#
# (C) Copyright 2000-2013
# Wolfgang Denk, DENX Software Engineering, wd@denx.de.
#
# SPDX-License-Identifier:	GPL-2.0+
#
#########################################################################

# This file is included from ./Makefile and spl/Makefile.
# Clean the state to avoid the same flags added twice.
#
# (Tegra needs different flags for SPL.
#  That's the reason why this file must be included from spl/Makefile too.
#  If we did not have Tegra SoCs, build system would be much simpler...)
PLATFORM_RELFLAGS :=
PLATFORM_CPPFLAGS :=
PLATFORM_LDFLAGS :=
LDFLAGS :=
LDFLAGS_FINAL :=
OBJCOPYFLAGS :=
# clear VENDOR for tcsh
VENDOR :=
#########################################################################

ARCH := $(CONFIG_SYS_ARCH:"%"=%)
CPU := $(CONFIG_SYS_CPU:"%"=%)
BOARD := $(CONFIG_SYS_BOARD:"%"=%)
ifneq ($(CONFIG_SYS_VENDOR),)
VENDOR := $(CONFIG_SYS_VENDOR:"%"=%)
endif
ifneq ($(CONFIG_SYS_SOC),)
SOC := $(CONFIG_SYS_SOC:"%"=%)
endif

# Some architecture config.mk files need to know what CPUDIR is set to,
# so calculate CPUDIR before including ARCH/SOC/CPU config.mk files.
# Check if arch/$ARCH/cpu/$CPU exists, otherwise assume arch/$ARCH/cpu contains
# CPU-specific code.
CPUDIR=arch/$(ARCH)/cpu$(if $(CPU),/$(CPU),)

sinclude $(srctree)/arch/$(ARCH)/config.mk	# include architecture dependend rules
sinclude $(srctree)/$(CPUDIR)/config.mk		# include  CPU	specific rules

ifdef	SOC
sinclude $(srctree)/$(CPUDIR)/$(SOC)/config.mk	# include  SoC	specific rules
endif
ifneq ($(BOARD),)
ifeq ($(CONFIG_SUPPORT_CUSTOMER_BOARD), y) #SUPPORT_CUSTOMER_BOARD
BOARDDIR = customer/board/$(BOARD)
else #SUPPORT_CUSTOMER_BOARD
ifdef	VENDOR
BOARDDIR = board/$(VENDOR)/$(BOARD)
else
BOARDDIR = board/$(BOARD)
endif
endif #SUPPORT_CUSTOMER_BOARD
endif
ifdef	BOARD
sinclude $(srctree)/$(BOARDDIR)/config.mk	# include board specific rules
endif

ifdef FTRACE
PLATFORM_CPPFLAGS += -finstrument-functions -DFTRACE
endif

# Allow use of stdint.h if available
ifneq ($(USE_STDINT),)
PLATFORM_CPPFLAGS += -DCONFIG_USE_STDINT
endif

#########################################################################

RELFLAGS := $(PLATFORM_RELFLAGS)

OBJCOPYFLAGS += --gap-fill=0xff

PLATFORM_CPPFLAGS += $(RELFLAGS)
PLATFORM_CPPFLAGS += -pipe

LDFLAGS += $(PLATFORM_LDFLAGS)
LDFLAGS_FINAL += -Bstatic

FIRMWARE_CPPFLAGS += -I$(buildsrc)/include
FIRMWARE_CPPFLAGS += -I$(buildsrc)/arch/$(ARCH)/include
FIRMWARE_CPPFLAGS += -I$(buildtree)/include2 -I$(buildtree)/include
FIRMWARE_CPPFLAGS += -include $(buildtree)/include/config.h
FIRMWARE_CPPFLAGS += -include $(buildtree)/include/generated/autoconf.h
FIRMWARE_CPPFLAGS += -include $(buildtree)/include/generated/version_autogenerated.h
FIRMWARE_CPPFLAGS += -fno-builtin -ffreestanding -nostdinc	\
	-isystem $(gccincdir) -pipe $(PLATFORM_CPPFLAGS)
FIRMWARE_CPPFLAGS += -I$(buildsrc)/board/$(BOARDDIR)/firmware

export FIRMWARE_CPPFLAGS
export PLATFORM_CPPFLAGS
export RELFLAGS
export LDFLAGS_FINAL
export CONFIG_STANDALONE_LOAD_ADDR
