/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2021 Amlogic, Inc. All rights reserved.
 */

#ifndef __VPP_DATA_HDR_H__
#define __VPP_DATA_HDR_H__

#define OO_BITS       (12)
#define OO_GAIN_SHIFT (3)
#define OO_NOR        (OO_BITS - OO_GAIN_SHIFT)

#define SIZE_CGAIN_LUT (65)
#define SIZE_EOTF_LUT  (143)
#define SIZE_OETF_LUT  (149)
#define SIZE_OOTF_LUT  (149)
#define SIZE_COEF_3X3  (9)
#define SIZE_OFFSET    (3)
#define SIZE_MTRX_COEF (16)
#define SIZE_EOTF_TBL  (33)
#define SIZE_OETF_TBL  (289)
#define SIZE_MAX_LUMA  (7)

struct hdr_proc_param_mtrx_s {
	int mtrx_only;
	int mtrx_in[SIZE_MTRX_COEF];
	int mtrx_gamut[SIZE_COEF_3X3];
	int ncl_prmy_panel[SIZE_COEF_3X3];
	int mtrx_gamut_mode;
	int mtrx_cgain[SIZE_MTRX_COEF];
	int mtrx_ogain[SIZE_MTRX_COEF];
	int mtrx_out[SIZE_MTRX_COEF];
	int mtrxi_pre_offset[SIZE_OFFSET];
	int mtrxi_pos_offset[SIZE_OFFSET];
	int mtrxo_pre_offset[SIZE_OFFSET];
	int mtrxo_pos_offset[SIZE_OFFSET];
	int mtrx_cgain_offset[SIZE_OFFSET];
	unsigned int mtrx_on;
	unsigned int gmt_bit_mode;
};

struct hdr_proc_param_lut_s {
	s64 eotf_lut[SIZE_EOTF_LUT];
	s64 oetf_lut[SIZE_OETF_LUT];
	s64 cgain_lut[SIZE_CGAIN_LUT];
	int ogain_lut[SIZE_OOTF_LUT];

	int ys_coef[3];
	unsigned int adp_scal_x_shift;
	unsigned int adp_scal_y_shift;

	unsigned int lut_on;
	unsigned int bitdepth;
	unsigned int cgain_en;
	unsigned int hist_en;
};

// sdr to hdr table  12bit
int data_cgain_lut0[SIZE_CGAIN_LUT] = {
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x4c0, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x40e,
	0x429, 0x444, 0x45f, 0x479, 0x492, 0x4ab, 0x4c3, 0x4db, 0x4f2,
	0x509, 0x520, 0x536, 0x54c, 0x561, 0x576, 0x58b, 0x59f, 0x5b3,
	0x5c0, 0x5d0, 0x5f2, 0x609, 0x620, 0x636, 0x64c, 0x661, 0x676,
	0x68b, 0x69f
};

// hdr10 to gamma lut 12bit (hdr to sdr)
int data_cgain_lut1[SIZE_CGAIN_LUT] = {
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x40e,
	0x419, 0x424, 0x43f, 0x449, 0x452, 0x46b, 0x473, 0x48b, 0x492,
	0x4a9, 0x4b0, 0x4c6, 0x4dc, 0x4e1, 0x4f6, 0x50b, 0x51f, 0x523,
	0x530, 0x540
};

// sdr to hdr 10bit (gamma to peak)
int data_cgain_lut2[SIZE_CGAIN_LUT] = {
	0xc00, 0xc00, 0xc00, 0xc00, 0xc00, 0xc00, 0xc00, 0xc00, 0xc00,
	0xc00, 0xc00, 0xc0e, 0xc79, 0xcdb, 0xd36, 0xd8b, 0xdda, 0xe25,
	0xe6b, 0xead, 0xeec, 0xf28, 0xf61, 0xf98, 0xfcc, 0xfff, 0x102f,
	0x105d, 0x108a, 0x10b5, 0x10df, 0x1107, 0x112e, 0x1154, 0x1178,
	0x119c, 0x11bf, 0x11e0, 0x1201, 0x1221, 0x1240, 0x125e, 0x127c,
	0x1299, 0x12b5, 0x12d1, 0x12ec, 0x1306, 0x1320, 0x1339, 0x1352,
	0x136b, 0x1383, 0x139a, 0x13b1, 0x13c7, 0x13de, 0x13f3, 0x1409,
	0x141e, 0x1432
};

int data_cgain_lut_bypass[SIZE_CGAIN_LUT] = {
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400
};

int data_eo_y_lut_hdr_def[SIZE_EOTF_LUT] = {
	1032192, 1032192, 1032192, 1032192, 16384, 16384, 16384, 16384,
	32768, 32768, 32768, 32768, 40960, 40960, 40960, 49152, 49152,
	73728, 86016, 94208, 100352, 104448, 108544, 112640, 117760, 123904,
	128000, 133632, 137728, 141824, 146944, 150272, 153344, 157440,
	161536, 165248, 167808, 170880, 174208, 177792, 181056, 183360,
	185792, 188480, 191552, 194880, 197536, 199520, 201696, 204128,
	206688, 209568, 212640, 214480, 216336, 218320, 220464, 222832,
	225360, 228112, 230248, 231864, 233608, 235496, 237544, 239752,
	242136, 244712, 246628, 248132, 249748, 251492, 253364, 255388,
	257564, 259908, 262290, 263646, 265106, 266678, 268366, 270182,
	272134, 274230, 276486, 278717, 280017, 281415, 282915, 284525,
	286255, 288113, 290107, 292247, 294545, 295961, 297284, 298705,
	300229, 301866, 303622, 305507, 307530, 309701, 311664, 312915,
	314257, 315698, 317246, 318907, 320690, 322605, 324662, 326871,
	328461, 329735, 331104, 332575, 334155, 335853, 337679, 339642,
	341752, 344021, 345263, 346576, 347989, 349509, 351145, 352907,
	354805, 356848, 359050, 360935, 362214, 363593, 365080, 366684,
	368414, 370283, 372300, 374478, 376832
};

int data_eo_y_lut_hdr[SIZE_EOTF_LUT] = {
	1032192, 1032192, 1032192, 1032192, 16384, 16384, 16384, 16384,
	32768, 32768, 32768, 32768, 40960, 40960, 40960, 49152, 49152,
	73728, 86016, 94208, 100352, 104448, 108544, 112640, 117760, 123904,
	128000, 133632, 137728, 141824, 146944, 150272, 153344, 157440,
	161536, 165248, 167808, 170880, 174208, 177792, 181056, 183360,
	185792, 188480, 191552, 194880, 197536, 199520, 201696, 204128,
	206688, 209568, 212640, 214480, 216336, 218320, 220464, 222832,
	225360, 228112, 230248, 231864, 233608, 235496, 237544, 239752,
	242136, 244712, 246628, 248132, 249748, 251492, 253364, 255388,
	257564, 259908, 262290, 263646, 265106, 266678, 268366, 270182,
	272134, 274230, 276486, 278717, 280017, 281415, 282915, 284525,
	286255, 288113, 290107, 292247, 294545, 295961, 297284, 298705,
	300229, 301866, 303622, 305507, 307530, 309701, 311664, 312915,
	314257, 315698, 317246, 318907, 320690, 322605, 324662, 326871,
	328461, 329735, 331104, 332575, 334155, 335853, 337679, 339642,
	341752, 344021, 345263, 346576, 347989, 349509, 351145, 352907,
	354805, 356848, 359050, 360935, 362214, 363593, 365080, 366684,
	368414, 370283, 372300, 374478, 376832
};

int data_eo_y_lut_hdr_10000[SIZE_EOTF_LUT] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7,
	8, 9, 10, 11, 12, 14, 15, 17, 18, 20, 22, 24, 26,
	29, 31, 34, 37, 41, 44, 48, 52, 57, 62, 67, 72, 78,
	85, 92, 99, 107, 116, 125, 135, 146, 158, 170, 183,
	198, 213, 229, 247, 266, 287, 309, 332, 357, 384, 413,
	445, 478, 514, 553, 594, 639, 686, 737, 792, 851, 915,
	983, 1056, 1134, 1219, 1309, 1406, 1511, 1623, 1744,
	1873, 2012, 2162, 2323, 2496, 2683, 2883, 3098, 3330,
	3580, 3849, 4138, 4450, 4786, 5148, 5539, 5959, 6413,
	6903, 7431, 8001, 8616, 9281, 10000
};

int data_eo_y_lut_pq_def[SIZE_EOTF_LUT] = {
	59392, 66560, 94208, 110592, 121984, 132160, 138816, 146432,
	151264, 156096, 161440, 165568, 168768, 172224, 175952, 179968,
	182240, 200680, 215102, 226400, 235271, 244625, 250984, 258029,
	264312, 269323, 275208, 280295, 284260, 288817, 294028, 297434,
	300794, 304586, 308851, 312465, 315139, 318120, 321437, 325119,
	328439, 330693, 333181, 335922, 338938, 342251, 344974, 346965,
	349143, 351524, 354124, 356960, 360050, 361931, 363762, 365751,
	367912, 370258, 372802, 375559, 377689, 379306, 381056, 382948,
	384994, 387204, 389591, 392167, 394081, 395581, 397197, 398940,
	400818, 402840, 405018, 407363, 409743, 411100, 412561, 414132,
	415820, 417636, 419588, 421685, 423939, 426172, 427472, 428869,
	430370, 431980, 433710, 435567, 437561, 439701, 441999, 443416,
	444740, 446160, 447685, 449321, 451078, 452962, 454986, 457157,
	459120, 460370, 461713, 463154, 464701, 466363, 468146, 470061,
	472118, 474326, 475917, 477191, 478560, 480031, 481611, 483309,
	485135, 487098, 489208, 491477, 492719, 494032, 495444, 496965,
	498601, 500363, 502261, 504304, 506506, 508391, 509670, 511049,
	512536, 514140, 515870, 517739, 519756, 521934, 524287
};

int data_eo_y_lut_pq[SIZE_EOTF_LUT] = {
	59392, 66560, 94208, 110592, 121984, 132160, 138816, 146432,
	151264, 156096, 161440, 165568, 168768, 172224, 175952, 179968,
	182240, 200680, 215102, 226400, 235271, 244625, 250984, 258029,
	264312, 269323, 275208, 280295, 284260, 288817, 294028, 297434,
	300794, 304586, 308851, 312465, 315139, 318120, 321437, 325119,
	328439, 330693, 333181, 335922, 338938, 342251, 344974, 346965,
	349143, 351524, 354124, 356960, 360050, 361931, 363762, 365751,
	367912, 370258, 372802, 375559, 377689, 379306, 381056, 382948,
	384994, 387204, 389591, 392167, 394081, 395581, 397197, 398940,
	400818, 402840, 405018, 407363, 409743, 411100, 412561, 414132,
	415820, 417636, 419588, 421685, 423939, 426172, 427472, 428869,
	430370, 431980, 433710, 435567, 437561, 439701, 441999, 443416,
	444740, 446160, 447685, 449321, 451078, 452962, 454986, 457157,
	459120, 460370, 461713, 463154, 464701, 466363, 468146, 470061,
	472118, 474326, 475917, 477191, 478560, 480031, 481611, 483309,
	485135, 487098, 489208, 491477, 492719, 494032, 495444, 496965,
	498601, 500363, 502261, 504304, 506506, 508391, 509670, 511049,
	512536, 514140, 515870, 517739, 519756, 521934, 524287
};

int data_eo_y_lut_hlg_23[SIZE_EOTF_LUT] = {
	1032192, 1032192, 1032192, 1032192, 16384, 16384, 16384, 16384,
	32768, 32768, 32768, 32768, 40960, 40960, 40960, 49152,
	49152, 73728, 185920, 197344, 204832, 213360, 218480, 224272,
	230072, 233656, 237576, 241848, 246108, 248580, 251228, 254044,
	257028, 260188, 262830, 264578, 266414, 268334, 270338, 272430,
	274606, 276866, 278871, 280087, 281345, 282647, 283991, 285377,
	286807, 288279, 289793, 291351, 292951, 294593, 295595, 296459,
	297344, 298251, 299179, 300128, 301099, 302091, 303104, 304139,
	305195, 306272, 307371, 308491, 309632, 310795, 311637, 312240,
	312853, 313477, 314112, 314757, 315413, 316080, 316757, 317455,
	318184, 318945, 319741, 320572, 321440, 322347, 323294, 324284,
	325318, 326398, 327526, 328192, 328808, 329451, 330123, 330825,
	331558, 332324, 333124, 333960, 334833, 335746, 336698, 337694,
	338734, 339820, 340955, 342141, 343379, 344368, 345044, 345750,
	346488, 347258, 348063, 348904, 349782, 350700, 351658, 352659,
	353705, 354798, 355940, 357132, 358378, 359679, 360743, 361453,
	362195, 362970, 363780, 364625, 365509, 366432, 367396, 368403,
	369455, 370554, 371703, 372902, 374155, 375464, 376832
};

int data_eo_y_lut_hlg[SIZE_EOTF_LUT] = {
	0, 169296, 202068, 221184, 234837, 246442, 253952, 262485, 267605,
	273408, 279210, 282794, 286720, 290986, 295253, 297728, 300373, 319488,
	333141, 344746, 352256, 360789, 365909, 371712, 377514, 381098, 385024,
	389290, 393557, 396032, 398677, 401493, 404480, 407637, 410282, 412032,
	413866, 415786, 417792, 419882, 422058, 424320, 426325, 427541, 428800,
	430101, 431445, 432832, 434261, 435733, 437248, 438805, 440405, 442048,
	443050, 443914, 444800, 445706, 446634, 447584, 448554, 449546, 450560,
	451594, 452650, 453728, 454826, 455946, 457088, 458250, 459093, 459696,
	460309, 460933, 461568, 462213, 462869, 463536, 464213, 464911, 465640,
	466401, 467197, 468028, 468896, 469803, 470750, 471740, 472774, 473854,
	474982, 475648, 476264, 476907, 477579, 478281, 479014, 479780, 480580,
	481416, 482289, 483201, 484154, 485150, 486190, 487276, 488411, 489597,
	490835, 491824, 492500, 493206, 493944, 494714, 495519, 496360, 497238,
	498156, 499114, 500115, 501161, 502254, 503396, 504588, 505834, 507135,
	508199, 508909, 509651, 510426, 511236, 512081, 512965, 513888, 514852,
	515859, 516911, 518010, 519158, 520358, 521611, 522920, 524287
};

int data_eo_y_lut_sdr[SIZE_EOTF_LUT] = {
	0, 163808, 199044, 219568, 234610, 247036, 255751, 264272, 270593,
	277939, 282430, 287163, 292441, 296593, 299792, 303278, 307054, 328697,
	344063, 354448, 364052, 372123, 379268, 384835, 391196, 395793, 399793,
	404214, 409063, 411973, 414834, 417919, 421229, 424767, 427260, 429261,
	431380, 433618, 435975, 438453, 441054, 443072, 444496, 445981, 447530,
	449142, 450817, 452556, 454360, 456229, 458163, 459457, 460489, 461555,
	462654, 463787, 464953, 466153, 467387, 468655, 469957, 471294, 472665,
	474071, 475324, 476062, 476817, 477590, 478381, 479190, 480016, 480861,
	481723, 482603, 483502, 484418, 485353, 486306, 487278, 488267, 489276,
	490302, 491348, 491966, 492507, 493057, 493618, 494187, 494766, 495354,
	495952, 496559, 497176, 497803, 498439, 499084, 499740, 500405, 501079,
	501764, 502458, 503161, 503875, 504598, 505332, 506075, 506828, 507590,
	508133, 508525, 508921, 509322, 509728, 510140, 510556, 510977, 511404,
	511835, 512272, 512713, 513160, 513611, 514068, 514530, 514997, 515469,
	515946, 516429, 516916, 517409, 517907, 518410, 518918, 519432, 519950,
	520474, 521003, 521537, 522077, 522622, 523172, 523727, 524287
};

int data_eo_y_lut_bypass[SIZE_EOTF_LUT] = {
	0, 360448, 376832, 385024, 393216, 397312, 401408, 405504, 409600,
	411648, 413696, 415744, 417792, 419840, 421888, 423936, 425984, 434176,
	442368, 446464, 450560, 454656, 458752, 460800, 462848, 464896, 466944,
	468992, 471040, 473088, 475136, 476160, 477184, 478208, 479232, 480256,
	481280, 482304, 483328, 484352, 485376, 486400, 487424, 488448, 489472,
	490496, 491520, 492032, 492544, 493056, 493568, 494080, 494592, 495104,
	495616, 496128, 496640, 497152, 497664, 498176, 498688, 499200, 499712,
	500224, 500736, 501248, 501760, 502272, 502784, 503296, 503808, 504320,
	504832, 505344, 505856, 506368, 506880, 507392, 507904, 508160, 508416,
	508672, 508928, 509184, 509440, 509696, 509952, 510208, 510464, 510720,
	510976, 511232, 511488, 511744, 512000, 512256, 512512, 512768, 513024,
	513280, 513536, 513792, 514048, 514304, 514560, 514816, 515072, 515328,
	515584, 515840, 516096, 516352, 516608, 516864, 517120, 517376, 517632,
	517888, 518144, 518400, 518656, 518912, 519168, 519424, 519680, 519936,
	520192, 520448, 520704, 520960, 521216, 521472, 521728, 521984, 522240,
	522496, 522752, 523008, 523264, 523520, 523776, 524032, 524287
};

int data_oe_y_lut_hdr[SIZE_OETF_LUT] = {
	0, 3, 5, 8, 12, 19, 28, 41, 60, 67, 74, 80, 85,
	96, 105, 113, 120, 134, 146, 157, 167, 184, 200, 214, 227, 250, 270,
	288, 304, 332, 357, 380, 400, 435, 465, 492, 517, 559, 595, 628, 656,
	706, 749, 787, 820, 850, 878, 903, 927, 949, 970, 989, 1008, 1042, 1073,
	1102, 1129, 1154, 1177, 1199, 1219, 1258, 1292, 1324, 1354, 1381, 1407,
	1431, 1453, 1495, 1533, 1568, 1600, 1630, 1657, 1683, 1708, 1753, 1794,
	1831, 1865, 1897, 1926, 1954, 1980, 2028, 2071, 2110, 2146, 2179, 2210,
	2239, 2267, 2317, 2361, 2402, 2440, 2474, 2506, 2536, 2564, 2616, 2662,
	2704, 2742, 2778, 2810, 2841, 2870, 2922, 2969, 3011, 3050, 3086, 3119,
	3150, 3179, 3231, 3278, 3321, 3360, 3396, 3429, 3459, 3488, 3540, 3587,
	3629, 3668, 3703, 3736, 3766, 3795, 3821, 3846, 3870, 3892, 3913, 3934,
	3953, 3971, 3989, 4006, 4022, 4038, 4053, 4068, 4082, 4095
};

int data_oe_y_lut_hlg[SIZE_OETF_LUT] = {
	0, 0, 0, 0, 1, 1, 2, 3, 4, 5, 6, 6, 6, 7, 8, 9,
	9, 10, 12, 12, 13, 15, 16, 18, 19, 21, 24, 25, 27, 30, 33, 36, 39,
	43, 48, 51, 55, 61, 67, 73, 78, 87, 96, 103, 110, 117, 123, 129, 135,
	141, 146, 151, 156, 166, 175, 183, 192, 199, 207, 214, 221, 235, 247,
	259, 271, 282, 293, 303, 313, 332, 350, 367, 384, 399, 414, 429, 443,
	470, 495, 519, 543, 565, 586, 607, 627, 665, 701, 735, 768, 799, 829,
	858, 886, 940, 991, 1039, 1086, 1130, 1173, 1214, 1254, 1330, 1402,
	1470, 1536, 1598, 1659, 1717, 1773, 1881, 1982, 2079, 2165, 2243,
	2313, 2377, 2436, 2541, 2633, 2714, 2788, 2855, 2916, 2972, 3025,
	3119, 3203, 3279, 3347, 3409, 3467, 3520, 3570, 3616, 3660, 3701,
	3740, 3778, 3813, 3847, 3879, 3910, 3939, 3968, 3995, 4022, 4047,
	4072, 4095
};

int data_oe_y_lut_sdr[SIZE_OETF_LUT] = {
	0, 0, 0, 1, 1, 2, 2, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 11, 12, 13,
	14, 15, 16, 18, 19, 21, 23, 24, 26, 29, 31, 34, 36, 40, 43, 46,
	49, 55, 59, 64, 68, 75, 81, 87, 93, 98, 103, 107, 112, 116, 120,
	124, 128, 135, 141, 147, 153, 159, 165, 170, 175, 185, 194, 202,
	210, 218, 226, 233, 240, 253, 266, 277, 289, 299, 309, 319, 329,
	347, 364, 380, 396, 410, 424, 438, 451, 476, 499, 521, 542, 562,
	582, 600, 618, 652, 684, 714, 743, 771, 797, 823, 847, 894, 938,
	979, 1019, 1056, 1093, 1127, 1161, 1225, 1285, 1342, 1396, 1448,
	1497, 1545, 1591, 1679, 1761, 1839, 1913, 1984, 2052, 2118, 2181,
	2301, 2414, 2520, 2622, 2719, 2812, 2902, 2989, 3072, 3153, 3231,
	3308, 3382, 3454, 3525, 3593, 3661, 3727, 3791, 3854, 3916, 3977,
	4037, 4095
};

int data_oe_y_lut_bypass[SIZE_OETF_LUT] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5,
	5, 6, 6, 7, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 20, 22, 24,
	26, 28, 30, 32, 36, 40, 44, 48, 52, 56, 60, 64, 72, 80, 88, 96,
	104, 112, 120, 128, 144, 160, 176, 192, 208, 224, 240, 256, 288,
	320, 352, 384, 416, 448, 480, 512, 576, 640, 704, 768, 832, 896,
	960, 1024, 1152, 1280, 1408, 1536, 1664, 1792, 1920, 2048, 2176,
	2304, 2432, 2560, 2688, 2816, 2944, 3072, 3200, 3328, 3456, 3584,
	3712, 3840, 3968, 4095
};

int data_oo_y_lut_hdr_hlg[SIZE_OOTF_LUT] = {
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 3983, 3703, 3469, 3270,
	3098, 2948, 2816, 2698, 2592, 2409, 2257, 2127, 2016, 1918,
	1832, 1755, 1686, 1567, 1468, 1384, 1311, 1248, 1192, 1142,
	1097, 1020, 955, 900, 853, 812, 775, 743, 714, 663,
	621, 586, 555, 528, 504, 483, 464, 431, 404, 381,
	361, 343, 328, 314, 302, 281, 263, 248, 235, 223,
	213, 204, 196, 189, 182, 176, 171, 166, 161, 157,
	152, 149, 145, 142, 139, 136, 133, 130, 128
};

int data_oo_y_lut_hdr_sdr_def[SIZE_OOTF_LUT] = {
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1532,
	1440, 1287, 1165, 1065, 982, 911, 850, 798, 752, 675,
	613, 563, 520, 484, 454, 427, 403, 364, 332, 306,
	283, 265, 248, 234, 221, 199, 182, 167, 154, 144,
	134, 126, 119, 113, 107, 102, 97, 93, 89, 86,
	82, 79, 77, 74, 72, 69, 67, 65, 64
};

int data_oo_y_lut_hdr_sdr[SIZE_OOTF_LUT] = {
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1532,
	1440, 1287, 1165, 1065, 982, 911, 850, 798, 752, 675,
	613, 563, 520, 484, 454, 427, 403, 364, 332, 306,
	283, 265, 248, 234, 221, 199, 182, 167, 154, 144,
	134, 126, 119, 113, 107, 102, 97, 93, 89, 86,
	82, 79, 77, 74, 72, 69, 67, 65, 64
};

int data_oo_y_lut_bypass[SIZE_OOTF_LUT] = {
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512
};

/* HDR map to 4000 gain=512*4000/10000, 512 as 1.0 */
int data_oo_y_lut_hdr_hdr_4000[SIZE_OOTF_LUT] = {
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205
};

/* HDR map to 2500 gain=512*2500/10000, 512 as 1.0 */
int data_oo_y_lut_hdr_hdr_2500[SIZE_OOTF_LUT] = {
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128
};

/* HDR map to 1200 gain=512*1200/10000, 512 as 1.0 */
int data_oo_y_lut_hdr_hdr_1200[SIZE_OOTF_LUT] = {
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61
};

int data_oo_y_lut_hlg_hdr[SIZE_OOTF_LUT] = {
	6, 10, 12, 13, 16, 18, 21, 24, 27, 29,
	30, 31, 32, 33, 34, 35, 36, 38, 39, 41,
	42, 44, 45, 47, 48, 50, 52, 54, 55, 58,
	60, 62, 64, 66, 69, 71, 73, 76, 79, 82,
	84, 88, 91, 94, 97, 99, 101, 103, 105, 106,
	108, 110, 111, 114, 116, 118, 120, 122, 124, 126,
	128, 131, 133, 136, 138, 141, 143, 145, 147, 150,
	153, 156, 159, 162, 164, 166, 168, 172, 176, 180,
	183, 186, 188, 191, 194, 198, 202, 206, 210, 213,
	216, 220, 222, 228, 233, 237, 241, 245, 249, 252,
	256, 262, 267, 272, 277, 282, 286, 290, 294, 301,
	307, 313, 318, 324, 328, 333, 337, 345, 353, 360,
	366, 372, 377, 383, 388, 397, 405, 413, 420, 427,
	433, 440, 445, 451, 456, 461, 466, 470, 475, 479,
	483, 487, 491, 494, 498, 502, 505, 508, 512
};

/* SDR convert to 310 gain=512*310/10000 lumin HDR, 512 as 1.0 */
int data_oo_y_lut_sdr_hdr[SIZE_OOTF_LUT] = {
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16
};

/* SDR convert to 80 gain=512*80/10000 lumin HDR, 512 as 1.0 */
int data_oo_y_lut_sdr_hdr_80[SIZE_OOTF_LUT] = {
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4
};

/* SDR convert to 250 gain=512*250/12000 lumin HDR, 512 as 1.0 */
int data_oo_y_lut_sdr_hdr_250[SIZE_OOTF_LUT] = {
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12
};

/* SDR convert to 310 gain=512*310/10000 lumin HDR, 512 as 1.0 */
int data_oo_y_lut_sdr_hdr_300[SIZE_OOTF_LUT] = {
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16
};

int data_oo_y_lut_hlg_sdr[SIZE_OOTF_LUT] = {
	790, 749, 739, 729, 719, 709, 699, 690, 681, 678,
	675, 673, 671, 669, 666, 664, 662, 659, 657, 655,
	653, 651, 648, 646, 645, 642, 639, 638, 636, 633,
	631, 629, 627, 625, 622, 620, 619, 616, 614, 612,
	610, 608, 606, 604, 602, 601, 600, 598, 597, 596,
	596, 595, 594, 593, 591, 590, 589, 588, 588, 587,
	586, 585, 583, 582, 581, 580, 580, 579, 578, 577,
	576, 575, 574, 573, 572, 571, 570, 569, 568, 567,
	566, 565, 564, 563, 563, 561, 560, 559, 558, 557,
	556, 556, 555, 554, 553, 552, 551, 550, 549, 548,
	548, 546, 545, 544, 543, 542, 542, 541, 540, 539,
	538, 537, 536, 535, 534, 533, 533, 532, 530, 529,
	529, 528, 527, 526, 526, 524, 523, 522, 521, 521,
	520, 519, 519, 518, 517, 517, 516, 516, 515, 515,
	514, 514, 514, 513, 513, 512, 512, 512, 512
};

int data_oo_y_lut_sdr_hlg[SIZE_OOTF_LUT] = {
	331, 349, 354, 359, 364, 369, 374, 379, 384, 386,
	387, 389, 390, 391, 393, 394, 395, 397, 398, 399,
	400, 402, 404, 405, 406, 408, 409, 410, 411, 413,
	415, 416, 417, 419, 420, 422, 423, 425, 426, 427,
	429, 430, 432, 433, 434, 435, 436, 437, 438, 439,
	439, 440, 440, 441, 442, 443, 444, 445, 445, 446,
	446, 447, 448, 449, 450, 451, 451, 452, 453, 454,
	455, 455, 456, 457, 458, 458, 459, 460, 461, 462,
	462, 463, 464, 464, 465, 466, 467, 468, 469, 469,
	470, 471, 471, 472, 473, 474, 475, 476, 477, 477,
	478, 479, 480, 481, 482, 482, 483, 484, 484, 486,
	487, 487, 488, 489, 490, 490, 491, 492, 493, 494,
	495, 496, 496, 497, 498, 499, 500, 501, 502, 503,
	503, 504, 505, 505, 506, 506, 507, 507, 508, 508,
	509, 509, 509, 510, 510, 511, 511, 511, 512
};

int data_oo_y_lut_ipt_sdr[SIZE_OOTF_LUT] = {
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 3983, 3703, 3469, 3270,
	3098, 2948, 2816, 2698, 2592, 2409, 2257, 2127, 2016, 1918,
	1832, 1755, 1686, 1567, 1468, 1384, 1311, 1248, 1192, 1142,
	1097, 1020, 955, 900, 853, 812, 775, 743, 714, 663,
	621, 586, 555, 528, 504, 483, 464, 431, 404, 381,
	361, 343, 328, 314, 302, 281, 263, 248, 235, 223,
	213, 204, 196, 189, 182, 176, 171, 166, 161, 157,
	152, 149, 145, 142, 139, 136, 133, 130, 64
};

/* gamut 3x3 matrix*/
/*int cl_2020_709[SIZE_COEF_3X3] = {-1775, 3867, -44, 3422, -1154, -220 ,-304, 43, 2309};*/
/*int cl_709_2020[SIZE_COEF_3X3] = {436, 1465, 148, 1285, 674, 89, 34, 180, 1834};*/
int data_ncl_709_2020[SIZE_COEF_3X3] = {1285, 674, 89, 142, 1883, 23, 34, 180, 1834};

/*standard 2020rgb->709rgb*/
int data_ncl_2020_709[SIZE_COEF_3X3] = {3401, -1204, -149, -255, 2320, -17, -37, -206, 2291};
/* dci-p3->709rgb*/
/*int ncl_2020_709[SIZE_COEF_3X3] = {2543, -459, -36, -88, 2133, 3, -41, -161, 2250};*/

/* standard2020->709-d65 8bit*/
int data_ncl_2020_709_8bit[SIZE_COEF_3X3] = {425, -150, -18, -31, 290, -2, -4, -25, 286};

/* standard2020->dcip3 8bit*/
int data_ncl_2020_p3dci[SIZE_COEF_3X3] = {368, -96, -16, -16, 275, -3, 1, -8, 263};

/* standard2020->d65p3 8bit*/
int data_ncl_2020_p3d65[SIZE_COEF_3X3] = {344, -72, -15, -16, 275, -2, 0, -5, 260};

/* primary->panel 8bit*/
int data_ncl_prmy_panel[SIZE_COEF_3X3] = {344, -72, -15, -16, 275, -2, 0, -5, 260};

/*for iptv special primary->709rgb*/
int data_ncl_sp_709[SIZE_COEF_3X3] = {2684, -489, -147, -201, 2266, -17, -29, -171, 2248};

/* gamut bypass */
int data_gamut_bypass_8bit[9] = {256, 0, 0, 0, 256, 0, 0, 0, 256};
int data_gamut_bypass[9] = {2048, 0, 0, 0, 2048, 0, 0, 0, 2048};

/* 1688, 2146,  262, */
/*  683, 2951,  462, */
/*   99,  309, 3688, */
/* 4096 as 1.0 */
int data_rgb2lms_ncl2020[SIZE_COEF_3X3] = {
	844, 1073, 131,
	342, 1475, 231,
	50, 154, 1844
};

/* ncl_709_2020 * rgb2lms_ncl2020 */
/* 606.133 1275.828 166.040 */
/* 320.411 1489.315 238.273 */
/* 72.384  320.413 1655.203 */
int data_rgb709_to_lms2020[SIZE_COEF_3X3] = {
	606, 1276, 166,
	321, 1489, 238,
	72, 320, 1656
};

/* 5ccf b0a4 028c */
/* ec83 26af fcce */
/* 002b fc5f 1375 */
/* 000c */
int data_lms2020_to_rgb709[SIZE_COEF_3X3] = {
	11879, -10158, 326,
	-2495, 4951, -409,
	21, -465, 2490
};

int data_lms2020_to_rgb709_div4[SIZE_COEF_3X3] = {
	2969, -2539, 81,
	-623, 1237, -102,
	5, -116, 622
};

/* Ys coeff, 1.0 = 1024 */
int data_ys_coef[SIZE_OFFSET] = {269, 694, 61};

/* matrix coef */
int data_rgb2yuvpre[SIZE_OFFSET] = {0, 0, 0};
int data_rgb2yuvpos[SIZE_OFFSET] = {64, 512, 512};

int data_yuv2rgbpre[SIZE_OFFSET] = {-64, -512, -512};
int data_yuv2rgbpos[SIZE_OFFSET] = {0, 0, 0};

int data_bypass_pre[SIZE_OFFSET] = {0, 0, 0};
int data_bypass_pos[SIZE_OFFSET] = {0, 0, 0};

int data_rgb2yuvfpre[SIZE_OFFSET] = {0, 0, 0};
int data_rgb2yuvfpos[SIZE_OFFSET] = {0, 512, 512};

int data_srgb2yuvfpre[SIZE_OFFSET] = {-64, -64, -64};
int data_srgb2yuvfpos[SIZE_OFFSET] = {0, 512, 512};

/*matrix coef BT709*/
int data_yuv2rgbmat[SIZE_MTRX_COEF] = {
	1197, 0, 0,
	1197, 1851, 0,
	1197, 0, 1163,
	1197, 2271, 0,
	1197, 0, 2011,
	0
};

int data_rgb2ycbcr[SIZE_MTRX_COEF] = {
	230, 594, 52,
	-125, -323,
	448, 448, -412,
	-36, 0, 0,
	0, 0, 0,
	0
};

int data_rgb2ycbcr_ncl2020[SIZE_MTRX_COEF] = {
	230, 594, 52,
	-125, -323, 448,
	448, -412, -36,
	0, 0, 0,
	0, 0, 0,
	0
};

int data_rgb2ycbcr_709[SIZE_MTRX_COEF] = {
	186, 627, 63,
	-103, -345, 448,
	448, -407, -41,
	0, 0, 0,
	0, 0, 0,
	0
};

int data_rgb2ycbcrf_709[SIZE_MTRX_COEF] = {
	218, 732, 74,
	-117, -393, 512,
	512, -464, -46,
	0, 0, 0,
	0, 0, 0,
	0
};

int data_srgb2ycbcrf_709[SIZE_MTRX_COEF] = {
	254, 853, 86,
	-137, -459, 596,
	596, -542, -55,
	0, 0, 0,
	0, 0, 0,
	0
};

int data_ycbcr2rgb_709[SIZE_MTRX_COEF]  = {
	1192, 0, 1836,
	1192, -217, -546,
	1192, 2166,
	0, 0, 0,
	0, 0, 0,
	0
};

int data_ycbcr2rgb_ncl2020[SIZE_MTRX_COEF] = {
	1197, 0, 1726,
	1197, -193, -669,
	1197, 2202, 0,
	0, 0, 0,
	0, 0, 0,
	0
};

int data_lms2ipt_ncl2020[SIZE_MTRX_COEF] = {
	410,    410,  204,
	2281, -2484,  203,
	413,    183, -596,
	0, 0, 0,
	0, 0, 0,
	0
};

/* 7fff 0c7c 1a45 */
/* 7fff f16d 110d */
/* 7fff 042d a95c */
/* 000f */
int data_ipt2lms_ncl2100[SIZE_MTRX_COEF] = {
	1024,  100,  210,
	1024, -117,  136,
	1024,   33, -694,
	0, 0, 0,
	0, 0, 0,
	0
};

int data_bypass_coeff[SIZE_MTRX_COEF] = {
	1024, 0, 0,
	0, 1024, 0,
	0, 0, 1024,
	0, 0, 0,
	0, 0, 0,
	0
};

int data_full2lmt_pre[SIZE_OFFSET] = {-0, -512, -512};
int data_full2lmt_pos[SIZE_OFFSET] = {0, 512, 512};
int data_full2lmt_coeff[SIZE_MTRX_COEF] = {
	1024, 0, 0,
	0, 512, 0,
	0, 0, 512,
	0, 0, 0,
	0, 0, 0,
	0
};

int data_srgb2rgb_pre[SIZE_OFFSET] = {-64, -64, -64};
int data_srgb2rgb_pos[SIZE_OFFSET] = {0, 0, 0};
int data_srgb2rgb_coeff[SIZE_MTRX_COEF] = {
	1192, 0, 0,
	0, 1192, 0,
	0, 0, 1192,
	0, 0, 0,
	0, 0, 0,
	0
};

int data_prmy_maxl[SIZE_MAX_LUMA] = {
	1200, 2000, 3000, 5000, 7000, 9000, 10000
};

/*1024 as 1.0*/
int data_margin_maxl[SIZE_MAX_LUMA] = {
	560, 384, 256, 128, 64, 16, 8
};

/*hdr eotf & oetf curve setting*/
/*panel from 260nit to 1000nit*/
/*
 *matlab parameters:
 *% default setting for TV:
 *panel_lum_max = 260; % nits, maximum panel luminance (260~1000)
 *alpha_low = 0.075;    % 0: no dark boost; otherwise add dark boost
 *panel_gamma = 2.2; % panel gamma 1.8, 2.0, 2.2, ...

 *osd_merge_lut = 1; % whether merge osd
 *eo/oe lut to solve table resolution issue

 *src_lum_max = 10000;  % nits, maximum of 10000 nits
 *dsp_lum_max = 10000;   % nits, maximum luma of display luminance
 *panel_lum_max = min(1000, panel_lum_max);
 *panel_lum_max = max(100, panel_lum_max)
 *panel_soft_clip_th = 912;
 *hlg_lum_max = 1200;  % nits, use HLG curve instead of 709 gamma
 *lum_norm = 10000;    % nits, 2084 maximum lum
 *eotf_scl = 2^(floor(log2(10000/panel_lum_max))-1)
 *% to increase precision could be 1,2,4,8,16
 *eo_scale = 1;     % eotf scale
 *eotf_norm = (2^14)*eo_scale ;  % 14bit(16384)=1.0; 15bit(32768)=1.0
 *fact_scl = 1 / eo_scale;      % min(max(1,src_lum_max/dsp_lum_max),4);
 *% factors to be applied to linear RGB before going to LUT289
 *oetf_norm = (2^14); % oetf normalization
 *oetf_scl = max(1,hlg_lum_max/100); % 1200
 *blx_soft = 0;        % 0: means not black soft clipping;
 *otherwise soft clipping, e.g. 2*4
 */
unsigned int data_eotf_33_2084_table[][SIZE_EOTF_TBL] = {
	{/*260*/
	    0,     4,     9,    16,    27,    43,    66,   101,
	  149,   219,   315,   449,   644,   911,  1273,  1762,
	 2418,  3297,  4468,  6028,  8100, 10851, 14501, 14938,
	15304, 15605, 15847, 16035, 16176, 16276, 16339, 16373,
	16383
	},
	{/*280*/
	    0,     4,     9,    16,    27,    43,    66,   101,
	  149,   219,   315,   449,   644,   911,  1273,  1762,
	 2418,  3297,  4468,  6028,  8100, 10851, 14501, 14938,
	15304, 15605, 15847, 16035, 16176, 16276, 16339, 16373,
	16383
	},
	{/*300*/
	    0,     4,     9,    16,    27,    43,    66,   101,
	  149,   219,   315,   449,   644,   911,  1273,  1762,
	 2418,  3297,  4468,  6028,  8100, 10851, 14501, 14938,
	15304, 15605, 15847, 16035, 16176, 16276, 16339, 16373,
	16383
	},
	{/*320*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*340*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*360*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*380*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*400*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*420*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*440*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*460*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*480*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*500*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*600*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*700*/
	    0,     2,     5,     8,    12,    18,    25,    35,
	   49,    68,    93,   128,   175,   239,   325,   440,
	  605,   824,  1117,  1507,  2025,  2713,  3625,  4836,
	 6445,  8583, 11430, 15228, 15695, 16025, 16237, 16350,
	16383
	},
	{/*800*/
	    0,     2,     5,     8,    12,    18,    25,    35,
	   49,    68,    93,   128,   175,   239,   325,   440,
	  605,   824,  1117,  1507,  2025,  2713,  3625,  4836,
	 6445,  8583, 11430, 15228, 15695, 16025, 16237, 16350,
	16383
	},
	{/*900*/
	    0,     2,     5,     8,    12,    18,    25,    35,
	   49,    68,    93,   128,   175,   239,   325,   440,
	  605,   824,  1117,  1507,  2025,  2713,  3625,  4836,
	 6445,  8583, 11430, 15228, 15695, 16025, 16237, 16350,
	16383
	},
	{/*1000*/
	    0,     2,     5,     8,    12,    18,    25,    35,
	   49,    68,    93,   128,   175,   239,   325,   440,
	  605,   824,  1117,  1507,  2025,  2713,  3625,  4836,
	 6445,  8583, 11430, 15228, 15695, 16025, 16237, 16350,
	16383
	}
};

unsigned int data_oetf_289_gamma22_table[][SIZE_OETF_TBL] = {
	{/*260*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  125,  169,  202,  230,  255,  278,  297,
	 316,  333,  349,  364,  379,  393,  407,  420,
	 433,  445,  457,  468,  479,  489,  500,  510,
	 520,  530,  539,  549,  558,  567,  576,  585,
	 593,  602,  610,  618,  626,  634,  642,  649,
	 657,  664,  671,  678,  686,  693,  701,  708,
	 716,  724,  732,  739,  747,  755,  762,  769,
	 776,  782,  789,  794,  800,  805,  809,  813,
	 816,  819,  821,  823,  826,  828,  830,  832,
	 834,  836,  839,  841,  843,  845,  847,  849,
	 851,  853,  855,  857,  859,  861,  863,  865,
	 867,  869,  871,  873,  875,  877,  879,  880,
	 882,  884,  886,  888,  890,  891,  893,  895,
	 897,  898,  900,  902,  903,  905,  907,  908,
	 910,  912,  913,  915,  916,  918,  920,  921,
	 923,  924,  926,  927,  929,  930,  932,  933,
	 935,  936,  937,  939,  940,  942,  943,  944,
	 946,  947,  948,  950,  951,  952,  953,  955,
	 956,  957,  958,  960,  961,  962,  963,  964,
	 965,  967,  968,  969,  970,  971,  972,  973,
	 974,  975,  976,  977,  978,  979,  980,  981,
	 982,  983,  984,  985,  986,  987,  988,  989,
	 989,  990,  991,  992,  993,  994,  994,  995,
	 996,  997,  997,  998,  999, 1000, 1000, 1001,
	1002, 1002, 1003, 1004, 1004, 1005, 1006, 1006,
	1007, 1007, 1008, 1009, 1009, 1010, 1010, 1011,
	1011, 1012, 1012, 1013, 1013, 1014, 1014, 1014,
	1015, 1015, 1016, 1016, 1016, 1017, 1017, 1017,
	1018, 1018, 1018, 1019, 1019, 1019, 1020, 1020,
	1020, 1020, 1021, 1021, 1021, 1021, 1021, 1022,
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*280*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  121,  163,  195,  222,  247,  268,  287,
	 305,  322,  337,  352,  367,  380,  393,  406,
	 418,  430,  441,  452,  463,  473,  483,  493,
	 502,  512,  521,  530,  539,  548,  557,  565,
	 573,  582,  589,  597,  605,  612,  620,  627,
	 634,  641,  648,  655,  662,  669,  677,  684,
	 692,  699,  707,  714,  721,  729,  736,  742,
	 749,  755,  761,  767,  772,  777,  782,  786,
	 789,  792,  794,  797,  799,  802,  804,  806,
	 809,  811,  813,  816,  818,  820,  823,  825,
	 827,  829,  832,  834,  836,  838,  841,  843,
	 845,  847,  849,  851,  853,  855,  858,  860,
	 862,  864,  866,  868,  870,  872,  874,  876,
	 878,  880,  881,  883,  885,  887,  889,  891,
	 893,  895,  896,  898,  900,  902,  903,  905,
	 907,  909,  910,  912,  914,  915,  917,  919,
	 920,  922,  924,  925,  927,  928,  930,  931,
	 933,  934,  936,  937,  939,  940,  942,  943,
	 945,  946,  947,  949,  950,  952,  953,  954,
	 956,  957,  958,  959,  961,  962,  963,  964,
	 966,  967,  968,  969,  970,  971,  973,  974,
	 975,  976,  977,  978,  979,  980,  981,  982,
	 983,  984,  985,  986,  987,  988,  989,  990,
	 991,  992,  993,  993,  994,  995,  996,  997,
	 998,  998,  999, 1000, 1001, 1001, 1002, 1003,
	1004, 1004, 1005, 1006, 1006, 1007, 1008, 1008,
	1009, 1009, 1010, 1011, 1011, 1012, 1012, 1013,
	1013, 1014, 1014, 1015, 1015, 1015, 1016, 1016,
	1017, 1017, 1017, 1018, 1018, 1019, 1019, 1019,
	1019, 1020, 1020, 1020, 1021, 1021, 1021, 1021,
	1021, 1022, 1022, 1022, 1022, 1022, 1022, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*300*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  117,  158,  189,  216,  239,  260,  278,
	 295,  311,  327,  341,  355,  368,  381,  393,
	 405,  417,  428,  438,  449,  458,  468,  478,
	 487,  496,  505,  514,  523,  531,  539,  548,
	 556,  563,  571,  579,  586,  594,  601,  608,
	 615,  622,  628,  635,  642,  648,  655,  661,
	 667,  674,  680,  686,  692,  698,  704,  710,
	 716,  722,  728,  733,  739,  745,  750,  756,
	 761,  767,  772,  778,  783,  789,  795,  801,
	 807,  813,  819,  825,  831,  836,  842,  848,
	 854,  859,  864,  869,  874,  879,  884,  888,
	 892,  895,  899,  902,  905,  907,  909,  910,
	 912,  913,  915,  916,  918,  919,  921,  922,
	 923,  925,  926,  927,  929,  930,  931,  933,
	 934,  935,  937,  938,  939,  940,  942,  943,
	 944,  945,  946,  948,  949,  950,  951,  952,
	 953,  955,  956,  957,  958,  959,  960,  961,
	 962,  963,  964,  965,  966,  967,  968,  969,
	 970,  971,  972,  973,  974,  975,  976,  977,
	 978,  979,  980,  980,  981,  982,  983,  984,
	 985,  986,  986,  987,  988,  989,  990,  990,
	 991,  992,  993,  993,  994,  995,  995,  996,
	 997,  997,  998,  999,  999, 1000, 1001, 1001,
	1002, 1002, 1003, 1004, 1004, 1005, 1005, 1006,
	1006, 1007, 1007, 1008, 1008, 1009, 1009, 1010,
	1010, 1011, 1011, 1012, 1012, 1013, 1013, 1013,
	1014, 1014, 1015, 1015, 1015, 1016, 1016, 1016,
	1017, 1017, 1017, 1018, 1018, 1018, 1018, 1019,
	1019, 1019, 1019, 1020, 1020, 1020, 1020, 1021,
	1021, 1021, 1021, 1021, 1021, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1022, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*320*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  153,  209,  252,  287,  317,  345,  370,
	 394,  416,  436,  455,  474,  491,  508,  524,
	 540,  555,  569,  584,  597,  611,  623,  636,
	 648,  661,  672,  684,  696,  707,  718,  729,
	 739,  750,  761,  772,  784,  796,  808,  820,
	 831,  841,  851,  860,  868,  874,  879,  882,
	 884,  886,  887,  889,  891,  892,  894,  895,
	 897,  899,  900,  902,  903,  905,  906,  908,
	 909,  911,  912,  913,  915,  916,  918,  919,
	 920,  922,  923,  924,  926,  927,  928,  930,
	 931,  932,  934,  935,  936,  937,  938,  940,
	 941,  942,  943,  944,  946,  947,  948,  949,
	 950,  951,  952,  953,  954,  955,  956,  958,
	 959,  960,  961,  962,  963,  964,  965,  965,
	 966,  967,  968,  969,  970,  971,  972,  973,
	 974,  975,  975,  976,  977,  978,  979,  979,
	 980,  981,  982,  983,  983,  984,  985,  986,
	 986,  987,  988,  988,  989,  990,  990,  991,
	 992,  992,  993,  994,  994,  995,  996,  996,
	 997,  997,  998,  998,  999, 1000, 1000, 1001,
	1001, 1002, 1002, 1003, 1003, 1004, 1004, 1005,
	1005, 1006, 1006, 1006, 1007, 1007, 1008, 1008,
	1009, 1009, 1009, 1010, 1010, 1011, 1011, 1011,
	1012, 1012, 1012, 1013, 1013, 1013, 1014, 1014,
	1014, 1015, 1015, 1015, 1015, 1016, 1016, 1016,
	1017, 1017, 1017, 1017, 1017, 1018, 1018, 1018,
	1018, 1019, 1019, 1019, 1019, 1019, 1020, 1020,
	1020, 1020, 1020, 1020, 1021, 1021, 1021, 1021,
	1021, 1021, 1021, 1021, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*340*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  149,  204,  245,  279,  309,  335,  360,
	 383,  404,  424,  442,  460,  477,  494,  510,
	 525,  539,  554,  567,  581,  594,  606,  619,
	 631,  642,  654,  666,  677,  688,  699,  709,
	 719,  730,  740,  751,  763,  774,  786,  797,
	 808,  818,  827,  836,  844,  850,  855,  858,
	 860,  862,  864,  866,  868,  870,  871,  873,
	 875,  877,  879,  880,  882,  884,  886,  887,
	 889,  891,  892,  894,  896,  897,  899,  900,
	 902,  904,  905,  907,  908,  910,  911,  913,
	 914,  916,  917,  919,  920,  921,  923,  924,
	 926,  927,  928,  930,  931,  932,  934,  935,
	 936,  938,  939,  940,  941,  943,  944,  945,
	 946,  947,  949,  950,  951,  952,  953,  954,
	 955,  956,  957,  959,  960,  961,  962,  963,
	 964,  965,  966,  967,  968,  969,  970,  971,
	 972,  972,  973,  974,  975,  976,  977,  978,
	 979,  980,  980,  981,  982,  983,  984,  984,
	 985,  986,  987,  987,  988,  989,  990,  990,
	 991,  992,  992,  993,  994,  994,  995,  996,
	 996,  997,  998,  998,  999,  999, 1000, 1001,
	1001, 1002, 1002, 1003, 1003, 1004, 1004, 1005,
	1005, 1006, 1006, 1007, 1007, 1008, 1008, 1009,
	1009, 1009, 1010, 1010, 1011, 1011, 1011, 1012,
	1012, 1013, 1013, 1013, 1014, 1014, 1014, 1015,
	1015, 1015, 1016, 1016, 1016, 1016, 1017, 1017,
	1017, 1017, 1018, 1018, 1018, 1018, 1019, 1019,
	1019, 1019, 1019, 1020, 1020, 1020, 1020, 1020,
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1022,
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*360*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  145,  198,  240,  272,  301,  327,  350,
	 373,  394,  413,  432,  449,  466,  482,  497,
	 512,  526,  540,  553,  566,  579,  591,  603,
	 615,  626,  637,  648,  659,  670,  680,  691,
	 701,  711,  721,  732,  743,  754,  765,  776,
	 786,  796,  806,  814,  821,  828,  833,  836,
	 838,  840,  843,  845,  847,  849,  851,  853,
	 855,  857,  859,  861,  863,  865,  866,  868,
	 870,  872,  874,  876,  878,  879,  881,  883,
	 885,  887,  888,  890,  892,  893,  895,  897,
	 899,  900,  902,  903,  905,  907,  908,  910,
	 911,  913,  914,  916,  917,  919,  920,  922,
	 923,  925,  926,  928,  929,  930,  932,  933,
	 934,  936,  937,  938,  940,  941,  942,  944,
	 945,  946,  947,  948,  950,  951,  952,  953,
	 954,  956,  957,  958,  959,  960,  961,  962,
	 963,  964,  965,  966,  967,  968,  969,  970,
	 971,  972,  973,  974,  975,  976,  977,  978,
	 979,  980,  981,  981,  982,  983,  984,  985,
	 986,  986,  987,  988,  989,  989,  990,  991,
	 992,  992,  993,  994,  994,  995,  996,  997,
	 997,  998,  998,  999, 1000, 1000, 1001, 1001,
	1002, 1003, 1003, 1004, 1004, 1005, 1005, 1006,
	1006, 1007, 1007, 1008, 1008, 1009, 1009, 1010,
	1010, 1011, 1011, 1011, 1012, 1012, 1013, 1013,
	1013, 1014, 1014, 1014, 1015, 1015, 1015, 1016,
	1016, 1016, 1017, 1017, 1017, 1017, 1018, 1018,
	1018, 1019, 1019, 1019, 1019, 1019, 1020, 1020,
	1020, 1020, 1020, 1021, 1021, 1021, 1021, 1021,
	1021, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*380*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  142,  194,  233,  265,  293,  319,  343,
	 365,  385,  403,  421,  438,  454,  469,  484,
	 499,  513,  527,  540,  553,  565,  577,  588,
	 600,  611,  622,  633,  643,  654,  664,  674,
	 684,  693,  704,  714,  725,  736,  746,  757,
	 767,  777,  786,  794,  801,  808,  813,  816,
	 818,  821,  823,  825,  828,  830,  832,  834,
	 836,  838,  841,  843,  845,  847,  849,  851,
	 853,  855,  857,  859,  861,  863,  865,  867,
	 869,  871,  873,  875,  877,  879,  880,  882,
	 884,  886,  888,  889,  891,  893,  895,  896,
	 898,  900,  901,  903,  905,  906,  908,  910,
	 911,  913,  914,  916,  917,  919,  921,  922,
	 923,  925,  926,  928,  929,  931,  932,  934,
	 935,  936,  938,  939,  940,  942,  943,  944,
	 946,  947,  948,  949,  951,  952,  953,  954,
	 955,  957,  958,  959,  960,  961,  962,  963,
	 964,  966,  967,  968,  969,  970,  971,  972,
	 973,  974,  975,  976,  977,  978,  978,  979,
	 980,  981,  982,  983,  984,  985,  986,  986,
	 987,  988,  989,  990,  990,  991,  992,  993,
	 993,  994,  995,  996,  996,  997,  998,  998,
	 999, 1000, 1000, 1001, 1001, 1002, 1003, 1003,
	1004, 1004, 1005, 1005, 1006, 1007, 1007, 1008,
	1008, 1009, 1009, 1010, 1010, 1010, 1011, 1011,
	1012, 1012, 1013, 1013, 1013, 1014, 1014, 1015,
	1015, 1015, 1016, 1016, 1016, 1017, 1017, 1017,
	1017, 1018, 1018, 1018, 1019, 1019, 1019, 1019,
	1020, 1020, 1020, 1020, 1020, 1021, 1021, 1021,
	1021, 1021, 1021, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*400*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  139,  189,  228,  259,  287,  312,  334,
	 356,  375,  394,  411,  427,  443,  458,  473,
	 487,  501,  514,  527,  540,  552,  564,  575,
	 586,  597,  608,  618,  629,  639,  649,  658,
	 668,  677,  687,  697,  708,  718,  729,  739,
	 749,  758,  767,  775,  782,  788,  793,  797,
	 800,  802,  804,  807,  809,  812,  814,  816,
	 819,  821,  823,  826,  828,  830,  832,  835,
	 837,  839,  841,  843,  845,  848,  850,  852,
	 854,  856,  858,  860,  862,  864,  866,  868,
	 870,  872,  874,  876,  878,  880,  882,  883,
	 885,  887,  889,  891,  892,  894,  896,  898,
	 899,  901,  903,  905,  906,  908,  910,  911,
	 913,  914,  916,  918,  919,  921,  922,  924,
	 925,  927,  928,  930,  931,  933,  934,  935,
	 937,  938,  940,  941,  942,  944,  945,  946,
	 948,  949,  950,  951,  953,  954,  955,  956,
	 958,  959,  960,  961,  962,  963,  964,  966,
	 967,  968,  969,  970,  971,  972,  973,  974,
	 975,  976,  977,  978,  979,  980,  981,  982,
	 983,  984,  984,  985,  986,  987,  988,  989,
	 990,  990,  991,  992,  993,  993,  994,  995,
	 996,  996,  997,  998,  999,  999, 1000, 1001,
	1001, 1002, 1002, 1003, 1004, 1004, 1005, 1005,
	1006, 1007, 1007, 1008, 1008, 1009, 1009, 1010,
	1010, 1011, 1011, 1012, 1012, 1012, 1013, 1013,
	1014, 1014, 1014, 1015, 1015, 1016, 1016, 1016,
	1017, 1017, 1017, 1018, 1018, 1018, 1018, 1019,
	1019, 1019, 1019, 1020, 1020, 1020, 1020, 1021,
	1021, 1021, 1021, 1021, 1021, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1022, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*420*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  135,  185,  222,  253,  280,  305,  327,
	 348,  368,  385,  402,  418,  434,  449,  463,
	 477,  490,  503,  516,  528,  539,  550,  562,
	 572,  583,  594,  604,  614,  624,  634,  644,
	 653,  662,  672,  682,  692,  702,  713,  723,
	 732,  741,  750,  758,  765,  771,  776,  780,
	 783,  785,  788,  790,  793,  795,  798,  800,
	 803,  805,  808,  810,  813,  815,  817,  820,
	 822,  824,  827,  829,  831,  834,  836,  838,
	 840,  842,  845,  847,  849,  851,  853,  855,
	 857,  859,  862,  864,  866,  868,  870,  872,
	 874,  876,  877,  879,  881,  883,  885,  887,
	 889,  891,  892,  894,  896,  898,  900,  901,
	 903,  905,  907,  908,  910,  912,  913,  915,
	 916,  918,  920,  921,  923,  924,  926,  927,
	 929,  930,  932,  933,  935,  936,  938,  939,
	 941,  942,  943,  945,  946,  947,  949,  950,
	 951,  953,  954,  955,  956,  958,  959,  960,
	 961,  962,  964,  965,  966,  967,  968,  969,
	 970,  971,  972,  973,  975,  976,  977,  978,
	 979,  980,  980,  981,  982,  983,  984,  985,
	 986,  987,  988,  989,  990,  990,  991,  992,
	 993,  994,  994,  995,  996,  997,  997,  998,
	 999, 1000, 1000, 1001, 1002, 1002, 1003, 1003,
	1004, 1005, 1005, 1006, 1006, 1007, 1008, 1008,
	1009, 1009, 1010, 1010, 1011, 1011, 1012, 1012,
	1013, 1013, 1013, 1014, 1014, 1015, 1015, 1015,
	1016, 1016, 1017, 1017, 1017, 1018, 1018, 1018,
	1018, 1019, 1019, 1019, 1020, 1020, 1020, 1020,
	1020, 1021, 1021, 1021, 1021, 1021, 1022, 1022,
	1022, 1022, 1022, 1022, 1022, 1022, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*440*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  133,  182,  219,  249,  275,  298,  320,
	 340,  360,  377,  394,  410,  425,  440,  454,
	 467,  480,  493,  505,  517,  528,  539,  550,
	 561,  572,  582,  592,  602,  612,  621,  631,
	 640,  649,  658,  667,  675,  684,  692,  700,
	 708,  716,  724,  731,  739,  747,  754,  761,
	 769,  776,  784,  793,  801,  809,  818,  826,
	 834,  842,  850,  858,  865,  872,  878,  884,
	 889,  894,  898,  901,  903,  905,  906,  908,
	 909,  911,  912,  913,  915,  916,  918,  919,
	 920,  922,  923,  924,  926,  927,  928,  930,
	 931,  932,  933,  935,  936,  937,  938,  939,
	 941,  942,  943,  944,  945,  946,  948,  949,
	 950,  951,  952,  953,  954,  955,  956,  957,
	 958,  959,  960,  961,  962,  963,  964,  965,
	 966,  967,  968,  969,  970,  971,  972,  973,
	 973,  974,  975,  976,  977,  978,  979,  979,
	 980,  981,  982,  983,  983,  984,  985,  986,
	 986,  987,  988,  988,  989,  990,  991,  991,
	 992,  993,  993,  994,  994,  995,  996,  996,
	 997,  998,  998,  999,  999, 1000, 1000, 1001,
	1001, 1002, 1003, 1003, 1004, 1004, 1005, 1005,
	1006, 1006, 1006, 1007, 1007, 1008, 1008, 1009,
	1009, 1010, 1010, 1010, 1011, 1011, 1011, 1012,
	1012, 1013, 1013, 1013, 1014, 1014, 1014, 1015,
	1015, 1015, 1016, 1016, 1016, 1016, 1017, 1017,
	1017, 1017, 1018, 1018, 1018, 1018, 1019, 1019,
	1019, 1019, 1019, 1020, 1020, 1020, 1020, 1020,
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1022,
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*460*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  130,  177,  214,  243,  269,  293,  314,
	 334,  353,  370,  386,  402,  416,  430,  444,
	 457,  470,  482,  494,  506,  517,  528,  539,
	 549,  560,  570,  580,  590,  599,  609,  618,
	 627,  636,  645,  653,  662,  670,  678,  686,
	 694,  702,  709,  717,  725,  732,  739,  746,
	 754,  761,  769,  777,  785,  793,  801,  809,
	 817,  825,  833,  840,  847,  854,  860,  866,
	 871,  875,  879,  883,  885,  887,  889,  890,
	 892,  893,  895,  897,  898,  900,  901,  903,
	 904,  906,  907,  909,  910,  912,  913,  915,
	 916,  918,  919,  921,  922,  923,  925,  926,
	 927,  929,  930,  931,  933,  934,  935,  937,
	 938,  939,  940,  941,  943,  944,  945,  946,
	 947,  949,  950,  951,  952,  953,  954,  955,
	 956,  958,  959,  960,  961,  962,  963,  964,
	 965,  966,  967,  968,  969,  970,  971,  972,
	 973,  973,  974,  975,  976,  977,  978,  979,
	 980,  980,  981,  982,  983,  984,  985,  985,
	 986,  987,  988,  988,  989,  990,  991,  991,
	 992,  993,  993,  994,  995,  995,  996,  997,
	 997,  998,  999,  999, 1000, 1000, 1001, 1002,
	1002, 1003, 1003, 1004, 1004, 1005, 1005, 1006,
	1006, 1007, 1007, 1008, 1008, 1009, 1009, 1010,
	1010, 1010, 1011, 1011, 1012, 1012, 1012, 1013,
	1013, 1014, 1014, 1014, 1015, 1015, 1015, 1016,
	1016, 1016, 1017, 1017, 1017, 1017, 1018, 1018,
	1018, 1018, 1019, 1019, 1019, 1019, 1020, 1020,
	1020, 1020, 1020, 1021, 1021, 1021, 1021, 1021,
	1021, 1021, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*480*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  128,  174,  210,  239,  264,  287,  308,
	 327,  345,  362,  378,  393,  408,  422,  435,
	 448,  461,  473,  485,  496,  507,  518,  529,
	 539,  549,  559,  569,  579,  588,  597,  606,
	 615,  624,  632,  641,  649,  657,  665,  673,
	 681,  689,  696,  704,  711,  718,  725,  733,
	 740,  747,  754,  762,  770,  778,  786,  794,
	 801,  809,  816,  823,  830,  837,  843,  849,
	 854,  858,  862,  865,  868,  870,  872,  874,
	 875,  877,  879,  881,  882,  884,  886,  888,
	 889,  891,  893,  894,  896,  897,  899,  901,
	 902,  904,  905,  907,  909,  910,  912,  913,
	 915,  916,  918,  919,  920,  922,  923,  925,
	 926,  928,  929,  930,  932,  933,  934,  936,
	 937,  938,  940,  941,  942,  943,  945,  946,
	 947,  948,  949,  951,  952,  953,  954,  955,
	 956,  958,  959,  960,  961,  962,  963,  964,
	 965,  966,  967,  968,  969,  970,  971,  972,
	 973,  974,  975,  976,  977,  978,  979,  980,
	 980,  981,  982,  983,  984,  985,  985,  986,
	 987,  988,  989,  989,  990,  991,  992,  992,
	 993,  994,  995,  995,  996,  997,  997,  998,
	 999,  999, 1000, 1001, 1001, 1002, 1002, 1003,
	1003, 1004, 1005, 1005, 1006, 1006, 1007, 1007,
	1008, 1008, 1009, 1009, 1010, 1010, 1011, 1011,
	1011, 1012, 1012, 1013, 1013, 1013, 1014, 1014,
	1015, 1015, 1015, 1016, 1016, 1016, 1017, 1017,
	1017, 1018, 1018, 1018, 1018, 1019, 1019, 1019,
	1019, 1020, 1020, 1020, 1020, 1020, 1021, 1021,
	1021, 1021, 1021, 1021, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*500*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  125,  171,  206,  235,  259,  281,  302,
	 321,  339,  356,  371,  386,  401,  414,  427,
	 440,  453,  465,  476,  488,  498,  509,  519,
	 529,  539,  549,  558,  568,  577,  586,  595,
	 603,  612,  620,  628,  637,  645,  652,  660,
	 668,  675,  683,  690,  697,  705,  712,  719,
	 726,  733,  740,  748,  755,  763,  771,  778,
	 786,  793,  801,  808,  814,  821,  827,  832,
	 837,  842,  846,  849,  852,  854,  856,  858,
	 860,  862,  864,  866,  867,  869,  871,  873,
	 875,  877,  879,  880,  882,  884,  886,  887,
	 889,  891,  893,  894,  896,  898,  899,  901,
	 902,  904,  906,  907,  909,  910,  912,  914,
	 915,  917,  918,  920,  921,  923,  924,  925,
	 927,  928,  930,  931,  933,  934,  935,  937,
	 938,  939,  941,  942,  943,  945,  946,  947,
	 948,  950,  951,  952,  953,  954,  956,  957,
	 958,  959,  960,  961,  962,  963,  965,  966,
	 967,  968,  969,  970,  971,  972,  973,  974,
	 975,  976,  977,  978,  979,  980,  981,  981,
	 982,  983,  984,  985,  986,  987,  987,  988,
	 989,  990,  991,  991,  992,  993,  994,  995,
	 995,  996,  997,  997,  998,  999,  999, 1000,
	1001, 1001, 1002, 1003, 1003, 1004, 1004, 1005,
	1006, 1006, 1007, 1007, 1008, 1008, 1009, 1009,
	1010, 1010, 1011, 1011, 1012, 1012, 1012, 1013,
	1013, 1014, 1014, 1015, 1015, 1015, 1016, 1016,
	1016, 1017, 1017, 1017, 1018, 1018, 1018, 1019,
	1019, 1019, 1019, 1020, 1020, 1020, 1020, 1020,
	1021, 1021, 1021, 1021, 1021, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1022, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*600*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  115,  157,  189,  215,  238,  259,  278,
	 296,  312,  327,  342,  356,  369,  381,  394,
	 405,  417,  428,  438,  449,  459,  468,  478,
	 487,  496,  505,  514,  523,  531,  540,  548,
	 556,  564,  571,  579,  586,  594,  601,  608,
	 615,  622,  629,  636,  642,  649,  655,  662,
	 668,  675,  681,  688,  695,  702,  709,  715,
	 722,  729,  735,  741,  747,  753,  759,  764,
	 769,  773,  777,  781,  784,  786,  789,  791,
	 794,  796,  799,  801,  803,  806,  808,  811,
	 813,  815,  818,  820,  822,  825,  827,  829,
	 831,  834,  836,  838,  840,  842,  845,  847,
	 849,  851,  853,  855,  857,  860,  862,  864,
	 866,  868,  870,  872,  874,  876,  878,  880,
	 882,  884,  886,  887,  889,  891,  893,  895,
	 897,  899,  900,  902,  904,  906,  908,  909,
	 911,  913,  915,  916,  918,  920,  921,  923,
	 925,  926,  928,  929,  931,  932,  934,  936,
	 937,  939,  940,  942,  943,  945,  946,  947,
	 949,  950,  952,  953,  954,  956,  957,  958,
	 960,  961,  962,  964,  965,  966,  967,  969,
	 970,  971,  972,  973,  974,  976,  977,  978,
	 979,  980,  981,  982,  983,  984,  985,  986,
	 987,  988,  989,  990,  991,  992,  993,  994,
	 995,  996,  996,  997,  998,  999, 1000, 1001,
	1001, 1002, 1003, 1004, 1004, 1005, 1006, 1006,
	1007, 1008, 1008, 1009, 1010, 1010, 1011, 1011,
	1012, 1012, 1013, 1014, 1014, 1015, 1015, 1015,
	1016, 1016, 1017, 1017, 1018, 1018, 1018, 1019,
	1019, 1019, 1020, 1020, 1020, 1020, 1021, 1021,
	1021, 1021, 1022, 1022, 1022, 1022, 1022, 1022,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*700*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  146,  201,  241,  276,  306,  332,  356,
	 378,  399,  419,  437,  454,  471,  487,  503,
	 518,  533,  547,  560,  573,  586,  599,  611,
	 623,  634,  646,  657,  668,  679,  689,  700,
	 710,  720,  730,  739,  749,  758,  767,  776,
	 785,  794,  803,  811,  820,  828,  837,  845,
	 853,  861,  870,  880,  889,  898,  905,  908,
	 909,  911,  912,  914,  915,  917,  918,  919,
	 921,  922,  923,  925,  926,  927,  929,  930,
	 931,  932,  934,  935,  936,  937,  939,  940,
	 941,  942,  943,  944,  946,  947,  948,  949,
	 950,  951,  952,  953,  954,  955,  956,  957,
	 958,  959,  960,  961,  962,  963,  964,  965,
	 966,  967,  968,  969,  970,  971,  972,  972,
	 973,  974,  975,  976,  977,  977,  978,  979,
	 980,  981,  981,  982,  983,  984,  984,  985,
	 986,  987,  987,  988,  989,  989,  990,  991,
	 991,  992,  993,  993,  994,  994,  995,  996,
	 996,  997,  997,  998,  998,  999,  999, 1000,
	1001, 1001, 1002, 1002, 1003, 1003, 1003, 1004,
	1004, 1005, 1005, 1006, 1006, 1007, 1007, 1007,
	1008, 1008, 1009, 1009, 1009, 1010, 1010, 1011,
	1011, 1011, 1012, 1012, 1012, 1013, 1013, 1013,
	1014, 1014, 1014, 1014, 1015, 1015, 1015, 1016,
	1016, 1016, 1016, 1017, 1017, 1017, 1017, 1017,
	1018, 1018, 1018, 1018, 1018, 1019, 1019, 1019,
	1019, 1019, 1020, 1020, 1020, 1020, 1020, 1020,
	1020, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
	1021, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1022, 1022, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*800*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  139,  189,  227,  259,  288,  312,  335,
	 356,  375,  393,  411,  427,  443,  458,  473,
	 487,  501,  514,  527,  539,  551,  563,  574,
	 586,  597,  607,  618,  628,  639,  649,  658,
	 668,  678,  687,  696,  705,  714,  722,  731,
	 739,  747,  756,  764,  772,  780,  787,  795,
	 803,  811,  819,  827,  836,  844,  850,  854,
	 856,  858,  860,  862,  864,  866,  868,  870,
	 872,  873,  875,  877,  879,  881,  883,  884,
	 886,  888,  890,  891,  893,  895,  896,  898,
	 900,  901,  903,  905,  906,  908,  909,  911,
	 912,  914,  916,  917,  919,  920,  922,  923,
	 924,  926,  927,  929,  930,  931,  933,  934,
	 936,  937,  938,  939,  941,  942,  943,  945,
	 946,  947,  948,  949,  951,  952,  953,  954,
	 955,  956,  958,  959,  960,  961,  962,  963,
	 964,  965,  966,  967,  968,  969,  970,  971,
	 972,  973,  974,  975,  976,  977,  978,  979,
	 980,  980,  981,  982,  983,  984,  985,  985,
	 986,  987,  988,  989,  989,  990,  991,  992,
	 992,  993,  994,  994,  995,  996,  996,  997,
	 998,  998,  999, 1000, 1000, 1001, 1001, 1002,
	1002, 1003, 1004, 1004, 1005, 1005, 1006, 1006,
	1007, 1007, 1008, 1008, 1009, 1009, 1010, 1010,
	1010, 1011, 1011, 1012, 1012, 1012, 1013, 1013,
	1014, 1014, 1014, 1015, 1015, 1015, 1016, 1016,
	1016, 1017, 1017, 1017, 1017, 1018, 1018, 1018,
	1018, 1019, 1019, 1019, 1019, 1020, 1020, 1020,
	1020, 1020, 1020, 1021, 1021, 1021, 1021, 1021,
	1021, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*900*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  131,  179,  216,  246,  273,  296,  317,
	 337,  355,  373,  389,  405,  420,  435,  449,
	 462,  475,  488,  500,  512,  523,  534,  545,
	 555,  566,  576,  586,  596,  605,  615,  624,
	 633,  642,  651,  660,  668,  676,  685,  693,
	 701,  709,  716,  724,  732,  739,  747,  754,
	 761,  769,  776,  783,  790,  797,  804,  810,
	 817,  824,  832,  839,  847,  855,  863,  870,
	 877,  884,  890,  895,  900,  904,  907,  908,
	 910,  911,  913,  914,  915,  917,  918,  920,
	 921,  922,  924,  925,  926,  928,  929,  930,
	 932,  933,  934,  935,  937,  938,  939,  940,
	 941,  943,  944,  945,  946,  947,  948,  949,
	 951,  952,  953,  954,  955,  956,  957,  958,
	 959,  960,  961,  962,  963,  964,  965,  966,
	 967,  968,  969,  970,  971,  972,  972,  973,
	 974,  975,  976,  977,  978,  978,  979,  980,
	 981,  982,  982,  983,  984,  985,  985,  986,
	 987,  988,  988,  989,  990,  990,  991,  992,
	 992,  993,  994,  994,  995,  996,  996,  997,
	 997,  998,  999,  999, 1000, 1000, 1001, 1001,
	1002, 1002, 1003, 1004, 1004, 1005, 1005, 1005,
	1006, 1006, 1007, 1007, 1008, 1008, 1009, 1009,
	1009, 1010, 1010, 1011, 1011, 1011, 1012, 1012,
	1013, 1013, 1013, 1014, 1014, 1014, 1015, 1015,
	1015, 1015, 1016, 1016, 1016, 1017, 1017, 1017,
	1017, 1018, 1018, 1018, 1018, 1019, 1019, 1019,
	1019, 1019, 1020, 1020, 1020, 1020, 1020, 1020,
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1022,
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*1000*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  124,  171,  206,  235,  260,  281,  302,
	 321,  339,  355,  371,  386,  400,  414,  428,
	 441,  453,  465,  476,  487,  498,  509,  519,
	 529,  539,  549,  558,  568,  577,  586,  594,
	 603,  612,  620,  628,  636,  644,  652,  660,
	 668,  675,  683,  690,  697,  705,  712,  719,
	 726,  733,  740,  746,  753,  759,  766,  772,
	 778,  785,  791,  797,  803,  809,  815,  821,
	 827,  833,  839,  845,  850,  856,  862,  867,
	 873,  880,  886,  893,  898,  903,  907,  909,
	 911,  912,  914,  915,  917,  918,  919,  921,
	 922,  924,  925,  926,  928,  929,  930,  932,
	 933,  934,  936,  937,  938,  939,  941,  942,
	 943,  944,  946,  947,  948,  949,  950,  951,
	 952,  954,  955,  956,  957,  958,  959,  960,
	 961,  962,  963,  964,  965,  966,  967,  968,
	 969,  970,  971,  972,  973,  974,  975,  976,
	 976,  977,  978,  979,  980,  981,  982,  982,
	 983,  984,  985,  986,  986,  987,  988,  989,
	 989,  990,  991,  991,  992,  993,  993,  994,
	 995,  995,  996,  997,  997,  998,  999,  999,
	1000, 1000, 1001, 1001, 1002, 1003, 1003, 1004,
	1004, 1005, 1005, 1006, 1006, 1007, 1007, 1008,
	1008, 1008, 1009, 1009, 1010, 1010, 1011, 1011,
	1011, 1012, 1012, 1013, 1013, 1013, 1014, 1014,
	1014, 1015, 1015, 1015, 1016, 1016, 1016, 1016,
	1017, 1017, 1017, 1018, 1018, 1018, 1018, 1019,
	1019, 1019, 1019, 1019, 1020, 1020, 1020, 1020,
	1020, 1020, 1021, 1021, 1021, 1021, 1021, 1021,
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	}
};

/*Mbox: iptv/ott hdr curve select*/
/*600nit alpha_low = 0.12;*/
unsigned int data_eotf_33_2084_mapping_box[SIZE_EOTF_TBL] = {
	    0,     4,    10,    16,    24,    34,    48,    67,
	   93,   129,   177,   244,   334,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
};

unsigned int data_oetf_289_gamma22_mapping_box[SIZE_OETF_TBL] = {
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  115,  157,  189,  215,  238,  259,  278,
	 296,  312,  327,  342,  356,  369,  381,  394,
	 405,  417,  428,  438,  449,  459,  468,  478,
	 487,  496,  505,  514,  523,  531,  540,  548,
	 556,  564,  571,  579,  586,  594,  601,  608,
	 615,  622,  629,  636,  642,  649,  655,  662,
	 668,  675,  681,  688,  695,  702,  709,  715,
	 722,  729,  735,  741,  747,  753,  759,  764,
	 769,  773,  777,  781,  784,  786,  789,  791,
	 794,  796,  799,  801,  803,  806,  808,  811,
	 813,  815,  818,  820,  822,  825,  827,  829,
	 831,  834,  836,  838,  840,  842,  845,  847,
	 849,  851,  853,  855,  857,  860,  862,  864,
	 866,  868,  870,  872,  874,  876,  878,  880,
	 882,  884,  886,  887,  889,  891,  893,  895,
	 897,  899,  900,  902,  904,  906,  908,  909,
	 911,  913,  915,  916,  918,  920,  921,  923,
	 925,  926,  928,  929,  931,  932,  934,  936,
	 937,  939,  940,  942,  943,  945,  946,  947,
	 949,  950,  952,  953,  954,  956,  957,  958,
	 960,  961,  962,  964,  965,  966,  967,  969,
	 970,  971,  972,  973,  974,  976,  977,  978,
	 979,  980,  981,  982,  983,  984,  985,  986,
	 987,  988,  989,  990,  991,  992,  993,  994,
	 995,  996,  996,  997,  998,  999, 1000, 1001,
	1001, 1002, 1003, 1004, 1004, 1005, 1006, 1006,
	1007, 1008, 1008, 1009, 1010, 1010, 1011, 1011,
	1012, 1012, 1013, 1014, 1014, 1015, 1015, 1015,
	1016, 1016, 1017, 1017, 1018, 1018, 1018, 1019,
	1019, 1019, 1020, 1020, 1020, 1020, 1021, 1021,
	1021, 1021, 1022, 1022, 1022, 1022, 1022, 1022,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
};

/*350nit alpha_low = 0.12; */
unsigned int data_eotf_33_2084_mapping_level1_box[SIZE_EOTF_TBL] = {
	    0,     4,    10,    16,    24,    34,    48,    67,
	   93,   129,   177,   244,   334,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
};

unsigned int data_oetf_289_gamma22_mapping_level1_box[SIZE_OETF_TBL] = {
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  148,  201,  242,  276,  305,  331,  355,
	 378,  399,  418,  437,  454,  471,  487,  503,
	 518,  532,  546,  560,  573,  586,  598,  610,
	 622,  634,  645,  656,  667,  678,  689,  699,
	 710,  720,  730,  741,  752,  764,  775,  786,
	 797,  807,  816,  825,  832,  839,  844,  847,
	 849,  851,  853,  855,  857,  859,  861,  863,
	 865,  867,  869,  871,  872,  874,  876,  878,
	 880,  881,  883,  885,  887,  888,  890,  892,
	 893,  895,  897,  898,  900,  902,  903,  905,
	 906,  908,  910,  911,  913,  914,  916,  917,
	 919,  920,  921,  923,  924,  926,  927,  928,
	 930,  931,  933,  934,  935,  937,  938,  939,
	 940,  942,  943,  944,  945,  947,  948,  949,
	 950,  951,  952,  954,  955,  956,  957,  958,
	 959,  960,  961,  962,  963,  964,  965,  966,
	 967,  968,  969,  970,  971,  972,  973,  974,
	 975,  976,  977,  978,  979,  980,  980,  981,
	 982,  983,  984,  985,  985,  986,  987,  988,
	 988,  989,  990,  991,  991,  992,  993,  993,
	 994,  995,  995,  996,  997,  997,  998,  999,
	 999, 1000, 1000, 1001, 1002, 1002, 1003, 1003,
	1004, 1004, 1005, 1005, 1006, 1006, 1007, 1007,
	1008, 1008, 1009, 1009, 1010, 1010, 1010, 1011,
	1011, 1012, 1012, 1012, 1013, 1013, 1013, 1014,
	1014, 1014, 1015, 1015, 1015, 1016, 1016, 1016,
	1017, 1017, 1017, 1017, 1018, 1018, 1018, 1018,
	1019, 1019, 1019, 1019, 1020, 1020, 1020, 1020,
	1020, 1020, 1021, 1021, 1021, 1021, 1021, 1021,
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
};

/*800nit alpha_low = 0.12; */
unsigned int data_eotf_33_2084_mapping_level2_box[SIZE_EOTF_TBL] = {
	    0,     4,     8,    12,    18,    24,    33,    43,
	   58,    77,   103,   138,   184,   246,   329,   440,
	  605,   824,  1117,  1507,  2025,  2713,  3625,  4836,
	 6445,  8583, 11430, 15228, 15695, 16025, 16237, 16350,
	16383
};

unsigned int oetf_289_gamma22_mapping_level2_box[SIZE_OETF_TBL] = {
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  139,  189,  227,  259,  288,  312,  335,
	 356,  375,  393,  411,  427,  443,  458,  473,
	 487,  501,  514,  527,  539,  551,  563,  574,
	 586,  597,  607,  618,  628,  639,  649,  658,
	 668,  678,  687,  696,  705,  714,  722,  731,
	 739,  747,  756,  764,  772,  780,  787,  795,
	 803,  811,  819,  827,  836,  844,  850,  854,
	 856,  858,  860,  862,  864,  866,  868,  870,
	 872,  873,  875,  877,  879,  881,  883,  884,
	 886,  888,  890,  891,  893,  895,  896,  898,
	 900,  901,  903,  905,  906,  908,  909,  911,
	 912,  914,  916,  917,  919,  920,  922,  923,
	 924,  926,  927,  929,  930,  931,  933,  934,
	 936,  937,  938,  939,  941,  942,  943,  945,
	 946,  947,  948,  949,  951,  952,  953,  954,
	 955,  956,  958,  959,  960,  961,  962,  963,
	 964,  965,  966,  967,  968,  969,  970,  971,
	 972,  973,  974,  975,  976,  977,  978,  979,
	 980,  980,  981,  982,  983,  984,  985,  985,
	 986,  987,  988,  989,  989,  990,  991,  992,
	 992,  993,  994,  994,  995,  996,  996,  997,
	 998,  998,  999, 1000, 1000, 1001, 1001, 1002,
	1002, 1003, 1004, 1004, 1005, 1005, 1006, 1006,
	1007, 1007, 1008, 1008, 1009, 1009, 1010, 1010,
	1010, 1011, 1011, 1012, 1012, 1012, 1013, 1013,
	1014, 1014, 1014, 1015, 1015, 1015, 1016, 1016,
	1016, 1017, 1017, 1017, 1017, 1018, 1018, 1018,
	1018, 1019, 1019, 1019, 1019, 1020, 1020, 1020,
	1020, 1020, 1020, 1021, 1021, 1021, 1021, 1021,
	1021, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
};

/*400nit alpha_low = 0.20; */
unsigned int data_eotf_33_2084_mapping_level3_box[SIZE_EOTF_TBL] = {
	    0,     7,    15,    24,    34,    47,    63,    83,
	  110,   146,   193,   257,   342,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
};

unsigned int data_oetf_289_gamma22_mapping_level3_box[SIZE_OETF_TBL] = {
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  139,  189,  228,  259,  287,  312,  334,
	 356,  375,  394,  411,  427,  443,  458,  473,
	 487,  501,  514,  527,  540,  552,  564,  575,
	 586,  597,  608,  618,  629,  639,  649,  658,
	 668,  677,  687,  697,  708,  718,  729,  739,
	 749,  758,  767,  775,  782,  788,  793,  797,
	 800,  802,  804,  807,  809,  812,  814,  816,
	 819,  821,  823,  826,  828,  830,  832,  835,
	 837,  839,  841,  843,  845,  848,  850,  852,
	 854,  856,  858,  860,  862,  864,  866,  868,
	 870,  872,  874,  876,  878,  880,  882,  883,
	 885,  887,  889,  891,  892,  894,  896,  898,
	 899,  901,  903,  905,  906,  908,  910,  911,
	 913,  914,  916,  918,  919,  921,  922,  924,
	 925,  927,  928,  930,  931,  933,  934,  935,
	 937,  938,  940,  941,  942,  944,  945,  946,
	 948,  949,  950,  951,  953,  954,  955,  956,
	 958,  959,  960,  961,  962,  963,  964,  966,
	 967,  968,  969,  970,  971,  972,  973,  974,
	 975,  976,  977,  978,  979,  980,  981,  982,
	 983,  984,  984,  985,  986,  987,  988,  989,
	 990,  990,  991,  992,  993,  993,  994,  995,
	 996,  996,  997,  998,  999,  999, 1000, 1001,
	1001, 1002, 1002, 1003, 1004, 1004, 1005, 1005,
	1006, 1007, 1007, 1008, 1008, 1009, 1009, 1010,
	1010, 1011, 1011, 1012, 1012, 1012, 1013, 1013,
	1014, 1014, 1014, 1015, 1015, 1016, 1016, 1016,
	1017, 1017, 1017, 1018, 1018, 1018, 1018, 1019,
	1019, 1019, 1019, 1020, 1020, 1020, 1020, 1021,
	1021, 1021, 1021, 1021, 1021, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1022, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
};

/*450nit  alpha_low = 0.12;*/
unsigned int data_eotf_33_2084_mapping_level4_box[SIZE_EOTF_TBL] = {
	    0,     4,    10,    16,    24,    34,    48,    67,
	   93,   129,   177,   244,   334,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
};

unsigned int data_oetf_289_gamma22_mapping_level4_box[SIZE_OETF_TBL] = {
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  131,  179,  216,  245,  272,  295,  317,
	 337,  356,  374,  390,  406,  421,  435,  449,
	 462,  475,  488,  500,  512,  523,  534,  545,
	 556,  566,  576,  586,  596,  605,  615,  624,
	 633,  642,  651,  660,  668,  676,  685,  693,
	 701,  709,  717,  725,  732,  740,  747,  754,
	 762,  769,  777,  785,  793,  802,  810,  818,
	 826,  834,  842,  849,  856,  863,  869,  875,
	 880,  885,  889,  892,  894,  896,  897,  899,
	 900,  902,  904,  905,  907,  908,  909,  911,
	 912,  914,  915,  917,  918,  919,  921,  922,
	 924,  925,  926,  928,  929,  930,  931,  933,
	 934,  935,  937,  938,  939,  940,  941,  943,
	 944,  945,  946,  947,  948,  950,  951,  952,
	 953,  954,  955,  956,  957,  958,  959,  960,
	 961,  962,  963,  964,  965,  966,  967,  968,
	 969,  970,  971,  972,  973,  974,  975,  976,
	 976,  977,  978,  979,  980,  981,  981,  982,
	 983,  984,  985,  985,  986,  987,  988,  988,
	 989,  990,  990,  991,  992,  993,  993,  994,
	 994,  995,  996,  996,  997,  998,  998,  999,
	 999, 1000, 1001, 1001, 1002, 1002, 1003, 1003,
	1004, 1004, 1005, 1005, 1006, 1006, 1007, 1007,
	1008, 1008, 1009, 1009, 1009, 1010, 1010, 1011,
	1011, 1012, 1012, 1012, 1013, 1013, 1013, 1014,
	1014, 1014, 1015, 1015, 1015, 1016, 1016, 1016,
	1017, 1017, 1017, 1017, 1018, 1018, 1018, 1018,
	1019, 1019, 1019, 1019, 1019, 1020, 1020, 1020,
	1020, 1020, 1021, 1021, 1021, 1021, 1021, 1021,
	1021, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
};

/*CSC related data*/
unsigned int primaries_bt709[3][2] = {
	{0.30 * INORM + 0.5, 0.60 * INORM + 0.5},/*G*/
	{0.15 * INORM + 0.5, 0.06 * INORM + 0.5},/*B*/
	{0.64 * INORM + 0.5, 0.33 * INORM + 0.5},/*R*/
};

unsigned int primaries_bt2020[3][2] = {
	{0.17 * INORM + 0.5, 0.797 * INORM + 0.5},/*G*/
	{0.131 * INORM + 0.5, 0.046 * INORM + 0.5},/*B*/
	{0.708 * INORM + 0.5, 0.292 * INORM + 0.5},/*R*/
};

unsigned int white_point_bt709[2] = {
	0.3127 * INORM + 0.5, 0.3290 * INORM + 0.5
};

unsigned int white_point_bt2020[2] = {
	0.3127 * INORM + 0.5, 0.3290 * INORM + 0.5
};

unsigned int customer_mtrx_param[16] = {
	0, 0, 0,
	0x0d49, 0x1b4d, 0x1f6b,
	0x1f01, 0x0910, 0x1fef,
	0x1fdb, 0x1f32, 0x08f3,
	0, 0, 0,
	1
};

unsigned int customer_hdmi_display_param[14] = {
	9,/*color primary = bt2020*/
	16,/*characteristic = st2084*/
	0.17 * INORM + 0.5, 0.797 * INORM + 0.5,/*G*/
	0.131 * INORM + 0.5, 0.046 * INORM + 0.5,/*B*/
	0.708 * INORM + 0.5, 0.292 * INORM + 0.5,/*R*/
	0.3127 * INORM + 0.5, 0.3290 * INORM + 0.5,/*W*/
	9997 * 10000, 0,/*max/min lum*/
	5000, 50,/*content lum and frame average*/
};

unsigned int customer_master_display_param[12] = {
	0.17 * INORM + 0.5, 0.797 * INORM + 0.5,/*G*/
	0.131 * INORM + 0.5, 0.046 * INORM + 0.5,/*B*/
	0.708 * INORM + 0.5, 0.292 * INORM + 0.5,/*R*/
	0.3127 * INORM + 0.5, 0.3290 * INORM + 0.5,/*W*/
	5000 * 10000, 50,/*max/min lum*/
	5000, 50,/*content lum and frame average*/
};

int mtrx_rgb709_to_yuv709[CSC_MTRX_5x3_COEF_SIZE] = {
	0, 0, 0,/*pre offset*/
	COEFF_NORM(0.2126), COEFF_NORM(0.7152), COEFF_NORM(0.0722),
	COEFF_NORM(-0.114572), COEFF_NORM(-0.385428), COEFF_NORM(0.5),
	COEFF_NORM(0.5), COEFF_NORM(-0.454153), COEFF_NORM(-0.045847),
	0, 0, 0,/*10'/11'/12'*/
	0, 0, 0,/*20'/21'/22'*/
	0, 512, 512,/*offset*/
	0, 0, 0,/*mode/right_shift/clip_en*/
};

int mtrx_rgb709_to_yuv709l[CSC_MTRX_5x3_COEF_SIZE] = {
	0, 0, 0,
	COEFF_NORM(0.181873), COEFF_NORM(0.611831), COEFF_NORM(0.061765),
	COEFF_NORM(-0.100251), COEFF_NORM(-0.337249), COEFF_NORM(0.437500),
	COEFF_NORM(0.437500), COEFF_NORM(-0.397384), COEFF_NORM(-0.040116),
	0, 0, 0,/*10'/11'/12'*/
	0, 0, 0,/*20'/21'/22'*/
	64, 512, 512,
	0, 0, 0,
};

int mtrx_rgb2020_to_yuv2020l[CSC_MTRX_5x3_COEF_SIZE] = {
	0, 0, 0,
	COEFF_NORM(0.224732), COEFF_NORM(0.580008), COEFF_NORM(0.050729),
	COEFF_NORM(-0.122176), COEFF_NORM(-0.315324), COEFF_NORM(0.437500),
	COEFF_NORM(0.437500), COEFF_NORM(-0.402312), COEFF_NORM(-0.035188),
	0, 0, 0,/*30/31/32*/
	0, 0, 0,/*40/41/42*/
	64, 512, 512,
	0, 0, 0,
};

int mtrx_yuv709l_to_rgb709[CSC_MTRX_5x3_COEF_SIZE] = {
	-64, -512, -512,
	COEFF_NORM(1.16895), COEFF_NORM(0.00000), COEFF_NORM(1.79977),
	COEFF_NORM(1.16895), COEFF_NORM(-0.21408), COEFF_NORM(-0.53500),
	COEFF_NORM(1.16895), COEFF_NORM(2.12069), COEFF_NORM(0.00000),
	0, 0, 0,/*30/31/32*/
	0, 0, 0,/*40/41/42*/
	0, 0, 0,
	0, 0, 0,
};

int mtrx_yuv709f_to_rgb709[CSC_MTRX_5x3_COEF_SIZE] = {
	0, -512, -512,
	COEFF_NORM(1.0), COEFF_NORM(0.00000), COEFF_NORM(1.575),
	COEFF_NORM(1.0), COEFF_NORM(-0.187), COEFF_NORM(-0.468),
	COEFF_NORM(1.0), COEFF_NORM(1.856), COEFF_NORM(0.00000),
	0, 0, 0,/*30/31/32*/
	0, 0, 0,/*40/41/42*/
	0, 0, 0,
	0, 0, 0,
};

int mtrx_yuv2020l_to_rgb2020[CSC_MTRX_5x3_COEF_SIZE] = {
	-64, -512, -512,
	COEFF_NORM(1.16895), COEFF_NORM(0.00000), COEFF_NORM(1.68526),
	COEFF_NORM(1.16895), COEFF_NORM(-0.18806), COEFF_NORM(-0.65298),
	COEFF_NORM(1.16895), COEFF_NORM(2.15017), COEFF_NORM(0.00000),
	0, 0, 0,/*30/31/32*/
	0, 0, 0,/*40/41/42*/
	0, 0, 0,
	0, 0, 0,
};

int mtrx_yuv709f_to_yuv709l[CSC_MTRX_5x3_COEF_SIZE] = {
	0, -512, -512,
	COEFF_NORM(0.859), COEFF_NORM(0), COEFF_NORM(0),
	COEFF_NORM(0), COEFF_NORM(0.878), COEFF_NORM(0),
	COEFF_NORM(0), COEFF_NORM(0), COEFF_NORM(0.878),
	0, 0, 0,/*10'/11'/12'*/
	0, 0, 0,/*20'/21'/22'*/
	64, 512, 512,
	0, 0, 0,
};

int mtrx_yuv709l_to_yuv709f[CSC_MTRX_5x3_COEF_SIZE] = {
	64, -512, -512,
	COEFF_NORM(1.16895), COEFF_NORM(0), COEFF_NORM(0),
	COEFF_NORM(0), COEFF_NORM(1.14286), COEFF_NORM(0),
	COEFF_NORM(0), COEFF_NORM(0), COEFF_NORM(1.14286),
	0, 0, 0,/*10'/11'/12'*/
	0, 0, 0,/*20'/21'/22'*/
	0, 512, 512,
	0, 0, 0,
};

int mtrx_yuv709l_to_yuv2020[CSC_MTRX_5x3_COEF_SIZE] = {
	-64, -512, -512,
	0x400, 0x1fe4, 0x2b,
	0, 0x39f, 0x1fe5,
	0x0, 0xc, 0x321,
	0, 0, 0,/*30/31/32*/
	0, 0, 0,/*40/41/42*/
	64, 512, 512,
	0, 0, 0,
};

int mtrx_yuv601l_to_yuv709l[CSC_MTRX_5x3_COEF_SIZE] = {
	-64, -512, -512,
	COEFF_NORM(1.0), COEFF_NORM(-0.115), COEFF_NORM(-0.207),
	COEFF_NORM(0), COEFF_NORM(1.018), COEFF_NORM(0.114),
	COEFF_NORM(0), COEFF_NORM(0.075), COEFF_NORM(1.025),
	0, 0, 0,/*30/31/32*/
	0, 0, 0,/*40/41/42*/
	64, 512, 512,
	0, 0, 0,
};

int mtrx_yuv601f_to_yuv709f[CSC_MTRX_5x3_COEF_SIZE] = {
	0, -512, -512,
	COEFF_NORM(1.00000), COEFF_NORM(-0.118), COEFF_NORM(-0.212),
	COEFF_NORM(0.00000), COEFF_NORM(1.018), COEFF_NORM(0.114),
	COEFF_NORM(0.00000), COEFF_NORM(0.075), COEFF_NORM(1.025),
	0, 0, 0,/*30/31/32*/
	0, 0, 0,/*40/41/42*/
	0, 512, 512,
	0, 0, 0,
};

int mtrx_yuv709l_to_yuv601l[CSC_MTRX_5x3_COEF_SIZE] = {
	-64, -512, -512,
	COEFF_NORM(1.0), COEFF_NORM(0.1), COEFF_NORM(0.192),
	COEFF_NORM(0), COEFF_NORM(0.990), COEFF_NORM(-0.110),
	COEFF_NORM(0), COEFF_NORM(-0.072), COEFF_NORM(0.984),
	0, 0, 0,/*30/31/32*/
	0, 0, 0,/*40/41/42*/
	64, 512, 512,
	0, 0, 0,
};

int mtrx_yuv601l_to_yuv709f[CSC_MTRX_5x3_COEF_SIZE] = {
	-64, -512, -512,
	COEFF_NORM(1.164), COEFF_NORM(-0.134), COEFF_NORM(-0.241),
	COEFF_NORM(0), COEFF_NORM(1.160), COEFF_NORM(-0.129),
	COEFF_NORM(0), COEFF_NORM(-0.085), COEFF_NORM(1.167),
	0, 0, 0,/*30/31/32*/
	0, 0, 0,/*40/41/42*/
	0, 512, 512,
	0, 0, 0,
};

int mtrx_yuv601f_to_yuv709l[CSC_MTRX_5x3_COEF_SIZE] = {
	0, -512, -512,
	COEFF_NORM(0.859), COEFF_NORM(-0.101), COEFF_NORM(-0.182),
	COEFF_NORM(0), COEFF_NORM(0.894), COEFF_NORM(-0.100),
	COEFF_NORM(0), COEFF_NORM(-0.066), COEFF_NORM(0.900),
	0, 0, 0,/*30/31/32*/
	0, 0, 0,/*40/41/42*/
	64, 512, 512,
	0, 0, 0,
};

int mtrx_bypass[CSC_MTRX_5x3_COEF_SIZE] = {
	0, 0, 0,
	COEFF_NORM(1.0), COEFF_NORM(0.0), COEFF_NORM(0.0),
	COEFF_NORM(0.0), COEFF_NORM(1.0), COEFF_NORM(0.0),
	COEFF_NORM(0.0), COEFF_NORM(0.0), COEFF_NORM(1.0),
	0, 0, 0,/*10'/11'/12'*/
	0, 0, 0,/*20'/21'/22'*/
	0, 0, 0,
	0, 0, 0,
};

#endif
