/*
 * Copyright (c) 2021-2022 Amlogic, Inc. All rights reserved.
 *
 * SPDX-License-Identifier: MIT
 */

// ----------------------------------------------------------------------
// This file is automatically generated from the script:
//
// ./create_headers_from_register_map_h.pl
//
// and was applied to the file
//
// Project name: t5w
//
// Create time: Tue Jul  6 14:31:42 CST 2021 by chong.gu
//
// ./register_map.h
//
// DO NOT EDIT!!!!!
// ----------------------------------------------------------------------
//
#ifndef REGISTER_H
#define REGISTER_H

#ifndef VERIFICATION
#define Wr(addr, data) (*((volatile uint32_t *)(addr)) = (data))
#define Rd(addr) (*(volatile uint32_t *)(addr))
#define Wr_reg_bits(reg, val, start, len)                                                        \
	Wr(reg, ((Rd(reg) & ~(((1L << (len)) - 1) << (start))) | ((uint32_t)(val) << (start))))
#else
#include "dpi.h"
#endif

//
// Reading file:  ./register_map.h
//
// synopsys translate_off
// synopsys translate_on
//
// Reading file:  stb_define.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// CBUS_BASE:  STB_CBUS_BASE = 0x18
// -----------------------------------------------
// There are two instantiations under one CBUS slave.  Each CBUS slave can support
// 256 registers.  Each demux is allocated 128 registers so set the offset in
// the middle
// Copy this define but don't add a base address
#define SECOND_DEMUX_OFFSET_0 0x50
#define THIRD_DEMUX_OFFSET_0 0xa0
//========================================================================
//  STB TOP Registers				    (8'hf0 - 8'hf7)
//========================================================================
// Bit 5:4 -- fec_sel_demux_2
// Bit 3:2 -- fec_sel_demux_1
// Bit 1:0 -- fec_sel_demux_0
#define TS_TOP_CONFIG1 ((0x184f << 2) + 0xffd00000)
// Bit 31:24 -- file_m2ts_skip_bytes_hiu1
// Bit 23:22 -- reserved
// Bit 21 -- ts_hiu_enable_hiu1
// Bit 20:16 -- fec_clk_div_hiu1
// Bit 15:8 -- TS_package_length_sub_1_hiu1 (default : 187)
// Bit 7:0 -- fec_sync_byte_hiu1 (default : 0x47)
#define TS_HIU1_CONFIG ((0x184e << 2) + 0xffd00000)
// bit[1:0]--   stb_recorder2_sel
#define STB_RECORDER2_CNTL ((0x18ee << 2) + 0xffd00000)
// bit [11]--   s2p2_disable
// bit [10:7]-- s2p2_clk_div
// bit [6:0]--  fec_serial_control_2
#define STB_S2P2_CONFIG ((0x18ef << 2) + 0xffd00000)
// bit 30:28 -- ciplus_o_sel
// bit 27:26 -- ciplus_i_sel
// bit 25 -- use FAIL fro TS2
// bit 24 -- use FAIL fro TS1
// bit 23 -- use FAIL fro TS0
// bit 22 -- invert fec_error for S2P1
// bit 21 -- invert fec_data for S2P1
// bit 20 -- invert fec_sync for S2P1
// bit 19 -- invert fec_valid for S2P1
// bit 18 -- invert fec_clk for S2P1
// bit 17:16 -- fec_s_sel for S2P1  00 - select TS0, 01 -- select TS1, 10 -- select TS2, 11 -
// reserved Bit 15 -- enable_des_pl_clk Bit 14 -- ts_out_select[3] Bit 13 --  use FAIL for TS3 Bit
// 12:10 -- ts_out_select[2:0], 0-TS0, 1-TS1, 2-TS2, 3-TS3, 4-S2P2, 5-S2P1, 6-S2P0, 7-File,
// 8-File1 bit 9:8 -- des_i_sel 00 -- select_fec_0, 01 -- select_fec_1, 10 -- select_fec_2, 11 -
// reserved bit 7 -- enable_des_pl bit 6 -- invert fec_error for S2P0 bit 5 -- invert fec_data for
// S2P0 bit 4 -- invert fec_sync for S2P0 bit 3 -- invert fec_valid for S2P0 bit 2 -- invert
// fec_clk for S2P0 bit 1:0 -- fec_s_sel for S2P0  00 - select TS0, 01 -- select TS1, 10 -- select
// TS2, 11 - reserved
#define STB_TOP_CONFIG ((0x18f0 << 2) + 0xffd00000)
// 31:28 - s2p1_clk_div
// 27:24 - s2p0_clk_div
// 23    - s2p1_disable
// 22    - s2p0_disable
// 21    - Reserved
// 20 -- TS_OUT_error_INVERT
// 19 -- TS_OUT_data_INVERT
// 18 -- TS_OUT_sync_INVERT
// 17 -- TS_OUT_valid_INVERT
// 16 -- TS_OUT_clk_INVERT
// 15:8 -- TS_package_length_sub_1 (default : 187)
//  7:0 -- fec_sync_byte (default : 0x47)
#define TS_TOP_CONFIG ((0x18f1 << 2) + 0xffd00000)
// Bit 25:24 -- transport_scrambling_control_odd_2 // should be 3
// Bit 23:16 -- file_m2ts_skip_bytes
// Bit 15:8 -- des_out_dly
// Bit 7:6 -- transport_scrambling_control_odd // should be 3
// Bit 5 -- ts_hiu_enable
// Bit 4:0 -- fec_clk_div
#define TS_FILE_CONFIG ((0x18f2 << 2) + 0xffd00000)
// Bit 19:14 -- des_2 ts pl state   -- Read Only
// Bit 13:8 -- des ts pl state   -- Read Only
// Bit 3:0 PID index to 8 PID to get key-set
// auto increse after TS_PL_PID_DATA read/write
#define TS_PL_PID_INDEX ((0x18f3 << 2) + 0xffd00000)
// Bit 13 -- PID match disble
// Bit 12:0 -- PID
#define TS_PL_PID_DATA ((0x18f4 << 2) + 0xffd00000)
#define COMM_DESC_KEY0 ((0x18f5 << 2) + 0xffd00000)
#define COMM_DESC_KEY1 ((0x18f6 << 2) + 0xffd00000)
#define COMM_DESC_KEY_RW ((0x18f7 << 2) + 0xffd00000)
// CI+ Register defines
// Bits[31:0] of the key
#define CIPLUS_KEY0 ((0x18f8 << 2) + 0xffd00000)
// Bits[63:32] of the key
#define CIPLUS_KEY1 ((0x18f9 << 2) + 0xffd00000)
// Bits[95:64] of the key
#define CIPLUS_KEY2 ((0x18fa << 2) + 0xffd00000)
// Bits[127:96] of the key
#define CIPLUS_KEY3 ((0x18fb << 2) + 0xffd00000)
// bit[5] write AES IV B value
// bit[4] write AES IV A value
// bit[3] write AES B key
// bit[2] write AES A key
// bit[1] write DES B key
// bit[0] write DES A key
#define CIPLUS_KEY_WR ((0x18fc << 2) + 0xffd00000)
// [15:8]   TS out delay.  This controls the rate at which the CIplus module drives TS out
// [3]      General enable for the ciplus module
// [2]      AES CBC disable (default should be 0 to enable AES CBC)
// [1]      AES Enable
// [0]      DES Enable
#define CIPLUS_CONFIG ((0x18fd << 2) + 0xffd00000)
// bit[31:28] AES IV endian
// bit[27:24] AES message out endian
// bit[23:20] AES message in endian
// bit[19:16] AES key endian
// bit[15:11]  unused
// bit[10:8]  DES message out endian
// bit[6:4]   DES message in endian
// bit[2:0]   DES key endian
#define CIPLUS_ENDIAN ((0x18fe << 2) + 0xffd00000)
// bit 15:8 - des_out_dly_2
// bit   7 - reserved
// Bit   6-- enable_des_pl_clk_2
// bit   5 - enable_des_pl_2
// bit 4:2 -- use_des_2  bit[2] -- demux0, bit[3] -- demux1, bit[4] -- demux2
// bit 1:0 -- des_i_sel_2 00 -- select_fec_0, 01 -- select_fec_1, 10 -- select_fec_2, 11 -
// reserved
#define COMM_DESC_2_CTL ((0x18ff << 2) + 0xffd00000)
//
// NOTE:  Don't process the demux registers using the standard create_headers.... perl script.
//        Instead, since the demux has multiple instances (and many registers) use a separate
//        script to create a separate stb_define.h for C-code.
//========================================================================
//  STB Registers				    (8'h00 - 8'h4f)
//
//========================================================================
// STB registers are 8'h0x
// Bit 15:0 -- version number : 0x0002  (v0.01)
// Bit 16 -- fec_select[3]
// Bit 15 -- fec_core_select 1 - select descramble output
// Bit 14:12 -  fec_select[2:0] 0-TS0, 1-TS1, 2-TS2, 3-TS3, 4-S2P2, 5-S2P1, 6-S2P0, 7-File,
// 8-File1 Bit 11 -- FEC_CLK Bit 10 -- SOP Bit 9 -- D_VALID Bit 8 -- D_FAIL Bit 7:0 -- D_DATA 7:0
// bit 31 -- enable_free_clk_fec_data_valid
// bit 30 -- enable_free_clk_stb_reg
// bit 29 -- always_use_pes_package_length
// bit 28 -- disable_pre_incomplete_section_fix
// bit 27 -- pointer_field_multi_pre_en
// bit 26 -- ignore_pre_incomplete_section
// bit 25 -- video2_enable
// bit 24:22 -- video2_type
// bit 21 -- do_not_trust_pes_package_length
// bit 20 (bit 4) -- Bypass use recoder path
// bit 19 (bit 3) -- clear_PID_continuity_counter_valid
// bit 18 (bit 2) -- Disable Splicing
// bit 17 (bit 1) -- Insert PES_STRONG_SYNC in Audio PES
// bit 16 (bit 0) -- Insert PES_STRONG_SYNC in Video PES
// Bit 15 - do not trust section length
// Bit 14 - om cmd push even zero
// Bit 13 - set_buff_ready_even_not_busy
// Bit 12 - SUB, OTHER PES interrupt at beginning of PES
// Bit 11 - discard_av_package -- for ts_recorder use only
// Bit 10 - ts_recorder_select  0:after PID filter 1:before PID filter
// Bit 9 - ts_recorder_enable
// Bit 8 - (table_id == 0xff) means section_end
// Bit 7 - do not send uncomplete section
// Bit 6 - do not discard duplicate package
// Bit 5 - search SOP when trasport_error_indicator
// Bit 4 - stb demux enable
// Bit 3 - do not reset state machine on SOP
// Bit 2 - search SOP when error happened ( when ignore_fail_n_sop, will have this case)
// Bit 1 - do not use SOP input ( check FEC sync byte instead )
// Bit 0 - ignore fec_error bit when non sop ( check error on SOP only)
// bit 15:8 demux package length - 1 ( default : 187 )
// bit 7:0 default is 0x47
// bit 31:16 -- filter memory write data hi[31:16]
// bit 15:0 -- filter memory write data low [15:0]
// bit 31:24 -- advanced setting hi
// bit 23:16 -- advanced setting low
// bit 15 -- filter memory write data request
// bit 7:0 -- filter memory write addr
// bit 13:8 demux state  -- read only
// bit 7:4 -- maxnum section filter compare address
// bit 3:0 -- maxnum PID filter compare address
// bit 15 - transport_error_indicator
// bit 14 - payload_unit_start_indicator
// bit 13 - transport_priority
// bit 12:0 - PID
// bit 7:6 transport_scrambling_control
// bit 5:4 adaptation_field_control
// bit 3:0 continuity_counter
// bit 15:12 -- om_cmd_count (read only)
// bit  11:9 -- overflow_count // bit  11:9 -- om_cmd_wr_ptr (read only)
// bit   8:6 -- om_overwrite_count // bit   8:6 -- om_cmd_rd_ptr (read only)
// bit   5:3 -- type_stb_om_w_rd (read only)
// bit     2 -- unit_start_stb_om_w_rd (read only)
// bit     1 -- om_cmd_overflow (read only)
// bit     0 -- om_cmd_pending (read)
// bit     0 -- om_cmd_read_finished (write)
// bit 15:9 // bit 14:8 -- count_stb_om_w_rd  (read only)
// bit 8:0  // bit  7:0 -- start_stb_om_wa_rd (read only)
// bit 11:0 -- offset for section data
// bit 31:16 -- base address for section buffer group 0 (*0x400 to get real address)
// bit 15:0 -- base address for section buffer group 1 (*0x400 to get real address)
// bit 31:16 -- ba2e address for section buffer group 2 (*0x400 to get real address)
// bit 15:0 -- base address for section buffer group 3 (*0x400 to get real address)
// bit 3:0 -- section buffer size for group 0 (bit used,  for example, 10 means 1K)
// bit 7:4 -- section buffer size for group 1
// bit 11:8 -- section buffer size for group 2
// bit 15:12 -- section buffer size for group 3
// section buffer busy status for buff 31:0 ( Read Only )
// section buffer write status for buff 31:0 -- Read
// clear buffer status ( buff READY and BUSY ) -- write
// bit 4:0 -- SEC_BUFFER_INDEX   RW
// bit 12:8 -- SEC_BUFFER_NUMBER for the INDEX buffer  Read_Only
// bit 14 -- output_section_buffer_valid
// bit 15 -- section_reset_busy (Read Only)
// bit 9:5 -- BYPASS PID number
// bit 4:0 -- PCR PID number
// bit 15:0 -- stream_id filter bit enable
// bit 7:0 -- stream_id filter target
// bit 12 -- PCR_EN
// bit 11:0 -- PCR90K_DIV
// bit 31:0 -- PCR[31:0] R/W
// bit 31:0 -- VPTS[31:0] R/W
// bit 31:0 -- VDTS[31:0] R/W
// bit 31:0 -- APTS[31:0] R/W
// bit 31:0 -- SPTS[31:0] R/W
// read -- status, write 1 clear status
// bit 15 -- SUB_PTS[32]
// bit 14 -- AUDIO_PTS[32]
// bit 13 -- VIDEO_DTS[32]
// bit 12 -- VIDEO_PTS[32]
// bit 3 -- sub_pts_ready
// bit 2 -- audio_pts_ready
// bit 1 -- video_dts_ready
// bit 0 -- video_pts_ready
// bit 3:0 --
//  0 -- adaptation_field_length[7:0], adaption_field_byte_1[7:0]
//  1 -- stream_id[7:0], pes_header_bytes_left[7:0]
//  2 -- pes_package_bytes_left[15:0]
//  3 -- pes_ctr_byte[7:0], pes_flag_byte[7:0]
//
// read only
// bit[31] -- no_match_record_en
// bit[30:16] - reserved
// default : 0x807f
// bit 15:9  -- MAX OM DMA COUNT  (default: 0x40)
// bit 8:0   -- LAST ADDR OF OM ADDR (default: 127)
// 15:0  WRITE 1 CLEAR to clear interrupt source
// 12 -- INPUT_TIME_OUT
// 11 -- PCR_ready
// 10 -- audio_splicing_point
// 9 -- video_splicing_point
// 8 -- other_PES_int
// 7 -- sub_PES_int
// 6 -- discontinuity
// 5 -- duplicated_pack_found
// 4 -- New PDTS ready
// 3 -- om_cmd_buffer ready for access
// 2 -- section buffer ready
// 1 -- transport_error_indicator
// 0 -- TS ERROR PIN
// Bit 5:3 - demux om write endian control for bypass
// Bit 2:0 - demux om write endian control for section
// When Bit 31 - 1 write will indicate all type use sepertate endian (Write Only)
// Bit 23:21 - demux om write endian control for OTHER_PES_PACKET
// Bit 20:18 - demux om write endian control for SCR_ONLY_PACKET
// Bit 17:15 - demux om write endian control for SUB_PACKET
// Bit 14:12 - demux om write endian control for AUDIO_PACKET
// Bit 11:9  - demux om write endian control for VIDEO_PACKET
//
// When Bit 31 - 0 write will indicate all type else use Bit 8:6
// Bit 8:6 - demux om write endian control for else
// Bit 10:9 -- sel DPTS_wr_ptr: 00 from parserA ; 01 from parserB
// Bit 8:7 -- use hi_bsf interface: 01 sel hiu0; 10 sel hiu1
// Bit 6:2 - Reserved
// Bit 1 - enable_halt_ts_hiu_fix
// Bit 0 - enable_halt_ts_hiu
// bit 15:0 -- base address for section buffer start (*0x10000 to get real base)
// bit 11 -- mask bit for OTHER_PES_AHB_DMA_EN
// bit 10 -- mask bit for SUB_AHB_DMA_EN
// bit 9 -- mask bit for BYPASS_AHB_DMA_EN
// bit 8 -- mask bit for SECTION_AHB_DMA_EN
// bit 7 -- mask bit for recoder stream
// bit 6:0 -- mask bit for each type
// bit 31:0 -- vb_wr_ptr for video PDTS
// bit 31:0 -- ab_wr_ptr for audio PDTS
// bit 20:0 -- SB_WRITE_PTR (sb_wr_ptr << 3 == byte write position)
// bit 19:0 -- SB_START (sb_start << 12 == byte address);
// bit 20:0 -- SB_SIZE (sb_size << 3 == byte size, 16M maximun)
// bit 31:0 -- sb_wr_ptr for sub PES
// bit 31:16 -- ob_wr_ptr for other PES
// bit 20:0 -- OB_WRITE_PTR (ob_wr_ptr << 3 == byte write position)
// bit 19:0 -- OB_START (ob_start << 12 == byte address);
// bit 20:0 -- OB_SIZE (ob_size << 3 == byte size, 16M maximun)
// bit 31:0 -- ob_wr_ptr for sub PES
// 15:0  DEMUX interrupt MASK
// 9 -- splicing_point
// 8 -- other_PES_int
// 7 -- sub_PES_int
// 6 -- discontinuity
// 5 -- duplicated_pack_found
// 4 -- New PDTS ready
// 3 -- om_cmd_buffer ready for access
// 2 -- section buffer ready
// 1 -- transport_error_indicator
// 0 -- TS ERROR PIN
// 31:16 VIDEO PID filter data
// 15 -- splicing VIDEO PID change enable
// 14:10 -- VIDEO PID FILTER ADDRESS
// 9 -- PES splicing active (Read Only)
// 8 -- splicing active (Read Only)
// 7:0  splicing countdown (Read Only)
// 31:16 AUDIO PID filter data
// 15 -- splicing AUDIO PID change enable
// 14:10 -- AUDIO PID FILTER ADDRESS
// 9 -- PES splicing active (Read Only)
// 8 -- splicing active (Read Only)
// 7:0  splicing countdown (Read Only)
// 23:16 M2TS_SKIP_BYTES
// 15:8 LAST TS PACKAGE BYTE COUNT (Read Only)
// 7:0  PACKAGE BYTE COUNT (Read Only)
// 15:0 2 bytes strong sync add to PES
// bit 15 -- stb_om_ren
// bit 14:11 -- reserved
// bit  10:0 -- OM_DATA_RD_ADDR
// bit 15:0 -- OM_DATA_RD
// AUTO STOP SETTING for 32 channels
// 4-nbits per channel
// when write
// bit 3 -- set section active
// bit 2:0 -- auto stop after count (0 means never stop)
// when read
// bit 3 -- current active status (1 - active, 0 - stopped )
// bit 2:0 -- count down to auto stop
// section 31:24
// section 23:16
// section 15:8
// section 7:0
// bit 31:0 reset channel status - each bit reset each channel
// read -- 32 channel status
// bit 4 -- video_stamp_use_dts
// bit 3 -- audio_stamp_sync_1_en
// bit 2 -- audio_stamp_insert_en
// bit 1 -- video_stamp_sync_1_en
// bit 0 -- video_stamp_insert_en
// Write : Bit[4:0] secter filter number for reset
// Read  : select according to output_section_buffer_valid :
//         per bit per section buffer valid status
//         or section_buffer_ignore
// bit[31:0] - channel_reset_timeout_disable
// bit[31] - no_match_reset_timeout_disable
// bit[30:0] input_time_out_int_cnt (0 -- means disable) Wr-setting, Rd-count
// bit[31:0] - channel_packet_count_disable
// bit[31] - no_match_packet_count_disable
// bit[30:0] input_packet_count
// bit[31:0] channel_record_enable
// bit[31:0] channel_process_enable
// bit[31:24] small_sec_size ((n+1) * 256 Bytes)
// bit[23:16] small_sec_rd_ptr
// bit[15:8]  small_sec_wr_ptr
// bit[7:2]   reserved
// bit[1] small_sec_wr_ptr_wr_enable
// bit[0] small_section_enable
// bit[31:0] small_sec_start_addr
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  stb_define.h
//
//
// Reading file:  periphs_reg.h
//
// $periphs/rtl/periphs_core register defines for the
// APB bus
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  SC_CBUS_BASE = 0x94
// -----------------------------------------------
#define SMARTCARD_REG0 ((0x9400 << 2) + 0xffd00000)
#define SMARTCARD_REG1 ((0x9401 << 2) + 0xffd00000)
#define SMARTCARD_REG2 ((0x9402 << 2) + 0xffd00000)
#define SMARTCARD_STATUS ((0x9403 << 2) + 0xffd00000)
#define SMARTCARD_INTR ((0x9404 << 2) + 0xffd00000)
#define SMARTCARD_REG5 ((0x9405 << 2) + 0xffd00000)
#define SMARTCARD_REG6 ((0x9406 << 2) + 0xffd00000)
#define SMARTCARD_FIFO ((0x9407 << 2) + 0xffd00000)
#define SMARTCARD_REG8 ((0x9408 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  UART0_CBUS_BASE = 0x90
// -----------------------------------------------
#define UART0_WFIFO ((0x9000 << 2) + 0xffd00000)
#define UART0_RFIFO ((0x9001 << 2) + 0xffd00000)
#define UART0_CONTROL ((0x9002 << 2) + 0xffd00000)
#define UART0_STATUS ((0x9003 << 2) + 0xffd00000)
#define UART0_MISC ((0x9004 << 2) + 0xffd00000)
#define UART0_REG5 ((0x9005 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  UART1_CBUS_BASE = 0x8c
// -----------------------------------------------
#define UART1_WFIFO ((0x8c00 << 2) + 0xffd00000)
#define UART1_RFIFO ((0x8c01 << 2) + 0xffd00000)
#define UART1_CONTROL ((0x8c02 << 2) + 0xffd00000)
#define UART1_STATUS ((0x8c03 << 2) + 0xffd00000)
#define UART1_MISC ((0x8c04 << 2) + 0xffd00000)
#define UART1_REG5 ((0x8c05 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  UART2_CBUS_BASE = 0x88
// -----------------------------------------------
#define UART2_WFIFO ((0x8800 << 2) + 0xffd00000)
#define UART2_RFIFO ((0x8801 << 2) + 0xffd00000)
#define UART2_CONTROL ((0x8802 << 2) + 0xffd00000)
#define UART2_STATUS ((0x8803 << 2) + 0xffd00000)
#define UART2_MISC ((0x8804 << 2) + 0xffd00000)
#define UART2_REG5 ((0x8805 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PWM_GH_CBUS_BASE = 0x84
// -----------------------------------------------
#define PWM_PWM_G ((0x8400 << 2) + 0xffd00000)
#define PWM_PWM_H ((0x8401 << 2) + 0xffd00000)
#define PWM_MISC_REG_GH ((0x8402 << 2) + 0xffd00000)
#define PWM_DELTA_SIGMA_GH ((0x8403 << 2) + 0xffd00000)
#define PWM_TIME_GH ((0x8404 << 2) + 0xffd00000)
#define PWM_G2 ((0x8405 << 2) + 0xffd00000)
#define PWM_H2 ((0x8406 << 2) + 0xffd00000)
#define PWM_BLINK_GH ((0x8407 << 2) + 0xffd00000)
#define PWM_LOCK_GH ((0x8408 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  CIPLUS_CBUS_BASE = 0x80
// -----------------------------------------------
#define CIPLUS_CMD_REG ((0x8000 << 2) + 0xffd00000)
#define CIPLUS_RDATA_REG ((0x8001 << 2) + 0xffd00000)
#define CIPLUS_CTRL_REG ((0x8002 << 2) + 0xffd00000)
#define CIPLUS_DELAY_CTRL0 ((0x8003 << 2) + 0xffd00000)
#define CIPLUS_DELAY_CTRL1 ((0x8004 << 2) + 0xffd00000)
#define CIPLUS_WAIT_TIMEOUT ((0x8005 << 2) + 0xffd00000)
#define CIPLUS_STATUS_REG ((0x8006 << 2) + 0xffd00000)
// ----------------------------
// SANA (Stream Analyzer)
// ----------------------------
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  SANA_CBUS_BASE = 0x30
// -----------------------------------------------
// [31:16] - ddr_setting
// [15]    - disable_stream_clock_gating
// [14:13] - mem_pd_ctl_sana
// [6:4]   - stream_fetch_endian
// [3]     - use_parser_vbuf_wp
// [2]     - use_parser_vbuf2_wp
// [1]     - stream_fetch_busy - Read Only
// [0]     - stream_fetch_enable
#define SANA_STREAM_CONTROL ((0x3020 << 2) + 0xffd00000)
#define SANA_STREAM_START_ADDR ((0x3021 << 2) + 0xffd00000)
#define SANA_STREAM_END_ADDR ((0x3022 << 2) + 0xffd00000)
// SW stream_buffer_wr_ptr
#define SANA_STREAM_WR_PTR ((0x3023 << 2) + 0xffd00000)
#define SANA_STREAM_RD_PTR ((0x3024 << 2) + 0xffd00000)
//[31:0] stream_buffer_level - read only
#define SANA_STREAM_LEVEL ((0x3025 << 2) + 0xffd00000)
// [31:29] stream_buffer_hole 256*(4^0) bytes
// [28:23] stream_fifo_hole
// [22:16] stream_fifo_level
// [15]    stream_fifo_wr_ptr_update_en
// [14:8]  stream_fifo_wr_ptr
// [7]     stream_fifo_rd_ptr_update_en
// [6:0]   stream_fifo_rd_ptr
#define SANA_STREAM_FIFO_CTL ((0x3026 << 2) + 0xffd00000)
// [31:18] - Reserved
// [17]    - sana_int_enable
// [16]    - sana_int_level (default : 0(pulse))
// [15]    - disable_shift_clock_gating
// [14]    - startcode_protect -- TODO
// [8:6]   - sft_valid_wr_position (default : 3 (at least 24 bits available))
// [5:4]   - emulate_code_length_sub_1(Default : 2)
// [3]     - emulation_auto_on_startcode(Default : 0)
// [2:1]   - start_code_length_sub_1(Default : 2)
// [0]     - stream_shift_enable(Default : 0)
#define SANA_SHIFT_CONTROL ((0x3027 << 2) + 0xffd00000)
// [31:0]  - max 4-bytes start code (Default : 0x00000100)
#define SANA_SHIFT_STARTCODE ((0x3028 << 2) + 0xffd00000)
// [31:0]  - max 4-bytes emulate code (Default : 0x00000300)
#define SANA_SHIFT_EMULATECODE ((0x3029 << 2) + 0xffd00000)
// [3]     - sana_int
// [2]     - startcode_searching
// [1]     - emulation_check_on
// [0]     - startcode_check_on
#define SANA_SHIFT_STATUS ((0x302a << 2) + 0xffd00000)
// [31:0] sana_shifted_data - read only
#define SANA_SHIFTED_DATA ((0x302b << 2) + 0xffd00000)
// [31:0] shift_byte_count[31:0]
#define SANA_SHIFT_BYTE_COUNT ((0x302c << 2) + 0xffd00000)
// [31:28] - shift_byte_count[35:32]
// [27:20] - element_read_data[31:24]
// [10]    - bytealign
// [9]     - signed_element
// [8]     - start_element_read
// [7]     - shift_busy
// [6:0]   - shift_bits
#define SANA_SHIFT_COMMAND ((0x302d << 2) + 0xffd00000)
// 31:8    - element_read_data[23:0]
//  7:2    - element_read_length
//  1:0    - element_read_state
#define SANA_ELEMENT_RESULT ((0x302e << 2) + 0xffd00000)
// support up to 8 masters, one bit per master
// 23:16   - lock_release (Write 1 to release)
// 15:8    - lock_req (write 1 to request)
//  7:0    - lock_result (Read Only)
#define ATOM_LOCK ((0x302f << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  I2C_M_0_CBUS_BASE = 0x7c
// -----------------------------------------------
#define I2C_M_0_CONTROL_REG ((0x7c00 << 2) + 0xffd00000)
#define I2C_M_MANUAL_SDA_I 26
#define I2C_M_MANUAL_SCL_I 25
#define I2C_M_MANUAL_SDA_O 24
#define I2C_M_MANUAL_SCL_O 23
#define I2C_M_MANUAL_EN 22
#define I2C_M_DELAY_MSB 21
#define I2C_M_DELAY_LSB 12
#define I2C_M_DATA_CNT_MSB 11
#define I2C_M_DATA_CNT_LSB 8
#define I2C_M_CURR_TOKEN_MSB 7
#define I2C_M_CURR_TOKEN_LSB 4
#define I2C_M_ERROR 3
#define I2C_M_STATUS 2
#define I2C_M_ACK_IGNORE 1
#define I2C_M_START 0
#define I2C_M_0_SLAVE_ADDR ((0x7c01 << 2) + 0xffd00000)
#define I2C_M_0_TOKEN_LIST0 ((0x7c02 << 2) + 0xffd00000)
#define I2C_M_0_TOKEN_LIST1 ((0x7c03 << 2) + 0xffd00000)
#define I2C_M_0_WDATA_REG0 ((0x7c04 << 2) + 0xffd00000)
#define I2C_M_0_WDATA_REG1 ((0x7c05 << 2) + 0xffd00000)
#define I2C_M_0_RDATA_REG0 ((0x7c06 << 2) + 0xffd00000)
#define I2C_M_0_RDATA_REG1 ((0x7c07 << 2) + 0xffd00000)
#define I2C_M_0_TIMEOUT_TH ((0x7c08 << 2) + 0xffd00000)
// -----------------------------------------------
// CBUS_BASE:  I2C_M_1_CBUS_BASE = 0x78
// -----------------------------------------------
#define I2C_M_1_CONTROL_REG ((0x7800 << 2) + 0xffd00000)
#define I2C_M_1_SLAVE_ADDR ((0x7801 << 2) + 0xffd00000)
#define I2C_M_1_TOKEN_LIST0 ((0x7802 << 2) + 0xffd00000)
#define I2C_M_1_TOKEN_LIST1 ((0x7803 << 2) + 0xffd00000)
#define I2C_M_1_WDATA_REG0 ((0x7804 << 2) + 0xffd00000)
#define I2C_M_1_WDATA_REG1 ((0x7805 << 2) + 0xffd00000)
#define I2C_M_1_RDATA_REG0 ((0x7806 << 2) + 0xffd00000)
#define I2C_M_1_RDATA_REG1 ((0x7807 << 2) + 0xffd00000)
#define I2C_M_1_TIMEOUT_TH ((0x7808 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  I2C_M_2_CBUS_BASE = 0x74
// -----------------------------------------------
#define I2C_M_2_CONTROL_REG ((0x7400 << 2) + 0xffd00000)
#define I2C_M_2_SLAVE_ADDR ((0x7401 << 2) + 0xffd00000)
#define I2C_M_2_TOKEN_LIST0 ((0x7402 << 2) + 0xffd00000)
#define I2C_M_2_TOKEN_LIST1 ((0x7403 << 2) + 0xffd00000)
#define I2C_M_2_WDATA_REG0 ((0x7404 << 2) + 0xffd00000)
#define I2C_M_2_WDATA_REG1 ((0x7405 << 2) + 0xffd00000)
#define I2C_M_2_RDATA_REG0 ((0x7406 << 2) + 0xffd00000)
#define I2C_M_2_RDATA_REG1 ((0x7407 << 2) + 0xffd00000)
#define I2C_M_2_TIMEOUT_TH ((0x7408 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  I2C_M_3_CBUS_BASE = 0x70
// -----------------------------------------------
#define I2C_M_3_CONTROL_REG ((0x7000 << 2) + 0xffd00000)
#define I2C_M_3_SLAVE_ADDR ((0x7001 << 2) + 0xffd00000)
#define I2C_M_3_TOKEN_LIST0 ((0x7002 << 2) + 0xffd00000)
#define I2C_M_3_TOKEN_LIST1 ((0x7003 << 2) + 0xffd00000)
#define I2C_M_3_WDATA_REG0 ((0x7004 << 2) + 0xffd00000)
#define I2C_M_3_WDATA_REG1 ((0x7005 << 2) + 0xffd00000)
#define I2C_M_3_RDATA_REG0 ((0x7006 << 2) + 0xffd00000)
#define I2C_M_3_RDATA_REG1 ((0x7007 << 2) + 0xffd00000)
#define I2C_M_3_TIMEOUT_TH ((0x7008 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PWM_AB_CBUS_BASE = 0x6c
// -----------------------------------------------
#define PWM_PWM_A ((0x6c00 << 2) + 0xffd00000)
#define PWM_PWM_B ((0x6c01 << 2) + 0xffd00000)
#define PWM_MISC_REG_AB ((0x6c02 << 2) + 0xffd00000)
#define PWM_DELTA_SIGMA_AB ((0x6c03 << 2) + 0xffd00000)
#define PWM_TIME_AB ((0x6c04 << 2) + 0xffd00000)
#define PWM_A2 ((0x6c05 << 2) + 0xffd00000)
#define PWM_B2 ((0x6c06 << 2) + 0xffd00000)
#define PWM_BLINK_AB ((0x6c07 << 2) + 0xffd00000)
#define PWM_LOCK_AB ((0x6c08 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PWM_CD_CBUS_BASE = 0x68
// -----------------------------------------------
#define PWM_PWM_C ((0x6800 << 2) + 0xffd00000)
#define PWM_PWM_D ((0x6801 << 2) + 0xffd00000)
#define PWM_MISC_REG_CD ((0x6802 << 2) + 0xffd00000)
#define PWM_DELTA_SIGMA_CD ((0x6803 << 2) + 0xffd00000)
#define PWM_TIME_CD ((0x6804 << 2) + 0xffd00000)
#define PWM_C2 ((0x6805 << 2) + 0xffd00000)
#define PWM_D2 ((0x6806 << 2) + 0xffd00000)
#define PWM_BLINK_CD ((0x6807 << 2) + 0xffd00000)
#define PWM_LOCK_CD ((0x6808 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PWM_EF_CBUS_BASE = 0x64
// -----------------------------------------------
#define PWM_PWM_E ((0x6400 << 2) + 0xffd00000)
#define PWM_PWM_F ((0x6401 << 2) + 0xffd00000)
#define PWM_MISC_REG_EF ((0x6402 << 2) + 0xffd00000)
#define PWM_DELTA_SIGMA_EF ((0x6403 << 2) + 0xffd00000)
#define PWM_TIME_EF ((0x6404 << 2) + 0xffd00000)
#define PWM_E2 ((0x6405 << 2) + 0xffd00000)
#define PWM_F2 ((0x6406 << 2) + 0xffd00000)
#define PWM_BLINK_EF ((0x6407 << 2) + 0xffd00000)
#define PWM_LOCK_EF ((0x6408 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  MSR_CLK_CBUS_BASE = 0x60
// -----------------------------------------------
#define MSR_CLK_DUTY ((0x6000 << 2) + 0xffd00000)
#define MSR_CLK_REG0 ((0x6001 << 2) + 0xffd00000)
#define MSR_CLK_REG1 ((0x6002 << 2) + 0xffd00000)
#define MSR_CLK_REG2 ((0x6003 << 2) + 0xffd00000)
#define MSR_CLK_REG3 ((0x6004 << 2) + 0xffd00000)
#define MSR_CLK_REG4 ((0x6005 << 2) + 0xffd00000)
#define MSR_CLK_REG5 ((0x6006 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  STEAM_CBUS_BASE = 0x2c
// -----------------------------------------------
// bit 31:24 -- event_length
// bit 23:22 -- bus_1st_sel_1  //00-gpio, 01-reserved, 10-addr, 11-data
// bit 21:20 -- bus_2nd_sel_1
// bit 19:18 -- bus_1st_sel_0
// bit 17:16 -- bus_2nd_sel_0
// bit 15:0 -- set output value (output 1 will read according to external input)
#define STREAM_EVENT_INFO ((0x2c00 << 2) + 0xffd00000)
// bit 31    -- force_parity_1
// bit 30    -- LSB_first
// bit 31:20 -- reserved
// bit 19:16 -- toggle point index
// bit 15:8  -- output togle point1
// bit 7:0   -- output togle point0 (0xff means input)
#define STREAM_OUTPUT_CONFIG ((0x2c01 << 2) + 0xffd00000)
// bit 31:24 -- clock_divide_ext
// bit 23:20 -- s_bus_start ( sclk, sdataout, sdatain)  // 0 means no s_bus used
// bit 19    -- no_sclk_on_pin // will use internal write clock and read clock (like RS232)
// bit 18    -- invert_sclk_in
// bit 17    -- sdata_send_busy  // indicate one data is sending -- read only
// bit 16    -- one_sdata_received // set when one sdata is received, can write 0 to clear
// bit 15    -- sdata_parity  // (write -- 0-even, 1-odd) (read -- received parity check)
// bit 14    -- sdata_send_type  // 0 -- 8 bits  1 -- 32 bits ( for fujitsu only )
// bit 13    -- sdata_receive_type // 0 -- 8 bits only  1 -- 8/32 bits
// bit 12    -- invert_request_out
// bit 11:8  -- request_out_sel  // 0 means disable output
// bit 7:0   --  stop_request_count
#define C_D_BUS_CONTROL ((0x2c02 << 2) + 0xffd00000)
// bit 31:0  -- serial data (write: output one data, read: input data)
#define C_DATA ((0x2c03 << 2) + 0xffd00000)
// bit 31:28 bus_width_1
// bit 27:24 bus_start_pin_1
// bit 23:16 bus_sel_chang_point_1
// bit 15:12 bus_width_0
// bit 11:08 bus_start_pin_0
// bit 07:00 bus_sel_chang_point_0
#define STREAM_BUS_CONFIG ((0x2c04 << 2) + 0xffd00000)
// bit 31:24 clock_divide
// bit 23:20 clock_output_sel  -- 0 means disable clock output
// bit 19 -- inc_event_addr
// bit 18 -- async_fifo_endian
// bit 17 -- send_to_async_fifo
// bit 16 -- data_in_serial_lsb
// bit 15 -- invert_no_wait_condition_0
// bit 14 -- invert_no_wait_condition_1
// bit 13 -- invert_no_wait_condition_2
// bit 12 -- invert_data_bus
// bit 11 -- invert_clock_in
// bit 10 -- event_wait_clk_en
// bit 9 -- data_in_serial
// bit 8 -- invert_data_in_clk
// bit 7:4  -- data_in_begin
// bit 3:0  -- data_in_clk_sel
#define STREAM_DATA_IN_CONFIG ((0x2c05 << 2) + 0xffd00000)
// wait condition and irq should not be connected to 0, 0 means disable)
// bit 31:28 -- no_wait_condition_0   (0 means disable this condition)
// bit 27:24 -- no_wait_condition_1   (0 means disable this condition)
// bit 23:20 -- no_wait_condition_2   (0 means disable this condition)
// bit 19:16 -- irq_input_sel         (0 means disable this interrupt)
// bit 15:13 -- interrupt_status (read) clear status (write) (ext 0, ext 1, transfer end)
// bit 12 -- enable_sdata_irq
// bit 11 -- invert_irq_0
// bit 10 -- invert_irq_1
// bit  9 -- enable_transfer_end_irq
// bit  8 -- enable_second_ext_irq
// bit 7:0 -- no_wait_condition_check_point (0xff means no check)
#define STREAM_WAIT_IRQ_CONFIG ((0x2c06 << 2) + 0xffd00000)
// bit 31:24 -- event address
// bit 23:16 -- event data
// bit 15:1 -- event repeat times  (0 means one time event)
// bit 0  -- Start Event (write) event_busy (read)
#define STREAM_EVENT_CTL ((0x2c07 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  SYNC_FIFO_CBUS_BASE = 0x28
// -----------------------------------------------
#define ASYNC_FIFO_REG0 ((0x2800 << 2) + 0xffd00000)
#define ASYNC_FIFO_REG1 ((0x2801 << 2) + 0xffd00000)
#define ASYNC_FIFO_FLUSH_STATUS 31
#define ASYNC_FIFO_ERR 30
#define ASYNC_FIFO_FIFO_EMPTY 29
#define ASYNC_FIFO_TO_HIU 24
#define ASYNC_FIFO_FLUSH 23
#define ASYNC_FIFO_RESET 22
#define ASYNC_FIFO_WRAP_EN 21
#define ASYNC_FIFO_FLUSH_EN 20
#define ASYNC_FIFO_RESIDUAL_MSB 19
#define ASYNC_FIFO_RESIDUAL_LSB 15
#define ASYNC_FIFO_FLUSH_CNT_MSB 14
#define ASYNC_FIFO_FLUSH_CNT_LSB 0
#define ASYNC_FIFO_REG2 ((0x2802 << 2) + 0xffd00000)
#define ASYNC_FIFO_FIFO_FULL 26
#define ASYNC_FIFO_FILL_STATUS 25
#define ASYNC_FIFO_SOURCE_MSB 24
#define ASYNC_FIFO_SOURCE_LSB 23
#define ASYNC_FIFO_ENDIAN_MSB 22
#define ASYNC_FIFO_ENDIAN_LSB 21
#define ASYNC_FIFO_FILL_EN 20
#define ASYNC_FIFO_FILL_CNT_MSB 19
#define ASYNC_FIFO_FILL_CNT_LSB 0
#define ASYNC_FIFO_REG3 ((0x2803 << 2) + 0xffd00000)
#define ASYNC_FLUSH_SIZE_IRQ_MSB 15
#define ASYNC_FLUSH_SIZE_IRQ_LSB 0
#define ASYNC_FIFO_REG4 ((0x2804 << 2) + 0xffd00000)
#define ASYNC_FIFO_REG5 ((0x2805 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  SYNC_FIFO2_CBUS_BASE = 0x24
// -----------------------------------------------
#define ASYNC_FIFO2_REG0 ((0x2400 << 2) + 0xffd00000)
#define ASYNC_FIFO2_REG1 ((0x2401 << 2) + 0xffd00000)
#define ASYNC_FIFO2_REG2 ((0x2402 << 2) + 0xffd00000)
#define ASYNC_FIFO2_REG3 ((0x2403 << 2) + 0xffd00000)
#define ASYNC_FIFO2_REG4 ((0x2404 << 2) + 0xffd00000)
#define ASYNC_FIFO2_REG5 ((0x2405 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  SYNC_FIFO3_CBUS_BASE = 0x98
// -----------------------------------------------
#define ASYNC_FIFO3_REG0 ((0x9800 << 2) + 0xffd00000)
#define ASYNC_FIFO3_REG1 ((0x9801 << 2) + 0xffd00000)
#define ASYNC_FIFO3_REG2 ((0x9802 << 2) + 0xffd00000)
#define ASYNC_FIFO3_REG3 ((0x9803 << 2) + 0xffd00000)
#define ASYNC_FIFO3_REG4 ((0x9804 << 2) + 0xffd00000)
#define ASYNC_FIFO3_REG5 ((0x9805 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  SPIFC_CBUS_BASE = 0x50
// -----------------------------------------------
#define SPI_FLASH_CMD ((0x5000 << 2) + 0xffd00000)
#define SPI_FLASH_READ 31
#define SPI_FLASH_WREN 30
#define SPI_FLASH_WRDI 29
#define SPI_FLASH_RDID 28
#define SPI_FLASH_RDSR 27
#define SPI_FLASH_WRSR 26
#define SPI_FLASH_PP 25
#define SPI_FLASH_SE 24
#define SPI_FLASH_BE 23
#define SPI_FLASH_CE 22
#define SPI_FLASH_DP 21
#define SPI_FLASH_RES 20
#define SPI_HPM 19
#define SPI_FLASH_USR 18
#define SPI_FLASH_USR_ADDR 15
#define SPI_FLASH_USR_DUMMY 14
#define SPI_FLASH_USR_DIN 13
#define SPI_FLASH_USR_DOUT 12
#define SPI_FLASH_USR_DUMMY_BLEN 10
#define SPI_FLASH_USR_CMD 0
#define SPI_FLASH_ADDR ((0x5001 << 2) + 0xffd00000)
#define SPI_FLASH_BYTES_LEN 24
#define SPI_FLASH_ADDR_START 0
#define SPI_FLASH_CTRL ((0x5002 << 2) + 0xffd00000)
#define SPI_ENABLE_AHB 17
#define SPI_SST_AAI 16
#define SPI_RES_RID 15
#define SPI_FREAD_DUAL 14
#define SPI_READ_READ_EN 13
#define SPI_CLK_DIV0 12
#define SPI_CLKCNT_N 8
#define SPI_CLKCNT_H 4
#define SPI_CLKCNT_L 0
#define SPI_FLASH_CTRL1 ((0x5003 << 2) + 0xffd00000)
#define SPI_FLASH_STATUS ((0x5004 << 2) + 0xffd00000)
#define SPI_FLASH_CTRL2 ((0x5005 << 2) + 0xffd00000)
#define SPI_FLASH_CLOCK ((0x5006 << 2) + 0xffd00000)
#define SPI_FLASH_USER ((0x5007 << 2) + 0xffd00000)
#define SPI_FLASH_USER1 ((0x5008 << 2) + 0xffd00000)
#define SPI_FLASH_USER2 ((0x5009 << 2) + 0xffd00000)
#define SPI_FLASH_USER3 ((0x500a << 2) + 0xffd00000)
#define SPI_FLASH_USER4 ((0x500b << 2) + 0xffd00000)
#define SPI_FLASH_SLAVE ((0x500c << 2) + 0xffd00000)
#define SPI_FLASH_SLAVE1 ((0x500d << 2) + 0xffd00000)
#define SPI_FLASH_SLAVE2 ((0x500e << 2) + 0xffd00000)
#define SPI_FLASH_SLAVE3 ((0x500f << 2) + 0xffd00000)
#define SPI_FLASH_C0 ((0x5010 << 2) + 0xffd00000)
#define SPI_FLASH_C1 ((0x5011 << 2) + 0xffd00000)
#define SPI_FLASH_C2 ((0x5012 << 2) + 0xffd00000)
#define SPI_FLASH_C3 ((0x5013 << 2) + 0xffd00000)
#define SPI_FLASH_C4 ((0x5014 << 2) + 0xffd00000)
#define SPI_FLASH_C5 ((0x5015 << 2) + 0xffd00000)
#define SPI_FLASH_C6 ((0x5016 << 2) + 0xffd00000)
#define SPI_FLASH_C7 ((0x5017 << 2) + 0xffd00000)
#define SPI_FLASH_B8 ((0x5018 << 2) + 0xffd00000)
#define SPI_FLASH_B9 ((0x5019 << 2) + 0xffd00000)
#define SPI_FLASH_B10 ((0x501a << 2) + 0xffd00000)
#define SPI_FLASH_B11 ((0x501b << 2) + 0xffd00000)
#define SPI_FLASH_B12 ((0x501c << 2) + 0xffd00000)
#define SPI_FLASH_B13 ((0x501d << 2) + 0xffd00000)
#define SPI_FLASH_B14 ((0x501e << 2) + 0xffd00000)
#define SPI_FLASH_B15 ((0x501f << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// spicc 0
// -----------------------------------------------
// CBUS_BASE:  SPICC0_CBUS_BASE = 0x4c
// -----------------------------------------------
#define SPICC0_RXDATA ((0x4c00 << 2) + 0xffd00000)
#define SPICC0_TXDATA ((0x4c01 << 2) + 0xffd00000)
#define SPICC0_CONREG ((0x4c02 << 2) + 0xffd00000)
#define SPICC0_INTREG ((0x4c03 << 2) + 0xffd00000)
#define SPICC0_DMAREG ((0x4c04 << 2) + 0xffd00000)
#define SPICC0_STATREG ((0x4c05 << 2) + 0xffd00000)
#define SPICC0_PERIODREG ((0x4c06 << 2) + 0xffd00000)
#define SPICC0_TESTREG ((0x4c07 << 2) + 0xffd00000)
#define SPICC0_DRADDR ((0x4c08 << 2) + 0xffd00000)
#define SPICC0_DWADDR ((0x4c09 << 2) + 0xffd00000)
#define SPICC0_LD_CNTL0 ((0x4c0a << 2) + 0xffd00000)
#define SPICC0_LD_CNTL1 ((0x4c0b << 2) + 0xffd00000)
#define SPICC0_LD_RADDR ((0x4c0c << 2) + 0xffd00000)
#define SPICC0_LD_WADDR ((0x4c0d << 2) + 0xffd00000)
#define SPICC0_ENHANCE_CNTL ((0x4c0e << 2) + 0xffd00000)
#define SPICC0_ENHANCE_CNTL1 ((0x4c0f << 2) + 0xffd00000)
#define SPICC0_ENHANCE_CNTL2 ((0x4c10 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// spicc 1
// -----------------------------------------------
// CBUS_BASE:  SPICC1_CBUS_BASE = 0x54
// -----------------------------------------------
#define SPICC1_RXDATA ((0x5400 << 2) + 0xffd00000)
#define SPICC1_TXDATA ((0x5401 << 2) + 0xffd00000)
#define SPICC1_CONREG ((0x5402 << 2) + 0xffd00000)
#define SPICC1_INTREG ((0x5403 << 2) + 0xffd00000)
#define SPICC1_DMAREG ((0x5404 << 2) + 0xffd00000)
#define SPICC1_STATREG ((0x5405 << 2) + 0xffd00000)
#define SPICC1_PERIODREG ((0x5406 << 2) + 0xffd00000)
#define SPICC1_TESTREG ((0x5407 << 2) + 0xffd00000)
#define SPICC1_DRADDR ((0x5408 << 2) + 0xffd00000)
#define SPICC1_DWADDR ((0x5409 << 2) + 0xffd00000)
#define SPICC1_LD_CNTL0 ((0x540a << 2) + 0xffd00000)
#define SPICC1_LD_CNTL1 ((0x540b << 2) + 0xffd00000)
#define SPICC1_LD_RADDR ((0x540c << 2) + 0xffd00000)
#define SPICC1_LD_WADDR ((0x540d << 2) + 0xffd00000)
#define SPICC1_ENHANCE_CNTL ((0x540e << 2) + 0xffd00000)
#define SPICC1_ENHANCE_CNTL1 ((0x540f << 2) + 0xffd00000)
#define SPICC1_ENHANCE_CNTL2 ((0x5410 << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// spicc 2
// -----------------------------------------------
// CBUS_BASE:  SPICC2_CBUS_BASE = 0x58
// -----------------------------------------------
#define SPICC2_RXDATA ((0x5800 << 2) + 0xffd00000)
#define SPICC2_TXDATA ((0x5801 << 2) + 0xffd00000)
#define SPICC2_CONREG ((0x5802 << 2) + 0xffd00000)
#define SPICC2_INTREG ((0x5803 << 2) + 0xffd00000)
#define SPICC2_DMAREG ((0x5804 << 2) + 0xffd00000)
#define SPICC2_STATREG ((0x5805 << 2) + 0xffd00000)
#define SPICC2_PERIODREG ((0x5806 << 2) + 0xffd00000)
#define SPICC2_TESTREG ((0x5807 << 2) + 0xffd00000)
#define SPICC2_DRADDR ((0x5808 << 2) + 0xffd00000)
#define SPICC2_DWADDR ((0x5809 << 2) + 0xffd00000)
#define SPICC2_LD_CNTL0 ((0x580a << 2) + 0xffd00000)
#define SPICC2_LD_CNTL1 ((0x580b << 2) + 0xffd00000)
#define SPICC2_LD_RADDR ((0x580c << 2) + 0xffd00000)
#define SPICC2_LD_WADDR ((0x580d << 2) + 0xffd00000)
#define SPICC2_ENHANCE_CNTL ((0x580e << 2) + 0xffd00000)
#define SPICC2_ENHANCE_CNTL1 ((0x580f << 2) + 0xffd00000)
#define SPICC2_ENHANCE_CNTL2 ((0x5810 << 2) + 0xffd00000)
//
//// -------------------------------------------------------------------
//// PSEL Group #1:  0x400 ~ 0x7FF
//// -------------------------------------------------------------------
//`define  PERIPHS1_CBUS_BASE   8'h28
//
//
//
//// ----------------------------
//// IR Remote (8)
//// ----------------------------
//`define IR_DEC_LDR_ACTIVE               8'h20
//`define IR_DEC_LDR_IDLE                 8'h21
//`define IR_DEC_LDR_REPEAT               8'h22
//`define IR_DEC_BIT_0                    8'h23
//`define IR_DEC_REG0                     8'h24
//`define IR_DEC_FRAME                    8'h25
//`define IR_DEC_STATUS                   8'h26
//`define IR_DEC_REG1                     8'h27
//
//// ----------------------------
//// Demod Sampling
//// ----------------------------
//`define DEMOD_ADC_SAMPLING               8'h2d
//// ----------------------------
//// WIFI
//// ----------------------------
//// `define WIFI_ADC_SAMPLING               8'h2e
//// `define WIFI_ADC_READBACK               8'h2f
//
//
//// ---------------------------
//// EFUSE (4)
//// ----------------------------
//// Moved to the Secure APB3 bus
//// `define EFUSE_CNTL0                     8'h58
//// `define EFUSE_CNTL1                     8'h59
//// `define EFUSE_CNTL2                     8'h5a
//// `define EFUSE_CNTL3                     8'h5b
//// `define EFUSE_CNTL4                     8'h5c
//
//// ---------------------------------------------
//// Separate APB slave that shares the CBUS/APB
//// register space of the static registers
//// ---------------------------------------------
//
//`define ATAPI_IDEREG0                   8'h60
//   `define IDE_UDMA_PIO_STATE         15
//   `define IDE_BUSY                   14
//   `define IDE_ERROR_BIT              13
//   `define IDE_DMARQ_BIT              12
//   `define IDE_IORDY_BIT              11
//   `define IDE_IORDY_EN_BIT           10
//   `define IDE_DIS_CSEL_BIT            9
//   `define IDE_CSEL_BIT                8
//   `define IDE_IRQ14                   2
//   `define IDE_ATAPI_GPIO_EN           3
//   `define IDE_DMARQ_FULL              1
//   `define IDE_ENABLE                  0
//`define ATAPI_IDEREG1                   8'h61
//`define ATAPI_IDEREG2                   8'h62
//    `define IDE_XFER_CNT_MSB_BIT      18
//    `define IDE_XFER_CNT_LSB_BIT       0
//`define ATAPI_CYCTIME                   8'h63
//`define ATAPI_IDETIME                   8'h64
//`define ATAPI_PIO_TIMING                8'h65
//`define ATAPI_TABLE_ADD_REG             8'h66
//`define ATAPI_IDEREG3                   8'h67
//`define ATAPI_UDMA_REG0                 8'h68
//`define ATAPI_UDMA_REG1                 8'h69
//
//// Room for registers here
//
//`define TRANS_PWMA_REG0                 8'h70
//`define TRANS_PWMA_REG1                 8'h71
//`define TRANS_PWMA_MUX0                 8'h72
//`define TRANS_PWMA_MUX1                 8'h73
//`define TRANS_PWMA_MUX2                 8'h74
//`define TRANS_PWMA_MUX3                 8'h75
//`define TRANS_PWMA_MUX4                 8'h76
//`define TRANS_PWMA_MUX5                 8'h77
//
//`define TRANS_PWMB_REG0                 8'h78
//`define TRANS_PWMB_REG1                 8'h79
//`define TRANS_PWMB_MUX0                 8'h7a
//`define TRANS_PWMB_MUX1                 8'h7b
//`define TRANS_PWMB_MUX2                 8'h7c
//`define TRANS_PWMB_MUX3                 8'h7d
//`define TRANS_PWMB_MUX4                 8'h7e
//`define TRANS_PWMB_MUX5                 8'h7f
//
//
//
//// ----------------------------
//// NAND (21)
//// ----------------------------
//`define NAND_START                      8'h80
//`define NAND_ADR_CMD                    8'h8a
//`define NAND_ADR_STS                    8'h8b
//`define NAND_END                        8'h8f
//
//// ----------------------------
//// ISP_FLASH_LED_CTRL
//// ----------------------------
////bit 31, reg_led_en //rising pulse start, falling pulse stop for torch mode
////bit 30, reg_inc_i_st_lat //for as3685, dynamic increase current during st_latch
////bit 29:28, reg_inv_en_pol //bit[29], invert en1, bit [28], invert en2
////bit 27, reg_switch_en1en2  //switch output en1 and en2. For IS3231: en1 is EN, en2 is mode.
////bit 26, reg_force_off_mode //1: reset state machine at the falling edge no matter which state
/// it is in /bit 25, reg_hold_nonstd_off_mode //hold the non-std led_off signal input before
/// state "OFF" /bit 24, reg_flash_mode_timeout_en  //force to exit the Tlat state when time out,
///for flash mode protection /bit 23, reg_en1_st_ini_level //en1 level during state ST_INI /bit
/// 22, reg_en2_st_set_mp_level //en2 level during state ST_SET_MP_HI, ST_SET_MP_LO /bit 21,
/// reg_en1_st_off_level //en1 level during state ST_OFF /bit 20, reg_en2_st_off_level //en2 level
/// during state ST_OFF /bit 19:12, reg_en1_mp_num  //en1 multi pulse number, up to 256 step
/// current control /bit 10:0, reg_t_st_ini //Max: 85.2 us under 24M clock input
//`define ISP_LED_CTRL                    8'h98
//
////bit 31:21, reg_t_en1_inc_i_st_lat_cnt //Max: 85.2us under 24M. for as3685, dynamic increase
/// current during st_latch /bit 20:10, reg_t_en2_lo_st_ini //Max: 85.2 us under 24M clock input
////bit 9:0, reg_t_en2_hi1_st_lat_cnt //42.62us @24M, EN2 can output hi-lo-hi during ST_LATCH,
/// this is the first lo -duration
//`define ISP_LED_TIMING1                 8'h99
//
////bit 31:21, reg_t_en1_mp_hi_cnt //Max: 85.2 us under 24M clock input, mp means multi pulse
////bit 20:10, reg_t_en1_mp_lo_cnt //Max: 85.2 us under 24M clock input, mp means multi pulse
////bit 9:0, reg_t_en2_lo1_st_lat_cnt //42.62us @24M, EN2 can output hi-lo-hi during ST_LATCH,
/// this is the first lo -duration
//`define ISP_LED_TIMING2                 8'h9a
//
////bit 30:28, RO state
////bit 25:0, reg_flash_mode_timeout_cnt //up to 2.79s at 24Mhz clk input
//`define ISP_LED_TIMING3                 8'h9b
//
////bit 25:0, reg_t_st_lat_cnt //up to 2.79s, keep the led on if it's 26'h3ffffff under torch mode
//`define ISP_LED_TIMING4                 8'h9c
//
////bit 31:26, reg_t_st_off_cnt[5:0] //up to 85.2us OFF state.
////bit 25:0, reg_t_en2_hi2_st_lat_cnt //EN2 can output hi-lo-hi during ST_LATCH, this is the
/// second hi -duration
//`define ISP_LED_TIMING5                 8'h9d
//
////bit 30:26, reg_t_st_off_cnt[10:6] //up to 85.2us OFF state.
////bit 25:0, reg_t_en1_st_lat_hold_cnt //to make sure Tlat to meat it's minimum request 500us
///(since non-std led_off signal may comes in anytime)
//`define ISP_LED_TIMING6                 8'h9e
//// ----------------------------
//// SAR ADC (16)
//// ----------------------------
////`define SAR_ADC_REG0                    8'ha0
////`define SAR_ADC_CHAN_LIST               8'ha1
////`define SAR_ADC_AVG_CNTL                8'ha2
////`define SAR_ADC_REG3                    8'ha3
////`define SAR_ADC_DELAY                   8'ha4
////`define SAR_ADC_LAST_RD                 8'ha5
////`define SAR_ADC_FIFO_RD                 8'ha6
////`define SAR_ADC_AUX_SW                  8'ha7
////`define SAR_ADC_CHAN_10_SW              8'ha8
////`define SAR_ADC_DETECT_IDLE_SW          8'ha9
////`define SAR_ADC_DELTA_10                8'haa
////`define SAR_ADC_REG11                   8'hab
////`define SAR_ADC_REG12                   8'hac
////`define SAR_ADC_REG13                   8'had
//
//// ----------------------------
//// CTouch (16)
//// ----------------------------
//
//
//// ---------------------------
//// RTC (4)
//// ---------------------------
//`define RTC_ADDR0                      8'hd0
//`define RTC_ADDR1                      8'hd1
//`define RTC_ADDR2                      8'hd2
//`define RTC_ADDR3                      8'hd3
//`define RTC_ADDR4                      8'hd4
//// ----------------------------
//// clock measure (4)
//// ----------------------------
//
//
//
//// -------------------------------------------------------------------
//// PSEL Group #2:  0x800 ~ 0xbFF
//// -------------------------------------------------------------------
//`define  PERIPHS2_CBUS_BASE   8'h2c
//
//`define USB_ADDR0                      8'h00
//`define USB_ADDR1                      8'h01
//`define USB_ADDR2                      8'h02
//`define USB_ADDR3                      8'h03
//`define USB_ADDR4                      8'h04
//`define USB_ADDR5                      8'h05
//`define USB_ADDR6                      8'h06
//`define USB_ADDR7                      8'h07
//`define USB_ADDR8                      8'h08
//`define USB_ADDR9                      8'h09
//`define USB_ADDR10                     8'h0a
//`define USB_ADDR11                     8'h0b
//`define USB_ADDR12                     8'h0c
//`define USB_ADDR13                     8'h0d
//`define USB_ADDR14                     8'h0e
//`define USB_ADDR15                     8'h0f
//
//`define USB_ADDR16                     8'h10
//`define USB_ADDR17                     8'h11
//`define USB_ADDR18                     8'h12
//`define USB_ADDR19                     8'h13
//`define USB_ADDR20                     8'h14
//`define USB_ADDR21                     8'h15
//`define USB_ADDR22                     8'h16
//`define USB_ADDR23                     8'h17
//`define USB_ADDR24                     8'h18
//`define USB_ADDR25                     8'h19
//`define USB_ADDR26                     8'h1a
//`define USB_ADDR27                     8'h1b
//`define USB_ADDR28                     8'h1c
//`define USB_ADDR29                     8'h1d
//`define USB_ADDR30                     8'h1e
//`define USB_ADDR31                     8'h1f
//
//
//
//
//
//// -------------------------------------------------------------------
//// PSEL Group #3:  0xc00 ~ 0xFFF
//// -------------------------------------------------------------------
//`define  PERIPHS3_CBUS_BASE   8'h30
//
//// ---------------------------
//// SDIO (8)
//// ---------------------------
//// `define C_SDIO_HIGH16                   8'h00
//// bit 31:0 -- cmd_argument/MS_SHORT_DATA_WRITE
//`define CMD_ARGUMENT                    8'h08
//// bit 31:24 -- repeat_package_times/MS_SHORT_DATA_WRITE_NUMBER
//// bit 21   -- use_int_window
//// bit 20   -- cmd_send_data/MS_HAVE_LONG_DATA_WRITE
//// bit 19   -- check_busy_on_dat0 (used for R1b response)
//// bit 18   -- response_crc7_from_8
//// bit 17   -- response_have_data/MS_HAVE_LONG_DATA_READ
//// bit 16   -- response_do_not_have_crc7/MS_SHORT_DATA_DO_NOT_HAVE_CRC16
//// bit 15:8 -- cmd_response_bits (00 means no response) /MS_SHORT_DATA_READ_NUMBER
//// bit 7:0 -- cmd_command/MS_TPC
//`define CMD_SEND                        8'h09
//// bit 31:29 -- sdio_write_CRC_ok_status
//// bit 28:23 -- sdio_write_Nwr
//// bit 22:21 -- m_endian
//// bit 20    -- bus_width
//// bit 19    -- data_latch_at_negedge (normally at posedge)
//// bit 18    -- do_not_delay_data (normally delay one clock)
//// bit 17:12 -- cmd_argument_bits (before CRC, normally : 39)
//// bit 11 -- cmd_out_at_posedge (normally at negedge)
//// bit 10 -- cmd_disable_CRC
//// bit 9:0 -- cmd_clk_divide
//`define SDIO_CONFIG                     8'h0a
//// bit 31:19 -- sdio_timing_out_count
//// bit 18 -- arc_timing_out_int_en
//// bit 17 -- amrisc_timing_out_int_en
//// bit 16 -- sdio_timig_out_int   -- write 1 clear this int bit
//// bit 15:12 -- sdio_status_info  -- used for change infor between ARC and Amrisc
//// bit 11 -- sdio_set_soft_int -- write 1 to this bit will set sdio_soft_int , read out is
/// m_req_sdio / bit 10 -- sdio_soft_int   -- write 1 clear this int bit / bit 9 -- sdio_cmd_int
/// -- write 1 clear this int bit / bit 8 -- sdio_if_int   -- write 1 clear this int bit / bit 7 --
/// sdio_data_write_crc16_ok -- Read-Only / bit 6 -- sdio_data_read_crc16_ok  -- Read-Only / bit 5
///-- sdio_response_crc7_ok    -- Read-Only / bit 4 -- sdio_cmd_busy            -- Read-Only / bit
/// 3:0 -- sdio_status            -- Read-Only
//`define SDIO_STATUS_IRQ                 8'h0b
//// bit 31 -- halt_hole 0 -- 8 bits 1 -- 16 bits
//// bit 30 -- force_halt
//// bit 29:24 -- sdio_force_data_read (read_only)
//// bit 23:22 -- disable_mem_halt (write and read)
//// bit 21:16 -- sdio_force_output_en
//// bit 15 -- soft_reset
//// bit 14 -- sdio_force_enable
//// bit 13:8 -- sdio_force_data/sdio_read_data
//// bit 7:6 -- sdio_if_int_config
//// bit 5 -- arc_soft_int_en
//// bit 4 -- arc_cmd_int_en
//// bit 3 -- arc_if_int_en
//// bit 2 -- amrisc_soft_int_en
//// bit 1 -- amrisc_cmd_int_en
//// bit 0 -- amrisc_if_int_en
//`define SDIO_IRQ_CONFIG                 8'h0c
//// bit 27:16 -- data_catch_finish_point
//// (
//// bit 15:12 -- response_read_index
//// bit 9 -- data_catch_readout_en
//// bit 8 -- write_read_out_index
//// ) this bits only write when write_read_out_index = 1
//// bit 11 -- sdio_1_data_swap01
//// bit 10 -- sdio_0_data_on_1
//// bit 7:6 -- data_catch_level
//// bit 5 -- stream_8_bits_mode
//// bit 4 -- stream_enable
//// bit 3 -- ms_sclk_always
//// bit 2 -- ms_enable
//// bit 1:0 -- SDIO_port_sel //00-sdio1, 01-sdio2, 02-sdio3
//`define SDIO_MULT_CONFIG                8'h0d
//// bit 31:0 -- m_addr_sdio
//`define SDIO_M_ADDR                     8'h0e
//// bit 31    -- CRC_status_4line
//// bit 30    -- data_rw_do_not_have_crc16/MS_LONG_DATA_DO_NOT_HAVE_CRC16
//// bit 29:16 -- data_rw_number/MS_LONG_DATA_NUMBER
//// bit 15:0 -- cmd_argument_ext/MS_SHORT_DATA_EXTENSION
//`define SDIO_EXTENSION                  8'h0f
//// ----------------------------
//// SDIO_AHB_CBUS (2)
//// ----------------------------
//// bit   17    -- arc_ahb_cbus_int_en
//// bit   16    -- amrisc_ahb_cbus_int_en
//// bit 15:8    -- SDIO_FIFO_count
//// bit  7:4    -- m_req_count
//// bit    3    -- reserved
//// bit    2    -- m_write_cbus
//// bit    1    -- m_req_cbus
//// bit    0    -- sdio_ahb_cbus_enable
//`define SDIO_AHB_CBUS_CTRL             8'h18
//// m_rd_data[31:0] when (m_write_cbus == 0)  CBUS write
//// m_wr_data[31:0] when (m_write_cbus == 1)  CBUS read
//`define SDIO_AHB_CBUS_M_DATA           8'h19
//
//
//// ----------------------------
//// SDHC (SDIO #2)
//// ----------------------------
//`define SD_REG0_ARGU    8'h80
//`define SD_REG1_SEND    8'h81
//`define SD_REG2_CNTL    8'h82
//`define SD_REG3_STAT    8'h83
//`define SD_REG4_CLKC    8'h84
//`define SD_REG5_ADDR    8'h85
//`define SD_REG6_PDMA    8'h86
//`define SD_REG7_MISC    8'h87
//`define SD_REG8_DATA    8'h88
//`define SD_REG9_ICTL    8'h89
//`define SD_REGA_ISTA    8'h8a
//`define SD_REGB_SRST    8'h8b
//`define SD_REGC_ESTA    8'h8c
//`define SD_REGD_ENHC    8'h8d
//`define SD_REGE_CLK2    8'h8e
//
//
// Closing file:  periphs_reg.h
//
//
// Reading file:  isa_reg.h
//
// $isa/rtl/isa_core register defines for the APB bus
// CBUS base slave address
// -----------------------------------------------
// CBUS_BASE:  ISA_CBUS_BASE = 0x3c
// -----------------------------------------------
// Up to 256 registers for this base
#define ISA_DEBUG_REG0 ((0x3c00 << 2) + 0xffd00000)
#define ISA_DEBUG_REG1 ((0x3c01 << 2) + 0xffd00000)
#define ISA_DEBUG_REG2 ((0x3c02 << 2) + 0xffd00000)
#define ISA_DEBUG_REG3 ((0x3c03 << 2) + 0xffd00000)
#define ISA_PLL_CLK_SIM0 ((0x3c08 << 2) + 0xffd00000)
#define ISA_CNTL_REG0 ((0x3c09 << 2) + 0xffd00000)
// -----------------------------------------------------------
#define AO_CPU_IRQ_IN0_INTR_STAT ((0x3c10 << 2) + 0xffd00000)
#define AO_CPU_IRQ_IN0_INTR_STAT_CLR ((0x3c11 << 2) + 0xffd00000)
#define AO_CPU_IRQ_IN0_INTR_MASK ((0x3c12 << 2) + 0xffd00000)
#define AO_CPU_IRQ_IN0_INTR_FIRQ_SEL ((0x3c13 << 2) + 0xffd00000)
// define MEDIA_CPU_IRQ_IN1_INTR_STAT           8'h14
// define MEDIA_CPU_IRQ_IN1_INTR_STAT_CLR       8'h15
// define MEDIA_CPU_IRQ_IN1_INTR_MASK           8'h16
// define MEDIA_CPU_IRQ_IN1_INTR_FIRQ_SEL       8'h17
//
// define MEDIA_CPU_IRQ_IN2_INTR_STAT              8'h18
// define MEDIA_CPU_IRQ_IN2_INTR_STAT_CLR          8'h19
// define MEDIA_CPU_IRQ_IN2_INTR_MASK              8'h1a
// define MEDIA_CPU_IRQ_IN2_INTR_FIRQ_SEL          8'h1b
//
// define MEDIA_CPU_IRQ_IN3_INTR_STAT            8'h1c
// define MEDIA_CPU_IRQ_IN3_INTR_STAT_CLR        8'h1d
// define MEDIA_CPU_IRQ_IN3_INTR_MASK            8'h1e
// define MEDIA_CPU_IRQ_IN3_INTR_FIRQ_SEL        8'h1f
#define GPIO_INTR_EDGE_POL ((0x3c20 << 2) + 0xffd00000)
#define GPIO_INTR_GPIO_SEL0 ((0x3c21 << 2) + 0xffd00000)
#define GPIO_INTR_GPIO_SEL1 ((0x3c22 << 2) + 0xffd00000)
#define GPIO_INTR_FILTER_SEL0 ((0x3c23 << 2) + 0xffd00000)
// `define GLOBAL_INTR_DISABLE                 8'h24    never used
#define CVBS_IRQ0_CNTL ((0x3c24 << 2) + 0xffd00000)
#define CVBS_IRQ1_CNTL ((0x3c25 << 2) + 0xffd00000)
#define CVBS_IRQ0_COUNTER ((0x3c26 << 2) + 0xffd00000)
#define CVBS_IRQ1_COUNTER ((0x3c27 << 2) + 0xffd00000)
#define MEDIA_CPU_INTR_STAT ((0x3c28 << 2) + 0xffd00000)
#define MEDIA_CPU_INTR_STAT_CLR ((0x3c29 << 2) + 0xffd00000)
#define MEDIA_CPU_INTR_MASK ((0x3c2a << 2) + 0xffd00000)
#define MEDIA_CPU_INTR_FIRQ_SEL ((0x3c2b << 2) + 0xffd00000)
// -----------------------------------------------------------
#define ISA_BIST_REG0 ((0x3c30 << 2) + 0xffd00000)
#define ISA_BIST_REG1 ((0x3c31 << 2) + 0xffd00000)
// -----------------------------------------------------------
#define WATCHDOG_CNTL ((0x3c34 << 2) + 0xffd00000)
#define WATCHDOG_CNTL1 ((0x3c35 << 2) + 0xffd00000)
#define WATCHDOG_TCNT ((0x3c36 << 2) + 0xffd00000)
#define WATCHDOG_RESET ((0x3c37 << 2) + 0xffd00000)
// -----------------------------------------------------------
#define AHB_ARBITER_REG ((0x3c42 << 2) + 0xffd00000)
#define AHB_ARBDEC_REG ((0x3c43 << 2) + 0xffd00000)
#define AHB_ARBITER2_REG ((0x3c4a << 2) + 0xffd00000)
#define DEVICE_MMCP_CNTL ((0x3c4b << 2) + 0xffd00000)
#define AUDIO_MMCP_CNTL ((0x3c4c << 2) + 0xffd00000)
#define DEVICE_AM2AXI0_CNTL0 ((0x3c4e << 2) + 0xffd00000)
#define DEVICE_AM2AXI1_CNTL0 ((0x3c4f << 2) + 0xffd00000)
// -----------------------------------------------------------
#define ISA_TIMER_MUX ((0x3c50 << 2) + 0xffd00000)
#define ISA_TIMERA ((0x3c51 << 2) + 0xffd00000)
#define ISA_TIMERB ((0x3c52 << 2) + 0xffd00000)
#define ISA_TIMERC ((0x3c53 << 2) + 0xffd00000)
#define ISA_TIMERD ((0x3c54 << 2) + 0xffd00000)
#define FBUF_ADDR ((0x3c56 << 2) + 0xffd00000)
#define VIDEO_FRM_BUF_MSB_BIT 23
#define VIDEO_FRM_BUF_LSB_BIT 2
#define SDRAM_CTL0 ((0x3c57 << 2) + 0xffd00000)
#define SDRAM_CTL2 ((0x3c58 << 2) + 0xffd00000)
//`define AO_CPU_CTL                          8'h59
#define SDRAM_CTL4 ((0x3c5a << 2) + 0xffd00000)
#define SDRAM_CTL5 ((0x3c5b << 2) + 0xffd00000)
#define SDRAM_CTL6 ((0x3c5c << 2) + 0xffd00000)
#define SDRAM_CTL7 ((0x3c5d << 2) + 0xffd00000)
#define SDRAM_CTL8 ((0x3c5e << 2) + 0xffd00000)
#define AHB_MP4_MC_CTL ((0x3c5f << 2) + 0xffd00000)
#define MEDIA_CPU_PCR ((0x3c60 << 2) + 0xffd00000)
#define MEDIA_CPU_CTL ((0x3c61 << 2) + 0xffd00000)
#define ISA_TIMERE ((0x3c62 << 2) + 0xffd00000)
#define ISA_TIMERE_HI ((0x3c63 << 2) + 0xffd00000)
#define ISA_TIMER_MUX1 ((0x3c64 << 2) + 0xffd00000)
#define ISA_TIMERF ((0x3c65 << 2) + 0xffd00000)
#define ISA_TIMERG ((0x3c66 << 2) + 0xffd00000)
#define ISA_TIMERH ((0x3c67 << 2) + 0xffd00000)
#define ISA_TIMERI ((0x3c68 << 2) + 0xffd00000)
// ---------------------------------------------
#define ABUF_WR_CTL0 ((0x3c70 << 2) + 0xffd00000)
#define ABUF_WR_INT_EN 31
#define ABUF_WR_INT_POS_MSB 30
#define ABUF_WR_INT_POS_LSB 16
#define ABUF_WR_BLK_SIZE_MSB 14
#define ABUF_WR_BLK_SIZE_LSB 0
#define ABUF_WR_CTL1 ((0x3c71 << 2) + 0xffd00000)
#define ABUF_WR_INT_EN 31
#define ABUF_WR_INT_POS_MSB 30
#define ABUF_WR_INT_POS_LSB 16
#define ABUF_WR_BLK_SIZE_MSB 14
#define ABUF_WR_BLK_SIZE_LSB 0
#define ABUF_WR_CTL2 ((0x3c72 << 2) + 0xffd00000)
#define ABUF_WR_CUR_FF_CNT_MSB 21
#define ABUF_WR_CUR_FF_CNT_LSB 16
#define ABUF_WR_CUR_BLK_MSB 14
#define ABUF_WR_CUR_BLK_LSB 0
#define ABUF_WR_CTL3 ((0x3c73 << 2) + 0xffd00000)
#define ABUF_WR_AHB_RST_PLS 3
#define ABUF_WR_FF_CLR_PLS 2
#define ABUF_WR_PLY_RPT_LVL 1
#define ABUF_WR_FF_PAUSE_LVL 0
#define ABUF_RD_CTL0 ((0x3c74 << 2) + 0xffd00000)
#define ABUF_RD_CTL1 ((0x3c75 << 2) + 0xffd00000)
#define ABUF_RD_INT_EN 31
#define ABUF_RD_INT_POS_MSB 30
#define ABUF_RD_INT_POS_LSB 16
#define ABUF_RD_BLK_SIZE_MSB 14
#define ABUF_RD_BLK_SIZE_LSB 0
#define ABUF_RD_CTL2 ((0x3c76 << 2) + 0xffd00000)
#define ABUF_RD_CUR_FF_CNT_MSB 21
#define ABUF_RD_CUR_FF_CNT_LSB 16
#define ABUF_RD_CUR_BLK_MSB 14
#define ABUF_RD_CUR_BLK_LSB 0
#define ABUF_RD_CTL3 ((0x3c77 << 2) + 0xffd00000)
#define ABUF_RD_PLY_ONCE_PLS 4
#define ABUF_RD_AHB_RST_PLS 3
#define ABUF_RD_FF_CLR_PLS 2
#define ABUF_RD_PLY_RPT_LVL 1
#define ABUF_RD_FF_PAUSE_LVL 0
#define ABUF_ARB_CTL0 ((0x3c78 << 2) + 0xffd00000)
#define ABUF_FIFO_CTL0 ((0x3c79 << 2) + 0xffd00000)
#define AIUout_FIFO_THRESHOLD_MSB 11
#define AIUout_FIFO_THRESHOLD_LSB 6
#define AIUin_FIFO_THRESHOLD_MSB 5
#define AIUin_FIFO_THRESHOLD_LSB 0
// ---------------------------------------------
#define AHB_BRIDGE_CNTL_WR ((0x3c80 << 2) + 0xffd00000)
#define AHB_BRIDGE_REMAP0 ((0x3c81 << 2) + 0xffd00000)
#define AHB_BRIDGE_REMAP1 ((0x3c82 << 2) + 0xffd00000)
#define AHB_BRIDGE_REMAP2 ((0x3c83 << 2) + 0xffd00000)
#define AHB_BRIDGE_REMAP3 ((0x3c84 << 2) + 0xffd00000)
#define AHB_BRIDGE_CNTL_REG1 ((0x3c85 << 2) + 0xffd00000)
#define AHB_BRIDGE_CNTL_REG2 ((0x3c86 << 2) + 0xffd00000)
// ---------------------------------------------
// software irq
#define ISA_SOFT_IRQ ((0x3c90 << 2) + 0xffd00000)
// ----------------------------------------------
// `define SYS_CPU_0_IRQ_IN0_INTR_STAT         8'h90
// `define SYS_CPU_0_IRQ_IN0_INTR_STAT_CLR     8'h91
// `define SYS_CPU_0_IRQ_IN0_INTR_MASK         8'h92
// `define SYS_CPU_0_IRQ_IN0_INTR_FIRQ_SEL     8'h93
// `define SYS_CPU_0_IRQ_IN1_INTR_STAT         8'h94
// `define SYS_CPU_0_IRQ_IN1_INTR_STAT_CLR     8'h95
// `define SYS_CPU_0_IRQ_IN1_INTR_MASK         8'h96
// `define SYS_CPU_0_IRQ_IN1_INTR_FIRQ_SEL     8'h97
// `define SYS_CPU_0_IRQ_IN2_INTR_STAT         8'h98
// `define SYS_CPU_0_IRQ_IN2_INTR_STAT_CLR     8'h99
// `define SYS_CPU_0_IRQ_IN2_INTR_MASK         8'h9a
// `define SYS_CPU_0_IRQ_IN2_INTR_FIRQ_SEL     8'h9b
// `define SYS_CPU_0_IRQ_IN3_INTR_STAT         8'h9c
// `define SYS_CPU_0_IRQ_IN3_INTR_STAT_CLR     8'h9d
// `define SYS_CPU_0_IRQ_IN3_INTR_MASK         8'h9e
// `define SYS_CPU_0_IRQ_IN3_INTR_FIRQ_SEL     8'h9f
// ----------------------------------------------
// `define SYS_CPU_1_IRQ_IN0_INTR_STAT         8'ha0
// `define SYS_CPU_1_IRQ_IN0_INTR_STAT_CLR     8'ha1
// `define SYS_CPU_1_IRQ_IN0_INTR_MASK         8'ha2
// `define SYS_CPU_1_IRQ_IN0_INTR_FIRQ_SEL     8'ha3
//
// `define SYS_CPU_1_IRQ_IN1_INTR_STAT         8'ha4
// `define SYS_CPU_1_IRQ_IN1_INTR_STAT_CLR     8'ha5
// `define SYS_CPU_1_IRQ_IN1_INTR_MASK         8'ha6
// `define SYS_CPU_1_IRQ_IN1_INTR_FIRQ_SEL     8'ha7
//
// `define SYS_CPU_1_IRQ_IN2_INTR_STAT         8'ha8
// `define SYS_CPU_1_IRQ_IN2_INTR_STAT_CLR     8'ha9
// `define SYS_CPU_1_IRQ_IN2_INTR_MASK         8'haa
// `define SYS_CPU_1_IRQ_IN2_INTR_FIRQ_SEL     8'hab
//
// `define SYS_CPU_1_IRQ_IN3_INTR_STAT         8'hac
// `define SYS_CPU_1_IRQ_IN3_INTR_STAT_CLR     8'had
// `define SYS_CPU_1_IRQ_IN3_INTR_MASK         8'hae
// `define SYS_CPU_1_IRQ_IN3_INTR_FIRQ_SEL     8'haf
// ----------------------------------------------
// `define MEDIA_CPU_IRQ_IN4_INTR_STAT         8'hb0
// `define MEDIA_CPU_IRQ_IN4_INTR_STAT_CLR     8'hb1
// `define MEDIA_CPU_IRQ_IN4_INTR_MASK         8'hb2
// `define MEDIA_CPU_IRQ_IN4_INTR_FIRQ_SEL     8'hb3
// `define SYS_CPU_0_IRQ_IN4_INTR_STAT         8'hb4
// `define SYS_CPU_0_IRQ_IN4_INTR_STAT_CLR     8'hb5
// `define SYS_CPU_0_IRQ_IN4_INTR_MASK         8'hb6
// `define SYS_CPU_0_IRQ_IN4_INTR_FIRQ_SEL     8'hb7
// `define SYS_CPU_1_IRQ_IN4_INTR_STAT         8'hb8
// `define SYS_CPU_1_IRQ_IN4_INTR_STAT_CLR     8'hb9
// `define SYS_CPU_1_IRQ_IN4_INTR_MASK         8'hba
// `define SYS_CPU_1_IRQ_IN4_INTR_FIRQ_SEL     8'hbb
// `define SYS_CPU_2_IRQ_IN4_INTR_STAT         8'hbc
// `define SYS_CPU_2_IRQ_IN4_INTR_STAT_CLR     8'hbd
// `define SYS_CPU_2_IRQ_IN4_INTR_MASK         8'hbe
// `define SYS_CPU_2_IRQ_IN4_INTR_FIRQ_SEL     8'hbf
// ----------------------------------------------
// `define SYS_CPU_2_IRQ_IN0_INTR_STAT         8'hc0
// `define SYS_CPU_2_IRQ_IN0_INTR_STAT_CLR     8'hc1
// `define SYS_CPU_2_IRQ_IN0_INTR_MASK         8'hc2
// `define SYS_CPU_2_IRQ_IN0_INTR_FIRQ_SEL     8'hc3
// `define SYS_CPU_2_IRQ_IN1_INTR_STAT         8'hc4
// `define SYS_CPU_2_IRQ_IN1_INTR_STAT_CLR     8'hc5
// `define SYS_CPU_2_IRQ_IN1_INTR_MASK         8'hc6
// `define SYS_CPU_2_IRQ_IN1_INTR_FIRQ_SEL     8'hc7
// `define SYS_CPU_2_IRQ_IN2_INTR_STAT         8'hc8
// `define SYS_CPU_2_IRQ_IN2_INTR_STAT_CLR     8'hc9
// `define SYS_CPU_2_IRQ_IN2_INTR_MASK         8'hca
// `define SYS_CPU_2_IRQ_IN2_INTR_FIRQ_SEL     8'hcb
// `define SYS_CPU_2_IRQ_IN3_INTR_STAT         8'hcc
// `define SYS_CPU_2_IRQ_IN3_INTR_STAT_CLR     8'hcd
// `define SYS_CPU_2_IRQ_IN3_INTR_MASK         8'hce
// `define SYS_CPU_2_IRQ_IN3_INTR_FIRQ_SEL     8'hcf
// ----------------------------------------------
// `define SYS_CPU_3_IRQ_IN0_INTR_STAT         8'hd0
// `define SYS_CPU_3_IRQ_IN0_INTR_STAT_CLR     8'hd1
// `define SYS_CPU_3_IRQ_IN0_INTR_MASK         8'hd2
// `define SYS_CPU_3_IRQ_IN0_INTR_FIRQ_SEL     8'hd3
// `define SYS_CPU_3_IRQ_IN1_INTR_STAT         8'hd4
// `define SYS_CPU_3_IRQ_IN1_INTR_STAT_CLR     8'hd5
// `define SYS_CPU_3_IRQ_IN1_INTR_MASK         8'hd6
// `define SYS_CPU_3_IRQ_IN1_INTR_FIRQ_SEL     8'hd7
// `define SYS_CPU_3_IRQ_IN2_INTR_STAT         8'hd8
// `define SYS_CPU_3_IRQ_IN2_INTR_STAT_CLR     8'hd9
// `define SYS_CPU_3_IRQ_IN2_INTR_MASK         8'hda
// `define SYS_CPU_3_IRQ_IN2_INTR_FIRQ_SEL     8'hdb
// `define SYS_CPU_3_IRQ_IN3_INTR_STAT         8'hdc
// `define SYS_CPU_3_IRQ_IN3_INTR_STAT_CLR     8'hdd
// `define SYS_CPU_3_IRQ_IN3_INTR_MASK         8'hde
// `define SYS_CPU_3_IRQ_IN3_INTR_FIRQ_SEL     8'hdf
// ----------------------------------------------
// `define SYS_CPU_3_IRQ_IN4_INTR_STAT         8'he0
// `define SYS_CPU_3_IRQ_IN4_INTR_STAT_CLR     8'he1
// `define SYS_CPU_3_IRQ_IN4_INTR_MASK         8'he2
// `define SYS_CPU_3_IRQ_IN4_INTR_FIRQ_SEL     8'he3
// `define MEDIA_CPU_IRQ_IN5_INTR_STAT         8'he4
// `define MEDIA_CPU_IRQ_IN5_INTR_STAT_CLR     8'he5
// `define MEDIA_CPU_IRQ_IN5_INTR_MASK         8'he6
// `define MEDIA_CPU_IRQ_IN5_INTR_FIRQ_SEL     8'he7
// `define SYS_CPU_0_IRQ_IN5_INTR_STAT         8'he8
// `define SYS_CPU_0_IRQ_IN5_INTR_STAT_CLR     8'he9
// `define SYS_CPU_0_IRQ_IN5_INTR_MASK         8'hea
// `define SYS_CPU_0_IRQ_IN5_INTR_FIRQ_SEL     8'heb
//
// Closing file:  isa_reg.h
//
//`include "bt656_reg.h"
//`include "pdm_reg.h"
//========================================================================
//  Global Control Registers			    (12'h000 - 12'h0ff)
//
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  RESET_CBUS_BASE = 0x04
// -----------------------------------------------
#define VERSION_CTRL ((0x0400 << 2) + 0xffd00000)
#define RESET0_REGISTER ((0x0401 << 2) + 0xffd00000)
#define RESET1_REGISTER ((0x0402 << 2) + 0xffd00000)
#define RESET2_REGISTER ((0x0403 << 2) + 0xffd00000)
#define RESET3_REGISTER ((0x0404 << 2) + 0xffd00000)
#define RESET4_REGISTER ((0x0405 << 2) + 0xffd00000)
#define RESET5_REGISTER ((0x0406 << 2) + 0xffd00000)
#define RESET6_REGISTER ((0x0407 << 2) + 0xffd00000)
#define RESET7_REGISTER ((0x0408 << 2) + 0xffd00000)
#define RESET0_MASK ((0x0410 << 2) + 0xffd00000)
#define RESET1_MASK ((0x0411 << 2) + 0xffd00000)
#define RESET2_MASK ((0x0412 << 2) + 0xffd00000)
#define RESET3_MASK ((0x0413 << 2) + 0xffd00000)
#define RESET4_MASK ((0x0414 << 2) + 0xffd00000)
#define RESET5_MASK ((0x0415 << 2) + 0xffd00000)
#define RESET6_MASK ((0x0416 << 2) + 0xffd00000)
#define RESET7_MASK ((0x0417 << 2) + 0xffd00000)
//`define CRT_MASK            8'h18
#define RESET0_LEVEL ((0x0420 << 2) + 0xffd00000)
#define RESET1_LEVEL ((0x0421 << 2) + 0xffd00000)
#define RESET2_LEVEL ((0x0422 << 2) + 0xffd00000)
#define RESET3_LEVEL ((0x0423 << 2) + 0xffd00000)
#define RESET4_LEVEL ((0x0424 << 2) + 0xffd00000)
#define RESET5_LEVEL ((0x0425 << 2) + 0xffd00000)
#define RESET6_LEVEL ((0x0426 << 2) + 0xffd00000)
#define RESET7_LEVEL ((0x0427 << 2) + 0xffd00000)
//======================================
//  Reset Register Bits
//
//======================================
#define HIU_RESET 0x0001
#define VLD_RESET 0x0002
#define IQIDCT_RESET 0x0004
#define MC_RESET 0x0008
#define DCU_RESET 0x0010
#define VIU_RESET 0x0020
#define AIU_RESET 0x0040
#define CPU_RESET 0x0080
#define AC3_RESET 0x0100
#define MPEG_RESET 0x0200
//-----------------------------------------------------------
// PARSER
//-----------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PARSER_CBUS_BASE = 0x38
// -----------------------------------------------
// bit 31:8 -- es_pack_size
// bit 7:6 -- es_type     00-Video, 01-Audio, 10-Subtitle
// bit 5 -- es_write
// bit 4 -- es_passthrough
// bit 3 -- insert_before_es_write
// bit 2 -- discard_cmd
// bit 1 -- search_cmd
// bit 0 -- Parser Busy
#define PARSER_CONTROL ((0x3860 << 2) + 0xffd00000)
// Write
//   bit 31:0 begin address for parser fetch
// Read
//   32 bit current fetch address
#define PARSER_FETCH_ADDR ((0x3861 << 2) + 0xffd00000)
// Write
//   bit 31 circle buffer indicator
//   bit 30 check_buffer_stop_addr
//   bit 29:27 fetch endian
//   bit 26:0 buffer size ( Bytes )
// Special command:
//   when bit 26:0 == 27'h0
//     then bit 29    -- stream_passthrough_enable
//          bit 28:27 -- stream_passthrough_type
// Read
//   6:5 cmd_rd_ptr
//   4:3 cmd_wr_ptr
//   2:0 cmd_number
#define PARSER_FETCH_CMD ((0x3862 << 2) + 0xffd00000)
// 31:0 stop_fetch_addr
#define PARSER_FETCH_STOP_ADDR ((0x3863 << 2) + 0xffd00000)
// 31:0 stop_fetch_addr - current_write_addr  // read only
#define PARSER_FETCH_LEVEL ((0x3864 << 2) + 0xffd00000)
// bit 31 - fetch_dma_urgent
// bit 30 - stream_dma_urgent
// bit 29 - force_pfifo_ren
// bit 28 - pfifo_peak_enable
// bit 27 - enable_free_clk_parser_reg
// bit 26 -
// bit 25:24 - parser_src_sel (00 - fetch, 01 - aux1, 10 - aux2 11 - aux3)
// bit 23:16 - pfifo_empty_count
// bit 15:12 - max_es_write_cycle (x16x64bits)
// 11:10 - start code width ( 00-8bits, 01-16bits, 10-24bits, 11-32bits )
// 9:8 - pfifo data access width ( 00-8bits, 01-16bits, 10-24bits, 11-32bits )
// 7:0 - empty room for fetch data ( max_fetch_cycle ) x64 bits
#define PARSER_CONFIG ((0x3865 << 2) + 0xffd00000)
// bit 24:16 -- pfifo_level
// bit 9:0 -- point to byte address
#define PFIFO_WR_PTR ((0x3866 << 2) + 0xffd00000)
// bit 9:0 -- point to byte address
#define PFIFO_RD_PTR ((0x3867 << 2) + 0xffd00000)
// bit 31:0 -- 8/16/24/32 bits data acording to pfifo_data_width
#define PFIFO_DATA ((0x3868 << 2) + 0xffd00000)
// bit 31:0 -- parser search pattern
#define PARSER_SEARCH_PATTERN ((0x3869 << 2) + 0xffd00000)
// bit 31:0 -- parser search mask ( 0 - disable bit match test )
#define PARSER_SEARCH_MASK ((0x386a << 2) + 0xffd00000)
// bit 31:16 -- parser_int_disable_count
// bit 15:8 -- Parser interrupt enable for host cpu
// bit 7:0 -- Parser interrupt enable for Amrisc
#define PARSER_INT_ENABLE ((0x386b << 2) + 0xffd00000)
// Bit 7 -- fetch_cmd_finished
// Bit 6:5 -- reserved
// Bit 4 -- parse finished
// Bit 3 -- discard finished
// Bit 2 -- insert zero finished
// Bit 1 -- Action Finished Except Search Start Code
// Bit 0 -- Search match interrupt (StartCode found)
// Read 7:0 int status
// Write will clear (bit based)
#define PARSER_INT_STATUS ((0x386c << 2) + 0xffd00000)
// 15    - SCR_32_READ_OUT (Read Only)
// 14    - SCR_32_data_valid
// 13    - SCR_32_data
// 12    - SCR_count_en
// 11:0  - SCR90K_DIV
#define PARSER_SCR_CTL ((0x386d << 2) + 0xffd00000)
// bit 31:0 SCR value
#define PARSER_SCR ((0x386e << 2) + 0xffd00000)
// bit 31:24 -- insert_loop_number
// bit 23:21 --
// bit 20:16 -- insert_byte_number
// bit 15:0 -- discard number
#define PARSER_PARAMETER ((0x386f << 2) + 0xffd00000)
// bit 31:0 -- insert data // write only
// write to PARSER_CONTROL will reset the write position
// continous write to this address can write upto 16 bytes
#define PARSER_INSERT_DATA ((0x3870 << 2) + 0xffd00000)
// Bit 31:24 -- Reserved Stream_ID
// Bit 23:16 -- Sub Stream_ID
// Bit 15:8  -- Audio Stream_ID
// Bit 7:0   -- Video Stream_ID
#define VAS_STREAM_ID ((0x3871 << 2) + 0xffd00000)
// Bit 31:0 -- VIDEO_DTS
#define VIDEO_DTS ((0x3872 << 2) + 0xffd00000)
// Bit 31:0 -- VIDEO_PTS
#define VIDEO_PTS ((0x3873 << 2) + 0xffd00000)
// Bit 31:0 -- VIDEO_PTS_DTS_WR_PTR
#define VIDEO_PTS_DTS_WR_PTR ((0x3874 << 2) + 0xffd00000)
// Bit 31:0 -- AUDIO_PTS
#define AUDIO_PTS ((0x3875 << 2) + 0xffd00000)
// Bit 31:0 -- AUDIO_PTS_WR_PTR
#define AUDIO_PTS_WR_PTR ((0x3876 << 2) + 0xffd00000)
// bit 31:20 -- stream_es_count ( Read Only)
// bit 19 -- req_pending ( parser ddr_A_fifo ) (Read Only)
// bit 18 -- stream_es_passthrough_enable
// bit 17:16 -- stream_es_passthrough_type
// bit 15:13 -- VIDEO2 Ees_write Endian
// bit 12 -- VIDEO2 using manual read point
// bit 11:9 -- SUB Ees_write Endian
// bit 8 -- SUB using manual read point
// bit 7:5 -- AUDIO Ees_write Endian
// bit 4 -- AUDIO using manual read point
// bit 3:1 -- VIDEO Ees_write Endian
// bit 0 -- VIDEO using manual read point
#define PARSER_ES_CONTROL ((0x3877 << 2) + 0xffd00000)
// Bit 31:0 PFIFO_MONITOR
#define PFIFO_MONITOR ((0x3878 << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_VIDEO DDR Interface
// --------------------------------------------
// The PARSER_VIDEO start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define PARSER_VIDEO_START_PTR ((0x3880 << 2) + 0xffd00000)
#define PARSER_VIDEO_END_PTR ((0x3881 << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_VIDEO Buffer Level Manager
// --------------------------------------------
#define PARSER_VIDEO_WP ((0x3882 << 2) + 0xffd00000)
#define PARSER_VIDEO_RP ((0x3883 << 2) + 0xffd00000)
#define PARSER_VIDEO_HOLE ((0x3884 << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_AUDIO DDR Interface
// --------------------------------------------
// The PARSER_AUDIO start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define PARSER_AUDIO_START_PTR ((0x3885 << 2) + 0xffd00000)
#define PARSER_AUDIO_END_PTR ((0x3886 << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_AUDIO Buffer Level Manager
// --------------------------------------------
#define PARSER_AUDIO_WP ((0x3887 << 2) + 0xffd00000)
#define PARSER_AUDIO_RP ((0x3888 << 2) + 0xffd00000)
#define PARSER_AUDIO_HOLE ((0x3889 << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_SUB DDR Interface
// --------------------------------------------
// The PARSER_SUB start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define PARSER_SUB_START_PTR ((0x388a << 2) + 0xffd00000)
#define PARSER_SUB_END_PTR ((0x388b << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_SUB Buffer Level Manager
// --------------------------------------------
#define PARSER_SUB_WP ((0x388c << 2) + 0xffd00000)
#define PARSER_SUB_RP ((0x388d << 2) + 0xffd00000)
#define PARSER_SUB_HOLE ((0x388e << 2) + 0xffd00000)
// Bit[31] dma_busy
// Bit[30] cur_fetch_or_es_write
// Bit[29:28] reserved
// Bit[27:24] fetch_status
// Bit[23:0] buffer_cycles_left
#define PARSER_FETCH_INFO ((0x388f << 2) + 0xffd00000)
// Bit[31:28] ctl_status
// Bit[27:24] insert_byte_offset
// Bit[23:0] es_pack_left_cycle
#define PARSER_STATUS ((0x3890 << 2) + 0xffd00000)
// Bit [31:16] AUDIO_wrap_count
// Bit  [15:0] VIDEO_wrap_count
#define PARSER_AV_WRAP_COUNT ((0x3891 << 2) + 0xffd00000)
// bit[29:24] A_brst_num_parser
// bit[21:16] A_id_parser
// bit[11:0] wrrsp_count_parser
#define WRRSP_PARSER ((0x3892 << 2) + 0xffd00000)
// `define CSS_cmd             12'h200   // address of css command and indirect register
// `define CSS_cntl            12'h201   // css control register
// `define CSS_data            12'h202   // indirect register
// `define CSS_id1_data        12'h203   // ID data for the first and second bytes
// `define CSS_id2_data        12'h204   // ID data for the third and fourth bytes
// CPPM registers
// `define CPPM_IFIFO_CTRL		12'h210	  //CPPM input FIFO control
// `define CPPM_C2BC_KEY		12'h211	  //CPPM C2 Block Cipher Key register
// `define CPPM_C2BC_DIN		12'h212	  //CPPM C2 Block Cipher data input register
// `define CPPM_C2BC_DOUT		12'h213   //CPPM C2 Block Cipher data result register
// `define CPPM_CMD			12'h214   //CPPM command and control register
// `define CPPM_CTRL_STATUS	12'h215   //CPPM control status, mainly for debug
// `define CPPM_IFIFO_DATA		12'h216   //CPPM input FIFO data pop port, just for debug
// --------------------------------------------
// PARSER_VIDEO2 DDR Interface
// --------------------------------------------
// The PARSER_VIDEO2 start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define PARSER_VIDEO2_START_PTR ((0x3893 << 2) + 0xffd00000)
#define PARSER_VIDEO2_END_PTR ((0x3894 << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_VIDEO2 Buffer Level Manager
// --------------------------------------------
#define PARSER_VIDEO2_WP ((0x3895 << 2) + 0xffd00000)
#define PARSER_VIDEO2_RP ((0x3896 << 2) + 0xffd00000)
#define PARSER_VIDEO2_HOLE ((0x3897 << 2) + 0xffd00000)
// Bit [31:16] AUDIO_wrap_count
// Bit  [15:0] VIDEO2_wrap_count
#define PARSER_AV2_WRAP_COUNT ((0x3898 << 2) + 0xffd00000)
//-----------------------------------------------------------
// PARSER1
//-----------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PARSER1_CBUS_BASE = 0x34
// -----------------------------------------------
#define PARSER_B_PARSER_CONTROL ((0x3460 << 2) + 0xffd00000)
// Write
//   bit 31:0 begin address for parser fetch
// Read
//   32 bit current fetch address
#define PARSER_B_PARSER_FETCH_ADDR ((0x3461 << 2) + 0xffd00000)
// Write
//   bit 31 circle buffer indicator
//   bit 30 check_buffer_stop_addr
//   bit 29:27 fetch endian
//   bit 26:0 buffer size ( Bytes )
// Special command:
//   when bit 26:0 == 27'h0
//     then bit 29    -- stream_passthrough_enable
//          bit 28:27 -- stream_passthrough_type
// Read
//   6:5 cmd_rd_ptr
//   4:3 cmd_wr_ptr
//   2:0 cmd_number
#define PARSER_B_PARSER_FETCH_CMD ((0x3462 << 2) + 0xffd00000)
// 31:0 stop_fetch_addr
#define PARSER_B_PARSER_FETCH_STOP_ADDR ((0x3463 << 2) + 0xffd00000)
// 31:0 stop_fetch_addr - current_write_addr  // read only
#define PARSER_B_PARSER_FETCH_LEVEL ((0x3464 << 2) + 0xffd00000)
// bit 31 - fetch_dma_urgent
// bit 30 - stream_dma_urgent
// bit 29 - force_pfifo_ren
// bit 28 - pfifo_peak_enable
// bit 27 - enable_free_clk_parser_reg
// bit 26 -
// bit 25:24 - parser_src_sel (00 - fetch, 01 - aux1, 10 - aux2 11 - aux3)
// bit 23:16 - pfifo_empty_count
// bit 15:12 - max_es_write_cycle (x16x64bits)
// 11:10 - start code width ( 00-8bits, 01-16bits, 10-24bits, 11-32bits )
// 9:8 - pfifo data access width ( 00-8bits, 01-16bits, 10-24bits, 11-32bits )
// 7:0 - empty room for fetch data ( max_fetch_cycle ) x64 bits
#define PARSER_B_PARSER_CONFIG ((0x3465 << 2) + 0xffd00000)
// bit 24:16 -- pfifo_level
// bit 9:0 -- point to byte address
#define PARSER_B_PFIFO_WR_PTR ((0x3466 << 2) + 0xffd00000)
// bit 9:0 -- point to byte address
#define PARSER_B_PFIFO_RD_PTR ((0x3467 << 2) + 0xffd00000)
// bit 31:0 -- 8/16/24/32 bits data acording to pfifo_data_width
#define PARSER_B_PFIFO_DATA ((0x3468 << 2) + 0xffd00000)
// bit 31:0 -- parser search pattern
#define PARSER_B_PARSER_SEARCH_PATTERN ((0x3469 << 2) + 0xffd00000)
// bit 31:0 -- parser search mask ( 0 - disable bit match test )
#define PARSER_B_PARSER_SEARCH_MASK ((0x346a << 2) + 0xffd00000)
// bit 31:16 -- parser_int_disable_count
// bit 15:8 -- Parser interrupt enable for host cpu
// bit 7:0 -- Parser interrupt enable for Amrisc
#define PARSER_B_PARSER_INT_ENABLE ((0x346b << 2) + 0xffd00000)
// Bit 7 -- fetch_cmd_finished
// Bit 6:5 -- reserved
// Bit 4 -- parse finished
// Bit 3 -- discard finished
// Bit 2 -- insert zero finished
// Bit 1 -- Action Finished Except Search Start Code
// Bit 0 -- Search match interrupt (StartCode found)
// Read 7:0 int status
// Write will clear (bit based)
#define PARSER_B_PARSER_INT_STATUS ((0x346c << 2) + 0xffd00000)
// 15    - SCR_32_READ_OUT (Read Only)
// 14    - SCR_32_data_valid
// 13    - SCR_32_data
// 12    - SCR_count_en
// 11:0  - SCR90K_DIV
#define PARSER_B_PARSER_SCR_CTL ((0x346d << 2) + 0xffd00000)
// bit 31:0 SCR value
#define PARSER_B_PARSER_SCR ((0x346e << 2) + 0xffd00000)
// bit 31:24 -- insert_loop_number
// bit 23:21 --
// bit 20:16 -- insert_byte_number
// bit 15:0 -- discard number
#define PARSER_B_PARSER_PARAMETER ((0x346f << 2) + 0xffd00000)
// bit 31:0 -- insert data // write only
// write to PARSER_CONTROL will reset the write position
// continous write to this address can write upto 16 bytes
#define PARSER_B_PARSER_INSERT_DATA ((0x3470 << 2) + 0xffd00000)
// Bit 31:24 -- Reserved Stream_ID
// Bit 23:16 -- Sub Stream_ID
// Bit 15:8  -- Audio Stream_ID
// Bit 7:0   -- Video Stream_ID
#define PARSER_B_VAS_STREAM_ID ((0x3471 << 2) + 0xffd00000)
// Bit 31:0 -- VIDEO_DTS
#define PARSER_B_VIDEO_DTS ((0x3472 << 2) + 0xffd00000)
// Bit 31:0 -- VIDEO_PTS
#define PARSER_B_VIDEO_PTS ((0x3473 << 2) + 0xffd00000)
// Bit 31:0 -- VIDEO_PTS_DTS_WR_PTR
#define PARSER_B_VIDEO_PTS_DTS_WR_PTR ((0x3474 << 2) + 0xffd00000)
// Bit 31:0 -- AUDIO_PTS
#define PARSER_B_AUDIO_PTS ((0x3475 << 2) + 0xffd00000)
// Bit 31:0 -- AUDIO_PTS_WR_PTR
#define PARSER_B_AUDIO_PTS_WR_PTR ((0x3476 << 2) + 0xffd00000)
// bit 31:20 -- stream_es_count ( Read Only)
// bit 19 -- req_pending ( parser ddr_A_fifo ) (Read Only)
// bit 18 -- stream_es_passthrough_enable
// bit 17:16 -- stream_es_passthrough_type
// bit 15:13 -- VIDEO2 Ees_write Endian
// bit 12 -- VIDEO2 using manual read point
// bit 11:9 -- SUB Ees_write Endian
// bit 8 -- SUB using manual read point
// bit 7:5 -- AUDIO Ees_write Endian
// bit 4 -- AUDIO using manual read point
// bit 3:1 -- VIDEO Ees_write Endian
// bit 0 -- VIDEO using manual read point
#define PARSER_B_PARSER_ES_CONTROL ((0x3477 << 2) + 0xffd00000)
// Bit 31:0 PFIFO_MONITOR
#define PARSER_B_PFIFO_MONITOR ((0x3478 << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_VIDEO DDR Interface
// --------------------------------------------
// The PARSER_VIDEO start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define PARSER_B_PARSER_VIDEO_START_PTR ((0x3480 << 2) + 0xffd00000)
#define PARSER_B_PARSER_VIDEO_END_PTR ((0x3481 << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_VIDEO Buffer Level Manager
// --------------------------------------------
#define PARSER_B_PARSER_VIDEO_WP ((0x3482 << 2) + 0xffd00000)
#define PARSER_B_PARSER_VIDEO_RP ((0x3483 << 2) + 0xffd00000)
#define PARSER_B_PARSER_VIDEO_HOLE ((0x3484 << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_AUDIO DDR Interface
// --------------------------------------------
// The PARSER_AUDIO start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define PARSER_B_PARSER_AUDIO_START_PTR ((0x3485 << 2) + 0xffd00000)
#define PARSER_B_PARSER_AUDIO_END_PTR ((0x3486 << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_AUDIO Buffer Level Manager
// --------------------------------------------
#define PARSER_B_PARSER_AUDIO_WP ((0x3487 << 2) + 0xffd00000)
#define PARSER_B_PARSER_AUDIO_RP ((0x3488 << 2) + 0xffd00000)
#define PARSER_B_PARSER_AUDIO_HOLE ((0x3489 << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_SUB DDR Interface
// --------------------------------------------
// The PARSER_SUB start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define PARSER_B_PARSER_SUB_START_PTR ((0x348a << 2) + 0xffd00000)
#define PARSER_B_PARSER_SUB_END_PTR ((0x348b << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_SUB Buffer Level Manager
// --------------------------------------------
#define PARSER_B_PARSER_SUB_WP ((0x348c << 2) + 0xffd00000)
#define PARSER_B_PARSER_SUB_RP ((0x348d << 2) + 0xffd00000)
#define PARSER_B_PARSER_SUB_HOLE ((0x348e << 2) + 0xffd00000)
// Bit[31] dma_busy
// Bit[30] cur_fetch_or_es_write
// Bit[29:28] reserved
// Bit[27:24] fetch_status
// Bit[23:0] buffer_cycles_left
#define PARSER_B_PARSER_FETCH_INFO ((0x348f << 2) + 0xffd00000)
// Bit[31:28] ctl_status
// Bit[27:24] insert_byte_offset
// Bit[23:0] es_pack_left_cycle
#define PARSER_B_PARSER_STATUS ((0x3490 << 2) + 0xffd00000)
// Bit [31:16] AUDIO_wrap_count
// Bit  [15:0] VIDEO_wrap_count
#define PARSER_B_PARSER_AV_WRAP_COUNT ((0x3491 << 2) + 0xffd00000)
// bit[29:24] A_brst_num_parser
// bit[21:16] A_id_parser
// bit[11:0] wrrsp_count_parser
#define PARSER_B_WRRSP_PARSER ((0x3492 << 2) + 0xffd00000)
// `define CSS_cmd             12'h200   // address of css command and indirect register
// `define CSS_cntl            12'h201   // css control register
// `define CSS_data            12'h202   // indirect register
// `define CSS_id1_data        12'h203   // ID data for the first and second bytes
// `define CSS_id2_data        12'h204   // ID data for the third and fourth bytes
// CPPM registers
// `define CPPM_IFIFO_CTRL		12'h210	  //CPPM input FIFO control
// `define CPPM_C2BC_KEY		12'h211	  //CPPM C2 Block Cipher Key register
// `define CPPM_C2BC_DIN		12'h212	  //CPPM C2 Block Cipher data input register
// `define CPPM_C2BC_DOUT		12'h213   //CPPM C2 Block Cipher data result register
// `define CPPM_CMD			12'h214   //CPPM command and control register
// `define CPPM_CTRL_STATUS	12'h215   //CPPM control status, mainly for debug
// `define CPPM_IFIFO_DATA		12'h216   //CPPM input FIFO data pop port, just for debug
// --------------------------------------------
// PARSER_VIDEO2 DDR Interface
// --------------------------------------------
// The PARSER_VIDEO2 start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define PARSER_B_PARSER_VIDEO2_START_PTR ((0x3493 << 2) + 0xffd00000)
#define PARSER_B_PARSER_VIDEO2_END_PTR ((0x3494 << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_VIDEO2 Buffer Level Manager
// --------------------------------------------
#define PARSER_B_PARSER_VIDEO2_WP ((0x3495 << 2) + 0xffd00000)
#define PARSER_B_PARSER_VIDEO2_RP ((0x3496 << 2) + 0xffd00000)
#define PARSER_B_PARSER_VIDEO2_HOLE ((0x3497 << 2) + 0xffd00000)
// Bit [31:16] AUDIO_wrap_count
// Bit  [15:0] VIDEO2_wrap_count
#define PARSER_B_PARSER_AV2_WRAP_COUNT ((0x3498 << 2) + 0xffd00000)
// DDR registers
//`define USE_DDR2
//========================================================================
//  DVIN Registers				    (12'h2e0 - 12'h2ef)
//
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DVIN_CBUS_BASE = 0x08
// -----------------------------------------------
// Bit 31:12 Rsrv
// Bit 11:10 RW, vs_hs_tim_ctrl: Controls which edge of HS/VS the active pixel/line is related:
//                               bit[0]=0: start of active pixel is counted from the rising edge
//                               of HS; bit[0]=1: start of active pixel is counted from the
//                               falling edge of HS; bit[1]=0: start of active line is counted
//                               from the rising edge of VS; bit[1]=1: start of active line is
//                               counted from the falling edge of VS.
// Bit     9 RW, sample_clk_neg: 1=invert input dvin_clk
// Bit  8: 7 RW, mode_422to444: 0=No conversion; 1=Rsrv; 2=Convert 422 to 444, use previous C
// value; 3=Convert 422 to 444, use average C value. Bit  6: 5 RW, de_mode: 0x=ignore input DE
// signal, use internal detection to determine active pixel;
//                        10=during active pixel, if DE is low, replace input data with the last
//                        good data before DE goes low; 11=Active pixel is determined by DE, no
//                        internal detection.
// Bit     4 RW, ext_field_sel: 1=Select external input Field, 0=Use internal detected Field.
// Bit     3 RW, field_pol_inv: set to 1 if input Field is low active and ext_field_sel=1
// Bit     2 RW, de_pol_inv: set to 1 if input DE is low active
// Bit     1 RW, vs_pol_inv: set to 1 if input VS is low active
// Bit     0 RW, hs_pol_inv: set to 1 if input HS is low active
#define DVIN_FRONT_END_CTRL ((0x08e0 << 2) + 0xffd00000)
// Bit 31:28 Reserved
// Bit 27:16 RW, hs_lead_vs_odd_max: Criteria for HW detecting odd/even Field internally: max
// clock cycles allowed for HS
//                                   active edge to lead before VS active edge, in odd field.
//                                   Failing it the field is even.
// Bit 15:12 Reserved
// Bit 11: 0 RW, hs_lead_vs_odd_min: Criteria for HW detecting odd/even Field internally -- min
// clock cycles allowed for HS
//                                   active edge to lead before VS active edge, in odd field.
//                                   Failing it the field is even.
#define DVIN_HS_LEAD_VS_ODD ((0x08e1 << 2) + 0xffd00000)
// Bit 31:28 Reserved
// Bit 27:16 RW, active_start_pix_fo
// Bit 15:12 Reserved
// Bit 11: 0 RW, active_start_pix_fe
#define DVIN_ACTIVE_START_PIX ((0x08e2 << 2) + 0xffd00000)
// Bit 31:28 Reserved
// Bit 27:16 RW, active_start_line_fo
// Bit 15:12 Reserved
// Bit 11: 0 RW, active_start_line_fe
#define DVIN_ACTIVE_START_LINE ((0x08e3 << 2) + 0xffd00000)
// Bit 31:28 Reserved
// Bit 27:16 RW, field_height_m1
// Bit 15:12 Reserved
// Bit 11: 0 RW, line_width_m1
#define DVIN_DISPLAY_SIZE ((0x08e4 << 2) + 0xffd00000)
// Bit    31 Rsrv
// Bit    30 R,  vs_in_polarity: 0=active high; 1=active low.
// Bit    29 R,  hs_in_polarity: 0=active high; 1=active low.
// Bit    28 R,  field_odd
// Bit 27:16 R,  hs_lead_vs_cnt
// Bit 15: 4 Rsrv
// Bit  3: 1 RW, data_comp_map: Re-map input data to form YCbCr.
//                              0=YCbCr is {[29:20], [19:10], [ 9: 0]};
//                              1=YCbCr is {[29:20], [ 9: 0], [19:10]};
//                              2=YCbCr is {[ 9: 0], [29:20], [19:10]};
//                              3=YCbCr is {[19:10], [29:20], [ 9: 0]};
//                              4=YCbCr is {[19:10], [ 9: 0], [29:20]};
//                              5=YCbCr is {[ 9: 0], [19:10], [29:20]};
//                              6,7=Rsrv
// Bit     0 RW, dvin_enable
#define DVIN_CTRL_STAT ((0x08e5 << 2) + 0xffd00000)
//========================================================================
//  DOS registers				    APB allocation from 32'hd0050000
//
//========================================================================
//=======================================================================
// XIF module
// `include "xregs.h"
#define X_INT_ADR 0x400
#define GPIO_ADR 0x401
#define GPIO_ADR_H8 0x402
#define WFIFO_DEPTH 8
#define WFIFO_PointerWidth 3
#define WFIFO_WORDSIZE 32
// MAC module
// move them to cpu domain.
//`define CLR_ACC_MAC         12'h410
//`define CLR_ACC_MAC2        12'h411
//`define ACC_0               12'h412
//`define ACC_1               12'h413
//`define ACC_2               12'h414
//`define ACC_3               12'h415
//========================================================================
//  Audio EQ DRC Interface				    (15'h1400 - 15'h14ff)
//
//========================================================================
//`include "audio_eq_drc.h"
//========================================================================
//  Audio Interface				    (12'h500 - 12'h5ff)
//
//========================================================================
//
// Reading file:  aififo_reg.h
//
//========================================================================
//  Audio Interface                                 (8'h00 - 8'hff)
//  Modified : Xuyun Chen Jan 2001
//========================================================================
// Number of bytes expected per NON-PCM frame, including the header.
// 16 bits.
// -----------------------------------------------
// CBUS_BASE:  AIFIFO_CBUS_BASE = 0x14
// -----------------------------------------------
//-----------------------------------------------------------------------------
// add for AIFIFO channel (old $cdrom/rtl/cdr_top/getbit)
//-----------------------------------------------------------------------------
// Bit 3    CRC pop aififo enable
// Bit 2    writing to this bit to 1 causes CRC module reset
// Bit 1    enable aififo
// Bit 0    writing to this bit to 1 causes aififo soft reset
#define AIU_AIFIFO_CTRL ((0x1400 << 2) + 0xffd00000)
//'h0000
// AIFIFO status register
// Bit 13    //aififo request to dcu status
// Bit 12    //dcu select status
// Bit 11:5  //aififo word counter number
// Bit 4:0   //how many bits left in the first pop register
#define AIU_AIFIFO_STATUS ((0x1401 << 2) + 0xffd00000)
// Same funcntion as the AIGBIT of AIFIFO in CDROM module
// write to this register how many bits wanna pop,
// and reading this register gets the corresponding bits data
#define AIU_AIFIFO_GBIT ((0x1402 << 2) + 0xffd00000)
// Same function as the AICLB of AIFIFO in CDROM module
// return the leading zeros by reading this registers
#define AIU_AIFIFO_CLB ((0x1403 << 2) + 0xffd00000)
// --------------------------------------------
// AIFIFO DDR Interface
// --------------------------------------------
// The AIFIFO start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define AIU_MEM_AIFIFO_START_PTR ((0x1404 << 2) + 0xffd00000)
// The current pointer points so some location between the START and END
// pointers.  The current pointer is a BYTE pointer.  That is, you can
// point to any BYTE address within the START/END range
#define AIU_MEM_AIFIFO_CURR_PTR ((0x1405 << 2) + 0xffd00000)
#define AIU_MEM_AIFIFO_END_PTR ((0x1406 << 2) + 0xffd00000)
#define AIU_MEM_AIFIFO_BYTES_AVAIL ((0x1407 << 2) + 0xffd00000)
// AIFIFO FIFO Control
// bit  [15:11] unused
// bit  [10]    use_level       Set this bit to 1 to enable filling of the FIFO controlled by the
// buffer
//                              level control.  If this bit is 0, then use bit[1] to control the
//                              enabling of filling
// bit  [9]     Data Ready.     This bit is set when data can be popped
// bit  [8]     fill busy       This bit will be high when we're fetching data from the DDR memory
//                              To reset this module, set cntl_enable = 0, and then wait for busy
//                              = 0. After that you can pulse cntl_init to start over
// bit  [7]     cntl_endian_jic Just in case endian.  last minute byte swap of the data out of
//                              the FIFO to getbit
// bit  [6]     unused
// bits [5:3]   endian:         see $lib/rtl/ddr_endian.v
// bit  [2]     cntl_empty_en   Set to 1 to enable reading the DDR memory FIFO and filling the
// pipeline to get-bit
//                              Set cntl_empty_en = cntl_fill_en = 0 when pulsing cntl_init
// bit  [1]     cntl_fill_en    Set to 1 to enable reading data from DDR memory
// bit  [0]     cntl_init:      After setting the read pointers, sizes, channel masks
//                              and read masks, set this bit to 1 and then to 0
//                              NOTE:  You don't need to pulse cntl_init if only the start address
//                              is being changed
#define AIU_MEM_AIFIFO_CONTROL ((0x1408 << 2) + 0xffd00000)
// --------------------------------------------
// AIFIFO Buffer Level Manager
// --------------------------------------------
#define AIU_MEM_AIFIFO_MAN_WP ((0x1409 << 2) + 0xffd00000)
#define AIU_MEM_AIFIFO_MAN_RP ((0x140a << 2) + 0xffd00000)
#define AIU_MEM_AIFIFO_LEVEL ((0x140b << 2) + 0xffd00000)
//
// bit  [1]     manual mode     Set to 1 for manual write pointer mode
// bit  [0]     Init            Set high then low after everything has been initialized
#define AIU_MEM_AIFIFO_BUF_CNTL ((0x140c << 2) + 0xffd00000)
#define AIU_MEM_AIFIFO_BUF_WRAP_COUNT ((0x140d << 2) + 0xffd00000)
// bit 29:24 A_brst_num
// bit 21:16 A_id
// bit 15:0 level_hold
#define AIU_MEM_AIFIFO_MEM_CTL ((0x140f << 2) + 0xffd00000)
// bit 31:16 -- drop_bytes
// bit 15:14 -- drop_status (Read-Only)
// bit 13:12 -- sync_match_position (Read-Only)
// bit 11:6 -- reserved
// bit 5:4 -- TIME_STAMP_NUMBER, 0-32bits, 1-64bits, 2-96bits, 3-128bits
// bit 3 -- stamp_soft_reset
// bit 2 -- TIME_STAMP_length_enable
// bit 1 -- TIME_STAMP_sync64_enable
// bit 0 -- TIME_STAMP_enable
#define AIFIFO_TIME_STAMP_CNTL ((0x1410 << 2) + 0xffd00000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_0
#define AIFIFO_TIME_STAMP_SYNC_0 ((0x1411 << 2) + 0xffd00000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_1
#define AIFIFO_TIME_STAMP_SYNC_1 ((0x1412 << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_0
#define AIFIFO_TIME_STAMP_0 ((0x1413 << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_1
#define AIFIFO_TIME_STAMP_1 ((0x1414 << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_2
#define AIFIFO_TIME_STAMP_2 ((0x1415 << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_3
#define AIFIFO_TIME_STAMP_3 ((0x1416 << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_LENGTH
#define AIFIFO_TIME_STAMP_LENGTH ((0x1417 << 2) + 0xffd00000)
//
// Closing file:  aififo_reg.h
//
//========================================================================
//  CDROM Interface                                 (12'h600 - 12'h6ff)
//
//========================================================================
//========================================================================
//	registers for ge2d (12'h8a0 - 12'h8ff)
//========================================================================
////`include "ge2d_regs.h" //  not in cbus domain any more, it is located in vapb3 bus now
//========================================================================
//  DSP Co-Processor Registers			    ( 8'he00 - 12'hfff)
//
//========================================================================
// Duplicate Address:  When actually used
// please move to a different address
// `define AUDIO_COP_CTL1      12'hf00  // r & w; r->
// 6'h00,bsmod[2:0],acmod[2:0],lfeon,nfchans[2:0]
//
// Incorrect format....should be 8'bits only
//
// Removed by Chris Maslyar       `define AUDIO_COP_CTL2      12'hf01  // r & w; r->
// frame_size[12:0],dsurmod[1:0] Removed by Chris Maslyar Removed by Chris Maslyar       //  f02
// -f0d are special regs , not in ac3_reg.h, but used by CPU for AC3 operations Removed by Chris
// Maslyar Removed by Chris Maslyar       `define OPERAND_M_CTL       12'hf02 Removed by Chris
// Maslyar       `define OPERAND1_ADDR       12'hf03 Removed by Chris Maslyar       `define
// OPERAND2_ADDR       12'hf04 Removed by Chris Maslyar       `define RESULT_M_CTL        12'hf05
// Removed by Chris Maslyar       `define RESULT1_ADDR        12'hf06
// Removed by Chris Maslyar       `define RESULT2_ADDR        12'hf07
// Removed by Chris Maslyar       `define ADD_SHFT_CTL        12'hf08
// Removed by Chris Maslyar       `define OPERAND_ONE_H       12'hf09
// Removed by Chris Maslyar       `define OPERAND_ONE_L       12'hf0a
// Removed by Chris Maslyar       `define OPERAND_TWO_H       12'hf0b
// Removed by Chris Maslyar       `define OPERAND_TWO_L       12'hf0c
// Removed by Chris Maslyar       `define RESULT_H            12'hf0d
// Removed by Chris Maslyar
// Removed by Chris Maslyar
// Removed by Chris Maslyar       `define RESULT_M            12'hf0e   // r & w; ac3_reg_14
// Removed by Chris Maslyar
// Removed by Chris Maslyar       // special reg
// Removed by Chris Maslyar       `define RESULT_L            12'hf0f
// Removed by Chris Maslyar
// Removed by Chris Maslyar       //
// Removed by Chris Maslyar       `define WMEM_R_PTR          12'hf10   // r & w ; endmant0 &1
// Removed by Chris Maslyar
// Removed by Chris Maslyar       `define WMEM_W_PTR          12'hf11
// Removed by Chris Maslyar       `define AUDIO_LAYER         12'hf20
// Removed by Chris Maslyar       `define AC3_DECODING        12'hf21
// Removed by Chris Maslyar       `define AC3_DYNAMIC         12'hf22
// Removed by Chris Maslyar       `define AC3_MELODY          12'hf23
// Removed by Chris Maslyar       `define AC3_VOCAL           12'hf24
//========================================================================
//	registers for mipi_dsi (12'h8a0 - 12'h8ff)
//========================================================================
//
// Reading file:  dsi_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// MIPI DSI HOST CONTROLLER Registers 0x1c00 - 0x1cff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  DSI_CBUS_BASE = 0x1c
// -----------------------------------------------
//------------------------------------------------------------------------------
// DWC IP registers: Synopsys IP, please refer to MIPI DSI HOST Databook
//------------------------------------------------------------------------------
#define MIPI_DSI_DWC_VERSION_OS ((0x1c00 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_PWR_UP_OS ((0x1c01 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_CLKMGR_CFG_OS ((0x1c02 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_DPI_VCID_OS ((0x1c03 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_DPI_COLOR_CODING_OS ((0x1c04 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_DPI_CFG_POL_OS ((0x1c05 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_DPI_LP_CMD_TIM_OS ((0x1c06 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_PCKHDL_CFG_OS ((0x1c0b << 2) + 0xffd00000)
#define MIPI_DSI_DWC_GEN_VCID_OS ((0x1c0c << 2) + 0xffd00000)
#define MIPI_DSI_DWC_MODE_CFG_OS ((0x1c0d << 2) + 0xffd00000)
#define MIPI_DSI_DWC_VID_MODE_CFG_OS ((0x1c0e << 2) + 0xffd00000)
#define MIPI_DSI_DWC_VID_PKT_SIZE_OS ((0x1c0f << 2) + 0xffd00000)
#define MIPI_DSI_DWC_VID_NUM_CHUNKS_OS ((0x1c10 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_VID_NULL_SIZE_OS ((0x1c11 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_VID_HSA_TIME_OS ((0x1c12 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_VID_HBP_TIME_OS ((0x1c13 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_VID_HLINE_TIME_OS ((0x1c14 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_VID_VSA_LINES_OS ((0x1c15 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_VID_VBP_LINES_OS ((0x1c16 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_VID_VFP_LINES_OS ((0x1c17 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_VID_VACTIVE_LINES_OS ((0x1c18 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_EDPI_CMD_SIZE_OS ((0x1c19 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_CMD_MODE_CFG_OS ((0x1c1a << 2) + 0xffd00000)
#define MIPI_DSI_DWC_GEN_HDR_OS ((0x1c1b << 2) + 0xffd00000)
#define MIPI_DSI_DWC_GEN_PLD_DATA_OS ((0x1c1c << 2) + 0xffd00000)
#define MIPI_DSI_DWC_CMD_PKT_STATUS_OS ((0x1c1d << 2) + 0xffd00000)
#define MIPI_DSI_DWC_TO_CNT_CFG_OS ((0x1c1e << 2) + 0xffd00000)
#define MIPI_DSI_DWC_HS_RD_TO_CNT_OS ((0x1c1f << 2) + 0xffd00000)
#define MIPI_DSI_DWC_LP_RD_TO_CNT_OS ((0x1c20 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_HS_WR_TO_CNT_OS ((0x1c21 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_LP_WR_TO_CNT_OS ((0x1c22 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_BTA_TO_CNT_OS ((0x1c23 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_SDF_3D_OS ((0x1c24 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_LPCLK_CTRL_OS ((0x1c25 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_PHY_TMR_LPCLK_CFG_OS ((0x1c26 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_PHY_TMR_CFG_OS ((0x1c27 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_PHY_RSTZ_OS ((0x1c28 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_PHY_IF_CFG_OS ((0x1c29 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_PHY_ULPS_CTRL_OS ((0x1c2a << 2) + 0xffd00000)
#define MIPI_DSI_DWC_PHY_TX_TRIGGERS_OS ((0x1c2b << 2) + 0xffd00000)
#define MIPI_DSI_DWC_PHY_STATUS_OS ((0x1c2c << 2) + 0xffd00000)
#define MIPI_DSI_DWC_PHY_TST_CTRL0_OS ((0x1c2d << 2) + 0xffd00000)
#define MIPI_DSI_DWC_PHY_TST_CTRL1_OS ((0x1c2e << 2) + 0xffd00000)
#define MIPI_DSI_DWC_INT_ST0_OS ((0x1c2f << 2) + 0xffd00000)
#define MIPI_DSI_DWC_INT_ST1_OS ((0x1c30 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_INT_MSK0_OS ((0x1c31 << 2) + 0xffd00000)
#define MIPI_DSI_DWC_INT_MSK1_OS ((0x1c32 << 2) + 0xffd00000)
//------------------------------------------------------------------------------
// Top-level registers: AmLogic proprietary
//------------------------------------------------------------------------------
// 31: 4    Reserved. Default 0.
//     3 RW ~tim_rst_n:  1=Assert SW reset on mipi_dsi_host_timing block.   0=Release reset.
//     Default 1. 2 RW ~dpi_rst_n:  1=Assert SW reset on mipi_dsi_host_dpi block.      0=Release
//     reset.    Default 1. 1 RW ~intr_rst_n: 1=Assert SW reset on mipi_dsi_host_intr block.
//     0=Release reset.    Default 1. 0 RW ~dwc_rst_n:  1=Assert SW reset on IP core. 0=Release
//     reset.    Default 1.
#define MIPI_DSI_TOP_SW_RESET ((0x1cf0 << 2) + 0xffd00000)
// 31: 5    Reserved. Default 0.
//     4 RW manual_edpihalt:  1=Manual suspend VencL; 0=do not suspend VencL. Default 0. 3 RW
//     auto_edpihalt_en: 1=Enable IP's edpihalt signal to suspend VencL; 0=IP's edpihalt signal
//     does not affect VencL. Default 0. 2 RW clock_freerun: Apply to auto-clock gate only.
//     Default 0.
//                          0=Default, use auto-clock gating to save power;
//                          1=use free-run clock, disable auto-clock gating, for debug mode.
//     1 RW enable_pixclk: A manual clock gate option, due to DWC IP does not have auto-clock
//     gating. 1=Enable pixclk.      Default 0. 0 RW enable_sysclk: A manual clock gate option,
//     due to DWC IP does not have auto-clock gating. 1=Enable sysclk.      Default 0.
#define MIPI_DSI_TOP_CLK_CNTL ((0x1cf1 << 2) + 0xffd00000)
// 31:27    Reserved. Default 0.
//    26 RW de_dpi_pol:     1= Invert DE polarity from mipi_dsi_host_dpi. Default 0. 25 RW
//    hsync_dpi_pol:  1= Invert HS polarity from mipi_dsi_host_dpi.                   Default 0.
//    24 RW vsync_dpi_pol:  1= Invert VS polarity from mipi_dsi_host_dpi. Default 0.
// 23:20 RW dpi_color_mode: Define DPI pixel format. Default 0.
//                           0=16-bit RGB565 config 1;
//                           1=16-bit RGB565 config 2;
//                           2=16-bit RGB565 config 3;
//                           3=18-bit RGB666 config 1;
//                           4=18-bit RGB666 config 2;
//                           5=24-bit RGB888;
//                           6=20-bit YCbCr 4:2:2;
//                           7=24-bit YCbCr 4:2:2;
//                           8=16-bit YCbCr 4:2:2;
//                           9=30-bit RGB;
//                          10=36-bit RGB;
//                          11=12-bit YCbCr 4:2:0.
//    19    Reserved. Default 0.
// 18:16 RW in_color_mode:  Define VENC data width. Default 0.
//                          0=30-bit pixel;
//                          1=24-bit pixel;
//                          2=18-bit pixel, RGB666;
//                          3=16-bit pixel, RGB565.
// 15:14 RW chroma_subsample: Define method of chroma subsampling. Default 0.
//                            Applicable to YUV422 or YUV420 only.
//                            0=Use even pixel's chroma;
//                            1=Use odd pixel's chroma;
//                            2=Use averaged value between even and odd pair.
// 13:12 RW comp2_sel:  Select which component to be Cr or B: 0=comp0; 1=comp1; 2=comp2.
// Default 2. 11:10 RW comp1_sel:  Select which component to be Cb or G: 0=comp0; 1=comp1;
// 2=comp2.    Default 1.
//  9: 8 RW comp0_sel:  Select which component to be Y  or R: 0=comp0; 1=comp1; 2=comp2. Default
//  0.
//     7    Reserved. Default 0. 6 RW de_venc_pol:    1= Invert DE polarity from VENC. Default 0.
//     5 RW hsync_venc_pol: 1= Invert HS polarity from VENC. Default 0. 4 RW vsync_venc_pol: 1=
//     Invert VS polarity from VENC.                                Default 0. 3 RW dpicolorm:
//     Signal to IP.                                                   Default 0. 2 RW dpishutdn:
//     Signal to IP.                                                   Default 0. 1    Reserved.
//     Default 0. 0    Reserved. Default 0.
#define MIPI_DSI_TOP_CNTL ((0x1cf2 << 2) + 0xffd00000)
// 31:16    Reserved. Default 0. 15: 8 RW suspend_frame_rate: Define rate of timed-suspend.
// Default 0.
//                              0=Execute suspend every frame; 1=Every other frame; ...; 255=Every
//                              256 frame.
//  7: 3    Reserved. Default 0.
//     2 RW timed_suspend_en:   1=Enable timed suspend VencL. 0=Disable timed suspend. Default 0.
//     1 RW manual_suspend_en:  1=Enable manual suspend VencL. 1=Cancel manual suspend VencL.
//     Default 0. 0 RW suspend_on_edpihalt:1=Enable IP's edpihalt signal to suspend VencL; 0=IP's
//     edpihalt signal does not affect VencL.   Default 1.
#define MIPI_DSI_TOP_SUSPEND_CNTL ((0x1cf3 << 2) + 0xffd00000)
// 31:29    Reserved. Default 0. 28:16 RW suspend_line_end:   Define timed-suspend region. Suspend
// from [pix_start,line_start] to [pix_end,line_end].         Default 0. 15:13    Reserved.
// Default 0. 12: 0 RW suspend_line_start: Define timed-suspend region. Suspend from
// [pix_start,line_start] to [pix_end,line_end].         Default 0.
#define MIPI_DSI_TOP_SUSPEND_LINE ((0x1cf4 << 2) + 0xffd00000)
// 31:29    Reserved. Default 0. 28:16 RW suspend_pix_end:    Define timed-suspend region. Suspend
// from [pix_start,line_start] to [pix_end,line_end].         Default 0. 15:13    Reserved.
// Default 0. 12: 0 RW suspend_pix_start:  Define timed-suspend region. Suspend from
// [pix_start,line_start] to [pix_end,line_end].         Default 0.
#define MIPI_DSI_TOP_SUSPEND_PIX ((0x1cf5 << 2) + 0xffd00000)
// 31:20    Reserved. Default 0. 19:10 RW meas_vsync:     Control on measuring Host Controller's
// vsync.                                                       Default 0.
//                          [   19] meas_en:        1=Enable measurement
//                          [   18] accum_meas_en:  0=meas_count is cleared at the end of each
//                          measure;
//                                                  1=meas_count is accumulated at the end of each
//                                                  measure.
//                          [17:10] vsync_span:     Define the duration of a measure is to last
//                          for how many Vsyncs.
//  9: 0 RW meas_edpite:    Control on measuring Display Slave's edpite. Default 0.
//                          [    9] meas_en:        1=Enable measurement
//                          [    8] accum_meas_en:  0=meas_count is cleared at the end of each
//                          measure;
//                                                  1=meas_count is accumulated at the end of each
//                                                  measure.
//                          [ 7: 0] edpite_span:    Define the duration of a measure is to last
//                          for how many edpite.
#define MIPI_DSI_TOP_MEAS_CNTL ((0x1cf6 << 2) + 0xffd00000)
//    31 R  stat_edpihalt:  status of edpihalt signal from IP.              Default 0.
// 30:29    Reserved.                                                       Default 0.
// 28:16 R  stat_te_line:   Snapshot of Host's line position at edpite.     Default 0.
// 15:13    Reserved.                                                       Default 0.
// 12: 0 R  stat_te_pix:    Snapshot of Host's pixel position at edpite.    Default 0.
#define MIPI_DSI_TOP_STAT ((0x1cf7 << 2) + 0xffd00000)
// To measure display slave's frame rate, we can use a reference clock to measure the duration of
// one of more edpite pulse(s). Measurement control is by register MIPI_DSI_TOP_MEAS_CNTL
// bit[9:0]. Reference clock comes from clk_rst_tst.cts_dsi_meas_clk, and is defined by HIU
// register HHI_VDIN_MEAS_CLK_CNTL bit[23:12]. Mesurement result is in MIPI_DSI_TOP_MEAS_STAT_TE0
// and MIPI_DSI_TOP_MEAS_STAT_TE1, as below: edpite_meas_count[47:0]: Number of reference clock
// cycles counted during one measure period (non-incremental measure), or
//                          during all measure periods so far (incremental measure).
// edpite_meas_count_n[3:0]:Number of measure periods has been done. Number can wrap over.
//
// 31: 0 R  edpite_meas_count[31:0].    Default 0.
#define MIPI_DSI_TOP_MEAS_STAT_TE0 ((0x1cf8 << 2) + 0xffd00000)
// 19:16 R  edpite_meas_count_n.        Default 0.
// 15: 0 R  edpite_meas_count[47:32].   Default 0.
#define MIPI_DSI_TOP_MEAS_STAT_TE1 ((0x1cf9 << 2) + 0xffd00000)
// To measure Host's frame rate, we can use a reference clock to measure the duration of one of
// more Vsync pulse(s). Measurement control is by register MIPI_DSI_TOP_MEAS_CNTL bit[19:10].
// Reference clock comes from clk_rst_tst.cts_dsi_meas_clk, and is defined by HIU register
// HHI_VDIN_MEAS_CLK_CNTL bit[23:12]. Mesurement result is in MIPI_DSI_TOP_MEAS_STAT_VS0 and
// MIPI_DSI_TOP_MEAS_STAT_VS1, as below: vsync_meas_count[47:0]:  Number of reference clock cycles
// counted during one measure period (non-incremental measure), or
//                          during all measure periods so far (incremental measure).
// vsync_meas_count_n[3:0]: Number of measure periods has been done. Number can wrap over.
//
// 31: 0 R  vsync_meas_count[31:0].     Default 0.
#define MIPI_DSI_TOP_MEAS_STAT_VS0 ((0x1cfa << 2) + 0xffd00000)
// 19:16 R  vsync_meas_count_n.         Default 0.
// 15: 0 R  vsync_meas_count[47:32].    Default 0.
#define MIPI_DSI_TOP_MEAS_STAT_VS1 ((0x1cfb << 2) + 0xffd00000)
// 31:16 RW intr_stat/clr. For each bit, read as this interrupt level status, write 1 to clear.
// Default 0.
//                         Note: To clear the interrupt level, simply write 1 to the specific bit,
//                         no need to write 0 afterwards.
//          [31:22] Reserved
//          [   21] stat/clr of EOF interrupt
//          [   20] stat/clr of de_fall interrupt
//          [   19] stat/clr of de_rise interrupt
//          [   18] stat/clr of vs_fall interrupt
//          [   17] stat/clr of vs_rise interrupt
//          [   16] stat/clr of dwc_edpite interrupt
// 15: 0 RW intr_enable. For each bit, 1=enable this interrupt, 0=disable. Default 0.
//          [15: 6] Reserved
//          [    5] EOF (End_Of_Field) interrupt
//          [    4] de_fall interrupt
//          [    3] de_rise interrupt
//          [    2] vs_fall interrupt
//          [    1] vs_rise interrupt
//          [    0] dwc_edpite interrupt
#define MIPI_DSI_TOP_INTR_CNTL_STAT ((0x1cfc << 2) + 0xffd00000)
// 31: 2    Reserved.   Default 0.
//  1: 0 RW mem_pd.     Default 3.
#define MIPI_DSI_TOP_MEM_PD ((0x1cfd << 2) + 0xffd00000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  dsi_regs.h
//
//======================================
//  CPU Assist module
//
//======================================
// -----------------------------------------------
// CBUS_BASE:  ASSIST_CBUS_BASE = 0x20
// -----------------------------------------------
//`define ASSIST_AMR_MBOX1_INT          8'h4d
//`define ASSIST_AMR_MBOX2_INT          8'h4e
#define ASSIST_AMR_SCRATCH0 ((0x204f << 2) + 0xffd00000)
#define ASSIST_AMR_SCRATCH1 ((0x2050 << 2) + 0xffd00000)
#define ASSIST_AMR_SCRATCH2 ((0x2051 << 2) + 0xffd00000)
#define ASSIST_AMR_SCRATCH3 ((0x2052 << 2) + 0xffd00000)
#define ASSIST_HW_REV ((0x2053 << 2) + 0xffd00000)
//`define ASSIST_CBUS_ARB               8'h54
#define ASSIST_POR_CONFIG ((0x2055 << 2) + 0xffd00000)
#define ASSIST_SPARE16_REG1 ((0x2056 << 2) + 0xffd00000)
#define ASSIST_SPARE16_REG2 ((0x2057 << 2) + 0xffd00000)
#define ASSIST_SPARE8_REG1 ((0x2058 << 2) + 0xffd00000)
#define ASSIST_SPARE8_REG2 ((0x2059 << 2) + 0xffd00000)
// Duplicate Address...when used please move to a new address
// `define TO_AMRISC_REG                 8'h59 // for amrisc
#define ASSIST_SPARE8_REG3 ((0x205a << 2) + 0xffd00000)
// Duplicate Address...when used please move to a new address
// `define FROM_AMRISC_REG               8'h5a // for amrisc
// Duplicate Address...when used please move to a new address
// `define MPEG2_DECODER_CONTROL         8'h5b // for amrisc
#define AC3_CTRL_REG1 ((0x205b << 2) + 0xffd00000)
#define AC3_CTRL_REG2 ((0x205c << 2) + 0xffd00000)
#define AC3_CTRL_REG3 ((0x205d << 2) + 0xffd00000)
#define AC3_CTRL_REG4 ((0x205e << 2) + 0xffd00000)
//`define ASSIST_PMEM_SPLIT             8'h5f
#define ASSIST_GEN_CNTL ((0x2068 << 2) + 0xffd00000)
#define EE_ASSIST_MBOX0_IRQ_REG ((0x2070 << 2) + 0xffd00000)
#define EE_ASSIST_MBOX0_CLR_REG ((0x2071 << 2) + 0xffd00000)
#define EE_ASSIST_MBOX0_MASK ((0x2072 << 2) + 0xffd00000)
#define EE_ASSIST_MBOX0_FIQ_SEL ((0x2073 << 2) + 0xffd00000)
#define EE_ASSIST_MBOX1_IRQ_REG ((0x2074 << 2) + 0xffd00000)
#define EE_ASSIST_MBOX1_CLR_REG ((0x2075 << 2) + 0xffd00000)
#define EE_ASSIST_MBOX1_MASK ((0x2076 << 2) + 0xffd00000)
#define EE_ASSIST_MBOX1_FIQ_SEL ((0x2077 << 2) + 0xffd00000)
#define EE_ASSIST_MBOX2_IRQ_REG ((0x2078 << 2) + 0xffd00000)
#define EE_ASSIST_MBOX2_CLR_REG ((0x2079 << 2) + 0xffd00000)
#define EE_ASSIST_MBOX2_MASK ((0x207a << 2) + 0xffd00000)
#define EE_ASSIST_MBOX2_FIQ_SEL ((0x207b << 2) + 0xffd00000)
#define EE_ASSIST_MBOX3_IRQ_REG ((0x207c << 2) + 0xffd00000)
#define EE_ASSIST_MBOX3_CLR_REG ((0x207d << 2) + 0xffd00000)
#define EE_ASSIST_MBOX3_MASK ((0x207e << 2) + 0xffd00000)
#define EE_ASSIST_MBOX3_FIQ_SEL ((0x207f << 2) + 0xffd00000)
//
// Reading file:  demod_reg.h
//
//========================================================================
//  Demod Interface                                 ()
//  Modified : Shixi Bu
//========================================================================
//
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  DEMOD_TOP_CBUS_BASE = 0x3c
// -----------------------------------------------
#define DEMOD_MODE1_REG ((0x3c00 << 2) + 0xff670000)
#define DEMOD_MODE2_REG ((0x3c0c << 2) + 0xff670000)
#define DEMOD_DVBT2_SEL_REG ((0x3c10 << 2) + 0xff670000)
#define DEMOD_DVBT2_CLK_DIV_REG ((0x3c1c << 2) + 0xff670000)
// -----------------------------------------------
// CBUS_BASE:  DEMOD_DVBT2_CBUS_BASE = 0x00
// -----------------------------------------------
#define DVBT2_RESV0_REG ((0x0004 << 2) + 0xff670000)
#define DVBT2_RESV1_REG ((0x0005 << 2) + 0xff670000)
#define DVBT2_RESV2_REG ((0x0006 << 2) + 0xff670000)
#define DVBT2_RESV3_REG ((0x0007 << 2) + 0xff670000)
#define MAC_ARC_CONTROL_REG ((0x0008 << 2) + 0xff670000)
#define MAC_ARC_STATUS_REG ((0x0009 << 2) + 0xff670000)
#define MAC_AHBABT_CONTROL0_REG ((0x000a << 2) + 0xff670000)
#define MAC_AHBABT_CONTROL1_REG ((0x000b << 2) + 0xff670000)
#define SOFT_RESET_CTRL_REG ((0x000c << 2) + 0xff670000)
#define DEMOD_MODE_REG ((0x000d << 2) + 0xff670000)
#define DIG_TIMEBASE_REG ((0x000e << 2) + 0xff670000)
#define RG_CPU_CTRL_REG ((0x002c << 2) + 0xff670000)
#define RG_CPU_STATUS1_REG ((0x002d << 2) + 0xff670000)
#define RG_CPU_STATUS2_REG ((0x002e << 2) + 0xff670000)
//
// Closing file:  demod_reg.h
//
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  ./register_map.h
//
//
// Reading file:  ./vcbus_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
//`define RDMA_VCBUS_BASE         8'h11
//===========================================================================
//
// Reading file:  rdma_regs.h
//
//===========================================================================
// RDMA registers 0x00 - 0xff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  RDMA_VCBUS_BASE = 0x11
// -----------------------------------------------
// Bit 31: 0 RW AHB start address for manual start DMA
#define RDMA_AHB_START_ADDR_MAN ((0x1100 << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for manual start DMA
#define RDMA_AHB_END_ADDR_MAN ((0x1101 << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 1
#define RDMA_AHB_START_ADDR_1 ((0x1102 << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 1
#define RDMA_AHB_END_ADDR_1 ((0x1103 << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 2
#define RDMA_AHB_START_ADDR_2 ((0x1104 << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 2
#define RDMA_AHB_END_ADDR_2 ((0x1105 << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 3
#define RDMA_AHB_START_ADDR_3 ((0x1106 << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 3
#define RDMA_AHB_END_ADDR_3 ((0x1107 << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 4
#define RDMA_AHB_START_ADDR_4 ((0x1108 << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 4
#define RDMA_AHB_END_ADDR_4 ((0x1109 << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 5
#define RDMA_AHB_START_ADDR_5 ((0x110a << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 5
#define RDMA_AHB_END_ADDR_5 ((0x110b << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 6
#define RDMA_AHB_START_ADDR_6 ((0x110c << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 6
#define RDMA_AHB_END_ADDR_6 ((0x110d << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 7
#define RDMA_AHB_START_ADDR_7 ((0x110e << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 7
#define RDMA_AHB_END_ADDR_7 ((0x110f << 2) + 0xff900000)
// Auto start DMA control:
// Bit 31:24 RW ctrl_enable_int_3. Interrupt inputs enable mask for source 3.
// Bit 23:16 RW ctrl_enable_int_2. Interrupt inputs enable mask for source 2.
// Bit 15: 8 RW ctrl_enable_int_1. Interrupt inputs enable mask for source 1.
// Bit     7 RW ctrl_cbus_write_3. Register read/write mode for auto-start 3. 1=Register write;
// 0=Register read. Bit     6 RW ctrl_cbus_write_3. Register read/write mode for auto-start 2.
// 1=Register write; 0=Register read. Bit     5 RW ctrl_cbus_write_3. Register read/write mode for
// auto-start 1. 1=Register write; 0=Register read. Bit     4 R  Rsrv. Bit     3 RW
// ctrl_cbus_addr_incr_3. 1=Incremental register access for auto-start 3; 0=Non-incremental
// (individual) register access. Bit     2 RW ctrl_cbus_addr_incr_2. 1=Incremental register access
// for auto-start 2; 0=Non-incremental (individual) register access. Bit     1 RW
// ctrl_cbus_addr_incr_1. 1=Incremental register access for auto-start 1; 0=Non-incremental
// (individual) register access. Bit     0 R  Rsrv.
#define RDMA_ACCESS_AUTO ((0x1110 << 2) + 0xff900000)
#define RDMA_ACCESS_AUTO2 ((0x1111 << 2) + 0xff900000)
// Manual start DMA control:
// Bit 31: 3 R  Rsrv.
// Bit     2 RW ctrl_cbus_write_man. Register read/write mode for manual-start. 1=Register write;
// 0=Register read. Bit     1 RW ctrl_cbus_addr_incr_man. 1=Incremental register access for
// manual-start; 0=Non-incremental (individual) register access. Bit     0 W  ctrl_start_man.
// Write 1 to this bit to manual-start DMA. This bit always read back 0.
#define RDMA_ACCESS_MAN ((0x1113 << 2) + 0xff900000)
// RDMA general control:
// Bit 31:25 R  Rsrv.
// Bit    24 W  ctrl_clr_rdma_done_int. Write 1 to reset rdma_int level to 0. No need to clear
// this bit. Bit 23:19 R  Rsrv. Bit 18:13 R  Rsrv. Bit 12: 7 R  Rsrv. Bit     6 RW
// ctrl_ddr_urgent. Bit  5: 4 RW ctrl_ahb_wr_burst_size. 0=ABH write request burst size 16;
//                                      1=ABH write request burst size 24;
//                                      2=ABH write request burst size 32;
//                                      3=ABH write request burst size 48.
// Bit  3: 2 RW ctrl_ahb_rd_burst_size. 0=ABH read request burst size 16;
//                                      1=ABH read request burst size 24;
//                                      2=ABH read request burst size 32;
//                                      3=ABH read request burst size 48.
// Bit     1 RW ctrl_sw_reset. 1=Reset RDMA logics except register.
// Bit     0 RW ctrl_free_clk_enable. 0=Default, Enable clock gating. 1=No clock gating, enable
// free clock.
#define RDMA_CTRL ((0x1114 << 2) + 0xff900000)
// Read only.
// Bit 31:29 R  Rsrv.
// Bit    28 R  rdma_done_int.
// Bit 27:25 R  Rsrv.
// Bit 24:18 R  ahb_wrfifo_cnt. FIFO for buffering CBus read data to be sent to AHB
// Bit 17:11 R  ahb_rdfifo_cnt. FIFO for buffering data read from AHB.
// Bit 10: 8 R  ddr_req_st. =0 -- Idle; !=0 -- AHB interfacing ongoing.
// Bit  7: 4 R  curr_req. Latest requests that is being/been serviced. E.g. 0000=Idle; 0010=Latest
// serviced request is Req 1. Bit  3: 0 R  req_latch. Requests that are yet to be serviced. E.g.
// 0000=No request; 0001=Req 0 waiting; 1100=Req 2 and 3 waiting.
#define RDMA_STATUS ((0x1115 << 2) + 0xff900000)
#define RDMA_STATUS2 ((0x1116 << 2) + 0xff900000)
#define RDMA_STATUS3 ((0x1117 << 2) + 0xff900000)
#define RDMA_ACCESS_AUTO4 ((0x1118 << 2) + 0xff900000)
#define RDMA_SRAM_CNTL ((0x1120 << 2) + 0xff900000)
#define RDMA_SRAM_REGADDR ((0x1121 << 2) + 0xff900000)
#define RDMA_SRAM_REGDATA ((0x1122 << 2) + 0xff900000)
#define RDMA_AUTO_SRC1_SEL ((0x1123 << 2) + 0xff900000)
#define RDMA_AUTO_SRC2_SEL ((0x1124 << 2) + 0xff900000)
#define RDMA_AUTO_SRC3_SEL ((0x1125 << 2) + 0xff900000)
#define RDMA_AUTO_SRC4_SEL ((0x1126 << 2) + 0xff900000)
#define RDMA_AUTO_SRC5_SEL ((0x1127 << 2) + 0xff900000)
#define RDMA_AUTO_SRC6_SEL ((0x1128 << 2) + 0xff900000)
#define RDMA_AUTO_SRC7_SEL ((0x1129 << 2) + 0xff900000)
// Bit  1: 0 RW AHB start address[33:32] for manual start DMA
#define RDMA_AHB_START_ADDR_MAN_MSB ((0x1130 << 2) + 0xff900000)
// Bit  1: 0 RW AHB end address[33:32] for manual start DMA
#define RDMA_AHB_END_ADDR_MAN_MSB ((0x1131 << 2) + 0xff900000)
// Bit  1: 0 RW AHB start address[33:32] for auto start source 1
#define RDMA_AHB_START_ADDR_1_MSB ((0x1132 << 2) + 0xff900000)
// Bit  1: 0 RW AHB end address[33:32] for auto start source 1
#define RDMA_AHB_END_ADDR_1_MSB ((0x1133 << 2) + 0xff900000)
// Bit  1: 0 RW AHB start address[33:32] for auto start source 2
#define RDMA_AHB_START_ADDR_2_MSB ((0x1134 << 2) + 0xff900000)
// Bit  1: 0 RW AHB end address[33:32] for auto start source 2
#define RDMA_AHB_END_ADDR_2_MSB ((0x1135 << 2) + 0xff900000)
// Bit  1: 0 RW AHB start address[33:32] for auto start source 3
#define RDMA_AHB_START_ADDR_3_MSB ((0x1136 << 2) + 0xff900000)
// Bit  1: 0 RW AHB end address[33:32] for auto start source 3
#define RDMA_AHB_END_ADDR_3_MSB ((0x1137 << 2) + 0xff900000)
// Bit  1: 0 RW AHB start address[33:32] for auto start source 4
#define RDMA_AHB_START_ADDR_4_MSB ((0x1138 << 2) + 0xff900000)
// Bit  1: 0 RW AHB end address[33:32] for auto start source 4
#define RDMA_AHB_END_ADDR_4_MSB ((0x1139 << 2) + 0xff900000)
// Bit  1: 0 RW AHB start address[33:32] for auto start source 5
#define RDMA_AHB_START_ADDR_5_MSB ((0x113a << 2) + 0xff900000)
// Bit  1: 0 RW AHB end address[33:32] for auto start source 5
#define RDMA_AHB_END_ADDR_5_MSB ((0x113b << 2) + 0xff900000)
// Bit  1: 0 RW AHB start address[33:32] for auto start source 6
#define RDMA_AHB_START_ADDR_6_MSB ((0x113c << 2) + 0xff900000)
// Bit  1: 0 RW AHB end address[33:32] for auto start source 6
#define RDMA_AHB_END_ADDR_6_MSB ((0x113d << 2) + 0xff900000)
// Bit  1: 0 RW AHB start address[33:32] for auto start source 7
#define RDMA_AHB_START_ADDR_7_MSB ((0x113e << 2) + 0xff900000)
// Bit  1: 0 RW AHB end address[33:32] for auto start source 7
#define RDMA_AHB_END_ADDR_7_MSB ((0x113f << 2) + 0xff900000)
//
// Closing file:  rdma_regs.h
//
//===========================================================================
//`define    VDIN0_VCBUS_BASE     8'h12
//===========================================================================
//
// Reading file:  vpu_vdin0_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// VDIN
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VDIN0_VCBUS_BASE = 0x12
// -----------------------------------------------
//
// Reading file:  vpu_vdin_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// VDIN
//===========================================================================
#define VDIN_SCALE_COEF_IDX ((0x1200 << 2) + 0xff900000)
#define VDIN_SCALE_COEF ((0x1201 << 2) + 0xff900000)
// bit 31,   mpeg_to_vdin_sel, 0: mpeg source to NR directly, 1: mpeg source pass through here
// bit 30,   mpeg_field info which can be written by software
// Bit 29,   force go_field, pulse signal
// Bit 28,   force go_line, pulse signal
// Bit 27,   enable mpeg_go_field input signal
// Bit 26:20, hold lines
// Bit 19,   delay go_field function enable
// Bit 18:12, delay go_field line number
// Bit 11:10, component2 output switch, 00: select component0 in, 01: select component1 in, 10:
// select component2 in Bit 9:8, component1 output switch, 00: select component0 in, 01: select
// component1 in, 10: select component2 in Bit 7:6, component0 output switch, 00: select
// component0 in, 01: select component1 in, 10: select component2 in Bit 5,   input window
// selection function enable Bit 4, enable VDIN common data input, otherwise there will be no
// video data input Bit 3:0 vdin selection, 1: mpeg_in from dram, 2: bt656 input, 3: component
// input, 4: tvdecoder input, 5: hdmi rx input, 6: digtial video input, 7: loopback from Viu1, 8:
// MIPI.
#define VDIN_COM_CTRL0 ((0x1202 << 2) + 0xff900000)
// Bit 28:16 active_max_pix_cnt, readonly
// Bit 12:0  active_max_pix_cnt_shadow, readonly
#define VDIN_ACTIVE_MAX_PIX_CNT_STATUS ((0x1203 << 2) + 0xff900000)
// Bit 28:16 go_line_cnt, readonly
// Bit 12:0  active_line_cnt, readonly
#define VDIN_LCNT_STATUS ((0x1204 << 2) + 0xff900000)
// Readonly
// Bit [14:3] lfifo_buf_cnt
// Bit 2, vdin_direct_done status
// Bit 1, vdin_nr_done status
// Bit 0, field
#define VDIN_COM_STATUS0 ((0x1205 << 2) + 0xff900000)
// Readonly
// Bit 31, vdi4 fifo overflow
// Bit 29:24, vdi3_asfifo_cnt
// Bit 23, vdi3 fifo overflow
// Bit 21:16, vdi3_asfifo_cnt
// Bit 15, vdi2 fifo overflow
// Bit 13:8, vdi2_asfifo_cnt
// Bit 7, vdi1 fifo overflow
// Bit 5:0, vdi1_asfifo_cnt
#define VDIN_COM_STATUS1 ((0x1206 << 2) + 0xff900000)
// Bit 28:16 go_line_cnt_shadow, readonly
// Bit 12:0  active_line_cnt_shadow, readonly
#define VDIN_LCNT_SHADOW_STATUS ((0x1207 << 2) + 0xff900000)
// each 8bit asfifo_ctrl is following:
// Bit 7, DE  enable
// Bit 6, go field enable
// Bit 5, go line enable
// Bit 4, if true, negative active input vsync
// Bit 3, if true, negative active input hsync
// Bit 2, vsync soft reset fifo enable
// Bit 1, overflow status clear
// Bit 0 asfifo soft reset, level signal
// Bit 7:0 vdi1 asfifo_ctrl
// Bit 23:16 vdi2 asfifo_ctrl
#define VDIN_ASFIFO_CTRL0 ((0x1208 << 2) + 0xff900000)
// Bit 7:0 vdi3 asfifo_ctrl
// Bit 23:16 vdi4 asfifo_ctrl
#define VDIN_ASFIFO_CTRL1 ((0x1209 << 2) + 0xff900000)
// Bit 28:16 input width minus 1, after the window function
// Bit 12:0  output width minus 1
#define VDIN_WIDTHM1I_WIDTHM1O ((0x120a << 2) + 0xff900000)
// Bit 20:17 prehsc_mode, bit 3:2, prehsc odd line interp mode, bit 1:0, prehsc even line interp
// mode,
//           each 2bit, 00: pix0+pix1/2, average, 01: pix1, 10: pix0
// Bit 16:15 sp422_mode, special mode for the component1 and component2, 00: normal case, 01: 32
// 64 32, 10: 0 64 64 0, 11: 16 96 16 Bit 14:8, hsc_ini_pixi_ptr, signed data, only useful when
// short_lineo_en is true Bit 7, prehsc_en Bit 6, hsc_en, Bit 5, hsc_short_lineo_en, short line
// output enable Bit 4, hsc_nearest_en Bit 3, hsc_phase0_always_en Bit 2:0, hsc_bank_length
#define VDIN_SC_MISC_CTRL ((0x120b << 2) + 0xff900000)
// Bit 28:24, integer portion
// Bit 23:0, fraction portion
#define VDIN_HSC_PHASE_STEP ((0x120c << 2) + 0xff900000)
// Bit 30:29    hscale rpt_p0_num
// Bit 28:24    hscale ini_rcv_num
// Bit 23:0     hscale ini_phase
#define VDIN_HSC_INI_CTRL ((0x120d << 2) + 0xff900000)
// Read only
// Bit 23, vdi7 fifo overflow
// Bit 21:16, vdi7_asfifo_cnt
// Bit 15, vdi6 fifo overflow
// Bit 13:8, vdi6_asfifo_cnt
// Bit 7, vdi5 fifo overflow
// Bit 5:0, vdi5_asfifo_cnt
#define VDIN_COM_STATUS2 ((0x120e << 2) + 0xff900000)
// Bit 25:16 asfifo decimate control
// Bit 25, if true, decimation counter sync with first valid DE in the field,
// otherwise the decimation counter is not sync with external signal
// Bit 24, decimation de enable
// Bit 23:20, decimation phase, which counter value use to decimate,
// Bit 19:16, decimation number, 0: not decimation, 1: decimation 2, 2: decimation 3 ....
// Bit 7:0 vdi5 asfifo_ctrl
#define VDIN_ASFIFO_CTRL2 ((0x120f << 2) + 0xff900000)
// Bit 7,  highlight_en
// Bit 6   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before
// matrix Bit 5:4  probe_sel, 00: select matrix 0, 01: select matrix 1,  otherwise select nothing
// Bit 3:2, matrix coef idx selection, 00: select mat0, 01: select mat1, otherwise slect nothing
// Bit 1   mat1 conversion matrix enable
// Bit 0   mat0 conversion matrix enable
#define VDIN_MATRIX_CTRL ((0x1210 << 2) + 0xff900000)
// Bit 28:16 coef00
// Bit 12:0  coef01
#define VDIN_MATRIX_COEF00_01 ((0x1211 << 2) + 0xff900000)
// Bit 28:16 coef02
// Bit 12:0  coef10
#define VDIN_MATRIX_COEF02_10 ((0x1212 << 2) + 0xff900000)
// Bit 28:16 coef11
// Bit 12:0  coef12
#define VDIN_MATRIX_COEF11_12 ((0x1213 << 2) + 0xff900000)
// Bit 28:16 coef20
// Bit 12:0  coef21
#define VDIN_MATRIX_COEF20_21 ((0x1214 << 2) + 0xff900000)
// BIt 18:16 conv_rs
// Bit 12:0  coef22
#define VDIN_MATRIX_COEF22 ((0x1215 << 2) + 0xff900000)
// Bit 26:16 offset0
// Bit 10:0  offset1
#define VDIN_MATRIX_OFFSET0_1 ((0x1216 << 2) + 0xff900000)
// Bit 10:0  offset2
#define VDIN_MATRIX_OFFSET2 ((0x1217 << 2) + 0xff900000)
// Bit 26:16 pre_offset0
// Bit 10:0  pre_offset1
#define VDIN_MATRIX_PRE_OFFSET0_1 ((0x1218 << 2) + 0xff900000)
// Bit 10:0  pre_offset2
#define VDIN_MATRIX_PRE_OFFSET2 ((0x1219 << 2) + 0xff900000)
// 12:0 lfifo_buf_size
#define VDIN_LFIFO_CTRL ((0x121a << 2) + 0xff900000)
#define VDIN_COM_GCLK_CTRL ((0x121b << 2) + 0xff900000)
// 12:0 VDIN input interface width minus 1, before the window function, after the de decimation
#define VDIN_INTF_WIDTHM1 ((0x121c << 2) + 0xff900000)
// Bit 15          //default== 0, urgent_ctrl_en
// Bit 14          //default== 0, urgent_wr, if true for write buffer
// Bit 13          //default== 0, out_inv_en
// Bit 12          //default == 0, urgent_ini_value
// Bit 11:6        //default == 0, up_th  up threshold
// Bit 5:0         //default == 0, dn_th  dn threshold
#define VDIN_LFIFO_URG_CTRL ((0x121e << 2) + 0xff900000)
// Bit 8, 1: discard data before line fifo, 0: normal mode
// Bit 7:0 Write chroma canvas address
#define VDIN_WR_CTRL2 ((0x121f << 2) + 0xff900000)
// Bit 31:30 hconv_mode, Applicable only to bit[13:12]=0 or 2. 0: Output every even pixels' CbCr;
//                                                            1: Output every odd pixels' CbCr;
//                                                            2: Output an average value per
//                                                            even&odd pair of pixels; 3: Output
//                                                            all CbCr. (This does NOT apply to
//                                                            bit[13:12]=0 -- 4:2:2 mode.)
// Bit 29 no_clk_gate: disable vid_wr_mif clock gating function.
// Bit 28 clear write response counter in the vdin write memory interface
// Bit 27 eol_sel, 1: use eol as the line end indication, 0: use width as line end indication in
// the vdin write memory interface Bit 26 vcp_nr_en. Only used in VDIN0. NOT used in VDIN1. Bit 25
// vcp_wr_en. Only used in VDIN0. NOT used in VDIN1. Bit 24 vcp_in_en. Only used in VDIN0. NOT
// used in VDIN1. Bit 23 vdin frame reset enable, if true, it will provide frame reset during
// go_field(vsync) to the modules after that Bit 22 vdin line fifo soft reset enable, meaning, if
// true line fifo will reset during go_field (vsync) Bit 21 vdin direct write done status clear
// Bit 20 vdin NR write done status clear bit. Bit 18 swap_cbcr. Applicable only to
// bit[13:12]=2. 0: Output CbCr (NV12); 1: Output CrCb (NV21). Bit 17:16 vconv_mode, Applicable
// only to bit[13:12]=2. 0: Output every even lines' CbCr;
//                                                       1: Output every odd lines' CbCr;
//                                                       2: Reserved;
//                                                       3: Output all CbCr.
// Bit 13:12 vdin write format, 0: 4:2:2 to luma canvas, 1: 4:4:4 to luma canvas,
//                             2: Y to luma canvas, CbCr to chroma canvas. For NV12/21, also
//                             define Bit 31:30, 17:16, and bit 18.
// Bit 11 vdin write canvas double buffer enable, means the canvas address will be latched by
// vsync before using Bit 10 1: disable ctrl_reg write pulse which will reset internal counter.
// when bit 11 is 1, this bit should be 1. Bit 9 vdin write request urgent Bit 8 vdin write
// request enable Bit 7:0 Write luma canvas address
#define VDIN_WR_CTRL ((0x1220 << 2) + 0xff900000)
// Bit 29, if true, horizontal reverse
// Bit 28:16 start
// Bit 12:0  end
#define VDIN_WR_H_START_END ((0x1221 << 2) + 0xff900000)
// Bit 29, if true, vertical reverse
// Bit 28:16 start
// Bit 15:13 field mode,  0 frame mode, 4 for field mode botton field, 5 for field mode top field,
// , 6 for blank line mode Bit 12:0  end
#define VDIN_WR_V_START_END ((0x1222 << 2) + 0xff900000)
// Bit 24:20, integer portion
// Bit 19:0, fraction portion
#define VDIN_VSC_PHASE_STEP ((0x1223 << 2) + 0xff900000)
// Bit 23, vsc_en, vertical scaler enable
// Bit 22  if true, repeat last line while scaling, otherwise use the dummy data to extend the
// input picture Bit 21 vsc_phase0_always_en, when scale up, you have to set it to 1 Bit 20:16 ini
// skip_line_num Bit 15:0 vscaler ini_phase
#define VDIN_VSC_INI_CTRL ((0x1224 << 2) + 0xff900000)
// Bit 28:16, vshrink input height minus 1
// Bit 12:0, scaler input height minus 1
#define VDIN_SCIN_HEIGHTM1 ((0x1225 << 2) + 0xff900000)
// Bit 23:16, dummy component 0
// Bit 15:8, dummy component 1
// Bit 7:0, dummy component 2
#define VDIN_DUMMY_DATA ((0x1226 << 2) + 0xff900000)
// Read only
// Bit 29:20 component 0
// Bit 19:10 component 1
// Bit 9:0 component 2
#define VDIN_MATRIX_PROBE_COLOR ((0x1228 << 2) + 0xff900000)
// Bit 23:16 component 0
// Bit 15:8  component 1
// Bit 7:0 component 2
#define VDIN_MATRIX_HL_COLOR ((0x1229 << 2) + 0xff900000)
// 28:16 probe x, postion
// 12:0  probe y, position
#define VDIN_MATRIX_PROBE_POS ((0x122a << 2) + 0xff900000)
#define VDIN_CHROMA_ADDR_PORT ((0x122b << 2) + 0xff900000)
#define VDIN_CHROMA_DATA_PORT ((0x122c << 2) + 0xff900000)
//
#define VDIN_CM_BRI_CON_CTRL ((0x122d << 2) + 0xff900000)
#define VDIN_HDMIRX_CTRL ((0x122e << 2) + 0xff900000)
// Bit 17  clk_cyc_cnt_clr, if true, clear this register
// Bit 16 if true, use vpu clock to count one line, otherwise use actually hsync to count line_cnt
// Bit 15:0   line width using vpu clk
#define VDIN_GO_LINE_CTRL ((0x122f << 2) + 0xff900000)
// Bit 31:24 hist_pix_white_th, larger than this th is counted as white pixel
// Bit 23:16 hist_pix_black_th, less than this th is counted as black pixel
// Bit 11    hist_34bin_only,   34 bin only mode, including white/black
// Bit 10:9  ldim_stts_din_sel, 00: from matrix0 dout,  01: from vsc_dout, 10: from matrix1 dout,
// 11: form matrix1 din Bit 8     ldim_stts_en Bit 6:5   hist_dnlp_low   the real pixels in each
// bins got by VDIN_DNLP_HISTXX should multiple with 2^(dnlp_low+3) Bit 3:2   hist_din_sel    the
// source used for hist statistics.  00: from matrix0 dout,  01: from vsc_dout, 10: from matrix1
// dout, 11: form matrix1 din Bit 1     hist_win_en     1'b0: hist used for full picture; 1'b1:
// hist used for pixels within hist window Bit 0     hist_spl_en     1'b0: disable hist readback;
// 1'b1: enable hist readback
#define VDIN_HIST_CTRL ((0x1230 << 2) + 0xff900000)
// Bit 28:16 hist_hstart  horizontal start value to define hist window
// Bit 12:0  hist_hend    horizontal end value to define hist window
#define VDIN_HIST_H_START_END ((0x1231 << 2) + 0xff900000)
// Bit 28:16 hist_vstart  vertical start value to define hist window
// Bit 12:0  hist_vend    vertical end value to define hist window
#define VDIN_HIST_V_START_END ((0x1232 << 2) + 0xff900000)
// Bit 15:8  hist_max    maximum value
// Bit 7:0   hist_min    minimum value
// read only
#define VDIN_HIST_MAX_MIN ((0x1233 << 2) + 0xff900000)
// Bit 31:0  hist_spl_rd
// counts for the total luma value
// read only
#define VDIN_HIST_SPL_VAL ((0x1234 << 2) + 0xff900000)
// Bit 21:0  hist_spl_pixel_count
// counts for the total calculated pixels
// read only
#define VDIN_HIST_SPL_PIX_CNT ((0x1235 << 2) + 0xff900000)
// Bit 31:0  hist_chroma_sum
// counts for the total chroma value
// read only
#define VDIN_HIST_CHROMA_SUM ((0x1236 << 2) + 0xff900000)
// Bit 31:16 higher hist bin
// Bit 15:0  lower hist bin
// 0-255 are splited to 64 bins evenly, and VDIN_DNLP_HISTXX
// are the statistic number of pixels that within each bin.
// VDIN_DNLP_HIST00[15:0]  counts for the first  bin
// VDIN_DNLP_HIST00[31:16] counts for the second bin
// VDIN_DNLP_HIST01[15:0]  counts for the third  bin
// VDIN_DNLP_HIST01[31:16] counts for the fourth bin
// etc...
// read only
#define VDIN_DNLP_HIST00 ((0x1237 << 2) + 0xff900000)
#define VDIN_DNLP_HIST01 ((0x1238 << 2) + 0xff900000)
#define VDIN_DNLP_HIST02 ((0x1239 << 2) + 0xff900000)
#define VDIN_DNLP_HIST03 ((0x123a << 2) + 0xff900000)
#define VDIN_DNLP_HIST04 ((0x123b << 2) + 0xff900000)
#define VDIN_DNLP_HIST05 ((0x123c << 2) + 0xff900000)
#define VDIN_DNLP_HIST06 ((0x123d << 2) + 0xff900000)
#define VDIN_DNLP_HIST07 ((0x123e << 2) + 0xff900000)
#define VDIN_DNLP_HIST08 ((0x123f << 2) + 0xff900000)
#define VDIN_DNLP_HIST09 ((0x1240 << 2) + 0xff900000)
#define VDIN_DNLP_HIST10 ((0x1241 << 2) + 0xff900000)
#define VDIN_DNLP_HIST11 ((0x1242 << 2) + 0xff900000)
#define VDIN_DNLP_HIST12 ((0x1243 << 2) + 0xff900000)
#define VDIN_DNLP_HIST13 ((0x1244 << 2) + 0xff900000)
#define VDIN_DNLP_HIST14 ((0x1245 << 2) + 0xff900000)
#define VDIN_DNLP_HIST15 ((0x1246 << 2) + 0xff900000)
#define VDIN_DNLP_HIST16 ((0x1247 << 2) + 0xff900000)
#define VDIN_DNLP_HIST17 ((0x1248 << 2) + 0xff900000)
#define VDIN_DNLP_HIST18 ((0x1249 << 2) + 0xff900000)
#define VDIN_DNLP_HIST19 ((0x124a << 2) + 0xff900000)
#define VDIN_DNLP_HIST20 ((0x124b << 2) + 0xff900000)
#define VDIN_DNLP_HIST21 ((0x124c << 2) + 0xff900000)
#define VDIN_DNLP_HIST22 ((0x124d << 2) + 0xff900000)
#define VDIN_DNLP_HIST23 ((0x124e << 2) + 0xff900000)
#define VDIN_DNLP_HIST24 ((0x124f << 2) + 0xff900000)
#define VDIN_DNLP_HIST25 ((0x1250 << 2) + 0xff900000)
#define VDIN_DNLP_HIST26 ((0x1251 << 2) + 0xff900000)
#define VDIN_DNLP_HIST27 ((0x1252 << 2) + 0xff900000)
#define VDIN_DNLP_HIST28 ((0x1253 << 2) + 0xff900000)
#define VDIN_DNLP_HIST29 ((0x1254 << 2) + 0xff900000)
#define VDIN_DNLP_HIST30 ((0x1255 << 2) + 0xff900000)
#define VDIN_DNLP_HIST31 ((0x1256 << 2) + 0xff900000)
// Bit 31, local dimming statistic enable
// Bit 28, eol enable
// Bit 27:25, vertical line overlap number for max finding
// Bit 24:22, horizontal pixel overlap number, 0: 17 pix, 1: 9 pix, 2: 5 pix, 3: 3 pix, 4: 0 pix
// Bit 20, 1,2,1 low pass filter enable before max/hist statistic
// Bit 19:16, region H/V position index, refer to VDIN_LDIM_STTS_HIST_SET_REGION
// Bit 15, 1: region read index auto increase per read to VDIN_LDIM_STTS_HIST_READ_REGION
// Bit 6:0, region read index
//`define VDIN_LDIM_STTS_HIST_REGION_IDX       8'h57
// Bit 28:0, if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h0: read/write hvstart0
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h1: read/write hend01
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h2: read/write vend01
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h3: read/write hend23
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h4: read/write vend23
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h5: read/write hend45
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h6: read/write vend45
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'd7: read/write hend67
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h8: read/write vend67
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h9: read/write hend89
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'ha: read/write vend89
// hvstart0, Bit 28:16 row0 vstart, Bit 12:0 col0 hstart
// hend01, Bit 28:16 col1 hend, Bit 12:0 col0 hend
// vend01, Bit 28:16 row1 vend, Bit 12:0 row0 vend
// hend23, Bit 28:16 col3 hend, Bit 12:0 col2 hend
// vend23, Bit 28:16 row3 vend, Bit 12:0 row2 vend
// hend45, Bit 28:16 col5 hend, Bit 12:0 col4 hend
// vend45, Bit 28:16 row5 vend, Bit 12:0 row4 vend
// hend67, Bit 28:16 col7 hend, Bit 12:0 col6 hend
// vend67, Bit 28:16 row7 vend, Bit 12:0 row6 vend
// hend89, Bit 28:16 col9 hend, Bit 12:0 col8 hend
// vend89, Bit 28:16 row9 vend, Bit 12:0 row8 vend
//`define VDIN_LDIM_STTS_HIST_SET_REGION       8'h58
// REGION STATISTIC DATA READ OUT PORT, bit 29:20 max_comp2, bit 19:10 max_comp1, bit 9:0
// max_comp0 `define VDIN_LDIM_STTS_HIST_READ_REGION      8'h59 Bit 18, reset bit, high active Bit
// 17, if true, widen hs/vs pulse Bit 16  vsync total counter always accumulating enable Bit
// 14:12, select hs/vs of video input channel to measure, 0: no selection, 1: vdi1, 2: vid2, 3:
// vid3, 4:vid4, 5:vdi5, 6:vid6, 7:vdi7, 8: vdi8 Bit 11:4, vsync_span, define how many vsync span
// need to measure Bit 2:0  meas_hs_index, index to select which HS counter/range
#define VDIN_MEAS_CTRL0 ((0x125a << 2) + 0xff900000)
// Read only
// 19:16     meas_ind_total_count_n, every number of sync_span vsyncs, this count add 1
// 15:0      high bit portion of vsync total counter
#define VDIN_MEAS_VS_COUNT_HI ((0x125b << 2) + 0xff900000)
// Read only
// 31:0, low bit portion of vsync total counter
#define VDIN_MEAS_VS_COUNT_LO ((0x125c << 2) + 0xff900000)
// according to the meas_hs_index in register VDIN_MEAS_CTRL0
// meas_hs_index == 0, first hs range
// meas_hs_index == 1, second hs range
// meas_hs_index == 2, third hs range
// meas_hs_index == 3, fourth hs range
// bit 28:16 count_start
// bit 12:0 count_end
#define VDIN_MEAS_HS_RANGE ((0x125d << 2) + 0xff900000)
// Read only
// according to the meas_hs_index in register VDIN_MEAS_CTRL0,
// meas_hs_index == 0, first range hs counter,
// meas_hs_index == 1, second range hs counter
// meas_hs_index == 2, third range hs counter
// meas_hs_index == 3, fourth range hs counter
// 23:0
#define VDIN_MEAS_HS_COUNT ((0x125e << 2) + 0xff900000)
// Bit 8      white_enable
// Bit 7:0    blkbar_white_level
#define VDIN_BLKBAR_CTRL1 ((0x125f << 2) + 0xff900000)
// Bit 31:24 blkbar_black_level    threshold to judge a black point
// Bit 23:21 Reserved
// Bit 20:8  blkbar_hwidth         left and right region width
// Bit 7:5   blkbar_comp_sel       select yin or uin or vin to be the valid input
// Bit 4     blkbar_sw_statistic_en enable software statistic of each block black points number
// Bit 3     blkbar_det_en
// Bit 2:1   blkbar_din_sel
// bit blkbar_det_top_en
#define VDIN_BLKBAR_CTRL0 ((0x1260 << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 blkbar_hstart.        Left region start
// Bit 15:13 Reserved
// Bit 12:0  blkbar_hend.          Right region end
#define VDIN_BLKBAR_H_START_END ((0x1261 << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 blkbar_vstart
// Bit 15:13 Reserved
// Bit 12:0  blkbar_vend
#define VDIN_BLKBAR_V_START_END ((0x1262 << 2) + 0xff900000)
// Bit 31:20 Reserved
// Bit 19:0  blkbar_cnt_threshold. threshold to judge whether a block is totally black
#define VDIN_BLKBAR_CNT_THRESHOLD ((0x1263 << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 blkbar_row_th1.       //threshold of the top blackbar
// Bit 15:13 Reserved
// bit 12:0  blkbar_row_th2        //threshold of the bottom blackbar
#define VDIN_BLKBAR_ROW_TH1_TH2 ((0x1264 << 2) + 0xff900000)
// Readonly
// Bit 31:29 Reserved
// Bit 28:16 blkbar_ind_left_start. horizontal start of the left region in the current searching
// Bit 15:13 Reserved
// Bit 12:0  blkbar_ind_left_end.   horizontal end of the left region in the current searching
#define VDIN_BLKBAR_IND_LEFT_START_END ((0x1265 << 2) + 0xff900000)
// Readonly
// Bit 31:29 Reserved
// Bit 28:16 blkbar_ind_right_start.horizontal start of the right region in the current searching
// Bit 15:13 Reserved
// Bit 12:0  blkbar_ind_right_end.  horizontal end of the right region in the current searching
#define VDIN_BLKBAR_IND_RIGHT_START_END ((0x1266 << 2) + 0xff900000)
// Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_left1_cnt.  Black pixel counter. left part of the left region
#define VDIN_BLKBAR_IND_LEFT1_CNT ((0x1267 << 2) + 0xff900000)
// Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_left2_cnt.  Black pixel counter. right part of the left region
#define VDIN_BLKBAR_IND_LEFT2_CNT ((0x1268 << 2) + 0xff900000)
// Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_right1_cnt. Black pixel counter. left part of the right region
#define VDIN_BLKBAR_IND_RIGHT1_CNT ((0x1269 << 2) + 0xff900000)
// Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_right2_cnt. Black pixel counter. right part of the right region
#define VDIN_BLKBAR_IND_RIGHT2_CNT ((0x126a << 2) + 0xff900000)
// Readonly
// Bit 31:30 Resersed
// Bit 29    blkbar_ind_black_det_done. LEFT/RIGHT Black detection done
// Bit 28:16 blkbar_top_pos.            Top black bar position
// Bit 15:13 Reserved.
// Bit 12:0  blkbar_bot_pos.            Bottom black bar position
#define VDIN_BLKBAR_STATUS0 ((0x126b << 2) + 0xff900000)
// Readonly
// Bit 31:29 Reserved
// Bit 28:16 blkbar_left_pos.       Left black bar posiont
// Bit 15:13 Reserved
// Bit 12:0  blkbar_right_pos.      Right black bar position
#define VDIN_BLKBAR_STATUS1 ((0x126c << 2) + 0xff900000)
// Bit 28:16 input window H start
// Bit 12:0  input window H end
#define VDIN_WIN_H_START_END ((0x126d << 2) + 0xff900000)
// Bit 28:16 input window H start
// Bit 12:0  input window V start
#define VDIN_WIN_V_START_END ((0x126e << 2) + 0xff900000)
// Bit 23:16 vdi8 asfifo_ctrl
// Bit 15:8 vdi7 asfifo_ctrl
// Bit 7:0 vdi6 asfifo_ctrl
#define VDIN_ASFIFO_CTRL3 ((0x126f << 2) + 0xff900000)
// Bit 3:2 vshrk_clk2_ctrl
// Bit 1:0 vshrk_clk1_ctrl
#define VDIN_COM_GCLK_CTRL2 ((0x1270 << 2) + 0xff900000)
// Bit 27 vshrk_en
// Bit 26:25 vshrk_mode
// Bit 24 vshrk_lpf_mode
// Bit 23:0 vshrk_dummy
#define VDIN_VSHRK_CTRL ((0x1271 << 2) + 0xff900000)
#define VDIN_DNLP_HIST32 ((0x1272 << 2) + 0xff900000)
// Read only
// Bit 7, vdi9 fifo overflow
// Bit 5:0, vdi9_asfifo_cnt
#define VDIN_COM_STATUS3 ((0x1273 << 2) + 0xff900000)
#define VDIN_SYNC_MASK ((0x1274 << 2) + 0xff900000)
// Bit 7:0,  hsync_mask_num
// Bit 15:8, vsync_mask_num
// Bit 16,   hsync_mask_enable
// Bit 17,   vsync_mask_num
// dolby vdin
#define VDIN_DOLBY_DSC_CTRL0 ((0x1275 << 2) + 0xff900000)
#define VDIN_DOLBY_DSC_CTRL1 ((0x1276 << 2) + 0xff900000)
#define VDIN_DOLBY_DSC_CTRL2 ((0x1277 << 2) + 0xff900000)
#define VDIN_DOLBY_DSC_CTRL3 ((0x1278 << 2) + 0xff900000)
#define VDIN_DOLBY_AXI_CTRL0 ((0x1279 << 2) + 0xff900000)
#define VDIN_DOLBY_AXI_CTRL1 ((0x127a << 2) + 0xff900000)
#define VDIN_DOLBY_AXI_CTRL2 ((0x127b << 2) + 0xff900000)
#define VDIN_DOLBY_AXI_CTRL3 ((0x127c << 2) + 0xff900000)
#define VDIN_DOLBY_DSC_STATUS0 ((0x127d << 2) + 0xff900000)
#define VDIN_DOLBY_DSC_STATUS1 ((0x127e << 2) + 0xff900000)
#define VDIN_DOLBY_DSC_STATUS2 ((0x127f << 2) + 0xff900000)
#define VDIN_DOLBY_DSC_STATUS3 ((0x121d << 2) + 0xff900000)
// hdr2 0x80 - -0xc0
#define VDIN_HDR2_CTRL ((0x1280 << 2) + 0xff900000)
#define VDIN_HDR2_CLK_GATE ((0x1281 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXI_COEF00_01 ((0x1282 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXI_COEF02_10 ((0x1283 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXI_COEF11_12 ((0x1284 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXI_COEF20_21 ((0x1285 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXI_COEF22 ((0x1286 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXI_COEF30_31 ((0x1287 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXI_COEF32_40 ((0x1288 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXI_COEF41_42 ((0x1289 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXI_OFFSET0_1 ((0x128a << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXI_OFFSET2 ((0x128b << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXI_PRE_OFFSET0_1 ((0x128c << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXI_PRE_OFFSET2 ((0x128d << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXO_COEF00_01 ((0x128e << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXO_COEF02_10 ((0x128f << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXO_COEF11_12 ((0x1290 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXO_COEF20_21 ((0x1291 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXO_COEF22 ((0x1292 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXO_COEF30_31 ((0x1293 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXO_COEF32_40 ((0x1294 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXO_COEF41_42 ((0x1295 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXO_OFFSET0_1 ((0x1296 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXO_OFFSET2 ((0x1297 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXO_PRE_OFFSET0_1 ((0x1298 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXO_PRE_OFFSET2 ((0x1299 << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXI_CLIP ((0x129a << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXO_CLIP ((0x129b << 2) + 0xff900000)
#define VDIN_HDR2_CGAIN_OFFT ((0x129c << 2) + 0xff900000)
#define VDIN_EOTF_LUT_ADDR_PORT ((0x129e << 2) + 0xff900000)
#define VDIN_EOTF_LUT_DATA_PORT ((0x129f << 2) + 0xff900000)
#define VDIN_OETF_LUT_ADDR_PORT ((0x12a0 << 2) + 0xff900000)
#define VDIN_OETF_LUT_DATA_PORT ((0x12a1 << 2) + 0xff900000)
#define VDIN_CGAIN_LUT_ADDR_PORT ((0x12a2 << 2) + 0xff900000)
#define VDIN_CGAIN_LUT_DATA_PORT ((0x12a3 << 2) + 0xff900000)
#define VDIN_HDR2_CGAIN_COEF0 ((0x12a4 << 2) + 0xff900000)
#define VDIN_HDR2_CGAIN_COEF1 ((0x12a5 << 2) + 0xff900000)
#define VDIN_OGAIN_LUT_ADDR_PORT ((0x12a6 << 2) + 0xff900000)
#define VDIN_OGAIN_LUT_DATA_PORT ((0x12a7 << 2) + 0xff900000)
#define VDIN_HDR2_ADPS_CTRL ((0x12a8 << 2) + 0xff900000)
#define VDIN_HDR2_ADPS_ALPHA0 ((0x12a9 << 2) + 0xff900000)
#define VDIN_HDR2_ADPS_ALPHA1 ((0x12aa << 2) + 0xff900000)
#define VDIN_HDR2_ADPS_BETA0 ((0x12ab << 2) + 0xff900000)
#define VDIN_HDR2_ADPS_BETA1 ((0x12ac << 2) + 0xff900000)
#define VDIN_HDR2_ADPS_BETA2 ((0x12ad << 2) + 0xff900000)
#define VDIN_HDR2_ADPS_COEF0 ((0x12ae << 2) + 0xff900000)
#define VDIN_HDR2_ADPS_COEF1 ((0x12af << 2) + 0xff900000)
#define VDIN_HDR2_GMUT_CTRL ((0x12b0 << 2) + 0xff900000)
#define VDIN_HDR2_GMUT_COEF0 ((0x12b1 << 2) + 0xff900000)
#define VDIN_HDR2_GMUT_COEF1 ((0x12b2 << 2) + 0xff900000)
#define VDIN_HDR2_GMUT_COEF2 ((0x12b3 << 2) + 0xff900000)
#define VDIN_HDR2_GMUT_COEF3 ((0x12b4 << 2) + 0xff900000)
#define VDIN_HDR2_GMUT_COEF4 ((0x12b5 << 2) + 0xff900000)
#define VDIN_HDR2_PIPE_CTRL1 ((0x12b6 << 2) + 0xff900000)
#define VDIN_HDR2_PIPE_CTRL2 ((0x12b7 << 2) + 0xff900000)
#define VDIN_HDR2_PIPE_CTRL3 ((0x12b8 << 2) + 0xff900000)
#define VDIN_HDR2_PROC_WIN1 ((0x12b9 << 2) + 0xff900000)
#define VDIN_HDR2_PROC_WIN2 ((0x12ba << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXI_EN_CTRL ((0x12bb << 2) + 0xff900000)
#define VDIN_HDR2_MATRIXO_EN_CTRL ((0x12bc << 2) + 0xff900000)
#define VDIN_HDR2_HIST_CTRL ((0x12bd << 2) + 0xff900000)
#define VDIN_HDR2_HIST_H_START_END ((0x12be << 2) + 0xff900000)
#define VDIN_HDR2_HIST_V_START_END ((0x12bf << 2) + 0xff900000)
#define VDIN_HDR2_HIST_RD ((0x129d << 2) + 0xff900000)
#define VDIN_WRARB_MODE ((0x12c0 << 2) + 0xff900000)
#define VDIN_WRARB_REQEN_SLV ((0x12c1 << 2) + 0xff900000)
#define VDIN_WRARB_WEIGH0_SLV ((0x12c2 << 2) + 0xff900000)
#define VDIN_WRARB_WEIGH1_SLV ((0x12c3 << 2) + 0xff900000)
#define VDIN_RDWR_ARB_STATUS ((0x12c4 << 2) + 0xff900000)
#define VDIN_ARB_DBG_CTRL ((0x12c5 << 2) + 0xff900000)
#define VDIN_ARB_DBG_STAT ((0x12c6 << 2) + 0xff900000)
#define VDIN_DBG_AXI_CMD_CNT ((0x12c7 << 2) + 0xff900000)
#define VDIN_DBG_AXI_DAT_CNT ((0x12c8 << 2) + 0xff900000)
#define VDIN_CRC_CTRL ((0x12c9 << 2) + 0xff900000)
#define VDIN_RO_CRC ((0x12ca << 2) + 0xff900000)
#define VDIN_LINE_INT ((0x12cb << 2) + 0xff900000)
#define VDIN_WR_URGENT_CTRL ((0x1257 << 2) + 0xff900000)
#define VDIN_RO_WRMIF_STATUS ((0x1258 << 2) + 0xff900000)
#define VDIN_WR_BADDR_LUMA ((0x12cc << 2) + 0xff900000)
#define VDIN_WR_BADDR_CHROMA ((0x12cd << 2) + 0xff900000)
#define VDIN_WR_STRIDE_LUMA ((0x12ce << 2) + 0xff900000)
#define VDIN_WR_STRIDE_CHROMA ((0x12cf << 2) + 0xff900000)
// for vdin dolby descramble start
#define VDIN_DSC_CTRL ((0x12d0 << 2) + 0xff900000)
// Bit   31:10     reserved
// Bit   9:4       reg_dithout_switch  ,uns, default = 36;//{2'h2,2'h1,2'h0}
// Bit   3,        reg_detunnel_en     ,uns, default = 1;
// Bit   2,        reg_detunnel_u_start,uns, default = 0;
// Bit   1,        reg_vdin_dith_en    ,uns, default = 1;
// Bit   0,        reg_descramble_en   ,uns, default = 1;
#define VDIN_CFMT_CTRL ((0x12d1 << 2) + 0xff900000)
// Bit 31:9  reserved
// Bit 8     reg_chfmt_rpt_pix          uns, default = 0    ; //  if true, horizontal formatter
// use repeating to generete pixel, otherwise use bilinear interpolation Bit 7:4
// reg_chfmt_ini_phase        uns, default = 0    ; //  horizontal formatter initial phase Bit 3
// reg_chfmt_rpt_p0_en        uns, default = 0    ; //  horizontal formatter repeat pixel 0 enable
// Bit 2:1   reg_chfmt_yc_ratio         uns, default = 1    ; //  horizontal Y/C ratio, 00: 1:1,
// 01: 2:1, 10: 4:1 Bit 0     reg_chfmt_en               uns, default = 1    ; //  horizontal
// formatter enable
#define VDIN_CFMT_W ((0x12d2 << 2) + 0xff900000)
// Bit 31:29 reserved
// Bit 28:16 reg_chfmt_w                uns, default = 1920   ;horizontal formatter width
// Bit 15:13 reserved
// Bit 12:0  reg_cvfmt_w                uns, default = 960    ;vertical formatter width
#define VDIN_SCB_CTRL0 ((0x12d3 << 2) + 0xff900000)
// Bit   31:24   reserved
// Bit   28      reg_scb2_enable             uns, default = 0;
// Bit   27      reg_scb2_444c422_gofield_en uns, default = 1;
// Bit   26      reg_scb2_tunnel_en          uns, default = 1;
// Bit   25:20   reg_scb2_tunnel_outswitch   uns, default = 36;//{2'h2,2'h1,2'h0}
// Bit   19:18   reg_scb2_444c422_mode       uns, default = 0; //0:left 1:right 2,3:avg
// Bit   17      reg_scb2_444c422_bypass     uns, default = 0; 1:bypass
// Bit   16      reserved                    //pulse for frm_en
//
// Bit   11      reg_444c422_gofield_en     uns, default = 1;
// Bit   10      reg_tunnel_en              uns, default = 1;
// Bit   9:4     reg_tunnel_outswitch       uns, default = 36;//{2'h2,2'h1,2'h0}
// Bit   3:2     reg_444c422_mode           uns, default = 0; //0:left 1:right 2,3:avg
// Bit   1       reg_444c422_bypass         uns, default = 0; 1:bypass
// Bit   0       reserved                   //pulse for frm_en
#define VDIN_SCB_CTRL1 ((0x12d4 << 2) + 0xff900000)
// Bit 31:29 reserved
// Bit 28:16 reg_444c422_hsize    uns, default = 1920   ;horizontal size
// Bit 15:13 reserved
// Bit 12:0  reg_444c422_vsize    uns, default = 960    ;vertical size
#define VDIN_DSC_HSIZE ((0x12d5 << 2) + 0xff900000)
// Bit 31:29 reserved
// Bit 28:16 reg_detunnel_hsize uns, default = 1920   ;
// Bit 15:13 reserved
// Bit 12:0  reg_dither_hsize   uns, default = 1920   ;
#define VDIN_DSC_DETUNNEL_SEL ((0x12d6 << 2) + 0xff900000)
// Bit 31:18 reserved
// Bit 17:0  reg_detunnel_sel   uns, default = 34658;  //{3'h1,3'h0,3'h3  ,3'h5,3'h4,3'h2}
#define VDIN_DSC_TUNNEL_SEL ((0x12d7 << 2) + 0xff900000)
// Bit 31:18 reserved
// Bit 17:0  reg_tunnel_sel   uns, default = 69868;  //= {3'h2,3'h1  ,3'h0,3'h3  ,3'h5,3'h4};
#define VDIN_SCB_CTRL2 ((0x12da << 2) + 0xff900000)
// Bit 31:29 reserved
// Bit 28:16 reg_scb2_444c422_hsize    uns, default = 1920   ;horizontal size
// Bit 15:13 reserved
// Bit 12:0  reg_scb2_444c422_vsize    uns, default = 960    ;vertical size
#define VDIN_HDR2_SIZE ((0x12d8 << 2) + 0xff900000)
#define VDIN_VSHRK_SIZE_M1 ((0x12d9 << 2) + 0xff900000)
// dither
#define VDIN_DITH_CTRL ((0x12e0 << 2) + 0xff900000)
#define VDIN_DITH_LUT_1 ((0x12e1 << 2) + 0xff900000)
#define VDIN_DITH_LUT_2 ((0x12e2 << 2) + 0xff900000)
#define VDIN_DITH_LUT_3 ((0x12e3 << 2) + 0xff900000)
#define VDIN_DITH_LUT_4 ((0x12e4 << 2) + 0xff900000)
#define VDIN_DITH_LUT_5 ((0x12e5 << 2) + 0xff900000)
#define VDIN_DITH_LUT_6 ((0x12e6 << 2) + 0xff900000)
#define VDIN_DITH_LUT_7 ((0x12e7 << 2) + 0xff900000)
#define VDIN_DITH_LUT_8 ((0x12e8 << 2) + 0xff900000)
#define VDIN_DITH_LUT_9 ((0x12e9 << 2) + 0xff900000)
#define VDIN_DITH_LUT_10 ((0x12ea << 2) + 0xff900000)
#define VDIN_DITH_LUT_11 ((0x12eb << 2) + 0xff900000)
#define VDIN_DITH_LUT_12 ((0x12ec << 2) + 0xff900000)
// for vdin dolby descramble end
#define VDIN_HSK_CTRL ((0x12ef << 2) + 0xff900000)
// Bit   31:23    reserved
// Bit   22:16    reg_hsk_size  ,uns, default = 4;
// Bit   15:13    reserved
// Bit   12:0     reg_frm_hsize ,uns, default = 1920;
#define VDIN_HSK_COEF_0 ((0x12f0 << 2) + 0xff900000)
// Bit  31:0   reg_hsk_coef00  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_1 ((0x12f1 << 2) + 0xff900000)
// Bit  31:0   reg_hsk_coef01  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_2 ((0x12f2 << 2) + 0xff900000)
// Bit  31:0   reg_hsk_coef02  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_3 ((0x12f3 << 2) + 0xff900000)
// Bit  31:0   reg_hsk_coef03  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
//
#define VDIN_HSK_COEF_4 ((0x12f4 << 2) + 0xff900000)
// Bit  31:0   reg_hsk_coef04  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_5 ((0x12f5 << 2) + 0xff900000)
// Bit  31:0   reg_hsk_coef05  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_6 ((0x12f6 << 2) + 0xff900000)
// Bit  31:0   reg_hsk_coef06  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_7 ((0x12f7 << 2) + 0xff900000)
// Bit  31:0   reg_hsk_coef07  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
//
#define VDIN_HSK_COEF_8 ((0x12f8 << 2) + 0xff900000)
// Bit  31:0   reg_hsk_coef08  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_9 ((0x12f9 << 2) + 0xff900000)
// Bit  31:0   reg_hsk_coef09  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_A ((0x12fa << 2) + 0xff900000)
// Bit  31:0   reg_hsk_coef10  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_B ((0x12fb << 2) + 0xff900000)
// Bit  31:0   reg_hsk_coef11  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
//
#define VDIN_HSK_COEF_C ((0x12fc << 2) + 0xff900000)
// Bit  31:0   reg_hsk_coef12  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_D ((0x12fd << 2) + 0xff900000)
// Bit  31:0   reg_hsk_coef13  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_E ((0x12fe << 2) + 0xff900000)
// Bit  31:0   reg_hsk_coef14  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_F ((0x12ff << 2) + 0xff900000)
// Bit  31:0   reg_hsk_coef15  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpu_vdin_regs.h
//

// 8'h72 occupied by histogram 32
// VDIN0        8'h00 - 8'h7f
#define VDIN0_SCALE_COEF_IDX (VDIN_SCALE_COEF_IDX)
#define VDIN0_SCALE_COEF (VDIN_SCALE_COEF)
#define VDIN0_COM_CTRL0 (VDIN_COM_CTRL0)
#define VDIN0_ACTIVE_MAX_PIX_CNT_STATUS (VDIN_ACTIVE_MAX_PIX_CNT_STATUS)
#define VDIN0_LCNT_STATUS (VDIN_LCNT_STATUS)
#define VDIN0_COM_STATUS0 (VDIN_COM_STATUS0)
#define VDIN0_COM_STATUS1 (VDIN_COM_STATUS1)
#define VDIN0_LCNT_SHADOW_STATUS (VDIN_LCNT_SHADOW_STATUS)
#define VDIN0_ASFIFO_CTRL0 (VDIN_ASFIFO_CTRL0)
#define VDIN0_ASFIFO_CTRL1 (VDIN_ASFIFO_CTRL1)
#define VDIN0_WIDTHM1I_WIDTHM1O (VDIN_WIDTHM1I_WIDTHM1O)
#define VDIN0_SC_MISC_CTRL (VDIN_SC_MISC_CTRL)
#define VDIN0_HSC_PHASE_STEP (VDIN_HSC_PHASE_STEP)
#define VDIN0_HSC_INI_CTRL (VDIN_HSC_INI_CTRL)
#define VDIN0_COM_STATUS2 (VDIN_COM_STATUS2)
#define VDIN0_COM_STATUS3 (VDIN_COM_STATUS3)
#define VDIN0_ASFIFO_CTRL2 (VDIN_ASFIFO_CTRL2)
#define VDIN0_MATRIX_CTRL (VDIN_MATRIX_CTRL)
#define VDIN0_MATRIX_COEF00_01 (VDIN_MATRIX_COEF00_01)
#define VDIN0_MATRIX_COEF02_10 (VDIN_MATRIX_COEF02_10)
#define VDIN0_MATRIX_COEF11_12 (VDIN_MATRIX_COEF11_12)
#define VDIN0_MATRIX_COEF20_21 (VDIN_MATRIX_COEF20_21)
#define VDIN0_MATRIX_COEF22 (VDIN_MATRIX_COEF22)
#define VDIN0_MATRIX_OFFSET0_1 (VDIN_MATRIX_OFFSET0_1)
#define VDIN0_MATRIX_OFFSET2 (VDIN_MATRIX_OFFSET2)
#define VDIN0_MATRIX_PRE_OFFSET0_1 (VDIN_MATRIX_PRE_OFFSET0_1)
#define VDIN0_MATRIX_PRE_OFFSET2 (VDIN_MATRIX_PRE_OFFSET2)
#define VDIN0_LFIFO_CTRL (VDIN_LFIFO_CTRL)
#define VDIN0_COM_GCLK_CTRL (VDIN_COM_GCLK_CTRL)
#define VDIN0_INTF_WIDTHM1 (VDIN_INTF_WIDTHM1)
#define VDIN0_WR_CTRL2 (VDIN_WR_CTRL2)
#define VDIN0_WR_CTRL (VDIN_WR_CTRL)
#define VDIN0_WR_H_START_END (VDIN_WR_H_START_END)
#define VDIN0_WR_V_START_END (VDIN_WR_V_START_END)
#define VDIN0_VSC_PHASE_STEP (VDIN_VSC_PHASE_STEP)
#define VDIN0_VSC_INI_CTRL (VDIN_VSC_INI_CTRL)
#define VDIN0_SCIN_HEIGHTM1 (VDIN_SCIN_HEIGHTM1)
#define VDIN0_DUMMY_DATA (VDIN_DUMMY_DATA)
#define VDIN0_MATRIX_PROBE_COLOR (VDIN_MATRIX_PROBE_COLOR)
#define VDIN0_MATRIX_HL_COLOR (VDIN_MATRIX_HL_COLOR)
#define VDIN0_MATRIX_PROBE_POS (VDIN_MATRIX_PROBE_POS)
#define VDIN0_CHROMA_ADDR_PORT (VDIN_CHROMA_ADDR_PORT)
#define VDIN0_CHROMA_DATA_PORT (VDIN_CHROMA_DATA_PORT)
#define VDIN0_CM_BRI_CON_CTRL (VDIN_CM_BRI_CON_CTRL)
#define VDIN0_HDMIRX_CTRL (VDIN_HDMIRX_CTRL)
#define VDIN0_GO_LINE_CTRL (VDIN_GO_LINE_CTRL)
#define VDIN0_HIST_CTRL (VDIN_HIST_CTRL)
#define VDIN0_HIST_H_START_END (VDIN_HIST_H_START_END)
#define VDIN0_HIST_V_START_END (VDIN_HIST_V_START_END)
#define VDIN0_HIST_MAX_MIN (VDIN_HIST_MAX_MIN)
#define VDIN0_HIST_SPL_VAL (VDIN_HIST_SPL_VAL)
#define VDIN0_HIST_SPL_PIX_CNT (VDIN_HIST_SPL_PIX_CNT)
#define VDIN0_HIST_CHROMA_SUM (VDIN_HIST_CHROMA_SUM)
#define VDIN0_DNLP_HIST00 (VDIN_DNLP_HIST00)
#define VDIN0_DNLP_HIST01 (VDIN_DNLP_HIST01)
#define VDIN0_DNLP_HIST02 (VDIN_DNLP_HIST02)
#define VDIN0_DNLP_HIST03 (VDIN_DNLP_HIST03)
#define VDIN0_DNLP_HIST04 (VDIN_DNLP_HIST04)
#define VDIN0_DNLP_HIST05 (VDIN_DNLP_HIST05)
#define VDIN0_DNLP_HIST06 (VDIN_DNLP_HIST06)
#define VDIN0_DNLP_HIST07 (VDIN_DNLP_HIST07)
#define VDIN0_DNLP_HIST08 (VDIN_DNLP_HIST08)
#define VDIN0_DNLP_HIST09 (VDIN_DNLP_HIST09)
#define VDIN0_DNLP_HIST10 (VDIN_DNLP_HIST10)
#define VDIN0_DNLP_HIST11 (VDIN_DNLP_HIST11)
#define VDIN0_DNLP_HIST12 (VDIN_DNLP_HIST12)
#define VDIN0_DNLP_HIST13 (VDIN_DNLP_HIST13)
#define VDIN0_DNLP_HIST14 (VDIN_DNLP_HIST14)
#define VDIN0_DNLP_HIST15 (VDIN_DNLP_HIST15)
#define VDIN0_DNLP_HIST16 (VDIN_DNLP_HIST16)
#define VDIN0_DNLP_HIST17 (VDIN_DNLP_HIST17)
#define VDIN0_DNLP_HIST18 (VDIN_DNLP_HIST18)
#define VDIN0_DNLP_HIST19 (VDIN_DNLP_HIST19)
#define VDIN0_DNLP_HIST20 (VDIN_DNLP_HIST20)
#define VDIN0_DNLP_HIST21 (VDIN_DNLP_HIST21)
#define VDIN0_DNLP_HIST22 (VDIN_DNLP_HIST22)
#define VDIN0_DNLP_HIST23 (VDIN_DNLP_HIST23)
#define VDIN0_DNLP_HIST24 (VDIN_DNLP_HIST24)
#define VDIN0_DNLP_HIST25 (VDIN_DNLP_HIST25)
#define VDIN0_DNLP_HIST26 (VDIN_DNLP_HIST26)
#define VDIN0_DNLP_HIST27 (VDIN_DNLP_HIST27)
#define VDIN0_DNLP_HIST28 (VDIN_DNLP_HIST28)
#define VDIN0_DNLP_HIST29 (VDIN_DNLP_HIST29)
#define VDIN0_DNLP_HIST30 (VDIN_DNLP_HIST30)
#define VDIN0_DNLP_HIST31 (VDIN_DNLP_HIST31)
#define VDIN0_DNLP_HIST32 (VDIN_DNLP_HIST32)
#define VDIN0_MEAS_CTRL0 (VDIN_MEAS_CTRL0)
#define VDIN0_MEAS_VS_COUNT_HI (VDIN_MEAS_VS_COUNT_HI)
#define VDIN0_MEAS_VS_COUNT_LO (VDIN_MEAS_VS_COUNT_LO)
#define VDIN0_MEAS_HS_RANGE (VDIN_MEAS_HS_RANGE)
#define VDIN0_MEAS_HS_COUNT (VDIN_MEAS_HS_COUNT)
#define VDIN0_BLKBAR_CTRL1 (VDIN_BLKBAR_CTRL1)
#define VDIN0_BLKBAR_CTRL0 (VDIN_BLKBAR_CTRL0)
#define VDIN0_BLKBAR_H_START_END (VDIN_BLKBAR_H_START_END)
#define VDIN0_BLKBAR_V_START_END (VDIN_BLKBAR_V_START_END)
#define VDIN0_BLKBAR_CNT_THRESHOLD (VDIN_BLKBAR_CNT_THRESHOLD)
#define VDIN0_BLKBAR_ROW_TH1_TH2 (VDIN_BLKBAR_ROW_TH1_TH2)
#define VDIN0_BLKBAR_IND_LEFT_START_END (VDIN_BLKBAR_IND_LEFT_START_END)
#define VDIN0_BLKBAR_IND_RIGHT_START_END (VDIN_BLKBAR_IND_RIGHT_START_END)
#define VDIN0_BLKBAR_IND_LEFT1_CNT (VDIN_BLKBAR_IND_LEFT1_CNT)
#define VDIN0_BLKBAR_IND_LEFT2_CNT (VDIN_BLKBAR_IND_LEFT2_CNT)
#define VDIN0_BLKBAR_IND_RIGHT1_CNT (VDIN_BLKBAR_IND_RIGHT1_CNT)
#define VDIN0_BLKBAR_IND_RIGHT2_CNT (VDIN_BLKBAR_IND_RIGHT2_CNT)
#define VDIN0_BLKBAR_STATUS0 (VDIN_BLKBAR_STATUS0)
#define VDIN0_BLKBAR_STATUS1 (VDIN_BLKBAR_STATUS1)
#define VDIN0_WIN_H_START_END (VDIN_WIN_H_START_END)
#define VDIN0_WIN_V_START_END (VDIN_WIN_V_START_END)
#define VDIN0_ASFIFO_CTRL3 (VDIN_ASFIFO_CTRL3)
#define VDIN0_LFIFO_URG_CTRL (VDIN_LFIFO_URG_CTRL)
#define VDIN0_COM_GCLK_CTRL2 (VDIN_COM_GCLK_CTRL2)
#define VDIN0_VSHRK_CTRL (VDIN_VSHRK_CTRL)
#define VDIN0_SYNC_MASK (VDIN_SYNC_MASK)
#define VDIN0_DOLBY_DSC_CTRL0 (VDIN_DOLBY_DSC_CTRL0)
#define VDIN0_DOLBY_DSC_CTRL1 (VDIN_DOLBY_DSC_CTRL1)
#define VDIN0_DOLBY_DSC_CTRL2 (VDIN_DOLBY_DSC_CTRL2)
#define VDIN0_DOLBY_DSC_CTRL3 (VDIN_DOLBY_DSC_CTRL3)
#define VDIN0_DOLBY_AXI_CTRL0 (VDIN_DOLBY_AXI_CTRL0)
#define VDIN0_DOLBY_AXI_CTRL1 (VDIN_DOLBY_AXI_CTRL1)
#define VDIN0_DOLBY_AXI_CTRL2 (VDIN_DOLBY_AXI_CTRL2)
#define VDIN0_DOLBY_AXI_CTRL3 (VDIN_DOLBY_AXI_CTRL3)
#define VDIN0_DOLBY_DSC_STATUS0 (VDIN_DOLBY_DSC_STATUS0)
#define VDIN0_DOLBY_DSC_STATUS1 (VDIN_DOLBY_DSC_STATUS1)
#define VDIN0_DOLBY_DSC_STATUS2 (VDIN_DOLBY_DSC_STATUS2)
#define VDIN0_DOLBY_DSC_STATUS3 (VDIN_DOLBY_DSC_STATUS3)
#define VDIN0_HDR2_CTRL VDIN_HDR2_CTRL
#define VDIN0_HDR2_CLK_GATE VDIN_HDR2_CLK_GATE
#define VDIN0_HDR2_MATRIXI_COEF00_01 VDIN_HDR2_MATRIXI_COEF00_01
#define VDIN0_HDR2_MATRIXI_COEF02_10 VDIN_HDR2_MATRIXI_COEF02_10
#define VDIN0_HDR2_MATRIXI_COEF11_12 VDIN_HDR2_MATRIXI_COEF11_12
#define VDIN0_HDR2_MATRIXI_COEF20_21 VDIN_HDR2_MATRIXI_COEF20_21
#define VDIN0_HDR2_MATRIXI_COEF22 VDIN_HDR2_MATRIXI_COEF22
#define VDIN0_HDR2_MATRIXI_COEF30_31 VDIN_HDR2_MATRIXI_COEF30_31
#define VDIN0_HDR2_MATRIXI_COEF32_40 VDIN_HDR2_MATRIXI_COEF32_40
#define VDIN0_HDR2_MATRIXI_COEF41_42 VDIN_HDR2_MATRIXI_COEF41_42
#define VDIN0_HDR2_MATRIXI_OFFSET0_1 VDIN_HDR2_MATRIXI_OFFSET0_1
#define VDIN0_HDR2_MATRIXI_OFFSET2 VDIN_HDR2_MATRIXI_OFFSET2
#define VDIN0_HDR2_MATRIXI_PRE_OFFSET0_1 VDIN_HDR2_MATRIXI_PRE_OFFSET0_1
#define VDIN0_HDR2_MATRIXI_PRE_OFFSET2 VDIN_HDR2_MATRIXI_PRE_OFFSET2
#define VDIN0_HDR2_MATRIXO_COEF00_01 VDIN_HDR2_MATRIXO_COEF00_01
#define VDIN0_HDR2_MATRIXO_COEF02_10 VDIN_HDR2_MATRIXO_COEF02_10
#define VDIN0_HDR2_MATRIXO_COEF11_12 VDIN_HDR2_MATRIXO_COEF11_12
#define VDIN0_HDR2_MATRIXO_COEF20_21 VDIN_HDR2_MATRIXO_COEF20_21
#define VDIN0_HDR2_MATRIXO_COEF22 VDIN_HDR2_MATRIXO_COEF22
#define VDIN0_HDR2_MATRIXO_COEF30_31 VDIN_HDR2_MATRIXO_COEF30_31
#define VDIN0_HDR2_MATRIXO_COEF32_40 VDIN_HDR2_MATRIXO_COEF32_40
#define VDIN0_HDR2_MATRIXO_COEF41_42 VDIN_HDR2_MATRIXO_COEF41_42
#define VDIN0_HDR2_MATRIXO_OFFSET0_1 VDIN_HDR2_MATRIXO_OFFSET0_1
#define VDIN0_HDR2_MATRIXO_OFFSET2 VDIN_HDR2_MATRIXO_OFFSET2
#define VDIN0_HDR2_MATRIXO_PRE_OFFSET0_1 VDIN_HDR2_MATRIXO_PRE_OFFSET0_1
#define VDIN0_HDR2_MATRIXO_PRE_OFFSET2 VDIN_HDR2_MATRIXO_PRE_OFFSET2
#define VDIN0_HDR2_MATRIXI_CLIP VDIN_HDR2_MATRIXI_CLIP
#define VDIN0_HDR2_MATRIXO_CLIP VDIN_HDR2_MATRIXO_CLIP
#define VDIN0_HDR2_CGAIN_OFFT VDIN_HDR2_CGAIN_OFFT
#define VDIN0_EOTF_LUT_ADDR_PORT VDIN_EOTF_LUT_ADDR_PORT
#define VDIN0_EOTF_LUT_DATA_PORT VDIN_EOTF_LUT_DATA_PORT
#define VDIN0_OETF_LUT_ADDR_PORT VDIN_OETF_LUT_ADDR_PORT
#define VDIN0_OETF_LUT_DATA_PORT VDIN_OETF_LUT_DATA_PORT
#define VDIN0_OGAIN_LUT_ADDR_PORT VDIN_OGAIN_LUT_ADDR_PORT
#define VDIN0_OGAIN_LUT_DATA_PORT VDIN_OGAIN_LUT_DATA_PORT
#define VDIN0_CGAIN_LUT_ADDR_PORT VDIN_CGAIN_LUT_ADDR_PORT
#define VDIN0_CGAIN_LUT_DATA_PORT VDIN_CGAIN_LUT_DATA_PORT
#define VDIN0_HDR2_CGAIN_COEF0 VDIN_HDR2_CGAIN_COEF0
#define VDIN0_HDR2_CGAIN_COEF1 VDIN_HDR2_CGAIN_COEF1
#define VDIN0_HDR2_ADPS_CTRL VDIN_HDR2_ADPS_CTRL
#define VDIN0_HDR2_ADPS_ALPHA0 VDIN_HDR2_ADPS_ALPHA0
#define VDIN0_HDR2_ADPS_ALPHA1 VDIN_HDR2_ADPS_ALPHA1
#define VDIN0_HDR2_ADPS_BETA0 VDIN_HDR2_ADPS_BETA0
#define VDIN0_HDR2_ADPS_BETA1 VDIN_HDR2_ADPS_BETA1
#define VDIN0_HDR2_ADPS_BETA2 VDIN_HDR2_ADPS_BETA2
#define VDIN0_HDR2_ADPS_COEF0 VDIN_HDR2_ADPS_COEF0
#define VDIN0_HDR2_ADPS_COEF1 VDIN_HDR2_ADPS_COEF1
#define VDIN0_HDR2_GMUT_CTRL VDIN_HDR2_GMUT_CTRL
#define VDIN0_HDR2_GMUT_COEF0 VDIN_HDR2_GMUT_COEF0
#define VDIN0_HDR2_GMUT_COEF1 VDIN_HDR2_GMUT_COEF1
#define VDIN0_HDR2_GMUT_COEF2 VDIN_HDR2_GMUT_COEF2
#define VDIN0_HDR2_GMUT_COEF3 VDIN_HDR2_GMUT_COEF3
#define VDIN0_HDR2_GMUT_COEF4 VDIN_HDR2_GMUT_COEF4
#define VDIN0_HDR2_PIPE_CTRL1 VDIN_HDR2_PIPE_CTRL1
#define VDIN0_HDR2_PIPE_CTRL2 VDIN_HDR2_PIPE_CTRL2
#define VDIN0_HDR2_PIPE_CTRL3 VDIN_HDR2_PIPE_CTRL3
#define VDIN0_HDR2_PROC_WIN1 VDIN_HDR2_PROC_WIN1
#define VDIN0_HDR2_PROC_WIN2 VDIN_HDR2_PROC_WIN2
#define VDIN0_HDR2_MATRIXI_EN_CTRL VDIN_HDR2_MATRIXI_EN_CTRL
#define VDIN0_HDR2_MATRIXO_EN_CTRL VDIN_HDR2_MATRIXO_EN_CTRL
#define VDIN0_HDR2_HIST_CTRL VDIN_HDR2_HIST_CTRL
#define VDIN0_HDR2_HIST_H_START_END VDIN_HDR2_HIST_H_START_END
#define VDIN0_HDR2_HIST_V_START_END VDIN_HDR2_HIST_V_START_END
#define VDIN0_HDR2_HIST_RD VDIN_HDR2_HIST_RD

#define VDIN0_CRC_CTRL (VDIN_CRC_CTRL)
#define VDIN0_RO_CRC (VDIN_RO_CRC)
#define VDIN0_LINE_INT (VDIN_LINE_INT)
#define VDIN0_WR_URGENT_CTRL (VDIN_WR_URGENT_CTRL)
#define VDIN0_RO_WRMIF_STATUS (VDIN_RO_WRMIF_STATUS)

#define VDIN0_WR_BADDR_LUMA (VDIN_WR_BADDR_LUMA)
#define VDIN0_WR_BADDR_CHROMA (VDIN_WR_BADDR_CHROMA)
#define VDIN0_WR_STRIDE_LUMA (VDIN_WR_STRIDE_LUMA)
#define VDIN0_WR_STRIDE_CHROMA (VDIN_WR_STRIDE_CHROMA)

#define VDIN0_DSC_CTRL VDIN_DSC_CTRL
#define VDIN0_CFMT_CTRL VDIN_CFMT_CTRL
#define VDIN0_CFMT_W VDIN_CFMT_W
#define VDIN0_SCB_CTRL0 VDIN_SCB_CTRL0
#define VDIN0_SCB_CTRL1 VDIN_SCB_CTRL1
#define VDIN0_SCB_CTRL2 VDIN_SCB_CTRL2
#define VDIN0_DSC_HSIZE VDIN_DSC_HSIZE
#define VDIN0_DSC_DETUNNEL_SEL VDIN_DSC_DETUNNEL_SEL
#define VDIN0_DSC_TUNNEL_SEL VDIN_DSC_TUNNEL_SEL
#define VDIN0_DITH_CTRL VDIN_DITH_CTRL
#define VDIN0_DITH_LUT_1 VDIN_DITH_LUT_1
#define VDIN0_DITH_LUT_2 VDIN_DITH_LUT_2
#define VDIN0_DITH_LUT_3 VDIN_DITH_LUT_3
#define VDIN0_DITH_LUT_4 VDIN_DITH_LUT_4
#define VDIN0_DITH_LUT_5 VDIN_DITH_LUT_5
#define VDIN0_DITH_LUT_6 VDIN_DITH_LUT_6
#define VDIN0_DITH_LUT_7 VDIN_DITH_LUT_7
#define VDIN0_DITH_LUT_8 VDIN_DITH_LUT_8
#define VDIN0_DITH_LUT_9 VDIN_DITH_LUT_9
#define VDIN0_DITH_LUT_10 VDIN_DITH_LUT_10
#define VDIN0_DITH_LUT_11 VDIN_DITH_LUT_11
#define VDIN0_DITH_LUT_12 VDIN_DITH_LUT_12

#define VDIN0_HSK_CTRL VDIN_HSK_CTRL
#define VDIN0_HSK_COEF_0 VDIN_HSK_COEF_0
#define VDIN0_HSK_COEF_1 VDIN_HSK_COEF_1
#define VDIN0_HSK_COEF_2 VDIN_HSK_COEF_2
#define VDIN0_HSK_COEF_3 VDIN_HSK_COEF_3
#define VDIN0_HSK_COEF_4 VDIN_HSK_COEF_4
#define VDIN0_HSK_COEF_5 VDIN_HSK_COEF_5
#define VDIN0_HSK_COEF_6 VDIN_HSK_COEF_6
#define VDIN0_HSK_COEF_7 VDIN_HSK_COEF_7
#define VDIN0_HSK_COEF_8 VDIN_HSK_COEF_8
#define VDIN0_HSK_COEF_9 VDIN_HSK_COEF_9
#define VDIN0_HSK_COEF_A VDIN_HSK_COEF_A
#define VDIN0_HSK_COEF_B VDIN_HSK_COEF_B
#define VDIN0_HSK_COEF_C VDIN_HSK_COEF_C
#define VDIN0_HSK_COEF_D VDIN_HSK_COEF_D
#define VDIN0_HSK_COEF_E VDIN_HSK_COEF_E
#define VDIN0_HSK_COEF_F VDIN_HSK_COEF_F

#define VDIN0_HDR2_SIZE VDIN_HDR2_SIZE
#define VDIN0_VSHRK_SIZE_M1 VDIN_VSHRK_SIZE_M1

// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpu_vdin0_regs.h
//
//===========================================================================
//`define    VDIN1_VCBUS_BASE     8'h13
//===========================================================================
//
// Reading file:  vpu_vdin1_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// VDIN
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VDIN1_VCBUS_BASE = 0x13
// -----------------------------------------------
#define VDIN1_OFFSET (0x100)
// `include "vpu_vdin_regs.h"
// 8'h72 occupied by histogram 32
// VDIN1        8'h00 - 8'h7f
#define VDIN1_SCALE_COEF_IDX ((VDIN1_OFFSET << 2) + VDIN_SCALE_COEF_IDX)
#define VDIN1_SCALE_COEF ((VDIN1_OFFSET << 2) + VDIN_SCALE_COEF)
#define VDIN1_COM_CTRL0 ((VDIN1_OFFSET << 2) + VDIN_COM_CTRL0)
#define VDIN1_ACTIVE_MAX_PIX_CNT_STATUS ((VDIN1_OFFSET << 2) + VDIN_ACTIVE_MAX_PIX_CNT_STATUS)
#define VDIN1_LCNT_STATUS ((VDIN1_OFFSET << 2) + VDIN_LCNT_STATUS)
#define VDIN1_COM_STATUS0 ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS0)
#define VDIN1_COM_STATUS1 ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS1)
#define VDIN1_LCNT_SHADOW_STATUS ((VDIN1_OFFSET << 2) + VDIN_LCNT_SHADOW_STATUS)
#define VDIN1_ASFIFO_CTRL0 ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL0)
#define VDIN1_ASFIFO_CTRL1 ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL1)
#define VDIN1_WIDTHM1I_WIDTHM1O ((VDIN1_OFFSET << 2) + VDIN_WIDTHM1I_WIDTHM1O)
#define VDIN1_SC_MISC_CTRL ((VDIN1_OFFSET << 2) + VDIN_SC_MISC_CTRL)
#define VDIN1_HSC_PHASE_STEP ((VDIN1_OFFSET << 2) + VDIN_HSC_PHASE_STEP)
#define VDIN1_HSC_INI_CTRL ((VDIN1_OFFSET << 2) + VDIN_HSC_INI_CTRL)
#define VDIN1_COM_STATUS2 ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS2)
#define VDIN1_COM_STATUS3 ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS3)
#define VDIN1_ASFIFO_CTRL2 ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL2)
#define VDIN1_MATRIX_CTRL ((VDIN1_OFFSET << 2) + VDIN_MATRIX_CTRL)
#define VDIN1_MATRIX_COEF00_01 ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF00_01)
#define VDIN1_MATRIX_COEF02_10 ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF02_10)
#define VDIN1_MATRIX_COEF11_12 ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF11_12)
#define VDIN1_MATRIX_COEF20_21 ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF20_21)
#define VDIN1_MATRIX_COEF22 ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF22)
#define VDIN1_MATRIX_OFFSET0_1 ((VDIN1_OFFSET << 2) + VDIN_MATRIX_OFFSET0_1)
#define VDIN1_MATRIX_OFFSET2 ((VDIN1_OFFSET << 2) + VDIN_MATRIX_OFFSET2)
#define VDIN1_MATRIX_PRE_OFFSET0_1 ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PRE_OFFSET0_1)
#define VDIN1_MATRIX_PRE_OFFSET2 ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PRE_OFFSET2)
#define VDIN1_LFIFO_CTRL ((VDIN1_OFFSET << 2) + VDIN_LFIFO_CTRL)
#define VDIN1_COM_GCLK_CTRL ((VDIN1_OFFSET << 2) + VDIN_COM_GCLK_CTRL)
#define VDIN1_INTF_WIDTHM1 ((VDIN1_OFFSET << 2) + VDIN_INTF_WIDTHM1)
#define VDIN1_WR_CTRL2 ((VDIN1_OFFSET << 2) + VDIN_WR_CTRL2)
#define VDIN1_WR_CTRL ((VDIN1_OFFSET << 2) + VDIN_WR_CTRL)
#define VDIN1_WR_H_START_END ((VDIN1_OFFSET << 2) + VDIN_WR_H_START_END)
#define VDIN1_WR_V_START_END ((VDIN1_OFFSET << 2) + VDIN_WR_V_START_END)
#define VDIN1_VSC_PHASE_STEP ((VDIN1_OFFSET << 2) + VDIN_VSC_PHASE_STEP)
#define VDIN1_VSC_INI_CTRL ((VDIN1_OFFSET << 2) + VDIN_VSC_INI_CTRL)
#define VDIN1_SCIN_HEIGHTM1 ((VDIN1_OFFSET << 2) + VDIN_SCIN_HEIGHTM1)
#define VDIN1_DUMMY_DATA ((VDIN1_OFFSET << 2) + VDIN_DUMMY_DATA)
#define VDIN1_MATRIX_PROBE_COLOR ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PROBE_COLOR)
#define VDIN1_MATRIX_HL_COLOR ((VDIN1_OFFSET << 2) + VDIN_MATRIX_HL_COLOR)
#define VDIN1_MATRIX_PROBE_POS ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PROBE_POS)
#define VDIN1_CHROMA_ADDR_PORT ((VDIN1_OFFSET << 2) + VDIN_CHROMA_ADDR_PORT)
#define VDIN1_CHROMA_DATA_PORT ((VDIN1_OFFSET << 2) + VDIN_CHROMA_DATA_PORT)
#define VDIN1_CM_BRI_CON_CTRL ((VDIN1_OFFSET << 2) + VDIN_CM_BRI_CON_CTRL)
#define VDIN1_HDMIRX_CTRL ((VDIN1_OFFSET << 2) + VDIN_HDMIRX_CTRL)
#define VDIN1_GO_LINE_CTRL ((VDIN1_OFFSET << 2) + VDIN_GO_LINE_CTRL)
#define VDIN1_HIST_CTRL ((VDIN1_OFFSET << 2) + VDIN_HIST_CTRL)
#define VDIN1_HIST_H_START_END ((VDIN1_OFFSET << 2) + VDIN_HIST_H_START_END)
#define VDIN1_HIST_V_START_END ((VDIN1_OFFSET << 2) + VDIN_HIST_V_START_END)
#define VDIN1_HIST_MAX_MIN ((VDIN1_OFFSET << 2) + VDIN_HIST_MAX_MIN)
#define VDIN1_HIST_SPL_VAL ((VDIN1_OFFSET << 2) + VDIN_HIST_SPL_VAL)
#define VDIN1_HIST_SPL_PIX_CNT ((VDIN1_OFFSET << 2) + VDIN_HIST_SPL_PIX_CNT)
#define VDIN1_HIST_CHROMA_SUM ((VDIN1_OFFSET << 2) + VDIN_HIST_CHROMA_SUM)
#define VDIN1_DNLP_HIST00 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST00)
#define VDIN1_DNLP_HIST01 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST01)
#define VDIN1_DNLP_HIST02 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST02)
#define VDIN1_DNLP_HIST03 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST03)
#define VDIN1_DNLP_HIST04 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST04)
#define VDIN1_DNLP_HIST05 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST05)
#define VDIN1_DNLP_HIST06 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST06)
#define VDIN1_DNLP_HIST07 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST07)
#define VDIN1_DNLP_HIST08 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST08)
#define VDIN1_DNLP_HIST09 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST09)
#define VDIN1_DNLP_HIST10 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST10)
#define VDIN1_DNLP_HIST11 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST11)
#define VDIN1_DNLP_HIST12 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST12)
#define VDIN1_DNLP_HIST13 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST13)
#define VDIN1_DNLP_HIST14 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST14)
#define VDIN1_DNLP_HIST15 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST15)
#define VDIN1_DNLP_HIST16 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST16)
#define VDIN1_DNLP_HIST17 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST17)
#define VDIN1_DNLP_HIST18 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST18)
#define VDIN1_DNLP_HIST19 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST19)
#define VDIN1_DNLP_HIST20 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST20)
#define VDIN1_DNLP_HIST21 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST21)
#define VDIN1_DNLP_HIST22 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST22)
#define VDIN1_DNLP_HIST23 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST23)
#define VDIN1_DNLP_HIST24 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST24)
#define VDIN1_DNLP_HIST25 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST25)
#define VDIN1_DNLP_HIST26 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST26)
#define VDIN1_DNLP_HIST27 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST27)
#define VDIN1_DNLP_HIST28 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST28)
#define VDIN1_DNLP_HIST29 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST29)
#define VDIN1_DNLP_HIST30 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST30)
#define VDIN1_DNLP_HIST31 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST31)
#define VDIN1_DNLP_HIST32 ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST32)
#define VDIN1_MEAS_CTRL0 ((VDIN1_OFFSET << 2) + VDIN_MEAS_CTRL0)
#define VDIN1_MEAS_VS_COUNT_HI ((VDIN1_OFFSET << 2) + VDIN_MEAS_VS_COUNT_HI)
#define VDIN1_MEAS_VS_COUNT_LO ((VDIN1_OFFSET << 2) + VDIN_MEAS_VS_COUNT_LO)
#define VDIN1_MEAS_HS_RANGE ((VDIN1_OFFSET << 2) + VDIN_MEAS_HS_RANGE)
#define VDIN1_MEAS_HS_COUNT ((VDIN1_OFFSET << 2) + VDIN_MEAS_HS_COUNT)
#define VDIN1_BLKBAR_CTRL1 ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_CTRL1)
#define VDIN1_BLKBAR_CTRL0 ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_CTRL0)
#define VDIN1_BLKBAR_H_START_END ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_H_START_END)
#define VDIN1_BLKBAR_V_START_END ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_V_START_END)
#define VDIN1_BLKBAR_CNT_THRESHOLD ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_CNT_THRESHOLD)
#define VDIN1_BLKBAR_ROW_TH1_TH2 ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_ROW_TH1_TH2)
#define VDIN1_BLKBAR_IND_LEFT_START_END ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT_START_END)
#define VDIN1_BLKBAR_IND_RIGHT_START_END ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT_START_END)
#define VDIN1_BLKBAR_IND_LEFT1_CNT ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT1_CNT)
#define VDIN1_BLKBAR_IND_LEFT2_CNT ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT2_CNT)
#define VDIN1_BLKBAR_IND_RIGHT1_CNT ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT1_CNT)
#define VDIN1_BLKBAR_IND_RIGHT2_CNT ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT2_CNT)
#define VDIN1_BLKBAR_STATUS0 ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_STATUS0)
#define VDIN1_BLKBAR_STATUS1 ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_STATUS1)
#define VDIN1_WIN_H_START_END ((VDIN1_OFFSET << 2) + VDIN_WIN_H_START_END)
#define VDIN1_WIN_V_START_END ((VDIN1_OFFSET << 2) + VDIN_WIN_V_START_END)
#define VDIN1_ASFIFO_CTRL3 ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL3)
#define VDIN1_LFIFO_URG_CTRL ((VDIN1_OFFSET << 2) + VDIN_LFIFO_URG_CTRL)
#define VDIN1_COM_GCLK_CTRL2 ((VDIN1_OFFSET << 2) + VDIN_COM_GCLK_CTRL2)
#define VDIN1_VSHRK_CTRL ((VDIN1_OFFSET << 2) + VDIN_VSHRK_CTRL)
#define VDIN1_SYNC_MASK ((VDIN1_OFFSET << 2) + VDIN_SYNC_MASK)
#define VDIN1_DOLBY_DSC_CTRL0 ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL0)
#define VDIN1_DOLBY_DSC_CTRL1 ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL1)
#define VDIN1_DOLBY_DSC_CTRL2 ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL2)
#define VDIN1_DOLBY_DSC_CTRL3 ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL3)
#define VDIN1_DOLBY_AXI_CTRL0 ((VDIN1_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL0)
#define VDIN1_DOLBY_AXI_CTRL1 ((VDIN1_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL1)
#define VDIN1_DOLBY_AXI_CTRL2 ((VDIN1_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL2)
#define VDIN1_DOLBY_AXI_CTRL3 ((VDIN1_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL3)
#define VDIN1_DOLBY_DSC_STATUS0 ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS0)
#define VDIN1_DOLBY_DSC_STATUS1 ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS1)
#define VDIN1_DOLBY_DSC_STATUS2 ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS2)
#define VDIN1_DOLBY_DSC_STATUS3 ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS3)

#define VDIN1_HDR2_CTRL ((VDIN1_OFFSET << 2) + VDIN_HDR2_CTRL)
#define VDIN1_HDR2_CLK_GATE ((VDIN1_OFFSET << 2) + VDIN_HDR2_CLK_GATE)
#define VDIN1_HDR2_MATRIXI_COEF00_01 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_COEF00_01)
#define VDIN1_HDR2_MATRIXI_COEF02_10 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_COEF02_10)
#define VDIN1_HDR2_MATRIXI_COEF11_12 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_COEF11_12)
#define VDIN1_HDR2_MATRIXI_COEF20_21 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_COEF20_21)
#define VDIN1_HDR2_MATRIXI_COEF22 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_COEF22)
#define VDIN1_HDR2_MATRIXI_COEF30_31 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_COEF30_31)
#define VDIN1_HDR2_MATRIXI_COEF32_40 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_COEF32_40)
#define VDIN1_HDR2_MATRIXI_COEF41_42 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_COEF41_42)
#define VDIN1_HDR2_MATRIXI_OFFSET0_1 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_OFFSET0_1)
#define VDIN1_HDR2_MATRIXI_OFFSET2 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_OFFSET2)
#define VDIN1_HDR2_MATRIXI_PRE_OFFSET0_1 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_PRE_OFFSET0_1)
#define VDIN1_HDR2_MATRIXI_PRE_OFFSET2 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_PRE_OFFSET2)
#define VDIN1_HDR2_MATRIXO_COEF00_01 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_COEF00_01)
#define VDIN1_HDR2_MATRIXO_COEF02_10 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_COEF02_10)
#define VDIN1_HDR2_MATRIXO_COEF11_12 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_COEF11_12)
#define VDIN1_HDR2_MATRIXO_COEF20_21 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_COEF20_21)
#define VDIN1_HDR2_MATRIXO_COEF22 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_COEF22)
#define VDIN1_HDR2_MATRIXO_COEF30_31 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_COEF30_31)
#define VDIN1_HDR2_MATRIXO_COEF32_40 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_COEF32_40)
#define VDIN1_HDR2_MATRIXO_COEF41_42 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_COEF41_42)
#define VDIN1_HDR2_MATRIXO_OFFSET0_1 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_OFFSET0_1)
#define VDIN1_HDR2_MATRIXO_OFFSET2 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_OFFSET2)
#define VDIN1_HDR2_MATRIXO_PRE_OFFSET0_1 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_PRE_OFFSET0_1)
#define VDIN1_HDR2_MATRIXO_PRE_OFFSET2 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_PRE_OFFSET2)
#define VDIN1_HDR2_MATRIXI_CLIP ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_CLIP)
#define VDIN1_HDR2_MATRIXO_CLIP ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_CLIP)
#define VDIN1_HDR2_CGAIN_OFFT ((VDIN1_OFFSET << 2) + VDIN_HDR2_CGAIN_OFFT)
#define VDIN1_EOTF_LUT_ADDR_PORT ((VDIN1_OFFSET << 2) + VDIN_EOTF_LUT_ADDR_PORT)
#define VDIN1_EOTF_LUT_DATA_PORT ((VDIN1_OFFSET << 2) + VDIN_EOTF_LUT_DATA_PORT)
#define VDIN1_OETF_LUT_ADDR_PORT ((VDIN1_OFFSET << 2) + VDIN_OETF_LUT_ADDR_PORT)
#define VDIN1_OETF_LUT_DATA_PORT ((VDIN1_OFFSET << 2) + VDIN_OETF_LUT_DATA_PORT)
#define VDIN1_OGAIN_LUT_ADDR_PORT ((VDIN1_OFFSET << 2) + VDIN_OGAIN_LUT_ADDR_PORT)
#define VDIN1_OGAIN_LUT_DATA_PORT ((VDIN1_OFFSET << 2) + VDIN_OGAIN_LUT_DATA_PORT)
#define VDIN1_CGAIN_LUT_ADDR_PORT ((VDIN1_OFFSET << 2) + VDIN_CGAIN_LUT_ADDR_PORT)
#define VDIN1_CGAIN_LUT_DATA_PORT ((VDIN1_OFFSET << 2) + VDIN_CGAIN_LUT_DATA_PORT)
#define VDIN1_HDR2_CGAIN_COEF0 ((VDIN1_OFFSET << 2) + VDIN_HDR2_CGAIN_COEF0)
#define VDIN1_HDR2_CGAIN_COEF1 ((VDIN1_OFFSET << 2) + VDIN_HDR2_CGAIN_COEF1)
#define VDIN1_HDR2_ADPS_CTRL ((VDIN1_OFFSET << 2) + VDIN_HDR2_ADPS_CTRL)
#define VDIN1_HDR2_ADPS_ALPHA0 ((VDIN1_OFFSET << 2) + VDIN_HDR2_ADPS_ALPHA0)
#define VDIN1_HDR2_ADPS_ALPHA1 ((VDIN1_OFFSET << 2) + VDIN_HDR2_ADPS_ALPHA1)
#define VDIN1_HDR2_ADPS_BETA0 ((VDIN1_OFFSET << 2) + VDIN_HDR2_ADPS_BETA0)
#define VDIN1_HDR2_ADPS_BETA1 ((VDIN1_OFFSET << 2) + VDIN_HDR2_ADPS_BETA1)
#define VDIN1_HDR2_ADPS_BETA2 ((VDIN1_OFFSET << 2) + VDIN_HDR2_ADPS_BETA2)
#define VDIN1_HDR2_ADPS_COEF0 ((VDIN1_OFFSET << 2) + VDIN_HDR2_ADPS_COEF0)
#define VDIN1_HDR2_ADPS_COEF1 ((VDIN1_OFFSET << 2) + VDIN_HDR2_ADPS_COEF1)
#define VDIN1_HDR2_GMUT_CTRL ((VDIN1_OFFSET << 2) + VDIN_HDR2_GMUT_CTRL)
#define VDIN1_HDR2_GMUT_COEF0 ((VDIN1_OFFSET << 2) + VDIN_HDR2_GMUT_COEF0)
#define VDIN1_HDR2_GMUT_COEF1 ((VDIN1_OFFSET << 2) + VDIN_HDR2_GMUT_COEF1)
#define VDIN1_HDR2_GMUT_COEF2 ((VDIN1_OFFSET << 2) + VDIN_HDR2_GMUT_COEF2)
#define VDIN1_HDR2_GMUT_COEF3 ((VDIN1_OFFSET << 2) + VDIN_HDR2_GMUT_COEF3)
#define VDIN1_HDR2_GMUT_COEF4 ((VDIN1_OFFSET << 2) + VDIN_HDR2_GMUT_COEF4)
#define VDIN1_HDR2_PIPE_CTRL1 ((VDIN1_OFFSET << 2) + VDIN_HDR2_PIPE_CTRL1)
#define VDIN1_HDR2_PIPE_CTRL2 ((VDIN1_OFFSET << 2) + VDIN_HDR2_PIPE_CTRL2)
#define VDIN1_HDR2_PIPE_CTRL3 ((VDIN1_OFFSET << 2) + VDIN_HDR2_PIPE_CTRL3)
#define VDIN1_HDR2_PROC_WIN1 ((VDIN1_OFFSET << 2) + VDIN_HDR2_PROC_WIN1)
#define VDIN1_HDR2_PROC_WIN2 ((VDIN1_OFFSET << 2) + VDIN_HDR2_PROC_WIN2)
#define VDIN1_HDR2_MATRIXI_EN_CTRL ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_EN_CTRL)
#define VDIN1_HDR2_MATRIXO_EN_CTRL ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_EN_CTRL)
#define VDIN1_HDR2_HIST_CTRL ((VDIN1_OFFSET << 2) + VDIN_HDR2_HIST_CTRL)
#define VDIN1_HDR2_HIST_H_START_END ((VDIN1_OFFSET << 2) + VDIN_HDR2_HIST_H_START_END)
#define VDIN1_HDR2_HIST_V_START_END ((VDIN1_OFFSET << 2) + VDIN_HDR2_HIST_V_START_END)
#define VDIN1_HDR2_HIST_RD ((VDIN1_OFFSET << 2) + VDIN_HDR2_HIST_RD)

#define VDIN1_CRC_CTRL ((VDIN1_OFFSET << 2) + VDIN_CRC_CTRL)
#define VDIN1_RO_CRC ((VDIN1_OFFSET << 2) + VDIN_RO_CRC)
#define VDIN1_LINE_INT ((VDIN1_OFFSET << 2) + VDIN_LINE_INT)
#define VDIN1_WR_URGENT_CTRL ((VDIN1_OFFSET << 2) + VDIN_WR_URGENT_CTRL)
#define VDIN1_RO_WRMIF_STATUS ((VDIN1_OFFSET << 2) + VDIN_RO_WRMIF_STATUS)

#define VDIN1_WR_BADDR_LUMA ((VDIN1_OFFSET << 2) + VDIN_WR_BADDR_LUMA)
#define VDIN1_WR_BADDR_CHROMA ((VDIN1_OFFSET << 2) + VDIN_WR_BADDR_CHROMA)
#define VDIN1_WR_STRIDE_LUMA ((VDIN1_OFFSET << 2) + VDIN_WR_STRIDE_LUMA)
#define VDIN1_WR_STRIDE_CHROMA ((VDIN1_OFFSET << 2) + VDIN_WR_STRIDE_CHROMA)

#define VDIN1_DSC_CTRL ((VDIN1_OFFSET << 2) + VDIN_DSC_CTRL)
#define VDIN1_CFMT_CTRL ((VDIN1_OFFSET << 2) + VDIN_CFMT_CTRL)
#define VDIN1_CFMT_W ((VDIN1_OFFSET << 2) + VDIN_CFMT_W)
#define VDIN1_SCB_CTRL0 ((VDIN1_OFFSET << 2) + VDIN_SCB_CTRL0)
#define VDIN1_SCB_CTRL1 ((VDIN1_OFFSET << 2) + VDIN_SCB_CTRL1)
#define VDIN1_SCB_CTRL2 ((VDIN1_OFFSET << 2) + VDIN_SCB_CTRL2)
#define VDIN1_DSC_HSIZE ((VDIN1_OFFSET << 2) + VDIN_DSC_HSIZE)
#define VDIN1_DSC_DETUNNEL_SEL ((VDIN1_OFFSET << 2) + VDIN_DSC_DETUNNEL_SEL)
#define VDIN1_DSC_TUNNEL_SEL ((VDIN1_OFFSET << 2) + VDIN_DSC_TUNNEL_SEL)
#define VDIN1_DITH_CTRL ((VDIN1_OFFSET << 2) + VDIN_DITH_CTRL)
#define VDIN1_DITH_LUT_1 ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_1)
#define VDIN1_DITH_LUT_2 ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_2)
#define VDIN1_DITH_LUT_3 ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_3)
#define VDIN1_DITH_LUT_4 ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_4)
#define VDIN1_DITH_LUT_5 ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_5)
#define VDIN1_DITH_LUT_6 ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_6)
#define VDIN1_DITH_LUT_7 ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_7)
#define VDIN1_DITH_LUT_8 ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_8)
#define VDIN1_DITH_LUT_9 ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_9)
#define VDIN1_DITH_LUT_10 ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_10)
#define VDIN1_DITH_LUT_11 ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_11)
#define VDIN1_DITH_LUT_12 ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_12)

#define VDIN1_HSK_CTRL ((VDIN1_OFFSET << 2) + VDIN_HSK_CTRL)
#define VDIN1_HSK_COEF_0 ((VDIN1_OFFSET << 2) + VDIN_HSK_COEF_0)
#define VDIN1_HSK_COEF_1 ((VDIN1_OFFSET << 2) + VDIN_HSK_COEF_1)
#define VDIN1_HSK_COEF_2 ((VDIN1_OFFSET << 2) + VDIN_HSK_COEF_2)
#define VDIN1_HSK_COEF_3 ((VDIN1_OFFSET << 2) + VDIN_HSK_COEF_3)
#define VDIN1_HSK_COEF_4 ((VDIN1_OFFSET << 2) + VDIN_HSK_COEF_4)
#define VDIN1_HSK_COEF_5 ((VDIN1_OFFSET << 2) + VDIN_HSK_COEF_5)
#define VDIN1_HSK_COEF_6 ((VDIN1_OFFSET << 2) + VDIN_HSK_COEF_6)
#define VDIN1_HSK_COEF_7 ((VDIN1_OFFSET << 2) + VDIN_HSK_COEF_7)
#define VDIN1_HSK_COEF_8 ((VDIN1_OFFSET << 2) + VDIN_HSK_COEF_8)
#define VDIN1_HSK_COEF_9 ((VDIN1_OFFSET << 2) + VDIN_HSK_COEF_9)
#define VDIN1_HSK_COEF_A ((VDIN1_OFFSET << 2) + VDIN_HSK_COEF_A)
#define VDIN1_HSK_COEF_B ((VDIN1_OFFSET << 2) + VDIN_HSK_COEF_B)
#define VDIN1_HSK_COEF_C ((VDIN1_OFFSET << 2) + VDIN_HSK_COEF_C)
#define VDIN1_HSK_COEF_D ((VDIN1_OFFSET << 2) + VDIN_HSK_COEF_D)
#define VDIN1_HSK_COEF_E ((VDIN1_OFFSET << 2) + VDIN_HSK_COEF_E)
#define VDIN1_HSK_COEF_F ((VDIN1_OFFSET << 2) + VDIN_HSK_COEF_F)

#define VDIN1_HDR2_SIZE ((VDIN1_OFFSET << 2) + VDIN_HDR2_SIZE)
#define VDIN1_VSHRK_SIZE_M1 ((VDIN1_OFFSET << 2) + VDIN_VSHRK_SIZE_M1)

// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpu_vdin1_regs.h
//
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  LCD0_VCBUS_BASE = 0x14
// -----------------------------------------------
//===========================================================================
//
// Reading file:  lcd_regs.h
//
//`define LCD0_VCBUS_BASE           8'h14
//`define LCD1_VCBUS_BASE           8'h15
//`define LCD2_VCBUS_BASE           8'h16
// 0x00 - 0x9f
//
// Reading file:  ldc_cbus.h
//
// synopsys translate_off
// synopsys translate_on
#define LDC_REG_BLOCK_NUM ((0x1400 << 2) + 0xff900000)
// Bit 31:21        reserved
// Bit 20           reg_ldc_en                // unsigned ,    RW, default = 1  1:enable ldc
// ,0:disable ldc Bit 19:14        reg_ldc_seg_col           // unsigned ,    RW, default = 16 the
// number of col segments for calculate backlight Bit 13: 8        reg_ldc_seg_row           //
// unsigned ,    RW, default = 9  the number of row segments for calculate backlight Bit  7: 4
// reg_ldc_blk_xnum          // unsigned ,    RW, default = 7  the number of col blocks for
// calculate intensity, 1<<blk_xnum Bit  3: 0        reg_ldc_blk_ynum          // unsigned , RW,
// default = 6  the number of row blocks for calculate intensity, 1<<blk_ynum
#define LDC_REG_SEG_Y_BOUNDARY_0_1 ((0x1401 << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:13        reg_ldc_seg_y_boundary_0  // unsigned ,    RW, default = 0  the segment row
// boundary Bit 12: 0        reg_ldc_seg_y_boundary_1  // unsigned ,    RW, default = 0  the
// segment row boundary
#define LDC_REG_SEG_Y_BOUNDARY_2_3 ((0x1402 << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:13        reg_ldc_seg_y_boundary_2  // unsigned ,    RW, default = 0  the segment row
// boundary Bit 12: 0        reg_ldc_seg_y_boundary_3  // unsigned ,    RW, default = 0  the
// segment row boundary
#define LDC_REG_SEG_Y_BOUNDARY_4_5 ((0x1403 << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:13        reg_ldc_seg_y_boundary_4  // unsigned ,    RW, default = 0  the segment row
// boundary Bit 12: 0        reg_ldc_seg_y_boundary_5  // unsigned ,    RW, default = 0  the
// segment row boundary
#define LDC_REG_SEG_Y_BOUNDARY_6_7 ((0x1404 << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:13        reg_ldc_seg_y_boundary_6  // unsigned ,    RW, default = 0  the segment row
// boundary Bit 12: 0        reg_ldc_seg_y_boundary_7  // unsigned ,    RW, default = 0  the
// segment row boundary
#define LDC_REG_SEG_Y_BOUNDARY_8_9 ((0x1405 << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:13        reg_ldc_seg_y_boundary_8  // unsigned ,    RW, default = 0  the segment row
// boundary Bit 12: 0        reg_ldc_seg_y_boundary_9  // unsigned ,    RW, default = 0  the
// segment row boundary
#define LDC_REG_SEG_Y_BOUNDARY_10_11 ((0x1406 << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:13        reg_ldc_seg_y_boundary_10 // unsigned ,    RW, default = 0  the segment row
// boundary Bit 12: 0        reg_ldc_seg_y_boundary_11 // unsigned ,    RW, default = 0  the
// segment row boundary
#define LDC_REG_SEG_Y_BOUNDARY_12_13 ((0x1407 << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:13        reg_ldc_seg_y_boundary_12 // unsigned ,    RW, default = 0  the segment row
// boundary Bit 12: 0        reg_ldc_seg_y_boundary_13 // unsigned ,    RW, default = 0  the
// segment row boundary
#define LDC_REG_SEG_Y_BOUNDARY_14_15 ((0x1408 << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:13        reg_ldc_seg_y_boundary_14 // unsigned ,    RW, default = 0  the segment row
// boundary Bit 12: 0        reg_ldc_seg_y_boundary_15 // unsigned ,    RW, default = 0  the
// segment row boundary
#define LDC_REG_SEG_Y_BOUNDARY_16_17 ((0x1409 << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:13        reg_ldc_seg_y_boundary_16 // unsigned ,    RW, default = 0  the segment row
// boundary Bit 12: 0        reg_ldc_seg_y_boundary_17 // unsigned ,    RW, default = 0  the
// segment row boundary
#define LDC_REG_SEG_Y_BOUNDARY_18_19 ((0x140a << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:13        reg_ldc_seg_y_boundary_18 // unsigned ,    RW, default = 0  the segment row
// boundary Bit 12: 0        reg_ldc_seg_y_boundary_19 // unsigned ,    RW, default = 0  the
// segment row boundary
#define LDC_REG_SEG_Y_BOUNDARY_20_21 ((0x140b << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:13        reg_ldc_seg_y_boundary_20 // unsigned ,    RW, default = 0  the segment row
// boundary Bit 12: 0        reg_ldc_seg_y_boundary_21 // unsigned ,    RW, default = 0  the
// segment row boundary
#define LDC_REG_SEG_Y_BOUNDARY_22_23 ((0x140c << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:13        reg_ldc_seg_y_boundary_22 // unsigned ,    RW, default = 0  the segment row
// boundary Bit 12: 0        reg_ldc_seg_y_boundary_23 // unsigned ,    RW, default = 0  the
// segment row boundary
#define LDC_REG_SEG_Y_BOUNDARY_24_25 ((0x140d << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:13        reg_ldc_seg_y_boundary_24 // unsigned ,    RW, default = 0  the segment row
// boundary Bit 12: 0        reg_ldc_seg_y_boundary_25 // unsigned ,    RW, default = 0  the
// segment row boundary
#define LDC_REG_SEG_Y_BOUNDARY_26_27 ((0x140e << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:13        reg_ldc_seg_y_boundary_26 // unsigned ,    RW, default = 0  the segment row
// boundary Bit 12: 0        reg_ldc_seg_y_boundary_27 // unsigned ,    RW, default = 0  the
// segment row boundary
#define LDC_REG_SEG_Y_BOUNDARY_28_29 ((0x140f << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:13        reg_ldc_seg_y_boundary_28 // unsigned ,    RW, default = 0  the segment row
// boundary Bit 12: 0        reg_ldc_seg_y_boundary_29 // unsigned ,    RW, default = 0  the
// segment row boundary
#define LDC_REG_SEG_Y_BOUNDARY_30_31 ((0x1410 << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:13        reg_ldc_seg_y_boundary_30 // unsigned ,    RW, default = 0  the segment row
// boundary Bit 12: 0        reg_ldc_seg_y_boundary_31 // unsigned ,    RW, default = 0  the
// segment row boundary
#define LDC_REG_SEG_X_BOUNDARY_0_1 ((0x1411 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_0  // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_1  // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_2_3 ((0x1412 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_2  // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_3  // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_4_5 ((0x1413 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_4  // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_5  // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_6_7 ((0x1414 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_6  // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_7  // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_8_9 ((0x1415 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_8  // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_9  // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_10_11 ((0x1416 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_10 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_11 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_12_13 ((0x1417 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_12 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_13 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_14_15 ((0x1418 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_14 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_15 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_16_17 ((0x1419 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_16 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_17 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_18_19 ((0x141a << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_18 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_19 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_20_21 ((0x141b << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_20 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_21 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_22_23 ((0x141c << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_22 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_23 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_24_25 ((0x141d << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_24 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_25 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_26_27 ((0x141e << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_26 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_27 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_28_29 ((0x141f << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_28 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_29 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_30_31 ((0x1420 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_30 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_31 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_32_33 ((0x1421 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_32 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_33 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_34_35 ((0x1422 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_34 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_35 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_36_37 ((0x1423 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_36 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_37 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_38_39 ((0x1424 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_38 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_39 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_40_41 ((0x1425 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_40 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_41 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_42_43 ((0x1426 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_42 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_43 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_44_45 ((0x1427 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_44 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_45 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_SEG_X_BOUNDARY_46_47 ((0x1428 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:14        reg_ldc_seg_x_boundary_46 // unsigned ,    RW, default = 0  the segment col
// boundary Bit 13: 0        reg_ldc_seg_x_boundary_47 // unsigned ,    RW, default = 0  the
// segment col boundary
#define LDC_REG_PANEL_SIZE ((0x1429 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_panel_width       // unsigned ,    RW, default = 0  the panel width
// Bit 15: 0        reg_ldc_panel_height      // unsigned ,    RW, default = 0  the panel height
#define LDC_REG_DOWNSAMPLE ((0x142a << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:24        reg_ldc_h_downsample      // unsigned ,    RW, default = 1  horizontal
// downsample scale, 1:/4,  2:/8, 3:/16, 4:/32 Bit 23           reg_ldc_ds_filter_mode    //
// unsigned ,    RW, default = 1  horizontal downsample filter mode, 0: avg 1: max Bit 22:15
// reg_ldc_y_gain            // unsigned ,    RW, default = 8'h40  the gain for input pixel value,
// 0x40 ==1 Bit 14:12        reg_ldc_hist_mode         // unsigned ,    RW, default = 3  the mode
// for hist statistic value to calculate initial backlight, 0:avg 1: max95, 2, max, 3:blend, 4:
// adaptive blend coef and blend target(max95 or max) Bit 11           reg_ldc_hist_blend_mode //
// unsigned ,    RW, default = 1  the blend mode to calculate initial backlight when hist mode=3,
// 0: max + avg, 1:max95 + avg Bit 10: 4        reg_ldc_hist_blend_alpha  // unsigned ,    RW,
// default = 7'h60  the coef for blend when hist mode=3, 128 means "1" Bit  3: 0
// reg_ldc_hist_adap_blend_max_gain // unsigned ,    RW, default = 13  the gain for blend max
// value when hist mode=4
#define LDC_REG_HIST_OVERLAP ((0x142b << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:18        reg_ldc_seg_x_overlap     // unsigned ,    RW, default = 0  the overlap pixel
// num for each segment in col Bit 17: 8        reg_ldc_seg_y_overlap     // unsigned ,    RW,
// default = 0  the overlap pixel num for each segment in row Bit  7: 0        reg_ldc_max95_ratio
// // unsigned ,    RW, default = 10  max95 percentile  //10
#define LDC_REG_BLEND_DIFF_TH ((0x142c << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:12        reg_ldc_hist_adap_blend_diff_th1 // unsigned ,    RW, default = 256  the
// threshold between max95 and average when hist mode=4, default= 4<<6 Bit 11: 0
// reg_ldc_hist_adap_blend_diff_th2 // unsigned ,    RW, default = 640  the threshold between
// max95 and average when hist mode=4, default= 10<<6
#define LDC_REG_CURVE_COEF ((0x142d << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:18        reg_ldc_hist_adap_blend_gain_0 // unsigned ,    RW, default = 8'h70  the blend
// gain0 in curve when hist mode=4 Bit 17:10        reg_ldc_hist_adap_blend_gain_1 // unsigned ,
// RW, default = 8'h40  the blend gain1 in curve when hist mode=4 Bit  9: 4
// reg_ldc_hist_adap_blend_th0 // unsigned ,    RW, default = 2  the blend threshold base in curve
// when hist mode=4 Bit  3: 0        reg_ldc_hist_adap_blend_thn // unsigned ,    RW, default = 4
// the blend threshold increase step in curve when hist mode=4, th0+1<<thn
#define LDC_REG_INIT_BL ((0x142e << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:12        reg_ldc_init_bl_min       // unsigned ,    RW, default = 0  the minimum value
// of init_bl Bit 11: 0        reg_ldc_init_bl_max       // unsigned ,    RW, default = 12'hfff
// the maximum value of init_bl
#define LDC_REG_SF_MODE ((0x142f << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:24        reg_ldc_sf_mode           // unsigned ,    RW, default = 2  the mode for
// backlight spatial filter, 0: no filter, 1: TSF filter , 2: new spatial filter Bit 23:12
// reg_ldc_sf_tsf_3x3        // unsigned ,    RW, default = 12'h600  smoothness control of the
// spatial filter at 3x3 Bit 11: 0        reg_ldc_sf_tsf_5x5        // unsigned ,    RW, default =
// 12'hC00  smoothness control of the spatial filter at 5x5
#define LDC_REG_SF_GAIN ((0x1430 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15: 8        reg_ldc_sf_gain_up        // unsigned ,    RW, default = 8'h20  the gain for
// backlight up Bit  7: 0        reg_ldc_sf_gain_dn        // unsigned ,    RW, default = 8'h00
// the gain for backlight down,256 as "1"
#define LDC_REG_BS_MODE ((0x1431 << 2) + 0xff900000)
// Bit 31:15        reserved
// Bit 14:12        reg_ldc_bs_bl_mode        // unsigned ,    RW, default = 0  the boost mode,
// 0:no boost,1:glb boost,2:local boost,3:max,4:min,5:avg Bit 11: 0        reg_ldc_glb_apl //
// unsigned ,    RW, default = 4095  global apl for one channel
#define LDC_REG_APL ((0x1432 << 2) + 0xff900000)
// Bit 31: 8        reserved
// Bit  7: 0        reg_ldc_bs_glb_apl_gain   // unsigned ,    RW, default = 8'h20  0x10 as "1"
#define LDC_REG_GLB_BOOST ((0x1433 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:16        reg_ldc_bs_dark_scene_bl_th // unsigned ,    RW, default = 12'h200  the global
// threshold for dark scene Bit 15: 8        reg_ldc_bs_gain           // unsigned ,    RW,
// default = 8'h20  the boost gain, default=0x20, 256 as "1" Bit  7: 0 reg_ldc_bs_limit_gain //
// unsigned ,    RW, default = 8'h60  the boost limit gain, 0x40 as "1"
#define LDC_REG_LOCAL_BOOST ((0x1434 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:20        reg_ldc_bs_loc_apl_gain   // unsigned ,    RW, default = 8'h20  the local apl
// gain for dark scene, 0x10 as "1" Bit 19:12        reg_ldc_bs_loc_max_min_gain // unsigned , RW,
// default = 8'h20  the local boost gain,0x10 as "1" Bit 11: 0 reg_ldc_bs_loc_dark_scene_bl_th //
// unsigned ,    RW, default = 12'h600  the local threshold for dark scene
#define LDC_REG_TF ((0x1435 << 2) + 0xff900000)
// Bit 31:24        reg_ldc_tf_low_alpha      // unsigned ,    RW, default = 8'h20  the low alpha
// for temporal filter Bit 23:16        reg_ldc_tf_high_alpha     // unsigned ,    RW, default =
// 8'h20  the high alpha for temporal filter Bit 15: 8        reg_ldc_tf_low_alpha_sc   //
// unsigned ,    RW, default = 8'h40  the low alpha for temporal filter in scene change Bit  7: 0
// reg_ldc_tf_high_alpha_sc  // unsigned ,    RW, default = 8'h40  the high alpha for temporal
// filter in scene change
#define LDC_REG_TF_SC ((0x1436 << 2) + 0xff900000)
// Bit 31: 9        reserved
// Bit  8           reg_ldc_tf_sc_flag        // unsigned ,    RW, default = 0  the flag for scene
// change Bit  7: 4        reg_ldc_cmp_mask_x        // unsigned ,    RW, default = 7  the mask
// width from profile to calculate one block intensity Bit  3: 0        reg_ldc_cmp_mask_y //
// unsigned ,    RW, default = 7  the mask height from profile to calculate one block intensity
#define LDC_REG_PROFILE_MODE ((0x1437 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23: 8        reg_ldc_profile_k         // unsigned ,    RW, default = 16'h240  the profile
// numerator coef Bit  7: 0        reg_ldc_profile_bits      // unsigned ,    RW, default = 8'h18
// the profile denominator coef
#define LDC_REG_BLK_FILTER ((0x1438 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15: 8        reg_ldc_block_filter_a    // unsigned ,    RW, default = 56  the coef for
// block intensity filter Bit  7: 0        reg_ldc_block_filter_b    // unsigned ,    RW, default
// = 37  the coef for block intensity filter
#define LDC_REG_BLK_FILTER_COEF ((0x1439 << 2) + 0xff900000)
// Bit 31:24        reg_ldc_block_filter_c    // unsigned ,    RW, default = 20  the coef for
// block intensity filter Bit 23:16        reg_ldc_block_filter_d    // unsigned ,    RW, default
// = 10  the coef for block intensity filter Bit 15: 8        reg_ldc_block_filter_e    //
// unsigned , RW, default = 5  the coef for block intensity filter Bit  7: 0
// reg_ldc_block_filter_f // unsigned ,    RW, default = 2  the coef for block intensity filter
#define LDC_REG_BL_MEMORY ((0x143a << 2) + 0xff900000)
// Bit 31: 3        reserved
// Bit  2: 0        reg_ldc_bl_buf_diff       // unsigned ,    RW, default = 0  the memory diff
// frame
#define LDC_REG_FACTOR_DIV_0 ((0x143b << 2) + 0xff900000)
// Bit 31:16        reg_ldc_factor_for_div_00 // unsigned ,    RW, default = 33893  the factor for
// divide,33893:2160; 34952:1080 Bit 15: 0        reg_ldc_factor_for_div_01 // unsigned ,    RW,
// default = 33893  the factor for divide,33893:2160; 34952:1080
#define LDC_REG_FACTOR_DIV_1 ((0x143c << 2) + 0xff900000)
// Bit 31:16        reg_ldc_factor_for_div_10 // unsigned ,    RW, default = 32896  the factor for
// divide Bit 15: 0        reg_ldc_factor_for_div_11 // unsigned ,    RW, default = 32896  the
// factor for divide
#define LDC_REG_BITS_DIV ((0x143d << 2) + 0xff900000)
// Bit 31:24        reg_ldc_bits_for_div_00   // unsigned ,    RW, default = 25  the bits for
// divide, 25:2160; 23:1080 Bit 23:16        reg_ldc_bits_for_div_01   // unsigned ,    RW,
// default = 25  the bits for divide, 25:2160; 23:1080 Bit 15: 8        reg_ldc_bits_for_div_10 //
// unsigned ,    RW, default = 25  the bits for divide, 25:2160; 23:1080 Bit  7: 0
// reg_ldc_bits_for_div_11   // unsigned ,    RW, default = 25  the bits for divide, 25:2160;
// 23:1080
#define LDC_REG_GLB_GAIN ((0x143e << 2) + 0xff900000)
// Bit 31:12        reserved
// Bit 11: 0        reg_ldc_glb_gain          // unsigned ,    RW, default = 1024  the global coef
// for compensation gain
#define LDC_REG_DITHER ((0x143f << 2) + 0xff900000)
// Bit 31: 2        reserved
// Bit  1           reg_ldc_dth_en            // unsigned ,    RW, default = 0  the enable dither
// Bit  0           reg_ldc_dth_bw            // unsigned ,    RW, default = 0  0: 2bits, 1: 4bits
#define LDC_REG_MIN_GAIN_LUT_0 ((0x1440 << 2) + 0xff900000)
// Bit 31:24        reg_ldc_min_gain_lut_3    // unsigned ,    RW, default = 8'h40
// Bit 23:16        reg_ldc_min_gain_lut_2    // unsigned ,    RW, default = 8'h40
// Bit 15: 8        reg_ldc_min_gain_lut_1    // unsigned ,    RW, default = 8'h40
// Bit  7: 0        reg_ldc_min_gain_lut_0    // unsigned ,    RW, default = 8'h40
#define LDC_REG_MIN_GAIN_LUT_1 ((0x1441 << 2) + 0xff900000)
// Bit 31:24        reg_ldc_min_gain_lut_7    // unsigned ,    RW, default = 8'h40
// Bit 23:16        reg_ldc_min_gain_lut_6    // unsigned ,    RW, default = 8'h40
// Bit 15: 8        reg_ldc_min_gain_lut_5    // unsigned ,    RW, default = 8'h40
// Bit  7: 0        reg_ldc_min_gain_lut_4    // unsigned ,    RW, default = 8'h40
#define LDC_REG_MIN_GAIN_LUT_2 ((0x1442 << 2) + 0xff900000)
// Bit 31:24        reg_ldc_min_gain_lut_11   // unsigned ,    RW, default = 8'h40
// Bit 23:16        reg_ldc_min_gain_lut_10   // unsigned ,    RW, default = 8'h40
// Bit 15: 8        reg_ldc_min_gain_lut_9    // unsigned ,    RW, default = 8'h40
// Bit  7: 0        reg_ldc_min_gain_lut_8    // unsigned ,    RW, default = 8'h40
#define LDC_REG_MIN_GAIN_LUT_3 ((0x1443 << 2) + 0xff900000)
// Bit 31:24        reg_ldc_min_gain_lut_15   // unsigned ,    RW, default = 8'h40
// Bit 23:16        reg_ldc_min_gain_lut_14   // unsigned ,    RW, default = 8'h40
// Bit 15: 8        reg_ldc_min_gain_lut_13   // unsigned ,    RW, default = 8'h40
// Bit  7: 0        reg_ldc_min_gain_lut_12   // unsigned ,    RW, default = 8'h40
#define LDC_REG_MIN_GAIN_LUT_4 ((0x1444 << 2) + 0xff900000)
// Bit 31:24        reg_ldc_min_gain_lut_19   // unsigned ,    RW, default = 8'h40
// Bit 23:16        reg_ldc_min_gain_lut_18   // unsigned ,    RW, default = 8'h40
// Bit 15: 8        reg_ldc_min_gain_lut_17   // unsigned ,    RW, default = 8'h40
// Bit  7: 0        reg_ldc_min_gain_lut_16   // unsigned ,    RW, default = 8'h40
#define LDC_REG_MIN_GAIN_LUT_5 ((0x1445 << 2) + 0xff900000)
// Bit 31:24        reg_ldc_min_gain_lut_23   // unsigned ,    RW, default = 8'h40
// Bit 23:16        reg_ldc_min_gain_lut_22   // unsigned ,    RW, default = 8'h40
// Bit 15: 8        reg_ldc_min_gain_lut_21   // unsigned ,    RW, default = 8'h40
// Bit  7: 0        reg_ldc_min_gain_lut_20   // unsigned ,    RW, default = 8'h40
#define LDC_REG_MIN_GAIN_LUT_6 ((0x1446 << 2) + 0xff900000)
// Bit 31:24        reg_ldc_min_gain_lut_27   // unsigned ,    RW, default = 8'h40
// Bit 23:16        reg_ldc_min_gain_lut_26   // unsigned ,    RW, default = 8'h40
// Bit 15: 8        reg_ldc_min_gain_lut_25   // unsigned ,    RW, default = 8'h40
// Bit  7: 0        reg_ldc_min_gain_lut_24   // unsigned ,    RW, default = 8'h40
#define LDC_REG_MIN_GAIN_LUT_7 ((0x1447 << 2) + 0xff900000)
// Bit 31:24        reg_ldc_min_gain_lut_31   // unsigned ,    RW, default = 8'h40
// Bit 23:16        reg_ldc_min_gain_lut_30   // unsigned ,    RW, default = 8'h40
// Bit 15: 8        reg_ldc_min_gain_lut_29   // unsigned ,    RW, default = 8'h40
// Bit  7: 0        reg_ldc_min_gain_lut_28   // unsigned ,    RW, default = 8'h40
#define LDC_REG_MIN_GAIN_LUT_8 ((0x1448 << 2) + 0xff900000)
// Bit 31:24        reg_ldc_min_gain_lut_35   // unsigned ,    RW, default = 8'h40
// Bit 23:16        reg_ldc_min_gain_lut_34   // unsigned ,    RW, default = 8'h40
// Bit 15: 8        reg_ldc_min_gain_lut_33   // unsigned ,    RW, default = 8'h40
// Bit  7: 0        reg_ldc_min_gain_lut_32   // unsigned ,    RW, default = 8'h40
#define LDC_REG_MIN_GAIN_LUT_9 ((0x1449 << 2) + 0xff900000)
// Bit 31:24        reg_ldc_min_gain_lut_39   // unsigned ,    RW, default = 8'h40
// Bit 23:16        reg_ldc_min_gain_lut_38   // unsigned ,    RW, default = 8'h40
// Bit 15: 8        reg_ldc_min_gain_lut_37   // unsigned ,    RW, default = 8'h40
// Bit  7: 0        reg_ldc_min_gain_lut_36   // unsigned ,    RW, default = 8'h40
#define LDC_REG_MIN_GAIN_LUT_10 ((0x144a << 2) + 0xff900000)
// Bit 31:24        reg_ldc_min_gain_lut_43   // unsigned ,    RW, default = 8'h40
// Bit 23:16        reg_ldc_min_gain_lut_42   // unsigned ,    RW, default = 8'h40
// Bit 15: 8        reg_ldc_min_gain_lut_41   // unsigned ,    RW, default = 8'h40
// Bit  7: 0        reg_ldc_min_gain_lut_40   // unsigned ,    RW, default = 8'h40
#define LDC_REG_MIN_GAIN_LUT_11 ((0x144b << 2) + 0xff900000)
// Bit 31:24        reg_ldc_min_gain_lut_47   // unsigned ,    RW, default = 8'h40
// Bit 23:16        reg_ldc_min_gain_lut_46   // unsigned ,    RW, default = 8'h40
// Bit 15: 8        reg_ldc_min_gain_lut_45   // unsigned ,    RW, default = 8'h40
// Bit  7: 0        reg_ldc_min_gain_lut_44   // unsigned ,    RW, default = 8'h40
#define LDC_REG_MIN_GAIN_LUT_12 ((0x144c << 2) + 0xff900000)
// Bit 31:24        reg_ldc_min_gain_lut_51   // unsigned ,    RW, default = 8'h40
// Bit 23:16        reg_ldc_min_gain_lut_50   // unsigned ,    RW, default = 8'h40
// Bit 15: 8        reg_ldc_min_gain_lut_49   // unsigned ,    RW, default = 8'h40
// Bit  7: 0        reg_ldc_min_gain_lut_48   // unsigned ,    RW, default = 8'h40
#define LDC_REG_MIN_GAIN_LUT_13 ((0x144d << 2) + 0xff900000)
// Bit 31:24        reg_ldc_min_gain_lut_55   // unsigned ,    RW, default = 8'h40
// Bit 23:16        reg_ldc_min_gain_lut_54   // unsigned ,    RW, default = 8'h40
// Bit 15: 8        reg_ldc_min_gain_lut_53   // unsigned ,    RW, default = 8'h40
// Bit  7: 0        reg_ldc_min_gain_lut_52   // unsigned ,    RW, default = 8'h40
#define LDC_REG_MIN_GAIN_LUT_14 ((0x144e << 2) + 0xff900000)
// Bit 31:24        reg_ldc_min_gain_lut_59   // unsigned ,    RW, default = 8'h40
// Bit 23:16        reg_ldc_min_gain_lut_58   // unsigned ,    RW, default = 8'h40
// Bit 15: 8        reg_ldc_min_gain_lut_57   // unsigned ,    RW, default = 8'h40
// Bit  7: 0        reg_ldc_min_gain_lut_56   // unsigned ,    RW, default = 8'h40
#define LDC_REG_MIN_GAIN_LUT_15 ((0x144f << 2) + 0xff900000)
// Bit 31:24        reg_ldc_min_gain_lut_63   // unsigned ,    RW, default = 8'h40
// Bit 23:16        reg_ldc_min_gain_lut_62   // unsigned ,    RW, default = 8'h40
// Bit 15: 8        reg_ldc_min_gain_lut_61   // unsigned ,    RW, default = 8'h40
// Bit  7: 0        reg_ldc_min_gain_lut_60   // unsigned ,    RW, default = 8'h40
#define LDC_REG_DITHER_LUT_1_0 ((0x1450 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_0         // unsigned ,    RW, default = 0  the reg dither
// lut_0 Bit 15: 0        reg_ldc_dither_lut2_0         // unsigned ,    RW, default = 0  the reg
// dither lut_0
#define LDC_REG_LDC_DITHER_LUT_1_1 ((0x1451 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_1         // unsigned ,    RW, default = 0  the reg dither
// lut_1 Bit 15: 0        reg_ldc_dither_lut2_1         // unsigned ,    RW, default = 0  the reg
// dither lut_1
#define LDC_REG_LDC_DITHER_LUT_1_2 ((0x1452 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_2         // unsigned ,    RW, default = 0  the reg dither
// lut_2 Bit 15: 0        reg_ldc_dither_lut2_2         // unsigned ,    RW, default = 0  the reg
// dither lut_2
#define LDC_REG_LDC_DITHER_LUT_1_3 ((0x1453 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_3         // unsigned ,    RW, default = 0  the reg dither
// lut_3 Bit 15: 0        reg_ldc_dither_lut2_3         // unsigned ,    RW, default = 0  the reg
// dither lut_3
#define LDC_REG_LDC_DITHER_LUT_1_4 ((0x1454 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_4         // unsigned ,    RW, default = 0  the reg dither
// lut_4 Bit 15: 0        reg_ldc_dither_lut2_4         // unsigned ,    RW, default = 0  the reg
// dither lut_4
#define LDC_REG_LDC_DITHER_LUT_1_5 ((0x1455 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_5         // unsigned ,    RW, default = 0  the reg dither
// lut_5 Bit 15: 0        reg_ldc_dither_lut2_5         // unsigned ,    RW, default = 0  the reg
// dither lut_5
#define LDC_REG_LDC_DITHER_LUT_1_6 ((0x1456 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_6         // unsigned ,    RW, default = 0  the reg dither
// lut_6 Bit 15: 0        reg_ldc_dither_lut2_6         // unsigned ,    RW, default = 0  the reg
// dither lut_6
#define LDC_REG_LDC_DITHER_LUT_1_7 ((0x1457 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_7         // unsigned ,    RW, default = 0  the reg dither
// lut_7 Bit 15: 0        reg_ldc_dither_lut2_7         // unsigned ,    RW, default = 0  the reg
// dither lut_7
#define LDC_REG_LDC_DITHER_LUT_1_8 ((0x1458 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_8         // unsigned ,    RW, default = 16'h8241  the reg
// dither lut_8 Bit 15: 0        reg_ldc_dither_lut2_8         // unsigned ,    RW, default =
// 16'h8241  the reg dither lut_8
#define LDC_REG_LDC_DITHER_LUT_1_9 ((0x1459 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_9         // unsigned ,    RW, default = 16'h4128  thereg
// dither lut_9 Bit 15: 0        reg_ldc_dither_lut2_9         // unsigned ,    RW, default =
// 16'h4128  thereg    dither lut_9
#define LDC_REG_LDC_DITHER_LUT_1_10 ((0x145a << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_10        // unsigned ,    RW, default = 16'h2814  thereg
// dither lut_10 Bit 15: 0        reg_ldc_dither_lut2_10        // unsigned ,    RW, default =
// 16'h2814  thereg    dither lut_10
#define LDC_REG_LDC_DITHER_LUT_1_11 ((0x145b << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_11        // unsigned ,    RW, default = 16'h1482  the reg
// dither lut_11 Bit 15: 0        reg_ldc_dither_lut2_11        // unsigned ,    RW, default =
// 16'h1482  the reg dither lut_11
#define LDC_REG_LDC_DITHER_LUT_1_12 ((0x145c << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_12        // unsigned ,    RW, default = 16'h1482  the reg
// dither lut_12 Bit 15: 0        reg_ldc_dither_lut2_12        // unsigned ,    RW, default =
// 16'h1482  the reg dither lut_12
#define LDC_REG_LDC_DITHER_LUT_1_13 ((0x145d << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_13        // unsigned ,    RW, default = 16'h2841  the reg
// dither lut_13 Bit 15: 0        reg_ldc_dither_lut2_13        // unsigned ,    RW, default =
// 16'h2841  the reg dither lut_13
#define LDC_REG_LDC_DITHER_LUT_1_14 ((0x145e << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_14        // unsigned ,    RW, default = 16'h4128  the reg
// dither lut_14 Bit 15: 0        reg_ldc_dither_lut2_14        // unsigned ,    RW, default =
// 16'h4128  the reg dither lut_14
#define LDC_REG_LDC_DITHER_LUT_1_15 ((0x145f << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_15        // unsigned ,    RW, default = 16'h8214  the reg
// dither lut_15 Bit 15: 0        reg_ldc_dither_lut2_15        // unsigned ,    RW, default =
// 16'h8214  the reg dither lut_15
#define LDC_REG_LDC_DITHER_LUT_1_16 ((0x1460 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_16        // unsigned ,    RW, default = 16'h9696  the reg
// dither lut_16 Bit 15: 0        reg_ldc_dither_lut2_16        // unsigned ,    RW, default =
// 16'h9696  the reg dither lut_16
#define LDC_REG_LDC_DITHER_LUT_1_17 ((0x1461 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_17        // unsigned ,    RW, default = 16'h6969  the reg
// dither lut_17 Bit 15: 0        reg_ldc_dither_lut2_17        // unsigned ,    RW, default =
// 16'h6969  the reg dither lut_17
#define LDC_REG_LDC_DITHER_LUT_1_18 ((0x1462 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_18        // unsigned ,    RW, default = 16'h9696  the reg
// dither lut_18 Bit 15: 0        reg_ldc_dither_lut2_18        // unsigned ,    RW, default =
// 16'h9696  the reg dither lut_18
#define LDC_REG_LDC_DITHER_LUT_1_19 ((0x1463 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_19        // unsigned ,    RW, default = 16'h6969  the reg
// dither lut_19 Bit 15: 0        reg_ldc_dither_lut2_19        // unsigned ,    RW, default =
// 16'h6969  the reg dither lut_19
#define LDC_REG_LDC_DITHER_LUT_1_20 ((0x1464 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_20        // unsigned ,    RW, default = 16'h9669  the reg
// dither lut_20 Bit 15: 0        reg_ldc_dither_lut2_20        // unsigned ,    RW, default =
// 16'h9669  the reg dither lut_20
#define LDC_REG_LDC_DITHER_LUT_1_21 ((0x1465 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_21        // unsigned ,    RW, default = 16'hc3c3  the reg
// dither lut_21 Bit 15: 0        reg_ldc_dither_lut2_21        // unsigned ,    RW, default =
// 16'hc3c3  the reg dither lut_21
#define LDC_REG_LDC_DITHER_LUT_1_22 ((0x1466 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_22        // unsigned ,    RW, default = 16'h6996  the reg
// dither lut_22 Bit 15: 0        reg_ldc_dither_lut2_22        // unsigned ,    RW, default =
// 16'h6996  the reg dither lut_22
#define LDC_REG_LDC_DITHER_LUT_1_23 ((0x1467 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_23        // unsigned ,    RW, default = 16'h3c3c  the reg
// dither lut_23 Bit 15: 0        reg_ldc_dither_lut2_23        // unsigned ,    RW, default =
// 16'h3c3c  the reg dither lut_23
#define LDC_REG_LDC_DITHER_LUT_1_24 ((0x1468 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_24        // unsigned ,    RW, default = 16'h7dbe  the reg
// dither lut_24 Bit 15: 0        reg_ldc_dither_lut2_24        // unsigned ,    RW, default =
// 16'h7dbe  the reg dither lut_24
#define LDC_REG_LDC_DITHER_LUT_1_25 ((0x1469 << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_25        // unsigned ,    RW, default = 16'hbed7  the reg
// dither lut_25 Bit 15: 0        reg_ldc_dither_lut2_25        // unsigned ,    RW, default =
// 16'hbed7  the reg dither lut_25
#define LDC_REG_LDC_DITHER_LUT_1_26 ((0x146a << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_26        // unsigned ,    RW, default = 16'hd7eb  the reg
// dither lut_26 Bit 15: 0        reg_ldc_dither_lut2_26        // unsigned ,    RW, default =
// 16'hd7eb  the reg dither lut_26
#define LDC_REG_LDC_DITHER_LUT_1_27 ((0x146b << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_27        // unsigned ,    RW, default = 16'heb7d  the reg
// dither lut_27 Bit 15: 0        reg_ldc_dither_lut2_27        // unsigned ,    RW, default =
// 16'heb7d  the reg dither lut_27
#define LDC_REG_LDC_DITHER_LUT_1_28 ((0x146c << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_28        // unsigned ,    RW, default = 16'heb7d  the reg
// dither lut_28 Bit 15: 0        reg_ldc_dither_lut2_28        // unsigned ,    RW, default =
// 16'heb7d  the reg dither lut_28
#define LDC_REG_LDC_DITHER_LUT_1_29 ((0x146d << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_29        // unsigned ,    RW, default = 16'hd7be  the reg
// dither lut_29 Bit 15: 0        reg_ldc_dither_lut2_29        // unsigned ,    RW, default =
// 16'hd7be  the reg dither lut_29
#define LDC_REG_LDC_DITHER_LUT_1_30 ((0x146e << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_30        // unsigned ,    RW, default = 16'hbed7  the reg
// dither lut_30 Bit 15: 0        reg_ldc_dither_lut2_30        // unsigned ,    RW, default =
// 16'hbed7  the reg dither lut_30
#define LDC_REG_LDC_DITHER_LUT_1_31 ((0x146f << 2) + 0xff900000)
// Bit 31:16        reg_ldc_dither_lut1_31        // unsigned ,    RW, default = 16'h7deb  the reg
// dither lut_31 Bit 15: 0        reg_ldc_dither_lut2_31        // unsigned ,    RW, default =
// 16'h7deb  the reg dither lut_31
#define LDC_SEG_INFO_SEL ((0x1470 << 2) + 0xff900000)
// Bit 31: 1        reserved
// Bit 0            reg_ldc_bl_duty_info_sft_upd  // unsigned ,  RW, default = 0  0:hardware
// update duty info; 1:software update duty info
#define LDC_DDR_ADDR_BASE ((0x1471 << 2) + 0xff900000)
// Bit 31:0         reg_ldc_ddr_addr_base       // unsigned ,    RW, default = 0  ldc ddr address
// base
#define LDC_GAIN_LUT_DATA ((0x1472 << 2) + 0xff900000)
// Bit 31:0         reg_ldc_gain_lut_data       // unsigned ,    RW, default = 0  gain lut address
#define LDC_GAIN_LUT_ADDR ((0x1473 << 2) + 0xff900000)
// Bit 31:0         reg_ldc_gain_lut_addr       // unsigned ,    RW, default = 0  gain lut data
#define LDC_GAIN_LUT_CTRL0 ((0x1474 << 2) + 0xff900000)
// Bit 31:2         reserved
// Bit 1            reg_ldc_gain_lut_smp_data_en_clr // unsigned ,    RW, default = 0   clear
// reg_ldc_gain_lut_smp_data_en signal 1: enable 0:disable Bit 0            reg_ldc_gain_lut_wr //
// unsigned ,    RW, default = 0  1:software write 0:software read.
#define LDC_GAIN_LUT_CTRL1 ((0x1475 << 2) + 0xff900000)
// Bit 31: 1        reserved
// Bit 0            reg_ldc_gain_lut_str             // unsigned ,    RW, default = 0  0->1:one
// software write/read start,postive edge valid.
#define LDC_ADJ_VS_CTRL ((0x1476 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15:0          reg_ldc_blk_intsty_calc_intvl     // unsigned ,    RW, default = 200 delay
// for one block intensity calculation period
#define LDC_LOW_POWER_EN ((0x1477 << 2) + 0xff900000)
// Bit 31: 3       reserved
// Bit 2         reg_ldc_cbus_clk_gate_free         // unsigned ,    RW, default = 1 1:disable
// cbus        clock gate, 0: enable cbus         clock gate Bit 1 reg_ldc_calc_part_clk_gate_free
// // unsigned ,    RW, default = 1 1:disable calculation clock gate, 0: enable calculation  clock
// gate Bit 0         reg_ldc_comp_part_clk_gate_free    // unsigned ,    RW, default = 1
// 1:disable compensation clock gate,0: enable compensation clock gate
#define LDC_CTRL_MISC0 ((0x1478 << 2) + 0xff900000)
// Bit 31:28 reserved
// Bit 27    reg_ldc_frm_end_sel                     //unsigned , RW, default = 0   1: wait for
// all axi transfer finish 0:wait for last frame pixel Bit 26    reg_ldc_prt_func_en //unsigned ,
// RW, default = 0   1: enable LDC output protect function 0:disable LDC output protect function
// Bit 25    reg_ldc_bl_input_sft_ctr_en             //unsigned , RW, default = 0   1: software
// control backlight info write index enable Bit 24:23 reg_ldc_bl_input_sft_wr_idx //unsigned ,
// RW, default = 0   backlight info write index, for debug only Bit 22
// reg_ldc_vsync_get_bl_info_en
// //unsigned , RW, default = 1   0:get backlighth info every block line  (no vsync interrupt)
// 1:get  backlighth info  accroding to vsync Bit 21:20 reg_ldc_hist_burst_len //unsigned , RW,
// default = 0   0:2 times 128bit 1:4 times 128bit 2,3:6 times      128bit Bit 19:18
// reg_ldc_blk_intsty_burst_len            //unsigned , RW, default = 0   0:2 times 128bit 1:4
// times 128bit 2:6   times      128bit 3:8        times 128bit Bit 17    reg_ldc_vs_edge_sel
// //unsigned , RW, default = 1   1:posedge vs sync   0:negedge vs sync Bit 16 reg_ldc_adj_vs_en
// //unsigned , RW, default = 0   move "vs" to frame end,so use front+back porch time to prefetch
// profile. 1:enable 0:disable; Bit 15:0  reg_ldc_adj_vs_delay_num                //unsigned , RW,
// default = 500 add a delay num to the frame end
#define LDC_CTRL_MISC1 ((0x1479 << 2) + 0xff900000)
// Bit 31:4 reserved
// Bit 3    reg_ldc_sft_upd_glb_apl_en               //unsigned , RW, default = 1   update
// reg_ldc_glb_apl register every frame by .. 1: by software; 0: by hardware; Bit 2
// reg_ldc_scn_chg_en                       //unsigned , RW, default = 0   positive edge
// available; Bit 1    reg_ldc_pref_chk_err_clr                 //unsigned , RW, default = 1
// 1:clear ldc_pref_chk_err signal; 0: no action; Bit 0    reg_ldc_pref_chk_err_det_mode
// //unsigned , RW, default = 0   1:auto clear ldc_pref_chk_err  signal every frame; 0:no action;
#define LDC_DGB_CTRL ((0x147a << 2) + 0xff900000)
// Bit 31:15      reserved
// Bit 14        reg_ldc_comp_en                    //unsigned,      RW, default = 1 1:enable ldc
// compensation   0:disable ldc compensation Bit 13        reg_ldc_comp_pxl_cmp_en //unsigned, RW,
// default = 1 1:enable comp_pxl_cmp_en    0:disable comp_pxl_cmp_en Bit 12
// reg_ldc_comp_interp_pxl_en         //unsigned,      RW, default = 1 1:enable comp_interp_pxl_en
// 0:disable comp_interp_pxl_en Bit 11        reg_ldc_comp_blk_flt_en            //unsigned, RW,
// default = 1 1:enable comp_blk_flt_en    0:disable comp_blk_flt_en Bit 10
// reg_ldc_comp_blk_intsty_en         //unsigned,      RW, default = 1 1:enable comp_blk_intsty_en
// 0:disable comp_blk_intsty_en Bit 9        reg_ldc_calc_tmp_flt_en            //unsigned, RW,
// default = 1 1:enable calc_tmp_flt_en    0:disable calc_tmp_flt_en Bit 8:5 reg_ldc_dbg_shft_num
// //unsigned,      RW, default = 0 1:debug Bit 4:1       reg_ldc_dbg_pnt //unsigned,      RW,
// default = 0 detailed info,please refer to application note Bit 0         reg_ldc_dbg_en
// //unsigned,      RW, default = 0 0:normal mode 1: debug mode
#define LDC_RO_BL_MEMORY_IDX ((0x147b << 2) + 0xff900000)
// Bit 31: 9        reserved
// Bit  8           ro_ldc_seg_input_fid      // unsigned ,    RO, default = 0  the memory input
// segment info index Bit  7: 4        ro_ldc_bl_input_fid       // unsigned ,    RO, default = 0
// the memory input frame backlight index Bit  3: 0        ro_ldc_bl_output_fid      // unsigned ,
// RO, default = 0  the memory output frame backlight index
#define LDC_RO_GLB_HIST_SUM ((0x147c << 2) + 0xff900000)
// Bit 31: 0        ro_ldc_glb_hist_data_sum  // unsigned ,    RO, default = 0  the global hist
// data sum
#define LDC_RO_GLB_HIST_CNT ((0x147d << 2) + 0xff900000)
// Bit 31: 0        ro_ldc_glb_hist_cnt_sum   // unsigned ,    RO, default = 0  the global hist
// cnt sum
#define LDC_RO_GAIN_SMP_DATA ((0x147f << 2) + 0xff900000)
// Bit 31:25        reserved
// Bit 24           ro_ldc_gain_lut_smp_data_en           // unsigned ,    RO, default = 0  the
// output frame index Bit 23: 0        ro_ldc_gain_lut_smp_data              // unsigned ,    RO,
// default = 0  the output frame index
#define LDC_RO_PREF_CHK_ERROR ((0x1480 << 2) + 0xff900000)
// Bit 31:1        reserved
// Bit 0          ro_ldc_pref_chk_err      // unsigned ,    RO, 0:no error found; 1: found error ;
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  ldc_cbus.h
//
#define LCD_GAMMA_CNTL_PORT ((0x14a0 << 2) + 0xff900000)
#define LCD_GAMMA_DATA_PORT ((0x14a1 << 2) + 0xff900000)
#define LCD_GAMMA_ADDR_PORT ((0x14a2 << 2) + 0xff900000)
#define LCD_GAMMA_VCOM_HSWITCH_ADDR ((0x14a3 << 2) + 0xff900000)
#define LCD_RGB_BASE_ADDR ((0x14a5 << 2) + 0xff900000)
#define LCD_RGB_COEFF_ADDR ((0x14a6 << 2) + 0xff900000)
#define LCD_POL_CNTL_ADDR ((0x14a7 << 2) + 0xff900000)
#define LCD_DITH_CNTL_ADDR ((0x14a8 << 2) + 0xff900000)
#define LCD_GAMMA_PROBE_CTRL ((0x14a9 << 2) + 0xff900000)
// read only
#define LCD_GAMMA_PROBE_COLOR_L ((0x14aa << 2) + 0xff900000)
#define LCD_GAMMA_PROBE_COLOR_H ((0x14ab << 2) + 0xff900000)
#define LCD_GAMMA_PROBE_HL_COLOR ((0x14ac << 2) + 0xff900000)
#define LCD_GAMMA_PROBE_POS_X ((0x14ad << 2) + 0xff900000)
#define LCD_GAMMA_PROBE_POS_Y ((0x14ae << 2) + 0xff900000)
#define LCD_LCD_MCU_CTL ((0x14b0 << 2) + 0xff900000)
#define LCD_LCD_MCU_DATA_0 ((0x14b1 << 2) + 0xff900000)
#define LCD_LCD_MCU_DATA_1 ((0x14b2 << 2) + 0xff900000)
#define LCD_LCD_PORT_SWAP ((0x14b3 << 2) + 0xff900000)
#define LCD_GAMMA_CNTL_PORT0 ((0x14b4 << 2) + 0xff900000)
#define LCD_GAMMA_DATA_PORT0 ((0x14b5 << 2) + 0xff900000)
#define LCD_GAMMA_ADDR_PORT0 ((0x14b6 << 2) + 0xff900000)
#define LCD_LDC_AXI_UGT ((0x14b7 << 2) + 0xff900000)
//
// Closing file:  lcd_regs.h
//
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  LCD1_VCBUS_BASE = 0x15
// -----------------------------------------------
//===========================================================================
//
// Reading file:  lcd1_regs.h
//
//`define LCD0_VCBUS_BASE           8'h14
//`define LCD1_VCBUS_BASE           8'h15
//`define LCD2_VCBUS_BASE           8'h16
#define LCD1_GAMMA_CNTL_PORT ((0x15a0 << 2) + 0xff900000)
#define LCD1_GAMMA_DATA_PORT ((0x15a1 << 2) + 0xff900000)
#define LCD1_GAMMA_ADDR_PORT ((0x15a2 << 2) + 0xff900000)
#define LCD1_GAMMA_VCOM_HSWITCH_ADDR ((0x15a3 << 2) + 0xff900000)
#define LCD1_RGB_BASE_ADDR ((0x15a5 << 2) + 0xff900000)
#define LCD1_RGB_COEFF_ADDR ((0x15a6 << 2) + 0xff900000)
#define LCD1_POL_CNTL_ADDR ((0x15a7 << 2) + 0xff900000)
#define LCD1_DITH_CNTL_ADDR ((0x15a8 << 2) + 0xff900000)
#define LCD1_GAMMA_PROBE_CTRL ((0x15a9 << 2) + 0xff900000)
// read only
#define LCD1_GAMMA_PROBE_COLOR_L ((0x15aa << 2) + 0xff900000)
#define LCD1_GAMMA_PROBE_COLOR_H ((0x15ab << 2) + 0xff900000)
#define LCD1_GAMMA_PROBE_HL_COLOR ((0x15ac << 2) + 0xff900000)
#define LCD1_GAMMA_PROBE_POS_X ((0x15ad << 2) + 0xff900000)
#define LCD1_GAMMA_PROBE_POS_Y ((0x15ae << 2) + 0xff900000)
#define LCD1_LCD_MCU_CTL ((0x15b0 << 2) + 0xff900000)
#define LCD1_LCD_MCU_DATA_0 ((0x15b1 << 2) + 0xff900000)
#define LCD1_LCD_MCU_DATA_1 ((0x15b2 << 2) + 0xff900000)
#define LCD1_LCD_PORT_SWAP ((0x15b3 << 2) + 0xff900000)
#define LCD1_GAMMA_CNTL_PORT0 ((0x15b4 << 2) + 0xff900000)
#define LCD1_GAMMA_DATA_PORT0 ((0x15b5 << 2) + 0xff900000)
#define LCD1_GAMMA_ADDR_PORT0 ((0x15b6 << 2) + 0xff900000)
//
// Closing file:  lcd1_regs.h
//
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  LCD2_VCBUS_BASE = 0x16
// -----------------------------------------------
//===========================================================================
//
// Reading file:  lcd2_regs.h
//
//`define LCD0_VCBUS_BASE           8'h14
//`define LCD1_VCBUS_BASE           8'h15
//`define LCD2_VCBUS_BASE           8'h16
#define LCD2_GAMMA_CNTL_PORT ((0x16a0 << 2) + 0xff900000)
#define LCD2_GAMMA_DATA_PORT ((0x16a1 << 2) + 0xff900000)
#define LCD2_GAMMA_ADDR_PORT ((0x16a2 << 2) + 0xff900000)
#define LCD2_GAMMA_VCOM_HSWITCH_ADDR ((0x16a3 << 2) + 0xff900000)
#define LCD2_RGB_BASE_ADDR ((0x16a5 << 2) + 0xff900000)
#define LCD2_RGB_COEFF_ADDR ((0x16a6 << 2) + 0xff900000)
#define LCD2_POL_CNTL_ADDR ((0x16a7 << 2) + 0xff900000)
#define LCD2_DITH_CNTL_ADDR ((0x16a8 << 2) + 0xff900000)
#define LCD2_GAMMA_PROBE_CTRL ((0x16a9 << 2) + 0xff900000)
// read only
#define LCD2_GAMMA_PROBE_COLOR_L ((0x16aa << 2) + 0xff900000)
#define LCD2_GAMMA_PROBE_COLOR_H ((0x16ab << 2) + 0xff900000)
#define LCD2_GAMMA_PROBE_HL_COLOR ((0x16ac << 2) + 0xff900000)
#define LCD2_GAMMA_PROBE_POS_X ((0x16ad << 2) + 0xff900000)
#define LCD2_GAMMA_PROBE_POS_Y ((0x16ae << 2) + 0xff900000)
#define LCD2_LCD_MCU_CTL ((0x16b0 << 2) + 0xff900000)
#define LCD2_LCD_MCU_DATA_0 ((0x16b1 << 2) + 0xff900000)
#define LCD2_LCD_MCU_DATA_1 ((0x16b2 << 2) + 0xff900000)
#define LCD2_LCD_PORT_SWAP ((0x16b3 << 2) + 0xff900000)
#define LCD2_GAMMA_CNTL_PORT0 ((0x16b4 << 2) + 0xff900000)
#define LCD2_GAMMA_DATA_PORT0 ((0x16b5 << 2) + 0xff900000)
#define LCD2_GAMMA_ADDR_PORT0 ((0x16b6 << 2) + 0xff900000)
//
// Closing file:  lcd2_regs.h
//
//===========================================================================
//`define MAD_VCBUS_BASE          8'h17
//===========================================================================
//
// Reading file:  vpu_mad_regs.h
//
// DEINTERLACE module start from 8'h90 end to 8'hff
// -----------------------------------------------
// CBUS_BASE:  MAD_VCBUS_BASE = 0x17
// -----------------------------------------------
#define DI_PRE_CTRL ((0x1700 << 2) + 0xff900000)
// bit 31,      cbus_pre_frame_rst
// bit 30,      cbus_pre_soft_rst
// bit 29,      pre_field_num
// bit 27:26,   mode_444c422
// bit 25,      di_cont_read_en
// bit 24:23,   mode_422c444
// bit 22,      mtn_after_nr
// bit 21:16,   pre_hold_fifo_lines
// bit 15,      nr_wr_by
// bit 14,      use_vdin_go_line
// bit 13,      di_prevdin_en
// bit 12,      di_pre_viu_link
// bit 11,      di_pre_repeat
// bit 10,      di_pre_drop_1st
// bit  9,      di_buf2_en
// bit  8,      di_chan2_en
// bit  7,      prenr_hist_en
// bit  6,      chan2_hist_en
// bit  5,      hist_check_en
// bit  4,      check_after_nr
// bit  3,      check222p_en
// bit  2,      check322p_en
// bit  1,      mtn_en
// bit  0,      nr_en
#define DI_POST_CTRL ((0x1701 << 2) + 0xff900000)
// bit 31,      cbus_post_frame_rst
// bit 30,      cbus_post_soft_rst
// bit 29,      post_field_num
// bit 21:16,   post_hold_fifo_lines
// bit 13,      prepost_link
// bit 12,      di_post_viu_link
// bit 11,      di_post_repeat
// bit 10,      di_post_drop_1st
// bit  9,      mif0_to_vpp_en
// bit  8,      di_vpp_out_en
// bit  7,      di_wr_bk_en
// bit  6,      di_mux_en
// bit  5,      di_blend_en
// bit  4,      di_mtnp_read_en
// bit  3,      di_mtn_buf_en
// bit  2,      di_ei_en
// bit  1,      di_buf1_en
// bit  0,      di_buf0_en
#define DI_POST_SIZE ((0x1702 << 2) + 0xff900000)
// bit 31:29,    diwr_field_mode     field mode,  0 frame mode, 4 for field mode botton field, 5
// for field mode top field, , 6 for blank line mode bit 28:16,    vsize1post bit 12:0, hsize1post
#define DI_PRE_SIZE ((0x1703 << 2) + 0xff900000)
// bit 31:29,    nrwr_field_mode     field mode,  0 frame mode, 4 for field mode botton field, 5
// for field mode top field, , 6 for blank line mode bit 28:16,    vsize1pre bit 12:0, hsize1pre
#define DI_EI_CTRL0 ((0x1704 << 2) + 0xff900000)
// bit 23:16,    ei0_filter[2:+]  abs_diff_left>filter && ...right>filter && ...top>filter &&
// ...bot>filter -> filter bit 15:8,     ei0_threshold[2:+] bit 3,        ei0_vertical bit 2,
// ei0_bpscf2 bit 1,        ei0_bpsfar1
#define DI_EI_CTRL1 ((0x1705 << 2) + 0xff900000)
// bit 31:24,    ei0_diff
// bit 23:16,    ei0_angle45
// bit 15:8,     ei0_peak
// bit 7:0,      ei0_cross
#define DI_EI_CTRL2 ((0x1706 << 2) + 0xff900000)
// bit 31:24,    ei0_close2
// bit 23:16,    ei0_close1
// bit 15:8,     ei0_far2
// bit 7:0,      ei0_far1
//`define DI_NR_CTRL0               8'h07
// bit 26,       nr_cue_en
// bit 25,       nr2_en
#define DI_NR_CTRL1 ((0x1708 << 2) + 0xff900000)
// bit 31:30,    mot_p1txtcore_mode
// bit 29:24,    mot_p1txtcore_clmt
// bit 21:16,    mot_p1txtcore_ylmt
// bit 15:8,     mot_p1txtcore_crate
// bit 7:0,      mot_p1txtcore_yrate
#define DI_NR_CTRL2 ((0x1709 << 2) + 0xff900000)
// bit 29:24,    mot_curtxtcore_clmt
// bit 21:16,    mot_curtxtcore_ylmt
// bit 15:8,     mot_curtxtcore_crate
// bit 7:0,      mot_curtxtcore_yrate
//`define DI_NR_CTRL3               8'h0a
// no use
//`define DI_MTN_CTRL               8'h0b
//`define DI_CANVAS_URGENT0         8'h0a
//`define DI_CANVAS_URGENT1         8'h0b
#define DI_MTN_CTRL1 ((0x170c << 2) + 0xff900000)
// bit 11:8,		mtn_paramtnthd
// bit 7:0,      mtn_parafltthd
#define DI_BLEND_CTRL ((0x170d << 2) + 0xff900000)
// bit 31,      blend_1_en
// bit 30,      blend_mtn_lpf
// bit 28,      post_mb_en
// bit 27,      blend_mtn3p_max
// bit 26,      blend_mtn3p_min
// bit 25,      blend_mtn3p_ave
// bit 24,      blend_mtn3p_maxtb
// bit 23,      blend_mtn_flt_en
// bit 22,      blend_data_flt_en
// bit 21:20,   blend_top_mode
// bit 19,      blend_reg3_enable
// bit 18,      blend_reg2_enable
// bit 17,      blend_reg1_enable
// bit 16,      blend_reg0_enable
// bit 15:14,   blend_reg3_mode
// bit 13:12,   blend_reg2_mode
// bit 11:10,   blend_reg1_mode
// bit 9:8,     blend_reg0_mode
// bit 7:0,     kdeint
//`define DI_BLEND_CTRL1            8'h0e
// no use
//`define DI_CANVAS_URGENT2         8'h0e
//`define DI_BLEND_CTRL2            8'h0f
// no use
#define DI_ARB_CTRL ((0x170f << 2) + 0xff900000)
// bit 31:26,			di_arb_thd1
// bit 25:20,			di_arb_thd0
// bit 19,			di_arb_tid_mode
// bit 18,			di_arb_arb_mode
// bit 17,			di_arb_acq_en
// bit 16,			di_arb_disable_clk
// bit 15:0,			di_arb_req_en
#define DI_BLEND_REG0_X ((0x1710 << 2) + 0xff900000)
// bit 27:16,   blend_reg0_startx
// bit 11:0,    blend_reg0_endx
#define DI_BLEND_REG0_Y ((0x1711 << 2) + 0xff900000)
#define DI_BLEND_REG1_X ((0x1712 << 2) + 0xff900000)
#define DI_BLEND_REG1_Y ((0x1713 << 2) + 0xff900000)
#define DI_BLEND_REG2_X ((0x1714 << 2) + 0xff900000)
#define DI_BLEND_REG2_Y ((0x1715 << 2) + 0xff900000)
#define DI_BLEND_REG3_X ((0x1716 << 2) + 0xff900000)
#define DI_BLEND_REG3_Y ((0x1717 << 2) + 0xff900000)
#define DI_CLKG_CTRL ((0x1718 << 2) + 0xff900000)
// bit 31:24,   pre_gclk_ctrl     no clk gate control. if ==1, module clk is not gated (always
// on). [3] for pulldown,[2] for mtn_1,[1] for mtn_0,[0] for nr bit 23:16,   post_gclk_ctrl    no
// clk gate control. [4] for ei_1, [3] for ei_0,[2] for ei_top, [1] for blend_1, [0] for blend_0
// bit 1,       di_gate_all       clk shut down. if ==1 , all di clock shut down
// bit 0,       di_no_clk_gate    no clk gate control.     if di_gated_all==0 and di_no_clk_gate
// ==1, all di clock is always working.
#define DI_EI_CTRL3 ((0x1719 << 2) + 0xff900000)
// bit 31,      reg_ei_1
// bit 30,      reg_demon_en
// bit 26:24,   reg_demon_mux
// bit 23:20,   reg_right_win
// bit 19:16,   reg_left_win
// bit 7:4,     reg_ei_sadm_quatize_margin
// bit 1:0,     reg_ei_sad_relative_mode
#define DI_EI_CTRL4 ((0x171a << 2) + 0xff900000)
// bit 29,      reg_ei_caldrt_ambliike2_biasvertical
// bit 28:24,   reg_ei_caldrt_addxla2list_drtmax
// bit 22:20,   reg_ei_caldrt_addxla2list_signm0th
// bit 19,      reg_ei_caldrt_addxla2list_mode
// bit 18:16,   reg_ei_signm_sad_cor_rate
// bit 15:12,   reg_ei_signm_sadi_cor_rate
// bit 11:6,    reg_ei_signm_sadi_cor_ofst
// bit 5:0,     reg_ei_signm_sad_ofst
#define DI_EI_CTRL5 ((0x171b << 2) + 0xff900000)
// bit 30:28,   reg_ei_caldrt_cnflcctchk_frcverthrd
// bit 26:24,   reg_ei_caldrt_cnflctchk_mg
// bit 23:22,   reg_ei_caldrt_cnflctchk_ws
// bit 21,      reg_ei_caldrt_cnflctchk_en
// bit 20,      reg_ei_caldrt_verfrc_final_en
// bit 19,      reg_ei_caldrt_verfrc_retimflt_en
// bit 18:16,   reg_ei_caldrt_verftc_eithratemth
// bit 15,      reg_ei_caldrt_verfrc_retiming_en
// bit 14:12,   reg_ei_caldrt_verfrc_bothratemth
// bit 11:9,    reg_ei_caldrt_ver_thrd
// bit 8:4,     reg_ei_caldrt_addxla2list_drtmin
// bit 3:0,     reg_ei_caldrt_addxla2list_drtlimit
#define DI_EI_CTRL6 ((0x171c << 2) + 0xff900000)
// bit 31:24,   reg_ei_caldrt_abext_sad12thhig
// bit 23:16,   reg_ei_caldrt_abext_sad00thlow
// bit 15:8,    reg_ei_caldrt_abext_sad12thlow
// bit 6:4,     reg_ei_caldrt_abext_ratemth
// bit 2:0,     reg_ei_caldrt_abext_drtthrd
#define DI_EI_CTRL7 ((0x171d << 2) + 0xff900000)
// bit 29,      reg_ei_caldrt_xlanopeak_codien
// bit 28:24,   reg_ei_caldrt_xlanopeak_drtmax
// bit 23,      reg_ei_caldrt_xlanopeak_en
// bit 28:24,   reg_ei_caldrt_abext_monotrnd_alpha
// bit 28:24,   reg_ei_caldrt_abext_mononum12_thrd
// bit 28:24,   reg_ei_caldrt_abext_mononum00_thrd
// bit 28:24,   reg_ei_caldrt_abext_sad00rate
// bit 28:24,   reg_ei_caldrt_abext_sad12rate
// bit 28:24,   reg_ei_caldrt_abext_sad00thhig
#define DI_EI_CTRL8 ((0x171e << 2) + 0xff900000)
// bit 30:28,   reg_ei_assign_headtail_magin
// bit 26:24,   reg_ei_retime_lastcurpncnfltchk_mode
// bit 22:21,   reg_ei_retime_lastcurpncnfltchk_drtth
// bit 20,      reg_ei_caldrt_histchk_cnfid
// bit 19:16,   reg_ei_caldrt_histchk_thrd
// bit 15,      reg_ei_caldrt_histchk_abext
// bit 14,      reg_ei_caldrt_histchk_npen
// bit 13:11,   reg_ei_caldrt_amblike2_drtmg
// bit 10:8,    reg_ei_caldrt_amblike2_valmg
// bit 7:4,     reg_ei_caldrt_amblike2_alpha
// bit 3:0,     reg_ei_caldrt_amblike2_drtth
#define DI_EI_CTRL9 ((0x171f << 2) + 0xff900000)
// bit 31:28,   reg_ei_caldrt_hcnfcheck_frcvert_xla_th3
// bit 27,      reg_ei_caldrt_hcnfcheck_frcvert_xla_en
// bit 26:24,   reg_ei_caldrt_conf_drtth
// bit 23:20,   reg_ei_caldrt_conf_absdrtth
// bit 19:18,   reg_ei_caldrt_abcheck_mode1
// bit 17:16,   reg_ei_caldrt_abcheck_mode0
// bit 15:12,   reg_ei_caldrt_abcheck_drth1
// bit 11:8,    reg_ei_caldrt_abcheck_drth0
// bit 6:4,     reg_ei_caldrt_abpnchk1_th
// bit 1,       reg_ei_caldrt_abpnchk1_en
// bit 0,       reg_ei_caldrt_abpnchk0_en
// DEINTERLACE mode check.
#define DI_MC_REG0_X ((0x1720 << 2) + 0xff900000)
// bit 27:16,   mc_reg0_start_x
// bit 11:0,    mc_reg0_end_x
#define DI_MC_REG0_Y ((0x1721 << 2) + 0xff900000)
#define DI_MC_REG1_X ((0x1722 << 2) + 0xff900000)
#define DI_MC_REG1_Y ((0x1723 << 2) + 0xff900000)
#define DI_MC_REG2_X ((0x1724 << 2) + 0xff900000)
#define DI_MC_REG2_Y ((0x1725 << 2) + 0xff900000)
#define DI_MC_REG3_X ((0x1726 << 2) + 0xff900000)
#define DI_MC_REG3_Y ((0x1727 << 2) + 0xff900000)
#define DI_MC_REG4_X ((0x1728 << 2) + 0xff900000)
#define DI_MC_REG4_Y ((0x1729 << 2) + 0xff900000)
#define DI_MC_32LVL0 ((0x172a << 2) + 0xff900000)
// bit 31:24,   mc_reg2_32lvl
// bit 23:16,   mc_reg1_32lvl
// bit 15:8,    mc_reg0_32lvl
// bit 7:0,     field_32lvl
#define DI_MC_32LVL1 ((0x172b << 2) + 0xff900000)
// bit 15:8,    mc_reg3_32lvl
// bit 7:0,     mc_reg4_32lvl
#define DI_MC_22LVL0 ((0x172c << 2) + 0xff900000)
// bit 31:16,   mc_reg0_22lvl
// bit 15:0,    field_22lvl
#define DI_MC_22LVL1 ((0x172d << 2) + 0xff900000)
// bit 31:16,   mc_reg2_22lvl
// bit 15:0,    mc_reg1_22lvl
#define DI_MC_22LVL2 ((0x172e << 2) + 0xff900000)
// bit 31:16,   mc_reg4_22lvl
// bit 15:0,    mc_reg3_22lvl
#define DI_MC_CTRL ((0x172f << 2) + 0xff900000)
// bit 4,       mc_reg4_en
// bit 3,       mc_reg3_en
// bit 2,       mc_reg2_en
// bit 1,       mc_reg1_en
// bit 0,       mc_reg0_en
#define DI_INTR_CTRL ((0x1730 << 2) + 0xff900000)
#define DI_INFO_ADDR ((0x1731 << 2) + 0xff900000)
#define DI_INFO_DATA ((0x1732 << 2) + 0xff900000)
#define DI_PRE_HOLD ((0x1733 << 2) + 0xff900000)
//// DET 3D REG DEFINE BEGIN ////
//// 8'h34~8'h3f
//     `define DET3D_MOTN_CFG                8'h34
//     //Bit 16,	reg_det3d_intr_en        Det3d interrupt enable
//     //Bit 9:8,	reg_Det3D_Motion_Mode    U2  Different mode for Motion Calculation of Luma
//     and Chroma:
//     //                                      0: MotY, 1: (2*MotY + (MotU + MotV))/4; 2:
//     Max(MotY, MotU,MotV); 3:Max(MotY, (MotU+MotV)/2)
//     //Bit 7:4,reg_Det3D_Motion_Core_Rate	U4  K Rate to Edge (HV) details for coring of
//     Motion Calculations, normalized to 32
//     //Bit 3:0,	reg_Det3D_Motion_Core_Thrd	U4  2X: static coring value for Motion
//     Detection.
//
//     `define DET3D_CB_CFG                  8'h35
//     //Bit 7:4,	reg_Det3D_ChessBd_NHV_ofst	U4,  Noise immune offset for NON-Horizotnal
//     or vertical combing detection.
//     //Bit 3:0,	reg_Det3D_ChessBd_HV_ofst	U4,  Noise immune offset for Horizotnal or
//     vertical combing detection.
//
//     `define DET3D_SPLT_CFG                8'h36
//     //Bit 7:4,reg_Det3D_SplitValid_ratio	U4,  Ratio between max_value and the avg_value of
//     the edge mapping for split line valid detection.
//     //                                      The smaller of this value, the easier of the split
//     line detected.
//     //Bit 3:0,	reg_Det3D_AvgIdx_ratio	    U4,  Ratio to the avg_value of the edge mapping
//     for split line position estimation.
//     //                                      The smaller of this value, the more samples will be
//     added to the estimation.
//
//     `define DET3D_HV_MUTE                 8'h37
//     //Bit 23:20, reg_Det3D_Edge_Ver_Mute	U4  X2: Horizontal pixels to be mute from H/V Edge
//     calculation Top and Bottom border part.
//     //Bit 19:16, reg_Det3D_Edge_Hor_Mute	U4  X2: Horizontal pixels to be mute from H/V Edge
//     calculation Left and right border part.
//     //Bit 15:12, reg_Det3D_ChessBd_Ver_Mute	U4  X2: Horizontal pixels to be mute from
//     ChessBoard statistics calculation in middle part
//     //Bit 11:8,	 reg_Det3D_ChessBd_Hor_Mute	U4  X2: Horizontal pixels to be mute from
//     ChessBoard statistics calculation in middle part
//     //Bit 7:4,	 reg_Det3D_STA8X8_Ver_Mute	U4  1X: Vertical pixels to be mute from
//     8x8 statistics calculation in each block.
//     //Bit 3:0,	 reg_Det3D_STA8X8_Hor_Mute	U4  1X: Horizontal pixels to be mute from
//     8x8 statistics calculation in each block.
//
//     `define DET3D_MAT_STA_P1M1            8'h38
//     //Bit 31:24, reg_Det3D_STA8X8_P1_K0_R8	U8  SAD to SAI ratio to decide P1, normalized to
//     256 (0.8)
//     //Bit 23:16, reg_Det3D_STA8X8_P1_K1_R7	U8  SAD to ENG ratio to decide P1, normalized to
//     128 (0.5)
//     //Bit 15:8, reg_Det3D_STA8X8_M1_K0_R6 U8  SAD to SAI ratio to decide M1, normalized to
//     64 (1.1)
//     //Bit 7:0, reg_Det3D_STA8X8_M1_K1_R6 U8  SAD to ENG ratio to decide M1, normalized to
//     64 (0.8)
//
//     `define DET3D_MAT_STA_P1TH            8'h39
//     //Bit 23:16, reg_Det3D_STAYUV_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16 (100)
//     //Bit 15:8,	 reg_Det3D_STAEDG_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1,
//     X16 (80)
//     //Bit 7:0,	 reg_Det3D_STAMOT_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1,
//     X16 (48)
//
//     `define DET3D_MAT_STA_M1TH            8'h3a
//     //Bit 23:16, reg_Det3D_STAYUV_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16 (100)
//     //Bit 15:8,	 reg_Det3D_STAEDG_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1,
//     X16 (80)
//     //Bit 7:0,	 reg_Det3D_STAMOT_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1,
//     X16 (64)
//
//     `define DET3D_MAT_STA_RSFT            8'h3b
//     //Bit 5:4,	 reg_Det3D_STAYUV_RSHFT	    U2  YUV statistics SAD and SAI calculation
//     result right shift bits to accommodate the 12bits clipping:
//     //                                      0: mainly for images <=720x480: 1: mainly for
//     images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//     //Bit 3:2,	 reg_Det3D_STAEDG_RSHFT	    U2  Horizontal and Vertical Edge Statistics SAD
//     and SAI calculation result right shift bits to accommodate the 12bits clipping:
//     //                                      0: mainly for images <=720x480: 1: mainly for
//     images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//     //Bit 1:0,	 reg_Det3D_STAMOT_RSHFT	    U2  Motion SAD and SAI calculation result
//     right shift bits to accommodate the 12bits clipping:
//     //                                      0: mainly for images <=720x480: 1: mainly for
//     images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//
//     `define DET3D_MAT_SYMTC_TH            8'h3c
//     //Bit 31:24, reg_Det3D_STALUM_symtc_Th	  U8  threshold to decide if the Luma statistics
//     is TB or LR symmetric.
//     //Bit 23:16, reg_Det3D_STACHR_symtc_Th	  U8  threshold to decide if the Chroma (UV)
//     statistics is TB or LR symmetric.
//     //Bit 15:8,	 reg_Det3D_STAEDG_symtc_Th	  U8  threshold to decide if the Horizontal
//     and Vertical Edge statistics is TB or LR symmetric.
//     //Bit 7:0, reg_Det3D_STAMOT_symtc_Th	  U8  threshold to decide if the Motion statistics
//     is TB or LR symmetric.
//
//     `define DET3D_RO_DET_CB_HOR           8'h3d
//     //Bit 31:16, RO_Det3D_ChessBd_NHor_value    U16  X64: number of Pixels of Horizontally
//     Surely NOT matching Chessboard pattern.
//     //Bit 15:0,	 RO_Det3D_ChessBd_Hor_value	    U16  X64: number of Pixels of
//     Horizontally Surely matching Chessboard pattern.
//
//     `define DET3D_RO_DET_CB_VER           8'h3e
//     //Bit 31:16, RO_Det3D_ChessBd_NVer_value	U16  X64: number of Pixels of Vertically Surely
//     NOT matching Chessboard pattern.
//     //Bit 15:0,	 RO_Det3D_ChessBd_Ver_value	    U16  X64: number of Pixels of Vertically
//     Surely matching Chessboard pattern.
//
//     `define DET3D_RO_SPLT_HT              8'h3f
//     //Bit 24, RO_Det3D_Split_HT_valid	U1  horizontal LR split border detected valid signal
//     for top half picture
//     //Bit 20:16, RO_Det3D_Split_HT_pxnum	U5  number of pixels included for the LR split
//     position estimation for top half picture
//     //Bit 9:0,	 RO_Det3D_Split_HT_idxX4	S10  X4: horizontal pixel shifts of LR split
//     position to the (ColMax/2) for top half picture
//
//     //// DET 3D REG DEFINE END ////
#define DI_MTN_1_CTRL1 ((0x1740 << 2) + 0xff900000)
// bit 31,      mtn_1_en
// bit 30,      mtn_init
// bit 29,      di2nr_txt_en
// bit 28,      reserved
// bit 27:24,   mtn_def
// bit 23:16,   mtn_adp_yc
// bit 15:8,    mtn_adp_2c
// bit 7:0,     mtn_adp_2y
#define DI_MTN_1_CTRL2 ((0x1741 << 2) + 0xff900000)
// bit 31:24,   mtn_ykinter
// bit 23:16,   mtn_ckinter
// bit 15:8,    mtn_ykintra
// bit  7:0,    mtn_ckintra
#define DI_MTN_1_CTRL3 ((0x1742 << 2) + 0xff900000)
// bit 31:24,   mtn_tyrate
// bit 23:16,   mtn_tcrate
// bit 15: 8,   mtn_mxcmby
// bit  7: 0,   mtn_mxcmbc
#define DI_MTN_1_CTRL4 ((0x1743 << 2) + 0xff900000)
// bit 31:24,   mtn_tcorey
// bit 23:16,   mtn_tcorec
// bit 15: 8,   mtn_minth
// bit  7: 0,   mtn_maxth
#define DI_MTN_1_CTRL5 ((0x1744 << 2) + 0xff900000)
// bit 31:28,   mtn_m1b_extnd
// bit 27:24,   mtn_m1b_errod
// bit 21:20,   mtn_mot_txt_mode
// bit 19:18,   mtn_replace_cbyy
// bit 17:16,   mtn_replace_ybyc
// bit 15: 8,   mtn_core_ykinter
// bit  7: 0,   mtn_core_ckinter
//// NR2 REG DEFINE BEGIN////
#define NR2_MET_NM_CTRL ((0x1745 << 2) + 0xff900000)
// Bit 28,	   reg_NM_reset	          Reset to the status of the Loop filter.
// Bit 27:24,   reg_NM_calc_length	  Length mode of the Noise measurement sample number for
// statistics.
//                                    0:  256 samples;    1: 512 samples;    2: 1024 samples;
//                                    ¡­X: 2^(8+x) samples
// Bit 23:20,   reg_NM_inc_step	      Loop filter input gain increase step.
// Bit 19:16,   reg_NM_dec_step	      Loop filter input gain decrease step.
// Bit 15:8,	   reg_NM_YHPmot_thrd	  Luma channel HP portion motion for condition of pixels
// included in Luma Noise measurement.
// Bit 7:0,	   reg_NM_CHPmot_thrd	  Chroma channel HP portion motion for condition of pixels
// included in Chroma Noise measurement.
#define NR2_MET_NM_YCTRL ((0x1746 << 2) + 0xff900000)
// Bit 31:28,   reg_NM_YPLL_target	      Target rate of NM_Ynoise_thrd to mean of the Luma
// Noise Bit 27:24,   reg_NM_YLPmot_thrd	      Luma channel LP portion motion for condition
// of pixels included in Luma Noise measurement. Bit 23:16,   reg_NM_YHPmot_thrd_min	  Minimum
// threshold for Luma channel HP portion motion to decide whether the pixel will be included in
// Luma noise measurement. Bit 15:8,	   reg_NM_YHPmot_thrd_max	  Maximum threshold for
// Luma channel HP portion motion to decide whether the pixel will be included in Luma noise
// measurement. Bit 7:0,	   reg_NM_Ylock_rate	      Rate to decide whether the Luma
// noise measurement is lock or not.
#define NR2_MET_NM_CCTRL ((0x1747 << 2) + 0xff900000)
// Bit 31:28,	reg_NM_CPLL_target	     Target rate of NM_Cnoise_thrd to mean of the Chroma
// Noise Bit 27:24,	reg_NM_CLPmot_thrd	     Chroma channel LP portion motion for
// condition of pixels included in Chroma Noise measurement. Bit 23:16,	reg_NM_CHPmot_thrd_min
// Minimum threshold for Chroma channel HP portion motion to decide whether the pixel will be
// included in Chroma noise measurement. Bit 15:8,	    reg_NM_CHPmot_thrd_max Maximum
// threshold for Chroma channel HP portion motion to decide whether the pixel will be included in
// Chroma noise measurement. Bit 7:0,	    reg_NM_Clock_rate	     Rate to decide whether the
// Chroma noise measurement is lock or not;
#define NR2_MET_NM_TNR ((0x1748 << 2) + 0xff900000)
// Bit 25,	    ro_NM_TNR_Ylock	         Read-only register to tell ifLuma channel noise
// measurement is locked or not. Bit 24,	    ro_NM_TNR_Clock	         Read-only register
// to tell if Chroma channel noise measurement is locked or not. Bit 23:12,	ro_NM_TNR_Ylevel
// Read-only register to give Luma channel noise level. It was 16x of pixel difference in 8 bits
// of YHPmot. Bit 11:0,	ro_NM_TNR_Clevel	         Read-only register to give Chroma channel
// noise level. It was 16x of pixel difference in 8 bits of CHPmot.
#define NR2_MET_NMFRM_TNR_YLEV ((0x1749 << 2) + 0xff900000)
// Bit 28:0,	ro_NMFrm_TNR_Ylevel	         Frame based Read-only register to give Luma
// channel noise level within one frame/field.
#define NR2_MET_NMFRM_TNR_YCNT ((0x174a << 2) + 0xff900000)
// Bit 23:0,	ro_NMFrm_TNR_Ycount	         Number ofLuma channel pixels included in
// Frame/Field based noise level measurement.
#define NR2_MET_NMFRM_TNR_CLEV ((0x174b << 2) + 0xff900000)
// Bit 28:0,	ro_NMFrm_TNR_Clevel	         Frame based Read-only register to give Chroma
// channel noise level within one frame/field.
#define NR2_MET_NMFRM_TNR_CCNT ((0x174c << 2) + 0xff900000)
// Bit 23:0,	ro_NMFrm_TNR_Ccount	         Number of Chroma channel pixels included in
// Frame/Field based noise level measurement.
#define NR2_3DEN_MODE ((0x174d << 2) + 0xff900000)
// Bit 6:4,	Blend_3dnr_en_r
// Bit 2:0,	Blend_3dnr_en_l
//   `define NR2_IIR_CTRL                8'h4e
//   //Bit 15:14, reg_LP_IIR_8bit_mode	LP IIR membitwidth mode:0: 10bits will be store in
//   memory;1: 9bits will be store in memory;
//   //                                  2: 8bits will be store in memory;3: 7bits will be store
//   in memory;
//   //Bit 13:12, reg_LP_IIR_mute_mode	Mode for the LP IIR mute,
//   //Bit 11:8,	 reg_LP_IIR_mute_thrd	Threshold of LP IIR mute to avoid ghost:
//   //Bit 7:6, reg_HP_IIR_8bit_mode IIR membitwidth mode:0: 10bits will be store in memory;1:
//   9bits will be store in memory;
//   //                                  2: 8bits will be store in memory;3: 7bits will be store
//   in memory;
//   //Bit 5:4,	reg_HP_IIR_mute_mode	Mode for theLP IIR mute
//   //Bit 3:0,	reg_HP_IIR_mute_thrd	Threshold of HP IIR mute to avoid ghost
//   //
#define NR2_SW_EN ((0x174f << 2) + 0xff900000)
// Bit 17:8,	Clk_gate_ctrl
// Bit 7,	Cfr_enable
// Bit 5,	Det3d_en
// Bit 4,	Nr2_proc_en
// Bit 0,	Nr2_sw_en
#define NR2_FRM_SIZE ((0x1750 << 2) + 0xff900000)
// Bit 27:16,  Frm_heigh	Frame/field height
// Bit 11: 0,  Frm_width	Frame/field width
//   `define NR2_SNR_SAD_CFG             8'h51
//   //Bit 12,	reg_MATNR_SNR_SAD_CenRPL	U1, Enable signal for Current pixel position SAD to
//   be replaced by SAD_min.0: do not replace Current pixel position SAD by SAD_min;1: do
//   replacements
//   //Bit 11:8,reg_MATNR_SNR_SAD_coring Coring value of the intra-frame SAD. sum = (sum
//   - reg_MATNR_SNR_SAD_coring);sum = (sum<0) ? 0: (sum>255)? 255: sum;
//   //Bit 6:5,	reg_MATNR_SNR_SAD_WinMod	Unsigned, Intra-frame SAD matching window mode:0:
//   1x1; 1: [1 1 1] 2: [1 2 1]; 3: [1 2 2 2 1];
//   //Bit 4:0,	Sad_coef_num	            Sad coeffient
//
//   `define NR2_MATNR_SNR_OS            8'h52
//   //Bit 7:4,	reg_MATNR_SNR_COS	    SNR Filter overshoot control margin for UV channel (X2
//   to u10 scale)
//   //Bit 3:0,	reg_MATNR_SNR_YOS	    SNR Filter overshoot control margin for luma channel
//   (X2 to u10 scale)
//
//   `define NR2_MATNR_SNR_NRM_CFG       8'h53
//   //Bit 23:16,	reg_MATNR_SNR_NRM_ofst	Edge based SNR boosting normalization offset to
//   SAD_max ;
//   //Bit 15:8,	    reg_MATNR_SNR_NRM_max	Edge based SNR boosting normalization Max
//   value
//   //Bit 7:0,	    reg_MATNR_SNR_NRM_min	Edge based SNR boosting normalization Min value
//
//   `define NR2_MATNR_SNR_NRM_GAIN      8'h54
//   //Bit 15:8,	reg_MATNR_SNR_NRM_Cgain	Edge based SNR boosting normalization Gain for
//   Chrm channel (norm 32 as 1)
//   //Bit 7:0,	reg_MATNR_SNR_NRM_Ygain	Edge based SNR boosting normalization Gain for Luma
//   channel (norm 32 as 1)
//
//   `define NR2_MATNR_SNR_LPF_CFG       8'h55
//   //Bit 23:16,reg_MATNR_SNRLPF_SADmaxTH	U8,  Threshold to SADmax to use TNRLPF to replace
//   SNRLPF. i.e.if (SAD_max<reg_MATNR_SNRLPF_SADmaxTH) SNRLPF_yuv[k] = TNRLPF_yuv[k];
//   //Bit 13:11,reg_MATNR_SNRLPF_Cmode	    LPF based SNR filtering mode on CHRM channel:
//   //                                      0: gradient LPF [1 1]/2, 1: gradient LPF [2 1 1]/4;
//   2: gradient LPF [3 3 2]/8; 3: gradient LPF [5 4 4 3]/16;
//   //                                      4: TNRLPF;  5 : CurLPF3x3_yuv[];  6: CurLPF3o3_yuv[]
//   7: CurLPF3x5_yuv[]
//   //Bit 10:8,	reg_MATNR_SNRLPF_Ymode	    LPF based SNR filtering mode on LUMA channel:
//   //                                      0: gradient LPF //Bit [1 1]/2, 1: gradient LPF [2 1
//   1]/4; 2: gradient LPF [3 3 2]/8;3: gradient LPF [5 4 4 3]/16;
//   //                                      4: TNRLPF;               5 : CurLPF3x3_yuv[]; 6:
//   CurLPF3o3_yuv[]         7: CurLPF3x5_yuv[]
//   //Bit 7:4,	reg_MATNR_SNRLPF_SADmin3TH	Offset threshold to SAD_min to Discard SAD_min3
//   corresponding pixel in LPF SNR filtering. (X8 to u8 scale)
//   //Bit 3:0,	reg_MATNR_SNRLPF_SADmin2TH	Offset threshold to SAD_min to Discard SAD_min2
//   corresponding pixel in LPF SNR filtering. (X8 to u8 scale)
//
//   `define NR2_MATNR_SNR_USF_GAIN      8'h56
//   //Bit 15:8,	reg_MATNR_SNR_USF_Cgain	    Un-sharp (HP) compensate back Chrm portion
//   gain, (norm 64 as 1)
//   //Bit 7:0,	reg_MATNR_SNR_USF_Ygain	    Un-sharp (HP) compensate back Luma portion gain, (norm
//   64 as 1)
//
//   `define NR2_MATNR_SNR_EDGE2B        8'h57
//   //Bit 15:8,	reg_MATNR_SNR_Edge2Beta_ofst	U8,  Offset for Beta based on Edge.
//   //Bit 7:0,	reg_MATNR_SNR_Edge2Beta_gain	U8.  Gain to SAD_min for Beta based on Edge. (norm
//   16 as 1)
//
//   `define NR2_MATNR_BETA_EGAIN        8'h58
//   //Bit 15:8,	reg_MATNR_CBeta_Egain	U8,  Gain to Edge based Beta for Chrm channel.
//   (normalized to 32 as 1)
//   //Bit 7:0,	reg_MATNR_YBeta_Egain	U8,  Gain to Edge based Beta for Luma channel. (normalized
//   to 32 as 1)
//
//   `define NR2_MATNR_BETA_BRT          8'h59
//   //Bit 31:28,	reg_MATNR_beta_BRT_limt_hi	U4,  Beta adjustment based on Brightness
//   high side Limit. (X16 to u8 scale)
//   //Bit 27:24,	reg_MATNR_beta_BRT_slop_hi	U4,  Beta adjustment based on Brightness
//   high side slope. Normalized to 16 as 1
//   //Bit 23:16,	reg_MATNR_beta_BRT_thrd_hi	U8,  Beta adjustment based on Brightness
//   high threshold.(u8 scale)
//   //Bit 15:12,	reg_MATNR_beta_BRT_limt_lo	U4,  Beta adjustment based on Brightness low
//   side Limit. (X16 to u8 scale)
//   //Bit 11:8,	    reg_MATNR_beta_BRT_slop_lo	U4,  Beta adjustment based on Brightness
//   low side slope. Normalized to 16 as 1
//   //Bit 7:0,	    reg_MATNR_beta_BRT_thrd_lo	U8,  Beta adjustment based on Brightness low
//   threshold.(u8 scale) `define NR2_MATNR_XBETA_CFG         8'h5a
//   //Bit 19:18,	reg_MATNR_CBeta_use_mode	U2,  Beta options (mux) from beta_motion
//   and beta_edge for Chrm channel;
//   //Bit 17:16,	reg_MATNR_YBeta_use_mode	U2,  Beta options (mux) from beta_motion
//   and beta_edge for Luma channel;
//   //Bit 15: 8,	reg_MATNR_CBeta_Ofst	    U8,  Offset to Beta for Chrm channel.(after
//   beta_edge and beta_motion mux)
//   //Bit  7: 0,	reg_MATNR_YBeta_Ofst	    U8,  Offset to Beta for Luma channel.(after
//   beta_edge and beta_motion mux) `define NR2_MATNR_YBETA_SCL         8'h5b
//   //Bit 31:24,	reg_MATNR_YBeta_scale_min	U8,  Final step Beta scale low limit for
//   Luma channel;
//   //Bit 23:16,	reg_MATNR_YBeta_scale_max	U8,  Final step Beta scale high limit for
//   Luma channe;
//   //Bit 15: 8,	reg_MATNR_YBeta_scale_gain	U8,  Final step Beta scale Gain for Luma
//   channel (normalized 32 to 1);
//   //Bit 7 : 0,	reg_MATNR_YBeta_scale_ofst	S8,  Final step Beta scale offset for Luma
//   channel ; `define NR2_MATNR_CBETA_SCL         8'h5c
//   //Bit 31:24,	reg_MATNR_CBeta_scale_min	Final step Beta scale low limit for Chrm
//   channel.Similar to Y
//   //Bit 23:16,	reg_MATNR_CBeta_scale_max	U8,  Final step Beta scale high limit for
//   Chrm channel.Similar to Y
//   //Bit 15: 8,	reg_MATNR_CBeta_scale_gain	U8,  Final step Beta scale Gain for Chrm
//   channel Similar to Y
//   //Bit  7: 0,	reg_MATNR_CBeta_scale_ofst	S8,  Final step Beta scale offset for Chrm
//   channel Similar to Y `define NR2_SNR_MASK                8'h5d
//   //Bit 20:0,    SAD_MSK	                    Valid signal in the 3x7 SAD surface
//   `define NR2_SAD2NORM_LUT0           8'h5e
//   //Bit 31:24,	reg_MATNR_SAD2Norm_LUT_3	SAD convert normal LUT node 3
//   //Bit 23:16,	reg_MATNR_SAD2Norm_LUT_2	SAD convert normal LUT node 2
//   //Bit 15: 8,	reg_MATNR_SAD2Norm_LUT_1	SAD convert normal LUT node 1
//   //Bit  7: 0,	reg_MATNR_SAD2Norm_LUT_0	SAD convert normal LUT node 0
//   `define NR2_SAD2NORM_LUT1           8'h5f
//   //Bit 31:24,	reg_MATNR_SAD2Norm_LUT_7	SAD convert normal LUT node 7
//   //Bit 23:16,	reg_MATNR_SAD2Norm_LUT_6	SAD convert normal LUT node 6
//   //Bit 15: 8,	reg_MATNR_SAD2Norm_LUT_5	SAD convert normal LUT node 5
//   //Bit  7: 0,	reg_MATNR_SAD2Norm_LUT_4	SAD convert normal LUT node 4
//   `define NR2_SAD2NORM_LUT2           8'h60
//   //Bit 31:24,	reg_MATNR_SAD2Norm_LUT_11	SAD convert normal LUT node 11
//   //Bit 23:16,	reg_MATNR_SAD2Norm_LUT_10	SAD convert normal LUT node 10
//   //Bit 15: 8,	reg_MATNR_SAD2Norm_LUT_9	SAD convert normal LUT node 9
//   //Bit  7: 0,	reg_MATNR_SAD2Norm_LUT_8	SAD convert normal LUT node 8
//   `define NR2_SAD2NORM_LUT3           8'h61
//   //Bit 31:24,	reg_MATNR_SAD2Norm_LUT_15	SAD convert normal LUT node 15
//   //Bit 23:16,	reg_MATNR_SAD2Norm_LUT_14	SAD convert normal LUT node 14
//   //Bit 15:8,	reg_MATNR_SAD2Norm_LUT_13	SAD convert normal LUT node 13
//   //Bit 7:0,	reg_MATNR_SAD2Norm_LUT_12	SAD convert normal LUT node 12
//   `define NR2_EDGE2BETA_LUT0          8'h62
//   //Bit 31:24,	reg_MATNR_Edge2Beta_LUT_3	Edge convert beta LUT node 3
//   //Bit 23:16,	reg_MATNR_Edge2Beta_LUT_2	Edge convert beta LUT node 2
//   //Bit 15: 8,	reg_MATNR_Edge2Beta_LUT_1	Edge convert beta LUT node 1
//   //Bit  7: 0,	reg_MATNR_Edge2Beta_LUT_0	Edge convert beta LUT node 0
//   `define NR2_EDGE2BETA_LUT1          8'h63
//   //Bit 31:24,	reg_MATNR_Edge2Beta_LUT_7	Edge convert beta LUT node 7
//   //Bit 23:16,	reg_MATNR_Edge2Beta_LUT_6	Edge convert beta LUT node 6
//   //Bit 15: 8,	reg_MATNR_Edge2Beta_LUT_5	Edge convert beta LUT node 5
//   //Bit  7: 0,	reg_MATNR_Edge2Beta_LUT_4	Edge convert beta LUT node 4
//   `define NR2_EDGE2BETA_LUT2          8'h64
//   //Bit 31:24,	reg_MATNR_Edge2Beta_LUT_11	Edge convert beta LUT node 11
//   //Bit 23:16,	reg_MATNR_Edge2Beta_LUT_10	Edge convert beta LUT node 10
//   //Bit 15: 8,	reg_MATNR_Edge2Beta_LUT_9	Edge convert beta LUT node 9
//   //Bit  7: 0,	reg_MATNR_Edge2Beta_LUT_8	Edge convert beta LUT node 8
//   `define NR2_EDGE2BETA_LUT3          8'h65
//   //Bit 31:24,	reg_MATNR_Edge2Beta_LUT_15	Edge convert beta LUT node 15
//   //Bit 23:16,	reg_MATNR_Edge2Beta_LUT_14	Edge convert beta LUT node 14
//   //Bit 15: 8,	reg_MATNR_Edge2Beta_LUT_13	Edge convert beta LUT node 13
//   //Bit  7: 0,	reg_MATNR_Edge2Beta_LUT_12	Edge convert beta LUT node 12
//   `define NR2_MOTION2BETA_LUT0        8'h66
//   //Bit 31:24,	reg_MATNR_Mot2Beta_LUT_3	Motion convert beta LUT node 3
//   //Bit 23:16,	reg_MATNR_Mot2Beta_LUT_2	Motion convert beta LUT node 2
//   //Bit 15: 8,	reg_MATNR_Mot2Beta_LUT_1	Motion convert beta LUT node 1
//   //Bit  7: 0,	reg_MATNR_Mot2Beta_LUT_0	Motion convert beta LUT node 0
//   `define NR2_MOTION2BETA_LUT1        8'h67
//   //Bit 31:24,	reg_MATNR_Mot2Beta_LUT_7	Motion convert beta LUT node 7
//   //Bit 23:16,	reg_MATNR_Mot2Beta_LUT_6	Motion convert beta LUT node 6
//   //Bit 15: 8,	reg_MATNR_Mot2Beta_LUT_5	Motion convert beta LUT node 5
//   //Bit  7: 0,	reg_MATNR_Mot2Beta_LUT_4	Motion convert beta LUT node 4
//   `define NR2_MOTION2BETA_LUT2        8'h68
//   //Bit 31:24,	reg_MATNR_Mot2Beta_LUT_11	Motion convert beta LUT node 11
//   //Bit 23:16,	reg_MATNR_Mot2Beta_LUT_10	Motion convert beta LUT node 10
//   //Bit 15: 8,	reg_MATNR_Mot2Beta_LUT_9	Motion convert beta LUT node 9
//   //Bit  7: 0,	reg_MATNR_Mot2Beta_LUT_8	Motion convert beta LUT node 8
//   `define NR2_MOTION2BETA_LUT3        8'h69
//   //Bit 31:24,	reg_MATNR_Mot2Beta_LUT_15	Motion convert beta LUT node 15
//   //Bit 23:16,	reg_MATNR_Mot2Beta_LUT_14	Motion convert beta LUT node 14
//   //Bit 15: 8,	reg_MATNR_Mot2Beta_LUT_13	Motion convert beta LUT node 13
//   //Bit  7: 0,	reg_MATNR_Mot2Beta_LUT_12	Motion convert beta LUT node 12
//    `define NR2_MATNR_MTN_CRTL          8'h6a
//    //Bit 25:24,	reg_MATNR_Vmtn_use_mode	    Motion_yuvV channel motion selection mode:0:
//    Vmot;1:Ymot/2 + (Umot+Vmot)/4; 2:Ymot/2 + max(Umot,Vmot)/2; 3: max(Ymot,Umot, Vmot)
//    //Bit 21:20,	reg_MATNR_Umtn_use_mode	    Motion_yuvU channel motion selection
//    mode:0:Umot;1:Ymot/2 + (Umot+Vmot)/4; 2:Ymot/2 + max(Umot,Vmot)/2; 3: max(Ymot,Umot, Vmot)
//    //Bit 17:16,	reg_MATNR_Ymtn_use_mode	    Motion_yuvLuma channel motion selection
//    mode:0: Ymot, 1: Ymot/2 + (Umot+Vmot)/4; 2: Ymot/2 + max(Umot,Vmot)/2; 3:  max(Ymot,Umot,
//    Vmot)
//    //Bit 13:12,	reg_MATNR_mtn_txt_mode	    Texture detection mode for adaptive coring of
//    HP motion
//    //Bit  9: 8,	reg_MATNR_mtn_cor_mode	    Coring selection mode based on texture
//    detection;
//    //Bit  6: 4,	reg_MATNR_mtn_hpf_mode	    video mode of current and previous frame/field
//    for MotHPF_yuv[k] calculation:
//    //Bit  2: 0,	reg_MATNR_mtn_lpf_mode	    LPF video mode of current and previous
//    frame/field for MotLPF_yuv[k] calculation: `define NR2_MATNR_MTN_CRTL2         8'h6b
//    //Bit 18:16,	reg_MATNR_iir_BS_Ymode	    IIR TNR filter Band split filter mode for Luma
//    LPF result generation (Cur and Prev);
//    //Bit 15: 8,	reg_MATNR_mtnb_alpLP_Cgain	Scale of motion_brthp_uv to
//    motion_brtlp_uv, normalized to 32 as 1
//    //Bit  7: 0,	reg_MATNR_mtnb_alpLP_Ygain	Scale of motion_brthp_y to motion_brtlp_y,
//    normalized to 32 as 1 `define NR2_MATNR_MTN_COR           8'h6c
//    //Bit 15:12,	reg_MATNR_mtn_cor_Cofst	    Coring Offset for Chroma Motion.
//    //Bit 11: 8,	reg_MATNR_mtn_cor_Cgain	    Gain to texture based coring for Chroma
//    Motion. Normalized to 16 as 1
//    //Bit  7: 4,	reg_MATNR_mtn_cor_Yofst	    Coring Offset for Luma Motion.
//    //Bit  3: 0,	reg_MATNR_mtn_cor_Ygain	    Gain to texture based coring for Luma Motion.
//    Normalized to 16 as 1 `define NR2_MATNR_MTN_GAIN          8'h6d
//    //Bit 31:24,	reg_MATNR_mtn_hp_Cgain	Gain to MotHPF_yuv[k] Chrm channel for motion
//    calculation, normalized to 64 as 1
//    //Bit 23:16,	reg_MATNR_mtn_hp_Ygain	Gain to MotHPF_yuv[k] Luma channel for motion
//    calculation, normalized to 64 as 1
//    //Bit 15: 8,	reg_MATNR_mtn_lp_Cgain	Gain to MotLPF_yuv[k] Chrm channel for motion
//    calculation, normalized to 32 as 1
//    //Bit  7: 0,	reg_MATNR_mtn_lp_Ygain	Gain to MotLPF_yuv[k] Luma channel for motion
//    calculation, normalized to 32 as 1 `define NR2_MATNR_DEGHOST           8'h6e
//    //Bit 8,	reg_MATNR_DeGhost_En	Enable signal for DeGhost function:0: disable; 1: enable
//    //Bit 7:4,	reg_MATNR_DeGhost_COS	DeGhost Overshoot margin for UV channel, (X2 to
//    u10 scale)
//    //Bit 3:0,	reg_MATNR_DeGhost_YOS	DeGhost Overshoot margin for Luma channel, (X2 to
//    u10 scale)
//
//    `define NR2_MATNR_ALPHALP_LUT0      8'h6f
//    //Bit 31:24,	reg_MATNR_AlphaLP_LUT_3	    Matnr low-pass filter alpha LUT node 3
//    //Bit 23:16,	reg_MATNR_AlphaLP_LUT_2	    Matnr low-pass filter alpha LUT node 2
//    //Bit 15: 8,	reg_MATNR_AlphaLP_LUT_1	    Matnr low-pass filter alpha LUT node 1
//    //Bit  7: 0,	reg_MATNR_AlphaLP_LUT_0	    Matnr low-pass filter alpha LUT node 0
//    `define NR2_MATNR_ALPHALP_LUT1      8'h70
//    //Bit 31:24,	reg_MATNR_AlphaLP_LUT_7	    Matnr low-pass filter alpha LUT node 7
//    //Bit 23:16,	reg_MATNR_AlphaLP_LUT_6	    Matnr low-pass filter alpha LUT node 6
//    //Bit 15: 8,	reg_MATNR_AlphaLP_LUT_5	    Matnr low-pass filter alpha LUT node 5
//    //Bit  7: 0,	reg_MATNR_AlphaLP_LUT_4	    Matnr low-pass filter alpha LUT node 4
//    `define NR2_MATNR_ALPHALP_LUT2      8'h71
//    //Bit 31:24,	reg_MATNR_AlphaLP_LUT_11	Matnr low-pass filter alpha LUT node 11
//    //Bit 23:16,	reg_MATNR_AlphaLP_LUT_10	Matnr low-pass filter alpha LUT node 10
//    //Bit 15: 8,	reg_MATNR_AlphaLP_LUT_9	    Matnr low-pass filter alpha LUT node 9
//    //Bit  7: 0,	reg_MATNR_AlphaLP_LUT_8	    Matnr low-pass filter alpha LUT node 8
//    `define NR2_MATNR_ALPHALP_LUT3      8'h72
//    //Bit 31:24,	reg_MATNR_AlphaLP_LUT_15	Matnr low-pass filter alpha LUT node 15
//    //Bit 23:16,	reg_MATNR_AlphaLP_LUT_14	Matnr low-pass filter alpha LUT node 14
//    //Bit 15: 8,	reg_MATNR_AlphaLP_LUT_13	Matnr low-pass filter alpha LUT node 13
//    //Bit  7: 0,	reg_MATNR_AlphaLP_LUT_12	Matnr low-pass filter alpha LUT node 12
//    `define NR2_MATNR_ALPHAHP_LUT0      8'h73
//    //Bit 31:24,	reg_MATNR_AlphaHP_LUT_3	    Matnr high-pass filter alpha LUT node 3
//    //Bit 23:16,	reg_MATNR_AlphaHP_LUT_2	    Matnr high-pass filter alpha LUT node 2
//    //Bit 15: 8,	reg_MATNR_AlphaHP_LUT_1	    Matnr high-pass filter alpha LUT node 1
//    //Bit  7: 0,	reg_MATNR_AlphaHP_LUT_0	    Matnr high-pass filter alpha LUT node 0
//    `define NR2_MATNR_ALPHAHP_LUT1      8'h74
//    //Bit 31:24,	reg_MATNR_AlphaHP_LUT_7	    Matnr high-pass filter alpha LUT node 7
//    //Bit 23:16,	reg_MATNR_AlphaHP_LUT_6	    Matnr high-pass filter alpha LUT node 6
//    //Bit 15: 8,	reg_MATNR_AlphaHP_LUT_5	    Matnr high-pass filter alpha LUT node 5
//    //Bit  7: 0,	reg_MATNR_AlphaHP_LUT_4	    Matnr high-pass filter alpha LUT node 4
//    `define NR2_MATNR_ALPHAHP_LUT2      8'h75
//    //Bit 31:24,	reg_MATNR_AlphaHP_LUT_11	Matnr high-pass filter alpha LUT node 11
//    //Bit 23:16,	reg_MATNR_AlphaHP_LUT_10	Matnr high-pass filter alpha LUT node 10
//    //Bit 15: 8,	reg_MATNR_AlphaHP_LUT_9	    Matnr high-pass filter alpha LUT node 9
//    //Bit  7: 0,	reg_MATNR_AlphaHP_LUT_8	    Matnr high-pass filter alpha LUT node 8
//    `define NR2_MATNR_ALPHAHP_LUT3      8'h76
//    //Bit 31:24,	reg_MATNR_AlphaHP_LUT_15	Matnr high-pass filter alpha LUT node 15
//    //Bit 23:16,	reg_MATNR_AlphaHP_LUT_14	Matnr high-pass filter alpha LUT node 14
//    //Bit 15: 8,	reg_MATNR_AlphaHP_LUT_13	Matnr high-pass filter alpha LUT node 13
//    //Bit  7: 0,	reg_MATNR_AlphaHP_LUT_12	Matnr high-pass filter alpha LUT node 12
//
//    `define NR2_MATNR_MTNB_BRT          8'h77
//    //Bit 31:28,	reg_MATNR_mtnb_BRT_limt_hi	Motion adjustment based on Brightness high
//    side Limit. (X16 to u8 scale)
//    //Bit 27:24,	reg_MATNR_mtnb_BRT_slop_hi	Motion adjustment based on Brightness high
//    side slope. Normalized to 16 as 1
//    //Bit 23:16,	reg_MATNR_mtnb_BRT_thrd_hi	Motion adjustment based on Brightness high
//    threshold.(u8 scale)
//    //Bit 15:12,	reg_MATNR_mtnb_BRT_limt_lo	Motion adjustment based on Brightness low
//    side Limit. (X16 to u8 scale)
//    //Bit 11: 8,	reg_MATNR_mtnb_BRT_slop_lo	Motion adjustment based on Brightness low
//    side slope. Normalized to 16 as 1
//    //Bit  7: 0,	reg_MATNR_mtnb_BRT_thrd_lo	Motion adjustment based on Brightness low
//    threshold.(u8 scale)
// 0x51 - 0x69 | 0x4e | 0x6a - 0x77
//
// Reading file:  vpu_nr2_regs.h
//
// synopsys translate_off
// synopsys translate_on
//========== nr2_snr_regs register begin ==========//
#define NR2_SNR_SAD_CFG ((0x1751 << 2) + 0xff900000)
// Bit 31:13        reserved
// Bit 12           reg_matnr_snr_sad_cenrpl       // unsigned , default = 1
// Bit 11: 8        reg_matnr_snr_sad_coring       // unsigned , default = 3
// Bit  7            reserved
// Bit  6: 5        reg_matnr_snr_sad_winmod       // unsigned , default = 1     0: 1x1; 1: [1 1
// 1] 2: [1 2 1]; 3: [1 2 2 2 1]; Bit  4: 0        sad_coef_num                      // unsigned ,
// default = 1     0: 1x1; 1: [1 1 1] 2: [1 2 1]; 3: [1 2 2 2 1];
#define NR2_MATNR_SNR_OS ((0x1752 << 2) + 0xff900000)
// Bit 31: 8        reserved
// Bit  7: 4        reg_matnr_snr_cos              // unsigned , default = 8
// Bit  3: 0        reg_matnr_snr_yos              // unsigned , default = 13
#define NR2_MATNR_SNR_NRM_CFG ((0x1753 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_matnr_snr_nrm_ofst         // signed , default = 64
// Bit 15: 8        reg_matnr_snr_nrm_max          // unsigned , default = 255
// Bit  7: 0        reg_matnr_snr_nrm_min          // unsigned , default = 0
#define NR2_MATNR_SNR_NRM_GAIN ((0x1754 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15: 8        reg_matnr_snr_nrm_cgain        // unsigned , default = 0     norm 32
// Bit  7: 0        reg_matnr_snr_nrm_ygain        // unsigned , default = 32    norm 32
#define NR2_MATNR_SNR_LPF_CFG ((0x1755 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_matnr_snrlpf_sadmaxth      // unsigned , default = 12
// Bit 15:14        reserved
// Bit 13:11        reg_matnr_snrlpf_cmode         // unsigned , default = 2     0: gradient LPF
// [1 1]/2, 1: gradient LPF [2 1 1]/4; 2: gradient LPF [3 3 2]/8; 3: gradient LPF [5 5 4 3]/16;
// Bit 10: 8        reg_matnr_snrlpf_ymode         // unsigned , default = 2     0: gradient LPF
// [1 1]/2, 1: gradient LPF [2 1 1]/4; 2: gradient LPF [3 3 2]/8; 3: gradient LPF [5 5 4 3]/16;
// Bit 7: 4        reg_matnr_snrlpf_sadmin3th     // unsigned , default = 6     X8 Bit  3: 0
// reg_matnr_snrlpf_sadmin2th     // unsigned , default = 4     X8
#define NR2_MATNR_SNR_USF_GAIN ((0x1756 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15: 8        reg_matnr_snr_usf_cgain        // unsigned , default = 0     norm 64
// Bit  7: 0        reg_matnr_snr_usf_ygain        // unsigned , default = 0     norm 64
#define NR2_MATNR_SNR_EDGE2B ((0x1757 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15: 8        reg_matnr_snr_edge2beta_ofst   // unsigned , default = 128
// Bit  7: 0        reg_matnr_snr_edge2beta_gain   // unsigned , default = 16
#define NR2_MATNR_BETA_EGAIN ((0x1758 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15: 8        reg_matnr_cbeta_egain          // unsigned , default = 32    normalized to 32
// Bit  7: 0        reg_matnr_ybeta_egain          // unsigned , default = 32    normalized to 32
#define NR2_MATNR_BETA_BRT ((0x1759 << 2) + 0xff900000)
// Bit 31:28        reg_matnr_beta_brt_limt_hi     // unsigned , default = 0
// Bit 27:24        reg_matnr_beta_brt_slop_hi     // unsigned , default = 0
// Bit 23:16        reg_matnr_beta_brt_thrd_hi     // unsigned , default = 160
// Bit 15:12        reg_matnr_beta_brt_limt_lo     // unsigned , default = 6
// Bit 11: 8        reg_matnr_beta_brt_slop_lo     // unsigned , default = 6
// Bit  7: 0        reg_matnr_beta_brt_thrd_lo     // unsigned , default = 100
#define NR2_MATNR_XBETA_CFG ((0x175a << 2) + 0xff900000)
// Bit 31:20        reserved
// Bit 19:18        reg_matnr_cbeta_use_mode       // unsigned , default = 0     0: beta_motion;
// 1: beta_edge; 2: min(beta_mot,beta_edge); 3: (beta_mot + beta_edge)/2 Bit 17:16
// reg_matnr_ybeta_use_mode       // unsigned , default = 0     0: beta_motion; 1: beta_edge; 2:
// min(beta_mot,beta_edge); 3: (beta_mot + beta_edge)/2; Bit 15: 8        reg_matnr_cbeta_ofst //
// unsigned , default = 0 Bit  7: 0        reg_matnr_ybeta_ofst           // unsigned , default =
// 0
#define NR2_MATNR_YBETA_SCL ((0x175b << 2) + 0xff900000)
// Bit 31:24        reg_matnr_ybeta_scale_min      // unsigned , default = 60
// Bit 23:16        reg_matnr_ybeta_scale_max      // unsigned , default = 255
// Bit 15: 8        reg_matnr_ybeta_scale_gain     // unsigned , default = 32    normalized 32
// to 1.0 Bit  7: 0        reg_matnr_ybeta_scale_ofst     // signed , default = 0
#define NR2_MATNR_CBETA_SCL ((0x175c << 2) + 0xff900000)
// Bit 31:24        reg_matnr_cbeta_scale_min      // unsigned , default = 0
// Bit 23:16        reg_matnr_cbeta_scale_max      // unsigned , default = 255
// Bit 15: 8        reg_matnr_cbeta_scale_gain     // unsigned , default = 32    normalized 32
// to 1.0 Bit  7: 0        reg_matnr_cbeta_scale_ofst     // signed , default = 0
#define NR2_SNR_MASK ((0x175d << 2) + 0xff900000)
// Bit 31:21        reserved
// Bit 20: 0        sad_msk                        // unsigned , default = 0x0f9f3e
#define NR2_SAD2NORM_LUT0 ((0x175e << 2) + 0xff900000)
// Bit 31:24        reg_matnr_sad2norm_lut3      // unsigned , default = 114
// Bit 23:16        reg_matnr_sad2norm_lut2      // unsigned , default = 146
// Bit 15: 8        reg_matnr_sad2norm_lut1      // unsigned , default = 171
// Bit  7: 0        reg_matnr_sad2norm_lut0      // unsigned , default = 205
#define NR2_SAD2NORM_LUT1 ((0x175f << 2) + 0xff900000)
// Bit 31:24        reg_matnr_sad2norm_lut7      // unsigned , default = 28
// Bit 23:16        reg_matnr_sad2norm_lut6      // unsigned , default = 35
// Bit 15: 8        reg_matnr_sad2norm_lut5      // unsigned , default = 49
// Bit  7: 0        reg_matnr_sad2norm_lut4      // unsigned , default = 79
#define NR2_SAD2NORM_LUT2 ((0x1760 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_sad2norm_lut11     // unsigned , default = 15
// Bit 23:16        reg_matnr_sad2norm_lut10     // unsigned , default = 17
// Bit 15: 8        reg_matnr_sad2norm_lut9      // unsigned , default = 19
// Bit  7: 0        reg_matnr_sad2norm_lut8      // unsigned , default = 23
#define NR2_SAD2NORM_LUT3 ((0x1761 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_sad2norm_lut15     // unsigned , default = 8
// Bit 23:16        reg_matnr_sad2norm_lut14     // unsigned , default = 9
// Bit 15: 8        reg_matnr_sad2norm_lut13     // unsigned , default = 10
// Bit  7: 0        reg_matnr_sad2norm_lut12     // unsigned , default = 12
#define NR2_EDGE2BETA_LUT0 ((0x1762 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_edge2beta_lut3    // unsigned , default = 128
// Bit 23:16        reg_matnr_edge2beta_lut2    // unsigned , default = 160
// Bit 15: 8        reg_matnr_edge2beta_lut1    // unsigned , default = 224
// Bit  7: 0        reg_matnr_edge2beta_lut0    // unsigned , default = 255
#define NR2_EDGE2BETA_LUT1 ((0x1763 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_edge2beta_lut7    // unsigned , default = 4
// Bit 23:16        reg_matnr_edge2beta_lut6    // unsigned , default = 16
// Bit 15: 8        reg_matnr_edge2beta_lut5    // unsigned , default = 32
// Bit  7: 0        reg_matnr_edge2beta_lut4    // unsigned , default = 80
#define NR2_EDGE2BETA_LUT2 ((0x1764 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_edge2beta_lut11    // unsigned , default = 0
// Bit 23:16        reg_matnr_edge2beta_lut10    // unsigned , default = 0
// Bit 15: 8        reg_matnr_edge2beta_lut9    // unsigned , default = 0
// Bit  7: 0        reg_matnr_edge2beta_lut8    // unsigned , default = 2
#define NR2_EDGE2BETA_LUT3 ((0x1765 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_edge2beta_lut15    // unsigned , default = 0
// Bit 23:16        reg_matnr_edge2beta_lut14    // unsigned , default = 0
// Bit 15: 8        reg_matnr_edge2beta_lut13    // unsigned , default = 0
// Bit  7: 0        reg_matnr_edge2beta_lut12    // unsigned , default = 0
#define NR2_MOTION2BETA_LUT0 ((0x1766 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_mot2beta_lut3     // unsigned , default = 32
// Bit 23:16        reg_matnr_mot2beta_lut2     // unsigned , default = 16
// Bit 15: 8        reg_matnr_mot2beta_lut1     // unsigned , default = 4
// Bit  7: 0        reg_matnr_mot2beta_lut0     // unsigned , default = 0
#define NR2_MOTION2BETA_LUT1 ((0x1767 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_mot2beta_lut7     // unsigned , default = 196
// Bit 23:16        reg_matnr_mot2beta_lut6     // unsigned , default = 128
// Bit 15: 8        reg_matnr_mot2beta_lut5     // unsigned , default = 64
// Bit  7: 0        reg_matnr_mot2beta_lut4     // unsigned , default = 48
#define NR2_MOTION2BETA_LUT2 ((0x1768 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_mot2beta_lut11     // unsigned , default = 255
// Bit 23:16        reg_matnr_mot2beta_lut10     // unsigned , default = 255
// Bit 15: 8        reg_matnr_mot2beta_lut9     // unsigned , default = 240
// Bit  7: 0        reg_matnr_mot2beta_lut8     // unsigned , default = 224
#define NR2_MOTION2BETA_LUT3 ((0x1769 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_mot2beta_lut15     // unsigned , default = 255
// Bit 23:16        reg_matnr_mot2beta_lut14     // unsigned , default = 255
// Bit 15: 8        reg_matnr_mot2beta_lut13     // unsigned , default = 255
// Bit  7: 0        reg_matnr_mot2beta_lut12     // unsigned , default = 255
//========== nr2_snr_regs register end ==========//
//========== nr2_tnr_regs register begin ==========//
#define NR2_IIR_CTRL ((0x174e << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15:14        reg_lp_iir_8bit_mode      // unsigned , default = 0  10bits; 1: 9bits; 2:
// 8bits 3: 7bits Bit 13:12        reg_hp_iir_mute_mode      // unsigned , default = 0 Bit 11: 8
// reg_hp_iir_mute_thrd      // unsigned , default = 0 Bit  7: 6        reg_hp_iir_8bit_mode //
// unsigned , default = 0 Bit  5: 4        reg_lp_iir_mute_mode      // unsigned , default = 0 Bit
// 3: 0        reg_lp_iir_mute_thrd      // unsigned , default = 0
#define NR2_MATNR_MTN_CRTL ((0x176a << 2) + 0xff900000)
// Bit 31:20        reserved
// Bit 19:18        reg_matnr_vmtn_use_mode   // unsigned , default = 0  0- Vmot, 1- Ymot/2 +
// (Umot+Vmot)/4; 2- Ymot/2 + max(Umot,Vmot)/2; 3- max(Ymot,Umot, Vmot) Bit 17:16
// reg_matnr_umtn_use_mode   // unsigned , default = 0  0- Umot, 1- Ymot/2 + (Umot+Vmot)/4; 2-
// Ymot/2 + max(Umot,Vmot)/2; 3- max(Ymot,Umot, Vmot) Bit 15:14        reg_matnr_ymtn_use_mode //
// unsigned , default = 0  0- Ymot, 1- Ymot/2 + (Umot+Vmot)/4; 2- Ymot/2 + max(Umot,Vmot)/2; 3-
// max(Ymot,Umot, Vmot) Bit 13:12        reg_matnr_mtn_txt_mode    // unsigned , default = 1 Bit
// 11 reserved Bit 10: 8        reg_matnr_mtn_cor_mode    // unsigned , default = 1  changes) Bit
// 7: 4        reg_matnr_mtn_hpf_mode    // unsigned , default = 8  extend to u4 for nr4, 0- 1x1;
// 1: 1x3; 2: 1x5; 3: 3x3; 4: 3o3; 5: 3x5, 6:3x3 SAD, 7: 5x3 SAD, 8-15: drt adaptive Bit  3
// reserved Bit  2: 0        reg_matnr_mtn_lpf_mode    // unsigned , default = 6  0- 1x1; 1: 1x3;
// 2: 1x5; 3: 3x3; 4: 3o3; 5: 3x5, 6,7: drt adaptive
#define NR2_MATNR_MTN_CRTL2 ((0x176b << 2) + 0xff900000)
// Bit 31:19        reserved
// Bit 18:16        reg_matnr_iir_bs_ymode      // unsigned , default = 6  LPF~~ 0- 1x1; 1: 1x3;
// 2: 1x5; 3: 3x3; 4: 3o3; 5: 3x5; 6/7: 0 Bit 15: 8        reg_matnr_mtnb_alplp_cgain  // unsigned
// , default = 64  to 32 Bit  7: 0        reg_matnr_mtnb_alplp_ygain  // unsigned , default = 64
// to 32
#define NR2_MATNR_MTN_COR ((0x176c << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15:12        reg_matnr_mtn_cor_cofst   // unsigned , default = 3  Offset for Chroma Motion.
// Bit 11: 8        reg_matnr_mtn_cor_cgain   // unsigned , default = 3  to texture based coring
// for Chroma Motion. Normalized to 16 as 1 Bit  7: 4        reg_matnr_mtn_cor_yofst   // unsigned
// , default = 3  Offset for Luma Motion. Bit  3: 0        reg_matnr_mtn_cor_ygain   // unsigned ,
// default = 3  to texture based coring for Luma Motion. Normalized to 16 as 1
#define NR2_MATNR_MTN_GAIN ((0x176d << 2) + 0xff900000)
// Bit 31:24        reg_matnr_mtn_hp_cgain    // unsigned , default = 64  to MotHPF_yuv[k] Chrm
// channel for motion calculation, normalized to 64 as 1 Bit 23:16        reg_matnr_mtn_hp_ygain
// // unsigned , default = 64  to MotHPF_yuv[k] Luma channel for motion calculation, normalized to
// 64 as 1 Bit 15: 8        reg_matnr_mtn_lp_cgain    // unsigned , default = 64  to MotLPF_yuv[k]
// Chrm channel for motion calculation, normalized to 32 as 1 Bit  7: 0 reg_matnr_mtn_lp_ygain //
// unsigned , default = 64  to MotLPF_yuv[k] Luma channel for motion calculation, normalized to 32
// as 1
#define NR2_MATNR_DEGHOST ((0x176e << 2) + 0xff900000)
// Bit 31            reserved
// Bit 30:28        reg_matnr_deghost_mode    // unsigned , default = 0  0:old_deghost;
// 1:soft_denoise & strong_deghost; 2:strong_denoise & soft_deghost; 3:strong_denoise &
// strong_deghost Bit 27:25        reserved Bit 24:20        reg_matnr_deghost_ygain   // unsigned
// , default = 4 Bit 19:17        reserved Bit 16:12        reg_matnr_deghost_cgain   // unsigned
// , default = 4 Bit 11: 9        reserved Bit  8           reg_matnr_deghost_en      // unsigned
// , default = 1  Enable signal for DeGhost function:0: disable; 1: enable Bit  7: 4
// reg_matnr_deghost_cos     // unsigned , default = 3  DeGhost Overshoot margin for UV channel,
// (X2 to u10 scale) Bit  3: 0        reg_matnr_deghost_yos     // unsigned , default = 3  DeGhost
// Overshoot margin for Luma channel, (X2 to u10 scale)
#define NR2_MATNR_ALPHALP_LUT0 ((0x176f << 2) + 0xff900000)
// Bit 31:24        reg_matnr_alphalp_lut3    // unsigned , default = 64  low-pass filter alpha
// LUT Bit 23:16        reg_matnr_alphalp_lut2    // unsigned , default = 128  low-pass filter
// alpha LUT Bit 15: 8        reg_matnr_alphalp_lut1    // unsigned , default = 128  low-pass
// filter alpha LUT Bit  7: 0        reg_matnr_alphalp_lut0    // unsigned , default = 128
// low-pass filter alpha LUT
#define NR2_MATNR_ALPHALP_LUT1 ((0x1770 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_alphalp_lut7    // unsigned , default = 255  low-pass filter alpha
// LUT Bit 23:16        reg_matnr_alphalp_lut6    // unsigned , default = 128  low-pass filter
// alpha LUT Bit 15: 8        reg_matnr_alphalp_lut5    // unsigned , default = 80  low-pass
// filter alpha LUT Bit  7: 0        reg_matnr_alphalp_lut4    // unsigned , default = 64 low-pass
// filter alpha LUT
#define NR2_MATNR_ALPHALP_LUT2 ((0x1771 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_alphalp_lut11   // unsigned , default = 255  low-pass filter alpha
// LUT Bit 23:16        reg_matnr_alphalp_lut10   // unsigned , default = 255  low-pass filter
// alpha LUT Bit 15: 8        reg_matnr_alphalp_lut9    // unsigned , default = 255  low-pass
// filter alpha LUT Bit  7: 0        reg_matnr_alphalp_lut8    // unsigned , default = 255
// low-pass filter alpha LUT
#define NR2_MATNR_ALPHALP_LUT3 ((0x1772 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_alphalp_lut15   // unsigned , default = 255  low-pass filter alpha
// LUT Bit 23:16        reg_matnr_alphalp_lut14   // unsigned , default = 255  low-pass filter
// alpha LUT Bit 15: 8        reg_matnr_alphalp_lut13   // unsigned , default = 255  low-pass
// filter alpha LUT Bit  7: 0        reg_matnr_alphalp_lut12   // unsigned , default = 255
// low-pass filter alpha LUT
#define NR2_MATNR_ALPHAHP_LUT0 ((0x1773 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_alphahp_lut3    // unsigned , default = 64  high-pass filter alpha
// LUT Bit 23:16        reg_matnr_alphahp_lut2    // unsigned , default = 128  high-pass filter
// alpha LUT Bit 15: 8        reg_matnr_alphahp_lut1    // unsigned , default = 128  high-pass
// filter alpha LUT Bit  7: 0        reg_matnr_alphahp_lut0    // unsigned , default = 128
// high-pass filter alpha LUT
#define NR2_MATNR_ALPHAHP_LUT1 ((0x1774 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_alphahp_lut7    // unsigned , default = 255  high-pass filter alpha
// LUT Bit 23:16        reg_matnr_alphahp_lut6    // unsigned , default = 128  high-pass filter
// alpha LUT Bit 15: 8        reg_matnr_alphahp_lut5    // unsigned , default = 80  high-pass
// filter alpha LUT Bit  7: 0        reg_matnr_alphahp_lut4    // unsigned , default = 64
// high-pass filter alpha LUT
#define NR2_MATNR_ALPHAHP_LUT2 ((0x1775 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_alphahp_lut11   // unsigned , default = 255  high-pass filter alpha
// LUT Bit 23:16        reg_matnr_alphahp_lut10   // unsigned , default = 255  high-pass filter
// alpha LUT Bit 15: 8        reg_matnr_alphahp_lut9    // unsigned , default = 255  high-pass
// filter alpha LUT Bit  7: 0        reg_matnr_alphahp_lut8    // unsigned , default = 255
// high-pass filter alpha LUT
#define NR2_MATNR_ALPHAHP_LUT3 ((0x1776 << 2) + 0xff900000)
// Bit 31:24        reg_matnr_alphahp_lut15   // unsigned , default = 255  high-pass filter alpha
// LUT Bit 23:16        reg_matnr_alphahp_lut14   // unsigned , default = 255  high-pass filter
// alpha LUT Bit 15: 8        reg_matnr_alphahp_lut13   // unsigned , default = 255  high-pass
// filter alpha LUT Bit  7: 0        reg_matnr_alphahp_lut12   // unsigned , default = 255
// high-pass filter alpha LUT
#define NR2_MATNR_MTNB_BRT ((0x1777 << 2) + 0xff900000)
// Bit 31:28        reg_matnr_mtnb_brt_limt_hi  // unsigned , default = 0
// Bit 27:24        reg_matnr_mtnb_brt_slop_hi  // unsigned , default = 0
// Bit 23:16        reg_matnr_mtnb_brt_thrd_hi  // unsigned , default = 160
// Bit 15:12        reg_matnr_mtnb_brt_limt_lo  // unsigned , default = 6
// Bit 11: 8        reg_matnr_mtnb_brt_slop_lo  // unsigned , default = 6
// Bit  7: 0        reg_matnr_mtnb_brt_thrd_lo  // unsigned , default = 100
//========== nr2_tnr_regs register end ==========//
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpu_nr2_regs.h
//
//
// Reading file:  nr2_cue_regs.h
//
// synopsys translate_off
// synopsys translate_on
#define NR2_CUE_MODE ((0x1778 << 2) + 0xff900000)
// Bit 31:20        reserved
// Bit 19           reg_cue2_isabv_org_invert1  // unsigned , default = 0
// Bit 18           reg_cue2_valid_condition    // unsigned , default = 1
// Bit 17:16        reg_cue2_orgline_flt_sel    // unsigned , default = 1
// Bit 15:12        reg_cue2_orgline_flt_alph   // unsigned , default = 4
// Bit 11           reg_cue2_isabv_org_invert   // unsigned , default = 0
// Bit 10           reg_cue2_iscur_org_invert   // unsigned , default = 0
// Bit  9           reg_cue_enable_r	          // unsigned , default = 1  right half frame
// enable Bit  8           reg_cue_enable_l            // unsigned , default = 1  left half frame
// enable Bit  7            reserved Bit  6: 4        reg_cue_con_rplc_mode       // unsigned ,
// default = 7  pixel chroma replace mode; Bit  3: 0        reg_cue_chrm_flt_mode       //
// unsigned , default = 5  improvement filter mode,
#define NR2_CUE_CON_MOT_TH ((0x1779 << 2) + 0xff900000)
// Bit 31:24        reg_cue_con_cmot_thrd2	   // unsigned , default = 20  Detection threshold
// of up/down two rows,  Chroma channel in Chroma Up-sampling Error (CUE) Detection (tighter). Bit
// 23:16        reg_cue_con_ymot_thrd2	   // unsigned , default = 20  Detection threshold of
// up/mid/down three rows,  Luma channel in Chroma Up-sampling Error (CUE) Detection (tighter).
// Bit
// 15: 8        reg_cue_con_cmot_thrd	      // unsigned , default = 20  Detection threshold of
// up/down two rows, Chroma channel in Chroma Up-sampling Error (CUE) Detection. Bit  7: 0
// reg_cue_con_ymot_thrd	      // unsigned , default = 20  Detection threshold of up/mid/down
// three rows, Luma channel in Chroma Up-sampling Error (CUE) Detection.
#define NR2_CUE_CON_DIF0 ((0x177a << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15: 8        reg_cue_con_difp1_thrd	   // unsigned , default = 20  field Intra-Field
// top/below line chroma difference threshold, Bit  7: 0        reg_cue_con_difcur_thrd	  //
// unsigned , default = 0  Field/Frame Intra-Field up/down line chroma difference threshold,
#define NR2_CUE_CON_DIF1 ((0x177b << 2) + 0xff900000)
// Bit 31:20        reserved
// Bit 19:16        reg_cue_con_rate0	         // unsigned , default = 8  Krate to decide CUE by
// relationship between CUE_diflG and CUE_difEG Bit 15: 8        reg_cue_con_difeg_thrd	   //
// unsigned , default = 0  to the difference between current Field/Frame middle line to down line
// color channel(CUE_difEG). Bit  7: 0        reg_cue_con_diflg_thrd	   // unsigned , default =
// 100  to the difference between P1 field top line to current Field/Frame down line color channel
// (CUE_diflG).
#define NR2_CUE_CON_DIF2 ((0x177c << 2) + 0xff900000)
// Bit 31:20        reserved
// Bit 19:16        reg_cue_con_rate1	        // unsigned , default = 8  Krate to decide CUE by
// relationship between CUE_difnC and CUE_difEC Bit 15: 8        reg_cue_con_difec_thrd    //
// unsigned , default = 0  to the difference between current Field/Frame middle line to up line
// color channel(CUE_difEC). Bit  7: 0        reg_cue_con_difnc_thrd    // unsigned , default =
// 100 to the difference between P1 field bot line to current Field/Frame up line color channel
// (CUE_difnC).
#define NR2_CUE_CON_DIF3 ((0x177d << 2) + 0xff900000)
// Bit 31:20        reserved
// Bit 19:16        reg_cue_con_rate2	        // unsigned , default = 8  Krate to decide CUE by
// relationship between CUE_difP1 and CUE_difEP1 Bit 15: 8        reg_cue_con_difep1_thrd   //
// unsigned , default = 10  top/below line to current field/frame middle line chroma difference
// (CUE_difEP1) threshold. Bit  7: 0        reg_cue_con_difp1_thrd2   // unsigned , default = 10
// field Intra-Field top/below line chroma difference threshold (tighter),
#define NR2_CUE_PRG_DIF ((0x177e << 2) + 0xff900000)
// Bit 31:21        reserved
// Bit 20           reg_cue_prg_enable	       // unsigned , default = 0  bit for progressive
// video CUE detection.If interlace input video, Bit 19:16        reg_cue_prg_rate
// // unsigned , default = 4  Krate to decide CUE by relationship between CUE_difCur and
// (CUE_difEC+CUE_difEG) Bit 15: 8        reg_cue_prg_difceg_thrd   // unsigned , default = 40
// Frame Intra-Field up-mid and mid-down line chroma difference threshold for progressive video
// CUE detection, Bit  7: 0        reg_cue_prg_difcur_thrd   // unsigned , default = 30  Frame
// Intra-Field up/down line chroma difference threshold,
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  nr2_cue_regs.h
//
#define NR2_CONV_MODE ((0x177f << 2) + 0xff900000)
// Bit 3:2,	Conv_c444_mode	The format convert mode about 422 to 444 when data read out line
// buffer Bit 1:0,	Conv_c422_mode	the format convert mode about 444 to 422 when data write
// to line buffer
//// NR2 REG DEFINE END ////
//// DET 3D REG DEFINE BEGIN ////
//// 8'h34~8'h3f | 8'h80~8'h8f | 0x9a-0x9b
//
// Reading file:  vpu_det3d_regs.h
//
//// DET 3D REG DEFINE BEGIN ////
//// 8'h34~8'h3f
//// DET 3D REG DEFINE END ////
#define DET3D_MOTN_CFG ((0x1734 << 2) + 0xff900000)
// Bit 16,	reg_det3d_intr_en	        Det3d interrupt enable
// Bit 9:8,	reg_Det3D_Motion_Mode	    U2  Different mode for Motion Calculation of Luma and
// Chroma:
//                                      0: MotY, 1: (2*MotY + (MotU + MotV))/4; 2: Max(MotY,
//                                      MotU,MotV); 3:Max(MotY, (MotU+MotV)/2)
// Bit 7:4,	reg_Det3D_Motion_Core_Rate	U4  K Rate to Edge (HV) details for coring of
// Motion Calculations, normalized to 32 Bit 3:0,	reg_Det3D_Motion_Core_Thrd	U4  2X:
// static coring value for Motion Detection.
#define DET3D_CB_CFG ((0x1735 << 2) + 0xff900000)
// Bit 7:4,	reg_Det3D_ChessBd_HV_ofst	U4,  Noise immune offset for Horizotnal or
// vertical combing detection. Bit 3:0,	reg_Det3D_ChessBd_NHV_ofst	U4,  Noise immune offset
// for NON-Horizotnal or vertical combing detection.
#define DET3D_SPLT_CFG ((0x1736 << 2) + 0xff900000)
// Bit 7:4,	reg_Det3D_SplitValid_ratio	U4,  Ratio between max_value and the avg_value of
// the edge mapping for split line valid detection.
//                                      The smaller of this value, the easier of the split line
//                                      detected.
// Bit 3:0,	reg_Det3D_AvgIdx_ratio	    U4,  Ratio to the avg_value of the edge mapping for
// split line position estimation.
//                                      The smaller of this value, the more samples will be added
//                                      to the estimation.
#define DET3D_HV_MUTE ((0x1737 << 2) + 0xff900000)
// Bit 23:20, reg_Det3D_Edge_Ver_Mute	U4  X2: Horizontal pixels to be mute from H/V Edge
// calculation Top and Bottom border part. Bit 19:16, reg_Det3D_Edge_Hor_Mute	U4  X2: Horizontal
// pixels to be mute from H/V Edge calculation Left and right border part. Bit 15:12,
// reg_Det3D_ChessBd_Ver_Mute	U4  X2: Horizontal pixels to be mute from ChessBoard statistics
// calculation in middle part Bit 11:8,	 reg_Det3D_ChessBd_Hor_Mute	U4  X2: Horizontal pixels
// to be mute from ChessBoard statistics calculation in middle part Bit 7:4,
// reg_Det3D_STA8X8_Ver_Mute	U4  1X: Vertical pixels to be mute from 8x8 statistics calculation
// in each block. Bit 3:0,	 reg_Det3D_STA8X8_Hor_Mute	U4  1X: Horizontal pixels to be
// mute from 8x8 statistics calculation in each block.
#define DET3D_MAT_STA_P1M1 ((0x1738 << 2) + 0xff900000)
// Bit 31:24, reg_Det3D_STA8X8_P1_K0_R8	U8  SAD to SAI ratio to decide P1, normalized to 256 (0.8)
// Bit 23:16, reg_Det3D_STA8X8_P1_K1_R7	U8  SAD to ENG ratio to decide P1, normalized to 128 (0.5)
// Bit 15:8,	 reg_Det3D_STA8X8_M1_K0_R6	U8  SAD to SAI ratio to decide M1, normalized to
// 64  (1.1) Bit 7:0,	 reg_Det3D_STA8X8_M1_K1_R6	U8  SAD to ENG ratio to decide M1,
// normalized to 64  (0.8)
#define DET3D_MAT_STA_P1TH ((0x1739 << 2) + 0xff900000)
// Bit 23:16, reg_Det3D_STAYUV_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16         (100)
// Bit 15:8,	 reg_Det3D_STAEDG_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16 (80)
// Bit 7:0,	 reg_Det3D_STAMOT_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16 (48)
#define DET3D_MAT_STA_M1TH ((0x173a << 2) + 0xff900000)
// Bit 23:16, reg_Det3D_STAYUV_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16         (100)
// Bit 15:8,	 reg_Det3D_STAEDG_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16 (80)
// Bit 7:0,	 reg_Det3D_STAMOT_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16 (64)
#define DET3D_MAT_STA_RSFT ((0x173b << 2) + 0xff900000)
// Bit 5:4,	 reg_Det3D_STAYUV_RSHFT	    U2  YUV statistics SAD and SAI calculation result
// right shift bits to accommodate the 12bits clipping:
//                                      0: mainly for images <=720x480: 1: mainly for images
//                                      <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other
//                                      higher resolutions
// Bit 3:2,	 reg_Det3D_STAEDG_RSHFT	    U2  Horizontal and Vertical Edge Statistics SAD and
// SAI calculation result right shift bits to accommodate the 12bits clipping:
//                                      0: mainly for images <=720x480: 1: mainly for images
//                                      <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other
//                                      higher resolutions
// Bit 1:0,	 reg_Det3D_STAMOT_RSHFT	    U2  Motion SAD and SAI calculation result right shift
// bits to accommodate the 12bits clipping:
//                                      0: mainly for images <=720x480: 1: mainly for images
//                                      <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other
//                                      higher resolutions
#define DET3D_MAT_SYMTC_TH ((0x173c << 2) + 0xff900000)
// Bit 31:24, reg_Det3D_STALUM_symtc_Th	  U8  threshold to decide if the Luma statistics is TB or
// LR symmetric. Bit 23:16, reg_Det3D_STACHR_symtc_Th	  U8  threshold to decide if the Chroma
// (UV) statistics is TB or LR symmetric. Bit 15:8,	 reg_Det3D_STAEDG_symtc_Th	  U8
// threshold to decide if the Horizontal and Vertical Edge statistics is TB or LR symmetric. Bit
// 7:0,	 reg_Det3D_STAMOT_symtc_Th	  U8  threshold to decide if the Motion statistics is TB
// or LR symmetric.
#define DET3D_RO_DET_CB_HOR ((0x173d << 2) + 0xff900000)
// Bit 31:16, RO_Det3D_ChessBd_NHor_value    U16  X64: number of Pixels of Horizontally Surely NOT
// matching Chessboard pattern.
// Bit 15:0,	 RO_Det3D_ChessBd_Hor_value	    U16  X64: number of Pixels of Horizontally
// Surely matching Chessboard pattern.
#define DET3D_RO_DET_CB_VER ((0x173e << 2) + 0xff900000)
// Bit 31:16, RO_Det3D_ChessBd_NVer_value	U16  X64: number of Pixels of Vertically Surely
// NOT matching Chessboard pattern. Bit 15:0,	 RO_Det3D_ChessBd_Ver_value	    U16  X64:
// number of Pixels of Vertically Surely matching Chessboard pattern.
#define DET3D_RO_SPLT_HT ((0x173f << 2) + 0xff900000)
// Bit 24,	 RO_Det3D_Split_HT_valid	U1  horizontal LR split border detected valid
// signal for top half picture
// Bit 20:16, RO_Det3D_Split_HT_pxnum	U5  number of pixels included for the LR split position
// estimation for top half picture
// Bit 9:0,	 RO_Det3D_Split_HT_idxX4	S10  X4: horizontal pixel shifts of LR split
// position to the (ColMax/2) for top half picture
//// DET 3D REG DEFINE BEGIN ////
////  8'h80~8'h8f
#define DET3D_RO_SPLT_HB ((0x1780 << 2) + 0xff900000)
// Bit 24,	    RO_Det3D_Split_HB_valid	    U1   horizontal LR split border detected valid
// signal for top half picture Bit 20:16,	RO_Det3D_Split_HB_pxnum	    U5   number of pixels
// included for the LR split position estimation for top half picture Bit  9: 0,
// RO_Det3D_Split_HB_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the
// (ColMax/2) for top half picture
#define DET3D_RO_SPLT_VL ((0x1781 << 2) + 0xff900000)
// Bit 24,	    RO_Det3D_Split_VL_valid	    U1   horizontal LR split border detected valid
// signal for top half picture Bit 20:16,	RO_Det3D_Split_VL_pxnum	    U5   number of pixels
// included for the LR split position estimation for top half picture Bit  9: 0,
// RO_Det3D_Split_VL_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the
// (ColMax/2) for top half picture
#define DET3D_RO_SPLT_VR ((0x1782 << 2) + 0xff900000)
// Bit 24   ,	RO_Det3D_Split_VR_valid	    U1   horizontal LR split border detected valid signal
// for top half picture
// Bit 20:16,	RO_Det3D_Split_VR_pxnum	    U5   number of pixels included for the LR split
// position estimation for top half picture Bit  9: 0,	RO_Det3D_Split_VR_idxX4	    S10  X4:
// horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
#define DET3D_RO_MAT_LUMA_LR ((0x1783 << 2) + 0xff900000)
// Bit 15:0,	RO_Luma_LR_score	 S2*8  LUMA statistics left right decision score for each
// band (8bands vertically),
//                               it can be -1/0/1:-1: most likely not LR symmetric 0: not sure 1:
//                               most likely LR symmetric
// Bit 7:0,	RO_Luma_LR_symtc	 U1*8  Luma statistics left right pure symmetric for each
// band (8bands vertically),
//                               it can be 0/1: 0: not sure 1: most likely LR is pure symmetric
// Bit 4:0,	RO_Luma_LR_sum	     S5  Total score of 8x8 Luma statistics for LR like decision,
//                               the larger this score, the more confidence that this is a LR 3D
//                               video. It is sum of  RO_Luma_LR_score[0~7]
#define DET3D_RO_MAT_LUMA_TB ((0x1784 << 2) + 0xff900000)
// Bit 15:0,	RO_Luma_TB_score	 S2*8  LUMA statistics Top/Bottom decision score for each
// band (8bands Horizontally), Bit 7:0,	RO_Luma_TB_symtc	 Luma statistics Top/Bottompure
// symmetric for each band (8bands Horizontally), Bit 4:0,	RO_Luma_TB_sum	     Total score
// of 8x8 Luma statistics for TB like decision,
#define DET3D_RO_MAT_CHRU_LR ((0x1785 << 2) + 0xff900000)
// Bit 15:0,	RO_ChrU_LR_score	S2*8  LUMA statistics left right decision score for each
// band (8bands vertically), Bit 7:0,	RO_ChrU_LR_symtc	CHRU statistics left right pure
// symmetric for each band (8bands vertically),
// Bit 4:0,	RO_ChrU_LR_sum	    Total score of 8x8 ChrU statistics for LR like decision,
#define DET3D_RO_MAT_CHRU_TB ((0x1786 << 2) + 0xff900000)
// Bit 15:0,	RO_ChrU_TB_score	S2*8  CHRU statistics Top/Bottom decision score for each
// band (8bands Horizontally) Bit 7:0,	RO_ChrU_TB_symtc	CHRU statistics Top/Bottompure
// symmetric for each band (8bands Horizontally) Bit 4:0,	RO_ChrU_TB_sum	    Total score of
// 8x8 ChrU statistics for TB like decision
#define DET3D_RO_MAT_CHRV_LR ((0x1787 << 2) + 0xff900000)
// Bit 15:0,	RO_ChrV_LR_score	S2*8  CHRUstatistics left right decision score for each
// band (8bands vertically) Bit 7:0,	RO_ChrV_LR_symtc	CHRV statistics left right pure
// symmetric for each band (8bands vertically) Bit 4:0,	RO_ChrV_LR_sum	    Total score of 8x8
// ChrV statistics for LR like decision
#define DET3D_RO_MAT_CHRV_TB ((0x1788 << 2) + 0xff900000)
// Bit 15:0,	RO_ChrV_TB_score	CHRV statistics Top/Bottom decision score for each band
// (8bands Horizontally) Bit 7:0,	RO_ChrV_TB_symtc	CHRV statistics Top/Bottompure
// symmetric for each band (8bands Horizontally) Bit 4:0,	RO_ChrV_TB_sum	    Total score of
// 8x8 ChrV statistics for TB like decision
#define DET3D_RO_MAT_HEDG_LR ((0x1789 << 2) + 0xff900000)
// Bit 15:0,	RO_Hedg_LR_score	Horizontal Edge statistics left right decision score for
// each band (8bands vertically) Bit 7:0,	RO_Hedg_LR_symtc	Horizontal Edge statistics
// left right pure symmetric for each band (8bands vertically) Bit 4:0,	RO_Hedg_LR_sum	    Total
// score of 8x8 Hedg statistics for LR like decision
#define DET3D_RO_MAT_HEDG_TB ((0x178a << 2) + 0xff900000)
// Bit 15:0,	RO_Hedg_TB_score	Horizontal Edge statistics Top/Bottom decision score for
// each band (8bands Horizontally) Bit 7:0,	RO_Hedg_TB_symtc	Horizontal Edge statistics
// Top/Bottompure symmetric for each band (8bands Horizontally) Bit 4:0,	RO_Hedg_TB_sum
// Total score of 8x8 Hedg statistics for TB like decision
#define DET3D_RO_MAT_VEDG_LR ((0x178b << 2) + 0xff900000)
// Bit 15:0,	RO_Vedg_LR_score	Vertical Edge statistics left right decision score for
// each band (8bands vertically) Bit 7:0,	RO_Vedg_LR_symtc	Vertical Edge statistics
// left right pure symmetric for each band (8bands vertically) Bit 4:0,	RO_Vedg_LR_sum	    Total
// score of 8x8 Vedg statistics for LR like decision
#define DET3D_RO_MAT_VEDG_TB ((0x178c << 2) + 0xff900000)
// Bit 15:0,	RO_Vedg_TB_score	Vertical Edge statistics Top/Bottom decision score for
// each band (8bands Horizontally) Bit 7:0,	RO_Vedg_TB_symtc	Vertical Edge statistics
// Top/Bottompure symmetric for each band (8bands Horizontally) Bit 4:0,	RO_Vedg_TB_sum
// Total score of 8x8 Vedg statistics for TB like decision
#define DET3D_RO_MAT_MOTN_LR ((0x178d << 2) + 0xff900000)
// Bit 15:0,	RO_Motn_LR_score	Motion statistics left right decision score for each band
// (8bands vertically)
// Bit 7:0,	RO_Motn_LR_symtc	Motion statistics left right pure symmetric for each band
// (8bands vertically) Bit 4:0,	RO_Motn_LR_sum	    Total score of 8x8 Motion statistics for LR
// like decision
#define DET3D_RO_MAT_MOTN_TB ((0x178e << 2) + 0xff900000)
// Bit 15:0,	RO_Motn_TB_score	Motion statistics Top/Bottom decision score for each band
// (8bands Horizontally) Bit 7:0,	RO_Motn_TB_symtc	Motion statistics Top/Bottompure
// symmetric for each band (8bands Horizontally) Bit 4:0,	RO_Motn_TB_sum	    Total score of
// 8x8 Motion statistics for TB like decision
#define DET3D_RO_FRM_MOTN ((0x178f << 2) + 0xff900000)
// Bit 15:0,	RO_Det3D_Frame_Motion	U16  frame based motion value sum for still image decision
// in FW.
/// mat ram read enter addr
#define DET3D_RAMRD_ADDR_PORT ((0x179a << 2) + 0xff900000)
#define DET3D_RAMRD_DATA_PORT ((0x179b << 2) + 0xff900000)
//
// Closing file:  vpu_det3d_regs.h
//
//   `define DET3D_RO_SPLT_HB            8'h80
//   //Bit 24,	    RO_Det3D_Split_HB_valid	    U1   horizontal LR split border detected valid
//   signal for top half picture
//   //Bit 20:16,	RO_Det3D_Split_HB_pxnum	    U5   number of pixels included for the LR
//   split position estimation for top half picture
//   //Bit  9: 0,	RO_Det3D_Split_HB_idxX4	    S10  X4: horizontal pixel shifts of LR split
//   position to the (ColMax/2) for top half picture `define DET3D_RO_SPLT_VL            8'h81
//   //Bit 24,	    RO_Det3D_Split_VL_valid	    U1   horizontal LR split border detected valid
//   signal for top half picture
//   //Bit 20:16,	RO_Det3D_Split_VL_pxnum	    U5   number of pixels included for the LR
//   split position estimation for top half picture
//   //Bit  9: 0,	RO_Det3D_Split_VL_idxX4	    S10  X4: horizontal pixel shifts of LR split
//   position to the (ColMax/2) for top half picture `define DET3D_RO_SPLT_VR            8'h82
//   //Bit 24   ,	RO_Det3D_Split_VR_valid	    U1   horizontal LR split border detected valid
//   signal for top half picture
//   //Bit 20:16,	RO_Det3D_Split_VR_pxnum	    U5   number of pixels included for the LR
//   split position estimation for top half picture
//   //Bit  9: 0,	RO_Det3D_Split_VR_idxX4	    S10  X4: horizontal pixel shifts of LR split
//   position to the (ColMax/2) for top half picture `define DET3D_RO_MAT_LUMA_LR        8'h83
//   //Bit 15:0,	RO_Luma_LR_score	 S2*8  LUMA statistics left right decision score for
//   each band (8bands vertically),
//   //                               it can be -1/0/1:-1: most likely not LR symmetric 0: not
//   sure 1: most likely LR symmetric
//   //Bit 7:0,	RO_Luma_LR_symtc	 U1*8  Luma statistics left right pure symmetric for each
//   band (8bands vertically),
//   //                               it can be 0/1: 0: not sure 1: most likely LR is pure
//   symmetric
//   //Bit 4:0,	RO_Luma_LR_sum	     S5  Total score of 8x8 Luma statistics for LR like decision,
//   //                               the larger this score, the more confidence that this is a LR
//   3D video. It is sum of  RO_Luma_LR_score[0~7] `define DET3D_RO_MAT_LUMA_TB        8'h84
//   //Bit 15:0,	RO_Luma_TB_score	 S2*8  LUMA statistics Top/Bottom decision score for
//   each band (8bands Horizontally),
//   //Bit 7:0,	RO_Luma_TB_symtc	 Luma statistics Top/Bottompure symmetric for each band
//   (8bands Horizontally),
//   //Bit 4:0,	RO_Luma_TB_sum	     Total score of 8x8 Luma statistics for TB like decision,
//   `define DET3D_RO_MAT_CHRU_LR        8'h85
//   //Bit 15:0,	RO_ChrU_LR_score	S2*8  LUMA statistics left right decision score for
//   each band (8bands vertically),
//   //Bit 7:0,	RO_ChrU_LR_symtc	CHRU statistics left right pure symmetric for each band
//   (8bands vertically),
//   //Bit 4:0,	RO_ChrU_LR_sum	    Total score of 8x8 ChrU statistics for LR like decision,
//   `define DET3D_RO_MAT_CHRU_TB        8'h86
//   //Bit 15:0,	RO_ChrU_TB_score	S2*8  CHRU statistics Top/Bottom decision score for
//   each band (8bands Horizontally)
//   //Bit 7:0,	RO_ChrU_TB_symtc	CHRU statistics Top/Bottompure symmetric for each band
//   (8bands Horizontally)
//   //Bit 4:0,	RO_ChrU_TB_sum	    Total score of 8x8 ChrU statistics for TB like decision
//   `define DET3D_RO_MAT_CHRV_LR        8'h87
//   //Bit 15:0, RO_ChrV_LR_score S2*8  CHRUstatistics left right decision score for each
//   band (8bands vertically)
//   //Bit 7:0,	RO_ChrV_LR_symtc	CHRV statistics left right pure symmetric for each band
//   (8bands vertically)
//   //Bit 4:0,	RO_ChrV_LR_sum	    Total score of 8x8 ChrV statistics for LR like decision
//   `define DET3D_RO_MAT_CHRV_TB        8'h88
//   //Bit 15:0,	RO_ChrV_TB_score	CHRV statistics Top/Bottom decision score for each
//   band (8bands Horizontally)
//   //Bit 7:0,	RO_ChrV_TB_symtc	CHRV statistics Top/Bottompure symmetric for each band
//   (8bands Horizontally)
//   //Bit 4:0,	RO_ChrV_TB_sum	    Total score of 8x8 ChrV statistics for TB like decision
//   `define DET3D_RO_MAT_HEDG_LR        8'h89
//   //Bit 15:0,	RO_Hedg_LR_score	Horizontal Edge statistics left right decision score
//   for each band (8bands vertically)
//   //Bit 7:0,	RO_Hedg_LR_symtc	Horizontal Edge statistics left right pure symmetric for
//   each band (8bands vertically)
//   //Bit 4:0,	RO_Hedg_LR_sum	    Total score of 8x8 Hedg statistics for LR like decision
//   `define DET3D_RO_MAT_HEDG_TB        8'h8a
//   //Bit 15:0,	RO_Hedg_TB_score	Horizontal Edge statistics Top/Bottom decision score
//   for each band (8bands Horizontally)
//   //Bit 7:0,	RO_Hedg_TB_symtc	Horizontal Edge statistics Top/Bottompure symmetric for
//   each band (8bands Horizontally)
//   //Bit 4:0,	RO_Hedg_TB_sum	    Total score of 8x8 Hedg statistics for TB like decision
//   `define DET3D_RO_MAT_VEDG_LR        8'h8b
//   //Bit 15:0, RO_Vedg_LR_score Vertical Edge statistics left right decision score for
//   each band (8bands vertically)
//   //Bit 7:0,	RO_Vedg_LR_symtc	Vertical Edge statistics left right pure symmetric for
//   each band (8bands vertically)
//   //Bit 4:0,	RO_Vedg_LR_sum	    Total score of 8x8 Vedg statistics for LR like decision
//   `define DET3D_RO_MAT_VEDG_TB        8'h8c
//   //Bit 15:0, RO_Vedg_TB_score Vertical Edge statistics Top/Bottom decision score for
//   each band (8bands Horizontally)
//   //Bit 7:0,	RO_Vedg_TB_symtc	Vertical Edge statistics Top/Bottompure symmetric for each
//   band (8bands Horizontally)
//   //Bit 4:0,	RO_Vedg_TB_sum	    Total score of 8x8 Vedg statistics for TB like decision
//   `define DET3D_RO_MAT_MOTN_LR        8'h8d
//   //Bit 15:0,	RO_Motn_LR_score	Motion statistics left right decision score for each
//   band (8bands vertically)
//   //Bit 7:0,	RO_Motn_LR_symtc	Motion statistics left right pure symmetric for each band
//   (8bands vertically)
//   //Bit 4:0,	RO_Motn_LR_sum	    Total score of 8x8 Motion statistics for LR like decision
//   `define DET3D_RO_MAT_MOTN_TB        8'h8e
//   //Bit 15:0,	RO_Motn_TB_score	Motion statistics Top/Bottom decision score for each
//   band (8bands Horizontally)
//   //Bit 7:0,	RO_Motn_TB_symtc	Motion statistics Top/Bottompure symmetric for each band
//   (8bands Horizontally)
//   //Bit 4:0,	RO_Motn_TB_sum	    Total score of 8x8 Motion statistics for TB like decision
//   `define DET3D_RO_FRM_MOTN           8'h8f
//   //Bit 15:0,	RO_Det3D_Frame_Motion	U16  frame based motion value sum for still image
//   decision in FW.
#define DI_EI_CTRL10 ((0x1793 << 2) + 0xff900000)
// bit 31:28,   reg_ei_caldrt_hstrrgchk_drtth
// bit 27:24,   reg_ei_caldrt_hstrrgchk_frcverthrd
// bit 23:20,   reg_ei_caldrt_hstrrgchk_mg
// bit 19,      reg_ei_caldrt_hstrrgchk_1sidnul
// bit 18,      reg_ei_caldrt_hstrrgchk_excpcnf
// bit 17:16,   reg_ei_caldrt_hstrrgchk_ws
// bit 15,      reg_ei_caldrt_hstrrgchk_en
// bit 14:13,   reg_ei_caldrt_hpncheck_mode
// bit 12,      reg_ei_caldrt_hpncheck_mute
// bit 11:9,    reg_ei_caldrt_hcnfcheck_mg2
// bit 8:6,     reg_ei_caldrt_hcnfcheck_mg1
// bit 5:4,     reg_ei_caldrt_hcnfcheck_mode
// bit 3:0,     reg_ei_caldrt_hcnfcheck_mg2
#define DI_NR_1_CTRL0 ((0x1794 << 2) + 0xff900000)
#define DI_NR_1_CTRL1 ((0x1795 << 2) + 0xff900000)
#define DI_NR_1_CTRL2 ((0x1796 << 2) + 0xff900000)
#define DI_NR_1_CTRL3 ((0x1797 << 2) + 0xff900000)
#define DI_EI_XWIN0 ((0x1798 << 2) + 0xff900000)
// bit 27:16,   ei_xend0
// bit 11:0,    ei_xstart0
#define DI_EI_XWIN1 ((0x1799 << 2) + 0xff900000)
/// mat ram read enter addr
//   `define DET3D_RAMRD_ADDR_PORT       8'h9a
//   `define DET3D_RAMRD_DATA_PORT       8'h9b
#define NR2_CFR_PARA_CFG0 ((0x179c << 2) + 0xff900000)
// Bit 8,	reg_CFR_CurDif_luma_mode	Current Field Top/Bot line Luma difference
// calculation
// mode Bit 7:6, reg_MACFR_frm_phase	        U2  This will be a field based phase register
// that need to be set by FW phase to phase:
//                                      this will be calculated based on dbdr_phase of the
//                                      specific line of this frame. u1: dbdr_phase=1, center line
//                                      is DB in current line;  dbdr_phase=2, center line is Dr in
//                                      current line;
// Bit 5:4,	reg_CFR_CurDif_tran_mode	U2  Current Field Top/Bot line Luma/Chroma
// transition
// level calculation mode, Bit 3:2,	reg_CFR_alpha_mode	        U2  Alpha selection mode
// for CFR block from curAlp and motAlp i.e. 0: motAlp; 1: (motAlp+curAlp)/2; 2:
// min(motAlp,curAlp); 3: max(motAlp,curAlp);
// Bit 1:0,	reg_CFR_Motion_Luma_mode	U2  LumaMotion Calculation mode for MA-CFR. 0:
// top/bot Lumma motion;   1: middle Luma Motion 2: top/bot + middle motion; 3: max(top/tot
// motion, middle motion)
#define NR2_CFR_PARA_CFG1 ((0x179d << 2) + 0xff900000)
// Bit 23:16,	reg_CFR_alpha_gain	    gain to map muxed curAlp and motAlp to alpha that will
// be used for final blending.
// Bit 15: 8,	reg_CFR_Motion_ofst	    Offset to Motion to calculate the motAlp, e,g:motAlp=
// reg_CFR_Motion_ofst- Motion;This register can be seen as the level of motion that we consider
// it
// at moving. Bit  7: 0,	reg_CFR_CurDif_gain	    gain to CurDif to map to alpha,
// normalized to 32;
//// DET 3D REG DEFINE END ////
#define DI_EI_CTRL11 ((0x179e << 2) + 0xff900000)
// bit 30:29,   reg_ei_amb_detect_mode
// bit 28:24,   reg_ei_amb_detect_winth
// bit 23:21,   reg_ei_amb_decide_rppth
// bit 20:19,   reg_ei_retime_lastmappncnfltchk_drtth
// bit 18:16,   reg_ei_retime_lastmappncnfltchk_mode
// bit 15:14,   reg_ei_retime_lastmapvertfrcchk_mode
// bit 13:12,   reg_ei_retime_lastvertfrcchk_mode
// bit 11:8,    reg_ei_retime_lastpnchk_drtth
// bit 6,       reg_ei_retime_lastpnchk_en
// bit 5:4,     reg_ei_retime_mode
// bit 3,       reg_ei_retime_last_en
// bit 2,       reg_ei_retime_ab_en
// bit 1,       reg_ei_caldrt_hstrvertfrcchk_en
// bit 0,       reg_ei_caldrt_hstrrgchk_mode
#define DI_EI_CTRL12 ((0x179f << 2) + 0xff900000)
// bit 31:28,   reg_ei_drtdelay2_lmt
// bit 27:26,   reg_ei_drtdelay2_notver_lrwin
// bit 25:24,   reg_ei_drtdelay_mode
// bit 23,      reg_ei_drtdelay2_mode
// bit 22:20,   reg_ei_assign_xla_signm0th
// bit 19,      reg_ei_assign_pkbiasvert_en
// bit 18,      reg_ei_assign_xla_en
// bit 17:16,   reg_ei_assign_xla_mode
// bit 15:12,   reg_ei_assign_nlfilter_magin
// bit 11:8,    reg_ei_localsearch_maxrange
// bit 7:4,     reg_ei_xla_drtth
// bit 3:0,     reg_ei_flatmsad_thrd
//`define DI_DIWR_CANVAS      8'ha0
//`define DI_DIWR_URGENT      8'ha1
//`define DI_NRWR_CANVAS      8'ha2
//`define DI_NRWR_URGENT      8'ha7
//`define DI_CONTWR_X                8'ha0
//`define DI_CONTWR_Y                8'ha1
//`define DI_CONTWR_CTRL             8'ha2
//`define DI_CONTPRD_X               8'ha3
//`define DI_CONTPRD_Y               8'ha4
//`define DI_CONTP2RD_X              8'ha5
//`define DI_CONTP2RD_Y              8'ha6
#define DI_RO_PRE_FIELD_CNT0 ((0x17a3 << 2) + 0xff900000)
#define DI_RO_PRE_FIELD_CNT1 ((0x17a4 << 2) + 0xff900000)
#define DI_RO_POS_FRAME_CNT0 ((0x17a5 << 2) + 0xff900000)
#define DI_RO_POS_FRAME_CNT1 ((0x17a6 << 2) + 0xff900000)
//`define DI_CONTRD_CTRL             8'ha7
#define DI_EI_CTRL13 ((0x17a8 << 2) + 0xff900000)
// bit 27:24,   reg_ei_int_drt2x_chrdrt_limit
// bit 23:20,   reg_ei_int_drt16x_core
// bit 19:16,   reg_ei_int_drtdelay2_notver_cancv
// bit 15:8,    reg_ei_int_drtdelay2_notver_sadth
// bit 7:0,     reg_ei_int_drtdelay2_vlddrt_sadth
#define DI_MTN_1_CTRL6 ((0x17a9 << 2) + 0xff900000)
// bit 31:24,   mtn_m1b_extnd
// bit 23:16,   mtn_m1b_errod
// bit 15: 8,   mtn_core_ykinter
// bit  7: 0,   mtn_core_ckinter
#define DI_MTN_1_CTRL7 ((0x17aa << 2) + 0xff900000)
// bit 31:24,   mtn_core_mxcmby
// bit 23:16,   mtn_core_mxcmbc
// bit 15: 8,   mtn_core_y
// bit  7: 0,   mtn_core_c
#define DI_MTN_1_CTRL8 ((0x17ab << 2) + 0xff900000)
// bit 31:24,   mtn_fcore_ykinter
// bit 23:16,   mtn_fcore_ckinter
// bit 15: 8,   mtn_fcore_ykintra
// bit  7: 0,   mtn_fcore_ckintra
#define DI_MTN_1_CTRL9 ((0x17ac << 2) + 0xff900000)
// bit 31:24,   mtn_fcore_2yrate
// bit 23:16,   mtn_fcore_2crate
// bit 15: 8,   mtn_fcore_y
// bit  7: 0,   mtn_fcore_c
#define DI_MTN_1_CTRL10 ((0x17ad << 2) + 0xff900000)
// bit 27:24,   mtn_motfld0
// bit 19:16,   mtn_stlfld0
// bit 11: 8,   mtn_motfld1
// bit  3: 0,   mtn_stlfld1
#define DI_MTN_1_CTRL11 ((0x17ae << 2) + 0xff900000)
// bit 27:24,   mtn_smotevn
// bit 20:16,   mtn_smotodd
// bit 11: 8,   mtn_sstlevn
// bit  4: 0,   mtn_sstlodd
#define DI_MTN_1_CTRL12 ((0x17af << 2) + 0xff900000)
// bit 31:24,   mtn_mgain
// bit 17:16,   mtn_mmode
// bit 15: 8,   mtn_sthrd
// bit  4: 0,   mtn_sgain
//`define DI_NRWR_X                 8'hc0
//`define DI_NRWR_Y                 8'hc1
// bit 31:30				nrwr_words_lim
// bit 29				nrwr_rev_y
// bit 28:16				nrwr_start_y
// bit 15				nrwr_ext_en
// bit 12:0				nrwr_end_y
//`define DI_NRWR_CTRL              8'hc2
// bit 31				pending_ddr_wrrsp_diwr
// bit 30				nrwr_reg_swap
// bit 29:26				nrwr_burst_lim
// bit 25				nrwr_canvas_syncen
// bit 24				nrwr_no_clk_gate
// bit 23:22				nrwr_rgb_mode  0:422 to one canvas;1:4:4:4 to one canvas;
// bit 21:20				nrwr_hconv_mode
// bit 19:18				nrwr_vconv_mode
// bit 17				nrwr_swap_cbcr
// bit 16				nrwr_urgent
// bit 15:8				nrwr_canvas_index_chroma
// bit 7:0				nrwr_canvas_index_luma
//`define DI_MTNWR_X                8'hc3
//`define DI_MTNWR_Y                8'hc4
//`define DI_MTNWR_CTRL             8'hc5
#define DI_RO_CRC_NRWR ((0x17c0 << 2) + 0xff900000)
#define DI_RO_CRC_MTNWR ((0x17c1 << 2) + 0xff900000)
#define DI_RO_CRC_DEINT ((0x17c2 << 2) + 0xff900000)
#define DI_CRC_CHK0 ((0x17c3 << 2) + 0xff900000)
#define DI_CRC_CHK1 ((0x17c4 << 2) + 0xff900000)
//`define DI_DIWR_X                 8'hc6
//`define DI_DIWR_Y                 8'hc7
// bit 31:30				diwr_words_lim
// bit 29				diwr_rev_y
// bit 28:16				diwr_start_y
// bit 15				diwr_ext_en
// bit 12:0				diwr_end_y
//`define DI_DIWR_CTRL              8'hc8
// bit 31				pending_ddr_wrrsp_diwr
// bit 30				diwr_reg_swap
// bit 29:26				diwr_burst_lim
// bit 25				diwr_canvas_syncen
// bit 24				diwr_no_clk_gate
// bit 23:22				diwr_rgb_mode  0:422 to one canvas;1:4:4:4 to one canvas;
// bit 21:20				diwr_hconv_mode
// bit 19:18				diwr_vconv_mode
// bit 17				diwr_swap_cbcr
// bit 16				diwr_urgent
// bit 15:8				diwr_canvas_index_chroma
// bit 7:0				diwr_canvas_index_luma
//`define DI_MTNCRD_X               8'hc9
//`define DI_MTNCRD_Y               8'hca
//`define DI_MTNPRD_X               8'hcb
//`define DI_MTNPRD_Y               8'hcc
//`define DI_MTNRD_CTRL             8'hcd
#define DI_TOP_PRE_CTRL ((0x17c5 << 2) + 0xff900000)
#define DI_TOP_POST_CTRL ((0x17c6 << 2) + 0xff900000)
#define DI_PRE_GL_CTRL ((0x17c7 << 2) + 0xff900000)
#define DI_PRE_GL_THD ((0x17c8 << 2) + 0xff900000)
#define DI_POST_GL_CTRL ((0x17c9 << 2) + 0xff900000)
#define DI_POST_GL_THD ((0x17ca << 2) + 0xff900000)
#define DI_RO_PRE_DBG ((0x17cb << 2) + 0xff900000)
#define DI_RO_POST_DBG ((0x17cc << 2) + 0xff900000)
#define DI_TOP_CTRL ((0x17cd << 2) + 0xff900000)
#define DI_AFBCD_GCLK0 ((0x17ce << 2) + 0xff900000)
#define DI_AFBCD_GCLK1 ((0x17cf << 2) + 0xff900000)
#define DI_RDMIF_DEPTH0 ((0x17d0 << 2) + 0xff900000)
#define DI_RDMIF_DEPTH1 ((0x17d1 << 2) + 0xff900000)
#define DI_RDMIF_DEPTH2 ((0x17d2 << 2) + 0xff900000)
#define DI_TOP_CTRL1 ((0x17d3 << 2) + 0xff900000)
#define DI_AFBCE0_HOLD_CTRL ((0x17d4 << 2) + 0xff900000)
#define DI_AFBCE1_HOLD_CTRL ((0x17d5 << 2) + 0xff900000)
#define DI_DTNL_CTRL ((0x17d6 << 2) + 0xff900000)
// 0xe0 - 0xff
//
// Reading file:  di_pd_grad_reg.h
//
#define DI_PD_GRAD_CTRL ((0x17e0 << 2) + 0xff900000)
// Bit 31:12  reserved
// Bit 11:4   reg_fd_min_grad_th           // default 255 //u8, for cur/pre1 field.
// cur_min_grad_err > th, will be excluded of statistic Bit 3      reg_fd_min_grad_th_adjust_en //
// default 1   //u1, reg_fd_min_grad_err_th adjustment enable/disable Bit 2
// reg_fd_err_grad_bf_flt_en    // default 1   //u1, 1:comput err_grad_sum before horizontal
// filtering; 0: ...after...; default=1; Bit 1      reg_fd_comb_field_sel        // default 0
// //u1, comb consists of 2 field; 0: cur-pre; 1:pre-pre2; Bit 0      reg_fd_iscur_top_inver //
// default 0   //u1, current field is top flag invert; 0 no invert, 1, invert
#define DI_PD_GRAD_TH_P ((0x17e1 << 2) + 0xff900000)
// Bit 31:24  reg_fd_min_grad_th_p0        //default 2     //u8,
// Bit 23:16  reg_fd_min_grad_th_p1        //default 4     //u8,
// Bit 15:8   reg_fd_min_grad_th_p2        //default 8     //u8,
// Bit 7:0    reg_fd_min_grad_th_p3        //default 12    //u8,
#define DI_PD_GRAD_TH_N ((0x17e2 << 2) + 0xff900000)
// Bit 31:24  reg_fd_min_grad_th_n0        //default 4     //u8,
// Bit 23:16  reg_fd_min_grad_th_n1        //default 8     //u8,
// Bit 15:8   reg_fd_min_grad_th_n2        //default 16    //u8,
// Bit 7:0    reg_fd_min_grad_th_n3        //default 32    //u8,
#define DI_PD_GRAD_GAIN_P ((0x17e3 << 2) + 0xff900000)
// Bit 31:29  reserved
// Bit 28:24  reg_fd_min_grad_gain_p0      //default 16    //u5,
// Bit 23:21  reserved
// Bit 20:16  reg_fd_min_grad_gain_p1      //default 16    //u5,
// Bit 15:13  reserved
// Bit 12:8   reg_fd_min_grad_gain_p2      //default 16    //u5,
// Bit 7:5    reserved
// Bit 4:0    reg_fd_min_grad_gain_p3      //default 16    //u5,
#define DI_PD_GRAD_GAIN_N ((0x17e4 << 2) + 0xff900000)
// Bit 31:29  reserved
// Bit 28:24  reg_fd_min_grad_gain_n0      //default 12    //u5,
// Bit 23:21  reserved
// Bit 20:16  reg_fd_min_grad_gain_n1      //default 12    //u5,
// Bit 15:13  reserved
// Bit 12:8   reg_fd_min_grad_gain_n2      //default 14    //u5,
// Bit 7:5    reserved
// Bit 4:0    reg_fd_min_grad_gain_n3      //default 15    //u5,
#define DI_PD_RO_SUM_P_WIN0 ((0x17e5 << 2) + 0xff900000)
// Bit 31:0   ro_fd_err_grad_sum_p0
#define DI_PD_RO_SUM_P_WIN1 ((0x17e6 << 2) + 0xff900000)
// Bit 31:0   ro_fd_err_grad_sum_p1
#define DI_PD_RO_SUM_P_WIN2 ((0x17e7 << 2) + 0xff900000)
// Bit 31:0   ro_fd_err_grad_sum_p2
#define DI_PD_RO_SUM_P_WIN3 ((0x17e8 << 2) + 0xff900000)
// Bit 31:0   ro_fd_err_grad_sum_p3
#define DI_PD_RO_SUM_P_WIN4 ((0x17e9 << 2) + 0xff900000)
// Bit 31:0   ro_fd_err_grad_sum_p4
#define DI_PD_RO_SUM_N_WIN0 ((0x17ea << 2) + 0xff900000)
// Bit 31:0   ro_fd_err_grad_sum_n0
#define DI_PD_RO_SUM_N_WIN1 ((0x17eb << 2) + 0xff900000)
// Bit 31:0   ro_fd_err_grad_sum_n1
#define DI_PD_RO_SUM_N_WIN2 ((0x17ec << 2) + 0xff900000)
// Bit 31:0   ro_fd_err_grad_sum_n2
#define DI_PD_RO_SUM_N_WIN3 ((0x17ed << 2) + 0xff900000)
// Bit 31:0   ro_fd_err_grad_sum_n3
#define DI_PD_RO_SUM_N_WIN4 ((0x17ee << 2) + 0xff900000)
// Bit 31:0   ro_fd_err_grad_sum_n4
#define DI_PD_RO_CNT_P_WIN0 ((0x17ef << 2) + 0xff900000)
// Bit 31:21  reserved
// Bit 20:0   ro_fd_err_grad_cnt_p0
#define DI_PD_RO_CNT_P_WIN1 ((0x17f0 << 2) + 0xff900000)
// Bit 31:21  reserved
// Bit 20:0   ro_fd_err_grad_cnt_p1
#define DI_PD_RO_CNT_P_WIN2 ((0x17f1 << 2) + 0xff900000)
// Bit 31:21  reserved
// Bit 20:0   ro_fd_err_grad_cnt_p2
#define DI_PD_RO_CNT_P_WIN3 ((0x17f2 << 2) + 0xff900000)
// Bit 31:21  reserved
// Bit 20:0   ro_fd_err_grad_cnt_p3
#define DI_PD_RO_CNT_P_WIN4 ((0x17f3 << 2) + 0xff900000)
// Bit 31:21  reserved
// Bit 20:0   ro_fd_err_grad_cnt_p4
#define DI_PD_RO_CNT_N_WIN0 ((0x17f4 << 2) + 0xff900000)
// Bit 31:21  reserved
// Bit 20:0   ro_fd_err_grad_cnt_n0
#define DI_PD_RO_CNT_N_WIN1 ((0x17f5 << 2) + 0xff900000)
// Bit 31:21  reserved
// Bit 20:0   ro_fd_err_grad_cnt_n1
#define DI_PD_RO_CNT_N_WIN2 ((0x17f6 << 2) + 0xff900000)
// Bit 31:21  reserved
// Bit 20:0   ro_fd_err_grad_cnt_n2
#define DI_PD_RO_CNT_N_WIN3 ((0x17f7 << 2) + 0xff900000)
// Bit 31:21  reserved
// Bit 20:0   ro_fd_err_grad_cnt_n3
#define DI_PD_RO_CNT_N_WIN4 ((0x17f8 << 2) + 0xff900000)
// Bit 31:21  reserved
// Bit 20:0   ro_fd_err_grad_cnt_n4
#define DI_PD_RO_SUM_P ((0x17f9 << 2) + 0xff900000)
// Bit 31:0   ro_fd_err_grad_sum_p_glb
#define DI_PD_RO_SUM_N ((0x17fa << 2) + 0xff900000)
// Bit 31:0   ro_fd_err_grad_sum_n_glb
#define DI_PD_RO_CNT_P ((0x17fb << 2) + 0xff900000)
// Bit 31:21  reserved
// Bit 20:0   ro_fd_err_grad_cnt_p_glb
#define DI_PD_RO_CNT_N ((0x17fc << 2) + 0xff900000)
// Bit 31:21  reserved
// Bit 20:0   ro_fd_err_grad_cnt_n_glb
//
// Closing file:  di_pd_grad_reg.h
//
//`define DI_INP_GEN_REG            8'hce
//`define DI_INP_CANVAS0            8'hcf
//`define DI_INP_LUMA_X0            8'hd0
//`define DI_INP_LUMA_Y0            8'hd1
//`define DI_INP_CHROMA_X0          8'hd2
//`define DI_INP_CHROMA_Y0          8'hd3
//`define DI_INP_RPT_LOOP           8'hd4
//`define DI_INP_LUMA0_RPT_PAT      8'hd5
//`define DI_INP_CHROMA0_RPT_PAT    8'hd6
//`define DI_INP_DUMMY_PIXEL        8'hd7
//`define DI_INP_LUMA_FIFO_SIZE     8'hd8
//`define DI_INP_RANGE_MAP_Y        8'hba
//`define DI_INP_RANGE_MAP_CB       8'hbb
//`define DI_INP_RANGE_MAP_CR       8'hbc
//`define DI_INP_GEN_REG2           8'h91
//
//`define DI_INP_FMT_CTRL           8'hd9
//`define DI_INP_FMT_W              8'hda
////
//`define DI_MEM_GEN_REG            8'hdb
//`define DI_MEM_CANVAS0            8'hdc
//`define DI_MEM_LUMA_X0            8'hdd
//`define DI_MEM_LUMA_Y0            8'hde
//`define DI_MEM_CHROMA_X0          8'hdf
//`define DI_MEM_CHROMA_Y0          8'he0
//`define DI_MEM_RPT_LOOP           8'he1
//`define DI_MEM_LUMA0_RPT_PAT      8'he2
//`define DI_MEM_CHROMA0_RPT_PAT    8'he3
//`define DI_MEM_DUMMY_PIXEL        8'he4
//`define DI_MEM_LUMA_FIFO_SIZE     8'he5
//`define DI_MEM_RANGE_MAP_Y        8'hbd
//`define DI_MEM_RANGE_MAP_CB       8'hbe
//`define DI_MEM_RANGE_MAP_CR       8'hbf
//`define DI_MEM_GEN_REG2           8'h92
//
//`define DI_MEM_FMT_CTRL           8'he6
//`define DI_MEM_FMT_W              8'he7
//
//`define DI_IF1_GEN_REG            8'he8
//`define DI_IF1_CANVAS0            8'he9
//`define DI_IF1_LUMA_X0            8'hea
//`define DI_IF1_LUMA_Y0            8'heb
//`define DI_IF1_CHROMA_X0          8'hec
//`define DI_IF1_CHROMA_Y0          8'hed
//`define DI_IF1_RPT_LOOP           8'hee
//`define DI_IF1_LUMA0_RPT_PAT      8'hef
//`define DI_IF1_CHROMA0_RPT_PAT    8'hf0
//`define DI_IF1_DUMMY_PIXEL        8'hf1
//`define DI_IF1_LUMA_FIFO_SIZE     8'hf2
//`define DI_IF1_RANGE_MAP_Y        8'hfc
//`define DI_IF1_RANGE_MAP_CB       8'hfd
//`define DI_IF1_RANGE_MAP_CR       8'hfe
//`define DI_IF1_GEN_REG2           8'h90
//
//`define DI_IF1_FMT_CTRL           8'hf3
//`define DI_IF1_FMT_W              8'hf4
//
//
//`define DI_CHAN2_GEN_REG          8'hf5
//`define DI_CHAN2_CANVAS0          8'hf6
//`define DI_CHAN2_LUMA_X0          8'hf7
//`define DI_CHAN2_LUMA_Y0          8'hf8
//`define DI_CHAN2_CHROMA_X0        8'hf9
//`define DI_CHAN2_CHROMA_Y0        8'hfa
//`define DI_CHAN2_RPT_LOOP         8'hfb
//`define DI_CHAN2_LUMA0_RPT_PAT    8'hb0
//`define DI_CHAN2_CHROMA0_RPT_PAT  8'hb1
//`define DI_CHAN2_DUMMY_PIXEL      8'hb2
//`define DI_CHAN2_LUMA_FIFO_SIZE   8'hb3
//`define DI_CHAN2_RANGE_MAP_Y      8'hb4
//`define DI_CHAN2_RANGE_MAP_CB     8'hb5
//`define DI_CHAN2_RANGE_MAP_CR     8'hb6
//`define DI_CHAN2_GEN_REG2         8'hb7
//`define DI_CHAN2_FMT_CTRL         8'hb8
//`define DI_CHAN2_FMT_W            8'hb9
//
// Closing file:  vpu_mad_regs.h
//
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  MADD_VCBUS_BASE = 0x18
// -----------------------------------------------
//===========================================================================
//
// Reading file:  di_dolby_regs.h
//
// synopsys translate_off
// synopsys translate_on
#define DI_DOLBY_CORE1C_REG_START ((0x1800 << 2) + 0xff900000)
#define DI_DOLBY_CORE1C_CLKGATE_CTRL ((0x18f2 << 2) + 0xff900000)
#define DI_DOLBY_CORE1C_SWAP_CTRL0 ((0x18f3 << 2) + 0xff900000)
#define DI_DOLBY_CORE1C_SWAP_CTRL1 ((0x18f4 << 2) + 0xff900000)
#define DI_DOLBY_CORE1C_SWAP_CTRL2 ((0x18f5 << 2) + 0xff900000)
#define DI_DOLBY_CORE1C_SWAP_CTRL3 ((0x18f6 << 2) + 0xff900000)
#define DI_DOLBY_CORE1C_SWAP_CTRL4 ((0x18f7 << 2) + 0xff900000)
#define DI_DOLBY_CORE1C_SWAP_CTRL5 ((0x18f8 << 2) + 0xff900000)
#define DI_DOLBY_CORE1C_DMA_CTRL ((0x18f9 << 2) + 0xff900000)
#define DI_DOLBY_CORE1C_DMA_STATUS ((0x18fa << 2) + 0xff900000)
#define DI_DOLBY_CORE1C_STATUS0 ((0x18fb << 2) + 0xff900000)
#define DI_DOLBY_CORE1C_STATUS1 ((0x18fc << 2) + 0xff900000)
#define DI_DOLBY_CORE1C_STATUS2 ((0x18fd << 2) + 0xff900000)
#define DI_DOLBY_CORE1C_STATUS3 ((0x18fe << 2) + 0xff900000)
#define DI_DOLBY_CORE1C_DMA_PORT ((0x18ff << 2) + 0xff900000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  di_dolby_regs.h
//
//`include "di_inp_afbc_dec_regs.h"
//`include "di_mem_afbc_dec_regs.h"
//`include "fgrain_di_regs.h"
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  DISP_IF0_VCBUS_BASE = 0x19
// -----------------------------------------------
//===========================================================================
//
// Reading file:  disp_if_regs.h
//
//`define DISP_IF0_VCBUS_BASE           8'h19
//`define DISP_IF1_VCBUS_BASE           8'h1e
//`define DISP_IF2_VCBUS_BASE           8'h1f
#define L_GAMMA_CNTL_PORT ((0x1900 << 2) + 0xff900000)
#define L_GAMMA_DATA_PORT ((0x1901 << 2) + 0xff900000)
#define L_GAMMA_ADDR_PORT ((0x1902 << 2) + 0xff900000)
#define L_GAMMA_VCOM_HSWITCH_ADDR ((0x1903 << 2) + 0xff900000)
#define L_RGB_BASE_ADDR ((0x1905 << 2) + 0xff900000)
#define L_RGB_COEFF_ADDR ((0x1906 << 2) + 0xff900000)
#define L_POL_CNTL_ADDR ((0x1907 << 2) + 0xff900000)
#define L_DITH_CNTL_ADDR ((0x1908 << 2) + 0xff900000)
#define L_GAMMA_PROBE_CTRL ((0x1909 << 2) + 0xff900000)
// read only
#define L_GAMMA_PROBE_COLOR_L ((0x190a << 2) + 0xff900000)
#define L_GAMMA_PROBE_COLOR_H ((0x190b << 2) + 0xff900000)
#define L_GAMMA_PROBE_HL_COLOR ((0x190c << 2) + 0xff900000)
#define L_GAMMA_PROBE_POS_X ((0x190d << 2) + 0xff900000)
#define L_GAMMA_PROBE_POS_Y ((0x190e << 2) + 0xff900000)
#define L_STH1_HS_ADDR ((0x1910 << 2) + 0xff900000)
#define L_STH1_HE_ADDR ((0x1911 << 2) + 0xff900000)
#define L_STH1_VS_ADDR ((0x1912 << 2) + 0xff900000)
#define L_STH1_VE_ADDR ((0x1913 << 2) + 0xff900000)
#define L_STH2_HS_ADDR ((0x1914 << 2) + 0xff900000)
#define L_STH2_HE_ADDR ((0x1915 << 2) + 0xff900000)
#define L_STH2_VS_ADDR ((0x1916 << 2) + 0xff900000)
#define L_STH2_VE_ADDR ((0x1917 << 2) + 0xff900000)
#define L_OEH_HS_ADDR ((0x1918 << 2) + 0xff900000)
#define L_OEH_HE_ADDR ((0x1919 << 2) + 0xff900000)
#define L_OEH_VS_ADDR ((0x191a << 2) + 0xff900000)
#define L_OEH_VE_ADDR ((0x191b << 2) + 0xff900000)
#define L_VCOM_HSWITCH_ADDR ((0x191c << 2) + 0xff900000)
#define L_VCOM_VS_ADDR ((0x191d << 2) + 0xff900000)
#define L_VCOM_VE_ADDR ((0x191e << 2) + 0xff900000)
#define L_CPV1_HS_ADDR ((0x191f << 2) + 0xff900000)
#define L_CPV1_HE_ADDR ((0x1920 << 2) + 0xff900000)
#define L_CPV1_VS_ADDR ((0x1921 << 2) + 0xff900000)
#define L_CPV1_VE_ADDR ((0x1922 << 2) + 0xff900000)
#define L_CPV2_HS_ADDR ((0x1923 << 2) + 0xff900000)
#define L_CPV2_HE_ADDR ((0x1924 << 2) + 0xff900000)
#define L_CPV2_VS_ADDR ((0x1925 << 2) + 0xff900000)
#define L_CPV2_VE_ADDR ((0x1926 << 2) + 0xff900000)
#define L_STV1_HS_ADDR ((0x1927 << 2) + 0xff900000)
#define L_STV1_HE_ADDR ((0x1928 << 2) + 0xff900000)
#define L_STV1_VS_ADDR ((0x1929 << 2) + 0xff900000)
#define L_STV1_VE_ADDR ((0x192a << 2) + 0xff900000)
#define L_STV2_HS_ADDR ((0x192b << 2) + 0xff900000)
#define L_STV2_HE_ADDR ((0x192c << 2) + 0xff900000)
#define L_STV2_VS_ADDR ((0x192d << 2) + 0xff900000)
#define L_STV2_VE_ADDR ((0x192e << 2) + 0xff900000)
#define L_OEV1_HS_ADDR ((0x192f << 2) + 0xff900000)
#define L_OEV1_HE_ADDR ((0x1930 << 2) + 0xff900000)
#define L_OEV1_VS_ADDR ((0x1931 << 2) + 0xff900000)
#define L_OEV1_VE_ADDR ((0x1932 << 2) + 0xff900000)
#define L_OEV2_HS_ADDR ((0x1933 << 2) + 0xff900000)
#define L_OEV2_HE_ADDR ((0x1934 << 2) + 0xff900000)
#define L_OEV2_VS_ADDR ((0x1935 << 2) + 0xff900000)
#define L_OEV2_VE_ADDR ((0x1936 << 2) + 0xff900000)
#define L_OEV3_HS_ADDR ((0x1937 << 2) + 0xff900000)
#define L_OEV3_HE_ADDR ((0x1938 << 2) + 0xff900000)
#define L_OEV3_VS_ADDR ((0x1939 << 2) + 0xff900000)
#define L_OEV3_VE_ADDR ((0x193a << 2) + 0xff900000)
#define L_LCD_PWR_ADDR ((0x193b << 2) + 0xff900000)
#define L_LCD_PWM0_LO_ADDR ((0x193c << 2) + 0xff900000)
#define L_LCD_PWM0_HI_ADDR ((0x193d << 2) + 0xff900000)
#define L_LCD_PWM1_LO_ADDR ((0x193e << 2) + 0xff900000)
#define L_LCD_PWM1_HI_ADDR ((0x193f << 2) + 0xff900000)
#define L_INV_CNT_ADDR ((0x1940 << 2) + 0xff900000)
#define L_TCON_MISC_SEL_ADDR ((0x1941 << 2) + 0xff900000)
#define L_DUAL_PORT_CNTL_ADDR ((0x1942 << 2) + 0xff900000)
#define MLVDS_CLK_CTL1_HI ((0x1943 << 2) + 0xff900000)
#define MLVDS_CLK_CTL1_LO ((0x1944 << 2) + 0xff900000)
//  [31:30] enable mlvds clocks
//  [24]    mlvds_clk_half_delay       24 // Bit 0
//  [23:0]  mlvds_clk_pattern           0 // Bit 23:0
#define L_TCON_DOUBLE_CTL ((0x1949 << 2) + 0xff900000)
#define L_TCON_PATTERN_HI ((0x194a << 2) + 0xff900000)
#define L_TCON_PATTERN_LO ((0x194b << 2) + 0xff900000)
#define LDIM_BL_ADDR_PORT ((0x194e << 2) + 0xff900000)
#define LDIM_BL_DATA_PORT ((0x194f << 2) + 0xff900000)
#define L_DE_HS_ADDR ((0x1951 << 2) + 0xff900000)
#define L_DE_HE_ADDR ((0x1952 << 2) + 0xff900000)
#define L_DE_VS_ADDR ((0x1953 << 2) + 0xff900000)
#define L_DE_VE_ADDR ((0x1954 << 2) + 0xff900000)
#define L_HSYNC_HS_ADDR ((0x1955 << 2) + 0xff900000)
#define L_HSYNC_HE_ADDR ((0x1956 << 2) + 0xff900000)
#define L_HSYNC_VS_ADDR ((0x1957 << 2) + 0xff900000)
#define L_HSYNC_VE_ADDR ((0x1958 << 2) + 0xff900000)
#define L_VSYNC_HS_ADDR ((0x1959 << 2) + 0xff900000)
#define L_VSYNC_HE_ADDR ((0x195a << 2) + 0xff900000)
#define L_VSYNC_VS_ADDR ((0x195b << 2) + 0xff900000)
#define L_VSYNC_VE_ADDR ((0x195c << 2) + 0xff900000)
// bit 8 -- vfifo_mcu_enable
// bit 7 -- halt_vs_de
// bit 6 -- R8G8B8_format
// bit 5 -- R6G6B6_format (round to 6 bits)
// bit 4 -- R5G6B5_format
// bit 3 -- dac_dith_sel
// bit 2 -- lcd_mcu_enable_de     -- ReadOnly
// bit 1 -- lcd_mcu_enable_vsync  -- ReadOnly
// bit 0 -- lcd_mcu_enable
#define L_LCD_MCU_CTL ((0x195d << 2) + 0xff900000)
#define P2P_CH_SWAP0 ((0x195e << 2) + 0xff900000)
#define P2P_CH_SWAP1 ((0x195f << 2) + 0xff900000)
#define P2P_BIT_REV ((0x1950 << 2) + 0xff900000)
// Dual port mLVDS registers
// bit 3 - enable_u_dual_mlvds_dp_clk
// bit 2 - enable_u_map_mlvds_r_clk
// bit 1 - enable_u_map_mlvds_l_clk
// bit 0 - dual_mlvds_en
//`define DUAL_MLVDS_CTL                8'h60
// bit[12:0] - dual_mlvds_line_start
//`define DUAL_MLVDS_LINE_START         8'h61
// bit[12:0] - dual_mlvds_line_end
//`define DUAL_MLVDS_LINE_END           8'h62
// bit[12:0] - dual_mlvds_w_pixel_start_l
//`define DUAL_MLVDS_PIXEL_W_START_L    8'h63
// bit[12:0] - dual_mlvds_w_pixel_end_l
//`define DUAL_MLVDS_PIXEL_W_END_L      8'h64
// bit[12:0] - dual_mlvds_w_pixel_start_r
//`define DUAL_MLVDS_PIXEL_W_START_R    8'h65
// bit[12:0] - dual_mlvds_w_pixel_end_r
//`define DUAL_MLVDS_PIXEL_W_END_R      8'h66
// bit[12:0] - dual_mlvds_r_pixel_start_l
//`define DUAL_MLVDS_PIXEL_R_START_L    8'h67
// bit[12:0] - dual_mlvds_r_pixel_cnt_l
//`define DUAL_MLVDS_PIXEL_R_CNT_L      8'h68
// bit[12:0] - dual_mlvds_r_pixel_start_r
//`define DUAL_MLVDS_PIXEL_R_START_R    8'h69
// bit[12:0] - dual_mlvds_r_pixel_cnt_r
//`define DUAL_MLVDS_PIXEL_R_CNT_R      8'h6a
// bit[15]   - v_inversion_en
// bit[12:0] - v_inversion_pixel
//`define V_INVERSION_PIXEL             8'h70
// bit[15]   - v_inversion_sync_en
// bit[12:0] - v_inversion_line
//`define V_INVERSION_LINE              8'h71
// bit[15:12]  - v_loop_r
// bit[11:10]  - v_pattern_1_r
// bit[9:8]    - v_pattern_0_r
// bit[7:4]    - v_loop_l
// bit[3:2]    - v_pattern_1_l
// bit[1:0]    - v_pattern_0_l
//`define V_INVERSION_CONTROL           8'h72
//`define MLVDS2_CONTROL           8'h74
#define mLVDS2_RESERVED 15 // 15
#define mLVDS2_double_pattern 14 // 14
#define mLVDS2_ins_reset 8 // 13:8  // each channel has one bit
#define mLVDS2_dual_gate 7
#define mLVDS2_bit_num 6 // 0-6Bits, 1-8Bits
#define mLVDS2_pair_num 5 // 0-3Pairs, 1-6Pairs
#define mLVDS2_msb_first 4
#define mLVDS2_PORT_SWAP 3
#define mLVDS2_MLSB_SWAP 2
#define mLVDS2_PN_SWAP 1
#define mLVDS2_en 0
//`define MLVDS2_CONFIG_HI         8'h75
//`define MLVDS2_CONFIG_LO         8'h76
#define mLVDS2_reset_offset 29 // Bit 31:29
#define mLVDS2_reset_length 23 // Bit 28:23
#define mLVDS2_config_reserved 20 // Bit 22:20
#define mLVDS2_reset_start_bit12 19 // Bit 19
#define mLVDS2_data_write_toggle 18
#define mLVDS2_data_write_ini 17
#define mLVDS2_data_latch_1_toggle 16
#define mLVDS2_data_latch_1_ini 15
#define mLVDS2_data_latch_0_toggle 14
#define mLVDS2_data_latch_0_ini 13
#define mLVDS2_reset_1_select 12 // 0 - same as reset_0, 1 - 1 clock delay of reset_0
#define mLVDS2_reset_start 0 // Bit 11:0
//`define MLVDS2_DUAL_GATE_WR_START        8'h77
//   `define     mlvds2_dual_gate_wr_start    0 // Bit 12:0
//`define MLVDS2_DUAL_GATE_WR_END          8'h78
//   `define     mlvds2_dual_gate_wr_end      0 // Bit 12:0
//
//`define MLVDS2_DUAL_GATE_RD_START        8'h79
//   `define     mlvds2_dual_gate_rd_start    0 // Bit 12:0
//`define MLVDS2_DUAL_GATE_RD_END          8'h7a
//   `define     mlvds2_dual_gate_rd_end      0 // Bit 12:0
//`define MLVDS2_SECOND_RESET_CTL          8'h7b
//   `define     mLVDS2_2nd_reset_start       0 // Bit 12:0
//
//`define MLVDS2_DUAL_GATE_CTL_HI        8'h7c
//`define MLVDS2_DUAL_GATE_CTL_LO        8'h7d
//   `define     mlvds2_tcon_field_en        24 // Bit 7:0
//   `define     mlvds2_dual_gate_reserved   21 // Bit 2:0
//   `define     mlvds2_scan_mode_start_line_bit12 20 // Bit 0
//   `define     mlvds2_scan_mode_odd        16 // Bit 3:0
//   `define     mlvds2_scan_mode_even       12 // Bit 3:0
//   `define     mlvds2_scan_mode_start_line  0 // Bit 11:0
//
//`define MLVDS2_RESET_CONFIG_HI         8'h7e
//`define MLVDS2_RESET_CONFIG_LO         8'h7f
//   `define     mLVDS2_reset_range_enable   31 // Bit 0
//   `define     mLVDS2_reset_range_inv      30 // Bit 0
//   `define     mLVDS2_reset_config_res1    29 // Bit 0
//   `define     mLVDS2_reset_range_line_0   16 // Bit 11:0
//   `define     mLVDS2_reset_config_res3    13 // Bit 2:0
//   `define     mLVDS2_reset_range_line_1    0 // Bit 11:0
//

// Vbyone registers  (Note: no MinLVDS in G9tv, share the register)
#define VBO_CTRL_L ((0x1960 << 2) + 0xff900000)
#define VBO_CTRL_H ((0x1961 << 2) + 0xff900000)
#define VBO_SOFT_RST ((0x1962 << 2) + 0xff900000)
#define VBO_LANES ((0x1963 << 2) + 0xff900000)
#define VBO_VIN_CTRL ((0x1964 << 2) + 0xff900000)
#define VBO_ACT_VSIZE ((0x1965 << 2) + 0xff900000)
#define VBO_REGION_00 ((0x1966 << 2) + 0xff900000)
#define VBO_REGION_01 ((0x1967 << 2) + 0xff900000)
#define VBO_REGION_02 ((0x1968 << 2) + 0xff900000)
#define VBO_REGION_03 ((0x1969 << 2) + 0xff900000)
#define VBO_VBK_CTRL_0 ((0x196a << 2) + 0xff900000)
#define VBO_VBK_CTRL_1 ((0x196b << 2) + 0xff900000)
#define VBO_HBK_CTRL ((0x196c << 2) + 0xff900000)
#define VBO_PXL_CTRL ((0x196d << 2) + 0xff900000)
#define VBO_LANE_SKEW_L ((0x196e << 2) + 0xff900000)
#define VBO_LANE_SKEW_H ((0x196f << 2) + 0xff900000)
#define VBO_GCLK_LANE_L ((0x1970 << 2) + 0xff900000)
#define VBO_GCLK_LANE_H ((0x1971 << 2) + 0xff900000)
#define VBO_GCLK_MAIN ((0x1972 << 2) + 0xff900000)
#define VBO_STATUS_L ((0x1973 << 2) + 0xff900000)
#define VBO_STATUS_H ((0x1974 << 2) + 0xff900000)
#define VBO_LANE_OUTPUT ((0x1975 << 2) + 0xff900000)
#define LCD_PORT_SWAP ((0x1976 << 2) + 0xff900000)
#define VBO_TMCHK_THRD_L ((0x1978 << 2) + 0xff900000)
#define VBO_TMCHK_THRD_H ((0x1979 << 2) + 0xff900000)
#define VBO_FSM_HOLDER_L ((0x197a << 2) + 0xff900000)
#define VBO_FSM_HOLDER_H ((0x197b << 2) + 0xff900000)
#define VBO_INTR_STATE_CTRL ((0x197c << 2) + 0xff900000)
#define VBO_INTR_UNMASK ((0x197d << 2) + 0xff900000)
#define VBO_TMCHK_HSYNC_STATE_L ((0x197e << 2) + 0xff900000)
#define VBO_TMCHK_HSYNC_STATE_H ((0x197f << 2) + 0xff900000)
#define VBO_TMCHK_VSYNC_STATE_L ((0x19f4 << 2) + 0xff900000)
#define VBO_TMCHK_VSYNC_STATE_H ((0x19f5 << 2) + 0xff900000)
#define VBO_TMCHK_VDE_STATE_L ((0x19f6 << 2) + 0xff900000)
#define VBO_TMCHK_VDE_STATE_H ((0x19f7 << 2) + 0xff900000)
#define VBO_INTR_STATE ((0x19f8 << 2) + 0xff900000)
#define VBO_INFILTER_CTRL ((0x19f9 << 2) + 0xff900000)
#define VBO_INSGN_CTRL ((0x19fa << 2) + 0xff900000)
#define VBO_INFILTER_CTRL_H ((0x1977 << 2) + 0xff900000)
// NOTE::    When Programming the Gamma, please turn off the IRQ service
#define GAMMA_CNTL_PORT ((0x1980 << 2) + 0xff900000)
#define GAMMA_VCOM_POL 7 // RW
#define GAMMA_RVS_OUT 6 // RW
#define ADR_RDY 5 // Read Only
#define WR_RDY 4 // Read Only
#define RD_RDY 3 // Read Only
#define GAMMA_TR 2 // RW
#define GAMMA_SET 1 // RW
#define GAMMA_EN 0 // RW
#define GAMMA_DATA_PORT ((0x1981 << 2) + 0xff900000)
#define GAMMA_ADDR_PORT ((0x1982 << 2) + 0xff900000)
#define H_RD 12
#define H_AUTO_INC 11
#define H_SEL_R 10
#define H_SEL_G 9
#define H_SEL_B 8
#define HADR_MSB 7 // 7:0
#define HADR 0 // 7:0
#define GAMMA_VCOM_HSWITCH_ADDR ((0x1983 << 2) + 0xff900000)
#define RGB_BASE_ADDR ((0x1985 << 2) + 0xff900000)
#define RGB_COEFF_ADDR ((0x1986 << 2) + 0xff900000)
#define POL_CNTL_ADDR ((0x1987 << 2) + 0xff900000)
#define DCLK_SEL 14 // FOR DCLK OUTPUT
#define TCON_VSYNC_SEL_DVI 11 // FOR RGB format DVI output
#define TCON_HSYNC_SEL_DVI 10 // FOR RGB format DVI output
#define TCON_DE_SEL_DVI 9 // FOR RGB format DVI output
#define CPH3_POL 8
#define CPH2_POL 7
#define CPH1_POL 6
#define TCON_DE_SEL 5
#define TCON_VS_SEL 4
#define TCON_HS_SEL 3
#define DE_POL 2
#define VS_POL 1
#define HS_POL 0
#define DITH_CNTL_ADDR ((0x1988 << 2) + 0xff900000)
#define DITH10_EN 10
#define DITH8_EN 9
#define DITH_MD 8
#define DITH10_CNTL_MSB 7 // 7:4
#define DITH10_CNTL 4 // 7:4
#define DITH8_CNTL_MSB 3 // 3:0
#define DITH8_CNTL 0 // 3:0
// Bit 1 highlight_en
// Bit 0 probe_en
#define GAMMA_PROBE_CTRL ((0x1989 << 2) + 0xff900000)
// read only
// Bit [15:0]  probe_color[15:0]
#define GAMMA_PROBE_COLOR_L ((0x198a << 2) + 0xff900000)
// Read only
// Bit 15: if true valid probed color
// Bit [13:0]  probe_color[29:16]
#define GAMMA_PROBE_COLOR_H ((0x198b << 2) + 0xff900000)
// bit 15:0, 5:6:5 color
#define GAMMA_PROBE_HL_COLOR ((0x198c << 2) + 0xff900000)
// 12:0 pos_x
#define GAMMA_PROBE_POS_X ((0x198d << 2) + 0xff900000)
// 12:0 pos_y
#define GAMMA_PROBE_POS_Y ((0x198e << 2) + 0xff900000)
#define STH1_HS_ADDR ((0x1990 << 2) + 0xff900000)
#define STH1_HE_ADDR ((0x1991 << 2) + 0xff900000)
#define STH1_VS_ADDR ((0x1992 << 2) + 0xff900000)
#define STH1_VE_ADDR ((0x1993 << 2) + 0xff900000)
#define STH2_HS_ADDR ((0x1994 << 2) + 0xff900000)
#define STH2_HE_ADDR ((0x1995 << 2) + 0xff900000)
#define STH2_VS_ADDR ((0x1996 << 2) + 0xff900000)
#define STH2_VE_ADDR ((0x1997 << 2) + 0xff900000)
#define OEH_HS_ADDR ((0x1998 << 2) + 0xff900000)
#define OEH_HE_ADDR ((0x1999 << 2) + 0xff900000)
#define OEH_VS_ADDR ((0x199a << 2) + 0xff900000)
#define OEH_VE_ADDR ((0x199b << 2) + 0xff900000)
#define VCOM_HSWITCH_ADDR ((0x199c << 2) + 0xff900000)
#define VCOM_VS_ADDR ((0x199d << 2) + 0xff900000)
#define VCOM_VE_ADDR ((0x199e << 2) + 0xff900000)
#define CPV1_HS_ADDR ((0x199f << 2) + 0xff900000)
#define CPV1_HE_ADDR ((0x19a0 << 2) + 0xff900000)
#define CPV1_VS_ADDR ((0x19a1 << 2) + 0xff900000)
#define CPV1_VE_ADDR ((0x19a2 << 2) + 0xff900000)
#define CPV2_HS_ADDR ((0x19a3 << 2) + 0xff900000)
#define CPV2_HE_ADDR ((0x19a4 << 2) + 0xff900000)
#define CPV2_VS_ADDR ((0x19a5 << 2) + 0xff900000)
#define CPV2_VE_ADDR ((0x19a6 << 2) + 0xff900000)
#define STV1_HS_ADDR ((0x19a7 << 2) + 0xff900000)
#define STV1_HE_ADDR ((0x19a8 << 2) + 0xff900000)
#define STV1_VS_ADDR ((0x19a9 << 2) + 0xff900000)
#define STV1_VE_ADDR ((0x19aa << 2) + 0xff900000)
#define STV2_HS_ADDR ((0x19ab << 2) + 0xff900000)
#define STV2_HE_ADDR ((0x19ac << 2) + 0xff900000)
#define STV2_VS_ADDR ((0x19ad << 2) + 0xff900000)
#define STV2_VE_ADDR ((0x19ae << 2) + 0xff900000)
#define OEV1_HS_ADDR ((0x19af << 2) + 0xff900000)
#define OEV1_HE_ADDR ((0x19b0 << 2) + 0xff900000)
#define OEV1_VS_ADDR ((0x19b1 << 2) + 0xff900000)
#define OEV1_VE_ADDR ((0x19b2 << 2) + 0xff900000)
#define OEV2_HS_ADDR ((0x19b3 << 2) + 0xff900000)
#define OEV2_HE_ADDR ((0x19b4 << 2) + 0xff900000)
#define OEV2_VS_ADDR ((0x19b5 << 2) + 0xff900000)
#define OEV2_VE_ADDR ((0x19b6 << 2) + 0xff900000)
#define OEV3_HS_ADDR ((0x19b7 << 2) + 0xff900000)
#define OEV3_HE_ADDR ((0x19b8 << 2) + 0xff900000)
#define OEV3_VS_ADDR ((0x19b9 << 2) + 0xff900000)
#define OEV3_VE_ADDR ((0x19ba << 2) + 0xff900000)
#define LCD_PWR_ADDR ((0x19bb << 2) + 0xff900000)
#define LCD_VDD 5
#define LCD_VBL 4
#define LCD_GPI_MSB 3
#define LCD_GPIO 0
#define LCD_PWM0_LO_ADDR ((0x19bc << 2) + 0xff900000)
#define LCD_PWM0_HI_ADDR ((0x19bd << 2) + 0xff900000)
#define LCD_PWM1_LO_ADDR ((0x19be << 2) + 0xff900000)
#define LCD_PWM1_HI_ADDR ((0x19bf << 2) + 0xff900000)
#define INV_CNT_ADDR ((0x19c0 << 2) + 0xff900000)
#define INV_EN 4
#define INV_CNT_MSB 3
#define INV_CNT 0
#define TCON_MISC_SEL_ADDR ((0x19c1 << 2) + 0xff900000)
#define STH2_SEL 12
#define STH1_SEL 11
#define OEH_SEL 10
#define VCOM_SEL 9
#define DB_LINE_SW 8
#define CPV2_SEL 7
#define CPV1_SEL 6
#define STV2_SEL 5
#define STV1_SEL 4
#define OEV_UNITE 3
#define OEV3_SEL 2
#define OEV2_SEL 1
#define OEV1_SEL 0
#define DUAL_PORT_CNTL_ADDR ((0x19c2 << 2) + 0xff900000)
#define OUTPUT_YUV 15
#define DUAL_IDF 12 // 14:12
#define DUAL_ISF 9 // 11:9
#define LCD_ANALOG_SEL_CPH3 8
#define LCD_ANALOG_3PHI_CLK_SEL 7
#define LCD_LVDS_SEL54 6
#define LCD_LVDS_SEL27 5
#define LCD_TTL_SEL 4
#define DUAL_LVDC_EN 3
#define PORT_SWP 2
#define RGB_SWP 1
#define BIT_SWP 0
#define MLVDS_CONTROL ((0x19c3 << 2) + 0xff900000)
#define mLVDS_RESERVED 15 // 15
#define mLVDS_double_pattern 14 // 14
#define mLVDS_ins_reset 8 // 13:8  // each channel has one bit
#define mLVDS_dual_gate 7
#define mLVDS_bit_num 6 // 0-6Bits, 1-8Bits
#define mLVDS_pair_num 5 // 0-3Pairs, 1-6Pairs
#define mLVDS_msb_first 4
#define mLVDS_PORT_SWAP 3
#define mLVDS_MLSB_SWAP 2
#define mLVDS_PN_SWAP 1
#define mLVDS_en 0
#define MLVDS_RESET_PATTERN_HI ((0x19c4 << 2) + 0xff900000)
#define MLVDS_RESET_PATTERN_LO ((0x19c5 << 2) + 0xff900000)
#define mLVDS_reset_pattern 0 // Bit 47:16
#define MLVDS_RESET_PATTERN_EXT ((0x19c6 << 2) + 0xff900000)
#define mLVDS_reset_pattern_ext 0 // Bit 15:0
#define MLVDS_CONFIG_HI ((0x19c7 << 2) + 0xff900000)
#define MLVDS_CONFIG_LO ((0x19c8 << 2) + 0xff900000)
#define mLVDS_reset_offset 29 // Bit 31:29
#define mLVDS_reset_length 23 // Bit 28:23
#define mLVDS_config_reserved 20 // Bit 22:20
#define mLVDS_reset_start_bit12 19 // Bit 19
#define mLVDS_data_write_toggle 18
#define mLVDS_data_write_ini 17
#define mLVDS_data_latch_1_toggle 16
#define mLVDS_data_latch_1_ini 15
#define mLVDS_data_latch_0_toggle 14
#define mLVDS_data_latch_0_ini 13
#define mLVDS_reset_1_select 12 // 0 - same as reset_0, 1 - 1 clock delay of reset_0
#define mLVDS_reset_start 0 // Bit 11:0
#define TCON_DOUBLE_CTL ((0x19c9 << 2) + 0xff900000)
#define tcon_double_ini 8 // Bit 7:0
#define tcon_double_inv 0 // Bit 7:0
#define TCON_PATTERN_HI ((0x19ca << 2) + 0xff900000)
#define TCON_PATTERN_LO ((0x19cb << 2) + 0xff900000)
#define tcon_pattern_loop_data 16 // Bit 15:0
#define tcon_pattern_loop_start 12 // Bit 3:0
#define tcon_pattern_loop_end 8 // Bit 3:0
#define tcon_pattern_enable 0 // Bit 7:0
#define TCON_CONTROL_HI ((0x19cc << 2) + 0xff900000)
#define TCON_CONTROL_LO ((0x19cd << 2) + 0xff900000)
#define tcon_pclk_enable 26 // Bit 5:0 (enable pclk on TCON channel 7 to 2)
#define tcon_pclk_div 24 // Bit 1:0 (control phy clok divide 2,4,6,8)
#define tcon_delay 0 // Bit 23:0 (3 bit for each channel)
#define LVDS_BLANK_DATA_HI ((0x19ce << 2) + 0xff900000)
#define LVDS_BLANK_DATA_LO ((0x19cf << 2) + 0xff900000)
#define LVDS_blank_data_reserved 30 // 31:30
#define LVDS_blank_data_r 20 // 29:20
#define LVDS_blank_data_g 10 // 19:10
#define LVDS_blank_data_b 0 //  9:0
#define LVDS_PACK_CNTL_ADDR ((0x19d0 << 2) + 0xff900000)
#define LVDS_USE_TCON 7
#define LVDS_DUAL 6
#define PN_SWP 5
#define LSB_FIRST 4
#define LVDS_RESV 3
#define ODD_EVEN_SWP 2
#define LVDS_REPACK 0
// New from M3 :
// Bit 15:12 -- Enable OFFSET Double Generate(TOCN7-TCON4)
// Bit 11:0 -- de_hs(old tcon) second offset_hs (new tcon)
#define DE_HS_ADDR ((0x19d1 << 2) + 0xff900000)
// New from M3 :
// Bit 15:12 -- Enable OFFSET Double Generate(TOCN3-TCON0)
#define DE_HE_ADDR ((0x19d2 << 2) + 0xff900000)
#define DE_VS_ADDR ((0x19d3 << 2) + 0xff900000)
#define DE_VE_ADDR ((0x19d4 << 2) + 0xff900000)
#define HSYNC_HS_ADDR ((0x19d5 << 2) + 0xff900000)
#define HSYNC_HE_ADDR ((0x19d6 << 2) + 0xff900000)
#define HSYNC_VS_ADDR ((0x19d7 << 2) + 0xff900000)
#define HSYNC_VE_ADDR ((0x19d8 << 2) + 0xff900000)
#define VSYNC_HS_ADDR ((0x19d9 << 2) + 0xff900000)
#define VSYNC_HE_ADDR ((0x19da << 2) + 0xff900000)
#define VSYNC_VS_ADDR ((0x19db << 2) + 0xff900000)
#define VSYNC_VE_ADDR ((0x19dc << 2) + 0xff900000)
// bit 8 -- vfifo_mcu_enable
// bit 7 -- halt_vs_de
// bit 6 -- R8G8B8_format
// bit 5 -- R6G6B6_format (round to 6 bits)
// bit 4 -- R5G6B5_format
// bit 3 -- dac_dith_sel
// bit 2 -- lcd_mcu_enable_de     -- ReadOnly
// bit 1 -- lcd_mcu_enable_vsync  -- ReadOnly
// bit 0 -- lcd_mcu_enable
#define LCD_MCU_CTL ((0x19dd << 2) + 0xff900000)
// ReadOnly
//   R5G6B5 when R5G6B5_format
//   G8R8   when R8G8B8_format
//   G5R10  Other
#define LCD_MCU_DATA_0 ((0x19de << 2) + 0xff900000)
// ReadOnly
//   G8B8   when R8G8B8_format
//   G5B10  Other
#define LCD_MCU_DATA_1 ((0x19df << 2) + 0xff900000)
// LVDS
#define LVDS_GEN_CNTL ((0x19e0 << 2) + 0xff900000)
//`define LVDS_PHY_CNTL0          8'he1
//`define LVDS_PHY_CNTL1          8'he2
//`define LVDS_PHY_CNTL2          8'he3
//`define LVDS_PHY_CNTL3          8'he4
//`define LVDS_PHY_CNTL4          8'he5
//`define LVDS_PHY_CNTL5          8'he6
#define LVDS_SRG_TEST ((0x19e8 << 2) + 0xff900000)
#define LVDS_BIST_MUX0 ((0x19e9 << 2) + 0xff900000)
#define LVDS_BIST_MUX1 ((0x19ea << 2) + 0xff900000)
#define LVDS_BIST_FIXED0 ((0x19eb << 2) + 0xff900000)
#define LVDS_BIST_FIXED1 ((0x19ec << 2) + 0xff900000)
#define LVDS_BIST_CNTL0 ((0x19ed << 2) + 0xff900000)
#define LVDS_CLKB_CLKA ((0x19ee << 2) + 0xff900000)
#define LVDS_PHY_CLK_CNTL ((0x19ef << 2) + 0xff900000)
#define LVDS_SER_EN ((0x19f0 << 2) + 0xff900000)
//`define LVDS_PHY_CNTL6        8'hf1
//`define LVDS_PHY_CNTL7        8'hf2
//`define LVDS_PHY_CNTL8        8'hf3
#define LVDS_CH_SWAP0 ((0x19e1 << 2) + 0xff900000)
#define LVDS_CH_SWAP1 ((0x19e2 << 2) + 0xff900000)
#define LVDS_CH_SWAP2 ((0x19e3 << 2) + 0xff900000)
//`define MLVDS_CLK_CTL0_HI        8'hf4
//`define MLVDS_CLK_CTL0_LO        8'hf5
//   `define     mlvds_clk_pattern_reserved 31 // Bit 31
//   `define     mpclk_dly                  28 // Bit 2:0
//   `define     mpclk_div                  26 // Bit 1:0 (control phy clok divide 2,4,6,8)
//   `define     use_mpclk                  25 // Bit 0
//   `define     mlvds_clk_half_delay       24 // Bit 0
//   `define     mlvds_clk_pattern           0 // Bit 23:0
//`define MLVDS_DUAL_GATE_WR_START        8'hf6
//   `define     mlvds_dual_gate_wr_start    0 // Bit 12:0
//`define MLVDS_DUAL_GATE_WR_END          8'hf7
//   `define     mlvds_dual_gate_wr_end      0 // Bit 12:0
//
//`define MLVDS_DUAL_GATE_RD_START        8'hf8
//   `define     mlvds_dual_gate_rd_start    0 // Bit 12:0
//`define MLVDS_DUAL_GATE_RD_END          8'hf9
//   `define     mlvds_dual_gate_rd_end      0 // Bit 12:0
//`define MLVDS_SECOND_RESET_CTL          8'hfa
//   `define     mLVDS_2nd_reset_start       0 // Bit 12:0
//
#define MLVDS_DUAL_GATE_CTL_HI ((0x19fb << 2) + 0xff900000)
#define MLVDS_DUAL_GATE_CTL_LO ((0x19fc << 2) + 0xff900000)
//   `define     mlvds_tcon_field_en        24 // Bit 7:0
//   `define     mlvds_dual_gate_reserved   21 // Bit 2:0
//   `define     mlvds_scan_mode_start_line_bit12 20 // Bit 0
//   `define     mlvds_scan_mode_odd        16 // Bit 3:0
//   `define     mlvds_scan_mode_even       12 // Bit 3:0
//   `define     mlvds_scan_mode_start_line  0 // Bit 11:0
//
//`define MLVDS_RESET_CONFIG_HI         8'hfd
//`define MLVDS_RESET_CONFIG_LO         8'hfe
//   `define     mLVDS_reset_range_enable   31 // Bit 0
//   `define     mLVDS_reset_range_inv      30 // Bit 0
//   `define     mLVDS_reset_config_res1    29 // Bit 0
//   `define     mLVDS_reset_range_line_0   16 // Bit 11:0
//   `define     mLVDS_reset_config_res3    13 // Bit 2:0
//   `define     mLVDS_reset_range_line_1    0 // Bit 11:0
//===============================================================
// LCD DRIVER BASE   END
//===============================================================
//
// Closing file:  disp_if_regs.h
//
//===========================================================================
//`define VIU_VCBUS_BASE                8'h1a
//===========================================================================
//
// Reading file:  vregs_clk2.h
//
//===========================================================================
// Video Interface Registers    0xa00 - 0xaff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VIU_VCBUS_BASE = 0x1a
// -----------------------------------------------
#define VIU_ADDR_START ((0x1a00 << 2) + 0xff900000)
#define VIU_ADDR_END ((0x1aff << 2) + 0xff900000)
//`define TRACE_REG 8'ff
//------------------------------------------------------------------------------
// VIU top-level registers 0x00-0x0f
//------------------------------------------------------------------------------
// Bit  0 RW, osd1_reset
// Bit  1 RW, osd2_reset
// Bit  2 RW, vd1_reset
// Bit  3 RW, vd1_fmt_reset
// Bit  4 RW, vd2_reset
// Bit  5 RW, vd2_fmt_reset
// Bit  6 RW, di_dsr1to2_reset
// Bit  7 RW, vpp_reset
// Bit  8 RW, di_if1_reset
// Bit  9 RW, di_if1_fmt_reset
// Bit 10 RW, di_inp_reset
// Bit 11 RW, di_inp_fmt_reset
// Bit 12 RW, di_mem_reset
// Bit 13 RW, di_mem_fmt_reset
// Bit 14 RW, di_nr_wr_mif_reset
// Bit 15 RW, dein_wr_mif_reset
// Bit 16 RW, di_chan2_mif_reset
// Bit 17 RW, di_mtn_wr_mif_reset
// Bit 18 RW, di_mtn_rd_mif_reset
// Bit 19 RW, di_mad_reset
// Bit 20 RW, vdin0_reset
// Bit 21 RW, vdin1_reset
// Bit 22 RW, nrin_mux_reset
// Bit 23 RW, vdin0_wr_reset
// Bit 24 RW, vdin1_wr_reset
// Bit 25 RW, reserved
// Bit 26 RW, d2d3_reset
// Bit 27 RW, di_cont_wr_mif_reset
// Bit 28 RW, di_cont_rd_mif_reset
#define VIU_SW_RESET ((0x1a01 << 2) + 0xff900000)
#define VIU_SW_RESET0 ((0x1a02 << 2) + 0xff900000)
// Bit 0 RW, software reset for mcvecrd_mif
// Bit 1 RW, software reset for mcinfowr_mif
// Bit 2 RW, software reset for mcinford_mif
#define VIU_SECURE_REG ((0x1a04 << 2) + 0xff900000)
// Bit 0 RW, dolby core1_tv secure w and r
// Bit 1 RW, dolby core2 secure w and r
// Bit 2 RW, dolby core3 secure w and r
// Bit 3 RW, for osd1 secure read
// Bit 4 RW, for osd2 secure read
#define DOLBY_INT_STAT ((0x1a05 << 2) + 0xff900000)
// todo
// bit 15:12 osdbld_gclk_ctrl 3:2 regclk ctrl 1:0 blending clk control
// bit 8 if true, vsync interrupt is generate only field == 0
// bit 7:0 fix_disable
#define VIU_MISC_CTRL0 ((0x1a06 << 2) + 0xff900000)
#define VIU_MISC_CTRL1 ((0x1a07 << 2) + 0xff900000)
// Bit 31:7       Reserved
// Bit 6:4        reg_cfg_err_clr
// Bit 3          Reserved
// Bit 2:0        reg_cfg_done
#define VIU_SECURE_DUMMY ((0x1a08 << 2) + 0xff900000)
#define VIU_SECURE_ST_RO ((0x1a09 << 2) + 0xff900000)
// Bit 31:30 vdin0 dout splitter, bit 0 turns on vdin0 to old path, bit 1 turns on vdin0 to
// d2d3_intf vdin0 input path Bit 29:28 vdin1 dout splitter, bit 0 turns on vdin1 to old path, bit
// 1 turns on vdin1 to d2d3_intf vdin1 input path Bit 27:26 NR write dout splitter, bit 0 turns on
// NR write to old path, bit 1 turns on NR WR to d2d3_intf NR WR input path Bit 23 if true, turn
// on clk_d2d3_reg (register clock) Bit 22 if true, turn on clk_d2d3 Bit 21 reg_v1_go_line Bit 20
// reg_v1_go_field Bit 19 reg_v0_go_field Bit 18:16 v1_gofld_sel, 000: display go_field/go_line,
// 001: DI pre_frame_rst/go_line, 010: vdin0 go_field/go_line,
// 011: vdin1 go_field/go_line, otherwise: force go_field by reg_v1_go_field(bit20), force go_line
// by reg_v1_go_line(bit21)
// Bit 15:13 v0_gofld_sel, 000: display go_field, 001: DI pre_frame_rst, 010: vdin0 go_field, 011:
// vdin1 go_field, otherwise: force go_field by reg_v0_go_field(bit19) Bit 12:6 hole_lines for
// d2d3 depth read interface Bit 5:4 d2d3_v1_sel, 2'b01: video display read interface(DI or vd1
// fomart output), 2'b10: scale output, otherwise nothing as v1 Bit 3 use_vdin_eol, if true, use
// vdin eol as the v0_eol, otherwise using length to get the v0_eol Bit 2:0  d2d3_v0_sel  001:
// vdin0, 010: vdin1, 011: NRW, 100: video display read interface(DI or vd1 fomart output), 101:
// vpp scale output
//
// `define D2D3_INTF_CTRL0                 8'h09
#define VD1_AFBCD0_MISC_CTRL ((0x1a0a << 2) + 0xff900000)
#define VD2_AFBCD1_MISC_CTRL ((0x1a0b << 2) + 0xff900000)
#define DOLBY_PATH_CTRL ((0x1a0c << 2) + 0xff900000)
#define WR_BACK_MISC_CTRL ((0x1a0d << 2) + 0xff900000)
#define OSD_PATH_MISC_CTRL ((0x1a0e << 2) + 0xff900000)
#define MALI_AFBCD_TOP_CTRL ((0x1a0f << 2) + 0xff900000)
//------------------------------------------------------------------------------
// OSD1 registers 0x10-0x2f
//------------------------------------------------------------------------------
// Bit    31 Reserved
// Bit    30 RW, enable_free_clk: 1=use free-running clock to drive logics;
//                                0=use gated clock for low power.
// Bit    29 R, test_rd_dsr
// Bit    28 R, osd_done
// Bit 27:24 R, osd_blk_mode
// Bit 23:22 R, osd_blk_ptr
// Bit    21 R, osd_enable
//
// Bit 20:12 RW, global_alpha
// Bit    11 RW, test_rd_en
// Bit 10: 9 Reserved for control signals
// Bit  8: 5 RW, ctrl_mtch_y
// Bit     4 RW, ctrl_422to444
// Bit  3: 0 RW, osd_blk_enable. Bit 0 to enable block 0: 1=enable, 0=disable;
//                               Bit 1 to enable block 1, and so on.
#define VIU_OSD1_CTRL_STAT ((0x1a10 << 2) + 0xff900000)
// Bit 31:26 Reserved
// Bit 25:16 R, fifo_count
// Bit 15    RW, osd_dpath_sel   0-osd1 mif 1-vpu mali afbcd
// Bit 14    RW, replaced_alpha_en
// Bit 13: 6 RW, replaced_alpha
// Bit  5: 4 RW, hold_fifo_lines[6:5]
// Bit     3 RW, rgb2yuv_full_range
// Bit     2 RW, alpha_9b_mode
// Bit     1 RW, reserved
// Bit     0 RW, color_expand_mode
#define VIU_OSD1_CTRL_STAT2 ((0x1a2d << 2) + 0xff900000)
// Bit 31: 9 Reserved
// Bit     8 RW, 0 = Write LUT, 1 = Read LUT
// Bit  7: 0 RW, lut_addr
#define VIU_OSD1_COLOR_ADDR ((0x1a11 << 2) + 0xff900000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU_OSD1_COLOR ((0x1a12 << 2) + 0xff900000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU_OSD1_TCOLOR_AG0 ((0x1a17 << 2) + 0xff900000)
#define VIU_OSD1_TCOLOR_AG1 ((0x1a18 << 2) + 0xff900000)
#define VIU_OSD1_TCOLOR_AG2 ((0x1a19 << 2) + 0xff900000)
#define VIU_OSD1_TCOLOR_AG3 ((0x1a1a << 2) + 0xff900000)
// Bit 31:30 Reserved
// Bit    29 RW, y_rev: 0=normal read, 1=reverse read in Y direction
// Bit    28 RW, x_rev: 0=normal read, 1=reverse read in X direction
// Bit 27:24 Reserved
// Bit 23:16 RW, tbl_addr
// Bit    15 RW, little_endian: 0=big endian, 1=little endian
// Bit    14 RW, rpt_y
// Bit 13:12 RW, interp_ctrl. 0x=No interpolation; 10=Interpolate with previous
//                            pixel; 11=Interpolate with the average value
//                            between previous and next pixel.
// Bit 11: 8 RW, osd_blk_mode
// Bit     7 RW, rgb_en
// Bit     6 RW, tc_alpha_en
// Bit  5: 2 RW, color_matrix
// Bit     1 RW, interlace_en
// Bit     0 RW, interlace_sel_odd
#define VIU_OSD1_BLK0_CFG_W0 ((0x1a1b << 2) + 0xff900000)
#define VIU_OSD1_BLK1_CFG_W0 ((0x1a1f << 2) + 0xff900000)
#define VIU_OSD1_BLK2_CFG_W0 ((0x1a23 << 2) + 0xff900000)
#define VIU_OSD1_BLK3_CFG_W0 ((0x1a27 << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, x_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, x_start
#define VIU_OSD1_BLK0_CFG_W1 ((0x1a1c << 2) + 0xff900000)
#define VIU_OSD1_BLK1_CFG_W1 ((0x1a20 << 2) + 0xff900000)
#define VIU_OSD1_BLK2_CFG_W1 ((0x1a24 << 2) + 0xff900000)
#define VIU_OSD1_BLK3_CFG_W1 ((0x1a28 << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, y_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, y_start
#define VIU_OSD1_BLK0_CFG_W2 ((0x1a1d << 2) + 0xff900000)
#define VIU_OSD1_BLK1_CFG_W2 ((0x1a21 << 2) + 0xff900000)
#define VIU_OSD1_BLK2_CFG_W2 ((0x1a25 << 2) + 0xff900000)
#define VIU_OSD1_BLK3_CFG_W2 ((0x1a29 << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, h_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, h_start
#define VIU_OSD1_BLK0_CFG_W3 ((0x1a1e << 2) + 0xff900000)
#define VIU_OSD1_BLK1_CFG_W3 ((0x1a22 << 2) + 0xff900000)
#define VIU_OSD1_BLK2_CFG_W3 ((0x1a26 << 2) + 0xff900000)
#define VIU_OSD1_BLK3_CFG_W3 ((0x1a2a << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, v_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, v_start
#define VIU_OSD1_BLK0_CFG_W4 ((0x1a13 << 2) + 0xff900000)
#define VIU_OSD1_BLK1_CFG_W4 ((0x1a14 << 2) + 0xff900000)
#define VIU_OSD1_BLK2_CFG_W4 ((0x1a15 << 2) + 0xff900000)
#define VIU_OSD1_BLK3_CFG_W4 ((0x1a16 << 2) + 0xff900000)
// Bit    31 RW, burst_len_sel[2] of [2:0]
// Bit    30 RW, byte_swap: In addition to endian control, further define
//               whether to swap upper and lower byte within a 16-bit mem word.
//               0=No swap; 1=Swap data[15:0] to be {data[7:0], data[15:8]}
// Bit    29 RW, div_swap : swap the 2 64bits words in 128 bit word
// Bit 28:24 RW, fifo_lim : when osd fifo is small than the fifo_lim*16, closed the rq port of
// osd_rd_mif Bit 23:22 RW, fifo_ctrl: 00 : for 1 word in 1 burst , 01 : for  2words in 1burst,
// 10: for 4words in 1burst, 11: reserved Bit 21:20 R,  fifo_st. 0=IDLE, 1=FILL, 2=ABORT Bit    19
// R,  fifo_overflow Bit 18:12 RW, fifo_depth_val, max value=64: set actual fifo depth to
// fifo_depth_val*8. Bit 11:10 RW, burst_len_sel[1:0] of [2:0]. 0=24(default), 1=32, 2=48, 3=64,
// 4=96, 5=128. Bit  9: 5 RW, hold_fifo_lines[4:0] Bit     4 RW, clear_err: one pulse to clear
// fifo_overflow Bit     3 RW, fifo_sync_rst Bit  2: 1 RW, endian Bit     0 RW, urgent
#define VIU_OSD1_FIFO_CTRL_STAT ((0x1a2b << 2) + 0xff900000)
// Bit 31:24 R, Y or R
// Bit 23:16 R, Cb or G
// Bit 15: 8 R, Cr or B
// Bit  7: 0 R, Output Alpha[8:1]
#define VIU_OSD1_TEST_RDDATA ((0x1a2c << 2) + 0xff900000)
// Bit    15 RW, prot_en: 1=Borrow PROT's FIFO storage, either for rotate or non-rotate.
// Bit 12: 0 RW, effective FIFO size when prot_en=1.
#define VIU_OSD1_PROT_CTRL ((0x1a2e << 2) + 0xff900000)
////add for OSD1/2 mali_unpack
#define VIU_OSD1_MALI_UNPACK_CTRL ((0x1a2f << 2) + 0xff900000)
//------------------------------------------------------------------------------
// OSD2 registers 0x30-0x4f  0x64 -0x67
//------------------------------------------------------------------------------
// Bit    31 Reserved
// Bit    30 RW, enable_free_clk: 1=use free-running clock to drive logics;
//                                0=use gated clock for low power.
// Bit    29 R, test_rd_dsr
// Bit    28 R, osd_done
// Bit 27:24 R, osd_blk_mode
// Bit 23:22 R, osd_blk_ptr
// Bit    21 R, osd_enable
//
// Bit 20:12 RW, global_alpha
// Bit    11 RW, test_rd_en
// Bit    10 RW, hl2_en
// Bit     9 RW, hl1_en
// Bit  8: 5 RW, ctrl_mtch_y
// Bit     4 RW, ctrl_422to444
// Bit  3: 0 RW, osd_blk_enable. Bit 0 to enable block 0: 1=enable, 0=disable;
//                               Bit 1 to enable block 1, and so on.
#define VIU_OSD2_CTRL_STAT ((0x1a30 << 2) + 0xff900000)
// Bit 31:26 Reserved
// Bit 25:16 R, fifo_count
// Bit 15    Reserved
// Bit 14    RW, replaced_alpha_en
// Bit 13: 6 RW, replaced_alpha
// Bit  5: 4 RW, hold_fifo_lines[6:5]
// Bit     3 RW, rgb2yuv_full_range
// Bit     2 RW, alpha_9b_mode
// Bit     1 RW, reserved
// Bit     0 RW, color_expand_mode
#define VIU_OSD2_CTRL_STAT2 ((0x1a4d << 2) + 0xff900000)
// Bit 31: 9 Reserved
// Bit     8 RW, 0 = Write LUT, 1 = Read LUT
// Bit  7: 0 RW, lut_addr
#define VIU_OSD2_COLOR_ADDR ((0x1a31 << 2) + 0xff900000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU_OSD2_COLOR ((0x1a32 << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, hl[1-2]_h/v_start
// Bit 15:12 Reserved
// Bit 11: 0 RW, hl[1-2]_h/v_end
#define VIU_OSD2_HL1_H_START_END ((0x1a33 << 2) + 0xff900000)
#define VIU_OSD2_HL1_V_START_END ((0x1a34 << 2) + 0xff900000)
#define VIU_OSD2_HL2_H_START_END ((0x1a35 << 2) + 0xff900000)
#define VIU_OSD2_HL2_V_START_END ((0x1a36 << 2) + 0xff900000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU_OSD2_TCOLOR_AG0 ((0x1a37 << 2) + 0xff900000)
#define VIU_OSD2_TCOLOR_AG1 ((0x1a38 << 2) + 0xff900000)
#define VIU_OSD2_TCOLOR_AG2 ((0x1a39 << 2) + 0xff900000)
#define VIU_OSD2_TCOLOR_AG3 ((0x1a3a << 2) + 0xff900000)
// Bit 31:24 Reserved
// Bit 23:16 RW, tbl_addr
// Bit    15 RW, little_endian: 0=big endian, 1=little endian
// Bit    14 RW, rpt_y
// Bit 13:12 RW, interp_ctrl. 0x=No interpolation; 10=Interpolate with previous
//                            pixel; 11=Interpolate with the average value
//                            between previous and next pixel.
// Bit 11: 8 RW, osd_blk_mode
// Bit     7 RW, rgb_en
// Bit     6 RW, tc_alpha_en
// Bit  5: 2 RW, color_matrix
// Bit     1 RW, interlace_en
// Bit     0 RW, interlace_sel_odd
#define VIU_OSD2_BLK0_CFG_W0 ((0x1a3b << 2) + 0xff900000)
#define VIU_OSD2_BLK1_CFG_W0 ((0x1a3f << 2) + 0xff900000)
#define VIU_OSD2_BLK2_CFG_W0 ((0x1a43 << 2) + 0xff900000)
#define VIU_OSD2_BLK3_CFG_W0 ((0x1a47 << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, x_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, x_start
#define VIU_OSD2_BLK0_CFG_W1 ((0x1a3c << 2) + 0xff900000)
#define VIU_OSD2_BLK1_CFG_W1 ((0x1a40 << 2) + 0xff900000)
#define VIU_OSD2_BLK2_CFG_W1 ((0x1a44 << 2) + 0xff900000)
#define VIU_OSD2_BLK3_CFG_W1 ((0x1a48 << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, y_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, y_start
#define VIU_OSD2_BLK0_CFG_W2 ((0x1a3d << 2) + 0xff900000)
#define VIU_OSD2_BLK1_CFG_W2 ((0x1a41 << 2) + 0xff900000)
#define VIU_OSD2_BLK2_CFG_W2 ((0x1a45 << 2) + 0xff900000)
#define VIU_OSD2_BLK3_CFG_W2 ((0x1a49 << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, h_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, h_start
#define VIU_OSD2_BLK0_CFG_W3 ((0x1a3e << 2) + 0xff900000)
#define VIU_OSD2_BLK1_CFG_W3 ((0x1a42 << 2) + 0xff900000)
#define VIU_OSD2_BLK2_CFG_W3 ((0x1a46 << 2) + 0xff900000)
#define VIU_OSD2_BLK3_CFG_W3 ((0x1a4a << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, v_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, v_start
#define VIU_OSD2_BLK0_CFG_W4 ((0x1a64 << 2) + 0xff900000)
#define VIU_OSD2_BLK1_CFG_W4 ((0x1a65 << 2) + 0xff900000)
#define VIU_OSD2_BLK2_CFG_W4 ((0x1a66 << 2) + 0xff900000)
#define VIU_OSD2_BLK3_CFG_W4 ((0x1a67 << 2) + 0xff900000)
// Bit    31 RW, burst_len_sel[2] of [2:0]
// Bit    30 RW, byte_swap: In addition to endian control, further define
//               whether to swap upper and lower byte within a 16-bit mem word.
//               0=No swap; 1=Swap data[15:0] to be {data[7:0], data[15:8]}
// Bit    29 RW, div_swap : swap the 2 64bits words in 128 bit word
// Bit 28:24 RW, fifo_lim : when osd fifo is small than the fifo_lim*16, closed the rq port of
// osd_rd_mif Bit 23:22 RW, fifo_ctrl: 00 : for 1 word in 1 burst , 01 : for  2words in 1burst,
// 10: for 4words in 1burst, 11: reserved Bit 21:20 R,  fifo_st. 0=IDLE, 1=FILL, 2=ABORT Bit    19
// R,  fifo_overflow
//
// Bit 18:12 RW, fifo_depth_val, max value=64: set actual fifo depth to fifo_depth_val*8.
// Bit 11:10 RW, burst_len_sel[1:0] of [2:0]. 0=24(default), 1=32, 2=48, 3=64, 4=96, 5=128.
// Bit  9: 5 RW, hold_fifo_lines[4:0]
// Bit     4 RW, clear_err: one pulse to clear fifo_overflow
// Bit     3 RW, fifo_sync_rst
// Bit  2: 1 RW, endian
// Bit     0 RW, urgent
#define VIU_OSD2_FIFO_CTRL_STAT ((0x1a4b << 2) + 0xff900000)
// Bit 31:24 R, Y or R
// Bit 23:16 R, Cb or G
// Bit 15: 8 R, Cr or B
// Bit  7: 0 R, Output Alpha[8:1]
#define VIU_OSD2_TEST_RDDATA ((0x1a4c << 2) + 0xff900000)
// Bit    15 RW, prot_en: 1=Borrow PROT's FIFO storage, either for rotate or non-rotate.
// Bit 12: 0 RW, effective FIFO size when prot_en=1.
#define VIU_OSD2_PROT_CTRL ((0x1a4e << 2) + 0xff900000)
#define VIU_GCLK_CTRL ((0x1a4f << 2) + 0xff900000)
//------------------------------------------------------------------------------
// VIU registers 0x50 -0x5f
//------------------------------------------------------------------------------
#define VIU_DATA_SEC ((0x1a50 << 2) + 0xff900000)
#define VIU_FRM_CTRL ((0x1a51 << 2) + 0xff900000)
// Bit   31:30 reserved
// Bit   29    viu0_frm_start       unsigned,default = 0   //pulse
// Bit   28:27 reserved
// Bit   26    viu0_chk_dout_sec    unsigned,default = 0
// Bit   25    viu0_wrbak1_hsyn_en  unsigned,default = 0
// Bit   24    viu0_wrbak0_hsyn_en  unsigned,default = 0
// Bit   23:20 reserved
// Bit   19:17 viu0_frm_phs_mode    unsigned,default = 0
// Bit   16    viu0_frm_start_sel   unsigned,default = 0
// Bit   15:13 reserved
// Bit   12:0  viu0_hold_line_num   unsigned,default = 4
#define VIU_RDMIF_DEPTH ((0x1a52 << 2) + 0xff900000)
#define VIU_FRC_BYP_LATCH_CTRL ((0x1a53 << 2) + 0xff900000)
// Bit   31:1   reserved
// Bit   0      frc_byp_latch_en unsigned,default = 0,1:latch 0:unlatch
#define MALI_AFBCD1_TOP_CTRL ((0x1a55 << 2) + 0xff900000)
#define MALI_AFBCD2_TOP_CTRL ((0x1a56 << 2) + 0xff900000)
#define VD1_HDR_IN_SIZE ((0x1a57 << 2) + 0xff900000)
// Bit   31:29     reserved
// Bit   28:16     vd1_hdr_in_vsize     unsigned,default = 1920 ,//vsize of hdr
// Bit   15:13     reserved
// Bit   12:0      vd1_hdr_in_hsize     unsigned,default = 1080 ,//hsize of hdr
#define VD2_HDR_IN_SIZE ((0x1a58 << 2) + 0xff900000)
// Bit   31:29     reserved
// Bit   28:16     vd2_hdr_in_vsize     unsigned,default = 1920 ,//vsize of hdr
// Bit   15:13     reserved
// Bit   12:0      vd2_hdr_in_hsize     unsigned,default = 1080 ,//hsize of hdr
#define VD3_HDR_IN_SIZE ((0x1a59 << 2) + 0xff900000)
// Bit   31:29     reserved
// Bit   28:16     vd3_hdr_in_vsize     unsigned,default = 1920 ,//vsize of hdr
// Bit   15:13     reserved
// Bit   12:0      vd3_hdr_in_hsize     unsigned,default = 1080 ,//hsize of hdr
#define OSD1_HDR_IN_SIZE ((0x1a5a << 2) + 0xff900000)
// Bit   31:29     reserved
// Bit   28:16     osd1_hdr_in_vsize     unsigned,default = 1920 ,//vsize of hdr
// Bit   15:13     reserved
// Bit   12:0      osd1_hdr_in_hsize     unsigned,default = 1080 ,//hsize of hdr
#define OSD2_HDR_IN_SIZE ((0x1a5b << 2) + 0xff900000)
// Bit   31:29     reserved
// Bit   28:16     osd2_hdr_in_vsize     unsigned,default = 1920 ,//vsize of hdr
// Bit   15:13     reserved
// Bit   12:0      osd2_hdr_in_hsize     unsigned,default = 1080 ,//hsize of hdr
#define OSD3_HDR_IN_SIZE ((0x1a5c << 2) + 0xff900000)
// Bit   31:29     reserved
// Bit   28:16     osd3_hdr_in_vsize     unsigned,default = 1920 ,//vsize of hdr
// Bit   15:13     reserved
// Bit   12:0      osd3_hdr_in_hsize     unsigned,default = 1080 ,//hsize of hdr
#define OSD4_HDR_IN_SIZE ((0x1a5d << 2) + 0xff900000)
// Bit   31:29     reserved
// Bit   28:16     osd4_hdr_in_vsize     unsigned,default = 1920 ,//vsize of hdr
// Bit   15:13     reserved
// Bit   12:0      osd4_hdr_in_hsize     unsigned,default = 1080 ,//hsize of hdr
#define OSD_BLEND_DIN_CTRL ((0x1a5e << 2) + 0xff900000)
// Bit   31:4      reserved
// Bit   3 :0      osd_bld_din_sel     unsigned,default = 0xf
#define DOLBY_PATH_SWAP_CTRL1 ((0x1a70 << 2) + 0xff900000)
// Bit   31:0      reserved
#define DOLBY_PATH_SWAP_CTRL2 ((0x1a71 << 2) + 0xff900000)
// Bit   31:0      reserved
#define VIU_VD1_PATH_CTRL ((0x1a73 << 2) + 0xff900000)
// Bit   31:30  reserved
// Bit   29     dolby_meta_sec       unsigned,default = 0 ,//0:osd unsecurity    1:osd security
// Bit   28     vd1_sec              unsigned,default = 0 ,//0:vd  unsecurity    1:vd  security
// Bit   27:18  reserved
// Bit   17     vd1_din_ext_mode     unsigned,default = 1 ,//0:{2'd0,data}       1:{data,2'd0}
// Bit   16     vd1_dolby_byp        unsigned,default = 1 ,//0:data into dolby   1:bypass dolby
// Bit   15:0   reserved
#define VIU_VD2_PATH_CTRL ((0x1a74 << 2) + 0xff900000)
// Bit   31:29  reserved
// Bit   28     vd2_sec              unsigned,default = 0 ,//0:vd  unsecurity    1:vd  security
// Bit   27:18  reserved
// Bit   17     vd2_din_ext_mode     unsigned,default = 1 ,//0:{2'd0,data}       1:{data,2'd0}
// Bit   16     vd2_dolby_byp        unsigned,default = 1 ,//0:data into dolby   1:bypass dolby
// Bit   15:0   reserved
#define VIU_VD3_PATH_CTRL ((0x1a75 << 2) + 0xff900000)
// Bit   31:29  reserved
// Bit   28     vd3_sec              unsigned,default = 0 ,//0:vd  unsecurity    1:vd  security
// Bit   27:18  reserved
// Bit   17     vd3_din_ext_mode     unsigned,default = 1 ,//0:{2'd0,data}       1:{data,2'd0}
// Bit   16     vd3_dolby_byp        unsigned,default = 1 ,//0:data into dolby   1:bypass dolby
// Bit   15:0   reserved
#define VIU_OSD1_PATH_CTRL ((0x1a76 << 2) + 0xff900000)
// Bit   31     reg_osd2_axi_sel     unsigned,default = 0 ,//0:mif               1:afbcd
// Bit   30     reserved
// Bit   29     mali_afbcd0_sec      unsigned,default = 0 ,//0:osd unsecurity    1:osd security
// Bit   28     osd2_sec             unsigned,default = 0 ,//0:osd unsecurity    1:osd security
// Bit   27:18  reserved
// Bit   17     osd1_din_ext_mode    unsigned,default = 1 ,//1:{2'd0,data}       0:{data,2'd0}
// Bit   16     osd1_dolby_byp       unsigned,default = 1 ,//0:data into dolby   1:bypass dolby
// Bit   15:5   reserved
// Bit   4      osd1_bld_din_sel     unsigned,default = 1 ,//0:osd_data to osd_bld 1:osd_data_byp
// osd_bld Bit   3      reserved Bit   2      osd1_sc_cmp_byp      unsigned,default = 0 ,//0:open
// data_convert 1:bypass data_convert Bit   1      osd1_sc_cmp_mode     unsigned,default = 1
// ,//0:{2'd0,data}       1:{data,2'd0} Bit   0      osd1_sc_path_sel     unsigned,default = 0
// ,//0:after HDR         1:before osd_blend
#define VIU_OSD2_PATH_CTRL ((0x1a77 << 2) + 0xff900000)
// Bit   31     reg_osd2_axi_sel     unsigned,default = 0 ,//0:mif               1:afbcd
// Bit   30:29  reserved
// Bit   28     osd2_sec             unsigned,default = 0 ,//0:osd unsecurity    1:osd security
// Bit   27:18  reserved
// Bit   17     osd2_din_ext_mode    unsigned,default = 1 ,//1:{2'd0,data}       0:{data,2'd0}
// Bit   16     osd2_dolby_byp       unsigned,default = 1 ,//0:data into dolby   1:bypass dolby
// Bit   15:5   reserved
// Bit   4      osd2_bld_din_sel     unsigned,default = 1 ,//0:osd_data to osd_bld 1:osd_data_byp
// osd_bld Bit   3      reserved Bit   2      osd2_sc_cmp_byp      unsigned,default = 0 ,//0:open
// data_convert 1:bypass data_convert Bit   1      osd2_sc_cmp_mode     unsigned,default = 1
// ,//0:{2'd0,data}       1:{data,2'd0} Bit   0      osd2_sc_path_sel     unsigned,default = 1
// ,//0:after HDR         1:before osd_blend
#define VIU_OSD3_PATH_CTRL ((0x1a78 << 2) + 0xff900000)
// Bit   31     reg_osd3_axi_sel     unsigned,default = 0 ,//0:mif               1:afbcd
// Bit   30:29  reserved
// Bit   28     osd3_sec             unsigned,default = 0 ,//0:osd unsecurity    1:osd security
// Bit   27:18  reserved
// Bit   17     osd3_din_ext_mode    unsigned,default = 1 ,//1:{2'd0,data}       0:{data,2'd0}
// Bit   16     osd3_dolby_byp       unsigned,default = 1 ,//0:data into dolby   1:bypass dolby
// Bit   15:5   reserved
// Bit   4      osd3_bld_din_sel     unsigned,default = 1 ,//0:osd_data to osd_bld 1:osd_data_byp
// osd_bld Bit   3      reserved Bit   2      osd3_sc_cmp_byp      unsigned,default = 0 ,//0:open
// data_convert 1:bypass data_convert Bit   1      osd3_sc_cmp_mode     unsigned,default = 1
// ,//0:{2'd0,data}       1:{data,2'd0} Bit   0      osd3_sc_path_sel     unsigned,default = 1
// ,//0:after HDR         1:before osd_blend
#define VIU_OSD4_PATH_CTRL ((0x1a79 << 2) + 0xff900000)
// Bit   31     reg_osd4_axi_sel     unsigned,default = 0 ,//0:mif               1:afbcd
// Bit   30:29  reserved
// Bit   28     osd4_sec             unsigned,default = 0 ,//0:osd unsecurity    1:osd security
// Bit   27:18  reserved
// Bit   17     osd4_din_ext_mode    unsigned,default = 1 ,//1:{2'd0,data}       0:{data,2'd0}
// Bit   16     osd4_dolby_byp       unsigned,default = 1 ,//0:data into dolby   1:bypass dolby
// Bit   15:5   reserved
// Bit   4      osd4_bld_din_sel     unsigned,default = 1 ,//0:osd_data to osd_bld 1:osd_data_byp
// osd_bld Bit   3      reserved Bit   2      osd4_sc_cmp_byp      unsigned,default = 0 ,//0:open
// data_convert 1:bypass data_convert Bit   1      osd4_sc_cmp_mode     unsigned,default = 1
// ,//0:{2'd0,data}       1:{data,2'd0} Bit   0      osd4_sc_path_sel     unsigned,default = 1
// ,//0:after HDR         1:before osd_blend
#define VD_PATH_MISC_CTRL ((0x1a7a << 2) + 0xff900000)
// Bit   31:0      reserved
#define VPP_PROBE_CTRL ((0x1a7b << 2) + 0xff900000)
#define VPP_PROBE_POS ((0x1a7c << 2) + 0xff900000)
#define VPP_HL_COLOR ((0x1a7d << 2) + 0xff900000)
#define VPP_PROBE_COLOR ((0x1a7e << 2) + 0xff900000)
#define VPP_PROBE_COLOR1 ((0x1a7f << 2) + 0xff900000)
#define VD1_PPS_DUMMY_DATA ((0x1a80 << 2) + 0xff900000)
// Bit   31:24     reserved
// Bit   23:0      vd_pps_dummy_data
#define VD2_PPS_DUMMY_DATA ((0x1a81 << 2) + 0xff900000)
// Bit   31:0      reserved
// Bit   23:0      vd_pps_dummy_data
#define VD3_PPS_DUMMY_DATA ((0x1a82 << 2) + 0xff900000)
// Bit   31:24     reserved
// Bit   23:0      vd_pps_dummy_data
#define VPP_VD1_DSC_CTRL ((0x1a83 << 2) + 0xff900000)
// Bit   31:0  vd1_in_dsc_ctrl  unsigned,default = 0
#define VPP_VD2_DSC_CTRL ((0x1a84 << 2) + 0xff900000)
// Bit   31:0  vd2_in_dsc_ctrl  unsigned,default = 0
#define VPP_VD3_DSC_CTRL ((0x1a85 << 2) + 0xff900000)
// Bit   31:0  vd3_in_dsc_ctrl  unsigned,default = 0
#define VPP_SC_HOLD_LINES ((0x1a88 << 2) + 0xff900000)
// Bit   31:28     reserved
// Bit   27:24     osd4_path_hold_lines unsigned,default = 0 ,//osd4 proc path hold lines
// Bit   23:20     osd3_path_hold_lines unsigned,default = 0 ,//osd3 proc path hold lines
// Bit   19:16     osd2_path_hold_lines unsigned,default = 0 ,//osd2 proc path hold lines
// Bit   15:12     osd1_path_hold_lines unsigned,default = 0 ,//osd1 proc path hold lines
// Bit   11:8      vd3_path_hold_lines  unsigned,default = 0 ,//vd3  proc path hold lines
// Bit   7 :4      vd2_path_hold_lines  unsigned,default = 0 ,//vd2  proc path hold lines
// Bit   3 :0      vd1_path_hold_lines  unsigned,default = 0 ,//vd1  proc path hold lines
#define PATH_START_SEL ((0x1a8a << 2) + 0xff900000)
// Bit   31:14     reserved
// Bit   13:12     osd3_path_start_sel   unsigned,default = 2 ,//0:use vpp0_go_field 1:use
// vpp1_go_field 2:use vpp2_go_field Bit   11:10     reserved Bit   9 :8      osd2_path_start_sel
// unsigned,default = 1 ,//0:use vpp0_go_field 1:use vpp1_go_field 2:use vpp2_go_field Bit   7 :6
// reserved Bit   5 :4      vd3_path_start_sel    unsigned,default = 2 ,//0:use vpp0_go_field
// 1:use vpp1_go_field 2:use vpp2_go_field Bit   3 :2      reserved Bit   1 :0 vd2_path_start_sel
// unsigned,default = 1 ,//0:use vpp0_go_field 1:use vpp1_go_field 2:use vpp2_go_field
#define VIU1_FRM_CTRL ((0x1a8d << 2) + 0xff900000)
// Bit   31:30 reserved
// Bit   29    viu1_frm_start       unsigned,default = 0   //pulse
// Bit   28:27 reserved
// Bit   26    viu1_chk_dout_sec    unsigned,default = 0
// Bit   25    reserved
// Bit   24    viu1_wrbak0_hsyn_en  unsigned,default = 0
// Bit   23:20 reserved
// Bit   19:17 viu1_frm_phs_mode    unsigned,default = 0
// Bit   16    viu1_frm_start_sel   unsigned,default = 0
// Bit   15:13 reserved
// Bit   12:0  viu1_hold_line_num   unsigned,default = 4
#define VIU2_FRM_CTRL ((0x1a8e << 2) + 0xff900000)
// Bit   31:30 reserved
// Bit   29    viu2_frm_start       unsigned,default = 0   //pulse
// Bit   28:27 reserved
// Bit   26    viu1_chk_dout_sec    unsigned,default = 0
// Bit   25    reserved
// Bit   24    viu1_wrbak0_hsyn_en  unsigned,default = 0
// Bit   23:20 reserved
// Bit   19:17 viu2_frm_phs_mode    unsigned,default = 0
// Bit   16    viu2_frm_start_sel   unsigned,default = 0
// Bit   15:13 reserved
// Bit   12:0  viu2_hold_line_num   unsigned,default = 4
#define VPU_SEC_INT_STAT ((0x1a8f << 2) + 0xff900000)
// Bit   31:3  reserved
// Bit   2     vpp0_sec_int_stat  unsigned,default = 0 ,// vppx in sec error int status
// Bit   1     vpp1_sec_int_stat  unsigned,default = 0 ,// vppx in sec error int status
// Bit   0     vpp2_sec_int_stat  unsigned,default = 0 ,// vppx in sec error int status
//------------------------------------------------------------------------------
// OSD1_MATRIX registers 0x90 -0x9f
//------------------------------------------------------------------------------
// Bit 7,  highlight_en
// Bit 6   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before
// matrix Bit 5:4  probe_sel, 00: select matrix 0, 01: select matrix 1,  otherwise select nothing
// Bit 3:2, matrix coef idx selection, 00: select mat0, 01: select mat1, otherwise slect nothing
// Bit 1   mat1 conversion matrix enable
// Bit 0   mat0 conversion matrix enable
#define VIU_OSD1_MATRIX_CTRL ((0x1a90 << 2) + 0xff900000)
// Bit 28:16 coef00
// Bit 12:0  coef01
#define VIU_OSD1_MATRIX_COEF00_01 ((0x1a91 << 2) + 0xff900000)
// Bit 28:16 coef02
// Bit 12:0  coef10
#define VIU_OSD1_MATRIX_COEF02_10 ((0x1a92 << 2) + 0xff900000)
// Bit 28:16 coef11
// Bit 12:0  coef12
#define VIU_OSD1_MATRIX_COEF11_12 ((0x1a93 << 2) + 0xff900000)
// Bit 28:16 coef20
// Bit 12:0  coef21
#define VIU_OSD1_MATRIX_COEF20_21 ((0x1a94 << 2) + 0xff900000)
// Bit 31:30    mat_clmod
// Bit 18:16    mat_convrs
// Bit 12:0     mat_coef42
#define VIU_OSD1_MATRIX_COLMOD_COEF42 ((0x1a95 << 2) + 0xff900000)
// Bit 26:16 offset0
// Bit 10:0  offset1
#define VIU_OSD1_MATRIX_OFFSET0_1 ((0x1a96 << 2) + 0xff900000)
// Bit 10:0  offset2
#define VIU_OSD1_MATRIX_OFFSET2 ((0x1a97 << 2) + 0xff900000)
// Bit 26:16 pre_offset0
// Bit 10:0  pre_offset1
#define VIU_OSD1_MATRIX_PRE_OFFSET0_1 ((0x1a98 << 2) + 0xff900000)
// Bit 10:0  pre_offset2
#define VIU_OSD1_MATRIX_PRE_OFFSET2 ((0x1a99 << 2) + 0xff900000)
// Read only
// Bit 29:20 component 0
// Bit 19:10 component 1
// Bit 9:0 component 2
#define VIU_OSD1_MATRIX_PROBE_COLOR ((0x1a9a << 2) + 0xff900000)
// Bit 23:16 component 0
// Bit 15:8  component 1
// Bit 7:0 component 2
#define VIU_OSD1_MATRIX_HL_COLOR ((0x1a9b << 2) + 0xff900000)
// 28:16 probe x, postion
// 12:0  probe y, position
#define VIU_OSD1_MATRIX_PROBE_POS ((0x1a9c << 2) + 0xff900000)
// Bit 28:16 coef22
// Bit 12:0  coef30
#define VIU_OSD1_MATRIX_COEF22_30 ((0x1a9d << 2) + 0xff900000)
// Bit 28:16 coef31
// Bit 12:0  coef32
#define VIU_OSD1_MATRIX_COEF31_32 ((0x1a9e << 2) + 0xff900000)
// Bit 28:16 coef40
// Bit 12:0  coef41
#define VIU_OSD1_MATRIX_COEF40_41 ((0x1a9f << 2) + 0xff900000)
#define VIU_OSD1_OETF_3X3_OFST_0 ((0x1aa0 << 2) + 0xff900000)
#define VIU_OSD1_OETF_3X3_OFST_1 ((0x1aa1 << 2) + 0xff900000)
//`define OSD_BLENDO_H_START_END          8'ha9       //'d1919
// OSD blending output horizontal start and end
// Bit 28:16 start
// Bit 12:0 end
//`define OSD_BLENDO_V_START_END          8'haa      //'d1079
// OSD blending output vertical start and end
// Bit 28:16 start
// Bit 12:0 end
//`define OSD_BLEND_GEN_CTRL0                 8'hab  //'h2000
// Bit 31:23 const_out_alpha
// Bit 22:14 const_op_alpha
// Bit 13 if true, OSD2 foreground otherwise OSD1 foreground
// Bit 12  OSD BLENDing enable
// Bit 9:8 alpha_op_sel 00: output alpha use osd1_alpha, 01: use osd2_alpha, else use
// const_out_alpha Bit 5:4 color_op_sel 00: use osd1_alpha, 01: use osd2_alpha, else use
// const_op_alpha Bit 1  OSD2 enable Bit 0  OSD1 enable `define OSD_BLEND_GEN_CTRL1 8'hac
// //'h80000 Bit 31    osd1_alpha_premult, if true, osd1 alpha is premultipiled Bit 30
// osd2_alpha_premult, if true, osd2 alpha is premultipiled Bit 23:16 osd blending hold lines Bit
// 13:0  osd blending h_size
//`define OSD_BLEND_DUMMY_DATA                8'had   //0
// Bit 29:20   Y/R
// Bit 19:10   CB/G
// Bit 9:0     Cr/B
//`define OSD_BLEND_CURRENT_XY                8'hae    //read only
// Bit 28:16 current_x
// Bit 12:0 current_y
// Bit 7,  highlight_en
// Bit 6   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before
// matrix Bit 5:4  probe_sel, 00: select matrix 0, 01: select matrix 1,  otherwise select nothing
// Bit 3:2, matrix coef idx selection, 00: select mat0, 01: select mat1, otherwise slect nothing
// Bit 1   mat1 conversion matrix enable
// Bit 0   mat0 conversion matrix enable
//`define VIU_OSD2_MATRIX_CTRL     8'hb0
// Bit 28:16 coef00
// Bit 12:0  coef01
#define VIU_OSD2_MATRIX_COEF00_01 ((0x1ab1 << 2) + 0xff900000)
// Bit 28:16 coef02
// Bit 12:0  coef10
#define VIU_OSD2_MATRIX_COEF02_10 ((0x1ab2 << 2) + 0xff900000)
// Bit 28:16 coef11
// Bit 12:0  coef12
#define VIU_OSD2_MATRIX_COEF11_12 ((0x1ab3 << 2) + 0xff900000)
// Bit 28:16 coef20
// Bit 12:0  coef21
#define VIU_OSD2_MATRIX_COEF20_21 ((0x1ab4 << 2) + 0xff900000)
#define VIU_OSD2_MATRIX_COEF22 ((0x1ab5 << 2) + 0xff900000)
// Bit 26:16 offset0
// Bit 10:0  offset1
#define VIU_OSD2_MATRIX_OFFSET0_1 ((0x1ab6 << 2) + 0xff900000)
// Bit 10:0  offset2
#define VIU_OSD2_MATRIX_OFFSET2 ((0x1ab7 << 2) + 0xff900000)
// Bit 26:16 pre_offset0
// Bit 10:0  pre_offset1
#define VIU_OSD2_MATRIX_PRE_OFFSET0_1 ((0x1ab8 << 2) + 0xff900000)
// Bit 10:0  pre_offset2
#define VIU_OSD2_MATRIX_PRE_OFFSET2 ((0x1ab9 << 2) + 0xff900000)
// Read only
// Bit 29:20 component 0
// Bit 19:10 component 1
// Bit 9:0 component 2
#define VIU_OSD2_MATRIX_PROBE_COLOR ((0x1aba << 2) + 0xff900000)
// Bit 23:16 component 0
// Bit 15:8  component 1
// Bit 7:0 component 2
#define VIU_OSD2_MATRIX_HL_COLOR ((0x1abb << 2) + 0xff900000)
// 28:16 probe x, postion
// 12:0  probe y, position
#define VIU_OSD2_MATRIX_PROBE_POS ((0x1abc << 2) + 0xff900000)
#define VIU_OSD2_MALI_UNPACK_CTRL ((0x1abd << 2) + 0xff900000)
//`define VIU_OSD2_MATRIX_HL_COLOR          8'hbe
//`define VIU_OSD2_MATRIX_PROBE_POS         8'hbf
//     //todo add comment
#define LDIM_STTS_GCLK_CTRL0 ((0x1ac0 << 2) + 0xff900000)
#define LDIM_STTS_CTRL0 ((0x1ac1 << 2) + 0xff900000)
#define LDIM_STTS_WIDTHM1_HEIGHTM1 ((0x1ac2 << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_COEF00_01 ((0x1ac3 << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_COEF02_10 ((0x1ac4 << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_COEF11_12 ((0x1ac5 << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_COEF20_21 ((0x1ac6 << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_COEF22 ((0x1ac7 << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_OFFSET0_1 ((0x1ac8 << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_OFFSET2 ((0x1ac9 << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_PRE_OFFSET0_1 ((0x1aca << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_PRE_OFFSET2 ((0x1acb << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_HL_COLOR ((0x1acc << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_PROBE_POS ((0x1acd << 2) + 0xff900000)
//
//     //read only
#define LDIM_STTS_MATRIX_PROBE_COLOR ((0x1ace << 2) + 0xff900000)
//
//     //Bit 31, local dimming statistic enable
//     //Bit 29, 1: output region histogram 16bit 0:output region histogram 20bit
//     //Bit 28, eol enable
//     //Bit 27:25, vertical line overlap number for max finding
//     //Bit 24:22, horizontal pixel overlap number, 0: 17 pix, 1: 9 pix, 2: 5 pix, 3: 3 pix, 4: 0
//     pix
//     //Bit 20, 1,2,1 low pass filter enable before max/hist statistic
//     //Bit 19:16, region H/V position index, refer to VDIN_LDIM_STTS_HIST_SET_REGION
//     //Bit 15:14, 1: region read index auto increase per block read finished to
//     VDIN_LDIM_STTS_HIST_READ_REGION
//     //			 2: region read index auto increase per read finished to
//     VDIN_LDIM_STTS_HIST_READ_REGION
//     //			 0/3: disable read index self increase
//     //Bit 13:8, region read sub index, which mux the hist & max-finding result to cbus port,
//     refer to LDIM_STTS_HIST_READ_REGION
//     //Bit 6:0, region read index
#define LDIM_STTS_HIST_REGION_IDX ((0x1ad0 << 2) + 0xff900000)
// Bit 28:0, if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h0: read/write hvstart0
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h1: read/write hend01
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h2: read/write vend01
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h3: read/write hend23
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h4: read/write vend23
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h5: read/write hend45
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h6: read/write vend45
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'd7: read/write hend67
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h8: read/write vend67
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h9: read/write hend89
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'ha: read/write vend89
//     //hvstart0, Bit 28:16 row0 vstart, Bit 12:0 col0 hstart
//     //hend01, Bit 28:16 col1 hend, Bit 12:0 col0 hend
//     //vend01, Bit 28:16 row1 vend, Bit 12:0 row0 vend
//     //hend23, Bit 28:16 col3 hend, Bit 12:0 col2 hend
//     //vend23, Bit 28:16 row3 vend, Bit 12:0 row2 vend
//     //hend45, Bit 28:16 col5 hend, Bit 12:0 col4 hend
//     //vend45, Bit 28:16 row5 vend, Bit 12:0 row4 vend
//     //hend67, Bit 28:16 col7 hend, Bit 12:0 col6 hend
//     //vend67, Bit 28:16 row7 vend, Bit 12:0 row6 vend
//     //hend89, Bit 28:16 col9 hend, Bit 12:0 col8 hend
//     //vend89, Bit 28:16 row9 vend, Bit 12:0 row8 vend
#define LDIM_STTS_HIST_SET_REGION ((0x1ad1 << 2) + 0xff900000)
//
//     //if LDIM_STTS_HIST_REGION_IDX[29] == 0, that is output hist with 20bit data.
//     //if LDIM_STTS_HIST_REGION_IDX[21] == 0, that is output 16hist bins in comp 0.
//     //output sequence as rd_sub_idx from 0~47: {max_comp2, comp0_hist0}, {max_comp1,
//     comp0_hist1}, {max_comp0, comp0_hist2},
//     comp0_hist3
//     ... comp2_hist16
//     //if LDIM_STTS_HIST_REGION_IDX[29] == 1, that is output hist with 16bit data.
//     //if LDIM_STTS_HIST_REGION_IDX[21] == 0, that is output 16hist bins in comp 0.
//     //output sequence as rd_sub_idx from 0~47: {max_comp2, max_comp1, max_comp0}, comp0_hist0,
//     comp0_hist1, comp0_hist2
//     comp0_hist3
//     ... comp2_hist16
//     //if LDIM_STTS_HIST_REGION_IDX[29] == 0, that is output hist with 20bit data.
//     //if LDIM_STTS_HIST_REGION_IDX[21] == 1, that is output 32hist bins in comp 0.
//     //output sequence as rd_sub_idx from 0~47: {max_comp2, max_comp1, max_comp0}, comp0_hist0,
//     comp0_hist1, comp0_hist2
//     comp0_hist3 ...comp0_hist31
//     ... comp1_hist16
//
#define LDIM_STTS_HIST_READ_REGION ((0x1ad2 << 2) + 0xff900000)
#define LDIM_STTS_HIST_START_RD_REGION ((0x1ad3 << 2) + 0xff900000)
#define LDIM_STTS_PCTL_TH ((0x1aaf << 2) + 0xff900000)
// Bit 31:27 for all [31] for all eotf enable,[30] for matrix3x3 enable, [29:27] for eotf_ch0~3
// Bit 17:6  for clock gating
// Bit 5:4   pscale_mode ch2
// Bit 3:2   pscale_mode ch1
// Bit 1:0   pscale_mode ch0
#define VIU_OSD1_EOTF_CTL ((0x1ad4 << 2) + 0xff900000)
// Bit 28:16 coef00
// Bit 12:0  coef01
#define VIU_OSD1_EOTF_COEF00_01 ((0x1ad5 << 2) + 0xff900000)
// Bit 28:16 coef02
// Bit 12:0  coef10
#define VIU_OSD1_EOTF_COEF02_10 ((0x1ad6 << 2) + 0xff900000)
// Bit 28:16 coef11
// Bit 12:0  coef12
#define VIU_OSD1_EOTF_COEF11_12 ((0x1ad7 << 2) + 0xff900000)
// Bit 28:16 coef20
// Bit 12:0  coef21
#define VIU_OSD1_EOTF_COEF20_21 ((0x1ad8 << 2) + 0xff900000)
// Bit 28:16 coef22
// Bit   2:0 coef_rs
#define VIU_OSD1_EOTF_COEF22_RS ((0x1ad9 << 2) + 0xff900000)
#define VIU_OSD1_EOTF_LUT_ADDR_PORT ((0x1ada << 2) + 0xff900000)
#define VIU_OSD1_EOTF_LUT_DATA_PORT ((0x1adb << 2) + 0xff900000)
// Bit 31:29  for OETF ch0~ch2
// Bit 21:12  for clock gating
// Bit 11:8   for oetf_scl_ch2
// Bit  7:4   for oetf_scl_ch1
// Bit  3:0   for oetf_scl_ch0
#define VIU_OSD1_OETF_CTL ((0x1adc << 2) + 0xff900000)
#define VIU_OSD1_OETF_LUT_ADDR_PORT ((0x1add << 2) + 0xff900000)
#define VIU_OSD1_OETF_LUT_DATA_PORT ((0x1ade << 2) + 0xff900000)
// can use 8'hdf 8'hcf
#define VIU_OSD1_DIMM_CTRL ((0x1adf << 2) + 0xff900000)
#define VIU_OSD2_DIMM_CTRL ((0x1acf << 2) + 0xff900000)
//------------------------------------------------------------------------------
// OSD1_MATRIX registers 0xe0 -0xfe
//------------------------------------------------------------------------------
// the segment of afbc dec is 8'he0-8'hfe
//`define AFBC_DEC_OFFSET   8'he0
//
// Reading file:  afbc_dec_regs.h
//
// synopsys translate_off
// synopsys translate_on
////===============================////
//// reg
////===============================////
#define AFBC_ENABLE ((0x1ae0 << 2) + 0xff900000)
// Bit   31:29,    reserved
// Bit   28:23,    reg_gclk_ctrl_core     unsigned, default = 0
// Bit   22,       reg_fmt_size_sw_mode   unsigned, default = 0, 0:hw mode 1:sw mode for format
// size Bit   21,       reg_addr_link_en  unsigned, default = 1, 1:enable Bit   20,
// reg_fmt444_comb unsigned, default = 0, 0: 444 8bit uncomb Bit   19,       reg_dos_uncomp_mode
// unsigned  , default = 0 Bit   18:16,    soft_rst          unsigned  , default = 4 Bit   15:14,
// reserved Bit   13:12,    ddr_blk_size      unsigned  , default = 1 Bit   11:9,     cmd_blk_size
// unsigend  , default = 3 Bit   8,        dec_enable        unsigned  , default = 0 Bit   7:2,
// reserved Bit   1,        head_len_sel      unsigned  , default = 1 Bit   0, dec_frm_start
// unsigned  , default = 0
#define AFBC_MODE ((0x1ae1 << 2) + 0xff900000)
// Bit   31:30,    reserved
// Bit   29,       ddr_sz_mode       uns, default = 0 , 0: fixed block ddr size 1 : unfixed block
// ddr size; Bit   28,       blk_mem_mode      uns, default = 0 , 0: fixed 16x128 size; 1 : fixed
// 12x128 size Bit   27:26,    rev_mode          uns, default = 0 , reverse mode Bit   25:24,
// mif_urgent        uns, default = 3 , info mif and data mif urgent Bit   23,       reserved Bit
// 22:16,    hold_line_num     uns, default = 4 , Bit   15:14,    burst_len         uns, default =
// 2, 0: burst1 1:burst2 2:burst4 Bit   13:8,     compbits_yuv      uns, default = 0 ,
//                                  bit 1:0,: y  component bitwidth : 00-8bit 01-9bit 10-10bit
//                                  11-12bit bit 3:2,: u  component bitwidth : 00-8bit 01-9bit
//                                  10-10bit 11-12bit bit 5:4,: v  component bitwidth : 00-8bit
//                                  01-9bit 10-10bit 11-12bit
// Bit   7:6,      vert_skip_y       uns, default = 0 , luma vert skip mode : 00-y0y1, 01-y0,
// 10-y1, 11-(y0+y1)/2 Bit   5:4,      horz_skip_y       uns, default = 0 , luma horz skip mode :
// 00-y0y1, 01-y0, 10-y1, 11-(y0+y1)/2 Bit   3:2,      vert_skip_uv      uns, default = 0 , chroma
// vert skip mode : 00-y0y1, 01-y0, 10-y1, 11-(y0+y1)/2 Bit   1:0,      horz_skip_uv      uns,
// default = 0 , chroma horz skip mode : 00-y0y1, 01-y0, 10-y1, 11-(y0+y1)/2
#define AFBC_SIZE_IN ((0x1ae2 << 2) + 0xff900000)
// Bit   31:29,    reserved
// Bit   28:16     hsize_in          uns, default = 1920 , pic horz size in  unit: pixel
// Bit   15:13,    reserved
// Bit   12:0,     vsize_in          uns, default = 1080 , pic vert size in  unit: pixel
#define AFBC_DEC_DEF_COLOR ((0x1ae3 << 2) + 0xff900000)
// Bit   31:30,   reserved
// Bit   29:20,   def_color_y        uns, default = 255, afbc dec y default setting value
// Bit   19:10,   def_color_u        uns, default = 128, afbc dec u default setting value
// Bit    9: 0,   def_color_v        uns, default = 128, afbc dec v default setting value
#define AFBC_CONV_CTRL ((0x1ae4 << 2) + 0xff900000)
// Bit   31:14,   reserved
// Bit   13:12,   fmt_mode            uns, default = 2, 0:yuv444 1:yuv422 2:yuv420
// Bit   11: 0,   conv_lbuf_len       uns, default = 256, unit=16 pixel need to set = 2^n
#define AFBC_LBUF_DEPTH ((0x1ae5 << 2) + 0xff900000)
// Bit   31:28,   reserved
// Bit   27:16,   dec_lbuf_depth      uns, default = 128; // unit= 8 pixel
// Bit   15:12,   reserved
// Bit   11:0,    mif_lbuf_depth      uns, default = 128;
#define AFBC_HEAD_BADDR ((0x1ae6 << 2) + 0xff900000)
// Bit   31:0,   mif_info_baddr      uns, default = 32'h0;
#define AFBC_BODY_BADDR ((0x1ae7 << 2) + 0xff900000)
// Bit   31:0,   mif_data_baddr      uns, default = 32'h00010000;
#define AFBC_SIZE_OUT ((0x1ae8 << 2) + 0xff900000)
// Bit   31:29,   reserved
// Bit   28:16,   hsize_out           uns, default = 1920    ; // unit: 1 pixel
// Bit   15:13,   reserved
// Bit    12:0,   vsize_out           uns, default = 1080 ; // unit: 1 pixel
#define AFBC_OUT_YSCOPE ((0x1ae9 << 2) + 0xff900000)
// Bit   31:29,   reserved
// Bit   28:16,   out_vert_bgn        uns, default = 0    ; // unit: 1 pixel
// Bit   15:13,   reserved
// Bit    12:0,   out_vert_end        uns, default = 1079 ; // unit: 1 pixel
#define AFBC_STAT ((0x1aea << 2) + 0xff900000)
// Bit   31:0,   ro_dbg_top_info      uns,
#define AFBC_VD_CFMT_CTRL ((0x1aeb << 2) + 0xff900000)
// Bit 31    cfmt_gclk_bit_dis      uns, default = 0    ; //  it true, disable clock, otherwise
// enable clock Bit 30    cfmt_soft_rst_bit      uns, default = 0    ; //  soft rst bit. Bit 29
// reserved Bit 28    chfmt_rpt_pix          uns, default = 0    ; //  if true, horizontal
// formatter use repeating to generete pixel, otherwise use bilinear interpolation Bit 27:24
// chfmt_ini_phase        uns, default = 0    ; //  horizontal formatter initial phase Bit 23
// chfmt_rpt_p0_en        uns, default = 0    ; //  horizontal formatter repeat pixel 0 enable Bit
// 22:21 chfmt_yc_ratio         uns, default = 0    ; //  horizontal Y/C ratio, 00: 1:1, 01: 2:1,
// 10: 4:1 Bit 20    chfmt_en               uns, default = 0    ; //  horizontal formatter enable
// Bit 19    cvfmt_phase0_always_en uns, default = 0    ; //if true, always use phase0 while
// vertical formater, meaning always
//          repeat data, no interpolation
// Bit 18    cvfmt_rpt_last_dis     uns, default = 0    ; //if true, disable vertical formatter
// chroma repeat last line Bit 17    cvfmt_phase0_nrpt_en   uns, default = 0    ; //veritcal
// formatter dont need repeat line on phase0, 1: enable, 0: disable Bit 16    cvfmt_rpt_line0_en
// uns, default = 0    ; //veritcal formatter repeat line 0 enable Bit 15:12 cvfmt_skip_line_num
// uns, default = 0    ; //vertical formatter skip line num at the beginning Bit 11:8
// cvfmt_ini_phase        uns, default = 0    ; //vertical formatter initial phase Bit 7:1
// cvfmt_phase_step       uns, default = 0    ; //vertical formatter phase step (3.4) Bit 0
// cvfmt_en               uns, default = 0    ; //vertical formatter enable
#define AFBC_VD_CFMT_W ((0x1aec << 2) + 0xff900000)
// Bit 31:29 reserved
// Bit 28:16 chfmt_w                uns, default = 0    ;horizontal formatter width
// Bit 15:13 reserved
// Bit 12:0  cvfmt_w                uns, default = 0    ;vertical formatter width
#define AFBC_MIF_HOR_SCOPE ((0x1aed << 2) + 0xff900000)
// Bit   31:26,   reserved
// Bit   25:16,   mif_blk_bgn_h        uns, default = 0  ; // unit: 32 pixel/block hor
// Bit   15:10,   reserved
// Bit    9: 0,   mif_blk_end_h        uns, default = 59 ; // unit: 32 pixel/block hor
#define AFBC_MIF_VER_SCOPE ((0x1aee << 2) + 0xff900000)
// Bit   31:28,   reserved
// Bit   27:16,   mif_blk_bgn_v        uns, default = 0  ; // unit: 32 pixel/block ver
// Bit   15:12,   reserved
// Bit   11: 0,   mif_blk_end_v        uns, default = 269; // unit: 32 pixel/block ver
#define AFBC_PIXEL_HOR_SCOPE ((0x1aef << 2) + 0xff900000)
// Bit   31:29,   reserved
// Bit   28:16,   dec_pixel_bgn_h        uns, default = 0  ; // unit: pixel
// Bit   15:13,   reserved
// Bit   12: 0,   dec_pixel_end_h        uns, default = 1919 ; // unit: pixel
#define AFBC_PIXEL_VER_SCOPE ((0x1af0 << 2) + 0xff900000)
// Bit   31:29,   reserved
// Bit   28:16,   dec_pixel_bgn_v        uns, default = 0  ; // unit: pixel
// Bit   15:13,   reserved
// Bit   12: 0,   dec_pixel_end_v        uns, default = 1079 ; // unit: pixel
#define AFBC_VD_CFMT_H ((0x1af1 << 2) + 0xff900000)
// Bit 31:13,    reserved
// Bit 12:0      cfmt_h  uns, default = 142  ; //vertical formatter height
#define AFBCDEC_IQUANT_ENABLE ((0x1af2 << 2) + 0xff900000)
// Bit 31:12        reserved
// Bit  11          reg_quant_expand_en_1  //unsigned, RW, enable for quantization value expansion
// Bit  10          reg_quant_expand_en_0  //unsigned, RW, enable for quantization value expansion
// Bit  9: 8        reg_bcleav_ofst               //signed ,  RW, default = 0  bcleave ofset to
// get lower range, especially under lossy, for v1/v2, x=0 is equivalent, default = -1; Bit  7: 5
// reserved Bit  4           reg_quant_enable_1        // unsigned ,    RW, default = 0  enable
// for quant to get some lossy Bit  3: 1        reserved Bit  0           reg_quant_enable_0 //
// unsigned ,    RW, default = 0  enable for quant to get some lossy
#define AFBCDEC_IQUANT_LUT_1 ((0x1af3 << 2) + 0xff900000)
// Bit 31           reserved
// Bit 30:28        reg_iquant_yclut_0_11     // unsigned ,    RW, default = 0  quantization lut
// for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 27           reserved Bit 26:24
// reg_iquant_yclut_0_10     // unsigned ,    RW, default = 1  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit 23           reserved Bit 22:20        reg_iquant_yclut_0_9 //
// unsigned ,    RW, default = 2  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 19           reserved Bit 18:16        reg_iquant_yclut_0_8      // unsigned ,    RW,
// default = 3  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 15 reserved Bit
// 14:12        reg_iquant_yclut_0_7      // unsigned ,    RW, default = 4  quantization lut for
// mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 11           reserved Bit 10: 8
// reg_iquant_yclut_0_6      // unsigned ,    RW, default = 5  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit  7           reserved Bit  6: 4        reg_iquant_yclut_0_5 //
// unsigned ,    RW, default = 5  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 3           reserved Bit  2: 0        reg_iquant_yclut_0_4      // unsigned ,    RW,
// default = 4 quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
#define AFBCDEC_IQUANT_LUT_2 ((0x1af4 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15           reserved
// Bit 14:12        reg_iquant_yclut_0_3      // unsigned ,    RW, default = 3  quantization lut
// for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 11           reserved Bit 10: 8
// reg_iquant_yclut_0_2      // unsigned ,    RW, default = 2  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit  7           reserved Bit  6: 4        reg_iquant_yclut_0_1 //
// unsigned ,    RW, default = 1  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 3           reserved Bit  2: 0        reg_iquant_yclut_0_0      // unsigned ,    RW,
// default = 0 quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
#define AFBCDEC_IQUANT_LUT_3 ((0x1af5 << 2) + 0xff900000)
// Bit 31           reserved
// Bit 30:28        reg_iquant_yclut_1_11     // unsigned ,    RW, default = 0  quantization lut
// for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 27           reserved Bit 26:24
// reg_iquant_yclut_1_10     // unsigned ,    RW, default = 1  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit 23           reserved Bit 22:20        reg_iquant_yclut_1_9 //
// unsigned ,    RW, default = 2  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 19           reserved Bit 18:16        reg_iquant_yclut_1_8      // unsigned ,    RW,
// default = 3  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 15 reserved Bit
// 14:12        reg_iquant_yclut_1_7      // unsigned ,    RW, default = 4  quantization lut for
// mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 11           reserved Bit 10: 8
// reg_iquant_yclut_1_6      // unsigned ,    RW, default = 5  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit  7           reserved Bit  6: 4        reg_iquant_yclut_1_5 //
// unsigned ,    RW, default = 5  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 3           reserved Bit  2: 0        reg_iquant_yclut_1_4      // unsigned ,    RW,
// default = 4 quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
#define AFBCDEC_IQUANT_LUT_4 ((0x1af6 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15           reserved
// Bit 14:12        reg_iquant_yclut_1_3      // unsigned ,    RW, default = 3  quantization lut
// for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 11           reserved Bit 10: 8
// reg_iquant_yclut_1_2      // unsigned ,    RW, default = 2  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit  7           reserved Bit  6: 4        reg_iquant_yclut_1_1 //
// unsigned ,    RW, default = 1  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 3           reserved Bit  2: 0        reg_iquant_yclut_1_0      // unsigned ,    RW,
// default = 0 quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1) synopsys
// translate_off synopsys translate_on
//
// Closing file:  afbc_dec_regs.h
//
//
// Closing file:  vregs_clk2.h
//
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VENC0A_VCBUS_BASE = 0x1b
// -----------------------------------------------
//===========================================================================
//
// Reading file:  venc_regs.h
//
//===========================================================================
// Video Interface Registers    0xa00 - 0xbff
//===========================================================================
//`define  VENC0A_VCBUS_BASE             8'h1b
// bit 15:8 -- vfifo2vd_vd_sel
// bit 0 -- vfifo2vd_en
#define ENCP_VFIFO2VD_CTL ((0x1b58 << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCP_VFIFO2VD_PIXEL_START ((0x1b59 << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCP_VFIFO2VD_PIXEL_END ((0x1b5a << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCP_VFIFO2VD_LINE_TOP_START ((0x1b5b << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCP_VFIFO2VD_LINE_TOP_END ((0x1b5c << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCP_VFIFO2VD_LINE_BOT_START ((0x1b5d << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCP_VFIFO2VD_LINE_BOT_END ((0x1b5e << 2) + 0xff900000)
// Route the hsync and vsync signals round the chip. There are three
// sources and users of these signals: VIU, internal video encoder, and
// the pins on the chip. Some muxing is still being done in the VIU. It
// was not moved to the venc module so that the same exact VIU code could
// be used both in Twister and Twister2000.
// Bit 2: venc_sync_source (1=>pins, 0=>viu)
// Bit 1: viu_sync_source (1=>pins, 0=>venc)
// Bit 0: vpins_sync_source (1=>venc, 0=>viu)
#define VENC_SYNC_ROUTE ((0x1b60 << 2) + 0xff900000)
#define VENC_VIDEO_EXSRC ((0x1b61 << 2) + 0xff900000)
#define VENC_DVI_SETTING ((0x1b62 << 2) + 0xff900000)
#define VENC_C656_CTRL ((0x1b63 << 2) + 0xff900000)
#define VENC_UPSAMPLE_CTRL0 ((0x1b64 << 2) + 0xff900000)
#define VENC_UPSAMPLE_CTRL1 ((0x1b65 << 2) + 0xff900000)
#define VENC_UPSAMPLE_CTRL2 ((0x1b66 << 2) + 0xff900000)
// Invert control for tcon output
// bit[15:14] -- vsync, hsync,
// bit[13:0] --  oev3, oev2, cpv2, cph3, cph2, cph1, oeh, vcom, stv2, stv1, cpv1, oev1, sth1, sth2
#define TCON_INVERT_CTL ((0x1b67 << 2) + 0xff900000)
#define VENC_VIDEO_PROG_MODE ((0x1b68 << 2) + 0xff900000)
//---- Venc pixel/line info
#define VENC_ENCI_LINE ((0x1b69 << 2) + 0xff900000)
#define VENC_ENCI_PIXEL ((0x1b6a << 2) + 0xff900000)
#define VENC_ENCP_LINE ((0x1b6b << 2) + 0xff900000)
#define VENC_ENCP_PIXEL ((0x1b6c << 2) + 0xff900000)
//---- Status
#define VENC_STATA ((0x1b6d << 2) + 0xff900000)
//---- Interrupt setting
#define VENC_INTCTRL ((0x1b6e << 2) + 0xff900000)
#define VENC_INTFLAG ((0x1b6f << 2) + 0xff900000)
//--------- Video test configuration
#define VENC_VIDEO_TST_EN ((0x1b70 << 2) + 0xff900000)
#define VENC_VIDEO_TST_MDSEL ((0x1b71 << 2) + 0xff900000)
#define VENC_VIDEO_TST_Y ((0x1b72 << 2) + 0xff900000)
#define VENC_VIDEO_TST_CB ((0x1b73 << 2) + 0xff900000)
#define VENC_VIDEO_TST_CR ((0x1b74 << 2) + 0xff900000)
#define VENC_VIDEO_TST_CLRBAR_STRT ((0x1b75 << 2) + 0xff900000)
#define VENC_VIDEO_TST_CLRBAR_WIDTH ((0x1b76 << 2) + 0xff900000)
#define VENC_VIDEO_TST_VDCNT_STSET ((0x1b77 << 2) + 0xff900000)
//----- Video dac setting
#define VENC_VDAC_DACSEL0 ((0x1b78 << 2) + 0xff900000)
#define VENC_VDAC_DACSEL1 ((0x1b79 << 2) + 0xff900000)
#define VENC_VDAC_DACSEL2 ((0x1b7a << 2) + 0xff900000)
#define VENC_VDAC_DACSEL3 ((0x1b7b << 2) + 0xff900000)
#define VENC_VDAC_DACSEL4 ((0x1b7c << 2) + 0xff900000)
#define VENC_VDAC_DACSEL5 ((0x1b7d << 2) + 0xff900000)
#define VENC_VDAC_SETTING ((0x1b7e << 2) + 0xff900000)
#define VENC_VDAC_TST_VAL ((0x1b7f << 2) + 0xff900000)
#define VENC_VDAC_DAC0_GAINCTRL ((0x1bf0 << 2) + 0xff900000)
#define VENC_VDAC_DAC0_OFFSET ((0x1bf1 << 2) + 0xff900000)
#define VENC_VDAC_DAC1_GAINCTRL ((0x1bf2 << 2) + 0xff900000)
#define VENC_VDAC_DAC1_OFFSET ((0x1bf3 << 2) + 0xff900000)
#define VENC_VDAC_DAC2_GAINCTRL ((0x1bf4 << 2) + 0xff900000)
#define VENC_VDAC_DAC2_OFFSET ((0x1bf5 << 2) + 0xff900000)
#define VENC_VDAC_DAC3_GAINCTRL ((0x1bf6 << 2) + 0xff900000)
#define VENC_VDAC_DAC3_OFFSET ((0x1bf7 << 2) + 0xff900000)
#define VENC_VDAC_DAC4_GAINCTRL ((0x1bf8 << 2) + 0xff900000)
#define VENC_VDAC_DAC4_OFFSET ((0x1bf9 << 2) + 0xff900000)
#define VENC_VDAC_DAC5_GAINCTRL ((0x1bfa << 2) + 0xff900000)
#define VENC_VDAC_DAC5_OFFSET ((0x1bfb << 2) + 0xff900000)
#define VENC_VDAC_FIFO_CTRL ((0x1bfc << 2) + 0xff900000)
#define ENCL_TCON_INVERT_CTL ((0x1bfd << 2) + 0xff900000)
//
// Closing file:  venc_regs.h
//
//
// Reading file:  enc480p_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// Video Encoder 480p Registers    0xb80 - 0xbef
//===========================================================================
//-------- Video basic setting
#define ENCP_VIDEO_EN ((0x1b80 << 2) + 0xff900000)
#define ENCP_VIDEO_SYNC_MODE ((0x1b81 << 2) + 0xff900000)
#define ENCP_MACV_EN ((0x1b82 << 2) + 0xff900000)
#define ENCP_VIDEO_Y_SCL ((0x1b83 << 2) + 0xff900000)
#define ENCP_VIDEO_PB_SCL ((0x1b84 << 2) + 0xff900000)
#define ENCP_VIDEO_PR_SCL ((0x1b85 << 2) + 0xff900000)
#define ENCP_VIDEO_SYNC_SCL ((0x1b86 << 2) + 0xff900000)
#define ENCP_VIDEO_MACV_SCL ((0x1b87 << 2) + 0xff900000)
#define ENCP_VIDEO_Y_OFFST ((0x1b88 << 2) + 0xff900000)
#define ENCP_VIDEO_PB_OFFST ((0x1b89 << 2) + 0xff900000)
#define ENCP_VIDEO_PR_OFFST ((0x1b8a << 2) + 0xff900000)
#define ENCP_VIDEO_SYNC_OFFST ((0x1b8b << 2) + 0xff900000)
#define ENCP_VIDEO_MACV_OFFST ((0x1b8c << 2) + 0xff900000)
//----- Video mode
#define ENCP_VIDEO_MODE ((0x1b8d << 2) + 0xff900000)
#define ENCP_VIDEO_MODE_ADV ((0x1b8e << 2) + 0xff900000)
//--------------- Debug pins
#define ENCP_DBG_PX_RST ((0x1b90 << 2) + 0xff900000)
#define ENCP_DBG_LN_RST ((0x1b91 << 2) + 0xff900000)
#define ENCP_DBG_PX_INT ((0x1b92 << 2) + 0xff900000)
#define ENCP_DBG_LN_INT ((0x1b93 << 2) + 0xff900000)
//----------- Video Advanced setting
#define ENCP_VIDEO_YFP1_HTIME ((0x1b94 << 2) + 0xff900000)
#define ENCP_VIDEO_YFP2_HTIME ((0x1b95 << 2) + 0xff900000)
#define ENCP_VIDEO_YC_DLY ((0x1b96 << 2) + 0xff900000)
#define ENCP_VIDEO_MAX_PXCNT ((0x1b97 << 2) + 0xff900000)
#define ENCP_VIDEO_HSPULS_BEGIN ((0x1b98 << 2) + 0xff900000)
#define ENCP_VIDEO_HSPULS_END ((0x1b99 << 2) + 0xff900000)
#define ENCP_VIDEO_HSPULS_SWITCH ((0x1b9a << 2) + 0xff900000)
#define ENCP_VIDEO_VSPULS_BEGIN ((0x1b9b << 2) + 0xff900000)
#define ENCP_VIDEO_VSPULS_END ((0x1b9c << 2) + 0xff900000)
#define ENCP_VIDEO_VSPULS_BLINE ((0x1b9d << 2) + 0xff900000)
#define ENCP_VIDEO_VSPULS_ELINE ((0x1b9e << 2) + 0xff900000)
#define ENCP_VIDEO_EQPULS_BEGIN ((0x1b9f << 2) + 0xff900000)
#define ENCP_VIDEO_EQPULS_END ((0x1ba0 << 2) + 0xff900000)
#define ENCP_VIDEO_EQPULS_BLINE ((0x1ba1 << 2) + 0xff900000)
#define ENCP_VIDEO_EQPULS_ELINE ((0x1ba2 << 2) + 0xff900000)
#define ENCP_VIDEO_HAVON_END ((0x1ba3 << 2) + 0xff900000)
#define ENCP_VIDEO_HAVON_BEGIN ((0x1ba4 << 2) + 0xff900000)
#define ENCP_VIDEO_VAVON_ELINE ((0x1baf << 2) + 0xff900000)
#define ENCP_VIDEO_VAVON_BLINE ((0x1ba6 << 2) + 0xff900000)
#define ENCP_VIDEO_HSO_BEGIN ((0x1ba7 << 2) + 0xff900000)
#define ENCP_VIDEO_HSO_END ((0x1ba8 << 2) + 0xff900000)
#define ENCP_VIDEO_VSO_BEGIN ((0x1ba9 << 2) + 0xff900000)
#define ENCP_VIDEO_VSO_END ((0x1baa << 2) + 0xff900000)
#define ENCP_VIDEO_VSO_BLINE ((0x1bab << 2) + 0xff900000)
#define ENCP_VIDEO_VSO_ELINE ((0x1bac << 2) + 0xff900000)
#define ENCP_VIDEO_SYNC_WAVE_CURVE ((0x1bad << 2) + 0xff900000)
#define ENCP_VIDEO_MAX_LNCNT ((0x1bae << 2) + 0xff900000)
#define ENCP_VIDEO_SY_VAL ((0x1bb0 << 2) + 0xff900000)
#define ENCP_VIDEO_SY2_VAL ((0x1bb1 << 2) + 0xff900000)
#define ENCP_VIDEO_BLANKY_VAL ((0x1bb2 << 2) + 0xff900000)
#define ENCP_VIDEO_BLANKPB_VAL ((0x1bb3 << 2) + 0xff900000)
#define ENCP_VIDEO_BLANKPR_VAL ((0x1bb4 << 2) + 0xff900000)
#define ENCP_VIDEO_HOFFST ((0x1bb5 << 2) + 0xff900000)
#define ENCP_VIDEO_VOFFST ((0x1bb6 << 2) + 0xff900000)
#define ENCP_VIDEO_RGB_CTRL ((0x1bb7 << 2) + 0xff900000)
#define ENCP_VIDEO_FILT_CTRL ((0x1bb8 << 2) + 0xff900000)
#define ENCP_VIDEO_OFLD_VPEQ_OFST ((0x1bb9 << 2) + 0xff900000)
#define ENCP_VIDEO_OFLD_VOAV_OFST ((0x1bba << 2) + 0xff900000)
#define ENCP_VIDEO_MATRIX_CB ((0x1bbb << 2) + 0xff900000)
#define ENCP_VIDEO_MATRIX_CR ((0x1bbc << 2) + 0xff900000)
#define ENCP_VIDEO_RGBIN_CTRL ((0x1bbd << 2) + 0xff900000)
//------------------Macrovision advanced setting
#define ENCP_MACV_BLANKY_VAL ((0x1bc0 << 2) + 0xff900000)
#define ENCP_MACV_MAXY_VAL ((0x1bc1 << 2) + 0xff900000)
#define ENCP_MACV_1ST_PSSYNC_STRT ((0x1bc2 << 2) + 0xff900000)
#define ENCP_MACV_PSSYNC_STRT ((0x1bc3 << 2) + 0xff900000)
#define ENCP_MACV_AGC_STRT ((0x1bc4 << 2) + 0xff900000)
#define ENCP_MACV_AGC_END ((0x1bc5 << 2) + 0xff900000)
#define ENCP_MACV_WAVE_END ((0x1bc6 << 2) + 0xff900000)
#define ENCP_MACV_STRTLINE ((0x1bc7 << 2) + 0xff900000)
#define ENCP_MACV_ENDLINE ((0x1bc8 << 2) + 0xff900000)
#define ENCP_MACV_TS_CNT_MAX_L ((0x1bc9 << 2) + 0xff900000)
#define ENCP_MACV_TS_CNT_MAX_H ((0x1bca << 2) + 0xff900000)
#define ENCP_MACV_TIME_DOWN ((0x1bcb << 2) + 0xff900000)
#define ENCP_MACV_TIME_LO ((0x1bcc << 2) + 0xff900000)
#define ENCP_MACV_TIME_UP ((0x1bcd << 2) + 0xff900000)
#define ENCP_MACV_TIME_RST ((0x1bce << 2) + 0xff900000)
//---------------- VBI control -------------------
#define ENCP_VBI_CTRL ((0x1bd0 << 2) + 0xff900000)
#define ENCP_VBI_SETTING ((0x1bd1 << 2) + 0xff900000)
#define ENCP_VBI_BEGIN ((0x1bd2 << 2) + 0xff900000)
#define ENCP_VBI_WIDTH ((0x1bd3 << 2) + 0xff900000)
#define ENCP_VBI_HVAL ((0x1bd4 << 2) + 0xff900000)
#define ENCP_VBI_DATA0 ((0x1bd5 << 2) + 0xff900000)
#define ENCP_VBI_DATA1 ((0x1bd6 << 2) + 0xff900000)
//----------------C656 OUT Control------------- Grant
#define C656_HS_ST ((0x1be0 << 2) + 0xff900000)
#define C656_HS_ED ((0x1be1 << 2) + 0xff900000)
#define C656_VS_LNST_E ((0x1be2 << 2) + 0xff900000)
#define C656_VS_LNST_O ((0x1be3 << 2) + 0xff900000)
#define C656_VS_LNED_E ((0x1be4 << 2) + 0xff900000)
#define C656_VS_LNED_O ((0x1be5 << 2) + 0xff900000)
#define C656_FS_LNST ((0x1be6 << 2) + 0xff900000)
#define C656_FS_LNED ((0x1be7 << 2) + 0xff900000)
#define ENCP_VRR_CTRL ((0x1be8 << 2) + 0xff900000)
#define ENCP_VRR_ADJ_LMT ((0x1be9 << 2) + 0xff900000)
#define ENCP_VRR_CTRL1 ((0x1bea << 2) + 0xff900000)
#define ENCP_RO_VRR ((0x1bec << 2) + 0xff900000)
#define ENCP_FRC_CTRL ((0x1beb << 2) + 0xff900000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  enc480p_regs.h
//
//
// Reading file:  enci_regs.h
//
//===========================================================================
// Video Interface Registers    0xb00 - 0xb57
//===========================================================================
#define ENCI_VIDEO_MODE ((0x1b00 << 2) + 0xff900000)
#define ENCI_VIDEO_MODE_ADV ((0x1b01 << 2) + 0xff900000)
#define ENCI_VIDEO_FSC_ADJ ((0x1b02 << 2) + 0xff900000)
#define ENCI_VIDEO_BRIGHT ((0x1b03 << 2) + 0xff900000)
#define ENCI_VIDEO_CONT ((0x1b04 << 2) + 0xff900000)
#define ENCI_VIDEO_SAT ((0x1b05 << 2) + 0xff900000)
#define ENCI_VIDEO_HUE ((0x1b06 << 2) + 0xff900000)
#define ENCI_VIDEO_SCH ((0x1b07 << 2) + 0xff900000)
#define ENCI_SYNC_MODE ((0x1b08 << 2) + 0xff900000)
#define ENCI_SYNC_CTRL ((0x1b09 << 2) + 0xff900000)
#define ENCI_SYNC_HSO_BEGIN ((0x1b0a << 2) + 0xff900000)
#define ENCI_SYNC_HSO_END ((0x1b0b << 2) + 0xff900000)
#define ENCI_SYNC_VSO_EVN ((0x1b0c << 2) + 0xff900000)
#define ENCI_SYNC_VSO_ODD ((0x1b0d << 2) + 0xff900000)
#define ENCI_SYNC_VSO_EVNLN ((0x1b0e << 2) + 0xff900000)
#define ENCI_SYNC_VSO_ODDLN ((0x1b0f << 2) + 0xff900000)
#define ENCI_SYNC_HOFFST ((0x1b10 << 2) + 0xff900000)
#define ENCI_SYNC_VOFFST ((0x1b11 << 2) + 0xff900000)
#define ENCI_SYNC_ADJ ((0x1b12 << 2) + 0xff900000)
#define ENCI_RGB_SETTING ((0x1b13 << 2) + 0xff900000)
//`define	ENCI_CMPN_MATRIX_CB		8'h14
//`define	ENCI_CMPN_MATRIX_CR		8'h15
#define ENCI_DE_H_BEGIN ((0x1b16 << 2) + 0xff900000)
#define ENCI_DE_H_END ((0x1b17 << 2) + 0xff900000)
#define ENCI_DE_V_BEGIN_EVEN ((0x1b18 << 2) + 0xff900000)
#define ENCI_DE_V_END_EVEN ((0x1b19 << 2) + 0xff900000)
#define ENCI_DE_V_BEGIN_ODD ((0x1b1a << 2) + 0xff900000)
#define ENCI_DE_V_END_ODD ((0x1b1b << 2) + 0xff900000)
#define ENCI_VBI_SETTING ((0x1b20 << 2) + 0xff900000)
#define ENCI_VBI_CCDT_EVN ((0x1b21 << 2) + 0xff900000)
#define ENCI_VBI_CCDT_ODD ((0x1b22 << 2) + 0xff900000)
#define ENCI_VBI_CC525_LN ((0x1b23 << 2) + 0xff900000)
#define ENCI_VBI_CC625_LN ((0x1b24 << 2) + 0xff900000)
#define ENCI_VBI_WSSDT ((0x1b25 << 2) + 0xff900000)
#define ENCI_VBI_WSS_LN ((0x1b26 << 2) + 0xff900000)
#define ENCI_VBI_CGMSDT_L ((0x1b27 << 2) + 0xff900000)
#define ENCI_VBI_CGMSDT_H ((0x1b28 << 2) + 0xff900000)
#define ENCI_VBI_CGMS_LN ((0x1b29 << 2) + 0xff900000)
#define ENCI_VBI_TTX_HTIME ((0x1b2a << 2) + 0xff900000)
#define ENCI_VBI_TTX_LN ((0x1b2b << 2) + 0xff900000)
#define ENCI_VBI_TTXDT0 ((0x1b2c << 2) + 0xff900000)
#define ENCI_VBI_TTXDT1 ((0x1b2d << 2) + 0xff900000)
#define ENCI_VBI_TTXDT2 ((0x1b2e << 2) + 0xff900000)
#define ENCI_VBI_TTXDT3 ((0x1b2f << 2) + 0xff900000)
#define ENCI_MACV_N0 ((0x1b30 << 2) + 0xff900000)
#define ENCI_MACV_N1 ((0x1b31 << 2) + 0xff900000)
#define ENCI_MACV_N2 ((0x1b32 << 2) + 0xff900000)
#define ENCI_MACV_N3 ((0x1b33 << 2) + 0xff900000)
#define ENCI_MACV_N4 ((0x1b34 << 2) + 0xff900000)
#define ENCI_MACV_N5 ((0x1b35 << 2) + 0xff900000)
#define ENCI_MACV_N6 ((0x1b36 << 2) + 0xff900000)
#define ENCI_MACV_N7 ((0x1b37 << 2) + 0xff900000)
#define ENCI_MACV_N8 ((0x1b38 << 2) + 0xff900000)
#define ENCI_MACV_N9 ((0x1b39 << 2) + 0xff900000)
#define ENCI_MACV_N10 ((0x1b3a << 2) + 0xff900000)
#define ENCI_MACV_N11 ((0x1b3b << 2) + 0xff900000)
#define ENCI_MACV_N12 ((0x1b3c << 2) + 0xff900000)
#define ENCI_MACV_N13 ((0x1b3d << 2) + 0xff900000)
#define ENCI_MACV_N14 ((0x1b3e << 2) + 0xff900000)
#define ENCI_MACV_N15 ((0x1b3f << 2) + 0xff900000)
#define ENCI_MACV_N16 ((0x1b40 << 2) + 0xff900000)
#define ENCI_MACV_N17 ((0x1b41 << 2) + 0xff900000)
#define ENCI_MACV_N18 ((0x1b42 << 2) + 0xff900000)
#define ENCI_MACV_N19 ((0x1b43 << 2) + 0xff900000)
#define ENCI_MACV_N20 ((0x1b44 << 2) + 0xff900000)
#define ENCI_MACV_N21 ((0x1b45 << 2) + 0xff900000)
#define ENCI_MACV_N22 ((0x1b46 << 2) + 0xff900000)
//`define	ENCI_MACV_P_AGC			8'h47
#define ENCI_DBG_PX_RST ((0x1b48 << 2) + 0xff900000)
#define ENCI_DBG_FLDLN_RST ((0x1b49 << 2) + 0xff900000)
#define ENCI_DBG_PX_INT ((0x1b4a << 2) + 0xff900000)
#define ENCI_DBG_FLDLN_INT ((0x1b4b << 2) + 0xff900000)
#define ENCI_DBG_MAXPX ((0x1b4c << 2) + 0xff900000)
#define ENCI_DBG_MAXLN ((0x1b4d << 2) + 0xff900000)
#define ENCI_MACV_MAX_AMP ((0x1b50 << 2) + 0xff900000)
#define ENCI_MACV_PULSE_LO ((0x1b51 << 2) + 0xff900000)
#define ENCI_MACV_PULSE_HI ((0x1b52 << 2) + 0xff900000)
#define ENCI_MACV_BKP_MAX ((0x1b53 << 2) + 0xff900000)
#define ENCI_CFILT_CTRL ((0x1b54 << 2) + 0xff900000)
#define ENCI_CFILT7 ((0x1b55 << 2) + 0xff900000)
#define ENCI_YC_DELAY ((0x1b56 << 2) + 0xff900000)
#define ENCI_VIDEO_EN ((0x1b57 << 2) + 0xff900000)
//
// Closing file:  enci_regs.h
//
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VENC0B_VCBUS_BASE = 0x1c
// -----------------------------------------------
//===========================================================================
//
// Reading file:  venc2_regs.h
//
//===========================================================================
// Venc Registers (Cont.)    0xc00 - 0xcff (VENC registers 0xc00 - 0xcef)
//===========================================================================
//`define  VENC0B_VCBUS_BASE            8'h1c
//`define  VENC1B_VCBUS_BASE            8'h22
//`define  VENC2B_VCBUS_BASE            8'h24
// Program video control signals from ENCI core to DVI/HDMI interface
#define ENCI_DVI_HSO_BEGIN ((0x1c00 << 2) + 0xff900000)
#define ENCI_DVI_HSO_END ((0x1c01 << 2) + 0xff900000)
#define ENCI_DVI_VSO_BLINE_EVN ((0x1c02 << 2) + 0xff900000)
#define ENCI_DVI_VSO_BLINE_ODD ((0x1c03 << 2) + 0xff900000)
#define ENCI_DVI_VSO_ELINE_EVN ((0x1c04 << 2) + 0xff900000)
#define ENCI_DVI_VSO_ELINE_ODD ((0x1c05 << 2) + 0xff900000)
#define ENCI_DVI_VSO_BEGIN_EVN ((0x1c06 << 2) + 0xff900000)
#define ENCI_DVI_VSO_BEGIN_ODD ((0x1c07 << 2) + 0xff900000)
#define ENCI_DVI_VSO_END_EVN ((0x1c08 << 2) + 0xff900000)
#define ENCI_DVI_VSO_END_ODD ((0x1c09 << 2) + 0xff900000)
// Define cmpt and cvbs cb/cr delay after ENCI chroma filters
// Bit 15:12 RW, enci_cb_cvbs_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit 11: 8 RW, enci_cr_cvbs_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit  7: 4 RW, enci_cb_cmpt_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit  3: 0 RW, enci_cr_cmpt_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
#define ENCI_CFILT_CTRL2 ((0x1c0a << 2) + 0xff900000)
#define ENCI_DACSEL_0 ((0x1c0b << 2) + 0xff900000)
#define ENCI_DACSEL_1 ((0x1c0c << 2) + 0xff900000)
#define ENCP_DACSEL_0 ((0x1c0d << 2) + 0xff900000)
#define ENCP_DACSEL_1 ((0x1c0e << 2) + 0xff900000)
#define ENCP_MAX_LINE_SWITCH_POINT ((0x1c0f << 2) + 0xff900000)
#define ENCI_TST_EN ((0x1c10 << 2) + 0xff900000)
#define ENCI_TST_MDSEL ((0x1c11 << 2) + 0xff900000)
#define ENCI_TST_Y ((0x1c12 << 2) + 0xff900000)
#define ENCI_TST_CB ((0x1c13 << 2) + 0xff900000)
#define ENCI_TST_CR ((0x1c14 << 2) + 0xff900000)
#define ENCI_TST_CLRBAR_STRT ((0x1c15 << 2) + 0xff900000)
#define ENCI_TST_CLRBAR_WIDTH ((0x1c16 << 2) + 0xff900000)
#define ENCI_TST_VDCNT_STSET ((0x1c17 << 2) + 0xff900000)
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define ENCI_VFIFO2VD_CTL ((0x1c18 << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCI_VFIFO2VD_PIXEL_START ((0x1c19 << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCI_VFIFO2VD_PIXEL_END ((0x1c1a << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCI_VFIFO2VD_LINE_TOP_START ((0x1c1b << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCI_VFIFO2VD_LINE_TOP_END ((0x1c1c << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCI_VFIFO2VD_LINE_BOT_START ((0x1c1d << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCI_VFIFO2VD_LINE_BOT_END ((0x1c1e << 2) + 0xff900000)
#define ENCI_VFIFO2VD_CTL2 ((0x1c1f << 2) + 0xff900000)
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define ENCT_VFIFO2VD_CTL ((0x1c20 << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCT_VFIFO2VD_PIXEL_START ((0x1c21 << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCT_VFIFO2VD_PIXEL_END ((0x1c22 << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCT_VFIFO2VD_LINE_TOP_START ((0x1c23 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCT_VFIFO2VD_LINE_TOP_END ((0x1c24 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCT_VFIFO2VD_LINE_BOT_START ((0x1c25 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCT_VFIFO2VD_LINE_BOT_END ((0x1c26 << 2) + 0xff900000)
#define ENCT_VFIFO2VD_CTL2 ((0x1c27 << 2) + 0xff900000)
#define ENCT_TST_EN ((0x1c28 << 2) + 0xff900000)
#define ENCT_TST_MDSEL ((0x1c29 << 2) + 0xff900000)
#define ENCT_TST_Y ((0x1c2a << 2) + 0xff900000)
#define ENCT_TST_CB ((0x1c2b << 2) + 0xff900000)
#define ENCT_TST_CR ((0x1c2c << 2) + 0xff900000)
#define ENCT_TST_CLRBAR_STRT ((0x1c2d << 2) + 0xff900000)
#define ENCT_TST_CLRBAR_WIDTH ((0x1c2e << 2) + 0xff900000)
#define ENCT_TST_VDCNT_STSET ((0x1c2f << 2) + 0xff900000)
// Program video control signals from ENCP core to DVI/HDMI interface
#define ENCP_DVI_HSO_BEGIN ((0x1c30 << 2) + 0xff900000)
#define ENCP_DVI_HSO_END ((0x1c31 << 2) + 0xff900000)
#define ENCP_DVI_VSO_BLINE_EVN ((0x1c32 << 2) + 0xff900000)
#define ENCP_DVI_VSO_BLINE_ODD ((0x1c33 << 2) + 0xff900000)
#define ENCP_DVI_VSO_ELINE_EVN ((0x1c34 << 2) + 0xff900000)
#define ENCP_DVI_VSO_ELINE_ODD ((0x1c35 << 2) + 0xff900000)
#define ENCP_DVI_VSO_BEGIN_EVN ((0x1c36 << 2) + 0xff900000)
#define ENCP_DVI_VSO_BEGIN_ODD ((0x1c37 << 2) + 0xff900000)
#define ENCP_DVI_VSO_END_EVN ((0x1c38 << 2) + 0xff900000)
#define ENCP_DVI_VSO_END_ODD ((0x1c39 << 2) + 0xff900000)
#define ENCP_DE_H_BEGIN ((0x1c3a << 2) + 0xff900000)
#define ENCP_DE_H_END ((0x1c3b << 2) + 0xff900000)
#define ENCP_DE_V_BEGIN_EVEN ((0x1c3c << 2) + 0xff900000)
#define ENCP_DE_V_END_EVEN ((0x1c3d << 2) + 0xff900000)
#define ENCP_DE_V_BEGIN_ODD ((0x1c3e << 2) + 0xff900000)
#define ENCP_DE_V_END_ODD ((0x1c3f << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCI_SYNC_LINE_LENGTH ((0x1c40 << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCI_SYNC_PIXEL_EN ((0x1c41 << 2) + 0xff900000)
// Bit 15 - enci_sync_enable
// Bit 14 - encp_sync_enable
// Bit 13 - enct_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCI_SYNC_TO_LINE_EN ((0x1c42 << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define ENCI_SYNC_TO_PIXEL ((0x1c43 << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCP_SYNC_LINE_LENGTH ((0x1c44 << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCP_SYNC_PIXEL_EN ((0x1c45 << 2) + 0xff900000)
// Bit 15 - enci_sync_enable
// Bit 14 - encp_sync_enable
// Bit 13 - enct_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCP_SYNC_TO_LINE_EN ((0x1c46 << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define ENCP_SYNC_TO_PIXEL ((0x1c47 << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCT_SYNC_LINE_LENGTH ((0x1c48 << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCT_SYNC_PIXEL_EN ((0x1c49 << 2) + 0xff900000)
// Bit 15 - enci_sync_enable
// Bit 14 - encp_sync_enable
// Bit 13 - enct_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCT_SYNC_TO_LINE_EN ((0x1c4a << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define ENCT_SYNC_TO_PIXEL ((0x1c4b << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCL_SYNC_LINE_LENGTH ((0x1c4c << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCL_SYNC_PIXEL_EN ((0x1c4d << 2) + 0xff900000)
// Bit 15 - enci_sync_enable
// Bit 14 - encp_sync_enable
// Bit 13 - enct_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCL_SYNC_TO_LINE_EN ((0x1c4e << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define ENCL_SYNC_TO_PIXEL ((0x1c4f << 2) + 0xff900000)
// bit    3 cfg_encp_lcd_scaler_bypass. 1=Do not scale LCD input data;
//                                      0=Scale LCD input data to y [16*4,235*4], c [16*4,240*4].
// bit    2 cfg_encp_vadj_scaler_bypass. 1=Do not scale data to enc480p_vadj;
//                                       0=Scale enc480p_vadj input data to y [16*4,235*4], c
//                                       [16*4,240*4].
// bit    1 cfg_vfifo2vd_out_scaler_bypass. 1=Do not scale vfifo2vd's output vdata;
//                                          0=Scale vfifo2vd's output vdata to y [16,235], c
//                                          [16,240].
// bit    0 cfg_vfifo_din_full_range. 1=Data from viu fifo is full range [0,1023];
//                                    0=Data from viu fifo is y [16*4,235*4], c [16*4,240*4].
#define ENCP_VFIFO2VD_CTL2 ((0x1c50 << 2) + 0xff900000)
// bit 15:1 Reserved.
// bit    0 cfg_int_dvi_sel_rgb. Applicable for using on-chip hdmi tx module only. This bit
// controls correct bit-mapping from
//          Venc to hdmi_tx depending on whether YCbCr or RGB mode.
//                               1=Map data bit from Venc to hdmi_tx for RGB mode;
//                               0=Default. Map data bit from Venc to hdmi_tx for YCbCr mode.
#define VENC_DVI_SETTING_MORE ((0x1c51 << 2) + 0xff900000)
#define VENC_VDAC_DAC4_FILT_CTRL0 ((0x1c54 << 2) + 0xff900000)
#define VENC_VDAC_DAC4_FILT_CTRL1 ((0x1c55 << 2) + 0xff900000)
#define VENC_VDAC_DAC5_FILT_CTRL0 ((0x1c56 << 2) + 0xff900000)
#define VENC_VDAC_DAC5_FILT_CTRL1 ((0x1c57 << 2) + 0xff900000)
// Bit 0   filter_en
#define VENC_VDAC_DAC0_FILT_CTRL0 ((0x1c58 << 2) + 0xff900000)
// dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
// Bit 15:8, coef1,
// Bit 7:0, coef0,
#define VENC_VDAC_DAC0_FILT_CTRL1 ((0x1c59 << 2) + 0xff900000)
// Bit 0   filter_en
#define VENC_VDAC_DAC1_FILT_CTRL0 ((0x1c5a << 2) + 0xff900000)
// dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
// Bit 15:8, coef1,
// Bit 7:0, coef0,
#define VENC_VDAC_DAC1_FILT_CTRL1 ((0x1c5b << 2) + 0xff900000)
// Bit 0   filter_en
#define VENC_VDAC_DAC2_FILT_CTRL0 ((0x1c5c << 2) + 0xff900000)
// dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
// Bit 15:8, coef1,
// Bit 7:0, coef0,
#define VENC_VDAC_DAC2_FILT_CTRL1 ((0x1c5d << 2) + 0xff900000)
// Bit 0   filter_en
#define VENC_VDAC_DAC3_FILT_CTRL0 ((0x1c5e << 2) + 0xff900000)
// dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
// Bit 15:8, coef1,
// Bit 7:0, coef0,
#define VENC_VDAC_DAC3_FILT_CTRL1 ((0x1c5f << 2) + 0xff900000)
//===========================================================================
// ENCT registers
#define ENCT_VIDEO_EN ((0x1c60 << 2) + 0xff900000)
#define ENCT_VIDEO_Y_SCL ((0x1c61 << 2) + 0xff900000)
#define ENCT_VIDEO_PB_SCL ((0x1c62 << 2) + 0xff900000)
#define ENCT_VIDEO_PR_SCL ((0x1c63 << 2) + 0xff900000)
#define ENCT_VIDEO_Y_OFFST ((0x1c64 << 2) + 0xff900000)
#define ENCT_VIDEO_PB_OFFST ((0x1c65 << 2) + 0xff900000)
#define ENCT_VIDEO_PR_OFFST ((0x1c66 << 2) + 0xff900000)
//----- Video mode
#define ENCT_VIDEO_MODE ((0x1c67 << 2) + 0xff900000)
#define ENCT_VIDEO_MODE_ADV ((0x1c68 << 2) + 0xff900000)
//--------------- Debug pins
#define ENCT_DBG_PX_RST ((0x1c69 << 2) + 0xff900000)
#define ENCT_DBG_LN_RST ((0x1c6a << 2) + 0xff900000)
#define ENCT_DBG_PX_INT ((0x1c6b << 2) + 0xff900000)
#define ENCT_DBG_LN_INT ((0x1c6c << 2) + 0xff900000)
//----------- Video Advanced setting
#define ENCT_VIDEO_YFP1_HTIME ((0x1c6d << 2) + 0xff900000)
#define ENCT_VIDEO_YFP2_HTIME ((0x1c6e << 2) + 0xff900000)
#define ENCT_VIDEO_YC_DLY ((0x1c6f << 2) + 0xff900000)
#define ENCT_VIDEO_MAX_PXCNT ((0x1c70 << 2) + 0xff900000)
#define ENCT_VIDEO_HAVON_END ((0x1c71 << 2) + 0xff900000)
#define ENCT_VIDEO_HAVON_BEGIN ((0x1c72 << 2) + 0xff900000)
#define ENCT_VIDEO_VAVON_ELINE ((0x1c73 << 2) + 0xff900000)
#define ENCT_VIDEO_VAVON_BLINE ((0x1c74 << 2) + 0xff900000)
#define ENCT_VIDEO_HSO_BEGIN ((0x1c75 << 2) + 0xff900000)
#define ENCT_VIDEO_HSO_END ((0x1c76 << 2) + 0xff900000)
#define ENCT_VIDEO_VSO_BEGIN ((0x1c77 << 2) + 0xff900000)
#define ENCT_VIDEO_VSO_END ((0x1c78 << 2) + 0xff900000)
#define ENCT_VIDEO_VSO_BLINE ((0x1c79 << 2) + 0xff900000)
#define ENCT_VIDEO_VSO_ELINE ((0x1c7a << 2) + 0xff900000)
#define ENCT_VIDEO_MAX_LNCNT ((0x1c7b << 2) + 0xff900000)
#define ENCT_VIDEO_BLANKY_VAL ((0x1c7c << 2) + 0xff900000)
#define ENCT_VIDEO_BLANKPB_VAL ((0x1c7d << 2) + 0xff900000)
#define ENCT_VIDEO_BLANKPR_VAL ((0x1c7e << 2) + 0xff900000)
#define ENCT_VIDEO_HOFFST ((0x1c7f << 2) + 0xff900000)
#define ENCT_VIDEO_VOFFST ((0x1c80 << 2) + 0xff900000)
#define ENCT_VIDEO_RGB_CTRL ((0x1c81 << 2) + 0xff900000)
#define ENCT_VIDEO_FILT_CTRL ((0x1c82 << 2) + 0xff900000)
#define ENCT_VIDEO_OFLD_VPEQ_OFST ((0x1c83 << 2) + 0xff900000)
#define ENCT_VIDEO_OFLD_VOAV_OFST ((0x1c84 << 2) + 0xff900000)
#define ENCT_VIDEO_MATRIX_CB ((0x1c85 << 2) + 0xff900000)
#define ENCT_VIDEO_MATRIX_CR ((0x1c86 << 2) + 0xff900000)
#define ENCT_VIDEO_RGBIN_CTRL ((0x1c87 << 2) + 0xff900000)
#define ENCT_MAX_LINE_SWITCH_POINT ((0x1c88 << 2) + 0xff900000)
#define ENCT_DACSEL_0 ((0x1c89 << 2) + 0xff900000)
#define ENCT_DACSEL_1 ((0x1c8a << 2) + 0xff900000)
#define ENCT_INBUF_CNTL0 ((0x1c8b << 2) + 0xff900000)
#define ENCT_INBUF_CNTL1 ((0x1c8c << 2) + 0xff900000)
#define ENCT_INBUF_CNT ((0x1c8d << 2) + 0xff900000)
#define ENCT_INBUF_HOLD_CNT ((0x1c8e << 2) + 0xff900000)
#define ENCT_INBUF_FIX_PIX_NUM ((0x1c8f << 2) + 0xff900000)
//===========================================================================
// For ENCL
//===========================================================================
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define ENCL_VFIFO2VD_CTL ((0x1c90 << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCL_VFIFO2VD_PIXEL_START ((0x1c91 << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCL_VFIFO2VD_PIXEL_END ((0x1c92 << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCL_VFIFO2VD_LINE_TOP_START ((0x1c93 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCL_VFIFO2VD_LINE_TOP_END ((0x1c94 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCL_VFIFO2VD_LINE_BOT_START ((0x1c95 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCL_VFIFO2VD_LINE_BOT_END ((0x1c96 << 2) + 0xff900000)
#define ENCL_VFIFO2VD_CTL2 ((0x1c97 << 2) + 0xff900000)
#define ENCL_TST_EN ((0x1c98 << 2) + 0xff900000)
#define ENCL_TST_MDSEL ((0x1c99 << 2) + 0xff900000)
#define ENCL_TST_Y ((0x1c9a << 2) + 0xff900000)
#define ENCL_TST_CB ((0x1c9b << 2) + 0xff900000)
#define ENCL_TST_CR ((0x1c9c << 2) + 0xff900000)
#define ENCL_TST_CLRBAR_STRT ((0x1c9d << 2) + 0xff900000)
#define ENCL_TST_CLRBAR_WIDTH ((0x1c9e << 2) + 0xff900000)
#define ENCL_TST_VDCNT_STSET ((0x1c9f << 2) + 0xff900000)
//===========================================================================
// ENCL registers
#define ENCL_VIDEO_EN ((0x1ca0 << 2) + 0xff900000)
#define ENCL_VIDEO_Y_SCL ((0x1ca1 << 2) + 0xff900000)
#define ENCL_VIDEO_PB_SCL ((0x1ca2 << 2) + 0xff900000)
#define ENCL_VIDEO_PR_SCL ((0x1ca3 << 2) + 0xff900000)
#define ENCL_VIDEO_Y_OFFST ((0x1ca4 << 2) + 0xff900000)
#define ENCL_VIDEO_PB_OFFST ((0x1ca5 << 2) + 0xff900000)
#define ENCL_VIDEO_PR_OFFST ((0x1ca6 << 2) + 0xff900000)
//----- Video mode
#define ENCL_VIDEO_MODE ((0x1ca7 << 2) + 0xff900000)
#define ENCL_VIDEO_MODE_ADV ((0x1ca8 << 2) + 0xff900000)
//--------------- Debug pins
#define ENCL_DBG_PX_RST ((0x1ca9 << 2) + 0xff900000)
#define ENCL_DBG_LN_RST ((0x1caa << 2) + 0xff900000)
#define ENCL_DBG_PX_INT ((0x1cab << 2) + 0xff900000)
#define ENCL_DBG_LN_INT ((0x1cac << 2) + 0xff900000)
//----------- Video Advanced setting
#define ENCL_VIDEO_YFP1_HTIME ((0x1cad << 2) + 0xff900000)
#define ENCL_VIDEO_YFP2_HTIME ((0x1cae << 2) + 0xff900000)
#define ENCL_VIDEO_YC_DLY ((0x1caf << 2) + 0xff900000)
#define ENCL_VIDEO_MAX_PXCNT ((0x1cb0 << 2) + 0xff900000)
#define ENCL_VIDEO_HAVON_END ((0x1cb1 << 2) + 0xff900000)
#define ENCL_VIDEO_HAVON_BEGIN ((0x1cb2 << 2) + 0xff900000)
#define ENCL_VIDEO_VAVON_ELINE ((0x1cb3 << 2) + 0xff900000)
#define ENCL_VIDEO_VAVON_BLINE ((0x1cb4 << 2) + 0xff900000)
#define ENCL_VIDEO_HSO_BEGIN ((0x1cb5 << 2) + 0xff900000)
#define ENCL_VIDEO_HSO_END ((0x1cb6 << 2) + 0xff900000)
#define ENCL_VIDEO_VSO_BEGIN ((0x1cb7 << 2) + 0xff900000)
#define ENCL_VIDEO_VSO_END ((0x1cb8 << 2) + 0xff900000)
#define ENCL_VIDEO_VSO_BLINE ((0x1cb9 << 2) + 0xff900000)
#define ENCL_VIDEO_VSO_ELINE ((0x1cba << 2) + 0xff900000)
#define ENCL_VIDEO_MAX_LNCNT ((0x1cbb << 2) + 0xff900000)
#define ENCL_VIDEO_BLANKY_VAL ((0x1cbc << 2) + 0xff900000)
#define ENCL_VIDEO_BLANKPB_VAL ((0x1cbd << 2) + 0xff900000)
#define ENCL_VIDEO_BLANKPR_VAL ((0x1cbe << 2) + 0xff900000)
#define ENCL_VIDEO_HOFFST ((0x1cbf << 2) + 0xff900000)
#define ENCL_VIDEO_VOFFST ((0x1cc0 << 2) + 0xff900000)
#define ENCL_VIDEO_RGB_CTRL ((0x1cc1 << 2) + 0xff900000)
#define ENCL_VIDEO_FILT_CTRL ((0x1cc2 << 2) + 0xff900000)
#define ENCL_VIDEO_OFLD_VPEQ_OFST ((0x1cc3 << 2) + 0xff900000)
#define ENCL_VIDEO_OFLD_VOAV_OFST ((0x1cc4 << 2) + 0xff900000)
#define ENCL_VIDEO_MATRIX_CB ((0x1cc5 << 2) + 0xff900000)
#define ENCL_VIDEO_MATRIX_CR ((0x1cc6 << 2) + 0xff900000)
#define ENCL_VIDEO_RGBIN_CTRL ((0x1cc7 << 2) + 0xff900000)
#define ENCL_MAX_LINE_SWITCH_POINT ((0x1cc8 << 2) + 0xff900000)
#define ENCL_DACSEL_0 ((0x1cc9 << 2) + 0xff900000)
#define ENCL_DACSEL_1 ((0x1cca << 2) + 0xff900000)
#define ENCT_VIDEO_H_PRE_DE_END ((0x1ccb << 2) + 0xff900000)
#define ENCT_VIDEO_H_PRE_DE_BEGIN ((0x1ccc << 2) + 0xff900000)
#define ENCT_VIDEO_V_PRE_DE_ELINE ((0x1ccd << 2) + 0xff900000)
#define ENCT_VIDEO_V_PRE_DE_BLINE ((0x1cce << 2) + 0xff900000)
#define ENCL_VIDEO_H_PRE_DE_END ((0x1ccf << 2) + 0xff900000)
#define ENCL_VIDEO_H_PRE_DE_BEGIN ((0x1cd0 << 2) + 0xff900000)
#define ENCL_VIDEO_V_PRE_DE_ELINE ((0x1cd1 << 2) + 0xff900000)
#define ENCL_VIDEO_V_PRE_DE_BLINE ((0x1cd2 << 2) + 0xff900000)
#define ENCL_INBUF_CNTL0 ((0x1cd3 << 2) + 0xff900000)
#define ENCL_INBUF_CNTL1 ((0x1cd4 << 2) + 0xff900000)
#define ENCL_INBUF_CNT ((0x1cd5 << 2) + 0xff900000)
#define ENCL_INBUF_HOLD_CNT ((0x1cd6 << 2) + 0xff900000)
#define ENCL_INBUF_FIX_PIX_NUM ((0x1cd7 << 2) + 0xff900000)
#define VENC_VRR_CTRL ((0x1cd8 << 2) + 0xff900000)
// Bit   31    cfg_vsp_din      // W, pulse
// Bit   30    cfg_vrr_clr      // W, pulse
// Bit 23:8    cfg_vsp_dly_num  // R/W, unsigned, default 0
// Bit  7:4    cfg_vrr_frm_ths  // R/W, unsigned, default 0
// Bit  3:2    cfg_vrr_vsp_en   // R/W, unsigned, default 0
// Bit    1    cfg_vrr_mode     // R/W, unsigned, default 0
// Bit    0    cfg_vrr_vsp_sel  // R/W, unsigned, default 0
#define VENC_VRR_ADJ_LMT ((0x1cd9 << 2) + 0xff900000)
// Bit 31:16  cfg_vrr_min_vnum  //R/W, unsigned,
// Bit 15:0   cfg_vrr_max_vnum  //R/W, unsigned,
#define VENC_VRR_CTRL1 ((0x1cda << 2) + 0xff900000)
// Bit 4:1    cfg_vsp_rst_num   //R/W, unsigned, default 1
// Bit   0    cfg_vsp_cnt_rst   //W,pulse
#define VENC_RO_VRR ((0x1cdc << 2) + 0xff900000)
// Bit 23:20   ro_vrr_vsp_cnt   // R,
// Bit 19:16   ro_vrr_max_err   // R,
// Bit 15:0    ro_last_lcnt     // R,
#define ENCL_FRC_CTRL ((0x1cdd << 2) + 0xff900000)
// Bit 13:0   cfg_frc_st_ln     //R/W, unsigned, default 176
#define ENCL_SYNC_CTRL ((0x1cde << 2) + 0xff900000)
// Bit 31      cfg_sync_clr     //  W, unsigned, default 0, cfg_sync_ctrl[31];//0; // pulse
// Bit 24      cfg_sync_mode    //R/W  unsigned, default 0, cfg_sync_ctrl[24];//0;
// Bit 23:20   cfg_ref_loop_num //R/W  unsigned, default 0, cfg_sync_ctrl[23:20];//0;
// Bit 19:16   cfg_din_loop_num //R/W  unsigned, default 0, cfg_sync_ctrl[19:16];//0;
// Bit 15:0    cfg_syn_min_vnum //R/W  unsigned, default 0, cfg_sync_ctrl[15:0];//1920;
#define VPU_VPU_PWM_V0 ((0x1ce0 << 2) + 0xff900000)
#define VPU_VPU_PWM_V1 ((0x1ce1 << 2) + 0xff900000)
#define VPU_VPU_PWM_V2 ((0x1ce2 << 2) + 0xff900000)
#define VPU_VPU_PWM_V3 ((0x1ce3 << 2) + 0xff900000)
#define VPU_VPU_PWM_H0 ((0x1ce4 << 2) + 0xff900000)
#define VPU_VPU_PWM_H1 ((0x1ce5 << 2) + 0xff900000)
#define VPU_VPU_PWM_H2 ((0x1ce6 << 2) + 0xff900000)
#define VPU_VPU_PWM_H3 ((0x1ce7 << 2) + 0xff900000)
#define VPU_VPU_3D_SYNC1 ((0x1ce8 << 2) + 0xff900000)
#define VPU_VPU_3D_SYNC2 ((0x1ce9 << 2) + 0xff900000)
#define VPU_VENC_DUMMY ((0x1cdf << 2) + 0xff900000)
#define VPU_VENC_ERROR ((0x1cea << 2) + 0xff900000)
#define VPU_VENCI_STAT ((0x1ceb << 2) + 0xff900000)
#define VPU_VENCP_STAT ((0x1cec << 2) + 0xff900000)
#define VPU_VENCL_STAT ((0x1ced << 2) + 0xff900000)
#define VPU_VENC_DITH ((0x1cee << 2) + 0xff900000)
#define VPU_VENC_CTRL ((0x1cef << 2) + 0xff900000)
#define VPU_VENCL_DITH_CTRL ((0x1cf0 << 2) + 0xff900000)
#define VPU_VENCL_DITH_LUT_1 ((0x1cf1 << 2) + 0xff900000)
#define VPU_VENCL_DITH_LUT_2 ((0x1cf2 << 2) + 0xff900000)
#define VPU_VENCL_DITH_LUT_3 ((0x1cf3 << 2) + 0xff900000)
#define VPU_VENCL_DITH_LUT_4 ((0x1cf4 << 2) + 0xff900000)
#define VPU_VENCL_DITH_LUT_5 ((0x1cf5 << 2) + 0xff900000)
#define VPU_VENCL_DITH_LUT_6 ((0x1cf6 << 2) + 0xff900000)
#define VPU_VENCL_DITH_LUT_7 ((0x1cf7 << 2) + 0xff900000)
#define VPU_VENCL_DITH_LUT_8 ((0x1cf8 << 2) + 0xff900000)
#define VPU_VENCL_DITH_LUT_9 ((0x1cf9 << 2) + 0xff900000)
#define VPU_VENCL_DITH_LUT_10 ((0x1cfa << 2) + 0xff900000)
#define VPU_VENCL_DITH_LUT_11 ((0x1cfb << 2) + 0xff900000)
#define VPU_VENCL_DITH_LUT_12 ((0x1cfc << 2) + 0xff900000)
//
// Closing file:  venc2_regs.h
//
//===========================================================================
//`define VPP_VCBUS_BASE			     8'h1d
//===========================================================================
//
// Reading file:  vpp_regs.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// CBUS_BASE:  VPP_VCBUS_BASE = 0x1d
// -----------------------------------------------
//===========================================================================
// Video postprocesing Registers
//===========================================================================
// dummy data used in the VPP preblend and scaler
// Bit 23:16    Y
// Bit 15:8     CB
// Bit 7:0      CR
#define VPP_DUMMY_DATA ((0x1d00 << 2) + 0xff900000)
// input line length used in VPP
#define VPP_LINE_IN_LENGTH ((0x1d01 << 2) + 0xff900000)
// input Picture height used in VPP
#define VPP_PIC_IN_HEIGHT ((0x1d02 << 2) + 0xff900000)
// Because there are many coefficients used in the vertical filter and horizontal filters,
// indirect access the coefficients of vertical filter and horizontal filter is used.
// For vertical filter, there are 33x4 coefficients
// For horizontal filter, there are 33x4 coefficients
// Bit 15	index increment, if bit9 == 1  then (0: index increase 1, 1: index increase 2)
// else (index increase 2) Bit 14	1: read coef through cbus enable, just for debug purpose
// in case when we wanna check the coef in ram in correct or not Bit 13    if true, vertical
// separated coef enable Bit 9     if true, use 9bit resolution coef, other use 8bit resolution
// coef Bit 8:7 type of index, 00: vertical coef, 01: vertical chroma coef: 10: horizontal coef,
// 11: resevered Bit 6:0   coef index
#define VPP_SCALE_COEF_IDX ((0x1d03 << 2) + 0xff900000)
// coefficients for vertical filter and horizontal filter
#define VPP_SCALE_COEF ((0x1d04 << 2) + 0xff900000)
// these following registers are the absolute line address pointer for output divided screen
// The output divided screen is shown in the following:
//
//  --------------------------   <------ line zero
//		.
//		.
//		.		    region0        <---------- nonlinear region or nonscaling
// region
//		.
//  ---------------------------
//  ---------------------------  <------ region1_startp
//		.
//		.           region1         <---------- nonlinear region
//		.
//		.
//  ---------------------------
//  ---------------------------  <------ region2_startp
//		.
//		.           region2         <---------- linear region
//		.
//		.
//  ---------------------------
//  ---------------------------  <------ region3_startp
//		.
//		.           region3         <---------- nonlinear region
//		.
//		.
//  ---------------------------
//  ---------------------------  <------ region4_startp
//		.
//		.           region4         <---------- nonlinear region or nonoscaling region
//		.
//		.
//  ---------------------------  <------ region4_endp
// Bit 28:16 region1 startp
// Bit 12:0 region2 startp
#define VPP_VSC_REGION12_STARTP ((0x1d05 << 2) + 0xff900000)
// Bit 28:16 region3 startp
// Bit 12:0 region4 startp
#define VPP_VSC_REGION34_STARTP ((0x1d06 << 2) + 0xff900000)
#define VPP_VSC_REGION4_ENDP ((0x1d07 << 2) + 0xff900000)
// vertical start phase step, (source/dest)*(2^24)
// Bit 27:24 integer part
// Bit 23:0	fraction part
#define VPP_VSC_START_PHASE_STEP ((0x1d08 << 2) + 0xff900000)
// vertical scaler region0 phase slope, Bit24 signed bit
#define VPP_VSC_REGION0_PHASE_SLOPE ((0x1d09 << 2) + 0xff900000)
// vertical scaler region1 phase slope, Bit24 signed bit
#define VPP_VSC_REGION1_PHASE_SLOPE ((0x1d0a << 2) + 0xff900000)
// vertical scaler region3 phase slope, Bit24 signed bit
#define VPP_VSC_REGION3_PHASE_SLOPE ((0x1d0b << 2) + 0xff900000)
// vertical scaler region4 phase slope, Bit24 signed bit
#define VPP_VSC_REGION4_PHASE_SLOPE ((0x1d0c << 2) + 0xff900000)
// Bit 18:17     double line mode, input/output line width of vscaler becomes 2X,
//           so only 2 line buffer in this case, use for 3D line by line interleave scaling
//           bit1 true, double the input width and half input height, bit0 true, change line
//           buffer 2 lines instead of 4 lines
// Bit 16     0: progressive output, 1: interlace output
// Bit 15     vertical scaler output line0 in advance or not for bottom field
// Bit 14:13  vertical scaler initial repeat line0 number for bottom field
// Bit 11:8   vertical scaler initial receiving  number for bottom field
// Bit 7      vertical scaler output line0 in advance or not for top field
// Bit 6:5    vertical scaler initial repeat line0 number for top field
// Bit 3:0    vertical scaler initial receiving  number for top field
#define VPP_VSC_PHASE_CTRL ((0x1d0d << 2) + 0xff900000)
// Bit 31:16  vertical scaler field initial phase for bottom field
// Bit 15:0  vertical scaler field initial phase for top field
#define VPP_VSC_INI_PHASE ((0x1d0e << 2) + 0xff900000)
// Bit 28:16 region1 startp
// Bit 12:0 region2 startp
#define VPP_HSC_REGION12_STARTP ((0x1d10 << 2) + 0xff900000)
// Bit 28:16 region3 startp
// Bit 12:0 region4 startp
#define VPP_HSC_REGION34_STARTP ((0x1d11 << 2) + 0xff900000)
#define VPP_HSC_REGION4_ENDP ((0x1d12 << 2) + 0xff900000)
// horizontal start phase step, (source/dest)*(2^24)
// Bit 27:24 integer part
// Bit 23:0	fraction part
#define VPP_HSC_START_PHASE_STEP ((0x1d13 << 2) + 0xff900000)
// horizontal scaler region0 phase slope, Bit24 signed bit
#define VPP_HSC_REGION0_PHASE_SLOPE ((0x1d14 << 2) + 0xff900000)
// horizontal scaler region1 phase slope, Bit24 signed bit
#define VPP_HSC_REGION1_PHASE_SLOPE ((0x1d15 << 2) + 0xff900000)
// horizontal scaler region3 phase slope, Bit24 signed bit
#define VPP_HSC_REGION3_PHASE_SLOPE ((0x1d16 << 2) + 0xff900000)
// horizontal scaler region4 phase slope, Bit24 signed bit
#define VPP_HSC_REGION4_PHASE_SLOPE ((0x1d17 << 2) + 0xff900000)
// Bit 22:21   horizontal scaler initial repeat pixel0 number0
// Bit 19:16   horizontal scaler initial receiving number0
// Bit 15:0    horizontal scaler top field initial phase0
#define VPP_HSC_PHASE_CTRL ((0x1d18 << 2) + 0xff900000)
// Bit 22 if true, divide VSC line length 2 as the HSC input length, othwise VSC length is the
// same as the VSC line length,
//                 just for special usage, more flexibility
// Bit 21 if true, prevsc uses lin buffer, otherwise prevsc does not use line buffer, it should be
// same as prevsc_en Bit 20 prehsc_en Bit 19 prevsc_en Bit 18 vsc_en Bit 17 hsc_en Bit 16
// scale_top_en Bit 15 video1 scale out enable Bit 12 if true, region0,region4 are nonlinear
// regions, otherwise they are not scaling regions, for horizontal scaler Bit 10:8 horizontal
// scaler bank length Bit 5, vertical scaler phase field mode, if true, disable the opposite
// parity line output, more bandwidth needed if output 1080i Bit 4 if true, region0,region4 are
// nonlinear regions, otherwise they are not scaling regions, for vertical scaler Bit 2:0 vertical
// scaler bank length
#define VPP_SC_MISC ((0x1d19 << 2) + 0xff900000)
// preblend video1 horizontal start and end
// Bit 28:16 start
// Bit 12:0 end
#define VPP_PREBLEND_VD1_H_START_END ((0x1d1a << 2) + 0xff900000)
// preblend video1 vertical start and end
// Bit 28:16 start
// Bit 12:0 end
#define VPP_PREBLEND_VD1_V_START_END ((0x1d1b << 2) + 0xff900000)
// postblend video1 horizontal start and end
// Bit 28:16 start
// Bit 12:0 end
#define VPP_POSTBLEND_VD1_H_START_END ((0x1d1c << 2) + 0xff900000)
// postblend video1 vertical start and end
// Bit 28:16 start
// Bit 12:0 end
#define VPP_POSTBLEND_VD1_V_START_END ((0x1d1d << 2) + 0xff900000)
// preblend/postblend video2 horizontal start and end
// Bit 28:16 start
// Bit 12:0 end
#define VPP_BLEND_VD2_H_START_END ((0x1d1e << 2) + 0xff900000)
// preblend/postblend video2 vertical start and end
// Bit 28:16 start
// Bit 12:0 end
#define VPP_BLEND_VD2_V_START_END ((0x1d1f << 2) + 0xff900000)
// preblend horizontal size
#define VPP_PREBLEND_H_SIZE ((0x1d20 << 2) + 0xff900000)
// postblend horizontal size
#define VPP_POSTBLEND_H_SIZE ((0x1d21 << 2) + 0xff900000)
// VPP hold lines
// Bit 29:24
// Bit 21:16
// Bit 15:8     preblend hold lines
// Bit 7:0      postblend hold lines
#define VPP_HOLD_LINES ((0x1d22 << 2) + 0xff900000)
// Bit 26   if true, automatic change post blend output to one color if field ==1
// Bit 25   if true, change screen to one color value for preblender
// Bit 24   if true, change screen to one color value for postblender
// Bit 23:16 one color Y
// Bit 15:8 one color Cb
// Bit  7:0 one color  Cr
#define VPP_BLEND_ONECOLOR_CTRL ((0x1d23 << 2) + 0xff900000)
// Read Only, VPP preblend current_x, current_y
// Bit 28:16 current_x
// Bit 12:0 current_y
#define VPP_PREBLEND_CURRENT_XY ((0x1d24 << 2) + 0xff900000)
// Read Only, VPP postblend current_x, current_y
// Bit 28:16 current_x
// Bit 12:0 current_y
#define VPP_POSTBLEND_CURRENT_XY ((0x1d25 << 2) + 0xff900000)
// Bit 31  vd1_bgosd_exchange_en for preblend
// Bit 30  vd1_bgosd_exchange_en for postblend
// Bit 28   color management enable
// Bit 27,  if true, vd2 use viu2 output as the input, otherwise use normal vd2 from memory
// Bit 26:18, vd2 alpha
// Bit 17, osd2 enable for preblend
// Bit 16, osd1 enable for preblend
// Bit 15, vd2 enable for preblend
// Bit 14, vd1 enable for preblend
// Bit 13, osd2 enable for postblend
// Bit 12, osd1 enable for postblend
// Bit 11, vd2 enable for postblend
// Bit 10, vd1 enable for postblend
// Bit 9,  if true, osd1 is alpha premultipiled
// Bit 8,  if true, osd2 is alpha premultipiled
// Bit 7,  postblend module enable
// Bit 6,  preblend module enable
// Bit 5,  if true, osd2 foreground compared with osd1 in preblend
// Bit 4,  if true, osd2 foreground compared with osd1 in postblend
// Bit 3,
// Bit 2,  if true, disable resetting async fifo every vsync, otherwise every vsync
//			 the aync fifo will be reseted.
// Bit 1,
// Bit 0	if true, the output result of VPP is saturated
#define VPP_MISC ((0x1d26 << 2) + 0xff900000)
// Bit 31:20 ofifo line length minus 1
// Bit 19  if true invert input vs
// Bit 18  if true invert input hs
// Bit 17  force top/bottom field, enable
// Bit 16  force top/bottom field, 0: top, 1: bottom
// Bit 15  force one go_field, one pluse, write only
// Bit 14  force one go_line, one pluse, write only
// Bit 12:0 ofifo size (actually only bit 10:1 is valid), always even number
#define VPP_OFIFO_SIZE ((0x1d27 << 2) + 0xff900000)
// Read only
// Bit 28:18 current scale out fifo counter
// Bit 17:13 current afifo counter
// Bit 12:0 current ofifo counter
#define VPP_FIFO_STATUS ((0x1d28 << 2) + 0xff900000)
// Bit 5 SMOKE3 postblend enable only when postblend vd2 is not enable
// Bit 4 SMOKE3 preblend enable only when preblend vd2 is not enable
// Bit 3 SMOKE2 postblend enable only when postblend osd2 is not enable
// Bit 2 SMOKE2 preblend enable only when preblend osd2 is not enable
// Bit 1 SMOKE1 postblend enable only when postblend osd1 is not enable
// Bit 0 SMOKE1 preblend enable only when preblend osd1 is not enable
#define VPP_SMOKE_CTRL ((0x1d29 << 2) + 0xff900000)
// smoke can be used only when that blending is disable and then be used as smoke function
// smoke1 for OSD1 chanel
// smoke2 for OSD2 chanel
// smoke3 for VD2 chanel
// 31:24 Y
// 23:16 Cb
// 15:8 Cr
// 7:0 Alpha
#define VPP_SMOKE1_VAL ((0x1d2a << 2) + 0xff900000)
#define VPP_SMOKE2_VAL ((0x1d2b << 2) + 0xff900000)
#define VPP_SMOKE3_VAL ((0x1d2c << 2) + 0xff900000)
// Bit 28:16 start
// Bit 12:0 end
#define VPP_SMOKE1_H_START_END ((0x1d2d << 2) + 0xff900000)
// Bit 28:16 start
// Bit 12:0 end
#define VPP_SMOKE1_V_START_END ((0x1d2e << 2) + 0xff900000)
// Bit 28:16 start
// Bit 12:0 end
#define VPP_SMOKE2_H_START_END ((0x1d2f << 2) + 0xff900000)
// Bit 28:16 start
// Bit 12:0 end
#define VPP_SMOKE2_V_START_END ((0x1d30 << 2) + 0xff900000)
// Bit 28:16 start
// Bit 12:0 end
#define VPP_SMOKE3_H_START_END ((0x1d31 << 2) + 0xff900000)
// Bit 28:16 start
// Bit 12:0 end
#define VPP_SMOKE3_V_START_END ((0x1d32 << 2) + 0xff900000)
// Bit 27:16 scale out fifo line length minus 1
// Bit 12:0 scale out fifo size (actually only bit 11:1 is valid, 11:1, max 1024), always even
// number
#define VPP_SCO_FIFO_CTRL ((0x1d33 << 2) + 0xff900000)
// for 3D quincunx sub-sampling and horizontal pixel by pixel 3D interleaving
// Bit 27:24, prehsc_mode, bit 3:2, prehsc odd line interp mode, bit 1:0, prehsc even line interp
// mode,
//           each 2bit, 00: pix0+pix1/2, average, 01: pix1, 10: pix0
// Bit 23 horizontal scaler double pixel mode
// Bit 22:21   horizontal scaler initial repeat pixel0 number1
// Bit 19:16   horizontal scaler initial receiving number1
// Bit 15:0    horizontal scaler top field initial phase1
#define VPP_HSC_PHASE_CTRL1 ((0x1d34 << 2) + 0xff900000)
// for 3D quincunx sub-sampling
// 31:24  prehsc pattern, each patten 1 bit, from lsb -> msb
// 22:20  prehsc pattern start
// 18:16 prehsc pattern end
// 15:8 hsc pattern, each patten 1 bit, from lsb -> msb
// 6:4  hsc pattern start
// 2:0  hsc pattern end
#define VPP_HSC_INI_PAT_CTRL ((0x1d35 << 2) + 0xff900000)
#define VPP_SC_GCLK_CTRL ((0x1d36 << 2) + 0xff900000)
#define VPP_PREHSC_COEF ((0x1d37 << 2) + 0xff900000)
#define VPP_PRE_SCALE_CTRL ((0x1d38 << 2) + 0xff900000)
#define VPP_PREVSC_COEF ((0x1d39 << 2) + 0xff900000)
#define VPP_PREHSC_COEF1 ((0x1d3a << 2) + 0xff900000)
// 0x3b-0x3e
//
// Reading file:  vpp_pst_sta_regs.h
//
#define VPP_PST_STA_CTRL ((0x1d3b << 2) + 0xff900000)
// Bit  31:5      reserved
// Bit  21:16     reg_pst_hist_rd_idx              .unsigned , default = 0, used for histgram read
// out Bit  15:12     reserved Bit  11:8      reg_gclk_ctrl                    .unsigned , default
// = 0, Bit  7:5       reserved Bit  4         reg_pst_hist_win_en              .unsigned ,
// default = 0, enable for post histogram sta window mode Bit  3:2       reg_pst_hist_mode_sel
// .unsigned , default = 0, component selection for hist sta: 0~2 for data[cmp]; 3:
// max(dat[0],dat[1], dat[2]) Bit  1         reg_pst_hist_after_csc           .unsigned , default
// = 0, hist_sta after CSC or NOT. 0: before CSC (YUV); 1: after CSC (R/G/B) Bit  0
// reg_pst_hist_sta_en .unsigned , default = 0, enable for post histogram sta
#define VPP_PST_STA_WIN_X ((0x1d3c << 2) + 0xff900000)
// Bit  31:30     reserved
// Bit  29:16     reg_pst_hist_win_xed      .unsigned , default = 1919
// Bit  15:14     reserved
// Bit  13: 0     reg_pst_hist_win_xst      .unsigned , default = 0
#define VPP_PST_STA_WIN_Y ((0x1d3d << 2) + 0xff900000)
// Bit  31:30     reserved
// Bit  29:16     reg_pst_hist_win_yed      .unsigned , default = 1079
// Bit  15:14     reserved
// Bit  13: 0     reg_pst_hist_win_yst      .unsigned , default = 0
#define VPP_PST_STA_RO_HIST ((0x1d3e << 2) + 0xff900000)
// Bit  23:0      ro_pst_hist_out           .unsigned ,RO,default = 0  ;
//
// Closing file:  vpp_pst_sta_regs.h
//
// Bit 3			minus black level enable for vadj2
// Bit 2			Video adjustment enable for vadj2
// Bit 1			minus black level enable for vadj1
// Bit 0			Video adjustment enable for vadj1
#define VPP_VADJ_CTRL ((0x1d40 << 2) + 0xff900000)
// Bit 16:8  brightness, signed value
// Bit 7:0	contrast, unsigned value, contrast from  0 <= contrast <2
//`define VPP_VADJ1_Y                    8'h41      //'h00080
// cb' = cb*ma + cr*mb
// cr' = cb*mc + cr*md
// all are bit 9:0, signed value, -2 < ma/mb/mc/md < 2
//`define VPP_VADJ1_MA_MB                8'h42   //26'h100_0000
//`define VPP_VADJ1_MC_MD                8'h43   //26'h000_0100
// Bit 16:8  brightness, signed value
// Bit 7:0	contrast, unsigned value, contrast from  0 <= contrast <2
//`define VPP_VADJ2_Y                    8'h44      //'h00080
// cb' = cb*ma + cr*mb
// cr' = cb*mc + cr*md
// all are bit 9:0, signed value, -2 < ma/mb/mc/md < 2
//`define VPP_VADJ2_MA_MB                8'h45   //26'h100_0000
//`define VPP_VADJ2_MC_MD                8'h46   //26'h000_0100
// Bit 2 horizontal chroma sharp/blur selection, 0:sharp, 1: blur
// Bit 1 horizontal luma sharp/blur selection, 0:sharp, 1: blur
// Bit 0 horizontal sharpness enable
#define VPP_HSHARP_CTRL ((0x1d50 << 2) + 0xff900000)
//{1'b0,threhsold} < diff
// Bit 26:16  luma threshold0
// Bit 10:0   luma threshold1
#define VPP_HSHARP_LUMA_THRESH01 ((0x1d51 << 2) + 0xff900000)
//
// Bit 26:16  luma threshold2
// Bit 10:0   luma threshold3
#define VPP_HSHARP_LUMA_THRESH23 ((0x1d52 << 2) + 0xff900000)
// Bit 26:16  chroma threshold0
// Bit 10:0   chroma threshold1
#define VPP_HSHARP_CHROMA_THRESH01 ((0x1d53 << 2) + 0xff900000)
// Bit 26:16  chroma threshold2
// Bit 10:0   chroma threshold3
#define VPP_HSHARP_CHROMA_THRESH23 ((0x1d54 << 2) + 0xff900000)
// Bit 23:16 luma gain2
// Bit 15:8  luma gain1
// Bit 7:0   luma gain0
#define VPP_HSHARP_LUMA_GAIN ((0x1d55 << 2) + 0xff900000)
//
// Bit 23:16 chroma gain2
// Bit 15:8  chroma gain1
// Bit 7:0   chroma gain0
#define VPP_HSHARP_CHROMA_GAIN ((0x1d56 << 2) + 0xff900000)
// Read only
// Bit 31, if it is true, it means this probe is valid in the last field/frame
// Bit 29:20 component 0
// Bit 19:10 component 1
// Bit 9:0 component 2
#define VPP_MATRIX_PROBE_COLOR ((0x1d5c << 2) + 0xff900000)
#define VPP_MATRIX_PROBE_COLOR1 ((0x1dd7 << 2) + 0xff900000)
// Bit 23:16 component 0
// Bit 15:8  component 1
// Bit 7:0 component 2
#define VPP_MATRIX_HL_COLOR ((0x1d5d << 2) + 0xff900000)
// 28:16 probe x, postion
// 12:0  probe y, position
#define VPP_MATRIX_PROBE_POS ((0x1d5e << 2) + 0xff900000)
// Bit 16,  highlight_en
// Bit 15   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before
// matrix Bit 14:12 probe_sel, 000: select post matrix, 001: select vd1 matrix, 010: select vd2
// matrix Bit 9:8  matrix coef idx selection, 00: select post matrix, 01: select vd1 matrix, 10:
// select vd2 matrix Bit 5    vd1 conversion matrix enable Bit 4    vd2 conversion matrix enable
// Bit 2    output y/cb/cr saturation enable, only for post matrix (y saturate to 16-235, cb/cr
// saturate to 16-240) Bit 1    input y/cb/cr saturation enable, only for post matrix (y saturate
// to 16-235, cb/cr saturate to 16-240) Bit 0    post conversion matrix enable
#define VPP_MATRIX_CTRL ((0x1d5f << 2) + 0xff900000)
// Bit 28:16 coef00
// Bit 12:0  coef01
#define VPP_MATRIX_COEF00_01 ((0x1d60 << 2) + 0xff900000)
// Bit 28:16 coef02
// Bit 12:0  coef10
#define VPP_MATRIX_COEF02_10 ((0x1d61 << 2) + 0xff900000)
// Bit 28:16 coef11
// Bit 12:0  coef12
#define VPP_MATRIX_COEF11_12 ((0x1d62 << 2) + 0xff900000)
// Bit 28:16 coef20
// Bit 12:0  coef21
#define VPP_MATRIX_COEF20_21 ((0x1d63 << 2) + 0xff900000)
#define VPP_MATRIX_COEF22 ((0x1d64 << 2) + 0xff900000)
// Bit 26:16 offset0
// Bit 10:0  offset1
#define VPP_MATRIX_OFFSET0_1 ((0x1d65 << 2) + 0xff900000)
// Bit 10:0  offset2
#define VPP_MATRIX_OFFSET2 ((0x1d66 << 2) + 0xff900000)
// Bit 26:16 pre_offset0
// Bit 10:0  pre_offset1
#define VPP_MATRIX_PRE_OFFSET0_1 ((0x1d67 << 2) + 0xff900000)
// Bit 10:0  pre_offset2
#define VPP_MATRIX_PRE_OFFSET2 ((0x1d68 << 2) + 0xff900000)
// dummy data used in the VPP postblend
// Bit 23:16    Y
// Bit 15:8     CB
// Bit 7:0      CR
#define VPP_DUMMY_DATA1 ((0x1d69 << 2) + 0xff900000)
// Bit 31 gainoff module enable
// Bit 26:16 gain0, 1.10 unsigned data
// Bit 10:0  gain1, 1.10 unsigned dat
#define VPP_GAINOFF_CTRL0 ((0x1d6a << 2) + 0xff900000)
// Bit 26:16 gain2, 1.10 unsigned data
// Bit 10:0, offset0, signed data
#define VPP_GAINOFF_CTRL1 ((0x1d6b << 2) + 0xff900000)
// Bit 26:16, offset1, signed data
// Bit 10:0, offset2, signed data
#define VPP_GAINOFF_CTRL2 ((0x1d6c << 2) + 0xff900000)
// Bit 26:16, pre_offset0, signed data
// Bit 10:0, pre_offset1, signed data
#define VPP_GAINOFF_CTRL3 ((0x1d6d << 2) + 0xff900000)
// Bit 10:0, pre_offset2, signed data
#define VPP_GAINOFF_CTRL4 ((0x1d6e << 2) + 0xff900000)
#define VPP_GAINOFF_GCLK_CTRL ((0x1d6f << 2) + 0xff900000)
#define VPP_CHROMA_ADDR_PORT ((0x1d70 << 2) + 0xff900000)
#define VPP_CHROMA_DATA_PORT ((0x1d71 << 2) + 0xff900000)

//  CHROMA_GAIN_REG_XX(00-07)
//  hue gain, sat gain function control
//  Bit 31      reg_sat_en                  enable sat adjustment in current region
//  Bit 27      reg_sat_increase            sat adjustment increase or decrease
//                                          1'b1: increase  1'b0: decrease
//  Bit 26:25   reg_sat_central_en          sat adjustment with central biggest or one side
//  biggest
//                                          2'b01 central biggest   2'b00 one side biggest
//  Bit 24      reg_sat_shape               when sat adjustment one side biggest, define left or
//  right
//                                          1'b1: left side biggest 1'b0 right side biggest
//  Bit 23:16   reg_sat_gain                define the sat gain when sat adjustment
//                                          0x00-0xff
//  Bit 15      reg_hue_en                  enable hue adjustment in current region
//  Bit 11      reg_hue_clockwise           hue adjustment clockwise or anti-clockwise
//                                          1'b1: clockwise 1'b0: anti-clockwise
//  Bit 10:9    reg_hue_central_en          when hue adjustment, parabola curve or non-symmetry
//  curve
//                                          1'b1: parabola curve    1'b0: non-symmetry curve
//  Bit 8       reg_hue_shape               when non-symmetry curve, define which side change more
//                                          1'b1: right side change more    1'b0: left side change
//                                          more
//  Bit 7:0     reg_hue_gain                define the hue gain when hue adjustment
//                                          0x00-0x80, note: should be no bigger than 0x80

#define CHROMA_GAIN_REG00 0x00

//  HUE_HUE_RANGE_REG_XX(00-07)
//  hue range select
//  Bit 31:24   no use now
//  Bit 23:16   reg_hue_shift_range         define the angle of target region
//                                          0x00-0xff,(0x100 means 120 degree though it can not be
//                                          set) must be greater or equal than 8'd8
//  Bit 15      reg_symmetry_en             this is used for create one symmetry region
//                                          the symmetry region hue_shift_start =
//                                          reg_hue_hue_shift_start + reg_hue_shift_range<<5 the
//                                          symmetry region hue_shift_range = reg_hue_shift_range
//                                          in symmetry region, all the sat and hue setting will
//                                          be same with original region, except reg_hue_shape,
//                                          reg_sat_shape, reg_hue_clockwise will be reversed
//  Bit 14:0    reg_hue_hue_shift_start     define the start angle of target region
//                                          0x6000 means 360 degree
//                                          only region 0 and 1 can exceed 360 degrees.

#define HUE_HUE_RANGE_REG00 0x01

//  HUE_RANGE_INV_REG_XX
//  Calculation should be follow
//  HUE_RANGE_INV_REG0X[15:0] = ((1<<20)/HUE_HUE_RANGE_REG0X[23:16]+1)>>1
//  HUE_RANGE_INV_REG_XX is to used to save divider

#define HUE_RANGE_INV_REG00 0x02

//  for belowing each low, high, low_slope, high_slope group:
//            a_____________b
//            /             \               a = low  + 2^low_slope
//           /               \              b = high - 2^high_slope
//          /                 \             low_slope <= 7; high_slope <= 7
//         /                   \            b >= a
//  ______/_____________________\________
//       low                    high
//
//
//  HUE_LUM_RANGE_REG_XX(00-07)
//  luma range selection for hue adjustment
//  Bit 31:24   reg_sat_lum_low             define the low level of luma value for sat adjustment
//                                          0x00-0xff
//  Bit 23:20   reg_hue_lum_high_slope      define the slope area below high level of luma value
//  for hue adjustment
//                                          0x00-0x07
//  Bit 19:16   reg_hue_lum_low_slope       define the slope area above low  level of luma value
//  for hue adjustment
//                                          0x00-0x07
//  Bit 15:8    reg_hue_lum_high            define the high level of luma value for hue adjustment
//                                          0x00-0xff
//  Bit 7:0     reg_hue_lum_low             define the low  level of luma value for hue adjustment
//                                          0x00-0xff

#define HUE_LUM_RANGE_REG00 0x03

//  HUE_SAT_RANGE_REG_XX(00-07)
//  sat range selection for hue adjustment
//  Bit 31:24   reg_sat_lum_high            define the high level of luma value for sat adjustment
//                                          0x00-0xff
//  Bit 23:20   reg_hue_sat_high_slope      define the slope area below high level of sat value
//  for hue adjustment
//                                          0x00-0x07
//  Bit 19:16   reg_hue_sat_low_slope       define the slope area above low  level of sat value
//  for hue adjustment
//                                          0x00-0x07
//  Bit 15:8    reg_hue_sat_high            define the high level of sat value for hue adjustment
//                                          0x00-0xff
//  Bit 7:0     reg_hue_sat_low             define the low  level of sat value for hue adjustment
//                                          0x00-0xff

#define HUE_SAT_RANGE_REG00 0x04

//  SAT_SAT_RANGE_REG_XX(00-07)
//  sat range selection for hue adjustment
//  Bit 31:28   reg_sat_lum_high_slope      define the slope area below high level of luma value
//  for sat adjustment
//                                          0x00-0x07
//  Bit 27:24   reg_sat_lum_low_slope       define the slope area above low  level of luma value
//  for sat adjustment
//                                          0x00-0x07
//  Bit 23:20   reg_sat_sat_high_slope      define the slope area below high level of sat value
//  for sat adjustment
//                                          0x00-0x07
//  Bit 19:16   reg_sat_sat_low_slope       define the slope area above low  level of sat value
//  for sat adjustment
//                                          0x00-0x07
//  Bit 15:8    reg_sat_sat_high            define the high level of sat value for sat adjustment
//                                          0x00-0xff
//  Bit 7:0     reg_sat_sat_low             define the low  level of sat value for sat adjustment
//                                          0x00-0xff

#define SAT_SAT_RANGE_REG00 0x05

#define CHROMA_GAIN_REG01 0x06
#define HUE_HUE_RANGE_REG01 0x07
#define HUE_RANGE_INV_REG01 0x08
#define HUE_LUM_RANGE_REG01 0x09
#define HUE_SAT_RANGE_REG01 0x0a
#define SAT_SAT_RANGE_REG01 0x0b

#define CHROMA_GAIN_REG02 0x0c
#define HUE_HUE_RANGE_REG02 0x0d
#define HUE_RANGE_INV_REG02 0x0e
#define HUE_LUM_RANGE_REG02 0x0f
#define HUE_SAT_RANGE_REG02 0x10
#define SAT_SAT_RANGE_REG02 0x11

#define CHROMA_GAIN_REG03 0x12
#define HUE_HUE_RANGE_REG03 0x13
#define HUE_RANGE_INV_REG03 0x14
#define HUE_LUM_RANGE_REG03 0x15
#define HUE_SAT_RANGE_REG03 0x16
#define SAT_SAT_RANGE_REG03 0x17

#define CHROMA_GAIN_REG04 0x18
#define HUE_HUE_RANGE_REG04 0x19
#define HUE_RANGE_INV_REG04 0x1a
#define HUE_LUM_RANGE_REG04 0x1b
#define HUE_SAT_RANGE_REG04 0x1c
#define SAT_SAT_RANGE_REG04 0x1d

#define CHROMA_GAIN_REG05 0x1e
#define HUE_HUE_RANGE_REG05 0x1f
#define HUE_RANGE_INV_REG05 0x20
#define HUE_LUM_RANGE_REG05 0x21
#define HUE_SAT_RANGE_REG05 0x22
#define SAT_SAT_RANGE_REG05 0x23

#define CHROMA_GAIN_REG06 0x24
#define HUE_HUE_RANGE_REG06 0x25
#define HUE_RANGE_INV_REG06 0x26
#define HUE_LUM_RANGE_REG06 0x27
#define HUE_SAT_RANGE_REG06 0x28
#define SAT_SAT_RANGE_REG06 0x29

#define CHROMA_GAIN_REG07 0x2a
#define HUE_HUE_RANGE_REG07 0x2b
#define HUE_RANGE_INV_REG07 0x2c
#define HUE_LUM_RANGE_REG07 0x2d
#define HUE_SAT_RANGE_REG07 0x2e
#define SAT_SAT_RANGE_REG07 0x2f

//  REG_CHROMA_CONTROL
//  Bit 31      reg_chroma_en               enable color manage function
//                                          1'b1: enable    1'b0: bypass
//  Bit 6       sat_sel                     uv_max or u^2+v^2 selected as sat for reference
//                                          1'b1: uv_max(default)   1'b0: u^2+v^2
//  Bit 5       uv_adj_en                   final uv_adjust enable
//                                          1'b1: enable    1'b0: bypass
//  Bit 2       hue_en                      rgb to hue enable
//                                          1'b1: enable(default)   1'b0: bypass
//  Bit 1:0     csc_sel                     define input YUV with different color type
//                                          2'b00: 601(16-235)  2'b01: 709(16-235)
//                                          2'b10: 601(0-255)   2'b11: 709(0-255)
#define REG_CHROMA_CONTROL 0x30 // default 32h'80000024
#define REG_DEMO_CENTER_BAR 0x31 // default 32h'0
#define REG_DEMO_HLIGHT_MODE 0x32 // default 32h'0
#define REG_DEMO_OWR_DATA 0x33 // default 32h'0

////===========================================////
//// CM2 ADDR
////===========================================////

#define SAT_BYYB_NODE_REG0 0x200 // default 32'h0
// Bit 31:24, sat_byyb_node3    the 4th node
// Bit 23:16, sat_byyb_node2    the 3th node
// Bit 15: 8, sat_byyb_node1    signed, the 2th node about saturation
// Bit  7: 0, sat_byyb_node0    signed, the 1th node about saturation
// gain offset along y coordinate,the gain normalized to 128 as "1"

#define SAT_BYYB_NODE_REG1 0x201 // default 32'h0
// Bit 31:24, sat_byyb_node7     the 8th node
// Bit 23:16, sat_byyb_node6     the 7th node
// Bit 15: 8, sat_byyb_node5     signed, the 6th node about saturation
// Bit  7: 0, sat_byyb_node4     signed, the 5th node about saturation
// gain offset along y coordinate,the gain normalized to 128 as "1"

#define SAT_BYYB_NODE_REG2 0x202 // default 32'h0
// Bit 31: 8, reserved
// Bit  7: 0, sat_byyb_node4     signed, the 5th node about saturation

#define SAT_SRC_NODE_REG 0x203 // default 32'h0
// Bit 31:28, reserved
// Bit 27:16, sat_src_node1
// Bit 15:12, reserved
// Bit 11: 0, sat_src_node0     usigned, threshold of input saturation for  first and second piece

#define CM_ENH_SFT_MODE_REG 0x204 // default 32'h0
// Bit 31: 9, reserved
// Bit  8: 6, hue_lsft_mode        hue offset adjustments scale
// Bit  5: 4, luma_lsft_mode       luma offset adjustments scale for reg_cm2_adj_luma_via_hue
// Bit  3: 2, sat_byy_rsft_mode    saturation gain adjustments scale for reg_cm2_adj_sat_via_y
// Bit  1: 0, sat_byhs_rsft_mode   saturation gain adjustments scale for
// reg_cm2_adj_sat_via_hs[:][:] 0:no scale up/down 1:dnscale by 2(-128,127)/2

#define FRM_SIZE_REG 0x205 // default 32'h0
// Bit 31:29, reserved
// Bit 28:16, reg_frm_height       the frame height size
// Bit 15:13, reserved
// Bit 12: 0, reg_frm_width        the frame width size

#define FITLER_CFG_REG 0x206 // default 32'h0
// Bit 31: 5, reserved
// Bit  4: 4, inteleav_mod         horizontal interleave filter(zero-padding) for 3D
// considerations 0:using non-zero padding lpf 1:using zero-padding lpf Bit  3: 2, lpf_slt_uv
// apply cm on lp portion or original video pixels options Bit  1: 0, lpf_slt_y            apply
// cm on lp portion or original video pixels options

#define CM_GLOBAL_GAIN_REG 0x207 // default 32'h0
// Bit 31:28, reserved
// Bit 27:16, cm2_global_sat     global saturation gain for general color adjustments(0~4095 <=>
// 0~8),512 normalized to "1" Bit 15:12, reserved Bit 11: 0, cm2_global_hue     global hue offsets
// for general color adjustments(0~4095 <=> 0~360 degree)

#define CM_ENH_CTL_REG 0x208 // default 32'h0
// Bit  31:7, reserved
// Bit     6, hue_adj_en        cm2 hue adjustments
// Bit     5, sat_adj_en        cm2 saturation adjustments
// Bit     4, luma_adj_en       enable siganl for cm2 luma adjustments
// Bit     3, reserved
// Bit     2, cm2_filt_en       apply cm on lp portion enable
// Bit     1, cm2_en            cm2 enable siganl
// Bit     0, cm1_en

#define ROI_X_SCOPE_REG 0x209 // default 32'h0
// Bit 31:29, reserved
// Bit 28:16, roi_x_end      ending col index of the region of interest
// Bit 15:13, reserved
// Bit 12: 0, roi_x_beg      start col index of the region of interest

#define ROI_Y_SCOPE_REG 0x20a // default 32'h0
// Bit 31:29, reserved
// Bit 28:16, roi_y_end      ending row index of the region of interest
// Bit 15:13, reserved
// Bit 12: 0, roi_y_beg      start row index of the region of interest

#define POI_XY_DIR_REG 0x20b // default 32'h0
// Bit 31:29, reserved
// Bit 28:16, poi_y_dir      ending row index of the region of interest
// Bit 15:13, reserved
// Bit 12: 0, poi_x_dir      start row index of the region of interest

#define COI_Y_SCOPE_REG 0x20c // default 32'h0
// Bit 31:16, reserved
// Bit 15: 8, coi_y_end
// Bit  7: 0, coi_y_beg

#define COI_H_SCOPE_REG 0x20d // default 32'h0
// Bit 31:28, reserved
// Bit 27:16, coi_h_end
// Bit 15:12, reserved
// Bit 11: 0, coi_h_beg        lower bound of hue value for color of interest ,12 bits precision

#define COI_S_SCOPE_REG 0x20e // default 32'h0
// Bit 31:28, reserved
// Bit 27:16, coi_s_end
// Bit 15:12, reserved
// Bit 11: 0, coi_s_beg        lower bound of sat value for color of interest ,12 bits precision
#define IFO_MODE_REG 0x20f // default 32'h0
// Bit 31:8, reserved
// Bit  7:6, ifo_mode3
// Bit  5:4, ifo_mode2
// Bit  3:2, ifo_mode1
// Bit  1:0, ifo_mode0
#define POI_RPL_MODE_REG 0x210 // default 32'h0
// Bit 31:4, reserved
// Bit  3:0, poi_rpl_mode          enhance mode control of pixels inside and outside region of
// interest bit[3:2]control roi
#define DEMO_OWR_YHS_REG 0x211 // default 32'h0
// Bit 31: 0, demo_owr_yhs

#define DEMO_POI_Y_REG 0x212 // default 32'h0
// Bit 31: 8, reserved
// Bit  7: 0, luma_data_poi_r       only get locked higher 8bits
#define DEMO_POI_H_REG 0x213 // default 32'h0
// Bit 31: 12, reserved
// Bit 11: 0, hue_data_poi_r        only get locked higher 12bits
#define DEMO_POI_S_REG 0x214 // default 32'h0
// Bit 31: 12, reserved
// Bit 11: 0, sat_data_poi_r         only get locked higher 12bits
//#define LUMA_BYH_LIMT_REG           0x215   // default 32'h0
#define LUMA_ADJ_LIMT_REG 0x215 // default 32'h0
// Bit 31:24, reserved
// Bit 23:16, luma_lmt_satslp         slope to do the luma adjustment degrade
// Bit 15:12, reserved
// Bit 11:0, luma_lmt_satth           threshold to saturation
#define SAT_ADJ_LIMT_REG 0x216 // default 32'h0
// Bit 31:24, reserved
// Bit 23:16, sat_lmt_satslp        slope to do the adjustment degrade
// Bit 15:12, reserved
// Bit 11:0, sat_lmt_satth          threshold to saturation
#define HUE_ADJ_LIMT_REG 0x217 // default 32'h0
// Bit 31: 24, reserved
// Bit 23: 16, hue_lmt_satslp        slope to do the adjustment degrade
// Bit 15: 12, reserved
// Bit 11: 0,  hue_lmt_satth          threshold to saturation
#define UVHS_OFST_REG 0x218 // default 32'h0
// Bit 31: 24, hs2uv_v_ofst
// Bit 23: 16, hs2uv_u_ofst
// Bit 15: 8,  uv2hs_v_ofst
// Bit  7: 0,  uv2hs_u_ofst
#define HUE_CFG_PARA_REG 0x219 // default 32'h0
// Bit 31: 17, reserved
// Bit     16, hue_protect_en
// Bit 15: 13, cm2_hue_byhs_mode
// Bit     12, cm2_hue_div_mode
// Bit 11: 0, cm2_before_hue_ofst
#define DEMO_SPLT_CFG_REG 0x21a // default 32'h0
// Bit 31: 22, reserved
// Bit 21: 20, demo_split_mode
// Bit 19: 16, demo_split_width        slope to do the adjustment degrade
// Bit 15: 13, reserved
// Bit 12: 0,  demo_split_post           threshold to saturation
#define DEMO_SPLT_YHS_REG 0x21b // default 32'h0
// Bit 31: 0,  demo_splt_yhs             threshold to saturation

#define XVYCC_YSCP_REG 0x21c // default 32'h0
// Bit 31: 28, reserved
// Bit 27: 16, xvycc_y_max
// Bit 15: 12, reserved
// Bit 11: 0, xvycc_y_min
#define XVYCC_USCP_REG 0x21d // default 32'h0
// Bit 31: 28, reserved
// Bit 27: 16, xvycc_u_max
// Bit 15: 12, reserved
// Bit 11: 0, xvycc_u_min
#define XVYCC_VSCP_REG 0x21e // default 32'h0
// Bit 31: 28, reserved
// Bit 27: 16, xvycc_v_max
// Bit 15: 12, reserved
// Bit 11: 0, xvycc_v_min
#define LUMA_ADJ0_REG 0x21f // default 32'h0
// Bit 21: 12, reg_cm_luma_blacklevel
// Bit 11: 0,  reg_cm_luma_contrast
#define LUMA_ADJ1_REG 0x220 // default 32'h0

#define STA_WIN_XYXY0_REG 0x221 // default 32'h0
#define STA_WIN_XYXY1_REG 0x222 // default 32'h0
#define STA_CFG_REG 0x223 // default 32'h0
#define STA_SAT_HIST0_REG 0x224 // default 32'h0
#define STA_SAT_HIST1_REG 0x225 // default 32'h0
#define RO_CM_HUE_HIST_BIN0 0x226 // default 32'h0
#define RO_CM_HUE_HIST_BIN1 0x227 // default 32'h0
#define RO_CM_HUE_HIST_BIN2 0x228 // default 32'h0
#define RO_CM_HUE_HIST_BIN3 0x229 // default 32'h0
#define RO_CM_HUE_HIST_BIN4 0x22a // default 32'h0
#define RO_CM_HUE_HIST_BIN5 0x22b // default 32'h0
#define RO_CM_HUE_HIST_BIN6 0x22c // default 32'h0
#define RO_CM_HUE_HIST_BIN7 0x22d // default 32'h0
#define RO_CM_HUE_HIST_BIN8 0x22e // default 32'h0
#define RO_CM_HUE_HIST_BIN9 0x22f // default 32'h0
#define RO_CM_HUE_HIST_BIN10 0x230 // default 32'h0
#define RO_CM_HUE_HIST_BIN11 0x231 // default 32'h0
#define RO_CM_HUE_HIST_BIN12 0x232 // default 32'h0
#define RO_CM_HUE_HIST_BIN13 0x233 // default 32'h0
#define RO_CM_HUE_HIST_BIN14 0x234 // default 32'h0
#define RO_CM_HUE_HIST_BIN15 0x235 // default 32'h0
#define RO_CM_HUE_HIST_BIN16 0x236 // default 32'h0
#define RO_CM_HUE_HIST_BIN17 0x237 // default 32'h0
#define RO_CM_HUE_HIST_BIN18 0x238 // default 32'h0
#define RO_CM_HUE_HIST_BIN19 0x239 // default 32'h0
#define RO_CM_HUE_HIST_BIN20 0x23a // default 32'h0
#define RO_CM_HUE_HIST_BIN21 0x23b // default 32'h0
#define RO_CM_HUE_HIST_BIN22 0x23c // default 32'h0
#define RO_CM_HUE_HIST_BIN23 0x23d // default 32'h0
#define RO_CM_HUE_HIST_BIN24 0x23e // default 32'h0
#define RO_CM_HUE_HIST_BIN25 0x23f // default 32'h0
#define RO_CM_HUE_HIST_BIN26 0x240 // default 32'h0
#define RO_CM_HUE_HIST_BIN27 0x241 // default 32'h0
#define RO_CM_HUE_HIST_BIN28 0x242 // default 32'h0
#define RO_CM_HUE_HIST_BIN29 0x243 // default 32'h0
#define RO_CM_HUE_HIST_BIN30 0x244 // default 32'h0
#define RO_CM_HUE_HIST_BIN31 0x245 // default 32'h0
#define RO_CM_SAT_HIST_BIN0 0x246 // default 32'h0
#define RO_CM_SAT_HIST_BIN1 0x247 // default 32'h0
#define RO_CM_SAT_HIST_BIN2 0x248 // default 32'h0
#define RO_CM_SAT_HIST_BIN3 0x249 // default 32'h0
#define RO_CM_SAT_HIST_BIN4 0x24a // default 32'h0
#define RO_CM_SAT_HIST_BIN5 0x24b // default 32'h0
#define RO_CM_SAT_HIST_BIN6 0x24c // default 32'h0
#define RO_CM_SAT_HIST_BIN7 0x24d // default 32'h0
#define RO_CM_SAT_HIST_BIN8 0x24e // default 32'h0
#define RO_CM_SAT_HIST_BIN9 0x24f // default 32'h0
#define RO_CM_SAT_HIST_BIN10 0x250 // default 32'h0
#define RO_CM_SAT_HIST_BIN11 0x251 // default 32'h0
#define RO_CM_SAT_HIST_BIN12 0x252 // default 32'h0
#define RO_CM_SAT_HIST_BIN13 0x253 // default 32'h0
#define RO_CM_SAT_HIST_BIN14 0x254 // default 32'h0
#define RO_CM_SAT_HIST_BIN15 0x255 // default 32'h0
#define RO_CM_SAT_HIST_BIN16 0x256 // default 32'h0
#define RO_CM_SAT_HIST_BIN17 0x257 // default 32'h0
#define RO_CM_SAT_HIST_BIN18 0x258 // default 32'h0
#define RO_CM_SAT_HIST_BIN19 0x259 // default 32'h0
#define RO_CM_SAT_HIST_BIN20 0x25a // default 32'h0
#define RO_CM_SAT_HIST_BIN21 0x25b // default 32'h0
#define RO_CM_SAT_HIST_BIN22 0x25c // default 32'h0
#define RO_CM_SAT_HIST_BIN23 0x25d // default 32'h0
#define RO_CM_SAT_HIST_BIN24 0x25e // default 32'h0
#define RO_CM_SAT_HIST_BIN25 0x25f // default 32'h0
#define RO_CM_SAT_HIST_BIN26 0x260 // default 32'h0
#define RO_CM_SAT_HIST_BIN27 0x261 // default 32'h0
#define RO_CM_SAT_HIST_BIN28 0x262 // default 32'h0
#define RO_CM_SAT_HIST_BIN29 0x263 // default 32'h0
#define RO_CM_SAT_HIST_BIN30 0x264 // default 32'h0
#define RO_CM_SAT_HIST_BIN31 0x265 // default 32'h0
#define RO_CM_BLK_BIN 0x266 // default 32'h0
#define RO_CM_BRT_BIN 0x267 // default 32'h0

////========= NODE 0 COEFFICIENT ==============////

#define REG_CM2_ENH_COEFF0_H00 0x100 // default 32'H0
// Bit 31: 24, reg_cm2_adj_sat_via_hs_2
// Bit 23: 16, reg_cm2_adj_sat_via_hs_1
// Bit 15: 8,  reg_cm2_adj_sat_via_hs_0
// Bit  7: 0, reg_cm2_adj_luma_via_h
// [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
// [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
#define REG_CM2_ENH_COEFF1_H00                                                                   \
	0x101 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx                                 \
		// [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
#define REG_CM2_ENH_COEFF2_H00                                                                   \
	0x102 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx                                 \
		// [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
#define REG_CM2_ENH_COEFF3_H00                                                                   \
	0x103 // default 32'H0                                                                     \
		// [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx                                 \
		// [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
#define REG_CM2_ENH_COEFF4_H00                                                                   \
	0x104 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx                               \
		// [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 1 COEFFICIENT ==============////

#define REG_CM2_ENH_COEFF0_H01                                                                   \
	0x108 // default 32'H0                                                                     \
		// [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx                               \
		// [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
#define REG_CM2_ENH_COEFF1_H01                                                                   \
	0x109 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx                                 \
		// [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
#define REG_CM2_ENH_COEFF2_H01                                                                   \
	0x10a // default 32'H0                                                                     \
		// [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx                                 \
		// [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
#define REG_CM2_ENH_COEFF3_H01                                                                   \
	0x10b // default 32'H0                                                                     \
		// [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx                                 \
		// [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
#define REG_CM2_ENH_COEFF4_H01                                                                   \
	0x10c // default 32'H0                                                                     \
		// [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx                               \
		// [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 2 COEFFICIENT ==============////

#define REG_CM2_ENH_COEFF0_H02                                                                   \
	0x110 // default 32'H0                                                                     \
		// [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx                               \
		// [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
#define REG_CM2_ENH_COEFF1_H02                                                                   \
	0x111 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx                                 \
		// [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
#define REG_CM2_ENH_COEFF2_H02                                                                   \
	0x112 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx                                 \
		// [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
#define REG_CM2_ENH_COEFF3_H02                                                                   \
	0x113 // default 32'H0                                                                     \
		// [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx                                 \
		// [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
#define REG_CM2_ENH_COEFF4_H02                                                                   \
	0x114 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx                               \
		// [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 3 COEFFICIENT ==============////

#define REG_CM2_ENH_COEFF0_H03                                                                   \
	0x118 // default 32'H0                                                                     \
		// [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx                               \
		// [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
#define REG_CM2_ENH_COEFF1_H03                                                                   \
	0x119 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx                                 \
		// [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
#define REG_CM2_ENH_COEFF2_H03                                                                   \
	0x11a // default 32'H0                                                                     \
		// [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx                                 \
		// [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
#define REG_CM2_ENH_COEFF3_H03                                                                   \
	0x11b // default 32'H0                                                                     \
		// [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx                                 \
		// [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
#define REG_CM2_ENH_COEFF4_H03                                                                   \
	0x11c // default 32'H0                                                                     \
		// [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx                               \
		// [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 4 COEFFICIENT ==============////

#define REG_CM2_ENH_COEFF0_H04                                                                   \
	0x120 // default 32'H0                                                                     \
		// [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx                               \
		// [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
#define REG_CM2_ENH_COEFF1_H04                                                                   \
	0x121 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx                                 \
		// [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
#define REG_CM2_ENH_COEFF2_H04                                                                   \
	0x122 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx                                 \
		// [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
#define REG_CM2_ENH_COEFF3_H04                                                                   \
	0x123 // default 32'H0                                                                     \
		// [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx                                 \
		// [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
#define REG_CM2_ENH_COEFF4_H04                                                                   \
	0x124 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx                               \
		// [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 5 COEFFICIENT ==============////

#define REG_CM2_ENH_COEFF0_H05                                                                   \
	0x128 // default 32'H0                                                                     \
		// [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx                               \
		// [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
#define REG_CM2_ENH_COEFF1_H05                                                                   \
	0x129 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx                                 \
		// [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
#define REG_CM2_ENH_COEFF2_H05                                                                   \
	0x12a // default 32'H0                                                                     \
		// [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx                                 \
		// [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
#define REG_CM2_ENH_COEFF3_H05                                                                   \
	0x12b // default 32'H0                                                                     \
		// [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx                                 \
		// [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
#define REG_CM2_ENH_COEFF4_H05                                                                   \
	0x12c // default 32'H0                                                                     \
		// [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx                               \
		// [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 6 COEFFICIENT ==============////

#define REG_CM2_ENH_COEFF0_H06                                                                   \
	0x130 // default 32'H0                                                                     \
		// [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx                               \
		// [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
#define REG_CM2_ENH_COEFF1_H06                                                                   \
	0x131 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx                                 \
		// [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
#define REG_CM2_ENH_COEFF2_H06                                                                   \
	0x132 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx                                 \
		// [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
#define REG_CM2_ENH_COEFF3_H06                                                                   \
	0x133 // default 32'H0                                                                     \
		// [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx                                 \
		// [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
#define REG_CM2_ENH_COEFF4_H06                                                                   \
	0x134 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx                               \
		// [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 7 COEFFICIENT ==============////

#define REG_CM2_ENH_COEFF0_H07                                                                   \
	0x138 // default 32'H0                                                                     \
		// [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx                               \
		// [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
#define REG_CM2_ENH_COEFF1_H07                                                                   \
	0x139 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx                                 \
		// [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
#define REG_CM2_ENH_COEFF2_H07                                                                   \
	0x13a // default 32'H0                                                                     \
		// [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx                                 \
		// [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
#define REG_CM2_ENH_COEFF3_H07                                                                   \
	0x13b // default 32'H0                                                                     \
		// [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx                                 \
		// [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
#define REG_CM2_ENH_COEFF4_H07                                                                   \
	0x13c // default 32'H0                                                                     \
		// [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx                               \
		// [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 8 COEFFICIENT ==============////

#define REG_CM2_ENH_COEFF0_H08                                                                   \
	0x140 // default 32'H0                                                                     \
		// [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx                               \
		// [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
#define REG_CM2_ENH_COEFF1_H08                                                                   \
	0x141 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx                                 \
		// [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
#define REG_CM2_ENH_COEFF2_H08                                                                   \
	0x142 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx                                 \
		// [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
#define REG_CM2_ENH_COEFF3_H08                                                                   \
	0x143 // default 32'H0                                                                     \
		// [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx                                 \
		// [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
#define REG_CM2_ENH_COEFF4_H08                                                                   \
	0x144 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx                               \
		// [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 9 COEFFICIENT ==============////

#define REG_CM2_ENH_COEFF0_H09                                                                   \
	0x148 // default 32'H0                                                                     \
		// [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx                               \
		// [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
#define REG_CM2_ENH_COEFF1_H09                                                                   \
	0x149 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx                                 \
		// [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
#define REG_CM2_ENH_COEFF2_H09                                                                   \
	0x14a // default 32'H0                                                                     \
		// [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx                                 \
		// [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
#define REG_CM2_ENH_COEFF3_H09                                                                   \
	0x14b // default 32'H0                                                                     \
		// [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx                                 \
		// [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
#define REG_CM2_ENH_COEFF4_H09                                                                   \
	0x14c // default 32'H0                                                                     \
		// [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx                               \
		// [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 10 COEFFICIENT ==============////

#define REG_CM2_ENH_COEFF0_H10                                                                   \
	0x150 // default 32'H0                                                                     \
		// [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx                               \
		// [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
#define REG_CM2_ENH_COEFF1_H10                                                                   \
	0x151 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx                                 \
		// [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
#define REG_CM2_ENH_COEFF2_H10                                                                   \
	0x152 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx                                 \
		// [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
#define REG_CM2_ENH_COEFF3_H10                                                                   \
	0x153 // default 32'H0                                                                     \
		// [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx                                 \
		// [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
#define REG_CM2_ENH_COEFF4_H10                                                                   \
	0x154 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx                               \
		// [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 11 COEFFICIENT ==============////

#define REG_CM2_ENH_COEFF0_H11                                                                   \
	0x158 // default 32'H0                                                                     \
		// [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx                               \
		// [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
#define REG_CM2_ENH_COEFF1_H11                                                                   \
	0x159 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx                                 \
		// [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
#define REG_CM2_ENH_COEFF2_H11                                                                   \
	0x15a // default 32'H0                                                                     \
		// [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx                                 \
		// [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
#define REG_CM2_ENH_COEFF3_H11                                                                   \
	0x15b // default 32'H0                                                                     \
		// [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx                                 \
		// [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
#define REG_CM2_ENH_COEFF4_H11                                                                   \
	0x15c // default 32'H0                                                                     \
		// [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx                               \
		// [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 12 COEFFICIENT ==============////

#define REG_CM2_ENH_COEFF0_H12                                                                   \
	0x160 // default 32'H0                                                                     \
		// [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx                               \
		// [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
#define REG_CM2_ENH_COEFF1_H12                                                                   \
	0x161 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx                                 \
		// [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
#define REG_CM2_ENH_COEFF2_H12                                                                   \
	0x162 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx                                 \
		// [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
#define REG_CM2_ENH_COEFF3_H12                                                                   \
	0x163 // default 32'H0                                                                     \
		// [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx                                 \
		// [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
#define REG_CM2_ENH_COEFF4_H12                                                                   \
	0x164 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx                               \
		// [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 13 COEFFICIENT ==============////

#define REG_CM2_ENH_COEFF0_H13                                                                   \
	0x168 // default 32'H0                                                                     \
		// [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx                               \
		// [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
#define REG_CM2_ENH_COEFF1_H13                                                                   \
	0x169 // default 32'H0                                                                     \
		// [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx                                 \
		// [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
#define REG_CM2_ENH_COEFF2_H13                                                                   \
	0x16a // default 32'H0                                                                     \
		// [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx                                 \
		// [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
#define REG_CM2_ENH_COEFF3_H13                                                                   \
	0x16b // default 32'H0                                                                     \
		// [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx                                 \
		// [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
#define REG_CM2_ENH_COEFF4_H13                                                                   \
	0x16c // default 32'H0                                                                     \
		// [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx                               \
		// [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

// Constraints
// 0)
//  there are 16 regions totally. 8 regions are for hue adjustment, 8 regions are for sat
//  adjustment. the hue range of the 16 regions can be set to overlap, but if overlap, the hue
//  range(start and end) must be same. the 8 regions for hue adjustment should not overlap. if
//  corresponding reg_hue_en_00 - 07 == 1 the 8 regions for hue adjustment are defined by:
//  (example are for region 0)
//    a) hue:
//        start: reg_hue_hue_shift_start_00[14:0]
//        end:
//        if reg_symmetry_en_00 == 0
//        reg_hue_hue_shift_start_00[14:0] + (reg_hue_hue_shift_range_00[7:0]<<5)
//        if reg_symmetry_en_00 == 1
//        reg_hue_hue_shift_start_00[14:0] + (reg_hue_hue_shift_range_00[7:0]<<6)
//    b) sat:
//        start: reg_hue_sat_low_00
//        end:   reg_hue_sat_high_00
//
//  the 8 regions for sat adjustment should not overlap. if corresponding reg_sat_en_00 - 07 == 1
//  the 8 regions for sat adjustment are defined by: (example are for region 0)
//    a) hue: same as that for hue adjustment.
//        start: reg_hue_hue_shift_start_00[14:0]
//        end:
//        if reg_symmetry_en_00 == 0
//			reg_hue_hue_shift_start_00[14:0] + (reg_hue_hue_shift_range_00[7:0]<<5)
//        if reg_symmetry_en_00 == 1
//        reg_hue_hue_shift_start_00[14:0] + (reg_hue_hue_shift_range_00[7:0]<<6)
//    b) sat:
//		start: reg_sat_sat_low_00
//		end:   reg_sat_sat_high_00
//
// 1)
//  reg_hue_hue_shift_range_00[7:0]:
//  reg_hue_hue_shift_range_01[7:0]:
//  reg_hue_hue_shift_range_02[7:0]:
//  reg_hue_hue_shift_range_03[7:0]:
//  reg_hue_hue_shift_range_04[7:0]:
//  reg_hue_hue_shift_range_05[7:0]:
//  reg_hue_hue_shift_range_06[7:0]:
//  reg_hue_hue_shift_range_07[7:0]:
//  must be greater or equal than 8'd8, so as reg_hue_range_inv_regxx can be represented by
//  0.0000_0000_xxxx_xxxx_xxxx_xxxx
//
// 2)
//  all regions of 0-7 should meet below requirement. below is just an example for region 7.
//  (reg_hue_lum_high_07 - reg_hue_lum_low_07) >=
//	(1<<reg_hue_lum_low_slope_07) + (1<<reg_hue_lum_high_slope_07)
//
//  (reg_hue_sat_high_07 - reg_hue_sat_low_07) >=
//	(1<<reg_hue_sat_low_slope_07) + (1<<reg_hue_sat_high_slope_07)
//
//  (reg_sat_lum_high_07 - reg_sat_lum_low_07) >=
//	(1<<reg_sat_lum_low_slope_07) + (1<<reg_sat_lum_high_slope_07)
//
//  (reg_sat_sat_high_07 - reg_sat_sat_low_07) >=
//	(1<<reg_sat_sat_low_slope_07) + (1<<reg_sat_sat_high_slope_07)
//
// 3)
//  all of reg_hue_hue_shift_start_00[14:0] ~ 07[14:0] < 0x6000.
//  only region 0 and 1 can exceed 360 degrees. ie:
//    reg_hue_hue_shift_start_00 + (reg_hue_hue_shift_range_00<<5) can greater than 0x6000.
//    reg_hue_hue_shift_start_01 + (reg_hue_hue_shift_range_01<<5) can greater than 0x6000.
//  but below should be met:
//    reg_hue_hue_shift_start_00 + (reg_hue_hue_shift_range_00<<5) < 0x8000. if reg_symmetry_en_00
//    == 0 reg_hue_hue_shift_start_01 + (reg_hue_hue_shift_range_00<<5) < 0x8000. if
//    reg_symmetry_en_00 == 0 reg_hue_hue_shift_start_00 + (reg_hue_hue_shift_range_00<<6) <
//    0x8000. if reg_symmetry_en_00 == 1 reg_hue_hue_shift_start_01 +
//    (reg_hue_hue_shift_range_00<<6) < 0x8000. if reg_symmetry_en_00 == 1
//
//  others could not exceed 360 degrees. ie:
//    reg_hue_hue_shift_start_02(to 7) + (reg_hue_hue_shift_range_02 (to 7) <<5) < 0x6000. if
//    reg_symmetry_en_02 (to 7) == 0. reg_hue_hue_shift_start_02(to 7) +
//    (reg_hue_hue_shift_range_02 (to 7) <<6) < 0x6000. if reg_symmetry_en_02 (to 7) == 1.
//
// 4)
//  reg_hue_gain_00[7:0] <= 0x80.
//  reg_hue_gain_01[7:0] <= 0x80.
//  reg_hue_gain_02[7:0] <= 0x80.
//  reg_hue_gain_03[7:0] <= 0x80.
//  reg_hue_gain_04[7:0] <= 0x80.
//  reg_hue_gain_05[7:0] <= 0x80.
//  reg_hue_gain_06[7:0] <= 0x80.
//  reg_hue_gain_07[7:0] <= 0x80.
//
// 5)
//  below registers can only have two setting: 00 and 01.
//    reg_hue_central_en_00[1:0]  .. _07[1:0]
//    reg_sat_central_en_00[1:0]  .. _07[1:0]
//
// 6)
//  all reg_..._slope_00-07 should not be greater than 7, ie: maximum value is 7.
//   for example: below is for region 0:
//   reg_hue_lum_low_slope_00[3:0]  <= 7
//   reg_hue_lum_high_slope_00[3:0] <= 7
//   reg_hue_sat_low_slope_00[3:0]  <= 7
//   reg_hue_sat_high_slope_00[3:0] <= 7
//   reg_sat_lum_low_slope_00[3:0]  <= 7
//   reg_sat_lum_high_slope_00[3:0] <= 7
//   reg_sat_sat_low_slope_00[3:0]  <= 7
//   reg_sat_sat_high_slope_00[3:0] <= 7
//

// synopsys translate_off
// synopsys translate_on
//
// Closing file:  chroma_reg.h
//
//(hsvsharp), (blue), gainoff, mat_vd1,mat_vd2, mat_post, prebld, postbld,(hsharp),sco_ff, vadj1,
// vadj2, ofifo, (chroma1), clk0(free_clk) vpp_reg each item 2bits, for each 2bits, if bit 2*i+1
// ==
// 1, free clk, else if bit 2*i == 1 no clk, else auto gated clock bit1 is not used, because I can
// not turn off vpp_reg clk because I can not turn on again because the register itself canot be
// set again without clk Bit 31:0
#define VPP_GCLK_CTRL0 ((0x1d72 << 2) + 0xff900000)
//(front_lti), (front_cti), Chroma2_filter, Chroma2, (Ccoring), (blackext), dnlp
// Bit 13:0
#define VPP_GCLK_CTRL1 ((0x1d73 << 2) + 0xff900000)
// prehsc_clk, line_buf, prevsc, vsc, hsc_clk, clk0(free_clk)
// Bit 11:0
//`define VPP_SC_GCLK_CTRL        8'h74
// Bit 17:9 VD1 alpha for preblend
// Bit 8:0 VD1 alpha for postblend
#define VPP_MISC1 ((0x1d76 << 2) + 0xff900000)
// Bit 31:0 super scalar clock control
#define VPP_SRSCL_GCLK_CTRL ((0x1d77 << 2) + 0xff900000)
// Bit 31:0 OSD super scalar clock control
#define VPP_OSDSR_GCLK_CTRL ((0x1d78 << 2) + 0xff900000)
// Bit 31:0 vvycc clock control
#define VPP_XVYCC_GCLK_CTRL ((0x1d79 << 2) + 0xff900000)
// Bit 8:0 VD3 alpha for postblend
#define VPP_MISC2 ((0x1d7a << 2) + 0xff900000)
// Bit 31:24     blackext_start
// Bit 23:16     blackext_slope1
// Bit 15:8      blackext_midpt
// Bit 7:0       blackext_slope2
#define VPP_BLACKEXT_CTRL ((0x1d80 << 2) + 0xff900000)
// Bit 31:24     bottom of region03 output value
// Bit 23:16     bottom of region02 output value
// Bit 15:8      bottom of region01 output value
// Bit 7:0       bottom of region00 output value
#define VPP_DNLP_CTRL_00 ((0x1d81 << 2) + 0xff900000)
// Bit 31:24     bottom of region07 output value
// Bit 23:16     bottom of region06 output value
// Bit 15:8      bottom of region05 output value
// Bit 7:0       bottom of region04 output value
#define VPP_DNLP_CTRL_01 ((0x1d82 << 2) + 0xff900000)
// Bit 31:24     bottom of region11 output value
// Bit 23:16     bottom of region10 output value
// Bit 15:8      bottom of region09 output value
// Bit 7:0       bottom of region08 output value
#define VPP_DNLP_CTRL_02 ((0x1d83 << 2) + 0xff900000)
// Bit 31:24     bottom of region15 output value
// Bit 23:16     bottom of region14 output value
// Bit 15:8      bottom of region13 output value
// Bit 7:0       bottom of region12 output value
#define VPP_DNLP_CTRL_03 ((0x1d84 << 2) + 0xff900000)
// Bit 31:24     bottom of region19 output value
// Bit 23:16     bottom of region18 output value
// Bit 15:8      bottom of region17 output value
// Bit 7:0       bottom of region16 output value
#define VPP_DNLP_CTRL_04 ((0x1d85 << 2) + 0xff900000)
// Bit 31:24     bottom of region23 output value
// Bit 23:16     bottom of region22 output value
// Bit 15:8      bottom of region21 output value
// Bit 7:0       bottom of region20 output value
#define VPP_DNLP_CTRL_05 ((0x1d86 << 2) + 0xff900000)
// Bit 31:24     bottom of region27 output value
// Bit 23:16     bottom of region26 output value
// Bit 15:8      bottom of region25 output value
// Bit 7:0       bottom of region24 output value
#define VPP_DNLP_CTRL_06 ((0x1d87 << 2) + 0xff900000)
// Bit 31:24     bottom of region31 output value
// Bit 23:16     bottom of region30 output value
// Bit 15:8      bottom of region29 output value
// Bit 7:0       bottom of region28 output value
#define VPP_DNLP_CTRL_07 ((0x1d88 << 2) + 0xff900000)
// Bit 31:24     bottom of region35 output value
// Bit 23:16     bottom of region34 output value
// Bit 15:8      bottom of region33 output value
// Bit 7:0       bottom of region32 output value
#define VPP_DNLP_CTRL_08 ((0x1d89 << 2) + 0xff900000)
// Bit 31:24     bottom of region39 output value
// Bit 23:16     bottom of region38 output value
// Bit 15:8      bottom of region37 output value
// Bit 7:0       bottom of region36 output value
#define VPP_DNLP_CTRL_09 ((0x1d8a << 2) + 0xff900000)
// Bit 31:24     bottom of region43 output value
// Bit 23:16     bottom of region42 output value
// Bit 15:8      bottom of region41 output value
// Bit 7:0       bottom of region40 output value
#define VPP_DNLP_CTRL_10 ((0x1d8b << 2) + 0xff900000)
// Bit 31:24     bottom of region47 output value
// Bit 23:16     bottom of region46 output value
// Bit 15:8      bottom of region45 output value
// Bit 7:0       bottom of region44 output value
#define VPP_DNLP_CTRL_11 ((0x1d8c << 2) + 0xff900000)
// Bit 31:24     bottom of region51 output value
// Bit 23:16     bottom of region50 output value
// Bit 15:8      bottom of region49 output value
// Bit 7:0       bottom of region48 output value
#define VPP_DNLP_CTRL_12 ((0x1d8d << 2) + 0xff900000)
// Bit 31:24     bottom of region55 output value
// Bit 23:16     bottom of region54 output value
// Bit 15:8      bottom of region53 output value
// Bit 7:0       bottom of region52 output value
#define VPP_DNLP_CTRL_13 ((0x1d8e << 2) + 0xff900000)
// Bit 31:24     bottom of region59 output value
// Bit 23:16     bottom of region58 output value
// Bit 15:8      bottom of region57 output value
// Bit 7:0       bottom of region56 output value
#define VPP_DNLP_CTRL_14 ((0x1d8f << 2) + 0xff900000)
// Bit 31:24     bottom of region63 output value
// Bit 23:16     bottom of region62 output value
// Bit 15:8      bottom of region61 output value
// Bit 7:0       bottom of region60 output value
#define VPP_DNLP_CTRL_15 ((0x1d90 << 2) + 0xff900000)
// `define VPP_PEAKING_HGAIN       8'h91   //32'h0
// `define VPP_PEAKING_VGAIN       8'h92   //32'h0
// `define VPP_PEAKING_NLP_1       8'h93   //32'h0
// `define VPP_PEAKING_NLP_2       8'h94   //32'h0
// `define VPP_PEAKING_NLP_3       8'h95   //32'h0
// `define VPP_PEAKING_NLP_4       8'h96   //32'h0
// `define VPP_PEAKING_NLP_5       8'h97   //32'h0
// `define VPP_SHARP_LIMIT         8'h98   //32'h0
// `define VPP_VLTI_CTRL           8'h99   //32'h0
// `define VPP_HLTI_CTRL           8'h9a   //32'h0
// `define VPP_CTI_CTRL            8'h9b   //32'h0
#define VPP_SRSHARP0_CTRL ((0x1d91 << 2) + 0xff900000)
// Bit 31:29  reserved
// Bit 28:16  srsharp_demo_split_sz   srsharp demo top/bot left/right width
// Bit 15:6   reserved
// Bit 5:4    srsharp_demo_disp_post  srsharp demo display postion
// Bit 3      srsharp_demo_en         srsharp demo enable
// Bit 2      srsharp_c444to422_en    srsharp format444 convert 422 enable
// Bit 1,     srsharp_buf_en          srsharp buffer enable
// Bit 0,     srsharp_en              srsharp enable
#define VPP_SRSHARP1_CTRL ((0x1d92 << 2) + 0xff900000)
// Bit 31:29  reserved
// Bit 28:16  srsharp_demo_split_sz   srsharp demo top/bot left/right width
// Bit 15:6   reserved
// Bit 5:4    srsharp_demo_disp_post  srsharp demo display postion
// Bit 3      srsharp_demo_en         srsharp demo enable
// Bit 2      srsharp_c444to422_en    srsharp format444 convert 422 enable
// Bit 1,     srsharp_buf_en          srsharp buffer enable
// Bit 0,     srsharp_en              srsharp enable
#define VPP_DOLBY_CTRL ((0x1d93 << 2) + 0xff900000)
// todo
#define VPP_DAT_CONV_PARA0 ((0x1d94 << 2) + 0xff900000)
#define VPP_DAT_CONV_PARA1 ((0x1d95 << 2) + 0xff900000)
// todo
#define VPP_SYNC_SEL0 ((0x1d96 << 2) + 0xff900000)
#define VPP_SR0_IN_SIZE ((0x1d97 << 2) + 0xff900000)
// Bit 31:29  reserved
// Bit 28:16  sr0_in_length  // unsigned  , default = 960  sr0 input length
// Bit 15:13  reserved
// Bit 12:0   sr0_in_height   // unsigned  , default = 540  sr0  input height
#define VPP_SR1_IN_SIZE ((0x1d98 << 2) + 0xff900000)
// Bit 31:29  reserved
// Bit 28:16  sr1_in_length  // unsigned  , default = 1920  sr1 input length
// Bit 15:13  reserved
// Bit 12:0   sr1_in_height   // unsigned  , default = 1080  sr1  input height
// Bit 29        blue_stretch_cb_inc
// Bit 28        blue_stretch_cr_inc
// Bit 27        the MSB of blue_stretch_error_crp_inv[11:0]
// Bit 26        the MSB of blue_stretch_error_crn_inv[11:0]
// Bit 25        the MSB of blue_stretch_error_cbp_inv[11:0]
// Bit 24        the MSB of blue_stretch_error_cbn_inv[11:0]
// Bit 23:16     blue_stretch_gain
// Bit 15:8      blue_stretch_gain_cb4cr
// Bit 7:0       blue_stretch_luma_high
#define VPP_BLUE_STRETCH_1 ((0x1d9c << 2) + 0xff900000)
// Bit 31:27     blue_stretch_error_crp
// Bit 26:16     the 11 LSB of blue_stretch_error_crp_inv[11:0]
// Bit 15:11     blue_stretch_error_crn
// Bit 10:0      the 11 LSB of blue_stretch_error_crn_inv[11:0]
#define VPP_BLUE_STRETCH_2 ((0x1d9d << 2) + 0xff900000)
// Bit 31:27     blue_stretch_error_cbp
// Bit 26:16     the 11 LSB of blue_stretch_error_cbp_inv[11:0]
// Bit 15:11     blue_stretch_error_cbn
// Bit 10:0      the 11 LSB of blue_stretch_error_cbn_inv[11:0]
#define VPP_BLUE_STRETCH_3 ((0x1d9e << 2) + 0xff900000)
#define VPP_CCORING_CTRL ((0x1da0 << 2) + 0xff900000)
// Bit 31:26 reserved
// Bit 25:16 reg_bypass_ccoring_ythd    // unsigned , default = 0   bypass_ccoring_ythd
// Bit 15:8  ccoring_th                 // unsigned , default = 0   Chroma coring threshold
// Bit 7:0   reserved
// Bit 3:0   ccoring_slope              // unsigned , default = 0   Chroma coring slope
#define VPP_VE_ENABLE_CTRL ((0x1da1 << 2) + 0xff900000)
// Bit 31:21  reserved
// Bit 20     demo_ccoring_enable     // unsigned  , default = 0 demo chroma coring enable
// Bit 19     demo_blackext_enable    // unsigned  , default = 0 demo black enxtension enable
// Bit 18     demo_dnlp_enable        // unsigned  , default = 0 demo dynamic nonlinear luma
// processing enable Bit 17     demo_hsvsharp_enable    // unsigned  , default = 0 demo hsvsharp
// enable Bit 16     demo_bluestretch_enable // unsigned  , default = 0 demo bluestretch enable
// Bit 15:14  demo_disp_position      // unsigned  , default = 0 2'b00: demo adjust on top, 2'b01:
// demo adjust on bottom, 2'b10: demo adjust on left, 2'b11: demo adjust on right Bit 13:7
// reserved Bit 6      sr4c0_path_sel          // unsigned  , default = 0 Bit 5 srscl_path_sel //
// unsigned  , default = 0 Bit 4      ccoring_en              // unsigned  , default = 0  chroma
// coring enable Bit 3      blackext_en             // unsigned  , default = 0  black enxtension
// enable Bit 2      dnlp_en                 // unsigned  , default = 0  dynamic nonlinear luma
// processing enable Bit 1      hsvsharp_en             // unsigned  , default = 0  hsvsharp
// enable Bit 0      blue_stretch_en         // unsigned  , default = 0  bluestretch enable
#define VPP_VE_DEMO_LEFT_TOP_SCREEN_WIDTH ((0x1da2 << 2) + 0xff900000)
// Bit 31:13  reserved
// Bit 12:0   ve_demo_left_top_screen_width // unsigned  , default = 0 demo left or top screen
// width
#define VPP_VE_DEMO_CENTER_BAR ((0x1da3 << 2) + 0xff900000)
#define VPP_VE_H_V_SIZE ((0x1da4 << 2) + 0xff900000)
// Bit 31:29  reserved
// Bit 28:16  ve_line_length  // unsigned  , default = 780  ve_line_length
// Bit 15:13  reserved
// Bit 12:0   ve_pic_height   // unsigned  , default = 438  ve_pic_height
#define VPP_OUT_H_V_SIZE ((0x1da5 << 2) + 0xff900000)
// Bit 31:29  reserved
// Bit 28:16  vppout_line_length  / unsigned  , default = 780   vppout_line_length
// Bit 15:13  reserved
// Bit 12:0   vppout_pic_height   // unsigned  , default = 438  vppout_pic_height
#define VPP_IN_H_V_SIZE ((0x1da6 << 2) + 0xff900000)
// Bit 31:29  reserved
// Bit 28:16  vppin_line_length  / unsigned  , default = 780   vppout_line_length
// Bit 15:13  reserved
// Bit 12:0   vppin_pic_height   // unsigned  , default = 438  vppout_pic_height
#define VPP_VDO_MEAS_CTRL ((0x1da8 << 2) + 0xff900000)
// Bit 31:11  reserved
// Bit 10:0   vdo_meas_ctrl    // unsigned  , default = 0  vdo_meas_ctrl
// Read only
// 19:16  ind_meas_count_n, every number of sync_span vsyncs, this counter add 1
// 15:0, high bit portion of counter
#define VPP_VDO_MEAS_VS_COUNT_HI ((0x1da9 << 2) + 0xff900000)
// Read only
// 31:0, low bit portion of counter
#define VPP_VDO_MEAS_VS_COUNT_LO ((0x1daa << 2) + 0xff900000)
// bit 11:9 vd2_sel,  001: select vd1_din, 010: select vd2_din, 011: select d2d3_l_din, 100:
// d2d3_r_din, otherwise no selection bit 8:6 vd1_l_sel, 001: select vd1_din, 010: select vd2_din,
// 011: select d2d3_l_din, 100: d2d3_r_din, otherwise no selection bit 5:3 vd1_r_sel, 001: select
// vd1_din, 010: select vd2_din, 011: select d2d3_l_din, 100: d2d3_r_din, otherwise no selection
// note: the source vd1_l_sel selected cannot be used as the source of vd1_r_sel or vd2_sel
// vd1_r_sel is useful only vd1_interleave_mode is not 00. And the source vd1_r_sel used can not
// used for the vd2_sel any more.
// bit 2:0 vd1_interleave_mode, 000: no interleave, 001: pixel interleaving, 010: line
// interleaving, 011: 2 pixel interleaving,
// 100: 2 line interleaving
#define VPP_INPUT_CTRL ((0x1dab << 2) + 0xff900000)
// bit 25:24 cti_bpf_sel
// bit 20:16 cti_blend_factor_gama
// bit 12:8 cti_blend_factor_beta
// bit 4:0 cti_blend_factor_alpha
#define VPP_CTI_CTRL2 ((0x1dac << 2) + 0xff900000)
// `define VPP_PEAKING_SAT_THD1 8'had
// `define VPP_PEAKING_SAT_THD2 8'hae
// `define VPP_PEAKING_SAT_THD3 8'haf
// `define VPP_PEAKING_SAT_THD4 8'hb0
// `define VPP_PEAKING_SAT_THD5 8'hb1
// `define VPP_PEAKING_SAT_THD6 8'hb2
// `define VPP_PEAKING_SAT_THD7 8'hb3
// `define VPP_PEAKING_SAT_THD8 8'hb4
// `define VPP_PEAKING_SAT_THD9 8'hb5
// `define VPP_PEAKING_GAIN_ADD1 8'hb6
// `define VPP_PEAKING_GAIN_ADD2 8'hb7
#define VPP_WRBAK_CTRL_SEC ((0x1dad << 2) + 0xff900000)
#define VD1_BLEND_SRC_CTRL_SEC ((0x1dae << 2) + 0xff900000)
#define VD2_BLEND_SRC_CTRL_SEC ((0x1daf << 2) + 0xff900000)
#define OSD1_BLEND_SRC_CTRL_SEC ((0x1db0 << 2) + 0xff900000)
#define OSD2_BLEND_SRC_CTRL_SEC ((0x1db1 << 2) + 0xff900000)
// crc check , new add
#define VPP_RO_CRCSUM ((0x1db2 << 2) + 0xff900000)
#define VPP_CRC_CHK ((0x1db3 << 2) + 0xff900000)
#define VPP_REG_OPT ((0x1db6 << 2) + 0xff900000)
// bit 23:16 peaking_dnlp_gain, u5.3, DNLP effect
// bit 15:8  peaking_factor
// bit 5     peaking_dnlp_demo_en
// bit 4     peaking_dnlp_en
// bit 3:0   peaking_filter_sel
#define VPP_PEAKING_DNLP ((0x1db8 << 2) + 0xff900000)
// bit 24    sharp_demo_win_en
// bit 23:12 sharp_demo_win_vend
// bit 11:0  sharp_demo_win_vstart
#define VPP_SHARP_DEMO_WIN_CTRL1 ((0x1db9 << 2) + 0xff900000)
// bit 23:12 sharp_demo_win_hend
// bit 11:0  sharp_demo_win_hstart
#define VPP_SHARP_DEMO_WIN_CTRL2 ((0x1dba << 2) + 0xff900000)
// Bit 31:24     front_hlti_neg_gain
// Bit 23:16     front_hlti_pos_gain
// Bit 15:8      front_hlti_threshold
// Bit 7:0       front_hlti_blend_factor
#define VPP_FRONT_HLTI_CTRL ((0x1dbb << 2) + 0xff900000)
// Bit 31        front_enable, enable the front LTI&CTI before scaler
// Bit 26:24     front_cti_step2
// Bit 23:21     front_cti_step
// Bit 20:16     front_cti_blend_factor
// Bit 15        front_cti_median_mode
// Bit 14:8      front_cti_threshold
// Bit 7:0       front_cti_gain
#define VPP_FRONT_CTI_CTRL ((0x1dbc << 2) + 0xff900000)
// bit 29:28 front_hlti_step
// bit 25:24 front_cti_bpf_sel
// bit 20:16 front_cti_blend_factor_gama
// bit 12:8  front_cti_blend_factor_beta
// bit 4:0   front_cti_blend_factor_alpha
#define VPP_FRONT_CTI_CTRL2 ((0x1dbd << 2) + 0xff900000)
// Bit 12:0 line number use to generate interrupt when line == this number
#define VPP_INT_LINE_NUM ((0x1dce << 2) + 0xff900000)
#define VPP_XVYCC_MISC ((0x1dcf << 2) + 0xff900000)
// new add lti/cti in 120924
// Bit  3: 0        //default== 0  reg_hlti_dn_flt_coe[0]
// Bit  7: 4        //default== 0  reg_hlti_dn_flt_coe[1]
// Bit 11: 8        //default== 0  reg_hlti_dn_flt_coe[2]
// Bit 15:12        //default== 2  reg_hlti_dn_flt_coe[3]
// Bit 19:16        //default== 4  reg_hlti_dn_flt_coe[4]
// Bit 22:20        //default== 3  reg_hlti_dn_flt_nrm  u3: 3~7
#define VPP_HLTI_DN_FLT ((0x1dd0 << 2) + 0xff900000)
// Bit  7: 0        //default== 8  reg_hlti_bst_gain  u8, norm 16 as "1"
// Bit 15: 8        //default== 20 reg_hlti_bst_core  u8, norm 32 as "1"
// Bit 23:16        //default== 32 reg_hlti_oob_gain  u8, norm 32 as "1"
// Bit 28:24        //default== 0  reg_hlti_oob_core  u5
#define VPP_HLTI_GAIN ((0x1dd1 << 2) + 0xff900000)
// Bit  7: 0        //default== 2  reg_hlti_clp_ofst  u8,
// Bit     8        //default== 0  reg_hlti_clp_mode  u1,
// Bit 11: 9        //default== 1  reg_hlti_clp_wind  u3,
// Bit 14:12        //default== 1  reg_hlti_bst_fltr  u3,
// Bit    15        //default== 1  reg_hlti_enable    u1,
#define VPP_HLTI_PARA ((0x1dd2 << 2) + 0xff900000)
// Bit  3: 0        //default== 0  reg_hcti_dn_flt_coe[0]
// Bit  7: 4        //default== 0  reg_hcti_dn_flt_coe[1]
// Bit 11: 8        //default== 1  reg_hcti_dn_flt_coe[2]
// Bit 15:12        //default== 2  reg_hcti_dn_flt_coe[3]
// Bit 19:16        //default== 2  reg_hcti_dn_flt_coe[4]
// Bit 22:20        //default== 3  reg_hcti_dn_flt_nrm   u3: 3~7
#define VPP_HCTI_DN_FLT ((0x1dd3 << 2) + 0xff900000)
// Bit 7: 0        //default== 48 reg_hcti_bst_gain  u8, norm 16 as "1"
// Bit15: 8        //default== 17 reg_hcti_bst_core  u8, norm 32 as "1"
// Bit23:16        //default== 16 reg_hcti_oob_gain  u8, norm 32 as "1"
// Bit28:24        //default==  0 reg_hcti_oob_core  u5
#define VPP_HCTI_GAIN ((0x1dd4 << 2) + 0xff900000)
// Bit  7: 0        //default==  0 reg_hcti_clp_ofst  u8,
// Bit     8        //default==  1 reg_hcti_clp_mode  u1,
// Bit 11: 9        //default==  3 reg_hcti_clp_wind  u3,
// Bit 14:12        //default==  6 reg_hcti_bst_fltr  u3,
// Bit    15        //default==  1 reg_hcti_enable    u1,
#define VPP_HCTI_PARA ((0x1dd5 << 2) + 0xff900000)
// Bit  7: 0        //default== 48 reg_vcti_bst_gain  u8, normalize 16 as "1"
// Bit 15: 8        //default== 10 reg_vcti_bst_core  u8
// Bit 19:16        //default== 10 reg_vcti_clp_ofst  u4
// Bit    20        //default==  1 reg_vcti_clp_wind  u1, 0: wind 3, 1: wind5
#define VPP_VCTI_PARA ((0x1dd6 << 2) + 0xff900000)
//`define VPP_MATRIX_PROBE_COLOR1 8'hd7  //defined before
// Bit 31          //default== 0, urgent fifo hold enable
// Bit 28:12       //default== 0, urgent fifo hold line threshold
// Bit 15          //default== 0, urgent_ctrl_en
// Bit 14          //default== 0, urgent_wr, if true for write buffer
// Bit 13          //default== 0, out_inv_en
// Bit 12          //default == 0, urgent_ini_value
// Bit 11:6        //default == 0, up_th  up threshold
// Bit 5:0         //default == 0, dn_th  dn threshold
#define VPP_OFIFO_URG_CTRL ((0x1dd8 << 2) + 0xff900000)
#define VPP_CLIP_MISC0 ((0x1dd9 << 2) + 0xff900000)
// Bit 29:20       // default == 1023, final clip r channel top
// Bit 19:10       // default == 1023, final clip g channel top
// Bit  9: 0       // default == 1023, final clip b channel top
#define VPP_CLIP_MISC1 ((0x1dda << 2) + 0xff900000)
// Bit 29:20       // default ==    0, final clip r channel bottom
// Bit 19:10       // default ==    0, final clip g channel bottom
// Bit  9: 0       // default ==    0, final clip b channel bottom
#define VPP_MATRIX_COEF13_14 ((0x1ddb << 2) + 0xff900000)
// Bit 28:16       // default == 0, matrix coef13
// Bit 12:0        // default == 0, matrix coef14
#define VPP_MATRIX_COEF23_24 ((0x1ddc << 2) + 0xff900000)
// Bit 28:16       // default == 0, matrix coef23
// Bit 12:0        // default == 0, matrix coef24
#define VPP_MATRIX_COEF15_25 ((0x1ddd << 2) + 0xff900000)
// Bit 28:16       // default == 0, matrix coef15
// Bit 12:0        // default == 0, matrix coef25
#define VPP_MATRIX_CLIP ((0x1dde << 2) + 0xff900000)
// Bit 7:5         //  default == 0,   mat rs
// Bit 4:3         //  default == 0,   mat clmod
// Bit 2:0         //  default == 0,   mat clip enable
#define VPP_XVYCC_MISC0 ((0x1ddf << 2) + 0xff900000)
// Bit 29:20       // default == 1023, xvycc clip r channel top
// Bit 19:10       // default == 1023, xvycc clip g channel top
// Bit  9: 0       // default == 1023, xvycc clip b channel top
#define VPP_XVYCC_MISC1 ((0x1de0 << 2) + 0xff900000)
// Bit 29:20       // default ==    0, xvycc clip r channel bottom
// Bit 19:10       // default ==    0, xvycc clip g channel bottom
// Bit  9: 0       // default ==    0, xvycc clip b channel bottom
#define VPP_VD1_CLIP_MISC0 ((0x1de1 << 2) + 0xff900000)
// Bit 29:20       // default == 1023, vd1 clip r channel top
// Bit 19:10       // default == 1023, vd1 clip g channel top
// Bit  9: 0       // default == 1023, vd1 clip b channel top
#define VPP_VD1_CLIP_MISC1 ((0x1de2 << 2) + 0xff900000)
// Bit 29:20       // default ==    0, vd1 clip r channel bottom
// Bit 19:10       // default ==    0, vd1 clip g channel bottom
// Bit  9: 0       // default ==    0, vd1 clip b channel bottom
#define VPP_VD2_CLIP_MISC0 ((0x1de3 << 2) + 0xff900000)
// Bit 29:20       // default == 1023, vd2 clip r channel top
// Bit 19:10       // default == 1023, vd2 clip g channel top
// Bit  9: 0       // default == 1023, vd2 clip b channel top
#define VPP_VD2_CLIP_MISC1 ((0x1de4 << 2) + 0xff900000)
// Bit 29:20       // default ==    0, vd2 clip r channel bottom
// Bit 19:10       // default ==    0, vd2 clip g channel bottom
// Bit  9: 0       // default ==    0, vd2 clip b channel bottom
#define VPP_VD3_CLIP_MISC0 ((0x1de5 << 2) + 0xff900000)
// Bit 29:20       // default == 1023, vd2 clip r channel top
// Bit 19:10       // default == 1023, vd2 clip g channel top
// Bit  9: 0       // default == 1023, vd2 clip b channel top
#define VPP_VD3_CLIP_MISC1 ((0x1de6 << 2) + 0xff900000)
// Bit 29:20       // default ==    0, vd2 clip r channel bottom
// Bit 19:10       // default ==    0, vd2 clip g channel bottom
// Bit  9: 0       // default ==    0, vd2 clip b channel bottom
#define VPP_BLEND_VD3_H_START_END ((0x1deb << 2) + 0xff900000)
// Bit 28:16 start
// Bit 12:0  end
#define VPP_BLEND_VD3_V_START_END ((0x1dec << 2) + 0xff900000)
// Bit 28:16 start
// Bit 12:0  end
#define VD3_BLEND_SRC_CTRL ((0x1def << 2) + 0xff900000)
#define VPP_VD2_HDR_IN_SIZE ((0x1df0 << 2) + 0xff900000)
// Bit 31:16       // default ==    0
// Bit 15:0        // default ==    0
#define VPP_OSD1_IN_SIZE ((0x1df1 << 2) + 0xff900000)
// Bit 31:16       // default ==    0
// Bit 15:0        // default ==    0
#define VPP_GCLK_CTRL2 ((0x1df2 << 2) + 0xff900000)
//`define VPP_BLEND_SRC_SEL               8'hf3
//`define VD2_PPS_DUMMY_DATA              8'hf4
#define VPP_OSD1_BLD_H_SCOPE ((0x1df5 << 2) + 0xff900000)
#define VPP_OSD1_BLD_V_SCOPE ((0x1df6 << 2) + 0xff900000)
#define VPP_OSD2_BLD_H_SCOPE ((0x1df7 << 2) + 0xff900000)
#define VPP_OSD2_BLD_V_SCOPE ((0x1df8 << 2) + 0xff900000)
#define VPP_WRBAK_CTRL ((0x1df9 << 2) + 0xff900000)
#define VPP_SLEEP_CTRL ((0x1dfa << 2) + 0xff900000)
#define VD1_BLEND_SRC_CTRL ((0x1dfb << 2) + 0xff900000)
#define VD2_BLEND_SRC_CTRL ((0x1dfc << 2) + 0xff900000)
#define OSD1_BLEND_SRC_CTRL ((0x1dfd << 2) + 0xff900000)
#define OSD2_BLEND_SRC_CTRL ((0x1dfe << 2) + 0xff900000)
//`define VPP_OSD_SCALE_CTRL              8'hff
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpp_regs.h
//
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  DISP_IF1_VCBUS_BASE = 0x1e
// -----------------------------------------------
//===========================================================================
//`include "disp_if_regs.h"
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  DISP_IF2_VCBUS_BASE = 0x1f
// -----------------------------------------------
//===========================================================================
//`include "disp_if_regs.h"
//===========================================================================
//`define VIUB_VCBUS_BASE                8'h20
//===========================================================================
//
// Reading file:  vregs_clk1.h
//
//===========================================================================
// Video Interface Registers    0xa00 - 0xaff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VIUB_VCBUS_BASE = 0x20
// -----------------------------------------------
#define VIUB_ADDR_START ((0x2000 << 2) + 0xff900000)
#define VIUB_ADDR_END ((0x20ff << 2) + 0xff900000)
//`define TRACE_REG 8'ff
//------------------------------------------------------------------------------
// VIU top-level registers
//------------------------------------------------------------------------------
// Bit  0 RW, osd1_reset
// Bit  1 RW, osd2_reset
// Bit  2 RW, vd1_reset
// Bit  3 RW, vd1_fmt_reset
// Bit  4 RW, vd2_reset
// Bit  5 RW, vd2_fmt_reset
// Bit  6 RW, di_dsr1to2_reset
// Bit  7 RW, vpp_reset
// Bit  8 RW, di_if1_reset
// Bit  9 RW, di_if1_fmt_reset
// Bit 10 RW, di_inp_reset
// Bit 11 RW, di_inp_fmt_reset
// Bit 12 RW, di_mem_reset
// Bit 13 RW, di_mem_fmt_reset
// Bit 14 RW, di_nr_wr_mif_reset
// Bit 15 RW, dein_wr_mif_reset
// Bit 16 RW, di_chan2_mif_reset
// Bit 17 RW, di_mtn_wr_mif_reset
// Bit 18 RW, di_mtn_rd_mif_reset
// Bit 19 RW, di_mad_reset
// Bit 20 RW, vdin0_reset
// Bit 21 RW, vdin1_reset
// Bit 22 RW, nrin_mux_reset
// Bit 23 RW, vdin0_wr_reset
// Bit 24 RW, vdin1_wr_reset
// Bit 25 RW, reserved
// Bit 26 RW, d2d3_reset
// Bit 27 RW, di_cont_wr_mif_reset
// Bit 28 RW, di_cont_rd_mif_reset
#define VIUB_SW_RESET ((0x2001 << 2) + 0xff900000)
#define VIUB_SW_RESET0 ((0x2002 << 2) + 0xff900000)
// Bit 0 RW, software reset for mcvecrd_mif
// Bit 1 RW, software reset for mcinfowr_mif
// Bit 2 RW, software reset for mcinford_mif
#define DI_AFBCE_CTRL ((0x2003 << 2) + 0xff900000)
#define VIUB_SECURE_ST_RO ((0x2004 << 2) + 0xff900000)
// bit 8 if true, vsync interrupt is generate only field == 0
// bit 7:0 fix_disable
#define VIUB_MISC_CTRL0 ((0x2006 << 2) + 0xff900000)
#define VIUB_GCLK_CTRL0 ((0x2007 << 2) + 0xff900000)
//// gclk_ctrl0_gl[ 0] : def=1 di_top_wrap clk enable
////
//// gclk_ctrl0_gl[ 8] : def=0 mad pre clock enable, from mad clock
//// gclk_ctrl0_gl[ 9] : def=0 mad post clock enable, from mad clock
//// gclk_ctrl0_gl[10] : def=0 div clock enable, di slow clock including di&mcdi
//// gclk_ctrl0_gl[11] : def=0 mcdi clock enable, from div clock
//// gclk_ctrl0_gl[12] : def=0 di post clock enable, from div clock
//// gclk_ctrl0_gl[13] : def=0 reserved
//// gclk_ctrl0_gl[14] : def=1 di_no_clk_gate, for old di
//// gclk_ctrl0_gl[15] : def=0 di_gate_all, for old di
#define VIUB_GCLK_CTRL1 ((0x2008 << 2) + 0xff900000)
//// gclk_ctrl1_gl[ 1: 0] : def=2'b00 mif-sub-arb clock gate ctrl [1]: clock valid, [0]: clock
/// close / gclk_ctrl1_gl[ 3: 2] : def=2'b00 if1 rdmif clock gate ctrl [1]: clock valid, [0]:
/// clock close / gclk_ctrl1_gl[ 5: 4] : def=2'b00 if2 rdmif clock gate ctrl [1]: clock valid, [0]:
/// clock close / gclk_ctrl1_gl[ 7: 6] : def=2'b00 de wrmif clock gate ctrl [1]: clock valid, [0]:
/// clock close / gclk_ctrl1_gl[ 9: 8] : def=2'b00 mtnrd post mif clock gate ctrl [1]: clock valid,
/// [0]: clock close / gclk_ctrl1_gl[11:10] : def=2'b00 mcdi post mif clock gate ctrl [1]: clock
/// valid, [0]: clock close / gclk_ctrl1_gl[17:16] : def=2'b00 inp rdmif clock gate ctrl [1]: clock
///valid, [0]: clock close / gclk_ctrl1_gl[19:18] : def=2'b00 mem rdmif clock gate ctrl [1]: clock
///valid, [0]: clock close / gclk_ctrl1_gl[21:20] : def=2'b00 chan rdmif clock gate ctrl [1]:
///clock valid, [0]: clock close / gclk_ctrl1_gl[23:22] : def=2'b00 nr wrmif clock gate ctrl [1]:
/// clock valid, [0]: clock close / gclk_ctrl1_gl[25:24] : def=2'b00 mtn mif clock gate ctrl [1]:
/// clock valid, [0]: clock close / gclk_ctrl1_gl[27:26] : def=2'b00 mcdi pre mif clock gate ctrl
/// [1]: clock valid, [0]: clock close
////
#define VIUB_GCLK_CTRL2 ((0x2009 << 2) + 0xff900000)
//// gclk_ctrl_pre[ 1: 0] : def=2'b00 nr clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl_pre[ 3: 2] : def=2'b00 pd clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl_pre[ 5: 4] : def=2'b00 mtn det clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl_pre[ 7: 6] : def=2'b00 debanding clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl_pre[ 9: 8] : def=2'b00 dnr clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl_pre[11:10] : def=2'b00 nr&dnr blend clock gate ctrl [1]: clock valid, [0]: clock
/// close / gclk_ctrl_pre[13:12] : def=2'b00 mcdi clock gate ctrl [1]: clock valid, [0]: clock
/// close
#define VIUB_GCLK_CTRL3 ((0x200a << 2) + 0xff900000)
//// gclk_ctrl_post[ 1: 0] : def=2'b00 di blend clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl_post[ 3: 2] : def=2'b00 ei clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl_post[ 5: 4] : def=2'b00 ei_0 clock gate ctrl [1]: clock valid, [0]: clock close
#define DI_DBG_CTRL ((0x200b << 2) + 0xff900000)
#define DI_DBG_CTRL1 ((0x200c << 2) + 0xff900000)
#define DI_DBG_SRDY_INF ((0x200d << 2) + 0xff900000)
#define DI_DBG_RRDY_INF ((0x200e << 2) + 0xff900000)
#define VIUB_SECURE_REG ((0x200f << 2) + 0xff900000)
#define DI_PRE_SEC_IN ((0x2010 << 2) + 0xff900000)
#define DI_POST_SEC_IN ((0x2011 << 2) + 0xff900000)
// the segment is 8'h14-8'h27
//
// Reading file:  ai_sr_pre_regs.h
//
// reg_base = 0x20_xx
#define NN_LRHF0 ((0x2014 << 2) + 0xff900000)
// Bit 31           reg_lrhf_en
// Bit 29:26        reg_gclk_ctrl[3:0]
// Bit 25:16        reg_lrhf_hf_gain_neg
// Bit 9:0          reg_lrhf_hf_gain_pos
#define NN_LRHF1 ((0x2015 << 2) + 0xff900000)
// Bit 31:28        reg_gclk_ctrl[7:4]
// Bit 26:16        reg_lrhf_lpf_coeff01
// Bit 10:0         reg_lrhf_lpf_coeff00
#define NN_LRHF2 ((0x2016 << 2) + 0xff900000)
// Bit 31:28        reg_gclk_ctrl[11:8]
// Bit 26:16        reg_lrhf_lpf_coeff10
// Bit 10:0         reg_lrhf_lpf_coeff02
#define NN_LRHF3 ((0x2017 << 2) + 0xff900000)
// Bit 26:16        reg_lrhf_lpf_coeff12
// Bit 10:0         reg_lrhf_lpf_coeff11
#define NN_LRHF4 ((0x2018 << 2) + 0xff900000)
// Bit 26:16        reg_lrhf_lpf_coeff21
// Bit 10:0         reg_lrhf_lpf_coeff20
#define NN_LRHF5 ((0x2019 << 2) + 0xff900000)
// Bit 31:24        reg_hblank_num
// Bit 23:16        reg_vblank_num
// Bit 10:0         eg_lrhf_lpf_coeff22
#define NN_LRHF6 ((0x201a << 2) + 0xff900000)
// Bit 31:24        reg_lrhf_pad_val
// Bit 22:12        reg_lrhf_pad_cols
// Bit 11           reg_dummy_en
// Bit 10:0         reg_lrhf_pad_rows
#define AISR_PRE_WRMIF_BADDR ((0x2020 << 2) + 0xff900000)
//`define AISR_PRE_WMIF_CTRL1    AISR_PRE_WRMIF_BADDR+8'h00;  8'h20
#define AISR_PRE_WMIF_CTRL2 ((0x2021 << 2) + 0xff900000)
#define AISR_PRE_WMIF_CTRL3 ((0x2022 << 2) + 0xff900000)
#define AISR_PRE_WMIF_CTRL4 ((0x2023 << 2) + 0xff900000)
#define AISR_PRE_WMIF_SCOPE_X ((0x2024 << 2) + 0xff900000)
#define AISR_PRE_WMIF_SCOPE_Y ((0x2025 << 2) + 0xff900000)
#define AISR_PRE_WMIF_RO_STAT ((0x2026 << 2) + 0xff900000)
//
// Closing file:  ai_sr_pre_regs.h
//
//`define DI_IF2_GEN_REG            8'h10
//`define DI_IF2_CANVAS0            8'h11
//`define DI_IF2_LUMA_X0            8'h12
//`define DI_IF2_LUMA_Y0            8'h13
//`define DI_IF2_CHROMA_X0          8'h14
//`define DI_IF2_CHROMA_Y0          8'h15
//`define DI_IF2_RPT_LOOP           8'h16
//`define DI_IF2_LUMA0_RPT_PAT      8'h17
//`define DI_IF2_CHROMA0_RPT_PAT    8'h18
//`define DI_IF2_DUMMY_PIXEL        8'h19
//`define DI_IF2_LUMA_FIFO_SIZE     8'h1a
//`define DI_IF2_RANGE_MAP_Y        8'h1b
//`define DI_IF2_RANGE_MAP_CB       8'h1c
//`define DI_IF2_RANGE_MAP_CR       8'h1d
//`define DI_IF2_GEN_REG2           8'h1e
//`define DI_IF2_FMT_CTRL           8'h1f
//`define DI_IF2_FMT_W              8'h20
//
//`define DI_IF2_URGENT_CTRL		  8'h21
// bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di
// inp chroma path bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 ,
// low threshold  for di inp luma path `define DI_IF2_GEN_REG3           8'h22 bit 31:1,  reversed
// bit 0,     cntl_64bit_rev
//==================================
#define DI_EI_DRT_CTRL ((0x2028 << 2) + 0xff900000)
// Bit 31,     reg_rectg_en      ;u1
// Bit 30,     reg_recbld_en     ;u1
// Bit 29:28,  reg_rectg_ws      ;u2
// Bit 27,     reserved
// Bit 26:24,  reg_abq_margin    ;u3
// Bit 23,     reserved
// Bit 22:20,  reg_trend_mg      ;u3
// Bit 19:16,  reg_int_d16xc1    ;u4
// Bit 15:14,  reserved
// Bit 13: 8,  reg_int_chlmt1    ;u6
// Bit  7,     reserved
// Bit  6: 4,  reg_nscheck_thrd  ;u3
// Bit  3,     reserved
// Bit  2: 0,  reg_horsl_ws      ;u3
#define DI_EI_DRT_PIXTH ((0x2029 << 2) + 0xff900000)
// Bit 31:24,  reg_min_pix        ;u8
// Bit 23:16,  reg_max_pix        ;u8
// Bit 15: 8,  reg_dmaxmin_thrdma ;u8
// Bit  7: 0,  reg_dmaxmin_thrdmi ;u8
#define DI_EI_DRT_CORRPIXTH ((0x202a << 2) + 0xff900000)
// Bit 31:24,  reg_newcorrpix_maxthrd ;u8
// Bit 23:16,  reg_corrpix_diffthrd   ;u8
// Bit 15: 8,  reg_corrpix_minthrd    ;u8
// Bit  7: 0,  reg_corrpix_maxthrd    ;u8
#define DI_EI_DRT_RECTG_WAVE ((0x202b << 2) + 0xff900000)
// Bit 31:29,  reserved
// Bit 28:24,  reg_max_pixwave  ;u5
// Bit 23:21,  reserved
// Bit 20:16,  reg_pix_wave     ;u5
// Bit 15:14,  reserved
// Bit 13: 8,  reg_maxdrt_thrd  ;u6
// Bit  7: 0,  reg_wave_thrd    ;u8
#define DI_EI_DRT_PIX_DIFFTH ((0x202c << 2) + 0xff900000)
// Bit 31:24,  reg_newraw_thrd    ;u8
// Bit 23:16,  reg_tb_max_thrd    ;u8
// Bit 15: 8,  reg_diffpix_thrd   ;u8
// Bit  7: 6,  reserved
// Bit  5: 0,  reg_bilt_trendnumt ;u8
#define DI_EI_DRT_UNBITREND_TH ((0x202d << 2) + 0xff900000)
// Bit 31:29,  reserved
// Bit 28:24,  reg_trend_numb     ;u5
// Bit 23:21,  reserved
// Bit 20:16,  reg_bilt_trendnum  ;u5
// Bit 15:13,  reserved
// Bit 12: 8,  reg_unil_trendnumt ;u5
// Bit  7: 5,  reserved
// Bit  4: 0,  reg_trend_num      ;u5
//`define DI_IF0_GEN_REG            8'h30
//`define DI_IF0_CANVAS0            8'h31
//`define DI_IF0_LUMA_X0            8'h32
//`define DI_IF0_LUMA_Y0            8'h33
//`define DI_IF0_CHROMA_X0          8'h34
//`define DI_IF0_CHROMA_Y0          8'h35
//`define DI_IF0_RPT_LOOP           8'h36
//`define DI_IF0_LUMA0_RPT_PAT      8'h37
//`define DI_IF0_CHROMA0_RPT_PAT    8'h38
//`define DI_IF0_DUMMY_PIXEL        8'h39
//`define DI_IF0_LUMA_FIFO_SIZE     8'h3a
//`define DI_IF0_RANGE_MAP_Y        8'h3b
//`define DI_IF0_RANGE_MAP_CB       8'h3c
//`define DI_IF0_RANGE_MAP_CR       8'h3d
//`define DI_IF0_GEN_REG2           8'h3e
//`define DI_IF0_FMT_CTRL           8'h3f
//`define DI_IF0_FMT_W              8'h40
//
//`define DI_IF0_URGENT_CTRL		  8'h41
// bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di
// inp chroma path bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 ,
// low threshold  for di inp luma path `define DI_IF0_GEN_REG3           8'h42 bit 31:1,  reversed
// bit 0,     cntl_64bit_rev the segment is 8'h30-8'h4f
//
// Reading file:  noise_estimate_reg.h
//
// synopsys translate_off
// synopsys translate_on
// REG BASE : 0x20   0x2030~0x204a
// within vregs_clk1.h
#define NR4_NE_X ((0x2030 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:16        reg_nr4_ne_xst            // unsigned ,    RW, default = 14  2~3833
// Bit 15:12        reserved
// Bit 11: 0        reg_nr4_ne_xed            // unsigned ,    RW, default = 1904  7~3838
#define NR4_NE_Y ((0x2031 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:16        reg_nr4_ne_yst            // unsigned ,    RW, default = 14  2~2173
// Bit 15:12        reserved
// Bit 11: 0        reg_nr4_ne_yed            // unsigned ,    RW, default = 1064  7~2178
#define NR4_NE_TOP ((0x2032 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_nr4_ne_luma_LowLimit  // unsigned ,    RW, default = 16  0~255
// Bit 15: 8        reg_nr4_ne_luma_HigLimit  // unsigned ,    RW, default = 235  0~255
// Bit  7: 4        reg_nr4_ne_gate           // unsigned ,    RW, default = 0
// Bit  3: 1        reserved
// Bit  0           reg_nr4_ne_enable         // unsigned ,    RW, default = 1
#define RO_NR4_NE_SBVAR_0 ((0x2033 << 2) + 0xff900000)
// Bit 31:27        reserved
// Bit 26:16        ro_nr4_ne_spatial_blockvar_1 // unsigned ,    RO, default = 0
// Bit 15:11        reserved
// Bit 10: 0        ro_nr4_ne_spatial_blockvar_0 // unsigned ,    RO, default = 0
#define RO_NR4_NE_SBVAR_1 ((0x2034 << 2) + 0xff900000)
// Bit 31:27        reserved
// Bit 26:16        ro_nr4_ne_spatial_blockvar_3 // unsigned ,    RO, default = 0
// Bit 15:11        reserved
// Bit 10: 0        ro_nr4_ne_spatial_blockvar_2 // unsigned ,    RO, default = 0
#define RO_NR4_NE_SBVAR_2 ((0x2035 << 2) + 0xff900000)
// Bit 31:27        reserved
// Bit 26:16        ro_nr4_ne_spatial_blockvar_5 // unsigned ,    RO, default = 0
// Bit 15:11        reserved
// Bit 10: 0        ro_nr4_ne_spatial_blockvar_4 // unsigned ,    RO, default = 0
#define RO_NR4_NE_SBVAR_3 ((0x2036 << 2) + 0xff900000)
// Bit 31:27        reserved
// Bit 26:16        ro_nr4_ne_spatial_blockvar_7 // unsigned ,    RO, default = 0
// Bit 15:11        reserved
// Bit 10: 0        ro_nr4_ne_spatial_blockvar_6 // unsigned ,    RO, default = 0
#define RO_NR4_NE_SBVAR_4 ((0x2037 << 2) + 0xff900000)
// Bit 31:27        reserved
// Bit 26:16        ro_nr4_ne_spatial_blockvar_9 // unsigned ,    RO, default = 0
// Bit 15:11        reserved
// Bit 10: 0        ro_nr4_ne_spatial_blockvar_8 // unsigned ,    RO, default = 0
#define RO_NR4_NE_SBVAR_5 ((0x2038 << 2) + 0xff900000)
// Bit 31:27        reserved
// Bit 26:16        ro_nr4_ne_spatial_blockvar_11 // unsigned ,    RO, default = 0
// Bit 15:11        reserved
// Bit 10: 0        ro_nr4_ne_spatial_blockvar_10 // unsigned ,    RO, default = 0
#define RO_NR4_NE_SBVAR_6 ((0x2039 << 2) + 0xff900000)
// Bit 31:27        reserved
// Bit 26:16        ro_nr4_ne_spatial_blockvar_13 // unsigned ,    RO, default = 0
// Bit 15:11        reserved
// Bit 10: 0        ro_nr4_ne_spatial_blockvar_12 // unsigned ,    RO, default = 0
#define RO_NR4_NE_SBVAR_7 ((0x203a << 2) + 0xff900000)
// Bit 31:27        reserved
// Bit 26:16        ro_nr4_ne_spatial_blockvar_15 // unsigned ,    RO, default = 0
// Bit 15:11        reserved
// Bit 10: 0        ro_nr4_ne_spatial_blockvar_14 // unsigned ,    RO, default = 0
#define RO_NR4_NE_TBVAR_0 ((0x203b << 2) + 0xff900000)
// Bit 31:27        reserved
// Bit 26:16        ro_nr4_ne_temporal_blockvar_1 // unsigned ,    RO, default = 0
// Bit 15:11        reserved
// Bit 10: 0        ro_nr4_ne_temporal_blockvar_0 // unsigned ,    RO, default = 0
#define RO_NR4_NE_TBVAR_1 ((0x203c << 2) + 0xff900000)
// Bit 31:27        reserved
// Bit 26:16        ro_nr4_ne_temporal_blockvar_3 // unsigned ,    RO, default = 0
// Bit 15:11        reserved
// Bit 10: 0        ro_nr4_ne_temporal_blockvar_2 // unsigned ,    RO, default = 0
#define RO_NR4_NE_TBVAR_2 ((0x203d << 2) + 0xff900000)
// Bit 31:27        reserved
// Bit 26:16        ro_nr4_ne_temporal_blockvar_5 // unsigned ,    RO, default = 0
// Bit 15:11        reserved
// Bit 10: 0        ro_nr4_ne_temporal_blockvar_4 // unsigned ,    RO, default = 0
#define RO_NR4_NE_TBVAR_3 ((0x203e << 2) + 0xff900000)
// Bit 31:27        reserved
// Bit 26:16        ro_nr4_ne_temporal_blockvar_7 // unsigned ,    RO, default = 0
// Bit 15:11        reserved
// Bit 10: 0        ro_nr4_ne_temporal_blockvar_6 // unsigned ,    RO, default = 0
#define RO_NR4_NE_TBVAR_4 ((0x203f << 2) + 0xff900000)
// Bit 31:27        reserved
// Bit 26:16        ro_nr4_ne_temporal_blockvar_9 // unsigned ,    RO, default = 0
// Bit 15:11        reserved
// Bit 10: 0        ro_nr4_ne_temporal_blockvar_8 // unsigned ,    RO, default = 0
#define RO_NR4_NE_TBVAR_5 ((0x2040 << 2) + 0xff900000)
// Bit 31:27        reserved
// Bit 26:16        ro_nr4_ne_temporal_blockvar_11 // unsigned ,    RO, default = 0
// Bit 15:11        reserved
// Bit 10: 0        ro_nr4_ne_temporal_blockvar_10 // unsigned ,    RO, default = 0
#define RO_NR4_NE_TBVAR_6 ((0x2041 << 2) + 0xff900000)
// Bit 31:27        reserved
// Bit 26:16        ro_nr4_ne_temporal_blockvar_13 // unsigned ,    RO, default = 0
// Bit 15:11        reserved
// Bit 10: 0        ro_nr4_ne_temporal_blockvar_12 // unsigned ,    RO, default = 0
#define RO_NR4_NE_TBVAR_7 ((0x2042 << 2) + 0xff900000)
// Bit 31:27        reserved
// Bit 26:16        ro_nr4_ne_temporal_blockvar_15 // unsigned ,    RO, default = 0
// Bit 15:11        reserved
// Bit 10: 0        ro_nr4_ne_temporal_blockvar_14 // unsigned ,    RO, default = 0
#define RO_NR4_NE_TBSUM_0 ((0x2043 << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:16        ro_nr4_ne_temporal_blockmean_1 // unsigned ,    RO, default = 0
// Bit 15:13        reserved
// Bit 12: 0        ro_nr4_ne_temporal_blockmean_0 // unsigned ,    RO, default = 0
#define RO_NR4_NE_TBSUM_1 ((0x2044 << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:16        ro_nr4_ne_temporal_blockmean_3 // unsigned ,    RO, default = 0
// Bit 15:13        reserved
// Bit 12: 0        ro_nr4_ne_temporal_blockmean_2 // unsigned ,    RO, default = 0
#define RO_NR4_NE_TBSUM_2 ((0x2045 << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:16        ro_nr4_ne_temporal_blockmean_5 // unsigned ,    RO, default = 0
// Bit 15:13        reserved
// Bit 12: 0        ro_nr4_ne_temporal_blockmean_4 // unsigned ,    RO, default = 0
#define RO_NR4_NE_TBSUM_3 ((0x2046 << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:16        ro_nr4_ne_temporal_blockmean_7 // unsigned ,    RO, default = 0
// Bit 15:13        reserved
// Bit 12: 0        ro_nr4_ne_temporal_blockmean_6 // unsigned ,    RO, default = 0
#define RO_NR4_NE_TBSUM_4 ((0x2047 << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:16        ro_nr4_ne_temporal_blockmean_9 // unsigned ,    RO, default = 0
// Bit 15:13        reserved
// Bit 12: 0        ro_nr4_ne_temporal_blockmean_8 // unsigned ,    RO, default = 0
#define RO_NR4_NE_TBSUM_5 ((0x2048 << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:16        ro_nr4_ne_temporal_blockmean_11 // unsigned ,    RO, default = 0
// Bit 15:13        reserved
// Bit 12: 0        ro_nr4_ne_temporal_blockmean_10 // unsigned ,    RO, default = 0
#define RO_NR4_NE_TBSUM_6 ((0x2049 << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:16        ro_nr4_ne_temporal_blockmean_13 // unsigned ,    RO, default = 0
// Bit 15:13        reserved
// Bit 12: 0        ro_nr4_ne_temporal_blockmean_12 // unsigned ,    RO, default = 0
#define RO_NR4_NE_TBSUM_7 ((0x204a << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:16        ro_nr4_ne_temporal_blockmean_15 // unsigned ,    RO, default = 0
// Bit 15:13        reserved
// Bit 12: 0        ro_nr4_ne_temporal_blockmean_14 // unsigned ,    RO, default = 0
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  noise_estimate_reg.h
//
// di arbtration :
// the segment is 8'h50-8'h5f
//
// Reading file:  di_arb_axi_regs.h
//
// synopsys translate_off
// synopsys translate_on
////===============================////
//// reg
////===============================////
//`define VIUB_VCBUS_BASE                8'h20         // VIU address space
#define DI_RDARB_MODE_L1C1 ((0x2050 << 2) + 0xff900000)
// Bit   31:22,    reserved
// Bit   21:16,    rdarb_sel           uns, default = 0 ,
//                                    rdarb_sel[0]==0 slave dc0 connect master port0
//                                    rdarb_sel[0]==1 slave dc0 connect master port1
//                                    rdarb_sel[1]==0 slave dc1 connect master port0
//                                    rdarb_sel[1]==1 slave dc1 connect master port1
//                                    rdarb_sel[2]==0 slave dc2 connect master port0
//                                    rdarb_sel[2]==1 slave dc2 connect master port1
//                                    rdarb_sel[3]==0 slave dc3 connect master port0
//                                    rdarb_sel[3]==1 slave dc3 connect master port1
//                                    rdarb_sel[4]==0 slave dc4 connect master port0
//                                    rdarb_sel[4]==1 slave dc4 connect master port1
//                                    rdarb_sel[5]==0 slave dc5 connect master port0
//                                    rdarb_sel[5]==1 slave dc5 connect master port1
// Bit   15:10,    reserved
// Bit   9:8,      rdarb_arb_mode      uns, default = 0 ,
//                                    rdarb_arb_mode[0] master port0 arb way,
//                                    rdarb_arb_mode[1] master port1 arb way,
// Bit   7:4,      reserved
// Bit   3:0,      rdarb_gate_clk_ctrl uns, default = 0 ,
//                                    rdarb_gate_clk_ctrl[1:0] master port0 clk gate control
//                                    rdarb_gate_clk_ctrl[3:2] master port1 clk gate control
#define DI_RDARB_REQEN_SLV_L1C1 ((0x2051 << 2) + 0xff900000)
// Bit   31:12,     reserved
// Bit   11:0,     rdarb_dc_req_en     unsigned  , default = 12'hfff
//                                    rdarb_dc_req_en[0]: the slv0 req to mst port0 enable,
//                                    rdarb_dc_req_en[1]: the slv1 req to mst port0 enable,
//                                    rdarb_dc_req_en[2]: the slv2 req to mst port0 enable,
//                                    rdarb_dc_req_en[3]: the slv3 req to mst port0 enable,
//                                    rdarb_dc_req_en[4]: the slv4 req to mst port0 enable,
//                                    rdarb_dc_req_en[5]: the slv5 req to mst port0 enable,
//                                    rdarb_dc_req_en[6]: the slv0 req to mst port1 enable,
//                                    rdarb_dc_req_en[7]: the slv1 req to mst port1 enable,
//                                    rdarb_dc_req_en[8]: the slv2 req to mst port1 enable,
//                                    rdarb_dc_req_en[9]: the slv3 req to mst port1 enable,
//                                    rdarb_dc_req_en[10]: the slv4 req to mst port1 enable,
//                                    rdarb_dc_req_en[11]: the slv5 req to mst port1 enable,
#define DI_RDARB_WEIGH0_SLV_L1C1 ((0x2052 << 2) + 0xff900000)
// Bit   31:30,    reserved
// Bit   29:0,     rddc_weigh_sxn     unsigned  , default = 0
//                                    rddc_weigh_sxn[0*6+:6]: the slv0 req weigh number
//                                    rddc_weigh_sxn[1*6+:6]: the slv1 req weigh number
//                                    rddc_weigh_sxn[2*6+:6]: the slv2 req weigh number
//                                    rddc_weigh_sxn[3*6+:6]: the slv3 req weigh number
//                                    rddc_weigh_sxn[4*6+:6]: the slv4 req weigh number
#define DI_RDARB_WEIGH1_SLV_L1C1 ((0x2053 << 2) + 0xff900000)
// Bit   31:6,    reserved
// Bit   5:0,     rddc_weigh_sxn     unsigned  , default = 0
//                                    rddc_weigh_sxn[5*6+:6]: the slv5 req weigh number
#define DI_WRARB_MODE_L1C1 ((0x2054 << 2) + 0xff900000)
// Bit   31:22,    reserved
// Bit   21:16,    wrarb_sel           uns, default = 0 ,
//                                    wrarb_sel[0]==0 slave dc0 connect master port0
//                                    wrarb_sel[0]==1 slave dc0 connect master port1
//                                    wrarb_sel[1]==0 slave dc1 connect master port0
//                                    wrarb_sel[1]==1 slave dc1 connect master port1
//                                    wrarb_sel[2]==0 slave dc2 connect master port0
//                                    wrarb_sel[2]==1 slave dc2 connect master port1
//                                    wrarb_sel[3]==0 slave dc3 connect master port0
//                                    wrarb_sel[3]==1 slave dc3 connect master port1
//                                    wrarb_sel[4]==0 slave dc4 connect master port0
//                                    wrarb_sel[4]==1 slave dc4 connect master port1
//                                    wrarb_sel[5]==0 slave dc5 connect master port0
//                                    wrarb_sel[5]==1 slave dc5 connect master port1
// Bit   15:10,    reserved
// Bit   9:8,      wrarb_arb_mode      uns, default = 0 ,
//                                    wrarb_arb_mode[0] master port0 arb way,
//                                    wrarb_arb_mode[1] master port1 arb way,
// Bit   7:4,      reserved
// Bit   3:0,      wrarb_gate_clk_ctrl uns, default = 0 ,
//                                    wrarb_gate_clk_ctrl[1:0] master port0 clk gate control
//                                    wrarb_gate_clk_ctrl[3:2] master port1 clk gate control
#define DI_WRARB_REQEN_SLV_L1C1 ((0x2055 << 2) + 0xff900000)
// Bit   31:12,     reserved
// Bit   11:0,     wrarb_dc_req_en     unsigned  , default = 0
//                                    wrarb_dc_req_en[0]: the slv0 req to mst port0 enable,
//                                    wrarb_dc_req_en[1]: the slv1 req to mst port0 enable,
//                                    wrarb_dc_req_en[2]: the slv2 req to mst port0 enable,
//                                    wrarb_dc_req_en[3]: the slv3 req to mst port0 enable,
//                                    wrarb_dc_req_en[4]: the slv4 req to mst port0 enable,
//                                    wrarb_dc_req_en[5]: the slv5 req to mst port0 enable,
//                                    wrarb_dc_req_en[0]: the slv0 req to mst port1 enable,
//                                    wrarb_dc_req_en[1]: the slv1 req to mst port1 enable,
//                                    wrarb_dc_req_en[2]: the slv2 req to mst port1 enable,
//                                    wrarb_dc_req_en[3]: the slv3 req to mst port1 enable,
//                                    wrarb_dc_req_en[4]: the slv4 req to mst port1 enable,
//                                    wrarb_dc_req_en[5]: the slv5 req to mst port1 enable,
#define DI_WRARB_WEIGH0_SLV_L1C1 ((0x2056 << 2) + 0xff900000)
// Bit   31:30,    reserved
// Bit   29:0,     wrdc_weigh_sxn     unsigned  , default = 0
//                                    wrdc_weigh_sxn[0*6+:6]: the slv0 req weigh number
//                                    wrdc_weigh_sxn[1*6+:6]: the slv1 req weigh number
//                                    wrdc_weigh_sxn[2*6+:6]: the slv2 req weigh number
//                                    wrdc_weigh_sxn[3*6+:6]: the slv3 req weigh number
//                                    wrdc_weigh_sxn[4*6+:6]: the slv4 req weigh number
#define DI_WRARB_WEIGH1_SLV_L1C1 ((0x2057 << 2) + 0xff900000)
// Bit   31:6,    reserved
// Bit   5:0,     wrdc_weigh_sxn     unsigned  , default = 0
//                                    wrdc_weigh_sxn[5*6+:6]: the slv5 req weigh number
#define DI_RDWR_ARB_STATUS_L1C1 ((0x2058 << 2) + 0xff900000)
// Bit   31:4,    reserved
// Bit    3:2,    wrarb_arb_busy     unsigned  , default = 0
// Bit    1:0,    rdarb_arb_busy     unsigned  , default = 0
#define DI_ARB_DBG_CTRL_L1C1 ((0x2059 << 2) + 0xff900000)
#define DI_ARB_DBG_STAT_L1C1 ((0x205a << 2) + 0xff900000)
#define DI_RDARB_UGT_L1C1 ((0x205b << 2) + 0xff900000)
#define DI_RDARB_LIMT0_L1C1 ((0x205c << 2) + 0xff900000)
#define DI_WRARB_UGT_L1C1 ((0x205d << 2) + 0xff900000)
#define DI_ARB_AXIWR_PROT ((0x205e << 2) + 0xff900000)
#define DI_ARB_AXIRD0_PROT ((0x205f << 2) + 0xff900000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  di_arb_axi_regs.h
//
// di afbc_enc
// the segment is 8'h60-8'h8f
//
// Reading file:  di_afbc_enc0_regs.h
//
// synopsys translate_off
// synopsys translate_on
#define DI_AFBCE_ENABLE ((0x2060 << 2) + 0xff900000)
// Bit   31:20,    gclk_ctrl        unsigned  , default = 0,
// Bit   19:16,    di_afbce_sync_sel   unsigned  , default = 0,
// Bit   15:14,    reserved
// Bit   13,       enc_rst_mode     unsigned  , default = 0,
// Bit   12,       enc_en_mode      unsigned  , default = 0,
// Bit   11:9,     reserved
// Bit   8,        enc_enable       unsigned  , default = 0,
// Bit   7:1,      reserved
// Bit   0,        reserved         enc_frm_start pulse use this bit don't use
#define DI_AFBCE_MODE ((0x2061 << 2) + 0xff900000)
// Bit   31:29,    soft_rst         unsigned, default = 0 ,the use as go_field
// Bit   28,       reserved
// Bit   27:26,    rev_mode         unsigned, default = 0 , reverse mode
// Bit   25:24,    mif_urgent       unsigned, default = 3 , info mif and data mif urgent
// Bit   23,       reserved
// Bit   22:16,    hold_line_num    unsigned, default = 4, 0: burst1 1:burst2 2:burst4
// Bit   15:14,    burst_mode       unsigned, default = 1, 0: burst1 1:burst2 2:burst4
// Bit   13:1,     reserved
// Bit      0,     reg_fmt444_comb  unsigned, default = 0, 0: 444 8bit uncomb
#define DI_AFBCE_SIZE_IN ((0x2062 << 2) + 0xff900000)
// Bit   31:29,    reserved
// Bit   28:16     hsize_in         unsigned, default = 1920 , pic horz size in  unit: pixel
// Bit   15:13,    reserved
// Bit   12:0,     vsize_in         unsigned, default = 1080 , pic vert size in  unit: pixel
#define DI_AFBCE_BLK_SIZE_IN ((0x2063 << 2) + 0xff900000)
// Bit   31:29,    reserved
// Bit   28:16     hblk_size        unsigned, default = 60 , pic horz size in  unit: pixel
// Bit   15:13,    reserved
// Bit   12:0,     vblk_size        unsigned, default = 270, pic vert size in  unit: pixel
#define DI_AFBCE_HEAD_BADDR ((0x2064 << 2) + 0xff900000)
// Bit   31:0,     head_baddr         unsigned, default = 32'h00;
#define DI_AFBCE_MIF_SIZE ((0x2065 << 2) + 0xff900000)
// Bit   31:30,  reserved
// Bit   29:28,  ddr_blk_size       unsigned, default = 1;
// Bit   27,     reserved
// Bit   26:24,  cmd_blk_size       unsigned, default = 3;
// Bit   23:21,  reserved
// Bit   20:16,  uncmp_size         unsigned, default = 20;
// Bit   15:0,   mmu_page_size      unsigned, default = 4096;
#define DI_AFBCE_PIXEL_IN_HOR_SCOPE ((0x2066 << 2) + 0xff900000)
// Bit   31:29,   reserved
// Bit   28:16,   enc_win_end_h     unsigned, default = 1919 ; //
// Bit   15:13,   reserved
// Bit   12:0,    enc_win_bgn_h     unsigned, default = 0    ; //
#define DI_AFBCE_PIXEL_IN_VER_SCOPE ((0x2067 << 2) + 0xff900000)
// Bit   31:29,   reserved
// Bit   28:16,   enc_win_end_v     unsigned, default = 1079 ; //
// Bit   15:13,   reserved
// Bit   12:0,    enc_win_bgn_v     unsigned, default = 0    ; //
#define DI_AFBCE_CONV_CTRL ((0x2068 << 2) + 0xff900000)
// Bit   31:29,   reserved
// Bit   28:16,   fmt_ybuf_depth    unsigned, default = 2048
// Bit   15:12,   reserved
// Bit   11: 0,   lbuf_depth        unsigned, default = 256, unit=16 pixel need to set = 2^n
#define DI_AFBCE_MIF_HOR_SCOPE ((0x2069 << 2) + 0xff900000)
// Bit   31:26,   reserved
// Bit   25:16,   blk_end_h         unsigned, default = 0    ; //
// Bit   15:10,   reserved
// Bit   9:0,     blk_bgn_h         unsigned, default = 59    ; //
#define DI_AFBCE_MIF_VER_SCOPE ((0x206a << 2) + 0xff900000)
// Bit   31:28,   reserved
// Bit   27:16,   blk_end_v         unsigned, default = 0    ; //
// Bit   15:12,   reserved
// Bit   11:0,    blk_bgn_v         unsigned, default = 269    ; //
#define DI_AFBCE_STAT1 ((0x206b << 2) + 0xff900000)
// Bit   31,     ro_frm_end_pulse1   unsigned, RO,default = 0  ;frame end status
// Bit   30:0,   ro_dbg_top_info1    unsigned, RO,default = 0  ;
#define DI_AFBCE_STAT2 ((0x206c << 2) + 0xff900000)
// Bit   31,     reserved
// Bit   30:0,   ro_dbg_top_info2    unsigned, RO,default = 0  ;
#define DI_AFBCE_FORMAT ((0x206d << 2) + 0xff900000)
// Bit 31:12        reserved
// Bit 11:10        reserved
// Bit  9: 8        reg_format_mode           // unsigned ,    RW, default = 2  data format;0 :
// YUV444, 1:YUV422, 2:YUV420, 3:RGB Bit  7: 4        reg_compbits_c            // unsigned , RW,
// default = 10  chroma bitwidth Bit  3: 0        reg_compbits_y            // unsigned ,    RW,
// default = 10  luma bitwidth
#define DI_AFBCE_MODE_EN ((0x206e << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:26        reserved
// Bit 25           reg_adpt_interleave_ymode // unsigned ,    RW, default = 0  force 0 to disable
// it: no  HW implementation Bit 24           reg_adpt_interleave_cmode // unsigned ,    RW,
// default = 0  force 0 to disable it: not HW implementation Bit 23 reg_adpt_yinterleave_luma_ride
// // unsigned ,    RW, default = 1  vertical interleave piece luma reorder ride;   0: no reorder
// ride; 1: w/4 as ride Bit 22           reg_adpt_yinterleave_chrm_ride // unsigned ,    RW,
// default = 1  vertical interleave piece chroma reorder ride; 0: no reorder ride; 1: w/2 as ride
// Bit 21           reg_adpt_xinterleave_luma_ride // unsigned ,    RW, default = 1  vertical
// interleave piece luma reorder ride;   0: no reorder ride; 1: w/4 as ride Bit 20
// reg_adpt_xinterleave_chrm_ride // unsigned ,    RW, default = 1  vertical interleave piece
// chroma reorder ride; 0: no reorder ride; 1: w/2 as ride Bit 19            reserved Bit 18
// reg_disable_order_mode_i_6 // unsigned ,    RW, default = 0  disable order mode0~6: each mode
// with one  disable bit: 0: no disable, 1: disable Bit 17           reg_disable_order_mode_i_5 //
// unsigned ,    RW, default = 0  disable order mode0~6: each mode with one  disable bit: 0: no
// disable, 1: disable Bit 16           reg_disable_order_mode_i_4 // unsigned ,    RW, default =
// 0 disable order mode0~6: each mode with one  disable bit: 0: no disable, 1: disable Bit 15
// reg_disable_order_mode_i_3 // unsigned ,    RW, default = 0  disable order mode0~6: each mode
// with one  disable bit: 0: no disable, 1: disable Bit 14           reg_disable_order_mode_i_2 //
// unsigned ,    RW, default = 0  disable order mode0~6: each mode with one  disable bit: 0: no
// disable, 1: disable Bit 13           reg_disable_order_mode_i_1 // unsigned ,    RW, default =
// 0 disable order mode0~6: each mode with one  disable bit: 0: no disable, 1: disable Bit 12
// reg_disable_order_mode_i_0 // unsigned ,    RW, default = 0  disable order mode0~6: each mode
// with one  disable bit: 0: no disable, 1: disable Bit 11            reserved Bit 10
// reg_minval_yenc_en        // unsigned ,    RW, default = 0  force disable, final decision to
// remove this ws 1% performance loss Bit  9           reg_16x4block_enable      // unsigned , RW,
// default = 0  block as mission, but permit 16x4 block Bit  8           reg_uncompress_split_mode
// // unsigned ,    RW, default = 0  0: no split; 1: split Bit  7: 6        reserved Bit  5
// reg_input_padding_uv128   // unsigned ,    RW, default = 0  input picture 32x4 block gap mode:
// 0:  pad uv=0; 1: pad uv=128 Bit  4           reg_dwds_padding_uv128    // unsigned ,    RW,
// default = 0  downsampled image for double write 32x gap mode: 0:  pad uv=0; 1: pad uv=128 Bit
// 3: 1        reg_force_order_mode_value // unsigned ,    RW, default = 0  force order mode 0~7
// Bit 0           reg_force_order_mode_en   // unsigned ,    RW, default = 0  force order mode
// enable: 0: no force; 1: forced to force_value
#define DI_AFBCE_DWSCALAR ((0x206f << 2) + 0xff900000)
// Bit 31: 8        reserved
// Bit  7: 6        reg_dwscalar_w0           // unsigned ,    RW, default = 3  horizontal 1st
// step scalar mode: 0: 1:1 no scalar; 1: 2:1 data drop (0,2,4, 6) pixel kept; 2: 2:1 data drop
// (1, 3, 5,7..) pixels kept; 3: avg Bit  5: 4        reg_dwscalar_w1           // unsigned , RW,
// default = 0  horizontal 2nd step scalar mode: 0: 1:1 no scalar; 1: 2:1 data drop (0,2,4, 6)
// pixel kept; 2: 2:1 data drop (1, 3, 5,7..) pixels kept; 3: avg Bit  3: 2        reg_dwscalar_h0
// // unsigned ,    RW, default = 2  vertical 1st step scalar mode: 0: 1:1 no scalar; 1: 2:1 data
// drop (0,2,4, 6) pixel kept; 2: 2:1 data drop (1, 3, 5,7..) pixels kept; 3: avg Bit  1: 0
// reg_dwscalar_h1           // unsigned ,    RW, default = 3  vertical 2nd step scalar mode: 0:
// 1:1 no scalar; 1: 2:1 data drop (0,2,4, 6) pixel kept; 2: 2:1 data drop (1, 3, 5,7..) pixels
// kept; 3: avg
#define DI_AFBCE_DEFCOLOR_1 ((0x2070 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:12        reg_enc_defalutcolor_3    // unsigned ,    RW, default = 4095  Picture wise
// default color value in [Y Cb Cr] Bit 11: 0        reg_enc_defalutcolor_0    // unsigned , RW,
// default = 4095  Picture wise default color value in [Y Cb Cr]
#define DI_AFBCE_DEFCOLOR_2 ((0x2071 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:12        reg_enc_defalutcolor_2    // unsigned ,    RW, default = 2048  wise default
// color value in [Y Cb Cr] Bit 11: 0        reg_enc_defalutcolor_1    // unsigned ,    RW,
// default = 2048  wise default color value in [Y Cb Cr]
#define DI_AFBCE_QUANT_ENABLE ((0x2072 << 2) + 0xff900000)
// Bit 31:12        reserved
// Bit 11           reg_quant_expand_en_1     // unsigned ,    RW, default = 0  enable for
// quantization value expansion Bit 10           reg_quant_expand_en_0     // unsigned ,    RW,
// default = 0  enable for quantization value expansion Bit  9: 8        reg_bcleav_ofst // signed
// ,    RW, default = 0  bcleave ofset to get lower range, especially under lossy, for v1/v2, x=0
// is equivalent, default = -1; Bit  7: 5        reserved Bit  4           reg_quant_enable_1 //
// unsigned ,    RW, default = 0  enable for quant to get some lossy Bit  3: 1        reserved Bit
// 0           reg_quant_enable_0        // unsigned ,    RW, default = 0  enable for quant to get
// some lossy
#define DI_AFBCE_IQUANT_LUT_1 ((0x2073 << 2) + 0xff900000)
// Bit 31            reserved
// Bit 30:28        reg_iquant_yclut_0_11     // unsigned ,    RW, default = 0  quantization lut
// for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 27            reserved Bit 26:24
// reg_iquant_yclut_0_10     // unsigned ,    RW, default = 1  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit 23            reserved Bit 22:20        reg_iquant_yclut_0_9 //
// unsigned ,    RW, default = 2  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 19            reserved Bit 18:16        reg_iquant_yclut_0_8      // unsigned ,    RW,
// default = 3  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 15 reserved Bit
// 14:12        reg_iquant_yclut_0_7      // unsigned ,    RW, default = 4  quantization lut for
// mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 11            reserved Bit 10: 8
// reg_iquant_yclut_0_6      // unsigned ,    RW, default = 5  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit  7            reserved Bit  6: 4        reg_iquant_yclut_0_5 //
// unsigned ,    RW, default = 5  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 3            reserved Bit  2: 0        reg_iquant_yclut_0_4      // unsigned ,    RW,
// default = 4  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
#define DI_AFBCE_IQUANT_LUT_2 ((0x2074 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15            reserved
// Bit 14:12        reg_iquant_yclut_0_3      // unsigned ,    RW, default = 3  quantization lut
// for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 11            reserved Bit 10: 8
// reg_iquant_yclut_0_2      // unsigned ,    RW, default = 2  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit  7            reserved Bit  6: 4        reg_iquant_yclut_0_1 //
// unsigned ,    RW, default = 1  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 3            reserved Bit  2: 0        reg_iquant_yclut_0_0      // unsigned ,    RW,
// default = 0  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
#define DI_AFBCE_IQUANT_LUT_3 ((0x2075 << 2) + 0xff900000)
// Bit 31            reserved
// Bit 30:28        reg_iquant_yclut_1_11     // unsigned ,    RW, default = 0  quantization lut
// for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 27            reserved Bit 26:24
// reg_iquant_yclut_1_10     // unsigned ,    RW, default = 1  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit 23            reserved Bit 22:20        reg_iquant_yclut_1_9 //
// unsigned ,    RW, default = 2  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 19            reserved Bit 18:16        reg_iquant_yclut_1_8      // unsigned ,    RW,
// default = 3  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 15 reserved Bit
// 14:12        reg_iquant_yclut_1_7      // unsigned ,    RW, default = 4  quantization lut for
// mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 11            reserved Bit 10: 8
// reg_iquant_yclut_1_6      // unsigned ,    RW, default = 5  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit  7            reserved Bit  6: 4        reg_iquant_yclut_1_5 //
// unsigned ,    RW, default = 5  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 3            reserved Bit  2: 0        reg_iquant_yclut_1_4      // unsigned ,    RW,
// default = 4  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
#define DI_AFBCE_IQUANT_LUT_4 ((0x2076 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15            reserved
// Bit 14:12        reg_iquant_yclut_1_3      // unsigned ,    RW, default = 3  quantization lut
// for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 11            reserved Bit 10: 8
// reg_iquant_yclut_1_2      // unsigned ,    RW, default = 2  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit  7            reserved Bit  6: 4        reg_iquant_yclut_1_1 //
// unsigned ,    RW, default = 1  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 3            reserved Bit  2: 0        reg_iquant_yclut_1_0      // unsigned ,    RW,
// default = 0  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
#define DI_AFBCE_RQUANT_LUT_1 ((0x2077 << 2) + 0xff900000)
// Bit 31            reserved
// Bit 30:28        reg_rquant_yclut_0_11     // unsigned ,    RW, default = 5  quantization lut
// for bctree leavs, quant=2^lut(bc_leav_r+1), can be calculated from iquant_yclut(fw_setting) Bit
// 27            reserved Bit 26:24        reg_rquant_yclut_0_10     // unsigned ,    RW, default
// = 5 Bit 23            reserved Bit 22:20        reg_rquant_yclut_0_9      // unsigned ,    RW,
// default = 4 Bit 19            reserved Bit 18:16        reg_rquant_yclut_0_8      // unsigned ,
// RW, default = 4 Bit 15            reserved Bit 14:12        reg_rquant_yclut_0_7      //
// unsigned ,    RW, default = 3 Bit 11            reserved Bit 10: 8        reg_rquant_yclut_0_6
// // unsigned ,    RW, default = 3 Bit  7            reserved Bit  6: 4 reg_rquant_yclut_0_5 //
// unsigned ,    RW, default = 2 Bit  3            reserved Bit  2: 0        reg_rquant_yclut_0_4
// // unsigned ,    RW, default = 2
#define DI_AFBCE_RQUANT_LUT_2 ((0x2078 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15            reserved
// Bit 14:12        reg_rquant_yclut_0_3      // unsigned ,    RW, default = 1
// Bit 11            reserved
// Bit 10: 8        reg_rquant_yclut_0_2      // unsigned ,    RW, default = 1
// Bit  7            reserved
// Bit  6: 4        reg_rquant_yclut_0_1      // unsigned ,    RW, default = 0
// Bit  3            reserved
// Bit  2: 0        reg_rquant_yclut_0_0      // unsigned ,    RW, default = 0
#define DI_AFBCE_RQUANT_LUT_3 ((0x2079 << 2) + 0xff900000)
// Bit 31            reserved
// Bit 30:28        reg_rquant_yclut_1_11     // unsigned ,    RW, default = 5  quantization lut
// for bctree leavs, quant=2^lut(bc_leav_r+1), can be calculated from iquant_yclut(fw_setting) Bit
// 27            reserved Bit 26:24        reg_rquant_yclut_1_10     // unsigned ,    RW, default
// = 5 Bit 23            reserved Bit 22:20        reg_rquant_yclut_1_9      // unsigned ,    RW,
// default = 4 Bit 19            reserved Bit 18:16        reg_rquant_yclut_1_8      // unsigned ,
// RW, default = 4 Bit 15            reserved Bit 14:12        reg_rquant_yclut_1_7      //
// unsigned ,    RW, default = 3 Bit 11            reserved Bit 10: 8        reg_rquant_yclut_1_6
// // unsigned ,    RW, default = 3 Bit  7            reserved Bit  6: 4 reg_rquant_yclut_1_5 //
// unsigned ,    RW, default = 2 Bit  3            reserved Bit  2: 0        reg_rquant_yclut_1_4
// // unsigned ,    RW, default = 2
#define DI_AFBCE_RQUANT_LUT_4 ((0x207a << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15            reserved
// Bit 14:12        reg_rquant_yclut_1_3      // unsigned ,    RW, default = 1
// Bit 11            reserved
// Bit 10: 8        reg_rquant_yclut_1_2      // unsigned ,    RW, default = 1
// Bit  7            reserved
// Bit  6: 4        reg_rquant_yclut_1_1      // unsigned ,    RW, default = 0
// Bit  3            reserved
// Bit  2: 0        reg_rquant_yclut_1_0      // unsigned ,    RW, default = 0
#define DI_AFBCE_YUV_FORMAT_CONV_MODE ((0x207b << 2) + 0xff900000)
// Bit 31: 8        reserved
// Bit  7           reserved
// Bit  6: 4        reg_444to422_mode         // unsigned ,    RW, default = 0
// Bit  3           reserved
// Bit  2: 0        reg_422to420_mode         // unsigned ,    RW, default = 0
#define DI_AFBCE_DUMMY_DATA ((0x207c << 2) + 0xff900000)
// Bit 31:30        reserved
// Bit 29: 0        reg_dummy_data           // unsigned ,  default = 0  ;
#define DI_AFBCE_CLR_FLAG ((0x207d << 2) + 0xff900000)
// Bit 31:0         reg_di_afbce_clr_flag           // unsigned, default = 0  ;
#define DI_AFBCE_STA_FLAGT ((0x207e << 2) + 0xff900000)
// Bit 31:0         ro_di_afbce__sta_flag        // unsigned, RO,default = 0  ;
#define DI_AFBCE_MMU_NUM ((0x207f << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15: 0        ro_frm_mmu_num           // unsigned, RO,default = 0  ;
#define DI_AFBCE_MMU_RMIF_CTRL1 ((0x2080 << 2) + 0xff900000)
// Bit 31:26 reserved
// Bit 25:24 reg_sync_sel      // unsigned , default = 0, axi canvas id sync with frm rst
// Bit 23:16 reg_canvas_id     // unsigned , default = 0, axi canvas id num
// Bit 15    reserved
// Bit 14:12 reg_cmd_intr_len  // unsigned , default = 1, interrupt send cmd when how many series
// axi cmd, Bit 11:10 reg_cmd_req_size  // unsigned , default = 1, how many room fifo have, then
// axi send series req, 0=16 1=32 2=24 3=64 Bit 9:8   reg_burst_len     // unsigned , default = 2,
// burst type: 0-single 1-bst2 2-bst4 Bit 7     reg_swap_64bit    // unsigned , default = 0,
// 64bits of 128bit swap enable Bit 6     reg_little_endian // unsigned , default = 0, big endian
// enable Bit 5     reg_y_rev         // unsigned , default = 0, vertical reverse enable Bit 4
// reg_x_rev         // unsigned , default = 0, horizontal reverse enable Bit 3     reserved Bit
// 2:0   reg_pack_mode     // unsigned , default = 3, 0:4bit 1:8bit 2:16bit 3:32bit 4:64bit
// 5:128bit
#define DI_AFBCE_MMU_RMIF_CTRL2 ((0x2081 << 2) + 0xff900000)
// Bit 31:30 reg_sw_rst        // unsigned , default = 0,
// Bit 29:24 reserved
// Bit 23:18 reg_gclk_ctrl
// Bit 17    reserved
// Bit 16:0  reg_urgent_ctrl   // unsigned , default = 0, urgent control reg :
#define DI_AFBCE_MMU_RMIF_CTRL3 ((0x2082 << 2) + 0xff900000)
// Bit 31:17 reserved
// Bit 16    reg_acc_mode      // unsigned , default = 1,
// Bit 15:13 reserved
// Bit 12:0  reg_stride        // unsigned , default = 4096,
#define DI_AFBCE_MMU_RMIF_CTRL4 ((0x2083 << 2) + 0xff900000)
// Bit 31:0  reg_baddr        // unsigned , default = 0,
#define DI_AFBCE_MMU_RMIF_SCOPE_X ((0x2084 << 2) + 0xff900000)
// Bit 31:29 reserved
// Bit 28:16 reg_x_end         // unsigned , default = 4095, the canvas hor end pixel position
// Bit 15:13 reserved
// Bit 12: 0 reg_x_start       // unsigned , default = 0, the canvas hor start pixel position
#define DI_AFBCE_MMU_RMIF_SCOPE_Y ((0x2085 << 2) + 0xff900000)
// Bit 31:29 reserved
// Bit 28:16 reg_y_end         // unsigned , default = 0, the canvas ver end pixel position
// Bit 15:13 reserved
// Bit 12: 0 reg_y_start       // unsigned , default = 0, the canvas ver start pixel positio
#define DI_AFBCE_MMU_RMIF_RO_STAT ((0x2086 << 2) + 0xff900000)
// Bit 15:0  reg_status        // unsigned ,
#define DI_AFBCE_PIP_CTRL ((0x208a << 2) + 0xff900000)
// Bit   31:3      reserved
// Bit   2         reg_enc_align_en     //unsigned  , RW,default = 1,
// Bit   1         reg_pip_ini_ctrl     //unsigned  , RW,default = 0,
// Bit   0         reg_pip_mode         //unsigned  , RW,default = 0,
#define DI_AFBCE_ROT_CTRL ((0x208b << 2) + 0xff900000)
// Bit   31:5      reserved
// Bit   4         reg_rot_en           //unsigned  , RW,default = 0, rotation enable
// Bit   3:0       reg_vstep            //unsigned  , RW,default = 8, rotation vstep ,setting
// acorrding rotation shrink mode
#define DI_AFBCE_DIMM_CTRL ((0x208c << 2) + 0xff900000)
// Bit   31        reg_dimm_layer_en   //unsigned  , RW,default = 0,dimm_layer enable signal
// Bit   30        reserved
// Bit   29:0      reg_dimm_data       //unsigned  , RW,default = 29'h00080200,dimm_layer data
#define DI_AFBCE_BND_DEC_MISC ((0x208d << 2) + 0xff900000)
// Bit 31:28  reserved
// Bit 27:26  bnd_dec_rev_mode         //unsigned , RW,default = 0    only pip mode use those
// bits,ususaly don't need configure Bit 25:24  bnd_dec_mif_urgent       //unsigned , RW,default =
// 3    only pip mode use those bits,ususaly don't need configure Bit 23:22  bnd_dec_burst_len
// //unsigned , RW,default = 2    only pip mode use those bits,ususaly don't need configure Bit
// 21:20  bnd_dec_ddr_blk_size     //unsigned , RW,default = 1    only pip mode use those
// bits,ususaly don't need configure Bit 19     reserved Bit 18:16  bnd_dec_cmd_blk_size
// //unsigned , RW,default = 3    only pip mode use those bits,ususaly don't need configure Bit 15
// reserved Bit 14     bnd_dec_blk_mem_mode     //unsigned , RW,default = 0    only pip mode use
// those bits,ususaly don't need configure Bit 13     bnd_dec_addr_link_en     //unsigned ,
// RW,default = 1    only pip mode use those bits,ususaly don't need configure Bit 12
// bnd_dec_always_body_rden
// //unsigned , RW,default = 0    only pip mode use those bits,ususaly don't need configure Bit
// 11:0   bnd_dec_mif_lbuf_depth   //unsigned , RW,default = 128  only pip mode use those
// bits,ususaly don't need configure
#define DI_AFBCE_RD_ARB_MISC ((0x208e << 2) + 0xff900000)
// Bit 31:13  reserved
// Bit 12     reg_arb_sw_rst          //unsigned , RW,default = 0    only pip mode use those
// bits,ususaly don't need configure Bit 11:10  reserved Bit 9      reg_arb_arblk_last1 //unsigned
// , RW,default = 0    only pip mode use those bits,ususaly don't need configure Bit 8
// reg_arb_arblk_last0     //unsigned , RW,default = 0    only pip mode use those bits,ususaly
// don't need configure Bit 7:4    reg_arb_weight_ch1      //unsigned , RW,default = 4    only pip
// mode use those bits,ususaly don't need configure Bit 3:0    reg_arb_weight_ch0      //unsigned
// , RW,default = 10   only pip mode use those bits,ususaly don't need configure synopsys
// translate_off synopsys translate_on
//
// Closing file:  di_afbc_enc0_regs.h
//
// the segment is 8'h90-8'ha3
//
// Reading file:  di_wrmif0_regs.h
//
#define NRWR_DBG_AXI_CMD_CNT ((0x2090 << 2) + 0xff900000)
#define NRWR_DBG_AXI_DAT_CNT ((0x2091 << 2) + 0xff900000)
#define DI_NRWR_CANVAS ((0x2092 << 2) + 0xff900000)
#define DI_NRWR_URGENT ((0x2093 << 2) + 0xff900000)
#define DI_NRWR_X ((0x2094 << 2) + 0xff900000)
#define DI_NRWR_Y ((0x2095 << 2) + 0xff900000)
// bit 31:30		  NRWR_words_lim
// bit 29		  NRWR_rev_y
// bit 28:16		  NRWR_start_y
// bit 15		  NRWR_ext_en
// bit 12:0		  NRWR_end_y
#define DI_NRWR_CTRL ((0x2096 << 2) + 0xff900000)
// bit 31		  pending_ddr_wrrsp_NRWR
// bit 30		  NRWR_reg_swap
// bit 29:26		  NRWR_burst_lim
// bit 25		  NRWR_canvas_syncen
// bit 24		  NRWR_no_clk_gate
// bit 23:22		  NRWR_rgb_mode  0:422 to one canvas;1:4:4:4 to one canvas 2:Y to luma ,
// CBCR to chroma canvas ,for nv12/21; 3 : reserved bit 21:20		  NRWR_hconv_mode bit
// 19:18		  NRWR_vconv_mode bit 17		  NRWR_swap_cbcr bit 16 NRWR_urgent
// bit 15:8		  NRWR_canvas_index_chroma bit 7:0		  NRWR_canvas_index_luma
#define DI_NRWR_SHRK_CTRL ((0x2097 << 2) + 0xff900000)
// bit   31:10     reserved
// bit   9:8       reg_vshrk_mode        unsigned, default = 0, 0:1/2 horizonal shrink 1:1/4
// horizonal shrink 2:1/8 horizonal shrink bit   7:6       reg_hshrk_mode        unsigned, default
// = 0, 0:1/2 vertical shrink 1:1/4 vertical shrink 2:1/8 vertical shrink bit   5:2 reg_gclk_ctrl
// unsigned, default = 0 bit   1         reg_frm_rst           unsigned, default = 0 bit   0
// reg_shrk_en           unsigned, default = 0
#define DI_NRWR_SHRK_SIZE ((0x2098 << 2) + 0xff900000)
// bit   31:26     reserved
// bit   25:13     reg_frm_hsize         unsigned, default = 1920, hsize in
// bit   12:0      reg_frm_vsize         unsigned, default = 1080, vsize in
#define DI_NRWR_CROP_CTRL ((0x209a << 2) + 0xff900000)
// Bit   31        reg_crop_en           unsigned  , RW,default = 0,dimm_layer enable signal
// Bit   30:4      reserved
// Bit   3:0       reg_hold_line         unsigned  , RW,default = 4,dimm_layer data
#define DI_NRWR_CROP_DIMM_CTRL ((0x209b << 2) + 0xff900000)
// Bit   31        reg_dimm_layer_en     unsigned  , RW,default = 0,dimm_layer enable signal
// Bit   30        reserved
// Bit   29:0      reg_dimm_data         unsigned  , RW,default = 29'h00080200,dimm_layer data
#define DI_NRWR_CROP_SIZE_IN ((0x209c << 2) + 0xff900000)
// Bit   31:29,    reserved
// Bit   28:16     reg_crop_hsize         unsigned, default = 1920 , pic horz size in  unit: pixel
// Bit   15:13,    reserved
// Bit   12:0,     reg_crop_vsize         unsigned, default = 1080 , pic vert size in  unit: pixel
#define DI_NRWR_CROP_HSCOPE ((0x209d << 2) + 0xff900000)
// Bit   31:29,    reserved
// Bit   28:16,    reg_cropwin_end_h      unsigned, default = 1919 ;
// Bit   15:13,    reserved
// Bit   12:0,     reg_cropwin_bgn_h      unsigned, default = 0    ;
#define DI_NRWR_CROP_VSCOPE ((0x209e << 2) + 0xff900000)
// Bit   31:29,    reserved
// Bit   28:16,    reg_cropwin_end_v      unsigned, default = 1079 ;
// Bit   15:13,    reserved
// Bit   12:0,     reg_cropwin_bgn_v      unsigned, default = 0    ;
#define DI_NRWR_BADDR0 ((0x20a0 << 2) + 0xff900000)
// Bit   31:0      wmif_baddr_luma        unsigned, default = 0x20000
#define DI_NRWR_STRIDE0 ((0x20a1 << 2) + 0xff900000)
// Bit   31        canvas_mode_en         unsigned, default = 0    ;
// Bit   30:14     reserved
// Bit   13:0      wmif_stride_luma       unsigned, default = 0x1000;
#define DI_NRWR_BADDR1 ((0x20a2 << 2) + 0xff900000)
// Bit   31:0      wmif_baddr_chroma      unsigned, default = 0x20000
#define DI_NRWR_STRIDE1 ((0x20a3 << 2) + 0xff900000)
// Bit   31        canvas_mode_en         unsigned, default = 0    ;
// Bit   30:14     reserved
// Bit   13:0      wmif_stride_chroma     unsigned, default = 0x1000;
//
// Closing file:  di_wrmif0_regs.h
//
// di afbc_enc
// the segment is 8'hc0-8'hef
//
// Reading file:  di_afbc_enc1_regs.h
//
// synopsys translate_off
// synopsys translate_on
#define DI_AFBCE1_ENABLE ((0x20c0 << 2) + 0xff900000)
// Bit   31:20,    gclk_ctrl        unsigned  , default = 0,
// Bit   19:16,    di_AFBCE1_sync_sel   unsigned  , default = 0,
// Bit   15:14,    reserved
// Bit   13,       enc_rst_mode     unsigned  , default = 0,
// Bit   12,       enc_en_mode      unsigned  , default = 0,
// Bit   11:9,     reserved
// Bit   8,        enc_enable       unsigned  , default = 0,
// Bit   7:1,      reserved
// Bit   0,        reserved         enc_frm_start pulse use this bit don't use
#define DI_AFBCE1_MODE ((0x20c1 << 2) + 0xff900000)
// Bit   31:29,    soft_rst         unsigned, default = 0 ,the use as go_field
// Bit   28,       reserved         unsigned, default = 0 , enable signal of crop
// Bit   27:26,    rev_mode         unsigned, default = 0 , reverse mode
// Bit   25:24,    mif_urgent       unsigned, default = 3 , info mif and data mif urgent
// Bit   23,       reserved
// Bit   22:16,    hold_line_num    unsigned, default = 4, 0: burst1 1:burst2 2:burst4
// Bit   15:14,    burst_mode       unsigned, default = 1, 0: burst1 1:burst2 2:burst4
// Bit   13:1,     reserved
// Bit      0,     reg_fmt444_comb  unsigned, default = 0, 0: 444 8bit uncomb
#define DI_AFBCE1_SIZE_IN ((0x20c2 << 2) + 0xff900000)
// Bit   31:29,    reserved
// Bit   28:16     hsize_in         unsigned, default = 1920 , pic horz size in  unit: pixel
// Bit   15:13,    reserved
// Bit   12:0,     vsize_in         unsigned, default = 1080 , pic vert size in  unit: pixel
#define DI_AFBCE1_BLK_SIZE_IN ((0x20c3 << 2) + 0xff900000)
// Bit   31:29,    reserved
// Bit   28:16     hblk_size        unsigned, default = 60 , pic horz size in  unit: pixel
// Bit   15:13,    reserved
// Bit   12:0,     vblk_size        unsigned, default = 270, pic vert size in  unit: pixel
#define DI_AFBCE1_HEAD_BADDR ((0x20c4 << 2) + 0xff900000)
// Bit   31:0,     head_baddr         unsigned, default = 32'h00;
#define DI_AFBCE1_MIF_SIZE ((0x20c5 << 2) + 0xff900000)
// Bit   31:30,  reserved
// Bit   29:28,  ddr_blk_size       unsigned, default = 1;
// Bit   27,     reserved
// Bit   26:24,  cmd_blk_size       unsigned, default = 3;
// Bit   23:21,  reserved
// Bit   20:16,  uncmp_size         unsigned, default = 20;
// Bit   15:0,   mmu_page_size      unsigned, default = 4096;
#define DI_AFBCE1_PIXEL_IN_HOR_SCOPE ((0x20c6 << 2) + 0xff900000)
// Bit   31:29,   reserved
// Bit   28:16,   enc_win_end_h     unsigned, default = 1919 ; //
// Bit   15:13,   reserved
// Bit   12:0,    enc_win_bgn_h     unsigned, default = 0    ; //
#define DI_AFBCE1_PIXEL_IN_VER_SCOPE ((0x20c7 << 2) + 0xff900000)
// Bit   31:29,   reserved
// Bit   28:16,   enc_win_end_v     unsigned, default = 1079 ; //
// Bit   15:13,   reserved
// Bit   12:0,    enc_win_bgn_v     unsigned, default = 0    ; //
#define DI_AFBCE1_CONV_CTRL ((0x20c8 << 2) + 0xff900000)
// Bit   31:29,   reserved
// Bit   28:16,   fmt_ybuf_depth    unsigned, default = 2048
// Bit   15:12,   reserved
// Bit   11: 0,   lbuf_depth        unsigned, default = 256, unit=16 pixel need to set = 2^n
#define DI_AFBCE1_MIF_HOR_SCOPE ((0x20c9 << 2) + 0xff900000)
// Bit   31:26,   reserved
// Bit   25:16,   blk_end_h         unsigned, default = 0    ; //
// Bit   15:10,   reserved
// Bit   9:0,     blk_bgn_h         unsigned, default = 59    ; //
#define DI_AFBCE1_MIF_VER_SCOPE ((0x20ca << 2) + 0xff900000)
// Bit   31:28,   reserved
// Bit   27:16,   blk_end_v         unsigned, default = 0    ; //
// Bit   15:12,   reserved
// Bit   11:0,    blk_bgn_v         unsigned, default = 269    ; //
#define DI_AFBCE1_STAT1 ((0x20cb << 2) + 0xff900000)
// Bit   31,     ro_frm_end_pulse1   unsigned, RO,default = 0  ;frame end status
// Bit   30:0,   ro_dbg_top_info1    unsigned, RO,default = 0  ;
#define DI_AFBCE1_STAT2 ((0x20cc << 2) + 0xff900000)
// Bit   31,     reserved
// Bit   30:0,   ro_dbg_top_info2    unsigned, RO,default = 0  ;
#define DI_AFBCE1_FORMAT ((0x20cd << 2) + 0xff900000)
// Bit 31:12        reserved
// Bit 11:10        reserved
// Bit  9: 8        reg_format_mode           // unsigned ,    RW, default = 2  data format;0 :
// YUV444, 1:YUV422, 2:YUV420, 3:RGB Bit  7: 4        reg_compbits_c            // unsigned , RW,
// default = 10  chroma bitwidth Bit  3: 0        reg_compbits_y            // unsigned ,    RW,
// default = 10  luma bitwidth
#define DI_AFBCE1_MODE_EN ((0x20ce << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:26        reserved
// Bit 25           reg_adpt_interleave_ymode // unsigned ,    RW, default = 0  force 0 to disable
// it: no  HW implementation Bit 24           reg_adpt_interleave_cmode // unsigned ,    RW,
// default = 0  force 0 to disable it: not HW implementation Bit 23 reg_adpt_yinterleave_luma_ride
// // unsigned ,    RW, default = 1  vertical interleave piece luma reorder ride;   0: no reorder
// ride; 1: w/4 as ride Bit 22           reg_adpt_yinterleave_chrm_ride // unsigned ,    RW,
// default = 1  vertical interleave piece chroma reorder ride; 0: no reorder ride; 1: w/2 as ride
// Bit 21           reg_adpt_xinterleave_luma_ride // unsigned ,    RW, default = 1  vertical
// interleave piece luma reorder ride;   0: no reorder ride; 1: w/4 as ride Bit 20
// reg_adpt_xinterleave_chrm_ride // unsigned ,    RW, default = 1  vertical interleave piece
// chroma reorder ride; 0: no reorder ride; 1: w/2 as ride Bit 19            reserved Bit 18
// reg_disable_order_mode_i_6 // unsigned ,    RW, default = 0  disable order mode0~6: each mode
// with one  disable bit: 0: no disable, 1: disable Bit 17           reg_disable_order_mode_i_5 //
// unsigned ,    RW, default = 0  disable order mode0~6: each mode with one  disable bit: 0: no
// disable, 1: disable Bit 16           reg_disable_order_mode_i_4 // unsigned ,    RW, default =
// 0 disable order mode0~6: each mode with one  disable bit: 0: no disable, 1: disable Bit 15
// reg_disable_order_mode_i_3 // unsigned ,    RW, default = 0  disable order mode0~6: each mode
// with one  disable bit: 0: no disable, 1: disable Bit 14           reg_disable_order_mode_i_2 //
// unsigned ,    RW, default = 0  disable order mode0~6: each mode with one  disable bit: 0: no
// disable, 1: disable Bit 13           reg_disable_order_mode_i_1 // unsigned ,    RW, default =
// 0 disable order mode0~6: each mode with one  disable bit: 0: no disable, 1: disable Bit 12
// reg_disable_order_mode_i_0 // unsigned ,    RW, default = 0  disable order mode0~6: each mode
// with one  disable bit: 0: no disable, 1: disable Bit 11            reserved Bit 10
// reg_minval_yenc_en        // unsigned ,    RW, default = 0  force disable, final decision to
// remove this ws 1% performance loss Bit  9           reg_16x4block_enable      // unsigned , RW,
// default = 0  block as mission, but permit 16x4 block Bit  8           reg_uncompress_split_mode
// // unsigned ,    RW, default = 0  0: no split; 1: split Bit  7: 6        reserved Bit  5
// reg_input_padding_uv128   // unsigned ,    RW, default = 0  input picture 32x4 block gap mode:
// 0:  pad uv=0; 1: pad uv=128 Bit  4           reg_dwds_padding_uv128    // unsigned ,    RW,
// default = 0  downsampled image for double write 32x gap mode: 0:  pad uv=0; 1: pad uv=128 Bit
// 3: 1        reg_force_order_mode_value // unsigned ,    RW, default = 0  force order mode 0~7
// Bit 0           reg_force_order_mode_en   // unsigned ,    RW, default = 0  force order mode
// enable: 0: no force; 1: forced to force_value
#define DI_AFBCE1_DWSCALAR ((0x20cf << 2) + 0xff900000)
// Bit 31: 8        reserved
// Bit  7: 6        reg_dwscalar_w0           // unsigned ,    RW, default = 3  horizontal 1st
// step scalar mode: 0: 1:1 no scalar; 1: 2:1 data drop (0,2,4, 6) pixel kept; 2: 2:1 data drop
// (1, 3, 5,7..) pixels kept; 3: avg Bit  5: 4        reg_dwscalar_w1           // unsigned , RW,
// default = 0  horizontal 2nd step scalar mode: 0: 1:1 no scalar; 1: 2:1 data drop (0,2,4, 6)
// pixel kept; 2: 2:1 data drop (1, 3, 5,7..) pixels kept; 3: avg Bit  3: 2        reg_dwscalar_h0
// // unsigned ,    RW, default = 2  vertical 1st step scalar mode: 0: 1:1 no scalar; 1: 2:1 data
// drop (0,2,4, 6) pixel kept; 2: 2:1 data drop (1, 3, 5,7..) pixels kept; 3: avg Bit  1: 0
// reg_dwscalar_h1           // unsigned ,    RW, default = 3  vertical 2nd step scalar mode: 0:
// 1:1 no scalar; 1: 2:1 data drop (0,2,4, 6) pixel kept; 2: 2:1 data drop (1, 3, 5,7..) pixels
// kept; 3: avg
#define DI_AFBCE1_DEFCOLOR_1 ((0x20d0 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:12        reg_enc_defalutcolor_3    // unsigned ,    RW, default = 4095  Picture wise
// default color value in [Y Cb Cr] Bit 11: 0        reg_enc_defalutcolor_0    // unsigned , RW,
// default = 4095  Picture wise default color value in [Y Cb Cr]
#define DI_AFBCE1_DEFCOLOR_2 ((0x20d1 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:12        reg_enc_defalutcolor_2    // unsigned ,    RW, default = 2048  wise default
// color value in [Y Cb Cr] Bit 11: 0        reg_enc_defalutcolor_1    // unsigned ,    RW,
// default = 2048  wise default color value in [Y Cb Cr]
#define DI_AFBCE1_QUANT_ENABLE ((0x20d2 << 2) + 0xff900000)
// Bit 31:12        reserved
// Bit 11           reg_quant_expand_en_1     // unsigned ,    RW, default = 0  enable for
// quantization value expansion Bit 10           reg_quant_expand_en_0     // unsigned ,    RW,
// default = 0  enable for quantization value expansion Bit  9: 8        reg_bcleav_ofst // signed
// ,    RW, default = 0  bcleave ofset to get lower range, especially under lossy, for v1/v2, x=0
// is equivalent, default = -1; Bit  7: 5        reserved Bit  4           reg_quant_enable_1 //
// unsigned ,    RW, default = 0  enable for quant to get some lossy Bit  3: 1        reserved Bit
// 0           reg_quant_enable_0        // unsigned ,    RW, default = 0  enable for quant to get
// some lossy
#define DI_AFBCE1_IQUANT_LUT_1 ((0x20d3 << 2) + 0xff900000)
// Bit 31            reserved
// Bit 30:28        reg_iquant_yclut_0_11     // unsigned ,    RW, default = 0  quantization lut
// for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 27            reserved Bit 26:24
// reg_iquant_yclut_0_10     // unsigned ,    RW, default = 1  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit 23            reserved Bit 22:20        reg_iquant_yclut_0_9 //
// unsigned ,    RW, default = 2  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 19            reserved Bit 18:16        reg_iquant_yclut_0_8      // unsigned ,    RW,
// default = 3  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 15 reserved Bit
// 14:12        reg_iquant_yclut_0_7      // unsigned ,    RW, default = 4  quantization lut for
// mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 11            reserved Bit 10: 8
// reg_iquant_yclut_0_6      // unsigned ,    RW, default = 5  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit  7            reserved Bit  6: 4        reg_iquant_yclut_0_5 //
// unsigned ,    RW, default = 5  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 3            reserved Bit  2: 0        reg_iquant_yclut_0_4      // unsigned ,    RW,
// default = 4  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
#define DI_AFBCE1_IQUANT_LUT_2 ((0x20d4 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15            reserved
// Bit 14:12        reg_iquant_yclut_0_3      // unsigned ,    RW, default = 3  quantization lut
// for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 11            reserved Bit 10: 8
// reg_iquant_yclut_0_2      // unsigned ,    RW, default = 2  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit  7            reserved Bit  6: 4        reg_iquant_yclut_0_1 //
// unsigned ,    RW, default = 1  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 3            reserved Bit  2: 0        reg_iquant_yclut_0_0      // unsigned ,    RW,
// default = 0  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
#define DI_AFBCE1_IQUANT_LUT_3 ((0x20d5 << 2) + 0xff900000)
// Bit 31            reserved
// Bit 30:28        reg_iquant_yclut_1_11     // unsigned ,    RW, default = 0  quantization lut
// for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 27            reserved Bit 26:24
// reg_iquant_yclut_1_10     // unsigned ,    RW, default = 1  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit 23            reserved Bit 22:20        reg_iquant_yclut_1_9 //
// unsigned ,    RW, default = 2  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 19            reserved Bit 18:16        reg_iquant_yclut_1_8      // unsigned ,    RW,
// default = 3  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 15 reserved Bit
// 14:12        reg_iquant_yclut_1_7      // unsigned ,    RW, default = 4  quantization lut for
// mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 11            reserved Bit 10: 8
// reg_iquant_yclut_1_6      // unsigned ,    RW, default = 5  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit  7            reserved Bit  6: 4        reg_iquant_yclut_1_5 //
// unsigned ,    RW, default = 5  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 3            reserved Bit  2: 0        reg_iquant_yclut_1_4      // unsigned ,    RW,
// default = 4  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
#define DI_AFBCE1_IQUANT_LUT_4 ((0x20d6 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15            reserved
// Bit 14:12        reg_iquant_yclut_1_3      // unsigned ,    RW, default = 3  quantization lut
// for mintree leavs, iquant=2^lut(bc_leav_q+1) Bit 11            reserved Bit 10: 8
// reg_iquant_yclut_1_2      // unsigned ,    RW, default = 2  quantization lut for mintree leavs,
// iquant=2^lut(bc_leav_q+1) Bit  7            reserved Bit  6: 4        reg_iquant_yclut_1_1 //
// unsigned ,    RW, default = 1  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// Bit 3            reserved Bit  2: 0        reg_iquant_yclut_1_0      // unsigned ,    RW,
// default = 0  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
#define DI_AFBCE1_RQUANT_LUT_1 ((0x20d7 << 2) + 0xff900000)
// Bit 31            reserved
// Bit 30:28        reg_rquant_yclut_0_11     // unsigned ,    RW, default = 5  quantization lut
// for bctree leavs, quant=2^lut(bc_leav_r+1), can be calculated from iquant_yclut(fw_setting) Bit
// 27            reserved Bit 26:24        reg_rquant_yclut_0_10     // unsigned ,    RW, default
// = 5 Bit 23            reserved Bit 22:20        reg_rquant_yclut_0_9      // unsigned ,    RW,
// default = 4 Bit 19            reserved Bit 18:16        reg_rquant_yclut_0_8      // unsigned ,
// RW, default = 4 Bit 15            reserved Bit 14:12        reg_rquant_yclut_0_7      //
// unsigned ,    RW, default = 3 Bit 11            reserved Bit 10: 8        reg_rquant_yclut_0_6
// // unsigned ,    RW, default = 3 Bit  7            reserved Bit  6: 4 reg_rquant_yclut_0_5 //
// unsigned ,    RW, default = 2 Bit  3            reserved Bit  2: 0        reg_rquant_yclut_0_4
// // unsigned ,    RW, default = 2
#define DI_AFBCE1_RQUANT_LUT_2 ((0x20d8 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15            reserved
// Bit 14:12        reg_rquant_yclut_0_3      // unsigned ,    RW, default = 1
// Bit 11            reserved
// Bit 10: 8        reg_rquant_yclut_0_2      // unsigned ,    RW, default = 1
// Bit  7            reserved
// Bit  6: 4        reg_rquant_yclut_0_1      // unsigned ,    RW, default = 0
// Bit  3            reserved
// Bit  2: 0        reg_rquant_yclut_0_0      // unsigned ,    RW, default = 0
#define DI_AFBCE1_RQUANT_LUT_3 ((0x20d9 << 2) + 0xff900000)
// Bit 31            reserved
// Bit 30:28        reg_rquant_yclut_1_11     // unsigned ,    RW, default = 5  quantization lut
// for bctree leavs, quant=2^lut(bc_leav_r+1), can be calculated from iquant_yclut(fw_setting) Bit
// 27            reserved Bit 26:24        reg_rquant_yclut_1_10     // unsigned ,    RW, default
// = 5 Bit 23            reserved Bit 22:20        reg_rquant_yclut_1_9      // unsigned ,    RW,
// default = 4 Bit 19            reserved Bit 18:16        reg_rquant_yclut_1_8      // unsigned ,
// RW, default = 4 Bit 15            reserved Bit 14:12        reg_rquant_yclut_1_7      //
// unsigned ,    RW, default = 3 Bit 11            reserved Bit 10: 8        reg_rquant_yclut_1_6
// // unsigned ,    RW, default = 3 Bit  7            reserved Bit  6: 4 reg_rquant_yclut_1_5 //
// unsigned ,    RW, default = 2 Bit  3            reserved Bit  2: 0        reg_rquant_yclut_1_4
// // unsigned ,    RW, default = 2
#define DI_AFBCE1_RQUANT_LUT_4 ((0x20da << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15            reserved
// Bit 14:12        reg_rquant_yclut_1_3      // unsigned ,    RW, default = 1
// Bit 11            reserved
// Bit 10: 8        reg_rquant_yclut_1_2      // unsigned ,    RW, default = 1
// Bit  7            reserved
// Bit  6: 4        reg_rquant_yclut_1_1      // unsigned ,    RW, default = 0
// Bit  3            reserved
// Bit  2: 0        reg_rquant_yclut_1_0      // unsigned ,    RW, default = 0
#define DI_AFBCE1_YUV_FORMAT_CONV_MODE ((0x20db << 2) + 0xff900000)
// Bit 31: 8        reserved
// Bit  7           reserved
// Bit  6: 4        reg_444to422_mode         // unsigned ,    RW, default = 0
// Bit  3           reserved
// Bit  2: 0        reg_422to420_mode         // unsigned ,    RW, default = 0
#define DI_AFBCE1_DUMMY_DATA ((0x20dc << 2) + 0xff900000)
// Bit 31:30        reserved
// Bit 29: 0        reg_dummy_data           // unsigned ,  default = 0  ;
#define DI_AFBCE1_CLR_FLAG ((0x20dd << 2) + 0xff900000)
// Bit 31:0         reg_di_AFBCE1_clr_flag           // unsigned, default = 0  ;
#define DI_AFBCE1_STA_FLAGT ((0x20de << 2) + 0xff900000)
// Bit 31:0         ro_di_AFBCE1__sta_flag        // unsigned, RO,default = 0  ;
#define DI_AFBCE1_MMU_NUM ((0x20df << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15: 0        ro_frm_mmu_num           // unsigned, RO,default = 0  ;
#define DI_AFBCE1_MMU_RMIF_CTRL1 ((0x20e0 << 2) + 0xff900000)
// Bit 31:26 reserved
// Bit 25:24 reg_sync_sel      // unsigned , default = 0, axi canvas id sync with frm rst
// Bit 23:16 reg_canvas_id     // unsigned , default = 0, axi canvas id num
// Bit 15    reserved
// Bit 14:12 reg_cmd_intr_len  // unsigned , default = 1, interrupt send cmd when how many series
// axi cmd, Bit 11:10 reg_cmd_req_size  // unsigned , default = 1, how many room fifo have, then
// axi send series req, 0=16 1=32 2=24 3=64 Bit 9:8   reg_burst_len     // unsigned , default = 2,
// burst type: 0-single 1-bst2 2-bst4 Bit 7     reg_swap_64bit    // unsigned , default = 0,
// 64bits of 128bit swap enable Bit 6     reg_little_endian // unsigned , default = 0, big endian
// enable Bit 5     reg_y_rev         // unsigned , default = 0, vertical reverse enable Bit 4
// reg_x_rev         // unsigned , default = 0, horizontal reverse enable Bit 3     reserved Bit
// 2:0   reg_pack_mode     // unsigned , default = 3, 0:4bit 1:8bit 2:16bit 3:32bit 4:64bit
// 5:128bit
#define DI_AFBCE1_MMU_RMIF_CTRL2 ((0x20e1 << 2) + 0xff900000)
// Bit 31:30 reg_sw_rst        // unsigned , default = 0,
// Bit 29:24 reserved
// Bit 23:18 reg_gclk_ctrl
// Bit 17    reserved
// Bit 16:0  reg_urgent_ctrl   // unsigned , default = 0, urgent control reg :
#define DI_AFBCE1_MMU_RMIF_CTRL3 ((0x20e2 << 2) + 0xff900000)
// Bit 31:17 reserved
// Bit 16    reg_acc_mode      // unsigned , default = 1,
// Bit 15:13 reserved
// Bit 12:0  reg_stride        // unsigned , default = 4096,
#define DI_AFBCE1_MMU_RMIF_CTRL4 ((0x20e3 << 2) + 0xff900000)
// Bit 31:0  reg_baddr        // unsigned , default = 0,
#define DI_AFBCE1_MMU_RMIF_SCOPE_X ((0x20e4 << 2) + 0xff900000)
// Bit 31:29 reserved
// Bit 28:16 reg_x_end         // unsigned , default = 4095, the canvas hor end pixel position
// Bit 15:13 reserved
// Bit 12: 0 reg_x_start       // unsigned , default = 0, the canvas hor start pixel position
#define DI_AFBCE1_MMU_RMIF_SCOPE_Y ((0x20e5 << 2) + 0xff900000)
// Bit 31:29 reserved
// Bit 28:16 reg_y_end         // unsigned , default = 0, the canvas ver end pixel position
// Bit 15:13 reserved
// Bit 12: 0 reg_y_start       // unsigned , default = 0, the canvas ver start pixel positio
#define DI_AFBCE1_MMU_RMIF_RO_STAT ((0x20e6 << 2) + 0xff900000)
// Bit 15:0  reg_status        // unsigned ,
#define DI_AFBCE1_PIP_CTRL ((0x20ea << 2) + 0xff900000)
// Bit   31:3      reserved
// Bit   2         reg_enc_align_en     //unsigned  , RW,default = 1,
// Bit   1         reg_pip_ini_ctrl     //unsigned  , RW,default = 0,
// Bit   0         reg_pip_mode         //unsigned  , RW,default = 0,
#define DI_AFBCE1_ROT_CTRL ((0x20eb << 2) + 0xff900000)
// Bit   31:5      reserved
// Bit   4         reg_rot_en           //unsigned  , RW,default = 0, rotation enable
// Bit   3:0       reg_vstep            //unsigned  , RW,default = 8, rotation vstep ,setting
// acorrding rotation shrink mode
#define DI_AFBCE1_DIMM_CTRL ((0x20ec << 2) + 0xff900000)
// Bit   31        reg_dimm_layer_en   //unsigned  , RW,default = 0,dimm_layer enable signal
// Bit   30        reserved
// Bit   29:0      reg_dimm_data       //unsigned  , RW,default = 29'h00080200,dimm_layer data
#define DI_AFBCE1_BND_DEC_MISC ((0x20ed << 2) + 0xff900000)
// Bit 31:28  reserved
// Bit 27:26  bnd_dec_rev_mode         //unsigned , RW,default = 0    only pip mode use those
// bits,ususaly don't need configure Bit 25:24  bnd_dec_mif_urgent       //unsigned , RW,default =
// 3    only pip mode use those bits,ususaly don't need configure Bit 23:22  bnd_dec_burst_len
// //unsigned , RW,default = 2    only pip mode use those bits,ususaly don't need configure Bit
// 21:20  bnd_dec_ddr_blk_size     //unsigned , RW,default = 1    only pip mode use those
// bits,ususaly don't need configure Bit 19     reserved Bit 18:16  bnd_dec_cmd_blk_size
// //unsigned , RW,default = 3    only pip mode use those bits,ususaly don't need configure Bit 15
// reserved Bit 14     bnd_dec_blk_mem_mode     //unsigned , RW,default = 0    only pip mode use
// those bits,ususaly don't need configure Bit 13     bnd_dec_addr_link_en     //unsigned ,
// RW,default = 1    only pip mode use those bits,ususaly don't need configure Bit 12
// bnd_dec_always_body_rden
// //unsigned , RW,default = 0    only pip mode use those bits,ususaly don't need configure Bit
// 11:0   bnd_dec_mif_lbuf_depth   //unsigned , RW,default = 128  only pip mode use those
// bits,ususaly don't need configure
#define DI_AFBCE1_RD_ARB_MISC ((0x20ee << 2) + 0xff900000)
// Bit 31:13  reserved
// Bit 12     reg_arb_sw_rst          //unsigned , RW,default = 0    only pip mode use those
// bits,ususaly don't need configure Bit 11:10  reserved Bit 9      reg_arb_arblk_last1 //unsigned
// , RW,default = 0    only pip mode use those bits,ususaly don't need configure Bit 8
// reg_arb_arblk_last0     //unsigned , RW,default = 0    only pip mode use those bits,ususaly
// don't need configure Bit 7:4    reg_arb_weight_ch1      //unsigned , RW,default = 4    only pip
// mode use those bits,ususaly don't need configure Bit 3:0    reg_arb_weight_ch0      //unsigned
// , RW,default = 10   only pip mode use those bits,ususaly don't need configure synopsys
// translate_off synopsys translate_on
//
// Closing file:  di_afbc_enc1_regs.h
//
// the segment is 8'hf0-8'hff, 8'ha8-8'hab
//
// Reading file:  di_wrmif1_regs.h
//
#define DIWR_DBG_AXI_CMD_CNT ((0x20f0 << 2) + 0xff900000)
#define DIWR_DBG_AXI_DAT_CNT ((0x20f1 << 2) + 0xff900000)
#define DI_DIWR_CANVAS ((0x20f2 << 2) + 0xff900000)
#define DI_DIWR_URGENT ((0x20f3 << 2) + 0xff900000)
#define DI_DIWR_X ((0x20f4 << 2) + 0xff900000)
#define DI_DIWR_Y ((0x20f5 << 2) + 0xff900000)
// bit 31:30		  diwr_words_lim
// bit 29		  diwr_rev_y
// bit 28:16		  diwr_start_y
// bit 15		  diwr_ext_en
// bit 12:0		  diwr_end_y
#define DI_DIWR_CTRL ((0x20f6 << 2) + 0xff900000)
// bit 31		  pending_ddr_wrrsp_diwr
// bit 30		  diwr_reg_swap
// bit 29:26		  diwr_burst_lim
// bit 25		  diwr_canvas_syncen
// bit 24		  diwr_no_clk_gate
// bit 23:22		  diwr_rgb_mode  0:422 to one canvas;1:4:4:4 to one canvas 2:Y to luma ,
// CBCR to chroma canvas ,for nv12/21; 3 : reserved bit 21:20		  diwr_hconv_mode bit
// 19:18		  diwr_vconv_mode bit 17		  diwr_swap_cbcr bit 16 diwr_urgent
// bit 15:8		  diwr_canvas_index_chroma bit 7:0		  diwr_canvas_index_luma
#define DI_DIWR_SHRK_CTRL ((0x20f7 << 2) + 0xff900000)
// bit   31:10     reserved
// bit   9:8       reg_vshrk_mode        unsigned, default = 0, 0:1/2 horizonal shrink 1:1/4
// horizonal shrink 2:1/8 horizonal shrink bit   7:6       reg_hshrk_mode        unsigned, default
// = 0, 0:1/2 vertical shrink 1:1/4 vertical shrink 2:1/8 vertical shrink bit   5:2 reg_gclk_ctrl
// unsigned, default = 0 bit   1         reg_frm_rst           unsigned, default = 0 bit   0
// reg_shrk_en           unsigned, default = 0
#define DI_DIWR_SHRK_SIZE ((0x20f8 << 2) + 0xff900000)
// bit   31:26     reserved
// bit   25:13     reg_frm_hsize         unsigned, default = 1920, hsize in
// bit   12:0      reg_frm_vsize         unsigned, default = 1080, vsize in
#define DI_DIWR_CROP_CTRL ((0x20fa << 2) + 0xff900000)
// Bit   31        reg_crop_en           unsigned  , RW,default = 0,dimm_layer enable signal
// Bit   30:4      reserved
// Bit   3:0       reg_hold_line         unsigned  , RW,default = 4,dimm_layer data
#define DI_DIWR_CROP_DIMM_CTRL ((0x20fb << 2) + 0xff900000)
// Bit   31        reg_dimm_layer_en     unsigned  , RW,default = 0,dimm_layer enable signal
// Bit   30        reserved
// Bit   29:0      reg_dimm_data         unsigned  , RW,default = 29'h00080200,dimm_layer data
#define DI_DIWR_CROP_SIZE_IN ((0x20fc << 2) + 0xff900000)
// Bit   31:29,    reserved
// Bit   28:16     reg_crop_hsize         unsigned, default = 1920 , pic horz size in  unit: pixel
// Bit   15:13,    reserved
// Bit   12:0,     reg_crop_vsize         unsigned, default = 1080 , pic vert size in  unit: pixel
#define DI_DIWR_CROP_HSCOPE ((0x20fd << 2) + 0xff900000)
// Bit   31:29,    reserved
// Bit   28:16,    reg_cropwin_end_h      unsigned, default = 1919 ;
// Bit   15:13,    reserved
// Bit   12:0,     reg_cropwin_bgn_h      unsigned, default = 0    ;
#define DI_DIWR_CROP_VSCOPE ((0x20fe << 2) + 0xff900000)
// Bit   31:29,    reserved
// Bit   28:16,    reg_cropwin_end_v      unsigned, default = 1079 ;
// Bit   15:13,    reserved
// Bit   12:0,     reg_cropwin_bgn_v      unsigned, default = 0    ;
#define DI_DIWR_BADDR0 ((0x20a8 << 2) + 0xff900000)
// Bit   31:0      wmif_baddr_luma        unsigned, default = 0x20000
#define DI_DIWR_STRIDE0 ((0x20a9 << 2) + 0xff900000)
// Bit   31        canvas_mode_en         unsigned, default = 0    ;
// Bit   30:14     reserved
// Bit   13:0      wmif_stride_luma       unsigned, default = 0x1000;
#define DI_DIWR_BADDR1 ((0x20aa << 2) + 0xff900000)
// Bit   31:0      wmif_baddr_chroma      unsigned, default = 0x20000
#define DI_DIWR_STRIDE1 ((0x20ab << 2) + 0xff900000)
// Bit   31        canvas_mode_en         unsigned, default = 0    ;
// Bit   30:14     reserved
// Bit   13:0      wmif_stride_chroma     unsigned, default = 0x1000;
//
// Closing file:  di_wrmif1_regs.h
//
//
// Closing file:  vregs_clk1.h
//
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VENC1A_VCBUS_BASE = 0x21
// -----------------------------------------------
//===========================================================================
//
// Reading file:  venc_1_regs.h
//
//===========================================================================
// Video Interface Registers    0xa00 - 0xbff
//===========================================================================
//`define  VENC10A_VCBUS_BASE             8'h1b
// bit 15:8 -- vfifo2vd_vd_sel
// bit 0 -- vfifo2vd_en
#define ENCP1_VFIFO2VD_CTL ((0x2158 << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCP1_VFIFO2VD_PIXEL_START ((0x2159 << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCP1_VFIFO2VD_PIXEL_END ((0x215a << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCP1_VFIFO2VD_LINE_TOP_START ((0x215b << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCP1_VFIFO2VD_LINE_TOP_END ((0x215c << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCP1_VFIFO2VD_LINE_BOT_START ((0x215d << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCP1_VFIFO2VD_LINE_BOT_END ((0x215e << 2) + 0xff900000)
// Route the hsync and vsync signals round the chip. There are three
// sources and users of these signals: VIU, internal video encoder, and
// the pins on the chip. Some muxing is still being done in the VIU. It
// was not moved to the venc module so that the same exact VIU code could
// be used both in Twister and Twister2000.
// Bit 2: venc_sync_source (1=>pins, 0=>viu)
// Bit 1: viu_sync_source (1=>pins, 0=>venc)
// Bit 0: vpins_sync_source (1=>venc, 0=>viu)
#define VENC1_SYNC_ROUTE ((0x2160 << 2) + 0xff900000)
#define VENC1_VIDEO_EXSRC ((0x2161 << 2) + 0xff900000)
#define VENC1_DVI_SETTING ((0x2162 << 2) + 0xff900000)
#define VENC1_C656_CTRL ((0x2163 << 2) + 0xff900000)
#define VENC1_UPSAMPLE_CTRL0 ((0x2164 << 2) + 0xff900000)
#define VENC1_UPSAMPLE_CTRL1 ((0x2165 << 2) + 0xff900000)
#define VENC1_UPSAMPLE_CTRL2 ((0x2166 << 2) + 0xff900000)
// Invert control for tcon output
// bit[15:14] -- vsync, hsync,
// bit[13:0] --  oev3, oev2, cpv2, cph3, cph2, cph1, oeh, vcom, stv2, stv1, cpv1, oev1, sth1, sth2
#define TCON1_INVERT_CTL ((0x2167 << 2) + 0xff900000)
#define VENC1_VIDEO_PROG_MODE ((0x2168 << 2) + 0xff900000)
//---- Venc pixel/line info
#define VENC1_ENCI_LINE ((0x2169 << 2) + 0xff900000)
#define VENC1_ENCI_PIXEL ((0x216a << 2) + 0xff900000)
#define VENC1_ENCP_LINE ((0x216b << 2) + 0xff900000)
#define VENC1_ENCP_PIXEL ((0x216c << 2) + 0xff900000)
//---- Status
#define VENC1_STATA ((0x216d << 2) + 0xff900000)
//---- Interrupt setting
#define VENC1_INTCTRL ((0x216e << 2) + 0xff900000)
#define VENC1_INTFLAG ((0x216f << 2) + 0xff900000)
//--------- Video test configuration
#define VENC1_VIDEO_TST_EN ((0x2170 << 2) + 0xff900000)
#define VENC1_VIDEO_TST_MDSEL ((0x2171 << 2) + 0xff900000)
#define VENC1_VIDEO_TST_Y ((0x2172 << 2) + 0xff900000)
#define VENC1_VIDEO_TST_CB ((0x2173 << 2) + 0xff900000)
#define VENC1_VIDEO_TST_CR ((0x2174 << 2) + 0xff900000)
#define VENC1_VIDEO_TST_CLRBAR_STRT ((0x2175 << 2) + 0xff900000)
#define VENC1_VIDEO_TST_CLRBAR_WIDTH ((0x2176 << 2) + 0xff900000)
#define VENC1_VIDEO_TST_VDCNT_STSET ((0x2177 << 2) + 0xff900000)
//----- Video dac setting
#define VENC1_VDAC_DACSEL0 ((0x2178 << 2) + 0xff900000)
#define VENC1_VDAC_DACSEL1 ((0x2179 << 2) + 0xff900000)
#define VENC1_VDAC_DACSEL2 ((0x217a << 2) + 0xff900000)
#define VENC1_VDAC_DACSEL3 ((0x217b << 2) + 0xff900000)
#define VENC1_VDAC_DACSEL4 ((0x217c << 2) + 0xff900000)
#define VENC1_VDAC_DACSEL5 ((0x217d << 2) + 0xff900000)
#define VENC1_VDAC_SETTING ((0x217e << 2) + 0xff900000)
#define VENC1_VDAC_TST_VAL ((0x217f << 2) + 0xff900000)
#define VENC1_VDAC_DAC0_GAINCTRL ((0x21f0 << 2) + 0xff900000)
#define VENC1_VDAC_DAC0_OFFSET ((0x21f1 << 2) + 0xff900000)
#define VENC1_VDAC_DAC1_GAINCTRL ((0x21f2 << 2) + 0xff900000)
#define VENC1_VDAC_DAC1_OFFSET ((0x21f3 << 2) + 0xff900000)
#define VENC1_VDAC_DAC2_GAINCTRL ((0x21f4 << 2) + 0xff900000)
#define VENC1_VDAC_DAC2_OFFSET ((0x21f5 << 2) + 0xff900000)
#define VENC1_VDAC_DAC3_GAINCTRL ((0x21f6 << 2) + 0xff900000)
#define VENC1_VDAC_DAC3_OFFSET ((0x21f7 << 2) + 0xff900000)
#define VENC1_VDAC_DAC4_GAINCTRL ((0x21f8 << 2) + 0xff900000)
#define VENC1_VDAC_DAC4_OFFSET ((0x21f9 << 2) + 0xff900000)
#define VENC1_VDAC_DAC5_GAINCTRL ((0x21fa << 2) + 0xff900000)
#define VENC1_VDAC_DAC5_OFFSET ((0x21fb << 2) + 0xff900000)
#define VENC1_VDAC_FIFO_CTRL ((0x21fc << 2) + 0xff900000)
#define ENCL1_TCON_INVERT_CTL ((0x21fd << 2) + 0xff900000)
//
// Closing file:  venc_1_regs.h
//
//
// Reading file:  enc480p_1_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// Video Encoder 480p Registers    0xb80 - 0xbef
//===========================================================================
//-------- Video basic setting
#define ENCP1_VIDEO_EN ((0x2180 << 2) + 0xff900000)
#define ENCP1_VIDEO_SYNC_MODE ((0x2181 << 2) + 0xff900000)
#define ENCP1_MACV_EN ((0x2182 << 2) + 0xff900000)
#define ENCP1_VIDEO_Y_SCL ((0x2183 << 2) + 0xff900000)
#define ENCP1_VIDEO_PB_SCL ((0x2184 << 2) + 0xff900000)
#define ENCP1_VIDEO_PR_SCL ((0x2185 << 2) + 0xff900000)
#define ENCP1_VIDEO_SYNC_SCL ((0x2186 << 2) + 0xff900000)
#define ENCP1_VIDEO_MACV_SCL ((0x2187 << 2) + 0xff900000)
#define ENCP1_VIDEO_Y_OFFST ((0x2188 << 2) + 0xff900000)
#define ENCP1_VIDEO_PB_OFFST ((0x2189 << 2) + 0xff900000)
#define ENCP1_VIDEO_PR_OFFST ((0x218a << 2) + 0xff900000)
#define ENCP1_VIDEO_SYNC_OFFST ((0x218b << 2) + 0xff900000)
#define ENCP1_VIDEO_MACV_OFFST ((0x218c << 2) + 0xff900000)
//----- Video mode
#define ENCP1_VIDEO_MODE ((0x218d << 2) + 0xff900000)
#define ENCP1_VIDEO_MODE_ADV ((0x218e << 2) + 0xff900000)
//--------------- Debug pins
#define ENCP1_DBG_PX_RST ((0x2190 << 2) + 0xff900000)
#define ENCP1_DBG_LN_RST ((0x2191 << 2) + 0xff900000)
#define ENCP1_DBG_PX_INT ((0x2192 << 2) + 0xff900000)
#define ENCP1_DBG_LN_INT ((0x2193 << 2) + 0xff900000)
//----------- Video Advanced setting
#define ENCP1_VIDEO_YFP1_HTIME ((0x2194 << 2) + 0xff900000)
#define ENCP1_VIDEO_YFP2_HTIME ((0x2195 << 2) + 0xff900000)
#define ENCP1_VIDEO_YC_DLY ((0x2196 << 2) + 0xff900000)
#define ENCP1_VIDEO_MAX_PXCNT ((0x2197 << 2) + 0xff900000)
#define ENCP1_VIDEO_HSPULS_BEGIN ((0x2198 << 2) + 0xff900000)
#define ENCP1_VIDEO_HSPULS_END ((0x2199 << 2) + 0xff900000)
#define ENCP1_VIDEO_HSPULS_SWITCH ((0x219a << 2) + 0xff900000)
#define ENCP1_VIDEO_VSPULS_BEGIN ((0x219b << 2) + 0xff900000)
#define ENCP1_VIDEO_VSPULS_END ((0x219c << 2) + 0xff900000)
#define ENCP1_VIDEO_VSPULS_BLINE ((0x219d << 2) + 0xff900000)
#define ENCP1_VIDEO_VSPULS_ELINE ((0x219e << 2) + 0xff900000)
#define ENCP1_VIDEO_EQPULS_BEGIN ((0x219f << 2) + 0xff900000)
#define ENCP1_VIDEO_EQPULS_END ((0x21a0 << 2) + 0xff900000)
#define ENCP1_VIDEO_EQPULS_BLINE ((0x21a1 << 2) + 0xff900000)
#define ENCP1_VIDEO_EQPULS_ELINE ((0x21a2 << 2) + 0xff900000)
#define ENCP1_VIDEO_HAVON_END ((0x21a3 << 2) + 0xff900000)
#define ENCP1_VIDEO_HAVON_BEGIN ((0x21a4 << 2) + 0xff900000)
#define ENCP1_VIDEO_VAVON_ELINE ((0x21af << 2) + 0xff900000)
#define ENCP1_VIDEO_VAVON_BLINE ((0x21a6 << 2) + 0xff900000)
#define ENCP1_VIDEO_HSO_BEGIN ((0x21a7 << 2) + 0xff900000)
#define ENCP1_VIDEO_HSO_END ((0x21a8 << 2) + 0xff900000)
#define ENCP1_VIDEO_VSO_BEGIN ((0x21a9 << 2) + 0xff900000)
#define ENCP1_VIDEO_VSO_END ((0x21aa << 2) + 0xff900000)
#define ENCP1_VIDEO_VSO_BLINE ((0x21ab << 2) + 0xff900000)
#define ENCP1_VIDEO_VSO_ELINE ((0x21ac << 2) + 0xff900000)
#define ENCP1_VIDEO_SYNC_WAVE_CURVE ((0x21ad << 2) + 0xff900000)
#define ENCP1_VIDEO_MAX_LNCNT ((0x21ae << 2) + 0xff900000)
#define ENCP1_VIDEO_SY_VAL ((0x21b0 << 2) + 0xff900000)
#define ENCP1_VIDEO_SY2_VAL ((0x21b1 << 2) + 0xff900000)
#define ENCP1_VIDEO_BLANKY_VAL ((0x21b2 << 2) + 0xff900000)
#define ENCP1_VIDEO_BLANKPB_VAL ((0x21b3 << 2) + 0xff900000)
#define ENCP1_VIDEO_BLANKPR_VAL ((0x21b4 << 2) + 0xff900000)
#define ENCP1_VIDEO_HOFFST ((0x21b5 << 2) + 0xff900000)
#define ENCP1_VIDEO_VOFFST ((0x21b6 << 2) + 0xff900000)
#define ENCP1_VIDEO_RGB_CTRL ((0x21b7 << 2) + 0xff900000)
#define ENCP1_VIDEO_FILT_CTRL ((0x21b8 << 2) + 0xff900000)
#define ENCP1_VIDEO_OFLD_VPEQ_OFST ((0x21b9 << 2) + 0xff900000)
#define ENCP1_VIDEO_OFLD_VOAV_OFST ((0x21ba << 2) + 0xff900000)
#define ENCP1_VIDEO_MATRIX_CB ((0x21bb << 2) + 0xff900000)
#define ENCP1_VIDEO_MATRIX_CR ((0x21bc << 2) + 0xff900000)
#define ENCP1_VIDEO_RGBIN_CTRL ((0x21bd << 2) + 0xff900000)
//------------------Macrovision advanced setting
#define ENCP1_MACV_BLANKY_VAL ((0x21c0 << 2) + 0xff900000)
#define ENCP1_MACV_MAXY_VAL ((0x21c1 << 2) + 0xff900000)
#define ENCP1_MACV_1ST_PSSYNC_STRT ((0x21c2 << 2) + 0xff900000)
#define ENCP1_MACV_PSSYNC_STRT ((0x21c3 << 2) + 0xff900000)
#define ENCP1_MACV_AGC_STRT ((0x21c4 << 2) + 0xff900000)
#define ENCP1_MACV_AGC_END ((0x21c5 << 2) + 0xff900000)
#define ENCP1_MACV_WAVE_END ((0x21c6 << 2) + 0xff900000)
#define ENCP1_MACV_STRTLINE ((0x21c7 << 2) + 0xff900000)
#define ENCP1_MACV_ENDLINE ((0x21c8 << 2) + 0xff900000)
#define ENCP1_MACV_TS_CNT_MAX_L ((0x21c9 << 2) + 0xff900000)
#define ENCP1_MACV_TS_CNT_MAX_H ((0x21ca << 2) + 0xff900000)
#define ENCP1_MACV_TIME_DOWN ((0x21cb << 2) + 0xff900000)
#define ENCP1_MACV_TIME_LO ((0x21cc << 2) + 0xff900000)
#define ENCP1_MACV_TIME_UP ((0x21cd << 2) + 0xff900000)
#define ENCP1_MACV_TIME_RST ((0x21ce << 2) + 0xff900000)
//---------------- VBI control -------------------
#define ENCP1_VBI_CTRL ((0x21d0 << 2) + 0xff900000)
#define ENCP1_VBI_SETTING ((0x21d1 << 2) + 0xff900000)
#define ENCP1_VBI_BEGIN ((0x21d2 << 2) + 0xff900000)
#define ENCP1_VBI_WIDTH ((0x21d3 << 2) + 0xff900000)
#define ENCP1_VBI_HVAL ((0x21d4 << 2) + 0xff900000)
#define ENCP1_VBI_DATA0 ((0x21d5 << 2) + 0xff900000)
#define ENCP1_VBI_DATA1 ((0x21d6 << 2) + 0xff900000)
//----------------C656 OUT Control------------- Grant
#define C656_HS_ST_1 ((0x21e0 << 2) + 0xff900000)
#define C656_HS_ED_1 ((0x21e1 << 2) + 0xff900000)
#define C656_VS_LNST_E_1 ((0x21e2 << 2) + 0xff900000)
#define C656_VS_LNST_O_1 ((0x21e3 << 2) + 0xff900000)
#define C656_VS_LNED_E_1 ((0x21e4 << 2) + 0xff900000)
#define C656_VS_LNED_O_1 ((0x21e5 << 2) + 0xff900000)
#define C656_FS_LNST_1 ((0x21e6 << 2) + 0xff900000)
#define C656_FS_LNED_1 ((0x21e7 << 2) + 0xff900000)
#define ENCP1_VRR_CTRL ((0x21e8 << 2) + 0xff900000)
#define ENCP1_VRR_ADJ_LMT ((0x21e9 << 2) + 0xff900000)
#define ENCP1_VRR_CTRL1 ((0x21ea << 2) + 0xff900000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  enc480p_1_regs.h
//
//
// Reading file:  enci_1_regs.h
//
//===========================================================================
// Video Interface Registers    0xb00 - 0xb57
//===========================================================================
#define ENCI1_VIDEO_MODE ((0x2100 << 2) + 0xff900000)
#define ENCI1_VIDEO_MODE_ADV ((0x2101 << 2) + 0xff900000)
#define ENCI1_VIDEO_FSC_ADJ ((0x2102 << 2) + 0xff900000)
#define ENCI1_VIDEO_BRIGHT ((0x2103 << 2) + 0xff900000)
#define ENCI1_VIDEO_CONT ((0x2104 << 2) + 0xff900000)
#define ENCI1_VIDEO_SAT ((0x2105 << 2) + 0xff900000)
#define ENCI1_VIDEO_HUE ((0x2106 << 2) + 0xff900000)
#define ENCI1_VIDEO_SCH ((0x2107 << 2) + 0xff900000)
#define ENCI1_SYNC_MODE ((0x2108 << 2) + 0xff900000)
#define ENCI1_SYNC_CTRL ((0x2109 << 2) + 0xff900000)
#define ENCI1_SYNC_HSO_BEGIN ((0x210a << 2) + 0xff900000)
#define ENCI1_SYNC_HSO_END ((0x210b << 2) + 0xff900000)
#define ENCI1_SYNC_VSO_EVN ((0x210c << 2) + 0xff900000)
#define ENCI1_SYNC_VSO_ODD ((0x210d << 2) + 0xff900000)
#define ENCI1_SYNC_VSO_EVNLN ((0x210e << 2) + 0xff900000)
#define ENCI1_SYNC_VSO_ODDLN ((0x210f << 2) + 0xff900000)
#define ENCI1_SYNC_HOFFST ((0x2110 << 2) + 0xff900000)
#define ENCI1_SYNC_VOFFST ((0x2111 << 2) + 0xff900000)
#define ENCI1_SYNC_ADJ ((0x2112 << 2) + 0xff900000)
#define ENCI1_RGB_SETTING ((0x2113 << 2) + 0xff900000)
//`define    ENCI1_CMPN_MATRIX_CB        8'h14
//`define    ENCI1_CMPN_MATRIX_CR        8'h15
#define ENCI1_DE_H_BEGIN ((0x2116 << 2) + 0xff900000)
#define ENCI1_DE_H_END ((0x2117 << 2) + 0xff900000)
#define ENCI1_DE_V_BEGIN_EVEN ((0x2118 << 2) + 0xff900000)
#define ENCI1_DE_V_END_EVEN ((0x2119 << 2) + 0xff900000)
#define ENCI1_DE_V_BEGIN_ODD ((0x211a << 2) + 0xff900000)
#define ENCI1_DE_V_END_ODD ((0x211b << 2) + 0xff900000)
#define ENCI1_VBI_SETTING ((0x2120 << 2) + 0xff900000)
#define ENCI1_VBI_CCDT_EVN ((0x2121 << 2) + 0xff900000)
#define ENCI1_VBI_CCDT_ODD ((0x2122 << 2) + 0xff900000)
#define ENCI1_VBI_CC525_LN ((0x2123 << 2) + 0xff900000)
#define ENCI1_VBI_CC625_LN ((0x2124 << 2) + 0xff900000)
#define ENCI1_VBI_WSSDT ((0x2125 << 2) + 0xff900000)
#define ENCI1_VBI_WSS_LN ((0x2126 << 2) + 0xff900000)
#define ENCI1_VBI_CGMSDT_L ((0x2127 << 2) + 0xff900000)
#define ENCI1_VBI_CGMSDT_H ((0x2128 << 2) + 0xff900000)
#define ENCI1_VBI_CGMS_LN ((0x2129 << 2) + 0xff900000)
#define ENCI1_VBI_TTX_HTIME ((0x212a << 2) + 0xff900000)
#define ENCI1_VBI_TTX_LN ((0x212b << 2) + 0xff900000)
#define ENCI1_VBI_TTXDT0 ((0x212c << 2) + 0xff900000)
#define ENCI1_VBI_TTXDT1 ((0x212d << 2) + 0xff900000)
#define ENCI1_VBI_TTXDT2 ((0x212e << 2) + 0xff900000)
#define ENCI1_VBI_TTXDT3 ((0x212f << 2) + 0xff900000)
#define ENCI1_MACV_N0 ((0x2130 << 2) + 0xff900000)
#define ENCI1_MACV_N1 ((0x2131 << 2) + 0xff900000)
#define ENCI1_MACV_N2 ((0x2132 << 2) + 0xff900000)
#define ENCI1_MACV_N3 ((0x2133 << 2) + 0xff900000)
#define ENCI1_MACV_N4 ((0x2134 << 2) + 0xff900000)
#define ENCI1_MACV_N5 ((0x2135 << 2) + 0xff900000)
#define ENCI1_MACV_N6 ((0x2136 << 2) + 0xff900000)
#define ENCI1_MACV_N7 ((0x2137 << 2) + 0xff900000)
#define ENCI1_MACV_N8 ((0x2138 << 2) + 0xff900000)
#define ENCI1_MACV_N9 ((0x2139 << 2) + 0xff900000)
#define ENCI1_MACV_N10 ((0x213a << 2) + 0xff900000)
#define ENCI1_MACV_N11 ((0x213b << 2) + 0xff900000)
#define ENCI1_MACV_N12 ((0x213c << 2) + 0xff900000)
#define ENCI1_MACV_N13 ((0x213d << 2) + 0xff900000)
#define ENCI1_MACV_N14 ((0x213e << 2) + 0xff900000)
#define ENCI1_MACV_N15 ((0x213f << 2) + 0xff900000)
#define ENCI1_MACV_N16 ((0x2140 << 2) + 0xff900000)
#define ENCI1_MACV_N17 ((0x2141 << 2) + 0xff900000)
#define ENCI1_MACV_N18 ((0x2142 << 2) + 0xff900000)
#define ENCI1_MACV_N19 ((0x2143 << 2) + 0xff900000)
#define ENCI1_MACV_N20 ((0x2144 << 2) + 0xff900000)
#define ENCI1_MACV_N21 ((0x2145 << 2) + 0xff900000)
#define ENCI1_MACV_N22 ((0x2146 << 2) + 0xff900000)
//`define    ENCI1_MACV_P_AGC            8'h47
#define ENCI1_DBG_PX_RST ((0x2148 << 2) + 0xff900000)
#define ENCI1_DBG_FLDLN_RST ((0x2149 << 2) + 0xff900000)
#define ENCI1_DBG_PX_INT ((0x214a << 2) + 0xff900000)
#define ENCI1_DBG_FLDLN_INT ((0x214b << 2) + 0xff900000)
#define ENCI1_DBG_MAXPX ((0x214c << 2) + 0xff900000)
#define ENCI1_DBG_MAXLN ((0x214d << 2) + 0xff900000)
#define ENCI1_MACV_MAX_AMP ((0x2150 << 2) + 0xff900000)
#define ENCI1_MACV_PULSE_LO ((0x2151 << 2) + 0xff900000)
#define ENCI1_MACV_PULSE_HI ((0x2152 << 2) + 0xff900000)
#define ENCI1_MACV_BKP_MAX ((0x2153 << 2) + 0xff900000)
#define ENCI1_CFILT_CTRL ((0x2154 << 2) + 0xff900000)
#define ENCI1_CFILT7 ((0x2155 << 2) + 0xff900000)
#define ENCI1_YC_DELAY ((0x2156 << 2) + 0xff900000)
#define ENCI1_VIDEO_EN ((0x2157 << 2) + 0xff900000)
//
// Closing file:  enci_1_regs.h
//
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VENC1B_VCBUS_BASE = 0x22
// -----------------------------------------------
//===========================================================================
//
// Reading file:  venc2_1_regs.h
//
//===========================================================================
// Venc Registers (Cont.)    0xc00 - 0xcff (VENC registers 0xc00 - 0xcef)
//===========================================================================
//`define  VENC0B_VCBUS_BASE            8'h1c
//`define  VENC1B_VCBUS_BASE            8'h22
//`define  VENC2B_VCBUS_BASE            8'h24
// Program video control signals from ENCI core to DVI/HDMI interface
#define ENCI1_DVI_HSO_BEGIN ((0x2200 << 2) + 0xff900000)
#define ENCI1_DVI_HSO_END ((0x2201 << 2) + 0xff900000)
#define ENCI1_DVI_VSO_BLINE_EVN ((0x2202 << 2) + 0xff900000)
#define ENCI1_DVI_VSO_BLINE_ODD ((0x2203 << 2) + 0xff900000)
#define ENCI1_DVI_VSO_ELINE_EVN ((0x2204 << 2) + 0xff900000)
#define ENCI1_DVI_VSO_ELINE_ODD ((0x2205 << 2) + 0xff900000)
#define ENCI1_DVI_VSO_BEGIN_EVN ((0x2206 << 2) + 0xff900000)
#define ENCI1_DVI_VSO_BEGIN_ODD ((0x2207 << 2) + 0xff900000)
#define ENCI1_DVI_VSO_END_EVN ((0x2208 << 2) + 0xff900000)
#define ENCI1_DVI_VSO_END_ODD ((0x2209 << 2) + 0xff900000)
// Define cmpt and cvbs cb/cr delay after ENCI chroma filters
// Bit 15:12 RW, enci_cb_cvbs_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit 11: 8 RW, enci_cr_cvbs_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit  7: 4 RW, enci_cb_cmpt_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit  3: 0 RW, enci_cr_cmpt_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
#define ENCI1_CFILT_CTRL2 ((0x220a << 2) + 0xff900000)
#define ENCI1_DACSEL_0 ((0x220b << 2) + 0xff900000)
#define ENCI1_DACSEL_1 ((0x220c << 2) + 0xff900000)
#define ENCP1_DACSEL_0 ((0x220d << 2) + 0xff900000)
#define ENCP1_DACSEL_1 ((0x220e << 2) + 0xff900000)
#define ENCP1_MAX_LINE_SWITCH_POINT ((0x220f << 2) + 0xff900000)
#define ENCI1_TST_EN ((0x2210 << 2) + 0xff900000)
#define ENCI1_TST_MDSEL ((0x2211 << 2) + 0xff900000)
#define ENCI1_TST_Y ((0x2212 << 2) + 0xff900000)
#define ENCI1_TST_CB ((0x2213 << 2) + 0xff900000)
#define ENCI1_TST_CR ((0x2214 << 2) + 0xff900000)
#define ENCI1_TST_CLRBAR_STRT ((0x2215 << 2) + 0xff900000)
#define ENCI1_TST_CLRBAR_WIDTH ((0x2216 << 2) + 0xff900000)
#define ENCI1_TST_VDCNT_STSET ((0x2217 << 2) + 0xff900000)
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define ENCI1_VFIFO2VD_CTL ((0x2218 << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCI1_VFIFO2VD_PIXEL_START ((0x2219 << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCI1_VFIFO2VD_PIXEL_END ((0x221a << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCI1_VFIFO2VD_LINE_TOP_START ((0x221b << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCI1_VFIFO2VD_LINE_TOP_END ((0x221c << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCI1_VFIFO2VD_LINE_BOT_START ((0x221d << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCI1_VFIFO2VD_LINE_BOT_END ((0x221e << 2) + 0xff900000)
#define ENCI1_VFIFO2VD_CTL2 ((0x221f << 2) + 0xff900000)
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define ENCT1_VFIFO2VD_CTL ((0x2220 << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCT1_VFIFO2VD_PIXEL_START ((0x2221 << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCT1_VFIFO2VD_PIXEL_END ((0x2222 << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCT1_VFIFO2VD_LINE_TOP_START ((0x2223 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCT1_VFIFO2VD_LINE_TOP_END ((0x2224 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCT1_VFIFO2VD_LINE_BOT_START ((0x2225 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCT1_VFIFO2VD_LINE_BOT_END ((0x2226 << 2) + 0xff900000)
#define ENCT1_VFIFO2VD_CTL2 ((0x2227 << 2) + 0xff900000)
#define ENCT1_TST_EN ((0x2228 << 2) + 0xff900000)
#define ENCT1_TST_MDSEL ((0x2229 << 2) + 0xff900000)
#define ENCT1_TST_Y ((0x222a << 2) + 0xff900000)
#define ENCT1_TST_CB ((0x222b << 2) + 0xff900000)
#define ENCT1_TST_CR ((0x222c << 2) + 0xff900000)
#define ENCT1_TST_CLRBAR_STRT ((0x222d << 2) + 0xff900000)
#define ENCT1_TST_CLRBAR_WIDTH ((0x222e << 2) + 0xff900000)
#define ENCT1_TST_VDCNT_STSET ((0x222f << 2) + 0xff900000)
// Program video control signals from ENCP core to DVI/HDMI interface
#define ENCP1_DVI_HSO_BEGIN ((0x2230 << 2) + 0xff900000)
#define ENCP1_DVI_HSO_END ((0x2231 << 2) + 0xff900000)
#define ENCP1_DVI_VSO_BLINE_EVN ((0x2232 << 2) + 0xff900000)
#define ENCP1_DVI_VSO_BLINE_ODD ((0x2233 << 2) + 0xff900000)
#define ENCP1_DVI_VSO_ELINE_EVN ((0x2234 << 2) + 0xff900000)
#define ENCP1_DVI_VSO_ELINE_ODD ((0x2235 << 2) + 0xff900000)
#define ENCP1_DVI_VSO_BEGIN_EVN ((0x2236 << 2) + 0xff900000)
#define ENCP1_DVI_VSO_BEGIN_ODD ((0x2237 << 2) + 0xff900000)
#define ENCP1_DVI_VSO_END_EVN ((0x2238 << 2) + 0xff900000)
#define ENCP1_DVI_VSO_END_ODD ((0x2239 << 2) + 0xff900000)
#define ENCP1_DE_H_BEGIN ((0x223a << 2) + 0xff900000)
#define ENCP1_DE_H_END ((0x223b << 2) + 0xff900000)
#define ENCP1_DE_V_BEGIN_EVEN ((0x223c << 2) + 0xff900000)
#define ENCP1_DE_V_END_EVEN ((0x223d << 2) + 0xff900000)
#define ENCP1_DE_V_BEGIN_ODD ((0x223e << 2) + 0xff900000)
#define ENCP1_DE_V_END_ODD ((0x223f << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCI1_SYNC_LINE_LENGTH ((0x2240 << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCI1_SYNC_PIXEL_EN ((0x2241 << 2) + 0xff900000)
// Bit 15 - ENCI1_sync_enable
// Bit 14 - ENCP1_sync_enable
// Bit 13 - ENCT1_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCI1_SYNC_TO_LINE_EN ((0x2242 << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define ENCI1_SYNC_TO_PIXEL ((0x2243 << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCP1_SYNC_LINE_LENGTH ((0x2244 << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCP1_SYNC_PIXEL_EN ((0x2245 << 2) + 0xff900000)
// Bit 15 - ENCI1_sync_enable
// Bit 14 - ENCP1_sync_enable
// Bit 13 - ENCT1_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCP1_SYNC_TO_LINE_EN ((0x2246 << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define ENCP1_SYNC_TO_PIXEL ((0x2247 << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCT1_SYNC_LINE_LENGTH ((0x2248 << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCT1_SYNC_PIXEL_EN ((0x2249 << 2) + 0xff900000)
// Bit 15 - ENCI1_sync_enable
// Bit 14 - ENCP1_sync_enable
// Bit 13 - ENCT1_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCT1_SYNC_TO_LINE_EN ((0x224a << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define ENCT1_SYNC_TO_PIXEL ((0x224b << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCL1_SYNC_LINE_LENGTH ((0x224c << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCL1_SYNC_PIXEL_EN ((0x224d << 2) + 0xff900000)
// Bit 15 - ENCI1_sync_enable
// Bit 14 - ENCP1_sync_enable
// Bit 13 - ENCT1_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCL1_SYNC_TO_LINE_EN ((0x224e << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define ENCL1_SYNC_TO_PIXEL ((0x224f << 2) + 0xff900000)
// bit    3 cfg_encp_lcd_scaler_bypass. 1=Do not scale LCD input data;
//                                      0=Scale LCD input data to y [16*4,235*4], c [16*4,240*4].
// bit    2 cfg_encp_vadj_scaler_bypass. 1=Do not scale data to enc480p_vadj;
//                                       0=Scale enc480p_vadj input data to y [16*4,235*4], c
//                                       [16*4,240*4].
// bit    1 cfg_vfifo2vd_out_scaler_bypass. 1=Do not scale vfifo2vd's output vdata;
//                                          0=Scale vfifo2vd's output vdata to y [16,235], c
//                                          [16,240].
// bit    0 cfg_vfifo_din_full_range. 1=Data from viu fifo is full range [0,1023];
//                                    0=Data from viu fifo is y [16*4,235*4], c [16*4,240*4].
#define ENCP1_VFIFO2VD_CTL2 ((0x2250 << 2) + 0xff900000)
// bit 15:1 Reserved.
// bit    0 cfg_int_dvi_sel_rgb. Applicable for using on-chip hdmi tx module only. This bit
// controls correct bit-mapping from
//          Venc to hdmi_tx depending on whether YCbCr or RGB mode.
//                               1=Map data bit from Venc to hdmi_tx for RGB mode;
//                               0=Default. Map data bit from Venc to hdmi_tx for YCbCr mode.
#define VENC1_DVI_SETTING_MORE ((0x2251 << 2) + 0xff900000)
#define VENC1_VDAC_DAC4_FILT_CTRL0 ((0x2254 << 2) + 0xff900000)
#define VENC1_VDAC_DAC4_FILT_CTRL1 ((0x2255 << 2) + 0xff900000)
#define VENC1_VDAC_DAC5_FILT_CTRL0 ((0x2256 << 2) + 0xff900000)
#define VENC1_VDAC_DAC5_FILT_CTRL1 ((0x2257 << 2) + 0xff900000)
// Bit 0   filter_en
#define VENC1_VDAC_DAC0_FILT_CTRL0 ((0x2258 << 2) + 0xff900000)
// dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
// Bit 15:8, coef1,
// Bit 7:0, coef0,
#define VENC1_VDAC_DAC0_FILT_CTRL1 ((0x2259 << 2) + 0xff900000)
// Bit 0   filter_en
#define VENC1_VDAC_DAC1_FILT_CTRL0 ((0x225a << 2) + 0xff900000)
// dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
// Bit 15:8, coef1,
// Bit 7:0, coef0,
#define VENC1_VDAC_DAC1_FILT_CTRL1 ((0x225b << 2) + 0xff900000)
// Bit 0   filter_en
#define VENC1_VDAC_DAC2_FILT_CTRL0 ((0x225c << 2) + 0xff900000)
// dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
// Bit 15:8, coef1,
// Bit 7:0, coef0,
#define VENC1_VDAC_DAC2_FILT_CTRL1 ((0x225d << 2) + 0xff900000)
// Bit 0   filter_en
#define VENC1_VDAC_DAC3_FILT_CTRL0 ((0x225e << 2) + 0xff900000)
// dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
// Bit 15:8, coef1,
// Bit 7:0, coef0,
#define VENC1_VDAC_DAC3_FILT_CTRL1 ((0x225f << 2) + 0xff900000)
//===========================================================================
// ENCT registers
#define ENCT1_VIDEO_EN ((0x2260 << 2) + 0xff900000)
#define ENCT1_VIDEO_Y_SCL ((0x2261 << 2) + 0xff900000)
#define ENCT1_VIDEO_PB_SCL ((0x2262 << 2) + 0xff900000)
#define ENCT1_VIDEO_PR_SCL ((0x2263 << 2) + 0xff900000)
#define ENCT1_VIDEO_Y_OFFST ((0x2264 << 2) + 0xff900000)
#define ENCT1_VIDEO_PB_OFFST ((0x2265 << 2) + 0xff900000)
#define ENCT1_VIDEO_PR_OFFST ((0x2266 << 2) + 0xff900000)
//----- Video mode
#define ENCT1_VIDEO_MODE ((0x2267 << 2) + 0xff900000)
#define ENCT1_VIDEO_MODE_ADV ((0x2268 << 2) + 0xff900000)
//--------------- Debug pins
#define ENCT1_DBG_PX_RST ((0x2269 << 2) + 0xff900000)
#define ENCT1_DBG_LN_RST ((0x226a << 2) + 0xff900000)
#define ENCT1_DBG_PX_INT ((0x226b << 2) + 0xff900000)
#define ENCT1_DBG_LN_INT ((0x226c << 2) + 0xff900000)
//----------- Video Advanced setting
#define ENCT1_VIDEO_YFP1_HTIME ((0x226d << 2) + 0xff900000)
#define ENCT1_VIDEO_YFP2_HTIME ((0x226e << 2) + 0xff900000)
#define ENCT1_VIDEO_YC_DLY ((0x226f << 2) + 0xff900000)
#define ENCT1_VIDEO_MAX_PXCNT ((0x2270 << 2) + 0xff900000)
#define ENCT1_VIDEO_HAVON_END ((0x2271 << 2) + 0xff900000)
#define ENCT1_VIDEO_HAVON_BEGIN ((0x2272 << 2) + 0xff900000)
#define ENCT1_VIDEO_VAVON_ELINE ((0x2273 << 2) + 0xff900000)
#define ENCT1_VIDEO_VAVON_BLINE ((0x2274 << 2) + 0xff900000)
#define ENCT1_VIDEO_HSO_BEGIN ((0x2275 << 2) + 0xff900000)
#define ENCT1_VIDEO_HSO_END ((0x2276 << 2) + 0xff900000)
#define ENCT1_VIDEO_VSO_BEGIN ((0x2277 << 2) + 0xff900000)
#define ENCT1_VIDEO_VSO_END ((0x2278 << 2) + 0xff900000)
#define ENCT1_VIDEO_VSO_BLINE ((0x2279 << 2) + 0xff900000)
#define ENCT1_VIDEO_VSO_ELINE ((0x227a << 2) + 0xff900000)
#define ENCT1_VIDEO_MAX_LNCNT ((0x227b << 2) + 0xff900000)
#define ENCT1_VIDEO_BLANKY_VAL ((0x227c << 2) + 0xff900000)
#define ENCT1_VIDEO_BLANKPB_VAL ((0x227d << 2) + 0xff900000)
#define ENCT1_VIDEO_BLANKPR_VAL ((0x227e << 2) + 0xff900000)
#define ENCT1_VIDEO_HOFFST ((0x227f << 2) + 0xff900000)
#define ENCT1_VIDEO_VOFFST ((0x2280 << 2) + 0xff900000)
#define ENCT1_VIDEO_RGB_CTRL ((0x2281 << 2) + 0xff900000)
#define ENCT1_VIDEO_FILT_CTRL ((0x2282 << 2) + 0xff900000)
#define ENCT1_VIDEO_OFLD_VPEQ_OFST ((0x2283 << 2) + 0xff900000)
#define ENCT1_VIDEO_OFLD_VOAV_OFST ((0x2284 << 2) + 0xff900000)
#define ENCT1_VIDEO_MATRIX_CB ((0x2285 << 2) + 0xff900000)
#define ENCT1_VIDEO_MATRIX_CR ((0x2286 << 2) + 0xff900000)
#define ENCT1_VIDEO_RGBIN_CTRL ((0x2287 << 2) + 0xff900000)
#define ENCT1_MAX_LINE_SWITCH_POINT ((0x2288 << 2) + 0xff900000)
#define ENCT1_DACSEL_0 ((0x2289 << 2) + 0xff900000)
#define ENCT1_DACSEL_1 ((0x228a << 2) + 0xff900000)
#define ENCT1_INBUF_CNTL0 ((0x228b << 2) + 0xff900000)
#define ENCT1_INBUF_CNTL1 ((0x228c << 2) + 0xff900000)
#define ENCT1_INBUF_CNT ((0x228d << 2) + 0xff900000)
#define ENCT1_INBUF_HOLD_CNT ((0x228e << 2) + 0xff900000)
#define ENCT1_INBUF_FIX_PIX_NUM ((0x228f << 2) + 0xff900000)
//===========================================================================
// For ENCL
//===========================================================================
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define ENCL1_VFIFO2VD_CTL ((0x2290 << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCL1_VFIFO2VD_PIXEL_START ((0x2291 << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCL1_VFIFO2VD_PIXEL_END ((0x2292 << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCL1_VFIFO2VD_LINE_TOP_START ((0x2293 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCL1_VFIFO2VD_LINE_TOP_END ((0x2294 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCL1_VFIFO2VD_LINE_BOT_START ((0x2295 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCL1_VFIFO2VD_LINE_BOT_END ((0x2296 << 2) + 0xff900000)
#define ENCL1_VFIFO2VD_CTL2 ((0x2297 << 2) + 0xff900000)
#define ENCL1_TST_EN ((0x2298 << 2) + 0xff900000)
#define ENCL1_TST_MDSEL ((0x2299 << 2) + 0xff900000)
#define ENCL1_TST_Y ((0x229a << 2) + 0xff900000)
#define ENCL1_TST_CB ((0x229b << 2) + 0xff900000)
#define ENCL1_TST_CR ((0x229c << 2) + 0xff900000)
#define ENCL1_TST_CLRBAR_STRT ((0x229d << 2) + 0xff900000)
#define ENCL1_TST_CLRBAR_WIDTH ((0x229e << 2) + 0xff900000)
#define ENCL1_TST_VDCNT_STSET ((0x229f << 2) + 0xff900000)
//===========================================================================
// ENCL1 registers
#define ENCL1_VIDEO_EN ((0x22a0 << 2) + 0xff900000)
#define ENCL1_VIDEO_Y_SCL ((0x22a1 << 2) + 0xff900000)
#define ENCL1_VIDEO_PB_SCL ((0x22a2 << 2) + 0xff900000)
#define ENCL1_VIDEO_PR_SCL ((0x22a3 << 2) + 0xff900000)
#define ENCL1_VIDEO_Y_OFFST ((0x22a4 << 2) + 0xff900000)
#define ENCL1_VIDEO_PB_OFFST ((0x22a5 << 2) + 0xff900000)
#define ENCL1_VIDEO_PR_OFFST ((0x22a6 << 2) + 0xff900000)
//----- Video mode
#define ENCL1_VIDEO_MODE ((0x22a7 << 2) + 0xff900000)
#define ENCL1_VIDEO_MODE_ADV ((0x22a8 << 2) + 0xff900000)
//--------------- Debug pins
#define ENCL1_DBG_PX_RST ((0x22a9 << 2) + 0xff900000)
#define ENCL1_DBG_LN_RST ((0x22aa << 2) + 0xff900000)
#define ENCL1_DBG_PX_INT ((0x22ab << 2) + 0xff900000)
#define ENCL1_DBG_LN_INT ((0x22ac << 2) + 0xff900000)
//----------- Video Advanced setting
#define ENCL1_VIDEO_YFP1_HTIME ((0x22ad << 2) + 0xff900000)
#define ENCL1_VIDEO_YFP2_HTIME ((0x22ae << 2) + 0xff900000)
#define ENCL1_VIDEO_YC_DLY ((0x22af << 2) + 0xff900000)
#define ENCL1_VIDEO_MAX_PXCNT ((0x22b0 << 2) + 0xff900000)
#define ENCL1_VIDEO_HAVON_END ((0x22b1 << 2) + 0xff900000)
#define ENCL1_VIDEO_HAVON_BEGIN ((0x22b2 << 2) + 0xff900000)
#define ENCL1_VIDEO_VAVON_ELINE ((0x22b3 << 2) + 0xff900000)
#define ENCL1_VIDEO_VAVON_BLINE ((0x22b4 << 2) + 0xff900000)
#define ENCL1_VIDEO_HSO_BEGIN ((0x22b5 << 2) + 0xff900000)
#define ENCL1_VIDEO_HSO_END ((0x22b6 << 2) + 0xff900000)
#define ENCL1_VIDEO_VSO_BEGIN ((0x22b7 << 2) + 0xff900000)
#define ENCL1_VIDEO_VSO_END ((0x22b8 << 2) + 0xff900000)
#define ENCL1_VIDEO_VSO_BLINE ((0x22b9 << 2) + 0xff900000)
#define ENCL1_VIDEO_VSO_ELINE ((0x22ba << 2) + 0xff900000)
#define ENCL1_VIDEO_MAX_LNCNT ((0x22bb << 2) + 0xff900000)
#define ENCL1_VIDEO_BLANKY_VAL ((0x22bc << 2) + 0xff900000)
#define ENCL1_VIDEO_BLANKPB_VAL ((0x22bd << 2) + 0xff900000)
#define ENCL1_VIDEO_BLANKPR_VAL ((0x22be << 2) + 0xff900000)
#define ENCL1_VIDEO_HOFFST ((0x22bf << 2) + 0xff900000)
#define ENCL1_VIDEO_VOFFST ((0x22c0 << 2) + 0xff900000)
#define ENCL1_VIDEO_RGB_CTRL ((0x22c1 << 2) + 0xff900000)
#define ENCL1_VIDEO_FILT_CTRL ((0x22c2 << 2) + 0xff900000)
#define ENCL1_VIDEO_OFLD_VPEQ_OFST ((0x22c3 << 2) + 0xff900000)
#define ENCL1_VIDEO_OFLD_VOAV_OFST ((0x22c4 << 2) + 0xff900000)
#define ENCL1_VIDEO_MATRIX_CB ((0x22c5 << 2) + 0xff900000)
#define ENCL1_VIDEO_MATRIX_CR ((0x22c6 << 2) + 0xff900000)
#define ENCL1_VIDEO_RGBIN_CTRL ((0x22c7 << 2) + 0xff900000)
#define ENCL1_MAX_LINE_SWITCH_POINT ((0x22c8 << 2) + 0xff900000)
#define ENCL1_DACSEL_0 ((0x22c9 << 2) + 0xff900000)
#define ENCL1_DACSEL_1 ((0x22ca << 2) + 0xff900000)
#define ENCT1_VIDEO_H_PRE_DE_END ((0x22cb << 2) + 0xff900000)
#define ENCT1_VIDEO_H_PRE_DE_BEGIN ((0x22cc << 2) + 0xff900000)
#define ENCT1_VIDEO_V_PRE_DE_ELINE ((0x22cd << 2) + 0xff900000)
#define ENCT1_VIDEO_V_PRE_DE_BLINE ((0x22ce << 2) + 0xff900000)
#define ENCL1_VIDEO_H_PRE_DE_END ((0x22cf << 2) + 0xff900000)
#define ENCL1_VIDEO_H_PRE_DE_BEGIN ((0x22d0 << 2) + 0xff900000)
#define ENCL1_VIDEO_V_PRE_DE_ELINE ((0x22d1 << 2) + 0xff900000)
#define ENCL1_VIDEO_V_PRE_DE_BLINE ((0x22d2 << 2) + 0xff900000)
#define ENCL1_INBUF_CNTL0 ((0x22d3 << 2) + 0xff900000)
#define ENCL1_INBUF_CNTL1 ((0x22d4 << 2) + 0xff900000)
#define ENCL1_INBUF_CNT ((0x22d5 << 2) + 0xff900000)
#define ENCL1_INBUF_HOLD_CNT ((0x22d6 << 2) + 0xff900000)
#define ENCL1_INBUF_FIX_PIX_NUM ((0x22d7 << 2) + 0xff900000)
#define VENC1_VRR_CTRL ((0x22d8 << 2) + 0xff900000)
// Bit   31    cfg_vsp_din      // W, pulse
// Bit   30    cfg_vrr_clr      // W, pulse
// Bit 31:28   ro_vrr_vsp_cnt   // R,
// Bit 27:24   ro_vrr_max_err   // R,
// Bit 23:8    cfg_vsp_dly_num  // R/W, unsigned, default 0
// Bit  7:4    cfg_vrr_frm_ths  // R/W, unsigned, default 0
// Bit  3:2    cfg_vrr_vsp_en   // R/W, unsigned, default 0
// Bit    1    cfg_vrr_mode     // R/W, unsigned, default 0
// Bit    0    cfg_vrr_vsp_sel  // R/W, unsigned, default 0
#define VENC1_VRR_ADJ_LMT ((0x22d9 << 2) + 0xff900000)
// Bit 31:16  cfg_vrr_min_vnum  //R/W, unsigned,
// Bit 15:0   cfg_vrr_max_vnum  //R/W, unsigned,
#define VENC1_VRR_CTRL1 ((0x22da << 2) + 0xff900000)
// Bit 4:1    cfg_vsp_rst_num   //R/W, unsigned, default 1
// Bit   0    cfg_vsp_cnt_rst   //W,pulse
#define VPU1_VPU_PWM_V0 ((0x22e0 << 2) + 0xff900000)
#define VPU1_VPU_PWM_V1 ((0x22e1 << 2) + 0xff900000)
#define VPU1_VPU_PWM_V2 ((0x22e2 << 2) + 0xff900000)
#define VPU1_VPU_PWM_V3 ((0x22e3 << 2) + 0xff900000)
#define VPU1_VPU_PWM_H0 ((0x22e4 << 2) + 0xff900000)
#define VPU1_VPU_PWM_H1 ((0x22e5 << 2) + 0xff900000)
#define VPU1_VPU_PWM_H2 ((0x22e6 << 2) + 0xff900000)
#define VPU1_VPU_PWM_H3 ((0x22e7 << 2) + 0xff900000)
#define VPU1_VPU_3D_SYNC1 ((0x22e8 << 2) + 0xff900000)
#define VPU1_VPU_3D_SYNC2 ((0x22e9 << 2) + 0xff900000)
#define VPU1_VENC_DUMMY ((0x22df << 2) + 0xff900000)
#define VPU1_VENC_ERROR ((0x22ea << 2) + 0xff900000)
#define VPU1_VENCI_STAT ((0x22eb << 2) + 0xff900000)
#define VPU1_VENCP_STAT ((0x22ec << 2) + 0xff900000)
#define VPU1_VENCL_STAT ((0x22ed << 2) + 0xff900000)
#define VPU1_VENC_DITH ((0x22ee << 2) + 0xff900000)
#define VPU1_VENC_CTRL ((0x22ef << 2) + 0xff900000)
#define VPU1_VENCL_DITH_CTRL ((0x22f0 << 2) + 0xff900000)
#define VPU1_VENCL_DITH_LUT_1 ((0x22f1 << 2) + 0xff900000)
#define VPU1_VENCL_DITH_LUT_2 ((0x22f2 << 2) + 0xff900000)
#define VPU1_VENCL_DITH_LUT_3 ((0x22f3 << 2) + 0xff900000)
#define VPU1_VENCL_DITH_LUT_4 ((0x22f4 << 2) + 0xff900000)
#define VPU1_VENCL_DITH_LUT_5 ((0x22f5 << 2) + 0xff900000)
#define VPU1_VENCL_DITH_LUT_6 ((0x22f6 << 2) + 0xff900000)
#define VPU1_VENCL_DITH_LUT_7 ((0x22f7 << 2) + 0xff900000)
#define VPU1_VENCL_DITH_LUT_8 ((0x22f8 << 2) + 0xff900000)
#define VPU1_VENCL_DITH_LUT_9 ((0x22f9 << 2) + 0xff900000)
#define VPU1_VENCL_DITH_LUT_10 ((0x22fa << 2) + 0xff900000)
#define VPU1_VENCL_DITH_LUT_11 ((0x22fb << 2) + 0xff900000)
#define VPU1_VENCL_DITH_LUT_12 ((0x22fc << 2) + 0xff900000)
//
// Closing file:  venc2_1_regs.h
//
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VENC2A_VCBUS_BASE = 0x23
// -----------------------------------------------
//===========================================================================
//
// Reading file:  venc_2_regs.h
//
//===========================================================================
// Video Interface Registers    0xa00 - 0xbff
//===========================================================================
//`define  VENC20A_VCBUS_BASE             8'h1b
// bit 15:8 -- vfifo2vd_vd_sel
// bit 0 -- vfifo2vd_en
#define ENCP2_VFIFO2VD_CTL ((0x2358 << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCP2_VFIFO2VD_PIXEL_START ((0x2359 << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCP2_VFIFO2VD_PIXEL_END ((0x235a << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCP2_VFIFO2VD_LINE_TOP_START ((0x235b << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCP2_VFIFO2VD_LINE_TOP_END ((0x235c << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCP2_VFIFO2VD_LINE_BOT_START ((0x235d << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCP2_VFIFO2VD_LINE_BOT_END ((0x235e << 2) + 0xff900000)
// Route the hsync and vsync signals round the chip. There are three
// sources and users of these signals: VIU, internal video encoder, and
// the pins on the chip. Some muxing is still being done in the VIU. It
// was not moved to the venc module so that the same exact VIU code could
// be used both in Twister and Twister2000.
// Bit 2: venc_sync_source (1=>pins, 0=>viu)
// Bit 1: viu_sync_source (1=>pins, 0=>venc)
// Bit 0: vpins_sync_source (1=>venc, 0=>viu)
#define VENC2_SYNC_ROUTE ((0x2360 << 2) + 0xff900000)
#define VENC2_VIDEO_EXSRC ((0x2361 << 2) + 0xff900000)
#define VENC2_DVI_SETTING ((0x2362 << 2) + 0xff900000)
#define VENC2_C656_CTRL ((0x2363 << 2) + 0xff900000)
#define VENC2_UPSAMPLE_CTRL0 ((0x2364 << 2) + 0xff900000)
#define VENC2_UPSAMPLE_CTRL1 ((0x2365 << 2) + 0xff900000)
#define VENC2_UPSAMPLE_CTRL2 ((0x2366 << 2) + 0xff900000)
// Invert control for tcon output
// bit[15:14] -- vsync, hsync,
// bit[13:0] --  oev3, oev2, cpv2, cph3, cph2, cph1, oeh, vcom, stv2, stv1, cpv1, oev1, sth1, sth2
#define TCON2_INVERT_CTL ((0x2367 << 2) + 0xff900000)
#define VENC2_VIDEO_PROG_MODE ((0x2368 << 2) + 0xff900000)
//---- Venc pixel/line info
#define VENC2_ENCI_LINE ((0x2369 << 2) + 0xff900000)
#define VENC2_ENCI_PIXEL ((0x236a << 2) + 0xff900000)
#define VENC2_ENCP_LINE ((0x236b << 2) + 0xff900000)
#define VENC2_ENCP_PIXEL ((0x236c << 2) + 0xff900000)
//---- Status
#define VENC2_STATA ((0x236d << 2) + 0xff900000)
//---- Interrupt setting
#define VENC2_INTCTRL ((0x236e << 2) + 0xff900000)
#define VENC2_INTFLAG ((0x236f << 2) + 0xff900000)
//--------- Video test configuration
#define VENC2_VIDEO_TST_EN ((0x2370 << 2) + 0xff900000)
#define VENC2_VIDEO_TST_MDSEL ((0x2371 << 2) + 0xff900000)
#define VENC2_VIDEO_TST_Y ((0x2372 << 2) + 0xff900000)
#define VENC2_VIDEO_TST_CB ((0x2373 << 2) + 0xff900000)
#define VENC2_VIDEO_TST_CR ((0x2374 << 2) + 0xff900000)
#define VENC2_VIDEO_TST_CLRBAR_STRT ((0x2375 << 2) + 0xff900000)
#define VENC2_VIDEO_TST_CLRBAR_WIDTH ((0x2376 << 2) + 0xff900000)
#define VENC2_VIDEO_TST_VDCNT_STSET ((0x2377 << 2) + 0xff900000)
//----- Video dac setting
#define VENC2_VDAC_DACSEL0 ((0x2378 << 2) + 0xff900000)
#define VENC2_VDAC_DACSEL1 ((0x2379 << 2) + 0xff900000)
#define VENC2_VDAC_DACSEL2 ((0x237a << 2) + 0xff900000)
#define VENC2_VDAC_DACSEL3 ((0x237b << 2) + 0xff900000)
#define VENC2_VDAC_DACSEL4 ((0x237c << 2) + 0xff900000)
#define VENC2_VDAC_DACSEL5 ((0x237d << 2) + 0xff900000)
#define VENC2_VDAC_SETTING ((0x237e << 2) + 0xff900000)
#define VENC2_VDAC_TST_VAL ((0x237f << 2) + 0xff900000)
#define VENC2_VDAC_DAC0_GAINCTRL ((0x23f0 << 2) + 0xff900000)
#define VENC2_VDAC_DAC0_OFFSET ((0x23f1 << 2) + 0xff900000)
#define VENC2_VDAC_DAC1_GAINCTRL ((0x23f2 << 2) + 0xff900000)
#define VENC2_VDAC_DAC1_OFFSET ((0x23f3 << 2) + 0xff900000)
#define VENC2_VDAC_DAC2_GAINCTRL ((0x23f4 << 2) + 0xff900000)
#define VENC2_VDAC_DAC2_OFFSET ((0x23f5 << 2) + 0xff900000)
#define VENC2_VDAC_DAC3_GAINCTRL ((0x23f6 << 2) + 0xff900000)
#define VENC2_VDAC_DAC3_OFFSET ((0x23f7 << 2) + 0xff900000)
#define VENC2_VDAC_DAC4_GAINCTRL ((0x23f8 << 2) + 0xff900000)
#define VENC2_VDAC_DAC4_OFFSET ((0x23f9 << 2) + 0xff900000)
#define VENC2_VDAC_DAC5_GAINCTRL ((0x23fa << 2) + 0xff900000)
#define VENC2_VDAC_DAC5_OFFSET ((0x23fb << 2) + 0xff900000)
#define VENC2_VDAC_FIFO_CTRL ((0x23fc << 2) + 0xff900000)
#define ENCL2_TCON_INVERT_CTL ((0x23fd << 2) + 0xff900000)
//
// Closing file:  venc_2_regs.h
//
//
// Reading file:  enc480p_2_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// Video Encoder 480p Registers    0xb80 - 0xbef
//===========================================================================
//-------- Video basic setting
#define ENCP2_VIDEO_EN ((0x2380 << 2) + 0xff900000)
#define ENCP2_VIDEO_SYNC_MODE ((0x2381 << 2) + 0xff900000)
#define ENCP2_MACV_EN ((0x2382 << 2) + 0xff900000)
#define ENCP2_VIDEO_Y_SCL ((0x2383 << 2) + 0xff900000)
#define ENCP2_VIDEO_PB_SCL ((0x2384 << 2) + 0xff900000)
#define ENCP2_VIDEO_PR_SCL ((0x2385 << 2) + 0xff900000)
#define ENCP2_VIDEO_SYNC_SCL ((0x2386 << 2) + 0xff900000)
#define ENCP2_VIDEO_MACV_SCL ((0x2387 << 2) + 0xff900000)
#define ENCP2_VIDEO_Y_OFFST ((0x2388 << 2) + 0xff900000)
#define ENCP2_VIDEO_PB_OFFST ((0x2389 << 2) + 0xff900000)
#define ENCP2_VIDEO_PR_OFFST ((0x238a << 2) + 0xff900000)
#define ENCP2_VIDEO_SYNC_OFFST ((0x238b << 2) + 0xff900000)
#define ENCP2_VIDEO_MACV_OFFST ((0x238c << 2) + 0xff900000)
//----- Video mode
#define ENCP2_VIDEO_MODE ((0x238d << 2) + 0xff900000)
#define ENCP2_VIDEO_MODE_ADV ((0x238e << 2) + 0xff900000)
//--------------- Debug pins
#define ENCP2_DBG_PX_RST ((0x2390 << 2) + 0xff900000)
#define ENCP2_DBG_LN_RST ((0x2391 << 2) + 0xff900000)
#define ENCP2_DBG_PX_INT ((0x2392 << 2) + 0xff900000)
#define ENCP2_DBG_LN_INT ((0x2393 << 2) + 0xff900000)
//----------- Video Advanced setting
#define ENCP2_VIDEO_YFP1_HTIME ((0x2394 << 2) + 0xff900000)
#define ENCP2_VIDEO_YFP2_HTIME ((0x2395 << 2) + 0xff900000)
#define ENCP2_VIDEO_YC_DLY ((0x2396 << 2) + 0xff900000)
#define ENCP2_VIDEO_MAX_PXCNT ((0x2397 << 2) + 0xff900000)
#define ENCP2_VIDEO_HSPULS_BEGIN ((0x2398 << 2) + 0xff900000)
#define ENCP2_VIDEO_HSPULS_END ((0x2399 << 2) + 0xff900000)
#define ENCP2_VIDEO_HSPULS_SWITCH ((0x239a << 2) + 0xff900000)
#define ENCP2_VIDEO_VSPULS_BEGIN ((0x239b << 2) + 0xff900000)
#define ENCP2_VIDEO_VSPULS_END ((0x239c << 2) + 0xff900000)
#define ENCP2_VIDEO_VSPULS_BLINE ((0x239d << 2) + 0xff900000)
#define ENCP2_VIDEO_VSPULS_ELINE ((0x239e << 2) + 0xff900000)
#define ENCP2_VIDEO_EQPULS_BEGIN ((0x239f << 2) + 0xff900000)
#define ENCP2_VIDEO_EQPULS_END ((0x23a0 << 2) + 0xff900000)
#define ENCP2_VIDEO_EQPULS_BLINE ((0x23a1 << 2) + 0xff900000)
#define ENCP2_VIDEO_EQPULS_ELINE ((0x23a2 << 2) + 0xff900000)
#define ENCP2_VIDEO_HAVON_END ((0x23a3 << 2) + 0xff900000)
#define ENCP2_VIDEO_HAVON_BEGIN ((0x23a4 << 2) + 0xff900000)
#define ENCP2_VIDEO_VAVON_ELINE ((0x23af << 2) + 0xff900000)
#define ENCP2_VIDEO_VAVON_BLINE ((0x23a6 << 2) + 0xff900000)
#define ENCP2_VIDEO_HSO_BEGIN ((0x23a7 << 2) + 0xff900000)
#define ENCP2_VIDEO_HSO_END ((0x23a8 << 2) + 0xff900000)
#define ENCP2_VIDEO_VSO_BEGIN ((0x23a9 << 2) + 0xff900000)
#define ENCP2_VIDEO_VSO_END ((0x23aa << 2) + 0xff900000)
#define ENCP2_VIDEO_VSO_BLINE ((0x23ab << 2) + 0xff900000)
#define ENCP2_VIDEO_VSO_ELINE ((0x23ac << 2) + 0xff900000)
#define ENCP2_VIDEO_SYNC_WAVE_CURVE ((0x23ad << 2) + 0xff900000)
#define ENCP2_VIDEO_MAX_LNCNT ((0x23ae << 2) + 0xff900000)
#define ENCP2_VIDEO_SY_VAL ((0x23b0 << 2) + 0xff900000)
#define ENCP2_VIDEO_SY2_VAL ((0x23b1 << 2) + 0xff900000)
#define ENCP2_VIDEO_BLANKY_VAL ((0x23b2 << 2) + 0xff900000)
#define ENCP2_VIDEO_BLANKPB_VAL ((0x23b3 << 2) + 0xff900000)
#define ENCP2_VIDEO_BLANKPR_VAL ((0x23b4 << 2) + 0xff900000)
#define ENCP2_VIDEO_HOFFST ((0x23b5 << 2) + 0xff900000)
#define ENCP2_VIDEO_VOFFST ((0x23b6 << 2) + 0xff900000)
#define ENCP2_VIDEO_RGB_CTRL ((0x23b7 << 2) + 0xff900000)
#define ENCP2_VIDEO_FILT_CTRL ((0x23b8 << 2) + 0xff900000)
#define ENCP2_VIDEO_OFLD_VPEQ_OFST ((0x23b9 << 2) + 0xff900000)
#define ENCP2_VIDEO_OFLD_VOAV_OFST ((0x23ba << 2) + 0xff900000)
#define ENCP2_VIDEO_MATRIX_CB ((0x23bb << 2) + 0xff900000)
#define ENCP2_VIDEO_MATRIX_CR ((0x23bc << 2) + 0xff900000)
#define ENCP2_VIDEO_RGBIN_CTRL ((0x23bd << 2) + 0xff900000)
//------------------Macrovision advanced setting
#define ENCP2_MACV_BLANKY_VAL ((0x23c0 << 2) + 0xff900000)
#define ENCP2_MACV_MAXY_VAL ((0x23c1 << 2) + 0xff900000)
#define ENCP2_MACV_1ST_PSSYNC_STRT ((0x23c2 << 2) + 0xff900000)
#define ENCP2_MACV_PSSYNC_STRT ((0x23c3 << 2) + 0xff900000)
#define ENCP2_MACV_AGC_STRT ((0x23c4 << 2) + 0xff900000)
#define ENCP2_MACV_AGC_END ((0x23c5 << 2) + 0xff900000)
#define ENCP2_MACV_WAVE_END ((0x23c6 << 2) + 0xff900000)
#define ENCP2_MACV_STRTLINE ((0x23c7 << 2) + 0xff900000)
#define ENCP2_MACV_ENDLINE ((0x23c8 << 2) + 0xff900000)
#define ENCP2_MACV_TS_CNT_MAX_L ((0x23c9 << 2) + 0xff900000)
#define ENCP2_MACV_TS_CNT_MAX_H ((0x23ca << 2) + 0xff900000)
#define ENCP2_MACV_TIME_DOWN ((0x23cb << 2) + 0xff900000)
#define ENCP2_MACV_TIME_LO ((0x23cc << 2) + 0xff900000)
#define ENCP2_MACV_TIME_UP ((0x23cd << 2) + 0xff900000)
#define ENCP2_MACV_TIME_RST ((0x23ce << 2) + 0xff900000)
//---------------- VBI control -------------------
#define ENCP2_VBI_CTRL ((0x23d0 << 2) + 0xff900000)
#define ENCP2_VBI_SETTING ((0x23d1 << 2) + 0xff900000)
#define ENCP2_VBI_BEGIN ((0x23d2 << 2) + 0xff900000)
#define ENCP2_VBI_WIDTH ((0x23d3 << 2) + 0xff900000)
#define ENCP2_VBI_HVAL ((0x23d4 << 2) + 0xff900000)
#define ENCP2_VBI_DATA0 ((0x23d5 << 2) + 0xff900000)
#define ENCP2_VBI_DATA1 ((0x23d6 << 2) + 0xff900000)
//----------------C656 OUT Control------------- Grant
#define C656_HS_ST_2 ((0x23e0 << 2) + 0xff900000)
#define C656_HS_ED_2 ((0x23e1 << 2) + 0xff900000)
#define C656_VS_LNST_E_2 ((0x23e2 << 2) + 0xff900000)
#define C656_VS_LNST_O_2 ((0x23e3 << 2) + 0xff900000)
#define C656_VS_LNED_E_2 ((0x23e4 << 2) + 0xff900000)
#define C656_VS_LNED_O_2 ((0x23e5 << 2) + 0xff900000)
#define C656_FS_LNST_2 ((0x23e6 << 2) + 0xff900000)
#define C656_FS_LNED_2 ((0x23e7 << 2) + 0xff900000)
#define ENCP2_VRR_CTRL ((0x23e8 << 2) + 0xff900000)
#define ENCP2_VRR_ADJ_LMT ((0x23e9 << 2) + 0xff900000)
#define ENCP2_VRR_CTRL1 ((0x23ea << 2) + 0xff900000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  enc480p_2_regs.h
//
//
// Reading file:  enci_2_regs.h
//
//===========================================================================
// Video Interface Registers    0xb00 - 0xb57
//===========================================================================
#define ENCI2_VIDEO_MODE ((0x2300 << 2) + 0xff900000)
#define ENCI2_VIDEO_MODE_ADV ((0x2301 << 2) + 0xff900000)
#define ENCI2_VIDEO_FSC_ADJ ((0x2302 << 2) + 0xff900000)
#define ENCI2_VIDEO_BRIGHT ((0x2303 << 2) + 0xff900000)
#define ENCI2_VIDEO_CONT ((0x2304 << 2) + 0xff900000)
#define ENCI2_VIDEO_SAT ((0x2305 << 2) + 0xff900000)
#define ENCI2_VIDEO_HUE ((0x2306 << 2) + 0xff900000)
#define ENCI2_VIDEO_SCH ((0x2307 << 2) + 0xff900000)
#define ENCI2_SYNC_MODE ((0x2308 << 2) + 0xff900000)
#define ENCI2_SYNC_CTRL ((0x2309 << 2) + 0xff900000)
#define ENCI2_SYNC_HSO_BEGIN ((0x230a << 2) + 0xff900000)
#define ENCI2_SYNC_HSO_END ((0x230b << 2) + 0xff900000)
#define ENCI2_SYNC_VSO_EVN ((0x230c << 2) + 0xff900000)
#define ENCI2_SYNC_VSO_ODD ((0x230d << 2) + 0xff900000)
#define ENCI2_SYNC_VSO_EVNLN ((0x230e << 2) + 0xff900000)
#define ENCI2_SYNC_VSO_ODDLN ((0x230f << 2) + 0xff900000)
#define ENCI2_SYNC_HOFFST ((0x2310 << 2) + 0xff900000)
#define ENCI2_SYNC_VOFFST ((0x2311 << 2) + 0xff900000)
#define ENCI2_SYNC_ADJ ((0x2312 << 2) + 0xff900000)
#define ENCI2_RGB_SETTING ((0x2313 << 2) + 0xff900000)
//`define    ENCI2_CMPN_MATRIX_CB        8'h14
//`define    ENCI2_CMPN_MATRIX_CR        8'h15
#define ENCI2_DE_H_BEGIN ((0x2316 << 2) + 0xff900000)
#define ENCI2_DE_H_END ((0x2317 << 2) + 0xff900000)
#define ENCI2_DE_V_BEGIN_EVEN ((0x2318 << 2) + 0xff900000)
#define ENCI2_DE_V_END_EVEN ((0x2319 << 2) + 0xff900000)
#define ENCI2_DE_V_BEGIN_ODD ((0x231a << 2) + 0xff900000)
#define ENCI2_DE_V_END_ODD ((0x231b << 2) + 0xff900000)
#define ENCI2_VBI_SETTING ((0x2320 << 2) + 0xff900000)
#define ENCI2_VBI_CCDT_EVN ((0x2321 << 2) + 0xff900000)
#define ENCI2_VBI_CCDT_ODD ((0x2322 << 2) + 0xff900000)
#define ENCI2_VBI_CC525_LN ((0x2323 << 2) + 0xff900000)
#define ENCI2_VBI_CC625_LN ((0x2324 << 2) + 0xff900000)
#define ENCI2_VBI_WSSDT ((0x2325 << 2) + 0xff900000)
#define ENCI2_VBI_WSS_LN ((0x2326 << 2) + 0xff900000)
#define ENCI2_VBI_CGMSDT_L ((0x2327 << 2) + 0xff900000)
#define ENCI2_VBI_CGMSDT_H ((0x2328 << 2) + 0xff900000)
#define ENCI2_VBI_CGMS_LN ((0x2329 << 2) + 0xff900000)
#define ENCI2_VBI_TTX_HTIME ((0x232a << 2) + 0xff900000)
#define ENCI2_VBI_TTX_LN ((0x232b << 2) + 0xff900000)
#define ENCI2_VBI_TTXDT0 ((0x232c << 2) + 0xff900000)
#define ENCI2_VBI_TTXDT1 ((0x232d << 2) + 0xff900000)
#define ENCI2_VBI_TTXDT2 ((0x232e << 2) + 0xff900000)
#define ENCI2_VBI_TTXDT3 ((0x232f << 2) + 0xff900000)
#define ENCI2_MACV_N0 ((0x2330 << 2) + 0xff900000)
#define ENCI2_MACV_N1 ((0x2331 << 2) + 0xff900000)
#define ENCI2_MACV_N2 ((0x2332 << 2) + 0xff900000)
#define ENCI2_MACV_N3 ((0x2333 << 2) + 0xff900000)
#define ENCI2_MACV_N4 ((0x2334 << 2) + 0xff900000)
#define ENCI2_MACV_N5 ((0x2335 << 2) + 0xff900000)
#define ENCI2_MACV_N6 ((0x2336 << 2) + 0xff900000)
#define ENCI2_MACV_N7 ((0x2337 << 2) + 0xff900000)
#define ENCI2_MACV_N8 ((0x2338 << 2) + 0xff900000)
#define ENCI2_MACV_N9 ((0x2339 << 2) + 0xff900000)
#define ENCI2_MACV_N10 ((0x233a << 2) + 0xff900000)
#define ENCI2_MACV_N11 ((0x233b << 2) + 0xff900000)
#define ENCI2_MACV_N12 ((0x233c << 2) + 0xff900000)
#define ENCI2_MACV_N13 ((0x233d << 2) + 0xff900000)
#define ENCI2_MACV_N14 ((0x233e << 2) + 0xff900000)
#define ENCI2_MACV_N15 ((0x233f << 2) + 0xff900000)
#define ENCI2_MACV_N16 ((0x2340 << 2) + 0xff900000)
#define ENCI2_MACV_N17 ((0x2341 << 2) + 0xff900000)
#define ENCI2_MACV_N18 ((0x2342 << 2) + 0xff900000)
#define ENCI2_MACV_N19 ((0x2343 << 2) + 0xff900000)
#define ENCI2_MACV_N20 ((0x2344 << 2) + 0xff900000)
#define ENCI2_MACV_N21 ((0x2345 << 2) + 0xff900000)
#define ENCI2_MACV_N22 ((0x2346 << 2) + 0xff900000)
//`define    ENCI2_MACV_P_AGC            8'h47
#define ENCI2_DBG_PX_RST ((0x2348 << 2) + 0xff900000)
#define ENCI2_DBG_FLDLN_RST ((0x2349 << 2) + 0xff900000)
#define ENCI2_DBG_PX_INT ((0x234a << 2) + 0xff900000)
#define ENCI2_DBG_FLDLN_INT ((0x234b << 2) + 0xff900000)
#define ENCI2_DBG_MAXPX ((0x234c << 2) + 0xff900000)
#define ENCI2_DBG_MAXLN ((0x234d << 2) + 0xff900000)
#define ENCI2_MACV_MAX_AMP ((0x2350 << 2) + 0xff900000)
#define ENCI2_MACV_PULSE_LO ((0x2351 << 2) + 0xff900000)
#define ENCI2_MACV_PULSE_HI ((0x2352 << 2) + 0xff900000)
#define ENCI2_MACV_BKP_MAX ((0x2353 << 2) + 0xff900000)
#define ENCI2_CFILT_CTRL ((0x2354 << 2) + 0xff900000)
#define ENCI2_CFILT7 ((0x2355 << 2) + 0xff900000)
#define ENCI2_YC_DELAY ((0x2356 << 2) + 0xff900000)
#define ENCI2_VIDEO_EN ((0x2357 << 2) + 0xff900000)
//
// Closing file:  enci_2_regs.h
//
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VENC2B_VCBUS_BASE = 0x24
// -----------------------------------------------
//===========================================================================
//
// Reading file:  venc2_2_regs.h
//
//===========================================================================
// Venc Registers (Cont.)    0xc00 - 0xcff (VENC registers 0xc00 - 0xcef)
//===========================================================================
//`define  VENC0B_VCBUS_BASE            8'h1c
//`define  VENC2B_VCBUS_BASE            8'h22
//`define  VENC2B_VCBUS_BASE            8'h24
// Program video control signals from ENCI core to DVI/HDMI interface
#define ENCI2_DVI_HSO_BEGIN ((0x2400 << 2) + 0xff900000)
#define ENCI2_DVI_HSO_END ((0x2401 << 2) + 0xff900000)
#define ENCI2_DVI_VSO_BLINE_EVN ((0x2402 << 2) + 0xff900000)
#define ENCI2_DVI_VSO_BLINE_ODD ((0x2403 << 2) + 0xff900000)
#define ENCI2_DVI_VSO_ELINE_EVN ((0x2404 << 2) + 0xff900000)
#define ENCI2_DVI_VSO_ELINE_ODD ((0x2405 << 2) + 0xff900000)
#define ENCI2_DVI_VSO_BEGIN_EVN ((0x2406 << 2) + 0xff900000)
#define ENCI2_DVI_VSO_BEGIN_ODD ((0x2407 << 2) + 0xff900000)
#define ENCI2_DVI_VSO_END_EVN ((0x2408 << 2) + 0xff900000)
#define ENCI2_DVI_VSO_END_ODD ((0x2409 << 2) + 0xff900000)
// Define cmpt and cvbs cb/cr delay after ENCI chroma filters
// Bit 15:12 RW, enci_cb_cvbs_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit 11: 8 RW, enci_cr_cvbs_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit  7: 4 RW, enci_cb_cmpt_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit  3: 0 RW, enci_cr_cmpt_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
#define ENCI2_CFILT_CTRL2 ((0x240a << 2) + 0xff900000)
#define ENCI2_DACSEL_0 ((0x240b << 2) + 0xff900000)
#define ENCI2_DACSEL_1 ((0x240c << 2) + 0xff900000)
#define ENCP2_DACSEL_0 ((0x240d << 2) + 0xff900000)
#define ENCP2_DACSEL_1 ((0x240e << 2) + 0xff900000)
#define ENCP2_MAX_LINE_SWITCH_POINT ((0x240f << 2) + 0xff900000)
#define ENCI2_TST_EN ((0x2410 << 2) + 0xff900000)
#define ENCI2_TST_MDSEL ((0x2411 << 2) + 0xff900000)
#define ENCI2_TST_Y ((0x2412 << 2) + 0xff900000)
#define ENCI2_TST_CB ((0x2413 << 2) + 0xff900000)
#define ENCI2_TST_CR ((0x2414 << 2) + 0xff900000)
#define ENCI2_TST_CLRBAR_STRT ((0x2415 << 2) + 0xff900000)
#define ENCI2_TST_CLRBAR_WIDTH ((0x2416 << 2) + 0xff900000)
#define ENCI2_TST_VDCNT_STSET ((0x2417 << 2) + 0xff900000)
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define ENCI2_VFIFO2VD_CTL ((0x2418 << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCI2_VFIFO2VD_PIXEL_START ((0x2419 << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCI2_VFIFO2VD_PIXEL_END ((0x241a << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCI2_VFIFO2VD_LINE_TOP_START ((0x241b << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCI2_VFIFO2VD_LINE_TOP_END ((0x241c << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCI2_VFIFO2VD_LINE_BOT_START ((0x241d << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCI2_VFIFO2VD_LINE_BOT_END ((0x241e << 2) + 0xff900000)
#define ENCI2_VFIFO2VD_CTL2 ((0x241f << 2) + 0xff900000)
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define ENCT2_VFIFO2VD_CTL ((0x2420 << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCT2_VFIFO2VD_PIXEL_START ((0x2421 << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCT2_VFIFO2VD_PIXEL_END ((0x2422 << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCT2_VFIFO2VD_LINE_TOP_START ((0x2423 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCT2_VFIFO2VD_LINE_TOP_END ((0x2424 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCT2_VFIFO2VD_LINE_BOT_START ((0x2425 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCT2_VFIFO2VD_LINE_BOT_END ((0x2426 << 2) + 0xff900000)
#define ENCT2_VFIFO2VD_CTL2 ((0x2427 << 2) + 0xff900000)
#define ENCT2_TST_EN ((0x2428 << 2) + 0xff900000)
#define ENCT2_TST_MDSEL ((0x2429 << 2) + 0xff900000)
#define ENCT2_TST_Y ((0x242a << 2) + 0xff900000)
#define ENCT2_TST_CB ((0x242b << 2) + 0xff900000)
#define ENCT2_TST_CR ((0x242c << 2) + 0xff900000)
#define ENCT2_TST_CLRBAR_STRT ((0x242d << 2) + 0xff900000)
#define ENCT2_TST_CLRBAR_WIDTH ((0x242e << 2) + 0xff900000)
#define ENCT2_TST_VDCNT_STSET ((0x242f << 2) + 0xff900000)
// Program video control signals from ENCP core to DVI/HDMI interface
#define ENCP2_DVI_HSO_BEGIN ((0x2430 << 2) + 0xff900000)
#define ENCP2_DVI_HSO_END ((0x2431 << 2) + 0xff900000)
#define ENCP2_DVI_VSO_BLINE_EVN ((0x2432 << 2) + 0xff900000)
#define ENCP2_DVI_VSO_BLINE_ODD ((0x2433 << 2) + 0xff900000)
#define ENCP2_DVI_VSO_ELINE_EVN ((0x2434 << 2) + 0xff900000)
#define ENCP2_DVI_VSO_ELINE_ODD ((0x2435 << 2) + 0xff900000)
#define ENCP2_DVI_VSO_BEGIN_EVN ((0x2436 << 2) + 0xff900000)
#define ENCP2_DVI_VSO_BEGIN_ODD ((0x2437 << 2) + 0xff900000)
#define ENCP2_DVI_VSO_END_EVN ((0x2438 << 2) + 0xff900000)
#define ENCP2_DVI_VSO_END_ODD ((0x2439 << 2) + 0xff900000)
#define ENCP2_DE_H_BEGIN ((0x243a << 2) + 0xff900000)
#define ENCP2_DE_H_END ((0x243b << 2) + 0xff900000)
#define ENCP2_DE_V_BEGIN_EVEN ((0x243c << 2) + 0xff900000)
#define ENCP2_DE_V_END_EVEN ((0x243d << 2) + 0xff900000)
#define ENCP2_DE_V_BEGIN_ODD ((0x243e << 2) + 0xff900000)
#define ENCP2_DE_V_END_ODD ((0x243f << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCI2_SYNC_LINE_LENGTH ((0x2440 << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCI2_SYNC_PIXEL_EN ((0x2441 << 2) + 0xff900000)
// Bit 15 - ENCI2_sync_enable
// Bit 14 - ENCP2_sync_enable
// Bit 13 - ENCT2_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCI2_SYNC_TO_LINE_EN ((0x2442 << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define ENCI2_SYNC_TO_PIXEL ((0x2443 << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCP2_SYNC_LINE_LENGTH ((0x2444 << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCP2_SYNC_PIXEL_EN ((0x2445 << 2) + 0xff900000)
// Bit 15 - ENCI2_sync_enable
// Bit 14 - ENCP2_sync_enable
// Bit 13 - ENCT2_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCP2_SYNC_TO_LINE_EN ((0x2446 << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define ENCP2_SYNC_TO_PIXEL ((0x2447 << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCT2_SYNC_LINE_LENGTH ((0x2448 << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCT2_SYNC_PIXEL_EN ((0x2449 << 2) + 0xff900000)
// Bit 15 - ENCI2_sync_enable
// Bit 14 - ENCP2_sync_enable
// Bit 13 - ENCT2_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCT2_SYNC_TO_LINE_EN ((0x244a << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define ENCT2_SYNC_TO_PIXEL ((0x244b << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCL2_SYNC_LINE_LENGTH ((0x244c << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCL2_SYNC_PIXEL_EN ((0x244d << 2) + 0xff900000)
// Bit 15 - ENCI2_sync_enable
// Bit 14 - ENCP2_sync_enable
// Bit 13 - ENCT2_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCL2_SYNC_TO_LINE_EN ((0x244e << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define ENCL2_SYNC_TO_PIXEL ((0x244f << 2) + 0xff900000)
// bit    3 cfg_encp_lcd_scaler_bypass. 1=Do not scale LCD input data;
//                                      0=Scale LCD input data to y [16*4,235*4], c [16*4,240*4].
// bit    2 cfg_encp_vadj_scaler_bypass. 1=Do not scale data to enc480p_vadj;
//                                       0=Scale enc480p_vadj input data to y [16*4,235*4], c
//                                       [16*4,240*4].
// bit    1 cfg_vfifo2vd_out_scaler_bypass. 1=Do not scale vfifo2vd's output vdata;
//                                          0=Scale vfifo2vd's output vdata to y [16,235], c
//                                          [16,240].
// bit    0 cfg_vfifo_din_full_range. 1=Data from viu fifo is full range [0,1023];
//                                    0=Data from viu fifo is y [16*4,235*4], c [16*4,240*4].
#define ENCP2_VFIFO2VD_CTL2 ((0x2450 << 2) + 0xff900000)
// bit 15:1 Reserved.
// bit    0 cfg_int_dvi_sel_rgb. Applicable for using on-chip hdmi tx module only. This bit
// controls correct bit-mapping from
//          Venc to hdmi_tx depending on whether YCbCr or RGB mode.
//                               1=Map data bit from Venc to hdmi_tx for RGB mode;
//                               0=Default. Map data bit from Venc to hdmi_tx for YCbCr mode.
#define VENC2_DVI_SETTING_MORE ((0x2451 << 2) + 0xff900000)
#define VENC2_VDAC_DAC4_FILT_CTRL0 ((0x2454 << 2) + 0xff900000)
#define VENC2_VDAC_DAC4_FILT_CTRL1 ((0x2455 << 2) + 0xff900000)
#define VENC2_VDAC_DAC5_FILT_CTRL0 ((0x2456 << 2) + 0xff900000)
#define VENC2_VDAC_DAC5_FILT_CTRL1 ((0x2457 << 2) + 0xff900000)
// Bit 0   filter_en
#define VENC2_VDAC_DAC0_FILT_CTRL0 ((0x2458 << 2) + 0xff900000)
// dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
// Bit 15:8, coef1,
// Bit 7:0, coef0,
#define VENC2_VDAC_DAC0_FILT_CTRL1 ((0x2459 << 2) + 0xff900000)
// Bit 0   filter_en
#define VENC2_VDAC_DAC1_FILT_CTRL0 ((0x245a << 2) + 0xff900000)
// dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
// Bit 15:8, coef1,
// Bit 7:0, coef0,
#define VENC2_VDAC_DAC1_FILT_CTRL1 ((0x245b << 2) + 0xff900000)
// Bit 0   filter_en
#define VENC2_VDAC_DAC2_FILT_CTRL0 ((0x245c << 2) + 0xff900000)
// dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
// Bit 15:8, coef1,
// Bit 7:0, coef0,
#define VENC2_VDAC_DAC2_FILT_CTRL1 ((0x245d << 2) + 0xff900000)
// Bit 0   filter_en
#define VENC2_VDAC_DAC3_FILT_CTRL0 ((0x245e << 2) + 0xff900000)
// dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
// Bit 15:8, coef1,
// Bit 7:0, coef0,
#define VENC2_VDAC_DAC3_FILT_CTRL1 ((0x245f << 2) + 0xff900000)
//===========================================================================
// ENCT registers
#define ENCT2_VIDEO_EN ((0x2460 << 2) + 0xff900000)
#define ENCT2_VIDEO_Y_SCL ((0x2461 << 2) + 0xff900000)
#define ENCT2_VIDEO_PB_SCL ((0x2462 << 2) + 0xff900000)
#define ENCT2_VIDEO_PR_SCL ((0x2463 << 2) + 0xff900000)
#define ENCT2_VIDEO_Y_OFFST ((0x2464 << 2) + 0xff900000)
#define ENCT2_VIDEO_PB_OFFST ((0x2465 << 2) + 0xff900000)
#define ENCT2_VIDEO_PR_OFFST ((0x2466 << 2) + 0xff900000)
//----- Video mode
#define ENCT2_VIDEO_MODE ((0x2467 << 2) + 0xff900000)
#define ENCT2_VIDEO_MODE_ADV ((0x2468 << 2) + 0xff900000)
//--------------- Debug pins
#define ENCT2_DBG_PX_RST ((0x2469 << 2) + 0xff900000)
#define ENCT2_DBG_LN_RST ((0x246a << 2) + 0xff900000)
#define ENCT2_DBG_PX_INT ((0x246b << 2) + 0xff900000)
#define ENCT2_DBG_LN_INT ((0x246c << 2) + 0xff900000)
//----------- Video Advanced setting
#define ENCT2_VIDEO_YFP1_HTIME ((0x246d << 2) + 0xff900000)
#define ENCT2_VIDEO_YFP2_HTIME ((0x246e << 2) + 0xff900000)
#define ENCT2_VIDEO_YC_DLY ((0x246f << 2) + 0xff900000)
#define ENCT2_VIDEO_MAX_PXCNT ((0x2470 << 2) + 0xff900000)
#define ENCT2_VIDEO_HAVON_END ((0x2471 << 2) + 0xff900000)
#define ENCT2_VIDEO_HAVON_BEGIN ((0x2472 << 2) + 0xff900000)
#define ENCT2_VIDEO_VAVON_ELINE ((0x2473 << 2) + 0xff900000)
#define ENCT2_VIDEO_VAVON_BLINE ((0x2474 << 2) + 0xff900000)
#define ENCT2_VIDEO_HSO_BEGIN ((0x2475 << 2) + 0xff900000)
#define ENCT2_VIDEO_HSO_END ((0x2476 << 2) + 0xff900000)
#define ENCT2_VIDEO_VSO_BEGIN ((0x2477 << 2) + 0xff900000)
#define ENCT2_VIDEO_VSO_END ((0x2478 << 2) + 0xff900000)
#define ENCT2_VIDEO_VSO_BLINE ((0x2479 << 2) + 0xff900000)
#define ENCT2_VIDEO_VSO_ELINE ((0x247a << 2) + 0xff900000)
#define ENCT2_VIDEO_MAX_LNCNT ((0x247b << 2) + 0xff900000)
#define ENCT2_VIDEO_BLANKY_VAL ((0x247c << 2) + 0xff900000)
#define ENCT2_VIDEO_BLANKPB_VAL ((0x247d << 2) + 0xff900000)
#define ENCT2_VIDEO_BLANKPR_VAL ((0x247e << 2) + 0xff900000)
#define ENCT2_VIDEO_HOFFST ((0x247f << 2) + 0xff900000)
#define ENCT2_VIDEO_VOFFST ((0x2480 << 2) + 0xff900000)
#define ENCT2_VIDEO_RGB_CTRL ((0x2481 << 2) + 0xff900000)
#define ENCT2_VIDEO_FILT_CTRL ((0x2482 << 2) + 0xff900000)
#define ENCT2_VIDEO_OFLD_VPEQ_OFST ((0x2483 << 2) + 0xff900000)
#define ENCT2_VIDEO_OFLD_VOAV_OFST ((0x2484 << 2) + 0xff900000)
#define ENCT2_VIDEO_MATRIX_CB ((0x2485 << 2) + 0xff900000)
#define ENCT2_VIDEO_MATRIX_CR ((0x2486 << 2) + 0xff900000)
#define ENCT2_VIDEO_RGBIN_CTRL ((0x2487 << 2) + 0xff900000)
#define ENCT2_MAX_LINE_SWITCH_POINT ((0x2488 << 2) + 0xff900000)
#define ENCT2_DACSEL_0 ((0x2489 << 2) + 0xff900000)
#define ENCT2_DACSEL_1 ((0x248a << 2) + 0xff900000)
#define ENCT2_INBUF_CNTL0 ((0x248b << 2) + 0xff900000)
#define ENCT2_INBUF_CNTL1 ((0x248c << 2) + 0xff900000)
#define ENCT2_INBUF_CNT ((0x248d << 2) + 0xff900000)
#define ENCT2_INBUF_HOLD_CNT ((0x248e << 2) + 0xff900000)
#define ENCT2_INBUF_FIX_PIX_NUM ((0x248f << 2) + 0xff900000)
//===========================================================================
// For ENCL
//===========================================================================
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define ENCL2_VFIFO2VD_CTL ((0x2490 << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCL2_VFIFO2VD_PIXEL_START ((0x2491 << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCL2_VFIFO2VD_PIXEL_END ((0x2492 << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCL2_VFIFO2VD_LINE_TOP_START ((0x2493 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCL2_VFIFO2VD_LINE_TOP_END ((0x2494 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCL2_VFIFO2VD_LINE_BOT_START ((0x2495 << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCL2_VFIFO2VD_LINE_BOT_END ((0x2496 << 2) + 0xff900000)
#define ENCL2_VFIFO2VD_CTL2 ((0x2497 << 2) + 0xff900000)
#define ENCL2_TST_EN ((0x2498 << 2) + 0xff900000)
#define ENCL2_TST_MDSEL ((0x2499 << 2) + 0xff900000)
#define ENCL2_TST_Y ((0x249a << 2) + 0xff900000)
#define ENCL2_TST_CB ((0x249b << 2) + 0xff900000)
#define ENCL2_TST_CR ((0x249c << 2) + 0xff900000)
#define ENCL2_TST_CLRBAR_STRT ((0x249d << 2) + 0xff900000)
#define ENCL2_TST_CLRBAR_WIDTH ((0x249e << 2) + 0xff900000)
#define ENCL2_TST_VDCNT_STSET ((0x249f << 2) + 0xff900000)
//===========================================================================
// ENCL2 registers
#define ENCL2_VIDEO_EN ((0x24a0 << 2) + 0xff900000)
#define ENCL2_VIDEO_Y_SCL ((0x24a1 << 2) + 0xff900000)
#define ENCL2_VIDEO_PB_SCL ((0x24a2 << 2) + 0xff900000)
#define ENCL2_VIDEO_PR_SCL ((0x24a3 << 2) + 0xff900000)
#define ENCL2_VIDEO_Y_OFFST ((0x24a4 << 2) + 0xff900000)
#define ENCL2_VIDEO_PB_OFFST ((0x24a5 << 2) + 0xff900000)
#define ENCL2_VIDEO_PR_OFFST ((0x24a6 << 2) + 0xff900000)
//----- Video mode
#define ENCL2_VIDEO_MODE ((0x24a7 << 2) + 0xff900000)
#define ENCL2_VIDEO_MODE_ADV ((0x24a8 << 2) + 0xff900000)
//--------------- Debug pins
#define ENCL2_DBG_PX_RST ((0x24a9 << 2) + 0xff900000)
#define ENCL2_DBG_LN_RST ((0x24aa << 2) + 0xff900000)
#define ENCL2_DBG_PX_INT ((0x24ab << 2) + 0xff900000)
#define ENCL2_DBG_LN_INT ((0x24ac << 2) + 0xff900000)
//----------- Video Advanced setting
#define ENCL2_VIDEO_YFP1_HTIME ((0x24ad << 2) + 0xff900000)
#define ENCL2_VIDEO_YFP2_HTIME ((0x24ae << 2) + 0xff900000)
#define ENCL2_VIDEO_YC_DLY ((0x24af << 2) + 0xff900000)
#define ENCL2_VIDEO_MAX_PXCNT ((0x24b0 << 2) + 0xff900000)
#define ENCL2_VIDEO_HAVON_END ((0x24b1 << 2) + 0xff900000)
#define ENCL2_VIDEO_HAVON_BEGIN ((0x24b2 << 2) + 0xff900000)
#define ENCL2_VIDEO_VAVON_ELINE ((0x24b3 << 2) + 0xff900000)
#define ENCL2_VIDEO_VAVON_BLINE ((0x24b4 << 2) + 0xff900000)
#define ENCL2_VIDEO_HSO_BEGIN ((0x24b5 << 2) + 0xff900000)
#define ENCL2_VIDEO_HSO_END ((0x24b6 << 2) + 0xff900000)
#define ENCL2_VIDEO_VSO_BEGIN ((0x24b7 << 2) + 0xff900000)
#define ENCL2_VIDEO_VSO_END ((0x24b8 << 2) + 0xff900000)
#define ENCL2_VIDEO_VSO_BLINE ((0x24b9 << 2) + 0xff900000)
#define ENCL2_VIDEO_VSO_ELINE ((0x24ba << 2) + 0xff900000)
#define ENCL2_VIDEO_MAX_LNCNT ((0x24bb << 2) + 0xff900000)
#define ENCL2_VIDEO_BLANKY_VAL ((0x24bc << 2) + 0xff900000)
#define ENCL2_VIDEO_BLANKPB_VAL ((0x24bd << 2) + 0xff900000)
#define ENCL2_VIDEO_BLANKPR_VAL ((0x24be << 2) + 0xff900000)
#define ENCL2_VIDEO_HOFFST ((0x24bf << 2) + 0xff900000)
#define ENCL2_VIDEO_VOFFST ((0x24c0 << 2) + 0xff900000)
#define ENCL2_VIDEO_RGB_CTRL ((0x24c1 << 2) + 0xff900000)
#define ENCL2_VIDEO_FILT_CTRL ((0x24c2 << 2) + 0xff900000)
#define ENCL2_VIDEO_OFLD_VPEQ_OFST ((0x24c3 << 2) + 0xff900000)
#define ENCL2_VIDEO_OFLD_VOAV_OFST ((0x24c4 << 2) + 0xff900000)
#define ENCL2_VIDEO_MATRIX_CB ((0x24c5 << 2) + 0xff900000)
#define ENCL2_VIDEO_MATRIX_CR ((0x24c6 << 2) + 0xff900000)
#define ENCL2_VIDEO_RGBIN_CTRL ((0x24c7 << 2) + 0xff900000)
#define ENCL2_MAX_LINE_SWITCH_POINT ((0x24c8 << 2) + 0xff900000)
#define ENCL2_DACSEL_0 ((0x24c9 << 2) + 0xff900000)
#define ENCL2_DACSEL_1 ((0x24ca << 2) + 0xff900000)
#define ENCT2_VIDEO_H_PRE_DE_END ((0x24cb << 2) + 0xff900000)
#define ENCT2_VIDEO_H_PRE_DE_BEGIN ((0x24cc << 2) + 0xff900000)
#define ENCT2_VIDEO_V_PRE_DE_ELINE ((0x24cd << 2) + 0xff900000)
#define ENCT2_VIDEO_V_PRE_DE_BLINE ((0x24ce << 2) + 0xff900000)
#define ENCL2_VIDEO_H_PRE_DE_END ((0x24cf << 2) + 0xff900000)
#define ENCL2_VIDEO_H_PRE_DE_BEGIN ((0x24d0 << 2) + 0xff900000)
#define ENCL2_VIDEO_V_PRE_DE_ELINE ((0x24d1 << 2) + 0xff900000)
#define ENCL2_VIDEO_V_PRE_DE_BLINE ((0x24d2 << 2) + 0xff900000)
#define ENCL2_INBUF_CNTL0 ((0x24d3 << 2) + 0xff900000)
#define ENCL2_INBUF_CNTL1 ((0x24d4 << 2) + 0xff900000)
#define ENCL2_INBUF_CNT ((0x24d5 << 2) + 0xff900000)
#define ENCL2_INBUF_HOLD_CNT ((0x24d6 << 2) + 0xff900000)
#define ENCL2_INBUF_FIX_PIX_NUM ((0x24d7 << 2) + 0xff900000)
#define VENC2_VRR_CTRL ((0x24d8 << 2) + 0xff900000)
// Bit   31    cfg_vsp_din      // W, pulse
// Bit   30    cfg_vrr_clr      // W, pulse
// Bit 31:28   ro_vrr_vsp_cnt   // R,
// Bit 27:24   ro_vrr_max_err   // R,
// Bit 23:8    cfg_vsp_dly_num  // R/W, unsigned, default 0
// Bit  7:4    cfg_vrr_frm_ths  // R/W, unsigned, default 0
// Bit  3:2    cfg_vrr_vsp_en   // R/W, unsigned, default 0
// Bit    1    cfg_vrr_mode     // R/W, unsigned, default 0
// Bit    0    cfg_vrr_vsp_sel  // R/W, unsigned, default 0
#define VENC2_VRR_ADJ_LMT ((0x24d9 << 2) + 0xff900000)
// Bit 31:16  cfg_vrr_min_vnum  //R/W, unsigned,
// Bit 15:0   cfg_vrr_max_vnum  //R/W, unsigned,
#define VENC2_VRR_CTRL1 ((0x24da << 2) + 0xff900000)
// Bit 4:1    cfg_vsp_rst_num   //R/W, unsigned, default 1
// Bit   0    cfg_vsp_cnt_rst   //W,pulse
#define VPU2_VPU_PWM_V0 ((0x24e0 << 2) + 0xff900000)
#define VPU2_VPU_PWM_V1 ((0x24e1 << 2) + 0xff900000)
#define VPU2_VPU_PWM_V2 ((0x24e2 << 2) + 0xff900000)
#define VPU2_VPU_PWM_V3 ((0x24e3 << 2) + 0xff900000)
#define VPU2_VPU_PWM_H0 ((0x24e4 << 2) + 0xff900000)
#define VPU2_VPU_PWM_H1 ((0x24e5 << 2) + 0xff900000)
#define VPU2_VPU_PWM_H2 ((0x24e6 << 2) + 0xff900000)
#define VPU2_VPU_PWM_H3 ((0x24e7 << 2) + 0xff900000)
#define VPU2_VPU_3D_SYNC1 ((0x24e8 << 2) + 0xff900000)
#define VPU2_VPU_3D_SYNC2 ((0x24e9 << 2) + 0xff900000)
#define VPU2_VENC_DUMMY ((0x24df << 2) + 0xff900000)
#define VPU2_VENC_ERROR ((0x24ea << 2) + 0xff900000)
#define VPU2_VENCI_STAT ((0x24eb << 2) + 0xff900000)
#define VPU2_VENCP_STAT ((0x24ec << 2) + 0xff900000)
#define VPU2_VENCL_STAT ((0x24ed << 2) + 0xff900000)
#define VPU2_VENC_DITH ((0x24ee << 2) + 0xff900000)
#define VPU2_VENC_CTRL ((0x24ef << 2) + 0xff900000)
#define VPU2_VENCL_DITH_CTRL ((0x24f0 << 2) + 0xff900000)
#define VPU2_VENCL_DITH_LUT_1 ((0x24f1 << 2) + 0xff900000)
#define VPU2_VENCL_DITH_LUT_2 ((0x24f2 << 2) + 0xff900000)
#define VPU2_VENCL_DITH_LUT_3 ((0x24f3 << 2) + 0xff900000)
#define VPU2_VENCL_DITH_LUT_4 ((0x24f4 << 2) + 0xff900000)
#define VPU2_VENCL_DITH_LUT_5 ((0x24f5 << 2) + 0xff900000)
#define VPU2_VENCL_DITH_LUT_6 ((0x24f6 << 2) + 0xff900000)
#define VPU2_VENCL_DITH_LUT_7 ((0x24f7 << 2) + 0xff900000)
#define VPU2_VENCL_DITH_LUT_8 ((0x24f8 << 2) + 0xff900000)
#define VPU2_VENCL_DITH_LUT_9 ((0x24f9 << 2) + 0xff900000)
#define VPU2_VENCL_DITH_LUT_10 ((0x24fa << 2) + 0xff900000)
#define VPU2_VENCL_DITH_LUT_11 ((0x24fb << 2) + 0xff900000)
#define VPU2_VENCL_DITH_LUT_12 ((0x24fc << 2) + 0xff900000)
//
// Closing file:  venc2_2_regs.h
//
//===========================================================================
// `define     VPU_VCBUS_BASE        8'h27
//===========================================================================
//
// Reading file:  vpu_top_regs.h
//
// synopsys translate_off
// synopsys translate_on
//======================================================================
//   vpu  register.
//======================================================================
// -----------------------------------------------
// CBUS_BASE:  VPU_VCBUS_BASE = 0x27
// -----------------------------------------------
#define VPU_CRC_CTRL ((0x2701 << 2) + 0xff900000)
#define VPU_RO_CRC0 ((0x2702 << 2) + 0xff900000)
#define VPU_RO_CRC1 ((0x2703 << 2) + 0xff900000)
#define VPU_RO_CRC2 ((0x2704 << 2) + 0xff900000)
#define VPU_RO_CRC3 ((0x2705 << 2) + 0xff900000)
#define VPU_RO_CRC4 ((0x2706 << 2) + 0xff900000)
#define VPU_RO_CRC5 ((0x2707 << 2) + 0xff900000)
#define VPU_RO_CRC6 ((0x2708 << 2) + 0xff900000)
#define VPU_RO_CRC7 ((0x2728 << 2) + 0xff900000)
#define VPU_RO_CRC8 ((0x2729 << 2) + 0xff900000)
#define VPU_RO_CRC9 ((0x272a << 2) + 0xff900000)
#define VPU_TOP_MISC ((0x2709 << 2) + 0xff900000)
#define VPU_INTF_CTRL ((0x270a << 2) + 0xff900000)
#define VPU_APB_PROT_CTRL ((0x270b << 2) + 0xff900000)
#define VPU_ENC_ERROR ((0x270c << 2) + 0xff900000)
#define VPU_SECURE_REG ((0x270d << 2) + 0xff900000)
#define VPU_SECURE_ST_RO ((0x270e << 2) + 0xff900000)
#define VPU_VDIN_SEC_IN ((0x270f << 2) + 0xff900000)
// Read only
//`define     VPU_TVDVBI_VSLATCH_ADDR   8'h12
// Read only
//`define     VPU_TVDVBI_WRRSP_ADDR 8'h13
#define VPU_VDIN_PRE_ARB_CTRL ((0x2714 << 2) + 0xff900000)
#define VPU_VDISP_PRE_ARB_CTRL ((0x2715 << 2) + 0xff900000)
#define VPU_VPUARB2_PRE_ARB_CTRL ((0x2716 << 2) + 0xff900000)
// [31:21] Reserved.
// [20:18] cntl_encx_clk_sel
// [17:16] cntl_vencl_dpi_sel_clk
// [15: 8] Reserved
// [ 6: 4] Reserved
// [ 3: 2] cntl_viu2_sel_venc. Select which one of the encI/P/T that VIU2 connects to:
//         0=No connection, 1=ENCI, 2=ENCP, 3=ENCT.
// [ 1: 0] cntl_viu1_sel_venc. Select which one of the encI/P/T that VIU1 connects to:
//         0=No connection, 1=ENCI, 2=ENCP, 3=ENCT.
#define VPU_VIU_VENC_MUX_CTRL ((0x271a << 2) + 0xff900000)
// [15:12] rd_rate. 0=A read every clk2; 1=A read every 2 clk2; ...; 15=A read every 16 clk2.
// [11: 8] wr_rate. 0=A write every clk1; 1=A write every 2 clk1; ...; 15=A write every 16 clk1.
// [ 7: 5] data_comp_map. Input data is CrYCb(BRG), map the output data to desired format:
//                          0=output CrYCb(BRG);
//                          1=output YCbCr(RGB);
//                          2=output YCrCb(RBG);
//                          3=output CbCrY(GBR);
//                          4=output CbYCr(GRB);
//                          5=output CrCbY(BGR);
//                          6,7=Rsrv.
// [    4] inv_dvi_clk. 1=Invert clock to external DVI, (clock invertion exists at internal HDMI).
// [    3] inv_vsync. 1=Invert Vsync polarity.
// [    2] inv_hsync. 1=Invert Hsync polarity.
// [ 1: 0] src_sel. 0=Disable output to HDMI; 1=Select VENC_I output to HDMI; 2=Select VENC_P
// output.
#define VPU_HDMI_SETTING ((0x271b << 2) + 0xff900000)
#define ENCI_INFO_READ ((0x271c << 2) + 0xff900000)
#define ENCP_INFO_READ ((0x271d << 2) + 0xff900000)
#define ENCT_INFO_READ ((0x271e << 2) + 0xff900000)
#define ENCL_INFO_READ ((0x271f << 2) + 0xff900000)
// Bit  0 RW, viu_rst_n
// Bit  1 RW, vdin_mmc_arb_rst_n
// Bit  2 RW, vdisp_mmc_arb_rst_n
// Bit  3 RW, vpuarb2_mmc_arb_rst_n
#define VPU_SW_RESET ((0x2720 << 2) + 0xff900000)
// Bit  6 RW, gclk_mpeg_vpu_misc
// Bit  5 RW, gclk_mpeg_venc_l_top
// Bit  4 RW, gclk_mpeg_vencl_int
// Bit  3 RW, gclk_mpeg_vencp_int
// Bit  2 RW, gclk_mpeg_vi2_top
// Bit  1 RW, gclk_mpeg_vi_top
// Bit  0 RW, gclk_mpeg_venc_p_top
#define VPU_CLK_GATE ((0x2723 << 2) + 0xff900000)
#define VPU_MEM_PD_REG0 ((0x2725 << 2) + 0xff900000)
#define VPU_MEM_PD_REG1 ((0x2726 << 2) + 0xff900000)
// [   31] hdmi_data_ovr_en: 1=Enable overriding data input to HDMI TX with hdmi_data_ovr[29:0].
// 0=No override. Default 0. [   30] Reserved. Default 0 [29: 0] hdmi_data_ovr. Default 0.
#define VPU_HDMI_DATA_OVR ((0x2727 << 2) + 0xff900000)
#define VPU_AXI_QOS_RD0 ((0x2730 << 2) + 0xff900000)
#define VPU_AXI_QOS_RD1 ((0x2731 << 2) + 0xff900000)
#define VPU_AXI_QOS_WR0 ((0x2732 << 2) + 0xff900000)
#define VPU_AXI_CACHE ((0x2733 << 2) + 0xff900000)
// Bit 0,   if true, force vencl clk enable, otherwise, it might auto turn off by mipi DSI
#define VPU_MISC_CTRL ((0x2740 << 2) + 0xff900000)
#define VPU_ISP_GCLK_CTRL0 ((0x2741 << 2) + 0xff900000)
#define VPU_ISP_GCLK_CTRL1 ((0x2742 << 2) + 0xff900000)
#define VPU_HDMI_FMT_CTRL ((0x2743 << 2) + 0xff900000)
#define VPU_VDIN_ASYNC_HOLD_CTRL ((0x2744 << 2) + 0xff900000)
#define VPU_VDISP_ASYNC_HOLD_CTRL ((0x2745 << 2) + 0xff900000)
#define VPU_VPUARB2_ASYNC_HOLD_CTRL ((0x2746 << 2) + 0xff900000)
#define VPU_ARB_URG_CTRL ((0x2747 << 2) + 0xff900000)
#define VPU_SECURE_DUMMY ((0x2748 << 2) + 0xff900000)
//`define     VPU_VENCL_DITH_EN            8'h49
#define VPU_TOP_CTRL ((0x2749 << 2) + 0xff900000)
// todo :
#define VPU_422TO444_RST ((0x274a << 2) + 0xff900000)
// todo :
#define VPU_422TO444_CTRL0 ((0x274b << 2) + 0xff900000)
// todo :
#define VPU_422TO444_CTRL1 ((0x274c << 2) + 0xff900000)
// todo :
#define VPU_422TO444_CTRL2 ((0x274d << 2) + 0xff900000)
// todo :
#define VPU_422TO444_CTRL3 ((0x274e << 2) + 0xff900000)
// todo :
#define VPU_422TO444_CTRL4 ((0x274f << 2) + 0xff900000)
// Bit 20    reg_viu2vdin0_sw_reset:   software reset
// Bit 19:18 reg_viu2vdin0_dn_ratio:   down-scale ratio; 0: no scale; 1: 1/2;  2:1/4; 3: reserved
// Bit 17:16 reg_viu2vdin0_flt_mode:   filter mode; 0: no filter; 1:[0 2 2 0]/4; 2:[1 1 1 1]/4;
// 3:[1 3 3 1]/8 Bit 15:14 reserved Bit 13:0  reg_viu2vdin0_hsize:      source horizontal size
#define VPU_VIU2VDIN0_HDN_CTRL ((0x2780 << 2) + 0xff900000)
#define VPU_VIU_ASYNC_MASK ((0x2781 << 2) + 0xff900000)
#define VPU_VDIN_MISC_CTRL ((0x2782 << 2) + 0xff900000)
// [31:29] Reserved.
// [28:24] cntl_viu2vdin1_sel_data. Select VIU to VDIN data path, must clear it first before
// changing the path selection:
//          5'b00000=Disable VIU to VDIN path;
//          5'b00001=Enable VIU of ENC_I domain to VDIN;
//          5'b00010=Enable VIU of ENC_P domain to VDIN;
//          5'b00100=Enable VIU of ENC_T domain to VDIN;
//          5'b01000=Enable VIU WriteBack 1 domain to VDIN;
//          5'b10000=Enable VIU WriteBack 2 domain to VDIN;
// [23:21] Reserved.
// [20:16] cntl_viu2vdin1_sel_clk. Select which clock to VDIN path, must clear it first before
// changing the clock:
//          5'b00000=Disable VIU to VDIN clock;
//          5'b00001=Select encI clock to VDIN;
//          5'b00010=Select encP clock to VDIN;
//          5'b00100=Select encT clock to VDIN;
//          5'b01000=Select VIU WriteBack 1 clock to VDIN;
//          5'b10000=Select VIU WriteBack 2 clock to VDIN;
// [15:13] Reserved.
// [12: 8] cntl_viu2vdin0_sel_data. Select VIU to VDIN data path, must clear it first before
// changing the path selection:
//          5'b00000=Disable VIU to VDIN path;
//          5'b00001=Enable VIU of ENC_I domain to VDIN;
//          5'b00010=Enable VIU of ENC_P domain to VDIN;
//          5'b00100=Enable VIU of ENC_T domain to VDIN;
//          5'b01000=Enable VIU WriteBack 1 domain to VDIN;
//          5'b10000=Enable VIU WriteBack 2 domain to VDIN;
// [ 7:5]  Reserved.
// [ 4: 0] cntl_viu2vdin0_sel_clk. Select which clock to VDIN path, must clear it first before
// changing the clock:
//          5'b00000=Disable VIU to VDIN clock;
//          5'b00001=Select encI clock to VDIN;
//          5'b00010=Select encP clock to VDIN;
//          5'b00100=Select encT clock to VDIN;
//          5'b01000=Select VIU WriteBack 1 clock to VDIN;
//          5'b10000=Select VIU WriteBack 2 clock to VDIN;
#define VPU_VIU_VDIN_IF_MUX_CTRL ((0x2783 << 2) + 0xff900000)
// Bit 20    reg_viu2vdin1_sw_reset:   software reset
// Bit 19:18 reg_viu2vdin1_dn_ratio:   down-scale ratio; 0: no scale; 1: 1/2;  2:1/4; 3: reserved
// Bit 17:16 reg_viu2vdin1_flt_mode:   filter mode; 0: no filter; 1:[0 2 2 0]/4; 2:[1 1 1 1]/4;
// 3:[1 3 3 1]/8 Bit 15:14 reserved Bit 13:0  reg_viu2vdin1_hsize:      source horizontal size
#define VPU_VIU2VDIN1_HDN_CTRL ((0x2784 << 2) + 0xff900000)
#define VPU_VENCX_CLK_CTRL ((0x2785 << 2) + 0xff900000)
// Bit 0  encp_afifo_clk
// Bit 1  encl_afifo_clk
// Bit 2  enci_afifo_clk
#define VPU_DISP_VIU0_CTRL ((0x2786 << 2) + 0xff900000)
// Bit 31    lvds_out_enable[0]
// Bit 30    vbo_out_enable[0]
// Bit 29    hdmi_tx_enable[0]
// Bit 28    dsi_edp_enable[0]
// Bit 27:7  reserved
// Bit 6     viu0_disable_rst_afifo
// Bit 5:4   viu0_vs_hs_ctrl
// Bit 3:2   viu0_force_field_ctrl
// Bit 1     viu0_force_go_line
// Bit 0     viu0_force_go_field
#define VPU_DISP_VIU1_CTRL ((0x2787 << 2) + 0xff900000)
// Bit 31    lvds_out_enable[1]
// Bit 30    vbo_out_enable[1]
// Bit 29    hdmi_tx_enable[1]
// Bit 28    dsi_edp_enable[1]
// Bit 27:7  reserved
// Bit 6     viu1_disable_rst_afifo
// Bit 5:4   viu1_vs_hs_ctrl
// Bit 3:2   viu1_force_field_ctrl
// Bit 1     viu1_force_go_line
// Bit 0     viu1_force_go_field
#define VPU_DISP_VIU2_CTRL ((0x2788 << 2) + 0xff900000)
// Bit 31    lvds_out_enable[2]
// Bit 30    vbo_out_enable[2]
// Bit 29    hdmi_tx_enable[2]
// Bit 28    dsi_edp_enable[2]
// Bit 27:7  reserved
// Bit 6     viu2_disable_rst_afifo
// Bit 5:4   viu2_vs_hs_ctrl
// Bit 3:2   viu2_force_field_ctrl
// Bit 1     viu2_force_go_line
// Bit 0     viu2_force_go_field
#define VPU_VENC_RGN_CTRL ((0x2789 << 2) + 0xff900000)
#define VPU_VENC_RGN_RSIZE ((0x278a << 2) + 0xff900000)
#define VPU_DISP_WRAP_CTRL ((0x278b << 2) + 0xff900000)
#define RO_VPU_VENC0_CRC ((0x278c << 2) + 0xff900000)
#define VPU_FRC_TOP_CTRL ((0x278d << 2) + 0xff900000)
// Bit 31:13 reserved
// Bit 12    reg_frc_cmp_mode       // unsigned ,   RW, default = 1, data   convert mode  signal
// 1:bypass data   convert  1:12bit/10bit convert 0:don't convert Bit 11:9  reserved Bit 8
// reg_frc_cmp_byp        // unsigned ,   RW, default = 0, data   convert bypass signal 1:bypass
// data   convert 0:open data   convert Bit 7:5   reserved Bit 4     reg_frc_pos_sel        //
// unsigned ,   RW, default = 0, select signal of frc position switch,1:before postblend 0:after
// postblend Bit 3:1   reserved Bit 0     reg_frc_byp_en         // unsigned ,   RW, default = 1,
// bypass enable signal of frc,1:bypas frc 0:open frc
#define VPU_VIU_ASYNC_MASK1 ((0x278f << 2) + 0xff900000)
// vpu arbtration :
// the segment is 8'h90-8'hc8
//
// Reading file:  vpu_arb_axi_regs.h
//
// synopsys translate_off
// synopsys translate_on
////===============================////
//// reg
////===============================////
//`define VPU_RDARB_MODE_L1C1           8'h90  //
////Bit   31:22,    reserved
////Bit   21:16,    rdarb_sel           uns, default = 0 ,
////                                    rdarb_sel[0]==0 slave dc0 connect master port0
/// rdarb_sel[0]==1 slave dc0 connect master port1 / rdarb_sel[1]==0 slave dc1 connect master
/// port0 rdarb_sel[1]==1 slave dc1 connect master port1 / rdarb_sel[2]==0 slave dc2 connect master
/// port0 rdarb_sel[2]==1 slave dc2 connect master port1 / rdarb_sel[3]==0 slave dc3 connect master
/// port0 rdarb_sel[3]==1 slave dc3 connect master port1 / rdarb_sel[4]==0 slave dc4 connect master
/// port0 rdarb_sel[4]==1 slave dc4 connect master port1 / rdarb_sel[5]==0 slave dc5 connect master
/// port0 rdarb_sel[5]==1 slave dc5 connect master port1 /Bit   15:10,    reserved /Bit   9:8,
/// rdarb_arb_mode      uns, default = 0 , /                                    rdarb_arb_mode[0]
/// master port0 arb way, /                                    rdarb_arb_mode[1] master port1 arb
/// way, /Bit   7:4,      reserved /Bit   3:0,      rdarb_gate_clk_ctrl uns, default = 0 , /
/// rdarb_gate_clk_ctrl[1:0] master port0 clk gate control / rdarb_gate_clk_ctrl[3:2] master port1
/// clk gate control
//
//`define VPU_RDARB_REQEN_SLV_L1C1      8'h91  //
////Bit   31:12,     reserved
////Bit   11:0,     rdarb_dc_req_en     unsigned  , default = 12'hfff
////                                    rdarb_dc_req_en[0]: the slv0 req to mst port0 enable,
////                                    rdarb_dc_req_en[1]: the slv1 req to mst port0 enable,
////                                    rdarb_dc_req_en[2]: the slv2 req to mst port0 enable,
////                                    rdarb_dc_req_en[3]: the slv3 req to mst port0 enable,
////                                    rdarb_dc_req_en[4]: the slv4 req to mst port0 enable,
////                                    rdarb_dc_req_en[5]: the slv5 req to mst port0 enable,
////                                    rdarb_dc_req_en[6]: the slv0 req to mst port1 enable,
////                                    rdarb_dc_req_en[7]: the slv1 req to mst port1 enable,
////                                    rdarb_dc_req_en[8]: the slv2 req to mst port1 enable,
////                                    rdarb_dc_req_en[9]: the slv3 req to mst port1 enable,
////                                    rdarb_dc_req_en[10]: the slv4 req to mst port1 enable,
////                                    rdarb_dc_req_en[11]: the slv5 req to mst port1 enable,
//
//`define VPU_RDARB_WEIGH0_SLV_L1C1      8'h92  //
////Bit   31:30,    reserved
////Bit   29:0,     rddc_weigh_sxn     unsigned  , default = 0
////                                    rddc_weigh_sxn[0*6+:6]: the slv0 req weigh number
////                                    rddc_weigh_sxn[1*6+:6]: the slv1 req weigh number
////                                    rddc_weigh_sxn[2*6+:6]: the slv2 req weigh number
////                                    rddc_weigh_sxn[3*6+:6]: the slv3 req weigh number
////                                    rddc_weigh_sxn[4*6+:6]: the slv4 req weigh number
//`define VPU_RDARB_WEIGH1_SLV_L1C1      8'h93  //
////Bit   31:6,    reserved
////Bit   5:0,     rddc_weigh_sxn     unsigned  , default = 0
////                                    rddc_weigh_sxn[5*6+:6]: the slv5 req weigh number
//
//
//
//`define VPU_WRARB_MODE_L1C1            8'h94  //
////Bit   31:22,    reserved
////Bit   21:16,    wrarb_sel           uns, default = 0 ,
////                                    wrarb_sel[0]==0 slave dc0 connect master port0
/// wrarb_sel[0]==1 slave dc0 connect master port1 / wrarb_sel[1]==0 slave dc1 connect master
/// port0 wrarb_sel[1]==1 slave dc1 connect master port1 / wrarb_sel[2]==0 slave dc2 connect master
/// port0 wrarb_sel[2]==1 slave dc2 connect master port1 / wrarb_sel[3]==0 slave dc3 connect master
/// port0 wrarb_sel[3]==1 slave dc3 connect master port1 / wrarb_sel[4]==0 slave dc4 connect master
/// port0 wrarb_sel[4]==1 slave dc4 connect master port1 / wrarb_sel[5]==0 slave dc5 connect master
/// port0 wrarb_sel[5]==1 slave dc5 connect master port1 /Bit   15:10,    reserved /Bit   9:8,
/// wrarb_arb_mode      uns, default = 0 , /                                    wrarb_arb_mode[0]
/// master port0 arb way, /                                    wrarb_arb_mode[1] master port1 arb
/// way, /Bit   7:4,      reserved /Bit   3:0,      wrarb_gate_clk_ctrl uns, default = 0 , /
/// wrarb_gate_clk_ctrl[1:0] master port0 clk gate control / wrarb_gate_clk_ctrl[3:2] master port1
/// clk gate control
//
//`define VPU_WRARB_REQEN_SLV_L1C1      8'h95  //
////Bit   31:12,     reserved
////Bit   11:0,     wrarb_dc_req_en     unsigned  , default = 0
////                                    wrarb_dc_req_en[0]: the slv0 req to mst port0 enable,
////                                    wrarb_dc_req_en[1]: the slv1 req to mst port0 enable,
////                                    wrarb_dc_req_en[2]: the slv2 req to mst port0 enable,
////                                    wrarb_dc_req_en[3]: the slv3 req to mst port0 enable,
////                                    wrarb_dc_req_en[4]: the slv4 req to mst port0 enable,
////                                    wrarb_dc_req_en[5]: the slv5 req to mst port0 enable,
////                                    wrarb_dc_req_en[0]: the slv0 req to mst port1 enable,
////                                    wrarb_dc_req_en[1]: the slv1 req to mst port1 enable,
////                                    wrarb_dc_req_en[2]: the slv2 req to mst port1 enable,
////                                    wrarb_dc_req_en[3]: the slv3 req to mst port1 enable,
////                                    wrarb_dc_req_en[4]: the slv4 req to mst port1 enable,
////                                    wrarb_dc_req_en[5]: the slv5 req to mst port1 enable,
//
//`define VPU_WRARB_WEIGH0_SLV_L1C1      8'h96  //
////Bit   31:30,    reserved
////Bit   29:0,     wrdc_weigh_sxn     unsigned  , default = 0
////                                    wrdc_weigh_sxn[0*6+:6]: the slv0 req weigh number
////                                    wrdc_weigh_sxn[1*6+:6]: the slv1 req weigh number
////                                    wrdc_weigh_sxn[2*6+:6]: the slv2 req weigh number
////                                    wrdc_weigh_sxn[3*6+:6]: the slv3 req weigh number
////                                    wrdc_weigh_sxn[4*6+:6]: the slv4 req weigh number
//`define VPU_WRARB_WEIGH1_SLV_L1C1      8'h97  //
////Bit   31:6,    reserved
////Bit   5:0,     wrdc_weigh_sxn     unsigned  , default = 0
////                                    wrdc_weigh_sxn[5*6+:6]: the slv5 req weigh number
//
//`define VPU_RDWR_ARB_STATUS_L1C1      8'h98  //
////Bit   31:4,    reserved
////Bit    3:2,    wrarb_arb_busy     unsigned  , default = 0
////Bit    1:0,    rdarb_arb_busy     unsigned  , default = 0
//
//
//`define VPU_RDARB_MODE_L1C2           8'h99  //
////Bit   31:21,    reserved
////Bit   20:16,    rdarb_sel           uns, default = 0 ,
////                                    rdarb_sel[0]==0 slave dc0 connect master port0
/// rdarb_sel[0]==1 slave dc0 connect master port1 / rdarb_sel[1]==0 slave dc1 connect master
/// port0 rdarb_sel[1]==1 slave dc1 connect master port1 / rdarb_sel[2]==0 slave dc2 connect master
/// port0 rdarb_sel[2]==1 slave dc2 connect master port1 / rdarb_sel[3]==0 slave dc3 connect master
/// port0 rdarb_sel[3]==1 slave dc3 connect master port1 / rdarb_sel[4]==0 slave dc4 connect master
/// port0 rdarb_sel[4]==1 slave dc4 connect master port1 /Bit   15:10,    reserved /Bit   9:8,
/// rdarb_arb_mode      uns, default = 0 , /                                    rdarb_arb_mode[0]
/// master port0 arb way, /                                    rdarb_arb_mode[1] master port1 arb
/// way, /Bit   7:4,      reserved /Bit   3:0,      rdarb_gate_clk_ctrl uns, default = 0 , /
/// rdarb_gate_clk_ctrl[1:0] master port0 clk gate control / rdarb_gate_clk_ctrl[3:2] master port0
/// clk gate control
//
//`define VPU_RDARB_REQEN_SLV_L1C2      8'h9a  //
////Bit   31:10,     reserved
////Bit    9:0,     rdarb_dc_req_en     unsigned  , default = 0
////                                    rdarb_dc_req_en[0]: the slv0 req to mst port0 enable,
////                                    rdarb_dc_req_en[1]: the slv1 req to mst port0 enable,
////                                    rdarb_dc_req_en[2]: the slv2 req to mst port0 enable,
////                                    rdarb_dc_req_en[3]: the slv3 req to mst port0 enable,
////                                    rdarb_dc_req_en[4]: the slv4 req to mst port0 enable,
////                                    rdarb_dc_req_en[5]: the slv0 req to mst port1 enable,
////                                    rdarb_dc_req_en[6]: the slv1 req to mst port1 enable,
////                                    rdarb_dc_req_en[7]: the slv2 req to mst port1 enable,
////                                    rdarb_dc_req_en[8]: the slv3 req to mst port1 enable,
////                                    rdarb_dc_req_en[9]: the slv4 req to mst port1 enable,
//
//`define VPU_RDARB_WEIGH0_SLV_L1C2      8'h9b  //
////Bit   31:30,    reserved
////Bit   29:0,     rddc_weigh_sxn     unsigned  , default = 0
////                                    rddc_weigh_sxn[0*6+:6]: the slv0 req weigh number
////                                    rddc_weigh_sxn[1*6+:6]: the slv1 req weigh number
////                                    rddc_weigh_sxn[2*6+:6]: the slv2 req weigh number
////                                    rddc_weigh_sxn[3*6+:6]: the slv3 req weigh number
////                                    rddc_weigh_sxn[4*6+:6]: the slv4 req weigh number
//
//`define VPU_RDWR_ARB_STATUS_L1C2      8'h9c  //
////Bit   31:3,    reserved
////Bit      2,    wrarb_arb_busy     unsigned  , default = 0
////Bit    1:0,    rdarb_arb_busy     unsigned  , default = 0
#define VPU_RDARB_MODE_L2C1 ((0x279d << 2) + 0xff900000)
// Bit   31:28,    reserved
// Bit   27:16,    rdarb_sel           uns, default = 0 ,
//                                    rdarb_sel[0]==0 slave dc0 connect master port0
//                                    rdarb_sel[0]==1 slave dc0 connect master port1
//                                    rdarb_sel[1]==0 slave dc1 connect master port0
//                                    rdarb_sel[1]==1 slave dc1 connect master port1
//                                    rdarb_sel[2]==0 slave dc2 connect master port0
//                                    rdarb_sel[2]==1 slave dc2 connect master port1
//                                    rdarb_sel[3]==0 slave dc3 connect master port0
//                                    rdarb_sel[3]==1 slave dc3 connect master port1
//                                    rdarb_sel[4]==0 slave dc4 connect master port0
//                                    rdarb_sel[4]==1 slave dc4 connect master port1
//                                    rdarb_sel[5]==0 slave dc5 connect master port0
//                                    rdarb_sel[5]==1 slave dc5 connect master port1
// Bit   15:11,    reserved
// Bit   10:8,      rdarb_arb_mode      uns, default = 0 ,
//                                    rdarb_arb_mode[0] master port0 arb way,
//                                    rdarb_arb_mode[1] master port1 arb way,
// Bit   7:6,      reserved
// Bit   5:0,      rdarb_gate_clk_ctrl uns, default = 0 ,
//                                    rdarb_gate_clk_ctrl[1:0] master port0 clk gate control
//                                    rdarb_gate_clk_ctrl[3:2] master port1 clk gate control
//                                    rdarb_gate_clk_ctrl[5:4] master port2 clk gate control
#define VPU_RDARB_REQEN_SLV_L2C1 ((0x279e << 2) + 0xff900000)
// Bit   31:18,     reserved
// Bit   17:0,     rdarb_dc_req_en     unsigned  , default = 0
//                                    rdarb_dc_req_en[0]: the slv0 req to mst port0 enable,
//                                    rdarb_dc_req_en[1]: the slv1 req to mst port0 enable,
//                                    rdarb_dc_req_en[2]: the slv2 req to mst port0 enable,
//                                    rdarb_dc_req_en[3]: the slv3 req to mst port0 enable,
//                                    rdarb_dc_req_en[4]: the slv4 req to mst port0 enable,
//                                    rdarb_dc_req_en[5]: the slv5 req to mst port0 enable,
//                                    rdarb_dc_req_en[0]: the slv0 req to mst port1 enable,
//                                    rdarb_dc_req_en[1]: the slv1 req to mst port1 enable,
//                                    rdarb_dc_req_en[2]: the slv2 req to mst port1 enable,
//                                    rdarb_dc_req_en[3]: the slv3 req to mst port1 enable,
//                                    rdarb_dc_req_en[4]: the slv4 req to mst port1 enable,
//                                    rdarb_dc_req_en[5]: the slv5 req to mst port1 enable,
#define VPU_RDARB_WEIGH0_SLV_L2C1 ((0x279f << 2) + 0xff900000)
// Bit   31:30,    reserved
// Bit   29:0,     rddc_weigh_sxn     unsigned  , default = 0
//                                    rddc_weigh_sxn[0*6+:6]: the slv0 req weigh number
//                                    rddc_weigh_sxn[1*6+:6]: the slv1 req weigh number
//                                    rddc_weigh_sxn[2*6+:6]: the slv2 req weigh number
//                                    rddc_weigh_sxn[3*6+:6]: the slv3 req weigh number
//                                    rddc_weigh_sxn[4*6+:6]: the slv4 req weigh number
#define VPU_RDARB_WEIGH1_SLV_L2C1 ((0x27a0 << 2) + 0xff900000)
// Bit   31:30,    reserved
// Bit   29:0,     rddc_weigh_sxn     unsigned  , default = 0
//                                    rddc_weigh_sxn[5*6+:6]: the slv5 req weigh number
//                                    rddc_weigh_sxn[6*6+:6]: the slv5 req weigh number
//                                    rddc_weigh_sxn[7*6+:6]: the slv5 req weigh number
//                                    rddc_weigh_sxn[8*6+:6]: the slv5 req weigh number
//                                    rddc_weigh_sxn[9*6+:6]: the slv5 req weigh number
#define VPU_RDARB_WEIGH2_SLV_L2C1 ((0x27c9 << 2) + 0xff900000)
// Bit   5:0,     rddc_weigh_sxn     unsigned  , default = 0
//                                    rddc_weigh_sxn[5*6+:6]: the slv5 req weigh number
#define VPU_RDWR_ARB_STATUS_L2C1 ((0x27a1 << 2) + 0xff900000)
// Bit   31:4,    reserved
// Bit    3:2,    wrarb_arb_busy     unsigned  , default = 0
// Bit    1:0,    rdarb_arb_busy     unsigned  , default = 0
#define VPU_WRARB_MODE_L2C1 ((0x27a2 << 2) + 0xff900000)
// Bit   31:20,    reserved
// Bit   19:16,    wrarb_sel           uns, default = 0 ,
//                                    wrarb_sel[0]==0 slave dc0 connect master port0
//                                    wrarb_sel[0]==1 slave dc0 connect master port1
//                                    wrarb_sel[1]==0 slave dc1 connect master port0
//                                    wrarb_sel[1]==1 slave dc1 connect master port1
//                                    wrarb_sel[2]==0 slave dc2 connect master port0
//                                    wrarb_sel[2]==1 slave dc2 connect master port1
//                                    wrarb_sel[3]==0 slave dc3 connect master port0
//                                    wrarb_sel[3]==1 slave dc3 connect master port1
// Bit   15:10,    reserved
// Bit   9:8,      wrarb_arb_mode      uns, default = 0 ,
//                                    wrarb_arb_mode[0] master port0 arb way,
//                                    wrarb_arb_mode[1] master port1 arb way,
// Bit   7:4,      reserved
// Bit   3:0,      wrarb_gate_clk_ctrl uns, default = 0 ,
//                                    wrarb_gate_clk_ctrl[1:0] master port0 clk gate control
//                                    wrarb_gate_clk_ctrl[3:2] master port0 clk gate control
#define VPU_WRARB_REQEN_SLV_L2C1 ((0x27a3 << 2) + 0xff900000)
// Bit   31:8,     reserved
// Bit    7:0,     wrarb_dc_req_en     unsigned  , default = 0
//                                    wrarb_dc_req_en[0]: the slv0 req to mst port0 enable,
//                                    wrarb_dc_req_en[1]: the slv1 req to mst port0 enable,
//                                    wrarb_dc_req_en[2]: the slv2 req to mst port0 enable,
//                                    wrarb_dc_req_en[3]: the slv3 req to mst port0 enable,
//                                    wrarb_dc_req_en[0]: the slv0 req to mst port1 enable,
//                                    wrarb_dc_req_en[1]: the slv1 req to mst port1 enable,
//                                    wrarb_dc_req_en[2]: the slv2 req to mst port1 enable,
//                                    wrarb_dc_req_en[3]: the slv3 req to mst port1 enable,
#define VPU_WRARB_WEIGH0_SLV_L2C1 ((0x27a4 << 2) + 0xff900000)
// Bit   31:24,    reserved
// Bit   23:0,     wrdc_weigh_sxn     unsigned  , default = 0
//                                    wrdc_weigh_sxn[0*6+:6]: the slv0 req weigh number
//                                    wrdc_weigh_sxn[1*6+:6]: the slv1 req weigh number
//                                    wrdc_weigh_sxn[2*6+:6]: the slv2 req weigh number
//                                    wrdc_weigh_sxn[3*6+:6]: the slv3 req weigh number
#define VPU_ASYNC_RD_MODE0 ((0x27a5 << 2) + 0xff900000)
// Bit   31:19,    reserved
// Bit   18,       req_en            unsigned  , default = 0  async enable
// Bit   17:16,    clk_gate_ctrl     unsigned  , default = 0  async clock gate control
// Bit   15:12,    auto_arugt_weight unsigned  , default = 4
// Bit   11,       reserved
// Bit   10:9,     arugt_sel         unsigned  , default = 0
//                                  00 : use auto fifo arugt generate the output arugt.
//                                  01 : use the register bit control
//                                  00 : use the input arguent
// Bit   8,        arguent_cfg       unsigned  , default = 0  register arguent control bit
// Bit   7:4,      rd_hold_num       unsigned  , default = 4  hold the read command threshold
// Bit   3:0,      rd_rel_num        unsigned  , default = 0  release the read command threshold
#define VPU_ASYNC_RD_MODE1 ((0x27a6 << 2) + 0xff900000)
// Bit   31:19,    reserved
// Bit   18,       req_en            unsigned  , default = 0  async enable
// Bit   17:16,    clk_gate_ctrl     unsigned  , default = 0  async clock gate control
// Bit   15:12,    auto_arugt_weight unsigned  , default = 4
// Bit   11,       reserved
// Bit   10:9,     arugt_sel         unsigned  , default = 0
//                                  00 : use auto fifo arugt generate the output arugt.
//                                  01 : use the register bit control
//                                  00 : use the input arguent
// Bit   8,        arguent_cfg       unsigned  , default = 0  register arguent control bit
// Bit   7:4,      rd_hold_num       unsigned  , default = 4  hold the read command threshold
// Bit   3:0,      rd_rel_num        unsigned  , default = 0  release the read command threshold
#define VPU_ASYNC_RD_MODE2 ((0x27a7 << 2) + 0xff900000)
// Bit   31:19,    reserved
// Bit   18,       req_en            unsigned  , default = 0  async enable
// Bit   17:16,    clk_gate_ctrl     unsigned  , default = 0  async clock gate control
// Bit   15:12,    auto_arugt_weight unsigned  , default = 4
// Bit   11,       reserved
// Bit   10:9,     arugt_sel         unsigned  , default = 0
//                                  00 : use auto fifo arugt generate the output arugt.
//                                  01 : use the register bit control
//                                  00 : use the input arguent
// Bit   8,        arguent_cfg       unsigned  , default = 0  register arguent control bit
// Bit   7:4,      rd_hold_num       unsigned  , default = 4  hold the read command threshold
// Bit   3:0,      rd_rel_num        unsigned  , default = 0  release the read command threshold
#define VPU_ASYNC_RD_MODE3 ((0x27a8 << 2) + 0xff900000)
// Bit   31:19,    reserved
// Bit   18,       req_en            unsigned  , default = 0  async enable
// Bit   17:16,    clk_gate_ctrl     unsigned  , default = 0  async clock gate control
// Bit   15:12,    auto_arugt_weight unsigned  , default = 4
// Bit   11,       reserved
// Bit   10:9,     arugt_sel         unsigned  , default = 0
//                                  00 : use auto fifo arugt generate the output arugt.
//                                  01 : use the register bit control
//                                  00 : use the input arguent
// Bit   8,        arguent_cfg       unsigned  , default = 0  register arguent control bit
// Bit   7:4,      rd_hold_num       unsigned  , default = 4  hold the read command threshold
// Bit   3:0,      rd_rel_num        unsigned  , default = 0  release the read command threshold
#define VPU_ASYNC_RD_MODE4 ((0x27a9 << 2) + 0xff900000)
// Bit   31:19,    reserved
// Bit   18,       req_en            unsigned  , default = 0  async enable
// Bit   17:16,    clk_gate_ctrl     unsigned  , default = 0  async clock gate control
// Bit   15:12,    auto_arugt_weight unsigned  , default = 4
// Bit   11,       reserved
// Bit   10:9,     arugt_sel         unsigned  , default = 0
//                                  00 : use auto fifo arugt generate the output arugt.
//                                  01 : use the register bit control
//                                  00 : use the input arguent
// Bit   8,        arguent_cfg       unsigned  , default = 0  register arguent control bit
// Bit   7:4,      rd_hold_num       unsigned  , default = 4  hold the read command threshold
// Bit   3:0,      rd_rel_num        unsigned  , default = 0  release the read command threshold
#define VPU_ASYNC_WR_MODE0 ((0x27aa << 2) + 0xff900000)
// Bit   31:19,    reserved
// Bit   18,       req_en            unsigned  , default = 0  async enable
// Bit   17:16,    clk_gate_ctrl     unsigned  , default = 0  async clock gate control
// Bit   15:12,    auto_arugt_weight unsigned  , default = 4
// Bit   11,       reserved
// Bit   10:9,     arugt_sel         unsigned  , default = 0
//                                  00 : use auto fifo arugt generate the output arugt.
//                                  01 : use the register bit control
//                                  00 : use the input arguent
// Bit   8,        arguent_cfg       unsigned  , default = 0  register arguent control bit
// Bit   7:4,      wr_hold_num       unsigned  , default = 4  hold the read command threshold
// Bit   3:0,      wr_rel_num        unsigned  , default = 0  release the write command threshold
#define VPU_ASYNC_WR_MODE1 ((0x27ab << 2) + 0xff900000)
// Bit   31:19,    reserved
// Bit   18,       req_en            unsigned  , default = 0  async enable
// Bit   17:16,    clk_gate_ctrl     unsigned  , default = 0  async clock gate control
// Bit   15:12,    auto_arugt_weight unsigned  , default = 4
// Bit   11,       reserved
// Bit   10:9,     arugt_sel         unsigned  , default = 0
//                                  00 : use auto fifo arugt generate the output arugt.
//                                  01 : use the register bit control
//                                  00 : use the input arguent
// Bit   8,        arguent_cfg       unsigned  , default = 0  register arguent control bit
// Bit   7:4,      wr_hold_num       unsigned  , default = 4  hold the read command threshold
// Bit   3:0,      wr_rel_num        unsigned  , default = 0  release the write command threshold
#define VPU_ASYNC_WR_MODE2 ((0x27ac << 2) + 0xff900000)
// Bit   31:19,    reserved
// Bit   18,       req_en            unsigned  , default = 0  async enable
// Bit   17:16,    clk_gate_ctrl     unsigned  , default = 0  async clock gate control
// Bit   15:12,    auto_arugt_weight unsigned  , default = 4
// Bit   11,       reserved
// Bit   10:9,     arugt_sel         unsigned  , default = 0
//                                  00 : use auto fifo arugt generate the output arugt.
//                                  01 : use the register bit control
//                                  00 : use the input arguent
// Bit   8,        arguent_cfg       unsigned  , default = 0  register arguent control bit
// Bit   7:4,      wr_hold_num       unsigned  , default = 4  hold the read command threshold
// Bit   3:0,      wr_rel_num        unsigned  , default = 0  release the write command threshold
#define VPU_ASYNC_STAT ((0x27ad << 2) + 0xff900000)
// Bit   31:19,    reserved
// Bit   18,       axiwr2_chan_idle  unsigned  , RO, axi write channel2 idle state
// Bit   17,       axiwr1_chan_idle  unsigned  , RO, axi write channel1 idle state
// Bit   16,       axiwr0_chan_idle  unsigned  , RO, axi write channel0 idle state
// Bit   15:5,     reserved
// Bit   4,        axird4_chan_idle  unsigned  , RO, axi read channel4 idle state
// Bit   3,        axird3_chan_idle  unsigned  , RO, axi read channel3 idle state
// Bit   2,        axird2_chan_idle  unsigned  , RO, axi read channel2 idle state
// Bit   1,        axird1_chan_idle  unsigned  , RO, axi read channel1 idle state
// Bit   0,        axird0_chan_idle  unsigned  , RO, axi read channel0 idle state
#define VPU_WRARB_MODE_L1C2 ((0x27ae << 2) + 0xff900000)
// Bit   31:18,    reserved
// Bit   17:16,    wrarb_sel           uns, default = 0 ,
//                                    wrarb_sel[0]==0 slave dc0 connect master port0
//                                    wrarb_sel[0]==1 slave dc0 connect master port1
//                                    wrarb_sel[1]==0 slave dc1 connect master port0
//                                    wrarb_sel[1]==1 slave dc1 connect master port1
// Bit   15:9,     reserved
// Bit   8,        wrarb_arb_mode      uns, default = 0 ,
//                                    wrarb_arb_mode[0] master port0 arb way,
// Bit   7:2,      reserved
// Bit   1:0,      wrarb_gate_clk_ctrl uns, default = 0 ,
//                                    wrarb_gate_clk_ctrl[1:0] master port0 clk gate control
#define VPU_WRARB_REQEN_SLV_L1C2 ((0x27af << 2) + 0xff900000)
// Bit   31:2,     reserved
// Bit    1:0,     wrarb_dc_req_en     unsigned  , default = 0
//                                    wrarb_dc_req_en[0]: the slv0 req to mst port0 enable,
//                                    wrarb_dc_req_en[1]: the slv1 req to mst port0 enable,
#define VPU_WRARB_WEIGH0_SLV_L1C2 ((0x27b0 << 2) + 0xff900000)
// Bit   31:30,    reserved
// Bit   29:0,     wrdc_weigh_sxn     unsigned  , default = 0
//                                    wrdc_weigh_sxn[0*6+:6]: the slv0 req weigh number
//                                    wrdc_weigh_sxn[1*6+:6]: the slv1 req weigh number
//                                    wrdc_weigh_sxn[2*6+:6]: the slv1 req weigh number
//                                    wrdc_weigh_sxn[3*6+:6]: the slv1 req weigh number
//                                    wrdc_weigh_sxn[4*6+:6]: the slv1 req weigh number
#define VPU_WRARB_WEIGH1_SLV_L1C2 ((0x27b1 << 2) + 0xff900000)
// Bit   31:18,    reserved
// Bit   17:0,     wrdc_weigh_sxn     unsigned  , default = 0
//                                    wrdc_weigh_sxn[5*6+:6]: the slv0 req weigh number
//                                    wrdc_weigh_sxn[6*6+:6]: the slv1 req weigh number
//                                    wrdc_weigh_sxn[7*6+:6]: the slv1 req weigh number
#define VPU_RDARB_WEIGH1_SLV_L1C2 ((0x27b2 << 2) + 0xff900000)
// Bit   31:18,    reserved
// Bit   17:0,     rddc_weigh_sxn     unsigned  , default = 0
//                                    rddc_weigh_sxn[5*6+:6]: the slv0 req weigh number
//                                    rddc_weigh_sxn[6*6+:6]: the slv1 req weigh number
//                                    rddc_weigh_sxn[7*6+:6]: the slv2 req weigh number
#define VPU_ARB_DBG_CTRL_L1C1 ((0x27b3 << 2) + 0xff900000)
#define VPU_ARB_DBG_STAT_L1C1 ((0x27b4 << 2) + 0xff900000)
#define VPU_ARB_DBG_CTRL_L1C2 ((0x27b5 << 2) + 0xff900000)
#define VPU_ARB_DBG_STAT_L1C2 ((0x27b6 << 2) + 0xff900000)
#define VPU_ARB_DBG_CTRL_L2C1 ((0x27b7 << 2) + 0xff900000)
#define VPU_ARB_DBG_STAT_L2C1 ((0x27b8 << 2) + 0xff900000)
#define VPU_ARB_PATH_CTRL ((0x27b9 << 2) + 0xff900000)
#define VPU_ARB_PATH_MAP00 ((0x27ba << 2) + 0xff900000)
#define VPU_ARB_PATH_MAP01 ((0x27bb << 2) + 0xff900000)
#define VPU_ARB_PATH_MAP02 ((0x27bc << 2) + 0xff900000)
#define VPU_ARB_PATH_MAP03 ((0x27bd << 2) + 0xff900000)
#define VPU_ARB_PATH_MAP10 ((0x27be << 2) + 0xff900000)
#define VPU_ARB_PATH_MAP11 ((0x27bf << 2) + 0xff900000)
#define VPU_ARB_PATH_MAP12 ((0x27c0 << 2) + 0xff900000)
#define VPU_ARB_PATH_MAP13 ((0x27c1 << 2) + 0xff900000)
#define VPU_RDARB_UGT_L2C1 ((0x27c2 << 2) + 0xff900000)
#define VPU_WRARB_UGT_L2C1 ((0x27c3 << 2) + 0xff900000)
#define VPU_RDARB_LIMT0_L2C1 ((0x27c4 << 2) + 0xff900000)
#define VPU_RDARB_LIMT1_L2C1 ((0x27c5 << 2) + 0xff900000)
#define VPU_ARB_AXIWR_PROT ((0x27c6 << 2) + 0xff900000)
#define VPU_ARB_AXIRD0_PROT ((0x27c7 << 2) + 0xff900000)
#define VPU_ARB_AXIRD1_PROT ((0x27c8 << 2) + 0xff900000)
#define VPU_AXI_SUBRD_ADDR ((0x2790 << 2) + 0xff900000)
//`define VPU_SUBRD_ARB_MODE         8'h90; == VPU_AXI_SUBRD_ADDR
#define VPU_SUBRD_ARB_REQEN_SLV ((0x2791 << 2) + 0xff900000)
#define VPU_SUBRD_ARB_WEIGH0_SLV ((0x2792 << 2) + 0xff900000)
#define VPU_SUBRD_ARB_WEIGH1_SLV ((0x2793 << 2) + 0xff900000)
#define VPU_SUBRD_ARB_UGT ((0x2794 << 2) + 0xff900000)
#define VPU_SUBRD_ARB_LIMT0 ((0x2795 << 2) + 0xff900000)
#define VPU_SUBRD_ARB_STATUS ((0x2796 << 2) + 0xff900000)
#define VPU_SUBRD_ARB_DBG_CTRL ((0x2797 << 2) + 0xff900000)
#define VPU_SUBRD_ARB_PROT ((0x2798 << 2) + 0xff900000)
#define VPU_SUBRD_ARB_PROT_STAT ((0x2799 << 2) + 0xff900000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpu_arb_axi_regs.h
//
// vpu lut dma
// the segment is 8'h50~8'h7f & 8'hca-8'hdf
//
// Reading file:  vpu_lut_dma_regs.h
//
// synopsys translate_off
// synopsys translate_on
// 0x50~0x7f
//
// Reading file:  viu_dma_top.h
//
#define VPU_DMA_RDMIF0_CTRL ((0x2750 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit    27        reg_rd0_frm_ctrl             // unsigned ,    RW , default = 0
// Bit    26        reg_rd0_frm_froce            // unsigned ,    RW , default = 0
// Bit 25:24        reg_rd0_frm_ini              // unsigned ,    RW , default = 0
// Bit 23:16        reg_rd0_enable_int           // unsigned ,    RW , default = 0     channel0
// select interrupt source Bit 15:13        reserved Bit 12:0         reg_rd0_stride // unsigned ,
// RW , default = 512   channel0 send number
#define VPU_DMA_RDMIF1_CTRL ((0x2751 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit    27        reg_rd1_frm_ctrl             // unsigned ,    RW , default = 0
// Bit    26        reg_rd1_frm_froce            // unsigned ,    RW , default = 0
// Bit 25:24        reg_rd1_frm_ini              // unsigned ,    RW , default = 0
// Bit 23:16        reg_rd1_enable_int           // unsigned ,    RW , default = 0     channel1
// select interrupt source Bit 15:13        reserved Bit 12:0         reg_rd1_stride // unsigned ,
// RW , default = 512   channel1 send number
#define VPU_DMA_RDMIF2_CTRL ((0x2752 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit    27        reg_rd2_frm_ctrl             // unsigned ,    RW , default = 0
// Bit    26        reg_rd2_frm_froce            // unsigned ,    RW , default = 0
// Bit 25:24        reg_rd2_frm_ini              // unsigned ,    RW , default = 0
// Bit 23:16        reg_rd2_enable_int           // unsigned ,    RW , default = 0     channel2
// select interrupt source Bit 15:13        reserved Bit 12:0         reg_rd2_stride // unsigned ,
// RW , default = 512   channel2 send number
#define VPU_DMA_RDMIF3_CTRL ((0x2753 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit    27        reg_rd3_frm_ctrl             // unsigned ,    RW , default = 0
// Bit    26        reg_rd3_frm_froce            // unsigned ,    RW , default = 0
// Bit 25:24        reg_rd3_frm_ini              // unsigned ,    RW , default = 0
// Bit 23:16        reg_rd3_enable_int           // unsigned ,    RW , default = 0     channel3
// select interrupt source Bit 15:13        reserved Bit 12:0         reg_rd3_stride // unsigned ,
// RW , default = 512   channel3 send number
#define VPU_DMA_RDMIF4_CTRL ((0x2754 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit    27        reg_rd4_frm_ctrl             // unsigned ,    RW , default = 0
// Bit    26        reg_rd4_frm_froce            // unsigned ,    RW , default = 0
// Bit 25:24        reg_rd4_frm_ini              // unsigned ,    RW , default = 0
// Bit 23:16        reg_rd4_enable_int           // unsigned ,    RW , default = 0     channel4
// select interrupt source Bit 15:13        reserved Bit 12:0         reg_rd4_stride // unsigned ,
// RW , default = 512   channel4 send number
#define VPU_DMA_RDMIF5_CTRL ((0x2755 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit    27        reg_rd5_frm_ctrl             // unsigned ,    RW , default = 0
// Bit    26        reg_rd5_frm_froce            // unsigned ,    RW , default = 0
// Bit 25:24        reg_rd5_frm_ini              // unsigned ,    RW , default = 0
// Bit 23:16        reg_rd5_enable_int           // unsigned ,    RW , default = 0     channel5
// select interrupt source Bit 15:13        reserved Bit 12:0         reg_rd5_stride // unsigned ,
// RW , default = 512   channel5 send number
#define VPU_DMA_RDMIF6_CTRL ((0x2756 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit    27        reg_rd6_frm_ctrl             // unsigned ,    RW , default = 0
// Bit    26        reg_rd6_frm_froce            // unsigned ,    RW , default = 0
// Bit 25:24        reg_rd6_frm_ini              // unsigned ,    RW , default = 0
// Bit 23:16        reg_rd6_enable_int           // unsigned ,    RW , default = 0     channel6
// select interrupt source Bit 15:13        reserved Bit 12:0         reg_rd6_stride // unsigned ,
// RW , default = 512   channel6 send number
#define VPU_DMA_RDMIF7_CTRL ((0x2757 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit    27        reg_rd7_frm_ctrl             // unsigned ,    RW , default = 0
// Bit    26        reg_rd7_frm_froce            // unsigned ,    RW , default = 0
// Bit 25:24        reg_rd7_frm_ini              // unsigned ,    RW , default = 0
// Bit 23:16        reg_rd7_enable_int           // unsigned ,    RW , default = 0     channel7
// select interrupt source Bit 15:13        reserved Bit 12:0         reg_rd7_stride // unsigned ,
// RW , default = 512   channel7 send number
#define VPU_DMA_RDMIF0_BADR0 ((0x2758 << 2) + 0xff900000)
// Bit 31:0  lut0_reg_baddr0
#define VPU_DMA_RDMIF0_BADR1 ((0x2759 << 2) + 0xff900000)
// Bit 31:0  lut0_reg_baddr1
#define VPU_DMA_RDMIF0_BADR2 ((0x275a << 2) + 0xff900000)
// Bit 31:0  lut0_reg_baddr2
#define VPU_DMA_RDMIF0_BADR3 ((0x275b << 2) + 0xff900000)
// Bit 31:0  lut0_reg_baddr3
#define VPU_DMA_RDMIF1_BADR0 ((0x275c << 2) + 0xff900000)
// Bit 31:0  lut1_reg_baddr0
#define VPU_DMA_RDMIF1_BADR1 ((0x275d << 2) + 0xff900000)
// Bit 31:0  lut1_reg_baddr1
#define VPU_DMA_RDMIF1_BADR2 ((0x275e << 2) + 0xff900000)
// Bit 31:0  lut1_reg_baddr2
#define VPU_DMA_RDMIF1_BADR3 ((0x275f << 2) + 0xff900000)
// Bit 31:0  lut1_reg_baddr3
#define VPU_DMA_RDMIF2_BADR0 ((0x2760 << 2) + 0xff900000)
// Bit 31:0  lut2_reg_baddr0
#define VPU_DMA_RDMIF2_BADR1 ((0x2761 << 2) + 0xff900000)
// Bit 31:0  lut2_reg_baddr1
#define VPU_DMA_RDMIF2_BADR2 ((0x2762 << 2) + 0xff900000)
// Bit 31:0  lut2_reg_baddr2
#define VPU_DMA_RDMIF2_BADR3 ((0x2763 << 2) + 0xff900000)
// Bit 31:0  lut2_reg_baddr3
#define VPU_DMA_RDMIF3_BADR0 ((0x2764 << 2) + 0xff900000)
// Bit 31:0  lut3_reg_baddr0
#define VPU_DMA_RDMIF3_BADR1 ((0x2765 << 2) + 0xff900000)
// Bit 31:0  lut3_reg_baddr1
#define VPU_DMA_RDMIF3_BADR2 ((0x2766 << 2) + 0xff900000)
// Bit 31:0  lut3_reg_baddr2
#define VPU_DMA_RDMIF3_BADR3 ((0x2767 << 2) + 0xff900000)
// Bit 31:0  lut3_reg_baddr3
#define VPU_DMA_RDMIF4_BADR0 ((0x2768 << 2) + 0xff900000)
// Bit 31:0  lut4_reg_baddr0
#define VPU_DMA_RDMIF4_BADR1 ((0x2769 << 2) + 0xff900000)
// Bit 31:0  lut4_reg_baddr1
#define VPU_DMA_RDMIF4_BADR2 ((0x276a << 2) + 0xff900000)
// Bit 31:0  lut4_reg_baddr2
#define VPU_DMA_RDMIF4_BADR3 ((0x276b << 2) + 0xff900000)
// Bit 31:0  lut4_reg_baddr3
#define VPU_DMA_RDMIF5_BADR0 ((0x276c << 2) + 0xff900000)
// Bit 31:0  lut5_reg_baddr0
#define VPU_DMA_RDMIF5_BADR1 ((0x276d << 2) + 0xff900000)
// Bit 31:0  lut5_reg_baddr1
#define VPU_DMA_RDMIF5_BADR2 ((0x276e << 2) + 0xff900000)
// Bit 31:0  lut5_reg_baddr2
#define VPU_DMA_RDMIF5_BADR3 ((0x276f << 2) + 0xff900000)
// Bit 31:0  lut5_reg_baddr3
#define VPU_DMA_RDMIF6_BADR0 ((0x2770 << 2) + 0xff900000)
// Bit 31:0  lut6_reg_baddr0
#define VPU_DMA_RDMIF6_BADR1 ((0x2771 << 2) + 0xff900000)
// Bit 31:0  lut6_reg_baddr1
#define VPU_DMA_RDMIF6_BADR2 ((0x2772 << 2) + 0xff900000)
// Bit 31:0  lut6_reg_baddr2
#define VPU_DMA_RDMIF6_BADR3 ((0x2773 << 2) + 0xff900000)
// Bit 31:0  lut6_reg_baddr3
#define VPU_DMA_RDMIF7_BADR0 ((0x2774 << 2) + 0xff900000)
// Bit 31:0  lut7_reg_baddr0
#define VPU_DMA_RDMIF7_BADR1 ((0x2775 << 2) + 0xff900000)
// Bit 31:0  lut7_reg_baddr1
#define VPU_DMA_RDMIF7_BADR2 ((0x2776 << 2) + 0xff900000)
// Bit 31:0  lut7_reg_baddr2
#define VPU_DMA_RDMIF7_BADR3 ((0x2777 << 2) + 0xff900000)
// Bit 31:0  lut7_reg_baddr3
//
// Closing file:  viu_dma_top.h
//
// 0x00~0x06
//`include"viu_com_rdmif_regs.h"
#define VPU_DMA_RDMIF_CTRL1 ((0x27ca << 2) + 0xff900000)
#define VPU_DMA_RDMIF_CTRL2 ((0x27cb << 2) + 0xff900000)
#define VPU_DMA_RDMIF_RO_STAT ((0x27d0 << 2) + 0xff900000)
// 0x07~0x0d
//`include"viu_com_wrmif_regs.h"
#define VPU_DMA_WRMIF_CTRL1 ((0x27d1 << 2) + 0xff900000)
#define VPU_DMA_WRMIF_CTRL2 ((0x27d2 << 2) + 0xff900000)
#define VPU_DMA_WRMIF_CTRL3 ((0x27d3 << 2) + 0xff900000)
#define VPU_DMA_WRMIF_BADDR0 ((0x27d4 << 2) + 0xff900000)
#define VPU_DMA_WRMIF_RO_STAT ((0x27d7 << 2) + 0xff900000)
#define VPU_DMA_RDMIF_CTRL ((0x27d8 << 2) + 0xff900000)
#define VPU_DMA_RDMIF_BADDR1 ((0x27d9 << 2) + 0xff900000)
#define VPU_DMA_RDMIF_BADDR2 ((0x27da << 2) + 0xff900000)
#define VPU_DMA_RDMIF_BADDR3 ((0x27db << 2) + 0xff900000)
#define VPU_DMA_WRMIF_CTRL ((0x27dc << 2) + 0xff900000)
#define VPU_DMA_WRMIF_BADDR1 ((0x27dd << 2) + 0xff900000)
#define VPU_DMA_WRMIF_BADDR2 ((0x27de << 2) + 0xff900000)
#define VPU_DMA_WRMIF_BADDR3 ((0x27df << 2) + 0xff900000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpu_lut_dma_regs.h
//
// new added 4x4 dither
// the segment is 8'hf0
#define VPU_HDMI_DITH_01_04 ((0x27f0 << 2) + 0xff900000)
#define VPU_HDMI_DITH_01_15 ((0x27f1 << 2) + 0xff900000)
#define VPU_HDMI_DITH_01_26 ((0x27f2 << 2) + 0xff900000)
#define VPU_HDMI_DITH_01_37 ((0x27f3 << 2) + 0xff900000)
#define VPU_HDMI_DITH_10_04 ((0x27f4 << 2) + 0xff900000)
#define VPU_HDMI_DITH_10_15 ((0x27f5 << 2) + 0xff900000)
#define VPU_HDMI_DITH_10_26 ((0x27f6 << 2) + 0xff900000)
#define VPU_HDMI_DITH_10_37 ((0x27f7 << 2) + 0xff900000)
#define VPU_HDMI_DITH_11_04 ((0x27f8 << 2) + 0xff900000)
#define VPU_HDMI_DITH_11_15 ((0x27f9 << 2) + 0xff900000)
#define VPU_HDMI_DITH_11_26 ((0x27fa << 2) + 0xff900000)
#define VPU_HDMI_DITH_11_37 ((0x27fb << 2) + 0xff900000)
#define VPU_HDMI_DITH_CNTL ((0x27fc << 2) + 0xff900000)
#define VPU_HDMI_TIMING_STAT ((0x27fd << 2) + 0xff900000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpu_top_regs.h
//
//===========================================================================
//  MIPI CSI2 Controller Adaptor    (16'h2a00 - 16'h2aff)
//===========================================================================
//`define  CSI2_HOST_VCBUS_BASE       8'h29
//`define  CSI2_ADPT_VCBUS_BASE       8'h2a
//`include "csi2_regs.h"
//===========================================================================
// D2D3 registers
//===========================================================================
//`define     D2D3_VCBUS_BASE         8'h2b
//
// Reading file:  d2d3_regs.h
//
//===========================================================================
// D2D3 Registers    0x - 0x
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  D2D3_VCBUS_BASE = 0x2b
// -----------------------------------------------
//------------------------------------------------------------------------------
// D2D3 top-level registers
//------------------------------------------------------------------------------
// Bit 31    RW, rd_lock_en,     1 to allow update some read-only registers based on filed
// Bit 30    RW, sw_rst_nobuf,   1 to reset the whole d2d3 unit
// Bit 29:28 RW, clk_auto_dis,   [29] DBR clock disable
//                               [28] DPG clock disable
// Bit 27:16 RW, clk_ctrl,       [27:26] gated clock control for register unit
//                               [25:24] gated clock control for DBR unit
//                               [23:22] gated clock control for LBDG unit
//                               [21:20] gated clock control for MBDG unit
//                               [19:18] gated clock control for CBDG unit
//                               [17:16] gated clock control for DBLD unit and SCD81 unit
// Bit 15:12 Reserved
// Bit 11    RW, lo_chroma_sign, 0: negate the u/v component of DBR left channel video output, 1:
// bypass Bit 10    RW, ro_chroma_sign, 0: negate the u/v component of DBR right channel video
// output, 1: bypass Bit 9     RW, vi0_chroma_sign, 0: negate the u/v component of DPG video
// input, 1: bypass Bit 8     RW, vi1_chroma_sign, 0: negate the u/v component of DBR video input,
// 1: bypass Bit 7:5   Reserved Bit 4     RW, lg_en,          Enable the LBDG unit and LBDG clock
// Bit 3     RW, mg_en,          Enable the MBDG unit and MBDG clock
// Bit 2     RW, cg_en,          Enable the CBDG unit and CBDG clock
// Bit 1     RW, dbr_en,         Enable the DBR unit and DBR clock
// Bit 0     RW, dpg_en,         Enable the DPG unit and clock except sub-unit CBDG, MBDG and LBDG
#define D2D3_GLB_CTRL ((0x2b00 << 2) + 0xff900000)
// Indicate the input picture size in DPG unit
// Bit 31:16 RW, szx_vi_m1,      The horizontal size minus 1
// Bit 15:0  RW, szy_vi_m1,      The vertical size minus 1
#define D2D3_DPG_INPIC_SIZE ((0x2b01 << 2) + 0xff900000)
// Indicate the output picture size in DBR unit
// Bit 31:16 RW, szx_vo_m1,      The horizontal size minus 1
// Bit 15:0  RW, szy_vo_m1,      The vertical size minus 1
#define D2D3_DBR_OUTPIC_SIZE ((0x2b02 << 2) + 0xff900000)
// Indicate the rectangular window to generate the "depth" in DPG unit
// Bit 31:16 RW, dg_win_x_start, Horizontal start position, count from 0
// Bit 15:0  RW, dg_win_x_end,   Horizontal end position, count from 0
#define D2D3_DGEN_WIN_HOR ((0x2b03 << 2) + 0xff900000)
// Indicate the rectangular window to generate the "depth" in DPG unit
// Bit 31:16 RW, dg_win_y_start, Vertical start position, count from 0
// Bit 15:0  RW, dg_win_y_end,   Vertical end position, count from 0
#define D2D3_DGEN_WIN_VER ((0x2b04 << 2) + 0xff900000)
//------------------------------------------------------------------------------
// CBDG SCU18 SCD81 SCD81_PRE registers
// cg: color based depth generate module
// scu18: scale up module
// scd81: scale down module
// scd81_pre: scd81 pre-scale-down module
//------------------------------------------------------------------------------
// Indicate parameters of pre-scale-down unit
// Bit 31:16 RW, scd81_hphs_step, horizontal step
// Bit 15:0  RW, scd81_hphs_ini, horizontal initial phase
#define D2D3_PRE_SCD_H ((0x2b05 << 2) + 0xff900000)
// Bit 31:16 RW, scu18_iniph,    initial phase in SCU18,
//                               [23:16] indicate the horizontal phase offset from the first data
//                               of every line [31:24] indicate the vertical phase offset from the
//                               first line of every frame
// Bit 15:12 Reserved
// Bit 11    RW, scd81_predrop_en, 1 to enable scd81 pre-scale-down function
// Bit 10:9  RW, cg_csc_sel,     Color Space Conversion(CSC) matrix mode selector in CBDG
//                               0: BT.601 (16-235/240)
//                               1: BT.709 (16-235/240)
//                               2: BT.601 (0-255)
//                               3: BT.709 (0-255)
// Bit 8     RW, scu18_rep_en,   1 to double each line of the SCU18 output
// Bit 7:4   RW, scu18_factor,   up-scale factor in SCU18 on DBR input depth data
//                               [7:6] for vertical, 0->1:1, 1->1:2, 2->1:4, 3->1:8
//                               [5:4] for horizontal, 0->1:1, 1->1:2, 2->1:4, 3->1:8
// Bit 3:0   RW, scd81_factor,   down-scale factor in SCD81 on DPG source video
//                               [3:2] for vertical, 0->1:1, 1->2:1, 2->4:1, 3->8:1
//                               [1:0] for horizontal, 0->1:1, 1->2:1, 2->4:1, 3->8:1
#define D2D3_SCALER_CTRL ((0x2b06 << 2) + 0xff900000)
// Bit 31:24 RW, cg_rpg_dth,     the down |r-g| threshold for sky detect
// Bit 23:16 RW, cg_rpg_uth,     the up |r-g| threshold for sky detect
// Bit 15:8  RW, cg_lum_dth,     the down Y threshold for sky detect
// Bit 7:0   RW, cg_lum_uth,     the up Y threshold for sky detect
#define D2D3_CG_THRESHOLD_1 ((0x2b07 << 2) + 0xff900000)
// Bit 31:24 RW, cg_rpb_dth,     the down |r-b| threshold for sky detect
// Bit 23:16 RW, cg_rpb_uth,     the up |r-b| threshold for sky detect
// Bit 15:8  RW, cg_bpg_dth,     the down |b-g| threshold for sky detect
// Bit 7:0   RW, cg_bpg_uth,     the up |b-g| threshold for sky detect
#define D2D3_CG_THRESHOLD_2 ((0x2b08 << 2) + 0xff900000)
// Bit 31:24 RW, cg_vp_rel_k,    parameter to calculate vanish point reliability
// Bit 23:16 RW, cg_vp_y_thr,    the max limitation to calculate the vanish-point's vertical
// position Bit 15:8  RW, cg_meet_dval,   signed depth value in the sky-bitmap Bit 7:0   RW,
// cg_unmt_dval,   signed depth value not in the sky-bitmap
#define D2D3_CG_PARAM_1 ((0x2b09 << 2) + 0xff900000)
// Bit 31:16 RW, cg_vpos_thr,    Maximal vertical limitation for sky-bit map when cg_vpos_en=1 and
// cg_vpos_adpt_en=0 Bit 15:8  Reserved Bit 7     RW, cg_vpos_en,     1 to enable the max vertical
// limitation for sky-bitmap Bit 6     RW, cg_vpos_adpt_en, 1 to enable the adaptive max vertical
// limitation for sky-bitmap.
//                               It is only valid when cg_vpos_en=1.
//                               The max vertical limitation is the previous field's vanish-point
//                               (vertical position) if cg_vpos_adpt_en=1.
// Bit 5:4   RW, cg_lpf_bypass,  bypass of low pass filter
//                               [5]:Vertical bypass, 1: bypass the vertical LPF on the CBDG depth
//                               [4]:Horizontal bypass, 1: bypass the horizontal LPF on the CBDG
//                               depth
// Bit 3:0   RW, cg_vp_rel_s,    parameter to calculate vanish point reliability
#define D2D3_CG_PARAM_2 ((0x2b0a << 2) + 0xff900000)
// Indicate parameters of pre-scale-down unit
// Bit 31:16 RW, scd81_vphs_step, vertical step
// Bit 15:0  RW, scd81_vphs_ini, vertical initial phase
#define D2D3_PRE_SCD_V ((0x2b0b << 2) + 0xff900000)
//------------------------------------------------------------------------------
// D2P registers
// d2p: depth to parallax transform module
//------------------------------------------------------------------------------
// Bit 31:24 RW, d2p_brdwid,     Horizontal boundary width for parallax, the parallax value would
// be forced to 0 in boundary,
//                               the d2p_brdwid should not 0 when D2P_WRAP is enabled
// Bit 23:22 Reserved
// Bit 21:20 RW, d2p_lomode,     line output mode,
//                               0:whole line is left or right;  1:whole line is left or right;
//                               2:left/right pixel interleaved;  3:left/right half-line
//                               interleaved
// Bit 19    RW, d2p_neg,        1 to exchange the left and right parallax value
// Bit 18    Reserved
// Bit 17    RW, d2p_wrap_en,    1 to enable D2P_WRAP unit
// Bit 16    RW, d2p_lar,        Indicate the first output for left or right, 0: left; 1: right
// Bit 15    RW, d2p_lr_switch,  enable left/right flag filed switch automatically, only valid
// when parallax output mode is field interleaved Bit 14    RW, d2p_1dtolr,     enable to generate
// 2 parallax data (left and right) from one depth Bit 13:12 RW, d2p_out_mode,   Parallax output
// mode
//                               0:left/right pixel interleaved; 1:line or half line interleaved;
//                               2:field interleaved
// Bit 11:8  RW, d2p_smode,      Shift mode,
//                               0: no shift; 1: enable left shift;
//                               2: enable right shift; 3: both left and right shift are enabled
// Bit 7:0   RW, d2p_offset,     depth offset, signed,
#define D2D3_D2P_PARAM_1 ((0x2b0c << 2) + 0xff900000)
// Bit 31:24 RW, d2p_pg0,        positive parallax gain when Parallax value < pt
// Bit 23:16 RW, d2p_pg1,        positive parallax gain when Parallax value >= pt
// Bit 15:8  RW, d2p_pt,         unsigned value used to separate the positive parallax range
// Bit 7:0   RW, d2p_plimit,     The limitation for positive parallax
#define D2D3_D2P_PARAM_2 ((0x2b0d << 2) + 0xff900000)
// Bit 31:24 RW, d2p_ng0,        negative parallax gain when Parallax value > -nt
// Bit 23:16 RW, d2p_ng1,        negative parallax gain when Parallax value <= -nt
// Bit 15:8  RW, d2p_nt,         unsigned value used to separate the negative parallax range
// Bit 7:0   RW, d2p_nlimit,     The limitation for negative parallax
#define D2D3_D2P_PARAM_3 ((0x2b0e << 2) + 0xff900000)
// Indicate step parameters of SCU18 unit
// Bit 31:17 Reserved
// Bit 16    RW, scu18_step_en,   step set enable in SCU18
// Bit 15:8  RW, scu18_hphs_step, horizontal step in SCU18
// Bit 7:0   RW, scu18_vphs_step, vertical step in SCU18
#define D2D3_SCU18_STEP ((0x2b0f << 2) + 0xff900000)
//------------------------------------------------------------------------------
// LBDG and DBLD registers
// lg: luma based depth generate module
// db: depth blending module
//------------------------------------------------------------------------------
// Bit 31:22 Reserved
// Bit 21:20 RW, db_lpf_bpcoeff, [21]:Vertical factor of low pass filter,
//                               1: Vfactor = 0/0/64/0/0, 0: Vfactor =
//                               {db_vf_a,db_vf_b,db_vf_c,db_vf_b,db_vf_a}, see D2D3_CTRL_15
//                               [20]:Horizontal factor of low pass filter,
//                               1: Hfactor = 0/0/64/0/0, 0: Hfactor =
//                               {db_hf_a,db_hf_b,db_hf_c,db_hf_b,db_hf_a}, see D2D3_CTRL_14
// Bit 19:18 RW, lg_lpf_bpcoeff, [19]:Vertical factor of low pass filter, 1: Vfactor = 0/64/0, 0:
// Vfactor = 20/24/20
//                               [18]:Horizontal factor of low pass filter, 1: Hfactor = 0/64/0,
//                               0: Hfactor = 16/32/16
// Bit 17:16 RW, cg_lpf_bpcoeff, [17]:Vertical factor of low pass filter, 1: Vfactor = 0/64/0, 0:
// Vfactor = 20/24/20
//                               [16]:Horizontal factor of low pass filter, 1: Hfactor = 0/64/0,
//                               0: Hfactor = 16/32/16
// Bit 15:10 Reserved
// Bit 9:8   RW, db_lpf_bypass,  [9] 1 to bypass the vertical LPF on the DBLD depth
//                               [8] 1 to bypass the horizontal LPF on the DBLD depth
// Bit 7:6   RW, lg_lpf_bypass,  [7] 1 to bypass the vertical LPF on the LBDG depth
//                               [6] 1 to bypass the horizontal LPF on the LBDG depth
// Bit 5:0   RW, lg_kc,          gain of CPL(v-u+256-y) to calculate the depth in LBDG
#define D2D3_DPF_LPF_CTRL ((0x2b10 << 2) + 0xff900000)
//------------------------------------------------------------------------------
// DBLD registers
// db: depth blending module
//------------------------------------------------------------------------------
// Bit 31:24 RW, db_g2_cg,       gain of CBDG depth in DBLD
// Bit 23:16 RW, db_o2_cg,       offset of CBDG depth in DBLD
// Bit 15:8  RW, db_g1_cg,       gain of CBDG depth using for summary in DBLD
// Bit 7:0   RW, db_o1_cg,       offset of CBDG depth using for summary in DBLD
#define D2D3_DBLD_CG_PARAM ((0x2b11 << 2) + 0xff900000)
// Bit 31:24 RW, db_g2_mg,       gain of MBDG depth in DBLD
// Bit 23:16 RW, db_o2_mg,       offset of MBDG depth in DBLD
// Bit 15:8  RW, db_g1_mg,       gain of MBDG depth using for summary in DBLD
// Bit 7:0   RW, db_o1_mg,       offset of MBDG depth using for summary in DBLD
#define D2D3_DBLD_MG_PARAM ((0x2b12 << 2) + 0xff900000)
// Bit 31:24 RW, db_g2_lg,       gain of LBDG depth in DBLD
// Bit 23:16 RW, db_o2_lg,       offset of LBDG depth in DBLD
// Bit 15:8  RW, db_g1_lg,       gain of LBDG depth using for summary in DBLD
// Bit 7:0   RW, db_o1_lg,       offset of LBDG depth using for summary in DBLD
#define D2D3_DBLD_LG_PARAM ((0x2b13 << 2) + 0xff900000)
// Bit 31:24 RW, db_factor,      unsigned gain of difference in DBLD
// Bit 23:16 RW, db_hf_a,        see register DPF_LPF_CTRL:db_lpf_bpcoeff, sign
// Bit 15:8  RW, db_hf_b,        see register DPF_LPF_CTRL:db_lpf_bpcoeff, sign
// Bit 7:0   RW, db_hf_c,        see register DPF_LPF_CTRL:db_lpf_bpcoeff, sign
#define D2D3_DBLD_LPF_HCOEFF ((0x2b14 << 2) + 0xff900000)
// Bit 31:24 RW, db_owin_fill,   signed depth value outside the rectangular window defined in
// register DGEN_WIN_HOR and DGEN_WIN_VER Bit 23:16 RW, db_vf_a,        see register
// DPF_LPF_CTRL:db_lpf_bpcoeff, sign Bit 15:8  RW, db_vf_b,        see register
// DPF_LPF_CTRL:db_lpf_bpcoeff, sign Bit 7:0   RW, db_vf_c,        see register
// DPF_LPF_CTRL:db_lpf_bpcoeff, sign
#define D2D3_DBLD_LPF_VCOEFF ((0x2b15 << 2) + 0xff900000)
// Bit 31:28 RW, hist_depth_idx,
// Bit 27:26 Reserved
// Bit 25    RW, mbdg_dep_neg,   1 to negate the output data of MBDG
// Bit 24    RW, lbdg_dep_neg,   1 to negate the output data of LBDG
// Bit 23:16 RW, db_f1_ctrl,     MUX1 selector
//                               [1:0] MUX1 path1 selector, 0:summary, 1:CBDG, 2:MBDG, 3:LBDG
//                               [3:2] MUX1 path2 selector, 0:summary, 1:CBDG, 2:MBDG, 3:LBDG
//                               [6:4] MUX1 out1 selector, 1:CBDG, 2:MBDG, 3:LBDG, 4:summary,
//                               5:MUX1out0, others:summary [7] MUX1OUT0 selector, 0:MIN
//                               (MUX1PATH1,MUX1Path2), 1:MAX (MUX1Path1,MUX1Path2)
// Bit 15:8  RW, db_f2_ctrl,     MUX2 selector
//                               [1:0] MUX2 path1 selector, 0:MUX1OUT1, 1:CBDG, 2:MBDG, 3:LBDG
//                               [3:2] MUX2 path2 selector, 0:MUX1OUT1, 1:CBDG, 2:MBDG, 3:LBDG
//                               [6:4] MUX2 out1 selector, 1:CBDG, 2:MBDG, 3:LBDG, 4:summary,
//                               5:MUX2out0, others:MUX2out0 [7] MUX2OUT0 selector, 0:MIN
//                               (MUX2PATH1,MUX2Path2), 1:MAX (MUX2Path1,MUX2Path2)
// Bit 7:4   RW, db_fifo0_sel,   the source input of FIFO0
//                               0: no use; 1:from CBDG; 2:from MBDG; 3:from LBDG others:reserved
// Bit 3:0   RW, db_fifo1_sel,   the source input of FIFO1
//                               0: no use; 1:from CBDG; 2:from MBDG; 3:from LBDG 4: from FIFO0;
//                               others:reserved
#define D2D3_DBLD_PATH_CTRL ((0x2b16 << 2) + 0xff900000)
// Indicate the input picture size in SCU18 unit
// Bit 31:16 RW, szy_scui,       The vertical size
// Bit 15:0  RW, szx_scui,       The horizontal size
#define D2D3_SCU18_INPIC_SIZE ((0x2b17 << 2) + 0xff900000)
//------------------------------------------------------------------------------
// MBDG registers
// mg: model based depth generate module
//------------------------------------------------------------------------------
// Bit 31:18 Reserved
// Bit 17    RW, mg_vp_en,       mdg vanish point enable, not used
// Bit 16    RW, mg_sw_en,       1 to use the software forced parameter for the point D, U and C
// in MBDG Bit 15:8  RW, mg_owin_fill,   Signed depth value outside the rectangular window defined
// in register DGEN_WIN_HOR and DGEN_WIN_VER Bit 7     RW, mg_iir_en,      1 to enable the 2-taps
// IIR filter in MBDG Bit 6:0   RW, mg_iir,         [6]: 1 to bypass the 2-taps IIR filter in MBDG
//                               [5:0]:Unsigned coefficient of the 2-taps IIR filter in MBDG
//                               [6]:bypass, 1:bypass, 0:not bypass
#define D2D3_MBDG_CTRL ((0x2b18 << 2) + 0xff900000)
// Bit 31:28 RW, mg_dtl_pxl_left, Max pixel number (1<< mg_dtl_pxl_left) using in the left window
// for activities in MBDG Bit 27:24 RW, mg_dtl_pxl_right, Max pixel number (1<< mg_dtl_pxl_right)
// using in the right window for activities in MBDG Bit 23:16 RW, mg_cx_sw,       Depth of point C
// in horizontal curve in MBDG for software forced Bit 15:8  RW, mg_ux_sw,       Depth of point U
// in horizontal curve in MBDG for software forced Bit 7:0   RW, mg_dx_sw,       Depth of point D
// in horizontal curve in MBDG for software forced
#define D2D3_MBDG_PARAM_0 ((0x2b19 << 2) + 0xff900000)
// Bit 31:28 RW, mg_dtl_pxl_up,  Max pixel number (1<< mg_dtl_pxl_up) using in the top window for
// activities in MBDG Bit 27:24 RW, mg_dtl_pxl_dn,  Max pixel number (1<< mg_dtl_pxl_dn) using in
// the bottom window for activities in MBDG Bit 23:16 RW, mg_cy_sw,       Depth of point C in
// vertical curve in MBDG for software forced Bit 15:8  RW, mg_uy_sw,       Depth of point U in
// vertical curve in MBDG for software forced Bit 7:0   RW, mg_dy_sw,       Depth of point D in
// vertical curve in MBDG for software forced
#define D2D3_MBDG_PARAM_1 ((0x2b1a << 2) + 0xff900000)
// Bit 31:24 RW, mg_dtl_ln_up,   Line number in the top window for activities in MBDG
// Bit 23:16 RW, mg_dtl_ln_dn,   Line number in the bottom window for activities in MBDG
// Bit 15:8  RW, mg_dtl_ln_left, Column number in the left window for activities in MBDG
// Bit 7:0   RW, mg_dtl_ln_right,Column number in the right window for activities in MBDG
#define D2D3_MBDG_PARAM_2 ((0x2b1b << 2) + 0xff900000)
// Bit 31:24 RW, mg_y_max,       Software initial depth of point D and U in vertical curve
// Bit 23:16 RW, mg_y_min,       Software initial depth of point C in vertical curve
// Bit 15:8  RW, mg_x_max,       Software initial depth of point D and U in horizontal curve
// Bit 7:0   RW, mg_x_min,       Software initial depth of point C in horizontal curve
#define D2D3_MBDG_PARAM_3 ((0x2b1c << 2) + 0xff900000)
// Bit 31:27 Reserved
// Bit 26    RW, mg_y_adapt_en,  1 to enable the adaptive mode for point U/D in vertical curve
// calculation Bit 25    RW, mg_xmm_adapt_en, 1 to enable the XMM adaptive mode for point U/D in
// horizontal curve calculation Bit 24    RW, mg_x_adapt_en,  1 to enable the adaptive mode for
// point U/D in horizontal curve calculation Bit 23:20 RW, mg_ytrans_1,    Shifter controller in
// vertical curve calculation, if mg_xtrans_1<0, right shift abs(mg_xtrans_1) bits, others left
// shift abs(mg_xtrans_1) bits Bit 19:16 RW, mg_xtrans_1,    Shifter controller in horizontal
// curve calculation, if mg_xtrans_1<0, right shift abs(mg_xtrans_1) bits, others left shift
// abs(mg_xtrans_1) bits Bit 15:8  RW, mg_yk_0,        The based activities value of the ACT for
// vertical curve Bit 7:0   RW, mg_xk_0,        The based activities value of the ACT for
// horizontal curve
#define D2D3_MBDG_PARAM_4 ((0x2b1d << 2) + 0xff900000)
// Bit 31:24 RW, mg_ysu3,        Quantized value 3 in vertical curve adaptive calculation
// Bit 23:16 RW, mg_ysu2,        Quantized value 2 in vertical curve adaptive calculation
// Bit 15:8  RW, mg_ysu1,        Quantized value 1 in vertical curve adaptive calculation
// Bit 7:0   RW, mg_ysu0,        Quantized value 0 in vertical curve adaptive calculation
#define D2D3_MBDG_PARAM_5 ((0x2b1e << 2) + 0xff900000)
// Bit 31:24 RW, mg_xsu3,        Quantized value 3 in horizontal curve adaptive calculation
// Bit 23:16 RW, mg_xsu2,        Quantized value 2 in horizontal curve adaptive calculation
// Bit 15:8  RW, mg_xsu1,        Quantized value 1 in horizontal curve adaptive calculation
// Bit 7:0   RW, mg_xsu0,        Quantized value 0 in horizontal curve adaptive calculation
#define D2D3_MBDG_PARAM_6 ((0x2b1f << 2) + 0xff900000)
// Bit 31:16 Reserved
// Bit 15:8  RW, mg_xsu4,        Quantized value 4 in horizontal curve adaptive calculation
// Bit 7:0   RW, mg_ysu4,        Quantized value 4 in vertical curve adaptive calculation
#define D2D3_MBDG_PARAM_7 ((0x2b20 << 2) + 0xff900000)
// Bit 31:28 RW, dbg_hscnt_sel   see DBG_STATUS_2
// Bit 27:25 Reserved
// Bit 24    RW, dbg_dbr_en,     1 to enable debug mode in DBR
// Bit 23:16 RW, dbg_force_data, Forced data in debug mode
// Bit 15:12 RW, dbg_bld_ctrl,   debug controller for DBLD
//                               [12]:enable;  [13]: 0 for passive mode, 0 for handshake mode
//                               [15:14]: 0 for constant mode, 1 for step1 mode
// Bit 11:8  RW, dbg_mg_ctrl,    debug controller for MBDG
//                               [8]:enable;  [9]: 0 for passive mode, 0 for handshake mode
//                               [11:10]: 0 for constant mode, 1 for step1 mode
// Bit 7:4   RW, dbg_cg_ctrl,    debug controller for CBDG
//                               [4]:enable;  [5]: 0 for passive mode, 0 for handshake mode
//                               [7:6]: 0 for constant mode, 1 for step1 mode
// Bit 3:0   RW, dbg_lg_ctrl,    debug controller for LBDG
//                               [0]:enable;  [1]: 0 for passive mode, 0 for handshake mode
//                               [3:2]: 0 for constant mode, 1 for step1 mode
#define D2D3_DBG_CTRL ((0x2b23 << 2) + 0xff900000)
//------------------------------------------------------------------------------
// DWMIF registers
//------------------------------------------------------------------------------
// Bit 31:18 Reserved
// Bit 17    RW, dw_x_rev        0: Normal write data from left to right in horizontal
//                               1: Reversed write data from left to right in horizontal
// Bit 16    RW, dw_y_rev        0: Normal write data from top to bottom in horizontal
//                               1: Reversed write data from bottom to top in horizontal
// Bit 15    RW, dw_done_clr     1 to clear register depw_done (DWMIF_STATUS)
// Bit 14    RW, dw_little_endian, 0: data is ordered in big-endian, 1: little endian
// Bit 13:12 RW, dw_pic_struct,  0:read every line, 1:reserved, 2:read even line, 3:read odd line
// Bit 11    RW, dw_urgent,      urgent index
// Bit 10    RW, dw_clr_wrrsp,   1:clear the write fifo counter
// Bit 9     RW, dw_canvas_wr,   canvas write initialization again
// Bit 8     RW, dw_req_en,      1 to enable write request
// Bit 7:0   RW, dw_canvas_index,Canvas index for the MSB of memory address for memory write
#define D2D3_DWMIF_CTRL ((0x2b24 << 2) + 0xff900000)
// Bit 31    Reserved
// Bit 30:16 RW, dw_end_x,       Horizontal end position for memory write, count by BYTE
// Bit 15    Reserved
// Bit 14:0  RW, dw_start_x,     Horizontal start position for memory write, count by BYTE
#define D2D3_DWMIF_HPOS ((0x2b25 << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, dw_end_y,       Vertical end position for memory write, count by BYTE
// Bit 15:13 Reserved
// Bit 12:0  RW, dw_start_y,     Vertical start position for memory write, count by BYTE
#define D2D3_DWMIF_VPOS ((0x2b26 << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, dw_vsizem1,     Vertical size for memory write, equal the size minus 1
// Bit 15:12 Reserved
// Bit 11:0  RW, dw_hsizem1,     Horizontal size for memory write, equal the size minus 1
#define D2D3_DWMIF_SIZE ((0x2b27 << 2) + 0xff900000)
//------------------------------------------------------------------------------
// DRMIF registers
//------------------------------------------------------------------------------
// Bit 31:18 Reserved
// Bit 17    RW, dr_y_rev,       0: Normal Read data from top to bottom in horizontal
//                               1: Reversed read data from bottom to top in horizontal
// Bit 16    RW, dr_x_rev,       0: Normal Read data from left to right in horizontal
//                               1: Reversed read data from right to left in horizontal
// Bit 15    RW, dr_clr_fifo_error, 1 to clear the overflow flag of the sticky FIFO
// Bit 14    RW, dr_little_endian, 0: data is ordered in big-endian; 1: little-endian
// Bit 13:12 RW, dr_pic_struct,  0: progressive;  1: Reserved;
//                               2: interlaced, even line;  3: interlaced, odd line
// Bit 11    RW, dr_urgent,      urgent index, no use in this system
// Bit 10:9  RW, dr_burst_size,  Burst read length for each request; 0=24,1=32,2=48,3=64
// Bit 8     RW, dr_req_en,      1 to enable read request
// Bit 7:0   RW, dr_canvas_index, Canvas index for the MSB of memory address for memory read
#define D2D3_DRMIF_CTRL ((0x2b28 << 2) + 0xff900000)
// Bit 31    Reserved
// Bit 30:16 RW, dr_end_x,       Horizontal end position for memory read, count by BYTE
// Bit 15    Reserved
// Bit 14:0  RW, dr_start_x,     Horizontal start position for memory read, count by BYTE
#define D2D3_DRMIF_HPOS ((0x2b29 << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, dr_end_y,       Vertical end position for memory read, count by BYTE
// Bit 15:13 Reserved
// Bit 12:0  RW, dr_start_y,     Vertical start position for memory read, count by BYTE
#define D2D3_DRMIF_VPOS ((0x2b2a << 2) + 0xff900000)
//------------------------------------------------------------------------------
// PDR registers
// ddd: parallax based render
//------------------------------------------------------------------------------
// Bit 31:8  Reserved
// Bit 7     RW, ddd_brdlpf_en,  1 to enable the smooth filter on the depth around the boundary
// Bit 6     RW, ddd_extn_black, 1 to enable the function to fill black colour when interpolated
// pixels is outside the picture in DBR Bit 5     RW, ddd_wrap_en,    Reserved Bit 4     RW,
// ddd_hhalf,      1 to indicate the left/right line length is a half of original line. Bit 3:2
// RW, ddd_out_mode,   Reserved Bit 1:0   RW, ddd_lomode,     wrap & pbr interleave mode:
//                               2'b0x: whole line is left or right;
//                               2'b10: d2p_lar=1(D2P_PARAM_1), rlrlrlrl inteleave in one line,
//                                      d2p_lar=0(D2P_PARAM_1), lrlrlrlr inteleave in one line,
//                               2'b11: d2p_lar=1(D2P_PARAM_1), rrrrrlllll, half line is right,
//                               another half is left,
//                                      d2p_lar=0(D2P_PARAM_1), lllllrrrrr, half line is left,
//                                      another half is right,
#define D2D3_DBR_DDD_CTRL ((0x2b2c << 2) + 0xff900000)
// Bit 31:0  RW, ddd_dbg_ctrl,   no use
#define D2D3_DBR_DDD_DBG ((0x2b2d << 2) + 0xff900000)
//------------------------------------------------------------------------------
// LRDMX registers
//------------------------------------------------------------------------------
// Bit 31:9  Reserved
// Bit 8     RW, lr_merge,       1: all the left/right input go to the left channel output
// Bit 7:6   RW, lrd_ff0_sel,    FF0 source selector
//                               0:from left input; 1:from right input; 2:from FF0; 3:no used
// Bit 5:4   RW, lrd_ff1_sel,    FF1 source selector
//                               0:from left input; 1:from right input; 2:from FF0; 3:no used
// Bit 3:2   RW, lrd_lout_sel,   left channel DEMUX
//                               00: ff0  01:ff1   10: left input  11:right input
// Bit 1:0   RW, lrd_rout_sel,   right channel DEMUX
//                               00: ff1  01:ff0   10: left input  11:right input
#define D2D3_DBR_LRDMX_CTRL ((0x2b2f << 2) + 0xff900000)
//------------------------------------------------------------------------------
// Read Only registers
//------------------------------------------------------------------------------
// Bit 31:24 RO, ro_cg_vprel,    vanish point's reliability in CBDG
// Bit 23:12 RO, ro_cg_vpx,      vanish point's X-Axis in CBDG
// Bit 11:0  RO, ro_cg_vpy,      vanish point's Y-Axis in CBDG
#define D2D3_CBDG_STATUS_1 ((0x2b30 << 2) + 0xff900000)
// Bit 31:24 RO, ro_mg_cx[7:0],  X-Axis of point C in horizontal curve in MBDG
// Bit 23:16 RO, ro_mg_ux,       Depth value of point U in horizontal curve in MBDG
// Bit 15:8  RO, ro_mg_dx,       Depth value of point D in horizontal curve in MBDG
// Bit 7:0   RO, ro_mg_minx,     Depth value of point C in horizontal curve in MBDG
#define D2D3_MBDG_STATUS_1 ((0x2b31 << 2) + 0xff900000)
// Bit 31:24 RO, ro_mg_cy[7:0],  X-Axis of point C in vertical curve in MBDG
// Bit 23:16 RO, ro_mg_uy,       Depth value of point U in vertical curve in MBDG
// Bit 15:8  RO, ro_mg_dy,       Depth value of point D in vertical curve in MBDG
// Bit 7:0   RO, ro_mg_miny,     Depth value of point C in vertical curve in MBDG
#define D2D3_MBDG_STATUS_2 ((0x2b32 << 2) + 0xff900000)
// Bit 31    RO, ro_wrap_status, 1 indicate the D2P_WRAP is busy to perform the initialization
// Bit 30:8  Reserved
// Bit 7:4   RO, ro_mg_cy[11:8], X-Axis of point C in vertical curve in MBDG
// Bit 3:0   RO, ro_mg_cx[11:8], X-Axis of point C in horizontal curve in MBDG
#define D2D3_MBDG_STATUS_3 ((0x2b33 << 2) + 0xff900000)
// Bit 31:21 Reserved
// Bit 20:0  RO, ro_mg_sum_u,    ACT(top): activities of the top part
#define D2D3_MBDG_STATUS_4 ((0x2b34 << 2) + 0xff900000)
// Bit 31:21 Reserved
// Bit 20:0  RO, ro_mg_sum_d,    ACT(bottom): activities of the bottom part
#define D2D3_MBDG_STATUS_5 ((0x2b35 << 2) + 0xff900000)
// Bit 31:21 Reserved
// Bit 20:0  RO, ro_mg_sum_l,    ACT(left): activities of the left part
#define D2D3_MBDG_STATUS_6 ((0x2b36 << 2) + 0xff900000)
// Bit 31:21 Reserved
// Bit 20:0  RO, ro_mg_sum_r,    ACT(right): activities of the right part
#define D2D3_MBDG_STATUS_7 ((0x2b37 << 2) + 0xff900000)
// Bit 31:0 dbg_handshake_ro0,   handshake signal for debug, internal srdy and rrdy
#define D2D3_DBG_STATUS_1 ((0x2b38 << 2) + 0xff900000)
// Bit 31:0 dbg_hscnt,           dbg_hscnt_sel == 4'h0, output lg hscnt
//                               dbg_hscnt_sel == 4'h1, output cg hscnt
//                               dbg_hscnt_sel == 4'h2, output mg hscnt
//                               dbg_hscnt_sel == 4'h3, output bld hscnt
//                               dbg_hscnt_sel == other value, output 32'h0
#define D2D3_DBG_STATUS_2 ((0x2b39 << 2) + 0xff900000)
// Bit 31:0 RO, drmif_status,    drmif module internal status
#define D2D3_DRMIF_STATUS ((0x2b3a << 2) + 0xff900000)
// Bit 31:2 RO, Reserved
// Bit 1:0  RO, d2d3_status0,    [1]: depw_done, one field depth write to ddr has done
//                               [0]: dwmif_pending_ddr_wrrsp, 1 to indicate write response from
//                               ddr
#define D2D3_DWMIF_STATUS ((0x2b3b << 2) + 0xff900000)
// Bit 31:24 Reserved
// Bit 23:0  RO, ro_meet_sum,    register sumxy_sum_dbg in CBDG
#define D2D3_CBDG_STATUS_2 ((0x2b3c << 2) + 0xff900000)
// Bit 31:20 Reserved
// Bit 19:0  RO, ro_hist_depth,
#define D2D3_DBLD_STATUS ((0x2b3d << 2) + 0xff900000)
// Bit 31:0 Reserved
#define D2D3_RESEV_STATUS1 ((0x2b3e << 2) + 0xff900000)
// Bit 31:0  Reserved
#define D2D3_RESEV_STATUS2 ((0x2b3f << 2) + 0xff900000)
//
// Closing file:  d2d3_regs.h
//
//===========================================================================
//  MIPI DSI Host Controller        (16'h2c00 - 16'h2cff)
//===========================================================================
//`define  DSI_VCBUS_BASE             8'h2c
//`include "dsi_regs.h"
//===========================================================================
//  ISP register    (16'h2d00 - 16'h2dff)
//===========================================================================
//`define ISP_VCBUS_BASE                   8'h2d todo
//`include "isp_reg.h"
//===========================================================================
//`define MADB_VCBUS_BASE                8'h2d
//===========================================================================
//
// Reading file:  vpu_dnr_regs.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// CBUS_BASE:  MADB_VCBUS_BASE = 0x2d
// -----------------------------------------------
#define DNR_CTRL ((0x2d00 << 2) + 0xff900000)
// Bit 31:17,        reserved
// Bit 16,            reg_dnr_en		                                , dnr enable .
// unsigned  , default = 1 Bit 15,            reg_dnr_db_vdbstep                          , vdb
// step, 0: 4, 1: 8        . unsigned  , default = 1 Bit 14,            reg_dnr_db_vdbprten , vdb
// protectoin enable       . unsigned  , default = 1 Bit 13,            reg_dnr_gbs_difen , enable
// dif (between LR and LL/RR) condition for gbs stat.. unsigned  , default = 0 Bit 12,
// reg_dnr_luma_en                             , enable ycbcr2luma module    . unsigned  , default
// = 1 Bit 11:10,        reg_dnr_db_mod                              , deblocking mode, 0:
// disable, 1: horizontal deblocking, 2: vertical deblocking, 3: horizontal & vertical deblocking.
// unsigned , default = 3 Bit  9,            reg_dnr_db_chrmen                           , enable
// chroma deblocking    . unsigned  , default = 1 Bit  8,            reg_dnr_hvdif_mod , 0: calc.
// difs by original Y, 1: by new luma. unsigned  , default = 1 Bit  7,            reserved Bit  6:
// 4, reg_dnr_demo_lften                          , b0: Y b1:U b2:V             . unsigned  ,
// default = 7 Bit  3,            reserved Bit  2: 0,        reg_dnr_demo_rgten , b0: Y b1:U b2:V
// . unsigned  , default = 7
#define DNR_HVSIZE ((0x2d01 << 2) + 0xff900000)
// Bit 31:29,        reserved
// Bit 28:16,        reg_dnr_hsize                               , hsize                       .
// unsigned  , default = 0 Bit 15:13,        reserved Bit 12: 0,        reg_dnr_vsize , vsize .
// unsigned  , default = 0
#define DNR_DBLK_BLANK_NUM ((0x2d02 << 2) + 0xff900000)
// Bit 31:16,        reserved
// Bit 15: 8,        reg_dblk_hblank_num                         , deblock hor blank num       .
// unsigned  , default = 16 Bit  7: 0,        reg_dblk_vblank_num                         ,
// deblock ver blank num       . unsigned  , default = 45
#define DNR_BLK_OFFST ((0x2d03 << 2) + 0xff900000)
// Bit 31: 7,        reserved
// Bit  6: 4,        reg_dnr_hbofst                              , horizontal block offset may
// provide by software calc.. unsigned  , default = 0 Bit  3,            reserved Bit  2: 0,
// reg_dnr_vbofst                              , vertical block offset may provide by software
// calc.. unsigned  , default = 0
#define DNR_GBS ((0x2d04 << 2) + 0xff900000)
// Bit 31: 2,        reserved
// Bit  1: 0,        reg_dnr_gbs                                 , global block strength may
// update by software calc.. unsigned  , default = 0
#define DNR_HBOFFST_STAT ((0x2d05 << 2) + 0xff900000)
// Bit 31:24,        reg_dnr_hbof_difthd                         , dif threshold (>=) between LR
// and LL/RR. unsigned  , default = 2 Bit 23:16,        reg_dnr_hbof_edgethd , edge threshold (<=)
// for LR  . unsigned  , default = 32 Bit 15: 8,        reg_dnr_hbof_flatthd , flat threshold (>=)
// for LR  . unsigned  , default = 0 Bit  7,            reserved Bit  6: 4, reg_dnr_hbof_delta ,
// delta for weighted bin accumulator. unsigned  , default = 1 Bit  3,            reserved Bit  2:
// 0,        reg_dnr_hbof_statmod                        , statistic mode for horizontal block
// offset, 0: count flags for 8-bin, 1: count LRs for 8-bin, 2: count difs for 8-bin, 3: count
// weighted flags for 8-bin, 4: count flags for first 32-bin, 5: count LRs for first 32-bin, 6 or
// 7: count difs for first 32-bin. unsigned  , default = 2
#define DNR_VBOFFST_STAT ((0x2d06 << 2) + 0xff900000)
// Bit 31:24,        reg_dnr_vbof_difthd                         , dif threshold (>=) between Up
// and Dw. unsigned  , default = 1 Bit 23:16,        reg_dnr_vbof_edgethd                        ,
// edge threshold (<=) for Up/Dw. unsigned  , default = 16 Bit 15: 8,        reg_dnr_vbof_flatthd
// , flat threshold (>=) for Up/Dw. unsigned  , default = 0 Bit  7,            reserved Bit  6: 4,
// reg_dnr_vbof_delta                          , delta for weighted bin accumulator. unsigned  ,
// default = 1 Bit  3,            reserved Bit  2: 0,        reg_dnr_vbof_statmod , statistic mode
// for vertical block offset, 0: count flags for 8-bin, 1: count Ups for 8-bin, 2: count difs for
// 8-bin, 3: count weighted flags for 8-bin, 4: count flags for first 32-bin, 5: count Ups for
// first 32-bin, 6 or 7: count difs for first 32-bin. unsigned  , default = 2
#define DNR_GBS_STAT ((0x2d07 << 2) + 0xff900000)
// Bit 31:24,        reg_dnr_gbs_edgethd                         , edge threshold (<=) for LR  .
// unsigned  , default = 32 Bit 23:16,        reg_dnr_gbs_flatthd                         , flat
// threshold (>=) for LR  . unsigned  , default = 0 Bit 15: 8,        reg_dnr_gbs_varthd ,
// variation threshold (<=) for Lvar/Rvar. unsigned  , default = 16 Bit  7: 0, reg_dnr_gbs_difthd
// , dif threshold (>=) between LR and LL/RR. unsigned  , default = 2
#define DNR_STAT_X_START_END ((0x2d08 << 2) + 0xff900000)
// Bit 31:30,        reserved
// Bit 29:16,        reg_dnr_stat_xst                                                          .
// unsigned  , default = 24 Bit 15:14,        reserved Bit 13: 0,        reg_dnr_stat_xed .
// unsigned  , default = HSIZE - 25
#define DNR_STAT_Y_START_END ((0x2d09 << 2) + 0xff900000)
// Bit 31:30,        reserved
// Bit 29:16,        reg_dnr_stat_yst                                                          .
// unsigned  , default = 24 Bit 15:14,        reserved Bit 13: 0,        reg_dnr_stat_yed .
// unsigned  , default = VSIZE - 25
#define DNR_LUMA ((0x2d0a << 2) + 0xff900000)
// Bit 31:27,        reserved
// Bit 26:24,        reg_dnr_luma_sqrtshft                       , left shift for fast squart of
// chroma, [0, 4]. unsigned  , default = 2 Bit 23:21,        reserved Bit 20:16,
// reg_dnr_luma_sqrtoffst                      , offset for fast squart of chroma. signed    ,
// default = 0 Bit 15,            reserved Bit 14:12,        reg_dnr_luma_wcmod , theta related to
// warm/cool segment line, 0: 0, 1: 45, 2: 90, 3: 135, 4: 180, 5: 225, 6: 270, 7: 315. . unsigned
// , default = 3 Bit 11: 8,        reg_dnr_luma_cshft                          , shift for calc.
// delta part, 0~8,  . unsigned  , default = 8 Bit  7: 6,        reserved Bit  5: 0,
// reg_dnr_luma_cgain                          , final gain for delta part, 32 normalized to "1".
// unsigned  , default = 4
#define DNR_DB_YEDGE_THD ((0x2d0b << 2) + 0xff900000)
// Bit 31:24,        reg_dnr_db_yedgethd0                        , edge threshold0 for luma    .
// unsigned  , default = 12 Bit 23:16,        reg_dnr_db_yedgethd1                        , edge
// threshold1 for luma    . unsigned  , default = 15 Bit 15: 8,        reg_dnr_db_yedgethd2 , edge
// threshold2 for luma    . unsigned  , default = 18 Bit  7: 0,        reg_dnr_db_yedgethd3 , edge
// threshold3 for luma    . unsigned  , default = 25
#define DNR_DB_CEDGE_THD ((0x2d0c << 2) + 0xff900000)
// Bit 31:24,        reg_dnr_db_cedgethd0                        , edge threshold0 for chroma  .
// unsigned  , default = 12 Bit 23:16,        reg_dnr_db_cedgethd1                        , edge
// threshold1 for chroma  . unsigned  , default = 15 Bit 15: 8,        reg_dnr_db_cedgethd2 , edge
// threshold2 for chroma  . unsigned  , default = 18 Bit  7: 0,        reg_dnr_db_cedgethd3 , edge
// threshold3 for chroma  . unsigned  , default = 25
#define DNR_DB_HGAP ((0x2d0d << 2) + 0xff900000)
// Bit 31:24,        reserved
// Bit 23:16,        reg_dnr_db_hgapthd                          , horizontal gap thd (<=) for
// very sure blockiness . unsigned  , default = 8 Bit 15: 8,        reg_dnr_db_hgapdifthd , dif
// thd between hgap and lft/rgt hdifs. unsigned  , default = 1 Bit  7: 1,        reserved Bit  0,
// reg_dnr_db_hgapmod                          , horizontal gap calc. mode, 0: just use current
// col x, 1: find max between (x-1, x, x+1) . unsigned  , default = 0
#define DNR_DB_HBS ((0x2d0e << 2) + 0xff900000)
// Bit 31: 6,        reserved
// Bit  5: 4,        reg_dnr_db_hbsup                            , horizontal bs up value      .
// unsigned  , default = 1 Bit  3: 2,        reg_dnr_db_hbsmax                           , max
// value of hbs for global control. unsigned  , default = 3 Bit  1: 0,        reg_dnr_db_hgbsthd ,
// gbs thd (>=) for hbs calc.  . unsigned  , default = 1
#define DNR_DB_HACT ((0x2d0f << 2) + 0xff900000)
// Bit 31:16,        reserved
// Bit 15: 8,        reg_dnr_db_hactthd0                         , thd0 of hact, for block
// classification. unsigned  , default = 10 Bit  7: 0,        reg_dnr_db_hactthd1 , thd1 of hact,
// for block classification. unsigned  , default = 32
#define DNR_DB_YHDELTA_GAIN ((0x2d10 << 2) + 0xff900000)
// Bit 31:27,        reserved
// Bit 26:24,        reg_dnr_db_yhdeltagain1                     , (p1-q1) gain for Y's delta
// calc. when bs=1, normalized 8 as "1" . unsigned  , default = 2 Bit 23,            reserved Bit
// 22:20,        reg_dnr_db_yhdeltagain2                     , (p1-q1) gain for Y's delta calc.
// when bs=2, normalized 8 as "1" . unsigned  , default = 0 Bit 19,            reserved Bit 18:16,
// reg_dnr_db_yhdeltagain3                     , (p1-q1) gain for Y's delta calc. when bs=3,
// normalized 8 as "1" . unsigned  , default = 0 Bit 15,            reserved Bit 14: 8,
// reg_dnr_db_yhdeltaadjoffst                  , offset for adjust Y's hdelta (-64, 63). signed ,
// default = 0 Bit  7: 6,        reserved Bit  5: 0,        reg_dnr_db_yhdeltaadjgain , gain for
// adjust Y's hdelta, normalized 32 as "1" . unsigned  , default = 32
#define DNR_DB_YHDELTA2_GAIN ((0x2d11 << 2) + 0xff900000)
// Bit 31:30,        reserved
// Bit 29:24,        reg_dnr_db_yhdelta2gain2                    , gain for bs=2's adjust Y's
// hdelta2, normalized 64 as "1" . unsigned  , default = 8 Bit 23:21,        reserved Bit 20:16,
// reg_dnr_db_yhdelta2offst2                   , offset for bs=2's adjust Y's hdelta2 (-16, 15).
// signed    , default = 0 Bit 15:14,        reserved Bit 13: 8,        reg_dnr_db_yhdelta2gain3 ,
// gain for bs=3's adjust Y's hdelta2, normalized 64 as "1" . unsigned  , default = 4 Bit  7: 5,
// reserved Bit  4: 0,        reg_dnr_db_yhdelta2offst3                   , offset for bs=3's
// adjust Y's hdelta2 (-16, 15). signed    , default = 0
#define DNR_DB_CHDELTA_GAIN ((0x2d12 << 2) + 0xff900000)
// Bit 31:27,        reserved
// Bit 26:24,        reg_dnr_db_chdeltagain1                     , (p1-q1) gain for UV's delta
// calc. when bs=1, normalized 8 as "1". unsigned  , default = 2 Bit 23,            reserved Bit
// 22:20,        reg_dnr_db_chdeltagain2                     , (p1-q1) gain for UV's delta calc.
// when bs=2, normalized 8 as "1". unsigned  , default = 0 Bit 19,            reserved Bit 18:16,
// reg_dnr_db_chdeltagain3                     , (p1-q1) gain for UV's delta calc. when bs=3,
// normalized 8 as "1". unsigned  , default = 0 Bit 15,            reserved Bit 14: 8,
// reg_dnr_db_chdeltaadjoffst                  , offset for adjust UV's hdelta (-64, 63). signed ,
// default = 0 Bit  7: 6,        reserved Bit  5: 0,        reg_dnr_db_chdeltaadjgain , gain for
// adjust UV's hdelta, normalized 32 as "1". unsigned  , default = 32
#define DNR_DB_CHDELTA2_GAIN ((0x2d13 << 2) + 0xff900000)
// Bit 31:30,        reserved
// Bit 29:24,        reg_dnr_db_chdelta2gain2                    , gain for bs=2's adjust UV's
// hdelta2, normalized 64 as "1" . unsigned  , default = 8 Bit 23:21,        reserved Bit 20:16,
// reg_dnr_db_chdelta2offst2                   , offset for bs=2's adjust UV's hdelta2 (-16, 15).
// signed    , default = 0 Bit 15:14,        reserved Bit 13: 8,        reg_dnr_db_chdelta2gain3 ,
// gain for bs=2's adjust UV's hdelta2, normalized 64 as "1" . unsigned  , default = 4 Bit  7: 5,
// reserved Bit  4: 0,        reg_dnr_db_chdelta2offst3                   , offset for bs=2's
// adjust UV's hdelta2 (-16, 15). signed    , default = 0
#define DNR_DB_YC_VEDGE_THD ((0x2d14 << 2) + 0xff900000)
// Bit 31:16,        reserved
// Bit 15: 8,        reg_dnr_db_yvedgethd                        , special Y's edge thd for vdb.
// unsigned  , default = 12 Bit  7: 0,        reg_dnr_db_cvedgethd                        ,
// special UV's edge thd for vdb. unsigned  , default = 12
#define DNR_DB_VBS_MISC ((0x2d15 << 2) + 0xff900000)
// Bit 31:24,        reg_dnr_db_vgapthd                          , vertical gap thd (<=) for very
// sure blockiness . unsigned  , default = 8 Bit 23:16,        reg_dnr_db_vactthd , thd of vact,
// for block classification . unsigned  , default = 10 Bit 15: 8,        reg_dnr_db_vgapdifthd ,
// dif thd between vgap and vact. unsigned  , default = 4 Bit  7: 4,        reserved Bit  3: 2,
// reg_dnr_db_vbsmax                           , max value of vbs for global control. unsigned  ,
// default = 2 Bit  1: 0,        reg_dnr_db_vgbsthd                          , gbs thd (>=) for
// vbs calc.  . unsigned  , default = 1
#define DNR_DB_YVDELTA_GAIN ((0x2d16 << 2) + 0xff900000)
// Bit 31:30,        reserved
// Bit 29:24,        reg_dnr_db_yvdeltaadjgain                   , gain for adjust Y's vdelta,
// normalized 32 as "1". unsigned  , default = 32 Bit 23,            reserved Bit 22:16,
// reg_dnr_db_yvdeltaadjoffst                  , offset for adjust Y's vdelta (-64, 63). signed ,
// default = 0 Bit 15:14,        reserved Bit 13: 8,        reg_dnr_db_yvdelta2gain , gain for
// adjust Y's vdelta2, normalized 64 as "1". unsigned  , default = 8 Bit  7: 5,        reserved
// Bit 4: 0,        reg_dnr_db_yvdelta2offst                    , offset for adjust Y's vdelta2
// (-16, 15). signed    , default = 0
#define DNR_DB_CVDELTA_GAIN ((0x2d17 << 2) + 0xff900000)
// Bit 31:30,        reserved
// Bit 29:24,        reg_dnr_db_cvdeltaadjgain                   , gain for adjust UV's vdelta,
// normalized 32 as "1". unsigned  , default = 32 Bit 23,            reserved Bit 22:16,
// reg_dnr_db_cvdeltaadjoffst                  , offset for adjust UV's vdelta (-64, 63). signed ,
// default = 0 Bit 15:14,        reserved Bit 13: 8,        reg_dnr_db_cvdelta2gain , gain for
// adjust UV's vdelta2, normalized 64 as "1". unsigned  , default = 8 Bit  7: 5,        reserved
// Bit  4: 0,        reg_dnr_db_cvdelta2offst                    , offset for adjust UV's vdelta2
// (-16, 15). signed    , default = 0
#define DNR_RO_GBS_STAT_LR ((0x2d18 << 2) + 0xff900000)
// Bit 31: 0,        ro_gbs_stat_lr                                                            .
// unsigned  , default = 0
#define DNR_RO_GBS_STAT_LL ((0x2d19 << 2) + 0xff900000)
// Bit 31: 0,        ro_gbs_stat_ll                                                            .
// unsigned  , default = 0
#define DNR_RO_GBS_STAT_RR ((0x2d1a << 2) + 0xff900000)
// Bit 31: 0,        ro_gbs_stat_rr                                                            .
// unsigned  , default = 0
#define DNR_RO_GBS_STAT_DIF ((0x2d1b << 2) + 0xff900000)
// Bit 31: 0,        ro_gbs_stat_dif                                                           .
// unsigned  , default = 0
#define DNR_RO_GBS_STAT_CNT ((0x2d1c << 2) + 0xff900000)
// Bit 31: 0,        ro_gbs_stat_cnt                                                           .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_0 ((0x2d1d << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt0                                                         .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_1 ((0x2d1e << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt1                                                         .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_2 ((0x2d1f << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt2                                                         .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_3 ((0x2d20 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt3                                                         .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_4 ((0x2d21 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt4                                                         .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_5 ((0x2d22 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt5                                                         .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_6 ((0x2d23 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt6                                                         .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_7 ((0x2d24 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt7                                                         .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_8 ((0x2d25 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt8                                                         .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_9 ((0x2d26 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt9                                                         .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_10 ((0x2d27 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt10                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_11 ((0x2d28 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt11                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_12 ((0x2d29 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt12                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_13 ((0x2d2a << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt13                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_14 ((0x2d2b << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt14                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_15 ((0x2d2c << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt15                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_16 ((0x2d2d << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt16                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_17 ((0x2d2e << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt17                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_18 ((0x2d2f << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt18                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_19 ((0x2d30 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt19                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_20 ((0x2d31 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt20                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_21 ((0x2d32 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt21                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_22 ((0x2d33 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt22                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_23 ((0x2d34 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt23                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_24 ((0x2d35 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt24                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_25 ((0x2d36 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt25                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_26 ((0x2d37 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt26                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_27 ((0x2d38 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt27                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_28 ((0x2d39 << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt28                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_29 ((0x2d3a << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt29                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_30 ((0x2d3b << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt30                                                        .
// unsigned  , default = 0
#define DNR_RO_HBOF_STAT_CNT_31 ((0x2d3c << 2) + 0xff900000)
// Bit 31: 0,        ro_hbof_stat_cnt31                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_0 ((0x2d3d << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt0                                                         .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_1 ((0x2d3e << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt1                                                         .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_2 ((0x2d3f << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt2                                                         .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_3 ((0x2d40 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt3                                                         .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_4 ((0x2d41 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt4                                                         .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_5 ((0x2d42 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt5                                                         .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_6 ((0x2d43 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt6                                                         .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_7 ((0x2d44 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt7                                                         .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_8 ((0x2d45 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt8                                                         .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_9 ((0x2d46 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt9                                                         .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_10 ((0x2d47 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt10                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_11 ((0x2d48 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt11                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_12 ((0x2d49 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt12                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_13 ((0x2d4a << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt13                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_14 ((0x2d4b << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt14                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_15 ((0x2d4c << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt15                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_16 ((0x2d4d << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt16                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_17 ((0x2d4e << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt17                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_18 ((0x2d4f << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt18                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_19 ((0x2d50 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt19                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_20 ((0x2d51 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt20                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_21 ((0x2d52 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt21                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_22 ((0x2d53 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt22                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_23 ((0x2d54 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt23                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_24 ((0x2d55 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt24                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_25 ((0x2d56 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt25                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_26 ((0x2d57 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt26                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_27 ((0x2d58 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt27                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_28 ((0x2d59 << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt28                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_29 ((0x2d5a << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt29                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_30 ((0x2d5b << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt30                                                        .
// unsigned  , default = 0
#define DNR_RO_VBOF_STAT_CNT_31 ((0x2d5c << 2) + 0xff900000)
// Bit 31: 0,        ro_vbof_stat_cnt31                                                        .
// unsigned  , default = 0
#define DNR_DM_ADP_EN ((0x2d5d << 2) + 0xff900000)
// Bit 31: 8        reserved
// Bit  7           reg_dnr_scene_change_flg    // unsigned , default = 1  , scence change flag
// for dnr(dm); Bit  6           reg_dnr_dm_lpf_en           // unsigned , default = 1  , enable
// lpf for demosquito filter Bit  5           reg_dnr_dm_adp_level_en     // unsigned , default =
// 1 , enable adptive demosquito level Bit  4           reg_dnr_dm_flg2bdif_en      // unsigned ,
// default = 1  , enable edge flg to blkdif calc. Bit  3: 2        reg_dnr_dm_edgeiir          //
// unsigned , default = 1  , edge flag iir mode, 0: cur, 1: max(pre, cur), 2: choice 0/1 by org
// mtn, 3: choice 0/1 by ref mtn Bit  1           reg_dnr_dm_dirdifmod        // unsigned ,
// default = 1  , dif mode for direction calc, 0: abs(dif02), 1: (abs(dif01)+abs(dif21))/2 Bit  0
// reg_dnr_dm_sur_dir_mod      // unsigned , default = 0  , sure direction mode for cordif calc.
#define DNR_DM_EDGE_DIR ((0x2d5e << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_dnr_dm_dirdifcor        // unsigned , default = 2  , dif coring threshold
// for direction calc Bit 15: 8        reg_dnr_dm_edgecordifthd    // unsigned , default = 160  ,
// edge flg down when cordif is large than threshold Bit  7: 0        reg_dnr_dm_mtnrt // unsigned
// , default = 60  , motion ratio for mtn decision
#define DNR_DM_CTRL ((0x2d60 << 2) + 0xff900000)
// Bit 31:13,        reserved
// Bit 12,            reg_dnr_dm_fedgeflg_en                      , enable edge flag calc. of each
// frame. unsigned  , default = 1 Bit 11,            reg_dnr_dm_fedgeflg_cl                      ,
// clear frame edge flag if needed. unsigned  , default = 1 Bit 10, reg_dnr_dm_fedgeflg_df , user
// defined edge when reg_dnr_dm_fedgeflg_en=0, default = 1 Bit  9,            reg_dnr_dm_en ,
// enable demosquito function  . unsigned  , default = 1 Bit  8,            reg_dnr_dm_chrmen ,
// enable chrome processing for demosquito. unsigned  , default = 1 Bit  7: 6, reg_dnr_dm_level ,
// demosquito level            . unsigned  , default = 3 Bit  5: 4,        reg_dnr_dm_leveldw0 ,
// level down when gbs is small. unsigned  , default = 1 Bit  3: 2,        reg_dnr_dm_leveldw1 ,
// level down for no edge/flat blocks. unsigned  , default = 1 Bit  1: 0,        reg_dnr_dm_gbsthd
// , small/large threshold for gbs (<=). unsigned  , default = 0
#define DNR_DM_NR_BLND ((0x2d61 << 2) + 0xff900000)
// Bit 31:25,        reserved
// Bit 24,            reg_dnr_dm_defalpen                         , enable user define alpha for
// dm & nr blend. unsigned  , default = 0 Bit 23:16,        reg_dnr_dm_defalp , user define alpha
// for dm & nr blend if enable. unsigned  , default = 0 Bit 15:14,        reserved Bit 13: 8,
// reg_dnr_dm_alpgain                          , gain for nr/dm alpha, normalized 32 as "1".
// unsigned  , default = 32 Bit  7: 0,        reg_dnr_dm_alpoffst                         , (-128,
// 127), offset for nr/dm alpha. signed    , default = 0
#define DNR_DM_RNG_THD ((0x2d62 << 2) + 0xff900000)
// Bit 31:24,        reserved
// Bit 23:16,        reg_dnr_dm_rngminthd                                                      .
// unsigned  , default = 2 Bit 15: 8,        reg_dnr_dm_rngmaxthd . unsigned  , default = 64 Bit
// 7: 0,        reg_dnr_dm_rngdifthd                                                      .
// unsigned , default = 4
#define DNR_DM_RNG_GAIN_OFST ((0x2d63 << 2) + 0xff900000)
// Bit 31:14,        reserved
// Bit 13: 8,        reg_dnr_dm_rnggain                          , normalized 16 as "1"        .
// unsigned  , default = 16 Bit  7: 6,        reserved Bit  5: 0,        reg_dnr_dm_rngofst .
// unsigned  , default = 0
#define DNR_DM_DIR_MISC ((0x2d64 << 2) + 0xff900000)
// Bit 31:30,        reserved
// Bit 29,            reg_dnr_dm_diralpen                                                       .
// unsigned  , default = 1 Bit 28:24,        reg_dnr_dm_diralpgain . unsigned  , default = 0 Bit
// 23:22,        reserved Bit 21:16,        reg_dnr_dm_diralpofst . unsigned  , default = 0 Bit
// 15:13,        reserved Bit 12: 8,        reg_dnr_dm_diralpmin . unsigned  , default = 0 Bit  7:
// 5,        reserved Bit  4: 0,        reg_dnr_dm_diralpmax . unsigned  , default = 31
#define DNR_DM_COR_DIF ((0x2d65 << 2) + 0xff900000)
// Bit 31: 4,        reserved
// Bit  3: 1,        reg_dnr_dm_cordifshft                                                     .
// unsigned  , default = 3 Bit  0,            reg_dnr_dm_cordifmod                        , 0:use
// max dir dif as cordif, 1: use max3x3 - min3x3 as cordif. unsigned  , default = 1
#define DNR_DM_FLT_THD ((0x2d66 << 2) + 0xff900000)
// Bit 31:24,        reg_dnr_dm_fltthd00                         , block flat threshold0 for block
// average difference when gbs is small, for flat block detection. unsigned  , default = 4 Bit
// 23:16,        reg_dnr_dm_fltthd01                         , block flat threshold1 for block
// average difference when gbs is small, for flat block detection. unsigned  , default = 6 Bit 15:
// 8,        reg_dnr_dm_fltthd10                         , block flat threshold0 for block average
// difference when gbs is large, for flat block detection. unsigned  , default = 9 Bit  7: 0,
// reg_dnr_dm_fltthd11                         , block flat threshold1 for block average
// difference when gbs is large, for flat block detection. unsigned  , default = 12
#define DNR_DM_VAR_THD ((0x2d67 << 2) + 0xff900000)
// Bit 31:24,        reg_dnr_dm_varthd00                         , block variance threshold0 (>=)
// when gbs is small, for flat block detection. unsigned  , default = 2 Bit 23:16,
// reg_dnr_dm_varthd01                         , block variance threshold1 (<=) when gbs is small,
// for flat block detection. unsigned  , default = 15 Bit 15: 8,        reg_dnr_dm_varthd10 ,
// block variance threshold0 (>=) when gbs is large, for flat block detection. unsigned  , default
// = 3 Bit  7: 0,        reg_dnr_dm_varthd11                         , block variance threshold1
// (<=) when gbs is large, for flat block detection. unsigned  , default = 24
#define DNR_DM_EDGE_DIF_THD ((0x2d68 << 2) + 0xff900000)
// Bit 31:24,        reg_dnr_dm_edgethd0                         , block edge threshold (<=) when
// gbs is small, for flat block detection. unsigned  , default = 32 Bit 23:16, reg_dnr_dm_edgethd1
// , block edge threshold (<=) when gbs is large, for flat block detection. unsigned  , default =
// 48 Bit 15: 8,        reg_dnr_dm_difthd0                          , block dif threshold (<=)
// when gbs is small, for flat block detection. unsigned  , default = 48 Bit  7: 0,
// reg_dnr_dm_difthd1 , block dif threshold (<=) when gbs is large, for flat block detection.
// unsigned  , default = 64
#define DNR_DM_AVG_THD ((0x2d69 << 2) + 0xff900000)
// Bit 31:16,        reserved
// Bit 15: 8,        reg_dnr_dm_avgthd0                          , block average threshold (>=),
// for flat block detection. unsigned  , default = 160 Bit  7: 0,        reg_dnr_dm_avgthd1 ,
// block average threshold (<=), for flat block detection. unsigned  , default = 128
#define DNR_DM_AVG_VAR_DIF_THD ((0x2d6a << 2) + 0xff900000)
// Bit 31:16,        reserved
// Bit 15: 8,        reg_dnr_dm_avgdifthd                        , block average dif threshold (<)
// between cur and up block, for flat block detection. unsigned  , default = 12 Bit  7: 0,
// reg_dnr_dm_vardifthd                        , block variance dif threshold (>=) between cur and
// up block, for flat block detection. unsigned  , default = 1
#define DNR_DM_VAR_EDGE_DIF_THD2 ((0x2d6b << 2) + 0xff900000)
// Bit 31:24,        reserved
// Bit 23:16,        reg_dnr_dm_varthd2                          , block variance threshold (>=),
// for edge block detection. unsigned  , default = 24 Bit 15: 8,        reg_dnr_dm_edgethd2 ,
// block edge threshold (>=), for edge block detection. unsigned  , default = 40 Bit  7: 0,
// reg_dnr_dm_difthd2                          , block dif threshold (>=), for edge block
// detection. unsigned  , default = 80
#define DNR_DM_DIF_FLT_MISC ((0x2d6c << 2) + 0xff900000)
// Bit 31:28,        reg_dnr_dm_ldifoob                          , pre-defined large dif when
// pixel out of blocks. unsigned  , default = 0 Bit 27:24,        reg_dnr_dm_bdifoob , pre-defined
// block dif when pixel out of blocks;. unsigned  , default = 0 Bit 23:16, reg_dnr_dm_fltalp ,
// pre-defined alpha for dm and nr blending, when block is flat with mos.. unsigned  , default =
// 200 Bit 15:12,        reserved Bit 11: 8,        reg_dnr_dm_fltminbdif                       ,
// pre-defined min block dif for dm filter, when block is flat with mos.. unsigned  , default = 12
// Bit  7,            reserved
// Bit  6: 2,        reg_dnr_dm_difnormgain                      , gain for pixel dif
// normalization for dm filter, normalized 16 as "1". unsigned  , default = 16 Bit  1,
// reg_dnr_dm_difnormen                        , enable pixel dif normalization for dm filter.
// unsigned  , default = 1 Bit  0,            reg_dnr_dm_difupden                         , enable
// block dif update using max of left, cur, right difs. unsigned  , default = 0
#define DNR_DM_SDIF_LUT0_2 ((0x2d6d << 2) + 0xff900000)
// Bit 31:21,        reserved
// Bit 20:16,        reg_dnr_dm_sdiflut0                         , normally 0-16               .
// unsigned  , default = 16 Bit 15:13,        reserved Bit 12: 8,        reg_dnr_dm_sdiflut1 ,
// normally 0-16               . unsigned  , default = 14 Bit  7: 5,        reserved Bit  4: 0,
// reg_dnr_dm_sdiflut2                         , normally 0-16               . unsigned  , default
// = 13
#define DNR_DM_SDIF_LUT3_5 ((0x2d6e << 2) + 0xff900000)
// Bit 31:21,        reserved
// Bit 20:16,        reg_dnr_dm_sdiflut3                         , normally 0-16               .
// unsigned  , default = 10 Bit 15:13,        reserved Bit 12: 8,        reg_dnr_dm_sdiflut4 ,
// normally 0-16               . unsigned  , default = 7 Bit  7: 5,        reserved Bit  4: 0,
// reg_dnr_dm_sdiflut5                         , normally 0-16               . unsigned  , default
// = 5
#define DNR_DM_SDIF_LUT6_8 ((0x2d6f << 2) + 0xff900000)
// Bit 31:21,        reserved
// Bit 20:16,        reg_dnr_dm_sdiflut6                         , normally 0-16               .
// unsigned  , default = 3 Bit 15:13,        reserved Bit 12: 8,        reg_dnr_dm_sdiflut7 ,
// normally 0-16               . unsigned  , default = 1 Bit  7: 5,        reserved Bit  4: 0,
// reg_dnr_dm_sdiflut8                         , normally 0-16               . unsigned  , default
// = 0
#define DNR_DM_LDIF_LUT0_2 ((0x2d70 << 2) + 0xff900000)
// Bit 31:21,        reserved
// Bit 20:16,        reg_dnr_dm_ldiflut0                         , normally 0-16               .
// unsigned  , default = 0 Bit 15:13,        reserved Bit 12: 8,        reg_dnr_dm_ldiflut1 ,
// normally 0-16               . unsigned  , default = 4 Bit  7: 5,        reserved Bit  4: 0,
// reg_dnr_dm_ldiflut2                         , normally 0-16               . unsigned  , default
// = 12
#define DNR_DM_LDIF_LUT3_5 ((0x2d71 << 2) + 0xff900000)
// Bit 31:21,        reserved
// Bit 20:16,        reg_dnr_dm_ldiflut3                         , normally 0-16               .
// unsigned  , default = 14 Bit 15:13,        reserved Bit 12: 8,        reg_dnr_dm_ldiflut4 ,
// normally 0-16               . unsigned  , default = 15 Bit  7: 5,        reserved Bit  4: 0,
// reg_dnr_dm_ldiflut5                         , normally 0-16               . unsigned  , default
// = 16
#define DNR_DM_LDIF_LUT6_8 ((0x2d72 << 2) + 0xff900000)
// Bit 31:21,        reserved
// Bit 20:16,        reg_dnr_dm_ldiflut6                         , normally 0-16               .
// unsigned  , default = 16 Bit 15:13,        reserved Bit 12: 8,        reg_dnr_dm_ldiflut7 ,
// normally 0-16               . unsigned  , default = 16 Bit  7: 5,        reserved Bit  4: 0,
// reg_dnr_dm_ldiflut8                         , normally 0-16               . unsigned  , default
// = 16
#define DNR_DM_DIF2NORM_LUT0_2 ((0x2d73 << 2) + 0xff900000)
// Bit 31:21,        reserved
// Bit 20:16,        reg_dnr_dm_dif2normlut0                     , normally 0-16               .
// unsigned  , default = 16 Bit 15:13,        reserved Bit 12: 8,        reg_dnr_dm_dif2normlut1 ,
// normally 0-16               . unsigned  , default = 5 Bit  7: 5,        reserved Bit  4: 0,
// reg_dnr_dm_dif2normlut2                     , normally 0-16               . unsigned  , default
// = 3
#define DNR_DM_DIF2NORM_LUT3_5 ((0x2d74 << 2) + 0xff900000)
// Bit 31:21,        reserved
// Bit 20:16,        reg_dnr_dm_dif2normlut3                     , normally 0-16               .
// unsigned  , default = 2 Bit 15:13,        reserved Bit 12: 8,        reg_dnr_dm_dif2normlut4 ,
// normally 0-16               . unsigned  , default = 2 Bit  7: 5,        reserved Bit  4: 0,
// reg_dnr_dm_dif2normlut5                     , normally 0-16               . unsigned  , default
// = 1
#define DNR_DM_DIF2NORM_LUT6_8 ((0x2d75 << 2) + 0xff900000)
// Bit 31:21,        reserved
// Bit 20:16,        reg_dnr_dm_dif2normlut6                     , normally 0-16               .
// unsigned  , default = 1 Bit 15:13,        reserved Bit 12: 8,        reg_dnr_dm_dif2normlut7 ,
// normally 0-16               . unsigned  , default = 1 Bit  7: 5,        reserved Bit  4: 0,
// reg_dnr_dm_dif2normlut8                     , normally 0-16               . unsigned  , default
// = 1
#define DNR_DM_GMS_THD ((0x2d76 << 2) + 0xff900000)
// Bit 31:16,        reserved
// Bit 15: 8,        reg_gms_stat_thd0                                                         .
// unsigned  , default = 0 Bit  7: 0,        reg_gms_stat_thd1 . unsigned  , default = 128
#define DNR_RO_DM_GMS_STAT_CNT ((0x2d77 << 2) + 0xff900000)
// Bit 31: 0,        ro_dm_gms_stat_cnt                                                        .
// unsigned  , default = 0
#define DNR_RO_DM_GMS_STAT_MS ((0x2d78 << 2) + 0xff900000)
// Bit 31: 0,        ro_dm_gms_stat_ms                                                        .
// unsigned  , default = 0
#define DNR_DM_EDGE_GAIN ((0x2d79 << 2) + 0xff900000)
// Bit 31:24        reg_dnr_dm_alpedgegain0   // unsigned , default = 8  , edge based gain for
// alpha, normalized 16 as "1" Bit 23:16        reg_dnr_dm_alpedgegain1   // unsigned , default =
// 16  , edge based gain for alpha, normalized 16 as "1" Bit 15: 8        reg_dnr_dm_alpedgegain2
// // unsigned , default = 24  , edge based gain for alpha, normalized 16 as "1" Bit  7: 0
// reg_dnr_dm_alpedgegain3   // unsigned , default = 32  , edge based gain for alpha, normalized
// 16 as "1"
#define DNR_DM_FLG_BDIF ((0x2d7a << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:24        reg_dnr_dm_flg2bdif0      // unsigned , default = 0  , (0-16), edge flg to
// blkdif calc. Bit 23:21        reserved Bit 20:16        reg_dnr_dm_flg2bdif1      // unsigned ,
// default = 6  , (0-16), edge flg to blkdif calc. Bit 15:13        reserved Bit 12: 8
// reg_dnr_dm_flg2bdif2      // unsigned , default = 10  , (0-16), edge flg to blkdif calc. Bit 7:
// 5        reserved Bit  4: 0        reg_dnr_dm_flg2bdif3      // unsigned , default = 12  ,
// (0-16), edge flg to blkdif calc.
#define DNR_DM_GBS_RORM ((0x2d7b << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15:12        reg_dnr_dm_gbs4difnorm0   // unsigned , default = 0  , gbs=0 for dif norm
// calc. Bit 11: 8        reg_dnr_dm_gbs4difnorm1   // unsigned , default = 1  , gbs=1 for dif
// norm calc. Bit  7: 4        reg_dnr_dm_gbs4difnorm2   // unsigned , default = 4  , gbs=2 for
// dif norm calc. Bit  3: 0        reg_dnr_dm_gbs4difnorm3   // unsigned , default = 6  , gbs=3
// for dif norm calc.
#define DNR_DM_FLG_LEV ((0x2d7c << 2) + 0xff900000)
// Bit 31:14        reserved
// Bit 13:12        reg_dnr_dm_flg2lev0       // unsigned , default = 1  , edge flg to filter
// level calc. Bit 11:10        reserved Bit  9: 8        reg_dnr_dm_flg2lev1       // unsigned ,
// default = 3  , edge flg to filter level calc. Bit  7: 6        reserved Bit  5: 4
// reg_dnr_dm_flg2lev2       // unsigned , default = 3  , edge flg to filter level calc. Bit  3: 2
// reserved Bit  1: 0        reg_dnr_dm_flg2lev3       // unsigned , default = 3  , edge flg to
// filter level calc.
#define DNR_DM_DIF_FLG_TH ((0x2d7d << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15: 8        reg_dnr_dm_dif2flgthd1    // unsigned , default = 128  , dif to edge flg
// threshold 1 Bit  7: 0        reg_dnr_dm_dif2flgthd2    // unsigned , default = 192  , dif to
// edge flg threshold 2
#define DNR_DM_CALP_GAIN_OFST ((0x2d7e << 2) + 0xff900000)
// Bit 31:22        reserved
// Bit 21:16        reg_dnr_dm_calpgain       // unsigned , default = 16  , chroma gain for nr/dm
// alpha, normalized 32 as "1" Bit 15: 9        reserved Bit  8: 0        reg_dnr_dm_calpoffst //
// signed , default = -64  , (-255, 255), chroma offset for nr/dm alpha
// 0x80-0x90
//
// Reading file:  vpu_decomb_regs.h
//
#define DECOMB_DET_VERT_CON0 ((0x2d80 << 2) + 0xff900000)
// Bit  31:24   reg_di_dcmb_det_vcon_thd0      default = 60  // u8
// Bit  23:16   reg_di_dcmb_det_vcon_thd1      default = 80  // u8
// Bit  15: 8   reg_di_dcmb_det_valp_lmt0      default = 63  // u8
// Bit   7: 0   reg_di_dcmb_det_valp_lmt1      default = 4   // u8
#define DECOMB_DET_VERT_CON1 ((0x2d81 << 2) + 0xff900000)
// Bit  23:16   reg_di_dcmb_det_valp_lmt2      default = 0   // u8
// Bit  15: 8   reg_di_dcmb_det_vrate0         default = 32  // u8
// Bit   7: 0   reg_di_dcmb_det_vrate1         default = 4   // u8
#define DECOMB_DET_EDGE_CON0 ((0x2d82 << 2) + 0xff900000)
// Bit  31:24   reg_di_dcmb_det_econ_thd0      default = 60  // u8
// Bit  23:16   reg_di_dcmb_det_econ_thd1      default = 80  // u8
// Bit  15: 8   reg_di_dcmb_det_ealp_lmt0      default = 63  // u8
// Bit   7: 0   reg_di_dcmb_det_ealp_lmt1      default = 4   // u8
#define DECOMB_DET_EDGE_CON1 ((0x2d83 << 2) + 0xff900000)
// Bit  23:16   reg_di_dcmb_det_ealp_lmt2      default = 0   // u8
// Bit  15: 8   reg_di_dcmb_det_erate0         default = 32  // u8
// Bit   7: 0   reg_di_dcmb_det_erate1         default = 4  // u8
#define DECOMB_PARA ((0x2d84 << 2) + 0xff900000)
// Bit  31:30   reserved
// Bit  29:28   reg_di_dcmb_cmb_lpf            default = 1  // u2, 0:no lpf, 1:[1 2 1], 2,3: [1 2
// 2 2 1] Bit  27:26   reg_di_dcmb_vedge_chk          default = 0  // u2, vertical edge check, 0:
// no check, 1: vrt!=0, 2: vrt==3 Bit  25:24   reg_di_dcmb_nedge_chk          default = 0  // u2,
// no idea edge check, 0, no check, 1, check Bit  23:20   reg_di_dcmb_edge_min           default =
// 0   // u4, min edge for edge cmb Bit  19:16   reg_di_dcmb_edge_max           default = 15  //
// u4, min edge for edge cmb Bit   15:8   reg_di_dcmb_bld_alp            default = 255  // u8,
// user defined alpha for di & decmb blend Bit    7:0   reg_di_dcmb_bld_alp_beta       default =
// 40  // u8, beta for mtn & cmb blend, for bld alpha calc.
#define DECOMB_BLND_CON0 ((0x2d85 << 2) + 0xff900000)
// Bit  31:24   reg_di_dcmb_bld_con_thd0       default = 100  // u8
// Bit  23:16   reg_di_dcmb_bld_con_thd1       default = 120  // u8
// Bit  15: 8   reg_di_dcmb_bld_alp_lmt0       default = 0  // u8
// Bit   7: 0   reg_di_dcmb_bld_alp_lmt1       default = 128   // u8
#define DECOMB_BLND_CON1 ((0x2d86 << 2) + 0xff900000)
// Bit  23:16   reg_di_dcmb_bld_alp_lmt2       default = 255   // u8
// Bit  15: 8   reg_di_dcmb_bld_rate0          default = 32 // u8
// Bit   7: 0   reg_di_dcmb_bld_rate1          default = 32  // u8
#define DECOMB_YC_THRD ((0x2d87 << 2) + 0xff900000)
// Bit  31:16   reserved
// Bit  15: 8   reg_di_dcmb_ythd               default = 2 // u8, default = 2
// Bit   7: 0   reg_di_dcmb_cthd               default = 2 // u8, default = 2
#define DECOMB_MTN_GAIN_OFST ((0x2d88 << 2) + 0xff900000)
// Bit  31:22   reserved
// Bit  21:16   reg_di_dcmb_mtn_alp_gain       default = 16  // u6, 16 is normalized to '1'
// Bit   15:9   reserved
// Bit    8:0   reg_di_dcmb_mtn_alp_ofst       default = 0  // s9, [-256, 255]
#define DECOMB_CMB_SEL_GAIN_OFST ((0x2d89 << 2) + 0xff900000)
// Bit  31:22   reserved
// Bit  21:16   reg_di_dcmb_cmb_sel_gain       default = 48  // u6, 16 is normalized to '1'
// Bit   15:9   reserved
// Bit    8:0   reg_di_dcmb_cmb_sel_ofst       default = 0  // s9, [-256, 255]
#define DECOMB_WIND00 ((0x2d8a << 2) + 0xff900000)
// Bit  31:29   reserved
// Bit  28:16   reg_di_dcmb_wnd00              default = 0 // u13, x0 for window 0, software
// control Bit  15:13   reserved Bit   12:0   reg_di_dcmb_wnd01              default = 719 // u13,
// x1 for window 0, HSIZE-1, software control
#define DECOMB_WIND01 ((0x2d8b << 2) + 0xff900000)
// Bit  31:29   reserved
// Bit  28:16   reg_di_dcmb_wnd02              default = 0 // u13, y0 for window 0, software
// control Bit  15:13   reserved Bit   12:0   reg_di_dcmb_wnd03              default = 39 // u13,
// y1 for window 0, software control
#define DECOMB_WIND10 ((0x2d8c << 2) + 0xff900000)
// Bit  31:29   reserved
// Bit  28:16   reg_di_dcmb_wnd10              default = 0 // u13, x0 for window 1, software
// control Bit  15:13   reserved Bit   12:0   reg_di_dcmb_wnd11              default = 719 // u13,
// x1 for window 1, HSIZE-1, software control
#define DECOMB_WIND11 ((0x2d8d << 2) + 0xff900000)
// Bit  31:29   reserved
// Bit  28:16   reg_di_dcmb_wnd12              default = 40 // u13, y0 for window 1, software
// control Bit  15:13   reserved Bit   12:0   reg_di_dcmb_wnd13              default = 239 // u13,
// y1 for window 1, VSIZE-1-40, software control
#define DECOMB_MODE ((0x2d8e << 2) + 0xff900000)
// Bit  31:16   reserved
// Bit     15   reg_di_dcmb_is_cmb_bef         default = 1  // u1, 1: decide is_cmb before cmbing
// refine, 0: decide is_cmb after cmbing refine Bit     14   reg_di_dcmb_en0 default = 1 // u1,
// enable decmobing for wind0 Bit     13   reg_di_dcmb_en1                default = 1 // u1,
// enable decmobing for wind1 Bit     12   reg_di_dcmb_en2                default = 1 // u1,
// enable decmobing for wind2 Bit  11:10   reg_di_dcmb_lpf_mod0           default = 2  // u2, get
// combing free pixels of wind0 by: 0, vertical lpf, 1, edge lpf, 2,3, ei data Bit    9:8
// reg_di_dcmb_lpf_mod1           default = 2  // u2, get combing free pixels of wind1 by: 0,
// vertical lpf, 1, edge lpf, 2,3, ei data Bit    7:6   reg_di_dcmb_lpf_mod2           default = 0
// // u2, get combing free pixels of wind2 by: 0, vertical lpf, 1, edge lpf, 2,3, ei data Bit 5
// reg_di_dcmb_cmb_sel0           default = 1  // u1, wind0 decmb based on: 0, vert cmb, 1, edge
// cmb Bit      4   reg_di_dcmb_cmb_sel1           default = 1  // u1, wind1 decmb based on: 0,
// vert cmb, 1, edge cmb Bit      3   reg_di_dcmb_cmb_sel2           default = 0  // u1, wind2
// decmb based on: 0, vert cmb, 1, edge cmb Bit      2   reg_di_dcmb_alp_mod0           default =
// 1
// // u1, wind0 decmb alpha based on: 0, user-defined, 1, motion adaptive Bit      1
// reg_di_dcmb_alp_mod1           default = 1  // u1, wind1 decmb alpha based on: 0, user-defined,
// 1, motion adaptive Bit      0   reg_di_dcmb_alp_mod2           default = 1  // u1, wind2 decmb
// alpha based on: 0, user-defined, 1, motion adaptive
#define DECOMB_FRM_SIZE ((0x2d8f << 2) + 0xff900000)
// Bit  31:29   reserved
// Bit  28:16   hsize_in                       default = 1920  // u13, pic horz size in  unit:
// pixel Bit  15:13   reserved Bit   12:0   vsize_in                       default = 1080  // u13,
// pic vert size in  unit: pixel
#define DECOMB_HV_BLANK ((0x2d90 << 2) + 0xff900000)
// Bit  31:16   reserved
// Bit   15:8   hblank_num                     default = 20  // u8, hor blank time
// Bit    7:0   vblank_num                     default = 50  // u8, ver blank time
//
// Closing file:  vpu_decomb_regs.h
//
// 0x98-0xa3
//
// Reading file:  vpu_nr2_dpolar_regs.h
//
// synopsys translate_off
// synopsys translate_on
#define NR2_POLAR3_MODE ((0x2d98 << 2) + 0xff900000)
// Bit 31:20        reserved
// Bit 19:18        reg_polar3_f02lpf_mod0    // unsigned , default = 3  low pass filter mode for
// field 0 and field2 before polar3 detection; 0 for no lpf, 1: [1 2 1]/4 vert lpf; 2: [1 2 1; 2 4
// 2; 1 2 1]/16 2d lpf, p1 no hlpf; 2: [1 2 1; 2 4 2; 1 2 1]/16 2d lpf, p1 [1 2 1]/4 hlpf Bit
// 17:16 reg_polar3_f02lpf_mod1    // unsigned , default = 3  low pass filter mode for field 0 and
// field2 before polar3 detection; 0 for no lpf, 1: [1 2 1]/4 vert lpf; 2: [1 2 1; 2 4 2; 1 2
// 1]/16 2d lpf, p1 no hlpf; 2: [1 2 1; 2 4 2; 1 2 1]/16 2d lpf, p1 [1 2 1]/4 hlpf Bit 15: 8
// reg_polar3_dif02_thrd0    // unsigned , default = 5  threshold of dif for polar3 detection
// except for 32 detection, only do polar3 detection on obvious motion, [0] for luma, 1[1] for
// chroma Bit  7: 0        reg_polar3_dif02_thrd1    // unsigned , default = 5  threshold of dif
// for polar3 detection except for 32 detection, only do polar3 detection on obvious motion, [0]
// for luma, 1[1] for chroma
#define NR2_POLAR3_THRD ((0x2d99 << 2) + 0xff900000)
// Bit 31:24        reg_polar3_txtf02_thrd0   // unsigned , default = 30  threshold to vertical
// f0f2 texture, if texture larger than this threshold, will not do the polar3 decision. Bit 23:16
// reg_polar3_txtf02_thrd1   // unsigned , default = 30  threshold to vertical f0f2 texture, if
// texture larger than this threshold, will not do the polar3 decision. Bit 15: 8
// reg_polar3_txtf1_thrd0    // unsigned , default = 20  threshold to vertical f1 texture, if
// texture larger than this threshold, will not do the polar3 decision. Bit  7: 0
// reg_polar3_txtf1_thrd1    // unsigned , default = 20  threshold to vertical f1 texture, if
// texture larger than this threshold, will not do the polar3 decision.
#define NR2_POLAR3_PARA0 ((0x2d9a << 2) + 0xff900000)
// Bit 31:28        reg_polar3_rate00         // unsigned , default = 6  delt = rate*dif02/32,
// e.g. f2<f0, if f1 within((f0+f2)/2 - delt), ((f0+f2)/2 + delt), then polar3_smoothmv++; Bit
// 27:24        reg_polar3_rate01         // unsigned , default = 6  delt = rate*dif02/32, e.g.
// f2<f0, if f1 within((f0+f2)/2 - delt), ((f0+f2)/2 + delt), then polar3_smoothmv++; Bit 23:20
// reg_polar3_rate10         // unsigned , default = 8  delt = rate*dif02/32, e.g. f2-ofst1<f0, if
// f1<((f0+f2)/2 - delt), then polar3_m1++; if f1>((f0+f2)/2 + delt), then polar3_p1++; Bit 19:16
// reg_polar3_rate11         // unsigned , default = 8  delt = rate*dif02/32, e.g. f2-ofst1<f0, if
// f1<((f0+f2)/2 - delt), then polar3_m1++; if f1>((f0+f2)/2 + delt), then polar3_p1++; Bit 15:12
// reg_polar3_rate20         // unsigned , default = 2  delt = rate*dif02/32, e.g. f2<f0, if
// f1<(f2
// - delt- ofset2), then polar3_m2++; if f1>((f0 + delt+ ofset2), then polar3_p2++; Bit 11: 8
// reg_polar3_rate21         // unsigned , default = 2  delt = rate*dif02/32, e.g. f2<f0, if
// f1<(f2
// - delt- ofset2), then polar3_m2++; if f1>((f0 + delt+ ofset2), then polar3_p2++; Bit  7: 1
// reserved Bit  0           reg_polar3_ro_reset       // unsigned , default = 0  reset signal of
// the polar3 read only registers
#define NR2_POLAR3_PARA1 ((0x2d9b << 2) + 0xff900000)
// Bit 31:24        reg_polar3_rate30         // unsigned , default = 48  delt = rate*dif02/32,
// e.g. f2<f0, if f1<(f2 - delt- ofset3) or f1>((f0 + delt+ofst3), then polar3_32++; Bit 23:16
// reg_polar3_rate31         // unsigned , default = 48  delt = rate*dif02/32, e.g. f2<f0, if
// f1<(f2 - delt- ofset3) or f1>((f0 + delt+ofst3), then polar3_32++; Bit 15:12 reg_polar3_ofst30
// // signed , default = 2  delt = rate*dif02/32, e.g. f2<f0, if f1<(f2 - delt-ofst3) or f1>((f0 +
// delt+ofst3), then polar3_32++; Bit 11: 8        reg_polar3_ofst31         // signed , default =
// 2  delt = rate*dif02/32, e.g. f2<f0, if f1<(f2 - delt-ofst3) or f1>((f0 + delt+ofst3), then
// polar3_32++; Bit  7: 4        reg_polar3_ofst20         // signed , default = 2  delt =
// rate*dif02/32, e.g. f2<f0, if f1<(f2 - delt- ofset2), then polar3_m2++; if f1>((f0 + delt+
// ofset2), then polar3_p2++; Bit  3: 0        reg_polar3_ofst21         // signed , default = 2
// delt = rate*dif02/32, e.g. f2<f0, if f1<(f2 - delt- ofset2), then polar3_m2++; if f1>((f0 +
// delt+ ofset2), then polar3_p2++;
#define NR2_POLAR3_CTRL ((0x2d9c << 2) + 0xff900000)
// Bit 31:24        reg_polar3_ofst10         // signed , default = 1
// Bit 23:16        reg_polar3_ofst11         // signed , default = 1
// Bit 15: 8        reg_polar3_h_mute         // unsigned , default = 10  horizontal pixels to
// mute for left right sides for polar3 detection; Bit  7: 0        reg_polar3_v_mute         //
// unsigned , default = 10  vertical pixels to mute for top and bottom sides for polar3 detection;
#define NR2_RO_POLAR3_NUMOFPIX ((0x2d9d << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23: 0        ro_polar3_numofpix        // unsigned , default = 0  number of pixels detected
// as polar3
#define NR2_RO_POLAR3_SMOOTHMV ((0x2d9e << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23: 0        ro_polar3_smoothmv        // unsigned , default = 0  number of pixels with
// smooth mv, F(t) is close between avg of f(t-1) and f(t+1);
#define NR2_RO_POLAR3_M1 ((0x2d9f << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23: 0        ro_polar3_m1              // unsigned , default = 0  number of pixels with
// F(t) is close to f(t-1) instead of f(t+1), but in between [f(t-1), f(t+1)];
#define NR2_RO_POLAR3_P1 ((0x2da0 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23: 0        ro_polar3_p1              // unsigned , default = 0  number of pixels with
// F(t) is close to f(t+1) instead of f(t-1), but in between [f(t-1), f(t+1)];
#define NR2_RO_POLAR3_M2 ((0x2da1 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23: 0        ro_polar3_m2              // unsigned , default = 0  number of pixels with
// F(t) is close to f(t-1) instead of f(t+1), but out side of (f(t-1), f(t+1));
#define NR2_RO_POLAR3_P2 ((0x2da2 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23: 0        ro_polar3_p2              // unsigned , default = 0  number of pixels with
// F(t) is close to f(t+1) instead of f(t-1), but out side of (f(t-1), f(t+1));
#define NR2_RO_POLAR3_32 ((0x2da3 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23: 0        ro_polar3_32              // unsigned , default = 0  number of pixels with
// F(t) far from [f(t-1),f(t+1)] and f(t-1) is close to f(t+1);
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpu_nr2_dpolar_regs.h
//
// 0xa4-0xf7 / 0xff
//
// Reading file:  vpu_nr4_regs.h
//
// synopsys translate_off
// synopsys translate_on
//========== nr4_drt_regs register begin ==========//
#define NR4_DRT_CTRL ((0x2da4 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_ydrt_3line_ssd_gain    // unsigned , default = 16  gain to max ssd
// normalized 16 as '1' Bit 23:16        reg_nr4_ydrt_5line_ssd_gain    // unsigned , default = 16
// gain to max ssd normalized 16 as '1' Bit 15            reserved Bit 14:13
// reg_nr4_drt_yhsad_mode
// // unsigned , default = 1  mode for luma horiztonal sad calc., 0: no vertical lpf, 1: vertical
// [1 2 1], 2 or 3: vertical [ 1 2 2 2 1] if 5 lines Bit 12:11        reg_nr4_drt_chsad_mode //
// unsigned , default = 1  mode for chroma horiztonal sad calc., 0: no vertical lpf, 1: vertical
// [1 2 1], 2 or 3: vertical [ 1 2 2 2 1] if 5 lines Bit 10           reg_nr4_drt_yhsad_hlpf //
// unsigned , default = 1  hlpf for luma hsad of drt calculation, 0: no lpf, 1: with [1 2 1] hlpf
// Bit  9           reg_nr4_drt_yvsad_hlpf         // unsigned , default = 1  hlpf for luma vsad
// of drt calculation, 0: no lpf, 1: with [1 2 1] hlpf Bit  8           reg_nr4_drt_ydsad_hlpf //
// unsigned , default = 1  hlpf for luma dsad of drt calculation, 0: no lpf, 1: with [1 2 1] hlpf
// Bit  7           reg_nr4_drt_chsad_hlpf         // unsigned , default = 1  hlpf for chrome hsad
// of drt calculation, 0: no lpf, 1: with [1 2 1] hlpf Bit  6           reg_nr4_drt_cvsad_hlpf //
// unsigned , default = 1  hlpf for chroma vsad of drt calculation, 0: no lpf, 1: with [1 2 1]
// hlpf Bit  5           reg_nr4_drt_cdsad_hlpf         // unsigned , default = 1  hlpf for chroma
// dsad of drt calculation, 0: no lpf, 1: with [1 2 1] hlpf Bit  4           reg_nr4_ydrt_dif_mode
// // unsigned , default = 1  0:y_dif, 1: y_dif + (u_dif + v_dif)/2 Bit  3: 2
// reg_nr4_cdrt_dif_mode // unsigned , default = 2  0:(u_dif + v_dif), 1: y_dif/4 + (u_dif +
// v_dif)*3/4, 2:y_dif/2 + (u_dif
// + v_dif)/2, 3: y_dif (not recommended) Bit  1: 0        reserved
#define NR4_DRT_YSAD_GAIN ((0x2da5 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_ysad_hrz_gain           // unsigned , default = 16  gain for
// horizontal sad, 16 normalized to "1" Bit 23:16        reg_nr4_ysad_diag_gain          //
// unsigned , default = 20  gain for diagonal sad, 16 normalized to "1" Bit 15: 8
// reg_nr4_ysad_vrt_gain           // unsigned , default = 16  gain for vertical sad, 16
// normalized to "1" Bit  7: 6        reserved Bit  5: 0        reg_nr4_drt_ysad_core_rate      //
// unsigned , default = 6  rate of coring for sad(theta) - sad(theta+pi/2)*rate/64
#define NR4_DRT_CSAD_GAIN ((0x2da6 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_csad_hrz_gain           // unsigned , default = 16  gain for
// horizontal sad, 16 normalized to "1" Bit 23:16        reg_nr4_csad_diag_gain          //
// unsigned , default = 20  gain for diagonal sad, 16 normalized to "1" Bit 15: 8
// reg_nr4_csad_vrt_gain           // unsigned , default = 16  gain for vertical sad, 16
// normalized to "1" Bit  7: 6        reserved Bit  5: 0        reg_nr4_drt_csad_core_rate      //
// unsigned , default = 6  rate of coring for sad(theta) - sad(theta+pi/2)*rate/64
#define NR4_DRT_SAD_ALP_CORE ((0x2da7 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:20        reg_nr4_ydrt_alp_core_rate     // unsigned , default = 0  luma ratio to
// min_err, alpha = (min_err - (max_err - min_err)*rate + ofst)/max_err * 64; dft = 0/32 Bit 19:16
// reg_nr4_cdrt_alp_core_rate     // unsigned , default = 0  chroma ratio to min_err, alpha =
// (min_err - (max_err - min_err)*rate + ofst)/max_err * 64; dft = 0/32 Bit 15:14        reserved
// Bit 13: 8        reg_nr4_ydrt_alp_core_ofst     // unsigned , default = 10  luma offset to
// min_err, alpha = (min_err - (max_err - min_err)*rate + ofst)/max_err * 64; dft = 10 Bit  7: 6
// reserved Bit  5: 0        reg_nr4_cdrt_alp_core_ofst     // unsigned , default = 10  chroma
// offset to min_err, alpha = (min_err - (max_err - min_err)*rate + ofst)/max_err * 64; dft = 10
#define NR4_DRT_ALP_MINMAX ((0x2da8 << 2) + 0xff900000)
// Bit 31:30        reserved
// Bit 29:24        reg_nr4_ydrt_alp_min           // unsigned , default = 0  luma min value of
// alpha, dft = 0 Bit 23:22        reserved Bit 21:16        reg_nr4_ydrt_alp_max           //
// unsigned , default = 63  luma max value of alpha, dft = 63 Bit 15:14        reserved Bit 13: 8
// reg_nr4_cdrt_alp_min           // unsigned , default = 0  chroma min value of alpha, dft = 0
// Bit 7: 6        reserved Bit  5: 0        reg_nr4_cdrt_alp_max           // unsigned , default
// = 63 chroma max value of alpha, dft = 63
//========== nr4_drt_regs register end ==========//
//========== nr4_snr_regs register begin ==========//
#define NR4_SNR_CTRL_REG ((0x2da9 << 2) + 0xff900000)
// Bit 31:13        reserved
// Bit 12           reg_nr4_bet2_sel              // unsigned , default = 1
// Bit 11: 9        reg_nr4_snr2_sel_mode         // unsigned , default = 0  0: no filter, 1:
// adpgau, adp_drt_lpf blend; 2: adpgau, drt4_lpf blend; 3: adp_drt_lpf method, 4: drt4_lpf
// method, 5: adp_drt_                                                             //original
// image blend, 6: drt4_lpf, original image blend, 7: adpgau method; dft=1 Bit  8
// reg_nr4_snr2_gaulpf_mode // unsigned , default = 1    0: 3*5 or 5*5 gaussian lpf;  1: 3*3
// (window size) gaussian lpf; dft=1 Bit  7: 6        reg_nr4_snr2_alpha0_sad_mode  // unsigned ,
// default = 3  0: max_sad*max_ssd; 1: max_sad*max_sad; 2: adp_max_sad*max_ssd; 3:
// adp_max_sad*adp_max_sad  dft=3 Bit  5: 4 reg_nr4_snr2_alpha1_sad_mode  // unsigned , default =
// 2  0: max_sad;  1: cross_max_sad; 2 or 3: adp_sad  dft=2 Bit  3: 2        reserved Bit  1: 0
// reg_nr4_snr2_adp_drtlpf_mode  // unsigned , default = 3  0: adp_drtlpf [2 1 1]/4, 1: adp_drtlpf
// [4 2 1 1]/8; 2: adp_drtlpf [2 2 2 1 1]/8; 3: adp_drtlpf [7 7 7 6 5]/32;  dft=3;
#define NR4_SNR_ALPHA0_MAX_MIN ((0x2daa << 2) + 0xff900000)
// Bit 31:30        reserved
// Bit 29:23        reg_nr4_snr2_alp0_ymin    // unsigned , default = 127  normalized to 128 as
// '1' Bit 22:16        reg_nr4_snr2_alp0_ymax    // unsigned , default = 127  normalized to 128
// as '1' Bit 15:14        reserved Bit 13: 7        reg_nr4_snr2_alp0_cmin    // unsigned ,
// default = 127  normalized to 128 as '1' Bit  6: 0        reg_nr4_snr2_alp0_cmax    // unsigned
// , default = 127  normalized to 128 as '1'
#define NR4_ALP0C_ERR2CURV_LIMIT0 ((0x2dab << 2) + 0xff900000)
// Bit 31:24        reg_nr4_snr2_alp0_minerr_cpar0  // unsigned , default = 0  threshold0 of curve
// to map mierr to alp0 for chroma channel, this will be set value of flat region mierr that no
// need blur. Bit 23:16        reg_nr4_snr2_alp0_minerr_cpar1  // unsigned , default = 25
// threshold1 of curve to map mierr to alp0 for chroma channel,this will be set value of texture
// region mierr that can not blur. Bit 15: 8        reg_nr4_snr2_alp0_minerr_cpar5  // unsigned ,
// default = 40  rate0 (for mierr<th0) of curve to map mierr to alp0 for chroma channel. the
// larger of the value, the deep of the slope. 0~255. Bit  7: 0 reg_nr4_snr2_alp0_minerr_cpar6  //
// unsigned , default = 40  rate1 (for mierr>th1) of curve to map mierr to alp0 for chroma
// channel. the larger of the value, the deep of the slope. 0~255.
#define NR4_ALP0C_ERR2CURV_LIMIT1 ((0x2dac << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_nr4_snr2_alp0_minerr_cpar2  // unsigned , default = 127  level limit(for
// mierr<th0) of curve to map mierr to alp0 for chroma channel, that we can do for flat region.
// 0~255. Bit 15: 8        reg_nr4_snr2_alp0_minerr_cpar3  // unsigned , default = 0  level
// limit(for th0<mierr<th1) of curve to map mierr to alp0 for chroma channel, that we can do for
// misc region. 0~255. Bit  7: 0        reg_nr4_snr2_alp0_minerr_cpar4  // unsigned , default =
// 127 level limit(for mierr>th1) of curve to map mierr to alp0 for chroma channel,   that we can
// do for texture region. 0~255.
#define NR4_ALP0Y_ERR2CURV_LIMIT0 ((0x2dad << 2) + 0xff900000)
// Bit 31:24        reg_nr4_snr2_alp0_minerr_ypar0  // unsigned , default = 0  threshold0 of curve
// to map mierr to alp0 for luma channel, this will be set value of flat region mierr that no need
// blur. 0~255. Bit 23:16        reg_nr4_snr2_alp0_minerr_ypar1  // unsigned , default = 25
// threshold1 of curve to map mierr to alp0 for luma channel,this will be set value of texture
// region mierr that can not blur. Bit 15: 8        reg_nr4_snr2_alp0_minerr_ypar5  // unsigned ,
// default = 40  rate0 (for mierr<th0) of curve to map mierr to alp0 for luma channel. the larger
// of the value, the deep of the slope. 0~255. Bit  7: 0        reg_nr4_snr2_alp0_minerr_ypar6  //
// unsigned , default = 40  rate1 (for mierr>th1) of curve to map mierr to alp0 for luma channel.
// the larger of the value, the deep of the slope. 0~255.
#define NR4_ALP0Y_ERR2CURV_LIMIT1 ((0x2dae << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_nr4_snr2_alp0_minerr_ypar2  // unsigned , default = 127  level limit(for
// mierr<th0) of curve to map mierr to alp0 for luma channel,  set to alp0 that we can do for flat
// region. 0~255. Bit 15: 8        reg_nr4_snr2_alp0_minerr_ypar3  // unsigned , default = 0 level
// limit(for th0<mierr<th1) of curve to map mierr to alp0 for luma channel, alp0 that we can do
// for misc region. 0~255. Bit  7: 0        reg_nr4_snr2_alp0_minerr_ypar4  // unsigned , default
// = 127 level limit(for mierr>th1) of curve to map mierr to alp0 for luma channel, alp0 that we
// can do for texture region. 0~255.
#define NR4_SNR_ALPA1_RATE_AND_OFST ((0x2daf << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:18        reg_nr4_snr2_alp1_ycore_rate      // unsigned , default = 0    normalized 64
// as "1" Bit 17:12        reg_nr4_snr2_alp1_ccore_rate      // unsigned , default = 0 normalized
// 64 as "1" Bit 11: 6        reg_nr4_snr2_alp1_ycore_ofst      // signed , default = 3 normalized
// 64 as "1" Bit  5: 0        reg_nr4_snr2_alp1_ccore_ofst      // signed , default = 3 normalized
// 64 as "1"
#define NR4_SNR_ALPHA1_MAX_MIN ((0x2db0 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:18        reg_nr4_snr2_alp1_ymin            // unsigned , default = 0    normalized to
// 64 as '1' Bit 17:12        reg_nr4_snr2_alp1_ymax            // unsigned , default = 63
// normalized to 64 as '1' Bit 11: 6        reg_nr4_snr2_alp1_cmin            // unsigned ,
// default = 0    normalized to 64 as '1' Bit  5: 0        reg_nr4_snr2_alp1_cmax            //
// unsigned , default = 63   normalized to 64 as '1'
#define NR4_ALP1C_ERR2CURV_LIMIT0 ((0x2db1 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_snr2_alp1_minerr_cpar0  // unsigned , default = 0    annel, this will
// be set value of flat region mierr that no need directional NR. 0~255. Bit 23:16
// reg_nr4_snr2_alp1_minerr_cpar1  // unsigned , default = 24   hannel,this will be set value of
// texture region mierr that can not do directional NR. 0~255. Bit 15: 8
// reg_nr4_snr2_alp1_minerr_cpar5  // unsigned , default = 0    a/chroma  channel. the larger of
// the value, the deep of the slope. Bit  7: 0        reg_nr4_snr2_alp1_minerr_cpar6  // unsigned
// , default = 20   a/chroma  channel. the larger of the value, the deep of the slope. 0~255
#define NR4_ALP1C_ERR2CURV_LIMIT1 ((0x2db2 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_nr4_snr2_alp1_minerr_cpar2  // unsigned , default = 0    will be set to
// alp1 that we can do for flat region. 0~255. Bit 15: 8        reg_nr4_snr2_alp1_minerr_cpar3  //
// unsigned , default = 16   this will be set to alp1 that we can do for misc region. 0~255. Bit
// 7: 0        reg_nr4_snr2_alp1_minerr_cpar4  // unsigned , default = 63   will be set to alp1
// that we can do for texture region. 0~255.255 before
#define NR4_ALP1Y_ERR2CURV_LIMIT0 ((0x2db3 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_snr2_alp1_minerr_ypar0  // unsigned , default = 0    thra/chroma
// channel, this will be set value of flat region mierr that no need directional NR. 0~255. Bit
// 23:16        reg_nr4_snr2_alp1_minerr_ypar1  // unsigned , default = 24   thra/chroma
// channel,this will be set value of texture region mierr that can not do directional NR. 0~255.
// Bit 15: 8        reg_nr4_snr2_alp1_minerr_ypar5  // unsigned , default = 0    ratlp1 for
// luma/chroma  channel. the larger of the value, the deep of the slope. Bit  7: 0
// reg_nr4_snr2_alp1_minerr_ypar6  // unsigned , default = 20   ratlp1 for luma/chroma  channel.
// the larger of the value, the deep of the slope. 0~255
#define NR4_ALP1Y_ERR2CURV_LIMIT1 ((0x2db4 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_nr4_snr2_alp1_minerr_ypar2  // unsigned , default = 0    lev to alp1 for
// luma/chroma  channel, this will be set to alp1 that we can do for flat region. 0~255. Bit 15: 8
// reg_nr4_snr2_alp1_minerr_ypar3  // unsigned , default = 16   levierr to alp1 for luma/chroma
// channel, this will be set to alp1 that we can do for misc region. 0~255. Bit  7: 0
// reg_nr4_snr2_alp1_minerr_ypar4  // unsigned , default = 63   lev to alp1 for luma/chroma
// channel, this will be set to alp1 that we can do for texture region. 0~255.255 before
//========== nr4_snr_regs register end ==========//
//========== nr4_tnr_regs register begin ==========//
#define NR4_MTN_CTRL ((0x2db5 << 2) + 0xff900000)
// Bit 31: 2        reserved
// Bit  1           reg_nr4_mtn_ref_en        // unsigned , default = 1  enable motion refinement,
// dft = 1 Bit  0           reg_nr4_mtn_ref_bet_sel   // unsigned , default = 0  beta selection
// mode for motion refinement, 0: beta1, 1: beta2, dft = 0
#define NR4_MTN_REF_PAR0 ((0x2db6 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_mtn_ref_par0      // unsigned , default = 24  par0 for beta to gain,
// dft = Bit 23:16        reg_nr4_mtn_ref_par1      // unsigned , default = 60  par1 for beta to
// gain, dft = Bit 15: 8        reg_nr4_mtn_ref_par2      // unsigned , default = 4  par2 for beta
// to gain, dft = Bit  7: 0        reg_nr4_mtn_ref_par3      // unsigned , default = 32  par3 for
// beta to gain, dft =
#define NR4_MTN_REF_PAR1 ((0x2db7 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_nr4_mtn_ref_par4      // unsigned , default = 128  par4 for beta to gain,
// dft = Bit 15: 8        reg_nr4_mtn_ref_par5      // unsigned , default = 40  par5 for beta to
// gain, dft = Bit  7: 0        reg_nr4_mtn_ref_par6      // unsigned , default = 20  par6 for
// beta to gain, dft =
//========== nr4_tnr_regs register end ==========//
//========== nr4_mcnr_regs register begin ==========//
#define NR4_MCNR_LUMA_ENH_CTRL ((0x2db8 << 2) + 0xff900000)
// Bit 31: 4        reserved
// Bit  3           reg_nr4_luma_plus_en           // unsigned , default = 1  enable luma
// enhancement, dft = 1 Bit  2           reg_nr4_luma_plus_wt_mode      // unsigned , default = 1
// luma weight calc mode, 0:sqrt(1+x^2), 1: 1+abs(x), dft = 0 Bit  1: 0
// reg_nr4_luma_plus_orient_mode  // unsigned , default = 1  0: only use previous orient for pre
// and cur luma plus, 1: 0: only use current orient for pre and cur luma plus
#define NR4_MCNR_LUMA_STAT_LIMTX ((0x2db9 << 2) + 0xff900000)
// Bit 31:30        reserved
// Bit 29:16        reg_nr4_luma_plus_xst        // unsigned , default = 8    start for luma plus
// statistic, dft = 8 Bit 15:14        reserved Bit 13: 0        reg_nr4_luma_plus_xed        //
// unsigned , default = 711  end for luma plus statistic, dft = HSIZE-8-1;
#define NR4_MCNR_LUMA_STAT_LIMTY ((0x2dba << 2) + 0xff900000)
// Bit 31:30        reserved
// Bit 29:16        reg_nr4_luma_plus_yst          // unsigned , default = 8  start for luma plus
// statistic, dft = 8 Bit 15:14        reserved Bit 13: 0        reg_nr4_luma_plus_yed          //
// unsigned , default = 231  end for luma plus statistic, dft = VSIZE-8-1
#define NR4_MCNR_LUMA_DIF_CALC ((0x2dbb << 2) + 0xff900000)
// Bit 31:30        reserved
// Bit 29:24        reg_nr4_luma_plus_ugain        // unsigned , default = 8  U's gain for luma
// enhancement, 16 normalized as '1' Bit 23:22        reserved Bit 21:16 reg_nr4_luma_plus_vgain
// // unsigned , default = 8  V's gain for luma enhancement, 16 normalized as '1' Bit 15: 8
// reg_nr4_luma_plus_ycor_thd     // unsigned , default = 2  Y coring threshold for difference
// calc., dft = 0 Bit  7: 0        reg_nr4_luma_plus_ccor_thd     // unsigned , default = 0  C
// coring threshold for difference calc., dft = 0
#define NR4_MCNR_LUMAPRE_CAL_PRAM ((0x2dbc << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:24        reg_nr4_pre_u_orient           // signed , default = 0  orientation of
// previous U, initial to 0, and will be updated by software Bit 23:18        reserved Bit 17:16
// reg_nr4_pre_v_orient           // signed , default = 0  orientation of previous V, initial to
// 0, and will be updated by software Bit 15: 8        reg_nr4_pre_u_mean             // unsigned
// , default = 0  mean of previous U, initial to 0, and will be updated by software Bit  7: 0
// reg_nr4_pre_v_mean             // unsigned , default = 0  mean of previousV, initial to 0, and
// will be updated by software
#define NR4_MCNR_LUMACUR_CAL_PRAM ((0x2dbd << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:24        reg_nr4_cur_u_orient           // signed , default = 0  orientation of current
// U, initial to 0, and will be updated by software Bit 23:18        reserved Bit 17:16
// reg_nr4_cur_v_orient           // signed , default = 0  orientation of current V, initial to 0,
// and will be updated by software Bit 15: 8        reg_nr4_cur_u_mean             // unsigned ,
// default = 0  mean of current U, initial to 0, and will be updated by software Bit  7: 0
// reg_nr4_cur_v_mean             // unsigned , default = 0  mean of current, initial to 0, and
// will be updated by software
#define NR4_MCNR_MV_CTRL_REG ((0x2dbe << 2) + 0xff900000)
// Bit 31:14        reserved
// Bit 13:12        reg_nr4_sad_bitw          // unsigned , default = 2  sad bit width (8 + x)
// before clip to u8, dft = 1 Bit 11: 4        reg_nr4_glb_gain          // unsigned , default =
// 64 global gain calc. by software, 64 is normalized as '1' Bit  3: 0        reg_nr4_mv_err_rsft
// // unsigned , default = 8  right shift for mv err calc., dft = 9
#define NR4_MCNR_MV_GAIN0 ((0x2dbf << 2) + 0xff900000)
// Bit 31:28        reg_nr4_lftmvx_gain       // unsigned , default = 1  left mvx gain for err
// calc., dft = 1 Bit 27:24        reg_nr4_lftmvy_gain       // unsigned , default = 1  left mvy
// gain for err calc., dft = 1 Bit 23:20        reg_nr4_zmvx_gain         // unsigned , default =
// 5 zero mvx gain for err calc., dft = 2 Bit 19:16        reg_nr4_zmvy_gain         // unsigned ,
// default = 5  zero mvy gain for err calc., dft = 4 Bit 15:12        reg_nr4_lmvx0_gain        //
// unsigned , default = 2  line mvx0 gain for err calc., dft = 1 Bit 11: 8 reg_nr4_lmvx1_gain //
// unsigned , default = 2  line mvx1 gain for err calc., dft = 1 Bit  7: 4 reg_nr4_lmvy0_gain //
// unsigned , default = 2  line mvy0 gain for err calc., dft = 1 Bit  3: 0 reg_nr4_lmvy1_gain //
// unsigned , default = 2  line mvy1 gain for err calc., dft = 1
#define NR4_MCNR_LMV_PARM ((0x2dc0 << 2) + 0xff900000)
// Bit 31:28        reg_nr4_lmv_rt0		         // unsigned , default = 3  ratio of max
// lmv
// Bit 27:24        reg_nr4_lmv_rt1		         // unsigned , default = 3  ratio of
// second max lmv Bit 23:22        reserved Bit 21:16        reg_nr4_lmv_num_lmt0	     //
// unsigned , default = 16  lmv0 least/limit number of (total number - zero_bin) Bit 15:14
// reserved Bit 13: 8        reg_nr4_lmv_num_lmt1	     // unsigned , default = 8  lmv1
// least/limit number of (total number - zero_bin - max0) Bit  7: 2        reserved Bit  1: 0
// reg_nr4_max_sad_rng
// // unsigned , default = 1  search range of max2 sad in small region, dft = 1
#define NR4_MCNR_ALP0_REG ((0x2dc1 << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25           reg_nr4_alp0_fail_chk     // unsigned , default = 1  enable check for alp0
// fail status Bit 24           reg_nr4_bet0_coef_ref_en  // unsigned , default = 1  bet1
// refinement by coef_blt Bit 23:16        reg_nr4_alp0_posad_gain   // unsigned , default = 255
// the sad (norm) gain for pixel pointed by MV; Bit 15:10        reserved Bit  9: 8
// reg_nr4_alp0_norm_mode    // unsigned , default = 0  alp0 select sad norm mode, 0: disable, 1:
// enable dc norm, 2: enable ac norm, 3: enable both (dc/ac) norm, dft = 3 Bit  7: 6 reserved Bit
// 5: 0        reg_nr4_alp0_norm_gain    // unsigned , default = 16  alp0 gain for sad norm, '32'
// as '1', dft = 1
#define NR4_MCNR_ALP1_AND_BET0_REG ((0x2dc2 << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:24        reg_nr4_alp1_norm_mode    // unsigned , default = 3  alp1 select sad norm
// mode, 0: disable, 1: enable dc norm, 2: enable ac norm, 3: enable both (dc/ac) norm, dft = 3
// Bit 23:22        reserved Bit 21:16        reg_nr4_alp1_norm_gain    // unsigned , default = 3
// alp1 gain for sad norm, '32' as '1', dft = 1 Bit 15:10        reserved Bit  9: 8
// reg_nr4_bet0_norm_mode    // unsigned , default = 3  bet0 select sad norm mode, 0: disable, 1:
// enable dc norm, 2: enable ac norm, 3: enable both (dc/ac) norm, dft = 3 Bit  7: 6 reserved Bit
// 5: 0        reg_nr4_bet0_norm_gain    // unsigned , default = 8  bet0 gain for sad norm, '32'
// as '1', dft = 1
#define NR4_MCNR_BET1_AND_BET2_REG ((0x2dc3 << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:24        reg_nr4_bet1_norm_mode    // unsigned , default = 3  bet1 select sad norm
// mode, 0: disable, 1: enable dc norm, 2: enable ac norm, 3: enable both (dc/ac) norm, dft = 3
// Bit 23:22        reserved Bit 21:16        reg_nr4_bet1_norm_gain    // unsigned , default = 8
// bet1 gain for sad norm, '32' as '1', dft = 1 Bit 15:10        reserved Bit  9: 8
// reg_nr4_bet2_norm_mode    // unsigned , default = 0  bet2 select sad norm mode, 0: disable, 1:
// enable dc norm, 2: enable ac norm, 3: enable both (dc/ac) norm, dft = 3 Bit  7: 6 reserved Bit
// 5: 0        reg_nr4_bet2_norm_gain    // unsigned , default = 16  bet2 gain for sad norm, '32'
// as '1', dft = 1
#define NR4_MCNR_AC_DC_CRTL ((0x2dc4 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15:12        reserved
// Bit 11           reg_nr4_dc_mode           // unsigned , default = 1  mode for dc selection,0:
// Y_lpf, 1: Y_lpf + (U_Lpf+V_lpf)/2, Bit 10           reg_nr4_ac_mode           // unsigned ,
// default = 1  mode for ac selection, 0: Y_abs_dif, 1: Y_abs_dif + (U_abs_dif + V_abs_dif)/2 Bit
// 9           reg_nr4_dc_sel            // unsigned , default = 0  selection mode for dc value,
// 0: 3x5, 1: 5x5, dft = 1 Bit  8           reg_nr4_ac_sel            // unsigned , default = 0
// selection mode for ac value, 0: 3x5, 1: 5x5, dft = 1 Bit  7            reserved Bit  6: 4
// reg_nr4_dc_shft           // unsigned , default = 2  right shift for dc value, dft = 2 Bit  3
// reserved Bit  2: 0        reg_nr4_ac_shft           // unsigned , default = 0  right shift for
// ac value, dft = 2
#define NR4_MCNR_CM_CTRL0 ((0x2dc5 << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28           reg_nr4_cm_skin_prc_bet0      // unsigned , default = 0  enable skin tone
// processing for mcnr bet0 calc., dft = 1 Bit 27:26        reg_nr4_cm_chrm_sel           //
// unsigned , default = 1  chrome selection for color match, 0: 1x1, 1: 3X3LPF, 2: 3x5LPF, 3:
// 5x5LPF for 5lines, 3x5LPF for 3lines, dft = 3 Bit 25:24        reg_nr4_cm_luma_sel           //
// unsigned , default = 1  luma selection for color match, 0: 1x1, 1: 3X3LPF, 2: 3x5LPF, 3: 5x5LPF
// for 5lines, 3x5LPF for 3lines, dft = 3 Bit 23:21        reg_nr4_cm_skin_rshft_bet0    //
// unsigned , default = 3  right shift for bet0's skin color gains, dft = 3 Bit 20
// reg_nr4_cm_var_sel            // unsigned , default = 1  variation selection for color match,
// 0: 3x5, 1: 5x5 for 5lines, 3x5 for 3lines, dft = 1 Bit 19           reg_nr4_cm_green_prc_bet0
// // unsigned , default = 1  enable green processing for mcnr bet0 calc., dft = 1 Bit 18:16
// reg_nr4_cm_green_rshft_bet0   // unsigned , default = 4  right shift for bet0's green color
// gains, dft = 4 Bit 15:14        reg_nr4_preflt_mod            // unsigned , default = 2  pre
// filter mode in mcnr, 0: mv pointed pixel, 1: bilater filter Bit 13:12        reg_nr4_alp1_mode
// // unsigned , default = 1  mode for alpha1's sad selection, 0: max sad, 1: three min sads, 2:
// min sad, 3: co sad Bit 11:10        reserved Bit  9: 8        reg_nr4_bet0_mode             //
// unsigned , default = 0  mode for bet0's sad selection, 0: max sad, 1: three min sads, 2: min
// sad, 3: co sad, else: (co sad) - (min sad) Bit  7: 6        reserved Bit  5: 4
// reg_nr4_bet1_mode
// // unsigned , default = 2  mode for bet1's sad selection, 0: max sad, 1: three min sads, 2: min
// sad, 3: co sad, else: (co sad) - (min sad) Bit  3: 2        reserved Bit  1: 0
// reg_nr4_bet2_mode
// // unsigned , default = 1  mode for bet2's sad selection, 0: max sad, 1: three min sads, 2: min
// sad, 3: co sad, else: (co sad) - (min sad)
#define NR4_MCNR_CM_PRAM ((0x2dc6 << 2) + 0xff900000)
// Bit 31:30        reserved
// Bit 29           reg_nr4_cm_blue_prc_alp0      // unsigned , default = 1  enable blue
// processing for mcnr alpha0 calc., dft = 1 Bit 28           reg_nr4_cm_blue_prc_alp1      //
// unsigned , default = 1  enable blue processing for mcnr alpha1 calc., dft = 1 Bit 27
// reg_nr4_cm_skin_prc_alp0      // unsigned , default = 1  enable skin tone processing for mcnr
// alpha0 calc., dft = 1 Bit 26           reg_nr4_cm_green_prc_alp0     // unsigned , default = 1
// enable green processing for mcnr alpha0 clac., dft = 1 Bit 25 reg_nr4_cm_skin_prc_alp1
// // unsigned , default = 1  enable skin tone processing for mcnr alpha0 calc., dft = 1 Bit 24
// reg_nr4_cm_green_prc_alp1     // unsigned , default = 1  enable green processing for mcnr
// alpha1 clac., dft = 1 Bit 23:20        reg_nr4_cm_blue_hue_st        // unsigned , default = 13
// hue start of blue, dft = Bit 19:16        reg_nr4_cm_blue_hue_ed        // unsigned , default =
// 15 hue end  of blue, dft = Bit 15:12        reg_nr4_cm_green_hue_st       // unsigned , default
// = 7 hue start of green, dft = Bit 11: 8        reg_nr4_cm_green_hue_ed       // unsigned ,
// default = 10  hue end  of green, dft = Bit  7: 4        reg_nr4_cm_skin_hue_st        //
// unsigned , default = 5  hue start of skin, dft = Bit  3: 0        reg_nr4_cm_skin_hue_ed //
// unsigned , default = 6  hue end  of skin, dft =
#define NR4_MCNR_CM_RSHFT_ALP0 ((0x2dc7 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:25        reg_nr4_cm_blue_rshft_bet0    // unsigned , default = 5  right shift for
// bet0's blue color gains, dft = 5 Bit 24           reg_nr4_cm_blue_prc_bet0      // unsigned ,
// default = 1  enable blue processing for mcnr bet0 calc., dft = 1 Bit 23            reserved Bit
// 22:20        reg_nr4_cm_blue_rshft_alp0    // unsigned , default = 5  right shift for
// alpha0/1's blue color gains, dft = 5 Bit 19            reserved Bit 18:16
// reg_nr4_cm_blue_rshft_alp1
// // unsigned , default = 5  right shift for alpha0/1's blue color gains, dft = 5 Bit 15 reserved
// Bit 14:12        reg_nr4_cm_green_rshft_alp0   // unsigned , default = 4  right shift for
// alpha0/1's green color gains, dft = 4 Bit 11            reserved Bit 10: 8
// reg_nr4_cm_green_rshft_alp1   // unsigned , default = 4  right shift for alpha0/1's green color
// gains, dft = 4 Bit  7            reserved Bit  6: 4        reg_nr4_cm_skin_rshft_alp0    //
// unsigned , default = 3  right shift for alpha0/1's skin color gains, dft = 3 Bit  3 reserved
// Bit 2: 0        reg_nr4_cm_skin_rshft_alp1    // unsigned , default = 3  right shift for
// alpha0/1's skin color gains, dft = 3
#define NR4_MCNR_BLUE_CENT ((0x2dc8 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_nr4_cm_blue_centx         // unsigned , default = 157  x coordinate of
// center of blue, dft = Bit 15: 8        reserved Bit  7: 0        reg_nr4_cm_blue_centy //
// unsigned , default = 110  y coordinate of center of blue, dft =
#define NR4_MCNR_BLUE_GAIN_PAR0 ((0x2dc9 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_cm_blue_gain_par0   // unsigned , default = 32  par0 for blue gain,
// dft = Bit 23:16        reg_nr4_cm_blue_gain_par1   // unsigned , default = 255  par1 for blue
// gain, dft = Bit 15: 8        reg_nr4_cm_blue_gain_par2   // unsigned , default = 4  par2 for
// blue gain, dft = Bit  7: 0        reg_nr4_cm_blue_gain_par3   // unsigned , default = 32  par3
// for blue gain, dft =
#define NR4_MCNR_BLUE_GAIN_PAR1 ((0x2dca << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_nr4_cm_blue_gain_par4   // unsigned , default = 32  par4 for blue gain,
// dft = Bit 15: 8        reg_nr4_cm_blue_gain_par5   // unsigned , default = 32  par5 for blue
// gain, dft = Bit  7: 0        reg_nr4_cm_blue_gain_par6   // unsigned , default = 0  par6 for
// blue gain, dft =
#define NR4_MCNR_CM_BLUE_CLIP0 ((0x2dcb << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_nr4_cm_blue_luma_min      // unsigned , default = 40  luma min for blue
// color matching, dft = Bit 15: 8        reserved Bit  7: 0        reg_nr4_cm_blue_luma_max //
// unsigned , default = 180  luma max for blue color matching, dft =
#define NR4_MCNR_CM_BLUE_CLIP1 ((0x2dcc << 2) + 0xff900000)
// Bit 31:24        reg_nr4_cm_blue_sat_min       // unsigned , default = 5  saturation min for
// blue color matching, dft = Bit 23:16        reg_nr4_cm_blue_sat_max       // unsigned , default
// = 255  saturation max for blue color matching, dft = Bit 15: 8        reg_nr4_cm_blue_var_min
// // unsigned , default = 0  variation min for blue color matching, dft = Bit  7: 0
// reg_nr4_cm_blue_var_max       // unsigned , default = 12  variation max for blue color
// matching, dft =
#define NR4_MCNR_GREEN_CENT ((0x2dcd << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_nr4_cm_green_centx         // unsigned , default = 114  x coordinate of
// center of green, dft = Bit 15: 8        reserved Bit  7: 0        reg_nr4_cm_green_centy //
// unsigned , default = 126  y coordinate of center of green, dft =
#define NR4_MCNR_GREEN_GAIN_PAR0 ((0x2dce << 2) + 0xff900000)
// Bit 31:24        reg_nr4_cm_green_gain_par0   // unsigned , default = 16  par0 for green gain,
// dft = Bit 23:16        reg_nr4_cm_green_gain_par1   // unsigned , default = 255  par1 for green
// gain, dft = Bit 15: 8        reg_nr4_cm_green_gain_par2   // unsigned , default = 255  par2 for
// green gain, dft = Bit  7: 0        reg_nr4_cm_green_gain_par3   // unsigned , default = 16 par3
// for green gain, dft =
#define NR4_MCNR_GREEN_GAIN_PAR1 ((0x2dcf << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_nr4_cm_green_gain_par4   // unsigned , default = 16  par4 for green gain,
// dft = Bit 15: 8        reg_nr4_cm_green_gain_par5   // unsigned , default = 128  par5 for green
// gain, dft = Bit  7: 0        reg_nr4_cm_green_gain_par6   // unsigned , default = 0  par6 for
// green gain, dft =
#define NR4_MCNR_GREEN_CLIP0 ((0x2dd0 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_nr4_cm_green_luma_min      // unsigned , default = 40  luma min for green
// color matching, dft = Bit 15: 8        reserved Bit  7: 0        reg_nr4_cm_green_luma_max //
// unsigned , default = 160  luma max for green color matching, dft =
#define NR4_MCNR_GREEN_CLIP2 ((0x2dd1 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_cm_green_sat_min       // unsigned , default = 4  saturation min for
// green color matching, dft = Bit 23:16        reg_nr4_cm_green_sat_max       // unsigned ,
// default = 255  saturation max for green color matching, dft = Bit 15: 8
// reg_nr4_cm_green_var_min
// // unsigned , default = 0  variation min for green color matching, dft = Bit  7: 0
// reg_nr4_cm_green_var_max       // unsigned , default = 12  variation max for green color
// matching, dft =
#define NR4_MCNR_SKIN_CENT ((0x2dd2 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_nr4_cm_skin_centx         // unsigned , default = 112  x coordinate of
// center of skin tone, dft = Bit 15: 8        reserved Bit  7: 0        reg_nr4_cm_skin_centy //
// unsigned , default = 149  y coordinate of center of skin tone, dft =
#define NR4_MCNR_SKIN_GAIN_PAR0 ((0x2dd3 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_cm_skin_gain_par0   // unsigned , default = 20  par0 for skin gain,
// dft = Bit 23:16        reg_nr4_cm_skin_gain_par1   // unsigned , default = 255  par1 for skin
// gain, dft = Bit 15: 8        reg_nr4_cm_skin_gain_par2   // unsigned , default = 255  par2 for
// skin gain, dft = Bit  7: 0        reg_nr4_cm_skin_gain_par3   // unsigned , default = 8  par3
// for skin gain, dft =
#define NR4_MCNR_SKIN_GAIN_PAR1 ((0x2dd4 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_nr4_cm_skin_gain_par4   // unsigned , default = 8  par4 for skin gain, dft
// = Bit 15: 8        reg_nr4_cm_skin_gain_par5   // unsigned , default = 128  par5 for skin gain,
// dft = Bit  7: 0        reg_nr4_cm_skin_gain_par6   // unsigned , default = 0  par6 for skin
// gain, dft =
#define NR4_MCNR_SKIN_CLIP0 ((0x2dd5 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:16        reg_nr4_cm_skin_luma_min      // unsigned , default = 40  luma min for skin
// color matching, dft = Bit 15: 8        reserved Bit  7: 0        reg_nr4_cm_skin_luma_max //
// unsigned , default = 180  luma max for skin color matching, dft =
#define NR4_MCNR_SKIN_CLIP1 ((0x2dd6 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_cm_skin_sat_min       // unsigned , default = 5  saturation min for
// skin color matching, dft = Bit 23:16        reg_nr4_cm_skin_sat_max       // unsigned , default
// = 255  saturation max for skin color matching, dft = Bit 15: 8        reg_nr4_cm_skin_var_min
// // unsigned , default = 0  variation min for skin color matching, dft = Bit  7: 0
// reg_nr4_cm_skin_var_max       // unsigned , default = 12  variation max for skin color
// matching, dft =
#define NR4_MCNR_ALP1_GLB_CTRL ((0x2dd7 << 2) + 0xff900000)
// Bit 31           reg_nr4_alp1_glb_gain_en     // unsigned , default = 0  alp1 adjust by global
// gain, dft = 1 Bit 30:28        reg_nr4_alp1_glb_gain_lsft   // unsigned , default = 6  alp1
// left shift before combine with global gain Bit 27           reg_nr4_bet0_glb_gain_en     //
// unsigned , default = 1  bet0 adjust by global gain, dft = 1 Bit 26:24
// reg_nr4_bet0_glb_gain_lsft
// // unsigned , default = 6  bet1 left shift before combine with global gain Bit 23
// reg_nr4_bet1_glb_gain_en     // unsigned , default = 0  bet1 adjust by global gain, dft = 0 Bit
// 22:20        reg_nr4_bet1_glb_gain_lsft   // unsigned , default = 6  bet1 left shift before
// combine with global gain Bit 19           reg_nr4_bet2_glb_gain_en     // unsigned , default =
// 1 bet2 adjust by global gain, dft = 1 Bit 18:16        reg_nr4_bet2_glb_gain_lsft   // unsigned
// , default = 6  bet2 left shift before combine with global gain Bit 15 reg_nr4_alp1_ac_en
// // unsigned , default = 1  alp1 adjust by ac, dft = 1 Bit 14:12        reg_nr4_alp1_ac_lsft //
// unsigned , default = 5  alp1 left shift before combine with ac Bit 11 reg_nr4_bet0_ac_en //
// unsigned , default = 0  bet0 adjust by ac, dft = 1 Bit 10: 8        reg_nr4_bet0_ac_lsft //
// unsigned , default = 5  bet0 left shift before combine with ac Bit  7 reg_nr4_bet1_ac_en //
// unsigned , default = 0  bet1 adjust by ac, dft = 1 Bit  6: 4        reg_nr4_bet1_ac_lsft //
// unsigned , default = 5  bet1 left shift before combine with ac Bit  3 reg_nr4_bet2_ac_en //
// unsigned , default = 0  bet2 adjust by ac, dft = 1 Bit  2: 0        reg_nr4_bet2_ac_lsft //
// unsigned , default = 5  bet2 left shift before combine with ac
#define NR4_MCNR_DC2NORM_LUT0 ((0x2dd8 << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:24        reg_nr4_dc2norm_lut0         // unsigned , default = 16  normal 0~16, dc to
// norm for alpha adjust, dft = Bit 23:21        reserved Bit 20:16        reg_nr4_dc2norm_lut1 //
// unsigned , default = 16  normal 0~16, dc to norm for alpha adjust, dft = Bit 15:13 reserved Bit
// 12: 8        reg_nr4_dc2norm_lut2         // unsigned , default = 16  normal 0~16, dc to norm
// for alpha adjust, dft = Bit  7: 5        reserved Bit  4: 0        reg_nr4_dc2norm_lut3 //
// unsigned , default = 16  normal 0~16, dc to norm for alpha adjust, dft =
#define NR4_MCNR_DC2NORM_LUT1 ((0x2dd9 << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:24        reg_nr4_dc2norm_lut4         // unsigned , default = 16  normal 0~16, dc to
// norm for alpha adjust, dft = Bit 23:21        reserved Bit 20:16        reg_nr4_dc2norm_lut5 //
// unsigned , default = 16  normal 0~16, dc to norm for alpha adjust, dft = Bit 15:13 reserved Bit
// 12: 8        reg_nr4_dc2norm_lut6         // unsigned , default = 16  normal 0~16, dc to norm
// for alpha adjust, dft = Bit  7: 5        reserved Bit  4: 0        reg_nr4_dc2norm_lut7 //
// unsigned , default = 12  normal 0~16, dc to norm for alpha adjust, dft =
#define NR4_MCNR_DC2NORM_LUT2 ((0x2dda << 2) + 0xff900000)
// Bit 31: 5        reserved
// Bit  4: 0        reg_nr4_dc2norm_lut8        // unsigned , default = 8   normal 0~16, dc to
// norm for alpha adjust, dft =
#define NR4_MCNR_AC2NORM_LUT0 ((0x2ddb << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:24        reg_nr4_ac2norm_lut0         // unsigned , default = 2  normal 0~16, ac to
// norm for alpha adjust, dft = Bit 23:21        reserved Bit 20:16        reg_nr4_ac2norm_lut1 //
// unsigned , default = 16  normal 0~16, ac to norm for alpha adjust, dft = Bit 15:13 reserved Bit
// 12: 8        reg_nr4_ac2norm_lut2         // unsigned , default = 16  normal 0~16, ac to norm
// for alpha adjust, dft = Bit  7: 5        reserved Bit  4: 0        reg_nr4_ac2norm_lut3 //
// unsigned , default = 12  normal 0~16, ac to norm for alpha adjust, dft =
#define NR4_MCNR_AC2NORM_LUT1 ((0x2ddc << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:24        reg_nr4_ac2norm_lut4         // unsigned , default = 4  normal 0~16, ac to
// norm for alpha adjust, dft = Bit 23:21        reserved Bit 20:16        reg_nr4_ac2norm_lut5 //
// unsigned , default = 2  normal 0~16, ac to norm for alpha adjust, dft = Bit 15:13 reserved Bit
// 12: 8        reg_nr4_ac2norm_lut6         // unsigned , default = 1  normal 0~16, ac to norm
// for alpha adjust, dft = Bit  7: 5        reserved Bit  4: 0        reg_nr4_ac2norm_lut7 //
// unsigned , default = 1  normal 0~16, ac to norm for alpha adjust, dft =
#define NR4_MCNR_AC2NORM_LUT2 ((0x2ddd << 2) + 0xff900000)
// Bit 31: 5        reserved
// Bit  4: 0        reg_nr4_ac2norm_lut8         // unsigned , default = 1  normal 0~16, ac to
// norm for alpha adjust, dft =
#define NR4_MCNR_SAD2ALP0_LUT0 ((0x2dde << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2alp0_lut0        // unsigned , default = 255  sad to alpha0 for
// temporal pixel value, dft = 255 Bit 23:16        reg_nr4_sad2alp0_lut1        // unsigned ,
// default = 252  sad to alpha0 for temporal pixel value, dft = 252 Bit 15: 8
// reg_nr4_sad2alp0_lut2
// // unsigned , default = 249  sad to alpha0 for temporal pixel value, dft = 249 Bit  7: 0
// reg_nr4_sad2alp0_lut3        // unsigned , default = 235  sad to alpha0 for temporal pixel
// value, dft = 70
#define NR4_MCNR_SAD2ALP0_LUT1 ((0x2ddf << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2alp0_lut4        // unsigned , default = 185  sad to alpha0 for
// temporal pixel value, dft = 12 Bit 23:16        reg_nr4_sad2alp0_lut5        // unsigned ,
// default = 70  sad to alpha0 for temporal pixel value, dft = 1 Bit 15: 8 reg_nr4_sad2alp0_lut6
// // unsigned , default = 14  sad to alpha0 for temporal pixel value, dft = 0 Bit  7: 0
// reg_nr4_sad2alp0_lut7        // unsigned , default = 1  sad to alpha0 for temporal pixel value,
// dft = 0
#define NR4_MCNR_SAD2ALP0_LUT2 ((0x2de0 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2alp0_lut8        // unsigned , default = 0  sad to alpha0 for
// temporal pixel value, dft = 0 Bit 23:16        reg_nr4_sad2alp0_lut9        // unsigned ,
// default = 0  sad to alpha0 for temporal pixel value, dft = 0 Bit 15: 8 reg_nr4_sad2alp0_lut10
// // unsigned , default = 0  sad to alpha0 for temporal pixel value, dft = 0 Bit  7: 0
// reg_nr4_sad2alp0_lut11       // unsigned , default = 0  sad to alpha0 for temporal pixel value,
// dft = 0
#define NR4_MCNR_SAD2ALP0_LUT3 ((0x2de1 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2alp0_lut12       // unsigned , default = 0  sad to alpha0 for
// temporal pixel value, dft = 0 Bit 23:16        reg_nr4_sad2alp0_lut13       // unsigned ,
// default = 0  sad to alpha0 for temporal pixel value, dft = 0 Bit 15: 8 reg_nr4_sad2alp0_lut14
// // unsigned , default = 0  sad to alpha0 for temporal pixel value, dft = 0 Bit  7: 0
// reg_nr4_sad2alp0_lut15       // unsigned , default = 0  sad to alpha0 for temporal pixel value,
// dft = 0
#define NR4_MCNR_SAD2ALP1_LUT0 ((0x2de2 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2alp1_lut0        // unsigned , default = 192  sad to alpha1 for
// temporal blending, dft = 128 Bit 23:16        reg_nr4_sad2alp1_lut1        // unsigned ,
// default = 160  sad to alpha1 for temporal blending, dft = 128 Bit 15: 8 reg_nr4_sad2alp1_lut2
// // unsigned , default = 128  sad to alpha1 for temporal blending, dft = 128 Bit  7: 0
// reg_nr4_sad2alp1_lut3        // unsigned , default = 96  sad to alpha1 for temporal blending,
// dft = 64
#define NR4_MCNR_SAD2ALP1_LUT1 ((0x2de3 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2alp1_lut4        // unsigned , default = 64  sad to alpha1 for
// temporal blending, dft = 64 Bit 23:16        reg_nr4_sad2alp1_lut5        // unsigned , default
// = 32  sad to alpha1 for temporal blending, dft = 128 Bit 15: 8        reg_nr4_sad2alp1_lut6 //
// unsigned , default = 16  sad to alpha1 for temporal blending, dft = 255 Bit  7: 0
// reg_nr4_sad2alp1_lut7        // unsigned , default = 8  sad to alpha1 for temporal blending,
// dft = 255
#define NR4_MCNR_SAD2ALP1_LUT2 ((0x2de4 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2alp1_lut8        // unsigned , default = 4  sad to alpha1 for
// temporal blending, dft = 255 Bit 23:16        reg_nr4_sad2alp1_lut9        // unsigned ,
// default = 0  sad to alpha1 for temporal blending, dft = 255 Bit 15: 8 reg_nr4_sad2alp1_lut10 //
// unsigned , default = 16  sad to alpha1 for temporal blending, dft = 255 Bit  7: 0
// reg_nr4_sad2alp1_lut11       // unsigned , default = 64  sad to alpha1 for temporal blending,
// dft = 255
#define NR4_MCNR_SAD2ALP1_LUT3 ((0x2de5 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2alp1_lut12       // unsigned , default = 96  sad to alpha1 for
// temporal blending, dft = 255 Bit 23:16        reg_nr4_sad2alp1_lut13       // unsigned ,
// default = 224  sad to alpha1 for temporal blending, dft = 255 Bit 15: 8 reg_nr4_sad2alp1_lut14
// // unsigned , default = 255  sad to alpha1 for temporal blending, dft = 255 Bit  7: 0
// reg_nr4_sad2alp1_lut15       // unsigned , default = 255  sad to alpha1 for temporal blending,
// dft = 255
#define NR4_MCNR_SAD2BET0_LUT0 ((0x2de6 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2bet0_lut0        // unsigned , default = 0  sad to beta0 for tnr
// and mcnr blending, dft = 0 Bit 23:16        reg_nr4_sad2bet0_lut1        // unsigned , default
// = 2  sad to beta0 for tnr and mcnr blending, dft = 2 Bit 15: 8        reg_nr4_sad2bet0_lut2 //
// unsigned , default = 4  sad to beta0 for tnr and mcnr blending, dft = 4 Bit  7: 0
// reg_nr4_sad2bet0_lut3        // unsigned , default = 8  sad to beta0 for tnr and mcnr blending,
// dft = 8
#define NR4_MCNR_SAD2BET0_LUT1 ((0x2de7 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2bet0_lut4        // unsigned , default = 16  sad to beta0 for tnr
// and mcnr blending, dft = 16 Bit 23:16        reg_nr4_sad2bet0_lut5        // unsigned , default
// = 32  sad to beta0 for tnr and mcnr blending, dft = 32 Bit 15: 8        reg_nr4_sad2bet0_lut6
// // unsigned , default = 48  sad to beta0 for tnr and mcnr blending, dft = 48 Bit  7: 0
// reg_nr4_sad2bet0_lut7        // unsigned , default = 64  sad to beta0 for tnr and mcnr
// blending, dft = 64
#define NR4_MCNR_SAD2BET0_LUT2 ((0x2de8 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2bet0_lut8        // unsigned , default = 80  sad to beta0 for tnr
// and mcnr blending, dft = 80 Bit 23:16        reg_nr4_sad2bet0_lut9        // unsigned , default
// = 96  sad to beta0 for tnr and mcnr blending, dft = 96 Bit 15: 8        reg_nr4_sad2bet0_lut10
// // unsigned , default = 112  sad to beta0 for tnr and mcnr blending, dft = 112 Bit  7: 0
// reg_nr4_sad2bet0_lut11       // unsigned , default = 128  sad to beta0 for tnr and mcnr
// blending, dft = 128
#define NR4_MCNR_SAD2BET0_LUT3 ((0x2de9 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2bet0_lut12       // unsigned , default = 196  sad to beta0 for tnr
// and mcnr blending, dft = 160 Bit 23:16        reg_nr4_sad2bet0_lut13       // unsigned ,
// default = 224  sad to beta0 for tnr and mcnr blending, dft = 192 Bit 15: 8
// reg_nr4_sad2bet0_lut14
// // unsigned , default = 255  sad to beta0 for tnr and mcnr blending, dft = 224 Bit  7: 0
// reg_nr4_sad2bet0_lut15       // unsigned , default = 255  sad to beta0 for tnr and mcnr
// blending, dft = 255
#define NR4_MCNR_SAD2BET1_LUT0 ((0x2dea << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2bet1_lut0        // unsigned , default = 0  sad to beta1 for
// deghost blending, dft = 0 Bit 23:16        reg_nr4_sad2bet1_lut1        // unsigned , default =
// 2  sad to beta1 for deghost blending, dft = 2 Bit 15: 8        reg_nr4_sad2bet1_lut2        //
// unsigned , default = 4  sad to beta1 for deghost blending, dft = 4 Bit  7: 0
// reg_nr4_sad2bet1_lut3        // unsigned , default = 8  sad to beta1 for deghost blending, dft
// =
// 8
#define NR4_MCNR_SAD2BET1_LUT1 ((0x2deb << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2bet1_lut4        // unsigned , default = 16  sad to beta1 for
// deghost blending, dft = 16 Bit 23:16        reg_nr4_sad2bet1_lut5        // unsigned , default
// = 32  sad to beta1 for deghost blending, dft = 32 Bit 15: 8        reg_nr4_sad2bet1_lut6 //
// unsigned , default = 48  sad to beta1 for deghost blending, dft = 48 Bit  7: 0
// reg_nr4_sad2bet1_lut7        // unsigned , default = 64  sad to beta1 for deghost blending, dft
// = 64
#define NR4_MCNR_SAD2BET1_LUT2 ((0x2dec << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2bet1_lut8        // unsigned , default = 80  sad to beta1 for
// deghost blending, dft = 80 Bit 23:16        reg_nr4_sad2bet1_lut9        // unsigned , default
// = 96  sad to beta1 for deghost blending, dft = 96 Bit 15: 8        reg_nr4_sad2bet1_lut10 //
// unsigned , default = 112  sad to beta1 for deghost blending, dft = 112 Bit  7: 0
// reg_nr4_sad2bet1_lut11       // unsigned , default = 128  sad to beta1 for deghost blending,
// dft = 128
#define NR4_MCNR_SAD2BET1_LUT3 ((0x2ded << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2bet1_lut12       // unsigned , default = 160  sad to beta1 for
// deghost blending, dft = 160 Bit 23:16        reg_nr4_sad2bet1_lut13       // unsigned , default
// = 192  sad to beta1 for deghost blending, dft = 192 Bit 15: 8        reg_nr4_sad2bet1_lut14 //
// unsigned , default = 224  sad to beta1 for deghost blending, dft = 224 Bit  7: 0
// reg_nr4_sad2bet1_lut15       // unsigned , default = 255  sad to beta1 for deghost blending,
// dft = 255
#define NR4_MCNR_SAD2BET2_LUT0 ((0x2dee << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2bet2_lut0        // unsigned , default = 0  sad to beta2 for snr
// and mcnr blending, dft = 0 Bit 23:16        reg_nr4_sad2bet2_lut1        // unsigned , default
// = 1  sad to beta2 for snr and mcnr blending, dft = 2 Bit 15: 8        reg_nr4_sad2bet2_lut2 //
// unsigned , default = 2  sad to beta2 for snr and mcnr blending, dft  = 4 Bit  7: 0
// reg_nr4_sad2bet2_lut3        // unsigned , default = 4  sad to beta2 for snr and mcnr blending,
// dft = 8
#define NR4_MCNR_SAD2BET2_LUT1 ((0x2def << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2bet2_lut4        // unsigned , default = 8  sad to beta2 for snr
// and mcnr blending, dft = 16 Bit 23:16        reg_nr4_sad2bet2_lut5        // unsigned , default
// = 16  sad to beta2 for snr and mcnr blending, dft = 32 Bit 15: 8        reg_nr4_sad2bet2_lut6
// // unsigned , default = 32  sad to beta2 for snr and mcnr blending, dft = 48 Bit  7: 0
// reg_nr4_sad2bet2_lut7        // unsigned , default = 48  sad to beta2 for snr and mcnr
// blending, dft = 64
#define NR4_MCNR_SAD2BET2_LUT2 ((0x2df0 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2bet2_lut8        // unsigned , default = 64  sad to beta2 for snr
// and mcnr blending, dft = 80 Bit 23:16        reg_nr4_sad2bet2_lut9        // unsigned , default
// = 80  sad to beta2 for snr and mcnr blending, dft = 96 Bit 15: 8        reg_nr4_sad2bet2_lut10
// // unsigned , default = 96  sad to beta2 for snr and mcnr blending, dft = 112 Bit  7: 0
// reg_nr4_sad2bet2_lut11       // unsigned , default = 112  sad to beta2 for snr and mcnr
// blending, dft = 128
#define NR4_MCNR_SAD2BET2_LUT3 ((0x2df1 << 2) + 0xff900000)
// Bit 31:24        reg_nr4_sad2bet2_lut12       // unsigned , default = 128  sad to beta2 for snr
// and mcnr blending, dft = 160 Bit 23:16        reg_nr4_sad2bet2_lut13       // unsigned ,
// default = 160  sad to beta2 for snr and mcnr blending, dft = 192 Bit 15: 8
// reg_nr4_sad2bet2_lut14
// // unsigned , default = 224  sad to beta2 for snr and mcnr blending, dft = 224 Bit  7: 0
// reg_nr4_sad2bet2_lut15       // unsigned , default = 255  sad to beta2 for snr and mcnr
// blending, dft = 255
#define NR4_MCNR_RO_U_SUM ((0x2df2 << 2) + 0xff900000)
// Bit 31: 0        ro_nr4_u_sum                // unsigned , default = 0  sum of U of current
// field/frame
#define NR4_MCNR_RO_V_SUM ((0x2df3 << 2) + 0xff900000)
// Bit 31: 0        ro_nr4_v_sum                // unsigned , default = 0  sum of V of current
// field/frame
#define NR4_MCNR_RO_GRDU_SUM ((0x2df4 << 2) + 0xff900000)
// Bit 31: 0        ro_nr4_grdu_sum             // unsigned , default = 0  sum of gradient U of
// current field/frame
#define NR4_MCNR_RO_GRDV_SUM ((0x2df5 << 2) + 0xff900000)
// Bit 31: 0        ro_nr4_grdv_sum             // unsigned , default = 0  sum of gradient V of
// current field/frame
#define NR4_TOP_CTRL ((0x2dff << 2) + 0xff900000)
// Bit 31:20        reg_gclk_ctrl                 // unsigned , default = 0
// Bit 19           reserved
// Bit 18           reg_nr4_mcnr_en              // unsigned , default = 1  ncnr enable or bypass,
// dft = 1 Bit 17           reg_nr2_en                 // unsigned , default = 1  nr2 enable, dft
// = 1 Bit 16           reg_nr4_en                   // unsigned , default = 1  nr4 enable, dft =
// 1 Bit 15           reg_nr2_proc_en            // unsigned , default = 1 Bit 14 reg_det3d_en //
// unsigned , default = 1 Bit 13           di_polar_en                   // unsigned , default = 1
// do does not have in C Bit 12           reg_cfr_enable             // unsigned , default = 0
// 0-disable;  1:enable Bit 11: 9        reg_3dnr_enable_l          // unsigned , default = 7  b0:
// Y b1:U b2:V Bit  8: 6        reg_3dnr_enable_r          // unsigned , default = 7  b0: Y b1:U
// b2:V Bit  5           reg_nr4_lnbuf_ctrl           // unsigned , default = 1  line buf ctrl for
// nr4: 0, 3lines, 1, 5lines, dft = 1 Bit  4           reg_nr4_snr2_en              // unsigned ,
// default = 0  snr2 enable, 0: use old snr, 1: use new snr2,   dft = 1 Bit  3
// reg_nr4_scene_change_en      // unsigned , default = 1  enable scene change proc. dft = 1 Bit 2
// nr2_sw_en                     // unsigned , default = 1  do does not have in C Bit  1 reserved
// Bit  0           reg_nr4_scene_change_flg     // unsigned , default = 0  flags for scene
// change, dft = 0
//========== nr4_mcnr_regs register end ==========//
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpu_nr4_regs.h
//
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpu_dnr_regs.h
//
//===========================================================================
//`define VI_HIST_SPL_VCBUS_BASE                   8'h2e
// VI_HIST_SPL register    (16'h2e00 - 16'h2eff)
//===========================================================================
//
// Reading file:  vi_hist_spl_reg.h
//
// synopsys translate_off
// synopsys translate_on
// ----------------------------
// VI_HIST_SPL 0x2e
// ----------------------------
// -----------------------------------------------
// CBUS_BASE:  VI_HIST_SPL_VCBUS_BASE = 0x2e
// -----------------------------------------------
// BIT 14: 34bin only, 0&255 and other 32bins
// Bit 13:11 hist_din_sel, 00: from vdin0 dout,  1: from vdin1, 2: from nr dout, 3: di output, 4:
// vpp output, 5: vd1_din, 6: vd2_din, 7:osd1_dout Bit 10:8   hist_din_comp_mux, mux of [29:22],
// [19:12], [9:2] for hist detect Bit 7:5   hist_dnlp_low   the real pixels in each bins got by
// VI_DNLP_HISTXX should multiple with 2^(dnlp_low+3) Bit 3:2   hist_din_sel    the source used
// for hist statistics.  00: from matrix0 dout,  01: from vsc_dout, 10: from matrix1 dout, 11:
// form matrix1 din Bit 1     hist_win_en     1'b0: hist used for full picture; 1'b1: hist used
// for pixels within hist window Bit 0     hist_spl_en     1'b0: disable hist readback; 1'b1:
// enable hist readback
#define VI_HIST_CTRL ((0x2e00 << 2) + 0xff900000)
// Bit 28:16 hist_hstart  horizontal start value to define hist window
// Bit 12:0  hist_hend    horizontal end value to define hist window
#define VI_HIST_H_START_END ((0x2e01 << 2) + 0xff900000)
// Bit 28:16 hist_vstart  vertical start value to define hist window
// Bit 12:0  hist_vend    vertical end value to define hist window
#define VI_HIST_V_START_END ((0x2e02 << 2) + 0xff900000)
// Bit 15:8  hist_max    maximum value
// Bit 7:0   hist_min    minimum value
// read only
#define VI_HIST_MAX_MIN ((0x2e03 << 2) + 0xff900000)
// Bit 31:0  hist_spl_rd
// counts for the total luma value
// read only
#define VI_HIST_SPL_VAL ((0x2e04 << 2) + 0xff900000)
// Bit 21:0  hist_spl_pixel_count
// counts for the total calculated pixels
// read only
#define VI_HIST_SPL_PIX_CNT ((0x2e05 << 2) + 0xff900000)
// Bit 31:0  hist_chroma_sum
// counts for the total chroma value
// read only
#define VI_HIST_CHROMA_SUM ((0x2e06 << 2) + 0xff900000)
// Bit 31:16 higher hist bin
// Bit 15:0  lower hist bin
// 0-255 are splited to 64 bins evenly, and VI_DNLP_HISTXX
// are the statistic number of pixels that within each bin.
// VI_DNLP_HIST00[15:0]  counts for the first  bin
// VI_DNLP_HIST00[31:16] counts for the second bin
// VI_DNLP_HIST01[15:0]  counts for the third  bin
// VI_DNLP_HIST01[31:16] counts for the fourth bin
// etc...
// read only
#define VI_DNLP_HIST00 ((0x2e07 << 2) + 0xff900000)
#define VI_DNLP_HIST01 ((0x2e08 << 2) + 0xff900000)
#define VI_DNLP_HIST02 ((0x2e09 << 2) + 0xff900000)
#define VI_DNLP_HIST03 ((0x2e0a << 2) + 0xff900000)
#define VI_DNLP_HIST04 ((0x2e0b << 2) + 0xff900000)
#define VI_DNLP_HIST05 ((0x2e0c << 2) + 0xff900000)
#define VI_DNLP_HIST06 ((0x2e0d << 2) + 0xff900000)
#define VI_DNLP_HIST07 ((0x2e0e << 2) + 0xff900000)
#define VI_DNLP_HIST08 ((0x2e0f << 2) + 0xff900000)
#define VI_DNLP_HIST09 ((0x2e10 << 2) + 0xff900000)
#define VI_DNLP_HIST10 ((0x2e11 << 2) + 0xff900000)
#define VI_DNLP_HIST11 ((0x2e12 << 2) + 0xff900000)
#define VI_DNLP_HIST12 ((0x2e13 << 2) + 0xff900000)
#define VI_DNLP_HIST13 ((0x2e14 << 2) + 0xff900000)
#define VI_DNLP_HIST14 ((0x2e15 << 2) + 0xff900000)
#define VI_DNLP_HIST15 ((0x2e16 << 2) + 0xff900000)
#define VI_DNLP_HIST16 ((0x2e17 << 2) + 0xff900000)
#define VI_DNLP_HIST17 ((0x2e18 << 2) + 0xff900000)
#define VI_DNLP_HIST18 ((0x2e19 << 2) + 0xff900000)
#define VI_DNLP_HIST19 ((0x2e1a << 2) + 0xff900000)
#define VI_DNLP_HIST20 ((0x2e1b << 2) + 0xff900000)
#define VI_DNLP_HIST21 ((0x2e1c << 2) + 0xff900000)
#define VI_DNLP_HIST22 ((0x2e1d << 2) + 0xff900000)
#define VI_DNLP_HIST23 ((0x2e1e << 2) + 0xff900000)
#define VI_DNLP_HIST24 ((0x2e1f << 2) + 0xff900000)
#define VI_DNLP_HIST25 ((0x2e20 << 2) + 0xff900000)
#define VI_DNLP_HIST26 ((0x2e21 << 2) + 0xff900000)
#define VI_DNLP_HIST27 ((0x2e22 << 2) + 0xff900000)
#define VI_DNLP_HIST28 ((0x2e23 << 2) + 0xff900000)
#define VI_DNLP_HIST29 ((0x2e24 << 2) + 0xff900000)
#define VI_DNLP_HIST30 ((0x2e25 << 2) + 0xff900000)
#define VI_DNLP_HIST31 ((0x2e26 << 2) + 0xff900000)
#define VI_DNLP_HIST32 ((0x2e27 << 2) + 0xff900000)
// Bit 28:16 hist_pic_height  active input data window height
// Bit 12:0  hist_pic_width   active input data window width
#define VI_HIST_PIC_SIZE ((0x2e28 << 2) + 0xff900000)
// Bit 15:8 hist_pix_white_value: >= this value will be white pixel
// Bit 7:0 hist_pix_black_value: <= this value will be black pixel
#define VI_HIST_BLACK_WHITE_VALUE ((0x2e29 << 2) + 0xff900000)
#define VI_HIST_GCLK_CTRL ((0x2e2a << 2) + 0xff900000)
// 0x30-0x8f
//
// Reading file:  aisr_post_reg.h
//
// VCBUS_BASE                   8'h2e
// 0x30-0x6f
//
// Reading file:  aisr_reshap_regs.h
//
// synopsys translate_off
// synopsys translate_on
// VCBUS_BASE                   8'h2e
#define AISR_RESHAP_CTRL0 ((0x2e40 << 2) + 0xff900000)
// Bit 31:15 reserved
// Bit 14:12 reg_cmd_intr_len  // unsigned , default = 1, interrupt send cmd when how many series
// axi cmd, Bit 11:10 reg_cmd_req_size  // unsigned , default = 1, how many room fifo have, then
// axi send series req, 0=16 1=32 2=24 3=64 Bit 9:8   reg_burst_len     // unsigned , default = 2,
// burst type: 0-single 1-bst2 2-bst4 Bit 7     reg_swap_64bit    // unsigned , default = 0,
// 64bits of 128bit swap enable Bit 6     reg_little_endian // unsigned , default = 0, big endian
// enable Bit 5     reg_y_rev         // unsigned , default = 0, vertical reverse enable Bit 4
// reg_x_rev         // unsigned , default = 0, horizontal reverse enable Bit 3     reserved Bit
// 2:0   reg_pack_mode     // unsigned , default = 1, 0:4bit 1:8bit 2:16bit 3:32bit 4:64bit
// 5:128bit
#define AISR_RESHAP_CTRL1 ((0x2e41 << 2) + 0xff900000)
// Bit 31:27 reserved
// Bit 26:24 reg_hloop_num     // unsigned , default = 1 the hor reshape size
// Bit 23    reserved
// Bit 22:20 reg_vloop_num     // unsigned , default = 1 the hor reshape size
// Bit 19:16 reg_vstep         // unsigned , default = 1
// Bit 15:13 reserved
// Bit 12:0  reg_stride        // unsigned , default = 4096
#define AISR_RESHAP_CTRL2 ((0x2e42 << 2) + 0xff900000)
// Bit 31    reserved
// Bit 30    reg_hold_en       // unsigned , default = 0
// Bit 29:24 reg_pass_num      // unsigned , default = 1
// Bit 23:18 reg_hold_num      // unsigned , default = 0
// Bit 17    reserved
// Bit 16:0  reg_urgent_ctrl   // unsigned , default = 0, urgent control reg :
#define AISR_RESHAP_SCOPE_X ((0x2e43 << 2) + 0xff900000)
// Bit 31:29 reserved
// Bit 28:16 reg_x_end         // unsigned , default = 4095, the canvas hor end pixel position
// Bit 15:13 reserved
// Bit 12: 0 reg_x_start       // unsigned , default = 0, the canvas hor start pixel position
#define AISR_RESHAP_SCOPE_Y ((0x2e44 << 2) + 0xff900000)
// Bit 31:29 reserved
// Bit 28:16 reg_y_end         // unsigned , default = 0, the canvas ver end pixel position
// Bit 15:13 reserved
// Bit 12: 0 reg_y_start       // unsigned , default = 0, the canvas ver start pixel positio
#define AISR_RESHAP_BADDR00 ((0x2e45 << 2) + 0xff900000)
// Bit 31:0  reg_baddr00       // unsigned , default = 0, the (0,0) base addr for reshape
#define AISR_RESHAP_BADDR01 ((0x2e46 << 2) + 0xff900000)
// Bit 31:0  reg_baddr01       // unsigned , default = 0, the (0,1) base addr for reshape
#define AISR_RESHAP_BADDR02 ((0x2e47 << 2) + 0xff900000)
// Bit 31:0  reg_baddr02       // unsigned , default = 0, the (0,2) base addr for reshape
#define AISR_RESHAP_BADDR03 ((0x2e48 << 2) + 0xff900000)
// Bit 31:0  reg_baddr03       // unsigned , default = 0, the (0,3) base addr for reshape
#define AISR_RESHAP_BADDR10 ((0x2e49 << 2) + 0xff900000)
// Bit 31:0  reg_baddr10       // unsigned , default = 0, the (1,0) base addr for reshape
#define AISR_RESHAP_BADDR11 ((0x2e4a << 2) + 0xff900000)
// Bit 31:0  reg_baddr11       // unsigned , default = 0, the (1,1) base addr for reshape
#define AISR_RESHAP_BADDR12 ((0x2e4b << 2) + 0xff900000)
// Bit 31:0  reg_baddr12       // unsigned , default = 0, the (1,2) base addr for reshape
#define AISR_RESHAP_BADDR13 ((0x2e4c << 2) + 0xff900000)
// Bit 31:0  reg_baddr13       // unsigned , default = 0, the (1,3) base addr for reshape
#define AISR_RESHAP_BADDR20 ((0x2e4d << 2) + 0xff900000)
// Bit 31:0  reg_baddr20       // unsigned , default = 0, the (2,0) base addr for reshape
#define AISR_RESHAP_BADDR21 ((0x2e4e << 2) + 0xff900000)
// Bit 31:0  reg_baddr21       // unsigned , default = 0, the (2,1) base addr for reshape
#define AISR_RESHAP_BADDR22 ((0x2e4f << 2) + 0xff900000)
// Bit 31:0  reg_baddr22       // unsigned , default = 0, the (2,2) base addr for reshape
#define AISR_RESHAP_BADDR23 ((0x2e50 << 2) + 0xff900000)
// Bit 31:0  reg_baddr23       // unsigned , default = 0, the (2,3) base addr for reshape
#define AISR_RESHAP_BADDR30 ((0x2e51 << 2) + 0xff900000)
// Bit 31:0  reg_baddr30       // unsigned , default = 0, the (3,0) base addr for reshape
#define AISR_RESHAP_BADDR31 ((0x2e52 << 2) + 0xff900000)
// Bit 31:0  reg_baddr31       // unsigned , default = 0, the (3,1) base addr for reshape
#define AISR_RESHAP_BADDR32 ((0x2e53 << 2) + 0xff900000)
// Bit 31:0  reg_baddr32       // unsigned , default = 0, the (3,2) base addr for reshape
#define AISR_RESHAP_BADDR33 ((0x2e54 << 2) + 0xff900000)
// Bit 31:0  reg_baddr33       // unsigned , default = 0, the (3,3) base addr for reshape
#define AISR_RESHAP_MISC ((0x2e55 << 2) + 0xff900000)
// Bit 31:24 reserved
// Bit 23:16 reg_sw_rst        // unsigned , default = 0,
// Bit 15: 8 reg_int_clr       // unsigned , default = 0,
// Bit  7: 0 reserved
#define AISR_RESHAP_GATE ((0x2e56 << 2) + 0xff900000)
// Bit 31:0  reg_gclk_ctrl     // unsigned , default = 0,
#define AISR_RESHAP_RO_STAT_0 ((0x2e57 << 2) + 0xff900000)
// Bit 31:16 ro_status_1      // unsigned ,
// Bit 15:0  ro_status_0      // unsigned ,
#define AISR_RESHAP_RO_STAT_1 ((0x2e58 << 2) + 0xff900000)
// Bit 31:16 ro_status_3      // unsigned ,
// Bit 15:0  ro_status_2      // unsigned ,
#define AISR_POST_CTRL ((0x2e5a << 2) + 0xff900000)
// Bit 31:0 reg_post_ctrl      // unsigned , default = 0,
#define AISR_POST_SIZE ((0x2e5b << 2) + 0xff900000)
// Bit 31:0 reg_post_size      // unsigned , default = 0x4380780,
#define AISR_AXIRD_BADDR ((0x2e60 << 2) + 0xff900000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  aisr_reshap_regs.h
//
// 0x70-0x8f
//
// Reading file:  vpp_scale_schn_reg.h
//
// synopsys translate_off
// synopsys translate_on
#define SCHN_SCALE_COEF_IDX ((0x2e70 << 2) + 0xff900000)
// Bit 31:20        reserved
// Bit 19:17        reg_type_index_ext        // unsigned ,    RW, default = 0  default = 0x0
// ,type of index, 000: vertical coef, 001: vertical chroma coef: 010: horizontal coef part A,
// 011: horizontal coef part B, 100: horizontal chroma coef part A, 101: horizontal chroma coef
// part B Bit 16           reg_ctype_ext_mode        // unsigned ,    RW, default = 0  default =
// 0x0 , if true use type_index_ext rather than reg_type_index Bit 15           reg_index_inc //
// unsigned ,    RW, default = 0  default	= 0x0 ,default = 0x0 ,index increment, if bit9 ==
// 1 then (0: index increase 1, 1: index increase 2) else (index increase 2) Bit 14
// reg_rd_cbus_coef_en       // unsigned ,    RW, default = 0  default = 0x0 ,1: read coef through
// cbus enable, just for debug purpose in case when we wanna check the coef in ram in correct or
// not Bit 13           reg_vf_sep_coef_en        // unsigned ,    RW, default = 0  default = 0x0
// ,if true, vertical separated coef enable Bit 12:10        reserved Bit  9 reg_high_reso_en //
// unsigned ,    RW, default = 0  default	= 0x0 ,default = 0x0 ,if true, use 9bit resolution
// coef, other use 8bit resolution coef Bit  8: 7        reg_type_index            // unsigned ,
// RW, default = 0  default	= 0x0 ,default = 0x0 ,type of index, 00: vertical coef, 01:
// vertical chroma coef: 10: horizontal coef, 11: resevered Bit  6: 0        reg_coef_index //
// unsigned ,    RW, default = 0  default	= 0x0 ,coef	index
#define SCHN_SCALE_COEF ((0x2e71 << 2) + 0xff900000)
// Bit 31:24        reg_coef0                 // signed ,    RW, default = 0  default	= 0x0 ,
// coefficients for vertical filter and horizontal	filter Bit 23:16        reg_coef1 //
// signed ,    RW, default = 0  default	= 0x0 ,	coefficients for vertical filter and horizontal
// filter Bit 15: 8        reg_coef2                 // signed ,    RW, default = 0  default
// = 0x0 ,	coefficients for vertical filter and horizontal	filter Bit  7: 0        reg_coef3
// // signed ,    RW, default = 0  default	= 0x0 ,	coefficients for vertical filter and
// horizontal	filter
#define SCHN_VSC_REGION12_STARTP ((0x2e72 << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:16        reg_vsc_region1_startp    // unsigned ,    RW, default = 0  default	= 0
// ,region1 startp Bit 15:13        reserved Bit 12: 0        reg_vsc_region2_startp    //
// unsigned ,    RW, default = 0  default	= 0	,region2 startp
#define SCHN_VSC_REGION34_STARTP ((0x2e73 << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:16        reg_vsc_region3_startp    // unsigned ,    RW, default = 13'h0438  default
// =0x0438,region3	startp Bit 15:13        reserved Bit 12: 0        reg_vsc_region4_startp
// // unsigned ,    RW, default = 13'h0438  default	=0x0438,region4	startp
#define SCHN_VSC_REGION4_ENDP ((0x2e74 << 2) + 0xff900000)
// Bit 31:13        reserved
// Bit 12: 0        reg_vsc_region4_endp      // unsigned ,    RW, default = 1079  default
// =13'd1079,region4 endp
#define SCHN_VSC_START_PHASE_STEP ((0x2e75 << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:24        reg_vsc_integer_part      // unsigned ,    RW, default = 1  default
// =1,vertical	start phase	step,(source/dest)*(2^24),integer part	of	step Bit 23: 0
// reg_vsc_fraction_part     // unsigned ,    RW, default = 0  default	=0,vertical	start
// phase	step,(source/dest)*(2^24),fraction part	of	step
#define SCHN_VSC_REGION0_PHASE_SLOPE ((0x2e76 << 2) + 0xff900000)
// Bit 31:25        reserved
// Bit 24: 0        reg_vsc_region0_phase_slope // unsigned ,    RW, default = 0  default
// =0,vertical	scaler region0 phase slope,region0 phase slope
#define SCHN_VSC_REGION1_PHASE_SLOPE ((0x2e77 << 2) + 0xff900000)
// Bit 31:25        reserved
// Bit 24: 0        reg_vsc_region1_phase_slope // unsigned ,    RW, default = 0  default	=
// 0,region1	phase slope
#define SCHN_VSC_REGION3_PHASE_SLOPE ((0x2e78 << 2) + 0xff900000)
// Bit 31:25        reserved
// Bit 24: 0        reg_vsc_region3_phase_slope // unsigned ,    RW, default = 0  default	=
// 0,region3	phase slope
#define SCHN_VSC_REGION4_PHASE_SLOPE ((0x2e79 << 2) + 0xff900000)
// Bit 31:25        reserved
// Bit 24: 0        reg_vsc_region4_phase_slope // unsigned ,    RW, default = 0  default	=
// 0,region4	phase slope
#define SCHN_VSC_PHASE_CTRL ((0x2e7a << 2) + 0xff900000)
// Bit 31:19        reserved
// Bit 18:17        reg_vsc_double_line_mode  // unsigned ,    RW, default = 0  default	= 0,double
// line	mode, input/output line	width of vscaler becomes 2X, so	only 2 line buffer in this case,
// use for 3D line by line interlace scaling bit1 true, double the input width and half input
// height, bit0 true, change line buffer 2 lines instead of 4 lines Bit 16 reg_vsc_prog_interlace
// // unsigned ,    RW, default = 0  default	= 0,0:progressive	output,	1:interlace
// output Bit 15           reg_vsc_bot_l0_out_en     // unsigned ,    RW, default = 0  default =
// 0,vertical	scaler	output	line0	in	advance	or	not	for	bottom	field Bit
// 14:13        reg_vsc_bot_rpt_l0_num    // unsigned ,    RW, default = 1  default	=
// 1,vertical	scaler	initial	repeat	line0	number	for	bottom	field Bit 12 reserved Bit
// 11: 8        reg_vsc_bot_ini_rcv_num   // unsigned ,    RW, default = 4  default	=
// 4,vertical	scaler	initial	receiving	number	for	bottom	field Bit  7
// reg_vsc_top_l0_out_en     // unsigned ,    RW, default = 0  default	= 0,vertical scaler
// output	line0	in	advance	or	not	for	top	field Bit  6: 5
// reg_vsc_top_rpt_l0_num    // unsigned ,    RW, default = 1  default	= 1,vertical scaler
// initial	repeat	line0	number	for	top	field Bit  4            reserved Bit  3: 0
// reg_vsc_top_ini_rcv_num   // unsigned ,    RW, default = 4  default	= 4,vertical scaler
// initial	receiving	number	for	top	field
#define SCHN_VSC_INI_PHASE ((0x2e7b << 2) + 0xff900000)
// Bit 31:16        reg_vsc_bot_ini_phase     // unsigned ,    RW, default = 0  default	=
// 0,vertical	scaler	field	initial	phase	for	bottom	field	Bit. Bit 15: 0
// reg_vsc_top_ini_phase     // unsigned ,    RW, default = 0  default	=	0,vertical
// scaler	field	initial	phase	for	top	field
#define SCHN_HSC_REGION12_STARTP ((0x2e7c << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:16        reg_hsc_region1_startp    // unsigned ,    RW, default = 0  default	=
// 0,region1	startp Bit 15:13        reserved Bit 12: 0        reg_hsc_region2_startp    //
// unsigned ,    RW, default = 0  default	=	0,region2	startp
#define SCHN_HSC_REGION34_STARTP ((0x2e7d << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:16        reg_hsc_region3_startp    // unsigned ,    RW, default = 13'h780  default =
// 0x780,region3	startp Bit 15:13        reserved Bit 12: 0        reg_hsc_region4_startp
// // unsigned ,    RW, default = 13'h780  default	=	0x780,region4	startp
#define SCHN_HSC_REGION4_ENDP ((0x2e7e << 2) + 0xff900000)
// Bit 31:13        reserved
// Bit 12: 0        reg_hsc_region4_endp      // unsigned ,    RW, default = 1919  default	=
// 13'd1919,region4	startp
#define SCHN_HSC_START_PHASE_STEP ((0x2e7f << 2) + 0xff900000)
// Bit 31:28        reserved
// Bit 27:24        reg_hsc_integer_part      // unsigned ,    RW, default = 1  default	=
// 1,integer	part	of	step Bit 23: 0        reg_hsc_fraction_part     // unsigned , RW,
// default = 0  default	=	0,fraction	part	of	step
#define SCHN_HSC_REGION0_PHASE_SLOPE ((0x2e80 << 2) + 0xff900000)
// Bit 31:25        reserved
// Bit 24: 0        reg_hsc_region0_phase_slope // unsigned ,    RW, default = 0  default	=
// 0,region0	phase	slope
#define SCHN_HSC_REGION1_PHASE_SLOPE ((0x2e81 << 2) + 0xff900000)
// Bit 31:25        reserved
// Bit 24: 0        reg_hsc_region1_phase_slope // unsigned ,    RW, default = 0  default	=
// 0,region1	phase	slope
#define SCHN_HSC_REGION3_PHASE_SLOPE ((0x2e82 << 2) + 0xff900000)
// Bit 31:25        reserved
// Bit 24: 0        reg_hsc_region3_phase_slope // unsigned ,    RW, default = 0  default	=
// 0,region3	phase	slope
#define SCHN_HSC_REGION4_PHASE_SLOPE ((0x2e83 << 2) + 0xff900000)
// Bit 31:25        reserved
// Bit 24: 0        reg_hsc_region4_phase_slope // unsigned ,    RW, default = 0  default	=
// 0,region4	phase	slope
#define SCHN_HSC_PHASE_CTRL ((0x2e84 << 2) + 0xff900000)
// Bit 31:24        reserved
// Bit 23:20        reg_hsc_rpt_p0_num0       // unsigned ,    RW, default = 1  default	= 1
// ,horizontal	scaler	initial	repeat	pixel0	number0 Bit 19:16        reg_hsc_ini_rcv_num0 //
// unsigned ,    RW, default = 4  default	=	4	,horizontal	scaler	initial
// receiving number0 Bit 15: 0        reg_hsc_ini_phase0        // unsigned ,    RW, default = 0
// default	=	0	,horizontal	scaler	top	field initial phase0
#define SCHN_SC_MISC ((0x2e85 << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25           reg_hf_sep_coef_4srnet_en // unsigned ,    RW, default = 0  default = 0x0, if
// true, horizontal separated coef in normal path for SRNet enable Bit 24 reg_repeat_last_line_en
// // unsigned ,    RW, default = 0  1,enable	repeat last line 0:disable repeat last line Bit 23
// reg_old_prehsc_en         // unsigned ,    RW, default = 0  default	=	0	,prehsc_en
// Bit 22           reg_hsc_len_div2_en       // unsigned ,    RW, default = 0  default	= 0
// ,if	true,divide VSC line length 2 as the HSC input length, othwise VSC line lengthjust for
// special usage, more flexibility Bit 21           reg_prevsc_lbuf_mode      // unsigned ,    RW,
// default = 0  default	=	0	,if	true, prevsc uses line buffer, otherwise prevsc
// does not use line buffer, it should	be same as prevsc_en Bit 20           reg_prehsc_en //
// unsigned ,    RW, default = 0  default = 0,prehsc_en Bit 19 reg_prevsc_en //
// unsigned ,    RW, default = 0  default = 0,prevsc_en Bit 18 reg_vsc_en //
// unsigned ,    RW, default = 0  default = 0,vsc_en Bit 17 reg_hsc_en // unsigned ,
// RW, default = 0  default	=	0	,hsc_en Bit 16 reg_sc_top_en // unsigned ,    RW,
// default = 0  default	=	0	,scale_top_en Bit 15 reg_sc_vd_en
// // unsigned ,    RW, default = 1  default	=	0	,video1	scale out enable Bit 14
// reserved Bit 13           reg_hsc_nonlinear_4region_en // unsigned ,    RW, default = 0 default
// =	1	,if	true, region0,region4 are nonlinear	regions, otherwise they	are
// not	scaling	regions, for horizontal	scaler Bit 12            reserved Bit 11: 8
// reg_hsc_bank_length       // unsigned ,    RW, default = 4  default	=	0
// ,horizontal	scaler	bank	length Bit  7: 6        reserved Bit  5 reg_vsc_phase_field_mode
// // unsigned ,    RW, default = 0  default	=	0	,vertical scaler phase field mode,
// if true,	disable	the	opposite parity	line output, more bandwidth needed if output
// 1080i Bit  4           reg_vsc_nonlinear_4region_en // unsigned ,    RW, default = 0  default =
// 0	,if	true, region0,region4 are nonlinear	regions, otherwise they	are
// not	scaling	regions, for vertical scaler Bit  3            reserved Bit  2: 0
// reg_vsc_bank_length       // unsigned ,    RW, default = 4  default	=	4	,vertical
// scaler	bank	length
#define SCHN_SCO_FIFO_CTRL ((0x2e86 << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:16        reg_sco_fifo_line_lenm1   // unsigned ,    RW, default = 13'hfff  default =
// 0xfff,	scale	out	fifo	line	length	minus	1 Bit 15:13        reserved Bit
// 12: 0        reg_sco_fifo_size         // unsigned ,    RW, default = 13'h200  default	=
// 0x200,	scale	out	fifo	size	(actually	only	bit	11:01
// is	valid,	11:1,	max	1024),	always	even	number
#define SCHN_HSC_PHASE_CTRL1 ((0x2e87 << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28           reg_hsc_double_pix_mode   // unsigned ,    RW, default = 0  default	=
// 0,horizontal	scaler	double	pixel	mode Bit 27:24        reg_prehsc_mode           //
// unsigned ,    RW, default = 0  default	=	0,prehsc_mode, bit 3:2, prehsc odd line
// interp mode, bit 1:0, prehsc even line interp mode, each 2bit, 00 pix0+pix1/2, average,
// 01:pix1,10:pix0 Bit 23:20        reg_hsc_rpt_p0_num1       // unsigned ,    RW, default = 1
// default	=	1,horizontal	scaler	initial	repeat	pixel0	number1 Bit 19:16
// reg_hsc_ini_rcv_num1      // unsigned ,    RW, default = 4  default	=	4,horizontal
// scaler	initial	receiving	number1 Bit 15: 0        reg_hsc_ini_phase1        //
// unsigned ,    RW, default = 0  default	=	0,horizontal	scaler	top	field
// initial	phase1
#define SCHN_HSC_INI_PAT_CTRL ((0x2e88 << 2) + 0xff900000)
// Bit 31:24        reg_prehsc_pattern        // unsigned ,    RW, default = 0  default	= 0,
// prehsc	pattern,	each	patten	1	bit,	from	lsb	->	msb Bit 23
// reserved Bit 22:20        reg_prehsc_pat_star       // unsigned ,    RW, default = 0  default =
// 0,	prehsc	pattern	start Bit 19            reserved Bit 18:16        reg_prehsc_pat_end //
// unsigned ,    RW, default = 0  default	=	0,	prehsc	pattern	end Bit 15: 8
// reg_hsc_pattern           // unsigned ,    RW, default = 0  default	=	0,	hsc
// pattern,	each	patten	1	bit,	from	lsb	->	msb Bit  7 reserved Bit 6:
// 4        reg_hsc_pat_start         // unsigned ,    RW, default = 0  default	=	0,
// hsc	pattern	start Bit  3            reserved Bit  2: 0        reg_hsc_pat_end           //
// unsigned ,    RW, default = 0  default	=	0,	hsc	pattern	end
#define SCHN_SC_GCLK_CTRL ((0x2e89 << 2) + 0xff900000)
// Bit 31:16        reserved
// Bit 15: 0        reg_vpp_sc_gclk_ctrl      // unsigned ,    RW, default = 0  default	= 0
// ,scale	clock	gate
#define SCHN_PREHSC_COEF ((0x2e8a << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:16        reg_prehsc_coef_1         // signed ,    RW, default = 0  default	=
// 0x00	,	coefficient0	pre horizontal	filter Bit 15:10        reserved Bit  9: 0
// reg_prehsc_coef_0         // signed ,    RW, default = 256  default	=	0x00	,
// coefficient1	pre horizontal	filter
#define SCHN_PREVSC_COEF ((0x2e8b << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:16        reg_prevsc_coef_1         // signed ,    RW, default = 0  default	=
// 0x00	,	coefficient2	pre vertical	filter Bit 15:10        reserved Bit  9: 0
// reg_prevsc_coef_0         // signed ,    RW, default = 256  default	=	0x40	,
// coefficient3	pre vertical	filter
#define SCHN_PRE_SCALE_CTRL ((0x2e8c << 2) + 0xff900000)
// Bit 31:29        reserved
// Bit 28:25        reg_preh_hb_num           // unsigned ,    RW, default = 8  defalut = 8,
// prehsc rtl h blank number Bit 24:21        reg_preh_vb_num           // unsigned ,    RW,
// default = 8  defalut = 8, prehsc rtl v blank number Bit 20           reg_sc_coef_s11_mode //
// unsigned ,    RW, default = 0  defalut = 0, sc coef bit-width 0:s9, 1:s11 Bit 19:16
// reg_vsc_nor_rs_bits       // unsigned ,    RW, default = 7  default = 7, normalize right shift
// bits of vsc Bit 15:12        reg_hsc_nor_rs_bits       // unsigned ,    RW, default = 7 default
// = 7, normalize right shift bits of hsc Bit 11: 8        reg_prehsc_flt_num        // unsigned ,
// RW, default = 2  default = 2, prehsc filter tap num Bit  7: 4        reg_prevsc_flt_num //
// unsigned ,    RW, default = 2  default = 2, prevsc filter tap num Bit  3: 2 reg_prehsc_rate //
// unsigned ,    RW, default = 1  default =   0,pre hscale down rate,
// 0:width,1:width/2,2:width/4,3:width/8 Bit  1: 0        reg_prevsc_rate           // unsigned ,
// RW, default = 1  default =   0,pre vscale down rate, 0:height,1:height/2,2:height/4,3:height/8
#define SCHN_PREHSC_COEF1 ((0x2e8d << 2) + 0xff900000)
// Bit 31:26        reserved
// Bit 25:16        reg_prehsc_coef_3         // signed ,    RW, default = 0  default	=
// 0x00	,	coefficient2	pre horizontal	filter Bit 15:10        reserved Bit  9: 0
// reg_prehsc_coef_2         // signed ,    RW, default = 0  default	=	0x40	,
// coefficient3	pre horizontal	filter
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpp_scale_schn_reg.h
//
//
// Closing file:  aisr_post_reg.h
//
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vi_hist_spl_reg.h
//
//===========================================================================
//`define MCDI_VCBUS_BASE                8'h2f
//===========================================================================
//
// Reading file:  mcdi_regs.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// CBUS_BASE:  MCDI_VCBUS_BASE = 0x2f
// -----------------------------------------------
////=================================================================////
//// memc di core 0
////=================================================================////
#define MCDI_HV_SIZEIN ((0x2f00 << 2) + 0xff900000)
// Bit 31:29, reserved
// Bit 28:16, reg_mcdi_hsize               image horizontal size (number of cols)   default=1024
// Bit 15:13, reserved
// Bit 12: 0, reg_mcdi_vsize               image vertical size   (number of rows)   default=1024
#define MCDI_HV_BLKSIZEIN ((0x2f01 << 2) + 0xff900000)
// Bit    31, reg_mcdi_vrev					 default = 0
// Bit    30, reg_mcdi_hrev					 default = 0
// Bit 29:28, reserved
// Bit 27:16, reg_mcdi_blkhsize               image horizontal blk size (number of cols)
// default=1024 Bit 15:13, reserved Bit 11: 0, reg_mcdi_blkvsize               image vertical blk
// size   (number of rows)   default=1024
#define MCDI_BLKTOTAL ((0x2f02 << 2) + 0xff900000)
// Bit 31:24, reserved
// Bit 23: 0, reg_mcdi_blktotal
#define MCDI_MOTINEN ((0x2f03 << 2) + 0xff900000)
// Bit 31: 2, reserved
// Bit     1, reg_mcdi_motionrefen.           enable motion refinement of MA, default = 1
// Bit     0, reg_mcdi_motionparadoxen.       enable motion paradox detection, default = 1
#define MCDI_CTRL_MODE ((0x2f04 << 2) + 0xff900000)
// Bit 31:28, reserved
// Bit 27:26, reg_mcdi_lmvlocken	             0:disable, 1: use max Lmv, 2: use no-zero
// Lmv, lmv lock enable mode, default = 2 Bit 25,    reg_mcdi_reldetrptchken
//                                           0: unable; 1: enable, enable repeat pattern check
//                                           (not repeat mv detection) in rel det part, default =
//                                           1
// Bit 24,    reg_mcdi_reldetgmvpd22chken
//                                           0: unable; 1: enable, enable pull-down 22 mode check
//                                           in gmv lock mode for rel det, default = 1
// Bit 23,    reg_mcdi_pd22chken
//                                           0: unable; 1: enable, enable pull-down 22 mode check
//                                           (lock) function, default = 1
// Bit 22,    reg_mcdi_reldetlpfen
//                                           0: unable; 1: enable, enable det value lpf, default =
//                                           1
// Bit 21,    reg_mcdi_reldetlmvpd22chken
//                                           0: unable; 1: enable, enable pull-down 22 mode check
//                                           in lmv lock mode for rel det, default = 1
// Bit 20,    reg_mcdi_reldetlmvdifchken
//                                           0: unable; 1: enable, enable lmv dif check in lmv
//                                           lock mode for rel det, default = 1
// Bit 19,    reg_mcdi_reldetgmvdifchken
//                                           0: unable; 1: enable, enable lmv dif check in lmv
//                                           lock mode for rel det, default = 1
// Bit 18,    reg_mcdi_reldetpd22chken
//                                           0: unable; 1: enable, enable pull-down 22 mode check
//                                           for rel det refinement, default = 1
// Bit 17,    reg_mcdi_reldetfrqchken
//                                           0: unable; 1: enable, enable mv frequency check in
//                                           rel det, default = 1
// Bit 16,    reg_mcdi_qmeen
//                                           0: unable; 1: enable, enable quarter motion
//                                           estimation, defautl = 1
// Bit 15,    reg_mcdi_refrptmven
//                                           0: unable; 1: enable, use repeat mv in refinement,
//                                           default = 1
// Bit 14,    reg_mcdi_refgmven
//                                           0: unable; 1: enable, use gmv in refinement, default
//                                           = 1
// Bit 13,    reg_mcdi_reflmven
//                                           0: unable; 1: enable, use lmvs in refinement, default
//                                           = 1
// Bit 12,    reg_mcdi_refnmven
//                                           0: unable; 1: enable, use neighoring mvs in
//                                           refinement, default = 1
// Bit 11,    reserved
// Bit 10,    reg_mcdi_referrfrqchken
//                                           0: unable; 1: enable, enable mv frquency check while
//                                           finding min err in ref, default = 1
// Bit 9,     reg_mcdi_refen
//                                           0: unable; 1: enable, enable mv refinement, default =
//                                           1
// Bit 8,     reg_mcdi_horlineen
//                                           0: unable; 1: enable,enable horizontal lines
//                                           detection by sad map, default = 1
// Bit 7,     reg_mcdi_highvertfrqdeten
//                                           0: unable; 1: enable, enable high vertical frequency
//                                           pattern detection, default = 1
// Bit 6,     reg_mcdi_gmvlocken
//                                           0: unable; 1: enable, enable gmv lock mode, default =
//                                           1
// Bit 5,     reg_mcdi_rptmven
//                                           0: unable; 1: enable, enable repeat pattern
//                                           detection, default = 1
// Bit 4,     reg_mcdi_gmven
//                                           0: unable; 1: enable, enable global motion
//                                           estimation, default = 1
// Bit 3,     reg_mcdi_lmven
//                                           0: unable; 1: enable, enable line mv estimation for
//                                           hme, default = 1
// Bit 2,     reg_mcdi_chkedgeen
//                                           0: unable; 1: enable, enable check edge function,
//                                           default = 1
// Bit 1,     reg_mcdi_txtdeten
//                                           0: unable; 1: enable, enable texture detection,
//                                           default = 1
// Bit 0,     reg_mcdi_memcen
//                                           0: unable; 1: enable, enable of memc di, default = 1
#define MCDI_UNI_MVDST ((0x2f05 << 2) + 0xff900000)
// Bit 31:20, reserved
// Bit 19:17, reg_mcdi_unimvdstabsseg0                     segment0 for uni-mv abs, default = 1
// Bit 16:12, reg_mcdi_unimvdstabsseg1                     segment1 for uni-mv abs, default = 15
// Bit 11: 8, reg_mcdi_unimvdstabsdifgain0	          2/2, gain0 of uni-mv abs dif for
// segment0, normalized 2 to '1', default = 2 Bit  7: 5, reg_mcdi_unimvdstabsdifgain1 2/2, gain1
// of uni-mv abs dif for segment1, normalized 2 to '1', default = 2 Bit  4: 2,
// reg_mcdi_unimvdstabsdifgain2                 2/2, gain2 of uni-mv abs dif beyond segment1,
// normalized 2 to '1', default = 2 Bit  1: 0, reg_mcdi_unimvdstsgnshft		          shift
// for neighboring distance of uni-mv, default = 0
#define MCDI_BI_MVDST ((0x2f06 << 2) + 0xff900000)
// Bit 31:20, reserved
// Bit 19:17, reg_mcdi_bimvdstabsseg0                      segment0 for bi-mv abs, default = 1
// Bit 16:12, reg_mcdi_bimvdstabsseg1                      segment1 for bi-mv abs, default = 9
// Bit 11: 8, reg_mcdi_bimvdstabsdifgain0	          6/2, gain0 of bi-mv abs dif for
// segment0, normalized 2 to '1', default = 6 Bit  7: 5, reg_mcdi_bimvdstabsdifgain1 3/2, gain1 of
// bi-mvabs dif for segment1, normalized 2 to '1', default = 3 Bit  4: 2,
// reg_mcdi_bimvdstabsdifgain2                  2/2, gain2 of bi-mvabs dif beyond segment1,
// normalized 2 to '1', default = 2 Bit  1: 0, reg_mcdi_bimvdstsgnshft	                  shift
// for neighboring distance of bi-mv, default = 0
#define MCDI_SAD_GAIN ((0x2f07 << 2) + 0xff900000)
// Bit 31:19, reserved
// Bit 18:17, reg_mcdi_unisadcorepxlgain                   uni-sad core pixels gain, default = 3
// Bit 16,    reg_mcdi_unisadcorepxlnormen                 enable uni-sad core pixels
// normalization, default = 0 Bit 15:11, reserved Bit 10: 9, reg_mcdi_bisadcorepxlgain bi-sad core
// pixels gain, default = 3 Bit  8,    reg_mcdi_bisadcorepxlnormen                  enable bi-sad
// core pixels normalization, default = 1 Bit  7: 3, reserved Bit  2: 1,
// reg_mcdi_biqsadcorepxlgain bi-qsad core pixels gain, default = 3 Bit  0,
// reg_mcdi_biqsadcorepxlnormen enable bi-qsad core pixels normalization, default = 1
#define MCDI_TXT_THD ((0x2f08 << 2) + 0xff900000)
// Bit 31:24, reserved
// Bit 23:16, reg_mcdi_txtminmaxdifthd,                    min max dif threshold (>=) for texture
// detection, default = 24 Bit 15: 8, reg_mcdi_txtmeandifthd,                      mean dif
// threshold (<) for texture detection, default = 9 Bit  7: 3, reserved Bit  2: 0,
// reg_mcdi_txtdetthd,                          texture detecting threshold, 0~4, default = 2
#define MCDI_FLT_MODESEL ((0x2f09 << 2) + 0xff900000)
// Bit 31	 reserved
// Bit 30:28, reg_mcdi_flthorlineselmode                   mode for horizontal line detecting flat
// calculation, default = 1, same as below Bit 27	 reserved Bit 26:24,
// reg_mcdi_fltgmvselmode                       mode for gmv flat calculation, default = 4, same
// as below Bit 23,	 reserved Bit 22:20, reg_mcdi_fltsadselmode                       mode for
// sad flat calculation, default = 2, same as below Bit 19,	 reserved Bit 18:16,
// reg_mcdi_fltbadwselmode                      mode for badw flat calculation, default = 3, same
// as below Bit 15,	 reserved Bit 14:12, reg_mcdi_fltrptmvselmode                     mode for
// repeat mv flat calculation, default = 4, same as below Bit 11,	 reserved Bit 10: 8,
// reg_mcdi_fltbadrelselmode                    mode for bad rel flat calculation, default = 4,
// same as below Bit  7,	 reserved Bit  6: 4, reg_mcdi_fltcolcfdselmode mode for col cfd
// flat calculation, default = 2, same as below Bit  3,	 reserved Bit  2: 0,
// reg_mcdi_fltpd22chkselmode                   mode for pd22 check flat calculation, default = 2,
// # 0:cur dif h, 1: cur dif v, 2: pre dif h, 3: pre dif v, 4: cur flt, 5: pre flt, 6: cur+pre, 7:
// max all(cur,pre)
#define MCDI_CHK_EDGE_THD ((0x2f0a << 2) + 0xff900000)
// Bit 23:28, reserved.
// Bit 27:24, reg_mcdi_chkedgedifsadthd.                   thd (<=) for sad dif check, 0~8,
// default = 1 Bit 23:16, reserved. Bit 15:12, reg_mcdi_chkedgemaxedgethd.                  max
// drt of edge, default = 15 Bit 11: 8, reg_mcdi_chkedgeminedgethd.                  min drt of
// edge, default = 2 Bit     7, reserved. Bit  6: 0, reg_mcdi_chkedgevdifthd. thd for vertical dif
// in check edge, default = 14
#define MCDI_CHK_EDGE_GAIN_OFFST ((0x2f0b << 2) + 0xff900000)
// Bit 31:24, reserved.
// Bit 23:20, reg_mcdi_chkedgedifthd1.                     thd1 for edge dif check (<=), default =
// 4 Bit 19:16, reg_mcdi_chkedgedifthd0.                     thd0 for edge dif check (>=), default
// = 15 Bit   :15, reserved. Bit 14:10, reg_mcdi_chkedgechklen.                      total check
// length for edge check, 1~24 (>0), default = 24 Bit  9: 8, reg_mcdi_chkedgeedgesel. final edge
// select mode, 0: original start edge, 1: lpf start edge, 2: original start+end edge, 3: lpf
// start+end edge, default = 1 Bit  7: 3, reg_mcdi_chkedgesaddstgain.                  distance
// gain for sad calc while getting edges, default = 4 Bit     2, reg_mcdi_chkedgechkmode. edge
// used in check mode, 0: original edge, 1: lpf edge, defautl = 1 Bit     1,
// reg_mcdi_chkedgestartedge. edge mode for start edge, 0: original edge, 1: lpf edge, defautl = 0
// Bit     0, reg_mcdi_chkedgeedgelpf.                     edge lpf mode, 0:[0,2,4,2,0],
// 1:[1,2,2,2,1], default = 0
#define MCDI_LMV_RT ((0x2f0c << 2) + 0xff900000)
// BIt 31:15, reserved
// Bit 14:12, reg_mcdi_lmvvalidmode                        valid mode for lmv calc., 100b: use
// char det, 010b: use flt, 001b: use hori flg Bit 11:10, reg_mcdi_lmvgainmvmode four modes of mv
// selection for lmv weight calucluation, default = 1
//                                                        0: cur(x-3), lst(x-1,x,x+1); 1:
//                                                        cur(x-4,x-3), lst(x,x+1); 2:
//                                                        cur(x-5,x-4,x-3),
//                                                        lst(x-1,x,x+1,x+2,x+3); 3:
//                                                        cur(x-6,x-5,x-4,x-3),
//                                                        lst(x-1,x,x+1,x+2);
// Bit  9,    reg_mcdi_lmvinitmode                         initial lmvs at first row of input
// field, 0: initial value = 0; 1: initial = 32 (invalid), default = 0 Bit  8,    reserved Bit  7:
// 4, reg_mcdi_lmvrt0                              ratio of max mv, default = 5 Bit  3: 0,
// reg_mcdi_lmvrt1                              ratio of second max mv, default = 5
#define MCDI_LMV_GAINTHD ((0x2f0d << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_lmvvxmaxgain                        max gain of lmv weight, default = 96
// Bit 23,    reserved
// Bit 22:20, reg_mcdi_lmvdifthd0                          dif threshold 0 (<) for small lmv,
// default = 1 Bit 19:17, reg_mcdi_lmvdifthd1                          dif threshold 1 (<) for
// median lmv, default = 2 Bit 16:14, reg_mcdi_lmvdifthd2                          dif threshold 2
// (<) for large lmv, default = 3 Bit 13: 8, reg_mcdi_lmvnumlmt least/limit number of (total
// number
// - max0), default = 20 Bit  7: 0, reg_mcdi_lmvfltthd                           flt cnt thd (<)
// for lmv, default = 9
#define MCDI_RPTMV_THD0 ((0x2f0e << 2) + 0xff900000)
// Bit 31:25, reg_mcdi_rptmvslpthd2			  slope thd (>=) between i and i+3/i-3
// (i+4/i-4), default = 64 Bit 24:20, reg_mcdi_rptmvslpthd1                        slope thd (>=)
// between i and i+2/i-2, default = 4 Bit 19:10, reg_mcdi_rptmvampthd2 amplitude thd (>=) between
// max and min, when count cycles, default = 300 Bit  9: 0, reg_mcdi_rptmvampthd1 amplitude thd
// (>=) between average of max and min, default = 400
#define MCDI_RPTMV_THD1 ((0x2f0f << 2) + 0xff900000)
// Bit 31:28, reserved
// Bit 27:25, reg_mcdi_rptmvcyccntthd                      thd (>=) of total cycles count, default
// = 2 Bit 24:21, reg_mcdi_rptmvcycdifthd                      dif thd (<) of cycles length,
// default = 3 Bit 20:18, reg_mcdi_rptmvcycvldthd                      thd (>) of valid cycles
// number, default = 1 Bit 17:15, reg_mcdi_rptmvhalfcycminthd                  min length thd (>=)
// of half cycle, default = 2 Bit 14:11, reg_mcdi_rptmvhalfcycdifthd                  neighboring
// half cycle length dif thd (<), default = 5 Bit 10: 8, reg_mcdi_rptmvminmaxcntthd least number
// of valid max and min, default = 2 Bit  7: 5, reg_mcdi_rptmvcycminthd                      min
// length thd (>=) of cycles, default = 2 Bit  4: 0, reg_mcdi_rptmvcycmaxthd max length thd (<) of
// cycles, default = 17
#define MCDI_RPTMV_THD2 ((0x2f10 << 2) + 0xff900000)
// Bit 31:24, reserved
// Bit 23:16, reg_mcdi_rptmvhdifthd0                       higher hdif thd (>=) (vertical edge)
// for rpt detection, default = 8 Bit 15: 8, reg_mcdi_rptmvhdifthd1                       hdif thd
// (>=) (slope edge) for rpt detection, default = 4 Bit  7: 0, reg_mcdi_rptmvvdifthd vdif thd (>=)
// (slope edge) for rpt detection, default = 1
#define MCDI_RPTMV_SAD ((0x2f11 << 2) + 0xff900000)
// Bit 31:26, reserved
// Bit 25:16, reg_mcdi_rptmvsaddifthdgain                  7x3x(16/16), gain for sad dif thd in
// rpt mv detection, 0~672, normalized 16 as '1', default = 336 Bit 15:10, reserved Bit  9: 0,
// reg_mcdi_rptmvsaddifthdoffst                 offset for sad dif thd in rpt mv detection,
// -512~511, default = 16
#define MCDI_RPTMV_FLG ((0x2f12 << 2) + 0xff900000)
// Bit 31:18,  reserved
// Bit 17:16,  reg_mcdi_rptmvmode                          select mode of mvs for repeat motion
// estimation, 0: hmv, 1: qmv/2, 2 or 3: qmv/4, default = 2 Bit 15: 8,  reg_mcdi_rptmvflgcntthd
// thd
// (>=) of min count number for rptmv of whole field, for rptmv estimation, default = 64 Bit  7:
// 5, reserved Bit  4: 0,  reg_mcdi_rptmvflgcntrt                      4/32, ratio for repeat mv
// flag count, normalized 32 as '1', set 31 to 32,
#define MCDI_RPTMV_GAIN ((0x2f13 << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_rptmvlftgain                        up repeat mv gain for hme, default = 96
// Bit 23:16, reg_mcdi_rptmvuplftgain                      up left repeat mv gain for hme, default
// = 32 Bit 15: 8, reg_mcdi_rptmvupgain                         up repeat mv gain for hme, default
// = 64 Bit  7: 0, reg_mcdi_rptmvuprightgain                    up right repeat mv gain for hme,
// default = 32
#define MCDI_GMV_RT ((0x2f14 << 2) + 0xff900000)
// Bit 31,    reserved
// Bit 30:24, reg_mcdi_gmvmtnrt0                           ratio 0 for motion scenario, set 127 to
// 128, normalized 128 as '1', default =32 Bit 23,    reserved Bit 22:16, reg_mcdi_gmvmtnrt1 ratio
// 1 for motion scenario, set 127 to 128, normalized 128 as '1', default = 56 Bit 15,    reserved
// Bit 14: 8, reg_mcdi_gmvstlrt0                           ratio 0 for still scenario, set 127 to
// 128, normalized 128 as '1', default = 56 Bit  7,    reserved Bit  6: 0, reg_mcdi_gmvstlrt1
// ratio 1 for still scenario, set 127 to 128, normalized 128 as '1', default = 80
#define MCDI_GMV_GAIN ((0x2f15 << 2) + 0xff900000)
// Bit 31:25, reg_mcdi_gmvzeromvlockrt0                    ratio 0 for locking zero mv, set 127 to
// 128, normalized 128 as '1', default = 100 Bit 24:18, reg_mcdi_gmvzeromvlockrt1 ratio 1 for
// locking zero mv, set 127 to 128, normalized 128 as '1', default = 112 Bit 17:16,
// reg_mcdi_gmvvalidmode                        valid mode for gmv calc., 10b: use flt, 01b: use
// hori flg, default = 3 Bit 15: 8, reg_mcdi_gmvvxgain                           gmv's vx gain
// when gmv locked for hme, default = 0 Bit  7: 0, reg_mcdi_gmvfltthd flat thd
// (<) for gmv calc. default = 3
#define MCDI_HOR_SADOFST ((0x2f16 << 2) + 0xff900000)
// Bit 31:25, reserved
// Bit 24:16, reg_mcdi_horsaddifthdgain                    21*1/8, gain/divisor for sad dif
// threshold in hor line detection, normalized 8 as '1', default = 21 Bit 15: 8,
// reg_mcdi_horsaddifthdoffst                   offset for sad dif threshold in hor line
// detection, -128~127, default = 0 Bit  7: 0, reg_mcdi_horvdifthd threshold (>=) of vertical dif
// of next block for horizontal line detection, default = 24
#define MCDI_REF_MV_NUM ((0x2f17 << 2) + 0xff900000)
// Bit 31: 2, reserved
// Bit  1: 0, reg_mcdi_refmcmode.         motion compensated mode used in refinement, 0: pre, 1:
// next, 2: (pre+next)/2, default = 0
#define MCDI_REF_BADW_THD_GAIN ((0x2f18 << 2) + 0xff900000)
// Bit 31:28, reserved
// Bit 27:24, reg_mcdi_refbadwcnt2gain.   gain for badwv count num==3, default = 6
// Bit 23:20, reg_mcdi_refbadwcnt1gain.   gain for badwv count num==2, default = 3
// Bit 19:16, reg_mcdi_refbadwcnt0gain.   gain for badwv count num==1, default = 1
// Bit 15:12, reg_mcdi_refbadwthd3.       threshold 3 for detect badweave with largest average
// luma, default = 4 Bit 11: 8, reg_mcdi_refbadwthd2.       threshold 2 for detect badweave with
// third smallest average luma, default = 3 Bit  7: 4, reg_mcdi_refbadwthd1.       threshold 1 for
// detect badweave with second smallest average luma, default = 2 Bit  3: 0, reg_mcdi_refbadwthd0.
// threshold 0 for detect badweave with smallest average luma, default = 1
#define MCDI_REF_BADW_SUM_GAIN ((0x2f19 << 2) + 0xff900000)
// Bit 31:13, reserved
// Bit 12: 8, reg_mcdi_refbadwsumgain0.   sum gain for r channel, 0~16, default = 8
// Bit  7: 5, reserved
// Bit     4, reg_mcdi_refbadwcalcmode.   mode for badw calculation, 0:sum, 1:max, default = 0
// Bit  3: 0, reserved
#define MCDI_REF_BS_THD_GAIN ((0x2f1a << 2) + 0xff900000)
// Bit 31:28, reg_mcdi_refbsudgain1.      up & down block stregth gain1, normalized to 8 as '1',
// default = 2 Bit 27:24, reg_mcdi_refbsudgain0.      up & down block stregth gain0, normalized to
// 8 as '1', default = 4 Bit 23:19, reserved Bit 18:16, reg_mcdi_refbslftgain.      left block
// strength gain, default = 0 Bit 15:13, reserved Bit 12: 8, reg_mcdi_refbsthd1.         threshold
// 1 for detect block stregth in refinment, default = 16 Bit  7: 5, reserved Bit  4: 0,
// reg_mcdi_refbsthd0.         threshold 0 for detect block stregth in refinment, default = 8
#define MCDI_REF_ERR_GAIN0 ((0x2f1b << 2) + 0xff900000)
// Bit    31, reserved
// Bit 30:24, reg_mcdi_referrnbrdstgain.            neighoring mv distances gain for err calc. in
// ref, normalized to 8 as '1', default = 48 Bit 23:20, reserved Bit 19:16, reg_mcdi_referrbsgain.
// bs gain for err calc. in ref, normalized to 8 as '1', default = 4 Bit    15, reserved Bit 14:
// 8, reg_mcdi_referrbadwgain.              badw gain for err calc. in ref, normalized to 8 as
// '1', default = 64 Bit  7: 4, reserved Bit  3: 0, reg_mcdi_referrsadgain.               sad gain
// for err calc. in ref, normalized to 8 as '1', default = 4
#define MCDI_REF_ERR_GAIN1 ((0x2f1c << 2) + 0xff900000)
// Bit 31:20, reserved
// Bit 19:16, reg_mcdi_referrchkedgegain.           check edge gain for err calc. in ref,
// normalized to 8 as '1', default = 4 Bit 15:12, reserved Bit 11: 8, reg_mcdi_referrlmvgain.
// (locked) lmv gain for err calc. in ref, normalized to 8 as '1', default = 0 Bit  7: 4, reserved
// Bit  3: 0, reg_mcdi_referrgmvgain.               (locked) gmv gain for err calc. in ref,
// normalized to 8 as '1', default = 0
#define MCDI_REF_ERR_FRQ_CHK ((0x2f1d << 2) + 0xff900000)
// Bit 31:28, reserved
// Bit 27:24, reg_mcdi_referrfrqgain.               gain for mv frquency, normalized to 4 as '1',
// default = 10 Bit 23:21, reserved Bit 20:16, reg_mcdi_referrfrqmax.                max gain for
// mv frquency check, default = 31 Bit    15, reserved Bit 14:12, reg_mcdi_ref_errfrqmvdifthd2. mv
// dif threshold 2 (<) for mv frquency check, default = 3 Bit    11, reserved Bit 10: 8,
// reg_mcdi_ref_errfrqmvdifthd1.         mv dif threshold 1 (<) for mv frquency check, default = 2
// Bit     7, reserved
// Bit  6: 4, reg_mcdi_ref_errfrqmvdifthd0.         mv dif threshold 0 (<) for mv frquency check,
// default = 1 Bit  3: 0, reserved
#define MCDI_QME_LPF_MSK ((0x2f1e << 2) + 0xff900000)
// Bit 31:28, reserved
// Bit 27:24, reg_mcdi_qmechkedgelpfmsk0.           lpf mask0 for chk edge in qme, 0~8, msk1 =
// (8-msk0), normalized to 8 as '1', default = 7 Bit 23:20, reserved Bit 19:16,
// reg_mcdi_qmebslpfmsk0.                lpf mask0 for bs in qme, 0~8, msk1 = (8-msk0), normalized
// to 8 as '1', default = 7 Bit 15:12, reserved Bit 11: 8, reg_mcdi_qmebadwlpfmsk0. lpf mask0 for
// badw in qme, 0~8, msk1 = (8-msk0), normalized to 8 as '1', default = 7 Bit  7: 4, reserved Bit
// 3: 0, reg_mcdi_qmesadlpfmsk0.               lpf mask0 for sad in qme, 0~8, msk1 = (8-msk0),
// normalized to 8 as '1', default = 7
#define MCDI_REL_DIF_THD_02 ((0x2f1f << 2) + 0xff900000)
// Bit 31:24, reserved.
// Bit 23:16, reg_mcdi_reldifthd2.                  thd (<) for (hdif+vdif), default = 9
// Bit 15: 8, reg_mcdi_reldifthd1.                  thd (<) for (vdif), default = 5
// Bit  7: 0, reg_mcdi_reldifthd0.                  thd (>=) for (hdif-vdif), default = 48
#define MCDI_REL_DIF_THD_34 ((0x2f20 << 2) + 0xff900000)
// Bit 31:16, reserved.
// Bit 15: 8, reg_mcdi_reldifthd4.                  thd (<) for (hdif), default = 255
// Bit  7: 0, reg_mcdi_reldifthd3.                  thd (>=) for (vdif-hdif), default = 48
#define MCDI_REL_BADW_GAIN_OFFST_01 ((0x2f21 << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_relbadwoffst1.               offset for badw adj, for flat block, -128~127,
// default = 0 Bit 23:16, reg_mcdi_relbadwgain1.                gain for badw adj, for flat block,
// default = 128 Bit 15: 8, reg_mcdi_relbadwoffst0.               offset for badw adj, for
// vertical block, -128~127, default = 0 Bit  7: 0, reg_mcdi_relbadwgain0.                gain for
// badw adj, for vertical block, default = 160
#define MCDI_REL_BADW_GAIN_OFFST_23 ((0x2f22 << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_relbadwoffst3.               offset for badw adj, for other block,
// -128~127, default = 0 Bit 23:16, reg_mcdi_relbadwgain3.                gain for badw adj, for
// other block, default = 48 Bit 15: 8, reg_mcdi_relbadwoffst2.               offset for badw adj,
// for horizontal block, -128~127, default = 0 Bit  7: 0, reg_mcdi_relbadwgain2. gain for badw
// adj, for horizontal block, default = 48
#define MCDI_REL_BADW_THD_GAIN_OFFST ((0x2f23 << 2) + 0xff900000)
// Bit 31:23, reserved.
// Bit 22:16, reg_mcdi_relbadwoffst.                offset for badw thd adj, -64~63, default = 0
// Bit 15: 8, reserved.
// Bit  7: 0, reg_mcdi_relbadwthdgain.              gain0 for badw thd adj, normalized to 16 as
// '1', default = 16
#define MCDI_REL_BADW_THD_MIN_MAX ((0x2f24 << 2) + 0xff900000)
// Bit 31:18, reserved.
// Bit 17: 8, reg_mcdi_relbadwthdmax.               max for badw thd adj, default = 256
// Bit  7: 0, reg_mcdi_relbadwthdmin.               min for badw thd adj, default = 16
#define MCDI_REL_SAD_GAIN_OFFST_01 ((0x2f25 << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_relsadoffst1.                offset for sad adj, for flat block, -128~127,
// default = 0 Bit 23:20, reserved. Bit 19:16, reg_mcdi_relsadgain1.                 gain for sad
// adj, for flat block, normalized to 8 as '1', default = 8 Bit 15: 8, reg_mcdi_relsadoffst0.
// offset for sad adj, for vertical block, -128~127, default = 0 Bit  7: 4, reserved. Bit  3: 0,
// reg_mcdi_relsadgain0.                 gain for sad adj, for vertical block, normalized to 8 as
// '1', default = 6
#define MCDI_REL_SAD_GAIN_OFFST_23 ((0x2f26 << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_relsadoffst3.                offset for sad adj, for other block, -128~127,
// default = 0 Bit 23:20, reserved. Bit 19:16, reg_mcdi_relsadgain3.                 gain for sad
// adj, for other block, normalized to 8 as '1', default = 8 Bit 15: 8, reg_mcdi_relsadoffst2.
// offset for sad adj, for horizontal block, -128~127, default = 0 Bit  7: 4, reserved. Bit  3: 0,
// reg_mcdi_relsadgain2.                 gain for sad adj, for horizontal block, normalized to 8
// as '1', default = 12
#define MCDI_REL_SAD_THD_GAIN_OFFST ((0x2f27 << 2) + 0xff900000)
// Bit 31:24, reserved.
// Bit 23:16, reg_mcdi_relsadoffst.                 offset for sad thd adj, -128~127, default = 0
// Bit 15:10, reserved.
// Bit  9: 0, reg_mcdi_relsadthdgain.               gain for sad thd adj, 21*2/16, normalized to
// 16 as '1', default = 42
#define MCDI_REL_SAD_THD_MIN_MAX ((0x2f28 << 2) + 0xff900000)
// Bit 31:27, reserved.
// Bit 26:16, reg_mcdi_relsadthdmax.                max for sad thd adj, 21*32, default = 672
// Bit 15: 9, reserved.
// Bit  8: 0, reg_mcdi_relsadthdmin.                min for sad thd adj, 21*2, default = 42
#define MCDI_REL_DET_GAIN_00 ((0x2f29 << 2) + 0xff900000)
// Bit 31:21, reserved.
// Bit 20:16, reg_mcdi_reldetbsgain0.               gain0 (gmv locked) for bs, for det. calc.
// normalized to 16 as '1', default = 8 Bit 15:14, reserved. Bit 13: 8, reg_mcdi_reldetbadwgain0.
// gain0 (gmv locked) for badw, for det. calc. normalized to 16 as '1', default = 12 Bit  7: 5,
// reserved. Bit  4: 0, reg_mcdi_reldetsadgain0.              gain0 (gmv locked) for qsad, for
// det. calc. normalized to 16 as '1', default = 8
#define MCDI_REL_DET_GAIN_01 ((0x2f2a << 2) + 0xff900000)
// Bit 31:14, reserved.
// Bit 12: 8, reg_mcdi_reldetchkedgegain0.          gain0 (gmv locked) for chk_edge, for det.
// calc. normalized to 16 as '1', default = 2 Bit     7, reserved. Bit  6: 0,
// reg_mcdi_reldetnbrdstgain0.           gain0 (gmv locked) for neighoring dist, for det. calc.
// normalized to 16 as '1', default = 24
#define MCDI_REL_DET_GAIN_10 ((0x2f2b << 2) + 0xff900000)
// Bit 31:21, reserved.
// Bit 20:16, reg_mcdi_reldetbsgain1.               gain1 (lmv locked) for bs, for det. calc.
// normalized to 16 as '1', default = 0 Bit 15:14, reserved. Bit 13: 8, reg_mcdi_reldetbadwgain1.
// gain1 (lmv locked) for badw, for det. calc. normalized to 16 as '1', default = 8 Bit  7: 5,
// reserved. Bit  4: 0, reg_mcdi_reldetsadgain1.              gain1 (lmv locked) for qsad, for
// det. calc. normalized to 16 as '1', default = 8
#define MCDI_REL_DET_GAIN_11 ((0x2f2c << 2) + 0xff900000)
// Bit 31:14, reserved.
// Bit 12: 8, reg_mcdi_reldetchkedgegain1.          gain1 (lmv locked) for chk_edge, for det.
// calc. normalized to 16 as '1', default = 0 Bit     7, reserved. Bit  6: 0,
// reg_mcdi_reldetnbrdstgain1.           gain1 (lmv locked) for neighoring dist, for det. calc.
// normalized to 16 as '1', default = 24
#define MCDI_REL_DET_GAIN_20 ((0x2f2d << 2) + 0xff900000)
// Bit 31:21, reserved.
// Bit 20:16, reg_mcdi_reldetbsgain2.               gain2 (no locked) for bs, for det. calc.
// normalized to 16 as '1', default = 12 Bit 15:14, reserved. Bit 13: 8, reg_mcdi_reldetbadwgain2.
// gain2 (no locked) for badw, for det. calc. normalized to 16 as '1', default = 32 Bit  7: 5,
// reserved. Bit  4: 0, reg_mcdi_reldetsadgain2.              gain2 (no locked) for qsad, for det.
// calc. normalized to 16 as '1', default = 16
#define MCDI_REL_DET_GAIN_21 ((0x2f2e << 2) + 0xff900000)
// Bit 31:26, reserved
// Bit 25:16, reg_mcdi_reldetoffst.                 offset for rel calculation, for det. calc.
// -512~511,  default = 0 Bit 15:14, reserved. Bit 12: 8, reg_mcdi_reldetchkedgegain2. gain2 (no
// locked) for chk_edge, for det. calc. normalized to 16 as '1', default = 10 Bit     7, reserved.
// Bit  6: 0, reg_mcdi_reldetnbrdstgain2.           gain2 (no locked) for neighoring dist, for
// det. calc. normalized to 16 as '1', default = 32
#define MCDI_REL_DET_GMV_DIF_CHK ((0x2f2f << 2) + 0xff900000)
// Bit 31:24, reserved.
// Bit 23:16, reg_mcdi_reldetgmvfltthd.             flat thd (>=) for gmv lock decision, default =
// 0 Bit    15, reserved. Bit 14:12, reg_mcdi_reldetgmvdifthd.             dif thd (>=) for
// current mv different from gmv for gmv dif check, actually used in Lmv lock check, default = 3
// Bit    11, reserved. Bit 10: 8, reg_mcdi_reldetgmvdifmin.             min mv dif for gmv dif
// check, default = 1, note: dif between reg_mcdi_rel_det_gmv_dif_max and
// reg_mcdi_rel_det_gmv_dif_min should be; 0,1,3,7, not work for others Bit  7: 4,
// reg_mcdi_reldetgmvdifmax.             max mv dif for gmv dif check, default = 4 Bit  3: 1,
// reserved Bit     0, reg_mcdi_reldetgmvdifmvmode.          mv mode used for gmv dif check, 0:
// use refmv, 1: use qmv, default = 0
#define MCDI_REL_DET_LMV_DIF_CHK ((0x2f30 << 2) + 0xff900000)
// Bit 31:24, reserved.
// Bit 23:16, reg_mcdi_reldetlmvfltthd.             flat thd (>=) for lmv lock decision, default =
// 12 Bit 15:14, reserved. Bit 13:12, reg_mcdi_reldetlmvlockchkmode.        lmv lock check mode,
// 0:cur Lmv, 1: cur & (last | next), 2: last & cur & next Lmv, default = 1 Bit    11, reserved.
// Bit 10: 8, reg_mcdi_reldetlmvdifmin.             min mv dif for lmv dif check, default = 1,
// note: dif between reg_mcdi_rel_det_lmv_dif_max and reg_mcdi_rel_det_lmv_dif_min should be;
// 0,1,3,7, not work for others Bit  7: 4, reg_mcdi_reldetlmvdifmax.             max mv dif for
// lmv dif check, default = 4 Bit  3: 1, reserved Bit     0, reg_mcdi_reldetlmvdifmvmode. mv mode
// used for lmv dif check, 0: use refmv, 1: use qmv, default = 0
#define MCDI_REL_DET_FRQ_CHK ((0x2f31 << 2) + 0xff900000)
// Bit 31:12, reserved.
// Bit 11: 8, reg_mcdi_reldetfrqgain.               gain for frequency check, normalized to 4 as
// '1', default = 10 Bit  7: 5, reserved Bit  4: 0, reg_mcdi_reldetfrqmax.                max
// value for frequency check, default = 31
#define MCDI_REL_DET_PD22_CHK ((0x2f32 << 2) + 0xff900000)
// Bit 31:18, reserved.
// Bit 17: 8, reg_mcdi_reldetpd22chkoffst.          offset for pd22 check happened, default = 512
// Bit  7: 5, reserved
// Bit  4: 0, reg_mcdi_reldetpd22chkgain.           gain for pd22 check happened, normalized to 8
// as '1', default = 12
#define MCDI_REL_DET_RPT_CHK_ROW ((0x2f33 << 2) + 0xff900000)
// Bit 31:27, reserved
// Bit 26:16, reg_mcdi_reldetrptchkendrow.          end row (<) number for repeat check, default =
// 2047 Bit 15:11, reserved Bit 10: 0, reg_mcdi_reldetrptchkstartrow.        start row (>=) number
// for repeat check, default = 0
#define MCDI_REL_DET_RPT_CHK_GAIN_QMV ((0x2f34 << 2) + 0xff900000)
// Bit 31:30, reserved
// Bit 29:24, reg_mcdi_reldetrptchkqmvmax.          max thd (<) of abs qmv for repeat check,
// default = 15, note that quarter mv's range is -63~63 Bit 23:22, reserved Bit 21:16,
// reg_mcdi_reldetrptchkqmvmin.          min thd (>=) of abs qmv for repeat check, default = 10,
// note that quarter mv's range is -63~63 Bit    15, reserved/ Bit 14: 4,
// reg_mcdi_reldetrptchkoffst.           offset for repeat check, default = 512 Bit  3: 0,
// reg_mcdi_reldetrptchkgain.            gain for repeat check, normalized to 8 as '1', default =
// 4
#define MCDI_REL_DET_RPT_CHK_THD_0 ((0x2f35 << 2) + 0xff900000)
// Bit 31:24, reserved
// Bit 23:16, reg_mcdi_reldetrptchkzerosadthd.      zero sad thd (<) for repeat check, default =
// 255 Bit 15:14, reserved. Bit 13: 8, reg_mcdi_reldetrptchkzerobadwthd.     zero badw thd (>=)
// for repeat check, default = 16 Bit  7: 4, reserved Bit  3: 0, reg_mcdi_reldetrptchkfrqdifthd.
// frequency dif thd (<) for repeat check, 0~10, default = 5
#define MCDI_REL_DET_RPT_CHK_THD_1 ((0x2f36 << 2) + 0xff900000)
// Bit 31:16, reserved
// Bit 15: 8, reg_mcdi_reldetrptchkvdifthd.         vertical dif thd (<) for repeat check, default
// = 16 Bit  7: 0, reg_mcdi_reldetrptchkhdifthd.         horizontal dif thd (>=) for repeat check,
// default = 16
#define MCDI_REL_DET_LPF_DIF_THD ((0x2f37 << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_reldetlpfdifthd3.            hdif thd (<) for lpf selection of horizontal
// block, default = 9 Bit 23:16, reg_mcdi_reldetlpfdifthd2.            vdif-hdif thd (>=) for lpf
// selection of horizontal block, default = 48 Bit 15: 8, reg_mcdi_reldetlpfdifthd1. vdif thd (<)
// for lpf selection of vertical block, default = 9 Bit  7: 0, reg_mcdi_reldetlpfdifthd0.
// hdif-vdif thd (>=) for lpf selection of vertical block, default = 48
#define MCDI_REL_DET_LPF_MSK_00_03 ((0x2f38 << 2) + 0xff900000)
// Bit 31:29, reserved
// Bit 28:24, reg_mcdi_reldetlpfmsk03.              det lpf mask03 for gmv/lmv locked mode, 0~16,
// default = 1 Bit 23:21, reserved Bit 20:16, reg_mcdi_reldetlpfmsk02.              det lpf mask02
// for gmv/lmv locked mode, 0~16, default = 1 Bit 15:13, reserved Bit 12: 8,
// reg_mcdi_reldetlpfmsk01.              det lpf mask01 for gmv/lmv locked mode, 0~16, default = 5
// Bit  7: 5, reserved
// Bit  4: 0, reg_mcdi_reldetlpfmsk00.              det lpf mask00 for gmv/lmv locked mode, 0~16,
// default = 8
#define MCDI_REL_DET_LPF_MSK_04_12 ((0x2f39 << 2) + 0xff900000)
// Bit 31:29, reserved
// Bit 28:24, reg_mcdi_reldetlpfmsk12.              det lpf mask12 for vertical blocks, 0~16,
// default = 0 Bit 23:21, reserved Bit 20:16, reg_mcdi_reldetlpfmsk11.              det lpf mask11
// for vertical blocks, 0~16, default = 0 Bit 15:13, reserved Bit 12: 8, reg_mcdi_reldetlpfmsk10.
// det lpf mask10 for vertical blocks, 0~16, default = 16 Bit  7: 5, reserved Bit  4: 0,
// reg_mcdi_reldetlpfmsk04.              det lpf mask04 for gmv/lmv locked mode, 0~16, default = 1
#define MCDI_REL_DET_LPF_MSK_13_21 ((0x2f3a << 2) + 0xff900000)
// Bit 31:29, reserved
// Bit 28:24, reg_mcdi_reldetlpfmsk21.              det lpf mask21 for horizontal blocks, 0~16,
// default = 6 Bit 23:21, reserved Bit 20:16, reg_mcdi_reldetlpfmsk20.              det lpf mask20
// for horizontal blocks, 0~16, default = 8 Bit 15:13, reserved Bit 12: 8,
// reg_mcdi_reldetlpfmsk14. det lpf mask14 for vertical blocks, 0~16, default = 0 Bit  7: 5,
// reserved Bit  4: 0, reg_mcdi_reldetlpfmsk13.              det lpf mask13 for vertical blocks,
// 0~16, default = 0
#define MCDI_REL_DET_LPF_MSK_22_30 ((0x2f3b << 2) + 0xff900000)
// Bit 31:29, reserved
// Bit 28:24, reg_mcdi_reldetlpfmsk30.              det lpf mask30 for other blocks, 0~16, default
// = 16 Bit 23:21, reserved Bit 20:16, reg_mcdi_reldetlpfmsk24.              det lpf mask24 for
// horizontal blocks, 0~16, default = 1 Bit 15:13, reserved Bit 12: 8, reg_mcdi_reldetlpfmsk23.
// det lpf mask23 for horizontal blocks, 0~16, default = 0 Bit  7: 5, reserved Bit  4: 0,
// reg_mcdi_reldetlpfmsk22.              det lpf mask22 for horizontal blocks, 0~16, default = 1
#define MCDI_REL_DET_LPF_MSK_31_34 ((0x2f3c << 2) + 0xff900000)
// Bit 31:29, reserved
// Bit 28:24, reg_mcdi_reldetlpfmsk34.              det lpf mask34 for other blocks, 0~16, default
// = 0 Bit 23:21, reserved Bit 20:16, reg_mcdi_reldetlpfmsk33.              det lpf mask33 for
// other blocks, 0~16, default = 0 Bit 15:13, reserved Bit 12: 8, reg_mcdi_reldetlpfmsk32. det lpf
// mask32 for other blocks, 0~16, default = 0 Bit  7: 5, reserved Bit  4: 0,
// reg_mcdi_reldetlpfmsk31.              det lpf mask31 for other blocks, 0~16, default = 0 Note:
// there are four group lpf masks from addr 37~3b, each group sum equal to 16.
#define MCDI_REL_DET_MIN ((0x2f3d << 2) + 0xff900000)
// Bit 31: 7, reserved
// Bit  6: 0, reg_mcdi_reldetmin.                   min of detected value, default = 16
#define MCDI_REL_DET_LUT_0_3 ((0x2f3e << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_reldetmaplut3.               default = 8
// Bit 23:16, reg_mcdi_reldetmaplut2.               default = 4
// Bit 15: 8, reg_mcdi_reldetmaplut1.               default = 2
// Bit  7: 0, reg_mcdi_reldetmaplut0.               default = 0
#define MCDI_REL_DET_LUT_4_7 ((0x2f3f << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_reldetmaplut7.               default = 64
// Bit 23:16, reg_mcdi_reldetmaplut6.               default = 48
// Bit 15: 8, reg_mcdi_reldetmaplut5.               default = 32
// Bit  7: 0, reg_mcdi_reldetmaplut4.               default = 16
#define MCDI_REL_DET_LUT_8_11 ((0x2f40 << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_reldetmaplut11.              default = 160
// Bit 23:16, reg_mcdi_reldetmaplut10.              default = 128
// Bit 15: 8, reg_mcdi_reldetmaplut9.               default = 96
// Bit  7: 0, reg_mcdi_reldetmaplut8.               default = 80
#define MCDI_REL_DET_LUT_12_15 ((0x2f41 << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_reldetmaplut15.              default = 255
// Bit 23:16, reg_mcdi_reldetmaplut14.              default = 240
// Bit 15: 8, reg_mcdi_reldetmaplut13.              default = 224
// Bit  7: 0, reg_mcdi_reldetmaplut12.              default = 192
#define MCDI_REL_DET_COL_CFD_THD ((0x2f42 << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_reldetcolcfdfltthd.          thd for flat smaller than (<) of column
// cofidence, default = 5 Bit 23:16, reg_mcdi_reldetcolcfdthd1.            thd for rel larger than
// (>=) in rel calc. mode col confidence without gmv locking, default = 160 Bit 15: 8,
// reg_mcdi_reldetcolcfdthd0.            thd for rel larger than (>=) in rel calc. mode col
// confidence when gmv locked, default = 100 Bit  7: 2, reg_mcdi_reldetcolcfdbadwthd.         thd
// for badw larger than (>=) in qbadw calc. mode of column cofidence, default = 16 Bit     1,
// reserved Bit     0, reg_mcdi_reldetcolcfdcalcmode.        calc. mode for column cofidence, 0:
// use rel, 1: use qbadw, default = 0
#define MCDI_REL_DET_COL_CFD_AVG_LUMA ((0x2f43 << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_reldetcolcfdavgmin1.         avg luma min1 (>=) for column cofidence, valid
// between 16~235, default = 235 Bit 23:16, reg_mcdi_reldetcolcfdavgmax1.         avg luma max1
// (<) for column cofidence, valid between 16~235, default = 235 Bit 15: 8,
// reg_mcdi_reldetcolcfdavgmin0.         avg luma min0 (>=) for column cofidence, valid between
// 16~235, default = 16 Bit  7: 0, reg_mcdi_reldetcolcfdavgmax0.         avg luma max0 (<)  for
// column cofidence, valid between 16~235, default = 21
#define MCDI_REL_DET_BAD_THD_0 ((0x2f44 << 2) + 0xff900000)
// Bit 31:16, reserved
// Bit 15: 8, reg_mcdi_reldetbadsadthd.             thd (>=) for bad sad, default = 120 (480/4)
// Bit  7: 6, reserved
// Bit  5: 0, reg_mcdi_reldetbadbadwthd.            thd (>=) for bad badw, 0~42, default = 12
#define MCDI_REL_DET_BAD_THD_1 ((0x2f45 << 2) + 0xff900000)
// Bit 31:24, reserved
// Bit 23:16, reg_mcdi_reldetbadrelfltthd.          thd (>=) of flat for bad rel detection,
// default = 4 Bit 15: 8, reg_mcdi_reldetbadrelthd1.            thd (>=) for bad rel without
// gmv/lmv locked, default = 160 Bit  7: 0, reg_mcdi_reldetbadrelthd0.            thd (>=) for bad
// rel with gmv/lmv locked, default = 120
#define MCDI_PD22_CHK_THD ((0x2f46 << 2) + 0xff900000)
// Bit 31:25, reserved
// Bit 24:16, reg_mcdi_pd22chksaddifthd.            sad dif thd (>=) for (pd22chksad - qsad) for
// pd22 check, default = 64 Bit 15:14, reserved Bit 13: 8, reg_mcdi_pd22chkqmvthd. thd (>=) of abs
// qmv for pd22 check, default = 2 Bit  7: 0, reg_mcdi_pd22chkfltthd.               thd (>=) of
// flat for pd22 check, default = 4
#define MCDI_PD22_CHK_GAIN_OFFST_0 ((0x2f47 << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_pd22chkedgeoffst0.           offset0 of pd22chkedge from right film22
// phase, -128~127, default = 0 Bit 23:21, reserved Bit 20:16, reg_mcdi_pd22chkedgegain0. gain0 of
// pd22chkedge from right film22 phase, normalized to 16 as '1', default = 16 Bit 15:12, reserved
// Bit 11: 8, reg_mcdi_pd22chkbadwoffst0.           offset0 of pd22chkbadw from right film22
// phase, -8~7, default = 0 Bit  7: 5, reserved Bit  4: 0, reg_mcdi_pd22chkbadwgain0. gain0 of
// pd22chkbadw from right film22 phase, normalized to 16 as '1', default = 8
#define MCDI_PD22_CHK_GAIN_OFFST_1 ((0x2f48 << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_pd22chkedgeoffst1.           offset1 of pd22chkedge from right film22
// phase, -128~127, default = 0 Bit 23:21, reserved Bit 20:16, reg_mcdi_pd22chkedgegain1. gain1 of
// pd22chkedge from right film22 phase, normalized to 16 as '1', default = 16 Bit 15:12, reserved
// Bit 11: 8, reg_mcdi_pd22chkbadwoffst1.           offset1 of pd22chkbadw from right film22
// phase, -8~7, default = 0 Bit  7: 5, reserved Bit  4: 0, reg_mcdi_pd22chkbadwgain1. gain1 of
// pd22chkbadw from right film22 phase, normalized to 16 as '1', default = 12
#define MCDI_LMV_LOCK_CNT_THD_GAIN ((0x2f49 << 2) + 0xff900000)
// Bit 31:20, reserved
// Bit 19:16, reg_mcdi_lmvlockcntmax.               max lmv lock count number, default = 6
// Bit 15:12, reg_mcdi_lmvlockcntoffst.             offset for lmv lock count, -8~7, default =  0
// Bit 11: 8, reg_mcdi_lmvlockcntgain.              gain for lmv lock count, normalized 8 as '1',
// 15 is set to 16, default = 8 Bit  7: 5, reserved Bit  4: 0, reg_mcdi_lmvlockcntthd. lmv count
// thd (>=) before be locked, 1~31, default = 4
#define MCDI_LMV_LOCK_ABS_DIF_THD ((0x2f4a << 2) + 0xff900000)
// Bit 31:27, reserved
// Bit 26:24, reg_mcdi_lmvlockdifthd2.              lmv dif thd for third part, before locked,
// default = 1 Bit    23, reserved Bit 22:20, reg_mcdi_lmvlockdifthd1.              lmv dif thd
// for second part, before locked, default = 1 Bit    19, reserved Bit 18:16,
// reg_mcdi_lmvlockdifthd0. lmv dif thd for first part, before locked, default = 1 Bit 15:13,
// reserved Bit 12: 8, reg_mcdi_lmvlockabsmax.               max abs (<) of lmv to be locked,
// default = 24 Bit  7: 5, reserved Bit  4: 0, reg_mcdi_lmvlockabsmin.               min abs (>=)
// of lmv to be locked, default = 1
#define MCDI_LMV_LOCK_ROW ((0x2f4b << 2) + 0xff900000)
// Bit 31:27, reserved
// Bit 26:16, reg_mcdi_lmvlockendrow.               end row (<) for lmv lock, default = 2047
// Bit 15:11, reserved
// Bit 10: 0, reg_mcdi_lmvlockstartrow.             start row (>=) for lmv lock, default = 0
#define MCDI_LMV_LOCK_RT_MODE ((0x2f4c << 2) + 0xff900000)
// Bit 31:27, reserved
// Bit 26:24, reg_mcdi_lmvlockextmode.              extend lines for lmv lock check, check how
// many lines for lmv locking, default = 2 Bit 23:16, reg_mcdi_lmvlockfltcntrt.             ratio
// of flt cnt for lock check, normalized 256 as '1', 255 is set to 256, default = 32 Bit 15: 8,
// reg_mcdi_lmvlocklmvcntrt1.            ratio when use non-zero lmv for lock check, normalized
// 256 as '1', 255 is set to 256, default = 48 Bit  7: 0, reg_mcdi_lmvlocklmvcntrt0. ratio when
// use max lmv for lock check, normalized 256 as '1', 255 is set to 256, default = 106
#define MCDI_GMV_LOCK_CNT_THD_GAIN ((0x2f4d << 2) + 0xff900000)
// Bit 31:20, reserved
// Bit 19:16, reg_mcdi_gmvlockcntmax.               max gmv lock count number, default = 6
// Bit 15:12, reg_mcdi_gmvlockcntoffst.             offset for gmv lock count, -8~7, default =  0
// Bit 11: 8, reg_mcdi_gmvlockcntgain.              gain for gmv lock count, normalized 8 as '1',
// 15 is set to 16, default = 8 Bit  7: 5, reserved Bit  4: 0, reg_mcdi_gmvlockcntthd. gmv count
// thd (>=) before be locked, 1~31, default = 4
#define MCDI_GMV_LOCK_ABS_DIF_THD ((0x2f4e << 2) + 0xff900000)
// Bit 31:27, reserved
// Bit 26:24, reg_mcdi_gmvlockdifthd2.              gmv dif thd for third part, before locked,
// default = 3 Bit    23, reserved Bit 22:20, reg_mcdi_gmvlockdifthd1.              gmv dif thd
// for second part, before locked, default = 2 Bit    19, reserved Bit 18:16,
// reg_mcdi_gmvlockdifthd0. gmv dif thd for first part, before locked, default = 1 Bit 15:13,
// reserved Bit 12: 8, reg_mcdi_gmvlockabsmax.               max abs of gmv to be locked, default
// = 15 Bit  7: 5, reserved Bit  4: 0, reg_mcdi_gmvlockabsmin.               min abs of gmv to be
// locked, default =
// 1
#define MCDI_HIGH_VERT_FRQ_DIF_THD ((0x2f4f << 2) + 0xff900000)
// Bit 31: 0, reg_mcdi_highvertfrqfldavgdifthd.     high_vert_frq field average luma dif thd (>=),
// 3*Blk_Width*Blk_Height, set by software, default = 103680
#define MCDI_HIGH_VERT_FRQ_DIF_DIF_THD ((0x2f50 << 2) + 0xff900000)
// Bit 31: 0, reg_mcdi_highvertfrqfldavgdifdifthd.  high_vert_frq field average luma dif's dif thd
// (<), 3*Blk_Width*Blk_Height, set by software, default = 103680
#define MCDI_HIGH_VERT_FRQ_RT_GAIN ((0x2f51 << 2) + 0xff900000)
// Bit 31:20, reserved
// Bit 19:16, reg_mcdi_highvertfrqcntthd.           high_vert_frq count thd (>=) before locked,
// 1~31, default = 4 Bit 15: 8, reg_mcdi_highvertfrqbadsadrt.         ratio for high_vert_frq bad
// sad count, normalized 256 as '1', 255 is set to 256, default = 24 Bit  7: 0,
// reg_mcdi_highvertfrqbadbadwrt.        ratio for high_vert_frq badw count, normalized 256 as
// '1', 255 is set to 256, default = 130
#define MCDI_MOTION_PARADOX_THD ((0x2f52 << 2) + 0xff900000)
// Bit 31:29, reserved
// Bit 28:24, reg_mcdi_motionparadoxcntthd.         motion paradox count thd (>=) before locked,
// 1~31, default = 4 Bit 23:22, reserved Bit 21:16, reg_mcdi_motionparadoxgmvthd.         abs gmv
// thd (<) of motion paradox, 0~32, note that 32 means invalid gmv, be careful, default = 32 Bit
// 15: 0, reserved
#define MCDI_MOTION_PARADOX_RT ((0x2f53 << 2) + 0xff900000)
// Bit 31:24, reserved
// Bit 23:16, reg_mcdi_motionparadoxbadsadrt.       ratio for field bad sad count of motion
// paradox, normalized 256 as '1', 255 is set to 256, default = 24 Bit 15: 8,
// reg_mcdi_motionparadoxbadrelrt.       ratio for field bad reliabilty count of motion paradox,
// normalized 256 as '1', 255 is set to 256, default = 120 Bit  7: 0, reg_mcdi_motionparadoxmtnrt.
// ratio for field motion count of motion paradox, normalized 256 as '1', 255 is set to 256,
// default = 218
#define MCDI_MOTION_REF_THD ((0x2f54 << 2) + 0xff900000)
// Bit 31:24, reserved
// Bit 23:20, reg_mcdi_motionrefoffst.              motion ref additive offset, default = 15
// Bit 19:16, reg_mcdi_motionrefgain.               motion ref gain, normalized 8 as '1', default
// = 8 Bit 15:13, reserved Bit 12: 8, reg_mcdi_motionrefrptmvthd.           abs thd (>=) of rpt mv
// (0~31, 32 means invalid) for motion ref, default = 1 Bit  7: 2, reg_mcdi_motionrefqmvthd. min
// thd (>=) of abs qmv for motion ref, note that quarter mv's range is -63~63, default = 2 Bit  1:
// 0, reg_mcdi_motionreflpfmode.            Mv and (8 x repeat flg) 's lpf mode of motion
// refinement, 0: no lpf, 1: [1 2 1], 2: [1 2 2 2 1], default = 1
#define MCDI_REL_COL_REF_RT ((0x2f55 << 2) + 0xff900000)
// Bit 31: 8, reserved
// Bit  7: 0, reg_mcdi_relcolrefrt.                 ratio for column cofidence level against
// column number, for refinement, default = 135
#define MCDI_PD22_CHK_THD_RT ((0x2f56 << 2) + 0xff900000)
// Bit 31:27, reserved
// Bit 26:16, reg_mcdi_pd22chkfltcntrt.             ratio for flat count of field pulldown 22
// check, normalized 2048 as '1', 2047 is set to 2048, default = 1 Bit 15: 8,
// reg_mcdi_pd22chkcntrt.                ratio of pulldown 22 check count, normalized 256 as '1',
// 255 is set to 256, default = 100 Bit  7: 5, reserved Bit  4: 0, reg_mcdi_pd22chkcntthd. thd
// (>=) for pd22 count before locked, 1~31, default = 4
#define MCDI_CHAR_DET_DIF_THD ((0x2f57 << 2) + 0xff900000)
// Bit 31:24, reserved
// Bit 23:16, reg_mcdi_chardetminmaxdifthd.         thd (>=) for dif between min and max value,
// default = 64 Bit 15: 8, reg_mcdi_chardetmaxdifthd.            thd (<) for dif between max
// value, default = 17 Bit  7: 0, reg_mcdi_chardetmindifthd.            thd (<) for dif between
// min value, default = 17
#define MCDI_CHAR_DET_CNT_THD ((0x2f58 << 2) + 0xff900000)
// Bit 31:21, reserved
// Bit 20:16, reg_mcdi_chardettotcntthd.            thd (>=) for total count, 0~21, default = 18
// Bit 15:13, reserved
// Bit 12: 8, reg_mcdi_chardetmaxcntthd.            thd (>=) for max count, 0~21, default = 1
// Bit  7: 5, reserved
// Bit  4: 0, reg_mcdi_chardetmincntthd.            thd (>=) for min count, 0~21, default = 1
// new add
#define MCDI_PD_22_CHK_WND0_X ((0x2f59 << 2) + 0xff900000)
// Bit 31:29, reserved
// Bit 28:16, reg_mcdi_pd22chkwnd0_x1                 u13, x1 for window 0, HSIZE-1, software
// control, default = 719 Bit 15:13, reserved Bit 12: 0, reg_mcdi_pd22chkwnd0_x0 u13, x0 for
// window 0, software control, default = 0
#define MCDI_PD_22_CHK_WND0_Y ((0x2f5a << 2) + 0xff900000)
// Bit 31:29, reserved
// Bit 28:16, reg_mcdi_pd22chkwnd0_y1                 u13, y1 for window 0  software control,
// default = 39 Bit 15:13, reserved Bit 12: 0, reg_mcdi_pd22chkwnd0_y0                 u13, y0 for
// window 0, software control, default = 0
#define MCDI_PD_22_CHK_WND1_X ((0x2f5b << 2) + 0xff900000)
// Bit 31:29, reserved
// Bit 28:16, reg_mcdi_pd22chkwnd1_x1                 u13, x1 for window 1, HSIZE-1, software
// control, default = 719 Bit 15:13, reserved Bit 12: 0, reg_mcdi_pd22chkwnd1_x0 u13, x0 for
// window 1, software control, default = 0
#define MCDI_PD_22_CHK_WND1_Y ((0x2f5c << 2) + 0xff900000)
// Bit 31:29, reserved
// Bit 28:16, reg_mcdi_pd22chkwnd1_y1                 u13, y1 for window 1  software control,
// default = 199 Bit 15:13, reserved Bit 12: 0, reg_mcdi_pd22chkwnd1_y0                 u13, y0
// for window 1, software control, default = 40
#define MCDI_PD_22_CHK_FRC_LMV ((0x2f5d << 2) + 0xff900000)
// Bit 31:11, reserved
// Bit    10, reg_mcdi_pd22chklmvchk2               u1, lmv lock check while force vof for each
// windows, default = 1 Bit     9, reg_mcdi_pd22chklmvchk1               u1, lmv lock check while
// force vof for each windows, default = 0 Bit     8, reg_mcdi_pd22chklmvchk0               u1,
// lmv lock check while force vof for each windows, default = 0 Bit     7, reserved Bit     6,
// reg_mcdi_pd22chkfrcpd2                u1, force pd flags for each windows, default = 0 Bit 5,
// reg_mcdi_pd22chkfrcpd1                u1, force pd flags for each windows, default = 0 Bit 4,
// reg_mcdi_pd22chkfrcpd0                u1, force pd flags for each windows, default = 0 Bit 3,
// reserved Bit     2, reg_mcdi_pd22chkfrcvof2               u1, force vof flags for each windows,
// default = 1 Bit     1, reg_mcdi_pd22chkfrcvof1               u1, force vof flags for each
// windows, default = 0 Bit     0, reg_mcdi_pd22chkfrcvof0               u1, force vof flags for
// each windows, default = 0
#define MCDI_PD_22_CHK_FLG_CNT ((0x2f5e << 2) + 0xff900000)
// Bit 31:27, reserved.
// Bit    26, reg_mcdi_pd22chkflg2.                     pull down 22 flag of prevoius one field.
// initial = 0 Bit    25, reg_mcdi_pd22chkflg1.                     pull down 22 flag of prevoius
// one field. initial = 0 Bit    24, reg_mcdi_pd22chkflg.                      pull down 22 flag
// of prevoius one field. initial = 0 Bit 23:16, reg_mcdi_pd22chkcnt2.                     pull
// down 22 count till prevoius one field. initial = 0 Bit 15: 8, reg_mcdi_pd22chkcnt1. pull down
// 22 count till prevoius one field. initial = 0 Bit  7: 0, reg_mcdi_pd22chkcnt. pull down 22
// count till prevoius one field. initial = 0
#define MCDI_RO_FLD_PD_22_PRE_CNT1 ((0x2fca << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_fldpd22precnt1.              prevoius pd22 check count of whole pre one
// field (block based). initial = 0
#define MCDI_RO_FLD_PD_22_FOR_CNT1 ((0x2fcb << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_fldpd22forcnt1.              forward pd22 check count of whole pre one field
// (block based). initial = 0
#define MCDI_RO_FLD_PD_22_FLT_CNT1 ((0x2fcc << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_fldpd22fltcnt1.              flat count (for pd22 check) of whole pre one
// field (block based). initial = 0
#define MCDI_RO_FLD_PD_22_PRE_CNT2 ((0x2fcd << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_fldpd22precnt2.              prevoius pd22 check count of whole pre one
// field (block based). initial = 0
#define MCDI_RO_FLD_PD_22_FOR_CNT2 ((0x2fce << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_fldpd22forcnt2.              forward pd22 check count of whole pre one field
// (block based). initial = 0
#define MCDI_RO_FLD_PD_22_FLT_CNT2 ((0x2fcf << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_fldpd22fltcnt2.              flat count (for pd22 check) of whole pre one
// field (block based). initial = 0
#define MCDI_FIELD_MV ((0x2f60 << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_pd22chkcnt
// Bit 23:16, reg_mcdi_fieldgmvcnt
// Bit    15, reg_mcdi_pd22chkflg
// Bit    14, reg_mcdi_fieldgmvlock
// Bit 13: 8, reg_mcdi_fieldrptmv.                  last field rpt mv
// Bit  7: 6, reserved
// Bit  5: 0, reg_mcdi_fieldgmv.                    last field gmv
#define MCDI_FIELD_HVF_PRDX_CNT ((0x2f61 << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_motionparadoxcnt.
// Bit 23:17, reserved
// Bit    16, reg_mcdi_motionparadoxflg.
// Bit 15: 8, reg_mcdi_highvertfrqcnt.
// Bit  7: 4, reserved
// Bit  3: 2, reg_mcdi_highvertfrqphase.
// Bit     1, reserved
// Bit     0, reg_mcdi_highvertfrqflg.
#define MCDI_FIELD_LUMA_AVG_SUM_0 ((0x2f62 << 2) + 0xff900000)
// Bit 31: 0, reg_mcdi_fld_luma_avg_sum0.
#define MCDI_FIELD_LUMA_AVG_SUM_1 ((0x2f63 << 2) + 0xff900000)
// Bit 31: 0, reg_mcdi_fld_luma_avg_sum1.
#define MCDI_YCBCR_BLEND_CRTL ((0x2f64 << 2) + 0xff900000)
// Bit 31:16, reserved
// Bit 15: 8, reg_mcdi_ycbcrblendgain.              ycbcr blending gain for cbcr in ycbcr. default
// = 0 Bit  7: 2, reserved. Bit  1: 0, reg_mcdi_ycbcrblendmode.              0:y+cmb(cb,cr),
// 1:med(r,g,b), 2:max(r,g,b), default = 2
#define MCDI_MCVECWR_CANVAS_SIZE ((0x2f65 << 2) + 0xff900000)
#define MCDI_MCVECRD_CANVAS_SIZE ((0x2f66 << 2) + 0xff900000)
#define MCDI_MCINFOWR_CANVAS_SIZE ((0x2f67 << 2) + 0xff900000)
#define MCDI_MCINFORD_CANVAS_SIZE ((0x2f68 << 2) + 0xff900000)
#define MCDI_MCVECWR_X ((0x2f92 << 2) + 0xff900000)
#define MCDI_MCVECWR_Y ((0x2f93 << 2) + 0xff900000)
#define MCDI_MCVECWR_CTRL ((0x2f94 << 2) + 0xff900000)
#define MCDI_MCVECRD_X ((0x2f95 << 2) + 0xff900000)
#define MCDI_MCVECRD_Y ((0x2f96 << 2) + 0xff900000)
#define MCDI_MCVECRD_CTRL ((0x2f97 << 2) + 0xff900000)
#define MCDI_MCINFOWR_X ((0x2f98 << 2) + 0xff900000)
#define MCDI_MCINFOWR_Y ((0x2f99 << 2) + 0xff900000)
#define MCDI_MCINFOWR_CTRL ((0x2f9a << 2) + 0xff900000)
#define MCDI_MCINFORD_X ((0x2f9b << 2) + 0xff900000)
#define MCDI_MCINFORD_Y ((0x2f9c << 2) + 0xff900000)
#define MCDI_MCINFORD_CTRL ((0x2f9d << 2) + 0xff900000)
#define MCDI_LMVLCKSTEXT_0 ((0x2f69 << 2) + 0xff900000)
// Bit 31:28, reserved
// Bit 27:16, mcdi_lmvlckstext_1                    lmv lck blog 1 line start
// Bit 15:12, reserved
// Bit 11: 0, mcdi_lmvlckstext_0                    lmv lck blog 0 line start
#define MCDI_LMVLCKSTEXT_1 ((0x2f6a << 2) + 0xff900000)
// Bit 31   , mcdi_refnewmode                       new ref me mv array order
// Bit 30   , mcdi_ref_lmv_lck_en                   use locked line mvs for ref
// Bit 29:28, mcdi_lmvlckupdw_ext                   up/down extend lines for locked lmv line's
// Bit 27:12, mcdi_lmvlckmin                        lmv lck blog height limit
// Bit 15:12, reserved
// Bit 11: 0, mcdi_lmvlckstext_2                    lmv lck blog 2 line start
#define MCDI_LMVLCKEDEXT_0 ((0x2f6b << 2) + 0xff900000)
// Bit 31:28, reserved
// Bit 27:16, mcdi_lmvlckedext_1                    lmv lck blog 1 line end
// Bit 15:12, reserved
// Bit 11: 0, mcdi_lmvlckedext_0                    lmv lck blog 0 line end
#define MCDI_LMVLCKEDEXT_1 ((0x2f6c << 2) + 0xff900000)
// Bit 31:12, reserved
// Bit 11: 0, mcdi_lmvlckedext_2                    lmv lck blog 2 line end
// ================================================================== MC registers======
#define MCDI_MC_CRTL ((0x2f70 << 2) + 0xff900000)
// Bit 31: 9, reserved
// Bit     8, reg_mcdi_mcpreflg.                    flag to use previous field for MC, 0:forward
// field, 1: previous field, default = 1 Bit     7, reg_mcdi_mcrelrefbycolcfden.          enable
// rel refinement by column cofidence in mc blending, default = 1 Bit  6: 5, reg_mcdi_mclpfen.
// enable mc pixles/rel lpf, 0:disable, 1: lpf rel, 2: lpf mc pxls, 3: lpf both rel and mc pxls,
// default = 0 Bit  4: 2, reg_mcdi_mcdebugmode.                 enable mc debug mode, 0:disable,
// 1: split left/right, 2: split top/bottom, 3: debug mv, 4: debug rel, default = 0 Bit  1: 0,
// reg_mcdi_mcen.                        mcdi enable mode, 0:disable, 1: blend with ma, 2: full
// mc, default = 1
#define MCDI_MC_LPF_MSK_0 ((0x2f71 << 2) + 0xff900000)
// Bit 31:21, reserved
// Bit 20:16, reg_mcdi_mclpfmsk02.                  mc lpf coef. 2 for pixel 0 of current block,
// normalized 16 as '1', default = 0 Bit 15:13, reserved Bit 12: 8, reg_mcdi_mclpfmsk01. mc lpf
// coef. 1 for pixel 0 of current block, normalized 16 as '1', default = 9 Bit  7: 5, reserved Bit
// 4: 0, reg_mcdi_mclpfmsk00.                  mc lpf coef. 0 for pixel 0 of current block,
// normalized 16 as '1', default = 7
#define MCDI_MC_LPF_MSK_1 ((0x2f72 << 2) + 0xff900000)
// Bit 31:21, reserved
// Bit 20:16, reg_mcdi_mclpfmsk12.                  mc lpf coef. 2 for pixel 1 of current block,
// 0~16, normalized 16 as '1', default = 0 Bit 15:13, reserved Bit 12: 8, reg_mcdi_mclpfmsk11. mc
// lpf coef. 1 for pixel 1 of current block, 0~16, normalized 16 as '1', default = 11 Bit  7: 5,
// reserved Bit  4: 0, reg_mcdi_mclpfmsk10.                  mc lpf coef. 0 for pixel 1 of current
// block, 0~16, normalized 16 as '1', default = 5
#define MCDI_MC_LPF_MSK_2 ((0x2f73 << 2) + 0xff900000)
// Bit 31:21, reserved
// Bit 20:16, reg_mcdi_mclpfmsk22.                  mc lpf coef. 2 for pixel 2 of current block,
// 0~16, normalized 16 as '1', default = 1 Bit 15:13, reserved Bit 12: 8, reg_mcdi_mclpfmsk21. mc
// lpf coef. 1 for pixel 2 of current block, 0~16, normalized 16 as '1', default = 14 Bit  7: 5,
// reserved Bit  4: 0, reg_mcdi_mclpfmsk20.                  mc lpf coef. 0 for pixel 2 of current
// block, 0~16, normalized 16 as '1', default = 1
#define MCDI_MC_LPF_MSK_3 ((0x2f74 << 2) + 0xff900000)
// Bit 31:21, reserved
// Bit 20:16, reg_mcdi_mclpfmsk32.                  mc lpf coef. 2 for pixel 3 of current block,
// 0~16, normalized 16 as '1', default = 5 Bit 15:13, reserved Bit 12: 8, reg_mcdi_mclpfmsk31. mc
// lpf coef. 1 for pixel 3 of current block, 0~16, normalized 16 as '1', default = 11 Bit  7: 5,
// reserved Bit  4: 0, reg_mcdi_mclpfmsk30.                  mc lpf coef. 0 for pixel 3 of current
// block, 0~16, normalized 16 as '1', default = 0
#define MCDI_MC_LPF_MSK_4 ((0x2f75 << 2) + 0xff900000)
// Bit 31:21, reserved
// Bit 20:16, reg_mcdi_mclpfmsk42.                  mc lpf coef. 2 for pixel 4 of current block,
// 0~16, normalized 16 as '1', default = 7 Bit 15:13, reserved Bit 12: 8, reg_mcdi_mclpfmsk41. mc
// lpf coef. 1 for pixel 4 of current block, 0~16, normalized 16 as '1', default = 9 Bit  7: 5,
// reserved Bit  4: 0, reg_mcdi_mclpfmsk40.                  mc lpf coef. 0 for pixel 4 of current
// block, 0~16, normalized 16 as '1', default = 0
#define MCDI_MC_REL_GAIN_OFFST_0 ((0x2f76 << 2) + 0xff900000)
// Bit 31:26, reserved
// Bit    25, reg_mcdi_mcmotionparadoxflg.          flag of motion paradox, initial with 0 and
// read from software, default = 0 Bit    24, reg_mcdi_mchighvertfrqflg.            flag of high
// vert frq, initial with 0 and read from software, default = 0 Bit 23:16,
// reg_mcdi_mcmotionparadoxoffst.        offset (rel + offset) for rel (MC blending coef.)
// refinement if motion paradox detected before MC blending before MC blending, default = 128 Bit
// 15:12, reserved Bit 11: 8, reg_mcdi_mcmotionparadoxgain.         gain for rel (MC blending
// coef.) refinement if motion paradox detected before MC blending, normalized 8 as '1', set 15 to
// 16, default = 8 Bit  7: 4, reg_mcdi_mchighvertfrqoffst.          minus offset (alpha - offset)
// for motion (MA blending coef.) refinement if high vertical frequency detected before MA
// blending, default = 15 Bit  3: 0, reg_mcdi_mchighvertfrqgain.           gain for motion (MA
// blending coef.) refinement if high vertical frequency detected before MA blending, normalized 8
// as '1', set 15 to 16, default = 8
#define MCDI_MC_REL_GAIN_OFFST_1 ((0x2f77 << 2) + 0xff900000)
// Bit 31:24, reg_mcdi_mcoutofboundrayoffst.        offset (rel + offset) for rel (MC blending
// coef.) refinement if MC pointed out of boundray before MC blending before MC blending, default
// = 255 Bit 23:20, reserved Bit 19:16, reg_mcdi_mcoutofboundraygain.         gain for rel (MC
// blending coef.) refinement if MC pointed out of boundray before MC blending, normalized 8 as
// '1', set 15 to 16, default = 8 Bit 15: 8, reg_mcdi_mcrelrefbycolcfdoffst.       offset (rel +
// offset) for rel (MC blending coef.) refinement if motion paradox detected before MC blending
// before MC blending, default = 255 Bit  7: 4, reserved. Bit  3: 0,
// reg_mcdi_mcrelrefbycolcfdgain. gain for rel (MC blending coef.) refinement if column cofidence
// failed before MC blending, normalized 8 as '1', set 15 to 16, default = 8
#define MCDI_MC_COL_CFD_0 ((0x2f78 << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_0.                    column cofidence value 0 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_1 ((0x2f79 << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_1.                    column cofidence value 1 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_2 ((0x2f7a << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_2.                    column cofidence value 2 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_3 ((0x2f7b << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_3.                    column cofidence value 3 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_4 ((0x2f7c << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_4.                    column cofidence value 4 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_5 ((0x2f7d << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_5.                    column cofidence value 5 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_6 ((0x2f7e << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_6.                    column cofidence value 6 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_7 ((0x2f7f << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_7.                    column cofidence value 7 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_8 ((0x2f80 << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_8.                    column cofidence value 8 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_9 ((0x2f81 << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_9.                    column cofidence value 9 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_10 ((0x2f82 << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_10.                   column cofidence value 10 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_11 ((0x2f83 << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_11.                   column cofidence value 11 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_12 ((0x2f84 << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_12.                   column cofidence value 12 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_13 ((0x2f85 << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_13.                   column cofidence value 13 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_14 ((0x2f86 << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_14.                   column cofidence value 14 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_15 ((0x2f87 << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_15.                   column cofidence value 15 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_16 ((0x2f88 << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_16.                   column cofidence value 16 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_17 ((0x2f89 << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_17.                   column cofidence value 17 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_18 ((0x2f8a << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_18.                   column cofidence value 18 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_19 ((0x2f8b << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_19.                   column cofidence value 19 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_20 ((0x2f8c << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_20.                   column cofidence value 20 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_21 ((0x2f8d << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_21.                   column cofidence value 21 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_22 ((0x2f8e << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_22.                   column cofidence value 22 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_23 ((0x2f8f << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_23.                   column cofidence value 23 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_24 ((0x2f90 << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_24.                   column cofidence value 24 read from software.
// initial = 0
#define MCDI_MC_COL_CFD_25 ((0x2f91 << 2) + 0xff900000)
// Bit 31: 0, mcdi_mc_col_cfd_25.                   column cofidence value 25 read from software.
// initial = 0
// ===================================================================================== PRE RO
// Registers
// ==========================================================================================
#define MCDI_RO_FLD_LUMA_AVG_SUM ((0x2fa0 << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_fldlumaavgsum.                block's luma avg sum of current filed (block
// based). initial = 0
#define MCDI_RO_GMV_VLD_CNT ((0x2fa1 << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_gmvvldcnt.                    valid gmv's count of pre one filed (block
// based). initial = 0
#define MCDI_RO_RPT_FLG_CNT ((0x2fa2 << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_rptflgcnt.                    repeat mv's count of pre one filed (block
// based). initial = 0
#define MCDI_RO_FLD_BAD_SAD_CNT ((0x2fa3 << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_fldbadsadcnt.                 bad sad count of whole pre one field (block
// based). initial = 0
#define MCDI_RO_FLD_BAD_BADW_CNT ((0x2fa4 << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_fldbadbadwcnt.                bad badw count of whole pre one field (block
// based). initial = 0
#define MCDI_RO_FLD_BAD_REL_CNT ((0x2fa5 << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_fldbadrelcnt.                 bad rel count of whole pre one field (block
// based). initial = 0
#define MCDI_RO_FLD_MTN_CNT ((0x2fa6 << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_fldmtncnt.                    motion count of whole pre one field (pixel
// based). initial = 0
#define MCDI_RO_FLD_VLD_CNT ((0x2fa7 << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_fldvldcnt.                    valid motion count of whole pre one field
// (pixel based). initial = 0
#define MCDI_RO_FLD_PD_22_PRE_CNT ((0x2fa8 << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_fldpd22precnt.                prevoius pd22 check count of whole pre one
// field (block based). initial = 0
#define MCDI_RO_FLD_PD_22_FOR_CNT ((0x2fa9 << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_fldpd22forcnt.                forward pd22 check count of whole pre one
// field (block based). initial = 0
#define MCDI_RO_FLD_PD_22_FLT_CNT ((0x2faa << 2) + 0xff900000)
// Bit 31: 0, ro_mcdi_fldpd22fltcnt.                flat count (for pd22 check) of whole pre one
// field (block based). initial = 0
#define MCDI_RO_HIGH_VERT_FRQ_FLG ((0x2fab << 2) + 0xff900000)
// Bit 31:16, reserved.
// Bit 15: 8, ro_mcdi_highvertfrqcnt.               high vertical frequency count till prevoius
// one field. initial = 0 Bit  7: 3, reserved. Bit  2: 1, ro_mcdi_highvertfrqphase. high vertical
// frequency phase of prevoius one field. initial = 2 Bit     0, ro_mcdi_highvertfrqflg. high
// vertical frequency flag of prevoius one field. initial = 0
#define MCDI_RO_GMV_LOCK_FLG ((0x2fac << 2) + 0xff900000)
// Bit 31:16, reserved.
// Bit 15: 8, ro_mcdi_gmvlckcnt.                    global mv lock count till prevoius one field.
// initial = 0 Bit  7: 2, ro_mcdi_gmv.                          global mv of prevoius one field.
// -31~31, initial = 32 (invalid value) Bit     1, ro_mcdi_zerogmvlckflg.                zero
// global mv lock flag of prevoius one field. initial = 0 Bit     0, ro_mcdi_gmvlckflg. global mv
// lock flag of prevoius one field. initial = 0
#define MCDI_RO_RPT_MV ((0x2fad << 2) + 0xff900000)
// Bit 5: 0, ro_mcdi_rptmv.                         repeate mv of prevoius one field. -31~31,
// initial = 32 (invalid value)
#define MCDI_RO_MOTION_PARADOX_FLG ((0x2fae << 2) + 0xff900000)
// Bit 31:16, reserved.
// Bit 15: 8, ro_mcdi_motionparadoxcnt.             motion paradox count till prevoius one field.
// initial = 0 Bit  7: 1, reserved. Bit     0, ro_mcdi_motionparadoxflg.             motion
// paradox flag of prevoius one field. initial = 0
#define MCDI_RO_PD_22_FLG ((0x2