// SPDX-License-Identifier: (GPL-2.0+ OR MIT)
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#include "vpp_pq_table.h"
#include "vpp_common.h"
#include "vpp_data.h"

static struct data_vs_param_s cur_vs_param;

static struct vpp_pq_tuning_reg_s lc_param[EN_LC_PARAM_MAX] = {
	{0x00, 4, 5, 0},
	{0x00, 8, 9, 0},
	{0x02, 0, 7, 0},
	{0x02, 8, 15, 0},
	{0x03, 0, 9, 0},
	{0x03, 16, 25, 0},
	{0x04, 0, 7, 0},
	{0x04, 8, 15, 0},
	{0x04, 16, 23, 0},
	{0x04, 24, 31, 0},
	{0x05, 0, 7, 0},
	{0x05, 8, 15, 0},
	{0x06, 0, 7, 0},
	{0x06, 8, 15, 0},
	{0x07, 0, 7, 0},
	{0x07, 16, 19, 0},
	{0x09, 0, 7, 0},
	{0x09, 8, 15, 0},
};

static struct vpp_pq_tuning_reg_s sharpness0_param[EN_SHARPNESS0_PARAM_MAX] = {
	{0x00, 0, 12, 0},
	{0x01, 0, 7, 0},
	{0x02, 0, 1, 0},
	{0x02, 4, 5, 0},
	{0x02, 8, 9, 0},
	{0x02, 12, 13, 0},
	{0x05, 0, 7, 0},
	{0x05, 8, 15, 0},
	{0x05, 16, 23, 0},
	{0x05, 24, 31, 0},
	{0x06, 8, 15, 0},
	{0x06, 16, 23, 0},
	{0x06, 24, 31, 0},
	{0x07, 0, 7, 0},
	{0x07, 8, 15, 0},
	{0x07, 16, 23, 0},
	{0x07, 24, 31, 0},
	{0x08, 8, 15, 0},
	{0x08, 16, 23, 0},
	{0x08, 24, 31, 0},
	{0x09, 0, 7, 0},
	{0x09, 8, 15, 0},
	{0x09, 16, 23, 0},
	{0x09, 24, 31, 0},
	{0x0a, 8, 15, 0},
	{0x0a, 16, 23, 0},
	{0x0a, 24, 31, 0},
	{0x0b, 0, 7, 0},
	{0x0b, 8, 15, 0},
	{0x0b, 16, 23, 0},
	{0x0b, 24, 31, 0},
	{0x0c, 8, 15, 0},
	{0x0c, 16, 23, 0},
	{0x0c, 24, 31, 0},
	{0x0d, 4, 5, 0},
	{0x0d, 8, 9, 0},
	{0x0d, 12, 13, 0},
	{0x0d, 20, 21, 0},
	{0x0d, 24, 25, 0},
	{0x0d, 28, 29, 0},
	{0x0e, 4, 5, 0},
	{0x0e, 8, 9, 0},
	{0x0e, 12, 13, 0},
	{0x0e, 20, 21, 0},
	{0x0e, 24, 25, 0},
	{0x0e, 28, 29, 0},
	{0x0f, 0, 5, 0},
	{0x0f, 8, 13, 0},
	{0x0f, 16, 21, 0},
	{0x10, 0, 5, 0},
	{0x10, 8, 13, 0},
	{0x10, 16, 21, 0},
	{0x11, 0, 5, 0},
	{0x11, 8, 13, 0},
	{0x11, 16, 21, 0},
	{0x12, 0, 5, 0},
	{0x12, 8, 13, 0},
	{0x12, 16, 21, 0},
	{0x13, 4, 7, 0},
	{0x13, 8, 11, 0},
	{0x13, 12, 15, 0},
	{0x13, 20, 23, 0},
	{0x13, 24, 27, 0},
	{0x13, 28, 31, 0},
	{0x14, 0, 5, 0},
	{0x14, 8, 15, 0},
	{0x15, 0, 7, 0},
	{0x15, 8, 15, 0},
	{0x15, 16, 23, 0},
	{0x15, 24, 31, 0},
	{0x16, 8, 15, 0},
	{0x16, 16, 23, 0},
	{0x16, 24, 31, 0},
	{0x17, 0, 7, 0},
	{0x17, 8, 15, 0},
	{0x17, 16, 23, 0},
	{0x17, 24, 31, 0},
	{0x18, 8, 15, 0},
	{0x18, 16, 23, 0},
	{0x18, 24, 31, 0},
	{0x19, 0, 5, 0},
	{0x19, 8, 13, 0},
	{0x19, 16, 21, 0},
	{0x19, 24, 29, 0},
	{0x1a, 0, 5, 0},
	{0x1a, 8, 13, 0},
	{0x1a, 16, 16, 0},
	{0x1b, 0, 7, 0},
	{0x1b, 8, 15, 0},
	{0x1b, 16, 23, 0},
	{0x1b, 24, 31, 0},
	{0x1c, 8, 15, 0},
	{0x1c, 16, 23, 0},
	{0x1c, 24, 31, 0},
	{0x1d, 0, 5, 0},
	{0x1d, 8, 13, 0},
	{0x1d, 16, 21, 0},
	{0x1d, 24, 29, 0},
	{0x1e, 0, 5, 0},
	{0x1e, 8, 13, 0},
	{0x1e, 16, 16, 0},
	{0x1f, 0, 7, 0},
	{0x1f, 8, 15, 0},
	{0x1f, 16, 23, 0},
	{0x1f, 24, 31, 0},
	{0x20, 8, 15, 0},
	{0x20, 16, 23, 0},
	{0x20, 24, 31, 0},
	{0x21, 0, 5, 0},
	{0x21, 8, 13, 0},
	{0x22, 0, 7, 0},
	{0x22, 8, 15, 0},
	{0x22, 16, 17, 0},
	{0x23, 0, 7, 0},
	{0x23, 8, 15, 0},
	{0x23, 16, 23, 0},
	{0x23, 24, 31, 0},
	{0x24, 0, 7, 0},
	{0x24, 8, 15, 0},
	{0x24, 16, 23, 0},
	{0x24, 24, 31, 0},
	{0x25, 0, 7, 0},
	{0x25, 8, 15, 0},
	{0x25, 16, 23, 0},
	{0x25, 24, 31, 0},
	{0x26, 0, 9, 0},
	{0x26, 12, 21, 0},
	{0x26, 24, 25, 0},
	{0x26, 28, 29, 0},
	{0x27, 0, 0, 0},
	{0x27, 1, 1, 0},
	{0x27, 2, 3, 0},
	{0x28, 0, 4, 0},
	{0x28, 9, 10, 0},
	{0x28, 16, 23, 0},
	{0x28, 24, 31, 0},
	{0x29, 0, 1, 0},
	{0x29, 2, 3, 0},
	{0x29, 8, 10, 0},
	{0x2a, 0, 5, 0},
	{0x2a, 8, 13, 0},
	{0x2a, 16, 19, 0},
	{0x2a, 24, 29, 0},
	{0x2b, 0, 5, 0},
	{0x2b, 8, 13, 0},
	{0x2b, 16, 19, 0},
	{0x2b, 24, 29, 0},
	{0x2c, 0, 5, 0},
	{0x2c, 8, 13, 0},
	{0x2c, 16, 21, 0},
	{0x2c, 24, 29, 0},
	{0x2d, 0, 2, 0},
	{0x2d, 4, 6, 0},
	{0x2d, 8, 10, 0},
	{0x2d, 12, 14, 0},
	{0x2d, 16, 17, 0},
	{0x2d, 18, 19, 0},
	{0x2d, 20, 21, 0},
	{0x2d, 22, 23, 0},
	{0x2d, 24, 25, 0},
	{0x2d, 26, 26, 0},
	{0x2d, 28, 28, 0},
	{0x2d, 30, 30, 0},
	{0x2e, 0, 2, 0},
	{0x2e, 4, 4, 0},
	{0x2e, 8, 11, 0},
	{0x2e, 12, 15, 0},
	{0x2e, 16, 17, 0},
	{0x2e, 18, 19, 0},
	{0x2e, 20, 21, 0},
	{0x2e, 22, 23, 0},
	{0x2e, 24, 25, 0},
	{0x2e, 26, 27, 0},
	{0x2e, 28, 28, 0},
	{0x2f, 0, 7, 0},
	{0x2f, 8, 15, 0},
	{0x2f, 16, 23, 0},
	{0x2f, 24, 31, 0},
	{0x30, 0, 7, 0},
	{0x30, 8, 15, 0},
	{0x30, 16, 23, 0},
	{0x30, 24, 31, 0},
	{0x31, 0, 7, 0},
	{0x31, 8, 15, 0},
	{0x31, 16, 23, 0},
	{0x31, 24, 25, 0},
	{0x31, 26, 28, 0},
	{0x31, 29, 31, 0},
	{0x32, 0, 7, 0},
	{0x32, 8, 15, 0},
	{0x32, 16, 23, 0},
	{0x32, 24, 31, 0},
	{0x33, 0, 7, 0},
	{0x34, 0, 2, 0},
	{0x34, 4, 4, 0},
	{0x34, 8, 11, 0},
	{0x34, 12, 15, 0},
	{0x34, 16, 17, 0},
	{0x34, 18, 19, 0},
	{0x34, 20, 21, 0},
	{0x34, 22, 23, 0},
	{0x34, 24, 25, 0},
	{0x34, 26, 27, 0},
	{0x34, 28, 28, 0},
	{0x35, 0, 7, 0},
	{0x35, 8, 15, 0},
	{0x35, 16, 23, 0},
	{0x35, 24, 28, 0},
	{0x36, 0, 7, 0},
	{0x36, 8, 15, 0},
	{0x36, 16, 23, 0},
	{0x36, 24, 31, 0},
	{0x37, 0, 7, 0},
	{0x37, 8, 15, 0},
	{0x37, 16, 23, 0},
	{0x37, 24, 25, 0},
	{0x37, 26, 28, 0},
	{0x37, 29, 31, 0},
	{0x38, 0, 7, 0},
	{0x38, 8, 15, 0},
	{0x38, 16, 23, 0},
	{0x38, 24, 31, 0},
	{0x39, 0, 7, 0},
	{0x3a, 0, 0, 0},
	{0x3a, 2, 2, 0},
	{0x3a, 4, 5, 0},
	{0x3a, 6, 7, 0},
	{0x3a, 8, 9, 0},
	{0x3a, 10, 11, 0},
	{0x3a, 12, 13, 0},
	{0x3a, 14, 14, 0},
	{0x3b, 0, 7, 0},
	{0x3b, 8, 15, 0},
	{0x3b, 16, 23, 0},
	{0x3c, 0, 7, 0},
	{0x3c, 8, 15, 0},
	{0x3c, 16, 23, 0},
	{0x3d, 0, 7, 0},
	{0x3d, 8, 15, 0},
	{0x3d, 16, 23, 0},
	{0x3d, 24, 31, 0},
	{0x3e, 0, 7, 0},
	{0x3e, 8, 15, 0},
	{0x3e, 16, 23, 0},
	{0x3e, 24, 31, 0},
	{0x3f, 0, 0, 0},
	{0x3f, 2, 2, 0},
	{0x3f, 4, 5, 0},
	{0x3f, 6, 7, 0},
	{0x3f, 8, 9, 0},
	{0x3f, 10, 11, 0},
	{0x3f, 12, 13, 0},
	{0x3f, 14, 14, 0},
	{0x40, 0, 7, 0},
	{0x40, 8, 15, 0},
	{0x40, 16, 23, 0},
	{0x41, 0, 7, 0},
	{0x41, 8, 15, 0},
	{0x41, 16, 23, 0},
	{0x42, 0, 7, 0},
	{0x42, 8, 15, 0},
	{0x42, 16, 23, 0},
	{0x42, 24, 31, 0},
	{0x43, 0, 7, 0},
	{0x43, 8, 15, 0},
	{0x43, 16, 23, 0},
	{0x43, 24, 31, 0},
	{0x44, 0, 12, 0},
	{0x44, 16, 28, 0},
	{0x61, 0, 0, 0},
	{0x61, 1, 1, 0},
	{0x61, 2, 2, 0},
	{0x61, 3, 3, 0},
	{0x61, 4, 4, 0},
	{0x61, 5, 5, 0},
	{0x61, 6, 6, 0},
	{0x61, 7, 7, 0},
	{0x61, 8, 13, 0},
	{0x61, 16, 21, 0},
	{0x61, 24, 29, 0},
	{0x62, 0, 0, 0},
	{0x62, 2, 3, 0},
	{0x62, 4, 5, 0},
	{0x62, 6, 7, 0},
	{0x62, 8, 8, 0},
	{0x62, 9, 9, 0},
	{0x62, 10, 10, 0},
	{0x62, 11, 11, 0},
	{0x63, 0, 5, 0},
	{0x63, 6, 6, 0},
	{0x63, 7, 7, 0},
	{0x63, 8, 15, 0},
	{0x63, 16, 23, 0},
	{0x63, 24, 26, 0},
	{0x63, 28, 30, 0},
	{0x66, 0, 2, 0},
	{0x66, 3, 3, 0},
	{0x66, 4, 6, 0},
	{0x66, 8, 14, 0},
	{0x67, 0, 3, 0},
	{0x67, 8, 11, 0},
	{0x67, 16, 19, 0},
	{0x67, 24, 27, 0},
	{0x68, 0, 3, 0},
	{0x68, 8, 11, 0},
	{0x68, 16, 19, 0},
	{0x68, 24, 27, 0},
	{0x69, 0, 3, 0},
	{0x69, 8, 11, 0},
	{0x69, 16, 19, 0},
	{0x69, 24, 27, 0},
	{0x6a, 0, 3, 0},
	{0x6a, 4, 7, 0},
	{0x6a, 8, 11, 0},
	{0x6a, 12, 15, 0},
	{0x6a, 16, 19, 0},
	{0x6a, 20, 23, 0},
	{0x6a, 24, 27, 0},
	{0x6a, 28, 31, 0},
	{0x6b, 0, 7, 0},
	{0x6b, 8, 15, 0},
	{0x6b, 16, 17, 0},
	{0x6b, 20, 23, 0},
	{0x6b, 24, 26, 0},
	{0x6b, 28, 30, 0},
	{0x6c, 0, 7, 0},
	{0x6c, 8, 15, 0},
	{0x6c, 16, 23, 0},
	{0x6c, 24, 31, 0},
	{0x6d, 0, 7, 0},
	{0x6d, 8, 15, 0},
	{0x6d, 16, 23, 0},
	{0x6e, 0, 7, 0},
	{0x6e, 8, 15, 0},
	{0x6e, 16, 23, 0},
	{0x6e, 24, 31, 0},
	{0x6f, 0, 7, 0},
	{0x6f, 8, 15, 0},
	{0x6f, 16, 23, 0},
	{0x70, 0, 3, 0},
	{0x70, 4, 7, 0},
	{0x70, 8, 11, 0},
	{0x70, 12, 15, 0},
	{0x70, 16, 19, 0},
	{0x70, 20, 23, 0},
	{0x70, 24, 27, 0},
	{0x70, 28, 31, 0},
	{0x71, 0, 3, 0},
	{0x71, 4, 7, 0},
	{0x71, 8, 11, 0},
	{0x71, 12, 15, 0},
	{0x71, 16, 19, 0},
	{0x71, 20, 23, 0},
	{0x71, 24, 27, 0},
	{0x71, 28, 31, 0},
	{0x72, 0, 5, 0},
	{0x72, 8, 15, 0},
	{0x72, 16, 23, 0},
	{0x73, 0, 15, 0},
	{0x73, 16, 31, 0},
	{0x77, 0, 1, 0},
	{0x77, 2, 3, 0},
	{0x77, 4, 4, 0},
	{0x77, 5, 5, 0},
	{0x77, 6, 6, 0},
	{0x77, 7, 7, 0},
	{0x77, 9, 11, 0},
	{0x77, 13, 15, 0},
	{0x77, 17, 19, 0},
	{0x77, 20, 20, 0},
	{0x77, 21, 21, 0},
	{0x77, 22, 22, 0},
	{0x77, 23, 23, 0},
	{0x77, 24, 24, 0},
	{0x77, 25, 25, 0},
	{0x77, 26, 26, 0},
	{0x79, 0, 2, 0},
	{0x79, 3, 5, 0},
	{0x79, 6, 8, 0},
	{0x79, 9, 11, 0},
	{0x79, 12, 14, 0},
	{0x79, 15, 17, 0},
	{0x79, 18, 20, 0},
	{0x79, 21, 23, 0},
	{0x7a, 0, 9, 0},
	{0x7a, 16, 25, 0},
	{0x7b, 0, 15, 0},
	{0x7b, 16, 31, 0},
	{0x7c, 0, 15, 0},
	{0x7c, 16, 31, 0},
	{0x7d, 0, 15, 0},
	{0x7d, 16, 31, 0},
	{0x7e, 0, 3, 0},
	{0x7e, 4, 7, 0},
	{0x7e, 8, 11, 0},
	{0x7e, 12, 15, 0},
	{0x7e, 16, 19, 0},
	{0x7e, 20, 23, 0},
	{0x7e, 24, 27, 0},
	{0x7e, 28, 31, 0},
	{0x7f, 0, 3, 0},
};

static struct vpp_pq_tuning_reg_s sharpness1_param[EN_SHARPNESS1_PARAM_MAX] = {
	{0x00, 0, 12, 0},
	{0x01, 0, 7, 0},
	{0x02, 0, 1, 0},
	{0x02, 4, 5, 0},
	{0x02, 8, 9, 0},
	{0x02, 12, 13, 0},
	{0x05, 0, 7, 0},
	{0x05, 8, 15, 0},
	{0x05, 16, 23, 0},
	{0x05, 24, 31, 0},
	{0x06, 8, 15, 0},
	{0x06, 16, 23, 0},
	{0x06, 24, 31, 0},
	{0x07, 0, 7, 0},
	{0x07, 8, 15, 0},
	{0x07, 16, 23, 0},
	{0x07, 24, 31, 0},
	{0x08, 8, 15, 0},
	{0x08, 16, 23, 0},
	{0x08, 24, 31, 0},
	{0x09, 0, 7, 0},
	{0x09, 8, 15, 0},
	{0x09, 16, 23, 0},
	{0x09, 24, 31, 0},
	{0x0a, 8, 15, 0},
	{0x0a, 16, 23, 0},
	{0x0a, 24, 31, 0},
	{0x0b, 0, 7, 0},
	{0x0b, 8, 15, 0},
	{0x0b, 16, 23, 0},
	{0x0b, 24, 31, 0},
	{0x0c, 8, 15, 0},
	{0x0c, 16, 23, 0},
	{0x0c, 24, 31, 0},
	{0x0d, 4, 5, 0},
	{0x0d, 8, 9, 0},
	{0x0d, 12, 13, 0},
	{0x0d, 20, 21, 0},
	{0x0d, 24, 25, 0},
	{0x0d, 28, 29, 0},
	{0x0e, 4, 5, 0},
	{0x0e, 8, 9, 0},
	{0x0e, 12, 13, 0},
	{0x0e, 20, 21, 0},
	{0x0e, 24, 25, 0},
	{0x0e, 28, 29, 0},
	{0x0f, 0, 5, 0},
	{0x0f, 8, 13, 0},
	{0x0f, 16, 21, 0},
	{0x10, 0, 5, 0},
	{0x10, 8, 13, 0},
	{0x10, 16, 21, 0},
	{0x11, 0, 5, 0},
	{0x11, 8, 13, 0},
	{0x11, 16, 21, 0},
	{0x12, 0, 5, 0},
	{0x12, 8, 13, 0},
	{0x12, 16, 21, 0},
	{0x13, 4, 7, 0},
	{0x13, 8, 11, 0},
	{0x13, 12, 15, 0},
	{0x13, 20, 23, 0},
	{0x13, 24, 27, 0},
	{0x13, 28, 31, 0},
	{0x14, 0, 5, 0},
	{0x14, 8, 15, 0},
	{0x15, 0, 7, 0},
	{0x15, 8, 15, 0},
	{0x15, 16, 23, 0},
	{0x15, 24, 31, 0},
	{0x16, 8, 15, 0},
	{0x16, 16, 23, 0},
	{0x16, 24, 31, 0},
	{0x17, 0, 7, 0},
	{0x17, 8, 15, 0},
	{0x17, 16, 23, 0},
	{0x17, 24, 31, 0},
	{0x18, 8, 15, 0},
	{0x18, 16, 23, 0},
	{0x18, 24, 31, 0},
	{0x19, 0, 5, 0},
	{0x19, 8, 13, 0},
	{0x19, 16, 21, 0},
	{0x19, 24, 29, 0},
	{0x1a, 0, 5, 0},
	{0x1a, 8, 13, 0},
	{0x1a, 16, 16, 0},
	{0x1b, 0, 7, 0},
	{0x1b, 8, 15, 0},
	{0x1b, 16, 23, 0},
	{0x1b, 24, 31, 0},
	{0x1c, 8, 15, 0},
	{0x1c, 16, 23, 0},
	{0x1c, 24, 31, 0},
	{0x1d, 0, 5, 0},
	{0x1d, 8, 13, 0},
	{0x1d, 16, 21, 0},
	{0x1d, 24, 29, 0},
	{0x1e, 0, 5, 0},
	{0x1e, 8, 13, 0},
	{0x1e, 16, 16, 0},
	{0x1f, 0, 7, 0},
	{0x1f, 8, 15, 0},
	{0x1f, 16, 23, 0},
	{0x1f, 24, 31, 0},
	{0x20, 8, 15, 0},
	{0x20, 16, 23, 0},
	{0x20, 24, 31, 0},
	{0x21, 0, 5, 0},
	{0x21, 8, 13, 0},
	{0x22, 0, 7, 0},
	{0x22, 8, 15, 0},
	{0x22, 16, 17, 0},
	{0x23, 0, 7, 0},
	{0x23, 8, 15, 0},
	{0x23, 16, 23, 0},
	{0x23, 24, 31, 0},
	{0x24, 0, 7, 0},
	{0x24, 8, 15, 0},
	{0x24, 16, 23, 0},
	{0x24, 24, 31, 0},
	{0x25, 0, 7, 0},
	{0x25, 8, 15, 0},
	{0x25, 16, 23, 0},
	{0x25, 24, 31, 0},
	{0x26, 0, 9, 0},
	{0x26, 12, 21, 0},
	{0x26, 24, 25, 0},
	{0x26, 28, 29, 0},
	{0x27, 0, 0, 0},
	{0x27, 1, 1, 0},
	{0x27, 2, 3, 0},
	{0x28, 0, 4, 0},
	{0x28, 9, 10, 0},
	{0x28, 16, 23, 0},
	{0x28, 24, 31, 0},
	{0x29, 0, 1, 0},
	{0x29, 2, 3, 0},
	{0x29, 8, 10, 0},
	{0x2a, 0, 5, 0},
	{0x2a, 8, 13, 0},
	{0x2a, 16, 19, 0},
	{0x2a, 24, 29, 0},
	{0x2b, 0, 5, 0},
	{0x2b, 8, 13, 0},
	{0x2b, 16, 19, 0},
	{0x2b, 24, 29, 0},
	{0x2c, 0, 5, 0},
	{0x2c, 8, 13, 0},
	{0x2c, 16, 21, 0},
	{0x2c, 24, 29, 0},
	{0x2d, 0, 2, 0},
	{0x2d, 4, 6, 0},
	{0x2d, 8, 10, 0},
	{0x2d, 12, 14, 0},
	{0x2d, 16, 17, 0},
	{0x2d, 18, 19, 0},
	{0x2d, 20, 21, 0},
	{0x2d, 22, 23, 0},
	{0x2d, 24, 25, 0},
	{0x2d, 26, 26, 0},
	{0x2d, 28, 28, 0},
	{0x2d, 30, 30, 0},
	{0x2e, 0, 2, 0},
	{0x2e, 4, 4, 0},
	{0x2e, 8, 11, 0},
	{0x2e, 12, 15, 0},
	{0x2e, 16, 17, 0},
	{0x2e, 18, 19, 0},
	{0x2e, 20, 21, 0},
	{0x2e, 22, 23, 0},
	{0x2e, 24, 25, 0},
	{0x2e, 26, 27, 0},
	{0x2e, 28, 28, 0},
	{0x2f, 0, 7, 0},
	{0x2f, 8, 15, 0},
	{0x2f, 16, 23, 0},
	{0x2f, 24, 31, 0},
	{0x30, 0, 7, 0},
	{0x30, 8, 15, 0},
	{0x30, 16, 23, 0},
	{0x30, 24, 31, 0},
	{0x31, 0, 7, 0},
	{0x31, 8, 15, 0},
	{0x31, 16, 23, 0},
	{0x31, 24, 25, 0},
	{0x31, 26, 28, 0},
	{0x31, 29, 31, 0},
	{0x32, 0, 7, 0},
	{0x32, 8, 15, 0},
	{0x32, 16, 23, 0},
	{0x32, 24, 31, 0},
	{0x33, 0, 7, 0},
	{0x34, 0, 2, 0},
	{0x34, 4, 4, 0},
	{0x34, 8, 11, 0},
	{0x34, 12, 15, 0},
	{0x34, 16, 17, 0},
	{0x34, 18, 19, 0},
	{0x34, 20, 21, 0},
	{0x34, 22, 23, 0},
	{0x34, 24, 25, 0},
	{0x34, 26, 27, 0},
	{0x34, 28, 28, 0},
	{0x35, 0, 7, 0},
	{0x35, 8, 15, 0},
	{0x35, 16, 23, 0},
	{0x35, 24, 28, 0},
	{0x36, 0, 7, 0},
	{0x36, 8, 15, 0},
	{0x36, 16, 23, 0},
	{0x36, 24, 31, 0},
	{0x37, 0, 7, 0},
	{0x37, 8, 15, 0},
	{0x37, 16, 23, 0},
	{0x37, 24, 25, 0},
	{0x37, 26, 28, 0},
	{0x37, 29, 31, 0},
	{0x38, 0, 7, 0},
	{0x38, 8, 15, 0},
	{0x38, 16, 23, 0},
	{0x38, 24, 31, 0},
	{0x39, 0, 7, 0},
	{0x3a, 0, 0, 0},
	{0x3a, 2, 2, 0},
	{0x3a, 4, 5, 0},
	{0x3a, 6, 7, 0},
	{0x3a, 8, 9, 0},
	{0x3a, 10, 11, 0},
	{0x3a, 12, 13, 0},
	{0x3a, 14, 14, 0},
	{0x3b, 0, 7, 0},
	{0x3b, 8, 15, 0},
	{0x3b, 16, 23, 0},
	{0x3c, 0, 7, 0},
	{0x3c, 8, 15, 0},
	{0x3c, 16, 23, 0},
	{0x3d, 0, 7, 0},
	{0x3d, 8, 15, 0},
	{0x3d, 16, 23, 0},
	{0x3d, 24, 31, 0},
	{0x3e, 0, 7, 0},
	{0x3e, 8, 15, 0},
	{0x3e, 16, 23, 0},
	{0x3e, 24, 31, 0},
	{0x3f, 0, 0, 0},
	{0x3f, 2, 2, 0},
	{0x3f, 4, 5, 0},
	{0x3f, 6, 7, 0},
	{0x3f, 8, 9, 0},
	{0x3f, 10, 11, 0},
	{0x3f, 12, 13, 0},
	{0x3f, 14, 14, 0},
	{0x40, 0, 7, 0},
	{0x40, 8, 15, 0},
	{0x40, 16, 23, 0},
	{0x41, 0, 7, 0},
	{0x41, 8, 15, 0},
	{0x41, 16, 23, 0},
	{0x42, 0, 7, 0},
	{0x42, 8, 15, 0},
	{0x42, 16, 23, 0},
	{0x42, 24, 31, 0},
	{0x43, 0, 7, 0},
	{0x43, 8, 15, 0},
	{0x43, 16, 23, 0},
	{0x43, 24, 31, 0},
	{0x44, 0, 12, 0},
	{0x44, 16, 28, 0},
	{0x58, 0, 7, 0},
	{0x58, 8, 15, 0},
	{0x58, 16, 23, 0},
	{0x58, 24, 31, 0},
	{0x59, 0, 7, 0},
	{0x59, 8, 15, 0},
	{0x59, 16, 23, 0},
	{0x59, 24, 31, 0},
	{0x5a, 0, 7, 0},
	{0x5a, 8, 15, 0},
	{0x5a, 16, 23, 0},
	{0x5a, 24, 31, 0},
	{0x5b, 0, 7, 0},
	{0x5b, 8, 15, 0},
	{0x5b, 16, 23, 0},
	{0x5b, 24, 31, 0},
	{0x5c, 0, 7, 0},
	{0x5c, 8, 15, 0},
	{0x5c, 16, 23, 0},
	{0x5c, 24, 31, 0},
	{0x5d, 0, 7, 0},
	{0x5d, 8, 15, 0},
	{0x5d, 16, 23, 0},
	{0x5d, 24, 31, 0},
	{0x5e, 0, 7, 0},
	{0x5e, 8, 15, 0},
	{0x5e, 16, 23, 0},
	{0x5e, 24, 31, 0},
	{0x5f, 0, 7, 0},
	{0x5f, 8, 15, 0},
	{0x5f, 16, 23, 0},
	{0x5f, 24, 31, 0},
	{0x60, 0, 0, 0},
	{0x60, 1, 1, 0},
	{0x61, 0, 0, 0},
	{0x61, 1, 1, 0},
	{0x61, 2, 2, 0},
	{0x61, 3, 3, 0},
	{0x61, 4, 4, 0},
	{0x61, 5, 5, 0},
	{0x61, 6, 6, 0},
	{0x61, 7, 7, 0},
	{0x61, 8, 13, 0},
	{0x61, 16, 21, 0},
	{0x61, 24, 29, 0},
	{0x62, 0, 0, 0},
	{0x62, 2, 3, 0},
	{0x62, 4, 5, 0},
	{0x62, 6, 7, 0},
	{0x62, 8, 8, 0},
	{0x62, 9, 9, 0},
	{0x62, 10, 10, 0},
	{0x62, 11, 11, 0},
	{0x63, 0, 5, 0},
	{0x63, 6, 6, 0},
	{0x63, 7, 7, 0},
	{0x63, 8, 15, 0},
	{0x63, 16, 23, 0},
	{0x63, 24, 26, 0},
	{0x63, 28, 30, 0},
	{0x64, 0, 0, 0},
	{0x64, 1, 1, 0},
	{0x64, 2, 3, 0},
	{0x65, 0, 3, 0},
	{0x65, 4, 7, 0},
	{0x65, 8, 11, 0},
	{0x65, 12, 15, 0},
	{0x65, 16, 19, 0},
	{0x65, 20, 23, 0},
	{0x65, 24, 27, 0},
	{0x65, 28, 31, 0},
	{0x66, 0, 2, 0},
	{0x66, 3, 3, 0},
	{0x66, 4, 6, 0},
	{0x66, 8, 14, 0},
	{0x67, 0, 3, 0},
	{0x67, 8, 11, 0},
	{0x67, 16, 19, 0},
	{0x67, 24, 27, 0},
	{0x68, 0, 3, 0},
	{0x68, 8, 11, 0},
	{0x68, 16, 19, 0},
	{0x68, 24, 27, 0},
	{0x69, 0, 3, 0},
	{0x69, 8, 11, 0},
	{0x69, 16, 19, 0},
	{0x69, 24, 27, 0},
	{0x6a, 0, 3, 0},
	{0x6a, 4, 7, 0},
	{0x6a, 8, 11, 0},
	{0x6a, 12, 15, 0},
	{0x6a, 16, 19, 0},
	{0x6a, 20, 23, 0},
	{0x6a, 24, 27, 0},
	{0x6a, 28, 31, 0},
	{0x6b, 0, 7, 0},
	{0x6b, 8, 15, 0},
	{0x6b, 16, 17, 0},
	{0x6b, 20, 23, 0},
	{0x6b, 24, 26, 0},
	{0x6b, 28, 30, 0},
	{0x6c, 0, 7, 0},
	{0x6c, 8, 15, 0},
	{0x6c, 16, 23, 0},
	{0x6c, 24, 31, 0},
	{0x6d, 0, 7, 0},
	{0x6d, 8, 15, 0},
	{0x6d, 16, 23, 0},
	{0x6e, 0, 7, 0},
	{0x6e, 8, 15, 0},
	{0x6e, 16, 23, 0},
	{0x6e, 24, 31, 0},
	{0x6f, 0, 7, 0},
	{0x6f, 8, 15, 0},
	{0x6f, 16, 23, 0},
	{0x70, 0, 3, 0},
	{0x70, 4, 7, 0},
	{0x70, 8, 11, 0},
	{0x70, 12, 15, 0},
	{0x70, 16, 19, 0},
	{0x70, 20, 23, 0},
	{0x70, 24, 27, 0},
	{0x70, 28, 31, 0},
	{0x71, 0, 3, 0},
	{0x71, 4, 7, 0},
	{0x71, 8, 11, 0},
	{0x71, 12, 15, 0},
	{0x71, 16, 19, 0},
	{0x71, 20, 23, 0},
	{0x71, 24, 27, 0},
	{0x71, 28, 31, 0},
	{0x72, 0, 5, 0},
	{0x72, 8, 15, 0},
	{0x72, 16, 23, 0},
	{0x73, 0, 15, 0},
	{0x73, 16, 31, 0},
	{0x74, 0, 0, 0},
	{0x74, 1, 1, 0},
	{0x74, 2, 3, 0},
	{0x74, 8, 15, 0},
	{0x74, 16, 23, 0},
	{0x75, 0, 7, 0},
	{0x75, 8, 15, 0},
	{0x75, 16, 23, 0},
	{0x77, 0, 1, 0},
	{0x77, 2, 3, 0},
	{0x77, 4, 4, 0},
	{0x77, 5, 5, 0},
	{0x77, 6, 6, 0},
	{0x77, 7, 7, 0},
	{0x77, 9, 11, 0},
	{0x77, 13, 15, 0},
	{0x77, 17, 19, 0},
	{0x77, 20, 20, 0},
	{0x77, 21, 21, 0},
	{0x77, 22, 22, 0},
	{0x77, 23, 23, 0},
	{0x77, 24, 24, 0},
	{0x77, 25, 25, 0},
	{0x77, 26, 26, 0},
	{0x79, 0, 2, 0},
	{0x79, 3, 5, 0},
	{0x79, 6, 8, 0},
	{0x79, 9, 11, 0},
	{0x79, 12, 14, 0},
	{0x79, 15, 17, 0},
	{0x79, 18, 20, 0},
	{0x79, 21, 23, 0},
	{0x7a, 0, 9, 0},
	{0x7a, 16, 25, 0},
	{0x7b, 0, 15, 0},
	{0x7b, 16, 31, 0},
	{0x7c, 0, 15, 0},
	{0x7c, 16, 31, 0},
	{0x7d, 0, 15, 0},
	{0x7d, 16, 31, 0},
	{0x7e, 0, 3, 0},
	{0x7e, 4, 7, 0},
	{0x7e, 8, 11, 0},
	{0x7e, 12, 15, 0},
	{0x7e, 16, 19, 0},
	{0x7e, 20, 23, 0},
	{0x7e, 24, 27, 0},
	{0x7e, 28, 31, 0},
	{0x7f, 0, 3, 0},
	{0x80, 0, 3, 0},
	{0x80, 4, 7, 0},
	{0x80, 8, 11, 0},
	{0x80, 12, 15, 0},
	{0x80, 16, 19, 0},
	{0x80, 20, 23, 0},
	{0x80, 24, 27, 0},
	{0x80, 28, 31, 0},
	{0x81, 0, 3, 0},
};

/*Internal functions*/
static void _update_data_page_reg(struct vpp_pq_tuning_page_s *pdata)
{
	int i, j;
	int reg_count = 0;
	unsigned char start = 0;
	unsigned char len = 0;
	unsigned int tmp = 0;
	struct vpp_pq_tuning_reg_s *preg_list;
	struct vpp_pq_tuning_reg_s *pcur_reg;
	struct vpp_pq_page_s *pcur_page;

	if (!pdata)
		return;

	if (!pdata->preg_list || pdata->reg_count == 0)
		return;

	preg_list = kcalloc(pdata->reg_count,
		sizeof(struct vpp_pq_tuning_reg_s), GFP_KERNEL);

	if (!preg_list)
		return;

	memcpy(preg_list, pdata->preg_list,
		sizeof(struct vpp_pq_tuning_reg_s) * pdata->reg_count);

	for (i = 0; i < EN_PAGE_MODULE_MAX; i++) {
		if (pq_table[i].page_addr == pdata->page_addr) {
			pcur_page = &pq_table[i].page[0];
			reg_count = pq_table[i].count;
			break;
		}
	}

	for (i = 0; i < pdata->reg_count; i++) {
		pcur_reg = preg_list + i;
		for (j = 0; j < reg_count; j++) {
			if (pcur_page->reg[j].addr == pcur_reg->reg_addr) {
				start = pcur_reg->bit_start;
				len = pcur_reg->bit_end - pcur_reg->bit_start + 1;
				tmp = pcur_page->reg[j].val;
				tmp = vpp_insert_int(tmp, pcur_reg->val, start, len);
				pcur_page->reg[j].val = tmp;
				pcur_page->reg[j].update = 1;
				break;
			}
		}
	}

	kfree(preg_list);
}

static void _write_data_table(enum vpp_page_module_e module,
	int index)
{
	int i = 0;
	int val = 0;
	int tmp = 0;
	int mask_index = 0;
	unsigned int addr = 0;

	if (module > EN_PAGE_MODULE_MAX - 1 ||
		index > PAGE_TBL_COUNT_MAX - 1)
		return;

	for (i = 0; i < pq_table[module].count; i++) {
		if (!pq_table[module].page[index].reg[i].update)
			continue;

		val = pq_table[module].page[index].reg[i].val;
		mask_index = pq_table[module].page[index].reg[i].mask_type;
		val &= mask_list[mask_index];
		addr = ADDR_PARAM(pq_table[module].page_addr,
			pq_table[module].page[index].reg[i].addr);

		tmp = READ_VPP_REG_BY_MODE(EN_MODE_DIR, addr);
		val |= tmp & (~mask_list[mask_index]);
		WRITE_VPP_REG_BY_MODE(EN_MODE_RDMA, addr, val);

		pq_table[module].page[index].reg[i].update = 0;
	}
}

/*External functions*/
int vpp_data_init(struct vpp_dev_s *pdev)
{
	enum vpp_chip_type_e chip_id;

	chip_id = pdev->pm_data->chip_id;

	memset(&cur_vs_param, 0, sizeof(cur_vs_param));

	return 0;
}

void vpp_data_update_data_table_reg(struct vpp_pq_tuning_table_s *pdata)
{
	int i;
	struct vpp_pq_tuning_page_s *ppage_list;

	if (!pdata)
		return;

	if (!pdata->ppage_list || pdata->page_count == 0)
		return;

	ppage_list = kcalloc(pdata->page_count,
		sizeof(struct vpp_pq_tuning_page_s), GFP_KERNEL);

	if (!ppage_list)
		return;

	memcpy(ppage_list, pdata->ppage_list,
		sizeof(struct vpp_pq_tuning_page_s) * pdata->page_count);

	for (i = 0; i < pdata->page_count; i++)
		_update_data_page_reg(ppage_list + i);

	kfree(ppage_list);
}

void vpp_data_updata_reg_lc(struct vpp_lc_param_s *pdata)
{
	int i;
	struct vpp_pq_tuning_page_s page;

	if (!pdata)
		return;

	for (i = 0; i < EN_LC_PARAM_MAX; i++)
		lc_param[i].val = pdata->param[i];

	page.page_addr = pq_table[EN_PAGE_MODULE_LC].page_addr;
	page.reg_count = EN_LC_PARAM_MAX;
	page.page_idx = 0;
	page.preg_list = &lc_param[0];

	_update_data_page_reg(&page);
}

void vpp_data_updata_reg_sharpness0(struct vpp_sharpness0_param_s *pdata)
{
	int i;
	struct vpp_pq_tuning_page_s page;

	if (!pdata)
		return;

	for (i = 0; i < EN_SHARPNESS0_PARAM_MAX; i++)
		sharpness0_param[i].val = pdata->param[i];

	page.page_addr = pq_table[EN_PAGE_MODULE_SR_0].page_addr;
	page.reg_count = EN_SHARPNESS0_PARAM_MAX;
	page.page_idx = 0;
	page.preg_list = &sharpness0_param[0];

	_update_data_page_reg(&page);
}

void vpp_data_updata_reg_sharpness1(struct vpp_sharpness1_param_s *pdata)
{
	int i;
	struct vpp_pq_tuning_page_s page;

	if (!pdata)
		return;

	for (i = 0; i < EN_SHARPNESS1_PARAM_MAX; i++)
		sharpness1_param[i].val = pdata->param[i];

	page.page_addr = pq_table[EN_PAGE_MODULE_SR_1].page_addr;
	page.reg_count = EN_SHARPNESS1_PARAM_MAX;
	page.page_idx = 0;
	page.preg_list = &sharpness1_param[0];

	_update_data_page_reg(&page);
}

void vpp_data_on_vs(struct data_vs_param_s *pvs_param)
{
	int i;

	if (!pvs_param)
		return;

	memcpy(&cur_vs_param, pvs_param, sizeof(cur_vs_param));

	for (i = 0; i < EN_PAGE_MODULE_MAX; i++)
		_write_data_table(i, 0);
}

