function testSyntax(script) {
    try {
        eval(script);
    } catch (error) {
        if (error instanceof SyntaxError)
            throw new Error("Bad error: " + String(error));
    }
}

function testSyntaxError(script, message) {
    var error = null;
    try {
        eval(script);
    } catch (e) {
        error = e;
    }
    if (!error)
        throw new Error("Expected syntax error not thrown");

    if (String(error) !== message)
        throw new Error("Bad error: " + String(error));
}

testSyntax(`
if (false)
    async
function t() { }
`);

testSyntaxError(`
if (false)
    async function t() { }
`, `SyntaxError: Unexpected keyword 'function'. Cannot use async function declaration in single-statement context.`);
