/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifndef _GE2D_REG_H_
#define _GE2D_REG_H_

/* dma cmd queue regs */
#define GE2D_AXI2DMA_CTRL0   0x81
#define GE2D_AXI2DMA_CTRL1   0x82
#define GE2D_AXI2DMA_CTRL2   0x83
#define GE2D_AXI2DMA_CTRL3   0x84
#define GE2D_AXI2DMA_CTRL4   0x85
#define GE2D_AXI2DMA_STATUS  0x86

/* ge2d setting regs */
#define GE2D_REG_START          0x90 /* reg start addr */
#define GE2D_MATRIX2_PRE_OFFSET 0x90
#define GE2D_MATRIX2_COEF00_01 0x91
#define GE2D_MATRIX2_COEF02_10 0x92
#define GE2D_MATRIX2_COEF11_12 0x93
#define GE2D_MATRIX2_COEF20_21 0x94
#define GE2D_MATRIX2_COEF22_CTRL 0x95
#define GE2D_MATRIX2_OFFSET 0x96
#define GE2D_MATRIX3_PRE_OFFSET 0x97
#define GE2D_MATRIX3_COEF00_01 0x98
#define GE2D_MATRIX3_COEF02_10 0x99
#define GE2D_MATRIX3_COEF11_12 0x9a
#define GE2D_MATRIX3_COEF20_21 0x9b
#define GE2D_MATRIX3_COEF22_CTRL 0x9c
#define GE2D_MATRIX3_OFFSET 0x9d
#define GE2D_GEN_CTRL0 0xa0
#define GE2D_GEN_CTRL1 0xa1
#define GE2D_GEN_CTRL2 0xa2
#define GE2D_CMD_CTRL 0xa3
#define GE2D_STATUS0 0xa4
#define GE2D_STATUS1 0xa5
#define GE2D_SRC1_DEF_COLOR 0xa6
#define GE2D_SRC1_CLIPX_START_END 0xa7
#define GE2D_SRC1_CLIPY_START_END 0xa8
#define GE2D_SRC1_CANVAS 0xa9
#define GE2D_SRC1_X_START_END 0xaa
#define GE2D_SRC1_Y_START_END 0xab
#define GE2D_SRC1_LUT_ADDR 0xac
#define GE2D_SRC1_LUT_DAT 0xad
#define GE2D_SRC1_FMT_CTRL 0xae
#define GE2D_SRC2_DEF_COLOR 0xaf
#define GE2D_SRC2_CLIPX_START_END 0xb0
#define GE2D_SRC2_CLIPY_START_END 0xb1
#define GE2D_SRC2_X_START_END 0xb2
#define GE2D_SRC2_Y_START_END 0xb3
#define GE2D_DST_CLIPX_START_END 0xb4
#define GE2D_DST_CLIPY_START_END 0xb5
#define GE2D_DST_X_START_END 0xb6
#define GE2D_DST_Y_START_END 0xb7
#define GE2D_SRC2_DST_CANVAS 0xb8
#define GE2D_VSC_START_PHASE_STEP 0xb9
#define GE2D_VSC_PHASE_SLOPE 0xba
#define GE2D_VSC_INI_CTRL 0xbb
#define GE2D_HSC_START_PHASE_STEP 0xbc
#define GE2D_HSC_PHASE_SLOPE 0xbd
#define GE2D_HSC_INI_CTRL 0xbe
#define GE2D_HSC_ADV_CTRL 0xbf
#define GE2D_SC_MISC_CTRL 0xc0
#define GE2D_VSC_NRND_POINT 0xc1
#define GE2D_VSC_NRND_PHASE 0xc2
#define GE2D_HSC_NRND_POINT 0xc3
#define GE2D_HSC_NRND_PHASE 0xc4
#define GE2D_MATRIX_PRE_OFFSET 0xc5
#define GE2D_MATRIX_COEF00_01 0xc6
#define GE2D_MATRIX_COEF02_10 0xc7
#define GE2D_MATRIX_COEF11_12 0xc8
#define GE2D_MATRIX_COEF20_21 0xc9
#define GE2D_MATRIX_COEF22_CTRL 0xca
#define GE2D_MATRIX_OFFSET 0xcb
#define GE2D_ALU_OP_CTRL 0xcc
#define GE2D_ALU_CONST_COLOR 0xcd
#define GE2D_SRC1_KEY 0xce
#define GE2D_SRC1_KEY_MASK 0xcf
#define GE2D_SRC2_KEY 0xd0
#define GE2D_SRC2_KEY_MASK 0xd1
#define GE2D_DST_BITMASK 0xd2
#define GE2D_DP_ONOFF_CTRL 0xd3
#define GE2D_SCALE_COEF_IDX 0xd4
#define GE2D_SCALE_COEF 0xd5
#define GE2D_SRC_OUTSIDE_ALPHA 0xd6
#define GE2D_ANTIFLICK_CTRL0 0xd8
#define GE2D_ANTIFLICK_CTRL1 0xd9
#define GE2D_ANTIFLICK_COLOR_FILT0 0xda
#define GE2D_ANTIFLICK_COLOR_FILT1 0xdb
#define GE2D_ANTIFLICK_COLOR_FILT2 0xdc
#define GE2D_ANTIFLICK_COLOR_FILT3 0xdd
#define GE2D_ANTIFLICK_ALPHA_FILT0 0xde
#define GE2D_ANTIFLICK_ALPHA_FILT1 0xdf
#define GE2D_ANTIFLICK_ALPHA_FILT2 0xe0
#define GE2D_ANTIFLICK_ALPHA_FILT3 0xe1
#define GE2D_SRC1_RANGE_MAP_Y_CTRL 0xe3
#define GE2D_SRC1_RANGE_MAP_CB_CTRL 0xe4
#define GE2D_SRC1_RANGE_MAP_CR_CTRL 0xe5
#define GE2D_ARB_BURST_NUM 0xe6
#define GE2D_TID_TOKEN 0xe7
#define GE2D_GEN_CTRL3 0xe8
#define GE2D_STATUS2 0xe9
#define GE2D_GEN_CTRL4 0xea
#define GE2D_DST1_BADDR_CTRL  0xf1
#define GE2D_DST1_STRIDE_CTRL 0xf2
#define GE2D_SRC1_BADDR_CTRL  0xf3
#define GE2D_SRC1_STRIDE_CTRL 0xf4
#define GE2D_SRC2_BADDR_CTRL  0xf5
#define GE2D_SRC2_STRIDE_CTRL 0xf6
#define GE2D_GEN_CTRL5  0xf1

#define GE2D_C1_DST1_BADDR_CTRL  0xf2
#define GE2D_C1_DST1_STRIDE_CTRL 0xf3
#define GE2D_C1_DST2_BADDR_CTRL  0xf4
#define GE2D_C1_DST2_STRIDE_CTRL 0xf5
#define GE2D_C1_SRC1_BADDR_CTRL_Y  0xf6
#define GE2D_C1_SRC1_STRIDE_CTRL_Y 0xf7
#define GE2D_C1_SRC1_BADDR_CTRL_CB  0xf8
#define GE2D_C1_SRC1_STRIDE_CTRL_CB 0xf9
#define GE2D_C1_SRC1_BADDR_CTRL_CR  0xfa
#define GE2D_C1_SRC1_STRIDE_CTRL_CR 0xfb
#define GE2D_C1_SRC2_BADDR_CTRL  0xfc
#define GE2D_C1_SRC2_STRIDE_CTRL 0xfd

#define GE2D_REG_END             0xfd /* reg end addr */

/* for HW cmd queue mode, this must be an even number */
#define GE2D_REG_CNT             (GE2D_REG_END - GE2D_REG_START + 1)

#define GE2D_REG_CMD_STEP        8   /* bytes*/
#define ONE_CMD_BUF_SIZE         (GE2D_REG_CNT * GE2D_REG_CMD_STEP) /* bytes */

#define GE2D_VOID_REG            0xee /* unused reg */

#define VIU_OSD1_BLK0_CFG_W0 0x1a1b

enum meson_chip_e {
	MESON_CPU_MAJOR_ID_M8B = 0x1B,
	MESON_CPU_MAJOR_ID_GXBB = 0x1F,
	MESON_CPU_MAJOR_ID_GXTVBB = 0x20,
	MESON_CPU_MAJOR_ID_GXL = 0x21,
	MESON_CPU_MAJOR_ID_GXM = 0x22,
	MESON_CPU_MAJOR_ID_TXL = 0x23,
	MESON_CPU_MAJOR_ID_TXLX = 0x24,
	MESON_CPU_MAJOR_ID_AXG = 0x25,
	MESON_CPU_MAJOR_ID_GXLX = 0x26,
	MESON_CPU_MAJOR_ID_TXHD = 0x27,
	MESON_CPU_MAJOR_ID_G12A = 0x28,
	MESON_CPU_MAJOR_ID_G12B = 0x29,
	MESON_CPU_MAJOR_ID_GXLX2 = 0x2a,
	MESON_CPU_MAJOR_ID_SM1 = 0x2B,
	MESON_CPU_MAJOR_ID_TL1 = 0x2E,
	MESON_CPU_MAJOR_ID_TM2,
	MESON_CPU_MAJOR_ID_C1,
	MESON_CPU_MAJOR_ID_C2,
	MESON_CPU_MAJOR_ID_SC2,
	MESON_CPU_MAJOR_ID_T5,
	MESON_CPU_MAJOR_ID_T7,
	MESON_CPU_MAJOR_ID_T3,
	MESON_CPU_MAJOR_ID_S4,
	MESON_CPU_MAJOR_ID_P1,
	MESON_CPU_MAJOR_ID_T5W,
	MESON_CPU_MAJOR_ID_S5,
};
#endif
