/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2021 Amlogic, Inc. All rights reserved.
 */
/***************************************************************************
 *    Copyright (c) 2017, Broadcom Ltd.
 *    All rights reserved.
 *    VESA CONFIDENTIAL
 *
 *  Statement regarding contribution of copyrighted materials to VESA:
 *
 *  This code is owned by Broadcom Limited and is contributed to VESA
 *  for inclusion and use in its VESA Display Stream Compression specification.
 *  Accordingly, VESA is hereby granted a worldwide, perpetual, non-exclusive
 *  license to revise, modify and create derivative works to this code and
 *  VESA shall own all right, title and interest in and to any derivative
 *  works authored by VESA.
 *
 *  Terms and Conditions
 *
 *  Without limiting the foregoing, you agree that your use
 *  of this software program does not convey any rights to you in any of
 *  Broadcom patent and other intellectual property, and you
 *  acknowledge that your use of this software may require that
 *  you separately obtain patent or other intellectual property
 *  rights from Broadcom or third parties.
 *
 *  Except as expressly set forth in a separate written license agreement
 *  between you and Broadcom, if applicable:
 *
 *  1. TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED
 *  "AS IS" AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES,
 *  REPRESENTATIONS OR WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR
 *  OTHERWISE, WITH RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY
 *  DISCLAIMS ANY AND ALL IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY,
 *  NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES,
 *  ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR
 *  CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING
 *  OUT OF USE OR PERFORMANCE OF THE SOFTWARE.
 *
 *  2. TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL
 *  BROADCOM OR ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL,
 *  SPECIAL, INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR
 *  IN ANY WAY RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN
 *  IF BROADCOM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES; OR (ii)
 *  ANY AMOUNT IN EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE SOFTWARE ITSELF
 *  OR U.S. $1, WHICHEVER IS GREATER. THESE LIMITATIONS SHALL APPLY
 *  NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF ANY LIMITED REMEDY.
 ***************************************************************************/

#include <linux/kernel.h>
#include <linux/slab.h>
#include "dsc_debug.h"

#define QP_VALUE_MAX_LEN	4

char *min_qp444_8b[] = {
	"0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"3	2	2	2	1	1	1	1	1	1	1	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"3	3	2	2	1	1	1	1	1	1	1	1	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"5	4	4	3	3	3	3	3	3	3	3	3	3	3	2	1	1	1	1	1	1	1	1	1	1	1	1	1	0	0	0	0	0	0	0	0	0",
	"5	4	4	4	3	3	3	3	3	3	3	3	3	3	3	2	1	1	1	1	1	1	1	1	1	1	1	1	1	1	0	0	0	0	0	0	0",
	"5	5	4	4	3	3	3	3	3	3	3	3	3	3	3	2	2	2	1	1	1	1	1	1	1	1	1	1	1	1	0	0	0	0	0	0	0",
	"5	5	4	4	3	3	3	3	3	3	3	3	3	3	3	2	2	2	2	2	2	2	2	2	2	2	1	1	1	1	1	1	0	0	0	0	0",
	"5	5	4	4	3	3	3	3	3	3	3	3	3	3	3	2	2	2	2	2	2	2	2	2	2	2	2	2	1	1	1	1	1	1	0	0	0",
	"6	5	5	4	4	4	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	2	2	1	1	1	1	1	1	0	0	0",
	"6	6	5	5	5	5	5	5	5	5	5	5	5	4	4	4	4	4	4	4	4	4	3	3	3	3	2	2	1	1	1	1	1	1	1	1	0",
	"6	6	6	5	5	5	5	5	5	5	5	5	5	5	5	5	5	4	4	4	4	4	4	4	4	4	3	3	2	2	2	2	1	1	1	1	0",
	"6	6	6	6	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	4	4	4	4	3	3	2	2	2	2	1	1	1	1	0",
	"9	9	9	9	8	8	7	7	7	7	7	7	7	7	7	7	7	7	7	7	6	6	5	5	5	5	4	4	3	3	3	3	2	2	1	1	1",
	"14	14	13	13	12	12	12	12	11	11	10	10	10	10	9	9	9	8	8	8	7	7	7	7	6	6	5	5	5	5	4	4	4	3	3	3	3"
};

char *max_qp444_8b[] = {
	"4	4	4	4	4	4	3	3	3	3	2	2	2	2	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"6	6	5	5	4	4	4	4	4	4	4	4	3	3	3	2	2	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	0	0	0	0	0",
	"8	7	7	6	5	5	5	5	5	5	5	5	4	4	4	3	2	2	1	1	1	1	1	1	1	1	1	1	1	1	1	1	0	0	0	0	0",
	"8	8	7	7	6	6	6	6	6	6	6	6	5	5	5	4	3	3	2	2	2	2	2	2	2	2	1	1	1	1	1	1	1	1	1	1	0",
	"9	8	8	7	7	7	7	7	7	7	7	7	6	6	5	4	4	3	2	2	2	2	2	2	2	2	2	2	1	1	1	1	1	1	1	1	0",
	"9	8	8	8	7	7	7	7	7	7	7	7	6	6	6	5	4	4	3	3	3	3	3	3	3	3	2	2	2	2	1	1	1	1	1	1	1",
	"9	9	8	8	7	7	7	7	7	7	7	7	7	6	6	5	4	4	3	3	3	3	3	3	3	3	2	2	2	2	1	1	1	1	1	1	1",
	"10	10	9	9	8	8	8	8	8	8	8	8	8	7	7	6	5	5	4	4	4	4	3	3	3	3	2	2	2	2	2	2	1	1	1	1	1",
	"11	11	10	10	9	9	9	9	9	9	8	8	8	7	7	6	6	5	5	5	5	5	4	4	4	4	3	3	2	2	2	2	2	2	1	1	1",
	"12	11	11	10	10	10	9	9	9	9	9	9	9	8	8	7	6	6	5	5	5	5	4	4	4	4	3	3	2	2	2	2	2	2	1	1	1",
	"12	12	11	11	10	10	10	10	10	10	9	9	9	8	8	7	7	6	6	6	5	5	4	4	4	4	3	3	2	2	2	2	2	2	2	2	1",
	"12	12	12	11	11	11	10	10	10	10	9	9	9	9	8	8	8	7	7	7	6	6	5	5	5	5	4	4	3	3	3	3	2	2	2	2	1",
	"12	12	12	12	11	11	11	11	11	10	10	9	9	9	8	8	8	7	7	7	6	6	5	5	5	5	4	4	3	3	3	3	2	2	2	2	1",
	"13	13	13	13	12	12	11	11	11	11	10	10	10	10	9	9	8	8	8	8	7	7	6	6	6	6	5	5	4	4	4	4	3	3	2	2	2",
	"15	15	14	14	13	13	13	13	12	12	11	11	11	11	10	10	10	9	9	9	8	8	8	8	7	7	6	6	6	6	5	5	5	4	4	4	4"
};

char *min_qp444_10b[] = {
	"0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"4	4	4	4	4	4	4	4	4	4	3	3	2	2	2	2	2	2	2	2	2	1	1	1	1	1	1	1	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"7	6	6	6	5	5	5	5	5	5	5	5	4	4	4	3	3	3	3	3	3	2	2	2	2	2	1	1	1	1	1	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"7	7	6	6	5	5	5	5	5	5	5	5	4	4	4	4	4	4	4	4	4	3	3	3	3	3	2	2	2	2	2	2	2	2	2	2	1	1	0	0	0	0	0	0	0	0	0	0	0",
	"9	8	8	7	7	7	7	7	7	7	7	7	6	6	5	5	5	5	4	4	4	4	3	3	3	3	3	3	2	2	2	2	2	2	2	2	1	1	1	1	0	0	0	0	0	0	0	0	0",
	"9	8	8	8	7	7	7	7	7	7	7	7	6	6	6	6	5	5	5	5	5	5	4	4	4	4	3	3	3	3	3	2	2	2	2	2	2	2	2	2	1	1	1	0	0	0	0	0	0",
	"9	9	8	8	7	7	7	7	7	7	7	7	7	7	7	6	6	6	5	5	5	5	5	4	4	4	3	3	3	3	3	3	3	3	3	3	3	2	2	2	1	1	1	1	0	0	0	0	0",
	"9	9	8	8	7	7	7	7	7	7	7	7	7	7	7	7	6	6	6	6	6	6	5	5	5	5	4	4	4	4	4	4	3	3	3	3	3	3	2	2	2	2	1	1	1	0	0	0	0",
	"9	9	8	8	7	7	7	7	7	7	7	7	7	7	7	7	7	6	6	6	6	6	5	5	5	5	5	5	5	4	4	4	4	4	3	3	3	3	3	3	2	2	2	1	1	1	1	0	0",
	"10	9	9	8	8	8	7	7	7	7	7	7	7	7	7	7	7	7	6	6	6	6	6	6	6	6	6	6	5	5	4	4	4	4	3	3	3	3	3	3	3	2	2	2	1	1	1	1	0",
	"10	10	9	9	9	9	9	9	9	9	9	9	9	8	8	8	8	7	7	7	7	7	6	6	6	6	6	6	5	5	5	5	5	5	5	5	4	4	4	3	3	3	2	2	2	1	1	1	1",
	"10	10	10	9	9	9	9	9	9	9	9	9	9	9	9	9	9	8	8	8	8	8	7	7	7	7	7	7	6	6	6	6	5	5	5	5	4	4	4	4	3	3	3	3	2	2	1	1	1",
	"10	10	10	10	9	9	9	9	9	9	9	9	9	9	9	9	9	9	9	9	8	8	8	8	8	8	7	7	6	6	6	6	5	5	5	5	4	4	4	4	3	3	3	3	2	2	2	2	1",
	"12	12	12	12	12	12	12	12	12	12	11	11	11	11	11	11	11	11	11	11	10	10	9	9	9	9	8	8	7	7	7	7	6	6	5	5	5	5	4	4	3	3	3	3	2	2	2	2	1",
	"18	18	17	17	16	16	16	16	15	15	14	14	14	14	13	13	13	12	12	12	11	11	11	11	10	10	9	9	9	9	9	8	8	7	7	7	7	7	6	6	5	5	5	5	4	4	3	3	3"
};

char *max_qp444_10b[] = {
	"8	8	8	8	8	8	7	7	7	6	5	5	4	4	3	3	3	2	2	2	2	2	2	1	1	1	1	1	1	1	1	1	1	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0",
	"10	10	9	9	8	8	8	8	8	8	7	7	6	6	6	5	5	4	4	4	4	3	3	3	3	3	2	2	2	2	2	2	1	1	1	1	1	1	1	0	0	0	0	0	0	0	0	0	0",
	"12	11	11	10	9	9	9	9	9	9	9	9	8	8	8	7	6	6	5	5	5	4	4	4	4	4	3	3	3	3	3	3	2	2	2	1	1	1	1	1	1	0	0	0	0	0	0	0	0",
	"12	12	11	11	10	10	10	10	10	10	10	10	9	9	9	8	7	7	6	6	6	5	5	5	5	5	4	4	3	3	3	3	3	3	3	3	2	2	1	1	1	1	1	0	0	0	0	0	0",
	"13	12	12	11	11	11	11	11	11	11	11	11	10	10	9	8	8	7	6	6	6	6	5	5	5	5	5	5	4	4	4	3	3	3	3	3	2	2	2	2	1	1	1	1	0	0	0	0	0",
	"13	12	12	12	11	11	11	11	11	11	11	11	10	10	10	9	8	8	7	7	7	7	6	6	6	6	5	5	5	5	4	3	3	3	3	3	3	3	3	3	2	2	2	1	1	1	1	0	0",
	"13	13	12	12	11	11	11	11	11	11	11	11	11	10	10	9	8	8	7	7	7	7	7	6	6	6	5	5	5	5	4	4	4	4	4	4	4	3	3	3	2	2	2	2	1	1	1	1	1",
	"14	14	13	13	12	12	12	12	12	12	12	12	12	11	11	10	9	9	8	8	8	8	7	7	7	7	6	6	6	5	5	5	4	4	4	4	4	4	3	3	3	3	2	2	2	1	1	1	1",
	"15	15	14	14	13	13	13	13	13	13	12	12	12	11	11	10	10	9	9	9	9	9	8	8	8	8	7	7	6	5	5	5	5	5	4	4	4	4	4	4	3	3	3	2	2	2	2	1	1",
	"16	15	15	14	14	14	13	13	13	13	13	13	13	12	12	11	10	10	9	9	9	9	8	8	8	8	7	7	6	6	5	5	5	5	4	4	4	4	4	4	4	3	3	3	2	2	2	2	1",
	"16	16	15	15	14	14	14	14	14	14	13	13	13	12	12	11	11	10	10	10	9	9	8	8	8	8	7	7	6	6	6	6	6	6	6	6	5	5	5	4	4	4	3	3	3	2	2	2	2",
	"16	16	16	15	15	15	14	14	14	14	13	13	13	13	12	12	12	11	11	11	10	10	9	9	9	9	8	8	7	7	7	7	6	6	6	6	5	5	5	5	4	4	4	4	3	3	2	2	2",
	"16	16	16	16	15	15	15	15	15	14	14	13	13	13	12	12	12	11	11	11	10	10	9	9	9	9	8	8	7	7	7	7	6	6	6	6	5	5	5	5	4	4	4	4	3	3	3	3	2",
	"17	17	17	17	16	16	15	15	15	15	14	14	14	14	13	13	12	12	12	12	11	11	10	10	10	10	9	9	8	8	8	8	7	7	6	6	6	6	5	5	4	4	4	4	3	3	3	3	2",
	"19	19	18	18	17	17	17	17	16	16	15	15	15	15	14	14	14	13	13	13	12	12	12	12	11	11	10	10	10	10	10	9	9	8	8	8	8	8	7	7	6	6	6	6	5	5	4	4	4"
};

char *min_qp444_12b[] = {
	"0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"5	5	5	5	4	4	4	4	4	4	4	4	4	4	4	3	3	2	2	2	2	2	2	2	2	2	1	1	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"11	10	10	9	8	8	8	8	8	8	8	8	7	7	7	6	5	5	4	4	4	3	3	3	3	3	2	2	2	2	2	2	1	1	1	1	1	1	1	1	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"11	11	10	10	9	9	9	9	9	9	9	9	8	8	8	7	6	6	6	6	6	5	5	5	5	5	4	4	3	3	3	3	3	3	3	3	2	2	2	2	2	2	2	1	1	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0",
	"13	12	12	11	11	11	11	11	11	11	11	11	10	10	9	9	9	8	7	7	7	7	5	5	5	5	5	5	4	4	4	3	3	3	3	3	3	3	3	3	2	2	2	2	1	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0",
	"13	12	12	12	11	11	11	11	11	11	11	11	11	11	11	10	9	9	8	8	8	8	6	6	6	6	5	5	5	5	5	4	4	4	4	4	4	4	4	4	3	3	3	2	2	2	2	1	1	1	1	1	1	0	0	0	0	0	0	0	0",
	"13	13	12	12	11	11	11	11	11	11	11	11	11	11	11	10	9	9	9	9	9	9	9	8	8	8	7	7	7	6	5	5	5	5	5	5	5	4	4	4	4	4	4	4	3	3	3	2	2	1	1	1	1	1	1	1	0	0	0	0	0",
	"13	13	12	12	11	11	11	11	11	11	11	11	11	11	11	11	10	10	10	10	10	10	9	9	9	9	8	8	8	7	7	7	6	6	6	6	6	6	5	5	5	5	4	4	4	3	3	2	2	2	2	2	2	1	1	1	1	0	0	0	0",
	"13	13	12	12	11	11	11	11	11	11	11	11	11	11	11	11	11	11	11	11	11	11	10	10	10	10	9	9	8	7	7	7	7	7	6	6	6	6	6	6	5	5	5	4	4	4	4	3	3	2	2	2	2	1	1	1	1	1	1	0	0",
	"14	13	13	12	12	12	11	11	11	11	11	11	11	11	11	11	11	11	11	11	11	11	10	10	10	10	9	9	8	8	8	8	8	8	7	7	7	7	7	6	6	5	5	5	4	4	4	4	3	3	3	3	3	2	2	2	2	2	1	1	0",
	"14	14	13	13	13	13	13	13	13	13	13	13	13	13	13	12	12	12	12	12	11	11	11	11	11	11	10	10	9	9	9	9	9	9	9	9	8	8	8	7	7	7	6	6	6	5	5	5	5	4	4	3	3	3	2	2	2	2	1	1	1",
	"14	14	14	13	13	13	13	13	13	13	13	13	13	13	13	13	13	13	13	13	12	12	11	11	11	11	11	11	10	10	10	10	9	9	9	9	8	8	8	8	7	7	7	7	6	6	5	5	5	4	4	4	3	3	3	3	2	2	1	1	1",
	"14	14	14	14	13	13	13	13	13	13	13	13	13	13	13	13	13	13	13	13	12	12	12	12	12	12	11	11	10	10	10	10	9	9	9	9	8	8	8	8	7	7	7	7	6	6	6	6	5	4	4	4	3	3	3	3	2	2	1	1	1",
	"17	17	17	17	16	16	15	15	15	15	15	15	15	15	15	15	15	15	15	15	14	14	13	13	13	13	12	12	11	11	11	11	10	10	9	9	9	9	8	8	7	7	7	7	7	6	6	6	5	5	5	5	4	4	3	3	3	3	2	2	1",
	"22	22	21	21	20	20	20	20	19	19	18	18	18	18	17	17	17	16	16	16	15	15	15	15	14	14	13	13	13	13	13	12	12	11	11	11	11	11	10	10	9	9	9	9	9	8	8	7	7	7	7	7	6	6	5	5	5	5	4	4	3"
};

char *max_qp444_12b[] = {
	"12	12	12	12	12	12	11	11	11	10	9	9	6	6	5	5	5	4	4	4	4	4	4	3	3	3	3	3	2	2	2	2	2	2	2	2	2	1	1	1	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"14	14	13	13	12	12	12	12	12	12	11	11	9	9	9	8	8	7	7	7	7	5	5	5	5	5	4	4	4	3	3	3	2	2	2	2	2	2	2	1	1	1	1	1	1	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0",
	"16	15	15	14	13	13	13	13	13	13	13	13	12	12	12	11	10	10	9	9	9	7	7	7	7	7	6	6	5	5	5	5	4	4	4	3	3	3	3	3	3	2	2	2	1	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0",
	"16	16	15	15	14	14	14	14	14	14	14	14	13	13	13	12	11	11	10	10	10	8	8	8	8	8	7	7	6	5	5	5	5	5	5	5	4	4	3	3	3	3	3	2	2	2	2	2	2	1	1	0	0	0	0	0	0	0	0	0	0",
	"17	16	16	15	15	15	15	15	15	15	15	15	14	14	13	12	12	11	10	10	10	10	8	8	8	8	8	8	7	7	7	6	6	5	5	5	4	4	4	4	3	3	3	3	2	2	2	2	2	1	1	1	1	1	1	1	1	1	1	0	0",
	"17	16	16	16	15	15	15	15	15	15	15	15	14	14	14	13	12	12	11	11	11	11	9	9	9	9	8	8	8	8	7	6	6	6	6	6	5	5	5	5	4	4	4	3	3	3	3	2	2	2	2	2	2	1	1	1	1	1	1	1	0",
	"17	17	16	16	15	15	15	15	15	15	15	15	15	14	14	13	12	12	11	11	11	11	11	10	10	10	9	9	9	8	7	7	7	7	7	7	7	6	6	6	5	5	5	5	4	4	4	3	3	2	2	2	2	2	2	2	1	1	1	1	0",
	"18	18	17	17	16	16	16	16	16	16	16	16	16	15	15	14	13	13	12	12	12	12	11	11	11	11	10	10	10	8	8	8	7	7	7	7	7	7	6	6	6	6	5	5	5	4	4	3	3	3	3	3	3	2	2	2	2	1	1	1	1",
	"19	19	18	18	17	17	17	17	17	17	16	16	16	15	15	14	14	13	13	13	13	13	12	12	12	12	11	11	10	9	8	8	8	8	7	7	7	7	7	7	6	6	6	5	5	5	5	4	4	3	3	3	3	2	2	2	2	2	2	1	1",
	"20	19	19	18	18	18	17	17	17	17	17	17	17	16	16	15	14	14	13	13	13	13	12	12	12	12	11	11	10	10	9	9	9	9	8	8	8	8	8	7	7	6	6	6	5	5	5	5	4	4	4	4	4	3	3	3	3	3	2	2	1",
	"20	20	19	19	18	18	18	18	18	18	17	17	17	16	16	15	15	14	14	14	13	13	12	12	12	12	11	11	10	10	10	10	10	10	10	10	9	9	9	8	8	8	7	7	7	6	6	6	6	5	5	4	4	4	3	3	3	3	2	2	2",
	"20	20	20	19	19	19	18	18	18	18	17	17	17	17	16	16	16	15	15	15	14	14	13	13	13	13	12	12	11	11	11	11	10	10	10	10	9	9	9	9	8	8	8	8	7	7	6	6	6	5	5	5	4	4	4	4	3	3	2	2	2",
	"20	20	20	20	19	19	19	19	19	18	18	17	17	17	16	16	16	15	15	15	14	14	13	13	13	13	12	12	11	11	11	11	10	10	10	10	9	9	9	9	8	8	8	8	7	7	7	7	6	5	5	5	4	4	4	4	3	3	2	2	2",
	"21	21	21	21	20	20	19	19	19	19	18	18	18	18	17	17	16	16	16	16	15	15	14	14	14	14	13	13	12	12	12	12	11	11	10	10	10	10	9	9	8	8	8	8	8	7	7	7	6	6	6	6	5	5	4	4	4	4	3	3	2",
	"23	23	22	22	21	21	21	21	20	20	19	19	19	19	18	18	18	17	17	17	16	16	16	16	15	15	14	14	14	14	14	13	13	12	12	12	12	12	11	11	10	10	10	10	10	9	9	8	8	8	8	8	7	7	6	6	6	6	5	5	4"
};

char *min_qp422_8b[] = {
	"0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"1	1	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"2	2	2	2	2	2	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"3	3	3	3	3	2	2	1	1	1	1	1	1	1	1	0	0	0	0	0	0",
	"3	3	3	3	3	2	2	1	1	1	1	1	1	1	1	1	1	0	0	0	0",
	"3	3	3	3	3	2	2	1	1	1	1	1	1	1	1	1	1	1	0	0	0",
	"3	3	3	3	3	3	2	2	2	2	2	2	2	2	2	1	1	1	1	0	0",
	"3	3	3	3	3	3	2	2	2	2	2	2	2	2	2	2	2	1	1	1	1",
	"3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	2	2	2	1	1	1",
	"5	5	5	5	5	4	4	4	4	4	4	4	4	3	3	3	2	2	1	1	1",
	"5	5	5	5	5	5	5	4	4	4	4	4	4	4	3	3	3	2	2	1	1",
	"5	5	5	5	5	5	5	5	5	5	5	5	5	4	4	3	3	2	2	1	1",
	"8	8	7	7	7	7	7	7	7	7	6	6	5	5	4	4	3	3	2	2	2",
	"12	12	11	11	10	10	9	9	8	8	7	7	6	6	5	5	4	4	4	3	3"
};

char *max_qp422_8b[] = {
	"4	4	3	3	2	2	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"4	4	4	4	4	3	2	2	1	1	1	1	1	0	0	0	0	0	0	0	0",
	"5	5	5	5	5	4	3	2	1	1	1	1	1	1	1	1	1	0	0	0	0",
	"6	6	6	6	6	5	4	3	2	2	2	2	2	1	1	1	1	1	1	0	0",
	"7	7	7	7	7	6	5	3	2	2	2	2	2	2	2	1	1	1	1	1	1",
	"7	7	7	7	7	6	5	4	3	3	3	2	2	2	2	2	2	1	1	1	1",
	"7	7	7	7	7	6	5	4	3	3	3	3	3	2	2	2	2	2	1	1	1",
	"8	8	8	8	8	7	6	5	4	4	4	3	3	3	3	2	2	2	2	1	1",
	"9	9	9	8	8	7	6	6	5	5	5	4	4	3	3	3	3	2	2	2	2",
	"10	10	9	9	9	8	7	6	5	5	5	5	4	4	4	3	3	3	2	2	2",
	"10	10	10	9	9	8	7	7	6	6	6	5	5	4	4	4	3	3	2	2	2",
	"11	11	10	10	9	9	8	7	7	7	6	6	5	5	4	4	4	3	3	2	2",
	"11	11	11	10	9	9	8	8	7	7	7	6	6	5	5	4	4	3	3	2	2",
	"12	12	11	11	10	10	9	9	8	8	7	7	6	6	5	5	4	4	3	3	3",
	"13	13	12	12	11	11	10	10	9	9	8	8	7	7	6	6	5	5	5	4	4"
};

char *min_qp422_10b[] = {
	"0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"4	4	4	2	2	2	2	2	2	2	2	2	2	1	1	1	1	1	1	0	0	0	0	0	0	0	0	0	0",
	"5	5	5	4	3	3	3	3	2	2	2	2	2	2	2	2	2	1	1	1	1	0	0	0	0	0	0	0	0",
	"6	6	6	6	5	4	4	4	3	3	3	3	3	2	2	2	2	2	2	1	1	1	0	0	0	0	0	0	0",
	"6	6	6	6	5	5	5	4	4	4	4	4	4	4	4	3	3	3	2	2	2	1	1	1	0	0	0	0	0",
	"6	6	6	6	6	5	5	5	5	4	4	4	4	4	4	4	4	3	3	3	3	2	1	1	0	0	0	0	0",
	"6	6	6	6	6	5	5	5	5	5	5	5	5	4	4	4	4	4	3	3	3	2	2	1	1	1	0	0	0",
	"7	7	7	7	7	6	6	6	6	6	6	5	5	5	5	4	4	4	4	3	3	3	2	2	1	1	1	1	1",
	"7	7	7	7	7	6	6	6	6	6	6	6	6	5	5	5	4	4	4	4	4	3	2	2	1	1	1	1	1",
	"8	8	7	7	7	7	7	7	7	7	7	7	6	6	6	6	5	5	4	4	4	3	3	2	2	1	1	1	1",
	"9	9	9	8	8	8	8	8	8	8	8	7	7	6	6	6	5	5	5	5	5	3	3	2	2	2	1	1	1",
	"9	9	9	9	8	8	8	8	8	8	8	8	7	7	6	6	6	6	6	5	5	4	3	3	2	2	1	1	1",
	"9	9	9	9	9	9	9	9	9	9	9	8	8	8	8	7	7	6	6	5	5	4	3	3	3	2	2	1	1",
	"12	12	11	11	11	11	11	11	11	11	10	10	9	9	8	8	7	7	6	6	5	5	4	4	3	3	2	2	1",
	"16	16	15	15	14	14	13	13	12	12	11	11	10	10	9	9	8	8	8	7	7	6	6	5	5	5	4	4	3"
};

char *max_qp422_10b[] = {
	"8	8	7	5	4	4	3	3	2	2	2	2	2	2	1	1	1	1	1	1	1	0	0	0	0	0	0	0	0",
	"8	8	8	6	6	5	4	4	3	3	3	3	3	2	2	2	2	2	2	1	1	1	0	0	0	0	0	0	0",
	"9	9	9	8	7	6	5	4	3	3	3	3	3	3	3	3	3	2	2	2	2	1	1	1	0	0	0	0	0",
	"10	10	10	10	9	8	7	6	5	5	5	5	5	4	4	3	3	3	3	2	2	2	1	1	1	1	1	1	1",
	"11	11	11	11	10	9	8	6	5	5	5	5	5	5	5	4	4	4	3	3	3	2	2	2	1	1	1	1	1",
	"11	11	11	11	11	10	9	8	7	6	6	5	5	5	5	5	5	4	4	4	4	3	2	2	1	1	1	1	1",
	"11	11	11	11	11	10	9	8	7	7	7	7	7	6	6	6	5	5	4	4	4	3	3	2	2	2	1	1	1",
	"12	12	12	12	12	11	10	9	8	8	8	7	7	7	7	6	5	5	5	4	4	4	3	3	2	2	2	2	2",
	"13	13	13	12	12	11	10	10	9	9	9	8	8	7	7	7	6	5	5	5	5	4	3	3	2	2	2	2	2",
	"14	14	13	13	13	12	11	10	9	9	9	9	8	8	8	7	6	6	5	5	5	4	4	3	3	2	2	2	2",
	"14	14	14	13	13	12	11	11	10	10	10	9	9	8	8	8	7	7	6	6	6	4	4	3	3	3	2	2	2",
	"15	15	14	14	13	13	12	11	11	11	10	10	9	9	8	8	8	7	7	6	6	5	4	4	3	3	2	2	2",
	"15	15	15	14	13	13	12	12	11	11	11	10	10	9	9	8	8	7	7	6	6	5	4	4	4	3	3	2	2",
	"16	16	15	15	14	14	13	13	12	12	11	11	10	10	9	9	8	8	7	7	6	6	5	5	4	4	3	3	2",
	"17	17	16	16	15	15	14	14	13	13	12	12	11	11	10	10	9	9	9	8	8	7	7	6	6	6	5	5	4"
};

char *min_qp422_12b[] = {
	"0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"4	4	4	4	4	3	3	3	2	2	2	2	2	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"9	9	9	8	7	6	5	5	4	4	4	4	4	4	3	3	2	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"10	10	10	10	8	8	8	7	6	6	6	6	6	5	4	3	3	3	3	2	2	2	1	1	1	1	1	1	1	0	0	0	0	0	0	0	0",
	"11	11	11	11	10	9	9	8	7	7	7	7	6	6	5	4	4	4	3	3	3	2	2	2	2	2	2	1	1	1	0	0	0	0	0	0	0",
	"11	11	11	11	11	10	10	9	9	8	8	7	6	6	5	5	5	4	4	4	4	3	2	2	2	2	2	1	1	1	1	0	0	0	0	0	0",
	"11	11	11	11	11	10	10	10	9	9	9	9	8	7	7	7	6	6	5	5	5	4	4	3	3	3	2	2	2	2	2	1	1	0	0	0	0",
	"11	11	11	11	11	11	10	10	10	10	10	9	8	8	8	7	6	6	6	5	5	5	4	4	3	3	3	3	3	2	2	2	1	1	0	0	0",
	"11	11	11	11	11	11	11	11	11	11	11	10	9	8	8	8	7	6	6	6	6	5	4	4	3	3	3	3	3	3	3	2	2	1	0	0	0",
	"11	11	11	11	11	11	11	11	11	11	11	11	9	9	9	8	7	7	6	6	6	5	5	4	4	3	3	3	3	3	3	2	2	1	1	0	0",
	"13	13	13	13	13	12	12	12	12	12	12	11	11	10	10	10	9	9	8	8	8	6	6	5	5	5	4	4	4	4	3	3	2	2	1	1	1",
	"13	13	13	13	13	13	13	13	13	13	12	12	11	11	10	10	10	9	9	8	8	7	6	6	5	5	4	4	4	4	4	3	3	2	2	1	1",
	"13	13	13	13	13	13	13	13	13	13	13	12	12	11	11	10	10	9	9	8	8	7	6	6	6	5	5	4	4	4	4	3	3	2	2	1	1",
	"16	16	15	15	15	15	15	15	15	15	14	14	13	13	12	12	11	11	10	10	9	9	8	8	7	7	6	6	5	5	4	4	4	3	3	2	2",
	"20	20	19	19	18	18	17	17	16	16	15	15	14	14	13	13	12	12	12	11	11	10	10	9	9	9	8	8	7	7	6	6	6	5	5	4	4"
};

char *max_qp422_12b[] = {
	"12	12	11	9	6	6	5	5	4	4	4	3	3	3	2	2	2	2	2	2	2	1	1	1	1	1	1	1	1	0	0	0	0	0	0	0	0",
	"12	12	12	10	9	8	7	7	6	6	5	5	5	4	4	4	3	3	3	2	2	2	1	1	1	1	1	1	1	0	0	0	0	0	0	0	0",
	"13	13	13	12	10	9	8	7	6	6	6	6	6	6	5	5	4	3	3	3	3	2	2	2	1	1	1	1	1	0	0	0	0	0	0	0	0",
	"14	14	14	14	12	11	10	9	8	8	8	8	8	7	6	5	5	5	5	4	4	4	3	3	2	2	2	2	2	1	1	0	0	0	0	0	0",
	"15	15	15	15	14	13	12	10	9	9	9	9	8	8	7	6	6	6	5	5	5	4	4	4	3	3	3	2	2	2	1	1	1	1	0	0	0",
	"15	15	15	15	15	14	13	12	11	10	10	9	8	8	7	7	7	6	6	6	6	5	4	4	3	3	3	2	2	2	2	1	1	1	1	1	1",
	"15	15	15	15	15	14	13	12	11	11	11	11	10	9	9	9	8	8	7	7	7	6	6	5	5	5	4	4	4	3	3	2	2	1	1	1	1",
	"16	16	16	16	16	15	14	13	12	12	12	11	10	10	10	9	8	8	8	7	7	7	6	6	5	5	5	5	5	3	3	3	2	2	1	1	1",
	"17	17	17	16	16	15	14	14	13	13	13	12	11	10	10	10	9	8	8	8	8	7	6	6	5	5	5	5	5	4	4	3	3	2	1	1	1",
	"18	18	17	17	17	16	15	14	13	13	13	13	11	11	11	10	9	9	8	8	8	7	7	6	6	5	5	5	5	4	4	3	3	2	2	1	1",
	"18	18	18	17	17	16	15	15	14	14	14	13	13	12	12	12	11	11	10	10	10	8	8	7	7	7	6	6	6	5	4	4	3	3	2	2	2",
	"19	19	18	18	17	17	16	15	15	15	14	14	13	13	12	12	12	11	11	10	10	9	8	8	7	7	6	6	6	5	5	4	4	3	3	2	2",
	"19	19	19	18	17	17	16	16	15	15	15	14	14	13	13	12	12	11	11	10	10	9	8	8	8	7	7	6	6	5	5	4	4	3	3	2	2",
	"20	20	19	19	18	18	17	17	16	16	15	15	14	14	13	13	12	12	11	11	10	10	9	9	8	8	7	7	6	6	5	5	5	4	4	3	3",
	"21	21	20	20	19	19	18	18	17	17	16	16	15	15	14	14	13	13	13	12	12	11	11	10	10	10	9	9	8	8	7	7	7	6	6	5	5"
};

char *min_qp420_8b[] = {
	"0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"1	1	1	1	1	1	1	0	0	0	0	0	0	0	0	0	0",
	"1	1	1	1	1	1	1	1	0	0	0	0	0	0	0	0	0",
	"3	3	3	3	3	2	1	1	1	1	1	1	1	0	0	0	0",
	"3	3	3	3	3	2	2	1	1	1	1	1	1	1	0	0	0",
	"3	3	3	3	3	3	2	2	1	1	1	1	1	1	1	0	0",
	"3	3	3	3	3	3	2	2	2	2	2	2	2	1	1	1	0",
	"3	3	3	3	3	3	2	2	2	2	2	2	2	2	1	1	0",
	"3	3	3	3	3	3	3	3	3	3	3	3	3	2	2	1	1",
	"5	5	5	5	5	4	4	4	4	4	3	3	3	3	2	1	1",
	"5	5	5	5	5	5	5	4	4	4	4	4	4	3	2	2	1",
	"5	5	5	5	5	5	5	5	5	5	5	4	4	3	3	2	1",
	"9	8	8	7	7	7	7	7	7	6	5	5	4	3	3	3	2",
	"13	12	12	11	10	10	9	8	8	7	6	6	5	5	4	4	3"
};

char *max_qp420_8b[] = {
	"4	4	3	3	2	2	1	1	0	0	0	0	0	0	0	0	0",
	"4	4	4	4	4	3	2	2	1	1	1	1	0	0	0	0	0",
	"5	5	5	5	5	4	3	2	1	1	1	1	1	1	0	0	0",
	"6	6	6	6	6	5	4	3	2	2	2	1	1	1	1	0	0",
	"7	7	7	7	7	5	4	3	2	2	2	2	2	1	1	1	0",
	"7	7	7	7	7	6	5	4	3	3	3	2	2	2	1	1	0",
	"7	7	7	7	7	6	5	4	3	3	3	3	2	2	2	1	1",
	"8	8	8	8	8	7	6	5	4	4	4	3	3	2	2	2	1",
	"9	9	9	8	8	7	6	6	5	5	4	4	3	3	2	2	1",
	"10	10	9	9	9	8	7	6	5	5	5	4	4	3	3	2	2",
	"10	10	10	9	9	8	8	7	6	6	5	5	4	4	3	2	2",
	"11	11	10	10	9	9	8	7	7	6	6	5	5	4	3	3	2",
	"11	11	11	10	9	9	9	8	7	7	6	5	5	4	4	3	2",
	"13	12	12	11	10	10	9	8	8	7	6	6	5	4	4	4	3",
	"14	13	13	12	11	11	10	9	9	8	7	7	6	6	5	5	4"
};

char *min_qp420_10b[] = {
	"0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"4	4	4	3	2	2	2	2	2	2	2	2	1	0	0	0	0	0	0	0	0	0	0",
	"4	4	4	3	3	3	3	3	3	2	2	2	2	2	1	0	0	0	0	0	0	0	0",
	"5	5	5	4	4	4	4	4	4	3	3	2	2	2	2	1	0	0	0	0	0	0	0",
	"7	7	7	6	6	5	5	4	4	3	3	3	3	2	2	2	1	1	1	0	0	0	0",
	"7	7	7	7	7	6	5	5	5	5	5	4	3	3	2	2	1	1	1	1	1	0	0",
	"7	7	7	7	7	6	6	5	5	5	5	4	4	4	3	2	2	2	2	1	1	1	0",
	"7	7	7	7	7	7	6	6	6	6	6	5	4	4	4	3	2	2	2	1	1	1	0",
	"7	7	7	7	7	7	7	7	6	6	6	6	5	5	4	4	3	3	2	2	2	1	1",
	"7	7	7	7	7	7	7	7	7	7	7	6	6	5	5	4	4	3	3	2	2	1	1",
	"9	9	9	9	9	8	8	8	8	8	7	7	6	6	5	5	4	4	3	3	2	2	1",
	"9	9	9	9	9	9	8	8	8	8	8	8	8	7	6	6	5	4	4	3	3	2	1",
	"9	9	9	9	9	9	9	9	9	9	9	8	8	7	7	6	5	4	4	3	3	2	1",
	"13	12	12	11	11	11	11	11	11	10	9	9	8	7	7	6	5	5	4	3	3	2	2",
	"17	16	16	15	14	14	13	12	12	11	10	10	10	9	8	8	7	6	6	5	5	4	4"
};

char *max_qp420_10b[] = {
	"8	8	7	6	4	4	3	3	2	1	1	1	1	1	0	0	0	0	0	0	0	0	0",
	"8	8	8	7	6	5	4	4	3	3	3	3	2	1	1	1	0	0	0	0	0	0	0",
	"9	9	9	8	8	7	6	5	4	3	3	3	3	3	2	1	1	1	0	0	0	0	0",
	"10	10	10	9	9	8	7	6	5	4	4	3	3	3	3	2	1	1	1	1	1	0	0",
	"11	11	11	10	10	8	7	6	5	4	4	4	4	3	3	3	2	2	2	1	1	1	0",
	"11	11	11	10	10	9	8	7	6	6	6	5	4	4	3	3	2	2	2	2	2	1	1",
	"11	11	11	11	11	10	9	8	7	7	7	6	5	5	4	3	3	3	3	2	2	2	1",
	"12	12	12	12	12	11	10	9	8	8	8	7	6	5	5	4	3	3	3	2	2	2	1",
	"13	13	13	12	12	11	10	10	9	9	8	8	7	7	6	5	4	4	3	3	3	2	2",
	"14	14	13	13	13	12	11	10	9	9	9	8	8	7	7	6	5	4	4	3	3	2	2",
	"14	14	14	13	13	12	12	11	10	10	9	9	8	8	7	6	5	5	4	4	3	3	2",
	"15	15	14	14	13	13	12	11	11	10	10	9	9	8	7	7	6	5	5	4	4	3	2",
	"15	15	15	14	13	13	13	12	11	11	10	9	9	8	8	7	6	5	5	4	4	3	2",
	"17	16	16	15	14	14	13	12	12	11	10	10	9	8	8	7	6	6	5	4	4	3	3",
	"18	17	17	16	15	15	14	13	13	12	11	11	11	10	9	9	8	7	7	6	6	5	5"
};

char *min_qp420_12b[] = {
	"0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"4	4	4	4	4	4	3	3	2	2	2	2	2	2	2	1	0	0	0	0	0	0	0	0	0	0	0	0	0",
	"9	8	8	7	7	6	5	5	4	4	4	4	3	3	3	2	2	1	0	0	0	0	0	0	0	0	0	0	0",
	"10	9	9	8	8	8	7	7	6	6	6	5	5	4	4	3	2	2	1	1	1	0	0	0	0	0	0	0	0",
	"11	10	10	10	10	9	9	8	7	6	6	6	6	5	5	4	3	3	3	2	2	1	0	0	0	0	0	0	0",
	"11	11	11	11	11	10	10	9	9	9	9	8	7	6	5	5	4	4	3	3	3	2	1	1	0	0	0	0	0",
	"11	11	11	11	11	11	10	10	9	9	9	8	8	7	6	5	5	5	5	4	3	3	2	1	1	1	1	1	0",
	"11	11	11	11	11	11	11	10	10	10	10	9	8	8	8	7	6	6	5	4	4	3	2	2	1	1	1	1	1",
	"11	11	11	11	11	11	11	11	11	11	10	10	9	9	8	8	7	7	6	5	5	4	4	2	2	1	1	1	1",
	"11	11	11	11	11	11	11	11	11	11	11	10	10	9	9	8	8	7	7	6	5	4	4	3	2	2	1	1	1",
	"13	13	13	13	13	13	13	12	12	12	11	11	10	10	9	9	8	8	7	7	6	5	4	3	3	2	2	1	1",
	"13	13	13	13	13	13	13	13	13	12	12	12	12	11	10	10	9	8	8	7	7	6	5	4	3	3	2	2	1",
	"13	13	13	13	13	13	13	13	13	13	13	12	12	11	11	10	9	8	8	7	7	6	5	4	4	3	2	2	1",
	"15	15	15	15	15	15	15	15	15	14	13	13	12	11	11	10	9	9	8	8	7	6	6	5	4	4	3	3	2",
	"21	20	20	19	18	18	17	16	16	15	14	14	14	13	12	12	11	10	10	10	9	8	8	7	6	6	5	5	4"
};

char *max_qp420_12b[] = {
	"11	10	9	8	6	6	5	5	4	3	3	2	2	2	1	1	1	1	1	1	1	0	0	0	0	0	0	0	0",
	"12	11	11	10	9	8	7	7	6	6	5	5	4	3	3	2	1	1	1	1	1	1	1	0	0	0	0	0	0",
	"13	12	12	11	11	10	9	8	7	6	6	6	5	5	4	3	3	2	1	1	1	1	1	0	0	0	0	0	0",
	"14	13	13	12	12	11	10	9	8	7	7	6	6	5	5	4	3	3	2	2	2	1	1	1	0	0	0	0	0",
	"15	14	14	13	13	11	10	9	8	7	7	7	7	6	6	5	4	4	4	3	3	2	1	1	1	0	0	0	0",
	"15	15	15	14	14	13	12	11	10	10	10	9	8	7	6	6	5	5	4	4	4	3	2	2	1	1	0	0	0",
	"15	15	15	15	15	14	13	12	11	11	11	10	9	8	7	6	6	6	6	5	4	4	3	2	2	2	1	1	0",
	"16	16	16	16	16	15	14	13	12	12	12	11	10	9	9	8	7	7	6	5	5	4	3	3	2	2	2	1	1",
	"17	17	17	16	16	15	14	14	13	13	12	12	11	11	10	9	8	8	7	6	6	5	5	3	3	2	2	1	1",
	"18	18	17	17	17	16	15	14	13	13	13	12	12	11	11	10	9	8	8	7	6	5	5	4	3	3	2	2	1",
	"18	18	18	17	17	16	16	15	14	14	13	13	12	12	11	10	9	9	8	8	7	6	5	4	4	3	3	2	2",
	"19	19	18	18	17	17	16	15	15	14	14	13	13	12	11	11	10	9	9	8	8	7	6	5	4	4	3	3	2",
	"19	19	19	18	17	17	17	16	15	15	14	13	13	12	12	11	10	9	9	8	8	7	6	5	5	4	3	3	2",
	"21	20	20	19	18	18	17	16	16	15	14	14	13	12	12	11	10	10	9	9	8	7	7	6	5	5	4	4	3",
	"22	21	21	20	19	19	18	17	17	16	15	15	15	14	13	13	12	11	11	11	10	9	9	8	7	7	6	6	5"
};

int **min_qp_444[3], **max_qp_444[3];
int **min_qp_422[3], **max_qp_422[3];
int **min_qp_420[3], **max_qp_420[3];

void line_to_int(char *s, int **l)
{
	int i, n;
	int j;
	int temp;
	char s_temp[QP_VALUE_MAX_LEN] = { 0 };

	n = 1;
	for (i = 0; s[i] != '\0'; ++i) {
		if (s[i] == '\t')
			n++;
	}
	*l = kcalloc(n, sizeof(int), GFP_KERNEL);
	if (!(*l)) {
		DSC_ERR("%s dest is null\n", __func__);
		return;
	}

	for (i = 0; i < n - 1; ++i) {
		//add '\0' end kstrtoint will judge
		for (j = 0; j < QP_VALUE_MAX_LEN; j++) {
			if ('0' <= *(s + j) && *(s + j) <= '9')
				s_temp[j] = *(s + j);
			else
				break;
		}
		if (kstrtoint(s_temp, 10, &temp) == 0)
			(*l)[i] = temp;
		while (s[0] != '\t')
			s++;
		s++;
		memset(s_temp, 0, QP_VALUE_MAX_LEN);
	}
	if (kstrtoint(s, 10, &temp) == 0)
		(*l)[i] = temp;
}

void make_qp_table(char *table[], int ***dest)
{
	int i;

	*dest = kcalloc(15, sizeof(int *), GFP_KERNEL);
	if (!(*dest)) {
		DSC_ERR("%s dest is null\n", __func__);
		return;
	}

	for (i = 0; i < 15; ++i)
		line_to_int(table[i], &((*dest)[i]));
}

void make_qp_tables(void)
{
	make_qp_table(min_qp444_8b, &min_qp_444[0]);
	make_qp_table(max_qp444_8b, &max_qp_444[0]);
	make_qp_table(min_qp444_10b, &min_qp_444[1]);
	make_qp_table(max_qp444_10b, &max_qp_444[1]);
	make_qp_table(min_qp444_12b, &min_qp_444[2]);
	make_qp_table(max_qp444_12b, &max_qp_444[2]);

	make_qp_table(min_qp422_8b, &min_qp_422[0]);
	make_qp_table(max_qp422_8b, &max_qp_422[0]);
	make_qp_table(min_qp422_10b, &min_qp_422[1]);
	make_qp_table(max_qp422_10b, &max_qp_422[1]);
	make_qp_table(min_qp422_12b, &min_qp_422[2]);
	make_qp_table(max_qp422_12b, &max_qp_422[2]);

	make_qp_table(min_qp420_8b, &min_qp_420[0]);
	make_qp_table(max_qp420_8b, &max_qp_420[0]);
	make_qp_table(min_qp420_10b, &min_qp_420[1]);
	make_qp_table(max_qp420_10b, &max_qp_420[1]);
	make_qp_table(min_qp420_12b, &min_qp_420[2]);
	make_qp_table(max_qp420_12b, &max_qp_420[2]);
}

void destroy_qp_table(int ***dest)
{
	int i;

	for (i = 0; i < 15; ++i) {
		if ((*dest)[i]) {
			kfree((*dest)[i]);
			(*dest)[i] = NULL;
		}
	}

	if (*dest) {
		kfree(*dest);
		dest = NULL;
	}
}

void destroy_qp_tables(void)
{
	destroy_qp_table(&min_qp_444[0]);
	destroy_qp_table(&max_qp_444[0]);
	destroy_qp_table(&min_qp_444[1]);
	destroy_qp_table(&max_qp_444[1]);
	destroy_qp_table(&min_qp_444[2]);
	destroy_qp_table(&max_qp_444[2]);

	destroy_qp_table(&min_qp_422[0]);
	destroy_qp_table(&max_qp_422[0]);
	destroy_qp_table(&min_qp_422[1]);
	destroy_qp_table(&max_qp_422[1]);
	destroy_qp_table(&min_qp_422[2]);
	destroy_qp_table(&max_qp_422[2]);

	destroy_qp_table(&min_qp_420[0]);
	destroy_qp_table(&max_qp_420[0]);
	destroy_qp_table(&min_qp_420[1]);
	destroy_qp_table(&max_qp_420[1]);
	destroy_qp_table(&min_qp_420[2]);
	destroy_qp_table(&max_qp_420[2]);
}
