/* SPDX-License-Identifier: GPL-2.0 */
/*
 * ad82128.h  --  ad82128 ALSA SoC Audio driver
 *
 * Copyright 1998 Elite Semiconductor Memory Technology
 *
 * Author: ESMT Audio/Power Product BU Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#ifndef __AD82128_H__
#define __AD82128_H__

#define AD82128_REGISTER_COUNT					 134
#define AD82128_RAM_TABLE_COUNT          120

// #define	PD_CRL_PIN_INDEX				122

/* Register Address Map */
#define AD82128_STATE_CTRL1_REG	0x00
#define AD82128_STATE_CTRL2_REG	0x01
#define AD82128_STATE_CTRL3_REG	0x02
#define AD82128_VOLUME_CTRL_REG	0x03
#define AD82128_VOLUME_CTRL_REG_CH1  0x04
#define AD82128_VOLUME_CTRL_REG_CH2  0x05
#define AD82128_STATE_CTRL5_REG	0x1A

#define CFADDR    0x1d
#define A1CF1     0x1e
#define A1CF2     0x1f
#define A1CF3     0x20
#define A1CF4     0x21
#define CFUD      0x32

#define AD82128_ANALOG_CTRL_REG		0x5e

#define AD82128_FAULT_REG		0x7D
#define AD82128_MAX_REG			0x85

/* AD82128_STATE_CTRL2_REG */
#define AD82128_SSZ_DS			BIT(5)

/* AD82128_STATE_CTRL1_REG */
#define AD82128_SAIF_I2S		(0x0 << 5)
#define AD82128_SAIF_LEFTJ		(0x1 << 5)
#define AD82128_SAIF_FORMAT_MASK	GENMASK(7, 5)

/* AD82128_STATE_CTRL3_REG */
#define AD82128_MUTE			BIT(6)

/* AD82128_STATE_CTRL5_REG */
#define AD82128_SW_RESET			BIT(5)

/* AD82128_ANALOG_CTRL_REG */
#define AD82128_ANALOG_GAIN_15_5DBV	(0x0)
#define AD82128_ANALOG_GAIN_14_0DBV	(0x1)
#define AD82128_ANALOG_GAIN_13_0DBV	(0x2)
#define AD82128_ANALOG_GAIN_11_5DBV	(0x3)
#define AD82128_ANALOG_GAIN_MASK	GENMASK(1, 0)
#define AD82128_ANALOG_GAIN_SHIFT	(0x0)

/* AD82128_FAULT_REG */
#define AD82128_CLKE		BIT(2)
#define AD82128_OCE			BIT(7)
#define AD82128_DCE			BIT(4)
#define AD82128_OTE			BIT(6)

static int m_reg_tab[AD82128_REGISTER_COUNT][2] = {
	{ 0x00, 0x00 }, //##State_Control_1
	{ 0x01, 0x81 }, //##State_Control_2
	{ 0x02, 0x7f }, //##State_Control_3
	{ 0x03, 0x18 }, //##Master_volume_control
	{ 0x04, 0x18 }, //##Channel_1_volume_control
	{ 0x05, 0x18 }, //##Channel_2_volume_control
	{ 0x06, 0x18 }, //##Channel_3_volume_control
	{ 0x07, 0x18 }, //##Channel_4_volume_control
	{ 0x08, 0x18 }, //##Channel_5_volume_control
	{ 0x09, 0x18 }, //##Channel_6_volume_control
	{ 0x0a, 0x00 }, //##Reserve
	{ 0x0b, 0x00 }, //##Reserve
	{ 0x0c, 0x90 }, //##State_Control_4
	{ 0x0d, 0x80 }, //##Channel_1_configuration_registers
	{ 0x0e, 0x80 }, //##Channel_2_configuration_registers
	{ 0x0f, 0x80 }, //##Channel_3_configuration_registers
	{ 0x10, 0x80 }, //##Channel_4_configuration_registers
	{ 0x11, 0x80 }, //##Channel_5_configuration_registers
	{ 0x12, 0x80 }, //##Channel_6_configuration_registers
	{ 0x13, 0x80 }, //##Channel_7_configuration_registers
	{ 0x14, 0x80 }, //##Channel_8_configuration_registers
	{ 0x15, 0x6a }, //##Reserve
	{ 0x16, 0x6a }, //##Reserve
	{ 0x17, 0x6a }, //##Reserve
	{ 0x18, 0x6a }, //##Reserve
	{ 0x19, 0x00 }, //##Reserve
	{ 0x1a, 0x28 }, //##State_Control_5
	{ 0x1b, 0x80 }, //##State_Control_6
	{ 0x1c, 0x20 }, //##State_Control_7
	{ 0x1d, 0x7f }, //##Coefficient_RAM_Base_Address
	{ 0x1e, 0x00 }, //##First_4bits_of_coefficients_A1
	{ 0x1f, 0x00 }, //##Second_8bits_of_coefficients_A1
	{ 0x20, 0x00 }, //##Third_8bits_of_coefficients_A1
	{ 0x21, 0x00 }, //##Fourth_bits_of_coefficients_A1
	{ 0x22, 0x00 }, //##First_4bits_of_coefficients_A2
	{ 0x23, 0x00 }, //##Second_8bits_of_coefficients_A2
	{ 0x24, 0x00 }, //##Third_8bits_of_coefficients_A2
	{ 0x25, 0x00 }, //##Fourth_8bits_of_coefficients_A2
	{ 0x26, 0x00 }, //##First_4bits_of_coefficients_B1
	{ 0x27, 0x00 }, //##Second_8bits_of_coefficients_B1
	{ 0x28, 0x00 }, //##Third_8bits_of_coefficients_B1
	{ 0x29, 0x00 }, //##Fourth_8bits_of_coefficients_B1
	{ 0x2a, 0x00 }, //##First_4bits_of_coefficients_B2
	{ 0x2b, 0x00 }, //##Second_8bits_of_coefficients_B2
	{ 0x2c, 0x00 }, //##Third_8bits_of_coefficients_B2
	{ 0x2d, 0x00 }, //##Fourth_bits_of_coefficients_B2
	{ 0x2e, 0x00 }, //##First_4bits_of_coefficients_A0
	{ 0x2f, 0x80 }, //##Second_8bits_of_coefficients_A0
	{ 0x30, 0x00 }, //##Third_8bits_of_coefficients_A0
	{ 0x31, 0x00 }, //##Fourth_8bits_of_coefficients_A0
	{ 0x32, 0x00 }, //##Coefficient_RAM_RW_control
	{ 0x33, 0x06 }, //##State_Control_8
	{ 0x34, 0xf0 }, //##State_Control_9
	{ 0x35, 0x00 }, //##Volume_Fine_tune
	{ 0x36, 0x00 }, //##Volume_Fine_tune
	{ 0x37, 0x04 }, //##Device_ID_register
	{ 0x38, 0x00 }, //##Level_Meter_Clear
	{ 0x39, 0x00 }, //##Power_Meter_Clear
	{ 0x3a, 0x00 }, //##First_8bits_of_C1_Level_Meter
	{ 0x3b, 0x00 }, //##Second_8bits_of_C1_Level_Meter
	{ 0x3c, 0xc0 }, //##Third_8bits_of_C1_Level_Meter
	{ 0x3d, 0x83 }, //##Fourth_8bits_of_C1_Level_Meter
	{ 0x3e, 0x00 }, //##First_8bits_of_C2_Level_Meter
	{ 0x3f, 0x00 }, //##Second_8bits_of_C2_Level_Meter
	{ 0x40, 0xc0 }, //##Third_8bits_of_C2_Level_Meter
	{ 0x41, 0x94 }, //##Fourth_8bits_of_C2_Level_Meter
	{ 0x42, 0x00 }, //##First_8bits_of_C3_Level_Meter
	{ 0x43, 0x00 }, //##Second_8bits_of_C3_Level_Meter
	{ 0x44, 0x00 }, //##Third_8bits_of_C3_Level_Meter
	{ 0x45, 0x00 }, //##Fourth_8bits_of_C3_Level_Meter
	{ 0x46, 0x00 }, //##First_8bits_of_C4_Level_Meter
	{ 0x47, 0x00 }, //##Second_8bits_of_C4_Level_Meter
	{ 0x48, 0x00 }, //##Third_8bits_of_C4_Level_Meter
	{ 0x49, 0x00 }, //##Fourth_8bits_of_C4_Level_Meter
	{ 0x4a, 0x00 }, //##First_8bits_of_C5_Level_Meter
	{ 0x4b, 0x00 }, //##Second_8bits_of_C5_Level_Meter
	{ 0x4c, 0x00 }, //##Third_8bits_of_C5_Level_Meter
	{ 0x4d, 0x00 }, //##Fourth_8bits_of_C5_Level_Meter
	{ 0x4e, 0x00 }, //##First_8bits_of_C6_Level_Meter
	{ 0x4f, 0x00 }, //##Second_8bits_of_C6_Level_Meter
	{ 0x50, 0x00 }, //##Third_8bits_of_C6_Level_Meter
	{ 0x51, 0x00 }, //##Fourth_8bits_of_C6_Level_Meter
	{ 0x52, 0x00 }, //##First_8bits_of_C7_Level_Meter
	{ 0x53, 0x00 }, //##Second_8bits_of_C7_Level_Meter
	{ 0x54, 0x00 }, //##Third_8bits_of_C7_Level_Meter
	{ 0x55, 0x00 }, //##Fourth_8bits_of_C7_Level_Meter
	{ 0x56, 0x00 }, //##First_8bits_of_C8_Level_Meter
	{ 0x57, 0x00 }, //##Second_8bits_of_C8_Level_Meter
	{ 0x58, 0x00 }, //##Third_8bits_of_C8_Level_Meter
	{ 0x59, 0x00 }, //##Fourth_8bits_of_C8_Level_Meter
	{ 0x5a, 0x05 }, //##I2S_data_output_selection_register
	{ 0x5b, 0x00 }, //##Mono_Key_High_Byte
	{ 0x5c, 0x00 }, //##Mono_Key_Low_Byte
	{ 0x5d, 0x07 }, //##Hires_Item
	{ 0x5e, 0x00 }, //##Analog_gain
	{ 0x5f, 0x00 }, //##Reserve
	{ 0x60, 0x00 }, //##Reserve
	{ 0x61, 0x00 }, //##Reserve
	{ 0x62, 0x00 }, //##Reserve
	{ 0x63, 0x00 }, //##Reserve
	{ 0x64, 0x00 }, //##Reserve
	{ 0x65, 0x00 }, //##Reserve
	{ 0x66, 0x00 }, //##Reserve
	{ 0x67, 0x00 }, //##Reserve
	{ 0x68, 0x00 }, //##Reserve
	{ 0x69, 0x00 }, //##Reserve
	{ 0x6a, 0x00 }, //##Reserve
	{ 0x6b, 0x00 }, //##Reserve
	{ 0x6c, 0x11 }, //##FS_and_PMF_read_out
	{ 0x6d, 0x00 }, //##OC_level_setting
	{ 0x6e, 0x40 }, //##DTC_setting
	{ 0x6f, 0x74 }, //##Testmode_register0
	{ 0x70, 0x07 }, //##Reserve
	{ 0x71, 0x40 }, //##Testmode_register1
	{ 0x72, 0x38 }, //##Testmode_register2
	{ 0x73, 0x18 }, //##Dither_signal_setting
	{ 0x74, 0x06 }, //##Error_delay
	{ 0x75, 0x55 }, //##First_8bits_of_MBIST_User_Program_Even
	{ 0x76, 0x55 }, //##Second_8bits_of_MBIST_User_Program_Even
	{ 0x77, 0x55 }, //##Third_8bits_of_MBIST_User_Program_Even
	{ 0x78, 0x55 }, //##Fourth_8bits_of_MBIST_User_Program_Even
	{ 0x79, 0x55 }, //##First_8bits_of_MBIST_User_Program_Odd
	{ 0x7a, 0x55 }, //##Second_8bits_of_MBIST_User_Program_Odd
	{ 0x7b, 0x55 }, //##Third_8bits_of_MBIST_User_Program_Odd
	{ 0x7c, 0x55 }, //##Fourth_8bits_of_MBIST_User_Program_Odd
	{ 0x7d, 0xfe }, //##Error_register
	{ 0x7e, 0xfe }, //##Error_latch_register
	{ 0x7f, 0x00 }, //##Error_clear_register
	{ 0x80, 0x00 }, //##Protection_register_set
	{ 0x81, 0x00 }, //##Memory_MBIST_status
	{ 0x82, 0x00 }, //##PWM_output_control
	{ 0x83, 0x00 }, //##Testmode_control_register
	{ 0x84, 0x00 }, //##RAM1_test_register_address
	{ 0x85, 0x00 }, //##First_8bits_of_RAM1_data
};

static int m_ram1_tab[][5] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ1_A1
	{ 0x01, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ1_A2
	{ 0x02, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ1_B1
	{ 0x03, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ1_B2
	{ 0x04, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_EQ1_A0
	{ 0x05, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ2_A1
	{ 0x06, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ2_A2
	{ 0x07, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ2_B1
	{ 0x08, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ2_B2
	{ 0x09, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_EQ2_A0
	{ 0x0a, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ3_A1
	{ 0x0b, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ3_A2
	{ 0x0c, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ3_B1
	{ 0x0d, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ3_B2
	{ 0x0e, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_EQ3_A0
	{ 0x0f, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ4_A1
	{ 0x10, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ4_A2
	{ 0x11, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ4_B1
	{ 0x12, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ4_B2
	{ 0x13, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_EQ4_A0
	{ 0x14, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ5_A1
	{ 0x15, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ5_A2
	{ 0x16, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ5_B1
	{ 0x17, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ5_B2
	{ 0x18, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_EQ5_A0
	{ 0x19, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ6_A1
	{ 0x1a, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ6_A2
	{ 0x1b, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ6_B1
	{ 0x1c, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ6_B2
	{ 0x1d, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_EQ6_A0
	{ 0x1e, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ7_A1
	{ 0x1f, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ7_A2
	{ 0x20, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ7_B1
	{ 0x21, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ7_B2
	{ 0x22, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_EQ7_A0
	{ 0x23, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ8_A1
	{ 0x24, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ8_A2
	{ 0x25, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ8_B1
	{ 0x26, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ8_B2
	{ 0x27, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_EQ8_A0
	{ 0x28, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ9_A1
	{ 0x29, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ9_A2
	{ 0x2a, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ9_B1
	{ 0x2b, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ9_B2
	{ 0x2c, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_EQ9_A0
	{ 0x2d, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ10_A1
	{ 0x2e, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ10_A2
	{ 0x2f, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ10_B1
	{ 0x30, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ10_B2
	{ 0x31, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_EQ10_A0
	{ 0x32, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ11_A1
	{ 0x33, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ11_A2
	{ 0x34, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ11_B1
	{ 0x35, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ11_B2
	{ 0x36, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_EQ11_A0
	{ 0x37, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ12_A1
	{ 0x38, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ12_A2
	{ 0x39, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ12_B1
	{ 0x3a, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ12_B2
	{ 0x3b, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_EQ12_A0
	{ 0x3c, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ13_A1
	{ 0x3d, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ13_A2
	{ 0x3e, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ13_B1
	{ 0x3f, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ13_B2
	{ 0x40, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_EQ13_A0
	{ 0x41, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ14_A1
	{ 0x42, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ14_A2
	{ 0x43, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ14_B1
	{ 0x44, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ14_B2
	{ 0x45, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_EQ14_A0
	{ 0x46, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ15_A1
	{ 0x47, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ15_A2
	{ 0x48, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ15_B1
	{ 0x49, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ15_B2
	{ 0x4a, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_EQ15_A0
	{ 0x4b, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ16_A1
	{ 0x4c, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ16_A2
	{ 0x4d, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ16_B1
	{ 0x4e, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_EQ16_B2
	{ 0x4f, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_EQ16_A0
	{ 0x50, 0x07, 0xff, 0xff, 0xf0 }, //##Channel_1_Mixer1
	{ 0x51, 0x00, 0x00, 0x00, 0x00 }, //##Channel_1_Mixer2
	{ 0x52, 0x00, 0x7e, 0x88, 0xe0 }, //##Channel_1_Prescale
	{ 0x53, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_Postscale
	{ 0x54, 0x02, 0x00, 0x00, 0x00 }, //##CH1.2_Power_Clipping
	{ 0x55, 0x00, 0x00, 0x01, 0xa0 }, //##Noise_Gate_Attack_Level
	{ 0x56, 0x00, 0x00, 0x05, 0x30 }, //##Noise_Gate_Release_Level
	{ 0x57, 0x00, 0x01, 0x00, 0x00 }, //##DRC1_Energy_Coefficient
	{ 0x58, 0x00, 0x01, 0x00, 0x00 }, //##DRC2_Energy_Coefficient
	{ 0x59, 0x00, 0x01, 0x00, 0x00 }, //##DRC3_Energy_Coefficient
	{ 0x5a, 0x00, 0x01, 0x00, 0x00 }, //##DRC4_Energy_Coefficient
	{ 0x5b, 0x00, 0x00, 0x19, 0x04 }, //##DRC1_Power_Meter
	{ 0x5c, 0x00, 0x00, 0x00, 0x00 }, //##DRC3_Power_Meter
	{ 0x5d, 0x00, 0x00, 0x00, 0x00 }, //##DRC5_Power_Meter
	{ 0x5e, 0x00, 0x00, 0x00, 0x00 }, //##DRC7_Power_Meter
	{ 0x5f, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_DRC_GAIN1
	{ 0x60, 0x02, 0x00, 0x00, 0x00 }, //##Channel_1_DRC_GAIN2
	{ 0x61, 0x0e, 0x00, 0x00, 0x00 }, //##Channel_1_DRC_GAIN3
	{ 0x62, 0x0e, 0x01, 0xc0, 0x70 }, //##DRC1_FF_threshold
	{ 0x63, 0x02, 0x00, 0x00, 0x00 }, //##DRC1_FF_slope
	{ 0x64, 0x00, 0x00, 0x40, 0x00 }, //##DRC1_FF_aa
	{ 0x65, 0x00, 0x00, 0x40, 0x00 }, //##DRC1_FF_da
	{ 0x66, 0x0e, 0x01, 0xc0, 0x70 }, //##DRC2_FF_threshold
	{ 0x67, 0x02, 0x00, 0x00, 0x00 }, //##DRC2_FF_slope
	{ 0x68, 0x00, 0x00, 0x40, 0x00 }, //##DRC2_FF_aa
	{ 0x69, 0x00, 0x00, 0x40, 0x00 }, //##DRC2_FF_da
	{ 0x6a, 0x0e, 0x01, 0xc0, 0x70 }, //##DRC3_FF_threshold
	{ 0x6b, 0x02, 0x00, 0x00, 0x00 }, //##DRC3_FF_slope
	{ 0x6c, 0x00, 0x00, 0x40, 0x00 }, //##DRC3_FF_aa
	{ 0x6d, 0x00, 0x00, 0x40, 0x00 }, //##DRC3_FF_da
	{ 0x6e, 0x0e, 0x01, 0xc0, 0x70 }, //##DRC4_FF_threshold
	{ 0x6f, 0x02, 0x00, 0x00, 0x00 }, //##DRC4_FF_slope
	{ 0x70, 0x00, 0x00, 0x40, 0x00 }, //##DRC4_FF_aa
	{ 0x71, 0x00, 0x00, 0x40, 0x00 }, //##DRC4_FF_da
	{ 0x72, 0x00, 0x7f, 0xf8, 0x01 }, //##DRC1_gain
	{ 0x73, 0x00, 0x00, 0x00, 0x00 }, //##DRC3_gain
	{ 0x74, 0x00, 0x00, 0x00, 0x00 }, //##DRC5_gain
	{ 0x75, 0x00, 0x00, 0x00, 0x00 }, //##DRC7_gain
	{ 0x76, 0x00, 0x80, 0x00, 0x00 }, //##I2SO_LCH_gain
	{ 0x77, 0x02, 0x00, 0x00, 0x00 }, //##SRS_gain
};

static int m_ram2_tab[][5] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ1_A1
	{ 0x01, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ1_A2
	{ 0x02, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ1_B1
	{ 0x03, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ1_B2
	{ 0x04, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_EQ1_A0
	{ 0x05, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ2_A1
	{ 0x06, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ2_A2
	{ 0x07, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ2_B1
	{ 0x08, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ2_B2
	{ 0x09, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_EQ2_A0
	{ 0x0a, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ3_A1
	{ 0x0b, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ3_A2
	{ 0x0c, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ3_B1
	{ 0x0d, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ3_B2
	{ 0x0e, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_EQ3_A0
	{ 0x0f, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ4_A1
	{ 0x10, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ4_A2
	{ 0x11, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ4_B1
	{ 0x12, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ4_B2
	{ 0x13, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_EQ4_A0
	{ 0x14, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ5_A1
	{ 0x15, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ5_A2
	{ 0x16, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ5_B1
	{ 0x17, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ5_B2
	{ 0x18, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_EQ5_A0
	{ 0x19, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ6_A1
	{ 0x1a, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ6_A2
	{ 0x1b, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ6_B1
	{ 0x1c, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ6_B2
	{ 0x1d, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_EQ6_A0
	{ 0x1e, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ7_A1
	{ 0x1f, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ7_A2
	{ 0x20, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ7_B1
	{ 0x21, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ7_B2
	{ 0x22, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_EQ7_A0
	{ 0x23, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ8_A1
	{ 0x24, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ8_A2
	{ 0x25, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ8_B1
	{ 0x26, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ8_B2
	{ 0x27, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_EQ8_A0
	{ 0x28, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ9_A1
	{ 0x29, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ9_A2
	{ 0x2a, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ9_B1
	{ 0x2b, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ9_B2
	{ 0x2c, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_EQ9_A0
	{ 0x2d, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ10_A1
	{ 0x2e, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ10_A2
	{ 0x2f, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ10_B1
	{ 0x30, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ10_B2
	{ 0x31, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_EQ10_A0
	{ 0x32, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ11_A1
	{ 0x33, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ11_A2
	{ 0x34, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ11_B1
	{ 0x35, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ11_B2
	{ 0x36, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_EQ11_A0
	{ 0x37, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ12_A1
	{ 0x38, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ12_A2
	{ 0x39, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ12_B1
	{ 0x3a, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ12_B2
	{ 0x3b, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_EQ12_A0
	{ 0x3c, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ13_A1
	{ 0x3d, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ13_A2
	{ 0x3e, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ13_B1
	{ 0x3f, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ13_B2
	{ 0x40, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_EQ13_A0
	{ 0x41, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ14_A1
	{ 0x42, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ14_A2
	{ 0x43, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ14_B1
	{ 0x44, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ14_B2
	{ 0x45, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_EQ14_A0
	{ 0x46, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ15_A1
	{ 0x47, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ15_A2
	{ 0x48, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ15_B1
	{ 0x49, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ15_B2
	{ 0x4a, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_EQ15_A0
	{ 0x4b, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ16_A1
	{ 0x4c, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ16_A2
	{ 0x4d, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ16_B1
	{ 0x4e, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_EQ16_B2
	{ 0x4f, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_EQ16_A0
	{ 0x50, 0x00, 0x00, 0x00, 0x00 }, //##Channel_2_Mixer1
	{ 0x51, 0x07, 0xff, 0xff, 0xf0 }, //##Channel_2_Mixer2
	{ 0x52, 0x00, 0x7e, 0x88, 0xe0 }, //##Channel_2_Prescale
	{ 0x53, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_Postscale
	{ 0x54, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x55, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x56, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x57, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x58, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x59, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x5a, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x5b, 0x00, 0x00, 0x18, 0x88 }, //##DRC2_Power_Meter
	{ 0x5c, 0x00, 0x00, 0x00, 0x00 }, //##DRC4_Power_Mete
	{ 0x5d, 0x00, 0x00, 0x00, 0x00 }, //##DRC6_Power_Meter
	{ 0x5e, 0x00, 0x00, 0x00, 0x00 }, //##DRC8_Power_Meter
	{ 0x5f, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_DRC_GAIN1
	{ 0x60, 0x02, 0x00, 0x00, 0x00 }, //##Channel_2_DRC_GAIN2
	{ 0x61, 0x0e, 0x00, 0x00, 0x00 }, //##Channel_2_DRC_GAIN3
	{ 0x62, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x63, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x64, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x65, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x66, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x67, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x68, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x69, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x6a, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x6b, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x6c, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x6d, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x6e, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x6f, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x70, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x71, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
	{ 0x72, 0x00, 0x00, 0x00, 0x00 }, //##DRC2_gain
	{ 0x73, 0x00, 0x00, 0x00, 0x00 }, //##DRC4_gain
	{ 0x74, 0x00, 0x00, 0x00, 0x00 }, //##DRC6_gain
	{ 0x75, 0x00, 0x00, 0x00, 0x00 }, //##DRC8_gain
	{ 0x76, 0x00, 0x80, 0x00, 0x00 }, //##I2SO_RCH_gain
	{ 0x77, 0x00, 0x00, 0x00, 0x00 }, //##Reserve
};

#endif /* __AD82128_H__ */
