#!/bin/sh
enable=0
AA_DEFAULT=/etc/apparmor/apparmor_generic_defaults
AAR_ENTRY_CNT=/tmp/aar_marker.txt
AAR_MESG_LOG=/tmp/aar_msg.txt
ACTIVE_PROFILES=`cat /sys/kernel/security/apparmor/profiles`
loop_time=1800
VMESG_FILE=/opt/logs/messages.txt
if [ ! -z "$ACTIVE_PROFILES" ]; then
     enable=1
fi
sleep 60
while [ $enable -eq 1 ]
do
   grep -i "$(date -u +%F'T'%H:%M)" /opt/logs/syslog_fallback.log > ${AAR_MESG_LOG}
   while read line; do
         profile=`echo $line | cut -d : -f1`
         count=`cat $AAR_MESG_LOG | grep profile | grep $profile | wc -l`;
         if [ "$profile" = "global" ]; then
               line=:$count
         else
               line=,$count
         fi
         echo -n $line >> $AAR_ENTRY_CNT
   done  < $AA_DEFAULT
   echo -n -e "`date -u "+%Y-%m-%dT%T.%3NZ"` APPARMOR_ENTRY_COUNT`cat $AAR_ENTRY_CNT`\n" >> ${VMESG_FILE}   
   rm -f ${AAR_MESG_LOG}
   rm -f ${AAR_ENTRY_CNT}
   sleep $loop_time
done
