/*
 * AdaptationSetStream.h
 *****************************************************************************
 * Copyright (C) 2013, bitmovin Softwareentwicklung OG, All Rights Reserved
 *
 * Email: libdash-dev@vicky.bitmovin.net
 *
 * This source code and its use and distribution, is subject to the terms
 * and conditions of the applicable license agreement.
 *****************************************************************************/

#ifndef LIBDASH_FRAMEWORK_MPD_ADAPTATIONSETSTREAM_H_
#define LIBDASH_FRAMEWORK_MPD_ADAPTATIONSETSTREAM_H_

#include "IRepresentationStream.h"
#include "IRepresentation.h"
#include "IMPD.h"
#include "IPeriod.h"
#include "IAdaptationSet.h"
#include "RepresentationStreamFactory.h"
#include "BaseUrlResolver.h"

namespace libdash
{
    namespace framework
    {
        namespace mpd
        {
            class AdaptationSetStream
            {
                public:
                    AdaptationSetStream             (dash::mpd::IMPD *mpd, dash::mpd::IPeriod *period, dash::mpd::IAdaptationSet *adaptationSet);
                    virtual ~AdaptationSetStream    ();

                    IRepresentationStream*      GetRepresentationStream             (dash::mpd::IRepresentation *representation);
		      dash::mpd::ISegment*        GetInitializationSegment        () ;
                private:
                    RepresentationStreamType    DetermineRepresentationStreamType   (dash::mpd::IRepresentation *representation);
                    void                        Initialize                          ();

                    std::map<dash::mpd::IRepresentation *, IRepresentationStream *> representations;
                    dash::mpd::IMPD                                                 *mpd;
                    dash::mpd::IPeriod                                              *period;
                    dash::mpd::IAdaptationSet                                       *adaptationSet;
                    
		      std::vector<dash::mpd::IBaseUrl *>  baseUrls;
            };
        }
    }
}
#endif /* LIBDASH_FRAMEWORK_MPD_ADAPTATIONSETSTREAM_H_ */
