function shouldBe(actual, expected) {
    if (actual !== expected)
        throw new Error('bad value: ' + actual + " " + expected);
}

const nf = new Intl.NumberFormat("en-US");
const nf2 = new Intl.NumberFormat("ja-JP");
shouldBe(nf.format("54.321"), `54.321`);
if (nf.formatRange) {
    shouldBe(nf.formatRange("-54.321", "+54.321"), `-54.321 – 54.321`);
    shouldBe(nf.formatRange("-54.321", "20000000000000000000000000000000000000000"), `-54.321 – 20,000,000,000,000,000,000,000,000,000,000,000,000,000`);
    shouldBe(nf.formatRange("-0", "0"), `-0 – 0`);
    shouldBe(nf.formatRange("-0", "1000000000000000000000000000000000000000000000"), `-0 – 1,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000`);
    shouldBe(nf2.formatRange("-54.321", "+54.321"), `-54.321 ～ 54.321`);
    shouldBe(nf2.formatRange("-54.321", "20000000000000000000000000000000000000000"), `-54.321 ～ 20,000,000,000,000,000,000,000,000,000,000,000,000,000`);
    shouldBe(nf2.formatRange("-0", "0"), `-0 ～ 0`);
    shouldBe(nf2.formatRange("-0", "1000000000000000000000000000000000000000000000"), `-0 ～ 1,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000`);
}
if (nf.formatRangeToParts) {
    shouldBe(JSON.stringify(nf.formatRangeToParts("-54.321", "+54.321")), `[{"type":"minusSign","value":"-","source":"startRange"},{"type":"integer","value":"54","source":"startRange"},{"type":"decimal","value":".","source":"startRange"},{"type":"fraction","value":"321","source":"startRange"},{"type":"literal","value":" – ","source":"shared"},{"type":"integer","value":"54","source":"endRange"},{"type":"decimal","value":".","source":"endRange"},{"type":"fraction","value":"321","source":"endRange"}]`);
    shouldBe(JSON.stringify(nf.formatRangeToParts("-54.321", "20000000000000000000000000000000000000000")), `[{"type":"minusSign","value":"-","source":"startRange"},{"type":"integer","value":"54","source":"startRange"},{"type":"decimal","value":".","source":"startRange"},{"type":"fraction","value":"321","source":"startRange"},{"type":"literal","value":" – ","source":"shared"},{"type":"integer","value":"20","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"}]`);
    shouldBe(JSON.stringify(nf.formatRangeToParts("-0", "0")), `[{"type":"minusSign","value":"-","source":"startRange"},{"type":"integer","value":"0","source":"startRange"},{"type":"literal","value":" – ","source":"shared"},{"type":"integer","value":"0","source":"endRange"}]`);
    shouldBe(JSON.stringify(nf.formatRangeToParts("-0", "1000000000000000000000000000000000000000000000")), `[{"type":"minusSign","value":"-","source":"startRange"},{"type":"integer","value":"0","source":"startRange"},{"type":"literal","value":" – ","source":"shared"},{"type":"integer","value":"1","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"}]`);
    shouldBe(JSON.stringify(nf2.formatRangeToParts("-54.321", "+54.321")), `[{"type":"minusSign","value":"-","source":"startRange"},{"type":"integer","value":"54","source":"startRange"},{"type":"decimal","value":".","source":"startRange"},{"type":"fraction","value":"321","source":"startRange"},{"type":"literal","value":" ～ ","source":"shared"},{"type":"integer","value":"54","source":"endRange"},{"type":"decimal","value":".","source":"endRange"},{"type":"fraction","value":"321","source":"endRange"}]`);
    shouldBe(JSON.stringify(nf2.formatRangeToParts("-54.321", "20000000000000000000000000000000000000000")), `[{"type":"minusSign","value":"-","source":"startRange"},{"type":"integer","value":"54","source":"startRange"},{"type":"decimal","value":".","source":"startRange"},{"type":"fraction","value":"321","source":"startRange"},{"type":"literal","value":" ～ ","source":"shared"},{"type":"integer","value":"20","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"}]`);
    shouldBe(JSON.stringify(nf2.formatRangeToParts("-0", "0")), `[{"type":"minusSign","value":"-","source":"startRange"},{"type":"integer","value":"0","source":"startRange"},{"type":"literal","value":" ～ ","source":"shared"},{"type":"integer","value":"0","source":"endRange"}]`);
    shouldBe(JSON.stringify(nf2.formatRangeToParts("-0", "1000000000000000000000000000000000000000000000")), `[{"type":"minusSign","value":"-","source":"startRange"},{"type":"integer","value":"0","source":"startRange"},{"type":"literal","value":" ～ ","source":"shared"},{"type":"integer","value":"1","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"},{"type":"group","value":",","source":"endRange"},{"type":"integer","value":"000","source":"endRange"}]`);
}
