// Copyright 2017, the V8 project authors. All rights reserved.
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//     * Neither the name of Google Inc. nor the names of its
//       contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Generated by tools/bigint-tester.py.

var data = [{
  a: 0xae965ffc8f83bd714a21a1378b154a7n,
  b: -0xe8165b619eeefben,
  r: -0xae965ffc8f83bd71a237fa5615fbb1bn
}, {
  a: 0xa2c1eb9f31900d88134f609536114cbadc932a0ffae26f391n,
  b: 0xd90f8c5522d13f831fcec03e045d8e31d4c789aa846n,
  r: 0xa2c1eb463e1c58aac270e38af8d172be811d1bdb3d6bc5bd7n
}, {
  a: 0x19c2f60883fc00abfa0880556534b0193b9594405f51b6473782d3bbd241e026ddddcn,
  b: -0x279578d6eb73f0918543db54abd870n,
  r: -0x19c2f60883fc00abfa0880556534b0193b95944226063b2980bddaa3867c556c605b4n
}, {
  a: -0x173825929f3fcdbn,
  b: 0x35c1d4a129eb5d9e0db730e7db49ac91669dn,
  r: -0x35c1d4a129eb5d9e0db73194591085629a48n
}, {
  a: 0xb3a87593979644cb767b9bf5619a45a0e948e53d754a507n,
  b: 0x12f9ee37e374507276ab10d4deb148f04beadd4109dbde3b64157b6a54en,
  r: 0x12f9ee37e374e3da033887429a7a3e8bd01fbcdb4c7b377381280e20049n
}, {
  a: -0xb0ac2e806n,
  b: -0xd56b96d2efc632eef2520c903f502783cc6027bb51e1bc4acn,
  r: 0xd56b96d2efc632eef2520c903f502783cc6027bbe14d92caen
}, {
  a: -0x6ee18dd17f9d223n,
  b: -0xf7bf332dc3ef5bb8b5a0a7354bea86146n,
  r: 0xf7bf332dc3ef5bb8b5ce46b89a951b367n
}, {
  a: 0x5e0889f4382c8d08e4cddf6c52ff875n,
  b: 0xc1ca88c371eefd5f6c42f1639f7d5bbb3c2542abe56337a006b8b1n,
  r: 0xc1ca88c371eefd5f6c42f1667ff5c4f8beed9225a9bec1652940c4n
}, {
  a: -0x16e6278164n,
  b: 0xd29e6922b8fac32eb959d4d82007729266dn,
  r: -0xd29e6922b8fac32eb959d4d8216910ea70fn
}, {
  a: 0x96454bd7d6733e1424c487e0fdac5c76a22ba5a023022107d10a8c121886en,
  b: 0xcafb7183n,
  r: 0x96454bd7d6733e1424c487e0fdac5c76a22ba5a023022107d10a80bdaf9edn
}, {
  a: -0x1e93a1a045c4939322faddeb95ed5a053fede7n,
  b: -0x7458f5de27ab869ec3406648a1e4194dac9ac9c34bn,
  r: 0x7458eb4d860bc35a50d344b27c0f8ca0f69ff62eacn
}, {
  a: -0x2b691056aa447e31f38be4d2dc3817b85837f0e99d4f754b644254b11963ff4b62n,
  b: -0x5dd62cc680fdb72f5f1a3a90beac18d39922f9e182d07a3f739a3a00673abn,
  r: 0x2b69158bc888163e28f911237f911c5299bac97bb2d16d6663e1a388bac3f938cbn
}, {
  a: -0x4a265b62697ebdde4bcc0e5df006ba1eb2fcc16ea2d6aff4e93a35f819aeb2f5f10n,
  b: 0xebd76c23bf20e8021d4n,
  r: -0x4a265b62697ebdde4bcc0e5df006ba1eb2fcc16ea2d6aff402ed59dba68e5af7edcn
}, {
  a: 0x3c723def6ee9a0536ec54cbc985403a55cf1de1n,
  b: 0n,
  r: 0x3c723def6ee9a0536ec54cbc985403a55cf1de1n
}, {
  a: 0x772d4714556d558a831fc39b55d97cda8d32de5fabed33cbf6d21f1b0b9d3bf79dbn,
  b: -0xa98d9n,
  r: -0x772d4714556d558a831fc39b55d97cda8d32de5fabed33cbf6d21f1b0b9d3b5e104n
}, {
  a: -0x9e3ab97c029f03e34e17f25n,
  b: 0x84ac9b30d42277ea116b5ea6f7a4301c2dcd3066n,
  r: -0x84ac9b30d42277ea1888f531378dc022192c4f43n
}, {
  a: -0x60305182d1e5f4a102fff7adeac705a75465753d62cn,
  b: -0x37n,
  r: 0x60305182d1e5f4a102fff7adeac705a75465753d61dn
}, {
  a: 0x7b9335bf9a18463f1b490244bdad2b7beb934a5242a4125726ffdf600n,
  b: -0x27411e47edb837e24c92a4888a69a75fb788114n,
  r: -0x7b9335bf9a18463f1b6e435afa40934c09dfd8f6ca2e7bf0794857714n
}, {
  a: 0xf6f087ab9639d0f88a4c8c7n,
  b: 0xf02bd083f821bc3da2b81bf76875a7c1d7ec64e1b567b5740a1c464b4aa9eadn,
  r: 0xf02bd083f821bc3da2b81bf76875a7c1d7ec64e1439732df9c2596b3c0e566an
}, {
  a: 0x82ae10eb878e1acdf7fd3e9d2e59f2f9n,
  b: -0xf0aa6n,
  r: -0x82ae10eb878e1acdf7fd3e9d2e56f85dn
}, {
  a: 0x7cn,
  b: 0xe4d926586060d877a30fee2421436705f0bcf8df685ccbd8n,
  r: 0xe4d926586060d877a30fee2421436705f0bcf8df685ccba4n
}, {
  a: 0xe856520151972d32be60d88bdb4210da1d51c011n,
  b: -0xadd24b41d9fb6dce29e917fe4317d88257adbde3f12e3b8eb73a7db02n,
  r: -0xadd24b41d9fb6dce276c72de560eaa517c4bb06b4c9a1a8316ef61b11n
}, {
  a: -0x46fb3f7ac370b0167d2954c810n,
  b: -0x121596a992e74da0973cd1678825bf7a3b279204227d7b3b20368462feen,
  r: 0x121596a992e74da0973cd1678825bf7a3f4821f38e4a703a47e4112e7e2n
}, {
  a: 0x76e2e3958401e98af7c20aa5c6325fbac272465303a410b69e0a6c8683796dbaf2224n,
  b: -0xb9d7f7cfe384bf573590d392073d462aa47d8a9d96fd5e66en,
  r: -0x76e2e3958401e98af7c2b37231fdbc3e7d2573c3d036178bd820c8fb09e4fb47ac44an
}, {
  a: -0x5n,
  b: -0x5555c43a3b184af2b5b1ae4n,
  r: 0x5555c43a3b184af2b5b1ae7n
}, {
  a: -0x4b958n,
  b: 0n,
  r: -0x4b958n
}, {
  a: -0x9n,
  b: -0xd5a151c136445f8bn,
  r: 0xd5a151c136445f82n
}, {
  a: 0x33c7cf82e112588ff16b07b9n,
  b: 0x9dd54e232e7fd1e0f84d7d650e03n,
  r: 0x9dd57de4e1fd30f2a0c28c0e09ban
}, {
  a: -0x86f0d49d3cbb7807983274225ed530879401e9fb351a16b60a6fn,
  b: -0x7015ab56d7e93a756a20n,
  r: 0x86f0d49d3cbb7807983274225ed53087e41442ade2f32cc36071n
}, {
  a: 0x9ca83a34c2a5a51515fe43dd91a4f1efb7a205e40484cf72f0baf30ae6d986cdb2b779n,
  b: -0xae883087e7140f3n,
  r: -0x9ca83a34c2a5a51515fe43dd91a4f1efb7a205e40484cf72f0baf3000e5a8eb3c3f78cn
}, {
  a: 0x198df935c17e89efa5cdf4b60cd83n,
  b: 0x6c89278cbd9e779152e20dfbbda5c984f17fd81f5d6552f5e405cde0e2216b6d00dn,
  r: 0x6c89278cbd9e779152e20dfbbda5c984f17fd806d09c67349a8c22452fd5dd61d8en
}, {
  a: 0x9c9f7b0ad9100845090c572ae3bc3cn,
  b: 0x1e781be66debcd88n,
  r: 0x9c9f7b0ad910085b7117b1470871b4n
}, {
  a: -0xd7054e1a68f4b0d3682an,
  b: -0x9141a6ff1f8186af2d4ab6d6f3a36061564efbe6b9a7c349ee2f296449f918061n,
  r: 0x9141a6ff1f8186af2d4ab6d6f3a36061564efbe6b9a7ce39bace8feb02f42e849n
}, {
  a: -0xf441e9aca15d709a9708488d7066ed5f47b1acf8475e1n,
  b: 0x82bffe4eb0874ba0f84e80d11de6aaf5n,
  r: -0xf441e9aca15d78b168eca38504dce2dbafbcbd262df16n
}, {
  a: 0x3ad2add2bcan,
  b: -0x52f12703ad969abe4979886fae3108a653480f8edf652da498a6faf21b6n,
  r: -0x52f12703ad969abe4979886fae3108a653480f8edf652da4a2745720a80n
}, {
  a: -0xb076dc088fd3n,
  b: 0xae0cac7a2b8732ff8d68c74d0bcf6dn,
  r: -0xae0cac7a2b8732ff8dd8b1910340c0n
}, {
  a: -0x1e0d65c075482b851716ce6c5f940fd5an,
  b: 0x621dbfd16662fa45a0fba14277b5n,
  r: -0x1e0d63e1aeb53de338b29463e58028aedn
}, {
  a: 0xf792d622a35c54b10008d88d733af9dd5fcd0331489adbd3a489cb6f0417085n,
  b: 0x95211539b3n,
  r: 0xf792d622a35c54b10008d88d733af9dd5fcd0331489adbd3a489c23d1544936n
}, {
  a: -0x72285533db1754e1de5ccb988803c14d2222335c8c07495344541063f3088ef8n,
  b: 0n,
  r: -0x72285533db1754e1de5ccb988803c14d2222335c8c07495344541063f3088ef8n
}, {
  a: -0xcc7c485db4fc85d21c50dbe2080486b85764637203an,
  b: -0x646417701d083839902e37aa5315c77565d00d803fb1abba96d8418665n,
  r: 0x646417701d08383557eab2711cdd9a54a0ddb3a0bff9c03fe09e76a65dn
}, {
  a: 0xdcb1fbf8fd4967e46fa799c3be588062fe9a9a91139e795f3b454ecf9a32a0374ba3n,
  b: -0xa5307286a3b5b34c7d0545431a894886f64c7ae28956315d9e0eab79n,
  r: -0xdcb1fbf8fd49c2d41d213a760d14fd67bbd980185b188f1341a7c799ab6f3e39e0dcn
}, {
  a: 0x8ae90d66c7e2258d6a5344c627dcc49e947d2d2415c8caaf0bfc1e23cn,
  b: -0xaf1c78d5d6ec9f6f8f7cc18n,
  r: -0x8ae90d66c7e2258d6a5344c627dcc49e94d2315cc01e2630647362e2cn
}, {
  a: -0x38bafb613e336153c54f88ecc9bben,
  b: -0x9c62ee53297db6198b59d97f42071dd287df3b2a90e0ce8n,
  r: 0x9c62ee53297db6198b61638423392eb3d41a74a27c2975an
}, {
  a: -0x4a9a433a97108e4dd6b15526128ccb0418e8c2n,
  b: 0x7a66fd027c8ccaea0d68c6b29e6e8d551713aaa50d7d2an,
  r: -0x7a66fd02361689d09a7848ff48dfd873059f61a11595ecn
}, {
  a: -0x7b4769f50fb62300a89449b8d7a6c1b493da2en,
  b: 0xb1d93a1aa4699b47d38ce80061d4bd8f8732686d9f0ab656a0e60f0a907n,
  r: -0xb1d93a1aa4699b47d38cefb4174bed74e50262e4db913b2cccfd463732bn
}, {
  a: 0x7bfab6d962777818c4e714f56416632b3ccf74b76ea481bf501cdc757n,
  b: -0xa6ee73a510a0d0935d1792f2a60ee5f1dae7cde0n,
  r: -0x7bfab6d962777818ce89f3cf351c6e22091e0d9844c46fe04db2a0a89n
}, {
  a: 0x5c898d13b8f2cfd6e6f6fc82a5ecfn,
  b: -0x8baa0d4ea69048e3a3d1b8121d75d98bbn,
  r: -0x8baa51c72b83f0116c075ee4e1f77c676n
}, {
  a: 0xd36835de9d665014cef741fc94ccb0829e06c1ab5n,
  b: 0xa25ccb01317829243fea378c7877n,
  r: 0xd36835de9d665a31024752eb165ef37c3d7e062c2n
}, {
  a: 0x1b28f180e358bb97e2770e2dd459e02553763ba6c15fff3d380f201d6n,
  b: -0x5b973238c552dd80258cb3bca6c7a6e4d030b8bc6032a636bd66d768bn,
  r: -0x40bfc3b8260a6617c7fbbd91729e46c18346831aa16d590b8569f775dn
}, {
  a: 0x5014de3cc36cc2a6366b4b6ef81786n,
  b: -0x7c96c796030aec9da92c660ecde2baa6fc6dfbe1441ebe4316471900233n,
  r: -0x7c96c796030aec9da92c660ecde2bfa7b18e37d78834dd25a2f1f6815b5n
}, {
  a: 0x97a15n,
  b: 0x3n,
  r: 0x97a16n
}, {
  a: 0x83acf52eb820b78c174412f9d53d245bfae845dc82d95fe7ccc66ddcaa0f35b31n,
  b: 0x4ea9b599n,
  r: 0x83acf52eb820b78c174412f9d53d245bfae845dc82d95fe7ccc66ddcaee5aeea8n
}, {
  a: 0xe26a487ed3a964182305a85413358fbb5fc6n,
  b: 0x6cdc2fa2603d69f15257c58d1f3ff53f1544762n,
  r: 0x6cd20906e7d0536713d5f5d79a7ec667eef18a4n
}, {
  a: -0xf1ccf331f522e1d8e3368f3f05558a73325an,
  b: 0x1b8ae7a6bf073630daaf4cbc103ed11bb4a0875d1ba34c8e8f310bcde7abcn,
  r: -0x1b8ae7a6bf073630daaf4cbc1f221e28abf2a9409590247d7f64536ad48e6n
}, {
  a: 0xc66cb8db92483df226c4c976f4fdf78fn,
  b: 0xec5c4b63ffd2f3dc35266370c7bf4805bdb1d7a13ffca0ddef66875006bd6n,
  r: 0xec5c4b63ffd2f3dc35266370c7bf4463763c6e85bc2382b1a3f1e81fd9c59n
}, {
  a: 0xac631cb79ed2n,
  b: 0xc0c14b945c94cc1a2fn,
  r: 0xc0c14b383f887b84fdn
}, {
  a: -0x1517f99fd3aa20607d847e9416b4dd76n,
  b: 0xfbbdbdb25091d38be64ff346f29d8e1fn,
  r: -0xeeaa442d833bf3eb9bcb8dd2e429536bn
}, {
  a: -0xc793bbcd96c0329d4d5fb23df968310f2a759e6dbfd934f4398f1a70f602c23c9b431cn,
  b: 0xd0b0n,
  r: -0xc793bbcd96c0329d4d5fb23df968310f2a759e6dbfd934f4398f1a70f602c23c9b93acn
}, {
  a: 0x8f4e2bn,
  b: -0x1d09b4136f8d13b482906cc2n,
  r: -0x1d09b4136f8d13b4821f22ebn
}, {
  a: -0x9399440afd79fd8485300aff4661fe23263c98eb9n,
  b: -0x6fd46c0976438b5d05773a5ac70fd40411669bc7cb03f9917an,
  r: 0x6fd46c097f7a1f1daaa0a5828f5cd4abe5008425f960301fc1n
}, {
  a: -0x1a793e3e790f64e33458f12dfca03n,
  b: -0xe32c45bad11418c212n,
  r: 0x1a793e3e790156276ff5e06c70813n
}, {
  a: 0x6n,
  b: -0xbf040503ea77b8ef3e22f9157b56906n,
  r: -0xbf040503ea77b8ef3e22f9157b56904n
}, {
  a: -0xa5247659482fc2060d191f44c8cbb492625b5f8b61fe53cbn,
  b: -0x73ce58200c9c087676655f6cf8a2cn,
  r: 0xa5247659482fc2060d1e23a14acb7d52e53c39de9731d9e1n
}, {
  a: -0xbf8ec0cecce011724d454d59753701b0b292407ae55a6ec03fa08fn,
  b: 0x8e24b36ccb928ec3d3a53c2973346e239c7eeb8a74cn,
  r: -0xbf8ec0cecce8f3397b89f471990a3be37005733c0763a92e8707c3n
}, {
  a: 0xf818dc5n,
  b: -0x5ff32c30619b9533014526f55db2eef602f28ca50e57a1e45f58f344e86f2e6f2dn,
  r: -0x5ff32c30619b9533014526f55db2eef602f28ca50e57a1e45f58f344e860afe2ean
}, {
  a: 0x446b728604b9fa40n,
  b: 0x42ccef6971c9d0ade6e3e8ef4a4954e4bd5882817n,
  r: 0x42ccef6971c9d0ade6e3e8ef4e0fe3ccdd131d257n
}, {
  a: -0x184dd1n,
  b: -0x7b9674fb5952a6505b34f647379df5429135a646cb91e318aaec0d8599d1bae0fn,
  r: 0x7b9674fb5952a6505b34f647379df5429135a646cb91e318aaec0d8599d03e3den
}, {
  a: 0xce5d616e26ea37d87n,
  b: -0x38a816859b3f7666cd7dded82ff3n,
  r: -0x38a816859b3393b0db9fb07b5276n
}, {
  a: 0xf1f64e7213dn,
  b: 0x1a22391c873b99c1a9f2c032680ea9e50e499fe077aba6f307cb9d1c4f4ccd3n,
  r: 0x1a22391c873b99c1a9f2c032680ea9e50e499fe077aba6f307cb6cea013edeen
}, {
  a: 0x386925ffn,
  b: -0x91afc1e00a6fc9ff34142a72cn,
  r: -0x91afc1e00a6fc9ff3792b82d5n
}, {
  a: -0x7e72418a453d3d2f65f9384f85506bdd88cdcabd2a200df3639c522803867b6204064n,
  b: -0xfd8e9d63af202614de5fc50b8a6d9fcb3d3f29db4dn,
  r: 0x7e72418a453d3d2f65f9384f855fb3345ef738bf4b6de80f3324f4f1ff35a89099b2fn
}, {
  a: -0x5339f5e7b91a59ea3f555dn,
  b: 0x4058e5c4aed4e99c965e12e3e3879e04518n,
  r: -0x4058e5c4aed4ecaf0900697246193df1045n
}, {
  a: -0x3c2f22550e3fd4fb6bfe19f56858f525657b252n,
  b: -0x44f6b396ca9fd026d09088bf9972a6n,
  r: 0x3c2f22550a70bfc20757e4f70551fdae9cec0f4n
}, {
  a: -0x8a7d13e8ec9af5n,
  b: 0n,
  r: -0x8a7d13e8ec9af5n
}, {
  a: -0xa0bb26e9129b114095831283an,
  b: 0xc4f56dcbbcf0c907n,
  r: -0xa0bb26e91ed4479c2e4c1e13fn
}, {
  a: 0x3236bef2a2eb6138694972b4349ec2eec76f314d97839b48bf364877fbf916n,
  b: -0x4d2bd0f1faefb6313ea79fc8fe5586f6766b427c2e4034a8f46802fb88ed70029f56n,
  r: -0x4d2bd0c3cc514493d5c6a7a1b72732c2e8a9acbb4171793f77f34a44bea507f96644n
}, {
  a: 0x9ba357a6062346dn,
  b: -0x21fd09fae2e368a3a0fe7a751n,
  r: -0x21fd09fae278cbf406f85933en
}, {
  a: 0x38044c25f2e494b95f45eddf496fcef95df5fe0443b6a2dn,
  b: 0x59c84701477b57n,
  r: 0x38044c25f2e494b95f45eddf496fcef958697a7457c117an
}, {
  a: 0xf2e9756351cfc16f9n,
  b: 0xc48ed7bc77c5d1f489201c74494ebc56cfeccdfe4657a2fc1ed674d890d0f0n,
  r: 0xc48ed7bc77c5d1f489201c74494ebc56cfeccdfe4657add2898041c46cc609n
}, {
  a: 0xb439a6a3804be444f9c47890b9490959b3cfe82d4ea80f234n,
  b: 0x49b3d3c64f6a4ec4fae4feeff543a2419n,
  r: 0xb439a6a3804be444b077ab56f623479d492b16c2bbebad62dn
}, {
  a: -0xaea3770a1bd9ad96f9e5db57c668e66abbf2e98c159132fff8fd165e0ede58b9268b1fn,
  b: -0xbace39c00b0950b45996e005n,
  r: 0xaea3770a1bd9ad96f9e5db57c668e66abbf2e98c1591324536c4d655078eece0b06b1an
}, {
  a: 0x877370651d00e2d01f932a68803c473e37525d62342fc3337d44n,
  b: -0x283404cb78215fb99b936bc584540cebdd93bbaf356ecd187f9bcefade25n,
  r: -0x283404cbff522fdc869389159bc726835daffc91023c907a4bb40dc9a361n
}, {
  a: 0xe9ad645937d3e8c347c8c5182e22320d22964n,
  b: 0xbf70f8099ec783e73891b191e175eb6b3f997b8n,
  r: 0xbf99556dc7f0500ffbd67954f95bc95932bbedcn
}, {
  a: -0x9dcedbd563eb0887518849f69a0b6e205f93509c31bfce4b72a8189b7a67n,
  b: 0x4n,
  r: -0x9dcedbd563eb0887518849f69a0b6e205f93509c31bfce4b72a8189b7a63n
}, {
  a: 0x18n,
  b: 0x31a382ae64n,
  r: 0x31a382ae7cn
}, {
  a: 0xe6323cd2ecd3b2ebbc52d69bbe1b72558cd67d7c79ff997559286d0a0a88n,
  b: 0xe5e3729b3f8f099e92n,
  r: 0xe6323cd2ecd3b2ebbc52d69bbe1b72558cd67d7c791a7a07c217e203941an
}, {
  a: 0x46b5ca4648c42298789ffd373798cbffecn,
  b: 0x652149021en,
  r: 0x46b5ca4648c42298789ffd3752b982fdf2n
}, {
  a: -0x17ef7c321c48bbbbeb37670663d2bf7de44bf78b17d678556n,
  b: -0x7adf3bn,
  r: 0x17ef7c321c48bbbbeb37670663d2bf7de44bf78b17d1d5a6fn
}, {
  a: 0xbad790f2e290b4dcf6794an,
  b: -0x7c3aba111eb873c95b666b71d6dc056en,
  r: -0x7c3aba111e02a459a984fbc50a2a7c28n
}, {
  a: -0x3635179cf3f09c28n,
  b: 0x1167ecc1db123d009e2dc769ae2fef15dn,
  r: -0x1167ecc1db123d009d4e96106110e6d7bn
}, {
  a: 0xbe61fc01e463d54966034dc7bbd1ec23n,
  b: 0xd69cfc61a2cf740fc46553feeafc01df6bcf9667a5226f0ff2f1531be2aa05d50n,
  r: 0xd69cfc61a2cf740fc46553feeafc01df602989a7bb64525b649167c799171b173n
}, {
  a: -0xf41e4ce5cb63a2407a94fca6e5805c6dd3e8db64n,
  b: 0x1f285285e9f9a2n,
  r: -0xf41e4ce5cb63a2407a94fca6e59f743f560122c2n
}, {
  a: -0x2488n,
  b: 0x951dcee77d287e0a2d304b620a381b94bb54366e565a324e7020c1662f6a2n,
  r: -0x951dcee77d287e0a2d304b620a381b94bb54366e565a324e7020c1662d226n
}, {
  a: 0x9d04785353dd8793ebc213ff124671f2cc098n,
  b: 0xec288ca2faad3ac638ce90d71en,
  r: 0x9d04785353d3451b21edb92cbe25fd1bc1786n
}, {
  a: 0x160n,
  b: -0xc24604a41c1191557e9267n,
  r: -0xc24604a41c1191557e9307n
}, {
  a: 0x9048afe195b58b5bf4e86f6b7f1eee47f2f769fc5a18de77n,
  b: -0x7fd8n,
  r: -0x9048afe195b58b5bf4e86f6b7f1eee47f2f769fc5a18a1a1n
}, {
  a: -0xe3a059c8dc38b6f98ad6e9315n,
  b: 0x5a34b9d1a0d97c103dca64936827accea81e3d7898e2n,
  r: -0x5a34b9d1a0d97c103dc45e96f4aa6f45c78690160bf7n
}, {
  a: -0x82146a2b32569b5944466ee63be5e4caadb50f98c59d12c5af5c8ca8cd90c2ee343n,
  b: -0x81e8cd49f98241bc5049671df44dc77n,
  r: 0x82146a2b32569b5944466ee63be5e4caadb58e7008d4eb47eee0dce1aa8d36a3f34n
}, {
  a: 0x6ab2e8f133791bbddeaaaa1751f70ad9e1e710d7584ff64d2e18a19an,
  b: 0xa98f8c9a740c9f630b5916ceef112d59f93fbcea2b30a9aa5dn,
  r: 0x6ab2e858bcf581c9d235c91c08e1c436f0ca492e67f31c661eb10bc7n
}, {
  a: 0x18e093559053b9ed287c013dc2d9efef0d454bd5f559468e013d8afdn,
  b: -0xa068c35b8a9e66841fc89dcc1n,
  r: -0x18e093559053b9ed287c013dc2d9efe50bc97e6d5cbf2ecffdb4563en
}, {
  a: 0xbf378020ccf1e0acb5c25a9af47f794087bfcae95f47cdc43107e418669edf5d877cn,
  b: -0xeb27bfb81ab90a5707be5229037c64b00c3ec167904cedcfn,
  r: -0xbf378020ccf1e0acb5c2b1bd4bc763f98de8cd570d6eceb855b7e826a7f94f116ab3n
}, {
  a: 0x5c2de841c0b1afd0956a91faf45c218fae963f7d4d2c1ba0929eca177713n,
  b: -0xb504b5a48615a0868d571876d1d11f49e29f3314fde3ce087f0ab85a0c10ca66fen,
  r: -0xb504b5f8abfde1463cf8c8e3bb40e5bdbebebcba6bdcb345531118c892dadd11efn
}, {
  a: 0x9bbfe876f73da6b2c7d041b8ba76b503e8n,
  b: -0x560a37625575f532642453048167b3dff75eacfn,
  r: -0x560a3ed9abf29a41be4f7f79857c38789c0e927n
}, {
  a: 0xd6ca1a48947ce36bab65319e44a49ad9b5913829bn,
  b: -0x4fc4157c266e9f961be15ced47a3f52dbfce72e123n,
  r: -0x42a8b4d8af2951a0a1570ff4a3e9bc8024976163ban
}, {
  a: -0xc520becf59ffec406efef71713f073c992ffc07a07ff9146eb8688c1b03n,
  b: -0xf1b3f4e9445c27a66e3cb0e8f3b1dea5b3c37c7e30cba4ced607edn,
  r: 0xc520b1d466b17805ac8491f4d8fefcf28f159b463038724a51ca65a1ceen
}, {
  a: 0x295eb4d3971d1cbdfb8ab05050cce7a64093cd5c0dc8baed74a21baaa34478eeecd9n,
  b: 0x59c92472fe8f6874e13a7dbdddd41abe3f3486b1f2dee5aan,
  r: 0x295eb4d3971d1cbdfb8ae99974be192928e72c66707567396e1c249e25f58a300973n
}, {
  a: 0xad565d0e4060223603c4c56f92946cbe99520fae52n,
  b: 0xfff345ae2606c99aa74484e53322d25ba20e3663a0cec1398b2a95e5042b1a98805d4n,
  r: 0xfff345ae2606c99aa74484e53328073e72ea306183aefd75ddd3bca3cfc28fb87ab86n
}, {
  a: -0x62ed2ean,
  b: -0x7baa74f4576a89cb0e7c74150f52n,
  r: 0x7baa74f4576a89cb0e7c723bddb8n
}, {
  a: -0x434dn,
  b: 0x376de4a5edb5536eb1678ababb1a80a0e015ba25c869dea0a0ec89e8dd251n,
  r: -0x376de4a5edb5536eb1678ababb1a80a0e015ba25c869dea0a0ec89e8d911en
}, {
  a: -0x67fd3d6a697c95dc38f8f909d98425017c47481eefd0e9e03603853b1a7ebn,
  b: 0x21a8efa9713a5fc5960ea169a730932d0768ace47225cb82c28c019d172ee3n,
  r: -0x27d73c7fd7ad969855812ef93aa8d17d10acd8659cd8c51cc1ec39cea6890an
}, {
  a: 0n,
  b: -0x7dd77a031a600c676d833cf4ad68c22453cfb2bb1c2c160de7n,
  r: -0x7dd77a031a600c676d833cf4ad68c22453cfb2bb1c2c160de7n
}, {
  a: -0x9e2b7564f9c49b479cf849ce2d0ae4n,
  b: -0xf2d03f16a5e5ef5dc3894d0fd2ae8fa428fe119a0f96n,
  r: 0xf2d03f16a5e5efc3e8fc29f61635c838d0b7dfb70576n
}, {
  a: -0x7606c525326db1413bf1ccb52421b24fd5c27n,
  b: 0xbb2806ea013e875afc547db0ef066eb9d22835bdc1974aa85d442a7a22d260548en,
  r: -0xbb2806ea013e875afc547db0ef0669d9be7a669b1a835917418f783839f69d08a9n
}, {
  a: -0x9b732b56d522bcbe8d09701e010a4fecf892771dd510cb97f7e5246bf3n,
  b: 0xe4f1034edb63215729167n,
  r: -0x9b732b56d522bcbe8d09701e010a4fecf8927952c5242621c5f056fa96n
}, {
  a: 0x51129faffa787f591ba1535d97e1858a73edf010c6c44d968c072352ac06b5cc814n,
  b: -0xbb4efcf18fbd9c7014eee05d1419855a99b95caa828f684fdn,
  r: -0x51129faffa787f591b1a1da1666e381603f91ef09bd05413d69e9a0e06843aa4ce9n
}, {
  a: -0x6d64ae97c19a437e8466d7e657ac8e620bbbd0n,
  b: 0x3ce8f5e3d6n,
  r: -0x6d64ae97c19a437e8466d7e657acb28afe581an
}, {
  a: -0xe248f0e59b13f45d7n,
  b: 0x6548e561d34396f996c0851an,
  r: -0x6548e56ff7cc98a027ffc0cdn
}, {
  a: 0x988ca076n,
  b: 0x286a39d38d3f3c5ff176e3fn,
  r: 0x286a39d38d3f3c5679bce49n
}, {
  a: 0x942813e1495cb1c4bc04f51552c9a855d3dca4a8b6220n,
  b: -0x5009ac4c84599370df5dea40b09c8c9an,
  r: -0x942813e1495cb4c426c03d50cbfea5a00d78afa17eeban
}, {
  a: 0x7n,
  b: -0xa843876e9e6878f4c6eb5a1ba27b91ff7191bed463n,
  r: -0xa843876e9e6878f4c6eb5a1ba27b91ff7191bed466n
}, {
  a: 0x4bd6ad445d35ae7b8900aeb334f57b1cae9n,
  b: -0xe75ce13b274560ab9c7b2b8a8dff6aeb451e16158cn,
  r: -0xe75ce13f9a2fb4ee4f21cc321df581d80a49a7df63n
}, {
  a: 0x340a42717dfd60d33d60d116f1eebf4810bacf8fa00a0eca7f08en,
  b: 0x280838b941d1a6be73b9bab318096946a8b625ab5738de6932212142d2n,
  r: 0x28083bf9e5f6b161a5b48965151806584342a4a0fbc0246992cd86b25cn
}, {
  a: -0xa534n,
  b: 0xefecc72bcba93f552efa9754b3467c3d3f31ae84268a78e65dfc84ebn,
  r: -0xefecc72bcba93f552efa9754b3467c3d3f31ae84268a78e65dfc21d9n
}, {
  a: -0x9f50dbecf484bb87dce27612e3709ee068619ecbd0161da000d3590c53bf92n,
  b: -0xce68n,
  r: 0x9f50dbecf484bb87dce27612e3709ee068619ecbd0161da000d3590c5371f6n
}, {
  a: -0x912598436fda7c9ebadc972bdb0cd5f9befe2169054417e80n,
  b: 0xbb105d11bf7bd227183e87cc988caa583f4edb97d0d9df67fdc1dda89062n,
  r: -0xbb105d11bf72c07e9c087a6b516707914df36b5a8f423085eb5189e9ee1en
}, {
  a: -0xaee45n,
  b: 0xd92d0e9cb3ee2a084n,
  r: -0xd92d0e9cb3ee84ec1n
}, {
  a: -0xa4c6025380b842bf49b9dd909b16en,
  b: 0x10c66d37ce3400978b954edc08e29553809e22cfb5b46b04eb016dn,
  r: -0x10c66d37ce3400978b954edc02aef576b895a6e4412ff6dde2b001n
}, {
  a: 0xba69b740fb9cn,
  b: 0n,
  r: 0xba69b740fb9cn
}, {
  a: -0x8231af82da14380b813295b7ddfn,
  b: 0xd411a599b4d76e9abf8n,
  r: -0x8231af820e059d9235e5fb2d627n
}, {
  a: 0xa5ec103908edb9965f58e351cf11d8272284bb4da85fdcn,
  b: -0xd0248c9e96b130412e02f468b08c51e5609bba47de3d875fdc9acd6ecn,
  r: -0xd0248c9e96bb6e802d927ab329e9a46b55874b5a5c4faf14684048938n
}, {
  a: -0xac0cf41a5dn,
  b: -0x952e30n,
  r: 0xac0c613473n
}, {
  a: -0x1459c36e4b3540f3n,
  b: -0x6462d52872acn,
  r: 0x1459a70c9e1d3259n
}, {
  a: -0x15620a5fe9d223e0442aaeaca60cb5f4106615d65fc9908243a5a38d9bn,
  b: -0xb88bf032fn,
  r: 0x15620a5fe9d223e0442aaeaca60cb5f4106615d65fc99082482d1c8eb4n
}, {
  a: 0n,
  b: -0x4ef1e0eecn,
  r: -0x4ef1e0eecn
}, {
  a: 0xd133c72ba1fn,
  b: -0x309bf3039be267478892e4620170e74934479bb18d720316e21654c4e7cd108n,
  r: -0x309bf3039be267478892e4620170e74934479bb18d720316e21685f720e6b19n
}, {
  a: 0x8a91a8832bef6f051f032aff0bd63dfeba92464f8316cf975c22n,
  b: 0xb7c93cc3ed3819bcc46734e7e755ce9733d889451b47c628a0ac34d49907f7cn,
  r: 0xb7c93cc3ed30b0a64c558a1117043ea59c283426c4ac6f0cc45405b8607235en
}, {
  a: 0xc421298f67ca1b97d844e5831f33a3c5b0f15519aa24dbfa69972c4ea3fc971n,
  b: -0x103865017e921e8cf3eda28en,
  r: -0xc421298f67ca1b97d844e5831f33a3c5b0f15518a9a28bed80b6c4819d26bfdn
}, {
  a: 0xa8c83fd6ad05a54n,
  b: -0xf1bfecef07bn,
  r: -0xa8c8ce6941eaa2fn
}, {
  a: -0xa13fe760b99afd1d5433687bff87ebb85b289a59157d72cb70n,
  b: 0xcaaf28bbfn,
  r: -0xa13fe760b99afd1d5433687bff87ebb85b289a5919d78040d1n
}, {
  a: -0x8e214e1d1f2c98119cb716758f52b23n,
  b: 0x223e2eaa4d7a49f645680n,
  r: -0x8e214e1d1f0ea63f36fa6c3c7917da3n
}, {
  a: -0x5d206673c00fbb842f545cebc70d6a715decn,
  b: -0x8e6bdd618a8709392bef4b50ffbcbfn,
  r: 0x5d2066fdabd2da0ea85d65c028463a8ee155n
}, {
  a: -0x5c55cece5ab0377cf6ca0021012f4d76n,
  b: 0x6fcf6163f158663577b2a242d96f9062n,
  r: -0x339aafadabe851498178a263d840dd18n
}, {
  a: -0xa90dd879842803d4c8bdn,
  b: -0x5da31cf8846ee7c54a3194761c48b4ac3663114cbae87f809fdfe71bn,
  r: 0x5da31cf8846ee7c54a3194761c48b4ac3663b8416291fba89c0b2fa6n
}, {
  a: -0xcf615ccfd098942af76a91fbbeb5ef3cbab6f64f6cc6n,
  b: 0xb80a3d4f41dc4576921c15490785238dbb121bb00433de0c896ccce83895n,
  r: -0xb80a3d4f41dc45765d7d4986d71db7a74c788a4bba86313033da3aa75451n
}, {
  a: 0x76f26e3b55438ad2244de6c3c9b0ba51554edbdfa28c18bf435f4714fc760ec93ccbben,
  b: 0x9042e07a299152ca49db5n,
  r: 0x76f26e3b55438ad2244de6c3c9b0ba51554edbdfa28c18bf4a5b69135eef1be598560bn
}, {
  a: 0xc9ac638b73d8864e8a3d52n,
  b: -0x9d5f62deed1a884afd0c7d9440b7c07173dn,
  r: -0x9d5f62deed1a84d03b34caa9c8d328d2a6fn
}, {
  a: -0x8dcddcc092n,
  b: -0xa96956ba76ddbf85f19d5d10a440c2db9ffdb7b8d99dn,
  r: 0xa96956ba76ddbf85f19d5d10a440c2db9f707a64190dn
}, {
  a: 0x58565ede1b3n,
  b: -0x53be8bd66b301n,
  r: -0x53e6dd88b52b4n
}, {
  a: 0x6d8159ffn,
  b: -0xd326ec54a7311fc8f1112a7cn,
  r: -0xd326ec54a7311fc89c907385n
}, {
  a: -0xff272ec3b549fb0907197c52b0997a06be82fe09d051c9a58265c0c25919734f4233en,
  b: -0x59995006f7191b53f1d6eb62ce0ea947a964n,
  r: 0xff272ec3b549fb0907197c52b0997a06bb1b6b09bf205810bd78ae7475f999db38a5en
}, {
  a: -0xbaf599272da0f1efddafa91163234ce855b85n,
  b: 0xed5d8a132601b94539bc533fb2n,
  r: -0xbaf599272dae24377c9dc90af770d72d66437n
}, {
  a: 0xf3e3ae82ce53cn,
  b: 0xc84ad7403eb279b1cb1c504681d965eedc23853a65274d36c4860e4en,
  r: 0xc84ad7403eb279b1cb1c504681d965eedc23853a6528730c2caaeb72n
}, {
  a: -0x253a9ac45c4cn,
  b: 0xc1n,
  r: -0x253a9ac45c8bn
}, {
  a: -0x964fb4587e4n,
  b: -0x15fab9a027fb2944cc2275d49fa5a2ba15aca3a296f8fc87n,
  r: 0x15fab9a027fb2944cc2275d49fa5a2ba15acaac66dbd7b65n
}, {
  a: -0xc92bfed275cdef576ca14783f61d408e19c4a1a8e9f667eae69an,
  b: -0x2bcc5c40726e770fa3c1edef8c4cdn,
  r: 0xc92bfed275cdef576ca147814ad884893f23d152d5e8b9122255n
}, {
  a: -0x3a9a9181325a129d13bef99ded6a34efn,
  b: -0x13bb232fn,
  r: 0x3a9a9181325a129d13bef99dfed117c0n
}, {
  a: -0xb503e4n,
  b: 0xaa6faa256b12n,
  r: -0xaa6faa9068f2n
}, {
  a: -0x3c787b7eb50de0b44194506n,
  b: -0x4n,
  r: 0x3c787b7eb50de0b44194506n
}, {
  a: 0xf1b6c9fc2138412e77add6f394889f6n,
  b: 0x3d6996bf7090d6fn,
  r: 0xf1b6c9fc2138412e4ac4404ce418499n
}, {
  a: 0x1ef58dec7201e3c7498187bd20n,
  b: -0xe78f175084b4a4193f1b8a9fe343b58083c2ec1a81ffd4dcbb16b2a58e3562f6n,
  r: -0xe78f175084b4a4193f1b8a9fe343b58083c2ec04747238aebaf575ec0fb2dfd6n
}, {
  a: -0x2d6732a761a55dfcc0fb62ee07a23c02bd90cf7a7880a4cffn,
  b: 0x90ff7b2d18322ad2f21d4cf4c3ea93e11636a8430ed67caen,
  r: -0x2468c515b0267f51efdab6214b9c953cacf3a5fe486dc3051n
}, {
  a: -0x751f7be48632476872d5ff3950cec0ed8e588afecc306dc5126a9fc38553e26679n,
  b: 0xa6edce43e25ed3bc018f363df6d2ebba01925202a6dbdbf43890d3n,
  r: -0x751f7be48632e185bc961d678372c162b8657c2c278a6c57406839185ea7daf6acn
}, {
  a: 0x339bf9feeb043854908312caa6d7c10693399a46e3aca3cd1d29da49n,
  b: 0xb9cac3dee4f829b29b78503a667ccf607bf2833a1d388546288n,
  r: 0x339bf2624739d61b12183b7d23d467615fcf9df9cb9f021e957db8c1n
}, {
  a: -0x8071b83923fn,
  b: 0x26ba24263f4857a5b81d836fcb38f3123b5566n,
  r: -0x26ba24263f4857a5b81d836fcb30f409b8c759n
}, {
  a: 0xe7f2c3873d90add4ec87384b6762844790df6f9c2a4c3e65096f8n,
  b: 0x32fb42895e77040e6f56f4f7c671570647448342b4f4eee65994ac45690ade82c7f8a2n,
  r: 0x32fb42895e77040e6129d8cfb5a85ddb098cf0c60282c6a220995abcabae1d64976e5an
}, {
  a: 0x4585770a5fn,
  b: 0x87180062fd82b10511c95b956cc010968b2ed5ad5ced3da0e16746n,
  r: 0x87180062fd82b10511c95b956cc010968b2ed5ad5ced7825966d19n
}, {
  a: 0xa5f2a1aff6e22432c89660da88a81d8f5385c403c11c360e6465a95615346n,
  b: 0xf8579cdaab96de87fbc6d4591d8f7fb1fffbcn,
  r: 0xa5f2a1aff6e22432c89660da70ff8155f8131a843adae25779ead6e7eacfan
}, {
  a: -0xcdc7f6db27f957db61f12792922e4eb1cn,
  b: -0xc41dfedc820c392211dfd287e2e75d0d8857336276d01765bcbce1d1a9ba14n,
  r: 0xc41dfedc820c392211dfd287e2e751d1f73a811de3ada17aaec5c8f34d5108n
}, {
  a: 0xdc6e3cfd987694361db5n,
  b: 0xfd7515d0500n,
  r: 0xdc6e3cfd97a1c56b18b5n
}, {
  a: 0x7c16348a0ca0ac7cd203794a8ee495eceeaa99867a02cfn,
  b: -0xfcae4362171801aead06db475898af42a13n,
  r: -0x7c16348a0caf6698e42208ca940e45815adf100c8e28den
}, {
  a: -0x8098n,
  b: -0xe33ed130ac98fe6ef2442ee4c2a637a365732ae9ben,
  r: 0xe33ed130ac98fe6ef2442ee4c2a637a365732a692an
}, {
  a: 0x21f633bf821e7c83e7f0cfc31067d26e7d34257e086768n,
  b: 0x99222aca1cc6a6n,
  r: 0x21f633bf821e7c83e7f0cfc31067d26ee4160fb414a1cen
}, {
  a: 0xb8cf6bdn,
  b: 0xa2fe0b881b6dc108ea2f27d9598865edd5n,
  r: 0xa2fe0b881b6dc108ea2f27d95983e91b68n
}, {
  a: 0x17e57c9c30123073384ed6d267aafe4n,
  b: 0x7a1f92d721c2571d97902b5199a1n,
  r: 0x17e2dd651d602c564997afd0d2b3645n
}, {
  a: 0xbf75cb67bn,
  b: -0xf12d65dc21e88e8c2569e87d55a144157f1185n,
  r: -0xf12d65dc21e88e8c2569e87d55a14fe223a800n
}, {
  a: 0xe5n,
  b: 0xf0047d961a15779c7db2ac5cb08651803c67064ed8e1d15dae966c2e882fcn,
  r: 0xf0047d961a15779c7db2ac5cb08651803c67064ed8e1d15dae966c2e88219n
}, {
  a: -0x3a6b7f5d939d2e9fn,
  b: -0xeccbe0badc4fcf52309cb1d4d7c5d626da679b44e317844n,
  r: 0xeccbe0badc4fcf52309cb1d4d7c5d6257cd06e9ddac56ddn
}, {
  a: -0x57005637d9dad33cc63dc74e074be7n,
  b: 0xf78c09377002c9a88fdn,
  r: -0x57005637d9d5abfc554ac7629dc31cn
}, {
  a: -0xcda1cef0n,
  b: -0x392d2d430c6378d10f7349a3698c775755a89d802822n,
  r: 0x392d2d430c6378d10f7349a3698c775755a85021e6cen
}, {
  a: 0xb6ba7673818bb9e54c847e9cn,
  b: 0x143adc6b0cf031131fa88de2b0958f0a1f9n,
  r: 0x143adc6b0cfb5ab4789095592ec1474df65n
}, {
  a: 0x794d748ce5fd145dfb6886d3d58313950f1504fa5da93n,
  b: 0x8f3604e22d2f4b48fn,
  r: 0x794d748ce5fd145dfb6886d3d5839ca30bf729d516e1cn
}, {
  a: 0x9ed72a7a14668265c115bab8e52b4af623f782b49ffe079800d58d01b2c9dn,
  b: -0xd8935a9f2c26cc18c6ac4954cabded50f9cdccf8f095038adfe534ac29b2n,
  r: -0x935e1fd3e6a4eea44d7f7e2da98094232c6b5e7b10f757a0ad2bde4b7052dn
}, {
  a: 0x398c0de503a56fa602e358bee301a6379a261d7bn,
  b: -0xd75816e44e4a496d2b405c8ca00de6256985d83eda5f986ec3ce01041e5n,
  r: -0xd75816e44e4a496d2b43c44c7e5ddc7393e5f60b51b1a874a0b7a365ca0n
}, {
  a: 0xe423dd8en,
  b: 0xa9727ce993c39ce7c193d52f6n,
  r: 0xa9727ce993c39ce7cfd1e8f78n
}, {
  a: 0x91853ff4f9d21n,
  b: 0xaaa5fa750b10b897a7d241fdddeb3911d96017bf7bb7e9ab28adca3f716878b46cn,
  r: 0xaaa5fa750b10b897a7d241fdddeb3911d96017bf7bb7e9ab28adc327229737294dn
}, {
  a: -0xb7ab3acn,
  b: 0x8e382fd83d64fbe6d0eaad0n,
  r: -0x8e382fd83d64fbe6674197cn
}, {
  a: -0x4n,
  b: -0xbd923ac5c997543baa5df84291c86b2527ea18d706666n,
  r: 0xbd923ac5c997543baa5df84291c86b2527ea18d706666n
}, {
  a: 0xaedc552617a6245b325b8b240ec5fn,
  b: 0x68b61042f034ed0595b02ba6e0733023123810fae7n,
  r: 0x68b61042f034e7e850e24adc82368306aa8a5016b8n
}, {
  a: 0x8e8b2222714cd3b5bcd41ae6e31b371a4049c0de5cad046510ccf21b1fbn,
  b: -0xd58a9a459305b835d34d87b0baef985dd0bde7854231n,
  r: -0x8e8b2222714cd3b8e47dbebfd340b4477491bbd5f25481b81b128a4f3ccn
}, {
  a: -0x44b46cd1d6c4168194414n,
  b: 0x9108dcdf265c7b4d9b5b7383e2e391b1e6409241b630n,
  r: -0x9108dcdf265c7b4d9b5b7387a9a55cac8a01fa58f224n
}, {
  a: 0xa05aa1c62f2a340e21c074ea1ad518698296863efd45513c342f577a598367f691n,
  b: 0xb607f9d31d16ef2817fe142a64244f4cdfa223n,
  r: 0xa05aa1c62f2a340e21c074ea1ad5ae6e7b459b28126d46c22005335e16cfb854b2n
}, {
  a: -0x92d611n,
  b: 0x266189c0a7cb646a4f38d5an,
  r: -0x266189c0a7cb646a4615b4bn
}, {
  a: 0xe23f346528cn,
  b: -0xa760dcdc5de5en,
  r: -0xa782e3e838cd2n
}, {
  a: 0x49ee650cb93f719dn,
  b: -0x8cf816dfd9b195e09608298a7d8d2604c777e2540ee58519n,
  r: -0x8cf816dfd9b195e09608298a7d8d26048e998758b7daf486n
}, {
  a: -0xae18588dbf58ffd51d0ccaa685b6f61a26a5b9736a0a88b654n,
  b: -0x3n,
  r: 0xae18588dbf58ffd51d0ccaa685b6f61a26a5b9736a0a88b651n
}, {
  a: -0x6b8643585e389cbe22c99fdfb7f9197c39n,
  b: -0x58858ac38ea375ca8f454f339dd4280a6n,
  r: 0x6e0e1bf466d2abe28a3dcb2c8e245bfc9dn
}, {
  a: -0x954c05ed38f9c37207da6a347e8b18bn,
  b: -0x409c024dc99b0cd7faf757c81de9edda21c04e04f2debf7cf3b96f5d9d8en,
  r: 0x409c024dc99b0cd7faf757c81de9e48ee19e9d8b6ee99f01551a28b52c07n
}, {
  a: -0xcb47ccf246fd371n,
  b: 0xe074f002e13a1987920825d6844b521f5e4eed52d9216b8dcee00550e6206336cn,
  r: -0xe074f002e13a1987920825d6844b521f5e4eed52d9216b8dce2b429c14669e01dn
}, {
  a: 0x6f8f788c55b98a697a6366a248d3c917f55321b7d895fad8e0b127cddn,
  b: -0xb268daf6d8745f6ec2a45a87fb68d290e468921bf5n,
  r: -0x6f8f788c55b98a625ceec9cfcf963ffbdf1689c86e18d3d6a6380672an
}, {
  a: -0x7535607bdd5ed6d8n,
  b: -0xeff2d8349e489919e5114n,
  r: 0xeff2df67c84f24cc087c4n
}, {
  a: 0xa5c6b63e3d5e23n,
  b: -0x820a2dfeab7e72n,
  r: -0x27cc9bc0962053n
}, {
  a: 0xa7c939a6cdae1af583db540d0b2265900164317102dbece6c5c1ce98001fn,
  b: 0x2826371071117ca64b7eedn,
  r: 0xa7c939a6cdae1af583db540d0b2265900164315924ecfc97d4bd68d37ef2n
}, {
  a: 0x2e7b0764caa7a1036f8226e1a43f4380e1a7b4e03695f4b73b8421ca192c6448c0n,
  b: 0x3bdab29545c7n,
  r: 0x2e7b0764caa7a1036f8226e1a43f4380e1a7b4e03695f4b73b8421f1c39ef10d07n
}, {
  a: 0x537e0e36898201d0cbe99b83e20a4581f5fa8acb9367201fc5618fef82a3ec92n,
  b: 0xc7n,
  r: 0x537e0e36898201d0cbe99b83e20a4581f5fa8acb9367201fc5618fef82a3ec55n
}, {
  a: 0xab24024d93cc9d5fb7fbcb3f45af7327afa5debf3bfa0b41486efea63b86671a4f1n,
  b: -0x5b033491c1ca6c9952246b527dadffn,
  r: -0xab24024d93cc9d5fb7fbcb3f45af7327afa5db0f08b3175deea76b847d3340c0910n
}, {
  a: -0xc7bfb3648d06b4c48n,
  b: 0x20052f08a0bf34bfc2cd6944903ae3dda3ce8d3d01eefn,
  r: -0x20052f08a0bf34bfc2cd6944903a246210aa003bb52a9n
}, {
  a: -0xe103e2f6809b2e830abd1f1a65359d2f78b76bbf1a919315n,
  b: -0xb656d0fe7d0ef9ffdb1ca275cae7b0a2eb80990580dd9aa01d55d2cd236477c38da40cn,
  r: 0xb656d0fe7d0ef9ffdb1ca294c905462270ae1a0f3dc280c528c8fdb5940fc8d91c371fn
}, {
  a: 0xcc47e2de187ab7da5ff0c945c504f11e48cae7fc32ae9a6bc6670781n,
  b: -0x3c6c27a329b052ebn,
  r: -0xcc47e2de187ab7da5ff0c945c504f11e48cae7fc0ec2bdc8efd7556cn
}, {
  a: -0x977d3dd07b135n,
  b: -0xcff290d423n,
  r: 0x9771c2f976516n
}, {
  a: 0xed37d4caadbacd3917599a39967ad98dfcab950cf424edee1db021d04a1n,
  b: -0x6b7dbd7505829b5bc397e39d07an,
  r: -0xed37d4caadbacd3917599a39967ad98d97d62879f1a676b5de27c24d4d9n
}, {
  a: -0xc381011d42734c9d050dc9n,
  b: -0x52a361d9a8e6a8cc53cb7654749a01d80eb1ae20a9b4ae87b43cn,
  r: 0x52a361d9a8e6a8cc53cb7654749a011b8fb0b362daf83382b9f3n
}, {
  a: -0x4ebeb280e640db4432a73b1acde8659876771a2n,
  b: -0x59b781e87de6d8677fc4594c4866b895cn,
  r: 0x4ebeb2d951c13339d47f5c6509b129d010cf8fan
}, {
  a: -0x61ce69733e13a4e0fa78c1cb6db0c7500ecffe77b4f6a646358c903075c5n,
  b: -0xc55aff3bdc11c92a4004ac07992c2db4c34e44n,
  r: 0x61ce69733e13a4e0fa78c10e374ffc8c1f06d437b05aa1df19a124f33b87n
}, {
  a: -0xcf5fa49c6a2e6f096a5aa3863791331248c5053n,
  b: -0x35309621e5695a927ebb9abd85542efabadac7ee8d88b1a450n,
  r: 0x35309621e565af68377d385b75c28b5082b9befdbcac3df41dn
}, {
  a: 0xc1fdd71937cf81b9a6728ed5ccb14a032fn,
  b: 0xf243e6549an,
  r: 0xc1fdd71937cf81b9a6728ed53ef2ac57b5n
}, {
  a: -0xa76b472eb4591b53ac4389e2f6d68ac24cfb4d6e1fca250753c2c3c71944519e915dn,
  b: 0xfd6b7214a3668n,
  r: -0xa76b472eb4591b53ac4389e2f6d68ac24cfb4d6e1fca250753c2c3c8cff370d4a735n
}, {
  a: -0x97deefd4a9n,
  b: -0x34242628f5ad407eeecb4ddc9f81f27dn,
  r: 0x34242628f5ad407eeecb4d4b416e26d4n
}, {
  a: 0x9ac4d732e3f0358660b0b897346fa449a3efde9bf41c3107549870bn,
  b: -0xb6444bb689065an,
  r: -0x9ac4d732e3f0358660b0b897346fa449a3efde9bff7875bc3c08153n
}, {
  a: 0xb00n,
  b: 0xa7643f7f9826a9a6451f73c7add910a670f35n,
  r: 0xa7643f7f9826a9a6451f73c7add910a670435n
}, {
  a: -0xdc298c18a6f271ae95ae1f2297n,
  b: -0x37e7n,
  r: 0xdc298c18a6f271ae95ae1f1570n
}, {
  a: -0x921eec8eccn,
  b: -0x3099729183c27n,
  r: 0x3090537f4b2edn
}, {
  a: 0x2b976d915271c02c237feac473b032a13f01f4514n,
  b: -0x4bafan,
  r: -0x2b976d915271c02c237feac473b032a13f01bffeen
}, {
  a: -0x9071558e5084ebc91b6f2d35b896a2f06fa3f7047b3f1fc69fn,
  b: -0x65563f9af3f0110e0ce4b12366d9d5276ba259c01n,
  r: 0x9071558e56d18830b4502c255858e9e259ce6a560d853a5a9en
}, {
  a: 0x6bebn,
  b: 0x645304447b3eff7874ee2d5261eac2b02764a96n,
  r: 0x645304447b3eff7874ee2d5261eac2b0276217dn
}, {
  a: -0x71b273061a106b374a6f04d4e84f19d522n,
  b: -0xcd98d7d2a02a5de44625ad9c56e93508e553ec27780295n,
  r: 0xcd98d7d2a02a2c563523b78c3dde7f67e187046861d7b5n
}, {
  a: 0x226c39e6bc7dac9d7e4c24e90d98f394346496ad6fn,
  b: -0xade98db92301d27ecb51n,
  r: -0x226c39e6bc7dac9d7e4c2444e4154ab735b6e86640n
}, {
  a: -0x7df487d0e1f610e4aa4615303674d20f2ef1d8bb901945297857bc7362999db24e958n,
  b: 0x16c5d3c61df4b8a71f06e88b506n,
  r: -0x7df487d0e1f610e4aa4615303674d20f2ef1d8bb900f80fabe4a48cbc5869b5ac5c52n
}, {
  a: -0x5e73c37615e63fd4c7068273c8eb3dffe86bdfb9ec82ed5a90c15367d34b519n,
  b: -0xcf9e666fd30b29bc48a497a0fa5815c4e3b2b08c4b178357e4e730a2f01015en,
  r: 0x91eda519c6ed16688fa215d332b3283b0bd96f35a7956e0d742663c5235b445n
}, {
  a: 0xb4f414e5c6ac2f8c689125f3cb3a18c6d945cf44ccd8f53e8bean,
  b: -0x447aaeb0318cc98206fd0c5b2085301668348a385c95fc6e0f36bn,
  r: -0x4f35effe6de60b7ac0741e041c36919a05a0d6cc1058733de7881n
}, {
  a: -0xadf5dc8c97360c2f58df71c5n,
  b: -0xddf7aaa84f75527966cc5e8abe080bcce6ed584ed0efb3d5ef845fen,
  r: 0xddf7aaa84f75527966cc5e8abe080bc639b09087a38f71206273439n
}, {
  a: 0xea334eb02f86314ae27036c2ecd74d610f4f7b824438d319ca30e3e751f40985b76n,
  b: -0x789fbbceac564f34b1dc7400e682bcda441e1ca7a5dd01c38c53baa038n,
  r: -0xea334eb0280fcaf608b55231a7ca8a210127504fe07932d3b06d33fb6931322fb42n
}, {
  a: -0xde10f943dc39f0b4d53fb56cd008n,
  b: -0x5c5f9f9731b46c96170cf9bb3e4d1n,
  r: 0x51be90030c77f39d5a5f02edf34d7n
}, {
  a: -0x7fdd171055467d4466924894796575n,
  b: 0xdca658ba36179f8db145f578ee5347d7098n,
  r: -0xdca65f47e7669ad9d691b311cada00415edn
}, {
  a: -0x25fd4acf4308da0f308f4b937n,
  b: -0x259c5e1d0e081bb2a76f479d767175ca85e157aea8584bedfd41d2f28dbebn,
  r: 0x259c5e1d0e081bb2a76f479d767175ca85e17253e29708e5274ee27dc62dcn
}, {
  a: 0n,
  b: 0n,
  r: 0n
}, {
  a: 0x6f83e59cc958edf4e0a19cn,
  b: 0n,
  r: 0x6f83e59cc958edf4e0a19cn
}, {
  a: -0xe40205n,
  b: 0x1ddd18c631a3c66f5d4n,
  r: -0x1ddd18c631a3c82f7d1n
}, {
  a: 0x2ecc3ee71977528b97c6ffdbed7117a67e10af9727766d00de5174n,
  b: -0x1c21b8060954525508b12n,
  r: -0x2ecc3ee71977528b97c6ffdbed7117a67fd2b41747e328258eda66n
}, {
  a: 0x1de43d7835fe7046578687e928ee599351ean,
  b: -0x79n,
  r: -0x1de43d7835fe7046578687e928ee59935193n
}, {
  a: 0xa9b50bb10624bf162d4a3n,
  b: -0x9a65d90d40c9258372f8n,
  r: -0xa0135621d2282d4e1a655n
}, {
  a: 0xc8adaa79cf2cfa9e45bf2d68357c2e8n,
  b: -0x8d5b447c1b7dn,
  r: -0xc8adaa79cf2cfa9e45b7f8dc72bd995n
}, {
  a: 0x92dn,
  b: 0xa873f4c777aefe95740b404507ef089e99dd578d5949f9f9cc0272cc9d37f1d9d01n,
  r: 0xa873f4c777aefe95740b404507ef089e99dd578d5949f9f9cc0272cc9d37f1d942cn
}, {
  a: 0x5f3a25dn,
  b: -0xa88a228c19031d21e6c406ec2abb99a1f9ea6en,
  r: -0xa88a228c19031d21e6c406ec2abb99a40a4831n
}, {
  a: 0x3abfd67b46n,
  b: -0x3f99dc2ed0597n,
  r: -0x3f9a77d3b7ed1n
}, {
  a: -0xf9faacfaa04b020530cf42b29bf3559ccec09e370e104cc3817151850b568e128n,
  b: -0x1d97c693n,
  r: 0xf9faacfaa04b020530cf42b29bf3559ccec09e370e104cc3817151850a8ff27b5n
}, {
  a: -0xfa978da6fe7ea9da1de22690feaba4a5a754306f7dbfd939f6a00cn,
  b: 0xcb726440c8e01124c21f362989da550cn,
  r: -0xfa978da6fe7ea9da1de2265b8ccfe46d474514ad6289f0b02cf508n
}, {
  a: -0x510175edd225a2c7dda63n,
  b: 0xc0f9bda9129929c9e6171a63f81cec71dn,
  r: -0xc0f9bda9129978c893fac8465adb31d80n
}, {
  a: 0x9d04d08n,
  b: 0x3f26an,
  r: 0x9d3bf62n
}, {
  a: 0xccb6d383a278446b545a988448804e5f2dd809f68c53ae37a61e777n,
  b: 0x2e1736d1dd591b801f588b85n,
  r: 0xccb6d383a278446b545a988448804e5dccab64eb59c216365396cf2n
}, {
  a: 0xc0140e423460159661aa026d3bc2767a4fa0d8654ac11122f61en,
  b: -0xdbc62c2n,
  r: -0xc0140e423460159661aa026d3bc2767a4fa0d8654ac11c9e94e0n
}, {
  a: 0x8c9ba3579a1c2867b89f881829b38fe0ede09n,
  b: -0xf9111e70479129e84e691f3c3603dd49151n,
  r: -0x8c62b249ea5bb94e50d1e10715858c3da4f5an
}, {
  a: -0xcf1e314a1b392b938ca9deaf49dn,
  b: -0xf4f44e34982eb6e1672434c0ce76n,
  r: 0xf805ad20399d24585feea92a3ae9n
}, {
  a: 0x4n,
  b: -0x4f19bc77c535a8fa748a08f4fn,
  r: -0x4f19bc77c535a8fa748a08f4bn
}, {
  a: -0x10d8c27850b312a2a754784557n,
  b: 0xe64c9b3aac7bde402d64n,
  r: -0x10d8c29e1c28280edc8a386833n
}, {
  a: 0x56ef567937bcb0n,
  b: -0xeab5909e56434156db953899432d9399a08b2f391f9623eb7b32220b1e3cdfen,
  r: -0xeab5909e56434156db953899432d9399a08b2f391f9623eb7e5cd76c8d4714en
}, {
  a: -0xb90a8d05afd759422059c1f33f3574e58e41ad397923dd28a0d8cn,
  b: 0xb717f7n,
  r: -0xb90a8d05afd759422059c1f33f3574e58e41ad397923dd23d1a7dn
}, {
  a: 0x5aa101c876652074f18f99ad77cec42c5404fb1e5881fa77d7581adc04cda0e0n,
  b: -0x930f22c50f8252ce1e4fd833d9777710f4f64ee607cc4n,
  r: -0x5aa101c876652074f186a95f5b9e3c0978e51fe3dbbc6d00a65755b8eaaddc24n
}, {
  a: -0x20954cc5719n,
  b: -0x8301cc4bea0e9a2ae89n,
  r: 0x8301cc4bca9bd6ef990n
}, {
  a: -0x993c379325f92111baec9331dfb790d064088b6n,
  b: 0xafa2ea03077c75e10ac0bc0c7bae644n,
  r: -0x993c37938a5bcb12bd90e6d0d5772cdc1fa6ef2n
}, {
  a: -0x65ca1452069f9676d78dd55866d36ebb324ca6bab2f1438973b0717258e60c6bb0c0en,
  b: -0xc96cd4f4359f377c3e65a72cbdb05e37n,
  r: 0x65ca1452069f9676d78dd55866d36ebb324caa2c7fbe00d080c7b2940294c7b0b523bn
}, {
  a: 0x7da7ad0536829d9cd7106an,
  b: 0xaa7a77522aaed1ecf1e02cf3ae72b5e874c1f0a6dd80b8ee99bb546102n,
  r: 0xaa7a77522aaed1ecf1e02cf3ae72b5e874c18d0170858e6c0427837168n
}, {
  a: -0x150dd055bc89925dcf7d87157e5f050fea3fe0b222f9804dd59453b382017997n,
  b: -0x5da5fefee3ed32e83714dd98e67cf3db6887b0d1n,
  r: 0x150dd055bc89925dcf7d871523fafbf109d2d25a15ed5dd533e8a068ea86c946n
}, {
  a: -0x4n,
  b: -0xf176e1003fn,
  r: 0xf176e1003dn
}, {
  a: 0x4260529ebf46c6a1bbff440ef14f76f5n,
  b: -0x7c25n,
  r: -0x4260529ebf46c6a1bbff440ef14f0ad2n
}, {
  a: 0xd82b38fa9e82n,
  b: 0xeb2a7feaff7888246cb46d3e25a40d2d87a477004ba05a1d9b292b09739004b177ebn,
  r: 0xeb2a7feaff7888246cb46d3e25a40d2d87a477004ba05a1d9b292b09abbb3c4be969n
}, {
  a: 0x43ebf56659a7599bfc9c2aeb0ed2c579fdf97d081884044c167262dbc2ba3726bcc51n,
  b: -0xd7b3d3da3a06fe5ff3fc56b254d377d22bdeffd87c8b30145bfba68f8360176e8dn,
  r: -0x43e68e5b6404f9f41963152e65f7884e80dbc0e7e503ccff1737dd61aa420127ca2den
}, {
  a: -0xdb2d32a74ee3e2802a636f6f0660b071f7a1b14b6c32eba4020eb852d1237c3f4f33dn,
  b: -0x62985ffbbn,
  r: 0xdb2d32a74ee3e2802a636f6f0660b071f7a1b14b6c32eba4020eb852d1231ea710c86n
}, {
  a: 0x72c9d9ab7f43fa56ac5c945bc2c65808763f7598ed7eacc31ecd5n,
  b: -0xbe30dd2408966852c212ccb68a1c5e91n,
  r: -0x72c9d9ab7f43fa56ac5c9fb8cf14188110ba59b9c1b5c462db246n
}, {
  a: 0x335c4ef68949f3647af4c3c9f81dn,
  b: 0xd18bc2b9b88bd49531ac0f89a7f2515e3cc15c1f0a3fb2e5d01c1n,
  r: 0xd18bc2b9b88bd49531ac0f89a4c795b15455c3294d90fed94f9dcn
}, {
  a: 0x708077e7bd4a9c55cn,
  b: -0xa628c8b369272ad567f5b9f93b264486b5b4230n,
  r: -0xa628c8b369272ad567f5b989bb51a33bff28774n
}, {
  a: -0x3fc11d6b88808f096a7dfab54c743bf470ed020204e434843n,
  b: -0x9120b22fdcd98abdd230eeaa212d87784bn,
  r: 0x3fc11d6b88808f007876d84881ec902953e3e8a0163c43008n
}, {
  a: 0x782a5d522e9c02f8d8bb48deabf63b414752fb22d5en,
  b: -0xd3713d71en,
  r: -0x782a5d522e9c02f8d8bb48deabf63b4147818a1fa44n
}, {
  a: 0xb27e71c3f18858dda672ee2c34a2b4f2c1dc501697b4fdc5ee06f3397701cben,
  b: 0xab3a68154cc68f8a3b432f91f77c5898ab2ba497f696ba537829e1an,
  r: 0xb27e71c35ab230c8eab461a60fe19b6336a0088e3c9f59521890496a0f282a4n
}, {
  a: 0x35447an,
  b: -0x32a71ee66058127ed4f6eb4cf0850d053c19aff1n,
  r: -0x32a71ee66058127ed4f6eb4cf0850d053c2ceb8bn
}, {
  a: -0x451442e18c388n,
  b: 0xb7n,
  r: -0x451442e18c331n
}, {
  a: -0x7432e49f2a1177a0b11fb33f64ea1e1726cce64c9cc01b10b94725382n,
  b: -0xb1e7bn,
  r: 0x7432e49f2a1177a0b11fb33f64ea1e1726cce64c9cc01b10b94794dfbn
}, {
  a: -0x17885b18d9bb0a7f3dbdc02f43f9a10911f4f3760286f3ee790e6a046cn,
  b: -0x4ecc377f7d200n,
  r: 0x17885b18d9bb0a7f3dbdc02f43f9a10911f4f3760286f702ba799dd594n
}, {
  a: -0xd8471d8e64fb7b974c44b882f3215bn,
  b: 0x1d40f2f31d5bn,
  r: -0xd8471d8e64fb7b974c59f870003c02n
}, {
  a: 0xbc4a606c44b5911694f9e7bce81eec3ef02f538a4db8ab2f4a6dn,
  b: -0x3bb41eb3d7e035c1n,
  r: -0xbc4a606c44b5911694f9e7bce81eec3ef02f683e530b7ccf7faen
}, {
  a: 0x516d42322312fbe18878596abfe5b00a314cce093466277938bn,
  b: 0x9f0d99352747b23e460dd1d9414425ae3772b4cn,
  r: 0x516d4232231264ec114d7e2d0ddbf607e0958f4d11c8100b8c7n
}, {
  a: -0xac070e0316816904f05afa55fcd0ada8ee3b0eae69409812n,
  b: 0x338f07850725fb0ddca2b50a6cb52225d2bf3d22bae423c8641c2548ffacbe316aen,
  r: -0x338f07850725fb0ddca8757a8c844a3342f0388d1fbbeec2be92c6f8154a2a38ec0n
}, {
  a: 0x3f7e960c607301e135d3efe39f5504e18c8cebb2a64610f9f7537b9a451d16d8n,
  b: 0x68ecfc768f834e17a77ebd3509af15454b7a47503920b7c78e1c929cb8a3be8n,
  r: 0x39f059cb088b35004fa40430cfcff5b5d83b4fc7a5d41b858fb2b2b38e972d30n
}, {
  a: -0x2ae85f4ecffddb02e304e80945dfeb891b22f79426667f1fcd5e4n,
  b: 0n,
  r: -0x2ae85f4ecffddb02e304e80945dfeb891b22f79426667f1fcd5e4n
}, {
  a: 0xf82d28abf12eea575b820bc0053403cd03aan,
  b: -0x2f2ddd69cd4n,
  r: -0xf82d28abf12eea575b820bc007c6de1b9f7an
}, {
  a: 0xfc0439696n,
  b: 0xdd2f857ddae2a74b79af5a5a7558db86be65011590d549bc7852541fb7e14ede46ef3n,
  r: 0xdd2f857ddae2a74b79af5a5a7558db86be65011590d549bc7852541fb7e1b2da7f865n
}, {
  a: -0xecf3bdbc64c4c929f4e26cb7n,
  b: -0x5dfbccn,
  r: 0xecf3bdbc64c4c929f4bf977dn
}, {
  a: -0xcba5679996n,
  b: 0xccaa9309c15a1d5b8ffac3f00f8f254975e74n,
  r: -0xccaa9309c15a1d5b8ffac3f00f839f1f0c7e2n
}, {
  a: 0x902ce791e069ae0449fb6c12873adf99537cd36n,
  b: 0x7821ce4be11d8c607d86d2a193c0d2401n,
  r: 0x902ce7e9c1a7e5e554770c6f01e87e0a93ae937n
}, {
  a: 0x2be15bf9399e8eff2f2e181cf0c69b5c8fb5cdf4154c8639ac34d6db4641b48bb6cdbn,
  b: 0x4817ae2f688ba9261ad063db4183d03d207abd8f656ea58c8092n,
  r: 0x2be15bf9399e8eff2baf62fe064e21ceee18cbc9a154bb3a7e337d03b0175ed37ec49n
}, {
  a: -0xfc202283n,
  b: -0x565151b65f4n,
  r: 0x565e93b4771n
}, {
  a: -0xa4c33fe9d09482e295a3200b316fc1006ae1807ff0fd1ecdc4b77b51facd6ffefbd628n,
  b: 0xa5846a16749d84cf75c3f1bf77e63c8e595d9e54540dfc48ca3635311d0b32n,
  r: -0xa4c33fe97510e8f4e13ea4c444ac30bf1d07bcf1a9a0809990ba871930fb5acfe6dd16n
}, {
  a: -0x6e2d98ab0119805cd028e5170e84ad8d2cdc5d5f5c735fan,
  b: 0xac1eafe27a95b2a177f428e84c7d1a2c2fdb88825093e3n,
  r: -0x64ec725526b0db76c757a7998a437c2fee21e5d7797a61bn
}, {
  a: 0x57a38d709c3afd7693d90a2bc6e5ccfn,
  b: 0x2a073d8cea9f7dfa2747594f5311868e5872024e466b0be198b05ed1e1894b2183892n,
  r: 0x2a073d8cea9f7dfa2747594f5311868e58720219e5e67b7da24d2842388360e76645dn
}, {
  a: 0x1b19f7afa709n,
  b: -0x6475e0bb47be83df615c0d860745f5b1310df2362c68e38e5cdn,
  r: -0x6475e0bb47be83df615c0d860745f5b1310df2379df799742c6n
}, {
  a: -0x9ee757278c7e5167041184f4d961a4ff977130aa93c9a73b40n,
  b: 0x8f2f11e96ab53f5d849fe5bef004e74ebd59fef35a382f733653b2b366f892n,
  r: -0x8f2f11e96ab5a1bad3b869c0a163e35f39ad2792fec7b80206f9217ac1c3aen
}, {
  a: -0xe6f1a44n,
  b: 0xc48c9106e35ecaf7a994b4a98fa8e055517e420f2b20954d86ae0ef55n,
  r: -0xc48c9106e35ecaf7a994b4a98fa8e055517e420f2b20954d8648ff517n
}, {
  a: 0n,
  b: 0xa44de837bfcfd7ae4208f1cf658da5d9109994fcd829fd462dcb1e5d36en,
  r: 0xa44de837bfcfd7ae4208f1cf658da5d9109994fcd829fd462dcb1e5d36en
}, {
  a: 0xb00ce8bccadafbb7d1571dff94169f2e16d9be539fce72caf0771d172ea9de12ff023n,
  b: -0xe242243ad98en,
  r: -0xb00ce8bccadafbb7d1571dff94169f2e16d9be539fce72caf0771d17208dfc51529afn
}, {
  a: 0x86afaab0d4358689c510db941422c2e9f294d6902ce68ccd540faafc230f6cen,
  b: 0xb56eeac3486a74ac4443c64421cfe0097b49f4n,
  r: 0x86afaab0d4358689c510db941f742c45c61271dae8a2b0a9161354fcb4bbf3an
}, {
  a: -0x3e0244aec40c3d11d5ee0900b50561c41e7a3acn,
  b: 0xbaa7ca9009275fe7e2920175dc61a6e3cc172cn,
  r: -0x35a83807c49e48efabc72917e8c37baa22bb488n
}, {
  a: -0xc80495c80061ad011ade036fcc97385e21364cf3d4be1fe900671b81n,
  b: 0x9e1b4e04c50d34bec13d703dc02a80c99abbcc9f7a99033an,
  r: -0xc80495c89e7ae305dfd337d10daa4863e11ccc3a4e05d3767afe18bbn
}, {
  a: 0x1b1dbe7873f572dc11140a53bed2f58n,
  b: 0xbf9553abab6f428c2cabcc44cef720bf3974146a77970a6n,
  r: 0xbf9553abab6f428c37b6723cbd02526328601e39c945ffen
}, {
  a: -0x38a136f8f723fc951efad441c51adn,
  b: -0xb6a7ce731cf3f868b136ca67ea56e8076a4ebadc6849n,
  r: 0xb6a7ce731cf3f86b3b25a5e89869215685e3fec039e4n
}, {
  a: -0x4d841dc63964abn,
  b: 0xe266dd81814008e19ca0f18908685c5b0f2ad12bdce46d6b3en,
  r: -0xe266dd81814008e19ca0f18908685c5b0f2a9cafc122540f95n
}, {
  a: -0xe6cd2c885dc3be21f3748715d70d0146e11c4168944eca423b9f9a2an,
  b: -0x2b1832b491c9f2eebcbf85d5bbd3cba6e193564d43ff36a4c57ee92882n,
  r: 0x2bfeff98199431509d4cf152ae04c6a7a7724a0c2b6b786e874576b2a8n
}, {
  a: 0xd09c6aa6c1e39cd6d33c07f836461c0n,
  b: 0xdn,
  r: 0xd09c6aa6c1e39cd6d33c07f836461cdn
}, {
  a: 0x26c83537ca4374d17n,
  b: 0xbb5620963936c55d23723edd6916f79d9d2658776b3575bfb31cf0d43c0561e71627n,
  r: 0xbb5620963936c55d23723edd6916f79d9d2658776b3575bfb31e9c576f79c5d05b30n
}, {
  a: 0x62a9dd400ab3d338bab37cba290e4a88b6e33221c490cn,
  b: -0x20a82aabcea426484n,
  r: -0x62a9dd400ab3d338bab37cba290e6a209c48fc85e2d90n
}, {
  a: 0xbe11797an,
  b: -0x8986ab34b9e8fn,
  r: -0x8986a0d5ae7f5n
}, {
  a: 0xd52947e7201411e54db625cn,
  b: -0x3bd3f37fd0369f4d9d463b7250318e87fdn,
  r: -0x3bd3f37fd03bcdd9e3343a334e6555e5a1n
}, {
  a: -0x3291544eaf09n,
  b: 0xb22683df57e925ee6800ce1889036n,
  r: -0xb22683df57e925ee6b29db5c63f3fn
}, {
  a: -0xddbc9afbfb90a7d0e51ed9d621fa75df9b01b2bn,
  b: 0x9970a1b7171aee757760b49c24ef644137fb8198dn,
  r: -0x99ad1d2dece17ed2a785aa45f2ce9e34e860802a8n
}, {
  a: 0x7c4a1ec538890328de1ccd8f9430b38a94e541f7543a790ef0d3fa120156e4bn,
  b: -0xe1da4390532c27404c2f986c1ca8d516a10515fd2a0n,
  r: -0x7c4a1ec538890328de1c2c55d7a0e0a6b3a50dd8cc5665a625c55b1714abcd5n
}, {
  a: 0x215e47babe7db6867c9db04d9ecca2a60477d0330n,
  b: -0x7df251a8978bd207446cda76fe55843cn,
  r: -0x215e47bab9a2939cf5e50d6dea8a6f016b928870cn
}, {
  a: 0x2b8970n,
  b: 0xb6e33f39a8f5d3ea2dd11490337c626323n,
  r: 0xb6e33f39a8f5d3ea2dd11490337c49ea53n
}, {
  a: -0x5c81fb605e7aeb4203n,
  b: 0xfbddecn,
  r: -0x5c81fb605e7a109fefn
}, {
  a: -0xe18bfc7a3f194d3f0f2d86b51b368fd5d7907e893cd2a7a52b7a23ee689c1n,
  b: -0x11cc536219f3d92a830bf1034a7d57en,
  r: 0xe18bfc7a3f194d3f0f2d86b51b368fc41bc31c90cf0b8d26208b20a415cbdn
}, {
  a: 0x3d7d55f9abdbfa3af4dfba48cd119fn,
  b: -0xd0dc810f17b6ce9ee1770094f00314d106d9a83319c2da2890405dfa3b7e230e66n,
  r: -0xd0dc810f17b6ce9ee1770094f00314d106d9954e4c3b71f36a7aa9258136ee1ffbn
}, {
  a: -0x7d8747dfd1be348ea44b8995499c09ccf7a3d2e01169b84b9n,
  b: 0xbde38fba984ff9a7d8bc904aad04d328n,
  r: -0x7d8747dfd1be348eaf95b16ee018f6568a281be4bbb9f5791n
}, {
  a: 0x26978ebd20a33ee2871792f555666bc73n,
  b: -0xd2cbeb47bd9563f65d3949n,
  r: -0x26978ebd20ae125c336c4ba36a03b853cn
}, {
  a: 0x96bb3f31b30c1793923c52ef3989e67678973eee40d8ea4e05dec87d9504aan,
  b: 0x6f951127n,
  r: 0x96bb3f31b30c1793923c52ef3989e67678973eee40d8ea4e05dec81200158dn
}, {
  a: -0x33a1aa0309n,
  b: -0x71b7fa747b48b2db36e4n,
  r: 0x71b7fa747b7b137135ebn
}, {
  a: -0x1eabab1434715fe99cf5fn,
  b: 0x49b50a464ce77n,
  r: -0x1eabab147dc455afd012an
}, {
  a: 0x9753ee3d7f49b23c5bf92143a2a0690f4cb9a58497cce7c08d33a9e8d539b6n,
  b: 0x8772c472aaf7c87bbb9ed2abbc53bbb676e2e075e13fcan,
  r: 0x9753ee3d7f49b23cdc8be5310857a174f727772f2b9f5c76fbd1499d34067cn
}, {
  a: -0x497384c938018a3n,
  b: -0x8ad7de629556587a6f78ae4e9eb9216c6ff0a4e92a6b7fcd84d11an,
  r: 0x8ad7de629556587a6f78ae4e9eb9216c6ff0a4edbd53335e04c9bbn
}, {
  a: 0x85fd019dec0615c6aa63693d4a4d31n,
  b: -0xde294469a079136ba732e2d07604188c1den,
  r: -0xde294c367060cdabc66e88764097cc28cedn
}, {
  a: -0x71ce02513406ce5a7ed2ee0e64n,
  b: 0x15d8b59e97e827b0c6ae1b06cf2950375e020d423b91bcc4e2a187d5e5f238n,
  r: -0x15d8b59e97e827b0c6ae1b06cf2950375e027c8c39c088c22cfbf9070bfc5cn
}, {
  a: -0x7ccc53298f7dbc000c2588b485e85c58081d74n,
  b: 0x9dc7d32806bad77ffa1af283c0ae2ffc5b1d1828339fe3ec0698dabbd78968d9f2n,
  r: -0x9dc7d32806bad77ffa1af283c0ae5330083497558f9fefc98e2c5f538bd160c482n
}, {
  a: -0x596578834d30739b7a8da68b88f7a6345a08113adb780n,
  b: -0x395a466524e619b7adeebd433cea395b490n,
  r: 0x596578834d0929dd1fa940923f5a48891934fb03803f0n
}, {
  a: 0xef28060e01092bfd3fc50ebdf162ec27f70a74a0e46143794599832c722da9n,
  b: 0x6a7446f1bdcca08c516n,
  r: 0xef28060e01092bfd3fc50ebdf162ec27f70a74a0e467e43d2a825fe67ae8bfn
}, {
  a: 0x2d9d60c877bba9ff697d922b92f58846dfb200817798868148073f8212b870n,
  b: -0xee7e9abaa9459e804e9fc24a01793838b7bn,
  r: -0x2d9d60c877bba9ff697d922b92fb6faf741894d89f9c6f7d6ca7281191330bn
}, {
  a: 0x47ddb7949746feae1b1cf1da944c150eb69c7de80f5d9bd3cbbaba4c89373b7e176fdn,
  b: -0x8c28eab17d2fc91022n,
  r: -0x47ddb7949746feae1b1cf1da944c150eb69c7de80f5d9bd3cbb278c22220e982866ddn
}, {
  a: 0x9576127e6faa3124f02c0ebd506b3d11aan,
  b: -0xfa9920daee333f198a59cc0f7cf722e5f47351f05043e1ea3e4811n,
  r: -0xfa9920daee333f198a5959796e894d4fc557a1dc5efeb1810359bbn
}, {
  a: -0x158942d0562e413ae1e5cb8n,
  b: 0xcn,
  r: -0x158942d0562e413ae1e5cbcn
}, {
  a: 0xdb0ced660aac0da15b021dc2ced6bf6b60bf0627f8c4749n,
  b: -0xac1a18b417cb80606bfee0a08f55d246n,
  r: -0xdb0ced660aac0dab9aa39683b26eb96ddf510c2f0d9950dn
}, {
  a: -0x5f6a9b1dc9d0dc91c26e90d0b4e0n,
  b: 0xfd04ead4418c759c2a06c3366e5b0519aee11n,
  r: -0xfd04ead4447adc2df69bceff727dec14a5acfn
}, {
  a: -0x6d25bd4ff667fa4fn,
  b: 0x2d7ee70b94251e9b17cd07fff3n,
  r: -0x2d7ee70b94483b26583b6005ben
}, {
  a: 0x79d510862b74e87adbbec6759eb4974dbc41n,
  b: 0xb60n,
  r: 0x79d510862b74e87adbbec6759eb4974db721n
}, {
  a: 0x34a3c96afb7336c38d2e8dd0208cda208336a23c101ede5f66bcd9a118d4968an,
  b: 0x444755032e2e196ce46eec6b929041487f2e8f4739d37132bdbn,
  r: 0x34a3c96afb733287f87ebf32c11a14666df01b15140a59ad8e48aa3c2fc7bd51n
}, {
  a: 0xd21f868be5781c8c6332add4083be61b22d8f622e660a626a3bb9528430n,
  b: 0x6a3aae52930977b31259e1efbc7e97b73cn,
  r: 0xd21f868be5781c8c6332add40e984cfe0be86159d7453838587c7c5330cn
}, {
  a: 0x6681581e778a452f1822f0e770dbd9b283dda622aad5542118174n,
  b: -0xf2n,
  r: -0x6681581e778a452f1822f0e770dbd9b283dda622aad5542118186n
}, {
  a: 0x72b4d213866b665b6an,
  b: -0xb224b60df73eb8dbc154e3b43bbeecaf3n,
  r: -0xb224b60df73eb8dcea19c28c5d0889199n
}, {
  a: -0xe9n,
  b: 0x10f5bdc1d55faa4b28en,
  r: -0x10f5bdc1d55faa4b267n
}, {
  a: -0x9ee0af324f7a2ebb93a829e0869d6ba2abf701ae6df215941d6ed17df579en,
  b: 0xa1a54348f054929143885e31b6df6ee2a6dcc11b0n,
  r: -0x9ee0af324f7a2ebb93a88845c5d59bf63966422633c3a34b738c77a13462en
}, {
  a: -0x39243ff9en,
  b: 0x518bb40b774b40b01n,
  r: -0x518bb40b4e6f7f49dn
}, {
  a: -0xf3c678c6077ed96c9386737d633b763c7ba8165n,
  b: 0xb3e8b45e6fe508b9d66fe123603f5f82238fd1n,
  r: -0xf8f8f383e18089e70ee08d6f553883c45990eb6n
}, {
  a: 0xc5c3fn,
  b: -0x995cd440bc4ad8d17485842f53ba73a87a8dadb7c6b737bb3ff17b07dcf950a4c69e9bn,
  r: -0x995cd440bc4ad8d17485842f53ba73a87a8dadb7c6b737bb3ff17b07dcf950a4cac2a6n
}, {
  a: 0xd5be9d28fd7cdc403e26c194aebfb2e5f64e7e7269n,
  b: 0x37d0084cd0063b2e5aac7a263954eb619921ddcb6n,
  r: 0xd6c39dac307cbff2db8c0636cd2afc53efdc63aedfn
}, {
  a: 0n,
  b: 0xe6e07f381aaf5959d20b7a2f3585bdd2a52bec0125032ae680443571n,
  r: 0xe6e07f381aaf5959d20b7a2f3585bdd2a52bec0125032ae680443571n
}, {
  a: 0xf3n,
  b: -0xc14f31421ca3c92da806b08536d82aa7999c27667950415546c886cabn,
  r: -0xc14f31421ca3c92da806b08536d82aa7999c27667950415546c886c5an
}, {
  a: 0x6abf1139d3d9b01db5ce325fb7e3940780c037fffaa88f49ff55bbc11b1c04n,
  b: 0x79d342535586d42df37dc0258ff60f88a10a545bc3bdn,
  r: 0x6abf1139d3d9b01db5b7e11de4b612d3ad334a3fdf27794677f4b19540dfb9n
}, {
  a: 0x15fn,
  b: -0x72d74dbc55d02fddb4cn,
  r: -0x72d74dbc55d02fdda15n
}, {
  a: -0x5efe383b1253de110e7ef8f4a0a03fn,
  b: 0xf6e4c1c530594f9dn,
  r: -0x5efe383b1253dee7eabf3dc4f9efa4n
}, {
  a: 0x3b20906a328122f91d835bce37cf632dc91dd07b1f50db8aa66531577470b481df45n,
  b: 0x879cd8b534a26e9a35788e7ac48da1020acec439f8a6a4b41671cfd0d42n,
  r: 0x3b20906a3af8ef724ec97d279498ebca65550a6b3ffc37c939ef5b1c3517a87cd207n
}, {
  a: 0xfaf2ac899n,
  b: 0xda125625d2421af84c9c3db216c1a0fa51fd4d12ff270c72c2d524695c1a7bfn,
  r: 0xda125625d2421af84c9c3db216c1a0fa51fd4d12ff270c72c2d52493aeb6f26n
}, {
  a: 0x3cn,
  b: -0x3249c52b105ef3n,
  r: -0x3249c52b105ecfn
}, {
  a: 0xae2c353c492cbe8e4e213b08n,
  b: -0xe549ef65b95d554cde24b92865456ff12eead5c8610e9573b2807cdc78an,
  r: -0xe549ef65b95d554cde24b92865456ff12ee0370b32ca07b85a649ecfc82n
}, {
  a: -0x94983f46c66230b2e8ff99e8c2168cbb2d69b39ce8b1cd01b705536a64n,
  b: 0x325370676fe9c65c17715897acd5d6bbcdf307n,
  r: -0x94983f46c66230b2e8ffabbbb271e352eb35a4edb02661d461be9e9965n
}, {
  a: 0x82beb170cdc7127f8a4963cf64c1174n,
  b: 0x3c64c8312057edd252b1624efcb85cb1720f8c68d45820dfe866acdea66n,
  r: 0x3c64c8312057edd252b1624efcb8de0fc37f41afc627aa968ba9c81fb12n
}, {
  a: -0x9247a04777d3n,
  b: 0x1c2ff62b6f6375a9a02n,
  r: -0x1c2ff6224b1971dedd1n
}, {
  a: -0x732ee481c1ee86b42bb0e2ef16d72c4772aaa8089f44b083c39b3e4cee1195f1466n,
  b: 0x66ac61c6d23d5919ea39df715db9923b51e0ba804ba9n,
  r: -0x732ee481c1ee86b42bb0e2e97c11302a517f39963cd9479618021df9f01a3df5fcdn
}, {
  a: -0x8e0e7b4e8690145872a069d18cb42n,
  b: 0x1221d6b6an,
  r: -0x8e0e7b4e8690145872a07bf05a02cn
}, {
  a: 0x8f757b3d0376a2f7188196f10n,
  b: -0xd961a01099397dd61c1389b52d6059a91n,
  r: -0xd961a010164c06eb1f652b4235e1cf581n
}, {
  a: -0xe4a7958b20ee9da13efbdn,
  b: -0xe056d08808a6aa92837e60a657607a605dd431058ea277ac6d2657788230n,
  r: 0xe056d08808a6aa92837e60a657607a605dd4310bc4db2f1e63cf8d6b6d93n
}, {
  a: -0xfec65ee29eadn,
  b: 0xan,
  r: -0xfec65ee29ea7n
}, {
  a: -0xfb2bef6a4abcd4cd6d24d95054cdn,
  b: -0x3156a3c89285609e1d708f00379ca0123b55240bbe5c8b58n,
  r: 0x3156a3c89285609e1d70742bd8f6eaaeef98492f670cdf9bn
}, {
  a: 0x760e2b0dc6c7ae8cd3fe64ad4455f8c4c0a1143fdbe9e77abn,
  b: 0xab3e6a32648321a4b55ec49138ca7aff0c2c9467d9ac4e806efa2110dbd8n,
  r: 0xab3e6a32648441460582a8ebd007451946f8d13855e044912d079f8eac73n
}, {
  a: -0x5620d40f9b4c507e0a12724a7c180c19c5e0c6c33dn,
  b: -0xbc0656a6f46efe88a62baca2dbf0ac861a6f96bdebe396dab06e6dn,
  r: 0xbc0656a6f46ea8a8722437ee8b8ea6946825eaa5e7fa533a76ad50n
}, {
  a: 0xad8851072n,
  b: 0x3374d5f7dffbffd8b291ae927099dc5d04e8b9n,
  r: 0x3374d5f7dffbffd8b291ae927099d68581f8cbn
}, {
  a: 0xeabab106409380c7c58359ff61673aa07318bf5ef8379d4ef140e3fn,
  b: 0xeae2d69a439407an,
  r: 0xeabab106409380c7c58359ff61673aa07318bf5e12d54bd4b2d4e45n
}, {
  a: 0xaf8425759602a1c3afc4efn,
  b: 0x7dd7a3e9391dbefa97535bd0531a463e73a7ab4d8c2de84da2a2dn,
  r: 0x7dd7a3e9391dbefa97535bd0531a46348be5fc14ec07f4775eec2n
}, {
  a: 0x21fn,
  b: -0xe87c6a0n,
  r: -0xe87c481n
}, {
  a: -0x245eaf2f0119n,
  b: 0x4ba27c4277c48f7440n,
  r: -0x4ba27c66296ba07559n
}, {
  a: 0x2d552b94ebce1fe60287a990affa282ffd0d7816adec000189b1d0e58fn,
  b: -0x78a3n,
  r: -0x2d552b94ebce1fe60287a990affa282ffd0d7816adec000189b1d09d2en
}, {
  a: 0x6fa505349f484f0636f647aa1e837b2072aef58b31d14ee3766n,
  b: -0x1937bc7n,
  r: -0x6fa505349f484f0636f647aa1e837b2072aef58b31d157d4ca1n
}, {
  a: -0x8acfc046c65b7e6c63fb943e4cabe7c815d184f3bfb3aa6e0ben,
  b: 0x7a40d2f3f9ef732869n,
  r: -0x8acfc046c65b7e6c63fb943e4cabe7c8127589dc802d5d5c8d5n
}, {
  a: 0x4c5622d1c4a583e000e554b8c3a6d1d3f199366e849d72c15b2a504dn,
  b: -0x5390348ab9ef0599819cce51b3bcff49a945185189n,
  r: -0x4c5622d1c4a583b390d1de012ca348526d5767dd38623b681e3201c6n
}, {
  a: -0x211dbf376fed85bb81d4fbd96125f504932f5735e4ece4418n,
  b: -0xda9ade38680452703c98n,
  r: 0x211dbf376fed85bb81d4fbd96125f8ad3eccd1b5a1cbe7880n
}, {
  a: 0x29a1c2880f0fe170b301126489c70c6ee82772d065e5n,
  b: -0x5072f18588714c848d1n,
  r: -0x29a1c2880f0fe170b30112648cc02376b0a066182d36n
}, {
  a: 0x813cb17773c899787138fd7033n,
  b: -0x9ca93751ef0058bddn,
  r: -0x813cb1777a020a0d6fc8f8fbf0n
}, {
  a: -0xf719d33873f8f65n,
  b: -0xbf5a7518299a7e2d75c84bf12n,
  r: 0xbf5a7518296d67fe4dbbb3075n
}, {
  a: 0xeaa1e607c8fb5d22d7df5f195259dba362e0aa105955a7ddde7574n,
  b: 0x4d102e8a439135d82ebd6e009b0eee5422ea9ed8907fda57b1n,
  r: 0xeaa1ab17e6711eb3e20771a43c5940ad8cb488fac78d37a20422c5n
}, {
  a: 0x7e3e6131ca5b33d28d20598546915d62d886f2effc3e95ac6f341507dn,
  b: 0x3288c2n,
  r: 0x7e3e6131ca5b33d28d20598546915d62d886f2effc3e95ac6f373d8bfn
}, {
  a: -0x2fea3a7a0n,
  b: -0xc1b7421eb6733038d4n,
  r: 0xc1b7421eb48d939f4cn
}, {
  a: -0x87873737bc7cc33978c498b797fn,
  b: -0xbb7f842375facf491c77ad1n,
  r: 0x87878c48385fb6c3b78d84c03aen
}, {
  a: -0x8fn,
  b: -0x80e4d03bbad368cbe64a65dcfa27280c689d3f5836d5739681a4a51dn,
  r: 0x80e4d03bbad368cbe64a65dcfa27280c689d3f5836d5739681a4a592n
}, {
  a: 0x39b093a014f3an,
  b: -0x6e38ba3567c08824d3e5c0cb2838334cf57031642dc227c8c6343f1n,
  r: -0x6e38ba3567c08824d3e5c0cb2838334cf57031642dfb975b6620ccbn
}, {
  a: 0x2a4fe5a9b94a1a76726bd961b59aa61e4d3698b92ae02d8c265n,
  b: 0xdb08b66cb379c671ec9be4fa5d48n,
  r: 0x2a4fe5a9b94a1a76726bd96c0511c0d57aaaffa7e35e6229f2dn
}, {
  a: 0xc01953f4e4f3be88n,
  b: 0x1b30338dda365c5881aa1de8n,
  r: 0x1b30338d1a2f0fac6559a360n
}, {
  a: 0x3n,
  b: -0x265ab4ab412e3610bffea7fbbd50c446858ac3276d6ea422f1ede874n,
  r: -0x265ab4ab412e3610bffea7fbbd50c446858ac3276d6ea422f1ede871n
}, {
  a: -0x723de2000193d0a6459an,
  b: -0x4ca49bb531f693n,
  r: 0x723de24ca5086597b30bn
}, {
  a: -0x808ae8831888fb2dc0a93e4df9482e1b2n,
  b: -0xf411d068n,
  r: 0x808ae8831888fb2dc0a93e4df609331d6n
}, {
  a: -0x3dn,
  b: 0x45199b07d68d8ac943b9bfn,
  r: -0x45199b07d68d8ac943b984n
}, {
  a: -0x7n,
  b: 0x734637d36n,
  r: -0x734637d31n
}, {
  a: 0x14402b99a1f160d5n,
  b: 0xf3fb0234d43ebface72574523aa223fe18a28e372889ef3ced88n,
  r: 0xf3fb0234d43ebface72574523aa223fe18a29a7703104ecd8d5dn
}, {
  a: 0x1f74ed3e30ef6e58fff5f9c338344866f503aa4957ae4f7379a15bf66c8054n,
  b: 0x9633ce58n,
  r: 0x1f74ed3e30ef6e58fff5f9c338344866f503aa4957ae4f7379a15b605f4e0cn
}, {
  a: 0x738858b4c3ae248f82406cf1c8ae530da82e830941997eeen,
  b: 0xd668944cbf4bb46497bb53d89a162c1fb7e96c7c18b29c6a6ec831n,
  r: 0xd668943f371300a7399fdc5ada7addd719ba61d43631952bf7b6dfn
}, {
  a: -0x335a67e784b278e10bdace047f5c44e7db3c49f1b460301fad5828b98610ean,
  b: -0x201c337a06d1afc0aca234679183bb8612af1f3276e76d4255afb40b4187n,
  r: 0x337a7bd4feb4a94ecb766c3018cdc75c5d2ee6ee8616d772ef0d870d8d516fn
}, {
  a: -0xde637bce156b65f4c13438d098d09e2cf07efd2066c9562c7444a9621bfc784n,
  b: 0x3c2fd31e3fbe39562fn,
  r: -0xde637bce156b65f4c13438d098d09e2cf07efd2066c955ee89754a99f8691adn
}, {
  a: -0x9ddc7e46d357d2c2901a8794dfd954c629de6ccecdn,
  b: 0xb3568a5en,
  r: -0x9ddc7e46d357d2c2901a8794dfd954c6296d3a4493n
}, {
  a: 0x48800c944n,
  b: 0x902b93d8388a144bbe121f836fdn,
  r: 0x902b93d8388a144bbe5a9f8ffb9n
}, {
  a: -0x26551a9081248b7bcn,
  b: -0xd6812cn,
  r: 0x26551a908129e3690n
}, {
  a: -0xce66e431d2f8f3d4e048bb07a1ac7852639961fa54be86f298d252615ec20b451n,
  b: 0x88197a9039b455d6817bc176eed13cf290f5f4372d5c6bc1256943261beec0n,
  r: -0xce6e65a67bfb6891bd20acbbb6c29541acb06ea517cc533424c004f56ca3b5a91n
}, {
  a: 0xbn,
  b: 0xeb1d44c3f9cc700ca75342d8f8724223265100927333b8b5826c0934ff46b57c87e33dn,
  r: 0xeb1d44c3f9cc700ca75342d8f8724223265100927333b8b5826c0934ff46b57c87e336n
}, {
  a: -0x1c6dd218b1631b5383dc2fea38293e6a75941a52ad6b7b284c0ebe0660n,
  b: -0x32c06de92457f378841114187ea19cbb34d98f1n,
  r: 0x1c6dd218b1631b5383df03ece6bb7b15421c5b43ecec913187bdf39eafn
}, {
  a: 0xc884705d30af500dn,
  b: -0xc61b4d5e59204n,
  r: -0xc88811e9e54ac20fn
}, {
  a: -0xfdb1689a32f89b31e6529b15970d95cf4b1af9a16002b7214n,
  b: -0xaee6337dfe88b9ffc98af6057b8dc729n,
  r: 0xfdb1689a32f89b31ecbcf82248e51e50b78256c137ba6b53bn
}, {
  a: 0xb6d8e0f0d5f0aa8495e314d2f313fee994f364df5649ea9fed7b4c8aa623480364n,
  b: 0x8efe4c24e5d7n,
  r: 0xb6d8e0f0d5f0aa8495e314d2f313fee994f364df5649ea9fed7b4c04586f6ce6b3n
}, {
  a: 0xda4n,
  b: 0x30250792557b96315914fe93959f7dc653n,
  r: 0x30250792557b96315914fe93959f7dcbf7n
}, {
  a: 0x62f146291706de503737c3cf9df76cn,
  b: 0x9da989d8a5fd4f18dd7b5473ecd7501cc07728732e94a0f80fe7bdacf4fn,
  r: 0x9da989d8a5fd4f18dd7b5473ecd75633d415b9034371a38b73db4473823n
}, {
  a: 0x6236ba00554533fe0bfb80dde07b486c750ebc11760bbee10ean,
  b: 0x56n,
  r: 0x6236ba00554533fe0bfb80dde07b486c750ebc11760bbee10bcn
}, {
  a: 0x7942dd75f608fa02be47b30n,
  b: -0xa5a761a803675ff5d79026f69715eeba3587218d4e34b862n,
  r: -0xa5a761a803675ff5d79026f69081c36d6ae7ae2d65d0c352n
}, {
  a: 0xcdc9caf2fa9a1f03b238ddd906889dd17dbed02db83423d9e2ed54abc206n,
  b: 0xad3e62ffa61eafa315f1309f98ee49a82f788d71bf80e3a84d67158af8ca4n,
  r: 0xa1e2fe5089b70e532ed2bd420886c07538a360736403a195d349c0c044ea2n
}, {
  a: 0xc6be12572a77149fd2604d53011n,
  b: 0x6a47855957a0ba828aeb14f2509283dbc06cn,
  r: 0x6a4785595bcb5ba7f84c65bbadb4870ef07dn
}, {
  a: -0x27c82ee9b5aadb720e01b4e5bb5155f62b59e83n,
  b: 0x3d1a8c188ed7debcb0973cbe549b68cd316baf0ce9a46c6af3n,
  r: -0x3d1a8c188ed5a23e5e0c6613e3bb88d67f301a19b6c6d9f472n
}, {
  a: -0x8n,
  b: 0xfa83ff6e8cf690d6b9f7fbddn,
  r: -0xfa83ff6e8cf690d6b9f7fbdbn
}, {
  a: 0xf1df19bfban,
  b: 0x9a7fa3e6bb5ff930a700b9n,
  r: 0x9a7fa3e6bb5f08efbebf03n
}, {
  a: 0x98c32ffaa2d9de16ce451e9a8b313359f80813d2e2c331fn,
  b: 0x1ec37cecf72b77433d1n,
  r: 0x98c32ffaa2d9de16ce451e9a8b312d9a84e4e4f995800cen
}, {
  a: -0xe0dcfeebb9512e8307f55941ee56d63f184e0c283855f39425596b6bd73n,
  b: 0xf59e68cadc737cb442n,
  r: -0xe0dcfeebb9512e8307f55941ee56d63f184e0c28370c1518889e5ca0931n
}, {
  a: 0x2dcb8a1db97051825b67a09cf0ae229245811550d4861e3f750n,
  b: -0x9aabe8555190379e2697c4b419a0effda1ec25e3f8125ea0d29ea1ae4bb96cn,
  r: -0x9aabe8555192eb26874c53b101855987a8232f01d13606b18793e9cfa84e3cn
}, {
  a: 0n,
  b: -0xad016826d696a621fdeaabb5d47d5e55ce301059767d98n,
  r: -0xad016826d696a621fdeaabb5d47d5e55ce301059767d98n
}, {
  a: 0x2bfd1775019f423f44c1fn,
  b: 0x4736233d4fa5f4e80040n,
  r: 0x2f8e7546d5651d71c4c5fn
}, {
  a: 0xfaadfa30680c52f72afde537e23dfaffdc703bc0390b9c8n,
  b: -0x3bc6cfc5737cd5f17e417dn,
  r: -0xfaadfa30680c52f72afde537e18196038b47f69f2eef8b5n
}, {
  a: 0x963d5an,
  b: -0xf2b38f979ed07d394a1bce0f88e25f41229873155fbcb2dae2875c6911cfcn,
  r: -0xf2b38f979ed07d394a1bce0f88e25f41229873155fbcb2dae2875c60721a2n
}, {
  a: 0xae5cb3cfdcae0656a3bb2516e6fc11a3820d3cb53ae5646e1195f98645n,
  b: -0x22c7c779cfb747f5bf3187902e41ca5c7f314fc62958cd81d211a4b03d2b16n,
  r: -0x22c769257c789b5bb967242b0b572ca06e92cdcb15edf764b67fb525c4ad51n
}, {
  a: -0x7b586f73fbe95bc868424e0a6b8b14ee4fa49926821fbe4fbe16f401265d0ff4f64a3cn,
  b: -0x2632219c21354deb2f98762n,
  r: 0x7b586f73fbe95bc868424e0a6b8b14ee4fa49926821fbe4ddd34edc33509d1460fcd5an
}, {
  a: -0xd32fe0111ae8b4996e9e0ded059266b10e94d1f934d4c6n,
  b: -0xf84c3629bn,
  r: 0xd32fe0111ae8b4996e9e0ded059266b10e94de7df7b65fn
}, {
  a: -0x91a7fb1bbb416d631c29b93f4be3cdn,
  b: -0xc1dd235b8f6ab9e0893454c64b0668268dn,
  r: 0xc1ddb2fc747102a1e45748eff23923c540n
}, {
  a: -0xddf0ff556c0fca40de3cf797e5f0fdf99d90d0b7bacbf4a043en,
  b: 0xb36fc05ce574f077ffedfe4fba2f856856000b0n,
  r: -0xddf0ff556c0f792f1e6012e31587021463df6a983fa3a2a048en
}, {
  a: -0x7a25eb28f7a1afn,
  b: 0x79dd4c3ddb4055a8f1c077n,
  r: -0x79dd4c3da165be800661dan
}, {
  a: -0x1de049a476de8af73c90e41dffff6e51ecd0d9en,
  b: -0xda9fe0f1e680b0419b6efe831dcef70b3d3b5d80367827d92d1fd98d136d78e76500n,
  r: 0xda9fe0f1e680b0419b6efe831dcef6d539a11aedded75410235e0672e588662a6962n
}, {
  a: 0x30ed288d8a3c6n,
  b: 0x9d4ec3234b37ad5bbe45n,
  r: 0x9d4ec32045e525831d83n
}, {
  a: -0xb6e97d36ea6ec792c5aan,
  b: 0x742b636fcn,
  r: -0xb6e97d36ea698524f356n
}, {
  a: -0x4e79e53ec5161d8e59ecbcf3b056972a460de3b5b460827n,
  b: 0x5eb3adcba4ecb671b34455a3828457786fn,
  r: -0x4e79e53ec5161865633006bd7b318c1e0357db9df11704an
}, {
  a: -0xbbddfed6b5e7f7b62dde866171537db5bbfbb9d4c41e39be6673d431n,
  b: 0xa42568n,
  r: -0xbbddfed6b5e7f7b62dde866171537db5bbfbb9d4c41e39be66d7f159n
}, {
  a: 0x83554ea756e0f7ce7329f974a2358f92932346d13c45cd9b2b54b007f2a1n,
  b: -0x27n,
  r: -0x83554ea756e0f7ce7329f974a2358f92932346d13c45cd9b2b54b007f288n
}, {
  a: -0x9a7ff727fc1480f006f74273c6eec82f5c0118480dcd913190f0cededb1b38a2510b8n,
  b: 0x669d563dadbe40ae2a8d0c33c82ca0a6e5n,
  r: -0x9a7ff727fc1480f006f74273c6eec82f5c07719d6e174ad59a12660e1827ba685b653n
}, {
  a: 0x4n,
  b: -0x816510012f295cafab56ed0e6378eacac1681c82c8d2e7fb055630670032fbb86aaan,
  r: -0x816510012f295cafab56ed0e6378eacac1681c82c8d2e7fb055630670032fbb86aaen
}, {
  a: 0x468d4697dn,
  b: 0xb4fbdde9b66803fd92cdf107ea167d4an,
  r: 0xb4fbdde9b66803fd92cdf10382c21437n
}, {
  a: -0xc8a335d98ca410ccba4b69n,
  b: 0xac612n,
  r: -0xc8a335d98ca410ccb08d7bn
}, {
  a: 0x8048n,
  b: -0x3d6f7ebf9ecc973da00b130458305n,
  r: -0x3d6f7ebf9ecc973da00b13045034dn
}, {
  a: -0x19193db0b7238829fba7fdfb5325832142b4e67ca750141fa5cn,
  b: -0x5a50d787d6b1f948192eda4508ffb5ee07f27e33e5a64e26697ee8n,
  r: 0x5a5146140dba8b709bb1603ad74a87b635e6557d826c3b272884bcn
}, {
  a: -0xd0510a82991c1895c8c385eca9aa1709b317c83232b640ffb9cf202fa11cd90607040n,
  b: -0x19cn,
  r: 0xd0510a82991c1895c8c385eca9aa1709b317c83232b640ffb9cf202fa11cd906071a4n
}, {
  a: -0x2bac181f3431cf98b49ad2456495386b964a8149f71343970d22c064a08de892dn,
  b: 0x16141d1ee33e7b8d5f47n,
  r: -0x2bac181f3431cf98b49ad2456495386b964a8149f71342f64cf32e5747353d66cn
}, {
  a: -0x934eeed790baa11n,
  b: 0x52ed1d11d8e0b6a39d1123fe78012c299d1a39f0bd542a78f70835fac627n,
  r: -0x52ed1d11d8e0b6a39d1123fe78012c299d1a39f0bd54234c19e54cf16c38n
}, {
  a: 0x1abf732f6070f69d0b22395b0f095a496a42dbe756185384c6fb048a7n,
  b: -0xf8d5e1e82c068bb122d64eca44aedf1d89d988n,
  r: -0x1abf732f6070f69d0b2db405118b9a21d150f683babc1969372399121n
}, {
  a: -0xc37d7f47fa7f5c5314cfn,
  b: 0x1a624d18an,
  r: -0xc37d7f47fa7efa77c545n
}, {
  a: 0xa794fd60cbec31699f26a6e6244499cd854fd773e7174ce70501542ef00ed68n,
  b: -0x85b56355e3ef82888fcc02da1a1834bb722c336d95d9e23d7a32d0af3e682f320fc2cn,
  r: -0x85b563f27712e24363fd6b453cbed29f36b5fee8da0e91da6d7e37aa3f3c01c201144n
}, {
  a: 0x67bbde3292462ac74f0df0cd4f6ad43fdeffbe37de33ec72c9n,
  b: -0xa1ed3d434f2c7d9040fc4b089307c0b3588adn,
  r: -0x67bbde32924620d99cd9c43f88b3d0301a4f3707a238d9fa66n
}, {
  a: -0x592n,
  b: 0x60b56c54956a51839e15564n,
  r: -0x60b56c54956a51839e150f6n
}, {
  a: 0x363fd22a6769358ce764897ffc4bacb12cdaf2d754924474eef1277077a36n,
  b: 0xf9c3880c2f2f722a66a891db8a04n,
  r: 0x363fd22a6769358ce764897ffc4bacb12346ca579660b356489bae6dcf032n
}, {
  a: 0x9245bb133db165e85e5b23n,
  b: -0xfdf00e51d61e68c6c50104876e523f67fn,
  r: -0xfdf00e51d6174c9d7432df9130d7dad5en
}, {
  a: 0xc37b8492ae6fb1d6743edbc30891931ecc66cd3b7ba52c066ae60an,
  b: -0x73067bfdn,
  r: -0xc37b8492ae6fb1d6743edbc30891931ecc66cd3b7ba52c756c9df7n
}, {
  a: 0xa20ef545bc16ccn,
  b: -0xac85e75fdfd2c092f0cab5bfe5421f255610bn,
  r: -0xac85e75fdfd2c092f0cab5b5c5ad4b7e977c7n
}, {
  a: 0x48daa12cff7e8fa1cbbf28bd936830b11643a62bac362dn,
  b: 0xbbf56fffce8a0477b37n,
  r: 0x48daa12cff7e8fa1cbbf28bd93638fe7e9bf4e8beb4d1an
}, {
  a: -0x939f5ac09b1994cen,
  b: -0xe781e6795249d1n,
  r: 0x9378db26e24bdd1dn
}, {
  a: -0xc04b634cf3e1773988888e140818a502858d40fc252255n,
  b: -0x841dc0c61bae128bf97ad5ccc3ac28ef75fab2aa90427d27e11n,
  r: 0x841dccc2ad9addb5ee094d444b4d686effaa9af2444dbf75c44n
}, {
  a: -0xfb002bdd6797e7719927cecc4df00f4b3174f4ac0b1349a602n,
  b: 0xe63daf9cf10eb5dd76d931aa4805fe77683c6a4be598e9e884d9126bfc240c78den,
  r: -0xe63daf9cf10eb5dd8dd91a772f921906f11ba487a868e6a3b5ade6c7f73745dee0n
}, {
  a: -0xf3393dc8107f0ad68a4n,
  b: -0x31823dad73cd73b88f5f7a226e0b86303ec83937a9e27c57ban,
  r: 0x31823dad73cd73b88f5f7a226e0b863f0d5be5b6ae12d13f1an
}, {
  a: -0xe576f5125c2eecn,
  b: -0xe7a65908f0298ee87444f16ca226ff22n,
  r: 0xe7a65908f0298ee874a18799b07ad1can
}, {
  a: -0xc52ec8n,
  b: -0x6a2882e5f3n,
  r: 0x6a2847cb35n
}, {
  a: -0x43bf1cf9341408d1fa0f3d77n,
  b: -0xfc16320232672ben,
  r: 0x43bf1cf93bd56bf1d9294fcbn
}, {
  a: 0x6fc1b70bea60a7cb6091a8fn,
  b: -0xfdb07656ab9d14033b8441n,
  r: -0x601ab06e80d9768b5329ed0n
}, {
  a: 0x2en,
  b: -0x6e4585f62de427f35390c2144098bc39cb1b34a5d5ea44a0e2d9cb2329ffn,
  r: -0x6e4585f62de427f35390c2144098bc39cb1b34a5d5ea44a0e2d9cb2329d1n
}, {
  a: -0xff9c48e764975b18a8f1d3c8004bdec4eb5466c523n,
  b: -0x95a770b92c7c2a16ae984cdfe772841e59eee2n,
  r: 0xff9cdd40142e776482e77d504c9439b66f4a3f2bc3n
}, {
  a: -0x3n,
  b: 0x77ba5e3a878394cf44315f1ce46fc914cfd0ed7b84141987cdbe36b0en,
  r: -0x77ba5e3a878394cf44315f1ce46fc914cfd0ed7b84141987cdbe36b0dn
}, {
  a: -0x2b1beb77ae0eca30c462d7dbfb966c8bd12e9022f51n,
  b: 0xb23a67a26f01894eed50dbf8b149f3981cde538eef6a688e70289cca70cda074d484n,
  r: -0xb23a67a26f01894eed50dbf8b3f84d2f663ebf2de32c45f3cf91fa02cddf4976fbd5n
}, {
  a: -0xd4bbe3fn,
  b: -0x3e0e8adc1eb54dc908878f57603cc8f6358da99a2777ceff8bb6f771n,
  r: 0x3e0e8adc1eb54dc908878f57603cc8f6358da99a2777ceff86fd494en
}, {
  a: -0x74809f0ccd0600b8d18314eae03755005389c65e812928b5011a2n,
  b: 0x21c7fb3e2c060dc7f18ee764c85e9957164n,
  r: -0x74809f0ccd0600b8d1a2d311de1b530d947848b9e5e1762c560c6n
}, {
  a: 0xff5912439e777bfcab8c17b500ffcc73094cb3a029af8e7ee9deb9189a1bcn,
  b: 0xa5993a71572407c1cc699c886fb779d867c1cf1f090e54e2416b2c38426cbdd9cd1n,
  r: 0xa5993a8e0e36445fbb126023e3a0ccd8980dbc1645bdf4cbeee552d19cd5a543d6dn
}, {
  a: 0xb43e1adf31ace2bb6755ba7f2e54ac5692008fb0c15757889e72b9fcn,
  b: 0xa98e630cfbe14aa37f6ea3a6a360f7df503c53db8f28e1cfn,
  r: 0xb43e1adf982281b79cb4f0dc513a0ff03160786f916b0453115a5833n
}, {
  a: -0xa1310d5af556883c44f1ca2a934e379a4be959966b2dc75b910992c787063can,
  b: -0x1692e6819850ed797fb4827d411f9aaf0e48575d6cbf2ca5cb029d438eed98b6an,
  r: 0x1633d78cc2a5bbf143f073b76b8cd4989403be04fad40162909394d1496a9e8a0n
}, {
  a: -0xf249485c90bde5d60df9597f7ee5f5f24e1f70f3fe77af72e08ee078dcef5262n,
  b: -0x8e95780aaf6e3466ac207d9401b24400n,
  r: 0xf249485c90bde5d60df9597f7ee5f5f2c08a08f951199b144cae9decdd5d119en
}, {
  a: 0x9d3fff8f86eebc66aa91ae55245453ec085f3ba6fe271da19d9bn,
  b: 0xdd4e57d5977987e02a89228715e1n,
  r: 0x9d3fff8f86eebc66aa91ae55f91a04399f26bc46d4ae3f26887an
}, {
  a: -0x84n,
  b: 0xd36b9d3f154694900d82ddee0f4d9e40f71e7e83266a46a03aadf0n,
  r: -0xd36b9d3f154694900d82ddee0f4d9e40f71e7e83266a46a03aad74n
}, {
  a: 0x1bb97b9e3334a3bd360n,
  b: -0x91099458beacbb8c0a6c3dbde0f3f257an,
  r: -0x91099458beacbb97b317a38ed4504f61an
}, {
  a: 0xdn,
  b: 0xc6c061n,
  r: 0xc6c06cn
}, {
  a: 0x215d07ffaa71f1ab9db595336195607df212ecb348n,
  b: 0xc02085b5b01f64a5b2c39f01436414a0e3794ee2b1d70e9d99c4266bcn,
  r: 0xc02085b5b01f64a7a713e0fbe47b0e1938201dd4a8810942b8eaed5f4n
}, {
  a: -0xbba44b4e08e9356a18446aafc159d112f157e55b2e0cn,
  b: 0xc92601102194805n,
  r: -0xbba44b4e08e9356a18446aafc159dd809146e742660fn
}, {
  a: -0x9n,
  b: -0x24ac57731ae9d76450f376a653003f1a680af9eb5dbb6bn,
  r: 0x24ac57731ae9d76450f376a653003f1a680af9eb5dbb62n
}, {
  a: 0n,
  b: -0x52a4b0b692n,
  r: -0x52a4b0b692n
}, {
  a: -0xd59a4be51e8478dda0b7d52ac5d745f7b7n,
  b: -0x72aedf3a08f7021098fa5dfn,
  r: 0xd59a4be51e83523053175a5ae4deca5268n
}, {
  a: 0x49f8086e9f048382e63145e66dd4f956396e0106fad69ebe0cf3eecfn,
  b: 0xbcf7748050f56ff8100ce61de0f628223373bcf86b6681716n,
  r: 0x49f808655073cb87e967ba676d1a9888360c8325cded5138ba9bf9d9n
}, {
  a: -0x46c2e57fcbbd22c4aacaa44fdef94664b64c678f3cdc90a89n,
  b: 0xe144b8e21eac4963107429a688e8d29c57b189a0dn,
  r: -0x46c2e57f2af99a26b466ed2cce8d6fc23ea4b5136b6d19086n
}, {
  a: 0xe65f14d0731734a1b86cfff05a477n,
  b: 0xb264bd94en,
  r: 0xe65f14d0731734a1b86c4d94e7d39n
}, {
  a: -0x8288ef80bf2755e089bb5c20c643a949b4fa7n,
  b: 0xa34704e4a4f89bc62en,
  r: -0x8288ef80bf2755e089b168508809e6c008989n
}, {
  a: 0x8ed01e8cbf6a7aa615dbe44b84565a41c6427671672c68c83cff1fa1d6e63ba71d50an,
  b: 0xaca6f84f46f995af556fa68cf929b143bb6a632074a7edefd2e00cf9de3a7b6150e43n,
  r: 0x2276e6c3f993ef0940b442c77d7feb027d281551138b8527ee1f135808dc40c64db49n
}, {
  a: 0xcf7c842ad5cabf2556985ee9ab9a179bbda95c9d13184be2e1745n,
  b: 0x7164fb0f276b15e61e70d37n,
  r: 0xcf7c842ad5cabf2556985ee9ab9a17ead95253ba780dadfc91a72n
}, {
  a: 0x3f05n,
  b: 0xcc4867a1fc7b6772d24fcf74938cab07f8ab267b60cd879554acd25cd8b6f2862ca95dn,
  r: 0xcc4867a1fc7b6772d24fcf74938cab07f8ab267b60cd879554acd25cd8b6f2862c9658n
}, {
  a: -0x310e2225a0539b8b8a25fc140635bfn,
  b: 0x3n,
  r: -0x310e2225a0539b8b8a25fc140635ben
}, {
  a: -0x47f53368b81d89b6d21b204a45e9cdda8a0a070cen,
  b: -0xcb6ff888d487569649n,
  r: 0x47f53368b81d89b6d21b2046f3164557c27f6e685n
}, {
  a: -0xf51a6d9209e7e27a1bf574b51de76a5baf12d1351b057233d6831ee14f667f52b5n,
  b: -0x28a2n,
  r: 0xf51a6d9209e7e27a1bf574b51de76a5baf12d1351b057233d6831ee14f667f7a15n
}, {
  a: 0xc8e01c5f869407ecn,
  b: 0xbc8b03ae5bb57bf75e28bf2867n,
  r: 0xbc8b03ae5b7d9beb01ae2b2f8bn
}, {
  a: 0x531b495598874f3a7da4cfdccb9b6c4ff001ea44n,
  b: -0x5e017fe6694c436d143ff7b5884de41fd776f9566dd2c24bac0f5c5n,
  r: -0x5e017fe6694c4368258b62ec003917b80d3a049ad46406b4ac11f81n
}, {
  a: -0x2da1354021eaaf20a779084c57caa22075dbb118ddd6cd7d45c94eb951e4f7c4d166an,
  b: -0xacf953921b308e695166b1b799668da82en,
  r: 0x2da1354021eaaf20a779084c57caa22075d17e8de4f77e75a35c58d24a9d61ac0be44n
}, {
  a: 0xc182748f29n,
  b: -0xcb8a3n,
  r: -0xc18278378cn
}, {
  a: -0x5416106d999d980932fade33bfd2f4f67f02cebf421bd2fa522351dan,
  b: -0xd161808d6dac081909f5e95ea661b3ca2952d5c1fd69e0n,
  r: 0x5416106d994cf989bf97723ba6db011f21a4af0c8832802f93de3806n
}, {
  a: 0x4b0ff0aa5a839f1n,
  b: -0xad3c237620de957b80558cfd3656cfn,
  r: -0xad3c237620de957f30aa86589e6f40n
}, {
  a: 0x4f8652b251785d76dba5612b3c71697f0022n,
  b: 0x5f987ca5ff232b6ae15c2d3an,
  r: 0x4f8652b2517802eea7009e08171b88232d18n
}, {
  a: 0x1369480afdb99761483e9d40c3ea0dn,
  b: 0x7a9a0df4140f9fece37e89b323527383c656n,
  r: 0x7a9a0de77d4795115ae9e8fb1dcf33402c5bn
}, {
  a: 0x482555ee9622458691de35n,
  b: 0xa0357an,
  r: 0x482555ee9622458631eb4fn
}, {
  a: 0x9222f4cbf4f7fdff9c4d232c1b83c04b9ac43d7de3792cff65bn,
  b: -0xe0dn,
  r: -0x9222f4cbf4f7fdff9c4d232c1b83c04b9ac43d7de3792cff858n
}, {
  a: -0x62220c990fn,
  b: 0x521f638092bbe531a1faa4533e62adca0a5736cb4b638cbc97d8573n,
  r: -0x521f638092bbe531a1faa4533e62adca0a5736cb4b638a9eb711c7en
}, {
  a: 0xda1da4a322240deac7e92206471b8e296a7ae843e842e71can,
  b: -0xa0b24n,
  r: -0xda1da4a322240deac7e92206471b8e296a7ae843e84247aean
}, {
  a: 0x81aebc02f31373279fc1edfbe50a3718e38n,
  b: 0x1baca359e04545cn,
  r: 0x81aebc02f31373279fc1f6574653d75da64n
}, {
  a: -0x8fdcbb0e66def9125aad0c222ea33e49c53e69087a207cd9b6e62f7cf793db426d0n,
  b: 0xc789n,
  r: -0x8fdcbb0e66def9125aad0c222ea33e49c53e69087a207cd9b6e62f7cf793db4e147n
}, {
  a: 0xcf3be2a08aab108aaa9dec29cfd37343da308d64659b650n,
  b: 0x1c6cb68f2647997d4ba9980fd229952e6c5ee6817d5fbcd4a17n,
  r: 0x1c6c79b4c4e713d65b2332923e005afd1f1d3cb1f03bd94fc47n
}, {
  a: 0x5c60e34766222fa34d91176f8d6d6db706ad363c03af463n,
  b: 0x28deae81aa2fb552a0n,
  r: 0x5c60e34766222fa34d91176f8d6d6f3aec452c9ef8fa6c3n
}, {
  a: 0x4388a13e88c0a2768n,
  b: -0xe83777300af39eeec2c2c8n,
  r: -0xe837730880e07662c8e5b0n
}, {
  a: -0xeb45b17n,
  b: -0xfd3aba7bdda81b430f511db58a0803619e7a0aa0n,
  r: 0xfd3aba7bdda81b430f511db58a08036190ce5189n
}, {
  a: -0x77893fd7561b2f9cn,
  b: 0xcccaa51c9d74047edd7436feb65a34a888342a0aa2a77310cf5d9890n,
  r: -0xcccaa51c9d74047edd7436feb65a34a888342a0ad52e4cc79946b70cn
}, {
  a: 0x8d2d668e129e893dee1854cn,
  b: 0xd69b33fc54a628c5c1f1ecaf9da2a02d6096c4150ef4a5c0b7de29543567cf6c6n,
  r: 0xd69b33fc54a628c5c1f1ecaf9da2a02d6096c4150e7988a639ccb7dd0889d738an
}, {
  a: 0x6055b5006992de0e016e47ba18d210022ccbd274561de55516719b5n,
  b: 0x922c26d4e6616ce2046cff8dc962eb1a903026192fac3e5ba0d09cn,
  r: 0x6977776d27f4c8c021288842c4443eb385c8d015c4e726b0ac7c929n
}, {
  a: 0xf135b3908a603ae7n,
  b: -0xe99a8ccf6737a20257f3f9699ee7f75e14dcc6ec58491068edec5bdd5n,
  r: -0xe99a8ccf6737a20257f3f9699ee7f75e14dcc6ec575a4b51e54a58734n
}, {
  a: -0xf4aeb85e32a494e66f1b0a0e814bd14fecb1c631an,
  b: -0x67e480be12528n,
  r: 0xf4aeb85e32a494e66f1b0a0e814bb6ab6c0fd463en
}, {
  a: -0x262b218ffd701326e6768abb2a0eafcffe798f57n,
  b: -0x6df36991fe1f2df670aan,
  r: 0x262b218ffd701326e676e748439f51d0d38fffffn
}, {
  a: 0x7cfb6156a7n,
  b: 0xe1e5c0ee8f40e4cfa4c8c974198068d1ff29851a2ea8d86a531d52e30a95d97d67ecen,
  r: 0xe1e5c0ee8f40e4cfa4c8c974198068d1ff29851a2ea8d86a531d52e30a9216cb72869n
}, {
  a: 0xff713b99cef7abbe2e3bf8782c09e8n,
  b: -0xe7a11953edc922dd9f7e82ba261e82061fa3e96ebcbdc219c8f48131fn,
  r: -0xe7a11953edc922dd9f7e82ba26117515a63f0614075f21a64f7641af7n
}, {
  a: -0xd79284e3d1f9e08f22fda8ab1296ed12282623ac77eb2n,
  b: -0x992n,
  r: 0xd79284e3d1f9e08f22fda8ab1296ed12282623ac77720n
}, {
  a: -0xf329c6e9e02d214a4266004ed9bab869e7e13a63205b241aa36an,
  b: 0xf36077de1ae99716f6a0ae6d58a4f6429n,
  r: -0xf329c6e9e02d214a42693649a45b16f0968e5069c68eae55c741n
}, {
  a: 0xb6a2f4795c555c47ca0f33865c3aen,
  b: -0x2945ee075d60919ccccb8a7a948946f881904f7n,
  r: -0x2945ee075dd63368b597df26d34349cb07cc759n
}, {
  a: -0x6d1c7eeff8d9a0beebad3ee2ddc63a6e20161d7ed0e0d07beb9n,
  b: 0n,
  r: -0x6d1c7eeff8d9a0beebad3ee2ddc63a6e20161d7ed0e0d07beb9n
}, {
  a: -0x6d702ed762d39701959b9220c2d13afede8de1bacc05506ebd07fbe6ded91f31c51c2n,
  b: 0x66f30e6726149dcefc40301b18e78efbc5f4b58542873db09054n,
  r: -0x6d702ed762d3970193f4a2c6b0b073223149e2bb7d8b28810158b0be8af16ceacc196n
}, {
  a: -0xcc11e7ffa93afcb749eaden,
  b: -0x41bec768e587bdb13dfb2ea806cd90353ca5a2a02cf55n,
  r: 0x41bec768e587bdb13dfb2ea4c7d3efcfaf0a69d4b2589n
}, {
  a: -0x5db9ed2a20db194fbae8ee30e9c6e83693b9efbed2f0b4461n,
  b: 0x1d823c0cee90e694d9992ccf4fbf9e6f14b51d413fc193646519bebbce2n,
  r: -0x1d823c0ceecd5f79f3b9f7d600057681245cdba909522a8bdbcb4e0f883n
}, {
  a: -0x36b260a2eb6b45bb692a1676028ad6n,
  b: 0x1b5fdea8e0feace4cd4c584df99da9118b1cfc31b811n,
  r: -0x1b5fdea8e0feacd27f2cfaa692d81278a10a8a3332c5n
}, {
  a: 0xef08a0da9e27cd98d642n,
  b: -0x4920532e782dc417daba501c250ee1d1f3d8f83d20bed9adaf2n,
  r: -0x4920532e782dc417daba501c250ee1df0352f594c2c20020cb4n
}, {
  a: -0xef6aaefc01b61c3aea76c3d189c04bd3e2fd1n,
  b: 0x5e4c409bn,
  r: -0xef6aaefc01b61c3aea76c3d189c04e3726f4cn
}, {
  a: 0xbecd102e1b9bn,
  b: 0x3aef5c103a5e0cn,
  r: 0x3a519100144597n
}, {
  a: 0x939d5c19237cfd96d9c898dn,
  b: -0x364dec6fe821210b07cc08ebf421n,
  r: -0x364de5563de0b33cc81565777daen
}, {
  a: -0x9e2d3101c315cbc2f116ff11e533n,
  b: -0x59d5ae3544n,
  r: 0x9e2d3101c315cbc2f14f2abfd071n
}, {
  a: -0x319d67e10c2ce7edede4888507faf1d3fee6adc251bb3dfb6a62n,
  b: 0x53fc63cd88n,
  r: -0x319d67e10c2ce7edede4888507faf1d3fee6adc251e8c198a7ean
}, {
  a: 0x3eeb82b8569n,
  b: -0x6b62a7b1479351b1b685e55183600660f4a8b295a514100fc769cd396a1d7n,
  r: -0x6b62a7b1479351b1b685e55183600660f4a8b295a514100fc75726bbd24c0n
}, {
  a: -0x7b7bd9b1d1cdaf5389f4fa4ef65ebbc739d745e5615d289dn,
  b: -0x2a94467d74d03991e5d4f877dbafda2dbd21a3cn,
  r: 0x7b7bd9b1d364eb345eb9f9d7e803f440446db847ba8f32a7n
}, {
  a: 0x4e3e3aacf065b5bn,
  b: 0x2c8036c48b6dceea84093fc0fb24n,
  r: 0x2c8036c48b6dca0967a3f0c6a07fn
}, {
  a: 0x3787n,
  b: -0xe041220f4f6af16338ac7d45c93017e5cd6a09f1fa47735f8aea1d11n,
  r: -0xe041220f4f6af16338ac7d45c93017e5cd6a09f1fa47735f8aea2a98n
}, {
  a: -0x8da4n,
  b: 0x236dadf7bc3f55d434b192f99830e57d44674387n,
  r: -0x236dadf7bc3f55d434b192f99830e57d4467ce25n
}, {
  a: 0n,
  b: -0x5c01aca31de18dfn,
  r: -0x5c01aca31de18dfn
}, {
  a: 0x4c7a010be3de65c7n,
  b: 0x914a16025058c794d8d5d2575fcac276ba17c1560c6a007c174072dda88dn,
  r: 0x914a16025058c794d8d5d2575fcac276ba17c1560c6a4c06164b9103cd4an
}, {
  a: -0x94f8d24a9ccb29890f1254e8ba42ec6052d3f035487n,
  b: -0xad71bdbd91dcad20975c22ca1d5c62f75716039df01699n,
  r: 0xad78f230b57561920fccd3ef53d7c6d991132ea2f3421en
}, {
  a: 0x4a6c9a99d88f9e2a531d4ef5e6975n,
  b: -0xf7c6e15939c2b36f61729528e9498n,
  r: -0xbdaa7bc0e14d2d45326fdbdd0fde3n
}, {
  a: 0xcn,
  b: 0x1177d59aec9efc49c7c428363aa08d43d80ecn,
  r: 0x1177d59aec9efc49c7c428363aa08d43d80e0n
}, {
  a: 0x36a61can,
  b: 0x9db188a6519e4c35aa6e3fa08845e5d26e7b47aea6089cdd52160010n,
  r: 0x9db188a6519e4c35aa6e3fa08845e5d26e7b47aea6089cdd517c61dan
}, {
  a: -0x1b5d9c967651a9249bbd0afen,
  b: 0xe61005n,
  r: -0x1b5d9c967651a9249b5b1af9n
}, {
  a: 0x62439fbabdc44658e37424629110a1d202f2c99d34752bdec59c91663347cc639n,
  b: -0xe035a625740a3bb935937d4936an,
  r: -0x62439fbabdc44658e37424629110a1d202f2c97d01d30eaacfa72853a03a85551n
}, {
  a: -0x9169748475b87b21eae0e595c6da35b1bf836737662b82557830dfb1656n,
  b: 0xe0a506d5330cc9ad1addd7493566b95a91c51bd54686bb0231ba9n,
  r: -0x91697464d0beae12e629488f1b0d7c84d93a3da6a3305713fe8bdd80dfdn
}, {
  a: 0xe45c58843ec3c829ea6122834f041cd54517be6619c5e3867a8n,
  b: 0xa825c5f5d99315a6ea309f115573422159c5b2bn,
  r: 0xe45c58843ec3600c2f94fb105aa2f6e5da06eb155be4ba43c83n
}, {
  a: 0xdfacc767b6bn,
  b: -0xc35fd582227d906d9a4f328453d4f293d930aaef2d35e38n,
  r: -0xc35fd582227d906d9a4f328453d4f293d9307543ea5255dn
}, {
  a: -0x96b56fb12ee3974f61bf94b1fdbbd483d569e62a29n,
  b: 0x789a53981fad48af336d750591a5020ca7b2969d4784495ad4ebdecfe2f50a57cf39n,
  r: -0x789a53981fad48af336d75059133b763169c750a08e5f6ce6516651b612063b1e512n
}, {
  a: -0xb02cb8e0048b5bffa2d2d844acbdcaa7a2ccdda1f9eae84fd2ab1c8f9ef3b1f49dn,
  b: 0x56e84bd276f86c3186d75034726a335221064fa8913e23b16c63f4adbe46828a123e8n,
  r: -0x56e34919f8f82484392d7d19f620f88e8b7c63654b21bd1fe89ede1c76bf6db10d775n
}, {
  a: 0xaf0e03e6851cc8dc62fb03df9a7e9aacd005cf5bfe36dn,
  b: -0x3bda9ecbfdddbe92a3840e67666287762416099n,
  r: -0xaf0e03dd5f820321bf45917c1e70fdcab282b97fe83f6n
}, {
  a: 0x2c6f858fc6cd0c956fc096b1e9c4189c4f3f1ef052844228ef642323914n,
  b: 0x14adf2fc49e76cf012de5de03bd617385438n,
  r: 0x2c6f858fc6cd0c956fc096b0a31b3758d149d1f17f619c2b520550a6d2cn
}, {
  a: -0x9a0c4012bcebfebd189869b7e2f9n,
  b: 0xaa4bbd0451f159efc702cn,
  r: -0x9a0c401818502ef8078df74b92d5n
}, {
  a: -0xb27ecd9901c60df1fb2db6b5da474f73d0f28bcd1202e44bfa6488af3c430aa6e9fd6n,
  b: -0x56a8524b80ad88a45e10f18a6n,
  r: 0xb27ecd9901c60df1fb2db6b5da474f73d0f28bcd1202b2e3a82f0802b4e754b618770n
}, {
  a: -0x9604c25fen,
  b: 0xc7afe9a4d794ddn,
  r: -0xc7afe0c49bb121n
}, {
  a: 0xc02ea2eb6ad813f999d074c3ee4b759826d28c8b69ba425533c386ef82c603n,
  b: 0x179d7870f7beb5edcdb9edf251d1e99e06e8fce6c514712ea3a16ab45b336e7411d0c6n,
  r: 0x179d787037901706a761fe0bc8019d5de8a3897ee3c6fda5ca1b28e168f0e89b9316c5n
}, {
  a: -0xc9637f5bd4dafdc768bb99687cb0e1a1a2b83n,
  b: -0x7631bc66506dbfb5a5ad50c0ea9c63d06n,
  r: 0xc963096a68bcadaad70e3cc52c700b3dc1687n
}, {
  a: 0xc8c5153a4242b3195714e69975b3d82798ed1c890746a2d69479285b008eb3c00b85fn,
  b: 0xde3b93ac6064dda2e53f8efa3n,
  r: 0xc8c5153a4242b3195714e69975b3d82798ed1c8907467ced07d5483fdd2c56ff857fcn
}, {
  a: 0x1ab88ean,
  b: -0x51dc315340an,
  r: -0x51dc2bebce4n
}, {
  a: -0xbn,
  b: 0x78b7388faefe5fe27c41d035d4b05e2268n,
  r: -0x78b7388faefe5fe27c41d035d4b05e2263n
}, {
  a: -0x4ae477d7df5b087743de667579cbf2ecf9d3025292810bf87afcbce2n,
  b: 0x81969cdd9676f426633c33654843fecf96437797878n,
  r: -0x4ae477d7df5b006e2a13bf12168994df3ae556d6ad6df29c4d85c49an
}, {
  a: -0x6c69646a21b4n,
  b: 0xd8f026ab1eab030505f727e302ed5b3c8121135d500e9d96fa157d26bc660ca0522ben,
  r: -0xd8f026ab1eab030505f727e302ed5b3c8121135d500e9d96fa157d26baa09ae6f030en
}, {
  a: -0xf5e41f47e2dc521354ec57ee4f7dd12ceff7cd7n,
  b: -0xf38f1d6bb553a65897e90bb86a25e333e8342124942n,
  r: 0xf38fe88faa144484c5fa5f543dcbac4e3918ced3597n
}, {
  a: -0xa3b8c2n,
  b: -0x774547274n,
  r: 0x774f7cab2n
}, {
  a: 0n,
  b: -0x5985e5fbc9c1caa754f5411a9dacaeb1a7c3545an,
  r: -0x5985e5fbc9c1caa754f5411a9dacaeb1a7c3545an
}, {
  a: 0xf2692fc034n,
  b: 0x804bf2d1d4885eb0523cc9a08305377cce980cb2a26368n,
  r: 0x804bf2d1d4885eb0523cc9a08305377cce98fedb8da35cn
}, {
  a: 0x6200397a9f7e168c2d8e16571f25c15c38n,
  b: -0x7c8336678591bc57ef24ec913bb0467a39d87f4n,
  r: -0x7c833047860615a00e4c2e49dad5378865cdbccn
}, {
  a: -0x15cb057b09n,
  b: -0x78a56366efa83473962bb1fb6adddecb97d85378131617868cfbec924n,
  r: 0x78a56366efa83473962bb1fb6adddecb97d8537813161787d04bbb22bn
}, {
  a: 0xb827dn,
  b: -0xf147419ef21255001198b8c725ce5657a4bd26e7a241e1da6e6782n,
  r: -0xf147419ef21255001198b8c725ce5657a4bd26e7a241e1da65e5fdn
}, {
  a: 0x7c41617707488d73fe9457daeffe9fb339d68491fa52n,
  b: 0xc59e222a5cn,
  r: 0x7c41617707488d73fe9457daeffe9fb339131ab3d00en
}, {
  a: 0x5be6104f7430c281c268c38e5f3c2175e5846031944a7ce8a8e40cd4e0410ec031881n,
  b: 0x43c9fc73d7735cc4758035b1a327f007b6n,
  r: 0x5be6104f7430c281c268c38e5f3c2175e5805cae53770bdd64a354d7bb5b3cbf31f37n
}, {
  a: 0xa3f00cf5dee396267ff2a97371ccdf02n,
  b: -0x634d33e2727c3eafc22ac4f35ac364n,
  r: -0xa39341c63c91ea18d03083b782961c62n
}, {
  a: -0x6a1d7ff8f0dddffd8fa94e6bd8n,
  b: -0x9dc341dab73321d2d1c7a053c916b65ea8f8c2843b3731254110fn,
  r: 0x9dc341dab73321d2d1c7a053c91017895777cf59c4efcbb1a7ad9n
}, {
  a: 0x2c0faa3b9b4ae51f2b8de6102caa68a707f92c2ca026bd953cc704be20a5n,
  b: 0x260ac8e7a00ca17n,
  r: 0x2c0faa3b9b4ae51f2b8de6102caa68a707f92c2ca026bff590497ebeeab2n
}, {
  a: -0x673648e7fdea10328c2969cbb6475e79118628fbb7194ebe3d1n,
  b: 0x4fb934af2019a0878342ffbea22aee94bf5cab36b8580bbc160d0d3421n,
  r: -0x4fb934a9537d2ef85de3fc9660bc722fdb294ca7a03a84076799e6d7f2n
}, {
  a: -0x725e8cf4f9f973c7b7a82a4600647fc070026e4d7bcd33n,
  b: -0x33a15dbn,
  r: 0x725e8cf4f9f973c7b7a82a4600647fc070026e4e41d8e8n
}, {
  a: 0n,
  b: 0xa57016a0ffb5483196e7aa2d41f21862f82fa3839d9af0bfe960f2dfc05bae37488n,
  r: 0xa57016a0ffb5483196e7aa2d41f21862f82fa3839d9af0bfe960f2dfc05bae37488n
}, {
  a: 0x5cc14ad4327173003d240b0b07c04da816a31ade019d6an,
  b: -0x73edf932b248a2052b3c54757249275032f4afeea60dcfe885d6378dace37262f7an,
  r: -0x73edf932b248a2052b3c51b966e4647725c4ac3ce6bd7f94810cb6e79d4e927b214n
}, {
  a: 0xe4817109ff36172703fc6f9d2f4c2150ef7da2dn,
  b: -0xa13620563e5ea0146c086b0ae09af587an,
  r: -0xe48171a8c91641195d5c7bf127272bb07588255n
}, {
  a: 0xb4n,
  b: -0x1e375fab3f117d2ec8e4n,
  r: -0x1e375fab3f117d2ec858n
}, {
  a: -0xfe71e8f34a2699d54daadb311b8eebb6bc7ec2762n,
  b: -0xc3ae38029fee42dd65901995ff816bd47fcc47acdaac89b0b546ad83d33f9523bd9f7n,
  r: 0xc3ae38029fee42dd65901995ff8195a5973f0d8a4379c41a6e77b60d3889295d7fe97n
}, {
  a: -0x9084880824f805569e9aaadc2431c60b8ef31e7n,
  b: -0xbcff6adn,
  r: 0x9084880824f805569e9aaadc2431c60b320c74an
}, {
  a: -0xec5317n,
  b: 0xb23c5c30a1ad054b81e607438e9b91720d7fbf8dn,
  r: -0xb23c5c30a1ad054b81e607438e9b91720d93ec9cn
}, {
  a: -0x8fe2ca08b747255e83441ad60bf92cfd9061fc1a6f97662676331a1f6f1n,
  b: -0x73ac37fbdf6c9d30c69d12ce77a1663dn,
  r: 0x8fe2ca08b747255e83441ad60bfe163eefdc0ad3bc9b0ff75ad460090ccn
}, {
  a: 0x65319b695ba5a163a95f444f629n,
  b: 0xf2aae8df6557bc14a7eb14ba845952fd942610a9f83612n,
  r: 0xf2aae8df6557bc14a7ed47a332cce8a7821c855dbcc03bn
}, {
  a: -0xa4bf01a628c5ec2c2d41f5fb5a0n,
  b: -0x6435b2e3c5d71d7ae8n,
  r: 0xa4bf01a62e86b702111c842cf78n
}, {
  a: 0x42cb174accc99b76ec68459179e34288392a9bb471d5b5e740f610a43n,
  b: -0xfb5fn,
  r: -0x42cb174accc99b76ec68459179e34288392a9bb471d5b5e740f61f11en
}, {
  a: 0xd723a99ac5220c8ac32fen,
  b: 0x2e410bc2e77154d77a33c2n,
  r: 0x2333315b4b23741fd6013cn
}, {
  a: -0xa70fb5c8c28e3cbfa2911n,
  b: 0x7ea0496915d8e675fc7efn,
  r: -0xd9affca1d756daca5ef00n
}, {
  a: 0x7007050de7f53a40007083703add2d96be5e1f29n,
  b: 0x413b3b21a3fc5f2fc89cn,
  r: 0x7007050de7f53a400070c24b01fc8e6ae171d7b5n
}, {
  a: 0xb7737710cn,
  b: 0xc0d95451b57176ce8afad4eee9cae1ae4e2n,
  r: 0xc0d95451b57176ce8afad4eee97d92d95een
}, {
  a: -0xdcb93712627a189a4bn,
  b: 0xd5613a1f8f71dd68b2aa02433cc4a7d2af6fab5f7fe78c742n,
  r: -0xd5613a1f8f71dd68b2aa02433cc4a7df64fcda79584605d09n
}, {
  a: 0xea3fba3a43323134fed4202448e30ff3cc89c4eb528c27c5n,
  b: 0x5ad31a17825ade484bb3210c52e08598668008087b647n,
  r: 0xea3a170be24a14991a509b16582621fb950facebd20b9182n
}, {
  a: 0x9a684fe877bf9b69414c3430a6557f3n,
  b: -0x608056476109689cdd988c14e08c1n,
  r: -0x9a08cfbe30de9201dd91acbcb2b5f34n
}, {
  a: -0x7cbf369c727dde32aa6cd812d7db9b5929c3d00974ce503d5a9n,
  b: -0x320d68d1aec9b573119cde6c8525n,
  r: 0x7cbf369c727dde32aa6cd811f70d1643c55887386d03b6f508cn
}, {
  a: 0x3ea3a5632ade8ed4d1b4c821ec8f8d1197da002558e4b5808bd38cf63n,
  b: 0xe9n,
  r: 0x3ea3a5632ade8ed4d1b4c821ec8f8d1197da002558e4b5808bd38cf8an
}, {
  a: 0x1a78382e1n,
  b: 0x7e611c74d4fn,
  r: 0x7e7b644cfaen
}, {
  a: 0xb5768855f8c07888fbfeccbc8e10e01aa8a1ccd37da6f20d08ee5n,
  b: -0x84f04773b9d2b3db5840c052bbaef8e65d66ada16b657666fcadn,
  r: -0xbd398c22c35d53b54e7ac0b9a5aa0f94cd77a6096b10a56b6724an
}, {
  a: -0x65b39a101n,
  b: 0x491326d1a177b59287b2ca99ceff3an,
  r: -0x491326d1a177b59287b2ccc2f75e3bn
}, {
  a: 0x3b5b8efb7575662516fff3eae7af46af1d3c5n,
  b: 0xe4f063dn,
  r: 0x3b5b8efb7575662516fff3eae7af464bed5f8n
}, {
  a: -0x64e17b06dad452a7e8e4d488d725340dc36f0f09aedf7b77dde34b4eea64c080fn,
  b: 0x75fbb779d27136dbdbeffe576fe5f1349152152881ad02a76a21n,
  r: -0x64e17b06dad455f8539349afc44889b33c8a79f7f1cc3262fcb1c3543a4eb6230n
}, {
  a: -0xe2dca665cc19c6fn,
  b: -0xe932ad0321f3e2985b0bda259dd0b506n,
  r: 0xe932ad0321f3e29855261043c111296bn
}, {
  a: 0xad331n,
  b: 0n,
  r: 0xad331n
}, {
  a: -0xd94ba1035e71d6b0aeb24ae8486n,
  b: 0xf57a0b9ee418a19f37d8a6d43a2485b3540c916628b1e15787b6dn,
  r: -0xf57a0b9ee418a19f37d8a6d43afdce125752e0b0981f531d6ffe9n
}, {
  a: -0xb58a382f3124859ad9593dddee245b54dc699d141a0a86b9422983d1dbe16n,
  b: 0x7b2de8d4e81c82dceef899991f29164e310d2cc827100fec9984ccfa6d9a58n,
  r: -0x70754b561b0eca85436d0a44c1cb53fb7ccbb51966b0a7870da654c770244en
}, {
  a: -0xd325fd11516470edd6cfdf1d9235291403ff089b531c66b161dd213967f376c465n,
  b: -0x401af1e57a818d0af795014a9aa942f4c46e9e9b6b49b283dab315369ab8b0n,
  r: 0xd325bd0ba0810a6c5bc52888937fb3bd410bccf5cd870df8d35efb8a72c5ec7ccbn
}, {
  a: -0x770a09a4658a8c4e380179cfbf9710544e8faec329cad632e73afe5a7d41ebn,
  b: 0xe733f97n,
  r: -0x770a09a4658a8c4e380179cfbf9710544e8faec329cad632e73afe540e7e7en
}, {
  a: -0x519f1944c4c370e89097dad5200f4b1501c329fef5ac23e71e857n,
  b: -0x614e48fen,
  r: 0x519f1944c4c370e89097dad5200f4b1501c329fef5ac25f3fa0abn
}, {
  a: 0xb41911491e4fba5b232bb18a53bc2cdc881b0f9dde77557e3fn,
  b: -0xf9f5943fd34faeffa0d7fbaa945e6a9c8b4caef868cbe81a4145n,
  r: -0xf9418d2e9a51e145fbf4d01b1e0dd6b057c4b5f7f5159f4f3f7cn
}, {
  a: 0xa7347a0685078ccaba31cd80f1a2a0b0adfd229df996a0fc8dan,
  b: 0xd0b84ab7228a2d7653030bd3919925be2401dc5c58f7c6bacn,
  r: 0xa7e4c24c322506e7cc62ce8b2233399513d92341a5ce573a376n
}, {
  a: 0x650fa0bf7de514b189d8ec18f7c925acn,
  b: 0x7885848e762d8bfa596319267f3fa19e2194e1bee4f36bn,
  r: 0x7885848e762d8b9f56c3a65b9a2b1017f978f9492dd6c7n
}, {
  a: -0x670cdbb1a2598344efa8caabd4d90356e7f7ece8e8738f81f798c18fb230d87e1fben,
  b: 0x7028ffd22ae8bb2a6d830663ffbbc109c757e81n,
  r: -0x670cdbb1a2598344efa8caabd4d90454680ace4663c12959c7fefe740e20440b613dn
}, {
  a: 0xfd252f5ef0cn,
  b: -0x59e719fa74bada7cb41fce4ac62633acn,
  r: -0x59e719fa74bada7cb41fc19894d3dca8n
}, {
  a: -0x62d63n,
  b: -0xe85269ac96bn,
  r: 0xe85269ce408n
}, {
  a: -0x8de76698239d579a9d59efbc14776664n,
  b: -0x5e04ec73ef53c54e42004b553912f1cac6796n,
  r: 0x5e04e4ad993a47779779e280a7e9308db01f6n
}, {
  a: 0x3554ae1805e6b3b8e0e78e926766e4429da8dd7e260n,
  b: 0x7086d29941b39c005957374ca60c5dc49277d1dffc44544a042n,
  r: 0x7086d29974e732185cb184f446ebd356f511359d61ec8934222n
}, {
  a: 0x5fn,
  b: 0xb6fe43e738564dcd61e7e7dcc0d35d7b154cb77057an,
  r: 0xb6fe43e738564dcd61e7e7dcc0d35d7b154cb770525n
}, {
  a: 0xc9f6n,
  b: -0x79e479e3n,
  r: -0x79e4b015n
}, {
  a: -0x817f2b4eac5cec28de72496103b611c84n,
  b: -0x56c28b1c83a05819682db06b24cfee7f9c2cd9905c84687n,
  r: 0x56c28b1c83a058981706fec77823c6a1ee65b893ea95a05n
}, {
  a: -0xea4e288e94b3168b7e8b9cn,
  b: -0x9d65deb5f88bban,
  r: 0xea4e288e09d6c83e860022n
}, {
  a: -0x9a708d84c88b711116d1326c162177a4ffe35fc8efbb4ebcc6bb61e386351n,
  b: 0xb6c17aea8fec91e5ed31f4fe126106086375e29748ff5b8438569an,
  r: -0x9a708d8fa49cdfb9e8182c32c53e3845d9f33f4ed8e567c8494ed9a0035cbn
}, {
  a: -0x715dfa0e4ae258644d17d28992a548091ae051bc204d55cfe119666fcn,
  b: 0x4fc14dd35eb0be7f9357b3ec9c455c3ae092c1c6n,
  r: -0x715dfa0e4ae2586449ebc654a74e43eee3d52a82e989000c4f104a73en
}, {
  a: -0x5baa80326008n,
  b: 0x860d4e749c08n,
  r: -0xdda7ce46fc10n
}, {
  a: 0n,
  b: 0x6c2bfd399f3ae5e3b62f5e80b460bf49fb9e7c33044acd1db5b6n,
  r: 0x6c2bfd399f3ae5e3b62f5e80b460bf49fb9e7c33044acd1db5b6n
}, {
  a: 0x8069f4a3acdc435b09016e4fbafd0746fdb744e56ba2b12eb10083c33n,
  b: -0xd85755n,
  r: -0x8069f4a3acdc435b09016e4fbafd0746fdb744e56ba2b12eb10d06b68n
}, {
  a: -0xc9b4008ecdbed49c1cec5bef021n,
  b: -0x61b3d261cea1f5e48610c996fca9f1bn,
  r: 0x61b31bd5ce2f385a528cd57aa746f3an
}, {
  a: -0xc339b06b85en,
  b: 0xc4365dcbd51ba8a6ddfe5dcf44548a58c13054dcc39337n,
  r: -0xc4365dcbd51ba8a6ddfe5dcf44548a58c13c6747c52b6bn
}, {
  a: 0x2c6b6e9f02ee5c536b5999bd3ef897eb6n,
  b: -0x1a0a9n,
  r: -0x2c6b6e9f02ee5c536b5999bd3ef88de1fn
}, {
  a: -0x9d455108c2b2bf67ddn,
  b: -0x4e544bn,
  r: 0x9d455108c2b2f13396n
}, {
  a: 0x89980b6397e460ee80049f8ff2e2fd26bbd7d9a3e3c20c80b4dfa2a847c2f50n,
  b: 0xfa69c5017f098d41f9200c0380n,
  r: 0x89980b6397e460ee80049f8ff2e2fd26bbd7d6057f921b702c0bbd3a4702cd0n
}, {
  a: -0xe20a3f4e20fc6232919be2dfafd0c5e9a92bf84e5072c2a114d9c3ea3e69c6cn,
  b: 0x9659n,
  r: -0xe20a3f4e20fc6232919be2dfafd0c5e9a92bf84e5072c2a114d9c3ea3e60a33n
}, {
  a: -0x5ee3bfc1e637e6c0492bn,
  b: 0xf632bn,
  r: -0x5ee3bfc1e637e6cf2a02n
}, {
  a: 0x3c737e77dfa102513988aan,
  b: -0xa7418392ee7d6f9f20df126c5b11bffe307df52c4b576255bd1cef81a193e181792n,
  r: -0xa7418392ee7d6f9f20df126c5b11bffe307df52c4b5761928afb927bb1b6f219f3cn
}, {
  a: 0xfffa7fb6fa698ffbab64a09394561f706bab892cd6da22bfda453ab49n,
  b: -0x2e3d797dec2954ccbe1d9665c95c03n,
  r: -0xfffa7fb6fa698ffbab64a0939454fca7fc754bb99a11c366bc19af74cn
}, {
  a: -0x35acf35fn,
  b: 0x618f4a6afda82a16d46cb6030ffc63590f4928163f04a308n,
  r: -0x618f4a6afda82a16d46cb6030ffc63590f4928160aa85057n
}, {
  a: -0x80n,
  b: 0x701c435b1a9ec7be52acf50e358a65acdea36cb6cd79c13e0e10c3fa2b98n,
  r: -0x701c435b1a9ec7be52acf50e358a65acdea36cb6cd79c13e0e10c3fa2be8n
}, {
  a: 0x11a1d1a305b8747eb0c7ea1fee28db81817cc71add64c814b95ea6f794ccfd4cn,
  b: 0xf62cd70f51598aba91c3b382d62d2542n,
  r: 0x11a1d1a305b8747eb0c7ea1fee28db81775010158c3d42ae289d157542e1d80en
}, {
  a: -0x31efaa6fc37d1c64639aaa0c163e58a2d6fa106d2n,
  b: 0xb146b9n,
  r: -0x31efaa6fc37d1c64639aaa0c163e58a2d6f104069n
}, {
  a: 0xed0134d24058797cc40072b9262325106943647783c874e896acbc2ebb2e5n,
  b: -0xf0772beed2c44c4d0c53f5e7bn,
  r: -0xed0134d24058797cc40072b92623251069439400a826a62cdae1b07d4eca0n
}, {
  a: 0xcc2dd5743161dac60038fab285d46daec17ed93a014f7b780dn,
  b: -0xb5ef0a2ff23412a69e9e4765e625a06744733ff57edc33b88ade2edd0cn,
  r: -0xb5ef0a2f3e19c7d2afff9da3e61d5ad5c1a7525bbfa2ea828b9155a507n
}, {
  a: -0xe6fb507a741f5028665c9171db705fadb8034f1aa9e23215b6752033f2n,
  b: -0xbafec1d9916681d5ecf25d7feedfbd1bd32c78bcfb1n,
  r: 0xe6fb507a741f5023c9b08ce8cd1842f3772698e44419e3a884b2abfc41n
}, {
  a: -0x712a7ff15921ad72d06ee7ecd7ef037fb00n,
  b: 0x5d9d5d4n,
  r: -0x712a7ff15921ad72d06ee7ecd7ef5ee2f2cn
}, {
  a: -0x8a402b4aeb7e914bfd74e2631ae98cn,
  b: -0x856a925aca45ecf69675f5d0ceef0c35n,
  r: 0x85e0d27180ae9267dd888132adf5e5bfn
}, {
  a: 0x589dfn,
  b: 0x17ab8e858ca1dc2446c294541bfb1aade86e8c67a5a9cf845aff49913598ccn,
  r: 0x17ab8e858ca1dc2446c294541bfb1aade86e8c67a5a9cf845aff4991301113n
}, {
  a: 0x178761f68f117b024ac1504f74f23b1d5n,
  b: 0x369n,
  r: 0x178761f68f117b024ac1504f74f23b2bcn
}, {
  a: -0x747e0d9b4a0a7d3e20c1429d85b1bca3fa7a57cb26c51dfbdd0dd6145bb4en,
  b: 0x72a68f0816e816ae736171c522573n,
  r: -0x747e0d9b4a0a7d3e20c1429d85b1bca388dcd8c3302d0b55ae6ca7d179e3fn
}, {
  a: -0xe0c3cac6b5a7bn,
  b: -0xb56bn,
  r: 0xe0c3cac6bef10n
}, {
  a: 0x2b8a27560210a28e5139n,
  b: -0xd4c665a525aeffeb4faafff5204n,
  r: -0xd4c665a79d0c8a8b6ea0d71033bn
}, {
  a: 0xdfdc3df682a17e811f405f20bn,
  b: -0x2f09252a910a5a9n,
  r: -0xdfdc3df6828e77a435d1557a4n
}, {
  a: 0xf368d31f6dd5e0b81a79b7433e6283a7248ff7ffcba3c4n,
  b: -0xa7b5bd0c6b09cf656d6a3dn,
  r: -0xf368d31f6dd5e0b81a79b74399d73eab4f86389aa6c9f9n
}, {
  a: -0x8466e6871c3354ec432e6c8613644850n,
  b: -0x746ed6638890840c72b8bda5n,
  r: 0x8466e687685d828fcbbee88a61dcf5ebn
}, {
  a: 0x4a4265318d2e7beecd957d72081754b73044532f489a78fc44552677n,
  b: -0x770ca9cb6addf1edce9d8a3ddb7c2bc369n,
  r: -0x4a4265318d2e7beecd957d0504be9fddedb5bee1d5104527387ee520n
}, {
  a: -0x6e4b57b3n,
  b: -0x30926649e69c3405c4c5702368ed2984272ebec7n,
  r: 0x30926649e69c3405c4c5702368ed29844965e974n
}, {
  a: -0x252d91437388329abb3b063de3738b32f9255a4823334d65a0eb7c7e014003605e2b5cn,
  b: 0x3349aff5n,
  r: -0x252d91437388329abb3b063de3738b32f9255a4823334d65a0eb7c7e014003531784afn
}, {
  a: 0x9f384c85b033n,
  b: -0xb38bade06bc4b433b6687dn,
  r: -0xb38bade06b5b8c7f33d850n
}, {
  a: -0xaabeca15e0ddb1217193df772018cb3f4ee3a300c3f41d7c51c38253n,
  b: 0x97fd8df868159d0800cecc84318d7d43dcbd0b60e1e3bfa144cb1en,
  r: -0xaa29379818b5a4bc799311bba42946420d3f1e0ba315fec3f087494dn
}, {
  a: 0xbdf9c8a34fe08f4c0c35abf16ee0370c01f1ce5ed91c5n,
  b: -0x2dc0926cac8a430aa1733fa916c5a781814f47e612258010f7274ad9975d33c0158e0n,
  r: -0x2dc0926cac8a430aa1733fa9ab3c6f22ceafc8aa1e102be199c77dd596acfd9ecc91bn
}, {
  a: -0x73f767e33fe009367d5n,
  b: -0x115f33f0c5cbbc466a52fbddd43f35577343da8e38fbd64332d4ecc9e705dn,
  r: 0x115f33f0c5cbbc466a52fbddd43f35577343da8e38882124d1eb0cc0d1788n
}, {
  a: -0xe741e26747641798254cacfcn,
  b: -0xebe09354129ec62a7d35c0cc637a6b71c50a937afb70a9090n,
  r: 0xebe09354129ec62a7d35c0cc6d0e7557b17cd203792463c74n
}, {
  a: 0x257c9398be0d5d90a7738819731819f2f90ab00a5cd2b72691aa6d67n,
  b: -0x98980ac8f225fda1f7682d8d292a1a45n,
  r: -0x257c9398be0d5d90a7738819eb80133a0b2f4dababba9aabb8807724n
}, {
  a: 0x4808959e3fd01651df7cddc613cf15a6en,
  b: 0x16ad89c30006e5bben,
  r: 0x4808959e3fd01651c9d1540513c9f01d0n
}, {
  a: -0x13e6052414fc4f67n,
  b: 0x2a24d3ff8c416d56d4b2c0556b8ce8201940a1b2429d3982b605n,
  r: -0x2a24d3ff8c416d56d4b2c0556b8ce8201940b25447b92d7ef964n
}, {
  a: -0x8a14d9d47n,
  b: -0x4996fa2a89db9d2d027b7715be7fed95baa71dbbd9ff04f4a7a2a5ff5baf4e44d4n,
  r: 0x4996fa2a89db9d2d027b7715be7fed95baa71dbbd9ff04f4a7a2a5ff530e03d995n
}, {
  a: -0x9n,
  b: -0xb6e2defafcbf6f0c14bc660ea33cf161809c0e58307d788bb7dn,
  r: 0xb6e2defafcbf6f0c14bc660ea33cf161809c0e58307d788bb74n
}, {
  a: -0xcabc7c38dan,
  b: -0x84ea1e7215952030b054c1a01eae63355707127n,
  r: 0x84ea1e7215952030b054c1a01eae6f9e90c49ffn
}, {
  a: -0x5e97b6fec731db8499443290576c825dd5f2de40c3f2044e5102afb0109484d709a0n,
  b: -0x24a8e3ae67f181d90e295bdeb9621508a43ee9d22640224a9n,
  r: 0x5e97b6fec731db849946781e6d8afd45c8623cd57e19926f0188ec5e8db6e0d52d37n
}, {
  a: 0xbd23c54d0928b98a93407da5b64da475a431ff3f2b942c0bc5n,
  b: -0x7399b7fc9dec7af7be11fa99bn,
  r: -0xbd23c54d0928b98a93407da5b1743f0a6def3890507533a260n
}, {
  a: 0x9c9ba75n,
  b: 0x6d1347n,
  r: 0x9a4a932n
}, {
  a: -0x3a1a7190398e546d12a27746434c9949e4754n,
  b: 0x5f798211fb136cf0edcf64958n,
  r: -0x3a1a7190398e0b1490b38c552fbc748680e0cn
}, {
  a: 0xb5cn,
  b: 0x18cf5c06f3647c951aff052ffffa33366a694826b88244c39bben,
  r: 0x18cf5c06f3647c951aff052ffffa33366a694826b88244c390e2n
}, {
  a: -0x9252192fcfb78fc85n,
  b: 0x147f01670aa5n,
  r: -0x925218683fa1ff622n
}, {
  a: -0x16df16a4a8f3542d5a9f6e122e51n,
  b: 0x2f87728de94fdcb72729b11b77f6791b87fb691db4bda0b07f9fbefa18a9n,
  r: -0x2f87728de94fdcb72729b11b77f6791b91247fb91c4ef49d2500d0e836fan
}, {
  a: -0x7d49d44fa5bd051b405f0b1bbf54816a7n,
  b: -0xc86dd0b83448163c20ba4e3008b8ef976d50686cdc34cd44e2n,
  r: 0xc86dd0b83448163c276ed374f2e33fc6d95598dd67c1855247n
}, {
  a: -0xd48n,
  b: -0x3a55446d65e212b7dc29ca0412aen,
  r: 0x3a55446d65e212b7dc29ca041fean
}, {
  a: 0x6e3n,
  b: 0xcd2cf9244e92n,
  r: 0xcd2cf9244871n
}, {
  a: 0x18e8an,
  b: -0x6214186c34d4399b0e64c868423811f6cec3dc01f40235938n,
  r: -0x6214186c34d4399b0e64c868423811f6cec3dc01f4022d7ben
}, {
  a: 0xd0c0c2a02bffb807833983d9aa855cbd7079858957700n,
  b: -0x88n,
  r: -0xd0c0c2a02bffb807833983d9aa855cbd7079858957788n
}, {
  a: -0xe76415d26e794395932290d2e41d611cb42fb111db9908f8b6dbfb7e7879n,
  b: 0xb378420532b2dcn,
  r: -0xe76415d26e794395932290d2e41d611cb42fb111db99084bce99fe4ccaa5n
}, {
  a: -0x89eb18e9a7754e33a1n,
  b: -0xf2c410bd92f1fb6adc9541962c4ef6760c18n,
  r: 0xf2c410bd92f1fb6adc1caa8ec5e983383fb7n
}, {
  a: -0xe08dd26fdn,
  b: 0xb0b4c42ac888a47fd195dfb878543dfe9c2c7ffc301f61n,
  r: -0xb0b4c42ac888a47fd195dfb878543dfe9c2c71f4ed399en
}, {
  a: -0xc01193f3aa54f4918a13cc613d0cf63454en,
  b: 0x72738a7bc8dc11580b968f79848378698d9c149432110dn,
  r: -0x72738a7bc8d0104134ac2a36cd9bd9554b8fc45b515441n
}, {
  a: -0x32249b5991b1edn,
  b: -0x73a36b4d98n,
  r: 0x3224e8fafafc7bn
}, {
  a: -0xff52041fn,
  b: 0x744bfb376b0e8b047f7c757c7917cdba260n,
  r: -0x744bfb376b0e8b047f7c757c7918389a67fn
}, {
  a: 0xb5eab5f5096661c7e45bb2a5950b38n,
  b: 0xd87f7dbde7eb0c359cf7981den,
  r: 0xb5eab872febdbfb95498eb6aec8ae6n
}, {
  a: -0x377d5fa25df749523n,
  b: 0xcf26ed1da5d813bab7270a5918322f70a380c871a269627bdaf5df14466b27n,
  r: -0xcf26ed1da5d813bab7270a5918322f70a380c871a269610c0f0ffacb32fe06n
}, {
  a: 0x702d91c3f4319c58909828ec2fecdd3ebf1862299d0436d99705080n,
  b: -0x5ca74906351046aefae82afd6891ca4ee2383ecdb690774492a62d05afbca93173fn,
  r: -0x5ca74906351036836b2bdeccf4c95ad6cad411216baec85cf08fb00199653e347bfn
}, {
  a: -0xabc07f9dbc7d9ec4ff9n,
  b: -0x34bd59e761dbb6af198398ba2729ad7892fdcead9934bd3n,
  r: 0x34bd59e761dbb6af198398ba272906b8ed6072d007f042an
}, {
  a: -0xc8d859eea0a261ad08ab0267f166432b0e357fn,
  b: -0x292ec425d17196776a3en,
  r: 0xc8d859eea0a261ad08822ca3d4b732bd795f43n
}, {
  a: -0xc9664n,
  b: -0x5ce06c760n,
  r: 0x5ce0a513cn
}, {
  a: -0x33a6n,
  b: -0xa9dbc56c7f0e532an,
  r: 0xa9dbc56c7f0e608cn
}, {
  a: -0x275f1032e9a98e6ec2ab66aac08259375c64f6fa0dc2d5fa7ecfbe76fbaa2975111n,
  b: 0xc35dbaf428623f81476a1964cdn,
  r: -0x275f1032e9a98e6ec2ab66aac08259375c64f6fa01f70e553c499d8eefdc88e35den
}, {
  a: 0x4a64ef386034b8162n,
  b: 0x8d3354622f84eb81c91e1718b885f41f017172796cb68dc427ef11a79f84423n,
  r: 0x8d3354622f84eb81c91e1718b885f41f017172796cb68d8e430029c7ab3c541n
}, {
  a: 0xfn,
  b: -0x2c3edf7dc6c8381fcn,
  r: -0x2c3edf7dc6c8381f5n
}, {
  a: 0x29de185c7f0161c24fab77109fd99e1bb669eb67b821f5f047dn,
  b: 0xd6a26fedafdc08667136fb5042c04bcf4a4b44c57c33af7b4533n,
  r: 0xd43f8e68682c1e7a55cc4c214b3dd22ef12dda7307b1b024414en
}, {
  a: -0x3ba6e1716b5a0a36872cdac5edb32e597e4d005b244bbbff91n,
  b: -0xcd6385e3afc5f5f462edc07n,
  r: 0x3ba6e1716b5a0a36872cdac5edbff8612077fc047b0d952396n
}, {
  a: -0xa99a896795e6c5319a98d90dbb8a64c72ffd3db50617dc6a60df83ac25dbcn,
  b: -0x516dfb77a46f23a36bf0d54f78a1e13c56c17d8f53608d6d42bb9fc85638dn,
  r: 0xf8f772103189e692f1680c42c32b85fb793c403a5577510722641c6473e37n
}, {
  a: 0xbd7b9747c8ea4d2c6fb0e13a7ecdc977c0f88cn,
  b: -0x4186dc56e8690444a5dfd72f89811971bac0de991c8cf568657n,
  r: -0x4186dc56e8690f931cababa12d53df8ab4d37975c01b8967edbn
}, {
  a: 0x45642e5n,
  b: -0xdda20828cf50n,
  r: -0xdda20c7e8dabn
}, {
  a: -0x71761ee4002ee94a559b619b0f554353abb654a1b331d061f8190affe50bn,
  b: -0x5168d865a41ce2c09f39697f293880617e728df6e70459a5cb625750e53895n,
  r: 0x5119ae7b401ccc29d56cf21eb237d5222dd93ba246b76875aa9a4e5a1add9en
}, {
  a: -0xbf474f42f1c216882f4eeaf32e7044367d71000a8408en,
  b: -0x7ff7e701671adcdd761cba96cc9ffc02f6d62650f3b459e6n,
  r: 0x7ffc13759335c0fc1e9e4e7863ad1b06b5b1f140f31c1968n
}, {
  a: -0x92b11n,
  b: 0n,
  r: -0x92b11n
}, {
  a: 0xedfeb4a70e98c70b4a442ba1dd2f85n,
  b: -0x1026325e94da8841fc71893825dbdd263eba50da54816488f4684f839582n,
  r: -0x1026325e94da8841fc71893825dbddcbc00ef7d4cc466fc2b043ee5eba05n
}, {
  a: 0xe84ca8f72ad282ee14335948317a46687d104297d7539a5a9b65a898005a7131n,
  b: -0x3afdce35n,
  r: -0xe84ca8f72ad282ee14335948317a46687d104297d7539a5a9b65a8983aa7bf06n
}, {
  a: -0xac44c1d25e05c40bf2d534c1a2cb2cc8e74d139009c5cb4a85e1dff8dc1c50c0n,
  b: -0xd86d7d3b44e6a08a4ff64c2bdeb7e160e41abddad18e2497680d4d5fn,
  r: 0xac44c1d28668b930b633944bed3d60e339faf2f0eddf7690546ffb6fb4111de1n
}, {
  a: 0xbcc13875bf4f278f5fb2a50807a1n,
  b: 0xe42031an,
  r: 0xbcc13875bf4f278f5fb2ab4a04bbn
}, {
  a: 0x82a7362c2b5b1f18675209bdef8b5d166473fe89bb05en,
  b: 0x18b5913892029a82d23dbf4e7938ad404aacd954998108547fe9b39d244dcf8c1c65ban,
  r: 0x18b5913892029a82d23dbf4e7112de22881968a51ff428cfa111064c420af06487d5e4n
}, {
  a: 0x36f5an,
  b: -0xd0d7ad8bd6d72da2n,
  r: -0xd0d7ad8bd6d442fcn
}, {
  a: -0xe75e856a73ccbabf61ba3be6n,
  b: -0xfbdc52b6695c04e21726f224ace1f7a6c2dc18f93n,
  r: 0xfbdc52b6695c04e219531a720bdd3c0d34c7bb477n
}, {
  a: -0x3f6b5d2b84df55da520ab42450e17b22744e579fa507c6257927f44b19e018c321n,
  b: 0xdn,
  r: -0x3f6b5d2b84df55da520ab42450e17b22744e579fa507c6257927f44b19e018c32en
}, {
  a: 0x4b53817a238b8eaf9a262114c66n,
  b: 0x62c2a77e7107d8db6ce2f83a1eb3f9477249d63n,
  r: 0x62c2a77e71079388ed98dbb1901c6361535d105n
}, {
  a: -0x5481eb17b9a9c9b502d1bb1af5bb30d03e612473ccc5b3dn,
  b: -0x1727c211c96n,
  r: 0x5481eb17b9a9c9b502d1bb1af5bb30d03e6133540ed47a9n
}, {
  a: -0xfd0c275cd95ef72b774c460e971db8804b48fcb39af56n,
  b: 0x76250cf638fc17b31fd5d0bea23e72468n,
  r: -0xfd0c275cd95e810e7bba7ef280aea7559bf65e8de8b3en
}, {
  a: 0x859986dcbcabd804b043cb8e7016811af777f5n,
  b: 0x95bbn,
  r: 0x859986dcbcabd804b043cb8e7016811af7e24en
}, {
  a: 0xb07bbaface7ca2c1192dn,
  b: -0x18d757047d5cn,
  r: -0xb07bbafad6abf5c56477n
}, {
  a: 0xc5123b3462edadd2db567f9c5b1df4n,
  b: 0xa70a47ab2e0897509d11e87b769ca7fb75cb65fba597b05bff5e1247fe62n,
  r: 0xa70a47ab2e0897509d11e87b769ca73e67f05199483a6280a9218e1ce396n
}, {
  a: -0xbbb00ce4c10d5c61c70e25dbn,
  b: -0x6n,
  r: 0xbbb00ce4c10d5c61c70e25dfn
}, {
  a: -0xcc74ab5c2a7b56302ab4d7d2eb0bc04217fe8c5e864778e768d753a240cd4fn,
  b: -0x225bb23ef01b2db1cbd164929bcacc6a95c3891b8469295ced1b84ef3b04505d6n,
  r: 0x2257757445d98a04a8d3cfdfe6e47cd691e2f6f341814d2b636d099a01205c89bn
}, {
  a: 0xb02190f9c2053fb6f3c14n,
  b: 0xbc1a26b4eee1n,
  r: 0xb02190f9c9c49dddbd2f5n
}, {
  a: 0xdf87c5a8e2cd1e107777e693n,
  b: 0xa1af29ba7c791n,
  r: 0xdf87c5a8e2c704e2ecd02102n
}, {
  a: 0x9dc66f0a84c35a58893f7f0f1f7b7ee88bd1c726638d17fabbc62711ebb78n,
  b: -0xfb178b32d5c3983989n,
  r: -0x9dc66f0a84c35a58893f7f0f1f7b7ee88bd1c7266382a68208eb7b28682f1n
}, {
  a: 0x5231ef7e72887b7a0a2329db3fe19d5352b7f348371e5n,
  b: 0x4478bb9d953003c27n,
  r: 0x5231ef7e72887b7a0a2329db3fe1d92be92a667834dc2n
}, {
  a: 0x80f89482bf8b2057926f2f97a7edd9abea6a8n,
  b: -0x10bd9a3fc8dn,
  r: -0x80f89482bf8b2057926f2f97a7fd6431d5a25n
}, {
  a: -0x1f58e09125b875d8847c69500619a137e79fa02eba8b519137ded43946d6n,
  b: -0xf4eebf7cc664209088083188219f1cc6d4b0b1d27394324b4de1n,
  r: 0x1f58e091d156caa4421849c08e1190bfc600bce86e3be043444ae6720b35n
}, {
  a: 0x346148a7d954dfde9d60551c3b2d075cd4cd7894b4e252d4849cc6n,
  b: 0x2ad768e0960a5013eb6facc6af208233fn,
  r: 0x346148a7d954dfde9d6057b14da30e3c71cc46224e2e38268cbff9n
}, {
  a: -0xc5e83a3f92cn,
  b: -0x72ebb82b6aca056a67694n,
  r: 0x72ebb82b6a0fed5058fb8n
}, {
  a: -0x8fae440898b23afn,
  b: 0x5fac7db68f074b59ffbfe73997a2f801df27a50a656e79f1e3e12a79ff51an,
  r: -0x5fac7db68f074b59ffbfe73997a2f801df27a50a656e797e4da522e14d6b5n
}, {
  a: 0xc7ddn,
  b: 0x93f449a167bdf33335183n,
  r: 0x93f449a167bdf3333965en
}, {
  a: 0x25cn,
  b: 0x59aa16857e4n,
  r: 0x59aa16855b8n
}, {
  a: -0xf5ddn,
  b: 0x8e5cd4150741b7f694d4b90bca71a10facde967dfcdedea2b6cd70e2855c916n,
  r: -0x8e5cd4150741b7f694d4b90bca71a10facde967dfcdedea2b6cd70e28553ccbn
}, {
  a: -0x39733076bc28e03e185665fad8a6efe99c95949e02bc35eadb4f148c8dn,
  b: -0x61fbfa7ccc4d23c50c34b3ba17a0ddd322e1381eb135ce8aed26n,
  r: 0x3973301747d29cf25575a0f6ec1555fe3c4847bce3842b5bee819e61a9n
}, {
  a: -0x9d84e035975e8372b685d1413529e8370fede19781ed6f36fb401c0daef378n,
  b: 0xbf542ea25c1355d0681df69dc9bcba95823adcbc05623267162222baa9a90da7513n,
  r: -0xbf54277a12100ca5802addf594a8a9c71cb9ac42db7b4a79c0d14d0ea869d748665n
}, {
  a: 0x14d759611ae9f24752593f090b083c289b096ea61c84e11e565d9c79fff28a60ab274n,
  b: 0x68e2fbabaac83a703590b283f470589668ad5564daacdff1760bb33c53486an,
  r: 0x14d7596794c648fdfeda980a52031417dc0ce7c09651b753fc90636e9f49b9a59fa1en
}, {
  a: 0x6f8cd80d2ee7105f4675d8c6fc9c67173bfe0bdbbe0n,
  b: -0x93e5eaa0e65d6ebc0513437653363fbf6f67n,
  r: -0x6f8cd80410b9ba5123a33306ada85072089df02d487n
}, {
  a: 0x1e64478bca61d89b45823837fc173aad7adc5e5a53cba4ce7e18n,
  b: -0xbfdfd555e00ff7b2fb8fd0da89849e8cde99be6205c98fdfe8da9fc4205n,
  r: -0xbfdfd554064b8f0e5d92596ed1a71df31fea14b5a80c6a7ad460d323c1dn
}, {
  a: 0xf5f55d0c06dd1ed5e7936f1a8335a49ea1fb7cf82e09c71a4bf881029ecec5b795ce7n,
  b: 0xd063ed3f02706cc5c7a96911c5c9fdf332b77978e26bed1ccce661d909ea720cbcn,
  r: 0xf5f85b32d52d39d32bcf158c1229f8017ec8578fb987e1a49a344f64835e5b10b505bn
}, {
  a: -0xb05909c393e4cabn,
  b: 0x83d9ca116ab8bfn,
  r: -0xb8649562854f416n
}, {
  a: 0x175d94b1n,
  b: 0x61da11bae50043eefab4adf6c99a5a47c7572e281720c4fd30n,
  r: 0x61da11bae50043eefab4adf6c99a5a47c7572e281737996981n
}, {
  a: 0xb4524c85b23c8d3ce219c075a5n,
  b: -0xbf104bc3b46n,
  r: -0xb4524c85b23c8d37131d7c4ee1n
}, {
  a: 0x1n,
  b: 0xe472c569684e91673fdff78da7b5a0cd8e9305a2dn,
  r: 0xe472c569684e91673fdff78da7b5a0cd8e9305a2cn
}, {
  a: 0x949d68dc00e2bad81343b687bd869c016aeefa63718cff5ea3en,
  b: -0xa07233059fc3an,
  r: -0x949d68dc00e2bad81343b687bd869c016aeefac303bffac1608n
}, {
  a: -0xff326be873n,
  b: 0xca0ddc24b9fe9dd9989bebc8a4f3f332c8cb3b84caf34561227e044f4914d494n,
  r: -0xca0ddc24b9fe9dd9989bebc8a4f3f332c8cb3b84caf34561227e04b07b7f3ce7n
}, {
  a: 0xc44f5edce4e4e839f3ffc0b03837f48252d1dd2cc7764bb168d092n,
  b: 0x19d4a051e2be2177a761f86ff2f285fc4c05bdb0c1755d567ec3n,
  r: 0xc4568a7cb50656188458a14857c50607ae9dd89177b73eec3eae51n
}, {
  a: -0x20db8a384c831087ae9837c563291c230fn,
  b: 0xf143c863fd8cae70e877162e876a44c432f2b580a4116d33a412cdab78cbn,
  r: -0xf143c863fd8cae70e877162e874a9f4e0abe369023bff5046171e4b75bc6n
}, {
  a: 0x72476e13ae6d120b4ada9a01af70170da1d62a242282e7a3d07f9a69f9d6570f84721bn,
  b: -0x98f277b7541004c6a926eb33dacn,
  r: -0x72476e13ae6d120b4ada9a01af70170da1d62a24228b6884ab0adb69b5bcc561374fb1n
}, {
  a: 0xc57b906292486cbd120a9f4bfcaen,
  b: -0x58124c20e8281f48258bd8392a720f924e6689cc8952f40n,
  r: -0x58124c20e8281f4825878f802c5b2b1485b7a9657ded392n
}, {
  a: 0x7c90176867bc12a8ed8b76cfd0c03419e9n,
  b: -0x2fadff122d329bd7d0e749fc7bc294e608615f56ef45e82fe1b2e01c9de8e320d31b1n,
  r: -0x2fadff122d329bd7d0e749fc7bc294e60866965799c393eecb3c38abf115ef239285an
}, {
  a: 0x3556c4d3fe74d01d4ad76c36084939c8e673c36a0ed56dc9ec5n,
  b: -0x9e5b13cb1e3084d5dd7fa5bccd904af0e8b5c17366b79386583016667n,
  r: -0x9e5b13fe48f4572ba9afb8f61afc7cf8a18c09951574f9888d5ddf8a4n
}, {
  a: -0x2e3b727bb56620e6f4ccac8e8bf64bn,
  b: -0x64773f868n,
  r: 0x2e3b727bb56620e6f4ccaac9f80e2dn
}, {
  a: -0x66c08cd92fce69dde7bebf9ecd0d0f8c04c0324c8bad1576eff5d2c10f81n,
  b: 0xcd032e7aa1637d22d6299adaea1b5f9e6442e18317d379fcae66aen,
  r: -0x66c08c142ce0137c84c39d48e497d5661f9fac28c94c96613c8c2e6f692fn
}, {
  a: -0xe891162e1e49f289ac76960305d00390fd9aa876f14efcc917decc8d3fc188a0n,
  b: 0x3d214faed0048f6986c8ece268a78ddbd3730cbd9299n,
  r: -0xe891162e1e49f289ac76ab224a7ed39472f32ebe1dac946e9a051ffe337c1a07n
}, {
  a: -0xfb37e7e393d1ef1efa70a065fb6n,
  b: -0xfd4913cc46df25e8de676a3b7964a71f3023cen,
  r: 0xfd4913cc46d09696a05e5725888b0015367c78n
}, {
  a: -0x26f312a9bfb13432a7f707349363d42e015cb23061be3ac7854bbda80n,
  b: 0xcaa0712512c7d513en,
  r: -0x26f312a9bfb13432a7f707349363d42e015cb230ab1e4be2978c68b42n
}, {
  a: 0n,
  b: -0x686cf9bf6f18845c2e221bb64fad0f57d7813263fa704d339def4e15b28b0394n,
  r: -0x686cf9bf6f18845c2e221bb64fad0f57d7813263fa704d339def4e15b28b0394n
}, {
  a: -0xf4160a1dffa1769fc475b06387aec7a48n,
  b: -0xd556377ca81035969d7ac6f41451d48270cn,
  r: 0xd5a22176b5ef94e002beb34477d67a45d4cn
}, {
  a: 0x1faec632cc3d34f203bd3d834793092bf5c8e47aa1996d008f0d32662e0ea5cn,
  b: -0xed31d2800692f0602e5791b3e4a1f851af58a227dbn,
  r: -0x1faec632cc3d34f203bd33505abb0942dacee69fd882534a90882893a42cd87n
}, {
  a: 0x8n,
  b: -0x61dd2dbf6444cb85bcb1824e8aab551f11aa5e21f86cd3240be9ee0aff718e74d65a1n,
  r: -0x61dd2dbf6444cb85bcb1824e8aab551f11aa5e21f86cd3240be9ee0aff718e74d65a9n
}, {
  a: -0x32ed32d2041d1f8f8cd181fbece26f0dn,
  b: 0x515a0a4e049411b93da63506bf8efec471140ac2465f189426e8a3d7af7db346e2b537n,
  r: -0x515a0a4e049411b93da63506bf8efec471140af0ab6dca903bf72c5b7efc48aa00da3cn
}, {
  a: -0x80f3618acaeefd98c62f472c3abbb94ab6f4c0eb2bc63a333n,
  b: -0x6dca8765d3b5a337a9e8b12174c9945e54d906f4481an,
  r: 0x80f367566298a0a39c1c3db2b1a9ae062fb125a6bba97eb2bn
}, {
  a: 0xcfc0263c0b464a2920096ff99b7d36bd622834be8440b310a044258159bn,
  b: 0xff930615n,
  r: 0xcfc0263c0b464a2920096ff99b7d36bd622834be8440b310a04bdcb138en
}, {
  a: -0x2e659bfbdb8a0f2c88ecd57387d6b5de5488a1655f1f01a64ff3de6dca0n,
  b: 0xec7b0831f7b28d2b9788d76aa4an,
  r: -0x2e659bfbdb8a0f2c88ecd57387d6b5deb8f3a954a8ad8c8dd87b09076d6n
}, {
  a: 0x722eac9be22e9c25a38946n,
  b: 0xde60d3621e5c264d820cab8708eae2a330519eb1e6bbda128n,
  r: 0xde60d3621e5c264d820cab8708edc049f9efbc5824e1e286en
}, {
  a: 0x137beb3f8e54d515d5bb81f13107deb8db6873fd55b7597n,
  b: -0xbc3c7ded05a8457303d042d4c42d94dcn,
  r: -0x137beb3f8e54d51e167c5f216b838988e66c5eb1176e14dn
}, {
  a: -0x83b527f3d92c5736n,
  b: 0xfe906842229n,
  r: -0x83b5281adfa8751dn
}, {
  a: 0x4836aeben,
  b: -0x8fdefedf7n,
  r: -0x8b5d94349n
}, {
  a: 0xd940f5c7e7092e5022ce38f54953af589a2725453cb5faed854120b897e8082380n,
  b: -0x542c1a76958b6a44fn,
  r: -0xd940f5c7e7092e5022ce38f54953af589a2725453cb5faed8003e11ffeb0be87cfn
}, {
  a: -0xa396a3aaf12f1b356n,
  b: 0n,
  r: -0xa396a3aaf12f1b356n
}, {
  a: 0xb67c0b23b62c496ac4d97f80caaa7b2ce131bac8f93d7c8f43a007e0a422cca0a648n,
  b: -0xbfa21f7be7f58f18fn,
  r: -0xb67c0b23b62c496ac4d97f80caaa7b2ce131bac8f93d7c8f43abfdc1539cb3f857c7n
}, {
  a: 0xba3e9a4d845a232b8b7d7722f849c61ef8f5d060bea4cd3n,
  b: -0x95f5254587ef92310f030a91eaf45d9a7cf2232718n,
  r: -0xba3e9312d60e7b55725e67d2c8e0d8b1bd2c77af9c96bc5n
}, {
  a: -0xa3dcd1cf1dc2df88079951194ea6094f062fbe39c29bad70n,
  b: -0x6ad20231da5b6b20fcc652507244327f4n,
  r: 0xa3dcd1cf1dc2df8eaab97204eb10bb40ca4a9b3ee6d88a9cn
}, {
  a: -0xa2f1edcdec312259a534438e1a1fe3n,
  b: 0n,
  r: -0xa2f1edcdec312259a534438e1a1fe3n
}, {
  a: 0xa65a42ff42383a6dffd9cd03c6a5c855f9540a490bfcb6fb50e8d19afn,
  b: 0xf1e7dccd68e519f39fee1f91abe701dn,
  r: 0xa65a42ff42383a6dffd9cd03c6542f89343cef50f86358e4c143369b2n
}, {
  a: -0xad6ccce0b9c1c561a022n,
  b: 0xb3a37cc842b7523849d8d9723d5936158855805441fbe83ce744ac5b0n,
  r: -0xb3a37cc842b7523849d8d9723d59361588558a828d35e3a0fb12b6592n
}, {
  a: -0xe526e288d5e5a54110483b4876b1e9a8fbac16e52ad21017654bdc36e3888ba4n,
  b: 0xa8426a50cdf5n,
  r: -0xe526e288d5e5a54110483b4876b1e9a8fbac16e52ad21017654b747489d84657n
}, {
  a: -0x66024139554afaeffb7fa9c1a8cdn,
  b: -0x76b5d533ddff100ca4db75725fb35942871e832a95f1674b908b459e1982e6fn,
  r: 0x76b5d533ddff100ca4db75725fb359428718e30e866433e43e74f26485986a2n
}, {
  a: -0x9310b59804367a606aa299f205b0d63443f38c96c81da57cba8271214e0e7ed2fn,
  b: -0x1d47b9fe265305f793e862ca8cadf220c26a5d5dd7d42f89d4555d2n,
  r: 0x9310b598042b3dd99484caf7f2233e56897f2164e8dfcf21e755a50ec7da2b8ffn
}, {
  a: 0x19a01289f82a6392cc3b455ffba0144b4aa150b0d5e37f33f0d1d7b77081201cn,
  b: 0x5f3e61afd15c270e40ff1d7e5dc9b8df96ea54a2b8e87bfdecf805fb97d97n,
  r: 0x19a5e16fe2d77650bcdf4aae2c45c8d0c7583e159fc8f1b44f0f18372f385d8bn
}, {
  a: -0xb30c829cc7088fa3f8ff774681e4bf6accbb9242f562e1f6d812n,
  b: -0x691e4316ffd297c2a1d5454c5dfa4e7cd4d0e1660d623c63a841n,
  r: 0xda12c18a38da1861592a320adc1ef116186b7324f800dd957051n
}, {
  a: -0x2a7n,
  b: -0x3aced0a0d65253fdd02604db9c7223003a238440366d9e7d34ab498e7026f5dadn,
  r: 0x3aced0a0d65253fdd02604db9c7223003a238440366d9e7d34ab498e7026f5f0an
}, {
  a: 0x4ee71939302413b2ea59f55ac2b2ca8eb6c62c10c8eca510505e44b049321bace64214n,
  b: 0xd3898de0e31609793efe08d46e48fef6d229n,
  r: 0x4ee71939302413b2ea59f55ac2b2ca8eb615a59d280fb3192960bab89d5c535210903dn
}, {
  a: 0x4124b7c45da08a881e80c7556cce7437187b9e34ba62435n,
  b: -0xcb6bf74e5d61079c0d8een,
  r: -0x4124b7c45da08a881e80c7556c051fc05626ff33266fcd9n
}, {
  a: -0x2f115c7cbaad65fb5ba6c1ae5c17eb39593d08cb7bf11ac366448394n,
  b: 0xa6a561ac428b27bn,
  r: -0x2f115c7cbaad65fb5ba6c1ae5c17eb39593d08cb719b4cd9a26c31e9n
}, {
  a: 0x6cad5n,
  b: -0x558845eec43056a6744ff302200190221f779ecb52a2057799fee96c80814c0796n,
  r: -0x558845eec43056a6744ff302200190221f779ecb52a2057799fee96c80814acd41n
}, {
  a: -0xbc5676542553f6n,
  b: 0xe24317a4920d0cad34da7n,
  r: -0xe24317af576a69ef61e53n
}, {
  a: -0xcf326929501dfb738df544abc8a3c7an,
  b: 0x8e959f0d495f7e219aac6b189e7279db1335497n,
  r: -0x8e959f0d866d1708cab1906b13873d70db968efn
}, {
  a: 0x4f97ecb2a337cc094b5cdca74a7908n,
  b: -0xb29a618e391n,
  r: -0x4f97ecb2a337cc094b57f501529a99n
}, {
  a: 0x3783ffe0b006d600e732dcfaf28ac508a75f7507415dd502f30d8f2e8344dab709n,
  b: -0x893n,
  r: -0x3783ffe0b006d600e732dcfaf28ac508a75f7507415dd502f30d8f2e8344dabf9cn
}, {
  a: 0xae99cdc4331f96a51aa802422434a213c614fe8e1ab68e0e26b35a88dcn,
  b: 0x99n,
  r: 0xae99cdc4331f96a51aa802422434a213c614fe8e1ab68e0e26b35a8845n
}, {
  a: 0x6a1e4c18aaa0cddfbda7c029de24578bc31c4b1c46b09e4352dn,
  b: 0x30e9c7bdc24dd9902fb2c1b11e8c5f7641en,
  r: 0x6a1e4c18aaa0cddf8d4e07941c698e1becae8aad583cc135133n
}, {
  a: 0x7769a5f9a908fn,
  b: -0xd1280873e1ada45b221e28d1170bc5c0bb31ea29a42d724d068n,
  r: -0xd1280873e1ada45b221e28d1170bc5c0bb31ea5ecd888be40e9n
}, {
  a: -0x1e71e3621af0b268dbd676n,
  b: -0x2bf39177acb2a1d9139986c53a09ec175081ada12c9ece51732n,
  r: 0x2bf39177acb2a1d9139986c53a09edf04eb78c0e27b843ec144n
}, {
  a: 0x7n,
  b: -0xe0304da9bed07b3c74fb96bf140e9361e5aee91b5887n,
  r: -0xe0304da9bed07b3c74fb96bf140e9361e5aee91b5882n
}, {
  a: 0xe60bn,
  b: 0xb5b5bc237839b063ac8cn,
  r: 0xb5b5bc237839b0634a87n
}, {
  a: -0x6070bb92cd47279a47030d055a1a9498n,
  b: -0x65d4208b9n,
  r: 0x6070bb92cd47279a47030d0307589c2fn
}, {
  a: 0x30bef510199a1cb8d64d4b6aa11bc22995a10n,
  b: 0x3be944e51e80d4890df7de5ede78df78cceeee220a858n,
  r: 0x3be944e52e3e2199146dc2e6083594126df52c0b9f248n
}, {
  a: -0x5c93d02n,
  b: 0xade061512cc16d3076324139b86b3118ec22e85e471fb34afa2a9909a9c6cc7394eba2n,
  r: -0xade061512cc16d3076324139b86b3118ec22e85e471fb34afa2a9909a9c6cc765dd6a4n
}, {
  a: -0x50d52e5e948deacaeadb95975d36n,
  b: 0x7afcfc66d9b277b5fa7cfe74bada27f9989f01faf8f6b6ff9e76144292c55f2en,
  r: -0x7afcfc66d9b277b5fa7cfe74bada27f9989f512fd6a8227274bcfe990752021cn
}, {
  a: -0xaa1e8244689101d3dcc61fb4c4d4667b98en,
  b: -0x374dd5d84300aa70d8faf580adf64n,
  r: 0xaa1e82732544d990dc6c6f6c3e21e6d66een
}, {
  a: 0x8c18fbe43b43eb69d909b04947a706eff58b83a069b35n,
  b: 0x5ef1494df19c027888e6e87d218n,
  r: 0x8c18fbe43b43eb69d95741000a569aed8d0365481492dn
}, {
  a: -0x217686a076b4e8e9e608439527aan,
  b: 0x9aa0b7cb521c17cb83ed506n,
  r: -0x21768f0a7dc85dc82774fbabf2b0n
}, {
  a: 0x968dea2a3acaa8ea10cb6eef00fa785baf039f6530a736n,
  b: 0xbac4caeaa28c4e8268ef45dca6n,
  r: 0x968dea2a3acaa8ea10cbd42bca10dad7e181f78a757b90n
}, {
  a: 0x7eeea1abb3453730cab4c1aecd572ff2346d137d8f034573bc03238001907060497en,
  b: 0xee2b4e0aba160929fa1b8an,
  r: 0x7eeea1abb3453730cab4c1aecd572ff2346d137d8f03459d974d293a1799599a52f4n
}, {
  a: 0xb2c58ef2718bdf25cfb0842269f4884a9f6c0a7e630378cd533677760cd5eca4ce171n,
  b: 0x8fae3acn,
  r: 0xb2c58ef2718bdf25cfb0842269f4884a9f6c0a7e630378cd533677760cd5ec2b602ddn
}, {
  a: 0x2a1d8bcaeabfff7c7509973cfa5e106cede5730636d3ecn,
  b: -0xc74368097648ba456a3b6f4c07da64400d85758a22624561794dn,
  r: -0xc74368236bc370afd5c413390e4d58ba53951967c7114357aaa1n
}, {
  a: 0xdebc3b5ad4eafae50919c5cn,
  b: -0x29707e01aae5aa6d89eeda4a60c53b4ce3a1056cdac6f777e484b70cafbe61cf65d6n,
  r: -0x29707e01aae5aa6d89eeda4a60c53b4ce3a1056cdac6fa9c27311a420010315ef98an
}, {
  a: -0x63da3a5fc5bec517439n,
  b: -0x2b405e5efe9a91aacfb28961d619982f8694526947a77f0fa6661e981cn,
  r: 0x2b405e5efe9a91aacfb28961d619982f8694526f7a04daf3fd8a4fec23n
}, {
  a: -0xbb494934a2fc0af3d00a89e22031aaen,
  b: 0x44037c556089c88ec3a44aae1b080d3efa4ee0d715faaafn,
  r: -0x44037c556089c88e78ed039ab9f407cd2a44693535cb003n
}, {
  a: 0xfffb3c180027c12db1372bfc389458ebdff524c4f34c4a71d73f55f426b832e979n,
  b: -0xbc823c76a74bfaa148ba8cbc88b5dd732bcfa106a577c0a07867n,
  r: -0xfffb3c180027c191330b5d5b736ef9a36579984c4691395a189e53515178929120n
}, {
  a: 0xf72086791449ccfec1309d67d05n,
  b: 0xfa102fd13ecceddca8n,
  r: 0xf72086791be8ce03d2dc53ba1adn
}, {
  a: 0x1f2a109eeba9ab566e4a11ca33b2n,
  b: 0xb49cb985131442db33a68e414c9e24fa2777da4e4881c4f0d1504649629n,
  r: 0xb49cb985131442db33a68e414c9e24fbd5d6d3a0f21b719635f15aea59bn
}, {
  a: 0xe957f72fe806aebf0300646bc3cde3dbb9ac2c5d66c53119aba097a662af9fn,
  b: 0x6da9f78en,
  r: 0xe957f72fe806aebf0300646bc3cde3dbb9ac2c5d66c53119aba097cbcb5811n
}, {
  a: -0xe0d7cn,
  b: 0xd0201645cca1218dae6ee84592e06c73f61b7f91b9cb7n,
  r: -0xd0201645cca1218dae6ee84592e06c73f61b7f91591cdn
}, {
  a: -0xd478c1a8ab5414c37862a0e53e9d06e81c7210c36aa5867f8bd154c6e831baen,
  b: -0xe5f419a1130110dc6f1fad15a99880n,
  r: 0xd478c1a8ab5414c37862a0e53e9d06e8122d51597b9597724d20ae17b2a83d2n
}, {
  a: 0xaebb4055bb21n,
  b: -0x8aa9815072a46b221cb7c29d25ec94a88906a6ddda3144cc00b8caf10e17n,
  r: -0x8aa9815072a46b221cb7c29d25ec94a88906a6ddda3144ccae038aa4b538n
}, {
  a: 0xf07694f3e90177906f5043842b36e8bef865060f9e9ed5fdc50605da385ebd0d9n,
  b: 0x756a25a41559831a527d3cfde6ce781bn,
  r: 0xf07694f3e90177906f5043842b36e8beff33a455dfcb4dcc6021d615e6325a8c2n
}, {
  a: -0x21n,
  b: 0x9d21bc61fd8b3e9bdab77688387bda2caa82be2en,
  r: -0x9d21bc61fd8b3e9bdab77688387bda2caa82be0fn
}, {
  a: -0x394543760d45c6b0930296a80ff76ad145921c0n,
  b: -0x15906d801667168d48b3deacba5fa086d86eb45cn,
  r: 0x160439b776b34ae64183f7c63aa0d62bcc3795e4n
}, {
  a: -0x7a83a76d15957b2a12da4dbe80341cae94161732n,
  b: -0x3b5894101355c95f60b0712beb0c7c80f61e29ecc01d386b6a4af4100ecb321an,
  r: 0x3b5894101355c95f60b0712b918fdbede38b52c6d2c775d5ea7ee8be9add2528n
}, {
  a: 0x32e39bf9c92098ee723f150d36997dbb2b6800d521ad8n,
  b: -0xee636aa594639a634892c9a52681ca7bd42b8c4ffac08cab86fd43adb5c39f3n,
  r: -0xee636aa594639a6348a02a3edf48eae33a59b35af7f615d63dd62bad60e232bn
}, {
  a: -0x2874713318d14dff64d14f7b07b9060b53b6944116n,
  b: 0x66f5aa6f2f1c45aa397103639210c8de0aeb8c5178cb52n,
  r: -0x66f5821b5e2f5d7b748e67b2dd6bcf670ce0dfe7ec8a48n
}, {
  a: 0x8645d67f830f6695122cc8083n,
  b: 0x32b00ef2a8599400adea08547efd840a2c75398f9ccf1f7ac57de1f09fa3f0fff0d105n,
  r: 0x32b00ef2a8599400adea08547efd840a2c75398f9ccf171e981a19c069caa1dd3c5186n
}, {
  a: -0x965n,
  b: -0xa853753e1a988d92b2d0ceabfcd9c1243e2b4d5c850019d7188a43b0c0b1a4bee1e4a1n,
  r: 0xa853753e1a988d92b2d0ceabfcd9c1243e2b4d5c850019d7188a43b0c0b1a4bee1edc4n
}, {
  a: 0x91c6536e59325648a721f319cf42752cafn,
  b: 0xf153066dc3a2aad63beeb97233a5d86958eaf49b51a178006337n,
  r: 0xf153066dc3a2aad63b7f7f215dfcea3f104dd568486e3a754f98n
}, {
  a: -0xa10ccd88906df818afe1b8fe9561372019fb49f282cd4c3n,
  b: -0xab3481895b5772090ddc0e7b5e97f8b57988dbef38826800be8932f0311dcd541bfen,
  r: 0xab3481895b5772090ddc046b924f71b3a6095111230d8156adfb336f8582e578cf3fn
}, {
  a: -0xe125f355984afe54756b74b906a585e74934232e74n,
  b: -0x1424c43f3fa89a3d805d480de36f4c1ba9d52478816f84n,
  r: 0x1424251accfd02777e093d6697d64abe2c326d4ca241f0n
}, {
  a: -0x95236a2ac7f0dbb019c748cd61484cb5e8b15cdn,
  b: 0x163446a4f0fab83c25e7001ce1c832628984e0e2589b7cfd1ec29242n,
  r: -0x163446a4f0fab83c2cb536be4db73fd98818946e8e8ff8364049878fn
}, {
  a: 0x7676333d03e8c5n,
  b: 0xdf4fa6703a4d60800ab365886b25n,
  r: 0xdf4fa6703a4d60f67c80588b83e0n
}, {
  a: 0xe86ad309548ed9ec5f9103d3n,
  b: -0x4035e6d262e0cd63d7f362f6de29ac45c5dn,
  r: -0x4035e6d262ee4bcee7662a1b40ec5555f90n
}, {
  a: -0x777da20d2746451624f8f99a149a9963f1e98ba9cfd90e9e5db01e7557fbf9n,
  b: 0x7b7ff6b83e061e356d9067b5794c3a2e30815cc0cd2ccff5d6a07cn,
  r: -0x777da20d5c39b3ae1afee7af790afed688a5b187ff58525e909cd180815b85n
}, {
  a: -0x8c06f670b1dc789207d9edb6e7bb2n,
  b: -0xb061975144977651c5174c3665b0eb9d814c4b6261945769817ff993580df741f54f7n,
  r: 0xb061975144977651c5174c3665b0eb9d814c4b62ed92a11930a381015fd41af712f47n
}, {
  a: 0x21ee6a79344b7005e7c8ed277d70fe0dn,
  b: -0x3b215114n,
  r: -0x21ee6a79344b7005e7c8ed274651af1fn
}, {
  a: 0xc388c7ffa0f9ed1n,
  b: -0xd0bc45ae3bd64d7a24688d27df0ce283006b6496729efdn,
  r: -0xd0bc45ae3bd64d7a24688d27df0ce28f38e71b6c7d002en
}, {
  a: 0x2e3f96d401ddad2b9a094ccb8b78b3354624d35cdc5d61df9582639b196a123b6c263n,
  b: -0x6c297917226560554dc74n,
  r: -0x2e3f96d401ddad2b9a094ccb8b78b3354624d35cdc5d61dff9ab1a8c3b0f726e21e11n
}, {
  a: -0x37426a2647cdf56a382dn,
  b: -0xbbfe82f68d524f2fd5e8468eb2968cfd2c4c89518c7a05a2fe04dc004482c95n,
  r: 0xbbfe82f68d524f2fd5e8468eb2968cfd2c4c89518c7971845c60a0df12214b8n
}, {
  a: 0x56831b615a57411e6fd698a16848ec1d7ce42eef4edcc87f01an,
  b: 0x857cc40cebeb9783037bfd0n,
  r: 0x56831b615a57411e6fd698a168486961b8e8c504d95fcb04fcan
}, {
  a: 0x16d260152a312en,
  b: -0x8763052fa8d39f1e71a11d8bc08125f061156a83e87736c7b75n,
  r: -0x8763052fa8d39f1e71a11d8bc08125f061156beece766464a5bn
}, {
  a: -0x81e6n,
  b: 0x28d8bbe2en,
  r: -0x28d8b3fccn
}, {
  a: 0xb453fb397618560e19n,
  b: -0xeedfde2e580d0f259e655ce5b3aadfa86n,
  r: -0xeedfde2e580d0f2edb5aef72d22fbf49dn
}, {
  a: 0xd908bcf0be8b9bca35ab97c3b5f54d0df109cbed77a18595d27696n,
  b: 0x50c7de75412b3c54feb46ba54676f2aa9c79acd085n,
  r: 0xd908bcf0be8bcb0debded6e889a1b3b99aac8d9b850b19ec7ea613n
}, {
  a: -0xa0bf044328da9fa85b8ee280af6995acc5a5fa7771n,
  b: -0xa29332ad84280bfede093d85928e9a9934n,
  r: 0xa0bf04438a49ad05dfa6e97e7160a829572b60ee43n
}, {
  a: -0xb0af8926bda1a6f54950e85b7ceac414c9f90e916c485e0be85886ebcc8cab24bn,
  b: 0xc87dc4d34f28470acb9d006978edffa11n,
  r: -0xb0af8926bda1a6f54950e85b7ceac4140184ca422360190123c58682b4615485cn
}, {
  a: -0x311fn,
  b: 0xbb035449d7da104d039ae84a8928c1f8bca269c03d04496283e95344100n,
  r: -0xbb035449d7da104d039ae84a8928c1f8bca269c03d04496283e9534701fn
}, {
  a: -0x161aa47ed34f40fd1c935233df27030ec7b2a5969d507e55db2972b6949f42150c19n,
  b: -0x94acd3a0a31c06a393e80e1n,
  r: 0x161aa47ed34f40fd1c935233df27030ec7b2a5969d50771f1613788754f57b2b8cf8n
}, {
  a: 0x2e0ca1n,
  b: -0x4eb185d90fccfc793dad44825f1976b06927a4ae71c4510n,
  r: -0x4eb185d90fccfc793dad44825f1976b06927a4ae73249afn
}, {
  a: 0xaa365d590a406566946d32b8261fa6587194417abe68e05f4e94fa0fbbf7b1b3n,
  b: -0xe23b34n,
  r: -0xaa365d590a406566946d32b8261fa6587194417abe68e05f4e94fa0fbb158a81n
}, {
  a: -0x85f0057f377038d2512be9cd0bdca2800e893e5ea1418n,
  b: -0x3787aec8955e29dc2n,
  r: 0x85f0057f377038d2512be9cd0bdc9507a041ab00889d6n
}, {
  a: 0xa983fe48f640950a6e025f2c4120268873f23bca0f0f0c780eac382f94838b4bn,
  b: 0xb69n,
  r: 0xa983fe48f640950a6e025f2c4120268873f23bca0f0f0c780eac382f94838022n
}, {
  a: -0x285969c97fa8099c35acc7db96dan,
  b: 0xa36cff8e32dd78d6fb1dc683d4dffc00290f65d7cfa4b92a097e455b0n,
  r: -0xa36cff8e32dd78d6fb1dc683d4dffe85bf93f22d4f3d7a70c503fc36an
}, {
  a: 0x828424f487c4011685n,
  b: 0x3efaffa7ce04a55f478e33n,
  r: 0x3efa7d23eaf0229b4698b6n
}, {
  a: 0xcfb9292722d1c1e572fc87aa89ab604a9n,
  b: -0x7660b613f77328e19dd5228625b8cce98fd5091fd60edf6cd403e7654d24ae4n,
  r: -0x7660b613f77328e19dd5228625b8cc2636fc2e3d07cf3a1e28844dece644e4bn
}, {
  a: -0xc87f336d6c1n,
  b: -0x618243b4907d614dd3f3f752ede1938f526007ad4dff2een,
  r: 0x618243b4907d614dd3f3f752ede1938f5260cfd27e9242dn
}, {
  a: -0xc51b366d391cb238ebcbaa11538ff86fdccfn,
  b: -0x7f26442b07d38f6118c191167e44bf8224e3313b4b7c7a691n,
  r: 0x7f26442b07d38330aba74287b567313e9e422403b4fa87a5en
}, {
  a: 0x975367d9255cebfe0f5914b2146ac0ef2a6d02498n,
  b: 0x49ca6fb63n,
  r: 0x975367d9255cebfe0f5914b2146ac0ef63a76dffbn
}, {
  a: 0x35fde5790ebb4d7ae9e5ddfa06bf7a35a536bbfe7026bf82bdb5f8bb30e39717fn,
  b: -0x9f48e29241707fdb2b1c860580d83389eed1a4662399963n,
  r: -0x35fde5790ebb4d7ae97a951894fe0a4a7e1da77875a667b1345b291f56c00e81en
}, {
  a: 0x6db82cf2b0eccf25252948dac1058ea7dd21a80df397edfn,
  b: -0xbc0e38928fdba8aebb72d286ec97b1df3b20f4853dd9579n,
  r: -0xd1b614603f37678b9e5b9a5c2d923f78e6015c88ce4eba8n
}, {
  a: 0xded053cf42f5f7a3422c13d83ded85d8a38496c3633835a8e6e86fd3dfn,
  b: -0x61542f1n,
  r: -0xded053cf42f5f7a3422c13d83ded85d8a38496c3633835a8e6ee7a9130n
}, {
  a: -0xd857b59be877e166bb7ca127abfdc9d9a9807f2aeb718259ff5e31bcfa17576b222a85n,
  b: -0xa5f0b99ce82b4be9efcf7e864378ff652n,
  r: 0xd857b59be877e166bb7ca127abfdc9d9a9807575e0e84cdb4be0af400dff335caddcd5n
}, {
  a: 0x7964475n,
  b: -0xb6de9665f9e2f40479e932cab2da587a5n,
  r: -0xb6de9665f9e2f40479e932cab2a33c3d2n
}, {
  a: 0xc5553a92cf10f2523367979n,
  b: 0xc98f6can,
  r: 0xc5553a92cf10f252fae8fb3n
}, {
  a: 0xae8a3cdd853n,
  b: 0x45c93f2f562861n,
  r: 0x45c3d78c9bf032n
}, {
  a: 0xb75267f7c4d91db7073e7fda53dce04c8481bf2622dc7cc655be483b6n,
  b: 0xf1d9aa4d98c5db410f0ad868746a97850n,
  r: 0xb75267f7c4d91db7073e7fdaa2054a011c4464672dd6a4ae21d4dfbe6n
}, {
  a: 0xb7f5993fdef4f60d612ce9a7ff961334f830749cb7244a74bn,
  b: -0xace8cafee118fn,
  r: -0xb7f5993fdef4f60d612ce9a7ff961334f830d8747ddaab6c6n
}, {
  a: -0xc21bcc7bd6cfd8ac72d229c8af322cbfd225bc726b5bf0d333911ff862n,
  b: -0x9ca32b5eb05a099993ef6725a9ec25c92781843e964cdb93efb76e1e8n,
  r: 0xcbd1fece3dca7835ebecdfbaf5aceee3405da431823f3d6a0d6a691986n
}, {
  a: 0xd3abd84d173299ac6b85n,
  b: -0x913d5bec9e215e4df4den,
  r: -0x429683a18913c7e19f59n
}, {
  a: -0x7925d3b987837ec02n,
  b: -0x31c224a2d4e549f9fe290f94d383e081e33ec6d3e0a893n,
  r: 0x31c224a2d4e549f9fe290f94d383e713be055eabd74493n
}, {
  a: 0x712e1e78f68fd9ce15e525fd8c9758c867d899an,
  b: -0x154n,
  r: -0x712e1e78f68fd9ce15e525fd8c9758c867d88can
}, {
  a: 0x8cd0448d8f30c2ebf95b35f35fef932b52cdn,
  b: -0x502c45a1f86n,
  r: -0x8cd0448d8f30c2ebf95b35f35aed57714d49n
}, {
  a: -0x622df1c114a32c366f9acc926cd7ed27d1f7def1d4dd5b9aa7edb79eaa8en,
  b: 0xa6ad1c893d5593d0edn,
  r: -0x622df1c114a32c366f9acc926cd7ed27d1f7def1d47bf6862ed0e20d7a61n
}, {
  a: -0x4ce7d5b43c584e8n,
  b: -0x4e88386db00296e25156c51a37c8cf0e61a238d1e9aec436bf2e9e90b97c6fb9b21n,
  r: 0x4e88386db00296e25156c51a37c8cf0e61a238d1e9aec436bf2ed2776cc853e1fc7n
}, {
  a: -0x724a43f54667527d721b535e35c8ba24e6c89c7e125889587dae4bec437cc2d035ddn,
  b: 0xee39577a2ce904a17634d7fae9ac9cb4ce820c2c62b2e88dan,
  r: -0x724a43f54667527d7215b0cb426a74b4acdfff336df61391b6e2a3cc81bae9febd07n
}, {
  a: -0x6ead9932a0n,
  b: -0x6725dfee32caebd5113102895d7828f3375961c6c414d4a9289eaacef5d5d2a7n,
  r: 0x6725dfee32caebd5113102895d7828f3375961c6c414d4a9289eaaa0584ce039n
}, {
  a: -0x450475b24ac904f799731239c417461690121b823d142216ada28be04e76n,
  b: 0xf86fa201d8e1e7dca133180aebc7d1a8c60bf88f9419708d7eab19bd8n,
  r: -0x450bf3486ad48ae9e4b9010844b9fa6b8a9e7b3db5ed6381a5756151d5aen
}, {
  a: 0x89e7c397acd4dc25fd8797689b01ef88e66401cb386acc7a9a62651edb44n,
  b: 0x2292cc8151d91daee9bn,
  r: 0x89e7c397acd4dc25fd8797689b01ef88e66401cb3a43e0b28f7ff4c435dfn
}, {
  a: 0x331c6ed0cb3bb1e573n,
  b: 0x2ac1a9456b488cfbdef6646093fc633d341980de2n,
  r: 0x2ac1a9456b488cfbdef66463a23a8e3187a29e891n
}, {
  a: 0xd23b129cn,
  b: -0x97339504a01a70c3n,
  r: -0x973395047221625fn
}, {
  a: -0x403a74e6daf5386e422e472163dn,
  b: -0xb7b18bbb2c66c2af95bb6963147d9b302bdbe150e8a0c807af1f3d7n,
  r: 0xb7b18bbb2c66c2af95bb6963147ddb0a5f3d3ba5d0ce8a29e83e5ean
}, {
  a: 0x502ab9n,
  b: -0xd75ecffb74n,
  r: -0xd75e9fd1cbn
}, {
  a: 0x103a30584b876701fe8fcd6ad234a30063b754007be590e65742d4n,
  b: 0x82b9c4e270ea15d16b74c0bf6e5cbf93c17b8a66ae37c3bd086n,
  r: 0x10321bc405a069a0a3997a26d9c246cb9a8b43b8dd8f739a6c9252n
}, {
  a: -0xfe84b0a72ead720d4fc6e541d09e4n,
  b: 0x53bbc776ecb06bn,
  r: -0xfe84b0a72ead7208747a922f1b989n
}, {
  a: -0x781421db0b73bd18n,
  b: -0x6d5eabeb98815f73n,
  r: 0x154a8a3093f2e265n
}, {
  a: -0x8n,
  b: -0x6203fb17b76cd37d9354ba40494f7f5271cd72325c56661f56a5n,
  r: 0x6203fb17b76cd37d9354ba40494f7f5271cd72325c56661f56a3n
}, {
  a: -0xcc3a9c2091b6d12d66b35e727012ee55e8bc879e454eeee1n,
  b: 0xed6f78242800cn,
  r: -0xcc3a9c2091b6d12d66b35e727012ee55e8b25169c70c6eedn
}, {
  a: -0x66506bd8f7aec19e23c9f840ecfb0f1f25ad040c6211735c7ea6a5ef3befe2n,
  b: 0xbca7cbbd3870deb3cce30f1d19177168fff8116b4f810d98ae7912aec866cde656n,
  r: -0xbca7aded53a8291d0d7d2cd4e1579d93f0e734c64b8d6f89dd256c086d89f609b8n
}, {
  a: -0xca3946afd7b3b207cc5913541ca4be7f079051af8411523792bd4143b845fd1eb9e7n,
  b: -0x92f5e76a15da25871b6f41c42b93935a633e382ed786d291d3c423n,
  r: 0xca3946afd7b3b29539be7941c681396468d1958417820854ac856f943e976ccd7dc4n
}, {
  a: 0xecb62da5856d139e4156e4abd60933bd7418ba9f6882d0a3f95cbe54585cc8n,
  b: 0xf4d60147df2344226dn,
  r: 0xecb62da5856d139e4156e4abd60933bd7418ba9f68822475f81b61771c7ea5n
}, {
  a: -0x8f5551d09d805a89ea401f65c0df7fbcc6n,
  b: 0xb2c8f13012575529a692f50673ebcb601c2880cn,
  r: -0xb2c8f9c5474a5cf1a33a6ba2721d976debd34can
}, {
  a: -0xace0c3303ec7ad4caf08236f0e47c6c87badn,
  b: 0x26399f6a41385660e660e04a11c60e2b07a7e646n,
  r: -0x2639338a820868a74b2c4f4232a9006cc16f9debn
}, {
  a: 0xee3317a12n,
  b: 0x1fd73ba17108207b4bc93ef3125f84f413d1d733b411c1ban,
  r: 0x1fd73ba17108207b4bc93ef3125f84f413d1d73d5720bba8n
}, {
  a: 0x7bc15156e2bd0eb25461db5ed7ce818ae7e3d142613a8419f6ff7128f7a3n,
  b: 0x6ad943c28b9633b381n,
  r: 0x7bc15156e2bd0eb25461db5ed7ce818ae7e3d14261505d5a3474e71b4422n
}, {
  a: 0xdd3e5e1f79ef13920a7dffcaa916ce7d24698ce7b4463df40e96c6d574355cd39147den,
  b: -0x3f42a2f98606a903ddbe358834be67c5f963ec96ae46febcca93061c4979eb6dfaan,
  r: -0xdd3daa35567773f89a402429f195859b58361ad97d2cd99be55a6fe515f1cb4d279878n
}, {
  a: 0x1e977a1760c8aed0f272eb50d8n,
  b: -0xfd769bb6a8db318c0bce9db2936b73da0b6dc96340db2bden,
  r: -0xfd769bb6a8db318c0bce9dac041164bac3c3199132307b06n
}, {
  a: 0xa1a97c0fc5dn,
  b: 0x4c14fb94d91a65b6cf9b37afc2d05cdffb6d7d05118dbbf5941f5ff82f8dc78bdn,
  r: 0x4c14fb94d91a65b6cf9b37afc2d05cdffb6d7d05118dbbf5941f5f5986f1c84e0n
}, {
  a: -0xc8491d61b402d9fa748en,
  b: 0x3b77010e7e5n,
  r: -0xc8491d61b7b5a9ea9369n
}, {
  a: -0xf2bd0e0da6e5e9ce066a2171a20bfbfefc425f4fd4c9d6n,
  b: -0x710762c4b3c63a8dn,
  r: 0xf2bd0e0da6e5e9ce066a2171a20bfb8ffb209bfc12f359n
}, {
  a: 0xc884e7ee469644b65d56cn,
  b: 0x5878f49bbb95704da28668583n,
  r: 0x58783c1f5c7b36dbe630350efn
}, {
  a: -0xcaa9108f858f4beec0507fe9c31cd850dd69a9690da098fn,
  b: -0xede07b155d138168087e8d9363ab4844974972c0ec9562e054a6b98619104n,
  r: 0xede07b155d1381a2a16e0216ece0a684c7369b03f04d323d3d0fd08bb988dn
}, {
  a: -0x4544bffbb5c19a9n,
  b: 0x9becf55979f358398f1n,
  r: -0x9becb01dc608edf815an
}, {
  a: 0x2ae662c57ccb99c95db6b7cf8378a6cf9e4caa1n,
  b: -0x6401a847d7dbbddn,
  r: -0x2ae662c57ccb99c95db6b7cfe7790e88499717en
}, {
  a: 0x3b46c7n,
  b: -0x12faa57e6794ba5bdbed603af869071a57e71e62a64016643de69effc50n,
  r: -0x12faa57e6794ba5bdbed603af869071a57e71e62a64016643de69d4ba89n
}, {
  a: 0x2759b9a40c401921b86eb087375118cn,
  b: 0x7a44d3a40138671dc4ef54ac3b4a5b1189cf33af8ddae05e45fc3855832bdn,
  r: 0x7a44d3a40138671dc4ef54ac3b4a5b36d07697a3cdc3c1e62b4cbf62d2331n
}, {
  a: -0xc342a035633c53eb4a5ed92be4217c85eda1n,
  b: -0xcc3a8b88c856f5c1b4fea9d3a117ec0bb849625a47e0fa31ec960a3d22ac9cn,
  r: 0xcc3a8b88c856f5c1b4fea9d3a1d4aeab8d2a5e09acaaa4e8c7722b41a7413bn
}, {
  a: 0xf4015216fe6d0b854263cb94f56ef7en,
  b: 0xda3e3f136db756a2011c454eafea2b2a8100c662cd1d1be70704a247048b757n,
  r: 0xda3e3f136db756a2011c454eafea2b2a7501947433701062456769d3f1e5829n
}, {
  a: -0x2306n,
  b: 0n,
  r: -0x2306n
}, {
  a: -0x23an,
  b: -0xf01ef9060b0903369d2f7ab9dn,
  r: 0xf01ef9060b0903369d2f7a9a5n
}, {
  a: -0x49c48dea2486bn,
  b: 0xe8d2d4a2327d429ebed3893641e1f05d9d2bd143974bfc28bcfbd2fn,
  r: -0xe8d2d4a2327d429ebed3893641e1f05d9d2bd143970238a556df546n
}, {
  a: 0xe381f58ef65d46af869406a4133f84fa953879112ca2ca70908n,
  b: -0x2a5393cb94cc01d0db832b9b163f84d09n,
  r: -0xe381f58ef65d46af86be5537d8ab48fb45e3fa3ab7b4f5f4401n
}, {
  a: -0xd0a1e8fac69095bfbba86364be90283d85577cf245f66n,
  b: -0x69f227b26a61d5b76360ba27726443eb3c121bca3035662ea735cc718bbcn,
  r: 0x69f227b26a61d5ba697e358b1b6d181086942d81d937e5f6f2420355d4den
}, {
  a: -0xcan,
  b: -0xf9eabeccbn,
  r: 0xf9eabec03n
}, {
  a: -0xcf20cdf7dc91f1af473738cfd4d690cdc8912100n,
  b: -0x993a9en,
  r: 0xcf20cdf7dc91f1af473738cfd4d690cdc8081a62n
}, {
  a: -0xbbca406c01a3ef18849b2a8e20c8b89d9734b4299622fba0752en,
  b: -0xc333950e61fe12bf8cf3cd7eea2924ce673d318c059a1dcf688ce476b3n,
  r: 0xc33395b5abbe7ebe2f1cd5fa7103aaeeaf85ac1b312e34594a7744039fn
}, {
  a: -0x38b98860a98fe24fa8faee521f24fb7e19c2a67976e2a61c59bb1d678296ae7a382n,
  b: -0x92fdeae04dabd8n,
  r: 0x38b98860a98fe24fa8faee521f24fb7e19c2a67976e2a61c59bb14485c38aaa0856n
}, {
  a: -0x4d8be0c244a0d137ab22982c36c2dn,
  b: 0xe951eb384a347d6eb4f92c30d47d79513c07f3fb8n,
  r: -0xe951eb384a3430e5543b6890054ad273a42bc5395n
}, {
  a: -0x1707a77b442f54cd160bd0eb48b95b6b15a11567ad9c51ff2dfbdf2400a98515en,
  b: -0xc722ac048bd840a14638cb4e43790b614b1c28n,
  r: 0x1707a77b442f54cd160bd0eb48b52941d5e9a8e3a7883273991fe8b4b6bd34d7an
}, {
  a: -0xd2d336038b091ad021c6681575ffee6c2b51b7bn,
  b: 0x672a54n,
  r: -0xd2d336038b091ad021c6681575ffee6c2d2312fn
}, {
  a: 0x116560a5146399212744a8ffadfb7cn,
  b: 0x14d75d58c6cb434387f8cac3a8365cd440f6ae50ccb811ff4caf243661cn,
  r: 0x14d75d58c6cb434387f8cac3a8365dc216fcff16f52a038b0620dee9d60n
}, {
  a: 0xb60c441fe1df33d8aea47fdn,
  b: -0xb13b8fd35d451ad42eefffd6eff745117a79b12c7ef3336bcn,
  r: -0xb13b8fd35d451ad42eefffd6ef41495565986e1fa65d97147n
}, {
  a: 0xe97a1cc29fb3201be2f762a2904n,
  b: -0x605b9036a3337fbc780c44c57a9f77c08ca97312070365f9bff54ff05102671n,
  r: -0x605b9036a3337fbc780c44c57a9f77c08ca99a681bc1fa4a9feead0733a0f75n
}, {
  a: -0x76c30db93c2dd0n,
  b: 0x9294884a6de332f92a7047b5cbccd4n,
  r: -0x9294884a6de332f95cb34a0cf7e11cn
}, {
  a: -0x573a5n,
  b: 0xf7ad203350cfdc306cfe24c4b5n,
  r: -0xf7ad203350cfdc306cfe21b712n
}, {
  a: 0x1037e56d3dae7122821e61c6473f4665a3e5e560ce6e728n,
  b: 0xd221ca24a6c3ea8c4ce0646f52384e3c3255n,
  r: 0x1037e56d3da3533e20540df8effb8863e510c6e42dad57dn
}, {
  a: 0xa75118be4c45fdcc473b783c306079a6f6796c3443e44a2180c69e74b8n,
  b: 0x1a135fe0153ac2d8504fe7f322b50d79ac5954c6a5913f1c1563bn,
  r: 0xa751191f79bbfc9feb16fd38ce1f4b8da6aef6f1d6a8207893375f2283n
}, {
  a: -0x2f18fe10b92b474114bn,
  b: 0xaded14121079239fe045092n,
  r: -0xaded3b0aee699ab4a7041d9n
}, {
  a: 0xfa8f5492c2871a092f37197af43c096d949950f4en,
  b: -0xd1ab123e55983cc912923d5e2a485c0efcfn,
  r: -0xfa8f54436995245cb70bd06866015747dcc55e081n
}, {
  a: 0x94016026b78f921f5c8fb80b7d5edbb4d00a500e4d9e1cb4d16e425n,
  b: -0x5d920edd7c2ba192b03903329fc773f29dea29f8b0110b5bcead505a7a537n,
  r: -0x5d920e497d4b87253fab1c6e107f788fc3319d28ba41051650b1e48b14114n
}, {
  a: -0x2352995121c929306e4b4ce365972f4e4a72b5d6a639c5451b8e2n,
  b: 0x71169d1a33c9de5e6e90bd3c18d88bb00457f2d88371cee13a436674een,
  r: -0x71169f2f1a5ccc42fc03bbd8ac16bde976a3167fa82ca482a61737cc10n
}, {
  a: -0x2297967467d1b442b27a81b9deb6af9ee239637d398718664275b3b627ef41n,
  b: 0xddc262bc24d63528defb2e8n,
  r: -0x2297967467d1b442b27a81b9deb6af9ee2396370e5a133a40f16e13bc85da9n
}, {
  a: -0x8007ff6n,
  b: -0x7fcd6e3dn,
  r: 0x77cd11c9n
}, {
  a: -0x889fn,
  b: -0xeb0b8bbfcefcdbab9cd545beceef1cd00c065c56e89333871n,
  r: 0xeb0b8bbfcefcdbab9cd545beceef1cd00c065c56e8933b0een
}, {
  a: -0x23742cbac6d30126a3701517a330fe1071105a2435c98d6f72n,
  b: -0xeebdb0cd540074c5c8d7e58fn,
  r: 0x23742cbac6d30126a3701517a3de43a0bc445a50f0015a8affn
}, {
  a: -0x9e6f7e21d0ba1638cn,
  b: 0n,
  r: -0x9e6f7e21d0ba1638cn
}, {
  a: -0xban,
  b: -0xf00c2c1f15ef47868c14add0aaac867476319046cfc0ec87fb194a0d139513db204e4n,
  r: 0xf00c2c1f15ef47868c14add0aaac867476319046cfc0ec87fb194a0d139513db2045an
}, {
  a: 0x901c42ca92fb852b124ce5a90363dbf55ee28n,
  b: 0x5e1e4c66007dd5ce007e3c6377632206053f47a54c58c59n,
  r: 0x5e1e4c6600edc98ccaecc7e65c716ee3ac3c247eb906271n
}, {
  a: 0xe77b0907d6b81ee2c266e1c3fbf6d6916615bea4ffe48n,
  b: -0xe2a9b5b4c80b639afd1803bd231f1dcf8870efbd56e79dc9fdn,
  r: -0xe2a9bbc3789b1ef17cf62f9b4d032270e519f9dc0d0dd237b5n
}, {
  a: 0x27405fac4b957a3b49113dce30d3408n,
  b: 0xaaa0b7496c2c973d705bfb938bef0d73a01n,
  r: 0xaaa090093380dca80a60b282b6213da0e09n
}, {
  a: 0x4df828c970b4a43eb06c5eb00312001a6c596da1c0n,
  b: -0x44339cdc55269c57bb4d3f42e7deb3a6548073b71n,
  r: -0x49bb1104b5e6cdfbcbd88d442d6feb2009116a9ab1n
}, {
  a: -0x861742d85n,
  b: -0x37c54f9531d15fbc67c29aaebe716f0an,
  r: 0x37c54f9531d15fbc67c29aa6df05428dn
}, {
  a: 0x71d6d109577ffcb81ba43n,
  b: -0x36347be84986ad8b048851dd5ce30b13c97e5e94ace9e46a6e3n,
  r: -0x36347be84986ad8b048851dd5ce30b621faf57c3d3155c71ca2n
}, {
  a: -0xe741bbaaba106d633c6008a31d618ae3afn,
  b: -0x7be90ce2a7f32e66803n,
  r: 0xe741bbaaba106d6482f0c68962536c8bacn
}, {
  a: -0xd73184e7db7ab2b220ade28bc6cec50e7213c518df60834ad876cc897a2n,
  b: -0x5fde828bda76dc3e3ef20bb3441c055954b66b9b61696260f2e07d2d76a3879f7ecdn,
  r: 0x5fde828bd705c4704345a0986616db71e8da87cb86485e317f167519db24eb57e96dn
}, {
  a: -0xe43f5fca297e5bd8583939cc4ecd769834d11ecc9abd5ef6aba88n,
  b: -0x4955n,
  r: 0xe43f5fca297e5bd8583939cc4ecd769834d11ecc9abd5ef6af3d3n
}, {
  a: 0xc334cbe1ad5f8bd7405c14886f17ca3e5f845e233358b4794db2deac94a05can,
  b: 0x1c239en,
  r: 0xc334cbe1ad5f8bd7405c14886f17ca3e5f845e233358b4794db2deac9562654n
}, {
  a: 0xff181ad9fe1dcan,
  b: 0xc377985b9f6n,
  r: 0xff142da07ba43cn
}, {
  a: 0xd3875bae18294c7aaec1ee168727b06404e4n,
  b: 0x6dc65f72d5e5494656aa1896989b3682e7f192d4149e9ad42dbb5234affn,
  r: 0x6dc65f72d5e5494656aa189ba0ee8c636565557ef8807bbc5fc05474e1bn
}, {
  a: -0x24fe6ea090a593834df8c8bc50c901d9823893ee7e556da5d8674807e8486n,
  b: 0x4438d2067a2436141de6eb686e78d929f77b93aabfe93b6c6n,
  r: -0x24fe6ea090a5d7bb9ffeb29866dd1c3f6950fd96a77c9ade4bcdf7eed3244n
}, {
  a: 0xc2b07d209b280ad00e71ed3b440c6975ad815e11777c633a756n,
  b: -0x4ce83f5n,
  r: -0xc2b07d209b280ad00e71ed3b440c6975ad815e11777c2fd24a3n
}, {
  a: 0x93a03d6d64ed1fe6ba0b381af1fb13d964dn,
  b: -0xe2ee86b248a8cacebcc64n,
  r: -0x93a03d6d64ed1f04548d8a525931dd65a2fn
}, {
  a: 0x91802653666829fe3b96df396571fe609b74f568b77d66e31e2a79n,
  b: -0x16d33d071a431e26517131c8b28227e65a692e23e3880c199n,
  r: -0x9180273e55b8585a0a74ba2e766d7548b90a90ce259f58db9eebe2n
}, {
  a: -0x23387643c86df51f8894e540f063n,
  b: 0xc320a2cd0dc7a577c8aacb2687976e5ff10973b3676df74243bed8f2084c7n,
  r: -0xc320a2cd0dc7a577c8aacb2687976e5ff33af4d75beb2813bb3796a6074a6n
}, {
  a: -0x18da7a2d7n,
  b: -0x962ea08543a4a928d1abebf8f005a446e0478e62a0b2c16ab9fe4e008ee7c3b6ce7n,
  r: 0x962ea08543a4a928d1abebf8f005a446e0478e62a0b2c16ab9fe4e008eff19cce30n
}, {
  a: 0xa1570d321e7339de3f616d52a77e3bc2b43742c0a4802n,
  b: 0xe2f4576d0fac99edda78d544d235f1472e93ada538d7d50f03b858f35e8e057n,
  r: 0xe2f4576d0fac99eddad98249e02b827ef0acccc86a70ab34c10c6fb19e2a855n
}, {
  a: 0x2c3463f37e25aae1a50f5271aef6370f398bc2c153n,
  b: 0x68571d7f824249e1an,
  r: 0x2c3463f37e25aae1a50f5271a87346d8c1afe65f49n
}, {
  a: 0xc01c73973f27b00b5b7c3b76c53191fd3n,
  b: 0xafb7303e494n,
  r: 0xc01c73973f27b00b5b7c3bd97201afb47n
}, {
  a: -0x96b1367bdc1ff0a8ad9adc868aac1f1ca2178d2385ec148e19267ad6267de1d9594n,
  b: -0x5118be8ad0d64bf7a9f89873a590d36fc7f7dc5f2fb66f9bf896c20fa4cdn,
  r: 0x96b1367ecd941805a0fe63fc15259826fb1abbdffa91d17ce2408369af11c12315fn
}, {
  a: 0x87ef05552b1b81e1n,
  b: -0x5f84fe2805ec8d2694fa4ea411c2e345ae6n,
  r: -0x5f84fe2805ec8d2694f23054449052fdb05n
}, {
  a: 0xba9e9200f3c9n,
  b: 0xabn,
  r: 0xba9e9200f362n
}, {
  a: 0x2096aeb589ecc6d19de8a1c7f5c94n,
  b: -0x9f92aaa6eb39ea904614da40a1fdcdcdccbec2cc630a59bdbf9003a696abecfd0a4cn,
  r: -0x9f92aaa6eb39ea904614da40a1fdcdcdccbec2ce6a60b2e5215c6ebf4821f08256e0n
}, {
  a: 0x12552ceb2f8ec6dfeb3815d6a00c5cf4f64ff82n,
  b: 0x33d29b86d7d84c423n,
  r: 0x12552ceb2f8ec6dfeb3815e57297da232e03ba1n
}, {
  a: -0x81686e35bdc7c12097dccb44ddf29bdeaan,
  b: -0xab2d08d4a8ebf84ef5dc378e85f1670e189c1c6442261676d0b0f1c4n,
  r: 0xab2d08d4a8ebf84ef5dc370fed9f52b3df5d3cf39eed52ab222b2f6an
}, {
  a: 0x4bc83f610171509af1b4331854048e2be5f04255b8a37d9ceb1n,
  b: -0xa34129961b6f686d6ac87a628c377c9382caeb45n,
  r: -0x4bc83f61017b648868d585eed2d222ac43d88122719b51325f6n
}, {
  a: -0x3584c629e36cd42e19b1dc818325fd3ec8e14cn,
  b: -0x40bd0a3e004ea2db3054n,
  r: 0x3584c629e36cd42e19f1618bbd25b39c13d118n
}, {
  a: -0x35f2573f1f8042e0d0e8e2d342ca2bbf8n,
  b: -0xb6daac9ce354604e0280eddf7d4c25dd779ebn,
  r: 0xb6da996eb46b7fce40603d379f9f67175c21dn
}, {
  a: 0xce47c1ec28bb1f7caed0cd2c0fadebb1d592ed636ac78n,
  b: 0x1f3b6ad7da455f6b75ba1858n,
  r: 0xce47c1ec28bb1f7caed0ccdfb900961580645a38cb420n
}, {
  a: -0x94cfac92e48f5f7fdd601be4e29389a4e234c568e3b6af665b767447540bd9c500n,
  b: 0x77f12be96aff2fced04ffc40cb3679f1a52af8a7c75110n,
  r: -0x94cfac92e48f5f7fdd606c15c97ae35bcdfa15271ff664502287d16dacac1e95f0n
}, {
  a: -0xcbn,
  b: 0x23bc7b7eb3993de9f7a7faa1c023bced715adf474n,
  r: -0x23bc7b7eb3993de9f7a7faa1c023bced715adf4bfn
}, {
  a: -0xd29e04ac2314969392ab0736f022n,
  b: 0x27da753a9b9ee64331f46c99c88f25b6000baf3617a8951472n,
  r: -0x27da753a9b9ee64331f46c4b568b8995149d3ca4bcafa3e454n
}, {
  a: -0x85a27541edd01d7ac9a64d1a88n,
  b: -0xd0fa68b528fe82edad51e2fff54567500e8n,
  r: 0xd0fa68b520a4a5b9b38ce32859df0381a60n
}, {
  a: -0x5ac94e0b891062124e919eace0cdd8ed3f599bc081n,
  b: 0xc8160c21cfd52dc718b3680fa0ec16acb711996e1c379cf7349a5fe4a05n,
  r: -0xc8160c21cfd52dc71d1ffcef187d108d93f88084d23b4179e76fc658a86n
}, {
  a: -0x302ec2562a84ae0a428a0e177c2ff253b7441dd93bd988844c00e20n,
  b: -0xcae227bf42b0c2a85c3038b4d3d257f8180bd36cab67dbc25fb9b3210bcce639n,
  r: 0xcae227bf41b22e8d3e98725477faf7196fc92c4990139a1fcc042ba94f0ce827n
}, {
  a: -0xd0f0365886c912a1548bedc6e5aded34aba36ae25b44075e0eb59b3n,
  b: 0xc435f05d0d45ace7cb5fc06f0fedb9517a8dfd6015eec737966ab1db1e5n,
  r: -0xc43520ad3b1d2a2ed9fe94e4e22b5cfc97b956c37f0c9c739134bf6e858n
}, {
  a: 0xd374922fa1fc406a2e2995d8570907f3ee943ea4d574n,
  b: 0xf4f5363d680a40995724e9516c65dd9109923c86331ecd6ef2e65f16e2da5f7n,
  r: 0xf4f5363d680a40995729de184e9fc2550f30de1f6e9bbdfe8dd8b6550897083n
}, {
  a: 0x2924b0ebbb58fbbe6ae5b7361f9d2e3c26c5f7n,
  b: 0xf056n,
  r: 0x2924b0ebbb58fbbe6ae5b7361f9d2e3c2635a1n
}, {
  a: 0xd19396531n,
  b: -0x453e82603044ef4dfda103c0ccac87f7abdf159878cc25d5cd711717a9883bn,
  r: -0x453e82603044ef4dfda103c0ccac87f7abdf159878cc25d5cd711a0e90ed0cn
}, {
  a: -0x8205284315a485f4726b7eafa4745n,
  b: 0x4ac99ccf3a93248511864dc412246n,
  r: -0xc8ccb48c2f37a17163ed336bb6503n
}, {
  a: -0x3610n,
  b: 0x5e5adc8f47dd69d60n,
  r: -0x5e5adc8f47dd6ab70n
}, {
  a: 0x5a4291a8a97835e880e0df039f487d633720f9n,
  b: 0x4936a4ad22a8ea45e1a61470d7c564n,
  r: 0x5a4291a8e04e9145a24835467eee6913e0e59dn
}, {
  a: -0xc7896131e98ada80063ba9n,
  b: -0x6d2bdeb6628dfadf60e2ade85232c053f93cfe1b76d520n,
  r: 0x6d2bdeb6628dfadf60e2ade895bba16210b6249b70eeb7n
}, {
  a: -0x5e7n,
  b: -0x6db8bae0fb9dac5n,
  r: 0x6db8bae0fb9df22n
}, {
  a: 0x7f1cn,
  b: 0x3dfn,
  r: 0x7cc3n
}, {
  a: 0x1ab2525959f5d2a0080d37dedfdcad1be45e4266cb83e721dfe6c4f5e5ab1889a04an,
  b: 0xdb2eb7b4b43ea353feabb37ed5208101f357efn,
  r: 0x1ab2525959f5d2a0080d37dedfdcadc0cae9f6d2f520b4df7455ba20c52a197af7a5n
}, {
  a: 0x8n,
  b: -0x6ec76f3b65ed8443b09b9cbdf391da011d8cn,
  r: -0x6ec76f3b65ed8443b09b9cbdf391da011d84n
}, {
  a: -0x5db5529110ddc8cb272f939d881b962e7295c70667f7abfbeac2da120f55481a48bn,
  b: 0xca63582d15d6a9b13ada8f7bd4a0d7644902a184a7f9ca2dbf25ceb400en,
  r: -0x5db55291dabe90e632f93a2cb2c11955a63510622ef50a7f4d3b103fb07086ae485n
}, {
  a: 0x17n,
  b: 0xc4fffab075ae26510b3b4f5597c9e27cb459b03ab4fb2b2e2ddc07a31eb9a6n,
  r: 0xc4fffab075ae26510b3b4f5597c9e27cb459b03ab4fb2b2e2ddc07a31eb9b1n
}, {
  a: -0xabc57d034051dden,
  b: -0x328ffeabe20eb439513e97ae4eeba67216bff699d1c5131d695fb7e91fn,
  r: 0x328ffeabe20eb439513e97ae4eeba67216bff699d1cfaf4ab96bb2f4c3n
}, {
  a: -0xc73n,
  b: -0x9n,
  r: 0xc7an
}, {
  a: 0x6a7fd4faf0560c64n,
  b: -0x78a1734c4240821b0082663ec7de794ba6bf9bd37de20d873cbeeedd91483fcce864n,
  r: -0x78a1734c4240821b0082663ec7de794ba6bf9bd37de20d873cbe84a245b2cf9ae408n
}, {
  a: -0x60c1cee62b14ffe990c0dfe1da2165eb0352d91459141fff7edb439n,
  b: 0xabaad5c5b4a051a536bb54e0c170155183af598bb5df1n,
  r: -0x60c1cee62bbf553c55747fb07f17debfe393a9010897b0a6f56e9can
}, {
  a: 0x5e05569aa5533d455f73685519168b832e04b943133a38ef9n,
  b: 0x9397f306a0d9e9c538c20281ad77dfb6ab95acc5c98cn,
  r: 0x5e055fa3da635748c1ef3bd9393e915453ffd3fa49f664775n
}, {
  a: -0xd41eaac2d56a2cac0f27db2734a50fb0b1bf6d32b16392d4n,
  b: 0x4687b0e64n,
  r: -0xd41eaac2d56a2cac0f27db2734a50fb0b1bf6d36d9189cb8n
}, {
  a: 0xb44d214733ba9baabac5900454a521e26n,
  b: -0x8981068ace430n,
  r: -0xb44d214733ba9baabac51985522fefa0an
}, {
  a: 0x99bacb69ff82b76a9b699c2d4f20en,
  b: 0x2n,
  r: 0x99bacb69ff82b76a9b699c2d4f20cn
}, {
  a: 0x89d00fe32n,
  b: -0xf3eeb6f31cdbb860bafc04fbf961f38ee421n,
  r: -0xf3eeb6f31cdbb860bafc04fbf9696e8e1a13n
}, {
  a: 0x9d81319477db654764n,
  b: 0x9b9ef7157000b167ce21be1f6777cc7e22e2f1fce4b91f348en,
  r: 0x9b9ef7157000b167ce21be1f6777cc7ebf63c06893627a73ean
}, {
  a: -0x191bde751n,
  b: -0x96f45f44a8e8b67a906a564e07bc6210a2284d24445df18911809712759d49n,
  r: 0x96f45f44a8e8b67a906a564e07bc6210a2284d24445df18911809683c87a18n
}, {
  a: 0x9f9f74c734cn,
  b: -0x788f813beb5266a328a1a3130077c9fb4fc5b8c872cf7d9e0b3n,
  r: -0x788f813beb5266a328a1a3130077c9fb4fc5b8c8ed5009593ffn
}, {
  a: -0x578ca894ad22532f421838n,
  b: 0xd02ca8fc0c54dd3cddebe06f8d3ef956699e9b05e4da9f434beaa6038290n,
  r: -0xd02ca8fc0c54dd3cddebe06f8d3ef956699e9b5268720bee69b989419aa8n
}, {
  a: 0x4589n,
  b: 0x41fd4a11e4c339845cb2c27cb23d066afcc30n,
  r: 0x41fd4a11e4c339845cb2c27cb23d066af89b9n
}, {
  a: -0x2f7a36394dc97c465d8b0a3e0d05703ff333c1cc7794e82d5679c18f59c6c28cn,
  b: 0x36n,
  r: -0x2f7a36394dc97c465d8b0a3e0d05703ff333c1cc7794e82d5679c18f59c6c2ben
}, {
  a: -0xacdb802a4ad3fc61d504ffaa5b63an,
  b: 0xd1a7dff652ac37363cab673440aa85n,
  r: -0xdb6a67f4f60108f021fb28cee51cbdn
}, {
  a: -0x8990f8778f1e1b4de65fbeb6ce3de81739b0ebf0d864d717296e2421392596e3fn,
  b: -0xc5d0dc509ad077376895n,
  r: 0x8990f8778f1e1b4de65fbeb6ce3de81739b0ebf0d864db4a24ab2d8c3e56e06aan
}, {
  a: 0xae2e3ede4a932b7f286c9ea1535eeaaef1d7368fn,
  b: -0xbe8385c30ab999efc589e043fb26586n,
  r: -0xae2e3ede417b132318c7073faf0674aace65530bn
}, {
  a: -0x87204262bbe9fe6a83430f68889f01e12f93ae8n,
  b: -0xd35n,
  r: 0x87204262bbe9fe6a83430f68889f01e12f937d3n
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var r = d.a ^ d.b;
  if (d.r !== r) {
    print("Input A:  " + d.a.toString(16));
    print("Input B:  " + d.b.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    print("Op: ^");
    error_count++;
  }
}
if (error_count !== 0)
  throw new Error("Finished with " + error_count + " errors.")

