/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * arch/arm/cpu/armv8/txhd/firmware/scp_task/secure_apb.h
 *
 * Copyright (C) 2020 Amlogic, Inc. All rights reserved.
 *
 */

#ifdef REGISTER_H
#else
#define REGISTER_H


// ----------------------------------------------------------------------
// This file is automatically generated from the script:
//
// ./create_headers_from_dos_params_h.pl
//
// and was applied to the file
//
// ./dos_param.h
//
// DO NOT EDIT!!!!!
// ----------------------------------------------------------------------
//
#ifdef DOS_REGISTER_H
#else
#define DOS_REGISTER_H


//
// Reading file:  ./dos_param.h
//
//------------------------------------------------------------------------------
// Define all modules' base address under DOS
// APB allocation from 32'hd0050000
//------------------------------------------------------------------------------
// Define base address for VDEC module under DOS:
//  DOS_VDEC_ASSIST_BASE_ADDR       14'h0000
//  DOS_VDEC_MDEC_BASE_ADDR         14'h0900
//  DOS_VDEC_VLD_BASE_ADDR          14'h0c00
//  DOS_VDEC_IQIDCT_BASE_ADDR       14'h0e00
//  DOS_VDEC_VCPU_BASE_ADDR         14'h0300
//  DOS_VDEC_RESERVED_BASE_ADDR     14'h0f00 // Do not use this offset
// Define base address for DOS top-level register module:
//  DOS_TOP_BASE_ADDR               14'h3f00
//------------------------------------------------------------------------------
// VDEC_ASSIST module level register offset
//------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_ASSIST_CBUS_BASE = 0x00
// -----------------------------------------------
#define VDEC_ASSIST_MMC_CTRL0                      ((0x0001  << 2) + 0xff620000)
#define VDEC_ASSIST_MMC_CTRL1                      ((0x0002  << 2) + 0xff620000)
#define VDEC_ASSIST_MMC_CTRL2                      ((0x0003  << 2) + 0xff620000)
#define VDEC_ASSIST_MMC_CTRL3                      ((0x0004  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR1_INT0                      ((0x0025  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR1_INT1                      ((0x0026  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR1_INT2                      ((0x0027  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR1_INT3                      ((0x0028  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR1_INT4                      ((0x0029  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR1_INT5                      ((0x002a  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR1_INT6                      ((0x002b  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR1_INT7                      ((0x002c  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR1_INT8                      ((0x002d  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR1_INT9                      ((0x002e  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR1_INTA                      ((0x002f  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR1_INTB                      ((0x0030  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR1_INTC                      ((0x0031  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR1_INTD                      ((0x0032  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR1_INTE                      ((0x0033  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR1_INTF                      ((0x0034  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR2_INT0                      ((0x0035  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR2_INT1                      ((0x0036  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR2_INT2                      ((0x0037  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR2_INT3                      ((0x0038  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR2_INT4                      ((0x0039  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR2_INT5                      ((0x003a  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR2_INT6                      ((0x003b  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR2_INT7                      ((0x003c  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR2_INT8                      ((0x003d  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR2_INT9                      ((0x003e  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR2_INTA                      ((0x003f  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR2_INTB                      ((0x0040  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR2_INTC                      ((0x0041  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR2_INTD                      ((0x0042  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR2_INTE                      ((0x0043  << 2) + 0xff620000)
#define VDEC_ASSIST_AMR2_INTF                      ((0x0044  << 2) + 0xff620000)
#define VDEC_ASSIST_MBX_SSEL                       ((0x0045  << 2) + 0xff620000)
#define VDEC_ASSIST_TIMER0_LO                      ((0x0060  << 2) + 0xff620000)
#define VDEC_ASSIST_TIMER0_HI                      ((0x0061  << 2) + 0xff620000)
#define VDEC_ASSIST_TIMER1_LO                      ((0x0062  << 2) + 0xff620000)
#define VDEC_ASSIST_TIMER1_HI                      ((0x0063  << 2) + 0xff620000)
#define VDEC_ASSIST_DMA_INT                        ((0x0064  << 2) + 0xff620000)
#define VDEC_ASSIST_DMA_INT_MSK                    ((0x0065  << 2) + 0xff620000)
#define VDEC_ASSIST_DMA_INT2                       ((0x0066  << 2) + 0xff620000)
#define VDEC_ASSIST_DMA_INT_MSK2                   ((0x0067  << 2) + 0xff620000)
#define VDEC_ASSIST_MBOX0_IRQ_REG                  ((0x0070  << 2) + 0xff620000)
#define VDEC_ASSIST_MBOX0_CLR_REG                  ((0x0071  << 2) + 0xff620000)
#define VDEC_ASSIST_MBOX0_MASK                     ((0x0072  << 2) + 0xff620000)
#define VDEC_ASSIST_MBOX0_FIQ_SEL                  ((0x0073  << 2) + 0xff620000)
#define VDEC_ASSIST_MBOX1_IRQ_REG                  ((0x0074  << 2) + 0xff620000)
#define VDEC_ASSIST_MBOX1_CLR_REG                  ((0x0075  << 2) + 0xff620000)
#define VDEC_ASSIST_MBOX1_MASK                     ((0x0076  << 2) + 0xff620000)
#define VDEC_ASSIST_MBOX1_FIQ_SEL                  ((0x0077  << 2) + 0xff620000)
#define VDEC_ASSIST_MBOX2_IRQ_REG                  ((0x0078  << 2) + 0xff620000)
#define VDEC_ASSIST_MBOX2_CLR_REG                  ((0x0079  << 2) + 0xff620000)
#define VDEC_ASSIST_MBOX2_MASK                     ((0x007a  << 2) + 0xff620000)
#define VDEC_ASSIST_MBOX2_FIQ_SEL                  ((0x007b  << 2) + 0xff620000)
//------------------------------------------------------------------------------
// VDEC2_ASSIST module level register offset
//------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC2_ASSIST_CBUS_BASE = 0x00
// -----------------------------------------------
#define VDEC2_ASSIST_MMC_CTRL0                     ((0x2001  << 2) + 0xff620000)
#define VDEC2_ASSIST_MMC_CTRL1                     ((0x2002  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR1_INT0                     ((0x2025  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR1_INT1                     ((0x2026  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR1_INT2                     ((0x2027  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR1_INT3                     ((0x2028  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR1_INT4                     ((0x2029  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR1_INT5                     ((0x202a  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR1_INT6                     ((0x202b  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR1_INT7                     ((0x202c  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR1_INT8                     ((0x202d  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR1_INT9                     ((0x202e  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR1_INTA                     ((0x202f  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR1_INTB                     ((0x2030  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR1_INTC                     ((0x2031  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR1_INTD                     ((0x2032  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR1_INTE                     ((0x2033  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR1_INTF                     ((0x2034  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR2_INT0                     ((0x2035  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR2_INT1                     ((0x2036  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR2_INT2                     ((0x2037  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR2_INT3                     ((0x2038  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR2_INT4                     ((0x2039  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR2_INT5                     ((0x203a  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR2_INT6                     ((0x203b  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR2_INT7                     ((0x203c  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR2_INT8                     ((0x203d  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR2_INT9                     ((0x203e  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR2_INTA                     ((0x203f  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR2_INTB                     ((0x2040  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR2_INTC                     ((0x2041  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR2_INTD                     ((0x2042  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR2_INTE                     ((0x2043  << 2) + 0xff620000)
#define VDEC2_ASSIST_AMR2_INTF                     ((0x2044  << 2) + 0xff620000)
#define VDEC2_ASSIST_MBX_SSEL                      ((0x2045  << 2) + 0xff620000)
#define VDEC2_ASSIST_TIMER0_LO                     ((0x2060  << 2) + 0xff620000)
#define VDEC2_ASSIST_TIMER0_HI                     ((0x2061  << 2) + 0xff620000)
#define VDEC2_ASSIST_TIMER1_LO                     ((0x2062  << 2) + 0xff620000)
#define VDEC2_ASSIST_TIMER1_HI                     ((0x2063  << 2) + 0xff620000)
#define VDEC2_ASSIST_DMA_INT                       ((0x2064  << 2) + 0xff620000)
#define VDEC2_ASSIST_DMA_INT_MSK                   ((0x2065  << 2) + 0xff620000)
#define VDEC2_ASSIST_DMA_INT2                      ((0x2066  << 2) + 0xff620000)
#define VDEC2_ASSIST_DMA_INT_MSK2                  ((0x2067  << 2) + 0xff620000)
#define VDEC2_ASSIST_MBOX0_IRQ_REG                 ((0x2070  << 2) + 0xff620000)
#define VDEC2_ASSIST_MBOX0_CLR_REG                 ((0x2071  << 2) + 0xff620000)
#define VDEC2_ASSIST_MBOX0_MASK                    ((0x2072  << 2) + 0xff620000)
#define VDEC2_ASSIST_MBOX0_FIQ_SEL                 ((0x2073  << 2) + 0xff620000)
#define VDEC2_ASSIST_MBOX1_IRQ_REG                 ((0x2074  << 2) + 0xff620000)
#define VDEC2_ASSIST_MBOX1_CLR_REG                 ((0x2075  << 2) + 0xff620000)
#define VDEC2_ASSIST_MBOX1_MASK                    ((0x2076  << 2) + 0xff620000)
#define VDEC2_ASSIST_MBOX1_FIQ_SEL                 ((0x2077  << 2) + 0xff620000)
#define VDEC2_ASSIST_MBOX2_IRQ_REG                 ((0x2078  << 2) + 0xff620000)
#define VDEC2_ASSIST_MBOX2_CLR_REG                 ((0x2079  << 2) + 0xff620000)
#define VDEC2_ASSIST_MBOX2_MASK                    ((0x207a  << 2) + 0xff620000)
#define VDEC2_ASSIST_MBOX2_FIQ_SEL                 ((0x207b  << 2) + 0xff620000)
//------------------------------------------------------------------------------
// HCODEC_ASSIST module level register offset
//------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  DOS_HCODEC_ASSIST_CBUS_BASE = 0x00
// -----------------------------------------------
#define HCODEC_ASSIST_MMC_CTRL0                    ((0x1001  << 2) + 0xff620000)
#define HCODEC_ASSIST_MMC_CTRL1                    ((0x1002  << 2) + 0xff620000)
#define HCODEC_ASSIST_MMC_CTRL2                    ((0x1003  << 2) + 0xff620000)
#define HCODEC_ASSIST_MMC_CTRL3                    ((0x1004  << 2) + 0xff620000)
//cfg_soft_rst = mfdin_reg0_crst[0]; // Soft Reset
//cfg_cg_cfe   = mfdin_reg0_crst[1]; // Clock Gating Forcing Enable
//cfg_dbuf_rst = mfdin_reg0_crst[2]; // Reset DBUF information
#define HCODEC_MFDIN_REG0_CRST                     ((0x1008  << 2) + 0xff620000)
//cfg_iformat       = mfdin_reg1_ctrl[3:0]; // Data In Format: 0 :CANVAS 422 YCbCr<-one canvas,
                                                     //        1 :CANVAS 444 YCbCr(or RGB)<-one canvas,
                                                     //        2 :CANVAS 420 Y<-one CrCb<-one (NV21)
                                                     //        3 :CANVAS 420 Y<-one CbCr<-one (NV12)
                                                     //        4 :CANVAS 420 Y<-one Cb<-one Cr<-one
                                                     //        5 :CANVAS 444 Y<-one Cb<-one Cr<-one
                                                     //        6 : Reserved for other canvas mode
                                                     //        7 : should combine with cfg_ifmt_extra, for 10-12bits
                                                     //        8 :LINEAR RGB888 (24bit)
                                                     //        9 :LINEAR RGB565 (16bit)
                                                     //        10:LINEAR YUV422
                                                     //        11:LINEAR YUV420 (Note:Legacy mode not supported)
                                                     //        12~15: Reserved for other linear mode
//cfg_oformat       = mfdin_reg1_ctrl[5:4];  // Data Out Format: 0:420 1:422 2:444 3:reserved
//cfg_dsample_enable= mfdin_reg1_ctrl[6];    // Downsample Enable
//cfg_dsample_trunc = mfdin_reg1_ctrl[7];    // Downsample Addition Option: 0:Round 1:Truncated
//cfg_block_ysize   = mfdin_reg1_ctrl[8];    // 0:block-y-size=16, 1:block-y-size=8(for JPEG's efficiency)
//cfg_interp_enable = mfdin_reg1_ctrl[9];    // Chroma Interpolation Enable
//cfg_interp_mode   = mfdin_reg1_ctrl[11:10];// 0:average round 1:average truncated 2:repeat left 3:repeat right
//cfg_r2y_enable    = mfdin_reg1_ctrl[12];   // RGb->YUV Enable
//cfg_r2y_mode      = mfdin_reg1_ctrl[14:13];// RGb->YUV Mode
//cfg_rgb565_mode   = mfdin_reg1_ctrl[15];   // RGB565 mode: 0:fill zero in tail 1:fill zero in head
//cfg_ifmt_extra    = mfdin_reg1_ctrl[17:16];// when cfg_iformat==7,
                                             //        0: CANVAS 12bit 422, YCbCr<-one canvas{...Y1[11:0],C1[11:0],Y0[11:0],C0[11:0]}
                                             //        1: CANVAS 10bit 444, YCbCr<-one canvas{...2'b0,Y0[9:0],U0[9:0],V0[9:0]}
                                             //        2: CANVAS 10bit 422, YCbCr<-one canvas{...Y1[9:0],C1[9:0],Y0[9:0],C0[9:0]}
//cfg_reserved1     = mfdin_reg1_ctrl[18];   // Reserved
//cfg_nr_enable     = mfdin_reg1_ctrl[19];   // Noise Reduction Enable
//cfg_outofpic      = mfdin_reg1_ctrl[28:20];// Out Of Picture Control: [8]mode:0:extend 1:fixed, [7:0]fixed value
//cfg_rd_blktype    = mfdin_reg1_ctrl[30:29];// Block Type: 0:H264_I_PIC_ALL_4x4, 1:H264_P_PIC_Y_16x16_C_8x8, 2:JPEG_ALL_8x8, 3:Reserved
//cfg_rd_nonycintl  = mfdin_reg1_ctrl[31];   // 0:YC interleaved 1:YC non-interleaved(for JPEG)
#define HCODEC_MFDIN_REG1_CTRL                     ((0x1009  << 2) + 0xff620000)
//mfdin_reg2: DEBUG Only Status
#define HCODEC_MFDIN_REG2_STAT                     ((0x100a  << 2) + 0xff620000)
//cfg_canvas_index0  = mfdin_reg3_canv[7:0];  //canvas index 0
//cfg_canvas_index1  = mfdin_reg3_canv[15:8]; //canvas index 1
//cfg_canvas_index2  = mfdin_reg3_canv[23:16];//canvas index 2
//cfg_canv_idx0_bppx = mfdin_reg3_canv[25:24];//canvas bytes per pixel in x direction for index0, 0:half 1:1 2:2 3:3
//cfg_canv_idx1_bppx = mfdin_reg3_canv[27:26];//canvas bytes per pixel in x direction for index1, 0:half 1:1 2:2 3:3
//cfg_canv_idx0_bppy = mfdin_reg3_canv[29:28];//canvas bytes per pixel in y direction for index0, 0:half 1:1 2:2 3:3
//cfg_canv_idx1_bppy = mfdin_reg3_canv[31:30];//canvas bytes per pixel in y direction for index1, 0:half 1:1 2:2 3:3
#define HCODEC_MFDIN_REG3_CANV                     ((0x100b  << 2) + 0xff620000)
//cfg_bytes_per_line  = mfdin_reg4_lnr0[15:0];  //linear Bytes per line
//cfg_linear_bytes4p  = mfdin_reg4_lnr0[17:16]; //linear (Bytes per pixel) - 1
//cfg_linear_dbl2line = mfdin_reg4_lnr0[18];    //linear double size for odd line
#define HCODEC_MFDIN_REG4_LNR0                     ((0x100c  << 2) + 0xff620000)
//cfg_base_address    = mfdin_reg5_lnr1[31:0];  //linear base address
#define HCODEC_MFDIN_REG5_LNR1                     ((0x100d  << 2) + 0xff620000)
//assign cfg_r2y_trunc     = mfdin_reg6_dcfg[9];   //RGb->YUV Addition Option: 0:Round 1:Truncated
//assign cfg_dma_ugt       = mfdin_reg6_dcfg[8];   //DMA Urgent
//assign cfg_dma_thread_id = mfdin_reg6_dcfg[7:6]; //DMA Thread ID
//assign cfg_dma_burst_num = mfdin_reg6_dcfg[5:0]; //DMA Burst Number
#define HCODEC_MFDIN_REG6_DCFG                     ((0x100e  << 2) + 0xff620000)
//cfg_soft_cmd = mfdin_reg7_scmd; // Soft Command [28]selfcleared start,[27:14]dmb_x,[13:0]dmb_y
#define HCODEC_MFDIN_REG7_SCMD                     ((0x100f  << 2) + 0xff620000)
//cfg_pic_xsize = mfdin_reg8_dmbl[23:12]; //pixel (x,y) at the beginning of last dmb in the picture, picture x size
//cfg_pic_ysize = mfdin_reg8_dmbl[11:0];  //picture y size
#define HCODEC_MFDIN_REG8_DMBL                     ((0x1010  << 2) + 0xff620000)
//cfg_endian = mfdin_reg9_endn; //Endian Control
#define HCODEC_MFDIN_REG9_ENDN                     ((0x1011  << 2) + 0xff620000)
//cfg_canv_biasx = mfdin_rega_cav1[23:12]; //canvas bias address x
//cfg_canv_biasy = mfdin_rega_cav1[11:0];  //canvas bias address y
#define HCODEC_MFDIN_REGA_CAV1                     ((0x1012  << 2) + 0xff620000)
//cfg_amp_en = mfdin_regb_ampc[24];      //Amplitude Enable
//cfg_amp_cy = mfdin_regb_ampc[23:16];   //Amplitude Coeff Y
//cfg_amp_cu = mfdin_regb_ampc[15:8];    //Amplitude Coeff U
//cfg_amp_cv = mfdin_regb_ampc[7:0];     //Amplitude Coeff V
#define HCODEC_MFDIN_REGB_AMPC                     ((0x1013  << 2) + 0xff620000)
//cfg_mb_end = mfdin_regc_mblp; // Soft Command [28]mb end enable,[27:14]dmb_x,[13:0]dmb_y
#define HCODEC_MFDIN_REGC_MBLP                     ((0x1014  << 2) + 0xff620000)
//       cfg_y_snr_en               = mfdin_reg0d[0];
//       cfg_y_snr_err_norm         = mfdin_reg0d[1];
// [3:0] cfg_y_snr_gau_bld_core     = mfdin_reg0d[5:2];
// [7:0] cfg_y_snr_gau_bld_ofst     = mfdin_reg0d[13:6];
// [5:0] cfg_y_snr_gau_bld_rate     = mfdin_reg0d[19:14];
// [5:0] cfg_y_snr_gau_alp0_min     = mfdin_reg0d[25:20];
// [5:0] cfg_y_snr_gau_alp0_max     = mfdin_reg0d[31:26];
#define HCODEC_MFDIN_REG0D                         ((0x1015  << 2) + 0xff620000)
//       cfg_y_tnr_en               = mfdin_reg0e[0];
//       cfg_y_tnr_mc_en            = mfdin_reg0e[1];
//       cfg_y_tnr_txt_mode         = mfdin_reg0e[2];
// [3:0] cfg_y_tnr_mot_sad_margin   = mfdin_reg0e[6:3];
// [5:0] cfg_y_tnr_alpha_min        = mfdin_reg0e[12:7];
// [5:0] cfg_y_tnr_alpha_max        = mfdin_reg0e[18:13];
// [5:0] cfg_y_tnr_deghost_os       = mfdin_reg0e[24:19];
#define HCODEC_MFDIN_REG0E                         ((0x1016  << 2) + 0xff620000)
// [3:0] cfg_y_tnr_mot_cortxt_rate  = mfdin_reg0f[3:0];
// [7:0] cfg_y_tnr_mot_distxt_ofst  = mfdin_reg0f[15:8];
// [3:0] cfg_y_tnr_mot_distxt_rate  = mfdin_reg0f[7:4];
// [7:0] cfg_y_tnr_mot_dismot_ofst  = mfdin_reg0f[23:16];
// [7:0] cfg_y_tnr_mot_frcsad_lock  = mfdin_reg0f[31:24];
#define HCODEC_MFDIN_REG0F                         ((0x1017  << 2) + 0xff620000)
// [7:0] cfg_y_tnr_mot2alp_frc_gain = mfdin_reg10[7:0];
// [7:0] cfg_y_tnr_mot2alp_nrm_gain = mfdin_reg10[15:8];
// [7:0] cfg_y_tnr_mot2alp_dis_gain = mfdin_reg10[23:16];
// [5:0] cfg_y_tnr_mot2alp_dis_ofst = mfdin_reg10[29:24];
#define HCODEC_MFDIN_REG10                         ((0x1018  << 2) + 0xff620000)
// [7:0] cfg_y_bld_beta2alp_rate    = mfdin_reg11[7:0];
// [5:0] cfg_y_bld_beta_min         = mfdin_reg11[13:8];
// [5:0] cfg_y_bld_beta_max         = mfdin_reg11[19:14];
#define HCODEC_MFDIN_REG11                         ((0x1019  << 2) + 0xff620000)
// REG12~16 for Chroma, same as Luma
#define HCODEC_MFDIN_REG12                         ((0x101a  << 2) + 0xff620000)
#define HCODEC_MFDIN_REG13                         ((0x101b  << 2) + 0xff620000)
#define HCODEC_MFDIN_REG14                         ((0x101c  << 2) + 0xff620000)
#define HCODEC_MFDIN_REG15                         ((0x101d  << 2) + 0xff620000)
#define HCODEC_MFDIN_REG16                         ((0x101e  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR1_INT0                    ((0x1025  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR1_INT1                    ((0x1026  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR1_INT2                    ((0x1027  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR1_INT3                    ((0x1028  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR1_INT4                    ((0x1029  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR1_INT5                    ((0x102a  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR1_INT6                    ((0x102b  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR1_INT7                    ((0x102c  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR1_INT8                    ((0x102d  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR1_INT9                    ((0x102e  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR1_INTA                    ((0x102f  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR1_INTB                    ((0x1030  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR1_INTC                    ((0x1031  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR1_INTD                    ((0x1032  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR1_INTE                    ((0x1033  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR1_INTF                    ((0x1034  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR2_INT0                    ((0x1035  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR2_INT1                    ((0x1036  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR2_INT2                    ((0x1037  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR2_INT3                    ((0x1038  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR2_INT4                    ((0x1039  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR2_INT5                    ((0x103a  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR2_INT6                    ((0x103b  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR2_INT7                    ((0x103c  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR2_INT8                    ((0x103d  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR2_INT9                    ((0x103e  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR2_INTA                    ((0x103f  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR2_INTB                    ((0x1040  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR2_INTC                    ((0x1041  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR2_INTD                    ((0x1042  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR2_INTE                    ((0x1043  << 2) + 0xff620000)
#define HCODEC_ASSIST_AMR2_INTF                    ((0x1044  << 2) + 0xff620000)
#define HCODEC_ASSIST_MBX_SSEL                     ((0x1045  << 2) + 0xff620000)
#define HCODEC_ASSIST_TIMER0_LO                    ((0x1060  << 2) + 0xff620000)
#define HCODEC_ASSIST_TIMER0_HI                    ((0x1061  << 2) + 0xff620000)
#define HCODEC_ASSIST_TIMER1_LO                    ((0x1062  << 2) + 0xff620000)
#define HCODEC_ASSIST_TIMER1_HI                    ((0x1063  << 2) + 0xff620000)
#define HCODEC_ASSIST_DMA_INT                      ((0x1064  << 2) + 0xff620000)
#define HCODEC_ASSIST_DMA_INT_MSK                  ((0x1065  << 2) + 0xff620000)
#define HCODEC_ASSIST_DMA_INT2                     ((0x1066  << 2) + 0xff620000)
#define HCODEC_ASSIST_DMA_INT_MSK2                 ((0x1067  << 2) + 0xff620000)
#define HCODEC_ASSIST_MBOX0_IRQ_REG                ((0x1070  << 2) + 0xff620000)
#define HCODEC_ASSIST_MBOX0_CLR_REG                ((0x1071  << 2) + 0xff620000)
#define HCODEC_ASSIST_MBOX0_MASK                   ((0x1072  << 2) + 0xff620000)
#define HCODEC_ASSIST_MBOX0_FIQ_SEL                ((0x1073  << 2) + 0xff620000)
#define HCODEC_ASSIST_MBOX1_IRQ_REG                ((0x1074  << 2) + 0xff620000)
#define HCODEC_ASSIST_MBOX1_CLR_REG                ((0x1075  << 2) + 0xff620000)
#define HCODEC_ASSIST_MBOX1_MASK                   ((0x1076  << 2) + 0xff620000)
#define HCODEC_ASSIST_MBOX1_FIQ_SEL                ((0x1077  << 2) + 0xff620000)
#define HCODEC_ASSIST_MBOX2_IRQ_REG                ((0x1078  << 2) + 0xff620000)
#define HCODEC_ASSIST_MBOX2_CLR_REG                ((0x1079  << 2) + 0xff620000)
#define HCODEC_ASSIST_MBOX2_MASK                   ((0x107a  << 2) + 0xff620000)
#define HCODEC_ASSIST_MBOX2_FIQ_SEL                ((0x107b  << 2) + 0xff620000)
//------------------------------------------------------------------------------
// MDEC module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  mdec_regs.h
//
//========================================================================
//  MDEC module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_MDEC_CBUS_BASE = 0x09
// -----------------------------------------------
#define MC_CTRL_REG                                ((0x0900  << 2) + 0xff620000)
#define MC_MB_INFO                                 ((0x0901  << 2) + 0xff620000)
#define MC_PIC_INFO                                ((0x0902  << 2) + 0xff620000)
#define MC_HALF_PEL_ONE                            ((0x0903  << 2) + 0xff620000)
#define MC_HALF_PEL_TWO                            ((0x0904  << 2) + 0xff620000)
#define POWER_CTL_MC                               ((0x0905  << 2) + 0xff620000)
#define MC_CMD                                     ((0x0906  << 2) + 0xff620000)
#define MC_CTRL0                                   ((0x0907  << 2) + 0xff620000)
#define MC_PIC_W_H                                 ((0x0908  << 2) + 0xff620000)
#define MC_STATUS0                                 ((0x0909  << 2) + 0xff620000)
#define MC_STATUS1                                 ((0x090a  << 2) + 0xff620000)
#define MC_CTRL1                                   ((0x090b  << 2) + 0xff620000)
#define MC_MIX_RATIO0                              ((0x090c  << 2) + 0xff620000)
#define MC_MIX_RATIO1                              ((0x090d  << 2) + 0xff620000)
#define MC_DP_MB_XY                                ((0x090e  << 2) + 0xff620000)
#define MC_OM_MB_XY                                ((0x090f  << 2) + 0xff620000)
#define PSCALE_RST                                 ((0x0910  << 2) + 0xff620000)
#define PSCALE_CTRL                                ((0x0911  << 2) + 0xff620000)
#define PSCALE_PICI_W                              ((0x0912  << 2) + 0xff620000)
#define PSCALE_PICI_H                              ((0x0913  << 2) + 0xff620000)
#define PSCALE_PICO_W                              ((0x0914  << 2) + 0xff620000)
#define PSCALE_PICO_H                              ((0x0915  << 2) + 0xff620000)
#define PSCALE_PICO_START_X                        ((0x0916  << 2) + 0xff620000)
#define PSCALE_PICO_START_Y                        ((0x0917  << 2) + 0xff620000)
#define PSCALE_DUMMY                               ((0x0918  << 2) + 0xff620000)
#define PSCALE_FILT0_COEF0                         ((0x0919  << 2) + 0xff620000)
#define PSCALE_FILT0_COEF1                         ((0x091a  << 2) + 0xff620000)
#define PSCALE_CMD_CTRL                            ((0x091b  << 2) + 0xff620000)
#define PSCALE_CMD_BLK_X                           ((0x091c  << 2) + 0xff620000)
#define PSCALE_CMD_BLK_Y                           ((0x091d  << 2) + 0xff620000)
#define PSCALE_STATUS                              ((0x091e  << 2) + 0xff620000)
#define PSCALE_BMEM_ADDR                           ((0x091f  << 2) + 0xff620000)
#define PSCALE_BMEM_DAT                            ((0x0920  << 2) + 0xff620000)
#define PSCALE_DRAM_BUF_CTRL                       ((0x0921  << 2) + 0xff620000)
#define PSCALE_MCMD_CTRL                           ((0x0922  << 2) + 0xff620000)
#define PSCALE_MCMD_XSIZE                          ((0x0923  << 2) + 0xff620000)
#define PSCALE_MCMD_YSIZE                          ((0x0924  << 2) + 0xff620000)
#define PSCALE_RBUF_START_BLKX                     ((0x0925  << 2) + 0xff620000)
#define PSCALE_RBUF_START_BLKY                     ((0x0926  << 2) + 0xff620000)
//`define PSCALE_RBUF_MB_WIDTH   8'h27
#define PSCALE_PICO_SHIFT_XY                       ((0x0928  << 2) + 0xff620000)
#define PSCALE_CTRL1                               ((0x0929  << 2) + 0xff620000)
//Bit 15, wmask enable
//Bit 14:13, filt0 srckey_less,
//Bit 12:11, filt1 srckey_less, in the case of the interpolated data is equal distance to
//key data and normal data, 00: select normal data, 01: select right data, 10: select key data
//Bit 10:9, srckey mode, 00: equal, 01: less than or equal, 10: great than or equal
//Bit 8, src key enable
//Bit 7:0, y src key
#define PSCALE_SRCKEY_CTRL0                        ((0x092a  << 2) + 0xff620000)
//Bit 15:8, cb src key
//Bit 7:0, cr src key
#define PSCALE_SRCKEY_CTRL1                        ((0x092b  << 2) + 0xff620000)
//Bit 22:16 canvas_rd_addr2
//Bit 14:8 canvas_rd_addr1
//Bit 6:0 canvas_rd_addr1
#define PSCALE_CANVAS_RD_ADDR                      ((0x092c  << 2) + 0xff620000)
//Bit 22:16 canvas_wr_addr2
//Bit 14:8 canvas_wr_addr1
//Bit 6:0 canvas_wr_addr1
#define PSCALE_CANVAS_WR_ADDR                      ((0x092d  << 2) + 0xff620000)
//bit 13:8 pscale thread ID and token
//bit 7 disable write response count adding to busy bit
//bit 5:0  pscale pre arbiter burst num
#define PSCALE_CTRL2                               ((0x092e  << 2) + 0xff620000)
//   31 - use_omem_mb_xy_auto
//23:16 - omem_max_mb_x
//15:8  - omem_mb_y_auto
// 7:0  - omem_mb_x_auto
#define HDEC_MC_OMEM_AUTO                          ((0x0930  << 2) + 0xff620000)
#define HDEC_MC_MBRIGHT_IDX                        ((0x0931  << 2) + 0xff620000)
#define HDEC_MC_MBRIGHT_RD                         ((0x0932  << 2) + 0xff620000)
#define MC_MPORT_CTRL                              ((0x0940  << 2) + 0xff620000)
#define MC_MPORT_DAT                               ((0x0941  << 2) + 0xff620000)
#define MC_WT_PRED_CTRL                            ((0x0942  << 2) + 0xff620000)
#define MC_MBBOT_ST_EVEN_ADDR                      ((0x0944  << 2) + 0xff620000)
#define MC_MBBOT_ST_ODD_ADDR                       ((0x0945  << 2) + 0xff620000)
#define MC_DPDN_MB_XY                              ((0x0946  << 2) + 0xff620000)
#define MC_OMDN_MB_XY                              ((0x0947  << 2) + 0xff620000)
#define MC_HCMDBUF_H                               ((0x0948  << 2) + 0xff620000)
#define MC_HCMDBUF_L                               ((0x0949  << 2) + 0xff620000)
#define MC_HCMD_H                                  ((0x094a  << 2) + 0xff620000)
#define MC_HCMD_L                                  ((0x094b  << 2) + 0xff620000)
#define MC_IDCT_DAT                                ((0x094c  << 2) + 0xff620000)
#define MC_CTRL_GCLK_CTRL                          ((0x094d  << 2) + 0xff620000)
#define MC_OTHER_GCLK_CTRL                         ((0x094e  << 2) + 0xff620000)
//Bit 29:24, mbbot thread ID and token
//Bit 21:16, mc read/write thread ID and token
//Bit 13:8,  mbbot pre-arbitor burst number
//Bit 5:0,   mc pre-arbitor burst number
#define MC_CTRL2                                   ((0x094f  << 2) + 0xff620000)
// `define DBLK_QUANT            8'h76 // ONLY for $ucode/real/amrisc/rv.s, reg value from apollo
//`define ANC1_CANVAS_ADDR      8'h80
//`define ANC2_CANVAS_ADDR      8'h81
//`define REC_CANVAS_ADDR       8'h89
//`define MDEC_PIC_W          8'h8c
//`define MDEC_PIC_H          8'h8d
// mdec_pic_dc_mux_ctrl[31]  -- mcr_hevc_mode
#define MDEC_PIC_DC_MUX_CTRL                       ((0x098d  << 2) + 0xff620000)
#define MDEC_PIC_DC_CTRL                           ((0x098e  << 2) + 0xff620000)
#define MDEC_PIC_DC_STATUS                         ((0x098f  << 2) + 0xff620000)
#define ANC0_CANVAS_ADDR                           ((0x0990  << 2) + 0xff620000)
#define ANC1_CANVAS_ADDR                           ((0x0991  << 2) + 0xff620000)
#define ANC2_CANVAS_ADDR                           ((0x0992  << 2) + 0xff620000)
#define ANC3_CANVAS_ADDR                           ((0x0993  << 2) + 0xff620000)
#define ANC4_CANVAS_ADDR                           ((0x0994  << 2) + 0xff620000)
#define ANC5_CANVAS_ADDR                           ((0x0995  << 2) + 0xff620000)
#define ANC6_CANVAS_ADDR                           ((0x0996  << 2) + 0xff620000)
#define ANC7_CANVAS_ADDR                           ((0x0997  << 2) + 0xff620000)
#define ANC8_CANVAS_ADDR                           ((0x0998  << 2) + 0xff620000)
#define ANC9_CANVAS_ADDR                           ((0x0999  << 2) + 0xff620000)
#define ANC10_CANVAS_ADDR                          ((0x099a  << 2) + 0xff620000)
#define ANC11_CANVAS_ADDR                          ((0x099b  << 2) + 0xff620000)
#define ANC12_CANVAS_ADDR                          ((0x099c  << 2) + 0xff620000)
#define ANC13_CANVAS_ADDR                          ((0x099d  << 2) + 0xff620000)
#define ANC14_CANVAS_ADDR                          ((0x099e  << 2) + 0xff620000)
#define ANC15_CANVAS_ADDR                          ((0x099f  << 2) + 0xff620000)
#define ANC16_CANVAS_ADDR                          ((0x09a0  << 2) + 0xff620000)
#define ANC17_CANVAS_ADDR                          ((0x09a1  << 2) + 0xff620000)
#define ANC18_CANVAS_ADDR                          ((0x09a2  << 2) + 0xff620000)
#define ANC19_CANVAS_ADDR                          ((0x09a3  << 2) + 0xff620000)
#define ANC20_CANVAS_ADDR                          ((0x09a4  << 2) + 0xff620000)
#define ANC21_CANVAS_ADDR                          ((0x09a5  << 2) + 0xff620000)
#define ANC22_CANVAS_ADDR                          ((0x09a6  << 2) + 0xff620000)
#define ANC23_CANVAS_ADDR                          ((0x09a7  << 2) + 0xff620000)
#define ANC24_CANVAS_ADDR                          ((0x09a8  << 2) + 0xff620000)
#define ANC25_CANVAS_ADDR                          ((0x09a9  << 2) + 0xff620000)
#define ANC26_CANVAS_ADDR                          ((0x09aa  << 2) + 0xff620000)
#define ANC27_CANVAS_ADDR                          ((0x09ab  << 2) + 0xff620000)
#define ANC28_CANVAS_ADDR                          ((0x09ac  << 2) + 0xff620000)
#define ANC29_CANVAS_ADDR                          ((0x09ad  << 2) + 0xff620000)
#define ANC30_CANVAS_ADDR                          ((0x09ae  << 2) + 0xff620000)
#define ANC31_CANVAS_ADDR                          ((0x09af  << 2) + 0xff620000)
#define DBKR_CANVAS_ADDR                           ((0x09b0  << 2) + 0xff620000)
#define DBKW_CANVAS_ADDR                           ((0x09b1  << 2) + 0xff620000)
#define REC_CANVAS_ADDR                            ((0x09b2  << 2) + 0xff620000)
//28:24, read/write, current canvas idx, used in h264 only now
//23:0, read only, current canvas address, 23:16, Cr canvas addr, 15:8, Cb canvas addr, 7:0, Y  canvas addr
#define CURR_CANVAS_CTRL                           ((0x09b3  << 2) + 0xff620000)
#define MDEC_PIC_DC_THRESH                         ((0x09b8  << 2) + 0xff620000)
#define MDEC_PICR_BUF_STATUS                       ((0x09b9  << 2) + 0xff620000)
#define MDEC_PICW_BUF_STATUS                       ((0x09ba  << 2) + 0xff620000)
#define MCW_DBLK_WRRSP_CNT                         ((0x09bb  << 2) + 0xff620000)
#define MC_MBBOT_WRRSP_CNT                         ((0x09bc  << 2) + 0xff620000)
#define MDEC_PICW_BUF2_STATUS                      ((0x09bd  << 2) + 0xff620000)
#define WRRSP_FIFO_PICW_DBK                        ((0x09be  << 2) + 0xff620000)
#define WRRSP_FIFO_PICW_MC                         ((0x09bf  << 2) + 0xff620000)
#define AV_SCRATCH_0                               ((0x09c0  << 2) + 0xff620000)
#define AV_SCRATCH_1                               ((0x09c1  << 2) + 0xff620000)
#define AV_SCRATCH_2                               ((0x09c2  << 2) + 0xff620000)
#define AV_SCRATCH_3                               ((0x09c3  << 2) + 0xff620000)
#define AV_SCRATCH_4                               ((0x09c4  << 2) + 0xff620000)
#define AV_SCRATCH_5                               ((0x09c5  << 2) + 0xff620000)
#define AV_SCRATCH_6                               ((0x09c6  << 2) + 0xff620000)
#define AV_SCRATCH_7                               ((0x09c7  << 2) + 0xff620000)
#define AV_SCRATCH_8                               ((0x09c8  << 2) + 0xff620000)
#define AV_SCRATCH_9                               ((0x09c9  << 2) + 0xff620000)
#define AV_SCRATCH_A                               ((0x09ca  << 2) + 0xff620000)
#define AV_SCRATCH_B                               ((0x09cb  << 2) + 0xff620000)
#define AV_SCRATCH_C                               ((0x09cc  << 2) + 0xff620000)
#define AV_SCRATCH_D                               ((0x09cd  << 2) + 0xff620000)
#define AV_SCRATCH_E                               ((0x09ce  << 2) + 0xff620000)
#define AV_SCRATCH_F                               ((0x09cf  << 2) + 0xff620000)
#define AV_SCRATCH_G                               ((0x09d0  << 2) + 0xff620000)
#define AV_SCRATCH_H                               ((0x09d1  << 2) + 0xff620000)
#define AV_SCRATCH_I                               ((0x09d2  << 2) + 0xff620000)
#define AV_SCRATCH_J                               ((0x09d3  << 2) + 0xff620000)
#define AV_SCRATCH_K                               ((0x09d4  << 2) + 0xff620000)
#define AV_SCRATCH_L                               ((0x09d5  << 2) + 0xff620000)
#define AV_SCRATCH_M                               ((0x09d6  << 2) + 0xff620000)
#define AV_SCRATCH_N                               ((0x09d7  << 2) + 0xff620000)
// bit[29:24] A_brst_num_co_mb
// bit[21:16] A_id_co_mb
// bit[11:0] wrrsp_count_co_mb
#define WRRSP_CO_MB                                ((0x09d8  << 2) + 0xff620000)
// bit[29:24] A_brst_num_dcac
// bit[21:16] A_id_dcac
// bit[11:0] wrrsp_count_dcac
#define WRRSP_DCAC                                 ((0x09d9  << 2) + 0xff620000)
// bit[11:0] wrrsp_count_vld
#define WRRSP_VLD                                  ((0x09da  << 2) + 0xff620000)
// doublew_cfg0[0];     //       Second Channel Enable, 1:Enable 0:Disable
// doublew_cfg0[3:1];   // [2:0] Endian Control for Luma
// doublew_cfg0[5:4];   // [1:0] Pixel sel by horizontal, 0x:1/2 10:left 11:right
// doublew_cfg0[7:6];   // [1:0] Pixel sel by vertical,   0x:1/2 10:up 11:down
// doublew_cfg0[8];     //       Size by horizontal, 0:original size 1: 1/2 shrunken size
// doublew_cfg0[9];     //       Size by vertical,   0:original size 1: 1/2 shrunken size
// doublew_cfg0[10];    //       1:Round 0:Truncation
// doublew_cfg0[11];    //       DMA Urgent
// doublew_cfg0[17:12]; // [5:0] DMA Burst Number
// doublew_cfg0[23:18]; // [5:0] DMA ID
// doublew_cfg0[26:24]; // [2:0] Endian Control for Chroma
// doublew_cfg0[27];    //       Source from, 1:MCW 0:DBLK
// doublew_cfg0[29:28]; // [1:0] 0x:select both top and bottom 10:select top 11:select bottom
// doublew_cfg0[30];    //       0:no merge 1:automatic merge
// doublew_cfg0[31];    //       0:Y addr no change 1:Y addr divided to half
#define MDEC_DOUBLEW_CFG0                          ((0x09db  << 2) + 0xff620000)
// doublew_cfg1[7:0];   // [7:0] DMA Canvas Address for Luma
// doublew_cfg1[15:8];  // [7:0] DMA Canvas Address for Chroma
// doublew_cfg1[16];    //       Disable 1st Write -
// doublew_cfg1[17];    //       Reverse to original version -
// doublew_cfg1[18];    //       DMA Address Mode - 0:Canvas Mode 1:Non-Canvas Mode
#define MDEC_DOUBLEW_CFG1                          ((0x09dc  << 2) + 0xff620000)
// doublew_cfg2[11:0];  //[11:0] vertical flip initial value
// doublew_cfg2[15];    //       vertical flip enable
// doublew_cfg2[24:16]; // [8:0] horizontal flip initial value
// doublew_cfg2[31];    //       horizontal flip enable
#define MDEC_DOUBLEW_CFG2                          ((0x09dd  << 2) + 0xff620000)
// doublew_cfg3[31:0];  //[31:0] non-canvas start address for Luma -
#define MDEC_DOUBLEW_CFG3                          ((0x09de  << 2) + 0xff620000)
// doublew_cfg4[31:0];  //[31:0] non-canvas start address for Chroma -
#define MDEC_DOUBLEW_CFG4                          ((0x09df  << 2) + 0xff620000)
// doublew_cfg5[12:0];  //[12:0] non-canvas picture width for Luma -
// doublew_cfg5[28:16]; //[12:0] non-canvas picture width for Chroma -
#define MDEC_DOUBLEW_CFG5                          ((0x09e0  << 2) + 0xff620000)
// doublew_cfg6: reserved
#define MDEC_DOUBLEW_CFG6                          ((0x09e1  << 2) + 0xff620000)
// doublew_cfg7: reserved
#define MDEC_DOUBLEW_CFG7                          ((0x09e2  << 2) + 0xff620000)
// doublew_status[11:0];//[11:0] wrrsp_count_doublew
// doublew_status[12];  //       doublew_status_busy
// doublew_status[13];  //       doublew_status_error
#define MDEC_DOUBLEW_STATUS                        ((0x09e3  << 2) + 0xff620000)
#define MDEC_EXTIF_CFG0                            ((0x09e4  << 2) + 0xff620000)
#define MDEC_EXTIF_CFG1                            ((0x09e5  << 2) + 0xff620000)
#define MDEC_EXTIF_STS0                            ((0x09e6  << 2) + 0xff620000)
//======================================
//  MC Control Register Bits
//
//======================================
// For bits, just copy the defines...don't translate to addresses
    #define MC_ENABLE	    0x0001
    //`define MC_RESET	    16'h0002
    #define SKIP_MB		    0x0004

//======================================
//  MB Info Register Bits
//
//======================================
    #define INTRA_MB	    0x0001

    #define BWD_PRED	    0x0004
    #define FWD_PRED	    0x0008

    #define FLD_MOT		    0x0100
    #define FRM_16x8_MOT	0x0200
    #define DUAL_PRM_MOT	0x0300

    #define FRM_DCT		    0x0000	    // Bit 10
    #define FLD_DCT		    0x0400

//======================================
//  MB Info Register Bits
//
//======================================
    #define I_PIC		    0x0001
    #define P_PIC		    0x0002
    #define B_PIC		    0x0003

    #define FLD_PIC		    0x0000	    // Bit 8
    #define FRM_PIC		    0x0100
//========================================================================
// DBLK Register:  12'h950 - 12'h97f
//========================================================================
#define DBLK_RST                                   ((0x0950  << 2) + 0xff620000)
#define DBLK_CTRL                                  ((0x0951  << 2) + 0xff620000)
#define DBLK_MB_WID_HEIGHT                         ((0x0952  << 2) + 0xff620000)
#define DBLK_STATUS                                ((0x0953  << 2) + 0xff620000)
#define DBLK_CMD_CTRL                              ((0x0954  << 2) + 0xff620000)
#define DBLK_MB_XY                                 ((0x0955  << 2) + 0xff620000)
#define DBLK_QP                                    ((0x0956  << 2) + 0xff620000)
#define DBLK_Y_BHFILT                              ((0x0957  << 2) + 0xff620000)
#define DBLK_Y_BHFILT_HIGH                         ((0x0958  << 2) + 0xff620000)
#define DBLK_Y_BVFILT                              ((0x0959  << 2) + 0xff620000)
#define DBLK_CB_BFILT                              ((0x095a  << 2) + 0xff620000)
#define DBLK_CR_BFILT                              ((0x095b  << 2) + 0xff620000)
#define DBLK_Y_HFILT                               ((0x095c  << 2) + 0xff620000)
#define DBLK_Y_HFILT_HIGH                          ((0x095d  << 2) + 0xff620000)
#define DBLK_Y_VFILT                               ((0x095e  << 2) + 0xff620000)
#define DBLK_CB_FILT                               ((0x095f  << 2) + 0xff620000)
#define DBLK_CR_FILT                               ((0x0960  << 2) + 0xff620000)
#define DBLK_BETAX_QP_SEL                          ((0x0961  << 2) + 0xff620000)
#define DBLK_CLIP_CTRL0                            ((0x0962  << 2) + 0xff620000)
#define DBLK_CLIP_CTRL1                            ((0x0963  << 2) + 0xff620000)
#define DBLK_CLIP_CTRL2                            ((0x0964  << 2) + 0xff620000)
#define DBLK_CLIP_CTRL3                            ((0x0965  << 2) + 0xff620000)
#define DBLK_CLIP_CTRL4                            ((0x0966  << 2) + 0xff620000)
#define DBLK_CLIP_CTRL5                            ((0x0967  << 2) + 0xff620000)
#define DBLK_CLIP_CTRL6                            ((0x0968  << 2) + 0xff620000)
#define DBLK_CLIP_CTRL7                            ((0x0969  << 2) + 0xff620000)
#define DBLK_CLIP_CTRL8                            ((0x096a  << 2) + 0xff620000)
#define DBLK_STATUS1                               ((0x096b  << 2) + 0xff620000)
#define DBLK_GCLK_FREE                             ((0x096c  << 2) + 0xff620000)
#define DBLK_GCLK_OFF                              ((0x096d  << 2) + 0xff620000)
#define DBLK_AVSFLAGS                              ((0x096e  << 2) + 0xff620000)
// bit 15:0
#define DBLK_CBPY                                  ((0x0970  << 2) + 0xff620000)
// bit 11:8 -- deblk_cbpy_bottom
// bit 7:4 -- deblk_cbpy_left
// bit 3:0 -- deblk_cbpy_top
#define DBLK_CBPY_ADJ                              ((0x0971  << 2) + 0xff620000)
// bit 7:0 -- deblk_cbpc
#define DBLK_CBPC                                  ((0x0972  << 2) + 0xff620000)
// bit 15 -- bottom_mb
// bit 14 -- left_mb
// bit 13 -- top_mb
// bit 12 -- reserved
// bit 11:8 -- deblk_cbpc_bottom
// bit 7:4 -- deblk_cbpc_left
// bit 3:0 -- deblk_cbpc_top
#define DBLK_CBPC_ADJ                              ((0x0973  << 2) + 0xff620000)
// bit 15:8 -- deblk_hmvd   -- {left_1, left_0, below_1, below_0, block3-0}
// bit 7:0 -- deblk_vmvd    -- {top_1, top_0, below_1, below_0, block3-0}
#define DBLK_VHMVD                                 ((0x0974  << 2) + 0xff620000)
// bit 13:12 -- right_vmvd
// bit 11 -- right_above_vmvd
// bit 10 -- left_below_hmvd
// bit 9 -- disable_dblk_luma
// bit 8 -- disable_dblk_chroma
// bit 7 -- bBelowRefDiff
// bit 6 -- bLeftRefDiff
// bit 5 -- bAboveRefDiff
// bit 4 -- reserved
// bit 3 -- s_below
// bit 2 -- s_left
// bit 1 -- s_above
// bit 0 -- s
#define DBLK_STRONG                                ((0x0975  << 2) + 0xff620000)
// bit 14:10 -- PQUANT
// bit 9:5 -- left_PQUANT
// bit 4:0 -- top_PQUANT
#define DBLK_RV8_QUANT                             ((0x0976  << 2) + 0xff620000)
#define DBLK_CBUS_HCMD2                            ((0x0977  << 2) + 0xff620000)
#define DBLK_CBUS_HCMD1                            ((0x0978  << 2) + 0xff620000)
#define DBLK_CBUS_HCMD0                            ((0x0979  << 2) + 0xff620000)
#define DBLK_VLD_HCMD2                             ((0x097a  << 2) + 0xff620000)
#define DBLK_VLD_HCMD1                             ((0x097b  << 2) + 0xff620000)
#define DBLK_VLD_HCMD0                             ((0x097c  << 2) + 0xff620000)
#define DBLK_OST_YBASE                             ((0x097d  << 2) + 0xff620000)
#define DBLK_OST_CBCRDIFF                          ((0x097e  << 2) + 0xff620000)
//13:8 dblk thread ID and token
//5:0  dblk pre arbiter burst num
#define DBLK_CTRL1                                 ((0x097f  << 2) + 0xff620000)
// MCRCC_CTL1
// 31:3  <reserved[23:0]>
// 2     <cfg_field_pic>
// 1     <sw_rst>
// 0     <bypass_en>
#define MCRCC_CTL1                                 ((0x0980  << 2) + 0xff620000)
// MCRCC_CTL2
// 31:24    <cfg_cache_anc01_c[7:0]>
// 23:16    <cfg_cache_anc01_y[7:0]>
// 15:8     <cfg_cache_anc00_c[7:0]>
// 7:0      <cfg_cache_anc00_y[7:0]>
#define MCRCC_CTL2                                 ((0x0981  << 2) + 0xff620000)
// MCRCC_CTL3
// 31:24    <cfg_cache_anc11_c[7:0]>
// 23:16    <cfg_cache_anc11_y[7:0]>
// 15:8     <cfg_cache_anc10_c[7:0]>
// 7:0      <cfg_cache_anc10_y[7:0]>
#define MCRCC_CTL3                                 ((0x0982  << 2) + 0xff620000)
// bit[31:10] reserved
// bit[9:0] sw_clock_gating control
// [9] vdec clk_en for assist and cbus.
// [8] vdec clk_en for ddr
// [7] vdec clk_en for vcpu
// [6] vdec clk_en for assist
// [5] vdec clk_en for dblk
// [4] vdec clk_en for iqidct
// [3] vdec clk_en for mc
// [2] vdec clk_en for pic_dc
// [1] vdec clk_en for psc
// [0] vdec clk_en for vld
#define GCLK_EN                                    ((0x0983  << 2) + 0xff620000)
// [0]  Reserved
// [1]  Reserved
// [2]  Reset assist, mdec's CBUS
// [3]  Reset mdec's VLD
// [4]  Reset mdec's VLD
// [5]  Reset mdec's VLD
// [6]  Reset mdec's IQIDCT
// [7]  Reset mdec's MC
// [8]  Reset mdec's DBLK
// [9]  Reset mdec's PIC_DC
// [10] Reset mdec's Pscale
// [11] Reset vcpu's MCPU
// [12] Reset vcpu's CCPU
// [13] Reset mmc_pre_arb
#define MDEC_SW_RESET                              ((0x0984  << 2) + 0xff620000)
//DBLK last address 12'h97f
//
// Closing file:  mdec_regs.h
//
//------------------------------------------------------------------------------
// VLD module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  vld_regs.h
//
//========================================================================
//  VLD module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_VLD_CBUS_BASE = 0x0c
// -----------------------------------------------
#define VLD_STATUS_CTRL                            ((0x0c00  << 2) + 0xff620000)
//
// bit 10 -- use_old_shift_en
// bit 9 -- output_mv_not_pmv
// bit 8:5 -- force_zigzag
// bit 4 -- force_zigzag_en
// bit 3 -- disable_viff_anempty_int
// bit 2 -- disable_m2_ac_coeff_one_cycle
// bit 1 -- forced_reset  force reset pmv
// bit 0 -- mpeg_type  0:mpeg1 1: mpeg2
#define MPEG1_2_REG                                ((0x0c01  << 2) + 0xff620000)
#define F_CODE_REG                                 ((0x0c02  << 2) + 0xff620000)
#define PIC_HEAD_INFO                              ((0x0c03  << 2) + 0xff620000)
#define SLICE_VER_POS_PIC_TYPE                     ((0x0c04  << 2) + 0xff620000)
#define QP_VALUE_REG                               ((0x0c05  << 2) + 0xff620000)
#define MBA_INC                                    ((0x0c06  << 2) + 0xff620000)
#define MB_MOTION_MODE                             ((0x0c07  << 2) + 0xff620000)
//`define PACKET_BYTE_COUNT   8'h08
// bit 15 -- force_search_startcode_en
// bit 14 -- int_cpu_when_error (before do anything)
// bit 13 -- vld_error_reset
// bit 12 -- return_on_slice_header
// bit 6 -- jpeg_ff00_en
// bit 5:0 -- vld_power_ctl
#define POWER_CTL_VLD                              ((0x0c08  << 2) + 0xff620000)
#define MB_WIDTH                                   ((0x0c09  << 2) + 0xff620000)
#define SLICE_QP                                   ((0x0c0a  << 2) + 0xff620000)
// `define MB_X_MB_Y           8'h0b   /* current MBX and MBY                  */
#define PRE_START_CODE                             ((0x0c0b  << 2) + 0xff620000)
#define SLICE_START_BYTE_01                        ((0x0c0c  << 2) + 0xff620000)
#define SLICE_START_BYTE_23                        ((0x0c0d  << 2) + 0xff620000)
#define RESYNC_MARKER_LENGTH                       ((0x0c0e  << 2) + 0xff620000)
// bit[6:5] - frame/field info, 01 - top, 10 - bottom, 11 - frame
// bit[4:0] - buffer ID
// L0_BUFF_ID_0, L0_BUFF_ID_1, L1_BUFF_ID_0, L1_BUFF_ID_1
#define DECODER_BUFFER_INFO                        ((0x0c0f  << 2) + 0xff620000)
#define FST_FOR_MV_X                               ((0x0c10  << 2) + 0xff620000)
#define FST_FOR_MV_Y                               ((0x0c11  << 2) + 0xff620000)
#define SCD_FOR_MV_X                               ((0x0c12  << 2) + 0xff620000)
#define SCD_FOR_MV_Y                               ((0x0c13  << 2) + 0xff620000)
#define FST_BAK_MV_X                               ((0x0c14  << 2) + 0xff620000)
#define FST_BAK_MV_Y                               ((0x0c15  << 2) + 0xff620000)
#define SCD_BAK_MV_X                               ((0x0c16  << 2) + 0xff620000)
#define SCD_BAK_MV_Y                               ((0x0c17  << 2) + 0xff620000)
// Bit 7:4 -- read_buffer_interlace  0-progressive, 1-interlace, used in VC1
// bit 3 -- disable_new_stcode_search_fix // From GXM
// bit 2 -- weighting_prediction
// bit 1 -- mb_weighting_flag
// bit 0 -- slice_weighting_flag
#define VLD_DECODE_CONTROL                         ((0x0c18  << 2) + 0xff620000)
#define VIFF_BIT_CNT                               ((0x0c1a  << 2) + 0xff620000)
#define BYTE_ALIGN_PEAK_HI                         ((0x0c1b  << 2) + 0xff620000)
#define BYTE_ALIGN_PEAK_LO                         ((0x0c1c  << 2) + 0xff620000)
#define NEXT_ALIGN_PEAK                            ((0x0c1d  << 2) + 0xff620000)
// bit 31    : byte_aligned_zero_23_from_org // From GXM
// bit 30    : force_shift_out_drop_flag_zero // From GXM
// bit 29    : en_st_protect_from_org // From GXM
// bit 28    : enable_halt_decode_start_voff
// bit 27    : disable_C_pred_check
// bit 26    : disable_I4_pred_check
// bit 25    : disable_I16_pred_check
// bit 24    : check_avs_1st_drop
// bit 23    : enable_cabac_protect // From GXM
// bit 22    : enable_avs_drop_more
// bit 21    : reset_avs_drop_ptr
// bit 20    : reset_cabac_use_next_at_end_req
// bit 19    : vc1_inv_intra_co_mb_ref_rd
// bit 18    : vc1_inv_co_mb_ref_rd
// bit 17    : vc1_inv_intra_co_mb_ref_wr
// bit 16    : vc1_inv_co_mb_ref_wr
// bit 15    : disable_mv_cal_begin_only
// bit 14    : avs_drop_enable
// bit 13:12 : avs_drop_ptr
// bit 11:8  : avs_demu_ctl_reg
// bit 7 : avs_enable
// bit 6 : disable_dblk_hcmd
// bit 5 : disable_mc_hcmd
// bit 4 : first_mode3_set enable
// bit 3 : first_mode3
// bit 2:1 : vc1_profile  0-SP, 1-MP, 2-reserved, 3-AP
// bit 0   : vc1_enable
#define VC1_CONTROL_REG                            ((0x0c1e  << 2) + 0xff620000)
#define PMV1_X                                     ((0x0c20  << 2) + 0xff620000)
#define PMV1_Y                                     ((0x0c21  << 2) + 0xff620000)
#define PMV2_X                                     ((0x0c22  << 2) + 0xff620000)
#define PMV2_Y                                     ((0x0c23  << 2) + 0xff620000)
#define PMV3_X                                     ((0x0c24  << 2) + 0xff620000)
#define PMV3_Y                                     ((0x0c25  << 2) + 0xff620000)
#define PMV4_X                                     ((0x0c26  << 2) + 0xff620000)
#define PMV4_Y                                     ((0x0c27  << 2) + 0xff620000)
// Can't use the same address for different defines
// Therefore, create a single define that covers both
// Only appears to be used in micro-code since the VLD hardware is
// hard coded.
// `define M4_TABLE_SELECT     8'h28  // Does this exist in HW ? Added from register_mp2.h
// `define M4_TABLE_OUTPUT     8'h28  // Does this exist in HW ? Added from register_mp2.h
#define M4_TABLE_SELECT                            ((0x0c28  << 2) + 0xff620000)
#define M4_CONTROL_REG                             ((0x0c29  << 2) + 0xff620000)
#define BLOCK_NUM                                  ((0x0c2a  << 2) + 0xff620000)
#define PATTERN_CODE                               ((0x0c2b  << 2) + 0xff620000)
#define MB_INFO                                    ((0x0c2c  << 2) + 0xff620000)
#define VLD_DC_PRED                                ((0x0c2d  << 2) + 0xff620000)
#define VLD_ERROR_MASK                             ((0x0c2e  << 2) + 0xff620000)
#define VLD_DC_PRED_C                              ((0x0c2f  << 2) + 0xff620000)
#define LAST_SLICE_MV_ADDR                         ((0x0c30  << 2) + 0xff620000)
#define LAST_MVX                                   ((0x0c31  << 2) + 0xff620000)
#define LAST_MVY                                   ((0x0c32  << 2) + 0xff620000)
#define VLD_C38                                    ((0x0c38  << 2) + 0xff620000)
#define VLD_C39                                    ((0x0c39  << 2) + 0xff620000)
#define VLD_STATUS                                 ((0x0c3a  << 2) + 0xff620000)
#define VLD_SHIFT_STATUS                           ((0x0c3b  << 2) + 0xff620000)
// `define VLD_SHIFT_INFO      8'h3b  // Does this exist in HW ? used in $ucode/mpeg4
#define VOFF_STATUS                                ((0x0c3c  << 2) + 0xff620000)
#define VLD_C3D                                    ((0x0c3d  << 2) + 0xff620000)
#define VLD_DBG_INDEX                              ((0x0c3e  << 2) + 0xff620000)
// vld_buff_info -- (index == 0)
// Bit11]    halt_decode_start_voff
// Bit10]    C_pred_error
// Bit[9]    I4_pred_error
// Bit[8]    I16_pred_error
// Bit[7:6]  mv_UR_ready_cnt;
// Bit[5]  vld_wr_idx
// Bit[4]  iq_rd_idx
// Bit[3]  vld_vi_block_rdy_1
// Bit[2]  vld_vi_block_rdy_2
// Bit[1]  voff_empty_1
// Bit[0]  voff_empty_2
// cabac_buff_info_0 -- (index == 1)
// Bit[31] shift_data_ready
// Bit[30:29] Reserved
// Bit[28:24] cabac_buffer_ptr
// Bit[23:0] cabac_buffer
// cabac_buff_info_1 -- (index == 2)
// Bit[31:29] Reserved
// Bit[28:20] Drange
// Bit[19:16] bin_count_4
// Bit[15:13] Reserved
// Bit[12:6] context_mem_do
// Bit[5:3] coeff_state
// Bit[2:0] mvd_state
// h264_mv_present -- (index == 3)
// Bit[31:16] mv_present_l0
// Bit[15:0] mv_present_l1
// h264_mv_cal_info_0 -- (index == 4)
// [31:28] mv_cal_state
// [27:24] direct_spatial_cnt
// Bit[23:21] Reserved
// Bit[20] mv_UR_ready_for_mv_cal
// Bit[19] co_mb_mem_ready_for_mv_cal
// Bit[18] mc_dblk_cmd_if_busy
// Bit[17] h264_co_mb_wr_busy
// Bit[16] H264_cbp_blk_ready
// Bit[15] mc_hcmd_rrdy
// Bit[14] mc_hcmd_srdy
// Bit[13] mc_cmd_if_ready
// Bit[12] mc_hcmd_mv_available
// Bit[11:8] mc_cmd_if_state
// Bit[7] dblk_hcmd_rrdy
// Bit[6] dblk_hcmd_srdy
// Bit[5] dblk_cmd_if_ready
// Bit[4] dblk_hcmd_mv_available
// Bit[3:0] dblk_cmd_if_state
// h264_mv_cal_info_1 -- (index == 5)
//  Bit[31:29] Reserved
//  Bit[28:24] total_mvd_num_l0
//  Bit[23:21] Reserved
//  Bit[20:16] mv_cal_ptr_l0
//  Bit[15:13] Reserved
//  Bit[12:8] mc_hcmd_ptr_l0
//  Bit[7:5] Reserved
//  Bit[4:0] dblk_hcmd_ptr_l0
// h264_mv_cal_info_2 -- (index == 6)
//  Bit[31:29] Reserved
//  Bit[28:24] total_mvd_num_l1
//  Bit[23:21] Reserved
//  Bit[20:16] mv_cal_ptr_l1
//  Bit[15:13] Reserved
//  Bit[12:8] mc_hcmd_ptr_l1
//  Bit[7:5] Reserved
//  Bit[4:0] dblk_hcmd_ptr_l1
// h264_co_mb_info -- (index == 7)
// Bit[31:26] Reserved
// Bit[25] mv_scale_cal_busy
// Bit[24:20] co_mv_count
// Bit[19:16] co_mv_process_state
// Bit[15] h264_co_mb_rd_busy
// Bit[15] h264_co_mb_rd_ready
// Bit[13:12] co_mv_transfer_block_cnt
// Bit[11:8] co_mv_transfer_ptr
// Bit[7] co_mv_POC_l1_busy
// Bit[6] h264_weight_scale_cal_en
// Bit[5] weight_cal_busy
// Bit[4] weight_cal_not_finished
// Bit[3:0] weight_process_state
#define VLD_DBG_DATA                               ((0x0c3f  << 2) + 0xff620000)
// --------------------------------------------
// VIFIFO DDR Interface
// --------------------------------------------
// The VIFIFO start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define VLD_MEM_VIFIFO_START_PTR                   ((0x0c40  << 2) + 0xff620000)
// The current pointer points so some location between the START and END
// pointers.  The current pointer is a BYTE pointer.  That is, you can
// point to any BYTE address within the START/END range
#define VLD_MEM_VIFIFO_CURR_PTR                    ((0x0c41  << 2) + 0xff620000)
#define VLD_MEM_VIFIFO_END_PTR                     ((0x0c42  << 2) + 0xff620000)
#define VLD_MEM_VIFIFO_BYTES_AVAIL                 ((0x0c43  << 2) + 0xff620000)
// VIFIFO FIFO Control
// bit  [31:24] viff_empty_int_enable_cpu[7:0]
// bit  [23:16] viff_empty_int_enable_amrisc[7:0]
//   -bit 23 Video BUFFER < 0x400 Bytes
//   -bit 22 Video BUFFER < 0x200 Bytes
//   -bit 21 Video BUFFER < 0x100 Bytes
//   -bit 20 Video BUFFER < 0x80 Bytes
//   -bit 19 Video BUFFER < 0x40 Bytes
//   -bit 18 Video BUFFER < 0x20 Bytes
//   -bit 17 vififo  < 16 double words
//   -bit 16 vififo  < 8 double words
// bit  [15:13] unused
// bit  [12]    A_urgent
// bit  [11]    transfer_length 0 - 32x64 Bits per request, 1 - 16x64 Bits per request
// bit  [10]    use_level       Set this bit to 1 to enable filling of the FIFO controlled by the buffer
//                              level control.  If this bit is 0, then use bit[1] to control the enabling of filling
// bit  [9]     Data Ready.     This bit is set when data can be popped
// bit  [8]     fill busy       This bit will be high when we're fetching data from the DDR memory
//                              To reset this module, set cntl_enable = 0, and then wait for busy = 0.
//                              After that you can pulse cntl_init to start over
// bit  [7]     init_with_cntl_init
// bit  [6]     reserved
// bits [5:3]   endian:         see $lib/rtl/ddr_endian.v
// bit  [2]     cntl_empty_en   Set to 1 to enable reading the DDR memory FIFO
//                              Set cntl_empty_en = cntl_fill_en = 0 when pulsing cntl_init
// bit  [1]     cntl_fill_en    Set to 1 to enable reading data from DDR memory
// bit  [0]     cntl_init:      After setting the read pointers, sizes, channel masks
//                              and read masks, set this bit to 1 and then to 0
//                              NOTE:  You don't need to pulse cntl_init if only the start address is
//                              being changed
#define VLD_MEM_VIFIFO_CONTROL                     ((0x0c44  << 2) + 0xff620000)
// --------------------------------------------
// VIFIFO Buffer Level Manager
// --------------------------------------------
#define VLD_MEM_VIFIFO_WP                          ((0x0c45  << 2) + 0xff620000)
#define VLD_MEM_VIFIFO_RP                          ((0x0c46  << 2) + 0xff620000)
#define VLD_MEM_VIFIFO_LEVEL                       ((0x0c47  << 2) + 0xff620000)
//
// bit  [8]     use_parser_video2_wp
// bit  [7]     vbuf2_out_manual
// bit  [6]     vbuf_out_manual
// bit  [5]     empty (ReadOnly)
// bit  [4]     full (ReadOnly)
// bit  [3:2]   reserved
// bit  [1]     manual mode     Set to 1 for manual write pointer mode
// bit  [0]     Init            Set high then low after everything has been initialized
#define VLD_MEM_VIFIFO_BUF_CNTL                    ((0x0c48  << 2) + 0xff620000)
// bit 31:16 -- drop_bytes
// bit 15:14 -- drop_status (Read-Only)
// bit 13:12 -- sync_match_position (Read-Only)
// bit 11:6 -- reserved
// bit 5:4 -- TIME_STAMP_NUMBER, 0-32bits, 1-64bits, 2-96bits, 3-128bits
// bit 3 -- stamp_soft_reset
// bit 2 -- TIME_STAMP_length_enable
// bit 1 -- TIME_STAMP_sync64_enable
// bit 0 -- TIME_STAMP_enable
#define VLD_TIME_STAMP_CNTL                        ((0x0c49  << 2) + 0xff620000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_0
#define VLD_TIME_STAMP_SYNC_0                      ((0x0c4a  << 2) + 0xff620000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_1
#define VLD_TIME_STAMP_SYNC_1                      ((0x0c4b  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_0
#define VLD_TIME_STAMP_0                           ((0x0c4c  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_1
#define VLD_TIME_STAMP_1                           ((0x0c4d  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_2
#define VLD_TIME_STAMP_2                           ((0x0c4e  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_3
#define VLD_TIME_STAMP_3                           ((0x0c4f  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_LENGTH
#define VLD_TIME_STAMP_LENGTH                      ((0x0c50  << 2) + 0xff620000)
// bit 15:0 vififo_rd_count
#define VLD_MEM_VIFIFO_WRAP_COUNT                  ((0x0c51  << 2) + 0xff620000)
// bit 29:24 A_brst_num
// bit 21:16 A_id
// bit 15:0 level_hold
#define VLD_MEM_VIFIFO_MEM_CTL                     ((0x0c52  << 2) + 0xff620000)
#define VLD_MEM_VBUF_RD_PTR                        ((0x0c53  << 2) + 0xff620000)
#define VLD_MEM_VBUF2_RD_PTR                       ((0x0c54  << 2) + 0xff620000)
#define VLD_MEM_SWAP_ADDR                          ((0x0c55  << 2) + 0xff620000)
// bit[23:16] - swap_d_count (Read Only)
// bit[15:8]  - swap_a_count (Read Only)
// bit [7] - swap busy (Read Only)
// bit [6:2] - reserved
// bit [1] - 1 - STORE to Memory, 0 - LOAD from Memory
// bit [0] - swap active
#define VLD_MEM_SWAP_CTL                           ((0x0c56  << 2) + 0xff620000)
//
// Closing file:  vld_regs.h
//
//------------------------------------------------------------------------------
// IQ/IDCT module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  iqidct_regs.h
//
//========================================================================
//  IQ/IDCT module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_IQIDCT_CBUS_BASE = 0x0e
// -----------------------------------------------
#define VCOP_CTRL_REG                              ((0x0e00  << 2) + 0xff620000)
#define QP_CTRL_REG                                ((0x0e01  << 2) + 0xff620000)
#define INTRA_QUANT_MATRIX                         ((0x0e02  << 2) + 0xff620000)
#define NON_I_QUANT_MATRIX                         ((0x0e03  << 2) + 0xff620000)
#define DC_SCALER                                  ((0x0e04  << 2) + 0xff620000)
#define DC_AC_CTRL                                 ((0x0e05  << 2) + 0xff620000)
// `define RV_AI_CTRL          8'h05  // ONLY for $ucode/real/amrisc/rv.s reg value from apollo
#define DC_AC_SCALE_MUL                            ((0x0e06  << 2) + 0xff620000)
#define DC_AC_SCALE_DIV                            ((0x0e07  << 2) + 0xff620000)
// `define DC_AC_SCALE_RESULT  8'h06
// `define RESERVED_E07        8'h07
#define POWER_CTL_IQIDCT                           ((0x0e08  << 2) + 0xff620000)
#define RV_AI_Y_X                                  ((0x0e09  << 2) + 0xff620000)
#define RV_AI_U_X                                  ((0x0e0a  << 2) + 0xff620000)
#define RV_AI_V_X                                  ((0x0e0b  << 2) + 0xff620000)
// bit 15:0 will count up when rv_ai_mb finished when non zero
// and rv_ai_mb_finished_int will be generate when this is not zero
#define RV_AI_MB_COUNT                             ((0x0e0c  << 2) + 0xff620000)
// For H264 I in PB picture Use -- dma type : h264_next_intra_dma
#define NEXT_INTRA_DMA_ADDRESS                     ((0x0e0d  << 2) + 0xff620000)
// Bit 16 -- dcac_dma_read_cache_disable
// Bit 15 -- dcac_dma_urgent
// Bit 14 -- nv21_swap
// Bit 13 -- nv21_top_dma
// Bit 12 -- reset_rv_ai_wait_rd_data
// Bit 11 -- set_rv_ai_wait_rd_data [12:11] = 3 means only dec 1 (For Skipped MB of MBAFF)
// Bit 10 -- rv_ai_wait_rd_data (Read Only)
// Bit 9 -- enable_rv_ai_wait_rd_data
// Bit 8 -- disable_vc1_mv_update
// Bit 7 -- pred_dc_signed
// Bit 6 -- inc_vld_ready_count
// Bit 5 -- dec_vld_ready_count
// Bit 4 -- disable_ref_bidir_fix
// Bit 3 -- disable_MV_UL_l1_bot_fix
// Bit 2 -- disable_mb_aff_fix
// Bit 1 -- canvas_addr_7
// Bit 0 -- constrained_intra_pred_flag for H264
#define IQIDCT_CONTROL                             ((0x0e0e  << 2) + 0xff620000)
// Bit[31:19] Reserved
// Bit[18] iq_waiting
// Bit[17] iq_om_wr_idx
// Bit[16] iq_om_rd_idx
// Bit[15] iq_om_busy
// Bit[14] iq_om_2_busy
// Bit[13] idx_fifo_0
// Bit[12] idx_fifo_1
// Bit[11] idx_fifo_2
// Bit[10] idx_fifo_3
// Bit[9] idx_fifo_4
// Bit[8] idx_fifo_5
// Bit[7] idx_fifo_6
// Bit[6] idx_fifo_7
// Bit[5:3] idx_fifo_wp
// Bit[2:0] idx_fifo_rp
#define IQIDCT_DEBUG_INFO_0                        ((0x0e0f  << 2) + 0xff620000)
// For RTL Simulation Only
#define DEBLK_CMD                                  ((0x0e10  << 2) + 0xff620000)
// Bit[15+16] ds_mc_valid_2
// Bit[14+16] new_idct1_rd_idx_2
// Bit[13+16] new_idct1_wr_idx_2
// Bit[12+16] idct1_buff0_busy_2
// Bit[11+16] idct1_buff1_busy_2
// Bit[10+16] new_idct1_busy_2
// Bit[9+16] iq_om_8val_2
// Bit[8+16] idct1_pipe_busy_2
// Bit[7+16] wait_mb_left_finish_hold_2
// Bit[6+16] new_idct2_rd_idx_2
// Bit[5+16] new_idct2_wr_idx_2
// Bit[4+16] idct2_buff0_busy_2
// Bit[3+16] idct2_buff1_busy_2
// Bit[2+16] idct2_en_2
// Bit[1+16] new_idct2_busy_2
// Bit[0+16] new_idct1_ready_2
// Bit[15] ds_mc_valid_1
// Bit[14] new_idct1_rd_idx_1
// Bit[13] new_idct1_wr_idx_1
// Bit[12] idct1_buff0_busy_1
// Bit[11] idct1_buff1_busy_1
// Bit[10] new_idct1_busy_1
// Bit[9] iq_om_8val_1
// Bit[8] idct1_pipe_busy_1
// Bit[7] wait_mb_left_finish_hold_1
// Bit[6] new_idct2_rd_idx_1
// Bit[5] new_idct2_wr_idx_1
// Bit[4] idct2_buff0_busy_1
// Bit[3] idct2_buff1_busy_1
// Bit[2] idct2_en_1
// Bit[1] new_idct2_busy_1
// Bit[0] new_idct1_ready_1
#define IQIDCT_DEBUG_IDCT                          ((0x0e11  << 2) + 0xff620000)
// bit 31 -- convas_enable
// bit 30:24 -- convas_x_count ( 8 pixels / 64 bits )
// bit 23:16 -- convas_y_count
// bit 15   -- dcac_dma_busy
// bit 14   -- dcac_dma_read_cache_active
// bit 13:8 -- dcac_dma_count
// bit 7    -- dcac_dma_rw
// bit 6    -- dcac_skip_read_mode
// bit 5:0  -- dcac_dma_offset
#define DCAC_DMA_CTRL                              ((0x0e12  << 2) + 0xff620000)
// when (convas_enable == 0 )
//   bit 31:0 dcac_dma_addr
// when (convas_enable == 1 )
//   bit 31:25 canvas_addr (7 bits)
//   bit 24:12 convas_y_start ( 13 btis )
//   bit 11:0  convas_x_start ( 12 btis )
#define DCAC_DMA_ADDRESS                           ((0x0e13  << 2) + 0xff620000)
// bit 7:0 -- dcac_cpu_addr
#define DCAC_CPU_ADDRESS                           ((0x0e14  << 2) + 0xff620000)
// bit 31:0 -- dcac_cpu_data
#define DCAC_CPU_DATA                              ((0x0e15  << 2) + 0xff620000)
// bit 31:19 -- reserved
// bit 18:16 -- block_num_reg -- Read-Only
// bit 15:0 -- dcac_mb_count
#define DCAC_MB_COUNT                              ((0x0e16  << 2) + 0xff620000)
// bit 31:18 -- reserved
// For H264 :
//   bit 17:2 -- h264_quant
//   bit 11:6 -- h264_quant_c
//   bit  5:0 -- h264_quant_c
// For VC1 :
//   bit    17 -- qindex_GT_8
//   bit    16 -- HalfQPStep
//   bit 15:12 -- eQuantMode
//   bit 11:6  -- AltPQuant
//   bit  5:0  -- PQuant
//
#define IQ_QUANT                                   ((0x0e17  << 2) + 0xff620000)
// bit 31:24  -- bitplane_width
// bit 23:16  -- bitplane_height
// bit 15:14  -- bitplane_start_x
// bit 13:12  -- bitplane_start_y
// bit 11:4   -- reserved
// bit 3:1    -- bitplane_type
// bit 0      -- bitplane_busy
#define VC1_BITPLANE_CTL                           ((0x0e18  << 2) + 0xff620000)
// bit 24:16  -- wq_param1
// bit  8: 0  -- wq_param0
#define AVSP_IQ_WQ_PARAM_01                        ((0x0e19  << 2) + 0xff620000)
// bit 24:16  -- wq_param3
// bit  8: 0  -- wq_param2
#define AVSP_IQ_WQ_PARAM_23                        ((0x0e1a  << 2) + 0xff620000)
// bit 24:16  -- wq_param5
// bit  8: 0  -- wq_param4
#define AVSP_IQ_WQ_PARAM_45                        ((0x0e1b  << 2) + 0xff620000)
// bit    31  -- weight_quant_en
// bit 17:16  -- current_scene_model
// bit 12: 8  -- chroma_qp_delta_cr
// bit  4: 0  -- chroma_qp_delta_cb
#define AVSP_IQ_CTL                                ((0x0e1c  << 2) + 0xff620000)
    #define RAM_TEST_CMD        0x002
    #define RAM_TEST_ADDR       0x003
    #define RAM_TEST_DATAH      0x004
    #define RAM_TEST_DATAL      0x005

    #define RAM_TEST_RD_CMD	    0x0000
    #define RAM_TEST_WR_CMD	    0x8000
    #define IDCT_TM2_PT0	    0x0001
    #define IDCT_TM2_PT1	    0x0002
    #define IDCT_TM1_PT0	    0x0004
    #define IDCT_TM1_PT1	    0x0008
    #define IQ_OMEM_PT0	        0x0010
    #define IQ_OMEM_PT1	        0x0020
    #define MC_IMEM_PT0	        0x0040
    #define ALL_RAM_PTS	        0x007f
//======================================
//  VCOP Control Register Bits
//
//======================================
    //`define IQIDCT_RESET	    16'h0001	    // Bit 0
    #define QM_WEN		    0x0002	    // Bit 1
    #define IQIDCT_ENABLE	    0x0004	    // Bit 2
    #define INTRA_QM	    0x0008	    // Bit 3	0 = Use default; 1 = use loaded
    #define NINTRA_QM	    0x0010	    // Bit 4	0 = Use default; 1 = use loaded
//======================================
//  QP Control Register Bits
//
//======================================
    #define INTRA_MODE	    0x0080	    // Bit 7
// Duplicate Address:  When actually used
// please move to a different address
// `define FLD_DCT_TYPE	    16'h0100	    // Bit 8	0 = Frame DCT; 1 = field DCT
//
// Closing file:  iqidct_regs.h
//
//------------------------------------------------------------------------------
// VCPU module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  vcpu_regs.h
//
//========================================================================
//  VCPU module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_VCPU_CBUS_BASE = 0x03
// -----------------------------------------------
#define MSP                                        ((0x0300  << 2) + 0xff620000)
#define MPSR                                       ((0x0301  << 2) + 0xff620000)
#define MINT_VEC_BASE                              ((0x0302  << 2) + 0xff620000)
#define MCPU_INTR_GRP                              ((0x0303  << 2) + 0xff620000)
#define MCPU_INTR_MSK                              ((0x0304  << 2) + 0xff620000)
#define MCPU_INTR_REQ                              ((0x0305  << 2) + 0xff620000)
#define MPC_P                                      ((0x0306  << 2) + 0xff620000)
#define MPC_D                                      ((0x0307  << 2) + 0xff620000)
#define MPC_E                                      ((0x0308  << 2) + 0xff620000)
#define MPC_W                                      ((0x0309  << 2) + 0xff620000)
#define MINDEX0_REG                                ((0x030a  << 2) + 0xff620000)
#define MINDEX1_REG                                ((0x030b  << 2) + 0xff620000)
#define MINDEX2_REG                                ((0x030c  << 2) + 0xff620000)
#define MINDEX3_REG                                ((0x030d  << 2) + 0xff620000)
#define MINDEX4_REG                                ((0x030e  << 2) + 0xff620000)
#define MINDEX5_REG                                ((0x030f  << 2) + 0xff620000)
#define MINDEX6_REG                                ((0x0310  << 2) + 0xff620000)
#define MINDEX7_REG                                ((0x0311  << 2) + 0xff620000)
#define MMIN_REG                                   ((0x0312  << 2) + 0xff620000)
#define MMAX_REG                                   ((0x0313  << 2) + 0xff620000)
#define MBREAK0_REG                                ((0x0314  << 2) + 0xff620000)
#define MBREAK1_REG                                ((0x0315  << 2) + 0xff620000)
#define MBREAK2_REG                                ((0x0316  << 2) + 0xff620000)
#define MBREAK3_REG                                ((0x0317  << 2) + 0xff620000)
#define MBREAK_TYPE                                ((0x0318  << 2) + 0xff620000)
#define MBREAK_CTRL                                ((0x0319  << 2) + 0xff620000)
#define MBREAK_STAUTS                              ((0x031a  << 2) + 0xff620000)
#define MDB_ADDR_REG                               ((0x031b  << 2) + 0xff620000)
#define MDB_DATA_REG                               ((0x031c  << 2) + 0xff620000)
#define MDB_CTRL                                   ((0x031d  << 2) + 0xff620000)
#define MSFTINT0                                   ((0x031e  << 2) + 0xff620000)
#define MSFTINT1                                   ((0x031f  << 2) + 0xff620000)
#define CSP                                        ((0x0320  << 2) + 0xff620000)
#define CPSR                                       ((0x0321  << 2) + 0xff620000)
#define CINT_VEC_BASE                              ((0x0322  << 2) + 0xff620000)
#define CCPU_INTR_GRP                              ((0x0323  << 2) + 0xff620000)
#define CCPU_INTR_MSK                              ((0x0324  << 2) + 0xff620000)
#define CCPU_INTR_REQ                              ((0x0325  << 2) + 0xff620000)
#define CPC_P                                      ((0x0326  << 2) + 0xff620000)
#define CPC_D                                      ((0x0327  << 2) + 0xff620000)
#define CPC_E                                      ((0x0328  << 2) + 0xff620000)
#define CPC_W                                      ((0x0329  << 2) + 0xff620000)
#define CINDEX0_REG                                ((0x032a  << 2) + 0xff620000)
#define CINDEX1_REG                                ((0x032b  << 2) + 0xff620000)
#define CINDEX2_REG                                ((0x032c  << 2) + 0xff620000)
#define CINDEX3_REG                                ((0x032d  << 2) + 0xff620000)
#define CINDEX4_REG                                ((0x032e  << 2) + 0xff620000)
#define CINDEX5_REG                                ((0x032f  << 2) + 0xff620000)
#define CINDEX6_REG                                ((0x0330  << 2) + 0xff620000)
#define CINDEX7_REG                                ((0x0331  << 2) + 0xff620000)
#define CMIN_REG                                   ((0x0332  << 2) + 0xff620000)
#define CMAX_REG                                   ((0x0333  << 2) + 0xff620000)
#define CBREAK0_REG                                ((0x0334  << 2) + 0xff620000)
#define CBREAK1_REG                                ((0x0335  << 2) + 0xff620000)
#define CBREAK2_REG                                ((0x0336  << 2) + 0xff620000)
#define CBREAK3_REG                                ((0x0337  << 2) + 0xff620000)
#define CBREAK_TYPE                                ((0x0338  << 2) + 0xff620000)
#define CBREAK_CTRL                                ((0x0339  << 2) + 0xff620000)
#define CBREAK_STAUTS                              ((0x033a  << 2) + 0xff620000)
#define CDB_ADDR_REG                               ((0x033b  << 2) + 0xff620000)
#define CDB_DATA_REG                               ((0x033c  << 2) + 0xff620000)
#define CDB_CTRL                                   ((0x033d  << 2) + 0xff620000)
#define CSFTINT0                                   ((0x033e  << 2) + 0xff620000)
#define CSFTINT1                                   ((0x033f  << 2) + 0xff620000)
#define IMEM_DMA_CTRL                              ((0x0340  << 2) + 0xff620000)
#define IMEM_DMA_ADR                               ((0x0341  << 2) + 0xff620000)
#define IMEM_DMA_COUNT                             ((0x0342  << 2) + 0xff620000)
// bit[29:24] A_brst_num_imem
// bit[21:16] A_id_imem
// bit[11:0] wrrsp_count_imem (reserved)
#define WRRSP_IMEM                                 ((0x0343  << 2) + 0xff620000)
#define LMEM_DMA_CTRL                              ((0x0350  << 2) + 0xff620000)
#define LMEM_DMA_ADR                               ((0x0351  << 2) + 0xff620000)
#define LMEM_DMA_COUNT                             ((0x0352  << 2) + 0xff620000)
// bit[29:24] A_brst_num_lmem
// bit[21:16] A_id_lmem
// bit[11:0] wrrsp_count_lmem
#define WRRSP_LMEM                                 ((0x0353  << 2) + 0xff620000)
#define MAC_CTRL1                                  ((0x0360  << 2) + 0xff620000)
#define ACC0REG1                                   ((0x0361  << 2) + 0xff620000)
#define ACC1REG1                                   ((0x0362  << 2) + 0xff620000)
#define MAC_CTRL2                                  ((0x0370  << 2) + 0xff620000)
#define ACC0REG2                                   ((0x0371  << 2) + 0xff620000)
#define ACC1REG2                                   ((0x0372  << 2) + 0xff620000)
#define CPU_TRACE                                  ((0x0380  << 2) + 0xff620000)
//
// Closing file:  vcpu_regs.h
//
//------------------------------------------------------------------------------
// HENC module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  henc_regs.h
//
//========================================================================
//  MDEC module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_HCODEC_HENC_CBUS_BASE = 0x0a
// -----------------------------------------------
#define HENC_SCRATCH_0                             ((0x1ac0  << 2) + 0xff620000)
#define HENC_SCRATCH_1                             ((0x1ac1  << 2) + 0xff620000)
#define HENC_SCRATCH_2                             ((0x1ac2  << 2) + 0xff620000)
#define HENC_SCRATCH_3                             ((0x1ac3  << 2) + 0xff620000)
#define HENC_SCRATCH_4                             ((0x1ac4  << 2) + 0xff620000)
#define HENC_SCRATCH_5                             ((0x1ac5  << 2) + 0xff620000)
#define HENC_SCRATCH_6                             ((0x1ac6  << 2) + 0xff620000)
#define HENC_SCRATCH_7                             ((0x1ac7  << 2) + 0xff620000)
#define HENC_SCRATCH_8                             ((0x1ac8  << 2) + 0xff620000)
#define HENC_SCRATCH_9                             ((0x1ac9  << 2) + 0xff620000)
#define HENC_SCRATCH_A                             ((0x1aca  << 2) + 0xff620000)
#define HENC_SCRATCH_B                             ((0x1acb  << 2) + 0xff620000)
#define HENC_SCRATCH_C                             ((0x1acc  << 2) + 0xff620000)
#define HENC_SCRATCH_D                             ((0x1acd  << 2) + 0xff620000)
#define HENC_SCRATCH_E                             ((0x1ace  << 2) + 0xff620000)
#define HENC_SCRATCH_F                             ((0x1acf  << 2) + 0xff620000)
#define HENC_SCRATCH_G                             ((0x1ad0  << 2) + 0xff620000)
#define HENC_SCRATCH_H                             ((0x1ad1  << 2) + 0xff620000)
#define HENC_SCRATCH_I                             ((0x1ad2  << 2) + 0xff620000)
#define HENC_SCRATCH_J                             ((0x1ad3  << 2) + 0xff620000)
#define HENC_SCRATCH_K                             ((0x1ad4  << 2) + 0xff620000)
#define HENC_SCRATCH_L                             ((0x1ad5  << 2) + 0xff620000)
#define HENC_SCRATCH_M                             ((0x1ad6  << 2) + 0xff620000)
#define HENC_SCRATCH_N                             ((0x1ad7  << 2) + 0xff620000)
// bit [7:0] data_feed_buff_id
#define IE_DATA_FEED_BUFF_INFO                     ((0x1ad8  << 2) + 0xff620000)
//
// Closing file:  henc_regs.h
//
//------------------------------------------------------------------------------
// VLC module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  vlc_regs.h
//
//========================================================================
//  VLC module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_HCODEC_VLC_CBUS_BASE = 0x0d
// -----------------------------------------------
// Bit[31:28] - henc_status
// Bit[27:8] - reserved
// Bit[7]    mc_hcmd_buff_enable
// Bit[6]    mc_hcmd_use_mc_hcmd_buff
// Bit[5]    mc_hcmd_use_mc_hcmd_hw_start
// Bit[4]    no_mc_out_null_non_skipped_mb
// Bit[3]    mc_out_even_skipped_mb
// Bit[2] - hcmd_enable
// Bit[1] - vlc_control_enable (0 will treat as soft_reset)
// Bit[0] - vlc_input_enable (enable input interface)
#define VLC_STATUS_CTRL                            ((0x1d00  << 2) + 0xff620000)
// Bit [31]  - small_luma_ignore_chroma
// Bit[30:16] - Reserved
// Bit [15]  - enable_free_clk_mc_hcmd_buff
// Bit [14]  - enable_free_clk_reg
// Bit [13]  - enable_free_clk_stream
// Bit [12]  - enable_free_clk_pre_buff
// Bit [11]  - enable_free_clk_vb_buff
// Bit [10]  - enable_free_clk_dc_input
// Bit [9]   - enable_free_clk_input
// Bit [8]   - enable_free_clk_mv_cal
// Bit [7]   - enable_free_clk_status
// Bit [6]   - enable_free_clk_mc_dblk_cmd_if
// Bit [5]   - disable_mvd_enc_finished
// Bit [4]   - I16MB_share_ipred_mode_with_I4MB
// Bit [3]   - fixed_picture_qp
// Bit [2]   - use_set_b8_mode ( not used now)
// Bit [1]   - use_set_mb_skip_run
// Bit [0]   - pop_coeff_even_all_zero
#define VLC_CONFIG                                 ((0x1d01  << 2) + 0xff620000)
// --------------------------------------------
// Bitstream DDR Interface
// --------------------------------------------
#define VLC_VB_START_PTR                           ((0x1d10  << 2) + 0xff620000)
#define VLC_VB_END_PTR                             ((0x1d11  << 2) + 0xff620000)
#define VLC_VB_WR_PTR                              ((0x1d12  << 2) + 0xff620000)
// Read Only, VLC_VB_SW_RD_PTR or VLC_VB_HW_RD_PTR
#define VLC_VB_RD_PTR                              ((0x1d13  << 2) + 0xff620000)
#define VLC_VB_SW_RD_PTR                           ((0x1d14  << 2) + 0xff620000)
// Read Only
#define VLC_VB_LEFT                                ((0x1d15  << 2) + 0xff620000)
// VB FIFO Control
// bit  [31:24] vb_full_int_enable_cpu[7:0]
// bit  [23:16] vb_full_int_enable_amrisc[7:0]
//   -bit 23 Video BUFFER LEFT < 0x400 Bytes
//   -bit 22 Video BUFFER LEFT < 0x200 Bytes
//   -bit 21 Video BUFFER LEFT < 0x100 Bytes
//   -bit 20 Video BUFFER LEFT < 0x80 Bytes
//   -bit 19 Video BUFFER LEFT < 0x40 Bytes
//   -bit 18 Video BUFFER LEFT < 0x20 Bytes
//   -bit 17 vbfifo left  < 16 double words (8x64bits)
//   -bit 16 vbfifo left  < 8 double words (4x64bits)
// bit  [15]    wr_ptr_int_enable_cpu
// bit  [14]    wr_ptr_int_enable_amrisc
// bit  [13]    wr_ptr_int (Read Only, write 1 will clear)
// bit  [12]    vb_full_int_enable_cpu(Read Only)
// bit  [11]    vb_full_int_enable_amrisc(Read Only)
// bit  [10]    reserved
// bit  [9]     use_vb_hw_rd_ptr
// bit  [8]     vb_always_ready Set to 1 to ignore vb_level blocking DDR write
// bit  [7]     vb_ready_for_transfer (Read Only)
// bit  [6]     data_ready_for_transfer (Read Only)
// bits [5:3]   vb_endian       Set VB Endian inside DDR memory
// bit  [2]     vb_write_busy   Read Only - indicate DDR write busy
// bit  [1]     vb_write_en     Set to 1 to enable writing data to DDR memory
// bit  [0]     vb_soft_reset   Soft reset
#define VLC_VB_CONTROL                             ((0x1d16  << 2) + 0xff620000)
// bit 31    transfer_length 0 - 32x64 Bits per request, 1 - 16x64 Bits per request  // default : 0
// bit 30    A_urgent  // default : 0
// bit 29:24 A_brst_num // default : 0x3f
// bit 23:22 reserved
// bit 21:16 A_id  // default : 0x20
// bit 15:0  vb_left_hold // default : 0
#define VLC_VB_MEM_CTL                             ((0x1d17  << 2) + 0xff620000)
// vb_wr_ptr address to generate interrupt
#define VLC_VB_INT_PTR                             ((0x1d18  << 2) + 0xff620000)
// bit[31:12] reserved
// bit[11:0] vlc_wrrsp_count
#define VLC_WRRSP                                  ((0x1d19  << 2) + 0xff620000)
#define VLC_TOTAL_BYTES                            ((0x1d1a  << 2) + 0xff620000)
// bit  [31:26] reserved
// bit  [25]    vb_flush
// bit  [24]    vb_reg_ready
// bit  [23:16] vb_buff_left     -- Read only
// bit  [15:8]  vb_buff_wr_point -- RW
// bit  [7:0]   vb_buff_rd_point -- RW
#define VLC_VB_BUFF                                ((0x1d1b  << 2) + 0xff620000)
// bit[31]    flush_vlc_pre_buff
// bit[30:27] reserved
// bit[26:24] vb_pre_buff_level
// bit[23:0]  vb_pre_buff_data[55:32]
#define VLC_VB_PRE_BUFF_HI                         ((0x1d1c  << 2) + 0xff620000)
// bit[31:0] vb_pre_buff_data[31:0]
#define VLC_VB_PRE_BUFF_LOW                        ((0x1d1d  << 2) + 0xff620000)
// bit[31]    stream_encap_enable  // 0x0000(00-03) will be changed to 0x000003(00-03) if enabled
// bit[30:29] stream_encap_delay   // delay bytes for encap used
// bit[28:24] stream_buff_point
// bit[23:0]  stream_buff_data
#define VLC_STREAM_BUFF                            ((0x1d1e  << 2) + 0xff620000)
// bit[31]    push_stream_block - Read Only (Will set if vb_buff full)
// bit[30]    push_stream_busy  - Read Only (busy when output one byte from stream_buf (max 2 clocks for 8 bits push)
// bit[29:28] stream_encap_status - Read Only
// bit[27:21] reserved
// Long Mode : (Amrisc need movilo and mvihi high to set stream_info)
//   bit[20:16] push_stream_long_length (0 or 31 : Mid or Short mode)
//   bit[15:0]  push_stream_data
// Mid Mode : (Amrisc need movi to set stream_info)
//   bit[15:12]] push_stream_mid_length (1-12 : mid mode active, 0-short mode, 15 - byte align)
//   bit[11:0]  push_stream_data
// Short Mode : (Amrisc can use mtspi to push stream directly)
//   bit[7:5] push_stream_short_length (0-5 : short length, else - invalid)
//   bit[4:0]  push_stream_data
#define VLC_PUSH_STREAM                            ((0x1d1f  << 2) + 0xff620000)
// bit[15:8] ELEMENT_LENGTH
// bit[7:1]  reserved
// bit[0]  Write - push start, Read - Push Busy
#define VLC_PUSH_ELEMENT                           ((0x1d20  << 2) + 0xff620000)
#define VLC_ELEMENT_DATA                           ((0x1d21  << 2) + 0xff620000)
// bit[7] hcmd_intra_use_sw_info
// bit[6] hcmd_use_sw_info
// bit[5] always_use_info_0_cbp_blk
// bit[4] always_update_info_0_cbp_blk
// bit[3] reset_left_mb_wr
// bit[2] reset_top_mb_wr
// bit[1] set_left_mb_wr
// bit[0] set_top_mb_wr
#define VLC_SPECIAL_CTL                            ((0x1d22  << 2) + 0xff620000)
// bit[28]    left_intra
// bit[27:22] left_quant
// bit[21:16] left_quant_c
// bit[12]    top_intra
// bit[11:6]  top_quant
// bit[5:0]   top_quant_c
#define VLC_HCMD_T_L_INFO                          ((0x1d23  << 2) + 0xff620000)
// bit[12]    cur_intra
// bit[11:6]  cur_quant
// bit[5:0]   cur_quant_c
#define VLC_HCMD_CUR_INFO                          ((0x1d24  << 2) + 0xff620000)
// bit[13]    top_left_info_in_data_mv_cal
// bit[12]    only_use_info_0_top_left_in_I
// bit[11]    top_left_info_in_data
// bit[10]    early_mix_mc_hcmd
// bit[9]     update_top_left_mix
// bit[8]     p_top_left_mix
// bit[7]     mv_cal_mixed_type
// bit[6]     mc_hcmd_mixed_type
// bit[5]     use_separate_int_control
// bit[4]     hcmd_intra_use_q_info
// bit[3]     hcmd_left_use_prev_info
// bit[2]     hcmd_use_q_info
// bit[1]     use_q_delta_quant
// bit[0]     detect_I16_from_I4
#define VLC_ADV_CONFIG                             ((0x1d25  << 2) + 0xff620000)
//   31 - use_hcmd_mb_xy_auto
//23:16 - hcmd_max_mb_x
//15:8  - hcmd_mb_y_auto
// 7:0  - hcmd_mb_x_auto
#define VLC_HCMD_MBXY_AUTO                         ((0x1d26  << 2) + 0xff620000)
// bit[31:0] vlc_int_control_inter -- will be used when use_separate_int_control is set
#define VLC_INT_CONTROL_INTER                      ((0x1d2f  << 2) + 0xff620000)
// --------------------------------------------
// Picture VLC
// --------------------------------------------
// (&(int|(~AND_enable))|(|(int&OR_enable)))
// bit[31]    OR interrupt Enable Reserved
// bit[30]    OR interrupt Enable for mv_busy
// bit[29]    OR interrupt Enable for b8_mode_busy
// bit[28]    OR interrupt Enable for mb_skip_run_busy
// bit[27]    OR interrupt Enable for cbp_busy
// bit[26]    OR interrupt Enable for Reserved
// bit[25]    OR interrupt Enable for Reserved
// bit[24]    OR interrupt Enable for mb_info_busy
// bit[23]    AND interrupt Enable Reserved
// bit[22]    AND interrupt Enable for mv_busy
// bit[21]    AND interrupt Enable for b8_mode_busy
// bit[20]    AND interrupt Enable for mb_skip_run_busy
// bit[19]    AND interrupt Enable for cbp_busy
// bit[18]    AND interrupt Enable for Reserved
// bit[17]    AND interrupt Enable for Reserved
// bit[16]    AND interrupt Enable for mb_info_busy
// bit[15]    OR interrupt Enable Reserved
// bit[14]    OR interrupt Enable for mvd
// bit[13]    OR interrupt Enable for b8_mode
// bit[12]    OR interrupt Enable for mb_skip_run
// bit[11]    OR interrupt Enable for cbp_ready
// bit[10]    OR interrupt Enable for c_ipred_mode_ready
// bit[9]     OR interrupt Enable for ipred_mode_ready
// bit[8]     OR interrupt Enable for mb_info_ready
// bit[7]     AND interrupt Enable Reserved
// bit[6]     AND interrupt Enable for mvd
// bit[5]     AND interrupt Enable for b8_mode
// bit[4]     AND interrupt Enable for mb_skip_run
// bit[3]     AND interrupt Enable for cbp_ready
// bit[2]     AND interrupt Enable for c_ipred_mode_ready
// bit[1]     AND interrupt Enable for ipred_mode_ready
// bit[0]     AND interrupt Enable for mb_info_ready
#define VLC_INT_CONTROL                            ((0x1d30  << 2) + 0xff620000)
// Bit[31:16] picture_height
// Bit[15:0]  picture_width
#define VLC_PIC_SIZE                               ((0x1d31  << 2) + 0xff620000)
// [31:16] Reserved
// [15:3] pic_width_in_mbs_minus1
// [2:0]  picture_type
#define VLC_PIC_INFO                               ((0x1d32  << 2) + 0xff620000)
// Bit[31:16] MB_NR
// Bit[15:8] MBY
// Bit[7:0] MBX
#define VLC_PIC_POSITION                           ((0x1d33  << 2) + 0xff620000)
// Bit[31] MV_busy
// Bit[30:6] Reserved
// Bit[15] Reserved
// Bit[14] vlc_input_MV_busy
// Bit[13] vlc_input_b8_mode_busy
// Bit[12] vlc_input_mb_skip_run_busy
// Bit[11] vlc_input_cbp_busy
// Bit[10] Reserved
// Bit[9]  Reserved
// Bit[8] vlc_input_mb_info_busy
// Bit[7] Reserved
// Bit[6] mvd
// Bit[5] b8_mode
// Bit[4] mb_skip_run
// Bit[3] cbp
// Bit[2] c_ipred_mode
// Bit[1] ipred_mode
// Bit[0] mb_info ( mb_type, mb_x, mb_y)
#define VLC_INPUT_STATUS                           ((0x1d34  << 2) + 0xff620000)
// Bit[31:28] detected_mb_type
// Bit[27:16] mb_y
// Bit[15:4]  mb_x
// Bit[3:0]   mb_type
#define VLC_MB_INFO                                ((0x1d35  << 2) + 0xff620000)
// command 0 -- no pending
// normal command + 1 is pending command
//
// bit 31:28 -- pending command 7
// bit 27:24 -- pending command 6
// bit 23:20 -- pending command 5
// bit 19:16 -- pending command 4
// bit 15:12 -- pending command 3
// bit 11:8  -- pending command 2
// bit  7:4  -- pending command 1
// bit  3:0  -- pending command 0
#define VLC_ENC_PEND_CMD                           ((0x1d36  << 2) + 0xff620000)
// For I Slice
// Bit[31:16] Reserved
// Bit[15:0] IntraType
#define HENC_TOP_INFO_0                            ((0x1d37  << 2) + 0xff620000)
#define HENC_LEFT_INFO_0                           ((0x1d38  << 2) + 0xff620000)
// For I Slice
// Bit[31:24] V_nnz
// Bit[23:16] U_nnz
// Bit[15:0]  Y_nnz
#define HENC_TOP_INFO_1                            ((0x1d39  << 2) + 0xff620000)
#define HENC_LEFT_INFO_1                           ((0x1d3a  << 2) + 0xff620000)
// bit[63:0] ipred_mode
#define VLC_IPRED_MODE_HI                          ((0x1d3b  << 2) + 0xff620000)
#define VLC_IPRED_MODE_LO                          ((0x1d3c  << 2) + 0xff620000)
// bit[15:8] SE delta quant
// bit[7:0]  UE delta quant
#define VLC_DELTA_QP                               ((0x1d3d  << 2) + 0xff620000)
// bit[31:16] Reserved
// bit[15:12] Reserved
// bit[11:8] c_ipred_mode
// bit[7:0] cbp
#define VLC_MB_HEADER_INFO                         ((0x1d3e  << 2) + 0xff620000)
// bit[31:16] mb_skip_run
// bit[15:0]  b8_mode
#define VLC_P_MB_HEADER_INFO                       ((0x1d3f  << 2) + 0xff620000)
// bit[31]    write_ptr_update
// bit[30]    read_ptr_update
// bit[29:20] coeff_buf_level
// bit[19:10] coeff_buf_write_ptr
// bit[9:0]   coeff_buf_read_ptr
#define VLC_COEFF_BUF_STATUS                       ((0x1d40  << 2) + 0xff620000)
// bit[31:10] Reserved
// bit[9:0] read_req_addr
#define VLC_COEFF_RD_REQ                           ((0x1d41  << 2) + 0xff620000)
// bit[20]   - coeff_buf_read_finished
// bit[19]   - coeff_first
// bit[18:4] - coeff_level
// bit[3:0]  - coeff_run
#define VLC_COEFF                                  ((0x1d42  << 2) + 0xff620000)
// bit[31]    - coeff_info_ready
// bit[30:25] - Reserved
// bit[24:15] - block_begin_addr
// bit[14:11] - trailing_one_sign
// bit[10:6]  - total_coeff
// bit[5:4]   - trailing_ones
// bit[3:0]   - total_zeros
#define VLC_COEFF_INFO                             ((0x1d43  << 2) + 0xff620000)
// bit[31]    write_ptr_update
// bit[30]    read_ptr_update
// bit[29:25] Reserved
// bit[24:20] dc_buf_level -- 0-16
// bit[19:15] Reserved
// bit[14:10] dc_buf_write_ptr
// bit[9:5]   Reserved
// bit[4:0]   dc_buf_read_ptr
#define VLC_DC_BUF_STATUS                          ((0x1d44  << 2) + 0xff620000)
// bit[31:10] Reserved
// bit[9:4]   Reserved
// bit[3:0]   read_req_addr
#define VLC_DC_RD_REQ                              ((0x1d45  << 2) + 0xff620000)
// bit[31:17] - Reserved
// bit[16]   - dc_first
// bit[15:1] - dc_level
// bit[0]    - dc_type  0 - CDC, 1 - LDC
#define VLC_DC                                     ((0x1d46  << 2) + 0xff620000)
// bit[31]    - dc_info_ready
// bit[30:25] - Reserved
// bit[24:20] - Reserved
// bit[19:15] - dc_idx_begin_addr
// bit[14:11] - dc_trailing_one_sign
// bit[10:6]  - dc_total_coeff
// bit[5:4]   - dc_trailing_ones
// bit[3:0]   - dc_total_zeros
#define VLC_DC_INFO                                ((0x1d47  << 2) + 0xff620000)
// bit[31:4]  - Reserved
// bit[3:0]   - mv_rw_idx  (auto increment when read/write VLC_MV)
#define VLC_MV_INDEX                               ((0x1d48  << 2) + 0xff620000)
// bit[31:16] - MVY
// bit[15:0]  - MVX
#define VLC_MV                                     ((0x1d49  << 2) + 0xff620000)
// bit[31:16] - MVY
// bitp15:0]  - MVX
// Write to HENC_TOP_MV_0 will cause previous U->UL, UR->U, and UR write
// Read will read U MV only
#define HENC_TOP_MV_0                              ((0x1d4a  << 2) + 0xff620000)
#define HENC_TOP_MV_1                              ((0x1d4b  << 2) + 0xff620000)
#define HENC_TOP_MV_2                              ((0x1d4c  << 2) + 0xff620000)
#define HENC_TOP_MV_3                              ((0x1d4d  << 2) + 0xff620000)
#define HENC_LEFT_MV_0                             ((0x1d4e  << 2) + 0xff620000)
#define HENC_LEFT_MV_1                             ((0x1d4f  << 2) + 0xff620000)
#define HENC_LEFT_MV_2                             ((0x1d50  << 2) + 0xff620000)
#define HENC_LEFT_MV_3                             ((0x1d51  << 2) + 0xff620000)
// Bit[31:1] Reserved
// Bit[0] top_left_mv_ready
#define TOP_LEFT_READY                             ((0x1d52  << 2) + 0xff620000)
// Bit[31:16] Reserved
// Bit[15:0] mb_skip_run
#define MB_SKIP_RUN                                ((0x1d53  << 2) + 0xff620000)
// Bit[31:16] Reserved
// Bit[15]    Reserved
// Bit[14:13] rd_struct // 00 - frame, 10 - top field, 11 - bottom field
// Bit[12:11] wr_struct // 00 - frame, 10 - top field, 11 - bottom field
// Bit[10:5]  mv_buff_id
// Bit[4:0]   mv_ref
#define VLC_HCMD_CONFIG                            ((0x1d54  << 2) + 0xff620000)
// Bit[9:0] h264_dblk_info
#define VLC_HCMD_DBLK_INFO                         ((0x1d55  << 2) + 0xff620000)
// Bit[3:0] vlc_dbg_idx
#define VLC_DBG_IDX                                ((0x1d56  << 2) + 0xff620000)
// Read Only
#define VLC_DBG_READ                               ((0x1d57  << 2) + 0xff620000)
// [   29] RW jpeg_comp2_ac_table_sel.                                                      Default 0.
// [   28] RW jpeg_comp2_dc_table_sel.                                                      Default 0.
// [26:25] RW jpeg_comp2_cnt_max.                                                           Default 0.
// [   24] RW jpeg_comp2_en. Set 1 if the scan will include component 2 (Cr).               Default 0.
// [   21] RW jpeg_comp1_ac_table_sel.                                                      Default 0.
// [   20] RW jpeg_comp1_dc_table_sel.                                                      Default 0.
// [18:17] RW jpeg_comp1_cnt_max.                                                           Default 0.
// [   16] RW jpeg_comp1_en. Set 1 if the scan will include component 1 (Cb).               Default 0.
// [   13] RW jpeg_comp0_ac_table_sel.                                                      Default 0.
// [   12] RW jpeg_comp0_dc_table_sel.                                                      Default 0.
// [10: 9] RW jpeg_comp0_cnt_max.                                                           Default 0.
// [    8] RW jpeg_comp0_en. Set 1 if the scan will include component 0 (Y).                Default 0.
// [    1] W  jpeg_coeff_init. Write 1 to this bit to initialize JPEG run length encoder.
// [    0] RW jpeg_en. 0=Disable JPEG encoder; 1=Enable JPEG encoder.                       Default 0.
#define VLC_JPEG_CTRL                              ((0x1d58  << 2) + 0xff620000)
// [   13] RW jpeg_coeff_buf_overfl. Write this bit to 1 to clear overfl.
// [   12] RW jpeg_coeff_buf_undrfl. Write this bit to 1 to clear undrfl.
// [   11] R  jpeg_coeff_buf_full.
// [   10] R  jpeg_coeff_buf_empty.
// [ 8: 0] R  jpeg_coeff_buf_level.
#define VLC_JPEG_COEFF_BUF_STAT                    ((0x1d59  << 2) + 0xff620000)
// [   16] RW JPEG HUFFMAN table access mode. 0=Write; 1=Read.  Default 1.
// [ 8: 0] RW JPEG HUFFMAN table addr.                          Default 0.
#define VLC_HUFFMAN_ADDR                           ((0x1d5a  << 2) + 0xff620000)
// [19: 0] RW JPEG HUFFMAN table data.
#define VLC_HUFFMAN_DATA                           ((0x1d5b  << 2) + 0xff620000)
// bit[31:0] enc_mv_bits - including b8_mode and mvd
#define VLC_ENC_MV_BITS                            ((0x1d5c  << 2) + 0xff620000)
// bit[31:0] enc_coeff_bits - including cbp, token, trailing_sign, coeff_enc, h264_totzeros, h264_run
#define VLC_ENC_COEFF_BITS                         ((0x1d5d  << 2) + 0xff620000)
//
// Closing file:  vlc_regs.h
//
//------------------------------------------------------------------------------
// QDCT module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  qdct_regs.h
//
//========================================================================
//  QDCT module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_HCODEC_QDCT_CBUS_BASE = 0x0f
// -----------------------------------------------
// bit[31:28] - mb_info_state
#define QDCT_STATUS_CTRL                           ((0x1f00  << 2) + 0xff620000)
// bit[18]    - enable_free_clk_sad_top
// bit[17]    - enable_free_clk_ie_top
// bit[16]    - enable_free_clk_ie_sub
// bit[15]    - enable_free_clk_mc_out
// bit[14]    - enable_free_clk_i_pred_top
// bit[13]    - enable_free_clk_idct_top
// bit[12]    - enable_free_clk_iq_top
// bit[11]    - enable_free_clk_q_top
// bit[10]    - enable_free_clk_dc_buff_8
// bit[9]     - enable_free_clk_dct_top
// bit[8]     - enable_free_clk_mb_info
// bit[7]     - enable_free_clk_mb_buff
// bit[6]     - enable_free_clk_reg
// bit[5]     - ignore_1_include_2nd_half_c
// bit[4]     - ignore_1_include_2nd_half
// bit[3]     - ignore_t_p8x8
// bit[2]     - not_ignore_dc
// bit[1]     - ignore_small_lac_intra
// bit[0]     - disable_fast_zero_block
#define QDCT_CONFIG                                ((0x1f01  << 2) + 0xff620000)
// bit[31]    - ignore_lac_coeff_en
// bit[30:26] - ignore_lac_coeff_else
// bit[25:21] - ignore_lac_coeff_2
// bit[20:16] - ignore_lac_coeff_1
// bit[15]    - ignore_cac_coeff_en
// bit[14:10] - ignore_cac_coeff_else
// bit[9:5]   - ignore_cac_coeff_2
// bit[4:0]   - ignore_cac_coeff_1
#define IGNORE_CONFIG                              ((0x1f02  << 2) + 0xff620000)
// bit[31]    - ignore_t_lac_coeff_en
// bit[30:26] - ignore_t_lac_coeff_else
// bit[25:21] - ignore_t_lac_coeff_2
// bit[20:16] - ignore_t_lac_coeff_1
// bit[15]    - ignore_cdc_coeff_en
// bit[14]    - ignore_t_lac_coeff_else_le_3
// bit[13]    - ignore_t_lac_coeff_else_le_4
// bit[12]    - ignore_cdc_only_when_empty_cac_inter
// bit[11]    - ignore_cdc_only_when_one_empty_inter
// bit[10:9]  - ignore_cdc_range_max_inter // 0-0, 1-1, 2,-2, 3-3
// bit[8:7]   - ignore_cdc_abs_max_inter // 0-1, 1-2, 2,-3, 3-4
// bit[6]     - reserved
// bit[5]     - ignore_cdc_only_when_empty_cac_intra
// bit[4]     - ignore_cdc_only_when_one_empty_intra
// bit[3:2]   - ignore_cdc_range_max_intra // 0-0, 1-1, 2,-2, 3-3
// bit[1:0]   - ignore_cdc_abs_max_intra // 0-1, 1-2, 2,-3, 3-4
#define IGNORE_CONFIG_2                            ((0x1f03  << 2) + 0xff620000)
// --------------------------------------------
// MB DATA DDR Interface
// --------------------------------------------
#define QDCT_MB_START_PTR                          ((0x1f10  << 2) + 0xff620000)
#define QDCT_MB_END_PTR                            ((0x1f11  << 2) + 0xff620000)
#define QDCT_MB_WR_PTR                             ((0x1f12  << 2) + 0xff620000)
#define QDCT_MB_RD_PTR                             ((0x1f13  << 2) + 0xff620000)
#define QDCT_MB_LEVEL                              ((0x1f14  << 2) + 0xff620000)
// bit  [31]    disable_mbxy_ie_save
// bit  [30]    no_wait_after_q_cdc
// bit  [29]    ie_start_int_enable
// bit  [28]    ignore_t_p8x8
// bit  [27]    zero_mc_out_null_non_skipped_mb
// bit  [26]    no_mc_out_null_non_skipped_mb
// bit  [25]    mc_out_even_skipped_mb
// bit  [24]    mc_out_wait_cbp_ready
// bit  [23]    mc_out_wait_mb_type_ready
// bit  [22]    i_pred_int_enable
// bit  [21]    intra_sat8_enable
// bit  [20]    ie_sub_enable
// bit  [19]    i_pred_enable
// bit  [18]    iq_enable
// bit  [17]    idct_enable
// bit  [16]    no_zero_coeff_mb
// bit  [15]    add_zero_coeff_block
// bit  [14]    mb_pause_enable
// bit  [13]    q_enable
// bit  [12]    dct_enable
// bit  [11]    ignore_magic_word
// bit  [10]    mb_info_en
// bit  [9]     mb_info_soft_reset
// bit  [8]     mb_always_ready Set to 1 to ignore mb_level blocking DDR read
// bit  [7]     mb_ready_for_transfer (Read Only)
// bit  [6]     data_ready_for_transfer (Read Only)
// bits [5:3]   mb_endian       Set MB Endian inside DDR memory
// bit  [2]     mb_read_busy   Read Only - indicate DDR read busy
// bit  [1]     mb_read_en     Set to 1 to enable reading data from DDR memory
// bit  [0]     mb_soft_reset   Soft reset
#define QDCT_MB_CONTROL                            ((0x1f15  << 2) + 0xff620000)
// bit 31    transfer_length 0 - 32x64 Bits per request, 1 - 16x64 Bits per request  // default : 0
// bit 30    A_urgent  // default : 0
// bit 29:24 A_brst_num // default : 0x3f
// bit 23    reserved
// bit 22    read_till_zero
// bit 21:16 A_id  // default : 0x21
// bit 15:0  mb_level_hold // default : 0
#define QDCT_MB_MEM_CTL                            ((0x1f16  << 2) + 0xff620000)
// bit  [31:24] reserved
// bit  [23:16] vb_buff_level     -- Read only
// bit  [15:8]  vb_buff_wr_point -- RW
// bit  [7:0]   vb_buff_rd_point -- RW
#define QDCT_MB_BUFF                               ((0x1f17  << 2) + 0xff620000)
// bit [31:0] mb infor data begin magic word - default : 0xa55aaa55
#define QDCT_MB_MAGIC_WORD                         ((0x1f18  << 2) + 0xff620000)
// Read Only Register
// bit[19]   dct_ready_1
// bit[18]   dct_ready_0
// bit[17]   dct_rd_idx
// bit[16]   dct_wr_idx
// bit[15]   dct_srdy
// bit[14]   dct_rrdy
// bit[13]   Reserved
// bit[12:8] dct_block_number
// bit[7:4]  dct_rw_addr
// bit[3:0]  dct_status
#define QDCT_DCT_STATUS                            ((0x1f19  << 2) + 0xff620000)
// bit[24:23]  vlc_quant_count
// bit[22:16]  vlc_delta_quant_data
// bit[15:10]  vlc_quant_data
// bit[9:4]    vlc_prev_quant_data
// bit[3:0]    q_status
#define QDCT_Q_STATUS                              ((0x1f1a  << 2) + 0xff620000)
// bit[31:3] Reserved
// bit[2:0]  picture_type
#define QDCT_PIC_INFO                              ((0x1f1b  << 2) + 0xff620000)
// bit[31:28] Reserved
// bit[27:22] I_pic_quant_c
// bit[21:16] I_pic_quant
// bit[15]    reserved
// bit[14:12] quant_rem_c
// bit[11:8]  quant_per_c
// bit[7]     reserved
// bit[6:4]   quant_rem
// bit[3:0]   quant_per
#define QDCT_Q_QUANT_I                             ((0x1f1c  << 2) + 0xff620000)
// bit[31:28] Reserved
// bit[27:22] P_pic_quant_c
// bit[21:16] P_pic_quant
// bit[15]    reserved
// bit[14:12] quant_rem_c
// bit[11:8]  quant_per_c
// bit[7]     reserved
// bit[6:4]   quant_rem
// bit[3:0]   quant_per
#define QDCT_Q_QUANT_P                             ((0x1f1d  << 2) + 0xff620000)
// bit[31]    mb_info_pause
// bit[30:16] pause_mby
// bit[15:0]  pause_mbx
#define QDCT_MB_PAUSE_CTL                          ((0x1f1e  << 2) + 0xff620000)
// bit[31]   top_control_ready_i_pred
// bit[30:28]top_dma_status
// bit[27]   top_control_ready_ie
// bit[26:24]Reserved
// bit[23]   ul_mb
// bit[22]   right_mb
// bit[21]   top_mb
// bit[20]   left_mb
// bit[19:8] mb_x
// bit[7:6]  i_pred_ref_idx_L
// bit[5:4]  i_pred_ref_idx_UL
// bit[3:2]  i_pred_ref_idx_U
// bit[1:0]  i_pred_ref_idx_UR
#define QDCT_TOP_CONTROL                           ((0x1f1f  << 2) + 0xff620000)
// bit[31:0] top_base_addr - DDR Memory start address for save top Pixel
#define QDCT_TOP_BASE_MEM                          ((0x1f20  << 2) + 0xff620000)
// bit 15:13 Reserved
// bit 12    A_urgent  // default : 0
// bit 11:6  A_brst_num // default : 0x3f
// bit 5:0   A_id  // default : 0x22
#define QDCT_TOP_MEM_CTL                           ((0x1f21  << 2) + 0xff620000)
// bit [11:0] top_wrrsp_count
#define QDCT_TOP_WRRSP                             ((0x1f22  << 2) + 0xff620000)
// Bit[3:0] qdct_dbg_idx
#define QDCT_DBG_IDX                               ((0x1f23  << 2) + 0xff620000)
// Read Only
#define QDCT_DBG_READ                              ((0x1f24  << 2) + 0xff620000)
// [19:18] RW jdct_inflow_ctrl. JPEG DCT input flow control.                                Default 0.
//            0=No halt;
//            1=DCT halts request at end of each 8x8 block;
//            2=DCT halts request at end of each MCU.
// [17:16] RW jpeg_coeff_last_sel.                                                          Default 0.
//            Select at which point to finish processing, give update to AmRISC so it can control the next step.
//            0=Mark last coeff at the end of an 8x8 block;
//            1=Mark at the end of an MCU;
//            2=Mark at the end of a scan.
// [   15] RW jpeg_quant_sel_comp2. 0=Comp2 select Quantization table 0; 1=Select table 1.  Default 0.
// [   14] RW jpeg_v_factor_comp2. Component 2's vertical sampling factor.                  Default 0.
// [   13] RW jpeg_h_factor_comp2. Component 2's horizontal sampling factor.                Default 0.
// [   12] RW jpeg_comp2_en. Set 1 if the scan will include component 2 (Cr).               Default 0.
// [   11] RW jpeg_quant_sel_comp1. 0=Comp1 select Quantization table 0; 1=Select table 1.  Default 0.
// [   10] RW jpeg_v_factor_comp1. Component 1's vertical sampling factor.                  Default 0.
// [    9] RW jpeg_h_factor_comp1. Component 1's horizontal sampling factor.                Default 0.
// [    8] RW jpeg_comp1_en. Set 1 if the scan will include component 1 (Cb).               Default 0.
// [    7] RW jpeg_quant_sel_comp0. 0=Comp0 select Quantization table 0; 1=Select table 1.  Default 0.
// [    6] RW jpeg_v_factor_comp0. Component 0's vertical sampling factor.                  Default 0.
// [    5] RW jpeg_h_factor_comp0. Component 0's horizontal sampling factor.                Default 0.
// [    4] RW jpeg_comp0_en. Set 1 if the scan will include component 0 (Y).                Default 0.
// [ 3: 1] RW jdct_intr_sel. JPEG DCT interrupt select.                                     Default 0.
//            0=Disable intr;
//            1=Intr at end of each 8x8 block of DCT input;
//            2=Intr at end of each MCU of DCT input;
//            3=Intr at end of a scan of DCT input;
//            4=Intr at end of each 8x8 block of DCT output;
//            5=Intr at end of each MCU of DCT output;
//            6=Intr at end of a scan of DCT output.
// [    0] RW jpeg_en. 0=Disable JPEG QDCT; 1=Enable JPEG QDCT.                             Default 0.
#define QDCT_JPEG_CTRL                             ((0x1f25  << 2) + 0xff620000)
// [29:16] RW jpeg_x_end.   Picture X end.      Default 0.
// [13: 0] RW jpeg_x_start. Picture X start.    Default 0.
#define QDCT_JPEG_X_START_END                      ((0x1f26  << 2) + 0xff620000)
// [29:16] RW jpeg_y_end.   Picture Y end.      Default 0.
// [13: 0] RW jpeg_y_start. Picture Y start.    Default 0.
#define QDCT_JPEG_Y_START_END                      ((0x1f27  << 2) + 0xff620000)
// [    8] RW JPEG QUANT table access mode. 0=Write; 1=Read.    Default 1.
// [ 5: 0] RW JPEG QUANT table addr.                            Default 0.
#define QDCT_JPEG_QUANT_ADDR                       ((0x1f28  << 2) + 0xff620000)
// [31: 0] RW JPEG QUANT table data.
#define QDCT_JPEG_QUANT_DATA                       ((0x1f29  << 2) + 0xff620000)
// [    1] W  resume_jdct.
//            Write 1 to this bit will resume JPEG input engine when previously
//            it is halted by QDCT_JPEG_CTRL.jdct_inflow_ctrl.
// [    0] W  jpeg_sof.
//            Write 1 to this bit will start JPEG input engine.
#define QDCT_JPEG_SOF_RESUME                       ((0x1f2a  << 2) + 0xff620000)
// [31:30] R  dct_st.       jdct_ctrl state. 0=IDLE; 1=WAIT; 2=DCT_REQ.
// [29:28] R  mfdin_comp.   Current component at pixel request to MFDIN.
// [27:14] R  mfdin_y.      Current Y at pixel request to MFDIN.
// [13: 0] R  mfdin_x.      Current X at pixel request to MFDIN.
#define QDCT_JPEG_DCT_STATUS0                      ((0x1f2b  << 2) + 0xff620000)
// [15:12] R  JPEG Quant read MEM select.
// [11: 8] R  JPEG DCT2 write MEM select.
// [ 7: 4] R  JPEG DCT2 read MEM select.
// [ 3: 0] R  JPEG DCT1 write MEM select.
#define QDCT_JPEG_DCT_STATUS1                      ((0x1f2c  << 2) + 0xff620000)
// [28:16] RW jdct_coeff1.  Default 13'h1D90; // 7568 = 4096 * sqrt(2) * (cos(Pi/8) + sin(Pi/8)) // 7569
// [12: 0] RW jdct_coeff0.  Default 13'h16A1; // 5793 = 4096 * sqrt(2)
#define QDCT_JPEG_DCT_COEFF01                      ((0x1f2d  << 2) + 0xff620000)
// [28:16] RW jdct_coeff3.  Default 13'h0C3F; // 3135 = 4096 * sqrt(2) * (cos(Pi/8) - sin(Pi/8))
// [12: 0] RW jdct_coeff2.  Default 13'h08A9; // 2217 = 4096 * sqrt(2) * sin(Pi/8) // 2215
#define QDCT_JPEG_DCT_COEFF23                      ((0x1f2e  << 2) + 0xff620000)
// [28:16] RW jdct_coeff5.  Default 13'h046A; // 1130 = 4096 * (cos(3Pi/16) - sin(3Pi/16))
// [12: 0] RW jdct_coeff4.  Default 13'h1631; // 5681 = 4096 * (cos(3Pi/16) + sin(3Pi/16)) // 5682
#define QDCT_JPEG_DCT_COEFF45                      ((0x1f2f  << 2) + 0xff620000)
// [28:16] RW jdct_coeff7.  Default 13'h0C92; // 3218 = 4096 * (cos(Pi/16) - sin(Pi/16))
// [12: 0] RW jdct_coeff6.  Default 13'h12D0; // 4816 = 4096 * (cos(Pi/16) + sin(Pi/16))
#define QDCT_JPEG_DCT_COEFF67                      ((0x1f30  << 2) + 0xff620000)
// [28:16] RW jdct_coeff9.  Default 13'h0FB1; // 4017 = 4096 * cos(Pi/16)
// [12: 0] RW jdct_coeff8.  Default 13'h0D4E; // 3406 = 4096 * cos(3Pi/16)
#define QDCT_JPEG_DCT_COEFF89                      ((0x1f31  << 2) + 0xff620000)
#define QDCT_I_PRED_REF_WR_IDX                     ((0x1f32  << 2) + 0xff620000)
#define QDCT_I_PRED_REF_WR_DATA                    ((0x1f33  << 2) + 0xff620000)
// bit[29]  mb_info_latch_no_I16_pred_mode
// bit[28]  ie_dma_mbxy_use_i_pred
// bit[27]  ie_dma_read_write_use_ip_idx
// bit[26]  ie_start_use_top_dma_count
// bit[25]  i_pred_top_dma_rd_mbbot
// bit[24]  i_pred_top_dma_wr_disable
// bit[23]  i_pred_mix
// bit[22]  me_ab_rd_when_intra_in_p
// bit[21]  force_mb_skip_run_when_intra
// bit[20]  mc_out_mixed_type
// bit[19]  ie_start_when_quant_not_full
// bit[18]  mb_info_state_mix
// bit[17]  mb_type_use_mix_result
// bit[16]  me_cb_ie_read_enable
// bit[15]  ie_cur_data_from_me
// bit[14]  rem_per_use_table
// bit[13]  q_latch_int_enable
// bit[12]  q_use_table
// bit[11]  q_start_wait
// bit[10]  LUMA_16_LEFT_use_cur
// bit[9]   DC_16_LEFT_SUM_use_cur
// bit[8]   c_ref_ie_sel_cur
// bit[7]   c_ipred_perfect_mode
// bit[6]   ref_ie_ul_sel 0-old, 1-use next_set
// bit[5]   mb_type_use_ie_result
// bit[4]   detect_I16_from_I4
// bit[3]   ie_not_wait_ref_busy
// bit[2]   ie_I16_enable
// bit[1:0] ie_done_sel (0, 1, 2, -1)
#define QDCT_ADV_CONFIG                            ((0x1f34  << 2) + 0xff620000)
// bit [31:16] I16x16_weight
// bit [15:0]  I4x4_weight
#define IE_WEIGHT                                  ((0x1f35  << 2) + 0xff620000)
// bit [31]  reserved
// bit [30] q_I16MB
// bit [29]  reserved
// bit [28]  reserved
// bit [27:23] quant_table_addr I4MB:[0,7], I16MB:[8:15], INTER:[16:23], Reserved:[24:31]
// bit [22]    quant_table_addr_update(when notupdate_rem_per) (read is arb_result : q_intra)
// bit [21:19] quant_rem_c
// bit [18:16] quant_rem_y
// bit [15:12] quant_per_c
// bit [11:8]  quant_per_y
// bit [7:2] quant
// bit [1] update_rem_per
// bit [0] clear_wait_status
#define Q_QUANT_CONTROL                            ((0x1f36  << 2) + 0xff620000)
#define MBBOT_EVEN_ADDR                            ((0x1f37  << 2) + 0xff620000)
#define MBBOT_ODD_ADDR                             ((0x1f38  << 2) + 0xff620000)
// bit [29:24] quant_table_data_3
// bit [21:16] quant_table_data_2
// bit [13:8]  quant_table_data_1
// bit [5:0]   quant_table_data_0
#define QUANT_TABLE_DATA                           ((0x1f39  << 2) + 0xff620000)
// bit [31:16] ie_sad_offset_I16
// bit [15:0] ie_sad_offset_I4
#define SAD_CONTROL_0                              ((0x1f3a  << 2) + 0xff620000)
// bit [31]     sad_soft_reset
// bit [30:27]  reserved
// bit [26:24]  ie_sad_shift_I16
// bit [22:20]  ie_sad_shift_I4
// bit [18:16]  me_sad_shift_INTER
// bit [15:0]   me_sad_offset_INTER
#define SAD_CONTROL_1                              ((0x1f3b  << 2) + 0xff620000)
// bit [31]     vlc_quant_rd_ptr
// bit [30]     vlc_quant_rd_ptr_update
// bit [29]     vlc_quant_wr_ptr
// bit [28]     vlc_quant_wr_ptr_update
// bit [27:26]  reserved
// bit [25:19]  vlc_delta_quant_1
// bit [18:13]  vlc_quant_1
// bit [12:6]   vlc_delta_quant_0
// bit [5:0]    vlc_quant_0
#define QDCT_VLC_QUANT_CTL_0                       ((0x1f3c  << 2) + 0xff620000)
// bit [31:30]  me_sad_rd_idx
// bit [29]     me_sad_rd_idx_update
// bit [28:27]  me_sad_wr_idx
// bit [26]     me_sad_wr_idx_update
// bit [25:24]  ie_sad_rd_idx
// bit [23]     ie_sad_rd_idx_update
// bit [22:21]  ie_sad_wr_idx
// bit [20]     ie_sad_wr_idx_update
// bit [19:12]  Reserved
// bit [11:6]   vlc_max_delta_q_neg
// bit [5:0]    vlc_max_delta_q_pos
#define QDCT_VLC_QUANT_CTL_1                       ((0x1f3d  << 2) + 0xff620000)
// bit[4] jdct_int
// bit[3] quant_latch
// bit[2] me_done
// bit[1] ie_start
// bit[0] i_pred_start
#define QDCT_INT_STATUS                            ((0x1f3e  << 2) + 0xff620000)
// bit[3]   mix_i_pred_wait_left_en
// bit[2:0] mc_pending_mb_count
#define QDCT_MIX_I_PRED_STATUS                     ((0x1f3f  << 2) + 0xff620000)
// IE/ME share same cbus_base as QDCT
//
// bit[31]  active_ur_block
// bit[30]  active_ul_block
// bit[21]  disable_HENC_V_PRED_16
// bit[20]  disable_HENC_H_PRED_16
// bit[19]  disable_HENC_DC_PRED_16
// bit[18]  disable_HENC_HENC_HOR_UP_PRED
// bit[17]  disable_HENC_VERT_LEFT_PRED
// bit[16]  disable_HENC_HENC_HOR_DOWN_PRED
// bit[15]  disable_HENC_VERT_RIGHT_PRED
// bit[14]  disable_HENC_DIAG_DOWN_RIGHT_PRED
// bit[13]  disable_HENC_DIAG_DOWN_LEFT_PRED
// bit[12]  disable_HENC_DC_PRED
// bit[11]  disable_HENC_HOR_PRED
// bit[10]  disable_HENC_VERT_PRED
// bit[9]   ie_c_wait_ie_pause
// bit[8:4] max_ie_result_buff_count
// bit[3]   ie_wait_for_ie_result  // use for (max_ie_result_buff_count == 0) to wait every block
// bit[2]   reserved
// bit[1]   ie_enable
// bit[0]   ie_soft_reset
#define IE_CONTROL                                 ((0x1f40  << 2) + 0xff620000)
// bit[31:12] Reserved
// bit[11:0]  mb_y
#define IE_MB_POSITION                             ((0x1f41  << 2) + 0xff620000)
// bit[31:16] me_skip_run
// bit[15:8]  reserved
// bit [7:4]  me_b8_mode
// bit [3:0]  ie_me_mb_type
#define IE_ME_MB_INFO                              ((0x1f42  << 2) + 0xff620000)
// bit[3]   ie_result_buff_enable
// bit[2]   ie_result_buff_soft_reset
// bit[1]   sad_enable
// bit[0]   ie_sad_soft_reset
#define SAD_CONTROL                                ((0x1f43  << 2) + 0xff620000)
// bit[31:16] - ie_result_buff_count - read only
// bit[14:12] -current_ie_result (pred_mode) - read only
// bit[11]  top_control_data_buff_wr_ptr - rd/wr
// bit[10]  top_control_data_buff_rd_ptr - rd/wr
// bit[9:5] ie_result_buff_wr_ptr        - rd/wr
// bit[4:0] ie_result_buff_rd_ptr        - rd/wr
#define IE_RESULT_BUFFER                           ((0x1f44  << 2) + 0xff620000)
// bit[63:0] ie_i4_pred_mode
#define IE_I4_PRED_MODE_HI                         ((0x1f45  << 2) + 0xff620000)
#define IE_I4_PRED_MODE_LO                         ((0x1f46  << 2) + 0xff620000)
// bit [31:9] reserved
// bit [8:4] i_pred_block_number
// bit [3:0] ie_c_pred_mode
#define IE_C_PRED_MODE                             ((0x1f47  << 2) + 0xff620000)
// 31:16 - Left, 0-select ie_pixel, 1-select mc_data_out
// 15:0  - Top,  0-select ie_pixel, 1-select mc_data_out
#define IE_CUR_REF_SEL                             ((0x1f48  << 2) + 0xff620000)
// bit[31]  enable_f_skip_1_step_3
// bit[30]  enable_f_skip_1_step_2
// bit[29]  enable_f_skip_1_step_1
// bit[28]  step_3_enable
// bit[27]  step_2_sub_pixel
// bit[26]  always_f_skip_step_3
// bit[25]  always_f_skip_step_2
// bit[24]  always_f_skip_step_1
// bit[23]  half_pixel_only
// bit[22:13] reserved
// bit[12]  adv_mv_enable
// bit[11]  sad_short_valid
// bit[10:9] mv_flexable_ctl 00:0x40, 01:0x80, 10:0xc0, 11 : 0x100
// bit[8]   no_md_ab_rd
// bit[7]   use_dct_state
// bit[6]   enable_free_clk_me_ctl
// bit[5]   enable_free_clk_me_ab
// bit[4]   enable_free_clk_me_cb
// bit[3]   reserved
// bit[2]   me_done_int_enable
// bit[1]   me_enable
// bit[0]   me_soft_reset
#define ME_CONTROL                                 ((0x1f49  << 2) + 0xff620000)
// bit[31:28] Reserved
// bit[27:16] me_start_mby
// bit[15:12] Reserved
// bit[11:0]  me_start_mbx
#define ME_START_POSITION                          ((0x1f4a  << 2) + 0xff620000)
// bit [31:28] me_status - Read only
// bit [27:24] me_cb_status  // current buffer
// bit [23:20] me_ab_status  // anc buffer
// bit [19]    Reserved
// bit [18:16] me_ab_wr_ptr  // read only
// bit [15:4]  me_last_mbx
// bit [3:1]   me_ab_rd_ptr  // read only
// bit [0]     me_action
#define ME_STATUS                                  ((0x1f4b  << 2) + 0xff620000)
// all Read-only
// bit [31:28] Reserved
// bit [27:16] me_ab_mbx
// bit [15:14] me_cb_wr_ptr
// bit [13:12] me_cb_rd_ptr
// bit [11:0]  me_cb_mbx
#define ME_DEBUG                                   ((0x1f4c  << 2) + 0xff620000)
// bit[29:24] step_3_skip_line
// bit[23:18] step_2_skip_line
// bit[17:12] step_1_skip_line
// bit[11:6]  step_0_skip_line
// bit[5:0]   read_skip_line
#define ME_SKIP_LINE                               ((0x1f4d  << 2) + 0xff620000)
// bit 15:13 Reserved
// bit 12    A_urgent  // default : 0
// bit 11:6  A_brst_num // default : 0x3f
// bit 5:0   A_id  // default : 0x23
#define ME_AB_MEM_CTL                              ((0x1f4e  << 2) + 0xff620000)
// bit[31:24] anc_pic_canvas
// bit[23:12] max_me_mby_num
// bit[11:0]  max_me_mbx_num
#define ME_PIC_INFO                                ((0x1f4f  << 2) + 0xff620000)
// bit [23:12] me_sad_enough_1
// bit [11:0]  me_sad_enough_0
#define ME_SAD_ENOUGH_01                           ((0x1f50  << 2) + 0xff620000)
// bit [25:12] adv_mv_8x8_enough
// bit [11:0]  me_sad_enough_2
#define ME_SAD_ENOUGH_23                           ((0x1f51  << 2) + 0xff620000)
// bit [21:10] me_step0_big_sad
// bit [9:5] me_step0_close_mv_y
// bit [4:0] me_step0_close_mv_x
#define ME_STEP0_CLOSE_MV                          ((0x1f52  << 2) + 0xff620000)
// bit[31:24] force_skip_sad_3
// bit[23:16] force_skip_sad_2
// bit[15:08] force_skip_sad_1
// bit[07:00] force_skip_sad_0
#define ME_F_SKIP_SAD                              ((0x1f53  << 2) + 0xff620000)
// bit[31:24] force_skip_weight_3
// bit[23:16] force_skip_weight_2
// bit[15:08] force_skip_weight_1
// bit[07:00] force_skip_weight_0
#define ME_F_SKIP_WEIGHT                           ((0x1f54  << 2) + 0xff620000)
// Merge when (
//              (flex & me_merge_flex_en) |
//              (big_sad & me_merge_sad_en)|
//              ((~me_merge_flex_en)&(~me_merge_sad_en))
//            ) &
//            ( small_mv_diff |(~me_merge_small_mv_en))
//            & (me_merge_flex_en | me_merge_sad_en | me_merge_small_mv_en)
// bit[31]   me_merge_mv_en_16
// bit[30]   me_merge_small_mv_en_16
// bit[29]   me_merge_flex_en_16
// bit[28]   me_merge_sad_en_16
// bit[27]   me_merge_mv_en_8
// bit[26]   me_merge_small_mv_en_8
// bit[25]   me_merge_flex_en_8
// bit[24]   me_merge_sad_en_8
// bit[23:18] me_merge_mv_diff_16
// bit[17:12] me_merge_mv_diff_8
// bit[11:0] me_merge_min_sad
#define ME_MV_MERGE_CTL                            ((0x1f55  << 2) + 0xff620000)
// bit[31:24] mv_step_weight_1
// bit[23:16] mv_pre_weight_1
// bit [15:0] mv_step_weight_0
// bit[7:0]   mv_pre_weight_0
#define ME_MV_WEIGHT_01                            ((0x1f56  << 2) + 0xff620000)
// bit[31:24] mv_step_weight_3 (mv_step_weight_1_2nd)
// bit[23:16] mv_pre_weight_3 (mv_pre_weight_1_2nd)
// bit[15:8]  mv_step_weight_2
// bit[7:0]   mv_pre_weight_2
#define ME_MV_WEIGHT_23                            ((0x1f57  << 2) + 0xff620000)
// bit[31:24] me_sad_range_inc_3
// bit[23:16] me_sad_range_inc_2
// bit[15:8] me_sad_range_inc_1
// bit[7:0] me_sad_range_inc_0
#define ME_SAD_RANGE_INC                           ((0x1f58  << 2) + 0xff620000)
// bit[31:19]  reserved
// bit[18]     sub_relative_any_1_en
// bit[17]     sub_relative_any_2_en
// bit[16]     sub_relative_any_3_en
// bit[15]     sub_relative_any_4_en
// bit[14]     sub_relative_any_h_en
// bit[13]     sub_make_non_flex_fix
// bit[12]     sub_make_big_non_flex_fix
// bit[11:8]   sub_normal_mv_diff_16
// bit[7:4]    sub_normal_mv_diff_8
// bit[3:2]    Reserved
// bit[1]      sub_merge_enable_16
// bit[0]      sub_merge_enable_8
#define ME_SUB_MERGE_CTL                           ((0x1f59  << 2) + 0xff620000)
// bit[31:28]  sub_ref_mv_diff_near
// bit[27:24]  sub_ref_mv_diff_near_flex
// bit[23:20]  sub_ref_mv_diff
// bit[19:16]  sub_ref_mv_diff_flex
// bit[15:8]   sub_ref_mv_near_weight
// bit[7:0]    sub_ref_mv_weight
#define ME_SUB_REF_MV_CTL                          ((0x1f5a  << 2) + 0xff620000)
// bit[31:24]  sub_weight_max_sad
// bit[23:16]  sub_any_range_sad
// bit[15:8]   sub_any_min_sad
// bit[7:0]    sub_any_max_sad
#define ME_SUB_ANY_WEIGHT_SAD                      ((0x1f5b  << 2) + 0xff620000)
// bit[31:24]  sub_fix_sad
// bit[23:16]  sub_fix_diff_sad
// bit[15:8]   sub_sad_flex_adj
// bit[7:0]    sub_big_non_flex_fix_sad
#define ME_SUB_FIX_SAD                             ((0x1f5c  << 2) + 0xff620000)
// bit[31:24]  sub_fix_min_sad
// bit[23:16]  sub_fix_min_diff_sad
// bit[15:8]   sub_fix_min_sad_2
// bit[7:0]    sub_fix_min_diff_sad_2
#define ME_SUB_FIX_MIN_SAD                         ((0x1f5d  << 2) + 0xff620000)
// bit[31:24]  sub_snap_to_ref_max_sad
// bit[23]     sub_snap_to_ref_non_flex
// bit[22:16]  sub_snap_to_ref_mv_diff
// bit[15:4]   sub_glitch_mv_sad
// bit[3:0]    sub_glitch_mv_diff
#define ME_SUB_SNAP_GLITCH                         ((0x1f5e  << 2) + 0xff620000)
// bit[31:20]  sad_act_limit
// bit[19:8]   s_a_any_sad
// bit[7]      Reserved
// bit[6:5]    sub_merge_method
// bit[4]      use_sub_act_result
// bit[3]      s_a_rnd
// bit[2]      Reserved
// bit[1]      sub_act_en_16
// bit[0]      sub_act_en
#define ME_SUB_ACT_CTL                             ((0x1f5f  << 2) + 0xff620000)
// bit[31:16]  reserved
// bit[15:0]   me_weight
#define ME_WEIGHT                                  ((0x1f60  << 2) + 0xff620000)
// bit[31]  ready_update
// bit[30]  data_update
// bit[29:28] reserved
// bit[27:22] me_quant_0
// bit[21]  ie_sad_ready_0
// bit[20:18]  Reserved
// bit[17:16]  me_sad_mv_type_0
// bit[15:0] me_sad_0
#define ME_SAD_0                                   ((0x1f61  << 2) + 0xff620000)
// bit[31]  ready_update
// bit[30]  data_update
// bit[29:28] reserved
// bit[27:22] me_quant_1
// bit[21]  me_sad_ready_1
// bit[20:18]  Reserved
// bit[17:16]  me_sad_mv_type_1
// bit[15:0] me_sad_1
#define ME_SAD_1                                   ((0x1f62  << 2) + 0xff620000)
// bit[31]  ready_update
// bit[30]  data_update
// bit[29:28] reserved
// bit[27:22] me_quant_2
// bit[21]  me_sad_ready_2
// bit[20:18]  Reserved
// bit[17:16]  me_sad_mv_type_2
// bit[15:0] me_sad_2
#define ME_SAD_2                                   ((0x1f63  << 2) + 0xff620000)
// bit[31]  ready_update
// bit[30]  data_update
// bit[29:28] reserved
// bit[27:22] me_quant_3
// bit[21]  me_sad_ready_3
// bit[20:18]  Reserved
// bit[17:16]  me_sad_mv_type_3
// bit[15:0] me_sad_3
#define ME_SAD_3                                   ((0x1f64  << 2) + 0xff620000)
// bit[31]  ready_update
// bit[30]  data_update
// bit[29:28] reserved
// bit[27:22] ie_quant_0
// bit[21]  ie_sad_ready_0
// bit[20]   I4/I16 (0-I4MB, 1-I16MB)
// bit[19:0] ie_sad_0
#define IE_SAD_0                                   ((0x1f65  << 2) + 0xff620000)
// bit[31]  ready_update
// bit[30]  data_update
// bit[29:28] reserved
// bit[27:22] ie_quant_1
// bit[21]  ie_sad_ready_1
// bit[20]   I4/I16 (0-I4MB, 1-I16MB)
// bit[19:0] ie_sad_1
#define IE_SAD_1                                   ((0x1f66  << 2) + 0xff620000)
// bit[31]  ready_update
// bit[30]  data_update
// bit[29:28] reserved
// bit[27:22] ie_quant_2
// bit[21]  ie_sad_ready_2
// bit[20]   I4/I16 (0-I4MB, 1-I16MB)
// bit[19:0] ie_sad_2
#define IE_SAD_2                                   ((0x1f67  << 2) + 0xff620000)
// bit[31]  ready_update
// bit[30]  data_update
// bit[29:28] reserved
// bit[27:22] ie_quant_3
// bit[21]  ie_sad_ready_3
// bit[20]   I4/I16 (0-I4MB, 1-I16MB)
// bit[19:0] ie_sad_3
#define IE_SAD_3                                   ((0x1f68  << 2) + 0xff620000)
// bit[31]   enable_large_diff_16x8
// bit[30]   enable_large_diff_8x16
// bit[29:16] adv_mv_8x8_weight
// bit[15:14] reserved
// bit[13:0] adv_mv_4x4x4_weight
#define ADV_MV_CTL0                                ((0x1f69  << 2) + 0xff620000)
// bit[31:16] adv_mv_16x16_weight
// bit[15]   enable_large_diff_16x16
// bit[14:0] adv_mv_16_8_weight
#define ADV_MV_CTL1                                ((0x1f6a  << 2) + 0xff620000)
#define ADV_MV_CTL2                                ((0x1f6b  << 2) + 0xff620000)
// bit[31]    v3_skip_enable
// bit[30]    v3_step_1_weight_enable // for step1, will only use pre_weight for block0, only step_weight for block 1,2,3
// bit[29]    v3_l2_skip_only_use_l2_sad // set to 1 may allow l1 maybe not skip
// bit[28]    v3_mv_sad_weight_enable
// bit[27]    v3_ipred_type_enable
// bit[25:12] force_skip_sad_1
// bit[11:0]  force_skip_sad_0
#define V3_SKIP_CONTROL                            ((0x1f6c  << 2) + 0xff620000)
// bit[18:16] top_ipred_type_count
// bit[15:14] Reserved
// bit[13:12] top_ipred_type_rd_idx
// bit[11:10] top_ipred_type_wr_idx
// bit[9]   left_ipred_type_ready
// bit[8]   top_ipred_type_ready
// bit[7:6] left_mv_idx
// bit[5:4] top_mv_idx
// bit[3] - left_mv_ready
// bit[2:0] top_mv_ready
#define V3_TOP_LEFT_CTL                            ((0x1f6d  << 2) + 0xff620000)
#define V3_TOP_MV                                  ((0x1f6e  << 2) + 0xff620000)
#define V3_LEFT_MV                                 ((0x1f6f  << 2) + 0xff620000)
// bit[31:30] reserved
// bit[29:16] v3_skip_weight_1
// bit[15:12] reserved
// bit[11:0]  v3_skip_weight_0
#define V3_SKIP_WEIGHT                             ((0x1f70  << 2) + 0xff620000)
// bit[31:28] reserved
// bit[27:16] v3_l1_f_skip_max_sad
// bit[15:12] reserved
// bit[11:0]  v3_l1_skip_max_sad
#define V3_L1_SKIP_MAX_SAD                         ((0x1f71  << 2) + 0xff620000)
// bit[31:16] force_skip_sad_2
// bit[15:0]  v3_skip_weight_2
#define V3_L2_SKIP_WEIGHT                          ((0x1f72  << 2) + 0xff620000)
// bit[21:16] v3_mv_sad_table_addr 0-15 table_step_0
// bit[11:0]  v3_mv_sad
#define V3_MV_SAD_TABLE                            ((0x1f73  << 2) + 0xff620000)
// [31:16] v3_ie_f_zero_sad_i16
// [15:0]  v3_ie_f_zero_sad_i4
#define V3_F_ZERO_CTL_0                            ((0x1f74  << 2) + 0xff620000)
// [25]    v3_no_ver_when_top_zero_en
// [24]    v3_no_hor_when_left_zero_en
// [23:16] v3_max_I16_H_num    // 0 means no break
// [15:0]  v3_me_f_zero_sad
#define V3_F_ZERO_CTL_1                            ((0x1f75  << 2) + 0xff620000)
#define V3_TOP_INTRA_INFO                          ((0x1f76  << 2) + 0xff620000)
#define V3_LEFT_INTRA_INFO                         ((0x1f77  << 2) + 0xff620000)
// [31:24]  C_ipred_weight_H
// [23:16]  C_ipred_weight_V
// [15:8]   I4_ipred_weight_else
// [7:0]    I4_ipred_weight_most
#define V3_IPRED_TYPE_WEIGHT_0                     ((0x1f78  << 2) + 0xff620000)
// [31:24]  I16_ipred_weight_DC
// [23:16]  I16_ipred_weight_H
// [15:8]   I16_ipred_weight_V
// [7:0]    C_ipred_weight_DC
#define V3_IPRED_TYPE_WEIGHT_1                     ((0x1f79  << 2) + 0xff620000)
// [31:16]  v3_left_small_max_me_sad
// [15:0]   v3_left_small_max_ie_sad
#define V3_LEFT_SMALL_MAX_SAD                      ((0x1f7a  << 2) + 0xff620000)
// (qr==7) & (qp==15) means force zero block
// [31:26]  v4_force_q_r_intra
// [25:20]  v4_force_q_r_inter
// [19]     v4_force_q_y_enable
// [18:16]  v4_force_qr_y
// [15:12]  v4_force_qp_y
// [11:0]   v4_force_skip_sad
#define V4_FORCE_SKIP_CFG                          ((0x1f7b  << 2) + 0xff620000)
// v5 Complexity // Y(256 pixel per MB) and C(128 pixel per MB)
// For every 4x4 block, calculate average and Add abs(pixel-average) together
// bit[31:16] v5_diff_sum_C
// bit[15:0]  v5_diff_sum_Y
#define V5_MB_DIFF_SUM                             ((0x1f7c  << 2) + 0xff620000)
// bit[31:24] v5_small_diff_cnt_C
// bit[23:16] v5_small_diff_C
// bit[15:8]  v5_small_diff_cnt_Y
// bit[7:0]   v5_small_diff_Y
#define V5_SMALL_DIFF_CNT                          ((0x1f7d  << 2) + 0xff620000)
// bit[31:29] Reserved
// bit[28:24] v5_simple_block_cnt // 0 -15 Y 16-23 C
// bit[23:20] v5_simple_pixel_cnt
// bit[19:18] v5_simple_dq_wr_ptr
// bit[17:16] v5_simple_dq_rd_ptr
// bit[15:12] v5_simple_dq (Read Only)
// bit[11:8]  v5_simple_me_weight(Read Only)
// bit[7] v5_use_small_diff_cnt
// bit[6] v5_simple_mb_inter_all_en
// bit[5] v5_simple_mb_inter_8x8_en
// bit[4] v5_simple_mb_inter_16_8_en
// bit[3] v5_simple_mb_inter_16x16_en
// bit[2] v5_simple_mb_intra_en
// bit[1] v5_simple_mb_C_en
// bit[0] v5_simple_mb_Y_en
#define V5_SIMPLE_MB_CTL                           ((0x1f7e  << 2) + 0xff620000)
// bit[31:28] v5_simple_dq_shift
// bit[27:24] v5_simple_dq_6(-7 to +7)
// bit[23:20] v5_simple_dq_5(-7 to +7)
// bit[19:16] v5_simple_dq_4(-7 to +7)
// bit[15:12] v5_simple_dq_3(-7 to +7)
// bit[11:08] v5_simple_dq_2(-7 to +7)
// bit[07:04] v5_simple_dq_1(-7 to +7)
// bit[03:00] v5_simple_dq_0(-7 to +7)
#define V5_SIMPLE_MB_DQUANT                        ((0x1f7f  << 2) + 0xff620000)
// bit[31:28] v5_simple_me_weight_shift
// bit[27:24] v5_simple_me_weight_6(-7 to +7)
// bit[23:20] v5_simple_me_weight_5(-7 to +7)
// bit[19:16] v5_simple_me_weight_4(-7 to +7)
// bit[15:12] v5_simple_me_weight_3(-7 to +7)
// bit[11:08] v5_simple_me_weight_2(-7 to +7)
// bit[07:04] v5_simple_me_weight_1(-7 to +7)
// bit[03:00] v5_simple_me_weight_0(-7 to +7)
#define V5_SIMPLE_MB_ME_WEIGHT                     ((0x1f80  << 2) + 0xff620000)
//
// Closing file:  qdct_regs.h
//
//------------------------------------------------------------------------------
// HCODEC MDEC module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  hcodec_mdec_regs.h
//
//========================================================================
//  MDEC module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_HCODEC_HDEC_CBUS_BASE = 0x09
// -----------------------------------------------
//`define HCODEC_MC_CTRL_REG         8'h00
//`define HCODEC_MC_MB_INFO          8'h01
//`define HCODEC_MC_PIC_INFO         8'h02
//`define HCODEC_MC_HALF_PEL_ONE     8'h03
//`define HCODEC_MC_HALF_PEL_TWO     8'h04
//`define HCODEC_POWER_CTL_MC        8'h05
//
//`define HCODEC_MC_CMD			    8'h06
//`define HCODEC_MC_CTRL0			8'h07
//`define HCODEC_MC_PIC_W_H  	    8'h08
//`define HCODEC_MC_STATUS0		    8'h09
//`define HCODEC_MC_STATUS1		    8'h0a
//`define HCODEC_MC_CTRL1			8'h0b
//`define HCODEC_MC_MIX_RATIO0	    8'h0c
//`define HCODEC_MC_MIX_RATIO1	    8'h0d
//`define HCODEC_MC_DP_MB_XY  	    8'h0e     //read only
//`define HCODEC_MC_OM_MB_XY  	    8'h0f     //read only
//
//`define HCODEC_MC_MPORT_CTRL  	    8'h40
//`define HCODEC_MC_MPORT_DAT  	    8'h41
//`define HCODEC_MC_WT_PRED_CTRL  	8'h42
//`define HCODEC_MC_MBBOT_ST_EVEN_ADDR 8'h44
//`define HCODEC_MC_MBBOT_ST_ODD_ADDR 8'h45
//`define HCODEC_MC_DPDN_MB_XY        8'h46    //read only
//`define HCODEC_MC_OMDN_MB_XY        8'h47    //read only
//`define HCODEC_MC_HCMDBUF_H        8'h48
//`define HCODEC_MC_HCMDBUF_L        8'h49
//`define HCODEC_MC_HCMD_H           8'h4a     //read only
//`define HCODEC_MC_HCMD_L           8'h4b     //read only
//`define HCODEC_MC_IDCT_DAT         8'h4c
//
//`define HCODEC_MC_CTRL_GCLK_CTRL   8'h4d
//`define HCODEC_MC_OTHER_GCLK_CTRL  8'h4e
//
////Bit 29:24, mbbot thread ID and token
////Bit 21:16, mc read/write thread ID and token
////Bit 13:8,  mbbot pre-arbitor burst number
////Bit 5:0,   mc pre-arbitor burst number
//`define HCODEC_MC_CTRL2            8'h4f
//
//// `define HCODEC_DBLK_QUANT            8'h76 // ONLY for $ucode/real/amrisc/rv.s, reg value from apollo
//
////`define HCODEC_ANC1_CANVAS_ADDR      8'h80
////`define HCODEC_ANC2_CANVAS_ADDR      8'h81
//
////`define HCODEC_REC_CANVAS_ADDR       8'h89
//
////`define HCODEC_MDEC_PIC_W          8'h8c
////`define HCODEC_MDEC_PIC_H          8'h8d
//`define HCODEC_MDEC_PIC_DC_CTRL    8'h8e
//`define HCODEC_MDEC_PIC_DC_STATUS  8'h8f
//
//`define HCODEC_ANC0_CANVAS_ADDR      8'h90
//`define HCODEC_ANC1_CANVAS_ADDR      8'h91
//`define HCODEC_ANC2_CANVAS_ADDR      8'h92
//`define HCODEC_ANC3_CANVAS_ADDR      8'h93
//`define HCODEC_ANC4_CANVAS_ADDR      8'h94
//`define HCODEC_ANC5_CANVAS_ADDR      8'h95
//`define HCODEC_ANC6_CANVAS_ADDR      8'h96
//`define HCODEC_ANC7_CANVAS_ADDR      8'h97
//`define HCODEC_ANC8_CANVAS_ADDR      8'h98
//`define HCODEC_ANC9_CANVAS_ADDR      8'h99
//`define HCODEC_ANC10_CANVAS_ADDR     8'h9a
//`define HCODEC_ANC11_CANVAS_ADDR     8'h9b
//`define HCODEC_ANC12_CANVAS_ADDR     8'h9c
//`define HCODEC_ANC13_CANVAS_ADDR     8'h9d
//`define HCODEC_ANC14_CANVAS_ADDR     8'h9e
//`define HCODEC_ANC15_CANVAS_ADDR     8'h9f
//`define HCODEC_ANC16_CANVAS_ADDR     8'ha0
//`define HCODEC_ANC17_CANVAS_ADDR     8'ha1
//`define HCODEC_ANC18_CANVAS_ADDR     8'ha2
//`define HCODEC_ANC19_CANVAS_ADDR     8'ha3
//`define HCODEC_ANC20_CANVAS_ADDR     8'ha4
//`define HCODEC_ANC21_CANVAS_ADDR     8'ha5
//`define HCODEC_ANC22_CANVAS_ADDR     8'ha6
//`define HCODEC_ANC23_CANVAS_ADDR     8'ha7
//`define HCODEC_ANC24_CANVAS_ADDR     8'ha8
//`define HCODEC_ANC25_CANVAS_ADDR     8'ha9
//`define HCODEC_ANC26_CANVAS_ADDR     8'haa
//`define HCODEC_ANC27_CANVAS_ADDR     8'hab
//`define HCODEC_ANC28_CANVAS_ADDR     8'hac
//`define HCODEC_ANC29_CANVAS_ADDR     8'had
//`define HCODEC_ANC30_CANVAS_ADDR     8'hae
//`define HCODEC_ANC31_CANVAS_ADDR     8'haf
//
//`define HCODEC_DBKR_CANVAS_ADDR      8'hb0
//`define HCODEC_DBKW_CANVAS_ADDR      8'hb1
//`define HCODEC_REC_CANVAS_ADDR       8'hb2
//
////28:24, read/write, current canvas idx, used in h264 only now
////23:0, read only, current canvas address, 23:16, Cr canvas addr, 15:8, Cb canvas addr, 7:0, Y  canvas addr
//`define HCODEC_CURR_CANVAS_CTRL      8'hb3
//
//`define HCODEC_MDEC_PIC_DC_THRESH    8'hb8
//`define HCODEC_MDEC_PICR_BUF_STATUS  8'hb9
//`define HCODEC_MDEC_PICW_BUF_STATUS  8'hba
//`define HCODEC_MCW_DBLK_WRRSP_CNT    8'hbb
//
//`define HCODEC_AV_SCRATCH_0          8'hc0
//`define HCODEC_AV_SCRATCH_1          8'hc1
//`define HCODEC_AV_SCRATCH_2          8'hc2
//`define HCODEC_AV_SCRATCH_3          8'hc3
//`define HCODEC_AV_SCRATCH_4          8'hc4
//`define HCODEC_AV_SCRATCH_5          8'hc5
//`define HCODEC_AV_SCRATCH_6          8'hc6
//`define HCODEC_AV_SCRATCH_7          8'hc7
//`define HCODEC_AV_SCRATCH_8          8'hc8
//`define HCODEC_AV_SCRATCH_9          8'hc9
//`define HCODEC_AV_SCRATCH_A          8'hca
//`define HCODEC_AV_SCRATCH_B          8'hcb
//`define HCODEC_AV_SCRATCH_C          8'hcc
//`define HCODEC_AV_SCRATCH_D          8'hcd
//`define HCODEC_AV_SCRATCH_E          8'hce
//`define HCODEC_AV_SCRATCH_F          8'hcf
//`define HCODEC_AV_SCRATCH_G          8'hd0
//`define HCODEC_AV_SCRATCH_H          8'hd1
//`define HCODEC_AV_SCRATCH_I          8'hd2
//`define HCODEC_AV_SCRATCH_J          8'hd3
//`define HCODEC_AV_SCRATCH_K          8'hd4
//`define HCODEC_AV_SCRATCH_L          8'hd5
//`define HCODEC_AV_SCRATCH_M          8'hd6
//`define HCODEC_AV_SCRATCH_N          8'hd7
//
//// bit[29:24] A_brst_num_co_mb
//// bit[21:16] A_id_co_mb
//// bit[11:0] wrrsp_count_co_mb
//`define HCODEC_WRRSP_CO_MB           8'hd8
//// bit[29:24] A_brst_num_dcac
//// bit[21:16] A_id_dcac
//// bit[11:0] wrrsp_count_dcac
//`define HCODEC_WRRSP_DCAC            8'hd9
//
////======================================
////  MC Control Register Bits
////
////======================================
//// For bits, just copy the defines...don't translate to addresses
//    `define HCODEC_MC_ENABLE	    16'h0001
//    //`define MC_RESET	    16'h0002
//    `define HCODEC_SKIP_MB		    16'h0004
//
////======================================
////  MB Info Register Bits
////
////======================================
//    `define HCODEC_INTRA_MB	    16'h0001
//
//    `define HCODEC_BWD_PRED	    16'h0004
//    `define HCODEC_FWD_PRED	    16'h0008
//
//    `define HCODEC_FLD_MOT		    16'h0100
//    `define HCODEC_FRM_16x8_MOT	16'h0200
//    `define HCODEC_DUAL_PRM_MOT	16'h0300
//
//    `define HCODEC_FRM_DCT		    16'h0000	    // Bit 10
//    `define HCODEC_FLD_DCT		    16'h0400
//
////======================================
////  MB Info Register Bits
////
////======================================
//    `define HCODEC_I_PIC		    16'h0001
//    `define HCODEC_P_PIC		    16'h0002
//    `define HCODEC_B_PIC		    16'h0003
//
//    `define HCODEC_FLD_PIC		    16'h0000	    // Bit 8
//    `define HCODEC_FRM_PIC		    16'h0100
//
////========================================================================
//// DBLK Register:  12'h950 - 12'h97f
////========================================================================
//`define HCODEC_DBLK_RST                8'h50
//`define HCODEC_DBLK_CTRL               8'h51
//`define HCODEC_DBLK_MB_WID_HEIGHT      8'h52
//`define HCODEC_DBLK_STATUS             8'h53
//`define HCODEC_DBLK_CMD_CTRL           8'h54
//`define HCODEC_DBLK_MB_XY              8'h55
//`define HCODEC_DBLK_QP                 8'h56
//`define HCODEC_DBLK_Y_BHFILT           8'h57
//`define HCODEC_DBLK_Y_BHFILT_HIGH      8'h58
//`define HCODEC_DBLK_Y_BVFILT           8'h59
//`define HCODEC_DBLK_CB_BFILT           8'h5a
//`define HCODEC_DBLK_CR_BFILT           8'h5b
//`define HCODEC_DBLK_Y_HFILT            8'h5c
//`define HCODEC_DBLK_Y_HFILT_HIGH       8'h5d
//`define HCODEC_DBLK_Y_VFILT            8'h5e
//`define HCODEC_DBLK_CB_FILT            8'h5f
//`define HCODEC_DBLK_CR_FILT            8'h60
//`define HCODEC_DBLK_BETAX_QP_SEL       8'h61
//`define HCODEC_DBLK_CLIP_CTRL0         8'h62
//`define HCODEC_DBLK_CLIP_CTRL1         8'h63
//`define HCODEC_DBLK_CLIP_CTRL2         8'h64
//`define HCODEC_DBLK_CLIP_CTRL3         8'h65
//`define HCODEC_DBLK_CLIP_CTRL4         8'h66
//`define HCODEC_DBLK_CLIP_CTRL5         8'h67
//`define HCODEC_DBLK_CLIP_CTRL6         8'h68
//`define HCODEC_DBLK_CLIP_CTRL7         8'h69
//`define HCODEC_DBLK_CLIP_CTRL8         8'h6a
//
//`define HCODEC_DBLK_STATUS1            8'h6b
//`define HCODEC_DBLK_GCLK_FREE          8'h6c
//`define HCODEC_DBLK_GCLK_OFF           8'h6d
//
//`define HCODEC_DBLK_AVSFLAGS           8'h6e
//
//// bit 15:0
//`define HCODEC_DBLK_CBPY               8'h70
//// bit 11:8 -- deblk_cbpy_bottom
//// bit 7:4 -- deblk_cbpy_left
//// bit 3:0 -- deblk_cbpy_top
//`define HCODEC_DBLK_CBPY_ADJ           8'h71
//// bit 7:0 -- deblk_cbpc
//`define HCODEC_DBLK_CBPC               8'h72
//// bit 15 -- bottom_mb
//// bit 14 -- left_mb
//// bit 13 -- top_mb
//// bit 12 -- reserved
//// bit 11:8 -- deblk_cbpc_bottom
//// bit 7:4 -- deblk_cbpc_left
//// bit 3:0 -- deblk_cbpc_top
//`define HCODEC_DBLK_CBPC_ADJ           8'h73
//// bit 15:8 -- deblk_hmvd   -- {left_1, left_0, below_1, below_0, block3-0}
//// bit 7:0 -- deblk_vmvd    -- {top_1, top_0, below_1, below_0, block3-0}
//`define HCODEC_DBLK_VHMVD              8'h74
//// bit 13:12 -- right_vmvd
//// bit 11 -- right_above_vmvd
//// bit 10 -- left_below_hmvd
//// bit 9 -- disable_dblk_luma
//// bit 8 -- disable_dblk_chroma
//// bit 7 -- bBelowRefDiff
//// bit 6 -- bLeftRefDiff
//// bit 5 -- bAboveRefDiff
//// bit 4 -- reserved
//// bit 3 -- s_below
//// bit 2 -- s_left
//// bit 1 -- s_above
//// bit 0 -- s
//`define HCODEC_DBLK_STRONG             8'h75
//// bit 14:10 -- PQUANT
//// bit 9:5 -- left_PQUANT
//// bit 4:0 -- top_PQUANT
//`define HCODEC_DBLK_RV8_QUANT          8'h76
//
//`define HCODEC_DBLK_CBUS_HCMD2         8'h77
//`define HCODEC_DBLK_CBUS_HCMD1         8'h78
//`define HCODEC_DBLK_CBUS_HCMD0         8'h79
//`define HCODEC_DBLK_VLD_HCMD2          8'h7a
//`define HCODEC_DBLK_VLD_HCMD1          8'h7b
//`define HCODEC_DBLK_VLD_HCMD0          8'h7c
//
//`define HCODEC_DBLK_OST_YBASE          8'h7d
//`define HCODEC_DBLK_OST_CBCRDIFF       8'h7e
//
////13:8 dblk thread ID and token
////5:0  dblk pre arbiter burst num
//`define HCODEC_DBLK_CTRL1              8'h7f
//
////DBLK last address 12'h97f
//
// Closing file:  hcodec_mdec_regs.h
//
//------------------------------------------------------------------------------
// HCODEC VLD module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  hcodec_vld_regs.h
//
//========================================================================
//  VLD module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_HCODEC_VLD_CBUS_BASE = 0x0c
// -----------------------------------------------
//
//`define HCODEC_VLD_STATUS_CTRL     8'h00
////
//// bit 10 -- use_old_shift_en
//// bit 9 -- output_mv_not_pmv
//// bit 8:5 -- force_zigzag
//// bit 4 -- force_zigzag_en
//// bit 3 -- disable_viff_anempty_int
//// bit 2 -- disable_m2_ac_coeff_one_cycle
//// bit 1 -- forced_reset  force reset pmv
//// bit 0 -- mpeg_type  0:mpeg1 1: mpeg2
//`define HCODEC_MPEG1_2_REG         8'h01
//`define HCODEC_F_CODE_REG          8'h02
//`define HCODEC_PIC_HEAD_INFO       8'h03
//`define HCODEC_SLICE_VER_POS_PIC_TYPE  8'h04
//`define HCODEC_QP_VALUE_REG        8'h05
//`define HCODEC_MBA_INC             8'h06
//`define HCODEC_MB_MOTION_MODE      8'h07
////`define HCODEC_PACKET_BYTE_COUNT   8'h08
//// bit 15 -- force_search_startcode_en
//// bit 14 -- int_cpu_when_error (before do anything)
//// bit 13 -- vld_error_reset
//// bit 12 -- return_on_slice_header
//// bit 6 -- jpeg_ff00_en
//// bit 5:0 -- vld_power_ctl
//`define HCODEC_POWER_CTL_VLD       8'h08
//
//`define HCODEC_MB_WIDTH	    8'h09
//`define HCODEC_SLICE_QP            8'h0a
//// `define HCODEC_MB_X_MB_Y           8'h0b   // current MBX and MBY
//`define HCODEC_PRE_START_CODE      8'h0b  // ONLY for $ucode/real/amrisc/rv.s, reg value from apollo
//`define HCODEC_SLICE_START_BYTE_01 8'h0c  // ONLY for $ucode/real/amrisc/rv.s, reg value from apollo
//`define HCODEC_SLICE_START_BYTE_23 8'h0d  // ONLY for $ucode/real/amrisc/rv.s, reg value from apollo
//`define HCODEC_RESYNC_MARKER_LENGTH 8'h0e  // Does this exist in HW ? used in $ucode/mpeg4
//
//// bit[6:5] - frame/field info, 01 - top, 10 - bottom, 11 - frame
//// bit[4:0] - buffer ID
//// L0_BUFF_ID_0, L0_BUFF_ID_1, L1_BUFF_ID_0, L1_BUFF_ID_1
//`define HCODEC_DECODER_BUFFER_INFO  8'h0f  // Current Only Used for VC1 Interlace Field
//
//`define HCODEC_FST_FOR_MV_X        8'h10
//`define HCODEC_FST_FOR_MV_Y        8'h11
//`define HCODEC_SCD_FOR_MV_X        8'h12
//`define HCODEC_SCD_FOR_MV_Y        8'h13
//`define HCODEC_FST_BAK_MV_X        8'h14
//`define HCODEC_FST_BAK_MV_Y        8'h15
//`define HCODEC_SCD_BAK_MV_X        8'h16
//`define HCODEC_SCD_BAK_MV_Y        8'h17
//
//// Bit 7:4 -- read_buffer_interlace  0-progressive, 1-interlace, used in VC1
//// bit 3 -- reserved
//// bit 2 -- weighting_prediction
//// bit 1 -- mb_weighting_flag
//// bit 0 -- slice_weighting_flag
//`define HCODEC_VLD_DECODE_CONTROL  8'h18
//
//`define HCODEC_VIFF_BIT_CNT        8'h1a
//`define HCODEC_BYTE_ALIGN_PEAK_HI  8'h1b
//`define HCODEC_BYTE_ALIGN_PEAK_LO  8'h1c
//`define HCODEC_NEXT_ALIGN_PEAK     8'h1d  // Does this exist in HW ? used in $ucode/mpeg4
//
//// bit 19    : vc1_inv_intra_co_mb_ref_rd
//// bit 18    : vc1_inv_co_mb_ref_rd
//// bit 17    : vc1_inv_intra_co_mb_ref_wr
//// bit 16    : vc1_inv_co_mb_ref_wr
//// bit 15    : reserved
//// bit 14    : avs_drop_enable
//// bit 13:12 : avs_drop_ptr
//// bit 11:8  : avs_demu_ctl_reg
//// bit 7 : avs_enable
//// bit 6 : disable_dblk_hcmd
//// bit 5 : disable_mc_hcmd
//// bit 4 : first_mode3_set enable
//// bit 3 : first_mode3
//// bit 2:1 : vc1_profile  0-SP, 1-MP, 2-reserved, 3-AP
//// bit 0   : vc1_enable
//`define HCODEC_VC1_CONTROL_REG     8'h1e
//
//`define HCODEC_PMV1_X              8'h20
//`define HCODEC_PMV1_Y              8'h21
//`define HCODEC_PMV2_X              8'h22
//`define HCODEC_PMV2_Y              8'h23
//`define HCODEC_PMV3_X              8'h24
//`define HCODEC_PMV3_Y              8'h25
//`define HCODEC_PMV4_X              8'h26
//`define HCODEC_PMV4_Y              8'h27
//// Can't use the same address for different defines
//// Therefore, create a single define HCODEC_that covers both
//// Only appears to be used in micro-code since the VLD hardware is
//// hard coded.
//// `define HCODEC_M4_TABLE_SELECT     8'h28  // Does this exist in HW ? Added from register_mp2.h
//// `define HCODEC_M4_TABLE_OUTPUT     8'h28  // Does this exist in HW ? Added from register_mp2.h
//`define HCODEC_M4_TABLE_SELECT     8'h28
//`define HCODEC_M4_CONTROL_REG      8'h29
//`define HCODEC_BLOCK_NUM           8'h2a  // Does this exist in HW ? Added from register_mp2.h
//`define HCODEC_PATTERN_CODE        8'h2b  // Does this exist in HW ? Added from register_mp2.h
//`define HCODEC_MB_INFO             8'h2c  // Does this exist in HW ? Added from register_mp2.h
//`define HCODEC_VLD_DC_PRED         8'h2d  // Does this exist in HW ? Added from register_mp4.h
//`define HCODEC_VLD_ERROR_MASK      8'h2e
//`define HCODEC_VLD_DC_PRED_C       8'h2f  // Does this exist in HW ? Added from register_mp4.h
//
//`define HCODEC_LAST_SLICE_MV_ADDR  8'h30
//`define HCODEC_LAST_MVX            8'h31
//`define HCODEC_LAST_MVY            8'h32
//
//`define HCODEC_VLD_C38             8'h38
//`define HCODEC_VLD_C39             8'h39
//
//`define HCODEC_VLD_STATUS          8'h3a  // Does this exist in HW ? used in $ucode/real/amrisc/rv.s
//`define HCODEC_VLD_SHIFT_STATUS    8'h3b  // Does this exist in HW ? used in $ucode/real/amrisc/rv.s
//// `define HCODEC_VLD_SHIFT_INFO      8'h3b  // Does this exist in HW ? used in $ucode/mpeg4
//`define HCODEC_VOFF_STATUS         8'h3c  // Does this exist in HW ? used in $ucode/mpeg4
//
//`define HCODEC_VLD_C3D             8'h3d
//
//`define HCODEC_VLD_DBG_INDEX       8'h3e
//
//
//// vld_buff_info -- (index == 0)
//// Bit[7:6]  mv_UR_ready_cnt;
//// Bit[5]  vld_wr_idx
//// Bit[4]  iq_rd_idx
//// Bit[3]  vld_vi_block_rdy_1
//// Bit[2]  vld_vi_block_rdy_2
//// Bit[1]  voff_empty_1
//// Bit[0]  voff_empty_2
//
//// cabac_buff_info_0 -- (index == 1)
//// Bit[31] shift_data_ready
//// Bit[30:29] Reserved
//// Bit[28:24] cabac_buffer_ptr
//// Bit[23:0] cabac_buffer
//
//// cabac_buff_info_1 -- (index == 2)
//// Bit[31:29] Reserved
//// Bit[28:20] Drange
//// Bit[19:16] bin_count_4
//// Bit[15:13] Reserved
//// Bit[12:6] context_mem_do
//// Bit[5:3] coeff_state
//// Bit[2:0] mvd_state
//
//// h264_mv_present -- (index == 3)
//// Bit[31:16] mv_present_l0
//// Bit[15:0] mv_present_l1
//
//// h264_mv_cal_info_0 -- (index == 4)
//// [31:28] mv_cal_state
//// [27:24] direct_spatial_cnt
//// Bit[23:21] Reserved
//// Bit[20] mv_UR_ready_for_mv_cal
//// Bit[19] co_mb_mem_ready_for_mv_cal
//// Bit[18] mc_dblk_cmd_if_busy
//// Bit[17] h264_co_mb_wr_busy
//// Bit[16] H264_cbp_blk_ready
//// Bit[15] mc_hcmd_rrdy
//// Bit[14] mc_hcmd_srdy
//// Bit[13] mc_cmd_if_ready
//// Bit[12] mc_hcmd_mv_available
//// Bit[11:8] mc_cmd_if_state
//// Bit[7] dblk_hcmd_rrdy
//// Bit[6] dblk_hcmd_srdy
//// Bit[5] dblk_cmd_if_ready
//// Bit[4] dblk_hcmd_mv_available
//// Bit[3:0] dblk_cmd_if_state
//
//// h264_mv_cal_info_1 -- (index == 5)
////  Bit[31:29] Reserved
////  Bit[28:24] total_mvd_num_l0
////  Bit[23:21] Reserved
////  Bit[20:16] mv_cal_ptr_l0
////  Bit[15:13] Reserved
////  Bit[12:8] mc_hcmd_ptr_l0
////  Bit[7:5] Reserved
////  Bit[4:0] dblk_hcmd_ptr_l0
//
//// h264_mv_cal_info_2 -- (index == 6)
////  Bit[31:29] Reserved
////  Bit[28:24] total_mvd_num_l1
////  Bit[23:21] Reserved
////  Bit[20:16] mv_cal_ptr_l1
////  Bit[15:13] Reserved
////  Bit[12:8] mc_hcmd_ptr_l1
////  Bit[7:5] Reserved
////  Bit[4:0] dblk_hcmd_ptr_l1
//
//// h264_co_mb_info -- (index == 7)
//// Bit[31:26] Reserved
//// Bit[25] mv_scale_cal_busy
//// Bit[24:20] co_mv_count
//// Bit[19:16] co_mv_process_state
//// Bit[15] h264_co_mb_rd_busy
//// Bit[15] h264_co_mb_rd_ready
//// Bit[13:12] co_mv_transfer_block_cnt
//// Bit[11:8] co_mv_transfer_ptr
//// Bit[7] co_mv_POC_l1_busy
//// Bit[6] h264_weight_scale_cal_en
//// Bit[5] weight_cal_busy
//// Bit[4] weight_cal_not_finished
//// Bit[3:0] weight_process_state
//
//`define HCODEC_VLD_DBG_DATA        8'h3f
//// --------------------------------------------
//// VIFIFO DDR Interface
//// --------------------------------------------
//// The VIFIFO start pointer into DDR memory is a 32-bit number
//// The Start pointer will automatically be truncated to land on
//// an 8-byte boundary.  That is, bits [2:0] = 0;
//`define HCODEC_VLD_MEM_VIFIFO_START_PTR        8'h40
//// The current pointer points so some location between the START and END
//// pointers.  The current pointer is a BYTE pointer.  That is, you can
//// point to any BYTE address within the START/END range
//`define HCODEC_VLD_MEM_VIFIFO_CURR_PTR         8'h41
//`define HCODEC_VLD_MEM_VIFIFO_END_PTR          8'h42
//`define HCODEC_VLD_MEM_VIFIFO_BYTES_AVAIL      8'h43
//// VIFIFO FIFO Control
//// bit  [31:24] viff_empty_int_enable_cpu[7:0]
//// bit  [23:16] viff_empty_int_enable_amrisc[7:0]
////   -bit 23 Video BUFFER < 0x400 Bytes
////   -bit 22 Video BUFFER < 0x200 Bytes
////   -bit 21 Video BUFFER < 0x100 Bytes
////   -bit 20 Video BUFFER < 0x80 Bytes
////   -bit 19 Video BUFFER < 0x40 Bytes
////   -bit 18 Video BUFFER < 0x20 Bytes
////   -bit 17 vififo  < 16 double words
////   -bit 16 vififo  < 8 double words
//// bit  [15:13] unused
//// bit  [12]    A_urgent
//// bit  [11]    transfer_length 0 - 32x64 Bits per request, 1 - 16x64 Bits per request
//// bit  [10]    use_level       Set this bit to 1 to enable filling of the FIFO controlled by the buffer
////                              level control.  If this bit is 0, then use bit[1] to control the enabling of filling
//// bit  [9]     Data Ready.     This bit is set when data can be popped
//// bit  [8]     fill busy       This bit will be high when we're fetching data from the DDR memory
////                              To reset this module, set cntl_enable = 0, and then wait for busy = 0.
////                              After that you can pulse cntl_init to start over
//// bit  [7]     init_with_cntl_init
//// bit  [6]     reserved
//// bits [5:3]   endian:         see $lib/rtl/ddr_endian.v
//// bit  [2]     cntl_empty_en   Set to 1 to enable reading the DDR memory FIFO
////                              Set cntl_empty_en = cntl_fill_en = 0 when pulsing cntl_init
//// bit  [1]     cntl_fill_en    Set to 1 to enable reading data from DDR memory
//// bit  [0]     cntl_init:      After setting the read pointers, sizes, channel masks
////                              and read masks, set this bit to 1 and then to 0
////                              NOTE:  You don't need to pulse cntl_init if only the start address is
////                              being changed
//`define HCODEC_VLD_MEM_VIFIFO_CONTROL         8'h44
//// --------------------------------------------
//// VIFIFO Buffer Level Manager
//// --------------------------------------------
//`define HCODEC_VLD_MEM_VIFIFO_WP              8'h45 // Manual or Parser write pointer
//`define HCODEC_VLD_MEM_VIFIFO_RP              8'h46
//`define HCODEC_VLD_MEM_VIFIFO_LEVEL           8'h47 // must be low first to shadow low/high 16-bit words
////
//// bit  [8]     use_parser_video2_wp
//// bit  [7]     vbuf2_out_manual
//// bit  [6]     vbuf_out_manual
//// bit  [5]     empty (ReadOnly)
//// bit  [4]     full (ReadOnly)
//// bit  [3:2]   reserved
//// bit  [1]     manual mode     Set to 1 for manual write pointer mode
//// bit  [0]     Init            Set high then low after everything has been initialized
//`define HCODEC_VLD_MEM_VIFIFO_BUF_CNTL        8'h48
//
//// bit 31:16 -- drop_bytes
//// bit 15:14 -- drop_status (Read-Only)
//// bit 13:12 -- sync_match_position (Read-Only)
//// bit 11:6 -- reserved
//// bit 5:4 -- TIME_STAMP_NUMBER, 0-32bits, 1-64bits, 2-96bits, 3-128bits
//// bit 3 -- stamp_soft_reset
//// bit 2 -- TIME_STAMP_length_enable
//// bit 1 -- TIME_STAMP_sync64_enable
//// bit 0 -- TIME_STAMP_enable
//`define HCODEC_VLD_TIME_STAMP_CNTL            8'h49
//// bit 31:0 -- TIME_STAMP_SYNC_CODE_0
//`define HCODEC_VLD_TIME_STAMP_SYNC_0          8'h4a
//// bit 31:0 -- TIME_STAMP_SYNC_CODE_1
//`define HCODEC_VLD_TIME_STAMP_SYNC_1          8'h4b
//// bit 31:0 TIME_STAMP_0
//`define HCODEC_VLD_TIME_STAMP_0               8'h4c
//// bit 31:0 TIME_STAMP_1
//`define HCODEC_VLD_TIME_STAMP_1               8'h4d
//// bit 31:0 TIME_STAMP_2
//`define HCODEC_VLD_TIME_STAMP_2               8'h4e
//// bit 31:0 TIME_STAMP_3
//`define HCODEC_VLD_TIME_STAMP_3               8'h4f
//// bit 31:0 TIME_STAMP_LENGTH
//`define HCODEC_VLD_TIME_STAMP_LENGTH          8'h50
//
//// bit 15:0 vififo_rd_count
//`define HCODEC_VLD_MEM_VIFIFO_WRAP_COUNT      8'h51
//
//// bit 29:24 A_brst_num
//// bit 21:16 A_id
//// bit 15:0 level_hold
//`define HCODEC_VLD_MEM_VIFIFO_MEM_CTL         8'h52
//
//`define HCODEC_VLD_MEM_VBUF_RD_PTR            8'h53 // manual read address for VBUF1
//`define HCODEC_VLD_MEM_VBUF2_RD_PTR           8'h54 // manual read address for VBUF2
//
//`define HCODEC_VLD_MEM_SWAP_ADDR              8'h55
//// bit[23:16] - swap_d_count (Read Only)
//// bit[15:8]  - swap_a_count (Read Only)
//// bit [7] - swap busy (Read Only)
//// bit [6:2] - reserved
//// bit [1] - 1 - STORE to Memory, 0 - LOAD from Memory
//// bit [0] - swap active
//`define HCODEC_VLD_MEM_SWAP_CTL               8'h56
//
// Closing file:  hcodec_vld_regs.h
//
//------------------------------------------------------------------------------
// HCODEC IQIDCT module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  hcodec_iqidct_regs.h
//
//========================================================================
//  IQ/IDCT module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_HCODEC_IQIDCT_CBUS_BASE = 0x0e
// -----------------------------------------------
//
//`define HCODEC_VCOP_CTRL_REG       8'h00
//`define HCODEC_QP_CTRL_REG         8'h01
//`define HCODEC_INTRA_QUANT_MATRIX  8'h02
//`define HCODEC_NON_I_QUANT_MATRIX  8'h03
//`define HCODEC_DC_SCALER           8'h04
//`define HCODEC_DC_AC_CTRL          8'h05
//// `define HCODEC_RV_AI_CTRL          8'h05  // ONLY for $ucode/real/amrisc/rv.s reg value from apollo
//`define HCODEC_DC_AC_SCALE_MUL     8'h06
//`define HCODEC_DC_AC_SCALE_DIV     8'h07
//// `define HCODEC_DC_AC_SCALE_RESULT  8'h06
//// `define HCODEC_RESERVED_E07        8'h07
//`define HCODEC_POWER_CTL_IQIDCT    8'h08
//`define HCODEC_RV_AI_Y_X           8'h09
//`define HCODEC_RV_AI_U_X           8'h0a
//`define HCODEC_RV_AI_V_X           8'h0b
//// bit 15:0 will count up when rv_ai_mb finished when non zero
//// and rv_ai_mb_finished_int will be generate when this is not zero
//`define HCODEC_RV_AI_MB_COUNT      8'h0c
//// For H264 I in PB picture Use -- dma type : h264_next_intra_dma
//`define HCODEC_NEXT_INTRA_DMA_ADDRESS 8'h0d
//// Bit 0 -- constrained_intra_pred_flag for H264
//`define HCODEC_IQIDCT_CONTROL         8'h0e
//
//
//// Bit[31:19] Reserved
//// Bit[18] iq_waiting
//// Bit[17] iq_om_wr_idx
//// Bit[16] iq_om_rd_idx
//// Bit[15] iq_om_busy
//// Bit[14] iq_om_2_busy
//// Bit[13] idx_fifo_0
//// Bit[12] idx_fifo_1
//// Bit[11] idx_fifo_2
//// Bit[10] idx_fifo_3
//// Bit[9] idx_fifo_4
//// Bit[8] idx_fifo_5
//// Bit[7] idx_fifo_6
//// Bit[6] idx_fifo_7
//// Bit[5:3] idx_fifo_wp
//// Bit[2:0] idx_fifo_rp
//
//`define HCODEC_IQIDCT_DEBUG_INFO_0    8'h0f
//
//// For RTL Simulation Only
//`define HCODEC_DEBLK_CMD              8'h10
//
//// Bit[15+16] ds_mc_valid_2
//// Bit[14+16] new_idct1_rd_idx_2
//// Bit[13+16] new_idct1_wr_idx_2
//// Bit[12+16] idct1_buff0_busy_2
//// Bit[11+16] idct1_buff1_busy_2
//// Bit[10+16] new_idct1_busy_2
//// Bit[9+16] iq_om_8val_2
//// Bit[8+16] idct1_pipe_busy_2
//
//// Bit[7+16] wait_mb_left_finish_hold_2
//// Bit[6+16] new_idct2_rd_idx_2
//// Bit[5+16] new_idct2_wr_idx_2
//// Bit[4+16] idct2_buff0_busy_2
//// Bit[3+16] idct2_buff1_busy_2
//// Bit[2+16] idct2_en_2
//// Bit[1+16] new_idct2_busy_2
//// Bit[0+16] new_idct1_ready_2
//
//// Bit[15] ds_mc_valid_1
//// Bit[14] new_idct1_rd_idx_1
//// Bit[13] new_idct1_wr_idx_1
//// Bit[12] idct1_buff0_busy_1
//// Bit[11] idct1_buff1_busy_1
//// Bit[10] new_idct1_busy_1
//// Bit[9] iq_om_8val_1
//// Bit[8] idct1_pipe_busy_1
//
//// Bit[7] wait_mb_left_finish_hold_1
//// Bit[6] new_idct2_rd_idx_1
//// Bit[5] new_idct2_wr_idx_1
//// Bit[4] idct2_buff0_busy_1
//// Bit[3] idct2_buff1_busy_1
//// Bit[2] idct2_en_1
//// Bit[1] new_idct2_busy_1
//// Bit[0] new_idct1_ready_1
//
//`define HCODEC_IQIDCT_DEBUG_IDCT      8'h11
//
//
//
//// bit 31 -- convas_enable
//// bit 30:24 -- convas_x_count ( 8 pixels / 64 bits )
//// bit 23:16 -- convas_y_count
//// bit 15   -- dcac_dma_busy
//// bit 14   -- dcac_dma_urgent
//// bit 13:8 -- dcac_dma_count
//// bit 7    -- dcac_dma_rw
//// bit 6    -- dcac_skip_read_mode
//// bit 5:0  -- dcac_dma_offset
//`define HCODEC_DCAC_DMA_CTRL        8'h12
//// when (convas_enable == 0 )
////   bit 31:0 dcac_dma_addr
//// when (convas_enable == 1 )
////   bit 31:25 canvas_addr (7 bits)
////   bit 24:12 convas_y_start ( 13 btis )
////   bit 11:0  convas_x_start ( 12 btis )
//`define HCODEC_DCAC_DMA_ADDRESS     8'h13
//// bit 7:0 -- dcac_cpu_addr
//`define HCODEC_DCAC_CPU_ADDRESS     8'h14
//// bit 31:0 -- dcac_cpu_data
//`define HCODEC_DCAC_CPU_DATA        8'h15
//
//// bit 31:19 -- reserved
//// bit 18:16 -- block_num_reg -- Read-Only
//// bit 15:0 -- dcac_mb_count
//`define HCODEC_DCAC_MB_COUNT        8'h16
//
//// bit 31:18 -- reserved
//// For H264 :
////   bit 17:2 -- h264_quant
////   bit 11:6 -- h264_quant_c
////   bit  5:0 -- h264_quant_c
//// For VC1 :
////   bit    17 -- qindex_GT_8
////   bit    16 -- HalfQPStep
////   bit 15:12 -- eQuantMode
////   bit 11:6  -- AltPQuant
////   bit  5:0  -- PQuant
////
//`define HCODEC_IQ_QUANT             8'h17
//
//// bit 31:24  -- bitplane_width
//// bit 23:16  -- bitplane_height
//// bit 15:14  -- bitplane_start_x
//// bit 13:12  -- bitplane_start_y
//// bit 11:4   -- reserved
//// bit 3:1    -- bitplane_type
//// bit 0      -- bitplane_busy
//`define HCODEC_VC1_BITPLANE_CTL     8'h18
//
//
//
//    `define HCODEC_RAM_TEST_CMD        12'h002
//    `define HCODEC_RAM_TEST_ADDR       12'h003
//    `define HCODEC_RAM_TEST_DATAH      12'h004
//    `define HCODEC_RAM_TEST_DATAL      12'h005
//
//    `define HCODEC_RAM_TEST_RD_CMD	    16'h0000
//    `define HCODEC_RAM_TEST_WR_CMD	    16'h8000
//    `define HCODEC_IDCT_TM2_PT0	    16'h0001
//    `define HCODEC_IDCT_TM2_PT1	    16'h0002
//    `define HCODEC_IDCT_TM1_PT0	    16'h0004
//    `define HCODEC_IDCT_TM1_PT1	    16'h0008
//    `define HCODEC_IQ_OMEM_PT0	        16'h0010
//    `define HCODEC_IQ_OMEM_PT1	        16'h0020
//    `define HCODEC_MC_IMEM_PT0	        16'h0040
//    `define HCODEC_ALL_RAM_PTS	        16'h007f
//
////======================================
////  VCOP Control Register Bits
////
////======================================
//    //`define HCODEC_IQIDCT_RESET	    16'h0001	    // Bit 0
//    `define HCODEC_QM_WEN		    16'h0002	    // Bit 1
//    `define HCODEC_IQIDCT_ENABLE	    16'h0004	    // Bit 2
//    `define HCODEC_INTRA_QM	    16'h0008	    // Bit 3	0 = Use default; 1 = use loaded
//    `define HCODEC_NINTRA_QM	    16'h0010	    // Bit 4	0 = Use default; 1 = use loaded
//
////======================================
////  QP Control Register Bits
////
////======================================
//    `define HCODEC_INTRA_MODE	    16'h0080	    // Bit 7
//// Duplicate Address:  When actually used
//// please move to a different address
//// `define HCODEC_FLD_DCT_TYPE	    16'h0100	    // Bit 8	0 = Frame DCT; 1 = field DCT
//
//
// Closing file:  hcodec_iqidct_regs.h
//
//------------------------------------------------------------------------------
// HCODEC IQIDCT module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  hcodec_vcpu_regs.h
//
//========================================================================
//  VCPU module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_HCODEC_VCPU_CBUS_BASE = 0x03
// -----------------------------------------------
//`define HCODEC_MSP                 8'h00
//`define HCODEC_MPSR                8'h01
//`define HCODEC_MINT_VEC_BASE       8'h02
//`define HCODEC_MCPU_INTR_GRP       8'h03
//`define HCODEC_MCPU_INTR_MSK       8'h04
//`define HCODEC_MCPU_INTR_REQ       8'h05
//`define HCODEC_MPC_P               8'h06
//`define HCODEC_MPC_D               8'h07
//`define HCODEC_MPC_E			    8'h08
//`define HCODEC_MPC_W			    8'h09
//`define HCODEC_MINDEX0_REG			8'h0a
//`define HCODEC_MINDEX1_REG			8'h0b
//`define HCODEC_MINDEX2_REG			8'h0c
//`define HCODEC_MINDEX3_REG			8'h0d
//`define HCODEC_MINDEX4_REG			8'h0e
//`define HCODEC_MINDEX5_REG			8'h0f
//`define HCODEC_MINDEX6_REG			8'h10
//`define HCODEC_MINDEX7_REG			8'h11
//`define HCODEC_MMIN_REG			8'h12
//`define HCODEC_MMAX_REG			8'h13
//`define HCODEC_MBREAK0_REG			8'h14
//`define HCODEC_MBREAK1_REG			8'h15
//`define HCODEC_MBREAK2_REG			8'h16
//`define HCODEC_MBREAK3_REG			8'h17
//`define HCODEC_MBREAK_TYPE			8'h18
//`define HCODEC_MBREAK_CTRL			8'h19
//`define HCODEC_MBREAK_STAUTS		8'h1a
//`define HCODEC_MDB_ADDR_REG		8'h1b
//`define HCODEC_MDB_DATA_REG		8'h1c
//`define HCODEC_MDB_CTRL			8'h1d
//`define HCODEC_MSFTINT0            8'h1e
//`define HCODEC_MSFTINT1            8'h1f
//
//`define HCODEC_CSP                 8'h20
//`define HCODEC_CPSR                8'h21
//`define HCODEC_CINT_VEC_BASE       8'h22
//`define HCODEC_CCPU_INTR_GRP       8'h23
//`define HCODEC_CCPU_INTR_MSK       8'h24
//`define HCODEC_CCPU_INTR_REQ       8'h25
//`define HCODEC_CPC_P               8'h26
//`define HCODEC_CPC_D               8'h27
//`define HCODEC_CPC_E			    8'h28
//`define HCODEC_CPC_W			    8'h29
//`define HCODEC_CINDEX0_REG			8'h2a
//`define HCODEC_CINDEX1_REG			8'h2b
//`define HCODEC_CINDEX2_REG			8'h2c
//`define HCODEC_CINDEX3_REG			8'h2d
//`define HCODEC_CINDEX4_REG			8'h2e
//`define HCODEC_CINDEX5_REG			8'h2f
//`define HCODEC_CINDEX6_REG			8'h30
//`define HCODEC_CINDEX7_REG			8'h31
//`define HCODEC_CMIN_REG			8'h32
//`define HCODEC_CMAX_REG			8'h33
//`define HCODEC_CBREAK0_REG			8'h34
//`define HCODEC_CBREAK1_REG			8'h35
//`define HCODEC_CBREAK2_REG			8'h36
//`define HCODEC_CBREAK3_REG			8'h37
//`define HCODEC_CBREAK_TYPE			8'h38
//`define HCODEC_CBREAK_CTRL			8'h39
//`define HCODEC_CBREAK_STAUTS		8'h3a
//`define HCODEC_CDB_ADDR_REG		8'h3b
//`define HCODEC_CDB_DATA_REG		8'h3c
//`define HCODEC_CDB_CTRL			8'h3d
//`define HCODEC_CSFTINT0            8'h3e
//`define HCODEC_CSFTINT1            8'h3f
//
//`define HCODEC_IMEM_DMA_CTRL       8'h40
//`define HCODEC_IMEM_DMA_ADR        8'h41
//`define HCODEC_IMEM_DMA_COUNT      8'h42
//// bit[29:24] A_brst_num_imem
//// bit[21:16] A_id_imem
//// bit[11:0] wrrsp_count_imem (reserved)
//`define HCODEC_WRRSP_IMEM          8'h43
//
//`define HCODEC_LMEM_DMA_CTRL       8'h50
//`define HCODEC_LMEM_DMA_ADR        8'h51
//`define HCODEC_LMEM_DMA_COUNT      8'h52
//// bit[29:24] A_brst_num_lmem
//// bit[21:16] A_id_lmem
//// bit[11:0] wrrsp_count_lmem
//`define HCODEC_WRRSP_LMEM          8'h53
//
//`define HCODEC_MAC_CTRL1			8'h60
//`define HCODEC_ACC0REG1			8'h61
//`define HCODEC_ACC1REG1			8'h62
//
//`define HCODEC_MAC_CTRL2			8'h70
//`define HCODEC_ACC0REG2			8'h71
//`define HCODEC_ACC1REG2			8'h72
//`define HCODEC_CPU_TRACE			8'h80
//
//
// Closing file:  hcodec_vcpu_regs.h
//
//------------------------------------------------------------------------------
// HEVC_ASSIST module level register offset
//------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  DOS_HEVC_ASSIST_CBUS_BASE = 0x00
// -----------------------------------------------
#define HEVC_ASSIST_AFIFO_CTRL                     ((0x3001  << 2) + 0xff620000)
#define HEVC_ASSIST_AFIFO_CTRL1                    ((0x3002  << 2) + 0xff620000)
#define HEVC_ASSIST_GCLK_EN                        ((0x3003  << 2) + 0xff620000)
#define HEVC_ASSIST_SW_RESET                       ((0x3004  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR1_INT0                      ((0x3025  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR1_INT1                      ((0x3026  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR1_INT2                      ((0x3027  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR1_INT3                      ((0x3028  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR1_INT4                      ((0x3029  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR1_INT5                      ((0x302a  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR1_INT6                      ((0x302b  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR1_INT7                      ((0x302c  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR1_INT8                      ((0x302d  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR1_INT9                      ((0x302e  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR1_INTA                      ((0x302f  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR1_INTB                      ((0x3030  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR1_INTC                      ((0x3031  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR1_INTD                      ((0x3032  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR1_INTE                      ((0x3033  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR1_INTF                      ((0x3034  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR2_INT0                      ((0x3035  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR2_INT1                      ((0x3036  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR2_INT2                      ((0x3037  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR2_INT3                      ((0x3038  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR2_INT4                      ((0x3039  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR2_INT5                      ((0x303a  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR2_INT6                      ((0x303b  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR2_INT7                      ((0x303c  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR2_INT8                      ((0x303d  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR2_INT9                      ((0x303e  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR2_INTA                      ((0x303f  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR2_INTB                      ((0x3040  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR2_INTC                      ((0x3041  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR2_INTD                      ((0x3042  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR2_INTE                      ((0x3043  << 2) + 0xff620000)
#define HEVC_ASSIST_AMR2_INTF                      ((0x3044  << 2) + 0xff620000)
#define HEVC_ASSIST_MBX_SSEL                       ((0x3045  << 2) + 0xff620000)
#define HEVC_ASSIST_TIMER0_LO                      ((0x3060  << 2) + 0xff620000)
#define HEVC_ASSIST_TIMER0_HI                      ((0x3061  << 2) + 0xff620000)
#define HEVC_ASSIST_TIMER1_LO                      ((0x3062  << 2) + 0xff620000)
#define HEVC_ASSIST_TIMER1_HI                      ((0x3063  << 2) + 0xff620000)
#define HEVC_ASSIST_DMA_INT                        ((0x3064  << 2) + 0xff620000)
#define HEVC_ASSIST_DMA_INT_MSK                    ((0x3065  << 2) + 0xff620000)
#define HEVC_ASSIST_DMA_INT2                       ((0x3066  << 2) + 0xff620000)
#define HEVC_ASSIST_DMA_INT_MSK2                   ((0x3067  << 2) + 0xff620000)
#define HEVC_ASSIST_MBOX0_IRQ_REG                  ((0x3070  << 2) + 0xff620000)
#define HEVC_ASSIST_MBOX0_CLR_REG                  ((0x3071  << 2) + 0xff620000)
#define HEVC_ASSIST_MBOX0_MASK                     ((0x3072  << 2) + 0xff620000)
#define HEVC_ASSIST_MBOX0_FIQ_SEL                  ((0x3073  << 2) + 0xff620000)
#define HEVC_ASSIST_MBOX1_IRQ_REG                  ((0x3074  << 2) + 0xff620000)
#define HEVC_ASSIST_MBOX1_CLR_REG                  ((0x3075  << 2) + 0xff620000)
#define HEVC_ASSIST_MBOX1_MASK                     ((0x3076  << 2) + 0xff620000)
#define HEVC_ASSIST_MBOX1_FIQ_SEL                  ((0x3077  << 2) + 0xff620000)
#define HEVC_ASSIST_MBOX2_IRQ_REG                  ((0x3078  << 2) + 0xff620000)
#define HEVC_ASSIST_MBOX2_CLR_REG                  ((0x3079  << 2) + 0xff620000)
#define HEVC_ASSIST_MBOX2_MASK                     ((0x307a  << 2) + 0xff620000)
#define HEVC_ASSIST_MBOX2_FIQ_SEL                  ((0x307b  << 2) + 0xff620000)
// bit[31:24] - read request
// bit[23:16] - write request
// bit[7] - disable_aml_axi_clk_gating
// bit[3:0] - arb_switch_cnt
#define HEVC_ASSIST_AXI_CTRL                       ((0x307c  << 2) + 0xff620000)
// bit[31:24] - read arb result
// bit[23:16] - write arb result
// bit[15:12] - read_ar_cnt
// bit[11:8] - write_aw_cnt
// bit[7] - arvalid_axi_s0
// bit[6] - arready_axi_s0
// bit[5] - awvalid_axi_s0
// bit[4] - awready_axi_s0
// bit[3:0] - write_fifo_cnt
#define HEVC_ASSIST_AXI_STATUS                     ((0x307d  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_0                      ((0x30c0  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_1                      ((0x30c1  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_2                      ((0x30c2  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_3                      ((0x30c3  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_4                      ((0x30c4  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_5                      ((0x30c5  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_6                      ((0x30c6  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_7                      ((0x30c7  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_8                      ((0x30c8  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_9                      ((0x30c9  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_A                      ((0x30ca  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_B                      ((0x30cb  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_C                      ((0x30cc  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_D                      ((0x30cd  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_E                      ((0x30ce  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_F                      ((0x30cf  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_G                      ((0x30d0  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_H                      ((0x30d1  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_I                      ((0x30d2  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_J                      ((0x30d3  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_K                      ((0x30d4  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_L                      ((0x30d5  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_M                      ((0x30d6  << 2) + 0xff620000)
#define HEVC_ASSIST_SCRATCH_N                      ((0x30d7  << 2) + 0xff620000)
//------------------------------------------------------------------------------
// HEVC_ASSIST module level register offset
// Same as VDEC/HCODEC to avoid confusing software guy
//------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  DOS_HEVC_VCPU_CBUS_BASE = 0x03
// -----------------------------------------------
//------------------------------------------------------------------------------
// HEVC_PARSER module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  hevc_parser_regs.h
//
// -----------------------------------------------
// CBUS_BASE:  DOS_HEVC_PARSER_CBUS_BASE = 0x01
// -----------------------------------------------
// [31:0] After reset version, can be used for test scratch register
#define HEVC_PARSER_VERSION                        ((0x3100  << 2) + 0xff620000)
// [31:16] - axi_setting
// [15]    - disable_stream_clock_gating
// [14]    - wstrb_set
// [13]    - stream_read_pause
// [6:4]   - stream_fetch_endian
// [3]     - use_parser_vbuf_wp
// [2]     - use_parser_vbuf2_wp
// [1]     - stream_fetch_busy - Read Only
// [0]     - stream_fetch_enable
#define HEVC_STREAM_CONTROL                        ((0x3101  << 2) + 0xff620000)
#define HEVC_STREAM_START_ADDR                     ((0x3102  << 2) + 0xff620000)
#define HEVC_STREAM_END_ADDR                       ((0x3103  << 2) + 0xff620000)
// SW stream_buffer_wr_ptr
#define HEVC_STREAM_WR_PTR                         ((0x3104  << 2) + 0xff620000)
#define HEVC_STREAM_RD_PTR                         ((0x3105  << 2) + 0xff620000)
//[31:0] stream_buffer_level - read only
#define HEVC_STREAM_LEVEL                          ((0x3106  << 2) + 0xff620000)
// [31:29] stream_buffer_hole 256*(4^0) bytes
// [28:23] stream_fifo_hole
// [22:16] stream_fifo_level
// [15]    stream_fifo_wr_ptr_update_en
// [14:8]  stream_fifo_wr_ptr
// [7]     stream_fifo_rd_ptr_update_en
// [6:0]   stream_fifo_rd_ptr
#define HEVC_STREAM_FIFO_CTL                       ((0x3107  << 2) + 0xff620000)
// [31:16] - Reserved
// [15]    - disable_shift_clock_gating
// [14]    - disable_start_code_protect
// [10]    - length_zero_startcode_en
// [9]     - length_valid_startcode_en
// [8:6]   - sft_valid_wr_position (default : 3 (at least 24 bits available))
// [5:4]   - emulate_code_length_sub_1(Default : 2)
// [3]     - emulation_auto_on_startcode(Default : 0)
// [2:1]   - start_code_length_sub_1(Default : 2)
// [0]     - stream_shift_enable(Default : 0)
#define HEVC_SHIFT_CONTROL                         ((0x3108  << 2) + 0xff620000)
// [31:0]  - max 4-bytes start code (Default : 0x00000100)
#define HEVC_SHIFT_STARTCODE                       ((0x3109  << 2) + 0xff620000)
// [31:0]  - max 4-bytes emulate code (Default : 0x00000300)
#define HEVC_SHIFT_EMULATECODE                     ((0x310a  << 2) + 0xff620000)
// [2]     - startcode_searching
// [1]     - emulation_check_on
// [0]     - startcode_check_on
#define HEVC_SHIFT_STATUS                          ((0x310b  << 2) + 0xff620000)
// [31:0] hevc_shifted_data - read only
#define HEVC_SHIFTED_DATA                          ((0x310c  << 2) + 0xff620000)
// [31:0] shift_byte_count[31:0]
#define HEVC_SHIFT_BYTE_COUNT                      ((0x310d  << 2) + 0xff620000)
// [31:28] - shift_byte_count[35:32]
// [27:20] - element_read_data[31:24]
// [10]    - bytealign
// [9]     - signed_element
// [8]     - start_element_read
// [7]     - shift_busy
// [6:0]   - shift_bits
#define HEVC_SHIFT_COMMAND                         ((0x310e  << 2) + 0xff620000)
// 31:8    - element_read_data[23:0]
//  7:2    - element_read_length
//  1:0    - element_read_state
#define HEVC_ELEMENT_RESULT                        ((0x310f  << 2) + 0xff620000)
// [31:16] - cabac_buffer
// [15]    - cabac_buffer_init
// [14]    - cabac_context_init
// [13]    - disable_cabac_clock_gating
// [12]    - cabac_init_flag
// [11]    - Reserved
// [10]    - VP9_init_mv
// [9]     - VP9_init_ref_mode
// [8]     - VP9_init_if_y_mode
// [7]     - VP9_init_intra_inter
// [6]     - VP9_init_inter_mode
// [5]     - VP9_init_coef
// [4]     - VP9_init_tx_mode
// [3]     - VP9_init_skip
// [2]     - VP9_init_partition
// [1]     - VP9_key_frame
// [0]     - cabac_enable(Default : 0)
#define HEVC_CABAC_CONTROL                         ((0x3110  << 2) + 0xff620000)
// [31:25] - chromaQPOffset_U
// [24:18] - chromaQPOffset_V
// [17:16] - MaxTrSize 0-4x4, 1-8x8, 2-16x16, 3-32x32
// [15:14] - MinTrSize 0-4x4, 1-8x8, 2-16x16, 3-32x32
// HEVC
// [13:12] - MaxCUSize 0-8x8, 1-16x16, 2-32x32, 3-64x64
// [11:10] - MinCUSize 0-8x8, 1-16x16, 2-32x32, 3-64x64
// [9]     - slice_sao_luma_flag
// [8]     - slice_sao_chroma_flag
// VP9 -- When vp9_enable
// [13:11] - MaxCUSize 0-8x8, 1-16x16, 2-32x32, 3-64x64, 7-4x4
// [10:8]  - MinCUSize 0-8x8, 1-16x16, 2-32x32, 3-64x64, 7-4x4
// [7:2]   - slice_quant
// [1:0]   - slice_type
// AVS2
// [13:12] - MaxCUSize 0-8x8, 1-16x16, 2-32x32, 3-64x64
// [11:10] - MinCUSize 0-8x8, 1-16x16, 2-32x32, 3-64x64
// [9]     - reserved
// [8]     - slice_quant[6]
// [7:2]   - slice_quant
// [1:0]   - slice_type
#define HEVC_PARSER_SLICE_INFO                     ((0x3111  << 2) + 0xff620000)
// bit[16]  - 0:command, 1:address(will auto increase when write command)
// bit[15:0]- command or addr
#define HEVC_PARSER_CMD_WRITE                      ((0x3112  << 2) + 0xff620000)
// [31:16] - reserved
// [15]    - disable_parser_core_clock_gating
// [14:1]  - Reserved
// [0]     - parser_core_enable(Default : 0)
#define HEVC_PARSER_CORE_CONTROL                   ((0x3113  << 2) + 0xff620000)
// [31:16] - pre_parser_cmd
// [15]    - start_cmd_fetch/fetch_busy
// [14]    - parser_cmd_ready
// [13]    - pre_parser_cmd_ready
// [12]    - do_not_wait_if_busy
// [11:8]  - cmd_fetch_status // Read-only
// [7:0]   - cmd_fetch_addr
#define HEVC_PARSER_CMD_FETCH                      ((0x3114  << 2) + 0xff620000)
// [31:16] - parser_cmd
// [9:5]   - parser_function
// [4:0]   - cmd_status
#define HEVC_PARSER_CMD_STATUS                     ((0x3115  << 2) + 0xff620000)
// [31]    - end_of_picture
// [30]    - uiLeft
// [39]    - uiTop
// [28]    - uiTopRight
// [27:24] - Reserved
// [23:12] - uiLin
// [11:0]  - uiCol
#define HEVC_PARSER_LCU_INFO                       ((0x3116  << 2) + 0xff620000)
// 29:28 - min_cu_size_qp_delta
// 27    - cu_qp_delta_enabled_flag
// 26    - amp_enabled_flag
// 25:23 - max_num_merge_cand
// 22    - mvd_l1_zero_flag
// 21:16 - num_ref_idx_l1_active
// 15:10 - num_ref_idx_l0_active
// 9:7   - max_transform_hierarchy_depth_inter
// 6:4   - max_transform_hierarchy_depth_intra
// 3     - transquant_bypass_enable_flag
// 2     - constrained_intra_pred_flag
// 1     - transform_skip_enabled_flag
// 0     - sign_data_hiding_flag
#define HEVC_PARSER_HEADER_INFO                    ((0x3117  << 2) + 0xff620000)
#define HEVC_PARSER_RESULT_0                       ((0x3118  << 2) + 0xff620000)
#define HEVC_PARSER_RESULT_1                       ((0x3119  << 2) + 0xff620000)
#define HEVC_PARSER_RESULT_2                       ((0x311a  << 2) + 0xff620000)
#define HEVC_PARSER_RESULT_3                       ((0x311b  << 2) + 0xff620000)
// For HEVC
// bit[31:24] - quant[47:40]
// bit[23:16] - quant[39:32]
// For VP9
// bit[31:24] - intra_flag
// bit[23:16] - SplitFlag_4
// bit[15:8]  - SkipFlag
// bit[7]     - SliceEnd|end_of_picture
// bit[6:3]   - SplitFlag_8
// bit[2:1]   - SplitFlag_16
// bit[0]     - SplitFlag_32
#define HEVC_CABAC_TOP_INFO                        ((0x311c  << 2) + 0xff620000)
// For HEVC
// bit[31:0]  - quant[31:0]
// For VP9
// bit [31:24] - vp9_top_eob_v
// bit [23:16] - vp9_top_eob_u
// bit [15:0] - vp9_top_eob_y
#define HEVC_CABAC_TOP_INFO_2                      ((0x311d  << 2) + 0xff620000)
// For HEVC
// bit[31:24] - quant[47:40]
// bit[23:16] - quant[39:32]
// For VP9
// bit[31:24] - Reserved
// bit[23:16] - SplitFlag_4
// bit[15:8]  - SkipFlag
// bit[7]     - Reserved
// bit[6:3]   - SplitFlag_8
// bit[2:1]   - SplitFlag_16
// bit[0]     - SplitFlag_32
#define HEVC_CABAC_LEFT_INFO                       ((0x311e  << 2) + 0xff620000)
// For HEVC
// bit[31:0]  - quant[31:0]
// For VP9
// bit [31:24] - vp9_left_eob_v
// bit [23:16] - vp9_left_eob_u
// bit [15:0] - vp9_left_eob_y
#define HEVC_CABAC_LEFT_INFO_2                     ((0x311f  << 2) + 0xff620000)
// [31:29] - stream_buffer_empty_int_ctl (32bytes - 4k bytes) (default : 4 : 512 bytes interrupt)
// [28:26] - stream_fifo_empty_int_ctl (0 - 128)(default : 0 - 0 byte interrupt)
// [25]    - stream_buffer_empty_int_cpu_enable
// [24]    - stream_buffer_empty_int_amrisc_enable
// [23]    - stream_fifo_empty_int_cpu_enable
// [22]    - stream_fifo_empty_int_amrisc_enable
// [15]    - disable_parser_clock_gating
// [8]     - dec_done_int_cpu_enable
// [7]     - dec_done_int_amrisc_enable
// [6]     - cmd_done_int_cpu_enable
// [5]     - cmd_done_int_amrisc_enable
// [4]     - startcode_found_int_cpu_enable
// [3]     - startcode_found_int_amrisc_enable
// [2]     - parser_int_cpu_level (default : 0(pulse))
// [1]     - parser_int_amrisc_level (default : 0(pulse))
// [0]     - parser_int_enable(Default : 0)
#define HEVC_PARSER_INT_CONTROL                    ((0x3120  << 2) + 0xff620000)
// [7]     - stream_empty_int_cpu
// [6]     - stream_empty_int_amrisc
// [2]     - dec_done_int
// [1]     - cmd_done_int
// [0]     - startcode_found_int
#define HEVC_PARSER_INT_STATUS                     ((0x3121  << 2) + 0xff620000)
// [31]    - parser_mpred_if_busy  -- Read Only
// [8]     - sao_sw_pred_enable
// [7]     - sao_top_save_even_no_sao
// [6]     - disable_parser_sao_if_clock_gating
// [5]     - parser_sao_if_en
// [4]     - scaler_if_leave_one_more_space
// [3]     - disable_parser_mpred_if_clock_gating
// [2]     - parser_mpred_if_en
// [1]     - disable_parser_scaler_if_clock_gating
// [0]     - parser_scaler_if_en
#define HEVC_PARSER_IF_CONTROL                     ((0x3122  << 2) + 0xff620000)
// [31:16] PicHeightInLumaSamples
// [15:0]  PicWidthInLumaSamples
#define HEVC_PARSER_PICTURE_SIZE                   ((0x3123  << 2) + 0xff620000)
// [31]    - start_lcu_mpred_cmd
// [30]    - lcu_decoding_start
// [29]    - do_not_wait_if_busy
// [23:0]  - lcu_idx
#define HEVC_PARSER_LCU_START                      ((0x3124  << 2) + 0xff620000)
// [31:30] - bit_depth_chroma_minus8
// [29:24] - MAX_QP
// [23:20] - qpBdOffsetC
// [19:16] - qpBdOffsetY
// [15:12] - pcm_sample_bit_depth_chroma
// [11:8]  - pcm_sample_bit_depth_luma
// [7:6]   - max_pcm_luma_coding_block_size
// [5:4]   - min_pcm_luma_coding_block_size
// [3:2]   - bit_depth_luma_minus8
// [1]     - enable_negative_quant
// [0]     - pcm_enabled_flag
#define HEVC_PARSER_HEADER_INFO2                   ((0x3125  << 2) + 0xff620000)
// Read Only
// bit[23]    - 1'b1
// bit[22]    - Reserved
// bit[21:16] - quant_V
// bit[15]    - 1'b1
// bit[14]    - Reserved
// bit[13:8]  - quant_U
// bit[7]     - 1'b1
// bit[6]     - Reserved
// bit[5:0]   - quant_Y
#define HEVC_PARSER_QUANT_READ                     ((0x3126  << 2) + 0xff620000)
#define HEVC_PARSER_RESERVED_27                    ((0x3127  << 2) + 0xff620000)
// bit[15:8]  - skip_addr_SaoOffData
// bit[7:0]   - skip_addr_SaoMerge
#define HEVC_PARSER_CMD_SKIP_0                     ((0x3128  << 2) + 0xff620000)
// bit[31:24] - skip_point_coding_unit_slice_type_RET
// bit[23:16] - skip_point_coding_unit_slice_type_B
// bit[15:8]  - skip_point_coding_unit_slice_type_P
// bit[7:0]   - skip_point_coding_unit_slice_type_I
#define HEVC_PARSER_CMD_SKIP_1                     ((0x3129  << 2) + 0xff620000)
// bit[31:24] - reserved
// bit[23:16] - skip_point_coding_unit_pred_mode_RET
// bit[15:8]  - skip_point_coding_unit_pred_mode_INTER
// bit[7:0]   - skip_point_coding_unit_pred_mode_INTRA
#define HEVC_PARSER_CMD_SKIP_2                     ((0x312a  << 2) + 0xff620000)
// Write :
// [24:16] context_addr for dec_Bin
// [15:0]  parser_cmd
// Read result:
// cabac_context_decodeBin,       // 31
// cabac_context_decodeBinEP,     // 30
// cabac_context_decodeBinTrm,    // 29
// cabac_context_decodeBinBit,    // 28
// parser_command,                // 27:22
// cabac_context_ready,           // 21
// cmd_status,                    // 20:16
// cabac_manual_data              // 15:0
//
#define HEVC_PARSER_MANUAL_CMD                     ((0x312b  << 2) + 0xff620000)
// bit [9:0] - Read address :
//          address 0-255 stream_fifo (128x64)
//          address 256-319 context_mem (256x7)
//          address 320-448 parser_cmd_mem (256x16)
#define HEVC_PARSER_MEM_RD_ADDR                    ((0x312c  << 2) + 0xff620000)
// bit [9:0] - Write address :
//          address 0-255 stream_fifo (128x64)
//          address 256-319 context_mem (256x7)
//          address 512-640 parser_cmd_mem (256x16)
#define HEVC_PARSER_MEM_WR_ADDR                    ((0x312d  << 2) + 0xff620000)
// bit[31:0] read/write data
#define HEVC_PARSER_MEM_RW_DATA                    ((0x312e  << 2) + 0xff620000)
// [31:20] sao_lcu_x
// [19:8]  sao_lcu_y
// [7] sao_lcu_xy_update
// [6:2] reserved
// [1] sao_wait_up_read
// [0] sao_wait_write
#define HEVC_SAO_IF_STATUS                         ((0x3130  << 2) + 0xff620000)
// Y_offset_3,    // 31:26
// Y_offset_2,    // 25:20
// Y_offset_1,    // 19:14
// Y_offset_0,    // 13:8
// Y_typeAuxInfo[3:0], // 7:4
// Y_typeIdc,     // 3:1 [0, 1, 2, 3]-EO, [4,5]-BO+Y_typeAuxInfo[4]
// Y_modelIdc     // 0
#define HEVC_SAO_IF_DATA_Y                         ((0x3131  << 2) + 0xff620000)
#define HEVC_SAO_IF_DATA_U                         ((0x3132  << 2) + 0xff620000)
#define HEVC_SAO_IF_DATA_V                         ((0x3133  << 2) + 0xff620000)
#define HEVC_STREAM_SWAP_ADDR                      ((0x3134  << 2) + 0xff620000)
// bit[31:24] - swap_wrrsp_count
// bit[23:16] - swap_d_count (Read Only)
// bit[15:8]  - swap_a_count (Read Only) (7:0 or 9:2)
// bit [7] - swap busy (Read Only)
// bit [6:4] - swap_d_count[10:8] (Read Only)
// bit [3] - swap_a_count[10] (Read Only)
// bit [2] - swap_wrrsp_count_update
// bit [1] - 1 - STORE to Memory, 0 - LOAD from Memory
// bit [0] - swap active
#define HEVC_STREAM_SWAP_CTRL                      ((0x3135  << 2) + 0xff620000)
#define HEVC_IQIT_IF_WAIT_CNT                      ((0x3136  << 2) + 0xff620000)
#define HEVC_MPRED_IF_WAIT_CNT                     ((0x3137  << 2) + 0xff620000)
#define HEVC_SAO_IF_WAIT_CNT                       ((0x3138  << 2) + 0xff620000)
// [31:0] packet_length_count
#define HEVC_STREAM_PACKET_LENGTH                  ((0x3139  << 2) + 0xff620000)
// [31]   data_length_protect_enable
// [30]   data_protect_fill_00_enable
// [29]   data_protect_fill_ff_enable
// [28:19] Reserved
// [18:0] data_length_protect_count
#define HEVC_SHIFT_LENGTH_PROTECT                  ((0x313a  << 2) + 0xff620000)
// bit[3:0] parser_debug_idx
#define HEVC_PARSER_DEBUG_IDX                      ((0x313e  << 2) + 0xff620000)
// bit[31:0] parser_debug_dat -- read only
#define HEVC_PARSER_DEBUG_DAT                      ((0x313f  << 2) + 0xff620000)
// bit[22]    - vp9_second_pu_use_if_busy_2
// bit[21]    - parser_mpred_if_busy_when_pu_mpred_busy
// bit[20:9]  - Reserved
// bit[8]   - force_skip_1 (SEG_LVL_SKIP)
// bit[7:3] - vp9_status
// bit[2] - change_vp9_status
// bit[1] - vp9_decode_start(W)/vp9_decode_busy
// bit[0] - vp9_enable
#define VP9_CONTROL                                ((0x3140  << 2) + 0xff620000)
// bit[15:8]- vp9_emd_cmd_parameter
// bit[3]   - vp9_emd_cmd_busy
// bit[2:0] - vp9_emd_command (bit[7]-start/busy)
//            0 - vp9_read
//                   (
//                      input : bit[15:8] - prob,
//                              bit[7:4] - vp9_read_literal_bits(1-16 bits)
//                      output : bit[31:16] - result)
//                   )
//            1 - vp9_diff_update_prob
//                   (
//                      input : bit[7:4] - function:
// `define vp9_read_tx_mode_prob     0
// `define vp9_read_coef_prob        1
// `define vp9_read_skip_prob        2
// `define vp9_read_inter_mode_prob  3
// `define vp9_read_interp_prob      4
// `define vp9_read_intra_inter_prob 5
// `define vp9_read_comp_inter_prob  6
// `define vp9_read_comp_ref_prob    7
// `define vp9_read_single_ref_prob  8
// `define vp9_read_if_y_mode_prob   9
// `define vp9_read_partition_prob  10
// `define vp9_read_mv_prob         11
//                              bit[29:16] - total loop times
//                              bit[31:30] - probs_common
//                      output : bit[15:8] - prob)
//                   )
#define VP9_EMD_CMD                                ((0x3141  << 2) + 0xff620000)
// vp9_top_y_mode[31:0]
#define VP9_TOP_Y_MODE_0                           ((0x3142  << 2) + 0xff620000)
// vp9_top_y_mode[63:32]
#define VP9_TOP_Y_MODE_1                           ((0x3143  << 2) + 0xff620000)
// vp9_left_y_mode[31:0]
#define VP9_LEFT_Y_MODE_0                          ((0x3144  << 2) + 0xff620000)
// vp9_left_y_mode[63:32]
#define VP9_LEFT_Y_MODE_1                          ((0x3145  << 2) + 0xff620000)
// bit[31] - 0:write_vp9_quant, 1:write_vp9_seg_feature
// For write_vp9_seg_feature:
// bit[24:22] - seg_id
// bit[21]    - seg_q_enable
// bit[20]    - seg_q_sign
// bit[19:12] - seg_q_abs
// bit[11]    - seg_lf_enable
// bit[10]    - seg_lf_sign
// bit[9:4]   - seg_lf_abs
// bit[3]     - seg_ref_enable
// bit[2:1]   - seg_ref_abs
// bit[0]     - seg_skip_enable
// For write_vp9_quant:
// bit[19:16] - Write index : Seg_0_Y-0, Seg_0_UV-1, ... Seq_7_Y-14, Seq_7_UV-15
// bit[15:8] - AC quant
// bit[7:0]  - DC quant
#define VP9_QUANT_WR                               ((0x3146  << 2) + 0xff620000)
// bit [31:16] - vp9_inter_mode_top/{8'h0, vp9_seg_pred_top}
// bit [15:0] - vp9_top_tx_mode (odd/even mi has same tx_mode)
#define HEVC_CABAC_TOP_INFO_3                      ((0x3147  << 2) + 0xff620000)
// bit [31:16] - vp9_inter_mode_left/{8'h0, vp9_seg_pred_left}
// bit [15:0] - vp9_left_tx_mode (odd/even mi has same tx_mode)
#define HEVC_CABAC_LEFT_INFO_3                     ((0x3148  << 2) + 0xff620000)
// bit [31:16] - ref_frame[1]
// bit [15:0]  - ref_frame[0]
#define HEVC_CABAC_TOP_INFO_4                      ((0x3149  << 2) + 0xff620000)
// bit [31:16] - ref_frame[1]
// bit [15:0]  - ref_frame[0]
#define HEVC_CABAC_LEFT_INFO_4                     ((0x314a  << 2) + 0xff620000)
// bit [31:16]  - interp_filter
// bit [15:8]   - Reserved
// bit [7:0]    - vp9_seg_pred_top
#define HEVC_CABAC_TOP_INFO_5                      ((0x314b  << 2) + 0xff620000)
// bit [31:16]  - interp_filter
// bit [15:8]   - Reserved
// bit [7:0]    - vp9_seg_pred_left
#define HEVC_CABAC_LEFT_INFO_5                     ((0x314c  << 2) + 0xff620000)
// bit[31]    - operation start (read : busy)
// bit[30:28] - operation_endian
// bit[27:24] - Reserved
// bit[23:22] - operation_mem 00:prob_mem, 01:count_mem
// bit[21:20] - operation_cmd 0:clear, 1-store, 2-load
// bit[19:10] - operation_end_addr
// bit[9:0] - operation_start_addr
#define VP9_MEM_OPERATION                          ((0x314d  << 2) + 0xff620000)
// bit[27]    - vp9_seg_pred_info_3
// bit[26]    - vp9_seg_abs_delta
// bit[25]    - vp9_seg_temporal
// bit[24]    - vp9_seg_update_map
// bit[23]    - vp9_seg_enable
// bit[22]    - vp9_lossless_use_set
// bit[21]    - vp9_lossless_set_data
// bit[20]    - vp9_swap_Y_MODE_with_INFO45
// bit[19]    - vp9_allow_hp
// bit[18:16] - vp9_interp_filter
// bit[15]    - vp9_intra_frame
// bit[14:12] - vp9_tx_mode
// bit[11:10] - vp9_ref_mode // SINGLE_REFERENCE(0), COMPOUND_REFERENCE(1), REFERENCE_MODE_SELECT(2)
// bit[9]   - VPX_BITS_10
// bit[8] - ref_frame_bias[2]
// bit[7] - ref_frame_bias[1]
// bit[6] - ref_frame_bias[0]
// [5:4] - comp_var_ref[1]
// [3:2] - comp_var_ref[0]
// [1:0] - comp_fixed_ref
#define VP9_DECODING_INFO                          ((0x314f  << 2) + 0xff620000)
// [7]   -- segment_id_map_from_shadow
// [6]   -- segment_id_map_to_shadow
// [5]   -- shadow_rw_addr_update
// [4:0] -- shadow_rw_addr
#define VP9_SHADOW_CTRL                            ((0x3150  << 2) + 0xff620000)
// [31:0] -- shadow_rw_data
#define VP9_SHADOW_DATA                            ((0x3151  << 2) + 0xff620000)
// bit[22]    - avs2_second_pu_use_if_busy_2
// bit[21]    - parser_mpred_if_busy_when_pu_mpred_busy
// bit[20:9]  - Reserved
// bit[8]   - force_skip_1 (SEG_LVL_SKIP)
// bit[7:3] - avs2_status
// bit[2] - change_avs2_status
// bit[1] - avs2_decode_start(W)/avs2_decode_busy
// bit[0] - avs2_enable
#define AVS2_CONTROL                               ((0x3152  << 2) + 0xff620000)
// bit[7] - useNSIP (nonsquare_intra_prediction_enable)
// bit[6] - secT_enabled (secondary_transform_enable_flag)
// bit[5] - slice_alf_enable_Y
// bit[4] - slice_alf_enable_U
// bit[3] - slice_alf_enable_V
// bit[2] - slice_sao_enable_Y
// bit[1] - slice_sao_enable_U
// bit[0] - slice_sao_enable_V
#define AVS2_DEC_INFO                              ((0x3153  << 2) + 0xff620000)
//
// Closing file:  hevc_parser_regs.h
//
//------------------------------------------------------------------------------
// HEVC_MPRED module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  hevc_mpred_regs.h
//
// -----------------------------------------------
// CBUS_BASE:  DOS_HEVC_MPRED_CBUS_BASE = 0x02
// -----------------------------------------------
#define HEVC_MPRED_VERSION                         ((0x3200  << 2) + 0xff620000)
//  [31:0]  reversion               default:32'h00010001
#define HEVC_MPRED_CTRL0                           ((0x3201  << 2) + 0xff620000)
// [1:0]    slice_type[1:0]
// [2]      new_pic
// [3]      new_tile
// [4]      SliceSegment
// [5]      TMVPFlag_en
// [6]      LDCFlag
// [7]      ColFromL0Flag
// [8]      reserved
// [9]      above_en
// [10]     mv_wr_en  :collocated MV write enable: 0=no-write,1=write;default:1'b1
// [11]     mv_rd_en
// [12]     col_isIntra
// [13]     reserved
// [14]     LongTerm_Curr
// [15]     LongTerm_Col
// [19:16]  lcu_size_log2[3:0]
// [23:20]  cu_size_log2[3:0]
// [26:24]  plevel[2:0]
// [31:27]  reserved
#define HEVC_MPRED_CTRL1                           ((0x3202  << 2) + 0xff620000)
//  [3:0]   MERGE_MAX_NUM_CANDS[3:0]
//  [7:4]   AMVP_MAX_NUM_CANDS[3:0]
//  [23:8]  reserved
//  [24]    clk_forceon
//  [31:25] reserved
#define HEVC_MPRED_INT_EN                          ((0x3203  << 2) + 0xff620000)
//  [0]     mpred_int_enable
//  [1]     mpred_int_amrisc_level
//  [2]     mpred_int_cpu_level
//  [3]     slice_done_int_amrisc_enable
//  [4]     slice_done_int_cpu_enable
//  [15]    disable_mpred_int_clock_gating
#define HEVC_MPRED_INT_STATUS                      ((0x3204  << 2) + 0xff620000)
//  [0]     slice_done IRQ
//  [31]    write "1"=slice start(self clear,read always return "0")
#define HEVC_MPRED_PIC_SIZE                        ((0x3205  << 2) + 0xff620000)
//  [15:0]  pic_width[15:0]
//  [31:16] pic_height[15:0]
#define HEVC_MPRED_PIC_SIZE_LCU                    ((0x3206  << 2) + 0xff620000)
//  [15:0]  lcu_x_num_1[15:0]   (=lcu_x_total-1)
//  [31:16] lcu_y_num_1[15:0]   (=lcu_y_total-1)
#define HEVC_MPRED_TILE_START                      ((0x3207  << 2) + 0xff620000)
//  [15:0]  tile_start_lcu_x[15:0]
//  [31:16] tile_start_lcu_y[15:0]
#define HEVC_MPRED_TILE_SIZE_LCU                   ((0x3208  << 2) + 0xff620000)
//  [15:0]  tile_width_lcu[15:0]
//  [31:16] tile_height_lcu[15:0]
#define HEVC_MPRED_REF_NUM                         ((0x3209  << 2) + 0xff620000)
//  [3:0]   refNum_L0[3:0]
//  [11:8]  refNum_L1[3:0]
//  [19:16] col_refNum_L0[3:0]
//  [27:24] col_refNum_L1[3:0]
#define HEVC_MPRED_LT_REF                          ((0x320a  << 2) + 0xff620000)
//  [00]    LongTerm_L0_Ref00
//  [01]    LongTerm_L0_Ref01
//  ......
//  [15]    LongTerm_L0_Ref15
//  [16]    LongTerm_L1_Ref00
//  [17]    LongTerm_L1_Ref01
//  ......
//  [31]    LongTerm_L1_Ref15
#define HEVC_MPRED_LT_COLREF                       ((0x320b  << 2) + 0xff620000)
//  [00]    LongTerm_Col_L0_Ref00
//  [01]    LongTerm_Col_L0_Ref01
//  ......
//  [15]    LongTerm_Col_L0_Ref15
//  [16]    LongTerm_Col_L1_Ref00
//  [17]    LongTerm_Col_L1_Ref01
//  ......
//  [31]    LongTerm_Col_L1_Ref15
#define HEVC_MPRED_REF_EN_L0                       ((0x320c  << 2) + 0xff620000)
//  [00]    L0_ref00_en
//  [01]    L0_ref01_en
//  ......
//  [15]    L0_ref15_en
#define HEVC_MPRED_REF_EN_L1                       ((0x320d  << 2) + 0xff620000)
//  [00]    L1_ref00_en
//  [01]    L1_ref01_en
//  ......
//  [15]    L1_ref15_en
#define HEVC_MPRED_COLREF_EN_L0                    ((0x320e  << 2) + 0xff620000)
//  [00]    COL_L0_ref00_en
//  [01]    COL_L0_ref01_en
//  ......
//  [15]    COL_L0_ref15_en
#define HEVC_MPRED_COLREF_EN_L1                    ((0x320f  << 2) + 0xff620000)
//  [00]    COL_L1_ref00_en
//  [01]    COL_L1_ref01_en
//  ......
//  [15]    COL_L1_ref15_en
#define HEVC_MPRED_AXI_WCTRL                       ((0x3210  << 2) + 0xff620000)
//  [11:8]  aw_id_set[3:0]
#define HEVC_MPRED_AXI_RCTRL                       ((0x3211  << 2) + 0xff620000)
//  [11:8]  ar_id_set[3:0]
#define HEVC_MPRED_ABV_START_ADDR                  ((0x3212  << 2) + 0xff620000)
#define HEVC_MPRED_MV_WR_START_ADDR                ((0x3213  << 2) + 0xff620000)
#define HEVC_MPRED_MV_RD_START_ADDR                ((0x3214  << 2) + 0xff620000)
#define HEVC_MPRED_MV_WPTR                         ((0x3215  << 2) + 0xff620000)
#define HEVC_MPRED_MV_RPTR                         ((0x3216  << 2) + 0xff620000)
#define HEVC_MPRED_MV_WR_ROW_JUMP                  ((0x3217  << 2) + 0xff620000)
#define HEVC_MPRED_MV_RD_ROW_JUMP                  ((0x3218  << 2) + 0xff620000)
#define HEVC_MPRED_CURR_LCU                        ((0x3219  << 2) + 0xff620000)
#define HEVC_MPRED_ABV_WPTR                        ((0x321a  << 2) + 0xff620000)
#define HEVC_MPRED_ABV_RPTR                        ((0x321b  << 2) + 0xff620000)
#define HEVC_MPRED_CTRL2                           ((0x321c  << 2) + 0xff620000)
#define HEVC_MPRED_CTRL3                           ((0x321d  << 2) + 0xff620000)
#define HEVC_MPRED_MV_WLCUY                        ((0x321e  << 2) + 0xff620000)
#define HEVC_MPRED_MV_RLCUY                        ((0x321f  << 2) + 0xff620000)
#define HEVC_MPRED_L0_REF00_POC                    ((0x3220  << 2) + 0xff620000)
#define HEVC_MPRED_L0_REF01_POC                    ((0x3221  << 2) + 0xff620000)
#define HEVC_MPRED_L0_REF02_POC                    ((0x3222  << 2) + 0xff620000)
#define HEVC_MPRED_L0_REF03_POC                    ((0x3223  << 2) + 0xff620000)
#define HEVC_MPRED_L0_REF04_POC                    ((0x3224  << 2) + 0xff620000)
#define HEVC_MPRED_L0_REF05_POC                    ((0x3225  << 2) + 0xff620000)
#define HEVC_MPRED_L0_REF06_POC                    ((0x3226  << 2) + 0xff620000)
#define HEVC_MPRED_L0_REF07_POC                    ((0x3227  << 2) + 0xff620000)
#define HEVC_MPRED_L0_REF08_POC                    ((0x3228  << 2) + 0xff620000)
#define HEVC_MPRED_L0_REF09_POC                    ((0x3229  << 2) + 0xff620000)
#define HEVC_MPRED_L0_REF10_POC                    ((0x322a  << 2) + 0xff620000)
#define HEVC_MPRED_L0_REF11_POC                    ((0x322b  << 2) + 0xff620000)
#define HEVC_MPRED_L0_REF12_POC                    ((0x322c  << 2) + 0xff620000)
#define HEVC_MPRED_L0_REF13_POC                    ((0x322d  << 2) + 0xff620000)
#define HEVC_MPRED_L0_REF14_POC                    ((0x322e  << 2) + 0xff620000)
#define HEVC_MPRED_L0_REF15_POC                    ((0x322f  << 2) + 0xff620000)
#define HEVC_MPRED_L1_REF00_POC                    ((0x3230  << 2) + 0xff620000)
#define HEVC_MPRED_L1_REF01_POC                    ((0x3231  << 2) + 0xff620000)
#define HEVC_MPRED_L1_REF02_POC                    ((0x3232  << 2) + 0xff620000)
#define HEVC_MPRED_L1_REF03_POC                    ((0x3233  << 2) + 0xff620000)
#define HEVC_MPRED_L1_REF04_POC                    ((0x3234  << 2) + 0xff620000)
#define HEVC_MPRED_L1_REF05_POC                    ((0x3235  << 2) + 0xff620000)
#define HEVC_MPRED_L1_REF06_POC                    ((0x3236  << 2) + 0xff620000)
#define HEVC_MPRED_L1_REF07_POC                    ((0x3237  << 2) + 0xff620000)
#define HEVC_MPRED_L1_REF08_POC                    ((0x3238  << 2) + 0xff620000)
#define HEVC_MPRED_L1_REF09_POC                    ((0x3239  << 2) + 0xff620000)
#define HEVC_MPRED_L1_REF10_POC                    ((0x323a  << 2) + 0xff620000)
#define HEVC_MPRED_L1_REF11_POC                    ((0x323b  << 2) + 0xff620000)
#define HEVC_MPRED_L1_REF12_POC                    ((0x323c  << 2) + 0xff620000)
#define HEVC_MPRED_L1_REF13_POC                    ((0x323d  << 2) + 0xff620000)
#define HEVC_MPRED_L1_REF14_POC                    ((0x323e  << 2) + 0xff620000)
#define HEVC_MPRED_L1_REF15_POC                    ((0x323f  << 2) + 0xff620000)
#define HEVC_MPRED_PIC_SIZE_EXT                    ((0x3240  << 2) + 0xff620000)
#define HEVC_MPRED_DBG_MODE0                       ((0x3241  << 2) + 0xff620000)
#define HEVC_MPRED_DBG_MODE1                       ((0x3242  << 2) + 0xff620000)
#define HEVC_MPRED_DBG2_MODE                       ((0x3243  << 2) + 0xff620000)
#define HEVC_MPRED_IMP_CMD0                        ((0x3244  << 2) + 0xff620000)
#define HEVC_MPRED_IMP_CMD1                        ((0x3245  << 2) + 0xff620000)
#define HEVC_MPRED_IMP_CMD2                        ((0x3246  << 2) + 0xff620000)
#define HEVC_MPRED_IMP_CMD3                        ((0x3247  << 2) + 0xff620000)
#define HEVC_MPRED_DBG2_DATA_0                     ((0x3248  << 2) + 0xff620000)
#define HEVC_MPRED_DBG2_DATA_1                     ((0x3249  << 2) + 0xff620000)
#define HEVC_MPRED_DBG2_DATA_2                     ((0x324a  << 2) + 0xff620000)
#define HEVC_MPRED_DBG2_DATA_3                     ((0x324b  << 2) + 0xff620000)
#define HEVC_MPRED_CTRL4                           ((0x324c  << 2) + 0xff620000)
//  [0]     above intermedia data compress: 0=no-compress,1=compress;default:1'b0
//  [1]     collocated MV intermedia data compress: 0=no-compress,1=compress;default:1'b0
//  [2]     vp9_mode,0=hevc_mode,1=vp9_mode,default=0
//  [6]     vp9_use_prev_frame_mvs  0=not allow vp9_use_prev_frame_mvs,1=allow vp9_use_prev_frame_mvs,default=0
//  [8]     vp9_not_allow_hp    0=vp9_allow_hp,1=vp9_not_allow_hp,default=0
//  [9]     vp9_is_compound     0=vp9_is_not_compound,1=vp9_is_compound,default=0
//  [12]    vp9_ref_sign_bias[1]        ref1(last) ref_sign_bias, default=0
//  [13]    vp9_ref_sign_bias[2]        ref2(golden) ref_sign_bias,default=0
//  [14]    vp9_ref_sign_bias[3]        ref3(altref) ref_sign_bias,default=0
#define HEVC_MPRED_CTRL5                           ((0x324d  << 2) + 0xff620000)
#define HEVC_MPRED_POC24_CTRL0                     ((0x324e  << 2) + 0xff620000)
#define HEVC_MPRED_POC24_CTRL1                     ((0x324f  << 2) + 0xff620000)
#define HEVC_MPRED_DBG_DATA_0                      ((0x3250  << 2) + 0xff620000)
#define HEVC_MPRED_DBG_DATA_1                      ((0x3251  << 2) + 0xff620000)
#define HEVC_MPRED_DBG_DATA_2                      ((0x3252  << 2) + 0xff620000)
#define HEVC_MPRED_DBG_DATA_3                      ((0x3253  << 2) + 0xff620000)
#define HEVC_MPRED_DBG_DATA_4                      ((0x3254  << 2) + 0xff620000)
#define HEVC_MPRED_DBG_DATA_5                      ((0x3255  << 2) + 0xff620000)
#define HEVC_MPRED_DBG_DATA_6                      ((0x3256  << 2) + 0xff620000)
#define HEVC_MPRED_DBG_DATA_7                      ((0x3257  << 2) + 0xff620000)
#define HEVC_MPRED_CTRL6                           ((0x3258  << 2) + 0xff620000)
#define HEVC_MPRED_CTRL7                           ((0x3259  << 2) + 0xff620000)
#define HEVC_MPRED_CTRL8                           ((0x325a  << 2) + 0xff620000)
#define HEVC_MPRED_CTRL9                           ((0x325b  << 2) + 0xff620000)
#define HEVC_MPRED_CUR_POC                         ((0x3260  << 2) + 0xff620000)
#define HEVC_MPRED_COL_POC                         ((0x3261  << 2) + 0xff620000)
#define HEVC_MPRED_MV_RD_END_ADDR                  ((0x3262  << 2) + 0xff620000)
//
// Closing file:  hevc_mpred_regs.h
//
//------------------------------------------------------------------------------
// HEVC_IPP module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  hevc_ipp_regs.h
//
// John A. Thodiyil
// Register map for intra/inter/pcm pixel-prediction + MCRCC + DECOMP
// August 14th, 2013
// -----------------------------------------------
// CBUS_BASE:  DOS_HEVC_IPP_CBUS_BASE = 0x04
// -----------------------------------------------
#define HEVCD_IPP_TOP_CNTL                         ((0x3400  << 2) + 0xff620000)
// [0]      -- software reset ipp and mpp
// [1]      -- enable ipp
// [3:2]    -- reserved
// [5:4]    -- codec[1:0] 00:hevc 01:vp9 10:avs2 11:reserved
// [31:6]   -- reserved
#define HEVCD_IPP_TOP_STATUS                       ((0x3401  << 2) + 0xff620000)
// [0]      -- ready for next tile/frame
// [1]      -- ready for next ctb
// [2]      -- ready for next slice
// [3]      -- reserved
// [4]      -- ipp_axi_rd_idle
// [5]      -- ipp_axi_wr_idle
// [6]      -- mpp_axi_rd_idle
// [31:7]   -- reserved
#define HEVCD_IPP_TOP_FRMCONFIG                    ((0x3402  << 2) + 0xff620000)
// [14:0]   -- frame width in luma pixels
// [30:16]  -- frame height in luma pixels
#define HEVCD_IPP_TOP_TILECONFIG1                  ((0x3403  << 2) + 0xff620000)
// [11:0]   -- tile_width_in_lcu
// [27:16]  -- tile_height_in_lcu
#define HEVCD_IPP_TOP_TILECONFIG2                  ((0x3404  << 2) + 0xff620000)
// [11:0]   -- tile_offset_x_in_lcu
// [27:16]  -- tile_offset_y_in_lcu
#define HEVCD_IPP_TOP_TILECONFIG3                  ((0x3405  << 2) + 0xff620000)
// [0]      -- tiles_enabled_flag
// [31:1]   -- reserved
#define HEVCD_IPP_TOP_LCUCONFIG                    ((0x3406  << 2) + 0xff620000)
// [6:0]    -- lcu size in pixels
#define HEVCD_IPP_TOP_FRMCTL                       ((0x3407  << 2) + 0xff620000)
// [x]      -- start ipp tile decode
#define HEVCD_IPP_CONFIG                           ((0x3408  << 2) + 0xff620000)
// [0]      -- ipp_strong_intra_smoothing_enable_flag
// [1]      -- cfg_ipp_constrained_intra_pred_flag
// [31:2]   -- reserved
#define HEVCD_IPP_LINEBUFF_BASE                    ((0x3409  << 2) + 0xff620000)
// [31:14]  -- intra-prediction line-buffer 16KByte axi address
// [13:0]   -- reserved
#define HEVCD_IPP_INTR_MASK                        ((0x340a  << 2) + 0xff620000)
// [0]      -- tile/frame ready
// [1]      -- ctb ready
// [2]      -- slice ready
// [31:3]   -- reserved
#define HEVCD_IPP_AXIIF_CONFIG                     ((0x340b  << 2) + 0xff620000)
// [3:0]    -- little_endian
// [5:4]    -- address_format 00:linear 01:32x32 10:64x32
// [7:6]    -- reserved
// [9:8]    -- Linear_LineAlignment 00:16byte 01:32byte 10:64byte
// [11:10]  -- reserved
// [12]     -- CbCr_byte_swap
// [31:13]  -- reserved
#define HEVCD_IPP_BITDEPTH_CONFIG                  ((0x340c  << 2) + 0xff620000)
// [1:0]    -- bit_depth_luma   00:8 01:9 10:10
// [3:2]    -- bit_depth_chroma 00:8 01:9 10:10
// [31:4]   -- reserved
#define HEVCD_IPP_SWMPREDIF_CONFIG                 ((0x3410  << 2) + 0xff620000)
// [0]      -- swmpredif_enable
// [31:1]   -- reserved
#define HEVCD_IPP_SWMPREDIF_STATUS                 ((0x3411  << 2) + 0xff620000)
// [0]      -- swmpredif_rdy
// [7:1]    -- reserved
// [14:8]   -- swmpredif_fifospace
// [31:15]  -- reserved
#define HEVCD_IPP_SWMPREDIF_CTBINFO                ((0x3412  << 2) + 0xff620000)
// [10:0]   -- swmpredif_ctb_x
// [15:11]  -- reserved
// [26:16]  -- swmpredif_ctb_y
// [30:27]  -- reserved
// [31]     -- swmpredif_newslice
#define HEVCD_IPP_SWMPREDIF_PUINFO0                ((0x3413  << 2) + 0xff620000)
// [31:0]   -- swmpredif_imp_cmd[31:0]
#define HEVCD_IPP_SWMPREDIF_PUINFO1                ((0x3414  << 2) + 0xff620000)
// [31:0]   -- swmpredif_imp_cmd[63:32]
#define HEVCD_IPP_SWMPREDIF_PUINFO2                ((0x3415  << 2) + 0xff620000)
// [31:0]   -- swmpredif_imp_cmd[95:64]
#define HEVCD_IPP_SWMPREDIF_PUINFO3                ((0x3416  << 2) + 0xff620000)
// [31:0]   -- swmpredif_imp_cmd[127:96]
#define HEVCD_IPP_SWMPREDIF_PUINFO4                ((0x3417  << 2) + 0xff620000)
// [31:0]   -- swmpredif_imp_cmd[159:128]
#define HEVCD_IPP_SWMPREDIF_PUINFO5                ((0x3418  << 2) + 0xff620000)
// [31:0]   -- swmpredif_imp_cmd[191:160]
//          writing to HEVCD_IPP_SWMPREDIF_PUINFO5
//          completes command, should be last to write.
#define HEVCD_IPP_DYNCLKGATE_CONFIG                ((0x3420  << 2) + 0xff620000)
// [0]      -- mpp_wpredict_clkgate_disbl
// [1]      -- mpp_ref_fetch_clkgate_disbl
// [2]      -- mpp_interpol_top_clkgate_disbl
// [3]      -- mpp_4x4mcr_clkgate_disbl
// [4]      -- mpp_ref_pack_clkgate_disbl
// [5]      -- mpp_mdec_if_clkgate_disbl
// [7:6]    -- reserved
// [8]      -- ipp_res_fetch_clkgate_disbl
// [9]      -- ipp_iqitIf_clkgate_disbl
// [10]     -- ipp_dblkCmdIf_clkgate_disbl
// [11]     -- ipp_dblkIf_clkgate_disbl
// [12]     -- ipp_cntl_clkgate_disbl
// [13]     -- ipp_nsamples_proc_clkgate_disbl
// [14]     -- ipp_refroute_clkgate_disbl
// [15]     -- ipp_spread_clkgate_disbl
// [16]     -- ipp_reg_clkgate_disbl
// [17]     -- ipp_recon_clkgate_disbl
// [19:18]  -- reserved
// [20]     -- decomp_cntl_clkgate_disbl
// [21]     -- decomp_axiIf_clkgate_disbl
// [22]     -- decomp_dcache_clkgate_disbl
// [23]     -- decomp_hcache_clkgate_disbl
// [24]     -- decomp_gearup_clkgate_disbl
// [25]     -- decomp_cores_clkgate_disbl
// [26]     -- decomp_rdroute_clkgate_disbl
// [27]     -- reserved
// [28]     -- master_decomp_clkgate_disbl
// [29]     -- master_mpp_clkgate_disbl
// [30]     -- master_ipp_clkgate_disbl
// [31]     -- master_ipp_mpp_decomp_clkgate_disbl
#define HEVCD_IPP_DYNCLKGATE_STATUS                ((0x3421  << 2) + 0xff620000)
// [0]      -- mpp_wpredict_clkgate
// [1]      -- mpp_ref_fetch_clkgate
// [2]      -- mpp_interpol_top_clkgate
// [3]      -- mpp_4x4mcr_clkgate
// [4]      -- mpp_ref_pack_clkgate
// [5]      -- mpp_mdec_if_clkgate
// [7:6]    -- reserved
// [8]      -- ipp_res_fetch_clkgate
// [9]      -- ipp_iqitIf_clkgate
// [10]     -- ipp_dblkCmdIf_clkgate
// [11]     -- ipp_dblkIf_clkgate
// [12]     -- ipp_cntl_clkgate
// [13]     -- ipp_nsamples_proc_clkgate
// [14]     -- ipp_refroute_clkgate
// [15]     -- ipp_spread_clkgate
// [16]     -- ipp_reg_clkgate
// [17]     -- ipp_recon_clkgate
// [19:18]  -- reserved
// [20]     -- decomp_cntl_clkgate
// [21]     -- decomp_axiIf_clkgate
// [22]     -- decomp_dcache_clkgate
// [23]     -- decomp_hcache_clkgate
// [24]     -- decomp_gearup_clkgate
// [25]     -- decomp_cores_clkgate
// [26]     -- decomp_rdroute_clkgate
// [27]     -- reserved
// [30:28]  -- reserved
// [31]     -- mcrcc_axi_clkgate
#define HEVCD_IPP_DBG_SEL                          ((0x3430  << 2) + 0xff620000)
// [3:0]    -- module_level_sel
// [7:4]    -- mpp_ipp_top_level
// [8]      -- ipp_sel
// [31:9]   -- reserved
#define HEVCD_IPP_DBG_DATA                         ((0x3431  << 2) + 0xff620000)
// [31:0]   -- Debug information
//////////////////////////////////////////////////////////////////////////////
///// MPP Registers                                       ////////////////////
//////////////////////////////////////////////////////////////////////////////
// Canvas Anchor to Axi-Address translation table
#define HEVCD_MPP_ANC2AXI_TBL_CONF_ADDR            ((0x3460  << 2) + 0xff620000)
// [0]      -- anc2axi canvas address translation table switch 0:sw 1:hw
// [1]      -- access type 1:wr 0:rd
// [2]      -- auto index increment
// [7:3]    -- reserved
// [15:8]   -- start index
// [31:16]  -- reserved
//`define     HEVCD_MPP_ANC2AXI_TBL_CMD_ADDR         8'h61
// [0]      -- anc2axi canvas address translation table access type 1:wr 0:rd
// [15:8]   -- anc2axi canvas address translation table access index
// [31:16]  -- anc2axi canvas address translation table access write data, 16KByte axi address
//          -- obsoleted
//`define     HEVCD_MPP_ANC2AXI_TBL_WDATA_ADDR       8'h62   // NU
// [x]      -- not used
//`define     HEVCD_MPP_ANC2AXI_TBL_RDATA_ADDR       8'h63
// [15:0]   -- anc2axi canvas address translation table access read data
//          -- obsoleted
#define HEVCD_MPP_ANC2AXI_TBL_DATA                 ((0x3464  << 2) + 0xff620000)
// [26:0]   -- anc2axi address r/w  32byte aligned
// [31:27]  -- reserved
#define HEVCD_MPP_WEIGHTPRED_CNTL_ADDR             ((0x347b  << 2) + 0xff620000)
// [0]      -- weighted_pred_flag
#define HEVCD_MPP_L0_WEIGHT_FLAG_ADDR              ((0x347c  << 2) + 0xff620000)
// [15:0]   -- luma_weght_flag0[15:0], indexed by refidx0
// [31:16]  -- chroma_weght_flag0[15:0], indexed by refidx0
#define HEVCD_MPP_L1_WEIGHT_FLAG_ADDR              ((0x347d  << 2) + 0xff620000)
// [15:0]   -- luma_weght_flag1[15:0], indexed by refidx1
// [31:16]  -- chroma_weght_flag1[15:0], indexed by refidx1
#define HEVCD_MPP_YLOG2WGHTDENOM_ADDR              ((0x347e  << 2) + 0xff620000)
// [3:0]    -- luma_log2_weight_denom
#define HEVCD_MPP_DELTACLOG2WGHTDENOM_ADDR         ((0x347f  << 2) + 0xff620000)
// [4:0]    -- delta_chroma_log2_weight_denom
#define HEVCD_MPP_WEIGHT_ADDR                      ((0x3480  << 2) + 0xff620000)
// [5:0]    -- weight_rw_addr
// [0]      -- DELTA_WEIGHT0
// [1]      -- OFFSET0
// [2]      -- DELTA_WEIGHT1
// [3]      -- OFFSET1
// ......
// [62]     -- DELTA_WEIGHT31
// [63]     -- OFFSET31
#define HEVCD_MPP_WEIGHT_DATA                      ((0x3481  << 2) + 0xff620000)
// For DELTA_WEIGHT :
// [7:0]    -- delta_y_weight for refidx0:0
// [15:8]   -- delta_cb_weight for refidx0:0
// [23:16]  -- delta_cr_weight for refidx0:0
// For OFFSET :
// [7:0]    -- luma_offset for refidx0:0
// [17:8]   -- delta_cb_offset for refidx0:0
// [27:18]  -- delta_cr_offset for refidx0:0
// ID to Anchor-Canvas-Address table
// [31:13]  reserved
// [12:8]   access_index
// [7:2]    reserved
// [1]      auto_inc_read
// [0]      auto_inc_write
#define HEVCD_MPP_ANC_CANVAS_ACCCONFIG_ADDR        ((0x34c0  << 2) + 0xff620000)
// Id[4:0]  --> {AnchorAddrCr[7:0],AnchorAddrCb[7:0],AnchorAddrY[7:0]}
#define HEVCD_MPP_ANC_CANVAS_DATA_ADDR             ((0x34c1  << 2) + 0xff620000)
// [0]       -- decomp_nocompress
// [1]       -- decomp_dcache_bypass
// [2]       -- reserved
// [3]       -- decomp_smem_bdepth888
// [4]       -- decomp_paged_mem_mode
// [30:5]    -- reserved
// [31]      -- decomp_axif_lbmode888
#define HEVCD_MPP_DECOMP_CTL1                      ((0x34c2  << 2) + 0xff620000)
// [23:0]    -- header1_offset : 32byte address from canvas base
// [31:24]   -- reserved
#define HEVCD_MPP_DECOMP_CTL2                      ((0x34c3  << 2) + 0xff620000)
// [9:0]     -- decomp_default_Y
// [19:10]   -- decomp_default_Cb
// [29:20]   -- decomp_default_Cr
// [31:30]   -- bitdepth_sel 00:8bit 01:9bit 10:10bit
#define HEVCD_MPP_DECOMP_CTL3                      ((0x34c4  << 2) + 0xff620000)
// HEVCD_MPP_DECOMP_PERFMON_CTL
// [0]      percount_reset
// [3:1]    perfcount_sel
// [31:4]   reserved
// {1'b0,perfcount_sel[1:0]}    perfcount
//     0                        raw_hcache_cnt
//     1                        hit_hcache_cnt
//     2                        raw_dcache_cnt
//     3                        hit_dcache_cnt
// {1'b1,perfcount_sel[1:0]}    perfcount
//     0                        fast_num_compburst
//     1                        slow_num_compburst
//     2,3                      raw_num_ncompburst
#define HEVCD_MPP_DECOMP_PERFMON_CTL               ((0x34c5  << 2) + 0xff620000)
// HEVCD_MPP_DECOMP_PERFMON_DATA
// [31:0]   percount_data
#define HEVCD_MPP_DECOMP_PERFMON_DATA              ((0x34c6  << 2) + 0xff620000)
// HEVCD_MPP_DECOMP_AXIURG_CTL
// [1:0]      -- decomp_hdrurg  00:Normal 01:Urgent 10:SuperUrgent
// [2]        -- decomp_fpathurg_en 1->Urgent if below lo_thresh
// [3]        -- decomp_spathurg_en 1->Urgent if below lo_thresh
// [10:4]     -- decomp_fpathurg_lothresh [32byte steps : max 96]
// [17:11]    -- decomp_fpathurg_hithresh [32byte steps : max 96]
// [24:18]    -- decomp_spathurg_lothresh [32byte steps : max 64]
// [31:25]    -- decomp_spathurg_hithresh [32byte steps : max 64]
#define HEVCD_MPP_DECOMP_AXIURG_CTL                ((0x34c7  << 2) + 0xff620000)
// HEVCD_MPP_VDEC_MCR_CTL
// [0]        -- mcr_mdec_mode : 1:mcr fetch used by vdec:mdec
// [3:1]      -- reserved
// [4]        -- mcr_mdec_8byte_endianess : 1:big 0:little
// [31:5]     -- reserved
#define HEVCD_MPP_VDEC_MCR_CTL                     ((0x34c8  << 2) + 0xff620000)
//////////////////////////////////////////////////////////////////////////////
///// MCRCC_AXI Registers                                 ////////////////////
//////////////////////////////////////////////////////////////////////////////
// HEVCD_MCRCC_CTL1
// 31:12 <reserved[20:0]>
// 11:10 <cfg_anc11_tb>                           // 01: top 10:bot 11:frame
// 9:8   <cfg_anc10_tb>
// 7:6   <cfg_anc01_tb>
// 5:4   <cfg_anc00_tb>
// 3     <cfg_clkgate_disbl>
// 2     <cfg_field_pic>                           // not used for hevc
// 1     <sw_rst>
// 0     <bypass_en>
#define HEVCD_MCRCC_CTL1                           ((0x34f0  << 2) + 0xff620000)
// HEVCD_MCRCC_CTL2
// 31:24    <cfg_cache_anc01_c[7:0]>
// 23:16    <cfg_cache_anc01_y[7:0]>
// 15:8     <cfg_cache_anc00_c[7:0]>
// 7:0      <cfg_cache_anc00_y[7:0]>
#define HEVCD_MCRCC_CTL2                           ((0x34f1  << 2) + 0xff620000)
// HEVCD_MCRCC_CTL3
// 31:24    <cfg_cache_anc11_c[7:0]>
// 23:16    <cfg_cache_anc11_y[7:0]>
// 15:8     <cfg_cache_anc10_c[7:0]>
// 7:0      <cfg_cache_anc10_y[7:0]>
#define HEVCD_MCRCC_CTL3                           ((0x34f2  << 2) + 0xff620000)
// HEVCD_MCRCC_PERFMON_CTL
// [0]      percount_reset
// [3:1]    perfcount_sel
// [31:4]   reserved
// perfcount_sel[2:0]     perfcount
//     0                  raw_mcr_cnt
//     1                  hit_mcr_cnt
//     2                  byp_mcr_cnt_nchoutwin
//     3                  byp_mcr_cnt_nchcanv
//     4                  miss_mcr_cnt_0
//     5                  miss_mcr_cnt_1
//     6                  hit_mcr_cnt_0
//     7                  hit_mcr_cnt_1
#define HEVCD_MCRCC_PERFMON_CTL                    ((0x34f3  << 2) + 0xff620000)
// HEVCD_MCRCC_PERFMON_DATA
// [31:0]   percount_data
#define HEVCD_MCRCC_PERFMON_DATA                   ((0x34f4  << 2) + 0xff620000)
//////////////////////////////////////////////////////////////////////////////
///// VP9 Decoder Registers                               ////////////////////
//////////////////////////////////////////////////////////////////////////////
// VP9D_MPP_INTERPOL_CFG0
// [2:0]    VP9 MC Interpolation type
            // 0-3:perframe type 4:per partition type
// [3]      reserved
// [4]      V99 MV precision
            // 1:high precision else  mv=mv*2
// [31:5]   reserved
#define VP9D_MPP_INTERPOL_CFG0                     ((0x3440  << 2) + 0xff620000)
// VP9D_MPP_REF_SCALE_ENBL
// [7:0]    VP9 MC reference scaled info
// [15:0]   VP9 MC reference scaled dir 0:Dwn 1:Up
// [31:16]  reserved
#define VP9D_MPP_REF_SCALE_ENBL                    ((0x3441  << 2) + 0xff620000)
// VP9D_MPP_REFINFO_TBL_ACCCONFIG
// [1:0]    reserved
// [2]      auto_inc_index/field
// [5:3]    reference index   0:last 1:golden 2:altref
// [8:6]    info field 0:<ref_width[14:0]> 1:<ref_height[14:0]>
            //         2:<scale_x[26:0]  3:<scale_y[26:0]>
            //         4:<decomp_header1_offset[23:0]> -- 32byte aligned
// [31:9]   reserved
#define VP9D_MPP_REFINFO_TBL_ACCCONFIG             ((0x3442  << 2) + 0xff620000)
// VP9D_MPP_REFINFO_DATA
// [n:0]    refinfo_tbl[index]field]  wr_data/rd_data
#define VP9D_MPP_REFINFO_DATA                      ((0x3443  << 2) + 0xff620000)
//
// Closing file:  hevc_ipp_regs.h
//
//------------------------------------------------------------------------------
// HEVC_DBLK module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  hevc_dblk_regs.h
//
// -----------------------------------------------
// CBUS_BASE:  DOS_HEVC_DBLK_CBUS_BASE = 0x05
// -----------------------------------------------
//cfg0[0];        //software_reset
//cfg0[1];        //status clear, only for axi error or pic_done
//cfg0[2];        //clock_forced_on_all
//cfg0[3];        //clock_forced_off_all
//cfg0[11:8];     //PU FIFO Threshold   , 0:16 1:1 ... 1:15
//cfg0[15:12];    //TU FIFO Threshold>>4, 0:16<<4 1:1<<4 ... 1:15<<4
//cfg0[29:16];    //clock_forced_on_submodules
#define HEVC_DBLK_CFG0                             ((0x3500  << 2) + 0xff620000)
//cfg1[1:0];      //ctb_size 0:64x64 1:32x32 2:16x16
//cfg1[2];        //ignore_out_of_boundary
//cfg1[3];        //pcm_loop_filter_disabled_flag
//cfg1[8:4];      //pps_cb_qp_offset (-12~12,inclusive)
//cfg1[13:9];     //pps_cr_qp_offset (-12~12,inclusive)
//cfg1[14];       //ctbx,y swap in pu i/f
//cfg1[15];       //sao_corner_45_degree_all_software_control
#define HEVC_DBLK_CFG1                             ((0x3501  << 2) + 0xff620000)
//cfg2[15:0];     //picture_size_width
//cfg2[31:16];    //picture_size_height
#define HEVC_DBLK_CFG2                             ((0x3502  << 2) + 0xff620000)
//cfg3[3:0];      //parameter_axi_arid
//cfg3[7:4];      //parameter_axi_awid
//cfg3[11:8];     //parameter_axi_wid
//cfg3[12];       //parameter_axi_not_check_write_response
//cfg3[19:16];    //data_axi_arid
//cfg3[23:20];    //data_axi_awid
//cfg3[27:24];    //data_axi_wid
//cfg3[28];       //data_axi_not_check_write_response
#define HEVC_DBLK_CFG3                             ((0x3503  << 2) + 0xff620000)
//cfg4[31:0];     //parameter_axi_start_address
#define HEVC_DBLK_CFG4                             ((0x3504  << 2) + 0xff620000)
//cfg5[31:0];     //data_axi_start_address
#define HEVC_DBLK_CFG5                             ((0x3505  << 2) + 0xff620000)
//cfg6[9:0];      //tile_ctbx
//cfg6[25:16];    //tile_ctby
//cfg6[31];       //tile_enabled
#define HEVC_DBLK_CFG6                             ((0x3506  << 2) + 0xff620000)
//cfg7[9:0];      //tile_ctbxsize
//cfg7[25:16];    //tile_ctbysize
#define HEVC_DBLK_CFG7                             ((0x3507  << 2) + 0xff620000)
//cfg8[9:0];      //start_ctbx, normally equals to tile_ctbx
//cfg8[25:16];    //start_ctby, normally equals to tile_ctby
//cfg8[31];       //start, self_cleared signal, normally set it at the begin of tile
#define HEVC_DBLK_CFG8                             ((0x3508  << 2) + 0xff620000)
//cfg9[0]         //loop_filter_across_tiles_enabled_flag
//cfg9[1]         //loop_filter_across_slices_enabled_flag
//cfg9[2]         //deblocking_filter_disabled_flag
//cfg9[6:3]       //beta_offset_div2 (-6~6,inclusive)
//cfg9[10:7]      //tc_offset_div2 (-6~6,inclusive)
#define HEVC_DBLK_CFG9                             ((0x3509  << 2) + 0xff620000)
//cfga[4:0]       //corner45degree{FIFO_CNT}
//cfga[31:27]     //corner45degree{EN,FIFO_CLR,FIFO_PUSH,DATA,DATA_SEL}
#define HEVC_DBLK_CFGA                             ((0x350a  << 2) + 0xff620000)
//cfgb[3:0]       //0:HEVC 1:VP9 ...
#define HEVC_DBLK_CFGB                             ((0x350b  << 2) + 0xff620000)
//cfgc[31:0]      //cfg_addr_y1
#define HEVC_DBLK_CFGC                             ((0x350c  << 2) + 0xff620000)
//TODO description
#define HEVC_DBLK_STS0                             ((0x350d  << 2) + 0xff620000)
//TODO description
#define HEVC_DBLK_STS1                             ((0x350e  << 2) + 0xff620000)
//
// Closing file:  hevc_dblk_regs.h
//
//------------------------------------------------------------------------------
// HEVC_SAO module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  hevc_sao_regs.h
//
// -----------------------------------------------
// CBUS_BASE:  DOS_HEVC_SAO_CBUS_BASE = 0x06
// -----------------------------------------------
#define HEVC_SAO_VERSION                           ((0x3600  << 2) + 0xff620000)
//  [31:0]  reversion               default:32'h00010001
#define HEVC_SAO_CTRL0                             ((0x3601  << 2) + 0xff620000)
//  [3:0]   lcu_size_log2
//  [31]    above intermedia data compress: 0=no-compress,1=compress;default:1'b0
#define HEVC_SAO_CTRL1                             ((0x3602  << 2) + 0xff620000)
//  [31:24] ar_fifo1_axi_thred
//  [23:16] ar_fifo0_axi_thred
//  [15:14] axi_linealign, 0-16bytes, 1-32bytes, 2-64bytes
//  [13:12] axi_aformat, 0-Linear, 1-32x32, 2-64x32
//  [11:08] axi_lendian_C
//  [07:04] axi_lendian_Y
//  [3]     reserved
//  [2]     clk_forceon
//  [1]     dw_disable:disable double write output
//  [0]     cm_disable:disable compress output
#define HEVC_SAO_INT_EN                            ((0x3603  << 2) + 0xff620000)
//  [0]     sao_int_enable
//  [1]     sao_int_amrisc_level
//  [2]     sao_int_cpu_level
//  [3]     slice_done_int_amrisc_enable
//  [4]     slice_done_int_cpu_enable
//  [15]    disable_sao_int_clock_gating
#define HEVC_SAO_INT_STATUS                        ((0x3604  << 2) + 0xff620000)
//  [0]     slice_done IRQ
//  [31]    write "1"=slice start(self clear,read always return "0")
#define HEVC_SAO_PIC_SIZE                          ((0x3605  << 2) + 0xff620000)
//  [15:0]  pic_width[15:0]
//  [31:16] pic_height[15:0]
#define HEVC_SAO_PIC_SIZE_LCU                      ((0x3606  << 2) + 0xff620000)
//  [15:0]  lcu_x_num_1[15:0]   (=lcu_x_total-1)
//  [31:16] lcu_y_num_1[15:0]   (=lcu_y_total-1)
#define HEVC_SAO_TILE_START                        ((0x3607  << 2) + 0xff620000)
//  [15:0]  tile_start_lcu_x[15:0]
//  [31:16] tile_start_lcu_y[15:0]
#define HEVC_SAO_TILE_SIZE_LCU                     ((0x3608  << 2) + 0xff620000)
//  [15:0]  tile_width_lcu[15:0]
//  [31:16] tile_height_lcu[15:0]
#define HEVC_SAO_AXI_WCTRL                         ((0x3609  << 2) + 0xff620000)
#define HEVC_SAO_AXI_RCTRL                         ((0x360a  << 2) + 0xff620000)
#define HEVC_SAO_Y_START_ADDR                      ((0x360b  << 2) + 0xff620000)
#define HEVC_SAO_Y_LENGTH                          ((0x360c  << 2) + 0xff620000)
#define HEVC_SAO_C_START_ADDR                      ((0x360d  << 2) + 0xff620000)
#define HEVC_SAO_C_LENGTH                          ((0x360e  << 2) + 0xff620000)
#define HEVC_SAO_Y_WPTR                            ((0x360f  << 2) + 0xff620000)
#define HEVC_SAO_C_WPTR                            ((0x3610  << 2) + 0xff620000)
#define HEVC_SAO_ABV_START_ADDR                    ((0x3611  << 2) + 0xff620000)
#define HEVC_SAO_VB_WR_START_ADDR                  ((0x3612  << 2) + 0xff620000)
#define HEVC_SAO_VB_RD_START_ADDR                  ((0x3613  << 2) + 0xff620000)
#define HEVC_SAO_ABV_WPTR                          ((0x3614  << 2) + 0xff620000)
#define HEVC_SAO_ABV_RPTR                          ((0x3615  << 2) + 0xff620000)
#define HEVC_SAO_VB_WPTR                           ((0x3616  << 2) + 0xff620000)
#define HEVC_SAO_VB_RPTR                           ((0x3617  << 2) + 0xff620000)
#define HEVC_SAO_DBG_MODE0                         ((0x361e  << 2) + 0xff620000)
#define HEVC_SAO_DBG_MODE1                         ((0x361f  << 2) + 0xff620000)
#define HEVC_SAO_CTRL2                             ((0x3620  << 2) + 0xff620000)
#define HEVC_SAO_CTRL3                             ((0x3621  << 2) + 0xff620000)
#define HEVC_SAO_CTRL4                             ((0x3622  << 2) + 0xff620000)
#define HEVC_SAO_CTRL5                             ((0x3623  << 2) + 0xff620000)
//[23:22]  dw_h1_ctrl   default:2'b11
//[21:20]  dw_h0_ctrl   default:2'b11
//[19:18]  dw_h1_ctrl   default:2'b11
//[17:16]  dw_h0_ctrl   default:2'b11
#define HEVC_SAO_CTRL6                             ((0x3624  << 2) + 0xff620000)
#define HEVC_SAO_CTRL7                             ((0x3625  << 2) + 0xff620000)
#define HEVC_CM_BODY_START_ADDR                    ((0x3626  << 2) + 0xff620000)
#define HEVC_CM_BODY_LENGTH                        ((0x3627  << 2) + 0xff620000)
#define HEVC_CM_HEADER_START_ADDR                  ((0x3628  << 2) + 0xff620000)
#define HEVC_CM_HEADER_LENGTH                      ((0x3629  << 2) + 0xff620000)
#define HEVC_CM_COLOR                              ((0x362a  << 2) + 0xff620000)
#define HEVC_CM_HEADER_OFFSET                      ((0x362b  << 2) + 0xff620000)
#define HEVC_SAO_CTRL8                             ((0x362c  << 2) + 0xff620000)
#define HEVC_SAO_CTRL9                             ((0x362d  << 2) + 0xff620000)
#define HEVC_SAO_CTRL10                            ((0x362e  << 2) + 0xff620000)
#define HEVC_SAO_CTRL11                            ((0x362f  << 2) + 0xff620000)
#define HEVC_SAO_DBG_DATA_0                        ((0x3630  << 2) + 0xff620000)
#define HEVC_SAO_DBG_DATA_1                        ((0x3631  << 2) + 0xff620000)
#define HEVC_SAO_DBG_DATA_2                        ((0x3632  << 2) + 0xff620000)
#define HEVC_SAO_DBG_DATA_3                        ((0x3633  << 2) + 0xff620000)
#define HEVC_SAO_DBG_DATA_4                        ((0x3634  << 2) + 0xff620000)
#define HEVC_SAO_DBG_DATA_5                        ((0x3635  << 2) + 0xff620000)
#define HEVC_SAO_DBG_DATA_6                        ((0x3636  << 2) + 0xff620000)
#define HEVC_SAO_DBG_DATA_7                        ((0x3637  << 2) + 0xff620000)
#define HEVC_SAO_MMU_WR                            ((0x3638  << 2) + 0xff620000)
#define HEVC_SAO_MMU_STATUS                        ((0x3639  << 2) + 0xff620000)
//Read Only
//sao_mmu_fifo is 16(depth)x20(bits)
//[0]   mmu_fifo_empty  1=empty,0=not-empty
//[1]   mmu_fifo_full   1=full,0=not-full
//[7:4] mmu_fifo_depth[3:0]
//[11:8] mmu_fifo_room[3:0]
#define HEVC_SAO_MMU_VH0_ADDR                      ((0x363a  << 2) + 0xff620000)
#define HEVC_SAO_MMU_VH1_ADDR                      ((0x363b  << 2) + 0xff620000)
#define HEVC_SAO_MMU_WPTR                          ((0x363c  << 2) + 0xff620000)
#define HEVC_SAO_MMU_RPTR                          ((0x363d  << 2) + 0xff620000)
//
// Closing file:  hevc_sao_regs.h
//
//------------------------------------------------------------------------------
// HEVC_IQIT module level register offset
//------------------------------------------------------------------------------
//
// Reading file:  hevc_iqit_regs.h
//
// -----------------------------------------------
// CBUS_BASE:  DOS_HEVC_IQIT_CBUS_BASE = 0x07
// -----------------------------------------------
// [    2] RW en_freeclk.   0=Auto-gated clock for saving power;
//                          1=Free running clock if something wrong with auto-gating.
//                          Default 0.
// [    1] RW enable_clk.   0=Disable clock; 1=Enable clock.        Default 0.
#define HEVC_IQIT_CLK_RST_CTRL                     ((0x3700  << 2) + 0xff620000)
// [ 5: 4] RW ctb_size.     0=8x8; 1=16x16; 2=32x32; 3=64x64.                       Default 0.
// [    3] RW itr_skip_mode. For dealing with discrepancy between Spec and C model for transform_skip.
//                          0=Follow Spec; 1=Follow C model.                        Default 0.
// [    2] RW scalelist_mode. Applicable only when scalelist_en=1.
//                          0=Use default scaling factor list;
//                          1=Use scaling factor list define in bit stream.
//                          Default 0.
// [    1] RW scalelist_en. 0=Use flat scale; 1=Use scaling factor list.            Default 0.
// [    0] RW diagscan_en.  0=Linear lookup dQ table; 1=Diagonally lookup dQ table. Default 0.
#define HEVC_IQIT_DEQUANT_CTRL                     ((0x3701  << 2) + 0xff620000)
// [31:10] WR Reserved.                                 Default 0.
// [ 9: 0] WR scalelut_addr.                            Default 0.
#define HEVC_IQIT_SCALELUT_WR_ADDR                 ((0x3702  << 2) + 0xff620000)
// [31:10] RD Reserved.                                 Default 0.
// [ 9: 0] RD scalelut_addr.                            Default 0.
#define HEVC_IQIT_SCALELUT_RD_ADDR                 ((0x3703  << 2) + 0xff620000)
// [ 7: 0] RW LUT data.
#define HEVC_IQIT_SCALELUT_DATA                    ((0x3704  << 2) + 0xff620000)
//---------------------------------------------------
// tab_idx [2:0] -
//    0-5 use custom table index
//    6 - reserved
//    7 - use default table
//---------------------------------------------------
// [22:20] 4x4 tab 5
// [   19] reserved
// [18:16] 4x4 tab 4
// [   15] reserved
// [14:12] 4x4 tab 3
// [   11] reserved
// [10: 8] 4x4 tab 2
// [    7] reserved
// [ 6: 4] 4x4 tab 1
// [    3] reserved
// [ 2: 0] 4x4 tab 0
#define HEVC_IQIT_SCALELUT_IDX_4                   ((0x3705  << 2) + 0xff620000)
// [22:20] 8x8 tab 5
// [   19] reserved
// [18:16] 8x8 tab 4
// [   15] reserved
// [14:12] 8x8 tab 3
// [   11] reserved
// [10: 8] 8x8 tab 2
// [    7] reserved
// [ 6: 4] 8x8 tab 1
// [    3] reserved
// [ 2: 0] 8x8 tab 0
#define HEVC_IQIT_SCALELUT_IDX_8                   ((0x3706  << 2) + 0xff620000)
// [   31] reserved
// [30:28] 32x32 tab 1
// [   27] reserved
// [26:24] 32x32 tab 0
// [   23] reserved
// [22:20] 16x16 tab 5
// [   19] reserved
// [18:16] 16x16 tab 4
// [   15] reserved
// [14:12] 16x16 tab 3
// [   11] reserved
// [10: 8] 16x16 tab 2
// [    7] reserved
// [ 6: 4] 16x16 tab 1
// [    3] reserved
// [ 2: 0] 16x16 tab 0
#define HEVC_IQIT_SCALELUT_IDX_16_32               ((0x3707  << 2) + 0xff620000)
// [ 8: 2] R  tuinfo_fifo_cnt.
// [    1] R  fifo_has_room.
// [    0] R  mem_init_done.
#define HEVC_IQIT_STAT_GEN0                        ((0x3708  << 2) + 0xff620000)
// [   23] RW cntl_qp_cr_valid.
// [21:16] RW cntl_qp_cr.
// [   15] RW cntl_qp_cb_valid.
// [13: 8] RW cntl_qp_cb.
// [    7] RW cntl_qp_y_valid.
// [ 5: 0] RW cntl_qp_y.
#define HEVC_QP_WRITE                              ((0x3709  << 2) + 0xff620000)
// [31:30] R  ipp_size.
// [28:24] R  ipp_mem_ptr.
// [23:22] R  itr2_size.
// [20:16] R  itr2_mem_ptr.
// [15:14] R  itr1_size.
// [12: 8] R  itr1_mem_ptr.
// [ 7: 6] R  iq_size.
// [ 4: 0] R  iq_mem_ptr.
#define HEVC_IQIT_STAT_GEN1                        ((0x370a  << 2) + 0xff620000)
// [ 5: 4] RW cntl_bitdepth_c. 0=8-bit; 1=9-bit; 2=10-bit.
// [ 1: 0] RW cntl_bitdepth_y. 0=8-bit; 1=9-bit; 2=10-bit.
#define HEVC_IQIT_BITDEPTH                         ((0x370b  << 2) + 0xff620000)
// [   10] R  ipp_active.
// [    9] R  itr2_active.
// [    8] R  itr1_active.
// [ 5: 0] R  mem_spare_num.
#define HEVC_IQIT_STAT_GEN2                        ((0x370c  << 2) + 0xff620000)
#define HEVC_IQIT_AVS2_WQP_0123                    ((0x370d  << 2) + 0xff620000)
#define HEVC_IQIT_AVS2_WQP_45                      ((0x370e  << 2) + 0xff620000)
#define HEVC_IQIT_AVS2_QP_DELTA                    ((0x370f  << 2) + 0xff620000)
//
// Closing file:  hevc_iqit_regs.h
//
//------------------------------------------------------------------------------
//  DOS top-level register offset
//------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  DOS_TOP_CBUS_BASE = 0x3f
// -----------------------------------------------
// [0]  reserved
// [1]  Reset Dos top level registers, except sw_reset0/1/2 which is only reset by external reset_n.
// [2]  VDEC1 Reset assist, mdec's CBUS
// [3]  VDEC1 Reset mdec's VLD
// [4]  VDEC1 Reset mdec's VLD
// [5]  VDEC1 Reset mdec's VLD
// [6]  VDEC1 Reset mdec's IQIDCT
// [7]  VDEC1 Reset mdec's MC
// [8]  VDEC1 Reset mdec's DBLK
// [9]  VDEC1 Reset mdec's PIC_DC
// [10] VDEC1 Reset mdec's Pscale
// [11] VDEC1 Reset vcpu's MCPU
// [12] VDEC1 Reset vcpu's CCPU
// [13] VDEC1 Reset mmc_pre_arb
#define DOS_SW_RESET0                              ((0x3f00  << 2) + 0xff620000)
// [31:27] reserved
// [26] hcodec clk_en for henc assist
// [25:22] reserved
// [21] hcodec clk_en for henc qdct
// [20] hcodec clk_en for henc vlc
// [19] hcodec clk_en for assist and cbus
// [18] hcodec clk_en for ddr
// [17] hcodec clk_en for vcpu
// [16] hcodec clk_en for hdec assist
// [15] hcodec clk_en for hdec dblk
// [14] reserved
// [13] hcodec clk_en for hdec mc
// [12] hcodec clk_en for hdec pic_dc
// [11:10] reserved
// [9] vdec clk_en for vdec assist and cbus
// [8] vdec clk_en for ddr
// [7] vdec clk_en for vcpu
// [6] vdec clk_en for mdec vld
// [5] vdec clk_en for mdec psc
// [4] vdec clk_en for mdec pic_dc
// [3] vdec clk_en for mdec mc
// [2] vdec clk_en for mdec iqidct
// [1] vdec clk_en for mdec dblk
// [0] vdec clk_en for mdec assist
#define DOS_GCLK_EN0                               ((0x3f01  << 2) + 0xff620000)
#define DOS_GEN_CTRL0                              ((0x3f02  << 2) + 0xff620000)
#define DOS_APB_ERR_CTRL                           ((0x3f03  << 2) + 0xff620000)
#define DOS_APB_ERR_STAT                           ((0x3f04  << 2) + 0xff620000)
#define DOS_VDEC_INT_EN                            ((0x3f05  << 2) + 0xff620000)
#define DOS_HCODEC_INT_EN                          ((0x3f06  << 2) + 0xff620000)
// [0]  Reserved
// [1]  Reserved
// [2]  HCODEC Reset assist, hdec's CBUS
// [3]  HCODEC Reset hdec's VLD
// [4]  HCODEC Reset hdec's VLD
// [5]  HCODEC Reset hdec's VLD
// [6]  HCODEC Reset hdec's IQIDCT
// [7]  HCODEC Reset hdec's MC
// [8]  HCODEC Reset hdec's DBLK
// [9]  HCODEC Reset hdec's PIC_DC
// [10] HCODEC Reset hdec's Pscale
// [11] HCODEC Reset vcpu's MCPU
// [12] HCODEC Reset vcpu's CCPU
// [13] HCODEC Reset mmc_pre_arb
// [14] HCODEC Reserved
// [15] HCODEC Reserved
// [16] HCODEC Reset henc's VLC
#define DOS_SW_RESET1                              ((0x3f07  << 2) + 0xff620000)
// [0]  Reserved
// [1]  Reserved
// [2]  VDEC2 Reset assist, mdec's CBUS
// [3]  VDEC2 Reset mdec's VLD
// [4]  VDEC2 Reset mdec's VLD
// [5]  VDEC2 Reset mdec's VLD
// [6]  VDEC2 Reset mdec's IQIDCT
// [7]  VDEC2 Reset mdec's MC
// [8]  VDEC2 Reset mdec's DBLK
// [9]  VDEC2 Reset mdec's PIC_DC
// [10] VDEC2 Reset mdec's Pscale
// [11] VDEC2 Reset vcpu's MCPU
// [12] VDEC2 Reset vcpu's CCPU
// [13] VDEC2 Reset mmc_pre_arb
#define DOS_SW_RESET2                              ((0x3f08  << 2) + 0xff620000)
// [31:10] Reserved
// [9] vdec2 clk_en for assist and cbus.
// [8] vdec2 clk_en for ddr;
// [7] vdec2 clk_en for vcpu;
// [6] vdec2 clk_en for mdec vld
// [5] vdec2 clk_en for mdec psc
// [4] vdec2 clk_en for mdec pic_dc
// [3] vdec2 clk_en for mdec mc
// [2] vdec2 clk_en for mdec iqidct
// [1] vdec2 clk_en for mdec dblk
// [0] vdec2 clk_en for mdec assist
#define DOS_GCLK_EN1                               ((0x3f09  << 2) + 0xff620000)
#define DOS_VDEC2_INT_EN                           ((0x3f0a  << 2) + 0xff620000)
#define DOS_VDIN_LCNT                              ((0x3f0b  << 2) + 0xff620000)
#define DOS_VDIN_FCNT                              ((0x3f0c  << 2) + 0xff620000)
#define DOS_VDIN_CCTL                              ((0x3f0d  << 2) + 0xff620000)
#define DOS_SCRATCH0                               ((0x3f10  << 2) + 0xff620000)
#define DOS_SCRATCH1                               ((0x3f11  << 2) + 0xff620000)
#define DOS_SCRATCH2                               ((0x3f12  << 2) + 0xff620000)
#define DOS_SCRATCH3                               ((0x3f13  << 2) + 0xff620000)
#define DOS_SCRATCH4                               ((0x3f14  << 2) + 0xff620000)
#define DOS_SCRATCH5                               ((0x3f15  << 2) + 0xff620000)
#define DOS_SCRATCH6                               ((0x3f16  << 2) + 0xff620000)
#define DOS_SCRATCH7                               ((0x3f17  << 2) + 0xff620000)
#define DOS_SCRATCH8                               ((0x3f18  << 2) + 0xff620000)
#define DOS_SCRATCH9                               ((0x3f19  << 2) + 0xff620000)
#define DOS_SCRATCH10                              ((0x3f1a  << 2) + 0xff620000)
#define DOS_SCRATCH11                              ((0x3f1b  << 2) + 0xff620000)
#define DOS_SCRATCH12                              ((0x3f1c  << 2) + 0xff620000)
#define DOS_SCRATCH13                              ((0x3f1d  << 2) + 0xff620000)
#define DOS_SCRATCH14                              ((0x3f1e  << 2) + 0xff620000)
#define DOS_SCRATCH15                              ((0x3f1f  << 2) + 0xff620000)
#define DOS_SCRATCH16                              ((0x3f20  << 2) + 0xff620000)
#define DOS_SCRATCH17                              ((0x3f21  << 2) + 0xff620000)
#define DOS_SCRATCH18                              ((0x3f22  << 2) + 0xff620000)
#define DOS_SCRATCH19                              ((0x3f23  << 2) + 0xff620000)
#define DOS_SCRATCH20                              ((0x3f24  << 2) + 0xff620000)
#define DOS_SCRATCH21                              ((0x3f25  << 2) + 0xff620000)
#define DOS_SCRATCH22                              ((0x3f26  << 2) + 0xff620000)
#define DOS_SCRATCH23                              ((0x3f27  << 2) + 0xff620000)
#define DOS_SCRATCH24                              ((0x3f28  << 2) + 0xff620000)
#define DOS_SCRATCH25                              ((0x3f29  << 2) + 0xff620000)
#define DOS_SCRATCH26                              ((0x3f2a  << 2) + 0xff620000)
#define DOS_SCRATCH27                              ((0x3f2b  << 2) + 0xff620000)
#define DOS_SCRATCH28                              ((0x3f2c  << 2) + 0xff620000)
#define DOS_SCRATCH29                              ((0x3f2d  << 2) + 0xff620000)
#define DOS_SCRATCH30                              ((0x3f2e  << 2) + 0xff620000)
#define DOS_SCRATCH31                              ((0x3f2f  << 2) + 0xff620000)
#define DOS_MEM_PD_VDEC                            ((0x3f30  << 2) + 0xff620000)
#define DOS_MEM_PD_VDEC2                           ((0x3f31  << 2) + 0xff620000)
#define DOS_MEM_PD_HCODEC                          ((0x3f32  << 2) + 0xff620000)
#define DOS_MEM_PD_HEVC                            ((0x3f33  << 2) + 0xff620000)
#define DOS_SW_RESET3                              ((0x3f34  << 2) + 0xff620000)
#define DOS_GCLK_EN3                               ((0x3f35  << 2) + 0xff620000)
#define DOS_HEVC_INT_EN                            ((0x3f36  << 2) + 0xff620000)
#define DOS_SW_RESET4                              ((0x3f37  << 2) + 0xff620000)
#define DOS_GCLK_EN4                               ((0x3f38  << 2) + 0xff620000)
#define DOS_MEM_PD_VP9DEC                          ((0x3f39  << 2) + 0xff620000)
// bit[31]    mcrcc_stall_en
// bit[30:28] Reserved
// bit[27:20] target_canvas
// bit[19:10] target_mby
// bit[ 9: 0] target_mbx
#define DOS_VDEC_MCRCC_STALL_CTRL                  ((0x3f40  << 2) + 0xff620000)
#define DOS_VDEC_MCRCC_STALL2_CTRL                 ((0x3f42  << 2) + 0xff620000)
#define DOS_VDEC2_MCRCC_STALL_CTRL                 ((0x3f41  << 2) + 0xff620000)
#define DOS_VDEC2_MCRCC_STALL2_CTRL                ((0x3f43  << 2) + 0xff620000)
// bit[1] s_clk off
// bit[0] m_clk off
#define DOS_CFG_CMPIF_BRIDGE                       ((0x3f44  << 2) + 0xff620000)
#define DOS_SECURE_CTL_INDEX                       ((0x3f80  << 2) + 0xff620000)
#define DOS_SECURE_CTL_DATA                        ((0x3f81  << 2) + 0xff620000)
#define DOS_SECURE_REG_NULL                        ((0x3f82  << 2) + 0xff620000)
//
// Closing file:  ./dos_param.h
//
//
// Reading file:  mdec_regs.h
//
//========================================================================
//  MDEC module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_MDEC_CBUS_BASE = 0x09
// -----------------------------------------------
#define HCODEC_MC_CTRL_REG                         ((0x1900  << 2) + 0xff620000)
#define HCODEC_MC_MB_INFO                          ((0x1901  << 2) + 0xff620000)
#define HCODEC_MC_PIC_INFO                         ((0x1902  << 2) + 0xff620000)
#define HCODEC_MC_HALF_PEL_ONE                     ((0x1903  << 2) + 0xff620000)
#define HCODEC_MC_HALF_PEL_TWO                     ((0x1904  << 2) + 0xff620000)
#define HCODEC_POWER_CTL_MC                        ((0x1905  << 2) + 0xff620000)
#define HCODEC_MC_CMD                              ((0x1906  << 2) + 0xff620000)
#define HCODEC_MC_CTRL0                            ((0x1907  << 2) + 0xff620000)
#define HCODEC_MC_PIC_W_H                          ((0x1908  << 2) + 0xff620000)
#define HCODEC_MC_STATUS0                          ((0x1909  << 2) + 0xff620000)
#define HCODEC_MC_STATUS1                          ((0x190a  << 2) + 0xff620000)
#define HCODEC_MC_CTRL1                            ((0x190b  << 2) + 0xff620000)
#define HCODEC_MC_MIX_RATIO0                       ((0x190c  << 2) + 0xff620000)
#define HCODEC_MC_MIX_RATIO1                       ((0x190d  << 2) + 0xff620000)
#define HCODEC_MC_DP_MB_XY                         ((0x190e  << 2) + 0xff620000)
#define HCODEC_MC_OM_MB_XY                         ((0x190f  << 2) + 0xff620000)
#define HCODEC_PSCALE_RST                          ((0x1910  << 2) + 0xff620000)
#define HCODEC_PSCALE_CTRL                         ((0x1911  << 2) + 0xff620000)
#define HCODEC_PSCALE_PICI_W                       ((0x1912  << 2) + 0xff620000)
#define HCODEC_PSCALE_PICI_H                       ((0x1913  << 2) + 0xff620000)
#define HCODEC_PSCALE_PICO_W                       ((0x1914  << 2) + 0xff620000)
#define HCODEC_PSCALE_PICO_H                       ((0x1915  << 2) + 0xff620000)
#define HCODEC_PSCALE_PICO_START_X                 ((0x1916  << 2) + 0xff620000)
#define HCODEC_PSCALE_PICO_START_Y                 ((0x1917  << 2) + 0xff620000)
#define HCODEC_PSCALE_DUMMY                        ((0x1918  << 2) + 0xff620000)
#define HCODEC_PSCALE_FILT0_COEF0                  ((0x1919  << 2) + 0xff620000)
#define HCODEC_PSCALE_FILT0_COEF1                  ((0x191a  << 2) + 0xff620000)
#define HCODEC_PSCALE_CMD_CTRL                     ((0x191b  << 2) + 0xff620000)
#define HCODEC_PSCALE_CMD_BLK_X                    ((0x191c  << 2) + 0xff620000)
#define HCODEC_PSCALE_CMD_BLK_Y                    ((0x191d  << 2) + 0xff620000)
#define HCODEC_PSCALE_STATUS                       ((0x191e  << 2) + 0xff620000)
#define HCODEC_PSCALE_BMEM_ADDR                    ((0x191f  << 2) + 0xff620000)
#define HCODEC_PSCALE_BMEM_DAT                     ((0x1920  << 2) + 0xff620000)
#define HCODEC_PSCALE_DRAM_BUF_CTRL                ((0x1921  << 2) + 0xff620000)
#define HCODEC_PSCALE_MCMD_CTRL                    ((0x1922  << 2) + 0xff620000)
#define HCODEC_PSCALE_MCMD_XSIZE                   ((0x1923  << 2) + 0xff620000)
#define HCODEC_PSCALE_MCMD_YSIZE                   ((0x1924  << 2) + 0xff620000)
#define HCODEC_PSCALE_RBUF_START_BLKX              ((0x1925  << 2) + 0xff620000)
#define HCODEC_PSCALE_RBUF_START_BLKY              ((0x1926  << 2) + 0xff620000)
//`define PSCALE_RBUF_MB_WIDTH   8'h27
#define HCODEC_PSCALE_PICO_SHIFT_XY                ((0x1928  << 2) + 0xff620000)
#define HCODEC_PSCALE_CTRL1                        ((0x1929  << 2) + 0xff620000)
//Bit 15, wmask enable
//Bit 14:13, filt0 srckey_less,
//Bit 12:11, filt1 srckey_less, in the case of the interpolated data is equal distance to
//key data and normal data, 00: select normal data, 01: select right data, 10: select key data
//Bit 10:9, srckey mode, 00: equal, 01: less than or equal, 10: great than or equal
//Bit 8, src key enable
//Bit 7:0, y src key
#define HCODEC_PSCALE_SRCKEY_CTRL0                 ((0x192a  << 2) + 0xff620000)
//Bit 15:8, cb src key
//Bit 7:0, cr src key
#define HCODEC_PSCALE_SRCKEY_CTRL1                 ((0x192b  << 2) + 0xff620000)
//Bit 22:16 canvas_rd_addr2
//Bit 14:8 canvas_rd_addr1
//Bit 6:0 canvas_rd_addr1
#define HCODEC_PSCALE_CANVAS_RD_ADDR               ((0x192c  << 2) + 0xff620000)
//Bit 22:16 canvas_wr_addr2
//Bit 14:8 canvas_wr_addr1
//Bit 6:0 canvas_wr_addr1
#define HCODEC_PSCALE_CANVAS_WR_ADDR               ((0x192d  << 2) + 0xff620000)
//bit 13:8 pscale thread ID and token
//bit 7 disable write response count adding to busy bit
//bit 5:0  pscale pre arbiter burst num
#define HCODEC_PSCALE_CTRL2                        ((0x192e  << 2) + 0xff620000)
//   31 - use_omem_mb_xy_auto
//23:16 - omem_max_mb_x
//15:8  - omem_mb_y_auto
// 7:0  - omem_mb_x_auto
#define HCODEC_HDEC_MC_OMEM_AUTO                   ((0x1930  << 2) + 0xff620000)
#define HCODEC_HDEC_MC_MBRIGHT_IDX                 ((0x1931  << 2) + 0xff620000)
#define HCODEC_HDEC_MC_MBRIGHT_RD                  ((0x1932  << 2) + 0xff620000)
#define HCODEC_MC_MPORT_CTRL                       ((0x1940  << 2) + 0xff620000)
#define HCODEC_MC_MPORT_DAT                        ((0x1941  << 2) + 0xff620000)
#define HCODEC_MC_WT_PRED_CTRL                     ((0x1942  << 2) + 0xff620000)
#define HCODEC_MC_MBBOT_ST_EVEN_ADDR               ((0x1944  << 2) + 0xff620000)
#define HCODEC_MC_MBBOT_ST_ODD_ADDR                ((0x1945  << 2) + 0xff620000)
#define HCODEC_MC_DPDN_MB_XY                       ((0x1946  << 2) + 0xff620000)
#define HCODEC_MC_OMDN_MB_XY                       ((0x1947  << 2) + 0xff620000)
#define HCODEC_MC_HCMDBUF_H                        ((0x1948  << 2) + 0xff620000)
#define HCODEC_MC_HCMDBUF_L                        ((0x1949  << 2) + 0xff620000)
#define HCODEC_MC_HCMD_H                           ((0x194a  << 2) + 0xff620000)
#define HCODEC_MC_HCMD_L                           ((0x194b  << 2) + 0xff620000)
#define HCODEC_MC_IDCT_DAT                         ((0x194c  << 2) + 0xff620000)
#define HCODEC_MC_CTRL_GCLK_CTRL                   ((0x194d  << 2) + 0xff620000)
#define HCODEC_MC_OTHER_GCLK_CTRL                  ((0x194e  << 2) + 0xff620000)
//Bit 29:24, mbbot thread ID and token
//Bit 21:16, mc read/write thread ID and token
//Bit 13:8,  mbbot pre-arbitor burst number
//Bit 5:0,   mc pre-arbitor burst number
#define HCODEC_MC_CTRL2                            ((0x194f  << 2) + 0xff620000)
// `define DBLK_QUANT            8'h76 // ONLY for $ucode/real/amrisc/rv.s, reg value from apollo
//`define ANC1_CANVAS_ADDR      8'h80
//`define ANC2_CANVAS_ADDR      8'h81
//`define REC_CANVAS_ADDR       8'h89
//`define MDEC_PIC_W          8'h8c
//`define MDEC_PIC_H          8'h8d
// mdec_pic_dc_mux_ctrl[31]  -- mcr_hevc_mode
#define HCODEC_MDEC_PIC_DC_MUX_CTRL                ((0x198d  << 2) + 0xff620000)
#define HCODEC_MDEC_PIC_DC_CTRL                    ((0x198e  << 2) + 0xff620000)
#define HCODEC_MDEC_PIC_DC_STATUS                  ((0x198f  << 2) + 0xff620000)
#define HCODEC_ANC0_CANVAS_ADDR                    ((0x1990  << 2) + 0xff620000)
#define HCODEC_ANC1_CANVAS_ADDR                    ((0x1991  << 2) + 0xff620000)
#define HCODEC_ANC2_CANVAS_ADDR                    ((0x1992  << 2) + 0xff620000)
#define HCODEC_ANC3_CANVAS_ADDR                    ((0x1993  << 2) + 0xff620000)
#define HCODEC_ANC4_CANVAS_ADDR                    ((0x1994  << 2) + 0xff620000)
#define HCODEC_ANC5_CANVAS_ADDR                    ((0x1995  << 2) + 0xff620000)
#define HCODEC_ANC6_CANVAS_ADDR                    ((0x1996  << 2) + 0xff620000)
#define HCODEC_ANC7_CANVAS_ADDR                    ((0x1997  << 2) + 0xff620000)
#define HCODEC_ANC8_CANVAS_ADDR                    ((0x1998  << 2) + 0xff620000)
#define HCODEC_ANC9_CANVAS_ADDR                    ((0x1999  << 2) + 0xff620000)
#define HCODEC_ANC10_CANVAS_ADDR                   ((0x199a  << 2) + 0xff620000)
#define HCODEC_ANC11_CANVAS_ADDR                   ((0x199b  << 2) + 0xff620000)
#define HCODEC_ANC12_CANVAS_ADDR                   ((0x199c  << 2) + 0xff620000)
#define HCODEC_ANC13_CANVAS_ADDR                   ((0x199d  << 2) + 0xff620000)
#define HCODEC_ANC14_CANVAS_ADDR                   ((0x199e  << 2) + 0xff620000)
#define HCODEC_ANC15_CANVAS_ADDR                   ((0x199f  << 2) + 0xff620000)
#define HCODEC_ANC16_CANVAS_ADDR                   ((0x19a0  << 2) + 0xff620000)
#define HCODEC_ANC17_CANVAS_ADDR                   ((0x19a1  << 2) + 0xff620000)
#define HCODEC_ANC18_CANVAS_ADDR                   ((0x19a2  << 2) + 0xff620000)
#define HCODEC_ANC19_CANVAS_ADDR                   ((0x19a3  << 2) + 0xff620000)
#define HCODEC_ANC20_CANVAS_ADDR                   ((0x19a4  << 2) + 0xff620000)
#define HCODEC_ANC21_CANVAS_ADDR                   ((0x19a5  << 2) + 0xff620000)
#define HCODEC_ANC22_CANVAS_ADDR                   ((0x19a6  << 2) + 0xff620000)
#define HCODEC_ANC23_CANVAS_ADDR                   ((0x19a7  << 2) + 0xff620000)
#define HCODEC_ANC24_CANVAS_ADDR                   ((0x19a8  << 2) + 0xff620000)
#define HCODEC_ANC25_CANVAS_ADDR                   ((0x19a9  << 2) + 0xff620000)
#define HCODEC_ANC26_CANVAS_ADDR                   ((0x19aa  << 2) + 0xff620000)
#define HCODEC_ANC27_CANVAS_ADDR                   ((0x19ab  << 2) + 0xff620000)
#define HCODEC_ANC28_CANVAS_ADDR                   ((0x19ac  << 2) + 0xff620000)
#define HCODEC_ANC29_CANVAS_ADDR                   ((0x19ad  << 2) + 0xff620000)
#define HCODEC_ANC30_CANVAS_ADDR                   ((0x19ae  << 2) + 0xff620000)
#define HCODEC_ANC31_CANVAS_ADDR                   ((0x19af  << 2) + 0xff620000)
#define HCODEC_DBKR_CANVAS_ADDR                    ((0x19b0  << 2) + 0xff620000)
#define HCODEC_DBKW_CANVAS_ADDR                    ((0x19b1  << 2) + 0xff620000)
#define HCODEC_REC_CANVAS_ADDR                     ((0x19b2  << 2) + 0xff620000)
//28:24, read/write, current canvas idx, used in h264 only now
//23:0, read only, current canvas address, 23:16, Cr canvas addr, 15:8, Cb canvas addr, 7:0, Y  canvas addr
#define HCODEC_CURR_CANVAS_CTRL                    ((0x19b3  << 2) + 0xff620000)
#define HCODEC_MDEC_PIC_DC_THRESH                  ((0x19b8  << 2) + 0xff620000)
#define HCODEC_MDEC_PICR_BUF_STATUS                ((0x19b9  << 2) + 0xff620000)
#define HCODEC_MDEC_PICW_BUF_STATUS                ((0x19ba  << 2) + 0xff620000)
#define HCODEC_MCW_DBLK_WRRSP_CNT                  ((0x19bb  << 2) + 0xff620000)
#define HCODEC_MC_MBBOT_WRRSP_CNT                  ((0x19bc  << 2) + 0xff620000)
#define HCODEC_MDEC_PICW_BUF2_STATUS               ((0x19bd  << 2) + 0xff620000)
#define HCODEC_WRRSP_FIFO_PICW_DBK                 ((0x19be  << 2) + 0xff620000)
#define HCODEC_WRRSP_FIFO_PICW_MC                  ((0x19bf  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_0                        ((0x19c0  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_1                        ((0x19c1  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_2                        ((0x19c2  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_3                        ((0x19c3  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_4                        ((0x19c4  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_5                        ((0x19c5  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_6                        ((0x19c6  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_7                        ((0x19c7  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_8                        ((0x19c8  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_9                        ((0x19c9  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_A                        ((0x19ca  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_B                        ((0x19cb  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_C                        ((0x19cc  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_D                        ((0x19cd  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_E                        ((0x19ce  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_F                        ((0x19cf  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_G                        ((0x19d0  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_H                        ((0x19d1  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_I                        ((0x19d2  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_J                        ((0x19d3  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_K                        ((0x19d4  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_L                        ((0x19d5  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_M                        ((0x19d6  << 2) + 0xff620000)
#define HCODEC_AV_SCRATCH_N                        ((0x19d7  << 2) + 0xff620000)
// bit[29:24] A_brst_num_co_mb
// bit[21:16] A_id_co_mb
// bit[11:0] wrrsp_count_co_mb
#define HCODEC_WRRSP_CO_MB                         ((0x19d8  << 2) + 0xff620000)
// bit[29:24] A_brst_num_dcac
// bit[21:16] A_id_dcac
// bit[11:0] wrrsp_count_dcac
#define HCODEC_WRRSP_DCAC                          ((0x19d9  << 2) + 0xff620000)
// bit[11:0] wrrsp_count_vld
#define HCODEC_WRRSP_VLD                           ((0x19da  << 2) + 0xff620000)
// doublew_cfg0[0];     //       Second Channel Enable, 1:Enable 0:Disable
// doublew_cfg0[3:1];   // [2:0] Endian Control for Luma
// doublew_cfg0[5:4];   // [1:0] Pixel sel by horizontal, 0x:1/2 10:left 11:right
// doublew_cfg0[7:6];   // [1:0] Pixel sel by vertical,   0x:1/2 10:up 11:down
// doublew_cfg0[8];     //       Size by horizontal, 0:original size 1: 1/2 shrunken size
// doublew_cfg0[9];     //       Size by vertical,   0:original size 1: 1/2 shrunken size
// doublew_cfg0[10];    //       1:Round 0:Truncation
// doublew_cfg0[11];    //       DMA Urgent
// doublew_cfg0[17:12]; // [5:0] DMA Burst Number
// doublew_cfg0[23:18]; // [5:0] DMA ID
// doublew_cfg0[26:24]; // [2:0] Endian Control for Chroma
// doublew_cfg0[27];    //       Source from, 1:MCW 0:DBLK
// doublew_cfg0[29:28]; // [1:0] 0x:select both top and bottom 10:select top 11:select bottom
// doublew_cfg0[30];    //       0:no merge 1:automatic merge
// doublew_cfg0[31];    //       0:Y addr no change 1:Y addr divided to half
#define HCODEC_MDEC_DOUBLEW_CFG0                   ((0x19db  << 2) + 0xff620000)
// doublew_cfg1[7:0];   // [7:0] DMA Canvas Address for Luma
// doublew_cfg1[15:8];  // [7:0] DMA Canvas Address for Chroma
// doublew_cfg1[16];    //       Disable 1st Write -
// doublew_cfg1[17];    //       Reverse to original version -
// doublew_cfg1[18];    //       DMA Address Mode - 0:Canvas Mode 1:Non-Canvas Mode
#define HCODEC_MDEC_DOUBLEW_CFG1                   ((0x19dc  << 2) + 0xff620000)
// doublew_cfg2[11:0];  //[11:0] vertical flip initial value
// doublew_cfg2[15];    //       vertical flip enable
// doublew_cfg2[24:16]; // [8:0] horizontal flip initial value
// doublew_cfg2[31];    //       horizontal flip enable
#define HCODEC_MDEC_DOUBLEW_CFG2                   ((0x19dd  << 2) + 0xff620000)
// doublew_cfg3[31:0];  //[31:0] non-canvas start address for Luma -
#define HCODEC_MDEC_DOUBLEW_CFG3                   ((0x19de  << 2) + 0xff620000)
// doublew_cfg4[31:0];  //[31:0] non-canvas start address for Chroma -
#define HCODEC_MDEC_DOUBLEW_CFG4                   ((0x19df  << 2) + 0xff620000)
// doublew_cfg5[12:0];  //[12:0] non-canvas picture width for Luma -
// doublew_cfg5[28:16]; //[12:0] non-canvas picture width for Chroma -
#define HCODEC_MDEC_DOUBLEW_CFG5                   ((0x19e0  << 2) + 0xff620000)
// doublew_cfg6: reserved
#define HCODEC_MDEC_DOUBLEW_CFG6                   ((0x19e1  << 2) + 0xff620000)
// doublew_cfg7: reserved
#define HCODEC_MDEC_DOUBLEW_CFG7                   ((0x19e2  << 2) + 0xff620000)
// doublew_status[11:0];//[11:0] wrrsp_count_doublew
// doublew_status[12];  //       doublew_status_busy
// doublew_status[13];  //       doublew_status_error
#define HCODEC_MDEC_DOUBLEW_STATUS                 ((0x19e3  << 2) + 0xff620000)
#define HCODEC_MDEC_EXTIF_CFG0                     ((0x19e4  << 2) + 0xff620000)
#define HCODEC_MDEC_EXTIF_CFG1                     ((0x19e5  << 2) + 0xff620000)
#define HCODEC_MDEC_EXTIF_STS0                     ((0x19e6  << 2) + 0xff620000)
//======================================
//  MC Control Register Bits
//
//======================================
// For bits, just copy the defines...don't translate to addresses
    //`define MC_RESET	    16'h0002
//======================================
//  MB Info Register Bits
//
//======================================
//======================================
//  MB Info Register Bits
//
//======================================
//========================================================================
// DBLK Register:  12'h950 - 12'h97f
//========================================================================
#define HCODEC_DBLK_RST                            ((0x1950  << 2) + 0xff620000)
#define HCODEC_DBLK_CTRL                           ((0x1951  << 2) + 0xff620000)
#define HCODEC_DBLK_MB_WID_HEIGHT                  ((0x1952  << 2) + 0xff620000)
#define HCODEC_DBLK_STATUS                         ((0x1953  << 2) + 0xff620000)
#define HCODEC_DBLK_CMD_CTRL                       ((0x1954  << 2) + 0xff620000)
#define HCODEC_DBLK_MB_XY                          ((0x1955  << 2) + 0xff620000)
#define HCODEC_DBLK_QP                             ((0x1956  << 2) + 0xff620000)
#define HCODEC_DBLK_Y_BHFILT                       ((0x1957  << 2) + 0xff620000)
#define HCODEC_DBLK_Y_BHFILT_HIGH                  ((0x1958  << 2) + 0xff620000)
#define HCODEC_DBLK_Y_BVFILT                       ((0x1959  << 2) + 0xff620000)
#define HCODEC_DBLK_CB_BFILT                       ((0x195a  << 2) + 0xff620000)
#define HCODEC_DBLK_CR_BFILT                       ((0x195b  << 2) + 0xff620000)
#define HCODEC_DBLK_Y_HFILT                        ((0x195c  << 2) + 0xff620000)
#define HCODEC_DBLK_Y_HFILT_HIGH                   ((0x195d  << 2) + 0xff620000)
#define HCODEC_DBLK_Y_VFILT                        ((0x195e  << 2) + 0xff620000)
#define HCODEC_DBLK_CB_FILT                        ((0x195f  << 2) + 0xff620000)
#define HCODEC_DBLK_CR_FILT                        ((0x1960  << 2) + 0xff620000)
#define HCODEC_DBLK_BETAX_QP_SEL                   ((0x1961  << 2) + 0xff620000)
#define HCODEC_DBLK_CLIP_CTRL0                     ((0x1962  << 2) + 0xff620000)
#define HCODEC_DBLK_CLIP_CTRL1                     ((0x1963  << 2) + 0xff620000)
#define HCODEC_DBLK_CLIP_CTRL2                     ((0x1964  << 2) + 0xff620000)
#define HCODEC_DBLK_CLIP_CTRL3                     ((0x1965  << 2) + 0xff620000)
#define HCODEC_DBLK_CLIP_CTRL4                     ((0x1966  << 2) + 0xff620000)
#define HCODEC_DBLK_CLIP_CTRL5                     ((0x1967  << 2) + 0xff620000)
#define HCODEC_DBLK_CLIP_CTRL6                     ((0x1968  << 2) + 0xff620000)
#define HCODEC_DBLK_CLIP_CTRL7                     ((0x1969  << 2) + 0xff620000)
#define HCODEC_DBLK_CLIP_CTRL8                     ((0x196a  << 2) + 0xff620000)
#define HCODEC_DBLK_STATUS1                        ((0x196b  << 2) + 0xff620000)
#define HCODEC_DBLK_GCLK_FREE                      ((0x196c  << 2) + 0xff620000)
#define HCODEC_DBLK_GCLK_OFF                       ((0x196d  << 2) + 0xff620000)
#define HCODEC_DBLK_AVSFLAGS                       ((0x196e  << 2) + 0xff620000)
// bit 15:0
#define HCODEC_DBLK_CBPY                           ((0x1970  << 2) + 0xff620000)
// bit 11:8 -- deblk_cbpy_bottom
// bit 7:4 -- deblk_cbpy_left
// bit 3:0 -- deblk_cbpy_top
#define HCODEC_DBLK_CBPY_ADJ                       ((0x1971  << 2) + 0xff620000)
// bit 7:0 -- deblk_cbpc
#define HCODEC_DBLK_CBPC                           ((0x1972  << 2) + 0xff620000)
// bit 15 -- bottom_mb
// bit 14 -- left_mb
// bit 13 -- top_mb
// bit 12 -- reserved
// bit 11:8 -- deblk_cbpc_bottom
// bit 7:4 -- deblk_cbpc_left
// bit 3:0 -- deblk_cbpc_top
#define HCODEC_DBLK_CBPC_ADJ                       ((0x1973  << 2) + 0xff620000)
// bit 15:8 -- deblk_hmvd   -- {left_1, left_0, below_1, below_0, block3-0}
// bit 7:0 -- deblk_vmvd    -- {top_1, top_0, below_1, below_0, block3-0}
#define HCODEC_DBLK_VHMVD                          ((0x1974  << 2) + 0xff620000)
// bit 13:12 -- right_vmvd
// bit 11 -- right_above_vmvd
// bit 10 -- left_below_hmvd
// bit 9 -- disable_dblk_luma
// bit 8 -- disable_dblk_chroma
// bit 7 -- bBelowRefDiff
// bit 6 -- bLeftRefDiff
// bit 5 -- bAboveRefDiff
// bit 4 -- reserved
// bit 3 -- s_below
// bit 2 -- s_left
// bit 1 -- s_above
// bit 0 -- s
#define HCODEC_DBLK_STRONG                         ((0x1975  << 2) + 0xff620000)
// bit 14:10 -- PQUANT
// bit 9:5 -- left_PQUANT
// bit 4:0 -- top_PQUANT
#define HCODEC_DBLK_RV8_QUANT                      ((0x1976  << 2) + 0xff620000)
#define HCODEC_DBLK_CBUS_HCMD2                     ((0x1977  << 2) + 0xff620000)
#define HCODEC_DBLK_CBUS_HCMD1                     ((0x1978  << 2) + 0xff620000)
#define HCODEC_DBLK_CBUS_HCMD0                     ((0x1979  << 2) + 0xff620000)
#define HCODEC_DBLK_VLD_HCMD2                      ((0x197a  << 2) + 0xff620000)
#define HCODEC_DBLK_VLD_HCMD1                      ((0x197b  << 2) + 0xff620000)
#define HCODEC_DBLK_VLD_HCMD0                      ((0x197c  << 2) + 0xff620000)
#define HCODEC_DBLK_OST_YBASE                      ((0x197d  << 2) + 0xff620000)
#define HCODEC_DBLK_OST_CBCRDIFF                   ((0x197e  << 2) + 0xff620000)
//13:8 dblk thread ID and token
//5:0  dblk pre arbiter burst num
#define HCODEC_DBLK_CTRL1                          ((0x197f  << 2) + 0xff620000)
// MCRCC_CTL1
// 31:3  <reserved[23:0]>
// 2     <cfg_field_pic>
// 1     <sw_rst>
// 0     <bypass_en>
#define HCODEC_MCRCC_CTL1                          ((0x1980  << 2) + 0xff620000)
// MCRCC_CTL2
// 31:24    <cfg_cache_anc01_c[7:0]>
// 23:16    <cfg_cache_anc01_y[7:0]>
// 15:8     <cfg_cache_anc00_c[7:0]>
// 7:0      <cfg_cache_anc00_y[7:0]>
#define HCODEC_MCRCC_CTL2                          ((0x1981  << 2) + 0xff620000)
// MCRCC_CTL3
// 31:24    <cfg_cache_anc11_c[7:0]>
// 23:16    <cfg_cache_anc11_y[7:0]>
// 15:8     <cfg_cache_anc10_c[7:0]>
// 7:0      <cfg_cache_anc10_y[7:0]>
#define HCODEC_MCRCC_CTL3                          ((0x1982  << 2) + 0xff620000)
// bit[31:10] reserved
// bit[9:0] sw_clock_gating control
// [9] vdec clk_en for assist and cbus.
// [8] vdec clk_en for ddr
// [7] vdec clk_en for vcpu
// [6] vdec clk_en for assist
// [5] vdec clk_en for dblk
// [4] vdec clk_en for iqidct
// [3] vdec clk_en for mc
// [2] vdec clk_en for pic_dc
// [1] vdec clk_en for psc
// [0] vdec clk_en for vld
#define HCODEC_GCLK_EN                             ((0x1983  << 2) + 0xff620000)
// [0]  Reserved
// [1]  Reserved
// [2]  Reset assist, mdec's CBUS
// [3]  Reset mdec's VLD
// [4]  Reset mdec's VLD
// [5]  Reset mdec's VLD
// [6]  Reset mdec's IQIDCT
// [7]  Reset mdec's MC
// [8]  Reset mdec's DBLK
// [9]  Reset mdec's PIC_DC
// [10] Reset mdec's Pscale
// [11] Reset vcpu's MCPU
// [12] Reset vcpu's CCPU
// [13] Reset mmc_pre_arb
#define HCODEC_MDEC_SW_RESET                       ((0x1984  << 2) + 0xff620000)
//DBLK last address 12'h97f
//
// Closing file:  mdec_regs.h
//
//
// Reading file:  mdec_regs.h
//
//========================================================================
//  MDEC module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_MDEC_CBUS_BASE = 0x09
// -----------------------------------------------
#define VDEC2_MC_CTRL_REG                          ((0x2900  << 2) + 0xff620000)
#define VDEC2_MC_MB_INFO                           ((0x2901  << 2) + 0xff620000)
#define VDEC2_MC_PIC_INFO                          ((0x2902  << 2) + 0xff620000)
#define VDEC2_MC_HALF_PEL_ONE                      ((0x2903  << 2) + 0xff620000)
#define VDEC2_MC_HALF_PEL_TWO                      ((0x2904  << 2) + 0xff620000)
#define VDEC2_POWER_CTL_MC                         ((0x2905  << 2) + 0xff620000)
#define VDEC2_MC_CMD                               ((0x2906  << 2) + 0xff620000)
#define VDEC2_MC_CTRL0                             ((0x2907  << 2) + 0xff620000)
#define VDEC2_MC_PIC_W_H                           ((0x2908  << 2) + 0xff620000)
#define VDEC2_MC_STATUS0                           ((0x2909  << 2) + 0xff620000)
#define VDEC2_MC_STATUS1                           ((0x290a  << 2) + 0xff620000)
#define VDEC2_MC_CTRL1                             ((0x290b  << 2) + 0xff620000)
#define VDEC2_MC_MIX_RATIO0                        ((0x290c  << 2) + 0xff620000)
#define VDEC2_MC_MIX_RATIO1                        ((0x290d  << 2) + 0xff620000)
#define VDEC2_MC_DP_MB_XY                          ((0x290e  << 2) + 0xff620000)
#define VDEC2_MC_OM_MB_XY                          ((0x290f  << 2) + 0xff620000)
#define VDEC2_PSCALE_RST                           ((0x2910  << 2) + 0xff620000)
#define VDEC2_PSCALE_CTRL                          ((0x2911  << 2) + 0xff620000)
#define VDEC2_PSCALE_PICI_W                        ((0x2912  << 2) + 0xff620000)
#define VDEC2_PSCALE_PICI_H                        ((0x2913  << 2) + 0xff620000)
#define VDEC2_PSCALE_PICO_W                        ((0x2914  << 2) + 0xff620000)
#define VDEC2_PSCALE_PICO_H                        ((0x2915  << 2) + 0xff620000)
#define VDEC2_PSCALE_PICO_START_X                  ((0x2916  << 2) + 0xff620000)
#define VDEC2_PSCALE_PICO_START_Y                  ((0x2917  << 2) + 0xff620000)
#define VDEC2_PSCALE_DUMMY                         ((0x2918  << 2) + 0xff620000)
#define VDEC2_PSCALE_FILT0_COEF0                   ((0x2919  << 2) + 0xff620000)
#define VDEC2_PSCALE_FILT0_COEF1                   ((0x291a  << 2) + 0xff620000)
#define VDEC2_PSCALE_CMD_CTRL                      ((0x291b  << 2) + 0xff620000)
#define VDEC2_PSCALE_CMD_BLK_X                     ((0x291c  << 2) + 0xff620000)
#define VDEC2_PSCALE_CMD_BLK_Y                     ((0x291d  << 2) + 0xff620000)
#define VDEC2_PSCALE_STATUS                        ((0x291e  << 2) + 0xff620000)
#define VDEC2_PSCALE_BMEM_ADDR                     ((0x291f  << 2) + 0xff620000)
#define VDEC2_PSCALE_BMEM_DAT                      ((0x2920  << 2) + 0xff620000)
#define VDEC2_PSCALE_DRAM_BUF_CTRL                 ((0x2921  << 2) + 0xff620000)
#define VDEC2_PSCALE_MCMD_CTRL                     ((0x2922  << 2) + 0xff620000)
#define VDEC2_PSCALE_MCMD_XSIZE                    ((0x2923  << 2) + 0xff620000)
#define VDEC2_PSCALE_MCMD_YSIZE                    ((0x2924  << 2) + 0xff620000)
#define VDEC2_PSCALE_RBUF_START_BLKX               ((0x2925  << 2) + 0xff620000)
#define VDEC2_PSCALE_RBUF_START_BLKY               ((0x2926  << 2) + 0xff620000)
//`define PSCALE_RBUF_MB_WIDTH   8'h27
#define VDEC2_PSCALE_PICO_SHIFT_XY                 ((0x2928  << 2) + 0xff620000)
#define VDEC2_PSCALE_CTRL1                         ((0x2929  << 2) + 0xff620000)
//Bit 15, wmask enable
//Bit 14:13, filt0 srckey_less,
//Bit 12:11, filt1 srckey_less, in the case of the interpolated data is equal distance to
//key data and normal data, 00: select normal data, 01: select right data, 10: select key data
//Bit 10:9, srckey mode, 00: equal, 01: less than or equal, 10: great than or equal
//Bit 8, src key enable
//Bit 7:0, y src key
#define VDEC2_PSCALE_SRCKEY_CTRL0                  ((0x292a  << 2) + 0xff620000)
//Bit 15:8, cb src key
//Bit 7:0, cr src key
#define VDEC2_PSCALE_SRCKEY_CTRL1                  ((0x292b  << 2) + 0xff620000)
//Bit 22:16 canvas_rd_addr2
//Bit 14:8 canvas_rd_addr1
//Bit 6:0 canvas_rd_addr1
#define VDEC2_PSCALE_CANVAS_RD_ADDR                ((0x292c  << 2) + 0xff620000)
//Bit 22:16 canvas_wr_addr2
//Bit 14:8 canvas_wr_addr1
//Bit 6:0 canvas_wr_addr1
#define VDEC2_PSCALE_CANVAS_WR_ADDR                ((0x292d  << 2) + 0xff620000)
//bit 13:8 pscale thread ID and token
//bit 7 disable write response count adding to busy bit
//bit 5:0  pscale pre arbiter burst num
#define VDEC2_PSCALE_CTRL2                         ((0x292e  << 2) + 0xff620000)
//   31 - use_omem_mb_xy_auto
//23:16 - omem_max_mb_x
//15:8  - omem_mb_y_auto
// 7:0  - omem_mb_x_auto
#define VDEC2_HDEC_MC_OMEM_AUTO                    ((0x2930  << 2) + 0xff620000)
#define VDEC2_HDEC_MC_MBRIGHT_IDX                  ((0x2931  << 2) + 0xff620000)
#define VDEC2_HDEC_MC_MBRIGHT_RD                   ((0x2932  << 2) + 0xff620000)
#define VDEC2_MC_MPORT_CTRL                        ((0x2940  << 2) + 0xff620000)
#define VDEC2_MC_MPORT_DAT                         ((0x2941  << 2) + 0xff620000)
#define VDEC2_MC_WT_PRED_CTRL                      ((0x2942  << 2) + 0xff620000)
#define VDEC2_MC_MBBOT_ST_EVEN_ADDR                ((0x2944  << 2) + 0xff620000)
#define VDEC2_MC_MBBOT_ST_ODD_ADDR                 ((0x2945  << 2) + 0xff620000)
#define VDEC2_MC_DPDN_MB_XY                        ((0x2946  << 2) + 0xff620000)
#define VDEC2_MC_OMDN_MB_XY                        ((0x2947  << 2) + 0xff620000)
#define VDEC2_MC_HCMDBUF_H                         ((0x2948  << 2) + 0xff620000)
#define VDEC2_MC_HCMDBUF_L                         ((0x2949  << 2) + 0xff620000)
#define VDEC2_MC_HCMD_H                            ((0x294a  << 2) + 0xff620000)
#define VDEC2_MC_HCMD_L                            ((0x294b  << 2) + 0xff620000)
#define VDEC2_MC_IDCT_DAT                          ((0x294c  << 2) + 0xff620000)
#define VDEC2_MC_CTRL_GCLK_CTRL                    ((0x294d  << 2) + 0xff620000)
#define VDEC2_MC_OTHER_GCLK_CTRL                   ((0x294e  << 2) + 0xff620000)
//Bit 29:24, mbbot thread ID and token
//Bit 21:16, mc read/write thread ID and token
//Bit 13:8,  mbbot pre-arbitor burst number
//Bit 5:0,   mc pre-arbitor burst number
#define VDEC2_MC_CTRL2                             ((0x294f  << 2) + 0xff620000)
// `define DBLK_QUANT            8'h76 // ONLY for $ucode/real/amrisc/rv.s, reg value from apollo
//`define ANC1_CANVAS_ADDR      8'h80
//`define ANC2_CANVAS_ADDR      8'h81
//`define REC_CANVAS_ADDR       8'h89
//`define MDEC_PIC_W          8'h8c
//`define MDEC_PIC_H          8'h8d
// mdec_pic_dc_mux_ctrl[31]  -- mcr_hevc_mode
#define VDEC2_MDEC_PIC_DC_MUX_CTRL                 ((0x298d  << 2) + 0xff620000)
#define VDEC2_MDEC_PIC_DC_CTRL                     ((0x298e  << 2) + 0xff620000)
#define VDEC2_MDEC_PIC_DC_STATUS                   ((0x298f  << 2) + 0xff620000)
#define VDEC2_ANC0_CANVAS_ADDR                     ((0x2990  << 2) + 0xff620000)
#define VDEC2_ANC1_CANVAS_ADDR                     ((0x2991  << 2) + 0xff620000)
#define VDEC2_ANC2_CANVAS_ADDR                     ((0x2992  << 2) + 0xff620000)
#define VDEC2_ANC3_CANVAS_ADDR                     ((0x2993  << 2) + 0xff620000)
#define VDEC2_ANC4_CANVAS_ADDR                     ((0x2994  << 2) + 0xff620000)
#define VDEC2_ANC5_CANVAS_ADDR                     ((0x2995  << 2) + 0xff620000)
#define VDEC2_ANC6_CANVAS_ADDR                     ((0x2996  << 2) + 0xff620000)
#define VDEC2_ANC7_CANVAS_ADDR                     ((0x2997  << 2) + 0xff620000)
#define VDEC2_ANC8_CANVAS_ADDR                     ((0x2998  << 2) + 0xff620000)
#define VDEC2_ANC9_CANVAS_ADDR                     ((0x2999  << 2) + 0xff620000)
#define VDEC2_ANC10_CANVAS_ADDR                    ((0x299a  << 2) + 0xff620000)
#define VDEC2_ANC11_CANVAS_ADDR                    ((0x299b  << 2) + 0xff620000)
#define VDEC2_ANC12_CANVAS_ADDR                    ((0x299c  << 2) + 0xff620000)
#define VDEC2_ANC13_CANVAS_ADDR                    ((0x299d  << 2) + 0xff620000)
#define VDEC2_ANC14_CANVAS_ADDR                    ((0x299e  << 2) + 0xff620000)
#define VDEC2_ANC15_CANVAS_ADDR                    ((0x299f  << 2) + 0xff620000)
#define VDEC2_ANC16_CANVAS_ADDR                    ((0x29a0  << 2) + 0xff620000)
#define VDEC2_ANC17_CANVAS_ADDR                    ((0x29a1  << 2) + 0xff620000)
#define VDEC2_ANC18_CANVAS_ADDR                    ((0x29a2  << 2) + 0xff620000)
#define VDEC2_ANC19_CANVAS_ADDR                    ((0x29a3  << 2) + 0xff620000)
#define VDEC2_ANC20_CANVAS_ADDR                    ((0x29a4  << 2) + 0xff620000)
#define VDEC2_ANC21_CANVAS_ADDR                    ((0x29a5  << 2) + 0xff620000)
#define VDEC2_ANC22_CANVAS_ADDR                    ((0x29a6  << 2) + 0xff620000)
#define VDEC2_ANC23_CANVAS_ADDR                    ((0x29a7  << 2) + 0xff620000)
#define VDEC2_ANC24_CANVAS_ADDR                    ((0x29a8  << 2) + 0xff620000)
#define VDEC2_ANC25_CANVAS_ADDR                    ((0x29a9  << 2) + 0xff620000)
#define VDEC2_ANC26_CANVAS_ADDR                    ((0x29aa  << 2) + 0xff620000)
#define VDEC2_ANC27_CANVAS_ADDR                    ((0x29ab  << 2) + 0xff620000)
#define VDEC2_ANC28_CANVAS_ADDR                    ((0x29ac  << 2) + 0xff620000)
#define VDEC2_ANC29_CANVAS_ADDR                    ((0x29ad  << 2) + 0xff620000)
#define VDEC2_ANC30_CANVAS_ADDR                    ((0x29ae  << 2) + 0xff620000)
#define VDEC2_ANC31_CANVAS_ADDR                    ((0x29af  << 2) + 0xff620000)
#define VDEC2_DBKR_CANVAS_ADDR                     ((0x29b0  << 2) + 0xff620000)
#define VDEC2_DBKW_CANVAS_ADDR                     ((0x29b1  << 2) + 0xff620000)
#define VDEC2_REC_CANVAS_ADDR                      ((0x29b2  << 2) + 0xff620000)
//28:24, read/write, current canvas idx, used in h264 only now
//23:0, read only, current canvas address, 23:16, Cr canvas addr, 15:8, Cb canvas addr, 7:0, Y  canvas addr
#define VDEC2_CURR_CANVAS_CTRL                     ((0x29b3  << 2) + 0xff620000)
#define VDEC2_MDEC_PIC_DC_THRESH                   ((0x29b8  << 2) + 0xff620000)
#define VDEC2_MDEC_PICR_BUF_STATUS                 ((0x29b9  << 2) + 0xff620000)
#define VDEC2_MDEC_PICW_BUF_STATUS                 ((0x29ba  << 2) + 0xff620000)
#define VDEC2_MCW_DBLK_WRRSP_CNT                   ((0x29bb  << 2) + 0xff620000)
#define VDEC2_MC_MBBOT_WRRSP_CNT                   ((0x29bc  << 2) + 0xff620000)
#define VDEC2_MDEC_PICW_BUF2_STATUS                ((0x29bd  << 2) + 0xff620000)
#define VDEC2_WRRSP_FIFO_PICW_DBK                  ((0x29be  << 2) + 0xff620000)
#define VDEC2_WRRSP_FIFO_PICW_MC                   ((0x29bf  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_0                         ((0x29c0  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_1                         ((0x29c1  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_2                         ((0x29c2  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_3                         ((0x29c3  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_4                         ((0x29c4  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_5                         ((0x29c5  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_6                         ((0x29c6  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_7                         ((0x29c7  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_8                         ((0x29c8  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_9                         ((0x29c9  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_A                         ((0x29ca  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_B                         ((0x29cb  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_C                         ((0x29cc  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_D                         ((0x29cd  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_E                         ((0x29ce  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_F                         ((0x29cf  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_G                         ((0x29d0  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_H                         ((0x29d1  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_I                         ((0x29d2  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_J                         ((0x29d3  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_K                         ((0x29d4  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_L                         ((0x29d5  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_M                         ((0x29d6  << 2) + 0xff620000)
#define VDEC2_AV_SCRATCH_N                         ((0x29d7  << 2) + 0xff620000)
// bit[29:24] A_brst_num_co_mb
// bit[21:16] A_id_co_mb
// bit[11:0] wrrsp_count_co_mb
#define VDEC2_WRRSP_CO_MB                          ((0x29d8  << 2) + 0xff620000)
// bit[29:24] A_brst_num_dcac
// bit[21:16] A_id_dcac
// bit[11:0] wrrsp_count_dcac
#define VDEC2_WRRSP_DCAC                           ((0x29d9  << 2) + 0xff620000)
// bit[11:0] wrrsp_count_vld
#define VDEC2_WRRSP_VLD                            ((0x29da  << 2) + 0xff620000)
// doublew_cfg0[0];     //       Second Channel Enable, 1:Enable 0:Disable
// doublew_cfg0[3:1];   // [2:0] Endian Control for Luma
// doublew_cfg0[5:4];   // [1:0] Pixel sel by horizontal, 0x:1/2 10:left 11:right
// doublew_cfg0[7:6];   // [1:0] Pixel sel by vertical,   0x:1/2 10:up 11:down
// doublew_cfg0[8];     //       Size by horizontal, 0:original size 1: 1/2 shrunken size
// doublew_cfg0[9];     //       Size by vertical,   0:original size 1: 1/2 shrunken size
// doublew_cfg0[10];    //       1:Round 0:Truncation
// doublew_cfg0[11];    //       DMA Urgent
// doublew_cfg0[17:12]; // [5:0] DMA Burst Number
// doublew_cfg0[23:18]; // [5:0] DMA ID
// doublew_cfg0[26:24]; // [2:0] Endian Control for Chroma
// doublew_cfg0[27];    //       Source from, 1:MCW 0:DBLK
// doublew_cfg0[29:28]; // [1:0] 0x:select both top and bottom 10:select top 11:select bottom
// doublew_cfg0[30];    //       0:no merge 1:automatic merge
// doublew_cfg0[31];    //       0:Y addr no change 1:Y addr divided to half
#define VDEC2_MDEC_DOUBLEW_CFG0                    ((0x29db  << 2) + 0xff620000)
// doublew_cfg1[7:0];   // [7:0] DMA Canvas Address for Luma
// doublew_cfg1[15:8];  // [7:0] DMA Canvas Address for Chroma
// doublew_cfg1[16];    //       Disable 1st Write -
// doublew_cfg1[17];    //       Reverse to original version -
// doublew_cfg1[18];    //       DMA Address Mode - 0:Canvas Mode 1:Non-Canvas Mode
#define VDEC2_MDEC_DOUBLEW_CFG1                    ((0x29dc  << 2) + 0xff620000)
// doublew_cfg2[11:0];  //[11:0] vertical flip initial value
// doublew_cfg2[15];    //       vertical flip enable
// doublew_cfg2[24:16]; // [8:0] horizontal flip initial value
// doublew_cfg2[31];    //       horizontal flip enable
#define VDEC2_MDEC_DOUBLEW_CFG2                    ((0x29dd  << 2) + 0xff620000)
// doublew_cfg3[31:0];  //[31:0] non-canvas start address for Luma -
#define VDEC2_MDEC_DOUBLEW_CFG3                    ((0x29de  << 2) + 0xff620000)
// doublew_cfg4[31:0];  //[31:0] non-canvas start address for Chroma -
#define VDEC2_MDEC_DOUBLEW_CFG4                    ((0x29df  << 2) + 0xff620000)
// doublew_cfg5[12:0];  //[12:0] non-canvas picture width for Luma -
// doublew_cfg5[28:16]; //[12:0] non-canvas picture width for Chroma -
#define VDEC2_MDEC_DOUBLEW_CFG5                    ((0x29e0  << 2) + 0xff620000)
// doublew_cfg6: reserved
#define VDEC2_MDEC_DOUBLEW_CFG6                    ((0x29e1  << 2) + 0xff620000)
// doublew_cfg7: reserved
#define VDEC2_MDEC_DOUBLEW_CFG7                    ((0x29e2  << 2) + 0xff620000)
// doublew_status[11:0];//[11:0] wrrsp_count_doublew
// doublew_status[12];  //       doublew_status_busy
// doublew_status[13];  //       doublew_status_error
#define VDEC2_MDEC_DOUBLEW_STATUS                  ((0x29e3  << 2) + 0xff620000)
#define VDEC2_MDEC_EXTIF_CFG0                      ((0x29e4  << 2) + 0xff620000)
#define VDEC2_MDEC_EXTIF_CFG1                      ((0x29e5  << 2) + 0xff620000)
#define VDEC2_MDEC_EXTIF_STS0                      ((0x29e6  << 2) + 0xff620000)
//======================================
//  MC Control Register Bits
//
//======================================
// For bits, just copy the defines...don't translate to addresses
    //`define MC_RESET	    16'h0002
//======================================
//  MB Info Register Bits
//
//======================================
//======================================
//  MB Info Register Bits
//
//======================================
//========================================================================
// DBLK Register:  12'h950 - 12'h97f
//========================================================================
#define VDEC2_DBLK_RST                             ((0x2950  << 2) + 0xff620000)
#define VDEC2_DBLK_CTRL                            ((0x2951  << 2) + 0xff620000)
#define VDEC2_DBLK_MB_WID_HEIGHT                   ((0x2952  << 2) + 0xff620000)
#define VDEC2_DBLK_STATUS                          ((0x2953  << 2) + 0xff620000)
#define VDEC2_DBLK_CMD_CTRL                        ((0x2954  << 2) + 0xff620000)
#define VDEC2_DBLK_MB_XY                           ((0x2955  << 2) + 0xff620000)
#define VDEC2_DBLK_QP                              ((0x2956  << 2) + 0xff620000)
#define VDEC2_DBLK_Y_BHFILT                        ((0x2957  << 2) + 0xff620000)
#define VDEC2_DBLK_Y_BHFILT_HIGH                   ((0x2958  << 2) + 0xff620000)
#define VDEC2_DBLK_Y_BVFILT                        ((0x2959  << 2) + 0xff620000)
#define VDEC2_DBLK_CB_BFILT                        ((0x295a  << 2) + 0xff620000)
#define VDEC2_DBLK_CR_BFILT                        ((0x295b  << 2) + 0xff620000)
#define VDEC2_DBLK_Y_HFILT                         ((0x295c  << 2) + 0xff620000)
#define VDEC2_DBLK_Y_HFILT_HIGH                    ((0x295d  << 2) + 0xff620000)
#define VDEC2_DBLK_Y_VFILT                         ((0x295e  << 2) + 0xff620000)
#define VDEC2_DBLK_CB_FILT                         ((0x295f  << 2) + 0xff620000)
#define VDEC2_DBLK_CR_FILT                         ((0x2960  << 2) + 0xff620000)
#define VDEC2_DBLK_BETAX_QP_SEL                    ((0x2961  << 2) + 0xff620000)
#define VDEC2_DBLK_CLIP_CTRL0                      ((0x2962  << 2) + 0xff620000)
#define VDEC2_DBLK_CLIP_CTRL1                      ((0x2963  << 2) + 0xff620000)
#define VDEC2_DBLK_CLIP_CTRL2                      ((0x2964  << 2) + 0xff620000)
#define VDEC2_DBLK_CLIP_CTRL3                      ((0x2965  << 2) + 0xff620000)
#define VDEC2_DBLK_CLIP_CTRL4                      ((0x2966  << 2) + 0xff620000)
#define VDEC2_DBLK_CLIP_CTRL5                      ((0x2967  << 2) + 0xff620000)
#define VDEC2_DBLK_CLIP_CTRL6                      ((0x2968  << 2) + 0xff620000)
#define VDEC2_DBLK_CLIP_CTRL7                      ((0x2969  << 2) + 0xff620000)
#define VDEC2_DBLK_CLIP_CTRL8                      ((0x296a  << 2) + 0xff620000)
#define VDEC2_DBLK_STATUS1                         ((0x296b  << 2) + 0xff620000)
#define VDEC2_DBLK_GCLK_FREE                       ((0x296c  << 2) + 0xff620000)
#define VDEC2_DBLK_GCLK_OFF                        ((0x296d  << 2) + 0xff620000)
#define VDEC2_DBLK_AVSFLAGS                        ((0x296e  << 2) + 0xff620000)
// bit 15:0
#define VDEC2_DBLK_CBPY                            ((0x2970  << 2) + 0xff620000)
// bit 11:8 -- deblk_cbpy_bottom
// bit 7:4 -- deblk_cbpy_left
// bit 3:0 -- deblk_cbpy_top
#define VDEC2_DBLK_CBPY_ADJ                        ((0x2971  << 2) + 0xff620000)
// bit 7:0 -- deblk_cbpc
#define VDEC2_DBLK_CBPC                            ((0x2972  << 2) + 0xff620000)
// bit 15 -- bottom_mb
// bit 14 -- left_mb
// bit 13 -- top_mb
// bit 12 -- reserved
// bit 11:8 -- deblk_cbpc_bottom
// bit 7:4 -- deblk_cbpc_left
// bit 3:0 -- deblk_cbpc_top
#define VDEC2_DBLK_CBPC_ADJ                        ((0x2973  << 2) + 0xff620000)
// bit 15:8 -- deblk_hmvd   -- {left_1, left_0, below_1, below_0, block3-0}
// bit 7:0 -- deblk_vmvd    -- {top_1, top_0, below_1, below_0, block3-0}
#define VDEC2_DBLK_VHMVD                           ((0x2974  << 2) + 0xff620000)
// bit 13:12 -- right_vmvd
// bit 11 -- right_above_vmvd
// bit 10 -- left_below_hmvd
// bit 9 -- disable_dblk_luma
// bit 8 -- disable_dblk_chroma
// bit 7 -- bBelowRefDiff
// bit 6 -- bLeftRefDiff
// bit 5 -- bAboveRefDiff
// bit 4 -- reserved
// bit 3 -- s_below
// bit 2 -- s_left
// bit 1 -- s_above
// bit 0 -- s
#define VDEC2_DBLK_STRONG                          ((0x2975  << 2) + 0xff620000)
// bit 14:10 -- PQUANT
// bit 9:5 -- left_PQUANT
// bit 4:0 -- top_PQUANT
#define VDEC2_DBLK_RV8_QUANT                       ((0x2976  << 2) + 0xff620000)
#define VDEC2_DBLK_CBUS_HCMD2                      ((0x2977  << 2) + 0xff620000)
#define VDEC2_DBLK_CBUS_HCMD1                      ((0x2978  << 2) + 0xff620000)
#define VDEC2_DBLK_CBUS_HCMD0                      ((0x2979  << 2) + 0xff620000)
#define VDEC2_DBLK_VLD_HCMD2                       ((0x297a  << 2) + 0xff620000)
#define VDEC2_DBLK_VLD_HCMD1                       ((0x297b  << 2) + 0xff620000)
#define VDEC2_DBLK_VLD_HCMD0                       ((0x297c  << 2) + 0xff620000)
#define VDEC2_DBLK_OST_YBASE                       ((0x297d  << 2) + 0xff620000)
#define VDEC2_DBLK_OST_CBCRDIFF                    ((0x297e  << 2) + 0xff620000)
//13:8 dblk thread ID and token
//5:0  dblk pre arbiter burst num
#define VDEC2_DBLK_CTRL1                           ((0x297f  << 2) + 0xff620000)
// MCRCC_CTL1
// 31:3  <reserved[23:0]>
// 2     <cfg_field_pic>
// 1     <sw_rst>
// 0     <bypass_en>
#define VDEC2_MCRCC_CTL1                           ((0x2980  << 2) + 0xff620000)
// MCRCC_CTL2
// 31:24    <cfg_cache_anc01_c[7:0]>
// 23:16    <cfg_cache_anc01_y[7:0]>
// 15:8     <cfg_cache_anc00_c[7:0]>
// 7:0      <cfg_cache_anc00_y[7:0]>
#define VDEC2_MCRCC_CTL2                           ((0x2981  << 2) + 0xff620000)
// MCRCC_CTL3
// 31:24    <cfg_cache_anc11_c[7:0]>
// 23:16    <cfg_cache_anc11_y[7:0]>
// 15:8     <cfg_cache_anc10_c[7:0]>
// 7:0      <cfg_cache_anc10_y[7:0]>
#define VDEC2_MCRCC_CTL3                           ((0x2982  << 2) + 0xff620000)
// bit[31:10] reserved
// bit[9:0] sw_clock_gating control
// [9] vdec clk_en for assist and cbus.
// [8] vdec clk_en for ddr
// [7] vdec clk_en for vcpu
// [6] vdec clk_en for assist
// [5] vdec clk_en for dblk
// [4] vdec clk_en for iqidct
// [3] vdec clk_en for mc
// [2] vdec clk_en for pic_dc
// [1] vdec clk_en for psc
// [0] vdec clk_en for vld
#define VDEC2_GCLK_EN                              ((0x2983  << 2) + 0xff620000)
// [0]  Reserved
// [1]  Reserved
// [2]  Reset assist, mdec's CBUS
// [3]  Reset mdec's VLD
// [4]  Reset mdec's VLD
// [5]  Reset mdec's VLD
// [6]  Reset mdec's IQIDCT
// [7]  Reset mdec's MC
// [8]  Reset mdec's DBLK
// [9]  Reset mdec's PIC_DC
// [10] Reset mdec's Pscale
// [11] Reset vcpu's MCPU
// [12] Reset vcpu's CCPU
// [13] Reset mmc_pre_arb
#define VDEC2_MDEC_SW_RESET                        ((0x2984  << 2) + 0xff620000)
//DBLK last address 12'h97f
//
// Closing file:  mdec_regs.h
//
//
// Reading file:  mdec_regs.h
//
//========================================================================
//  MDEC module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_MDEC_CBUS_BASE = 0x09
// -----------------------------------------------
#define HEVC_MC_CTRL_REG                           ((0x3900  << 2) + 0xff620000)
#define HEVC_MC_MB_INFO                            ((0x3901  << 2) + 0xff620000)
#define HEVC_MC_PIC_INFO                           ((0x3902  << 2) + 0xff620000)
#define HEVC_MC_HALF_PEL_ONE                       ((0x3903  << 2) + 0xff620000)
#define HEVC_MC_HALF_PEL_TWO                       ((0x3904  << 2) + 0xff620000)
#define HEVC_POWER_CTL_MC                          ((0x3905  << 2) + 0xff620000)
#define HEVC_MC_CMD                                ((0x3906  << 2) + 0xff620000)
#define HEVC_MC_CTRL0                              ((0x3907  << 2) + 0xff620000)
#define HEVC_MC_PIC_W_H                            ((0x3908  << 2) + 0xff620000)
#define HEVC_MC_STATUS0                            ((0x3909  << 2) + 0xff620000)
#define HEVC_MC_STATUS1                            ((0x390a  << 2) + 0xff620000)
#define HEVC_MC_CTRL1                              ((0x390b  << 2) + 0xff620000)
#define HEVC_MC_MIX_RATIO0                         ((0x390c  << 2) + 0xff620000)
#define HEVC_MC_MIX_RATIO1                         ((0x390d  << 2) + 0xff620000)
#define HEVC_MC_DP_MB_XY                           ((0x390e  << 2) + 0xff620000)
#define HEVC_MC_OM_MB_XY                           ((0x390f  << 2) + 0xff620000)
#define HEVC_PSCALE_RST                            ((0x3910  << 2) + 0xff620000)
#define HEVC_PSCALE_CTRL                           ((0x3911  << 2) + 0xff620000)
#define HEVC_PSCALE_PICI_W                         ((0x3912  << 2) + 0xff620000)
#define HEVC_PSCALE_PICI_H                         ((0x3913  << 2) + 0xff620000)
#define HEVC_PSCALE_PICO_W                         ((0x3914  << 2) + 0xff620000)
#define HEVC_PSCALE_PICO_H                         ((0x3915  << 2) + 0xff620000)
#define HEVC_PSCALE_PICO_START_X                   ((0x3916  << 2) + 0xff620000)
#define HEVC_PSCALE_PICO_START_Y                   ((0x3917  << 2) + 0xff620000)
#define HEVC_PSCALE_DUMMY                          ((0x3918  << 2) + 0xff620000)
#define HEVC_PSCALE_FILT0_COEF0                    ((0x3919  << 2) + 0xff620000)
#define HEVC_PSCALE_FILT0_COEF1                    ((0x391a  << 2) + 0xff620000)
#define HEVC_PSCALE_CMD_CTRL                       ((0x391b  << 2) + 0xff620000)
#define HEVC_PSCALE_CMD_BLK_X                      ((0x391c  << 2) + 0xff620000)
#define HEVC_PSCALE_CMD_BLK_Y                      ((0x391d  << 2) + 0xff620000)
#define HEVC_PSCALE_STATUS                         ((0x391e  << 2) + 0xff620000)
#define HEVC_PSCALE_BMEM_ADDR                      ((0x391f  << 2) + 0xff620000)
#define HEVC_PSCALE_BMEM_DAT                       ((0x3920  << 2) + 0xff620000)
#define HEVC_PSCALE_DRAM_BUF_CTRL                  ((0x3921  << 2) + 0xff620000)
#define HEVC_PSCALE_MCMD_CTRL                      ((0x3922  << 2) + 0xff620000)
#define HEVC_PSCALE_MCMD_XSIZE                     ((0x3923  << 2) + 0xff620000)
#define HEVC_PSCALE_MCMD_YSIZE                     ((0x3924  << 2) + 0xff620000)
#define HEVC_PSCALE_RBUF_START_BLKX                ((0x3925  << 2) + 0xff620000)
#define HEVC_PSCALE_RBUF_START_BLKY                ((0x3926  << 2) + 0xff620000)
//`define PSCALE_RBUF_MB_WIDTH   8'h27
#define HEVC_PSCALE_PICO_SHIFT_XY                  ((0x3928  << 2) + 0xff620000)
#define HEVC_PSCALE_CTRL1                          ((0x3929  << 2) + 0xff620000)
//Bit 15, wmask enable
//Bit 14:13, filt0 srckey_less,
//Bit 12:11, filt1 srckey_less, in the case of the interpolated data is equal distance to
//key data and normal data, 00: select normal data, 01: select right data, 10: select key data
//Bit 10:9, srckey mode, 00: equal, 01: less than or equal, 10: great than or equal
//Bit 8, src key enable
//Bit 7:0, y src key
#define HEVC_PSCALE_SRCKEY_CTRL0                   ((0x392a  << 2) + 0xff620000)
//Bit 15:8, cb src key
//Bit 7:0, cr src key
#define HEVC_PSCALE_SRCKEY_CTRL1                   ((0x392b  << 2) + 0xff620000)
//Bit 22:16 canvas_rd_addr2
//Bit 14:8 canvas_rd_addr1
//Bit 6:0 canvas_rd_addr1
#define HEVC_PSCALE_CANVAS_RD_ADDR                 ((0x392c  << 2) + 0xff620000)
//Bit 22:16 canvas_wr_addr2
//Bit 14:8 canvas_wr_addr1
//Bit 6:0 canvas_wr_addr1
#define HEVC_PSCALE_CANVAS_WR_ADDR                 ((0x392d  << 2) + 0xff620000)
//bit 13:8 pscale thread ID and token
//bit 7 disable write response count adding to busy bit
//bit 5:0  pscale pre arbiter burst num
#define HEVC_PSCALE_CTRL2                          ((0x392e  << 2) + 0xff620000)
//   31 - use_omem_mb_xy_auto
//23:16 - omem_max_mb_x
//15:8  - omem_mb_y_auto
// 7:0  - omem_mb_x_auto
#define HEVC_HDEC_MC_OMEM_AUTO                     ((0x3930  << 2) + 0xff620000)
#define HEVC_HDEC_MC_MBRIGHT_IDX                   ((0x3931  << 2) + 0xff620000)
#define HEVC_HDEC_MC_MBRIGHT_RD                    ((0x3932  << 2) + 0xff620000)
#define HEVC_MC_MPORT_CTRL                         ((0x3940  << 2) + 0xff620000)
#define HEVC_MC_MPORT_DAT                          ((0x3941  << 2) + 0xff620000)
#define HEVC_MC_WT_PRED_CTRL                       ((0x3942  << 2) + 0xff620000)
#define HEVC_MC_MBBOT_ST_EVEN_ADDR                 ((0x3944  << 2) + 0xff620000)
#define HEVC_MC_MBBOT_ST_ODD_ADDR                  ((0x3945  << 2) + 0xff620000)
#define HEVC_MC_DPDN_MB_XY                         ((0x3946  << 2) + 0xff620000)
#define HEVC_MC_OMDN_MB_XY                         ((0x3947  << 2) + 0xff620000)
#define HEVC_MC_HCMDBUF_H                          ((0x3948  << 2) + 0xff620000)
#define HEVC_MC_HCMDBUF_L                          ((0x3949  << 2) + 0xff620000)
#define HEVC_MC_HCMD_H                             ((0x394a  << 2) + 0xff620000)
#define HEVC_MC_HCMD_L                             ((0x394b  << 2) + 0xff620000)
#define HEVC_MC_IDCT_DAT                           ((0x394c  << 2) + 0xff620000)
#define HEVC_MC_CTRL_GCLK_CTRL                     ((0x394d  << 2) + 0xff620000)
#define HEVC_MC_OTHER_GCLK_CTRL                    ((0x394e  << 2) + 0xff620000)
//Bit 29:24, mbbot thread ID and token
//Bit 21:16, mc read/write thread ID and token
//Bit 13:8,  mbbot pre-arbitor burst number
//Bit 5:0,   mc pre-arbitor burst number
#define HEVC_MC_CTRL2                              ((0x394f  << 2) + 0xff620000)
// `define DBLK_QUANT            8'h76 // ONLY for $ucode/real/amrisc/rv.s, reg value from apollo
//`define ANC1_CANVAS_ADDR      8'h80
//`define ANC2_CANVAS_ADDR      8'h81
//`define REC_CANVAS_ADDR       8'h89
//`define MDEC_PIC_W          8'h8c
//`define MDEC_PIC_H          8'h8d
// mdec_pic_dc_mux_ctrl[31]  -- mcr_hevc_mode
#define HEVC_MDEC_PIC_DC_MUX_CTRL                  ((0x398d  << 2) + 0xff620000)
#define HEVC_MDEC_PIC_DC_CTRL                      ((0x398e  << 2) + 0xff620000)
#define HEVC_MDEC_PIC_DC_STATUS                    ((0x398f  << 2) + 0xff620000)
#define HEVC_ANC0_CANVAS_ADDR                      ((0x3990  << 2) + 0xff620000)
#define HEVC_ANC1_CANVAS_ADDR                      ((0x3991  << 2) + 0xff620000)
#define HEVC_ANC2_CANVAS_ADDR                      ((0x3992  << 2) + 0xff620000)
#define HEVC_ANC3_CANVAS_ADDR                      ((0x3993  << 2) + 0xff620000)
#define HEVC_ANC4_CANVAS_ADDR                      ((0x3994  << 2) + 0xff620000)
#define HEVC_ANC5_CANVAS_ADDR                      ((0x3995  << 2) + 0xff620000)
#define HEVC_ANC6_CANVAS_ADDR                      ((0x3996  << 2) + 0xff620000)
#define HEVC_ANC7_CANVAS_ADDR                      ((0x3997  << 2) + 0xff620000)
#define HEVC_ANC8_CANVAS_ADDR                      ((0x3998  << 2) + 0xff620000)
#define HEVC_ANC9_CANVAS_ADDR                      ((0x3999  << 2) + 0xff620000)
#define HEVC_ANC10_CANVAS_ADDR                     ((0x399a  << 2) + 0xff620000)
#define HEVC_ANC11_CANVAS_ADDR                     ((0x399b  << 2) + 0xff620000)
#define HEVC_ANC12_CANVAS_ADDR                     ((0x399c  << 2) + 0xff620000)
#define HEVC_ANC13_CANVAS_ADDR                     ((0x399d  << 2) + 0xff620000)
#define HEVC_ANC14_CANVAS_ADDR                     ((0x399e  << 2) + 0xff620000)
#define HEVC_ANC15_CANVAS_ADDR                     ((0x399f  << 2) + 0xff620000)
#define HEVC_ANC16_CANVAS_ADDR                     ((0x39a0  << 2) + 0xff620000)
#define HEVC_ANC17_CANVAS_ADDR                     ((0x39a1  << 2) + 0xff620000)
#define HEVC_ANC18_CANVAS_ADDR                     ((0x39a2  << 2) + 0xff620000)
#define HEVC_ANC19_CANVAS_ADDR                     ((0x39a3  << 2) + 0xff620000)
#define HEVC_ANC20_CANVAS_ADDR                     ((0x39a4  << 2) + 0xff620000)
#define HEVC_ANC21_CANVAS_ADDR                     ((0x39a5  << 2) + 0xff620000)
#define HEVC_ANC22_CANVAS_ADDR                     ((0x39a6  << 2) + 0xff620000)
#define HEVC_ANC23_CANVAS_ADDR                     ((0x39a7  << 2) + 0xff620000)
#define HEVC_ANC24_CANVAS_ADDR                     ((0x39a8  << 2) + 0xff620000)
#define HEVC_ANC25_CANVAS_ADDR                     ((0x39a9  << 2) + 0xff620000)
#define HEVC_ANC26_CANVAS_ADDR                     ((0x39aa  << 2) + 0xff620000)
#define HEVC_ANC27_CANVAS_ADDR                     ((0x39ab  << 2) + 0xff620000)
#define HEVC_ANC28_CANVAS_ADDR                     ((0x39ac  << 2) + 0xff620000)
#define HEVC_ANC29_CANVAS_ADDR                     ((0x39ad  << 2) + 0xff620000)
#define HEVC_ANC30_CANVAS_ADDR                     ((0x39ae  << 2) + 0xff620000)
#define HEVC_ANC31_CANVAS_ADDR                     ((0x39af  << 2) + 0xff620000)
#define HEVC_DBKR_CANVAS_ADDR                      ((0x39b0  << 2) + 0xff620000)
#define HEVC_DBKW_CANVAS_ADDR                      ((0x39b1  << 2) + 0xff620000)
#define HEVC_REC_CANVAS_ADDR                       ((0x39b2  << 2) + 0xff620000)
//28:24, read/write, current canvas idx, used in h264 only now
//23:0, read only, current canvas address, 23:16, Cr canvas addr, 15:8, Cb canvas addr, 7:0, Y  canvas addr
#define HEVC_CURR_CANVAS_CTRL                      ((0x39b3  << 2) + 0xff620000)
#define HEVC_MDEC_PIC_DC_THRESH                    ((0x39b8  << 2) + 0xff620000)
#define HEVC_MDEC_PICR_BUF_STATUS                  ((0x39b9  << 2) + 0xff620000)
#define HEVC_MDEC_PICW_BUF_STATUS                  ((0x39ba  << 2) + 0xff620000)
#define HEVC_MCW_DBLK_WRRSP_CNT                    ((0x39bb  << 2) + 0xff620000)
#define HEVC_MC_MBBOT_WRRSP_CNT                    ((0x39bc  << 2) + 0xff620000)
#define HEVC_MDEC_PICW_BUF2_STATUS                 ((0x39bd  << 2) + 0xff620000)
#define HEVC_WRRSP_FIFO_PICW_DBK                   ((0x39be  << 2) + 0xff620000)
#define HEVC_WRRSP_FIFO_PICW_MC                    ((0x39bf  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_0                          ((0x39c0  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_1                          ((0x39c1  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_2                          ((0x39c2  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_3                          ((0x39c3  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_4                          ((0x39c4  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_5                          ((0x39c5  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_6                          ((0x39c6  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_7                          ((0x39c7  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_8                          ((0x39c8  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_9                          ((0x39c9  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_A                          ((0x39ca  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_B                          ((0x39cb  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_C                          ((0x39cc  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_D                          ((0x39cd  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_E                          ((0x39ce  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_F                          ((0x39cf  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_G                          ((0x39d0  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_H                          ((0x39d1  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_I                          ((0x39d2  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_J                          ((0x39d3  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_K                          ((0x39d4  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_L                          ((0x39d5  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_M                          ((0x39d6  << 2) + 0xff620000)
#define HEVC_AV_SCRATCH_N                          ((0x39d7  << 2) + 0xff620000)
// bit[29:24] A_brst_num_co_mb
// bit[21:16] A_id_co_mb
// bit[11:0] wrrsp_count_co_mb
#define HEVC_WRRSP_CO_MB                           ((0x39d8  << 2) + 0xff620000)
// bit[29:24] A_brst_num_dcac
// bit[21:16] A_id_dcac
// bit[11:0] wrrsp_count_dcac
#define HEVC_WRRSP_DCAC                            ((0x39d9  << 2) + 0xff620000)
// bit[11:0] wrrsp_count_vld
#define HEVC_WRRSP_VLD                             ((0x39da  << 2) + 0xff620000)
// doublew_cfg0[0];     //       Second Channel Enable, 1:Enable 0:Disable
// doublew_cfg0[3:1];   // [2:0] Endian Control for Luma
// doublew_cfg0[5:4];   // [1:0] Pixel sel by horizontal, 0x:1/2 10:left 11:right
// doublew_cfg0[7:6];   // [1:0] Pixel sel by vertical,   0x:1/2 10:up 11:down
// doublew_cfg0[8];     //       Size by horizontal, 0:original size 1: 1/2 shrunken size
// doublew_cfg0[9];     //       Size by vertical,   0:original size 1: 1/2 shrunken size
// doublew_cfg0[10];    //       1:Round 0:Truncation
// doublew_cfg0[11];    //       DMA Urgent
// doublew_cfg0[17:12]; // [5:0] DMA Burst Number
// doublew_cfg0[23:18]; // [5:0] DMA ID
// doublew_cfg0[26:24]; // [2:0] Endian Control for Chroma
// doublew_cfg0[27];    //       Source from, 1:MCW 0:DBLK
// doublew_cfg0[29:28]; // [1:0] 0x:select both top and bottom 10:select top 11:select bottom
// doublew_cfg0[30];    //       0:no merge 1:automatic merge
// doublew_cfg0[31];    //       0:Y addr no change 1:Y addr divided to half
#define HEVC_MDEC_DOUBLEW_CFG0                     ((0x39db  << 2) + 0xff620000)
// doublew_cfg1[7:0];   // [7:0] DMA Canvas Address for Luma
// doublew_cfg1[15:8];  // [7:0] DMA Canvas Address for Chroma
// doublew_cfg1[16];    //       Disable 1st Write -
// doublew_cfg1[17];    //       Reverse to original version -
// doublew_cfg1[18];    //       DMA Address Mode - 0:Canvas Mode 1:Non-Canvas Mode
#define HEVC_MDEC_DOUBLEW_CFG1                     ((0x39dc  << 2) + 0xff620000)
// doublew_cfg2[11:0];  //[11:0] vertical flip initial value
// doublew_cfg2[15];    //       vertical flip enable
// doublew_cfg2[24:16]; // [8:0] horizontal flip initial value
// doublew_cfg2[31];    //       horizontal flip enable
#define HEVC_MDEC_DOUBLEW_CFG2                     ((0x39dd  << 2) + 0xff620000)
// doublew_cfg3[31:0];  //[31:0] non-canvas start address for Luma -
#define HEVC_MDEC_DOUBLEW_CFG3                     ((0x39de  << 2) + 0xff620000)
// doublew_cfg4[31:0];  //[31:0] non-canvas start address for Chroma -
#define HEVC_MDEC_DOUBLEW_CFG4                     ((0x39df  << 2) + 0xff620000)
// doublew_cfg5[12:0];  //[12:0] non-canvas picture width for Luma -
// doublew_cfg5[28:16]; //[12:0] non-canvas picture width for Chroma -
#define HEVC_MDEC_DOUBLEW_CFG5                     ((0x39e0  << 2) + 0xff620000)
// doublew_cfg6: reserved
#define HEVC_MDEC_DOUBLEW_CFG6                     ((0x39e1  << 2) + 0xff620000)
// doublew_cfg7: reserved
#define HEVC_MDEC_DOUBLEW_CFG7                     ((0x39e2  << 2) + 0xff620000)
// doublew_status[11:0];//[11:0] wrrsp_count_doublew
// doublew_status[12];  //       doublew_status_busy
// doublew_status[13];  //       doublew_status_error
#define HEVC_MDEC_DOUBLEW_STATUS                   ((0x39e3  << 2) + 0xff620000)
#define HEVC_MDEC_EXTIF_CFG0                       ((0x39e4  << 2) + 0xff620000)
#define HEVC_MDEC_EXTIF_CFG1                       ((0x39e5  << 2) + 0xff620000)
#define HEVC_MDEC_EXTIF_STS0                       ((0x39e6  << 2) + 0xff620000)
//======================================
//  MC Control Register Bits
//
//======================================
// For bits, just copy the defines...don't translate to addresses
    //`define MC_RESET	    16'h0002
//======================================
//  MB Info Register Bits
//
//======================================
//======================================
//  MB Info Register Bits
//
//======================================
//========================================================================
// DBLK Register:  12'h950 - 12'h97f
//========================================================================
#define HEVC_DBLK_RST                              ((0x3950  << 2) + 0xff620000)
#define HEVC_DBLK_CTRL                             ((0x3951  << 2) + 0xff620000)
#define HEVC_DBLK_MB_WID_HEIGHT                    ((0x3952  << 2) + 0xff620000)
#define HEVC_DBLK_STATUS                           ((0x3953  << 2) + 0xff620000)
#define HEVC_DBLK_CMD_CTRL                         ((0x3954  << 2) + 0xff620000)
#define HEVC_DBLK_MB_XY                            ((0x3955  << 2) + 0xff620000)
#define HEVC_DBLK_QP                               ((0x3956  << 2) + 0xff620000)
#define HEVC_DBLK_Y_BHFILT                         ((0x3957  << 2) + 0xff620000)
#define HEVC_DBLK_Y_BHFILT_HIGH                    ((0x3958  << 2) + 0xff620000)
#define HEVC_DBLK_Y_BVFILT                         ((0x3959  << 2) + 0xff620000)
#define HEVC_DBLK_CB_BFILT                         ((0x395a  << 2) + 0xff620000)
#define HEVC_DBLK_CR_BFILT                         ((0x395b  << 2) + 0xff620000)
#define HEVC_DBLK_Y_HFILT                          ((0x395c  << 2) + 0xff620000)
#define HEVC_DBLK_Y_HFILT_HIGH                     ((0x395d  << 2) + 0xff620000)
#define HEVC_DBLK_Y_VFILT                          ((0x395e  << 2) + 0xff620000)
#define HEVC_DBLK_CB_FILT                          ((0x395f  << 2) + 0xff620000)
#define HEVC_DBLK_CR_FILT                          ((0x3960  << 2) + 0xff620000)
#define HEVC_DBLK_BETAX_QP_SEL                     ((0x3961  << 2) + 0xff620000)
#define HEVC_DBLK_CLIP_CTRL0                       ((0x3962  << 2) + 0xff620000)
#define HEVC_DBLK_CLIP_CTRL1                       ((0x3963  << 2) + 0xff620000)
#define HEVC_DBLK_CLIP_CTRL2                       ((0x3964  << 2) + 0xff620000)
#define HEVC_DBLK_CLIP_CTRL3                       ((0x3965  << 2) + 0xff620000)
#define HEVC_DBLK_CLIP_CTRL4                       ((0x3966  << 2) + 0xff620000)
#define HEVC_DBLK_CLIP_CTRL5                       ((0x3967  << 2) + 0xff620000)
#define HEVC_DBLK_CLIP_CTRL6                       ((0x3968  << 2) + 0xff620000)
#define HEVC_DBLK_CLIP_CTRL7                       ((0x3969  << 2) + 0xff620000)
#define HEVC_DBLK_CLIP_CTRL8                       ((0x396a  << 2) + 0xff620000)
#define HEVC_DBLK_STATUS1                          ((0x396b  << 2) + 0xff620000)
#define HEVC_DBLK_GCLK_FREE                        ((0x396c  << 2) + 0xff620000)
#define HEVC_DBLK_GCLK_OFF                         ((0x396d  << 2) + 0xff620000)
#define HEVC_DBLK_AVSFLAGS                         ((0x396e  << 2) + 0xff620000)
// bit 15:0
#define HEVC_DBLK_CBPY                             ((0x3970  << 2) + 0xff620000)
// bit 11:8 -- deblk_cbpy_bottom
// bit 7:4 -- deblk_cbpy_left
// bit 3:0 -- deblk_cbpy_top
#define HEVC_DBLK_CBPY_ADJ                         ((0x3971  << 2) + 0xff620000)
// bit 7:0 -- deblk_cbpc
#define HEVC_DBLK_CBPC                             ((0x3972  << 2) + 0xff620000)
// bit 15 -- bottom_mb
// bit 14 -- left_mb
// bit 13 -- top_mb
// bit 12 -- reserved
// bit 11:8 -- deblk_cbpc_bottom
// bit 7:4 -- deblk_cbpc_left
// bit 3:0 -- deblk_cbpc_top
#define HEVC_DBLK_CBPC_ADJ                         ((0x3973  << 2) + 0xff620000)
// bit 15:8 -- deblk_hmvd   -- {left_1, left_0, below_1, below_0, block3-0}
// bit 7:0 -- deblk_vmvd    -- {top_1, top_0, below_1, below_0, block3-0}
#define HEVC_DBLK_VHMVD                            ((0x3974  << 2) + 0xff620000)
// bit 13:12 -- right_vmvd
// bit 11 -- right_above_vmvd
// bit 10 -- left_below_hmvd
// bit 9 -- disable_dblk_luma
// bit 8 -- disable_dblk_chroma
// bit 7 -- bBelowRefDiff
// bit 6 -- bLeftRefDiff
// bit 5 -- bAboveRefDiff
// bit 4 -- reserved
// bit 3 -- s_below
// bit 2 -- s_left
// bit 1 -- s_above
// bit 0 -- s
#define HEVC_DBLK_STRONG                           ((0x3975  << 2) + 0xff620000)
// bit 14:10 -- PQUANT
// bit 9:5 -- left_PQUANT
// bit 4:0 -- top_PQUANT
#define HEVC_DBLK_RV8_QUANT                        ((0x3976  << 2) + 0xff620000)
#define HEVC_DBLK_CBUS_HCMD2                       ((0x3977  << 2) + 0xff620000)
#define HEVC_DBLK_CBUS_HCMD1                       ((0x3978  << 2) + 0xff620000)
#define HEVC_DBLK_CBUS_HCMD0                       ((0x3979  << 2) + 0xff620000)
#define HEVC_DBLK_VLD_HCMD2                        ((0x397a  << 2) + 0xff620000)
#define HEVC_DBLK_VLD_HCMD1                        ((0x397b  << 2) + 0xff620000)
#define HEVC_DBLK_VLD_HCMD0                        ((0x397c  << 2) + 0xff620000)
#define HEVC_DBLK_OST_YBASE                        ((0x397d  << 2) + 0xff620000)
#define HEVC_DBLK_OST_CBCRDIFF                     ((0x397e  << 2) + 0xff620000)
//13:8 dblk thread ID and token
//5:0  dblk pre arbiter burst num
#define HEVC_DBLK_CTRL1                            ((0x397f  << 2) + 0xff620000)
// MCRCC_CTL1
// 31:3  <reserved[23:0]>
// 2     <cfg_field_pic>
// 1     <sw_rst>
// 0     <bypass_en>
#define HEVC_MCRCC_CTL1                            ((0x3980  << 2) + 0xff620000)
// MCRCC_CTL2
// 31:24    <cfg_cache_anc01_c[7:0]>
// 23:16    <cfg_cache_anc01_y[7:0]>
// 15:8     <cfg_cache_anc00_c[7:0]>
// 7:0      <cfg_cache_anc00_y[7:0]>
#define HEVC_MCRCC_CTL2                            ((0x3981  << 2) + 0xff620000)
// MCRCC_CTL3
// 31:24    <cfg_cache_anc11_c[7:0]>
// 23:16    <cfg_cache_anc11_y[7:0]>
// 15:8     <cfg_cache_anc10_c[7:0]>
// 7:0      <cfg_cache_anc10_y[7:0]>
#define HEVC_MCRCC_CTL3                            ((0x3982  << 2) + 0xff620000)
// bit[31:10] reserved
// bit[9:0] sw_clock_gating control
// [9] vdec clk_en for assist and cbus.
// [8] vdec clk_en for ddr
// [7] vdec clk_en for vcpu
// [6] vdec clk_en for assist
// [5] vdec clk_en for dblk
// [4] vdec clk_en for iqidct
// [3] vdec clk_en for mc
// [2] vdec clk_en for pic_dc
// [1] vdec clk_en for psc
// [0] vdec clk_en for vld
#define HEVC_GCLK_EN                               ((0x3983  << 2) + 0xff620000)
// [0]  Reserved
// [1]  Reserved
// [2]  Reset assist, mdec's CBUS
// [3]  Reset mdec's VLD
// [4]  Reset mdec's VLD
// [5]  Reset mdec's VLD
// [6]  Reset mdec's IQIDCT
// [7]  Reset mdec's MC
// [8]  Reset mdec's DBLK
// [9]  Reset mdec's PIC_DC
// [10] Reset mdec's Pscale
// [11] Reset vcpu's MCPU
// [12] Reset vcpu's CCPU
// [13] Reset mmc_pre_arb
#define HEVC_MDEC_SW_RESET                         ((0x3984  << 2) + 0xff620000)
//DBLK last address 12'h97f
//
// Closing file:  mdec_regs.h
//
//
// Reading file:  vld_regs.h
//
//========================================================================
//  VLD module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_VLD_CBUS_BASE = 0x0c
// -----------------------------------------------
#define HCODEC_VLD_STATUS_CTRL                     ((0x1c00  << 2) + 0xff620000)
//
// bit 10 -- use_old_shift_en
// bit 9 -- output_mv_not_pmv
// bit 8:5 -- force_zigzag
// bit 4 -- force_zigzag_en
// bit 3 -- disable_viff_anempty_int
// bit 2 -- disable_m2_ac_coeff_one_cycle
// bit 1 -- forced_reset  force reset pmv
// bit 0 -- mpeg_type  0:mpeg1 1: mpeg2
#define HCODEC_MPEG1_2_REG                         ((0x1c01  << 2) + 0xff620000)
#define HCODEC_F_CODE_REG                          ((0x1c02  << 2) + 0xff620000)
#define HCODEC_PIC_HEAD_INFO                       ((0x1c03  << 2) + 0xff620000)
#define HCODEC_SLICE_VER_POS_PIC_TYPE              ((0x1c04  << 2) + 0xff620000)
#define HCODEC_QP_VALUE_REG                        ((0x1c05  << 2) + 0xff620000)
#define HCODEC_MBA_INC                             ((0x1c06  << 2) + 0xff620000)
#define HCODEC_MB_MOTION_MODE                      ((0x1c07  << 2) + 0xff620000)
//`define PACKET_BYTE_COUNT   8'h08
// bit 15 -- force_search_startcode_en
// bit 14 -- int_cpu_when_error (before do anything)
// bit 13 -- vld_error_reset
// bit 12 -- return_on_slice_header
// bit 6 -- jpeg_ff00_en
// bit 5:0 -- vld_power_ctl
#define HCODEC_POWER_CTL_VLD                       ((0x1c08  << 2) + 0xff620000)
#define HCODEC_MB_WIDTH                            ((0x1c09  << 2) + 0xff620000)
#define HCODEC_SLICE_QP                            ((0x1c0a  << 2) + 0xff620000)
// `define MB_X_MB_Y           8'h0b   /* current MBX and MBY                  */
#define HCODEC_PRE_START_CODE                      ((0x1c0b  << 2) + 0xff620000)
#define HCODEC_SLICE_START_BYTE_01                 ((0x1c0c  << 2) + 0xff620000)
#define HCODEC_SLICE_START_BYTE_23                 ((0x1c0d  << 2) + 0xff620000)
#define HCODEC_RESYNC_MARKER_LENGTH                ((0x1c0e  << 2) + 0xff620000)
// bit[6:5] - frame/field info, 01 - top, 10 - bottom, 11 - frame
// bit[4:0] - buffer ID
// L0_BUFF_ID_0, L0_BUFF_ID_1, L1_BUFF_ID_0, L1_BUFF_ID_1
#define HCODEC_DECODER_BUFFER_INFO                 ((0x1c0f  << 2) + 0xff620000)
#define HCODEC_FST_FOR_MV_X                        ((0x1c10  << 2) + 0xff620000)
#define HCODEC_FST_FOR_MV_Y                        ((0x1c11  << 2) + 0xff620000)
#define HCODEC_SCD_FOR_MV_X                        ((0x1c12  << 2) + 0xff620000)
#define HCODEC_SCD_FOR_MV_Y                        ((0x1c13  << 2) + 0xff620000)
#define HCODEC_FST_BAK_MV_X                        ((0x1c14  << 2) + 0xff620000)
#define HCODEC_FST_BAK_MV_Y                        ((0x1c15  << 2) + 0xff620000)
#define HCODEC_SCD_BAK_MV_X                        ((0x1c16  << 2) + 0xff620000)
#define HCODEC_SCD_BAK_MV_Y                        ((0x1c17  << 2) + 0xff620000)
// Bit 7:4 -- read_buffer_interlace  0-progressive, 1-interlace, used in VC1
// bit 3 -- disable_new_stcode_search_fix // From GXM
// bit 2 -- weighting_prediction
// bit 1 -- mb_weighting_flag
// bit 0 -- slice_weighting_flag
#define HCODEC_VLD_DECODE_CONTROL                  ((0x1c18  << 2) + 0xff620000)
#define HCODEC_VIFF_BIT_CNT                        ((0x1c1a  << 2) + 0xff620000)
#define HCODEC_BYTE_ALIGN_PEAK_HI                  ((0x1c1b  << 2) + 0xff620000)
#define HCODEC_BYTE_ALIGN_PEAK_LO                  ((0x1c1c  << 2) + 0xff620000)
#define HCODEC_NEXT_ALIGN_PEAK                     ((0x1c1d  << 2) + 0xff620000)
// bit 31    : byte_aligned_zero_23_from_org // From GXM
// bit 30    : force_shift_out_drop_flag_zero // From GXM
// bit 29    : en_st_protect_from_org // From GXM
// bit 28    : enable_halt_decode_start_voff
// bit 27    : disable_C_pred_check
// bit 26    : disable_I4_pred_check
// bit 25    : disable_I16_pred_check
// bit 24    : check_avs_1st_drop
// bit 23    : enable_cabac_protect // From GXM
// bit 22    : enable_avs_drop_more
// bit 21    : reset_avs_drop_ptr
// bit 20    : reset_cabac_use_next_at_end_req
// bit 19    : vc1_inv_intra_co_mb_ref_rd
// bit 18    : vc1_inv_co_mb_ref_rd
// bit 17    : vc1_inv_intra_co_mb_ref_wr
// bit 16    : vc1_inv_co_mb_ref_wr
// bit 15    : disable_mv_cal_begin_only
// bit 14    : avs_drop_enable
// bit 13:12 : avs_drop_ptr
// bit 11:8  : avs_demu_ctl_reg
// bit 7 : avs_enable
// bit 6 : disable_dblk_hcmd
// bit 5 : disable_mc_hcmd
// bit 4 : first_mode3_set enable
// bit 3 : first_mode3
// bit 2:1 : vc1_profile  0-SP, 1-MP, 2-reserved, 3-AP
// bit 0   : vc1_enable
#define HCODEC_VC1_CONTROL_REG                     ((0x1c1e  << 2) + 0xff620000)
#define HCODEC_PMV1_X                              ((0x1c20  << 2) + 0xff620000)
#define HCODEC_PMV1_Y                              ((0x1c21  << 2) + 0xff620000)
#define HCODEC_PMV2_X                              ((0x1c22  << 2) + 0xff620000)
#define HCODEC_PMV2_Y                              ((0x1c23  << 2) + 0xff620000)
#define HCODEC_PMV3_X                              ((0x1c24  << 2) + 0xff620000)
#define HCODEC_PMV3_Y                              ((0x1c25  << 2) + 0xff620000)
#define HCODEC_PMV4_X                              ((0x1c26  << 2) + 0xff620000)
#define HCODEC_PMV4_Y                              ((0x1c27  << 2) + 0xff620000)
// Can't use the same address for different defines
// Therefore, create a single define that covers both
// Only appears to be used in micro-code since the VLD hardware is
// hard coded.
// `define M4_TABLE_SELECT     8'h28  // Does this exist in HW ? Added from register_mp2.h
// `define M4_TABLE_OUTPUT     8'h28  // Does this exist in HW ? Added from register_mp2.h
#define HCODEC_M4_TABLE_SELECT                     ((0x1c28  << 2) + 0xff620000)
#define HCODEC_M4_CONTROL_REG                      ((0x1c29  << 2) + 0xff620000)
#define HCODEC_BLOCK_NUM                           ((0x1c2a  << 2) + 0xff620000)
#define HCODEC_PATTERN_CODE                        ((0x1c2b  << 2) + 0xff620000)
#define HCODEC_MB_INFO                             ((0x1c2c  << 2) + 0xff620000)
#define HCODEC_VLD_DC_PRED                         ((0x1c2d  << 2) + 0xff620000)
#define HCODEC_VLD_ERROR_MASK                      ((0x1c2e  << 2) + 0xff620000)
#define HCODEC_VLD_DC_PRED_C                       ((0x1c2f  << 2) + 0xff620000)
#define HCODEC_LAST_SLICE_MV_ADDR                  ((0x1c30  << 2) + 0xff620000)
#define HCODEC_LAST_MVX                            ((0x1c31  << 2) + 0xff620000)
#define HCODEC_LAST_MVY                            ((0x1c32  << 2) + 0xff620000)
#define HCODEC_VLD_C38                             ((0x1c38  << 2) + 0xff620000)
#define HCODEC_VLD_C39                             ((0x1c39  << 2) + 0xff620000)
#define HCODEC_VLD_STATUS                          ((0x1c3a  << 2) + 0xff620000)
#define HCODEC_VLD_SHIFT_STATUS                    ((0x1c3b  << 2) + 0xff620000)
// `define VLD_SHIFT_INFO      8'h3b  // Does this exist in HW ? used in $ucode/mpeg4
#define HCODEC_VOFF_STATUS                         ((0x1c3c  << 2) + 0xff620000)
#define HCODEC_VLD_C3D                             ((0x1c3d  << 2) + 0xff620000)
#define HCODEC_VLD_DBG_INDEX                       ((0x1c3e  << 2) + 0xff620000)
// vld_buff_info -- (index == 0)
// Bit11]    halt_decode_start_voff
// Bit10]    C_pred_error
// Bit[9]    I4_pred_error
// Bit[8]    I16_pred_error
// Bit[7:6]  mv_UR_ready_cnt;
// Bit[5]  vld_wr_idx
// Bit[4]  iq_rd_idx
// Bit[3]  vld_vi_block_rdy_1
// Bit[2]  vld_vi_block_rdy_2
// Bit[1]  voff_empty_1
// Bit[0]  voff_empty_2
// cabac_buff_info_0 -- (index == 1)
// Bit[31] shift_data_ready
// Bit[30:29] Reserved
// Bit[28:24] cabac_buffer_ptr
// Bit[23:0] cabac_buffer
// cabac_buff_info_1 -- (index == 2)
// Bit[31:29] Reserved
// Bit[28:20] Drange
// Bit[19:16] bin_count_4
// Bit[15:13] Reserved
// Bit[12:6] context_mem_do
// Bit[5:3] coeff_state
// Bit[2:0] mvd_state
// h264_mv_present -- (index == 3)
// Bit[31:16] mv_present_l0
// Bit[15:0] mv_present_l1
// h264_mv_cal_info_0 -- (index == 4)
// [31:28] mv_cal_state
// [27:24] direct_spatial_cnt
// Bit[23:21] Reserved
// Bit[20] mv_UR_ready_for_mv_cal
// Bit[19] co_mb_mem_ready_for_mv_cal
// Bit[18] mc_dblk_cmd_if_busy
// Bit[17] h264_co_mb_wr_busy
// Bit[16] H264_cbp_blk_ready
// Bit[15] mc_hcmd_rrdy
// Bit[14] mc_hcmd_srdy
// Bit[13] mc_cmd_if_ready
// Bit[12] mc_hcmd_mv_available
// Bit[11:8] mc_cmd_if_state
// Bit[7] dblk_hcmd_rrdy
// Bit[6] dblk_hcmd_srdy
// Bit[5] dblk_cmd_if_ready
// Bit[4] dblk_hcmd_mv_available
// Bit[3:0] dblk_cmd_if_state
// h264_mv_cal_info_1 -- (index == 5)
//  Bit[31:29] Reserved
//  Bit[28:24] total_mvd_num_l0
//  Bit[23:21] Reserved
//  Bit[20:16] mv_cal_ptr_l0
//  Bit[15:13] Reserved
//  Bit[12:8] mc_hcmd_ptr_l0
//  Bit[7:5] Reserved
//  Bit[4:0] dblk_hcmd_ptr_l0
// h264_mv_cal_info_2 -- (index == 6)
//  Bit[31:29] Reserved
//  Bit[28:24] total_mvd_num_l1
//  Bit[23:21] Reserved
//  Bit[20:16] mv_cal_ptr_l1
//  Bit[15:13] Reserved
//  Bit[12:8] mc_hcmd_ptr_l1
//  Bit[7:5] Reserved
//  Bit[4:0] dblk_hcmd_ptr_l1
// h264_co_mb_info -- (index == 7)
// Bit[31:26] Reserved
// Bit[25] mv_scale_cal_busy
// Bit[24:20] co_mv_count
// Bit[19:16] co_mv_process_state
// Bit[15] h264_co_mb_rd_busy
// Bit[15] h264_co_mb_rd_ready
// Bit[13:12] co_mv_transfer_block_cnt
// Bit[11:8] co_mv_transfer_ptr
// Bit[7] co_mv_POC_l1_busy
// Bit[6] h264_weight_scale_cal_en
// Bit[5] weight_cal_busy
// Bit[4] weight_cal_not_finished
// Bit[3:0] weight_process_state
#define HCODEC_VLD_DBG_DATA                        ((0x1c3f  << 2) + 0xff620000)
// --------------------------------------------
// VIFIFO DDR Interface
// --------------------------------------------
// The VIFIFO start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define HCODEC_VLD_MEM_VIFIFO_START_PTR            ((0x1c40  << 2) + 0xff620000)
// The current pointer points so some location between the START and END
// pointers.  The current pointer is a BYTE pointer.  That is, you can
// point to any BYTE address within the START/END range
#define HCODEC_VLD_MEM_VIFIFO_CURR_PTR             ((0x1c41  << 2) + 0xff620000)
#define HCODEC_VLD_MEM_VIFIFO_END_PTR              ((0x1c42  << 2) + 0xff620000)
#define HCODEC_VLD_MEM_VIFIFO_BYTES_AVAIL          ((0x1c43  << 2) + 0xff620000)
// VIFIFO FIFO Control
// bit  [31:24] viff_empty_int_enable_cpu[7:0]
// bit  [23:16] viff_empty_int_enable_amrisc[7:0]
//   -bit 23 Video BUFFER < 0x400 Bytes
//   -bit 22 Video BUFFER < 0x200 Bytes
//   -bit 21 Video BUFFER < 0x100 Bytes
//   -bit 20 Video BUFFER < 0x80 Bytes
//   -bit 19 Video BUFFER < 0x40 Bytes
//   -bit 18 Video BUFFER < 0x20 Bytes
//   -bit 17 vififo  < 16 double words
//   -bit 16 vififo  < 8 double words
// bit  [15:13] unused
// bit  [12]    A_urgent
// bit  [11]    transfer_length 0 - 32x64 Bits per request, 1 - 16x64 Bits per request
// bit  [10]    use_level       Set this bit to 1 to enable filling of the FIFO controlled by the buffer
//                              level control.  If this bit is 0, then use bit[1] to control the enabling of filling
// bit  [9]     Data Ready.     This bit is set when data can be popped
// bit  [8]     fill busy       This bit will be high when we're fetching data from the DDR memory
//                              To reset this module, set cntl_enable = 0, and then wait for busy = 0.
//                              After that you can pulse cntl_init to start over
// bit  [7]     init_with_cntl_init
// bit  [6]     reserved
// bits [5:3]   endian:         see $lib/rtl/ddr_endian.v
// bit  [2]     cntl_empty_en   Set to 1 to enable reading the DDR memory FIFO
//                              Set cntl_empty_en = cntl_fill_en = 0 when pulsing cntl_init
// bit  [1]     cntl_fill_en    Set to 1 to enable reading data from DDR memory
// bit  [0]     cntl_init:      After setting the read pointers, sizes, channel masks
//                              and read masks, set this bit to 1 and then to 0
//                              NOTE:  You don't need to pulse cntl_init if only the start address is
//                              being changed
#define HCODEC_VLD_MEM_VIFIFO_CONTROL              ((0x1c44  << 2) + 0xff620000)
// --------------------------------------------
// VIFIFO Buffer Level Manager
// --------------------------------------------
#define HCODEC_VLD_MEM_VIFIFO_WP                   ((0x1c45  << 2) + 0xff620000)
#define HCODEC_VLD_MEM_VIFIFO_RP                   ((0x1c46  << 2) + 0xff620000)
#define HCODEC_VLD_MEM_VIFIFO_LEVEL                ((0x1c47  << 2) + 0xff620000)
//
// bit  [8]     use_parser_video2_wp
// bit  [7]     vbuf2_out_manual
// bit  [6]     vbuf_out_manual
// bit  [5]     empty (ReadOnly)
// bit  [4]     full (ReadOnly)
// bit  [3:2]   reserved
// bit  [1]     manual mode     Set to 1 for manual write pointer mode
// bit  [0]     Init            Set high then low after everything has been initialized
#define HCODEC_VLD_MEM_VIFIFO_BUF_CNTL             ((0x1c48  << 2) + 0xff620000)
// bit 31:16 -- drop_bytes
// bit 15:14 -- drop_status (Read-Only)
// bit 13:12 -- sync_match_position (Read-Only)
// bit 11:6 -- reserved
// bit 5:4 -- TIME_STAMP_NUMBER, 0-32bits, 1-64bits, 2-96bits, 3-128bits
// bit 3 -- stamp_soft_reset
// bit 2 -- TIME_STAMP_length_enable
// bit 1 -- TIME_STAMP_sync64_enable
// bit 0 -- TIME_STAMP_enable
#define HCODEC_VLD_TIME_STAMP_CNTL                 ((0x1c49  << 2) + 0xff620000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_0
#define HCODEC_VLD_TIME_STAMP_SYNC_0               ((0x1c4a  << 2) + 0xff620000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_1
#define HCODEC_VLD_TIME_STAMP_SYNC_1               ((0x1c4b  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_0
#define HCODEC_VLD_TIME_STAMP_0                    ((0x1c4c  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_1
#define HCODEC_VLD_TIME_STAMP_1                    ((0x1c4d  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_2
#define HCODEC_VLD_TIME_STAMP_2                    ((0x1c4e  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_3
#define HCODEC_VLD_TIME_STAMP_3                    ((0x1c4f  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_LENGTH
#define HCODEC_VLD_TIME_STAMP_LENGTH               ((0x1c50  << 2) + 0xff620000)
// bit 15:0 vififo_rd_count
#define HCODEC_VLD_MEM_VIFIFO_WRAP_COUNT           ((0x1c51  << 2) + 0xff620000)
// bit 29:24 A_brst_num
// bit 21:16 A_id
// bit 15:0 level_hold
#define HCODEC_VLD_MEM_VIFIFO_MEM_CTL              ((0x1c52  << 2) + 0xff620000)
#define HCODEC_VLD_MEM_VBUF_RD_PTR                 ((0x1c53  << 2) + 0xff620000)
#define HCODEC_VLD_MEM_VBUF2_RD_PTR                ((0x1c54  << 2) + 0xff620000)
#define HCODEC_VLD_MEM_SWAP_ADDR                   ((0x1c55  << 2) + 0xff620000)
// bit[23:16] - swap_d_count (Read Only)
// bit[15:8]  - swap_a_count (Read Only)
// bit [7] - swap busy (Read Only)
// bit [6:2] - reserved
// bit [1] - 1 - STORE to Memory, 0 - LOAD from Memory
// bit [0] - swap active
#define HCODEC_VLD_MEM_SWAP_CTL                    ((0x1c56  << 2) + 0xff620000)
//
// Closing file:  vld_regs.h
//
//
// Reading file:  vld_regs.h
//
//========================================================================
//  VLD module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_VLD_CBUS_BASE = 0x0c
// -----------------------------------------------
#define VDEC2_VLD_STATUS_CTRL                      ((0x2c00  << 2) + 0xff620000)
//
// bit 10 -- use_old_shift_en
// bit 9 -- output_mv_not_pmv
// bit 8:5 -- force_zigzag
// bit 4 -- force_zigzag_en
// bit 3 -- disable_viff_anempty_int
// bit 2 -- disable_m2_ac_coeff_one_cycle
// bit 1 -- forced_reset  force reset pmv
// bit 0 -- mpeg_type  0:mpeg1 1: mpeg2
#define VDEC2_MPEG1_2_REG                          ((0x2c01  << 2) + 0xff620000)
#define VDEC2_F_CODE_REG                           ((0x2c02  << 2) + 0xff620000)
#define VDEC2_PIC_HEAD_INFO                        ((0x2c03  << 2) + 0xff620000)
#define VDEC2_SLICE_VER_POS_PIC_TYPE               ((0x2c04  << 2) + 0xff620000)
#define VDEC2_QP_VALUE_REG                         ((0x2c05  << 2) + 0xff620000)
#define VDEC2_MBA_INC                              ((0x2c06  << 2) + 0xff620000)
#define VDEC2_MB_MOTION_MODE                       ((0x2c07  << 2) + 0xff620000)
//`define PACKET_BYTE_COUNT   8'h08
// bit 15 -- force_search_startcode_en
// bit 14 -- int_cpu_when_error (before do anything)
// bit 13 -- vld_error_reset
// bit 12 -- return_on_slice_header
// bit 6 -- jpeg_ff00_en
// bit 5:0 -- vld_power_ctl
#define VDEC2_POWER_CTL_VLD                        ((0x2c08  << 2) + 0xff620000)
#define VDEC2_MB_WIDTH                             ((0x2c09  << 2) + 0xff620000)
#define VDEC2_SLICE_QP                             ((0x2c0a  << 2) + 0xff620000)
// `define MB_X_MB_Y           8'h0b   /* current MBX and MBY                  */
#define VDEC2_PRE_START_CODE                       ((0x2c0b  << 2) + 0xff620000)
#define VDEC2_SLICE_START_BYTE_01                  ((0x2c0c  << 2) + 0xff620000)
#define VDEC2_SLICE_START_BYTE_23                  ((0x2c0d  << 2) + 0xff620000)
#define VDEC2_RESYNC_MARKER_LENGTH                 ((0x2c0e  << 2) + 0xff620000)
// bit[6:5] - frame/field info, 01 - top, 10 - bottom, 11 - frame
// bit[4:0] - buffer ID
// L0_BUFF_ID_0, L0_BUFF_ID_1, L1_BUFF_ID_0, L1_BUFF_ID_1
#define VDEC2_DECODER_BUFFER_INFO                  ((0x2c0f  << 2) + 0xff620000)
#define VDEC2_FST_FOR_MV_X                         ((0x2c10  << 2) + 0xff620000)
#define VDEC2_FST_FOR_MV_Y                         ((0x2c11  << 2) + 0xff620000)
#define VDEC2_SCD_FOR_MV_X                         ((0x2c12  << 2) + 0xff620000)
#define VDEC2_SCD_FOR_MV_Y                         ((0x2c13  << 2) + 0xff620000)
#define VDEC2_FST_BAK_MV_X                         ((0x2c14  << 2) + 0xff620000)
#define VDEC2_FST_BAK_MV_Y                         ((0x2c15  << 2) + 0xff620000)
#define VDEC2_SCD_BAK_MV_X                         ((0x2c16  << 2) + 0xff620000)
#define VDEC2_SCD_BAK_MV_Y                         ((0x2c17  << 2) + 0xff620000)
// Bit 7:4 -- read_buffer_interlace  0-progressive, 1-interlace, used in VC1
// bit 3 -- disable_new_stcode_search_fix // From GXM
// bit 2 -- weighting_prediction
// bit 1 -- mb_weighting_flag
// bit 0 -- slice_weighting_flag
#define VDEC2_VLD_DECODE_CONTROL                   ((0x2c18  << 2) + 0xff620000)
#define VDEC2_VIFF_BIT_CNT                         ((0x2c1a  << 2) + 0xff620000)
#define VDEC2_BYTE_ALIGN_PEAK_HI                   ((0x2c1b  << 2) + 0xff620000)
#define VDEC2_BYTE_ALIGN_PEAK_LO                   ((0x2c1c  << 2) + 0xff620000)
#define VDEC2_NEXT_ALIGN_PEAK                      ((0x2c1d  << 2) + 0xff620000)
// bit 31    : byte_aligned_zero_23_from_org // From GXM
// bit 30    : force_shift_out_drop_flag_zero // From GXM
// bit 29    : en_st_protect_from_org // From GXM
// bit 28    : enable_halt_decode_start_voff
// bit 27    : disable_C_pred_check
// bit 26    : disable_I4_pred_check
// bit 25    : disable_I16_pred_check
// bit 24    : check_avs_1st_drop
// bit 23    : enable_cabac_protect // From GXM
// bit 22    : enable_avs_drop_more
// bit 21    : reset_avs_drop_ptr
// bit 20    : reset_cabac_use_next_at_end_req
// bit 19    : vc1_inv_intra_co_mb_ref_rd
// bit 18    : vc1_inv_co_mb_ref_rd
// bit 17    : vc1_inv_intra_co_mb_ref_wr
// bit 16    : vc1_inv_co_mb_ref_wr
// bit 15    : disable_mv_cal_begin_only
// bit 14    : avs_drop_enable
// bit 13:12 : avs_drop_ptr
// bit 11:8  : avs_demu_ctl_reg
// bit 7 : avs_enable
// bit 6 : disable_dblk_hcmd
// bit 5 : disable_mc_hcmd
// bit 4 : first_mode3_set enable
// bit 3 : first_mode3
// bit 2:1 : vc1_profile  0-SP, 1-MP, 2-reserved, 3-AP
// bit 0   : vc1_enable
#define VDEC2_VC1_CONTROL_REG                      ((0x2c1e  << 2) + 0xff620000)
#define VDEC2_PMV1_X                               ((0x2c20  << 2) + 0xff620000)
#define VDEC2_PMV1_Y                               ((0x2c21  << 2) + 0xff620000)
#define VDEC2_PMV2_X                               ((0x2c22  << 2) + 0xff620000)
#define VDEC2_PMV2_Y                               ((0x2c23  << 2) + 0xff620000)
#define VDEC2_PMV3_X                               ((0x2c24  << 2) + 0xff620000)
#define VDEC2_PMV3_Y                               ((0x2c25  << 2) + 0xff620000)
#define VDEC2_PMV4_X                               ((0x2c26  << 2) + 0xff620000)
#define VDEC2_PMV4_Y                               ((0x2c27  << 2) + 0xff620000)
// Can't use the same address for different defines
// Therefore, create a single define that covers both
// Only appears to be used in micro-code since the VLD hardware is
// hard coded.
// `define M4_TABLE_SELECT     8'h28  // Does this exist in HW ? Added from register_mp2.h
// `define M4_TABLE_OUTPUT     8'h28  // Does this exist in HW ? Added from register_mp2.h
#define VDEC2_M4_TABLE_SELECT                      ((0x2c28  << 2) + 0xff620000)
#define VDEC2_M4_CONTROL_REG                       ((0x2c29  << 2) + 0xff620000)
#define VDEC2_BLOCK_NUM                            ((0x2c2a  << 2) + 0xff620000)
#define VDEC2_PATTERN_CODE                         ((0x2c2b  << 2) + 0xff620000)
#define VDEC2_MB_INFO                              ((0x2c2c  << 2) + 0xff620000)
#define VDEC2_VLD_DC_PRED                          ((0x2c2d  << 2) + 0xff620000)
#define VDEC2_VLD_ERROR_MASK                       ((0x2c2e  << 2) + 0xff620000)
#define VDEC2_VLD_DC_PRED_C                        ((0x2c2f  << 2) + 0xff620000)
#define VDEC2_LAST_SLICE_MV_ADDR                   ((0x2c30  << 2) + 0xff620000)
#define VDEC2_LAST_MVX                             ((0x2c31  << 2) + 0xff620000)
#define VDEC2_LAST_MVY                             ((0x2c32  << 2) + 0xff620000)
#define VDEC2_VLD_C38                              ((0x2c38  << 2) + 0xff620000)
#define VDEC2_VLD_C39                              ((0x2c39  << 2) + 0xff620000)
#define VDEC2_VLD_STATUS                           ((0x2c3a  << 2) + 0xff620000)
#define VDEC2_VLD_SHIFT_STATUS                     ((0x2c3b  << 2) + 0xff620000)
// `define VLD_SHIFT_INFO      8'h3b  // Does this exist in HW ? used in $ucode/mpeg4
#define VDEC2_VOFF_STATUS                          ((0x2c3c  << 2) + 0xff620000)
#define VDEC2_VLD_C3D                              ((0x2c3d  << 2) + 0xff620000)
#define VDEC2_VLD_DBG_INDEX                        ((0x2c3e  << 2) + 0xff620000)
// vld_buff_info -- (index == 0)
// Bit11]    halt_decode_start_voff
// Bit10]    C_pred_error
// Bit[9]    I4_pred_error
// Bit[8]    I16_pred_error
// Bit[7:6]  mv_UR_ready_cnt;
// Bit[5]  vld_wr_idx
// Bit[4]  iq_rd_idx
// Bit[3]  vld_vi_block_rdy_1
// Bit[2]  vld_vi_block_rdy_2
// Bit[1]  voff_empty_1
// Bit[0]  voff_empty_2
// cabac_buff_info_0 -- (index == 1)
// Bit[31] shift_data_ready
// Bit[30:29] Reserved
// Bit[28:24] cabac_buffer_ptr
// Bit[23:0] cabac_buffer
// cabac_buff_info_1 -- (index == 2)
// Bit[31:29] Reserved
// Bit[28:20] Drange
// Bit[19:16] bin_count_4
// Bit[15:13] Reserved
// Bit[12:6] context_mem_do
// Bit[5:3] coeff_state
// Bit[2:0] mvd_state
// h264_mv_present -- (index == 3)
// Bit[31:16] mv_present_l0
// Bit[15:0] mv_present_l1
// h264_mv_cal_info_0 -- (index == 4)
// [31:28] mv_cal_state
// [27:24] direct_spatial_cnt
// Bit[23:21] Reserved
// Bit[20] mv_UR_ready_for_mv_cal
// Bit[19] co_mb_mem_ready_for_mv_cal
// Bit[18] mc_dblk_cmd_if_busy
// Bit[17] h264_co_mb_wr_busy
// Bit[16] H264_cbp_blk_ready
// Bit[15] mc_hcmd_rrdy
// Bit[14] mc_hcmd_srdy
// Bit[13] mc_cmd_if_ready
// Bit[12] mc_hcmd_mv_available
// Bit[11:8] mc_cmd_if_state
// Bit[7] dblk_hcmd_rrdy
// Bit[6] dblk_hcmd_srdy
// Bit[5] dblk_cmd_if_ready
// Bit[4] dblk_hcmd_mv_available
// Bit[3:0] dblk_cmd_if_state
// h264_mv_cal_info_1 -- (index == 5)
//  Bit[31:29] Reserved
//  Bit[28:24] total_mvd_num_l0
//  Bit[23:21] Reserved
//  Bit[20:16] mv_cal_ptr_l0
//  Bit[15:13] Reserved
//  Bit[12:8] mc_hcmd_ptr_l0
//  Bit[7:5] Reserved
//  Bit[4:0] dblk_hcmd_ptr_l0
// h264_mv_cal_info_2 -- (index == 6)
//  Bit[31:29] Reserved
//  Bit[28:24] total_mvd_num_l1
//  Bit[23:21] Reserved
//  Bit[20:16] mv_cal_ptr_l1
//  Bit[15:13] Reserved
//  Bit[12:8] mc_hcmd_ptr_l1
//  Bit[7:5] Reserved
//  Bit[4:0] dblk_hcmd_ptr_l1
// h264_co_mb_info -- (index == 7)
// Bit[31:26] Reserved
// Bit[25] mv_scale_cal_busy
// Bit[24:20] co_mv_count
// Bit[19:16] co_mv_process_state
// Bit[15] h264_co_mb_rd_busy
// Bit[15] h264_co_mb_rd_ready
// Bit[13:12] co_mv_transfer_block_cnt
// Bit[11:8] co_mv_transfer_ptr
// Bit[7] co_mv_POC_l1_busy
// Bit[6] h264_weight_scale_cal_en
// Bit[5] weight_cal_busy
// Bit[4] weight_cal_not_finished
// Bit[3:0] weight_process_state
#define VDEC2_VLD_DBG_DATA                         ((0x2c3f  << 2) + 0xff620000)
// --------------------------------------------
// VIFIFO DDR Interface
// --------------------------------------------
// The VIFIFO start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define VDEC2_VLD_MEM_VIFIFO_START_PTR             ((0x2c40  << 2) + 0xff620000)
// The current pointer points so some location between the START and END
// pointers.  The current pointer is a BYTE pointer.  That is, you can
// point to any BYTE address within the START/END range
#define VDEC2_VLD_MEM_VIFIFO_CURR_PTR              ((0x2c41  << 2) + 0xff620000)
#define VDEC2_VLD_MEM_VIFIFO_END_PTR               ((0x2c42  << 2) + 0xff620000)
#define VDEC2_VLD_MEM_VIFIFO_BYTES_AVAIL           ((0x2c43  << 2) + 0xff620000)
// VIFIFO FIFO Control
// bit  [31:24] viff_empty_int_enable_cpu[7:0]
// bit  [23:16] viff_empty_int_enable_amrisc[7:0]
//   -bit 23 Video BUFFER < 0x400 Bytes
//   -bit 22 Video BUFFER < 0x200 Bytes
//   -bit 21 Video BUFFER < 0x100 Bytes
//   -bit 20 Video BUFFER < 0x80 Bytes
//   -bit 19 Video BUFFER < 0x40 Bytes
//   -bit 18 Video BUFFER < 0x20 Bytes
//   -bit 17 vififo  < 16 double words
//   -bit 16 vififo  < 8 double words
// bit  [15:13] unused
// bit  [12]    A_urgent
// bit  [11]    transfer_length 0 - 32x64 Bits per request, 1 - 16x64 Bits per request
// bit  [10]    use_level       Set this bit to 1 to enable filling of the FIFO controlled by the buffer
//                              level control.  If this bit is 0, then use bit[1] to control the enabling of filling
// bit  [9]     Data Ready.     This bit is set when data can be popped
// bit  [8]     fill busy       This bit will be high when we're fetching data from the DDR memory
//                              To reset this module, set cntl_enable = 0, and then wait for busy = 0.
//                              After that you can pulse cntl_init to start over
// bit  [7]     init_with_cntl_init
// bit  [6]     reserved
// bits [5:3]   endian:         see $lib/rtl/ddr_endian.v
// bit  [2]     cntl_empty_en   Set to 1 to enable reading the DDR memory FIFO
//                              Set cntl_empty_en = cntl_fill_en = 0 when pulsing cntl_init
// bit  [1]     cntl_fill_en    Set to 1 to enable reading data from DDR memory
// bit  [0]     cntl_init:      After setting the read pointers, sizes, channel masks
//                              and read masks, set this bit to 1 and then to 0
//                              NOTE:  You don't need to pulse cntl_init if only the start address is
//                              being changed
#define VDEC2_VLD_MEM_VIFIFO_CONTROL               ((0x2c44  << 2) + 0xff620000)
// --------------------------------------------
// VIFIFO Buffer Level Manager
// --------------------------------------------
#define VDEC2_VLD_MEM_VIFIFO_WP                    ((0x2c45  << 2) + 0xff620000)
#define VDEC2_VLD_MEM_VIFIFO_RP                    ((0x2c46  << 2) + 0xff620000)
#define VDEC2_VLD_MEM_VIFIFO_LEVEL                 ((0x2c47  << 2) + 0xff620000)
//
// bit  [8]     use_parser_video2_wp
// bit  [7]     vbuf2_out_manual
// bit  [6]     vbuf_out_manual
// bit  [5]     empty (ReadOnly)
// bit  [4]     full (ReadOnly)
// bit  [3:2]   reserved
// bit  [1]     manual mode     Set to 1 for manual write pointer mode
// bit  [0]     Init            Set high then low after everything has been initialized
#define VDEC2_VLD_MEM_VIFIFO_BUF_CNTL              ((0x2c48  << 2) + 0xff620000)
// bit 31:16 -- drop_bytes
// bit 15:14 -- drop_status (Read-Only)
// bit 13:12 -- sync_match_position (Read-Only)
// bit 11:6 -- reserved
// bit 5:4 -- TIME_STAMP_NUMBER, 0-32bits, 1-64bits, 2-96bits, 3-128bits
// bit 3 -- stamp_soft_reset
// bit 2 -- TIME_STAMP_length_enable
// bit 1 -- TIME_STAMP_sync64_enable
// bit 0 -- TIME_STAMP_enable
#define VDEC2_VLD_TIME_STAMP_CNTL                  ((0x2c49  << 2) + 0xff620000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_0
#define VDEC2_VLD_TIME_STAMP_SYNC_0                ((0x2c4a  << 2) + 0xff620000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_1
#define VDEC2_VLD_TIME_STAMP_SYNC_1                ((0x2c4b  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_0
#define VDEC2_VLD_TIME_STAMP_0                     ((0x2c4c  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_1
#define VDEC2_VLD_TIME_STAMP_1                     ((0x2c4d  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_2
#define VDEC2_VLD_TIME_STAMP_2                     ((0x2c4e  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_3
#define VDEC2_VLD_TIME_STAMP_3                     ((0x2c4f  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_LENGTH
#define VDEC2_VLD_TIME_STAMP_LENGTH                ((0x2c50  << 2) + 0xff620000)
// bit 15:0 vififo_rd_count
#define VDEC2_VLD_MEM_VIFIFO_WRAP_COUNT            ((0x2c51  << 2) + 0xff620000)
// bit 29:24 A_brst_num
// bit 21:16 A_id
// bit 15:0 level_hold
#define VDEC2_VLD_MEM_VIFIFO_MEM_CTL               ((0x2c52  << 2) + 0xff620000)
#define VDEC2_VLD_MEM_VBUF_RD_PTR                  ((0x2c53  << 2) + 0xff620000)
#define VDEC2_VLD_MEM_VBUF2_RD_PTR                 ((0x2c54  << 2) + 0xff620000)
#define VDEC2_VLD_MEM_SWAP_ADDR                    ((0x2c55  << 2) + 0xff620000)
// bit[23:16] - swap_d_count (Read Only)
// bit[15:8]  - swap_a_count (Read Only)
// bit [7] - swap busy (Read Only)
// bit [6:2] - reserved
// bit [1] - 1 - STORE to Memory, 0 - LOAD from Memory
// bit [0] - swap active
#define VDEC2_VLD_MEM_SWAP_CTL                     ((0x2c56  << 2) + 0xff620000)
//
// Closing file:  vld_regs.h
//
//
// Reading file:  vld_regs.h
//
//========================================================================
//  VLD module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_VLD_CBUS_BASE = 0x0c
// -----------------------------------------------
#define HEVC_VLD_STATUS_CTRL                       ((0x3c00  << 2) + 0xff620000)
//
// bit 10 -- use_old_shift_en
// bit 9 -- output_mv_not_pmv
// bit 8:5 -- force_zigzag
// bit 4 -- force_zigzag_en
// bit 3 -- disable_viff_anempty_int
// bit 2 -- disable_m2_ac_coeff_one_cycle
// bit 1 -- forced_reset  force reset pmv
// bit 0 -- mpeg_type  0:mpeg1 1: mpeg2
#define HEVC_MPEG1_2_REG                           ((0x3c01  << 2) + 0xff620000)
#define HEVC_F_CODE_REG                            ((0x3c02  << 2) + 0xff620000)
#define HEVC_PIC_HEAD_INFO                         ((0x3c03  << 2) + 0xff620000)
#define HEVC_SLICE_VER_POS_PIC_TYPE                ((0x3c04  << 2) + 0xff620000)
#define HEVC_QP_VALUE_REG                          ((0x3c05  << 2) + 0xff620000)
#define HEVC_MBA_INC                               ((0x3c06  << 2) + 0xff620000)
#define HEVC_MB_MOTION_MODE                        ((0x3c07  << 2) + 0xff620000)
//`define PACKET_BYTE_COUNT   8'h08
// bit 15 -- force_search_startcode_en
// bit 14 -- int_cpu_when_error (before do anything)
// bit 13 -- vld_error_reset
// bit 12 -- return_on_slice_header
// bit 6 -- jpeg_ff00_en
// bit 5:0 -- vld_power_ctl
#define HEVC_POWER_CTL_VLD                         ((0x3c08  << 2) + 0xff620000)
#define HEVC_MB_WIDTH                              ((0x3c09  << 2) + 0xff620000)
#define HEVC_SLICE_QP                              ((0x3c0a  << 2) + 0xff620000)
// `define MB_X_MB_Y           8'h0b   /* current MBX and MBY                  */
#define HEVC_PRE_START_CODE                        ((0x3c0b  << 2) + 0xff620000)
#define HEVC_SLICE_START_BYTE_01                   ((0x3c0c  << 2) + 0xff620000)
#define HEVC_SLICE_START_BYTE_23                   ((0x3c0d  << 2) + 0xff620000)
#define HEVC_RESYNC_MARKER_LENGTH                  ((0x3c0e  << 2) + 0xff620000)
// bit[6:5] - frame/field info, 01 - top, 10 - bottom, 11 - frame
// bit[4:0] - buffer ID
// L0_BUFF_ID_0, L0_BUFF_ID_1, L1_BUFF_ID_0, L1_BUFF_ID_1
#define HEVC_DECODER_BUFFER_INFO                   ((0x3c0f  << 2) + 0xff620000)
#define HEVC_FST_FOR_MV_X                          ((0x3c10  << 2) + 0xff620000)
#define HEVC_FST_FOR_MV_Y                          ((0x3c11  << 2) + 0xff620000)
#define HEVC_SCD_FOR_MV_X                          ((0x3c12  << 2) + 0xff620000)
#define HEVC_SCD_FOR_MV_Y                          ((0x3c13  << 2) + 0xff620000)
#define HEVC_FST_BAK_MV_X                          ((0x3c14  << 2) + 0xff620000)
#define HEVC_FST_BAK_MV_Y                          ((0x3c15  << 2) + 0xff620000)
#define HEVC_SCD_BAK_MV_X                          ((0x3c16  << 2) + 0xff620000)
#define HEVC_SCD_BAK_MV_Y                          ((0x3c17  << 2) + 0xff620000)
// Bit 7:4 -- read_buffer_interlace  0-progressive, 1-interlace, used in VC1
// bit 3 -- disable_new_stcode_search_fix // From GXM
// bit 2 -- weighting_prediction
// bit 1 -- mb_weighting_flag
// bit 0 -- slice_weighting_flag
#define HEVC_VLD_DECODE_CONTROL                    ((0x3c18  << 2) + 0xff620000)
#define HEVC_VIFF_BIT_CNT                          ((0x3c1a  << 2) + 0xff620000)
#define HEVC_BYTE_ALIGN_PEAK_HI                    ((0x3c1b  << 2) + 0xff620000)
#define HEVC_BYTE_ALIGN_PEAK_LO                    ((0x3c1c  << 2) + 0xff620000)
#define HEVC_NEXT_ALIGN_PEAK                       ((0x3c1d  << 2) + 0xff620000)
// bit 31    : byte_aligned_zero_23_from_org // From GXM
// bit 30    : force_shift_out_drop_flag_zero // From GXM
// bit 29    : en_st_protect_from_org // From GXM
// bit 28    : enable_halt_decode_start_voff
// bit 27    : disable_C_pred_check
// bit 26    : disable_I4_pred_check
// bit 25    : disable_I16_pred_check
// bit 24    : check_avs_1st_drop
// bit 23    : enable_cabac_protect // From GXM
// bit 22    : enable_avs_drop_more
// bit 21    : reset_avs_drop_ptr
// bit 20    : reset_cabac_use_next_at_end_req
// bit 19    : vc1_inv_intra_co_mb_ref_rd
// bit 18    : vc1_inv_co_mb_ref_rd
// bit 17    : vc1_inv_intra_co_mb_ref_wr
// bit 16    : vc1_inv_co_mb_ref_wr
// bit 15    : disable_mv_cal_begin_only
// bit 14    : avs_drop_enable
// bit 13:12 : avs_drop_ptr
// bit 11:8  : avs_demu_ctl_reg
// bit 7 : avs_enable
// bit 6 : disable_dblk_hcmd
// bit 5 : disable_mc_hcmd
// bit 4 : first_mode3_set enable
// bit 3 : first_mode3
// bit 2:1 : vc1_profile  0-SP, 1-MP, 2-reserved, 3-AP
// bit 0   : vc1_enable
#define HEVC_VC1_CONTROL_REG                       ((0x3c1e  << 2) + 0xff620000)
#define HEVC_PMV1_X                                ((0x3c20  << 2) + 0xff620000)
#define HEVC_PMV1_Y                                ((0x3c21  << 2) + 0xff620000)
#define HEVC_PMV2_X                                ((0x3c22  << 2) + 0xff620000)
#define HEVC_PMV2_Y                                ((0x3c23  << 2) + 0xff620000)
#define HEVC_PMV3_X                                ((0x3c24  << 2) + 0xff620000)
#define HEVC_PMV3_Y                                ((0x3c25  << 2) + 0xff620000)
#define HEVC_PMV4_X                                ((0x3c26  << 2) + 0xff620000)
#define HEVC_PMV4_Y                                ((0x3c27  << 2) + 0xff620000)
// Can't use the same address for different defines
// Therefore, create a single define that covers both
// Only appears to be used in micro-code since the VLD hardware is
// hard coded.
// `define M4_TABLE_SELECT     8'h28  // Does this exist in HW ? Added from register_mp2.h
// `define M4_TABLE_OUTPUT     8'h28  // Does this exist in HW ? Added from register_mp2.h
#define HEVC_M4_TABLE_SELECT                       ((0x3c28  << 2) + 0xff620000)
#define HEVC_M4_CONTROL_REG                        ((0x3c29  << 2) + 0xff620000)
#define HEVC_BLOCK_NUM                             ((0x3c2a  << 2) + 0xff620000)
#define HEVC_PATTERN_CODE                          ((0x3c2b  << 2) + 0xff620000)
#define HEVC_MB_INFO                               ((0x3c2c  << 2) + 0xff620000)
#define HEVC_VLD_DC_PRED                           ((0x3c2d  << 2) + 0xff620000)
#define HEVC_VLD_ERROR_MASK                        ((0x3c2e  << 2) + 0xff620000)
#define HEVC_VLD_DC_PRED_C                         ((0x3c2f  << 2) + 0xff620000)
#define HEVC_LAST_SLICE_MV_ADDR                    ((0x3c30  << 2) + 0xff620000)
#define HEVC_LAST_MVX                              ((0x3c31  << 2) + 0xff620000)
#define HEVC_LAST_MVY                              ((0x3c32  << 2) + 0xff620000)
#define HEVC_VLD_C38                               ((0x3c38  << 2) + 0xff620000)
#define HEVC_VLD_C39                               ((0x3c39  << 2) + 0xff620000)
#define HEVC_VLD_STATUS                            ((0x3c3a  << 2) + 0xff620000)
#define HEVC_VLD_SHIFT_STATUS                      ((0x3c3b  << 2) + 0xff620000)
// `define VLD_SHIFT_INFO      8'h3b  // Does this exist in HW ? used in $ucode/mpeg4
#define HEVC_VOFF_STATUS                           ((0x3c3c  << 2) + 0xff620000)
#define HEVC_VLD_C3D                               ((0x3c3d  << 2) + 0xff620000)
#define HEVC_VLD_DBG_INDEX                         ((0x3c3e  << 2) + 0xff620000)
// vld_buff_info -- (index == 0)
// Bit11]    halt_decode_start_voff
// Bit10]    C_pred_error
// Bit[9]    I4_pred_error
// Bit[8]    I16_pred_error
// Bit[7:6]  mv_UR_ready_cnt;
// Bit[5]  vld_wr_idx
// Bit[4]  iq_rd_idx
// Bit[3]  vld_vi_block_rdy_1
// Bit[2]  vld_vi_block_rdy_2
// Bit[1]  voff_empty_1
// Bit[0]  voff_empty_2
// cabac_buff_info_0 -- (index == 1)
// Bit[31] shift_data_ready
// Bit[30:29] Reserved
// Bit[28:24] cabac_buffer_ptr
// Bit[23:0] cabac_buffer
// cabac_buff_info_1 -- (index == 2)
// Bit[31:29] Reserved
// Bit[28:20] Drange
// Bit[19:16] bin_count_4
// Bit[15:13] Reserved
// Bit[12:6] context_mem_do
// Bit[5:3] coeff_state
// Bit[2:0] mvd_state
// h264_mv_present -- (index == 3)
// Bit[31:16] mv_present_l0
// Bit[15:0] mv_present_l1
// h264_mv_cal_info_0 -- (index == 4)
// [31:28] mv_cal_state
// [27:24] direct_spatial_cnt
// Bit[23:21] Reserved
// Bit[20] mv_UR_ready_for_mv_cal
// Bit[19] co_mb_mem_ready_for_mv_cal
// Bit[18] mc_dblk_cmd_if_busy
// Bit[17] h264_co_mb_wr_busy
// Bit[16] H264_cbp_blk_ready
// Bit[15] mc_hcmd_rrdy
// Bit[14] mc_hcmd_srdy
// Bit[13] mc_cmd_if_ready
// Bit[12] mc_hcmd_mv_available
// Bit[11:8] mc_cmd_if_state
// Bit[7] dblk_hcmd_rrdy
// Bit[6] dblk_hcmd_srdy
// Bit[5] dblk_cmd_if_ready
// Bit[4] dblk_hcmd_mv_available
// Bit[3:0] dblk_cmd_if_state
// h264_mv_cal_info_1 -- (index == 5)
//  Bit[31:29] Reserved
//  Bit[28:24] total_mvd_num_l0
//  Bit[23:21] Reserved
//  Bit[20:16] mv_cal_ptr_l0
//  Bit[15:13] Reserved
//  Bit[12:8] mc_hcmd_ptr_l0
//  Bit[7:5] Reserved
//  Bit[4:0] dblk_hcmd_ptr_l0
// h264_mv_cal_info_2 -- (index == 6)
//  Bit[31:29] Reserved
//  Bit[28:24] total_mvd_num_l1
//  Bit[23:21] Reserved
//  Bit[20:16] mv_cal_ptr_l1
//  Bit[15:13] Reserved
//  Bit[12:8] mc_hcmd_ptr_l1
//  Bit[7:5] Reserved
//  Bit[4:0] dblk_hcmd_ptr_l1
// h264_co_mb_info -- (index == 7)
// Bit[31:26] Reserved
// Bit[25] mv_scale_cal_busy
// Bit[24:20] co_mv_count
// Bit[19:16] co_mv_process_state
// Bit[15] h264_co_mb_rd_busy
// Bit[15] h264_co_mb_rd_ready
// Bit[13:12] co_mv_transfer_block_cnt
// Bit[11:8] co_mv_transfer_ptr
// Bit[7] co_mv_POC_l1_busy
// Bit[6] h264_weight_scale_cal_en
// Bit[5] weight_cal_busy
// Bit[4] weight_cal_not_finished
// Bit[3:0] weight_process_state
#define HEVC_VLD_DBG_DATA                          ((0x3c3f  << 2) + 0xff620000)
// --------------------------------------------
// VIFIFO DDR Interface
// --------------------------------------------
// The VIFIFO start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define HEVC_VLD_MEM_VIFIFO_START_PTR              ((0x3c40  << 2) + 0xff620000)
// The current pointer points so some location between the START and END
// pointers.  The current pointer is a BYTE pointer.  That is, you can
// point to any BYTE address within the START/END range
#define HEVC_VLD_MEM_VIFIFO_CURR_PTR               ((0x3c41  << 2) + 0xff620000)
#define HEVC_VLD_MEM_VIFIFO_END_PTR                ((0x3c42  << 2) + 0xff620000)
#define HEVC_VLD_MEM_VIFIFO_BYTES_AVAIL            ((0x3c43  << 2) + 0xff620000)
// VIFIFO FIFO Control
// bit  [31:24] viff_empty_int_enable_cpu[7:0]
// bit  [23:16] viff_empty_int_enable_amrisc[7:0]
//   -bit 23 Video BUFFER < 0x400 Bytes
//   -bit 22 Video BUFFER < 0x200 Bytes
//   -bit 21 Video BUFFER < 0x100 Bytes
//   -bit 20 Video BUFFER < 0x80 Bytes
//   -bit 19 Video BUFFER < 0x40 Bytes
//   -bit 18 Video BUFFER < 0x20 Bytes
//   -bit 17 vififo  < 16 double words
//   -bit 16 vififo  < 8 double words
// bit  [15:13] unused
// bit  [12]    A_urgent
// bit  [11]    transfer_length 0 - 32x64 Bits per request, 1 - 16x64 Bits per request
// bit  [10]    use_level       Set this bit to 1 to enable filling of the FIFO controlled by the buffer
//                              level control.  If this bit is 0, then use bit[1] to control the enabling of filling
// bit  [9]     Data Ready.     This bit is set when data can be popped
// bit  [8]     fill busy       This bit will be high when we're fetching data from the DDR memory
//                              To reset this module, set cntl_enable = 0, and then wait for busy = 0.
//                              After that you can pulse cntl_init to start over
// bit  [7]     init_with_cntl_init
// bit  [6]     reserved
// bits [5:3]   endian:         see $lib/rtl/ddr_endian.v
// bit  [2]     cntl_empty_en   Set to 1 to enable reading the DDR memory FIFO
//                              Set cntl_empty_en = cntl_fill_en = 0 when pulsing cntl_init
// bit  [1]     cntl_fill_en    Set to 1 to enable reading data from DDR memory
// bit  [0]     cntl_init:      After setting the read pointers, sizes, channel masks
//                              and read masks, set this bit to 1 and then to 0
//                              NOTE:  You don't need to pulse cntl_init if only the start address is
//                              being changed
#define HEVC_VLD_MEM_VIFIFO_CONTROL                ((0x3c44  << 2) + 0xff620000)
// --------------------------------------------
// VIFIFO Buffer Level Manager
// --------------------------------------------
#define HEVC_VLD_MEM_VIFIFO_WP                     ((0x3c45  << 2) + 0xff620000)
#define HEVC_VLD_MEM_VIFIFO_RP                     ((0x3c46  << 2) + 0xff620000)
#define HEVC_VLD_MEM_VIFIFO_LEVEL                  ((0x3c47  << 2) + 0xff620000)
//
// bit  [8]     use_parser_video2_wp
// bit  [7]     vbuf2_out_manual
// bit  [6]     vbuf_out_manual
// bit  [5]     empty (ReadOnly)
// bit  [4]     full (ReadOnly)
// bit  [3:2]   reserved
// bit  [1]     manual mode     Set to 1 for manual write pointer mode
// bit  [0]     Init            Set high then low after everything has been initialized
#define HEVC_VLD_MEM_VIFIFO_BUF_CNTL               ((0x3c48  << 2) + 0xff620000)
// bit 31:16 -- drop_bytes
// bit 15:14 -- drop_status (Read-Only)
// bit 13:12 -- sync_match_position (Read-Only)
// bit 11:6 -- reserved
// bit 5:4 -- TIME_STAMP_NUMBER, 0-32bits, 1-64bits, 2-96bits, 3-128bits
// bit 3 -- stamp_soft_reset
// bit 2 -- TIME_STAMP_length_enable
// bit 1 -- TIME_STAMP_sync64_enable
// bit 0 -- TIME_STAMP_enable
#define HEVC_VLD_TIME_STAMP_CNTL                   ((0x3c49  << 2) + 0xff620000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_0
#define HEVC_VLD_TIME_STAMP_SYNC_0                 ((0x3c4a  << 2) + 0xff620000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_1
#define HEVC_VLD_TIME_STAMP_SYNC_1                 ((0x3c4b  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_0
#define HEVC_VLD_TIME_STAMP_0                      ((0x3c4c  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_1
#define HEVC_VLD_TIME_STAMP_1                      ((0x3c4d  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_2
#define HEVC_VLD_TIME_STAMP_2                      ((0x3c4e  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_3
#define HEVC_VLD_TIME_STAMP_3                      ((0x3c4f  << 2) + 0xff620000)
// bit 31:0 TIME_STAMP_LENGTH
#define HEVC_VLD_TIME_STAMP_LENGTH                 ((0x3c50  << 2) + 0xff620000)
// bit 15:0 vififo_rd_count
#define HEVC_VLD_MEM_VIFIFO_WRAP_COUNT             ((0x3c51  << 2) + 0xff620000)
// bit 29:24 A_brst_num
// bit 21:16 A_id
// bit 15:0 level_hold
#define HEVC_VLD_MEM_VIFIFO_MEM_CTL                ((0x3c52  << 2) + 0xff620000)
#define HEVC_VLD_MEM_VBUF_RD_PTR                   ((0x3c53  << 2) + 0xff620000)
#define HEVC_VLD_MEM_VBUF2_RD_PTR                  ((0x3c54  << 2) + 0xff620000)
#define HEVC_VLD_MEM_SWAP_ADDR                     ((0x3c55  << 2) + 0xff620000)
// bit[23:16] - swap_d_count (Read Only)
// bit[15:8]  - swap_a_count (Read Only)
// bit [7] - swap busy (Read Only)
// bit [6:2] - reserved
// bit [1] - 1 - STORE to Memory, 0 - LOAD from Memory
// bit [0] - swap active
#define HEVC_VLD_MEM_SWAP_CTL                      ((0x3c56  << 2) + 0xff620000)
//
// Closing file:  vld_regs.h
//
//
// Reading file:  iqidct_regs.h
//
//========================================================================
//  IQ/IDCT module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_IQIDCT_CBUS_BASE = 0x0e
// -----------------------------------------------
#define HCODEC_VCOP_CTRL_REG                       ((0x1e00  << 2) + 0xff620000)
#define HCODEC_QP_CTRL_REG                         ((0x1e01  << 2) + 0xff620000)
#define HCODEC_INTRA_QUANT_MATRIX                  ((0x1e02  << 2) + 0xff620000)
#define HCODEC_NON_I_QUANT_MATRIX                  ((0x1e03  << 2) + 0xff620000)
#define HCODEC_DC_SCALER                           ((0x1e04  << 2) + 0xff620000)
#define HCODEC_DC_AC_CTRL                          ((0x1e05  << 2) + 0xff620000)
// `define RV_AI_CTRL          8'h05  // ONLY for $ucode/real/amrisc/rv.s reg value from apollo
#define HCODEC_DC_AC_SCALE_MUL                     ((0x1e06  << 2) + 0xff620000)
#define HCODEC_DC_AC_SCALE_DIV                     ((0x1e07  << 2) + 0xff620000)
// `define DC_AC_SCALE_RESULT  8'h06
// `define RESERVED_E07        8'h07
#define HCODEC_POWER_CTL_IQIDCT                    ((0x1e08  << 2) + 0xff620000)
#define HCODEC_RV_AI_Y_X                           ((0x1e09  << 2) + 0xff620000)
#define HCODEC_RV_AI_U_X                           ((0x1e0a  << 2) + 0xff620000)
#define HCODEC_RV_AI_V_X                           ((0x1e0b  << 2) + 0xff620000)
// bit 15:0 will count up when rv_ai_mb finished when non zero
// and rv_ai_mb_finished_int will be generate when this is not zero
#define HCODEC_RV_AI_MB_COUNT                      ((0x1e0c  << 2) + 0xff620000)
// For H264 I in PB picture Use -- dma type : h264_next_intra_dma
#define HCODEC_NEXT_INTRA_DMA_ADDRESS              ((0x1e0d  << 2) + 0xff620000)
// Bit 16 -- dcac_dma_read_cache_disable
// Bit 15 -- dcac_dma_urgent
// Bit 14 -- nv21_swap
// Bit 13 -- nv21_top_dma
// Bit 12 -- reset_rv_ai_wait_rd_data
// Bit 11 -- set_rv_ai_wait_rd_data [12:11] = 3 means only dec 1 (For Skipped MB of MBAFF)
// Bit 10 -- rv_ai_wait_rd_data (Read Only)
// Bit 9 -- enable_rv_ai_wait_rd_data
// Bit 8 -- disable_vc1_mv_update
// Bit 7 -- pred_dc_signed
// Bit 6 -- inc_vld_ready_count
// Bit 5 -- dec_vld_ready_count
// Bit 4 -- disable_ref_bidir_fix
// Bit 3 -- disable_MV_UL_l1_bot_fix
// Bit 2 -- disable_mb_aff_fix
// Bit 1 -- canvas_addr_7
// Bit 0 -- constrained_intra_pred_flag for H264
#define HCODEC_IQIDCT_CONTROL                      ((0x1e0e  << 2) + 0xff620000)
// Bit[31:19] Reserved
// Bit[18] iq_waiting
// Bit[17] iq_om_wr_idx
// Bit[16] iq_om_rd_idx
// Bit[15] iq_om_busy
// Bit[14] iq_om_2_busy
// Bit[13] idx_fifo_0
// Bit[12] idx_fifo_1
// Bit[11] idx_fifo_2
// Bit[10] idx_fifo_3
// Bit[9] idx_fifo_4
// Bit[8] idx_fifo_5
// Bit[7] idx_fifo_6
// Bit[6] idx_fifo_7
// Bit[5:3] idx_fifo_wp
// Bit[2:0] idx_fifo_rp
#define HCODEC_IQIDCT_DEBUG_INFO_0                 ((0x1e0f  << 2) + 0xff620000)
// For RTL Simulation Only
#define HCODEC_DEBLK_CMD                           ((0x1e10  << 2) + 0xff620000)
// Bit[15+16] ds_mc_valid_2
// Bit[14+16] new_idct1_rd_idx_2
// Bit[13+16] new_idct1_wr_idx_2
// Bit[12+16] idct1_buff0_busy_2
// Bit[11+16] idct1_buff1_busy_2
// Bit[10+16] new_idct1_busy_2
// Bit[9+16] iq_om_8val_2
// Bit[8+16] idct1_pipe_busy_2
// Bit[7+16] wait_mb_left_finish_hold_2
// Bit[6+16] new_idct2_rd_idx_2
// Bit[5+16] new_idct2_wr_idx_2
// Bit[4+16] idct2_buff0_busy_2
// Bit[3+16] idct2_buff1_busy_2
// Bit[2+16] idct2_en_2
// Bit[1+16] new_idct2_busy_2
// Bit[0+16] new_idct1_ready_2
// Bit[15] ds_mc_valid_1
// Bit[14] new_idct1_rd_idx_1
// Bit[13] new_idct1_wr_idx_1
// Bit[12] idct1_buff0_busy_1
// Bit[11] idct1_buff1_busy_1
// Bit[10] new_idct1_busy_1
// Bit[9] iq_om_8val_1
// Bit[8] idct1_pipe_busy_1
// Bit[7] wait_mb_left_finish_hold_1
// Bit[6] new_idct2_rd_idx_1
// Bit[5] new_idct2_wr_idx_1
// Bit[4] idct2_buff0_busy_1
// Bit[3] idct2_buff1_busy_1
// Bit[2] idct2_en_1
// Bit[1] new_idct2_busy_1
// Bit[0] new_idct1_ready_1
#define HCODEC_IQIDCT_DEBUG_IDCT                   ((0x1e11  << 2) + 0xff620000)
// bit 31 -- convas_enable
// bit 30:24 -- convas_x_count ( 8 pixels / 64 bits )
// bit 23:16 -- convas_y_count
// bit 15   -- dcac_dma_busy
// bit 14   -- dcac_dma_read_cache_active
// bit 13:8 -- dcac_dma_count
// bit 7    -- dcac_dma_rw
// bit 6    -- dcac_skip_read_mode
// bit 5:0  -- dcac_dma_offset
#define HCODEC_DCAC_DMA_CTRL                       ((0x1e12  << 2) + 0xff620000)
// when (convas_enable == 0 )
//   bit 31:0 dcac_dma_addr
// when (convas_enable == 1 )
//   bit 31:25 canvas_addr (7 bits)
//   bit 24:12 convas_y_start ( 13 btis )
//   bit 11:0  convas_x_start ( 12 btis )
#define HCODEC_DCAC_DMA_ADDRESS                    ((0x1e13  << 2) + 0xff620000)
// bit 7:0 -- dcac_cpu_addr
#define HCODEC_DCAC_CPU_ADDRESS                    ((0x1e14  << 2) + 0xff620000)
// bit 31:0 -- dcac_cpu_data
#define HCODEC_DCAC_CPU_DATA                       ((0x1e15  << 2) + 0xff620000)
// bit 31:19 -- reserved
// bit 18:16 -- block_num_reg -- Read-Only
// bit 15:0 -- dcac_mb_count
#define HCODEC_DCAC_MB_COUNT                       ((0x1e16  << 2) + 0xff620000)
// bit 31:18 -- reserved
// For H264 :
//   bit 17:2 -- h264_quant
//   bit 11:6 -- h264_quant_c
//   bit  5:0 -- h264_quant_c
// For VC1 :
//   bit    17 -- qindex_GT_8
//   bit    16 -- HalfQPStep
//   bit 15:12 -- eQuantMode
//   bit 11:6  -- AltPQuant
//   bit  5:0  -- PQuant
//
#define HCODEC_IQ_QUANT                            ((0x1e17  << 2) + 0xff620000)
// bit 31:24  -- bitplane_width
// bit 23:16  -- bitplane_height
// bit 15:14  -- bitplane_start_x
// bit 13:12  -- bitplane_start_y
// bit 11:4   -- reserved
// bit 3:1    -- bitplane_type
// bit 0      -- bitplane_busy
#define HCODEC_VC1_BITPLANE_CTL                    ((0x1e18  << 2) + 0xff620000)
// bit 24:16  -- wq_param1
// bit  8: 0  -- wq_param0
#define HCODEC_AVSP_IQ_WQ_PARAM_01                 ((0x1e19  << 2) + 0xff620000)
// bit 24:16  -- wq_param3
// bit  8: 0  -- wq_param2
#define HCODEC_AVSP_IQ_WQ_PARAM_23                 ((0x1e1a  << 2) + 0xff620000)
// bit 24:16  -- wq_param5
// bit  8: 0  -- wq_param4
#define HCODEC_AVSP_IQ_WQ_PARAM_45                 ((0x1e1b  << 2) + 0xff620000)
// bit    31  -- weight_quant_en
// bit 17:16  -- current_scene_model
// bit 12: 8  -- chroma_qp_delta_cr
// bit  4: 0  -- chroma_qp_delta_cb
#define HCODEC_AVSP_IQ_CTL                         ((0x1e1c  << 2) + 0xff620000)
//======================================
//  VCOP Control Register Bits
//
//======================================
    //`define IQIDCT_RESET	    16'h0001	    // Bit 0
//======================================
//  QP Control Register Bits
//
//======================================
// Duplicate Address:  When actually used
// please move to a different address
// `define FLD_DCT_TYPE	    16'h0100	    // Bit 8	0 = Frame DCT; 1 = field DCT
//
// Closing file:  iqidct_regs.h
//
//
// Reading file:  iqidct_regs.h
//
//========================================================================
//  IQ/IDCT module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_IQIDCT_CBUS_BASE = 0x0e
// -----------------------------------------------
#define VDEC2_VCOP_CTRL_REG                        ((0x2e00  << 2) + 0xff620000)
#define VDEC2_QP_CTRL_REG                          ((0x2e01  << 2) + 0xff620000)
#define VDEC2_INTRA_QUANT_MATRIX                   ((0x2e02  << 2) + 0xff620000)
#define VDEC2_NON_I_QUANT_MATRIX                   ((0x2e03  << 2) + 0xff620000)
#define VDEC2_DC_SCALER                            ((0x2e04  << 2) + 0xff620000)
#define VDEC2_DC_AC_CTRL                           ((0x2e05  << 2) + 0xff620000)
// `define RV_AI_CTRL          8'h05  // ONLY for $ucode/real/amrisc/rv.s reg value from apollo
#define VDEC2_DC_AC_SCALE_MUL                      ((0x2e06  << 2) + 0xff620000)
#define VDEC2_DC_AC_SCALE_DIV                      ((0x2e07  << 2) + 0xff620000)
// `define DC_AC_SCALE_RESULT  8'h06
// `define RESERVED_E07        8'h07
#define VDEC2_POWER_CTL_IQIDCT                     ((0x2e08  << 2) + 0xff620000)
#define VDEC2_RV_AI_Y_X                            ((0x2e09  << 2) + 0xff620000)
#define VDEC2_RV_AI_U_X                            ((0x2e0a  << 2) + 0xff620000)
#define VDEC2_RV_AI_V_X                            ((0x2e0b  << 2) + 0xff620000)
// bit 15:0 will count up when rv_ai_mb finished when non zero
// and rv_ai_mb_finished_int will be generate when this is not zero
#define VDEC2_RV_AI_MB_COUNT                       ((0x2e0c  << 2) + 0xff620000)
// For H264 I in PB picture Use -- dma type : h264_next_intra_dma
#define VDEC2_NEXT_INTRA_DMA_ADDRESS               ((0x2e0d  << 2) + 0xff620000)
// Bit 16 -- dcac_dma_read_cache_disable
// Bit 15 -- dcac_dma_urgent
// Bit 14 -- nv21_swap
// Bit 13 -- nv21_top_dma
// Bit 12 -- reset_rv_ai_wait_rd_data
// Bit 11 -- set_rv_ai_wait_rd_data [12:11] = 3 means only dec 1 (For Skipped MB of MBAFF)
// Bit 10 -- rv_ai_wait_rd_data (Read Only)
// Bit 9 -- enable_rv_ai_wait_rd_data
// Bit 8 -- disable_vc1_mv_update
// Bit 7 -- pred_dc_signed
// Bit 6 -- inc_vld_ready_count
// Bit 5 -- dec_vld_ready_count
// Bit 4 -- disable_ref_bidir_fix
// Bit 3 -- disable_MV_UL_l1_bot_fix
// Bit 2 -- disable_mb_aff_fix
// Bit 1 -- canvas_addr_7
// Bit 0 -- constrained_intra_pred_flag for H264
#define VDEC2_IQIDCT_CONTROL                       ((0x2e0e  << 2) + 0xff620000)
// Bit[31:19] Reserved
// Bit[18] iq_waiting
// Bit[17] iq_om_wr_idx
// Bit[16] iq_om_rd_idx
// Bit[15] iq_om_busy
// Bit[14] iq_om_2_busy
// Bit[13] idx_fifo_0
// Bit[12] idx_fifo_1
// Bit[11] idx_fifo_2
// Bit[10] idx_fifo_3
// Bit[9] idx_fifo_4
// Bit[8] idx_fifo_5
// Bit[7] idx_fifo_6
// Bit[6] idx_fifo_7
// Bit[5:3] idx_fifo_wp
// Bit[2:0] idx_fifo_rp
#define VDEC2_IQIDCT_DEBUG_INFO_0                  ((0x2e0f  << 2) + 0xff620000)
// For RTL Simulation Only
#define VDEC2_DEBLK_CMD                            ((0x2e10  << 2) + 0xff620000)
// Bit[15+16] ds_mc_valid_2
// Bit[14+16] new_idct1_rd_idx_2
// Bit[13+16] new_idct1_wr_idx_2
// Bit[12+16] idct1_buff0_busy_2
// Bit[11+16] idct1_buff1_busy_2
// Bit[10+16] new_idct1_busy_2
// Bit[9+16] iq_om_8val_2
// Bit[8+16] idct1_pipe_busy_2
// Bit[7+16] wait_mb_left_finish_hold_2
// Bit[6+16] new_idct2_rd_idx_2
// Bit[5+16] new_idct2_wr_idx_2
// Bit[4+16] idct2_buff0_busy_2
// Bit[3+16] idct2_buff1_busy_2
// Bit[2+16] idct2_en_2
// Bit[1+16] new_idct2_busy_2
// Bit[0+16] new_idct1_ready_2
// Bit[15] ds_mc_valid_1
// Bit[14] new_idct1_rd_idx_1
// Bit[13] new_idct1_wr_idx_1
// Bit[12] idct1_buff0_busy_1
// Bit[11] idct1_buff1_busy_1
// Bit[10] new_idct1_busy_1
// Bit[9] iq_om_8val_1
// Bit[8] idct1_pipe_busy_1
// Bit[7] wait_mb_left_finish_hold_1
// Bit[6] new_idct2_rd_idx_1
// Bit[5] new_idct2_wr_idx_1
// Bit[4] idct2_buff0_busy_1
// Bit[3] idct2_buff1_busy_1
// Bit[2] idct2_en_1
// Bit[1] new_idct2_busy_1
// Bit[0] new_idct1_ready_1
#define VDEC2_IQIDCT_DEBUG_IDCT                    ((0x2e11  << 2) + 0xff620000)
// bit 31 -- convas_enable
// bit 30:24 -- convas_x_count ( 8 pixels / 64 bits )
// bit 23:16 -- convas_y_count
// bit 15   -- dcac_dma_busy
// bit 14   -- dcac_dma_read_cache_active
// bit 13:8 -- dcac_dma_count
// bit 7    -- dcac_dma_rw
// bit 6    -- dcac_skip_read_mode
// bit 5:0  -- dcac_dma_offset
#define VDEC2_DCAC_DMA_CTRL                        ((0x2e12  << 2) + 0xff620000)
// when (convas_enable == 0 )
//   bit 31:0 dcac_dma_addr
// when (convas_enable == 1 )
//   bit 31:25 canvas_addr (7 bits)
//   bit 24:12 convas_y_start ( 13 btis )
//   bit 11:0  convas_x_start ( 12 btis )
#define VDEC2_DCAC_DMA_ADDRESS                     ((0x2e13  << 2) + 0xff620000)
// bit 7:0 -- dcac_cpu_addr
#define VDEC2_DCAC_CPU_ADDRESS                     ((0x2e14  << 2) + 0xff620000)
// bit 31:0 -- dcac_cpu_data
#define VDEC2_DCAC_CPU_DATA                        ((0x2e15  << 2) + 0xff620000)
// bit 31:19 -- reserved
// bit 18:16 -- block_num_reg -- Read-Only
// bit 15:0 -- dcac_mb_count
#define VDEC2_DCAC_MB_COUNT                        ((0x2e16  << 2) + 0xff620000)
// bit 31:18 -- reserved
// For H264 :
//   bit 17:2 -- h264_quant
//   bit 11:6 -- h264_quant_c
//   bit  5:0 -- h264_quant_c
// For VC1 :
//   bit    17 -- qindex_GT_8
//   bit    16 -- HalfQPStep
//   bit 15:12 -- eQuantMode
//   bit 11:6  -- AltPQuant
//   bit  5:0  -- PQuant
//
#define VDEC2_IQ_QUANT                             ((0x2e17  << 2) + 0xff620000)
// bit 31:24  -- bitplane_width
// bit 23:16  -- bitplane_height
// bit 15:14  -- bitplane_start_x
// bit 13:12  -- bitplane_start_y
// bit 11:4   -- reserved
// bit 3:1    -- bitplane_type
// bit 0      -- bitplane_busy
#define VDEC2_VC1_BITPLANE_CTL                     ((0x2e18  << 2) + 0xff620000)
// bit 24:16  -- wq_param1
// bit  8: 0  -- wq_param0
#define VDEC2_AVSP_IQ_WQ_PARAM_01                  ((0x2e19  << 2) + 0xff620000)
// bit 24:16  -- wq_param3
// bit  8: 0  -- wq_param2
#define VDEC2_AVSP_IQ_WQ_PARAM_23                  ((0x2e1a  << 2) + 0xff620000)
// bit 24:16  -- wq_param5
// bit  8: 0  -- wq_param4
#define VDEC2_AVSP_IQ_WQ_PARAM_45                  ((0x2e1b  << 2) + 0xff620000)
// bit    31  -- weight_quant_en
// bit 17:16  -- current_scene_model
// bit 12: 8  -- chroma_qp_delta_cr
// bit  4: 0  -- chroma_qp_delta_cb
#define VDEC2_AVSP_IQ_CTL                          ((0x2e1c  << 2) + 0xff620000)
//======================================
//  VCOP Control Register Bits
//
//======================================
    //`define IQIDCT_RESET	    16'h0001	    // Bit 0
//======================================
//  QP Control Register Bits
//
//======================================
// Duplicate Address:  When actually used
// please move to a different address
// `define FLD_DCT_TYPE	    16'h0100	    // Bit 8	0 = Frame DCT; 1 = field DCT
//
// Closing file:  iqidct_regs.h
//
//
// Reading file:  iqidct_regs.h
//
//========================================================================
//  IQ/IDCT module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_IQIDCT_CBUS_BASE = 0x0e
// -----------------------------------------------
#define HEVC_VCOP_CTRL_REG                         ((0x3e00  << 2) + 0xff620000)
#define HEVC_QP_CTRL_REG                           ((0x3e01  << 2) + 0xff620000)
#define HEVC_INTRA_QUANT_MATRIX                    ((0x3e02  << 2) + 0xff620000)
#define HEVC_NON_I_QUANT_MATRIX                    ((0x3e03  << 2) + 0xff620000)
#define HEVC_DC_SCALER                             ((0x3e04  << 2) + 0xff620000)
#define HEVC_DC_AC_CTRL                            ((0x3e05  << 2) + 0xff620000)
// `define RV_AI_CTRL          8'h05  // ONLY for $ucode/real/amrisc/rv.s reg value from apollo
#define HEVC_DC_AC_SCALE_MUL                       ((0x3e06  << 2) + 0xff620000)
#define HEVC_DC_AC_SCALE_DIV                       ((0x3e07  << 2) + 0xff620000)
// `define DC_AC_SCALE_RESULT  8'h06
// `define RESERVED_E07        8'h07
#define HEVC_POWER_CTL_IQIDCT                      ((0x3e08  << 2) + 0xff620000)
#define HEVC_RV_AI_Y_X                             ((0x3e09  << 2) + 0xff620000)
#define HEVC_RV_AI_U_X                             ((0x3e0a  << 2) + 0xff620000)
#define HEVC_RV_AI_V_X                             ((0x3e0b  << 2) + 0xff620000)
// bit 15:0 will count up when rv_ai_mb finished when non zero
// and rv_ai_mb_finished_int will be generate when this is not zero
#define HEVC_RV_AI_MB_COUNT                        ((0x3e0c  << 2) + 0xff620000)
// For H264 I in PB picture Use -- dma type : h264_next_intra_dma
#define HEVC_NEXT_INTRA_DMA_ADDRESS                ((0x3e0d  << 2) + 0xff620000)
// Bit 16 -- dcac_dma_read_cache_disable
// Bit 15 -- dcac_dma_urgent
// Bit 14 -- nv21_swap
// Bit 13 -- nv21_top_dma
// Bit 12 -- reset_rv_ai_wait_rd_data
// Bit 11 -- set_rv_ai_wait_rd_data [12:11] = 3 means only dec 1 (For Skipped MB of MBAFF)
// Bit 10 -- rv_ai_wait_rd_data (Read Only)
// Bit 9 -- enable_rv_ai_wait_rd_data
// Bit 8 -- disable_vc1_mv_update
// Bit 7 -- pred_dc_signed
// Bit 6 -- inc_vld_ready_count
// Bit 5 -- dec_vld_ready_count
// Bit 4 -- disable_ref_bidir_fix
// Bit 3 -- disable_MV_UL_l1_bot_fix
// Bit 2 -- disable_mb_aff_fix
// Bit 1 -- canvas_addr_7
// Bit 0 -- constrained_intra_pred_flag for H264
#define HEVC_IQIDCT_CONTROL                        ((0x3e0e  << 2) + 0xff620000)
// Bit[31:19] Reserved
// Bit[18] iq_waiting
// Bit[17] iq_om_wr_idx
// Bit[16] iq_om_rd_idx
// Bit[15] iq_om_busy
// Bit[14] iq_om_2_busy
// Bit[13] idx_fifo_0
// Bit[12] idx_fifo_1
// Bit[11] idx_fifo_2
// Bit[10] idx_fifo_3
// Bit[9] idx_fifo_4
// Bit[8] idx_fifo_5
// Bit[7] idx_fifo_6
// Bit[6] idx_fifo_7
// Bit[5:3] idx_fifo_wp
// Bit[2:0] idx_fifo_rp
#define HEVC_IQIDCT_DEBUG_INFO_0                   ((0x3e0f  << 2) + 0xff620000)
// For RTL Simulation Only
#define HEVC_DEBLK_CMD                             ((0x3e10  << 2) + 0xff620000)
// Bit[15+16] ds_mc_valid_2
// Bit[14+16] new_idct1_rd_idx_2
// Bit[13+16] new_idct1_wr_idx_2
// Bit[12+16] idct1_buff0_busy_2
// Bit[11+16] idct1_buff1_busy_2
// Bit[10+16] new_idct1_busy_2
// Bit[9+16] iq_om_8val_2
// Bit[8+16] idct1_pipe_busy_2
// Bit[7+16] wait_mb_left_finish_hold_2
// Bit[6+16] new_idct2_rd_idx_2
// Bit[5+16] new_idct2_wr_idx_2
// Bit[4+16] idct2_buff0_busy_2
// Bit[3+16] idct2_buff1_busy_2
// Bit[2+16] idct2_en_2
// Bit[1+16] new_idct2_busy_2
// Bit[0+16] new_idct1_ready_2
// Bit[15] ds_mc_valid_1
// Bit[14] new_idct1_rd_idx_1
// Bit[13] new_idct1_wr_idx_1
// Bit[12] idct1_buff0_busy_1
// Bit[11] idct1_buff1_busy_1
// Bit[10] new_idct1_busy_1
// Bit[9] iq_om_8val_1
// Bit[8] idct1_pipe_busy_1
// Bit[7] wait_mb_left_finish_hold_1
// Bit[6] new_idct2_rd_idx_1
// Bit[5] new_idct2_wr_idx_1
// Bit[4] idct2_buff0_busy_1
// Bit[3] idct2_buff1_busy_1
// Bit[2] idct2_en_1
// Bit[1] new_idct2_busy_1
// Bit[0] new_idct1_ready_1
#define HEVC_IQIDCT_DEBUG_IDCT                     ((0x3e11  << 2) + 0xff620000)
// bit 31 -- convas_enable
// bit 30:24 -- convas_x_count ( 8 pixels / 64 bits )
// bit 23:16 -- convas_y_count
// bit 15   -- dcac_dma_busy
// bit 14   -- dcac_dma_read_cache_active
// bit 13:8 -- dcac_dma_count
// bit 7    -- dcac_dma_rw
// bit 6    -- dcac_skip_read_mode
// bit 5:0  -- dcac_dma_offset
#define HEVC_DCAC_DMA_CTRL                         ((0x3e12  << 2) + 0xff620000)
// when (convas_enable == 0 )
//   bit 31:0 dcac_dma_addr
// when (convas_enable == 1 )
//   bit 31:25 canvas_addr (7 bits)
//   bit 24:12 convas_y_start ( 13 btis )
//   bit 11:0  convas_x_start ( 12 btis )
#define HEVC_DCAC_DMA_ADDRESS                      ((0x3e13  << 2) + 0xff620000)
// bit 7:0 -- dcac_cpu_addr
#define HEVC_DCAC_CPU_ADDRESS                      ((0x3e14  << 2) + 0xff620000)
// bit 31:0 -- dcac_cpu_data
#define HEVC_DCAC_CPU_DATA                         ((0x3e15  << 2) + 0xff620000)
// bit 31:19 -- reserved
// bit 18:16 -- block_num_reg -- Read-Only
// bit 15:0 -- dcac_mb_count
#define HEVC_DCAC_MB_COUNT                         ((0x3e16  << 2) + 0xff620000)
// bit 31:18 -- reserved
// For H264 :
//   bit 17:2 -- h264_quant
//   bit 11:6 -- h264_quant_c
//   bit  5:0 -- h264_quant_c
// For VC1 :
//   bit    17 -- qindex_GT_8
//   bit    16 -- HalfQPStep
//   bit 15:12 -- eQuantMode
//   bit 11:6  -- AltPQuant
//   bit  5:0  -- PQuant
//
#define HEVC_IQ_QUANT                              ((0x3e17  << 2) + 0xff620000)
// bit 31:24  -- bitplane_width
// bit 23:16  -- bitplane_height
// bit 15:14  -- bitplane_start_x
// bit 13:12  -- bitplane_start_y
// bit 11:4   -- reserved
// bit 3:1    -- bitplane_type
// bit 0      -- bitplane_busy
#define HEVC_VC1_BITPLANE_CTL                      ((0x3e18  << 2) + 0xff620000)
// bit 24:16  -- wq_param1
// bit  8: 0  -- wq_param0
#define HEVC_AVSP_IQ_WQ_PARAM_01                   ((0x3e19  << 2) + 0xff620000)
// bit 24:16  -- wq_param3
// bit  8: 0  -- wq_param2
#define HEVC_AVSP_IQ_WQ_PARAM_23                   ((0x3e1a  << 2) + 0xff620000)
// bit 24:16  -- wq_param5
// bit  8: 0  -- wq_param4
#define HEVC_AVSP_IQ_WQ_PARAM_45                   ((0x3e1b  << 2) + 0xff620000)
// bit    31  -- weight_quant_en
// bit 17:16  -- current_scene_model
// bit 12: 8  -- chroma_qp_delta_cr
// bit  4: 0  -- chroma_qp_delta_cb
#define HEVC_AVSP_IQ_CTL                           ((0x3e1c  << 2) + 0xff620000)
//======================================
//  VCOP Control Register Bits
//
//======================================
    //`define IQIDCT_RESET	    16'h0001	    // Bit 0
//======================================
//  QP Control Register Bits
//
//======================================
// Duplicate Address:  When actually used
// please move to a different address
// `define FLD_DCT_TYPE	    16'h0100	    // Bit 8	0 = Frame DCT; 1 = field DCT
//
// Closing file:  iqidct_regs.h
//
//
// Reading file:  vcpu_regs.h
//
//========================================================================
//  VCPU module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_VCPU_CBUS_BASE = 0x03
// -----------------------------------------------
#define HCODEC_MSP                                 ((0x1300  << 2) + 0xff620000)
#define HCODEC_MPSR                                ((0x1301  << 2) + 0xff620000)
#define HCODEC_MINT_VEC_BASE                       ((0x1302  << 2) + 0xff620000)
#define HCODEC_MCPU_INTR_GRP                       ((0x1303  << 2) + 0xff620000)
#define HCODEC_MCPU_INTR_MSK                       ((0x1304  << 2) + 0xff620000)
#define HCODEC_MCPU_INTR_REQ                       ((0x1305  << 2) + 0xff620000)
#define HCODEC_MPC_P                               ((0x1306  << 2) + 0xff620000)
#define HCODEC_MPC_D                               ((0x1307  << 2) + 0xff620000)
#define HCODEC_MPC_E                               ((0x1308  << 2) + 0xff620000)
#define HCODEC_MPC_W                               ((0x1309  << 2) + 0xff620000)
#define HCODEC_MINDEX0_REG                         ((0x130a  << 2) + 0xff620000)
#define HCODEC_MINDEX1_REG                         ((0x130b  << 2) + 0xff620000)
#define HCODEC_MINDEX2_REG                         ((0x130c  << 2) + 0xff620000)
#define HCODEC_MINDEX3_REG                         ((0x130d  << 2) + 0xff620000)
#define HCODEC_MINDEX4_REG                         ((0x130e  << 2) + 0xff620000)
#define HCODEC_MINDEX5_REG                         ((0x130f  << 2) + 0xff620000)
#define HCODEC_MINDEX6_REG                         ((0x1310  << 2) + 0xff620000)
#define HCODEC_MINDEX7_REG                         ((0x1311  << 2) + 0xff620000)
#define HCODEC_MMIN_REG                            ((0x1312  << 2) + 0xff620000)
#define HCODEC_MMAX_REG                            ((0x1313  << 2) + 0xff620000)
#define HCODEC_MBREAK0_REG                         ((0x1314  << 2) + 0xff620000)
#define HCODEC_MBREAK1_REG                         ((0x1315  << 2) + 0xff620000)
#define HCODEC_MBREAK2_REG                         ((0x1316  << 2) + 0xff620000)
#define HCODEC_MBREAK3_REG                         ((0x1317  << 2) + 0xff620000)
#define HCODEC_MBREAK_TYPE                         ((0x1318  << 2) + 0xff620000)
#define HCODEC_MBREAK_CTRL                         ((0x1319  << 2) + 0xff620000)
#define HCODEC_MBREAK_STAUTS                       ((0x131a  << 2) + 0xff620000)
#define HCODEC_MDB_ADDR_REG                        ((0x131b  << 2) + 0xff620000)
#define HCODEC_MDB_DATA_REG                        ((0x131c  << 2) + 0xff620000)
#define HCODEC_MDB_CTRL                            ((0x131d  << 2) + 0xff620000)
#define HCODEC_MSFTINT0                            ((0x131e  << 2) + 0xff620000)
#define HCODEC_MSFTINT1                            ((0x131f  << 2) + 0xff620000)
#define HCODEC_CSP                                 ((0x1320  << 2) + 0xff620000)
#define HCODEC_CPSR                                ((0x1321  << 2) + 0xff620000)
#define HCODEC_CINT_VEC_BASE                       ((0x1322  << 2) + 0xff620000)
#define HCODEC_CCPU_INTR_GRP                       ((0x1323  << 2) + 0xff620000)
#define HCODEC_CCPU_INTR_MSK                       ((0x1324  << 2) + 0xff620000)
#define HCODEC_CCPU_INTR_REQ                       ((0x1325  << 2) + 0xff620000)
#define HCODEC_CPC_P                               ((0x1326  << 2) + 0xff620000)
#define HCODEC_CPC_D                               ((0x1327  << 2) + 0xff620000)
#define HCODEC_CPC_E                               ((0x1328  << 2) + 0xff620000)
#define HCODEC_CPC_W                               ((0x1329  << 2) + 0xff620000)
#define HCODEC_CINDEX0_REG                         ((0x132a  << 2) + 0xff620000)
#define HCODEC_CINDEX1_REG                         ((0x132b  << 2) + 0xff620000)
#define HCODEC_CINDEX2_REG                         ((0x132c  << 2) + 0xff620000)
#define HCODEC_CINDEX3_REG                         ((0x132d  << 2) + 0xff620000)
#define HCODEC_CINDEX4_REG                         ((0x132e  << 2) + 0xff620000)
#define HCODEC_CINDEX5_REG                         ((0x132f  << 2) + 0xff620000)
#define HCODEC_CINDEX6_REG                         ((0x1330  << 2) + 0xff620000)
#define HCODEC_CINDEX7_REG                         ((0x1331  << 2) + 0xff620000)
#define HCODEC_CMIN_REG                            ((0x1332  << 2) + 0xff620000)
#define HCODEC_CMAX_REG                            ((0x1333  << 2) + 0xff620000)
#define HCODEC_CBREAK0_REG                         ((0x1334  << 2) + 0xff620000)
#define HCODEC_CBREAK1_REG                         ((0x1335  << 2) + 0xff620000)
#define HCODEC_CBREAK2_REG                         ((0x1336  << 2) + 0xff620000)
#define HCODEC_CBREAK3_REG                         ((0x1337  << 2) + 0xff620000)
#define HCODEC_CBREAK_TYPE                         ((0x1338  << 2) + 0xff620000)
#define HCODEC_CBREAK_CTRL                         ((0x1339  << 2) + 0xff620000)
#define HCODEC_CBREAK_STAUTS                       ((0x133a  << 2) + 0xff620000)
#define HCODEC_CDB_ADDR_REG                        ((0x133b  << 2) + 0xff620000)
#define HCODEC_CDB_DATA_REG                        ((0x133c  << 2) + 0xff620000)
#define HCODEC_CDB_CTRL                            ((0x133d  << 2) + 0xff620000)
#define HCODEC_CSFTINT0                            ((0x133e  << 2) + 0xff620000)
#define HCODEC_CSFTINT1                            ((0x133f  << 2) + 0xff620000)
#define HCODEC_IMEM_DMA_CTRL                       ((0x1340  << 2) + 0xff620000)
#define HCODEC_IMEM_DMA_ADR                        ((0x1341  << 2) + 0xff620000)
#define HCODEC_IMEM_DMA_COUNT                      ((0x1342  << 2) + 0xff620000)
// bit[29:24] A_brst_num_imem
// bit[21:16] A_id_imem
// bit[11:0] wrrsp_count_imem (reserved)
#define HCODEC_WRRSP_IMEM                          ((0x1343  << 2) + 0xff620000)
#define HCODEC_LMEM_DMA_CTRL                       ((0x1350  << 2) + 0xff620000)
#define HCODEC_LMEM_DMA_ADR                        ((0x1351  << 2) + 0xff620000)
#define HCODEC_LMEM_DMA_COUNT                      ((0x1352  << 2) + 0xff620000)
// bit[29:24] A_brst_num_lmem
// bit[21:16] A_id_lmem
// bit[11:0] wrrsp_count_lmem
#define HCODEC_WRRSP_LMEM                          ((0x1353  << 2) + 0xff620000)
#define HCODEC_MAC_CTRL1                           ((0x1360  << 2) + 0xff620000)
#define HCODEC_ACC0REG1                            ((0x1361  << 2) + 0xff620000)
#define HCODEC_ACC1REG1                            ((0x1362  << 2) + 0xff620000)
#define HCODEC_MAC_CTRL2                           ((0x1370  << 2) + 0xff620000)
#define HCODEC_ACC0REG2                            ((0x1371  << 2) + 0xff620000)
#define HCODEC_ACC1REG2                            ((0x1372  << 2) + 0xff620000)
#define HCODEC_CPU_TRACE                           ((0x1380  << 2) + 0xff620000)
//
// Closing file:  vcpu_regs.h
//
//
// Reading file:  vcpu_regs.h
//
//========================================================================
//  VCPU module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_VCPU_CBUS_BASE = 0x03
// -----------------------------------------------
#define VDEC2_MSP                                  ((0x2300  << 2) + 0xff620000)
#define VDEC2_MPSR                                 ((0x2301  << 2) + 0xff620000)
#define VDEC2_MINT_VEC_BASE                        ((0x2302  << 2) + 0xff620000)
#define VDEC2_MCPU_INTR_GRP                        ((0x2303  << 2) + 0xff620000)
#define VDEC2_MCPU_INTR_MSK                        ((0x2304  << 2) + 0xff620000)
#define VDEC2_MCPU_INTR_REQ                        ((0x2305  << 2) + 0xff620000)
#define VDEC2_MPC_P                                ((0x2306  << 2) + 0xff620000)
#define VDEC2_MPC_D                                ((0x2307  << 2) + 0xff620000)
#define VDEC2_MPC_E                                ((0x2308  << 2) + 0xff620000)
#define VDEC2_MPC_W                                ((0x2309  << 2) + 0xff620000)
#define VDEC2_MINDEX0_REG                          ((0x230a  << 2) + 0xff620000)
#define VDEC2_MINDEX1_REG                          ((0x230b  << 2) + 0xff620000)
#define VDEC2_MINDEX2_REG                          ((0x230c  << 2) + 0xff620000)
#define VDEC2_MINDEX3_REG                          ((0x230d  << 2) + 0xff620000)
#define VDEC2_MINDEX4_REG                          ((0x230e  << 2) + 0xff620000)
#define VDEC2_MINDEX5_REG                          ((0x230f  << 2) + 0xff620000)
#define VDEC2_MINDEX6_REG                          ((0x2310  << 2) + 0xff620000)
#define VDEC2_MINDEX7_REG                          ((0x2311  << 2) + 0xff620000)
#define VDEC2_MMIN_REG                             ((0x2312  << 2) + 0xff620000)
#define VDEC2_MMAX_REG                             ((0x2313  << 2) + 0xff620000)
#define VDEC2_MBREAK0_REG                          ((0x2314  << 2) + 0xff620000)
#define VDEC2_MBREAK1_REG                          ((0x2315  << 2) + 0xff620000)
#define VDEC2_MBREAK2_REG                          ((0x2316  << 2) + 0xff620000)
#define VDEC2_MBREAK3_REG                          ((0x2317  << 2) + 0xff620000)
#define VDEC2_MBREAK_TYPE                          ((0x2318  << 2) + 0xff620000)
#define VDEC2_MBREAK_CTRL                          ((0x2319  << 2) + 0xff620000)
#define VDEC2_MBREAK_STAUTS                        ((0x231a  << 2) + 0xff620000)
#define VDEC2_MDB_ADDR_REG                         ((0x231b  << 2) + 0xff620000)
#define VDEC2_MDB_DATA_REG                         ((0x231c  << 2) + 0xff620000)
#define VDEC2_MDB_CTRL                             ((0x231d  << 2) + 0xff620000)
#define VDEC2_MSFTINT0                             ((0x231e  << 2) + 0xff620000)
#define VDEC2_MSFTINT1                             ((0x231f  << 2) + 0xff620000)
#define VDEC2_CSP                                  ((0x2320  << 2) + 0xff620000)
#define VDEC2_CPSR                                 ((0x2321  << 2) + 0xff620000)
#define VDEC2_CINT_VEC_BASE                        ((0x2322  << 2) + 0xff620000)
#define VDEC2_CCPU_INTR_GRP                        ((0x2323  << 2) + 0xff620000)
#define VDEC2_CCPU_INTR_MSK                        ((0x2324  << 2) + 0xff620000)
#define VDEC2_CCPU_INTR_REQ                        ((0x2325  << 2) + 0xff620000)
#define VDEC2_CPC_P                                ((0x2326  << 2) + 0xff620000)
#define VDEC2_CPC_D                                ((0x2327  << 2) + 0xff620000)
#define VDEC2_CPC_E                                ((0x2328  << 2) + 0xff620000)
#define VDEC2_CPC_W                                ((0x2329  << 2) + 0xff620000)
#define VDEC2_CINDEX0_REG                          ((0x232a  << 2) + 0xff620000)
#define VDEC2_CINDEX1_REG                          ((0x232b  << 2) + 0xff620000)
#define VDEC2_CINDEX2_REG                          ((0x232c  << 2) + 0xff620000)
#define VDEC2_CINDEX3_REG                          ((0x232d  << 2) + 0xff620000)
#define VDEC2_CINDEX4_REG                          ((0x232e  << 2) + 0xff620000)
#define VDEC2_CINDEX5_REG                          ((0x232f  << 2) + 0xff620000)
#define VDEC2_CINDEX6_REG                          ((0x2330  << 2) + 0xff620000)
#define VDEC2_CINDEX7_REG                          ((0x2331  << 2) + 0xff620000)
#define VDEC2_CMIN_REG                             ((0x2332  << 2) + 0xff620000)
#define VDEC2_CMAX_REG                             ((0x2333  << 2) + 0xff620000)
#define VDEC2_CBREAK0_REG                          ((0x2334  << 2) + 0xff620000)
#define VDEC2_CBREAK1_REG                          ((0x2335  << 2) + 0xff620000)
#define VDEC2_CBREAK2_REG                          ((0x2336  << 2) + 0xff620000)
#define VDEC2_CBREAK3_REG                          ((0x2337  << 2) + 0xff620000)
#define VDEC2_CBREAK_TYPE                          ((0x2338  << 2) + 0xff620000)
#define VDEC2_CBREAK_CTRL                          ((0x2339  << 2) + 0xff620000)
#define VDEC2_CBREAK_STAUTS                        ((0x233a  << 2) + 0xff620000)
#define VDEC2_CDB_ADDR_REG                         ((0x233b  << 2) + 0xff620000)
#define VDEC2_CDB_DATA_REG                         ((0x233c  << 2) + 0xff620000)
#define VDEC2_CDB_CTRL                             ((0x233d  << 2) + 0xff620000)
#define VDEC2_CSFTINT0                             ((0x233e  << 2) + 0xff620000)
#define VDEC2_CSFTINT1                             ((0x233f  << 2) + 0xff620000)
#define VDEC2_IMEM_DMA_CTRL                        ((0x2340  << 2) + 0xff620000)
#define VDEC2_IMEM_DMA_ADR                         ((0x2341  << 2) + 0xff620000)
#define VDEC2_IMEM_DMA_COUNT                       ((0x2342  << 2) + 0xff620000)
// bit[29:24] A_brst_num_imem
// bit[21:16] A_id_imem
// bit[11:0] wrrsp_count_imem (reserved)
#define VDEC2_WRRSP_IMEM                           ((0x2343  << 2) + 0xff620000)
#define VDEC2_LMEM_DMA_CTRL                        ((0x2350  << 2) + 0xff620000)
#define VDEC2_LMEM_DMA_ADR                         ((0x2351  << 2) + 0xff620000)
#define VDEC2_LMEM_DMA_COUNT                       ((0x2352  << 2) + 0xff620000)
// bit[29:24] A_brst_num_lmem
// bit[21:16] A_id_lmem
// bit[11:0] wrrsp_count_lmem
#define VDEC2_WRRSP_LMEM                           ((0x2353  << 2) + 0xff620000)
#define VDEC2_MAC_CTRL1                            ((0x2360  << 2) + 0xff620000)
#define VDEC2_ACC0REG1                             ((0x2361  << 2) + 0xff620000)
#define VDEC2_ACC1REG1                             ((0x2362  << 2) + 0xff620000)
#define VDEC2_MAC_CTRL2                            ((0x2370  << 2) + 0xff620000)
#define VDEC2_ACC0REG2                             ((0x2371  << 2) + 0xff620000)
#define VDEC2_ACC1REG2                             ((0x2372  << 2) + 0xff620000)
#define VDEC2_CPU_TRACE                            ((0x2380  << 2) + 0xff620000)
//
// Closing file:  vcpu_regs.h
//
//
// Reading file:  vcpu_regs.h
//
//========================================================================
//  VCPU module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_VDEC_VCPU_CBUS_BASE = 0x03
// -----------------------------------------------
#define HEVC_MSP                                   ((0x3300  << 2) + 0xff620000)
#define HEVC_MPSR                                  ((0x3301  << 2) + 0xff620000)
#define HEVC_MINT_VEC_BASE                         ((0x3302  << 2) + 0xff620000)
#define HEVC_MCPU_INTR_GRP                         ((0x3303  << 2) + 0xff620000)
#define HEVC_MCPU_INTR_MSK                         ((0x3304  << 2) + 0xff620000)
#define HEVC_MCPU_INTR_REQ                         ((0x3305  << 2) + 0xff620000)
#define HEVC_MPC_P                                 ((0x3306  << 2) + 0xff620000)
#define HEVC_MPC_D                                 ((0x3307  << 2) + 0xff620000)
#define HEVC_MPC_E                                 ((0x3308  << 2) + 0xff620000)
#define HEVC_MPC_W                                 ((0x3309  << 2) + 0xff620000)
#define HEVC_MINDEX0_REG                           ((0x330a  << 2) + 0xff620000)
#define HEVC_MINDEX1_REG                           ((0x330b  << 2) + 0xff620000)
#define HEVC_MINDEX2_REG                           ((0x330c  << 2) + 0xff620000)
#define HEVC_MINDEX3_REG                           ((0x330d  << 2) + 0xff620000)
#define HEVC_MINDEX4_REG                           ((0x330e  << 2) + 0xff620000)
#define HEVC_MINDEX5_REG                           ((0x330f  << 2) + 0xff620000)
#define HEVC_MINDEX6_REG                           ((0x3310  << 2) + 0xff620000)
#define HEVC_MINDEX7_REG                           ((0x3311  << 2) + 0xff620000)
#define HEVC_MMIN_REG                              ((0x3312  << 2) + 0xff620000)
#define HEVC_MMAX_REG                              ((0x3313  << 2) + 0xff620000)
#define HEVC_MBREAK0_REG                           ((0x3314  << 2) + 0xff620000)
#define HEVC_MBREAK1_REG                           ((0x3315  << 2) + 0xff620000)
#define HEVC_MBREAK2_REG                           ((0x3316  << 2) + 0xff620000)
#define HEVC_MBREAK3_REG                           ((0x3317  << 2) + 0xff620000)
#define HEVC_MBREAK_TYPE                           ((0x3318  << 2) + 0xff620000)
#define HEVC_MBREAK_CTRL                           ((0x3319  << 2) + 0xff620000)
#define HEVC_MBREAK_STAUTS                         ((0x331a  << 2) + 0xff620000)
#define HEVC_MDB_ADDR_REG                          ((0x331b  << 2) + 0xff620000)
#define HEVC_MDB_DATA_REG                          ((0x331c  << 2) + 0xff620000)
#define HEVC_MDB_CTRL                              ((0x331d  << 2) + 0xff620000)
#define HEVC_MSFTINT0                              ((0x331e  << 2) + 0xff620000)
#define HEVC_MSFTINT1                              ((0x331f  << 2) + 0xff620000)
#define HEVC_CSP                                   ((0x3320  << 2) + 0xff620000)
#define HEVC_CPSR                                  ((0x3321  << 2) + 0xff620000)
#define HEVC_CINT_VEC_BASE                         ((0x3322  << 2) + 0xff620000)
#define HEVC_CCPU_INTR_GRP                         ((0x3323  << 2) + 0xff620000)
#define HEVC_CCPU_INTR_MSK                         ((0x3324  << 2) + 0xff620000)
#define HEVC_CCPU_INTR_REQ                         ((0x3325  << 2) + 0xff620000)
#define HEVC_CPC_P                                 ((0x3326  << 2) + 0xff620000)
#define HEVC_CPC_D                                 ((0x3327  << 2) + 0xff620000)
#define HEVC_CPC_E                                 ((0x3328  << 2) + 0xff620000)
#define HEVC_CPC_W                                 ((0x3329  << 2) + 0xff620000)
#define HEVC_CINDEX0_REG                           ((0x332a  << 2) + 0xff620000)
#define HEVC_CINDEX1_REG                           ((0x332b  << 2) + 0xff620000)
#define HEVC_CINDEX2_REG                           ((0x332c  << 2) + 0xff620000)
#define HEVC_CINDEX3_REG                           ((0x332d  << 2) + 0xff620000)
#define HEVC_CINDEX4_REG                           ((0x332e  << 2) + 0xff620000)
#define HEVC_CINDEX5_REG                           ((0x332f  << 2) + 0xff620000)
#define HEVC_CINDEX6_REG                           ((0x3330  << 2) + 0xff620000)
#define HEVC_CINDEX7_REG                           ((0x3331  << 2) + 0xff620000)
#define HEVC_CMIN_REG                              ((0x3332  << 2) + 0xff620000)
#define HEVC_CMAX_REG                              ((0x3333  << 2) + 0xff620000)
#define HEVC_CBREAK0_REG                           ((0x3334  << 2) + 0xff620000)
#define HEVC_CBREAK1_REG                           ((0x3335  << 2) + 0xff620000)
#define HEVC_CBREAK2_REG                           ((0x3336  << 2) + 0xff620000)
#define HEVC_CBREAK3_REG                           ((0x3337  << 2) + 0xff620000)
#define HEVC_CBREAK_TYPE                           ((0x3338  << 2) + 0xff620000)
#define HEVC_CBREAK_CTRL                           ((0x3339  << 2) + 0xff620000)
#define HEVC_CBREAK_STAUTS                         ((0x333a  << 2) + 0xff620000)
#define HEVC_CDB_ADDR_REG                          ((0x333b  << 2) + 0xff620000)
#define HEVC_CDB_DATA_REG                          ((0x333c  << 2) + 0xff620000)
#define HEVC_CDB_CTRL                              ((0x333d  << 2) + 0xff620000)
#define HEVC_CSFTINT0                              ((0x333e  << 2) + 0xff620000)
#define HEVC_CSFTINT1                              ((0x333f  << 2) + 0xff620000)
#define HEVC_IMEM_DMA_CTRL                         ((0x3340  << 2) + 0xff620000)
#define HEVC_IMEM_DMA_ADR                          ((0x3341  << 2) + 0xff620000)
#define HEVC_IMEM_DMA_COUNT                        ((0x3342  << 2) + 0xff620000)
// bit[29:24] A_brst_num_imem
// bit[21:16] A_id_imem
// bit[11:0] wrrsp_count_imem (reserved)
#define HEVC_WRRSP_IMEM                            ((0x3343  << 2) + 0xff620000)
#define HEVC_LMEM_DMA_CTRL                         ((0x3350  << 2) + 0xff620000)
#define HEVC_LMEM_DMA_ADR                          ((0x3351  << 2) + 0xff620000)
#define HEVC_LMEM_DMA_COUNT                        ((0x3352  << 2) + 0xff620000)
// bit[29:24] A_brst_num_lmem
// bit[21:16] A_id_lmem
// bit[11:0] wrrsp_count_lmem
#define HEVC_WRRSP_LMEM                            ((0x3353  << 2) + 0xff620000)
#define HEVC_MAC_CTRL1                             ((0x3360  << 2) + 0xff620000)
#define HEVC_ACC0REG1                              ((0x3361  << 2) + 0xff620000)
#define HEVC_ACC1REG1                              ((0x3362  << 2) + 0xff620000)
#define HEVC_MAC_CTRL2                             ((0x3370  << 2) + 0xff620000)
#define HEVC_ACC0REG2                              ((0x3371  << 2) + 0xff620000)
#define HEVC_ACC1REG2                              ((0x3372  << 2) + 0xff620000)
#define HEVC_CPU_TRACE                             ((0x3380  << 2) + 0xff620000)
//
// Closing file:  vcpu_regs.h
//
//
// Reading file:  henc_regs.h
//
//========================================================================
//  MDEC module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_HCODEC_HENC_CBUS_BASE = 0x0a
// -----------------------------------------------
#define HCODEC_HENC_SCRATCH_0                      ((0x1ac0  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_1                      ((0x1ac1  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_2                      ((0x1ac2  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_3                      ((0x1ac3  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_4                      ((0x1ac4  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_5                      ((0x1ac5  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_6                      ((0x1ac6  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_7                      ((0x1ac7  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_8                      ((0x1ac8  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_9                      ((0x1ac9  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_A                      ((0x1aca  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_B                      ((0x1acb  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_C                      ((0x1acc  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_D                      ((0x1acd  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_E                      ((0x1ace  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_F                      ((0x1acf  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_G                      ((0x1ad0  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_H                      ((0x1ad1  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_I                      ((0x1ad2  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_J                      ((0x1ad3  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_K                      ((0x1ad4  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_L                      ((0x1ad5  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_M                      ((0x1ad6  << 2) + 0xff620000)
#define HCODEC_HENC_SCRATCH_N                      ((0x1ad7  << 2) + 0xff620000)
// bit [7:0] data_feed_buff_id
#define HCODEC_IE_DATA_FEED_BUFF_INFO              ((0x1ad8  << 2) + 0xff620000)
//
// Closing file:  henc_regs.h
//
//
// Reading file:  vlc_regs.h
//
//========================================================================
//  VLC module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_HCODEC_VLC_CBUS_BASE = 0x0d
// -----------------------------------------------
// Bit[31:28] - henc_status
// Bit[27:8] - reserved
// Bit[7]    mc_hcmd_buff_enable
// Bit[6]    mc_hcmd_use_mc_hcmd_buff
// Bit[5]    mc_hcmd_use_mc_hcmd_hw_start
// Bit[4]    no_mc_out_null_non_skipped_mb
// Bit[3]    mc_out_even_skipped_mb
// Bit[2] - hcmd_enable
// Bit[1] - vlc_control_enable (0 will treat as soft_reset)
// Bit[0] - vlc_input_enable (enable input interface)
#define HCODEC_VLC_STATUS_CTRL                     ((0x1d00  << 2) + 0xff620000)
// Bit [31]  - small_luma_ignore_chroma
// Bit[30:16] - Reserved
// Bit [15]  - enable_free_clk_mc_hcmd_buff
// Bit [14]  - enable_free_clk_reg
// Bit [13]  - enable_free_clk_stream
// Bit [12]  - enable_free_clk_pre_buff
// Bit [11]  - enable_free_clk_vb_buff
// Bit [10]  - enable_free_clk_dc_input
// Bit [9]   - enable_free_clk_input
// Bit [8]   - enable_free_clk_mv_cal
// Bit [7]   - enable_free_clk_status
// Bit [6]   - enable_free_clk_mc_dblk_cmd_if
// Bit [5]   - disable_mvd_enc_finished
// Bit [4]   - I16MB_share_ipred_mode_with_I4MB
// Bit [3]   - fixed_picture_qp
// Bit [2]   - use_set_b8_mode ( not used now)
// Bit [1]   - use_set_mb_skip_run
// Bit [0]   - pop_coeff_even_all_zero
#define HCODEC_VLC_CONFIG                          ((0x1d01  << 2) + 0xff620000)
// --------------------------------------------
// Bitstream DDR Interface
// --------------------------------------------
#define HCODEC_VLC_VB_START_PTR                    ((0x1d10  << 2) + 0xff620000)
#define HCODEC_VLC_VB_END_PTR                      ((0x1d11  << 2) + 0xff620000)
#define HCODEC_VLC_VB_WR_PTR                       ((0x1d12  << 2) + 0xff620000)
// Read Only, VLC_VB_SW_RD_PTR or VLC_VB_HW_RD_PTR
#define HCODEC_VLC_VB_RD_PTR                       ((0x1d13  << 2) + 0xff620000)
#define HCODEC_VLC_VB_SW_RD_PTR                    ((0x1d14  << 2) + 0xff620000)
// Read Only
#define HCODEC_VLC_VB_LEFT                         ((0x1d15  << 2) + 0xff620000)
// VB FIFO Control
// bit  [31:24] vb_full_int_enable_cpu[7:0]
// bit  [23:16] vb_full_int_enable_amrisc[7:0]
//   -bit 23 Video BUFFER LEFT < 0x400 Bytes
//   -bit 22 Video BUFFER LEFT < 0x200 Bytes
//   -bit 21 Video BUFFER LEFT < 0x100 Bytes
//   -bit 20 Video BUFFER LEFT < 0x80 Bytes
//   -bit 19 Video BUFFER LEFT < 0x40 Bytes
//   -bit 18 Video BUFFER LEFT < 0x20 Bytes
//   -bit 17 vbfifo left  < 16 double words (8x64bits)
//   -bit 16 vbfifo left  < 8 double words (4x64bits)
// bit  [15]    wr_ptr_int_enable_cpu
// bit  [14]    wr_ptr_int_enable_amrisc
// bit  [13]    wr_ptr_int (Read Only, write 1 will clear)
// bit  [12]    vb_full_int_enable_cpu(Read Only)
// bit  [11]    vb_full_int_enable_amrisc(Read Only)
// bit  [10]    reserved
// bit  [9]     use_vb_hw_rd_ptr
// bit  [8]     vb_always_ready Set to 1 to ignore vb_level blocking DDR write
// bit  [7]     vb_ready_for_transfer (Read Only)
// bit  [6]     data_ready_for_transfer (Read Only)
// bits [5:3]   vb_endian       Set VB Endian inside DDR memory
// bit  [2]     vb_write_busy   Read Only - indicate DDR write busy
// bit  [1]     vb_write_en     Set to 1 to enable writing data to DDR memory
// bit  [0]     vb_soft_reset   Soft reset
#define HCODEC_VLC_VB_CONTROL                      ((0x1d16  << 2) + 0xff620000)
// bit 31    transfer_length 0 - 32x64 Bits per request, 1 - 16x64 Bits per request  // default : 0
// bit 30    A_urgent  // default : 0
// bit 29:24 A_brst_num // default : 0x3f
// bit 23:22 reserved
// bit 21:16 A_id  // default : 0x20
// bit 15:0  vb_left_hold // default : 0
#define HCODEC_VLC_VB_MEM_CTL                      ((0x1d17  << 2) + 0xff620000)
// vb_wr_ptr address to generate interrupt
#define HCODEC_VLC_VB_INT_PTR                      ((0x1d18  << 2) + 0xff620000)
// bit[31:12] reserved
// bit[11:0] vlc_wrrsp_count
#define HCODEC_VLC_WRRSP                           ((0x1d19  << 2) + 0xff620000)
#define HCODEC_VLC_TOTAL_BYTES                     ((0x1d1a  << 2) + 0xff620000)
// bit  [31:26] reserved
// bit  [25]    vb_flush
// bit  [24]    vb_reg_ready
// bit  [23:16] vb_buff_left     -- Read only
// bit  [15:8]  vb_buff_wr_point -- RW
// bit  [7:0]   vb_buff_rd_point -- RW
#define HCODEC_VLC_VB_BUFF                         ((0x1d1b  << 2) + 0xff620000)
// bit[31]    flush_vlc_pre_buff
// bit[30:27] reserved
// bit[26:24] vb_pre_buff_level
// bit[23:0]  vb_pre_buff_data[55:32]
#define HCODEC_VLC_VB_PRE_BUFF_HI                  ((0x1d1c  << 2) + 0xff620000)
// bit[31:0] vb_pre_buff_data[31:0]
#define HCODEC_VLC_VB_PRE_BUFF_LOW                 ((0x1d1d  << 2) + 0xff620000)
// bit[31]    stream_encap_enable  // 0x0000(00-03) will be changed to 0x000003(00-03) if enabled
// bit[30:29] stream_encap_delay   // delay bytes for encap used
// bit[28:24] stream_buff_point
// bit[23:0]  stream_buff_data
#define HCODEC_VLC_STREAM_BUFF                     ((0x1d1e  << 2) + 0xff620000)
// bit[31]    push_stream_block - Read Only (Will set if vb_buff full)
// bit[30]    push_stream_busy  - Read Only (busy when output one byte from stream_buf (max 2 clocks for 8 bits push)
// bit[29:28] stream_encap_status - Read Only
// bit[27:21] reserved
// Long Mode : (Amrisc need movilo and mvihi high to set stream_info)
//   bit[20:16] push_stream_long_length (0 or 31 : Mid or Short mode)
//   bit[15:0]  push_stream_data
// Mid Mode : (Amrisc need movi to set stream_info)
//   bit[15:12]] push_stream_mid_length (1-12 : mid mode active, 0-short mode, 15 - byte align)
//   bit[11:0]  push_stream_data
// Short Mode : (Amrisc can use mtspi to push stream directly)
//   bit[7:5] push_stream_short_length (0-5 : short length, else - invalid)
//   bit[4:0]  push_stream_data
#define HCODEC_VLC_PUSH_STREAM                     ((0x1d1f  << 2) + 0xff620000)
// bit[15:8] ELEMENT_LENGTH
// bit[7:1]  reserved
// bit[0]  Write - push start, Read - Push Busy
#define HCODEC_VLC_PUSH_ELEMENT                    ((0x1d20  << 2) + 0xff620000)
#define HCODEC_VLC_ELEMENT_DATA                    ((0x1d21  << 2) + 0xff620000)
// bit[7] hcmd_intra_use_sw_info
// bit[6] hcmd_use_sw_info
// bit[5] always_use_info_0_cbp_blk
// bit[4] always_update_info_0_cbp_blk
// bit[3] reset_left_mb_wr
// bit[2] reset_top_mb_wr
// bit[1] set_left_mb_wr
// bit[0] set_top_mb_wr
#define HCODEC_VLC_SPECIAL_CTL                     ((0x1d22  << 2) + 0xff620000)
// bit[28]    left_intra
// bit[27:22] left_quant
// bit[21:16] left_quant_c
// bit[12]    top_intra
// bit[11:6]  top_quant
// bit[5:0]   top_quant_c
#define HCODEC_VLC_HCMD_T_L_INFO                   ((0x1d23  << 2) + 0xff620000)
// bit[12]    cur_intra
// bit[11:6]  cur_quant
// bit[5:0]   cur_quant_c
#define HCODEC_VLC_HCMD_CUR_INFO                   ((0x1d24  << 2) + 0xff620000)
// bit[13]    top_left_info_in_data_mv_cal
// bit[12]    only_use_info_0_top_left_in_I
// bit[11]    top_left_info_in_data
// bit[10]    early_mix_mc_hcmd
// bit[9]     update_top_left_mix
// bit[8]     p_top_left_mix
// bit[7]     mv_cal_mixed_type
// bit[6]     mc_hcmd_mixed_type
// bit[5]     use_separate_int_control
// bit[4]     hcmd_intra_use_q_info
// bit[3]     hcmd_left_use_prev_info
// bit[2]     hcmd_use_q_info
// bit[1]     use_q_delta_quant
// bit[0]     detect_I16_from_I4
#define HCODEC_VLC_ADV_CONFIG                      ((0x1d25  << 2) + 0xff620000)
//   31 - use_hcmd_mb_xy_auto
//23:16 - hcmd_max_mb_x
//15:8  - hcmd_mb_y_auto
// 7:0  - hcmd_mb_x_auto
#define HCODEC_VLC_HCMD_MBXY_AUTO                  ((0x1d26  << 2) + 0xff620000)
// bit[31:0] vlc_int_control_inter -- will be used when use_separate_int_control is set
#define HCODEC_VLC_INT_CONTROL_INTER               ((0x1d2f  << 2) + 0xff620000)
// --------------------------------------------
// Picture VLC
// --------------------------------------------
// (&(int|(~AND_enable))|(|(int&OR_enable)))
// bit[31]    OR interrupt Enable Reserved
// bit[30]    OR interrupt Enable for mv_busy
// bit[29]    OR interrupt Enable for b8_mode_busy
// bit[28]    OR interrupt Enable for mb_skip_run_busy
// bit[27]    OR interrupt Enable for cbp_busy
// bit[26]    OR interrupt Enable for Reserved
// bit[25]    OR interrupt Enable for Reserved
// bit[24]    OR interrupt Enable for mb_info_busy
// bit[23]    AND interrupt Enable Reserved
// bit[22]    AND interrupt Enable for mv_busy
// bit[21]    AND interrupt Enable for b8_mode_busy
// bit[20]    AND interrupt Enable for mb_skip_run_busy
// bit[19]    AND interrupt Enable for cbp_busy
// bit[18]    AND interrupt Enable for Reserved
// bit[17]    AND interrupt Enable for Reserved
// bit[16]    AND interrupt Enable for mb_info_busy
// bit[15]    OR interrupt Enable Reserved
// bit[14]    OR interrupt Enable for mvd
// bit[13]    OR interrupt Enable for b8_mode
// bit[12]    OR interrupt Enable for mb_skip_run
// bit[11]    OR interrupt Enable for cbp_ready
// bit[10]    OR interrupt Enable for c_ipred_mode_ready
// bit[9]     OR interrupt Enable for ipred_mode_ready
// bit[8]     OR interrupt Enable for mb_info_ready
// bit[7]     AND interrupt Enable Reserved
// bit[6]     AND interrupt Enable for mvd
// bit[5]     AND interrupt Enable for b8_mode
// bit[4]     AND interrupt Enable for mb_skip_run
// bit[3]     AND interrupt Enable for cbp_ready
// bit[2]     AND interrupt Enable for c_ipred_mode_ready
// bit[1]     AND interrupt Enable for ipred_mode_ready
// bit[0]     AND interrupt Enable for mb_info_ready
#define HCODEC_VLC_INT_CONTROL                     ((0x1d30  << 2) + 0xff620000)
// Bit[31:16] picture_height
// Bit[15:0]  picture_width
#define HCODEC_VLC_PIC_SIZE                        ((0x1d31  << 2) + 0xff620000)
// [31:16] Reserved
// [15:3] pic_width_in_mbs_minus1
// [2:0]  picture_type
#define HCODEC_VLC_PIC_INFO                        ((0x1d32  << 2) + 0xff620000)
// Bit[31:16] MB_NR
// Bit[15:8] MBY
// Bit[7:0] MBX
#define HCODEC_VLC_PIC_POSITION                    ((0x1d33  << 2) + 0xff620000)
// Bit[31] MV_busy
// Bit[30:6] Reserved
// Bit[15] Reserved
// Bit[14] vlc_input_MV_busy
// Bit[13] vlc_input_b8_mode_busy
// Bit[12] vlc_input_mb_skip_run_busy
// Bit[11] vlc_input_cbp_busy
// Bit[10] Reserved
// Bit[9]  Reserved
// Bit[8] vlc_input_mb_info_busy
// Bit[7] Reserved
// Bit[6] mvd
// Bit[5] b8_mode
// Bit[4] mb_skip_run
// Bit[3] cbp
// Bit[2] c_ipred_mode
// Bit[1] ipred_mode
// Bit[0] mb_info ( mb_type, mb_x, mb_y)
#define HCODEC_VLC_INPUT_STATUS                    ((0x1d34  << 2) + 0xff620000)
// Bit[31:28] detected_mb_type
// Bit[27:16] mb_y
// Bit[15:4]  mb_x
// Bit[3:0]   mb_type
#define HCODEC_VLC_MB_INFO                         ((0x1d35  << 2) + 0xff620000)
// command 0 -- no pending
// normal command + 1 is pending command
//
// bit 31:28 -- pending command 7
// bit 27:24 -- pending command 6
// bit 23:20 -- pending command 5
// bit 19:16 -- pending command 4
// bit 15:12 -- pending command 3
// bit 11:8  -- pending command 2
// bit  7:4  -- pending command 1
// bit  3:0  -- pending command 0
#define HCODEC_VLC_ENC_PEND_CMD                    ((0x1d36  << 2) + 0xff620000)
// For I Slice
// Bit[31:16] Reserved
// Bit[15:0] IntraType
#define HCODEC_HENC_TOP_INFO_0                     ((0x1d37  << 2) + 0xff620000)
#define HCODEC_HENC_LEFT_INFO_0                    ((0x1d38  << 2) + 0xff620000)
// For I Slice
// Bit[31:24] V_nnz
// Bit[23:16] U_nnz
// Bit[15:0]  Y_nnz
#define HCODEC_HENC_TOP_INFO_1                     ((0x1d39  << 2) + 0xff620000)
#define HCODEC_HENC_LEFT_INFO_1                    ((0x1d3a  << 2) + 0xff620000)
// bit[63:0] ipred_mode
#define HCODEC_VLC_IPRED_MODE_HI                   ((0x1d3b  << 2) + 0xff620000)
#define HCODEC_VLC_IPRED_MODE_LO                   ((0x1d3c  << 2) + 0xff620000)
// bit[15:8] SE delta quant
// bit[7:0]  UE delta quant
#define HCODEC_VLC_DELTA_QP                        ((0x1d3d  << 2) + 0xff620000)
// bit[31:16] Reserved
// bit[15:12] Reserved
// bit[11:8] c_ipred_mode
// bit[7:0] cbp
#define HCODEC_VLC_MB_HEADER_INFO                  ((0x1d3e  << 2) + 0xff620000)
// bit[31:16] mb_skip_run
// bit[15:0]  b8_mode
#define HCODEC_VLC_P_MB_HEADER_INFO                ((0x1d3f  << 2) + 0xff620000)
// bit[31]    write_ptr_update
// bit[30]    read_ptr_update
// bit[29:20] coeff_buf_level
// bit[19:10] coeff_buf_write_ptr
// bit[9:0]   coeff_buf_read_ptr
#define HCODEC_VLC_COEFF_BUF_STATUS                ((0x1d40  << 2) + 0xff620000)
// bit[31:10] Reserved
// bit[9:0] read_req_addr
#define HCODEC_VLC_COEFF_RD_REQ                    ((0x1d41  << 2) + 0xff620000)
// bit[20]   - coeff_buf_read_finished
// bit[19]   - coeff_first
// bit[18:4] - coeff_level
// bit[3:0]  - coeff_run
#define HCODEC_VLC_COEFF                           ((0x1d42  << 2) + 0xff620000)
// bit[31]    - coeff_info_ready
// bit[30:25] - Reserved
// bit[24:15] - block_begin_addr
// bit[14:11] - trailing_one_sign
// bit[10:6]  - total_coeff
// bit[5:4]   - trailing_ones
// bit[3:0]   - total_zeros
#define HCODEC_VLC_COEFF_INFO                      ((0x1d43  << 2) + 0xff620000)
// bit[31]    write_ptr_update
// bit[30]    read_ptr_update
// bit[29:25] Reserved
// bit[24:20] dc_buf_level -- 0-16
// bit[19:15] Reserved
// bit[14:10] dc_buf_write_ptr
// bit[9:5]   Reserved
// bit[4:0]   dc_buf_read_ptr
#define HCODEC_VLC_DC_BUF_STATUS                   ((0x1d44  << 2) + 0xff620000)
// bit[31:10] Reserved
// bit[9:4]   Reserved
// bit[3:0]   read_req_addr
#define HCODEC_VLC_DC_RD_REQ                       ((0x1d45  << 2) + 0xff620000)
// bit[31:17] - Reserved
// bit[16]   - dc_first
// bit[15:1] - dc_level
// bit[0]    - dc_type  0 - CDC, 1 - LDC
#define HCODEC_VLC_DC                              ((0x1d46  << 2) + 0xff620000)
// bit[31]    - dc_info_ready
// bit[30:25] - Reserved
// bit[24:20] - Reserved
// bit[19:15] - dc_idx_begin_addr
// bit[14:11] - dc_trailing_one_sign
// bit[10:6]  - dc_total_coeff
// bit[5:4]   - dc_trailing_ones
// bit[3:0]   - dc_total_zeros
#define HCODEC_VLC_DC_INFO                         ((0x1d47  << 2) + 0xff620000)
// bit[31:4]  - Reserved
// bit[3:0]   - mv_rw_idx  (auto increment when read/write VLC_MV)
#define HCODEC_VLC_MV_INDEX                        ((0x1d48  << 2) + 0xff620000)
// bit[31:16] - MVY
// bit[15:0]  - MVX
#define HCODEC_VLC_MV                              ((0x1d49  << 2) + 0xff620000)
// bit[31:16] - MVY
// bitp15:0]  - MVX
// Write to HENC_TOP_MV_0 will cause previous U->UL, UR->U, and UR write
// Read will read U MV only
#define HCODEC_HENC_TOP_MV_0                       ((0x1d4a  << 2) + 0xff620000)
#define HCODEC_HENC_TOP_MV_1                       ((0x1d4b  << 2) + 0xff620000)
#define HCODEC_HENC_TOP_MV_2                       ((0x1d4c  << 2) + 0xff620000)
#define HCODEC_HENC_TOP_MV_3                       ((0x1d4d  << 2) + 0xff620000)
#define HCODEC_HENC_LEFT_MV_0                      ((0x1d4e  << 2) + 0xff620000)
#define HCODEC_HENC_LEFT_MV_1                      ((0x1d4f  << 2) + 0xff620000)
#define HCODEC_HENC_LEFT_MV_2                      ((0x1d50  << 2) + 0xff620000)
#define HCODEC_HENC_LEFT_MV_3                      ((0x1d51  << 2) + 0xff620000)
// Bit[31:1] Reserved
// Bit[0] top_left_mv_ready
#define HCODEC_TOP_LEFT_READY                      ((0x1d52  << 2) + 0xff620000)
// Bit[31:16] Reserved
// Bit[15:0] mb_skip_run
#define HCODEC_MB_SKIP_RUN                         ((0x1d53  << 2) + 0xff620000)
// Bit[31:16] Reserved
// Bit[15]    Reserved
// Bit[14:13] rd_struct // 00 - frame, 10 - top field, 11 - bottom field
// Bit[12:11] wr_struct // 00 - frame, 10 - top field, 11 - bottom field
// Bit[10:5]  mv_buff_id
// Bit[4:0]   mv_ref
#define HCODEC_VLC_HCMD_CONFIG                     ((0x1d54  << 2) + 0xff620000)
// Bit[9:0] h264_dblk_info
#define HCODEC_VLC_HCMD_DBLK_INFO                  ((0x1d55  << 2) + 0xff620000)
// Bit[3:0] vlc_dbg_idx
#define HCODEC_VLC_DBG_IDX                         ((0x1d56  << 2) + 0xff620000)
// Read Only
#define HCODEC_VLC_DBG_READ                        ((0x1d57  << 2) + 0xff620000)
// [   29] RW jpeg_comp2_ac_table_sel.                                                      Default 0.
// [   28] RW jpeg_comp2_dc_table_sel.                                                      Default 0.
// [26:25] RW jpeg_comp2_cnt_max.                                                           Default 0.
// [   24] RW jpeg_comp2_en. Set 1 if the scan will include component 2 (Cr).               Default 0.
// [   21] RW jpeg_comp1_ac_table_sel.                                                      Default 0.
// [   20] RW jpeg_comp1_dc_table_sel.                                                      Default 0.
// [18:17] RW jpeg_comp1_cnt_max.                                                           Default 0.
// [   16] RW jpeg_comp1_en. Set 1 if the scan will include component 1 (Cb).               Default 0.
// [   13] RW jpeg_comp0_ac_table_sel.                                                      Default 0.
// [   12] RW jpeg_comp0_dc_table_sel.                                                      Default 0.
// [10: 9] RW jpeg_comp0_cnt_max.                                                           Default 0.
// [    8] RW jpeg_comp0_en. Set 1 if the scan will include component 0 (Y).                Default 0.
// [    1] W  jpeg_coeff_init. Write 1 to this bit to initialize JPEG run length encoder.
// [    0] RW jpeg_en. 0=Disable JPEG encoder; 1=Enable JPEG encoder.                       Default 0.
#define HCODEC_VLC_JPEG_CTRL                       ((0x1d58  << 2) + 0xff620000)
// [   13] RW jpeg_coeff_buf_overfl. Write this bit to 1 to clear overfl.
// [   12] RW jpeg_coeff_buf_undrfl. Write this bit to 1 to clear undrfl.
// [   11] R  jpeg_coeff_buf_full.
// [   10] R  jpeg_coeff_buf_empty.
// [ 8: 0] R  jpeg_coeff_buf_level.
#define HCODEC_VLC_JPEG_COEFF_BUF_STAT             ((0x1d59  << 2) + 0xff620000)
// [   16] RW JPEG HUFFMAN table access mode. 0=Write; 1=Read.  Default 1.
// [ 8: 0] RW JPEG HUFFMAN table addr.                          Default 0.
#define HCODEC_VLC_HUFFMAN_ADDR                    ((0x1d5a  << 2) + 0xff620000)
// [19: 0] RW JPEG HUFFMAN table data.
#define HCODEC_VLC_HUFFMAN_DATA                    ((0x1d5b  << 2) + 0xff620000)
// bit[31:0] enc_mv_bits - including b8_mode and mvd
#define HCODEC_VLC_ENC_MV_BITS                     ((0x1d5c  << 2) + 0xff620000)
// bit[31:0] enc_coeff_bits - including cbp, token, trailing_sign, coeff_enc, h264_totzeros, h264_run
#define HCODEC_VLC_ENC_COEFF_BITS                  ((0x1d5d  << 2) + 0xff620000)
//
// Closing file:  vlc_regs.h
//
//
// Reading file:  qdct_regs.h
//
//========================================================================
//  QDCT module level register offset
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DOS_HCODEC_QDCT_CBUS_BASE = 0x0f
// -----------------------------------------------
// bit[31:28] - mb_info_state
#define HCODEC_QDCT_STATUS_CTRL                    ((0x1f00  << 2) + 0xff620000)
// bit[18]    - enable_free_clk_sad_top
// bit[17]    - enable_free_clk_ie_top
// bit[16]    - enable_free_clk_ie_sub
// bit[15]    - enable_free_clk_mc_out
// bit[14]    - enable_free_clk_i_pred_top
// bit[13]    - enable_free_clk_idct_top
// bit[12]    - enable_free_clk_iq_top
// bit[11]    - enable_free_clk_q_top
// bit[10]    - enable_free_clk_dc_buff_8
// bit[9]     - enable_free_clk_dct_top
// bit[8]     - enable_free_clk_mb_info
// bit[7]     - enable_free_clk_mb_buff
// bit[6]     - enable_free_clk_reg
// bit[5]     - ignore_1_include_2nd_half_c
// bit[4]     - ignore_1_include_2nd_half
// bit[3]     - ignore_t_p8x8
// bit[2]     - not_ignore_dc
// bit[1]     - ignore_small_lac_intra
// bit[0]     - disable_fast_zero_block
#define HCODEC_QDCT_CONFIG                         ((0x1f01  << 2) + 0xff620000)
// bit[31]    - ignore_lac_coeff_en
// bit[30:26] - ignore_lac_coeff_else
// bit[25:21] - ignore_lac_coeff_2
// bit[20:16] - ignore_lac_coeff_1
// bit[15]    - ignore_cac_coeff_en
// bit[14:10] - ignore_cac_coeff_else
// bit[9:5]   - ignore_cac_coeff_2
// bit[4:0]   - ignore_cac_coeff_1
#define HCODEC_IGNORE_CONFIG                       ((0x1f02  << 2) + 0xff620000)
// bit[31]    - ignore_t_lac_coeff_en
// bit[30:26] - ignore_t_lac_coeff_else
// bit[25:21] - ignore_t_lac_coeff_2
// bit[20:16] - ignore_t_lac_coeff_1
// bit[15]    - ignore_cdc_coeff_en
// bit[14]    - ignore_t_lac_coeff_else_le_3
// bit[13]    - ignore_t_lac_coeff_else_le_4
// bit[12]    - ignore_cdc_only_when_empty_cac_inter
// bit[11]    - ignore_cdc_only_when_one_empty_inter
// bit[10:9]  - ignore_cdc_range_max_inter // 0-0, 1-1, 2,-2, 3-3
// bit[8:7]   - ignore_cdc_abs_max_inter // 0-1, 1-2, 2,-3, 3-4
// bit[6]     - reserved
// bit[5]     - ignore_cdc_only_when_empty_cac_intra
// bit[4]     - ignore_cdc_only_when_one_empty_intra
// bit[3:2]   - ignore_cdc_range_max_intra // 0-0, 1-1, 2,-2, 3-3
// bit[1:0]   - ignore_cdc_abs_max_intra // 0-1, 1-2, 2,-3, 3-4
#define HCODEC_IGNORE_CONFIG_2                     ((0x1f03  << 2) + 0xff620000)
// --------------------------------------------
// MB DATA DDR Interface
// --------------------------------------------
#define HCODEC_QDCT_MB_START_PTR                   ((0x1f10  << 2) + 0xff620000)
#define HCODEC_QDCT_MB_END_PTR                     ((0x1f11  << 2) + 0xff620000)
#define HCODEC_QDCT_MB_WR_PTR                      ((0x1f12  << 2) + 0xff620000)
#define HCODEC_QDCT_MB_RD_PTR                      ((0x1f13  << 2) + 0xff620000)
#define HCODEC_QDCT_MB_LEVEL                       ((0x1f14  << 2) + 0xff620000)
// bit  [31]    disable_mbxy_ie_save
// bit  [30]    no_wait_after_q_cdc
// bit  [29]    ie_start_int_enable
// bit  [28]    ignore_t_p8x8
// bit  [27]    zero_mc_out_null_non_skipped_mb
// bit  [26]    no_mc_out_null_non_skipped_mb
// bit  [25]    mc_out_even_skipped_mb
// bit  [24]    mc_out_wait_cbp_ready
// bit  [23]    mc_out_wait_mb_type_ready
// bit  [22]    i_pred_int_enable
// bit  [21]    intra_sat8_enable
// bit  [20]    ie_sub_enable
// bit  [19]    i_pred_enable
// bit  [18]    iq_enable
// bit  [17]    idct_enable
// bit  [16]    no_zero_coeff_mb
// bit  [15]    add_zero_coeff_block
// bit  [14]    mb_pause_enable
// bit  [13]    q_enable
// bit  [12]    dct_enable
// bit  [11]    ignore_magic_word
// bit  [10]    mb_info_en
// bit  [9]     mb_info_soft_reset
// bit  [8]     mb_always_ready Set to 1 to ignore mb_level blocking DDR read
// bit  [7]     mb_ready_for_transfer (Read Only)
// bit  [6]     data_ready_for_transfer (Read Only)
// bits [5:3]   mb_endian       Set MB Endian inside DDR memory
// bit  [2]     mb_read_busy   Read Only - indicate DDR read busy
// bit  [1]     mb_read_en     Set to 1 to enable reading data from DDR memory
// bit  [0]     mb_soft_reset   Soft reset
#define HCODEC_QDCT_MB_CONTROL                     ((0x1f15  << 2) + 0xff620000)
// bit 31    transfer_length 0 - 32x64 Bits per request, 1 - 16x64 Bits per request  // default : 0
// bit 30    A_urgent  // default : 0
// bit 29:24 A_brst_num // default : 0x3f
// bit 23    reserved
// bit 22    read_till_zero
// bit 21:16 A_id  // default : 0x21
// bit 15:0  mb_level_hold // default : 0
#define HCODEC_QDCT_MB_MEM_CTL                     ((0x1f16  << 2) + 0xff620000)
// bit  [31:24] reserved
// bit  [23:16] vb_buff_level     -- Read only
// bit  [15:8]  vb_buff_wr_point -- RW
// bit  [7:0]   vb_buff_rd_point -- RW
#define HCODEC_QDCT_MB_BUFF                        ((0x1f17  << 2) + 0xff620000)
// bit [31:0] mb infor data begin magic word - default : 0xa55aaa55
#define HCODEC_QDCT_MB_MAGIC_WORD                  ((0x1f18  << 2) + 0xff620000)
// Read Only Register
// bit[19]   dct_ready_1
// bit[18]   dct_ready_0
// bit[17]   dct_rd_idx
// bit[16]   dct_wr_idx
// bit[15]   dct_srdy
// bit[14]   dct_rrdy
// bit[13]   Reserved
// bit[12:8] dct_block_number
// bit[7:4]  dct_rw_addr
// bit[3:0]  dct_status
#define HCODEC_QDCT_DCT_STATUS                     ((0x1f19  << 2) + 0xff620000)
// bit[24:23]  vlc_quant_count
// bit[22:16]  vlc_delta_quant_data
// bit[15:10]  vlc_quant_data
// bit[9:4]    vlc_prev_quant_data
// bit[3:0]    q_status
#define HCODEC_QDCT_Q_STATUS                       ((0x1f1a  << 2) + 0xff620000)
// bit[31:3] Reserved
// bit[2:0]  picture_type
#define HCODEC_QDCT_PIC_INFO                       ((0x1f1b  << 2) + 0xff620000)
// bit[31:28] Reserved
// bit[27:22] I_pic_quant_c
// bit[21:16] I_pic_quant
// bit[15]    reserved
// bit[14:12] quant_rem_c
// bit[11:8]  quant_per_c
// bit[7]     reserved
// bit[6:4]   quant_rem
// bit[3:0]   quant_per
#define HCODEC_QDCT_Q_QUANT_I                      ((0x1f1c  << 2) + 0xff620000)
// bit[31:28] Reserved
// bit[27:22] P_pic_quant_c
// bit[21:16] P_pic_quant
// bit[15]    reserved
// bit[14:12] quant_rem_c
// bit[11:8]  quant_per_c
// bit[7]     reserved
// bit[6:4]   quant_rem
// bit[3:0]   quant_per
#define HCODEC_QDCT_Q_QUANT_P                      ((0x1f1d  << 2) + 0xff620000)
// bit[31]    mb_info_pause
// bit[30:16] pause_mby
// bit[15:0]  pause_mbx
#define HCODEC_QDCT_MB_PAUSE_CTL                   ((0x1f1e  << 2) + 0xff620000)
// bit[31]   top_control_ready_i_pred
// bit[30:28]top_dma_status
// bit[27]   top_control_ready_ie
// bit[26:24]Reserved
// bit[23]   ul_mb
// bit[22]   right_mb
// bit[21]   top_mb
// bit[20]   left_mb
// bit[19:8] mb_x
// bit[7:6]  i_pred_ref_idx_L
// bit[5:4]  i_pred_ref_idx_UL
// bit[3:2]  i_pred_ref_idx_U
// bit[1:0]  i_pred_ref_idx_UR
#define HCODEC_QDCT_TOP_CONTROL                    ((0x1f1f  << 2) + 0xff620000)
// bit[31:0] top_base_addr - DDR Memory start address for save top Pixel
#define HCODEC_QDCT_TOP_BASE_MEM                   ((0x1f20  << 2) + 0xff620000)
// bit 15:13 Reserved
// bit 12    A_urgent  // default : 0
// bit 11:6  A_brst_num // default : 0x3f
// bit 5:0   A_id  // default : 0x22
#define HCODEC_QDCT_TOP_MEM_CTL                    ((0x1f21  << 2) + 0xff620000)
// bit [11:0] top_wrrsp_count
#define HCODEC_QDCT_TOP_WRRSP                      ((0x1f22  << 2) + 0xff620000)
// Bit[3:0] qdct_dbg_idx
#define HCODEC_QDCT_DBG_IDX                        ((0x1f23  << 2) + 0xff620000)
// Read Only
#define HCODEC_QDCT_DBG_READ                       ((0x1f24  << 2) + 0xff620000)
// [19:18] RW jdct_inflow_ctrl. JPEG DCT input flow control.                                Default 0.
//            0=No halt;
//            1=DCT halts request at end of each 8x8 block;
//            2=DCT halts request at end of each MCU.
// [17:16] RW jpeg_coeff_last_sel.                                                          Default 0.
//            Select at which point to finish processing, give update to AmRISC so it can control the next step.
//            0=Mark last coeff at the end of an 8x8 block;
//            1=Mark at the end of an MCU;
//            2=Mark at the end of a scan.
// [   15] RW jpeg_quant_sel_comp2. 0=Comp2 select Quantization table 0; 1=Select table 1.  Default 0.
// [   14] RW jpeg_v_factor_comp2. Component 2's vertical sampling factor.                  Default 0.
// [   13] RW jpeg_h_factor_comp2. Component 2's horizontal sampling factor.                Default 0.
// [   12] RW jpeg_comp2_en. Set 1 if the scan will include component 2 (Cr).               Default 0.
// [   11] RW jpeg_quant_sel_comp1. 0=Comp1 select Quantization table 0; 1=Select table 1.  Default 0.
// [   10] RW jpeg_v_factor_comp1. Component 1's vertical sampling factor.                  Default 0.
// [    9] RW jpeg_h_factor_comp1. Component 1's horizontal sampling factor.                Default 0.
// [    8] RW jpeg_comp1_en. Set 1 if the scan will include component 1 (Cb).               Default 0.
// [    7] RW jpeg_quant_sel_comp0. 0=Comp0 select Quantization table 0; 1=Select table 1.  Default 0.
// [    6] RW jpeg_v_factor_comp0. Component 0's vertical sampling factor.                  Default 0.
// [    5] RW jpeg_h_factor_comp0. Component 0's horizontal sampling factor.                Default 0.
// [    4] RW jpeg_comp0_en. Set 1 if the scan will include component 0 (Y).                Default 0.
// [ 3: 1] RW jdct_intr_sel. JPEG DCT interrupt select.                                     Default 0.
//            0=Disable intr;
//            1=Intr at end of each 8x8 block of DCT input;
//            2=Intr at end of each MCU of DCT input;
//            3=Intr at end of a scan of DCT input;
//            4=Intr at end of each 8x8 block of DCT output;
//            5=Intr at end of each MCU of DCT output;
//            6=Intr at end of a scan of DCT output.
// [    0] RW jpeg_en. 0=Disable JPEG QDCT; 1=Enable JPEG QDCT.                             Default 0.
#define HCODEC_QDCT_JPEG_CTRL                      ((0x1f25  << 2) + 0xff620000)
// [29:16] RW jpeg_x_end.   Picture X end.      Default 0.
// [13: 0] RW jpeg_x_start. Picture X start.    Default 0.
#define HCODEC_QDCT_JPEG_X_START_END               ((0x1f26  << 2) + 0xff620000)
// [29:16] RW jpeg_y_end.   Picture Y end.      Default 0.
// [13: 0] RW jpeg_y_start. Picture Y start.    Default 0.
#define HCODEC_QDCT_JPEG_Y_START_END               ((0x1f27  << 2) + 0xff620000)
// [    8] RW JPEG QUANT table access mode. 0=Write; 1=Read.    Default 1.
// [ 5: 0] RW JPEG QUANT table addr.                            Default 0.
#define HCODEC_QDCT_JPEG_QUANT_ADDR                ((0x1f28  << 2) + 0xff620000)
// [31: 0] RW JPEG QUANT table data.
#define HCODEC_QDCT_JPEG_QUANT_DATA                ((0x1f29  << 2) + 0xff620000)
// [    1] W  resume_jdct.
//            Write 1 to this bit will resume JPEG input engine when previously
//            it is halted by QDCT_JPEG_CTRL.jdct_inflow_ctrl.
// [    0] W  jpeg_sof.
//            Write 1 to this bit will start JPEG input engine.
#define HCODEC_QDCT_JPEG_SOF_RESUME                ((0x1f2a  << 2) + 0xff620000)
// [31:30] R  dct_st.       jdct_ctrl state. 0=IDLE; 1=WAIT; 2=DCT_REQ.
// [29:28] R  mfdin_comp.   Current component at pixel request to MFDIN.
// [27:14] R  mfdin_y.      Current Y at pixel request to MFDIN.
// [13: 0] R  mfdin_x.      Current X at pixel request to MFDIN.
#define HCODEC_QDCT_JPEG_DCT_STATUS0               ((0x1f2b  << 2) + 0xff620000)
// [15:12] R  JPEG Quant read MEM select.
// [11: 8] R  JPEG DCT2 write MEM select.
// [ 7: 4] R  JPEG DCT2 read MEM select.
// [ 3: 0] R  JPEG DCT1 write MEM select.
#define HCODEC_QDCT_JPEG_DCT_STATUS1               ((0x1f2c  << 2) + 0xff620000)
// [28:16] RW jdct_coeff1.  Default 13'h1D90; // 7568 = 4096 * sqrt(2) * (cos(Pi/8) + sin(Pi/8)) // 7569
// [12: 0] RW jdct_coeff0.  Default 13'h16A1; // 5793 = 4096 * sqrt(2)
#define HCODEC_QDCT_JPEG_DCT_COEFF01               ((0x1f2d  << 2) + 0xff620000)
// [28:16] RW jdct_coeff3.  Default 13'h0C3F; // 3135 = 4096 * sqrt(2) * (cos(Pi/8) - sin(Pi/8))
// [12: 0] RW jdct_coeff2.  Default 13'h08A9; // 2217 = 4096 * sqrt(2) * sin(Pi/8) // 2215
#define HCODEC_QDCT_JPEG_DCT_COEFF23               ((0x1f2e  << 2) + 0xff620000)
// [28:16] RW jdct_coeff5.  Default 13'h046A; // 1130 = 4096 * (cos(3Pi/16) - sin(3Pi/16))
// [12: 0] RW jdct_coeff4.  Default 13'h1631; // 5681 = 4096 * (cos(3Pi/16) + sin(3Pi/16)) // 5682
#define HCODEC_QDCT_JPEG_DCT_COEFF45               ((0x1f2f  << 2) + 0xff620000)
// [28:16] RW jdct_coeff7.  Default 13'h0C92; // 3218 = 4096 * (cos(Pi/16) - sin(Pi/16))
// [12: 0] RW jdct_coeff6.  Default 13'h12D0; // 4816 = 4096 * (cos(Pi/16) + sin(Pi/16))
#define HCODEC_QDCT_JPEG_DCT_COEFF67               ((0x1f30  << 2) + 0xff620000)
// [28:16] RW jdct_coeff9.  Default 13'h0FB1; // 4017 = 4096 * cos(Pi/16)
// [12: 0] RW jdct_coeff8.  Default 13'h0D4E; // 3406 = 4096 * cos(3Pi/16)
#define HCODEC_QDCT_JPEG_DCT_COEFF89               ((0x1f31  << 2) + 0xff620000)
#define HCODEC_QDCT_I_PRED_REF_WR_IDX              ((0x1f32  << 2) + 0xff620000)
#define HCODEC_QDCT_I_PRED_REF_WR_DATA             ((0x1f33  << 2) + 0xff620000)
// bit[29]  mb_info_latch_no_I16_pred_mode
// bit[28]  ie_dma_mbxy_use_i_pred
// bit[27]  ie_dma_read_write_use_ip_idx
// bit[26]  ie_start_use_top_dma_count
// bit[25]  i_pred_top_dma_rd_mbbot
// bit[24]  i_pred_top_dma_wr_disable
// bit[23]  i_pred_mix
// bit[22]  me_ab_rd_when_intra_in_p
// bit[21]  force_mb_skip_run_when_intra
// bit[20]  mc_out_mixed_type
// bit[19]  ie_start_when_quant_not_full
// bit[18]  mb_info_state_mix
// bit[17]  mb_type_use_mix_result
// bit[16]  me_cb_ie_read_enable
// bit[15]  ie_cur_data_from_me
// bit[14]  rem_per_use_table
// bit[13]  q_latch_int_enable
// bit[12]  q_use_table
// bit[11]  q_start_wait
// bit[10]  LUMA_16_LEFT_use_cur
// bit[9]   DC_16_LEFT_SUM_use_cur
// bit[8]   c_ref_ie_sel_cur
// bit[7]   c_ipred_perfect_mode
// bit[6]   ref_ie_ul_sel 0-old, 1-use next_set
// bit[5]   mb_type_use_ie_result
// bit[4]   detect_I16_from_I4
// bit[3]   ie_not_wait_ref_busy
// bit[2]   ie_I16_enable
// bit[1:0] ie_done_sel (0, 1, 2, -1)
#define HCODEC_QDCT_ADV_CONFIG                     ((0x1f34  << 2) + 0xff620000)
// bit [31:16] I16x16_weight
// bit [15:0]  I4x4_weight
#define HCODEC_IE_WEIGHT                           ((0x1f35  << 2) + 0xff620000)
// bit [31]  reserved
// bit [30] q_I16MB
// bit [29]  reserved
// bit [28]  reserved
// bit [27:23] quant_table_addr I4MB:[0,7], I16MB:[8:15], INTER:[16:23], Reserved:[24:31]
// bit [22]    quant_table_addr_update(when notupdate_rem_per) (read is arb_result : q_intra)
// bit [21:19] quant_rem_c
// bit [18:16] quant_rem_y
// bit [15:12] quant_per_c
// bit [11:8]  quant_per_y
// bit [7:2] quant
// bit [1] update_rem_per
// bit [0] clear_wait_status
#define HCODEC_Q_QUANT_CONTROL                     ((0x1f36  << 2) + 0xff620000)
#define HCODEC_MBBOT_EVEN_ADDR                     ((0x1f37  << 2) + 0xff620000)
#define HCODEC_MBBOT_ODD_ADDR                      ((0x1f38  << 2) + 0xff620000)
// bit [29:24] quant_table_data_3
// bit [21:16] quant_table_data_2
// bit [13:8]  quant_table_data_1
// bit [5:0]   quant_table_data_0
#define HCODEC_QUANT_TABLE_DATA                    ((0x1f39  << 2) + 0xff620000)
// bit [31:16] ie_sad_offset_I16
// bit [15:0] ie_sad_offset_I4
#define HCODEC_SAD_CONTROL_0                       ((0x1f3a  << 2) + 0xff620000)
// bit [31]     sad_soft_reset
// bit [30:27]  reserved
// bit [26:24]  ie_sad_shift_I16
// bit [22:20]  ie_sad_shift_I4
// bit [18:16]  me_sad_shift_INTER
// bit [15:0]   me_sad_offset_INTER
#define HCODEC_SAD_CONTROL_1                       ((0x1f3b  << 2) + 0xff620000)
// bit [31]     vlc_quant_rd_ptr
// bit [30]     vlc_quant_rd_ptr_update
// bit [29]     vlc_quant_wr_ptr
// bit [28]     vlc_quant_wr_ptr_update
// bit [27:26]  reserved
// bit [25:19]  vlc_delta_quant_1
// bit [18:13]  vlc_quant_1
// bit [12:6]   vlc_delta_quant_0
// bit [5:0]    vlc_quant_0
#define HCODEC_QDCT_VLC_QUANT_CTL_0                ((0x1f3c  << 2) + 0xff620000)
// bit [31:30]  me_sad_rd_idx
// bit [29]     me_sad_rd_idx_update
// bit [28:27]  me_sad_wr_idx
// bit [26]     me_sad_wr_idx_update
// bit [25:24]  ie_sad_rd_idx
// bit [23]     ie_sad_rd_idx_update
// bit [22:21]  ie_sad_wr_idx
// bit [20]     ie_sad_wr_idx_update
// bit [19:12]  Reserved
// bit [11:6]   vlc_max_delta_q_neg
// bit [5:0]    vlc_max_delta_q_pos
#define HCODEC_QDCT_VLC_QUANT_CTL_1                ((0x1f3d  << 2) + 0xff620000)
// bit[4] jdct_int
// bit[3] quant_latch
// bit[2] me_done
// bit[1] ie_start
// bit[0] i_pred_start
#define HCODEC_QDCT_INT_STATUS                     ((0x1f3e  << 2) + 0xff620000)
// bit[3]   mix_i_pred_wait_left_en
// bit[2:0] mc_pending_mb_count
#define HCODEC_QDCT_MIX_I_PRED_STATUS              ((0x1f3f  << 2) + 0xff620000)
// IE/ME share same cbus_base as QDCT
//
// bit[31]  active_ur_block
// bit[30]  active_ul_block
// bit[21]  disable_HENC_V_PRED_16
// bit[20]  disable_HENC_H_PRED_16
// bit[19]  disable_HENC_DC_PRED_16
// bit[18]  disable_HENC_HENC_HOR_UP_PRED
// bit[17]  disable_HENC_VERT_LEFT_PRED
// bit[16]  disable_HENC_HENC_HOR_DOWN_PRED
// bit[15]  disable_HENC_VERT_RIGHT_PRED
// bit[14]  disable_HENC_DIAG_DOWN_RIGHT_PRED
// bit[13]  disable_HENC_DIAG_DOWN_LEFT_PRED
// bit[12]  disable_HENC_DC_PRED
// bit[11]  disable_HENC_HOR_PRED
// bit[10]  disable_HENC_VERT_PRED
// bit[9]   ie_c_wait_ie_pause
// bit[8:4] max_ie_result_buff_count
// bit[3]   ie_wait_for_ie_result  // use for (max_ie_result_buff_count == 0) to wait every block
// bit[2]   reserved
// bit[1]   ie_enable
// bit[0]   ie_soft_reset
#define HCODEC_IE_CONTROL                          ((0x1f40  << 2) + 0xff620000)
// bit[31:12] Reserved
// bit[11:0]  mb_y
#define HCODEC_IE_MB_POSITION                      ((0x1f41  << 2) + 0xff620000)
// bit[31:16] me_skip_run
// bit[15:8]  reserved
// bit [7:4]  me_b8_mode
// bit [3:0]  ie_me_mb_type
#define HCODEC_IE_ME_MB_INFO                       ((0x1f42  << 2) + 0xff620000)
// bit[3]   ie_result_buff_enable
// bit[2]   ie_result_buff_soft_reset
// bit[1]   sad_enable
// bit[0]   ie_sad_soft_reset
#define HCODEC_SAD_CONTROL                         ((0x1f43  << 2) + 0xff620000)
// bit[31:16] - ie_result_buff_count - read only
// bit[14:12] -current_ie_result (pred_mode) - read only
// bit[11]  top_control_data_buff_wr_ptr - rd/wr
// bit[10]  top_control_data_buff_rd_ptr - rd/wr
// bit[9:5] ie_result_buff_wr_ptr        - rd/wr
// bit[4:0] ie_result_buff_rd_ptr        - rd/wr
#define HCODEC_IE_RESULT_BUFFER                    ((0x1f44  << 2) + 0xff620000)
// bit[63:0] ie_i4_pred_mode
#define HCODEC_IE_I4_PRED_MODE_HI                  ((0x1f45  << 2) + 0xff620000)
#define HCODEC_IE_I4_PRED_MODE_LO                  ((0x1f46  << 2) + 0xff620000)
// bit [31:9] reserved
// bit [8:4] i_pred_block_number
// bit [3:0] ie_c_pred_mode
#define HCODEC_IE_C_PRED_MODE                      ((0x1f47  << 2) + 0xff620000)
// 31:16 - Left, 0-select ie_pixel, 1-select mc_data_out
// 15:0  - Top,  0-select ie_pixel, 1-select mc_data_out
#define HCODEC_IE_CUR_REF_SEL                      ((0x1f48  << 2) + 0xff620000)
// bit[31]  enable_f_skip_1_step_3
// bit[30]  enable_f_skip_1_step_2
// bit[29]  enable_f_skip_1_step_1
// bit[28]  step_3_enable
// bit[27]  step_2_sub_pixel
// bit[26]  always_f_skip_step_3
// bit[25]  always_f_skip_step_2
// bit[24]  always_f_skip_step_1
// bit[23]  half_pixel_only
// bit[22:13] reserved
// bit[12]  adv_mv_enable
// bit[11]  sad_short_valid
// bit[10:9] mv_flexable_ctl 00:0x40, 01:0x80, 10:0xc0, 11 : 0x100
// bit[8]   no_md_ab_rd
// bit[7]   use_dct_state
// bit[6]   enable_free_clk_me_ctl
// bit[5]   enable_free_clk_me_ab
// bit[4]   enable_free_clk_me_cb
// bit[3]   reserved
// bit[2]   me_done_int_enable
// bit[1]   me_enable
// bit[0]   me_soft_reset
#define HCODEC_ME_CONTROL                          ((0x1f49  << 2) + 0xff620000)
// bit[31:28] Reserved
// bit[27:16] me_start_mby
// bit[15:12] Reserved
// bit[11:0]  me_start_mbx
#define HCODEC_ME_START_POSITION                   ((0x1f4a  << 2) + 0xff620000)
// bit [31:28] me_status - Read only
// bit [27:24] me_cb_status  // current buffer
// bit [23:20] me_ab_status  // anc buffer
// bit [19]    Reserved
// bit [18:16] me_ab_wr_ptr  // read only
// bit [15:4]  me_last_mbx
// bit [3:1]   me_ab_rd_ptr  // read only
// bit [0]     me_action
#define HCODEC_ME_STATUS                           ((0x1f4b  << 2) + 0xff620000)
// all Read-only
// bit [31:28] Reserved
// bit [27:16] me_ab_mbx
// bit [15:14] me_cb_wr_ptr
// bit [13:12] me_cb_rd_ptr
// bit [11:0]  me_cb_mbx
#define HCODEC_ME_DEBUG                            ((0x1f4c  << 2) + 0xff620000)
// bit[29:24] step_3_skip_line
// bit[23:18] step_2_skip_line
// bit[17:12] step_1_skip_line
// bit[11:6]  step_0_skip_line
// bit[5:0]   read_skip_line
#define HCODEC_ME_SKIP_LINE                        ((0x1f4d  << 2) + 0xff620000)
// bit 15:13 Reserved
// bit 12    A_urgent  // default : 0
// bit 11:6  A_brst_num // default : 0x3f
// bit 5:0   A_id  // default : 0x23
#define HCODEC_ME_AB_MEM_CTL                       ((0x1f4e  << 2) + 0xff620000)
// bit[31:24] anc_pic_canvas
// bit[23:12] max_me_mby_num
// bit[11:0]  max_me_mbx_num
#define HCODEC_ME_PIC_INFO                         ((0x1f4f  << 2) + 0xff620000)
// bit [23:12] me_sad_enough_1
// bit [11:0]  me_sad_enough_0
#define HCODEC_ME_SAD_ENOUGH_01                    ((0x1f50  << 2) + 0xff620000)
// bit [25:12] adv_mv_8x8_enough
// bit [11:0]  me_sad_enough_2
#define HCODEC_ME_SAD_ENOUGH_23                    ((0x1f51  << 2) + 0xff620000)
// bit [21:10] me_step0_big_sad
// bit [9:5] me_step0_close_mv_y
// bit [4:0] me_step0_close_mv_x
#define HCODEC_ME_STEP0_CLOSE_MV                   ((0x1f52  << 2) + 0xff620000)
// bit[31:24] force_skip_sad_3
// bit[23:16] force_skip_sad_2
// bit[15:08] force_skip_sad_1
// bit[07:00] force_skip_sad_0
#define HCODEC_ME_F_SKIP_SAD                       ((0x1f53  << 2) + 0xff620000)
// bit[31:24] force_skip_weight_3
// bit[23:16] force_skip_weight_2
// bit[15:08] force_skip_weight_1
// bit[07:00] force_skip_weight_0
#define HCODEC_ME_F_SKIP_WEIGHT                    ((0x1f54  << 2) + 0xff620000)
// Merge when (
//              (flex & me_merge_flex_en) |
//              (big_sad & me_merge_sad_en)|
//              ((~me_merge_flex_en)&(~me_merge_sad_en))
//            ) &
//            ( small_mv_diff |(~me_merge_small_mv_en))
//            & (me_merge_flex_en | me_merge_sad_en | me_merge_small_mv_en)
// bit[31]   me_merge_mv_en_16
// bit[30]   me_merge_small_mv_en_16
// bit[29]   me_merge_flex_en_16
// bit[28]   me_merge_sad_en_16
// bit[27]   me_merge_mv_en_8
// bit[26]   me_merge_small_mv_en_8
// bit[25]   me_merge_flex_en_8
// bit[24]   me_merge_sad_en_8
// bit[23:18] me_merge_mv_diff_16
// bit[17:12] me_merge_mv_diff_8
// bit[11:0] me_merge_min_sad
#define HCODEC_ME_MV_MERGE_CTL                     ((0x1f55  << 2) + 0xff620000)
// bit[31:24] mv_step_weight_1
// bit[23:16] mv_pre_weight_1
// bit [15:0] mv_step_weight_0
// bit[7:0]   mv_pre_weight_0
#define HCODEC_ME_MV_WEIGHT_01                     ((0x1f56  << 2) + 0xff620000)
// bit[31:24] mv_step_weight_3 (mv_step_weight_1_2nd)
// bit[23:16] mv_pre_weight_3 (mv_pre_weight_1_2nd)
// bit[15:8]  mv_step_weight_2
// bit[7:0]   mv_pre_weight_2
#define HCODEC_ME_MV_WEIGHT_23                     ((0x1f57  << 2) + 0xff620000)
// bit[31:24] me_sad_range_inc_3
// bit[23:16] me_sad_range_inc_2
// bit[15:8] me_sad_range_inc_1
// bit[7:0] me_sad_range_inc_0
#define HCODEC_ME_SAD_RANGE_INC                    ((0x1f58  << 2) + 0xff620000)
// bit[31:19]  reserved
// bit[18]     sub_relative_any_1_en
// bit[17]     sub_relative_any_2_en
// bit[16]     sub_relative_any_3_en
// bit[15]     sub_relative_any_4_en
// bit[14]     sub_relative_any_h_en
// bit[13]     sub_make_non_flex_fix
// bit[12]     sub_make_big_non_flex_fix
// bit[11:8]   sub_normal_mv_diff_16
// bit[7:4]    sub_normal_mv_diff_8
// bit[3:2]    Reserved
// bit[1]      sub_merge_enable_16
// bit[0]      sub_merge_enable_8
#define HCODEC_ME_SUB_MERGE_CTL                    ((0x1f59  << 2) + 0xff620000)
// bit[31:28]  sub_ref_mv_diff_near
// bit[27:24]  sub_ref_mv_diff_near_flex
// bit[23:20]  sub_ref_mv_diff
// bit[19:16]  sub_ref_mv_diff_flex
// bit[15:8]   sub_ref_mv_near_weight
// bit[7:0]    sub_ref_mv_weight
#define HCODEC_ME_SUB_REF_MV_CTL                   ((0x1f5a  << 2) + 0xff620000)
// bit[31:24]  sub_weight_max_sad
// bit[23:16]  sub_any_range_sad
// bit[15:8]   sub_any_min_sad
// bit[7:0]    sub_any_max_sad
#define HCODEC_ME_SUB_ANY_WEIGHT_SAD               ((0x1f5b  << 2) + 0xff620000)
// bit[31:24]  sub_fix_sad
// bit[23:16]  sub_fix_diff_sad
// bit[15:8]   sub_sad_flex_adj
// bit[7:0]    sub_big_non_flex_fix_sad
#define HCODEC_ME_SUB_FIX_SAD                      ((0x1f5c  << 2) + 0xff620000)
// bit[31:24]  sub_fix_min_sad
// bit[23:16]  sub_fix_min_diff_sad
// bit[15:8]   sub_fix_min_sad_2
// bit[7:0]    sub_fix_min_diff_sad_2
#define HCODEC_ME_SUB_FIX_MIN_SAD                  ((0x1f5d  << 2) + 0xff620000)
// bit[31:24]  sub_snap_to_ref_max_sad
// bit[23]     sub_snap_to_ref_non_flex
// bit[22:16]  sub_snap_to_ref_mv_diff
// bit[15:4]   sub_glitch_mv_sad
// bit[3:0]    sub_glitch_mv_diff
#define HCODEC_ME_SUB_SNAP_GLITCH                  ((0x1f5e  << 2) + 0xff620000)
// bit[31:20]  sad_act_limit
// bit[19:8]   s_a_any_sad
// bit[7]      Reserved
// bit[6:5]    sub_merge_method
// bit[4]      use_sub_act_result
// bit[3]      s_a_rnd
// bit[2]      Reserved
// bit[1]      sub_act_en_16
// bit[0]      sub_act_en
#define HCODEC_ME_SUB_ACT_CTL                      ((0x1f5f  << 2) + 0xff620000)
// bit[31:16]  reserved
// bit[15:0]   me_weight
#define HCODEC_ME_WEIGHT                           ((0x1f60  << 2) + 0xff620000)
// bit[31]  ready_update
// bit[30]  data_update
// bit[29:28] reserved
// bit[27:22] me_quant_0
// bit[21]  ie_sad_ready_0
// bit[20:18]  Reserved
// bit[17:16]  me_sad_mv_type_0
// bit[15:0] me_sad_0
#define HCODEC_ME_SAD_0                            ((0x1f61  << 2) + 0xff620000)
// bit[31]  ready_update
// bit[30]  data_update
// bit[29:28] reserved
// bit[27:22] me_quant_1
// bit[21]  me_sad_ready_1
// bit[20:18]  Reserved
// bit[17:16]  me_sad_mv_type_1
// bit[15:0] me_sad_1
#define HCODEC_ME_SAD_1                            ((0x1f62  << 2) + 0xff620000)
// bit[31]  ready_update
// bit[30]  data_update
// bit[29:28] reserved
// bit[27:22] me_quant_2
// bit[21]  me_sad_ready_2
// bit[20:18]  Reserved
// bit[17:16]  me_sad_mv_type_2
// bit[15:0] me_sad_2
#define HCODEC_ME_SAD_2                            ((0x1f63  << 2) + 0xff620000)
// bit[31]  ready_update
// bit[30]  data_update
// bit[29:28] reserved
// bit[27:22] me_quant_3
// bit[21]  me_sad_ready_3
// bit[20:18]  Reserved
// bit[17:16]  me_sad_mv_type_3
// bit[15:0] me_sad_3
#define HCODEC_ME_SAD_3                            ((0x1f64  << 2) + 0xff620000)
// bit[31]  ready_update
// bit[30]  data_update
// bit[29:28] reserved
// bit[27:22] ie_quant_0
// bit[21]  ie_sad_ready_0
// bit[20]   I4/I16 (0-I4MB, 1-I16MB)
// bit[19:0] ie_sad_0
#define HCODEC_IE_SAD_0                            ((0x1f65  << 2) + 0xff620000)
// bit[31]  ready_update
// bit[30]  data_update
// bit[29:28] reserved
// bit[27:22] ie_quant_1
// bit[21]  ie_sad_ready_1
// bit[20]   I4/I16 (0-I4MB, 1-I16MB)
// bit[19:0] ie_sad_1
#define HCODEC_IE_SAD_1                            ((0x1f66  << 2) + 0xff620000)
// bit[31]  ready_update
// bit[30]  data_update
// bit[29:28] reserved
// bit[27:22] ie_quant_2
// bit[21]  ie_sad_ready_2
// bit[20]   I4/I16 (0-I4MB, 1-I16MB)
// bit[19:0] ie_sad_2
#define HCODEC_IE_SAD_2                            ((0x1f67  << 2) + 0xff620000)
// bit[31]  ready_update
// bit[30]  data_update
// bit[29:28] reserved
// bit[27:22] ie_quant_3
// bit[21]  ie_sad_ready_3
// bit[20]   I4/I16 (0-I4MB, 1-I16MB)
// bit[19:0] ie_sad_3
#define HCODEC_IE_SAD_3                            ((0x1f68  << 2) + 0xff620000)
// bit[31]   enable_large_diff_16x8
// bit[30]   enable_large_diff_8x16
// bit[29:16] adv_mv_8x8_weight
// bit[15:14] reserved
// bit[13:0] adv_mv_4x4x4_weight
#define HCODEC_ADV_MV_CTL0                         ((0x1f69  << 2) + 0xff620000)
// bit[31:16] adv_mv_16x16_weight
// bit[15]   enable_large_diff_16x16
// bit[14:0] adv_mv_16_8_weight
#define HCODEC_ADV_MV_CTL1                         ((0x1f6a  << 2) + 0xff620000)
#define HCODEC_ADV_MV_CTL2                         ((0x1f6b  << 2) + 0xff620000)
// bit[31]    v3_skip_enable
// bit[30]    v3_step_1_weight_enable // for step1, will only use pre_weight for block0, only step_weight for block 1,2,3
// bit[29]    v3_l2_skip_only_use_l2_sad // set to 1 may allow l1 maybe not skip
// bit[28]    v3_mv_sad_weight_enable
// bit[27]    v3_ipred_type_enable
// bit[25:12] force_skip_sad_1
// bit[11:0]  force_skip_sad_0
#define HCODEC_V3_SKIP_CONTROL                     ((0x1f6c  << 2) + 0xff620000)
// bit[18:16] top_ipred_type_count
// bit[15:14] Reserved
// bit[13:12] top_ipred_type_rd_idx
// bit[11:10] top_ipred_type_wr_idx
// bit[9]   left_ipred_type_ready
// bit[8]   top_ipred_type_ready
// bit[7:6] left_mv_idx
// bit[5:4] top_mv_idx
// bit[3] - left_mv_ready
// bit[2:0] top_mv_ready
#define HCODEC_V3_TOP_LEFT_CTL                     ((0x1f6d  << 2) + 0xff620000)
#define HCODEC_V3_TOP_MV                           ((0x1f6e  << 2) + 0xff620000)
#define HCODEC_V3_LEFT_MV                          ((0x1f6f  << 2) + 0xff620000)
// bit[31:30] reserved
// bit[29:16] v3_skip_weight_1
// bit[15:12] reserved
// bit[11:0]  v3_skip_weight_0
#define HCODEC_V3_SKIP_WEIGHT                      ((0x1f70  << 2) + 0xff620000)
// bit[31:28] reserved
// bit[27:16] v3_l1_f_skip_max_sad
// bit[15:12] reserved
// bit[11:0]  v3_l1_skip_max_sad
#define HCODEC_V3_L1_SKIP_MAX_SAD                  ((0x1f71  << 2) + 0xff620000)
// bit[31:16] force_skip_sad_2
// bit[15:0]  v3_skip_weight_2
#define HCODEC_V3_L2_SKIP_WEIGHT                   ((0x1f72  << 2) + 0xff620000)
// bit[21:16] v3_mv_sad_table_addr 0-15 table_step_0
// bit[11:0]  v3_mv_sad
#define HCODEC_V3_MV_SAD_TABLE                     ((0x1f73  << 2) + 0xff620000)
// [31:16] v3_ie_f_zero_sad_i16
// [15:0]  v3_ie_f_zero_sad_i4
#define HCODEC_V3_F_ZERO_CTL_0                     ((0x1f74  << 2) + 0xff620000)
// [25]    v3_no_ver_when_top_zero_en
// [24]    v3_no_hor_when_left_zero_en
// [23:16] v3_max_I16_H_num    // 0 means no break
// [15:0]  v3_me_f_zero_sad
#define HCODEC_V3_F_ZERO_CTL_1                     ((0x1f75  << 2) + 0xff620000)
#define HCODEC_V3_TOP_INTRA_INFO                   ((0x1f76  << 2) + 0xff620000)
#define HCODEC_V3_LEFT_INTRA_INFO                  ((0x1f77  << 2) + 0xff620000)
// [31:24]  C_ipred_weight_H
// [23:16]  C_ipred_weight_V
// [15:8]   I4_ipred_weight_else
// [7:0]    I4_ipred_weight_most
#define HCODEC_V3_IPRED_TYPE_WEIGHT_0              ((0x1f78  << 2) + 0xff620000)
// [31:24]  I16_ipred_weight_DC
// [23:16]  I16_ipred_weight_H
// [15:8]   I16_ipred_weight_V
// [7:0]    C_ipred_weight_DC
#define HCODEC_V3_IPRED_TYPE_WEIGHT_1              ((0x1f79  << 2) + 0xff620000)
// [31:16]  v3_left_small_max_me_sad
// [15:0]   v3_left_small_max_ie_sad
#define HCODEC_V3_LEFT_SMALL_MAX_SAD               ((0x1f7a  << 2) + 0xff620000)
// (qr==7) & (qp==15) means force zero block
// [31:26]  v4_force_q_r_intra
// [25:20]  v4_force_q_r_inter
// [19]     v4_force_q_y_enable
// [18:16]  v4_force_qr_y
// [15:12]  v4_force_qp_y
// [11:0]   v4_force_skip_sad
#define HCODEC_V4_FORCE_SKIP_CFG                   ((0x1f7b  << 2) + 0xff620000)
// v5 Complexity // Y(256 pixel per MB) and C(128 pixel per MB)
// For every 4x4 block, calculate average and Add abs(pixel-average) together
// bit[31:16] v5_diff_sum_C
// bit[15:0]  v5_diff_sum_Y
#define HCODEC_V5_MB_DIFF_SUM                      ((0x1f7c  << 2) + 0xff620000)
// bit[31:24] v5_small_diff_cnt_C
// bit[23:16] v5_small_diff_C
// bit[15:8]  v5_small_diff_cnt_Y
// bit[7:0]   v5_small_diff_Y
#define HCODEC_V5_SMALL_DIFF_CNT                   ((0x1f7d  << 2) + 0xff620000)
// bit[31:29] Reserved
// bit[28:24] v5_simple_block_cnt // 0 -15 Y 16-23 C
// bit[23:20] v5_simple_pixel_cnt
// bit[19:18] v5_simple_dq_wr_ptr
// bit[17:16] v5_simple_dq_rd_ptr
// bit[15:12] v5_simple_dq (Read Only)
// bit[11:8]  v5_simple_me_weight(Read Only)
// bit[7] v5_use_small_diff_cnt
// bit[6] v5_simple_mb_inter_all_en
// bit[5] v5_simple_mb_inter_8x8_en
// bit[4] v5_simple_mb_inter_16_8_en
// bit[3] v5_simple_mb_inter_16x16_en
// bit[2] v5_simple_mb_intra_en
// bit[1] v5_simple_mb_C_en
// bit[0] v5_simple_mb_Y_en
#define HCODEC_V5_SIMPLE_MB_CTL                    ((0x1f7e  << 2) + 0xff620000)
// bit[31:28] v5_simple_dq_shift
// bit[27:24] v5_simple_dq_6(-7 to +7)
// bit[23:20] v5_simple_dq_5(-7 to +7)
// bit[19:16] v5_simple_dq_4(-7 to +7)
// bit[15:12] v5_simple_dq_3(-7 to +7)
// bit[11:08] v5_simple_dq_2(-7 to +7)
// bit[07:04] v5_simple_dq_1(-7 to +7)
// bit[03:00] v5_simple_dq_0(-7 to +7)
#define HCODEC_V5_SIMPLE_MB_DQUANT                 ((0x1f7f  << 2) + 0xff620000)
// bit[31:28] v5_simple_me_weight_shift
// bit[27:24] v5_simple_me_weight_6(-7 to +7)
// bit[23:20] v5_simple_me_weight_5(-7 to +7)
// bit[19:16] v5_simple_me_weight_4(-7 to +7)
// bit[15:12] v5_simple_me_weight_3(-7 to +7)
// bit[11:08] v5_simple_me_weight_2(-7 to +7)
// bit[07:04] v5_simple_me_weight_1(-7 to +7)
// bit[03:00] v5_simple_me_weight_0(-7 to +7)
#define HCODEC_V5_SIMPLE_MB_ME_WEIGHT              ((0x1f80  << 2) + 0xff620000)
//
// Closing file:  qdct_regs.h
//

#endif // DOS_REGISTER_H

#if 0
#define Wr(addr, data) *(volatile uint32_t *)(addr)=(data)
#define Rd(addr) *(volatile uint32_t *)(addr)
#define Wr_reg_bits(reg, val, start, len) \
  Wr(reg, ((Rd(reg) & ~(((1L<<(len))-1)<<(start))) | ((uint32_t)(val) << (start))))
#endif

//
// Reading file:  ./register_map.h
//
// synopsys translate_off
// synopsys translate_on
//
// Reading file:  stb_define.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// CBUS_BASE:  STB_CBUS_BASE = 0x18
// -----------------------------------------------
// There are two instantiations under one CBUS slave.  Each CBUS slave can support
// 256 registers.  Each demux is allocated 128 registers so set the offset in
// the middle
// Copy this define but don't add a base address
#define SECOND_DEMUX_OFFSET_0  0x50
#define THIRD_DEMUX_OFFSET_0   0xa0
//========================================================================
//  STB TOP Registers				    (8'hf0 - 8'hf7)
//========================================================================
// bit 30:28 -- ciplus_o_sel
// bit 27:26 -- ciplus_i_sel
// bit 25 -- use FAIL fro TS2
// bit 24 -- use FAIL fro TS1
// bit 23 -- use FAIL fro TS0
// bit 22 -- invert fec_error for S2P1
// bit 21 -- invert fec_data for S2P1
// bit 20 -- invert fec_sync for S2P1
// bit 19 -- invert fec_valid for S2P1
// bit 18 -- invert fec_clk for S2P1
// bit 17:16 -- fec_s_sel for S2P1  00 - select TS0, 01 -- select TS1, 10 -- select TS2, 11 - reserved
// Bit 15 -- enable_des_pl_clk
// Bit 14:13 -- reserved
// Bit 12:10 -- ts_out_select, 0-TS0, 1-TS1, 2-TS2, 3,4-Reserved, 5-S2P1, 6-S2P0, 7-File
// bit 9:8 -- des_i_sel 00 -- select_fec_0, 01 -- select_fec_1, 10 -- select_fec_2, 11 - reserved
// bit 7 -- enable_des_pl
// bit 6 -- invert fec_error for S2P0
// bit 5 -- invert fec_data for S2P0
// bit 4 -- invert fec_sync for S2P0
// bit 3 -- invert fec_valid for S2P0
// bit 2 -- invert fec_clk for S2P0
// bit 1:0 -- fec_s_sel for S2P0  00 - select TS0, 01 -- select TS1, 10 -- select TS2, 11 - reserved
#define STB_TOP_CONFIG                             ((0x18f0  << 2) + 0xffd00000)
// 31:28 - s2p1_clk_div
// 27:24 - s2p0_clk_div
// 23    - s2p1_disable
// 22    - s2p0_disable
// 21    - Reserved
// 20 -- TS_OUT_error_INVERT
// 19 -- TS_OUT_data_INVERT
// 18 -- TS_OUT_sync_INVERT
// 17 -- TS_OUT_valid_INVERT
// 16 -- TS_OUT_clk_INVERT
// 15:8 -- TS_package_length_sub_1 (default : 187)
//  7:0 -- fec_sync_byte (default : 0x47)
#define TS_TOP_CONFIG                              ((0x18f1  << 2) + 0xffd00000)
// Bit 25:24 -- transport_scrambling_control_odd_2 // should be 3
// Bit 23:16 -- file_m2ts_skip_bytes
// Bit 15:8 -- des_out_dly
// Bit 7:6 -- transport_scrambling_control_odd // should be 3
// Bit 5 -- ts_hiu_enable
// Bit 4:0 -- fec_clk_div
#define TS_FILE_CONFIG                             ((0x18f2  << 2) + 0xffd00000)
// Bit 19:14 -- des_2 ts pl state   -- Read Only
// Bit 13:8 -- des ts pl state   -- Read Only
// Bit 3:0 PID index to 8 PID to get key-set
// auto increase after TS_PL_PID_DATA read/write
#define TS_PL_PID_INDEX                            ((0x18f3  << 2) + 0xffd00000)
// Bit 13 -- PID match disble
// Bit 12:0 -- PID
#define TS_PL_PID_DATA                             ((0x18f4  << 2) + 0xffd00000)
#define COMM_DESC_KEY0                             ((0x18f5  << 2) + 0xffd00000)
#define COMM_DESC_KEY1                             ((0x18f6  << 2) + 0xffd00000)
#define COMM_DESC_KEY_RW                           ((0x18f7  << 2) + 0xffd00000)
// CI+ Register defines
// Bits[31:0] of the key
#define CIPLUS_KEY0                                ((0x18f8  << 2) + 0xffd00000)
// Bits[63:32] of the key
#define CIPLUS_KEY1                                ((0x18f9  << 2) + 0xffd00000)
// Bits[95:64] of the key
#define CIPLUS_KEY2                                ((0x18fa  << 2) + 0xffd00000)
// Bits[127:96] of the key
#define CIPLUS_KEY3                                ((0x18fb  << 2) + 0xffd00000)
// bit[5] write AES IV B value
// bit[4] write AES IV A value
// bit[3] write AES B key
// bit[2] write AES A key
// bit[1] write DES B key
// bit[0] write DES A key
#define CIPLUS_KEY_WR                              ((0x18fc  << 2) + 0xffd00000)
// [15:8]   TS out delay.  This controls the rate at which the CIplus module drives TS out
// [3]      General enable for the ciplus module
// [2]      AES CBC disable (default should be 0 to enable AES CBC)
// [1]      AES Enable
// [0]      DES Enable
#define CIPLUS_CONFIG                              ((0x18fd  << 2) + 0xffd00000)
// bit[31:28] AES IV endian
// bit[27:24] AES message out endian
// bit[23:20] AES message in endian
// bit[19:16] AES key endian
// bit[15:11]  unused
// bit[10:8]  DES message out endian
// bit[6:4]   DES message in endian
// bit[2:0]   DES key endian
#define CIPLUS_ENDIAN                              ((0x18fe  << 2) + 0xffd00000)
// bit 15:8 - des_out_dly_2
// bit   7 - reserved
// Bit   6-- enable_des_pl_clk_2
// bit   5 - enable_des_pl_2
// bit 4:2 -- use_des_2  bit[2] -- demux0, bit[3] -- demux1, bit[4] -- demux2
// bit 1:0 -- des_i_sel_2 00 -- select_fec_0, 01 -- select_fec_1, 10 -- select_fec_2, 11 - reserved
#define COMM_DESC_2_CTL                            ((0x18ff  << 2) + 0xffd00000)
//
// NOTE:  Don't process the demux registers using the standard create_headers.... perl script.
//        Instead, since the demux has multiple instances (and many registers) use a separate
//        script to create a separate stb_define.h for C-code.
//========================================================================
//  STB Registers				    (8'h00 - 8'h4f)
//
//========================================================================
// STB registers are 8'h0x
// Bit 15:0 -- version number : 0x0002  (v0.01)
// Bit 15 -- fec_core_select 1 - select descramble output
// Bit 14:12 -  fec_select 0-TS0, 1-TS1, 2-TS2, 3,4-Reserved, 5-S2P1, 6-S2P0, 7-File
// Bit 11 -- FEC_CLK
// Bit 10 -- SOP
// Bit 9 -- D_VALID
// Bit 8 -- D_FAIL
// Bit 7:0 -- D_DATA 7:0
// bit 31 -- enable_free_clk_fec_data_valid
// bit 30 -- enable_free_clk_stb_reg
// bit 29 -- always_use_pes_package_length
// bit 28 -- disable_pre_incomplete_section_fix
// bit 27 -- pointer_field_multi_pre_en
// bit 26 -- ignore_pre_incomplete_section
// bit 25 -- video2_enable
// bit 24:22 -- video2_type
// bit 21 -- do_not_trust_pes_package_length
// bit 20 (bit 4) -- Bypass use recoder path
// bit 19 (bit 3) -- clear_PID_continuity_counter_valid
// bit 18 (bit 2) -- Disable Splicing
// bit 17 (bit 1) -- Insert PES_STRONG_SYNC in Audio PES
// bit 16 (bit 0) -- Insert PES_STRONG_SYNC in Video PES
// Bit 15 - do not trust section length
// Bit 14 - om cmd push even zero
// Bit 13 - set_buff_ready_even_not_busy
// Bit 12 - SUB, OTHER PES interrupt at beginning of PES
// Bit 11 - discard_av_package -- for ts_recorder use only
// Bit 10 - ts_recorder_select  0:after PID filter 1:before PID filter
// Bit 9 - ts_recorder_enable
// Bit 8 - (table_id == 0xff) means section_end
// Bit 7 - do not send uncomplete section
// Bit 6 - do not discard duplicate package
// Bit 5 - search SOP when transport_error_indicator
// Bit 4 - stb demux enable
// Bit 3 - do not reset state machine on SOP
// Bit 2 - search SOP when error happened ( when ignore_fail_n_sop, will have this case)
// Bit 1 - do not use SOP input ( check FEC sync byte instead )
// Bit 0 - ignore fec_error bit when non sop ( check error on SOP only)
// bit 15:8 demux package length - 1 ( default : 187 )
// bit 7:0 default is 0x47
// bit 31:16 -- filter memory write data hi[31:16]
// bit 15:0 -- filter memory write data low [15:0]
// bit 31:24 -- advanced setting hi
// bit 23:16 -- advanced setting low
// bit 15 -- filter memory write data request
// bit 7:0 -- filter memory write addr
// bit 13:8 demux state  -- read only
// bit 7:4 -- maxnum section filter compare address
// bit 3:0 -- maxnum PID filter compare address
// bit 15 - transport_error_indicator
// bit 14 - payload_unit_start_indicator
// bit 13 - transport_priority
// bit 12:0 - PID
// bit 7:6 transport_scrambling_control
// bit 5:4 adaptation_field_control
// bit 3:0 continuity_counter
// bit 15:12 -- om_cmd_count (read only)
// bit  11:9 -- overflow_count // bit  11:9 -- om_cmd_wr_ptr (read only)
// bit   8:6 -- om_overwrite_count // bit   8:6 -- om_cmd_rd_ptr (read only)
// bit   5:3 -- type_stb_om_w_rd (read only)
// bit     2 -- unit_start_stb_om_w_rd (read only)
// bit     1 -- om_cmd_overflow (read only)
// bit     0 -- om_cmd_pending (read)
// bit     0 -- om_cmd_read_finished (write)
// bit 15:9 // bit 14:8 -- count_stb_om_w_rd  (read only)
// bit 8:0  // bit  7:0 -- start_stb_om_wa_rd (read only)
// bit 11:0 -- offset for section data
// bit 31:16 -- base address for section buffer group 0 (*0x400 to get real address)
// bit 15:0 -- base address for section buffer group 1 (*0x400 to get real address)
// bit 31:16 -- ba2e address for section buffer group 2 (*0x400 to get real address)
// bit 15:0 -- base address for section buffer group 3 (*0x400 to get real address)
// bit 3:0 -- section buffer size for group 0 (bit used,  for example, 10 means 1K)
// bit 7:4 -- section buffer size for group 1
// bit 11:8 -- section buffer size for group 2
// bit 15:12 -- section buffer size for group 3
// section buffer busy status for buff 31:0 ( Read Only )
// section buffer write status for buff 31:0 -- Read
// clear buffer status ( buff READY and BUSY ) -- write
// bit 4:0 -- SEC_BUFFER_INDEX   RW
// bit 12:8 -- SEC_BUFFER_NUMBER for the INDEX buffer  Read_Only
// bit 14 -- output_section_buffer_valid
// bit 15 -- section_reset_busy (Read Only)
// bit 9:5 -- BYPASS PID number
// bit 4:0 -- PCR PID number
// bit 15:0 -- stream_id filter bit enable
// bit 7:0 -- stream_id filter target
// bit 12 -- PCR_EN
// bit 11:0 -- PCR90K_DIV
// bit 31:0 -- PCR[31:0] R/W
// bit 31:0 -- VPTS[31:0] R/W
// bit 31:0 -- VDTS[31:0] R/W
// bit 31:0 -- APTS[31:0] R/W
// bit 31:0 -- SPTS[31:0] R/W
// read -- status, write 1 clear status
// bit 15 -- SUB_PTS[32]
// bit 14 -- AUDIO_PTS[32]
// bit 13 -- VIDEO_DTS[32]
// bit 12 -- VIDEO_PTS[32]
// bit 3 -- sub_pts_ready
// bit 2 -- audio_pts_ready
// bit 1 -- video_dts_ready
// bit 0 -- video_pts_ready
// bit 3:0 --
//  0 -- adaptation_field_length[7:0], adaption_field_byte_1[7:0]
//  1 -- stream_id[7:0], pes_header_bytes_left[7:0]
//  2 -- pes_package_bytes_left[15:0]
//  3 -- pes_ctr_byte[7:0], pes_flag_byte[7:0]
//
// read only
// bit[31] -- no_match_record_en
// bit[30:16] - reserved
// default : 0x807f
// bit 15:9  -- MAX OM DMA COUNT  (default: 0x40)
// bit 8:0   -- LAST ADDR OF OM ADDR (default: 127)
// 15:0  WRITE 1 CLEAR to clear interrupt source
//12 -- INPUT_TIME_OUT
//11 -- PCR_ready
//10 -- audio_splicing_point
// 9 -- video_splicing_point
// 8 -- other_PES_int
// 7 -- sub_PES_int
// 6 -- discontinuity
// 5 -- duplicated_pack_found
// 4 -- New PDTS ready
// 3 -- om_cmd_buffer ready for access
// 2 -- section buffer ready
// 1 -- transport_error_indicator
// 0 -- TS ERROR PIN
// Bit 5:3 - demux om write endian control for bypass
// Bit 2:0 - demux om write endian control for section
// When Bit 31 - 1 write will indicate all type use separate endian (Write Only)
// Bit 23:21 - demux om write endian control for OTHER_PES_PACKET
// Bit 20:18 - demux om write endian control for SCR_ONLY_PACKET
// Bit 17:15 - demux om write endian control for SUB_PACKET
// Bit 14:12 - demux om write endian control for AUDIO_PACKET
// Bit 11:9  - demux om write endian control for VIDEO_PACKET
//
// When Bit 31 - 0 write will indicate all type else use Bit 8:6
// Bit 8:6 - demux om write endian control for else
// Bit 15:8 -- last_burst_threshold
// Bit 7 -- use hi_bsf interface
// Bit 6:2 - fec_clk_div
// Bit 1 ts_source_sel
// Bit 0 - Hiu TS generate enable
// bit 15:0 -- base address for section buffer start (*0x10000 to get real base)
// bit 11 -- mask bit for OTHER_PES_AHB_DMA_EN
// bit 10 -- mask bit for SUB_AHB_DMA_EN
// bit 9 -- mask bit for BYPASS_AHB_DMA_EN
// bit 8 -- mask bit for SECTION_AHB_DMA_EN
// bit 7 -- mask bit for recoder stream
// bit 6:0 -- mask bit for each type
// bit 31:0 -- vb_wr_ptr for video PDTS
// bit 31:0 -- ab_wr_ptr for audio PDTS
// bit 20:0 -- SB_WRITE_PTR (sb_wr_ptr << 3 == byte write position)
// bit 19:0 -- SB_START (sb_start << 12 == byte address);
// bit 20:0 -- SB_SIZE (sb_size << 3 == byte size, 16M maximun)
// bit 31:0 -- sb_wr_ptr for sub PES
// bit 31:16 -- ob_wr_ptr for other PES
// bit 20:0 -- OB_WRITE_PTR (ob_wr_ptr << 3 == byte write position)
// bit 19:0 -- OB_START (ob_start << 12 == byte address);
// bit 20:0 -- OB_SIZE (ob_size << 3 == byte size, 16M maximun)
// bit 31:0 -- ob_wr_ptr for sub PES
// 15:0  DEMUX interrupt MASK
// 9 -- splicing_point
// 8 -- other_PES_int
// 7 -- sub_PES_int
// 6 -- discontinuity
// 5 -- duplicated_pack_found
// 4 -- New PDTS ready
// 3 -- om_cmd_buffer ready for access
// 2 -- section buffer ready
// 1 -- transport_error_indicator
// 0 -- TS ERROR PIN
// 31:16 VIDEO PID filter data
//15 -- splicing VIDEO PID change enable
//14:10 -- VIDEO PID FILTER ADDRESS
// 9 -- PES splicing active (Read Only)
// 8 -- splicing active (Read Only)
// 7:0  splicing countdown (Read Only)
// 31:16 AUDIO PID filter data
//15 -- splicing AUDIO PID change enable
//14:10 -- AUDIO PID FILTER ADDRESS
// 9 -- PES splicing active (Read Only)
// 8 -- splicing active (Read Only)
// 7:0  splicing countdown (Read Only)
// 23:16 M2TS_SKIP_BYTES
// 15:8 LAST TS PACKAGE BYTE COUNT (Read Only)
// 7:0  PACKAGE BYTE COUNT (Read Only)
// 15:0 2 bytes strong sync add to PES
// bit 15 -- stb_om_ren
// bit 14:11 -- reserved
// bit  10:0 -- OM_DATA_RD_ADDR
// bit 15:0 -- OM_DATA_RD
// AUTO STOP SETTING for 32 channels
// 4-nbits per channel
// when write
// bit 3 -- set section active
// bit 2:0 -- auto stop after count (0 means never stop)
// when read
// bit 3 -- current active status (1 - active, 0 - stopped )
// bit 2:0 -- count down to auto stop
// section 31:24
// section 23:16
// section 15:8
// section 7:0
// bit 31:0 reset channel status - each bit reset each channel
// read -- 32 channel status
// bit 4 -- video_stamp_use_dts
// bit 3 -- audio_stamp_sync_1_en
// bit 2 -- audio_stamp_insert_en
// bit 1 -- video_stamp_sync_1_en
// bit 0 -- video_stamp_insert_en
// Write : Bit[4:0] secter filter number for reset
// Read  : select according to output_section_buffer_valid :
//         per bit per section buffer valid status
//         or section_buffer_ignore
// bit[31:0] - channel_reset_timeout_disable
// bit[31] - no_match_reset_timeout_disable
// bit[30:0] input_time_out_int_cnt (0 -- means disable) Wr-setting, Rd-count
// bit[31:0] - channel_packet_count_disable
// bit[31] - no_match_packet_count_disable
// bit[30:0] input_packet_count
// bit[31:0] channel_record_enable
// bit[31:0] channel_process_enable
// bit[31:24] small_sec_size ((n+1) * 256 Bytes)
// bit[23:16] small_sec_rd_ptr
// bit[15:8]  small_sec_wr_ptr
// bit[7:2]   reserved
// bit[1] small_sec_wr_ptr_wr_enable
// bit[0] small_section_enable
// bit[31:0] small_sec_start_addr
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  stb_define.h
//
//
// Reading file:  periphs_reg.h
//
// $periphs/rtl/periphs_core register defines for the
// APB bus
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  SC_CBUS_BASE = 0x94
// -----------------------------------------------
#define SMARTCARD_REG0                             ((0x9400  << 2) + 0xffd00000)
#define SMARTCARD_REG1                             ((0x9401  << 2) + 0xffd00000)
#define SMARTCARD_REG2                             ((0x9402  << 2) + 0xffd00000)
#define SMARTCARD_STATUS                           ((0x9403  << 2) + 0xffd00000)
#define SMARTCARD_INTR                             ((0x9404  << 2) + 0xffd00000)
#define SMARTCARD_REG5                             ((0x9405  << 2) + 0xffd00000)
#define SMARTCARD_REG6                             ((0x9406  << 2) + 0xffd00000)
#define SMARTCARD_FIFO                             ((0x9407  << 2) + 0xffd00000)
#define SMARTCARD_REG8                             ((0x9408  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  UART0_CBUS_BASE = 0x90
// -----------------------------------------------
#define UART0_WFIFO                                ((0x9000  << 2) + 0xffd00000)
#define UART0_RFIFO                                ((0x9001  << 2) + 0xffd00000)
#define UART0_CONTROL                              ((0x9002  << 2) + 0xffd00000)
#define UART0_STATUS                               ((0x9003  << 2) + 0xffd00000)
#define UART0_MISC                                 ((0x9004  << 2) + 0xffd00000)
#define UART0_REG5                                 ((0x9005  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  UART1_CBUS_BASE = 0x8c
// -----------------------------------------------
#define UART1_WFIFO                                ((0x8c00  << 2) + 0xffd00000)
#define UART1_RFIFO                                ((0x8c01  << 2) + 0xffd00000)
#define UART1_CONTROL                              ((0x8c02  << 2) + 0xffd00000)
#define UART1_STATUS                               ((0x8c03  << 2) + 0xffd00000)
#define UART1_MISC                                 ((0x8c04  << 2) + 0xffd00000)
#define UART1_REG5                                 ((0x8c05  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  UART2_CBUS_BASE = 0x88
// -----------------------------------------------
#define UART2_WFIFO                                ((0x8800  << 2) + 0xffd00000)
#define UART2_RFIFO                                ((0x8801  << 2) + 0xffd00000)
#define UART2_CONTROL                              ((0x8802  << 2) + 0xffd00000)
#define UART2_STATUS                               ((0x8803  << 2) + 0xffd00000)
#define UART2_MISC                                 ((0x8804  << 2) + 0xffd00000)
#define UART2_REG5                                 ((0x8805  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  UART3_CBUS_BASE = 0x84
// -----------------------------------------------
#define UART3_DF_REG_A73                           ((0x8400  << 2) + 0xffd00000)
#define UART3_DF_REG_A74                           ((0x8401  << 2) + 0xffd00000)
#define UART3_DF_REG_A75                           ((0x8402  << 2) + 0xffd00000)
#define UART3_DF_REG_A76                           ((0x8403  << 2) + 0xffd00000)
#define UART3_DF_REG_A77                           ((0x8404  << 2) + 0xffd00000)
#define UART3_DF_REG_A78                           ((0x8405  << 2) + 0xffd00000)
#define UART3_DF_REG_A79                           ((0x8406  << 2) + 0xffd00000)
#define UART3_DF_REG_A80                           ((0x8407  << 2) + 0xffd00000)
#define UART3_DF_REG_A81                           ((0x8408  << 2) + 0xffd00000)
#define UART3_DF_REG_A82                           ((0x8409  << 2) + 0xffd00000)
#define UART3_DF_REG_A83                           ((0x8410  << 2) + 0xffd00000)
#define UART3_DF_REG_A84                           ((0x8411  << 2) + 0xffd00000)
#define UART3_DF_REG_A85                           ((0x8412  << 2) + 0xffd00000)
#define UART3_DF_REG_A86                           ((0x8413  << 2) + 0xffd00000)
#define UART3_DF_REG_A87                           ((0x8414  << 2) + 0xffd00000)
#define UART3_DF_REG_A88                           ((0x8415  << 2) + 0xffd00000)
#define UART3_DF_REG_A89                           ((0x8416  << 2) + 0xffd00000)
#define UART3_DF_REG_A96                           ((0x8417  << 2) + 0xffd00000)
#define UART3_DF_REG_A97                           ((0x8418  << 2) + 0xffd00000)
#define UART3_DF_REG_A128                          ((0x8420  << 2) + 0xffd00000)
#define UART3_DF_REG_A129                          ((0x8421  << 2) + 0xffd00000)
#define UART3_DF_REG_A130                          ((0x8422  << 2) + 0xffd00000)
#define UART3_DF_REG_A131                          ((0x8423  << 2) + 0xffd00000)
#define UART3_DF_REG_A132                          ((0x8424  << 2) + 0xffd00000)
#define UART3_DF_REG_A133                          ((0x8425  << 2) + 0xffd00000)
#define UART3_DF_REG_A134                          ((0x8426  << 2) + 0xffd00000)
#define UART3_DF_REG_A135                          ((0x8427  << 2) + 0xffd00000)
#define UART3_DF_REG_A136                          ((0x8428  << 2) + 0xffd00000)
// ----------------------------
// SANA (Stream Analyzer)
// ----------------------------
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  SANA_CBUS_BASE = 0x30
// -----------------------------------------------
// [31:16] - ddr_setting
// [15]    - disable_stream_clock_gating
// [14:13] - mem_pd_ctl_sana
// [6:4]   - stream_fetch_endian
// [3]     - use_parser_vbuf_wp
// [2]     - use_parser_vbuf2_wp
// [1]     - stream_fetch_busy - Read Only
// [0]     - stream_fetch_enable
#define SANA_STREAM_CONTROL                        ((0x3020  << 2) + 0xffd00000)
#define SANA_STREAM_START_ADDR                     ((0x3021  << 2) + 0xffd00000)
#define SANA_STREAM_END_ADDR                       ((0x3022  << 2) + 0xffd00000)
// SW stream_buffer_wr_ptr
#define SANA_STREAM_WR_PTR                         ((0x3023  << 2) + 0xffd00000)
#define SANA_STREAM_RD_PTR                         ((0x3024  << 2) + 0xffd00000)
//[31:0] stream_buffer_level - read only
#define SANA_STREAM_LEVEL                          ((0x3025  << 2) + 0xffd00000)
// [31:29] stream_buffer_hole 256*(4^0) bytes
// [28:23] stream_fifo_hole
// [22:16] stream_fifo_level
// [15]    stream_fifo_wr_ptr_update_en
// [14:8]  stream_fifo_wr_ptr
// [7]     stream_fifo_rd_ptr_update_en
// [6:0]   stream_fifo_rd_ptr
#define SANA_STREAM_FIFO_CTL                       ((0x3026  << 2) + 0xffd00000)
// [31:18] - Reserved
// [17]    - sana_int_enable
// [16]    - sana_int_level (default : 0(pulse))
// [15]    - disable_shift_clock_gating
// [14]    - startcode_protect -- TODO
// [8:6]   - sft_valid_wr_position (default : 3 (at least 24 bits available))
// [5:4]   - emulate_code_length_sub_1(Default : 2)
// [3]     - emulation_auto_on_startcode(Default : 0)
// [2:1]   - start_code_length_sub_1(Default : 2)
// [0]     - stream_shift_enable(Default : 0)
#define SANA_SHIFT_CONTROL                         ((0x3027  << 2) + 0xffd00000)
// [31:0]  - max 4-bytes start code (Default : 0x00000100)
#define SANA_SHIFT_STARTCODE                       ((0x3028  << 2) + 0xffd00000)
// [31:0]  - max 4-bytes emulate code (Default : 0x00000300)
#define SANA_SHIFT_EMULATECODE                     ((0x3029  << 2) + 0xffd00000)
// [3]     - sana_int
// [2]     - startcode_searching
// [1]     - emulation_check_on
// [0]     - startcode_check_on
#define SANA_SHIFT_STATUS                          ((0x302a  << 2) + 0xffd00000)
// [31:0] sana_shifted_data - read only
#define SANA_SHIFTED_DATA                          ((0x302b  << 2) + 0xffd00000)
// [31:0] shift_byte_count[31:0]
#define SANA_SHIFT_BYTE_COUNT                      ((0x302c  << 2) + 0xffd00000)
// [31:28] - shift_byte_count[35:32]
// [27:20] - element_read_data[31:24]
// [10]    - bytealign
// [9]     - signed_element
// [8]     - start_element_read
// [7]     - shift_busy
// [6:0]   - shift_bits
#define SANA_SHIFT_COMMAND                         ((0x302d  << 2) + 0xffd00000)
// 31:8    - element_read_data[23:0]
//  7:2    - element_read_length
//  1:0    - element_read_state
#define SANA_ELEMENT_RESULT                        ((0x302e  << 2) + 0xffd00000)
// support up to 8 masters, one bit per master
// 23:16   - lock_release (Write 1 to release)
// 15:8    - lock_req (write 1 to request)
//  7:0    - lock_result (Read Only)
#define ATOM_LOCK                                  ((0x302f  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  I2C_M_0_CBUS_BASE = 0x7c
// -----------------------------------------------
#define I2C_M_0_CONTROL_REG                        ((0x7c00  << 2) + 0xffd00000)
    #define     I2C_M_MANUAL_SDA_I        26
    #define     I2C_M_MANUAL_SCL_I        25
    #define     I2C_M_MANUAL_SDA_O        24
    #define     I2C_M_MANUAL_SCL_O        23
    #define     I2C_M_MANUAL_EN           22
    #define     I2C_M_DELAY_MSB           21
    #define     I2C_M_DELAY_LSB           12
    #define     I2C_M_DATA_CNT_MSB        11
    #define     I2C_M_DATA_CNT_LSB        8
    #define     I2C_M_CURR_TOKEN_MSB      7
    #define     I2C_M_CURR_TOKEN_LSB      4
    #define     I2C_M_ERROR               3
    #define     I2C_M_STATUS              2
    #define     I2C_M_ACK_IGNORE          1
    #define     I2C_M_START               0
#define I2C_M_0_SLAVE_ADDR                         ((0x7c01  << 2) + 0xffd00000)
#define I2C_M_0_TOKEN_LIST0                        ((0x7c02  << 2) + 0xffd00000)
#define I2C_M_0_TOKEN_LIST1                        ((0x7c03  << 2) + 0xffd00000)
#define I2C_M_0_WDATA_REG0                         ((0x7c04  << 2) + 0xffd00000)
#define I2C_M_0_WDATA_REG1                         ((0x7c05  << 2) + 0xffd00000)
#define I2C_M_0_RDATA_REG0                         ((0x7c06  << 2) + 0xffd00000)
#define I2C_M_0_RDATA_REG1                         ((0x7c07  << 2) + 0xffd00000)
// -----------------------------------------------
// CBUS_BASE:  I2C_M_1_CBUS_BASE = 0x78
// -----------------------------------------------
#define I2C_M_1_CONTROL_REG                        ((0x7800  << 2) + 0xffd00000)
#define I2C_M_1_SLAVE_ADDR                         ((0x7801  << 2) + 0xffd00000)
#define I2C_M_1_TOKEN_LIST0                        ((0x7802  << 2) + 0xffd00000)
#define I2C_M_1_TOKEN_LIST1                        ((0x7803  << 2) + 0xffd00000)
#define I2C_M_1_WDATA_REG0                         ((0x7804  << 2) + 0xffd00000)
#define I2C_M_1_WDATA_REG1                         ((0x7805  << 2) + 0xffd00000)
#define I2C_M_1_RDATA_REG0                         ((0x7806  << 2) + 0xffd00000)
#define I2C_M_1_RDATA_REG1                         ((0x7807  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  I2C_M_2_CBUS_BASE = 0x74
// -----------------------------------------------
#define I2C_M_2_CONTROL_REG                        ((0x7400  << 2) + 0xffd00000)
#define I2C_M_2_SLAVE_ADDR                         ((0x7401  << 2) + 0xffd00000)
#define I2C_M_2_TOKEN_LIST0                        ((0x7402  << 2) + 0xffd00000)
#define I2C_M_2_TOKEN_LIST1                        ((0x7403  << 2) + 0xffd00000)
#define I2C_M_2_WDATA_REG0                         ((0x7404  << 2) + 0xffd00000)
#define I2C_M_2_WDATA_REG1                         ((0x7405  << 2) + 0xffd00000)
#define I2C_M_2_RDATA_REG0                         ((0x7406  << 2) + 0xffd00000)
#define I2C_M_2_RDATA_REG1                         ((0x7407  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  I2C_M_3_CBUS_BASE = 0x70
// -----------------------------------------------
#define I2C_M_3_CONTROL_REG                        ((0x7000  << 2) + 0xffd00000)
#define I2C_M_3_SLAVE_ADDR                         ((0x7001  << 2) + 0xffd00000)
#define I2C_M_3_TOKEN_LIST0                        ((0x7002  << 2) + 0xffd00000)
#define I2C_M_3_TOKEN_LIST1                        ((0x7003  << 2) + 0xffd00000)
#define I2C_M_3_WDATA_REG0                         ((0x7004  << 2) + 0xffd00000)
#define I2C_M_3_WDATA_REG1                         ((0x7005  << 2) + 0xffd00000)
#define I2C_M_3_RDATA_REG0                         ((0x7006  << 2) + 0xffd00000)
#define I2C_M_3_RDATA_REG1                         ((0x7007  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PWM_AB_CBUS_BASE = 0x6c
// -----------------------------------------------
#define PWM_PWM_A                                  ((0x6c00  << 2) + 0xffd00000)
#define PWM_PWM_B                                  ((0x6c01  << 2) + 0xffd00000)
#define PWM_MISC_REG_AB                            ((0x6c02  << 2) + 0xffd00000)
#define PWM_DELTA_SIGMA_AB                         ((0x6c03  << 2) + 0xffd00000)
#define PWM_TIME_AB                                ((0x6c04  << 2) + 0xffd00000)
#define PWM_A2                                     ((0x6c05  << 2) + 0xffd00000)
#define PWM_B2                                     ((0x6c06  << 2) + 0xffd00000)
#define PWM_BLINK_AB                               ((0x6c07  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PWM_CD_CBUS_BASE = 0x68
// -----------------------------------------------
#define PWM_PWM_C                                  ((0x6800  << 2) + 0xffd00000)
#define PWM_PWM_D                                  ((0x6801  << 2) + 0xffd00000)
#define PWM_MISC_REG_CD                            ((0x6802  << 2) + 0xffd00000)
#define PWM_DELTA_SIGMA_CD                         ((0x6803  << 2) + 0xffd00000)
#define PWM_TIME_CD                                ((0x6804  << 2) + 0xffd00000)
#define PWM_C2                                     ((0x6805  << 2) + 0xffd00000)
#define PWM_D2                                     ((0x6806  << 2) + 0xffd00000)
#define PWM_BLINK_CD                               ((0x6807  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PWM_EF_CBUS_BASE = 0x64
// -----------------------------------------------
#define PWM_PWM_E                                  ((0x6400  << 2) + 0xffd00000)
#define PWM_PWM_F                                  ((0x6401  << 2) + 0xffd00000)
#define PWM_MISC_REG_EF                            ((0x6402  << 2) + 0xffd00000)
#define PWM_DELTA_SIGMA_EF                         ((0x6403  << 2) + 0xffd00000)
#define PWM_TIME_EF                                ((0x6404  << 2) + 0xffd00000)
#define PWM_E2                                     ((0x6405  << 2) + 0xffd00000)
#define PWM_F2                                     ((0x6406  << 2) + 0xffd00000)
#define PWM_BLINK_EF                               ((0x6407  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  MSR_CLK_CBUS_BASE = 0x60
// -----------------------------------------------
#define MSR_CLK_DUTY                               ((0x6000  << 2) + 0xffd00000)
#define MSR_CLK_REG0                               ((0x6001  << 2) + 0xffd00000)
#define MSR_CLK_REG1                               ((0x6002  << 2) + 0xffd00000)
#define MSR_CLK_REG2                               ((0x6003  << 2) + 0xffd00000)
#define MSR_CLK_REG3                               ((0x6004  << 2) + 0xffd00000)
#define MSR_CLK_REG4                               ((0x6005  << 2) + 0xffd00000)
#define MSR_CLK_REG5                               ((0x6006  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  STEAM_CBUS_BASE = 0x2c
// -----------------------------------------------
// bit 31:24 -- event_length
// bit 23:22 -- bus_1st_sel_1  //00-gpio, 01-reserved, 10-addr, 11-data
// bit 21:20 -- bus_2nd_sel_1
// bit 19:18 -- bus_1st_sel_0
// bit 17:16 -- bus_2nd_sel_0
// bit 15:0 -- set output value (output 1 will read according to external input)
#define STREAM_EVENT_INFO                          ((0x2c00  << 2) + 0xffd00000)
// bit 31    -- force_parity_1
// bit 30    -- LSB_first
// bit 31:20 -- reserved
// bit 19:16 -- toggle point index
// bit 15:8  -- output toggle point1
// bit 7:0   -- output toggle point0 (0xff means input)
#define STREAM_OUTPUT_CONFIG                       ((0x2c01  << 2) + 0xffd00000)
// bit 31:24 -- clock_divide_ext
// bit 23:20 -- s_bus_start ( sclk, sdataout, sdatain)  // 0 means no s_bus used
// bit 19    -- no_sclk_on_pin // will use internal write clock and read clock (like RS232)
// bit 18    -- invert_sclk_in
// bit 17    -- sdata_send_busy  // indicate one data is sending -- read only
// bit 16    -- one_sdata_received // set when one sdata is received, can write 0 to clear
// bit 15    -- sdata_parity  // (write -- 0-even, 1-odd) (read -- received parity check)
// bit 14    -- sdata_send_type  // 0 -- 8 bits  1 -- 32 bits ( for fujitsu only )
// bit 13    -- sdata_receive_type // 0 -- 8 bits only  1 -- 8/32 bits
// bit 12    -- invert_request_out
// bit 11:8  -- request_out_sel  // 0 means disable output
// bit 7:0   --  stop_request_count
#define C_D_BUS_CONTROL                            ((0x2c02  << 2) + 0xffd00000)
// bit 31:0  -- serial data (write: output one data, read: input data)
#define C_DATA                                     ((0x2c03  << 2) + 0xffd00000)
// bit 31:28 bus_width_1
// bit 27:24 bus_start_pin_1
// bit 23:16 bus_sel_chang_point_1
// bit 15:12 bus_width_0
// bit 11:08 bus_start_pin_0
// bit 07:00 bus_sel_chang_point_0
#define STREAM_BUS_CONFIG                          ((0x2c04  << 2) + 0xffd00000)
// bit 31:24 clock_divide
// bit 23:20 clock_output_sel  -- 0 means disable clock output
// bit 19 -- inc_event_addr
// bit 18 -- async_fifo_endian
// bit 17 -- send_to_async_fifo
// bit 16 -- data_in_serial_lsb
// bit 15 -- invert_no_wait_condition_0
// bit 14 -- invert_no_wait_condition_1
// bit 13 -- invert_no_wait_condition_2
// bit 12 -- invert_data_bus
// bit 11 -- invert_clock_in
// bit 10 -- event_wait_clk_en
// bit 9 -- data_in_serial
// bit 8 -- invert_data_in_clk
// bit 7:4  -- data_in_begin
// bit 3:0  -- data_in_clk_sel
#define STREAM_DATA_IN_CONFIG                      ((0x2c05  << 2) + 0xffd00000)
// wait condition and irq should not be connected to 0, 0 means disable)
// bit 31:28 -- no_wait_condition_0   (0 means disable this condition)
// bit 27:24 -- no_wait_condition_1   (0 means disable this condition)
// bit 23:20 -- no_wait_condition_2   (0 means disable this condition)
// bit 19:16 -- irq_input_sel         (0 means disable this interrupt)
// bit 15:13 -- interrupt_status (read) clear status (write) (ext 0, ext 1, transfer end)
// bit 12 -- enable_sdata_irq
// bit 11 -- invert_irq_0
// bit 10 -- invert_irq_1
// bit  9 -- enable_transfer_end_irq
// bit  8 -- enable_second_ext_irq
// bit 7:0 -- no_wait_condition_check_point (0xff means no check)
#define STREAM_WAIT_IRQ_CONFIG                     ((0x2c06  << 2) + 0xffd00000)
// bit 31:24 -- event address
// bit 23:16 -- event data
// bit 15:1 -- event repeat times  (0 means one time event)
// bit 0  -- Start Event (write) event_busy (read)
#define STREAM_EVENT_CTL                           ((0x2c07  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  SYNC_FIFO_CBUS_BASE = 0x28
// -----------------------------------------------
#define ASYNC_FIFO_REG0                            ((0x2800  << 2) + 0xffd00000)
#define ASYNC_FIFO_REG1                            ((0x2801  << 2) + 0xffd00000)
    #define ASYNC_FIFO_FLUSH_STATUS     31
    #define ASYNC_FIFO_ERR              30
    #define ASYNC_FIFO_FIFO_EMPTY       29
    #define ASYNC_FIFO_TO_HIU           24
    #define ASYNC_FIFO_FLUSH            23
    #define ASYNC_FIFO_RESET            22
    #define ASYNC_FIFO_WRAP_EN          21
    #define ASYNC_FIFO_FLUSH_EN         20
    #define ASYNC_FIFO_RESIDUAL_MSB     19
    #define ASYNC_FIFO_RESIDUAL_LSB     15
    #define ASYNC_FIFO_FLUSH_CNT_MSB    14
    #define ASYNC_FIFO_FLUSH_CNT_LSB    0
#define ASYNC_FIFO_REG2                            ((0x2802  << 2) + 0xffd00000)
    #define ASYNC_FIFO_FIFO_FULL        26
    #define ASYNC_FIFO_FILL_STATUS      25
    #define ASYNC_FIFO_SOURCE_MSB       24
    #define ASYNC_FIFO_SOURCE_LSB       23
    #define ASYNC_FIFO_ENDIAN_MSB       22
    #define ASYNC_FIFO_ENDIAN_LSB       21
    #define ASYNC_FIFO_FILL_EN          20
    #define ASYNC_FIFO_FILL_CNT_MSB     19
    #define ASYNC_FIFO_FILL_CNT_LSB     0
#define ASYNC_FIFO_REG3                            ((0x2803  << 2) + 0xffd00000)
    #define ASYNC_FLUSH_SIZE_IRQ_MSB    15
    #define ASYNC_FLUSH_SIZE_IRQ_LSB    0
#define ASYNC_FIFO_REG4                            ((0x2804  << 2) + 0xffd00000)
#define ASYNC_FIFO_REG5                            ((0x2805  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  SYNC_FIFO2_CBUS_BASE = 0x24
// -----------------------------------------------
#define ASYNC_FIFO2_REG0                           ((0x2400  << 2) + 0xffd00000)
#define ASYNC_FIFO2_REG1                           ((0x2401  << 2) + 0xffd00000)
#define ASYNC_FIFO2_REG2                           ((0x2402  << 2) + 0xffd00000)
#define ASYNC_FIFO2_REG3                           ((0x2403  << 2) + 0xffd00000)
#define ASYNC_FIFO2_REG4                           ((0x2404  << 2) + 0xffd00000)
#define ASYNC_FIFO2_REG5                           ((0x2405  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  SPIFC_CBUS_BASE = 0x50
// -----------------------------------------------
#define SPI_FLASH_CMD                              ((0x5000  << 2) + 0xffd00000)
    #define SPI_FLASH_READ    31
    #define SPI_FLASH_WREN    30
    #define SPI_FLASH_WRDI    29
    #define SPI_FLASH_RDID    28
    #define SPI_FLASH_RDSR    27
    #define SPI_FLASH_WRSR    26
    #define SPI_FLASH_PP      25
    #define SPI_FLASH_SE      24
    #define SPI_FLASH_BE      23
    #define SPI_FLASH_CE      22
    #define SPI_FLASH_DP      21
    #define SPI_FLASH_RES     20
    #define SPI_HPM           19
    #define SPI_FLASH_USR     18
    #define SPI_FLASH_USR_ADDR 15
    #define SPI_FLASH_USR_DUMMY 14
    #define SPI_FLASH_USR_DIN   13
    #define SPI_FLASH_USR_DOUT   12
    #define SPI_FLASH_USR_DUMMY_BLEN   10
    #define SPI_FLASH_USR_CMD     0
#define SPI_FLASH_ADDR                             ((0x5001  << 2) + 0xffd00000)
    #define SPI_FLASH_BYTES_LEN 24
    #define SPI_FLASH_ADDR_START 0
#define SPI_FLASH_CTRL                             ((0x5002  << 2) + 0xffd00000)
    #define SPI_ENABLE_AHB    17
    #define SPI_SST_AAI       16
    #define SPI_RES_RID       15
    #define SPI_FREAD_DUAL    14
    #define SPI_READ_READ_EN  13
    #define SPI_CLK_DIV0      12
    #define SPI_CLKCNT_N      8
    #define SPI_CLKCNT_H      4
    #define SPI_CLKCNT_L      0
#define SPI_FLASH_CTRL1                            ((0x5003  << 2) + 0xffd00000)
#define SPI_FLASH_STATUS                           ((0x5004  << 2) + 0xffd00000)
#define SPI_FLASH_CTRL2                            ((0x5005  << 2) + 0xffd00000)
#define SPI_FLASH_CLOCK                            ((0x5006  << 2) + 0xffd00000)
#define SPI_FLASH_USER                             ((0x5007  << 2) + 0xffd00000)
#define SPI_FLASH_USER1                            ((0x5008  << 2) + 0xffd00000)
#define SPI_FLASH_USER2                            ((0x5009  << 2) + 0xffd00000)
#define SPI_FLASH_USER3                            ((0x500a  << 2) + 0xffd00000)
#define SPI_FLASH_USER4                            ((0x500b  << 2) + 0xffd00000)
#define SPI_FLASH_SLAVE                            ((0x500c  << 2) + 0xffd00000)
#define SPI_FLASH_SLAVE1                           ((0x500d  << 2) + 0xffd00000)
#define SPI_FLASH_SLAVE2                           ((0x500e  << 2) + 0xffd00000)
#define SPI_FLASH_SLAVE3                           ((0x500f  << 2) + 0xffd00000)
#define SPI_FLASH_C0                               ((0x5010  << 2) + 0xffd00000)
#define SPI_FLASH_C1                               ((0x5011  << 2) + 0xffd00000)
#define SPI_FLASH_C2                               ((0x5012  << 2) + 0xffd00000)
#define SPI_FLASH_C3                               ((0x5013  << 2) + 0xffd00000)
#define SPI_FLASH_C4                               ((0x5014  << 2) + 0xffd00000)
#define SPI_FLASH_C5                               ((0x5015  << 2) + 0xffd00000)
#define SPI_FLASH_C6                               ((0x5016  << 2) + 0xffd00000)
#define SPI_FLASH_C7                               ((0x5017  << 2) + 0xffd00000)
#define SPI_FLASH_B8                               ((0x5018  << 2) + 0xffd00000)
#define SPI_FLASH_B9                               ((0x5019  << 2) + 0xffd00000)
#define SPI_FLASH_B10                              ((0x501a  << 2) + 0xffd00000)
#define SPI_FLASH_B11                              ((0x501b  << 2) + 0xffd00000)
#define SPI_FLASH_B12                              ((0x501c  << 2) + 0xffd00000)
#define SPI_FLASH_B13                              ((0x501d  << 2) + 0xffd00000)
#define SPI_FLASH_B14                              ((0x501e  << 2) + 0xffd00000)
#define SPI_FLASH_B15                              ((0x501f  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
//spicc 0
// -----------------------------------------------
// CBUS_BASE:  SPICC0_CBUS_BASE = 0x4c
// -----------------------------------------------
#define SPICC0_RXDATA                              ((0x4c00  << 2) + 0xffd00000)
#define SPICC0_TXDATA                              ((0x4c01  << 2) + 0xffd00000)
#define SPICC0_CONREG                              ((0x4c02  << 2) + 0xffd00000)
#define SPICC0_INTREG                              ((0x4c03  << 2) + 0xffd00000)
#define SPICC0_DMAREG                              ((0x4c04  << 2) + 0xffd00000)
#define SPICC0_STATREG                             ((0x4c05  << 2) + 0xffd00000)
#define SPICC0_PERIODREG                           ((0x4c06  << 2) + 0xffd00000)
#define SPICC0_TESTREG                             ((0x4c07  << 2) + 0xffd00000)
#define SPICC0_DRADDR                              ((0x4c08  << 2) + 0xffd00000)
#define SPICC0_DWADDR                              ((0x4c09  << 2) + 0xffd00000)
#define SPICC0_LD_CNTL0                            ((0x4c0a  << 2) + 0xffd00000)
#define SPICC0_LD_CNTL1                            ((0x4c0b  << 2) + 0xffd00000)
#define SPICC0_LD_RADDR                            ((0x4c0c  << 2) + 0xffd00000)
#define SPICC0_LD_WADDR                            ((0x4c0d  << 2) + 0xffd00000)
#define SPICC0_ENHANCE_CNTL                        ((0x4c0e  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
//spicc 1
// -----------------------------------------------
// CBUS_BASE:  SPICC1_CBUS_BASE = 0x54
// -----------------------------------------------
#define SPICC1_RXDATA                              ((0x5400  << 2) + 0xffd00000)
#define SPICC1_TXDATA                              ((0x5401  << 2) + 0xffd00000)
#define SPICC1_CONREG                              ((0x5402  << 2) + 0xffd00000)
#define SPICC1_INTREG                              ((0x5403  << 2) + 0xffd00000)
#define SPICC1_DMAREG                              ((0x5404  << 2) + 0xffd00000)
#define SPICC1_STATREG                             ((0x5405  << 2) + 0xffd00000)
#define SPICC1_PERIODREG                           ((0x5406  << 2) + 0xffd00000)
#define SPICC1_TESTREG                             ((0x5407  << 2) + 0xffd00000)
#define SPICC1_DRADDR                              ((0x5408  << 2) + 0xffd00000)
#define SPICC1_DWADDR                              ((0x5409  << 2) + 0xffd00000)
#define SPICC1_LD_CNTL0                            ((0x540a  << 2) + 0xffd00000)
#define SPICC1_LD_CNTL1                            ((0x540b  << 2) + 0xffd00000)
#define SPICC1_LD_RADDR                            ((0x540c  << 2) + 0xffd00000)
#define SPICC1_LD_WADDR                            ((0x540d  << 2) + 0xffd00000)
#define SPICC1_ENHANCE_CNTL                        ((0x540e  << 2) + 0xffd00000)
//
//// -------------------------------------------------------------------
//// PSEL Group #1:  0x400 ~ 0x7FF
//// -------------------------------------------------------------------
//`define  PERIPHS1_CBUS_BASE   8'h28
//
//
//
//// ----------------------------
//// IR Remote (8)
//// ----------------------------
//`define IR_DEC_LDR_ACTIVE               8'h20
//`define IR_DEC_LDR_IDLE                 8'h21
//`define IR_DEC_LDR_REPEAT               8'h22
//`define IR_DEC_BIT_0                    8'h23
//`define IR_DEC_REG0                     8'h24
//`define IR_DEC_FRAME                    8'h25
//`define IR_DEC_STATUS                   8'h26
//`define IR_DEC_REG1                     8'h27
//
//// ----------------------------
//// Demod Sampling
//// ----------------------------
//`define DEMOD_ADC_SAMPLING               8'h2d
//// ----------------------------
//// WIFI
//// ----------------------------
//// `define WIFI_ADC_SAMPLING               8'h2e
//// `define WIFI_ADC_READBACK               8'h2f
//
//
//// ---------------------------
//// EFUSE (4)
//// ----------------------------
//// Moved to the Secure APB3 bus
//// `define EFUSE_CNTL0                     8'h58
//// `define EFUSE_CNTL1                     8'h59
//// `define EFUSE_CNTL2                     8'h5a
//// `define EFUSE_CNTL3                     8'h5b
//// `define EFUSE_CNTL4                     8'h5c
//
//// ---------------------------------------------
//// Separate APB slave that shares the CBUS/APB
//// register space of the static registers
//// ---------------------------------------------
//
//`define ATAPI_IDEREG0                   8'h60
//   `define IDE_UDMA_PIO_STATE         15
//   `define IDE_BUSY                   14
//   `define IDE_ERROR_BIT              13
//   `define IDE_DMARQ_BIT              12
//   `define IDE_IORDY_BIT              11
//   `define IDE_IORDY_EN_BIT           10
//   `define IDE_DIS_CSEL_BIT            9
//   `define IDE_CSEL_BIT                8
//   `define IDE_IRQ14                   2
//   `define IDE_ATAPI_GPIO_EN           3
//   `define IDE_DMARQ_FULL              1
//   `define IDE_ENABLE                  0
//`define ATAPI_IDEREG1                   8'h61
//`define ATAPI_IDEREG2                   8'h62
//    `define IDE_XFER_CNT_MSB_BIT      18
//    `define IDE_XFER_CNT_LSB_BIT       0
//`define ATAPI_CYCTIME                   8'h63
//`define ATAPI_IDETIME                   8'h64
//`define ATAPI_PIO_TIMING                8'h65
//`define ATAPI_TABLE_ADD_REG             8'h66
//`define ATAPI_IDEREG3                   8'h67
//`define ATAPI_UDMA_REG0                 8'h68
//`define ATAPI_UDMA_REG1                 8'h69
//
//// Room for registers here
//
//`define TRANS_PWMA_REG0                 8'h70
//`define TRANS_PWMA_REG1                 8'h71
//`define TRANS_PWMA_MUX0                 8'h72
//`define TRANS_PWMA_MUX1                 8'h73
//`define TRANS_PWMA_MUX2                 8'h74
//`define TRANS_PWMA_MUX3                 8'h75
//`define TRANS_PWMA_MUX4                 8'h76
//`define TRANS_PWMA_MUX5                 8'h77
//
//`define TRANS_PWMB_REG0                 8'h78
//`define TRANS_PWMB_REG1                 8'h79
//`define TRANS_PWMB_MUX0                 8'h7a
//`define TRANS_PWMB_MUX1                 8'h7b
//`define TRANS_PWMB_MUX2                 8'h7c
//`define TRANS_PWMB_MUX3                 8'h7d
//`define TRANS_PWMB_MUX4                 8'h7e
//`define TRANS_PWMB_MUX5                 8'h7f
//
//
//
//// ----------------------------
//// NAND (21)
//// ----------------------------
//`define NAND_START                      8'h80
//`define NAND_ADR_CMD                    8'h8a
//`define NAND_ADR_STS                    8'h8b
//`define NAND_END                        8'h8f
//
//// ----------------------------
//// ISP_FLASH_LED_CTRL
//// ----------------------------
////bit 31, reg_led_en //rising pulse start, falling pulse stop for torch mode
////bit 30, reg_inc_i_st_lat //for as3685, dynamic increase current during st_latch
////bit 29:28, reg_inv_en_pol //bit[29], invert en1, bit [28], invert en2
////bit 27, reg_switch_en1en2  //switch output en1 and en2. For IS3231: en1 is EN, en2 is mode.
////bit 26, reg_force_off_mode //1: reset state machine at the falling edge no matter which state it is in
////bit 25, reg_hold_nonstd_off_mode //hold the non-std led_off signal input before state "OFF"
////bit 24, reg_flash_mode_timeout_en  //force to exit the Tlat state when time out, for flash mode protection
////bit 23, reg_en1_st_ini_level //en1 level during state ST_INI
////bit 22, reg_en2_st_set_mp_level //en2 level during state ST_SET_MP_HI, ST_SET_MP_LO
////bit 21, reg_en1_st_off_level //en1 level during state ST_OFF
////bit 20, reg_en2_st_off_level //en2 level during state ST_OFF
////bit 19:12, reg_en1_mp_num  //en1 multi pulse number, up to 256 step current control
////bit 10:0, reg_t_st_ini //Max: 85.2 us under 24M clock input
//`define ISP_LED_CTRL                    8'h98
//
////bit 31:21, reg_t_en1_inc_i_st_lat_cnt //Max: 85.2us under 24M. for as3685, dynamic increase current during st_latch
////bit 20:10, reg_t_en2_lo_st_ini //Max: 85.2 us under 24M clock input
////bit 9:0, reg_t_en2_hi1_st_lat_cnt //42.62us @24M, EN2 can output hi-lo-hi during ST_LATCH, this is the first lo -duration
//`define ISP_LED_TIMING1                 8'h99
//
////bit 31:21, reg_t_en1_mp_hi_cnt //Max: 85.2 us under 24M clock input, mp means multi pulse
////bit 20:10, reg_t_en1_mp_lo_cnt //Max: 85.2 us under 24M clock input, mp means multi pulse
////bit 9:0, reg_t_en2_lo1_st_lat_cnt //42.62us @24M, EN2 can output hi-lo-hi during ST_LATCH, this is the first lo -duration
//`define ISP_LED_TIMING2                 8'h9a
//
////bit 30:28, RO state
////bit 25:0, reg_flash_mode_timeout_cnt //up to 2.79s at 24Mhz clk input
//`define ISP_LED_TIMING3                 8'h9b
//
////bit 25:0, reg_t_st_lat_cnt //up to 2.79s, keep the led on if it's 26'h3ffffff under torch mode
//`define ISP_LED_TIMING4                 8'h9c
//
////bit 31:26, reg_t_st_off_cnt[5:0] //up to 85.2us OFF state.
////bit 25:0, reg_t_en2_hi2_st_lat_cnt //EN2 can output hi-lo-hi during ST_LATCH, this is the second hi -duration
//`define ISP_LED_TIMING5                 8'h9d
//
////bit 30:26, reg_t_st_off_cnt[10:6] //up to 85.2us OFF state.
////bit 25:0, reg_t_en1_st_lat_hold_cnt //to make sure Tlat to meat it's minimum request 500us (since non-std led_off signal may comes in anytime)
//`define ISP_LED_TIMING6                 8'h9e
//// ----------------------------
//// SAR ADC (16)
//// ----------------------------
////`define SAR_ADC_REG0                    8'ha0
////`define SAR_ADC_CHAN_LIST               8'ha1
////`define SAR_ADC_AVG_CNTL                8'ha2
////`define SAR_ADC_REG3                    8'ha3
////`define SAR_ADC_DELAY                   8'ha4
////`define SAR_ADC_LAST_RD                 8'ha5
////`define SAR_ADC_FIFO_RD                 8'ha6
////`define SAR_ADC_AUX_SW                  8'ha7
////`define SAR_ADC_CHAN_10_SW              8'ha8
////`define SAR_ADC_DETECT_IDLE_SW          8'ha9
////`define SAR_ADC_DELTA_10                8'haa
////`define SAR_ADC_REG11                   8'hab
////`define SAR_ADC_REG12                   8'hac
////`define SAR_ADC_REG13                   8'had
//
//// ----------------------------
//// CTouch (16)
//// ----------------------------
//
//
//// ---------------------------
//// RTC (4)
//// ---------------------------
//`define RTC_ADDR0                      8'hd0
//`define RTC_ADDR1                      8'hd1
//`define RTC_ADDR2                      8'hd2
//`define RTC_ADDR3                      8'hd3
//`define RTC_ADDR4                      8'hd4
//// ----------------------------
//// clock measure (4)
//// ----------------------------
//
//
//
//// -------------------------------------------------------------------
//// PSEL Group #2:  0x800 ~ 0xbFF
//// -------------------------------------------------------------------
//`define  PERIPHS2_CBUS_BASE   8'h2c
//
//`define USB_ADDR0                      8'h00
//`define USB_ADDR1                      8'h01
//`define USB_ADDR2                      8'h02
//`define USB_ADDR3                      8'h03
//`define USB_ADDR4                      8'h04
//`define USB_ADDR5                      8'h05
//`define USB_ADDR6                      8'h06
//`define USB_ADDR7                      8'h07
//`define USB_ADDR8                      8'h08
//`define USB_ADDR9                      8'h09
//`define USB_ADDR10                     8'h0a
//`define USB_ADDR11                     8'h0b
//`define USB_ADDR12                     8'h0c
//`define USB_ADDR13                     8'h0d
//`define USB_ADDR14                     8'h0e
//`define USB_ADDR15                     8'h0f
//
//`define USB_ADDR16                     8'h10
//`define USB_ADDR17                     8'h11
//`define USB_ADDR18                     8'h12
//`define USB_ADDR19                     8'h13
//`define USB_ADDR20                     8'h14
//`define USB_ADDR21                     8'h15
//`define USB_ADDR22                     8'h16
//`define USB_ADDR23                     8'h17
//`define USB_ADDR24                     8'h18
//`define USB_ADDR25                     8'h19
//`define USB_ADDR26                     8'h1a
//`define USB_ADDR27                     8'h1b
//`define USB_ADDR28                     8'h1c
//`define USB_ADDR29                     8'h1d
//`define USB_ADDR30                     8'h1e
//`define USB_ADDR31                     8'h1f
//
//
//
//
//
//// -------------------------------------------------------------------
//// PSEL Group #3:  0xc00 ~ 0xFFF
//// -------------------------------------------------------------------
//`define  PERIPHS3_CBUS_BASE   8'h30
//
//// ---------------------------
//// SDIO (8)
//// ---------------------------
//// `define C_SDIO_HIGH16                   8'h00
//// bit 31:0 -- cmd_argument/MS_SHORT_DATA_WRITE
//`define CMD_ARGUMENT                    8'h08
//// bit 31:24 -- repeat_package_times/MS_SHORT_DATA_WRITE_NUMBER
//// bit 21   -- use_int_window
//// bit 20   -- cmd_send_data/MS_HAVE_LONG_DATA_WRITE
//// bit 19   -- check_busy_on_dat0 (used for R1b response)
//// bit 18   -- response_crc7_from_8
//// bit 17   -- response_have_data/MS_HAVE_LONG_DATA_READ
//// bit 16   -- response_do_not_have_crc7/MS_SHORT_DATA_DO_NOT_HAVE_CRC16
//// bit 15:8 -- cmd_response_bits (00 means no response) /MS_SHORT_DATA_READ_NUMBER
//// bit 7:0 -- cmd_command/MS_TPC
//`define CMD_SEND                        8'h09
//// bit 31:29 -- sdio_write_CRC_ok_status
//// bit 28:23 -- sdio_write_Nwr
//// bit 22:21 -- m_endian
//// bit 20    -- bus_width
//// bit 19    -- data_latch_at_negedge (normally at posedge)
//// bit 18    -- do_not_delay_data (normally delay one clock)
//// bit 17:12 -- cmd_argument_bits (before CRC, normally : 39)
//// bit 11 -- cmd_out_at_posedge (normally at negedge)
//// bit 10 -- cmd_disable_CRC
//// bit 9:0 -- cmd_clk_divide
//`define SDIO_CONFIG                     8'h0a
//// bit 31:19 -- sdio_timing_out_count
//// bit 18 -- arc_timing_out_int_en
//// bit 17 -- amrisc_timing_out_int_en
//// bit 16 -- sdio_timig_out_int   -- write 1 clear this int bit
//// bit 15:12 -- sdio_status_info  -- used for change infor between ARC and Amrisc
//// bit 11 -- sdio_set_soft_int -- write 1 to this bit will set sdio_soft_int , read out is m_req_sdio
//// bit 10 -- sdio_soft_int   -- write 1 clear this int bit
//// bit 9 -- sdio_cmd_int   -- write 1 clear this int bit
//// bit 8 -- sdio_if_int   -- write 1 clear this int bit
//// bit 7 -- sdio_data_write_crc16_ok -- Read-Only
//// bit 6 -- sdio_data_read_crc16_ok  -- Read-Only
//// bit 5 -- sdio_response_crc7_ok    -- Read-Only
//// bit 4 -- sdio_cmd_busy            -- Read-Only
//// bit 3:0 -- sdio_status            -- Read-Only
//`define SDIO_STATUS_IRQ                 8'h0b
//// bit 31 -- halt_hole 0 -- 8 bits 1 -- 16 bits
//// bit 30 -- force_halt
//// bit 29:24 -- sdio_force_data_read (read_only)
//// bit 23:22 -- disable_mem_halt (write and read)
//// bit 21:16 -- sdio_force_output_en
//// bit 15 -- soft_reset
//// bit 14 -- sdio_force_enable
//// bit 13:8 -- sdio_force_data/sdio_read_data
//// bit 7:6 -- sdio_if_int_config
//// bit 5 -- arc_soft_int_en
//// bit 4 -- arc_cmd_int_en
//// bit 3 -- arc_if_int_en
//// bit 2 -- amrisc_soft_int_en
//// bit 1 -- amrisc_cmd_int_en
//// bit 0 -- amrisc_if_int_en
//`define SDIO_IRQ_CONFIG                 8'h0c
//// bit 27:16 -- data_catch_finish_point
//// (
//// bit 15:12 -- response_read_index
//// bit 9 -- data_catch_readout_en
//// bit 8 -- write_read_out_index
//// ) this bits only write when write_read_out_index = 1
//// bit 11 -- sdio_1_data_swap01
//// bit 10 -- sdio_0_data_on_1
//// bit 7:6 -- data_catch_level
//// bit 5 -- stream_8_bits_mode
//// bit 4 -- stream_enable
//// bit 3 -- ms_sclk_always
//// bit 2 -- ms_enable
//// bit 1:0 -- SDIO_port_sel //00-sdio1, 01-sdio2, 02-sdio3
//`define SDIO_MULT_CONFIG                8'h0d
//// bit 31:0 -- m_addr_sdio
//`define SDIO_M_ADDR                     8'h0e
//// bit 31    -- CRC_status_4line
//// bit 30    -- data_rw_do_not_have_crc16/MS_LONG_DATA_DO_NOT_HAVE_CRC16
//// bit 29:16 -- data_rw_number/MS_LONG_DATA_NUMBER
//// bit 15:0 -- cmd_argument_ext/MS_SHORT_DATA_EXTENSION
//`define SDIO_EXTENSION                  8'h0f
//// ----------------------------
//// SDIO_AHB_CBUS (2)
//// ----------------------------
//// bit   17    -- arc_ahb_cbus_int_en
//// bit   16    -- amrisc_ahb_cbus_int_en
//// bit 15:8    -- SDIO_FIFO_count
//// bit  7:4    -- m_req_count
//// bit    3    -- reserved
//// bit    2    -- m_write_cbus
//// bit    1    -- m_req_cbus
//// bit    0    -- sdio_ahb_cbus_enable
//`define SDIO_AHB_CBUS_CTRL             8'h18
//// m_rd_data[31:0] when (m_write_cbus == 0)  CBUS write
//// m_wr_data[31:0] when (m_write_cbus == 1)  CBUS read
//`define SDIO_AHB_CBUS_M_DATA           8'h19
//
//
//// ----------------------------
//// SDHC (SDIO #2)
//// ----------------------------
//`define SD_REG0_ARGU    8'h80
//`define SD_REG1_SEND    8'h81
//`define SD_REG2_CNTL    8'h82
//`define SD_REG3_STAT    8'h83
//`define SD_REG4_CLKC    8'h84
//`define SD_REG5_ADDR    8'h85
//`define SD_REG6_PDMA    8'h86
//`define SD_REG7_MISC    8'h87
//`define SD_REG8_DATA    8'h88
//`define SD_REG9_ICTL    8'h89
//`define SD_REGA_ISTA    8'h8a
//`define SD_REGB_SRST    8'h8b
//`define SD_REGC_ESTA    8'h8c
//`define SD_REGD_ENHC    8'h8d
//`define SD_REGE_CLK2    8'h8e
//
//
// Closing file:  periphs_reg.h
//
//
// Reading file:  isa_reg.h
//
// $isa/rtl/isa_core register defines for the APB bus
// CBUS base slave address
// -----------------------------------------------
// CBUS_BASE:  ISA_CBUS_BASE = 0x3c
// -----------------------------------------------
// Up to 256 registers for this base
#define ISA_DEBUG_REG0                             ((0x3c00  << 2) + 0xffd00000)
#define ISA_DEBUG_REG1                             ((0x3c01  << 2) + 0xffd00000)
#define ISA_DEBUG_REG2                             ((0x3c02  << 2) + 0xffd00000)
#define ISA_DEBUG_REG3                             ((0x3c03  << 2) + 0xffd00000)
#define ISA_PLL_CLK_SIM0                           ((0x3c08  << 2) + 0xffd00000)
#define ISA_CNTL_REG0                              ((0x3c09  << 2) + 0xffd00000)
// -----------------------------------------------------------
#define AO_CPU_IRQ_IN0_INTR_STAT                   ((0x3c10  << 2) + 0xffd00000)
#define AO_CPU_IRQ_IN0_INTR_STAT_CLR               ((0x3c11  << 2) + 0xffd00000)
#define AO_CPU_IRQ_IN0_INTR_MASK                   ((0x3c12  << 2) + 0xffd00000)
#define AO_CPU_IRQ_IN0_INTR_FIRQ_SEL               ((0x3c13  << 2) + 0xffd00000)
// define MEDIA_CPU_IRQ_IN1_INTR_STAT           8'h14
// define MEDIA_CPU_IRQ_IN1_INTR_STAT_CLR       8'h15
// define MEDIA_CPU_IRQ_IN1_INTR_MASK           8'h16
// define MEDIA_CPU_IRQ_IN1_INTR_FIRQ_SEL       8'h17
//
// define MEDIA_CPU_IRQ_IN2_INTR_STAT              8'h18
// define MEDIA_CPU_IRQ_IN2_INTR_STAT_CLR          8'h19
// define MEDIA_CPU_IRQ_IN2_INTR_MASK              8'h1a
// define MEDIA_CPU_IRQ_IN2_INTR_FIRQ_SEL          8'h1b
//
// define MEDIA_CPU_IRQ_IN3_INTR_STAT            8'h1c
// define MEDIA_CPU_IRQ_IN3_INTR_STAT_CLR        8'h1d
// define MEDIA_CPU_IRQ_IN3_INTR_MASK            8'h1e
// define MEDIA_CPU_IRQ_IN3_INTR_FIRQ_SEL        8'h1f
#define GPIO_INTR_EDGE_POL                         ((0x3c20  << 2) + 0xffd00000)
#define GPIO_INTR_GPIO_SEL0                        ((0x3c21  << 2) + 0xffd00000)
#define GPIO_INTR_GPIO_SEL1                        ((0x3c22  << 2) + 0xffd00000)
#define GPIO_INTR_FILTER_SEL0                      ((0x3c23  << 2) + 0xffd00000)
// `define GLOBAL_INTR_DISABLE                 8'h24    never used
#define CVBS_IRQ0_CNTL                             ((0x3c24  << 2) + 0xffd00000)
#define CVBS_IRQ1_CNTL                             ((0x3c25  << 2) + 0xffd00000)
#define CVBS_IRQ0_COUNTER                          ((0x3c26  << 2) + 0xffd00000)
#define CVBS_IRQ1_COUNTER                          ((0x3c27  << 2) + 0xffd00000)
#define MEDIA_CPU_INTR_STAT                        ((0x3c28  << 2) + 0xffd00000)
#define MEDIA_CPU_INTR_STAT_CLR                    ((0x3c29  << 2) + 0xffd00000)
#define MEDIA_CPU_INTR_MASK                        ((0x3c2a  << 2) + 0xffd00000)
#define MEDIA_CPU_INTR_FIRQ_SEL                    ((0x3c2b  << 2) + 0xffd00000)
// -----------------------------------------------------------
#define ISA_BIST_REG0                              ((0x3c30  << 2) + 0xffd00000)
#define ISA_BIST_REG1                              ((0x3c31  << 2) + 0xffd00000)
// -----------------------------------------------------------
#define WATCHDOG_CNTL                              ((0x3c34  << 2) + 0xffd00000)
#define WATCHDOG_CNTL1                             ((0x3c35  << 2) + 0xffd00000)
#define WATCHDOG_TCNT                              ((0x3c36  << 2) + 0xffd00000)
#define WATCHDOG_RESET                             ((0x3c37  << 2) + 0xffd00000)
// -----------------------------------------------------------
#define AHB_ARBITER_REG                            ((0x3c42  << 2) + 0xffd00000)
#define AHB_ARBDEC_REG                             ((0x3c43  << 2) + 0xffd00000)
#define AHB_ARBITER2_REG                           ((0x3c4a  << 2) + 0xffd00000)
#define DEVICE_MMCP_CNTL                           ((0x3c4b  << 2) + 0xffd00000)
#define AUDIO_MMCP_CNTL                            ((0x3c4c  << 2) + 0xffd00000)
// -----------------------------------------------------------
#define ISA_TIMER_MUX                              ((0x3c50  << 2) + 0xffd00000)
#define ISA_TIMERA                                 ((0x3c51  << 2) + 0xffd00000)
#define ISA_TIMERB                                 ((0x3c52  << 2) + 0xffd00000)
#define ISA_TIMERC                                 ((0x3c53  << 2) + 0xffd00000)
#define ISA_TIMERD                                 ((0x3c54  << 2) + 0xffd00000)
#define FBUF_ADDR                                  ((0x3c56  << 2) + 0xffd00000)
    #define VIDEO_FRM_BUF_MSB_BIT      23
    #define VIDEO_FRM_BUF_LSB_BIT       2
#define SDRAM_CTL0                                 ((0x3c57  << 2) + 0xffd00000)
#define SDRAM_CTL2                                 ((0x3c58  << 2) + 0xffd00000)
//`define AO_CPU_CTL                          8'h59
#define SDRAM_CTL4                                 ((0x3c5a  << 2) + 0xffd00000)
#define SDRAM_CTL5                                 ((0x3c5b  << 2) + 0xffd00000)
#define SDRAM_CTL6                                 ((0x3c5c  << 2) + 0xffd00000)
#define SDRAM_CTL7                                 ((0x3c5d  << 2) + 0xffd00000)
#define SDRAM_CTL8                                 ((0x3c5e  << 2) + 0xffd00000)
#define AHB_MP4_MC_CTL                             ((0x3c5f  << 2) + 0xffd00000)
#define MEDIA_CPU_PCR                              ((0x3c60  << 2) + 0xffd00000)
#define MEDIA_CPU_CTL                              ((0x3c61  << 2) + 0xffd00000)
#define ISA_TIMERE                                 ((0x3c62  << 2) + 0xffd00000)
#define ISA_TIMERE_HI                              ((0x3c63  << 2) + 0xffd00000)
#define ISA_TIMER_MUX1                             ((0x3c64  << 2) + 0xffd00000)
#define ISA_TIMERF                                 ((0x3c65  << 2) + 0xffd00000)
#define ISA_TIMERG                                 ((0x3c66  << 2) + 0xffd00000)
#define ISA_TIMERH                                 ((0x3c67  << 2) + 0xffd00000)
#define ISA_TIMERI                                 ((0x3c68  << 2) + 0xffd00000)
// ---------------------------------------------
#define ABUF_WR_CTL0                               ((0x3c70  << 2) + 0xffd00000)
    #define ABUF_WR_INT_EN	    31
    #define ABUF_WR_INT_POS_MSB      30
    #define ABUF_WR_INT_POS_LSB      16
    #define ABUF_WR_BLK_SIZE_MSB     14
    #define ABUF_WR_BLK_SIZE_LSB      0
#define ABUF_WR_CTL1                               ((0x3c71  << 2) + 0xffd00000)
    #define ABUF_WR_INT_EN	    31
    #define ABUF_WR_INT_POS_MSB      30
    #define ABUF_WR_INT_POS_LSB      16
    #define ABUF_WR_BLK_SIZE_MSB     14
    #define ABUF_WR_BLK_SIZE_LSB      0
#define ABUF_WR_CTL2                               ((0x3c72  << 2) + 0xffd00000)
    #define ABUF_WR_CUR_FF_CNT_MSB   21
    #define ABUF_WR_CUR_FF_CNT_LSB   16
    #define ABUF_WR_CUR_BLK_MSB      14
    #define ABUF_WR_CUR_BLK_LSB       0
#define ABUF_WR_CTL3                               ((0x3c73  << 2) + 0xffd00000)
    #define ABUF_WR_AHB_RST_PLS       3
    #define ABUF_WR_FF_CLR_PLS        2
    #define ABUF_WR_PLY_RPT_LVL	     1
    #define ABUF_WR_FF_PAUSE_LVL      0
#define ABUF_RD_CTL0                               ((0x3c74  << 2) + 0xffd00000)
#define ABUF_RD_CTL1                               ((0x3c75  << 2) + 0xffd00000)
    #define ABUF_RD_INT_EN	    31
    #define ABUF_RD_INT_POS_MSB      30
    #define ABUF_RD_INT_POS_LSB      16
    #define ABUF_RD_BLK_SIZE_MSB     14
    #define ABUF_RD_BLK_SIZE_LSB      0
#define ABUF_RD_CTL2                               ((0x3c76  << 2) + 0xffd00000)
    #define ABUF_RD_CUR_FF_CNT_MSB   21
    #define ABUF_RD_CUR_FF_CNT_LSB   16
    #define ABUF_RD_CUR_BLK_MSB      14
    #define ABUF_RD_CUR_BLK_LSB       0
#define ABUF_RD_CTL3                               ((0x3c77  << 2) + 0xffd00000)
    #define ABUF_RD_PLY_ONCE_PLS      4
    #define ABUF_RD_AHB_RST_PLS       3
    #define ABUF_RD_FF_CLR_PLS        2
    #define ABUF_RD_PLY_RPT_LVL	     1
    #define ABUF_RD_FF_PAUSE_LVL      0
#define ABUF_ARB_CTL0                              ((0x3c78  << 2) + 0xffd00000)
#define ABUF_FIFO_CTL0                             ((0x3c79  << 2) + 0xffd00000)
    #define AIUout_FIFO_THRESHOLD_MSB 11
    #define AIUout_FIFO_THRESHOLD_LSB 6
    #define AIUin_FIFO_THRESHOLD_MSB  5
    #define AIUin_FIFO_THRESHOLD_LSB  0
// ---------------------------------------------
#define AHB_BRIDGE_CNTL_WR                         ((0x3c80  << 2) + 0xffd00000)
#define AHB_BRIDGE_REMAP0                          ((0x3c81  << 2) + 0xffd00000)
#define AHB_BRIDGE_REMAP1                          ((0x3c82  << 2) + 0xffd00000)
#define AHB_BRIDGE_REMAP2                          ((0x3c83  << 2) + 0xffd00000)
#define AHB_BRIDGE_REMAP3                          ((0x3c84  << 2) + 0xffd00000)
#define AHB_BRIDGE_CNTL_REG1                       ((0x3c85  << 2) + 0xffd00000)
#define AHB_BRIDGE_CNTL_REG2                       ((0x3c86  << 2) + 0xffd00000)
// ---------------------------------------------
// ----------------------------------------------
// `define SYS_CPU_0_IRQ_IN0_INTR_STAT         8'h90
// `define SYS_CPU_0_IRQ_IN0_INTR_STAT_CLR     8'h91
// `define SYS_CPU_0_IRQ_IN0_INTR_MASK         8'h92
// `define SYS_CPU_0_IRQ_IN0_INTR_FIRQ_SEL     8'h93
// `define SYS_CPU_0_IRQ_IN1_INTR_STAT         8'h94
// `define SYS_CPU_0_IRQ_IN1_INTR_STAT_CLR     8'h95
// `define SYS_CPU_0_IRQ_IN1_INTR_MASK         8'h96
// `define SYS_CPU_0_IRQ_IN1_INTR_FIRQ_SEL     8'h97
// `define SYS_CPU_0_IRQ_IN2_INTR_STAT         8'h98
// `define SYS_CPU_0_IRQ_IN2_INTR_STAT_CLR     8'h99
// `define SYS_CPU_0_IRQ_IN2_INTR_MASK         8'h9a
// `define SYS_CPU_0_IRQ_IN2_INTR_FIRQ_SEL     8'h9b
// `define SYS_CPU_0_IRQ_IN3_INTR_STAT         8'h9c
// `define SYS_CPU_0_IRQ_IN3_INTR_STAT_CLR     8'h9d
// `define SYS_CPU_0_IRQ_IN3_INTR_MASK         8'h9e
// `define SYS_CPU_0_IRQ_IN3_INTR_FIRQ_SEL     8'h9f
// ----------------------------------------------
// `define SYS_CPU_1_IRQ_IN0_INTR_STAT         8'ha0
// `define SYS_CPU_1_IRQ_IN0_INTR_STAT_CLR     8'ha1
// `define SYS_CPU_1_IRQ_IN0_INTR_MASK         8'ha2
// `define SYS_CPU_1_IRQ_IN0_INTR_FIRQ_SEL     8'ha3
//
// `define SYS_CPU_1_IRQ_IN1_INTR_STAT         8'ha4
// `define SYS_CPU_1_IRQ_IN1_INTR_STAT_CLR     8'ha5
// `define SYS_CPU_1_IRQ_IN1_INTR_MASK         8'ha6
// `define SYS_CPU_1_IRQ_IN1_INTR_FIRQ_SEL     8'ha7
//
// `define SYS_CPU_1_IRQ_IN2_INTR_STAT         8'ha8
// `define SYS_CPU_1_IRQ_IN2_INTR_STAT_CLR     8'ha9
// `define SYS_CPU_1_IRQ_IN2_INTR_MASK         8'haa
// `define SYS_CPU_1_IRQ_IN2_INTR_FIRQ_SEL     8'hab
//
// `define SYS_CPU_1_IRQ_IN3_INTR_STAT         8'hac
// `define SYS_CPU_1_IRQ_IN3_INTR_STAT_CLR     8'had
// `define SYS_CPU_1_IRQ_IN3_INTR_MASK         8'hae
// `define SYS_CPU_1_IRQ_IN3_INTR_FIRQ_SEL     8'haf
// ----------------------------------------------
// `define MEDIA_CPU_IRQ_IN4_INTR_STAT         8'hb0
// `define MEDIA_CPU_IRQ_IN4_INTR_STAT_CLR     8'hb1
// `define MEDIA_CPU_IRQ_IN4_INTR_MASK         8'hb2
// `define MEDIA_CPU_IRQ_IN4_INTR_FIRQ_SEL     8'hb3
// `define SYS_CPU_0_IRQ_IN4_INTR_STAT         8'hb4
// `define SYS_CPU_0_IRQ_IN4_INTR_STAT_CLR     8'hb5
// `define SYS_CPU_0_IRQ_IN4_INTR_MASK         8'hb6
// `define SYS_CPU_0_IRQ_IN4_INTR_FIRQ_SEL     8'hb7
// `define SYS_CPU_1_IRQ_IN4_INTR_STAT         8'hb8
// `define SYS_CPU_1_IRQ_IN4_INTR_STAT_CLR     8'hb9
// `define SYS_CPU_1_IRQ_IN4_INTR_MASK         8'hba
// `define SYS_CPU_1_IRQ_IN4_INTR_FIRQ_SEL     8'hbb
// `define SYS_CPU_2_IRQ_IN4_INTR_STAT         8'hbc
// `define SYS_CPU_2_IRQ_IN4_INTR_STAT_CLR     8'hbd
// `define SYS_CPU_2_IRQ_IN4_INTR_MASK         8'hbe
// `define SYS_CPU_2_IRQ_IN4_INTR_FIRQ_SEL     8'hbf
// ----------------------------------------------
// `define SYS_CPU_2_IRQ_IN0_INTR_STAT         8'hc0
// `define SYS_CPU_2_IRQ_IN0_INTR_STAT_CLR     8'hc1
// `define SYS_CPU_2_IRQ_IN0_INTR_MASK         8'hc2
// `define SYS_CPU_2_IRQ_IN0_INTR_FIRQ_SEL     8'hc3
// `define SYS_CPU_2_IRQ_IN1_INTR_STAT         8'hc4
// `define SYS_CPU_2_IRQ_IN1_INTR_STAT_CLR     8'hc5
// `define SYS_CPU_2_IRQ_IN1_INTR_MASK         8'hc6
// `define SYS_CPU_2_IRQ_IN1_INTR_FIRQ_SEL     8'hc7
// `define SYS_CPU_2_IRQ_IN2_INTR_STAT         8'hc8
// `define SYS_CPU_2_IRQ_IN2_INTR_STAT_CLR     8'hc9
// `define SYS_CPU_2_IRQ_IN2_INTR_MASK         8'hca
// `define SYS_CPU_2_IRQ_IN2_INTR_FIRQ_SEL     8'hcb
// `define SYS_CPU_2_IRQ_IN3_INTR_STAT         8'hcc
// `define SYS_CPU_2_IRQ_IN3_INTR_STAT_CLR     8'hcd
// `define SYS_CPU_2_IRQ_IN3_INTR_MASK         8'hce
// `define SYS_CPU_2_IRQ_IN3_INTR_FIRQ_SEL     8'hcf
// ----------------------------------------------
// `define SYS_CPU_3_IRQ_IN0_INTR_STAT         8'hd0
// `define SYS_CPU_3_IRQ_IN0_INTR_STAT_CLR     8'hd1
// `define SYS_CPU_3_IRQ_IN0_INTR_MASK         8'hd2
// `define SYS_CPU_3_IRQ_IN0_INTR_FIRQ_SEL     8'hd3
// `define SYS_CPU_3_IRQ_IN1_INTR_STAT         8'hd4
// `define SYS_CPU_3_IRQ_IN1_INTR_STAT_CLR     8'hd5
// `define SYS_CPU_3_IRQ_IN1_INTR_MASK         8'hd6
// `define SYS_CPU_3_IRQ_IN1_INTR_FIRQ_SEL     8'hd7
// `define SYS_CPU_3_IRQ_IN2_INTR_STAT         8'hd8
// `define SYS_CPU_3_IRQ_IN2_INTR_STAT_CLR     8'hd9
// `define SYS_CPU_3_IRQ_IN2_INTR_MASK         8'hda
// `define SYS_CPU_3_IRQ_IN2_INTR_FIRQ_SEL     8'hdb
// `define SYS_CPU_3_IRQ_IN3_INTR_STAT         8'hdc
// `define SYS_CPU_3_IRQ_IN3_INTR_STAT_CLR     8'hdd
// `define SYS_CPU_3_IRQ_IN3_INTR_MASK         8'hde
// `define SYS_CPU_3_IRQ_IN3_INTR_FIRQ_SEL     8'hdf
// ----------------------------------------------
// `define SYS_CPU_3_IRQ_IN4_INTR_STAT         8'he0
// `define SYS_CPU_3_IRQ_IN4_INTR_STAT_CLR     8'he1
// `define SYS_CPU_3_IRQ_IN4_INTR_MASK         8'he2
// `define SYS_CPU_3_IRQ_IN4_INTR_FIRQ_SEL     8'he3
// `define MEDIA_CPU_IRQ_IN5_INTR_STAT         8'he4
// `define MEDIA_CPU_IRQ_IN5_INTR_STAT_CLR     8'he5
// `define MEDIA_CPU_IRQ_IN5_INTR_MASK         8'he6
// `define MEDIA_CPU_IRQ_IN5_INTR_FIRQ_SEL     8'he7
// `define SYS_CPU_0_IRQ_IN5_INTR_STAT         8'he8
// `define SYS_CPU_0_IRQ_IN5_INTR_STAT_CLR     8'he9
// `define SYS_CPU_0_IRQ_IN5_INTR_MASK         8'hea
// `define SYS_CPU_0_IRQ_IN5_INTR_FIRQ_SEL     8'heb
//
// Closing file:  isa_reg.h
//
//`include "bt656_reg.h"
//`include "pdm_reg.h"
//========================================================================
//  Global Control Registers			    (12'h000 - 12'h0ff)
//
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  RESET_CBUS_BASE = 0x04
// -----------------------------------------------
#define VERSION_CTRL                               ((0x0400  << 2) + 0xffd00000)
#define RESET0_REGISTER                            ((0x0401  << 2) + 0xffd00000)
#define RESET1_REGISTER                            ((0x0402  << 2) + 0xffd00000)
#define RESET2_REGISTER                            ((0x0403  << 2) + 0xffd00000)
#define RESET3_REGISTER                            ((0x0404  << 2) + 0xffd00000)
#define RESET4_REGISTER                            ((0x0405  << 2) + 0xffd00000)
#define RESET5_REGISTER                            ((0x0406  << 2) + 0xffd00000)
#define RESET6_REGISTER                            ((0x0407  << 2) + 0xffd00000)
#define RESET7_REGISTER                            ((0x0408  << 2) + 0xffd00000)
#define RESET0_MASK                                ((0x0410  << 2) + 0xffd00000)
#define RESET1_MASK                                ((0x0411  << 2) + 0xffd00000)
#define RESET2_MASK                                ((0x0412  << 2) + 0xffd00000)
#define RESET3_MASK                                ((0x0413  << 2) + 0xffd00000)
#define RESET4_MASK                                ((0x0414  << 2) + 0xffd00000)
#define RESET5_MASK                                ((0x0415  << 2) + 0xffd00000)
#define RESET6_MASK                                ((0x0416  << 2) + 0xffd00000)
#define CRT_MASK                                   ((0x0417  << 2) + 0xffd00000)
#define RESET7_MASK                                ((0x0418  << 2) + 0xffd00000)
#define RESET0_LEVEL                               ((0x0420  << 2) + 0xffd00000)
#define RESET1_LEVEL                               ((0x0421  << 2) + 0xffd00000)
#define RESET2_LEVEL                               ((0x0422  << 2) + 0xffd00000)
#define RESET3_LEVEL                               ((0x0423  << 2) + 0xffd00000)
#define RESET4_LEVEL                               ((0x0424  << 2) + 0xffd00000)
#define RESET5_LEVEL                               ((0x0425  << 2) + 0xffd00000)
#define RESET6_LEVEL                               ((0x0426  << 2) + 0xffd00000)
#define RESET7_LEVEL                               ((0x0427  << 2) + 0xffd00000)
//======================================
//  Reset Register Bits
//
//======================================
    #define HIU_RESET	    0x0001
    #define VLD_RESET	    0x0002
    #define IQIDCT_RESET	0x0004
    #define MC_RESET	    0x0008
    #define DCU_RESET	    0x0010
    #define VIU_RESET	    0x0020
    #define AIU_RESET	    0x0040
    #define CPU_RESET	    0x0080
    #define AC3_RESET	    0x0100
    #define MPEG_RESET	    0x0200
//-----------------------------------------------------------
// PARSER
//-----------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PARSER_CBUS_BASE = 0x38
// -----------------------------------------------
// bit 31:8 -- es_pack_size
// bit 7:6 -- es_type     00-Video, 01-Audio, 10-Subtitle
// bit 5 -- es_write
// bit 4 -- es_passthrough
// bit 3 -- insert_before_es_write
// bit 2 -- discard_cmd
// bit 1 -- search_cmd
// bit 0 -- Parser Busy
#define PARSER_CONTROL                             ((0x3860  << 2) + 0xffd00000)
// Write
//   bit 31:0 begin address for parser fetch
// Read
//   32 bit current fetch address
#define PARSER_FETCH_ADDR                          ((0x3861  << 2) + 0xffd00000)
// Write
//   bit 31 circle buffer indicator
//   bit 30 check_buffer_stop_addr
//   bit 29:27 fetch endian
//   bit 26:0 buffer size ( Bytes )
// Special command:
//   when bit 26:0 == 27'h0
//     then bit 29    -- stream_passthrough_enable
//          bit 28:27 -- stream_passthrough_type
// Read
//   6:5 cmd_rd_ptr
//   4:3 cmd_wr_ptr
//   2:0 cmd_number
#define PARSER_FETCH_CMD                           ((0x3862  << 2) + 0xffd00000)
// 31:0 stop_fetch_addr
#define PARSER_FETCH_STOP_ADDR                     ((0x3863  << 2) + 0xffd00000)
// 31:0 stop_fetch_addr - current_write_addr  // read only
#define PARSER_FETCH_LEVEL                         ((0x3864  << 2) + 0xffd00000)
// bit 31 - fetch_dma_urgent
// bit 30 - stream_dma_urgent
// bit 29 - force_pfifo_ren
// bit 28 - pfifo_peak_enable
// bit 27 - enable_free_clk_parser_reg
// bit 26 -
// bit 25:24 - parser_src_sel (00 - fetch, 01 - aux1, 10 - aux2 11 - aux3)
// bit 23:16 - pfifo_empty_count
// bit 15:12 - max_es_write_cycle (x16x64bits)
// 11:10 - start code width ( 00-8bits, 01-16bits, 10-24bits, 11-32bits )
// 9:8 - pfifo data access width ( 00-8bits, 01-16bits, 10-24bits, 11-32bits )
// 7:0 - empty room for fetch data ( max_fetch_cycle ) x64 bits
#define PARSER_CONFIG                              ((0x3865  << 2) + 0xffd00000)
// bit 24:16 -- pfifo_level
// bit 9:0 -- point to byte address
#define PFIFO_WR_PTR                               ((0x3866  << 2) + 0xffd00000)
// bit 9:0 -- point to byte address
#define PFIFO_RD_PTR                               ((0x3867  << 2) + 0xffd00000)
// bit 31:0 -- 8/16/24/32 bits data according to pfifo_data_width
#define PFIFO_DATA                                 ((0x3868  << 2) + 0xffd00000)
// bit 31:0 -- parser search pattern
#define PARSER_SEARCH_PATTERN                      ((0x3869  << 2) + 0xffd00000)
// bit 31:0 -- parser search mask ( 0 - disable bit match test )
#define PARSER_SEARCH_MASK                         ((0x386a  << 2) + 0xffd00000)
// bit 31:16 -- parser_int_disable_count
// bit 15:8 -- Parser interrupt enable for host cpu
// bit 7:0 -- Parser interrupt enable for Amrisc
#define PARSER_INT_ENABLE                          ((0x386b  << 2) + 0xffd00000)
// Bit 7 -- fetch_cmd_finished
// Bit 6:5 -- reserved
// Bit 4 -- parse finished
// Bit 3 -- discard finished
// Bit 2 -- insert zero finished
// Bit 1 -- Action Finished Except Search Start Code
// Bit 0 -- Search match interrupt (StartCode found)
// Read 7:0 int status
// Write will clear (bit based)
#define PARSER_INT_STATUS                          ((0x386c  << 2) + 0xffd00000)
// 15    - SCR_32_READ_OUT (Read Only)
// 14    - SCR_32_data_valid
// 13    - SCR_32_data
// 12    - SCR_count_en
// 11:0  - SCR90K_DIV
#define PARSER_SCR_CTL                             ((0x386d  << 2) + 0xffd00000)
// bit 31:0 SCR value
#define PARSER_SCR                                 ((0x386e  << 2) + 0xffd00000)
// bit 31:24 -- insert_loop_number
// bit 23:21 --
// bit 20:16 -- insert_byte_number
// bit 15:0 -- discard number
#define PARSER_PARAMETER                           ((0x386f  << 2) + 0xffd00000)
// bit 31:0 -- insert data // write only
// write to PARSER_CONTROL will reset the write position
// continuous write to this address can write upto 16 bytes
#define PARSER_INSERT_DATA                         ((0x3870  << 2) + 0xffd00000)
// Bit 31:24 -- Reserved Stream_ID
// Bit 23:16 -- Sub Stream_ID
// Bit 15:8  -- Audio Stream_ID
// Bit 7:0   -- Video Stream_ID
#define VAS_STREAM_ID                              ((0x3871  << 2) + 0xffd00000)
// Bit 31:0 -- VIDEO_DTS
#define VIDEO_DTS                                  ((0x3872  << 2) + 0xffd00000)
// Bit 31:0 -- VIDEO_PTS
#define VIDEO_PTS                                  ((0x3873  << 2) + 0xffd00000)
// Bit 31:0 -- VIDEO_PTS_DTS_WR_PTR
#define VIDEO_PTS_DTS_WR_PTR                       ((0x3874  << 2) + 0xffd00000)
// Bit 31:0 -- AUDIO_PTS
#define AUDIO_PTS                                  ((0x3875  << 2) + 0xffd00000)
// Bit 31:0 -- AUDIO_PTS_WR_PTR
#define AUDIO_PTS_WR_PTR                           ((0x3876  << 2) + 0xffd00000)
// bit 31:20 -- stream_es_count ( Read Only)
// bit 19 -- req_pending ( parser ddr_A_fifo ) (Read Only)
// bit 18 -- stream_es_passthrough_enable
// bit 17:16 -- stream_es_passthrough_type
// bit 15:13 -- VIDEO2 Ees_write Endian
// bit 12 -- VIDEO2 using manual read point
// bit 11:9 -- SUB Ees_write Endian
// bit 8 -- SUB using manual read point
// bit 7:5 -- AUDIO Ees_write Endian
// bit 4 -- AUDIO using manual read point
// bit 3:1 -- VIDEO Ees_write Endian
// bit 0 -- VIDEO using manual read point
#define PARSER_ES_CONTROL                          ((0x3877  << 2) + 0xffd00000)
// Bit 31:0 PFIFO_MONITOR
#define PFIFO_MONITOR                              ((0x3878  << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_VIDEO DDR Interface
// --------------------------------------------
// The PARSER_VIDEO start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define PARSER_VIDEO_START_PTR                     ((0x3880  << 2) + 0xffd00000)
#define PARSER_VIDEO_END_PTR                       ((0x3881  << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_VIDEO Buffer Level Manager
// --------------------------------------------
#define PARSER_VIDEO_WP                            ((0x3882  << 2) + 0xffd00000)
#define PARSER_VIDEO_RP                            ((0x3883  << 2) + 0xffd00000)
#define PARSER_VIDEO_HOLE                          ((0x3884  << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_AUDIO DDR Interface
// --------------------------------------------
// The PARSER_AUDIO start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define PARSER_AUDIO_START_PTR                     ((0x3885  << 2) + 0xffd00000)
#define PARSER_AUDIO_END_PTR                       ((0x3886  << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_AUDIO Buffer Level Manager
// --------------------------------------------
#define PARSER_AUDIO_WP                            ((0x3887  << 2) + 0xffd00000)
#define PARSER_AUDIO_RP                            ((0x3888  << 2) + 0xffd00000)
#define PARSER_AUDIO_HOLE                          ((0x3889  << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_SUB DDR Interface
// --------------------------------------------
// The PARSER_SUB start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define PARSER_SUB_START_PTR                       ((0x388a  << 2) + 0xffd00000)
#define PARSER_SUB_END_PTR                         ((0x388b  << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_SUB Buffer Level Manager
// --------------------------------------------
#define PARSER_SUB_WP                              ((0x388c  << 2) + 0xffd00000)
#define PARSER_SUB_RP                              ((0x388d  << 2) + 0xffd00000)
#define PARSER_SUB_HOLE                            ((0x388e  << 2) + 0xffd00000)
// Bit[31] dma_busy
// Bit[30] cur_fetch_or_es_write
// Bit[29:28] reserved
// Bit[27:24] fetch_status
// Bit[23:0] buffer_cycles_left
#define PARSER_FETCH_INFO                          ((0x388f  << 2) + 0xffd00000)
// Bit[31:28] ctl_status
// Bit[27:24] insert_byte_offset
// Bit[23:0] es_pack_left_cycle
#define PARSER_STATUS                              ((0x3890  << 2) + 0xffd00000)
// Bit [31:16] AUDIO_wrap_count
// Bit  [15:0] VIDEO_wrap_count
#define PARSER_AV_WRAP_COUNT                       ((0x3891  << 2) + 0xffd00000)
// bit[29:24] A_brst_num_parser
// bit[21:16] A_id_parser
// bit[11:0] wrrsp_count_parser
#define WRRSP_PARSER                               ((0x3892  << 2) + 0xffd00000)
// `define CSS_cmd             12'h200   // address of css command and indirect register
// `define CSS_cntl            12'h201   // css control register
// `define CSS_data            12'h202   // indirect register
// `define CSS_id1_data  	    12'h203   // ID data for the first and second bytes
// `define CSS_id2_data  	    12'h204   // ID data for the third and fourth bytes
//CPPM registers
// `define CPPM_IFIFO_CTRL		12'h210	  //CPPM input FIFO control
// `define CPPM_C2BC_KEY		12'h211	  //CPPM C2 Block Cipher Key register
// `define CPPM_C2BC_DIN		12'h212	  //CPPM C2 Block Cipher data input register
// `define CPPM_C2BC_DOUT		12'h213   //CPPM C2 Block Cipher data result register
// `define CPPM_CMD			12'h214   //CPPM command and control register
// `define CPPM_CTRL_STATUS	12'h215   //CPPM control status, mainly for debug
// `define CPPM_IFIFO_DATA		12'h216   //CPPM input FIFO data pop port, just for debug
// --------------------------------------------
// PARSER_VIDEO2 DDR Interface
// --------------------------------------------
// The PARSER_VIDEO2 start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define PARSER_VIDEO2_START_PTR                    ((0x3893  << 2) + 0xffd00000)
#define PARSER_VIDEO2_END_PTR                      ((0x3894  << 2) + 0xffd00000)
// --------------------------------------------
// PARSER_VIDEO2 Buffer Level Manager
// --------------------------------------------
#define PARSER_VIDEO2_WP                           ((0x3895  << 2) + 0xffd00000)
#define PARSER_VIDEO2_RP                           ((0x3896  << 2) + 0xffd00000)
#define PARSER_VIDEO2_HOLE                         ((0x3897  << 2) + 0xffd00000)
// Bit [31:16] AUDIO_wrap_count
// Bit  [15:0] VIDEO2_wrap_count
#define PARSER_AV2_WRAP_COUNT                      ((0x3898  << 2) + 0xffd00000)
// DDR registers
//`define USE_DDR2
//========================================================================
//  DVIN Registers				    (12'h2e0 - 12'h2ef)
//
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DVIN_CBUS_BASE = 0x08
// -----------------------------------------------
// Bit 31:12 Rsrv
// Bit 11:10 RW, vs_hs_tim_ctrl: Controls which edge of HS/VS the active pixel/line is related:
//                               bit[0]=0: start of active pixel is counted from the rising edge of HS;
//                               bit[0]=1: start of active pixel is counted from the falling edge of HS;
//                               bit[1]=0: start of active line is counted from the rising edge of VS;
//                               bit[1]=1: start of active line is counted from the falling edge of VS.
// Bit     9 RW, sample_clk_neg: 1=invert input dvin_clk
// Bit  8: 7 RW, mode_422to444: 0=No convertion; 1=Rsrv; 2=Convert 422 to 444, use previous C value; 3=Convert 422 to 444, use average C value.
// Bit  6: 5 RW, de_mode: 0x=ignore input DE signal, use internal detection to to determine active pixel;
//                        10=during active pixel, if DE is low, replace input data with the last good data before DE goes low;
//                        11=Active pixel is determined by DE, no internal detection.
// Bit     4 RW, ext_field_sel: 1=Select external input Field, 0=Use internal detected Field.
// Bit     3 RW, field_pol_inv: set to 1 if input Field is low active and ext_field_sel=1
// Bit     2 RW, de_pol_inv: set to 1 if input DE is low active
// Bit     1 RW, vs_pol_inv: set to 1 if input VS is low active
// Bit     0 RW, hs_pol_inv: set to 1 if input HS is low active
#define DVIN_FRONT_END_CTRL                        ((0x08e0  << 2) + 0xffd00000)
// Bit 31:28 Reserved
// Bit 27:16 RW, hs_lead_vs_odd_max: Criteria for HW detecting odd/even Field internally: max clock cycles allowed for HS
//                                   active edge to lead before VS active edge, in odd field. Failing it the field is even.
// Bit 15:12 Reserved
// Bit 11: 0 RW, hs_lead_vs_odd_min: Criteria for HW detecting odd/even Field internally -- min clock cycles allowed for HS
//                                   active edge to lead before VS active edge, in odd field. Failing it the field is even.
#define DVIN_HS_LEAD_VS_ODD                        ((0x08e1  << 2) + 0xffd00000)
// Bit 31:28 Reserved
// Bit 27:16 RW, active_start_pix_fo
// Bit 15:12 Reserved
// Bit 11: 0 RW, active_start_pix_fe
#define DVIN_ACTIVE_START_PIX                      ((0x08e2  << 2) + 0xffd00000)
// Bit 31:28 Reserved
// Bit 27:16 RW, active_start_line_fo
// Bit 15:12 Reserved
// Bit 11: 0 RW, active_start_line_fe
#define DVIN_ACTIVE_START_LINE                     ((0x08e3  << 2) + 0xffd00000)
// Bit 31:28 Reserved
// Bit 27:16 RW, field_height_m1
// Bit 15:12 Reserved
// Bit 11: 0 RW, line_width_m1
#define DVIN_DISPLAY_SIZE                          ((0x08e4  << 2) + 0xffd00000)
// Bit    31 Rsrv
// Bit    30 R,  vs_in_polarity: 0=active high; 1=active low.
// Bit    29 R,  hs_in_polarity: 0=active high; 1=active low.
// Bit    28 R,  field_odd
// Bit 27:16 R,  hs_lead_vs_cnt
// Bit 15: 4 Rsrv
// Bit  3: 1 RW, data_comp_map: Re-map input data to form YCbCr.
//                              0=YCbCr is {[29:20], [19:10], [ 9: 0]};
//                              1=YCbCr is {[29:20], [ 9: 0], [19:10]};
//                              2=YCbCr is {[ 9: 0], [29:20], [19:10]};
//                              3=YCbCr is {[19:10], [29:20], [ 9: 0]};
//                              4=YCbCr is {[19:10], [ 9: 0], [29:20]};
//                              5=YCbCr is {[ 9: 0], [19:10], [29:20]};
//                              6,7=Rsrv
// Bit     0 RW, dvin_enable
#define DVIN_CTRL_STAT                             ((0x08e5  << 2) + 0xffd00000)
//========================================================================
//  DOS registers				    APB allocation from 32'hd0050000
//
//========================================================================
//=======================================================================
// XIF module
// `include "xregs.h"
    #define X_INT_ADR           0x400
    #define GPIO_ADR            0x401
    #define GPIO_ADR_H8         0x402
    #define WFIFO_DEPTH         8
    #define WFIFO_PointerWidth  3
    #define WFIFO_WORDSIZE      32
// MAC module
// move them to cpu domain.
//`define CLR_ACC_MAC         12'h410
//`define CLR_ACC_MAC2        12'h411
//`define ACC_0               12'h412
//`define ACC_1               12'h413
//`define ACC_2               12'h414
//`define ACC_3               12'h415
//========================================================================
//  Audio EQ DRC Interface				    (15'h1400 - 15'h14ff)
//
//========================================================================
//
// Reading file:  audio_eq_drc.h
//
// -----------------------------------------------
// CBUS_BASE:  AED_CBUS_BASE = 0x10
// -----------------------------------------------
#define AED_EQ_CH1_COEF00                          ((0x1000  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF01                          ((0x1001  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF02                          ((0x1002  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF03                          ((0x1003  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF04                          ((0x1004  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF10                          ((0x1005  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF11                          ((0x1006  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF12                          ((0x1007  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF13                          ((0x1008  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF14                          ((0x1009  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF20                          ((0x100a  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF21                          ((0x100b  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF22                          ((0x100c  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF23                          ((0x100d  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF24                          ((0x100e  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF30                          ((0x100f  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF31                          ((0x1010  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF32                          ((0x1011  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF33                          ((0x1012  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF34                          ((0x1013  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF40                          ((0x1014  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF41                          ((0x1015  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF42                          ((0x1016  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF43                          ((0x1017  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF44                          ((0x1018  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF50                          ((0x1019  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF51                          ((0x101a  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF52                          ((0x101b  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF53                          ((0x101c  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF54                          ((0x101d  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF60                          ((0x101e  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF61                          ((0x101f  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF62                          ((0x1020  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF63                          ((0x1021  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF64                          ((0x1022  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF70                          ((0x1023  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF71                          ((0x1024  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF72                          ((0x1025  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF73                          ((0x1026  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF74                          ((0x1027  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF80                          ((0x1028  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF81                          ((0x1029  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF82                          ((0x102a  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF83                          ((0x102b  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF84                          ((0x102c  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF90                          ((0x102d  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF91                          ((0x102e  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF92                          ((0x102f  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF93                          ((0x1030  << 2) + 0xffd00000)
#define AED_EQ_CH1_COEF94                          ((0x1031  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF00                          ((0x1032  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF01                          ((0x1033  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF02                          ((0x1034  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF03                          ((0x1035  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF04                          ((0x1036  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF10                          ((0x1037  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF11                          ((0x1038  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF12                          ((0x1039  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF13                          ((0x103a  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF14                          ((0x103b  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF20                          ((0x103c  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF21                          ((0x103d  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF22                          ((0x103e  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF23                          ((0x103f  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF24                          ((0x1040  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF30                          ((0x1041  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF31                          ((0x1042  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF32                          ((0x1043  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF33                          ((0x1044  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF34                          ((0x1045  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF40                          ((0x1046  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF41                          ((0x1047  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF42                          ((0x1048  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF43                          ((0x1049  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF44                          ((0x104a  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF50                          ((0x104b  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF51                          ((0x104c  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF52                          ((0x104d  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF53                          ((0x104e  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF54                          ((0x104f  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF60                          ((0x1050  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF61                          ((0x1051  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF62                          ((0x1052  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF63                          ((0x1053  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF64                          ((0x1054  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF70                          ((0x1055  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF71                          ((0x1056  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF72                          ((0x1057  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF73                          ((0x1058  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF74                          ((0x1059  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF80                          ((0x105a  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF81                          ((0x105b  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF82                          ((0x105c  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF83                          ((0x105d  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF84                          ((0x105e  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF90                          ((0x105f  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF91                          ((0x1060  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF92                          ((0x1061  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF93                          ((0x1062  << 2) + 0xffd00000)
#define AED_EQ_CH2_COEF94                          ((0x1063  << 2) + 0xffd00000)
#define AED_EQ_EN                                  ((0x1064  << 2) + 0xffd00000)
#define AED_EQ_VOLUME                              ((0x1065  << 2) + 0xffd00000)
#define AED_EQ_VOLUME_SLEW_CNT                     ((0x1066  << 2) + 0xffd00000)
#define AED_MUTE                                   ((0x1067  << 2) + 0xffd00000)
#define AED_DRC_EN                                 ((0x1070  << 2) + 0xffd00000)
#define AED_DRC_AE                                 ((0x1071  << 2) + 0xffd00000)
#define AED_DRC_AA                                 ((0x1072  << 2) + 0xffd00000)
#define AED_DRC_AD                                 ((0x1073  << 2) + 0xffd00000)
#define AED_DRC_AE_1M                              ((0x1074  << 2) + 0xffd00000)
#define AED_DRC_AA_1M                              ((0x1075  << 2) + 0xffd00000)
#define AED_DRC_AD_1M                              ((0x1076  << 2) + 0xffd00000)
#define AED_DRC_OFFSET0                            ((0x1077  << 2) + 0xffd00000)
#define AED_DRC_OFFSET1                            ((0x1078  << 2) + 0xffd00000)
#define AED_DRC_THD0                               ((0x1079  << 2) + 0xffd00000)
#define AED_DRC_THD1                               ((0x107a  << 2) + 0xffd00000)
#define AED_DRC_K0                                 ((0x107b  << 2) + 0xffd00000)
#define AED_DRC_K1                                 ((0x107c  << 2) + 0xffd00000)
#define AED_CLIP_THD                               ((0x107d  << 2) + 0xffd00000)
#define AED_NG_THD0                                ((0x107e  << 2) + 0xffd00000)
#define AED_NG_THD1                                ((0x107f  << 2) + 0xffd00000)
#define AED_NG_CNT_THD                             ((0x1080  << 2) + 0xffd00000)
#define AED_NG_CTL                                 ((0x1081  << 2) + 0xffd00000)
#define AED_ED_CTL                                 ((0x1082  << 2) + 0xffd00000)
#define AED_DEBUG0                                 ((0x1083  << 2) + 0xffd00000)
#define AED_DEBUG1                                 ((0x1084  << 2) + 0xffd00000)
#define AED_DEBUG2                                 ((0x1085  << 2) + 0xffd00000)
#define AED_DEBUG3                                 ((0x1086  << 2) + 0xffd00000)
#define AED_DEBUG4                                 ((0x1087  << 2) + 0xffd00000)
#define AED_DEBUG5                                 ((0x1088  << 2) + 0xffd00000)
#define AED_DEBUG6                                 ((0x1089  << 2) + 0xffd00000)
#define AED_TOP_CTL                                ((0x1090  << 2) + 0xffd00000)
//
// Closing file:  audio_eq_drc.h
//
//========================================================================
//  Audio Interface				    (12'h500 - 12'h5ff)
//
//========================================================================
//
// Reading file:  aregs.h
//
//========================================================================
//  Audio Interface                                 (8'h00 - 8'hff)
//  Modified : Xuyun Chen Jan 2001
//========================================================================
// Number of bytes expected per NON-PCM frame, including the header.
// 16 bits.
// -----------------------------------------------
// CBUS_BASE:  AIU_CBUS_BASE = 0x14
// -----------------------------------------------
#define AIU_958_BPF                                ((0x1400  << 2) + 0xffd00000)
// Value of burst_info used in IEC958 preamble for a NON-PCM frame. See
// ATSC AC-3 spec Annex B. 16 bits.
#define AIU_958_BRST                               ((0x1401  << 2) + 0xffd00000)
// Value of length_code used in IEC958 preamble for an NON-PCM frame. See
// ATSC AC-3 spec Annex B. 16 bits.
#define AIU_958_LENGTH                             ((0x1402  << 2) + 0xffd00000)
// How many subframes to padd around the NON-PCM frame. This will
// be set to 'd3072 if it is a AC-3 audio stream.
// 16 bits
#define AIU_958_PADDSIZE                           ((0x1403  << 2) + 0xffd00000)
// 16'd3072
// Misc. control settings for IEC958 interface
// Bit 15:14 pcm_sample_ctl, 00-pcm_no_sample, 01-pcm_sample_up, 10-pcm_sample_down, 11-pcm_sample_down_drop
// Bit 13: if true, force each audio data to left or right according to the bit attached with the audio data
//         This bit should be used with Register AIU_958_force_left(0x505) together
// Bit 12: if true, the U(user data) is from the stream otherwise it is filled by
//                   zero while encoding iec958 frame
// Bit 11   : if true big endian(highword,lowword) otherwise little endian(lowword,highword)
//            for 32bit mode
// Bit 10:8 : shift number for 32 bit mode
// Bit 7  : 32 bit mode turn on while This bit is true and Bit 1 is true
// Bit 6:5 : Specifies output alignment for 16 bit pcm data.
//          00 : dout = {8'b0, din};
//          01 : dout = {4'b0, din, 4'b0};
//          10 : dout = {      din, 8'b0};
// Bit 4  : True if data should be sent out MSB first. LSB first is the
//          default in the spec.
// Bit 3  : True if msb should be extended (only used with 16 bit pcm data.)
// Bit 2  : True if msb of PCM data should be inverted.
// Bit 1  : True if PCM data is 16 bits wide. False if 24 bit or 32bit mode.
// Bit 0  : True if source data is non-PCM data. False if it is PCM data.
#define AIU_958_MISC                               ((0x1404  << 2) + 0xffd00000)
// 14'b0_0_0_000_0_0000001
// A write to this register specifies that the next pcm sample sent out
// of the iec958 interface should go into the _left_ channel.
#define AIU_958_FORCE_LEFT                         ((0x1405  << 2) + 0xffd00000)
//Read Only
//bit 6:0  how many data discarded in the last dma after one frame data finish transfering to AIU
// should used together with register AIU_958_dcu_ff_ctrl
#define AIU_958_DISCARD_NUM                        ((0x1406  << 2) + 0xffd00000)
//bit 15:8  : A read from this register indicates the IEC958 FIFO count value
//bit 7 :  ai_958_req_size if ture, set to 8 bits interface, used to handle odd frame continuous read
//bit 6 :  continue seeking and dont discard the rest data in one dma after frame end
//bit 5 :  if true, byte by byte seeking, otherwise word by word seeking
//bit 4 :  if true, the function for sync head seeking is enabled
//bit 3:2 :	IEC958 interrupt mode
// There are two conditions to generate interrupt. The First condition is that one frame data
// have been finished writing into FIFO. The second condition is at least some data of the current
// frame have been read out(refer to Register AIU_958_ffrdout_thd)
//			00: interrupt is not generated
//			10:	interrupt is generated if the first condition is true
//			01:	interrupt is generated if the second condition is true
//			11:	interrupt is generated if both of the conditions are true
//bit 1: fifo auto disable, High means after one frame data put into the FIFO, the FIFO
//					will automatically disabled
//bit 0: fifo enable
#define AIU_958_DCU_FF_CTRL                        ((0x1407  << 2) + 0xffd00000)
// 'b0_0_1_11_1_0
// channel status registers for Left channel
// chstat_l0[15:0] contains bits 15:0 of the channel status word. Note
// that bit zero of the channel status word is sent out first.
// chstat_l1[15:0] contains bits 31:16 of the channel status word.
#define AIU_958_CHSTAT_L0                          ((0x1408  << 2) + 0xffd00000)
#define AIU_958_CHSTAT_L1                          ((0x1409  << 2) + 0xffd00000)
// Control register for IEC958 interface
// Bit 9:8 what to do if there is a fifo underrun
//         00 => insert 24'h000000
//         01 => insert mute constant as defined below
//         10 => repeat last l/r samples
// Bit 7:5 mute constant
//         000 => 24'h000000
//         001 => 24'h800000
//         010 => 24'h080000
//         011 => 24'h008000
//         100 => 24'h000001
//         101 => 24'h000010
//         110 => 24'h000100
// Bit 4   mute left speaker
// Bit 3   mute right speaker
// Bit 2:1 swap channels
//         00 : L R => L R
//         01 : L R => L L
//         10 : L R => R R
//         11 : L R => R L
// Bit 0   Set this bit to hold iec958 interface after the current
//         subframe has been completely transmitted.
#define AIU_958_CTRL                               ((0x140a  << 2) + 0xffd00000)
// 10'b00_000_00_00_0
// A write operation to this register will cause one of the output samples
// to be repeated. This can be used to switch the left and the right
// channels.
#define AIU_958_RPT                                ((0x140b  << 2) + 0xffd00000)
// Channel swap and mute control register.
// Bit 15: Mute extra left channel
// Bit 14: Mute extra right channel
// Bit 13: Mute center
// Bit 12: Mute subwoofer
// Bit 11: Mute surround left
// Bit 10: Mute surround right
// Bit  9: Mute left
// Bit  8: Mute right
// Bit 7:6 Channel swap for xtra dac
// Bit 5:4 Channel swap for sub/center dac
// Bit 3:2 Channel swap for surround dac
// Bit 1:0 Channel swap for main l/r dac
// Channel swap possibilities:
// 00 : L R => L R
// 01 : L R => L L
// 10 : L R => R R
// 11 : L R => R L
#define AIU_I2S_MUTE_SWAP                          ((0x140c  << 2) + 0xffd00000)
// 16'b0
// Bit 0 : 0=> single two channel stream
//         1=> four two channel streams
#define AIU_I2S_SOURCE_DESC                        ((0x140d  << 2) + 0xffd00000)
// Median filter control register
// Bit 1:  0=> data is offset binary
//         1=> data is signed
// Bit 0:  enable median filter
#define AIU_I2S_MED_CTRL                           ((0x140e  << 2) + 0xffd00000)
// 2'b10
// Median filter threshold constant
// 16 bits
#define AIU_I2S_MED_THRESH                         ((0x140f  << 2) + 0xffd00000)
// 16'h8000
// Describes dac's connected to I2S interface
// Bit 7:  sign extend sample before downshift.
// Bit 6:4 payload downshift constant
// Bit 3:  mute constant
//         0 => 'h0000000
//         1 => 'h800000
// Bit 2:  send msb first
// Bit 1:0 Size of payload
//         Note that this parameter used to be called "size of dacs"
//         It is now called the payload size since a 24 bit payload can
//         actually be connected to any size of dac. The dac will simply
//         disregard the extra bits.
//         00 => 16 bit, alrclk = aoclk/32
//         01 => 20 bit, alrclk = aoclk/40
//         10 => 24 bit, alrclk = aoclk/48
//		   11 => 24 bit, but alrclk = aoclk/64
#define AIU_I2S_DAC_CFG                            ((0x1410  << 2) + 0xffd00000)
// 8'b0_000_1_1_10
// A write to this register will cause the interface to repeat the current
// sample. Can be used to regain synchronization.
// A read from this register indicates that the next sample to be sent
// out of the interface should go into the _left_ channel of the dac.
#define AIU_I2S_SYNC                               ((0x1411  << 2) + 0xffd00000)
// Misc regs
// Bit 4 if true, force each audio data to left or right according to the bit attached with the audio data
//         This bit should be used with Register AIU_i2s_sync(0x511) together
// Bit 3:  Same Audio source for IEC958 and I2s stream 0, both from i2s buffer
// Bit 2:  Set this bit to put i2s interface in hold mode
// Bit 1:0 How to handle underruns
//         00 => send zeros
//         01 => send 'h800000
//         10 => repeat last samples
#define AIU_I2S_MISC                               ((0x1412  << 2) + 0xffd00000)
// 5'b0
// Bit 7:0 Audio output config.
//			2 bits for each dac, 7:6 for dac3, 5:4 for dac2,
//								 3:2 for dac1, 1:0 for dac0
//			For each 2bits: 00: connect channel0-1 to the dac
//							01: connect channel2-3 to the dac
//							10: connect channel4-5 to the dac
//							11: connect channel6-7 to the dac
#define AIU_I2S_OUT_CFG                            ((0x1413  << 2) + 0xffd00000)
// 8'b0_000000_0
#define AIU_I2S_FF_CTRL                            ((0x1414  << 2) + 0xffd00000)
// A write to this register resets the AIU
//Bit 3 reset slow domain iec958
//Bit 2 soft reset iec958 fast domain
//Bit 1 reset slow domain i2s
//Bit 0 soft reset i2s fast domain
#define AIU_RST_SOFT                               ((0x1415  << 2) + 0xffd00000)
// Clock generation control register
// Bit 15: enable_ddr_arb, set low to reset
// Bit 14:13 parser_A_addr_sel  00-A_addr_aififo2, 01-A_addr_iec958, 10-A_addr_aififo, 11-A_addr_i2s
// Bit 12: 958 divisor more, if true, divided by 2, 4, 6, 8
// Bit 11: amclk output divisor
//			0 => dont divide
//			1 => divide by 2
// Bit 10: clock source selection
//        0 => aiclk from pin
//        1 => ai_pll_clk from pll
// Bit 9:8 alrclk skew
//         00 => alrclk transitions at the same time msb is sent
//         01 => alrclk transitions on the cycle before msb is sent
//         10 => alrclk transitions on the cycle after msb is sent
// Bit 7: invert alrclk
// Bit 6: invert aoclk
// Bit 5:4 958 divisor
//        00 => divide by 1
//        01 => divide by 2
//		  10 => divide by 3
//		  11 => divide by 4
// Bit 3:2 i2s divisor. NOTE: this value is ignored if AIU_clk_ctrl_more[5:0] != 0
//         00 => divide by 1
//         01 => divide by 2
//         10 => divide by 4
//         11 => divide by 8
// Bit 1: enable 958 divider
// Bit 0: enable i2s divider
#define AIU_CLK_CTRL                               ((0x1416  << 2) + 0xffd00000)
// 13'b0_0_1_01_1_1_10_11_0_0
// Misc settings that determine the type of adc that is
// connected to the AIU. Reverb mode is deleted.
// Bit 12:  selects adc input
// Bit 11:10 adc size
//           00 => 16 bits
//           01 => 18 bits
//           10 => 20 bits
//           11 => 24 bits
// Bit 9:8   adc l/r swap mode
//           00 => stereo
//           01 => send the right adc input to both l and r speakers
//           01 => send the left adc input to both l and r speakers
//           11 => sum the left and right inputs and forward to
//                both speakers
// Bit 7:5 adata/lrclk skew mode
// Bit 4   1=>invert the adc's lrclk (This is the lrclk going _out_
//         of the chip.
// Bit 3   1=>Latch the data on the positive edge of the _internal_
//         aoclk.
// Bit 2   1=>adc data is in signed 2's complement mode
#define AIU_MIX_ADCCFG                             ((0x1417  << 2) + 0xffd00000)
// 12'b01_00_001_1_0_1_00
// Control register that can be changed dynamically. These control
// signals are synchronized internally.
// Bit 12:  if true, toggle each mixed audio data to left or right channel
// Bit 11:  abuf din left selection, if true, select bit 24 of the data from abuf
//		    otherwise select bit 25 of the data from abuf
// Bit 10:9  mix sync select, when music, mic and abuf are mixed togather, the main
//			 sync source can be selected
//     00: not sync source
//	   01: music data is the main sync source
//	   10: abuf input data is the main sync source
//	   11: music and abuf togather as the sync source
// Bit 8:  0=> data from abuf is offset binary
//         1=> data from abuf is signed
// Bit 7:6 the source for data from aiu to abuf
//           00 => mic
//           01 => mic scaled + abuf scaled
//           10 => mic scaled + abuf scaled + music scaled
//			 11 => music
// Bit 5   channel from aiu to abuf is on
// Bit 4   channel from abuf to aiu is on
// Bit 3   mic is on
// Bit 2   music is on
// Bit 1   if true the mixed data are outputed to i2s dac channel,
//			otherwise the mixed data are outputed to IEC958 output
// Bit 0   if true music source for mixing is from i2s buffer,
//			otherwise music source is from iec958 buffer
#define AIU_MIX_CTRL                               ((0x1418  << 2) + 0xffd00000)
// 11'b01_1_01_0_0_0_1_1_1
// Bit    15 invert_audin_sclk.
// Bit    14 enable_adc_sclk.
// Bit 13: 8 divisor_adc_sclk.
// Bit     7 invert_acodec_adc_sclk.
// Bit     6 hdmitx_sel_aoclkx2: 0=Select cts_clk_i958 as AIU clk to hdmi_tx_audio_master_clk; 1=Select cts_aoclkx2_int as AIU clk to hdmi_tx_audio_master_clk;
// Bit  5: 0 More control on i2s divisor. For backward compatibility, this value is ignored if is 0,
//           if non-zero, it takes effect over AIU_clk_ctrl[3:2].
//           0=i2s divisor will use the old value in AIU_clk_ctrl[3:2] (divide by 1/2/4/8)
//           1=divide by 2;
//           2=divide by 3;
//           3=divide by 4;
//           ... and so on ...
//           63=divide by 64.
#define AIU_CLK_CTRL_MORE                          ((0x1419  << 2) + 0xffd00000)
// A read from this register pops 16 bits of data off the 958
// fifo. A write has no effect.
#define AIU_958_POP                                ((0x141a  << 2) + 0xffd00000)
//gain register for mixing
// for each gain,
//			 00000: x 0
//			 00001: x 1
//			 00010: x 2
//           00011: x 3
//			 00100: x 4
//			 00101: x 5
//			 00110: x 6
//			......
//           01110: x14
//           01111: x15
//           10000: x 0
//           10001: x 1/16
//           10010: x 2/16
//           10011: x 3/16
//           10100: x 4/16
//			......
//           11110: x 14/16
//           11111: x 15/16
//Bit 14:10 mic gain
//Bit 9:5 	abuf gain
//Bit 4:0 music gain
#define AIU_MIX_GAIN                               ((0x141b  << 2) + 0xffd00000)
// 15'b00001_00001_00001
//sync head seeking is supported. The  maximum length of sync head is
//48-bit-wide.(in byte by byte seeking mode, the maximum is 44-bit-wide).
//It is consisted of 3 words (synword1_synword2_syncword3).
//You can configure the sync head pattern by using sync mask(mask1_mask2_mask3).
//For example. AC-3 sync head is a 16-bit word(0b77), so syncword1 is set as 0b77,
//mask1 is 0000(not set), mask2 and mask3 is all masked.
#define AIU_958_SYNWORD1                           ((0x141c  << 2) + 0xffd00000)
//16'h0b77  //ac-3 sync head
#define AIU_958_SYNWORD2                           ((0x141d  << 2) + 0xffd00000)
//16'h0000
#define AIU_958_SYNWORD3                           ((0x141e  << 2) + 0xffd00000)
//16'h0000
#define AIU_958_SYNWORD1_MASK                      ((0x141f  << 2) + 0xffd00000)
//16'h0000 //16-bit ac-3 sync_head
#define AIU_958_SYNWORD2_MASK                      ((0x1420  << 2) + 0xffd00000)
//16'hffff
#define AIU_958_SYNWORD3_MASK                      ((0x1421  << 2) + 0xffd00000)
//16'hffff
//fifo read-out threshold, one condition to generate interrupt is met after fifo readout counter
//reach this value in a frame, please refer to register AIU_958_dcu_ff_ctrl
#define AIU_958_FFRDOUT_THD                        ((0x1422  << 2) + 0xffd00000)
//'h0004
//For pause burst sequence adding, one pause burst sequence is consist of a serious
// pause burst.
//This register defines the length of each pause burst in a pause burst sequence. The size of the
//preamble(Pa, Pb, Pc, Pd) is not counted, but the size of stuff data is counted.
#define AIU_958_LENGTH_PER_PAUSE                   ((0x1423  << 2) + 0xffd00000)
//'h0000
//This register defines the number of pause burst in a pause burst sequence.
//Bit 15  if true, one pause burst sequence will be added
//Bit 14:0 the number of pause burst in a pause burst sequence
#define AIU_958_PAUSE_NUM                          ((0x1424  << 2) + 0xffd00000)
//'h0000
//The first 16-bit in the payload of pause burst sequence (gap_length)
#define AIU_958_PAUSE_PAYLOAD                      ((0x1425  << 2) + 0xffd00000)
//'h0000
//For auto pause function, when enabled, pause burst sequence will be automatically added if the data in
// 958 fifo is less than auto_pause threshold and if fifo is disabled.
//Bit 15   if true, auto pause function enable
//Bit 14   pause pack option, just for debugging and adding one option
//Bit 7:0  auto_pause threshold
#define AIU_958_AUTO_PAUSE                         ((0x1426  << 2) + 0xffd00000)
//'h0000
//pause burst sequence payload length( = AIU_958_pause_num * AIU_958_length_per_pause)
#define AIU_958_PAUSE_PD_LENGTH                    ((0x1427  << 2) + 0xffd00000)
//'h0000
// Bit 15:12 Rsrv.
// Bit 11: 0 dac_lrclk_div: Default is 48-1=47, which means lrclk is sclk divide by 48.
#define AIU_CODEC_DAC_LRCLK_CTRL                   ((0x1428  << 2) + 0xffd00000)
//'h002f
// Bit 15:14 Rsrv.
// Bit    13 inv_audin_lrclk: whether to invert lrclk before output to Audin
// Bit    12 inv_acodec_adc_lrclk: whether to invert lrclk before output to Audio Codec
// Bit 11: 0 adc_lrclk_div: Default is 48-1=47, which means lrclk is sclk divide by 48.
#define AIU_CODEC_ADC_LRCLK_CTRL                   ((0x1429  << 2) + 0xffd00000)
//'h002f
// Bit 15:6 Rsrv.
// Bit  5: 4 hdmi_data_sel: 00=output 0, disable hdmi data; 01=Select pcm data; 10=Select AIU I2S data; 11=Not allowed.
// Bit  3: 2 Rsrv.
// Bit  1: 0 hdmi_clk_sel: 00=Disable output hdmi clock; 01=Select pcm clock; 10=Select AIU clk; 11=Not allowed.
#define AIU_HDMI_CLK_DATA_CTRL                     ((0x142a  << 2) + 0xffd00000)
//'h0000
// Bit 15:6 Rsrv.
// Bit  5: 4 acodec_data_sel: 00=output 0, disable acodec_sdin; 01=Select pcm data; 10=Select AIU I2S data; 11=Not allowed.
// Bit  3: 2 Rsrv.
// Bit  1: 0 acodec_clk_sel: 00=Disable output acodec_sclk; 01=Select pcm clock; 10=Select AIU aoclk; 11=Not allowed.
#define AIU_CODEC_CLK_DATA_CTRL                    ((0x142b  << 2) + 0xffd00000)
//'h0000
#define AIU_ACODEC_CTRL                            ((0x142c  << 2) + 0xffd00000)
// channel status registers for right channel
// chstat_r0[15:0] contains bits 15:0 of the channel status word. Note
// that bit zero of the channel status word is sent out first.
// chstat_r1[15:0] contains bits 31:16 of the channel status word.
#define AIU_958_CHSTAT_R0                          ((0x1430  << 2) + 0xffd00000)
#define AIU_958_CHSTAT_R1                          ((0x1431  << 2) + 0xffd00000)
//Bit 1 	if true, turn on Digital output Valid control
//Bit 0		0: output 0, 1: output 1 to the valid bit in audio digital output when Bit 1 is true
#define AIU_958_VALID_CTRL                         ((0x1432  << 2) + 0xffd00000)
//-----------------------------------------------------------------------------
// Audio Amplifier controls
//-----------------------------------------------------------------------------
#define AIU_AUDIO_AMP_REG0                         ((0x143c  << 2) + 0xffd00000)
#define AIU_AUDIO_AMP_REG1                         ((0x143d  << 2) + 0xffd00000)
#define AIU_AUDIO_AMP_REG2                         ((0x143e  << 2) + 0xffd00000)
#define AIU_AUDIO_AMP_REG3                         ((0x143f  << 2) + 0xffd00000)
//-----------------------------------------------------------------------------
//add for AIFIFO2 channel
//-----------------------------------------------------------------------------
//Bit 3 	CRC pop aififo2 enable
//Bit 2		writing to this bit to 1 causes CRC module reset
//Bit 1		unused
//Bit 0		writing to this bit to 1 causes AIFIFO2 soft reset
#define AIU_AIFIFO2_CTRL                           ((0x1440  << 2) + 0xffd00000)
//'h0000
//AIFIFO2 status register
//Bit 4:0		//how many bits left in the first pop register
#define AIU_AIFIFO2_STATUS                         ((0x1441  << 2) + 0xffd00000)
//Same function as the AIGBIT of AIFIFO in CDROM module
//write to this register how many bits wanna pop,
//and reading this register gets the corresponding bits data
#define AIU_AIFIFO2_GBIT                           ((0x1442  << 2) + 0xffd00000)
//Same function as the AICLB of AIFIFO in CDROM module
//return the leading zeros by reading this registers
#define AIU_AIFIFO2_CLB                            ((0x1443  << 2) + 0xffd00000)
//CRC control register, read/write
//Bit 0		CRC calculation start
//Bit 1		CRC core soft reset
//Bit 2		CRC input register clear
//Bit 3		CRC pop data from FIFO enable
//Bit 13:8	CRC polynomial equation order, between 1 to 32
#define AIU_CRC_CTRL                               ((0x1444  << 2) + 0xffd00000)
//16'h1000
//CRC status register, read only
//Bit 7:4	CRC internal shift register bit select, just for debug purpose
//Bit 3		CRC internal shift register data valid, just for debug purpose
//Bit 2		CRC input register data valid
//Bit 1		CRC result, 1: CRC not correct, 0: CRC correct
//Bit 0		CRC state,  1: CRC busy, 0: CRC idle
#define AIU_CRC_STATUS                             ((0x1445  << 2) + 0xffd00000)
//CRC internal shift register, read only, for debug purpose
#define AIU_CRC_SHIFT_REG                          ((0x1446  << 2) + 0xffd00000)
//CRC data input register, read/write
#define AIU_CRC_IREG                               ((0x1447  << 2) + 0xffd00000)
//16'h0000
//CRC calculation register high-bit part [31:16], read/write
#define AIU_CRC_CAL_REG1                           ((0x1448  << 2) + 0xffd00000)
//CRC calculation register low-bit part [15:0], read/write
#define AIU_CRC_CAL_REG0                           ((0x1449  << 2) + 0xffd00000)
//32'h00000000
//CRC polynomial coefficient high-bit part [31:16], read/write
#define AIU_CRC_POLY_COEF1                         ((0x144a  << 2) + 0xffd00000)
//CRC polynomial coefficient low-bit part [15:0], read/write
#define AIU_CRC_POLY_COEF0                         ((0x144b  << 2) + 0xffd00000)
//32'h80050000			default CRC-16
//CRC frame size, high-bit part [19:16], read/write
#define AIU_CRC_BIT_SIZE1                          ((0x144c  << 2) + 0xffd00000)
//CRC frame size, low-bit part [15:0],	 read/write
#define AIU_CRC_BIT_SIZE0                          ((0x144d  << 2) + 0xffd00000)
//20'hfffff
//how many bits have been processed right now in the current frame, read only
//high-bit part [19:16]
#define AIU_CRC_BIT_CNT1                           ((0x144e  << 2) + 0xffd00000)
//low-bit part [15:0]
#define AIU_CRC_BIT_CNT0                           ((0x144f  << 2) + 0xffd00000)
// -------------------------------------
// AMCLK Measurement
// -------------------------------------
// Used to measure the amclk frequency
#define AIU_AMCLK_GATE_HI                          ((0x1450  << 2) + 0xffd00000)
#define AIU_AMCLK_GATE_LO                          ((0x1451  << 2) + 0xffd00000)
#define AIU_AMCLK_MSR                              ((0x1452  << 2) + 0xffd00000)
#define AIU_AUDAC_CTRL0                            ((0x1453  << 2) + 0xffd00000)
// -------------------------------------
// Super Simple Delta Sigma DAC
// -------------------------------------
// bit 15   1 = invert the clock to the analog filter
// bit 14   1 = digital mute
// bit 13   1 = enable analog mute (in the analog block)
// bit 12   1 = enable Right channel 3 in the analog block
// bit 11   1 = enable Left  channel 3 in the analog block
// bit 10   1 = enable Right channel 2 in the analog block
// bit  9   1 = enable Left  channel 2 in the analog block
// bit  8   1 = enable Right channel 1 in the analog block
// bit  7   1 = enable Left  channel 1 in the analog block
// bit  6   1 = enable Right channel 0 in the analog block
// bit  5   1 = enable Left  channel 0 in the analog block
// bit  4:  bit select for serial input data
// bit  3:  invert alrclk used by the delta-sigma DAC
// bit  2:  1 = use serial I2S data.  0 = use parallel audio data
// bits 1:0 Which data to send to the delta-sigma DAC
//              11 = use channel 3 data
//              10 = use channel 2 data
//              01 = use channel 1 data
//              00 = use channel 0 data
#define AIU_DELTA_SIGMA0                           ((0x1455  << 2) + 0xffd00000)
// Delta Sigma MUTE Value
#define AIU_DELTA_SIGMA1                           ((0x1456  << 2) + 0xffd00000)
// Additional Audio filter controls
#define AIU_DELTA_SIGMA2                           ((0x1457  << 2) + 0xffd00000)
//Bit 14, left channel Delta Sigma modulator soft reset
//Bit 13, right channel Delta Sigma modulator soft reset
//Bit 12, left channel Delta Sigma modulator internal state clear enable when it is unstable
//Bit 11, right channel Delta Sigma modulator internal state clear enable when it is unstable
//Bit 10, left channel Delta Sigma detect unstable state enable
//Bit  9, right channel Delta Sigma detect unstable state enable
//Bit  8, dither high pass filter enable in the Delta Sigma loop
//Bit 7:6, reserved
//Bit 5:0, Delta Sigma input data gain  0/32 ~ 63/32
//default: 16'h3
#define AIU_DELTA_SIGMA3                           ((0x1458  << 2) + 0xffd00000)
//15:8, Added Delta Sigma DC level, range:+-1/2, minimum: +-1/128 (assume max is -1 ~ +1)
//7:0, max same sequence number, used for unstable detection
//default: 16'h0
#define AIU_DELTA_SIGMA4                           ((0x1459  << 2) + 0xffd00000)
//Bit 15:8, square wave divide num
//Bit 7:0, square wave amplitude, -1/4 ~ 1/4, minimum: +-1/1024
//default: 16'h0
#define AIU_DELTA_SIGMA5                           ((0x145a  << 2) + 0xffd00000)
//Bit 11:8, loop dither amplitude2, 0/32 ~ 15/32
//Bit 7:4,  loop dither amplitude1, 0/32 ~ 15/32
//Bit 3:0,  loop dither amplitude0, 0/32 ~ 15/32
//default: 16'h0
#define AIU_DELTA_SIGMA6                           ((0x145b  << 2) + 0xffd00000)
//Bit 15:8, loop dithering threshold1   0, 1/512, 2/512 ... 1/2
//Bit 7:0,  loop dithering threshold0   0, 1/512, 2/512 ... 1/2
//default: 16'h0
#define AIU_DELTA_SIGMA7                           ((0x145c  << 2) + 0xffd00000)
//read only
//Bit 15:8  left channel Delta Sigma clear counter number, how many times Delta Sigma has been reseted
//          It will saturate to 255, if more than 255 time
//Bit 7:0   left channel max same sequence number
#define AIU_DELTA_SIGMA_LCNTS                      ((0x145d  << 2) + 0xffd00000)
//read only
//Bit 15:8  right channel Delta Sigma clear counter number, how many times Delta Sigma has been reseted
//          It will saturate to 255, if more than 255 time
//Bit 7:0   right channel max same sequence number
#define AIU_DELTA_SIGMA_RCNTS                      ((0x145e  << 2) + 0xffd00000)
// --------------------------------------------
// I2S DDR Interface
// --------------------------------------------
// The I2S start pointer into DDR memory is a 32-bit number
#define AIU_MEM_I2S_START_PTR                      ((0x1460  << 2) + 0xffd00000)
#define AIU_MEM_I2S_RD_PTR                         ((0x1461  << 2) + 0xffd00000)
#define AIU_MEM_I2S_END_PTR                        ((0x1462  << 2) + 0xffd00000)
// There are two masks that control how data is read:
// [31:16] IRQ block.
// [15:8] chan_mem_mask.  Each bit indicates which channels exist in memory
// [7:0]  chan_rd_mask.   Each bit indicates which channels are READ from memory
#define AIU_MEM_I2S_MASKS                          ((0x1463  << 2) + 0xffd00000)
// I2S FIFO Control
// bits [11:10] Select which hardware pointer to use to control the buffer
//              level:
//                  00 = parser
//                  01 = audin_fifo0_wrpt
//                  1x = audin_fifo1_wrpt
// bit  [9]     Use level control: 1 = use buffer level control
// bit  [8]     Read Only.  This bit is 1 when there is data available for reading
// bit  [7]     Read only.  This bit will be high when we're fetching data from the DDR memory
//              To reset this module, set cntl_enable = 0, and then wait for busy = 0.
//              After that you can pulse cntl_init to start over
// bit  [6]     cntl_mode_16bit:Set to 1 for 16 bit storage format in DDR
// bits [5:3]   endian:  see $lib/rtl/ddr_endian.v
// bit  [2]     cntl_empty_en   Set to 1 to enable reading data from the FIFO
// bit  [1]     cntl_fill_en    Set to 1 to enable reading data from DDR memory
// bit  [0]     cntl_init:      After setting the read pointers, sizes, channel masks
//                              and read masks, set this bit to 1 and then to 0
#define AIU_MEM_I2S_CONTROL                        ((0x1464  << 2) + 0xffd00000)
// --------------------------------------------
// IEC958 DDR Interface
// --------------------------------------------
// The IEC958 start pointer into DDR memory is a 32-bit number
#define AIU_MEM_IEC958_START_PTR                   ((0x1465  << 2) + 0xffd00000)
#define AIU_MEM_IEC958_RD_PTR                      ((0x1466  << 2) + 0xffd00000)
#define AIU_MEM_IEC958_END_PTR                     ((0x1467  << 2) + 0xffd00000)
// There are two masks that control how data is read:
// [15:8] chan_mem_mask.  Each bit indicates which channels exist in memory
// [7:0]  chan_rd_mask.   Each bit indicates which channels are READ from memory
#define AIU_MEM_IEC958_MASKS                       ((0x1468  << 2) + 0xffd00000)
// IEC958 FIFO Control
// bit  [31]    A_urgent
// bit  [30]    ch_always_8
// bit  [29:24] rdata_rd_base_begin ( used for select from different channel )
// bit  [23:14] reserved
// bit  [13]    cntl_sim_en
// bit  [12]    cntl_use_level
// bit  [11]    Read only.      This bit will be set to 1 when there is data in the FIFO to process
// bit  [10]    Read only.  This bit will be high when we're fetching data from the DDR memory
//              To reset this module, set cntl_enable = 0, and then wait for busy = 0.
//              After that you can pulse cntl_init to start over
// bit  [9]     cntl_endian_jic Just in case endian.  last minute byte swap of the data out of
//                              the FIFO to the rest of the IEC958 logic
// bit  [8]     mode_raw:       Set this bit to 1 to tell the IEC958 FIFO to read
//                              and process data linearly for raw data.
// bit  [7]     cntl_mode_16bit:Set to 1 for 16 bit storage format in DDR.  Only valid when mode_raw = 0
// bit  [6]     cntl_rd_ddr     Set this bit to read if you want AIU_MEM_IEC958_RD_PTR and
//                              AIU_MEM_IEC958_RD_PTR_HIGH to refer to the pointer into DDR memory.
//                              Otherwise, the curr_ptr registers refer to the byte address of the data
//                              at the output of the FIFO to the rest of the IEC958 logic
// bits [5:3]   endian:         see $lib/rtl/ddr_endian.v
// bit  [2]     cntl_empty_en   Set to 1 to enable reading the DDR memory FIFO and filling the pipeline to get-bit
//                              Set cntl_empty_en = cntl_fill_en = 0 when pulsing cntl_init
// bit  [1]     cntl_fill_en    Set to 1 to enable reading data from DDR memory
// bit  [0]     cntl_init:      After setting the read pointers, sizes, channel masks
//                              and read masks, set this bit to 1 and then to 0
#define AIU_MEM_IEC958_CONTROL                     ((0x1469  << 2) + 0xffd00000)
// --------------------------------------------
// AIFIFO2 DDR Interface
// --------------------------------------------
// The AIFIFO2 start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define AIU_MEM_AIFIFO2_START_PTR                  ((0x146a  << 2) + 0xffd00000)
// The current pointer points so some location between the START and END
// pointers.  The current pointer is a BYTE pointer.  That is, you can
// point to any BYTE address within the START/END range
#define AIU_MEM_AIFIFO2_CURR_PTR                   ((0x146b  << 2) + 0xffd00000)
#define AIU_MEM_AIFIFO2_END_PTR                    ((0x146c  << 2) + 0xffd00000)
#define AIU_MEM_AIFIFO2_BYTES_AVAIL                ((0x146d  << 2) + 0xffd00000)
// AIFIFO2 FIFO Control
// bit  [15:11] unused
// bit  [10]    use_level       Set this bit to 1 to enable filling of the FIFO controlled by the buffer
//                              level control.  If this bit is 0, then use bit[1] to control the enabling of filling
// bit  [9]     Data Ready.     This bit is set when data can be popped
// bit  [8]     fill busy       This bit will be high when we're fetching data from the DDR memory
//                              To reset this module, set cntl_enable = 0, and then wait for busy = 0.
//                              After that you can pulse cntl_init to start over
// bit  [7]     cntl_endian_jic Just in case endian.  last minute byte swap of the data out of
//                              the FIFO to getbit
// bit  [6]     unused
// bits [5:3]   endian:         see $lib/rtl/ddr_endian.v
// bit  [2]     cntl_empty_en   Set to 1 to enable reading the DDR memory FIFO and filling the pipeline to get-bit
//                              Set cntl_empty_en = cntl_fill_en = 0 when pulsing cntl_init
// bit  [1]     cntl_fill_en    Set to 1 to enable reading data from DDR memory
// bit  [0]     cntl_init:      After setting the read pointers, sizes, channel masks
//                              and read masks, set this bit to 1 and then to 0
//                              NOTE:  You don't need to pulse cntl_init if only the start address is
//                              being changed
#define AIU_MEM_AIFIFO2_CONTROL                    ((0x146e  << 2) + 0xffd00000)
// --------------------------------------------
// AIFIFO2 Buffer Level Manager
// --------------------------------------------
#define AIU_MEM_AIFIFO2_MAN_WP                     ((0x146f  << 2) + 0xffd00000)
#define AIU_MEM_AIFIFO2_MAN_RP                     ((0x1470  << 2) + 0xffd00000)
#define AIU_MEM_AIFIFO2_LEVEL                      ((0x1471  << 2) + 0xffd00000)
//
// bit  [1]     manual mode     Set to 1 for manual write pointer mode
// bit  [0]     Init            Set high then low after everything has been initialized
#define AIU_MEM_AIFIFO2_BUF_CNTL                   ((0x1472  << 2) + 0xffd00000)
// --------------------------------------------
// I2S Buffer Level Manager
// --------------------------------------------
#define AIU_MEM_I2S_MAN_WP                         ((0x1473  << 2) + 0xffd00000)
#define AIU_MEM_I2S_MAN_RP                         ((0x1474  << 2) + 0xffd00000)
#define AIU_MEM_I2S_LEVEL                          ((0x1475  << 2) + 0xffd00000)
//
// bit  [1]     mode            0 = parser (or audin_fifo0 or audin_fifo1),
//                              1 for manual write pointer
// bit  [0]     Init            Set high then low after everything has been initialized
#define AIU_MEM_I2S_BUF_CNTL                       ((0x1476  << 2) + 0xffd00000)
#define AIU_MEM_I2S_BUF_WRAP_COUNT                 ((0x1477  << 2) + 0xffd00000)
// bit 29:24 A_brst_num
// bit 21:16 A_id
// bit 15:0 level_hold
#define AIU_MEM_I2S_MEM_CTL                        ((0x1478  << 2) + 0xffd00000)
//-----------------------------------------------------------------------------
// Additional IEC958 registers (new feature)
//-----------------------------------------------------------------------------
// bit 29:24 A_brst_num
// bit 21:16 A_id
// bit 15:0 level_hold
#define AIU_MEM_IEC958_MEM_CTL                     ((0x1479  << 2) + 0xffd00000)
#define AIU_MEM_IEC958_WRAP_COUNT                  ((0x147a  << 2) + 0xffd00000)
#define AIU_MEM_IEC958_IRQ_LEVEL                   ((0x147b  << 2) + 0xffd00000)
#define AIU_MEM_IEC958_MAN_WP                      ((0x147c  << 2) + 0xffd00000)
#define AIU_MEM_IEC958_MAN_RP                      ((0x147d  << 2) + 0xffd00000)
#define AIU_MEM_IEC958_LEVEL                       ((0x147e  << 2) + 0xffd00000)
#define AIU_MEM_IEC958_BUF_CNTL                    ((0x147f  << 2) + 0xffd00000)
//-----------------------------------------------------------------------------
// add for AIFIFO channel (old $cdrom/rtl/cdr_top/getbit)
//-----------------------------------------------------------------------------
// Bit 3 	CRC pop aififo enable
// Bit 2		writing to this bit to 1 causes CRC module reset
// Bit 1		enable aififo
// Bit 0		writing to this bit to 1 causes aififo soft reset
#define AIU_AIFIFO_CTRL                            ((0x1480  << 2) + 0xffd00000)
//'h0000
// AIFIFO status register
// Bit 13		//aififo request to dcu status
// Bit 12		//dcu select status
// Bit 11:5		//aififo word counter number
// Bit 4:0		//how many bits left in the first pop register
#define AIU_AIFIFO_STATUS                          ((0x1481  << 2) + 0xffd00000)
// Same function as the AIGBIT of AIFIFO in CDROM module
// write to this register how many bits wanna pop,
// and reading this register gets the corresponding bits data
#define AIU_AIFIFO_GBIT                            ((0x1482  << 2) + 0xffd00000)
// Same function as the AICLB of AIFIFO in CDROM module
// return the leading zeros by reading this registers
#define AIU_AIFIFO_CLB                             ((0x1483  << 2) + 0xffd00000)
// --------------------------------------------
// AIFIFO DDR Interface
// --------------------------------------------
// The AIFIFO start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define AIU_MEM_AIFIFO_START_PTR                   ((0x1484  << 2) + 0xffd00000)
// The current pointer points so some location between the START and END
// pointers.  The current pointer is a BYTE pointer.  That is, you can
// point to any BYTE address within the START/END range
#define AIU_MEM_AIFIFO_CURR_PTR                    ((0x1485  << 2) + 0xffd00000)
#define AIU_MEM_AIFIFO_END_PTR                     ((0x1486  << 2) + 0xffd00000)
#define AIU_MEM_AIFIFO_BYTES_AVAIL                 ((0x1487  << 2) + 0xffd00000)
// AIFIFO FIFO Control
// bit  [15:11] unused
// bit  [10]    use_level       Set this bit to 1 to enable filling of the FIFO controlled by the buffer
//                              level control.  If this bit is 0, then use bit[1] to control the enabling of filling
// bit  [9]     Data Ready.     This bit is set when data can be popped
// bit  [8]     fill busy       This bit will be high when we're fetching data from the DDR memory
//                              To reset this module, set cntl_enable = 0, and then wait for busy = 0.
//                              After that you can pulse cntl_init to start over
// bit  [7]     cntl_endian_jic Just in case endian.  last minute byte swap of the data out of
//                              the FIFO to getbit
// bit  [6]     unused
// bits [5:3]   endian:         see $lib/rtl/ddr_endian.v
// bit  [2]     cntl_empty_en   Set to 1 to enable reading the DDR memory FIFO and filling the pipeline to get-bit
//                              Set cntl_empty_en = cntl_fill_en = 0 when pulsing cntl_init
// bit  [1]     cntl_fill_en    Set to 1 to enable reading data from DDR memory
// bit  [0]     cntl_init:      After setting the read pointers, sizes, channel masks
//                              and read masks, set this bit to 1 and then to 0
//                              NOTE:  You don't need to pulse cntl_init if only the start address is
//                              being changed
#define AIU_MEM_AIFIFO_CONTROL                     ((0x1488  << 2) + 0xffd00000)
// --------------------------------------------
// AIFIFO Buffer Level Manager
// --------------------------------------------
#define AIU_MEM_AIFIFO_MAN_WP                      ((0x1489  << 2) + 0xffd00000)
#define AIU_MEM_AIFIFO_MAN_RP                      ((0x148a  << 2) + 0xffd00000)
#define AIU_MEM_AIFIFO_LEVEL                       ((0x148b  << 2) + 0xffd00000)
//
// bit  [1]     manual mode     Set to 1 for manual write pointer mode
// bit  [0]     Init            Set high then low after everything has been initialized
#define AIU_MEM_AIFIFO_BUF_CNTL                    ((0x148c  << 2) + 0xffd00000)
#define AIU_MEM_AIFIFO_BUF_WRAP_COUNT              ((0x148d  << 2) + 0xffd00000)
#define AIU_MEM_AIFIFO2_BUF_WRAP_COUNT             ((0x148e  << 2) + 0xffd00000)
// bit 29:24 A_brst_num
// bit 21:16 A_id
// bit 15:0 level_hold
#define AIU_MEM_AIFIFO_MEM_CTL                     ((0x148f  << 2) + 0xffd00000)
// bit 31:16 -- drop_bytes
// bit 15:14 -- drop_status (Read-Only)
// bit 13:12 -- sync_match_position (Read-Only)
// bit 11:6 -- reserved
// bit 5:4 -- TIME_STAMP_NUMBER, 0-32bits, 1-64bits, 2-96bits, 3-128bits
// bit 3 -- stamp_soft_reset
// bit 2 -- TIME_STAMP_length_enable
// bit 1 -- TIME_STAMP_sync64_enable
// bit 0 -- TIME_STAMP_enable
#define AIFIFO_TIME_STAMP_CNTL                     ((0x1490  << 2) + 0xffd00000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_0
#define AIFIFO_TIME_STAMP_SYNC_0                   ((0x1491  << 2) + 0xffd00000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_1
#define AIFIFO_TIME_STAMP_SYNC_1                   ((0x1492  << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_0
#define AIFIFO_TIME_STAMP_0                        ((0x1493  << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_1
#define AIFIFO_TIME_STAMP_1                        ((0x1494  << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_2
#define AIFIFO_TIME_STAMP_2                        ((0x1495  << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_3
#define AIFIFO_TIME_STAMP_3                        ((0x1496  << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_LENGTH
#define AIFIFO_TIME_STAMP_LENGTH                   ((0x1497  << 2) + 0xffd00000)
// bit 31:16 -- drop_bytes
// bit 15:14 -- drop_status (Read-Only)
// bit 13:12 -- sync_match_position (Read-Only)
// bit 11:6 -- reserved
// bit 5:4 -- TIME_STAMP_NUMBER, 0-32bits, 1-64bits, 2-96bits, 3-128bits
// bit 3 -- stamp_soft_reset
// bit 2 -- TIME_STAMP_length_enable
// bit 1 -- TIME_STAMP_sync64_enable
// bit 0 -- TIME_STAMP_enable
#define AIFIFO2_TIME_STAMP_CNTL                    ((0x1498  << 2) + 0xffd00000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_0
#define AIFIFO2_TIME_STAMP_SYNC_0                  ((0x1499  << 2) + 0xffd00000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_1
#define AIFIFO2_TIME_STAMP_SYNC_1                  ((0x149a  << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_0
#define AIFIFO2_TIME_STAMP_0                       ((0x149b  << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_1
#define AIFIFO2_TIME_STAMP_1                       ((0x149c  << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_2
#define AIFIFO2_TIME_STAMP_2                       ((0x149d  << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_3
#define AIFIFO2_TIME_STAMP_3                       ((0x149e  << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_LENGTH
#define AIFIFO2_TIME_STAMP_LENGTH                  ((0x149f  << 2) + 0xffd00000)
// bit 31:16 -- drop_bytes
// bit 15:14 -- drop_status (Read-Only)
// bit 13:12 -- sync_match_position (Read-Only)
// bit 11:6 -- reserved
// bit 5:4 -- TIME_STAMP_NUMBER, 0-32bits, 1-64bits, 2-96bits, 3-128bits
// bit 3 -- stamp_soft_reset
// bit 2 -- TIME_STAMP_length_enable
// bit 1 -- TIME_STAMP_sync64_enable
// bit 0 -- TIME_STAMP_enable
#define IEC958_TIME_STAMP_CNTL                     ((0x14a0  << 2) + 0xffd00000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_0
#define IEC958_TIME_STAMP_SYNC_0                   ((0x14a1  << 2) + 0xffd00000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_1
#define IEC958_TIME_STAMP_SYNC_1                   ((0x14a2  << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_0
#define IEC958_TIME_STAMP_0                        ((0x14a3  << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_1
#define IEC958_TIME_STAMP_1                        ((0x14a4  << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_2
#define IEC958_TIME_STAMP_2                        ((0x14a5  << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_3
#define IEC958_TIME_STAMP_3                        ((0x14a6  << 2) + 0xffd00000)
// bit 31:0 TIME_STAMP_LENGTH
#define IEC958_TIME_STAMP_LENGTH                   ((0x14a7  << 2) + 0xffd00000)
// bit 29:24 A_brst_num
// bit 21:16 A_id
// bit 15:0 level_hold
#define AIU_MEM_AIFIFO2_MEM_CTL                    ((0x14a8  << 2) + 0xffd00000)
// --------------------------------------------
// CBUS_DDR interface for I2S_FAST
// --------------------------------------------
// bit[31:26] unused
// bit[25]      A_req       level
// bit[24]      data_req    If this bit is 1, then (a_req_cnt != 'h0)
// bit[23:16]   a_req_cnt   This value corresponds to the number of 32-bit words
//                          requested by the i2s_fast() module
// bit[15:7]    unused
// bit[6]                   Set this bit to mux in the cbus_ddr_interface
// bit[5]                   Set this bit to allow back to back A_req's to be serviced
// bit[4]                   Set this bit to generate an IRQ on the first A_req
//                          If this bit is 0, then an IRQ is generated after all requests
//                          are completed and how many 32-bit words to send is calculated.
// bit[3:1]                 Endian
// bit[0]                   Set this bit enable the cbus_ddr_interface
#define AIU_I2S_CBUS_DDR_CNTL                      ((0x14a9  << 2) + 0xffd00000)
// 32-bit data to write to the cbus_ddr interface
#define AIU_I2S_CBUS_DDR_WDATA                     ((0x14aa  << 2) + 0xffd00000)
// First address associated with the first request by the i2s_fast() to read DDR data
#define AIU_I2S_CBUS_DDR_ADDR                      ((0x14ab  << 2) + 0xffd00000)
//
// Closing file:  aregs.h
//
//========================================================================
//  CDROM Interface                                 (12'h600 - 12'h6ff)
//
//========================================================================
//========================================================================
//	registers for ge2d (12'h8a0 - 12'h8ff)
//========================================================================
////`include "ge2d_regs.h" //  not in cbus domain any more, it is located in vapb3 bus now
//========================================================================
//  DSP Co-Processor Registers			    ( 8'he00 - 12'hfff)
//
//========================================================================
// Duplicate Address:  When actually used
// please move to a different address
// `define AUDIO_COP_CTL1      12'hf00  // r & w; r-> 6'h00,bsmod[2:0],acmod[2:0],lfeon,nfchans[2:0]
//
// Incorrect format....should be 8'bits only
//
// Removed by Chris Maslyar       `define AUDIO_COP_CTL2      12'hf01  // r & w; r-> frame_size[12:0],dsurmod[1:0]
// Removed by Chris Maslyar
// Removed by Chris Maslyar       //  f02 -f0d are special regs , not in ac3_reg.h, but used by CPU for AC3 operations
// Removed by Chris Maslyar
// Removed by Chris Maslyar       `define OPERAND_M_CTL       12'hf02
// Removed by Chris Maslyar       `define OPERAND1_ADDR       12'hf03
// Removed by Chris Maslyar       `define OPERAND2_ADDR       12'hf04
// Removed by Chris Maslyar       `define RESULT_M_CTL        12'hf05
// Removed by Chris Maslyar       `define RESULT1_ADDR        12'hf06
// Removed by Chris Maslyar       `define RESULT2_ADDR        12'hf07
// Removed by Chris Maslyar       `define ADD_SHFT_CTL        12'hf08
// Removed by Chris Maslyar       `define OPERAND_ONE_H       12'hf09
// Removed by Chris Maslyar       `define OPERAND_ONE_L       12'hf0a
// Removed by Chris Maslyar       `define OPERAND_TWO_H       12'hf0b
// Removed by Chris Maslyar       `define OPERAND_TWO_L       12'hf0c
// Removed by Chris Maslyar       `define RESULT_H            12'hf0d
// Removed by Chris Maslyar
// Removed by Chris Maslyar
// Removed by Chris Maslyar       `define RESULT_M            12'hf0e   // r & w; ac3_reg_14
// Removed by Chris Maslyar
// Removed by Chris Maslyar       // special reg
// Removed by Chris Maslyar       `define RESULT_L            12'hf0f
// Removed by Chris Maslyar
// Removed by Chris Maslyar       //
// Removed by Chris Maslyar       `define WMEM_R_PTR          12'hf10   // r & w ; endmant0 &1
// Removed by Chris Maslyar
// Removed by Chris Maslyar       `define WMEM_W_PTR          12'hf11
// Removed by Chris Maslyar       `define AUDIO_LAYER         12'hf20
// Removed by Chris Maslyar       `define AC3_DECODING        12'hf21
// Removed by Chris Maslyar       `define AC3_DYNAMIC         12'hf22
// Removed by Chris Maslyar       `define AC3_MELODY          12'hf23
// Removed by Chris Maslyar       `define AC3_VOCAL           12'hf24
//======================================
//  CPU Assist module
//
//======================================
// -----------------------------------------------
// CBUS_BASE:  ASSIST_CBUS_BASE = 0x20
// -----------------------------------------------
//`define ASSIST_AMR_MBOX1_INT          8'h4d
//`define ASSIST_AMR_MBOX2_INT          8'h4e
#define ASSIST_AMR_SCRATCH0                        ((0x204f  << 2) + 0xffd00000)
#define ASSIST_AMR_SCRATCH1                        ((0x2050  << 2) + 0xffd00000)
#define ASSIST_AMR_SCRATCH2                        ((0x2051  << 2) + 0xffd00000)
#define ASSIST_AMR_SCRATCH3                        ((0x2052  << 2) + 0xffd00000)
#define ASSIST_HW_REV                              ((0x2053  << 2) + 0xffd00000)
//`define ASSIST_CBUS_ARB               8'h54
#define ASSIST_POR_CONFIG                          ((0x2055  << 2) + 0xffd00000)
#define ASSIST_SPARE16_REG1                        ((0x2056  << 2) + 0xffd00000)
#define ASSIST_SPARE16_REG2                        ((0x2057  << 2) + 0xffd00000)
#define ASSIST_SPARE8_REG1                         ((0x2058  << 2) + 0xffd00000)
#define ASSIST_SPARE8_REG2                         ((0x2059  << 2) + 0xffd00000)
// Duplicate Address...when used please move to a new address
// `define TO_AMRISC_REG                 8'h59 // for amrisc
#define ASSIST_SPARE8_REG3                         ((0x205a  << 2) + 0xffd00000)
// Duplicate Address...when used please move to a new address
// `define FROM_AMRISC_REG               8'h5a // for amrisc
// Duplicate Address...when used please move to a new address
// `define MPEG2_DECODER_CONTROL         8'h5b // for amrisc
#define AC3_CTRL_REG1                              ((0x205b  << 2) + 0xffd00000)
#define AC3_CTRL_REG2                              ((0x205c  << 2) + 0xffd00000)
#define AC3_CTRL_REG3                              ((0x205d  << 2) + 0xffd00000)
#define AC3_CTRL_REG4                              ((0x205e  << 2) + 0xffd00000)
//`define ASSIST_PMEM_SPLIT             8'h5f
#define ASSIST_GEN_CNTL                            ((0x2068  << 2) + 0xffd00000)
#define EE_ASSIST_MBOX0_IRQ_REG                    ((0x2070  << 2) + 0xffd00000)
#define EE_ASSIST_MBOX0_CLR_REG                    ((0x2071  << 2) + 0xffd00000)
#define EE_ASSIST_MBOX0_MASK                       ((0x2072  << 2) + 0xffd00000)
#define EE_ASSIST_MBOX0_FIQ_SEL                    ((0x2073  << 2) + 0xffd00000)
#define EE_ASSIST_MBOX1_IRQ_REG                    ((0x2074  << 2) + 0xffd00000)
#define EE_ASSIST_MBOX1_CLR_REG                    ((0x2075  << 2) + 0xffd00000)
#define EE_ASSIST_MBOX1_MASK                       ((0x2076  << 2) + 0xffd00000)
#define EE_ASSIST_MBOX1_FIQ_SEL                    ((0x2077  << 2) + 0xffd00000)
#define EE_ASSIST_MBOX2_IRQ_REG                    ((0x2078  << 2) + 0xffd00000)
#define EE_ASSIST_MBOX2_CLR_REG                    ((0x2079  << 2) + 0xffd00000)
#define EE_ASSIST_MBOX2_MASK                       ((0x207a  << 2) + 0xffd00000)
#define EE_ASSIST_MBOX2_FIQ_SEL                    ((0x207b  << 2) + 0xffd00000)
#define EE_ASSIST_MBOX3_IRQ_REG                    ((0x207c  << 2) + 0xffd00000)
#define EE_ASSIST_MBOX3_CLR_REG                    ((0x207d  << 2) + 0xffd00000)
#define EE_ASSIST_MBOX3_MASK                       ((0x207e  << 2) + 0xffd00000)
#define EE_ASSIST_MBOX3_FIQ_SEL                    ((0x207f  << 2) + 0xffd00000)
// -----------------------------------------------
// CBUS_BASE:  AUD_CBUS_BASE = 0x34
// -----------------------------------------------
// ----------------------------
// AUDIN (64)
// ----------------------------
#define AUDIN_SPDIF_MODE                           ((0x3400  << 2) + 0xffd00000)
    #define SPDIF_EN                31
    #define SPDIF_INT_EN            30
    #define SPDIF_BURST_PRE_INT_EN  29
    #define SPDIF_TIE_0             24
    #define SPDIF_SAMPLE_SEL        23
    #define SPDIF_REVERSE_EN        22
    #define SPDIF_BIT_ORDER         20
    #define SPDIF_CHNL_ORDER        19
    #define SPDIF_DATA_TYPE_SEL     18
    #define SPDIF_XTDCLK_UPD_ITVL   14   //16:14
    #define SPDIF_CLKNUM_54U        0     //13:0
#define AUDIN_SPDIF_FS_CLK_RLTN                    ((0x3401  << 2) + 0xffd00000)
    #define SPDIF_CLKNUM_192K  24     //29:24
    #define SPDIF_CLKNUM_96K   18     //23:18
    #define SPDIF_CLKNUM_48K   12     //17:12
    #define SPDIF_CLKNUM_44K   6     // 11:6
    #define SPDIF_CLKNUM_32K   0     // 5:0
#define AUDIN_SPDIF_CHNL_STS_A                     ((0x3402  << 2) + 0xffd00000)
#define AUDIN_SPDIF_CHNL_STS_B                     ((0x3403  << 2) + 0xffd00000)
#define AUDIN_SPDIF_MISC                           ((0x3404  << 2) + 0xffd00000)
#define AUDIN_SPDIF_NPCM_PCPD                      ((0x3405  << 2) + 0xffd00000)
#define AUDIN_SPDIF_END                            ((0x340f  << 2) + 0xffd00000)
#define AUDIN_I2SIN_CTRL                           ((0x3410  << 2) + 0xffd00000)
    #define I2SIN_DIR       0    // I2S CLK and LRCLK direction. 0 : input 1 : output.
    #define I2SIN_CLK_SEL    1    // I2S clk selection : 0 : from pad input. 1 : from AIU.
    #define I2SIN_LRCLK_SEL 2
    #define I2SIN_POS_SYNC  3
    #define I2SIN_LRCLK_SKEW 4    // 6:4
    #define I2SIN_LRCLK_INVT 7
    #define I2SIN_SIZE       8    //9:8 : 0 16 bit. 1 : 18 bits 2 : 20 bits 3 : 24bits.
    #define I2SIN_CHAN_EN   10    //13:10.
    #define I2SIN_EN        15
// Bit 31:15    Rsrv.
// Bit 14:12 RW HDMI-RX SPDIF channel status select to report on AUDIN_DECODE_CHANNEL_STATUS_A_*: 0=select channel 1; 1=channel 2; ...; 7=channel 8.
// Bit 11: 8 RW HDMI-RX SPDIF channel status extraction enable, 1-bit per channel pair. To enable, SPDIF input source also must select 1.
// Bit  7: 6    Rsrv.
// Bit  5: 4 RW SPDIF input source select. 0=Default, select chip external; 1=select HDMI RX output; 2/3=Rsrv.
// Bit  3: 2    Rsrv.
// Bit  1: 0 RW I2S input source select. 0=Default, select chip external; 1=select audio codec output; 2=select HDMI RX output; 3=Rsrv.
#define AUDIN_SOURCE_SEL                           ((0x3411  << 2) + 0xffd00000)
// The following registers control the new alternative decoder -- hdmi_tx_audio_decoder, in audin module
// Bit 31:25    Rsrv.
// Bit    24 RW SPDIF enable.
// Bit 23:22    Rsrv.
// Bit 21:20 RW i2s_block_start_src: 0=left channel 0 is approved as block start generator, ..., 3=left channel 3 is the block start generator.
// Bit 19:17    Rsrv.
// Bit    16 RW I2S enable.
// Bit 15: 8 RW audio_channel_alloc: Usage indication of up to 8 channels. If the corresponding bit is 1, then this channel is used.
//                                   E.g.: In 2-channel audio, it is 00000011
// Bit     7 RW hdmi_tx_audio_decoder input sel: 0=SPDIF; 1=I2S.
// Bit     6 RW i2s_channel_config: 0=2-channel; 1=8-channel.
// Bit  5: 4 RW i2s_format_select: 0=left-justify; 1=right-justify; 2=I2S format; 3=DSP format.
// Bit  3: 2 RW i2s_bit_width: 0=16-bit; 1=18-bit; 2=20-bit; 3=24-bit.
// Bit     1 RW ws polarity: 0=0 is left, 1 is right; 1=1 is left, 0 is right.
// Bit     0 RW For SPDIF mode, 0=use channel status from input data; 1=use channel status from registers;
//              For I2S mode, 0=one-bit audio; 1=I2S.
#define AUDIN_DECODE_FORMAT                        ((0x3412  << 2) + 0xffd00000)
// Bit 31:25    Rsrv.
// Bit    24 R  channel_status stability indicator.
// Bit 23:16 RW Valid bits for audio sample packet. [7] for valid_sp3_right, [6] for valid_sp3_left, ..., [1] for valid_sp0_right, [0] for valid_sp0_left.
// Bit 15: 8 RW User bits for audio sample packet. [7] for user_sp3_right, [6] for user_sp3_left, ..., [1] for user_sp0_right, [0] for user_sp0_left.
// Bit  7: 4 RW cntl_init_discard: Number of initial hdmi_tx_audio_decoder samples to discard from reset.
// Bit     3 RW cntl_invert_i2s_lrclk: Invert WS before input to hdmi_tx_audio_decoder.
// Bit     2 RW audio_valid_overwrite: Valid bit selection in audio packet. 0=use input data; 1=use
// Bit     1 RW audio_user_overwrite: User bit selection in audio packet. 0=use input data; 1=use
// Bit     0 RW audio_sample_valid: sample non-flat indication. 0=flat, non-valid; 1=non-flat, valid.
#define AUDIN_DECODE_CONTROL_STATUS                ((0x3413  << 2) + 0xffd00000)
// IEC958 192-bit channel status: muxed between 8 channels, channel selection by AUDIN_SOURCE_SEL[14:12]
#define AUDIN_DECODE_CHANNEL_STATUS_A_0            ((0x3414  << 2) + 0xffd00000)
#define AUDIN_DECODE_CHANNEL_STATUS_A_1            ((0x3415  << 2) + 0xffd00000)
#define AUDIN_DECODE_CHANNEL_STATUS_A_2            ((0x3416  << 2) + 0xffd00000)
#define AUDIN_DECODE_CHANNEL_STATUS_A_3            ((0x3417  << 2) + 0xffd00000)
#define AUDIN_DECODE_CHANNEL_STATUS_A_4            ((0x3418  << 2) + 0xffd00000)
#define AUDIN_DECODE_CHANNEL_STATUS_A_5            ((0x3419  << 2) + 0xffd00000)
#define AUDIN_FIFO0_START                          ((0x3420  << 2) + 0xffd00000)
#define AUDIN_FIFO0_END                            ((0x3421  << 2) + 0xffd00000)
#define AUDIN_FIFO0_PTR                            ((0x3422  << 2) + 0xffd00000)
#define AUDIN_FIFO0_INTR                           ((0x3423  << 2) + 0xffd00000)
#define AUDIN_FIFO0_RDPTR                          ((0x3424  << 2) + 0xffd00000)
#define AUDIN_FIFO0_CTRL                           ((0x3425  << 2) + 0xffd00000)
    #define AUDIN_FIFO0_EN       0
    #define AUDIN_FIFO0_RST      1
    #define AUDIN_FIFO0_LOAD     2    //write 1 to load address to AUDIN_FIFO0.

    #define AUDIN_FIFO0_DIN_SEL  3
            // 0     spdifIN
            // 1     i2Sin
            // 2     PCMIN
            // 3     HDMI in
            // 4     DEMODULATOR IN
    #define AUDIN_FIFO0_ENDIAN   8    //10:8   data endian control.
    #define AUDIN_FIFO0_CHAN     11    //14:11   channel number.  in M1 suppose there's only 1 channel and 2 channel.
    #define AUDIN_FIFO0_UG       15    // urgent request enable.
    #define AUDIN_FIFO0_HOLD0_EN  19
    #define AUDIN_FIFO0_HOLD1_EN  20
    #define AUDIN_FIFO0_HOLD2_EN  21
    #define AUDIN_FIFO0_HOLD0_SEL 22   // 23:22
    #define AUDIN_FIFO0_HOLD1_SEL 24   // 25:24
    #define AUDIN_FIFO0_HOLD2_SEL 26   // 27:26
    #define AUDIN_FIFO0_HOLD_LVL  28   // 27:26


#define AUDIN_FIFO0_CTRL1                          ((0x3426  << 2) + 0xffd00000)
#define AUDIN_FIFO0_LVL0                           ((0x3427  << 2) + 0xffd00000)
#define AUDIN_FIFO0_LVL1                           ((0x3428  << 2) + 0xffd00000)
#define AUDIN_FIFO0_LVL2                           ((0x3429  << 2) + 0xffd00000)
#define AUDIN_FIFO0_REQID                          ((0x3430  << 2) + 0xffd00000)
#define AUDIN_FIFO0_WRAP                           ((0x3431  << 2) + 0xffd00000)
#define AUDIN_FIFO1_START                          ((0x3433  << 2) + 0xffd00000)
#define AUDIN_FIFO1_END                            ((0x3434  << 2) + 0xffd00000)
#define AUDIN_FIFO1_PTR                            ((0x3435  << 2) + 0xffd00000)
#define AUDIN_FIFO1_INTR                           ((0x3436  << 2) + 0xffd00000)
#define AUDIN_FIFO1_RDPTR                          ((0x3437  << 2) + 0xffd00000)
#define AUDIN_FIFO1_CTRL                           ((0x3438  << 2) + 0xffd00000)
    #define AUDIN_FIFO1_EN       0
    #define AUDIN_FIFO1_RST      1
    #define AUDIN_FIFO1_LOAD     2    //write 1 to load address to AUDIN_FIFO0.

    #define AUDIN_FIFO1_DIN_SEL  3
            // 0     spdifIN
            // 1     i2Sin
            // 2     PCMIN
            // 3     HDMI in
            // 4     DEMODULATOR IN
    #define AUDIN_FIFO1_ENDIAN   8    //10:8   data endian control.
    #define AUDIN_FIFO1_CHAN     11    //14:11   channel number.  in M1 suppose there's only 1 channel and 2 channel.
    #define AUDIN_FIFO1_UG       15    // urgent request enable.
    #define AUDIN_FIFO1_HOLD0_EN  19
    #define AUDIN_FIFO1_HOLD1_EN  20
    #define AUDIN_FIFO1_HOLD2_EN  21
    #define AUDIN_FIFO1_HOLD0_SEL 22   // 23:22
    #define AUDIN_FIFO1_HOLD1_SEL 24   // 25:24
    #define AUDIN_FIFO1_HOLD2_SEL 26   // 27:26
    #define AUDIN_FIFO1_HOLD_LVL  28   // 27:26
#define AUDIN_FIFO1_CTRL1                          ((0x3439  << 2) + 0xffd00000)
#define AUDIN_FIFO1_LVL0                           ((0x3440  << 2) + 0xffd00000)
#define AUDIN_FIFO1_LVL1                           ((0x3441  << 2) + 0xffd00000)
#define AUDIN_FIFO1_LVL2                           ((0x3442  << 2) + 0xffd00000)
#define AUDIN_FIFO1_REQID                          ((0x3443  << 2) + 0xffd00000)
#define AUDIN_FIFO1_WRAP                           ((0x3444  << 2) + 0xffd00000)
#define AUDIN_FIFO2_START                          ((0x3445  << 2) + 0xffd00000)
#define AUDIN_FIFO2_END                            ((0x3446  << 2) + 0xffd00000)
#define AUDIN_FIFO2_PTR                            ((0x3447  << 2) + 0xffd00000)
#define AUDIN_FIFO2_INTR                           ((0x3448  << 2) + 0xffd00000)
#define AUDIN_FIFO2_RDPTR                          ((0x3449  << 2) + 0xffd00000)
#define AUDIN_FIFO2_CTRL                           ((0x344a  << 2) + 0xffd00000)
#define AUDIN_FIFO2_CTRL1                          ((0x344b  << 2) + 0xffd00000)
#define AUDIN_FIFO2_LVL0                           ((0x344c  << 2) + 0xffd00000)
#define AUDIN_FIFO2_LVL1                           ((0x344d  << 2) + 0xffd00000)
#define AUDIN_FIFO2_LVL2                           ((0x344e  << 2) + 0xffd00000)
#define AUDIN_FIFO2_REQID                          ((0x344f  << 2) + 0xffd00000)
#define AUDIN_FIFO2_WRAP                           ((0x3450  << 2) + 0xffd00000)
#define AUDIN_INT_CTRL                             ((0x3451  << 2) + 0xffd00000)
#define AUDIN_FIFO_INT                             ((0x3452  << 2) + 0xffd00000)
#define PCMIN_CTRL0                                ((0x3460  << 2) + 0xffd00000)
#define PCMIN_CTRL1                                ((0x3461  << 2) + 0xffd00000)
#define PCMIN_CTRL2                                ((0x3462  << 2) + 0xffd00000)
//`define PCMIN1_CTRL0                     8'h62
//`define PCMIN1_CTRL1                     8'h63
#define PCMOUT_CTRL0                               ((0x3470  << 2) + 0xffd00000)
#define PCMOUT_CTRL1                               ((0x3471  << 2) + 0xffd00000)
#define PCMOUT_CTRL2                               ((0x3472  << 2) + 0xffd00000)
#define PCMOUT_CTRL3                               ((0x3473  << 2) + 0xffd00000)
#define PCMOUT_CTRL4                               ((0x3474  << 2) + 0xffd00000)
//`define PCMOUT1_CTRL0                    8'h74
//`define PCMOUT1_CTRL1                    8'h75
//`define PCMOUT1_CTRL2                    8'h76
//`define PCMOUT1_CTRL3                    8'h77
#define AUDOUT_CTRL                                ((0x3480  << 2) + 0xffd00000)
#define AUDOUT_CTRL1                               ((0x3481  << 2) + 0xffd00000)
#define AUDOUT_BUF0_STA                            ((0x3482  << 2) + 0xffd00000)
#define AUDOUT_BUF0_EDA                            ((0x3483  << 2) + 0xffd00000)
#define AUDOUT_BUF0_WPTR                           ((0x3484  << 2) + 0xffd00000)
#define AUDOUT_BUF1_STA                            ((0x3485  << 2) + 0xffd00000)
#define AUDOUT_BUF1_EDA                            ((0x3486  << 2) + 0xffd00000)
#define AUDOUT_BUF1_WPTR                           ((0x3487  << 2) + 0xffd00000)
#define AUDOUT_FIFO_RPTR                           ((0x3488  << 2) + 0xffd00000)
#define AUDOUT_INTR_PTR                            ((0x3489  << 2) + 0xffd00000)
#define AUDOUT_FIFO_STS                            ((0x348a  << 2) + 0xffd00000)
//`define AUDOUT1_CTRL                     8'h90
//`define AUDOUT1_CTRL1                    8'h91
//`define AUDOUT1_BUF0_STA                 8'h92
//`define AUDOUT1_BUF0_EDA                 8'h93
//`define AUDOUT1_BUF0_WPTR                8'h94
//`define AUDOUT1_BUF1_STA                 8'h95
//`define AUDOUT1_BUF1_EDA                 8'h96
//`define AUDOUT1_BUF1_WPTR                8'h97
//`define AUDOUT1_FIFO_RPTR                8'h98
//`define AUDOUT1_INTR_PTR                 8'h99
//`define AUDOUT1_FIFO_STS                 8'h9a
//// Bit 31: 0 RW cntl_mute_val: Use this value during mute, if cntl_mute_mode=2.
//`define AUDIN_MUTE_VAL                 8'h35
#define AUDIN_HDMI_MEAS_CTRL                       ((0x34a0  << 2) + 0xffd00000)
#define AUDIN_HDMI_MEAS_CYCLES_M1                  ((0x34a1  << 2) + 0xffd00000)
#define AUDIN_HDMI_MEAS_INTR_MASKN                 ((0x34a2  << 2) + 0xffd00000)
#define AUDIN_HDMI_MEAS_INTR_STAT                  ((0x34a3  << 2) + 0xffd00000)
#define AUDIN_HDMI_REF_CYCLES_STAT_0               ((0x34a4  << 2) + 0xffd00000)
#define AUDIN_HDMI_REF_CYCLES_STAT_1               ((0x34a5  << 2) + 0xffd00000)
#define AUDIN_HDMIRX_AFIFO_STAT                    ((0x34a6  << 2) + 0xffd00000)
#define AUDIN_MEM_PD                               ((0x34aa  << 2) + 0xffd00000)
#define AUDIN_FIFO0_PIO_STS                        ((0x34b0  << 2) + 0xffd00000)
#define AUDIN_FIFO0_PIO_RDL                        ((0x34b1  << 2) + 0xffd00000)
#define AUDIN_FIFO0_PIO_RDH                        ((0x34b2  << 2) + 0xffd00000)
#define AUDIN_FIFO1_PIO_STS                        ((0x34b3  << 2) + 0xffd00000)
#define AUDIN_FIFO1_PIO_RDL                        ((0x34b4  << 2) + 0xffd00000)
#define AUDIN_FIFO1_PIO_RDH                        ((0x34b5  << 2) + 0xffd00000)
#define AUDIN_FIFO2_PIO_STS                        ((0x34b6  << 2) + 0xffd00000)
#define AUDIN_FIFO2_PIO_RDL                        ((0x34b7  << 2) + 0xffd00000)
#define AUDIN_FIFO2_PIO_RDH                        ((0x34b8  << 2) + 0xffd00000)
#define AUDOUT_FIFO_PIO_STS                        ((0x34b9  << 2) + 0xffd00000)
#define AUDOUT_FIFO_PIO_WRL                        ((0x34ba  << 2) + 0xffd00000)
#define AUDOUT_FIFO_PIO_WRH                        ((0x34bb  << 2) + 0xffd00000)
//`define AUDOUT1_FIFO_PIO_STS		8'hbc
//`define AUDOUT1_FIFO_PIO_WRL        	8'hbd
//`define AUDOUT1_FIFO_PIO_WRH        	8'hbe
#define AUD_RESAMPLE_CTRL0                         ((0x34bf  << 2) + 0xffd00000)
#define AUD_RESAMPLE_CTRL1                         ((0x34c0  << 2) + 0xffd00000)
#define AUD_RESAMPLE_STATUS                        ((0x34c1  << 2) + 0xffd00000)
#define AUD_RESAMPLE_CTRL2                         ((0x34c2  << 2) + 0xffd00000)
#define AUD_RESAMPLE_COEF0                         ((0x34c3  << 2) + 0xffd00000)
#define AUD_RESAMPLE_COEF1                         ((0x34c4  << 2) + 0xffd00000)
#define AUD_RESAMPLE_COEF2                         ((0x34c5  << 2) + 0xffd00000)
#define AUD_RESAMPLE_COEF3                         ((0x34c6  << 2) + 0xffd00000)
#define AUD_RESAMPLE_COEF4                         ((0x34c7  << 2) + 0xffd00000)
#define AUDIN_ADDR_END                             ((0x34c8  << 2) + 0xffd00000)
#define AUDIN_ATV_DEMOD_CTRL                       ((0x34d0  << 2) + 0xffd00000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  ./register_map.h
//
//
// Reading file:  ./vcbus_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
//`define RDMA_VCBUS_BASE       8'h11
//===========================================================================
//
// Reading file:  rdma_regs.h
//
//===========================================================================
// RDMA registers 0x00 - 0xff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  RDMA_VCBUS_BASE = 0x11
// -----------------------------------------------
// Bit 31: 0 RW AHB start address for manual start DMA
#define RDMA_AHB_START_ADDR_MAN                    ((0x1100  << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for manual start DMA
#define RDMA_AHB_END_ADDR_MAN                      ((0x1101  << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 1
#define RDMA_AHB_START_ADDR_1                      ((0x1102  << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 1
#define RDMA_AHB_END_ADDR_1                        ((0x1103  << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 2
#define RDMA_AHB_START_ADDR_2                      ((0x1104  << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 2
#define RDMA_AHB_END_ADDR_2                        ((0x1105  << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 3
#define RDMA_AHB_START_ADDR_3                      ((0x1106  << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 3
#define RDMA_AHB_END_ADDR_3                        ((0x1107  << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 4
#define RDMA_AHB_START_ADDR_4                      ((0x1108  << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 4
#define RDMA_AHB_END_ADDR_4                        ((0x1109  << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 5
#define RDMA_AHB_START_ADDR_5                      ((0x110a  << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 5
#define RDMA_AHB_END_ADDR_5                        ((0x110b  << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 6
#define RDMA_AHB_START_ADDR_6                      ((0x110c  << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 6
#define RDMA_AHB_END_ADDR_6                        ((0x110d  << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 7
#define RDMA_AHB_START_ADDR_7                      ((0x110e  << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 7
#define RDMA_AHB_END_ADDR_7                        ((0x110f  << 2) + 0xff900000)
// Auto start DMA control:
// Bit 31:24 RW ctrl_enable_int_3. Interrupt inputs enable mask for source 3.
// Bit 23:16 RW ctrl_enable_int_2. Interrupt inputs enable mask for source 2.
// Bit 15: 8 RW ctrl_enable_int_1. Interrupt inputs enable mask for source 1.
// Bit     7 RW ctrl_cbus_write_3. Register read/write mode for auto-start 3. 1=Register write; 0=Register read.
// Bit     6 RW ctrl_cbus_write_3. Register read/write mode for auto-start 2. 1=Register write; 0=Register read.
// Bit     5 RW ctrl_cbus_write_3. Register read/write mode for auto-start 1. 1=Register write; 0=Register read.
// Bit     4 R  Rsrv.
// Bit     3 RW ctrl_cbus_addr_incr_3. 1=Incremental register access for auto-start 3; 0=Non-incremental (individual) register access.
// Bit     2 RW ctrl_cbus_addr_incr_2. 1=Incremental register access for auto-start 2; 0=Non-incremental (individual) register access.
// Bit     1 RW ctrl_cbus_addr_incr_1. 1=Incremental register access for auto-start 1; 0=Non-incremental (individual) register access.
// Bit     0 R  Rsrv.
#define RDMA_ACCESS_AUTO                           ((0x1110  << 2) + 0xff900000)
#define RDMA_ACCESS_AUTO2                          ((0x1111  << 2) + 0xff900000)
#define RDMA_ACCESS_AUTO3                          ((0x1112  << 2) + 0xff900000)
// Manual start DMA control:
// Bit 31: 3 R  Rsrv.
// Bit     2 RW ctrl_cbus_write_man. Register read/write mode for manual-start. 1=Register write; 0=Register read.
// Bit     1 RW ctrl_cbus_addr_incr_man. 1=Incremental register access for manual-start; 0=Non-incremental (individual) register access.
// Bit     0 W  ctrl_start_man. Write 1 to this bit to manual-start DMA. This bit always read back 0.
#define RDMA_ACCESS_MAN                            ((0x1113  << 2) + 0xff900000)
// RDMA general control:
// Bit 31:25 R  Rsrv.
// Bit    24 W  ctrl_clr_rdma_done_int. Write 1 to reset rdma_int level to 0. No need to clear this bit.
// Bit 23:19 R  Rsrv.
// Bit 18:13 R  Rsrv.
// Bit 12: 7 R  Rsrv.
// Bit     6 RW ctrl_ddr_urgent.
// Bit  5: 4 RW ctrl_ahb_wr_burst_size. 0=ABH write request burst size 16;
//                                      1=ABH write request burst size 24;
//                                      2=ABH write request burst size 32;
//                                      3=ABH write request burst size 48.
// Bit  3: 2 RW ctrl_ahb_rd_burst_size. 0=ABH read request burst size 16;
//                                      1=ABH read request burst size 24;
//                                      2=ABH read request burst size 32;
//                                      3=ABH read request burst size 48.
// Bit     1 RW ctrl_sw_reset. 1=Reset RDMA logic except register.
// Bit     0 RW ctrl_free_clk_enable. 0=Default, Enable clock gating. 1=No clock gating, enable free clock.
#define RDMA_CTRL                                  ((0x1114  << 2) + 0xff900000)
// Read only.
// Bit 31:29 R  Rsrv.
// Bit    28 R  rdma_done_int.
// Bit 27:25 R  Rsrv.
// Bit 24:18 R  ahb_wrfifo_cnt. FIFO for buffering CBus read data to be sent to AHB
// Bit 17:11 R  ahb_rdfifo_cnt. FIFO for buffering data read from AHB.
// Bit 10: 8 R  ddr_req_st. =0 -- Idle; !=0 -- AHB interfacing ongoing.
// Bit  7: 4 R  curr_req. Latest requests that is being/been serviced. E.g. 0000=Idle; 0010=Latest serviced request is Req 1.
// Bit  3: 0 R  req_latch. Requests that are yet to be serviced. E.g. 0000=No request; 0001=Req 0 waiting; 1100=Req 2 and 3 waiting.
#define RDMA_STATUS                                ((0x1115  << 2) + 0xff900000)
#define RDMA_STATUS2                               ((0x1116  << 2) + 0xff900000)
#define RDMA_STATUS3                               ((0x1117  << 2) + 0xff900000)
#define RDMA_ACCESS_AUTO4                          ((0x1118  << 2) + 0xff900000)
#define RDMA_SRAM_CNTL                             ((0x1120  << 2) + 0xff900000)
#define RDMA_SRAM_REGADDR                          ((0x1121  << 2) + 0xff900000)
#define RDMA_SRAM_REGDATA                          ((0x1122  << 2) + 0xff900000)
//
// Closing file:  rdma_regs.h
//
//===========================================================================
// VDIN
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VDIN_VCBUS_BASE = 0x12
// -----------------------------------------------
//VDIN0        8'h00 - 8'h7f
//VDIN1        8'h80 - 8'hef
#define VDIN0_OFFSET            0x00
#define VDIN1_OFFSET            0x80

#define VDIN_SCALE_COEF_IDX                        ((0x1200  << 2) + 0xff900000)
#define VDIN_SCALE_COEF                            ((0x1201  << 2) + 0xff900000)
//bit 31,   mpeg_to_vdin_sel, 0: mpeg source to NR directly, 1: mpeg source pass through here
//bit 30,   mpeg_field info which can be written by software
//Bit 29,   force go_field, pulse signal
//Bit 28,   force go_line, pulse signal
//Bit 27,   enable mpeg_go_field input signal
//Bit 26:20, hold lines
//Bit 19,   delay go_field function enable
//Bit 18:12, delay go_field line number
//Bit 11:10, component2 output switch, 00: select component0 in, 01: select component1 in, 10: select component2 in
//Bit 9:8, component1 output switch, 00: select component0 in, 01: select component1 in, 10: select component2 in
//Bit 7:6, component0 output switch, 00: select component0 in, 01: select component1 in, 10: select component2 in
//Bit 5,   input window selection function enable
//Bit 4, enable VDIN common data input, otherwise there will be no video data input
//Bit 3:0 vdin selection, 1: mpeg_in from dram, 2: bt656 input, 3: component input, 4: tvdecoder input, 5: hdmi rx input, 6: digital video input, 7: loopback from Viu1, 8: MIPI.
#define VDIN_COM_CTRL0                             ((0x1202  << 2) + 0xff900000)
//Bit 28:16 active_max_pix_cnt, readonly
//Bit 12:0  active_max_pix_cnt_shadow, readonly
#define VDIN_ACTIVE_MAX_PIX_CNT_STATUS             ((0x1203  << 2) + 0xff900000)
//Bit 28:16 go_line_cnt, readonly
//Bit 12:0  active_line_cnt, readonly
#define VDIN_LCNT_STATUS                           ((0x1204  << 2) + 0xff900000)
//Readonly
//Bit [14:3] lfifo_buf_cnt
//Bit 2, vdin_direct_done status
//Bit 1, vdin_nr_done status
//Bit 0, field
#define VDIN_COM_STATUS0                           ((0x1205  << 2) + 0xff900000)
//Readonly
//Bit 31, vdi4 fifo overflow
//Bit 29:24, vdi3_asfifo_cnt
//Bit 23, vdi3 fifo overflow
//Bit 21:16, vdi3_asfifo_cnt
//Bit 15, vdi2 fifo overflow
//Bit 13:8, vdi2_asfifo_cnt
//Bit 7, vdi1 fifo overflow
//Bit 5:0, vdi1_asfifo_cnt
#define VDIN_COM_STATUS1                           ((0x1206  << 2) + 0xff900000)
//Bit 28:16 go_line_cnt_shadow, readonly
//Bit 12:0  active_line_cnt_shadow, readonly
#define VDIN_LCNT_SHADOW_STATUS                    ((0x1207  << 2) + 0xff900000)
//each 8bit asfifo_ctrl is following:
//Bit 7, DE  enable
//Bit 6, go field enable
//Bit 5, go line enable
//Bit 4, if true, negative active input vsync
//Bit 3, if true, negative active input hsync
//Bit 2, vsync soft reset fifo enable
//Bit 1, overflow status clear
//Bit 0 asfifo soft reset, level signal
//Bit 7:0 vdi1 asfifo_ctrl
//Bit 23:16 vdi2 asfifo_ctrl
#define VDIN_ASFIFO_CTRL0                          ((0x1208  << 2) + 0xff900000)
//Bit 7:0 vdi3 asfifo_ctrl
//Bit 23:16 vdi4 asfifo_ctrl
#define VDIN_ASFIFO_CTRL1                          ((0x1209  << 2) + 0xff900000)
//Bit 28:16 input width minus 1, after the window function
//Bit 12:0  output width minus 1
#define VDIN_WIDTHM1I_WIDTHM1O                     ((0x120a  << 2) + 0xff900000)
//Bit 20:17 prehsc_mode, bit 3:2, prehsc odd line interp mode, bit 1:0, prehsc even line interp mode,
//           each 2bit, 00: pix0+pix1/2, average, 01: pix1, 10: pix0
//Bit 16:15 sp422_mode, special mode for the component1 and component2, 00: normal case, 01: 32 64 32, 10: 0 64 64 0, 11: 16 96 16
//Bit 14:8, hsc_ini_pixi_ptr, signed data, only useful when short_lineo_en is true
//Bit 7, prehsc_en
//Bit 6, hsc_en,
//Bit 5, hsc_short_lineo_en, short line output enable
//Bit 4, hsc_nearest_en
//Bit 3, hsc_phase0_always_en
//Bit 2:0, hsc_bank_length
#define VDIN_SC_MISC_CTRL                          ((0x120b  << 2) + 0xff900000)
//Bit 28:24, integer portion
//Bit 23:0, fraction portion
#define VDIN_HSC_PHASE_STEP                        ((0x120c  << 2) + 0xff900000)
//Bit 30:29    hscale rpt_p0_num
//Bit 28:24    hscale ini_rcv_num
//Bit 23:0     hscale ini_phase
#define VDIN_HSC_INI_CTRL                          ((0x120d  << 2) + 0xff900000)
//Read only
//Bit 23, vdi7 fifo overflow
//Bit 21:16, vdi7_asfifo_cnt
//Bit 15, vdi6 fifo overflow
//Bit 13:8, vdi6_asfifo_cnt
//Bit 7, vdi5 fifo overflow
//Bit 5:0, vdi5_asfifo_cnt
#define VDIN_COM_STATUS2                           ((0x120e  << 2) + 0xff900000)
//Bit 25:16 asfifo decimate control
//Bit 25, if true, decimation counter sync with first valid DE in the field,
//otherwise the decimation counter is not sync with external signal
//Bit 24, decimation de enable
//Bit 23:20, decimation phase, which counter value use to decimate,
//Bit 19:16, decimation number, 0: not decimation, 1: decimation 2, 2: decimation 3 ....
//Bit 7:0 vdi5 asfifo_ctrl
#define VDIN_ASFIFO_CTRL2                          ((0x120f  << 2) + 0xff900000)
//Bit 7,  highlight_en
//Bit 6   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before matrix
//Bit 5:4  probe_sel, 00: select matrix 0, 01: select matrix 1,  otherwise select nothing
//Bit 3:2, matrix coef idx selection, 00: select mat0, 01: select mat1, otherwise slect nothing
//Bit 1   mat1 conversion matrix enable
//Bit 0   mat0 conversion matrix enable
#define VDIN_MATRIX_CTRL                           ((0x1210  << 2) + 0xff900000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define VDIN_MATRIX_COEF00_01                      ((0x1211  << 2) + 0xff900000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define VDIN_MATRIX_COEF02_10                      ((0x1212  << 2) + 0xff900000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define VDIN_MATRIX_COEF11_12                      ((0x1213  << 2) + 0xff900000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define VDIN_MATRIX_COEF20_21                      ((0x1214  << 2) + 0xff900000)
//BIt 18:16 conv_rs
//Bit 12:0  coef22
#define VDIN_MATRIX_COEF22                         ((0x1215  << 2) + 0xff900000)
//Bit 26:16 offset0
//Bit 10:0  offset1
#define VDIN_MATRIX_OFFSET0_1                      ((0x1216  << 2) + 0xff900000)
//Bit 10:0  offset2
#define VDIN_MATRIX_OFFSET2                        ((0x1217  << 2) + 0xff900000)
//Bit 26:16 pre_offset0
//Bit 10:0  pre_offset1
#define VDIN_MATRIX_PRE_OFFSET0_1                  ((0x1218  << 2) + 0xff900000)
//Bit 10:0  pre_offset2
#define VDIN_MATRIX_PRE_OFFSET2                    ((0x1219  << 2) + 0xff900000)
//12:0 lfifo_buf_size
#define VDIN_LFIFO_CTRL                            ((0x121a  << 2) + 0xff900000)
#define VDIN_COM_GCLK_CTRL                         ((0x121b  << 2) + 0xff900000)
//12:0 VDIN input interface width minus 1, before the window function, after the de decimation
#define VDIN_INTF_WIDTHM1                          ((0x121c  << 2) + 0xff900000)
//Bit 15          //default== 0, urgent_ctrl_en
//Bit 14          //default== 0, urgent_wr, if true for write buffer
//Bit 13          //default== 0, out_inv_en
//Bit 12          //default == 0, urgent_ini_value
//Bit 11:6        //default == 0, up_th  up threshold
//Bit 5:0         //default == 0, dn_th  dn threshold
#define VDIN_LFIFO_URG_CTRL                        ((0x121e  << 2) + 0xff900000)
//Bit 8, 1: discard data before line fifo, 0: normal mode
//Bit 7:0 Write chroma canvas address
#define VDIN_WR_CTRL2                              ((0x121f  << 2) + 0xff900000)
//Bit 31:30 hconv_mode, Applicable only to bit[13:12]=0 or 2. 0: Output every even pixels' CbCr;
//                                                            1: Output every odd pixels' CbCr;
//                                                            2: Output an average value per even&odd pair of pixels;
//                                                            3: Output all CbCr. (This does NOT apply to bit[13:12]=0 -- 4:2:2 mode.)
//Bit 29 no_clk_gate: disable vid_wr_mif clock gating function.
//Bit 28 clear write response counter in the vdin write memory interface
//Bit 27 eol_sel, 1: use eol as the line end indication, 0: use width as line end indication in the vdin write memory interface
//Bit 26 vcp_nr_en. Only used in VDIN0. NOT used in VDIN1.
//Bit 25 vcp_wr_en. Only used in VDIN0. NOT used in VDIN1.
//Bit 24 vcp_in_en. Only used in VDIN0. NOT used in VDIN1.
//Bit 23 vdin frame reset enble, if true, it will provide frame reset during go_field(vsync) to the modules after that
//Bit 22 vdin line fifo soft reset enable, meaning, if true line fifo will reset during go_field (vsync)
//Bit 21 vdin direct write done status clear bit
//Bit 20 vdin NR write done status clear bit
//Bit 18 swap_cbcr. Applicable only to bit[13:12]=2. 0: Output CbCr (NV12); 1: Output CrCb (NV21).
//Bit 17:16 vconv_mode, Applicable only to bit[13:12]=2. 0: Output every even lines' CbCr;
//                                                       1: Output every odd lines' CbCr;
//                                                       2: Reserved;
//                                                       3: Output all CbCr.
//Bit 13:12 vdin write format, 0: 4:2:2 to luma canvas, 1: 4:4:4 to luma canvas,
//                             2: Y to luma canvas, CbCr to chroma canvas. For NV12/21, also define Bit 31:30, 17:16, and bit 18.
//Bit 11 vdin write canvas double buffer enable, means the canvas address will be latched by vsync before using
//Bit 10 1: disable ctrl_reg write pulse which will reset internal counter. when bit 11 is 1, this bit should be 1.
//Bit 9 vdin write request urgent
//Bit 8 vdin write request enable
//Bit 7:0 Write luma canvas address
#define VDIN_WR_CTRL                               ((0x1220  << 2) + 0xff900000)
//Bit 29, if true, horizontal reverse
//Bit 28:16 start
//Bit 12:0  end
#define VDIN_WR_H_START_END                        ((0x1221  << 2) + 0xff900000)
//Bit 29, if true, vertical reverse
//Bit 28:16 start
//Bit 12:0  end
#define VDIN_WR_V_START_END                        ((0x1222  << 2) + 0xff900000)
//Bit 24:20, integer portion
//Bit 19:0, fraction portion
#define VDIN_VSC_PHASE_STEP                        ((0x1223  << 2) + 0xff900000)
//Bit 23, vsc_en, vertical scaler enable
//Bit 21 vsc_phase0_always_en, when scale up, you have to set it to 1
//Bit 20:16 ini skip_line_num
//Bit 15:0 vscaler ini_phase
#define VDIN_VSC_INI_CTRL                          ((0x1224  << 2) + 0xff900000)
//Bit 28:16, vshrink input height minus 1
//Bit 12:0, scaler input height minus 1
#define VDIN_SCIN_HEIGHTM1                         ((0x1225  << 2) + 0xff900000)
//Bit 23:16, dummy component 0
//Bit 15:8, dummy component 1
//Bit 7:0, dummy component 2
#define VDIN_DUMMY_DATA                            ((0x1226  << 2) + 0xff900000)
//Read only
//Bit 29:20 component 0
//Bit 19:10 component 1
//Bit 9:0 component 2
#define VDIN_MATRIX_PROBE_COLOR                    ((0x1228  << 2) + 0xff900000)
//Bit 23:16 component 0
//Bit 15:8  component 1
//Bit 7:0 component 2
#define VDIN_MATRIX_HL_COLOR                       ((0x1229  << 2) + 0xff900000)
//28:16 probe x, postion
//12:0  probe y, position
#define VDIN_MATRIX_PROBE_POS                      ((0x122a  << 2) + 0xff900000)
#define VDIN_CHROMA_ADDR_PORT                      ((0x122b  << 2) + 0xff900000)
#define VDIN_CHROMA_DATA_PORT                      ((0x122c  << 2) + 0xff900000)
//
#define VDIN_CM_BRI_CON_CTRL                       ((0x122d  << 2) + 0xff900000)
//Bit 17  clk_cyc_cnt_clr, if true, clear this register
//Bit 16 if true, use vpu clock to count one line, otherwise use actually hsync to count line_cnt
//Bit 15:0   line width using vpu clk
#define VDIN_GO_LINE_CTRL                          ((0x122f  << 2) + 0xff900000)
//Bit 31:24 hist_pix_white_th, larger than this th is counted as white pixel
//Bit 23:16 hist_pix_black_th, less than this th is counted as black pixel
//Bit 11    hist_34bin_only,   34 bin only mode, including white/black
//Bit 10:9  ldim_stts_din_sel, 00: from matrix0 dout,  01: from vsc_dout, 10: from matrix1 dout, 11: form matrix1 din
//Bit 8     ldim_stts_en
//Bit 6:5   hist_dnlp_low   the real pixels in each bins got by VDIN_DNLP_HISTXX should multiple with 2^(dnlp_low+3)
//Bit 3:2   hist_din_sel    the source used for hist statistics.  00: from matrix0 dout,  01: from vsc_dout, 10: from matrix1 dout, 11: form matrix1 din
//Bit 1     hist_win_en     1'b0: hist used for full picture; 1'b1: hist used for pixels within hist window
//Bit 0     hist_spl_en     1'b0: disable hist readback; 1'b1: enable hist readback
#define VDIN_HIST_CTRL                             ((0x1230  << 2) + 0xff900000)
//Bit 28:16 hist_hstart  horizontal start value to define hist window
//Bit 12:0  hist_hend    horizontal end value to define hist window
#define VDIN_HIST_H_START_END                      ((0x1231  << 2) + 0xff900000)
//Bit 28:16 hist_vstart  vertical start value to define hist window
//Bit 12:0  hist_vend    vertical end value to define hist window
#define VDIN_HIST_V_START_END                      ((0x1232  << 2) + 0xff900000)
//Bit 15:8  hist_max    maximum value
//Bit 7:0   hist_min    minimum value
//read only
#define VDIN_HIST_MAX_MIN                          ((0x1233  << 2) + 0xff900000)
//Bit 31:0  hist_spl_rd
//counts for the total luma value
//read only
#define VDIN_HIST_SPL_VAL                          ((0x1234  << 2) + 0xff900000)
//Bit 21:0  hist_spl_pixel_count
//counts for the total calculated pixels
//read only
#define VDIN_HIST_SPL_PIX_CNT                      ((0x1235  << 2) + 0xff900000)
//Bit 31:0  hist_chroma_sum
//counts for the total chroma value
//read only
#define VDIN_HIST_CHROMA_SUM                       ((0x1236  << 2) + 0xff900000)
//Bit 31:16 higher hist bin
//Bit 15:0  lower hist bin
//0-255 are splited to 64 bins evenly, and VDIN_DNLP_HISTXX
//are the statistic number of pixels that within each bin.
//VDIN_DNLP_HIST00[15:0]  counts for the first  bin
//VDIN_DNLP_HIST00[31:16] counts for the second bin
//VDIN_DNLP_HIST01[15:0]  counts for the third  bin
//VDIN_DNLP_HIST01[31:16] counts for the fourth bin
//etc...
//read only
#define VDIN_DNLP_HIST00                           ((0x1237  << 2) + 0xff900000)
#define VDIN_DNLP_HIST01                           ((0x1238  << 2) + 0xff900000)
#define VDIN_DNLP_HIST02                           ((0x1239  << 2) + 0xff900000)
#define VDIN_DNLP_HIST03                           ((0x123a  << 2) + 0xff900000)
#define VDIN_DNLP_HIST04                           ((0x123b  << 2) + 0xff900000)
#define VDIN_DNLP_HIST05                           ((0x123c  << 2) + 0xff900000)
#define VDIN_DNLP_HIST06                           ((0x123d  << 2) + 0xff900000)
#define VDIN_DNLP_HIST07                           ((0x123e  << 2) + 0xff900000)
#define VDIN_DNLP_HIST08                           ((0x123f  << 2) + 0xff900000)
#define VDIN_DNLP_HIST09                           ((0x1240  << 2) + 0xff900000)
#define VDIN_DNLP_HIST10                           ((0x1241  << 2) + 0xff900000)
#define VDIN_DNLP_HIST11                           ((0x1242  << 2) + 0xff900000)
#define VDIN_DNLP_HIST12                           ((0x1243  << 2) + 0xff900000)
#define VDIN_DNLP_HIST13                           ((0x1244  << 2) + 0xff900000)
#define VDIN_DNLP_HIST14                           ((0x1245  << 2) + 0xff900000)
#define VDIN_DNLP_HIST15                           ((0x1246  << 2) + 0xff900000)
#define VDIN_DNLP_HIST16                           ((0x1247  << 2) + 0xff900000)
#define VDIN_DNLP_HIST17                           ((0x1248  << 2) + 0xff900000)
#define VDIN_DNLP_HIST18                           ((0x1249  << 2) + 0xff900000)
#define VDIN_DNLP_HIST19                           ((0x124a  << 2) + 0xff900000)
#define VDIN_DNLP_HIST20                           ((0x124b  << 2) + 0xff900000)
#define VDIN_DNLP_HIST21                           ((0x124c  << 2) + 0xff900000)
#define VDIN_DNLP_HIST22                           ((0x124d  << 2) + 0xff900000)
#define VDIN_DNLP_HIST23                           ((0x124e  << 2) + 0xff900000)
#define VDIN_DNLP_HIST24                           ((0x124f  << 2) + 0xff900000)
#define VDIN_DNLP_HIST25                           ((0x1250  << 2) + 0xff900000)
#define VDIN_DNLP_HIST26                           ((0x1251  << 2) + 0xff900000)
#define VDIN_DNLP_HIST27                           ((0x1252  << 2) + 0xff900000)
#define VDIN_DNLP_HIST28                           ((0x1253  << 2) + 0xff900000)
#define VDIN_DNLP_HIST29                           ((0x1254  << 2) + 0xff900000)
#define VDIN_DNLP_HIST30                           ((0x1255  << 2) + 0xff900000)
#define VDIN_DNLP_HIST31                           ((0x1256  << 2) + 0xff900000)
//Bit 31, local dimming statistic enable
//Bit 28, eol enable
//Bit 27:25, vertical line overlap number for max finding
//Bit 24:22, horizontal pixel overlap number, 0: 17 pix, 1: 9 pix, 2: 5 pix, 3: 3 pix, 4: 0 pix
//Bit 20, 1,2,1 low pass filter enable before max/hist statistic
//Bit 19:16, region H/V position index, refer to VDIN_LDIM_STTS_HIST_SET_REGION
//Bit 15, 1: region read index auto increase per read to VDIN_LDIM_STTS_HIST_READ_REGION
//Bit 6:0, region read index
#define VDIN_LDIM_STTS_HIST_REGION_IDX             ((0x1257  << 2) + 0xff900000)
//Bit 28:0, if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h0: read/write hvstart0
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h1: read/write hend01
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h2: read/write vend01
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h3: read/write hend23
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h4: read/write vend23
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h5: read/write hend45
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h6: read/write vend45
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'd7: read/write hend67
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h8: read/write vend67
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h9: read/write hend89
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'ha: read/write vend89
//hvstart0, Bit 28:16 row0 vstart, Bit 12:0 col0 hstart
//hend01, Bit 28:16 col1 hend, Bit 12:0 col0 hend
//vend01, Bit 28:16 row1 vend, Bit 12:0 row0 vend
//hend23, Bit 28:16 col3 hend, Bit 12:0 col2 hend
//vend23, Bit 28:16 row3 vend, Bit 12:0 row2 vend
//hend45, Bit 28:16 col5 hend, Bit 12:0 col4 hend
//vend45, Bit 28:16 row5 vend, Bit 12:0 row4 vend
//hend67, Bit 28:16 col7 hend, Bit 12:0 col6 hend
//vend67, Bit 28:16 row7 vend, Bit 12:0 row6 vend
//hend89, Bit 28:16 col9 hend, Bit 12:0 col8 hend
//vend89, Bit 28:16 row9 vend, Bit 12:0 row8 vend
#define VDIN_LDIM_STTS_HIST_SET_REGION             ((0x1258  << 2) + 0xff900000)
//REGION STATISTIC DATA READ OUT PORT, bit 29:20 max_comp2, bit 19:10 max_comp1, bit 9:0 max_comp0
#define VDIN_LDIM_STTS_HIST_READ_REGION            ((0x1259  << 2) + 0xff900000)
//Bit 18, reset bit, high active
//Bit 17, if true, widen hs/vs pulse
//Bit 16  vsync total counter always accumulating enable
//Bit 14:12, select hs/vs of video input channel to measure, 0: no selection, 1: vdi1, 2: vid2, 3: vid3, 4:vid4, 5:vdi5, 6:vid6, 7:vdi7, 8: vdi8
//Bit 11:4, vsync_span, define how many vsync span need to measure
//Bit 2:0  meas_hs_index, index to select which HS counter/range
#define VDIN_MEAS_CTRL0                            ((0x125a  << 2) + 0xff900000)
//Read only
//19:16     meas_ind_total_count_n, every number of sync_span vsyncs, this count add 1
//15:0      high bit portion of vsync total counter
#define VDIN_MEAS_VS_COUNT_HI                      ((0x125b  << 2) + 0xff900000)
//Read only
//31:0, low bit portion of vsync total counter
#define VDIN_MEAS_VS_COUNT_LO                      ((0x125c  << 2) + 0xff900000)
//according to the meas_hs_index in register VDIN_MEAS_CTRL0
//meas_hs_index == 0, first hs range
//meas_hs_index == 1, second hs range
//meas_hs_index == 2, third hs range
//meas_hs_index == 3, fourth hs range
//bit 28:16 count_start
//bit 12:0 count_end
#define VDIN_MEAS_HS_RANGE                         ((0x125d  << 2) + 0xff900000)
//Read only
//according to the meas_hs_index in register VDIN_MEAS_CTRL0,
//meas_hs_index == 0, first range hs counter,
//meas_hs_index == 1, second range hs coutner
//meas_hs_index == 2, third range hs coutner
//meas_hs_index == 3, fourth range hs coutner
//23:0
#define VDIN_MEAS_HS_COUNT                         ((0x125e  << 2) + 0xff900000)
//Bit 8      white_enable
//Bit 7:0    blkbar_white_level
#define VDIN_BLKBAR_CTRL1                          ((0x125f  << 2) + 0xff900000)
// Bit 31:24 blkbar_black_level    threshold to judge a black point
// Bit 23:21 Reserved
// Bit 20:8  blkbar_hwidth         left and right region width
// Bit 7:5   blkbar_comp_sel       select yin or uin or vin to be the valid input
// Bit 4     blkbar_sw_statistic_en enable software statistic of each block black points number
// Bit 3     blkbar_det_en
// Bit 2:1   blkbar_din_sel
// bit blkbar_det_top_en
#define VDIN_BLKBAR_CTRL0                          ((0x1260  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 blkbar_hstart.        Left region start
// Bit 15:13 Reserved
// Bit 12:0  blkbar_hend.          Right region end
#define VDIN_BLKBAR_H_START_END                    ((0x1261  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 blkbar_vstart
// Bit 15:13 Reserved
// Bit 12:0  blkbar_vend
#define VDIN_BLKBAR_V_START_END                    ((0x1262  << 2) + 0xff900000)
// Bit 31:20 Reserved
// Bit 19:0  blkbar_cnt_threshold. threshold to judge whether a block is totally black
#define VDIN_BLKBAR_CNT_THRESHOLD                  ((0x1263  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 blkbar_row_th1.       //threshold of the top blackbar
// Bit 15:13 Reserved
// bit 12:0  blkbar_row_th2        //threshold of the bottom blackbar
#define VDIN_BLKBAR_ROW_TH1_TH2                    ((0x1264  << 2) + 0xff900000)
//Readonly
// Bit 31:29 Reserved
// Bit 28:16 blkbar_ind_left_start. horizontal start of the left region in the current searching
// Bit 15:13 Reserved
// Bit 12:0  blkbar_ind_left_end.   horizontal end of the left region in the current searching
#define VDIN_BLKBAR_IND_LEFT_START_END             ((0x1265  << 2) + 0xff900000)
//Readonly
// Bit 31:29 Reserved
// Bit 28:16 blkbar_ind_right_start.horizontal start of the right region in the current searching
// Bit 15:13 Reserved
// Bit 12:0  blkbar_ind_right_end.  horizontal end of the right region in the current searching
#define VDIN_BLKBAR_IND_RIGHT_START_END            ((0x1266  << 2) + 0xff900000)
//Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_left1_cnt.  Black pixel counter. left part of the left region
#define VDIN_BLKBAR_IND_LEFT1_CNT                  ((0x1267  << 2) + 0xff900000)
//Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_left2_cnt.  Black pixel counter. right part of the left region
#define VDIN_BLKBAR_IND_LEFT2_CNT                  ((0x1268  << 2) + 0xff900000)
//Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_right1_cnt. Black pixel counter. left part of the right region
#define VDIN_BLKBAR_IND_RIGHT1_CNT                 ((0x1269  << 2) + 0xff900000)
//Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_right2_cnt. Black pixel counter. right part of the right region
#define VDIN_BLKBAR_IND_RIGHT2_CNT                 ((0x126a  << 2) + 0xff900000)
//Readonly
// Bit 31:30 reserved
// Bit 29    blkbar_ind_black_det_done. LEFT/RIGHT Black detection done
// Bit 28:16 blkbar_top_pos.            Top black bar position
// Bit 15:13 Reserved.
// Bit 12:0  blkbar_bot_pos.            Bottom black bar position
#define VDIN_BLKBAR_STATUS0                        ((0x126b  << 2) + 0xff900000)
//Readonly
// Bit 31:29 Reserved
// Bit 28:16 blkbar_left_pos.       Left black bar position
// Bit 15:13 Reserved
// Bit 12:0  blkbar_right_pos.      Right black bar position
#define VDIN_BLKBAR_STATUS1                        ((0x126c  << 2) + 0xff900000)
//Bit 28:16 input window H start
//Bit 12:0  input window H end
#define VDIN_WIN_H_START_END                       ((0x126d  << 2) + 0xff900000)
//Bit 28:16 input window H start
//Bit 12:0  input window V start
#define VDIN_WIN_V_START_END                       ((0x126e  << 2) + 0xff900000)
//Bit 23:16 vdi8 asfifo_ctrl
//Bit 15:8 vdi7 asfifo_ctrl
//Bit 7:0 vdi6 asfifo_ctrl
#define VDIN_ASFIFO_CTRL3                          ((0x126f  << 2) + 0xff900000)
//Bit 3:2 vshrk_clk2_ctrl
//Bit 1:0 vshrk_clk1_ctrl
#define VDIN_COM_GCLK_CTRL2                        ((0x1270  << 2) + 0xff900000)
//Bit 27 vshrk_en
//Bit 26:25 vshrk_mode
//Bit 24 vshrk_lpf_mode
//Bit 23:0 vshrk_dummy
#define VDIN_VSHRK_CTRL                            ((0x1271  << 2) + 0xff900000)
#define VDIN_DNLP_HIST32                           ((0x1272  << 2) + 0xff900000)
//Read only
//Bit 7, vdi9 fifo overflow
//Bit 5:0, vdi9_asfifo_cnt
#define VDIN_COM_STATUS3                           ((0x1273  << 2) + 0xff900000)
#define VDIN_SYNC_MASK                             ((0x1274  << 2) + 0xff900000)
//Bit 7:0,  hsync_mask_num
//Bit 15:8, vsync_mask_num
//Bit 16,   hsync_mask_enable
//Bit 17,   vsync_mask_num
//dolby vdin
#define VDIN_DOLBY_DSC_CTRL0                       ((0x1275  << 2) + 0xff900000)
#define VDIN_DOLBY_DSC_CTRL1                       ((0x1276  << 2) + 0xff900000)
#define VDIN_DOLBY_DSC_CTRL2                       ((0x1277  << 2) + 0xff900000)
#define VDIN_DOLBY_DSC_CTRL3                       ((0x1278  << 2) + 0xff900000)
#define VDIN_DOLBY_AXI_CTRL0                       ((0x1279  << 2) + 0xff900000)
#define VDIN_DOLBY_AXI_CTRL1                       ((0x127a  << 2) + 0xff900000)
#define VDIN_DOLBY_AXI_CTRL2                       ((0x127b  << 2) + 0xff900000)
#define VDIN_DOLBY_AXI_CTRL3                       ((0x127c  << 2) + 0xff900000)
#define VDIN_DOLBY_DSC_STATUS0                     ((0x127d  << 2) + 0xff900000)
#define VDIN_DOLBY_DSC_STATUS1                     ((0x127e  << 2) + 0xff900000)
#define VDIN_DOLBY_DSC_STATUS2                     ((0x127f  << 2) + 0xff900000)
#define VDIN_DOLBY_DSC_STATUS3                     ((0x121d  << 2) + 0xff900000)

//8'h72 occupied by histogram 32
//VDIN0        8'h00 - 8'h7f
#define VDIN0_SCALE_COEF_IDX                    ((VDIN0_OFFSET << 2) + VDIN_SCALE_COEF_IDX               )
#define VDIN0_SCALE_COEF                        ((VDIN0_OFFSET << 2) + VDIN_SCALE_COEF                   )
#define VDIN0_COM_CTRL0                         ((VDIN0_OFFSET << 2) + VDIN_COM_CTRL0                    )
#define VDIN0_ACTIVE_MAX_PIX_CNT_STATUS         ((VDIN0_OFFSET << 2) + VDIN_ACTIVE_MAX_PIX_CNT_STATUS    )
#define VDIN0_LCNT_STATUS                       ((VDIN0_OFFSET << 2) + VDIN_LCNT_STATUS                  )
#define VDIN0_COM_STATUS0                       ((VDIN0_OFFSET << 2) + VDIN_COM_STATUS0                  )
#define VDIN0_COM_STATUS1                       ((VDIN0_OFFSET << 2) + VDIN_COM_STATUS1                  )
#define VDIN0_LCNT_SHADOW_STATUS                ((VDIN0_OFFSET << 2) + VDIN_LCNT_SHADOW_STATUS           )
#define VDIN0_ASFIFO_CTRL0                      ((VDIN0_OFFSET << 2) + VDIN_ASFIFO_CTRL0                 )
#define VDIN0_ASFIFO_CTRL1                      ((VDIN0_OFFSET << 2) + VDIN_ASFIFO_CTRL1                 )
#define VDIN0_WIDTHM1I_WIDTHM1O                 ((VDIN0_OFFSET << 2) + VDIN_WIDTHM1I_WIDTHM1O            )
#define VDIN0_SC_MISC_CTRL                      ((VDIN0_OFFSET << 2) + VDIN_SC_MISC_CTRL                 )
#define VDIN0_HSC_PHASE_STEP                    ((VDIN0_OFFSET << 2) + VDIN_HSC_PHASE_STEP               )
#define VDIN0_HSC_INI_CTRL                      ((VDIN0_OFFSET << 2) + VDIN_HSC_INI_CTRL                 )
#define VDIN0_COM_STATUS2                       ((VDIN0_OFFSET << 2) + VDIN_COM_STATUS2                  )
#define VDIN0_COM_STATUS3                       ((VDIN0_OFFSET << 2) + VDIN_COM_STATUS3                  )
#define VDIN0_ASFIFO_CTRL2                      ((VDIN0_OFFSET << 2) + VDIN_ASFIFO_CTRL2                 )
#define VDIN0_MATRIX_CTRL                       ((VDIN0_OFFSET << 2) + VDIN_MATRIX_CTRL                  )
#define VDIN0_MATRIX_COEF00_01                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_COEF00_01             )
#define VDIN0_MATRIX_COEF02_10                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_COEF02_10             )
#define VDIN0_MATRIX_COEF11_12                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_COEF11_12             )
#define VDIN0_MATRIX_COEF20_21                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_COEF20_21             )
#define VDIN0_MATRIX_COEF22                     ((VDIN0_OFFSET << 2) + VDIN_MATRIX_COEF22                )
#define VDIN0_MATRIX_OFFSET0_1                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_OFFSET0_1             )
#define VDIN0_MATRIX_OFFSET2                    ((VDIN0_OFFSET << 2) + VDIN_MATRIX_OFFSET2               )
#define VDIN0_MATRIX_PRE_OFFSET0_1              ((VDIN0_OFFSET << 2) + VDIN_MATRIX_PRE_OFFSET0_1         )
#define VDIN0_MATRIX_PRE_OFFSET2                ((VDIN0_OFFSET << 2) + VDIN_MATRIX_PRE_OFFSET2           )
#define VDIN0_LFIFO_CTRL                        ((VDIN0_OFFSET << 2) + VDIN_LFIFO_CTRL                   )
#define VDIN0_COM_GCLK_CTRL                     ((VDIN0_OFFSET << 2) + VDIN_COM_GCLK_CTRL                )
#define VDIN0_INTF_WIDTHM1                      ((VDIN0_OFFSET << 2) + VDIN_INTF_WIDTHM1                 )
#define VDIN0_WR_CTRL2                          ((VDIN0_OFFSET << 2) + VDIN_WR_CTRL2                     )
#define VDIN0_WR_CTRL                           ((VDIN0_OFFSET << 2) + VDIN_WR_CTRL                      )
#define VDIN0_WR_H_START_END                    ((VDIN0_OFFSET << 2) + VDIN_WR_H_START_END               )
#define VDIN0_WR_V_START_END                    ((VDIN0_OFFSET << 2) + VDIN_WR_V_START_END               )
#define VDIN0_VSC_PHASE_STEP                    ((VDIN0_OFFSET << 2) + VDIN_VSC_PHASE_STEP               )
#define VDIN0_VSC_INI_CTRL                      ((VDIN0_OFFSET << 2) + VDIN_VSC_INI_CTRL                 )
#define VDIN0_SCIN_HEIGHTM1                     ((VDIN0_OFFSET << 2) + VDIN_SCIN_HEIGHTM1                )
#define VDIN0_DUMMY_DATA                        ((VDIN0_OFFSET << 2) + VDIN_DUMMY_DATA                   )
#define VDIN0_MATRIX_PROBE_COLOR                ((VDIN0_OFFSET << 2) + VDIN_MATRIX_PROBE_COLOR           )
#define VDIN0_MATRIX_HL_COLOR                   ((VDIN0_OFFSET << 2) + VDIN_MATRIX_HL_COLOR              )
#define VDIN0_MATRIX_PROBE_POS                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_PROBE_POS             )
#define VDIN0_CHROMA_ADDR_PORT                  ((VDIN0_OFFSET << 2) + VDIN_CHROMA_ADDR_PORT             )
#define VDIN0_CHROMA_DATA_PORT                  ((VDIN0_OFFSET << 2) + VDIN_CHROMA_DATA_PORT             )
#define VDIN0_CM_BRI_CON_CTRL                   ((VDIN0_OFFSET << 2) + VDIN_CM_BRI_CON_CTRL              )
#define VDIN0_HIST_CTRL                         ((VDIN0_OFFSET << 2) + VDIN_HIST_CTRL                    )
#define VDIN0_HIST_H_START_END                  ((VDIN0_OFFSET << 2) + VDIN_HIST_H_START_END             )
#define VDIN0_HIST_V_START_END                  ((VDIN0_OFFSET << 2) + VDIN_HIST_V_START_END             )
#define VDIN0_HIST_MAX_MIN                      ((VDIN0_OFFSET << 2) + VDIN_HIST_MAX_MIN                 )
#define VDIN0_HIST_SPL_VAL                      ((VDIN0_OFFSET << 2) + VDIN_HIST_SPL_VAL                 )
#define VDIN0_HIST_SPL_PIX_CNT                  ((VDIN0_OFFSET << 2) + VDIN_HIST_SPL_PIX_CNT             )
#define VDIN0_HIST_CHROMA_SUM                   ((VDIN0_OFFSET << 2) + VDIN_HIST_CHROMA_SUM              )
#define VDIN0_DNLP_HIST00                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST00                  )
#define VDIN0_DNLP_HIST01                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST01                  )
#define VDIN0_DNLP_HIST02                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST02                  )
#define VDIN0_DNLP_HIST03                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST03                  )
#define VDIN0_DNLP_HIST04                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST04                  )
#define VDIN0_DNLP_HIST05                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST05                  )
#define VDIN0_DNLP_HIST06                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST06                  )
#define VDIN0_DNLP_HIST07                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST07                  )
#define VDIN0_DNLP_HIST08                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST08                  )
#define VDIN0_DNLP_HIST09                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST09                  )
#define VDIN0_DNLP_HIST10                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST10                  )
#define VDIN0_DNLP_HIST11                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST11                  )
#define VDIN0_DNLP_HIST12                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST12                  )
#define VDIN0_DNLP_HIST13                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST13                  )
#define VDIN0_DNLP_HIST14                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST14                  )
#define VDIN0_DNLP_HIST15                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST15                  )
#define VDIN0_DNLP_HIST16                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST16                  )
#define VDIN0_DNLP_HIST17                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST17                  )
#define VDIN0_DNLP_HIST18                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST18                  )
#define VDIN0_DNLP_HIST19                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST19                  )
#define VDIN0_DNLP_HIST20                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST20                  )
#define VDIN0_DNLP_HIST21                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST21                  )
#define VDIN0_DNLP_HIST22                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST22                  )
#define VDIN0_DNLP_HIST23                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST23                  )
#define VDIN0_DNLP_HIST24                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST24                  )
#define VDIN0_DNLP_HIST25                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST25                  )
#define VDIN0_DNLP_HIST26                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST26                  )
#define VDIN0_DNLP_HIST27                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST27                  )
#define VDIN0_DNLP_HIST28                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST28                  )
#define VDIN0_DNLP_HIST29                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST29                  )
#define VDIN0_DNLP_HIST30                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST30                  )
#define VDIN0_DNLP_HIST31                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST31                  )
#define VDIN0_DNLP_HIST32                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST32                  )
#define VDIN0_LDIM_STTS_HIST_REGION_IDX         ((VDIN0_OFFSET << 2) + VDIN_LDIM_STTS_HIST_REGION_IDX    )
#define VDIN0_LDIM_STTS_HIST_SET_REGION         ((VDIN0_OFFSET << 2) + VDIN_LDIM_STTS_HIST_SET_REGION    )
#define VDIN0_LDIM_STTS_HIST_READ_REGION        ((VDIN0_OFFSET << 2) + VDIN_LDIM_STTS_HIST_READ_REGION   )
#define VDIN0_MEAS_CTRL0                        ((VDIN0_OFFSET << 2) + VDIN_MEAS_CTRL0                   )
#define VDIN0_MEAS_VS_COUNT_HI                  ((VDIN0_OFFSET << 2) + VDIN_MEAS_VS_COUNT_HI             )
#define VDIN0_MEAS_VS_COUNT_LO                  ((VDIN0_OFFSET << 2) + VDIN_MEAS_VS_COUNT_LO             )
#define VDIN0_MEAS_HS_RANGE                     ((VDIN0_OFFSET << 2) + VDIN_MEAS_HS_RANGE                )
#define VDIN0_MEAS_HS_COUNT                     ((VDIN0_OFFSET << 2) + VDIN_MEAS_HS_COUNT                )
#define VDIN0_BLKBAR_CTRL1                      ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_CTRL1                 )
#define VDIN0_BLKBAR_CTRL0                      ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_CTRL0                 )
#define VDIN0_BLKBAR_H_START_END                ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_H_START_END           )
#define VDIN0_BLKBAR_V_START_END                ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_V_START_END           )
#define VDIN0_BLKBAR_CNT_THRESHOLD              ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_CNT_THRESHOLD         )
#define VDIN0_BLKBAR_ROW_TH1_TH2                ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_ROW_TH1_TH2           )
#define VDIN0_BLKBAR_IND_LEFT_START_END         ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT_START_END    )
#define VDIN0_BLKBAR_IND_RIGHT_START_END        ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT_START_END   )
#define VDIN0_BLKBAR_IND_LEFT1_CNT              ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT1_CNT         )
#define VDIN0_BLKBAR_IND_LEFT2_CNT              ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT2_CNT         )
#define VDIN0_BLKBAR_IND_RIGHT1_CNT             ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT1_CNT        )
#define VDIN0_BLKBAR_IND_RIGHT2_CNT             ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT2_CNT        )
#define VDIN0_BLKBAR_STATUS0                    ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_STATUS0               )
#define VDIN0_BLKBAR_STATUS1                    ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_STATUS1               )
#define VDIN0_WIN_H_START_END                   ((VDIN0_OFFSET << 2) + VDIN_WIN_H_START_END              )
#define VDIN0_WIN_V_START_END                   ((VDIN0_OFFSET << 2) + VDIN_WIN_V_START_END              )
#define VDIN0_ASFIFO_CTRL3                      ((VDIN0_OFFSET << 2) + VDIN_ASFIFO_CTRL3                 )
#define VDIN0_COM_GCLK_CTRL2                    ((VDIN0_OFFSET << 2) + VDIN_COM_GCLK_CTRL2               )
#define VDIN0_VSHRK_CTRL                        ((VDIN0_OFFSET << 2) + VDIN_VSHRK_CTRL                   )
#define VDIN0_SYNC_MASK                         ((VDIN0_OFFSET << 2) + VDIN_SYNC_MASK                    )
#define VDIN0_DOLBY_DSC_CTRL0                    ((VDIN0_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL0  )
#define VDIN0_DOLBY_DSC_CTRL1                    ((VDIN0_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL1  )
#define VDIN0_DOLBY_DSC_CTRL2                    ((VDIN0_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL2  )
#define VDIN0_DOLBY_DSC_CTRL3                    ((VDIN0_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL3  )
#define VDIN0_DOLBY_AXI_CTRL0                    ((VDIN0_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL0  )
#define VDIN0_DOLBY_AXI_CTRL1                    ((VDIN0_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL1  )
#define VDIN0_DOLBY_AXI_CTRL2                    ((VDIN0_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL2  )
#define VDIN0_DOLBY_AXI_CTRL3                    ((VDIN0_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL3  )
#define VDIN0_DOLBY_DSC_STATUS0                  ((VDIN0_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS0)
#define VDIN0_DOLBY_DSC_STATUS1                  ((VDIN0_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS1)
#define VDIN0_DOLBY_DSC_STATUS2                  ((VDIN0_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS2)
#define VDIN0_DOLBY_DSC_STATUS3                  ((VDIN0_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS3)


//VDIN1        8'h80 - 8'hef
#define VDIN1_SCALE_COEF_IDX                    ((VDIN1_OFFSET << 2) + VDIN_SCALE_COEF_IDX               )
#define VDIN1_SCALE_COEF                        ((VDIN1_OFFSET << 2) + VDIN_SCALE_COEF                   )
#define VDIN1_COM_CTRL0                         ((VDIN1_OFFSET << 2) + VDIN_COM_CTRL0                    )
#define VDIN1_ACTIVE_MAX_PIX_CNT_STATUS         ((VDIN1_OFFSET << 2) + VDIN_ACTIVE_MAX_PIX_CNT_STATUS    )
#define VDIN1_LCNT_STATUS                       ((VDIN1_OFFSET << 2) + VDIN_LCNT_STATUS                  )
#define VDIN1_COM_STATUS0                       ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS0                  )
#define VDIN1_COM_STATUS1                       ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS1                  )
#define VDIN1_LCNT_SHADOW_STATUS                ((VDIN1_OFFSET << 2) + VDIN_LCNT_SHADOW_STATUS           )
#define VDIN1_ASFIFO_CTRL0                      ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL0                 )
#define VDIN1_ASFIFO_CTRL1                      ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL1                 )
#define VDIN1_WIDTHM1I_WIDTHM1O                 ((VDIN1_OFFSET << 2) + VDIN_WIDTHM1I_WIDTHM1O            )
#define VDIN1_SC_MISC_CTRL                      ((VDIN1_OFFSET << 2) + VDIN_SC_MISC_CTRL                 )
#define VDIN1_HSC_PHASE_STEP                    ((VDIN1_OFFSET << 2) + VDIN_HSC_PHASE_STEP               )
#define VDIN1_HSC_INI_CTRL                      ((VDIN1_OFFSET << 2) + VDIN_HSC_INI_CTRL                 )
#define VDIN1_COM_STATUS2                       ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS2                  )
#define VDIN1_COM_STATUS3                       ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS3                  )
#define VDIN1_ASFIFO_CTRL2                      ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL2                 )
#define VDIN1_MATRIX_CTRL                       ((VDIN1_OFFSET << 2) + VDIN_MATRIX_CTRL                  )
#define VDIN1_MATRIX_COEF00_01                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF00_01             )
#define VDIN1_MATRIX_COEF02_10                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF02_10             )
#define VDIN1_MATRIX_COEF11_12                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF11_12             )
#define VDIN1_MATRIX_COEF20_21                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF20_21             )
#define VDIN1_MATRIX_COEF22                     ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF22                )
#define VDIN1_MATRIX_OFFSET0_1                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_OFFSET0_1             )
#define VDIN1_MATRIX_OFFSET2                    ((VDIN1_OFFSET << 2) + VDIN_MATRIX_OFFSET2               )
#define VDIN1_MATRIX_PRE_OFFSET0_1              ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PRE_OFFSET0_1         )
#define VDIN1_MATRIX_PRE_OFFSET2                ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PRE_OFFSET2           )
#define VDIN1_LFIFO_CTRL                        ((VDIN1_OFFSET << 2) + VDIN_LFIFO_CTRL                   )
#define VDIN1_COM_GCLK_CTRL                     ((VDIN1_OFFSET << 2) + VDIN_COM_GCLK_CTRL                )
#define VDIN1_INTF_WIDTHM1                      ((VDIN1_OFFSET << 2) + VDIN_INTF_WIDTHM1                 )
#define VDIN1_WR_CTRL2                          ((VDIN1_OFFSET << 2) + VDIN_WR_CTRL2                     )
#define VDIN1_WR_CTRL                           ((VDIN1_OFFSET << 2) + VDIN_WR_CTRL                      )
#define VDIN1_WR_H_START_END                    ((VDIN1_OFFSET << 2) + VDIN_WR_H_START_END               )
#define VDIN1_WR_V_START_END                    ((VDIN1_OFFSET << 2) + VDIN_WR_V_START_END               )
#define VDIN1_VSC_PHASE_STEP                    ((VDIN1_OFFSET << 2) + VDIN_VSC_PHASE_STEP               )
#define VDIN1_VSC_INI_CTRL                      ((VDIN1_OFFSET << 2) + VDIN_VSC_INI_CTRL                 )
#define VDIN1_SCIN_HEIGHTM1                     ((VDIN1_OFFSET << 2) + VDIN_SCIN_HEIGHTM1                )
#define VDIN1_DUMMY_DATA                        ((VDIN1_OFFSET << 2) + VDIN_DUMMY_DATA                   )
#define VDIN1_MATRIX_PROBE_COLOR                ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PROBE_COLOR           )
#define VDIN1_MATRIX_HL_COLOR                   ((VDIN1_OFFSET << 2) + VDIN_MATRIX_HL_COLOR              )
#define VDIN1_MATRIX_PROBE_POS                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PROBE_POS             )
#define VDIN1_CHROMA_ADDR_PORT                  ((VDIN1_OFFSET << 2) + VDIN_CHROMA_ADDR_PORT             )
#define VDIN1_CHROMA_DATA_PORT                  ((VDIN1_OFFSET << 2) + VDIN_CHROMA_DATA_PORT             )
#define VDIN1_CM_BRI_CON_CTRL                   ((VDIN1_OFFSET << 2) + VDIN_CM_BRI_CON_CTRL              )
#define VDIN1_HIST_CTRL                         ((VDIN1_OFFSET << 2) + VDIN_HIST_CTRL                    )
#define VDIN1_HIST_H_START_END                  ((VDIN1_OFFSET << 2) + VDIN_HIST_H_START_END             )
#define VDIN1_HIST_V_START_END                  ((VDIN1_OFFSET << 2) + VDIN_HIST_V_START_END             )
#define VDIN1_HIST_MAX_MIN                      ((VDIN1_OFFSET << 2) + VDIN_HIST_MAX_MIN                 )
#define VDIN1_HIST_SPL_VAL                      ((VDIN1_OFFSET << 2) + VDIN_HIST_SPL_VAL                 )
#define VDIN1_HIST_SPL_PIX_CNT                  ((VDIN1_OFFSET << 2) + VDIN_HIST_SPL_PIX_CNT             )
#define VDIN1_HIST_CHROMA_SUM                   ((VDIN1_OFFSET << 2) + VDIN_HIST_CHROMA_SUM              )
#define VDIN1_DNLP_HIST00                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST00                  )
#define VDIN1_DNLP_HIST01                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST01                  )
#define VDIN1_DNLP_HIST02                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST02                  )
#define VDIN1_DNLP_HIST03                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST03                  )
#define VDIN1_DNLP_HIST04                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST04                  )
#define VDIN1_DNLP_HIST05                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST05                  )
#define VDIN1_DNLP_HIST06                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST06                  )
#define VDIN1_DNLP_HIST07                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST07                  )
#define VDIN1_DNLP_HIST08                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST08                  )
#define VDIN1_DNLP_HIST09                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST09                  )
#define VDIN1_DNLP_HIST10                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST10                  )
#define VDIN1_DNLP_HIST11                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST11                  )
#define VDIN1_DNLP_HIST12                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST12                  )
#define VDIN1_DNLP_HIST13                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST13                  )
#define VDIN1_DNLP_HIST14                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST14                  )
#define VDIN1_DNLP_HIST15                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST15                  )
#define VDIN1_DNLP_HIST16                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST16                  )
#define VDIN1_DNLP_HIST17                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST17                  )
#define VDIN1_DNLP_HIST18                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST18                  )
#define VDIN1_DNLP_HIST19                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST19                  )
#define VDIN1_DNLP_HIST20                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST20                  )
#define VDIN1_DNLP_HIST21                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST21                  )
#define VDIN1_DNLP_HIST22                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST22                  )
#define VDIN1_DNLP_HIST23                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST23                  )
#define VDIN1_DNLP_HIST24                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST24                  )
#define VDIN1_DNLP_HIST25                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST25                  )
#define VDIN1_DNLP_HIST26                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST26                  )
#define VDIN1_DNLP_HIST27                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST27                  )
#define VDIN1_DNLP_HIST28                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST28                  )
#define VDIN1_DNLP_HIST29                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST29                  )
#define VDIN1_DNLP_HIST30                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST30                  )
#define VDIN1_DNLP_HIST31                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST31                  )
#define VDIN1_DNLP_HIST32                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST32                  )
#define VDIN1_LDIM_STTS_HIST_REGION_IDX         ((VDIN1_OFFSET << 2) + VDIN_LDIM_STTS_HIST_REGION_IDX    )
#define VDIN1_LDIM_STTS_HIST_SET_REGION         ((VDIN1_OFFSET << 2) + VDIN_LDIM_STTS_HIST_SET_REGION    )
#define VDIN1_LDIM_STTS_HIST_READ_REGION        ((VDIN1_OFFSET << 2) + VDIN_LDIM_STTS_HIST_READ_REGION   )
#define VDIN1_MEAS_CTRL0                        ((VDIN1_OFFSET << 2) + VDIN_MEAS_CTRL0                   )
#define VDIN1_MEAS_VS_COUNT_HI                  ((VDIN1_OFFSET << 2) + VDIN_MEAS_VS_COUNT_HI             )
#define VDIN1_MEAS_VS_COUNT_LO                  ((VDIN1_OFFSET << 2) + VDIN_MEAS_VS_COUNT_LO             )
#define VDIN1_MEAS_HS_RANGE                     ((VDIN1_OFFSET << 2) + VDIN_MEAS_HS_RANGE                )
#define VDIN1_MEAS_HS_COUNT                     ((VDIN1_OFFSET << 2) + VDIN_MEAS_HS_COUNT                )
#define VDIN1_BLKBAR_CTRL1                      ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_CTRL1                 )
#define VDIN1_BLKBAR_CTRL0                      ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_CTRL0                 )
#define VDIN1_BLKBAR_H_START_END                ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_H_START_END           )
#define VDIN1_BLKBAR_V_START_END                ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_V_START_END           )
#define VDIN1_BLKBAR_CNT_THRESHOLD              ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_CNT_THRESHOLD         )
#define VDIN1_BLKBAR_ROW_TH1_TH2                ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_ROW_TH1_TH2           )
#define VDIN1_BLKBAR_IND_LEFT_START_END         ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT_START_END    )
#define VDIN1_BLKBAR_IND_RIGHT_START_END        ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT_START_END   )
#define VDIN1_BLKBAR_IND_LEFT1_CNT              ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT1_CNT         )
#define VDIN1_BLKBAR_IND_LEFT2_CNT              ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT2_CNT         )
#define VDIN1_BLKBAR_IND_RIGHT1_CNT             ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT1_CNT        )
#define VDIN1_BLKBAR_IND_RIGHT2_CNT             ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT2_CNT        )
#define VDIN1_BLKBAR_STATUS0                    ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_STATUS0               )
#define VDIN1_BLKBAR_STATUS1                    ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_STATUS1               )
#define VDIN1_WIN_H_START_END                   ((VDIN1_OFFSET << 2) + VDIN_WIN_H_START_END              )
#define VDIN1_WIN_V_START_END                   ((VDIN1_OFFSET << 2) + VDIN_WIN_V_START_END              )
#define VDIN1_ASFIFO_CTRL3                      ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL3                 )
#define VDIN1_COM_GCLK_CTRL2                    ((VDIN1_OFFSET << 2) + VDIN_COM_GCLK_CTRL2               )
#define VDIN1_VSHRK_CTRL                        ((VDIN1_OFFSET << 2) + VDIN_VSHRK_CTRL                   )
#define VDIN1_SYNC_MASK                         ((VDIN1_OFFSET << 2) + VDIN_SYNC_MASK                    )
#define VDIN1_DOLBY_DSC_CTRL0                    ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL0  )
#define VDIN1_DOLBY_DSC_CTRL1                    ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL1  )
#define VDIN1_DOLBY_DSC_CTRL2                    ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL2  )
#define VDIN1_DOLBY_DSC_CTRL3                    ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL3  )
#define VDIN1_DOLBY_AXI_CTRL0                    ((VDIN1_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL0  )
#define VDIN1_DOLBY_AXI_CTRL1                    ((VDIN1_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL1  )
#define VDIN1_DOLBY_AXI_CTRL2                    ((VDIN1_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL2  )
#define VDIN1_DOLBY_AXI_CTRL3                    ((VDIN1_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL3  )
#define VDIN1_DOLBY_DSC_STATUS0                  ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS0)
#define VDIN1_DOLBY_DSC_STATUS1                  ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS1)
#define VDIN1_DOLBY_DSC_STATUS2                  ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS2)
#define VDIN1_DOLBY_DSC_STATUS3                  ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS3)

//`define LCD_VCBUS_BASE               8'h14
//
// Reading file:  lcd_regs.h
//
// -----------------------------------------------
// CBUS_BASE:  LCD_VCBUS_BASE = 0x14
// -----------------------------------------------
//========================================================================
//LCD DRV     12'h480~12'h4ef
//=======================================================================
#define L_GAMMA_CNTL_PORT                          ((0x1400  << 2) + 0xff900000)
#define L_GAMMA_DATA_PORT                          ((0x1401  << 2) + 0xff900000)
#define L_GAMMA_ADDR_PORT                          ((0x1402  << 2) + 0xff900000)
#define L_GAMMA_VCOM_HSWITCH_ADDR                  ((0x1403  << 2) + 0xff900000)
#define L_RGB_BASE_ADDR                            ((0x1405  << 2) + 0xff900000)
#define L_RGB_COEFF_ADDR                           ((0x1406  << 2) + 0xff900000)
#define L_POL_CNTL_ADDR                            ((0x1407  << 2) + 0xff900000)
#define L_DITH_CNTL_ADDR                           ((0x1408  << 2) + 0xff900000)
#define L_GAMMA_PROBE_CTRL                         ((0x1409  << 2) + 0xff900000)
//read only
#define L_GAMMA_PROBE_COLOR_L                      ((0x140a  << 2) + 0xff900000)
#define L_GAMMA_PROBE_COLOR_H                      ((0x140b  << 2) + 0xff900000)
#define L_GAMMA_PROBE_HL_COLOR                     ((0x140c  << 2) + 0xff900000)
#define L_GAMMA_PROBE_POS_X                        ((0x140d  << 2) + 0xff900000)
#define L_GAMMA_PROBE_POS_Y                        ((0x140e  << 2) + 0xff900000)
#define L_STH1_HS_ADDR                             ((0x1410  << 2) + 0xff900000)
#define L_STH1_HE_ADDR                             ((0x1411  << 2) + 0xff900000)
#define L_STH1_VS_ADDR                             ((0x1412  << 2) + 0xff900000)
#define L_STH1_VE_ADDR                             ((0x1413  << 2) + 0xff900000)
#define L_STH2_HS_ADDR                             ((0x1414  << 2) + 0xff900000)
#define L_STH2_HE_ADDR                             ((0x1415  << 2) + 0xff900000)
#define L_STH2_VS_ADDR                             ((0x1416  << 2) + 0xff900000)
#define L_STH2_VE_ADDR                             ((0x1417  << 2) + 0xff900000)
#define L_OEH_HS_ADDR                              ((0x1418  << 2) + 0xff900000)
#define L_OEH_HE_ADDR                              ((0x1419  << 2) + 0xff900000)
#define L_OEH_VS_ADDR                              ((0x141a  << 2) + 0xff900000)
#define L_OEH_VE_ADDR                              ((0x141b  << 2) + 0xff900000)
#define L_VCOM_HSWITCH_ADDR                        ((0x141c  << 2) + 0xff900000)
#define L_VCOM_VS_ADDR                             ((0x141d  << 2) + 0xff900000)
#define L_VCOM_VE_ADDR                             ((0x141e  << 2) + 0xff900000)
#define L_CPV1_HS_ADDR                             ((0x141f  << 2) + 0xff900000)
#define L_CPV1_HE_ADDR                             ((0x1420  << 2) + 0xff900000)
#define L_CPV1_VS_ADDR                             ((0x1421  << 2) + 0xff900000)
#define L_CPV1_VE_ADDR                             ((0x1422  << 2) + 0xff900000)
#define L_CPV2_HS_ADDR                             ((0x1423  << 2) + 0xff900000)
#define L_CPV2_HE_ADDR                             ((0x1424  << 2) + 0xff900000)
#define L_CPV2_VS_ADDR                             ((0x1425  << 2) + 0xff900000)
#define L_CPV2_VE_ADDR                             ((0x1426  << 2) + 0xff900000)
#define L_STV1_HS_ADDR                             ((0x1427  << 2) + 0xff900000)
#define L_STV1_HE_ADDR                             ((0x1428  << 2) + 0xff900000)
#define L_STV1_VS_ADDR                             ((0x1429  << 2) + 0xff900000)
#define L_STV1_VE_ADDR                             ((0x142a  << 2) + 0xff900000)
#define L_STV2_HS_ADDR                             ((0x142b  << 2) + 0xff900000)
#define L_STV2_HE_ADDR                             ((0x142c  << 2) + 0xff900000)
#define L_STV2_VS_ADDR                             ((0x142d  << 2) + 0xff900000)
#define L_STV2_VE_ADDR                             ((0x142e  << 2) + 0xff900000)
#define L_OEV1_HS_ADDR                             ((0x142f  << 2) + 0xff900000)
#define L_OEV1_HE_ADDR                             ((0x1430  << 2) + 0xff900000)
#define L_OEV1_VS_ADDR                             ((0x1431  << 2) + 0xff900000)
#define L_OEV1_VE_ADDR                             ((0x1432  << 2) + 0xff900000)
#define L_OEV2_HS_ADDR                             ((0x1433  << 2) + 0xff900000)
#define L_OEV2_HE_ADDR                             ((0x1434  << 2) + 0xff900000)
#define L_OEV2_VS_ADDR                             ((0x1435  << 2) + 0xff900000)
#define L_OEV2_VE_ADDR                             ((0x1436  << 2) + 0xff900000)
#define L_OEV3_HS_ADDR                             ((0x1437  << 2) + 0xff900000)
#define L_OEV3_HE_ADDR                             ((0x1438  << 2) + 0xff900000)
#define L_OEV3_VS_ADDR                             ((0x1439  << 2) + 0xff900000)
#define L_OEV3_VE_ADDR                             ((0x143a  << 2) + 0xff900000)
#define L_LCD_PWR_ADDR                             ((0x143b  << 2) + 0xff900000)
#define L_LCD_PWM0_LO_ADDR                         ((0x143c  << 2) + 0xff900000)
#define L_LCD_PWM0_HI_ADDR                         ((0x143d  << 2) + 0xff900000)
#define L_LCD_PWM1_LO_ADDR                         ((0x143e  << 2) + 0xff900000)
#define L_LCD_PWM1_HI_ADDR                         ((0x143f  << 2) + 0xff900000)
#define L_INV_CNT_ADDR                             ((0x1440  << 2) + 0xff900000)
#define L_TCON_MISC_SEL_ADDR                       ((0x1441  << 2) + 0xff900000)
#define L_DUAL_PORT_CNTL_ADDR                      ((0x1442  << 2) + 0xff900000)
#define MLVDS_CLK_CTL1_HI                          ((0x1443  << 2) + 0xff900000)
#define MLVDS_CLK_CTL1_LO                          ((0x1444  << 2) + 0xff900000)
//  [31:30] enable mlvds clocks
//  [24]    mlvds_clk_half_delay       24 // Bit 0
//  [23:0]  mlvds_clk_pattern           0 // Bit 23:0
#define L_TCON_DOUBLE_CTL                          ((0x1449  << 2) + 0xff900000)
#define L_TCON_PATTERN_HI                          ((0x144a  << 2) + 0xff900000)
#define L_TCON_PATTERN_LO                          ((0x144b  << 2) + 0xff900000)
#define LDIM_BL_ADDR_PORT                          ((0x144e  << 2) + 0xff900000)
#define LDIM_BL_DATA_PORT                          ((0x144f  << 2) + 0xff900000)
#define L_DE_HS_ADDR                               ((0x1451  << 2) + 0xff900000)
#define L_DE_HE_ADDR                               ((0x1452  << 2) + 0xff900000)
#define L_DE_VS_ADDR                               ((0x1453  << 2) + 0xff900000)
#define L_DE_VE_ADDR                               ((0x1454  << 2) + 0xff900000)
#define L_HSYNC_HS_ADDR                            ((0x1455  << 2) + 0xff900000)
#define L_HSYNC_HE_ADDR                            ((0x1456  << 2) + 0xff900000)
#define L_HSYNC_VS_ADDR                            ((0x1457  << 2) + 0xff900000)
#define L_HSYNC_VE_ADDR                            ((0x1458  << 2) + 0xff900000)
#define L_VSYNC_HS_ADDR                            ((0x1459  << 2) + 0xff900000)
#define L_VSYNC_HE_ADDR                            ((0x145a  << 2) + 0xff900000)
#define L_VSYNC_VS_ADDR                            ((0x145b  << 2) + 0xff900000)
#define L_VSYNC_VE_ADDR                            ((0x145c  << 2) + 0xff900000)
// bit 8 -- vfifo_mcu_enable
// bit 7 -- halt_vs_de
// bit 6 -- R8G8B8_format
// bit 5 -- R6G6B6_format (round to 6 bits)
// bit 4 -- R5G6B5_format
// bit 3 -- dac_dith_sel
// bit 2 -- lcd_mcu_enable_de     -- ReadOnly
// bit 1 -- lcd_mcu_enable_vsync  -- ReadOnly
// bit 0 -- lcd_mcu_enable
#define L_LCD_MCU_CTL                              ((0x145d  << 2) + 0xff900000)
//**************************************************************************
//*  Dual port mLVDS registers
//**************************************************************************
// bit 3 - enable_u_dual_mlvds_dp_clk
// bit 2 - enable_u_map_mlvds_r_clk
// bit 1 - enable_u_map_mlvds_l_clk
// bit 0 - dual_mlvds_en
//`define DUAL_MLVDS_CTL                8'h60
// bit[12:0] - dual_mlvds_line_start
//`define DUAL_MLVDS_LINE_START         8'h61
// bit[12:0] - dual_mlvds_line_end
//`define DUAL_MLVDS_LINE_END           8'h62
// bit[12:0] - dual_mlvds_w_pixel_start_l
//`define DUAL_MLVDS_PIXEL_W_START_L    8'h63
// bit[12:0] - dual_mlvds_w_pixel_end_l
//`define DUAL_MLVDS_PIXEL_W_END_L      8'h64
// bit[12:0] - dual_mlvds_w_pixel_start_r
//`define DUAL_MLVDS_PIXEL_W_START_R    8'h65
// bit[12:0] - dual_mlvds_w_pixel_end_r
//`define DUAL_MLVDS_PIXEL_W_END_R      8'h66
// bit[12:0] - dual_mlvds_r_pixel_start_l
//`define DUAL_MLVDS_PIXEL_R_START_L    8'h67
// bit[12:0] - dual_mlvds_r_pixel_cnt_l
//`define DUAL_MLVDS_PIXEL_R_CNT_L      8'h68
// bit[12:0] - dual_mlvds_r_pixel_start_r
//`define DUAL_MLVDS_PIXEL_R_START_R    8'h69
// bit[12:0] - dual_mlvds_r_pixel_cnt_r
//`define DUAL_MLVDS_PIXEL_R_CNT_R      8'h6a
// bit[15]   - v_inversion_en
// bit[12:0] - v_inversion_pixel
//`define V_INVERSION_PIXEL             8'h70
// bit[15]   - v_inversion_sync_en
// bit[12:0] - v_inversion_line
//`define V_INVERSION_LINE              8'h71
// bit[15:12]  - v_loop_r
// bit[11:10]  - v_pattern_1_r
// bit[9:8]    - v_pattern_0_r
// bit[7:4]    - v_loop_l
// bit[3:2]    - v_pattern_1_l
// bit[1:0]    - v_pattern_0_l
//`define V_INVERSION_CONTROL           8'h72
//`define MLVDS2_CONTROL           8'h74
   #define     mLVDS2_RESERVED  15    // 15
   #define     mLVDS2_double_pattern  14    // 14
   #define     mLVDS2_ins_reset  8    // 13:8  // each channel has one bit
   #define     mLVDS2_dual_gate  7
   #define     mLVDS2_bit_num    6    // 0-6Bits, 1-8Bits
   #define     mLVDS2_pair_num   5    // 0-3Pairs, 1-6Pairs
   #define     mLVDS2_msb_first  4
   #define     mLVDS2_PORT_SWAP  3
   #define     mLVDS2_MLSB_SWAP  2
   #define     mLVDS2_PN_SWAP    1
   #define     mLVDS2_en         0
//`define MLVDS2_CONFIG_HI         8'h75
//`define MLVDS2_CONFIG_LO         8'h76
   #define     mLVDS2_reset_offset         29 // Bit 31:29
   #define     mLVDS2_reset_length         23 // Bit 28:23
   #define     mLVDS2_config_reserved      20 // Bit 22:20
   #define     mLVDS2_reset_start_bit12    19 // Bit 19
   #define     mLVDS2_data_write_toggle    18
   #define     mLVDS2_data_write_ini       17
   #define     mLVDS2_data_latch_1_toggle  16
   #define     mLVDS2_data_latch_1_ini     15
   #define     mLVDS2_data_latch_0_toggle  14
   #define     mLVDS2_data_latch_0_ini     13
   #define     mLVDS2_reset_1_select       12 // 0 - same as reset_0, 1 - 1 clock delay of reset_0
   #define     mLVDS2_reset_start           0 // Bit 11:0
//`define MLVDS2_DUAL_GATE_WR_START        8'h77
//   `define     mlvds2_dual_gate_wr_start    0 // Bit 12:0
//`define MLVDS2_DUAL_GATE_WR_END          8'h78
//   `define     mlvds2_dual_gate_wr_end      0 // Bit 12:0
//
//`define MLVDS2_DUAL_GATE_RD_START        8'h79
//   `define     mlvds2_dual_gate_rd_start    0 // Bit 12:0
//`define MLVDS2_DUAL_GATE_RD_END          8'h7a
//   `define     mlvds2_dual_gate_rd_end      0 // Bit 12:0
//`define MLVDS2_SECOND_RESET_CTL          8'h7b
//   `define     mLVDS2_2nd_reset_start       0 // Bit 12:0
//
//`define MLVDS2_DUAL_GATE_CTL_HI        8'h7c
//`define MLVDS2_DUAL_GATE_CTL_LO        8'h7d
//   `define     mlvds2_tcon_field_en        24 // Bit 7:0
//   `define     mlvds2_dual_gate_reserved   21 // Bit 2:0
//   `define     mlvds2_scan_mode_start_line_bit12 20 // Bit 0
//   `define     mlvds2_scan_mode_odd        16 // Bit 3:0
//   `define     mlvds2_scan_mode_even       12 // Bit 3:0
//   `define     mlvds2_scan_mode_start_line  0 // Bit 11:0
//
//`define MLVDS2_RESET_CONFIG_HI         8'h7e
//`define MLVDS2_RESET_CONFIG_LO         8'h7f
//   `define     mLVDS2_reset_range_enable   31 // Bit 0
//   `define     mLVDS2_reset_range_inv      30 // Bit 0
//   `define     mLVDS2_reset_config_res1    29 // Bit 0
//   `define     mLVDS2_reset_range_line_0   16 // Bit 11:0
//   `define     mLVDS2_reset_config_res3    13 // Bit 2:0
//   `define     mLVDS2_reset_range_line_1    0 // Bit 11:0
//
//**************************************************************************
//*  Vbyone registers  (Note: no MinLVDS in G9tv, share the register)
//**************************************************************************
#define VBO_CTRL_L                                 ((0x1460  << 2) + 0xff900000)
#define VBO_CTRL_H                                 ((0x1461  << 2) + 0xff900000)
#define VBO_SOFT_RST                               ((0x1462  << 2) + 0xff900000)
#define VBO_LANES                                  ((0x1463  << 2) + 0xff900000)
#define VBO_VIN_CTRL                               ((0x1464  << 2) + 0xff900000)
#define VBO_ACT_VSIZE                              ((0x1465  << 2) + 0xff900000)
#define VBO_REGION_00                              ((0x1466  << 2) + 0xff900000)
#define VBO_REGION_01                              ((0x1467  << 2) + 0xff900000)
#define VBO_REGION_02                              ((0x1468  << 2) + 0xff900000)
#define VBO_REGION_03                              ((0x1469  << 2) + 0xff900000)
#define VBO_VBK_CTRL_0                             ((0x146a  << 2) + 0xff900000)
#define VBO_VBK_CTRL_1                             ((0x146b  << 2) + 0xff900000)
#define VBO_HBK_CTRL                               ((0x146c  << 2) + 0xff900000)
#define VBO_PXL_CTRL                               ((0x146d  << 2) + 0xff900000)
#define VBO_LANE_SKEW_L                            ((0x146e  << 2) + 0xff900000)
#define VBO_LANE_SKEW_H                            ((0x146f  << 2) + 0xff900000)
#define VBO_GCLK_LANE_L                            ((0x1470  << 2) + 0xff900000)
#define VBO_GCLK_LANE_H                            ((0x1471  << 2) + 0xff900000)
#define VBO_GCLK_MAIN                              ((0x1472  << 2) + 0xff900000)
#define VBO_STATUS_L                               ((0x1473  << 2) + 0xff900000)
#define VBO_STATUS_H                               ((0x1474  << 2) + 0xff900000)
#define VBO_LANE_OUTPUT                            ((0x1475  << 2) + 0xff900000)
#define LCD_PORT_SWAP                              ((0x1476  << 2) + 0xff900000)
#define VBO_TMCHK_THRD_L                           ((0x1478  << 2) + 0xff900000)
#define VBO_TMCHK_THRD_H                           ((0x1479  << 2) + 0xff900000)
#define VBO_FSM_HOLDER_L                           ((0x147a  << 2) + 0xff900000)
#define VBO_FSM_HOLDER_H                           ((0x147b  << 2) + 0xff900000)
#define VBO_INTR_STATE_CTRL                        ((0x147c  << 2) + 0xff900000)
#define VBO_INTR_UNMASK                            ((0x147d  << 2) + 0xff900000)
#define VBO_TMCHK_HSYNC_STATE_L                    ((0x147e  << 2) + 0xff900000)
#define VBO_TMCHK_HSYNC_STATE_H                    ((0x147f  << 2) + 0xff900000)
#define VBO_TMCHK_VSYNC_STATE_L                    ((0x14f4  << 2) + 0xff900000)
#define VBO_TMCHK_VSYNC_STATE_H                    ((0x14f5  << 2) + 0xff900000)
#define VBO_TMCHK_VDE_STATE_L                      ((0x14f6  << 2) + 0xff900000)
#define VBO_TMCHK_VDE_STATE_H                      ((0x14f7  << 2) + 0xff900000)
#define VBO_INTR_STATE                             ((0x14f8  << 2) + 0xff900000)
#define VBO_INFILTER_CTRL                          ((0x14f9  << 2) + 0xff900000)
#define VBO_INSGN_CTRL                             ((0x14fa  << 2) + 0xff900000)
//**************************************************************************
//*  NOTE::    When Programming the Gamma, please turn off the IRQ service *
//**************************************************************************
#define GAMMA_CNTL_PORT                            ((0x1480  << 2) + 0xff900000)
   #define  GAMMA_VCOM_POL    7     //RW
   #define  GAMMA_RVS_OUT     6     //RW
   #define  ADR_RDY           5     //Read Only
   #define  WR_RDY            4     //Read Only
   #define  RD_RDY            3     //Read Only
   #define  GAMMA_TR          2     //RW
   #define  GAMMA_SET         1     //RW
   #define  GAMMA_EN          0     //RW
#define GAMMA_DATA_PORT                            ((0x1481  << 2) + 0xff900000)
#define GAMMA_ADDR_PORT                            ((0x1482  << 2) + 0xff900000)
   #define  H_RD              12
   #define  H_AUTO_INC        11
   #define  H_SEL_R           10
   #define  H_SEL_G           9
   #define  H_SEL_B           8
   #define  HADR_MSB          7            //7:0
   #define  HADR              0            //7:0
#define GAMMA_VCOM_HSWITCH_ADDR                    ((0x1483  << 2) + 0xff900000)
#define RGB_BASE_ADDR                              ((0x1485  << 2) + 0xff900000)
#define RGB_COEFF_ADDR                             ((0x1486  << 2) + 0xff900000)
#define POL_CNTL_ADDR                              ((0x1487  << 2) + 0xff900000)
   #define   DCLK_SEL             14    //FOR DCLK OUTPUT
   #define   TCON_VSYNC_SEL_DVI   11    //FOR RGB format DVI output
   #define   TCON_HSYNC_SEL_DVI   10    //FOR RGB format DVI output
   #define   TCON_DE_SEL_DVI      9     //FOR RGB format DVI output
   #define   CPH3_POL         8
   #define   CPH2_POL         7
   #define   CPH1_POL         6
   #define   TCON_DE_SEL      5
   #define   TCON_VS_SEL      4
   #define   TCON_HS_SEL      3
   #define   DE_POL           2
   #define   VS_POL           1
   #define   HS_POL           0
#define DITH_CNTL_ADDR                             ((0x1488  << 2) + 0xff900000)
   #define  DITH10_EN         10
   #define  DITH8_EN          9
   #define  DITH_MD           8
   #define  DITH10_CNTL_MSB   7          //7:4
   #define  DITH10_CNTL       4          //7:4
   #define  DITH8_CNTL_MSB    3          //3:0
   #define  DITH8_CNTL        0          //3:0
//Bit 1 highlight_en
//Bit 0 probe_en
#define GAMMA_PROBE_CTRL                           ((0x1489  << 2) + 0xff900000)
//read only
//Bit [15:0]  probe_color[15:0]
#define GAMMA_PROBE_COLOR_L                        ((0x148a  << 2) + 0xff900000)
//Read only
//Bit 15: if true valid probed color
//Bit [13:0]  probe_color[29:16]
#define GAMMA_PROBE_COLOR_H                        ((0x148b  << 2) + 0xff900000)
//bit 15:0, 5:6:5 color
#define GAMMA_PROBE_HL_COLOR                       ((0x148c  << 2) + 0xff900000)
//12:0 pos_x
#define GAMMA_PROBE_POS_X                          ((0x148d  << 2) + 0xff900000)
//12:0 pos_y
#define GAMMA_PROBE_POS_Y                          ((0x148e  << 2) + 0xff900000)
#define STH1_HS_ADDR                               ((0x1490  << 2) + 0xff900000)
#define STH1_HE_ADDR                               ((0x1491  << 2) + 0xff900000)
#define STH1_VS_ADDR                               ((0x1492  << 2) + 0xff900000)
#define STH1_VE_ADDR                               ((0x1493  << 2) + 0xff900000)
#define STH2_HS_ADDR                               ((0x1494  << 2) + 0xff900000)
#define STH2_HE_ADDR                               ((0x1495  << 2) + 0xff900000)
#define STH2_VS_ADDR                               ((0x1496  << 2) + 0xff900000)
#define STH2_VE_ADDR                               ((0x1497  << 2) + 0xff900000)
#define OEH_HS_ADDR                                ((0x1498  << 2) + 0xff900000)
#define OEH_HE_ADDR                                ((0x1499  << 2) + 0xff900000)
#define OEH_VS_ADDR                                ((0x149a  << 2) + 0xff900000)
#define OEH_VE_ADDR                                ((0x149b  << 2) + 0xff900000)
#define VCOM_HSWITCH_ADDR                          ((0x149c  << 2) + 0xff900000)
#define VCOM_VS_ADDR                               ((0x149d  << 2) + 0xff900000)
#define VCOM_VE_ADDR                               ((0x149e  << 2) + 0xff900000)
#define CPV1_HS_ADDR                               ((0x149f  << 2) + 0xff900000)
#define CPV1_HE_ADDR                               ((0x14a0  << 2) + 0xff900000)
#define CPV1_VS_ADDR                               ((0x14a1  << 2) + 0xff900000)
#define CPV1_VE_ADDR                               ((0x14a2  << 2) + 0xff900000)
#define CPV2_HS_ADDR                               ((0x14a3  << 2) + 0xff900000)
#define CPV2_HE_ADDR                               ((0x14a4  << 2) + 0xff900000)
#define CPV2_VS_ADDR                               ((0x14a5  << 2) + 0xff900000)
#define CPV2_VE_ADDR                               ((0x14a6  << 2) + 0xff900000)
#define STV1_HS_ADDR                               ((0x14a7  << 2) + 0xff900000)
#define STV1_HE_ADDR                               ((0x14a8  << 2) + 0xff900000)
#define STV1_VS_ADDR                               ((0x14a9  << 2) + 0xff900000)
#define STV1_VE_ADDR                               ((0x14aa  << 2) + 0xff900000)
#define STV2_HS_ADDR                               ((0x14ab  << 2) + 0xff900000)
#define STV2_HE_ADDR                               ((0x14ac  << 2) + 0xff900000)
#define STV2_VS_ADDR                               ((0x14ad  << 2) + 0xff900000)
#define STV2_VE_ADDR                               ((0x14ae  << 2) + 0xff900000)
#define OEV1_HS_ADDR                               ((0x14af  << 2) + 0xff900000)
#define OEV1_HE_ADDR                               ((0x14b0  << 2) + 0xff900000)
#define OEV1_VS_ADDR                               ((0x14b1  << 2) + 0xff900000)
#define OEV1_VE_ADDR                               ((0x14b2  << 2) + 0xff900000)
#define OEV2_HS_ADDR                               ((0x14b3  << 2) + 0xff900000)
#define OEV2_HE_ADDR                               ((0x14b4  << 2) + 0xff900000)
#define OEV2_VS_ADDR                               ((0x14b5  << 2) + 0xff900000)
#define OEV2_VE_ADDR                               ((0x14b6  << 2) + 0xff900000)
#define OEV3_HS_ADDR                               ((0x14b7  << 2) + 0xff900000)
#define OEV3_HE_ADDR                               ((0x14b8  << 2) + 0xff900000)
#define OEV3_VS_ADDR                               ((0x14b9  << 2) + 0xff900000)
#define OEV3_VE_ADDR                               ((0x14ba  << 2) + 0xff900000)
#define LCD_PWR_ADDR                               ((0x14bb  << 2) + 0xff900000)
   #define      LCD_VDD        5
   #define      LCD_VBL        4
   #define      LCD_GPI_MSB    3
   #define      LCD_GPIO       0
#define LCD_PWM0_LO_ADDR                           ((0x14bc  << 2) + 0xff900000)
#define LCD_PWM0_HI_ADDR                           ((0x14bd  << 2) + 0xff900000)
#define LCD_PWM1_LO_ADDR                           ((0x14be  << 2) + 0xff900000)
#define LCD_PWM1_HI_ADDR                           ((0x14bf  << 2) + 0xff900000)
#define INV_CNT_ADDR                               ((0x14c0  << 2) + 0xff900000)
   #define     INV_EN          4
   #define     INV_CNT_MSB     3
   #define     INV_CNT         0
#define TCON_MISC_SEL_ADDR                         ((0x14c1  << 2) + 0xff900000)
   #define     STH2_SEL        12
   #define     STH1_SEL        11
   #define     OEH_SEL         10
   #define     VCOM_SEL         9
   #define     DB_LINE_SW       8
   #define     CPV2_SEL         7
   #define     CPV1_SEL         6
   #define     STV2_SEL         5
   #define     STV1_SEL         4
   #define     OEV_UNITE        3
   #define     OEV3_SEL         2
   #define     OEV2_SEL         1
   #define     OEV1_SEL         0
#define DUAL_PORT_CNTL_ADDR                        ((0x14c2  << 2) + 0xff900000)
   #define     OUTPUT_YUV       15
   #define     DUAL_IDF         12   // 14:12
   #define     DUAL_ISF         9    // 11:9
   #define     LCD_ANALOG_SEL_CPH3   8
   #define     LCD_ANALOG_3PHI_CLK_SEL   7
   #define     LCD_LVDS_SEL54   6
   #define     LCD_LVDS_SEL27   5
   #define     LCD_TTL_SEL      4
   #define     DUAL_LVDC_EN     3
   #define     PORT_SWP         2
   #define     RGB_SWP          1
   #define     BIT_SWP          0
#define MLVDS_CONTROL                              ((0x14c3  << 2) + 0xff900000)
   #define     mLVDS_RESERVED  15    // 15
   #define     mLVDS_double_pattern  14    // 14
   #define     mLVDS_ins_reset  8    // 13:8  // each channel has one bit
   #define     mLVDS_dual_gate  7
   #define     mLVDS_bit_num    6    // 0-6Bits, 1-8Bits
   #define     mLVDS_pair_num   5    // 0-3Pairs, 1-6Pairs
   #define     mLVDS_msb_first  4
   #define     mLVDS_PORT_SWAP  3
   #define     mLVDS_MLSB_SWAP  2
   #define     mLVDS_PN_SWAP    1
   #define     mLVDS_en         0
#define MLVDS_RESET_PATTERN_HI                     ((0x14c4  << 2) + 0xff900000)
#define MLVDS_RESET_PATTERN_LO                     ((0x14c5  << 2) + 0xff900000)
   #define     mLVDS_reset_pattern  0 // Bit 47:16
#define MLVDS_RESET_PATTERN_EXT                    ((0x14c6  << 2) + 0xff900000)
   #define     mLVDS_reset_pattern_ext  0 // Bit 15:0
#define MLVDS_CONFIG_HI                            ((0x14c7  << 2) + 0xff900000)
#define MLVDS_CONFIG_LO                            ((0x14c8  << 2) + 0xff900000)
   #define     mLVDS_reset_offset         29 // Bit 31:29
   #define     mLVDS_reset_length         23 // Bit 28:23
   #define     mLVDS_config_reserved      20 // Bit 22:20
   #define     mLVDS_reset_start_bit12    19 // Bit 19
   #define     mLVDS_data_write_toggle    18
   #define     mLVDS_data_write_ini       17
   #define     mLVDS_data_latch_1_toggle  16
   #define     mLVDS_data_latch_1_ini     15
   #define     mLVDS_data_latch_0_toggle  14
   #define     mLVDS_data_latch_0_ini     13
   #define     mLVDS_reset_1_select       12 // 0 - same as reset_0, 1 - 1 clock delay of reset_0
   #define     mLVDS_reset_start           0 // Bit 11:0
#define TCON_DOUBLE_CTL                            ((0x14c9  << 2) + 0xff900000)
   #define     tcon_double_ini          8 // Bit 7:0
   #define     tcon_double_inv          0 // Bit 7:0
#define TCON_PATTERN_HI                            ((0x14ca  << 2) + 0xff900000)
#define TCON_PATTERN_LO                            ((0x14cb  << 2) + 0xff900000)
   #define     tcon_pattern_loop_data     16 // Bit 15:0
   #define     tcon_pattern_loop_start    12 // Bit 3:0
   #define     tcon_pattern_loop_end       8 // Bit 3:0
   #define     tcon_pattern_enable         0 // Bit 7:0
#define TCON_CONTROL_HI                            ((0x14cc  << 2) + 0xff900000)
#define TCON_CONTROL_LO                            ((0x14cd  << 2) + 0xff900000)
   #define     tcon_pclk_enable           26 // Bit 5:0 (enable pclk on TCON channel 7 to 2)
   #define     tcon_pclk_div              24 // Bit 1:0 (control phy clok divide 2,4,6,8)
   #define     tcon_delay                  0 // Bit 23:0 (3 bit for each channel)
#define LVDS_BLANK_DATA_HI                         ((0x14ce  << 2) + 0xff900000)
#define LVDS_BLANK_DATA_LO                         ((0x14cf  << 2) + 0xff900000)
   #define     LVDS_blank_data_reserved 30  // 31:30
   #define     LVDS_blank_data_r        20  // 29:20
   #define     LVDS_blank_data_g        10  // 19:10
   #define     LVDS_blank_data_b         0  //  9:0
#define LVDS_PACK_CNTL_ADDR                        ((0x14d0  << 2) + 0xff900000)
   #define     LVDS_USE_TCON    7
   #define     LVDS_DUAL        6
   #define     PN_SWP           5
   #define     LSB_FIRST        4
   #define     LVDS_RESV        3
   #define     ODD_EVEN_SWP     2
   #define     LVDS_REPACK      0
// New from M3 :
// Bit 15:12 -- Enable OFFSET Double Generate(TOCN7-TCON4)
// Bit 11:0 -- de_hs(old tcon) second offset_hs (new tcon)
#define DE_HS_ADDR                                 ((0x14d1  << 2) + 0xff900000)
// New from M3 :
// Bit 15:12 -- Enable OFFSET Double Generate(TOCN3-TCON0)
#define DE_HE_ADDR                                 ((0x14d2  << 2) + 0xff900000)
#define DE_VS_ADDR                                 ((0x14d3  << 2) + 0xff900000)
#define DE_VE_ADDR                                 ((0x14d4  << 2) + 0xff900000)
#define HSYNC_HS_ADDR                              ((0x14d5  << 2) + 0xff900000)
#define HSYNC_HE_ADDR                              ((0x14d6  << 2) + 0xff900000)
#define HSYNC_VS_ADDR                              ((0x14d7  << 2) + 0xff900000)
#define HSYNC_VE_ADDR                              ((0x14d8  << 2) + 0xff900000)
#define VSYNC_HS_ADDR                              ((0x14d9  << 2) + 0xff900000)
#define VSYNC_HE_ADDR                              ((0x14da  << 2) + 0xff900000)
#define VSYNC_VS_ADDR                              ((0x14db  << 2) + 0xff900000)
#define VSYNC_VE_ADDR                              ((0x14dc  << 2) + 0xff900000)
// bit 8 -- vfifo_mcu_enable
// bit 7 -- halt_vs_de
// bit 6 -- R8G8B8_format
// bit 5 -- R6G6B6_format (round to 6 bits)
// bit 4 -- R5G6B5_format
// bit 3 -- dac_dith_sel
// bit 2 -- lcd_mcu_enable_de     -- ReadOnly
// bit 1 -- lcd_mcu_enable_vsync  -- ReadOnly
// bit 0 -- lcd_mcu_enable
#define LCD_MCU_CTL                                ((0x14dd  << 2) + 0xff900000)
// ReadOnly
//   R5G6B5 when R5G6B5_format
//   G8R8   when R8G8B8_format
//   G5R10  Other
#define LCD_MCU_DATA_0                             ((0x14de  << 2) + 0xff900000)
// ReadOnly
//   G8B8   when R8G8B8_format
//   G5B10  Other
#define LCD_MCU_DATA_1                             ((0x14df  << 2) + 0xff900000)
// LVDS
#define LVDS_GEN_CNTL                              ((0x14e0  << 2) + 0xff900000)
#define LVDS_PHY_CNTL0                             ((0x14e1  << 2) + 0xff900000)
#define LVDS_PHY_CNTL1                             ((0x14e2  << 2) + 0xff900000)
#define LVDS_PHY_CNTL2                             ((0x14e3  << 2) + 0xff900000)
#define LVDS_PHY_CNTL3                             ((0x14e4  << 2) + 0xff900000)
#define LVDS_PHY_CNTL4                             ((0x14e5  << 2) + 0xff900000)
#define LVDS_PHY_CNTL5                             ((0x14e6  << 2) + 0xff900000)
#define LVDS_SRG_TEST                              ((0x14e8  << 2) + 0xff900000)
#define LVDS_BIST_MUX0                             ((0x14e9  << 2) + 0xff900000)
#define LVDS_BIST_MUX1                             ((0x14ea  << 2) + 0xff900000)
#define LVDS_BIST_FIXED0                           ((0x14eb  << 2) + 0xff900000)
#define LVDS_BIST_FIXED1                           ((0x14ec  << 2) + 0xff900000)
#define LVDS_BIST_CNTL0                            ((0x14ed  << 2) + 0xff900000)
#define LVDS_CLKB_CLKA                             ((0x14ee  << 2) + 0xff900000)
#define LVDS_PHY_CLK_CNTL                          ((0x14ef  << 2) + 0xff900000)
#define LVDS_SER_EN                                ((0x14f0  << 2) + 0xff900000)
#define LVDS_PHY_CNTL6                             ((0x14f1  << 2) + 0xff900000)
#define LVDS_PHY_CNTL7                             ((0x14f2  << 2) + 0xff900000)
#define LVDS_PHY_CNTL8                             ((0x14f3  << 2) + 0xff900000)
//`define MLVDS_CLK_CTL0_HI        8'hf4
//`define MLVDS_CLK_CTL0_LO        8'hf5
//   `define     mlvds_clk_pattern_reserved 31 // Bit 31
//   `define     mpclk_dly                  28 // Bit 2:0
//   `define     mpclk_div                  26 // Bit 1:0 (control phy clok divide 2,4,6,8)
//   `define     use_mpclk                  25 // Bit 0
//   `define     mlvds_clk_half_delay       24 // Bit 0
//   `define     mlvds_clk_pattern           0 // Bit 23:0
//`define MLVDS_DUAL_GATE_WR_START        8'hf6
//   `define     mlvds_dual_gate_wr_start    0 // Bit 12:0
//`define MLVDS_DUAL_GATE_WR_END          8'hf7
//   `define     mlvds_dual_gate_wr_end      0 // Bit 12:0
//
//`define MLVDS_DUAL_GATE_RD_START        8'hf8
//   `define     mlvds_dual_gate_rd_start    0 // Bit 12:0
//`define MLVDS_DUAL_GATE_RD_END          8'hf9
//   `define     mlvds_dual_gate_rd_end      0 // Bit 12:0
//`define MLVDS_SECOND_RESET_CTL          8'hfa
//   `define     mLVDS_2nd_reset_start       0 // Bit 12:0
//
#define MLVDS_DUAL_GATE_CTL_HI                     ((0x14fb  << 2) + 0xff900000)
#define MLVDS_DUAL_GATE_CTL_LO                     ((0x14fc  << 2) + 0xff900000)
//   `define     mlvds_tcon_field_en        24 // Bit 7:0
//   `define     mlvds_dual_gate_reserved   21 // Bit 2:0
//   `define     mlvds_scan_mode_start_line_bit12 20 // Bit 0
//   `define     mlvds_scan_mode_odd        16 // Bit 3:0
//   `define     mlvds_scan_mode_even       12 // Bit 3:0
//   `define     mlvds_scan_mode_start_line  0 // Bit 11:0
//
//`define MLVDS_RESET_CONFIG_HI         8'hfd
//`define MLVDS_RESET_CONFIG_LO         8'hfe
//   `define     mLVDS_reset_range_enable   31 // Bit 0
//   `define     mLVDS_reset_range_inv      30 // Bit 0
//   `define     mLVDS_reset_config_res1    29 // Bit 0
//   `define     mLVDS_reset_range_line_0   16 // Bit 11:0
//   `define     mLVDS_reset_config_res3    13 // Bit 2:0
//   `define     mLVDS_reset_range_line_1    0 // Bit 11:0
//===============================================================
//LCD DRIVER BASE   END
//===============================================================
//
// Closing file:  lcd_regs.h
//
//`define MAD_VCBUS_BASE               8'h17
//
// Reading file:  mad_regs.h
//
//DEINTERLACE module start from 8'h90 end to 8'hff
// -----------------------------------------------
// CBUS_BASE:  MAD_VCBUS_BASE = 0x17
// -----------------------------------------------
#define DI_PRE_CTRL                                ((0x1700  << 2) + 0xff900000)
// bit 31,      cbus_pre_frame_rst
// bit 30,      cbus_pre_soft_rst
// bit 29,      pre_field_num
// bit 27:26,   mode_444c422
// bit 25,      di_cont_read_en
// bit 24:23,   mode_422c444
// bit 22,      mtn_after_nr
// bit 21:16,   pre_hold_fifo_lines
// bit 15,      nr_wr_by
// bit 14,      use_vdin_go_line
// bit 13,      di_prevdin_en
// bit 12,      di_pre_viu_link
// bit 11,      di_pre_repeat
// bit 10,      di_pre_drop_1st
// bit  9,      di_buf2_en
// bit  8,      di_chan2_en
// bit  7,      prenr_hist_en
// bit  6,      chan2_hist_en
// bit  5,      hist_check_en
// bit  4,      check_after_nr
// bit  3,      check222p_en
// bit  2,      check322p_en
// bit  1,      mtn_en
// bit  0,      nr_en
#define DI_POST_CTRL                               ((0x1701  << 2) + 0xff900000)
// bit 31,      cbus_post_frame_rst
// bit 30,      cbus_post_soft_rst
// bit 29,      post_field_num
// bit 21:16,   post_hold_fifo_lines
// bit 13,      prepost_link
// bit 12,      di_post_viu_link
// bit 11,      di_post_repeat
// bit 10,      di_post_drop_1st
// bit  9,      mif0_to_vpp_en
// bit  8,      di_vpp_out_en
// bit  7,      di_wr_bk_en
// bit  6,      di_mux_en
// bit  5,      di_blend_en
// bit  4,      di_mtnp_read_en
// bit  3,      di_mtn_buf_en
// bit  2,      di_ei_en
// bit  1,      di_buf1_en
// bit  0,      di_buf0_en
#define DI_POST_SIZE                               ((0x1702  << 2) + 0xff900000)
//bit 28:16,    vsize1post
//bit 12:0,     hsize1post
#define DI_PRE_SIZE                                ((0x1703  << 2) + 0xff900000)
//bit 28:16,    vsize1pre
//bit 12:0,     hsize1pre
#define DI_EI_CTRL0                                ((0x1704  << 2) + 0xff900000)
//bit 23:16,    ei0_filter[2:+]  abs_diff_left>filter && ...right>filter && ...top>filter && ...bot>filter -> filter
//bit 15:8,     ei0_threshold[2:+]
//bit 3,        ei0_vertical
//bit 2,        ei0_bpscf2
//bit 1,        ei0_bpsfar1
#define DI_EI_CTRL1                                ((0x1705  << 2) + 0xff900000)
//bit 31:24,    ei0_diff
//bit 23:16,    ei0_angle45
//bit 15:8,     ei0_peak
//bit 7:0,      ei0_cross
#define DI_EI_CTRL2                                ((0x1706  << 2) + 0xff900000)
//bit 31:24,    ei0_close2
//bit 23:16,    ei0_close1
//bit 15:8,     ei0_far2
//bit 7:0,      ei0_far1
#define DI_NR_CTRL0                                ((0x1707  << 2) + 0xff900000)
//bit 26,       nr_cue_en
//bit 25,       nr2_en
#define DI_NR_CTRL1                                ((0x1708  << 2) + 0xff900000)
//bit 31:30,    mot_p1txtcore_mode
//bit 29:24,    mot_p1txtcore_clmt
//bit 21:16,    mot_p1txtcore_ylmt
//bit 15:8,     mot_p1txtcore_crate
//bit 7:0,      mot_p1txtcore_yrate
#define DI_NR_CTRL2                                ((0x1709  << 2) + 0xff900000)
//bit 29:24,    mot_curtxtcore_clmt
//bit 21:16,    mot_curtxtcore_ylmt
//bit 15:8,     mot_curtxtcore_crate
//bit 7:0,      mot_curtxtcore_yrate
//`define DI_NR_CTRL3               8'h0a
//no use
//`define DI_MTN_CTRL               8'h0b
//no use
#define DI_CANVAS_URGENT0                          ((0x170a  << 2) + 0xff900000)
#define DI_CANVAS_URGENT1                          ((0x170b  << 2) + 0xff900000)
#define DI_MTN_CTRL1                               ((0x170c  << 2) + 0xff900000)
//bit 13 ,      me enable
//bit 12 ,      me autoenable
//bit 11:8,		mtn_paramtnthd
//bit 7:0,      mtn_parafltthd
#define DI_BLEND_CTRL                              ((0x170d  << 2) + 0xff900000)
//bit 31,      blend_1_en
//bit 30,      blend_mtn_lpf
//bit 28,      post_mb_en
//bit 27,      blend_mtn3p_max
//bit 26,      blend_mtn3p_min
//bit 25,      blend_mtn3p_ave
//bit 24,      blend_mtn3p_maxtb
//bit 23,      blend_mtn_flt_en
//bit 22,      blend_data_flt_en
//bit 21:20,   blend_top_mode
//bit 19,      blend_reg3_enable
//bit 18,      blend_reg2_enable
//bit 17,      blend_reg1_enable
//bit 16,      blend_reg0_enable
//bit 15:14,   blend_reg3_mode
//bit 13:12,   blend_reg2_mode
//bit 11:10,   blend_reg1_mode
//bit 9:8,     blend_reg0_mode
//bit 7:0,     kdeint
//`define DI_BLEND_CTRL1            8'h0e
//no use
#define DI_CANVAS_URGENT2                          ((0x170e  << 2) + 0xff900000)
//`define DI_BLEND_CTRL2            8'h0f
//no use
#define DI_ARB_CTRL                                ((0x170f  << 2) + 0xff900000)
//bit 31:26,			di_arb_thd1
//bit 25:20,			di_arb_thd0
//bit 19,			di_arb_tid_mode
//bit 18,			di_arb_arb_mode
//bit 17,			di_arb_acq_en
//bit 16,			di_arb_disable_clk
//bit 15:0,			di_arb_req_en
#define DI_BLEND_REG0_X                            ((0x1710  << 2) + 0xff900000)
//bit 27:16,   blend_reg0_startx
//bit 11:0,    blend_reg0_endx
#define DI_BLEND_REG0_Y                            ((0x1711  << 2) + 0xff900000)
#define DI_BLEND_REG1_X                            ((0x1712  << 2) + 0xff900000)
#define DI_BLEND_REG1_Y                            ((0x1713  << 2) + 0xff900000)
#define DI_BLEND_REG2_X                            ((0x1714  << 2) + 0xff900000)
#define DI_BLEND_REG2_Y                            ((0x1715  << 2) + 0xff900000)
#define DI_BLEND_REG3_X                            ((0x1716  << 2) + 0xff900000)
#define DI_BLEND_REG3_Y                            ((0x1717  << 2) + 0xff900000)
#define DI_CLKG_CTRL                               ((0x1718  << 2) + 0xff900000)
//bit 31:24,   pre_gclk_ctrl     no clk gate control. if ==1, module clk is not gated (always on). [3] for pulldown,[2] for mtn_1,[1] for mtn_0,[0] for nr
//bit 23:16,   post_gclk_ctrl    no clk gate control. [4] for ei_1, [3] for ei_0,[2] for ei_top, [1] for blend_1, [0] for blend_0
//bit 1,       di_gate_all       clk shut down. if ==1 , all di clock shut down
//bit 0,       di_no_clk_gate    no clk gate control.     if di_gated_all==0 and di_no_clk_gate ==1, all di clock is always working.
#define DI_EI_CTRL3                                ((0x1719  << 2) + 0xff900000)
//bit 31,      reg_ei_1
//bit 30,      reg_demon_en
//bit 26:24,   reg_demon_mux
//bit 23:20,   reg_right_win
//bit 19:16,   reg_left_win
//bit 7:4,     reg_ei_sadm_quatize_margin
//bit 1:0,     reg_ei_sad_relative_mode
#define DI_EI_CTRL4                                ((0x171a  << 2) + 0xff900000)
//bit 29,      reg_ei_caldrt_ambliike2_biasvertical
//bit 28:24,   reg_ei_caldrt_addxla2list_drtmax
//bit 22:20,   reg_ei_caldrt_addxla2list_signm0th
//bit 19,      reg_ei_caldrt_addxla2list_mode
//bit 18:16,   reg_ei_signm_sad_cor_rate
//bit 15:12,   reg_ei_signm_sadi_cor_rate
//bit 11:6,    reg_ei_signm_sadi_cor_ofst
//bit 5:0,     reg_ei_signm_sad_ofst
#define DI_EI_CTRL5                                ((0x171b  << 2) + 0xff900000)
//bit 30:28,   reg_ei_caldrt_cnflcctchk_frcverthrd
//bit 26:24,   reg_ei_caldrt_cnflctchk_mg
//bit 23:22,   reg_ei_caldrt_cnflctchk_ws
//bit 21,      reg_ei_caldrt_cnflctchk_en
//bit 20,      reg_ei_caldrt_verfrc_final_en
//bit 19,      reg_ei_caldrt_verfrc_retimflt_en
//bit 18:16,   reg_ei_caldrt_verftc_eithratemth
//bit 15,      reg_ei_caldrt_verfrc_retiming_en
//bit 14:12,   reg_ei_caldrt_verfrc_bothratemth
//bit 11:9,    reg_ei_caldrt_ver_thrd
//bit 8:4,     reg_ei_caldrt_addxla2list_drtmin
//bit 3:0,     reg_ei_caldrt_addxla2list_drtlimit
#define DI_EI_CTRL6                                ((0x171c  << 2) + 0xff900000)
//bit 31:24,   reg_ei_caldrt_abext_sad12thhig
//bit 23:16,   reg_ei_caldrt_abext_sad00thlow
//bit 15:8,    reg_ei_caldrt_abext_sad12thlow
//bit 6:4,     reg_ei_caldrt_abext_ratemth
//bit 2:0,     reg_ei_caldrt_abext_drtthrd
#define DI_EI_CTRL7                                ((0x171d  << 2) + 0xff900000)
//bit 29,      reg_ei_caldrt_xlanopeak_codien
//bit 28:24,   reg_ei_caldrt_xlanopeak_drtmax
//bit 23,      reg_ei_caldrt_xlanopeak_en
//bit 28:24,   reg_ei_caldrt_abext_monotrnd_alpha
//bit 28:24,   reg_ei_caldrt_abext_mononum12_thrd
//bit 28:24,   reg_ei_caldrt_abext_mononum00_thrd
//bit 28:24,   reg_ei_caldrt_abext_sad00rate
//bit 28:24,   reg_ei_caldrt_abext_sad12rate
//bit 28:24,   reg_ei_caldrt_abext_sad00thhig
#define DI_EI_CTRL8                                ((0x171e  << 2) + 0xff900000)
//bit 30:28,   reg_ei_assign_headtail_magin
//bit 26:24,   reg_ei_retime_lastcurpncnfltchk_mode
//bit 22:21,   reg_ei_retime_lastcurpncnfltchk_drtth
//bit 20,      reg_ei_caldrt_histchk_cnfid
//bit 19:16,   reg_ei_caldrt_histchk_thrd
//bit 15,      reg_ei_caldrt_histchk_abext
//bit 14,      reg_ei_caldrt_histchk_npen
//bit 13:11,   reg_ei_caldrt_amblike2_drtmg
//bit 10:8,    reg_ei_caldrt_amblike2_valmg
//bit 7:4,     reg_ei_caldrt_amblike2_alpha
//bit 3:0,     reg_ei_caldrt_amblike2_drtth
#define DI_EI_CTRL9                                ((0x171f  << 2) + 0xff900000)
//bit 31:28,   reg_ei_caldrt_hcnfcheck_frcvert_xla_th3
//bit 27,      reg_ei_caldrt_hcnfcheck_frcvert_xla_en
//bit 26:24,   reg_ei_caldrt_conf_drtth
//bit 23:20,   reg_ei_caldrt_conf_absdrtth
//bit 19:18,   reg_ei_caldrt_abcheck_mode1
//bit 17:16,   reg_ei_caldrt_abcheck_mode0
//bit 15:12,   reg_ei_caldrt_abcheck_drth1
//bit 11:8,    reg_ei_caldrt_abcheck_drth0
//bit 6:4,     reg_ei_caldrt_abpnchk1_th
//bit 1,       reg_ei_caldrt_abpnchk1_en
//bit 0,       reg_ei_caldrt_abpnchk0_en
// DEINTERLACE mode check.
#define DI_MC_REG0_X                               ((0x1720  << 2) + 0xff900000)
//bit 27:16,   mc_reg0_start_x
//bit 11:0,    mc_reg0_end_x
#define DI_MC_REG0_Y                               ((0x1721  << 2) + 0xff900000)
#define DI_MC_REG1_X                               ((0x1722  << 2) + 0xff900000)
#define DI_MC_REG1_Y                               ((0x1723  << 2) + 0xff900000)
#define DI_MC_REG2_X                               ((0x1724  << 2) + 0xff900000)
#define DI_MC_REG2_Y                               ((0x1725  << 2) + 0xff900000)
#define DI_MC_REG3_X                               ((0x1726  << 2) + 0xff900000)
#define DI_MC_REG3_Y                               ((0x1727  << 2) + 0xff900000)
#define DI_MC_REG4_X                               ((0x1728  << 2) + 0xff900000)
#define DI_MC_REG4_Y                               ((0x1729  << 2) + 0xff900000)
#define DI_MC_32LVL0                               ((0x172a  << 2) + 0xff900000)
//bit 31:24,   mc_reg2_32lvl
//bit 23:16,   mc_reg1_32lvl
//bit 15:8,    mc_reg0_32lvl
//bit 7:0,     field_32lvl
#define DI_MC_32LVL1                               ((0x172b  << 2) + 0xff900000)
//bit 15:8,    mc_reg3_32lvl
//bit 7:0,     mc_reg4_32lvl
#define DI_MC_22LVL0                               ((0x172c  << 2) + 0xff900000)
//bit 31:16,   mc_reg0_22lvl
//bit 15:0,    field_22lvl
#define DI_MC_22LVL1                               ((0x172d  << 2) + 0xff900000)
//bit 31:16,   mc_reg2_22lvl
//bit 15:0,    mc_reg1_22lvl
#define DI_MC_22LVL2                               ((0x172e  << 2) + 0xff900000)
//bit 31:16,   mc_reg4_22lvl
//bit 15:0,    mc_reg3_22lvl
#define DI_MC_CTRL                                 ((0x172f  << 2) + 0xff900000)
//bit 4,       mc_reg4_en
//bit 3,       mc_reg3_en
//bit 2,       mc_reg2_en
//bit 1,       mc_reg1_en
//bit 0,       mc_reg0_en
#define DI_INTR_CTRL                               ((0x1730  << 2) + 0xff900000)
#define DI_INFO_ADDR                               ((0x1731  << 2) + 0xff900000)
#define DI_INFO_DATA                               ((0x1732  << 2) + 0xff900000)
#define DI_PRE_HOLD                                ((0x1733  << 2) + 0xff900000)
//// DET 3D REG DEFINE BEGIN ////
//// 8'h34~8'h3f
//     `define DET3D_MOTN_CFG                8'h34
//     //Bit 16,	reg_det3d_intr_en	        Det3d interrupt enable
//     //Bit 9:8,	reg_Det3D_Motion_Mode	    U2  Different mode for Motion Calculation of Luma and Chroma:
//     //                                      0: MotY, 1: (2*MotY + (MotU + MotV))/4; 2: Max(MotY, MotU,MotV); 3:Max(MotY, (MotU+MotV)/2)
//     //Bit 7:4,	reg_Det3D_Motion_Core_Rate	U4  K Rate to Edge (HV) details for coring of Motion Calculations, normalized to 32
//     //Bit 3:0,	reg_Det3D_Motion_Core_Thrd	U4  2X: static coring value for Motion Detection.
//
//     `define DET3D_CB_CFG                  8'h35
//     //Bit 7:4,	reg_Det3D_ChessBd_NHV_ofst	U4,  Noise immune offset for NON-Horizontal or vertical combing detection.
//     //Bit 3:0,	reg_Det3D_ChessBd_HV_ofst	U4,  Noise immune offset for Horizontal or vertical combing detection.
//
//     `define DET3D_SPLT_CFG                8'h36
//     //Bit 7:4,	reg_Det3D_SplitValid_ratio	U4,  Ratio between max_value and the avg_value of the edge mapping for split line valid detection.
//     //                                      The smaller of this value, the easier of the split line detected.
//     //Bit 3:0,	reg_Det3D_AvgIdx_ratio	    U4,  Ratio to the avg_value of the edge mapping for split line position estimation.
//     //                                      The smaller of this value, the more samples will be added to the estimation.
//
//     `define DET3D_HV_MUTE                 8'h37
//     //Bit 23:20, reg_Det3D_Edge_Ver_Mute	U4  X2: Horizontal pixels to be mute from H/V Edge calculation Top and Bottom border part.
//     //Bit 19:16, reg_Det3D_Edge_Hor_Mute	U4  X2: Horizontal pixels to be mute from H/V Edge calculation Left and right border part.
//     //Bit 15:12, reg_Det3D_ChessBd_Ver_Mute	U4  X2: Horizontal pixels to be mute from ChessBoard statistics calculation in middle part
//     //Bit 11:8,	 reg_Det3D_ChessBd_Hor_Mute	U4  X2: Horizontal pixels to be mute from ChessBoard statistics calculation in middle part
//     //Bit 7:4,	 reg_Det3D_STA8X8_Ver_Mute	U4  1X: Vertical pixels to be mute from 8x8 statistics calculation in each block.
//     //Bit 3:0,	 reg_Det3D_STA8X8_Hor_Mute	U4  1X: Horizontal pixels to be mute from 8x8 statistics calculation in each block.
//
//     `define DET3D_MAT_STA_P1M1            8'h38
//     //Bit 31:24, reg_Det3D_STA8X8_P1_K0_R8	U8  SAD to SAI ratio to decide P1, normalized to 256 (0.8)
//     //Bit 23:16, reg_Det3D_STA8X8_P1_K1_R7	U8  SAD to ENG ratio to decide P1, normalized to 128 (0.5)
//     //Bit 15:8,	 reg_Det3D_STA8X8_M1_K0_R6	U8  SAD to SAI ratio to decide M1, normalized to 64  (1.1)
//     //Bit 7:0,	 reg_Det3D_STA8X8_M1_K1_R6	U8  SAD to ENG ratio to decide M1, normalized to 64  (0.8)
//
//     `define DET3D_MAT_STA_P1TH            8'h39
//     //Bit 23:16, reg_Det3D_STAYUV_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16         (100)
//     //Bit 15:8,	 reg_Det3D_STAEDG_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16         (80)
//     //Bit 7:0,	 reg_Det3D_STAMOT_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16         (48)
//
//     `define DET3D_MAT_STA_M1TH            8'h3a
//     //Bit 23:16, reg_Det3D_STAYUV_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16         (100)
//     //Bit 15:8,	 reg_Det3D_STAEDG_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16         (80)
//     //Bit 7:0,	 reg_Det3D_STAMOT_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16         (64)
//
//     `define DET3D_MAT_STA_RSFT            8'h3b
//     //Bit 5:4,	 reg_Det3D_STAYUV_RSHFT	    U2  YUV statistics SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//     //                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//     //Bit 3:2,	 reg_Det3D_STAEDG_RSHFT	    U2  Horizontal and Vertical Edge Statistics SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//     //                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//     //Bit 1:0,	 reg_Det3D_STAMOT_RSHFT	    U2  Motion SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//     //                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//
//     `define DET3D_MAT_SYMTC_TH            8'h3c
//     //Bit 31:24, reg_Det3D_STALUM_symtc_Th	  U8  threshold to decide if the Luma statistics is TB or LR symmetric.
//     //Bit 23:16, reg_Det3D_STACHR_symtc_Th	  U8  threshold to decide if the Chroma (UV) statistics is TB or LR symmetric.
//     //Bit 15:8,	 reg_Det3D_STAEDG_symtc_Th	  U8  threshold to decide if the Horizontal and Vertical Edge statistics is TB or LR symmetric.
//     //Bit 7:0,	 reg_Det3D_STAMOT_symtc_Th	  U8  threshold to decide if the Motion statistics is TB or LR symmetric.
//
//     `define DET3D_RO_DET_CB_HOR           8'h3d
//     //Bit 31:16, RO_Det3D_ChessBd_NHor_value    U16  X64: number of Pixels of Horizontally Surely NOT matching Chessboard pattern.
//     //Bit 15:0,	 RO_Det3D_ChessBd_Hor_value	    U16  X64: number of Pixels of Horizontally Surely matching Chessboard pattern.
//
//     `define DET3D_RO_DET_CB_VER           8'h3e
//     //Bit 31:16, RO_Det3D_ChessBd_NVer_value	U16  X64: number of Pixels of Vertically Surely NOT matching Chessboard pattern.
//     //Bit 15:0,	 RO_Det3D_ChessBd_Ver_value	    U16  X64: number of Pixels of Vertically Surely matching Chessboard pattern.
//
//     `define DET3D_RO_SPLT_HT              8'h3f
//     //Bit 24,	 RO_Det3D_Split_HT_valid	U1  horizontal LR split border detected valid signal for top half picture
//     //Bit 20:16, RO_Det3D_Split_HT_pxnum	U5  number of pixels included for the LR split position estimation for top half picture
//     //Bit 9:0,	 RO_Det3D_Split_HT_idxX4	S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
//
//     //// DET 3D REG DEFINE END ////
#define DI_MTN_1_CTRL1                             ((0x1740  << 2) + 0xff900000)
//bit 31,      mtn_1_en
//bit 30,      mtn_init
//bit 29,      di2nr_txt_en
//bit 28,      reserved
//bit 27:24,   mtn_def
//bit 23:16,   mtn_adp_yc
//bit 15:8,    mtn_adp_2c
//bit 7:0,     mtn_adp_2y
#define DI_MTN_1_CTRL2                             ((0x1741  << 2) + 0xff900000)
//bit 31:24,   mtn_ykinter
//bit 23:16,   mtn_ckinter
//bit 15:8,    mtn_ykintra
//bit  7:0,    mtn_ckintra
#define DI_MTN_1_CTRL3                             ((0x1742  << 2) + 0xff900000)
//bit 31:24,   mtn_tyrate
//bit 23:16,   mtn_tcrate
//bit 15: 8,   mtn_mxcmby
//bit  7: 0,   mtn_mxcmbc
#define DI_MTN_1_CTRL4                             ((0x1743  << 2) + 0xff900000)
//bit 31:24,   mtn_tcorey
//bit 23:16,   mtn_tcorec
//bit 15: 8,   mtn_minth
//bit  7: 0,   mtn_maxth
#define DI_MTN_1_CTRL5                             ((0x1744  << 2) + 0xff900000)
//bit 31:28,   mtn_m1b_extend
//bit 27:24,   mtn_m1b_errod
//bit 21:20,   mtn_mot_txt_mode
//bit 19:18,   mtn_replace_cbyy
//bit 17:16,   mtn_replace_ybyc
//bit 15: 8,   mtn_core_ykinter
//bit  7: 0,   mtn_core_ckinter
//// NR2 REG DEFINE BEGIN////
#define NR2_MET_NM_CTRL                            ((0x1745  << 2) + 0xff900000)
//Bit 28,	   reg_NM_reset	          Reset to the status of the Loop filter.
//Bit 27:24,   reg_NM_calc_length	  Length mode of the Noise measurement sample number for statistics.
//                                    0:  256 samples;    1: 512 samples;    2: 1024 samples;   ¡­X: 2^(8+x) samples
//Bit 23:20,   reg_NM_inc_step	      Loop filter input gain increase step.
//Bit 19:16,   reg_NM_dec_step	      Loop filter input gain decrease step.
//Bit 15:8,	   reg_NM_YHPmot_thrd	  Luma channel HP portion motion for condition of pixels included in Luma Noise measurement.
//Bit 7:0,	   reg_NM_CHPmot_thrd	  Chroma channel HP portion motion for condition of pixels included in Chroma Noise measurement.
#define NR2_MET_NM_YCTRL                           ((0x1746  << 2) + 0xff900000)
//Bit 31:28,   reg_NM_YPLL_target	      Target rate of NM_Ynoise_thrd to mean of the Luma Noise
//Bit 27:24,   reg_NM_YLPmot_thrd	      Luma channel LP portion motion for condition of pixels included in Luma Noise measurement.
//Bit 23:16,   reg_NM_YHPmot_thrd_min	  Minimum threshold for Luma channel HP portion motion to decide whether the pixel will be included in Luma noise measurement.
//Bit 15:8,	   reg_NM_YHPmot_thrd_max	  Maximum threshold for Luma channel HP portion motion to decide whether the pixel will be included in Luma noise measurement.
//Bit 7:0,	   reg_NM_Ylock_rate	      Rate to decide whether the Luma noise measurement is lock or not.
#define NR2_MET_NM_CCTRL                           ((0x1747  << 2) + 0xff900000)
//Bit 31:28,	reg_NM_CPLL_target	     Target rate of NM_Cnoise_thrd to mean of the Chroma Noise
//Bit 27:24,	reg_NM_CLPmot_thrd	     Chroma channel LP portion motion for condition of pixels included in Chroma Noise measurement.
//Bit 23:16,	reg_NM_CHPmot_thrd_min	 Minimum threshold for Chroma channel HP portion motion to decide whether the pixel will be included in Chroma noise measurement.
//Bit 15:8,	    reg_NM_CHPmot_thrd_max	 Maximum threshold for Chroma channel HP portion motion to decide whether the pixel will be included in Chroma noise measurement.
//Bit 7:0,	    reg_NM_Clock_rate	     Rate to decide whether the Chroma noise measurement is lock or not;
#define NR2_MET_NM_TNR                             ((0x1748  << 2) + 0xff900000)
//Bit 25,	    ro_NM_TNR_Ylock	         Read-only register to tell ifLuma channel noise measurement is locked or not.
//Bit 24,	    ro_NM_TNR_Clock	         Read-only register to tell if Chroma channel noise measurement is locked or not.
//Bit 23:12,	ro_NM_TNR_Ylevel	     Read-only register to give Luma channel noise level. It was 16x of pixel difference in 8 bits of YHPmot.
//Bit 11:0,	ro_NM_TNR_Clevel	         Read-only register to give Chroma channel noise level. It was 16x of pixel difference in 8 bits of CHPmot.
#define NR2_MET_NMFRM_TNR_YLEV                     ((0x1749  << 2) + 0xff900000)
//Bit 28:0,	ro_NMFrm_TNR_Ylevel	         Frame based Read-only register to give Luma channel noise level within one frame/field.
#define NR2_MET_NMFRM_TNR_YCNT                     ((0x174a  << 2) + 0xff900000)
//Bit 23:0,	ro_NMFrm_TNR_Ycount	         Number ofLuma channel pixels included in Frame/Field based noise level measurement.
#define NR2_MET_NMFRM_TNR_CLEV                     ((0x174b  << 2) + 0xff900000)
//Bit 28:0,	ro_NMFrm_TNR_Clevel	         Frame based Read-only register to give Chroma channel noise level within one frame/field.
#define NR2_MET_NMFRM_TNR_CCNT                     ((0x174c  << 2) + 0xff900000)
//Bit 23:0,	ro_NMFrm_TNR_Ccount	         Number of Chroma channel pixels included in Frame/Field based noise level measurement.
#define NR2_3DEN_MODE                              ((0x174d  << 2) + 0xff900000)
//Bit 6:4,	Blend_3dnr_en_r
//Bit 2:0,	Blend_3dnr_en_l
//   `define NR2_IIR_CTRL                8'h4e
//   //Bit 15:14, reg_LP_IIR_8bit_mode	LP IIR membitwidth mode:0: 10bits will be store in memory;1: 9bits will be store in memory;
//   //                                  2: 8bits will be store in memory;3: 7bits will be store in memory;
//   //Bit 13:12, reg_LP_IIR_mute_mode	Mode for the LP IIR mute,
//   //Bit 11:8,	 reg_LP_IIR_mute_thrd	Threshold of LP IIR mute to avoid ghost:
//   //Bit 7:6,	 reg_HP_IIR_8bit_mode	IIR membitwidth mode:0: 10bits will be store in memory;1: 9bits will be store in memory;
//   //                                  2: 8bits will be store in memory;3: 7bits will be store in memory;
//   //Bit 5:4,	reg_HP_IIR_mute_mode	Mode for theLP IIR mute
//   //Bit 3:0,	reg_HP_IIR_mute_thrd	Threshold of HP IIR mute to avoid ghost
//   //
#define NR2_SW_EN                                  ((0x174f  << 2) + 0xff900000)
//Bit 17:8,	Clk_gate_ctrl
//Bit 7,	Cfr_enable
//Bit 5,	Det3d_en
//Bit 4,	Nr2_proc_en
//Bit 0,	Nr2_sw_en
#define NR2_FRM_SIZE                               ((0x1750  << 2) + 0xff900000)
//Bit 27:16,  Frm_heigh	Frame/field height
//Bit 11: 0,  Frm_width	Frame/field width
//   `define NR2_SNR_SAD_CFG             8'h51
//   //Bit 12,	reg_MATNR_SNR_SAD_CenRPL	U1, Enable signal for Current pixel position SAD to be replaced by SAD_min.0: do not replace Current pixel position SAD by SAD_min;1: do replacements
//   //Bit 11:8,	reg_MATNR_SNR_SAD_coring	Coring value of the intra-frame SAD. sum = (sum - reg_MATNR_SNR_SAD_coring);sum = (sum<0) ? 0: (sum>255)? 255: sum;
//   //Bit 6:5,	reg_MATNR_SNR_SAD_WinMod	Unsigned, Intra-frame SAD matching window mode:0: 1x1; 1: [1 1 1] 2: [1 2 1]; 3: [1 2 2 2 1];
//   //Bit 4:0,	Sad_coef_num	            Sad coeffient
//
//   `define NR2_MATNR_SNR_OS            8'h52
//   //Bit 7:4,	reg_MATNR_SNR_COS	    SNR Filter overshoot control margin for UV channel (X2 to u10 scale)
//   //Bit 3:0,	reg_MATNR_SNR_YOS	    SNR Filter overshoot control margin for luma channel (X2 to u10 scale)
//
//   `define NR2_MATNR_SNR_NRM_CFG       8'h53
//   //Bit 23:16,	reg_MATNR_SNR_NRM_ofst	Edge based SNR boosting normalization offset to SAD_max ;
//   //Bit 15:8,	    reg_MATNR_SNR_NRM_max	Edge based SNR boosting normalization Max value
//   //Bit 7:0,	    reg_MATNR_SNR_NRM_min	Edge based SNR boosting normalization Min value
//
//   `define NR2_MATNR_SNR_NRM_GAIN      8'h54
//   //Bit 15:8,	reg_MATNR_SNR_NRM_Cgain	Edge based SNR boosting normalization Gain for Chrm channel (norm 32 as 1)
//   //Bit 7:0,	reg_MATNR_SNR_NRM_Ygain	Edge based SNR boosting normalization Gain for Luma channel (norm 32 as 1)
//
//   `define NR2_MATNR_SNR_LPF_CFG       8'h55
//   //Bit 23:16,reg_MATNR_SNRLPF_SADmaxTH	U8,  Threshold to SADmax to use TNRLPF to replace SNRLPF. i.e.if (SAD_max<reg_MATNR_SNRLPF_SADmaxTH) SNRLPF_yuv[k] = TNRLPF_yuv[k];
//   //Bit 13:11,reg_MATNR_SNRLPF_Cmode	    LPF based SNR filtering mode on CHRM channel:
//   //                                      0: gradient LPF [1 1]/2, 1: gradient LPF [2 1 1]/4; 2: gradient LPF [3 3 2]/8; 3: gradient LPF [5 4 4 3]/16;
//   //                                      4: TNRLPF;  5 : CurLPF3x3_yuv[];  6: CurLPF3o3_yuv[]  7: CurLPF3x5_yuv[]
//   //Bit 10:8,	reg_MATNR_SNRLPF_Ymode	    LPF based SNR filtering mode on LUMA channel:
//   //                                      0: gradient LPF //Bit [1 1]/2, 1: gradient LPF [2 1 1]/4; 2: gradient LPF [3 3 2]/8;3: gradient LPF [5 4 4 3]/16;
//   //                                      4: TNRLPF;               5 : CurLPF3x3_yuv[];       6: CurLPF3o3_yuv[]         7: CurLPF3x5_yuv[]
//   //Bit 7:4,	reg_MATNR_SNRLPF_SADmin3TH	Offset threshold to SAD_min to Discard SAD_min3 corresponding pixel in LPF SNR filtering. (X8 to u8 scale)
//   //Bit 3:0,	reg_MATNR_SNRLPF_SADmin2TH	Offset threshold to SAD_min to Discard SAD_min2 corresponding pixel in LPF SNR filtering. (X8 to u8 scale)
//
//   `define NR2_MATNR_SNR_USF_GAIN      8'h56
//   //Bit 15:8,	reg_MATNR_SNR_USF_Cgain	    Un-sharp (HP) compensate back Chrm portion gain, (norm 64 as 1)
//   //Bit 7:0,	reg_MATNR_SNR_USF_Ygain	    Un-sharp (HP) compensate back Luma portion gain, (norm 64 as 1)
//
//   `define NR2_MATNR_SNR_EDGE2B        8'h57
//   //Bit 15:8,	reg_MATNR_SNR_Edge2Beta_ofst	U8,  Offset for Beta based on Edge.
//   //Bit 7:0,	reg_MATNR_SNR_Edge2Beta_gain	U8.  Gain to SAD_min for Beta based on Edge. (norm 16 as 1)
//
//   `define NR2_MATNR_BETA_EGAIN        8'h58
//   //Bit 15:8,	reg_MATNR_CBeta_Egain	U8,  Gain to Edge based Beta for Chrm channel. (normalized to 32 as 1)
//   //Bit 7:0,	reg_MATNR_YBeta_Egain	U8,  Gain to Edge based Beta for Luma channel. (normalized to 32 as 1)
//
//   `define NR2_MATNR_BETA_BRT          8'h59
//   //Bit 31:28,	reg_MATNR_beta_BRT_limt_hi	U4,  Beta adjustment based on Brightness high side Limit. (X16 to u8 scale)
//   //Bit 27:24,	reg_MATNR_beta_BRT_slop_hi	U4,  Beta adjustment based on Brightness high side slope. Normalized to 16 as 1
//   //Bit 23:16,	reg_MATNR_beta_BRT_thrd_hi	U8,  Beta adjustment based on Brightness high threshold.(u8 scale)
//   //Bit 15:12,	reg_MATNR_beta_BRT_limt_lo	U4,  Beta adjustment based on Brightness low side Limit. (X16 to u8 scale)
//   //Bit 11:8,	    reg_MATNR_beta_BRT_slop_lo	U4,  Beta adjustment based on Brightness low side slope. Normalized to 16 as 1
//   //Bit 7:0,	    reg_MATNR_beta_BRT_thrd_lo	U8,  Beta adjustment based on Brightness low threshold.(u8 scale)
//   `define NR2_MATNR_XBETA_CFG         8'h5a
//   //Bit 19:18,	reg_MATNR_CBeta_use_mode	U2,  Beta options (mux) from beta_motion and beta_edge for Chrm channel;
//   //Bit 17:16,	reg_MATNR_YBeta_use_mode	U2,  Beta options (mux) from beta_motion and beta_edge for Luma channel;
//   //Bit 15: 8,	reg_MATNR_CBeta_Ofst	    U8,  Offset to Beta for Chrm channel.(after beta_edge and beta_motion mux)
//   //Bit  7: 0,	reg_MATNR_YBeta_Ofst	    U8,  Offset to Beta for Luma channel.(after beta_edge and beta_motion mux)
//   `define NR2_MATNR_YBETA_SCL         8'h5b
//   //Bit 31:24,	reg_MATNR_YBeta_scale_min	U8,  Final step Beta scale low limit for Luma channel;
//   //Bit 23:16,	reg_MATNR_YBeta_scale_max	U8,  Final step Beta scale high limit for Luma channe;
//   //Bit 15: 8,	reg_MATNR_YBeta_scale_gain	U8,  Final step Beta scale Gain for Luma channel (normalized 32 to 1);
//   //Bit 7 : 0,	reg_MATNR_YBeta_scale_ofst	S8,  Final step Beta scale offset for Luma channel ;
//   `define NR2_MATNR_CBETA_SCL         8'h5c
//   //Bit 31:24,	reg_MATNR_CBeta_scale_min	Final step Beta scale low limit for Chrm channel.Similar to Y
//   //Bit 23:16,	reg_MATNR_CBeta_scale_max	U8,  Final step Beta scale high limit for Chrm channel.Similar to Y
//   //Bit 15: 8,	reg_MATNR_CBeta_scale_gain	U8,  Final step Beta scale Gain for Chrm channel Similar to Y
//   //Bit  7: 0,	reg_MATNR_CBeta_scale_ofst	S8,  Final step Beta scale offset for Chrm channel Similar to Y
//   `define NR2_SNR_MASK                8'h5d
//   //Bit 20:0, 	SAD_MSK	                    Valid signal in the 3x7 SAD surface
//   `define NR2_SAD2NORM_LUT0           8'h5e
//   //Bit 31:24,	reg_MATNR_SAD2Norm_LUT_3	SAD convert normal LUT node 3
//   //Bit 23:16,	reg_MATNR_SAD2Norm_LUT_2	SAD convert normal LUT node 2
//   //Bit 15: 8,	reg_MATNR_SAD2Norm_LUT_1	SAD convert normal LUT node 1
//   //Bit  7: 0,	reg_MATNR_SAD2Norm_LUT_0	SAD convert normal LUT node 0
//   `define NR2_SAD2NORM_LUT1           8'h5f
//   //Bit 31:24,	reg_MATNR_SAD2Norm_LUT_7	SAD convert normal LUT node 7
//   //Bit 23:16,	reg_MATNR_SAD2Norm_LUT_6	SAD convert normal LUT node 6
//   //Bit 15: 8,	reg_MATNR_SAD2Norm_LUT_5	SAD convert normal LUT node 5
//   //Bit  7: 0,	reg_MATNR_SAD2Norm_LUT_4	SAD convert normal LUT node 4
//   `define NR2_SAD2NORM_LUT2           8'h60
//   //Bit 31:24,	reg_MATNR_SAD2Norm_LUT_11	SAD convert normal LUT node 11
//   //Bit 23:16,	reg_MATNR_SAD2Norm_LUT_10	SAD convert normal LUT node 10
//   //Bit 15: 8,	reg_MATNR_SAD2Norm_LUT_9	SAD convert normal LUT node 9
//   //Bit  7: 0,	reg_MATNR_SAD2Norm_LUT_8	SAD convert normal LUT node 8
//   `define NR2_SAD2NORM_LUT3           8'h61
//   //Bit 31:24,	reg_MATNR_SAD2Norm_LUT_15	SAD convert normal LUT node 15
//   //Bit 23:16,	reg_MATNR_SAD2Norm_LUT_14	SAD convert normal LUT node 14
//   //Bit 15:8,	reg_MATNR_SAD2Norm_LUT_13	SAD convert normal LUT node 13
//   //Bit 7:0,	reg_MATNR_SAD2Norm_LUT_12	SAD convert normal LUT node 12
//   `define NR2_EDGE2BETA_LUT0          8'h62
//   //Bit 31:24,	reg_MATNR_Edge2Beta_LUT_3	Edge convert beta LUT node 3
//   //Bit 23:16,	reg_MATNR_Edge2Beta_LUT_2	Edge convert beta LUT node 2
//   //Bit 15: 8,	reg_MATNR_Edge2Beta_LUT_1	Edge convert beta LUT node 1
//   //Bit  7: 0,	reg_MATNR_Edge2Beta_LUT_0	Edge convert beta LUT node 0
//   `define NR2_EDGE2BETA_LUT1          8'h63
//   //Bit 31:24,	reg_MATNR_Edge2Beta_LUT_7	Edge convert beta LUT node 7
//   //Bit 23:16,	reg_MATNR_Edge2Beta_LUT_6	Edge convert beta LUT node 6
//   //Bit 15: 8,	reg_MATNR_Edge2Beta_LUT_5	Edge convert beta LUT node 5
//   //Bit  7: 0,	reg_MATNR_Edge2Beta_LUT_4	Edge convert beta LUT node 4
//   `define NR2_EDGE2BETA_LUT2          8'h64
//   //Bit 31:24,	reg_MATNR_Edge2Beta_LUT_11	Edge convert beta LUT node 11
//   //Bit 23:16,	reg_MATNR_Edge2Beta_LUT_10	Edge convert beta LUT node 10
//   //Bit 15: 8,	reg_MATNR_Edge2Beta_LUT_9	Edge convert beta LUT node 9
//   //Bit  7: 0,	reg_MATNR_Edge2Beta_LUT_8	Edge convert beta LUT node 8
//   `define NR2_EDGE2BETA_LUT3          8'h65
//   //Bit 31:24,	reg_MATNR_Edge2Beta_LUT_15	Edge convert beta LUT node 15
//   //Bit 23:16,	reg_MATNR_Edge2Beta_LUT_14	Edge convert beta LUT node 14
//   //Bit 15: 8,	reg_MATNR_Edge2Beta_LUT_13	Edge convert beta LUT node 13
//   //Bit  7: 0,	reg_MATNR_Edge2Beta_LUT_12	Edge convert beta LUT node 12
//   `define NR2_MOTION2BETA_LUT0        8'h66
//   //Bit 31:24,	reg_MATNR_Mot2Beta_LUT_3	Motion convert beta LUT node 3
//   //Bit 23:16,	reg_MATNR_Mot2Beta_LUT_2	Motion convert beta LUT node 2
//   //Bit 15: 8,	reg_MATNR_Mot2Beta_LUT_1	Motion convert beta LUT node 1
//   //Bit  7: 0,	reg_MATNR_Mot2Beta_LUT_0	Motion convert beta LUT node 0
//   `define NR2_MOTION2BETA_LUT1        8'h67
//   //Bit 31:24,	reg_MATNR_Mot2Beta_LUT_7	Motion convert beta LUT node 7
//   //Bit 23:16,	reg_MATNR_Mot2Beta_LUT_6	Motion convert beta LUT node 6
//   //Bit 15: 8,	reg_MATNR_Mot2Beta_LUT_5	Motion convert beta LUT node 5
//   //Bit  7: 0,	reg_MATNR_Mot2Beta_LUT_4	Motion convert beta LUT node 4
//   `define NR2_MOTION2BETA_LUT2        8'h68
//   //Bit 31:24,	reg_MATNR_Mot2Beta_LUT_11	Motion convert beta LUT node 11
//   //Bit 23:16,	reg_MATNR_Mot2Beta_LUT_10	Motion convert beta LUT node 10
//   //Bit 15: 8,	reg_MATNR_Mot2Beta_LUT_9	Motion convert beta LUT node 9
//   //Bit  7: 0,	reg_MATNR_Mot2Beta_LUT_8	Motion convert beta LUT node 8
//   `define NR2_MOTION2BETA_LUT3        8'h69
//   //Bit 31:24,	reg_MATNR_Mot2Beta_LUT_15	Motion convert beta LUT node 15
//   //Bit 23:16,	reg_MATNR_Mot2Beta_LUT_14	Motion convert beta LUT node 14
//   //Bit 15: 8,	reg_MATNR_Mot2Beta_LUT_13	Motion convert beta LUT node 13
//   //Bit  7: 0,	reg_MATNR_Mot2Beta_LUT_12	Motion convert beta LUT node 12
//    `define NR2_MATNR_MTN_CRTL          8'h6a
//    //Bit 25:24,	reg_MATNR_Vmtn_use_mode	    Motion_yuvV channel motion selection mode:0: Vmot;1:Ymot/2 + (Umot+Vmot)/4; 2:Ymot/2 + max(Umot,Vmot)/2; 3: max(Ymot,Umot, Vmot)
//    //Bit 21:20,	reg_MATNR_Umtn_use_mode	    Motion_yuvU channel motion selection mode:0:Umot;1:Ymot/2 + (Umot+Vmot)/4; 2:Ymot/2 + max(Umot,Vmot)/2; 3: max(Ymot,Umot, Vmot)
//    //Bit 17:16,	reg_MATNR_Ymtn_use_mode	    Motion_yuvLuma channel motion selection mode:0:  Ymot, 1: Ymot/2 + (Umot+Vmot)/4; 2: Ymot/2 + max(Umot,Vmot)/2; 3:  max(Ymot,Umot, Vmot)
//    //Bit 13:12,	reg_MATNR_mtn_txt_mode	    Texture detection mode for adaptive coring of HP motion
//    //Bit  9: 8,	reg_MATNR_mtn_cor_mode	    Coring selection mode based on texture detection;
//    //Bit  6: 4,	reg_MATNR_mtn_hpf_mode	    video mode of current and previous frame/field for MotHPF_yuv[k] calculation:
//    //Bit  2: 0,	reg_MATNR_mtn_lpf_mode	    LPF video mode of current and previous frame/field for MotLPF_yuv[k] calculation:
//    `define NR2_MATNR_MTN_CRTL2         8'h6b
//    //Bit 18:16,	reg_MATNR_iir_BS_Ymode	    IIR TNR filter Band split filter mode for Luma LPF result generation (Cur and Prev);
//    //Bit 15: 8,	reg_MATNR_mtnb_alpLP_Cgain	Scale of motion_brthp_uv to motion_brtlp_uv, normalized to 32 as 1
//    //Bit  7: 0,	reg_MATNR_mtnb_alpLP_Ygain	Scale of motion_brthp_y to motion_brtlp_y, normalized to 32 as 1
//    `define NR2_MATNR_MTN_COR           8'h6c
//    //Bit 15:12,	reg_MATNR_mtn_cor_Cofst	    Coring Offset for Chroma Motion.
//    //Bit 11: 8,	reg_MATNR_mtn_cor_Cgain	    Gain to texture based coring for Chroma Motion. Normalized to 16 as 1
//    //Bit  7: 4,	reg_MATNR_mtn_cor_Yofst	    Coring Offset for Luma Motion.
//    //Bit  3: 0,	reg_MATNR_mtn_cor_Ygain	    Gain to texture based coring for Luma Motion. Normalized to 16 as 1
//    `define NR2_MATNR_MTN_GAIN          8'h6d
//    //Bit 31:24,	reg_MATNR_mtn_hp_Cgain	Gain to MotHPF_yuv[k] Chrm channel for motion calculation, normalized to 64 as 1
//    //Bit 23:16,	reg_MATNR_mtn_hp_Ygain	Gain to MotHPF_yuv[k] Luma channel for motion calculation, normalized to 64 as 1
//    //Bit 15: 8,	reg_MATNR_mtn_lp_Cgain	Gain to MotLPF_yuv[k] Chrm channel for motion calculation, normalized to 32 as 1
//    //Bit  7: 0,	reg_MATNR_mtn_lp_Ygain	Gain to MotLPF_yuv[k] Luma channel for motion calculation, normalized to 32 as 1
//    `define NR2_MATNR_DEGHOST           8'h6e
//    //Bit 8,	reg_MATNR_DeGhost_En	Enable signal for DeGhost function:0: disable; 1: enable
//    //Bit 7:4,	reg_MATNR_DeGhost_COS	DeGhost Overshoot margin for UV channel, (X2 to u10 scale)
//    //Bit 3:0,	reg_MATNR_DeGhost_YOS	DeGhost Overshoot margin for Luma channel, (X2 to u10 scale)
//
//    `define NR2_MATNR_ALPHALP_LUT0      8'h6f
//    //Bit 31:24,	reg_MATNR_AlphaLP_LUT_3	    Matnr low-pass filter alpha LUT node 3
//    //Bit 23:16,	reg_MATNR_AlphaLP_LUT_2	    Matnr low-pass filter alpha LUT node 2
//    //Bit 15: 8,	reg_MATNR_AlphaLP_LUT_1	    Matnr low-pass filter alpha LUT node 1
//    //Bit  7: 0,	reg_MATNR_AlphaLP_LUT_0	    Matnr low-pass filter alpha LUT node 0
//    `define NR2_MATNR_ALPHALP_LUT1      8'h70
//    //Bit 31:24,	reg_MATNR_AlphaLP_LUT_7	    Matnr low-pass filter alpha LUT node 7
//    //Bit 23:16,	reg_MATNR_AlphaLP_LUT_6	    Matnr low-pass filter alpha LUT node 6
//    //Bit 15: 8,	reg_MATNR_AlphaLP_LUT_5	    Matnr low-pass filter alpha LUT node 5
//    //Bit  7: 0,	reg_MATNR_AlphaLP_LUT_4	    Matnr low-pass filter alpha LUT node 4
//    `define NR2_MATNR_ALPHALP_LUT2      8'h71
//    //Bit 31:24,	reg_MATNR_AlphaLP_LUT_11	Matnr low-pass filter alpha LUT node 11
//    //Bit 23:16,	reg_MATNR_AlphaLP_LUT_10	Matnr low-pass filter alpha LUT node 10
//    //Bit 15: 8,	reg_MATNR_AlphaLP_LUT_9	    Matnr low-pass filter alpha LUT node 9
//    //Bit  7: 0,	reg_MATNR_AlphaLP_LUT_8	    Matnr low-pass filter alpha LUT node 8
//    `define NR2_MATNR_ALPHALP_LUT3      8'h72
//    //Bit 31:24,	reg_MATNR_AlphaLP_LUT_15	Matnr low-pass filter alpha LUT node 15
//    //Bit 23:16,	reg_MATNR_AlphaLP_LUT_14	Matnr low-pass filter alpha LUT node 14
//    //Bit 15: 8,	reg_MATNR_AlphaLP_LUT_13	Matnr low-pass filter alpha LUT node 13
//    //Bit  7: 0,	reg_MATNR_AlphaLP_LUT_12	Matnr low-pass filter alpha LUT node 12
//    `define NR2_MATNR_ALPHAHP_LUT0      8'h73
//    //Bit 31:24,	reg_MATNR_AlphaHP_LUT_3	    Matnr high-pass filter alpha LUT node 3
//    //Bit 23:16,	reg_MATNR_AlphaHP_LUT_2	    Matnr high-pass filter alpha LUT node 2
//    //Bit 15: 8,	reg_MATNR_AlphaHP_LUT_1	    Matnr high-pass filter alpha LUT node 1
//    //Bit  7: 0,	reg_MATNR_AlphaHP_LUT_0	    Matnr high-pass filter alpha LUT node 0
//    `define NR2_MATNR_ALPHAHP_LUT1      8'h74
//    //Bit 31:24,	reg_MATNR_AlphaHP_LUT_7	    Matnr high-pass filter alpha LUT node 7
//    //Bit 23:16,	reg_MATNR_AlphaHP_LUT_6	    Matnr high-pass filter alpha LUT node 6
//    //Bit 15: 8,	reg_MATNR_AlphaHP_LUT_5	    Matnr high-pass filter alpha LUT node 5
//    //Bit  7: 0,	reg_MATNR_AlphaHP_LUT_4	    Matnr high-pass filter alpha LUT node 4
//    `define NR2_MATNR_ALPHAHP_LUT2      8'h75
//    //Bit 31:24,	reg_MATNR_AlphaHP_LUT_11	Matnr high-pass filter alpha LUT node 11
//    //Bit 23:16,	reg_MATNR_AlphaHP_LUT_10	Matnr high-pass filter alpha LUT node 10
//    //Bit 15: 8,	reg_MATNR_AlphaHP_LUT_9	    Matnr high-pass filter alpha LUT node 9
//    //Bit  7: 0,	reg_MATNR_AlphaHP_LUT_8	    Matnr high-pass filter alpha LUT node 8
//    `define NR2_MATNR_ALPHAHP_LUT3      8'h76
//    //Bit 31:24,	reg_MATNR_AlphaHP_LUT_15	Matnr high-pass filter alpha LUT node 15
//    //Bit 23:16,	reg_MATNR_AlphaHP_LUT_14	Matnr high-pass filter alpha LUT node 14
//    //Bit 15: 8,	reg_MATNR_AlphaHP_LUT_13	Matnr high-pass filter alpha LUT node 13
//    //Bit  7: 0,	reg_MATNR_AlphaHP_LUT_12	Matnr high-pass filter alpha LUT node 12
//
//    `define NR2_MATNR_MTNB_BRT          8'h77
//    //Bit 31:28,	reg_MATNR_mtnb_BRT_limt_hi	Motion adjustment based on Brightness high side Limit. (X16 to u8 scale)
//    //Bit 27:24,	reg_MATNR_mtnb_BRT_slop_hi	Motion adjustment based on Brightness high side slope. Normalized to 16 as 1
//    //Bit 23:16,	reg_MATNR_mtnb_BRT_thrd_hi	Motion adjustment based on Brightness high threshold.(u8 scale)
//    //Bit 15:12,	reg_MATNR_mtnb_BRT_limt_lo	Motion adjustment based on Brightness low side Limit. (X16 to u8 scale)
//    //Bit 11: 8,	reg_MATNR_mtnb_BRT_slop_lo	Motion adjustment based on Brightness low side slope. Normalized to 16 as 1
//    //Bit  7: 0,	reg_MATNR_mtnb_BRT_thrd_lo	Motion adjustment based on Brightness low threshold.(u8 scale)
// 0x51 - 0x69 | 0x4e | 0x6a - 0x77
//
// Reading file:  nr2_regs.h
//
// synopsys translate_off
// synopsys translate_on
//========== nr2_snr_regs register begin ==========//
#define NR2_SNR_SAD_CFG                            ((0x1751  << 2) + 0xff900000)
//Bit 31:13        reserved
//Bit 12           reg_matnr_snr_sad_cenrpl       // unsigned , default = 1
//Bit 11: 8        reg_matnr_snr_sad_coring       // unsigned , default = 3
//Bit  7            reserved
//Bit  6: 5        reg_matnr_snr_sad_winmod       // unsigned , default = 1     0: 1x1; 1: [1 1 1] 2: [1 2 1]; 3: [1 2 2 2 1];
//Bit  4: 0        sad_coef_num                      // unsigned , default = 1     0: 1x1; 1: [1 1 1] 2: [1 2 1]; 3: [1 2 2 2 1];
#define NR2_MATNR_SNR_OS                           ((0x1752  << 2) + 0xff900000)
//Bit 31: 8        reserved
//Bit  7: 4        reg_matnr_snr_cos              // unsigned , default = 8
//Bit  3: 0        reg_matnr_snr_yos              // unsigned , default = 13
#define NR2_MATNR_SNR_NRM_CFG                      ((0x1753  << 2) + 0xff900000)
//Bit 31:24        reserved
//Bit 23:16        reg_matnr_snr_nrm_ofst         // signed , default = 64
//Bit 15: 8        reg_matnr_snr_nrm_max          // unsigned , default = 255
//Bit  7: 0        reg_matnr_snr_nrm_min          // unsigned , default = 0
#define NR2_MATNR_SNR_NRM_GAIN                     ((0x1754  << 2) + 0xff900000)
//Bit 31:16        reserved
//Bit 15: 8        reg_matnr_snr_nrm_cgain        // unsigned , default = 0     norm 32
//Bit  7: 0        reg_matnr_snr_nrm_ygain        // unsigned , default = 32    norm 32
#define NR2_MATNR_SNR_LPF_CFG                      ((0x1755  << 2) + 0xff900000)
//Bit 31:24        reserved
//Bit 23:16        reg_matnr_snrlpf_sadmaxth      // unsigned , default = 12
//Bit 15:14        reserved
//Bit 13:11        reg_matnr_snrlpf_cmode         // unsigned , default = 2     0: gradient LPF [1 1]/2, 1: gradient LPF [2 1 1]/4; 2: gradient LPF [3 3 2]/8; 3: gradient LPF [5 5 4 3]/16;
//Bit 10: 8        reg_matnr_snrlpf_ymode         // unsigned , default = 2     0: gradient LPF [1 1]/2, 1: gradient LPF [2 1 1]/4; 2: gradient LPF [3 3 2]/8; 3: gradient LPF [5 5 4 3]/16;
//Bit  7: 4        reg_matnr_snrlpf_sadmin3th     // unsigned , default = 6     X8
//Bit  3: 0        reg_matnr_snrlpf_sadmin2th     // unsigned , default = 4     X8
#define NR2_MATNR_SNR_USF_GAIN                     ((0x1756  << 2) + 0xff900000)
//Bit 31:16        reserved
//Bit 15: 8        reg_matnr_snr_usf_cgain        // unsigned , default = 0     norm 64
//Bit  7: 0        reg_matnr_snr_usf_ygain        // unsigned , default = 0     norm 64
#define NR2_MATNR_SNR_EDGE2B                       ((0x1757  << 2) + 0xff900000)
//Bit 31:16        reserved
//Bit 15: 8        reg_matnr_snr_edge2beta_ofst   // unsigned , default = 128
//Bit  7: 0        reg_matnr_snr_edge2beta_gain   // unsigned , default = 16
#define NR2_MATNR_BETA_EGAIN                       ((0x1758  << 2) + 0xff900000)
//Bit 31:16        reserved
//Bit 15: 8        reg_matnr_cbeta_egain          // unsigned , default = 32    normalized to 32
//Bit  7: 0        reg_matnr_ybeta_egain          // unsigned , default = 32    normalized to 32
#define NR2_MATNR_BETA_BRT                         ((0x1759  << 2) + 0xff900000)
//Bit 31:28        reg_matnr_beta_brt_limt_hi     // unsigned , default = 0
//Bit 27:24        reg_matnr_beta_brt_slop_hi     // unsigned , default = 0
//Bit 23:16        reg_matnr_beta_brt_thrd_hi     // unsigned , default = 160
//Bit 15:12        reg_matnr_beta_brt_limt_lo     // unsigned , default = 6
//Bit 11: 8        reg_matnr_beta_brt_slop_lo     // unsigned , default = 6
//Bit  7: 0        reg_matnr_beta_brt_thrd_lo     // unsigned , default = 100
#define NR2_MATNR_XBETA_CFG                        ((0x175a  << 2) + 0xff900000)
//Bit 31:20        reserved
//Bit 19:18        reg_matnr_cbeta_use_mode       // unsigned , default = 0     0: beta_motion; 1: beta_edge; 2: min(beta_mot,beta_edge); 3: (beta_mot + beta_edge)/2
//Bit 17:16        reg_matnr_ybeta_use_mode       // unsigned , default = 0     0: beta_motion; 1: beta_edge; 2: min(beta_mot,beta_edge); 3: (beta_mot + beta_edge)/2;
//Bit 15: 8        reg_matnr_cbeta_ofst           // unsigned , default = 0
//Bit  7: 0        reg_matnr_ybeta_ofst           // unsigned , default = 0
#define NR2_MATNR_YBETA_SCL                        ((0x175b  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_ybeta_scale_min      // unsigned , default = 60
//Bit 23:16        reg_matnr_ybeta_scale_max      // unsigned , default = 255
//Bit 15: 8        reg_matnr_ybeta_scale_gain     // unsigned , default = 32    normalized 32 to 1.0
//Bit  7: 0        reg_matnr_ybeta_scale_ofst     // signed , default = 0
#define NR2_MATNR_CBETA_SCL                        ((0x175c  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_cbeta_scale_min      // unsigned , default = 0
//Bit 23:16        reg_matnr_cbeta_scale_max      // unsigned , default = 255
//Bit 15: 8        reg_matnr_cbeta_scale_gain     // unsigned , default = 32    normalized 32 to 1.0
//Bit  7: 0        reg_matnr_cbeta_scale_ofst     // signed , default = 0
#define NR2_SNR_MASK                               ((0x175d  << 2) + 0xff900000)
//Bit 31:21        reserved
//Bit 20: 0        sad_msk                        // unsigned , default = 0x0f9f3e
#define NR2_SAD2NORM_LUT0                          ((0x175e  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_sad2norm_lut3      // unsigned , default = 114
//Bit 23:16        reg_matnr_sad2norm_lut2      // unsigned , default = 146
//Bit 15: 8        reg_matnr_sad2norm_lut1      // unsigned , default = 171
//Bit  7: 0        reg_matnr_sad2norm_lut0      // unsigned , default = 205
#define NR2_SAD2NORM_LUT1                          ((0x175f  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_sad2norm_lut7      // unsigned , default = 28
//Bit 23:16        reg_matnr_sad2norm_lut6      // unsigned , default = 35
//Bit 15: 8        reg_matnr_sad2norm_lut5      // unsigned , default = 49
//Bit  7: 0        reg_matnr_sad2norm_lut4      // unsigned , default = 79
#define NR2_SAD2NORM_LUT2                          ((0x1760  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_sad2norm_lut11     // unsigned , default = 15
//Bit 23:16        reg_matnr_sad2norm_lut10     // unsigned , default = 17
//Bit 15: 8        reg_matnr_sad2norm_lut9      // unsigned , default = 19
//Bit  7: 0        reg_matnr_sad2norm_lut8      // unsigned , default = 23
#define NR2_SAD2NORM_LUT3                          ((0x1761  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_sad2norm_lut15     // unsigned , default = 8
//Bit 23:16        reg_matnr_sad2norm_lut14     // unsigned , default = 9
//Bit 15: 8        reg_matnr_sad2norm_lut13     // unsigned , default = 10
//Bit  7: 0        reg_matnr_sad2norm_lut12     // unsigned , default = 12
#define NR2_EDGE2BETA_LUT0                         ((0x1762  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_edge2beta_lut3    // unsigned , default = 128
//Bit 23:16        reg_matnr_edge2beta_lut2    // unsigned , default = 160
//Bit 15: 8        reg_matnr_edge2beta_lut1    // unsigned , default = 224
//Bit  7: 0        reg_matnr_edge2beta_lut0    // unsigned , default = 255
#define NR2_EDGE2BETA_LUT1                         ((0x1763  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_edge2beta_lut7    // unsigned , default = 4
//Bit 23:16        reg_matnr_edge2beta_lut6    // unsigned , default = 16
//Bit 15: 8        reg_matnr_edge2beta_lut5    // unsigned , default = 32
//Bit  7: 0        reg_matnr_edge2beta_lut4    // unsigned , default = 80
#define NR2_EDGE2BETA_LUT2                         ((0x1764  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_edge2beta_lut11    // unsigned , default = 0
//Bit 23:16        reg_matnr_edge2beta_lut10    // unsigned , default = 0
//Bit 15: 8        reg_matnr_edge2beta_lut9    // unsigned , default = 0
//Bit  7: 0        reg_matnr_edge2beta_lut8    // unsigned , default = 2
#define NR2_EDGE2BETA_LUT3                         ((0x1765  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_edge2beta_lut15    // unsigned , default = 0
//Bit 23:16        reg_matnr_edge2beta_lut14    // unsigned , default = 0
//Bit 15: 8        reg_matnr_edge2beta_lut13    // unsigned , default = 0
//Bit  7: 0        reg_matnr_edge2beta_lut12    // unsigned , default = 0
#define NR2_MOTION2BETA_LUT0                       ((0x1766  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_mot2beta_lut3     // unsigned , default = 32
//Bit 23:16        reg_matnr_mot2beta_lut2     // unsigned , default = 16
//Bit 15: 8        reg_matnr_mot2beta_lut1     // unsigned , default = 4
//Bit  7: 0        reg_matnr_mot2beta_lut0     // unsigned , default = 0
#define NR2_MOTION2BETA_LUT1                       ((0x1767  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_mot2beta_lut7     // unsigned , default = 196
//Bit 23:16        reg_matnr_mot2beta_lut6     // unsigned , default = 128
//Bit 15: 8        reg_matnr_mot2beta_lut5     // unsigned , default = 64
//Bit  7: 0        reg_matnr_mot2beta_lut4     // unsigned , default = 48
#define NR2_MOTION2BETA_LUT2                       ((0x1768  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_mot2beta_lut11     // unsigned , default = 255
//Bit 23:16        reg_matnr_mot2beta_lut10     // unsigned , default = 255
//Bit 15: 8        reg_matnr_mot2beta_lut9     // unsigned , default = 240
//Bit  7: 0        reg_matnr_mot2beta_lut8     // unsigned , default = 224
#define NR2_MOTION2BETA_LUT3                       ((0x1769  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_mot2beta_lut15     // unsigned , default = 255
//Bit 23:16        reg_matnr_mot2beta_lut14     // unsigned , default = 255
//Bit 15: 8        reg_matnr_mot2beta_lut13     // unsigned , default = 255
//Bit  7: 0        reg_matnr_mot2beta_lut12     // unsigned , default = 255
//========== nr2_snr_regs register end ==========//
//========== nr2_tnr_regs register begin ==========//
#define NR2_IIR_CTRL                               ((0x174e  << 2) + 0xff900000)
//Bit 31:16        reserved
//Bit 15:14        reg_lp_iir_8bit_mode      // unsigned , default = 0  10bits; 1: 9bits; 2: 8bits 3: 7bits
//Bit 13:12        reg_hp_iir_mute_mode      // unsigned , default = 0
//Bit 11: 8        reg_hp_iir_mute_thrd      // unsigned , default = 0
//Bit  7: 6        reg_hp_iir_8bit_mode      // unsigned , default = 0
//Bit  5: 4        reg_lp_iir_mute_mode      // unsigned , default = 0
//Bit  3: 0        reg_lp_iir_mute_thrd      // unsigned , default = 0
#define NR2_MATNR_MTN_CRTL                         ((0x176a  << 2) + 0xff900000)
//Bit 31:20        reserved
//Bit 19:18        reg_matnr_vmtn_use_mode   // unsigned , default = 0  0- Vmot, 1- Ymot/2 + (Umot+Vmot)/4; 2- Ymot/2 + max(Umot,Vmot)/2; 3- max(Ymot,Umot, Vmot)
//Bit 17:16        reg_matnr_umtn_use_mode   // unsigned , default = 0  0- Umot, 1- Ymot/2 + (Umot+Vmot)/4; 2- Ymot/2 + max(Umot,Vmot)/2; 3- max(Ymot,Umot, Vmot)
//Bit 15:14        reg_matnr_ymtn_use_mode   // unsigned , default = 0  0- Ymot, 1- Ymot/2 + (Umot+Vmot)/4; 2- Ymot/2 + max(Umot,Vmot)/2; 3- max(Ymot,Umot, Vmot)
//Bit 13:12        reg_matnr_mtn_txt_mode    // unsigned , default = 1
//Bit 11            reserved
//Bit 10: 8        reg_matnr_mtn_cor_mode    // unsigned , default = 1  changes)
//Bit  7: 4        reg_matnr_mtn_hpf_mode    // unsigned , default = 8  extend to u4 for nr4, 0- 1x1; 1: 1x3; 2: 1x5; 3: 3x3; 4: 3o3; 5: 3x5, 6:3x3 SAD, 7: 5x3 SAD, 8-15: drt adaptive
//Bit  3            reserved
//Bit  2: 0        reg_matnr_mtn_lpf_mode    // unsigned , default = 6  0- 1x1; 1: 1x3; 2: 1x5; 3: 3x3; 4: 3o3; 5: 3x5, 6,7: drt adaptive
#define NR2_MATNR_MTN_CRTL2                        ((0x176b  << 2) + 0xff900000)
//Bit 31:19        reserved
//Bit 18:16        reg_matnr_iir_bs_ymode      // unsigned , default = 6  LPF~~ 0- 1x1; 1: 1x3; 2: 1x5; 3: 3x3; 4: 3o3; 5: 3x5; 6/7: 0
//Bit 15: 8        reg_matnr_mtnb_alplp_cgain  // unsigned , default = 64  to 32
//Bit  7: 0        reg_matnr_mtnb_alplp_ygain  // unsigned , default = 64  to 32
#define NR2_MATNR_MTN_COR                          ((0x176c  << 2) + 0xff900000)
//Bit 31:16        reserved
//Bit 15:12        reg_matnr_mtn_cor_cofst   // unsigned , default = 3  Offset for Chroma Motion.
//Bit 11: 8        reg_matnr_mtn_cor_cgain   // unsigned , default = 3  to texture based coring for Chroma Motion. Normalized to 16 as 1
//Bit  7: 4        reg_matnr_mtn_cor_yofst   // unsigned , default = 3  Offset for Luma Motion.
//Bit  3: 0        reg_matnr_mtn_cor_ygain   // unsigned , default = 3  to texture based coring for Luma Motion. Normalized to 16 as 1
#define NR2_MATNR_MTN_GAIN                         ((0x176d  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_mtn_hp_cgain    // unsigned , default = 64  to MotHPF_yuv[k] Chrm channel for motion calculation, normalized to 64 as 1
//Bit 23:16        reg_matnr_mtn_hp_ygain    // unsigned , default = 64  to MotHPF_yuv[k] Luma channel for motion calculation, normalized to 64 as 1
//Bit 15: 8        reg_matnr_mtn_lp_cgain    // unsigned , default = 64  to MotLPF_yuv[k] Chrm channel for motion calculation, normalized to 32 as 1
//Bit  7: 0        reg_matnr_mtn_lp_ygain    // unsigned , default = 64  to MotLPF_yuv[k] Luma channel for motion calculation, normalized to 32 as 1
#define NR2_MATNR_DEGHOST                          ((0x176e  << 2) + 0xff900000)
//Bit 31            reserved
//Bit 30:28        reg_matnr_deghost_mode    // unsigned , default = 0  0:old_deghost; 1:soft_denoise & strong_deghost; 2:strong_denoise & soft_deghost; 3:strong_denoise & strong_deghost
//Bit 27:25        reserved
//Bit 24:20        reg_matnr_deghost_ygain   // unsigned , default = 4
//Bit 19:17        reserved
//Bit 16:12        reg_matnr_deghost_cgain   // unsigned , default = 4
//Bit 11: 9        reserved
//Bit  8           reg_matnr_deghost_en      // unsigned , default = 1  0: disable; 1: enable Enable signal for DeGhost function:0: disable; 1: enable
//Bit  7: 4        reg_matnr_deghost_cos     // unsigned , default = 3  DeGhost Overshoot margin for UV channel, (X2 to u10 scale)
//Bit  3: 0        reg_matnr_deghost_yos     // unsigned , default = 3  DeGhost Overshoot margin for Luma channel, (X2 to u10 scale)
#define NR2_MATNR_ALPHALP_LUT0                     ((0x176f  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_alphalp_lut3    // unsigned , default = 64  low-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphalp_lut2    // unsigned , default = 128  low-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphalp_lut1    // unsigned , default = 128  low-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphalp_lut0    // unsigned , default = 128  low-pass filter alpha LUT
#define NR2_MATNR_ALPHALP_LUT1                     ((0x1770  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_alphalp_lut7    // unsigned , default = 255  low-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphalp_lut6    // unsigned , default = 128  low-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphalp_lut5    // unsigned , default = 80  low-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphalp_lut4    // unsigned , default = 64  low-pass filter alpha LUT
#define NR2_MATNR_ALPHALP_LUT2                     ((0x1771  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_alphalp_lut11   // unsigned , default = 255  low-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphalp_lut10   // unsigned , default = 255  low-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphalp_lut9    // unsigned , default = 255  low-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphalp_lut8    // unsigned , default = 255  low-pass filter alpha LUT
#define NR2_MATNR_ALPHALP_LUT3                     ((0x1772  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_alphalp_lut15   // unsigned , default = 255  low-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphalp_lut14   // unsigned , default = 255  low-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphalp_lut13   // unsigned , default = 255  low-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphalp_lut12   // unsigned , default = 255  low-pass filter alpha LUT
#define NR2_MATNR_ALPHAHP_LUT0                     ((0x1773  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_alphahp_lut3    // unsigned , default = 64  high-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphahp_lut2    // unsigned , default = 128  high-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphahp_lut1    // unsigned , default = 128  high-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphahp_lut0    // unsigned , default = 128  high-pass filter alpha LUT
#define NR2_MATNR_ALPHAHP_LUT1                     ((0x1774  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_alphahp_lut7    // unsigned , default = 255  high-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphahp_lut6    // unsigned , default = 128  high-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphahp_lut5    // unsigned , default = 80  high-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphahp_lut4    // unsigned , default = 64  high-pass filter alpha LUT
#define NR2_MATNR_ALPHAHP_LUT2                     ((0x1775  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_alphahp_lut11   // unsigned , default = 255  high-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphahp_lut10   // unsigned , default = 255  high-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphahp_lut9    // unsigned , default = 255  high-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphahp_lut8    // unsigned , default = 255  high-pass filter alpha LUT
#define NR2_MATNR_ALPHAHP_LUT3                     ((0x1776  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_alphahp_lut15   // unsigned , default = 255  high-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphahp_lut14   // unsigned , default = 255  high-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphahp_lut13   // unsigned , default = 255  high-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphahp_lut12   // unsigned , default = 255  high-pass filter alpha LUT
#define NR2_MATNR_MTNB_BRT                         ((0x1777  << 2) + 0xff900000)
//Bit 31:28        reg_matnr_mtnb_brt_limt_hi  // unsigned , default = 0
//Bit 27:24        reg_matnr_mtnb_brt_slop_hi  // unsigned , default = 0
//Bit 23:16        reg_matnr_mtnb_brt_thrd_hi  // unsigned , default = 160
//Bit 15:12        reg_matnr_mtnb_brt_limt_lo  // unsigned , default = 6
//Bit 11: 8        reg_matnr_mtnb_brt_slop_lo  // unsigned , default = 6
//Bit  7: 0        reg_matnr_mtnb_brt_thrd_lo  // unsigned , default = 100
//========== nr2_tnr_regs register end ==========//
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  nr2_regs.h
//
#define DI_EI_DRT_CTRL                             ((0x1778  << 2) + 0xff900000)
//Bit 31,     reg_rectg_en      ;u1
//Bit 30,     reg_recbld_en     ;u1
//Bit 29:28,  reg_rectg_ws      ;u2
//Bit 27,     reserved
//Bit 26:24,  reg_abq_margin    ;u3
//Bit 23,     reserved
//Bit 22:20,  reg_trend_mg      ;u3
//Bit 19:16,  reg_int_d16xc1    ;u4
//Bit 15:14,  reserved
//Bit 13: 8,  reg_int_chlmt1    ;u6
//Bit  7,     reserved
//Bit  6: 4,  reg_nscheck_thrd  ;u3
//Bit  3,     reserved
//Bit  2: 0,  reg_horsl_ws      ;u3
#define DI_EI_DRT_PIXTH                            ((0x1779  << 2) + 0xff900000)
//Bit 31:24,  reg_min_pix        ;u8
//Bit 23:16,  reg_max_pix        ;u8
//Bit 15: 8,  reg_dmaxmin_thrdma ;u8
//Bit  7: 0,  reg_dmaxmin_thrdmi ;u8
#define DI_EI_DRT_CORRPIXTH                        ((0x177a  << 2) + 0xff900000)
//Bit 31:24,  reg_newcorrpix_maxthrd ;u8
//Bit 23:16,  reg_corrpix_diffthrd   ;u8
//Bit 15: 8,  reg_corrpix_minthrd    ;u8
//Bit  7: 0,  reg_corrpix_maxthrd    ;u8
#define DI_EI_DRT_RECTG_WAVE                       ((0x177b  << 2) + 0xff900000)
//Bit 31:29,  reserved
//Bit 28:24,  reg_max_pixwave  ;u5
//Bit 23:21,  reserved
//Bit 20:16,  reg_pix_wave     ;u5
//Bit 15:14,  reserved
//Bit 13: 8,  reg_maxdrt_thrd  ;u6
//Bit  7: 0,  reg_wave_thrd    ;u8
#define DI_EI_DRT_PIX_DIFFTH                       ((0x177c  << 2) + 0xff900000)
//Bit 31:24,  reg_newraw_thrd    ;u8
//Bit 23:16,  reg_tb_max_thrd    ;u8
//Bit 15: 8,  reg_diffpix_thrd   ;u8
//Bit  7: 6,  reserved
//Bit  5: 0,  reg_bilt_trendnumt ;u8
#define DI_EI_DRT_UNBITREND_TH                     ((0x177d  << 2) + 0xff900000)
//Bit 31:29,  reserved
//Bit 28:24,  reg_trend_numb     ;u5
//Bit 23:21,  reserved
//Bit 20:16,  reg_bilt_trendnum  ;u5
//Bit 15:13,  reserved
//Bit 12: 8,  reg_unil_trendnumt ;u5
//Bit  7: 5,  reserved
//Bit  4: 0,  reg_trend_num      ;u5
#define NR2_CONV_MODE                              ((0x177f  << 2) + 0xff900000)
//Bit 3:2,	Conv_c444_mode	The format convert mode about 422 to 444 when data read out line buffer
//Bit 1:0,	Conv_c422_mode	the format convert mode about 444 to 422 when data write to line buffer
//// NR2 REG DEFINE END ////
//// DET 3D REG DEFINE BEGIN ////
//// 8'h34~8'h3f | 8'h80~8'h8f | 0x9a-0x9b
//
// Reading file:  det3d_regs.h
//
//// DET 3D REG DEFINE BEGIN ////
//// 8'h34~8'h3f
//// DET 3D REG DEFINE END ////
#define DET3D_MOTN_CFG                             ((0x1734  << 2) + 0xff900000)
//Bit 16,	reg_det3d_intr_en	        Det3d interrupt enable
//Bit 9:8,	reg_Det3D_Motion_Mode	    U2  Different mode for Motion Calculation of Luma and Chroma:
//                                      0: MotY, 1: (2*MotY + (MotU + MotV))/4; 2: Max(MotY, MotU,MotV); 3:Max(MotY, (MotU+MotV)/2)
//Bit 7:4,	reg_Det3D_Motion_Core_Rate	U4  K Rate to Edge (HV) details for coring of Motion Calculations, normalized to 32
//Bit 3:0,	reg_Det3D_Motion_Core_Thrd	U4  2X: static coring value for Motion Detection.
#define DET3D_CB_CFG                               ((0x1735  << 2) + 0xff900000)
//Bit 7:4,	reg_Det3D_ChessBd_HV_ofst	U4,  Noise immune offset for Horizontal or vertical combing detection.
//Bit 3:0,	reg_Det3D_ChessBd_NHV_ofst	U4,  Noise immune offset for NON-Horizontal or vertical combing detection.
#define DET3D_SPLT_CFG                             ((0x1736  << 2) + 0xff900000)
//Bit 7:4,	reg_Det3D_SplitValid_ratio	U4,  Ratio between max_value and the avg_value of the edge mapping for split line valid detection.
//                                      The smaller of this value, the easier of the split line detected.
//Bit 3:0,	reg_Det3D_AvgIdx_ratio	    U4,  Ratio to the avg_value of the edge mapping for split line position estimation.
//                                      The smaller of this value, the more samples will be added to the estimation.
#define DET3D_HV_MUTE                              ((0x1737  << 2) + 0xff900000)
//Bit 23:20, reg_Det3D_Edge_Ver_Mute	U4  X2: Horizontal pixels to be mute from H/V Edge calculation Top and Bottom border part.
//Bit 19:16, reg_Det3D_Edge_Hor_Mute	U4  X2: Horizontal pixels to be mute from H/V Edge calculation Left and right border part.
//Bit 15:12, reg_Det3D_ChessBd_Ver_Mute	U4  X2: Horizontal pixels to be mute from ChessBoard statistics calculation in middle part
//Bit 11:8,	 reg_Det3D_ChessBd_Hor_Mute	U4  X2: Horizontal pixels to be mute from ChessBoard statistics calculation in middle part
//Bit 7:4,	 reg_Det3D_STA8X8_Ver_Mute	U4  1X: Vertical pixels to be mute from 8x8 statistics calculation in each block.
//Bit 3:0,	 reg_Det3D_STA8X8_Hor_Mute	U4  1X: Horizontal pixels to be mute from 8x8 statistics calculation in each block.
#define DET3D_MAT_STA_P1M1                         ((0x1738  << 2) + 0xff900000)
//Bit 31:24, reg_Det3D_STA8X8_P1_K0_R8	U8  SAD to SAI ratio to decide P1, normalized to 256 (0.8)
//Bit 23:16, reg_Det3D_STA8X8_P1_K1_R7	U8  SAD to ENG ratio to decide P1, normalized to 128 (0.5)
//Bit 15:8,	 reg_Det3D_STA8X8_M1_K0_R6	U8  SAD to SAI ratio to decide M1, normalized to 64  (1.1)
//Bit 7:0,	 reg_Det3D_STA8X8_M1_K1_R6	U8  SAD to ENG ratio to decide M1, normalized to 64  (0.8)
#define DET3D_MAT_STA_P1TH                         ((0x1739  << 2) + 0xff900000)
//Bit 23:16, reg_Det3D_STAYUV_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16         (100)
//Bit 15:8,	 reg_Det3D_STAEDG_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16         (80)
//Bit 7:0,	 reg_Det3D_STAMOT_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16         (48)
#define DET3D_MAT_STA_M1TH                         ((0x173a  << 2) + 0xff900000)
//Bit 23:16, reg_Det3D_STAYUV_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16         (100)
//Bit 15:8,	 reg_Det3D_STAEDG_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16         (80)
//Bit 7:0,	 reg_Det3D_STAMOT_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16         (64)
#define DET3D_MAT_STA_RSFT                         ((0x173b  << 2) + 0xff900000)
//Bit 5:4,	 reg_Det3D_STAYUV_RSHFT	    U2  YUV statistics SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//Bit 3:2,	 reg_Det3D_STAEDG_RSHFT	    U2  Horizontal and Vertical Edge Statistics SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//Bit 1:0,	 reg_Det3D_STAMOT_RSHFT	    U2  Motion SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
#define DET3D_MAT_SYMTC_TH                         ((0x173c  << 2) + 0xff900000)
//Bit 31:24, reg_Det3D_STALUM_symtc_Th	  U8  threshold to decide if the Luma statistics is TB or LR symmetric.
//Bit 23:16, reg_Det3D_STACHR_symtc_Th	  U8  threshold to decide if the Chroma (UV) statistics is TB or LR symmetric.
//Bit 15:8,	 reg_Det3D_STAEDG_symtc_Th	  U8  threshold to decide if the Horizontal and Vertical Edge statistics is TB or LR symmetric.
//Bit 7:0,	 reg_Det3D_STAMOT_symtc_Th	  U8  threshold to decide if the Motion statistics is TB or LR symmetric.
#define DET3D_RO_DET_CB_HOR                        ((0x173d  << 2) + 0xff900000)
//Bit 31:16, RO_Det3D_ChessBd_NHor_value    U16  X64: number of Pixels of Horizontally Surely NOT matching Chessboard pattern.
//Bit 15:0,	 RO_Det3D_ChessBd_Hor_value	    U16  X64: number of Pixels of Horizontally Surely matching Chessboard pattern.
#define DET3D_RO_DET_CB_VER                        ((0x173e  << 2) + 0xff900000)
//Bit 31:16, RO_Det3D_ChessBd_NVer_value	U16  X64: number of Pixels of Vertically Surely NOT matching Chessboard pattern.
//Bit 15:0,	 RO_Det3D_ChessBd_Ver_value	    U16  X64: number of Pixels of Vertically Surely matching Chessboard pattern.
#define DET3D_RO_SPLT_HT                           ((0x173f  << 2) + 0xff900000)
//Bit 24,	 RO_Det3D_Split_HT_valid	U1  horizontal LR split border detected valid signal for top half picture
//Bit 20:16, RO_Det3D_Split_HT_pxnum	U5  number of pixels included for the LR split position estimation for top half picture
//Bit 9:0,	 RO_Det3D_Split_HT_idxX4	S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
//// DET 3D REG DEFINE BEGIN ////
////  8'h80~8'h8f
#define DET3D_RO_SPLT_HB                           ((0x1780  << 2) + 0xff900000)
//Bit 24,	    RO_Det3D_Split_HB_valid	    U1   horizontal LR split border detected valid signal for top half picture
//Bit 20:16,	RO_Det3D_Split_HB_pxnum	    U5   number of pixels included for the LR split position estimation for top half picture
//Bit  9: 0,	RO_Det3D_Split_HB_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
#define DET3D_RO_SPLT_VL                           ((0x1781  << 2) + 0xff900000)
//Bit 24,	    RO_Det3D_Split_VL_valid	    U1   horizontal LR split border detected valid signal for top half picture
//Bit 20:16,	RO_Det3D_Split_VL_pxnum	    U5   number of pixels included for the LR split position estimation for top half picture
//Bit  9: 0,	RO_Det3D_Split_VL_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
#define DET3D_RO_SPLT_VR                           ((0x1782  << 2) + 0xff900000)
//Bit 24   ,	RO_Det3D_Split_VR_valid	    U1   horizontal LR split border detected valid signal for top half picture
//Bit 20:16,	RO_Det3D_Split_VR_pxnum	    U5   number of pixels included for the LR split position estimation for top half picture
//Bit  9: 0,	RO_Det3D_Split_VR_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
#define DET3D_RO_MAT_LUMA_LR                       ((0x1783  << 2) + 0xff900000)
//Bit 15:0,	RO_Luma_LR_score	 S2*8  LUMA statistics left right decision score for each band (8bands vertically),
//                               it can be -1/0/1:-1: most likely not LR symmetric 0: not sure 1: most likely LR symmetric
//Bit 7:0,	RO_Luma_LR_symtc	 U1*8  Luma statistics left right pure symmetric for each band (8bands vertically),
//                               it can be 0/1: 0: not sure 1: most likely LR is pure symmetric
//Bit 4:0,	RO_Luma_LR_sum	     S5  Total score of 8x8 Luma statistics for LR like decision,
//                               the larger this score, the more confidence that this is a LR 3D video. It is sum of  RO_Luma_LR_score[0~7]
#define DET3D_RO_MAT_LUMA_TB                       ((0x1784  << 2) + 0xff900000)
//Bit 15:0,	RO_Luma_TB_score	 S2*8  LUMA statistics Top/Bottom decision score for each band (8bands Horizontally),
//Bit 7:0,	RO_Luma_TB_symtc	 Luma statistics Top/Bottompure symmetric for each band (8bands Horizontally),
//Bit 4:0,	RO_Luma_TB_sum	     Total score of 8x8 Luma statistics for TB like decision,
#define DET3D_RO_MAT_CHRU_LR                       ((0x1785  << 2) + 0xff900000)
//Bit 15:0,	RO_ChrU_LR_score	S2*8  LUMA statistics left right decision score for each band (8bands vertically),
//Bit 7:0,	RO_ChrU_LR_symtc	CHRU statistics left right pure symmetric for each band (8bands vertically),
//Bit 4:0,	RO_ChrU_LR_sum	    Total score of 8x8 ChrU statistics for LR like decision,
#define DET3D_RO_MAT_CHRU_TB                       ((0x1786  << 2) + 0xff900000)
//Bit 15:0,	RO_ChrU_TB_score	S2*8  CHRU statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,	RO_ChrU_TB_symtc	CHRU statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,	RO_ChrU_TB_sum	    Total score of 8x8 ChrU statistics for TB like decision
#define DET3D_RO_MAT_CHRV_LR                       ((0x1787  << 2) + 0xff900000)
//Bit 15:0,	RO_ChrV_LR_score	S2*8  CHRUstatistics left right decision score for each band (8bands vertically)
//Bit 7:0,	RO_ChrV_LR_symtc	CHRV statistics left right pure symmetric for each band (8bands vertically)
//Bit 4:0,	RO_ChrV_LR_sum	    Total score of 8x8 ChrV statistics for LR like decision
#define DET3D_RO_MAT_CHRV_TB                       ((0x1788  << 2) + 0xff900000)
//Bit 15:0,	RO_ChrV_TB_score	CHRV statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,	RO_ChrV_TB_symtc	CHRV statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,	RO_ChrV_TB_sum	    Total score of 8x8 ChrV statistics for TB like decision
#define DET3D_RO_MAT_HEDG_LR                       ((0x1789  << 2) + 0xff900000)
//Bit 15:0,	RO_Hedg_LR_score	Horizontal Edge statistics left right decision score for each band (8bands vertically)
//Bit 7:0,	RO_Hedg_LR_symtc	Horizontal Edge statistics left right pure symmetric for each band (8bands vertically)
//Bit 4:0,	RO_Hedg_LR_sum	    Total score of 8x8 Hedg statistics for LR like decision
#define DET3D_RO_MAT_HEDG_TB                       ((0x178a  << 2) + 0xff900000)
//Bit 15:0,	RO_Hedg_TB_score	Horizontal Edge statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,	RO_Hedg_TB_symtc	Horizontal Edge statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,	RO_Hedg_TB_sum	    Total score of 8x8 Hedg statistics for TB like decision
#define DET3D_RO_MAT_VEDG_LR                       ((0x178b  << 2) + 0xff900000)
//Bit 15:0,	RO_Vedg_LR_score	Vertical Edge statistics left right decision score for each band (8bands vertically)
//Bit 7:0,	RO_Vedg_LR_symtc	Vertical Edge statistics left right pure symmetric for each band (8bands vertically)
//Bit 4:0,	RO_Vedg_LR_sum	    Total score of 8x8 Vedg statistics for LR like decision
#define DET3D_RO_MAT_VEDG_TB                       ((0x178c  << 2) + 0xff900000)
//Bit 15:0,	RO_Vedg_TB_score	Vertical Edge statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,	RO_Vedg_TB_symtc	Vertical Edge statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,	RO_Vedg_TB_sum	    Total score of 8x8 Vedg statistics for TB like decision
#define DET3D_RO_MAT_MOTN_LR                       ((0x178d  << 2) + 0xff900000)
//Bit 15:0,	RO_Motn_LR_score	Motion statistics left right decision score for each band (8bands vertically)
//Bit 7:0,	RO_Motn_LR_symtc	Motion statistics left right pure symmetric for each band (8bands vertically)
//Bit 4:0,	RO_Motn_LR_sum	    Total score of 8x8 Motion statistics for LR like decision
#define DET3D_RO_MAT_MOTN_TB                       ((0x178e  << 2) + 0xff900000)
//Bit 15:0,	RO_Motn_TB_score	Motion statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,	RO_Motn_TB_symtc	Motion statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,	RO_Motn_TB_sum	    Total score of 8x8 Motion statistics for TB like decision
#define DET3D_RO_FRM_MOTN                          ((0x178f  << 2) + 0xff900000)
//Bit 15:0,	RO_Det3D_Frame_Motion	U16  frame based motion value sum for still image decision in FW.
/// mat ram read enter addr
#define DET3D_RAMRD_ADDR_PORT                      ((0x179a  << 2) + 0xff900000)
#define DET3D_RAMRD_DATA_PORT                      ((0x179b  << 2) + 0xff900000)
//
// Closing file:  det3d_regs.h
//
//   `define DET3D_RO_SPLT_HB            8'h80
//   //Bit 24,	    RO_Det3D_Split_HB_valid	    U1   horizontal LR split border detected valid signal for top half picture
//   //Bit 20:16,	RO_Det3D_Split_HB_pxnum	    U5   number of pixels included for the LR split position estimation for top half picture
//   //Bit  9: 0,	RO_Det3D_Split_HB_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
//   `define DET3D_RO_SPLT_VL            8'h81
//   //Bit 24,	    RO_Det3D_Split_VL_valid	    U1   horizontal LR split border detected valid signal for top half picture
//   //Bit 20:16,	RO_Det3D_Split_VL_pxnum	    U5   number of pixels included for the LR split position estimation for top half picture
//   //Bit  9: 0,	RO_Det3D_Split_VL_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
//   `define DET3D_RO_SPLT_VR            8'h82
//   //Bit 24   ,	RO_Det3D_Split_VR_valid	    U1   horizontal LR split border detected valid signal for top half picture
//   //Bit 20:16,	RO_Det3D_Split_VR_pxnum	    U5   number of pixels included for the LR split position estimation for top half picture
//   //Bit  9: 0,	RO_Det3D_Split_VR_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
//   `define DET3D_RO_MAT_LUMA_LR        8'h83
//   //Bit 15:0,	RO_Luma_LR_score	 S2*8  LUMA statistics left right decision score for each band (8bands vertically),
//   //                               it can be -1/0/1:-1: most likely not LR symmetric 0: not sure 1: most likely LR symmetric
//   //Bit 7:0,	RO_Luma_LR_symtc	 U1*8  Luma statistics left right pure symmetric for each band (8bands vertically),
//   //                               it can be 0/1: 0: not sure 1: most likely LR is pure symmetric
//   //Bit 4:0,	RO_Luma_LR_sum	     S5  Total score of 8x8 Luma statistics for LR like decision,
//   //                               the larger this score, the more confidence that this is a LR 3D video. It is sum of  RO_Luma_LR_score[0~7]
//   `define DET3D_RO_MAT_LUMA_TB        8'h84
//   //Bit 15:0,	RO_Luma_TB_score	 S2*8  LUMA statistics Top/Bottom decision score for each band (8bands Horizontally),
//   //Bit 7:0,	RO_Luma_TB_symtc	 Luma statistics Top/Bottompure symmetric for each band (8bands Horizontally),
//   //Bit 4:0,	RO_Luma_TB_sum	     Total score of 8x8 Luma statistics for TB like decision,
//   `define DET3D_RO_MAT_CHRU_LR        8'h85
//   //Bit 15:0,	RO_ChrU_LR_score	S2*8  LUMA statistics left right decision score for each band (8bands vertically),
//   //Bit 7:0,	RO_ChrU_LR_symtc	CHRU statistics left right pure symmetric for each band (8bands vertically),
//   //Bit 4:0,	RO_ChrU_LR_sum	    Total score of 8x8 ChrU statistics for LR like decision,
//   `define DET3D_RO_MAT_CHRU_TB        8'h86
//   //Bit 15:0,	RO_ChrU_TB_score	S2*8  CHRU statistics Top/Bottom decision score for each band (8bands Horizontally)
//   //Bit 7:0,	RO_ChrU_TB_symtc	CHRU statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//   //Bit 4:0,	RO_ChrU_TB_sum	    Total score of 8x8 ChrU statistics for TB like decision
//   `define DET3D_RO_MAT_CHRV_LR        8'h87
//   //Bit 15:0,	RO_ChrV_LR_score	S2*8  CHRUstatistics left right decision score for each band (8bands vertically)
//   //Bit 7:0,	RO_ChrV_LR_symtc	CHRV statistics left right pure symmetric for each band (8bands vertically)
//   //Bit 4:0,	RO_ChrV_LR_sum	    Total score of 8x8 ChrV statistics for LR like decision
//   `define DET3D_RO_MAT_CHRV_TB        8'h88
//   //Bit 15:0,	RO_ChrV_TB_score	CHRV statistics Top/Bottom decision score for each band (8bands Horizontally)
//   //Bit 7:0,	RO_ChrV_TB_symtc	CHRV statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//   //Bit 4:0,	RO_ChrV_TB_sum	    Total score of 8x8 ChrV statistics for TB like decision
//   `define DET3D_RO_MAT_HEDG_LR        8'h89
//   //Bit 15:0,	RO_Hedg_LR_score	Horizontal Edge statistics left right decision score for each band (8bands vertically)
//   //Bit 7:0,	RO_Hedg_LR_symtc	Horizontal Edge statistics left right pure symmetric for each band (8bands vertically)
//   //Bit 4:0,	RO_Hedg_LR_sum	    Total score of 8x8 Hedg statistics for LR like decision
//   `define DET3D_RO_MAT_HEDG_TB        8'h8a
//   //Bit 15:0,	RO_Hedg_TB_score	Horizontal Edge statistics Top/Bottom decision score for each band (8bands Horizontally)
//   //Bit 7:0,	RO_Hedg_TB_symtc	Horizontal Edge statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//   //Bit 4:0,	RO_Hedg_TB_sum	    Total score of 8x8 Hedg statistics for TB like decision
//   `define DET3D_RO_MAT_VEDG_LR        8'h8b
//   //Bit 15:0,	RO_Vedg_LR_score	Vertical Edge statistics left right decision score for each band (8bands vertically)
//   //Bit 7:0,	RO_Vedg_LR_symtc	Vertical Edge statistics left right pure symmetric for each band (8bands vertically)
//   //Bit 4:0,	RO_Vedg_LR_sum	    Total score of 8x8 Vedg statistics for LR like decision
//   `define DET3D_RO_MAT_VEDG_TB        8'h8c
//   //Bit 15:0,	RO_Vedg_TB_score	Vertical Edge statistics Top/Bottom decision score for each band (8bands Horizontally)
//   //Bit 7:0,	RO_Vedg_TB_symtc	Vertical Edge statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//   //Bit 4:0,	RO_Vedg_TB_sum	    Total score of 8x8 Vedg statistics for TB like decision
//   `define DET3D_RO_MAT_MOTN_LR        8'h8d
//   //Bit 15:0,	RO_Motn_LR_score	Motion statistics left right decision score for each band (8bands vertically)
//   //Bit 7:0,	RO_Motn_LR_symtc	Motion statistics left right pure symmetric for each band (8bands vertically)
//   //Bit 4:0,	RO_Motn_LR_sum	    Total score of 8x8 Motion statistics for LR like decision
//   `define DET3D_RO_MAT_MOTN_TB        8'h8e
//   //Bit 15:0,	RO_Motn_TB_score	Motion statistics Top/Bottom decision score for each band (8bands Horizontally)
//   //Bit 7:0,	RO_Motn_TB_symtc	Motion statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//   //Bit 4:0,	RO_Motn_TB_sum	    Total score of 8x8 Motion statistics for TB like decision
//   `define DET3D_RO_FRM_MOTN           8'h8f
//   //Bit 15:0,	RO_Det3D_Frame_Motion	U16  frame based motion value sum for still image decision in FW.
#define DI_EI_CTRL10                               ((0x1793  << 2) + 0xff900000)
//bit 31:28,   reg_ei_caldrt_hstrrgchk_drtth
//bit 27:24,   reg_ei_caldrt_hstrrgchk_frcverthrd
//bit 23:20,   reg_ei_caldrt_hstrrgchk_mg
//bit 19,      reg_ei_caldrt_hstrrgchk_1sidnul
//bit 18,      reg_ei_caldrt_hstrrgchk_excpcnf
//bit 17:16,   reg_ei_caldrt_hstrrgchk_ws
//bit 15,      reg_ei_caldrt_hstrrgchk_en
//bit 14:13,   reg_ei_caldrt_hpncheck_mode
//bit 12,      reg_ei_caldrt_hpncheck_mute
//bit 11:9,    reg_ei_caldrt_hcnfcheck_mg2
//bit 8:6,     reg_ei_caldrt_hcnfcheck_mg1
//bit 5:4,     reg_ei_caldrt_hcnfcheck_mode
//bit 3:0,     reg_ei_caldrt_hcnfcheck_mg2
#define DI_NR_1_CTRL0                              ((0x1794  << 2) + 0xff900000)
#define DI_NR_1_CTRL1                              ((0x1795  << 2) + 0xff900000)
#define DI_NR_1_CTRL2                              ((0x1796  << 2) + 0xff900000)
#define DI_NR_1_CTRL3                              ((0x1797  << 2) + 0xff900000)
#define DI_EI_XWIN0                                ((0x1798  << 2) + 0xff900000)
//bit 27:16,   ei_xend0
//bit 11:0,    ei_xstart0
#define DI_EI_XWIN1                                ((0x1799  << 2) + 0xff900000)
/// mat ram read enter addr
//   `define DET3D_RAMRD_ADDR_PORT       8'h9a
//   `define DET3D_RAMRD_DATA_PORT       8'h9b
#define NR2_CFR_PARA_CFG0                          ((0x179c  << 2) + 0xff900000)
//Bit 8,	reg_CFR_CurDif_luma_mode	Current Field Top/Bot line Luma difference calculation mode
//Bit 7:6,	reg_MACFR_frm_phase	        U2  This will be a field based phase register that need to be set by FW phase to phase:
//                                      this will be calculated based on dbdr_phase of the specific line of this frame.
//                                      u1: dbdr_phase=1, center line is DB in current line;  dbdr_phase=2, center line is Dr in current line;
//Bit 5:4,	reg_CFR_CurDif_tran_mode	U2  Current Field Top/Bot line Luma/Chroma transition level calculation mode,
//Bit 3:2,	reg_CFR_alpha_mode	        U2  Alpha selection mode for CFR block from curAlp and motAlp i.e. 0: motAlp; 1: (motAlp+curAlp)/2; 2: min(motAlp,curAlp); 3: max(motAlp,curAlp);
//Bit 1:0,	reg_CFR_Motion_Luma_mode	U2  LumaMotion Calculation mode for MA-CFR. 0: top/bot Lumma motion;   1: middle Luma Motion 2: top/bot + middle motion; 3: max(top/tot motion, middle motion)
#define NR2_CFR_PARA_CFG1                          ((0x179d  << 2) + 0xff900000)
//Bit 23:16,	reg_CFR_alpha_gain	    gain to map muxed curAlp and motAlp to alpha that will be used for final blending.
//Bit 15: 8,	reg_CFR_Motion_ofst	    Offset to Motion to calculate the motAlp, e,g:motAlp= reg_CFR_Motion_ofst- Motion;This register can be seen as the level of motion that we consider it at moving.
//Bit  7: 0,	reg_CFR_CurDif_gain	    gain to CurDif to map to alpha, normalized to 32;
//// DET 3D REG DEFINE END ////
#define DI_EI_CTRL11                               ((0x179e  << 2) + 0xff900000)
//bit 30:29,   reg_ei_amb_detect_mode
//bit 28:24,   reg_ei_amb_detect_winth
//bit 23:21,   reg_ei_amb_decide_rppth
//bit 20:19,   reg_ei_retime_lastmappncnfltchk_drtth
//bit 18:16,   reg_ei_retime_lastmappncnfltchk_mode
//bit 15:14,   reg_ei_retime_lastmapvertfrcchk_mode
//bit 13:12,   reg_ei_retime_lastvertfrcchk_mode
//bit 11:8,    reg_ei_retime_lastpnchk_drtth
//bit 6,       reg_ei_retime_lastpnchk_en
//bit 5:4,     reg_ei_retime_mode
//bit 3,       reg_ei_retime_last_en
//bit 2,       reg_ei_retime_ab_en
//bit 1,       reg_ei_caldrt_hstrvertfrcchk_en
//bit 0,       reg_ei_caldrt_hstrrgchk_mode
#define DI_EI_CTRL12                               ((0x179f  << 2) + 0xff900000)
//bit 31:28,   reg_ei_drtdelay2_lmt
//bit 27:26,   reg_ei_drtdelay2_notver_lrwin
//bit 25:24,   reg_ei_drtdelay_mode
//bit 23,      reg_ei_drtdelay2_mode
//bit 22:20,   reg_ei_assign_xla_signm0th
//bit 19,      reg_ei_assign_pkbiasvert_en
//bit 18,      reg_ei_assign_xla_en
//bit 17:16,   reg_ei_assign_xla_mode
//bit 15:12,   reg_ei_assign_nlfilter_magin
//bit 11:8,    reg_ei_localsearch_maxrange
//bit 7:4,     reg_ei_xla_drtth
//bit 3:0,     reg_ei_flatmsad_thrd
#define DI_CONTWR_X                                ((0x17a0  << 2) + 0xff900000)
#define DI_CONTWR_Y                                ((0x17a1  << 2) + 0xff900000)
#define DI_CONTWR_CTRL                             ((0x17a2  << 2) + 0xff900000)
#define DI_CONTPRD_X                               ((0x17a3  << 2) + 0xff900000)
#define DI_CONTPRD_Y                               ((0x17a4  << 2) + 0xff900000)
#define DI_CONTP2RD_X                              ((0x17a5  << 2) + 0xff900000)
#define DI_CONTP2RD_Y                              ((0x17a6  << 2) + 0xff900000)
#define DI_CONTRD_CTRL                             ((0x17a7  << 2) + 0xff900000)
#define DI_EI_CTRL13                               ((0x17a8  << 2) + 0xff900000)
//bit 27:24,   reg_ei_int_drt2x_chrdrt_limit
//bit 23:20,   reg_ei_int_drt16x_core
//bit 19:16,   reg_ei_int_drtdelay2_notver_cancv
//bit 15:8,    reg_ei_int_drtdelay2_notver_sadth
//bit 7:0,     reg_ei_int_drtdelay2_vlddrt_sadth
#define DI_MTN_1_CTRL6                             ((0x17a9  << 2) + 0xff900000)
//bit 31:24,   mtn_m1b_extend
//bit 23:16,   mtn_m1b_errod
//bit 15: 8,   mtn_core_ykinter
//bit  7: 0,   mtn_core_ckinter
#define DI_MTN_1_CTRL7                             ((0x17aa  << 2) + 0xff900000)
//bit 31:24,   mtn_core_mxcmby
//bit 23:16,   mtn_core_mxcmbc
//bit 15: 8,   mtn_core_y
//bit  7: 0,   mtn_core_c
#define DI_MTN_1_CTRL8                             ((0x17ab  << 2) + 0xff900000)
//bit 31:24,   mtn_fcore_ykinter
//bit 23:16,   mtn_fcore_ckinter
//bit 15: 8,   mtn_fcore_ykintra
//bit  7: 0,   mtn_fcore_ckintra
#define DI_MTN_1_CTRL9                             ((0x17ac  << 2) + 0xff900000)
//bit 31:24,   mtn_fcore_2yrate
//bit 23:16,   mtn_fcore_2crate
//bit 15: 8,   mtn_fcore_y
//bit  7: 0,   mtn_fcore_c
#define DI_MTN_1_CTRL10                            ((0x17ad  << 2) + 0xff900000)
//bit 27:24,   mtn_motfld0
//bit 19:16,   mtn_stlfld0
//bit 11: 8,   mtn_motfld1
//bit  3: 0,   mtn_stlfld1
#define DI_MTN_1_CTRL11                            ((0x17ae  << 2) + 0xff900000)
//bit 27:24,   mtn_smotevn
//bit 20:16,   mtn_smotodd
//bit 11: 8,   mtn_sstlevn
//bit  4: 0,   mtn_sstlodd
#define DI_MTN_1_CTRL12                            ((0x17af  << 2) + 0xff900000)
//bit 31:24,   mtn_mgain
//bit 17:16,   mtn_mmode
//bit 15: 8,   mtn_sthrd
//bit  4: 0,   mtn_sgain
#define DI_NRWR_X                                  ((0x17c0  << 2) + 0xff900000)
#define DI_NRWR_Y                                  ((0x17c1  << 2) + 0xff900000)
//bit 31:30				nrwr_words_lim
//bit 29				nrwr_rev_y
//bit 28:16				nrwr_start_y
//bit 15				nrwr_ext_en
//bit 12:0				nrwr_end_y
#define DI_NRWR_CTRL                               ((0x17c2  << 2) + 0xff900000)
//bit 31				pending_ddr_wrrsp_diwr
//bit 30				nrwr_reg_swap
//bit 29:26				nrwr_burst_lim
//bit 25				nrwr_canvas_syncen
//bit 24				nrwr_no_clk_gate
//bit 23:22				nrwr_rgb_mode  0:422 to one canvas;1:4:4:4 to one canvas;
//bit 21:20				nrwr_hconv_mode
//bit 19:18				nrwr_vconv_mode
//bit 17				nrwr_swap_cbcr
//bit 16				nrwr_urgent
//bit 15:8				nrwr_canvas_index_chroma
//bit 7:0				nrwr_canvas_index_luma
#define DI_MTNWR_X                                 ((0x17c3  << 2) + 0xff900000)
#define DI_MTNWR_Y                                 ((0x17c4  << 2) + 0xff900000)
#define DI_MTNWR_CTRL                              ((0x17c5  << 2) + 0xff900000)
#define DI_DIWR_X                                  ((0x17c6  << 2) + 0xff900000)
#define DI_DIWR_Y                                  ((0x17c7  << 2) + 0xff900000)
//bit 31:30				diwr_words_lim
//bit 29				diwr_rev_y
//bit 28:16				diwr_start_y
//bit 15				diwr_ext_en
//bit 12:0				diwr_end_y
#define DI_DIWR_CTRL                               ((0x17c8  << 2) + 0xff900000)
//bit 31				pending_ddr_wrrsp_diwr
//bit 30				diwr_reg_swap
//bit 29:26				diwr_burst_lim
//bit 25				diwr_canvas_syncen
//bit 24				diwr_no_clk_gate
//bit 23:22				diwr_rgb_mode  0:422 to one canvas;1:4:4:4 to one canvas;
//bit 21:20				diwr_hconv_mode
//bit 19:18				diwr_vconv_mode
//bit 17				diwr_swap_cbcr
//bit 16				diwr_urgent
//bit 15:8				diwr_canvas_index_chroma
//bit 7:0				diwr_canvas_index_luma
//`define DI_MTNCRD_X               8'hc9
//`define DI_MTNCRD_Y               8'hca
#define DI_MTNPRD_X                                ((0x17cb  << 2) + 0xff900000)
#define DI_MTNPRD_Y                                ((0x17cc  << 2) + 0xff900000)
#define DI_MTNRD_CTRL                              ((0x17cd  << 2) + 0xff900000)
#define DI_INP_GEN_REG                             ((0x17ce  << 2) + 0xff900000)
#define DI_INP_CANVAS0                             ((0x17cf  << 2) + 0xff900000)
#define DI_INP_LUMA_X0                             ((0x17d0  << 2) + 0xff900000)
#define DI_INP_LUMA_Y0                             ((0x17d1  << 2) + 0xff900000)
#define DI_INP_CHROMA_X0                           ((0x17d2  << 2) + 0xff900000)
#define DI_INP_CHROMA_Y0                           ((0x17d3  << 2) + 0xff900000)
#define DI_INP_RPT_LOOP                            ((0x17d4  << 2) + 0xff900000)
#define DI_INP_LUMA0_RPT_PAT                       ((0x17d5  << 2) + 0xff900000)
#define DI_INP_CHROMA0_RPT_PAT                     ((0x17d6  << 2) + 0xff900000)
#define DI_INP_DUMMY_PIXEL                         ((0x17d7  << 2) + 0xff900000)
#define DI_INP_LUMA_FIFO_SIZE                      ((0x17d8  << 2) + 0xff900000)
#define DI_INP_RANGE_MAP_Y                         ((0x17ba  << 2) + 0xff900000)
#define DI_INP_RANGE_MAP_CB                        ((0x17bb  << 2) + 0xff900000)
#define DI_INP_RANGE_MAP_CR                        ((0x17bc  << 2) + 0xff900000)
#define DI_INP_GEN_REG2                            ((0x1791  << 2) + 0xff900000)
#define DI_INP_FMT_CTRL                            ((0x17d9  << 2) + 0xff900000)
#define DI_INP_FMT_W                               ((0x17da  << 2) + 0xff900000)
#define DI_MEM_GEN_REG                             ((0x17db  << 2) + 0xff900000)
#define DI_MEM_CANVAS0                             ((0x17dc  << 2) + 0xff900000)
#define DI_MEM_LUMA_X0                             ((0x17dd  << 2) + 0xff900000)
#define DI_MEM_LUMA_Y0                             ((0x17de  << 2) + 0xff900000)
#define DI_MEM_CHROMA_X0                           ((0x17df  << 2) + 0xff900000)
#define DI_MEM_CHROMA_Y0                           ((0x17e0  << 2) + 0xff900000)
#define DI_MEM_RPT_LOOP                            ((0x17e1  << 2) + 0xff900000)
#define DI_MEM_LUMA0_RPT_PAT                       ((0x17e2  << 2) + 0xff900000)
#define DI_MEM_CHROMA0_RPT_PAT                     ((0x17e3  << 2) + 0xff900000)
#define DI_MEM_DUMMY_PIXEL                         ((0x17e4  << 2) + 0xff900000)
#define DI_MEM_LUMA_FIFO_SIZE                      ((0x17e5  << 2) + 0xff900000)
#define DI_MEM_RANGE_MAP_Y                         ((0x17bd  << 2) + 0xff900000)
#define DI_MEM_RANGE_MAP_CB                        ((0x17be  << 2) + 0xff900000)
#define DI_MEM_RANGE_MAP_CR                        ((0x17bf  << 2) + 0xff900000)
#define DI_MEM_GEN_REG2                            ((0x1792  << 2) + 0xff900000)
#define DI_MEM_FMT_CTRL                            ((0x17e6  << 2) + 0xff900000)
#define DI_MEM_FMT_W                               ((0x17e7  << 2) + 0xff900000)
#define DI_IF1_GEN_REG                             ((0x17e8  << 2) + 0xff900000)
#define DI_IF1_CANVAS0                             ((0x17e9  << 2) + 0xff900000)
#define DI_IF1_LUMA_X0                             ((0x17ea  << 2) + 0xff900000)
#define DI_IF1_LUMA_Y0                             ((0x17eb  << 2) + 0xff900000)
#define DI_IF1_CHROMA_X0                           ((0x17ec  << 2) + 0xff900000)
#define DI_IF1_CHROMA_Y0                           ((0x17ed  << 2) + 0xff900000)
#define DI_IF1_RPT_LOOP                            ((0x17ee  << 2) + 0xff900000)
#define DI_IF1_LUMA0_RPT_PAT                       ((0x17ef  << 2) + 0xff900000)
#define DI_IF1_CHROMA0_RPT_PAT                     ((0x17f0  << 2) + 0xff900000)
#define DI_IF1_DUMMY_PIXEL                         ((0x17f1  << 2) + 0xff900000)
#define DI_IF1_LUMA_FIFO_SIZE                      ((0x17f2  << 2) + 0xff900000)
#define DI_IF1_RANGE_MAP_Y                         ((0x17fc  << 2) + 0xff900000)
#define DI_IF1_RANGE_MAP_CB                        ((0x17fd  << 2) + 0xff900000)
#define DI_IF1_RANGE_MAP_CR                        ((0x17fe  << 2) + 0xff900000)
#define DI_IF1_GEN_REG2                            ((0x1790  << 2) + 0xff900000)
#define DI_IF1_FMT_CTRL                            ((0x17f3  << 2) + 0xff900000)
#define DI_IF1_FMT_W                               ((0x17f4  << 2) + 0xff900000)
#define DI_CHAN2_GEN_REG                           ((0x17f5  << 2) + 0xff900000)
#define DI_CHAN2_CANVAS0                           ((0x17f6  << 2) + 0xff900000)
#define DI_CHAN2_LUMA_X0                           ((0x17f7  << 2) + 0xff900000)
#define DI_CHAN2_LUMA_Y0                           ((0x17f8  << 2) + 0xff900000)
#define DI_CHAN2_CHROMA_X0                         ((0x17f9  << 2) + 0xff900000)
#define DI_CHAN2_CHROMA_Y0                         ((0x17fa  << 2) + 0xff900000)
#define DI_CHAN2_RPT_LOOP                          ((0x17fb  << 2) + 0xff900000)
#define DI_CHAN2_LUMA0_RPT_PAT                     ((0x17b0  << 2) + 0xff900000)
#define DI_CHAN2_CHROMA0_RPT_PAT                   ((0x17b1  << 2) + 0xff900000)
#define DI_CHAN2_DUMMY_PIXEL                       ((0x17b2  << 2) + 0xff900000)
#define DI_CHAN2_LUMA_FIFO_SIZE                    ((0x17b3  << 2) + 0xff900000)
#define DI_CHAN2_RANGE_MAP_Y                       ((0x17b4  << 2) + 0xff900000)
#define DI_CHAN2_RANGE_MAP_CB                      ((0x17b5  << 2) + 0xff900000)
#define DI_CHAN2_RANGE_MAP_CR                      ((0x17b6  << 2) + 0xff900000)
#define DI_CHAN2_GEN_REG2                          ((0x17b7  << 2) + 0xff900000)
#define DI_CHAN2_FMT_CTRL                          ((0x17b8  << 2) + 0xff900000)
#define DI_CHAN2_FMT_W                             ((0x17b9  << 2) + 0xff900000)
//
// Closing file:  mad_regs.h
//
//`define VPP2_VCBUS_BASE              8'h19
//
// Reading file:  vpp2_regs.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// CBUS_BASE:  VPP2_VCBUS_BASE = 0x19
// -----------------------------------------------
//===========================================================================
// Video postprocessing Registers
//===========================================================================
// dummy data used in the VPP preblend and scaler
// Bit 23:16
// Bit 15:8     CB
// Bit 7:0      CR
#define VPP2_DUMMY_DATA                            ((0x1900  << 2) + 0xff900000)
//input line length used in VPP
#define VPP2_LINE_IN_LENGTH                        ((0x1901  << 2) + 0xff900000)
//input Picture height used in VPP
#define VPP2_PIC_IN_HEIGHT                         ((0x1902  << 2) + 0xff900000)
//Because there are many coefficients used in the vertical filter and horizontal filters,
//indirect access the coefficients of vertical filter and horizontal filter is used.
//For vertical filter, there are 33x4 coefficients
//For horizontal filter, there are 33x4 coefficients
//Bit 15    index increment, if bit9 == 1  then (0: index increase 1, 1: index increase 2) else (index increase 2)
//Bit 14    1: read coef through cbus enable, just for debug purpose in case when we wanna check the coef in ram in correct or not
//Bit 13    if true, vertical separated coef enable
//Bit 9     if true, use 9bit resolution coef, other use 8bit resolution coef
//Bit 8:7   type of index, 00: vertical coef, 01: vertical chroma coef: 10: horizontal coef, 11: resevered
//Bit 6:0   coef index
#define VPP2_SCALE_COEF_IDX                        ((0x1903  << 2) + 0xff900000)
//coefficients for vertical filter and horizontal filter
#define VPP2_SCALE_COEF                            ((0x1904  << 2) + 0xff900000)
//these following registers are the absolute line address pointer for output divided screen
//The output divided screen is shown in the following:
//
//  --------------------------   <------ line zero
//      .
//      .
//      .           region0        <---------- nonlinear region or nonscaling region
//      .
//  ---------------------------
//  ---------------------------  <------ region1_startp
//      .
//      .           region1         <---------- nonlinear region
//      .
//      .
//  ---------------------------
//  ---------------------------  <------ region2_startp
//      .
//      .           region2         <---------- linear region
//      .
//      .
//  ---------------------------
//  ---------------------------  <------ region3_startp
//      .
//      .           region3         <---------- nonlinear region
//      .
//      .
//  ---------------------------
//  ---------------------------  <------ region4_startp
//      .
//      .           region4         <---------- nonlinear region or nonoscaling region
//      .
//      .
//  ---------------------------  <------ region4_endp
//Bit 28:16 region1 startp
//Bit 12:0 region2 startp
#define VPP2_VSC_REGION12_STARTP                   ((0x1905  << 2) + 0xff900000)
//Bit 28:16 region3 startp
//Bit 12:0 region4 startp
#define VPP2_VSC_REGION34_STARTP                   ((0x1906  << 2) + 0xff900000)
#define VPP2_VSC_REGION4_ENDP                      ((0x1907  << 2) + 0xff900000)
//vertical start phase step, (source/dest)*(2^24)
//Bit 27:24 integer part
//Bit 23:0  fraction part
#define VPP2_VSC_START_PHASE_STEP                  ((0x1908  << 2) + 0xff900000)
//vertical scaler region0 phase slope, Bit24 signed bit
#define VPP2_VSC_REGION0_PHASE_SLOPE               ((0x1909  << 2) + 0xff900000)
//vertical scaler region1 phase slope, Bit24 signed bit
#define VPP2_VSC_REGION1_PHASE_SLOPE               ((0x190a  << 2) + 0xff900000)
//vertical scaler region3 phase slope, Bit24 signed bit
#define VPP2_VSC_REGION3_PHASE_SLOPE               ((0x190b  << 2) + 0xff900000)
//vertical scaler region4 phase slope, Bit24 signed bit
#define VPP2_VSC_REGION4_PHASE_SLOPE               ((0x190c  << 2) + 0xff900000)
//Bit 18:17     double line mode, input/output line width of vscaler becomes 2X,
//           so only 2 line buffer in this case, use for 3D line by line interleave scaling
//           bit1 true, double the input width and half input height, bit0 true, change line buffer 2 lines instead of 4 lines
//Bit 16     0: progressive output, 1: interlace output
//Bit 15     vertical scaler output line0 in advance or not for bottom field
//Bit 14:13  vertical scaler initial repeat line0 number for bottom field
//Bit 11:8   vertical scaler initial receiving  number for bottom field
//Bit 7      vertical scaler output line0 in advance or not for top field
//Bit 6:5    vertical scaler initial repeat line0 number for top field
//Bit 3:0    vertical scaler initial receiving  number for top field
#define VPP2_VSC_PHASE_CTRL                        ((0x190d  << 2) + 0xff900000)
//Bit 31:16  vertical scaler field initial phase for bottom field
//Bit 15:0  vertical scaler field initial phase for top field
#define VPP2_VSC_INI_PHASE                         ((0x190e  << 2) + 0xff900000)
//Bit 28:16 region1 startp
//Bit 12:0 region2 startp
#define VPP2_HSC_REGION12_STARTP                   ((0x1910  << 2) + 0xff900000)
//Bit 28:16 region3 startp
//Bit 12:0 region4 startp
#define VPP2_HSC_REGION34_STARTP                   ((0x1911  << 2) + 0xff900000)
#define VPP2_HSC_REGION4_ENDP                      ((0x1912  << 2) + 0xff900000)
//horizontal start phase step, (source/dest)*(2^24)
//Bit 27:24 integer part
//Bit 23:0  fraction part
#define VPP2_HSC_START_PHASE_STEP                  ((0x1913  << 2) + 0xff900000)
//horizontal scaler region0 phase slope, Bit24 signed bit
#define VPP2_HSC_REGION0_PHASE_SLOPE               ((0x1914  << 2) + 0xff900000)
//horizontal scaler region1 phase slope, Bit24 signed bit
#define VPP2_HSC_REGION1_PHASE_SLOPE               ((0x1915  << 2) + 0xff900000)
//horizontal scaler region3 phase slope, Bit24 signed bit
#define VPP2_HSC_REGION3_PHASE_SLOPE               ((0x1916  << 2) + 0xff900000)
//horizontal scaler region4 phase slope, Bit24 signed bit
#define VPP2_HSC_REGION4_PHASE_SLOPE               ((0x1917  << 2) + 0xff900000)
//Bit 22:21   horizontal scaler initial repeat pixel0 number
//Bit 19:16   horizontal scaler initial receiving number
//Bit 15:0    horizontal scaler top field initial phase
#define VPP2_HSC_PHASE_CTRL                        ((0x1918  << 2) + 0xff900000)
// Bit 22 if true, divide VSC line length 2 as the HSC input length, otherwise VSC length length is the same as the VSC line length,
//                 just for special usage, more flexibility
// Bit 21 if true, prevsc uses lin buffer, otherwise prevsc does not use line buffer, it should be same as prevsc_en
// Bit 20 prehsc_en
// Bit 19 prevsc_en
// Bit 18 vsc_en
// Bit 17 hsc_en
// Bit 16 scale_top_en
// Bit 15 video1 scale out enable
// Bit 12 if true, region0,region4 are nonlinear regions, otherwise they are not scaling regions, for horizontal scaler
// Bit 10:8 horizontal scaler bank length
// Bit 5, vertical scaler phase field mode, if true, disable the opposite parity line output, more bandwith needed if output 1080i
// Bit 4 if true, region0,region4 are nonlinear regions, otherwise they are not scaling regions, for vertical scaler
// Bit 2:0 vertical scaler bank length
#define VPP2_SC_MISC                               ((0x1919  << 2) + 0xff900000)
// preblend video1 horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP2_PREBLEND_VD1_H_START_END              ((0x191a  << 2) + 0xff900000)
// preblend video1 vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP2_PREBLEND_VD1_V_START_END              ((0x191b  << 2) + 0xff900000)
// postblend video1 horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP2_POSTBLEND_VD1_H_START_END             ((0x191c  << 2) + 0xff900000)
// postblend video1 vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP2_POSTBLEND_VD1_V_START_END             ((0x191d  << 2) + 0xff900000)
// preblend horizontal size
#define VPP2_PREBLEND_H_SIZE                       ((0x1920  << 2) + 0xff900000)
// postblend horizontal size
#define VPP2_POSTBLEND_H_SIZE                      ((0x1921  << 2) + 0xff900000)
//VPP hold lines
//Bit 29:24
//Bit 21:16
//Bit 15:8     preblend hold lines
//Bit 7:0      postblend hold lines
#define VPP2_HOLD_LINES                            ((0x1922  << 2) + 0xff900000)
//Bit 25   if true, change screen to one color value for preblender
//Bit 24   if true, change screen to one color value for postblender
// Bit 23:16 one color Y
// Bit 15:8 one color Cb
// Bit  7:0 one color  Cr
#define VPP2_BLEND_ONECOLOR_CTRL                   ((0x1923  << 2) + 0xff900000)
//Read Only, VPP preblend current_x, current_y
//Bit 28:16 current_x
//Bit 12:0 current_y
#define VPP2_PREBLEND_CURRENT_XY                   ((0x1924  << 2) + 0xff900000)
//Read Only, VPP postblend current_x, current_y
//Bit 28:16 current_x
//Bit 12:0 current_y
#define VPP2_POSTBLEND_CURRENT_XY                  ((0x1925  << 2) + 0xff900000)
// Bit 31  vd1_bgosd_exchange_en for preblend
// Bit 30  vd1_bgosd_exchange_en for postblend
// bit 28   color management enable
// Bit 27,  reserved
// Bit 26:18, reserved
// Bit 17, osd2 enable for preblend
// Bit 16, osd1 enable for preblend
// Bit 15, reserved
// Bit 14, vd1 enable for preblend
// Bit 13, osd2 enable for postblend
// Bit 12, osd1 enable for postblend
// Bit 11, reserved
// Bit 10, vd1 enable for postblend
// Bit 9,  if true, osd1 is alpha premultiplied
// Bit 8,  if true, osd2 is alpha premultiplied
// Bit 7,  postblend module enable
// Bit 6,  preblend module enable
// Bit 5,  if true, osd2 foreground compared with osd1 in preblend
// Bit 4,  if true, osd2 foreground compared with osd1 in postblend
// Bit 3,
// Bit 2,  if true, disable resetting async fifo every vsync, otherwise every vsync
//           the aync fifo will be reseted.
// Bit 1,
// Bit 0    if true, the output result of VPP is saturated
#define VPP2_MISC                                  ((0x1926  << 2) + 0xff900000)
//Bit 31:20 ofifo line length minus 1
//Bit 19  if true invert input vs
//Bit 18  if true invert input hs
//Bit 17  force top/bottom field, enable
//Bit 16  force top/bottom field, 0: top, 1: bottom
//Bit 15  force one go_field, one pluse, write only
//Bit 14  force one go_line, one pluse, write only
//Bit 12:0 ofifo size (actually only bit 10:1 is valid), always even number
#define VPP2_OFIFO_SIZE                            ((0x1927  << 2) + 0xff900000)
//Read only
//Bit 28:17 current scale out fifo counter
//Bit 16:12 current afifo counter
//Bit 11:0 current ofifo counter
#define VPP2_FIFO_STATUS                           ((0x1928  << 2) + 0xff900000)
// Bit 3 SMOKE2 postblend enable only when postblend osd2 is not enable
// Bit 2 SMOKE2 preblend enable only when preblend osd2 is not enable
// Bit 1 SMOKE1 postblend enable only when postblend osd1 is not enable
// Bit 0 SMOKE1 preblend enable only when preblend osd1 is not enable
#define VPP2_SMOKE_CTRL                            ((0x1929  << 2) + 0xff900000)
//smoke can be used only when that blending is disable and then be used as smoke function
//smoke1 for OSD1 channel
//smoke2 for OSD2 channel
//31:24 Y
//23:16 Cb
//15:8 Cr
//7:0 Alpha
#define VPP2_SMOKE1_VAL                            ((0x192a  << 2) + 0xff900000)
#define VPP2_SMOKE2_VAL                            ((0x192b  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP2_SMOKE1_H_START_END                    ((0x192d  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP2_SMOKE1_V_START_END                    ((0x192e  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP2_SMOKE2_H_START_END                    ((0x192f  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP2_SMOKE2_V_START_END                    ((0x1930  << 2) + 0xff900000)
//Bit 27:16 scale out fifo line length minus 1
//Bit 12:0 scale out fifo size (actually only bit 11:1 is valid, 11:1, max 1024), always even number
#define VPP2_SCO_FIFO_CTRL                         ((0x1933  << 2) + 0xff900000)
//for 3D quincunx sub-sampling and horizontal pixel by pixel 3D interleaving
//Bit 27:24, prehsc_mode, bit 3:2, prehsc odd line interp mode, bit 1:0, prehsc even line interp mode,
//           each 2bit, 00: pix0+pix1/2, average, 01: pix1, 10: pix0
//Bit 23 horizontal scaler double pixel mode
//Bit 22:21   horizontal scaler initial repeat pixel0 number1
//Bit 19:16   horizontal scaler initial receiving number1
//Bit 15:0    horizontal scaler top field initial phase1
#define VPP2_HSC_PHASE_CTRL1                       ((0x1934  << 2) + 0xff900000)
//for 3D quincunx sub-sampling
//31:24  prehsc pattern, each patten 1 bit, from lsb -> msb
//22:20  prehsc pattern start
//18:16 prehsc pattern end
//15:8 pattern, each patten 1 bit, from lsb -> msb
//6:4  pattern start
//2:0  pattern end
#define VPP2_HSC_INI_PAT_CTRL                      ((0x1935  << 2) + 0xff900000)
//Bit 3         minus black level enable for vadj2
//Bit 2         Video adjustment enable for vadj2
//Bit 1         minus black level enable for vadj1
//Bit 0         Video adjustment enable for vadj1
#define VPP2_VADJ_CTRL                             ((0x1940  << 2) + 0xff900000)
//Bit 16:8  brightness, signed value
//Bit 7:0   contrast, unsigned value, contrast from  0 <= contrast <2
#define VPP2_VADJ1_Y                               ((0x1941  << 2) + 0xff900000)
//cb' = cb*ma + cr*mb
//cr' = cb*mc + cr*md
//all are bit 9:0, signed value, -2 < ma/mb/mc/md < 2
#define VPP2_VADJ1_MA_MB                           ((0x1942  << 2) + 0xff900000)
#define VPP2_VADJ1_MC_MD                           ((0x1943  << 2) + 0xff900000)
//Bit 16:8  brightness, signed value
//Bit 7:0   contrast, unsigned value, contrast from  0 <= contrast <2
#define VPP2_VADJ2_Y                               ((0x1944  << 2) + 0xff900000)
//cb' = cb*ma + cr*mb
//cr' = cb*mc + cr*md
//all are bit 9:0, signed value, -2 < ma/mb/mc/md < 2
#define VPP2_VADJ2_MA_MB                           ((0x1945  << 2) + 0xff900000)
#define VPP2_VADJ2_MC_MD                           ((0x1946  << 2) + 0xff900000)
//Read only
//Bit 31, if it is true, it means this probe is valid in the last field/frame
//Bit 29:20 component 0
//Bit 19:10 component 1
//Bit 9:0 component 2
#define VPP2_MATRIX_PROBE_COLOR                    ((0x195c  << 2) + 0xff900000)
//Bit 23:16 component 0
//Bit 15:8  component 1
//Bit 7:0 component 2
#define VPP2_MATRIX_HL_COLOR                       ((0x195d  << 2) + 0xff900000)
//28:16 probe x, postion
//12:0  probe y, position
#define VPP2_MATRIX_PROBE_POS                      ((0x195e  << 2) + 0xff900000)
//Bit 16,  highlight_en
//Bit 15   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before matrix
//Bit 14:12 probe_sel, 000: select post matrix, 001: select vd1 matrix,
//Bit 9:8  matrix coef idx selection, 00: select post matrix, 01: select vd1 matrix
//Bit 5    vd1 conversion matrix enable
//Bit 4    reserved
//Bit 2    output y/cb/cr saturation enable, only for post matrix (y saturate to 16-235, cb/cr saturate to 16-240)
//Bit 1    input y/cb/cr saturation enable, only for post matrix (y saturate to 16-235, cb/cr saturate to 16-240)
//Bit 0    post conversion matrix enable
#define VPP2_MATRIX_CTRL                           ((0x195f  << 2) + 0xff900000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define VPP2_MATRIX_COEF00_01                      ((0x1960  << 2) + 0xff900000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define VPP2_MATRIX_COEF02_10                      ((0x1961  << 2) + 0xff900000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define VPP2_MATRIX_COEF11_12                      ((0x1962  << 2) + 0xff900000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define VPP2_MATRIX_COEF20_21                      ((0x1963  << 2) + 0xff900000)
#define VPP2_MATRIX_COEF22                         ((0x1964  << 2) + 0xff900000)
//Bit 26:16 offset0
//Bit 10:0  offset1
#define VPP2_MATRIX_OFFSET0_1                      ((0x1965  << 2) + 0xff900000)
//Bit 10:0  offset2
#define VPP2_MATRIX_OFFSET2                        ((0x1966  << 2) + 0xff900000)
//Bit 26:16 pre_offset0
//Bit 10:0  pre_offset1
#define VPP2_MATRIX_PRE_OFFSET0_1                  ((0x1967  << 2) + 0xff900000)
//Bit 10:0  pre_offset2
#define VPP2_MATRIX_PRE_OFFSET2                    ((0x1968  << 2) + 0xff900000)
// dummy data used in the VPP postblend
// Bit 23:16    Y
// Bit 15:8     CB
// Bit 7:0      CR
#define VPP2_DUMMY_DATA1                           ((0x1969  << 2) + 0xff900000)
//Bit 31 gainoff module enable
//Bit 26:16 gain0, 1.10 unsigned data
//Bit 10:0  gain1, 1.10 unsigned dat
#define VPP2_GAINOFF_CTRL0                         ((0x196a  << 2) + 0xff900000)
//Bit 26:16 gain2, 1.10 unsigned data
//Bit 10:0, offset0, signed data
#define VPP2_GAINOFF_CTRL1                         ((0x196b  << 2) + 0xff900000)
//Bit 26:16, offset1, signed data
//Bit 10:0, offset2, signed data
#define VPP2_GAINOFF_CTRL2                         ((0x196c  << 2) + 0xff900000)
//Bit 26:16, pre_offset0, signed data
//Bit 10:0, pre_offset1, signed data
#define VPP2_GAINOFF_CTRL3                         ((0x196d  << 2) + 0xff900000)
//Bit 10:0, pre_offset2, signed data
#define VPP2_GAINOFF_CTRL4                         ((0x196e  << 2) + 0xff900000)
//only two registers used in the color management, which are defined in the chroma_reg.h
#define VPP2_CHROMA_ADDR_PORT                      ((0x1970  << 2) + 0xff900000)
#define VPP2_CHROMA_DATA_PORT                      ((0x1971  << 2) + 0xff900000)
//`include "chroma_reg.h"       //defined inside is the indirect addressed registers
//(hsvsharp), (blue), gainoff, mat_vd1,mat_vd2, mat_post, prebld, postbld,(hsharp),sco_ff, vadj1, vadj2, ofifo, (chroma1), clk0(free_clk) vpp_reg
//each item 2bits, for each 2bits, if bit 2*i+1 == 1, free clk, else if bit 2*i == 1 no clk, else auto gated clock
//bit1 is not used, because I can not turn off vpp_reg clk because I can not turn on again
//because the register itself canot be set again without clk
//Bit 31:0
#define VPP2_GCLK_CTRL0                            ((0x1972  << 2) + 0xff900000)
//Chroma2_filter, Chroma2, (Ccoring), (blackext), dnlp
//Bit 9:0
#define VPP2_GCLK_CTRL1                            ((0x1973  << 2) + 0xff900000)
//prehsc_clk, line_buf, prevsc, vsc, hsc_clk, clk0(free_clk)
//Bit 11:0
#define VPP2_SC_GCLK_CTRL                          ((0x1974  << 2) + 0xff900000)
//Bit 17:9 VD1 alpha for preblend
//Bit 8:0 VD1 alpha for postblend
#define VPP2_MISC1                                 ((0x1976  << 2) + 0xff900000)
//Bit 31:24     bottom of region03 output value
//Bit 23:16     bottom of region02 output value
//Bit 15:8      bottom of region01 output value
//Bit 7:0       bottom of region00 output value
#define VPP2_DNLP_CTRL_00                          ((0x1981  << 2) + 0xff900000)
//Bit 31:24     bottom of region07 output value
//Bit 23:16     bottom of region06 output value
//Bit 15:8      bottom of region05 output value
//Bit 7:0       bottom of region04 output value
#define VPP2_DNLP_CTRL_01                          ((0x1982  << 2) + 0xff900000)
//Bit 31:24     bottom of region11 output value
//Bit 23:16     bottom of region10 output value
//Bit 15:8      bottom of region09 output value
//Bit 7:0       bottom of region08 output value
#define VPP2_DNLP_CTRL_02                          ((0x1983  << 2) + 0xff900000)
//Bit 31:24     bottom of region15 output value
//Bit 23:16     bottom of region14 output value
//Bit 15:8      bottom of region13 output value
//Bit 7:0       bottom of region12 output value
#define VPP2_DNLP_CTRL_03                          ((0x1984  << 2) + 0xff900000)
//Bit 31:24     bottom of region19 output value
//Bit 23:16     bottom of region18 output value
//Bit 15:8      bottom of region17 output value
//Bit 7:0       bottom of region16 output value
#define VPP2_DNLP_CTRL_04                          ((0x1985  << 2) + 0xff900000)
//Bit 31:24     bottom of region23 output value
//Bit 23:16     bottom of region22 output value
//Bit 15:8      bottom of region21 output value
//Bit 7:0       bottom of region20 output value
#define VPP2_DNLP_CTRL_05                          ((0x1986  << 2) + 0xff900000)
//Bit 31:24     bottom of region27 output value
//Bit 23:16     bottom of region26 output value
//Bit 15:8      bottom of region25 output value
//Bit 7:0       bottom of region24 output value
#define VPP2_DNLP_CTRL_06                          ((0x1987  << 2) + 0xff900000)
//Bit 31:24     bottom of region31 output value
//Bit 23:16     bottom of region30 output value
//Bit 15:8      bottom of region29 output value
//Bit 7:0       bottom of region28 output value
#define VPP2_DNLP_CTRL_07                          ((0x1988  << 2) + 0xff900000)
//Bit 31:24     bottom of region35 output value
//Bit 23:16     bottom of region34 output value
//Bit 15:8      bottom of region33 output value
//Bit 7:0       bottom of region32 output value
#define VPP2_DNLP_CTRL_08                          ((0x1989  << 2) + 0xff900000)
//Bit 31:24     bottom of region39 output value
//Bit 23:16     bottom of region38 output value
//Bit 15:8      bottom of region37 output value
//Bit 7:0       bottom of region36 output value
#define VPP2_DNLP_CTRL_09                          ((0x198a  << 2) + 0xff900000)
//Bit 31:24     bottom of region43 output value
//Bit 23:16     bottom of region42 output value
//Bit 15:8      bottom of region41 output value
//Bit 7:0       bottom of region40 output value
#define VPP2_DNLP_CTRL_10                          ((0x198b  << 2) + 0xff900000)
//Bit 31:24     bottom of region47 output value
//Bit 23:16     bottom of region46 output value
//Bit 15:8      bottom of region45 output value
//Bit 7:0       bottom of region44 output value
#define VPP2_DNLP_CTRL_11                          ((0x198c  << 2) + 0xff900000)
//Bit 31:24     bottom of region51 output value
//Bit 23:16     bottom of region50 output value
//Bit 15:8      bottom of region49 output value
//Bit 7:0       bottom of region48 output value
#define VPP2_DNLP_CTRL_12                          ((0x198d  << 2) + 0xff900000)
//Bit 31:24     bottom of region55 output value
//Bit 23:16     bottom of region54 output value
//Bit 15:8      bottom of region53 output value
//Bit 7:0       bottom of region52 output value
#define VPP2_DNLP_CTRL_13                          ((0x198e  << 2) + 0xff900000)
//Bit 31:24     bottom of region59 output value
//Bit 23:16     bottom of region58 output value
//Bit 15:8      bottom of region57 output value
//Bit 7:0       bottom of region56 output value
#define VPP2_DNLP_CTRL_14                          ((0x198f  << 2) + 0xff900000)
//Bit 31:24     bottom of region63 output value
//Bit 23:16     bottom of region62 output value
//Bit 15:8      bottom of region61 output value
//Bit 7:0       bottom of region60 output value
#define VPP2_DNLP_CTRL_15                          ((0x1990  << 2) + 0xff900000)
//Bit 20 reserved
//Bit 19 reserved
//Bit 18 demo dynamic nonlinear luma processing enable
//Bit 17 reserved
//Bit 16 reserved
//Bit 15:14, 2'b00: demo adjust on top, 2'b01: demo adjust on bottom, 2'b10: demo adjust on left, 2'b11: demo adjust on right
//Bit 4 reserved
//Bit 3 reserved
//Bit 2 dynamic nonlinear luma processing enable
//Bit 1 reserved
//Bit 0 reserved
#define VPP2_VE_ENABLE_CTRL                        ((0x19a1  << 2) + 0xff900000)
//Bit 12:0, demo left or top screen width
#define VPP2_VE_DEMO_LEFT_TOP_SCREEN_WIDTH         ((0x19a2  << 2) + 0xff900000)
#define VPP2_VE_DEMO_CENTER_BAR                    ((0x19a3  << 2) + 0xff900000)
//28:16  ve_line_length
//12:0   ve_pic_height
#define VPP2_VE_H_V_SIZE                           ((0x19a4  << 2) + 0xff900000)
//Bit 10   reset bit, high active
//Bit 9    0: measuring rising edge, 1: measuring falling edge
//Bit 8    if true, accumulate the counter number, otherwise not
//Bit 7:0  vsync_span, define how many vsync span need to measure
#define VPP2_VDO_MEAS_CTRL                         ((0x19a8  << 2) + 0xff900000)
//Read only
//19:16  ind_meas_count_n, every number of sync_span vsyncs, this counter add 1
//15:0, high bit portion of counter
#define VPP2_VDO_MEAS_VS_COUNT_HI                  ((0x19a9  << 2) + 0xff900000)
//Read only
//31:0, low bit portion of counter
#define VPP2_VDO_MEAS_VS_COUNT_LO                  ((0x19aa  << 2) + 0xff900000)
//vertical scaler phase step
//Bit 27:0,  4.24 format
#define VPP2_OSD_VSC_PHASE_STEP                    ((0x19c0  << 2) + 0xff900000)
//Bit 31:16, bottom vertical scaler initial phase
//Bit 15:0, top vertical scaler initial phase
#define VPP2_OSD_VSC_INI_PHASE                     ((0x19c1  << 2) + 0xff900000)
//Bit 24    osd vertical Scaler enable
//Bit 23    osd_prog_interlace 0: current field is progressive, 1: current field is interlace
//Bit 22:21 osd_vsc_double_line_mode, bit1, double input width and half input height, bit0, change line buffer becomes 2 lines
//Bit 20    osd_vsc_phase0_always_en
//Bit 19    osd_vsc_nearest_en
//Bit 17:16 osd_vsc_bot_rpt_l0_num
//Bit 14:11 osd_vsc_bot_ini_rcv_num
//Bit 9:8   osd_vsc_top_rpt_l0_num
//Bit 6:3   osd_vsc_top_ini_rcv_num
//Bit 2:0   osd_vsc_bank_length
#define VPP2_OSD_VSC_CTRL0                         ((0x19c2  << 2) + 0xff900000)
//horizontal scaler phase step
//Bit 27:0,  4.24 format
#define VPP2_OSD_HSC_PHASE_STEP                    ((0x19c3  << 2) + 0xff900000)
//Bit 31:16, horizontal scaler initial phase1
//Bit 15:0, horizontal scaler initial phase0
#define VPP2_OSD_HSC_INI_PHASE                     ((0x19c4  << 2) + 0xff900000)
//Bit 22   osd horizontal scaler enable
//Bit 21   osd_hsc_double_pix_mode
//Bit 20   osd_hsc_phase0_always_en
//Bit 19   osd_hsc_nearest_en
//Bit 17:16 osd_hsc_rpt_p0_num1
//Bit 14:11 osd_hsc_ini_rcv_num1
//Bit 9:8   osd_hsc_rpt_p0_num0
//Bit 6:3   osd_hsc_ini_rcv_num0
//Bit 2:0   osd_hsc_bank_length
#define VPP2_OSD_HSC_CTRL0                         ((0x19c5  << 2) + 0xff900000)
//for 3D quincunx sub-sampling
//bit 15:8 pattern, each patten 1 bit, from lsb -> msb
//bit 6:4  pattern start
//bit 2:0  pattern end
#define VPP2_OSD_HSC_INI_PAT_CTRL                  ((0x19c6  << 2) + 0xff900000)
//bit 31:24, componet 0
//bit 23:16, component 1
//bit 15:8, component 2
//bit 7:0 component 3, alpha
#define VPP2_OSD_SC_DUMMY_DATA                     ((0x19c7  << 2) + 0xff900000)
//Bit 14 osc_sc_din_osd1_alpha_mode, 1: (alpha >= 128) ? alpha -1: alpha,  0: (alpha >=1) ? alpha - 1: alpha.
//Bit 13 osc_sc_din_osd2_alpha_mode, 1: (alpha >= 128) ? alpha -1: alpha,  0: (alpha >=1) ? alpha - 1: alpha.
//Bit 12 osc_sc_dout_alpha_mode, 1: (alpha >= 128) ? alpha + 1: alpha, 0: (alpha >=1) ? alpha + 1: alpha.
//Bit 12 osc_sc_alpha_mode, 1: (alpha >= 128) ? alpha + 1: alpha, 0: (alpha >=1) ? alpha + 1: alpha.
//Bit 11:4 default alpha for vd1 or vd2 if they are selected as the source
//Bit 3 osd scaler path enable
//Bit 1:0 osd_sc_sel, 00: select osd1 input, 01: select osd2 input, 10: select vd1 input, 11: select vd2 input after matrix
#define VPP2_OSD_SC_CTRL0                          ((0x19c8  << 2) + 0xff900000)
//Bit 28:16 OSD scaler input width minus 1
//Bit 12:0 OSD scaler input height minus 1
#define VPP2_OSD_SCI_WH_M1                         ((0x19c9  << 2) + 0xff900000)
//Bit 28:16 OSD scaler output horizontal start
//Bit 12:0 OSD scaler output horizontal end
#define VPP2_OSD_SCO_H_START_END                   ((0x19ca  << 2) + 0xff900000)
//Bit 28:16 OSD scaler output vertical start
//Bit 12:0 OSD scaler output vertical end
#define VPP2_OSD_SCO_V_START_END                   ((0x19cb  << 2) + 0xff900000)
//Because there are many coefficients used in the vertical filter and horizontal filters,
//indirect access the coefficients of vertical filter and horizontal filter is used.
//For vertical filter, there are 33x4 coefficients
//For horizontal filter, there are 33x4 coefficients
//Bit 15	index increment, if bit9 == 1  then (0: index increase 1, 1: index increase 2) else (index increase 2)
//Bit 14	1: read coef through cbus enable, just for debug purpose in case when we wanna check the coef in ram in correct or not
//Bit 9     if true, use 9bit resolution coef, other use 8bit resolution coef
//Bit 8   type of index, 0: vertical coef,  1: horizontal coef
//Bit 6:0 	coef index
#define VPP2_OSD_SCALE_COEF_IDX                    ((0x19cc  << 2) + 0xff900000)
//coefficients for vertical filter and horizontal filter
#define VPP2_OSD_SCALE_COEF                        ((0x19cd  << 2) + 0xff900000)
//Bit 12:0 line number use to generate interrupt when line == this number
#define VPP2_INT_LINE_NUM                          ((0x19ce  << 2) + 0xff900000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpp2_regs.h
//
//`define VIU_VCBUS_BASE                8'h1a
//
// Reading file:  vregs_clk2.h
//
//===========================================================================
// Video Interface Registers    0xa00 - 0xaff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VIU_VCBUS_BASE = 0x1a
// -----------------------------------------------
#define VIU_ADDR_START                             ((0x1a00  << 2) + 0xff900000)
#define VIU_ADDR_END                               ((0x1aff  << 2) + 0xff900000)
//`define TRACE_REG 8'ff
//------------------------------------------------------------------------------
// VIU top-level registers
//------------------------------------------------------------------------------
// Bit  0 RW, osd1_reset
// Bit  1 RW, osd2_reset
// Bit  2 RW, vd1_reset
// Bit  3 RW, vd1_fmt_reset
// Bit  4 RW, vd2_reset
// Bit  5 RW, vd2_fmt_reset
// Bit  6 RW, di_dsr1to2_reset
// Bit  7 RW, vpp_reset
// Bit  8 RW, di_if1_reset
// Bit  9 RW, di_if1_fmt_reset
// Bit 10 RW, di_inp_reset
// Bit 11 RW, di_inp_fmt_reset
// Bit 12 RW, di_mem_reset
// Bit 13 RW, di_mem_fmt_reset
// Bit 14 RW, di_nr_wr_mif_reset
// Bit 15 RW, dein_wr_mif_reset
// Bit 16 RW, di_chan2_mif_reset
// Bit 17 RW, di_mtn_wr_mif_reset
// Bit 18 RW, di_mtn_rd_mif_reset
// Bit 19 RW, di_mad_reset
// Bit 20 RW, vdin0_reset
// Bit 21 RW, vdin1_reset
// Bit 22 RW, nrin_mux_reset
// Bit 23 RW, vdin0_wr_reset
// Bit 24 RW, vdin1_wr_reset
// Bit 25 RW, reserved
// Bit 26 RW, d2d3_reset
// Bit 27 RW, di_cont_wr_mif_reset
// Bit 28 RW, di_cont_rd_mif_reset
#define VIU_SW_RESET                               ((0x1a01  << 2) + 0xff900000)
#define VIU_SW_RESET0                              ((0x1a02  << 2) + 0xff900000)
// Bit 0 RW, software reset for mcvecrd_mif
// Bit 1 RW, software reset for mcinfowr_mif
// Bit 2 RW, software reset for mcinford_mif
#define VIU_SECURE_REG                             ((0x1a04  << 2) + 0xff900000)
// Bit 0 RW, dolby core1_tv secure w and r
// Bit 1 RW, dolby core2 secure w and r
// Bit 2 RW, dolby core3 secure w and r
// Bit 3 RW, for osd1 secure read
// Bit 4 RW, for osd2 secure read
#define DOLBY_INT_STAT                             ((0x1a05  << 2) + 0xff900000)
// todo
//bit 15:12 osdbld_gclk_ctrl 3:2 regclk ctrl 1:0 blending clk control
//bit 8 if true, vsync interrup is generate only field == 0
//bit 7:0 fix_disable
#define VIU_MISC_CTRL0                             ((0x1a06  << 2) + 0xff900000)
#define VIU_MISC_CTRL1                             ((0x1a07  << 2) + 0xff900000)
// Bit 15:14  mali_afbcd_gclk_ctrl      mali_afbcd clock gate control[5:4]
// Bit 12     osd1_afbcd_axi_mux        0 : use the osd mif as input; 1 : use afbcd as input
// Bit 11:8   mali_afbcd_gclk_ctrl      mali_afbcd clock gate control[3:0]
// Bit  7:2   vd2_afbcd_gclk_ctrl       vd2_afbcd clock gate control
// Bit  1     vpp_vd2_din_sel           0: vpp vd2 sel the mif input; 1: vpp vd2 sel the dos afbcd
// Bit  0     vd2_afbcd_out_sel         0: vd2_afbcd output to vpp; 1 : vd2_afbcd output to di inp
#define D2D3_INTF_LENGTH                           ((0x1a08  << 2) + 0xff900000)
// Bit 31:30 vdin0 dout splitter, bit 0 turns on vdin0 to old path, bit 1 turns on vdin0 to d2d3_intf vdin0 input path
// Bit 29:28 vdin1 dout splitter, bit 0 turns on vdin1 to old path, bit 1 turns on vdin1 to d2d3_intf vdin1 input path
// Bit 27:26 NR write dout splitter, bit 0 turns on NR write to old path, bit 1 turns on NR WR to d2d3_intf NR WR input path
// Bit 23 if true, turn on clk_d2d3_reg (register clock)
// Bit 22 if true, turn on clk_d2d3
// Bit 21 reg_v1_go_line
// Bit 20 reg_v1_go_field
// Bit 19 reg_v0_go_field
// Bit 18:16 v1_gofld_sel, 000: display go_field/go_line, 001: DI pre_frame_rst/go_line, 010: vdin0 go_field/go_line,
//011: vdin1 go_field/go_line, otherwise: force go_field by reg_v1_go_field(bit20), force go_line by reg_v1_go_line(bit21)
// Bit 15:13 v0_gofld_sel, 000: display go_field, 001: DI pre_frame_rst, 010: vdin0 go_field, 011: vdin1 go_field, otherwise: force go_field by
// reg_v0_go_field(bit19)
// Bit 12:6 hole_lines for d2d3 depth read interface
// Bit 5:4 d2d3_v1_sel, 2'b01: video display read interface(DI or vd1 format output), 2'b10: scale output, otherwise nothing as v1
// Bit 3 use_vdin_eol, if true, use vdin eol as the v0_eol, otherwise using length to get the v0_eol
// Bit 2:0  d2d3_v0_sel  001: vdin0, 010: vdin1, 011: NRW, 100: video display read interface(DI or vd1 format output), 101: vpp scale output
//
#define D2D3_INTF_CTRL0                            ((0x1a09  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// OSD1 registers
//------------------------------------------------------------------------------
// Bit    31 Reserved
// Bit    30 RW, enable_free_clk: 1=use free-running clock to drive logic;
//                                0=use gated clock for low power.
// Bit    29 R, test_rd_dsr
// Bit    28 R, osd_done
// Bit 27:24 R, osd_blk_mode
// Bit 23:22 R, osd_blk_ptr
// Bit    21 R, osd_enable
//
// Bit 20:12 RW, global_alpha
// Bit    11 RW, test_rd_en
// Bit 10: 9 Reserved for control signals
// Bit  8: 5 RW, ctrl_mtch_y
// Bit     4 RW, ctrl_422to444
// Bit  3: 0 RW, osd_blk_enable. Bit 0 to enable block 0: 1=enable, 0=disable;
//                               Bit 1 to enable block 1, and so on.
#define VIU_OSD1_CTRL_STAT                         ((0x1a10  << 2) + 0xff900000)
// Bit 31:26 Reserved
// Bit 25:16 R, fifo_count
// Bit 15    RW, osd_dpath_sel   0-osd1 mif 1-vpu mali afbcd
// Bit 14    RW, replaced_alpha_en
// Bit 13: 6 RW, replaced_alpha
// Bit  5: 4 RW, hold_fifo_lines[6:5]
// Bit     3 RW, rgb2yuv_full_range
// Bit     2 RW, alpha_9b_mode
// Bit     1 RW, reserved
// Bit     0 RW, color_expand_mode
#define VIU_OSD1_CTRL_STAT2                        ((0x1a2d  << 2) + 0xff900000)
// Bit 31: 9 Reserved
// Bit     8 RW, 0 = Write LUT, 1 = Read LUT
// Bit  7: 0 RW, lut_addr
#define VIU_OSD1_COLOR_ADDR                        ((0x1a11  << 2) + 0xff900000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU_OSD1_COLOR                             ((0x1a12  << 2) + 0xff900000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU_OSD1_TCOLOR_AG0                        ((0x1a17  << 2) + 0xff900000)
#define VIU_OSD1_TCOLOR_AG1                        ((0x1a18  << 2) + 0xff900000)
#define VIU_OSD1_TCOLOR_AG2                        ((0x1a19  << 2) + 0xff900000)
#define VIU_OSD1_TCOLOR_AG3                        ((0x1a1a  << 2) + 0xff900000)
// Bit 31:30 Reserved
// Bit    29 RW, y_rev: 0=normal read, 1=reverse read in Y direction
// Bit    28 RW, x_rev: 0=normal read, 1=reverse read in X direction
// Bit 27:24 Reserved
// Bit 23:16 RW, tbl_addr
// Bit    15 RW, little_endian: 0=big endian, 1=little endian
// Bit    14 RW, rpt_y
// Bit 13:12 RW, interp_ctrl. 0x=No interpolation; 10=Interpolate with previous
//                            pixel; 11=Interpolate with the average value
//                            between previous and next pixel.
// Bit 11: 8 RW, osd_blk_mode
// Bit     7 RW, rgb_en
// Bit     6 RW, tc_alpha_en
// Bit  5: 2 RW, color_matrix
// Bit     1 RW, interlace_en
// Bit     0 RW, interlace_sel_odd
#define VIU_OSD1_BLK0_CFG_W0                       ((0x1a1b  << 2) + 0xff900000)
#define VIU_OSD1_BLK1_CFG_W0                       ((0x1a1f  << 2) + 0xff900000)
#define VIU_OSD1_BLK2_CFG_W0                       ((0x1a23  << 2) + 0xff900000)
#define VIU_OSD1_BLK3_CFG_W0                       ((0x1a27  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, x_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, x_start
#define VIU_OSD1_BLK0_CFG_W1                       ((0x1a1c  << 2) + 0xff900000)
#define VIU_OSD1_BLK1_CFG_W1                       ((0x1a20  << 2) + 0xff900000)
#define VIU_OSD1_BLK2_CFG_W1                       ((0x1a24  << 2) + 0xff900000)
#define VIU_OSD1_BLK3_CFG_W1                       ((0x1a28  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, y_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, y_start
#define VIU_OSD1_BLK0_CFG_W2                       ((0x1a1d  << 2) + 0xff900000)
#define VIU_OSD1_BLK1_CFG_W2                       ((0x1a21  << 2) + 0xff900000)
#define VIU_OSD1_BLK2_CFG_W2                       ((0x1a25  << 2) + 0xff900000)
#define VIU_OSD1_BLK3_CFG_W2                       ((0x1a29  << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, h_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, h_start
#define VIU_OSD1_BLK0_CFG_W3                       ((0x1a1e  << 2) + 0xff900000)
#define VIU_OSD1_BLK1_CFG_W3                       ((0x1a22  << 2) + 0xff900000)
#define VIU_OSD1_BLK2_CFG_W3                       ((0x1a26  << 2) + 0xff900000)
#define VIU_OSD1_BLK3_CFG_W3                       ((0x1a2a  << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, v_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, v_start
#define VIU_OSD1_BLK0_CFG_W4                       ((0x1a13  << 2) + 0xff900000)
#define VIU_OSD1_BLK1_CFG_W4                       ((0x1a14  << 2) + 0xff900000)
#define VIU_OSD1_BLK2_CFG_W4                       ((0x1a15  << 2) + 0xff900000)
#define VIU_OSD1_BLK3_CFG_W4                       ((0x1a16  << 2) + 0xff900000)
// Bit    31 RW, burst_len_sel[2] of [2:0]
// Bit    30 RW, byte_swap: In addition to endian control, further define
//               whether to swap upper and lower byte within a 16-bit mem word.
//               0=No swap; 1=Swap data[15:0] to be {data[7:0], data[15:8]}
// Bit    29 RW, div_swap : swap the 2 64bits words in 128 bit word
// Bit 28:24 RW, fifo_lim : when osd fifo is small than the fifo_lim*16, closed the rq port of osd_rd_mif
// Bit 23:22 RW, fifo_ctrl: 00 : for 1 word in 1 burst , 01 : for  2words in 1burst, 10: for 4words in 1burst, 11: reserved
// Bit 21:20 R,  fifo_st. 0=IDLE, 1=FILL, 2=ABORT
// Bit    19 R,  fifo_overflow
// Bit 18:12 RW, fifo_depth_val, max value=64: set actual fifo depth to fifo_depth_val*8.
// Bit 11:10 RW, burst_len_sel[1:0] of [2:0]. 0=24(default), 1=32, 2=48, 3=64, 4=96, 5=128.
// Bit  9: 5 RW, hold_fifo_lines[4:0]
// Bit     4 RW, clear_err: one pulse to clear fifo_overflow
// Bit     3 RW, fifo_sync_rst
// Bit  2: 1 RW, endian
// Bit     0 RW, urgent
#define VIU_OSD1_FIFO_CTRL_STAT                    ((0x1a2b  << 2) + 0xff900000)
// Bit 31:24 R, Y or R
// Bit 23:16 R, Cb or G
// Bit 15: 8 R, Cr or B
// Bit  7: 0 R, Output Alpha[8:1]
#define VIU_OSD1_TEST_RDDATA                       ((0x1a2c  << 2) + 0xff900000)
// Bit    15 RW, prot_en: 1=Borrow PROT's FIFO storage, either for rotate or non-rotate.
// Bit 12: 0 RW, effective FIFO size when prot_en=1.
#define VIU_OSD1_PROT_CTRL                         ((0x1a2e  << 2) + 0xff900000)
//Bit 7,  highlight_en
//Bit 6   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before matrix
//Bit 5:4  probe_sel, 00: select matrix 0, 01: select matrix 1,  otherwise select nothing
//Bit 3:2, matrix coef idx selection, 00: select mat0, 01: select mat1, otherwise slect nothing
//Bit 1   mat1 conversion matrix enable
//Bit 0   mat0 conversion matrix enable
#define VIU_OSD1_MATRIX_CTRL                       ((0x1a90  << 2) + 0xff900000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define VIU_OSD1_MATRIX_COEF00_01                  ((0x1a91  << 2) + 0xff900000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define VIU_OSD1_MATRIX_COEF02_10                  ((0x1a92  << 2) + 0xff900000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define VIU_OSD1_MATRIX_COEF11_12                  ((0x1a93  << 2) + 0xff900000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define VIU_OSD1_MATRIX_COEF20_21                  ((0x1a94  << 2) + 0xff900000)
//Bit 31:30    mat_clmod
//Bit 18:16    mat_convrs
//Bit 12:0     mat_coef42
#define VIU_OSD1_MATRIX_COLMOD_COEF42              ((0x1a95  << 2) + 0xff900000)
//Bit 26:16 offset0
//Bit 10:0  offset1
#define VIU_OSD1_MATRIX_OFFSET0_1                  ((0x1a96  << 2) + 0xff900000)
//Bit 10:0  offset2
#define VIU_OSD1_MATRIX_OFFSET2                    ((0x1a97  << 2) + 0xff900000)
//Bit 26:16 pre_offset0
//Bit 10:0  pre_offset1
#define VIU_OSD1_MATRIX_PRE_OFFSET0_1              ((0x1a98  << 2) + 0xff900000)
//Bit 10:0  pre_offset2
#define VIU_OSD1_MATRIX_PRE_OFFSET2                ((0x1a99  << 2) + 0xff900000)
//Read only
//Bit 29:20 component 0
//Bit 19:10 component 1
//Bit 9:0 component 2
#define VIU_OSD1_MATRIX_PROBE_COLOR                ((0x1a9a  << 2) + 0xff900000)
//Bit 23:16 component 0
//Bit 15:8  component 1
//Bit 7:0 component 2
#define VIU_OSD1_MATRIX_HL_COLOR                   ((0x1a9b  << 2) + 0xff900000)
//28:16 probe x, postion
//12:0  probe y, position
#define VIU_OSD1_MATRIX_PROBE_POS                  ((0x1a9c  << 2) + 0xff900000)
//Bit 28:16 coef22
//Bit 12:0  coef30
#define VIU_OSD1_MATRIX_COEF22_30                  ((0x1a9d  << 2) + 0xff900000)
//Bit 28:16 coef31
//Bit 12:0  coef32
#define VIU_OSD1_MATRIX_COEF31_32                  ((0x1a9e  << 2) + 0xff900000)
//Bit 28:16 coef40
//Bit 12:0  coef41
#define VIU_OSD1_MATRIX_COEF40_41                  ((0x1a9f  << 2) + 0xff900000)
//Bit 31:27 for all [31] for all eotf enable,[30] for matrix3x3 enable, [29:27] for eotf_ch0~3
//Bit 17:6  for clock gating
//Bit 5:4   pscale_mode ch2
//Bit 3:2   pscale_mode ch1
//Bit 1:0   pscale_mode ch0
#define VIU_OSD1_EOTF_CTL                          ((0x1ad4  << 2) + 0xff900000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define VIU_OSD1_EOTF_COEF00_01                    ((0x1ad5  << 2) + 0xff900000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define VIU_OSD1_EOTF_COEF02_10                    ((0x1ad6  << 2) + 0xff900000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define VIU_OSD1_EOTF_COEF11_12                    ((0x1ad7  << 2) + 0xff900000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define VIU_OSD1_EOTF_COEF20_21                    ((0x1ad8  << 2) + 0xff900000)
//Bit 28:16 coef22
//Bit   2:0 coef_rs
#define VIU_OSD1_EOTF_COEF22_RS                    ((0x1ad9  << 2) + 0xff900000)
#define VIU_OSD1_EOTF_LUT_ADDR_PORT                ((0x1ada  << 2) + 0xff900000)
#define VIU_OSD1_EOTF_LUT_DATA_PORT                ((0x1adb  << 2) + 0xff900000)
//Bit 31:29  for OETF ch0~ch2
//Bit 21:12  for clock gating
//Bit 11:8   for oetf_scl_ch2
//Bit  7:4   for oetf_scl_ch1
//Bit  3:0   for oetf_scl_ch0
#define VIU_OSD1_OETF_CTL                          ((0x1adc  << 2) + 0xff900000)
#define VIU_OSD1_OETF_LUT_ADDR_PORT                ((0x1add  << 2) + 0xff900000)
#define VIU_OSD1_OETF_LUT_DATA_PORT                ((0x1ade  << 2) + 0xff900000)
#define VIU_OSD1_OETF_3X3_OFST_0                   ((0x1aa0  << 2) + 0xff900000)
#define VIU_OSD1_OETF_3X3_OFST_1                   ((0x1aa1  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// OSD2 registers
//------------------------------------------------------------------------------
// Bit    31 Reserved
// Bit    30 RW, enable_free_clk: 1=use free-running clock to drive logic;
//                                0=use gated clock for low power.
// Bit    29 R, test_rd_dsr
// Bit    28 R, osd_done
// Bit 27:24 R, osd_blk_mode
// Bit 23:22 R, osd_blk_ptr
// Bit    21 R, osd_enable
//
// Bit 20:12 RW, global_alpha
// Bit    11 RW, test_rd_en
// Bit    10 RW, hl2_en
// Bit     9 RW, hl1_en
// Bit  8: 5 RW, ctrl_mtch_y
// Bit     4 RW, ctrl_422to444
// Bit  3: 0 RW, osd_blk_enable. Bit 0 to enable block 0: 1=enable, 0=disable;
//                               Bit 1 to enable block 1, and so on.
#define VIU_OSD2_CTRL_STAT                         ((0x1a30  << 2) + 0xff900000)
// Bit 31:26 Reserved
// Bit 25:16 R, fifo_count
// Bit 15    Reserved
// Bit 14    RW, replaced_alpha_en
// Bit 13: 6 RW, replaced_alpha
// Bit  5: 4 RW, hold_fifo_lines[6:5]
// Bit     3 RW, rgb2yuv_full_range
// Bit     2 RW, alpha_9b_mode
// Bit     1 RW, reserved
// Bit     0 RW, color_expand_mode
#define VIU_OSD2_CTRL_STAT2                        ((0x1a4d  << 2) + 0xff900000)
// Bit 31: 9 Reserved
// Bit     8 RW, 0 = Write LUT, 1 = Read LUT
// Bit  7: 0 RW, lut_addr
#define VIU_OSD2_COLOR_ADDR                        ((0x1a31  << 2) + 0xff900000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU_OSD2_COLOR                             ((0x1a32  << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, hl[1-2]_h/v_start
// Bit 15:12 Reserved
// Bit 11: 0 RW, hl[1-2]_h/v_end
#define VIU_OSD2_HL1_H_START_END                   ((0x1a33  << 2) + 0xff900000)
#define VIU_OSD2_HL1_V_START_END                   ((0x1a34  << 2) + 0xff900000)
#define VIU_OSD2_HL2_H_START_END                   ((0x1a35  << 2) + 0xff900000)
#define VIU_OSD2_HL2_V_START_END                   ((0x1a36  << 2) + 0xff900000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU_OSD2_TCOLOR_AG0                        ((0x1a37  << 2) + 0xff900000)
#define VIU_OSD2_TCOLOR_AG1                        ((0x1a38  << 2) + 0xff900000)
#define VIU_OSD2_TCOLOR_AG2                        ((0x1a39  << 2) + 0xff900000)
#define VIU_OSD2_TCOLOR_AG3                        ((0x1a3a  << 2) + 0xff900000)
// Bit 31:24 Reserved
// Bit 23:16 RW, tbl_addr
// Bit    15 RW, little_endian: 0=big endian, 1=little endian
// Bit    14 RW, rpt_y
// Bit 13:12 RW, interp_ctrl. 0x=No interpolation; 10=Interpolate with previous
//                            pixel; 11=Interpolate with the average value
//                            between previous and next pixel.
// Bit 11: 8 RW, osd_blk_mode
// Bit     7 RW, rgb_en
// Bit     6 RW, tc_alpha_en
// Bit  5: 2 RW, color_matrix
// Bit     1 RW, interlace_en
// Bit     0 RW, interlace_sel_odd
#define VIU_OSD2_BLK0_CFG_W0                       ((0x1a3b  << 2) + 0xff900000)
#define VIU_OSD2_BLK1_CFG_W0                       ((0x1a3f  << 2) + 0xff900000)
#define VIU_OSD2_BLK2_CFG_W0                       ((0x1a43  << 2) + 0xff900000)
#define VIU_OSD2_BLK3_CFG_W0                       ((0x1a47  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, x_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, x_start
#define VIU_OSD2_BLK0_CFG_W1                       ((0x1a3c  << 2) + 0xff900000)
#define VIU_OSD2_BLK1_CFG_W1                       ((0x1a40  << 2) + 0xff900000)
#define VIU_OSD2_BLK2_CFG_W1                       ((0x1a44  << 2) + 0xff900000)
#define VIU_OSD2_BLK3_CFG_W1                       ((0x1a48  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, y_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, y_start
#define VIU_OSD2_BLK0_CFG_W2                       ((0x1a3d  << 2) + 0xff900000)
#define VIU_OSD2_BLK1_CFG_W2                       ((0x1a41  << 2) + 0xff900000)
#define VIU_OSD2_BLK2_CFG_W2                       ((0x1a45  << 2) + 0xff900000)
#define VIU_OSD2_BLK3_CFG_W2                       ((0x1a49  << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, h_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, h_start
#define VIU_OSD2_BLK0_CFG_W3                       ((0x1a3e  << 2) + 0xff900000)
#define VIU_OSD2_BLK1_CFG_W3                       ((0x1a42  << 2) + 0xff900000)
#define VIU_OSD2_BLK2_CFG_W3                       ((0x1a46  << 2) + 0xff900000)
#define VIU_OSD2_BLK3_CFG_W3                       ((0x1a4a  << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, v_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, v_start
#define VIU_OSD2_BLK0_CFG_W4                       ((0x1a64  << 2) + 0xff900000)
#define VIU_OSD2_BLK1_CFG_W4                       ((0x1a65  << 2) + 0xff900000)
#define VIU_OSD2_BLK2_CFG_W4                       ((0x1a66  << 2) + 0xff900000)
#define VIU_OSD2_BLK3_CFG_W4                       ((0x1a67  << 2) + 0xff900000)
// Bit    31 RW, burst_len_sel[2] of [2:0]
// Bit    30 RW, byte_swap: In addition to endian control, further define
//               whether to swap upper and lower byte within a 16-bit mem word.
//               0=No swap; 1=Swap data[15:0] to be {data[7:0], data[15:8]}
// Bit    29 RW, div_swap : swap the 2 64bits words in 128 bit word
// Bit 28:24 RW, fifo_lim : when osd fifo is small than the fifo_lim*16, closed the rq port of osd_rd_mif
// Bit 23:22 RW, fifo_ctrl: 00 : for 1 word in 1 burst , 01 : for  2words in 1burst, 10: for 4words in 1burst, 11: reserved
// Bit 21:20 R,  fifo_st. 0=IDLE, 1=FILL, 2=ABORT
// Bit    19 R,  fifo_overflow
//
// Bit 18:12 RW, fifo_depth_val, max value=64: set actual fifo depth to fifo_depth_val*8.
// Bit 11:10 RW, burst_len_sel[1:0] of [2:0]. 0=24(default), 1=32, 2=48, 3=64, 4=96, 5=128.
// Bit  9: 5 RW, hold_fifo_lines[4:0]
// Bit     4 RW, clear_err: one pulse to clear fifo_overflow
// Bit     3 RW, fifo_sync_rst
// Bit  2: 1 RW, endian
// Bit     0 RW, urgent
#define VIU_OSD2_FIFO_CTRL_STAT                    ((0x1a4b  << 2) + 0xff900000)
// Bit 31:24 R, Y or R
// Bit 23:16 R, Cb or G
// Bit 15: 8 R, Cr or B
// Bit  7: 0 R, Output Alpha[8:1]
#define VIU_OSD2_TEST_RDDATA                       ((0x1a4c  << 2) + 0xff900000)
// Bit    15 RW, prot_en: 1=Borrow PROT's FIFO storage, either for rotate or non-rotate.
// Bit 12: 0 RW, effective FIFO size when prot_en=1.
#define VIU_OSD2_PROT_CTRL                         ((0x1a4e  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// VD1 path
//------------------------------------------------------------------------------
#define VD1_IF0_GEN_REG                            ((0x1a50  << 2) + 0xff900000)
#define VD1_IF0_CANVAS0                            ((0x1a51  << 2) + 0xff900000)
#define VD1_IF0_CANVAS1                            ((0x1a52  << 2) + 0xff900000)
#define VD1_IF0_LUMA_X0                            ((0x1a53  << 2) + 0xff900000)
#define VD1_IF0_LUMA_Y0                            ((0x1a54  << 2) + 0xff900000)
#define VD1_IF0_CHROMA_X0                          ((0x1a55  << 2) + 0xff900000)
#define VD1_IF0_CHROMA_Y0                          ((0x1a56  << 2) + 0xff900000)
#define VD1_IF0_LUMA_X1                            ((0x1a57  << 2) + 0xff900000)
#define VD1_IF0_LUMA_Y1                            ((0x1a58  << 2) + 0xff900000)
#define VD1_IF0_CHROMA_X1                          ((0x1a59  << 2) + 0xff900000)
#define VD1_IF0_CHROMA_Y1                          ((0x1a5a  << 2) + 0xff900000)
#define VD1_IF0_RPT_LOOP                           ((0x1a5b  << 2) + 0xff900000)
#define VD1_IF0_LUMA0_RPT_PAT                      ((0x1a5c  << 2) + 0xff900000)
#define VD1_IF0_CHROMA0_RPT_PAT                    ((0x1a5d  << 2) + 0xff900000)
#define VD1_IF0_LUMA1_RPT_PAT                      ((0x1a5e  << 2) + 0xff900000)
#define VD1_IF0_CHROMA1_RPT_PAT                    ((0x1a5f  << 2) + 0xff900000)
#define VD1_IF0_LUMA_PSEL                          ((0x1a60  << 2) + 0xff900000)
#define VD1_IF0_CHROMA_PSEL                        ((0x1a61  << 2) + 0xff900000)
#define VD1_IF0_DUMMY_PIXEL                        ((0x1a62  << 2) + 0xff900000)
#define VD1_IF0_LUMA_FIFO_SIZE                     ((0x1a63  << 2) + 0xff900000)
#define VD1_IF0_RANGE_MAP_Y                        ((0x1a6a  << 2) + 0xff900000)
#define VD1_IF0_RANGE_MAP_CB                       ((0x1a6b  << 2) + 0xff900000)
#define VD1_IF0_RANGE_MAP_CR                       ((0x1a6c  << 2) + 0xff900000)
#define VD1_IF0_GEN_REG2                           ((0x1a6d  << 2) + 0xff900000)
#define VD1_IF0_PROT_CNTL                          ((0x1a6e  << 2) + 0xff900000)
#define VD1_IF0_URGENT_CTRL                        ((0x1a6f  << 2) + 0xff900000)
//Bit 31    it true, disable clock, otherwise enable clock
//Bit 30    soft rst bit
//Bit 28    if true, horizontal formatter use repeating to generate pixel, otherwise use bilinear interpolation
//Bit 27:24 horizontal formatter initial phase
//Bit 23    horizontal formatter repeat pixel 0 enable
//Bit 22:21 horizontal Y/C ratio, 00: 1:1, 01: 2:1, 10: 4:1
//Bit 20    horizontal formatter enable
//Bit 19    if true, always use phase0 while vertical formater, meaning always
//          repeat data, no interpolation
//Bit 18    if true, disable vertical formatter chroma repeat last line
//Bit 17    vertical formatter dont need repeat line on phase0, 1: enable, 0: disable
//Bit 16    vertical formatter repeat line 0 enable
//Bit 15:12 vertical formatter skip line num at the beginning
//Bit 11:8  vertical formatter initial phase
//Bit 7:1   vertical formatter phase step (3.4)
//Bit 0     vertical formatter enable
#define VIU_VD1_FMT_CTRL                           ((0x1a68  << 2) + 0xff900000)
//Bit 27:16  horizontal formatter width
//Bit 11:0   vertical formatter width
#define VIU_VD1_FMT_W                              ((0x1a69  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// VD2 path
//------------------------------------------------------------------------------
#define VD2_IF0_GEN_REG                            ((0x1a70  << 2) + 0xff900000)
#define VD2_IF0_CANVAS0                            ((0x1a71  << 2) + 0xff900000)
#define VD2_IF0_CANVAS1                            ((0x1a72  << 2) + 0xff900000)
#define VD2_IF0_LUMA_X0                            ((0x1a73  << 2) + 0xff900000)
#define VD2_IF0_LUMA_Y0                            ((0x1a74  << 2) + 0xff900000)
#define VD2_IF0_CHROMA_X0                          ((0x1a75  << 2) + 0xff900000)
#define VD2_IF0_CHROMA_Y0                          ((0x1a76  << 2) + 0xff900000)
#define VD2_IF0_LUMA_X1                            ((0x1a77  << 2) + 0xff900000)
#define VD2_IF0_LUMA_Y1                            ((0x1a78  << 2) + 0xff900000)
#define VD2_IF0_CHROMA_X1                          ((0x1a79  << 2) + 0xff900000)
#define VD2_IF0_CHROMA_Y1                          ((0x1a7a  << 2) + 0xff900000)
#define VD2_IF0_RPT_LOOP                           ((0x1a7b  << 2) + 0xff900000)
#define VD2_IF0_LUMA0_RPT_PAT                      ((0x1a7c  << 2) + 0xff900000)
#define VD2_IF0_CHROMA0_RPT_PAT                    ((0x1a7d  << 2) + 0xff900000)
#define VD2_IF0_LUMA1_RPT_PAT                      ((0x1a7e  << 2) + 0xff900000)
#define VD2_IF0_CHROMA1_RPT_PAT                    ((0x1a7f  << 2) + 0xff900000)
#define VD2_IF0_LUMA_PSEL                          ((0x1a80  << 2) + 0xff900000)
#define VD2_IF0_CHROMA_PSEL                        ((0x1a81  << 2) + 0xff900000)
#define VD2_IF0_DUMMY_PIXEL                        ((0x1a82  << 2) + 0xff900000)
#define VD2_IF0_LUMA_FIFO_SIZE                     ((0x1a83  << 2) + 0xff900000)
#define VD2_IF0_RANGE_MAP_Y                        ((0x1a8a  << 2) + 0xff900000)
#define VD2_IF0_RANGE_MAP_CB                       ((0x1a8b  << 2) + 0xff900000)
#define VD2_IF0_RANGE_MAP_CR                       ((0x1a8c  << 2) + 0xff900000)
#define VD2_IF0_GEN_REG2                           ((0x1a8d  << 2) + 0xff900000)
#define VD2_IF0_PROT_CNTL                          ((0x1a8e  << 2) + 0xff900000)
#define VD2_IF0_URGENT_CTRL                        ((0x1a8f  << 2) + 0xff900000)
//Bit 31    it true, disable clock, otherwise enable clock
//Bit 30    soft rst bit
//Bit 28    if true, horizontal formatter use repeating to generate pixel, otherwise use bilinear interpolation
//Bit 27:24 horizontal formatter initial phase
//Bit 23    horizontal formatter repeat pixel 0 enable
//Bit 22:21 horizontal Y/C ratio, 00: 1:1, 01: 2:1, 10: 4:1
//Bit 20    horizontal formatter enable
//Bit 17    vertical formatter dont need repeat line on phase0, 1: enable, 0: disable
//Bit 16    vertical formatter repeat line 0 enable
//Bit 15:12 vertical formatter skip line num at the beginning
//Bit 11:8  vertical formatter initial phase
//Bit 7:1   vertical formatter phase step (3.4)
//Bit 0     vertical formatter enable
#define VIU_VD2_FMT_CTRL                           ((0x1a88  << 2) + 0xff900000)
//Bit 27:16  horizontal formatter width
//Bit 11:0   vertical formatter width
#define VIU_VD2_FMT_W                              ((0x1a89  << 2) + 0xff900000)
//     //todo add comment
#define LDIM_STTS_GCLK_CTRL0                       ((0x1ac0  << 2) + 0xff900000)
#define LDIM_STTS_CTRL0                            ((0x1ac1  << 2) + 0xff900000)
#define LDIM_STTS_WIDTHM1_HEIGHTM1                 ((0x1ac2  << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_COEF00_01                 ((0x1ac3  << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_COEF02_10                 ((0x1ac4  << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_COEF11_12                 ((0x1ac5  << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_COEF20_21                 ((0x1ac6  << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_COEF22                    ((0x1ac7  << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_OFFSET0_1                 ((0x1ac8  << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_OFFSET2                   ((0x1ac9  << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_PRE_OFFSET0_1             ((0x1aca  << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_PRE_OFFSET2               ((0x1acb  << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_HL_COLOR                  ((0x1acc  << 2) + 0xff900000)
#define LDIM_STTS_MATRIX_PROBE_POS                 ((0x1acd  << 2) + 0xff900000)
//
//     //read only
#define LDIM_STTS_MATRIX_PROBE_COLOR               ((0x1ace  << 2) + 0xff900000)
//
//     //Bit 31, local dimming statistic enable
//     //Bit 29, 1: output region histogram 16bit 0:output region histogram 20bit
//     //Bit 28, eol enable
//     //Bit 27:25, vertical line overlap number for max finding
//     //Bit 24:22, horizontal pixel overlap number, 0: 17 pix, 1: 9 pix, 2: 5 pix, 3: 3 pix, 4: 0 pix
//     //Bit 20, 1,2,1 low pass filter enable before max/hist statistic
//     //Bit 19:16, region H/V position index, refer to VDIN_LDIM_STTS_HIST_SET_REGION
//     //Bit 15:14, 1: region read index auto increase per block read finished to VDIN_LDIM_STTS_HIST_READ_REGION
//     //			 2: region read index auto increase per read finished to VDIN_LDIM_STTS_HIST_READ_REGION
//     //			 0/3: disable read index self increase
//     //Bit 13:8, region read sub index, which mux the hist & max-finding result to cbus port, refer to LDIM_STTS_HIST_READ_REGION
//     //Bit 6:0, region read index
#define LDIM_STTS_HIST_REGION_IDX                  ((0x1ad0  << 2) + 0xff900000)
//Bit 28:0, if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h0: read/write hvstart0
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h1: read/write hend01
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h2: read/write vend01
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h3: read/write hend23
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h4: read/write vend23
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h5: read/write hend45
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h6: read/write vend45
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'd7: read/write hend67
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h8: read/write vend67
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h9: read/write hend89
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'ha: read/write vend89
//     //hvstart0, Bit 28:16 row0 vstart, Bit 12:0 col0 hstart
//     //hend01, Bit 28:16 col1 hend, Bit 12:0 col0 hend
//     //vend01, Bit 28:16 row1 vend, Bit 12:0 row0 vend
//     //hend23, Bit 28:16 col3 hend, Bit 12:0 col2 hend
//     //vend23, Bit 28:16 row3 vend, Bit 12:0 row2 vend
//     //hend45, Bit 28:16 col5 hend, Bit 12:0 col4 hend
//     //vend45, Bit 28:16 row5 vend, Bit 12:0 row4 vend
//     //hend67, Bit 28:16 col7 hend, Bit 12:0 col6 hend
//     //vend67, Bit 28:16 row7 vend, Bit 12:0 row6 vend
//     //hend89, Bit 28:16 col9 hend, Bit 12:0 col8 hend
//     //vend89, Bit 28:16 row9 vend, Bit 12:0 row8 vend
#define LDIM_STTS_HIST_SET_REGION                  ((0x1ad1  << 2) + 0xff900000)
//
//     //if LDIM_STTS_HIST_REGION_IDX[29] == 0, that is output hist with 20bit data.
//     //if LDIM_STTS_HIST_REGION_IDX[21] == 0, that is output 16hist bins in comp 0.
//     //output sequence as rd_sub_idx from 0~47: {max_comp2, comp0_hist0}, {max_comp1, comp0_hist1}, {max_comp0, comp0_hist2},
//     //										   comp0_hist3 ... comp2_hist16
//     //if LDIM_STTS_HIST_REGION_IDX[29] == 1, that is output hist with 16bit data.
//     //if LDIM_STTS_HIST_REGION_IDX[21] == 0, that is output 16hist bins in comp 0.
//     //output sequence as rd_sub_idx from 0~47: {max_comp2, max_comp1, max_comp0}, comp0_hist0, comp0_hist1, comp0_hist2
//     //										   comp0_hist3 ... comp2_hist16
//     //if LDIM_STTS_HIST_REGION_IDX[29] == 0, that is output hist with 20bit data.
//     //if LDIM_STTS_HIST_REGION_IDX[21] == 1, that is output 32hist bins in comp 0.
//     //output sequence as rd_sub_idx from 0~47: {max_comp2, max_comp1, max_comp0}, comp0_hist0, comp0_hist1, comp0_hist2
//     //										   comp0_hist3 ...comp0_hist31 ... comp1_hist16
//
#define LDIM_STTS_HIST_READ_REGION                 ((0x1ad2  << 2) + 0xff900000)
#define LDIM_STTS_HIST_START_RD_REGION             ((0x1ad3  << 2) + 0xff900000)
//     //bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di if1 chroma path
//     //bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di if1 luma path
//     `define DI_IF1_URGENT_CTRL						8'ha3
//     //bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di inp chroma path
//     //bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di inp luma path
//     `define DI_INP_URGENT_CTRL						8'ha4
//     //bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di mem chroma path
//     //bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di mem luma path
//     `define DI_MEM_URGENT_CTRL						8'ha5
//     //bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di chan2 chroma path
//     //bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di chan2 luma path
//     `define DI_CHAN2_URGENT_CTRL					8'ha6
#define VD1_IF0_GEN_REG3                           ((0x1aa7  << 2) + 0xff900000)
//bit 31:1,  reversed
//bit 0,     cntl_64bit_rev
#define VD2_IF0_GEN_REG3                           ((0x1aa8  << 2) + 0xff900000)
//bit 31:1,  reversed
//bit 0,     cntl_64bit_rev
#define OSD_BLENDO_H_START_END                     ((0x1aa9  << 2) + 0xff900000)
//OSD blending output horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define OSD_BLENDO_V_START_END                     ((0x1aaa  << 2) + 0xff900000)
//OSD blending output vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define OSD_BLEND_GEN_CTRL0                        ((0x1aab  << 2) + 0xff900000)
//Bit 31:23 const_out_alpha
//Bit 22:14 const_op_alpha
//Bit 13 if true, OSD2 foreground otherwise OSD1 foreground
//Bit 12  OSD BLENDing enable
//Bit 9:8 alpha_op_sel 00: output alpha use osd1_alpha, 01: use osd2_alpha, else use const_out_alpha
//Bit 5:4 color_op_sel 00: use osd1_alpha, 01: use osd2_alpha, else use const_op_alpha
//Bit 1  OSD2 enable
//Bit 0  OSD1 enable
#define OSD_BLEND_GEN_CTRL1                        ((0x1aac  << 2) + 0xff900000)
//Bit 31    osd1_alpha_premult, if true, osd1 alpha is premultiplied
//Bit 30    osd2_alpha_premult, if true, osd2 alpha is premultiplied
//Bit 23:16 osd blending hold lines
//Bit 13:0  osd blending h_size
#define OSD_BLEND_DUMMY_DATA                       ((0x1aad  << 2) + 0xff900000)
//Bit 29:20   Y/R
//Bit 19:10   CB/G
//Bit 9:0     Cr/B
#define OSD_BLEND_CURRENT_XY                       ((0x1aae  << 2) + 0xff900000)
//Bit 28:16 current_x
//Bit 12:0 current_y
//Bit 7,  highlight_en
//Bit 6   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before matrix
//Bit 5:4  probe_sel, 00: select matrix 0, 01: select matrix 1,  otherwise select nothing
//Bit 3:2, matrix coef idx selection, 00: select mat0, 01: select mat1, otherwise slect nothing
//Bit 1   mat1 conversion matrix enable
//Bit 0   mat0 conversion matrix enable
#define VIU_OSD2_MATRIX_CTRL                       ((0x1ab0  << 2) + 0xff900000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define VIU_OSD2_MATRIX_COEF00_01                  ((0x1ab1  << 2) + 0xff900000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define VIU_OSD2_MATRIX_COEF02_10                  ((0x1ab2  << 2) + 0xff900000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define VIU_OSD2_MATRIX_COEF11_12                  ((0x1ab3  << 2) + 0xff900000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define VIU_OSD2_MATRIX_COEF20_21                  ((0x1ab4  << 2) + 0xff900000)
#define VIU_OSD2_MATRIX_COEF22                     ((0x1ab5  << 2) + 0xff900000)
//Bit 26:16 offset0
//Bit 10:0  offset1
#define VIU_OSD2_MATRIX_OFFSET0_1                  ((0x1ab6  << 2) + 0xff900000)
//Bit 10:0  offset2
#define VIU_OSD2_MATRIX_OFFSET2                    ((0x1ab7  << 2) + 0xff900000)
//Bit 26:16 pre_offset0
//Bit 10:0  pre_offset1
#define VIU_OSD2_MATRIX_PRE_OFFSET0_1              ((0x1ab8  << 2) + 0xff900000)
//Bit 10:0  pre_offset2
#define VIU_OSD2_MATRIX_PRE_OFFSET2                ((0x1ab9  << 2) + 0xff900000)
//Read only
//Bit 29:20 component 0
//Bit 19:10 component 1
//Bit 9:0 component 2
#define VIU_OSD2_MATRIX_PROBE_COLOR                ((0x1aba  << 2) + 0xff900000)
//Bit 23:16 component 0
//Bit 15:8  component 1
//Bit 7:0 component 2
#define VIU_OSD2_MATRIX_HL_COLOR                   ((0x1abb  << 2) + 0xff900000)
//28:16 probe x, postion
//12:0  probe y, position
#define VIU_OSD2_MATRIX_PROBE_POS                  ((0x1abc  << 2) + 0xff900000)
//the segment of afbc dec is 8'he0-8'hfe
//`define AFBC_DEC_OFFSET   8'he0
//
// Reading file:  afbc_dec_regs.h
//
// synopsys translate_off
// synopsys translate_on
////===============================////
//// reg
////===============================////
#define AFBC_ENABLE                                ((0x1ae0  << 2) + 0xff900000)
//Bit   31:1,     reserved
//Bit   8,        dec_enable        unsigned  , default = 0
//Bit   7:1,      reserved
//Bit   0,        frm_start         unsigned  , default = 0
#define AFBC_MODE                                  ((0x1ae1  << 2) + 0xff900000)
//Bit   31,       soft_reset        the use as go_field
//Bit   30,       reserved
//Bit   29,       ddr_sz_mode       uns, default = 0 , 0: fixed block ddr size 1 : unfixed block ddr size;
//Bit   28,       blk_mem_mode      uns, default = 0 , 0: fixed 16x128 size; 1 : fixed 12x128 size
//Bit   27:26,    rev_mode          uns, default = 0 , reverse mode
//Bit   25:24,    mif_urgent        uns, default = 3 , info mif and data mif urgent
//Bit   22:16,    hold_line_num
//Bit   15:14,    burst_len         uns, default = 1, 0: burst1 1:burst2 2:burst4
//Bit   13:8,     compbits_yuv      uns, default = 0 ,
//                                  bit 1:0,: y  component bitwidth : 00-8bit 01-9bit 10-10bit
//                                  bit 3:2,: u  component bitwidth : 00-8bit 01-9bit 10-10bit
//                                  bit 5:4,: v  component bitwidth : 00-8bit 01-9bit 10-10bit
//Bit   7:6,      vert_skip_y       uns, default = 0 , luma vert skip mode : 00-y0y1, 01-y0, 10-y1, 11-(y0+y1)/2
//Bit   5:4,      horz_skip_y       uns, default = 0 , luma horz skip mode : 00-y0y1, 01-y0, 10-y1, 11-(y0+y1)/2
//Bit   3:2,      vert_skip_uv      uns, default = 0 , chroma vert skip mode : 00-y0y1, 01-y0, 10-y1, 11-(y0+y1)/2
//Bit   1:0,      horz_skip_uv      uns, default = 0 , chroma horz skip mode : 00-y0y1, 01-y0, 10-y1, 11-(y0+y1)/2
#define AFBC_SIZE_IN                               ((0x1ae2  << 2) + 0xff900000)
//Bit   31:29,    reserved
//Bit   28:16     hsize_in          uns, default = 1920 , pic horz size in  unit: pixel
//Bit   15:13,    reserved
//Bit   12:0,     vsize_in          uns, default = 1080 , pic vert size in  unit: pixel
#define AFBC_DEC_DEF_COLOR                         ((0x1ae3  << 2) + 0xff900000)
//Bit   31:29,    reserved
//Bit   29:20,   def_color_y        uns, default = 0, afbc dec y default setting value
//Bit   19:10,   def_color_u        uns, default = 0, afbc dec u default setting value
//Bit    9: 0,   def_color_v        uns, default = 0, afbc dec v default setting value
#define AFBC_CONV_CTRL                             ((0x1ae4  << 2) + 0xff900000)
//Bit   31:12,   reserved
//Bit   11: 0,   conv_lbuf_len       uns, default = 256, unit=16 pixel need to set = 2^n
#define AFBC_LBUF_DEPTH                            ((0x1ae5  << 2) + 0xff900000)
//Bit   31:28,   reserved
//Bit   27:16,   dec_lbuf_depth      uns, default = 128; // unit= 8 pixel
//Bit   15:12,   reserved
//Bit   11:0,    mif_lbuf_depth      uns, default = 128;
#define AFBC_HEAD_BADDR                            ((0x1ae6  << 2) + 0xff900000)
//Bit   31:0,   mif_info_baddr      uns, default = 32'h0;
#define AFBC_BODY_BADDR                            ((0x1ae7  << 2) + 0xff900000)
//Bit   31:0,   mif_data_baddr      uns, default = 32'h0001_0000;
#define AFBC_SIZE_OUT                              ((0x1ae8  << 2) + 0xff900000)
//Bit   31:29,   reserved
//Bit   28:16,   hsize_out           uns, default = 1920    ; // unit: 1 pixel
//Bit   15:13,   reserved
//Bit    12:0,   vsize_out           uns, default = 1080 ; // unit: 1 pixel
#define AFBC_OUT_YSCOPE                            ((0x1ae9  << 2) + 0xff900000)
//Bit   31:29,   reserved
//Bit   28:16,   out_vert_bgn        uns, default = 0    ; // unit: 1 pixel
//Bit   15:13,   reserved
//Bit    12:0,   out_vert_end        uns, default = 1079 ; // unit: 1 pixel
#define AFBC_STAT                                  ((0x1aea  << 2) + 0xff900000)
//Bit   31:1,   reserved
//Bit      0,   frm_end_stat         uns, frame end status
#define AFBC_VD_CFMT_CTRL                          ((0x1aeb  << 2) + 0xff900000)
//Bit 31    it true, disable clock, otherwise enable clock
//Bit 30    soft rst bit
//Bit 28    if true, horizontal formatter use repeating to generate pixel, otherwise use bilinear interpolation
//Bit 27:24 horizontal formatter initial phase
//Bit 23    horizontal formatter repeat pixel 0 enable
//Bit 22:21 horizontal Y/C ratio, 00: 1:1, 01: 2:1, 10: 4:1
//Bit 20    horizontal formatter enable
//Bit 19    if true, always use phase0 while vertical formater, meaning always
//          repeat data, no interpolation
//Bit 18    if true, disable vertical formatter chroma repeat last line
//Bit 17    vertical formatter dont need repeat line on phase0, 1: enable, 0: disable
//Bit 16    vertical formatter repeat line 0 enable
//Bit 15:12 vertical formatter skip line num at the beginning
//Bit 11:8  vertical formatter initial phase
//Bit 7:1   vertical formatter phase step (3.4)
//Bit 0     vertical formatter enable
#define AFBC_VD_CFMT_W                             ((0x1aec  << 2) + 0xff900000)
//Bit 27:16  horizontal formatter width
//Bit 11:0   vertical formatter width
#define AFBC_MIF_HOR_SCOPE                         ((0x1aed  << 2) + 0xff900000)
//Bit   31:26,   reserved
//Bit   25:16,   mif_blk_bgn_h        uns, default = 0  ; // unit: 32 pixel/block hor
//Bit   15:10,   reserved
//Bit    9: 0,   mif_blk_end_h        uns, default = 59 ; // unit: 32 pixel/block hor
#define AFBC_MIF_VER_SCOPE                         ((0x1aee  << 2) + 0xff900000)
//Bit   31:28,   reserved
//Bit   27:16,   mif_blk_bgn_v        uns, default = 0  ; // unit: 32 pixel/block ver
//Bit   15:12,   reserved
//Bit   11: 0,   mif_blk_end_v        uns, default = 269; // unit: 32 pixel/block ver
#define AFBC_PIXEL_HOR_SCOPE                       ((0x1aef  << 2) + 0xff900000)
//Bit   31:29,   reserved
//Bit   28:16,   dec_pixel_bgn_h        uns, default = 0  ; // unit: pixel
//Bit   15:13,   reserved
//Bit   12: 0,   dec_pixel_end_h        uns, default = 1919 ; // unit: pixel
#define AFBC_PIXEL_VER_SCOPE                       ((0x1af0  << 2) + 0xff900000)
//Bit   31:29,   reserved
//Bit   28:16,   dec_pixel_bgn_v        uns, default = 0  ; // unit: pixel
//Bit   15:13,   reserved
//Bit   12: 0,   dec_pixel_end_v        uns, default = 1079 ; // unit: pixel
#define AFBC_VD_CFMT_H                             ((0x1af1  << 2) + 0xff900000)
//Bit 12:0   vertical formatter height
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  afbc_dec_regs.h
//
//
// Closing file:  vregs_clk2.h
//
//`define  VENC_VCBUS_BASE              8'h1b
//
// Reading file:  venc_regs.h
//
//===========================================================================
// Video Interface Registers    0xa00 - 0xbff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VENC_VCBUS_BASE = 0x1b
// -----------------------------------------------
// bit 15:8 -- vfifo2vd_vd_sel
// bit 0 -- vfifo2vd_en
#define ENCP_VFIFO2VD_CTL                          ((0x1b58  << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCP_VFIFO2VD_PIXEL_START                  ((0x1b59  << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCP_VFIFO2VD_PIXEL_END                    ((0x1b5a  << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCP_VFIFO2VD_LINE_TOP_START               ((0x1b5b  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCP_VFIFO2VD_LINE_TOP_END                 ((0x1b5c  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCP_VFIFO2VD_LINE_BOT_START               ((0x1b5d  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCP_VFIFO2VD_LINE_BOT_END                 ((0x1b5e  << 2) + 0xff900000)
// Route the hsync and vsync signals round the chip. There are three
// sources and users of these signals: VIU, internal video encoder, and
// the pins on the chip. Some muxing is still being done in the VIU. It
// was not moved to the venc module so that the same exact VIU code could
// be used both in Twister and Twister2000.
// Bit 2: venc_sync_source (1=>pins, 0=>viu)
// Bit 1: viu_sync_source (1=>pins, 0=>venc)
// Bit 0: vpins_sync_source (1=>venc, 0=>viu)
#define VENC_SYNC_ROUTE                            ((0x1b60  << 2) + 0xff900000)
#define VENC_VIDEO_EXSRC                           ((0x1b61  << 2) + 0xff900000)
#define VENC_DVI_SETTING                           ((0x1b62  << 2) + 0xff900000)
#define VENC_C656_CTRL                             ((0x1b63  << 2) + 0xff900000)
#define VENC_UPSAMPLE_CTRL0                        ((0x1b64  << 2) + 0xff900000)
#define VENC_UPSAMPLE_CTRL1                        ((0x1b65  << 2) + 0xff900000)
#define VENC_UPSAMPLE_CTRL2                        ((0x1b66  << 2) + 0xff900000)
// Invert control for tcon output
// bit[15:14] -- vsync, hsync,
// bit[13:0] --  oev3, oev2, cpv2, cph3, cph2, cph1, oeh, vcom, stv2, stv1, cpv1, oev1, sth1, sth2
#define TCON_INVERT_CTL                            ((0x1b67  << 2) + 0xff900000)
#define VENC_VIDEO_PROG_MODE                       ((0x1b68  << 2) + 0xff900000)
//---- Venc pixel/line info
#define VENC_ENCI_LINE                             ((0x1b69  << 2) + 0xff900000)
#define VENC_ENCI_PIXEL                            ((0x1b6a  << 2) + 0xff900000)
#define VENC_ENCP_LINE                             ((0x1b6b  << 2) + 0xff900000)
#define VENC_ENCP_PIXEL                            ((0x1b6c  << 2) + 0xff900000)
//---- Status
#define VENC_STATA                                 ((0x1b6d  << 2) + 0xff900000)
//---- Interrupt setting
#define VENC_INTCTRL                               ((0x1b6e  << 2) + 0xff900000)
#define VENC_INTFLAG                               ((0x1b6f  << 2) + 0xff900000)
//--------- Video test configuration
#define VENC_VIDEO_TST_EN                          ((0x1b70  << 2) + 0xff900000)
#define VENC_VIDEO_TST_MDSEL                       ((0x1b71  << 2) + 0xff900000)
#define VENC_VIDEO_TST_Y                           ((0x1b72  << 2) + 0xff900000)
#define VENC_VIDEO_TST_CB                          ((0x1b73  << 2) + 0xff900000)
#define VENC_VIDEO_TST_CR                          ((0x1b74  << 2) + 0xff900000)
#define VENC_VIDEO_TST_CLRBAR_STRT                 ((0x1b75  << 2) + 0xff900000)
#define VENC_VIDEO_TST_CLRBAR_WIDTH                ((0x1b76  << 2) + 0xff900000)
#define VENC_VIDEO_TST_VDCNT_STSET                 ((0x1b77  << 2) + 0xff900000)
//----- Video dac setting
#define VENC_VDAC_DACSEL0                          ((0x1b78  << 2) + 0xff900000)
#define VENC_VDAC_DACSEL1                          ((0x1b79  << 2) + 0xff900000)
#define VENC_VDAC_DACSEL2                          ((0x1b7a  << 2) + 0xff900000)
#define VENC_VDAC_DACSEL3                          ((0x1b7b  << 2) + 0xff900000)
#define VENC_VDAC_DACSEL4                          ((0x1b7c  << 2) + 0xff900000)
#define VENC_VDAC_DACSEL5                          ((0x1b7d  << 2) + 0xff900000)
#define VENC_VDAC_SETTING                          ((0x1b7e  << 2) + 0xff900000)
#define VENC_VDAC_TST_VAL                          ((0x1b7f  << 2) + 0xff900000)
#define VENC_VDAC_DAC0_GAINCTRL                    ((0x1bf0  << 2) + 0xff900000)
#define VENC_VDAC_DAC0_OFFSET                      ((0x1bf1  << 2) + 0xff900000)
#define VENC_VDAC_DAC1_GAINCTRL                    ((0x1bf2  << 2) + 0xff900000)
#define VENC_VDAC_DAC1_OFFSET                      ((0x1bf3  << 2) + 0xff900000)
#define VENC_VDAC_DAC2_GAINCTRL                    ((0x1bf4  << 2) + 0xff900000)
#define VENC_VDAC_DAC2_OFFSET                      ((0x1bf5  << 2) + 0xff900000)
#define VENC_VDAC_DAC3_GAINCTRL                    ((0x1bf6  << 2) + 0xff900000)
#define VENC_VDAC_DAC3_OFFSET                      ((0x1bf7  << 2) + 0xff900000)
#define VENC_VDAC_DAC4_GAINCTRL                    ((0x1bf8  << 2) + 0xff900000)
#define VENC_VDAC_DAC4_OFFSET                      ((0x1bf9  << 2) + 0xff900000)
#define VENC_VDAC_DAC5_GAINCTRL                    ((0x1bfa  << 2) + 0xff900000)
#define VENC_VDAC_DAC5_OFFSET                      ((0x1bfb  << 2) + 0xff900000)
#define VENC_VDAC_FIFO_CTRL                        ((0x1bfc  << 2) + 0xff900000)
#define ENCL_TCON_INVERT_CTL                       ((0x1bfd  << 2) + 0xff900000)
//
// Closing file:  venc_regs.h
//
//
// Reading file:  enc480p_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// Video Encoder 480p Registers    0xb80 - 0xbef
//===========================================================================
//-------- Video basic setting
#define ENCP_VIDEO_EN                              ((0x1b80  << 2) + 0xff900000)
#define ENCP_VIDEO_SYNC_MODE                       ((0x1b81  << 2) + 0xff900000)
#define ENCP_MACV_EN                               ((0x1b82  << 2) + 0xff900000)
#define ENCP_VIDEO_Y_SCL                           ((0x1b83  << 2) + 0xff900000)
#define ENCP_VIDEO_PB_SCL                          ((0x1b84  << 2) + 0xff900000)
#define ENCP_VIDEO_PR_SCL                          ((0x1b85  << 2) + 0xff900000)
#define ENCP_VIDEO_SYNC_SCL                        ((0x1b86  << 2) + 0xff900000)
#define ENCP_VIDEO_MACV_SCL                        ((0x1b87  << 2) + 0xff900000)
#define ENCP_VIDEO_Y_OFFST                         ((0x1b88  << 2) + 0xff900000)
#define ENCP_VIDEO_PB_OFFST                        ((0x1b89  << 2) + 0xff900000)
#define ENCP_VIDEO_PR_OFFST                        ((0x1b8a  << 2) + 0xff900000)
#define ENCP_VIDEO_SYNC_OFFST                      ((0x1b8b  << 2) + 0xff900000)
#define ENCP_VIDEO_MACV_OFFST                      ((0x1b8c  << 2) + 0xff900000)
//----- Video mode
#define ENCP_VIDEO_MODE                            ((0x1b8d  << 2) + 0xff900000)
#define ENCP_VIDEO_MODE_ADV                        ((0x1b8e  << 2) + 0xff900000)
//--------------- Debug pins
#define ENCP_DBG_PX_RST                            ((0x1b90  << 2) + 0xff900000)
#define ENCP_DBG_LN_RST                            ((0x1b91  << 2) + 0xff900000)
#define ENCP_DBG_PX_INT                            ((0x1b92  << 2) + 0xff900000)
#define ENCP_DBG_LN_INT                            ((0x1b93  << 2) + 0xff900000)
//----------- Video Advanced setting
#define ENCP_VIDEO_YFP1_HTIME                      ((0x1b94  << 2) + 0xff900000)
#define ENCP_VIDEO_YFP2_HTIME                      ((0x1b95  << 2) + 0xff900000)
#define ENCP_VIDEO_YC_DLY                          ((0x1b96  << 2) + 0xff900000)
#define ENCP_VIDEO_MAX_PXCNT                       ((0x1b97  << 2) + 0xff900000)
#define ENCP_VIDEO_HSPULS_BEGIN                    ((0x1b98  << 2) + 0xff900000)
#define ENCP_VIDEO_HSPULS_END                      ((0x1b99  << 2) + 0xff900000)
#define ENCP_VIDEO_HSPULS_SWITCH                   ((0x1b9a  << 2) + 0xff900000)
#define ENCP_VIDEO_VSPULS_BEGIN                    ((0x1b9b  << 2) + 0xff900000)
#define ENCP_VIDEO_VSPULS_END                      ((0x1b9c  << 2) + 0xff900000)
#define ENCP_VIDEO_VSPULS_BLINE                    ((0x1b9d  << 2) + 0xff900000)
#define ENCP_VIDEO_VSPULS_ELINE                    ((0x1b9e  << 2) + 0xff900000)
#define ENCP_VIDEO_EQPULS_BEGIN                    ((0x1b9f  << 2) + 0xff900000)
#define ENCP_VIDEO_EQPULS_END                      ((0x1ba0  << 2) + 0xff900000)
#define ENCP_VIDEO_EQPULS_BLINE                    ((0x1ba1  << 2) + 0xff900000)
#define ENCP_VIDEO_EQPULS_ELINE                    ((0x1ba2  << 2) + 0xff900000)
#define ENCP_VIDEO_HAVON_END                       ((0x1ba3  << 2) + 0xff900000)
#define ENCP_VIDEO_HAVON_BEGIN                     ((0x1ba4  << 2) + 0xff900000)
#define ENCP_VIDEO_VAVON_ELINE                     ((0x1baf  << 2) + 0xff900000)
#define ENCP_VIDEO_VAVON_BLINE                     ((0x1ba6  << 2) + 0xff900000)
#define ENCP_VIDEO_HSO_BEGIN                       ((0x1ba7  << 2) + 0xff900000)
#define ENCP_VIDEO_HSO_END                         ((0x1ba8  << 2) + 0xff900000)
#define ENCP_VIDEO_VSO_BEGIN                       ((0x1ba9  << 2) + 0xff900000)
#define ENCP_VIDEO_VSO_END                         ((0x1baa  << 2) + 0xff900000)
#define ENCP_VIDEO_VSO_BLINE                       ((0x1bab  << 2) + 0xff900000)
#define ENCP_VIDEO_VSO_ELINE                       ((0x1bac  << 2) + 0xff900000)
#define ENCP_VIDEO_SYNC_WAVE_CURVE                 ((0x1bad  << 2) + 0xff900000)
#define ENCP_VIDEO_MAX_LNCNT                       ((0x1bae  << 2) + 0xff900000)
#define ENCP_VIDEO_SY_VAL                          ((0x1bb0  << 2) + 0xff900000)
#define ENCP_VIDEO_SY2_VAL                         ((0x1bb1  << 2) + 0xff900000)
#define ENCP_VIDEO_BLANKY_VAL                      ((0x1bb2  << 2) + 0xff900000)
#define ENCP_VIDEO_BLANKPB_VAL                     ((0x1bb3  << 2) + 0xff900000)
#define ENCP_VIDEO_BLANKPR_VAL                     ((0x1bb4  << 2) + 0xff900000)
#define ENCP_VIDEO_HOFFST                          ((0x1bb5  << 2) + 0xff900000)
#define ENCP_VIDEO_VOFFST                          ((0x1bb6  << 2) + 0xff900000)
#define ENCP_VIDEO_RGB_CTRL                        ((0x1bb7  << 2) + 0xff900000)
#define ENCP_VIDEO_FILT_CTRL                       ((0x1bb8  << 2) + 0xff900000)
#define ENCP_VIDEO_OFLD_VPEQ_OFST                  ((0x1bb9  << 2) + 0xff900000)
#define ENCP_VIDEO_OFLD_VOAV_OFST                  ((0x1bba  << 2) + 0xff900000)
#define ENCP_VIDEO_MATRIX_CB                       ((0x1bbb  << 2) + 0xff900000)
#define ENCP_VIDEO_MATRIX_CR                       ((0x1bbc  << 2) + 0xff900000)
#define ENCP_VIDEO_RGBIN_CTRL                      ((0x1bbd  << 2) + 0xff900000)
//------------------Macrovision advanced setting
#define ENCP_MACV_BLANKY_VAL                       ((0x1bc0  << 2) + 0xff900000)
#define ENCP_MACV_MAXY_VAL                         ((0x1bc1  << 2) + 0xff900000)
#define ENCP_MACV_1ST_PSSYNC_STRT                  ((0x1bc2  << 2) + 0xff900000)
#define ENCP_MACV_PSSYNC_STRT                      ((0x1bc3  << 2) + 0xff900000)
#define ENCP_MACV_AGC_STRT                         ((0x1bc4  << 2) + 0xff900000)
#define ENCP_MACV_AGC_END                          ((0x1bc5  << 2) + 0xff900000)
#define ENCP_MACV_WAVE_END                         ((0x1bc6  << 2) + 0xff900000)
#define ENCP_MACV_STRTLINE                         ((0x1bc7  << 2) + 0xff900000)
#define ENCP_MACV_ENDLINE                          ((0x1bc8  << 2) + 0xff900000)
#define ENCP_MACV_TS_CNT_MAX_L                     ((0x1bc9  << 2) + 0xff900000)
#define ENCP_MACV_TS_CNT_MAX_H                     ((0x1bca  << 2) + 0xff900000)
#define ENCP_MACV_TIME_DOWN                        ((0x1bcb  << 2) + 0xff900000)
#define ENCP_MACV_TIME_LO                          ((0x1bcc  << 2) + 0xff900000)
#define ENCP_MACV_TIME_UP                          ((0x1bcd  << 2) + 0xff900000)
#define ENCP_MACV_TIME_RST                         ((0x1bce  << 2) + 0xff900000)
//---------------- VBI control -------------------
#define ENCP_VBI_CTRL                              ((0x1bd0  << 2) + 0xff900000)
#define ENCP_VBI_SETTING                           ((0x1bd1  << 2) + 0xff900000)
#define ENCP_VBI_BEGIN                             ((0x1bd2  << 2) + 0xff900000)
#define ENCP_VBI_WIDTH                             ((0x1bd3  << 2) + 0xff900000)
#define ENCP_VBI_HVAL                              ((0x1bd4  << 2) + 0xff900000)
#define ENCP_VBI_DATA0                             ((0x1bd5  << 2) + 0xff900000)
#define ENCP_VBI_DATA1                             ((0x1bd6  << 2) + 0xff900000)
//----------------C656 OUT Control------------- Grant
#define C656_HS_ST                                 ((0x1be0  << 2) + 0xff900000)
#define C656_HS_ED                                 ((0x1be1  << 2) + 0xff900000)
#define C656_VS_LNST_E                             ((0x1be2  << 2) + 0xff900000)
#define C656_VS_LNST_O                             ((0x1be3  << 2) + 0xff900000)
#define C656_VS_LNED_E                             ((0x1be4  << 2) + 0xff900000)
#define C656_VS_LNED_O                             ((0x1be5  << 2) + 0xff900000)
#define C656_FS_LNST                               ((0x1be6  << 2) + 0xff900000)
#define C656_FS_LNED                               ((0x1be7  << 2) + 0xff900000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  enc480p_regs.h
//
//
// Reading file:  enci_regs.h
//
//===========================================================================
// Video Interface Registers    0xb00 - 0xb57
//===========================================================================
#define ENCI_VIDEO_MODE                            ((0x1b00  << 2) + 0xff900000)
#define ENCI_VIDEO_MODE_ADV                        ((0x1b01  << 2) + 0xff900000)
#define ENCI_VIDEO_FSC_ADJ                         ((0x1b02  << 2) + 0xff900000)
#define ENCI_VIDEO_BRIGHT                          ((0x1b03  << 2) + 0xff900000)
#define ENCI_VIDEO_CONT                            ((0x1b04  << 2) + 0xff900000)
#define ENCI_VIDEO_SAT                             ((0x1b05  << 2) + 0xff900000)
#define ENCI_VIDEO_HUE                             ((0x1b06  << 2) + 0xff900000)
#define ENCI_VIDEO_SCH                             ((0x1b07  << 2) + 0xff900000)
#define ENCI_SYNC_MODE                             ((0x1b08  << 2) + 0xff900000)
#define ENCI_SYNC_CTRL                             ((0x1b09  << 2) + 0xff900000)
#define ENCI_SYNC_HSO_BEGIN                        ((0x1b0a  << 2) + 0xff900000)
#define ENCI_SYNC_HSO_END                          ((0x1b0b  << 2) + 0xff900000)
#define ENCI_SYNC_VSO_EVN                          ((0x1b0c  << 2) + 0xff900000)
#define ENCI_SYNC_VSO_ODD                          ((0x1b0d  << 2) + 0xff900000)
#define ENCI_SYNC_VSO_EVNLN                        ((0x1b0e  << 2) + 0xff900000)
#define ENCI_SYNC_VSO_ODDLN                        ((0x1b0f  << 2) + 0xff900000)
#define ENCI_SYNC_HOFFST                           ((0x1b10  << 2) + 0xff900000)
#define ENCI_SYNC_VOFFST                           ((0x1b11  << 2) + 0xff900000)
#define ENCI_SYNC_ADJ                              ((0x1b12  << 2) + 0xff900000)
#define ENCI_RGB_SETTING                           ((0x1b13  << 2) + 0xff900000)
//`define	ENCI_CMPN_MATRIX_CB		8'h14
//`define	ENCI_CMPN_MATRIX_CR		8'h15
#define ENCI_DE_H_BEGIN                            ((0x1b16  << 2) + 0xff900000)
#define ENCI_DE_H_END                              ((0x1b17  << 2) + 0xff900000)
#define ENCI_DE_V_BEGIN_EVEN                       ((0x1b18  << 2) + 0xff900000)
#define ENCI_DE_V_END_EVEN                         ((0x1b19  << 2) + 0xff900000)
#define ENCI_DE_V_BEGIN_ODD                        ((0x1b1a  << 2) + 0xff900000)
#define ENCI_DE_V_END_ODD                          ((0x1b1b  << 2) + 0xff900000)
#define ENCI_VBI_SETTING                           ((0x1b20  << 2) + 0xff900000)
#define ENCI_VBI_CCDT_EVN                          ((0x1b21  << 2) + 0xff900000)
#define ENCI_VBI_CCDT_ODD                          ((0x1b22  << 2) + 0xff900000)
#define ENCI_VBI_CC525_LN                          ((0x1b23  << 2) + 0xff900000)
#define ENCI_VBI_CC625_LN                          ((0x1b24  << 2) + 0xff900000)
#define ENCI_VBI_WSSDT                             ((0x1b25  << 2) + 0xff900000)
#define ENCI_VBI_WSS_LN                            ((0x1b26  << 2) + 0xff900000)
#define ENCI_VBI_CGMSDT_L                          ((0x1b27  << 2) + 0xff900000)
#define ENCI_VBI_CGMSDT_H                          ((0x1b28  << 2) + 0xff900000)
#define ENCI_VBI_CGMS_LN                           ((0x1b29  << 2) + 0xff900000)
#define ENCI_VBI_TTX_HTIME                         ((0x1b2a  << 2) + 0xff900000)
#define ENCI_VBI_TTX_LN                            ((0x1b2b  << 2) + 0xff900000)
#define ENCI_VBI_TTXDT0                            ((0x1b2c  << 2) + 0xff900000)
#define ENCI_VBI_TTXDT1                            ((0x1b2d  << 2) + 0xff900000)
#define ENCI_VBI_TTXDT2                            ((0x1b2e  << 2) + 0xff900000)
#define ENCI_VBI_TTXDT3                            ((0x1b2f  << 2) + 0xff900000)
#define ENCI_MACV_N0                               ((0x1b30  << 2) + 0xff900000)
#define ENCI_MACV_N1                               ((0x1b31  << 2) + 0xff900000)
#define ENCI_MACV_N2                               ((0x1b32  << 2) + 0xff900000)
#define ENCI_MACV_N3                               ((0x1b33  << 2) + 0xff900000)
#define ENCI_MACV_N4                               ((0x1b34  << 2) + 0xff900000)
#define ENCI_MACV_N5                               ((0x1b35  << 2) + 0xff900000)
#define ENCI_MACV_N6                               ((0x1b36  << 2) + 0xff900000)
#define ENCI_MACV_N7                               ((0x1b37  << 2) + 0xff900000)
#define ENCI_MACV_N8                               ((0x1b38  << 2) + 0xff900000)
#define ENCI_MACV_N9                               ((0x1b39  << 2) + 0xff900000)
#define ENCI_MACV_N10                              ((0x1b3a  << 2) + 0xff900000)
#define ENCI_MACV_N11                              ((0x1b3b  << 2) + 0xff900000)
#define ENCI_MACV_N12                              ((0x1b3c  << 2) + 0xff900000)
#define ENCI_MACV_N13                              ((0x1b3d  << 2) + 0xff900000)
#define ENCI_MACV_N14                              ((0x1b3e  << 2) + 0xff900000)
#define ENCI_MACV_N15                              ((0x1b3f  << 2) + 0xff900000)
#define ENCI_MACV_N16                              ((0x1b40  << 2) + 0xff900000)
#define ENCI_MACV_N17                              ((0x1b41  << 2) + 0xff900000)
#define ENCI_MACV_N18                              ((0x1b42  << 2) + 0xff900000)
#define ENCI_MACV_N19                              ((0x1b43  << 2) + 0xff900000)
#define ENCI_MACV_N20                              ((0x1b44  << 2) + 0xff900000)
#define ENCI_MACV_N21                              ((0x1b45  << 2) + 0xff900000)
#define ENCI_MACV_N22                              ((0x1b46  << 2) + 0xff900000)
//`define	ENCI_MACV_P_AGC			8'h47
#define ENCI_DBG_PX_RST                            ((0x1b48  << 2) + 0xff900000)
#define ENCI_DBG_FLDLN_RST                         ((0x1b49  << 2) + 0xff900000)
#define ENCI_DBG_PX_INT                            ((0x1b4a  << 2) + 0xff900000)
#define ENCI_DBG_FLDLN_INT                         ((0x1b4b  << 2) + 0xff900000)
#define ENCI_DBG_MAXPX                             ((0x1b4c  << 2) + 0xff900000)
#define ENCI_DBG_MAXLN                             ((0x1b4d  << 2) + 0xff900000)
#define ENCI_MACV_MAX_AMP                          ((0x1b50  << 2) + 0xff900000)
#define ENCI_MACV_PULSE_LO                         ((0x1b51  << 2) + 0xff900000)
#define ENCI_MACV_PULSE_HI                         ((0x1b52  << 2) + 0xff900000)
#define ENCI_MACV_BKP_MAX                          ((0x1b53  << 2) + 0xff900000)
#define ENCI_CFILT_CTRL                            ((0x1b54  << 2) + 0xff900000)
#define ENCI_CFILT7                                ((0x1b55  << 2) + 0xff900000)
#define ENCI_YC_DELAY                              ((0x1b56  << 2) + 0xff900000)
#define ENCI_VIDEO_EN                              ((0x1b57  << 2) + 0xff900000)
//
// Closing file:  enci_regs.h
//
//`define  VENC2_VCBUS_BASE             8'h1c
//
// Reading file:  venc2_regs.h
//
//===========================================================================
// Venc Registers (Cont.)    0xc00 - 0xcff (VENC registers 0xc00 - 0xcef)
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VENC2_VCBUS_BASE = 0x1c
// -----------------------------------------------
// Program video control signals from ENCI core to DVI/HDMI interface
#define ENCI_DVI_HSO_BEGIN                         ((0x1c00  << 2) + 0xff900000)
#define ENCI_DVI_HSO_END                           ((0x1c01  << 2) + 0xff900000)
#define ENCI_DVI_VSO_BLINE_EVN                     ((0x1c02  << 2) + 0xff900000)
#define ENCI_DVI_VSO_BLINE_ODD                     ((0x1c03  << 2) + 0xff900000)
#define ENCI_DVI_VSO_ELINE_EVN                     ((0x1c04  << 2) + 0xff900000)
#define ENCI_DVI_VSO_ELINE_ODD                     ((0x1c05  << 2) + 0xff900000)
#define ENCI_DVI_VSO_BEGIN_EVN                     ((0x1c06  << 2) + 0xff900000)
#define ENCI_DVI_VSO_BEGIN_ODD                     ((0x1c07  << 2) + 0xff900000)
#define ENCI_DVI_VSO_END_EVN                       ((0x1c08  << 2) + 0xff900000)
#define ENCI_DVI_VSO_END_ODD                       ((0x1c09  << 2) + 0xff900000)
// Define cmpt and cvbs cb/cr delay after ENCI chroma filters
// Bit 15:12 RW, enci_cb_cvbs_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit 11: 8 RW, enci_cr_cvbs_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit  7: 4 RW, enci_cb_cmpt_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit  3: 0 RW, enci_cr_cmpt_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
#define ENCI_CFILT_CTRL2                           ((0x1c0a  << 2) + 0xff900000)
#define ENCI_DACSEL_0                              ((0x1c0b  << 2) + 0xff900000)
#define ENCI_DACSEL_1                              ((0x1c0c  << 2) + 0xff900000)
#define ENCP_DACSEL_0                              ((0x1c0d  << 2) + 0xff900000)
#define ENCP_DACSEL_1                              ((0x1c0e  << 2) + 0xff900000)
#define ENCP_MAX_LINE_SWITCH_POINT                 ((0x1c0f  << 2) + 0xff900000)
#define ENCI_TST_EN                                ((0x1c10  << 2) + 0xff900000)
#define ENCI_TST_MDSEL                             ((0x1c11  << 2) + 0xff900000)
#define ENCI_TST_Y                                 ((0x1c12  << 2) + 0xff900000)
#define ENCI_TST_CB                                ((0x1c13  << 2) + 0xff900000)
#define ENCI_TST_CR                                ((0x1c14  << 2) + 0xff900000)
#define ENCI_TST_CLRBAR_STRT                       ((0x1c15  << 2) + 0xff900000)
#define ENCI_TST_CLRBAR_WIDTH                      ((0x1c16  << 2) + 0xff900000)
#define ENCI_TST_VDCNT_STSET                       ((0x1c17  << 2) + 0xff900000)
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define ENCI_VFIFO2VD_CTL                          ((0x1c18  << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCI_VFIFO2VD_PIXEL_START                  ((0x1c19  << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCI_VFIFO2VD_PIXEL_END                    ((0x1c1a  << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCI_VFIFO2VD_LINE_TOP_START               ((0x1c1b  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCI_VFIFO2VD_LINE_TOP_END                 ((0x1c1c  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCI_VFIFO2VD_LINE_BOT_START               ((0x1c1d  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCI_VFIFO2VD_LINE_BOT_END                 ((0x1c1e  << 2) + 0xff900000)
#define ENCI_VFIFO2VD_CTL2                         ((0x1c1f  << 2) + 0xff900000)
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define ENCT_VFIFO2VD_CTL                          ((0x1c20  << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCT_VFIFO2VD_PIXEL_START                  ((0x1c21  << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCT_VFIFO2VD_PIXEL_END                    ((0x1c22  << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCT_VFIFO2VD_LINE_TOP_START               ((0x1c23  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCT_VFIFO2VD_LINE_TOP_END                 ((0x1c24  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCT_VFIFO2VD_LINE_BOT_START               ((0x1c25  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCT_VFIFO2VD_LINE_BOT_END                 ((0x1c26  << 2) + 0xff900000)
#define ENCT_VFIFO2VD_CTL2                         ((0x1c27  << 2) + 0xff900000)
#define ENCT_TST_EN                                ((0x1c28  << 2) + 0xff900000)
#define ENCT_TST_MDSEL                             ((0x1c29  << 2) + 0xff900000)
#define ENCT_TST_Y                                 ((0x1c2a  << 2) + 0xff900000)
#define ENCT_TST_CB                                ((0x1c2b  << 2) + 0xff900000)
#define ENCT_TST_CR                                ((0x1c2c  << 2) + 0xff900000)
#define ENCT_TST_CLRBAR_STRT                       ((0x1c2d  << 2) + 0xff900000)
#define ENCT_TST_CLRBAR_WIDTH                      ((0x1c2e  << 2) + 0xff900000)
#define ENCT_TST_VDCNT_STSET                       ((0x1c2f  << 2) + 0xff900000)
// Program video control signals from ENCP core to DVI/HDMI interface
#define ENCP_DVI_HSO_BEGIN                         ((0x1c30  << 2) + 0xff900000)
#define ENCP_DVI_HSO_END                           ((0x1c31  << 2) + 0xff900000)
#define ENCP_DVI_VSO_BLINE_EVN                     ((0x1c32  << 2) + 0xff900000)
#define ENCP_DVI_VSO_BLINE_ODD                     ((0x1c33  << 2) + 0xff900000)
#define ENCP_DVI_VSO_ELINE_EVN                     ((0x1c34  << 2) + 0xff900000)
#define ENCP_DVI_VSO_ELINE_ODD                     ((0x1c35  << 2) + 0xff900000)
#define ENCP_DVI_VSO_BEGIN_EVN                     ((0x1c36  << 2) + 0xff900000)
#define ENCP_DVI_VSO_BEGIN_ODD                     ((0x1c37  << 2) + 0xff900000)
#define ENCP_DVI_VSO_END_EVN                       ((0x1c38  << 2) + 0xff900000)
#define ENCP_DVI_VSO_END_ODD                       ((0x1c39  << 2) + 0xff900000)
#define ENCP_DE_H_BEGIN                            ((0x1c3a  << 2) + 0xff900000)
#define ENCP_DE_H_END                              ((0x1c3b  << 2) + 0xff900000)
#define ENCP_DE_V_BEGIN_EVEN                       ((0x1c3c  << 2) + 0xff900000)
#define ENCP_DE_V_END_EVEN                         ((0x1c3d  << 2) + 0xff900000)
#define ENCP_DE_V_BEGIN_ODD                        ((0x1c3e  << 2) + 0xff900000)
#define ENCP_DE_V_END_ODD                          ((0x1c3f  << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCI_SYNC_LINE_LENGTH                      ((0x1c40  << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCI_SYNC_PIXEL_EN                         ((0x1c41  << 2) + 0xff900000)
// Bit 15 - enci_sync_enable
// Bit 14 - encp_sync_enable
// Bit 13 - enct_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCI_SYNC_TO_LINE_EN                       ((0x1c42  << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define ENCI_SYNC_TO_PIXEL                         ((0x1c43  << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCP_SYNC_LINE_LENGTH                      ((0x1c44  << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCP_SYNC_PIXEL_EN                         ((0x1c45  << 2) + 0xff900000)
// Bit 15 - enci_sync_enable
// Bit 14 - encp_sync_enable
// Bit 13 - enct_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCP_SYNC_TO_LINE_EN                       ((0x1c46  << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define ENCP_SYNC_TO_PIXEL                         ((0x1c47  << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCT_SYNC_LINE_LENGTH                      ((0x1c48  << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCT_SYNC_PIXEL_EN                         ((0x1c49  << 2) + 0xff900000)
// Bit 15 - enci_sync_enable
// Bit 14 - encp_sync_enable
// Bit 13 - enct_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCT_SYNC_TO_LINE_EN                       ((0x1c4a  << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define ENCT_SYNC_TO_PIXEL                         ((0x1c4b  << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCL_SYNC_LINE_LENGTH                      ((0x1c4c  << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCL_SYNC_PIXEL_EN                         ((0x1c4d  << 2) + 0xff900000)
// Bit 15 - enci_sync_enable
// Bit 14 - encp_sync_enable
// Bit 13 - enct_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCL_SYNC_TO_LINE_EN                       ((0x1c4e  << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define ENCL_SYNC_TO_PIXEL                         ((0x1c4f  << 2) + 0xff900000)
// bit    3 cfg_encp_lcd_scaler_bypass. 1=Do not scale LCD input data;
//                                      0=Scale LCD input data to y [16*4,235*4], c [16*4,240*4].
// bit    2 cfg_encp_vadj_scaler_bypass. 1=Do not scale data to enc480p_vadj;
//                                       0=Scale enc480p_vadj input data to y [16*4,235*4], c [16*4,240*4].
// bit    1 cfg_vfifo2vd_out_scaler_bypass. 1=Do not scale vfifo2vd's output vdata;
//                                          0=Scale vfifo2vd's output vdata to y [16,235], c [16,240].
// bit    0 cfg_vfifo_din_full_range. 1=Data from viu fifo is full range [0,1023];
//                                    0=Data from viu fifo is y [16*4,235*4], c [16*4,240*4].
#define ENCP_VFIFO2VD_CTL2                         ((0x1c50  << 2) + 0xff900000)
// bit 15:1 Reserved.
// bit    0 cfg_int_dvi_sel_rgb. Applicable for using on-chip hdmi tx module only. This bit controls correct bit-mapping from
//          Venc to hdmi_tx depending on whether YCbCr or RGB mode.
//                               1=Map data bit from Venc to hdmi_tx for RGB mode;
//                               0=Default. Map data bit from Venc to hdmi_tx for YCbCr mode.
#define VENC_DVI_SETTING_MORE                      ((0x1c51  << 2) + 0xff900000)
#define VENC_VDAC_DAC4_FILT_CTRL0                  ((0x1c54  << 2) + 0xff900000)
#define VENC_VDAC_DAC4_FILT_CTRL1                  ((0x1c55  << 2) + 0xff900000)
#define VENC_VDAC_DAC5_FILT_CTRL0                  ((0x1c56  << 2) + 0xff900000)
#define VENC_VDAC_DAC5_FILT_CTRL1                  ((0x1c57  << 2) + 0xff900000)
//Bit 0   filter_en
#define VENC_VDAC_DAC0_FILT_CTRL0                  ((0x1c58  << 2) + 0xff900000)
//dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
//Bit 15:8, coef1,
//Bit 7:0, coef0,
#define VENC_VDAC_DAC0_FILT_CTRL1                  ((0x1c59  << 2) + 0xff900000)
//Bit 0   filter_en
#define VENC_VDAC_DAC1_FILT_CTRL0                  ((0x1c5a  << 2) + 0xff900000)
//dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
//Bit 15:8, coef1,
//Bit 7:0, coef0,
#define VENC_VDAC_DAC1_FILT_CTRL1                  ((0x1c5b  << 2) + 0xff900000)
//Bit 0   filter_en
#define VENC_VDAC_DAC2_FILT_CTRL0                  ((0x1c5c  << 2) + 0xff900000)
//dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
//Bit 15:8, coef1,
//Bit 7:0, coef0,
#define VENC_VDAC_DAC2_FILT_CTRL1                  ((0x1c5d  << 2) + 0xff900000)
//Bit 0   filter_en
#define VENC_VDAC_DAC3_FILT_CTRL0                  ((0x1c5e  << 2) + 0xff900000)
//dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
//Bit 15:8, coef1,
//Bit 7:0, coef0,
#define VENC_VDAC_DAC3_FILT_CTRL1                  ((0x1c5f  << 2) + 0xff900000)
//===========================================================================
// ENCT registers
#define ENCT_VIDEO_EN                              ((0x1c60  << 2) + 0xff900000)
#define ENCT_VIDEO_Y_SCL                           ((0x1c61  << 2) + 0xff900000)
#define ENCT_VIDEO_PB_SCL                          ((0x1c62  << 2) + 0xff900000)
#define ENCT_VIDEO_PR_SCL                          ((0x1c63  << 2) + 0xff900000)
#define ENCT_VIDEO_Y_OFFST                         ((0x1c64  << 2) + 0xff900000)
#define ENCT_VIDEO_PB_OFFST                        ((0x1c65  << 2) + 0xff900000)
#define ENCT_VIDEO_PR_OFFST                        ((0x1c66  << 2) + 0xff900000)
//----- Video mode
#define ENCT_VIDEO_MODE                            ((0x1c67  << 2) + 0xff900000)
#define ENCT_VIDEO_MODE_ADV                        ((0x1c68  << 2) + 0xff900000)
//--------------- Debug pins
#define ENCT_DBG_PX_RST                            ((0x1c69  << 2) + 0xff900000)
#define ENCT_DBG_LN_RST                            ((0x1c6a  << 2) + 0xff900000)
#define ENCT_DBG_PX_INT                            ((0x1c6b  << 2) + 0xff900000)
#define ENCT_DBG_LN_INT                            ((0x1c6c  << 2) + 0xff900000)
//----------- Video Advanced setting
#define ENCT_VIDEO_YFP1_HTIME                      ((0x1c6d  << 2) + 0xff900000)
#define ENCT_VIDEO_YFP2_HTIME                      ((0x1c6e  << 2) + 0xff900000)
#define ENCT_VIDEO_YC_DLY                          ((0x1c6f  << 2) + 0xff900000)
#define ENCT_VIDEO_MAX_PXCNT                       ((0x1c70  << 2) + 0xff900000)
#define ENCT_VIDEO_HAVON_END                       ((0x1c71  << 2) + 0xff900000)
#define ENCT_VIDEO_HAVON_BEGIN                     ((0x1c72  << 2) + 0xff900000)
#define ENCT_VIDEO_VAVON_ELINE                     ((0x1c73  << 2) + 0xff900000)
#define ENCT_VIDEO_VAVON_BLINE                     ((0x1c74  << 2) + 0xff900000)
#define ENCT_VIDEO_HSO_BEGIN                       ((0x1c75  << 2) + 0xff900000)
#define ENCT_VIDEO_HSO_END                         ((0x1c76  << 2) + 0xff900000)
#define ENCT_VIDEO_VSO_BEGIN                       ((0x1c77  << 2) + 0xff900000)
#define ENCT_VIDEO_VSO_END                         ((0x1c78  << 2) + 0xff900000)
#define ENCT_VIDEO_VSO_BLINE                       ((0x1c79  << 2) + 0xff900000)
#define ENCT_VIDEO_VSO_ELINE                       ((0x1c7a  << 2) + 0xff900000)
#define ENCT_VIDEO_MAX_LNCNT                       ((0x1c7b  << 2) + 0xff900000)
#define ENCT_VIDEO_BLANKY_VAL                      ((0x1c7c  << 2) + 0xff900000)
#define ENCT_VIDEO_BLANKPB_VAL                     ((0x1c7d  << 2) + 0xff900000)
#define ENCT_VIDEO_BLANKPR_VAL                     ((0x1c7e  << 2) + 0xff900000)
#define ENCT_VIDEO_HOFFST                          ((0x1c7f  << 2) + 0xff900000)
#define ENCT_VIDEO_VOFFST                          ((0x1c80  << 2) + 0xff900000)
#define ENCT_VIDEO_RGB_CTRL                        ((0x1c81  << 2) + 0xff900000)
#define ENCT_VIDEO_FILT_CTRL                       ((0x1c82  << 2) + 0xff900000)
#define ENCT_VIDEO_OFLD_VPEQ_OFST                  ((0x1c83  << 2) + 0xff900000)
#define ENCT_VIDEO_OFLD_VOAV_OFST                  ((0x1c84  << 2) + 0xff900000)
#define ENCT_VIDEO_MATRIX_CB                       ((0x1c85  << 2) + 0xff900000)
#define ENCT_VIDEO_MATRIX_CR                       ((0x1c86  << 2) + 0xff900000)
#define ENCT_VIDEO_RGBIN_CTRL                      ((0x1c87  << 2) + 0xff900000)
#define ENCT_MAX_LINE_SWITCH_POINT                 ((0x1c88  << 2) + 0xff900000)
#define ENCT_DACSEL_0                              ((0x1c89  << 2) + 0xff900000)
#define ENCT_DACSEL_1                              ((0x1c8a  << 2) + 0xff900000)
//===========================================================================
// For ENCL
//===========================================================================
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define ENCL_VFIFO2VD_CTL                          ((0x1c90  << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCL_VFIFO2VD_PIXEL_START                  ((0x1c91  << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCL_VFIFO2VD_PIXEL_END                    ((0x1c92  << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCL_VFIFO2VD_LINE_TOP_START               ((0x1c93  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCL_VFIFO2VD_LINE_TOP_END                 ((0x1c94  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCL_VFIFO2VD_LINE_BOT_START               ((0x1c95  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCL_VFIFO2VD_LINE_BOT_END                 ((0x1c96  << 2) + 0xff900000)
#define ENCL_VFIFO2VD_CTL2                         ((0x1c97  << 2) + 0xff900000)
#define ENCL_TST_EN                                ((0x1c98  << 2) + 0xff900000)
#define ENCL_TST_MDSEL                             ((0x1c99  << 2) + 0xff900000)
#define ENCL_TST_Y                                 ((0x1c9a  << 2) + 0xff900000)
#define ENCL_TST_CB                                ((0x1c9b  << 2) + 0xff900000)
#define ENCL_TST_CR                                ((0x1c9c  << 2) + 0xff900000)
#define ENCL_TST_CLRBAR_STRT                       ((0x1c9d  << 2) + 0xff900000)
#define ENCL_TST_CLRBAR_WIDTH                      ((0x1c9e  << 2) + 0xff900000)
#define ENCL_TST_VDCNT_STSET                       ((0x1c9f  << 2) + 0xff900000)
//===========================================================================
// ENCL registers
#define ENCL_VIDEO_EN                              ((0x1ca0  << 2) + 0xff900000)
#define ENCL_VIDEO_Y_SCL                           ((0x1ca1  << 2) + 0xff900000)
#define ENCL_VIDEO_PB_SCL                          ((0x1ca2  << 2) + 0xff900000)
#define ENCL_VIDEO_PR_SCL                          ((0x1ca3  << 2) + 0xff900000)
#define ENCL_VIDEO_Y_OFFST                         ((0x1ca4  << 2) + 0xff900000)
#define ENCL_VIDEO_PB_OFFST                        ((0x1ca5  << 2) + 0xff900000)
#define ENCL_VIDEO_PR_OFFST                        ((0x1ca6  << 2) + 0xff900000)
//----- Video mode
#define ENCL_VIDEO_MODE                            ((0x1ca7  << 2) + 0xff900000)
#define ENCL_VIDEO_MODE_ADV                        ((0x1ca8  << 2) + 0xff900000)
//--------------- Debug pins
#define ENCL_DBG_PX_RST                            ((0x1ca9  << 2) + 0xff900000)
#define ENCL_DBG_LN_RST                            ((0x1caa  << 2) + 0xff900000)
#define ENCL_DBG_PX_INT                            ((0x1cab  << 2) + 0xff900000)
#define ENCL_DBG_LN_INT                            ((0x1cac  << 2) + 0xff900000)
//----------- Video Advanced setting
#define ENCL_VIDEO_YFP1_HTIME                      ((0x1cad  << 2) + 0xff900000)
#define ENCL_VIDEO_YFP2_HTIME                      ((0x1cae  << 2) + 0xff900000)
#define ENCL_VIDEO_YC_DLY                          ((0x1caf  << 2) + 0xff900000)
#define ENCL_VIDEO_MAX_PXCNT                       ((0x1cb0  << 2) + 0xff900000)
#define ENCL_VIDEO_HAVON_END                       ((0x1cb1  << 2) + 0xff900000)
#define ENCL_VIDEO_HAVON_BEGIN                     ((0x1cb2  << 2) + 0xff900000)
#define ENCL_VIDEO_VAVON_ELINE                     ((0x1cb3  << 2) + 0xff900000)
#define ENCL_VIDEO_VAVON_BLINE                     ((0x1cb4  << 2) + 0xff900000)
#define ENCL_VIDEO_HSO_BEGIN                       ((0x1cb5  << 2) + 0xff900000)
#define ENCL_VIDEO_HSO_END                         ((0x1cb6  << 2) + 0xff900000)
#define ENCL_VIDEO_VSO_BEGIN                       ((0x1cb7  << 2) + 0xff900000)
#define ENCL_VIDEO_VSO_END                         ((0x1cb8  << 2) + 0xff900000)
#define ENCL_VIDEO_VSO_BLINE                       ((0x1cb9  << 2) + 0xff900000)
#define ENCL_VIDEO_VSO_ELINE                       ((0x1cba  << 2) + 0xff900000)
#define ENCL_VIDEO_MAX_LNCNT                       ((0x1cbb  << 2) + 0xff900000)
#define ENCL_VIDEO_BLANKY_VAL                      ((0x1cbc  << 2) + 0xff900000)
#define ENCL_VIDEO_BLANKPB_VAL                     ((0x1cbd  << 2) + 0xff900000)
#define ENCL_VIDEO_BLANKPR_VAL                     ((0x1cbe  << 2) + 0xff900000)
#define ENCL_VIDEO_HOFFST                          ((0x1cbf  << 2) + 0xff900000)
#define ENCL_VIDEO_VOFFST                          ((0x1cc0  << 2) + 0xff900000)
#define ENCL_VIDEO_RGB_CTRL                        ((0x1cc1  << 2) + 0xff900000)
#define ENCL_VIDEO_FILT_CTRL                       ((0x1cc2  << 2) + 0xff900000)
#define ENCL_VIDEO_OFLD_VPEQ_OFST                  ((0x1cc3  << 2) + 0xff900000)
#define ENCL_VIDEO_OFLD_VOAV_OFST                  ((0x1cc4  << 2) + 0xff900000)
#define ENCL_VIDEO_MATRIX_CB                       ((0x1cc5  << 2) + 0xff900000)
#define ENCL_VIDEO_MATRIX_CR                       ((0x1cc6  << 2) + 0xff900000)
#define ENCL_VIDEO_RGBIN_CTRL                      ((0x1cc7  << 2) + 0xff900000)
#define ENCL_MAX_LINE_SWITCH_POINT                 ((0x1cc8  << 2) + 0xff900000)
#define ENCL_DACSEL_0                              ((0x1cc9  << 2) + 0xff900000)
#define ENCL_DACSEL_1                              ((0x1cca  << 2) + 0xff900000)
//
// Closing file:  venc2_regs.h
//
//`define VPP_VCBUS_BASE			     8'h1d
//
// Reading file:  vpp_regs.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// CBUS_BASE:  VPP_VCBUS_BASE = 0x1d
// -----------------------------------------------
//===========================================================================
// Video postprocessing Registers
//===========================================================================
// dummy data used in the VPP preblend and scaler
// Bit 23:16    Y
// Bit 15:8     CB
// Bit 7:0      CR
#define VPP_DUMMY_DATA                             ((0x1d00  << 2) + 0xff900000)
//input line length used in VPP
#define VPP_LINE_IN_LENGTH                         ((0x1d01  << 2) + 0xff900000)
//input Picture height used in VPP
#define VPP_PIC_IN_HEIGHT                          ((0x1d02  << 2) + 0xff900000)
//Because there are many coefficients used in the vertical filter and horizontal filters,
//indirect access the coefficients of vertical filter and horizontal filter is used.
//For vertical filter, there are 33x4 coefficients
//For horizontal filter, there are 33x4 coefficients
//Bit 15	index increment, if bit9 == 1  then (0: index increase 1, 1: index increase 2) else (index increase 2)
//Bit 14	1: read coef through cbus enable, just for debug purpose in case when we wanna check the coef in ram in correct or not
//Bit 13    if true, vertical separated coef enable
//Bit 9     if true, use 9bit resolution coef, other use 8bit resolution coef
//Bit 8:7   type of index, 00: vertical coef, 01: vertical chroma coef: 10: horizontal coef, 11: resevered
//Bit 6:0 	coef index
#define VPP_SCALE_COEF_IDX                         ((0x1d03  << 2) + 0xff900000)
//coefficients for vertical filter and horizontal filter
#define VPP_SCALE_COEF                             ((0x1d04  << 2) + 0xff900000)
//these following registers are the absolute line address pointer for output divided screen
//The output divided screen is shown in the following:
//
//  --------------------------   <------ line zero
//		.
//		.
//		.		    region0        <---------- nonlinear region or nonscaling region
//		.
//  ---------------------------
//  ---------------------------  <------ region1_startp
//		.
//		.           region1         <---------- nonlinear region
//		.
//		.
//  ---------------------------
//  ---------------------------  <------ region2_startp
//		.
//		.           region2         <---------- linear region
//		.
//		.
//  ---------------------------
//  ---------------------------  <------ region3_startp
//		.
//		.           region3         <---------- nonlinear region
//		.
//		.
//  ---------------------------
//  ---------------------------  <------ region4_startp
//		.
//		.           region4         <---------- nonlinear region or nonoscaling region
//		.
//		.
//  ---------------------------  <------ region4_endp
//Bit 28:16 region1 startp
//Bit 12:0 region2 startp
#define VPP_VSC_REGION12_STARTP                    ((0x1d05  << 2) + 0xff900000)
//Bit 28:16 region3 startp
//Bit 12:0 region4 startp
#define VPP_VSC_REGION34_STARTP                    ((0x1d06  << 2) + 0xff900000)
#define VPP_VSC_REGION4_ENDP                       ((0x1d07  << 2) + 0xff900000)
//vertical start phase step, (source/dest)*(2^24)
//Bit 27:24 integer part
//Bit 23:0	fraction part
#define VPP_VSC_START_PHASE_STEP                   ((0x1d08  << 2) + 0xff900000)
//vertical scaler region0 phase slope, Bit24 signed bit
#define VPP_VSC_REGION0_PHASE_SLOPE                ((0x1d09  << 2) + 0xff900000)
//vertical scaler region1 phase slope, Bit24 signed bit
#define VPP_VSC_REGION1_PHASE_SLOPE                ((0x1d0a  << 2) + 0xff900000)
//vertical scaler region3 phase slope, Bit24 signed bit
#define VPP_VSC_REGION3_PHASE_SLOPE                ((0x1d0b  << 2) + 0xff900000)
//vertical scaler region4 phase slope, Bit24 signed bit
#define VPP_VSC_REGION4_PHASE_SLOPE                ((0x1d0c  << 2) + 0xff900000)
//Bit 18:17     double line mode, input/output line width of vscaler becomes 2X,
//           so only 2 line buffer in this case, use for 3D line by line interleave scaling
//           bit1 true, double the input width and half input height, bit0 true, change line buffer 2 lines instead of 4 lines
//Bit 16     0: progressive output, 1: interlace output
//Bit 15     vertical scaler output line0 in advance or not for bottom field
//Bit 14:13  vertical scaler initial repeat line0 number for bottom field
//Bit 11:8   vertical scaler initial receiving  number for bottom field
//Bit 7      vertical scaler output line0 in advance or not for top field
//Bit 6:5    vertical scaler initial repeat line0 number for top field
//Bit 3:0    vertical scaler initial receiving  number for top field
#define VPP_VSC_PHASE_CTRL                         ((0x1d0d  << 2) + 0xff900000)
//Bit 31:16  vertical scaler field initial phase for bottom field
//Bit 15:0  vertical scaler field initial phase for top field
#define VPP_VSC_INI_PHASE                          ((0x1d0e  << 2) + 0xff900000)
//Bit 28:16 region1 startp
//Bit 12:0 region2 startp
#define VPP_HSC_REGION12_STARTP                    ((0x1d10  << 2) + 0xff900000)
//Bit 28:16 region3 startp
//Bit 12:0 region4 startp
#define VPP_HSC_REGION34_STARTP                    ((0x1d11  << 2) + 0xff900000)
#define VPP_HSC_REGION4_ENDP                       ((0x1d12  << 2) + 0xff900000)
//horizontal start phase step, (source/dest)*(2^24)
//Bit 27:24 integer part
//Bit 23:0	fraction part
#define VPP_HSC_START_PHASE_STEP                   ((0x1d13  << 2) + 0xff900000)
//horizontal scaler region0 phase slope, Bit24 signed bit
#define VPP_HSC_REGION0_PHASE_SLOPE                ((0x1d14  << 2) + 0xff900000)
//horizontal scaler region1 phase slope, Bit24 signed bit
#define VPP_HSC_REGION1_PHASE_SLOPE                ((0x1d15  << 2) + 0xff900000)
//horizontal scaler region3 phase slope, Bit24 signed bit
#define VPP_HSC_REGION3_PHASE_SLOPE                ((0x1d16  << 2) + 0xff900000)
//horizontal scaler region4 phase slope, Bit24 signed bit
#define VPP_HSC_REGION4_PHASE_SLOPE                ((0x1d17  << 2) + 0xff900000)
//Bit 22:21   horizontal scaler initial repeat pixel0 number0
//Bit 19:16   horizontal scaler initial receiving number0
//Bit 15:0    horizontal scaler top field initial phase0
#define VPP_HSC_PHASE_CTRL                         ((0x1d18  << 2) + 0xff900000)
// Bit 22 if true, divide VSC line length 2 as the HSC input length, otherwise VSC length length is the same as the VSC line length,
//                 just for special usage, more flexibility
// Bit 21 if true, prevsc uses lin buffer, otherwise prevsc does not use line buffer, it should be same as prevsc_en
// Bit 20 prehsc_en
// Bit 19 prevsc_en
// Bit 18 vsc_en
// Bit 17 hsc_en
// Bit 16 scale_top_en
// Bit 15 video1 scale out enable
// Bit 12 if true, region0,region4 are nonlinear regions, otherwise they are not scaling regions, for horizontal scaler
// Bit 10:8 horizontal scaler bank length
// Bit 5, vertical scaler phase field mode, if true, disable the opposite parity line output, more bandwith needed if output 1080i
// Bit 4 if true, region0,region4 are nonlinear regions, otherwise they are not scaling regions, for vertical scaler
// Bit 2:0 vertical scaler bank length
#define VPP_SC_MISC                                ((0x1d19  << 2) + 0xff900000)
// preblend video1 horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP_PREBLEND_VD1_H_START_END               ((0x1d1a  << 2) + 0xff900000)
// preblend video1 vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP_PREBLEND_VD1_V_START_END               ((0x1d1b  << 2) + 0xff900000)
// postblend video1 horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP_POSTBLEND_VD1_H_START_END              ((0x1d1c  << 2) + 0xff900000)
// postblend video1 vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP_POSTBLEND_VD1_V_START_END              ((0x1d1d  << 2) + 0xff900000)
// preblend/postblend video2 horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP_BLEND_VD2_H_START_END                  ((0x1d1e  << 2) + 0xff900000)
// preblend/postblend video2 vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP_BLEND_VD2_V_START_END                  ((0x1d1f  << 2) + 0xff900000)
// preblend horizontal size
#define VPP_PREBLEND_H_SIZE                        ((0x1d20  << 2) + 0xff900000)
// postblend horizontal size
#define VPP_POSTBLEND_H_SIZE                       ((0x1d21  << 2) + 0xff900000)
//VPP hold lines
//Bit 29:24
//Bit 21:16
//Bit 15:8     preblend hold lines
//Bit 7:0      postblend hold lines
#define VPP_HOLD_LINES                             ((0x1d22  << 2) + 0xff900000)
//Bit 26   if true, automatic change post blend output to one color if field ==1
//Bit 25   if true, change screen to one color value for preblender
//Bit 24   if true, change screen to one color value for postblender
// Bit 23:16 one color Y
// Bit 15:8 one color Cb
// Bit  7:0 one color  Cr
#define VPP_BLEND_ONECOLOR_CTRL                    ((0x1d23  << 2) + 0xff900000)
//Read Only, VPP preblend current_x, current_y
//Bit 28:16 current_x
//Bit 12:0 current_y
#define VPP_PREBLEND_CURRENT_XY                    ((0x1d24  << 2) + 0xff900000)
//Read Only, VPP postblend current_x, current_y
//Bit 28:16 current_x
//Bit 12:0 current_y
#define VPP_POSTBLEND_CURRENT_XY                   ((0x1d25  << 2) + 0xff900000)
// Bit 31  vd1_bgosd_exchange_en for preblend
// Bit 30  vd1_bgosd_exchange_en for postblend
// Bit 28   color management enable
// Bit 27,  if true, vd2 use viu2 output as the input, otherwise use normal vd2 from memory
// Bit 26:18, vd2 alpha
// Bit 17, osd2 enable for preblend
// Bit 16, osd1 enable for preblend
// Bit 15, vd2 enable for preblend
// Bit 14, vd1 enable for preblend
// Bit 13, osd2 enable for postblend
// Bit 12, osd1 enable for postblend
// Bit 11, vd2 enable for postblend
// Bit 10, vd1 enable for postblend
// Bit 9,  if true, osd1 is alpha premultiplied
// Bit 8,  if true, osd2 is alpha premultiplied
// Bit 7,  postblend module enable
// Bit 6,  preblend module enable
// Bit 5,  if true, osd2 foreground compared with osd1 in preblend
// Bit 4,  if true, osd2 foreground compared with osd1 in postblend
// Bit 3,
// Bit 2,  if true, disable resetting async fifo every vsync, otherwise every vsync
//			 the aync fifo will be reseted.
// Bit 1,
// Bit 0	if true, the output result of VPP is saturated
#define VPP_MISC                                   ((0x1d26  << 2) + 0xff900000)
//Bit 31:20 ofifo line length minus 1
//Bit 19  if true invert input vs
//Bit 18  if true invert input hs
//Bit 17  force top/bottom field, enable
//Bit 16  force top/bottom field, 0: top, 1: bottom
//Bit 15  force one go_field, one pluse, write only
//Bit 14  force one go_line, one pluse, write only
//Bit 12:0 ofifo size (actually only bit 10:1 is valid), always even number
#define VPP_OFIFO_SIZE                             ((0x1d27  << 2) + 0xff900000)
//Read only
//Bit 28:18 current scale out fifo counter
//Bit 17:13 current afifo counter
//Bit 12:0 current ofifo counter
#define VPP_FIFO_STATUS                            ((0x1d28  << 2) + 0xff900000)
// Bit 5 SMOKE3 postblend enable only when postblend vd2 is not enable
// Bit 4 SMOKE3 preblend enable only when preblend vd2 is not enable
// Bit 3 SMOKE2 postblend enable only when postblend osd2 is not enable
// Bit 2 SMOKE2 preblend enable only when preblend osd2 is not enable
// Bit 1 SMOKE1 postblend enable only when postblend osd1 is not enable
// Bit 0 SMOKE1 preblend enable only when preblend osd1 is not enable
#define VPP_SMOKE_CTRL                             ((0x1d29  << 2) + 0xff900000)
//smoke can be used only when that blending is disable and then be used as smoke function
//smoke1 for OSD1 channel
//smoke2 for OSD2 channel
//smoke3 for VD2 channel
//31:24 Y
//23:16 Cb
//15:8 Cr
//7:0 Alpha
#define VPP_SMOKE1_VAL                             ((0x1d2a  << 2) + 0xff900000)
#define VPP_SMOKE2_VAL                             ((0x1d2b  << 2) + 0xff900000)
#define VPP_SMOKE3_VAL                             ((0x1d2c  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP_SMOKE1_H_START_END                     ((0x1d2d  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP_SMOKE1_V_START_END                     ((0x1d2e  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP_SMOKE2_H_START_END                     ((0x1d2f  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP_SMOKE2_V_START_END                     ((0x1d30  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP_SMOKE3_H_START_END                     ((0x1d31  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP_SMOKE3_V_START_END                     ((0x1d32  << 2) + 0xff900000)
//Bit 27:16 scale out fifo line length minus 1
//Bit 12:0 scale out fifo size (actually only bit 11:1 is valid, 11:1, max 1024), always even number
#define VPP_SCO_FIFO_CTRL                          ((0x1d33  << 2) + 0xff900000)
//for 3D quincunx sub-sampling and horizontal pixel by pixel 3D interleaving
//Bit 27:24, prehsc_mode, bit 3:2, prehsc odd line interp mode, bit 1:0, prehsc even line interp mode,
//           each 2bit, 00: pix0+pix1/2, average, 01: pix1, 10: pix0
//Bit 23 horizontal scaler double pixel mode
//Bit 22:21   horizontal scaler initial repeat pixel0 number1
//Bit 19:16   horizontal scaler initial receiving number1
//Bit 15:0    horizontal scaler top field initial phase1
#define VPP_HSC_PHASE_CTRL1                        ((0x1d34  << 2) + 0xff900000)
//for 3D quincunx sub-sampling
//31:24  prehsc pattern, each patten 1 bit, from lsb -> msb
//22:20  prehsc pattern start
//18:16 prehsc pattern end
//15:8 hsc pattern, each patten 1 bit, from lsb -> msb
//6:4  hsc pattern start
//2:0  hsc pattern end
#define VPP_HSC_INI_PAT_CTRL                       ((0x1d35  << 2) + 0xff900000)
//Bit 3			minus black level enable for vadj2
//Bit 2			Video adjustment enable for vadj2
//Bit 1			minus black level enable for vadj1
//Bit 0			Video adjustment enable for vadj1
#define VPP_VADJ_CTRL                              ((0x1d40  << 2) + 0xff900000)
//Bit 16:8  brightness, signed value
//Bit 7:0	contrast, unsigned value, contrast from  0 <= contrast <2
#define VPP_VADJ1_Y                                ((0x1d41  << 2) + 0xff900000)
//cb' = cb*ma + cr*mb
//cr' = cb*mc + cr*md
//all are bit 9:0, signed value, -2 < ma/mb/mc/md < 2
#define VPP_VADJ1_MA_MB                            ((0x1d42  << 2) + 0xff900000)
#define VPP_VADJ1_MC_MD                            ((0x1d43  << 2) + 0xff900000)
//Bit 16:8  brightness, signed value
//Bit 7:0	contrast, unsigned value, contrast from  0 <= contrast <2
#define VPP_VADJ2_Y                                ((0x1d44  << 2) + 0xff900000)
//cb' = cb*ma + cr*mb
//cr' = cb*mc + cr*md
//all are bit 9:0, signed value, -2 < ma/mb/mc/md < 2
#define VPP_VADJ2_MA_MB                            ((0x1d45  << 2) + 0xff900000)
#define VPP_VADJ2_MC_MD                            ((0x1d46  << 2) + 0xff900000)
//Bit 2 horizontal chroma sharp/blur selection, 0:sharp, 1: blur
//Bit 1 horizontal luma sharp/blur selection, 0:sharp, 1: blur
//Bit 0 horizontal sharpness enable
#define VPP_HSHARP_CTRL                            ((0x1d50  << 2) + 0xff900000)
//{1'b0,threshold} < diff
//Bit 26:16  luma threshold0
//Bit 10:0   luma threshold1
#define VPP_HSHARP_LUMA_THRESH01                   ((0x1d51  << 2) + 0xff900000)
//
//Bit 26:16  luma threshold2
//Bit 10:0   luma threshold3
#define VPP_HSHARP_LUMA_THRESH23                   ((0x1d52  << 2) + 0xff900000)
//Bit 26:16  chroma threshold0
//Bit 10:0   chroma threshold1
#define VPP_HSHARP_CHROMA_THRESH01                 ((0x1d53  << 2) + 0xff900000)
//Bit 26:16  chroma threshold2
//Bit 10:0   chroma threshold3
#define VPP_HSHARP_CHROMA_THRESH23                 ((0x1d54  << 2) + 0xff900000)
//Bit 23:16 luma gain2
//Bit 15:8  luma gain1
//Bit 7:0   luma gain0
#define VPP_HSHARP_LUMA_GAIN                       ((0x1d55  << 2) + 0xff900000)
//
//Bit 23:16 chroma gain2
//Bit 15:8  chroma gain1
//Bit 7:0   chroma gain0
#define VPP_HSHARP_CHROMA_GAIN                     ((0x1d56  << 2) + 0xff900000)
//Read only
//Bit 31, if it is true, it means this probe is valid in the last field/frame
//Bit 29:20 component 0
//Bit 19:10 component 1
//Bit 9:0 component 2
#define VPP_MATRIX_PROBE_COLOR                     ((0x1d5c  << 2) + 0xff900000)
#define VPP_MATRIX_PROBE_COLOR1                    ((0x1dd7  << 2) + 0xff900000)
//Bit 23:16 component 0
//Bit 15:8  component 1
//Bit 7:0 component 2
#define VPP_MATRIX_HL_COLOR                        ((0x1d5d  << 2) + 0xff900000)
//28:16 probe x, postion
//12:0  probe y, position
#define VPP_MATRIX_PROBE_POS                       ((0x1d5e  << 2) + 0xff900000)
//Bit 16,  highlight_en
//Bit 15   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before matrix
//Bit 14:12 probe_sel, 000: select post matrix, 001: select vd1 matrix, 010: select vd2 matrix
//Bit 9:8  matrix coef idx selection, 00: select post matrix, 01: select vd1 matrix, 10: select vd2 matrix
//Bit 5    vd1 conversion matrix enable
//Bit 4    vd2 conversion matrix enable
//Bit 2    output y/cb/cr saturation enable, only for post matrix (y saturate to 16-235, cb/cr saturate to 16-240)
//Bit 1    input y/cb/cr saturation enable, only for post matrix (y saturate to 16-235, cb/cr saturate to 16-240)
//Bit 0    post conversion matrix enable
#define VPP_MATRIX_CTRL                            ((0x1d5f  << 2) + 0xff900000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define VPP_MATRIX_COEF00_01                       ((0x1d60  << 2) + 0xff900000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define VPP_MATRIX_COEF02_10                       ((0x1d61  << 2) + 0xff900000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define VPP_MATRIX_COEF11_12                       ((0x1d62  << 2) + 0xff900000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define VPP_MATRIX_COEF20_21                       ((0x1d63  << 2) + 0xff900000)
#define VPP_MATRIX_COEF22                          ((0x1d64  << 2) + 0xff900000)
//Bit 26:16 offset0
//Bit 10:0  offset1
#define VPP_MATRIX_OFFSET0_1                       ((0x1d65  << 2) + 0xff900000)
//Bit 10:0  offset2
#define VPP_MATRIX_OFFSET2                         ((0x1d66  << 2) + 0xff900000)
//Bit 26:16 pre_offset0
//Bit 10:0  pre_offset1
#define VPP_MATRIX_PRE_OFFSET0_1                   ((0x1d67  << 2) + 0xff900000)
//Bit 10:0  pre_offset2
#define VPP_MATRIX_PRE_OFFSET2                     ((0x1d68  << 2) + 0xff900000)
// dummy data used in the VPP postblend
// Bit 23:16    Y
// Bit 15:8     CB
// Bit 7:0      CR
#define VPP_DUMMY_DATA1                            ((0x1d69  << 2) + 0xff900000)
//Bit 31 gainoff module enable
//Bit 26:16 gain0, 1.10 unsigned data
//Bit 10:0  gain1, 1.10 unsigned dat
#define VPP_GAINOFF_CTRL0                          ((0x1d6a  << 2) + 0xff900000)
//Bit 26:16 gain2, 1.10 unsigned data
//Bit 10:0, offset0, signed data
#define VPP_GAINOFF_CTRL1                          ((0x1d6b  << 2) + 0xff900000)
//Bit 26:16, offset1, signed data
//Bit 10:0, offset2, signed data
#define VPP_GAINOFF_CTRL2                          ((0x1d6c  << 2) + 0xff900000)
//Bit 26:16, pre_offset0, signed data
//Bit 10:0, pre_offset1, signed data
#define VPP_GAINOFF_CTRL3                          ((0x1d6d  << 2) + 0xff900000)
//Bit 10:0, pre_offset2, signed data
#define VPP_GAINOFF_CTRL4                          ((0x1d6e  << 2) + 0xff900000)
//only two registers used in the color management, which are defined in the chroma_reg.h
//`define VPP_CHROMA_ADDR_PORT    8'h70
//`define VPP_CHROMA_DATA_PORT    8'h71
//
// Reading file:  chroma_reg.h
//
//**********************************************************************************
//* Copyright (c) 2008, AMLOGIC Inc.
//* All rights reserved
//**********************************************************************************
//* File :  chroma_reg.v
//* Author : Terrence Wang
//* Date : Dec 2008
//* Description :
//*
//**********************************************************************************
//* Modification History:
//* Date    Modified By         Reason
//**********************************************************************************
// synopsys translate_off
// synopsys translate_on
#define VPP_CHROMA_ADDR_PORT                       ((0x1d70  << 2) + 0xff900000)
#define VPP_CHROMA_DATA_PORT                       ((0x1d71  << 2) + 0xff900000)
//`define CHROMA_ADDR_PORT        8'h67
//`define CHROMA_DATA_PORT        8'h68

//  CHROMA_GAIN_REG_XX(00-07)
//  hue gain, sat gain function control
//  Bit 31      reg_sat_en                  enable sat adjustment in current region
//  Bit 27      reg_sat_increase            sat adjustment increase or decrease
//                                          1'b1: increase  1'b0: decrease
//  Bit 26:25   reg_sat_central_en          sat adjustment with central biggest or one side biggest
//                                          2'b01 central biggest   2'b00 one side biggest
//  Bit 24      reg_sat_shape               when sat adjustment one side biggest, define left or right
//                                          1'b1: left side biggest 1'b0 right side biggest
//  Bit 23:16   reg_sat_gain                define the sat gain when sat adjustment
//                                          0x00-0xff
//  Bit 15      reg_hue_en                  enable hue adjustment in current region
//  Bit 11      reg_hue_clockwise           hue adjustment clockwise or anti-clockwise
//                                          1'b1: clockwise 1'b0: anti-clockwise
//  Bit 10:9    reg_hue_central_en          when hue adjustment, parabola curve or non-symmetry curve
//                                          1'b1: parabola curve    1'b0: non-symmetry curve
//  Bit 8       reg_hue_shape               when non-symmetry curve, define which side change more
//                                          1'b1: right side change more    1'b0: left side change more
//  Bit 7:0     reg_hue_gain                define the hue gain when hue adjustment
//                                          0x00-0x80, note: should be no bigger than 0x80

    #define CHROMA_GAIN_REG00       0x00


//  HUE_HUE_RANGE_REG_XX(00-07)
//  hue range select
//  Bit 31:24   no use now
//  Bit 23:16   reg_hue_shift_range         define the angle of target region
//                                          0x00-0xff,(0x100 means 120 degree though it can not be set)
//                                          must be greater or equal than 8'd8
//  Bit 15      reg_symmetry_en             this is used for create one symmetry region
//                                          the symmetry region hue_shift_start = reg_hue_hue_shift_start + reg_hue_shift_range<<5
//                                          the symmetry region hue_shift_range = reg_hue_shift_range
//                                          in symmetry region, all the sat and hue setting will be same with original region,
//                                          except reg_hue_shape, reg_sat_shape, reg_hue_clockwise will be reversed
//  Bit 14:0    reg_hue_hue_shift_start     define the start angle of target region
//                                          0x6000 means 360 degree
//                                          only region 0 and 1 can exceed 360 degrees.

    #define HUE_HUE_RANGE_REG00     0x01


//  HUE_RANGE_INV_REG_XX
//  Calculation should be follow
//  HUE_RANGE_INV_REG0X[15:0] = ((1<<20)/HUE_HUE_RANGE_REG0X[23:16]+1)>>1
//  HUE_RANGE_INV_REG_XX is to used to save divider

    #define HUE_RANGE_INV_REG00     0x02



//  for belowing each low, high, low_slope, high_slope group:
//            a_____________b
//            /             \               a = low  + 2^low_slope
//           /               \              b = high - 2^high_slope
//          /                 \             low_slope <= 7; high_slope <= 7
//         /                   \            b >= a
//  ______/_____________________\________
//       low                    high
//
//
//  HUE_LUM_RANGE_REG_XX(00-07)
//  luma range selection for hue adjustment
//  Bit 31:24   reg_sat_lum_low             define the low level of luma value for sat adjustment
//                                          0x00-0xff
//  Bit 23:20   reg_hue_lum_high_slope      define the slope area below high level of luma value for hue adjustment
//                                          0x00-0x07
//  Bit 19:16   reg_hue_lum_low_slope       define the slope area above low  level of luma value for hue adjustment
//                                          0x00-0x07
//  Bit 15:8    reg_hue_lum_high            define the high level of luma value for hue adjustment
//                                          0x00-0xff
//  Bit 7:0     reg_hue_lum_low             define the low  level of luma value for hue adjustment
//                                          0x00-0xff

    #define HUE_LUM_RANGE_REG00     0x03

//  HUE_SAT_RANGE_REG_XX(00-07)
//  sat range selection for hue adjustment
//  Bit 31:24   reg_sat_lum_high            define the high level of luma value for sat adjustment
//                                          0x00-0xff
//  Bit 23:20   reg_hue_sat_high_slope      define the slope area below high level of sat value for hue adjustment
//                                          0x00-0x07
//  Bit 19:16   reg_hue_sat_low_slope       define the slope area above low  level of sat value for hue adjustment
//                                          0x00-0x07
//  Bit 15:8    reg_hue_sat_high            define the high level of sat value for hue adjustment
//                                          0x00-0xff
//  Bit 7:0     reg_hue_sat_low             define the low  level of sat value for hue adjustment
//                                          0x00-0xff

    #define HUE_SAT_RANGE_REG00     0x04

//  SAT_SAT_RANGE_REG_XX(00-07)
//  sat range selection for hue adjustment
//  Bit 31:28   reg_sat_lum_high_slope      define the slope area below high level of luma value for sat adjustment
//                                          0x00-0x07
//  Bit 27:24   reg_sat_lum_low_slope       define the slope area above low  level of luma value for sat adjustment
//                                          0x00-0x07
//  Bit 23:20   reg_sat_sat_high_slope      define the slope area below high level of sat value for sat adjustment
//                                          0x00-0x07
//  Bit 19:16   reg_sat_sat_low_slope       define the slope area above low  level of sat value for sat adjustment
//                                          0x00-0x07
//  Bit 15:8    reg_sat_sat_high            define the high level of sat value for sat adjustment
//                                          0x00-0xff
//  Bit 7:0     reg_sat_sat_low             define the low  level of sat value for sat adjustment
//                                          0x00-0xff

    #define SAT_SAT_RANGE_REG00     0x05


    #define CHROMA_GAIN_REG01       0x06
    #define HUE_HUE_RANGE_REG01     0x07
    #define HUE_RANGE_INV_REG01     0x08
    #define HUE_LUM_RANGE_REG01     0x09
    #define HUE_SAT_RANGE_REG01     0x0a
    #define SAT_SAT_RANGE_REG01     0x0b

    #define CHROMA_GAIN_REG02       0x0c
    #define HUE_HUE_RANGE_REG02     0x0d
    #define HUE_RANGE_INV_REG02     0x0e
    #define HUE_LUM_RANGE_REG02     0x0f
    #define HUE_SAT_RANGE_REG02     0x10
    #define SAT_SAT_RANGE_REG02     0x11


    #define CHROMA_GAIN_REG03       0x12
    #define HUE_HUE_RANGE_REG03     0x13
    #define HUE_RANGE_INV_REG03     0x14
    #define HUE_LUM_RANGE_REG03     0x15
    #define HUE_SAT_RANGE_REG03     0x16
    #define SAT_SAT_RANGE_REG03     0x17

    #define CHROMA_GAIN_REG04       0x18
    #define HUE_HUE_RANGE_REG04     0x19
    #define HUE_RANGE_INV_REG04     0x1a
    #define HUE_LUM_RANGE_REG04     0x1b
    #define HUE_SAT_RANGE_REG04     0x1c
    #define SAT_SAT_RANGE_REG04     0x1d

    #define CHROMA_GAIN_REG05       0x1e
    #define HUE_HUE_RANGE_REG05     0x1f
    #define HUE_RANGE_INV_REG05     0x20
    #define HUE_LUM_RANGE_REG05     0x21
    #define HUE_SAT_RANGE_REG05     0x22
    #define SAT_SAT_RANGE_REG05     0x23

    #define CHROMA_GAIN_REG06       0x24
    #define HUE_HUE_RANGE_REG06     0x25
    #define HUE_RANGE_INV_REG06     0x26
    #define HUE_LUM_RANGE_REG06     0x27
    #define HUE_SAT_RANGE_REG06     0x28
    #define SAT_SAT_RANGE_REG06     0x29

    #define CHROMA_GAIN_REG07       0x2a
    #define HUE_HUE_RANGE_REG07     0x2b
    #define HUE_RANGE_INV_REG07     0x2c
    #define HUE_LUM_RANGE_REG07     0x2d
    #define HUE_SAT_RANGE_REG07     0x2e
    #define SAT_SAT_RANGE_REG07     0x2f

//  REG_CHROMA_CONTROL
//  Bit 31      reg_chroma_en               enable color manage function
//                                          1'b1: enable    1'b0: bypass
//  Bit 6       sat_sel                     uv_max or u^2+v^2 selected as sat for reference
//                                          1'b1: uv_max(default)   1'b0: u^2+v^2
//  Bit 5       uv_adj_en                   final uv_adjust enable
//                                          1'b1: enable    1'b0: bypass
//  Bit 2       hue_en                      rgb to hue enable
//                                          1'b1: enable(default)   1'b0: bypass
//  Bit 1:0     csc_sel                     define input YUV with different color type
//                                          2'b00: 601(16-235)  2'b01: 709(16-235)
//                                          2'b10: 601(0-255)   2'b11: 709(0-255)
    #define REG_CHROMA_CONTROL      0x30   // default 32h'80000024
    #define REG_DEMO_CENTER_BAR     0x31   // default 32h'0
    #define REG_DEMO_HLIGHT_MODE    0x32   // default 32h'0
    #define REG_DEMO_OWR_DATA       0x33   // default 32h'0


////===========================================////
//// CM2 ADDR
////===========================================////

    #define SAT_BYYB_NODE_REG0          0x200   // default 32'h0
//Bit 31:24, sat_byyb_node3    the 4th node
//Bit 23:16, sat_byyb_node2    the 3th node
//Bit 15: 8, sat_byyb_node1    signed, the 2th node about saturation
//Bit  7: 0, sat_byyb_node0    signed, the 1th node about saturation
//gain offset along y coordinate,the gain normalized to 128 as "1"

	#define SAT_BYYB_NODE_REG1          0x201   // default 32'h0
//Bit 31:24, sat_byyb_node7     the 8th node
//Bit 23:16, sat_byyb_node6     the 7th node
//Bit 15: 8, sat_byyb_node5     signed, the 6th node about saturation
//Bit  7: 0, sat_byyb_node4     signed, the 5th node about saturation
//gain offset along y coordinate,the gain normalized to 128 as "1"

    #define SAT_BYYB_NODE_REG2          0x202   // default 32'h0
//Bit 31: 8, reserved
//Bit  7: 0, sat_byyb_node4     signed, the 5th node about saturation


    #define SAT_SRC_NODE_REG            0x203   // default 32'h0
//Bit 31:28, reserved
//Bit 27:16, sat_src_node1
//Bit 15:12, reserved
//Bit 11: 0, sat_src_node0     usigned, threshold of input saturation for  first and second piece

    #define CM_ENH_SFT_MODE_REG         0x204   // default 32'h0
//Bit 31: 9, reserved
//Bit  8: 6, hue_lsft_mode        hue offset adjustments scale
//Bit  5: 4, luma_lsft_mode       luma offset adjustments scale for reg_cm2_adj_luma_via_hue
//Bit  3: 2, sat_byy_rsft_mode    saturation gain adjustments scale for reg_cm2_adj_sat_via_y
//Bit  1: 0, sat_byhs_rsft_mode   saturation gain adjustments scale for reg_cm2_adj_sat_via_hs[:][:] 0:no scale up/down 1:dnscale by 2(-128,127)/2

    #define FRM_SIZE_REG                0x205   // default 32'h0
//Bit 31:29, reserved
//Bit 28:16, reg_frm_height       the frame height size
//Bit 15:13, reserved
//Bit 12: 0, reg_frm_width        the frame width size

    #define FITLER_CFG_REG              0x206   // default 32'h0
//Bit 31: 5, reserved
//Bit  4: 4, inteleav_mod         horizontal interleave filter(zero-padding) for 3D considerations 0:using non-zero padding lpf 1:using zero-padding lpf
//Bit  3: 2, lpf_slt_uv           apply cm on lp portion or original video pixels options
//Bit  1: 0, lpf_slt_y            apply cm on lp portion or original video pixels options

    #define CM_GLOBAL_GAIN_REG          0x207   // default 32'h0
//Bit 31:28, reserved
//Bit 27:16, cm2_global_sat     global saturation gain for general color adjustments(0~4095 <=> 0~8),512 normalized to "1"
//Bit 15:12, reserved
//Bit 11: 0, cm2_global_hue     global hue offsets for general color adjustments(0~4095 <=> 0~360 degree)

    #define CM_ENH_CTL_REG              0x208   // default 32'h0
//Bit  31:7, reserved
//Bit     6, hue_adj_en        cm2 hue adjustments
//Bit     5, sat_adj_en        cm2 saturation adjustments
//Bit     4, luma_adj_en       enable signal for cm2 luma adjustments
//Bit     3, reserved
//Bit     2, cm2_filt_en       apply cm on lp portion enable
//Bit     1, cm2_en            cm2 enable signal
//Bit     0, cm1_en

    #define ROI_X_SCOPE_REG             0x209   // default 32'h0
//Bit 31:29, reserved
//Bit 28:16, roi_x_end      ending col index of the region of interest
//Bit 15:13, reserved
//Bit 12: 0, roi_x_beg      start col index of the region of interest

   #define ROI_Y_SCOPE_REG             0x20a   // default 32'h0
//Bit 31:29, reserved
//Bit 28:16, roi_y_end      ending row index of the region of interest
//Bit 15:13, reserved
//Bit 12: 0, roi_y_beg      start row index of the region of interest

    #define POI_XY_DIR_REG              0x20b   // default 32'h0
//Bit 31:29, reserved
//Bit 28:16, poi_y_dir      ending row index of the region of interest
//Bit 15:13, reserved
//Bit 12: 0, poi_x_dir      start row index of the region of interest

    #define COI_Y_SCOPE_REG             0x20c   // default 32'h0
//Bit 31:16, reserved
//Bit 15: 8, coi_y_end
//Bit  7: 0, coi_y_beg

    #define COI_H_SCOPE_REG             0x20d   // default 32'h0
//Bit 31:28, reserved
//Bit 27:16, coi_h_end
//Bit 15:12, reserved
//Bit 11: 0, coi_h_beg        lower bound of hue value for color of interest ,12 bits precision

    #define COI_S_SCOPE_REG             0x20e   // default 32'h0
//Bit 31:28, reserved
//Bit 27:16, coi_s_end
//Bit 15:12, reserved
//Bit 11: 0, coi_s_beg        lower bound of sat value for color of interest ,12 bits precision
    #define IFO_MODE_REG                0x20f   // default 32'h0
//Bit 31:8, reserved
//Bit  7:6, ifo_mode3
//Bit  5:4, ifo_mode2
//Bit  3:2, ifo_mode1
//Bit  1:0, ifo_mode0
    #define POI_RPL_MODE_REG            0x210   // default 32'h0
//Bit 31:4, reserved
//Bit  3:0, poi_rpl_mode          enhance mode control of pixels inside and outside region of interest bit[3:2]control roi
    #define DEMO_OWR_YHS_REG            0x211   // default 32'h0
//Bit 31: 0, demo_owr_yhs

    #define DEMO_POI_Y_REG              0x212   // default 32'h0
//Bit 31: 8, reserved
//Bit  7: 0, luma_data_poi_r       only get locked higher 8bits
    #define DEMO_POI_H_REG              0x213   // default 32'h0
//Bit 31: 12, reserved
//Bit 11: 0, hue_data_poi_r        only get locked higher 12bits
    #define DEMO_POI_S_REG              0x214   // default 32'h0
//Bit 31: 12, reserved
//Bit 11: 0, sat_data_poi_r         only get locked higher 12bits
    //#define LUMA_BYH_LIMT_REG           0x215   // default 32'h0
    #define LUMA_ADJ_LIMT_REG           0x215   // default 32'h0
//Bit 31:24, reserved
//Bit 23:16, luma_lmt_satslp         slope to do the luma adjustment degrade
//Bit 15:12, reserved
//Bit 11:0, luma_lmt_satth           threshold to saturation
    #define SAT_ADJ_LIMT_REG            0x216   // default 32'h0
//Bit 31:24, reserved
//Bit 23:16, sat_lmt_satslp        slope to do the adjustment degrade
//Bit 15:12, reserved
//Bit 11:0, sat_lmt_satth          threshold to saturation
    #define HUE_ADJ_LIMT_REG            0x217   // default 32'h0
//Bit 31: 24, reserved
//Bit 23: 16, hue_lmt_satslp        slope to do the adjustment degrade
//Bit 15: 12, reserved
//Bit 11: 0,  hue_lmt_satth          threshold to saturation
    #define UVHS_OFST_REG               0x218   // default 32'h0
//Bit 31: 24, hs2uv_v_ofst
//Bit 23: 16, hs2uv_u_ofst
//Bit 15: 8,  uv2hs_v_ofst
//Bit  7: 0,  uv2hs_u_ofst
    #define HUE_CFG_PARA_REG            0x219   // default 32'h0
//Bit 31: 17, reserved
//Bit     16, hue_protect_en
//Bit 15: 13, cm2_hue_byhs_mode
//Bit     12, cm2_hue_div_mode
//Bit 11: 0, cm2_before_hue_ofst
    #define DEMO_SPLT_CFG_REG           0x21a   // default 32'h0
//Bit 31: 22, reserved
//Bit 21: 20, demo_split_mode
//Bit 19: 16, demo_split_width        slope to do the adjustment degrade
//Bit 15: 13, reserved
//Bit 12: 0,  demo_split_post           threshold to saturation
    #define DEMO_SPLT_YHS_REG           0x21b   // default 32'h0
//Bit 31: 0,  demo_splt_yhs             threshold to saturation

    #define XVYCC_YSCP_REG              0x21c   // default 32'h0
//Bit 31: 28, reserved
//Bit 27: 16, xvycc_y_max
//Bit 15: 12, reserved
//Bit 11: 0, xvycc_y_min
    #define XVYCC_USCP_REG              0x21d   // default 32'h0
//Bit 31: 28, reserved
//Bit 27: 16, xvycc_u_max
//Bit 15: 12, reserved
//Bit 11: 0, xvycc_u_min
    #define XVYCC_VSCP_REG              0x21e   // default 32'h0
//Bit 31: 28, reserved
//Bit 27: 16, xvycc_v_max
//Bit 15: 12, reserved
//Bit 11: 0, xvycc_v_min

////========= NODE 0 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H00      0x100   // default 32'H0
//Bit 31: 24, reg_cm2_adj_sat_via_hs_2
//Bit 23: 16, reg_cm2_adj_sat_via_hs_1
//Bit 15: 8,  reg_cm2_adj_sat_via_hs_0
//Bit  7: 0, reg_cm2_adj_luma_via_h
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H00      0x101   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H00      0x102   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H00      0x103   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H00      0x104   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 1 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H01      0x108   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H01      0x109   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H01      0x10a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H01      0x10b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H01      0x10c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 2 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H02      0x110   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H02      0x111   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H02      0x112   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H02      0x113   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H02      0x114   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 3 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H03      0x118   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H03      0x119   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H03      0x11a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H03      0x11b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H03      0x11c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 4 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H04      0x120   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H04      0x121   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H04      0x122   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H04      0x123   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H04      0x124   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 5 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H05      0x128   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H05      0x129   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H05      0x12a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H05      0x12b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H05      0x12c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 6 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H06      0x130   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H06      0x131   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H06      0x132   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H06      0x133   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H06      0x134   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 7 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H07      0x138   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H07      0x139   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H07      0x13a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H07      0x13b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H07      0x13c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 8 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H08      0x140   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H08      0x141   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H08      0x142   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H08      0x143   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H08      0x144   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 9 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H09      0x148   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H09      0x149   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H09      0x14a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H09      0x14b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H09      0x14c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 10 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H10      0x150   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H10      0x151   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H10      0x152   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H10      0x153   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H10      0x154   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 11 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H11      0x158   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H11      0x159   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H11      0x15a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H11      0x15b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H11      0x15c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 12 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H12      0x160   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H12      0x161   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H12      0x162   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H12      0x163   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H12      0x164   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 13 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H13      0x168   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H13      0x169   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H13      0x16a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H13      0x16b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H13      0x16c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx


/* Constraints
0)
  there are 16 regions totally. 8 regions are for hue adjustment, 8 regions are for sat adjustment.
  the hue range of the 16 regions can be set to overlap, but if overlap, the hue range(start and end) must be same.
  the 8 regions for hue adjustment should not overlap. if corresponding reg_hue_en_00 - 07 == 1
  the 8 regions for hue adjustment are defined by: (example are for region 0)
    a) hue:
        start: reg_hue_hue_shift_start_00[14:0]
        end:
        if reg_symmetry_en_00 == 0
        reg_hue_hue_shift_start_00[14:0] + (reg_hue_hue_shift_range_00[7:0]<<5)
        if reg_symmetry_en_00 == 1
        reg_hue_hue_shift_start_00[14:0] + (reg_hue_hue_shift_range_00[7:0]<<6)
    b) sat:
        start: reg_hue_sat_low_00
        end:   reg_hue_sat_high_00

  the 8 regions for sat adjustment should not overlap. if corresponding reg_sat_en_00 - 07 == 1
  the 8 regions for sat adjustment are defined by: (example are for region 0)
    a) hue: same as that for hue adjustment.
        start: reg_hue_hue_shift_start_00[14:0]
        end:
        if reg_symmetry_en_00 == 0
        reg_hue_hue_shift_start_00[14:0] + (reg_hue_hue_shift_range_00[7:0]<<5)
        if reg_symmetry_en_00 == 1
        reg_hue_hue_shift_start_00[14:0] + (reg_hue_hue_shift_range_00[7:0]<<6)
    b) sat:
        start: reg_sat_sat_low_00
        end:   reg_sat_sat_high_00

1)
  reg_hue_hue_shift_range_00[7:0]:
  reg_hue_hue_shift_range_01[7:0]:
  reg_hue_hue_shift_range_02[7:0]:
  reg_hue_hue_shift_range_03[7:0]:
  reg_hue_hue_shift_range_04[7:0]:
  reg_hue_hue_shift_range_05[7:0]:
  reg_hue_hue_shift_range_06[7:0]:
  reg_hue_hue_shift_range_07[7:0]:
  must be greater or equal than 8'd8, so as reg_hue_range_inv_regxx can be represented by 0.0000_0000_xxxx_xxxx_xxxx_xxxx

2)
  all regions of 0-7 should meet below requirement. below is just an example for region 7.
  (reg_hue_lum_high_07 - reg_hue_lum_low_07) >=
        (1<<reg_hue_lum_low_slope_07) + (1<<reg_hue_lum_high_slope_07)

  (reg_hue_sat_high_07 - reg_hue_sat_low_07) >=
        (1<<reg_hue_sat_low_slope_07) + (1<<reg_hue_sat_high_slope_07)

  (reg_sat_lum_high_07 - reg_sat_lum_low_07) >=
        (1<<reg_sat_lum_low_slope_07) + (1<<reg_sat_lum_high_slope_07)

  (reg_sat_sat_high_07 - reg_sat_sat_low_07) >=
        (1<<reg_sat_sat_low_slope_07) + (1<<reg_sat_sat_high_slope_07)

3)
  all of reg_hue_hue_shift_start_00[14:0] ~ 07[14:0] < 0x6000.
  only region 0 and 1 can exceed 360 degrees. ie:
    reg_hue_hue_shift_start_00 + (reg_hue_hue_shift_range_00<<5) can greater than 0x6000.
    reg_hue_hue_shift_start_01 + (reg_hue_hue_shift_range_01<<5) can greater than 0x6000.
  but below should be met:
    reg_hue_hue_shift_start_00 + (reg_hue_hue_shift_range_00<<5) < 0x8000. if reg_symmetry_en_00 == 0
    reg_hue_hue_shift_start_01 + (reg_hue_hue_shift_range_00<<5) < 0x8000. if reg_symmetry_en_00 == 0
    reg_hue_hue_shift_start_00 + (reg_hue_hue_shift_range_00<<6) < 0x8000. if reg_symmetry_en_00 == 1
    reg_hue_hue_shift_start_01 + (reg_hue_hue_shift_range_00<<6) < 0x8000. if reg_symmetry_en_00 == 1

  others could not exceed 360 degrees. ie:
    reg_hue_hue_shift_start_02(to 7) + (reg_hue_hue_shift_range_02 (to 7) <<5) < 0x6000. if reg_symmetry_en_02 (to 7) == 0.
    reg_hue_hue_shift_start_02(to 7) + (reg_hue_hue_shift_range_02 (to 7) <<6) < 0x6000. if reg_symmetry_en_02 (to 7) == 1.

4)
  reg_hue_gain_00[7:0] <= 0x80.
  reg_hue_gain_01[7:0] <= 0x80.
  reg_hue_gain_02[7:0] <= 0x80.
  reg_hue_gain_03[7:0] <= 0x80.
  reg_hue_gain_04[7:0] <= 0x80.
  reg_hue_gain_05[7:0] <= 0x80.
  reg_hue_gain_06[7:0] <= 0x80.
  reg_hue_gain_07[7:0] <= 0x80.

5)
  below registers can only have two setting: 00 and 01.
    reg_hue_central_en_00[1:0]  .. _07[1:0]
    reg_sat_central_en_00[1:0]  .. _07[1:0]

6)
  all reg_..._slope_00-07 should not be greater than 7, ie: maximum value is 7.
   for example: below is for region 0:
   reg_hue_lum_low_slope_00[3:0]  <= 7
   reg_hue_lum_high_slope_00[3:0] <= 7
   reg_hue_sat_low_slope_00[3:0]  <= 7
   reg_hue_sat_high_slope_00[3:0] <= 7
   reg_sat_lum_low_slope_00[3:0]  <= 7
   reg_sat_lum_high_slope_00[3:0] <= 7
   reg_sat_sat_low_slope_00[3:0]  <= 7
   reg_sat_sat_high_slope_00[3:0] <= 7
*/

// synopsys translate_off
// synopsys translate_on
//
// Closing file:  chroma_reg.h
//
//(hsvsharp), (blue), gainoff, mat_vd1,mat_vd2, mat_post, prebld, postbld,(hsharp),sco_ff, vadj1, vadj2, ofifo, (chroma1), clk0(free_clk) vpp_reg
//each item 2bits, for each 2bits, if bit 2*i+1 == 1, free clk, else if bit 2*i == 1 no clk, else auto gated clock
//bit1 is not used, because I can not turn off vpp_reg clk because I can not turn on again
//because the register itself canot be set again without clk
//Bit 31:0
#define VPP_GCLK_CTRL0                             ((0x1d72  << 2) + 0xff900000)
//(front_lti), (front_cti), Chroma2_filter, Chroma2, (Ccoring), (blackext), dnlp
//Bit 13:0
#define VPP_GCLK_CTRL1                             ((0x1d73  << 2) + 0xff900000)
//prehsc_clk, line_buf, prevsc, vsc, hsc_clk, clk0(free_clk)
//Bit 11:0
#define VPP_SC_GCLK_CTRL                           ((0x1d74  << 2) + 0xff900000)
//Bit 17:9 VD1 alpha for preblend
//Bit 8:0 VD1 alpha for postblend
#define VPP_MISC1                                  ((0x1d76  << 2) + 0xff900000)
//Bit 31:0 super scalar clock control
#define VPP_SRSCL_GCLK_CTRL                        ((0x1d77  << 2) + 0xff900000)
//Bit 31:0 OSD super scalar clock control
#define VPP_OSDSR_GCLK_CTRL                        ((0x1d78  << 2) + 0xff900000)
//Bit 31:0 vvycc clock control
#define VPP_XVYCC_GCLK_CTRL                        ((0x1d79  << 2) + 0xff900000)
//Bit 31:24     blackext_start
//Bit 23:16     blackext_slope1
//Bit 15:8      blackext_midpt
//Bit 7:0       blackext_slope2
#define VPP_BLACKEXT_CTRL                          ((0x1d80  << 2) + 0xff900000)
//Bit 31:24     bottom of region03 output value
//Bit 23:16     bottom of region02 output value
//Bit 15:8      bottom of region01 output value
//Bit 7:0       bottom of region00 output value
#define VPP_DNLP_CTRL_00                           ((0x1d81  << 2) + 0xff900000)
//Bit 31:24     bottom of region07 output value
//Bit 23:16     bottom of region06 output value
//Bit 15:8      bottom of region05 output value
//Bit 7:0       bottom of region04 output value
#define VPP_DNLP_CTRL_01                           ((0x1d82  << 2) + 0xff900000)
//Bit 31:24     bottom of region11 output value
//Bit 23:16     bottom of region10 output value
//Bit 15:8      bottom of region09 output value
//Bit 7:0       bottom of region08 output value
#define VPP_DNLP_CTRL_02                           ((0x1d83  << 2) + 0xff900000)
//Bit 31:24     bottom of region15 output value
//Bit 23:16     bottom of region14 output value
//Bit 15:8      bottom of region13 output value
//Bit 7:0       bottom of region12 output value
#define VPP_DNLP_CTRL_03                           ((0x1d84  << 2) + 0xff900000)
//Bit 31:24     bottom of region19 output value
//Bit 23:16     bottom of region18 output value
//Bit 15:8      bottom of region17 output value
//Bit 7:0       bottom of region16 output value
#define VPP_DNLP_CTRL_04                           ((0x1d85  << 2) + 0xff900000)
//Bit 31:24     bottom of region23 output value
//Bit 23:16     bottom of region22 output value
//Bit 15:8      bottom of region21 output value
//Bit 7:0       bottom of region20 output value
#define VPP_DNLP_CTRL_05                           ((0x1d86  << 2) + 0xff900000)
//Bit 31:24     bottom of region27 output value
//Bit 23:16     bottom of region26 output value
//Bit 15:8      bottom of region25 output value
//Bit 7:0       bottom of region24 output value
#define VPP_DNLP_CTRL_06                           ((0x1d87  << 2) + 0xff900000)
//Bit 31:24     bottom of region31 output value
//Bit 23:16     bottom of region30 output value
//Bit 15:8      bottom of region29 output value
//Bit 7:0       bottom of region28 output value
#define VPP_DNLP_CTRL_07                           ((0x1d88  << 2) + 0xff900000)
//Bit 31:24     bottom of region35 output value
//Bit 23:16     bottom of region34 output value
//Bit 15:8      bottom of region33 output value
//Bit 7:0       bottom of region32 output value
#define VPP_DNLP_CTRL