/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * arch/arm/cpu/armv8/axg/firmware/scp_task/regs.h
 *
 * Copyright (C) 2020 Amlogic, Inc. All rights reserved.
 *
 */

// ----------------------------------------------------------------------
// regs.h header
//
// bus base define, update manually
//
// ----------------------------------------------------------------------
//

#ifndef _BASE_REGISTER
#define _BASE_REGISTER
#define REG_BASE_AOBUS                  (0xFF800000L)
#define REG_BASE_PERIPHS                (0xFF634000L)
#define REG_BASE_CBUS                   (0xFFD00000L)
#define REG_BASE_HIU                    (0xFF63C000L)
#define REG_BASE_VCBUS                  (0xFF900000L)
#define DMC_REG_BASE                    (0xFF638000L)

#endif /*_BASE_REGISTER*/

// ----------------------------------------------------------------------
// This file is automatically generated for the SW team:
//
// From three scripts:./create_headers_from_register_map_h.pl, create_headers_from_secure_apb4_h.pl, create_headers_for_mmc_register_map_h.pl
//
// DO NOT EDIT!!!!!
// ----------------------------------------------------------------------
//

#ifndef REGS_H
#define REGS_H


//
// Reading file:  ./register_map.h
//
// synopsys translate_off
// synopsys translate_on
//
// Reading file:  periphs_reg.h
//
// $periphs/rtl/periphs_core register defines for the
// APB bus
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  UART0_CBUS_BASE = 0x90
// -----------------------------------------------
#define   UART0_WFIFO                              (0x9000)
#define P_UART0_WFIFO                              (volatile uint32_t *)((0x9000  << 2) + 0xffd00000)
#define   UART0_RFIFO                              (0x9001)
#define P_UART0_RFIFO                              (volatile uint32_t *)((0x9001  << 2) + 0xffd00000)
#define   UART0_CONTROL                            (0x9002)
#define P_UART0_CONTROL                            (volatile uint32_t *)((0x9002  << 2) + 0xffd00000)
#define   UART0_STATUS                             (0x9003)
#define P_UART0_STATUS                             (volatile uint32_t *)((0x9003  << 2) + 0xffd00000)
#define   UART0_MISC                               (0x9004)
#define P_UART0_MISC                               (volatile uint32_t *)((0x9004  << 2) + 0xffd00000)
#define   UART0_REG5                               (0x9005)
#define P_UART0_REG5                               (volatile uint32_t *)((0x9005  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  UART1_CBUS_BASE = 0x8c
// -----------------------------------------------
#define   UART1_WFIFO                              (0x8c00)
#define P_UART1_WFIFO                              (volatile uint32_t *)((0x8c00  << 2) + 0xffd00000)
#define   UART1_RFIFO                              (0x8c01)
#define P_UART1_RFIFO                              (volatile uint32_t *)((0x8c01  << 2) + 0xffd00000)
#define   UART1_CONTROL                            (0x8c02)
#define P_UART1_CONTROL                            (volatile uint32_t *)((0x8c02  << 2) + 0xffd00000)
#define   UART1_STATUS                             (0x8c03)
#define P_UART1_STATUS                             (volatile uint32_t *)((0x8c03  << 2) + 0xffd00000)
#define   UART1_MISC                               (0x8c04)
#define P_UART1_MISC                               (volatile uint32_t *)((0x8c04  << 2) + 0xffd00000)
#define   UART1_REG5                               (0x8c05)
#define P_UART1_REG5                               (volatile uint32_t *)((0x8c05  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  I2C_M_0_CBUS_BASE = 0x7c
// -----------------------------------------------
#define   I2C_M_0_CONTROL_REG                      (0x7c00)
#define P_I2C_M_0_CONTROL_REG                      (volatile uint32_t *)((0x7c00  << 2) + 0xffd00000)
    #define     I2C_M_MANUAL_SDA_I        26
    #define     I2C_M_MANUAL_SCL_I        25
    #define     I2C_M_MANUAL_SDA_O        24
    #define     I2C_M_MANUAL_SCL_O        23
    #define     I2C_M_MANUAL_EN           22
    #define     I2C_M_DELAY_MSB           21
    #define     I2C_M_DELAY_LSB           12
    #define     I2C_M_DATA_CNT_MSB        11
    #define     I2C_M_DATA_CNT_LSB        8
    #define     I2C_M_CURR_TOKEN_MSB      7
    #define     I2C_M_CURR_TOKEN_LSB      4
    #define     I2C_M_ERROR               3
    #define     I2C_M_STATUS              2
    #define     I2C_M_ACK_IGNORE          1
    #define     I2C_M_START               0
#define   I2C_M_0_SLAVE_ADDR                       (0x7c01)
#define P_I2C_M_0_SLAVE_ADDR                       (volatile uint32_t *)((0x7c01  << 2) + 0xffd00000)
#define   I2C_M_0_TOKEN_LIST0                      (0x7c02)
#define P_I2C_M_0_TOKEN_LIST0                      (volatile uint32_t *)((0x7c02  << 2) + 0xffd00000)
#define   I2C_M_0_TOKEN_LIST1                      (0x7c03)
#define P_I2C_M_0_TOKEN_LIST1                      (volatile uint32_t *)((0x7c03  << 2) + 0xffd00000)
#define   I2C_M_0_WDATA_REG0                       (0x7c04)
#define P_I2C_M_0_WDATA_REG0                       (volatile uint32_t *)((0x7c04  << 2) + 0xffd00000)
#define   I2C_M_0_WDATA_REG1                       (0x7c05)
#define P_I2C_M_0_WDATA_REG1                       (volatile uint32_t *)((0x7c05  << 2) + 0xffd00000)
#define   I2C_M_0_RDATA_REG0                       (0x7c06)
#define P_I2C_M_0_RDATA_REG0                       (volatile uint32_t *)((0x7c06  << 2) + 0xffd00000)
#define   I2C_M_0_RDATA_REG1                       (0x7c07)
#define P_I2C_M_0_RDATA_REG1                       (volatile uint32_t *)((0x7c07  << 2) + 0xffd00000)
#define   I2C_M_0_TIMEOUT_TH                       (0x7c08)
#define P_I2C_M_0_TIMEOUT_TH                       (volatile uint32_t *)((0x7c08  << 2) + 0xffd00000)
// -----------------------------------------------
// CBUS_BASE:  I2C_M_1_CBUS_BASE = 0x78
// -----------------------------------------------
#define   I2C_M_1_CONTROL_REG                      (0x7800)
#define P_I2C_M_1_CONTROL_REG                      (volatile uint32_t *)((0x7800  << 2) + 0xffd00000)
#define   I2C_M_1_SLAVE_ADDR                       (0x7801)
#define P_I2C_M_1_SLAVE_ADDR                       (volatile uint32_t *)((0x7801  << 2) + 0xffd00000)
#define   I2C_M_1_TOKEN_LIST0                      (0x7802)
#define P_I2C_M_1_TOKEN_LIST0                      (volatile uint32_t *)((0x7802  << 2) + 0xffd00000)
#define   I2C_M_1_TOKEN_LIST1                      (0x7803)
#define P_I2C_M_1_TOKEN_LIST1                      (volatile uint32_t *)((0x7803  << 2) + 0xffd00000)
#define   I2C_M_1_WDATA_REG0                       (0x7804)
#define P_I2C_M_1_WDATA_REG0                       (volatile uint32_t *)((0x7804  << 2) + 0xffd00000)
#define   I2C_M_1_WDATA_REG1                       (0x7805)
#define P_I2C_M_1_WDATA_REG1                       (volatile uint32_t *)((0x7805  << 2) + 0xffd00000)
#define   I2C_M_1_RDATA_REG0                       (0x7806)
#define P_I2C_M_1_RDATA_REG0                       (volatile uint32_t *)((0x7806  << 2) + 0xffd00000)
#define   I2C_M_1_RDATA_REG1                       (0x7807)
#define P_I2C_M_1_RDATA_REG1                       (volatile uint32_t *)((0x7807  << 2) + 0xffd00000)
#define   I2C_M_1_TIMEOUT_TH                       (0x7808)
#define P_I2C_M_1_TIMEOUT_TH                       (volatile uint32_t *)((0x7808  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  I2C_M_2_CBUS_BASE = 0x74
// -----------------------------------------------
#define   I2C_M_2_CONTROL_REG                      (0x7400)
#define P_I2C_M_2_CONTROL_REG                      (volatile uint32_t *)((0x7400  << 2) + 0xffd00000)
#define   I2C_M_2_SLAVE_ADDR                       (0x7401)
#define P_I2C_M_2_SLAVE_ADDR                       (volatile uint32_t *)((0x7401  << 2) + 0xffd00000)
#define   I2C_M_2_TOKEN_LIST0                      (0x7402)
#define P_I2C_M_2_TOKEN_LIST0                      (volatile uint32_t *)((0x7402  << 2) + 0xffd00000)
#define   I2C_M_2_TOKEN_LIST1                      (0x7403)
#define P_I2C_M_2_TOKEN_LIST1                      (volatile uint32_t *)((0x7403  << 2) + 0xffd00000)
#define   I2C_M_2_WDATA_REG0                       (0x7404)
#define P_I2C_M_2_WDATA_REG0                       (volatile uint32_t *)((0x7404  << 2) + 0xffd00000)
#define   I2C_M_2_WDATA_REG1                       (0x7405)
#define P_I2C_M_2_WDATA_REG1                       (volatile uint32_t *)((0x7405  << 2) + 0xffd00000)
#define   I2C_M_2_RDATA_REG0                       (0x7406)
#define P_I2C_M_2_RDATA_REG0                       (volatile uint32_t *)((0x7406  << 2) + 0xffd00000)
#define   I2C_M_2_RDATA_REG1                       (0x7407)
#define P_I2C_M_2_RDATA_REG1                       (volatile uint32_t *)((0x7407  << 2) + 0xffd00000)
#define   I2C_M_2_TIMEOUT_TH                       (0x7408)
#define P_I2C_M_2_TIMEOUT_TH                       (volatile uint32_t *)((0x7408  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  I2C_M_3_CBUS_BASE = 0x70
// -----------------------------------------------
#define   I2C_M_3_CONTROL_REG                      (0x7000)
#define P_I2C_M_3_CONTROL_REG                      (volatile uint32_t *)((0x7000  << 2) + 0xffd00000)
#define   I2C_M_3_SLAVE_ADDR                       (0x7001)
#define P_I2C_M_3_SLAVE_ADDR                       (volatile uint32_t *)((0x7001  << 2) + 0xffd00000)
#define   I2C_M_3_TOKEN_LIST0                      (0x7002)
#define P_I2C_M_3_TOKEN_LIST0                      (volatile uint32_t *)((0x7002  << 2) + 0xffd00000)
#define   I2C_M_3_TOKEN_LIST1                      (0x7003)
#define P_I2C_M_3_TOKEN_LIST1                      (volatile uint32_t *)((0x7003  << 2) + 0xffd00000)
#define   I2C_M_3_WDATA_REG0                       (0x7004)
#define P_I2C_M_3_WDATA_REG0                       (volatile uint32_t *)((0x7004  << 2) + 0xffd00000)
#define   I2C_M_3_WDATA_REG1                       (0x7005)
#define P_I2C_M_3_WDATA_REG1                       (volatile uint32_t *)((0x7005  << 2) + 0xffd00000)
#define   I2C_M_3_RDATA_REG0                       (0x7006)
#define P_I2C_M_3_RDATA_REG0                       (volatile uint32_t *)((0x7006  << 2) + 0xffd00000)
#define   I2C_M_3_RDATA_REG1                       (0x7007)
#define P_I2C_M_3_RDATA_REG1                       (volatile uint32_t *)((0x7007  << 2) + 0xffd00000)
#define   I2C_M_3_TIMEOUT_TH                       (0x7008)
#define P_I2C_M_3_TIMEOUT_TH                       (volatile uint32_t *)((0x7008  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PWM_AB_CBUS_BASE = 0x6c
// -----------------------------------------------
#define   PWM_PWM_A                                (0x6c00)
#define P_PWM_PWM_A                                (volatile uint32_t *)((0x6c00  << 2) + 0xffd00000)
#define   PWM_PWM_B                                (0x6c01)
#define P_PWM_PWM_B                                (volatile uint32_t *)((0x6c01  << 2) + 0xffd00000)
#define   PWM_MISC_REG_AB                          (0x6c02)
#define P_PWM_MISC_REG_AB                          (volatile uint32_t *)((0x6c02  << 2) + 0xffd00000)
#define   PWM_DELTA_SIGMA_AB                       (0x6c03)
#define P_PWM_DELTA_SIGMA_AB                       (volatile uint32_t *)((0x6c03  << 2) + 0xffd00000)
#define   PWM_TIME_AB                              (0x6c04)
#define P_PWM_TIME_AB                              (volatile uint32_t *)((0x6c04  << 2) + 0xffd00000)
#define   PWM_A2                                   (0x6c05)
#define P_PWM_A2                                   (volatile uint32_t *)((0x6c05  << 2) + 0xffd00000)
#define   PWM_B2                                   (0x6c06)
#define P_PWM_B2                                   (volatile uint32_t *)((0x6c06  << 2) + 0xffd00000)
#define   PWM_BLINK_AB                             (0x6c07)
#define P_PWM_BLINK_AB                             (volatile uint32_t *)((0x6c07  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PWM_CD_CBUS_BASE = 0x68
// -----------------------------------------------
#define   PWM_PWM_C                                (0x6800)
#define P_PWM_PWM_C                                (volatile uint32_t *)((0x6800  << 2) + 0xffd00000)
#define   PWM_PWM_D                                (0x6801)
#define P_PWM_PWM_D                                (volatile uint32_t *)((0x6801  << 2) + 0xffd00000)
#define   PWM_MISC_REG_CD                          (0x6802)
#define P_PWM_MISC_REG_CD                          (volatile uint32_t *)((0x6802  << 2) + 0xffd00000)
#define   PWM_DELTA_SIGMA_CD                       (0x6803)
#define P_PWM_DELTA_SIGMA_CD                       (volatile uint32_t *)((0x6803  << 2) + 0xffd00000)
#define   PWM_TIME_CD                              (0x6804)
#define P_PWM_TIME_CD                              (volatile uint32_t *)((0x6804  << 2) + 0xffd00000)
#define   PWM_C2                                   (0x6805)
#define P_PWM_C2                                   (volatile uint32_t *)((0x6805  << 2) + 0xffd00000)
#define   PWM_D2                                   (0x6806)
#define P_PWM_D2                                   (volatile uint32_t *)((0x6806  << 2) + 0xffd00000)
#define   PWM_BLINK_CD                             (0x6807)
#define P_PWM_BLINK_CD                             (volatile uint32_t *)((0x6807  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  MSR_CLK_CBUS_BASE = 0x60
// -----------------------------------------------
#define   MSR_CLK_DUTY                             (0x6000)
#define P_MSR_CLK_DUTY                             (volatile uint32_t *)((0x6000  << 2) + 0xffd00000)
#define   MSR_CLK_REG0                             (0x6001)
#define P_MSR_CLK_REG0                             (volatile uint32_t *)((0x6001  << 2) + 0xffd00000)
#define   MSR_CLK_REG1                             (0x6002)
#define P_MSR_CLK_REG1                             (volatile uint32_t *)((0x6002  << 2) + 0xffd00000)
#define   MSR_CLK_REG2                             (0x6003)
#define P_MSR_CLK_REG2                             (volatile uint32_t *)((0x6003  << 2) + 0xffd00000)
#define   MSR_CLK_REG3                             (0x6004)
#define P_MSR_CLK_REG3                             (volatile uint32_t *)((0x6004  << 2) + 0xffd00000)
#define   MSR_CLK_REG4                             (0x6005)
#define P_MSR_CLK_REG4                             (volatile uint32_t *)((0x6005  << 2) + 0xffd00000)
#define   MSR_CLK_REG5                             (0x6006)
#define P_MSR_CLK_REG5                             (volatile uint32_t *)((0x6006  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  SPIFC_CBUS_BASE = 0x50
// -----------------------------------------------
#define   SPI_FLASH_CMD                            (0x5000)
#define P_SPI_FLASH_CMD                            (volatile uint32_t *)((0x5000  << 2) + 0xffd00000)
    #define SPI_FLASH_READ    31
    #define SPI_FLASH_WREN    30
    #define SPI_FLASH_WRDI    29
    #define SPI_FLASH_RDID    28
    #define SPI_FLASH_RDSR    27
    #define SPI_FLASH_WRSR    26
    #define SPI_FLASH_PP      25
    #define SPI_FLASH_SE      24
    #define SPI_FLASH_BE      23
    #define SPI_FLASH_CE      22
    #define SPI_FLASH_DP      21
    #define SPI_FLASH_RES     20
    #define SPI_HPM           19
    #define SPI_FLASH_USR     18
    #define SPI_FLASH_USR_ADDR 15
    #define SPI_FLASH_USR_DUMMY 14
    #define SPI_FLASH_USR_DIN   13
    #define SPI_FLASH_USR_DOUT   12
    #define SPI_FLASH_USR_DUMMY_BLEN   10
    #define SPI_FLASH_USR_CMD     0
#define   SPI_FLASH_ADDR                           (0x5001)
#define P_SPI_FLASH_ADDR                           (volatile uint32_t *)((0x5001  << 2) + 0xffd00000)
    #define SPI_FLASH_BYTES_LEN 24
    #define SPI_FLASH_ADDR_START 0
#define   SPI_FLASH_CTRL                           (0x5002)
#define P_SPI_FLASH_CTRL                           (volatile uint32_t *)((0x5002  << 2) + 0xffd00000)
    #define SPI_ENABLE_AHB    17
    #define SPI_SST_AAI       16
    #define SPI_RES_RID       15
    #define SPI_FREAD_DUAL    14
    #define SPI_READ_READ_EN  13
    #define SPI_CLK_DIV0      12
    #define SPI_CLKCNT_N      8
    #define SPI_CLKCNT_H      4
    #define SPI_CLKCNT_L      0
#define   SPI_FLASH_CTRL1                          (0x5003)
#define P_SPI_FLASH_CTRL1                          (volatile uint32_t *)((0x5003  << 2) + 0xffd00000)
#define   SPI_FLASH_STATUS                         (0x5004)
#define P_SPI_FLASH_STATUS                         (volatile uint32_t *)((0x5004  << 2) + 0xffd00000)
#define   SPI_FLASH_CTRL2                          (0x5005)
#define P_SPI_FLASH_CTRL2                          (volatile uint32_t *)((0x5005  << 2) + 0xffd00000)
#define   SPI_FLASH_CLOCK                          (0x5006)
#define P_SPI_FLASH_CLOCK                          (volatile uint32_t *)((0x5006  << 2) + 0xffd00000)
#define   SPI_FLASH_USER                           (0x5007)
#define P_SPI_FLASH_USER                           (volatile uint32_t *)((0x5007  << 2) + 0xffd00000)
#define   SPI_FLASH_USER1                          (0x5008)
#define P_SPI_FLASH_USER1                          (volatile uint32_t *)((0x5008  << 2) + 0xffd00000)
#define   SPI_FLASH_USER2                          (0x5009)
#define P_SPI_FLASH_USER2                          (volatile uint32_t *)((0x5009  << 2) + 0xffd00000)
#define   SPI_FLASH_USER3                          (0x500a)
#define P_SPI_FLASH_USER3                          (volatile uint32_t *)((0x500a  << 2) + 0xffd00000)
#define   SPI_FLASH_USER4                          (0x500b)
#define P_SPI_FLASH_USER4                          (volatile uint32_t *)((0x500b  << 2) + 0xffd00000)
#define   SPI_FLASH_SLAVE                          (0x500c)
#define P_SPI_FLASH_SLAVE                          (volatile uint32_t *)((0x500c  << 2) + 0xffd00000)
#define   SPI_FLASH_SLAVE1                         (0x500d)
#define P_SPI_FLASH_SLAVE1                         (volatile uint32_t *)((0x500d  << 2) + 0xffd00000)
#define   SPI_FLASH_SLAVE2                         (0x500e)
#define P_SPI_FLASH_SLAVE2                         (volatile uint32_t *)((0x500e  << 2) + 0xffd00000)
#define   SPI_FLASH_SLAVE3                         (0x500f)
#define P_SPI_FLASH_SLAVE3                         (volatile uint32_t *)((0x500f  << 2) + 0xffd00000)
#define   SPI_FLASH_C0                             (0x5010)
#define P_SPI_FLASH_C0                             (volatile uint32_t *)((0x5010  << 2) + 0xffd00000)
#define   SPI_FLASH_C1                             (0x5011)
#define P_SPI_FLASH_C1                             (volatile uint32_t *)((0x5011  << 2) + 0xffd00000)
#define   SPI_FLASH_C2                             (0x5012)
#define P_SPI_FLASH_C2                             (volatile uint32_t *)((0x5012  << 2) + 0xffd00000)
#define   SPI_FLASH_C3                             (0x5013)
#define P_SPI_FLASH_C3                             (volatile uint32_t *)((0x5013  << 2) + 0xffd00000)
#define   SPI_FLASH_C4                             (0x5014)
#define P_SPI_FLASH_C4                             (volatile uint32_t *)((0x5014  << 2) + 0xffd00000)
#define   SPI_FLASH_C5                             (0x5015)
#define P_SPI_FLASH_C5                             (volatile uint32_t *)((0x5015  << 2) + 0xffd00000)
#define   SPI_FLASH_C6                             (0x5016)
#define P_SPI_FLASH_C6                             (volatile uint32_t *)((0x5016  << 2) + 0xffd00000)
#define   SPI_FLASH_C7                             (0x5017)
#define P_SPI_FLASH_C7                             (volatile uint32_t *)((0x5017  << 2) + 0xffd00000)
#define   SPI_FLASH_B8                             (0x5018)
#define P_SPI_FLASH_B8                             (volatile uint32_t *)((0x5018  << 2) + 0xffd00000)
#define   SPI_FLASH_B9                             (0x5019)
#define P_SPI_FLASH_B9                             (volatile uint32_t *)((0x5019  << 2) + 0xffd00000)
#define   SPI_FLASH_B10                            (0x501a)
#define P_SPI_FLASH_B10                            (volatile uint32_t *)((0x501a  << 2) + 0xffd00000)
#define   SPI_FLASH_B11                            (0x501b)
#define P_SPI_FLASH_B11                            (volatile uint32_t *)((0x501b  << 2) + 0xffd00000)
#define   SPI_FLASH_B12                            (0x501c)
#define P_SPI_FLASH_B12                            (volatile uint32_t *)((0x501c  << 2) + 0xffd00000)
#define   SPI_FLASH_B13                            (0x501d)
#define P_SPI_FLASH_B13                            (volatile uint32_t *)((0x501d  << 2) + 0xffd00000)
#define   SPI_FLASH_B14                            (0x501e)
#define P_SPI_FLASH_B14                            (volatile uint32_t *)((0x501e  << 2) + 0xffd00000)
#define   SPI_FLASH_B15                            (0x501f)
#define P_SPI_FLASH_B15                            (volatile uint32_t *)((0x501f  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
//spicc 0
// -----------------------------------------------
// CBUS_BASE:  SPICC0_CBUS_BASE = 0x4c
// -----------------------------------------------
#define   SPICC0_RXDATA                            (0x4c00)
#define P_SPICC0_RXDATA                            (volatile uint32_t *)((0x4c00  << 2) + 0xffd00000)
#define   SPICC0_TXDATA                            (0x4c01)
#define P_SPICC0_TXDATA                            (volatile uint32_t *)((0x4c01  << 2) + 0xffd00000)
#define   SPICC0_CONREG                            (0x4c02)
#define P_SPICC0_CONREG                            (volatile uint32_t *)((0x4c02  << 2) + 0xffd00000)
#define   SPICC0_INTREG                            (0x4c03)
#define P_SPICC0_INTREG                            (volatile uint32_t *)((0x4c03  << 2) + 0xffd00000)
#define   SPICC0_DMAREG                            (0x4c04)
#define P_SPICC0_DMAREG                            (volatile uint32_t *)((0x4c04  << 2) + 0xffd00000)
#define   SPICC0_STATREG                           (0x4c05)
#define P_SPICC0_STATREG                           (volatile uint32_t *)((0x4c05  << 2) + 0xffd00000)
#define   SPICC0_PERIODREG                         (0x4c06)
#define P_SPICC0_PERIODREG                         (volatile uint32_t *)((0x4c06  << 2) + 0xffd00000)
#define   SPICC0_TESTREG                           (0x4c07)
#define P_SPICC0_TESTREG                           (volatile uint32_t *)((0x4c07  << 2) + 0xffd00000)
#define   SPICC0_DRADDR                            (0x4c08)
#define P_SPICC0_DRADDR                            (volatile uint32_t *)((0x4c08  << 2) + 0xffd00000)
#define   SPICC0_DWADDR                            (0x4c09)
#define P_SPICC0_DWADDR                            (volatile uint32_t *)((0x4c09  << 2) + 0xffd00000)
#define   SPICC0_LD_CNTL0                          (0x4c0a)
#define P_SPICC0_LD_CNTL0                          (volatile uint32_t *)((0x4c0a  << 2) + 0xffd00000)
#define   SPICC0_LD_CNTL1                          (0x4c0b)
#define P_SPICC0_LD_CNTL1                          (volatile uint32_t *)((0x4c0b  << 2) + 0xffd00000)
#define   SPICC0_LD_RADDR                          (0x4c0c)
#define P_SPICC0_LD_RADDR                          (volatile uint32_t *)((0x4c0c  << 2) + 0xffd00000)
#define   SPICC0_LD_WADDR                          (0x4c0d)
#define P_SPICC0_LD_WADDR                          (volatile uint32_t *)((0x4c0d  << 2) + 0xffd00000)
#define   SPICC0_ENHANCE_CNTL                      (0x4c0e)
#define P_SPICC0_ENHANCE_CNTL                      (volatile uint32_t *)((0x4c0e  << 2) + 0xffd00000)
#define   SPICC0_ENHANCE_CNTL1                     (0x4c0f)
#define P_SPICC0_ENHANCE_CNTL1                     (volatile uint32_t *)((0x4c0f  << 2) + 0xffd00000)
// ------------------------------------------------------------------------------------
//spicc 1
// -----------------------------------------------
// CBUS_BASE:  SPICC1_CBUS_BASE = 0x54
// -----------------------------------------------
#define   SPICC1_RXDATA                            (0x5400)
#define P_SPICC1_RXDATA                            (volatile uint32_t *)((0x5400  << 2) + 0xffd00000)
#define   SPICC1_TXDATA                            (0x5401)
#define P_SPICC1_TXDATA                            (volatile uint32_t *)((0x5401  << 2) + 0xffd00000)
#define   SPICC1_CONREG                            (0x5402)
#define P_SPICC1_CONREG                            (volatile uint32_t *)((0x5402  << 2) + 0xffd00000)
#define   SPICC1_INTREG                            (0x5403)
#define P_SPICC1_INTREG                            (volatile uint32_t *)((0x5403  << 2) + 0xffd00000)
#define   SPICC1_DMAREG                            (0x5404)
#define P_SPICC1_DMAREG                            (volatile uint32_t *)((0x5404  << 2) + 0xffd00000)
#define   SPICC1_STATREG                           (0x5405)
#define P_SPICC1_STATREG                           (volatile uint32_t *)((0x5405  << 2) + 0xffd00000)
#define   SPICC1_PERIODREG                         (0x5406)
#define P_SPICC1_PERIODREG                         (volatile uint32_t *)((0x5406  << 2) + 0xffd00000)
#define   SPICC1_TESTREG                           (0x5407)
#define P_SPICC1_TESTREG                           (volatile uint32_t *)((0x5407  << 2) + 0xffd00000)
#define   SPICC1_DRADDR                            (0x5408)
#define P_SPICC1_DRADDR                            (volatile uint32_t *)((0x5408  << 2) + 0xffd00000)
#define   SPICC1_DWADDR                            (0x5409)
#define P_SPICC1_DWADDR                            (volatile uint32_t *)((0x5409  << 2) + 0xffd00000)
#define   SPICC1_LD_CNTL0                          (0x540a)
#define P_SPICC1_LD_CNTL0                          (volatile uint32_t *)((0x540a  << 2) + 0xffd00000)
#define   SPICC1_LD_CNTL1                          (0x540b)
#define P_SPICC1_LD_CNTL1                          (volatile uint32_t *)((0x540b  << 2) + 0xffd00000)
#define   SPICC1_LD_RADDR                          (0x540c)
#define P_SPICC1_LD_RADDR                          (volatile uint32_t *)((0x540c  << 2) + 0xffd00000)
#define   SPICC1_LD_WADDR                          (0x540d)
#define P_SPICC1_LD_WADDR                          (volatile uint32_t *)((0x540d  << 2) + 0xffd00000)
#define   SPICC1_ENHANCE_CNTL                      (0x540e)
#define P_SPICC1_ENHANCE_CNTL                      (volatile uint32_t *)((0x540e  << 2) + 0xffd00000)
#define   SPICC1_ENHANCE_CNTL1                     (0x540f)
#define P_SPICC1_ENHANCE_CNTL1                     (volatile uint32_t *)((0x540f  << 2) + 0xffd00000)
//
//
// Closing file:  periphs_reg.h
//
//
// Reading file:  isa_reg.h
//
// $isa/rtl/isa_core register defines for the APB bus
// CBUS base slave address
// -----------------------------------------------
// CBUS_BASE:  ISA_CBUS_BASE = 0x3c
// -----------------------------------------------
// Up to 256 registers for this base
#define   ISA_DEBUG_REG0                           (0x3c00)
#define P_ISA_DEBUG_REG0                           (volatile uint32_t *)((0x3c00  << 2) + 0xffd00000)
#define   ISA_DEBUG_REG1                           (0x3c01)
#define P_ISA_DEBUG_REG1                           (volatile uint32_t *)((0x3c01  << 2) + 0xffd00000)
#define   ISA_DEBUG_REG2                           (0x3c02)
#define P_ISA_DEBUG_REG2                           (volatile uint32_t *)((0x3c02  << 2) + 0xffd00000)
#define   ISA_DEBUG_REG3                           (0x3c03)
#define P_ISA_DEBUG_REG3                           (volatile uint32_t *)((0x3c03  << 2) + 0xffd00000)
#define   ISA_PLL_CLK_SIM0                         (0x3c08)
#define P_ISA_PLL_CLK_SIM0                         (volatile uint32_t *)((0x3c08  << 2) + 0xffd00000)
#define   ISA_CNTL_REG0                            (0x3c09)
#define P_ISA_CNTL_REG0                            (volatile uint32_t *)((0x3c09  << 2) + 0xffd00000)
// -----------------------------------------------------------
#define   AO_CPU_IRQ_IN0_INTR_STAT                 (0x3c10)
#define P_AO_CPU_IRQ_IN0_INTR_STAT                 (volatile uint32_t *)((0x3c10  << 2) + 0xffd00000)
#define   AO_CPU_IRQ_IN0_INTR_STAT_CLR             (0x3c11)
#define P_AO_CPU_IRQ_IN0_INTR_STAT_CLR             (volatile uint32_t *)((0x3c11  << 2) + 0xffd00000)
#define   AO_CPU_IRQ_IN0_INTR_MASK                 (0x3c12)
#define P_AO_CPU_IRQ_IN0_INTR_MASK                 (volatile uint32_t *)((0x3c12  << 2) + 0xffd00000)
#define   AO_CPU_IRQ_IN0_INTR_FIRQ_SEL             (0x3c13)
#define P_AO_CPU_IRQ_IN0_INTR_FIRQ_SEL             (volatile uint32_t *)((0x3c13  << 2) + 0xffd00000)
#define   GPIO_INTR_EDGE_POL                       (0x3c20)
#define P_GPIO_INTR_EDGE_POL                       (volatile uint32_t *)((0x3c20  << 2) + 0xffd00000)
#define   GPIO_INTR_GPIO_SEL0                      (0x3c21)
#define P_GPIO_INTR_GPIO_SEL0                      (volatile uint32_t *)((0x3c21  << 2) + 0xffd00000)
#define   GPIO_INTR_GPIO_SEL1                      (0x3c22)
#define P_GPIO_INTR_GPIO_SEL1                      (volatile uint32_t *)((0x3c22  << 2) + 0xffd00000)
#define   GPIO_INTR_FILTER_SEL0                    (0x3c23)
#define P_GPIO_INTR_FILTER_SEL0                    (volatile uint32_t *)((0x3c23  << 2) + 0xffd00000)
// `define GLOBAL_INTR_DISABLE                 8'h24    never used
#define   MEDIA_CPU_INTR_STAT                      (0x3c28)
#define P_MEDIA_CPU_INTR_STAT                      (volatile uint32_t *)((0x3c28  << 2) + 0xffd00000)
#define   MEDIA_CPU_INTR_STAT_CLR                  (0x3c29)
#define P_MEDIA_CPU_INTR_STAT_CLR                  (volatile uint32_t *)((0x3c29  << 2) + 0xffd00000)
#define   MEDIA_CPU_INTR_MASK                      (0x3c2a)
#define P_MEDIA_CPU_INTR_MASK                      (volatile uint32_t *)((0x3c2a  << 2) + 0xffd00000)
#define   MEDIA_CPU_INTR_FIRQ_SEL                  (0x3c2b)
#define P_MEDIA_CPU_INTR_FIRQ_SEL                  (volatile uint32_t *)((0x3c2b  << 2) + 0xffd00000)
// -----------------------------------------------------------
#define   ISA_BIST_REG0                            (0x3c30)
#define P_ISA_BIST_REG0                            (volatile uint32_t *)((0x3c30  << 2) + 0xffd00000)
#define   ISA_BIST_REG1                            (0x3c31)
#define P_ISA_BIST_REG1                            (volatile uint32_t *)((0x3c31  << 2) + 0xffd00000)
// -----------------------------------------------------------
#define   WATCHDOG_CNTL                            (0x3c34)
#define P_WATCHDOG_CNTL                            (volatile uint32_t *)((0x3c34  << 2) + 0xffd00000)
#define   WATCHDOG_CNTL1                           (0x3c35)
#define P_WATCHDOG_CNTL1                           (volatile uint32_t *)((0x3c35  << 2) + 0xffd00000)
#define   WATCHDOG_TCNT                            (0x3c36)
#define P_WATCHDOG_TCNT                            (volatile uint32_t *)((0x3c36  << 2) + 0xffd00000)
#define   WATCHDOG_RESET                           (0x3c37)
#define P_WATCHDOG_RESET                           (volatile uint32_t *)((0x3c37  << 2) + 0xffd00000)
// -----------------------------------------------------------
#define   AHB_ARBITER_REG                          (0x3c42)
#define P_AHB_ARBITER_REG                          (volatile uint32_t *)((0x3c42  << 2) + 0xffd00000)
#define   AHB_ARBDEC_REG                           (0x3c43)
#define P_AHB_ARBDEC_REG                           (volatile uint32_t *)((0x3c43  << 2) + 0xffd00000)
#define   AHB_ARBITER2_REG                         (0x3c4a)
#define P_AHB_ARBITER2_REG                         (volatile uint32_t *)((0x3c4a  << 2) + 0xffd00000)
#define   DEVICE_MMCP_CNTL                         (0x3c4b)
#define P_DEVICE_MMCP_CNTL                         (volatile uint32_t *)((0x3c4b  << 2) + 0xffd00000)
#define   AUDIO_MMCP_CNTL                          (0x3c4c)
#define P_AUDIO_MMCP_CNTL                          (volatile uint32_t *)((0x3c4c  << 2) + 0xffd00000)
// -----------------------------------------------------------
#define   ISA_TIMER_MUX                            (0x3c50)
#define P_ISA_TIMER_MUX                            (volatile uint32_t *)((0x3c50  << 2) + 0xffd00000)
#define   ISA_TIMERA                               (0x3c51)
#define P_ISA_TIMERA                               (volatile uint32_t *)((0x3c51  << 2) + 0xffd00000)
#define   ISA_TIMERB                               (0x3c52)
#define P_ISA_TIMERB                               (volatile uint32_t *)((0x3c52  << 2) + 0xffd00000)
#define   ISA_TIMERC                               (0x3c53)
#define P_ISA_TIMERC                               (volatile uint32_t *)((0x3c53  << 2) + 0xffd00000)
#define   ISA_TIMERD                               (0x3c54)
#define P_ISA_TIMERD                               (volatile uint32_t *)((0x3c54  << 2) + 0xffd00000)
#define   FBUF_ADDR                                (0x3c56)
#define P_FBUF_ADDR                                (volatile uint32_t *)((0x3c56  << 2) + 0xffd00000)
    #define VIDEO_FRM_BUF_MSB_BIT      23
    #define VIDEO_FRM_BUF_LSB_BIT       2
#define   SDRAM_CTL0                               (0x3c57)
#define P_SDRAM_CTL0                               (volatile uint32_t *)((0x3c57  << 2) + 0xffd00000)
#define   SDRAM_CTL2                               (0x3c58)
#define P_SDRAM_CTL2                               (volatile uint32_t *)((0x3c58  << 2) + 0xffd00000)
//`define AO_CPU_CTL                          8'h59
#define   SDRAM_CTL4                               (0x3c5a)
#define P_SDRAM_CTL4                               (volatile uint32_t *)((0x3c5a  << 2) + 0xffd00000)
#define   SDRAM_CTL5                               (0x3c5b)
#define P_SDRAM_CTL5                               (volatile uint32_t *)((0x3c5b  << 2) + 0xffd00000)
#define   SDRAM_CTL6                               (0x3c5c)
#define P_SDRAM_CTL6                               (volatile uint32_t *)((0x3c5c  << 2) + 0xffd00000)
#define   SDRAM_CTL7                               (0x3c5d)
#define P_SDRAM_CTL7                               (volatile uint32_t *)((0x3c5d  << 2) + 0xffd00000)
#define   SDRAM_CTL8                               (0x3c5e)
#define P_SDRAM_CTL8                               (volatile uint32_t *)((0x3c5e  << 2) + 0xffd00000)
#define   AHB_MP4_MC_CTL                           (0x3c5f)
#define P_AHB_MP4_MC_CTL                           (volatile uint32_t *)((0x3c5f  << 2) + 0xffd00000)
#define   MEDIA_CPU_PCR                            (0x3c60)
#define P_MEDIA_CPU_PCR                            (volatile uint32_t *)((0x3c60  << 2) + 0xffd00000)
#define   MEDIA_CPU_CTL                            (0x3c61)
#define P_MEDIA_CPU_CTL                            (volatile uint32_t *)((0x3c61  << 2) + 0xffd00000)
#define   ISA_TIMERE                               (0x3c62)
#define P_ISA_TIMERE                               (volatile uint32_t *)((0x3c62  << 2) + 0xffd00000)
#define   ISA_TIMERE_HI                            (0x3c63)
#define P_ISA_TIMERE_HI                            (volatile uint32_t *)((0x3c63  << 2) + 0xffd00000)
#define   ISA_TIMER_MUX1                           (0x3c64)
#define P_ISA_TIMER_MUX1                           (volatile uint32_t *)((0x3c64  << 2) + 0xffd00000)
#define   ISA_TIMERF                               (0x3c65)
#define P_ISA_TIMERF                               (volatile uint32_t *)((0x3c65  << 2) + 0xffd00000)
#define   ISA_TIMERG                               (0x3c66)
#define P_ISA_TIMERG                               (volatile uint32_t *)((0x3c66  << 2) + 0xffd00000)
#define   ISA_TIMERH                               (0x3c67)
#define P_ISA_TIMERH                               (volatile uint32_t *)((0x3c67  << 2) + 0xffd00000)
#define   ISA_TIMERI                               (0x3c68)
#define P_ISA_TIMERI                               (volatile uint32_t *)((0x3c68  << 2) + 0xffd00000)
// ---------------------------------------------
#define   AHB_BRIDGE_CNTL_WR                       (0x3c80)
#define P_AHB_BRIDGE_CNTL_WR                       (volatile uint32_t *)((0x3c80  << 2) + 0xffd00000)
#define   AHB_BRIDGE_REMAP0                        (0x3c81)
#define P_AHB_BRIDGE_REMAP0                        (volatile uint32_t *)((0x3c81  << 2) + 0xffd00000)
#define   AHB_BRIDGE_REMAP1                        (0x3c82)
#define P_AHB_BRIDGE_REMAP1                        (volatile uint32_t *)((0x3c82  << 2) + 0xffd00000)
#define   AHB_BRIDGE_REMAP2                        (0x3c83)
#define P_AHB_BRIDGE_REMAP2                        (volatile uint32_t *)((0x3c83  << 2) + 0xffd00000)
#define   AHB_BRIDGE_REMAP3                        (0x3c84)
#define P_AHB_BRIDGE_REMAP3                        (volatile uint32_t *)((0x3c84  << 2) + 0xffd00000)
#define   AHB_BRIDGE_CNTL_REG1                     (0x3c85)
#define P_AHB_BRIDGE_CNTL_REG1                     (volatile uint32_t *)((0x3c85  << 2) + 0xffd00000)
#define   AHB_BRIDGE_CNTL_REG2                     (0x3c86)
#define P_AHB_BRIDGE_CNTL_REG2                     (volatile uint32_t *)((0x3c86  << 2) + 0xffd00000)
// ---------------------------------------------
//
// Closing file:  isa_reg.h
//
//
// Reading file:  emmc_reg.h
//
// $periphs/rtl/periphs_core register defines for the
// APB bus
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  EMMCA_CBUS_BASE = 0x40c
// -----------------------------------------------
#define   EMMC_A_GCLOCK                            (0x40c00)
#define P_EMMC_A_GCLOCK                            (volatile uint32_t *)((0x40c00  << 2) + 0xffd00000)
#define   EMMC_A_GDELAY0                           (0x40c01)
#define P_EMMC_A_GDELAY0                           (volatile uint32_t *)((0x40c01  << 2) + 0xffd00000)
#define   EMMC_A_GDELAY1                           (0x40c02)
#define P_EMMC_A_GDELAY1                           (volatile uint32_t *)((0x40c02  << 2) + 0xffd00000)
#define   EMMC_A_GADJUST                           (0x40c03)
#define P_EMMC_A_GADJUST                           (volatile uint32_t *)((0x40c03  << 2) + 0xffd00000)
#define   EMMC_A_GCALOUT0                          (0x40c04)
#define P_EMMC_A_GCALOUT0                          (volatile uint32_t *)((0x40c04  << 2) + 0xffd00000)
#define   EMMC_A_GCALOUT1                          (0x40c05)
#define P_EMMC_A_GCALOUT1                          (volatile uint32_t *)((0x40c05  << 2) + 0xffd00000)
#define   EMMC_A_GCALOUT2                          (0x40c06)
#define P_EMMC_A_GCALOUT2                          (volatile uint32_t *)((0x40c06  << 2) + 0xffd00000)
#define   EMMC_A_GCALOUT3                          (0x40c07)
#define P_EMMC_A_GCALOUT3                          (volatile uint32_t *)((0x40c07  << 2) + 0xffd00000)
#define   EMMC_A_GADJ_LOG                          (0x40c08)
#define P_EMMC_A_GADJ_LOG                          (volatile uint32_t *)((0x40c08  << 2) + 0xffd00000)
#define   EMMC_A_GCLKTEST_LOG                      (0x40c09)
#define P_EMMC_A_GCLKTEST_LOG                      (volatile uint32_t *)((0x40c09  << 2) + 0xffd00000)
#define   EMMC_A_GCLKTEST_OUT                      (0x40c0a)
#define P_EMMC_A_GCLKTEST_OUT                      (volatile uint32_t *)((0x40c0a  << 2) + 0xffd00000)
#define   EMMC_A_GEYETEST_LOG                      (0x40c0b)
#define P_EMMC_A_GEYETEST_LOG                      (volatile uint32_t *)((0x40c0b  << 2) + 0xffd00000)
#define   EMMC_A_GEYETEST_OUT0                     (0x40c0c)
#define P_EMMC_A_GEYETEST_OUT0                     (volatile uint32_t *)((0x40c0c  << 2) + 0xffd00000)
#define   EMMC_A_GEYETEST_OUT1                     (0x40c0d)
#define P_EMMC_A_GEYETEST_OUT1                     (volatile uint32_t *)((0x40c0d  << 2) + 0xffd00000)
#define   EMMC_A_GINTF3                            (0x40c0e)
#define P_EMMC_A_GINTF3                            (volatile uint32_t *)((0x40c0e  << 2) + 0xffd00000)
#define   EMMC_A_GRESERVE                          (0x40c0f)
#define P_EMMC_A_GRESERVE                          (volatile uint32_t *)((0x40c0f  << 2) + 0xffd00000)
#define   EMMC_A_GSTART                            (0x40c10)
#define P_EMMC_A_GSTART                            (volatile uint32_t *)((0x40c10  << 2) + 0xffd00000)
#define   EMMC_A_GCFG                              (0x40c11)
#define P_EMMC_A_GCFG                              (volatile uint32_t *)((0x40c11  << 2) + 0xffd00000)
#define   EMMC_A_GSTATUS                           (0x40c12)
#define P_EMMC_A_GSTATUS                           (volatile uint32_t *)((0x40c12  << 2) + 0xffd00000)
#define   EMMC_A_GIRQ_EN                           (0x40c13)
#define P_EMMC_A_GIRQ_EN                           (volatile uint32_t *)((0x40c13  << 2) + 0xffd00000)
#define   EMMC_A_GCMD_CFG                          (0x40c14)
#define P_EMMC_A_GCMD_CFG                          (volatile uint32_t *)((0x40c14  << 2) + 0xffd00000)
#define   EMMC_A_GCMD_ARG                          (0x40c15)
#define P_EMMC_A_GCMD_ARG                          (volatile uint32_t *)((0x40c15  << 2) + 0xffd00000)
#define   EMMC_A_GCMD_DAT                          (0x40c16)
#define P_EMMC_A_GCMD_DAT                          (volatile uint32_t *)((0x40c16  << 2) + 0xffd00000)
#define   EMMC_A_GCMD_RSP                          (0x40c17)
#define P_EMMC_A_GCMD_RSP                          (volatile uint32_t *)((0x40c17  << 2) + 0xffd00000)
#define   EMMC_A_GCMD_RSP1                         (0x40c18)
#define P_EMMC_A_GCMD_RSP1                         (volatile uint32_t *)((0x40c18  << 2) + 0xffd00000)
#define   EMMC_A_GCMD_RSP2                         (0x40c19)
#define P_EMMC_A_GCMD_RSP2                         (volatile uint32_t *)((0x40c19  << 2) + 0xffd00000)
#define   EMMC_A_GCMD_RSP3                         (0x40c1a)
#define P_EMMC_A_GCMD_RSP3                         (volatile uint32_t *)((0x40c1a  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_6C                       (0x40c1b)
#define P_EMMC_A_RESERVED_6C                       (volatile uint32_t *)((0x40c1b  << 2) + 0xffd00000)
#define   EMMC_A_GCURR_CFG                         (0x40c1c)
#define P_EMMC_A_GCURR_CFG                         (volatile uint32_t *)((0x40c1c  << 2) + 0xffd00000)
#define   EMMC_A_GCURR_ARG                         (0x40c1d)
#define P_EMMC_A_GCURR_ARG                         (volatile uint32_t *)((0x40c1d  << 2) + 0xffd00000)
#define   EMMC_A_GCURR_DAT                         (0x40c1e)
#define P_EMMC_A_GCURR_DAT                         (volatile uint32_t *)((0x40c1e  << 2) + 0xffd00000)
#define   EMMC_A_GCURR_RSP                         (0x40c1f)
#define P_EMMC_A_GCURR_RSP                         (volatile uint32_t *)((0x40c1f  << 2) + 0xffd00000)
#define   EMMC_A_GNEXT_CFG                         (0x40c20)
#define P_EMMC_A_GNEXT_CFG                         (volatile uint32_t *)((0x40c20  << 2) + 0xffd00000)
#define   EMMC_A_GNEXT_ARG                         (0x40c21)
#define P_EMMC_A_GNEXT_ARG                         (volatile uint32_t *)((0x40c21  << 2) + 0xffd00000)
#define   EMMC_A_GNEXT_DAT                         (0x40c22)
#define P_EMMC_A_GNEXT_DAT                         (volatile uint32_t *)((0x40c22  << 2) + 0xffd00000)
#define   EMMC_A_GNEXT_RSP                         (0x40c23)
#define P_EMMC_A_GNEXT_RSP                         (volatile uint32_t *)((0x40c23  << 2) + 0xffd00000)
#define   EMMC_A_GRXD                              (0x40c24)
#define P_EMMC_A_GRXD                              (volatile uint32_t *)((0x40c24  << 2) + 0xffd00000)
#define   EMMC_A_GTXD                              (0x40c25)
#define P_EMMC_A_GTXD                              (volatile uint32_t *)((0x40c25  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_00                    (0x40c26)
#define P_EMMC_A_RESERVED_98_00                    (volatile uint32_t *)((0x40c26  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_01                    (0x40c27)
#define P_EMMC_A_RESERVED_98_01                    (volatile uint32_t *)((0x40c27  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_02                    (0x40c28)
#define P_EMMC_A_RESERVED_98_02                    (volatile uint32_t *)((0x40c28  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_03                    (0x40c29)
#define P_EMMC_A_RESERVED_98_03                    (volatile uint32_t *)((0x40c29  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_04                    (0x40c2a)
#define P_EMMC_A_RESERVED_98_04                    (volatile uint32_t *)((0x40c2a  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_05                    (0x40c2b)
#define P_EMMC_A_RESERVED_98_05                    (volatile uint32_t *)((0x40c2b  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_06                    (0x40c2c)
#define P_EMMC_A_RESERVED_98_06                    (volatile uint32_t *)((0x40c2c  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_07                    (0x40c2d)
#define P_EMMC_A_RESERVED_98_07                    (volatile uint32_t *)((0x40c2d  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_08                    (0x40c2e)
#define P_EMMC_A_RESERVED_98_08                    (volatile uint32_t *)((0x40c2e  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_09                    (0x40c2f)
#define P_EMMC_A_RESERVED_98_09                    (volatile uint32_t *)((0x40c2f  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_10                    (0x40c30)
#define P_EMMC_A_RESERVED_98_10                    (volatile uint32_t *)((0x40c30  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_11                    (0x40c31)
#define P_EMMC_A_RESERVED_98_11                    (volatile uint32_t *)((0x40c31  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_12                    (0x40c32)
#define P_EMMC_A_RESERVED_98_12                    (volatile uint32_t *)((0x40c32  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_13                    (0x40c33)
#define P_EMMC_A_RESERVED_98_13                    (volatile uint32_t *)((0x40c33  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_14                    (0x40c34)
#define P_EMMC_A_RESERVED_98_14                    (volatile uint32_t *)((0x40c34  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_15                    (0x40c35)
#define P_EMMC_A_RESERVED_98_15                    (volatile uint32_t *)((0x40c35  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_16                    (0x40c36)
#define P_EMMC_A_RESERVED_98_16                    (volatile uint32_t *)((0x40c36  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_17                    (0x40c37)
#define P_EMMC_A_RESERVED_98_17                    (volatile uint32_t *)((0x40c37  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_18                    (0x40c38)
#define P_EMMC_A_RESERVED_98_18                    (volatile uint32_t *)((0x40c38  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_19                    (0x40c39)
#define P_EMMC_A_RESERVED_98_19                    (volatile uint32_t *)((0x40c39  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_20                    (0x40c3a)
#define P_EMMC_A_RESERVED_98_20                    (volatile uint32_t *)((0x40c3a  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_21                    (0x40c3b)
#define P_EMMC_A_RESERVED_98_21                    (volatile uint32_t *)((0x40c3b  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_22                    (0x40c3c)
#define P_EMMC_A_RESERVED_98_22                    (volatile uint32_t *)((0x40c3c  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_23                    (0x40c3d)
#define P_EMMC_A_RESERVED_98_23                    (volatile uint32_t *)((0x40c3d  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_24                    (0x40c3e)
#define P_EMMC_A_RESERVED_98_24                    (volatile uint32_t *)((0x40c3e  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_25                    (0x40c3f)
#define P_EMMC_A_RESERVED_98_25                    (volatile uint32_t *)((0x40c3f  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_26                    (0x40c40)
#define P_EMMC_A_RESERVED_98_26                    (volatile uint32_t *)((0x40c40  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_27                    (0x40c41)
#define P_EMMC_A_RESERVED_98_27                    (volatile uint32_t *)((0x40c41  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_28                    (0x40c42)
#define P_EMMC_A_RESERVED_98_28                    (volatile uint32_t *)((0x40c42  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_29                    (0x40c43)
#define P_EMMC_A_RESERVED_98_29                    (volatile uint32_t *)((0x40c43  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_30                    (0x40c44)
#define P_EMMC_A_RESERVED_98_30                    (volatile uint32_t *)((0x40c44  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_31                    (0x40c45)
#define P_EMMC_A_RESERVED_98_31                    (volatile uint32_t *)((0x40c45  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_32                    (0x40c46)
#define P_EMMC_A_RESERVED_98_32                    (volatile uint32_t *)((0x40c46  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_33                    (0x40c47)
#define P_EMMC_A_RESERVED_98_33                    (volatile uint32_t *)((0x40c47  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_34                    (0x40c48)
#define P_EMMC_A_RESERVED_98_34                    (volatile uint32_t *)((0x40c48  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_35                    (0x40c49)
#define P_EMMC_A_RESERVED_98_35                    (volatile uint32_t *)((0x40c49  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_36                    (0x40c4a)
#define P_EMMC_A_RESERVED_98_36                    (volatile uint32_t *)((0x40c4a  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_37                    (0x40c4b)
#define P_EMMC_A_RESERVED_98_37                    (volatile uint32_t *)((0x40c4b  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_38                    (0x40c4c)
#define P_EMMC_A_RESERVED_98_38                    (volatile uint32_t *)((0x40c4c  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_39                    (0x40c4d)
#define P_EMMC_A_RESERVED_98_39                    (volatile uint32_t *)((0x40c4d  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_40                    (0x40c4e)
#define P_EMMC_A_RESERVED_98_40                    (volatile uint32_t *)((0x40c4e  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_41                    (0x40c4f)
#define P_EMMC_A_RESERVED_98_41                    (volatile uint32_t *)((0x40c4f  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_42                    (0x40c50)
#define P_EMMC_A_RESERVED_98_42                    (volatile uint32_t *)((0x40c50  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_43                    (0x40c51)
#define P_EMMC_A_RESERVED_98_43                    (volatile uint32_t *)((0x40c51  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_44                    (0x40c52)
#define P_EMMC_A_RESERVED_98_44                    (volatile uint32_t *)((0x40c52  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_45                    (0x40c53)
#define P_EMMC_A_RESERVED_98_45                    (volatile uint32_t *)((0x40c53  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_46                    (0x40c54)
#define P_EMMC_A_RESERVED_98_46                    (volatile uint32_t *)((0x40c54  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_47                    (0x40c55)
#define P_EMMC_A_RESERVED_98_47                    (volatile uint32_t *)((0x40c55  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_48                    (0x40c56)
#define P_EMMC_A_RESERVED_98_48                    (volatile uint32_t *)((0x40c56  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_49                    (0x40c57)
#define P_EMMC_A_RESERVED_98_49                    (volatile uint32_t *)((0x40c57  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_50                    (0x40c58)
#define P_EMMC_A_RESERVED_98_50                    (volatile uint32_t *)((0x40c58  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_51                    (0x40c59)
#define P_EMMC_A_RESERVED_98_51                    (volatile uint32_t *)((0x40c59  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_52                    (0x40c5a)
#define P_EMMC_A_RESERVED_98_52                    (volatile uint32_t *)((0x40c5a  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_53                    (0x40c5b)
#define P_EMMC_A_RESERVED_98_53                    (volatile uint32_t *)((0x40c5b  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_54                    (0x40c5c)
#define P_EMMC_A_RESERVED_98_54                    (volatile uint32_t *)((0x40c5c  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_55                    (0x40c5d)
#define P_EMMC_A_RESERVED_98_55                    (volatile uint32_t *)((0x40c5d  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_56                    (0x40c5e)
#define P_EMMC_A_RESERVED_98_56                    (volatile uint32_t *)((0x40c5e  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_57                    (0x40c5f)
#define P_EMMC_A_RESERVED_98_57                    (volatile uint32_t *)((0x40c5f  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_58                    (0x40c60)
#define P_EMMC_A_RESERVED_98_58                    (volatile uint32_t *)((0x40c60  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_59                    (0x40c61)
#define P_EMMC_A_RESERVED_98_59                    (volatile uint32_t *)((0x40c61  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_60                    (0x40c62)
#define P_EMMC_A_RESERVED_98_60                    (volatile uint32_t *)((0x40c62  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_61                    (0x40c63)
#define P_EMMC_A_RESERVED_98_61                    (volatile uint32_t *)((0x40c63  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_62                    (0x40c64)
#define P_EMMC_A_RESERVED_98_62                    (volatile uint32_t *)((0x40c64  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_63                    (0x40c65)
#define P_EMMC_A_RESERVED_98_63                    (volatile uint32_t *)((0x40c65  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_64                    (0x40c66)
#define P_EMMC_A_RESERVED_98_64                    (volatile uint32_t *)((0x40c66  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_65                    (0x40c67)
#define P_EMMC_A_RESERVED_98_65                    (volatile uint32_t *)((0x40c67  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_66                    (0x40c68)
#define P_EMMC_A_RESERVED_98_66                    (volatile uint32_t *)((0x40c68  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_67                    (0x40c69)
#define P_EMMC_A_RESERVED_98_67                    (volatile uint32_t *)((0x40c69  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_68                    (0x40c6a)
#define P_EMMC_A_RESERVED_98_68                    (volatile uint32_t *)((0x40c6a  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_69                    (0x40c6b)
#define P_EMMC_A_RESERVED_98_69                    (volatile uint32_t *)((0x40c6b  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_70                    (0x40c6c)
#define P_EMMC_A_RESERVED_98_70                    (volatile uint32_t *)((0x40c6c  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_71                    (0x40c6d)
#define P_EMMC_A_RESERVED_98_71                    (volatile uint32_t *)((0x40c6d  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_72                    (0x40c6e)
#define P_EMMC_A_RESERVED_98_72                    (volatile uint32_t *)((0x40c6e  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_73                    (0x40c6f)
#define P_EMMC_A_RESERVED_98_73                    (volatile uint32_t *)((0x40c6f  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_74                    (0x40c70)
#define P_EMMC_A_RESERVED_98_74                    (volatile uint32_t *)((0x40c70  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_75                    (0x40c71)
#define P_EMMC_A_RESERVED_98_75                    (volatile uint32_t *)((0x40c71  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_76                    (0x40c72)
#define P_EMMC_A_RESERVED_98_76                    (volatile uint32_t *)((0x40c72  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_77                    (0x40c73)
#define P_EMMC_A_RESERVED_98_77                    (volatile uint32_t *)((0x40c73  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_78                    (0x40c74)
#define P_EMMC_A_RESERVED_98_78                    (volatile uint32_t *)((0x40c74  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_79                    (0x40c75)
#define P_EMMC_A_RESERVED_98_79                    (volatile uint32_t *)((0x40c75  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_80                    (0x40c76)
#define P_EMMC_A_RESERVED_98_80                    (volatile uint32_t *)((0x40c76  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_81                    (0x40c77)
#define P_EMMC_A_RESERVED_98_81                    (volatile uint32_t *)((0x40c77  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_82                    (0x40c78)
#define P_EMMC_A_RESERVED_98_82                    (volatile uint32_t *)((0x40c78  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_83                    (0x40c79)
#define P_EMMC_A_RESERVED_98_83                    (volatile uint32_t *)((0x40c79  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_84                    (0x40c7a)
#define P_EMMC_A_RESERVED_98_84                    (volatile uint32_t *)((0x40c7a  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_85                    (0x40c7b)
#define P_EMMC_A_RESERVED_98_85                    (volatile uint32_t *)((0x40c7b  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_86                    (0x40c7c)
#define P_EMMC_A_RESERVED_98_86                    (volatile uint32_t *)((0x40c7c  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_87                    (0x40c7d)
#define P_EMMC_A_RESERVED_98_87                    (volatile uint32_t *)((0x40c7d  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_88                    (0x40c7e)
#define P_EMMC_A_RESERVED_98_88                    (volatile uint32_t *)((0x40c7e  << 2) + 0xffd00000)
#define   EMMC_A_RESERVED_98_89                    (0x40c7f)
#define P_EMMC_A_RESERVED_98_89                    (volatile uint32_t *)((0x40c7f  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_000                         (0x40c80)
#define P_EMMC_A_GDESC_000                         (volatile uint32_t *)((0x40c80  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_001                         (0x40c81)
#define P_EMMC_A_GDESC_001                         (volatile uint32_t *)((0x40c81  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_002                         (0x40c82)
#define P_EMMC_A_GDESC_002                         (volatile uint32_t *)((0x40c82  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_003                         (0x40c83)
#define P_EMMC_A_GDESC_003                         (volatile uint32_t *)((0x40c83  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_004                         (0x40c84)
#define P_EMMC_A_GDESC_004                         (volatile uint32_t *)((0x40c84  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_005                         (0x40c85)
#define P_EMMC_A_GDESC_005                         (volatile uint32_t *)((0x40c85  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_006                         (0x40c86)
#define P_EMMC_A_GDESC_006                         (volatile uint32_t *)((0x40c86  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_007                         (0x40c87)
#define P_EMMC_A_GDESC_007                         (volatile uint32_t *)((0x40c87  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_008                         (0x40c88)
#define P_EMMC_A_GDESC_008                         (volatile uint32_t *)((0x40c88  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_009                         (0x40c89)
#define P_EMMC_A_GDESC_009                         (volatile uint32_t *)((0x40c89  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_010                         (0x40c8a)
#define P_EMMC_A_GDESC_010                         (volatile uint32_t *)((0x40c8a  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_011                         (0x40c8b)
#define P_EMMC_A_GDESC_011                         (volatile uint32_t *)((0x40c8b  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_012                         (0x40c8c)
#define P_EMMC_A_GDESC_012                         (volatile uint32_t *)((0x40c8c  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_013                         (0x40c8d)
#define P_EMMC_A_GDESC_013                         (volatile uint32_t *)((0x40c8d  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_014                         (0x40c8e)
#define P_EMMC_A_GDESC_014                         (volatile uint32_t *)((0x40c8e  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_015                         (0x40c8f)
#define P_EMMC_A_GDESC_015                         (volatile uint32_t *)((0x40c8f  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_016                         (0x40c90)
#define P_EMMC_A_GDESC_016                         (volatile uint32_t *)((0x40c90  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_017                         (0x40c91)
#define P_EMMC_A_GDESC_017                         (volatile uint32_t *)((0x40c91  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_018                         (0x40c92)
#define P_EMMC_A_GDESC_018                         (volatile uint32_t *)((0x40c92  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_019                         (0x40c93)
#define P_EMMC_A_GDESC_019                         (volatile uint32_t *)((0x40c93  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_020                         (0x40c94)
#define P_EMMC_A_GDESC_020                         (volatile uint32_t *)((0x40c94  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_021                         (0x40c95)
#define P_EMMC_A_GDESC_021                         (volatile uint32_t *)((0x40c95  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_022                         (0x40c96)
#define P_EMMC_A_GDESC_022                         (volatile uint32_t *)((0x40c96  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_023                         (0x40c97)
#define P_EMMC_A_GDESC_023                         (volatile uint32_t *)((0x40c97  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_024                         (0x40c98)
#define P_EMMC_A_GDESC_024                         (volatile uint32_t *)((0x40c98  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_025                         (0x40c99)
#define P_EMMC_A_GDESC_025                         (volatile uint32_t *)((0x40c99  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_026                         (0x40c9a)
#define P_EMMC_A_GDESC_026                         (volatile uint32_t *)((0x40c9a  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_027                         (0x40c9b)
#define P_EMMC_A_GDESC_027                         (volatile uint32_t *)((0x40c9b  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_028                         (0x40c9c)
#define P_EMMC_A_GDESC_028                         (volatile uint32_t *)((0x40c9c  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_029                         (0x40c9d)
#define P_EMMC_A_GDESC_029                         (volatile uint32_t *)((0x40c9d  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_030                         (0x40c9e)
#define P_EMMC_A_GDESC_030                         (volatile uint32_t *)((0x40c9e  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_031                         (0x40c9f)
#define P_EMMC_A_GDESC_031                         (volatile uint32_t *)((0x40c9f  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_032                         (0x40ca0)
#define P_EMMC_A_GDESC_032                         (volatile uint32_t *)((0x40ca0  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_033                         (0x40ca1)
#define P_EMMC_A_GDESC_033                         (volatile uint32_t *)((0x40ca1  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_034                         (0x40ca2)
#define P_EMMC_A_GDESC_034                         (volatile uint32_t *)((0x40ca2  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_035                         (0x40ca3)
#define P_EMMC_A_GDESC_035                         (volatile uint32_t *)((0x40ca3  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_036                         (0x40ca4)
#define P_EMMC_A_GDESC_036                         (volatile uint32_t *)((0x40ca4  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_037                         (0x40ca5)
#define P_EMMC_A_GDESC_037                         (volatile uint32_t *)((0x40ca5  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_038                         (0x40ca6)
#define P_EMMC_A_GDESC_038                         (volatile uint32_t *)((0x40ca6  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_039                         (0x40ca7)
#define P_EMMC_A_GDESC_039                         (volatile uint32_t *)((0x40ca7  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_040                         (0x40ca8)
#define P_EMMC_A_GDESC_040                         (volatile uint32_t *)((0x40ca8  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_041                         (0x40ca9)
#define P_EMMC_A_GDESC_041                         (volatile uint32_t *)((0x40ca9  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_042                         (0x40caa)
#define P_EMMC_A_GDESC_042                         (volatile uint32_t *)((0x40caa  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_043                         (0x40cab)
#define P_EMMC_A_GDESC_043                         (volatile uint32_t *)((0x40cab  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_044                         (0x40cac)
#define P_EMMC_A_GDESC_044                         (volatile uint32_t *)((0x40cac  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_045                         (0x40cad)
#define P_EMMC_A_GDESC_045                         (volatile uint32_t *)((0x40cad  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_046                         (0x40cae)
#define P_EMMC_A_GDESC_046                         (volatile uint32_t *)((0x40cae  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_047                         (0x40caf)
#define P_EMMC_A_GDESC_047                         (volatile uint32_t *)((0x40caf  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_048                         (0x40cb0)
#define P_EMMC_A_GDESC_048                         (volatile uint32_t *)((0x40cb0  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_049                         (0x40cb1)
#define P_EMMC_A_GDESC_049                         (volatile uint32_t *)((0x40cb1  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_050                         (0x40cb2)
#define P_EMMC_A_GDESC_050                         (volatile uint32_t *)((0x40cb2  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_051                         (0x40cb3)
#define P_EMMC_A_GDESC_051                         (volatile uint32_t *)((0x40cb3  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_052                         (0x40cb4)
#define P_EMMC_A_GDESC_052                         (volatile uint32_t *)((0x40cb4  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_053                         (0x40cb5)
#define P_EMMC_A_GDESC_053                         (volatile uint32_t *)((0x40cb5  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_054                         (0x40cb6)
#define P_EMMC_A_GDESC_054                         (volatile uint32_t *)((0x40cb6  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_055                         (0x40cb7)
#define P_EMMC_A_GDESC_055                         (volatile uint32_t *)((0x40cb7  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_056                         (0x40cb8)
#define P_EMMC_A_GDESC_056                         (volatile uint32_t *)((0x40cb8  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_057                         (0x40cb9)
#define P_EMMC_A_GDESC_057                         (volatile uint32_t *)((0x40cb9  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_058                         (0x40cba)
#define P_EMMC_A_GDESC_058                         (volatile uint32_t *)((0x40cba  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_059                         (0x40cbb)
#define P_EMMC_A_GDESC_059                         (volatile uint32_t *)((0x40cbb  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_060                         (0x40cbc)
#define P_EMMC_A_GDESC_060                         (volatile uint32_t *)((0x40cbc  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_061                         (0x40cbd)
#define P_EMMC_A_GDESC_061                         (volatile uint32_t *)((0x40cbd  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_062                         (0x40cbe)
#define P_EMMC_A_GDESC_062                         (volatile uint32_t *)((0x40cbe  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_063                         (0x40cbf)
#define P_EMMC_A_GDESC_063                         (volatile uint32_t *)((0x40cbf  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_064                         (0x40cc0)
#define P_EMMC_A_GDESC_064                         (volatile uint32_t *)((0x40cc0  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_065                         (0x40cc1)
#define P_EMMC_A_GDESC_065                         (volatile uint32_t *)((0x40cc1  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_066                         (0x40cc2)
#define P_EMMC_A_GDESC_066                         (volatile uint32_t *)((0x40cc2  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_067                         (0x40cc3)
#define P_EMMC_A_GDESC_067                         (volatile uint32_t *)((0x40cc3  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_068                         (0x40cc4)
#define P_EMMC_A_GDESC_068                         (volatile uint32_t *)((0x40cc4  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_069                         (0x40cc5)
#define P_EMMC_A_GDESC_069                         (volatile uint32_t *)((0x40cc5  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_070                         (0x40cc6)
#define P_EMMC_A_GDESC_070                         (volatile uint32_t *)((0x40cc6  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_071                         (0x40cc7)
#define P_EMMC_A_GDESC_071                         (volatile uint32_t *)((0x40cc7  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_072                         (0x40cc8)
#define P_EMMC_A_GDESC_072                         (volatile uint32_t *)((0x40cc8  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_073                         (0x40cc9)
#define P_EMMC_A_GDESC_073                         (volatile uint32_t *)((0x40cc9  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_074                         (0x40cca)
#define P_EMMC_A_GDESC_074                         (volatile uint32_t *)((0x40cca  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_075                         (0x40ccb)
#define P_EMMC_A_GDESC_075                         (volatile uint32_t *)((0x40ccb  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_076                         (0x40ccc)
#define P_EMMC_A_GDESC_076                         (volatile uint32_t *)((0x40ccc  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_077                         (0x40ccd)
#define P_EMMC_A_GDESC_077                         (volatile uint32_t *)((0x40ccd  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_078                         (0x40cce)
#define P_EMMC_A_GDESC_078                         (volatile uint32_t *)((0x40cce  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_079                         (0x40ccf)
#define P_EMMC_A_GDESC_079                         (volatile uint32_t *)((0x40ccf  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_080                         (0x40cd0)
#define P_EMMC_A_GDESC_080                         (volatile uint32_t *)((0x40cd0  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_081                         (0x40cd1)
#define P_EMMC_A_GDESC_081                         (volatile uint32_t *)((0x40cd1  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_082                         (0x40cd2)
#define P_EMMC_A_GDESC_082                         (volatile uint32_t *)((0x40cd2  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_083                         (0x40cd3)
#define P_EMMC_A_GDESC_083                         (volatile uint32_t *)((0x40cd3  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_084                         (0x40cd4)
#define P_EMMC_A_GDESC_084                         (volatile uint32_t *)((0x40cd4  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_085                         (0x40cd5)
#define P_EMMC_A_GDESC_085                         (volatile uint32_t *)((0x40cd5  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_086                         (0x40cd6)
#define P_EMMC_A_GDESC_086                         (volatile uint32_t *)((0x40cd6  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_087                         (0x40cd7)
#define P_EMMC_A_GDESC_087                         (volatile uint32_t *)((0x40cd7  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_088                         (0x40cd8)
#define P_EMMC_A_GDESC_088                         (volatile uint32_t *)((0x40cd8  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_089                         (0x40cd9)
#define P_EMMC_A_GDESC_089                         (volatile uint32_t *)((0x40cd9  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_090                         (0x40cda)
#define P_EMMC_A_GDESC_090                         (volatile uint32_t *)((0x40cda  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_091                         (0x40cdb)
#define P_EMMC_A_GDESC_091                         (volatile uint32_t *)((0x40cdb  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_092                         (0x40cdc)
#define P_EMMC_A_GDESC_092                         (volatile uint32_t *)((0x40cdc  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_093                         (0x40cdd)
#define P_EMMC_A_GDESC_093                         (volatile uint32_t *)((0x40cdd  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_094                         (0x40cde)
#define P_EMMC_A_GDESC_094                         (volatile uint32_t *)((0x40cde  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_095                         (0x40cdf)
#define P_EMMC_A_GDESC_095                         (volatile uint32_t *)((0x40cdf  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_096                         (0x40ce0)
#define P_EMMC_A_GDESC_096                         (volatile uint32_t *)((0x40ce0  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_097                         (0x40ce1)
#define P_EMMC_A_GDESC_097                         (volatile uint32_t *)((0x40ce1  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_098                         (0x40ce2)
#define P_EMMC_A_GDESC_098                         (volatile uint32_t *)((0x40ce2  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_099                         (0x40ce3)
#define P_EMMC_A_GDESC_099                         (volatile uint32_t *)((0x40ce3  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_100                         (0x40ce4)
#define P_EMMC_A_GDESC_100                         (volatile uint32_t *)((0x40ce4  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_101                         (0x40ce5)
#define P_EMMC_A_GDESC_101                         (volatile uint32_t *)((0x40ce5  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_102                         (0x40ce6)
#define P_EMMC_A_GDESC_102                         (volatile uint32_t *)((0x40ce6  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_103                         (0x40ce7)
#define P_EMMC_A_GDESC_103                         (volatile uint32_t *)((0x40ce7  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_104                         (0x40ce8)
#define P_EMMC_A_GDESC_104                         (volatile uint32_t *)((0x40ce8  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_105                         (0x40ce9)
#define P_EMMC_A_GDESC_105                         (volatile uint32_t *)((0x40ce9  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_106                         (0x40cea)
#define P_EMMC_A_GDESC_106                         (volatile uint32_t *)((0x40cea  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_107                         (0x40ceb)
#define P_EMMC_A_GDESC_107                         (volatile uint32_t *)((0x40ceb  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_108                         (0x40cec)
#define P_EMMC_A_GDESC_108                         (volatile uint32_t *)((0x40cec  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_109                         (0x40ced)
#define P_EMMC_A_GDESC_109                         (volatile uint32_t *)((0x40ced  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_110                         (0x40cee)
#define P_EMMC_A_GDESC_110                         (volatile uint32_t *)((0x40cee  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_111                         (0x40cef)
#define P_EMMC_A_GDESC_111                         (volatile uint32_t *)((0x40cef  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_112                         (0x40cf0)
#define P_EMMC_A_GDESC_112                         (volatile uint32_t *)((0x40cf0  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_113                         (0x40cf1)
#define P_EMMC_A_GDESC_113                         (volatile uint32_t *)((0x40cf1  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_114                         (0x40cf2)
#define P_EMMC_A_GDESC_114                         (volatile uint32_t *)((0x40cf2  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_115                         (0x40cf3)
#define P_EMMC_A_GDESC_115                         (volatile uint32_t *)((0x40cf3  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_116                         (0x40cf4)
#define P_EMMC_A_GDESC_116                         (volatile uint32_t *)((0x40cf4  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_117                         (0x40cf5)
#define P_EMMC_A_GDESC_117                         (volatile uint32_t *)((0x40cf5  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_118                         (0x40cf6)
#define P_EMMC_A_GDESC_118                         (volatile uint32_t *)((0x40cf6  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_119                         (0x40cf7)
#define P_EMMC_A_GDESC_119                         (volatile uint32_t *)((0x40cf7  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_120                         (0x40cf8)
#define P_EMMC_A_GDESC_120                         (volatile uint32_t *)((0x40cf8  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_121                         (0x40cf9)
#define P_EMMC_A_GDESC_121                         (volatile uint32_t *)((0x40cf9  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_122                         (0x40cfa)
#define P_EMMC_A_GDESC_122                         (volatile uint32_t *)((0x40cfa  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_123                         (0x40cfb)
#define P_EMMC_A_GDESC_123                         (volatile uint32_t *)((0x40cfb  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_124                         (0x40cfc)
#define P_EMMC_A_GDESC_124                         (volatile uint32_t *)((0x40cfc  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_125                         (0x40cfd)
#define P_EMMC_A_GDESC_125                         (volatile uint32_t *)((0x40cfd  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_126                         (0x40cfe)
#define P_EMMC_A_GDESC_126                         (volatile uint32_t *)((0x40cfe  << 2) + 0xffd00000)
#define   EMMC_A_GDESC_127                         (0x40cff)
#define P_EMMC_A_GDESC_127                         (volatile uint32_t *)((0x40cff  << 2) + 0xffd00000)
#define   EMMC_A_GPING_000                         (0x40d00)
#define P_EMMC_A_GPING_000                         (volatile uint32_t *)((0x40d00  << 2) + 0xffd00000)
#define   EMMC_A_GPING_001                         (0x40d01)
#define P_EMMC_A_GPING_001                         (volatile uint32_t *)((0x40d01  << 2) + 0xffd00000)
#define   EMMC_A_GPING_002                         (0x40d02)
#define P_EMMC_A_GPING_002                         (volatile uint32_t *)((0x40d02  << 2) + 0xffd00000)
#define   EMMC_A_GPING_003                         (0x40d03)
#define P_EMMC_A_GPING_003                         (volatile uint32_t *)((0x40d03  << 2) + 0xffd00000)
#define   EMMC_A_GPING_004                         (0x40d04)
#define P_EMMC_A_GPING_004                         (volatile uint32_t *)((0x40d04  << 2) + 0xffd00000)
#define   EMMC_A_GPING_005                         (0x40d05)
#define P_EMMC_A_GPING_005                         (volatile uint32_t *)((0x40d05  << 2) + 0xffd00000)
#define   EMMC_A_GPING_006                         (0x40d06)
#define P_EMMC_A_GPING_006                         (volatile uint32_t *)((0x40d06  << 2) + 0xffd00000)
#define   EMMC_A_GPING_007                         (0x40d07)
#define P_EMMC_A_GPING_007                         (volatile uint32_t *)((0x40d07  << 2) + 0xffd00000)
#define   EMMC_A_GPING_008                         (0x40d08)
#define P_EMMC_A_GPING_008                         (volatile uint32_t *)((0x40d08  << 2) + 0xffd00000)
#define   EMMC_A_GPING_009                         (0x40d09)
#define P_EMMC_A_GPING_009                         (volatile uint32_t *)((0x40d09  << 2) + 0xffd00000)
#define   EMMC_A_GPING_010                         (0x40d0a)
#define P_EMMC_A_GPING_010                         (volatile uint32_t *)((0x40d0a  << 2) + 0xffd00000)
#define   EMMC_A_GPING_011                         (0x40d0b)
#define P_EMMC_A_GPING_011                         (volatile uint32_t *)((0x40d0b  << 2) + 0xffd00000)
#define   EMMC_A_GPING_012                         (0x40d0c)
#define P_EMMC_A_GPING_012                         (volatile uint32_t *)((0x40d0c  << 2) + 0xffd00000)
#define   EMMC_A_GPING_013                         (0x40d0d)
#define P_EMMC_A_GPING_013                         (volatile uint32_t *)((0x40d0d  << 2) + 0xffd00000)
#define   EMMC_A_GPING_014                         (0x40d0e)
#define P_EMMC_A_GPING_014                         (volatile uint32_t *)((0x40d0e  << 2) + 0xffd00000)
#define   EMMC_A_GPING_015                         (0x40d0f)
#define P_EMMC_A_GPING_015                         (volatile uint32_t *)((0x40d0f  << 2) + 0xffd00000)
#define   EMMC_A_GPING_016                         (0x40d10)
#define P_EMMC_A_GPING_016                         (volatile uint32_t *)((0x40d10  << 2) + 0xffd00000)
#define   EMMC_A_GPING_017                         (0x40d11)
#define P_EMMC_A_GPING_017                         (volatile uint32_t *)((0x40d11  << 2) + 0xffd00000)
#define   EMMC_A_GPING_018                         (0x40d12)
#define P_EMMC_A_GPING_018                         (volatile uint32_t *)((0x40d12  << 2) + 0xffd00000)
#define   EMMC_A_GPING_019                         (0x40d13)
#define P_EMMC_A_GPING_019                         (volatile uint32_t *)((0x40d13  << 2) + 0xffd00000)
#define   EMMC_A_GPING_020                         (0x40d14)
#define P_EMMC_A_GPING_020                         (volatile uint32_t *)((0x40d14  << 2) + 0xffd00000)
#define   EMMC_A_GPING_021                         (0x40d15)
#define P_EMMC_A_GPING_021                         (volatile uint32_t *)((0x40d15  << 2) + 0xffd00000)
#define   EMMC_A_GPING_022                         (0x40d16)
#define P_EMMC_A_GPING_022                         (volatile uint32_t *)((0x40d16  << 2) + 0xffd00000)
#define   EMMC_A_GPING_023                         (0x40d17)
#define P_EMMC_A_GPING_023                         (volatile uint32_t *)((0x40d17  << 2) + 0xffd00000)
#define   EMMC_A_GPING_024                         (0x40d18)
#define P_EMMC_A_GPING_024                         (volatile uint32_t *)((0x40d18  << 2) + 0xffd00000)
#define   EMMC_A_GPING_025                         (0x40d19)
#define P_EMMC_A_GPING_025                         (volatile uint32_t *)((0x40d19  << 2) + 0xffd00000)
#define   EMMC_A_GPING_026                         (0x40d1a)
#define P_EMMC_A_GPING_026                         (volatile uint32_t *)((0x40d1a  << 2) + 0xffd00000)
#define   EMMC_A_GPING_027                         (0x40d1b)
#define P_EMMC_A_GPING_027                         (volatile uint32_t *)((0x40d1b  << 2) + 0xffd00000)
#define   EMMC_A_GPING_028                         (0x40d1c)
#define P_EMMC_A_GPING_028                         (volatile uint32_t *)((0x40d1c  << 2) + 0xffd00000)
#define   EMMC_A_GPING_029                         (0x40d1d)
#define P_EMMC_A_GPING_029                         (volatile uint32_t *)((0x40d1d  << 2) + 0xffd00000)
#define   EMMC_A_GPING_030                         (0x40d1e)
#define P_EMMC_A_GPING_030                         (volatile uint32_t *)((0x40d1e  << 2) + 0xffd00000)
#define   EMMC_A_GPING_031                         (0x40d1f)
#define P_EMMC_A_GPING_031                         (volatile uint32_t *)((0x40d1f  << 2) + 0xffd00000)
#define   EMMC_A_GPING_032                         (0x40d20)
#define P_EMMC_A_GPING_032                         (volatile uint32_t *)((0x40d20  << 2) + 0xffd00000)
#define   EMMC_A_GPING_033                         (0x40d21)
#define P_EMMC_A_GPING_033                         (volatile uint32_t *)((0x40d21  << 2) + 0xffd00000)
#define   EMMC_A_GPING_034                         (0x40d22)
#define P_EMMC_A_GPING_034                         (volatile uint32_t *)((0x40d22  << 2) + 0xffd00000)
#define   EMMC_A_GPING_035                         (0x40d23)
#define P_EMMC_A_GPING_035                         (volatile uint32_t *)((0x40d23  << 2) + 0xffd00000)
#define   EMMC_A_GPING_036                         (0x40d24)
#define P_EMMC_A_GPING_036                         (volatile uint32_t *)((0x40d24  << 2) + 0xffd00000)
#define   EMMC_A_GPING_037                         (0x40d25)
#define P_EMMC_A_GPING_037                         (volatile uint32_t *)((0x40d25  << 2) + 0xffd00000)
#define   EMMC_A_GPING_038                         (0x40d26)
#define P_EMMC_A_GPING_038                         (volatile uint32_t *)((0x40d26  << 2) + 0xffd00000)
#define   EMMC_A_GPING_039                         (0x40d27)
#define P_EMMC_A_GPING_039                         (volatile uint32_t *)((0x40d27  << 2) + 0xffd00000)
#define   EMMC_A_GPING_040                         (0x40d28)
#define P_EMMC_A_GPING_040                         (volatile uint32_t *)((0x40d28  << 2) + 0xffd00000)
#define   EMMC_A_GPING_041                         (0x40d29)
#define P_EMMC_A_GPING_041                         (volatile uint32_t *)((0x40d29  << 2) + 0xffd00000)
#define   EMMC_A_GPING_042                         (0x40d2a)
#define P_EMMC_A_GPING_042                         (volatile uint32_t *)((0x40d2a  << 2) + 0xffd00000)
#define   EMMC_A_GPING_043                         (0x40d2b)
#define P_EMMC_A_GPING_043                         (volatile uint32_t *)((0x40d2b  << 2) + 0xffd00000)
#define   EMMC_A_GPING_044                         (0x40d2c)
#define P_EMMC_A_GPING_044                         (volatile uint32_t *)((0x40d2c  << 2) + 0xffd00000)
#define   EMMC_A_GPING_045                         (0x40d2d)
#define P_EMMC_A_GPING_045                         (volatile uint32_t *)((0x40d2d  << 2) + 0xffd00000)
#define   EMMC_A_GPING_046                         (0x40d2e)
#define P_EMMC_A_GPING_046                         (volatile uint32_t *)((0x40d2e  << 2) + 0xffd00000)
#define   EMMC_A_GPING_047                         (0x40d2f)
#define P_EMMC_A_GPING_047                         (volatile uint32_t *)((0x40d2f  << 2) + 0xffd00000)
#define   EMMC_A_GPING_048                         (0x40d30)
#define P_EMMC_A_GPING_048                         (volatile uint32_t *)((0x40d30  << 2) + 0xffd00000)
#define   EMMC_A_GPING_049                         (0x40d31)
#define P_EMMC_A_GPING_049                         (volatile uint32_t *)((0x40d31  << 2) + 0xffd00000)
#define   EMMC_A_GPING_050                         (0x40d32)
#define P_EMMC_A_GPING_050                         (volatile uint32_t *)((0x40d32  << 2) + 0xffd00000)
#define   EMMC_A_GPING_051                         (0x40d33)
#define P_EMMC_A_GPING_051                         (volatile uint32_t *)((0x40d33  << 2) + 0xffd00000)
#define   EMMC_A_GPING_052                         (0x40d34)
#define P_EMMC_A_GPING_052                         (volatile uint32_t *)((0x40d34  << 2) + 0xffd00000)
#define   EMMC_A_GPING_053                         (0x40d35)
#define P_EMMC_A_GPING_053                         (volatile uint32_t *)((0x40d35  << 2) + 0xffd00000)
#define   EMMC_A_GPING_054                         (0x40d36)
#define P_EMMC_A_GPING_054                         (volatile uint32_t *)((0x40d36  << 2) + 0xffd00000)
#define   EMMC_A_GPING_055                         (0x40d37)
#define P_EMMC_A_GPING_055                         (volatile uint32_t *)((0x40d37  << 2) + 0xffd00000)
#define   EMMC_A_GPING_056                         (0x40d38)
#define P_EMMC_A_GPING_056                         (volatile uint32_t *)((0x40d38  << 2) + 0xffd00000)
#define   EMMC_A_GPING_057                         (0x40d39)
#define P_EMMC_A_GPING_057                         (volatile uint32_t *)((0x40d39  << 2) + 0xffd00000)
#define   EMMC_A_GPING_058                         (0x40d3a)
#define P_EMMC_A_GPING_058                         (volatile uint32_t *)((0x40d3a  << 2) + 0xffd00000)
#define   EMMC_A_GPING_059                         (0x40d3b)
#define P_EMMC_A_GPING_059                         (volatile uint32_t *)((0x40d3b  << 2) + 0xffd00000)
#define   EMMC_A_GPING_060                         (0x40d3c)
#define P_EMMC_A_GPING_060                         (volatile uint32_t *)((0x40d3c  << 2) + 0xffd00000)
#define   EMMC_A_GPING_061                         (0x40d3d)
#define P_EMMC_A_GPING_061                         (volatile uint32_t *)((0x40d3d  << 2) + 0xffd00000)
#define   EMMC_A_GPING_062                         (0x40d3e)
#define P_EMMC_A_GPING_062                         (volatile uint32_t *)((0x40d3e  << 2) + 0xffd00000)
#define   EMMC_A_GPING_063                         (0x40d3f)
#define P_EMMC_A_GPING_063                         (volatile uint32_t *)((0x40d3f  << 2) + 0xffd00000)
#define   EMMC_A_GPING_064                         (0x40d40)
#define P_EMMC_A_GPING_064                         (volatile uint32_t *)((0x40d40  << 2) + 0xffd00000)
#define   EMMC_A_GPING_065                         (0x40d41)
#define P_EMMC_A_GPING_065                         (volatile uint32_t *)((0x40d41  << 2) + 0xffd00000)
#define   EMMC_A_GPING_066                         (0x40d42)
#define P_EMMC_A_GPING_066                         (volatile uint32_t *)((0x40d42  << 2) + 0xffd00000)
#define   EMMC_A_GPING_067                         (0x40d43)
#define P_EMMC_A_GPING_067                         (volatile uint32_t *)((0x40d43  << 2) + 0xffd00000)
#define   EMMC_A_GPING_068                         (0x40d44)
#define P_EMMC_A_GPING_068                         (volatile uint32_t *)((0x40d44  << 2) + 0xffd00000)
#define   EMMC_A_GPING_069                         (0x40d45)
#define P_EMMC_A_GPING_069                         (volatile uint32_t *)((0x40d45  << 2) + 0xffd00000)
#define   EMMC_A_GPING_070                         (0x40d46)
#define P_EMMC_A_GPING_070                         (volatile uint32_t *)((0x40d46  << 2) + 0xffd00000)
#define   EMMC_A_GPING_071                         (0x40d47)
#define P_EMMC_A_GPING_071                         (volatile uint32_t *)((0x40d47  << 2) + 0xffd00000)
#define   EMMC_A_GPING_072                         (0x40d48)
#define P_EMMC_A_GPING_072                         (volatile uint32_t *)((0x40d48  << 2) + 0xffd00000)
#define   EMMC_A_GPING_073                         (0x40d49)
#define P_EMMC_A_GPING_073                         (volatile uint32_t *)((0x40d49  << 2) + 0xffd00000)
#define   EMMC_A_GPING_074                         (0x40d4a)
#define P_EMMC_A_GPING_074                         (volatile uint32_t *)((0x40d4a  << 2) + 0xffd00000)
#define   EMMC_A_GPING_075                         (0x40d4b)
#define P_EMMC_A_GPING_075                         (volatile uint32_t *)((0x40d4b  << 2) + 0xffd00000)
#define   EMMC_A_GPING_076                         (0x40d4c)
#define P_EMMC_A_GPING_076                         (volatile uint32_t *)((0x40d4c  << 2) + 0xffd00000)
#define   EMMC_A_GPING_077                         (0x40d4d)
#define P_EMMC_A_GPING_077                         (volatile uint32_t *)((0x40d4d  << 2) + 0xffd00000)
#define   EMMC_A_GPING_078                         (0x40d4e)
#define P_EMMC_A_GPING_078                         (volatile uint32_t *)((0x40d4e  << 2) + 0xffd00000)
#define   EMMC_A_GPING_079                         (0x40d4f)
#define P_EMMC_A_GPING_079                         (volatile uint32_t *)((0x40d4f  << 2) + 0xffd00000)
#define   EMMC_A_GPING_080                         (0x40d50)
#define P_EMMC_A_GPING_080                         (volatile uint32_t *)((0x40d50  << 2) + 0xffd00000)
#define   EMMC_A_GPING_081                         (0x40d51)
#define P_EMMC_A_GPING_081                         (volatile uint32_t *)((0x40d51  << 2) + 0xffd00000)
#define   EMMC_A_GPING_082                         (0x40d52)
#define P_EMMC_A_GPING_082                         (volatile uint32_t *)((0x40d52  << 2) + 0xffd00000)
#define   EMMC_A_GPING_083                         (0x40d53)
#define P_EMMC_A_GPING_083                         (volatile uint32_t *)((0x40d53  << 2) + 0xffd00000)
#define   EMMC_A_GPING_084                         (0x40d54)
#define P_EMMC_A_GPING_084                         (volatile uint32_t *)((0x40d54  << 2) + 0xffd00000)
#define   EMMC_A_GPING_085                         (0x40d55)
#define P_EMMC_A_GPING_085                         (volatile uint32_t *)((0x40d55  << 2) + 0xffd00000)
#define   EMMC_A_GPING_086                         (0x40d56)
#define P_EMMC_A_GPING_086                         (volatile uint32_t *)((0x40d56  << 2) + 0xffd00000)
#define   EMMC_A_GPING_087                         (0x40d57)
#define P_EMMC_A_GPING_087                         (volatile uint32_t *)((0x40d57  << 2) + 0xffd00000)
#define   EMMC_A_GPING_088                         (0x40d58)
#define P_EMMC_A_GPING_088                         (volatile uint32_t *)((0x40d58  << 2) + 0xffd00000)
#define   EMMC_A_GPING_089                         (0x40d59)
#define P_EMMC_A_GPING_089                         (volatile uint32_t *)((0x40d59  << 2) + 0xffd00000)
#define   EMMC_A_GPING_090                         (0x40d5a)
#define P_EMMC_A_GPING_090                         (volatile uint32_t *)((0x40d5a  << 2) + 0xffd00000)
#define   EMMC_A_GPING_091                         (0x40d5b)
#define P_EMMC_A_GPING_091                         (volatile uint32_t *)((0x40d5b  << 2) + 0xffd00000)
#define   EMMC_A_GPING_092                         (0x40d5c)
#define P_EMMC_A_GPING_092                         (volatile uint32_t *)((0x40d5c  << 2) + 0xffd00000)
#define   EMMC_A_GPING_093                         (0x40d5d)
#define P_EMMC_A_GPING_093                         (volatile uint32_t *)((0x40d5d  << 2) + 0xffd00000)
#define   EMMC_A_GPING_094                         (0x40d5e)
#define P_EMMC_A_GPING_094                         (volatile uint32_t *)((0x40d5e  << 2) + 0xffd00000)
#define   EMMC_A_GPING_095                         (0x40d5f)
#define P_EMMC_A_GPING_095                         (volatile uint32_t *)((0x40d5f  << 2) + 0xffd00000)
#define   EMMC_A_GPING_096                         (0x40d60)
#define P_EMMC_A_GPING_096                         (volatile uint32_t *)((0x40d60  << 2) + 0xffd00000)
#define   EMMC_A_GPING_097                         (0x40d61)
#define P_EMMC_A_GPING_097                         (volatile uint32_t *)((0x40d61  << 2) + 0xffd00000)
#define   EMMC_A_GPING_098                         (0x40d62)
#define P_EMMC_A_GPING_098                         (volatile uint32_t *)((0x40d62  << 2) + 0xffd00000)
#define   EMMC_A_GPING_099                         (0x40d63)
#define P_EMMC_A_GPING_099                         (volatile uint32_t *)((0x40d63  << 2) + 0xffd00000)
#define   EMMC_A_GPING_100                         (0x40d64)
#define P_EMMC_A_GPING_100                         (volatile uint32_t *)((0x40d64  << 2) + 0xffd00000)
#define   EMMC_A_GPING_101                         (0x40d65)
#define P_EMMC_A_GPING_101                         (volatile uint32_t *)((0x40d65  << 2) + 0xffd00000)
#define   EMMC_A_GPING_102                         (0x40d66)
#define P_EMMC_A_GPING_102                         (volatile uint32_t *)((0x40d66  << 2) + 0xffd00000)
#define   EMMC_A_GPING_103                         (0x40d67)
#define P_EMMC_A_GPING_103                         (volatile uint32_t *)((0x40d67  << 2) + 0xffd00000)
#define   EMMC_A_GPING_104                         (0x40d68)
#define P_EMMC_A_GPING_104                         (volatile uint32_t *)((0x40d68  << 2) + 0xffd00000)
#define   EMMC_A_GPING_105                         (0x40d69)
#define P_EMMC_A_GPING_105                         (volatile uint32_t *)((0x40d69  << 2) + 0xffd00000)
#define   EMMC_A_GPING_106                         (0x40d6a)
#define P_EMMC_A_GPING_106                         (volatile uint32_t *)((0x40d6a  << 2) + 0xffd00000)
#define   EMMC_A_GPING_107                         (0x40d6b)
#define P_EMMC_A_GPING_107                         (volatile uint32_t *)((0x40d6b  << 2) + 0xffd00000)
#define   EMMC_A_GPING_108                         (0x40d6c)
#define P_EMMC_A_GPING_108                         (volatile uint32_t *)((0x40d6c  << 2) + 0xffd00000)
#define   EMMC_A_GPING_109                         (0x40d6d)
#define P_EMMC_A_GPING_109                         (volatile uint32_t *)((0x40d6d  << 2) + 0xffd00000)
#define   EMMC_A_GPING_110                         (0x40d6e)
#define P_EMMC_A_GPING_110                         (volatile uint32_t *)((0x40d6e  << 2) + 0xffd00000)
#define   EMMC_A_GPING_111                         (0x40d6f)
#define P_EMMC_A_GPING_111                         (volatile uint32_t *)((0x40d6f  << 2) + 0xffd00000)
#define   EMMC_A_GPING_112                         (0x40d70)
#define P_EMMC_A_GPING_112                         (volatile uint32_t *)((0x40d70  << 2) + 0xffd00000)
#define   EMMC_A_GPING_113                         (0x40d71)
#define P_EMMC_A_GPING_113                         (volatile uint32_t *)((0x40d71  << 2) + 0xffd00000)
#define   EMMC_A_GPING_114                         (0x40d72)
#define P_EMMC_A_GPING_114                         (volatile uint32_t *)((0x40d72  << 2) + 0xffd00000)
#define   EMMC_A_GPING_115                         (0x40d73)
#define P_EMMC_A_GPING_115                         (volatile uint32_t *)((0x40d73  << 2) + 0xffd00000)
#define   EMMC_A_GPING_116                         (0x40d74)
#define P_EMMC_A_GPING_116                         (volatile uint32_t *)((0x40d74  << 2) + 0xffd00000)
#define   EMMC_A_GPING_117                         (0x40d75)
#define P_EMMC_A_GPING_117                         (volatile uint32_t *)((0x40d75  << 2) + 0xffd00000)
#define   EMMC_A_GPING_118                         (0x40d76)
#define P_EMMC_A_GPING_118                         (volatile uint32_t *)((0x40d76  << 2) + 0xffd00000)
#define   EMMC_A_GPING_119                         (0x40d77)
#define P_EMMC_A_GPING_119                         (volatile uint32_t *)((0x40d77  << 2) + 0xffd00000)
#define   EMMC_A_GPING_120                         (0x40d78)
#define P_EMMC_A_GPING_120                         (volatile uint32_t *)((0x40d78  << 2) + 0xffd00000)
#define   EMMC_A_GPING_121                         (0x40d79)
#define P_EMMC_A_GPING_121                         (volatile uint32_t *)((0x40d79  << 2) + 0xffd00000)
#define   EMMC_A_GPING_122                         (0x40d7a)
#define P_EMMC_A_GPING_122                         (volatile uint32_t *)((0x40d7a  << 2) + 0xffd00000)
#define   EMMC_A_GPING_123                         (0x40d7b)
#define P_EMMC_A_GPING_123                         (volatile uint32_t *)((0x40d7b  << 2) + 0xffd00000)
#define   EMMC_A_GPING_124                         (0x40d7c)
#define P_EMMC_A_GPING_124                         (volatile uint32_t *)((0x40d7c  << 2) + 0xffd00000)
#define   EMMC_A_GPING_125                         (0x40d7d)
#define P_EMMC_A_GPING_125                         (volatile uint32_t *)((0x40d7d  << 2) + 0xffd00000)
#define   EMMC_A_GPING_126                         (0x40d7e)
#define P_EMMC_A_GPING_126                         (volatile uint32_t *)((0x40d7e  << 2) + 0xffd00000)
#define   EMMC_A_GPING_127                         (0x40d7f)
#define P_EMMC_A_GPING_127                         (volatile uint32_t *)((0x40d7f  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_000                         (0x40d80)
#define P_EMMC_A_GPONG_000                         (volatile uint32_t *)((0x40d80  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_001                         (0x40d81)
#define P_EMMC_A_GPONG_001                         (volatile uint32_t *)((0x40d81  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_002                         (0x40d82)
#define P_EMMC_A_GPONG_002                         (volatile uint32_t *)((0x40d82  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_003                         (0x40d83)
#define P_EMMC_A_GPONG_003                         (volatile uint32_t *)((0x40d83  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_004                         (0x40d84)
#define P_EMMC_A_GPONG_004                         (volatile uint32_t *)((0x40d84  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_005                         (0x40d85)
#define P_EMMC_A_GPONG_005                         (volatile uint32_t *)((0x40d85  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_006                         (0x40d86)
#define P_EMMC_A_GPONG_006                         (volatile uint32_t *)((0x40d86  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_007                         (0x40d87)
#define P_EMMC_A_GPONG_007                         (volatile uint32_t *)((0x40d87  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_008                         (0x40d88)
#define P_EMMC_A_GPONG_008                         (volatile uint32_t *)((0x40d88  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_009                         (0x40d89)
#define P_EMMC_A_GPONG_009                         (volatile uint32_t *)((0x40d89  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_010                         (0x40d8a)
#define P_EMMC_A_GPONG_010                         (volatile uint32_t *)((0x40d8a  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_011                         (0x40d8b)
#define P_EMMC_A_GPONG_011                         (volatile uint32_t *)((0x40d8b  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_012                         (0x40d8c)
#define P_EMMC_A_GPONG_012                         (volatile uint32_t *)((0x40d8c  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_013                         (0x40d8d)
#define P_EMMC_A_GPONG_013                         (volatile uint32_t *)((0x40d8d  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_014                         (0x40d8e)
#define P_EMMC_A_GPONG_014                         (volatile uint32_t *)((0x40d8e  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_015                         (0x40d8f)
#define P_EMMC_A_GPONG_015                         (volatile uint32_t *)((0x40d8f  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_016                         (0x40d90)
#define P_EMMC_A_GPONG_016                         (volatile uint32_t *)((0x40d90  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_017                         (0x40d91)
#define P_EMMC_A_GPONG_017                         (volatile uint32_t *)((0x40d91  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_018                         (0x40d92)
#define P_EMMC_A_GPONG_018                         (volatile uint32_t *)((0x40d92  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_019                         (0x40d93)
#define P_EMMC_A_GPONG_019                         (volatile uint32_t *)((0x40d93  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_020                         (0x40d94)
#define P_EMMC_A_GPONG_020                         (volatile uint32_t *)((0x40d94  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_021                         (0x40d95)
#define P_EMMC_A_GPONG_021                         (volatile uint32_t *)((0x40d95  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_022                         (0x40d96)
#define P_EMMC_A_GPONG_022                         (volatile uint32_t *)((0x40d96  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_023                         (0x40d97)
#define P_EMMC_A_GPONG_023                         (volatile uint32_t *)((0x40d97  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_024                         (0x40d98)
#define P_EMMC_A_GPONG_024                         (volatile uint32_t *)((0x40d98  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_025                         (0x40d99)
#define P_EMMC_A_GPONG_025                         (volatile uint32_t *)((0x40d99  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_026                         (0x40d9a)
#define P_EMMC_A_GPONG_026                         (volatile uint32_t *)((0x40d9a  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_027                         (0x40d9b)
#define P_EMMC_A_GPONG_027                         (volatile uint32_t *)((0x40d9b  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_028                         (0x40d9c)
#define P_EMMC_A_GPONG_028                         (volatile uint32_t *)((0x40d9c  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_029                         (0x40d9d)
#define P_EMMC_A_GPONG_029                         (volatile uint32_t *)((0x40d9d  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_030                         (0x40d9e)
#define P_EMMC_A_GPONG_030                         (volatile uint32_t *)((0x40d9e  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_031                         (0x40d9f)
#define P_EMMC_A_GPONG_031                         (volatile uint32_t *)((0x40d9f  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_032                         (0x40da0)
#define P_EMMC_A_GPONG_032                         (volatile uint32_t *)((0x40da0  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_033                         (0x40da1)
#define P_EMMC_A_GPONG_033                         (volatile uint32_t *)((0x40da1  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_034                         (0x40da2)
#define P_EMMC_A_GPONG_034                         (volatile uint32_t *)((0x40da2  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_035                         (0x40da3)
#define P_EMMC_A_GPONG_035                         (volatile uint32_t *)((0x40da3  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_036                         (0x40da4)
#define P_EMMC_A_GPONG_036                         (volatile uint32_t *)((0x40da4  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_037                         (0x40da5)
#define P_EMMC_A_GPONG_037                         (volatile uint32_t *)((0x40da5  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_038                         (0x40da6)
#define P_EMMC_A_GPONG_038                         (volatile uint32_t *)((0x40da6  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_039                         (0x40da7)
#define P_EMMC_A_GPONG_039                         (volatile uint32_t *)((0x40da7  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_040                         (0x40da8)
#define P_EMMC_A_GPONG_040                         (volatile uint32_t *)((0x40da8  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_041                         (0x40da9)
#define P_EMMC_A_GPONG_041                         (volatile uint32_t *)((0x40da9  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_042                         (0x40daa)
#define P_EMMC_A_GPONG_042                         (volatile uint32_t *)((0x40daa  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_043                         (0x40dab)
#define P_EMMC_A_GPONG_043                         (volatile uint32_t *)((0x40dab  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_044                         (0x40dac)
#define P_EMMC_A_GPONG_044                         (volatile uint32_t *)((0x40dac  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_045                         (0x40dad)
#define P_EMMC_A_GPONG_045                         (volatile uint32_t *)((0x40dad  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_046                         (0x40dae)
#define P_EMMC_A_GPONG_046                         (volatile uint32_t *)((0x40dae  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_047                         (0x40daf)
#define P_EMMC_A_GPONG_047                         (volatile uint32_t *)((0x40daf  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_048                         (0x40db0)
#define P_EMMC_A_GPONG_048                         (volatile uint32_t *)((0x40db0  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_049                         (0x40db1)
#define P_EMMC_A_GPONG_049                         (volatile uint32_t *)((0x40db1  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_050                         (0x40db2)
#define P_EMMC_A_GPONG_050                         (volatile uint32_t *)((0x40db2  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_051                         (0x40db3)
#define P_EMMC_A_GPONG_051                         (volatile uint32_t *)((0x40db3  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_052                         (0x40db4)
#define P_EMMC_A_GPONG_052                         (volatile uint32_t *)((0x40db4  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_053                         (0x40db5)
#define P_EMMC_A_GPONG_053                         (volatile uint32_t *)((0x40db5  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_054                         (0x40db6)
#define P_EMMC_A_GPONG_054                         (volatile uint32_t *)((0x40db6  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_055                         (0x40db7)
#define P_EMMC_A_GPONG_055                         (volatile uint32_t *)((0x40db7  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_056                         (0x40db8)
#define P_EMMC_A_GPONG_056                         (volatile uint32_t *)((0x40db8  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_057                         (0x40db9)
#define P_EMMC_A_GPONG_057                         (volatile uint32_t *)((0x40db9  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_058                         (0x40dba)
#define P_EMMC_A_GPONG_058                         (volatile uint32_t *)((0x40dba  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_059                         (0x40dbb)
#define P_EMMC_A_GPONG_059                         (volatile uint32_t *)((0x40dbb  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_060                         (0x40dbc)
#define P_EMMC_A_GPONG_060                         (volatile uint32_t *)((0x40dbc  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_061                         (0x40dbd)
#define P_EMMC_A_GPONG_061                         (volatile uint32_t *)((0x40dbd  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_062                         (0x40dbe)
#define P_EMMC_A_GPONG_062                         (volatile uint32_t *)((0x40dbe  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_063                         (0x40dbf)
#define P_EMMC_A_GPONG_063                         (volatile uint32_t *)((0x40dbf  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_064                         (0x40dc0)
#define P_EMMC_A_GPONG_064                         (volatile uint32_t *)((0x40dc0  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_065                         (0x40dc1)
#define P_EMMC_A_GPONG_065                         (volatile uint32_t *)((0x40dc1  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_066                         (0x40dc2)
#define P_EMMC_A_GPONG_066                         (volatile uint32_t *)((0x40dc2  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_067                         (0x40dc3)
#define P_EMMC_A_GPONG_067                         (volatile uint32_t *)((0x40dc3  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_068                         (0x40dc4)
#define P_EMMC_A_GPONG_068                         (volatile uint32_t *)((0x40dc4  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_069                         (0x40dc5)
#define P_EMMC_A_GPONG_069                         (volatile uint32_t *)((0x40dc5  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_070                         (0x40dc6)
#define P_EMMC_A_GPONG_070                         (volatile uint32_t *)((0x40dc6  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_071                         (0x40dc7)
#define P_EMMC_A_GPONG_071                         (volatile uint32_t *)((0x40dc7  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_072                         (0x40dc8)
#define P_EMMC_A_GPONG_072                         (volatile uint32_t *)((0x40dc8  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_073                         (0x40dc9)
#define P_EMMC_A_GPONG_073                         (volatile uint32_t *)((0x40dc9  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_074                         (0x40dca)
#define P_EMMC_A_GPONG_074                         (volatile uint32_t *)((0x40dca  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_075                         (0x40dcb)
#define P_EMMC_A_GPONG_075                         (volatile uint32_t *)((0x40dcb  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_076                         (0x40dcc)
#define P_EMMC_A_GPONG_076                         (volatile uint32_t *)((0x40dcc  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_077                         (0x40dcd)
#define P_EMMC_A_GPONG_077                         (volatile uint32_t *)((0x40dcd  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_078                         (0x40dce)
#define P_EMMC_A_GPONG_078                         (volatile uint32_t *)((0x40dce  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_079                         (0x40dcf)
#define P_EMMC_A_GPONG_079                         (volatile uint32_t *)((0x40dcf  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_080                         (0x40dd0)
#define P_EMMC_A_GPONG_080                         (volatile uint32_t *)((0x40dd0  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_081                         (0x40dd1)
#define P_EMMC_A_GPONG_081                         (volatile uint32_t *)((0x40dd1  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_082                         (0x40dd2)
#define P_EMMC_A_GPONG_082                         (volatile uint32_t *)((0x40dd2  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_083                         (0x40dd3)
#define P_EMMC_A_GPONG_083                         (volatile uint32_t *)((0x40dd3  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_084                         (0x40dd4)
#define P_EMMC_A_GPONG_084                         (volatile uint32_t *)((0x40dd4  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_085                         (0x40dd5)
#define P_EMMC_A_GPONG_085                         (volatile uint32_t *)((0x40dd5  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_086                         (0x40dd6)
#define P_EMMC_A_GPONG_086                         (volatile uint32_t *)((0x40dd6  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_087                         (0x40dd7)
#define P_EMMC_A_GPONG_087                         (volatile uint32_t *)((0x40dd7  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_088                         (0x40dd8)
#define P_EMMC_A_GPONG_088                         (volatile uint32_t *)((0x40dd8  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_089                         (0x40dd9)
#define P_EMMC_A_GPONG_089                         (volatile uint32_t *)((0x40dd9  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_090                         (0x40dda)
#define P_EMMC_A_GPONG_090                         (volatile uint32_t *)((0x40dda  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_091                         (0x40ddb)
#define P_EMMC_A_GPONG_091                         (volatile uint32_t *)((0x40ddb  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_092                         (0x40ddc)
#define P_EMMC_A_GPONG_092                         (volatile uint32_t *)((0x40ddc  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_093                         (0x40ddd)
#define P_EMMC_A_GPONG_093                         (volatile uint32_t *)((0x40ddd  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_094                         (0x40dde)
#define P_EMMC_A_GPONG_094                         (volatile uint32_t *)((0x40dde  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_095                         (0x40ddf)
#define P_EMMC_A_GPONG_095                         (volatile uint32_t *)((0x40ddf  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_096                         (0x40de0)
#define P_EMMC_A_GPONG_096                         (volatile uint32_t *)((0x40de0  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_097                         (0x40de1)
#define P_EMMC_A_GPONG_097                         (volatile uint32_t *)((0x40de1  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_098                         (0x40de2)
#define P_EMMC_A_GPONG_098                         (volatile uint32_t *)((0x40de2  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_099                         (0x40de3)
#define P_EMMC_A_GPONG_099                         (volatile uint32_t *)((0x40de3  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_100                         (0x40de4)
#define P_EMMC_A_GPONG_100                         (volatile uint32_t *)((0x40de4  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_101                         (0x40de5)
#define P_EMMC_A_GPONG_101                         (volatile uint32_t *)((0x40de5  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_102                         (0x40de6)
#define P_EMMC_A_GPONG_102                         (volatile uint32_t *)((0x40de6  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_103                         (0x40de7)
#define P_EMMC_A_GPONG_103                         (volatile uint32_t *)((0x40de7  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_104                         (0x40de8)
#define P_EMMC_A_GPONG_104                         (volatile uint32_t *)((0x40de8  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_105                         (0x40de9)
#define P_EMMC_A_GPONG_105                         (volatile uint32_t *)((0x40de9  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_106                         (0x40dea)
#define P_EMMC_A_GPONG_106                         (volatile uint32_t *)((0x40dea  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_107                         (0x40deb)
#define P_EMMC_A_GPONG_107                         (volatile uint32_t *)((0x40deb  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_108                         (0x40dec)
#define P_EMMC_A_GPONG_108                         (volatile uint32_t *)((0x40dec  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_109                         (0x40ded)
#define P_EMMC_A_GPONG_109                         (volatile uint32_t *)((0x40ded  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_110                         (0x40dee)
#define P_EMMC_A_GPONG_110                         (volatile uint32_t *)((0x40dee  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_111                         (0x40def)
#define P_EMMC_A_GPONG_111                         (volatile uint32_t *)((0x40def  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_112                         (0x40df0)
#define P_EMMC_A_GPONG_112                         (volatile uint32_t *)((0x40df0  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_113                         (0x40df1)
#define P_EMMC_A_GPONG_113                         (volatile uint32_t *)((0x40df1  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_114                         (0x40df2)
#define P_EMMC_A_GPONG_114                         (volatile uint32_t *)((0x40df2  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_115                         (0x40df3)
#define P_EMMC_A_GPONG_115                         (volatile uint32_t *)((0x40df3  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_116                         (0x40df4)
#define P_EMMC_A_GPONG_116                         (volatile uint32_t *)((0x40df4  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_117                         (0x40df5)
#define P_EMMC_A_GPONG_117                         (volatile uint32_t *)((0x40df5  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_118                         (0x40df6)
#define P_EMMC_A_GPONG_118                         (volatile uint32_t *)((0x40df6  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_119                         (0x40df7)
#define P_EMMC_A_GPONG_119                         (volatile uint32_t *)((0x40df7  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_120                         (0x40df8)
#define P_EMMC_A_GPONG_120                         (volatile uint32_t *)((0x40df8  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_121                         (0x40df9)
#define P_EMMC_A_GPONG_121                         (volatile uint32_t *)((0x40df9  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_122                         (0x40dfa)
#define P_EMMC_A_GPONG_122                         (volatile uint32_t *)((0x40dfa  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_123                         (0x40dfb)
#define P_EMMC_A_GPONG_123                         (volatile uint32_t *)((0x40dfb  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_124                         (0x40dfc)
#define P_EMMC_A_GPONG_124                         (volatile uint32_t *)((0x40dfc  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_125                         (0x40dfd)
#define P_EMMC_A_GPONG_125                         (volatile uint32_t *)((0x40dfd  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_126                         (0x40dfe)
#define P_EMMC_A_GPONG_126                         (volatile uint32_t *)((0x40dfe  << 2) + 0xffd00000)
#define   EMMC_A_GPONG_127                         (0x40dff)
#define P_EMMC_A_GPONG_127                         (volatile uint32_t *)((0x40dff  << 2) + 0xffd00000)
// -----------------------------------------------
// CBUS_BASE:  EMMCB_CBUS_BASE = 0x414
// -----------------------------------------------
#define   EMMC_B_GCLOCK                            (0x41400)
#define P_EMMC_B_GCLOCK                            (volatile uint32_t *)((0x41400  << 2) + 0xffd00000)
#define   EMMC_B_GDELAY0                           (0x41401)
#define P_EMMC_B_GDELAY0                           (volatile uint32_t *)((0x41401  << 2) + 0xffd00000)
#define   EMMC_B_GDELAY1                           (0x41402)
#define P_EMMC_B_GDELAY1                           (volatile uint32_t *)((0x41402  << 2) + 0xffd00000)
#define   EMMC_B_GADJUST                           (0x41403)
#define P_EMMC_B_GADJUST                           (volatile uint32_t *)((0x41403  << 2) + 0xffd00000)
#define   EMMC_B_GCALOUT0                          (0x41404)
#define P_EMMC_B_GCALOUT0                          (volatile uint32_t *)((0x41404  << 2) + 0xffd00000)
#define   EMMC_B_GCALOUT1                          (0x41405)
#define P_EMMC_B_GCALOUT1                          (volatile uint32_t *)((0x41405  << 2) + 0xffd00000)
#define   EMMC_B_GCALOUT2                          (0x41406)
#define P_EMMC_B_GCALOUT2                          (volatile uint32_t *)((0x41406  << 2) + 0xffd00000)
#define   EMMC_B_GCALOUT3                          (0x41407)
#define P_EMMC_B_GCALOUT3                          (volatile uint32_t *)((0x41407  << 2) + 0xffd00000)
#define   EMMC_B_GADJ_LOG                          (0x41408)
#define P_EMMC_B_GADJ_LOG                          (volatile uint32_t *)((0x41408  << 2) + 0xffd00000)
#define   EMMC_B_GCLKTEST_LOG                      (0x41409)
#define P_EMMC_B_GCLKTEST_LOG                      (volatile uint32_t *)((0x41409  << 2) + 0xffd00000)
#define   EMMC_B_GCLKTEST_OUT                      (0x4140a)
#define P_EMMC_B_GCLKTEST_OUT                      (volatile uint32_t *)((0x4140a  << 2) + 0xffd00000)
#define   EMMC_B_GEYETEST_LOG                      (0x4140b)
#define P_EMMC_B_GEYETEST_LOG                      (volatile uint32_t *)((0x4140b  << 2) + 0xffd00000)
#define   EMMC_B_GEYETEST_OUT0                     (0x4140c)
#define P_EMMC_B_GEYETEST_OUT0                     (volatile uint32_t *)((0x4140c  << 2) + 0xffd00000)
#define   EMMC_B_GEYETEST_OUT1                     (0x4140d)
#define P_EMMC_B_GEYETEST_OUT1                     (volatile uint32_t *)((0x4140d  << 2) + 0xffd00000)
#define   EMMC_B_GINTF3                            (0x4140e)
#define P_EMMC_B_GINTF3                            (volatile uint32_t *)((0x4140e  << 2) + 0xffd00000)
#define   EMMC_B_GRESERVE                          (0x4140f)
#define P_EMMC_B_GRESERVE                          (volatile uint32_t *)((0x4140f  << 2) + 0xffd00000)
#define   EMMC_B_GSTART                            (0x41410)
#define P_EMMC_B_GSTART                            (volatile uint32_t *)((0x41410  << 2) + 0xffd00000)
#define   EMMC_B_GCFG                              (0x41411)
#define P_EMMC_B_GCFG                              (volatile uint32_t *)((0x41411  << 2) + 0xffd00000)
#define   EMMC_B_GSTATUS                           (0x41412)
#define P_EMMC_B_GSTATUS                           (volatile uint32_t *)((0x41412  << 2) + 0xffd00000)
#define   EMMC_B_GIRQ_EN                           (0x41413)
#define P_EMMC_B_GIRQ_EN                           (volatile uint32_t *)((0x41413  << 2) + 0xffd00000)
#define   EMMC_B_GCMD_CFG                          (0x41414)
#define P_EMMC_B_GCMD_CFG                          (volatile uint32_t *)((0x41414  << 2) + 0xffd00000)
#define   EMMC_B_GCMD_ARG                          (0x41415)
#define P_EMMC_B_GCMD_ARG                          (volatile uint32_t *)((0x41415  << 2) + 0xffd00000)
#define   EMMC_B_GCMD_DAT                          (0x41416)
#define P_EMMC_B_GCMD_DAT                          (volatile uint32_t *)((0x41416  << 2) + 0xffd00000)
#define   EMMC_B_GCMD_RSP                          (0x41417)
#define P_EMMC_B_GCMD_RSP                          (volatile uint32_t *)((0x41417  << 2) + 0xffd00000)
#define   EMMC_B_GCMD_RSP1                         (0x41418)
#define P_EMMC_B_GCMD_RSP1                         (volatile uint32_t *)((0x41418  << 2) + 0xffd00000)
#define   EMMC_B_GCMD_RSP2                         (0x41419)
#define P_EMMC_B_GCMD_RSP2                         (volatile uint32_t *)((0x41419  << 2) + 0xffd00000)
#define   EMMC_B_GCMD_RSP3                         (0x4141a)
#define P_EMMC_B_GCMD_RSP3                         (volatile uint32_t *)((0x4141a  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_6C                       (0x4141b)
#define P_EMMC_B_RESERVED_6C                       (volatile uint32_t *)((0x4141b  << 2) + 0xffd00000)
#define   EMMC_B_GCURR_CFG                         (0x4141c)
#define P_EMMC_B_GCURR_CFG                         (volatile uint32_t *)((0x4141c  << 2) + 0xffd00000)
#define   EMMC_B_GCURR_ARG                         (0x4141d)
#define P_EMMC_B_GCURR_ARG                         (volatile uint32_t *)((0x4141d  << 2) + 0xffd00000)
#define   EMMC_B_GCURR_DAT                         (0x4141e)
#define P_EMMC_B_GCURR_DAT                         (volatile uint32_t *)((0x4141e  << 2) + 0xffd00000)
#define   EMMC_B_GCURR_RSP                         (0x4141f)
#define P_EMMC_B_GCURR_RSP                         (volatile uint32_t *)((0x4141f  << 2) + 0xffd00000)
#define   EMMC_B_GNEXT_CFG                         (0x41420)
#define P_EMMC_B_GNEXT_CFG                         (volatile uint32_t *)((0x41420  << 2) + 0xffd00000)
#define   EMMC_B_GNEXT_ARG                         (0x41421)
#define P_EMMC_B_GNEXT_ARG                         (volatile uint32_t *)((0x41421  << 2) + 0xffd00000)
#define   EMMC_B_GNEXT_DAT                         (0x41422)
#define P_EMMC_B_GNEXT_DAT                         (volatile uint32_t *)((0x41422  << 2) + 0xffd00000)
#define   EMMC_B_GNEXT_RSP                         (0x41423)
#define P_EMMC_B_GNEXT_RSP                         (volatile uint32_t *)((0x41423  << 2) + 0xffd00000)
#define   EMMC_B_GRXD                              (0x41424)
#define P_EMMC_B_GRXD                              (volatile uint32_t *)((0x41424  << 2) + 0xffd00000)
#define   EMMC_B_GTXD                              (0x41425)
#define P_EMMC_B_GTXD                              (volatile uint32_t *)((0x41425  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_00                    (0x41426)
#define P_EMMC_B_RESERVED_98_00                    (volatile uint32_t *)((0x41426  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_01                    (0x41427)
#define P_EMMC_B_RESERVED_98_01                    (volatile uint32_t *)((0x41427  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_02                    (0x41428)
#define P_EMMC_B_RESERVED_98_02                    (volatile uint32_t *)((0x41428  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_03                    (0x41429)
#define P_EMMC_B_RESERVED_98_03                    (volatile uint32_t *)((0x41429  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_04                    (0x4142a)
#define P_EMMC_B_RESERVED_98_04                    (volatile uint32_t *)((0x4142a  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_05                    (0x4142b)
#define P_EMMC_B_RESERVED_98_05                    (volatile uint32_t *)((0x4142b  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_06                    (0x4142c)
#define P_EMMC_B_RESERVED_98_06                    (volatile uint32_t *)((0x4142c  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_07                    (0x4142d)
#define P_EMMC_B_RESERVED_98_07                    (volatile uint32_t *)((0x4142d  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_08                    (0x4142e)
#define P_EMMC_B_RESERVED_98_08                    (volatile uint32_t *)((0x4142e  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_09                    (0x4142f)
#define P_EMMC_B_RESERVED_98_09                    (volatile uint32_t *)((0x4142f  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_10                    (0x41430)
#define P_EMMC_B_RESERVED_98_10                    (volatile uint32_t *)((0x41430  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_11                    (0x41431)
#define P_EMMC_B_RESERVED_98_11                    (volatile uint32_t *)((0x41431  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_12                    (0x41432)
#define P_EMMC_B_RESERVED_98_12                    (volatile uint32_t *)((0x41432  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_13                    (0x41433)
#define P_EMMC_B_RESERVED_98_13                    (volatile uint32_t *)((0x41433  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_14                    (0x41434)
#define P_EMMC_B_RESERVED_98_14                    (volatile uint32_t *)((0x41434  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_15                    (0x41435)
#define P_EMMC_B_RESERVED_98_15                    (volatile uint32_t *)((0x41435  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_16                    (0x41436)
#define P_EMMC_B_RESERVED_98_16                    (volatile uint32_t *)((0x41436  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_17                    (0x41437)
#define P_EMMC_B_RESERVED_98_17                    (volatile uint32_t *)((0x41437  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_18                    (0x41438)
#define P_EMMC_B_RESERVED_98_18                    (volatile uint32_t *)((0x41438  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_19                    (0x41439)
#define P_EMMC_B_RESERVED_98_19                    (volatile uint32_t *)((0x41439  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_20                    (0x4143a)
#define P_EMMC_B_RESERVED_98_20                    (volatile uint32_t *)((0x4143a  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_21                    (0x4143b)
#define P_EMMC_B_RESERVED_98_21                    (volatile uint32_t *)((0x4143b  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_22                    (0x4143c)
#define P_EMMC_B_RESERVED_98_22                    (volatile uint32_t *)((0x4143c  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_23                    (0x4143d)
#define P_EMMC_B_RESERVED_98_23                    (volatile uint32_t *)((0x4143d  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_24                    (0x4143e)
#define P_EMMC_B_RESERVED_98_24                    (volatile uint32_t *)((0x4143e  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_25                    (0x4143f)
#define P_EMMC_B_RESERVED_98_25                    (volatile uint32_t *)((0x4143f  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_26                    (0x41440)
#define P_EMMC_B_RESERVED_98_26                    (volatile uint32_t *)((0x41440  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_27                    (0x41441)
#define P_EMMC_B_RESERVED_98_27                    (volatile uint32_t *)((0x41441  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_28                    (0x41442)
#define P_EMMC_B_RESERVED_98_28                    (volatile uint32_t *)((0x41442  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_29                    (0x41443)
#define P_EMMC_B_RESERVED_98_29                    (volatile uint32_t *)((0x41443  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_30                    (0x41444)
#define P_EMMC_B_RESERVED_98_30                    (volatile uint32_t *)((0x41444  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_31                    (0x41445)
#define P_EMMC_B_RESERVED_98_31                    (volatile uint32_t *)((0x41445  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_32                    (0x41446)
#define P_EMMC_B_RESERVED_98_32                    (volatile uint32_t *)((0x41446  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_33                    (0x41447)
#define P_EMMC_B_RESERVED_98_33                    (volatile uint32_t *)((0x41447  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_34                    (0x41448)
#define P_EMMC_B_RESERVED_98_34                    (volatile uint32_t *)((0x41448  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_35                    (0x41449)
#define P_EMMC_B_RESERVED_98_35                    (volatile uint32_t *)((0x41449  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_36                    (0x4144a)
#define P_EMMC_B_RESERVED_98_36                    (volatile uint32_t *)((0x4144a  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_37                    (0x4144b)
#define P_EMMC_B_RESERVED_98_37                    (volatile uint32_t *)((0x4144b  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_38                    (0x4144c)
#define P_EMMC_B_RESERVED_98_38                    (volatile uint32_t *)((0x4144c  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_39                    (0x4144d)
#define P_EMMC_B_RESERVED_98_39                    (volatile uint32_t *)((0x4144d  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_40                    (0x4144e)
#define P_EMMC_B_RESERVED_98_40                    (volatile uint32_t *)((0x4144e  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_41                    (0x4144f)
#define P_EMMC_B_RESERVED_98_41                    (volatile uint32_t *)((0x4144f  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_42                    (0x41450)
#define P_EMMC_B_RESERVED_98_42                    (volatile uint32_t *)((0x41450  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_43                    (0x41451)
#define P_EMMC_B_RESERVED_98_43                    (volatile uint32_t *)((0x41451  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_44                    (0x41452)
#define P_EMMC_B_RESERVED_98_44                    (volatile uint32_t *)((0x41452  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_45                    (0x41453)
#define P_EMMC_B_RESERVED_98_45                    (volatile uint32_t *)((0x41453  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_46                    (0x41454)
#define P_EMMC_B_RESERVED_98_46                    (volatile uint32_t *)((0x41454  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_47                    (0x41455)
#define P_EMMC_B_RESERVED_98_47                    (volatile uint32_t *)((0x41455  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_48                    (0x41456)
#define P_EMMC_B_RESERVED_98_48                    (volatile uint32_t *)((0x41456  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_49                    (0x41457)
#define P_EMMC_B_RESERVED_98_49                    (volatile uint32_t *)((0x41457  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_50                    (0x41458)
#define P_EMMC_B_RESERVED_98_50                    (volatile uint32_t *)((0x41458  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_51                    (0x41459)
#define P_EMMC_B_RESERVED_98_51                    (volatile uint32_t *)((0x41459  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_52                    (0x4145a)
#define P_EMMC_B_RESERVED_98_52                    (volatile uint32_t *)((0x4145a  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_53                    (0x4145b)
#define P_EMMC_B_RESERVED_98_53                    (volatile uint32_t *)((0x4145b  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_54                    (0x4145c)
#define P_EMMC_B_RESERVED_98_54                    (volatile uint32_t *)((0x4145c  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_55                    (0x4145d)
#define P_EMMC_B_RESERVED_98_55                    (volatile uint32_t *)((0x4145d  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_56                    (0x4145e)
#define P_EMMC_B_RESERVED_98_56                    (volatile uint32_t *)((0x4145e  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_57                    (0x4145f)
#define P_EMMC_B_RESERVED_98_57                    (volatile uint32_t *)((0x4145f  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_58                    (0x41460)
#define P_EMMC_B_RESERVED_98_58                    (volatile uint32_t *)((0x41460  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_59                    (0x41461)
#define P_EMMC_B_RESERVED_98_59                    (volatile uint32_t *)((0x41461  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_60                    (0x41462)
#define P_EMMC_B_RESERVED_98_60                    (volatile uint32_t *)((0x41462  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_61                    (0x41463)
#define P_EMMC_B_RESERVED_98_61                    (volatile uint32_t *)((0x41463  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_62                    (0x41464)
#define P_EMMC_B_RESERVED_98_62                    (volatile uint32_t *)((0x41464  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_63                    (0x41465)
#define P_EMMC_B_RESERVED_98_63                    (volatile uint32_t *)((0x41465  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_64                    (0x41466)
#define P_EMMC_B_RESERVED_98_64                    (volatile uint32_t *)((0x41466  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_65                    (0x41467)
#define P_EMMC_B_RESERVED_98_65                    (volatile uint32_t *)((0x41467  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_66                    (0x41468)
#define P_EMMC_B_RESERVED_98_66                    (volatile uint32_t *)((0x41468  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_67                    (0x41469)
#define P_EMMC_B_RESERVED_98_67                    (volatile uint32_t *)((0x41469  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_68                    (0x4146a)
#define P_EMMC_B_RESERVED_98_68                    (volatile uint32_t *)((0x4146a  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_69                    (0x4146b)
#define P_EMMC_B_RESERVED_98_69                    (volatile uint32_t *)((0x4146b  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_70                    (0x4146c)
#define P_EMMC_B_RESERVED_98_70                    (volatile uint32_t *)((0x4146c  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_71                    (0x4146d)
#define P_EMMC_B_RESERVED_98_71                    (volatile uint32_t *)((0x4146d  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_72                    (0x4146e)
#define P_EMMC_B_RESERVED_98_72                    (volatile uint32_t *)((0x4146e  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_73                    (0x4146f)
#define P_EMMC_B_RESERVED_98_73                    (volatile uint32_t *)((0x4146f  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_74                    (0x41470)
#define P_EMMC_B_RESERVED_98_74                    (volatile uint32_t *)((0x41470  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_75                    (0x41471)
#define P_EMMC_B_RESERVED_98_75                    (volatile uint32_t *)((0x41471  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_76                    (0x41472)
#define P_EMMC_B_RESERVED_98_76                    (volatile uint32_t *)((0x41472  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_77                    (0x41473)
#define P_EMMC_B_RESERVED_98_77                    (volatile uint32_t *)((0x41473  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_78                    (0x41474)
#define P_EMMC_B_RESERVED_98_78                    (volatile uint32_t *)((0x41474  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_79                    (0x41475)
#define P_EMMC_B_RESERVED_98_79                    (volatile uint32_t *)((0x41475  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_80                    (0x41476)
#define P_EMMC_B_RESERVED_98_80                    (volatile uint32_t *)((0x41476  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_81                    (0x41477)
#define P_EMMC_B_RESERVED_98_81                    (volatile uint32_t *)((0x41477  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_82                    (0x41478)
#define P_EMMC_B_RESERVED_98_82                    (volatile uint32_t *)((0x41478  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_83                    (0x41479)
#define P_EMMC_B_RESERVED_98_83                    (volatile uint32_t *)((0x41479  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_84                    (0x4147a)
#define P_EMMC_B_RESERVED_98_84                    (volatile uint32_t *)((0x4147a  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_85                    (0x4147b)
#define P_EMMC_B_RESERVED_98_85                    (volatile uint32_t *)((0x4147b  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_86                    (0x4147c)
#define P_EMMC_B_RESERVED_98_86                    (volatile uint32_t *)((0x4147c  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_87                    (0x4147d)
#define P_EMMC_B_RESERVED_98_87                    (volatile uint32_t *)((0x4147d  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_88                    (0x4147e)
#define P_EMMC_B_RESERVED_98_88                    (volatile uint32_t *)((0x4147e  << 2) + 0xffd00000)
#define   EMMC_B_RESERVED_98_89                    (0x4147f)
#define P_EMMC_B_RESERVED_98_89                    (volatile uint32_t *)((0x4147f  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_000                         (0x41480)
#define P_EMMC_B_GDESC_000                         (volatile uint32_t *)((0x41480  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_001                         (0x41481)
#define P_EMMC_B_GDESC_001                         (volatile uint32_t *)((0x41481  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_002                         (0x41482)
#define P_EMMC_B_GDESC_002                         (volatile uint32_t *)((0x41482  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_003                         (0x41483)
#define P_EMMC_B_GDESC_003                         (volatile uint32_t *)((0x41483  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_004                         (0x41484)
#define P_EMMC_B_GDESC_004                         (volatile uint32_t *)((0x41484  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_005                         (0x41485)
#define P_EMMC_B_GDESC_005                         (volatile uint32_t *)((0x41485  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_006                         (0x41486)
#define P_EMMC_B_GDESC_006                         (volatile uint32_t *)((0x41486  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_007                         (0x41487)
#define P_EMMC_B_GDESC_007                         (volatile uint32_t *)((0x41487  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_008                         (0x41488)
#define P_EMMC_B_GDESC_008                         (volatile uint32_t *)((0x41488  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_009                         (0x41489)
#define P_EMMC_B_GDESC_009                         (volatile uint32_t *)((0x41489  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_010                         (0x4148a)
#define P_EMMC_B_GDESC_010                         (volatile uint32_t *)((0x4148a  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_011                         (0x4148b)
#define P_EMMC_B_GDESC_011                         (volatile uint32_t *)((0x4148b  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_012                         (0x4148c)
#define P_EMMC_B_GDESC_012                         (volatile uint32_t *)((0x4148c  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_013                         (0x4148d)
#define P_EMMC_B_GDESC_013                         (volatile uint32_t *)((0x4148d  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_014                         (0x4148e)
#define P_EMMC_B_GDESC_014                         (volatile uint32_t *)((0x4148e  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_015                         (0x4148f)
#define P_EMMC_B_GDESC_015                         (volatile uint32_t *)((0x4148f  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_016                         (0x41490)
#define P_EMMC_B_GDESC_016                         (volatile uint32_t *)((0x41490  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_017                         (0x41491)
#define P_EMMC_B_GDESC_017                         (volatile uint32_t *)((0x41491  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_018                         (0x41492)
#define P_EMMC_B_GDESC_018                         (volatile uint32_t *)((0x41492  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_019                         (0x41493)
#define P_EMMC_B_GDESC_019                         (volatile uint32_t *)((0x41493  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_020                         (0x41494)
#define P_EMMC_B_GDESC_020                         (volatile uint32_t *)((0x41494  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_021                         (0x41495)
#define P_EMMC_B_GDESC_021                         (volatile uint32_t *)((0x41495  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_022                         (0x41496)
#define P_EMMC_B_GDESC_022                         (volatile uint32_t *)((0x41496  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_023                         (0x41497)
#define P_EMMC_B_GDESC_023                         (volatile uint32_t *)((0x41497  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_024                         (0x41498)
#define P_EMMC_B_GDESC_024                         (volatile uint32_t *)((0x41498  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_025                         (0x41499)
#define P_EMMC_B_GDESC_025                         (volatile uint32_t *)((0x41499  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_026                         (0x4149a)
#define P_EMMC_B_GDESC_026                         (volatile uint32_t *)((0x4149a  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_027                         (0x4149b)
#define P_EMMC_B_GDESC_027                         (volatile uint32_t *)((0x4149b  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_028                         (0x4149c)
#define P_EMMC_B_GDESC_028                         (volatile uint32_t *)((0x4149c  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_029                         (0x4149d)
#define P_EMMC_B_GDESC_029                         (volatile uint32_t *)((0x4149d  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_030                         (0x4149e)
#define P_EMMC_B_GDESC_030                         (volatile uint32_t *)((0x4149e  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_031                         (0x4149f)
#define P_EMMC_B_GDESC_031                         (volatile uint32_t *)((0x4149f  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_032                         (0x414a0)
#define P_EMMC_B_GDESC_032                         (volatile uint32_t *)((0x414a0  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_033                         (0x414a1)
#define P_EMMC_B_GDESC_033                         (volatile uint32_t *)((0x414a1  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_034                         (0x414a2)
#define P_EMMC_B_GDESC_034                         (volatile uint32_t *)((0x414a2  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_035                         (0x414a3)
#define P_EMMC_B_GDESC_035                         (volatile uint32_t *)((0x414a3  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_036                         (0x414a4)
#define P_EMMC_B_GDESC_036                         (volatile uint32_t *)((0x414a4  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_037                         (0x414a5)
#define P_EMMC_B_GDESC_037                         (volatile uint32_t *)((0x414a5  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_038                         (0x414a6)
#define P_EMMC_B_GDESC_038                         (volatile uint32_t *)((0x414a6  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_039                         (0x414a7)
#define P_EMMC_B_GDESC_039                         (volatile uint32_t *)((0x414a7  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_040                         (0x414a8)
#define P_EMMC_B_GDESC_040                         (volatile uint32_t *)((0x414a8  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_041                         (0x414a9)
#define P_EMMC_B_GDESC_041                         (volatile uint32_t *)((0x414a9  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_042                         (0x414aa)
#define P_EMMC_B_GDESC_042                         (volatile uint32_t *)((0x414aa  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_043                         (0x414ab)
#define P_EMMC_B_GDESC_043                         (volatile uint32_t *)((0x414ab  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_044                         (0x414ac)
#define P_EMMC_B_GDESC_044                         (volatile uint32_t *)((0x414ac  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_045                         (0x414ad)
#define P_EMMC_B_GDESC_045                         (volatile uint32_t *)((0x414ad  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_046                         (0x414ae)
#define P_EMMC_B_GDESC_046                         (volatile uint32_t *)((0x414ae  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_047                         (0x414af)
#define P_EMMC_B_GDESC_047                         (volatile uint32_t *)((0x414af  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_048                         (0x414b0)
#define P_EMMC_B_GDESC_048                         (volatile uint32_t *)((0x414b0  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_049                         (0x414b1)
#define P_EMMC_B_GDESC_049                         (volatile uint32_t *)((0x414b1  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_050                         (0x414b2)
#define P_EMMC_B_GDESC_050                         (volatile uint32_t *)((0x414b2  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_051                         (0x414b3)
#define P_EMMC_B_GDESC_051                         (volatile uint32_t *)((0x414b3  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_052                         (0x414b4)
#define P_EMMC_B_GDESC_052                         (volatile uint32_t *)((0x414b4  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_053                         (0x414b5)
#define P_EMMC_B_GDESC_053                         (volatile uint32_t *)((0x414b5  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_054                         (0x414b6)
#define P_EMMC_B_GDESC_054                         (volatile uint32_t *)((0x414b6  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_055                         (0x414b7)
#define P_EMMC_B_GDESC_055                         (volatile uint32_t *)((0x414b7  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_056                         (0x414b8)
#define P_EMMC_B_GDESC_056                         (volatile uint32_t *)((0x414b8  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_057                         (0x414b9)
#define P_EMMC_B_GDESC_057                         (volatile uint32_t *)((0x414b9  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_058                         (0x414ba)
#define P_EMMC_B_GDESC_058                         (volatile uint32_t *)((0x414ba  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_059                         (0x414bb)
#define P_EMMC_B_GDESC_059                         (volatile uint32_t *)((0x414bb  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_060                         (0x414bc)
#define P_EMMC_B_GDESC_060                         (volatile uint32_t *)((0x414bc  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_061                         (0x414bd)
#define P_EMMC_B_GDESC_061                         (volatile uint32_t *)((0x414bd  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_062                         (0x414be)
#define P_EMMC_B_GDESC_062                         (volatile uint32_t *)((0x414be  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_063                         (0x414bf)
#define P_EMMC_B_GDESC_063                         (volatile uint32_t *)((0x414bf  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_064                         (0x414c0)
#define P_EMMC_B_GDESC_064                         (volatile uint32_t *)((0x414c0  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_065                         (0x414c1)
#define P_EMMC_B_GDESC_065                         (volatile uint32_t *)((0x414c1  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_066                         (0x414c2)
#define P_EMMC_B_GDESC_066                         (volatile uint32_t *)((0x414c2  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_067                         (0x414c3)
#define P_EMMC_B_GDESC_067                         (volatile uint32_t *)((0x414c3  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_068                         (0x414c4)
#define P_EMMC_B_GDESC_068                         (volatile uint32_t *)((0x414c4  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_069                         (0x414c5)
#define P_EMMC_B_GDESC_069                         (volatile uint32_t *)((0x414c5  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_070                         (0x414c6)
#define P_EMMC_B_GDESC_070                         (volatile uint32_t *)((0x414c6  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_071                         (0x414c7)
#define P_EMMC_B_GDESC_071                         (volatile uint32_t *)((0x414c7  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_072                         (0x414c8)
#define P_EMMC_B_GDESC_072                         (volatile uint32_t *)((0x414c8  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_073                         (0x414c9)
#define P_EMMC_B_GDESC_073                         (volatile uint32_t *)((0x414c9  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_074                         (0x414ca)
#define P_EMMC_B_GDESC_074                         (volatile uint32_t *)((0x414ca  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_075                         (0x414cb)
#define P_EMMC_B_GDESC_075                         (volatile uint32_t *)((0x414cb  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_076                         (0x414cc)
#define P_EMMC_B_GDESC_076                         (volatile uint32_t *)((0x414cc  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_077                         (0x414cd)
#define P_EMMC_B_GDESC_077                         (volatile uint32_t *)((0x414cd  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_078                         (0x414ce)
#define P_EMMC_B_GDESC_078                         (volatile uint32_t *)((0x414ce  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_079                         (0x414cf)
#define P_EMMC_B_GDESC_079                         (volatile uint32_t *)((0x414cf  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_080                         (0x414d0)
#define P_EMMC_B_GDESC_080                         (volatile uint32_t *)((0x414d0  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_081                         (0x414d1)
#define P_EMMC_B_GDESC_081                         (volatile uint32_t *)((0x414d1  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_082                         (0x414d2)
#define P_EMMC_B_GDESC_082                         (volatile uint32_t *)((0x414d2  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_083                         (0x414d3)
#define P_EMMC_B_GDESC_083                         (volatile uint32_t *)((0x414d3  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_084                         (0x414d4)
#define P_EMMC_B_GDESC_084                         (volatile uint32_t *)((0x414d4  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_085                         (0x414d5)
#define P_EMMC_B_GDESC_085                         (volatile uint32_t *)((0x414d5  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_086                         (0x414d6)
#define P_EMMC_B_GDESC_086                         (volatile uint32_t *)((0x414d6  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_087                         (0x414d7)
#define P_EMMC_B_GDESC_087                         (volatile uint32_t *)((0x414d7  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_088                         (0x414d8)
#define P_EMMC_B_GDESC_088                         (volatile uint32_t *)((0x414d8  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_089                         (0x414d9)
#define P_EMMC_B_GDESC_089                         (volatile uint32_t *)((0x414d9  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_090                         (0x414da)
#define P_EMMC_B_GDESC_090                         (volatile uint32_t *)((0x414da  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_091                         (0x414db)
#define P_EMMC_B_GDESC_091                         (volatile uint32_t *)((0x414db  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_092                         (0x414dc)
#define P_EMMC_B_GDESC_092                         (volatile uint32_t *)((0x414dc  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_093                         (0x414dd)
#define P_EMMC_B_GDESC_093                         (volatile uint32_t *)((0x414dd  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_094                         (0x414de)
#define P_EMMC_B_GDESC_094                         (volatile uint32_t *)((0x414de  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_095                         (0x414df)
#define P_EMMC_B_GDESC_095                         (volatile uint32_t *)((0x414df  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_096                         (0x414e0)
#define P_EMMC_B_GDESC_096                         (volatile uint32_t *)((0x414e0  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_097                         (0x414e1)
#define P_EMMC_B_GDESC_097                         (volatile uint32_t *)((0x414e1  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_098                         (0x414e2)
#define P_EMMC_B_GDESC_098                         (volatile uint32_t *)((0x414e2  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_099                         (0x414e3)
#define P_EMMC_B_GDESC_099                         (volatile uint32_t *)((0x414e3  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_100                         (0x414e4)
#define P_EMMC_B_GDESC_100                         (volatile uint32_t *)((0x414e4  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_101                         (0x414e5)
#define P_EMMC_B_GDESC_101                         (volatile uint32_t *)((0x414e5  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_102                         (0x414e6)
#define P_EMMC_B_GDESC_102                         (volatile uint32_t *)((0x414e6  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_103                         (0x414e7)
#define P_EMMC_B_GDESC_103                         (volatile uint32_t *)((0x414e7  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_104                         (0x414e8)
#define P_EMMC_B_GDESC_104                         (volatile uint32_t *)((0x414e8  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_105                         (0x414e9)
#define P_EMMC_B_GDESC_105                         (volatile uint32_t *)((0x414e9  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_106                         (0x414ea)
#define P_EMMC_B_GDESC_106                         (volatile uint32_t *)((0x414ea  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_107                         (0x414eb)
#define P_EMMC_B_GDESC_107                         (volatile uint32_t *)((0x414eb  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_108                         (0x414ec)
#define P_EMMC_B_GDESC_108                         (volatile uint32_t *)((0x414ec  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_109                         (0x414ed)
#define P_EMMC_B_GDESC_109                         (volatile uint32_t *)((0x414ed  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_110                         (0x414ee)
#define P_EMMC_B_GDESC_110                         (volatile uint32_t *)((0x414ee  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_111                         (0x414ef)
#define P_EMMC_B_GDESC_111                         (volatile uint32_t *)((0x414ef  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_112                         (0x414f0)
#define P_EMMC_B_GDESC_112                         (volatile uint32_t *)((0x414f0  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_113                         (0x414f1)
#define P_EMMC_B_GDESC_113                         (volatile uint32_t *)((0x414f1  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_114                         (0x414f2)
#define P_EMMC_B_GDESC_114                         (volatile uint32_t *)((0x414f2  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_115                         (0x414f3)
#define P_EMMC_B_GDESC_115                         (volatile uint32_t *)((0x414f3  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_116                         (0x414f4)
#define P_EMMC_B_GDESC_116                         (volatile uint32_t *)((0x414f4  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_117                         (0x414f5)
#define P_EMMC_B_GDESC_117                         (volatile uint32_t *)((0x414f5  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_118                         (0x414f6)
#define P_EMMC_B_GDESC_118                         (volatile uint32_t *)((0x414f6  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_119                         (0x414f7)
#define P_EMMC_B_GDESC_119                         (volatile uint32_t *)((0x414f7  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_120                         (0x414f8)
#define P_EMMC_B_GDESC_120                         (volatile uint32_t *)((0x414f8  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_121                         (0x414f9)
#define P_EMMC_B_GDESC_121                         (volatile uint32_t *)((0x414f9  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_122                         (0x414fa)
#define P_EMMC_B_GDESC_122                         (volatile uint32_t *)((0x414fa  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_123                         (0x414fb)
#define P_EMMC_B_GDESC_123                         (volatile uint32_t *)((0x414fb  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_124                         (0x414fc)
#define P_EMMC_B_GDESC_124                         (volatile uint32_t *)((0x414fc  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_125                         (0x414fd)
#define P_EMMC_B_GDESC_125                         (volatile uint32_t *)((0x414fd  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_126                         (0x414fe)
#define P_EMMC_B_GDESC_126                         (volatile uint32_t *)((0x414fe  << 2) + 0xffd00000)
#define   EMMC_B_GDESC_127                         (0x414ff)
#define P_EMMC_B_GDESC_127                         (volatile uint32_t *)((0x414ff  << 2) + 0xffd00000)
#define   EMMC_B_GPING_000                         (0x41500)
#define P_EMMC_B_GPING_000                         (volatile uint32_t *)((0x41500  << 2) + 0xffd00000)
#define   EMMC_B_GPING_001                         (0x41501)
#define P_EMMC_B_GPING_001                         (volatile uint32_t *)((0x41501  << 2) + 0xffd00000)
#define   EMMC_B_GPING_002                         (0x41502)
#define P_EMMC_B_GPING_002                         (volatile uint32_t *)((0x41502  << 2) + 0xffd00000)
#define   EMMC_B_GPING_003                         (0x41503)
#define P_EMMC_B_GPING_003                         (volatile uint32_t *)((0x41503  << 2) + 0xffd00000)
#define   EMMC_B_GPING_004                         (0x41504)
#define P_EMMC_B_GPING_004                         (volatile uint32_t *)((0x41504  << 2) + 0xffd00000)
#define   EMMC_B_GPING_005                         (0x41505)
#define P_EMMC_B_GPING_005                         (volatile uint32_t *)((0x41505  << 2) + 0xffd00000)
#define   EMMC_B_GPING_006                         (0x41506)
#define P_EMMC_B_GPING_006                         (volatile uint32_t *)((0x41506  << 2) + 0xffd00000)
#define   EMMC_B_GPING_007                         (0x41507)
#define P_EMMC_B_GPING_007                         (volatile uint32_t *)((0x41507  << 2) + 0xffd00000)
#define   EMMC_B_GPING_008                         (0x41508)
#define P_EMMC_B_GPING_008                         (volatile uint32_t *)((0x41508  << 2) + 0xffd00000)
#define   EMMC_B_GPING_009                         (0x41509)
#define P_EMMC_B_GPING_009                         (volatile uint32_t *)((0x41509  << 2) + 0xffd00000)
#define   EMMC_B_GPING_010                         (0x4150a)
#define P_EMMC_B_GPING_010                         (volatile uint32_t *)((0x4150a  << 2) + 0xffd00000)
#define   EMMC_B_GPING_011                         (0x4150b)
#define P_EMMC_B_GPING_011                         (volatile uint32_t *)((0x4150b  << 2) + 0xffd00000)
#define   EMMC_B_GPING_012                         (0x4150c)
#define P_EMMC_B_GPING_012                         (volatile uint32_t *)((0x4150c  << 2) + 0xffd00000)
#define   EMMC_B_GPING_013                         (0x4150d)
#define P_EMMC_B_GPING_013                         (volatile uint32_t *)((0x4150d  << 2) + 0xffd00000)
#define   EMMC_B_GPING_014                         (0x4150e)
#define P_EMMC_B_GPING_014                         (volatile uint32_t *)((0x4150e  << 2) + 0xffd00000)
#define   EMMC_B_GPING_015                         (0x4150f)
#define P_EMMC_B_GPING_015                         (volatile uint32_t *)((0x4150f  << 2) + 0xffd00000)
#define   EMMC_B_GPING_016                         (0x41510)
#define P_EMMC_B_GPING_016                         (volatile uint32_t *)((0x41510  << 2) + 0xffd00000)
#define   EMMC_B_GPING_017                         (0x41511)
#define P_EMMC_B_GPING_017                         (volatile uint32_t *)((0x41511  << 2) + 0xffd00000)
#define   EMMC_B_GPING_018                         (0x41512)
#define P_EMMC_B_GPING_018                         (volatile uint32_t *)((0x41512  << 2) + 0xffd00000)
#define   EMMC_B_GPING_019                         (0x41513)
#define P_EMMC_B_GPING_019                         (volatile uint32_t *)((0x41513  << 2) + 0xffd00000)
#define   EMMC_B_GPING_020                         (0x41514)
#define P_EMMC_B_GPING_020                         (volatile uint32_t *)((0x41514  << 2) + 0xffd00000)
#define   EMMC_B_GPING_021                         (0x41515)
#define P_EMMC_B_GPING_021                         (volatile uint32_t *)((0x41515  << 2) + 0xffd00000)
#define   EMMC_B_GPING_022                         (0x41516)
#define P_EMMC_B_GPING_022                         (volatile uint32_t *)((0x41516  << 2) + 0xffd00000)
#define   EMMC_B_GPING_023                         (0x41517)
#define P_EMMC_B_GPING_023                         (volatile uint32_t *)((0x41517  << 2) + 0xffd00000)
#define   EMMC_B_GPING_024                         (0x41518)
#define P_EMMC_B_GPING_024                         (volatile uint32_t *)((0x41518  << 2) + 0xffd00000)
#define   EMMC_B_GPING_025                         (0x41519)
#define P_EMMC_B_GPING_025                         (volatile uint32_t *)((0x41519  << 2) + 0xffd00000)
#define   EMMC_B_GPING_026                         (0x4151a)
#define P_EMMC_B_GPING_026                         (volatile uint32_t *)((0x4151a  << 2) + 0xffd00000)
#define   EMMC_B_GPING_027                         (0x4151b)
#define P_EMMC_B_GPING_027                         (volatile uint32_t *)((0x4151b  << 2) + 0xffd00000)
#define   EMMC_B_GPING_028                         (0x4151c)
#define P_EMMC_B_GPING_028                         (volatile uint32_t *)((0x4151c  << 2) + 0xffd00000)
#define   EMMC_B_GPING_029                         (0x4151d)
#define P_EMMC_B_GPING_029                         (volatile uint32_t *)((0x4151d  << 2) + 0xffd00000)
#define   EMMC_B_GPING_030                         (0x4151e)
#define P_EMMC_B_GPING_030                         (volatile uint32_t *)((0x4151e  << 2) + 0xffd00000)
#define   EMMC_B_GPING_031                         (0x4151f)
#define P_EMMC_B_GPING_031                         (volatile uint32_t *)((0x4151f  << 2) + 0xffd00000)
#define   EMMC_B_GPING_032                         (0x41520)
#define P_EMMC_B_GPING_032                         (volatile uint32_t *)((0x41520  << 2) + 0xffd00000)
#define   EMMC_B_GPING_033                         (0x41521)
#define P_EMMC_B_GPING_033                         (volatile uint32_t *)((0x41521  << 2) + 0xffd00000)
#define   EMMC_B_GPING_034                         (0x41522)
#define P_EMMC_B_GPING_034                         (volatile uint32_t *)((0x41522  << 2) + 0xffd00000)
#define   EMMC_B_GPING_035                         (0x41523)
#define P_EMMC_B_GPING_035                         (volatile uint32_t *)((0x41523  << 2) + 0xffd00000)
#define   EMMC_B_GPING_036                         (0x41524)
#define P_EMMC_B_GPING_036                         (volatile uint32_t *)((0x41524  << 2) + 0xffd00000)
#define   EMMC_B_GPING_037                         (0x41525)
#define P_EMMC_B_GPING_037                         (volatile uint32_t *)((0x41525  << 2) + 0xffd00000)
#define   EMMC_B_GPING_038                         (0x41526)
#define P_EMMC_B_GPING_038                         (volatile uint32_t *)((0x41526  << 2) + 0xffd00000)
#define   EMMC_B_GPING_039                         (0x41527)
#define P_EMMC_B_GPING_039                         (volatile uint32_t *)((0x41527  << 2) + 0xffd00000)
#define   EMMC_B_GPING_040                         (0x41528)
#define P_EMMC_B_GPING_040                         (volatile uint32_t *)((0x41528  << 2) + 0xffd00000)
#define   EMMC_B_GPING_041                         (0x41529)
#define P_EMMC_B_GPING_041                         (volatile uint32_t *)((0x41529  << 2) + 0xffd00000)
#define   EMMC_B_GPING_042                         (0x4152a)
#define P_EMMC_B_GPING_042                         (volatile uint32_t *)((0x4152a  << 2) + 0xffd00000)
#define   EMMC_B_GPING_043                         (0x4152b)
#define P_EMMC_B_GPING_043                         (volatile uint32_t *)((0x4152b  << 2) + 0xffd00000)
#define   EMMC_B_GPING_044                         (0x4152c)
#define P_EMMC_B_GPING_044                         (volatile uint32_t *)((0x4152c  << 2) + 0xffd00000)
#define   EMMC_B_GPING_045                         (0x4152d)
#define P_EMMC_B_GPING_045                         (volatile uint32_t *)((0x4152d  << 2) + 0xffd00000)
#define   EMMC_B_GPING_046                         (0x4152e)
#define P_EMMC_B_GPING_046                         (volatile uint32_t *)((0x4152e  << 2) + 0xffd00000)
#define   EMMC_B_GPING_047                         (0x4152f)
#define P_EMMC_B_GPING_047                         (volatile uint32_t *)((0x4152f  << 2) + 0xffd00000)
#define   EMMC_B_GPING_048                         (0x41530)
#define P_EMMC_B_GPING_048                         (volatile uint32_t *)((0x41530  << 2) + 0xffd00000)
#define   EMMC_B_GPING_049                         (0x41531)
#define P_EMMC_B_GPING_049                         (volatile uint32_t *)((0x41531  << 2) + 0xffd00000)
#define   EMMC_B_GPING_050                         (0x41532)
#define P_EMMC_B_GPING_050                         (volatile uint32_t *)((0x41532  << 2) + 0xffd00000)
#define   EMMC_B_GPING_051                         (0x41533)
#define P_EMMC_B_GPING_051                         (volatile uint32_t *)((0x41533  << 2) + 0xffd00000)
#define   EMMC_B_GPING_052                         (0x41534)
#define P_EMMC_B_GPING_052                         (volatile uint32_t *)((0x41534  << 2) + 0xffd00000)
#define   EMMC_B_GPING_053                         (0x41535)
#define P_EMMC_B_GPING_053                         (volatile uint32_t *)((0x41535  << 2) + 0xffd00000)
#define   EMMC_B_GPING_054                         (0x41536)
#define P_EMMC_B_GPING_054                         (volatile uint32_t *)((0x41536  << 2) + 0xffd00000)
#define   EMMC_B_GPING_055                         (0x41537)
#define P_EMMC_B_GPING_055                         (volatile uint32_t *)((0x41537  << 2) + 0xffd00000)
#define   EMMC_B_GPING_056                         (0x41538)
#define P_EMMC_B_GPING_056                         (volatile uint32_t *)((0x41538  << 2) + 0xffd00000)
#define   EMMC_B_GPING_057                         (0x41539)
#define P_EMMC_B_GPING_057                         (volatile uint32_t *)((0x41539  << 2) + 0xffd00000)
#define   EMMC_B_GPING_058                         (0x4153a)
#define P_EMMC_B_GPING_058                         (volatile uint32_t *)((0x4153a  << 2) + 0xffd00000)
#define   EMMC_B_GPING_059                         (0x4153b)
#define P_EMMC_B_GPING_059                         (volatile uint32_t *)((0x4153b  << 2) + 0xffd00000)
#define   EMMC_B_GPING_060                         (0x4153c)
#define P_EMMC_B_GPING_060                         (volatile uint32_t *)((0x4153c  << 2) + 0xffd00000)
#define   EMMC_B_GPING_061                         (0x4153d)
#define P_EMMC_B_GPING_061                         (volatile uint32_t *)((0x4153d  << 2) + 0xffd00000)
#define   EMMC_B_GPING_062                         (0x4153e)
#define P_EMMC_B_GPING_062                         (volatile uint32_t *)((0x4153e  << 2) + 0xffd00000)
#define   EMMC_B_GPING_063                         (0x4153f)
#define P_EMMC_B_GPING_063                         (volatile uint32_t *)((0x4153f  << 2) + 0xffd00000)
#define   EMMC_B_GPING_064                         (0x41540)
#define P_EMMC_B_GPING_064                         (volatile uint32_t *)((0x41540  << 2) + 0xffd00000)
#define   EMMC_B_GPING_065                         (0x41541)
#define P_EMMC_B_GPING_065                         (volatile uint32_t *)((0x41541  << 2) + 0xffd00000)
#define   EMMC_B_GPING_066                         (0x41542)
#define P_EMMC_B_GPING_066                         (volatile uint32_t *)((0x41542  << 2) + 0xffd00000)
#define   EMMC_B_GPING_067                         (0x41543)
#define P_EMMC_B_GPING_067                         (volatile uint32_t *)((0x41543  << 2) + 0xffd00000)
#define   EMMC_B_GPING_068                         (0x41544)
#define P_EMMC_B_GPING_068                         (volatile uint32_t *)((0x41544  << 2) + 0xffd00000)
#define   EMMC_B_GPING_069                         (0x41545)
#define P_EMMC_B_GPING_069                         (volatile uint32_t *)((0x41545  << 2) + 0xffd00000)
#define   EMMC_B_GPING_070                         (0x41546)
#define P_EMMC_B_GPING_070                         (volatile uint32_t *)((0x41546  << 2) + 0xffd00000)
#define   EMMC_B_GPING_071                         (0x41547)
#define P_EMMC_B_GPING_071                         (volatile uint32_t *)((0x41547  << 2) + 0xffd00000)
#define   EMMC_B_GPING_072                         (0x41548)
#define P_EMMC_B_GPING_072                         (volatile uint32_t *)((0x41548  << 2) + 0xffd00000)
#define   EMMC_B_GPING_073                         (0x41549)
#define P_EMMC_B_GPING_073                         (volatile uint32_t *)((0x41549  << 2) + 0xffd00000)
#define   EMMC_B_GPING_074                         (0x4154a)
#define P_EMMC_B_GPING_074                         (volatile uint32_t *)((0x4154a  << 2) + 0xffd00000)
#define   EMMC_B_GPING_075                         (0x4154b)
#define P_EMMC_B_GPING_075                         (volatile uint32_t *)((0x4154b  << 2) + 0xffd00000)
#define   EMMC_B_GPING_076                         (0x4154c)
#define P_EMMC_B_GPING_076                         (volatile uint32_t *)((0x4154c  << 2) + 0xffd00000)
#define   EMMC_B_GPING_077                         (0x4154d)
#define P_EMMC_B_GPING_077                         (volatile uint32_t *)((0x4154d  << 2) + 0xffd00000)
#define   EMMC_B_GPING_078                         (0x4154e)
#define P_EMMC_B_GPING_078                         (volatile uint32_t *)((0x4154e  << 2) + 0xffd00000)
#define   EMMC_B_GPING_079                         (0x4154f)
#define P_EMMC_B_GPING_079                         (volatile uint32_t *)((0x4154f  << 2) + 0xffd00000)
#define   EMMC_B_GPING_080                         (0x41550)
#define P_EMMC_B_GPING_080                         (volatile uint32_t *)((0x41550  << 2) + 0xffd00000)
#define   EMMC_B_GPING_081                         (0x41551)
#define P_EMMC_B_GPING_081                         (volatile uint32_t *)((0x41551  << 2) + 0xffd00000)
#define   EMMC_B_GPING_082                         (0x41552)
#define P_EMMC_B_GPING_082                         (volatile uint32_t *)((0x41552  << 2) + 0xffd00000)
#define   EMMC_B_GPING_083                         (0x41553)
#define P_EMMC_B_GPING_083                         (volatile uint32_t *)((0x41553  << 2) + 0xffd00000)
#define   EMMC_B_GPING_084                         (0x41554)
#define P_EMMC_B_GPING_084                         (volatile uint32_t *)((0x41554  << 2) + 0xffd00000)
#define   EMMC_B_GPING_085                         (0x41555)
#define P_EMMC_B_GPING_085                         (volatile uint32_t *)((0x41555  << 2) + 0xffd00000)
#define   EMMC_B_GPING_086                         (0x41556)
#define P_EMMC_B_GPING_086                         (volatile uint32_t *)((0x41556  << 2) + 0xffd00000)
#define   EMMC_B_GPING_087                         (0x41557)
#define P_EMMC_B_GPING_087                         (volatile uint32_t *)((0x41557  << 2) + 0xffd00000)
#define   EMMC_B_GPING_088                         (0x41558)
#define P_EMMC_B_GPING_088                         (volatile uint32_t *)((0x41558  << 2) + 0xffd00000)
#define   EMMC_B_GPING_089                         (0x41559)
#define P_EMMC_B_GPING_089                         (volatile uint32_t *)((0x41559  << 2) + 0xffd00000)
#define   EMMC_B_GPING_090                         (0x4155a)
#define P_EMMC_B_GPING_090                         (volatile uint32_t *)((0x4155a  << 2) + 0xffd00000)
#define   EMMC_B_GPING_091                         (0x4155b)
#define P_EMMC_B_GPING_091                         (volatile uint32_t *)((0x4155b  << 2) + 0xffd00000)
#define   EMMC_B_GPING_092                         (0x4155c)
#define P_EMMC_B_GPING_092                         (volatile uint32_t *)((0x4155c  << 2) + 0xffd00000)
#define   EMMC_B_GPING_093                         (0x4155d)
#define P_EMMC_B_GPING_093                         (volatile uint32_t *)((0x4155d  << 2) + 0xffd00000)
#define   EMMC_B_GPING_094                         (0x4155e)
#define P_EMMC_B_GPING_094                         (volatile uint32_t *)((0x4155e  << 2) + 0xffd00000)
#define   EMMC_B_GPING_095                         (0x4155f)
#define P_EMMC_B_GPING_095                         (volatile uint32_t *)((0x4155f  << 2) + 0xffd00000)
#define   EMMC_B_GPING_096                         (0x41560)
#define P_EMMC_B_GPING_096                         (volatile uint32_t *)((0x41560  << 2) + 0xffd00000)
#define   EMMC_B_GPING_097                         (0x41561)
#define P_EMMC_B_GPING_097                         (volatile uint32_t *)((0x41561  << 2) + 0xffd00000)
#define   EMMC_B_GPING_098                         (0x41562)
#define P_EMMC_B_GPING_098                         (volatile uint32_t *)((0x41562  << 2) + 0xffd00000)
#define   EMMC_B_GPING_099                         (0x41563)
#define P_EMMC_B_GPING_099                         (volatile uint32_t *)((0x41563  << 2) + 0xffd00000)
#define   EMMC_B_GPING_100                         (0x41564)
#define P_EMMC_B_GPING_100                         (volatile uint32_t *)((0x41564  << 2) + 0xffd00000)
#define   EMMC_B_GPING_101                         (0x41565)
#define P_EMMC_B_GPING_101                         (volatile uint32_t *)((0x41565  << 2) + 0xffd00000)
#define   EMMC_B_GPING_102                         (0x41566)
#define P_EMMC_B_GPING_102                         (volatile uint32_t *)((0x41566  << 2) + 0xffd00000)
#define   EMMC_B_GPING_103                         (0x41567)
#define P_EMMC_B_GPING_103                         (volatile uint32_t *)((0x41567  << 2) + 0xffd00000)
#define   EMMC_B_GPING_104                         (0x41568)
#define P_EMMC_B_GPING_104                         (volatile uint32_t *)((0x41568  << 2) + 0xffd00000)
#define   EMMC_B_GPING_105                         (0x41569)
#define P_EMMC_B_GPING_105                         (volatile uint32_t *)((0x41569  << 2) + 0xffd00000)
#define   EMMC_B_GPING_106                         (0x4156a)
#define P_EMMC_B_GPING_106                         (volatile uint32_t *)((0x4156a  << 2) + 0xffd00000)
#define   EMMC_B_GPING_107                         (0x4156b)
#define P_EMMC_B_GPING_107                         (volatile uint32_t *)((0x4156b  << 2) + 0xffd00000)
#define   EMMC_B_GPING_108                         (0x4156c)
#define P_EMMC_B_GPING_108                         (volatile uint32_t *)((0x4156c  << 2) + 0xffd00000)
#define   EMMC_B_GPING_109                         (0x4156d)
#define P_EMMC_B_GPING_109                         (volatile uint32_t *)((0x4156d  << 2) + 0xffd00000)
#define   EMMC_B_GPING_110                         (0x4156e)
#define P_EMMC_B_GPING_110                         (volatile uint32_t *)((0x4156e  << 2) + 0xffd00000)
#define   EMMC_B_GPING_111                         (0x4156f)
#define P_EMMC_B_GPING_111                         (volatile uint32_t *)((0x4156f  << 2) + 0xffd00000)
#define   EMMC_B_GPING_112                         (0x41570)
#define P_EMMC_B_GPING_112                         (volatile uint32_t *)((0x41570  << 2) + 0xffd00000)
#define   EMMC_B_GPING_113                         (0x41571)
#define P_EMMC_B_GPING_113                         (volatile uint32_t *)((0x41571  << 2) + 0xffd00000)
#define   EMMC_B_GPING_114                         (0x41572)
#define P_EMMC_B_GPING_114                         (volatile uint32_t *)((0x41572  << 2) + 0xffd00000)
#define   EMMC_B_GPING_115                         (0x41573)
#define P_EMMC_B_GPING_115                         (volatile uint32_t *)((0x41573  << 2) + 0xffd00000)
#define   EMMC_B_GPING_116                         (0x41574)
#define P_EMMC_B_GPING_116                         (volatile uint32_t *)((0x41574  << 2) + 0xffd00000)
#define   EMMC_B_GPING_117                         (0x41575)
#define P_EMMC_B_GPING_117                         (volatile uint32_t *)((0x41575  << 2) + 0xffd00000)
#define   EMMC_B_GPING_118                         (0x41576)
#define P_EMMC_B_GPING_118                         (volatile uint32_t *)((0x41576  << 2) + 0xffd00000)
#define   EMMC_B_GPING_119                         (0x41577)
#define P_EMMC_B_GPING_119                         (volatile uint32_t *)((0x41577  << 2) + 0xffd00000)
#define   EMMC_B_GPING_120                         (0x41578)
#define P_EMMC_B_GPING_120                         (volatile uint32_t *)((0x41578  << 2) + 0xffd00000)
#define   EMMC_B_GPING_121                         (0x41579)
#define P_EMMC_B_GPING_121                         (volatile uint32_t *)((0x41579  << 2) + 0xffd00000)
#define   EMMC_B_GPING_122                         (0x4157a)
#define P_EMMC_B_GPING_122                         (volatile uint32_t *)((0x4157a  << 2) + 0xffd00000)
#define   EMMC_B_GPING_123                         (0x4157b)
#define P_EMMC_B_GPING_123                         (volatile uint32_t *)((0x4157b  << 2) + 0xffd00000)
#define   EMMC_B_GPING_124                         (0x4157c)
#define P_EMMC_B_GPING_124                         (volatile uint32_t *)((0x4157c  << 2) + 0xffd00000)
#define   EMMC_B_GPING_125                         (0x4157d)
#define P_EMMC_B_GPING_125                         (volatile uint32_t *)((0x4157d  << 2) + 0xffd00000)
#define   EMMC_B_GPING_126                         (0x4157e)
#define P_EMMC_B_GPING_126                         (volatile uint32_t *)((0x4157e  << 2) + 0xffd00000)
#define   EMMC_B_GPING_127                         (0x4157f)
#define P_EMMC_B_GPING_127                         (volatile uint32_t *)((0x4157f  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_000                         (0x41580)
#define P_EMMC_B_GPONG_000                         (volatile uint32_t *)((0x41580  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_001                         (0x41581)
#define P_EMMC_B_GPONG_001                         (volatile uint32_t *)((0x41581  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_002                         (0x41582)
#define P_EMMC_B_GPONG_002                         (volatile uint32_t *)((0x41582  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_003                         (0x41583)
#define P_EMMC_B_GPONG_003                         (volatile uint32_t *)((0x41583  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_004                         (0x41584)
#define P_EMMC_B_GPONG_004                         (volatile uint32_t *)((0x41584  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_005                         (0x41585)
#define P_EMMC_B_GPONG_005                         (volatile uint32_t *)((0x41585  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_006                         (0x41586)
#define P_EMMC_B_GPONG_006                         (volatile uint32_t *)((0x41586  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_007                         (0x41587)
#define P_EMMC_B_GPONG_007                         (volatile uint32_t *)((0x41587  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_008                         (0x41588)
#define P_EMMC_B_GPONG_008                         (volatile uint32_t *)((0x41588  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_009                         (0x41589)
#define P_EMMC_B_GPONG_009                         (volatile uint32_t *)((0x41589  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_010                         (0x4158a)
#define P_EMMC_B_GPONG_010                         (volatile uint32_t *)((0x4158a  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_011                         (0x4158b)
#define P_EMMC_B_GPONG_011                         (volatile uint32_t *)((0x4158b  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_012                         (0x4158c)
#define P_EMMC_B_GPONG_012                         (volatile uint32_t *)((0x4158c  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_013                         (0x4158d)
#define P_EMMC_B_GPONG_013                         (volatile uint32_t *)((0x4158d  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_014                         (0x4158e)
#define P_EMMC_B_GPONG_014                         (volatile uint32_t *)((0x4158e  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_015                         (0x4158f)
#define P_EMMC_B_GPONG_015                         (volatile uint32_t *)((0x4158f  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_016                         (0x41590)
#define P_EMMC_B_GPONG_016                         (volatile uint32_t *)((0x41590  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_017                         (0x41591)
#define P_EMMC_B_GPONG_017                         (volatile uint32_t *)((0x41591  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_018                         (0x41592)
#define P_EMMC_B_GPONG_018                         (volatile uint32_t *)((0x41592  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_019                         (0x41593)
#define P_EMMC_B_GPONG_019                         (volatile uint32_t *)((0x41593  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_020                         (0x41594)
#define P_EMMC_B_GPONG_020                         (volatile uint32_t *)((0x41594  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_021                         (0x41595)
#define P_EMMC_B_GPONG_021                         (volatile uint32_t *)((0x41595  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_022                         (0x41596)
#define P_EMMC_B_GPONG_022                         (volatile uint32_t *)((0x41596  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_023                         (0x41597)
#define P_EMMC_B_GPONG_023                         (volatile uint32_t *)((0x41597  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_024                         (0x41598)
#define P_EMMC_B_GPONG_024                         (volatile uint32_t *)((0x41598  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_025                         (0x41599)
#define P_EMMC_B_GPONG_025                         (volatile uint32_t *)((0x41599  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_026                         (0x4159a)
#define P_EMMC_B_GPONG_026                         (volatile uint32_t *)((0x4159a  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_027                         (0x4159b)
#define P_EMMC_B_GPONG_027                         (volatile uint32_t *)((0x4159b  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_028                         (0x4159c)
#define P_EMMC_B_GPONG_028                         (volatile uint32_t *)((0x4159c  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_029                         (0x4159d)
#define P_EMMC_B_GPONG_029                         (volatile uint32_t *)((0x4159d  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_030                         (0x4159e)
#define P_EMMC_B_GPONG_030                         (volatile uint32_t *)((0x4159e  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_031                         (0x4159f)
#define P_EMMC_B_GPONG_031                         (volatile uint32_t *)((0x4159f  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_032                         (0x415a0)
#define P_EMMC_B_GPONG_032                         (volatile uint32_t *)((0x415a0  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_033                         (0x415a1)
#define P_EMMC_B_GPONG_033                         (volatile uint32_t *)((0x415a1  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_034                         (0x415a2)
#define P_EMMC_B_GPONG_034                         (volatile uint32_t *)((0x415a2  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_035                         (0x415a3)
#define P_EMMC_B_GPONG_035                         (volatile uint32_t *)((0x415a3  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_036                         (0x415a4)
#define P_EMMC_B_GPONG_036                         (volatile uint32_t *)((0x415a4  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_037                         (0x415a5)
#define P_EMMC_B_GPONG_037                         (volatile uint32_t *)((0x415a5  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_038                         (0x415a6)
#define P_EMMC_B_GPONG_038                         (volatile uint32_t *)((0x415a6  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_039                         (0x415a7)
#define P_EMMC_B_GPONG_039                         (volatile uint32_t *)((0x415a7  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_040                         (0x415a8)
#define P_EMMC_B_GPONG_040                         (volatile uint32_t *)((0x415a8  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_041                         (0x415a9)
#define P_EMMC_B_GPONG_041                         (volatile uint32_t *)((0x415a9  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_042                         (0x415aa)
#define P_EMMC_B_GPONG_042                         (volatile uint32_t *)((0x415aa  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_043                         (0x415ab)
#define P_EMMC_B_GPONG_043                         (volatile uint32_t *)((0x415ab  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_044                         (0x415ac)
#define P_EMMC_B_GPONG_044                         (volatile uint32_t *)((0x415ac  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_045                         (0x415ad)
#define P_EMMC_B_GPONG_045                         (volatile uint32_t *)((0x415ad  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_046                         (0x415ae)
#define P_EMMC_B_GPONG_046                         (volatile uint32_t *)((0x415ae  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_047                         (0x415af)
#define P_EMMC_B_GPONG_047                         (volatile uint32_t *)((0x415af  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_048                         (0x415b0)
#define P_EMMC_B_GPONG_048                         (volatile uint32_t *)((0x415b0  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_049                         (0x415b1)
#define P_EMMC_B_GPONG_049                         (volatile uint32_t *)((0x415b1  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_050                         (0x415b2)
#define P_EMMC_B_GPONG_050                         (volatile uint32_t *)((0x415b2  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_051                         (0x415b3)
#define P_EMMC_B_GPONG_051                         (volatile uint32_t *)((0x415b3  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_052                         (0x415b4)
#define P_EMMC_B_GPONG_052                         (volatile uint32_t *)((0x415b4  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_053                         (0x415b5)
#define P_EMMC_B_GPONG_053                         (volatile uint32_t *)((0x415b5  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_054                         (0x415b6)
#define P_EMMC_B_GPONG_054                         (volatile uint32_t *)((0x415b6  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_055                         (0x415b7)
#define P_EMMC_B_GPONG_055                         (volatile uint32_t *)((0x415b7  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_056                         (0x415b8)
#define P_EMMC_B_GPONG_056                         (volatile uint32_t *)((0x415b8  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_057                         (0x415b9)
#define P_EMMC_B_GPONG_057                         (volatile uint32_t *)((0x415b9  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_058                         (0x415ba)
#define P_EMMC_B_GPONG_058                         (volatile uint32_t *)((0x415ba  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_059                         (0x415bb)
#define P_EMMC_B_GPONG_059                         (volatile uint32_t *)((0x415bb  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_060                         (0x415bc)
#define P_EMMC_B_GPONG_060                         (volatile uint32_t *)((0x415bc  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_061                         (0x415bd)
#define P_EMMC_B_GPONG_061                         (volatile uint32_t *)((0x415bd  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_062                         (0x415be)
#define P_EMMC_B_GPONG_062                         (volatile uint32_t *)((0x415be  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_063                         (0x415bf)
#define P_EMMC_B_GPONG_063                         (volatile uint32_t *)((0x415bf  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_064                         (0x415c0)
#define P_EMMC_B_GPONG_064                         (volatile uint32_t *)((0x415c0  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_065                         (0x415c1)
#define P_EMMC_B_GPONG_065                         (volatile uint32_t *)((0x415c1  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_066                         (0x415c2)
#define P_EMMC_B_GPONG_066                         (volatile uint32_t *)((0x415c2  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_067                         (0x415c3)
#define P_EMMC_B_GPONG_067                         (volatile uint32_t *)((0x415c3  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_068                         (0x415c4)
#define P_EMMC_B_GPONG_068                         (volatile uint32_t *)((0x415c4  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_069                         (0x415c5)
#define P_EMMC_B_GPONG_069                         (volatile uint32_t *)((0x415c5  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_070                         (0x415c6)
#define P_EMMC_B_GPONG_070                         (volatile uint32_t *)((0x415c6  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_071                         (0x415c7)
#define P_EMMC_B_GPONG_071                         (volatile uint32_t *)((0x415c7  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_072                         (0x415c8)
#define P_EMMC_B_GPONG_072                         (volatile uint32_t *)((0x415c8  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_073                         (0x415c9)
#define P_EMMC_B_GPONG_073                         (volatile uint32_t *)((0x415c9  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_074                         (0x415ca)
#define P_EMMC_B_GPONG_074                         (volatile uint32_t *)((0x415ca  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_075                         (0x415cb)
#define P_EMMC_B_GPONG_075                         (volatile uint32_t *)((0x415cb  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_076                         (0x415cc)
#define P_EMMC_B_GPONG_076                         (volatile uint32_t *)((0x415cc  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_077                         (0x415cd)
#define P_EMMC_B_GPONG_077                         (volatile uint32_t *)((0x415cd  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_078                         (0x415ce)
#define P_EMMC_B_GPONG_078                         (volatile uint32_t *)((0x415ce  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_079                         (0x415cf)
#define P_EMMC_B_GPONG_079                         (volatile uint32_t *)((0x415cf  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_080                         (0x415d0)
#define P_EMMC_B_GPONG_080                         (volatile uint32_t *)((0x415d0  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_081                         (0x415d1)
#define P_EMMC_B_GPONG_081                         (volatile uint32_t *)((0x415d1  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_082                         (0x415d2)
#define P_EMMC_B_GPONG_082                         (volatile uint32_t *)((0x415d2  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_083                         (0x415d3)
#define P_EMMC_B_GPONG_083                         (volatile uint32_t *)((0x415d3  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_084                         (0x415d4)
#define P_EMMC_B_GPONG_084                         (volatile uint32_t *)((0x415d4  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_085                         (0x415d5)
#define P_EMMC_B_GPONG_085                         (volatile uint32_t *)((0x415d5  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_086                         (0x415d6)
#define P_EMMC_B_GPONG_086                         (volatile uint32_t *)((0x415d6  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_087                         (0x415d7)
#define P_EMMC_B_GPONG_087                         (volatile uint32_t *)((0x415d7  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_088                         (0x415d8)
#define P_EMMC_B_GPONG_088                         (volatile uint32_t *)((0x415d8  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_089                         (0x415d9)
#define P_EMMC_B_GPONG_089                         (volatile uint32_t *)((0x415d9  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_090                         (0x415da)
#define P_EMMC_B_GPONG_090                         (volatile uint32_t *)((0x415da  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_091                         (0x415db)
#define P_EMMC_B_GPONG_091                         (volatile uint32_t *)((0x415db  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_092                         (0x415dc)
#define P_EMMC_B_GPONG_092                         (volatile uint32_t *)((0x415dc  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_093                         (0x415dd)
#define P_EMMC_B_GPONG_093                         (volatile uint32_t *)((0x415dd  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_094                         (0x415de)
#define P_EMMC_B_GPONG_094                         (volatile uint32_t *)((0x415de  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_095                         (0x415df)
#define P_EMMC_B_GPONG_095                         (volatile uint32_t *)((0x415df  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_096                         (0x415e0)
#define P_EMMC_B_GPONG_096                         (volatile uint32_t *)((0x415e0  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_097                         (0x415e1)
#define P_EMMC_B_GPONG_097                         (volatile uint32_t *)((0x415e1  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_098                         (0x415e2)
#define P_EMMC_B_GPONG_098                         (volatile uint32_t *)((0x415e2  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_099                         (0x415e3)
#define P_EMMC_B_GPONG_099                         (volatile uint32_t *)((0x415e3  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_100                         (0x415e4)
#define P_EMMC_B_GPONG_100                         (volatile uint32_t *)((0x415e4  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_101                         (0x415e5)
#define P_EMMC_B_GPONG_101                         (volatile uint32_t *)((0x415e5  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_102                         (0x415e6)
#define P_EMMC_B_GPONG_102                         (volatile uint32_t *)((0x415e6  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_103                         (0x415e7)
#define P_EMMC_B_GPONG_103                         (volatile uint32_t *)((0x415e7  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_104                         (0x415e8)
#define P_EMMC_B_GPONG_104                         (volatile uint32_t *)((0x415e8  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_105                         (0x415e9)
#define P_EMMC_B_GPONG_105                         (volatile uint32_t *)((0x415e9  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_106                         (0x415ea)
#define P_EMMC_B_GPONG_106                         (volatile uint32_t *)((0x415ea  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_107                         (0x415eb)
#define P_EMMC_B_GPONG_107                         (volatile uint32_t *)((0x415eb  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_108                         (0x415ec)
#define P_EMMC_B_GPONG_108                         (volatile uint32_t *)((0x415ec  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_109                         (0x415ed)
#define P_EMMC_B_GPONG_109                         (volatile uint32_t *)((0x415ed  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_110                         (0x415ee)
#define P_EMMC_B_GPONG_110                         (volatile uint32_t *)((0x415ee  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_111                         (0x415ef)
#define P_EMMC_B_GPONG_111                         (volatile uint32_t *)((0x415ef  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_112                         (0x415f0)
#define P_EMMC_B_GPONG_112                         (volatile uint32_t *)((0x415f0  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_113                         (0x415f1)
#define P_EMMC_B_GPONG_113                         (volatile uint32_t *)((0x415f1  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_114                         (0x415f2)
#define P_EMMC_B_GPONG_114                         (volatile uint32_t *)((0x415f2  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_115                         (0x415f3)
#define P_EMMC_B_GPONG_115                         (volatile uint32_t *)((0x415f3  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_116                         (0x415f4)
#define P_EMMC_B_GPONG_116                         (volatile uint32_t *)((0x415f4  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_117                         (0x415f5)
#define P_EMMC_B_GPONG_117                         (volatile uint32_t *)((0x415f5  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_118                         (0x415f6)
#define P_EMMC_B_GPONG_118                         (volatile uint32_t *)((0x415f6  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_119                         (0x415f7)
#define P_EMMC_B_GPONG_119                         (volatile uint32_t *)((0x415f7  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_120                         (0x415f8)
#define P_EMMC_B_GPONG_120                         (volatile uint32_t *)((0x415f8  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_121                         (0x415f9)
#define P_EMMC_B_GPONG_121                         (volatile uint32_t *)((0x415f9  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_122                         (0x415fa)
#define P_EMMC_B_GPONG_122                         (volatile uint32_t *)((0x415fa  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_123                         (0x415fb)
#define P_EMMC_B_GPONG_123                         (volatile uint32_t *)((0x415fb  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_124                         (0x415fc)
#define P_EMMC_B_GPONG_124                         (volatile uint32_t *)((0x415fc  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_125                         (0x415fd)
#define P_EMMC_B_GPONG_125                         (volatile uint32_t *)((0x415fd  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_126                         (0x415fe)
#define P_EMMC_B_GPONG_126                         (volatile uint32_t *)((0x415fe  << 2) + 0xffd00000)
#define   EMMC_B_GPONG_127                         (0x415ff)
#define P_EMMC_B_GPONG_127                         (volatile uint32_t *)((0x415ff  << 2) + 0xffd00000)
// -----------------------------------------------
// CBUS_BASE:  EMMCC_CBUS_BASE = 0x40c
// -----------------------------------------------
#define   EMMC_C_GCLOCK                            (0x40c00)
#define P_EMMC_C_GCLOCK                            (volatile uint32_t *)((0x40c00  << 2) + 0xffd00000)
#define   EMMC_C_GDELAY0                           (0x40c01)
#define P_EMMC_C_GDELAY0                           (volatile uint32_t *)((0x40c01  << 2) + 0xffd00000)
#define   EMMC_C_GDELAY1                           (0x40c02)
#define P_EMMC_C_GDELAY1                           (volatile uint32_t *)((0x40c02  << 2) + 0xffd00000)
#define   EMMC_C_GADJUST                           (0x40c03)
#define P_EMMC_C_GADJUST                           (volatile uint32_t *)((0x40c03  << 2) + 0xffd00000)
#define   EMMC_C_GCALOUT0                          (0x40c04)
#define P_EMMC_C_GCALOUT0                          (volatile uint32_t *)((0x40c04  << 2) + 0xffd00000)
#define   EMMC_C_GCALOUT1                          (0x40c05)
#define P_EMMC_C_GCALOUT1                          (volatile uint32_t *)((0x40c05  << 2) + 0xffd00000)
#define   EMMC_C_GCALOUT2                          (0x40c06)
#define P_EMMC_C_GCALOUT2                          (volatile uint32_t *)((0x40c06  << 2) + 0xffd00000)
#define   EMMC_C_GCALOUT3                          (0x40c07)
#define P_EMMC_C_GCALOUT3                          (volatile uint32_t *)((0x40c07  << 2) + 0xffd00000)
#define   EMMC_C_GADJ_LOG                          (0x40c08)
#define P_EMMC_C_GADJ_LOG                          (volatile uint32_t *)((0x40c08  << 2) + 0xffd00000)
#define   EMMC_C_GCLKTEST_LOG                      (0x40c09)
#define P_EMMC_C_GCLKTEST_LOG                      (volatile uint32_t *)((0x40c09  << 2) + 0xffd00000)
#define   EMMC_C_GCLKTEST_OUT                      (0x40c0a)
#define P_EMMC_C_GCLKTEST_OUT                      (volatile uint32_t *)((0x40c0a  << 2) + 0xffd00000)
#define   EMMC_C_GEYETEST_LOG                      (0x40c0b)
#define P_EMMC_C_GEYETEST_LOG                      (volatile uint32_t *)((0x40c0b  << 2) + 0xffd00000)
#define   EMMC_C_GEYETEST_OUT0                     (0x40c0c)
#define P_EMMC_C_GEYETEST_OUT0                     (volatile uint32_t *)((0x40c0c  << 2) + 0xffd00000)
#define   EMMC_C_GEYETEST_OUT1                     (0x40c0d)
#define P_EMMC_C_GEYETEST_OUT1                     (volatile uint32_t *)((0x40c0d  << 2) + 0xffd00000)
#define   EMMC_C_GINTF3                            (0x40c0e)
#define P_EMMC_C_GINTF3                            (volatile uint32_t *)((0x40c0e  << 2) + 0xffd00000)
#define   EMMC_C_GRESERVE                          (0x40c0f)
#define P_EMMC_C_GRESERVE                          (volatile uint32_t *)((0x40c0f  << 2) + 0xffd00000)
#define   EMMC_C_GSTART                            (0x40c10)
#define P_EMMC_C_GSTART                            (volatile uint32_t *)((0x40c10  << 2) + 0xffd00000)
#define   EMMC_C_GCFG                              (0x40c11)
#define P_EMMC_C_GCFG                              (volatile uint32_t *)((0x40c11  << 2) + 0xffd00000)
#define   EMMC_C_GSTATUS                           (0x40c12)
#define P_EMMC_C_GSTATUS                           (volatile uint32_t *)((0x40c12  << 2) + 0xffd00000)
#define   EMMC_C_GIRQ_EN                           (0x40c13)
#define P_EMMC_C_GIRQ_EN                           (volatile uint32_t *)((0x40c13  << 2) + 0xffd00000)
#define   EMMC_C_GCMD_CFG                          (0x40c14)
#define P_EMMC_C_GCMD_CFG                          (volatile uint32_t *)((0x40c14  << 2) + 0xffd00000)
#define   EMMC_C_GCMD_ARG                          (0x40c15)
#define P_EMMC_C_GCMD_ARG                          (volatile uint32_t *)((0x40c15  << 2) + 0xffd00000)
#define   EMMC_C_GCMD_DAT                          (0x40c16)
#define P_EMMC_C_GCMD_DAT                          (volatile uint32_t *)((0x40c16  << 2) + 0xffd00000)
#define   EMMC_C_GCMD_RSP                          (0x40c17)
#define P_EMMC_C_GCMD_RSP                          (volatile uint32_t *)((0x40c17  << 2) + 0xffd00000)
#define   EMMC_C_GCMD_RSP1                         (0x40c18)
#define P_EMMC_C_GCMD_RSP1                         (volatile uint32_t *)((0x40c18  << 2) + 0xffd00000)
#define   EMMC_C_GCMD_RSP2                         (0x40c19)
#define P_EMMC_C_GCMD_RSP2                         (volatile uint32_t *)((0x40c19  << 2) + 0xffd00000)
#define   EMMC_C_GCMD_RSP3                         (0x40c1a)
#define P_EMMC_C_GCMD_RSP3                         (volatile uint32_t *)((0x40c1a  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_6C                       (0x40c1b)
#define P_EMMC_C_RESERVED_6C                       (volatile uint32_t *)((0x40c1b  << 2) + 0xffd00000)
#define   EMMC_C_GCURR_CFG                         (0x40c1c)
#define P_EMMC_C_GCURR_CFG                         (volatile uint32_t *)((0x40c1c  << 2) + 0xffd00000)
#define   EMMC_C_GCURR_ARG                         (0x40c1d)
#define P_EMMC_C_GCURR_ARG                         (volatile uint32_t *)((0x40c1d  << 2) + 0xffd00000)
#define   EMMC_C_GCURR_DAT                         (0x40c1e)
#define P_EMMC_C_GCURR_DAT                         (volatile uint32_t *)((0x40c1e  << 2) + 0xffd00000)
#define   EMMC_C_GCURR_RSP                         (0x40c1f)
#define P_EMMC_C_GCURR_RSP                         (volatile uint32_t *)((0x40c1f  << 2) + 0xffd00000)
#define   EMMC_C_GNEXT_CFG                         (0x40c20)
#define P_EMMC_C_GNEXT_CFG                         (volatile uint32_t *)((0x40c20  << 2) + 0xffd00000)
#define   EMMC_C_GNEXT_ARG                         (0x40c21)
#define P_EMMC_C_GNEXT_ARG                         (volatile uint32_t *)((0x40c21  << 2) + 0xffd00000)
#define   EMMC_C_GNEXT_DAT                         (0x40c22)
#define P_EMMC_C_GNEXT_DAT                         (volatile uint32_t *)((0x40c22  << 2) + 0xffd00000)
#define   EMMC_C_GNEXT_RSP                         (0x40c23)
#define P_EMMC_C_GNEXT_RSP                         (volatile uint32_t *)((0x40c23  << 2) + 0xffd00000)
#define   EMMC_C_GRXD                              (0x40c24)
#define P_EMMC_C_GRXD                              (volatile uint32_t *)((0x40c24  << 2) + 0xffd00000)
#define   EMMC_C_GTXD                              (0x40c25)
#define P_EMMC_C_GTXD                              (volatile uint32_t *)((0x40c25  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_00                    (0x40c26)
#define P_EMMC_C_RESERVED_98_00                    (volatile uint32_t *)((0x40c26  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_01                    (0x40c27)
#define P_EMMC_C_RESERVED_98_01                    (volatile uint32_t *)((0x40c27  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_02                    (0x40c28)
#define P_EMMC_C_RESERVED_98_02                    (volatile uint32_t *)((0x40c28  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_03                    (0x40c29)
#define P_EMMC_C_RESERVED_98_03                    (volatile uint32_t *)((0x40c29  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_04                    (0x40c2a)
#define P_EMMC_C_RESERVED_98_04                    (volatile uint32_t *)((0x40c2a  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_05                    (0x40c2b)
#define P_EMMC_C_RESERVED_98_05                    (volatile uint32_t *)((0x40c2b  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_06                    (0x40c2c)
#define P_EMMC_C_RESERVED_98_06                    (volatile uint32_t *)((0x40c2c  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_07                    (0x40c2d)
#define P_EMMC_C_RESERVED_98_07                    (volatile uint32_t *)((0x40c2d  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_08                    (0x40c2e)
#define P_EMMC_C_RESERVED_98_08                    (volatile uint32_t *)((0x40c2e  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_09                    (0x40c2f)
#define P_EMMC_C_RESERVED_98_09                    (volatile uint32_t *)((0x40c2f  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_10                    (0x40c30)
#define P_EMMC_C_RESERVED_98_10                    (volatile uint32_t *)((0x40c30  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_11                    (0x40c31)
#define P_EMMC_C_RESERVED_98_11                    (volatile uint32_t *)((0x40c31  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_12                    (0x40c32)
#define P_EMMC_C_RESERVED_98_12                    (volatile uint32_t *)((0x40c32  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_13                    (0x40c33)
#define P_EMMC_C_RESERVED_98_13                    (volatile uint32_t *)((0x40c33  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_14                    (0x40c34)
#define P_EMMC_C_RESERVED_98_14                    (volatile uint32_t *)((0x40c34  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_15                    (0x40c35)
#define P_EMMC_C_RESERVED_98_15                    (volatile uint32_t *)((0x40c35  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_16                    (0x40c36)
#define P_EMMC_C_RESERVED_98_16                    (volatile uint32_t *)((0x40c36  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_17                    (0x40c37)
#define P_EMMC_C_RESERVED_98_17                    (volatile uint32_t *)((0x40c37  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_18                    (0x40c38)
#define P_EMMC_C_RESERVED_98_18                    (volatile uint32_t *)((0x40c38  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_19                    (0x40c39)
#define P_EMMC_C_RESERVED_98_19                    (volatile uint32_t *)((0x40c39  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_20                    (0x40c3a)
#define P_EMMC_C_RESERVED_98_20                    (volatile uint32_t *)((0x40c3a  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_21                    (0x40c3b)
#define P_EMMC_C_RESERVED_98_21                    (volatile uint32_t *)((0x40c3b  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_22                    (0x40c3c)
#define P_EMMC_C_RESERVED_98_22                    (volatile uint32_t *)((0x40c3c  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_23                    (0x40c3d)
#define P_EMMC_C_RESERVED_98_23                    (volatile uint32_t *)((0x40c3d  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_24                    (0x40c3e)
#define P_EMMC_C_RESERVED_98_24                    (volatile uint32_t *)((0x40c3e  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_25                    (0x40c3f)
#define P_EMMC_C_RESERVED_98_25                    (volatile uint32_t *)((0x40c3f  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_26                    (0x40c40)
#define P_EMMC_C_RESERVED_98_26                    (volatile uint32_t *)((0x40c40  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_27                    (0x40c41)
#define P_EMMC_C_RESERVED_98_27                    (volatile uint32_t *)((0x40c41  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_28                    (0x40c42)
#define P_EMMC_C_RESERVED_98_28                    (volatile uint32_t *)((0x40c42  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_29                    (0x40c43)
#define P_EMMC_C_RESERVED_98_29                    (volatile uint32_t *)((0x40c43  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_30                    (0x40c44)
#define P_EMMC_C_RESERVED_98_30                    (volatile uint32_t *)((0x40c44  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_31                    (0x40c45)
#define P_EMMC_C_RESERVED_98_31                    (volatile uint32_t *)((0x40c45  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_32                    (0x40c46)
#define P_EMMC_C_RESERVED_98_32                    (volatile uint32_t *)((0x40c46  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_33                    (0x40c47)
#define P_EMMC_C_RESERVED_98_33                    (volatile uint32_t *)((0x40c47  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_34                    (0x40c48)
#define P_EMMC_C_RESERVED_98_34                    (volatile uint32_t *)((0x40c48  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_35                    (0x40c49)
#define P_EMMC_C_RESERVED_98_35                    (volatile uint32_t *)((0x40c49  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_36                    (0x40c4a)
#define P_EMMC_C_RESERVED_98_36                    (volatile uint32_t *)((0x40c4a  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_37                    (0x40c4b)
#define P_EMMC_C_RESERVED_98_37                    (volatile uint32_t *)((0x40c4b  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_38                    (0x40c4c)
#define P_EMMC_C_RESERVED_98_38                    (volatile uint32_t *)((0x40c4c  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_39                    (0x40c4d)
#define P_EMMC_C_RESERVED_98_39                    (volatile uint32_t *)((0x40c4d  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_40                    (0x40c4e)
#define P_EMMC_C_RESERVED_98_40                    (volatile uint32_t *)((0x40c4e  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_41                    (0x40c4f)
#define P_EMMC_C_RESERVED_98_41                    (volatile uint32_t *)((0x40c4f  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_42                    (0x40c50)
#define P_EMMC_C_RESERVED_98_42                    (volatile uint32_t *)((0x40c50  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_43                    (0x40c51)
#define P_EMMC_C_RESERVED_98_43                    (volatile uint32_t *)((0x40c51  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_44                    (0x40c52)
#define P_EMMC_C_RESERVED_98_44                    (volatile uint32_t *)((0x40c52  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_45                    (0x40c53)
#define P_EMMC_C_RESERVED_98_45                    (volatile uint32_t *)((0x40c53  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_46                    (0x40c54)
#define P_EMMC_C_RESERVED_98_46                    (volatile uint32_t *)((0x40c54  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_47                    (0x40c55)
#define P_EMMC_C_RESERVED_98_47                    (volatile uint32_t *)((0x40c55  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_48                    (0x40c56)
#define P_EMMC_C_RESERVED_98_48                    (volatile uint32_t *)((0x40c56  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_49                    (0x40c57)
#define P_EMMC_C_RESERVED_98_49                    (volatile uint32_t *)((0x40c57  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_50                    (0x40c58)
#define P_EMMC_C_RESERVED_98_50                    (volatile uint32_t *)((0x40c58  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_51                    (0x40c59)
#define P_EMMC_C_RESERVED_98_51                    (volatile uint32_t *)((0x40c59  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_52                    (0x40c5a)
#define P_EMMC_C_RESERVED_98_52                    (volatile uint32_t *)((0x40c5a  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_53                    (0x40c5b)
#define P_EMMC_C_RESERVED_98_53                    (volatile uint32_t *)((0x40c5b  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_54                    (0x40c5c)
#define P_EMMC_C_RESERVED_98_54                    (volatile uint32_t *)((0x40c5c  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_55                    (0x40c5d)
#define P_EMMC_C_RESERVED_98_55                    (volatile uint32_t *)((0x40c5d  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_56                    (0x40c5e)
#define P_EMMC_C_RESERVED_98_56                    (volatile uint32_t *)((0x40c5e  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_57                    (0x40c5f)
#define P_EMMC_C_RESERVED_98_57                    (volatile uint32_t *)((0x40c5f  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_58                    (0x40c60)
#define P_EMMC_C_RESERVED_98_58                    (volatile uint32_t *)((0x40c60  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_59                    (0x40c61)
#define P_EMMC_C_RESERVED_98_59                    (volatile uint32_t *)((0x40c61  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_60                    (0x40c62)
#define P_EMMC_C_RESERVED_98_60                    (volatile uint32_t *)((0x40c62  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_61                    (0x40c63)
#define P_EMMC_C_RESERVED_98_61                    (volatile uint32_t *)((0x40c63  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_62                    (0x40c64)
#define P_EMMC_C_RESERVED_98_62                    (volatile uint32_t *)((0x40c64  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_63                    (0x40c65)
#define P_EMMC_C_RESERVED_98_63                    (volatile uint32_t *)((0x40c65  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_64                    (0x40c66)
#define P_EMMC_C_RESERVED_98_64                    (volatile uint32_t *)((0x40c66  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_65                    (0x40c67)
#define P_EMMC_C_RESERVED_98_65                    (volatile uint32_t *)((0x40c67  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_66                    (0x40c68)
#define P_EMMC_C_RESERVED_98_66                    (volatile uint32_t *)((0x40c68  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_67                    (0x40c69)
#define P_EMMC_C_RESERVED_98_67                    (volatile uint32_t *)((0x40c69  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_68                    (0x40c6a)
#define P_EMMC_C_RESERVED_98_68                    (volatile uint32_t *)((0x40c6a  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_69                    (0x40c6b)
#define P_EMMC_C_RESERVED_98_69                    (volatile uint32_t *)((0x40c6b  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_70                    (0x40c6c)
#define P_EMMC_C_RESERVED_98_70                    (volatile uint32_t *)((0x40c6c  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_71                    (0x40c6d)
#define P_EMMC_C_RESERVED_98_71                    (volatile uint32_t *)((0x40c6d  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_72                    (0x40c6e)
#define P_EMMC_C_RESERVED_98_72                    (volatile uint32_t *)((0x40c6e  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_73                    (0x40c6f)
#define P_EMMC_C_RESERVED_98_73                    (volatile uint32_t *)((0x40c6f  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_74                    (0x40c70)
#define P_EMMC_C_RESERVED_98_74                    (volatile uint32_t *)((0x40c70  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_75                    (0x40c71)
#define P_EMMC_C_RESERVED_98_75                    (volatile uint32_t *)((0x40c71  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_76                    (0x40c72)
#define P_EMMC_C_RESERVED_98_76                    (volatile uint32_t *)((0x40c72  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_77                    (0x40c73)
#define P_EMMC_C_RESERVED_98_77                    (volatile uint32_t *)((0x40c73  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_78                    (0x40c74)
#define P_EMMC_C_RESERVED_98_78                    (volatile uint32_t *)((0x40c74  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_79                    (0x40c75)
#define P_EMMC_C_RESERVED_98_79                    (volatile uint32_t *)((0x40c75  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_80                    (0x40c76)
#define P_EMMC_C_RESERVED_98_80                    (volatile uint32_t *)((0x40c76  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_81                    (0x40c77)
#define P_EMMC_C_RESERVED_98_81                    (volatile uint32_t *)((0x40c77  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_82                    (0x40c78)
#define P_EMMC_C_RESERVED_98_82                    (volatile uint32_t *)((0x40c78  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_83                    (0x40c79)
#define P_EMMC_C_RESERVED_98_83                    (volatile uint32_t *)((0x40c79  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_84                    (0x40c7a)
#define P_EMMC_C_RESERVED_98_84                    (volatile uint32_t *)((0x40c7a  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_85                    (0x40c7b)
#define P_EMMC_C_RESERVED_98_85                    (volatile uint32_t *)((0x40c7b  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_86                    (0x40c7c)
#define P_EMMC_C_RESERVED_98_86                    (volatile uint32_t *)((0x40c7c  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_87                    (0x40c7d)
#define P_EMMC_C_RESERVED_98_87                    (volatile uint32_t *)((0x40c7d  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_88                    (0x40c7e)
#define P_EMMC_C_RESERVED_98_88                    (volatile uint32_t *)((0x40c7e  << 2) + 0xffd00000)
#define   EMMC_C_RESERVED_98_89                    (0x40c7f)
#define P_EMMC_C_RESERVED_98_89                    (volatile uint32_t *)((0x40c7f  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_000                         (0x40c80)
#define P_EMMC_C_GDESC_000                         (volatile uint32_t *)((0x40c80  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_001                         (0x40c81)
#define P_EMMC_C_GDESC_001                         (volatile uint32_t *)((0x40c81  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_002                         (0x40c82)
#define P_EMMC_C_GDESC_002                         (volatile uint32_t *)((0x40c82  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_003                         (0x40c83)
#define P_EMMC_C_GDESC_003                         (volatile uint32_t *)((0x40c83  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_004                         (0x40c84)
#define P_EMMC_C_GDESC_004                         (volatile uint32_t *)((0x40c84  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_005                         (0x40c85)
#define P_EMMC_C_GDESC_005                         (volatile uint32_t *)((0x40c85  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_006                         (0x40c86)
#define P_EMMC_C_GDESC_006                         (volatile uint32_t *)((0x40c86  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_007                         (0x40c87)
#define P_EMMC_C_GDESC_007                         (volatile uint32_t *)((0x40c87  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_008                         (0x40c88)
#define P_EMMC_C_GDESC_008                         (volatile uint32_t *)((0x40c88  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_009                         (0x40c89)
#define P_EMMC_C_GDESC_009                         (volatile uint32_t *)((0x40c89  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_010                         (0x40c8a)
#define P_EMMC_C_GDESC_010                         (volatile uint32_t *)((0x40c8a  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_011                         (0x40c8b)
#define P_EMMC_C_GDESC_011                         (volatile uint32_t *)((0x40c8b  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_012                         (0x40c8c)
#define P_EMMC_C_GDESC_012                         (volatile uint32_t *)((0x40c8c  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_013                         (0x40c8d)
#define P_EMMC_C_GDESC_013                         (volatile uint32_t *)((0x40c8d  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_014                         (0x40c8e)
#define P_EMMC_C_GDESC_014                         (volatile uint32_t *)((0x40c8e  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_015                         (0x40c8f)
#define P_EMMC_C_GDESC_015                         (volatile uint32_t *)((0x40c8f  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_016                         (0x40c90)
#define P_EMMC_C_GDESC_016                         (volatile uint32_t *)((0x40c90  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_017                         (0x40c91)
#define P_EMMC_C_GDESC_017                         (volatile uint32_t *)((0x40c91  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_018                         (0x40c92)
#define P_EMMC_C_GDESC_018                         (volatile uint32_t *)((0x40c92  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_019                         (0x40c93)
#define P_EMMC_C_GDESC_019                         (volatile uint32_t *)((0x40c93  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_020                         (0x40c94)
#define P_EMMC_C_GDESC_020                         (volatile uint32_t *)((0x40c94  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_021                         (0x40c95)
#define P_EMMC_C_GDESC_021                         (volatile uint32_t *)((0x40c95  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_022                         (0x40c96)
#define P_EMMC_C_GDESC_022                         (volatile uint32_t *)((0x40c96  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_023                         (0x40c97)
#define P_EMMC_C_GDESC_023                         (volatile uint32_t *)((0x40c97  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_024                         (0x40c98)
#define P_EMMC_C_GDESC_024                         (volatile uint32_t *)((0x40c98  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_025                         (0x40c99)
#define P_EMMC_C_GDESC_025                         (volatile uint32_t *)((0x40c99  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_026                         (0x40c9a)
#define P_EMMC_C_GDESC_026                         (volatile uint32_t *)((0x40c9a  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_027                         (0x40c9b)
#define P_EMMC_C_GDESC_027                         (volatile uint32_t *)((0x40c9b  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_028                         (0x40c9c)
#define P_EMMC_C_GDESC_028                         (volatile uint32_t *)((0x40c9c  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_029                         (0x40c9d)
#define P_EMMC_C_GDESC_029                         (volatile uint32_t *)((0x40c9d  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_030                         (0x40c9e)
#define P_EMMC_C_GDESC_030                         (volatile uint32_t *)((0x40c9e  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_031                         (0x40c9f)
#define P_EMMC_C_GDESC_031                         (volatile uint32_t *)((0x40c9f  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_032                         (0x40ca0)
#define P_EMMC_C_GDESC_032                         (volatile uint32_t *)((0x40ca0  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_033                         (0x40ca1)
#define P_EMMC_C_GDESC_033                         (volatile uint32_t *)((0x40ca1  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_034                         (0x40ca2)
#define P_EMMC_C_GDESC_034                         (volatile uint32_t *)((0x40ca2  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_035                         (0x40ca3)
#define P_EMMC_C_GDESC_035                         (volatile uint32_t *)((0x40ca3  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_036                         (0x40ca4)
#define P_EMMC_C_GDESC_036                         (volatile uint32_t *)((0x40ca4  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_037                         (0x40ca5)
#define P_EMMC_C_GDESC_037                         (volatile uint32_t *)((0x40ca5  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_038                         (0x40ca6)
#define P_EMMC_C_GDESC_038                         (volatile uint32_t *)((0x40ca6  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_039                         (0x40ca7)
#define P_EMMC_C_GDESC_039                         (volatile uint32_t *)((0x40ca7  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_040                         (0x40ca8)
#define P_EMMC_C_GDESC_040                         (volatile uint32_t *)((0x40ca8  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_041                         (0x40ca9)
#define P_EMMC_C_GDESC_041                         (volatile uint32_t *)((0x40ca9  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_042                         (0x40caa)
#define P_EMMC_C_GDESC_042                         (volatile uint32_t *)((0x40caa  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_043                         (0x40cab)
#define P_EMMC_C_GDESC_043                         (volatile uint32_t *)((0x40cab  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_044                         (0x40cac)
#define P_EMMC_C_GDESC_044                         (volatile uint32_t *)((0x40cac  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_045                         (0x40cad)
#define P_EMMC_C_GDESC_045                         (volatile uint32_t *)((0x40cad  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_046                         (0x40cae)
#define P_EMMC_C_GDESC_046                         (volatile uint32_t *)((0x40cae  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_047                         (0x40caf)
#define P_EMMC_C_GDESC_047                         (volatile uint32_t *)((0x40caf  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_048                         (0x40cb0)
#define P_EMMC_C_GDESC_048                         (volatile uint32_t *)((0x40cb0  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_049                         (0x40cb1)
#define P_EMMC_C_GDESC_049                         (volatile uint32_t *)((0x40cb1  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_050                         (0x40cb2)
#define P_EMMC_C_GDESC_050                         (volatile uint32_t *)((0x40cb2  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_051                         (0x40cb3)
#define P_EMMC_C_GDESC_051                         (volatile uint32_t *)((0x40cb3  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_052                         (0x40cb4)
#define P_EMMC_C_GDESC_052                         (volatile uint32_t *)((0x40cb4  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_053                         (0x40cb5)
#define P_EMMC_C_GDESC_053                         (volatile uint32_t *)((0x40cb5  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_054                         (0x40cb6)
#define P_EMMC_C_GDESC_054                         (volatile uint32_t *)((0x40cb6  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_055                         (0x40cb7)
#define P_EMMC_C_GDESC_055                         (volatile uint32_t *)((0x40cb7  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_056                         (0x40cb8)
#define P_EMMC_C_GDESC_056                         (volatile uint32_t *)((0x40cb8  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_057                         (0x40cb9)
#define P_EMMC_C_GDESC_057                         (volatile uint32_t *)((0x40cb9  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_058                         (0x40cba)
#define P_EMMC_C_GDESC_058                         (volatile uint32_t *)((0x40cba  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_059                         (0x40cbb)
#define P_EMMC_C_GDESC_059                         (volatile uint32_t *)((0x40cbb  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_060                         (0x40cbc)
#define P_EMMC_C_GDESC_060                         (volatile uint32_t *)((0x40cbc  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_061                         (0x40cbd)
#define P_EMMC_C_GDESC_061                         (volatile uint32_t *)((0x40cbd  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_062                         (0x40cbe)
#define P_EMMC_C_GDESC_062                         (volatile uint32_t *)((0x40cbe  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_063                         (0x40cbf)
#define P_EMMC_C_GDESC_063                         (volatile uint32_t *)((0x40cbf  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_064                         (0x40cc0)
#define P_EMMC_C_GDESC_064                         (volatile uint32_t *)((0x40cc0  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_065                         (0x40cc1)
#define P_EMMC_C_GDESC_065                         (volatile uint32_t *)((0x40cc1  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_066                         (0x40cc2)
#define P_EMMC_C_GDESC_066                         (volatile uint32_t *)((0x40cc2  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_067                         (0x40cc3)
#define P_EMMC_C_GDESC_067                         (volatile uint32_t *)((0x40cc3  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_068                         (0x40cc4)
#define P_EMMC_C_GDESC_068                         (volatile uint32_t *)((0x40cc4  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_069                         (0x40cc5)
#define P_EMMC_C_GDESC_069                         (volatile uint32_t *)((0x40cc5  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_070                         (0x40cc6)
#define P_EMMC_C_GDESC_070                         (volatile uint32_t *)((0x40cc6  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_071                         (0x40cc7)
#define P_EMMC_C_GDESC_071                         (volatile uint32_t *)((0x40cc7  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_072                         (0x40cc8)
#define P_EMMC_C_GDESC_072                         (volatile uint32_t *)((0x40cc8  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_073                         (0x40cc9)
#define P_EMMC_C_GDESC_073                         (volatile uint32_t *)((0x40cc9  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_074                         (0x40cca)
#define P_EMMC_C_GDESC_074                         (volatile uint32_t *)((0x40cca  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_075                         (0x40ccb)
#define P_EMMC_C_GDESC_075                         (volatile uint32_t *)((0x40ccb  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_076                         (0x40ccc)
#define P_EMMC_C_GDESC_076                         (volatile uint32_t *)((0x40ccc  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_077                         (0x40ccd)
#define P_EMMC_C_GDESC_077                         (volatile uint32_t *)((0x40ccd  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_078                         (0x40cce)
#define P_EMMC_C_GDESC_078                         (volatile uint32_t *)((0x40cce  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_079                         (0x40ccf)
#define P_EMMC_C_GDESC_079                         (volatile uint32_t *)((0x40ccf  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_080                         (0x40cd0)
#define P_EMMC_C_GDESC_080                         (volatile uint32_t *)((0x40cd0  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_081                         (0x40cd1)
#define P_EMMC_C_GDESC_081                         (volatile uint32_t *)((0x40cd1  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_082                         (0x40cd2)
#define P_EMMC_C_GDESC_082                         (volatile uint32_t *)((0x40cd2  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_083                         (0x40cd3)
#define P_EMMC_C_GDESC_083                         (volatile uint32_t *)((0x40cd3  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_084                         (0x40cd4)
#define P_EMMC_C_GDESC_084                         (volatile uint32_t *)((0x40cd4  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_085                         (0x40cd5)
#define P_EMMC_C_GDESC_085                         (volatile uint32_t *)((0x40cd5  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_086                         (0x40cd6)
#define P_EMMC_C_GDESC_086                         (volatile uint32_t *)((0x40cd6  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_087                         (0x40cd7)
#define P_EMMC_C_GDESC_087                         (volatile uint32_t *)((0x40cd7  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_088                         (0x40cd8)
#define P_EMMC_C_GDESC_088                         (volatile uint32_t *)((0x40cd8  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_089                         (0x40cd9)
#define P_EMMC_C_GDESC_089                         (volatile uint32_t *)((0x40cd9  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_090                         (0x40cda)
#define P_EMMC_C_GDESC_090                         (volatile uint32_t *)((0x40cda  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_091                         (0x40cdb)
#define P_EMMC_C_GDESC_091                         (volatile uint32_t *)((0x40cdb  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_092                         (0x40cdc)
#define P_EMMC_C_GDESC_092                         (volatile uint32_t *)((0x40cdc  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_093                         (0x40cdd)
#define P_EMMC_C_GDESC_093                         (volatile uint32_t *)((0x40cdd  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_094                         (0x40cde)
#define P_EMMC_C_GDESC_094                         (volatile uint32_t *)((0x40cde  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_095                         (0x40cdf)
#define P_EMMC_C_GDESC_095                         (volatile uint32_t *)((0x40cdf  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_096                         (0x40ce0)
#define P_EMMC_C_GDESC_096                         (volatile uint32_t *)((0x40ce0  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_097                         (0x40ce1)
#define P_EMMC_C_GDESC_097                         (volatile uint32_t *)((0x40ce1  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_098                         (0x40ce2)
#define P_EMMC_C_GDESC_098                         (volatile uint32_t *)((0x40ce2  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_099                         (0x40ce3)
#define P_EMMC_C_GDESC_099                         (volatile uint32_t *)((0x40ce3  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_100                         (0x40ce4)
#define P_EMMC_C_GDESC_100                         (volatile uint32_t *)((0x40ce4  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_101                         (0x40ce5)
#define P_EMMC_C_GDESC_101                         (volatile uint32_t *)((0x40ce5  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_102                         (0x40ce6)
#define P_EMMC_C_GDESC_102                         (volatile uint32_t *)((0x40ce6  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_103                         (0x40ce7)
#define P_EMMC_C_GDESC_103                         (volatile uint32_t *)((0x40ce7  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_104                         (0x40ce8)
#define P_EMMC_C_GDESC_104                         (volatile uint32_t *)((0x40ce8  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_105                         (0x40ce9)
#define P_EMMC_C_GDESC_105                         (volatile uint32_t *)((0x40ce9  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_106                         (0x40cea)
#define P_EMMC_C_GDESC_106                         (volatile uint32_t *)((0x40cea  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_107                         (0x40ceb)
#define P_EMMC_C_GDESC_107                         (volatile uint32_t *)((0x40ceb  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_108                         (0x40cec)
#define P_EMMC_C_GDESC_108                         (volatile uint32_t *)((0x40cec  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_109                         (0x40ced)
#define P_EMMC_C_GDESC_109                         (volatile uint32_t *)((0x40ced  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_110                         (0x40cee)
#define P_EMMC_C_GDESC_110                         (volatile uint32_t *)((0x40cee  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_111                         (0x40cef)
#define P_EMMC_C_GDESC_111                         (volatile uint32_t *)((0x40cef  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_112                         (0x40cf0)
#define P_EMMC_C_GDESC_112                         (volatile uint32_t *)((0x40cf0  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_113                         (0x40cf1)
#define P_EMMC_C_GDESC_113                         (volatile uint32_t *)((0x40cf1  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_114                         (0x40cf2)
#define P_EMMC_C_GDESC_114                         (volatile uint32_t *)((0x40cf2  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_115                         (0x40cf3)
#define P_EMMC_C_GDESC_115                         (volatile uint32_t *)((0x40cf3  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_116                         (0x40cf4)
#define P_EMMC_C_GDESC_116                         (volatile uint32_t *)((0x40cf4  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_117                         (0x40cf5)
#define P_EMMC_C_GDESC_117                         (volatile uint32_t *)((0x40cf5  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_118                         (0x40cf6)
#define P_EMMC_C_GDESC_118                         (volatile uint32_t *)((0x40cf6  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_119                         (0x40cf7)
#define P_EMMC_C_GDESC_119                         (volatile uint32_t *)((0x40cf7  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_120                         (0x40cf8)
#define P_EMMC_C_GDESC_120                         (volatile uint32_t *)((0x40cf8  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_121                         (0x40cf9)
#define P_EMMC_C_GDESC_121                         (volatile uint32_t *)((0x40cf9  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_122                         (0x40cfa)
#define P_EMMC_C_GDESC_122                         (volatile uint32_t *)((0x40cfa  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_123                         (0x40cfb)
#define P_EMMC_C_GDESC_123                         (volatile uint32_t *)((0x40cfb  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_124                         (0x40cfc)
#define P_EMMC_C_GDESC_124                         (volatile uint32_t *)((0x40cfc  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_125                         (0x40cfd)
#define P_EMMC_C_GDESC_125                         (volatile uint32_t *)((0x40cfd  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_126                         (0x40cfe)
#define P_EMMC_C_GDESC_126                         (volatile uint32_t *)((0x40cfe  << 2) + 0xffd00000)
#define   EMMC_C_GDESC_127                         (0x40cff)
#define P_EMMC_C_GDESC_127                         (volatile uint32_t *)((0x40cff  << 2) + 0xffd00000)
#define   EMMC_C_GPING_000                         (0x40d00)
#define P_EMMC_C_GPING_000                         (volatile uint32_t *)((0x40d00  << 2) + 0xffd00000)
#define   EMMC_C_GPING_001                         (0x40d01)
#define P_EMMC_C_GPING_001                         (volatile uint32_t *)((0x40d01  << 2) + 0xffd00000)
#define   EMMC_C_GPING_002                         (0x40d02)
#define P_EMMC_C_GPING_002                         (volatile uint32_t *)((0x40d02  << 2) + 0xffd00000)
#define   EMMC_C_GPING_003                         (0x40d03)
#define P_EMMC_C_GPING_003                         (volatile uint32_t *)((0x40d03  << 2) + 0xffd00000)
#define   EMMC_C_GPING_004                         (0x40d04)
#define P_EMMC_C_GPING_004                         (volatile uint32_t *)((0x40d04  << 2) + 0xffd00000)
#define   EMMC_C_GPING_005                         (0x40d05)
#define P_EMMC_C_GPING_005                         (volatile uint32_t *)((0x40d05  << 2) + 0xffd00000)
#define   EMMC_C_GPING_006                         (0x40d06)
#define P_EMMC_C_GPING_006                         (volatile uint32_t *)((0x40d06  << 2) + 0xffd00000)
#define   EMMC_C_GPING_007                         (0x40d07)
#define P_EMMC_C_GPING_007                         (volatile uint32_t *)((0x40d07  << 2) + 0xffd00000)
#define   EMMC_C_GPING_008                         (0x40d08)
#define P_EMMC_C_GPING_008                         (volatile uint32_t *)((0x40d08  << 2) + 0xffd00000)
#define   EMMC_C_GPING_009                         (0x40d09)
#define P_EMMC_C_GPING_009                         (volatile uint32_t *)((0x40d09  << 2) + 0xffd00000)
#define   EMMC_C_GPING_010                         (0x40d0a)
#define P_EMMC_C_GPING_010                         (volatile uint32_t *)((0x40d0a  << 2) + 0xffd00000)
#define   EMMC_C_GPING_011                         (0x40d0b)
#define P_EMMC_C_GPING_011                         (volatile uint32_t *)((0x40d0b  << 2) + 0xffd00000)
#define   EMMC_C_GPING_012                         (0x40d0c)
#define P_EMMC_C_GPING_012                         (volatile uint32_t *)((0x40d0c  << 2) + 0xffd00000)
#define   EMMC_C_GPING_013                         (0x40d0d)
#define P_EMMC_C_GPING_013                         (volatile uint32_t *)((0x40d0d  << 2) + 0xffd00000)
#define   EMMC_C_GPING_014                         (0x40d0e)
#define P_EMMC_C_GPING_014                         (volatile uint32_t *)((0x40d0e  << 2) + 0xffd00000)
#define   EMMC_C_GPING_015                         (0x40d0f)
#define P_EMMC_C_GPING_015                         (volatile uint32_t *)((0x40d0f  << 2) + 0xffd00000)
#define   EMMC_C_GPING_016                         (0x40d10)
#define P_EMMC_C_GPING_016                         (volatile uint32_t *)((0x40d10  << 2) + 0xffd00000)
#define   EMMC_C_GPING_017                         (0x40d11)
#define P_EMMC_C_GPING_017                         (volatile uint32_t *)((0x40d11  << 2) + 0xffd00000)
#define   EMMC_C_GPING_018                         (0x40d12)
#define P_EMMC_C_GPING_018                         (volatile uint32_t *)((0x40d12  << 2) + 0xffd00000)
#define   EMMC_C_GPING_019                         (0x40d13)
#define P_EMMC_C_GPING_019                         (volatile uint32_t *)((0x40d13  << 2) + 0xffd00000)
#define   EMMC_C_GPING_020                         (0x40d14)
#define P_EMMC_C_GPING_020                         (volatile uint32_t *)((0x40d14  << 2) + 0xffd00000)
#define   EMMC_C_GPING_021                         (0x40d15)
#define P_EMMC_C_GPING_021                         (volatile uint32_t *)((0x40d15  << 2) + 0xffd00000)
#define   EMMC_C_GPING_022                         (0x40d16)
#define P_EMMC_C_GPING_022                         (volatile uint32_t *)((0x40d16  << 2) + 0xffd00000)
#define   EMMC_C_GPING_023                         (0x40d17)
#define P_EMMC_C_GPING_023                         (volatile uint32_t *)((0x40d17  << 2) + 0xffd00000)
#define   EMMC_C_GPING_024                         (0x40d18)
#define P_EMMC_C_GPING_024                         (volatile uint32_t *)((0x40d18  << 2) + 0xffd00000)
#define   EMMC_C_GPING_025                         (0x40d19)
#define P_EMMC_C_GPING_025                         (volatile uint32_t *)((0x40d19  << 2) + 0xffd00000)
#define   EMMC_C_GPING_026                         (0x40d1a)
#define P_EMMC_C_GPING_026                         (volatile uint32_t *)((0x40d1a  << 2) + 0xffd00000)
#define   EMMC_C_GPING_027                         (0x40d1b)
#define P_EMMC_C_GPING_027                         (volatile uint32_t *)((0x40d1b  << 2) + 0xffd00000)
#define   EMMC_C_GPING_028                         (0x40d1c)
#define P_EMMC_C_GPING_028                         (volatile uint32_t *)((0x40d1c  << 2) + 0xffd00000)
#define   EMMC_C_GPING_029                         (0x40d1d)
#define P_EMMC_C_GPING_029                         (volatile uint32_t *)((0x40d1d  << 2) + 0xffd00000)
#define   EMMC_C_GPING_030                         (0x40d1e)
#define P_EMMC_C_GPING_030                         (volatile uint32_t *)((0x40d1e  << 2) + 0xffd00000)
#define   EMMC_C_GPING_031                         (0x40d1f)
#define P_EMMC_C_GPING_031                         (volatile uint32_t *)((0x40d1f  << 2) + 0xffd00000)
#define   EMMC_C_GPING_032                         (0x40d20)
#define P_EMMC_C_GPING_032                         (volatile uint32_t *)((0x40d20  << 2) + 0xffd00000)
#define   EMMC_C_GPING_033                         (0x40d21)
#define P_EMMC_C_GPING_033                         (volatile uint32_t *)((0x40d21  << 2) + 0xffd00000)
#define   EMMC_C_GPING_034                         (0x40d22)
#define P_EMMC_C_GPING_034                         (volatile uint32_t *)((0x40d22  << 2) + 0xffd00000)
#define   EMMC_C_GPING_035                         (0x40d23)
#define P_EMMC_C_GPING_035                         (volatile uint32_t *)((0x40d23  << 2) + 0xffd00000)
#define   EMMC_C_GPING_036                         (0x40d24)
#define P_EMMC_C_GPING_036                         (volatile uint32_t *)((0x40d24  << 2) + 0xffd00000)
#define   EMMC_C_GPING_037                         (0x40d25)
#define P_EMMC_C_GPING_037                         (volatile uint32_t *)((0x40d25  << 2) + 0xffd00000)
#define   EMMC_C_GPING_038                         (0x40d26)
#define P_EMMC_C_GPING_038                         (volatile uint32_t *)((0x40d26  << 2) + 0xffd00000)
#define   EMMC_C_GPING_039                         (0x40d27)
#define P_EMMC_C_GPING_039                         (volatile uint32_t *)((0x40d27  << 2) + 0xffd00000)
#define   EMMC_C_GPING_040                         (0x40d28)
#define P_EMMC_C_GPING_040                         (volatile uint32_t *)((0x40d28  << 2) + 0xffd00000)
#define   EMMC_C_GPING_041                         (0x40d29)
#define P_EMMC_C_GPING_041                         (volatile uint32_t *)((0x40d29  << 2) + 0xffd00000)
#define   EMMC_C_GPING_042                         (0x40d2a)
#define P_EMMC_C_GPING_042                         (volatile uint32_t *)((0x40d2a  << 2) + 0xffd00000)
#define   EMMC_C_GPING_043                         (0x40d2b)
#define P_EMMC_C_GPING_043                         (volatile uint32_t *)((0x40d2b  << 2) + 0xffd00000)
#define   EMMC_C_GPING_044                         (0x40d2c)
#define P_EMMC_C_GPING_044                         (volatile uint32_t *)((0x40d2c  << 2) + 0xffd00000)
#define   EMMC_C_GPING_045                         (0x40d2d)
#define P_EMMC_C_GPING_045                         (volatile uint32_t *)((0x40d2d  << 2) + 0xffd00000)
#define   EMMC_C_GPING_046                         (0x40d2e)
#define P_EMMC_C_GPING_046                         (volatile uint32_t *)((0x40d2e  << 2) + 0xffd00000)
#define   EMMC_C_GPING_047                         (0x40d2f)
#define P_EMMC_C_GPING_047                         (volatile uint32_t *)((0x40d2f  << 2) + 0xffd00000)
#define   EMMC_C_GPING_048                         (0x40d30)
#define P_EMMC_C_GPING_048                         (volatile uint32_t *)((0x40d30  << 2) + 0xffd00000)
#define   EMMC_C_GPING_049                         (0x40d31)
#define P_EMMC_C_GPING_049                         (volatile uint32_t *)((0x40d31  << 2) + 0xffd00000)
#define   EMMC_C_GPING_050                         (0x40d32)
#define P_EMMC_C_GPING_050                         (volatile uint32_t *)((0x40d32  << 2) + 0xffd00000)
#define   EMMC_C_GPING_051                         (0x40d33)
#define P_EMMC_C_GPING_051                         (volatile uint32_t *)((0x40d33  << 2) + 0xffd00000)
#define   EMMC_C_GPING_052                         (0x40d34)
#define P_EMMC_C_GPING_052                         (volatile uint32_t *)((0x40d34  << 2) + 0xffd00000)
#define   EMMC_C_GPING_053                         (0x40d35)
#define P_EMMC_C_GPING_053                         (volatile uint32_t *)((0x40d35  << 2) + 0xffd00000)
#define   EMMC_C_GPING_054                         (0x40d36)
#define P_EMMC_C_GPING_054                         (volatile uint32_t *)((0x40d36  << 2) + 0xffd00000)
#define   EMMC_C_GPING_055                         (0x40d37)
#define P_EMMC_C_GPING_055                         (volatile uint32_t *)((0x40d37  << 2) + 0xffd00000)
#define   EMMC_C_GPING_056                         (0x40d38)
#define P_EMMC_C_GPING_056                         (volatile uint32_t *)((0x40d38  << 2) + 0xffd00000)
#define   EMMC_C_GPING_057                         (0x40d39)
#define P_EMMC_C_GPING_057                         (volatile uint32_t *)((0x40d39  << 2) + 0xffd00000)
#define   EMMC_C_GPING_058                         (0x40d3a)
#define P_EMMC_C_GPING_058                         (volatile uint32_t *)((0x40d3a  << 2) + 0xffd00000)
#define   EMMC_C_GPING_059                         (0x40d3b)
#define P_EMMC_C_GPING_059                         (volatile uint32_t *)((0x40d3b  << 2) + 0xffd00000)
#define   EMMC_C_GPING_060                         (0x40d3c)
#define P_EMMC_C_GPING_060                         (volatile uint32_t *)((0x40d3c  << 2) + 0xffd00000)
#define   EMMC_C_GPING_061                         (0x40d3d)
#define P_EMMC_C_GPING_061                         (volatile uint32_t *)((0x40d3d  << 2) + 0xffd00000)
#define   EMMC_C_GPING_062                         (0x40d3e)
#define P_EMMC_C_GPING_062                         (volatile uint32_t *)((0x40d3e  << 2) + 0xffd00000)
#define   EMMC_C_GPING_063                         (0x40d3f)
#define P_EMMC_C_GPING_063                         (volatile uint32_t *)((0x40d3f  << 2) + 0xffd00000)
#define   EMMC_C_GPING_064                         (0x40d40)
#define P_EMMC_C_GPING_064                         (volatile uint32_t *)((0x40d40  << 2) + 0xffd00000)
#define   EMMC_C_GPING_065                         (0x40d41)
#define P_EMMC_C_GPING_065                         (volatile uint32_t *)((0x40d41  << 2) + 0xffd00000)
#define   EMMC_C_GPING_066                         (0x40d42)
#define P_EMMC_C_GPING_066                         (volatile uint32_t *)((0x40d42  << 2) + 0xffd00000)
#define   EMMC_C_GPING_067                         (0x40d43)
#define P_EMMC_C_GPING_067                         (volatile uint32_t *)((0x40d43  << 2) + 0xffd00000)
#define   EMMC_C_GPING_068                         (0x40d44)
#define P_EMMC_C_GPING_068                         (volatile uint32_t *)((0x40d44  << 2) + 0xffd00000)
#define   EMMC_C_GPING_069                         (0x40d45)
#define P_EMMC_C_GPING_069                         (volatile uint32_t *)((0x40d45  << 2) + 0xffd00000)
#define   EMMC_C_GPING_070                         (0x40d46)
#define P_EMMC_C_GPING_070                         (volatile uint32_t *)((0x40d46  << 2) + 0xffd00000)
#define   EMMC_C_GPING_071                         (0x40d47)
#define P_EMMC_C_GPING_071                         (volatile uint32_t *)((0x40d47  << 2) + 0xffd00000)
#define   EMMC_C_GPING_072                         (0x40d48)
#define P_EMMC_C_GPING_072                         (volatile uint32_t *)((0x40d48  << 2) + 0xffd00000)
#define   EMMC_C_GPING_073                         (0x40d49)
#define P_EMMC_C_GPING_073                         (volatile uint32_t *)((0x40d49  << 2) + 0xffd00000)
#define   EMMC_C_GPING_074                         (0x40d4a)
#define P_EMMC_C_GPING_074                         (volatile uint32_t *)((0x40d4a  << 2) + 0xffd00000)
#define   EMMC_C_GPING_075                         (0x40d4b)
#define P_EMMC_C_GPING_075                         (volatile uint32_t *)((0x40d4b  << 2) + 0xffd00000)
#define   EMMC_C_GPING_076                         (0x40d4c)
#define P_EMMC_C_GPING_076                         (volatile uint32_t *)((0x40d4c  << 2) + 0xffd00000)
#define   EMMC_C_GPING_077                         (0x40d4d)
#define P_EMMC_C_GPING_077                         (volatile uint32_t *)((0x40d4d  << 2) + 0xffd00000)
#define   EMMC_C_GPING_078                         (0x40d4e)
#define P_EMMC_C_GPING_078                         (volatile uint32_t *)((0x40d4e  << 2) + 0xffd00000)
#define   EMMC_C_GPING_079                         (0x40d4f)
#define P_EMMC_C_GPING_079                         (volatile uint32_t *)((0x40d4f  << 2) + 0xffd00000)
#define   EMMC_C_GPING_080                         (0x40d50)
#define P_EMMC_C_GPING_080                         (volatile uint32_t *)((0x40d50  << 2) + 0xffd00000)
#define   EMMC_C_GPING_081                         (0x40d51)
#define P_EMMC_C_GPING_081                         (volatile uint32_t *)((0x40d51  << 2) + 0xffd00000)
#define   EMMC_C_GPING_082                         (0x40d52)
#define P_EMMC_C_GPING_082                         (volatile uint32_t *)((0x40d52  << 2) + 0xffd00000)
#define   EMMC_C_GPING_083                         (0x40d53)
#define P_EMMC_C_GPING_083                         (volatile uint32_t *)((0x40d53  << 2) + 0xffd00000)
#define   EMMC_C_GPING_084                         (0x40d54)
#define P_EMMC_C_GPING_084                         (volatile uint32_t *)((0x40d54  << 2) + 0xffd00000)
#define   EMMC_C_GPING_085                         (0x40d55)
#define P_EMMC_C_GPING_085                         (volatile uint32_t *)((0x40d55  << 2) + 0xffd00000)
#define   EMMC_C_GPING_086                         (0x40d56)
#define P_EMMC_C_GPING_086                         (volatile uint32_t *)((0x40d56  << 2) + 0xffd00000)
#define   EMMC_C_GPING_087                         (0x40d57)
#define P_EMMC_C_GPING_087                         (volatile uint32_t *)((0x40d57  << 2) + 0xffd00000)
#define   EMMC_C_GPING_088                         (0x40d58)
#define P_EMMC_C_GPING_088                         (volatile uint32_t *)((0x40d58  << 2) + 0xffd00000)
#define   EMMC_C_GPING_089                         (0x40d59)
#define P_EMMC_C_GPING_089                         (volatile uint32_t *)((0x40d59  << 2) + 0xffd00000)
#define   EMMC_C_GPING_090                         (0x40d5a)
#define P_EMMC_C_GPING_090                         (volatile uint32_t *)((0x40d5a  << 2) + 0xffd00000)
#define   EMMC_C_GPING_091                         (0x40d5b)
#define P_EMMC_C_GPING_091                         (volatile uint32_t *)((0x40d5b  << 2) + 0xffd00000)
#define   EMMC_C_GPING_092                         (0x40d5c)
#define P_EMMC_C_GPING_092                         (volatile uint32_t *)((0x40d5c  << 2) + 0xffd00000)
#define   EMMC_C_GPING_093                         (0x40d5d)
#define P_EMMC_C_GPING_093                         (volatile uint32_t *)((0x40d5d  << 2) + 0xffd00000)
#define   EMMC_C_GPING_094                         (0x40d5e)
#define P_EMMC_C_GPING_094                         (volatile uint32_t *)((0x40d5e  << 2) + 0xffd00000)
#define   EMMC_C_GPING_095                         (0x40d5f)
#define P_EMMC_C_GPING_095                         (volatile uint32_t *)((0x40d5f  << 2) + 0xffd00000)
#define   EMMC_C_GPING_096                         (0x40d60)
#define P_EMMC_C_GPING_096                         (volatile uint32_t *)((0x40d60  << 2) + 0xffd00000)
#define   EMMC_C_GPING_097                         (0x40d61)
#define P_EMMC_C_GPING_097                         (volatile uint32_t *)((0x40d61  << 2) + 0xffd00000)
#define   EMMC_C_GPING_098                         (0x40d62)
#define P_EMMC_C_GPING_098                         (volatile uint32_t *)((0x40d62  << 2) + 0xffd00000)
#define   EMMC_C_GPING_099                         (0x40d63)
#define P_EMMC_C_GPING_099                         (volatile uint32_t *)((0x40d63  << 2) + 0xffd00000)
#define   EMMC_C_GPING_100                         (0x40d64)
#define P_EMMC_C_GPING_100                         (volatile uint32_t *)((0x40d64  << 2) + 0xffd00000)
#define   EMMC_C_GPING_101                         (0x40d65)
#define P_EMMC_C_GPING_101                         (volatile uint32_t *)((0x40d65  << 2) + 0xffd00000)
#define   EMMC_C_GPING_102                         (0x40d66)
#define P_EMMC_C_GPING_102                         (volatile uint32_t *)((0x40d66  << 2) + 0xffd00000)
#define   EMMC_C_GPING_103                         (0x40d67)
#define P_EMMC_C_GPING_103                         (volatile uint32_t *)((0x40d67  << 2) + 0xffd00000)
#define   EMMC_C_GPING_104                         (0x40d68)
#define P_EMMC_C_GPING_104                         (volatile uint32_t *)((0x40d68  << 2) + 0xffd00000)
#define   EMMC_C_GPING_105                         (0x40d69)
#define P_EMMC_C_GPING_105                         (volatile uint32_t *)((0x40d69  << 2) + 0xffd00000)
#define   EMMC_C_GPING_106                         (0x40d6a)
#define P_EMMC_C_GPING_106                         (volatile uint32_t *)((0x40d6a  << 2) + 0xffd00000)
#define   EMMC_C_GPING_107                         (0x40d6b)
#define P_EMMC_C_GPING_107                         (volatile uint32_t *)((0x40d6b  << 2) + 0xffd00000)
#define   EMMC_C_GPING_108                         (0x40d6c)
#define P_EMMC_C_GPING_108                         (volatile uint32_t *)((0x40d6c  << 2) + 0xffd00000)
#define   EMMC_C_GPING_109                         (0x40d6d)
#define P_EMMC_C_GPING_109                         (volatile uint32_t *)((0x40d6d  << 2) + 0xffd00000)
#define   EMMC_C_GPING_110                         (0x40d6e)
#define P_EMMC_C_GPING_110                         (volatile uint32_t *)((0x40d6e  << 2) + 0xffd00000)
#define   EMMC_C_GPING_111                         (0x40d6f)
#define P_EMMC_C_GPING_111                         (volatile uint32_t *)((0x40d6f  << 2) + 0xffd00000)
#define   EMMC_C_GPING_112                         (0x40d70)
#define P_EMMC_C_GPING_112                         (volatile uint32_t *)((0x40d70  << 2) + 0xffd00000)
#define   EMMC_C_GPING_113                         (0x40d71)
#define P_EMMC_C_GPING_113                         (volatile uint32_t *)((0x40d71  << 2) + 0xffd00000)
#define   EMMC_C_GPING_114                         (0x40d72)
#define P_EMMC_C_GPING_114                         (volatile uint32_t *)((0x40d72  << 2) + 0xffd00000)
#define   EMMC_C_GPING_115                         (0x40d73)
#define P_EMMC_C_GPING_115                         (volatile uint32_t *)((0x40d73  << 2) + 0xffd00000)
#define   EMMC_C_GPING_116                         (0x40d74)
#define P_EMMC_C_GPING_116                         (volatile uint32_t *)((0x40d74  << 2) + 0xffd00000)
#define   EMMC_C_GPING_117                         (0x40d75)
#define P_EMMC_C_GPING_117                         (volatile uint32_t *)((0x40d75  << 2) + 0xffd00000)
#define   EMMC_C_GPING_118                         (0x40d76)
#define P_EMMC_C_GPING_118                         (volatile uint32_t *)((0x40d76  << 2) + 0xffd00000)
#define   EMMC_C_GPING_119                         (0x40d77)
#define P_EMMC_C_GPING_119                         (volatile uint32_t *)((0x40d77  << 2) + 0xffd00000)
#define   EMMC_C_GPING_120                         (0x40d78)
#define P_EMMC_C_GPING_120                         (volatile uint32_t *)((0x40d78  << 2) + 0xffd00000)
#define   EMMC_C_GPING_121                         (0x40d79)
#define P_EMMC_C_GPING_121                         (volatile uint32_t *)((0x40d79  << 2) + 0xffd00000)
#define   EMMC_C_GPING_122                         (0x40d7a)
#define P_EMMC_C_GPING_122                         (volatile uint32_t *)((0x40d7a  << 2) + 0xffd00000)
#define   EMMC_C_GPING_123                         (0x40d7b)
#define P_EMMC_C_GPING_123                         (volatile uint32_t *)((0x40d7b  << 2) + 0xffd00000)
#define   EMMC_C_GPING_124                         (0x40d7c)
#define P_EMMC_C_GPING_124                         (volatile uint32_t *)((0x40d7c  << 2) + 0xffd00000)
#define   EMMC_C_GPING_125                         (0x40d7d)
#define P_EMMC_C_GPING_125                         (volatile uint32_t *)((0x40d7d  << 2) + 0xffd00000)
#define   EMMC_C_GPING_126                         (0x40d7e)
#define P_EMMC_C_GPING_126                         (volatile uint32_t *)((0x40d7e  << 2) + 0xffd00000)
#define   EMMC_C_GPING_127                         (0x40d7f)
#define P_EMMC_C_GPING_127                         (volatile uint32_t *)((0x40d7f  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_000                         (0x40d80)
#define P_EMMC_C_GPONG_000                         (volatile uint32_t *)((0x40d80  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_001                         (0x40d81)
#define P_EMMC_C_GPONG_001                         (volatile uint32_t *)((0x40d81  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_002                         (0x40d82)
#define P_EMMC_C_GPONG_002                         (volatile uint32_t *)((0x40d82  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_003                         (0x40d83)
#define P_EMMC_C_GPONG_003                         (volatile uint32_t *)((0x40d83  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_004                         (0x40d84)
#define P_EMMC_C_GPONG_004                         (volatile uint32_t *)((0x40d84  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_005                         (0x40d85)
#define P_EMMC_C_GPONG_005                         (volatile uint32_t *)((0x40d85  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_006                         (0x40d86)
#define P_EMMC_C_GPONG_006                         (volatile uint32_t *)((0x40d86  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_007                         (0x40d87)
#define P_EMMC_C_GPONG_007                         (volatile uint32_t *)((0x40d87  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_008                         (0x40d88)
#define P_EMMC_C_GPONG_008                         (volatile uint32_t *)((0x40d88  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_009                         (0x40d89)
#define P_EMMC_C_GPONG_009                         (volatile uint32_t *)((0x40d89  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_010                         (0x40d8a)
#define P_EMMC_C_GPONG_010                         (volatile uint32_t *)((0x40d8a  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_011                         (0x40d8b)
#define P_EMMC_C_GPONG_011                         (volatile uint32_t *)((0x40d8b  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_012                         (0x40d8c)
#define P_EMMC_C_GPONG_012                         (volatile uint32_t *)((0x40d8c  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_013                         (0x40d8d)
#define P_EMMC_C_GPONG_013                         (volatile uint32_t *)((0x40d8d  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_014                         (0x40d8e)
#define P_EMMC_C_GPONG_014                         (volatile uint32_t *)((0x40d8e  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_015                         (0x40d8f)
#define P_EMMC_C_GPONG_015                         (volatile uint32_t *)((0x40d8f  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_016                         (0x40d90)
#define P_EMMC_C_GPONG_016                         (volatile uint32_t *)((0x40d90  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_017                         (0x40d91)
#define P_EMMC_C_GPONG_017                         (volatile uint32_t *)((0x40d91  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_018                         (0x40d92)
#define P_EMMC_C_GPONG_018                         (volatile uint32_t *)((0x40d92  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_019                         (0x40d93)
#define P_EMMC_C_GPONG_019                         (volatile uint32_t *)((0x40d93  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_020                         (0x40d94)
#define P_EMMC_C_GPONG_020                         (volatile uint32_t *)((0x40d94  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_021                         (0x40d95)
#define P_EMMC_C_GPONG_021                         (volatile uint32_t *)((0x40d95  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_022                         (0x40d96)
#define P_EMMC_C_GPONG_022                         (volatile uint32_t *)((0x40d96  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_023                         (0x40d97)
#define P_EMMC_C_GPONG_023                         (volatile uint32_t *)((0x40d97  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_024                         (0x40d98)
#define P_EMMC_C_GPONG_024                         (volatile uint32_t *)((0x40d98  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_025                         (0x40d99)
#define P_EMMC_C_GPONG_025                         (volatile uint32_t *)((0x40d99  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_026                         (0x40d9a)
#define P_EMMC_C_GPONG_026                         (volatile uint32_t *)((0x40d9a  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_027                         (0x40d9b)
#define P_EMMC_C_GPONG_027                         (volatile uint32_t *)((0x40d9b  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_028                         (0x40d9c)
#define P_EMMC_C_GPONG_028                         (volatile uint32_t *)((0x40d9c  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_029                         (0x40d9d)
#define P_EMMC_C_GPONG_029                         (volatile uint32_t *)((0x40d9d  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_030                         (0x40d9e)
#define P_EMMC_C_GPONG_030                         (volatile uint32_t *)((0x40d9e  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_031                         (0x40d9f)
#define P_EMMC_C_GPONG_031                         (volatile uint32_t *)((0x40d9f  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_032                         (0x40da0)
#define P_EMMC_C_GPONG_032                         (volatile uint32_t *)((0x40da0  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_033                         (0x40da1)
#define P_EMMC_C_GPONG_033                         (volatile uint32_t *)((0x40da1  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_034                         (0x40da2)
#define P_EMMC_C_GPONG_034                         (volatile uint32_t *)((0x40da2  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_035                         (0x40da3)
#define P_EMMC_C_GPONG_035                         (volatile uint32_t *)((0x40da3  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_036                         (0x40da4)
#define P_EMMC_C_GPONG_036                         (volatile uint32_t *)((0x40da4  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_037                         (0x40da5)
#define P_EMMC_C_GPONG_037                         (volatile uint32_t *)((0x40da5  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_038                         (0x40da6)
#define P_EMMC_C_GPONG_038                         (volatile uint32_t *)((0x40da6  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_039                         (0x40da7)
#define P_EMMC_C_GPONG_039                         (volatile uint32_t *)((0x40da7  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_040                         (0x40da8)
#define P_EMMC_C_GPONG_040                         (volatile uint32_t *)((0x40da8  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_041                         (0x40da9)
#define P_EMMC_C_GPONG_041                         (volatile uint32_t *)((0x40da9  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_042                         (0x40daa)
#define P_EMMC_C_GPONG_042                         (volatile uint32_t *)((0x40daa  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_043                         (0x40dab)
#define P_EMMC_C_GPONG_043                         (volatile uint32_t *)((0x40dab  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_044                         (0x40dac)
#define P_EMMC_C_GPONG_044                         (volatile uint32_t *)((0x40dac  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_045                         (0x40dad)
#define P_EMMC_C_GPONG_045                         (volatile uint32_t *)((0x40dad  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_046                         (0x40dae)
#define P_EMMC_C_GPONG_046                         (volatile uint32_t *)((0x40dae  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_047                         (0x40daf)
#define P_EMMC_C_GPONG_047                         (volatile uint32_t *)((0x40daf  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_048                         (0x40db0)
#define P_EMMC_C_GPONG_048                         (volatile uint32_t *)((0x40db0  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_049                         (0x40db1)
#define P_EMMC_C_GPONG_049                         (volatile uint32_t *)((0x40db1  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_050                         (0x40db2)
#define P_EMMC_C_GPONG_050                         (volatile uint32_t *)((0x40db2  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_051                         (0x40db3)
#define P_EMMC_C_GPONG_051                         (volatile uint32_t *)((0x40db3  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_052                         (0x40db4)
#define P_EMMC_C_GPONG_052                         (volatile uint32_t *)((0x40db4  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_053                         (0x40db5)
#define P_EMMC_C_GPONG_053                         (volatile uint32_t *)((0x40db5  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_054                         (0x40db6)
#define P_EMMC_C_GPONG_054                         (volatile uint32_t *)((0x40db6  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_055                         (0x40db7)
#define P_EMMC_C_GPONG_055                         (volatile uint32_t *)((0x40db7  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_056                         (0x40db8)
#define P_EMMC_C_GPONG_056                         (volatile uint32_t *)((0x40db8  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_057                         (0x40db9)
#define P_EMMC_C_GPONG_057                         (volatile uint32_t *)((0x40db9  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_058                         (0x40dba)
#define P_EMMC_C_GPONG_058                         (volatile uint32_t *)((0x40dba  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_059                         (0x40dbb)
#define P_EMMC_C_GPONG_059                         (volatile uint32_t *)((0x40dbb  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_060                         (0x40dbc)
#define P_EMMC_C_GPONG_060                         (volatile uint32_t *)((0x40dbc  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_061                         (0x40dbd)
#define P_EMMC_C_GPONG_061                         (volatile uint32_t *)((0x40dbd  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_062                         (0x40dbe)
#define P_EMMC_C_GPONG_062                         (volatile uint32_t *)((0x40dbe  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_063                         (0x40dbf)
#define P_EMMC_C_GPONG_063                         (volatile uint32_t *)((0x40dbf  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_064                         (0x40dc0)
#define P_EMMC_C_GPONG_064                         (volatile uint32_t *)((0x40dc0  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_065                         (0x40dc1)
#define P_EMMC_C_GPONG_065                         (volatile uint32_t *)((0x40dc1  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_066                         (0x40dc2)
#define P_EMMC_C_GPONG_066                         (volatile uint32_t *)((0x40dc2  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_067                         (0x40dc3)
#define P_EMMC_C_GPONG_067                         (volatile uint32_t *)((0x40dc3  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_068                         (0x40dc4)
#define P_EMMC_C_GPONG_068                         (volatile uint32_t *)((0x40dc4  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_069                         (0x40dc5)
#define P_EMMC_C_GPONG_069                         (volatile uint32_t *)((0x40dc5  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_070                         (0x40dc6)
#define P_EMMC_C_GPONG_070                         (volatile uint32_t *)((0x40dc6  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_071                         (0x40dc7)
#define P_EMMC_C_GPONG_071                         (volatile uint32_t *)((0x40dc7  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_072                         (0x40dc8)
#define P_EMMC_C_GPONG_072                         (volatile uint32_t *)((0x40dc8  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_073                         (0x40dc9)
#define P_EMMC_C_GPONG_073                         (volatile uint32_t *)((0x40dc9  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_074                         (0x40dca)
#define P_EMMC_C_GPONG_074                         (volatile uint32_t *)((0x40dca  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_075                         (0x40dcb)
#define P_EMMC_C_GPONG_075                         (volatile uint32_t *)((0x40dcb  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_076                         (0x40dcc)
#define P_EMMC_C_GPONG_076                         (volatile uint32_t *)((0x40dcc  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_077                         (0x40dcd)
#define P_EMMC_C_GPONG_077                         (volatile uint32_t *)((0x40dcd  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_078                         (0x40dce)
#define P_EMMC_C_GPONG_078                         (volatile uint32_t *)((0x40dce  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_079                         (0x40dcf)
#define P_EMMC_C_GPONG_079                         (volatile uint32_t *)((0x40dcf  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_080                         (0x40dd0)
#define P_EMMC_C_GPONG_080                         (volatile uint32_t *)((0x40dd0  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_081                         (0x40dd1)
#define P_EMMC_C_GPONG_081                         (volatile uint32_t *)((0x40dd1  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_082                         (0x40dd2)
#define P_EMMC_C_GPONG_082                         (volatile uint32_t *)((0x40dd2  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_083                         (0x40dd3)
#define P_EMMC_C_GPONG_083                         (volatile uint32_t *)((0x40dd3  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_084                         (0x40dd4)
#define P_EMMC_C_GPONG_084                         (volatile uint32_t *)((0x40dd4  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_085                         (0x40dd5)
#define P_EMMC_C_GPONG_085                         (volatile uint32_t *)((0x40dd5  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_086                         (0x40dd6)
#define P_EMMC_C_GPONG_086                         (volatile uint32_t *)((0x40dd6  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_087                         (0x40dd7)
#define P_EMMC_C_GPONG_087                         (volatile uint32_t *)((0x40dd7  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_088                         (0x40dd8)
#define P_EMMC_C_GPONG_088                         (volatile uint32_t *)((0x40dd8  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_089                         (0x40dd9)
#define P_EMMC_C_GPONG_089                         (volatile uint32_t *)((0x40dd9  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_090                         (0x40dda)
#define P_EMMC_C_GPONG_090                         (volatile uint32_t *)((0x40dda  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_091                         (0x40ddb)
#define P_EMMC_C_GPONG_091                         (volatile uint32_t *)((0x40ddb  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_092                         (0x40ddc)
#define P_EMMC_C_GPONG_092                         (volatile uint32_t *)((0x40ddc  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_093                         (0x40ddd)
#define P_EMMC_C_GPONG_093                         (volatile uint32_t *)((0x40ddd  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_094                         (0x40dde)
#define P_EMMC_C_GPONG_094                         (volatile uint32_t *)((0x40dde  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_095                         (0x40ddf)
#define P_EMMC_C_GPONG_095                         (volatile uint32_t *)((0x40ddf  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_096                         (0x40de0)
#define P_EMMC_C_GPONG_096                         (volatile uint32_t *)((0x40de0  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_097                         (0x40de1)
#define P_EMMC_C_GPONG_097                         (volatile uint32_t *)((0x40de1  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_098                         (0x40de2)
#define P_EMMC_C_GPONG_098                         (volatile uint32_t *)((0x40de2  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_099                         (0x40de3)
#define P_EMMC_C_GPONG_099                         (volatile uint32_t *)((0x40de3  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_100                         (0x40de4)
#define P_EMMC_C_GPONG_100                         (volatile uint32_t *)((0x40de4  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_101                         (0x40de5)
#define P_EMMC_C_GPONG_101                         (volatile uint32_t *)((0x40de5  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_102                         (0x40de6)
#define P_EMMC_C_GPONG_102                         (volatile uint32_t *)((0x40de6  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_103                         (0x40de7)
#define P_EMMC_C_GPONG_103                         (volatile uint32_t *)((0x40de7  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_104                         (0x40de8)
#define P_EMMC_C_GPONG_104                         (volatile uint32_t *)((0x40de8  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_105                         (0x40de9)
#define P_EMMC_C_GPONG_105                         (volatile uint32_t *)((0x40de9  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_106                         (0x40dea)
#define P_EMMC_C_GPONG_106                         (volatile uint32_t *)((0x40dea  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_107                         (0x40deb)
#define P_EMMC_C_GPONG_107                         (volatile uint32_t *)((0x40deb  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_108                         (0x40dec)
#define P_EMMC_C_GPONG_108                         (volatile uint32_t *)((0x40dec  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_109                         (0x40ded)
#define P_EMMC_C_GPONG_109                         (volatile uint32_t *)((0x40ded  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_110                         (0x40dee)
#define P_EMMC_C_GPONG_110                         (volatile uint32_t *)((0x40dee  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_111                         (0x40def)
#define P_EMMC_C_GPONG_111                         (volatile uint32_t *)((0x40def  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_112                         (0x40df0)
#define P_EMMC_C_GPONG_112                         (volatile uint32_t *)((0x40df0  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_113                         (0x40df1)
#define P_EMMC_C_GPONG_113                         (volatile uint32_t *)((0x40df1  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_114                         (0x40df2)
#define P_EMMC_C_GPONG_114                         (volatile uint32_t *)((0x40df2  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_115                         (0x40df3)
#define P_EMMC_C_GPONG_115                         (volatile uint32_t *)((0x40df3  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_116                         (0x40df4)
#define P_EMMC_C_GPONG_116                         (volatile uint32_t *)((0x40df4  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_117                         (0x40df5)
#define P_EMMC_C_GPONG_117                         (volatile uint32_t *)((0x40df5  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_118                         (0x40df6)
#define P_EMMC_C_GPONG_118                         (volatile uint32_t *)((0x40df6  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_119                         (0x40df7)
#define P_EMMC_C_GPONG_119                         (volatile uint32_t *)((0x40df7  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_120                         (0x40df8)
#define P_EMMC_C_GPONG_120                         (volatile uint32_t *)((0x40df8  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_121                         (0x40df9)
#define P_EMMC_C_GPONG_121                         (volatile uint32_t *)((0x40df9  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_122                         (0x40dfa)
#define P_EMMC_C_GPONG_122                         (volatile uint32_t *)((0x40dfa  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_123                         (0x40dfb)
#define P_EMMC_C_GPONG_123                         (volatile uint32_t *)((0x40dfb  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_124                         (0x40dfc)
#define P_EMMC_C_GPONG_124                         (volatile uint32_t *)((0x40dfc  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_125                         (0x40dfd)
#define P_EMMC_C_GPONG_125                         (volatile uint32_t *)((0x40dfd  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_126                         (0x40dfe)
#define P_EMMC_C_GPONG_126                         (volatile uint32_t *)((0x40dfe  << 2) + 0xffd00000)
#define   EMMC_C_GPONG_127                         (0x40dff)
#define P_EMMC_C_GPONG_127                         (volatile uint32_t *)((0x40dff  << 2) + 0xffd00000)
//
// Closing file:  emmc_reg.h
//
//
// Reading file:  usb_reg.h
//
// $periphs/rtl/periphs_core register defines for the
// APB bus
// ------------------------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  USB_CBUS_BASE = 0x424
// -----------------------------------------------
#define   USB21_REG0                               (0x42408)
#define P_USB21_REG0                               (volatile uint32_t *)((0x42408  << 2) + 0xffd00000)
#define   USB21_REG1                               (0x42409)
#define P_USB21_REG1                               (volatile uint32_t *)((0x42409  << 2) + 0xffd00000)
#define   USB21_REG2                               (0x4240a)
#define P_USB21_REG2                               (volatile uint32_t *)((0x4240a  << 2) + 0xffd00000)
//
// Closing file:  usb_reg.h
//
//`include "bt656_reg.h"
//`include "pdm_reg.h"
//========================================================================
//  Global Control Registers                (12'h000 - 12'h0ff)
//
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  RESET_CBUS_BASE = 0x04
// -----------------------------------------------
#define   VERSION_CTRL                             (0x0400)
#define P_VERSION_CTRL                             (volatile uint32_t *)((0x0400  << 2) + 0xffd00000)
#define   RESET0_REGISTER                          (0x0401)
#define P_RESET0_REGISTER                          (volatile uint32_t *)((0x0401  << 2) + 0xffd00000)
#define   RESET1_REGISTER                          (0x0402)
#define P_RESET1_REGISTER                          (volatile uint32_t *)((0x0402  << 2) + 0xffd00000)
#define   RESET2_REGISTER                          (0x0403)
#define P_RESET2_REGISTER                          (volatile uint32_t *)((0x0403  << 2) + 0xffd00000)
#define   RESET3_REGISTER                          (0x0404)
#define P_RESET3_REGISTER                          (volatile uint32_t *)((0x0404  << 2) + 0xffd00000)
#define   RESET4_REGISTER                          (0x0405)
#define P_RESET4_REGISTER                          (volatile uint32_t *)((0x0405  << 2) + 0xffd00000)
#define   RESET5_REGISTER                          (0x0406)
#define P_RESET5_REGISTER                          (volatile uint32_t *)((0x0406  << 2) + 0xffd00000)
#define   RESET6_REGISTER                          (0x0407)
#define P_RESET6_REGISTER                          (volatile uint32_t *)((0x0407  << 2) + 0xffd00000)
#define   RESET7_REGISTER                          (0x0408)
#define P_RESET7_REGISTER                          (volatile uint32_t *)((0x0408  << 2) + 0xffd00000)
#define   RESET0_MASK                              (0x0410)
#define P_RESET0_MASK                              (volatile uint32_t *)((0x0410  << 2) + 0xffd00000)
#define   RESET1_MASK                              (0x0411)
#define P_RESET1_MASK                              (volatile uint32_t *)((0x0411  << 2) + 0xffd00000)
#define   RESET2_MASK                              (0x0412)
#define P_RESET2_MASK                              (volatile uint32_t *)((0x0412  << 2) + 0xffd00000)
#define   RESET3_MASK                              (0x0413)
#define P_RESET3_MASK                              (volatile uint32_t *)((0x0413  << 2) + 0xffd00000)
#define   RESET4_MASK                              (0x0414)
#define P_RESET4_MASK                              (volatile uint32_t *)((0x0414  << 2) + 0xffd00000)
#define   RESET5_MASK                              (0x0415)
#define P_RESET5_MASK                              (volatile uint32_t *)((0x0415  << 2) + 0xffd00000)
#define   RESET6_MASK                              (0x0416)
#define P_RESET6_MASK                              (volatile uint32_t *)((0x0416  << 2) + 0xffd00000)
#define   CRT_MASK                                 (0x0417)
#define P_CRT_MASK                                 (volatile uint32_t *)((0x0417  << 2) + 0xffd00000)
#define   RESET7_MASK                              (0x0418)
#define P_RESET7_MASK                              (volatile uint32_t *)((0x0418  << 2) + 0xffd00000)
#define   RESET0_LEVEL                             (0x0420)
#define P_RESET0_LEVEL                             (volatile uint32_t *)((0x0420  << 2) + 0xffd00000)
#define   RESET1_LEVEL                             (0x0421)
#define P_RESET1_LEVEL                             (volatile uint32_t *)((0x0421  << 2) + 0xffd00000)
#define   RESET2_LEVEL                             (0x0422)
#define P_RESET2_LEVEL                             (volatile uint32_t *)((0x0422  << 2) + 0xffd00000)
#define   RESET3_LEVEL                             (0x0423)
#define P_RESET3_LEVEL                             (volatile uint32_t *)((0x0423  << 2) + 0xffd00000)
#define   RESET4_LEVEL                             (0x0424)
#define P_RESET4_LEVEL                             (volatile uint32_t *)((0x0424  << 2) + 0xffd00000)
#define   RESET5_LEVEL                             (0x0425)
#define P_RESET5_LEVEL                             (volatile uint32_t *)((0x0425  << 2) + 0xffd00000)
#define   RESET6_LEVEL                             (0x0426)
#define P_RESET6_LEVEL                             (volatile uint32_t *)((0x0426  << 2) + 0xffd00000)
#define   RESET7_LEVEL                             (0x0427)
#define P_RESET7_LEVEL                             (volatile uint32_t *)((0x0427  << 2) + 0xffd00000)
//======================================
//  Reset Register Bits
//
//======================================
    #define HIU_RESET       0x0001
    #define VLD_RESET       0x0002
    #define IQIDCT_RESET    0x0004
    #define MC_RESET        0x0008
    #define DCU_RESET       0x0010
    #define VIU_RESET       0x0020
    #define AIU_RESET       0x0040
    #define CPU_RESET       0x0080
    #define AC3_RESET       0x0100
    #define MPEG_RESET      0x0200
//=======================================================================
// XIF module
// `include "xregs.h"
    #define X_INT_ADR           0x400
    #define GPIO_ADR            0x401
    #define GPIO_ADR_H8         0x402
    #define WFIFO_DEPTH         8
    #define WFIFO_PointerWidth  3
    #define WFIFO_WORDSIZE      32
//========================================================================
//  registers for mipi_dsi (12'h8a0 - 12'h8ff)
//========================================================================
//
// Reading file:  dsi_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// MIPI DSI HOST CONTROLLER Registers 0x1800 - 0x18ff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  DSI_CBUS_BASE = 0x18
// -----------------------------------------------
//------------------------------------------------------------------------------
// DWC IP registers: Synopsys IP, please refer to MIPI DSI HOST Databook
//------------------------------------------------------------------------------
#define   MIPI_DSI_DWC_VERSION_OS                  (0x1800)
#define P_MIPI_DSI_DWC_VERSION_OS                  (volatile uint32_t *)((0x1800  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_PWR_UP_OS                   (0x1801)
#define P_MIPI_DSI_DWC_PWR_UP_OS                   (volatile uint32_t *)((0x1801  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_CLKMGR_CFG_OS               (0x1802)
#define P_MIPI_DSI_DWC_CLKMGR_CFG_OS               (volatile uint32_t *)((0x1802  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_DPI_VCID_OS                 (0x1803)
#define P_MIPI_DSI_DWC_DPI_VCID_OS                 (volatile uint32_t *)((0x1803  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_DPI_COLOR_CODING_OS         (0x1804)
#define P_MIPI_DSI_DWC_DPI_COLOR_CODING_OS         (volatile uint32_t *)((0x1804  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_DPI_CFG_POL_OS              (0x1805)
#define P_MIPI_DSI_DWC_DPI_CFG_POL_OS              (volatile uint32_t *)((0x1805  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_DPI_LP_CMD_TIM_OS           (0x1806)
#define P_MIPI_DSI_DWC_DPI_LP_CMD_TIM_OS           (volatile uint32_t *)((0x1806  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_PCKHDL_CFG_OS               (0x180b)
#define P_MIPI_DSI_DWC_PCKHDL_CFG_OS               (volatile uint32_t *)((0x180b  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_GEN_VCID_OS                 (0x180c)
#define P_MIPI_DSI_DWC_GEN_VCID_OS                 (volatile uint32_t *)((0x180c  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_MODE_CFG_OS                 (0x180d)
#define P_MIPI_DSI_DWC_MODE_CFG_OS                 (volatile uint32_t *)((0x180d  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_VID_MODE_CFG_OS             (0x180e)
#define P_MIPI_DSI_DWC_VID_MODE_CFG_OS             (volatile uint32_t *)((0x180e  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_VID_PKT_SIZE_OS             (0x180f)
#define P_MIPI_DSI_DWC_VID_PKT_SIZE_OS             (volatile uint32_t *)((0x180f  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_VID_NUM_CHUNKS_OS           (0x1810)
#define P_MIPI_DSI_DWC_VID_NUM_CHUNKS_OS           (volatile uint32_t *)((0x1810  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_VID_NULL_SIZE_OS            (0x1811)
#define P_MIPI_DSI_DWC_VID_NULL_SIZE_OS            (volatile uint32_t *)((0x1811  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_VID_HSA_TIME_OS             (0x1812)
#define P_MIPI_DSI_DWC_VID_HSA_TIME_OS             (volatile uint32_t *)((0x1812  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_VID_HBP_TIME_OS             (0x1813)
#define P_MIPI_DSI_DWC_VID_HBP_TIME_OS             (volatile uint32_t *)((0x1813  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_VID_HLINE_TIME_OS           (0x1814)
#define P_MIPI_DSI_DWC_VID_HLINE_TIME_OS           (volatile uint32_t *)((0x1814  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_VID_VSA_LINES_OS            (0x1815)
#define P_MIPI_DSI_DWC_VID_VSA_LINES_OS            (volatile uint32_t *)((0x1815  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_VID_VBP_LINES_OS            (0x1816)
#define P_MIPI_DSI_DWC_VID_VBP_LINES_OS            (volatile uint32_t *)((0x1816  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_VID_VFP_LINES_OS            (0x1817)
#define P_MIPI_DSI_DWC_VID_VFP_LINES_OS            (volatile uint32_t *)((0x1817  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_VID_VACTIVE_LINES_OS        (0x1818)
#define P_MIPI_DSI_DWC_VID_VACTIVE_LINES_OS        (volatile uint32_t *)((0x1818  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_EDPI_CMD_SIZE_OS            (0x1819)
#define P_MIPI_DSI_DWC_EDPI_CMD_SIZE_OS            (volatile uint32_t *)((0x1819  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_CMD_MODE_CFG_OS             (0x181a)
#define P_MIPI_DSI_DWC_CMD_MODE_CFG_OS             (volatile uint32_t *)((0x181a  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_GEN_HDR_OS                  (0x181b)
#define P_MIPI_DSI_DWC_GEN_HDR_OS                  (volatile uint32_t *)((0x181b  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_GEN_PLD_DATA_OS             (0x181c)
#define P_MIPI_DSI_DWC_GEN_PLD_DATA_OS             (volatile uint32_t *)((0x181c  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_CMD_PKT_STATUS_OS           (0x181d)
#define P_MIPI_DSI_DWC_CMD_PKT_STATUS_OS           (volatile uint32_t *)((0x181d  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_TO_CNT_CFG_OS               (0x181e)
#define P_MIPI_DSI_DWC_TO_CNT_CFG_OS               (volatile uint32_t *)((0x181e  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_HS_RD_TO_CNT_OS             (0x181f)
#define P_MIPI_DSI_DWC_HS_RD_TO_CNT_OS             (volatile uint32_t *)((0x181f  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_LP_RD_TO_CNT_OS             (0x1820)
#define P_MIPI_DSI_DWC_LP_RD_TO_CNT_OS             (volatile uint32_t *)((0x1820  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_HS_WR_TO_CNT_OS             (0x1821)
#define P_MIPI_DSI_DWC_HS_WR_TO_CNT_OS             (volatile uint32_t *)((0x1821  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_LP_WR_TO_CNT_OS             (0x1822)
#define P_MIPI_DSI_DWC_LP_WR_TO_CNT_OS             (volatile uint32_t *)((0x1822  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_BTA_TO_CNT_OS               (0x1823)
#define P_MIPI_DSI_DWC_BTA_TO_CNT_OS               (volatile uint32_t *)((0x1823  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_SDF_3D_OS                   (0x1824)
#define P_MIPI_DSI_DWC_SDF_3D_OS                   (volatile uint32_t *)((0x1824  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_LPCLK_CTRL_OS               (0x1825)
#define P_MIPI_DSI_DWC_LPCLK_CTRL_OS               (volatile uint32_t *)((0x1825  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_PHY_TMR_LPCLK_CFG_OS        (0x1826)
#define P_MIPI_DSI_DWC_PHY_TMR_LPCLK_CFG_OS        (volatile uint32_t *)((0x1826  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_PHY_TMR_CFG_OS              (0x1827)
#define P_MIPI_DSI_DWC_PHY_TMR_CFG_OS              (volatile uint32_t *)((0x1827  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_PHY_RSTZ_OS                 (0x1828)
#define P_MIPI_DSI_DWC_PHY_RSTZ_OS                 (volatile uint32_t *)((0x1828  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_PHY_IF_CFG_OS               (0x1829)
#define P_MIPI_DSI_DWC_PHY_IF_CFG_OS               (volatile uint32_t *)((0x1829  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_PHY_ULPS_CTRL_OS            (0x182a)
#define P_MIPI_DSI_DWC_PHY_ULPS_CTRL_OS            (volatile uint32_t *)((0x182a  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_PHY_TX_TRIGGERS_OS          (0x182b)
#define P_MIPI_DSI_DWC_PHY_TX_TRIGGERS_OS          (volatile uint32_t *)((0x182b  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_PHY_STATUS_OS               (0x182c)
#define P_MIPI_DSI_DWC_PHY_STATUS_OS               (volatile uint32_t *)((0x182c  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_PHY_TST_CTRL0_OS            (0x182d)
#define P_MIPI_DSI_DWC_PHY_TST_CTRL0_OS            (volatile uint32_t *)((0x182d  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_PHY_TST_CTRL1_OS            (0x182e)
#define P_MIPI_DSI_DWC_PHY_TST_CTRL1_OS            (volatile uint32_t *)((0x182e  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_INT_ST0_OS                  (0x182f)
#define P_MIPI_DSI_DWC_INT_ST0_OS                  (volatile uint32_t *)((0x182f  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_INT_ST1_OS                  (0x1830)
#define P_MIPI_DSI_DWC_INT_ST1_OS                  (volatile uint32_t *)((0x1830  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_INT_MSK0_OS                 (0x1831)
#define P_MIPI_DSI_DWC_INT_MSK0_OS                 (volatile uint32_t *)((0x1831  << 2) + 0xffd00000)
#define   MIPI_DSI_DWC_INT_MSK1_OS                 (0x1832)
#define P_MIPI_DSI_DWC_INT_MSK1_OS                 (volatile uint32_t *)((0x1832  << 2) + 0xffd00000)
//------------------------------------------------------------------------------
// Top-level registers: AmLogic proprietary
//------------------------------------------------------------------------------
// 31: 4    Reserved.                                                                           Default 0.
//     3 RW ~tim_rst_n:  1=Assert SW reset on mipi_dsi_host_timing block.   0=Release reset.    Default 1.
//     2 RW ~dpi_rst_n:  1=Assert SW reset on mipi_dsi_host_dpi block.      0=Release reset.    Default 1.
//     1 RW ~intr_rst_n: 1=Assert SW reset on mipi_dsi_host_intr block.     0=Release reset.    Default 1.
//     0 RW ~dwc_rst_n:  1=Assert SW reset on IP core.                      0=Release reset.    Default 1.
#define   MIPI_DSI_TOP_SW_RESET                    (0x18f0)
#define P_MIPI_DSI_TOP_SW_RESET                    (volatile uint32_t *)((0x18f0  << 2) + 0xffd00000)
// 31: 3    Reserved.                                                                                                       Default 0.
//     2 RW clock_freerun: Apply to auto-clock gate only.                                                                   Default 0.
//                          0=Default, use auto-clock gating to save power;
//                          1=use free-run clock, disable auto-clock gating, for debug mode.
//     1 RW enable_pixclk: A manual clock gate option, due to DWC IP does not have auto-clock gating. 1=Enable pixclk.      Default 0.
//     0 RW enable_sysclk: A manual clock gate option, due to DWC IP does not have auto-clock gating. 1=Enable sysclk.      Default 0.
#define   MIPI_DSI_TOP_CLK_CNTL                    (0x18f1)
#define P_MIPI_DSI_TOP_CLK_CNTL                    (volatile uint32_t *)((0x18f1  << 2) + 0xffd00000)
// 31:27    Reserved.                                                                       Default 0.
//    26 RW de_dpi_pol:     1= Invert DE polarity from mipi_dsi_host_dpi.                   Default 0.
//    25 RW hsync_dpi_pol:  1= Invert HS polarity from mipi_dsi_host_dpi.                   Default 0.
//    24 RW vsync_dpi_pol:  1= Invert VS polarity from mipi_dsi_host_dpi.                   Default 0.
// 23:20 RW dpi_color_mode: Define DPI pixel format.                                        Default 0.
//                           0=16-bit RGB565 config 1;
//                           1=16-bit RGB565 config 2;
//                           2=16-bit RGB565 config 3;
//                           3=18-bit RGB666 config 1;
//                           4=18-bit RGB666 config 2;
//                           5=24-bit RGB888;
//                           6=20-bit YCbCr 4:2:2;
//                           7=24-bit YCbCr 4:2:2;
//                           8=16-bit YCbCr 4:2:2;
//                           9=30-bit RGB;
//                          10=36-bit RGB;
//                          11=12-bit YCbCr 4:2:0.
//    19    Reserved.                                                                       Default 0.
// 18:16 RW in_color_mode:  Define VENC data width.                                         Default 0.
//                          0=30-bit pixel;
//                          1=24-bit pixel;
//                          2=18-bit pixel, RGB666;
//                          3=16-bit pixel, RGB565.
// 15:14 RW chroma_subsample: Define method of chroma subsampling.                          Default 0.
//                            Applicable to YUV422 or YUV420 only.
//                            0=Use even pixel's chroma;
//                            1=Use odd pixel's chroma;
//                            2=Use averaged value between even and odd pair.
// 13:12 RW comp2_sel:  Select which component to be Cr or B: 0=comp0; 1=comp1; 2=comp2.    Default 2.
// 11:10 RW comp1_sel:  Select which component to be Cb or G: 0=comp0; 1=comp1; 2=comp2.    Default 1.
//  9: 8 RW comp0_sel:  Select which component to be Y  or R: 0=comp0; 1=comp1; 2=comp2.    Default 0.
//     7    Reserved.                                                                       Default 0.
//     6 RW de_venc_pol:    1= Invert DE polarity from VENC.                                Default 0.
//     5 RW hsync_venc_pol: 1= Invert HS polarity from VENC.                                Default 0.
//     4 RW vsync_venc_pol: 1= Invert VS polarity from VENC.                                Default 0.
//     3 RW dpicolorm:      Signal to IP.                                                   Default 0.
//     2 RW dpishutdn:      Signal to IP.                                                   Default 0.
//     1    Reserved.                                                                       Default 0.
//     0    Reserved.                                                                       Default 0.
#define   MIPI_DSI_TOP_CNTL                        (0x18f2)
#define P_MIPI_DSI_TOP_CNTL                        (volatile uint32_t *)((0x18f2  << 2) + 0xffd00000)
// 31:16    Reserved.                                                                                                           Default 0.
// 15: 8 RW suspend_frame_rate: Define rate of timed-suspend.                                                                   Default 0.
//                              0=Execute suspend every frame; 1=Every other frame; ...; 255=Every 256 frame.
//  7: 3    Reserved.                                                                                                           Default 0.
//     2 RW timed_suspend_en:   1=Enable timed suspend VencL. 0=Disable timed suspend.                                          Default 0.
//     1 RW manual_suspend_en:  1=Enable manual suspend VencL. 1=Cancel manual suspend VencL.                                   Default 0.
//     0 RW suspend_on_edpihalt:1=Enable IP's edpihalt signal to suspend VencL; 0=IP's edpihalt signal does not affect VencL.   Default 1.
#define   MIPI_DSI_TOP_SUSPEND_CNTL                (0x18f3)
#define P_MIPI_DSI_TOP_SUSPEND_CNTL                (volatile uint32_t *)((0x18f3  << 2) + 0xffd00000)
// 31:29    Reserved.                                                                                                           Default 0.
// 28:16 RW suspend_line_end:   Define timed-suspend region. Suspend from [pix_start,line_start] to [pix_end,line_end].         Default 0.
// 15:13    Reserved.                                                                                                           Default 0.
// 12: 0 RW suspend_line_start: Define timed-suspend region. Suspend from [pix_start,line_start] to [pix_end,line_end].         Default 0.
#define   MIPI_DSI_TOP_SUSPEND_LINE                (0x18f4)
#define P_MIPI_DSI_TOP_SUSPEND_LINE                (volatile uint32_t *)((0x18f4  << 2) + 0xffd00000)
// 31:29    Reserved.                                                                                                           Default 0.
// 28:16 RW suspend_pix_end:    Define timed-suspend region. Suspend from [pix_start,line_start] to [pix_end,line_end].         Default 0.
// 15:13    Reserved.                                                                                                           Default 0.
// 12: 0 RW suspend_pix_start:  Define timed-suspend region. Suspend from [pix_start,line_start] to [pix_end,line_end].         Default 0.
#define   MIPI_DSI_TOP_SUSPEND_PIX                 (0x18f5)
#define P_MIPI_DSI_TOP_SUSPEND_PIX                 (volatile uint32_t *)((0x18f5  << 2) + 0xffd00000)
// 31:20    Reserved.                                                                                                           Default 0.
// 19:10 RW meas_vsync:     Control on measuring Host Controller's vsync.                                                       Default 0.
//                          [   19] meas_en:        1=Enable measurement
//                          [   18] accum_meas_en:  0=meas_count is cleared at the end of each measure;
//                                                  1=meas_count is accumulated at the end of each measure.
//                          [17:10] vsync_span:     Define the duration of a measure is to last for how many Vsyncs.
//  9: 0 RW meas_edpite:    Control on measuring Display Slave's edpite.                                                        Default 0.
//                          [    9] meas_en:        1=Enable measurement
//                          [    8] accum_meas_en:  0=meas_count is cleared at the end of each measure;
//                                                  1=meas_count is accumulated at the end of each measure.
//                          [ 7: 0] edpite_span:    Define the duration of a measure is to last for how many edpite.
#define   MIPI_DSI_TOP_MEAS_CNTL                   (0x18f6)
#define P_MIPI_DSI_TOP_MEAS_CNTL                   (volatile uint32_t *)((0x18f6  << 2) + 0xffd00000)
//    31 R  stat_edpihalt:  status of edpihalt signal from IP.              Default 0.
// 30:29    Reserved.                                                       Default 0.
// 28:16 R  stat_te_line:   Snapshot of Host's line position at edpite.     Default 0.
// 15:13    Reserved.                                                       Default 0.
// 12: 0 R  stat_te_pix:    Snapshot of Host's pixel position at edpite.    Default 0.
#define   MIPI_DSI_TOP_STAT                        (0x18f7)
#define P_MIPI_DSI_TOP_STAT                        (volatile uint32_t *)((0x18f7  << 2) + 0xffd00000)
// To measure display slave's frame rate, we can use a reference clock to measure the duration of one of more edpite pulse(s).
// Measurement control is by register MIPI_DSI_TOP_MEAS_CNTL bit[9:0].
// Reference clock comes from clk_rst_tst.cts_dsi_meas_clk, and is defined by HIU register HHI_VDIN_MEAS_CLK_CNTL bit[23:12].
// Measurement result is in MIPI_DSI_TOP_MEAS_STAT_TE0 and MIPI_DSI_TOP_MEAS_STAT_TE1, as below:
// edpite_meas_count[47:0]: Number of reference clock cycles counted during one measure period (non-incremental measure), or
//                          during all measure periods so far (incremental measure).
// edpite_meas_count_n[3:0]:Number of measure periods has been done. Number can wrap over.
//
// 31: 0 R  edpite_meas_count[31:0].    Default 0.
#define   MIPI_DSI_TOP_MEAS_STAT_TE0               (0x18f8)
#define P_MIPI_DSI_TOP_MEAS_STAT_TE0               (volatile uint32_t *)((0x18f8  << 2) + 0xffd00000)
// 19:16 R  edpite_meas_count_n.        Default 0.
// 15: 0 R  edpite_meas_count[47:32].   Default 0.
#define   MIPI_DSI_TOP_MEAS_STAT_TE1               (0x18f9)
#define P_MIPI_DSI_TOP_MEAS_STAT_TE1               (volatile uint32_t *)((0x18f9  << 2) + 0xffd00000)
// To measure Host's frame rate, we can use a reference clock to measure the duration of one of more Vsync pulse(s).
// Measurement control is by register MIPI_DSI_TOP_MEAS_CNTL bit[19:10].
// Reference clock comes from clk_rst_tst.cts_dsi_meas_clk, and is defined by HIU register HHI_VDIN_MEAS_CLK_CNTL bit[23:12].
// Measurement result is in MIPI_DSI_TOP_MEAS_STAT_VS0 and MIPI_DSI_TOP_MEAS_STAT_VS1, as below:
// vsync_meas_count[47:0]:  Number of reference clock cycles counted during one measure period (non-incremental measure), or
//                          during all measure periods so far (incremental measure).
// vsync_meas_count_n[3:0]: Number of measure periods has been done. Number can wrap over.
//
// 31: 0 R  vsync_meas_count[31:0].     Default 0.
#define   MIPI_DSI_TOP_MEAS_STAT_VS0               (0x18fa)
#define P_MIPI_DSI_TOP_MEAS_STAT_VS0               (volatile uint32_t *)((0x18fa  << 2) + 0xffd00000)
// 19:16 R  vsync_meas_count_n.         Default 0.
// 15: 0 R  vsync_meas_count[47:32].    Default 0.
#define   MIPI_DSI_TOP_MEAS_STAT_VS1               (0x18fb)
#define P_MIPI_DSI_TOP_MEAS_STAT_VS1               (volatile uint32_t *)((0x18fb  << 2) + 0xffd00000)
// 31:16 RW intr_stat/clr. For each bit, read as this interrupt level status, write 1 to clear. Default 0.
//                         Note: To clear the interrupt level, simply write 1 to the specific bit, no need to write 0 afterwards.
//          [31:22] Reserved
//          [   21] stat/clr of EOF interrupt
//          [   20] stat/clr of de_fall interrupt
//          [   19] stat/clr of de_rise interrupt
//          [   18] stat/clr of vs_fall interrupt
//          [   17] stat/clr of vs_rise interrupt
//          [   16] stat/clr of dwc_edpite interrupt
// 15: 0 RW intr_enable. For each bit, 1=enable this interrupt, 0=disable.                      Default 0.
//          [15: 6] Reserved
//          [    5] EOF (End_Of_Field) interrupt
//          [    4] de_fall interrupt
//          [    3] de_rise interrupt
//          [    2] vs_fall interrupt
//          [    1] vs_rise interrupt
//          [    0] dwc_edpite interrupt
#define   MIPI_DSI_TOP_INTR_CNTL_STAT              (0x18fc)
#define P_MIPI_DSI_TOP_INTR_CNTL_STAT              (volatile uint32_t *)((0x18fc  << 2) + 0xffd00000)
// 31: 2    Reserved.   Default 0.
//  1: 0 RW mem_pd.     Default 3.
#define   MIPI_DSI_TOP_MEM_PD                      (0x18fd)
#define P_MIPI_DSI_TOP_MEM_PD                      (volatile uint32_t *)((0x18fd  << 2) + 0xffd00000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  dsi_regs.h
//
//======================================
//  CPU Assist module
//
//======================================
// -----------------------------------------------
// CBUS_BASE:  ASSIST_CBUS_BASE = 0x20
// -----------------------------------------------
//`define ASSIST_AMR_MBOX1_INT          8'h4d
//`define ASSIST_AMR_MBOX2_INT          8'h4e
#define   ASSIST_AMR_SCRATCH0                      (0x204f)
#define P_ASSIST_AMR_SCRATCH0                      (volatile uint32_t *)((0x204f  << 2) + 0xffd00000)
#define   ASSIST_AMR_SCRATCH1                      (0x2050)
#define P_ASSIST_AMR_SCRATCH1                      (volatile uint32_t *)((0x2050  << 2) + 0xffd00000)
#define   ASSIST_AMR_SCRATCH2                      (0x2051)
#define P_ASSIST_AMR_SCRATCH2                      (volatile uint32_t *)((0x2051  << 2) + 0xffd00000)
#define   ASSIST_AMR_SCRATCH3                      (0x2052)
#define P_ASSIST_AMR_SCRATCH3                      (volatile uint32_t *)((0x2052  << 2) + 0xffd00000)
#define   ASSIST_HW_REV                            (0x2053)
#define P_ASSIST_HW_REV                            (volatile uint32_t *)((0x2053  << 2) + 0xffd00000)
//`define ASSIST_CBUS_ARB               8'h54
#define   ASSIST_POR_CONFIG                        (0x2055)
#define P_ASSIST_POR_CONFIG                        (volatile uint32_t *)((0x2055  << 2) + 0xffd00000)
#define   ASSIST_SPARE16_REG1                      (0x2056)
#define P_ASSIST_SPARE16_REG1                      (volatile uint32_t *)((0x2056  << 2) + 0xffd00000)
#define   ASSIST_SPARE16_REG2                      (0x2057)
#define P_ASSIST_SPARE16_REG2                      (volatile uint32_t *)((0x2057  << 2) + 0xffd00000)
#define   ASSIST_SPARE8_REG1                       (0x2058)
#define P_ASSIST_SPARE8_REG1                       (volatile uint32_t *)((0x2058  << 2) + 0xffd00000)
#define   ASSIST_SPARE8_REG2                       (0x2059)
#define P_ASSIST_SPARE8_REG2                       (volatile uint32_t *)((0x2059  << 2) + 0xffd00000)
// Duplicate Address...when used please move to a new address
// `define TO_AMRISC_REG                 8'h59 // for amrisc
#define   ASSIST_SPARE8_REG3                       (0x205a)
#define P_ASSIST_SPARE8_REG3                       (volatile uint32_t *)((0x205a  << 2) + 0xffd00000)
// Duplicate Address...when used please move to a new address
// `define FROM_AMRISC_REG               8'h5a // for amrisc
// Duplicate Address...when used please move to a new address
// `define MPEG2_DECODER_CONTROL         8'h5b // for amrisc
#define   AC3_CTRL_REG1                            (0x205b)
#define P_AC3_CTRL_REG1                            (volatile uint32_t *)((0x205b  << 2) + 0xffd00000)
#define   AC3_CTRL_REG2                            (0x205c)
#define P_AC3_CTRL_REG2                            (volatile uint32_t *)((0x205c  << 2) + 0xffd00000)
#define   AC3_CTRL_REG3                            (0x205d)
#define P_AC3_CTRL_REG3                            (volatile uint32_t *)((0x205d  << 2) + 0xffd00000)
#define   AC3_CTRL_REG4                            (0x205e)
#define P_AC3_CTRL_REG4                            (volatile uint32_t *)((0x205e  << 2) + 0xffd00000)
//`define ASSIST_PMEM_SPLIT             8'h5f
#define   ASSIST_GEN_CNTL                          (0x2068)
#define P_ASSIST_GEN_CNTL                          (volatile uint32_t *)((0x2068  << 2) + 0xffd00000)
#define   EE_ASSIST_MBOX0_IRQ_REG                  (0x2070)
#define P_EE_ASSIST_MBOX0_IRQ_REG                  (volatile uint32_t *)((0x2070  << 2) + 0xffd00000)
#define   EE_ASSIST_MBOX0_CLR_REG                  (0x2071)
#define P_EE_ASSIST_MBOX0_CLR_REG                  (volatile uint32_t *)((0x2071  << 2) + 0xffd00000)
#define   EE_ASSIST_MBOX0_MASK                     (0x2072)
#define P_EE_ASSIST_MBOX0_MASK                     (volatile uint32_t *)((0x2072  << 2) + 0xffd00000)
#define   EE_ASSIST_MBOX0_FIQ_SEL                  (0x2073)
#define P_EE_ASSIST_MBOX0_FIQ_SEL                  (volatile uint32_t *)((0x2073  << 2) + 0xffd00000)
#define   EE_ASSIST_MBOX1_IRQ_REG                  (0x2074)
#define P_EE_ASSIST_MBOX1_IRQ_REG                  (volatile uint32_t *)((0x2074  << 2) + 0xffd00000)
#define   EE_ASSIST_MBOX1_CLR_REG                  (0x2075)
#define P_EE_ASSIST_MBOX1_CLR_REG                  (volatile uint32_t *)((0x2075  << 2) + 0xffd00000)
#define   EE_ASSIST_MBOX1_MASK                     (0x2076)
#define P_EE_ASSIST_MBOX1_MASK                     (volatile uint32_t *)((0x2076  << 2) + 0xffd00000)
#define   EE_ASSIST_MBOX1_FIQ_SEL                  (0x2077)
#define P_EE_ASSIST_MBOX1_FIQ_SEL                  (volatile uint32_t *)((0x2077  << 2) + 0xffd00000)
#define   EE_ASSIST_MBOX2_IRQ_REG                  (0x2078)
#define P_EE_ASSIST_MBOX2_IRQ_REG                  (volatile uint32_t *)((0x2078  << 2) + 0xffd00000)
#define   EE_ASSIST_MBOX2_CLR_REG                  (0x2079)
#define P_EE_ASSIST_MBOX2_CLR_REG                  (volatile uint32_t *)((0x2079  << 2) + 0xffd00000)
#define   EE_ASSIST_MBOX2_MASK                     (0x207a)
#define P_EE_ASSIST_MBOX2_MASK                     (volatile uint32_t *)((0x207a  << 2) + 0xffd00000)
#define   EE_ASSIST_MBOX2_FIQ_SEL                  (0x207b)
#define P_EE_ASSIST_MBOX2_FIQ_SEL                  (volatile uint32_t *)((0x207b  << 2) + 0xffd00000)
#define   EE_ASSIST_MBOX3_IRQ_REG                  (0x207c)
#define P_EE_ASSIST_MBOX3_IRQ_REG                  (volatile uint32_t *)((0x207c  << 2) + 0xffd00000)
#define   EE_ASSIST_MBOX3_CLR_REG                  (0x207d)
#define P_EE_ASSIST_MBOX3_CLR_REG                  (volatile uint32_t *)((0x207d  << 2) + 0xffd00000)
#define   EE_ASSIST_MBOX3_MASK                     (0x207e)
#define P_EE_ASSIST_MBOX3_MASK                     (volatile uint32_t *)((0x207e  << 2) + 0xffd00000)
#define   EE_ASSIST_MBOX3_FIQ_SEL                  (0x207f)
#define P_EE_ASSIST_MBOX3_FIQ_SEL                  (volatile uint32_t *)((0x207f  << 2) + 0xffd00000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  ./register_map.h
//
//
// Reading file:  ./vcbus_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
//`define RDMA_VCBUS_BASE       8'h11
//===========================================================================
//
// Reading file:  rdma_regs.h
//
//===========================================================================
// RDMA registers 0x00 - 0xff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  RDMA_VCBUS_BASE = 0x11
// -----------------------------------------------
// Bit 31: 0 RW AHB start address for manual start DMA
#define   RDMA_AHB_START_ADDR_MAN                  (0x1100)
#define P_RDMA_AHB_START_ADDR_MAN                  (volatile uint32_t *)((0x1100  << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for manual start DMA
#define   RDMA_AHB_END_ADDR_MAN                    (0x1101)
#define P_RDMA_AHB_END_ADDR_MAN                    (volatile uint32_t *)((0x1101  << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 1
#define   RDMA_AHB_START_ADDR_1                    (0x1102)
#define P_RDMA_AHB_START_ADDR_1                    (volatile uint32_t *)((0x1102  << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 1
#define   RDMA_AHB_END_ADDR_1                      (0x1103)
#define P_RDMA_AHB_END_ADDR_1                      (volatile uint32_t *)((0x1103  << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 2
#define   RDMA_AHB_START_ADDR_2                    (0x1104)
#define P_RDMA_AHB_START_ADDR_2                    (volatile uint32_t *)((0x1104  << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 2
#define   RDMA_AHB_END_ADDR_2                      (0x1105)
#define P_RDMA_AHB_END_ADDR_2                      (volatile uint32_t *)((0x1105  << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 3
#define   RDMA_AHB_START_ADDR_3                    (0x1106)
#define P_RDMA_AHB_START_ADDR_3                    (volatile uint32_t *)((0x1106  << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 3
#define   RDMA_AHB_END_ADDR_3                      (0x1107)
#define P_RDMA_AHB_END_ADDR_3                      (volatile uint32_t *)((0x1107  << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 4
#define   RDMA_AHB_START_ADDR_4                    (0x1108)
#define P_RDMA_AHB_START_ADDR_4                    (volatile uint32_t *)((0x1108  << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 4
#define   RDMA_AHB_END_ADDR_4                      (0x1109)
#define P_RDMA_AHB_END_ADDR_4                      (volatile uint32_t *)((0x1109  << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 5
#define   RDMA_AHB_START_ADDR_5                    (0x110a)
#define P_RDMA_AHB_START_ADDR_5                    (volatile uint32_t *)((0x110a  << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 5
#define   RDMA_AHB_END_ADDR_5                      (0x110b)
#define P_RDMA_AHB_END_ADDR_5                      (volatile uint32_t *)((0x110b  << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 6
#define   RDMA_AHB_START_ADDR_6                    (0x110c)
#define P_RDMA_AHB_START_ADDR_6                    (volatile uint32_t *)((0x110c  << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 6
#define   RDMA_AHB_END_ADDR_6                      (0x110d)
#define P_RDMA_AHB_END_ADDR_6                      (volatile uint32_t *)((0x110d  << 2) + 0xff900000)
// Bit 31: 0 RW AHB start address for auto start source 7
#define   RDMA_AHB_START_ADDR_7                    (0x110e)
#define P_RDMA_AHB_START_ADDR_7                    (volatile uint32_t *)((0x110e  << 2) + 0xff900000)
// Bit 31: 0 RW AHB end address for auto start source 7
#define   RDMA_AHB_END_ADDR_7                      (0x110f)
#define P_RDMA_AHB_END_ADDR_7                      (volatile uint32_t *)((0x110f  << 2) + 0xff900000)
// Auto start DMA control:
// Bit 31:24 RW ctrl_enable_int_3. Interrupt inputs enable mask for source 3.
// Bit 23:16 RW ctrl_enable_int_2. Interrupt inputs enable mask for source 2.
// Bit 15: 8 RW ctrl_enable_int_1. Interrupt inputs enable mask for source 1.
// Bit     7 RW ctrl_cbus_write_3. Register read/write mode for auto-start 3. 1=Register write; 0=Register read.
// Bit     6 RW ctrl_cbus_write_3. Register read/write mode for auto-start 2. 1=Register write; 0=Register read.
// Bit     5 RW ctrl_cbus_write_3. Register read/write mode for auto-start 1. 1=Register write; 0=Register read.
// Bit     4 R  Rsrv.
// Bit     3 RW ctrl_cbus_addr_incr_3. 1=Incremental register access for auto-start 3; 0=Non-incremental (individual) register access.
// Bit     2 RW ctrl_cbus_addr_incr_2. 1=Incremental register access for auto-start 2; 0=Non-incremental (individual) register access.
// Bit     1 RW ctrl_cbus_addr_incr_1. 1=Incremental register access for auto-start 1; 0=Non-incremental (individual) register access.
// Bit     0 R  Rsrv.
#define   RDMA_ACCESS_AUTO                         (0x1110)
#define P_RDMA_ACCESS_AUTO                         (volatile uint32_t *)((0x1110  << 2) + 0xff900000)
#define   RDMA_ACCESS_AUTO2                        (0x1111)
#define P_RDMA_ACCESS_AUTO2                        (volatile uint32_t *)((0x1111  << 2) + 0xff900000)
#define   RDMA_ACCESS_AUTO3                        (0x1112)
#define P_RDMA_ACCESS_AUTO3                        (volatile uint32_t *)((0x1112  << 2) + 0xff900000)
// Manual start DMA control:
// Bit 31: 3 R  Rsrv.
// Bit     2 RW ctrl_cbus_write_man. Register read/write mode for manual-start. 1=Register write; 0=Register read.
// Bit     1 RW ctrl_cbus_addr_incr_man. 1=Incremental register access for manual-start; 0=Non-incremental (individual) register access.
// Bit     0 W  ctrl_start_man. Write 1 to this bit to manual-start DMA. This bit always read back 0.
#define   RDMA_ACCESS_MAN                          (0x1113)
#define P_RDMA_ACCESS_MAN                          (volatile uint32_t *)((0x1113  << 2) + 0xff900000)
// RDMA general control:
// Bit 31:25 R  Rsrv.
// Bit    24 W  ctrl_clr_rdma_done_int. Write 1 to reset rdma_int level to 0. No need to clear this bit.
// Bit 23:19 R  Rsrv.
// Bit 18:13 R  Rsrv.
// Bit 12: 7 R  Rsrv.
// Bit     6 RW ctrl_ddr_urgent.
// Bit  5: 4 RW ctrl_ahb_wr_burst_size. 0=ABH write request burst size 16;
//                                      1=ABH write request burst size 24;
//                                      2=ABH write request burst size 32;
//                                      3=ABH write request burst size 48.
// Bit  3: 2 RW ctrl_ahb_rd_burst_size. 0=ABH read request burst size 16;
//                                      1=ABH read request burst size 24;
//                                      2=ABH read request burst size 32;
//                                      3=ABH read request burst size 48.
// Bit     1 RW ctrl_sw_reset. 1=Reset RDMA logic except register.
// Bit     0 RW ctrl_free_clk_enable. 0=Default, Enable clock gating. 1=No clock gating, enable free clock.
#define   RDMA_CTRL                                (0x1114)
#define P_RDMA_CTRL                                (volatile uint32_t *)((0x1114  << 2) + 0xff900000)
// Read only.
// Bit 31:29 R  Rsrv.
// Bit    28 R  rdma_done_int.
// Bit 27:25 R  Rsrv.
// Bit 24:18 R  ahb_wrfifo_cnt. FIFO for buffering CBus read data to be sent to AHB
// Bit 17:11 R  ahb_rdfifo_cnt. FIFO for buffering data read from AHB.
// Bit 10: 8 R  ddr_req_st. =0 -- Idle; !=0 -- AHB interfacing ongoing.
// Bit  7: 4 R  curr_req. Latest requests that is being/been serviced. E.g. 0000=Idle; 0010=Latest serviced request is Req 1.
// Bit  3: 0 R  req_latch. Requests that are yet to be serviced. E.g. 0000=No request; 0001=Req 0 waiting; 1100=Req 2 and 3 waiting.
#define   RDMA_STATUS                              (0x1115)
#define P_RDMA_STATUS                              (volatile uint32_t *)((0x1115  << 2) + 0xff900000)
#define   RDMA_STATUS2                             (0x1116)
#define P_RDMA_STATUS2                             (volatile uint32_t *)((0x1116  << 2) + 0xff900000)
#define   RDMA_STATUS3                             (0x1117)
#define P_RDMA_STATUS3                             (volatile uint32_t *)((0x1117  << 2) + 0xff900000)
#define   RDMA_ACCESS_AUTO4                        (0x1118)
#define P_RDMA_ACCESS_AUTO4                        (volatile uint32_t *)((0x1118  << 2) + 0xff900000)
#define   RDMA_SRAM_CNTL                           (0x1120)
#define P_RDMA_SRAM_CNTL                           (volatile uint32_t *)((0x1120  << 2) + 0xff900000)
#define   RDMA_SRAM_REGADDR                        (0x1121)
#define P_RDMA_SRAM_REGADDR                        (volatile uint32_t *)((0x1121  << 2) + 0xff900000)
#define   RDMA_SRAM_REGDATA                        (0x1122)
#define P_RDMA_SRAM_REGDATA                        (volatile uint32_t *)((0x1122  << 2) + 0xff900000)
//
// Closing file:  rdma_regs.h
//
//===========================================================================
// VDIN
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VDIN_VCBUS_BASE = 0x12
// -----------------------------------------------
//VDIN0        8'h00 - 8'h7f
//VDIN1        8'h80 - 8'hef
#define VDIN0_OFFSET            0x00
#define VDIN1_OFFSET            0x80

#define   VDIN_SCALE_COEF_IDX                      (0x1200)
#define P_VDIN_SCALE_COEF_IDX                      (volatile uint32_t *)((0x1200  << 2) + 0xff900000)
#define   VDIN_SCALE_COEF                          (0x1201)
#define P_VDIN_SCALE_COEF                          (volatile uint32_t *)((0x1201  << 2) + 0xff900000)
//bit 31,   mpeg_to_vdin_sel, 0: mpeg source to NR directly, 1: mpeg source pass through here
//bit 30,   mpeg_field info which can be written by software
//Bit 29,   force go_field, pulse signal
//Bit 28,   force go_line, pulse signal
//Bit 27,   enable mpeg_go_field input signal
//Bit 26:20, hold lines
//Bit 19,   delay go_field function enable
//Bit 18:12, delay go_field line number
//Bit 11:10, component2 output switch, 00: select component0 in, 01: select component1 in, 10: select component2 in
//Bit 9:8, component1 output switch, 00: select component0 in, 01: select component1 in, 10: select component2 in
//Bit 7:6, component0 output switch, 00: select component0 in, 01: select component1 in, 10: select component2 in
//Bit 5,   input window selection function enable
//Bit 4, enable VDIN common data input, otherwise there will be no video data input
//Bit 3:0 vdin selection, 1: mpeg_in from dram, 2: bt656 input, 3: component input, 4: tvdecoder input, 5: hdmi rx input, 6: digital video input, 7: loopback from Viu1, 8: MIPI.
#define   VDIN_COM_CTRL0                           (0x1202)
#define P_VDIN_COM_CTRL0                           (volatile uint32_t *)((0x1202  << 2) + 0xff900000)
//Bit 28:16 active_max_pix_cnt, readonly
//Bit 12:0  active_max_pix_cnt_shadow, readonly
#define   VDIN_ACTIVE_MAX_PIX_CNT_STATUS           (0x1203)
#define P_VDIN_ACTIVE_MAX_PIX_CNT_STATUS           (volatile uint32_t *)((0x1203  << 2) + 0xff900000)
//Bit 28:16 go_line_cnt, readonly
//Bit 12:0  active_line_cnt, readonly
#define   VDIN_LCNT_STATUS                         (0x1204)
#define P_VDIN_LCNT_STATUS                         (volatile uint32_t *)((0x1204  << 2) + 0xff900000)
//Readonly
//Bit [14:3] lfifo_buf_cnt
//Bit 2, vdin_direct_done status
//Bit 1, vdin_nr_done status
//Bit 0, field
#define   VDIN_COM_STATUS0                         (0x1205)
#define P_VDIN_COM_STATUS0                         (volatile uint32_t *)((0x1205  << 2) + 0xff900000)
//Readonly
//Bit 31, vdi4 fifo overflow
//Bit 29:24, vdi3_asfifo_cnt
//Bit 23, vdi3 fifo overflow
//Bit 21:16, vdi3_asfifo_cnt
//Bit 15, vdi2 fifo overflow
//Bit 13:8, vdi2_asfifo_cnt
//Bit 7, vdi1 fifo overflow
//Bit 5:0, vdi1_asfifo_cnt
#define   VDIN_COM_STATUS1                         (0x1206)
#define P_VDIN_COM_STATUS1                         (volatile uint32_t *)((0x1206  << 2) + 0xff900000)
//Bit 28:16 go_line_cnt_shadow, readonly
//Bit 12:0  active_line_cnt_shadow, readonly
#define   VDIN_LCNT_SHADOW_STATUS                  (0x1207)
#define P_VDIN_LCNT_SHADOW_STATUS                  (volatile uint32_t *)((0x1207  << 2) + 0xff900000)
//each 8bit asfifo_ctrl is following:
//Bit 7, DE  enable
//Bit 6, go field enable
//Bit 5, go line enable
//Bit 4, if true, negative active input vsync
//Bit 3, if true, negative active input hsync
//Bit 2, vsync soft reset fifo enable
//Bit 1, overflow status clear
//Bit 0 asfifo soft reset, level signal
//Bit 7:0 vdi1 asfifo_ctrl
//Bit 23:16 vdi2 asfifo_ctrl
#define   VDIN_ASFIFO_CTRL0                        (0x1208)
#define P_VDIN_ASFIFO_CTRL0                        (volatile uint32_t *)((0x1208  << 2) + 0xff900000)
//Bit 7:0 vdi3 asfifo_ctrl
//Bit 23:16 vdi4 asfifo_ctrl
#define   VDIN_ASFIFO_CTRL1                        (0x1209)
#define P_VDIN_ASFIFO_CTRL1                        (volatile uint32_t *)((0x1209  << 2) + 0xff900000)
//Bit 28:16 input width minus 1, after the window function
//Bit 12:0  output width minus 1
#define   VDIN_WIDTHM1I_WIDTHM1O                   (0x120a)
#define P_VDIN_WIDTHM1I_WIDTHM1O                   (volatile uint32_t *)((0x120a  << 2) + 0xff900000)
//Bit 20:17 prehsc_mode, bit 3:2, prehsc odd line interp mode, bit 1:0, prehsc even line interp mode,
//           each 2bit, 00: pix0+pix1/2, average, 01: pix1, 10: pix0
//Bit 16:15 sp422_mode, special mode for the component1 and component2, 00: normal case, 01: 32 64 32, 10: 0 64 64 0, 11: 16 96 16
//Bit 14:8, hsc_ini_pixi_ptr, signed data, only useful when short_lineo_en is true
//Bit 7, prehsc_en
//Bit 6, hsc_en,
//Bit 5, hsc_short_lineo_en, short line output enable
//Bit 4, hsc_nearest_en
//Bit 3, hsc_phase0_always_en
//Bit 2:0, hsc_bank_length
#define   VDIN_SC_MISC_CTRL                        (0x120b)
#define P_VDIN_SC_MISC_CTRL                        (volatile uint32_t *)((0x120b  << 2) + 0xff900000)
//Bit 28:24, integer portion
//Bit 23:0, fraction portion
#define   VDIN_HSC_PHASE_STEP                      (0x120c)
#define P_VDIN_HSC_PHASE_STEP                      (volatile uint32_t *)((0x120c  << 2) + 0xff900000)
//Bit 30:29    hscale rpt_p0_num
//Bit 28:24    hscale ini_rcv_num
//Bit 23:0     hscale ini_phase
#define   VDIN_HSC_INI_CTRL                        (0x120d)
#define P_VDIN_HSC_INI_CTRL                        (volatile uint32_t *)((0x120d  << 2) + 0xff900000)
//Read only
//Bit 23, vdi7 fifo overflow
//Bit 21:16, vdi7_asfifo_cnt
//Bit 15, vdi6 fifo overflow
//Bit 13:8, vdi6_asfifo_cnt
//Bit 7, vdi5 fifo overflow
//Bit 5:0, vdi5_asfifo_cnt
#define   VDIN_COM_STATUS2                         (0x120e)
#define P_VDIN_COM_STATUS2                         (volatile uint32_t *)((0x120e  << 2) + 0xff900000)
//Bit 25:16 asfifo decimate control
//Bit 25, if true, decimation counter sync with first valid DE in the field,
//otherwise the decimation counter is not sync with external signal
//Bit 24, decimation de enable
//Bit 23:20, decimation phase, which counter value use to decimate,
//Bit 19:16, decimation number, 0: not decimation, 1: decimation 2, 2: decimation 3 ....
//Bit 7:0 vdi5 asfifo_ctrl
#define   VDIN_ASFIFO_CTRL2                        (0x120f)
#define P_VDIN_ASFIFO_CTRL2                        (volatile uint32_t *)((0x120f  << 2) + 0xff900000)
//Bit 7,  highlight_en
//Bit 6   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before matrix
//Bit 5:4  probe_sel, 00: select matrix 0, 01: select matrix 1,  otherwise select nothing
//Bit 3:2, matrix coef idx selection, 00: select mat0, 01: select mat1, otherwise slect nothing
//Bit 1   mat1 conversion matrix enable
//Bit 0   mat0 conversion matrix enable
#define   VDIN_MATRIX_CTRL                         (0x1210)
#define P_VDIN_MATRIX_CTRL                         (volatile uint32_t *)((0x1210  << 2) + 0xff900000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define   VDIN_MATRIX_COEF00_01                    (0x1211)
#define P_VDIN_MATRIX_COEF00_01                    (volatile uint32_t *)((0x1211  << 2) + 0xff900000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define   VDIN_MATRIX_COEF02_10                    (0x1212)
#define P_VDIN_MATRIX_COEF02_10                    (volatile uint32_t *)((0x1212  << 2) + 0xff900000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define   VDIN_MATRIX_COEF11_12                    (0x1213)
#define P_VDIN_MATRIX_COEF11_12                    (volatile uint32_t *)((0x1213  << 2) + 0xff900000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define   VDIN_MATRIX_COEF20_21                    (0x1214)
#define P_VDIN_MATRIX_COEF20_21                    (volatile uint32_t *)((0x1214  << 2) + 0xff900000)
//BIt 18:16 conv_rs
//Bit 12:0  coef22
#define   VDIN_MATRIX_COEF22                       (0x1215)
#define P_VDIN_MATRIX_COEF22                       (volatile uint32_t *)((0x1215  << 2) + 0xff900000)
//Bit 26:16 offset0
//Bit 10:0  offset1
#define   VDIN_MATRIX_OFFSET0_1                    (0x1216)
#define P_VDIN_MATRIX_OFFSET0_1                    (volatile uint32_t *)((0x1216  << 2) + 0xff900000)
//Bit 10:0  offset2
#define   VDIN_MATRIX_OFFSET2                      (0x1217)
#define P_VDIN_MATRIX_OFFSET2                      (volatile uint32_t *)((0x1217  << 2) + 0xff900000)
//Bit 26:16 pre_offset0
//Bit 10:0  pre_offset1
#define   VDIN_MATRIX_PRE_OFFSET0_1                (0x1218)
#define P_VDIN_MATRIX_PRE_OFFSET0_1                (volatile uint32_t *)((0x1218  << 2) + 0xff900000)
//Bit 10:0  pre_offset2
#define   VDIN_MATRIX_PRE_OFFSET2                  (0x1219)
#define P_VDIN_MATRIX_PRE_OFFSET2                  (volatile uint32_t *)((0x1219  << 2) + 0xff900000)
//12:0 lfifo_buf_size
#define   VDIN_LFIFO_CTRL                          (0x121a)
#define P_VDIN_LFIFO_CTRL                          (volatile uint32_t *)((0x121a  << 2) + 0xff900000)
#define   VDIN_COM_GCLK_CTRL                       (0x121b)
#define P_VDIN_COM_GCLK_CTRL                       (volatile uint32_t *)((0x121b  << 2) + 0xff900000)
//12:0 VDIN input interface width minus 1, before the window function, after the de decimation
#define   VDIN_INTF_WIDTHM1                        (0x121c)
#define P_VDIN_INTF_WIDTHM1                        (volatile uint32_t *)((0x121c  << 2) + 0xff900000)
//Bit 15          //default== 0, urgent_ctrl_en
//Bit 14          //default== 0, urgent_wr, if true for write buffer
//Bit 13          //default== 0, out_inv_en
//Bit 12          //default == 0, urgent_ini_value
//Bit 11:6        //default == 0, up_th  up threshold
//Bit 5:0         //default == 0, dn_th  dn threshold
#define   VDIN_LFIFO_URG_CTRL                      (0x121e)
#define P_VDIN_LFIFO_URG_CTRL                      (volatile uint32_t *)((0x121e  << 2) + 0xff900000)
//Bit 8, 1: discard data before line fifo, 0: normal mode
//Bit 7:0 Write chroma canvas address
#define   VDIN_WR_CTRL2                            (0x121f)
#define P_VDIN_WR_CTRL2                            (volatile uint32_t *)((0x121f  << 2) + 0xff900000)
//Bit 31:30 hconv_mode, Applicable only to bit[13:12]=0 or 2. 0: Output every even pixels' CbCr;
//                                                            1: Output every odd pixels' CbCr;
//                                                            2: Output an average value per even&odd pair of pixels;
//                                                            3: Output all CbCr. (This does NOT apply to bit[13:12]=0 -- 4:2:2 mode.)
//Bit 29 no_clk_gate: disable vid_wr_mif clock gating function.
//Bit 28 clear write response counter in the vdin write memory interface
//Bit 27 eol_sel, 1: use eol as the line end indication, 0: use width as line end indication in the vdin write memory interface
//Bit 26 vcp_nr_en. Only used in VDIN0. NOT used in VDIN1.
//Bit 25 vcp_wr_en. Only used in VDIN0. NOT used in VDIN1.
//Bit 24 vcp_in_en. Only used in VDIN0. NOT used in VDIN1.
//Bit 23 vdin frame reset enble, if true, it will provide frame reset during go_field(vsync) to the modules after that
//Bit 22 vdin line fifo soft reset enable, meaning, if true line fifo will reset during go_field (vsync)
//Bit 21 vdin direct write done status clear bit
//Bit 20 vdin NR write done status clear bit
//Bit 18 swap_cbcr. Applicable only to bit[13:12]=2. 0: Output CbCr (NV12); 1: Output CrCb (NV21).
//Bit 17:16 vconv_mode, Applicable only to bit[13:12]=2. 0: Output every even lines' CbCr;
//                                                       1: Output every odd lines' CbCr;
//                                                       2: Reserved;
//                                                       3: Output all CbCr.
//Bit 13:12 vdin write format, 0: 4:2:2 to luma canvas, 1: 4:4:4 to luma canvas,
//                             2: Y to luma canvas, CbCr to chroma canvas. For NV12/21, also define Bit 31:30, 17:16, and bit 18.
//Bit 11 vdin write canvas double buffer enable, means the canvas address will be latched by vsync before using
//Bit 10 1: disable ctrl_reg write pulse which will reset internal counter. when bit 11 is 1, this bit should be 1.
//Bit 9 vdin write request urgent
//Bit 8 vdin write request enable
//Bit 7:0 Write luma canvas address
#define   VDIN_WR_CTRL                             (0x1220)
#define P_VDIN_WR_CTRL                             (volatile uint32_t *)((0x1220  << 2) + 0xff900000)
//Bit 29, if true, horizontal reverse
//Bit 28:16 start
//Bit 12:0  end
#define   VDIN_WR_H_START_END                      (0x1221)
#define P_VDIN_WR_H_START_END                      (volatile uint32_t *)((0x1221  << 2) + 0xff900000)
//Bit 29, if true, vertical reverse
//Bit 28:16 start
//Bit 12:0  end
#define   VDIN_WR_V_START_END                      (0x1222)
#define P_VDIN_WR_V_START_END                      (volatile uint32_t *)((0x1222  << 2) + 0xff900000)
//Bit 24:20, integer portion
//Bit 19:0, fraction portion
#define   VDIN_VSC_PHASE_STEP                      (0x1223)
#define P_VDIN_VSC_PHASE_STEP                      (volatile uint32_t *)((0x1223  << 2) + 0xff900000)
//Bit 23, vsc_en, vertical scaler enable
//Bit 21 vsc_phase0_always_en, when scale up, you have to set it to 1
//Bit 20:16 ini skip_line_num
//Bit 15:0 vscaler ini_phase
#define   VDIN_VSC_INI_CTRL                        (0x1224)
#define P_VDIN_VSC_INI_CTRL                        (volatile uint32_t *)((0x1224  << 2) + 0xff900000)
//Bit 28:16, vshrink input height minus 1
//Bit 12:0, scaler input height minus 1
#define   VDIN_SCIN_HEIGHTM1                       (0x1225)
#define P_VDIN_SCIN_HEIGHTM1                       (volatile uint32_t *)((0x1225  << 2) + 0xff900000)
//Bit 23:16, dummy component 0
//Bit 15:8, dummy component 1
//Bit 7:0, dummy component 2
#define   VDIN_DUMMY_DATA                          (0x1226)
#define P_VDIN_DUMMY_DATA                          (volatile uint32_t *)((0x1226  << 2) + 0xff900000)
//Read only
//Bit 29:20 component 0
//Bit 19:10 component 1
//Bit 9:0 component 2
#define   VDIN_MATRIX_PROBE_COLOR                  (0x1228)
#define P_VDIN_MATRIX_PROBE_COLOR                  (volatile uint32_t *)((0x1228  << 2) + 0xff900000)
//Bit 23:16 component 0
//Bit 15:8  component 1
//Bit 7:0 component 2
#define   VDIN_MATRIX_HL_COLOR                     (0x1229)
#define P_VDIN_MATRIX_HL_COLOR                     (volatile uint32_t *)((0x1229  << 2) + 0xff900000)
//28:16 probe x, postion
//12:0  probe y, position
#define   VDIN_MATRIX_PROBE_POS                    (0x122a)
#define P_VDIN_MATRIX_PROBE_POS                    (volatile uint32_t *)((0x122a  << 2) + 0xff900000)
#define   VDIN_CHROMA_ADDR_PORT                    (0x122b)
#define P_VDIN_CHROMA_ADDR_PORT                    (volatile uint32_t *)((0x122b  << 2) + 0xff900000)
#define   VDIN_CHROMA_DATA_PORT                    (0x122c)
#define P_VDIN_CHROMA_DATA_PORT                    (volatile uint32_t *)((0x122c  << 2) + 0xff900000)
//
#define   VDIN_CM_BRI_CON_CTRL                     (0x122d)
#define P_VDIN_CM_BRI_CON_CTRL                     (volatile uint32_t *)((0x122d  << 2) + 0xff900000)
//Bit 17  clk_cyc_cnt_clr, if true, clear this register
//Bit 16 if true, use vpu clock to count one line, otherwise use actually hsync to count line_cnt
//Bit 15:0   line width using vpu clk
#define   VDIN_GO_LINE_CTRL                        (0x122f)
#define P_VDIN_GO_LINE_CTRL                        (volatile uint32_t *)((0x122f  << 2) + 0xff900000)
//Bit 31:24 hist_pix_white_th, larger than this th is counted as white pixel
//Bit 23:16 hist_pix_black_th, less than this th is counted as black pixel
//Bit 11    hist_34bin_only,   34 bin only mode, including white/black
//Bit 10:9  ldim_stts_din_sel, 00: from matrix0 dout,  01: from vsc_dout, 10: from matrix1 dout, 11: form matrix1 din
//Bit 8     ldim_stts_en
//Bit 6:5   hist_dnlp_low   the real pixels in each bins got by VDIN_DNLP_HISTXX should multiple with 2^(dnlp_low+3)
//Bit 3:2   hist_din_sel    the source used for hist statistics.  00: from matrix0 dout,  01: from vsc_dout, 10: from matrix1 dout, 11: form matrix1 din
//Bit 1     hist_win_en     1'b0: hist used for full picture; 1'b1: hist used for pixels within hist window
//Bit 0     hist_spl_en     1'b0: disable hist readback; 1'b1: enable hist readback
#define   VDIN_HIST_CTRL                           (0x1230)
#define P_VDIN_HIST_CTRL                           (volatile uint32_t *)((0x1230  << 2) + 0xff900000)
//Bit 28:16 hist_hstart  horizontal start value to define hist window
//Bit 12:0  hist_hend    horizontal end value to define hist window
#define   VDIN_HIST_H_START_END                    (0x1231)
#define P_VDIN_HIST_H_START_END                    (volatile uint32_t *)((0x1231  << 2) + 0xff900000)
//Bit 28:16 hist_vstart  vertical start value to define hist window
//Bit 12:0  hist_vend    vertical end value to define hist window
#define   VDIN_HIST_V_START_END                    (0x1232)
#define P_VDIN_HIST_V_START_END                    (volatile uint32_t *)((0x1232  << 2) + 0xff900000)
//Bit 15:8  hist_max    maximum value
//Bit 7:0   hist_min    minimum value
//read only
#define   VDIN_HIST_MAX_MIN                        (0x1233)
#define P_VDIN_HIST_MAX_MIN                        (volatile uint32_t *)((0x1233  << 2) + 0xff900000)
//Bit 31:0  hist_spl_rd
//counts for the total luma value
//read only
#define   VDIN_HIST_SPL_VAL                        (0x1234)
#define P_VDIN_HIST_SPL_VAL                        (volatile uint32_t *)((0x1234  << 2) + 0xff900000)
//Bit 21:0  hist_spl_pixel_count
//counts for the total calculated pixels
//read only
#define   VDIN_HIST_SPL_PIX_CNT                    (0x1235)
#define P_VDIN_HIST_SPL_PIX_CNT                    (volatile uint32_t *)((0x1235  << 2) + 0xff900000)
//Bit 31:0  hist_chroma_sum
//counts for the total chroma value
//read only
#define   VDIN_HIST_CHROMA_SUM                     (0x1236)
#define P_VDIN_HIST_CHROMA_SUM                     (volatile uint32_t *)((0x1236  << 2) + 0xff900000)
//Bit 31:16 higher hist bin
//Bit 15:0  lower hist bin
//0-255 are splited to 64 bins evenly, and VDIN_DNLP_HISTXX
//are the statistic number of pixels that within each bin.
//VDIN_DNLP_HIST00[15:0]  counts for the first  bin
//VDIN_DNLP_HIST00[31:16] counts for the second bin
//VDIN_DNLP_HIST01[15:0]  counts for the third  bin
//VDIN_DNLP_HIST01[31:16] counts for the fourth bin
//etc...
//read only
#define   VDIN_DNLP_HIST00                         (0x1237)
#define P_VDIN_DNLP_HIST00                         (volatile uint32_t *)((0x1237  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST01                         (0x1238)
#define P_VDIN_DNLP_HIST01                         (volatile uint32_t *)((0x1238  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST02                         (0x1239)
#define P_VDIN_DNLP_HIST02                         (volatile uint32_t *)((0x1239  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST03                         (0x123a)
#define P_VDIN_DNLP_HIST03                         (volatile uint32_t *)((0x123a  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST04                         (0x123b)
#define P_VDIN_DNLP_HIST04                         (volatile uint32_t *)((0x123b  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST05                         (0x123c)
#define P_VDIN_DNLP_HIST05                         (volatile uint32_t *)((0x123c  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST06                         (0x123d)
#define P_VDIN_DNLP_HIST06                         (volatile uint32_t *)((0x123d  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST07                         (0x123e)
#define P_VDIN_DNLP_HIST07                         (volatile uint32_t *)((0x123e  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST08                         (0x123f)
#define P_VDIN_DNLP_HIST08                         (volatile uint32_t *)((0x123f  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST09                         (0x1240)
#define P_VDIN_DNLP_HIST09                         (volatile uint32_t *)((0x1240  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST10                         (0x1241)
#define P_VDIN_DNLP_HIST10                         (volatile uint32_t *)((0x1241  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST11                         (0x1242)
#define P_VDIN_DNLP_HIST11                         (volatile uint32_t *)((0x1242  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST12                         (0x1243)
#define P_VDIN_DNLP_HIST12                         (volatile uint32_t *)((0x1243  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST13                         (0x1244)
#define P_VDIN_DNLP_HIST13                         (volatile uint32_t *)((0x1244  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST14                         (0x1245)
#define P_VDIN_DNLP_HIST14                         (volatile uint32_t *)((0x1245  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST15                         (0x1246)
#define P_VDIN_DNLP_HIST15                         (volatile uint32_t *)((0x1246  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST16                         (0x1247)
#define P_VDIN_DNLP_HIST16                         (volatile uint32_t *)((0x1247  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST17                         (0x1248)
#define P_VDIN_DNLP_HIST17                         (volatile uint32_t *)((0x1248  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST18                         (0x1249)
#define P_VDIN_DNLP_HIST18                         (volatile uint32_t *)((0x1249  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST19                         (0x124a)
#define P_VDIN_DNLP_HIST19                         (volatile uint32_t *)((0x124a  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST20                         (0x124b)
#define P_VDIN_DNLP_HIST20                         (volatile uint32_t *)((0x124b  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST21                         (0x124c)
#define P_VDIN_DNLP_HIST21                         (volatile uint32_t *)((0x124c  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST22                         (0x124d)
#define P_VDIN_DNLP_HIST22                         (volatile uint32_t *)((0x124d  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST23                         (0x124e)
#define P_VDIN_DNLP_HIST23                         (volatile uint32_t *)((0x124e  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST24                         (0x124f)
#define P_VDIN_DNLP_HIST24                         (volatile uint32_t *)((0x124f  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST25                         (0x1250)
#define P_VDIN_DNLP_HIST25                         (volatile uint32_t *)((0x1250  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST26                         (0x1251)
#define P_VDIN_DNLP_HIST26                         (volatile uint32_t *)((0x1251  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST27                         (0x1252)
#define P_VDIN_DNLP_HIST27                         (volatile uint32_t *)((0x1252  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST28                         (0x1253)
#define P_VDIN_DNLP_HIST28                         (volatile uint32_t *)((0x1253  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST29                         (0x1254)
#define P_VDIN_DNLP_HIST29                         (volatile uint32_t *)((0x1254  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST30                         (0x1255)
#define P_VDIN_DNLP_HIST30                         (volatile uint32_t *)((0x1255  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST31                         (0x1256)
#define P_VDIN_DNLP_HIST31                         (volatile uint32_t *)((0x1256  << 2) + 0xff900000)
//Bit 31, local dimming statistic enable
//Bit 28, eol enable
//Bit 27:25, vertical line overlap number for max finding
//Bit 24:22, horizontal pixel overlap number, 0: 17 pix, 1: 9 pix, 2: 5 pix, 3: 3 pix, 4: 0 pix
//Bit 20, 1,2,1 low pass filter enable before max/hist statistic
//Bit 19:16, region H/V position index, refer to VDIN_LDIM_STTS_HIST_SET_REGION
//Bit 15, 1: region read index auto increase per read to VDIN_LDIM_STTS_HIST_READ_REGION
//Bit 6:0, region read index
#define   VDIN_LDIM_STTS_HIST_REGION_IDX           (0x1257)
#define P_VDIN_LDIM_STTS_HIST_REGION_IDX           (volatile uint32_t *)((0x1257  << 2) + 0xff900000)
//Bit 28:0, if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h0: read/write hvstart0
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h1: read/write hend01
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h2: read/write vend01
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h3: read/write hend23
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h4: read/write vend23
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h5: read/write hend45
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h6: read/write vend45
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'd7: read/write hend67
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h8: read/write vend67
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h9: read/write hend89
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'ha: read/write vend89
//hvstart0, Bit 28:16 row0 vstart, Bit 12:0 col0 hstart
//hend01, Bit 28:16 col1 hend, Bit 12:0 col0 hend
//vend01, Bit 28:16 row1 vend, Bit 12:0 row0 vend
//hend23, Bit 28:16 col3 hend, Bit 12:0 col2 hend
//vend23, Bit 28:16 row3 vend, Bit 12:0 row2 vend
//hend45, Bit 28:16 col5 hend, Bit 12:0 col4 hend
//vend45, Bit 28:16 row5 vend, Bit 12:0 row4 vend
//hend67, Bit 28:16 col7 hend, Bit 12:0 col6 hend
//vend67, Bit 28:16 row7 vend, Bit 12:0 row6 vend
//hend89, Bit 28:16 col9 hend, Bit 12:0 col8 hend
//vend89, Bit 28:16 row9 vend, Bit 12:0 row8 vend
#define   VDIN_LDIM_STTS_HIST_SET_REGION           (0x1258)
#define P_VDIN_LDIM_STTS_HIST_SET_REGION           (volatile uint32_t *)((0x1258  << 2) + 0xff900000)
//REGION STATISTIC DATA READ OUT PORT, bit 29:20 max_comp2, bit 19:10 max_comp1, bit 9:0 max_comp0
#define   VDIN_LDIM_STTS_HIST_READ_REGION          (0x1259)
#define P_VDIN_LDIM_STTS_HIST_READ_REGION          (volatile uint32_t *)((0x1259  << 2) + 0xff900000)
//Bit 18, reset bit, high active
//Bit 17, if true, widen hs/vs pulse
//Bit 16  vsync total counter always accumulating enable
//Bit 14:12, select hs/vs of video input channel to measure, 0: no selection, 1: vdi1, 2: vid2, 3: vid3, 4:vid4, 5:vdi5, 6:vid6, 7:vdi7, 8: vdi8
//Bit 11:4, vsync_span, define how many vsync span need to measure
//Bit 2:0  meas_hs_index, index to select which HS counter/range
#define   VDIN_MEAS_CTRL0                          (0x125a)
#define P_VDIN_MEAS_CTRL0                          (volatile uint32_t *)((0x125a  << 2) + 0xff900000)
//Read only
//19:16     meas_ind_total_count_n, every number of sync_span vsyncs, this count add 1
//15:0      high bit portion of vsync total counter
#define   VDIN_MEAS_VS_COUNT_HI                    (0x125b)
#define P_VDIN_MEAS_VS_COUNT_HI                    (volatile uint32_t *)((0x125b  << 2) + 0xff900000)
//Read only
//31:0, low bit portion of vsync total counter
#define   VDIN_MEAS_VS_COUNT_LO                    (0x125c)
#define P_VDIN_MEAS_VS_COUNT_LO                    (volatile uint32_t *)((0x125c  << 2) + 0xff900000)
//according to the meas_hs_index in register VDIN_MEAS_CTRL0
//meas_hs_index == 0, first hs range
//meas_hs_index == 1, second hs range
//meas_hs_index == 2, third hs range
//meas_hs_index == 3, fourth hs range
//bit 28:16 count_start
//bit 12:0 count_end
#define   VDIN_MEAS_HS_RANGE                       (0x125d)
#define P_VDIN_MEAS_HS_RANGE                       (volatile uint32_t *)((0x125d  << 2) + 0xff900000)
//Read only
//according to the meas_hs_index in register VDIN_MEAS_CTRL0,
//meas_hs_index == 0, first range hs counter,
//meas_hs_index == 1, second range hs coutner
//meas_hs_index == 2, third range hs coutner
//meas_hs_index == 3, fourth range hs coutner
//23:0
#define   VDIN_MEAS_HS_COUNT                       (0x125e)
#define P_VDIN_MEAS_HS_COUNT                       (volatile uint32_t *)((0x125e  << 2) + 0xff900000)
//Bit 8      white_enable
//Bit 7:0    blkbar_white_level
#define   VDIN_BLKBAR_CTRL1                        (0x125f)
#define P_VDIN_BLKBAR_CTRL1                        (volatile uint32_t *)((0x125f  << 2) + 0xff900000)
// Bit 31:24 blkbar_black_level    threshold to judge a black point
// Bit 23:21 Reserved
// Bit 20:8  blkbar_hwidth         left and right region width
// Bit 7:5   blkbar_comp_sel       select yin or uin or vin to be the valid input
// Bit 4     blkbar_sw_statistic_en enable software statistic of each block black points number
// Bit 3     blkbar_det_en
// Bit 2:1   blkbar_din_sel
// bit blkbar_det_top_en
#define   VDIN_BLKBAR_CTRL0                        (0x1260)
#define P_VDIN_BLKBAR_CTRL0                        (volatile uint32_t *)((0x1260  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 blkbar_hstart.        Left region start
// Bit 15:13 Reserved
// Bit 12:0  blkbar_hend.          Right region end
#define   VDIN_BLKBAR_H_START_END                  (0x1261)
#define P_VDIN_BLKBAR_H_START_END                  (volatile uint32_t *)((0x1261  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 blkbar_vstart
// Bit 15:13 Reserved
// Bit 12:0  blkbar_vend
#define   VDIN_BLKBAR_V_START_END                  (0x1262)
#define P_VDIN_BLKBAR_V_START_END                  (volatile uint32_t *)((0x1262  << 2) + 0xff900000)
// Bit 31:20 Reserved
// Bit 19:0  blkbar_cnt_threshold. threshold to judge whether a block is totally black
#define   VDIN_BLKBAR_CNT_THRESHOLD                (0x1263)
#define P_VDIN_BLKBAR_CNT_THRESHOLD                (volatile uint32_t *)((0x1263  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 blkbar_row_th1.       //threshold of the top blackbar
// Bit 15:13 Reserved
// bit 12:0  blkbar_row_th2        //threshold of the bottom blackbar
#define   VDIN_BLKBAR_ROW_TH1_TH2                  (0x1264)
#define P_VDIN_BLKBAR_ROW_TH1_TH2                  (volatile uint32_t *)((0x1264  << 2) + 0xff900000)
//Readonly
// Bit 31:29 Reserved
// Bit 28:16 blkbar_ind_left_start. horizontal start of the left region in the current searching
// Bit 15:13 Reserved
// Bit 12:0  blkbar_ind_left_end.   horizontal end of the left region in the current searching
#define   VDIN_BLKBAR_IND_LEFT_START_END           (0x1265)
#define P_VDIN_BLKBAR_IND_LEFT_START_END           (volatile uint32_t *)((0x1265  << 2) + 0xff900000)
//Readonly
// Bit 31:29 Reserved
// Bit 28:16 blkbar_ind_right_start.horizontal start of the right region in the current searching
// Bit 15:13 Reserved
// Bit 12:0  blkbar_ind_right_end.  horizontal end of the right region in the current searching
#define   VDIN_BLKBAR_IND_RIGHT_START_END          (0x1266)
#define P_VDIN_BLKBAR_IND_RIGHT_START_END          (volatile uint32_t *)((0x1266  << 2) + 0xff900000)
//Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_left1_cnt.  Black pixel counter. left part of the left region
#define   VDIN_BLKBAR_IND_LEFT1_CNT                (0x1267)
#define P_VDIN_BLKBAR_IND_LEFT1_CNT                (volatile uint32_t *)((0x1267  << 2) + 0xff900000)
//Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_left2_cnt.  Black pixel counter. right part of the left region
#define   VDIN_BLKBAR_IND_LEFT2_CNT                (0x1268)
#define P_VDIN_BLKBAR_IND_LEFT2_CNT                (volatile uint32_t *)((0x1268  << 2) + 0xff900000)
//Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_right1_cnt. Black pixel counter. left part of the right region
#define   VDIN_BLKBAR_IND_RIGHT1_CNT               (0x1269)
#define P_VDIN_BLKBAR_IND_RIGHT1_CNT               (volatile uint32_t *)((0x1269  << 2) + 0xff900000)
//Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_right2_cnt. Black pixel counter. right part of the right region
#define   VDIN_BLKBAR_IND_RIGHT2_CNT               (0x126a)
#define P_VDIN_BLKBAR_IND_RIGHT2_CNT               (volatile uint32_t *)((0x126a  << 2) + 0xff900000)
//Readonly
// Bit 31:30 Reserved
// Bit 29    blkbar_ind_black_det_done. LEFT/RIGHT Black detection done
// Bit 28:16 blkbar_top_pos.            Top black bar position
// Bit 15:13 Reserved.
// Bit 12:0  blkbar_bot_pos.            Bottom black bar position
#define   VDIN_BLKBAR_STATUS0                      (0x126b)
#define P_VDIN_BLKBAR_STATUS0                      (volatile uint32_t *)((0x126b  << 2) + 0xff900000)
//Readonly
// Bit 31:29 Reserved
// Bit 28:16 blkbar_left_pos.       Left black bar position
// Bit 15:13 Reserved
// Bit 12:0  blkbar_right_pos.      Right black bar position
#define   VDIN_BLKBAR_STATUS1                      (0x126c)
#define P_VDIN_BLKBAR_STATUS1                      (volatile uint32_t *)((0x126c  << 2) + 0xff900000)
//Bit 28:16 input window H start
//Bit 12:0  input window H end
#define   VDIN_WIN_H_START_END                     (0x126d)
#define P_VDIN_WIN_H_START_END                     (volatile uint32_t *)((0x126d  << 2) + 0xff900000)
//Bit 28:16 input window H start
//Bit 12:0  input window V start
#define   VDIN_WIN_V_START_END                     (0x126e)
#define P_VDIN_WIN_V_START_END                     (volatile uint32_t *)((0x126e  << 2) + 0xff900000)
//Bit 23:16 vdi8 asfifo_ctrl
//Bit 15:8 vdi7 asfifo_ctrl
//Bit 7:0 vdi6 asfifo_ctrl
#define   VDIN_ASFIFO_CTRL3                        (0x126f)
#define P_VDIN_ASFIFO_CTRL3                        (volatile uint32_t *)((0x126f  << 2) + 0xff900000)
//Bit 3:2 vshrk_clk2_ctrl
//Bit 1:0 vshrk_clk1_ctrl
#define   VDIN_COM_GCLK_CTRL2                      (0x1270)
#define P_VDIN_COM_GCLK_CTRL2                      (volatile uint32_t *)((0x1270  << 2) + 0xff900000)
//Bit 27 vshrk_en
//Bit 26:25 vshrk_mode
//Bit 24 vshrk_lpf_mode
//Bit 23:0 vshrk_dummy
#define   VDIN_VSHRK_CTRL                          (0x1271)
#define P_VDIN_VSHRK_CTRL                          (volatile uint32_t *)((0x1271  << 2) + 0xff900000)
#define   VDIN_DNLP_HIST32                         (0x1272)
#define P_VDIN_DNLP_HIST32                         (volatile uint32_t *)((0x1272  << 2) + 0xff900000)
//Read only
//Bit 7, vdi9 fifo overflow
//Bit 5:0, vdi9_asfifo_cnt
#define   VDIN_COM_STATUS3                         (0x1273)
#define P_VDIN_COM_STATUS3                         (volatile uint32_t *)((0x1273  << 2) + 0xff900000)
#define   VDIN_SYNC_MASK                           (0x1274)
#define P_VDIN_SYNC_MASK                           (volatile uint32_t *)((0x1274  << 2) + 0xff900000)
//Bit 7:0,  hsync_mask_num
//Bit 15:8, vsync_mask_num
//Bit 16,   hsync_mask_enable
//Bit 17,   vsync_mask_num
//dolby vdin
#define   VDIN_DOLBY_DSC_CTRL0                     (0x1275)
#define P_VDIN_DOLBY_DSC_CTRL0                     (volatile uint32_t *)((0x1275  << 2) + 0xff900000)
#define   VDIN_DOLBY_DSC_CTRL1                     (0x1276)
#define P_VDIN_DOLBY_DSC_CTRL1                     (volatile uint32_t *)((0x1276  << 2) + 0xff900000)
#define   VDIN_DOLBY_DSC_CTRL2                     (0x1277)
#define P_VDIN_DOLBY_DSC_CTRL2                     (volatile uint32_t *)((0x1277  << 2) + 0xff900000)
#define   VDIN_DOLBY_DSC_CTRL3                     (0x1278)
#define P_VDIN_DOLBY_DSC_CTRL3                     (volatile uint32_t *)((0x1278  << 2) + 0xff900000)
#define   VDIN_DOLBY_AXI_CTRL0                     (0x1279)
#define P_VDIN_DOLBY_AXI_CTRL0                     (volatile uint32_t *)((0x1279  << 2) + 0xff900000)
#define   VDIN_DOLBY_AXI_CTRL1                     (0x127a)
#define P_VDIN_DOLBY_AXI_CTRL1                     (volatile uint32_t *)((0x127a  << 2) + 0xff900000)
#define   VDIN_DOLBY_AXI_CTRL2                     (0x127b)
#define P_VDIN_DOLBY_AXI_CTRL2                     (volatile uint32_t *)((0x127b  << 2) + 0xff900000)
#define   VDIN_DOLBY_AXI_CTRL3                     (0x127c)
#define P_VDIN_DOLBY_AXI_CTRL3                     (volatile uint32_t *)((0x127c  << 2) + 0xff900000)
#define   VDIN_DOLBY_DSC_STATUS0                   (0x127d)
#define P_VDIN_DOLBY_DSC_STATUS0                   (volatile uint32_t *)((0x127d  << 2) + 0xff900000)
#define   VDIN_DOLBY_DSC_STATUS1                   (0x127e)
#define P_VDIN_DOLBY_DSC_STATUS1                   (volatile uint32_t *)((0x127e  << 2) + 0xff900000)
#define   VDIN_DOLBY_DSC_STATUS2                   (0x127f)
#define P_VDIN_DOLBY_DSC_STATUS2                   (volatile uint32_t *)((0x127f  << 2) + 0xff900000)
#define   VDIN_DOLBY_DSC_STATUS3                   (0x121d)
#define P_VDIN_DOLBY_DSC_STATUS3                   (volatile uint32_t *)((0x121d  << 2) + 0xff900000)

//8'h72 occupied by histogram 32
//VDIN0        8'h00 - 8'h7f
#define VDIN0_SCALE_COEF_IDX                    ((VDIN0_OFFSET << 2) + VDIN_SCALE_COEF_IDX               )
#define VDIN0_SCALE_COEF                        ((VDIN0_OFFSET << 2) + VDIN_SCALE_COEF                   )
#define VDIN0_COM_CTRL0                         ((VDIN0_OFFSET << 2) + VDIN_COM_CTRL0                    )
#define VDIN0_ACTIVE_MAX_PIX_CNT_STATUS         ((VDIN0_OFFSET << 2) + VDIN_ACTIVE_MAX_PIX_CNT_STATUS    )
#define VDIN0_LCNT_STATUS                       ((VDIN0_OFFSET << 2) + VDIN_LCNT_STATUS                  )
#define VDIN0_COM_STATUS0                       ((VDIN0_OFFSET << 2) + VDIN_COM_STATUS0                  )
#define VDIN0_COM_STATUS1                       ((VDIN0_OFFSET << 2) + VDIN_COM_STATUS1                  )
#define VDIN0_LCNT_SHADOW_STATUS                ((VDIN0_OFFSET << 2) + VDIN_LCNT_SHADOW_STATUS           )
#define VDIN0_ASFIFO_CTRL0                      ((VDIN0_OFFSET << 2) + VDIN_ASFIFO_CTRL0                 )
#define VDIN0_ASFIFO_CTRL1                      ((VDIN0_OFFSET << 2) + VDIN_ASFIFO_CTRL1                 )
#define VDIN0_WIDTHM1I_WIDTHM1O                 ((VDIN0_OFFSET << 2) + VDIN_WIDTHM1I_WIDTHM1O            )
#define VDIN0_SC_MISC_CTRL                      ((VDIN0_OFFSET << 2) + VDIN_SC_MISC_CTRL                 )
#define VDIN0_HSC_PHASE_STEP                    ((VDIN0_OFFSET << 2) + VDIN_HSC_PHASE_STEP               )
#define VDIN0_HSC_INI_CTRL                      ((VDIN0_OFFSET << 2) + VDIN_HSC_INI_CTRL                 )
#define VDIN0_COM_STATUS2                       ((VDIN0_OFFSET << 2) + VDIN_COM_STATUS2                  )
#define VDIN0_COM_STATUS3                       ((VDIN0_OFFSET << 2) + VDIN_COM_STATUS3                  )
#define VDIN0_ASFIFO_CTRL2                      ((VDIN0_OFFSET << 2) + VDIN_ASFIFO_CTRL2                 )
#define VDIN0_MATRIX_CTRL                       ((VDIN0_OFFSET << 2) + VDIN_MATRIX_CTRL                  )
#define VDIN0_MATRIX_COEF00_01                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_COEF00_01             )
#define VDIN0_MATRIX_COEF02_10                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_COEF02_10             )
#define VDIN0_MATRIX_COEF11_12                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_COEF11_12             )
#define VDIN0_MATRIX_COEF20_21                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_COEF20_21             )
#define VDIN0_MATRIX_COEF22                     ((VDIN0_OFFSET << 2) + VDIN_MATRIX_COEF22                )
#define VDIN0_MATRIX_OFFSET0_1                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_OFFSET0_1             )
#define VDIN0_MATRIX_OFFSET2                    ((VDIN0_OFFSET << 2) + VDIN_MATRIX_OFFSET2               )
#define VDIN0_MATRIX_PRE_OFFSET0_1              ((VDIN0_OFFSET << 2) + VDIN_MATRIX_PRE_OFFSET0_1         )
#define VDIN0_MATRIX_PRE_OFFSET2                ((VDIN0_OFFSET << 2) + VDIN_MATRIX_PRE_OFFSET2           )
#define VDIN0_LFIFO_CTRL                        ((VDIN0_OFFSET << 2) + VDIN_LFIFO_CTRL                   )
#define VDIN0_COM_GCLK_CTRL                     ((VDIN0_OFFSET << 2) + VDIN_COM_GCLK_CTRL                )
#define VDIN0_INTF_WIDTHM1                      ((VDIN0_OFFSET << 2) + VDIN_INTF_WIDTHM1                 )
#define VDIN0_WR_CTRL2                          ((VDIN0_OFFSET << 2) + VDIN_WR_CTRL2                     )
#define VDIN0_WR_CTRL                           ((VDIN0_OFFSET << 2) + VDIN_WR_CTRL                      )
#define VDIN0_WR_H_START_END                    ((VDIN0_OFFSET << 2) + VDIN_WR_H_START_END               )
#define VDIN0_WR_V_START_END                    ((VDIN0_OFFSET << 2) + VDIN_WR_V_START_END               )
#define VDIN0_VSC_PHASE_STEP                    ((VDIN0_OFFSET << 2) + VDIN_VSC_PHASE_STEP               )
#define VDIN0_VSC_INI_CTRL                      ((VDIN0_OFFSET << 2) + VDIN_VSC_INI_CTRL                 )
#define VDIN0_SCIN_HEIGHTM1                     ((VDIN0_OFFSET << 2) + VDIN_SCIN_HEIGHTM1                )
#define VDIN0_DUMMY_DATA                        ((VDIN0_OFFSET << 2) + VDIN_DUMMY_DATA                   )
#define VDIN0_MATRIX_PROBE_COLOR                ((VDIN0_OFFSET << 2) + VDIN_MATRIX_PROBE_COLOR           )
#define VDIN0_MATRIX_HL_COLOR                   ((VDIN0_OFFSET << 2) + VDIN_MATRIX_HL_COLOR              )
#define VDIN0_MATRIX_PROBE_POS                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_PROBE_POS             )
#define VDIN0_CHROMA_ADDR_PORT                  ((VDIN0_OFFSET << 2) + VDIN_CHROMA_ADDR_PORT             )
#define VDIN0_CHROMA_DATA_PORT                  ((VDIN0_OFFSET << 2) + VDIN_CHROMA_DATA_PORT             )
#define VDIN0_CM_BRI_CON_CTRL                   ((VDIN0_OFFSET << 2) + VDIN_CM_BRI_CON_CTRL              )
#define VDIN0_HIST_CTRL                         ((VDIN0_OFFSET << 2) + VDIN_HIST_CTRL                    )
#define VDIN0_HIST_H_START_END                  ((VDIN0_OFFSET << 2) + VDIN_HIST_H_START_END             )
#define VDIN0_HIST_V_START_END                  ((VDIN0_OFFSET << 2) + VDIN_HIST_V_START_END             )
#define VDIN0_HIST_MAX_MIN                      ((VDIN0_OFFSET << 2) + VDIN_HIST_MAX_MIN                 )
#define VDIN0_HIST_SPL_VAL                      ((VDIN0_OFFSET << 2) + VDIN_HIST_SPL_VAL                 )
#define VDIN0_HIST_SPL_PIX_CNT                  ((VDIN0_OFFSET << 2) + VDIN_HIST_SPL_PIX_CNT             )
#define VDIN0_HIST_CHROMA_SUM                   ((VDIN0_OFFSET << 2) + VDIN_HIST_CHROMA_SUM              )
#define VDIN0_DNLP_HIST00                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST00                  )
#define VDIN0_DNLP_HIST01                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST01                  )
#define VDIN0_DNLP_HIST02                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST02                  )
#define VDIN0_DNLP_HIST03                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST03                  )
#define VDIN0_DNLP_HIST04                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST04                  )
#define VDIN0_DNLP_HIST05                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST05                  )
#define VDIN0_DNLP_HIST06                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST06                  )
#define VDIN0_DNLP_HIST07                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST07                  )
#define VDIN0_DNLP_HIST08                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST08                  )
#define VDIN0_DNLP_HIST09                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST09                  )
#define VDIN0_DNLP_HIST10                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST10                  )
#define VDIN0_DNLP_HIST11                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST11                  )
#define VDIN0_DNLP_HIST12                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST12                  )
#define VDIN0_DNLP_HIST13                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST13                  )
#define VDIN0_DNLP_HIST14                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST14                  )
#define VDIN0_DNLP_HIST15                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST15                  )
#define VDIN0_DNLP_HIST16                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST16                  )
#define VDIN0_DNLP_HIST17                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST17                  )
#define VDIN0_DNLP_HIST18                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST18                  )
#define VDIN0_DNLP_HIST19                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST19                  )
#define VDIN0_DNLP_HIST20                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST20                  )
#define VDIN0_DNLP_HIST21                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST21                  )
#define VDIN0_DNLP_HIST22                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST22                  )
#define VDIN0_DNLP_HIST23                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST23                  )
#define VDIN0_DNLP_HIST24                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST24                  )
#define VDIN0_DNLP_HIST25                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST25                  )
#define VDIN0_DNLP_HIST26                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST26                  )
#define VDIN0_DNLP_HIST27                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST27                  )
#define VDIN0_DNLP_HIST28                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST28                  )
#define VDIN0_DNLP_HIST29                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST29                  )
#define VDIN0_DNLP_HIST30                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST30                  )
#define VDIN0_DNLP_HIST31                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST31                  )
#define VDIN0_DNLP_HIST32                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST32                  )
#define VDIN0_LDIM_STTS_HIST_REGION_IDX         ((VDIN0_OFFSET << 2) + VDIN_LDIM_STTS_HIST_REGION_IDX    )
#define VDIN0_LDIM_STTS_HIST_SET_REGION         ((VDIN0_OFFSET << 2) + VDIN_LDIM_STTS_HIST_SET_REGION    )
#define VDIN0_LDIM_STTS_HIST_READ_REGION        ((VDIN0_OFFSET << 2) + VDIN_LDIM_STTS_HIST_READ_REGION   )
#define VDIN0_MEAS_CTRL0                        ((VDIN0_OFFSET << 2) + VDIN_MEAS_CTRL0                   )
#define VDIN0_MEAS_VS_COUNT_HI                  ((VDIN0_OFFSET << 2) + VDIN_MEAS_VS_COUNT_HI             )
#define VDIN0_MEAS_VS_COUNT_LO                  ((VDIN0_OFFSET << 2) + VDIN_MEAS_VS_COUNT_LO             )
#define VDIN0_MEAS_HS_RANGE                     ((VDIN0_OFFSET << 2) + VDIN_MEAS_HS_RANGE                )
#define VDIN0_MEAS_HS_COUNT                     ((VDIN0_OFFSET << 2) + VDIN_MEAS_HS_COUNT                )
#define VDIN0_BLKBAR_CTRL1                      ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_CTRL1                 )
#define VDIN0_BLKBAR_CTRL0                      ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_CTRL0                 )
#define VDIN0_BLKBAR_H_START_END                ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_H_START_END           )
#define VDIN0_BLKBAR_V_START_END                ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_V_START_END           )
#define VDIN0_BLKBAR_CNT_THRESHOLD              ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_CNT_THRESHOLD         )
#define VDIN0_BLKBAR_ROW_TH1_TH2                ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_ROW_TH1_TH2           )
#define VDIN0_BLKBAR_IND_LEFT_START_END         ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT_START_END    )
#define VDIN0_BLKBAR_IND_RIGHT_START_END        ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT_START_END   )
#define VDIN0_BLKBAR_IND_LEFT1_CNT              ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT1_CNT         )
#define VDIN0_BLKBAR_IND_LEFT2_CNT              ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT2_CNT         )
#define VDIN0_BLKBAR_IND_RIGHT1_CNT             ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT1_CNT        )
#define VDIN0_BLKBAR_IND_RIGHT2_CNT             ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT2_CNT        )
#define VDIN0_BLKBAR_STATUS0                    ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_STATUS0               )
#define VDIN0_BLKBAR_STATUS1                    ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_STATUS1               )
#define VDIN0_WIN_H_START_END                   ((VDIN0_OFFSET << 2) + VDIN_WIN_H_START_END              )
#define VDIN0_WIN_V_START_END                   ((VDIN0_OFFSET << 2) + VDIN_WIN_V_START_END              )
#define VDIN0_ASFIFO_CTRL3                      ((VDIN0_OFFSET << 2) + VDIN_ASFIFO_CTRL3                 )
#define VDIN0_COM_GCLK_CTRL2                    ((VDIN0_OFFSET << 2) + VDIN_COM_GCLK_CTRL2               )
#define VDIN0_VSHRK_CTRL                        ((VDIN0_OFFSET << 2) + VDIN_VSHRK_CTRL                   )
#define VDIN0_SYNC_MASK                         ((VDIN0_OFFSET << 2) + VDIN_SYNC_MASK                    )
#define VDIN0_DOLBY_DSC_CTRL0                    ((VDIN0_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL0  )
#define VDIN0_DOLBY_DSC_CTRL1                    ((VDIN0_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL1  )
#define VDIN0_DOLBY_DSC_CTRL2                    ((VDIN0_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL2  )
#define VDIN0_DOLBY_DSC_CTRL3                    ((VDIN0_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL3  )
#define VDIN0_DOLBY_AXI_CTRL0                    ((VDIN0_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL0  )
#define VDIN0_DOLBY_AXI_CTRL1                    ((VDIN0_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL1  )
#define VDIN0_DOLBY_AXI_CTRL2                    ((VDIN0_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL2  )
#define VDIN0_DOLBY_AXI_CTRL3                    ((VDIN0_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL3  )
#define VDIN0_DOLBY_DSC_STATUS0                  ((VDIN0_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS0)
#define VDIN0_DOLBY_DSC_STATUS1                  ((VDIN0_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS1)
#define VDIN0_DOLBY_DSC_STATUS2                  ((VDIN0_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS2)
#define VDIN0_DOLBY_DSC_STATUS3                  ((VDIN0_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS3)


//VDIN1        8'h80 - 8'hef
#define VDIN1_SCALE_COEF_IDX                    ((VDIN1_OFFSET << 2) + VDIN_SCALE_COEF_IDX               )
#define VDIN1_SCALE_COEF                        ((VDIN1_OFFSET << 2) + VDIN_SCALE_COEF                   )
#define VDIN1_COM_CTRL0                         ((VDIN1_OFFSET << 2) + VDIN_COM_CTRL0                    )
#define VDIN1_ACTIVE_MAX_PIX_CNT_STATUS         ((VDIN1_OFFSET << 2) + VDIN_ACTIVE_MAX_PIX_CNT_STATUS    )
#define VDIN1_LCNT_STATUS                       ((VDIN1_OFFSET << 2) + VDIN_LCNT_STATUS                  )
#define VDIN1_COM_STATUS0                       ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS0                  )
#define VDIN1_COM_STATUS1                       ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS1                  )
#define VDIN1_LCNT_SHADOW_STATUS                ((VDIN1_OFFSET << 2) + VDIN_LCNT_SHADOW_STATUS           )
#define VDIN1_ASFIFO_CTRL0                      ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL0                 )
#define VDIN1_ASFIFO_CTRL1                      ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL1                 )
#define VDIN1_WIDTHM1I_WIDTHM1O                 ((VDIN1_OFFSET << 2) + VDIN_WIDTHM1I_WIDTHM1O            )
#define VDIN1_SC_MISC_CTRL                      ((VDIN1_OFFSET << 2) + VDIN_SC_MISC_CTRL                 )
#define VDIN1_HSC_PHASE_STEP                    ((VDIN1_OFFSET << 2) + VDIN_HSC_PHASE_STEP               )
#define VDIN1_HSC_INI_CTRL                      ((VDIN1_OFFSET << 2) + VDIN_HSC_INI_CTRL                 )
#define VDIN1_COM_STATUS2                       ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS2                  )
#define VDIN1_COM_STATUS3                       ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS3                  )
#define VDIN1_ASFIFO_CTRL2                      ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL2                 )
#define VDIN1_MATRIX_CTRL                       ((VDIN1_OFFSET << 2) + VDIN_MATRIX_CTRL                  )
#define VDIN1_MATRIX_COEF00_01                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF00_01             )
#define VDIN1_MATRIX_COEF02_10                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF02_10             )
#define VDIN1_MATRIX_COEF11_12                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF11_12             )
#define VDIN1_MATRIX_COEF20_21                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF20_21             )
#define VDIN1_MATRIX_COEF22                     ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF22                )
#define VDIN1_MATRIX_OFFSET0_1                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_OFFSET0_1             )
#define VDIN1_MATRIX_OFFSET2                    ((VDIN1_OFFSET << 2) + VDIN_MATRIX_OFFSET2               )
#define VDIN1_MATRIX_PRE_OFFSET0_1              ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PRE_OFFSET0_1         )
#define VDIN1_MATRIX_PRE_OFFSET2                ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PRE_OFFSET2           )
#define VDIN1_LFIFO_CTRL                        ((VDIN1_OFFSET << 2) + VDIN_LFIFO_CTRL                   )
#define VDIN1_COM_GCLK_CTRL                     ((VDIN1_OFFSET << 2) + VDIN_COM_GCLK_CTRL                )
#define VDIN1_INTF_WIDTHM1                      ((VDIN1_OFFSET << 2) + VDIN_INTF_WIDTHM1                 )
#define VDIN1_WR_CTRL2                          ((VDIN1_OFFSET << 2) + VDIN_WR_CTRL2                     )
#define VDIN1_WR_CTRL                           ((VDIN1_OFFSET << 2) + VDIN_WR_CTRL                      )
#define VDIN1_WR_H_START_END                    ((VDIN1_OFFSET << 2) + VDIN_WR_H_START_END               )
#define VDIN1_WR_V_START_END                    ((VDIN1_OFFSET << 2) + VDIN_WR_V_START_END               )
#define VDIN1_VSC_PHASE_STEP                    ((VDIN1_OFFSET << 2) + VDIN_VSC_PHASE_STEP               )
#define VDIN1_VSC_INI_CTRL                      ((VDIN1_OFFSET << 2) + VDIN_VSC_INI_CTRL                 )
#define VDIN1_SCIN_HEIGHTM1                     ((VDIN1_OFFSET << 2) + VDIN_SCIN_HEIGHTM1                )
#define VDIN1_DUMMY_DATA                        ((VDIN1_OFFSET << 2) + VDIN_DUMMY_DATA                   )
#define VDIN1_MATRIX_PROBE_COLOR                ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PROBE_COLOR           )
#define VDIN1_MATRIX_HL_COLOR                   ((VDIN1_OFFSET << 2) + VDIN_MATRIX_HL_COLOR              )
#define VDIN1_MATRIX_PROBE_POS                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PROBE_POS             )
#define VDIN1_CHROMA_ADDR_PORT                  ((VDIN1_OFFSET << 2) + VDIN_CHROMA_ADDR_PORT             )
#define VDIN1_CHROMA_DATA_PORT                  ((VDIN1_OFFSET << 2) + VDIN_CHROMA_DATA_PORT             )
#define VDIN1_CM_BRI_CON_CTRL                   ((VDIN1_OFFSET << 2) + VDIN_CM_BRI_CON_CTRL              )
#define VDIN1_HIST_CTRL                         ((VDIN1_OFFSET << 2) + VDIN_HIST_CTRL                    )
#define VDIN1_HIST_H_START_END                  ((VDIN1_OFFSET << 2) + VDIN_HIST_H_START_END             )
#define VDIN1_HIST_V_START_END                  ((VDIN1_OFFSET << 2) + VDIN_HIST_V_START_END             )
#define VDIN1_HIST_MAX_MIN                      ((VDIN1_OFFSET << 2) + VDIN_HIST_MAX_MIN                 )
#define VDIN1_HIST_SPL_VAL                      ((VDIN1_OFFSET << 2) + VDIN_HIST_SPL_VAL                 )
#define VDIN1_HIST_SPL_PIX_CNT                  ((VDIN1_OFFSET << 2) + VDIN_HIST_SPL_PIX_CNT             )
#define VDIN1_HIST_CHROMA_SUM                   ((VDIN1_OFFSET << 2) + VDIN_HIST_CHROMA_SUM              )
#define VDIN1_DNLP_HIST00                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST00                  )
#define VDIN1_DNLP_HIST01                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST01                  )
#define VDIN1_DNLP_HIST02                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST02                  )
#define VDIN1_DNLP_HIST03                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST03                  )
#define VDIN1_DNLP_HIST04                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST04                  )
#define VDIN1_DNLP_HIST05                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST05                  )
#define VDIN1_DNLP_HIST06                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST06                  )
#define VDIN1_DNLP_HIST07                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST07                  )
#define VDIN1_DNLP_HIST08                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST08                  )
#define VDIN1_DNLP_HIST09                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST09                  )
#define VDIN1_DNLP_HIST10                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST10                  )
#define VDIN1_DNLP_HIST11                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST11                  )
#define VDIN1_DNLP_HIST12                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST12                  )
#define VDIN1_DNLP_HIST13                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST13                  )
#define VDIN1_DNLP_HIST14                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST14                  )
#define VDIN1_DNLP_HIST15                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST15                  )
#define VDIN1_DNLP_HIST16                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST16                  )
#define VDIN1_DNLP_HIST17                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST17                  )
#define VDIN1_DNLP_HIST18                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST18                  )
#define VDIN1_DNLP_HIST19                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST19                  )
#define VDIN1_DNLP_HIST20                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST20                  )
#define VDIN1_DNLP_HIST21                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST21                  )
#define VDIN1_DNLP_HIST22                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST22                  )
#define VDIN1_DNLP_HIST23                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST23                  )
#define VDIN1_DNLP_HIST24                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST24                  )
#define VDIN1_DNLP_HIST25                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST25                  )
#define VDIN1_DNLP_HIST26                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST26                  )
#define VDIN1_DNLP_HIST27                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST27                  )
#define VDIN1_DNLP_HIST28                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST28                  )
#define VDIN1_DNLP_HIST29                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST29                  )
#define VDIN1_DNLP_HIST30                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST30                  )
#define VDIN1_DNLP_HIST31                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST31                  )
#define VDIN1_DNLP_HIST32                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST32                  )
#define VDIN1_LDIM_STTS_HIST_REGION_IDX         ((VDIN1_OFFSET << 2) + VDIN_LDIM_STTS_HIST_REGION_IDX    )
#define VDIN1_LDIM_STTS_HIST_SET_REGION         ((VDIN1_OFFSET << 2) + VDIN_LDIM_STTS_HIST_SET_REGION    )
#define VDIN1_LDIM_STTS_HIST_READ_REGION        ((VDIN1_OFFSET << 2) + VDIN_LDIM_STTS_HIST_READ_REGION   )
#define VDIN1_MEAS_CTRL0                        ((VDIN1_OFFSET << 2) + VDIN_MEAS_CTRL0                   )
#define VDIN1_MEAS_VS_COUNT_HI                  ((VDIN1_OFFSET << 2) + VDIN_MEAS_VS_COUNT_HI             )
#define VDIN1_MEAS_VS_COUNT_LO                  ((VDIN1_OFFSET << 2) + VDIN_MEAS_VS_COUNT_LO             )
#define VDIN1_MEAS_HS_RANGE                     ((VDIN1_OFFSET << 2) + VDIN_MEAS_HS_RANGE                )
#define VDIN1_MEAS_HS_COUNT                     ((VDIN1_OFFSET << 2) + VDIN_MEAS_HS_COUNT                )
#define VDIN1_BLKBAR_CTRL1                      ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_CTRL1                 )
#define VDIN1_BLKBAR_CTRL0                      ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_CTRL0                 )
#define VDIN1_BLKBAR_H_START_END                ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_H_START_END           )
#define VDIN1_BLKBAR_V_START_END                ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_V_START_END           )
#define VDIN1_BLKBAR_CNT_THRESHOLD              ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_CNT_THRESHOLD         )
#define VDIN1_BLKBAR_ROW_TH1_TH2                ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_ROW_TH1_TH2           )
#define VDIN1_BLKBAR_IND_LEFT_START_END         ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT_START_END    )
#define VDIN1_BLKBAR_IND_RIGHT_START_END        ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT_START_END   )
#define VDIN1_BLKBAR_IND_LEFT1_CNT              ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT1_CNT         )
#define VDIN1_BLKBAR_IND_LEFT2_CNT              ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT2_CNT         )
#define VDIN1_BLKBAR_IND_RIGHT1_CNT             ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT1_CNT        )
#define VDIN1_BLKBAR_IND_RIGHT2_CNT             ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT2_CNT        )
#define VDIN1_BLKBAR_STATUS0                    ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_STATUS0               )
#define VDIN1_BLKBAR_STATUS1                    ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_STATUS1               )
#define VDIN1_WIN_H_START_END                   ((VDIN1_OFFSET << 2) + VDIN_WIN_H_START_END              )
#define VDIN1_WIN_V_START_END                   ((VDIN1_OFFSET << 2) + VDIN_WIN_V_START_END              )
#define VDIN1_ASFIFO_CTRL3                      ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL3                 )
#define VDIN1_COM_GCLK_CTRL2                    ((VDIN1_OFFSET << 2) + VDIN_COM_GCLK_CTRL2               )
#define VDIN1_VSHRK_CTRL                        ((VDIN1_OFFSET << 2) + VDIN_VSHRK_CTRL                   )
#define VDIN1_SYNC_MASK                         ((VDIN1_OFFSET << 2) + VDIN_SYNC_MASK                    )
#define VDIN1_DOLBY_DSC_CTRL0                    ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL0  )
#define VDIN1_DOLBY_DSC_CTRL1                    ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL1  )
#define VDIN1_DOLBY_DSC_CTRL2                    ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL2  )
#define VDIN1_DOLBY_DSC_CTRL3                    ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL3  )
#define VDIN1_DOLBY_AXI_CTRL0                    ((VDIN1_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL0  )
#define VDIN1_DOLBY_AXI_CTRL1                    ((VDIN1_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL1  )
#define VDIN1_DOLBY_AXI_CTRL2                    ((VDIN1_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL2  )
#define VDIN1_DOLBY_AXI_CTRL3                    ((VDIN1_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL3  )
#define VDIN1_DOLBY_DSC_STATUS0                  ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS0)
#define VDIN1_DOLBY_DSC_STATUS1                  ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS1)
#define VDIN1_DOLBY_DSC_STATUS2                  ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS2)
#define VDIN1_DOLBY_DSC_STATUS3                  ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS3)

//`define LCD_VCBUS_BASE               8'h14
//
// Reading file:  lcd_regs.h
//
// -----------------------------------------------
// CBUS_BASE:  LCD_VCBUS_BASE = 0x14
// -----------------------------------------------
//========================================================================
//LCD DRV     12'h480~12'h4ef
//=======================================================================
#define   L_GAMMA_CNTL_PORT                        (0x1400)
#define P_L_GAMMA_CNTL_PORT                        (volatile uint32_t *)((0x1400  << 2) + 0xff900000)
#define   L_GAMMA_DATA_PORT                        (0x1401)
#define P_L_GAMMA_DATA_PORT                        (volatile uint32_t *)((0x1401  << 2) + 0xff900000)
#define   L_GAMMA_ADDR_PORT                        (0x1402)
#define P_L_GAMMA_ADDR_PORT                        (volatile uint32_t *)((0x1402  << 2) + 0xff900000)
#define   L_GAMMA_VCOM_HSWITCH_ADDR                (0x1403)
#define P_L_GAMMA_VCOM_HSWITCH_ADDR                (volatile uint32_t *)((0x1403  << 2) + 0xff900000)
#define   L_RGB_BASE_ADDR                          (0x1405)
#define P_L_RGB_BASE_ADDR                          (volatile uint32_t *)((0x1405  << 2) + 0xff900000)
#define   L_RGB_COEFF_ADDR                         (0x1406)
#define P_L_RGB_COEFF_ADDR                         (volatile uint32_t *)((0x1406  << 2) + 0xff900000)
#define   L_POL_CNTL_ADDR                          (0x1407)
#define P_L_POL_CNTL_ADDR                          (volatile uint32_t *)((0x1407  << 2) + 0xff900000)
#define   L_DITH_CNTL_ADDR                         (0x1408)
#define P_L_DITH_CNTL_ADDR                         (volatile uint32_t *)((0x1408  << 2) + 0xff900000)
#define   L_GAMMA_PROBE_CTRL                       (0x1409)
#define P_L_GAMMA_PROBE_CTRL                       (volatile uint32_t *)((0x1409  << 2) + 0xff900000)
//read only
#define   L_GAMMA_PROBE_COLOR_L                    (0x140a)
#define P_L_GAMMA_PROBE_COLOR_L                    (volatile uint32_t *)((0x140a  << 2) + 0xff900000)
#define   L_GAMMA_PROBE_COLOR_H                    (0x140b)
#define P_L_GAMMA_PROBE_COLOR_H                    (volatile uint32_t *)((0x140b  << 2) + 0xff900000)
#define   L_GAMMA_PROBE_HL_COLOR                   (0x140c)
#define P_L_GAMMA_PROBE_HL_COLOR                   (volatile uint32_t *)((0x140c  << 2) + 0xff900000)
#define   L_GAMMA_PROBE_POS_X                      (0x140d)
#define P_L_GAMMA_PROBE_POS_X                      (volatile uint32_t *)((0x140d  << 2) + 0xff900000)
#define   L_GAMMA_PROBE_POS_Y                      (0x140e)
#define P_L_GAMMA_PROBE_POS_Y                      (volatile uint32_t *)((0x140e  << 2) + 0xff900000)
#define   L_STH1_HS_ADDR                           (0x1410)
#define P_L_STH1_HS_ADDR                           (volatile uint32_t *)((0x1410  << 2) + 0xff900000)
#define   L_STH1_HE_ADDR                           (0x1411)
#define P_L_STH1_HE_ADDR                           (volatile uint32_t *)((0x1411  << 2) + 0xff900000)
#define   L_STH1_VS_ADDR                           (0x1412)
#define P_L_STH1_VS_ADDR                           (volatile uint32_t *)((0x1412  << 2) + 0xff900000)
#define   L_STH1_VE_ADDR                           (0x1413)
#define P_L_STH1_VE_ADDR                           (volatile uint32_t *)((0x1413  << 2) + 0xff900000)
#define   L_STH2_HS_ADDR                           (0x1414)
#define P_L_STH2_HS_ADDR                           (volatile uint32_t *)((0x1414  << 2) + 0xff900000)
#define   L_STH2_HE_ADDR                           (0x1415)
#define P_L_STH2_HE_ADDR                           (volatile uint32_t *)((0x1415  << 2) + 0xff900000)
#define   L_STH2_VS_ADDR                           (0x1416)
#define P_L_STH2_VS_ADDR                           (volatile uint32_t *)((0x1416  << 2) + 0xff900000)
#define   L_STH2_VE_ADDR                           (0x1417)
#define P_L_STH2_VE_ADDR                           (volatile uint32_t *)((0x1417  << 2) + 0xff900000)
#define   L_OEH_HS_ADDR                            (0x1418)
#define P_L_OEH_HS_ADDR                            (volatile uint32_t *)((0x1418  << 2) + 0xff900000)
#define   L_OEH_HE_ADDR                            (0x1419)
#define P_L_OEH_HE_ADDR                            (volatile uint32_t *)((0x1419  << 2) + 0xff900000)
#define   L_OEH_VS_ADDR                            (0x141a)
#define P_L_OEH_VS_ADDR                            (volatile uint32_t *)((0x141a  << 2) + 0xff900000)
#define   L_OEH_VE_ADDR                            (0x141b)
#define P_L_OEH_VE_ADDR                            (volatile uint32_t *)((0x141b  << 2) + 0xff900000)
#define   L_VCOM_HSWITCH_ADDR                      (0x141c)
#define P_L_VCOM_HSWITCH_ADDR                      (volatile uint32_t *)((0x141c  << 2) + 0xff900000)
#define   L_VCOM_VS_ADDR                           (0x141d)
#define P_L_VCOM_VS_ADDR                           (volatile uint32_t *)((0x141d  << 2) + 0xff900000)
#define   L_VCOM_VE_ADDR                           (0x141e)
#define P_L_VCOM_VE_ADDR                           (volatile uint32_t *)((0x141e  << 2) + 0xff900000)
#define   L_CPV1_HS_ADDR                           (0x141f)
#define P_L_CPV1_HS_ADDR                           (volatile uint32_t *)((0x141f  << 2) + 0xff900000)
#define   L_CPV1_HE_ADDR                           (0x1420)
#define P_L_CPV1_HE_ADDR                           (volatile uint32_t *)((0x1420  << 2) + 0xff900000)
#define   L_CPV1_VS_ADDR                           (0x1421)
#define P_L_CPV1_VS_ADDR                           (volatile uint32_t *)((0x1421  << 2) + 0xff900000)
#define   L_CPV1_VE_ADDR                           (0x1422)
#define P_L_CPV1_VE_ADDR                           (volatile uint32_t *)((0x1422  << 2) + 0xff900000)
#define   L_CPV2_HS_ADDR                           (0x1423)
#define P_L_CPV2_HS_ADDR                           (volatile uint32_t *)((0x1423  << 2) + 0xff900000)
#define   L_CPV2_HE_ADDR                           (0x1424)
#define P_L_CPV2_HE_ADDR                           (volatile uint32_t *)((0x1424  << 2) + 0xff900000)
#define   L_CPV2_VS_ADDR                           (0x1425)
#define P_L_CPV2_VS_ADDR                           (volatile uint32_t *)((0x1425  << 2) + 0xff900000)
#define   L_CPV2_VE_ADDR                           (0x1426)
#define P_L_CPV2_VE_ADDR                           (volatile uint32_t *)((0x1426  << 2) + 0xff900000)
#define   L_STV1_HS_ADDR                           (0x1427)
#define P_L_STV1_HS_ADDR                           (volatile uint32_t *)((0x1427  << 2) + 0xff900000)
#define   L_STV1_HE_ADDR                           (0x1428)
#define P_L_STV1_HE_ADDR                           (volatile uint32_t *)((0x1428  << 2) + 0xff900000)
#define   L_STV1_VS_ADDR                           (0x1429)
#define P_L_STV1_VS_ADDR                           (volatile uint32_t *)((0x1429  << 2) + 0xff900000)
#define   L_STV1_VE_ADDR                           (0x142a)
#define P_L_STV1_VE_ADDR                           (volatile uint32_t *)((0x142a  << 2) + 0xff900000)
#define   L_STV2_HS_ADDR                           (0x142b)
#define P_L_STV2_HS_ADDR                           (volatile uint32_t *)((0x142b  << 2) + 0xff900000)
#define   L_STV2_HE_ADDR                           (0x142c)
#define P_L_STV2_HE_ADDR                           (volatile uint32_t *)((0x142c  << 2) + 0xff900000)
#define   L_STV2_VS_ADDR                           (0x142d)
#define P_L_STV2_VS_ADDR                           (volatile uint32_t *)((0x142d  << 2) + 0xff900000)
#define   L_STV2_VE_ADDR                           (0x142e)
#define P_L_STV2_VE_ADDR                           (volatile uint32_t *)((0x142e  << 2) + 0xff900000)
#define   L_OEV1_HS_ADDR                           (0x142f)
#define P_L_OEV1_HS_ADDR                           (volatile uint32_t *)((0x142f  << 2) + 0xff900000)
#define   L_OEV1_HE_ADDR                           (0x1430)
#define P_L_OEV1_HE_ADDR                           (volatile uint32_t *)((0x1430  << 2) + 0xff900000)
#define   L_OEV1_VS_ADDR                           (0x1431)
#define P_L_OEV1_VS_ADDR                           (volatile uint32_t *)((0x1431  << 2) + 0xff900000)
#define   L_OEV1_VE_ADDR                           (0x1432)
#define P_L_OEV1_VE_ADDR                           (volatile uint32_t *)((0x1432  << 2) + 0xff900000)
#define   L_OEV2_HS_ADDR                           (0x1433)
#define P_L_OEV2_HS_ADDR                           (volatile uint32_t *)((0x1433  << 2) + 0xff900000)
#define   L_OEV2_HE_ADDR                           (0x1434)
#define P_L_OEV2_HE_ADDR                           (volatile uint32_t *)((0x1434  << 2) + 0xff900000)
#define   L_OEV2_VS_ADDR                           (0x1435)
#define P_L_OEV2_VS_ADDR                           (volatile uint32_t *)((0x1435  << 2) + 0xff900000)
#define   L_OEV2_VE_ADDR                           (0x1436)
#define P_L_OEV2_VE_ADDR                           (volatile uint32_t *)((0x1436  << 2) + 0xff900000)
#define   L_OEV3_HS_ADDR                           (0x1437)
#define P_L_OEV3_HS_ADDR                           (volatile uint32_t *)((0x1437  << 2) + 0xff900000)
#define   L_OEV3_HE_ADDR                           (0x1438)
#define P_L_OEV3_HE_ADDR                           (volatile uint32_t *)((0x1438  << 2) + 0xff900000)
#define   L_OEV3_VS_ADDR                           (0x1439)
#define P_L_OEV3_VS_ADDR                           (volatile uint32_t *)((0x1439  << 2) + 0xff900000)
#define   L_OEV3_VE_ADDR                           (0x143a)
#define P_L_OEV3_VE_ADDR                           (volatile uint32_t *)((0x143a  << 2) + 0xff900000)
#define   L_LCD_PWR_ADDR                           (0x143b)
#define P_L_LCD_PWR_ADDR                           (volatile uint32_t *)((0x143b  << 2) + 0xff900000)
#define   L_LCD_PWM0_LO_ADDR                       (0x143c)
#define P_L_LCD_PWM0_LO_ADDR                       (volatile uint32_t *)((0x143c  << 2) + 0xff900000)
#define   L_LCD_PWM0_HI_ADDR                       (0x143d)
#define P_L_LCD_PWM0_HI_ADDR                       (volatile uint32_t *)((0x143d  << 2) + 0xff900000)
#define   L_LCD_PWM1_LO_ADDR                       (0x143e)
#define P_L_LCD_PWM1_LO_ADDR                       (volatile uint32_t *)((0x143e  << 2) + 0xff900000)
#define   L_LCD_PWM1_HI_ADDR                       (0x143f)
#define P_L_LCD_PWM1_HI_ADDR                       (volatile uint32_t *)((0x143f  << 2) + 0xff900000)
#define   L_INV_CNT_ADDR                           (0x1440)
#define P_L_INV_CNT_ADDR                           (volatile uint32_t *)((0x1440  << 2) + 0xff900000)
#define   L_TCON_MISC_SEL_ADDR                     (0x1441)
#define P_L_TCON_MISC_SEL_ADDR                     (volatile uint32_t *)((0x1441  << 2) + 0xff900000)
#define   L_DUAL_PORT_CNTL_ADDR                    (0x1442)
#define P_L_DUAL_PORT_CNTL_ADDR                    (volatile uint32_t *)((0x1442  << 2) + 0xff900000)
#define   MLVDS_CLK_CTL1_HI                        (0x1443)
#define P_MLVDS_CLK_CTL1_HI                        (volatile uint32_t *)((0x1443  << 2) + 0xff900000)
#define   MLVDS_CLK_CTL1_LO                        (0x1444)
#define P_MLVDS_CLK_CTL1_LO                        (volatile uint32_t *)((0x1444  << 2) + 0xff900000)
//  [31:30] enable mlvds clocks
//  [24]    mlvds_clk_half_delay       24 // Bit 0
//  [23:0]  mlvds_clk_pattern           0 // Bit 23:0
#define   L_TCON_DOUBLE_CTL                        (0x1449)
#define P_L_TCON_DOUBLE_CTL                        (volatile uint32_t *)((0x1449  << 2) + 0xff900000)
#define   L_TCON_PATTERN_HI                        (0x144a)
#define P_L_TCON_PATTERN_HI                        (volatile uint32_t *)((0x144a  << 2) + 0xff900000)
#define   L_TCON_PATTERN_LO                        (0x144b)
#define P_L_TCON_PATTERN_LO                        (volatile uint32_t *)((0x144b  << 2) + 0xff900000)
#define   LDIM_BL_ADDR_PORT                        (0x144e)
#define P_LDIM_BL_ADDR_PORT                        (volatile uint32_t *)((0x144e  << 2) + 0xff900000)
#define   LDIM_BL_DATA_PORT                        (0x144f)
#define P_LDIM_BL_DATA_PORT                        (volatile uint32_t *)((0x144f  << 2) + 0xff900000)
#define   L_DE_HS_ADDR                             (0x1451)
#define P_L_DE_HS_ADDR                             (volatile uint32_t *)((0x1451  << 2) + 0xff900000)
#define   L_DE_HE_ADDR                             (0x1452)
#define P_L_DE_HE_ADDR                             (volatile uint32_t *)((0x1452  << 2) + 0xff900000)
#define   L_DE_VS_ADDR                             (0x1453)
#define P_L_DE_VS_ADDR                             (volatile uint32_t *)((0x1453  << 2) + 0xff900000)
#define   L_DE_VE_ADDR                             (0x1454)
#define P_L_DE_VE_ADDR                             (volatile uint32_t *)((0x1454  << 2) + 0xff900000)
#define   L_HSYNC_HS_ADDR                          (0x1455)
#define P_L_HSYNC_HS_ADDR                          (volatile uint32_t *)((0x1455  << 2) + 0xff900000)
#define   L_HSYNC_HE_ADDR                          (0x1456)
#define P_L_HSYNC_HE_ADDR                          (volatile uint32_t *)((0x1456  << 2) + 0xff900000)
#define   L_HSYNC_VS_ADDR                          (0x1457)
#define P_L_HSYNC_VS_ADDR                          (volatile uint32_t *)((0x1457  << 2) + 0xff900000)
#define   L_HSYNC_VE_ADDR                          (0x1458)
#define P_L_HSYNC_VE_ADDR                          (volatile uint32_t *)((0x1458  << 2) + 0xff900000)
#define   L_VSYNC_HS_ADDR                          (0x1459)
#define P_L_VSYNC_HS_ADDR                          (volatile uint32_t *)((0x1459  << 2) + 0xff900000)
#define   L_VSYNC_HE_ADDR                          (0x145a)
#define P_L_VSYNC_HE_ADDR                          (volatile uint32_t *)((0x145a  << 2) + 0xff900000)
#define   L_VSYNC_VS_ADDR                          (0x145b)
#define P_L_VSYNC_VS_ADDR                          (volatile uint32_t *)((0x145b  << 2) + 0xff900000)
#define   L_VSYNC_VE_ADDR                          (0x145c)
#define P_L_VSYNC_VE_ADDR                          (volatile uint32_t *)((0x145c  << 2) + 0xff900000)
// bit 8 -- vfifo_mcu_enable
// bit 7 -- halt_vs_de
// bit 6 -- R8G8B8_format
// bit 5 -- R6G6B6_format (round to 6 bits)
// bit 4 -- R5G6B5_format
// bit 3 -- dac_dith_sel
// bit 2 -- lcd_mcu_enable_de     -- ReadOnly
// bit 1 -- lcd_mcu_enable_vsync  -- ReadOnly
// bit 0 -- lcd_mcu_enable
#define   L_LCD_MCU_CTL                            (0x145d)
#define P_L_LCD_MCU_CTL                            (volatile uint32_t *)((0x145d  << 2) + 0xff900000)
//**************************************************************************
//*  Dual port mLVDS registers
//**************************************************************************
// bit 3 - enable_u_dual_mlvds_dp_clk
// bit 2 - enable_u_map_mlvds_r_clk
// bit 1 - enable_u_map_mlvds_l_clk
// bit 0 - dual_mlvds_en
//`define DUAL_MLVDS_CTL                8'h60
// bit[12:0] - dual_mlvds_line_start
//`define DUAL_MLVDS_LINE_START         8'h61
// bit[12:0] - dual_mlvds_line_end
//`define DUAL_MLVDS_LINE_END           8'h62
// bit[12:0] - dual_mlvds_w_pixel_start_l
//`define DUAL_MLVDS_PIXEL_W_START_L    8'h63
// bit[12:0] - dual_mlvds_w_pixel_end_l
//`define DUAL_MLVDS_PIXEL_W_END_L      8'h64
// bit[12:0] - dual_mlvds_w_pixel_start_r
//`define DUAL_MLVDS_PIXEL_W_START_R    8'h65
// bit[12:0] - dual_mlvds_w_pixel_end_r
//`define DUAL_MLVDS_PIXEL_W_END_R      8'h66
// bit[12:0] - dual_mlvds_r_pixel_start_l
//`define DUAL_MLVDS_PIXEL_R_START_L    8'h67
// bit[12:0] - dual_mlvds_r_pixel_cnt_l
//`define DUAL_MLVDS_PIXEL_R_CNT_L      8'h68
// bit[12:0] - dual_mlvds_r_pixel_start_r
//`define DUAL_MLVDS_PIXEL_R_START_R    8'h69
// bit[12:0] - dual_mlvds_r_pixel_cnt_r
//`define DUAL_MLVDS_PIXEL_R_CNT_R      8'h6a
// bit[15]   - v_inversion_en
// bit[12:0] - v_inversion_pixel
//`define V_INVERSION_PIXEL             8'h70
// bit[15]   - v_inversion_sync_en
// bit[12:0] - v_inversion_line
//`define V_INVERSION_LINE              8'h71
// bit[15:12]  - v_loop_r
// bit[11:10]  - v_pattern_1_r
// bit[9:8]    - v_pattern_0_r
// bit[7:4]    - v_loop_l
// bit[3:2]    - v_pattern_1_l
// bit[1:0]    - v_pattern_0_l
//`define V_INVERSION_CONTROL           8'h72
//`define MLVDS2_CONTROL           8'h74
   #define     mLVDS2_RESERVED  15    // 15
   #define     mLVDS2_double_pattern  14    // 14
   #define     mLVDS2_ins_reset  8    // 13:8  // each channel has one bit
   #define     mLVDS2_dual_gate  7
   #define     mLVDS2_bit_num    6    // 0-6Bits, 1-8Bits
   #define     mLVDS2_pair_num   5    // 0-3Pairs, 1-6Pairs
   #define     mLVDS2_msb_first  4
   #define     mLVDS2_PORT_SWAP  3
   #define     mLVDS2_MLSB_SWAP  2
   #define     mLVDS2_PN_SWAP    1
   #define     mLVDS2_en         0
//`define MLVDS2_CONFIG_HI         8'h75
//`define MLVDS2_CONFIG_LO         8'h76
   #define     mLVDS2_reset_offset         29 // Bit 31:29
   #define     mLVDS2_reset_length         23 // Bit 28:23
   #define     mLVDS2_config_reserved      20 // Bit 22:20
   #define     mLVDS2_reset_start_bit12    19 // Bit 19
   #define     mLVDS2_data_write_toggle    18
   #define     mLVDS2_data_write_ini       17
   #define     mLVDS2_data_latch_1_toggle  16
   #define     mLVDS2_data_latch_1_ini     15
   #define     mLVDS2_data_latch_0_toggle  14
   #define     mLVDS2_data_latch_0_ini     13
   #define     mLVDS2_reset_1_select       12 // 0 - same as reset_0, 1 - 1 clock delay of reset_0
   #define     mLVDS2_reset_start           0 // Bit 11:0
//`define MLVDS2_DUAL_GATE_WR_START        8'h77
//   `define     mlvds2_dual_gate_wr_start    0 // Bit 12:0
//`define MLVDS2_DUAL_GATE_WR_END          8'h78
//   `define     mlvds2_dual_gate_wr_end      0 // Bit 12:0
//
//`define MLVDS2_DUAL_GATE_RD_START        8'h79
//   `define     mlvds2_dual_gate_rd_start    0 // Bit 12:0
//`define MLVDS2_DUAL_GATE_RD_END          8'h7a
//   `define     mlvds2_dual_gate_rd_end      0 // Bit 12:0
//`define MLVDS2_SECOND_RESET_CTL          8'h7b
//   `define     mLVDS2_2nd_reset_start       0 // Bit 12:0
//
//`define MLVDS2_DUAL_GATE_CTL_HI        8'h7c
//`define MLVDS2_DUAL_GATE_CTL_LO        8'h7d
//   `define     mlvds2_tcon_field_en        24 // Bit 7:0
//   `define     mlvds2_dual_gate_reserved   21 // Bit 2:0
//   `define     mlvds2_scan_mode_start_line_bit12 20 // Bit 0
//   `define     mlvds2_scan_mode_odd        16 // Bit 3:0
//   `define     mlvds2_scan_mode_even       12 // Bit 3:0
//   `define     mlvds2_scan_mode_start_line  0 // Bit 11:0
//
//`define MLVDS2_RESET_CONFIG_HI         8'h7e
//`define MLVDS2_RESET_CONFIG_LO         8'h7f
//   `define     mLVDS2_reset_range_enable   31 // Bit 0
//   `define     mLVDS2_reset_range_inv      30 // Bit 0
//   `define     mLVDS2_reset_config_res1    29 // Bit 0
//   `define     mLVDS2_reset_range_line_0   16 // Bit 11:0
//   `define     mLVDS2_reset_config_res3    13 // Bit 2:0
//   `define     mLVDS2_reset_range_line_1    0 // Bit 11:0
//
//**************************************************************************
//*  Vbyone registers  (Note: no MinLVDS in G9tv, share the register)
//**************************************************************************
#define   VBO_CTRL_L                               (0x1460)
#define P_VBO_CTRL_L                               (volatile uint32_t *)((0x1460  << 2) + 0xff900000)
#define   VBO_CTRL_H                               (0x1461)
#define P_VBO_CTRL_H                               (volatile uint32_t *)((0x1461  << 2) + 0xff900000)
#define   VBO_SOFT_RST                             (0x1462)
#define P_VBO_SOFT_RST                             (volatile uint32_t *)((0x1462  << 2) + 0xff900000)
#define   VBO_LANES                                (0x1463)
#define P_VBO_LANES                                (volatile uint32_t *)((0x1463  << 2) + 0xff900000)
#define   VBO_VIN_CTRL                             (0x1464)
#define P_VBO_VIN_CTRL                             (volatile uint32_t *)((0x1464  << 2) + 0xff900000)
#define   VBO_ACT_VSIZE                            (0x1465)
#define P_VBO_ACT_VSIZE                            (volatile uint32_t *)((0x1465  << 2) + 0xff900000)
#define   VBO_REGION_00                            (0x1466)
#define P_VBO_REGION_00                            (volatile uint32_t *)((0x1466  << 2) + 0xff900000)
#define   VBO_REGION_01                            (0x1467)
#define P_VBO_REGION_01                            (volatile uint32_t *)((0x1467  << 2) + 0xff900000)
#define   VBO_REGION_02                            (0x1468)
#define P_VBO_REGION_02                            (volatile uint32_t *)((0x1468  << 2) + 0xff900000)
#define   VBO_REGION_03                            (0x1469)
#define P_VBO_REGION_03                            (volatile uint32_t *)((0x1469  << 2) + 0xff900000)
#define   VBO_VBK_CTRL_0                           (0x146a)
#define P_VBO_VBK_CTRL_0                           (volatile uint32_t *)((0x146a  << 2) + 0xff900000)
#define   VBO_VBK_CTRL_1                           (0x146b)
#define P_VBO_VBK_CTRL_1                           (volatile uint32_t *)((0x146b  << 2) + 0xff900000)
#define   VBO_HBK_CTRL                             (0x146c)
#define P_VBO_HBK_CTRL                             (volatile uint32_t *)((0x146c  << 2) + 0xff900000)
#define   VBO_PXL_CTRL                             (0x146d)
#define P_VBO_PXL_CTRL                             (volatile uint32_t *)((0x146d  << 2) + 0xff900000)
#define   VBO_LANE_SKEW_L                          (0x146e)
#define P_VBO_LANE_SKEW_L                          (volatile uint32_t *)((0x146e  << 2) + 0xff900000)
#define   VBO_LANE_SKEW_H                          (0x146f)
#define P_VBO_LANE_SKEW_H                          (volatile uint32_t *)((0x146f  << 2) + 0xff900000)
#define   VBO_GCLK_LANE_L                          (0x1470)
#define P_VBO_GCLK_LANE_L                          (volatile uint32_t *)((0x1470  << 2) + 0xff900000)
#define   VBO_GCLK_LANE_H                          (0x1471)
#define P_VBO_GCLK_LANE_H                          (volatile uint32_t *)((0x1471  << 2) + 0xff900000)
#define   VBO_GCLK_MAIN                            (0x1472)
#define P_VBO_GCLK_MAIN                            (volatile uint32_t *)((0x1472  << 2) + 0xff900000)
#define   VBO_STATUS_L                             (0x1473)
#define P_VBO_STATUS_L                             (volatile uint32_t *)((0x1473  << 2) + 0xff900000)
#define   VBO_STATUS_H                             (0x1474)
#define P_VBO_STATUS_H                             (volatile uint32_t *)((0x1474  << 2) + 0xff900000)
#define   VBO_LANE_OUTPUT                          (0x1475)
#define P_VBO_LANE_OUTPUT                          (volatile uint32_t *)((0x1475  << 2) + 0xff900000)
#define   LCD_PORT_SWAP                            (0x1476)
#define P_LCD_PORT_SWAP                            (volatile uint32_t *)((0x1476  << 2) + 0xff900000)
#define   VBO_TMCHK_THRD_L                         (0x1478)
#define P_VBO_TMCHK_THRD_L                         (volatile uint32_t *)((0x1478  << 2) + 0xff900000)
#define   VBO_TMCHK_THRD_H                         (0x1479)
#define P_VBO_TMCHK_THRD_H                         (volatile uint32_t *)((0x1479  << 2) + 0xff900000)
#define   VBO_FSM_HOLDER_L                         (0x147a)
#define P_VBO_FSM_HOLDER_L                         (volatile uint32_t *)((0x147a  << 2) + 0xff900000)
#define   VBO_FSM_HOLDER_H                         (0x147b)
#define P_VBO_FSM_HOLDER_H                         (volatile uint32_t *)((0x147b  << 2) + 0xff900000)
#define   VBO_INTR_STATE_CTRL                      (0x147c)
#define P_VBO_INTR_STATE_CTRL                      (volatile uint32_t *)((0x147c  << 2) + 0xff900000)
#define   VBO_INTR_UNMASK                          (0x147d)
#define P_VBO_INTR_UNMASK                          (volatile uint32_t *)((0x147d  << 2) + 0xff900000)
#define   VBO_TMCHK_HSYNC_STATE_L                  (0x147e)
#define P_VBO_TMCHK_HSYNC_STATE_L                  (volatile uint32_t *)((0x147e  << 2) + 0xff900000)
#define   VBO_TMCHK_HSYNC_STATE_H                  (0x147f)
#define P_VBO_TMCHK_HSYNC_STATE_H                  (volatile uint32_t *)((0x147f  << 2) + 0xff900000)
#define   VBO_TMCHK_VSYNC_STATE_L                  (0x14f4)
#define P_VBO_TMCHK_VSYNC_STATE_L                  (volatile uint32_t *)((0x14f4  << 2) + 0xff900000)
#define   VBO_TMCHK_VSYNC_STATE_H                  (0x14f5)
#define P_VBO_TMCHK_VSYNC_STATE_H                  (volatile uint32_t *)((0x14f5  << 2) + 0xff900000)
#define   VBO_TMCHK_VDE_STATE_L                    (0x14f6)
#define P_VBO_TMCHK_VDE_STATE_L                    (volatile uint32_t *)((0x14f6  << 2) + 0xff900000)
#define   VBO_TMCHK_VDE_STATE_H                    (0x14f7)
#define P_VBO_TMCHK_VDE_STATE_H                    (volatile uint32_t *)((0x14f7  << 2) + 0xff900000)
#define   VBO_INTR_STATE                           (0x14f8)
#define P_VBO_INTR_STATE                           (volatile uint32_t *)((0x14f8  << 2) + 0xff900000)
#define   VBO_INFILTER_CTRL                        (0x14f9)
#define P_VBO_INFILTER_CTRL                        (volatile uint32_t *)((0x14f9  << 2) + 0xff900000)
#define   VBO_INSGN_CTRL                           (0x14fa)
#define P_VBO_INSGN_CTRL                           (volatile uint32_t *)((0x14fa  << 2) + 0xff900000)
//**************************************************************************
//*  NOTE::    When Programming the Gamma, please turn off the IRQ service *
//**************************************************************************
#define   GAMMA_CNTL_PORT                          (0x1480)
#define P_GAMMA_CNTL_PORT                          (volatile uint32_t *)((0x1480  << 2) + 0xff900000)
   #define  GAMMA_VCOM_POL    7     //RW
   #define  GAMMA_RVS_OUT     6     //RW
   #define  ADR_RDY           5     //Read Only
   #define  WR_RDY            4     //Read Only
   #define  RD_RDY            3     //Read Only
   #define  GAMMA_TR          2     //RW
   #define  GAMMA_SET         1     //RW
   #define  GAMMA_EN          0     //RW
#define   GAMMA_DATA_PORT                          (0x1481)
#define P_GAMMA_DATA_PORT                          (volatile uint32_t *)((0x1481  << 2) + 0xff900000)
#define   GAMMA_ADDR_PORT                          (0x1482)
#define P_GAMMA_ADDR_PORT                          (volatile uint32_t *)((0x1482  << 2) + 0xff900000)
   #define  H_RD              12
   #define  H_AUTO_INC        11
   #define  H_SEL_R           10
   #define  H_SEL_G           9
   #define  H_SEL_B           8
   #define  HADR_MSB          7            //7:0
   #define  HADR              0            //7:0
#define   GAMMA_VCOM_HSWITCH_ADDR                  (0x1483)
#define P_GAMMA_VCOM_HSWITCH_ADDR                  (volatile uint32_t *)((0x1483  << 2) + 0xff900000)
#define   RGB_BASE_ADDR                            (0x1485)
#define P_RGB_BASE_ADDR                            (volatile uint32_t *)((0x1485  << 2) + 0xff900000)
#define   RGB_COEFF_ADDR                           (0x1486)
#define P_RGB_COEFF_ADDR                           (volatile uint32_t *)((0x1486  << 2) + 0xff900000)
#define   POL_CNTL_ADDR                            (0x1487)
#define P_POL_CNTL_ADDR                            (volatile uint32_t *)((0x1487  << 2) + 0xff900000)
   #define   DCLK_SEL             14    //FOR DCLK OUTPUT
   #define   TCON_VSYNC_SEL_DVI   11    //FOR RGB format DVI output
   #define   TCON_HSYNC_SEL_DVI   10    //FOR RGB format DVI output
   #define   TCON_DE_SEL_DVI      9     //FOR RGB format DVI output
   #define   CPH3_POL         8
   #define   CPH2_POL         7
   #define   CPH1_POL         6
   #define   TCON_DE_SEL      5
   #define   TCON_VS_SEL      4
   #define   TCON_HS_SEL      3
   #define   DE_POL           2
   #define   VS_POL           1
   #define   HS_POL           0
#define   DITH_CNTL_ADDR                           (0x1488)
#define P_DITH_CNTL_ADDR                           (volatile uint32_t *)((0x1488  << 2) + 0xff900000)
   #define  DITH10_EN         10
   #define  DITH8_EN          9
   #define  DITH_MD           8
   #define  DITH10_CNTL_MSB   7          //7:4
   #define  DITH10_CNTL       4          //7:4
   #define  DITH8_CNTL_MSB    3          //3:0
   #define  DITH8_CNTL        0          //3:0
//Bit 1 highlight_en
//Bit 0 probe_en
#define   GAMMA_PROBE_CTRL                         (0x1489)
#define P_GAMMA_PROBE_CTRL                         (volatile uint32_t *)((0x1489  << 2) + 0xff900000)
//read only
//Bit [15:0]  probe_color[15:0]
#define   GAMMA_PROBE_COLOR_L                      (0x148a)
#define P_GAMMA_PROBE_COLOR_L                      (volatile uint32_t *)((0x148a  << 2) + 0xff900000)
//Read only
//Bit 15: if true valid probed color
//Bit [13:0]  probe_color[29:16]
#define   GAMMA_PROBE_COLOR_H                      (0x148b)
#define P_GAMMA_PROBE_COLOR_H                      (volatile uint32_t *)((0x148b  << 2) + 0xff900000)
//bit 15:0, 5:6:5 color
#define   GAMMA_PROBE_HL_COLOR                     (0x148c)
#define P_GAMMA_PROBE_HL_COLOR                     (volatile uint32_t *)((0x148c  << 2) + 0xff900000)
//12:0 pos_x
#define   GAMMA_PROBE_POS_X                        (0x148d)
#define P_GAMMA_PROBE_POS_X                        (volatile uint32_t *)((0x148d  << 2) + 0xff900000)
//12:0 pos_y
#define   GAMMA_PROBE_POS_Y                        (0x148e)
#define P_GAMMA_PROBE_POS_Y                        (volatile uint32_t *)((0x148e  << 2) + 0xff900000)
#define   STH1_HS_ADDR                             (0x1490)
#define P_STH1_HS_ADDR                             (volatile uint32_t *)((0x1490  << 2) + 0xff900000)
#define   STH1_HE_ADDR                             (0x1491)
#define P_STH1_HE_ADDR                             (volatile uint32_t *)((0x1491  << 2) + 0xff900000)
#define   STH1_VS_ADDR                             (0x1492)
#define P_STH1_VS_ADDR                             (volatile uint32_t *)((0x1492  << 2) + 0xff900000)
#define   STH1_VE_ADDR                             (0x1493)
#define P_STH1_VE_ADDR                             (volatile uint32_t *)((0x1493  << 2) + 0xff900000)
#define   STH2_HS_ADDR                             (0x1494)
#define P_STH2_HS_ADDR                             (volatile uint32_t *)((0x1494  << 2) + 0xff900000)
#define   STH2_HE_ADDR                             (0x1495)
#define P_STH2_HE_ADDR                             (volatile uint32_t *)((0x1495  << 2) + 0xff900000)
#define   STH2_VS_ADDR                             (0x1496)
#define P_STH2_VS_ADDR                             (volatile uint32_t *)((0x1496  << 2) + 0xff900000)
#define   STH2_VE_ADDR                             (0x1497)
#define P_STH2_VE_ADDR                             (volatile uint32_t *)((0x1497  << 2) + 0xff900000)
#define   OEH_HS_ADDR                              (0x1498)
#define P_OEH_HS_ADDR                              (volatile uint32_t *)((0x1498  << 2) + 0xff900000)
#define   OEH_HE_ADDR                              (0x1499)
#define P_OEH_HE_ADDR                              (volatile uint32_t *)((0x1499  << 2) + 0xff900000)
#define   OEH_VS_ADDR                              (0x149a)
#define P_OEH_VS_ADDR                              (volatile uint32_t *)((0x149a  << 2) + 0xff900000)
#define   OEH_VE_ADDR                              (0x149b)
#define P_OEH_VE_ADDR                              (volatile uint32_t *)((0x149b  << 2) + 0xff900000)
#define   VCOM_HSWITCH_ADDR                        (0x149c)
#define P_VCOM_HSWITCH_ADDR                        (volatile uint32_t *)((0x149c  << 2) + 0xff900000)
#define   VCOM_VS_ADDR                             (0x149d)
#define P_VCOM_VS_ADDR                             (volatile uint32_t *)((0x149d  << 2) + 0xff900000)
#define   VCOM_VE_ADDR                             (0x149e)
#define P_VCOM_VE_ADDR                             (volatile uint32_t *)((0x149e  << 2) + 0xff900000)
#define   CPV1_HS_ADDR                             (0x149f)
#define P_CPV1_HS_ADDR                             (volatile uint32_t *)((0x149f  << 2) + 0xff900000)
#define   CPV1_HE_ADDR                             (0x14a0)
#define P_CPV1_HE_ADDR                             (volatile uint32_t *)((0x14a0  << 2) + 0xff900000)
#define   CPV1_VS_ADDR                             (0x14a1)
#define P_CPV1_VS_ADDR                             (volatile uint32_t *)((0x14a1  << 2) + 0xff900000)
#define   CPV1_VE_ADDR                             (0x14a2)
#define P_CPV1_VE_ADDR                             (volatile uint32_t *)((0x14a2  << 2) + 0xff900000)
#define   CPV2_HS_ADDR                             (0x14a3)
#define P_CPV2_HS_ADDR                             (volatile uint32_t *)((0x14a3  << 2) + 0xff900000)
#define   CPV2_HE_ADDR                             (0x14a4)
#define P_CPV2_HE_ADDR                             (volatile uint32_t *)((0x14a4  << 2) + 0xff900000)
#define   CPV2_VS_ADDR                             (0x14a5)
#define P_CPV2_VS_ADDR                             (volatile uint32_t *)((0x14a5  << 2) + 0xff900000)
#define   CPV2_VE_ADDR                             (0x14a6)
#define P_CPV2_VE_ADDR                             (volatile uint32_t *)((0x14a6  << 2) + 0xff900000)
#define   STV1_HS_ADDR                             (0x14a7)
#define P_STV1_HS_ADDR                             (volatile uint32_t *)((0x14a7  << 2) + 0xff900000)
#define   STV1_HE_ADDR                             (0x14a8)
#define P_STV1_HE_ADDR                             (volatile uint32_t *)((0x14a8  << 2) + 0xff900000)
#define   STV1_VS_ADDR                             (0x14a9)
#define P_STV1_VS_ADDR                             (volatile uint32_t *)((0x14a9  << 2) + 0xff900000)
#define   STV1_VE_ADDR                             (0x14aa)
#define P_STV1_VE_ADDR                             (volatile uint32_t *)((0x14aa  << 2) + 0xff900000)
#define   STV2_HS_ADDR                             (0x14ab)
#define P_STV2_HS_ADDR                             (volatile uint32_t *)((0x14ab  << 2) + 0xff900000)
#define   STV2_HE_ADDR                             (0x14ac)
#define P_STV2_HE_ADDR                             (volatile uint32_t *)((0x14ac  << 2) + 0xff900000)
#define   STV2_VS_ADDR                             (0x14ad)
#define P_STV2_VS_ADDR                             (volatile uint32_t *)((0x14ad  << 2) + 0xff900000)
#define   STV2_VE_ADDR                             (0x14ae)
#define P_STV2_VE_ADDR                             (volatile uint32_t *)((0x14ae  << 2) + 0xff900000)
#define   OEV1_HS_ADDR                             (0x14af)
#define P_OEV1_HS_ADDR                             (volatile uint32_t *)((0x14af  << 2) + 0xff900000)
#define   OEV1_HE_ADDR                             (0x14b0)
#define P_OEV1_HE_ADDR                             (volatile uint32_t *)((0x14b0  << 2) + 0xff900000)
#define   OEV1_VS_ADDR                             (0x14b1)
#define P_OEV1_VS_ADDR                             (volatile uint32_t *)((0x14b1  << 2) + 0xff900000)
#define   OEV1_VE_ADDR                             (0x14b2)
#define P_OEV1_VE_ADDR                             (volatile uint32_t *)((0x14b2  << 2) + 0xff900000)
#define   OEV2_HS_ADDR                             (0x14b3)
#define P_OEV2_HS_ADDR                             (volatile uint32_t *)((0x14b3  << 2) + 0xff900000)
#define   OEV2_HE_ADDR                             (0x14b4)
#define P_OEV2_HE_ADDR                             (volatile uint32_t *)((0x14b4  << 2) + 0xff900000)
#define   OEV2_VS_ADDR                             (0x14b5)
#define P_OEV2_VS_ADDR                             (volatile uint32_t *)((0x14b5  << 2) + 0xff900000)
#define   OEV2_VE_ADDR                             (0x14b6)
#define P_OEV2_VE_ADDR                             (volatile uint32_t *)((0x14b6  << 2) + 0xff900000)
#define   OEV3_HS_ADDR                             (0x14b7)
#define P_OEV3_HS_ADDR                             (volatile uint32_t *)((0x14b7  << 2) + 0xff900000)
#define   OEV3_HE_ADDR                             (0x14b8)
#define P_OEV3_HE_ADDR                             (volatile uint32_t *)((0x14b8  << 2) + 0xff900000)
#define   OEV3_VS_ADDR                             (0x14b9)
#define P_OEV3_VS_ADDR                             (volatile uint32_t *)((0x14b9  << 2) + 0xff900000)
#define   OEV3_VE_ADDR                             (0x14ba)
#define P_OEV3_VE_ADDR                             (volatile uint32_t *)((0x14ba  << 2) + 0xff900000)
#define   LCD_PWR_ADDR                             (0x14bb)
#define P_LCD_PWR_ADDR                             (volatile uint32_t *)((0x14bb  << 2) + 0xff900000)
   #define      LCD_VDD        5
   #define      LCD_VBL        4
   #define      LCD_GPI_MSB    3
   #define      LCD_GPIO       0
#define   LCD_PWM0_LO_ADDR                         (0x14bc)
#define P_LCD_PWM0_LO_ADDR                         (volatile uint32_t *)((0x14bc  << 2) + 0xff900000)
#define   LCD_PWM0_HI_ADDR                         (0x14bd)
#define P_LCD_PWM0_HI_ADDR                         (volatile uint32_t *)((0x14bd  << 2) + 0xff900000)
#define   LCD_PWM1_LO_ADDR                         (0x14be)
#define P_LCD_PWM1_LO_ADDR                         (volatile uint32_t *)((0x14be  << 2) + 0xff900000)
#define   LCD_PWM1_HI_ADDR                         (0x14bf)
#define P_LCD_PWM1_HI_ADDR                         (volatile uint32_t *)((0x14bf  << 2) + 0xff900000)
#define   INV_CNT_ADDR                             (0x14c0)
#define P_INV_CNT_ADDR                             (volatile uint32_t *)((0x14c0  << 2) + 0xff900000)
   #define     INV_EN          4
   #define     INV_CNT_MSB     3
   #define     INV_CNT         0
#define   TCON_MISC_SEL_ADDR                       (0x14c1)
#define P_TCON_MISC_SEL_ADDR                       (volatile uint32_t *)((0x14c1  << 2) + 0xff900000)
   #define     STH2_SEL        12
   #define     STH1_SEL        11
   #define     OEH_SEL         10
   #define     VCOM_SEL         9
   #define     DB_LINE_SW       8
   #define     CPV2_SEL         7
   #define     CPV1_SEL         6
   #define     STV2_SEL         5
   #define     STV1_SEL         4
   #define     OEV_UNITE        3
   #define     OEV3_SEL         2
   #define     OEV2_SEL         1
   #define     OEV1_SEL         0
#define   DUAL_PORT_CNTL_ADDR                      (0x14c2)
#define P_DUAL_PORT_CNTL_ADDR                      (volatile uint32_t *)((0x14c2  << 2) + 0xff900000)
   #define     OUTPUT_YUV       15
   #define     DUAL_IDF         12   // 14:12
   #define     DUAL_ISF         9    // 11:9
   #define     LCD_ANALOG_SEL_CPH3   8
   #define     LCD_ANALOG_3PHI_CLK_SEL   7
   #define     LCD_LVDS_SEL54   6
   #define     LCD_LVDS_SEL27   5
   #define     LCD_TTL_SEL      4
   #define     DUAL_LVDC_EN     3
   #define     PORT_SWP         2
   #define     RGB_SWP          1
   #define     BIT_SWP          0
#define   MLVDS_CONTROL                            (0x14c3)
#define P_MLVDS_CONTROL                            (volatile uint32_t *)((0x14c3  << 2) + 0xff900000)
   #define     mLVDS_RESERVED  15    // 15
   #define     mLVDS_double_pattern  14    // 14
   #define     mLVDS_ins_reset  8    // 13:8  // each channel has one bit
   #define     mLVDS_dual_gate  7
   #define     mLVDS_bit_num    6    // 0-6Bits, 1-8Bits
   #define     mLVDS_pair_num   5    // 0-3Pairs, 1-6Pairs
   #define     mLVDS_msb_first  4
   #define     mLVDS_PORT_SWAP  3
   #define     mLVDS_MLSB_SWAP  2
   #define     mLVDS_PN_SWAP    1
   #define     mLVDS_en         0
#define   MLVDS_RESET_PATTERN_HI                   (0x14c4)
#define P_MLVDS_RESET_PATTERN_HI                   (volatile uint32_t *)((0x14c4  << 2) + 0xff900000)
#define   MLVDS_RESET_PATTERN_LO                   (0x14c5)
#define P_MLVDS_RESET_PATTERN_LO                   (volatile uint32_t *)((0x14c5  << 2) + 0xff900000)
   #define     mLVDS_reset_pattern  0 // Bit 47:16
#define   MLVDS_RESET_PATTERN_EXT                  (0x14c6)
#define P_MLVDS_RESET_PATTERN_EXT                  (volatile uint32_t *)((0x14c6  << 2) + 0xff900000)
   #define     mLVDS_reset_pattern_ext  0 // Bit 15:0
#define   MLVDS_CONFIG_HI                          (0x14c7)
#define P_MLVDS_CONFIG_HI                          (volatile uint32_t *)((0x14c7  << 2) + 0xff900000)
#define   MLVDS_CONFIG_LO                          (0x14c8)
#define P_MLVDS_CONFIG_LO                          (volatile uint32_t *)((0x14c8  << 2) + 0xff900000)
   #define     mLVDS_reset_offset         29 // Bit 31:29
   #define     mLVDS_reset_length         23 // Bit 28:23
   #define     mLVDS_config_reserved      20 // Bit 22:20
   #define     mLVDS_reset_start_bit12    19 // Bit 19
   #define     mLVDS_data_write_toggle    18
   #define     mLVDS_data_write_ini       17
   #define     mLVDS_data_latch_1_toggle  16
   #define     mLVDS_data_latch_1_ini     15
   #define     mLVDS_data_latch_0_toggle  14
   #define     mLVDS_data_latch_0_ini     13
   #define     mLVDS_reset_1_select       12 // 0 - same as reset_0, 1 - 1 clock delay of reset_0
   #define     mLVDS_reset_start           0 // Bit 11:0
#define   TCON_DOUBLE_CTL                          (0x14c9)
#define P_TCON_DOUBLE_CTL                          (volatile uint32_t *)((0x14c9  << 2) + 0xff900000)
   #define     tcon_double_ini          8 // Bit 7:0
   #define     tcon_double_inv          0 // Bit 7:0
#define   TCON_PATTERN_HI                          (0x14ca)
#define P_TCON_PATTERN_HI                          (volatile uint32_t *)((0x14ca  << 2) + 0xff900000)
#define   TCON_PATTERN_LO                          (0x14cb)
#define P_TCON_PATTERN_LO                          (volatile uint32_t *)((0x14cb  << 2) + 0xff900000)
   #define     tcon_pattern_loop_data     16 // Bit 15:0
   #define     tcon_pattern_loop_start    12 // Bit 3:0
   #define     tcon_pattern_loop_end       8 // Bit 3:0
   #define     tcon_pattern_enable         0 // Bit 7:0
#define   TCON_CONTROL_HI                          (0x14cc)
#define P_TCON_CONTROL_HI                          (volatile uint32_t *)((0x14cc  << 2) + 0xff900000)
#define   TCON_CONTROL_LO                          (0x14cd)
#define P_TCON_CONTROL_LO                          (volatile uint32_t *)((0x14cd  << 2) + 0xff900000)
   #define     tcon_pclk_enable           26 // Bit 5:0 (enable pclk on TCON channel 7 to 2)
   #define     tcon_pclk_div              24 // Bit 1:0 (control phy clok divide 2,4,6,8)
   #define     tcon_delay                  0 // Bit 23:0 (3 bit for each channel)
#define   LVDS_BLANK_DATA_HI                       (0x14ce)
#define P_LVDS_BLANK_DATA_HI                       (volatile uint32_t *)((0x14ce  << 2) + 0xff900000)
#define   LVDS_BLANK_DATA_LO                       (0x14cf)
#define P_LVDS_BLANK_DATA_LO                       (volatile uint32_t *)((0x14cf  << 2) + 0xff900000)
   #define     LVDS_blank_data_reserved 30  // 31:30
   #define     LVDS_blank_data_r        20  // 29:20
   #define     LVDS_blank_data_g        10  // 19:10
   #define     LVDS_blank_data_b         0  //  9:0
#define   LVDS_PACK_CNTL_ADDR                      (0x14d0)
#define P_LVDS_PACK_CNTL_ADDR                      (volatile uint32_t *)((0x14d0  << 2) + 0xff900000)
   #define     LVDS_USE_TCON    7
   #define     LVDS_DUAL        6
   #define     PN_SWP           5
   #define     LSB_FIRST        4
   #define     LVDS_RESV        3
   #define     ODD_EVEN_SWP     2
   #define     LVDS_REPACK      0
// New from M3 :
// Bit 15:12 -- Enable OFFSET Double Generate(TOCN7-TCON4)
// Bit 11:0 -- de_hs(old tcon) second offset_hs (new tcon)
#define   DE_HS_ADDR                               (0x14d1)
#define P_DE_HS_ADDR                               (volatile uint32_t *)((0x14d1  << 2) + 0xff900000)
// New from M3 :
// Bit 15:12 -- Enable OFFSET Double Generate(TOCN3-TCON0)
#define   DE_HE_ADDR                               (0x14d2)
#define P_DE_HE_ADDR                               (volatile uint32_t *)((0x14d2  << 2) + 0xff900000)
#define   DE_VS_ADDR                               (0x14d3)
#define P_DE_VS_ADDR                               (volatile uint32_t *)((0x14d3  << 2) + 0xff900000)
#define   DE_VE_ADDR                               (0x14d4)
#define P_DE_VE_ADDR                               (volatile uint32_t *)((0x14d4  << 2) + 0xff900000)
#define   HSYNC_HS_ADDR                            (0x14d5)
#define P_HSYNC_HS_ADDR                            (volatile uint32_t *)((0x14d5  << 2) + 0xff900000)
#define   HSYNC_HE_ADDR                            (0x14d6)
#define P_HSYNC_HE_ADDR                            (volatile uint32_t *)((0x14d6  << 2) + 0xff900000)
#define   HSYNC_VS_ADDR                            (0x14d7)
#define P_HSYNC_VS_ADDR                            (volatile uint32_t *)((0x14d7  << 2) + 0xff900000)
#define   HSYNC_VE_ADDR                            (0x14d8)
#define P_HSYNC_VE_ADDR                            (volatile uint32_t *)((0x14d8  << 2) + 0xff900000)
#define   VSYNC_HS_ADDR                            (0x14d9)
#define P_VSYNC_HS_ADDR                            (volatile uint32_t *)((0x14d9  << 2) + 0xff900000)
#define   VSYNC_HE_ADDR                            (0x14da)
#define P_VSYNC_HE_ADDR                            (volatile uint32_t *)((0x14da  << 2) + 0xff900000)
#define   VSYNC_VS_ADDR                            (0x14db)
#define P_VSYNC_VS_ADDR                            (volatile uint32_t *)((0x14db  << 2) + 0xff900000)
#define   VSYNC_VE_ADDR                            (0x14dc)
#define P_VSYNC_VE_ADDR                            (volatile uint32_t *)((0x14dc  << 2) + 0xff900000)
// bit 8 -- vfifo_mcu_enable
// bit 7 -- halt_vs_de
// bit 6 -- R8G8B8_format
// bit 5 -- R6G6B6_format (round to 6 bits)
// bit 4 -- R5G6B5_format
// bit 3 -- dac_dith_sel
// bit 2 -- lcd_mcu_enable_de     -- ReadOnly
// bit 1 -- lcd_mcu_enable_vsync  -- ReadOnly
// bit 0 -- lcd_mcu_enable
#define   LCD_MCU_CTL                              (0x14dd)
#define P_LCD_MCU_CTL                              (volatile uint32_t *)((0x14dd  << 2) + 0xff900000)
// ReadOnly
//   R5G6B5 when R5G6B5_format
//   G8R8   when R8G8B8_format
//   G5R10  Other
#define   LCD_MCU_DATA_0                           (0x14de)
#define P_LCD_MCU_DATA_0                           (volatile uint32_t *)((0x14de  << 2) + 0xff900000)
// ReadOnly
//   G8B8   when R8G8B8_format
//   G5B10  Other
#define   LCD_MCU_DATA_1                           (0x14df)
#define P_LCD_MCU_DATA_1                           (volatile uint32_t *)((0x14df  << 2) + 0xff900000)
// LVDS
#define   LVDS_GEN_CNTL                            (0x14e0)
#define P_LVDS_GEN_CNTL                            (volatile uint32_t *)((0x14e0  << 2) + 0xff900000)
#define   LVDS_PHY_CNTL0                           (0x14e1)
#define P_LVDS_PHY_CNTL0                           (volatile uint32_t *)((0x14e1  << 2) + 0xff900000)
#define   LVDS_PHY_CNTL1                           (0x14e2)
#define P_LVDS_PHY_CNTL1                           (volatile uint32_t *)((0x14e2  << 2) + 0xff900000)
#define   LVDS_PHY_CNTL2                           (0x14e3)
#define P_LVDS_PHY_CNTL2                           (volatile uint32_t *)((0x14e3  << 2) + 0xff900000)
#define   LVDS_PHY_CNTL3                           (0x14e4)
#define P_LVDS_PHY_CNTL3                           (volatile uint32_t *)((0x14e4  << 2) + 0xff900000)
#define   LVDS_PHY_CNTL4                           (0x14e5)
#define P_LVDS_PHY_CNTL4                           (volatile uint32_t *)((0x14e5  << 2) + 0xff900000)
#define   LVDS_PHY_CNTL5                           (0x14e6)
#define P_LVDS_PHY_CNTL5                           (volatile uint32_t *)((0x14e6  << 2) + 0xff900000)
#define   LVDS_SRG_TEST                            (0x14e8)
#define P_LVDS_SRG_TEST                            (volatile uint32_t *)((0x14e8  << 2) + 0xff900000)
#define   LVDS_BIST_MUX0                           (0x14e9)
#define P_LVDS_BIST_MUX0                           (volatile uint32_t *)((0x14e9  << 2) + 0xff900000)
#define   LVDS_BIST_MUX1                           (0x14ea)
#define P_LVDS_BIST_MUX1                           (volatile uint32_t *)((0x14ea  << 2) + 0xff900000)
#define   LVDS_BIST_FIXED0                         (0x14eb)
#define P_LVDS_BIST_FIXED0                         (volatile uint32_t *)((0x14eb  << 2) + 0xff900000)
#define   LVDS_BIST_FIXED1                         (0x14ec)
#define P_LVDS_BIST_FIXED1                         (volatile uint32_t *)((0x14ec  << 2) + 0xff900000)
#define   LVDS_BIST_CNTL0                          (0x14ed)
#define P_LVDS_BIST_CNTL0                          (volatile uint32_t *)((0x14ed  << 2) + 0xff900000)
#define   LVDS_CLKB_CLKA                           (0x14ee)
#define P_LVDS_CLKB_CLKA                           (volatile uint32_t *)((0x14ee  << 2) + 0xff900000)
#define   LVDS_PHY_CLK_CNTL                        (0x14ef)
#define P_LVDS_PHY_CLK_CNTL                        (volatile uint32_t *)((0x14ef  << 2) + 0xff900000)
#define   LVDS_SER_EN                              (0x14f0)
#define P_LVDS_SER_EN                              (volatile uint32_t *)((0x14f0  << 2) + 0xff900000)
#define   LVDS_PHY_CNTL6                           (0x14f1)
#define P_LVDS_PHY_CNTL6                           (volatile uint32_t *)((0x14f1  << 2) + 0xff900000)
#define   LVDS_PHY_CNTL7                           (0x14f2)
#define P_LVDS_PHY_CNTL7                           (volatile uint32_t *)((0x14f2  << 2) + 0xff900000)
#define   LVDS_PHY_CNTL8                           (0x14f3)
#define P_LVDS_PHY_CNTL8                           (volatile uint32_t *)((0x14f3  << 2) + 0xff900000)
//`define MLVDS_CLK_CTL0_HI        8'hf4
//`define MLVDS_CLK_CTL0_LO        8'hf5
//   `define     mlvds_clk_pattern_reserved 31 // Bit 31
//   `define     mpclk_dly                  28 // Bit 2:0
//   `define     mpclk_div                  26 // Bit 1:0 (control phy clok divide 2,4,6,8)
//   `define     use_mpclk                  25 // Bit 0
//   `define     mlvds_clk_half_delay       24 // Bit 0
//   `define     mlvds_clk_pattern           0 // Bit 23:0
//`define MLVDS_DUAL_GATE_WR_START        8'hf6
//   `define     mlvds_dual_gate_wr_start    0 // Bit 12:0
//`define MLVDS_DUAL_GATE_WR_END          8'hf7
//   `define     mlvds_dual_gate_wr_end      0 // Bit 12:0
//
//`define MLVDS_DUAL_GATE_RD_START        8'hf8
//   `define     mlvds_dual_gate_rd_start    0 // Bit 12:0
//`define MLVDS_DUAL_GATE_RD_END          8'hf9
//   `define     mlvds_dual_gate_rd_end      0 // Bit 12:0
//`define MLVDS_SECOND_RESET_CTL          8'hfa
//   `define     mLVDS_2nd_reset_start       0 // Bit 12:0
//
#define   MLVDS_DUAL_GATE_CTL_HI                   (0x14fb)
#define P_MLVDS_DUAL_GATE_CTL_HI                   (volatile uint32_t *)((0x14fb  << 2) + 0xff900000)
#define   MLVDS_DUAL_GATE_CTL_LO                   (0x14fc)
#define P_MLVDS_DUAL_GATE_CTL_LO                   (volatile uint32_t *)((0x14fc  << 2) + 0xff900000)
//   `define     mlvds_tcon_field_en        24 // Bit 7:0
//   `define     mlvds_dual_gate_reserved   21 // Bit 2:0
//   `define     mlvds_scan_mode_start_line_bit12 20 // Bit 0
//   `define     mlvds_scan_mode_odd        16 // Bit 3:0
//   `define     mlvds_scan_mode_even       12 // Bit 3:0
//   `define     mlvds_scan_mode_start_line  0 // Bit 11:0
//
//`define MLVDS_RESET_CONFIG_HI         8'hfd
//`define MLVDS_RESET_CONFIG_LO         8'hfe
//   `define     mLVDS_reset_range_enable   31 // Bit 0
//   `define     mLVDS_reset_range_inv      30 // Bit 0
//   `define     mLVDS_reset_config_res1    29 // Bit 0
//   `define     mLVDS_reset_range_line_0   16 // Bit 11:0
//   `define     mLVDS_reset_config_res3    13 // Bit 2:0
//   `define     mLVDS_reset_range_line_1    0 // Bit 11:0
//===============================================================
//LCD DRIVER BASE   END
//===============================================================
//
// Closing file:  lcd_regs.h
//
//`define MAD_VCBUS_BASE               8'h17
//
// Reading file:  mad_regs.h
//
//DEINTERLACE module start from 8'h90 end to 8'hff
// -----------------------------------------------
// CBUS_BASE:  MAD_VCBUS_BASE = 0x17
// -----------------------------------------------
#define   DI_PRE_CTRL                              (0x1700)
#define P_DI_PRE_CTRL                              (volatile uint32_t *)((0x1700  << 2) + 0xff900000)
// bit 31,      cbus_pre_frame_rst
// bit 30,      cbus_pre_soft_rst
// bit 29,      pre_field_num
// bit 27:26,   mode_444c422
// bit 25,      di_cont_read_en
// bit 24:23,   mode_422c444
// bit 22,      mtn_after_nr
// bit 21:16,   pre_hold_fifo_lines
// bit 15,      nr_wr_by
// bit 14,      use_vdin_go_line
// bit 13,      di_prevdin_en
// bit 12,      di_pre_viu_link
// bit 11,      di_pre_repeat
// bit 10,      di_pre_drop_1st
// bit  9,      di_buf2_en
// bit  8,      di_chan2_en
// bit  7,      prenr_hist_en
// bit  6,      chan2_hist_en
// bit  5,      hist_check_en
// bit  4,      check_after_nr
// bit  3,      check222p_en
// bit  2,      check322p_en
// bit  1,      mtn_en
// bit  0,      nr_en
#define   DI_POST_CTRL                             (0x1701)
#define P_DI_POST_CTRL                             (volatile uint32_t *)((0x1701  << 2) + 0xff900000)
// bit 31,      cbus_post_frame_rst
// bit 30,      cbus_post_soft_rst
// bit 29,      post_field_num
// bit 21:16,   post_hold_fifo_lines
// bit 13,      prepost_link
// bit 12,      di_post_viu_link
// bit 11,      di_post_repeat
// bit 10,      di_post_drop_1st
// bit  9,      mif0_to_vpp_en
// bit  8,      di_vpp_out_en
// bit  7,      di_wr_bk_en
// bit  6,      di_mux_en
// bit  5,      di_blend_en
// bit  4,      di_mtnp_read_en
// bit  3,      di_mtn_buf_en
// bit  2,      di_ei_en
// bit  1,      di_buf1_en
// bit  0,      di_buf0_en
#define   DI_POST_SIZE                             (0x1702)
#define P_DI_POST_SIZE                             (volatile uint32_t *)((0x1702  << 2) + 0xff900000)
//bit 28:16,    vsize1post
//bit 12:0,     hsize1post
#define   DI_PRE_SIZE                              (0x1703)
#define P_DI_PRE_SIZE                              (volatile uint32_t *)((0x1703  << 2) + 0xff900000)
//bit 28:16,    vsize1pre
//bit 12:0,     hsize1pre
#define   DI_EI_CTRL0                              (0x1704)
#define P_DI_EI_CTRL0                              (volatile uint32_t *)((0x1704  << 2) + 0xff900000)
//bit 23:16,    ei0_filter[2:+]  abs_diff_left>filter && ...right>filter && ...top>filter && ...bot>filter -> filter
//bit 15:8,     ei0_threshold[2:+]
//bit 3,        ei0_vertical
//bit 2,        ei0_bpscf2
//bit 1,        ei0_bpsfar1
#define   DI_EI_CTRL1                              (0x1705)
#define P_DI_EI_CTRL1                              (volatile uint32_t *)((0x1705  << 2) + 0xff900000)
//bit 31:24,    ei0_diff
//bit 23:16,    ei0_angle45
//bit 15:8,     ei0_peak
//bit 7:0,      ei0_cross
#define   DI_EI_CTRL2                              (0x1706)
#define P_DI_EI_CTRL2                              (volatile uint32_t *)((0x1706  << 2) + 0xff900000)
//bit 31:24,    ei0_close2
//bit 23:16,    ei0_close1
//bit 15:8,     ei0_far2
//bit 7:0,      ei0_far1
#define   DI_NR_CTRL0                              (0x1707)
#define P_DI_NR_CTRL0                              (volatile uint32_t *)((0x1707  << 2) + 0xff900000)
//bit 26,       nr_cue_en
//bit 25,       nr2_en
#define   DI_NR_CTRL1                              (0x1708)
#define P_DI_NR_CTRL1                              (volatile uint32_t *)((0x1708  << 2) + 0xff900000)
//bit 31:30,    mot_p1txtcore_mode
//bit 29:24,    mot_p1txtcore_clmt
//bit 21:16,    mot_p1txtcore_ylmt
//bit 15:8,     mot_p1txtcore_crate
//bit 7:0,      mot_p1txtcore_yrate
#define   DI_NR_CTRL2                              (0x1709)
#define P_DI_NR_CTRL2                              (volatile uint32_t *)((0x1709  << 2) + 0xff900000)
//bit 29:24,    mot_curtxtcore_clmt
//bit 21:16,    mot_curtxtcore_ylmt
//bit 15:8,     mot_curtxtcore_crate
//bit 7:0,      mot_curtxtcore_yrate
//`define DI_NR_CTRL3               8'h0a
//no use
//`define DI_MTN_CTRL               8'h0b
//no use
#define   DI_CANVAS_URGENT0                        (0x170a)
#define P_DI_CANVAS_URGENT0                        (volatile uint32_t *)((0x170a  << 2) + 0xff900000)
#define   DI_CANVAS_URGENT1                        (0x170b)
#define P_DI_CANVAS_URGENT1                        (volatile uint32_t *)((0x170b  << 2) + 0xff900000)
#define   DI_MTN_CTRL1                             (0x170c)
#define P_DI_MTN_CTRL1                             (volatile uint32_t *)((0x170c  << 2) + 0xff900000)
//bit 13 ,      me enable
//bit 12 ,      me autoenable
//bit 11:8,     mtn_paramtnthd
//bit 7:0,      mtn_parafltthd
#define   DI_BLEND_CTRL                            (0x170d)
#define P_DI_BLEND_CTRL                            (volatile uint32_t *)((0x170d  << 2) + 0xff900000)
//bit 31,      blend_1_en
//bit 30,      blend_mtn_lpf
//bit 28,      post_mb_en
//bit 27,      blend_mtn3p_max
//bit 26,      blend_mtn3p_min
//bit 25,      blend_mtn3p_ave
//bit 24,      blend_mtn3p_maxtb
//bit 23,      blend_mtn_flt_en
//bit 22,      blend_data_flt_en
//bit 21:20,   blend_top_mode
//bit 19,      blend_reg3_enable
//bit 18,      blend_reg2_enable
//bit 17,      blend_reg1_enable
//bit 16,      blend_reg0_enable
//bit 15:14,   blend_reg3_mode
//bit 13:12,   blend_reg2_mode
//bit 11:10,   blend_reg1_mode
//bit 9:8,     blend_reg0_mode
//bit 7:0,     kdeint
//`define DI_BLEND_CTRL1            8'h0e
//no use
#define   DI_CANVAS_URGENT2                        (0x170e)
#define P_DI_CANVAS_URGENT2                        (volatile uint32_t *)((0x170e  << 2) + 0xff900000)
//`define DI_BLEND_CTRL2            8'h0f
//no use
#define   DI_ARB_CTRL                              (0x170f)
#define P_DI_ARB_CTRL                              (volatile uint32_t *)((0x170f  << 2) + 0xff900000)
//bit 31:26,            di_arb_thd1
//bit 25:20,            di_arb_thd0
//bit 19,           di_arb_tid_mode
//bit 18,           di_arb_arb_mode
//bit 17,           di_arb_acq_en
//bit 16,           di_arb_disable_clk
//bit 15:0,         di_arb_req_en
#define   DI_BLEND_REG0_X                          (0x1710)
#define P_DI_BLEND_REG0_X                          (volatile uint32_t *)((0x1710  << 2) + 0xff900000)
//bit 27:16,   blend_reg0_startx
//bit 11:0,    blend_reg0_endx
#define   DI_BLEND_REG0_Y                          (0x1711)
#define P_DI_BLEND_REG0_Y                          (volatile uint32_t *)((0x1711  << 2) + 0xff900000)
#define   DI_BLEND_REG1_X                          (0x1712)
#define P_DI_BLEND_REG1_X                          (volatile uint32_t *)((0x1712  << 2) + 0xff900000)
#define   DI_BLEND_REG1_Y                          (0x1713)
#define P_DI_BLEND_REG1_Y                          (volatile uint32_t *)((0x1713  << 2) + 0xff900000)
#define   DI_BLEND_REG2_X                          (0x1714)
#define P_DI_BLEND_REG2_X                          (volatile uint32_t *)((0x1714  << 2) + 0xff900000)
#define   DI_BLEND_REG2_Y                          (0x1715)
#define P_DI_BLEND_REG2_Y                          (volatile uint32_t *)((0x1715  << 2) + 0xff900000)
#define   DI_BLEND_REG3_X                          (0x1716)
#define P_DI_BLEND_REG3_X                          (volatile uint32_t *)((0x1716  << 2) + 0xff900000)
#define   DI_BLEND_REG3_Y                          (0x1717)
#define P_DI_BLEND_REG3_Y                          (volatile uint32_t *)((0x1717  << 2) + 0xff900000)
#define   DI_CLKG_CTRL                             (0x1718)
#define P_DI_CLKG_CTRL                             (volatile uint32_t *)((0x1718  << 2) + 0xff900000)
//bit 31:24,   pre_gclk_ctrl     no clk gate control. if ==1, module clk is not gated (always on). [3] for pulldown,[2] for mtn_1,[1] for mtn_0,[0] for nr
//bit 23:16,   post_gclk_ctrl    no clk gate control. [4] for ei_1, [3] for ei_0,[2] for ei_top, [1] for blend_1, [0] for blend_0
//bit 1,       di_gate_all       clk shut down. if ==1 , all di clock shut down
//bit 0,       di_no_clk_gate    no clk gate control.     if di_gated_all==0 and di_no_clk_gate ==1, all di clock is always working.
#define   DI_EI_CTRL3                              (0x1719)
#define P_DI_EI_CTRL3                              (volatile uint32_t *)((0x1719  << 2) + 0xff900000)
//bit 31,      reg_ei_1
//bit 30,      reg_demon_en
//bit 26:24,   reg_demon_mux
//bit 23:20,   reg_right_win
//bit 19:16,   reg_left_win
//bit 7:4,     reg_ei_sadm_quatize_margin
//bit 1:0,     reg_ei_sad_relative_mode
#define   DI_EI_CTRL4                              (0x171a)
#define P_DI_EI_CTRL4                              (volatile uint32_t *)((0x171a  << 2) + 0xff900000)
//bit 29,      reg_ei_caldrt_ambliike2_biasvertical
//bit 28:24,   reg_ei_caldrt_addxla2list_drtmax
//bit 22:20,   reg_ei_caldrt_addxla2list_signm0th
//bit 19,      reg_ei_caldrt_addxla2list_mode
//bit 18:16,   reg_ei_signm_sad_cor_rate
//bit 15:12,   reg_ei_signm_sadi_cor_rate
//bit 11:6,    reg_ei_signm_sadi_cor_ofst
//bit 5:0,     reg_ei_signm_sad_ofst
#define   DI_EI_CTRL5                              (0x171b)
#define P_DI_EI_CTRL5                              (volatile uint32_t *)((0x171b  << 2) + 0xff900000)
//bit 30:28,   reg_ei_caldrt_cnflcctchk_frcverthrd
//bit 26:24,   reg_ei_caldrt_cnflctchk_mg
//bit 23:22,   reg_ei_caldrt_cnflctchk_ws
//bit 21,      reg_ei_caldrt_cnflctchk_en
//bit 20,      reg_ei_caldrt_verfrc_final_en
//bit 19,      reg_ei_caldrt_verfrc_retimflt_en
//bit 18:16,   reg_ei_caldrt_verftc_eithratemth
//bit 15,      reg_ei_caldrt_verfrc_retiming_en
//bit 14:12,   reg_ei_caldrt_verfrc_bothratemth
//bit 11:9,    reg_ei_caldrt_ver_thrd
//bit 8:4,     reg_ei_caldrt_addxla2list_drtmin
//bit 3:0,     reg_ei_caldrt_addxla2list_drtlimit
#define   DI_EI_CTRL6                              (0x171c)
#define P_DI_EI_CTRL6                              (volatile uint32_t *)((0x171c  << 2) + 0xff900000)
//bit 31:24,   reg_ei_caldrt_abext_sad12thhig
//bit 23:16,   reg_ei_caldrt_abext_sad00thlow
//bit 15:8,    reg_ei_caldrt_abext_sad12thlow
//bit 6:4,     reg_ei_caldrt_abext_ratemth
//bit 2:0,     reg_ei_caldrt_abext_drtthrd
#define   DI_EI_CTRL7                              (0x171d)
#define P_DI_EI_CTRL7                              (volatile uint32_t *)((0x171d  << 2) + 0xff900000)
//bit 29,      reg_ei_caldrt_xlanopeak_codien
//bit 28:24,   reg_ei_caldrt_xlanopeak_drtmax
//bit 23,      reg_ei_caldrt_xlanopeak_en
//bit 28:24,   reg_ei_caldrt_abext_monotrnd_alpha
//bit 28:24,   reg_ei_caldrt_abext_mononum12_thrd
//bit 28:24,   reg_ei_caldrt_abext_mononum00_thrd
//bit 28:24,   reg_ei_caldrt_abext_sad00rate
//bit 28:24,   reg_ei_caldrt_abext_sad12rate
//bit 28:24,   reg_ei_caldrt_abext_sad00thhig
#define   DI_EI_CTRL8                              (0x171e)
#define P_DI_EI_CTRL8                              (volatile uint32_t *)((0x171e  << 2) + 0xff900000)
//bit 30:28,   reg_ei_assign_headtail_magin
//bit 26:24,   reg_ei_retime_lastcurpncnfltchk_mode
//bit 22:21,   reg_ei_retime_lastcurpncnfltchk_drtth
//bit 20,      reg_ei_caldrt_histchk_cnfid
//bit 19:16,   reg_ei_caldrt_histchk_thrd
//bit 15,      reg_ei_caldrt_histchk_abext
//bit 14,      reg_ei_caldrt_histchk_npen
//bit 13:11,   reg_ei_caldrt_amblike2_drtmg
//bit 10:8,    reg_ei_caldrt_amblike2_valmg
//bit 7:4,     reg_ei_caldrt_amblike2_alpha
//bit 3:0,     reg_ei_caldrt_amblike2_drtth
#define   DI_EI_CTRL9                              (0x171f)
#define P_DI_EI_CTRL9                              (volatile uint32_t *)((0x171f  << 2) + 0xff900000)
//bit 31:28,   reg_ei_caldrt_hcnfcheck_frcvert_xla_th3
//bit 27,      reg_ei_caldrt_hcnfcheck_frcvert_xla_en
//bit 26:24,   reg_ei_caldrt_conf_drtth
//bit 23:20,   reg_ei_caldrt_conf_absdrtth
//bit 19:18,   reg_ei_caldrt_abcheck_mode1
//bit 17:16,   reg_ei_caldrt_abcheck_mode0
//bit 15:12,   reg_ei_caldrt_abcheck_drth1
//bit 11:8,    reg_ei_caldrt_abcheck_drth0
//bit 6:4,     reg_ei_caldrt_abpnchk1_th
//bit 1,       reg_ei_caldrt_abpnchk1_en
//bit 0,       reg_ei_caldrt_abpnchk0_en
// DEINTERLACE mode check.
#define   DI_MC_REG0_X                             (0x1720)
#define P_DI_MC_REG0_X                             (volatile uint32_t *)((0x1720  << 2) + 0xff900000)
//bit 27:16,   mc_reg0_start_x
//bit 11:0,    mc_reg0_end_x
#define   DI_MC_REG0_Y                             (0x1721)
#define P_DI_MC_REG0_Y                             (volatile uint32_t *)((0x1721  << 2) + 0xff900000)
#define   DI_MC_REG1_X                             (0x1722)
#define P_DI_MC_REG1_X                             (volatile uint32_t *)((0x1722  << 2) + 0xff900000)
#define   DI_MC_REG1_Y                             (0x1723)
#define P_DI_MC_REG1_Y                             (volatile uint32_t *)((0x1723  << 2) + 0xff900000)
#define   DI_MC_REG2_X                             (0x1724)
#define P_DI_MC_REG2_X                             (volatile uint32_t *)((0x1724  << 2) + 0xff900000)
#define   DI_MC_REG2_Y                             (0x1725)
#define P_DI_MC_REG2_Y                             (volatile uint32_t *)((0x1725  << 2) + 0xff900000)
#define   DI_MC_REG3_X                             (0x1726)
#define P_DI_MC_REG3_X                             (volatile uint32_t *)((0x1726  << 2) + 0xff900000)
#define   DI_MC_REG3_Y                             (0x1727)
#define P_DI_MC_REG3_Y                             (volatile uint32_t *)((0x1727  << 2) + 0xff900000)
#define   DI_MC_REG4_X                             (0x1728)
#define P_DI_MC_REG4_X                             (volatile uint32_t *)((0x1728  << 2) + 0xff900000)
#define   DI_MC_REG4_Y                             (0x1729)
#define P_DI_MC_REG4_Y                             (volatile uint32_t *)((0x1729  << 2) + 0xff900000)
#define   DI_MC_32LVL0                             (0x172a)
#define P_DI_MC_32LVL0                             (volatile uint32_t *)((0x172a  << 2) + 0xff900000)
//bit 31:24,   mc_reg2_32lvl
//bit 23:16,   mc_reg1_32lvl
//bit 15:8,    mc_reg0_32lvl
//bit 7:0,     field_32lvl
#define   DI_MC_32LVL1                             (0x172b)
#define P_DI_MC_32LVL1                             (volatile uint32_t *)((0x172b  << 2) + 0xff900000)
//bit 15:8,    mc_reg3_32lvl
//bit 7:0,     mc_reg4_32lvl
#define   DI_MC_22LVL0                             (0x172c)
#define P_DI_MC_22LVL0                             (volatile uint32_t *)((0x172c  << 2) + 0xff900000)
//bit 31:16,   mc_reg0_22lvl
//bit 15:0,    field_22lvl
#define   DI_MC_22LVL1                             (0x172d)
#define P_DI_MC_22LVL1                             (volatile uint32_t *)((0x172d  << 2) + 0xff900000)
//bit 31:16,   mc_reg2_22lvl
//bit 15:0,    mc_reg1_22lvl
#define   DI_MC_22LVL2                             (0x172e)
#define P_DI_MC_22LVL2                             (volatile uint32_t *)((0x172e  << 2) + 0xff900000)
//bit 31:16,   mc_reg4_22lvl
//bit 15:0,    mc_reg3_22lvl
#define   DI_MC_CTRL                               (0x172f)
#define P_DI_MC_CTRL                               (volatile uint32_t *)((0x172f  << 2) + 0xff900000)
//bit 4,       mc_reg4_en
//bit 3,       mc_reg3_en
//bit 2,       mc_reg2_en
//bit 1,       mc_reg1_en
//bit 0,       mc_reg0_en
#define   DI_INTR_CTRL                             (0x1730)
#define P_DI_INTR_CTRL                             (volatile uint32_t *)((0x1730  << 2) + 0xff900000)
#define   DI_INFO_ADDR                             (0x1731)
#define P_DI_INFO_ADDR                             (volatile uint32_t *)((0x1731  << 2) + 0xff900000)
#define   DI_INFO_DATA                             (0x1732)
#define P_DI_INFO_DATA                             (volatile uint32_t *)((0x1732  << 2) + 0xff900000)
#define   DI_PRE_HOLD                              (0x1733)
#define P_DI_PRE_HOLD                              (volatile uint32_t *)((0x1733  << 2) + 0xff900000)
//// DET 3D REG DEFINE BEGIN ////
//// 8'h34~8'h3f
//     `define DET3D_MOTN_CFG                8'h34
//     //Bit 16,    reg_det3d_intr_en           Det3d interrupt enable
//     //Bit 9:8,   reg_Det3D_Motion_Mode       U2  Different mode for Motion Calculation of Luma and Chroma:
//     //                                      0: MotY, 1: (2*MotY + (MotU + MotV))/4; 2: Max(MotY, MotU,MotV); 3:Max(MotY, (MotU+MotV)/2)
//     //Bit 7:4,   reg_Det3D_Motion_Core_Rate  U4  K Rate to Edge (HV) details for coring of Motion Calculations, normalized to 32
//     //Bit 3:0,   reg_Det3D_Motion_Core_Thrd  U4  2X: static coring value for Motion Detection.
//
//     `define DET3D_CB_CFG                  8'h35
//     //Bit 7:4,   reg_Det3D_ChessBd_NHV_ofst  U4,  Noise immune offset for NON-Horizontal or vertical combing detection.
//     //Bit 3:0,   reg_Det3D_ChessBd_HV_ofst   U4,  Noise immune offset for Horizontal or vertical combing detection.
//
//     `define DET3D_SPLT_CFG                8'h36
//     //Bit 7:4,   reg_Det3D_SplitValid_ratio  U4,  Ratio between max_value and the avg_value of the edge mapping for split line valid detection.
//     //                                      The smaller of this value, the easier of the split line detected.
//     //Bit 3:0,   reg_Det3D_AvgIdx_ratio      U4,  Ratio to the avg_value of the edge mapping for split line position estimation.
//     //                                      The smaller of this value, the more samples will be added to the estimation.
//
//     `define DET3D_HV_MUTE                 8'h37
//     //Bit 23:20, reg_Det3D_Edge_Ver_Mute U4  X2: Horizontal pixels to be mute from H/V Edge calculation Top and Bottom border part.
//     //Bit 19:16, reg_Det3D_Edge_Hor_Mute U4  X2: Horizontal pixels to be mute from H/V Edge calculation Left and right border part.
//     //Bit 15:12, reg_Det3D_ChessBd_Ver_Mute  U4  X2: Horizontal pixels to be mute from ChessBoard statistics calculation in middle part
//     //Bit 11:8,   reg_Det3D_ChessBd_Hor_Mute U4  X2: Horizontal pixels to be mute from ChessBoard statistics calculation in middle part
//     //Bit 7:4,    reg_Det3D_STA8X8_Ver_Mute  U4  1X: Vertical pixels to be mute from 8x8 statistics calculation in each block.
//     //Bit 3:0,    reg_Det3D_STA8X8_Hor_Mute  U4  1X: Horizontal pixels to be mute from 8x8 statistics calculation in each block.
//
//     `define DET3D_MAT_STA_P1M1            8'h38
//     //Bit 31:24, reg_Det3D_STA8X8_P1_K0_R8   U8  SAD to SAI ratio to decide P1, normalized to 256 (0.8)
//     //Bit 23:16, reg_Det3D_STA8X8_P1_K1_R7   U8  SAD to ENG ratio to decide P1, normalized to 128 (0.5)
//     //Bit 15:8,   reg_Det3D_STA8X8_M1_K0_R6  U8  SAD to SAI ratio to decide M1, normalized to 64  (1.1)
//     //Bit 7:0,    reg_Det3D_STA8X8_M1_K1_R6  U8  SAD to ENG ratio to decide M1, normalized to 64  (0.8)
//
//     `define DET3D_MAT_STA_P1TH            8'h39
//     //Bit 23:16, reg_Det3D_STAYUV_P1_TH_L4   U8  SAD to ENG Thrd offset to decide P1, X16         (100)
//     //Bit 15:8,   reg_Det3D_STAEDG_P1_TH_L4  U8  SAD to ENG Thrd offset to decide P1, X16         (80)
//     //Bit 7:0,    reg_Det3D_STAMOT_P1_TH_L4  U8  SAD to ENG Thrd offset to decide P1, X16         (48)
//
//     `define DET3D_MAT_STA_M1TH            8'h3a
//     //Bit 23:16, reg_Det3D_STAYUV_M1_TH_L4   U8  SAD to ENG Thrd offset to decide M1, X16         (100)
//     //Bit 15:8,   reg_Det3D_STAEDG_M1_TH_L4  U8  SAD to ENG Thrd offset to decide M1, X16         (80)
//     //Bit 7:0,    reg_Det3D_STAMOT_M1_TH_L4  U8  SAD to ENG Thrd offset to decide M1, X16         (64)
//
//     `define DET3D_MAT_STA_RSFT            8'h3b
//     //Bit 5:4,    reg_Det3D_STAYUV_RSHFT     U2  YUV statistics SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//     //                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//     //Bit 3:2,    reg_Det3D_STAEDG_RSHFT     U2  Horizontal and Vertical Edge Statistics SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//     //                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//     //Bit 1:0,    reg_Det3D_STAMOT_RSHFT     U2  Motion SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//     //                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//
//     `define DET3D_MAT_SYMTC_TH            8'h3c
//     //Bit 31:24, reg_Det3D_STALUM_symtc_Th     U8  threshold to decide if the Luma statistics is TB or LR symmetric.
//     //Bit 23:16, reg_Det3D_STACHR_symtc_Th     U8  threshold to decide if the Chroma (UV) statistics is TB or LR symmetric.
//     //Bit 15:8,   reg_Det3D_STAEDG_symtc_Th    U8  threshold to decide if the Horizontal and Vertical Edge statistics is TB or LR symmetric.
//     //Bit 7:0,    reg_Det3D_STAMOT_symtc_Th    U8  threshold to decide if the Motion statistics is TB or LR symmetric.
//
//     `define DET3D_RO_DET_CB_HOR           8'h3d
//     //Bit 31:16, RO_Det3D_ChessBd_NHor_value    U16  X64: number of Pixels of Horizontally Surely NOT matching Chessboard pattern.
//     //Bit 15:0,   RO_Det3D_ChessBd_Hor_value     U16  X64: number of Pixels of Horizontally Surely matching Chessboard pattern.
//
//     `define DET3D_RO_DET_CB_VER           8'h3e
//     //Bit 31:16, RO_Det3D_ChessBd_NVer_value U16  X64: number of Pixels of Vertically Surely NOT matching Chessboard pattern.
//     //Bit 15:0,   RO_Det3D_ChessBd_Ver_value     U16  X64: number of Pixels of Vertically Surely matching Chessboard pattern.
//
//     `define DET3D_RO_SPLT_HT              8'h3f
//     //Bit 24,     RO_Det3D_Split_HT_valid    U1  horizontal LR split border detected valid signal for top half picture
//     //Bit 20:16, RO_Det3D_Split_HT_pxnum U5  number of pixels included for the LR split position estimation for top half picture
//     //Bit 9:0,    RO_Det3D_Split_HT_idxX4    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
//
//     //// DET 3D REG DEFINE END ////
#define   DI_MTN_1_CTRL1                           (0x1740)
#define P_DI_MTN_1_CTRL1                           (volatile uint32_t *)((0x1740  << 2) + 0xff900000)
//bit 31,      mtn_1_en
//bit 30,      mtn_init
//bit 29,      di2nr_txt_en
//bit 28,      reserved
//bit 27:24,   mtn_def
//bit 23:16,   mtn_adp_yc
//bit 15:8,    mtn_adp_2c
//bit 7:0,     mtn_adp_2y
#define   DI_MTN_1_CTRL2                           (0x1741)
#define P_DI_MTN_1_CTRL2                           (volatile uint32_t *)((0x1741  << 2) + 0xff900000)
//bit 31:24,   mtn_ykinter
//bit 23:16,   mtn_ckinter
//bit 15:8,    mtn_ykintra
//bit  7:0,    mtn_ckintra
#define   DI_MTN_1_CTRL3                           (0x1742)
#define P_DI_MTN_1_CTRL3                           (volatile uint32_t *)((0x1742  << 2) + 0xff900000)
//bit 31:24,   mtn_tyrate
//bit 23:16,   mtn_tcrate
//bit 15: 8,   mtn_mxcmby
//bit  7: 0,   mtn_mxcmbc
#define   DI_MTN_1_CTRL4                           (0x1743)
#define P_DI_MTN_1_CTRL4                           (volatile uint32_t *)((0x1743  << 2) + 0xff900000)
//bit 31:24,   mtn_tcorey
//bit 23:16,   mtn_tcorec
//bit 15: 8,   mtn_minth
//bit  7: 0,   mtn_maxth
#define   DI_MTN_1_CTRL5                           (0x1744)
#define P_DI_MTN_1_CTRL5                           (volatile uint32_t *)((0x1744  << 2) + 0xff900000)
//bit 31:28,   mtn_m1b_extend
//bit 27:24,   mtn_m1b_errod
//bit 21:20,   mtn_mot_txt_mode
//bit 19:18,   mtn_replace_cbyy
//bit 17:16,   mtn_replace_ybyc
//bit 15: 8,   mtn_core_ykinter
//bit  7: 0,   mtn_core_ckinter
//// NR2 REG DEFINE BEGIN////
#define   NR2_MET_NM_CTRL                          (0x1745)
#define P_NR2_MET_NM_CTRL                          (volatile uint32_t *)((0x1745  << 2) + 0xff900000)
//Bit 28,      reg_NM_reset           Reset to the status of the Loop filter.
//Bit 27:24,   reg_NM_calc_length     Length mode of the Noise measurement sample number for statistics.
//                                    0:  256 samples;    1: 512 samples;    2: 1024 samples;   隆颅X: 2^(8+x) samples
//Bit 23:20,   reg_NM_inc_step        Loop filter input gain increase step.
//Bit 19:16,   reg_NM_dec_step        Loop filter input gain decrease step.
//Bit 15:8,    reg_NM_YHPmot_thrd     Luma channel HP portion motion for condition of pixels included in Luma Noise measurement.
//Bit 7:0,     reg_NM_CHPmot_thrd     Chroma channel HP portion motion for condition of pixels included in Chroma Noise measurement.
#define   NR2_MET_NM_YCTRL                         (0x1746)
#define P_NR2_MET_NM_YCTRL                         (volatile uint32_t *)((0x1746  << 2) + 0xff900000)
//Bit 31:28,   reg_NM_YPLL_target         Target rate of NM_Ynoise_thrd to mean of the Luma Noise
//Bit 27:24,   reg_NM_YLPmot_thrd         Luma channel LP portion motion for condition of pixels included in Luma Noise measurement.
//Bit 23:16,   reg_NM_YHPmot_thrd_min     Minimum threshold for Luma channel HP portion motion to decide whether the pixel will be included in Luma noise measurement.
//Bit 15:8,    reg_NM_YHPmot_thrd_max     Maximum threshold for Luma channel HP portion motion to decide whether the pixel will be included in Luma noise measurement.
//Bit 7:0,     reg_NM_Ylock_rate          Rate to decide whether the Luma noise measurement is lock or not.
#define   NR2_MET_NM_CCTRL                         (0x1747)
#define P_NR2_MET_NM_CCTRL                         (volatile uint32_t *)((0x1747  << 2) + 0xff900000)
//Bit 31:28,    reg_NM_CPLL_target       Target rate of NM_Cnoise_thrd to mean of the Chroma Noise
//Bit 27:24,    reg_NM_CLPmot_thrd       Chroma channel LP portion motion for condition of pixels included in Chroma Noise measurement.
//Bit 23:16,    reg_NM_CHPmot_thrd_min   Minimum threshold for Chroma channel HP portion motion to decide whether the pixel will be included in Chroma noise measurement.
//Bit 15:8,     reg_NM_CHPmot_thrd_max   Maximum threshold for Chroma channel HP portion motion to decide whether the pixel will be included in Chroma noise measurement.
//Bit 7:0,      reg_NM_Clock_rate        Rate to decide whether the Chroma noise measurement is lock or not;
#define   NR2_MET_NM_TNR                           (0x1748)
#define P_NR2_MET_NM_TNR                           (volatile uint32_t *)((0x1748  << 2) + 0xff900000)
//Bit 25,       ro_NM_TNR_Ylock          Read-only register to tell ifLuma channel noise measurement is locked or not.
//Bit 24,       ro_NM_TNR_Clock          Read-only register to tell if Chroma channel noise measurement is locked or not.
//Bit 23:12,    ro_NM_TNR_Ylevel         Read-only register to give Luma channel noise level. It was 16x of pixel difference in 8 bits of YHPmot.
//Bit 11:0, ro_NM_TNR_Clevel             Read-only register to give Chroma channel noise level. It was 16x of pixel difference in 8 bits of CHPmot.
#define   NR2_MET_NMFRM_TNR_YLEV                   (0x1749)
#define P_NR2_MET_NMFRM_TNR_YLEV                   (volatile uint32_t *)((0x1749  << 2) + 0xff900000)
//Bit 28:0, ro_NMFrm_TNR_Ylevel          Frame based Read-only register to give Luma channel noise level within one frame/field.
#define   NR2_MET_NMFRM_TNR_YCNT                   (0x174a)
#define P_NR2_MET_NMFRM_TNR_YCNT                   (volatile uint32_t *)((0x174a  << 2) + 0xff900000)
//Bit 23:0, ro_NMFrm_TNR_Ycount          Number ofLuma channel pixels included in Frame/Field based noise level measurement.
#define   NR2_MET_NMFRM_TNR_CLEV                   (0x174b)
#define P_NR2_MET_NMFRM_TNR_CLEV                   (volatile uint32_t *)((0x174b  << 2) + 0xff900000)
//Bit 28:0, ro_NMFrm_TNR_Clevel          Frame based Read-only register to give Chroma channel noise level within one frame/field.
#define   NR2_MET_NMFRM_TNR_CCNT                   (0x174c)
#define P_NR2_MET_NMFRM_TNR_CCNT                   (volatile uint32_t *)((0x174c  << 2) + 0xff900000)
//Bit 23:0, ro_NMFrm_TNR_Ccount          Number of Chroma channel pixels included in Frame/Field based noise level measurement.
#define   NR2_3DEN_MODE                            (0x174d)
#define P_NR2_3DEN_MODE                            (volatile uint32_t *)((0x174d  << 2) + 0xff900000)
//Bit 6:4,  Blend_3dnr_en_r
//Bit 2:0,  Blend_3dnr_en_l
//   `define NR2_IIR_CTRL                8'h4e
//   //Bit 15:14, reg_LP_IIR_8bit_mode  LP IIR membitwidth mode:0: 10bits will be store in memory;1: 9bits will be store in memory;
//   //                                  2: 8bits will be store in memory;3: 7bits will be store in memory;
//   //Bit 13:12, reg_LP_IIR_mute_mode  Mode for the LP IIR mute,
//   //Bit 11:8,     reg_LP_IIR_mute_thrd   Threshold of LP IIR mute to avoid ghost:
//   //Bit 7:6,  reg_HP_IIR_8bit_mode   IIR membitwidth mode:0: 10bits will be store in memory;1: 9bits will be store in memory;
//   //                                  2: 8bits will be store in memory;3: 7bits will be store in memory;
//   //Bit 5:4, reg_HP_IIR_mute_mode    Mode for theLP IIR mute
//   //Bit 3:0, reg_HP_IIR_mute_thrd    Threshold of HP IIR mute to avoid ghost
//   //
#define   NR2_SW_EN                                (0x174f)
#define P_NR2_SW_EN                                (volatile uint32_t *)((0x174f  << 2) + 0xff900000)
//Bit 17:8, Clk_gate_ctrl
//Bit 7,    Cfr_enable
//Bit 5,    Det3d_en
//Bit 4,    Nr2_proc_en
//Bit 0,    Nr2_sw_en
#define   NR2_FRM_SIZE                             (0x1750)
#define P_NR2_FRM_SIZE                             (volatile uint32_t *)((0x1750  << 2) + 0xff900000)
//Bit 27:16,  Frm_heigh Frame/field height
//Bit 11: 0,  Frm_width Frame/field width
//   `define NR2_SNR_SAD_CFG             8'h51
//   //Bit 12,  reg_MATNR_SNR_SAD_CenRPL    U1, Enable signal for Current pixel position SAD to be replaced by SAD_min.0: do not replace Current pixel position SAD by SAD_min;1: do replacements
//   //Bit 11:8,    reg_MATNR_SNR_SAD_coring    Coring value of the intra-frame SAD. sum = (sum - reg_MATNR_SNR_SAD_coring);sum = (sum<0) ? 0: (sum>255)? 255: sum;
//   //Bit 6:5, reg_MATNR_SNR_SAD_WinMod    Unsigned, Intra-frame SAD matching window mode:0: 1x1; 1: [1 1 1] 2: [1 2 1]; 3: [1 2 2 2 1];
//   //Bit 4:0, Sad_coef_num                Sad coeffient
//
//   `define NR2_MATNR_SNR_OS            8'h52
//   //Bit 7:4, reg_MATNR_SNR_COS       SNR Filter overshoot control margin for UV channel (X2 to u10 scale)
//   //Bit 3:0, reg_MATNR_SNR_YOS       SNR Filter overshoot control margin for luma channel (X2 to u10 scale)
//
//   `define NR2_MATNR_SNR_NRM_CFG       8'h53
//   //Bit 23:16,   reg_MATNR_SNR_NRM_ofst  Edge based SNR boosting normalization offset to SAD_max ;
//   //Bit 15:8,        reg_MATNR_SNR_NRM_max   Edge based SNR boosting normalization Max value
//   //Bit 7:0,     reg_MATNR_SNR_NRM_min   Edge based SNR boosting normalization Min value
//
//   `define NR2_MATNR_SNR_NRM_GAIN      8'h54
//   //Bit 15:8,    reg_MATNR_SNR_NRM_Cgain Edge based SNR boosting normalization Gain for Chrm channel (norm 32 as 1)
//   //Bit 7:0, reg_MATNR_SNR_NRM_Ygain Edge based SNR boosting normalization Gain for Luma channel (norm 32 as 1)
//
//   `define NR2_MATNR_SNR_LPF_CFG       8'h55
//   //Bit 23:16,reg_MATNR_SNRLPF_SADmaxTH  U8,  Threshold to SADmax to use TNRLPF to replace SNRLPF. i.e.if (SAD_max<reg_MATNR_SNRLPF_SADmaxTH) SNRLPF_yuv[k] = TNRLPF_yuv[k];
//   //Bit 13:11,reg_MATNR_SNRLPF_Cmode     LPF based SNR filtering mode on CHRM channel:
//   //                                      0: gradient LPF [1 1]/2, 1: gradient LPF [2 1 1]/4; 2: gradient LPF [3 3 2]/8; 3: gradient LPF [5 4 4 3]/16;
//   //                                      4: TNRLPF;  5 : CurLPF3x3_yuv[];  6: CurLPF3o3_yuv[]  7: CurLPF3x5_yuv[]
//   //Bit 10:8,    reg_MATNR_SNRLPF_Ymode      LPF based SNR filtering mode on LUMA channel:
//   //                                      0: gradient LPF //Bit [1 1]/2, 1: gradient LPF [2 1 1]/4; 2: gradient LPF [3 3 2]/8;3: gradient LPF [5 4 4 3]/16;
//   //                                      4: TNRLPF;               5 : CurLPF3x3_yuv[];       6: CurLPF3o3_yuv[]         7: CurLPF3x5_yuv[]
//   //Bit 7:4, reg_MATNR_SNRLPF_SADmin3TH  Offset threshold to SAD_min to Discard SAD_min3 corresponding pixel in LPF SNR filtering. (X8 to u8 scale)
//   //Bit 3:0, reg_MATNR_SNRLPF_SADmin2TH  Offset threshold to SAD_min to Discard SAD_min2 corresponding pixel in LPF SNR filtering. (X8 to u8 scale)
//
//   `define NR2_MATNR_SNR_USF_GAIN      8'h56
//   //Bit 15:8,    reg_MATNR_SNR_USF_Cgain     Un-sharp (HP) compensate back Chrm portion gain, (norm 64 as 1)
//   //Bit 7:0, reg_MATNR_SNR_USF_Ygain     Un-sharp (HP) compensate back Luma portion gain, (norm 64 as 1)
//
//   `define NR2_MATNR_SNR_EDGE2B        8'h57
//   //Bit 15:8,    reg_MATNR_SNR_Edge2Beta_ofst    U8,  Offset for Beta based on Edge.
//   //Bit 7:0, reg_MATNR_SNR_Edge2Beta_gain    U8.  Gain to SAD_min for Beta based on Edge. (norm 16 as 1)
//
//   `define NR2_MATNR_BETA_EGAIN        8'h58
//   //Bit 15:8,    reg_MATNR_CBeta_Egain   U8,  Gain to Edge based Beta for Chrm channel. (normalized to 32 as 1)
//   //Bit 7:0, reg_MATNR_YBeta_Egain   U8,  Gain to Edge based Beta for Luma channel. (normalized to 32 as 1)
//
//   `define NR2_MATNR_BETA_BRT          8'h59
//   //Bit 31:28,   reg_MATNR_beta_BRT_limt_hi  U4,  Beta adjustment based on Brightness high side Limit. (X16 to u8 scale)
//   //Bit 27:24,   reg_MATNR_beta_BRT_slop_hi  U4,  Beta adjustment based on Brightness high side slope. Normalized to 16 as 1
//   //Bit 23:16,   reg_MATNR_beta_BRT_thrd_hi  U8,  Beta adjustment based on Brightness high threshold.(u8 scale)
//   //Bit 15:12,   reg_MATNR_beta_BRT_limt_lo  U4,  Beta adjustment based on Brightness low side Limit. (X16 to u8 scale)
//   //Bit 11:8,        reg_MATNR_beta_BRT_slop_lo  U4,  Beta adjustment based on Brightness low side slope. Normalized to 16 as 1
//   //Bit 7:0,     reg_MATNR_beta_BRT_thrd_lo  U8,  Beta adjustment based on Brightness low threshold.(u8 scale)
//   `define NR2_MATNR_XBETA_CFG         8'h5a
//   //Bit 19:18,   reg_MATNR_CBeta_use_mode    U2,  Beta options (mux) from beta_motion and beta_edge for Chrm channel;
//   //Bit 17:16,   reg_MATNR_YBeta_use_mode    U2,  Beta options (mux) from beta_motion and beta_edge for Luma channel;
//   //Bit 15: 8,   reg_MATNR_CBeta_Ofst        U8,  Offset to Beta for Chrm channel.(after beta_edge and beta_motion mux)
//   //Bit  7: 0,   reg_MATNR_YBeta_Ofst        U8,  Offset to Beta for Luma channel.(after beta_edge and beta_motion mux)
//   `define NR2_MATNR_YBETA_SCL         8'h5b
//   //Bit 31:24,   reg_MATNR_YBeta_scale_min   U8,  Final step Beta scale low limit for Luma channel;
//   //Bit 23:16,   reg_MATNR_YBeta_scale_max   U8,  Final step Beta scale high limit for Luma channe;
//   //Bit 15: 8,   reg_MATNR_YBeta_scale_gain  U8,  Final step Beta scale Gain for Luma channel (normalized 32 to 1);
//   //Bit 7 : 0,   reg_MATNR_YBeta_scale_ofst  S8,  Final step Beta scale offset for Luma channel ;
//   `define NR2_MATNR_CBETA_SCL         8'h5c
//   //Bit 31:24,   reg_MATNR_CBeta_scale_min   Final step Beta scale low limit for Chrm channel.Similar to Y
//   //Bit 23:16,   reg_MATNR_CBeta_scale_max   U8,  Final step Beta scale high limit for Chrm channel.Similar to Y
//   //Bit 15: 8,   reg_MATNR_CBeta_scale_gain  U8,  Final step Beta scale Gain for Chrm channel Similar to Y
//   //Bit  7: 0,   reg_MATNR_CBeta_scale_ofst  S8,  Final step Beta scale offset for Chrm channel Similar to Y
//   `define NR2_SNR_MASK                8'h5d
//   //Bit 20:0,    SAD_MSK                     Valid signal in the 3x7 SAD surface
//   `define NR2_SAD2NORM_LUT0           8'h5e
//   //Bit 31:24,   reg_MATNR_SAD2Norm_LUT_3    SAD convert normal LUT node 3
//   //Bit 23:16,   reg_MATNR_SAD2Norm_LUT_2    SAD convert normal LUT node 2
//   //Bit 15: 8,   reg_MATNR_SAD2Norm_LUT_1    SAD convert normal LUT node 1
//   //Bit  7: 0,   reg_MATNR_SAD2Norm_LUT_0    SAD convert normal LUT node 0
//   `define NR2_SAD2NORM_LUT1           8'h5f
//   //Bit 31:24,   reg_MATNR_SAD2Norm_LUT_7    SAD convert normal LUT node 7
//   //Bit 23:16,   reg_MATNR_SAD2Norm_LUT_6    SAD convert normal LUT node 6
//   //Bit 15: 8,   reg_MATNR_SAD2Norm_LUT_5    SAD convert normal LUT node 5
//   //Bit  7: 0,   reg_MATNR_SAD2Norm_LUT_4    SAD convert normal LUT node 4
//   `define NR2_SAD2NORM_LUT2           8'h60
//   //Bit 31:24,   reg_MATNR_SAD2Norm_LUT_11   SAD convert normal LUT node 11
//   //Bit 23:16,   reg_MATNR_SAD2Norm_LUT_10   SAD convert normal LUT node 10
//   //Bit 15: 8,   reg_MATNR_SAD2Norm_LUT_9    SAD convert normal LUT node 9
//   //Bit  7: 0,   reg_MATNR_SAD2Norm_LUT_8    SAD convert normal LUT node 8
//   `define NR2_SAD2NORM_LUT3           8'h61
//   //Bit 31:24,   reg_MATNR_SAD2Norm_LUT_15   SAD convert normal LUT node 15
//   //Bit 23:16,   reg_MATNR_SAD2Norm_LUT_14   SAD convert normal LUT node 14
//   //Bit 15:8,    reg_MATNR_SAD2Norm_LUT_13   SAD convert normal LUT node 13
//   //Bit 7:0, reg_MATNR_SAD2Norm_LUT_12   SAD convert normal LUT node 12
//   `define NR2_EDGE2BETA_LUT0          8'h62
//   //Bit 31:24,   reg_MATNR_Edge2Beta_LUT_3   Edge convert beta LUT node 3
//   //Bit 23:16,   reg_MATNR_Edge2Beta_LUT_2   Edge convert beta LUT node 2
//   //Bit 15: 8,   reg_MATNR_Edge2Beta_LUT_1   Edge convert beta LUT node 1
//   //Bit  7: 0,   reg_MATNR_Edge2Beta_LUT_0   Edge convert beta LUT node 0
//   `define NR2_EDGE2BETA_LUT1          8'h63
//   //Bit 31:24,   reg_MATNR_Edge2Beta_LUT_7   Edge convert beta LUT node 7
//   //Bit 23:16,   reg_MATNR_Edge2Beta_LUT_6   Edge convert beta LUT node 6
//   //Bit 15: 8,   reg_MATNR_Edge2Beta_LUT_5   Edge convert beta LUT node 5
//   //Bit  7: 0,   reg_MATNR_Edge2Beta_LUT_4   Edge convert beta LUT node 4
//   `define NR2_EDGE2BETA_LUT2          8'h64
//   //Bit 31:24,   reg_MATNR_Edge2Beta_LUT_11  Edge convert beta LUT node 11
//   //Bit 23:16,   reg_MATNR_Edge2Beta_LUT_10  Edge convert beta LUT node 10
//   //Bit 15: 8,   reg_MATNR_Edge2Beta_LUT_9   Edge convert beta LUT node 9
//   //Bit  7: 0,   reg_MATNR_Edge2Beta_LUT_8   Edge convert beta LUT node 8
//   `define NR2_EDGE2BETA_LUT3          8'h65
//   //Bit 31:24,   reg_MATNR_Edge2Beta_LUT_15  Edge convert beta LUT node 15
//   //Bit 23:16,   reg_MATNR_Edge2Beta_LUT_14  Edge convert beta LUT node 14
//   //Bit 15: 8,   reg_MATNR_Edge2Beta_LUT_13  Edge convert beta LUT node 13
//   //Bit  7: 0,   reg_MATNR_Edge2Beta_LUT_12  Edge convert beta LUT node 12
//   `define NR2_MOTION2BETA_LUT0        8'h66
//   //Bit 31:24,   reg_MATNR_Mot2Beta_LUT_3    Motion convert beta LUT node 3
//   //Bit 23:16,   reg_MATNR_Mot2Beta_LUT_2    Motion convert beta LUT node 2
//   //Bit 15: 8,   reg_MATNR_Mot2Beta_LUT_1    Motion convert beta LUT node 1
//   //Bit  7: 0,   reg_MATNR_Mot2Beta_LUT_0    Motion convert beta LUT node 0
//   `define NR2_MOTION2BETA_LUT1        8'h67
//   //Bit 31:24,   reg_MATNR_Mot2Beta_LUT_7    Motion convert beta LUT node 7
//   //Bit 23:16,   reg_MATNR_Mot2Beta_LUT_6    Motion convert beta LUT node 6
//   //Bit 15: 8,   reg_MATNR_Mot2Beta_LUT_5    Motion convert beta LUT node 5
//   //Bit  7: 0,   reg_MATNR_Mot2Beta_LUT_4    Motion convert beta LUT node 4
//   `define NR2_MOTION2BETA_LUT2        8'h68
//   //Bit 31:24,   reg_MATNR_Mot2Beta_LUT_11   Motion convert beta LUT node 11
//   //Bit 23:16,   reg_MATNR_Mot2Beta_LUT_10   Motion convert beta LUT node 10
//   //Bit 15: 8,   reg_MATNR_Mot2Beta_LUT_9    Motion convert beta LUT node 9
//   //Bit  7: 0,   reg_MATNR_Mot2Beta_LUT_8    Motion convert beta LUT node 8
//   `define NR2_MOTION2BETA_LUT3        8'h69
//   //Bit 31:24,   reg_MATNR_Mot2Beta_LUT_15   Motion convert beta LUT node 15
//   //Bit 23:16,   reg_MATNR_Mot2Beta_LUT_14   Motion convert beta LUT node 14
//   //Bit 15: 8,   reg_MATNR_Mot2Beta_LUT_13   Motion convert beta LUT node 13
//   //Bit  7: 0,   reg_MATNR_Mot2Beta_LUT_12   Motion convert beta LUT node 12
//    `define NR2_MATNR_MTN_CRTL          8'h6a
//    //Bit 25:24,  reg_MATNR_Vmtn_use_mode     Motion_yuvV channel motion selection mode:0: Vmot;1:Ymot/2 + (Umot+Vmot)/4; 2:Ymot/2 + max(Umot,Vmot)/2; 3: max(Ymot,Umot, Vmot)
//    //Bit 21:20,  reg_MATNR_Umtn_use_mode     Motion_yuvU channel motion selection mode:0:Umot;1:Ymot/2 + (Umot+Vmot)/4; 2:Ymot/2 + max(Umot,Vmot)/2; 3: max(Ymot,Umot, Vmot)
//    //Bit 17:16,  reg_MATNR_Ymtn_use_mode     Motion_yuvLuma channel motion selection mode:0:  Ymot, 1: Ymot/2 + (Umot+Vmot)/4; 2: Ymot/2 + max(Umot,Vmot)/2; 3:  max(Ymot,Umot, Vmot)
//    //Bit 13:12,  reg_MATNR_mtn_txt_mode      Texture detection mode for adaptive coring of HP motion
//    //Bit  9: 8,  reg_MATNR_mtn_cor_mode      Coring selection mode based on texture detection;
//    //Bit  6: 4,  reg_MATNR_mtn_hpf_mode      video mode of current and previous frame/field for MotHPF_yuv[k] calculation:
//    //Bit  2: 0,  reg_MATNR_mtn_lpf_mode      LPF video mode of current and previous frame/field for MotLPF_yuv[k] calculation:
//    `define NR2_MATNR_MTN_CRTL2         8'h6b
//    //Bit 18:16,  reg_MATNR_iir_BS_Ymode      IIR TNR filter Band split filter mode for Luma LPF result generation (Cur and Prev);
//    //Bit 15: 8,  reg_MATNR_mtnb_alpLP_Cgain  Scale of motion_brthp_uv to motion_brtlp_uv, normalized to 32 as 1
//    //Bit  7: 0,  reg_MATNR_mtnb_alpLP_Ygain  Scale of motion_brthp_y to motion_brtlp_y, normalized to 32 as 1
//    `define NR2_MATNR_MTN_COR           8'h6c
//    //Bit 15:12,  reg_MATNR_mtn_cor_Cofst     Coring Offset for Chroma Motion.
//    //Bit 11: 8,  reg_MATNR_mtn_cor_Cgain     Gain to texture based coring for Chroma Motion. Normalized to 16 as 1
//    //Bit  7: 4,  reg_MATNR_mtn_cor_Yofst     Coring Offset for Luma Motion.
//    //Bit  3: 0,  reg_MATNR_mtn_cor_Ygain     Gain to texture based coring for Luma Motion. Normalized to 16 as 1
//    `define NR2_MATNR_MTN_GAIN          8'h6d
//    //Bit 31:24,  reg_MATNR_mtn_hp_Cgain  Gain to MotHPF_yuv[k] Chrm channel for motion calculation, normalized to 64 as 1
//    //Bit 23:16,  reg_MATNR_mtn_hp_Ygain  Gain to MotHPF_yuv[k] Luma channel for motion calculation, normalized to 64 as 1
//    //Bit 15: 8,  reg_MATNR_mtn_lp_Cgain  Gain to MotLPF_yuv[k] Chrm channel for motion calculation, normalized to 32 as 1
//    //Bit  7: 0,  reg_MATNR_mtn_lp_Ygain  Gain to MotLPF_yuv[k] Luma channel for motion calculation, normalized to 32 as 1
//    `define NR2_MATNR_DEGHOST           8'h6e
//    //Bit 8,  reg_MATNR_DeGhost_En    Enable signal for DeGhost function:0: disable; 1: enable
//    //Bit 7:4,    reg_MATNR_DeGhost_COS   DeGhost Overshoot margin for UV channel, (X2 to u10 scale)
//    //Bit 3:0,    reg_MATNR_DeGhost_YOS   DeGhost Overshoot margin for Luma channel, (X2 to u10 scale)
//
//    `define NR2_MATNR_ALPHALP_LUT0      8'h6f
//    //Bit 31:24,  reg_MATNR_AlphaLP_LUT_3     Matnr low-pass filter alpha LUT node 3
//    //Bit 23:16,  reg_MATNR_AlphaLP_LUT_2     Matnr low-pass filter alpha LUT node 2
//    //Bit 15: 8,  reg_MATNR_AlphaLP_LUT_1     Matnr low-pass filter alpha LUT node 1
//    //Bit  7: 0,  reg_MATNR_AlphaLP_LUT_0     Matnr low-pass filter alpha LUT node 0
//    `define NR2_MATNR_ALPHALP_LUT1      8'h70
//    //Bit 31:24,  reg_MATNR_AlphaLP_LUT_7     Matnr low-pass filter alpha LUT node 7
//    //Bit 23:16,  reg_MATNR_AlphaLP_LUT_6     Matnr low-pass filter alpha LUT node 6
//    //Bit 15: 8,  reg_MATNR_AlphaLP_LUT_5     Matnr low-pass filter alpha LUT node 5
//    //Bit  7: 0,  reg_MATNR_AlphaLP_LUT_4     Matnr low-pass filter alpha LUT node 4
//    `define NR2_MATNR_ALPHALP_LUT2      8'h71
//    //Bit 31:24,  reg_MATNR_AlphaLP_LUT_11    Matnr low-pass filter alpha LUT node 11
//    //Bit 23:16,  reg_MATNR_AlphaLP_LUT_10    Matnr low-pass filter alpha LUT node 10
//    //Bit 15: 8,  reg_MATNR_AlphaLP_LUT_9     Matnr low-pass filter alpha LUT node 9
//    //Bit  7: 0,  reg_MATNR_AlphaLP_LUT_8     Matnr low-pass filter alpha LUT node 8
//    `define NR2_MATNR_ALPHALP_LUT3      8'h72
//    //Bit 31:24,  reg_MATNR_AlphaLP_LUT_15    Matnr low-pass filter alpha LUT node 15
//    //Bit 23:16,  reg_MATNR_AlphaLP_LUT_14    Matnr low-pass filter alpha LUT node 14
//    //Bit 15: 8,  reg_MATNR_AlphaLP_LUT_13    Matnr low-pass filter alpha LUT node 13
//    //Bit  7: 0,  reg_MATNR_AlphaLP_LUT_12    Matnr low-pass filter alpha LUT node 12
//    `define NR2_MATNR_ALPHAHP_LUT0      8'h73
//    //Bit 31:24,  reg_MATNR_AlphaHP_LUT_3     Matnr high-pass filter alpha LUT node 3
//    //Bit 23:16,  reg_MATNR_AlphaHP_LUT_2     Matnr high-pass filter alpha LUT node 2
//    //Bit 15: 8,  reg_MATNR_AlphaHP_LUT_1     Matnr high-pass filter alpha LUT node 1
//    //Bit  7: 0,  reg_MATNR_AlphaHP_LUT_0     Matnr high-pass filter alpha LUT node 0
//    `define NR2_MATNR_ALPHAHP_LUT1      8'h74
//    //Bit 31:24,  reg_MATNR_AlphaHP_LUT_7     Matnr high-pass filter alpha LUT node 7
//    //Bit 23:16,  reg_MATNR_AlphaHP_LUT_6     Matnr high-pass filter alpha LUT node 6
//    //Bit 15: 8,  reg_MATNR_AlphaHP_LUT_5     Matnr high-pass filter alpha LUT node 5
//    //Bit  7: 0,  reg_MATNR_AlphaHP_LUT_4     Matnr high-pass filter alpha LUT node 4
//    `define NR2_MATNR_ALPHAHP_LUT2      8'h75
//    //Bit 31:24,  reg_MATNR_AlphaHP_LUT_11    Matnr high-pass filter alpha LUT node 11
//    //Bit 23:16,  reg_MATNR_AlphaHP_LUT_10    Matnr high-pass filter alpha LUT node 10
//    //Bit 15: 8,  reg_MATNR_AlphaHP_LUT_9     Matnr high-pass filter alpha LUT node 9
//    //Bit  7: 0,  reg_MATNR_AlphaHP_LUT_8     Matnr high-pass filter alpha LUT node 8
//    `define NR2_MATNR_ALPHAHP_LUT3      8'h76
//    //Bit 31:24,  reg_MATNR_AlphaHP_LUT_15    Matnr high-pass filter alpha LUT node 15
//    //Bit 23:16,  reg_MATNR_AlphaHP_LUT_14    Matnr high-pass filter alpha LUT node 14
//    //Bit 15: 8,  reg_MATNR_AlphaHP_LUT_13    Matnr high-pass filter alpha LUT node 13
//    //Bit  7: 0,  reg_MATNR_AlphaHP_LUT_12    Matnr high-pass filter alpha LUT node 12
//
//    `define NR2_MATNR_MTNB_BRT          8'h77
//    //Bit 31:28,  reg_MATNR_mtnb_BRT_limt_hi  Motion adjustment based on Brightness high side Limit. (X16 to u8 scale)
//    //Bit 27:24,  reg_MATNR_mtnb_BRT_slop_hi  Motion adjustment based on Brightness high side slope. Normalized to 16 as 1
//    //Bit 23:16,  reg_MATNR_mtnb_BRT_thrd_hi  Motion adjustment based on Brightness high threshold.(u8 scale)
//    //Bit 15:12,  reg_MATNR_mtnb_BRT_limt_lo  Motion adjustment based on Brightness low side Limit. (X16 to u8 scale)
//    //Bit 11: 8,  reg_MATNR_mtnb_BRT_slop_lo  Motion adjustment based on Brightness low side slope. Normalized to 16 as 1
//    //Bit  7: 0,  reg_MATNR_mtnb_BRT_thrd_lo  Motion adjustment based on Brightness low threshold.(u8 scale)
// 0x51 - 0x69 | 0x4e | 0x6a - 0x77
//
// Reading file:  nr2_regs.h
//
// synopsys translate_off
// synopsys translate_on
//========== nr2_snr_regs register begin ==========//
#define   NR2_SNR_SAD_CFG                          (0x1751)
#define P_NR2_SNR_SAD_CFG                          (volatile uint32_t *)((0x1751  << 2) + 0xff900000)
//Bit 31:13        reserved
//Bit 12           reg_matnr_snr_sad_cenrpl       // unsigned , default = 1
//Bit 11: 8        reg_matnr_snr_sad_coring       // unsigned , default = 3
//Bit  7            reserved
//Bit  6: 5        reg_matnr_snr_sad_winmod       // unsigned , default = 1     0: 1x1; 1: [1 1 1] 2: [1 2 1]; 3: [1 2 2 2 1];
//Bit  4: 0        sad_coef_num                      // unsigned , default = 1     0: 1x1; 1: [1 1 1] 2: [1 2 1]; 3: [1 2 2 2 1];
#define   NR2_MATNR_SNR_OS                         (0x1752)
#define P_NR2_MATNR_SNR_OS                         (volatile uint32_t *)((0x1752  << 2) + 0xff900000)
//Bit 31: 8        reserved
//Bit  7: 4        reg_matnr_snr_cos              // unsigned , default = 8
//Bit  3: 0        reg_matnr_snr_yos              // unsigned , default = 13
#define   NR2_MATNR_SNR_NRM_CFG                    (0x1753)
#define P_NR2_MATNR_SNR_NRM_CFG                    (volatile uint32_t *)((0x1753  << 2) + 0xff900000)
//Bit 31:24        reserved
//Bit 23:16        reg_matnr_snr_nrm_ofst         // signed , default = 64
//Bit 15: 8        reg_matnr_snr_nrm_max          // unsigned , default = 255
//Bit  7: 0        reg_matnr_snr_nrm_min          // unsigned , default = 0
#define   NR2_MATNR_SNR_NRM_GAIN                   (0x1754)
#define P_NR2_MATNR_SNR_NRM_GAIN                   (volatile uint32_t *)((0x1754  << 2) + 0xff900000)
//Bit 31:16        reserved
//Bit 15: 8        reg_matnr_snr_nrm_cgain        // unsigned , default = 0     norm 32
//Bit  7: 0        reg_matnr_snr_nrm_ygain        // unsigned , default = 32    norm 32
#define   NR2_MATNR_SNR_LPF_CFG                    (0x1755)
#define P_NR2_MATNR_SNR_LPF_CFG                    (volatile uint32_t *)((0x1755  << 2) + 0xff900000)
//Bit 31:24        reserved
//Bit 23:16        reg_matnr_snrlpf_sadmaxth      // unsigned , default = 12
//Bit 15:14        reserved
//Bit 13:11        reg_matnr_snrlpf_cmode         // unsigned , default = 2     0: gradient LPF [1 1]/2, 1: gradient LPF [2 1 1]/4; 2: gradient LPF [3 3 2]/8; 3: gradient LPF [5 5 4 3]/16;
//Bit 10: 8        reg_matnr_snrlpf_ymode         // unsigned , default = 2     0: gradient LPF [1 1]/2, 1: gradient LPF [2 1 1]/4; 2: gradient LPF [3 3 2]/8; 3: gradient LPF [5 5 4 3]/16;
//Bit  7: 4        reg_matnr_snrlpf_sadmin3th     // unsigned , default = 6     X8
//Bit  3: 0        reg_matnr_snrlpf_sadmin2th     // unsigned , default = 4     X8
#define   NR2_MATNR_SNR_USF_GAIN                   (0x1756)
#define P_NR2_MATNR_SNR_USF_GAIN                   (volatile uint32_t *)((0x1756  << 2) + 0xff900000)
//Bit 31:16        reserved
//Bit 15: 8        reg_matnr_snr_usf_cgain        // unsigned , default = 0     norm 64
//Bit  7: 0        reg_matnr_snr_usf_ygain        // unsigned , default = 0     norm 64
#define   NR2_MATNR_SNR_EDGE2B                     (0x1757)
#define P_NR2_MATNR_SNR_EDGE2B                     (volatile uint32_t *)((0x1757  << 2) + 0xff900000)
//Bit 31:16        reserved
//Bit 15: 8        reg_matnr_snr_edge2beta_ofst   // unsigned , default = 128
//Bit  7: 0        reg_matnr_snr_edge2beta_gain   // unsigned , default = 16
#define   NR2_MATNR_BETA_EGAIN                     (0x1758)
#define P_NR2_MATNR_BETA_EGAIN                     (volatile uint32_t *)((0x1758  << 2) + 0xff900000)
//Bit 31:16        reserved
//Bit 15: 8        reg_matnr_cbeta_egain          // unsigned , default = 32    normalized to 32
//Bit  7: 0        reg_matnr_ybeta_egain          // unsigned , default = 32    normalized to 32
#define   NR2_MATNR_BETA_BRT                       (0x1759)
#define P_NR2_MATNR_BETA_BRT                       (volatile uint32_t *)((0x1759  << 2) + 0xff900000)
//Bit 31:28        reg_matnr_beta_brt_limt_hi     // unsigned , default = 0
//Bit 27:24        reg_matnr_beta_brt_slop_hi     // unsigned , default = 0
//Bit 23:16        reg_matnr_beta_brt_thrd_hi     // unsigned , default = 160
//Bit 15:12        reg_matnr_beta_brt_limt_lo     // unsigned , default = 6
//Bit 11: 8        reg_matnr_beta_brt_slop_lo     // unsigned , default = 6
//Bit  7: 0        reg_matnr_beta_brt_thrd_lo     // unsigned , default = 100
#define   NR2_MATNR_XBETA_CFG                      (0x175a)
#define P_NR2_MATNR_XBETA_CFG                      (volatile uint32_t *)((0x175a  << 2) + 0xff900000)
//Bit 31:20        reserved
//Bit 19:18        reg_matnr_cbeta_use_mode       // unsigned , default = 0     0: beta_motion; 1: beta_edge; 2: min(beta_mot,beta_edge); 3: (beta_mot + beta_edge)/2
//Bit 17:16        reg_matnr_ybeta_use_mode       // unsigned , default = 0     0: beta_motion; 1: beta_edge; 2: min(beta_mot,beta_edge); 3: (beta_mot + beta_edge)/2;
//Bit 15: 8        reg_matnr_cbeta_ofst           // unsigned , default = 0
//Bit  7: 0        reg_matnr_ybeta_ofst           // unsigned , default = 0
#define   NR2_MATNR_YBETA_SCL                      (0x175b)
#define P_NR2_MATNR_YBETA_SCL                      (volatile uint32_t *)((0x175b  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_ybeta_scale_min      // unsigned , default = 60
//Bit 23:16        reg_matnr_ybeta_scale_max      // unsigned , default = 255
//Bit 15: 8        reg_matnr_ybeta_scale_gain     // unsigned , default = 32    normalized 32 to 1.0
//Bit  7: 0        reg_matnr_ybeta_scale_ofst     // signed , default = 0
#define   NR2_MATNR_CBETA_SCL                      (0x175c)
#define P_NR2_MATNR_CBETA_SCL                      (volatile uint32_t *)((0x175c  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_cbeta_scale_min      // unsigned , default = 0
//Bit 23:16        reg_matnr_cbeta_scale_max      // unsigned , default = 255
//Bit 15: 8        reg_matnr_cbeta_scale_gain     // unsigned , default = 32    normalized 32 to 1.0
//Bit  7: 0        reg_matnr_cbeta_scale_ofst     // signed , default = 0
#define   NR2_SNR_MASK                             (0x175d)
#define P_NR2_SNR_MASK                             (volatile uint32_t *)((0x175d  << 2) + 0xff900000)
//Bit 31:21        reserved
//Bit 20: 0        sad_msk                        // unsigned , default = 0x0f9f3e
#define   NR2_SAD2NORM_LUT0                        (0x175e)
#define P_NR2_SAD2NORM_LUT0                        (volatile uint32_t *)((0x175e  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_sad2norm_lut3      // unsigned , default = 114
//Bit 23:16        reg_matnr_sad2norm_lut2      // unsigned , default = 146
//Bit 15: 8        reg_matnr_sad2norm_lut1      // unsigned , default = 171
//Bit  7: 0        reg_matnr_sad2norm_lut0      // unsigned , default = 205
#define   NR2_SAD2NORM_LUT1                        (0x175f)
#define P_NR2_SAD2NORM_LUT1                        (volatile uint32_t *)((0x175f  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_sad2norm_lut7      // unsigned , default = 28
//Bit 23:16        reg_matnr_sad2norm_lut6      // unsigned , default = 35
//Bit 15: 8        reg_matnr_sad2norm_lut5      // unsigned , default = 49
//Bit  7: 0        reg_matnr_sad2norm_lut4      // unsigned , default = 79
#define   NR2_SAD2NORM_LUT2                        (0x1760)
#define P_NR2_SAD2NORM_LUT2                        (volatile uint32_t *)((0x1760  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_sad2norm_lut11     // unsigned , default = 15
//Bit 23:16        reg_matnr_sad2norm_lut10     // unsigned , default = 17
//Bit 15: 8        reg_matnr_sad2norm_lut9      // unsigned , default = 19
//Bit  7: 0        reg_matnr_sad2norm_lut8      // unsigned , default = 23
#define   NR2_SAD2NORM_LUT3                        (0x1761)
#define P_NR2_SAD2NORM_LUT3                        (volatile uint32_t *)((0x1761  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_sad2norm_lut15     // unsigned , default = 8
//Bit 23:16        reg_matnr_sad2norm_lut14     // unsigned , default = 9
//Bit 15: 8        reg_matnr_sad2norm_lut13     // unsigned , default = 10
//Bit  7: 0        reg_matnr_sad2norm_lut12     // unsigned , default = 12
#define   NR2_EDGE2BETA_LUT0                       (0x1762)
#define P_NR2_EDGE2BETA_LUT0                       (volatile uint32_t *)((0x1762  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_edge2beta_lut3    // unsigned , default = 128
//Bit 23:16        reg_matnr_edge2beta_lut2    // unsigned , default = 160
//Bit 15: 8        reg_matnr_edge2beta_lut1    // unsigned , default = 224
//Bit  7: 0        reg_matnr_edge2beta_lut0    // unsigned , default = 255
#define   NR2_EDGE2BETA_LUT1                       (0x1763)
#define P_NR2_EDGE2BETA_LUT1                       (volatile uint32_t *)((0x1763  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_edge2beta_lut7    // unsigned , default = 4
//Bit 23:16        reg_matnr_edge2beta_lut6    // unsigned , default = 16
//Bit 15: 8        reg_matnr_edge2beta_lut5    // unsigned , default = 32
//Bit  7: 0        reg_matnr_edge2beta_lut4    // unsigned , default = 80
#define   NR2_EDGE2BETA_LUT2                       (0x1764)
#define P_NR2_EDGE2BETA_LUT2                       (volatile uint32_t *)((0x1764  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_edge2beta_lut11    // unsigned , default = 0
//Bit 23:16        reg_matnr_edge2beta_lut10    // unsigned , default = 0
//Bit 15: 8        reg_matnr_edge2beta_lut9    // unsigned , default = 0
//Bit  7: 0        reg_matnr_edge2beta_lut8    // unsigned , default = 2
#define   NR2_EDGE2BETA_LUT3                       (0x1765)
#define P_NR2_EDGE2BETA_LUT3                       (volatile uint32_t *)((0x1765  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_edge2beta_lut15    // unsigned , default = 0
//Bit 23:16        reg_matnr_edge2beta_lut14    // unsigned , default = 0
//Bit 15: 8        reg_matnr_edge2beta_lut13    // unsigned , default = 0
//Bit  7: 0        reg_matnr_edge2beta_lut12    // unsigned , default = 0
#define   NR2_MOTION2BETA_LUT0                     (0x1766)
#define P_NR2_MOTION2BETA_LUT0                     (volatile uint32_t *)((0x1766  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_mot2beta_lut3     // unsigned , default = 32
//Bit 23:16        reg_matnr_mot2beta_lut2     // unsigned , default = 16
//Bit 15: 8        reg_matnr_mot2beta_lut1     // unsigned , default = 4
//Bit  7: 0        reg_matnr_mot2beta_lut0     // unsigned , default = 0
#define   NR2_MOTION2BETA_LUT1                     (0x1767)
#define P_NR2_MOTION2BETA_LUT1                     (volatile uint32_t *)((0x1767  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_mot2beta_lut7     // unsigned , default = 196
//Bit 23:16        reg_matnr_mot2beta_lut6     // unsigned , default = 128
//Bit 15: 8        reg_matnr_mot2beta_lut5     // unsigned , default = 64
//Bit  7: 0        reg_matnr_mot2beta_lut4     // unsigned , default = 48
#define   NR2_MOTION2BETA_LUT2                     (0x1768)
#define P_NR2_MOTION2BETA_LUT2                     (volatile uint32_t *)((0x1768  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_mot2beta_lut11     // unsigned , default = 255
//Bit 23:16        reg_matnr_mot2beta_lut10     // unsigned , default = 255
//Bit 15: 8        reg_matnr_mot2beta_lut9     // unsigned , default = 240
//Bit  7: 0        reg_matnr_mot2beta_lut8     // unsigned , default = 224
#define   NR2_MOTION2BETA_LUT3                     (0x1769)
#define P_NR2_MOTION2BETA_LUT3                     (volatile uint32_t *)((0x1769  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_mot2beta_lut15     // unsigned , default = 255
//Bit 23:16        reg_matnr_mot2beta_lut14     // unsigned , default = 255
//Bit 15: 8        reg_matnr_mot2beta_lut13     // unsigned , default = 255
//Bit  7: 0        reg_matnr_mot2beta_lut12     // unsigned , default = 255
//========== nr2_snr_regs register end ==========//
//========== nr2_tnr_regs register begin ==========//
#define   NR2_IIR_CTRL                             (0x174e)
#define P_NR2_IIR_CTRL                             (volatile uint32_t *)((0x174e  << 2) + 0xff900000)
//Bit 31:16        reserved
//Bit 15:14        reg_lp_iir_8bit_mode      // unsigned , default = 0  10bits; 1: 9bits; 2: 8bits 3: 7bits
//Bit 13:12        reg_hp_iir_mute_mode      // unsigned , default = 0
//Bit 11: 8        reg_hp_iir_mute_thrd      // unsigned , default = 0
//Bit  7: 6        reg_hp_iir_8bit_mode      // unsigned , default = 0
//Bit  5: 4        reg_lp_iir_mute_mode      // unsigned , default = 0
//Bit  3: 0        reg_lp_iir_mute_thrd      // unsigned , default = 0
#define   NR2_MATNR_MTN_CRTL                       (0x176a)
#define P_NR2_MATNR_MTN_CRTL                       (volatile uint32_t *)((0x176a  << 2) + 0xff900000)
//Bit 31:20        reserved
//Bit 19:18        reg_matnr_vmtn_use_mode   // unsigned , default = 0  0- Vmot, 1- Ymot/2 + (Umot+Vmot)/4; 2- Ymot/2 + max(Umot,Vmot)/2; 3- max(Ymot,Umot, Vmot)
//Bit 17:16        reg_matnr_umtn_use_mode   // unsigned , default = 0  0- Umot, 1- Ymot/2 + (Umot+Vmot)/4; 2- Ymot/2 + max(Umot,Vmot)/2; 3- max(Ymot,Umot, Vmot)
//Bit 15:14        reg_matnr_ymtn_use_mode   // unsigned , default = 0  0- Ymot, 1- Ymot/2 + (Umot+Vmot)/4; 2- Ymot/2 + max(Umot,Vmot)/2; 3- max(Ymot,Umot, Vmot)
//Bit 13:12        reg_matnr_mtn_txt_mode    // unsigned , default = 1
//Bit 11            reserved
//Bit 10: 8        reg_matnr_mtn_cor_mode    // unsigned , default = 1  changes)
//Bit  7: 4        reg_matnr_mtn_hpf_mode    // unsigned , default = 8  extend to u4 for nr4, 0- 1x1; 1: 1x3; 2: 1x5; 3: 3x3; 4: 3o3; 5: 3x5, 6:3x3 SAD, 7: 5x3 SAD, 8-15: drt adaptive
//Bit  3            reserved
//Bit  2: 0        reg_matnr_mtn_lpf_mode    // unsigned , default = 6  0- 1x1; 1: 1x3; 2: 1x5; 3: 3x3; 4: 3o3; 5: 3x5, 6,7: drt adaptive
#define   NR2_MATNR_MTN_CRTL2                      (0x176b)
#define P_NR2_MATNR_MTN_CRTL2                      (volatile uint32_t *)((0x176b  << 2) + 0xff900000)
//Bit 31:19        reserved
//Bit 18:16        reg_matnr_iir_bs_ymode      // unsigned , default = 6  LPF~~ 0- 1x1; 1: 1x3; 2: 1x5; 3: 3x3; 4: 3o3; 5: 3x5; 6/7: 0
//Bit 15: 8        reg_matnr_mtnb_alplp_cgain  // unsigned , default = 64  to 32
//Bit  7: 0        reg_matnr_mtnb_alplp_ygain  // unsigned , default = 64  to 32
#define   NR2_MATNR_MTN_COR                        (0x176c)
#define P_NR2_MATNR_MTN_COR                        (volatile uint32_t *)((0x176c  << 2) + 0xff900000)
//Bit 31:16        reserved
//Bit 15:12        reg_matnr_mtn_cor_cofst   // unsigned , default = 3  Offset for Chroma Motion.
//Bit 11: 8        reg_matnr_mtn_cor_cgain   // unsigned , default = 3  to texture based coring for Chroma Motion. Normalized to 16 as 1
//Bit  7: 4        reg_matnr_mtn_cor_yofst   // unsigned , default = 3  Offset for Luma Motion.
//Bit  3: 0        reg_matnr_mtn_cor_ygain   // unsigned , default = 3  to texture based coring for Luma Motion. Normalized to 16 as 1
#define   NR2_MATNR_MTN_GAIN                       (0x176d)
#define P_NR2_MATNR_MTN_GAIN                       (volatile uint32_t *)((0x176d  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_mtn_hp_cgain    // unsigned , default = 64  to MotHPF_yuv[k] Chrm channel for motion calculation, normalized to 64 as 1
//Bit 23:16        reg_matnr_mtn_hp_ygain    // unsigned , default = 64  to MotHPF_yuv[k] Luma channel for motion calculation, normalized to 64 as 1
//Bit 15: 8        reg_matnr_mtn_lp_cgain    // unsigned , default = 64  to MotLPF_yuv[k] Chrm channel for motion calculation, normalized to 32 as 1
//Bit  7: 0        reg_matnr_mtn_lp_ygain    // unsigned , default = 64  to MotLPF_yuv[k] Luma channel for motion calculation, normalized to 32 as 1
#define   NR2_MATNR_DEGHOST                        (0x176e)
#define P_NR2_MATNR_DEGHOST                        (volatile uint32_t *)((0x176e  << 2) + 0xff900000)
//Bit 31            reserved
//Bit 30:28        reg_matnr_deghost_mode    // unsigned , default = 0  0:old_deghost; 1:soft_denoise & strong_deghost; 2:strong_denoise & soft_deghost; 3:strong_denoise & strong_deghost
//Bit 27:25        reserved
//Bit 24:20        reg_matnr_deghost_ygain   // unsigned , default = 4
//Bit 19:17        reserved
//Bit 16:12        reg_matnr_deghost_cgain   // unsigned , default = 4
//Bit 11: 9        reserved
//Bit  8           reg_matnr_deghost_en      // unsigned , default = 1  0: disable; 1: enable Enable signal for DeGhost function:0: disable; 1: enable
//Bit  7: 4        reg_matnr_deghost_cos     // unsigned , default = 3  DeGhost Overshoot margin for UV channel, (X2 to u10 scale)
//Bit  3: 0        reg_matnr_deghost_yos     // unsigned , default = 3  DeGhost Overshoot margin for Luma channel, (X2 to u10 scale)
#define   NR2_MATNR_ALPHALP_LUT0                   (0x176f)
#define P_NR2_MATNR_ALPHALP_LUT0                   (volatile uint32_t *)((0x176f  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_alphalp_lut3    // unsigned , default = 64  low-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphalp_lut2    // unsigned , default = 128  low-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphalp_lut1    // unsigned , default = 128  low-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphalp_lut0    // unsigned , default = 128  low-pass filter alpha LUT
#define   NR2_MATNR_ALPHALP_LUT1                   (0x1770)
#define P_NR2_MATNR_ALPHALP_LUT1                   (volatile uint32_t *)((0x1770  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_alphalp_lut7    // unsigned , default = 255  low-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphalp_lut6    // unsigned , default = 128  low-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphalp_lut5    // unsigned , default = 80  low-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphalp_lut4    // unsigned , default = 64  low-pass filter alpha LUT
#define   NR2_MATNR_ALPHALP_LUT2                   (0x1771)
#define P_NR2_MATNR_ALPHALP_LUT2                   (volatile uint32_t *)((0x1771  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_alphalp_lut11   // unsigned , default = 255  low-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphalp_lut10   // unsigned , default = 255  low-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphalp_lut9    // unsigned , default = 255  low-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphalp_lut8    // unsigned , default = 255  low-pass filter alpha LUT
#define   NR2_MATNR_ALPHALP_LUT3                   (0x1772)
#define P_NR2_MATNR_ALPHALP_LUT3                   (volatile uint32_t *)((0x1772  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_alphalp_lut15   // unsigned , default = 255  low-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphalp_lut14   // unsigned , default = 255  low-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphalp_lut13   // unsigned , default = 255  low-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphalp_lut12   // unsigned , default = 255  low-pass filter alpha LUT
#define   NR2_MATNR_ALPHAHP_LUT0                   (0x1773)
#define P_NR2_MATNR_ALPHAHP_LUT0                   (volatile uint32_t *)((0x1773  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_alphahp_lut3    // unsigned , default = 64  high-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphahp_lut2    // unsigned , default = 128  high-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphahp_lut1    // unsigned , default = 128  high-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphahp_lut0    // unsigned , default = 128  high-pass filter alpha LUT
#define   NR2_MATNR_ALPHAHP_LUT1                   (0x1774)
#define P_NR2_MATNR_ALPHAHP_LUT1                   (volatile uint32_t *)((0x1774  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_alphahp_lut7    // unsigned , default = 255  high-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphahp_lut6    // unsigned , default = 128  high-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphahp_lut5    // unsigned , default = 80  high-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphahp_lut4    // unsigned , default = 64  high-pass filter alpha LUT
#define   NR2_MATNR_ALPHAHP_LUT2                   (0x1775)
#define P_NR2_MATNR_ALPHAHP_LUT2                   (volatile uint32_t *)((0x1775  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_alphahp_lut11   // unsigned , default = 255  high-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphahp_lut10   // unsigned , default = 255  high-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphahp_lut9    // unsigned , default = 255  high-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphahp_lut8    // unsigned , default = 255  high-pass filter alpha LUT
#define   NR2_MATNR_ALPHAHP_LUT3                   (0x1776)
#define P_NR2_MATNR_ALPHAHP_LUT3                   (volatile uint32_t *)((0x1776  << 2) + 0xff900000)
//Bit 31:24        reg_matnr_alphahp_lut15   // unsigned , default = 255  high-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphahp_lut14   // unsigned , default = 255  high-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphahp_lut13   // unsigned , default = 255  high-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphahp_lut12   // unsigned , default = 255  high-pass filter alpha LUT
#define   NR2_MATNR_MTNB_BRT                       (0x1777)
#define P_NR2_MATNR_MTNB_BRT                       (volatile uint32_t *)((0x1777  << 2) + 0xff900000)
//Bit 31:28        reg_matnr_mtnb_brt_limt_hi  // unsigned , default = 0
//Bit 27:24        reg_matnr_mtnb_brt_slop_hi  // unsigned , default = 0
//Bit 23:16        reg_matnr_mtnb_brt_thrd_hi  // unsigned , default = 160
//Bit 15:12        reg_matnr_mtnb_brt_limt_lo  // unsigned , default = 6
//Bit 11: 8        reg_matnr_mtnb_brt_slop_lo  // unsigned , default = 6
//Bit  7: 0        reg_matnr_mtnb_brt_thrd_lo  // unsigned , default = 100
//========== nr2_tnr_regs register end ==========//
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  nr2_regs.h
//
#define   DI_EI_DRT_CTRL                           (0x1778)
#define P_DI_EI_DRT_CTRL                           (volatile uint32_t *)((0x1778  << 2) + 0xff900000)
//Bit 31,     reg_rectg_en      ;u1
//Bit 30,     reg_recbld_en     ;u1
//Bit 29:28,  reg_rectg_ws      ;u2
//Bit 27,     reserved
//Bit 26:24,  reg_abq_margin    ;u3
//Bit 23,     reserved
//Bit 22:20,  reg_trend_mg      ;u3
//Bit 19:16,  reg_int_d16xc1    ;u4
//Bit 15:14,  reserved
//Bit 13: 8,  reg_int_chlmt1    ;u6
//Bit  7,     reserved
//Bit  6: 4,  reg_nscheck_thrd  ;u3
//Bit  3,     reserved
//Bit  2: 0,  reg_horsl_ws      ;u3
#define   DI_EI_DRT_PIXTH                          (0x1779)
#define P_DI_EI_DRT_PIXTH                          (volatile uint32_t *)((0x1779  << 2) + 0xff900000)
//Bit 31:24,  reg_min_pix        ;u8
//Bit 23:16,  reg_max_pix        ;u8
//Bit 15: 8,  reg_dmaxmin_thrdma ;u8
//Bit  7: 0,  reg_dmaxmin_thrdmi ;u8
#define   DI_EI_DRT_CORRPIXTH                      (0x177a)
#define P_DI_EI_DRT_CORRPIXTH                      (volatile uint32_t *)((0x177a  << 2) + 0xff900000)
//Bit 31:24,  reg_newcorrpix_maxthrd ;u8
//Bit 23:16,  reg_corrpix_diffthrd   ;u8
//Bit 15: 8,  reg_corrpix_minthrd    ;u8
//Bit  7: 0,  reg_corrpix_maxthrd    ;u8
#define   DI_EI_DRT_RECTG_WAVE                     (0x177b)
#define P_DI_EI_DRT_RECTG_WAVE                     (volatile uint32_t *)((0x177b  << 2) + 0xff900000)
//Bit 31:29,  reserved
//Bit 28:24,  reg_max_pixwave  ;u5
//Bit 23:21,  reserved
//Bit 20:16,  reg_pix_wave     ;u5
//Bit 15:14,  reserved
//Bit 13: 8,  reg_maxdrt_thrd  ;u6
//Bit  7: 0,  reg_wave_thrd    ;u8
#define   DI_EI_DRT_PIX_DIFFTH                     (0x177c)
#define P_DI_EI_DRT_PIX_DIFFTH                     (volatile uint32_t *)((0x177c  << 2) + 0xff900000)
//Bit 31:24,  reg_newraw_thrd    ;u8
//Bit 23:16,  reg_tb_max_thrd    ;u8
//Bit 15: 8,  reg_diffpix_thrd   ;u8
//Bit  7: 6,  reserved
//Bit  5: 0,  reg_bilt_trendnumt ;u8
#define   DI_EI_DRT_UNBITREND_TH                   (0x177d)
#define P_DI_EI_DRT_UNBITREND_TH                   (volatile uint32_t *)((0x177d  << 2) + 0xff900000)
//Bit 31:29,  reserved
//Bit 28:24,  reg_trend_numb     ;u5
//Bit 23:21,  reserved
//Bit 20:16,  reg_bilt_trendnum  ;u5
//Bit 15:13,  reserved
//Bit 12: 8,  reg_unil_trendnumt ;u5
//Bit  7: 5,  reserved
//Bit  4: 0,  reg_trend_num      ;u5
#define   NR2_CONV_MODE                            (0x177f)
#define P_NR2_CONV_MODE                            (volatile uint32_t *)((0x177f  << 2) + 0xff900000)
//Bit 3:2,  Conv_c444_mode  The format convert mode about 422 to 444 when data read out line buffer
//Bit 1:0,  Conv_c422_mode  the format convert mode about 444 to 422 when data write to line buffer
//// NR2 REG DEFINE END ////
//// DET 3D REG DEFINE BEGIN ////
//// 8'h34~8'h3f | 8'h80~8'h8f | 0x9a-0x9b
//
// Reading file:  det3d_regs.h
//
//// DET 3D REG DEFINE BEGIN ////
//// 8'h34~8'h3f
//// DET 3D REG DEFINE END ////
#define   DET3D_MOTN_CFG                           (0x1734)
#define P_DET3D_MOTN_CFG                           (volatile uint32_t *)((0x1734  << 2) + 0xff900000)
//Bit 16,   reg_det3d_intr_en           Det3d interrupt enable
//Bit 9:8,  reg_Det3D_Motion_Mode       U2  Different mode for Motion Calculation of Luma and Chroma:
//                                      0: MotY, 1: (2*MotY + (MotU + MotV))/4; 2: Max(MotY, MotU,MotV); 3:Max(MotY, (MotU+MotV)/2)
//Bit 7:4,  reg_Det3D_Motion_Core_Rate  U4  K Rate to Edge (HV) details for coring of Motion Calculations, normalized to 32
//Bit 3:0,  reg_Det3D_Motion_Core_Thrd  U4  2X: static coring value for Motion Detection.
#define   DET3D_CB_CFG                             (0x1735)
#define P_DET3D_CB_CFG                             (volatile uint32_t *)((0x1735  << 2) + 0xff900000)
//Bit 7:4,  reg_Det3D_ChessBd_HV_ofst   U4,  Noise immune offset for Horizontal or vertical combing detection.
//Bit 3:0,  reg_Det3D_ChessBd_NHV_ofst  U4,  Noise immune offset for NON-Horizontal or vertical combing detection.
#define   DET3D_SPLT_CFG                           (0x1736)
#define P_DET3D_SPLT_CFG                           (volatile uint32_t *)((0x1736  << 2) + 0xff900000)
//Bit 7:4,  reg_Det3D_SplitValid_ratio  U4,  Ratio between max_value and the avg_value of the edge mapping for split line valid detection.
//                                      The smaller of this value, the easier of the split line detected.
//Bit 3:0,  reg_Det3D_AvgIdx_ratio      U4,  Ratio to the avg_value of the edge mapping for split line position estimation.
//                                      The smaller of this value, the more samples will be added to the estimation.
#define   DET3D_HV_MUTE                            (0x1737)
#define P_DET3D_HV_MUTE                            (volatile uint32_t *)((0x1737  << 2) + 0xff900000)
//Bit 23:20, reg_Det3D_Edge_Ver_Mute    U4  X2: Horizontal pixels to be mute from H/V Edge calculation Top and Bottom border part.
//Bit 19:16, reg_Det3D_Edge_Hor_Mute    U4  X2: Horizontal pixels to be mute from H/V Edge calculation Left and right border part.
//Bit 15:12, reg_Det3D_ChessBd_Ver_Mute U4  X2: Horizontal pixels to be mute from ChessBoard statistics calculation in middle part
//Bit 11:8,  reg_Det3D_ChessBd_Hor_Mute U4  X2: Horizontal pixels to be mute from ChessBoard statistics calculation in middle part
//Bit 7:4,   reg_Det3D_STA8X8_Ver_Mute  U4  1X: Vertical pixels to be mute from 8x8 statistics calculation in each block.
//Bit 3:0,   reg_Det3D_STA8X8_Hor_Mute  U4  1X: Horizontal pixels to be mute from 8x8 statistics calculation in each block.
#define   DET3D_MAT_STA_P1M1                       (0x1738)
#define P_DET3D_MAT_STA_P1M1                       (volatile uint32_t *)((0x1738  << 2) + 0xff900000)
//Bit 31:24, reg_Det3D_STA8X8_P1_K0_R8  U8  SAD to SAI ratio to decide P1, normalized to 256 (0.8)
//Bit 23:16, reg_Det3D_STA8X8_P1_K1_R7  U8  SAD to ENG ratio to decide P1, normalized to 128 (0.5)
//Bit 15:8,  reg_Det3D_STA8X8_M1_K0_R6  U8  SAD to SAI ratio to decide M1, normalized to 64  (1.1)
//Bit 7:0,   reg_Det3D_STA8X8_M1_K1_R6  U8  SAD to ENG ratio to decide M1, normalized to 64  (0.8)
#define   DET3D_MAT_STA_P1TH                       (0x1739)
#define P_DET3D_MAT_STA_P1TH                       (volatile uint32_t *)((0x1739  << 2) + 0xff900000)
//Bit 23:16, reg_Det3D_STAYUV_P1_TH_L4  U8  SAD to ENG Thrd offset to decide P1, X16         (100)
//Bit 15:8,  reg_Det3D_STAEDG_P1_TH_L4  U8  SAD to ENG Thrd offset to decide P1, X16         (80)
//Bit 7:0,   reg_Det3D_STAMOT_P1_TH_L4  U8  SAD to ENG Thrd offset to decide P1, X16         (48)
#define   DET3D_MAT_STA_M1TH                       (0x173a)
#define P_DET3D_MAT_STA_M1TH                       (volatile uint32_t *)((0x173a  << 2) + 0xff900000)
//Bit 23:16, reg_Det3D_STAYUV_M1_TH_L4  U8  SAD to ENG Thrd offset to decide M1, X16         (100)
//Bit 15:8,  reg_Det3D_STAEDG_M1_TH_L4  U8  SAD to ENG Thrd offset to decide M1, X16         (80)
//Bit 7:0,   reg_Det3D_STAMOT_M1_TH_L4  U8  SAD to ENG Thrd offset to decide M1, X16         (64)
#define   DET3D_MAT_STA_RSFT                       (0x173b)
#define P_DET3D_MAT_STA_RSFT                       (volatile uint32_t *)((0x173b  << 2) + 0xff900000)
//Bit 5:4,   reg_Det3D_STAYUV_RSHFT     U2  YUV statistics SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//Bit 3:2,   reg_Det3D_STAEDG_RSHFT     U2  Horizontal and Vertical Edge Statistics SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//Bit 1:0,   reg_Det3D_STAMOT_RSHFT     U2  Motion SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
#define   DET3D_MAT_SYMTC_TH                       (0x173c)
#define P_DET3D_MAT_SYMTC_TH                       (volatile uint32_t *)((0x173c  << 2) + 0xff900000)
//Bit 31:24, reg_Det3D_STALUM_symtc_Th    U8  threshold to decide if the Luma statistics is TB or LR symmetric.
//Bit 23:16, reg_Det3D_STACHR_symtc_Th    U8  threshold to decide if the Chroma (UV) statistics is TB or LR symmetric.
//Bit 15:8,  reg_Det3D_STAEDG_symtc_Th    U8  threshold to decide if the Horizontal and Vertical Edge statistics is TB or LR symmetric.
//Bit 7:0,   reg_Det3D_STAMOT_symtc_Th    U8  threshold to decide if the Motion statistics is TB or LR symmetric.
#define   DET3D_RO_DET_CB_HOR                      (0x173d)
#define P_DET3D_RO_DET_CB_HOR                      (volatile uint32_t *)((0x173d  << 2) + 0xff900000)
//Bit 31:16, RO_Det3D_ChessBd_NHor_value    U16  X64: number of Pixels of Horizontally Surely NOT matching Chessboard pattern.
//Bit 15:0,  RO_Det3D_ChessBd_Hor_value     U16  X64: number of Pixels of Horizontally Surely matching Chessboard pattern.
#define   DET3D_RO_DET_CB_VER                      (0x173e)
#define P_DET3D_RO_DET_CB_VER                      (volatile uint32_t *)((0x173e  << 2) + 0xff900000)
//Bit 31:16, RO_Det3D_ChessBd_NVer_value    U16  X64: number of Pixels of Vertically Surely NOT matching Chessboard pattern.
//Bit 15:0,  RO_Det3D_ChessBd_Ver_value     U16  X64: number of Pixels of Vertically Surely matching Chessboard pattern.
#define   DET3D_RO_SPLT_HT                         (0x173f)
#define P_DET3D_RO_SPLT_HT                         (volatile uint32_t *)((0x173f  << 2) + 0xff900000)
//Bit 24,    RO_Det3D_Split_HT_valid    U1  horizontal LR split border detected valid signal for top half picture
//Bit 20:16, RO_Det3D_Split_HT_pxnum    U5  number of pixels included for the LR split position estimation for top half picture
//Bit 9:0,   RO_Det3D_Split_HT_idxX4    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
//// DET 3D REG DEFINE BEGIN ////
////  8'h80~8'h8f
#define   DET3D_RO_SPLT_HB                         (0x1780)
#define P_DET3D_RO_SPLT_HB                         (volatile uint32_t *)((0x1780  << 2) + 0xff900000)
//Bit 24,       RO_Det3D_Split_HB_valid     U1   horizontal LR split border detected valid signal for top half picture
//Bit 20:16,    RO_Det3D_Split_HB_pxnum     U5   number of pixels included for the LR split position estimation for top half picture
//Bit  9: 0,    RO_Det3D_Split_HB_idxX4     S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
#define   DET3D_RO_SPLT_VL                         (0x1781)
#define P_DET3D_RO_SPLT_VL                         (volatile uint32_t *)((0x1781  << 2) + 0xff900000)
//Bit 24,       RO_Det3D_Split_VL_valid     U1   horizontal LR split border detected valid signal for top half picture
//Bit 20:16,    RO_Det3D_Split_VL_pxnum     U5   number of pixels included for the LR split position estimation for top half picture
//Bit  9: 0,    RO_Det3D_Split_VL_idxX4     S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
#define   DET3D_RO_SPLT_VR                         (0x1782)
#define P_DET3D_RO_SPLT_VR                         (volatile uint32_t *)((0x1782  << 2) + 0xff900000)
//Bit 24   ,    RO_Det3D_Split_VR_valid     U1   horizontal LR split border detected valid signal for top half picture
//Bit 20:16,    RO_Det3D_Split_VR_pxnum     U5   number of pixels included for the LR split position estimation for top half picture
//Bit  9: 0,    RO_Det3D_Split_VR_idxX4     S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
#define   DET3D_RO_MAT_LUMA_LR                     (0x1783)
#define P_DET3D_RO_MAT_LUMA_LR                     (volatile uint32_t *)((0x1783  << 2) + 0xff900000)
//Bit 15:0, RO_Luma_LR_score     S2*8  LUMA statistics left right decision score for each band (8bands vertically),
//                               it can be -1/0/1:-1: most likely not LR symmetric 0: not sure 1: most likely LR symmetric
//Bit 7:0,  RO_Luma_LR_symtc     U1*8  Luma statistics left right pure symmetric for each band (8bands vertically),
//                               it can be 0/1: 0: not sure 1: most likely LR is pure symmetric
//Bit 4:0,  RO_Luma_LR_sum       S5  Total score of 8x8 Luma statistics for LR like decision,
//                               the larger this score, the more confidence that this is a LR 3D video. It is sum of  RO_Luma_LR_score[0~7]
#define   DET3D_RO_MAT_LUMA_TB                     (0x1784)
#define P_DET3D_RO_MAT_LUMA_TB                     (volatile uint32_t *)((0x1784  << 2) + 0xff900000)
//Bit 15:0, RO_Luma_TB_score     S2*8  LUMA statistics Top/Bottom decision score for each band (8bands Horizontally),
//Bit 7:0,  RO_Luma_TB_symtc     Luma statistics Top/Bottompure symmetric for each band (8bands Horizontally),
//Bit 4:0,  RO_Luma_TB_sum       Total score of 8x8 Luma statistics for TB like decision,
#define   DET3D_RO_MAT_CHRU_LR                     (0x1785)
#define P_DET3D_RO_MAT_CHRU_LR                     (volatile uint32_t *)((0x1785  << 2) + 0xff900000)
//Bit 15:0, RO_ChrU_LR_score    S2*8  LUMA statistics left right decision score for each band (8bands vertically),
//Bit 7:0,  RO_ChrU_LR_symtc    CHRU statistics left right pure symmetric for each band (8bands vertically),
//Bit 4:0,  RO_ChrU_LR_sum      Total score of 8x8 ChrU statistics for LR like decision,
#define   DET3D_RO_MAT_CHRU_TB                     (0x1786)
#define P_DET3D_RO_MAT_CHRU_TB                     (volatile uint32_t *)((0x1786  << 2) + 0xff900000)
//Bit 15:0, RO_ChrU_TB_score    S2*8  CHRU statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,  RO_ChrU_TB_symtc    CHRU statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,  RO_ChrU_TB_sum      Total score of 8x8 ChrU statistics for TB like decision
#define   DET3D_RO_MAT_CHRV_LR                     (0x1787)
#define P_DET3D_RO_MAT_CHRV_LR                     (volatile uint32_t *)((0x1787  << 2) + 0xff900000)
//Bit 15:0, RO_ChrV_LR_score    S2*8  CHRUstatistics left right decision score for each band (8bands vertically)
//Bit 7:0,  RO_ChrV_LR_symtc    CHRV statistics left right pure symmetric for each band (8bands vertically)
//Bit 4:0,  RO_ChrV_LR_sum      Total score of 8x8 ChrV statistics for LR like decision
#define   DET3D_RO_MAT_CHRV_TB                     (0x1788)
#define P_DET3D_RO_MAT_CHRV_TB                     (volatile uint32_t *)((0x1788  << 2) + 0xff900000)
//Bit 15:0, RO_ChrV_TB_score    CHRV statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,  RO_ChrV_TB_symtc    CHRV statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,  RO_ChrV_TB_sum      Total score of 8x8 ChrV statistics for TB like decision
#define   DET3D_RO_MAT_HEDG_LR                     (0x1789)
#define P_DET3D_RO_MAT_HEDG_LR                     (volatile uint32_t *)((0x1789  << 2) + 0xff900000)
//Bit 15:0, RO_Hedg_LR_score    Horizontal Edge statistics left right decision score for each band (8bands vertically)
//Bit 7:0,  RO_Hedg_LR_symtc    Horizontal Edge statistics left right pure symmetric for each band (8bands vertically)
//Bit 4:0,  RO_Hedg_LR_sum      Total score of 8x8 Hedg statistics for LR like decision
#define   DET3D_RO_MAT_HEDG_TB                     (0x178a)
#define P_DET3D_RO_MAT_HEDG_TB                     (volatile uint32_t *)((0x178a  << 2) + 0xff900000)
//Bit 15:0, RO_Hedg_TB_score    Horizontal Edge statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,  RO_Hedg_TB_symtc    Horizontal Edge statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,  RO_Hedg_TB_sum      Total score of 8x8 Hedg statistics for TB like decision
#define   DET3D_RO_MAT_VEDG_LR                     (0x178b)
#define P_DET3D_RO_MAT_VEDG_LR                     (volatile uint32_t *)((0x178b  << 2) + 0xff900000)
//Bit 15:0, RO_Vedg_LR_score    Vertical Edge statistics left right decision score for each band (8bands vertically)
//Bit 7:0,  RO_Vedg_LR_symtc    Vertical Edge statistics left right pure symmetric for each band (8bands vertically)
//Bit 4:0,  RO_Vedg_LR_sum      Total score of 8x8 Vedg statistics for LR like decision
#define   DET3D_RO_MAT_VEDG_TB                     (0x178c)
#define P_DET3D_RO_MAT_VEDG_TB                     (volatile uint32_t *)((0x178c  << 2) + 0xff900000)
//Bit 15:0, RO_Vedg_TB_score    Vertical Edge statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,  RO_Vedg_TB_symtc    Vertical Edge statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,  RO_Vedg_TB_sum      Total score of 8x8 Vedg statistics for TB like decision
#define   DET3D_RO_MAT_MOTN_LR                     (0x178d)
#define P_DET3D_RO_MAT_MOTN_LR                     (volatile uint32_t *)((0x178d  << 2) + 0xff900000)
//Bit 15:0, RO_Motn_LR_score    Motion statistics left right decision score for each band (8bands vertically)
//Bit 7:0,  RO_Motn_LR_symtc    Motion statistics left right pure symmetric for each band (8bands vertically)
//Bit 4:0,  RO_Motn_LR_sum      Total score of 8x8 Motion statistics for LR like decision
#define   DET3D_RO_MAT_MOTN_TB                     (0x178e)
#define P_DET3D_RO_MAT_MOTN_TB                     (volatile uint32_t *)((0x178e  << 2) + 0xff900000)
//Bit 15:0, RO_Motn_TB_score    Motion statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,  RO_Motn_TB_symtc    Motion statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,  RO_Motn_TB_sum      Total score of 8x8 Motion statistics for TB like decision
#define   DET3D_RO_FRM_MOTN                        (0x178f)
#define P_DET3D_RO_FRM_MOTN                        (volatile uint32_t *)((0x178f  << 2) + 0xff900000)
//Bit 15:0, RO_Det3D_Frame_Motion   U16  frame based motion value sum for still image decision in FW.
/// mat ram read enter addr
#define   DET3D_RAMRD_ADDR_PORT                    (0x179a)
#define P_DET3D_RAMRD_ADDR_PORT                    (volatile uint32_t *)((0x179a  << 2) + 0xff900000)
#define   DET3D_RAMRD_DATA_PORT                    (0x179b)
#define P_DET3D_RAMRD_DATA_PORT                    (volatile uint32_t *)((0x179b  << 2) + 0xff900000)
//
// Closing file:  det3d_regs.h
//
//   `define DET3D_RO_SPLT_HB            8'h80
//   //Bit 24,      RO_Det3D_Split_HB_valid     U1   horizontal LR split border detected valid signal for top half picture
//   //Bit 20:16,   RO_Det3D_Split_HB_pxnum     U5   number of pixels included for the LR split position estimation for top half picture
//   //Bit  9: 0,   RO_Det3D_Split_HB_idxX4     S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
//   `define DET3D_RO_SPLT_VL            8'h81
//   //Bit 24,      RO_Det3D_Split_VL_valid     U1   horizontal LR split border detected valid signal for top half picture
//   //Bit 20:16,   RO_Det3D_Split_VL_pxnum     U5   number of pixels included for the LR split position estimation for top half picture
//   //Bit  9: 0,   RO_Det3D_Split_VL_idxX4     S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
//   `define DET3D_RO_SPLT_VR            8'h82
//   //Bit 24   ,   RO_Det3D_Split_VR_valid     U1   horizontal LR split border detected valid signal for top half picture
//   //Bit 20:16,   RO_Det3D_Split_VR_pxnum     U5   number of pixels included for the LR split position estimation for top half picture
//   //Bit  9: 0,   RO_Det3D_Split_VR_idxX4     S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
//   `define DET3D_RO_MAT_LUMA_LR        8'h83
//   //Bit 15:0,    RO_Luma_LR_score     S2*8  LUMA statistics left right decision score for each band (8bands vertically),
//   //                               it can be -1/0/1:-1: most likely not LR symmetric 0: not sure 1: most likely LR symmetric
//   //Bit 7:0, RO_Luma_LR_symtc     U1*8  Luma statistics left right pure symmetric for each band (8bands vertically),
//   //                               it can be 0/1: 0: not sure 1: most likely LR is pure symmetric
//   //Bit 4:0, RO_Luma_LR_sum       S5  Total score of 8x8 Luma statistics for LR like decision,
//   //                               the larger this score, the more confidence that this is a LR 3D video. It is sum of  RO_Luma_LR_score[0~7]
//   `define DET3D_RO_MAT_LUMA_TB        8'h84
//   //Bit 15:0,    RO_Luma_TB_score     S2*8  LUMA statistics Top/Bottom decision score for each band (8bands Horizontally),
//   //Bit 7:0, RO_Luma_TB_symtc     Luma statistics Top/Bottompure symmetric for each band (8bands Horizontally),
//   //Bit 4:0, RO_Luma_TB_sum       Total score of 8x8 Luma statistics for TB like decision,
//   `define DET3D_RO_MAT_CHRU_LR        8'h85
//   //Bit 15:0,    RO_ChrU_LR_score    S2*8  LUMA statistics left right decision score for each band (8bands vertically),
//   //Bit 7:0, RO_ChrU_LR_symtc    CHRU statistics left right pure symmetric for each band (8bands vertically),
//   //Bit 4:0, RO_ChrU_LR_sum      Total score of 8x8 ChrU statistics for LR like decision,
//   `define DET3D_RO_MAT_CHRU_TB        8'h86
//   //Bit 15:0,    RO_ChrU_TB_score    S2*8  CHRU statistics Top/Bottom decision score for each band (8bands Horizontally)
//   //Bit 7:0, RO_ChrU_TB_symtc    CHRU statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//   //Bit 4:0, RO_ChrU_TB_sum      Total score of 8x8 ChrU statistics for TB like decision
//   `define DET3D_RO_MAT_CHRV_LR        8'h87
//   //Bit 15:0,    RO_ChrV_LR_score    S2*8  CHRUstatistics left right decision score for each band (8bands vertically)
//   //Bit 7:0, RO_ChrV_LR_symtc    CHRV statistics left right pure symmetric for each band (8bands vertically)
//   //Bit 4:0, RO_ChrV_LR_sum      Total score of 8x8 ChrV statistics for LR like decision
//   `define DET3D_RO_MAT_CHRV_TB        8'h88
//   //Bit 15:0,    RO_ChrV_TB_score    CHRV statistics Top/Bottom decision score for each band (8bands Horizontally)
//   //Bit 7:0, RO_ChrV_TB_symtc    CHRV statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//   //Bit 4:0, RO_ChrV_TB_sum      Total score of 8x8 ChrV statistics for TB like decision
//   `define DET3D_RO_MAT_HEDG_LR        8'h89
//   //Bit 15:0,    RO_Hedg_LR_score    Horizontal Edge statistics left right decision score for each band (8bands vertically)
//   //Bit 7:0, RO_Hedg_LR_symtc    Horizontal Edge statistics left right pure symmetric for each band (8bands vertically)
//   //Bit 4:0, RO_Hedg_LR_sum      Total score of 8x8 Hedg statistics for LR like decision
//   `define DET3D_RO_MAT_HEDG_TB        8'h8a
//   //Bit 15:0,    RO_Hedg_TB_score    Horizontal Edge statistics Top/Bottom decision score for each band (8bands Horizontally)
//   //Bit 7:0, RO_Hedg_TB_symtc    Horizontal Edge statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//   //Bit 4:0, RO_Hedg_TB_sum      Total score of 8x8 Hedg statistics for TB like decision
//   `define DET3D_RO_MAT_VEDG_LR        8'h8b
//   //Bit 15:0,    RO_Vedg_LR_score    Vertical Edge statistics left right decision score for each band (8bands vertically)
//   //Bit 7:0, RO_Vedg_LR_symtc    Vertical Edge statistics left right pure symmetric for each band (8bands vertically)
//   //Bit 4:0, RO_Vedg_LR_sum      Total score of 8x8 Vedg statistics for LR like decision
//   `define DET3D_RO_MAT_VEDG_TB        8'h8c
//   //Bit 15:0,    RO_Vedg_TB_score    Vertical Edge statistics Top/Bottom decision score for each band (8bands Horizontally)
//   //Bit 7:0, RO_Vedg_TB_symtc    Vertical Edge statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//   //Bit 4:0, RO_Vedg_TB_sum      Total score of 8x8 Vedg statistics for TB like decision
//   `define DET3D_RO_MAT_MOTN_LR        8'h8d
//   //Bit 15:0,    RO_Motn_LR_score    Motion statistics left right decision score for each band (8bands vertically)
//   //Bit 7:0, RO_Motn_LR_symtc    Motion statistics left right pure symmetric for each band (8bands vertically)
//   //Bit 4:0, RO_Motn_LR_sum      Total score of 8x8 Motion statistics for LR like decision
//   `define DET3D_RO_MAT_MOTN_TB        8'h8e
//   //Bit 15:0,    RO_Motn_TB_score    Motion statistics Top/Bottom decision score for each band (8bands Horizontally)
//   //Bit 7:0, RO_Motn_TB_symtc    Motion statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//   //Bit 4:0, RO_Motn_TB_sum      Total score of 8x8 Motion statistics for TB like decision
//   `define DET3D_RO_FRM_MOTN           8'h8f
//   //Bit 15:0,    RO_Det3D_Frame_Motion   U16  frame based motion value sum for still image decision in FW.
#define   DI_EI_CTRL10                             (0x1793)
#define P_DI_EI_CTRL10                             (volatile uint32_t *)((0x1793  << 2) + 0xff900000)
//bit 31:28,   reg_ei_caldrt_hstrrgchk_drtth
//bit 27:24,   reg_ei_caldrt_hstrrgchk_frcverthrd
//bit 23:20,   reg_ei_caldrt_hstrrgchk_mg
//bit 19,      reg_ei_caldrt_hstrrgchk_1sidnul
//bit 18,      reg_ei_caldrt_hstrrgchk_excpcnf
//bit 17:16,   reg_ei_caldrt_hstrrgchk_ws
//bit 15,      reg_ei_caldrt_hstrrgchk_en
//bit 14:13,   reg_ei_caldrt_hpncheck_mode
//bit 12,      reg_ei_caldrt_hpncheck_mute
//bit 11:9,    reg_ei_caldrt_hcnfcheck_mg2
//bit 8:6,     reg_ei_caldrt_hcnfcheck_mg1
//bit 5:4,     reg_ei_caldrt_hcnfcheck_mode
//bit 3:0,     reg_ei_caldrt_hcnfcheck_mg2
#define   DI_NR_1_CTRL0                            (0x1794)
#define P_DI_NR_1_CTRL0                            (volatile uint32_t *)((0x1794  << 2) + 0xff900000)
#define   DI_NR_1_CTRL1                            (0x1795)
#define P_DI_NR_1_CTRL1                            (volatile uint32_t *)((0x1795  << 2) + 0xff900000)
#define   DI_NR_1_CTRL2                            (0x1796)
#define P_DI_NR_1_CTRL2                            (volatile uint32_t *)((0x1796  << 2) + 0xff900000)
#define   DI_NR_1_CTRL3                            (0x1797)
#define P_DI_NR_1_CTRL3                            (volatile uint32_t *)((0x1797  << 2) + 0xff900000)
#define   DI_EI_XWIN0                              (0x1798)
#define P_DI_EI_XWIN0                              (volatile uint32_t *)((0x1798  << 2) + 0xff900000)
//bit 27:16,   ei_xend0
//bit 11:0,    ei_xstart0
#define   DI_EI_XWIN1                              (0x1799)
#define P_DI_EI_XWIN1                              (volatile uint32_t *)((0x1799  << 2) + 0xff900000)
/// mat ram read enter addr
//   `define DET3D_RAMRD_ADDR_PORT       8'h9a
//   `define DET3D_RAMRD_DATA_PORT       8'h9b
#define   NR2_CFR_PARA_CFG0                        (0x179c)
#define P_NR2_CFR_PARA_CFG0                        (volatile uint32_t *)((0x179c  << 2) + 0xff900000)
//Bit 8,    reg_CFR_CurDif_luma_mode    Current Field Top/Bot line Luma difference calculation mode
//Bit 7:6,  reg_MACFR_frm_phase         U2  This will be a field based phase register that need to be set by FW phase to phase:
//                                      this will be calculated based on dbdr_phase of the specific line of this frame.
//                                      u1: dbdr_phase=1, center line is DB in current line;  dbdr_phase=2, center line is Dr in current line;
//Bit 5:4,  reg_CFR_CurDif_tran_mode    U2  Current Field Top/Bot line Luma/Chroma transition level calculation mode,
//Bit 3:2,  reg_CFR_alpha_mode          U2  Alpha selection mode for CFR block from curAlp and motAlp i.e. 0: motAlp; 1: (motAlp+curAlp)/2; 2: min(motAlp,curAlp); 3: max(motAlp,curAlp);
//Bit 1:0,  reg_CFR_Motion_Luma_mode    U2  LumaMotion Calculation mode for MA-CFR. 0: top/bot Lumma motion;   1: middle Luma Motion 2: top/bot + middle motion; 3: max(top/tot motion, middle motion)
#define   NR2_CFR_PARA_CFG1                        (0x179d)
#define P_NR2_CFR_PARA_CFG1                        (volatile uint32_t *)((0x179d  << 2) + 0xff900000)
//Bit 23:16,    reg_CFR_alpha_gain      gain to map muxed curAlp and motAlp to alpha that will be used for final blending.
//Bit 15: 8,    reg_CFR_Motion_ofst     Offset to Motion to calculate the motAlp, e,g:motAlp= reg_CFR_Motion_ofst- Motion;This register can be seen as the level of motion that we consider it at moving.
//Bit  7: 0,    reg_CFR_CurDif_gain     gain to CurDif to map to alpha, normalized to 32;
//// DET 3D REG DEFINE END ////
#define   DI_EI_CTRL11                             (0x179e)
#define P_DI_EI_CTRL11                             (volatile uint32_t *)((0x179e  << 2) + 0xff900000)
//bit 30:29,   reg_ei_amb_detect_mode
//bit 28:24,   reg_ei_amb_detect_winth
//bit 23:21,   reg_ei_amb_decide_rppth
//bit 20:19,   reg_ei_retime_lastmappncnfltchk_drtth
//bit 18:16,   reg_ei_retime_lastmappncnfltchk_mode
//bit 15:14,   reg_ei_retime_lastmapvertfrcchk_mode
//bit 13:12,   reg_ei_retime_lastvertfrcchk_mode
//bit 11:8,    reg_ei_retime_lastpnchk_drtth
//bit 6,       reg_ei_retime_lastpnchk_en
//bit 5:4,     reg_ei_retime_mode
//bit 3,       reg_ei_retime_last_en
//bit 2,       reg_ei_retime_ab_en
//bit 1,       reg_ei_caldrt_hstrvertfrcchk_en
//bit 0,       reg_ei_caldrt_hstrrgchk_mode
#define   DI_EI_CTRL12                             (0x179f)
#define P_DI_EI_CTRL12                             (volatile uint32_t *)((0x179f  << 2) + 0xff900000)
//bit 31:28,   reg_ei_drtdelay2_lmt
//bit 27:26,   reg_ei_drtdelay2_notver_lrwin
//bit 25:24,   reg_ei_drtdelay_mode
//bit 23,      reg_ei_drtdelay2_mode
//bit 22:20,   reg_ei_assign_xla_signm0th
//bit 19,      reg_ei_assign_pkbiasvert_en
//bit 18,      reg_ei_assign_xla_en
//bit 17:16,   reg_ei_assign_xla_mode
//bit 15:12,   reg_ei_assign_nlfilter_magin
//bit 11:8,    reg_ei_localsearch_maxrange
//bit 7:4,     reg_ei_xla_drtth
//bit 3:0,     reg_ei_flatmsad_thrd
#define   DI_CONTWR_X                              (0x17a0)
#define P_DI_CONTWR_X                              (volatile uint32_t *)((0x17a0  << 2) + 0xff900000)
#define   DI_CONTWR_Y                              (0x17a1)
#define P_DI_CONTWR_Y                              (volatile uint32_t *)((0x17a1  << 2) + 0xff900000)
#define   DI_CONTWR_CTRL                           (0x17a2)
#define P_DI_CONTWR_CTRL                           (volatile uint32_t *)((0x17a2  << 2) + 0xff900000)
#define   DI_CONTPRD_X                             (0x17a3)
#define P_DI_CONTPRD_X                             (volatile uint32_t *)((0x17a3  << 2) + 0xff900000)
#define   DI_CONTPRD_Y                             (0x17a4)
#define P_DI_CONTPRD_Y                             (volatile uint32_t *)((0x17a4  << 2) + 0xff900000)
#define   DI_CONTP2RD_X                            (0x17a5)
#define P_DI_CONTP2RD_X                            (volatile uint32_t *)((0x17a5  << 2) + 0xff900000)
#define   DI_CONTP2RD_Y                            (0x17a6)
#define P_DI_CONTP2RD_Y                            (volatile uint32_t *)((0x17a6  << 2) + 0xff900000)
#define   DI_CONTRD_CTRL                           (0x17a7)
#define P_DI_CONTRD_CTRL                           (volatile uint32_t *)((0x17a7  << 2) + 0xff900000)
#define   DI_EI_CTRL13                             (0x17a8)
#define P_DI_EI_CTRL13                             (volatile uint32_t *)((0x17a8  << 2) + 0xff900000)
//bit 27:24,   reg_ei_int_drt2x_chrdrt_limit
//bit 23:20,   reg_ei_int_drt16x_core
//bit 19:16,   reg_ei_int_drtdelay2_notver_cancv
//bit 15:8,    reg_ei_int_drtdelay2_notver_sadth
//bit 7:0,     reg_ei_int_drtdelay2_vlddrt_sadth
#define   DI_MTN_1_CTRL6                           (0x17a9)
#define P_DI_MTN_1_CTRL6                           (volatile uint32_t *)((0x17a9  << 2) + 0xff900000)
//bit 31:24,   mtn_m1b_extend
//bit 23:16,   mtn_m1b_errod
//bit 15: 8,   mtn_core_ykinter
//bit  7: 0,   mtn_core_ckinter
#define   DI_MTN_1_CTRL7                           (0x17aa)
#define P_DI_MTN_1_CTRL7                           (volatile uint32_t *)((0x17aa  << 2) + 0xff900000)
//bit 31:24,   mtn_core_mxcmby
//bit 23:16,   mtn_core_mxcmbc
//bit 15: 8,   mtn_core_y
//bit  7: 0,   mtn_core_c
#define   DI_MTN_1_CTRL8                           (0x17ab)
#define P_DI_MTN_1_CTRL8                           (volatile uint32_t *)((0x17ab  << 2) + 0xff900000)
//bit 31:24,   mtn_fcore_ykinter
//bit 23:16,   mtn_fcore_ckinter
//bit 15: 8,   mtn_fcore_ykintra
//bit  7: 0,   mtn_fcore_ckintra
#define   DI_MTN_1_CTRL9                           (0x17ac)
#define P_DI_MTN_1_CTRL9                           (volatile uint32_t *)((0x17ac  << 2) + 0xff900000)
//bit 31:24,   mtn_fcore_2yrate
//bit 23:16,   mtn_fcore_2crate
//bit 15: 8,   mtn_fcore_y
//bit  7: 0,   mtn_fcore_c
#define   DI_MTN_1_CTRL10                          (0x17ad)
#define P_DI_MTN_1_CTRL10                          (volatile uint32_t *)((0x17ad  << 2) + 0xff900000)
//bit 27:24,   mtn_motfld0
//bit 19:16,   mtn_stlfld0
//bit 11: 8,   mtn_motfld1
//bit  3: 0,   mtn_stlfld1
#define   DI_MTN_1_CTRL11                          (0x17ae)
#define P_DI_MTN_1_CTRL11                          (volatile uint32_t *)((0x17ae  << 2) + 0xff900000)
//bit 27:24,   mtn_smotevn
//bit 20:16,   mtn_smotodd
//bit 11: 8,   mtn_sstlevn
//bit  4: 0,   mtn_sstlodd
#define   DI_MTN_1_CTRL12                          (0x17af)
#define P_DI_MTN_1_CTRL12                          (volatile uint32_t *)((0x17af  << 2) + 0xff900000)
//bit 31:24,   mtn_mgain
//bit 17:16,   mtn_mmode
//bit 15: 8,   mtn_sthrd
//bit  4: 0,   mtn_sgain
#define   DI_NRWR_X                                (0x17c0)
#define P_DI_NRWR_X                                (volatile uint32_t *)((0x17c0  << 2) + 0xff900000)
#define   DI_NRWR_Y                                (0x17c1)
#define P_DI_NRWR_Y                                (volatile uint32_t *)((0x17c1  << 2) + 0xff900000)
//bit 31:30             nrwr_words_lim
//bit 29                nrwr_rev_y
//bit 28:16             nrwr_start_y
//bit 15                nrwr_ext_en
//bit 12:0              nrwr_end_y
#define   DI_NRWR_CTRL                             (0x17c2)
#define P_DI_NRWR_CTRL                             (volatile uint32_t *)((0x17c2  << 2) + 0xff900000)
//bit 31                pending_ddr_wrrsp_diwr
//bit 30                nrwr_reg_swap
//bit 29:26             nrwr_burst_lim
//bit 25                nrwr_canvas_syncen
//bit 24                nrwr_no_clk_gate
//bit 23:22             nrwr_rgb_mode  0:422 to one canvas;1:4:4:4 to one canvas;
//bit 21:20             nrwr_hconv_mode
//bit 19:18             nrwr_vconv_mode
//bit 17                nrwr_swap_cbcr
//bit 16                nrwr_urgent
//bit 15:8              nrwr_canvas_index_chroma
//bit 7:0               nrwr_canvas_index_luma
#define   DI_MTNWR_X                               (0x17c3)
#define P_DI_MTNWR_X                               (volatile uint32_t *)((0x17c3  << 2) + 0xff900000)
#define   DI_MTNWR_Y                               (0x17c4)
#define P_DI_MTNWR_Y                               (volatile uint32_t *)((0x17c4  << 2) + 0xff900000)
#define   DI_MTNWR_CTRL                            (0x17c5)
#define P_DI_MTNWR_CTRL                            (volatile uint32_t *)((0x17c5  << 2) + 0xff900000)
#define   DI_DIWR_X                                (0x17c6)
#define P_DI_DIWR_X                                (volatile uint32_t *)((0x17c6  << 2) + 0xff900000)
#define   DI_DIWR_Y                                (0x17c7)
#define P_DI_DIWR_Y                                (volatile uint32_t *)((0x17c7  << 2) + 0xff900000)
//bit 31:30             diwr_words_lim
//bit 29                diwr_rev_y
//bit 28:16             diwr_start_y
//bit 15                diwr_ext_en
//bit 12:0              diwr_end_y
#define   DI_DIWR_CTRL                             (0x17c8)
#define P_DI_DIWR_CTRL                             (volatile uint32_t *)((0x17c8  << 2) + 0xff900000)
//bit 31                pending_ddr_wrrsp_diwr
//bit 30                diwr_reg_swap
//bit 29:26             diwr_burst_lim
//bit 25                diwr_canvas_syncen
//bit 24                diwr_no_clk_gate
//bit 23:22             diwr_rgb_mode  0:422 to one canvas;1:4:4:4 to one canvas;
//bit 21:20             diwr_hconv_mode
//bit 19:18             diwr_vconv_mode
//bit 17                diwr_swap_cbcr
//bit 16                diwr_urgent
//bit 15:8              diwr_canvas_index_chroma
//bit 7:0               diwr_canvas_index_luma
//`define DI_MTNCRD_X               8'hc9
//`define DI_MTNCRD_Y               8'hca
#define   DI_MTNPRD_X                              (0x17cb)
#define P_DI_MTNPRD_X                              (volatile uint32_t *)((0x17cb  << 2) + 0xff900000)
#define   DI_MTNPRD_Y                              (0x17cc)
#define P_DI_MTNPRD_Y                              (volatile uint32_t *)((0x17cc  << 2) + 0xff900000)
#define   DI_MTNRD_CTRL                            (0x17cd)
#define P_DI_MTNRD_CTRL                            (volatile uint32_t *)((0x17cd  << 2) + 0xff900000)
#define   DI_INP_GEN_REG                           (0x17ce)
#define P_DI_INP_GEN_REG                           (volatile uint32_t *)((0x17ce  << 2) + 0xff900000)
#define   DI_INP_CANVAS0                           (0x17cf)
#define P_DI_INP_CANVAS0                           (volatile uint32_t *)((0x17cf  << 2) + 0xff900000)
#define   DI_INP_LUMA_X0                           (0x17d0)
#define P_DI_INP_LUMA_X0                           (volatile uint32_t *)((0x17d0  << 2) + 0xff900000)
#define   DI_INP_LUMA_Y0                           (0x17d1)
#define P_DI_INP_LUMA_Y0                           (volatile uint32_t *)((0x17d1  << 2) + 0xff900000)
#define   DI_INP_CHROMA_X0                         (0x17d2)
#define P_DI_INP_CHROMA_X0                         (volatile uint32_t *)((0x17d2  << 2) + 0xff900000)
#define   DI_INP_CHROMA_Y0                         (0x17d3)
#define P_DI_INP_CHROMA_Y0                         (volatile uint32_t *)((0x17d3  << 2) + 0xff900000)
#define   DI_INP_RPT_LOOP                          (0x17d4)
#define P_DI_INP_RPT_LOOP                          (volatile uint32_t *)((0x17d4  << 2) + 0xff900000)
#define   DI_INP_LUMA0_RPT_PAT                     (0x17d5)
#define P_DI_INP_LUMA0_RPT_PAT                     (volatile uint32_t *)((0x17d5  << 2) + 0xff900000)
#define   DI_INP_CHROMA0_RPT_PAT                   (0x17d6)
#define P_DI_INP_CHROMA0_RPT_PAT                   (volatile uint32_t *)((0x17d6  << 2) + 0xff900000)
#define   DI_INP_DUMMY_PIXEL                       (0x17d7)
#define P_DI_INP_DUMMY_PIXEL                       (volatile uint32_t *)((0x17d7  << 2) + 0xff900000)
#define   DI_INP_LUMA_FIFO_SIZE                    (0x17d8)
#define P_DI_INP_LUMA_FIFO_SIZE                    (volatile uint32_t *)((0x17d8  << 2) + 0xff900000)
#define   DI_INP_RANGE_MAP_Y                       (0x17ba)
#define P_DI_INP_RANGE_MAP_Y                       (volatile uint32_t *)((0x17ba  << 2) + 0xff900000)
#define   DI_INP_RANGE_MAP_CB                      (0x17bb)
#define P_DI_INP_RANGE_MAP_CB                      (volatile uint32_t *)((0x17bb  << 2) + 0xff900000)
#define   DI_INP_RANGE_MAP_CR                      (0x17bc)
#define P_DI_INP_RANGE_MAP_CR                      (volatile uint32_t *)((0x17bc  << 2) + 0xff900000)
#define   DI_INP_GEN_REG2                          (0x1791)
#define P_DI_INP_GEN_REG2                          (volatile uint32_t *)((0x1791  << 2) + 0xff900000)
#define   DI_INP_FMT_CTRL                          (0x17d9)
#define P_DI_INP_FMT_CTRL                          (volatile uint32_t *)((0x17d9  << 2) + 0xff900000)
#define   DI_INP_FMT_W                             (0x17da)
#define P_DI_INP_FMT_W                             (volatile uint32_t *)((0x17da  << 2) + 0xff900000)
#define   DI_MEM_GEN_REG                           (0x17db)
#define P_DI_MEM_GEN_REG                           (volatile uint32_t *)((0x17db  << 2) + 0xff900000)
#define   DI_MEM_CANVAS0                           (0x17dc)
#define P_DI_MEM_CANVAS0                           (volatile uint32_t *)((0x17dc  << 2) + 0xff900000)
#define   DI_MEM_LUMA_X0                           (0x17dd)
#define P_DI_MEM_LUMA_X0                           (volatile uint32_t *)((0x17dd  << 2) + 0xff900000)
#define   DI_MEM_LUMA_Y0                           (0x17de)
#define P_DI_MEM_LUMA_Y0                           (volatile uint32_t *)((0x17de  << 2) + 0xff900000)
#define   DI_MEM_CHROMA_X0                         (0x17df)
#define P_DI_MEM_CHROMA_X0                         (volatile uint32_t *)((0x17df  << 2) + 0xff900000)
#define   DI_MEM_CHROMA_Y0                         (0x17e0)
#define P_DI_MEM_CHROMA_Y0                         (volatile uint32_t *)((0x17e0  << 2) + 0xff900000)
#define   DI_MEM_RPT_LOOP                          (0x17e1)
#define P_DI_MEM_RPT_LOOP                          (volatile uint32_t *)((0x17e1  << 2) + 0xff900000)
#define   DI_MEM_LUMA0_RPT_PAT                     (0x17e2)
#define P_DI_MEM_LUMA0_RPT_PAT                     (volatile uint32_t *)((0x17e2  << 2) + 0xff900000)
#define   DI_MEM_CHROMA0_RPT_PAT                   (0x17e3)
#define P_DI_MEM_CHROMA0_RPT_PAT                   (volatile uint32_t *)((0x17e3  << 2) + 0xff900000)
#define   DI_MEM_DUMMY_PIXEL                       (0x17e4)
#define P_DI_MEM_DUMMY_PIXEL                       (volatile uint32_t *)((0x17e4  << 2) + 0xff900000)
#define   DI_MEM_LUMA_FIFO_SIZE                    (0x17e5)
#define P_DI_MEM_LUMA_FIFO_SIZE                    (volatile uint32_t *)((0x17e5  << 2) + 0xff900000)
#define   DI_MEM_RANGE_MAP_Y                       (0x17bd)
#define P_DI_MEM_RANGE_MAP_Y                       (volatile uint32_t *)((0x17bd  << 2) + 0xff900000)
#define   DI_MEM_RANGE_MAP_CB                      (0x17be)
#define P_DI_MEM_RANGE_MAP_CB                      (volatile uint32_t *)((0x17be  << 2) + 0xff900000)
#define   DI_MEM_RANGE_MAP_CR                      (0x17bf)
#define P_DI_MEM_RANGE_MAP_CR                      (volatile uint32_t *)((0x17bf  << 2) + 0xff900000)
#define   DI_MEM_GEN_REG2                          (0x1792)
#define P_DI_MEM_GEN_REG2                          (volatile uint32_t *)((0x1792  << 2) + 0xff900000)
#define   DI_MEM_FMT_CTRL                          (0x17e6)
#define P_DI_MEM_FMT_CTRL                          (volatile uint32_t *)((0x17e6  << 2) + 0xff900000)
#define   DI_MEM_FMT_W                             (0x17e7)
#define P_DI_MEM_FMT_W                             (volatile uint32_t *)((0x17e7  << 2) + 0xff900000)
#define   DI_IF1_GEN_REG                           (0x17e8)
#define P_DI_IF1_GEN_REG                           (volatile uint32_t *)((0x17e8  << 2) + 0xff900000)
#define   DI_IF1_CANVAS0                           (0x17e9)
#define P_DI_IF1_CANVAS0                           (volatile uint32_t *)((0x17e9  << 2) + 0xff900000)
#define   DI_IF1_LUMA_X0                           (0x17ea)
#define P_DI_IF1_LUMA_X0                           (volatile uint32_t *)((0x17ea  << 2) + 0xff900000)
#define   DI_IF1_LUMA_Y0                           (0x17eb)
#define P_DI_IF1_LUMA_Y0                           (volatile uint32_t *)((0x17eb  << 2) + 0xff900000)
#define   DI_IF1_CHROMA_X0                         (0x17ec)
#define P_DI_IF1_CHROMA_X0                         (volatile uint32_t *)((0x17ec  << 2) + 0xff900000)
#define   DI_IF1_CHROMA_Y0                         (0x17ed)
#define P_DI_IF1_CHROMA_Y0                         (volatile uint32_t *)((0x17ed  << 2) + 0xff900000)
#define   DI_IF1_RPT_LOOP                          (0x17ee)
#define P_DI_IF1_RPT_LOOP                          (volatile uint32_t *)((0x17ee  << 2) + 0xff900000)
#define   DI_IF1_LUMA0_RPT_PAT                     (0x17ef)
#define P_DI_IF1_LUMA0_RPT_PAT                     (volatile uint32_t *)((0x17ef  << 2) + 0xff900000)
#define   DI_IF1_CHROMA0_RPT_PAT                   (0x17f0)
#define P_DI_IF1_CHROMA0_RPT_PAT                   (volatile uint32_t *)((0x17f0  << 2) + 0xff900000)
#define   DI_IF1_DUMMY_PIXEL                       (0x17f1)
#define P_DI_IF1_DUMMY_PIXEL                       (volatile uint32_t *)((0x17f1  << 2) + 0xff900000)
#define   DI_IF1_LUMA_FIFO_SIZE                    (0x17f2)
#define P_DI_IF1_LUMA_FIFO_SIZE                    (volatile uint32_t *)((0x17f2  << 2) + 0xff900000)
#define   DI_IF1_RANGE_MAP_Y                       (0x17fc)
#define P_DI_IF1_RANGE_MAP_Y                       (volatile uint32_t *)((0x17fc  << 2) + 0xff900000)
#define   DI_IF1_RANGE_MAP_CB                      (0x17fd)
#define P_DI_IF1_RANGE_MAP_CB                      (volatile uint32_t *)((0x17fd  << 2) + 0xff900000)
#define   DI_IF1_RANGE_MAP_CR                      (0x17fe)
#define P_DI_IF1_RANGE_MAP_CR                      (volatile uint32_t *)((0x17fe  << 2) + 0xff900000)
#define   DI_IF1_GEN_REG2                          (0x1790)
#define P_DI_IF1_GEN_REG2                          (volatile uint32_t *)((0x1790  << 2) + 0xff900000)
#define   DI_IF1_FMT_CTRL                          (0x17f3)
#define P_DI_IF1_FMT_CTRL                          (volatile uint32_t *)((0x17f3  << 2) + 0xff900000)
#define   DI_IF1_FMT_W                             (0x17f4)
#define P_DI_IF1_FMT_W                             (volatile uint32_t *)((0x17f4  << 2) + 0xff900000)
#define   DI_CHAN2_GEN_REG                         (0x17f5)
#define P_DI_CHAN2_GEN_REG                         (volatile uint32_t *)((0x17f5  << 2) + 0xff900000)
#define   DI_CHAN2_CANVAS0                         (0x17f6)
#define P_DI_CHAN2_CANVAS0                         (volatile uint32_t *)((0x17f6  << 2) + 0xff900000)
#define   DI_CHAN2_LUMA_X0                         (0x17f7)
#define P_DI_CHAN2_LUMA_X0                         (volatile uint32_t *)((0x17f7  << 2) + 0xff900000)
#define   DI_CHAN2_LUMA_Y0                         (0x17f8)
#define P_DI_CHAN2_LUMA_Y0                         (volatile uint32_t *)((0x17f8  << 2) + 0xff900000)
#define   DI_CHAN2_CHROMA_X0                       (0x17f9)
#define P_DI_CHAN2_CHROMA_X0                       (volatile uint32_t *)((0x17f9  << 2) + 0xff900000)
#define   DI_CHAN2_CHROMA_Y0                       (0x17fa)
#define P_DI_CHAN2_CHROMA_Y0                       (volatile uint32_t *)((0x17fa  << 2) + 0xff900000)
#define   DI_CHAN2_RPT_LOOP                        (0x17fb)
#define P_DI_CHAN2_RPT_LOOP                        (volatile uint32_t *)((0x17fb  << 2) + 0xff900000)
#define   DI_CHAN2_LUMA0_RPT_PAT                   (0x17b0)
#define P_DI_CHAN2_LUMA0_RPT_PAT                   (volatile uint32_t *)((0x17b0  << 2) + 0xff900000)
#define   DI_CHAN2_CHROMA0_RPT_PAT                 (0x17b1)
#define P_DI_CHAN2_CHROMA0_RPT_PAT                 (volatile uint32_t *)((0x17b1  << 2) + 0xff900000)
#define   DI_CHAN2_DUMMY_PIXEL                     (0x17b2)
#define P_DI_CHAN2_DUMMY_PIXEL                     (volatile uint32_t *)((0x17b2  << 2) + 0xff900000)
#define   DI_CHAN2_LUMA_FIFO_SIZE                  (0x17b3)
#define P_DI_CHAN2_LUMA_FIFO_SIZE                  (volatile uint32_t *)((0x17b3  << 2) + 0xff900000)
#define   DI_CHAN2_RANGE_MAP_Y                     (0x17b4)
#define P_DI_CHAN2_RANGE_MAP_Y                     (volatile uint32_t *)((0x17b4  << 2) + 0xff900000)
#define   DI_CHAN2_RANGE_MAP_CB                    (0x17b5)
#define P_DI_CHAN2_RANGE_MAP_CB                    (volatile uint32_t *)((0x17b5  << 2) + 0xff900000)
#define   DI_CHAN2_RANGE_MAP_CR                    (0x17b6)
#define P_DI_CHAN2_RANGE_MAP_CR                    (volatile uint32_t *)((0x17b6  << 2) + 0xff900000)
#define   DI_CHAN2_GEN_REG2                        (0x17b7)
#define P_DI_CHAN2_GEN_REG2                        (volatile uint32_t *)((0x17b7  << 2) + 0xff900000)
#define   DI_CHAN2_FMT_CTRL                        (0x17b8)
#define P_DI_CHAN2_FMT_CTRL                        (volatile uint32_t *)((0x17b8  << 2) + 0xff900000)
#define   DI_CHAN2_FMT_W                           (0x17b9)
#define P_DI_CHAN2_FMT_W                           (volatile uint32_t *)((0x17b9  << 2) + 0xff900000)
//
// Closing file:  mad_regs.h
//
//`define VPP2_VCBUS_BASE              8'h19
//
// Reading file:  vpp2_regs.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// CBUS_BASE:  VPP2_VCBUS_BASE = 0x19
// -----------------------------------------------
//===========================================================================
// Video postprocessing Registers
//===========================================================================
// dummy data used in the VPP preblend and scaler
// Bit 23:16
// Bit 15:8     CB
// Bit 7:0      CR
#define   VPP2_DUMMY_DATA                          (0x1900)
#define P_VPP2_DUMMY_DATA                          (volatile uint32_t *)((0x1900  << 2) + 0xff900000)
//input line length used in VPP
#define   VPP2_LINE_IN_LENGTH                      (0x1901)
#define P_VPP2_LINE_IN_LENGTH                      (volatile uint32_t *)((0x1901  << 2) + 0xff900000)
//input Picture height used in VPP
#define   VPP2_PIC_IN_HEIGHT                       (0x1902)
#define P_VPP2_PIC_IN_HEIGHT                       (volatile uint32_t *)((0x1902  << 2) + 0xff900000)
//Because there are many coefficients used in the vertical filter and horizontal filters,
//indirect access the coefficients of vertical filter and horizontal filter is used.
//For vertical filter, there are 33x4 coefficients
//For horizontal filter, there are 33x4 coefficients
//Bit 15    index increment, if bit9 == 1  then (0: index increase 1, 1: index increase 2) else (index increase 2)
//Bit 14    1: read coef through cbus enable, just for debug purpose in case when we wanna check the coef in ram in correct or not
//Bit 13    if true, vertical separated coef enable
//Bit 9     if true, use 9bit resolution coef, other use 8bit resolution coef
//Bit 8:7   type of index, 00: vertical coef, 01: vertical chroma coef: 10: horizontal coef, 11: resevered
//Bit 6:0   coef index
#define   VPP2_SCALE_COEF_IDX                      (0x1903)
#define P_VPP2_SCALE_COEF_IDX                      (volatile uint32_t *)((0x1903  << 2) + 0xff900000)
//coefficients for vertical filter and horizontal filter
#define   VPP2_SCALE_COEF                          (0x1904)
#define P_VPP2_SCALE_COEF                          (volatile uint32_t *)((0x1904  << 2) + 0xff900000)
//these following registers are the absolute line address pointer for output divided screen
//The output divided screen is shown in the following:
//
//  --------------------------   <------ line zero
//      .
//      .
//      .           region0        <---------- nonlinear region or nonscaling region
//      .
//  ---------------------------
//  ---------------------------  <------ region1_startp
//      .
//      .           region1         <---------- nonlinear region
//      .
//      .
//  ---------------------------
//  ---------------------------  <------ region2_startp
//      .
//      .           region2         <---------- linear region
//      .
//      .
//  ---------------------------
//  ---------------------------  <------ region3_startp
//      .
//      .           region3         <---------- nonlinear region
//      .
//      .
//  ---------------------------
//  ---------------------------  <------ region4_startp
//      .
//      .           region4         <---------- nonlinear region or nonoscaling region
//      .
//      .
//  ---------------------------  <------ region4_endp
//Bit 28:16 region1 startp
//Bit 12:0 region2 startp
#define   VPP2_VSC_REGION12_STARTP                 (0x1905)
#define P_VPP2_VSC_REGION12_STARTP                 (volatile uint32_t *)((0x1905  << 2) + 0xff900000)
//Bit 28:16 region3 startp
//Bit 12:0 region4 startp
#define   VPP2_VSC_REGION34_STARTP                 (0x1906)
#define P_VPP2_VSC_REGION34_STARTP                 (volatile uint32_t *)((0x1906  << 2) + 0xff900000)
#define   VPP2_VSC_REGION4_ENDP                    (0x1907)
#define P_VPP2_VSC_REGION4_ENDP                    (volatile uint32_t *)((0x1907  << 2) + 0xff900000)
//vertical start phase step, (source/dest)*(2^24)
//Bit 27:24 integer part
//Bit 23:0  fraction part
#define   VPP2_VSC_START_PHASE_STEP                (0x1908)
#define P_VPP2_VSC_START_PHASE_STEP                (volatile uint32_t *)((0x1908  << 2) + 0xff900000)
//vertical scaler region0 phase slope, Bit24 signed bit
#define   VPP2_VSC_REGION0_PHASE_SLOPE             (0x1909)
#define P_VPP2_VSC_REGION0_PHASE_SLOPE             (volatile uint32_t *)((0x1909  << 2) + 0xff900000)
//vertical scaler region1 phase slope, Bit24 signed bit
#define   VPP2_VSC_REGION1_PHASE_SLOPE             (0x190a)
#define P_VPP2_VSC_REGION1_PHASE_SLOPE             (volatile uint32_t *)((0x190a  << 2) + 0xff900000)
//vertical scaler region3 phase slope, Bit24 signed bit
#define   VPP2_VSC_REGION3_PHASE_SLOPE             (0x190b)
#define P_VPP2_VSC_REGION3_PHASE_SLOPE             (volatile uint32_t *)((0x190b  << 2) + 0xff900000)
//vertical scaler region4 phase slope, Bit24 signed bit
#define   VPP2_VSC_REGION4_PHASE_SLOPE             (0x190c)
#define P_VPP2_VSC_REGION4_PHASE_SLOPE             (volatile uint32_t *)((0x190c  << 2) + 0xff900000)
//Bit 18:17     double line mode, input/output line width of vscaler becomes 2X,
//           so only 2 line buffer in this case, use for 3D line by line interleave scaling
//           bit1 true, double the input width and half input height, bit0 true, change line buffer 2 lines instead of 4 lines
//Bit 16     0: progressive output, 1: interlace output
//Bit 15     vertical scaler output line0 in advance or not for bottom field
//Bit 14:13  vertical scaler initial repeat line0 number for bottom field
//Bit 11:8   vertical scaler initial receiving  number for bottom field
//Bit 7      vertical scaler output line0 in advance or not for top field
//Bit 6:5    vertical scaler initial repeat line0 number for top field
//Bit 3:0    vertical scaler initial receiving  number for top field
#define   VPP2_VSC_PHASE_CTRL                      (0x190d)
#define P_VPP2_VSC_PHASE_CTRL                      (volatile uint32_t *)((0x190d  << 2) + 0xff900000)
//Bit 31:16  vertical scaler field initial phase for bottom field
//Bit 15:0  vertical scaler field initial phase for top field
#define   VPP2_VSC_INI_PHASE                       (0x190e)
#define P_VPP2_VSC_INI_PHASE                       (volatile uint32_t *)((0x190e  << 2) + 0xff900000)
//Bit 28:16 region1 startp
//Bit 12:0 region2 startp
#define   VPP2_HSC_REGION12_STARTP                 (0x1910)
#define P_VPP2_HSC_REGION12_STARTP                 (volatile uint32_t *)((0x1910  << 2) + 0xff900000)
//Bit 28:16 region3 startp
//Bit 12:0 region4 startp
#define   VPP2_HSC_REGION34_STARTP                 (0x1911)
#define P_VPP2_HSC_REGION34_STARTP                 (volatile uint32_t *)((0x1911  << 2) + 0xff900000)
#define   VPP2_HSC_REGION4_ENDP                    (0x1912)
#define P_VPP2_HSC_REGION4_ENDP                    (volatile uint32_t *)((0x1912  << 2) + 0xff900000)
//horizontal start phase step, (source/dest)*(2^24)
//Bit 27:24 integer part
//Bit 23:0  fraction part
#define   VPP2_HSC_START_PHASE_STEP                (0x1913)
#define P_VPP2_HSC_START_PHASE_STEP                (volatile uint32_t *)((0x1913  << 2) + 0xff900000)
//horizontal scaler region0 phase slope, Bit24 signed bit
#define   VPP2_HSC_REGION0_PHASE_SLOPE             (0x1914)
#define P_VPP2_HSC_REGION0_PHASE_SLOPE             (volatile uint32_t *)((0x1914  << 2) + 0xff900000)
//horizontal scaler region1 phase slope, Bit24 signed bit
#define   VPP2_HSC_REGION1_PHASE_SLOPE             (0x1915)
#define P_VPP2_HSC_REGION1_PHASE_SLOPE             (volatile uint32_t *)((0x1915  << 2) + 0xff900000)
//horizontal scaler region3 phase slope, Bit24 signed bit
#define   VPP2_HSC_REGION3_PHASE_SLOPE             (0x1916)
#define P_VPP2_HSC_REGION3_PHASE_SLOPE             (volatile uint32_t *)((0x1916  << 2) + 0xff900000)
//horizontal scaler region4 phase slope, Bit24 signed bit
#define   VPP2_HSC_REGION4_PHASE_SLOPE             (0x1917)
#define P_VPP2_HSC_REGION4_PHASE_SLOPE             (volatile uint32_t *)((0x1917  << 2) + 0xff900000)
//Bit 22:21   horizontal scaler initial repeat pixel0 number
//Bit 19:16   horizontal scaler initial receiving number
//Bit 15:0    horizontal scaler top field initial phase
#define   VPP2_HSC_PHASE_CTRL                      (0x1918)
#define P_VPP2_HSC_PHASE_CTRL                      (volatile uint32_t *)((0x1918  << 2) + 0xff900000)
// Bit 22 if true, divide VSC line length 2 as the HSC input length, otherwise VSC length length is the same as the VSC line length,
//                 just for special usage, more flexibility
// Bit 21 if true, prevsc uses lin buffer, otherwise prevsc does not use line buffer, it should be same as prevsc_en
// Bit 20 prehsc_en
// Bit 19 prevsc_en
// Bit 18 vsc_en
// Bit 17 hsc_en
// Bit 16 scale_top_en
// Bit 15 video1 scale out enable
// Bit 12 if true, region0,region4 are nonlinear regions, otherwise they are not scaling regions, for horizontal scaler
// Bit 10:8 horizontal scaler bank length
// Bit 5, vertical scaler phase field mode, if true, disable the opposite parity line output, more bandwith needed if output 1080i
// Bit 4 if true, region0,region4 are nonlinear regions, otherwise they are not scaling regions, for vertical scaler
// Bit 2:0 vertical scaler bank length
#define   VPP2_SC_MISC                             (0x1919)
#define P_VPP2_SC_MISC                             (volatile uint32_t *)((0x1919  << 2) + 0xff900000)
// preblend video1 horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define   VPP2_PREBLEND_VD1_H_START_END            (0x191a)
#define P_VPP2_PREBLEND_VD1_H_START_END            (volatile uint32_t *)((0x191a  << 2) + 0xff900000)
// preblend video1 vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define   VPP2_PREBLEND_VD1_V_START_END            (0x191b)
#define P_VPP2_PREBLEND_VD1_V_START_END            (volatile uint32_t *)((0x191b  << 2) + 0xff900000)
// postblend video1 horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define   VPP2_POSTBLEND_VD1_H_START_END           (0x191c)
#define P_VPP2_POSTBLEND_VD1_H_START_END           (volatile uint32_t *)((0x191c  << 2) + 0xff900000)
// postblend video1 vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define   VPP2_POSTBLEND_VD1_V_START_END           (0x191d)
#define P_VPP2_POSTBLEND_VD1_V_START_END           (volatile uint32_t *)((0x191d  << 2) + 0xff900000)
// preblend horizontal size
#define   VPP2_PREBLEND_H_SIZE                     (0x1920)
#define P_VPP2_PREBLEND_H_SIZE                     (volatile uint32_t *)((0x1920  << 2) + 0xff900000)
// postblend horizontal size
#define   VPP2_POSTBLEND_H_SIZE                    (0x1921)
#define P_VPP2_POSTBLEND_H_SIZE                    (volatile uint32_t *)((0x1921  << 2) + 0xff900000)
//VPP hold lines
//Bit 29:24
//Bit 21:16
//Bit 15:8     preblend hold lines
//Bit 7:0      postblend hold lines
#define   VPP2_HOLD_LINES                          (0x1922)
#define P_VPP2_HOLD_LINES                          (volatile uint32_t *)((0x1922  << 2) + 0xff900000)
//Bit 25   if true, change screen to one color value for preblender
//Bit 24   if true, change screen to one color value for postblender
// Bit 23:16 one color Y
// Bit 15:8 one color Cb
// Bit  7:0 one color  Cr
#define   VPP2_BLEND_ONECOLOR_CTRL                 (0x1923)
#define P_VPP2_BLEND_ONECOLOR_CTRL                 (volatile uint32_t *)((0x1923  << 2) + 0xff900000)
//Read Only, VPP preblend current_x, current_y
//Bit 28:16 current_x
//Bit 12:0 current_y
#define   VPP2_PREBLEND_CURRENT_XY                 (0x1924)
#define P_VPP2_PREBLEND_CURRENT_XY                 (volatile uint32_t *)((0x1924  << 2) + 0xff900000)
//Read Only, VPP postblend current_x, current_y
//Bit 28:16 current_x
//Bit 12:0 current_y
#define   VPP2_POSTBLEND_CURRENT_XY                (0x1925)
#define P_VPP2_POSTBLEND_CURRENT_XY                (volatile uint32_t *)((0x1925  << 2) + 0xff900000)
// Bit 31  vd1_bgosd_exchange_en for preblend
// Bit 30  vd1_bgosd_exchange_en for postblend
// bit 28   color management enable
// Bit 27,  reserved
// Bit 26:18, reserved
// Bit 17, osd2 enable for preblend
// Bit 16, osd1 enable for preblend
// Bit 15, reserved
// Bit 14, vd1 enable for preblend
// Bit 13, osd2 enable for postblend
// Bit 12, osd1 enable for postblend
// Bit 11, reserved
// Bit 10, vd1 enable for postblend
// Bit 9,  if true, osd1 is alpha premultiplied
// Bit 8,  if true, osd2 is alpha premultiplied
// Bit 7,  postblend module enable
// Bit 6,  preblend module enable
// Bit 5,  if true, osd2 foreground compared with osd1 in preblend
// Bit 4,  if true, osd2 foreground compared with osd1 in postblend
// Bit 3,
// Bit 2,  if true, disable resetting async fifo every vsync, otherwise every vsync
//           the aync fifo will be reseted.
// Bit 1,
// Bit 0    if true, the output result of VPP is saturated
#define   VPP2_MISC                                (0x1926)
#define P_VPP2_MISC                                (volatile uint32_t *)((0x1926  << 2) + 0xff900000)
//Bit 31:20 ofifo line length minus 1
//Bit 19  if true invert input vs
//Bit 18  if true invert input hs
//Bit 17  force top/bottom field, enable
//Bit 16  force top/bottom field, 0: top, 1: bottom
//Bit 15  force one go_field, one pluse, write only
//Bit 14  force one go_line, one pluse, write only
//Bit 12:0 ofifo size (actually only bit 10:1 is valid), always even number
#define   VPP2_OFIFO_SIZE                          (0x1927)
#define P_VPP2_OFIFO_SIZE                          (volatile uint32_t *)((0x1927  << 2) + 0xff900000)
//Read only
//Bit 28:17 current scale out fifo counter
//Bit 16:12 current afifo counter
//Bit 11:0 current ofifo counter
#define   VPP2_FIFO_STATUS                         (0x1928)
#define P_VPP2_FIFO_STATUS                         (volatile uint32_t *)((0x1928  << 2) + 0xff900000)
// Bit 3 SMOKE2 postblend enable only when postblend osd2 is not enable
// Bit 2 SMOKE2 preblend enable only when preblend osd2 is not enable
// Bit 1 SMOKE1 postblend enable only when postblend osd1 is not enable
// Bit 0 SMOKE1 preblend enable only when preblend osd1 is not enable
#define   VPP2_SMOKE_CTRL                          (0x1929)
#define P_VPP2_SMOKE_CTRL                          (volatile uint32_t *)((0x1929  << 2) + 0xff900000)
//smoke can be used only when that blending is disable and then be used as smoke function
//smoke1 for OSD1 channel
//smoke2 for OSD2 channel
//31:24 Y
//23:16 Cb
//15:8 Cr
//7:0 Alpha
#define   VPP2_SMOKE1_VAL                          (0x192a)
#define P_VPP2_SMOKE1_VAL                          (volatile uint32_t *)((0x192a  << 2) + 0xff900000)
#define   VPP2_SMOKE2_VAL                          (0x192b)
#define P_VPP2_SMOKE2_VAL                          (volatile uint32_t *)((0x192b  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define   VPP2_SMOKE1_H_START_END                  (0x192d)
#define P_VPP2_SMOKE1_H_START_END                  (volatile uint32_t *)((0x192d  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define   VPP2_SMOKE1_V_START_END                  (0x192e)
#define P_VPP2_SMOKE1_V_START_END                  (volatile uint32_t *)((0x192e  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define   VPP2_SMOKE2_H_START_END                  (0x192f)
#define P_VPP2_SMOKE2_H_START_END                  (volatile uint32_t *)((0x192f  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define   VPP2_SMOKE2_V_START_END                  (0x1930)
#define P_VPP2_SMOKE2_V_START_END                  (volatile uint32_t *)((0x1930  << 2) + 0xff900000)
//Bit 27:16 scale out fifo line length minus 1
//Bit 12:0 scale out fifo size (actually only bit 11:1 is valid, 11:1, max 1024), always even number
#define   VPP2_SCO_FIFO_CTRL                       (0x1933)
#define P_VPP2_SCO_FIFO_CTRL                       (volatile uint32_t *)((0x1933  << 2) + 0xff900000)
//for 3D quincunx sub-sampling and horizontal pixel by pixel 3D interleaving
//Bit 27:24, prehsc_mode, bit 3:2, prehsc odd line interp mode, bit 1:0, prehsc even line interp mode,
//           each 2bit, 00: pix0+pix1/2, average, 01: pix1, 10: pix0
//Bit 23 horizontal scaler double pixel mode
//Bit 22:21   horizontal scaler initial repeat pixel0 number1
//Bit 19:16   horizontal scaler initial receiving number1
//Bit 15:0    horizontal scaler top field initial phase1
#define   VPP2_HSC_PHASE_CTRL1                     (0x1934)
#define P_VPP2_HSC_PHASE_CTRL1                     (volatile uint32_t *)((0x1934  << 2) + 0xff900000)
//for 3D quincunx sub-sampling
//31:24  prehsc pattern, each patten 1 bit, from lsb -> msb
//22:20  prehsc pattern start
//18:16 prehsc pattern end
//15:8 pattern, each patten 1 bit, from lsb -> msb
//6:4  pattern start
//2:0  pattern end
#define   VPP2_HSC_INI_PAT_CTRL                    (0x1935)
#define P_VPP2_HSC_INI_PAT_CTRL                    (volatile uint32_t *)((0x1935  << 2) + 0xff900000)
//Bit 3         minus black level enable for vadj2
//Bit 2         Video adjustment enable for vadj2
//Bit 1         minus black level enable for vadj1
//Bit 0         Video adjustment enable for vadj1
#define   VPP2_VADJ_CTRL                           (0x1940)
#define P_VPP2_VADJ_CTRL                           (volatile uint32_t *)((0x1940  << 2) + 0xff900000)
//Bit 16:8  brightness, signed value
//Bit 7:0   contrast, unsigned value, contrast from  0 <= contrast <2
#define   VPP2_VADJ1_Y                             (0x1941)
#define P_VPP2_VADJ1_Y                             (volatile uint32_t *)((0x1941  << 2) + 0xff900000)
//cb' = cb*ma + cr*mb
//cr' = cb*mc + cr*md
//all are bit 9:0, signed value, -2 < ma/mb/mc/md < 2
#define   VPP2_VADJ1_MA_MB                         (0x1942)
#define P_VPP2_VADJ1_MA_MB                         (volatile uint32_t *)((0x1942  << 2) + 0xff900000)
#define   VPP2_VADJ1_MC_MD                         (0x1943)
#define P_VPP2_VADJ1_MC_MD                         (volatile uint32_t *)((0x1943  << 2) + 0xff900000)
//Bit 16:8  brightness, signed value
//Bit 7:0   contrast, unsigned value, contrast from  0 <= contrast <2
#define   VPP2_VADJ2_Y                             (0x1944)
#define P_VPP2_VADJ2_Y                             (volatile uint32_t *)((0x1944  << 2) + 0xff900000)
//cb' = cb*ma + cr*mb
//cr' = cb*mc + cr*md
//all are bit 9:0, signed value, -2 < ma/mb/mc/md < 2
#define   VPP2_VADJ2_MA_MB                         (0x1945)
#define P_VPP2_VADJ2_MA_MB                         (volatile uint32_t *)((0x1945  << 2) + 0xff900000)
#define   VPP2_VADJ2_MC_MD                         (0x1946)
#define P_VPP2_VADJ2_MC_MD                         (volatile uint32_t *)((0x1946  << 2) + 0xff900000)
//Read only
//Bit 31, if it is true, it means this probe is valid in the last field/frame
//Bit 29:20 component 0
//Bit 19:10 component 1
//Bit 9:0 component 2
#define   VPP2_MATRIX_PROBE_COLOR                  (0x195c)
#define P_VPP2_MATRIX_PROBE_COLOR                  (volatile uint32_t *)((0x195c  << 2) + 0xff900000)
//Bit 23:16 component 0
//Bit 15:8  component 1
//Bit 7:0 component 2
#define   VPP2_MATRIX_HL_COLOR                     (0x195d)
#define P_VPP2_MATRIX_HL_COLOR                     (volatile uint32_t *)((0x195d  << 2) + 0xff900000)
//28:16 probe x, postion
//12:0  probe y, position
#define   VPP2_MATRIX_PROBE_POS                    (0x195e)
#define P_VPP2_MATRIX_PROBE_POS                    (volatile uint32_t *)((0x195e  << 2) + 0xff900000)
//Bit 16,  highlight_en
//Bit 15   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before matrix
//Bit 14:12 probe_sel, 000: select post matrix, 001: select vd1 matrix,
//Bit 9:8  matrix coef idx selection, 00: select post matrix, 01: select vd1 matrix
//Bit 5    vd1 conversion matrix enable
//Bit 4    reserved
//Bit 2    output y/cb/cr saturation enable, only for post matrix (y saturate to 16-235, cb/cr saturate to 16-240)
//Bit 1    input y/cb/cr saturation enable, only for post matrix (y saturate to 16-235, cb/cr saturate to 16-240)
//Bit 0    post conversion matrix enable
#define   VPP2_MATRIX_CTRL                         (0x195f)
#define P_VPP2_MATRIX_CTRL                         (volatile uint32_t *)((0x195f  << 2) + 0xff900000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define   VPP2_MATRIX_COEF00_01                    (0x1960)
#define P_VPP2_MATRIX_COEF00_01                    (volatile uint32_t *)((0x1960  << 2) + 0xff900000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define   VPP2_MATRIX_COEF02_10                    (0x1961)
#define P_VPP2_MATRIX_COEF02_10                    (volatile uint32_t *)((0x1961  << 2) + 0xff900000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define   VPP2_MATRIX_COEF11_12                    (0x1962)
#define P_VPP2_MATRIX_COEF11_12                    (volatile uint32_t *)((0x1962  << 2) + 0xff900000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define   VPP2_MATRIX_COEF20_21                    (0x1963)
#define P_VPP2_MATRIX_COEF20_21                    (volatile uint32_t *)((0x1963  << 2) + 0xff900000)
#define   VPP2_MATRIX_COEF22                       (0x1964)
#define P_VPP2_MATRIX_COEF22                       (volatile uint32_t *)((0x1964  << 2) + 0xff900000)
//Bit 26:16 offset0
//Bit 10:0  offset1
#define   VPP2_MATRIX_OFFSET0_1                    (0x1965)
#define P_VPP2_MATRIX_OFFSET0_1                    (volatile uint32_t *)((0x1965  << 2) + 0xff900000)
//Bit 10:0  offset2
#define   VPP2_MATRIX_OFFSET2                      (0x1966)
#define P_VPP2_MATRIX_OFFSET2                      (volatile uint32_t *)((0x1966  << 2) + 0xff900000)
//Bit 26:16 pre_offset0
//Bit 10:0  pre_offset1
#define   VPP2_MATRIX_PRE_OFFSET0_1                (0x1967)
#define P_VPP2_MATRIX_PRE_OFFSET0_1                (volatile uint32_t *)((0x1967  << 2) + 0xff900000)
//Bit 10:0  pre_offset2
#define   VPP2_MATRIX_PRE_OFFSET2                  (0x1968)
#define P_VPP2_MATRIX_PRE_OFFSET2                  (volatile uint32_t *)((0x1968  << 2) + 0xff900000)
// dummy data used in the VPP postblend
// Bit 23:16    Y
// Bit 15:8     CB
// Bit 7:0      CR
#define   VPP2_DUMMY_DATA1                         (0x1969)
#define P_VPP2_DUMMY_DATA1                         (volatile uint32_t *)((0x1969  << 2) + 0xff900000)
//Bit 31 gainoff module enable
//Bit 26:16 gain0, 1.10 unsigned data
//Bit 10:0  gain1, 1.10 unsigned dat
#define   VPP2_GAINOFF_CTRL0                       (0x196a)
#define P_VPP2_GAINOFF_CTRL0                       (volatile uint32_t *)((0x196a  << 2) + 0xff900000)
//Bit 26:16 gain2, 1.10 unsigned data
//Bit 10:0, offset0, signed data
#define   VPP2_GAINOFF_CTRL1                       (0x196b)
#define P_VPP2_GAINOFF_CTRL1                       (volatile uint32_t *)((0x196b  << 2) + 0xff900000)
//Bit 26:16, offset1, signed data
//Bit 10:0, offset2, signed data
#define   VPP2_GAINOFF_CTRL2                       (0x196c)
#define P_VPP2_GAINOFF_CTRL2                       (volatile uint32_t *)((0x196c  << 2) + 0xff900000)
//Bit 26:16, pre_offset0, signed data
//Bit 10:0, pre_offset1, signed data
#define   VPP2_GAINOFF_CTRL3                       (0x196d)
#define P_VPP2_GAINOFF_CTRL3                       (volatile uint32_t *)((0x196d  << 2) + 0xff900000)
//Bit 10:0, pre_offset2, signed data
#define   VPP2_GAINOFF_CTRL4                       (0x196e)
#define P_VPP2_GAINOFF_CTRL4                       (volatile uint32_t *)((0x196e  << 2) + 0xff900000)
//only two registers used in the color management, which are defined in the chroma_reg.h
#define   VPP2_CHROMA_ADDR_PORT                    (0x1970)
#define P_VPP2_CHROMA_ADDR_PORT                    (volatile uint32_t *)((0x1970  << 2) + 0xff900000)
#define   VPP2_CHROMA_DATA_PORT                    (0x1971)
#define P_VPP2_CHROMA_DATA_PORT                    (volatile uint32_t *)((0x1971  << 2) + 0xff900000)
//`include "chroma_reg.h"       //defined inside is the indirect addressed registers
//(hsvsharp), (blue), gainoff, mat_vd1,mat_vd2, mat_post, prebld, postbld,(hsharp),sco_ff, vadj1, vadj2, ofifo, (chroma1), clk0(free_clk) vpp_reg
//each item 2bits, for each 2bits, if bit 2*i+1 == 1, free clk, else if bit 2*i == 1 no clk, else auto gated clock
//bit1 is not used, because I can not turn off vpp_reg clk because I can not turn on again
//because the register itself canot be set again without clk
//Bit 31:0
#define   VPP2_GCLK_CTRL0                          (0x1972)
#define P_VPP2_GCLK_CTRL0                          (volatile uint32_t *)((0x1972  << 2) + 0xff900000)
//Chroma2_filter, Chroma2, (Ccoring), (blackext), dnlp
//Bit 9:0
#define   VPP2_GCLK_CTRL1                          (0x1973)
#define P_VPP2_GCLK_CTRL1                          (volatile uint32_t *)((0x1973  << 2) + 0xff900000)
//prehsc_clk, line_buf, prevsc, vsc, hsc_clk, clk0(free_clk)
//Bit 11:0
#define   VPP2_SC_GCLK_CTRL                        (0x1974)
#define P_VPP2_SC_GCLK_CTRL                        (volatile uint32_t *)((0x1974  << 2) + 0xff900000)
//Bit 17:9 VD1 alpha for preblend
//Bit 8:0 VD1 alpha for postblend
#define   VPP2_MISC1                               (0x1976)
#define P_VPP2_MISC1                               (volatile uint32_t *)((0x1976  << 2) + 0xff900000)
//Bit 31:24     bottom of region03 output value
//Bit 23:16     bottom of region02 output value
//Bit 15:8      bottom of region01 output value
//Bit 7:0       bottom of region00 output value
#define   VPP2_DNLP_CTRL_00                        (0x1981)
#define P_VPP2_DNLP_CTRL_00                        (volatile uint32_t *)((0x1981  << 2) + 0xff900000)
//Bit 31:24     bottom of region07 output value
//Bit 23:16     bottom of region06 output value
//Bit 15:8      bottom of region05 output value
//Bit 7:0       bottom of region04 output value
#define   VPP2_DNLP_CTRL_01                        (0x1982)
#define P_VPP2_DNLP_CTRL_01                        (volatile uint32_t *)((0x1982  << 2) + 0xff900000)
//Bit 31:24     bottom of region11 output value
//Bit 23:16     bottom of region10 output value
//Bit 15:8      bottom of region09 output value
//Bit 7:0       bottom of region08 output value
#define   VPP2_DNLP_CTRL_02                        (0x1983)
#define P_VPP2_DNLP_CTRL_02                        (volatile uint32_t *)((0x1983  << 2) + 0xff900000)
//Bit 31:24     bottom of region15 output value
//Bit 23:16     bottom of region14 output value
//Bit 15:8      bottom of region13 output value
//Bit 7:0       bottom of region12 output value
#define   VPP2_DNLP_CTRL_03                        (0x1984)
#define P_VPP2_DNLP_CTRL_03                        (volatile uint32_t *)((0x1984  << 2) + 0xff900000)
//Bit 31:24     bottom of region19 output value
//Bit 23:16     bottom of region18 output value
//Bit 15:8      bottom of region17 output value
//Bit 7:0       bottom of region16 output value
#define   VPP2_DNLP_CTRL_04                        (0x1985)
#define P_VPP2_DNLP_CTRL_04                        (volatile uint32_t *)((0x1985  << 2) + 0xff900000)
//Bit 31:24     bottom of region23 output value
//Bit 23:16     bottom of region22 output value
//Bit 15:8      bottom of region21 output value
//Bit 7:0       bottom of region20 output value
#define   VPP2_DNLP_CTRL_05                        (0x1986)
#define P_VPP2_DNLP_CTRL_05                        (volatile uint32_t *)((0x1986  << 2) + 0xff900000)
//Bit 31:24     bottom of region27 output value
//Bit 23:16     bottom of region26 output value
//Bit 15:8      bottom of region25 output value
//Bit 7:0       bottom of region24 output value
#define   VPP2_DNLP_CTRL_06                        (0x1987)
#define P_VPP2_DNLP_CTRL_06                        (volatile uint32_t *)((0x1987  << 2) + 0xff900000)
//Bit 31:24     bottom of region31 output value
//Bit 23:16     bottom of region30 output value
//Bit 15:8      bottom of region29 output value
//Bit 7:0       bottom of region28 output value
#define   VPP2_DNLP_CTRL_07                        (0x1988)
#define P_VPP2_DNLP_CTRL_07                        (volatile uint32_t *)((0x1988  << 2) + 0xff900000)
//Bit 31:24     bottom of region35 output value
//Bit 23:16     bottom of region34 output value
//Bit 15:8      bottom of region33 output value
//Bit 7:0       bottom of region32 output value
#define   VPP2_DNLP_CTRL_08                        (0x1989)
#define P_VPP2_DNLP_CTRL_08                        (volatile uint32_t *)((0x1989  << 2) + 0xff900000)
//Bit 31:24     bottom of region39 output value
//Bit 23:16     bottom of region38 output value
//Bit 15:8      bottom of region37 output value
//Bit 7:0       bottom of region36 output value
#define   VPP2_DNLP_CTRL_09                        (0x198a)
#define P_VPP2_DNLP_CTRL_09                        (volatile uint32_t *)((0x198a  << 2) + 0xff900000)
//Bit 31:24     bottom of region43 output value
//Bit 23:16     bottom of region42 output value
//Bit 15:8      bottom of region41 output value
//Bit 7:0       bottom of region40 output value
#define   VPP2_DNLP_CTRL_10                        (0x198b)
#define P_VPP2_DNLP_CTRL_10                        (volatile uint32_t *)((0x198b  << 2) + 0xff900000)
//Bit 31:24     bottom of region47 output value
//Bit 23:16     bottom of region46 output value
//Bit 15:8      bottom of region45 output value
//Bit 7:0       bottom of region44 output value
#define   VPP2_DNLP_CTRL_11                        (0x198c)
#define P_VPP2_DNLP_CTRL_11                        (volatile uint32_t *)((0x198c  << 2) + 0xff900000)
//Bit 31:24     bottom of region51 output value
//Bit 23:16     bottom of region50 output value
//Bit 15:8      bottom of region49 output value
//Bit 7:0       bottom of region48 output value
#define   VPP2_DNLP_CTRL_12                        (0x198d)
#define P_VPP2_DNLP_CTRL_12                        (volatile uint32_t *)((0x198d  << 2) + 0xff900000)
//Bit 31:24     bottom of region55 output value
//Bit 23:16     bottom of region54 output value
//Bit 15:8      bottom of region53 output value
//Bit 7:0       bottom of region52 output value
#define   VPP2_DNLP_CTRL_13                        (0x198e)
#define P_VPP2_DNLP_CTRL_13                        (volatile uint32_t *)((0x198e  << 2) + 0xff900000)
//Bit 31:24     bottom of region59 output value
//Bit 23:16     bottom of region58 output value
//Bit 15:8      bottom of region57 output value
//Bit 7:0       bottom of region56 output value
#define   VPP2_DNLP_CTRL_14                        (0x198f)
#define P_VPP2_DNLP_CTRL_14                        (volatile uint32_t *)((0x198f  << 2) + 0xff900000)
//Bit 31:24     bottom of region63 output value
//Bit 23:16     bottom of region62 output value
//Bit 15:8      bottom of region61 output value
//Bit 7:0       bottom of region60 output value
#define   VPP2_DNLP_CTRL_15                        (0x1990)
#define P_VPP2_DNLP_CTRL_15                        (volatile uint32_t *)((0x1990  << 2) + 0xff900000)
//Bit 20 reserved
//Bit 19 reserved
//Bit 18 demo dynamic nonlinear luma processing enable
//Bit 17 reserved
//Bit 16 reserved
//Bit 15:14, 2'b00: demo adjust on top, 2'b01: demo adjust on bottom, 2'b10: demo adjust on left, 2'b11: demo adjust on right
//Bit 4 reserved
//Bit 3 reserved
//Bit 2 dynamic nonlinear luma processing enable
//Bit 1 reserved
//Bit 0 reserved
#define   VPP2_VE_ENABLE_CTRL                      (0x19a1)
#define P_VPP2_VE_ENABLE_CTRL                      (volatile uint32_t *)((0x19a1  << 2) + 0xff900000)
//Bit 12:0, demo left or top screen width
#define   VPP2_VE_DEMO_LEFT_TOP_SCREEN_WIDTH       (0x19a2)
#define P_VPP2_VE_DEMO_LEFT_TOP_SCREEN_WIDTH       (volatile uint32_t *)((0x19a2  << 2) + 0xff900000)
#define   VPP2_VE_DEMO_CENTER_BAR                  (0x19a3)
#define P_VPP2_VE_DEMO_CENTER_BAR                  (volatile uint32_t *)((0x19a3  << 2) + 0xff900000)
//28:16  ve_line_length
//12:0   ve_pic_height
#define   VPP2_VE_H_V_SIZE                         (0x19a4)
#define P_VPP2_VE_H_V_SIZE                         (volatile uint32_t *)((0x19a4  << 2) + 0xff900000)
//Bit 10   reset bit, high active
//Bit 9    0: measuring rising edge, 1: measuring falling edge
//Bit 8    if true, accumulate the counter number, otherwise not
//Bit 7:0  vsync_span, define how many vsync span need to measure
#define   VPP2_VDO_MEAS_CTRL                       (0x19a8)
#define P_VPP2_VDO_MEAS_CTRL                       (volatile uint32_t *)((0x19a8  << 2) + 0xff900000)
//Read only
//19:16  ind_meas_count_n, every number of sync_span vsyncs, this counter add 1
//15:0, high bit portion of counter
#define   VPP2_VDO_MEAS_VS_COUNT_HI                (0x19a9)
#define P_VPP2_VDO_MEAS_VS_COUNT_HI                (volatile uint32_t *)((0x19a9  << 2) + 0xff900000)
//Read only
//31:0, low bit portion of counter
#define   VPP2_VDO_MEAS_VS_COUNT_LO                (0x19aa)
#define P_VPP2_VDO_MEAS_VS_COUNT_LO                (volatile uint32_t *)((0x19aa  << 2) + 0xff900000)
//vertical scaler phase step
//Bit 27:0,  4.24 format
#define   VPP2_OSD_VSC_PHASE_STEP                  (0x19c0)
#define P_VPP2_OSD_VSC_PHASE_STEP                  (volatile uint32_t *)((0x19c0  << 2) + 0xff900000)
//Bit 31:16, bottom vertical scaler initial phase
//Bit 15:0, top vertical scaler initial phase
#define   VPP2_OSD_VSC_INI_PHASE                   (0x19c1)
#define P_VPP2_OSD_VSC_INI_PHASE                   (volatile uint32_t *)((0x19c1  << 2) + 0xff900000)
//Bit 24    osd vertical Scaler enable
//Bit 23    osd_prog_interlace 0: current field is progressive, 1: current field is interlace
//Bit 22:21 osd_vsc_double_line_mode, bit1, double input width and half input height, bit0, change line buffer becomes 2 lines
//Bit 20    osd_vsc_phase0_always_en
//Bit 19    osd_vsc_nearest_en
//Bit 17:16 osd_vsc_bot_rpt_l0_num
//Bit 14:11 osd_vsc_bot_ini_rcv_num
//Bit 9:8   osd_vsc_top_rpt_l0_num
//Bit 6:3   osd_vsc_top_ini_rcv_num
//Bit 2:0   osd_vsc_bank_length
#define   VPP2_OSD_VSC_CTRL0                       (0x19c2)
#define P_VPP2_OSD_VSC_CTRL0                       (volatile uint32_t *)((0x19c2  << 2) + 0xff900000)
//horizontal scaler phase step
//Bit 27:0,  4.24 format
#define   VPP2_OSD_HSC_PHASE_STEP                  (0x19c3)
#define P_VPP2_OSD_HSC_PHASE_STEP                  (volatile uint32_t *)((0x19c3  << 2) + 0xff900000)
//Bit 31:16, horizontal scaler initial phase1
//Bit 15:0, horizontal scaler initial phase0
#define   VPP2_OSD_HSC_INI_PHASE                   (0x19c4)
#define P_VPP2_OSD_HSC_INI_PHASE                   (volatile uint32_t *)((0x19c4  << 2) + 0xff900000)
//Bit 22   osd horizontal scaler enable
//Bit 21   osd_hsc_double_pix_mode
//Bit 20   osd_hsc_phase0_always_en
//Bit 19   osd_hsc_nearest_en
//Bit 17:16 osd_hsc_rpt_p0_num1
//Bit 14:11 osd_hsc_ini_rcv_num1
//Bit 9:8   osd_hsc_rpt_p0_num0
//Bit 6:3   osd_hsc_ini_rcv_num0
//Bit 2:0   osd_hsc_bank_length
#define   VPP2_OSD_HSC_CTRL0                       (0x19c5)
#define P_VPP2_OSD_HSC_CTRL0                       (volatile uint32_t *)((0x19c5  << 2) + 0xff900000)
//for 3D quincunx sub-sampling
//bit 15:8 pattern, each patten 1 bit, from lsb -> msb
//bit 6:4  pattern start
//bit 2:0  pattern end
#define   VPP2_OSD_HSC_INI_PAT_CTRL                (0x19c6)
#define P_VPP2_OSD_HSC_INI_PAT_CTRL                (volatile uint32_t *)((0x19c6  << 2) + 0xff900000)
//bit 31:24, componet 0
//bit 23:16, component 1
//bit 15:8, component 2
//bit 7:0 component 3, alpha
#define   VPP2_OSD_SC_DUMMY_DATA                   (0x19c7)
#define P_VPP2_OSD_SC_DUMMY_DATA                   (volatile uint32_t *)((0x19c7  << 2) + 0xff900000)
//Bit 14 osc_sc_din_osd1_alpha_mode, 1: (alpha >= 128) ? alpha -1: alpha,  0: (alpha >=1) ? alpha - 1: alpha.
//Bit 13 osc_sc_din_osd2_alpha_mode, 1: (alpha >= 128) ? alpha -1: alpha,  0: (alpha >=1) ? alpha - 1: alpha.
//Bit 12 osc_sc_dout_alpha_mode, 1: (alpha >= 128) ? alpha + 1: alpha, 0: (alpha >=1) ? alpha + 1: alpha.
//Bit 12 osc_sc_alpha_mode, 1: (alpha >= 128) ? alpha + 1: alpha, 0: (alpha >=1) ? alpha + 1: alpha.
//Bit 11:4 default alpha for vd1 or vd2 if they are selected as the source
//Bit 3 osd scaler path enable
//Bit 1:0 osd_sc_sel, 00: select osd1 input, 01: select osd2 input, 10: select vd1 input, 11: select vd2 input after matrix
#define   VPP2_OSD_SC_CTRL0                        (0x19c8)
#define P_VPP2_OSD_SC_CTRL0                        (volatile uint32_t *)((0x19c8  << 2) + 0xff900000)
//Bit 28:16 OSD scaler input width minus 1
//Bit 12:0 OSD scaler input height minus 1
#define   VPP2_OSD_SCI_WH_M1                       (0x19c9)
#define P_VPP2_OSD_SCI_WH_M1                       (volatile uint32_t *)((0x19c9  << 2) + 0xff900000)
//Bit 28:16 OSD scaler output horizontal start
//Bit 12:0 OSD scaler output horizontal end
#define   VPP2_OSD_SCO_H_START_END                 (0x19ca)
#define P_VPP2_OSD_SCO_H_START_END                 (volatile uint32_t *)((0x19ca  << 2) + 0xff900000)
//Bit 28:16 OSD scaler output vertical start
//Bit 12:0 OSD scaler output vertical end
#define   VPP2_OSD_SCO_V_START_END                 (0x19cb)
#define P_VPP2_OSD_SCO_V_START_END                 (volatile uint32_t *)((0x19cb  << 2) + 0xff900000)
//Because there are many coefficients used in the vertical filter and horizontal filters,
//indirect access the coefficients of vertical filter and horizontal filter is used.
//For vertical filter, there are 33x4 coefficients
//For horizontal filter, there are 33x4 coefficients
//Bit 15    index increment, if bit9 == 1  then (0: index increase 1, 1: index increase 2) else (index increase 2)
//Bit 14    1: read coef through cbus enable, just for debug purpose in case when we wanna check the coef in ram in correct or not
//Bit 9     if true, use 9bit resolution coef, other use 8bit resolution coef
//Bit 8   type of index, 0: vertical coef,  1: horizontal coef
//Bit 6:0   coef index
#define   VPP2_OSD_SCALE_COEF_IDX                  (0x19cc)
#define P_VPP2_OSD_SCALE_COEF_IDX                  (volatile uint32_t *)((0x19cc  << 2) + 0xff900000)
//coefficients for vertical filter and horizontal filter
#define   VPP2_OSD_SCALE_COEF                      (0x19cd)
#define P_VPP2_OSD_SCALE_COEF                      (volatile uint32_t *)((0x19cd  << 2) + 0xff900000)
//Bit 12:0 line number use to generate interrupt when line == this number
#define   VPP2_INT_LINE_NUM                        (0x19ce)
#define P_VPP2_INT_LINE_NUM                        (volatile uint32_t *)((0x19ce  << 2) + 0xff900000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpp2_regs.h
//
//`define VIU_VCBUS_BASE                8'h1a
//
// Reading file:  vregs_clk2.h
//
//===========================================================================
// Video Interface Registers    0xa00 - 0xaff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VIU_VCBUS_BASE = 0x1a
// -----------------------------------------------
#define   VIU_ADDR_START                           (0x1a00)
#define P_VIU_ADDR_START                           (volatile uint32_t *)((0x1a00  << 2) + 0xff900000)
#define   VIU_ADDR_END                             (0x1aff)
#define P_VIU_ADDR_END                             (volatile uint32_t *)((0x1aff  << 2) + 0xff900000)
//`define TRACE_REG 8'ff
//------------------------------------------------------------------------------
// VIU top-level registers
//------------------------------------------------------------------------------
// Bit  0 RW, osd1_reset
// Bit  1 RW, osd2_reset
// Bit  2 RW, vd1_reset
// Bit  3 RW, vd1_fmt_reset
// Bit  4 RW, vd2_reset
// Bit  5 RW, vd2_fmt_reset
// Bit  6 RW, di_dsr1to2_reset
// Bit  7 RW, vpp_reset
// Bit  8 RW, di_if1_reset
// Bit  9 RW, di_if1_fmt_reset
// Bit 10 RW, di_inp_reset
// Bit 11 RW, di_inp_fmt_reset
// Bit 12 RW, di_mem_reset
// Bit 13 RW, di_mem_fmt_reset
// Bit 14 RW, di_nr_wr_mif_reset
// Bit 15 RW, dein_wr_mif_reset
// Bit 16 RW, di_chan2_mif_reset
// Bit 17 RW, di_mtn_wr_mif_reset
// Bit 18 RW, di_mtn_rd_mif_reset
// Bit 19 RW, di_mad_reset
// Bit 20 RW, vdin0_reset
// Bit 21 RW, vdin1_reset
// Bit 22 RW, nrin_mux_reset
// Bit 23 RW, vdin0_wr_reset
// Bit 24 RW, vdin1_wr_reset
// Bit 25 RW, reserved
// Bit 26 RW, d2d3_reset
// Bit 27 RW, di_cont_wr_mif_reset
// Bit 28 RW, di_cont_rd_mif_reset
#define   VIU_SW_RESET                             (0x1a01)
#define P_VIU_SW_RESET                             (volatile uint32_t *)((0x1a01  << 2) + 0xff900000)
#define   VIU_SW_RESET0                            (0x1a02)
#define P_VIU_SW_RESET0                            (volatile uint32_t *)((0x1a02  << 2) + 0xff900000)
// Bit 0 RW, software reset for mcvecrd_mif
// Bit 1 RW, software reset for mcinfowr_mif
// Bit 2 RW, software reset for mcinford_mif
#define   VIU_SECURE_REG                           (0x1a04)
#define P_VIU_SECURE_REG                           (volatile uint32_t *)((0x1a04  << 2) + 0xff900000)
// Bit 0 RW, dolby core1_tv secure w and r
// Bit 1 RW, dolby core2 secure w and r
// Bit 2 RW, dolby core3 secure w and r
// Bit 3 RW, for osd1 secure read
// Bit 4 RW, for osd2 secure read
#define   DOLBY_INT_STAT                           (0x1a05)
#define P_DOLBY_INT_STAT                           (volatile uint32_t *)((0x1a05  << 2) + 0xff900000)
// todo
//bit 15:12 osdbld_gclk_ctrl 3:2 regclk ctrl 1:0 blending clk control
//bit 8 if true, vsync interrup is generate only field == 0
//bit 7:0 fix_disable
#define   VIU_MISC_CTRL0                           (0x1a06)
#define P_VIU_MISC_CTRL0                           (volatile uint32_t *)((0x1a06  << 2) + 0xff900000)
#define   VIU_MISC_CTRL1                           (0x1a07)
#define P_VIU_MISC_CTRL1                           (volatile uint32_t *)((0x1a07  << 2) + 0xff900000)
// Bit 15:14  mali_afbcd_gclk_ctrl      mali_afbcd clock gate control[5:4]
// Bit 12     osd1_afbcd_axi_mux        0 : use the osd mif as input; 1 : use afbcd as input
// Bit 11:8   mali_afbcd_gclk_ctrl      mali_afbcd clock gate control[3:0]
// Bit  7:2   vd2_afbcd_gclk_ctrl       vd2_afbcd clock gate control
// Bit  1     vpp_vd2_din_sel           0: vpp vd2 sel the mif input; 1: vpp vd2 sel the dos afbcd
// Bit  0     vd2_afbcd_out_sel         0: vd2_afbcd output to vpp; 1 : vd2_afbcd output to di inp
#define   D2D3_INTF_LENGTH                         (0x1a08)
#define P_D2D3_INTF_LENGTH                         (volatile uint32_t *)((0x1a08  << 2) + 0xff900000)
// Bit 31:30 vdin0 dout splitter, bit 0 turns on vdin0 to old path, bit 1 turns on vdin0 to d2d3_intf vdin0 input path
// Bit 29:28 vdin1 dout splitter, bit 0 turns on vdin1 to old path, bit 1 turns on vdin1 to d2d3_intf vdin1 input path
// Bit 27:26 NR write dout splitter, bit 0 turns on NR write to old path, bit 1 turns on NR WR to d2d3_intf NR WR input path
// Bit 23 if true, turn on clk_d2d3_reg (register clock)
// Bit 22 if true, turn on clk_d2d3
// Bit 21 reg_v1_go_line
// Bit 20 reg_v1_go_field
// Bit 19 reg_v0_go_field
// Bit 18:16 v1_gofld_sel, 000: display go_field/go_line, 001: DI pre_frame_rst/go_line, 010: vdin0 go_field/go_line,
//011: vdin1 go_field/go_line, otherwise: force go_field by reg_v1_go_field(bit20), force go_line by reg_v1_go_line(bit21)
// Bit 15:13 v0_gofld_sel, 000: display go_field, 001: DI pre_frame_rst, 010: vdin0 go_field, 011: vdin1 go_field, otherwise: force go_field by
// reg_v0_go_field(bit19)
// Bit 12:6 hole_lines for d2d3 depth read interface
// Bit 5:4 d2d3_v1_sel, 2'b01: video display read interface(DI or vd1 format output), 2'b10: scale output, otherwise nothing as v1
// Bit 3 use_vdin_eol, if true, use vdin eol as the v0_eol, otherwise using length to get the v0_eol
// Bit 2:0  d2d3_v0_sel  001: vdin0, 010: vdin1, 011: NRW, 100: video display read interface(DI or vd1 format output), 101: vpp scale output
//
#define   D2D3_INTF_CTRL0                          (0x1a09)
#define P_D2D3_INTF_CTRL0                          (volatile uint32_t *)((0x1a09  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// OSD1 registers
//------------------------------------------------------------------------------
// Bit    31 Reserved
// Bit    30 RW, enable_free_clk: 1=use free-running clock to drive logic;
//                                0=use gated clock for low power.
// Bit    29 R, test_rd_dsr
// Bit    28 R, osd_done
// Bit 27:24 R, osd_blk_mode
// Bit 23:22 R, osd_blk_ptr
// Bit    21 R, osd_enable
//
// Bit 20:12 RW, global_alpha
// Bit    11 RW, test_rd_en
// Bit 10: 9 Reserved for control signals
// Bit  8: 5 RW, ctrl_mtch_y
// Bit     4 RW, ctrl_422to444
// Bit  3: 0 RW, osd_blk_enable. Bit 0 to enable block 0: 1=enable, 0=disable;
//                               Bit 1 to enable block 1, and so on.
#define   VIU_OSD1_CTRL_STAT                       (0x1a10)
#define P_VIU_OSD1_CTRL_STAT                       (volatile uint32_t *)((0x1a10  << 2) + 0xff900000)
// Bit 31:26 Reserved
// Bit 25:16 R, fifo_count
// Bit 15    RW, osd_dpath_sel   0-osd1 mif 1-vpu mali afbcd
// Bit 14    RW, replaced_alpha_en
// Bit 13: 6 RW, replaced_alpha
// Bit  5: 4 RW, hold_fifo_lines[6:5]
// Bit     3 RW, rgb2yuv_full_range
// Bit     2 RW, alpha_9b_mode
// Bit     1 RW, reserved
// Bit     0 RW, color_expand_mode
#define   VIU_OSD1_CTRL_STAT2                      (0x1a2d)
#define P_VIU_OSD1_CTRL_STAT2                      (volatile uint32_t *)((0x1a2d  << 2) + 0xff900000)
// Bit 31: 9 Reserved
// Bit     8 RW, 0 = Write LUT, 1 = Read LUT
// Bit  7: 0 RW, lut_addr
#define   VIU_OSD1_COLOR_ADDR                      (0x1a11)
#define P_VIU_OSD1_COLOR_ADDR                      (volatile uint32_t *)((0x1a11  << 2) + 0xff900000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define   VIU_OSD1_COLOR                           (0x1a12)
#define P_VIU_OSD1_COLOR                           (volatile uint32_t *)((0x1a12  << 2) + 0xff900000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define   VIU_OSD1_TCOLOR_AG0                      (0x1a17)
#define P_VIU_OSD1_TCOLOR_AG0                      (volatile uint32_t *)((0x1a17  << 2) + 0xff900000)
#define   VIU_OSD1_TCOLOR_AG1                      (0x1a18)
#define P_VIU_OSD1_TCOLOR_AG1                      (volatile uint32_t *)((0x1a18  << 2) + 0xff900000)
#define   VIU_OSD1_TCOLOR_AG2                      (0x1a19)
#define P_VIU_OSD1_TCOLOR_AG2                      (volatile uint32_t *)((0x1a19  << 2) + 0xff900000)
#define   VIU_OSD1_TCOLOR_AG3                      (0x1a1a)
#define P_VIU_OSD1_TCOLOR_AG3                      (volatile uint32_t *)((0x1a1a  << 2) + 0xff900000)
// Bit 31:30 Reserved
// Bit    29 RW, y_rev: 0=normal read, 1=reverse read in Y direction
// Bit    28 RW, x_rev: 0=normal read, 1=reverse read in X direction
// Bit 27:24 Reserved
// Bit 23:16 RW, tbl_addr
// Bit    15 RW, little_endian: 0=big endian, 1=little endian
// Bit    14 RW, rpt_y
// Bit 13:12 RW, interp_ctrl. 0x=No interpolation; 10=Interpolate with previous
//                            pixel; 11=Interpolate with the average value
//                            between previous and next pixel.
// Bit 11: 8 RW, osd_blk_mode
// Bit     7 RW, rgb_en
// Bit     6 RW, tc_alpha_en
// Bit  5: 2 RW, color_matrix
// Bit     1 RW, interlace_en
// Bit     0 RW, interlace_sel_odd
#define   VIU_OSD1_BLK0_CFG_W0                     (0x1a1b)
#define P_VIU_OSD1_BLK0_CFG_W0                     (volatile uint32_t *)((0x1a1b  << 2) + 0xff900000)
#define   VIU_OSD1_BLK1_CFG_W0                     (0x1a1f)
#define P_VIU_OSD1_BLK1_CFG_W0                     (volatile uint32_t *)((0x1a1f  << 2) + 0xff900000)
#define   VIU_OSD1_BLK2_CFG_W0                     (0x1a23)
#define P_VIU_OSD1_BLK2_CFG_W0                     (volatile uint32_t *)((0x1a23  << 2) + 0xff900000)
#define   VIU_OSD1_BLK3_CFG_W0                     (0x1a27)
#define P_VIU_OSD1_BLK3_CFG_W0                     (volatile uint32_t *)((0x1a27  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, x_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, x_start
#define   VIU_OSD1_BLK0_CFG_W1                     (0x1a1c)
#define P_VIU_OSD1_BLK0_CFG_W1                     (volatile uint32_t *)((0x1a1c  << 2) + 0xff900000)
#define   VIU_OSD1_BLK1_CFG_W1                     (0x1a20)
#define P_VIU_OSD1_BLK1_CFG_W1                     (volatile uint32_t *)((0x1a20  << 2) + 0xff900000)
#define   VIU_OSD1_BLK2_CFG_W1                     (0x1a24)
#define P_VIU_OSD1_BLK2_CFG_W1                     (volatile uint32_t *)((0x1a24  << 2) + 0xff900000)
#define   VIU_OSD1_BLK3_CFG_W1                     (0x1a28)
#define P_VIU_OSD1_BLK3_CFG_W1                     (volatile uint32_t *)((0x1a28  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, y_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, y_start
#define   VIU_OSD1_BLK0_CFG_W2                     (0x1a1d)
#define P_VIU_OSD1_BLK0_CFG_W2                     (volatile uint32_t *)((0x1a1d  << 2) + 0xff900000)
#define   VIU_OSD1_BLK1_CFG_W2                     (0x1a21)
#define P_VIU_OSD1_BLK1_CFG_W2                     (volatile uint32_t *)((0x1a21  << 2) + 0xff900000)
#define   VIU_OSD1_BLK2_CFG_W2                     (0x1a25)
#define P_VIU_OSD1_BLK2_CFG_W2                     (volatile uint32_t *)((0x1a25  << 2) + 0xff900000)
#define   VIU_OSD1_BLK3_CFG_W2                     (0x1a29)
#define P_VIU_OSD1_BLK3_CFG_W2                     (volatile uint32_t *)((0x1a29  << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, h_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, h_start
#define   VIU_OSD1_BLK0_CFG_W3                     (0x1a1e)
#define P_VIU_OSD1_BLK0_CFG_W3                     (volatile uint32_t *)((0x1a1e  << 2) + 0xff900000)
#define   VIU_OSD1_BLK1_CFG_W3                     (0x1a22)
#define P_VIU_OSD1_BLK1_CFG_W3                     (volatile uint32_t *)((0x1a22  << 2) + 0xff900000)
#define   VIU_OSD1_BLK2_CFG_W3                     (0x1a26)
#define P_VIU_OSD1_BLK2_CFG_W3                     (volatile uint32_t *)((0x1a26  << 2) + 0xff900000)
#define   VIU_OSD1_BLK3_CFG_W3                     (0x1a2a)
#define P_VIU_OSD1_BLK3_CFG_W3                     (volatile uint32_t *)((0x1a2a  << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, v_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, v_start
#define   VIU_OSD1_BLK0_CFG_W4                     (0x1a13)
#define P_VIU_OSD1_BLK0_CFG_W4                     (volatile uint32_t *)((0x1a13  << 2) + 0xff900000)
#define   VIU_OSD1_BLK1_CFG_W4                     (0x1a14)
#define P_VIU_OSD1_BLK1_CFG_W4                     (volatile uint32_t *)((0x1a14  << 2) + 0xff900000)
#define   VIU_OSD1_BLK2_CFG_W4                     (0x1a15)
#define P_VIU_OSD1_BLK2_CFG_W4                     (volatile uint32_t *)((0x1a15  << 2) + 0xff900000)
#define   VIU_OSD1_BLK3_CFG_W4                     (0x1a16)
#define P_VIU_OSD1_BLK3_CFG_W4                     (volatile uint32_t *)((0x1a16  << 2) + 0xff900000)
// Bit    31 RW, burst_len_sel[2] of [2:0]
// Bit    30 RW, byte_swap: In addition to endian control, further define
//               whether to swap upper and lower byte within a 16-bit mem word.
//               0=No swap; 1=Swap data[15:0] to be {data[7:0], data[15:8]}
// Bit    29 RW, div_swap : swap the 2 64bits words in 128 bit word
// Bit 28:24 RW, fifo_lim : when osd fifo is small than the fifo_lim*16, closed the rq port of osd_rd_mif
// Bit 23:22 RW, fifo_ctrl: 00 : for 1 word in 1 burst , 01 : for  2words in 1burst, 10: for 4words in 1burst, 11: reserved
// Bit 21:20 R,  fifo_st. 0=IDLE, 1=FILL, 2=ABORT
// Bit    19 R,  fifo_overflow
// Bit 18:12 RW, fifo_depth_val, max value=64: set actual fifo depth to fifo_depth_val*8.
// Bit 11:10 RW, burst_len_sel[1:0] of [2:0]. 0=24(default), 1=32, 2=48, 3=64, 4=96, 5=128.
// Bit  9: 5 RW, hold_fifo_lines[4:0]
// Bit     4 RW, clear_err: one pulse to clear fifo_overflow
// Bit     3 RW, fifo_sync_rst
// Bit  2: 1 RW, endian
// Bit     0 RW, urgent
#define   VIU_OSD1_FIFO_CTRL_STAT                  (0x1a2b)
#define P_VIU_OSD1_FIFO_CTRL_STAT                  (volatile uint32_t *)((0x1a2b  << 2) + 0xff900000)
// Bit 31:24 R, Y or R
// Bit 23:16 R, Cb or G
// Bit 15: 8 R, Cr or B
// Bit  7: 0 R, Output Alpha[8:1]
#define   VIU_OSD1_TEST_RDDATA                     (0x1a2c)
#define P_VIU_OSD1_TEST_RDDATA                     (volatile uint32_t *)((0x1a2c  << 2) + 0xff900000)
// Bit    15 RW, prot_en: 1=Borrow PROT's FIFO storage, either for rotate or non-rotate.
// Bit 12: 0 RW, effective FIFO size when prot_en=1.
#define   VIU_OSD1_PROT_CTRL                       (0x1a2e)
#define P_VIU_OSD1_PROT_CTRL                       (volatile uint32_t *)((0x1a2e  << 2) + 0xff900000)
//Bit 7,  highlight_en
//Bit 6   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before matrix
//Bit 5:4  probe_sel, 00: select matrix 0, 01: select matrix 1,  otherwise select nothing
//Bit 3:2, matrix coef idx selection, 00: select mat0, 01: select mat1, otherwise slect nothing
//Bit 1   mat1 conversion matrix enable
//Bit 0   mat0 conversion matrix enable
#define   VIU_OSD1_MATRIX_CTRL                     (0x1a90)
#define P_VIU_OSD1_MATRIX_CTRL                     (volatile uint32_t *)((0x1a90  << 2) + 0xff900000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define   VIU_OSD1_MATRIX_COEF00_01                (0x1a91)
#define P_VIU_OSD1_MATRIX_COEF00_01                (volatile uint32_t *)((0x1a91  << 2) + 0xff900000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define   VIU_OSD1_MATRIX_COEF02_10                (0x1a92)
#define P_VIU_OSD1_MATRIX_COEF02_10                (volatile uint32_t *)((0x1a92  << 2) + 0xff900000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define   VIU_OSD1_MATRIX_COEF11_12                (0x1a93)
#define P_VIU_OSD1_MATRIX_COEF11_12                (volatile uint32_t *)((0x1a93  << 2) + 0xff900000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define   VIU_OSD1_MATRIX_COEF20_21                (0x1a94)
#define P_VIU_OSD1_MATRIX_COEF20_21                (volatile uint32_t *)((0x1a94  << 2) + 0xff900000)
//Bit 31:30    mat_clmod
//Bit 18:16    mat_convrs
//Bit 12:0     mat_coef42
#define   VIU_OSD1_MATRIX_COLMOD_COEF42            (0x1a95)
#define P_VIU_OSD1_MATRIX_COLMOD_COEF42            (volatile uint32_t *)((0x1a95  << 2) + 0xff900000)
//Bit 26:16 offset0
//Bit 10:0  offset1
#define   VIU_OSD1_MATRIX_OFFSET0_1                (0x1a96)
#define P_VIU_OSD1_MATRIX_OFFSET0_1                (volatile uint32_t *)((0x1a96  << 2) + 0xff900000)
//Bit 10:0  offset2
#define   VIU_OSD1_MATRIX_OFFSET2                  (0x1a97)
#define P_VIU_OSD1_MATRIX_OFFSET2                  (volatile uint32_t *)((0x1a97  << 2) + 0xff900000)
//Bit 26:16 pre_offset0
//Bit 10:0  pre_offset1
#define   VIU_OSD1_MATRIX_PRE_OFFSET0_1            (0x1a98)
#define P_VIU_OSD1_MATRIX_PRE_OFFSET0_1            (volatile uint32_t *)((0x1a98  << 2) + 0xff900000)
//Bit 10:0  pre_offset2
#define   VIU_OSD1_MATRIX_PRE_OFFSET2              (0x1a99)
#define P_VIU_OSD1_MATRIX_PRE_OFFSET2              (volatile uint32_t *)((0x1a99  << 2) + 0xff900000)
//Read only
//Bit 29:20 component 0
//Bit 19:10 component 1
//Bit 9:0 component 2
#define   VIU_OSD1_MATRIX_PROBE_COLOR              (0x1a9a)
#define P_VIU_OSD1_MATRIX_PROBE_COLOR              (volatile uint32_t *)((0x1a9a  << 2) + 0xff900000)
//Bit 23:16 component 0
//Bit 15:8  component 1
//Bit 7:0 component 2
#define   VIU_OSD1_MATRIX_HL_COLOR                 (0x1a9b)
#define P_VIU_OSD1_MATRIX_HL_COLOR                 (volatile uint32_t *)((0x1a9b  << 2) + 0xff900000)
//28:16 probe x, postion
//12:0  probe y, position
#define   VIU_OSD1_MATRIX_PROBE_POS                (0x1a9c)
#define P_VIU_OSD1_MATRIX_PROBE_POS                (volatile uint32_t *)((0x1a9c  << 2) + 0xff900000)
//Bit 28:16 coef22
//Bit 12:0  coef30
#define   VIU_OSD1_MATRIX_COEF22_30                (0x1a9d)
#define P_VIU_OSD1_MATRIX_COEF22_30                (volatile uint32_t *)((0x1a9d  << 2) + 0xff900000)
//Bit 28:16 coef31
//Bit 12:0  coef32
#define   VIU_OSD1_MATRIX_COEF31_32                (0x1a9e)
#define P_VIU_OSD1_MATRIX_COEF31_32                (volatile uint32_t *)((0x1a9e  << 2) + 0xff900000)
//Bit 28:16 coef40
//Bit 12:0  coef41
#define   VIU_OSD1_MATRIX_COEF40_41                (0x1a9f)
#define P_VIU_OSD1_MATRIX_COEF40_41                (volatile uint32_t *)((0x1a9f  << 2) + 0xff900000)
//Bit 31:27 for all [31] for all eotf enable,[30] for matrix3x3 enable, [29:27] for eotf_ch0~3
//Bit 17:6  for clock gating
//Bit 5:4   pscale_mode ch2
//Bit 3:2   pscale_mode ch1
//Bit 1:0   pscale_mode ch0
#define   VIU_OSD1_EOTF_CTL                        (0x1ad4)
#define P_VIU_OSD1_EOTF_CTL                        (volatile uint32_t *)((0x1ad4  << 2) + 0xff900000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define   VIU_OSD1_EOTF_COEF00_01                  (0x1ad5)
#define P_VIU_OSD1_EOTF_COEF00_01                  (volatile uint32_t *)((0x1ad5  << 2) + 0xff900000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define   VIU_OSD1_EOTF_COEF02_10                  (0x1ad6)
#define P_VIU_OSD1_EOTF_COEF02_10                  (volatile uint32_t *)((0x1ad6  << 2) + 0xff900000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define   VIU_OSD1_EOTF_COEF11_12                  (0x1ad7)
#define P_VIU_OSD1_EOTF_COEF11_12                  (volatile uint32_t *)((0x1ad7  << 2) + 0xff900000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define   VIU_OSD1_EOTF_COEF20_21                  (0x1ad8)
#define P_VIU_OSD1_EOTF_COEF20_21                  (volatile uint32_t *)((0x1ad8  << 2) + 0xff900000)
//Bit 28:16 coef22
//Bit   2:0 coef_rs
#define   VIU_OSD1_EOTF_COEF22_RS                  (0x1ad9)
#define P_VIU_OSD1_EOTF_COEF22_RS                  (volatile uint32_t *)((0x1ad9  << 2) + 0xff900000)
#define   VIU_OSD1_EOTF_LUT_ADDR_PORT              (0x1ada)
#define P_VIU_OSD1_EOTF_LUT_ADDR_PORT              (volatile uint32_t *)((0x1ada  << 2) + 0xff900000)
#define   VIU_OSD1_EOTF_LUT_DATA_PORT              (0x1adb)
#define P_VIU_OSD1_EOTF_LUT_DATA_PORT              (volatile uint32_t *)((0x1adb  << 2) + 0xff900000)
//Bit 31:29  for OETF ch0~ch2
//Bit 21:12  for clock gating
//Bit 11:8   for oetf_scl_ch2
//Bit  7:4   for oetf_scl_ch1
//Bit  3:0   for oetf_scl_ch0
#define   VIU_OSD1_OETF_CTL                        (0x1adc)
#define P_VIU_OSD1_OETF_CTL                        (volatile uint32_t *)((0x1adc  << 2) + 0xff900000)
#define   VIU_OSD1_OETF_LUT_ADDR_PORT              (0x1add)
#define P_VIU_OSD1_OETF_LUT_ADDR_PORT              (volatile uint32_t *)((0x1add  << 2) + 0xff900000)
#define   VIU_OSD1_OETF_LUT_DATA_PORT              (0x1ade)
#define P_VIU_OSD1_OETF_LUT_DATA_PORT              (volatile uint32_t *)((0x1ade  << 2) + 0xff900000)
#define   VIU_OSD1_OETF_3X3_OFST_0                 (0x1aa0)
#define P_VIU_OSD1_OETF_3X3_OFST_0                 (volatile uint32_t *)((0x1aa0  << 2) + 0xff900000)
#define   VIU_OSD1_OETF_3X3_OFST_1                 (0x1aa1)
#define P_VIU_OSD1_OETF_3X3_OFST_1                 (volatile uint32_t *)((0x1aa1  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// OSD2 registers
//------------------------------------------------------------------------------
// Bit    31 Reserved
// Bit    30 RW, enable_free_clk: 1=use free-running clock to drive logic;
//                                0=use gated clock for low power.
// Bit    29 R, test_rd_dsr
// Bit    28 R, osd_done
// Bit 27:24 R, osd_blk_mode
// Bit 23:22 R, osd_blk_ptr
// Bit    21 R, osd_enable
//
// Bit 20:12 RW, global_alpha
// Bit    11 RW, test_rd_en
// Bit    10 RW, hl2_en
// Bit     9 RW, hl1_en
// Bit  8: 5 RW, ctrl_mtch_y
// Bit     4 RW, ctrl_422to444
// Bit  3: 0 RW, osd_blk_enable. Bit 0 to enable block 0: 1=enable, 0=disable;
//                               Bit 1 to enable block 1, and so on.
#define   VIU_OSD2_CTRL_STAT                       (0x1a30)
#define P_VIU_OSD2_CTRL_STAT                       (volatile uint32_t *)((0x1a30  << 2) + 0xff900000)
// Bit 31:26 Reserved
// Bit 25:16 R, fifo_count
// Bit 15    Reserved
// Bit 14    RW, replaced_alpha_en
// Bit 13: 6 RW, replaced_alpha
// Bit  5: 4 RW, hold_fifo_lines[6:5]
// Bit     3 RW, rgb2yuv_full_range
// Bit     2 RW, alpha_9b_mode
// Bit     1 RW, reserved
// Bit     0 RW, color_expand_mode
#define   VIU_OSD2_CTRL_STAT2                      (0x1a4d)
#define P_VIU_OSD2_CTRL_STAT2                      (volatile uint32_t *)((0x1a4d  << 2) + 0xff900000)
// Bit 31: 9 Reserved
// Bit     8 RW, 0 = Write LUT, 1 = Read LUT
// Bit  7: 0 RW, lut_addr
#define   VIU_OSD2_COLOR_ADDR                      (0x1a31)
#define P_VIU_OSD2_COLOR_ADDR                      (volatile uint32_t *)((0x1a31  << 2) + 0xff900000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define   VIU_OSD2_COLOR                           (0x1a32)
#define P_VIU_OSD2_COLOR                           (volatile uint32_t *)((0x1a32  << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, hl[1-2]_h/v_start
// Bit 15:12 Reserved
// Bit 11: 0 RW, hl[1-2]_h/v_end
#define   VIU_OSD2_HL1_H_START_END                 (0x1a33)
#define P_VIU_OSD2_HL1_H_START_END                 (volatile uint32_t *)((0x1a33  << 2) + 0xff900000)
#define   VIU_OSD2_HL1_V_START_END                 (0x1a34)
#define P_VIU_OSD2_HL1_V_START_END                 (volatile uint32_t *)((0x1a34  << 2) + 0xff900000)
#define   VIU_OSD2_HL2_H_START_END                 (0x1a35)
#define P_VIU_OSD2_HL2_H_START_END                 (volatile uint32_t *)((0x1a35  << 2) + 0xff900000)
#define   VIU_OSD2_HL2_V_START_END                 (0x1a36)
#define P_VIU_OSD2_HL2_V_START_END                 (volatile uint32_t *)((0x1a36  << 2) + 0xff900000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define   VIU_OSD2_TCOLOR_AG0                      (0x1a37)
#define P_VIU_OSD2_TCOLOR_AG0                      (volatile uint32_t *)((0x1a37  << 2) + 0xff900000)
#define   VIU_OSD2_TCOLOR_AG1                      (0x1a38)
#define P_VIU_OSD2_TCOLOR_AG1                      (volatile uint32_t *)((0x1a38  << 2) + 0xff900000)
#define   VIU_OSD2_TCOLOR_AG2                      (0x1a39)
#define P_VIU_OSD2_TCOLOR_AG2                      (volatile uint32_t *)((0x1a39  << 2) + 0xff900000)
#define   VIU_OSD2_TCOLOR_AG3                      (0x1a3a)
#define P_VIU_OSD2_TCOLOR_AG3                      (volatile uint32_t *)((0x1a3a  << 2) + 0xff900000)
// Bit 31:24 Reserved
// Bit 23:16 RW, tbl_addr
// Bit    15 RW, little_endian: 0=big endian, 1=little endian
// Bit    14 RW, rpt_y
// Bit 13:12 RW, interp_ctrl. 0x=No interpolation; 10=Interpolate with previous
//                            pixel; 11=Interpolate with the average value
//                            between previous and next pixel.
// Bit 11: 8 RW, osd_blk_mode
// Bit     7 RW, rgb_en
// Bit     6 RW, tc_alpha_en
// Bit  5: 2 RW, color_matrix
// Bit     1 RW, interlace_en
// Bit     0 RW, interlace_sel_odd
#define   VIU_OSD2_BLK0_CFG_W0                     (0x1a3b)
#define P_VIU_OSD2_BLK0_CFG_W0                     (volatile uint32_t *)((0x1a3b  << 2) + 0xff900000)
#define   VIU_OSD2_BLK1_CFG_W0                     (0x1a3f)
#define P_VIU_OSD2_BLK1_CFG_W0                     (volatile uint32_t *)((0x1a3f  << 2) + 0xff900000)
#define   VIU_OSD2_BLK2_CFG_W0                     (0x1a43)
#define P_VIU_OSD2_BLK2_CFG_W0                     (volatile uint32_t *)((0x1a43  << 2) + 0xff900000)
#define   VIU_OSD2_BLK3_CFG_W0                     (0x1a47)
#define P_VIU_OSD2_BLK3_CFG_W0                     (volatile uint32_t *)((0x1a47  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, x_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, x_start
#define   VIU_OSD2_BLK0_CFG_W1                     (0x1a3c)
#define P_VIU_OSD2_BLK0_CFG_W1                     (volatile uint32_t *)((0x1a3c  << 2) + 0xff900000)
#define   VIU_OSD2_BLK1_CFG_W1                     (0x1a40)
#define P_VIU_OSD2_BLK1_CFG_W1                     (volatile uint32_t *)((0x1a40  << 2) + 0xff900000)
#define   VIU_OSD2_BLK2_CFG_W1                     (0x1a44)
#define P_VIU_OSD2_BLK2_CFG_W1                     (volatile uint32_t *)((0x1a44  << 2) + 0xff900000)
#define   VIU_OSD2_BLK3_CFG_W1                     (0x1a48)
#define P_VIU_OSD2_BLK3_CFG_W1                     (volatile uint32_t *)((0x1a48  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, y_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, y_start
#define   VIU_OSD2_BLK0_CFG_W2                     (0x1a3d)
#define P_VIU_OSD2_BLK0_CFG_W2                     (volatile uint32_t *)((0x1a3d  << 2) + 0xff900000)
#define   VIU_OSD2_BLK1_CFG_W2                     (0x1a41)
#define P_VIU_OSD2_BLK1_CFG_W2                     (volatile uint32_t *)((0x1a41  << 2) + 0xff900000)
#define   VIU_OSD2_BLK2_CFG_W2                     (0x1a45)
#define P_VIU_OSD2_BLK2_CFG_W2                     (volatile uint32_t *)((0x1a45  << 2) + 0xff900000)
#define   VIU_OSD2_BLK3_CFG_W2                     (0x1a49)
#define P_VIU_OSD2_BLK3_CFG_W2                     (volatile uint32_t *)((0x1a49  << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, h_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, h_start
#define   VIU_OSD2_BLK0_CFG_W3                     (0x1a3e)
#define P_VIU_OSD2_BLK0_CFG_W3                     (volatile uint32_t *)((0x1a3e  << 2) + 0xff900000)
#define   VIU_OSD2_BLK1_CFG_W3                     (0x1a42)
#define P_VIU_OSD2_BLK1_CFG_W3                     (volatile uint32_t *)((0x1a42  << 2) + 0xff900000)
#define   VIU_OSD2_BLK2_CFG_W3                     (0x1a46)
#define P_VIU_OSD2_BLK2_CFG_W3                     (volatile uint32_t *)((0x1a46  << 2) + 0xff900000)
#define   VIU_OSD2_BLK3_CFG_W3                     (0x1a4a)
#define P_VIU_OSD2_BLK3_CFG_W3                     (volatile uint32_t *)((0x1a4a  << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, v_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, v_start
#define   VIU_OSD2_BLK0_CFG_W4                     (0x1a64)
#define P_VIU_OSD2_BLK0_CFG_W4                     (volatile uint32_t *)((0x1a64  << 2) + 0xff900000)
#define   VIU_OSD2_BLK1_CFG_W4                     (0x1a65)
#define P_VIU_OSD2_BLK1_CFG_W4                     (volatile uint32_t *)((0x1a65  << 2) + 0xff900000)
#define   VIU_OSD2_BLK2_CFG_W4                     (0x1a66)
#define P_VIU_OSD2_BLK2_CFG_W4                     (volatile uint32_t *)((0x1a66  << 2) + 0xff900000)
#define   VIU_OSD2_BLK3_CFG_W4                     (0x1a67)
#define P_VIU_OSD2_BLK3_CFG_W4                     (volatile uint32_t *)((0x1a67  << 2) + 0xff900000)
// Bit    31 RW, burst_len_sel[2] of [2:0]
// Bit    30 RW, byte_swap: In addition to endian control, further define
//               whether to swap upper and lower byte within a 16-bit mem word.
//               0=No swap; 1=Swap data[15:0] to be {data[7:0], data[15:8]}
// Bit    29 RW, div_swap : swap the 2 64bits words in 128 bit word
// Bit 28:24 RW, fifo_lim : when osd fifo is small than the fifo_lim*16, closed the rq port of osd_rd_mif
// Bit 23:22 RW, fifo_ctrl: 00 : for 1 word in 1 burst , 01 : for  2words in 1burst, 10: for 4words in 1burst, 11: reserved
// Bit 21:20 R,  fifo_st. 0=IDLE, 1=FILL, 2=ABORT
// Bit    19 R,  fifo_overflow
//
// Bit 18:12 RW, fifo_depth_val, max value=64: set actual fifo depth to fifo_depth_val*8.
// Bit 11:10 RW, burst_len_sel[1:0] of [2:0]. 0=24(default), 1=32, 2=48, 3=64, 4=96, 5=128.
// Bit  9: 5 RW, hold_fifo_lines[4:0]
// Bit     4 RW, clear_err: one pulse to clear fifo_overflow
// Bit     3 RW, fifo_sync_rst
// Bit  2: 1 RW, endian
// Bit     0 RW, urgent
#define   VIU_OSD2_FIFO_CTRL_STAT                  (0x1a4b)
#define P_VIU_OSD2_FIFO_CTRL_STAT                  (volatile uint32_t *)((0x1a4b  << 2) + 0xff900000)
// Bit 31:24 R, Y or R
// Bit 23:16 R, Cb or G
// Bit 15: 8 R, Cr or B
// Bit  7: 0 R, Output Alpha[8:1]
#define   VIU_OSD2_TEST_RDDATA                     (0x1a4c)
#define P_VIU_OSD2_TEST_RDDATA                     (volatile uint32_t *)((0x1a4c  << 2) + 0xff900000)
// Bit    15 RW, prot_en: 1=Borrow PROT's FIFO storage, either for rotate or non-rotate.
// Bit 12: 0 RW, effective FIFO size when prot_en=1.
#define   VIU_OSD2_PROT_CTRL                       (0x1a4e)
#define P_VIU_OSD2_PROT_CTRL                       (volatile uint32_t *)((0x1a4e  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// VD1 path
//------------------------------------------------------------------------------
#define   VD1_IF0_GEN_REG                          (0x1a50)
#define P_VD1_IF0_GEN_REG                          (volatile uint32_t *)((0x1a50  << 2) + 0xff900000)
#define   VD1_IF0_CANVAS0                          (0x1a51)
#define P_VD1_IF0_CANVAS0                          (volatile uint32_t *)((0x1a51  << 2) + 0xff900000)
#define   VD1_IF0_CANVAS1                          (0x1a52)
#define P_VD1_IF0_CANVAS1                          (volatile uint32_t *)((0x1a52  << 2) + 0xff900000)
#define   VD1_IF0_LUMA_X0                          (0x1a53)
#define P_VD1_IF0_LUMA_X0                          (volatile uint32_t *)((0x1a53  << 2) + 0xff900000)
#define   VD1_IF0_LUMA_Y0                          (0x1a54)
#define P_VD1_IF0_LUMA_Y0                          (volatile uint32_t *)((0x1a54  << 2) + 0xff900000)
#define   VD1_IF0_CHROMA_X0                        (0x1a55)
#define P_VD1_IF0_CHROMA_X0                        (volatile uint32_t *)((0x1a55  << 2) + 0xff900000)
#define   VD1_IF0_CHROMA_Y0                        (0x1a56)
#define P_VD1_IF0_CHROMA_Y0                        (volatile uint32_t *)((0x1a56  << 2) + 0xff900000)
#define   VD1_IF0_LUMA_X1                          (0x1a57)
#define P_VD1_IF0_LUMA_X1                          (volatile uint32_t *)((0x1a57  << 2) + 0xff900000)
#define   VD1_IF0_LUMA_Y1                          (0x1a58)
#define P_VD1_IF0_LUMA_Y1                          (volatile uint32_t *)((0x1a58  << 2) + 0xff900000)
#define   VD1_IF0_CHROMA_X1                        (0x1a59)
#define P_VD1_IF0_CHROMA_X1                        (volatile uint32_t *)((0x1a59  << 2) + 0xff900000)
#define   VD1_IF0_CHROMA_Y1                        (0x1a5a)
#define P_VD1_IF0_CHROMA_Y1                        (volatile uint32_t *)((0x1a5a  << 2) + 0xff900000)
#define   VD1_IF0_RPT_LOOP                         (0x1a5b)
#define P_VD1_IF0_RPT_LOOP                         (volatile uint32_t *)((0x1a5b  << 2) + 0xff900000)
#define   VD1_IF0_LUMA0_RPT_PAT                    (0x1a5c)
#define P_VD1_IF0_LUMA0_RPT_PAT                    (volatile uint32_t *)((0x1a5c  << 2) + 0xff900000)
#define   VD1_IF0_CHROMA0_RPT_PAT                  (0x1a5d)
#define P_VD1_IF0_CHROMA0_RPT_PAT                  (volatile uint32_t *)((0x1a5d  << 2) + 0xff900000)
#define   VD1_IF0_LUMA1_RPT_PAT                    (0x1a5e)
#define P_VD1_IF0_LUMA1_RPT_PAT                    (volatile uint32_t *)((0x1a5e  << 2) + 0xff900000)
#define   VD1_IF0_CHROMA1_RPT_PAT                  (0x1a5f)
#define P_VD1_IF0_CHROMA1_RPT_PAT                  (volatile uint32_t *)((0x1a5f  << 2) + 0xff900000)
#define   VD1_IF0_LUMA_PSEL                        (0x1a60)
#define P_VD1_IF0_LUMA_PSEL                        (volatile uint32_t *)((0x1a60  << 2) + 0xff900000)
#define   VD1_IF0_CHROMA_PSEL                      (0x1a61)
#define P_VD1_IF0_CHROMA_PSEL                      (volatile uint32_t *)((0x1a61  << 2) + 0xff900000)
#define   VD1_IF0_DUMMY_PIXEL                      (0x1a62)
#define P_VD1_IF0_DUMMY_PIXEL                      (volatile uint32_t *)((0x1a62  << 2) + 0xff900000)
#define   VD1_IF0_LUMA_FIFO_SIZE                   (0x1a63)
#define P_VD1_IF0_LUMA_FIFO_SIZE                   (volatile uint32_t *)((0x1a63  << 2) + 0xff900000)
#define   VD1_IF0_RANGE_MAP_Y                      (0x1a6a)
#define P_VD1_IF0_RANGE_MAP_Y                      (volatile uint32_t *)((0x1a6a  << 2) + 0xff900000)
#define   VD1_IF0_RANGE_MAP_CB                     (0x1a6b)
#define P_VD1_IF0_RANGE_MAP_CB                     (volatile uint32_t *)((0x1a6b  << 2) + 0xff900000)
#define   VD1_IF0_RANGE_MAP_CR                     (0x1a6c)
#define P_VD1_IF0_RANGE_MAP_CR                     (volatile uint32_t *)((0x1a6c  << 2) + 0xff900000)
#define   VD1_IF0_GEN_REG2                         (0x1a6d)
#define P_VD1_IF0_GEN_REG2                         (volatile uint32_t *)((0x1a6d  << 2) + 0xff900000)
#define   VD1_IF0_PROT_CNTL                        (0x1a6e)
#define P_VD1_IF0_PROT_CNTL                        (volatile uint32_t *)((0x1a6e  << 2) + 0xff900000)
#define   VD1_IF0_URGENT_CTRL                      (0x1a6f)
#define P_VD1_IF0_URGENT_CTRL                      (volatile uint32_t *)((0x1a6f  << 2) + 0xff900000)
//Bit 31    it true, disable clock, otherwise enable clock
//Bit 30    soft rst bit
//Bit 28    if true, horizontal formatter use repeating to generate pixel, otherwise use bilinear interpolation
//Bit 27:24 horizontal formatter initial phase
//Bit 23    horizontal formatter repeat pixel 0 enable
//Bit 22:21 horizontal Y/C ratio, 00: 1:1, 01: 2:1, 10: 4:1
//Bit 20    horizontal formatter enable
//Bit 19    if true, always use phase0 while vertical formater, meaning always
//          repeat data, no interpolation
//Bit 18    if true, disable vertical formatter chroma repeat last line
//Bit 17    vertical formatter dont need repeat line on phase0, 1: enable, 0: disable
//Bit 16    vertical formatter repeat line 0 enable
//Bit 15:12 vertical formatter skip line num at the beginning
//Bit 11:8  vertical formatter initial phase
//Bit 7:1   vertical formatter phase step (3.4)
//Bit 0     vertical formatter enable
#define   VIU_VD1_FMT_CTRL                         (0x1a68)
#define P_VIU_VD1_FMT_CTRL                         (volatile uint32_t *)((0x1a68  << 2) + 0xff900000)
//Bit 27:16  horizontal formatter width
//Bit 11:0   vertical formatter width
#define   VIU_VD1_FMT_W                            (0x1a69)
#define P_VIU_VD1_FMT_W                            (volatile uint32_t *)((0x1a69  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// VD2 path
//------------------------------------------------------------------------------
#define   VD2_IF0_GEN_REG                          (0x1a70)
#define P_VD2_IF0_GEN_REG                          (volatile uint32_t *)((0x1a70  << 2) + 0xff900000)
#define   VD2_IF0_CANVAS0                          (0x1a71)
#define P_VD2_IF0_CANVAS0                          (volatile uint32_t *)((0x1a71  << 2) + 0xff900000)
#define   VD2_IF0_CANVAS1                          (0x1a72)
#define P_VD2_IF0_CANVAS1                          (volatile uint32_t *)((0x1a72  << 2) + 0xff900000)
#define   VD2_IF0_LUMA_X0                          (0x1a73)
#define P_VD2_IF0_LUMA_X0                          (volatile uint32_t *)((0x1a73  << 2) + 0xff900000)
#define   VD2_IF0_LUMA_Y0                          (0x1a74)
#define P_VD2_IF0_LUMA_Y0                          (volatile uint32_t *)((0x1a74  << 2) + 0xff900000)
#define   VD2_IF0_CHROMA_X0                        (0x1a75)
#define P_VD2_IF0_CHROMA_X0                        (volatile uint32_t *)((0x1a75  << 2) + 0xff900000)
#define   VD2_IF0_CHROMA_Y0                        (0x1a76)
#define P_VD2_IF0_CHROMA_Y0                        (volatile uint32_t *)((0x1a76  << 2) + 0xff900000)
#define   VD2_IF0_LUMA_X1                          (0x1a77)
#define P_VD2_IF0_LUMA_X1                          (volatile uint32_t *)((0x1a77  << 2) + 0xff900000)
#define   VD2_IF0_LUMA_Y1                          (0x1a78)
#define P_VD2_IF0_LUMA_Y1                          (volatile uint32_t *)((0x1a78  << 2) + 0xff900000)
#define   VD2_IF0_CHROMA_X1                        (0x1a79)
#define P_VD2_IF0_CHROMA_X1                        (volatile uint32_t *)((0x1a79  << 2) + 0xff900000)
#define   VD2_IF0_CHROMA_Y1                        (0x1a7a)
#define P_VD2_IF0_CHROMA_Y1                        (volatile uint32_t *)((0x1a7a  << 2) + 0xff900000)
#define   VD2_IF0_RPT_LOOP                         (0x1a7b)
#define P_VD2_IF0_RPT_LOOP                         (volatile uint32_t *)((0x1a7b  << 2) + 0xff900000)
#define   VD2_IF0_LUMA0_RPT_PAT                    (0x1a7c)
#define P_VD2_IF0_LUMA0_RPT_PAT                    (volatile uint32_t *)((0x1a7c  << 2) + 0xff900000)
#define   VD2_IF0_CHROMA0_RPT_PAT                  (0x1a7d)
#define P_VD2_IF0_CHROMA0_RPT_PAT                  (volatile uint32_t *)((0x1a7d  << 2) + 0xff900000)
#define   VD2_IF0_LUMA1_RPT_PAT                    (0x1a7e)
#define P_VD2_IF0_LUMA1_RPT_PAT                    (volatile uint32_t *)((0x1a7e  << 2) + 0xff900000)
#define   VD2_IF0_CHROMA1_RPT_PAT                  (0x1a7f)
#define P_VD2_IF0_CHROMA1_RPT_PAT                  (volatile uint32_t *)((0x1a7f  << 2) + 0xff900000)
#define   VD2_IF0_LUMA_PSEL                        (0x1a80)
#define P_VD2_IF0_LUMA_PSEL                        (volatile uint32_t *)((0x1a80  << 2) + 0xff900000)
#define   VD2_IF0_CHROMA_PSEL                      (0x1a81)
#define P_VD2_IF0_CHROMA_PSEL                      (volatile uint32_t *)((0x1a81  << 2) + 0xff900000)
#define   VD2_IF0_DUMMY_PIXEL                      (0x1a82)
#define P_VD2_IF0_DUMMY_PIXEL                      (volatile uint32_t *)((0x1a82  << 2) + 0xff900000)
#define   VD2_IF0_LUMA_FIFO_SIZE                   (0x1a83)
#define P_VD2_IF0_LUMA_FIFO_SIZE                   (volatile uint32_t *)((0x1a83  << 2) + 0xff900000)
#define   VD2_IF0_RANGE_MAP_Y                      (0x1a8a)
#define P_VD2_IF0_RANGE_MAP_Y                      (volatile uint32_t *)((0x1a8a  << 2) + 0xff900000)
#define   VD2_IF0_RANGE_MAP_CB                     (0x1a8b)
#define P_VD2_IF0_RANGE_MAP_CB                     (volatile uint32_t *)((0x1a8b  << 2) + 0xff900000)
#define   VD2_IF0_RANGE_MAP_CR                     (0x1a8c)
#define P_VD2_IF0_RANGE_MAP_CR                     (volatile uint32_t *)((0x1a8c  << 2) + 0xff900000)
#define   VD2_IF0_GEN_REG2                         (0x1a8d)
#define P_VD2_IF0_GEN_REG2                         (volatile uint32_t *)((0x1a8d  << 2) + 0xff900000)
#define   VD2_IF0_PROT_CNTL                        (0x1a8e)
#define P_VD2_IF0_PROT_CNTL                        (volatile uint32_t *)((0x1a8e  << 2) + 0xff900000)
#define   VD2_IF0_URGENT_CTRL                      (0x1a8f)
#define P_VD2_IF0_URGENT_CTRL                      (volatile uint32_t *)((0x1a8f  << 2) + 0xff900000)
//Bit 31    it true, disable clock, otherwise enable clock
//Bit 30    soft rst bit
//Bit 28    if true, horizontal formatter use repeating to generate pixel, otherwise use bilinear interpolation
//Bit 27:24 horizontal formatter initial phase
//Bit 23    horizontal formatter repeat pixel 0 enable
//Bit 22:21 horizontal Y/C ratio, 00: 1:1, 01: 2:1, 10: 4:1
//Bit 20    horizontal formatter enable
//Bit 17    vertical formatter dont need repeat line on phase0, 1: enable, 0: disable
//Bit 16    vertical formatter repeat line 0 enable
//Bit 15:12 vertical formatter skip line num at the beginning
//Bit 11:8  vertical formatter initial phase
//Bit 7:1   vertical formatter phase step (3.4)
//Bit 0     vertical formatter enable
#define   VIU_VD2_FMT_CTRL                         (0x1a88)
#define P_VIU_VD2_FMT_CTRL                         (volatile uint32_t *)((0x1a88  << 2) + 0xff900000)
//Bit 27:16  horizontal formatter width
//Bit 11:0   vertical formatter width
#define   VIU_VD2_FMT_W                            (0x1a89)
#define P_VIU_VD2_FMT_W                            (volatile uint32_t *)((0x1a89  << 2) + 0xff900000)
//     //todo add comment
#define   LDIM_STTS_GCLK_CTRL0                     (0x1ac0)
#define P_LDIM_STTS_GCLK_CTRL0                     (volatile uint32_t *)((0x1ac0  << 2) + 0xff900000)
#define   LDIM_STTS_CTRL0                          (0x1ac1)
#define P_LDIM_STTS_CTRL0                          (volatile uint32_t *)((0x1ac1  << 2) + 0xff900000)
#define   LDIM_STTS_WIDTHM1_HEIGHTM1               (0x1ac2)
#define P_LDIM_STTS_WIDTHM1_HEIGHTM1               (volatile uint32_t *)((0x1ac2  << 2) + 0xff900000)
#define   LDIM_STTS_MATRIX_COEF00_01               (0x1ac3)
#define P_LDIM_STTS_MATRIX_COEF00_01               (volatile uint32_t *)((0x1ac3  << 2) + 0xff900000)
#define   LDIM_STTS_MATRIX_COEF02_10               (0x1ac4)
#define P_LDIM_STTS_MATRIX_COEF02_10               (volatile uint32_t *)((0x1ac4  << 2) + 0xff900000)
#define   LDIM_STTS_MATRIX_COEF11_12               (0x1ac5)
#define P_LDIM_STTS_MATRIX_COEF11_12               (volatile uint32_t *)((0x1ac5  << 2) + 0xff900000)
#define   LDIM_STTS_MATRIX_COEF20_21               (0x1ac6)
#define P_LDIM_STTS_MATRIX_COEF20_21               (volatile uint32_t *)((0x1ac6  << 2) + 0xff900000)
#define   LDIM_STTS_MATRIX_COEF22                  (0x1ac7)
#define P_LDIM_STTS_MATRIX_COEF22                  (volatile uint32_t *)((0x1ac7  << 2) + 0xff900000)
#define   LDIM_STTS_MATRIX_OFFSET0_1               (0x1ac8)
#define P_LDIM_STTS_MATRIX_OFFSET0_1               (volatile uint32_t *)((0x1ac8  << 2) + 0xff900000)
#define   LDIM_STTS_MATRIX_OFFSET2                 (0x1ac9)
#define P_LDIM_STTS_MATRIX_OFFSET2                 (volatile uint32_t *)((0x1ac9  << 2) + 0xff900000)
#define   LDIM_STTS_MATRIX_PRE_OFFSET0_1           (0x1aca)
#define P_LDIM_STTS_MATRIX_PRE_OFFSET0_1           (volatile uint32_t *)((0x1aca  << 2) + 0xff900000)
#define   LDIM_STTS_MATRIX_PRE_OFFSET2             (0x1acb)
#define P_LDIM_STTS_MATRIX_PRE_OFFSET2             (volatile uint32_t *)((0x1acb  << 2) + 0xff900000)
#define   LDIM_STTS_MATRIX_HL_COLOR                (0x1acc)
#define P_LDIM_STTS_MATRIX_HL_COLOR                (volatile uint32_t *)((0x1acc  << 2) + 0xff900000)
#define   LDIM_STTS_MATRIX_PROBE_POS               (0x1acd)
#define P_LDIM_STTS_MATRIX_PROBE_POS               (volatile uint32_t *)((0x1acd  << 2) + 0xff900000)
//
//     //read only
#define   LDIM_STTS_MATRIX_PROBE_COLOR             (0x1ace)
#define P_LDIM_STTS_MATRIX_PROBE_COLOR             (volatile uint32_t *)((0x1ace  << 2) + 0xff900000)
//
//     //Bit 31, local dimming statistic enable
//     //Bit 29, 1: output region histogram 16bit 0:output region histogram 20bit
//     //Bit 28, eol enable
//     //Bit 27:25, vertical line overlap number for max finding
//     //Bit 24:22, horizontal pixel overlap number, 0: 17 pix, 1: 9 pix, 2: 5 pix, 3: 3 pix, 4: 0 pix
//     //Bit 20, 1,2,1 low pass filter enable before max/hist statistic
//     //Bit 19:16, region H/V position index, refer to VDIN_LDIM_STTS_HIST_SET_REGION
//     //Bit 15:14, 1: region read index auto increase per block read finished to VDIN_LDIM_STTS_HIST_READ_REGION
//     //            2: region read index auto increase per read finished to VDIN_LDIM_STTS_HIST_READ_REGION
//     //            0/3: disable read index self increase
//     //Bit 13:8, region read sub index, which mux the hist & max-finding result to cbus port, refer to LDIM_STTS_HIST_READ_REGION
//     //Bit 6:0, region read index
#define   LDIM_STTS_HIST_REGION_IDX                (0x1ad0)
#define P_LDIM_STTS_HIST_REGION_IDX                (volatile uint32_t *)((0x1ad0  << 2) + 0xff900000)
//Bit 28:0, if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h0: read/write hvstart0
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h1: read/write hend01
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h2: read/write vend01
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h3: read/write hend23
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h4: read/write vend23
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h5: read/write hend45
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h6: read/write vend45
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'd7: read/write hend67
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h8: read/write vend67
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h9: read/write hend89
//          if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'ha: read/write vend89
//     //hvstart0, Bit 28:16 row0 vstart, Bit 12:0 col0 hstart
//     //hend01, Bit 28:16 col1 hend, Bit 12:0 col0 hend
//     //vend01, Bit 28:16 row1 vend, Bit 12:0 row0 vend
//     //hend23, Bit 28:16 col3 hend, Bit 12:0 col2 hend
//     //vend23, Bit 28:16 row3 vend, Bit 12:0 row2 vend
//     //hend45, Bit 28:16 col5 hend, Bit 12:0 col4 hend
//     //vend45, Bit 28:16 row5 vend, Bit 12:0 row4 vend
//     //hend67, Bit 28:16 col7 hend, Bit 12:0 col6 hend
//     //vend67, Bit 28:16 row7 vend, Bit 12:0 row6 vend
//     //hend89, Bit 28:16 col9 hend, Bit 12:0 col8 hend
//     //vend89, Bit 28:16 row9 vend, Bit 12:0 row8 vend
#define   LDIM_STTS_HIST_SET_REGION                (0x1ad1)
#define P_LDIM_STTS_HIST_SET_REGION                (volatile uint32_t *)((0x1ad1  << 2) + 0xff900000)
//
//     //if LDIM_STTS_HIST_REGION_IDX[29] == 0, that is output hist with 20bit data.
//     //if LDIM_STTS_HIST_REGION_IDX[21] == 0, that is output 16hist bins in comp 0.
//     //output sequence as rd_sub_idx from 0~47: {max_comp2, comp0_hist0}, {max_comp1, comp0_hist1}, {max_comp0, comp0_hist2},
//     //                                          comp0_hist3 ... comp2_hist16
//     //if LDIM_STTS_HIST_REGION_IDX[29] == 1, that is output hist with 16bit data.
//     //if LDIM_STTS_HIST_REGION_IDX[21] == 0, that is output 16hist bins in comp 0.
//     //output sequence as rd_sub_idx from 0~47: {max_comp2, max_comp1, max_comp0}, comp0_hist0, comp0_hist1, comp0_hist2
//     //                                          comp0_hist3 ... comp2_hist16
//     //if LDIM_STTS_HIST_REGION_IDX[29] == 0, that is output hist with 20bit data.
//     //if LDIM_STTS_HIST_REGION_IDX[21] == 1, that is output 32hist bins in comp 0.
//     //output sequence as rd_sub_idx from 0~47: {max_comp2, max_comp1, max_comp0}, comp0_hist0, comp0_hist1, comp0_hist2
//     //                                          comp0_hist3 ...comp0_hist31 ... comp1_hist16
//
#define   LDIM_STTS_HIST_READ_REGION               (0x1ad2)
#define P_LDIM_STTS_HIST_READ_REGION               (volatile uint32_t *)((0x1ad2  << 2) + 0xff900000)
#define   LDIM_STTS_HIST_START_RD_REGION           (0x1ad3)
#define P_LDIM_STTS_HIST_START_RD_REGION           (volatile uint32_t *)((0x1ad3  << 2) + 0xff900000)
//     //bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di if1 chroma path
//     //bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di if1 luma path
//     `define DI_IF1_URGENT_CTRL                       8'ha3
//     //bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di inp chroma path
//     //bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di inp luma path
//     `define DI_INP_URGENT_CTRL                       8'ha4
//     //bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di mem chroma path
//     //bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di mem luma path
//     `define DI_MEM_URGENT_CTRL                       8'ha5
//     //bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di chan2 chroma path
//     //bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di chan2 luma path
//     `define DI_CHAN2_URGENT_CTRL                 8'ha6
#define   VD1_IF0_GEN_REG3                         (0x1aa7)
#define P_VD1_IF0_GEN_REG3                         (volatile uint32_t *)((0x1aa7  << 2) + 0xff900000)
//bit 31:1,  reversed
//bit 0,     cntl_64bit_rev
#define   VD2_IF0_GEN_REG3                         (0x1aa8)
#define P_VD2_IF0_GEN_REG3                         (volatile uint32_t *)((0x1aa8  << 2) + 0xff900000)
//bit 31:1,  reversed
//bit 0,     cntl_64bit_rev
#define   OSD_BLENDO_H_START_END                   (0x1aa9)
#define P_OSD_BLENDO_H_START_END                   (volatile uint32_t *)((0x1aa9  << 2) + 0xff900000)
//OSD blending output horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define   OSD_BLENDO_V_START_END                   (0x1aaa)
#define P_OSD_BLENDO_V_START_END                   (volatile uint32_t *)((0x1aaa  << 2) + 0xff900000)
//OSD blending output vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define   OSD_BLEND_GEN_CTRL0                      (0x1aab)
#define P_OSD_BLEND_GEN_CTRL0                      (volatile uint32_t *)((0x1aab  << 2) + 0xff900000)
//Bit 31:23 const_out_alpha
//Bit 22:14 const_op_alpha
//Bit 13 if true, OSD2 foreground otherwise OSD1 foreground
//Bit 12  OSD BLENDing enable
//Bit 9:8 alpha_op_sel 00: output alpha use osd1_alpha, 01: use osd2_alpha, else use const_out_alpha
//Bit 5:4 color_op_sel 00: use osd1_alpha, 01: use osd2_alpha, else use const_op_alpha
//Bit 1  OSD2 enable
//Bit 0  OSD1 enable
#define   OSD_BLEND_GEN_CTRL1                      (0x1aac)
#define P_OSD_BLEND_GEN_CTRL1                      (volatile uint32_t *)((0x1aac  << 2) + 0xff900000)
//Bit 31    osd1_alpha_premult, if true, osd1 alpha is premultiplied
//Bit 30    osd2_alpha_premult, if true, osd2 alpha is premultiplied
//Bit 23:16 osd blending hold lines
//Bit 13:0  osd blending h_size
#define   OSD_BLEND_DUMMY_DATA                     (0x1aad)
#define P_OSD_BLEND_DUMMY_DATA                     (volatile uint32_t *)((0x1aad  << 2) + 0xff900000)
//Bit 29:20   Y/R
//Bit 19:10   CB/G
//Bit 9:0     Cr/B
#define   OSD_BLEND_CURRENT_XY                     (0x1aae)
#define P_OSD_BLEND_CURRENT_XY                     (volatile uint32_t *)((0x1aae  << 2) + 0xff900000)
//Bit 28:16 current_x
//Bit 12:0 current_y
//Bit 7,  highlight_en
//Bit 6   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before matrix
//Bit 5:4  probe_sel, 00: select matrix 0, 01: select matrix 1,  otherwise select nothing
//Bit 3:2, matrix coef idx selection, 00: select mat0, 01: select mat1, otherwise slect nothing
//Bit 1   mat1 conversion matrix enable
//Bit 0   mat0 conversion matrix enable
#define   VIU_OSD2_MATRIX_CTRL                     (0x1ab0)
#define P_VIU_OSD2_MATRIX_CTRL                     (volatile uint32_t *)((0x1ab0  << 2) + 0xff900000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define   VIU_OSD2_MATRIX_COEF00_01                (0x1ab1)
#define P_VIU_OSD2_MATRIX_COEF00_01                (volatile uint32_t *)((0x1ab1  << 2) + 0xff900000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define   VIU_OSD2_MATRIX_COEF02_10                (0x1ab2)
#define P_VIU_OSD2_MATRIX_COEF02_10                (volatile uint32_t *)((0x1ab2  << 2) + 0xff900000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define   VIU_OSD2_MATRIX_COEF11_12                (0x1ab3)
#define P_VIU_OSD2_MATRIX_COEF11_12                (volatile uint32_t *)((0x1ab3  << 2) + 0xff900000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define   VIU_OSD2_MATRIX_COEF20_21                (0x1ab4)
#define P_VIU_OSD2_MATRIX_COEF20_21                (volatile uint32_t *)((0x1ab4  << 2) + 0xff900000)
#define   VIU_OSD2_MATRIX_COEF22                   (0x1ab5)
#define P_VIU_OSD2_MATRIX_COEF22                   (volatile uint32_t *)((0x1ab5  << 2) + 0xff900000)
//Bit 26:16 offset0
//Bit 10:0  offset1
#define   VIU_OSD2_MATRIX_OFFSET0_1                (0x1ab6)
#define P_VIU_OSD2_MATRIX_OFFSET0_1                (volatile uint32_t *)((0x1ab6  << 2) + 0xff900000)
//Bit 10:0  offset2
#define   VIU_OSD2_MATRIX_OFFSET2                  (0x1ab7)
#define P_VIU_OSD2_MATRIX_OFFSET2                  (volatile uint32_t *)((0x1ab7  << 2) + 0xff900000)
//Bit 26:16 pre_offset0
//Bit 10:0  pre_offset1
#define   VIU_OSD2_MATRIX_PRE_OFFSET0_1            (0x1ab8)
#define P_VIU_OSD2_MATRIX_PRE_OFFSET0_1            (volatile uint32_t *)((0x1ab8  << 2) + 0xff900000)
//Bit 10:0  pre_offset2
#define   VIU_OSD2_MATRIX_PRE_OFFSET2              (0x1ab9)
#define P_VIU_OSD2_MATRIX_PRE_OFFSET2              (volatile uint32_t *)((0x1ab9  << 2) + 0xff900000)
//Read only
//Bit 29:20 component 0
//Bit 19:10 component 1
//Bit 9:0 component 2
#define   VIU_OSD2_MATRIX_PROBE_COLOR              (0x1aba)
#define P_VIU_OSD2_MATRIX_PROBE_COLOR              (volatile uint32_t *)((0x1aba  << 2) + 0xff900000)
//Bit 23:16 component 0
//Bit 15:8  component 1
//Bit 7:0 component 2
#define   VIU_OSD2_MATRIX_HL_COLOR                 (0x1abb)
#define P_VIU_OSD2_MATRIX_HL_COLOR                 (volatile uint32_t *)((0x1abb  << 2) + 0xff900000)
//28:16 probe x, postion
//12:0  probe y, position
#define   VIU_OSD2_MATRIX_PROBE_POS                (0x1abc)
#define P_VIU_OSD2_MATRIX_PROBE_POS                (volatile uint32_t *)((0x1abc  << 2) + 0xff900000)
//the segment of afbc dec is 8'he0-8'hfe
//`define AFBC_DEC_OFFSET   8'he0
//
// Reading file:  afbc_dec_regs.h
//
// synopsys translate_off
// synopsys translate_on
////===============================////
//// reg
////===============================////
#define   AFBC_ENABLE                              (0x1ae0)
#define P_AFBC_ENABLE                              (volatile uint32_t *)((0x1ae0  << 2) + 0xff900000)
//Bit   31:1,     reserved
//Bit   8,        dec_enable        unsigned  , default = 0
//Bit   7:1,      reserved
//Bit   0,        frm_start         unsigned  , default = 0
#define   AFBC_MODE                                (0x1ae1)
#define P_AFBC_MODE                                (volatile uint32_t *)((0x1ae1  << 2) + 0xff900000)
//Bit   31,       soft_reset        the use as go_field
//Bit   30,       reserved
//Bit   29,       ddr_sz_mode       uns, default = 0 , 0: fixed block ddr size 1 : unfixed block ddr size;
//Bit   28,       blk_mem_mode      uns, default = 0 , 0: fixed 16x128 size; 1 : fixed 12x128 size
//Bit   27:26,    rev_mode          uns, default = 0 , reverse mode
//Bit   25:24,    mif_urgent        uns, default = 3 , info mif and data mif urgent
//Bit   22:16,    hold_line_num
//Bit   15:14,    burst_len         uns, default = 1, 0: burst1 1:burst2 2:burst4
//Bit   13:8,     compbits_yuv      uns, default = 0 ,
//                                  bit 1:0,: y  component bitwidth : 00-8bit 01-9bit 10-10bit
//                                  bit 3:2,: u  component bitwidth : 00-8bit 01-9bit 10-10bit
//                                  bit 5:4,: v  component bitwidth : 00-8bit 01-9bit 10-10bit
//Bit   7:6,      vert_skip_y       uns, default = 0 , luma vert skip mode : 00-y0y1, 01-y0, 10-y1, 11-(y0+y1)/2
//Bit   5:4,      horz_skip_y       uns, default = 0 , luma horz skip mode : 00-y0y1, 01-y0, 10-y1, 11-(y0+y1)/2
//Bit   3:2,      vert_skip_uv      uns, default = 0 , chroma vert skip mode : 00-y0y1, 01-y0, 10-y1, 11-(y0+y1)/2
//Bit   1:0,      horz_skip_uv      uns, default = 0 , chroma horz skip mode : 00-y0y1, 01-y0, 10-y1, 11-(y0+y1)/2
#define   AFBC_SIZE_IN                             (0x1ae2)
#define P_AFBC_SIZE_IN                             (volatile uint32_t *)((0x1ae2  << 2) + 0xff900000)
//Bit   31:29,    reserved
//Bit   28:16     hsize_in          uns, default = 1920 , pic horz size in  unit: pixel
//Bit   15:13,    reserved
//Bit   12:0,     vsize_in          uns, default = 1080 , pic vert size in  unit: pixel
#define   AFBC_DEC_DEF_COLOR                       (0x1ae3)
#define P_AFBC_DEC_DEF_COLOR                       (volatile uint32_t *)((0x1ae3  << 2) + 0xff900000)
//Bit   31:29,    reserved
//Bit   29:20,   def_color_y        uns, default = 0, afbc dec y default setting value
//Bit   19:10,   def_color_u        uns, default = 0, afbc dec u default setting value
//Bit    9: 0,   def_color_v        uns, default = 0, afbc dec v default setting value
#define   AFBC_CONV_CTRL                           (0x1ae4)
#define P_AFBC_CONV_CTRL                           (volatile uint32_t *)((0x1ae4  << 2) + 0xff900000)
//Bit   31:12,   reserved
//Bit   11: 0,   conv_lbuf_len       uns, default = 256, unit=16 pixel need to set = 2^n
#define   AFBC_LBUF_DEPTH                          (0x1ae5)
#define P_AFBC_LBUF_DEPTH                          (volatile uint32_t *)((0x1ae5  << 2) + 0xff900000)
//Bit   31:28,   reserved
//Bit   27:16,   dec_lbuf_depth      uns, default = 128; // unit= 8 pixel
//Bit   15:12,   reserved
//Bit   11:0,    mif_lbuf_depth      uns, default = 128;
#define   AFBC_HEAD_BADDR                          (0x1ae6)
#define P_AFBC_HEAD_BADDR                          (volatile uint32_t *)((0x1ae6  << 2) + 0xff900000)
//Bit   31:0,   mif_info_baddr      uns, default = 32'h0;
#define   AFBC_BODY_BADDR                          (0x1ae7)
#define P_AFBC_BODY_BADDR                          (volatile uint32_t *)((0x1ae7  << 2) + 0xff900000)
//Bit   31:0,   mif_data_baddr      uns, default = 32'h0001_0000;
#define   AFBC_SIZE_OUT                            (0x1ae8)
#define P_AFBC_SIZE_OUT                            (volatile uint32_t *)((0x1ae8  << 2) + 0xff900000)
//Bit   31:29,   reserved
//Bit   28:16,   hsize_out           uns, default = 1920    ; // unit: 1 pixel
//Bit   15:13,   reserved
//Bit    12:0,   vsize_out           uns, default = 1080 ; // unit: 1 pixel
#define   AFBC_OUT_YSCOPE                          (0x1ae9)
#define P_AFBC_OUT_YSCOPE                          (volatile uint32_t *)((0x1ae9  << 2) + 0xff900000)
//Bit   31:29,   reserved
//Bit   28:16,   out_vert_bgn        uns, default = 0    ; // unit: 1 pixel
//Bit   15:13,   reserved
//Bit    12:0,   out_vert_end        uns, default = 1079 ; // unit: 1 pixel
#define   AFBC_STAT                                (0x1aea)
#define P_AFBC_STAT                                (volatile uint32_t *)((0x1aea  << 2) + 0xff900000)
//Bit   31:1,   reserved
//Bit      0,   frm_end_stat         uns, frame end status
#define   AFBC_VD_CFMT_CTRL                        (0x1aeb)
#define P_AFBC_VD_CFMT_CTRL                        (volatile uint32_t *)((0x1aeb  << 2) + 0xff900000)
//Bit 31    it true, disable clock, otherwise enable clock
//Bit 30    soft rst bit
//Bit 28    if true, horizontal formatter use repeating to generate pixel, otherwise use bilinear interpolation
//Bit 27:24 horizontal formatter initial phase
//Bit 23    horizontal formatter repeat pixel 0 enable
//Bit 22:21 horizontal Y/C ratio, 00: 1:1, 01: 2:1, 10: 4:1
//Bit 20    horizontal formatter enable
//Bit 19    if true, always use phase0 while vertical formater, meaning always
//          repeat data, no interpolation
//Bit 18    if true, disable vertical formatter chroma repeat last line
//Bit 17    vertical formatter dont need repeat line on phase0, 1: enable, 0: disable
//Bit 16    vertical formatter repeat line 0 enable
//Bit 15:12 vertical formatter skip line num at the beginning
//Bit 11:8  vertical formatter initial phase
//Bit 7:1   vertical formatter phase step (3.4)
//Bit 0     vertical formatter enable
#define   AFBC_VD_CFMT_W                           (0x1aec)
#define P_AFBC_VD_CFMT_W                           (volatile uint32_t *)((0x1aec  << 2) + 0xff900000)
//Bit 27:16  horizontal formatter width
//Bit 11:0   vertical formatter width
#define   AFBC_MIF_HOR_SCOPE                       (0x1aed)
#define P_AFBC_MIF_HOR_SCOPE                       (volatile uint32_t *)((0x1aed  << 2) + 0xff900000)
//Bit   31:26,   reserved
//Bit   25:16,   mif_blk_bgn_h        uns, default = 0  ; // unit: 32 pixel/block hor
//Bit   15:10,   reserved
//Bit    9: 0,   mif_blk_end_h        uns, default = 59 ; // unit: 32 pixel/block hor
#define   AFBC_MIF_VER_SCOPE                       (0x1aee)
#define P_AFBC_MIF_VER_SCOPE                       (volatile uint32_t *)((0x1aee  << 2) + 0xff900000)
//Bit   31:28,   reserved
//Bit   27:16,   mif_blk_bgn_v        uns, default = 0  ; // unit: 32 pixel/block ver
//Bit   15:12,   reserved
//Bit   11: 0,   mif_blk_end_v        uns, default = 269; // unit: 32 pixel/block ver
#define   AFBC_PIXEL_HOR_SCOPE                     (0x1aef)
#define P_AFBC_PIXEL_HOR_SCOPE                     (volatile uint32_t *)((0x1aef  << 2) + 0xff900000)
//Bit   31:29,   reserved
//Bit   28:16,   dec_pixel_bgn_h        uns, default = 0  ; // unit: pixel
//Bit   15:13,   reserved
//Bit   12: 0,   dec_pixel_end_h        uns, default = 1919 ; // unit: pixel
#define   AFBC_PIXEL_VER_SCOPE                     (0x1af0)
#define P_AFBC_PIXEL_VER_SCOPE                     (volatile uint32_t *)((0x1af0  << 2) + 0xff900000)
//Bit   31:29,   reserved
//Bit   28:16,   dec_pixel_bgn_v        uns, default = 0  ; // unit: pixel
//Bit   15:13,   reserved
//Bit   12: 0,   dec_pixel_end_v        uns, default = 1079 ; // unit: pixel
#define   AFBC_VD_CFMT_H                           (0x1af1)
#define P_AFBC_VD_CFMT_H                           (volatile uint32_t *)((0x1af1  << 2) + 0xff900000)
//Bit 12:0   vertical formatter height
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  afbc_dec_regs.h
//
//
// Closing file:  vregs_clk2.h
//
//`define  VENC_VCBUS_BASE              8'h1b
//
// Reading file:  venc_regs.h
//
//===========================================================================
// Video Interface Registers    0xa00 - 0xbff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VENC_VCBUS_BASE = 0x1b
// -----------------------------------------------
// bit 15:8 -- vfifo2vd_vd_sel
// bit 0 -- vfifo2vd_en
#define   ENCP_VFIFO2VD_CTL                        (0x1b58)
#define P_ENCP_VFIFO2VD_CTL                        (volatile uint32_t *)((0x1b58  << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define   ENCP_VFIFO2VD_PIXEL_START                (0x1b59)
#define P_ENCP_VFIFO2VD_PIXEL_START                (volatile uint32_t *)((0x1b59  << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define   ENCP_VFIFO2VD_PIXEL_END                  (0x1b5a)
#define P_ENCP_VFIFO2VD_PIXEL_END                  (volatile uint32_t *)((0x1b5a  << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define   ENCP_VFIFO2VD_LINE_TOP_START             (0x1b5b)
#define P_ENCP_VFIFO2VD_LINE_TOP_START             (volatile uint32_t *)((0x1b5b  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define   ENCP_VFIFO2VD_LINE_TOP_END               (0x1b5c)
#define P_ENCP_VFIFO2VD_LINE_TOP_END               (volatile uint32_t *)((0x1b5c  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define   ENCP_VFIFO2VD_LINE_BOT_START             (0x1b5d)
#define P_ENCP_VFIFO2VD_LINE_BOT_START             (volatile uint32_t *)((0x1b5d  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define   ENCP_VFIFO2VD_LINE_BOT_END               (0x1b5e)
#define P_ENCP_VFIFO2VD_LINE_BOT_END               (volatile uint32_t *)((0x1b5e  << 2) + 0xff900000)
// Route the hsync and vsync signals round the chip. There are three
// sources and users of these signals: VIU, internal video encoder, and
// the pins on the chip. Some muxing is still being done in the VIU. It
// was not moved to the venc module so that the same exact VIU code could
// be used both in Twister and Twister2000.
// Bit 2: venc_sync_source (1=>pins, 0=>viu)
// Bit 1: viu_sync_source (1=>pins, 0=>venc)
// Bit 0: vpins_sync_source (1=>venc, 0=>viu)
#define   VENC_SYNC_ROUTE                          (0x1b60)
#define P_VENC_SYNC_ROUTE                          (volatile uint32_t *)((0x1b60  << 2) + 0xff900000)
#define   VENC_VIDEO_EXSRC                         (0x1b61)
#define P_VENC_VIDEO_EXSRC                         (volatile uint32_t *)((0x1b61  << 2) + 0xff900000)
#define   VENC_DVI_SETTING                         (0x1b62)
#define P_VENC_DVI_SETTING                         (volatile uint32_t *)((0x1b62  << 2) + 0xff900000)
#define   VENC_C656_CTRL                           (0x1b63)
#define P_VENC_C656_CTRL                           (volatile uint32_t *)((0x1b63  << 2) + 0xff900000)
#define   VENC_UPSAMPLE_CTRL0                      (0x1b64)
#define P_VENC_UPSAMPLE_CTRL0                      (volatile uint32_t *)((0x1b64  << 2) + 0xff900000)
#define   VENC_UPSAMPLE_CTRL1                      (0x1b65)
#define P_VENC_UPSAMPLE_CTRL1                      (volatile uint32_t *)((0x1b65  << 2) + 0xff900000)
#define   VENC_UPSAMPLE_CTRL2                      (0x1b66)
#define P_VENC_UPSAMPLE_CTRL2                      (volatile uint32_t *)((0x1b66  << 2) + 0xff900000)
// Invert control for tcon output
// bit[15:14] -- vsync, hsync,
// bit[13:0] --  oev3, oev2, cpv2, cph3, cph2, cph1, oeh, vcom, stv2, stv1, cpv1, oev1, sth1, sth2
#define   TCON_INVERT_CTL                          (0x1b67)
#define P_TCON_INVERT_CTL                          (volatile uint32_t *)((0x1b67  << 2) + 0xff900000)
#define   VENC_VIDEO_PROG_MODE                     (0x1b68)
#define P_VENC_VIDEO_PROG_MODE                     (volatile uint32_t *)((0x1b68  << 2) + 0xff900000)
//---- Venc pixel/line info
#define   VENC_ENCI_LINE                           (0x1b69)
#define P_VENC_ENCI_LINE                           (volatile uint32_t *)((0x1b69  << 2) + 0xff900000)
#define   VENC_ENCI_PIXEL                          (0x1b6a)
#define P_VENC_ENCI_PIXEL                          (volatile uint32_t *)((0x1b6a  << 2) + 0xff900000)
#define   VENC_ENCP_LINE                           (0x1b6b)
#define P_VENC_ENCP_LINE                           (volatile uint32_t *)((0x1b6b  << 2) + 0xff900000)
#define   VENC_ENCP_PIXEL                          (0x1b6c)
#define P_VENC_ENCP_PIXEL                          (volatile uint32_t *)((0x1b6c  << 2) + 0xff900000)
//---- Status
#define   VENC_STATA                               (0x1b6d)
#define P_VENC_STATA                               (volatile uint32_t *)((0x1b6d  << 2) + 0xff900000)
//---- Interrupt setting
#define   VENC_INTCTRL                             (0x1b6e)
#define P_VENC_INTCTRL                             (volatile uint32_t *)((0x1b6e  << 2) + 0xff900000)
#define   VENC_INTFLAG                             (0x1b6f)
#define P_VENC_INTFLAG                             (volatile uint32_t *)((0x1b6f  << 2) + 0xff900000)
//--------- Video test configuration
#define   VENC_VIDEO_TST_EN                        (0x1b70)
#define P_VENC_VIDEO_TST_EN                        (volatile uint32_t *)((0x1b70  << 2) + 0xff900000)
#define   VENC_VIDEO_TST_MDSEL                     (0x1b71)
#define P_VENC_VIDEO_TST_MDSEL                     (volatile uint32_t *)((0x1b71  << 2) + 0xff900000)
#define   VENC_VIDEO_TST_Y                         (0x1b72)
#define P_VENC_VIDEO_TST_Y                         (volatile uint32_t *)((0x1b72  << 2) + 0xff900000)
#define   VENC_VIDEO_TST_CB                        (0x1b73)
#define P_VENC_VIDEO_TST_CB                        (volatile uint32_t *)((0x1b73  << 2) + 0xff900000)
#define   VENC_VIDEO_TST_CR                        (0x1b74)
#define P_VENC_VIDEO_TST_CR                        (volatile uint32_t *)((0x1b74  << 2) + 0xff900000)
#define   VENC_VIDEO_TST_CLRBAR_STRT               (0x1b75)
#define P_VENC_VIDEO_TST_CLRBAR_STRT               (volatile uint32_t *)((0x1b75  << 2) + 0xff900000)
#define   VENC_VIDEO_TST_CLRBAR_WIDTH              (0x1b76)
#define P_VENC_VIDEO_TST_CLRBAR_WIDTH              (volatile uint32_t *)((0x1b76  << 2) + 0xff900000)
#define   VENC_VIDEO_TST_VDCNT_STSET               (0x1b77)
#define P_VENC_VIDEO_TST_VDCNT_STSET               (volatile uint32_t *)((0x1b77  << 2) + 0xff900000)
//----- Video dac setting
#define   VENC_VDAC_DACSEL0                        (0x1b78)
#define P_VENC_VDAC_DACSEL0                        (volatile uint32_t *)((0x1b78  << 2) + 0xff900000)
#define   VENC_VDAC_DACSEL1                        (0x1b79)
#define P_VENC_VDAC_DACSEL1                        (volatile uint32_t *)((0x1b79  << 2) + 0xff900000)
#define   VENC_VDAC_DACSEL2                        (0x1b7a)
#define P_VENC_VDAC_DACSEL2                        (volatile uint32_t *)((0x1b7a  << 2) + 0xff900000)
#define   VENC_VDAC_DACSEL3                        (0x1b7b)
#define P_VENC_VDAC_DACSEL3                        (volatile uint32_t *)((0x1b7b  << 2) + 0xff900000)
#define   VENC_VDAC_DACSEL4                        (0x1b7c)
#define P_VENC_VDAC_DACSEL4                        (volatile uint32_t *)((0x1b7c  << 2) + 0xff900000)
#define   VENC_VDAC_DACSEL5                        (0x1b7d)
#define P_VENC_VDAC_DACSEL5                        (volatile uint32_t *)((0x1b7d  << 2) + 0xff900000)
#define   VENC_VDAC_SETTING                        (0x1b7e)
#define P_VENC_VDAC_SETTING                        (volatile uint32_t *)((0x1b7e  << 2) + 0xff900000)
#define   VENC_VDAC_TST_VAL                        (0x1b7f)
#define P_VENC_VDAC_TST_VAL                        (volatile uint32_t *)((0x1b7f  << 2) + 0xff900000)
#define   VENC_VDAC_DAC0_GAINCTRL                  (0x1bf0)
#define P_VENC_VDAC_DAC0_GAINCTRL                  (volatile uint32_t *)((0x1bf0  << 2) + 0xff900000)
#define   VENC_VDAC_DAC0_OFFSET                    (0x1bf1)
#define P_VENC_VDAC_DAC0_OFFSET                    (volatile uint32_t *)((0x1bf1  << 2) + 0xff900000)
#define   VENC_VDAC_DAC1_GAINCTRL                  (0x1bf2)
#define P_VENC_VDAC_DAC1_GAINCTRL                  (volatile uint32_t *)((0x1bf2  << 2) + 0xff900000)
#define   VENC_VDAC_DAC1_OFFSET                    (0x1bf3)
#define P_VENC_VDAC_DAC1_OFFSET                    (volatile uint32_t *)((0x1bf3  << 2) + 0xff900000)
#define   VENC_VDAC_DAC2_GAINCTRL                  (0x1bf4)
#define P_VENC_VDAC_DAC2_GAINCTRL                  (volatile uint32_t *)((0x1bf4  << 2) + 0xff900000)
#define   VENC_VDAC_DAC2_OFFSET                    (0x1bf5)
#define P_VENC_VDAC_DAC2_OFFSET                    (volatile uint32_t *)((0x1bf5  << 2) + 0xff900000)
#define   VENC_VDAC_DAC3_GAINCTRL                  (0x1bf6)
#define P_VENC_VDAC_DAC3_GAINCTRL                  (volatile uint32_t *)((0x1bf6  << 2) + 0xff900000)
#define   VENC_VDAC_DAC3_OFFSET                    (0x1bf7)
#define P_VENC_VDAC_DAC3_OFFSET                    (volatile uint32_t *)((0x1bf7  << 2) + 0xff900000)
#define   VENC_VDAC_DAC4_GAINCTRL                  (0x1bf8)
#define P_VENC_VDAC_DAC4_GAINCTRL                  (volatile uint32_t *)((0x1bf8  << 2) + 0xff900000)
#define   VENC_VDAC_DAC4_OFFSET                    (0x1bf9)
#define P_VENC_VDAC_DAC4_OFFSET                    (volatile uint32_t *)((0x1bf9  << 2) + 0xff900000)
#define   VENC_VDAC_DAC5_GAINCTRL                  (0x1bfa)
#define P_VENC_VDAC_DAC5_GAINCTRL                  (volatile uint32_t *)((0x1bfa  << 2) + 0xff900000)
#define   VENC_VDAC_DAC5_OFFSET                    (0x1bfb)
#define P_VENC_VDAC_DAC5_OFFSET                    (volatile uint32_t *)((0x1bfb  << 2) + 0xff900000)
#define   VENC_VDAC_FIFO_CTRL                      (0x1bfc)
#define P_VENC_VDAC_FIFO_CTRL                      (volatile uint32_t *)((0x1bfc  << 2) + 0xff900000)
#define   ENCL_TCON_INVERT_CTL                     (0x1bfd)
#define P_ENCL_TCON_INVERT_CTL                     (volatile uint32_t *)((0x1bfd  << 2) + 0xff900000)
//
// Closing file:  venc_regs.h
//
//
// Reading file:  enc480p_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// Video Encoder 480p Registers    0xb80 - 0xbef
//===========================================================================
//-------- Video basic setting
#define   ENCP_VIDEO_EN                            (0x1b80)
#define P_ENCP_VIDEO_EN                            (volatile uint32_t *)((0x1b80  << 2) + 0xff900000)
#define   ENCP_VIDEO_SYNC_MODE                     (0x1b81)
#define P_ENCP_VIDEO_SYNC_MODE                     (volatile uint32_t *)((0x1b81  << 2) + 0xff900000)
#define   ENCP_MACV_EN                             (0x1b82)
#define P_ENCP_MACV_EN                             (volatile uint32_t *)((0x1b82  << 2) + 0xff900000)
#define   ENCP_VIDEO_Y_SCL                         (0x1b83)
#define P_ENCP_VIDEO_Y_SCL                         (volatile uint32_t *)((0x1b83  << 2) + 0xff900000)
#define   ENCP_VIDEO_PB_SCL                        (0x1b84)
#define P_ENCP_VIDEO_PB_SCL                        (volatile uint32_t *)((0x1b84  << 2) + 0xff900000)
#define   ENCP_VIDEO_PR_SCL                        (0x1b85)
#define P_ENCP_VIDEO_PR_SCL                        (volatile uint32_t *)((0x1b85  << 2) + 0xff900000)
#define   ENCP_VIDEO_SYNC_SCL                      (0x1b86)
#define P_ENCP_VIDEO_SYNC_SCL                      (volatile uint32_t *)((0x1b86  << 2) + 0xff900000)
#define   ENCP_VIDEO_MACV_SCL                      (0x1b87)
#define P_ENCP_VIDEO_MACV_SCL                      (volatile uint32_t *)((0x1b87  << 2) + 0xff900000)
#define   ENCP_VIDEO_Y_OFFST                       (0x1b88)
#define P_ENCP_VIDEO_Y_OFFST                       (volatile uint32_t *)((0x1b88  << 2) + 0xff900000)
#define   ENCP_VIDEO_PB_OFFST                      (0x1b89)
#define P_ENCP_VIDEO_PB_OFFST                      (volatile uint32_t *)((0x1b89  << 2) + 0xff900000)
#define   ENCP_VIDEO_PR_OFFST                      (0x1b8a)
#define P_ENCP_VIDEO_PR_OFFST                      (volatile uint32_t *)((0x1b8a  << 2) + 0xff900000)
#define   ENCP_VIDEO_SYNC_OFFST                    (0x1b8b)
#define P_ENCP_VIDEO_SYNC_OFFST                    (volatile uint32_t *)((0x1b8b  << 2) + 0xff900000)
#define   ENCP_VIDEO_MACV_OFFST                    (0x1b8c)
#define P_ENCP_VIDEO_MACV_OFFST                    (volatile uint32_t *)((0x1b8c  << 2) + 0xff900000)
//----- Video mode
#define   ENCP_VIDEO_MODE                          (0x1b8d)
#define P_ENCP_VIDEO_MODE                          (volatile uint32_t *)((0x1b8d  << 2) + 0xff900000)
#define   ENCP_VIDEO_MODE_ADV                      (0x1b8e)
#define P_ENCP_VIDEO_MODE_ADV                      (volatile uint32_t *)((0x1b8e  << 2) + 0xff900000)
//--------------- Debug pins
#define   ENCP_DBG_PX_RST                          (0x1b90)
#define P_ENCP_DBG_PX_RST                          (volatile uint32_t *)((0x1b90  << 2) + 0xff900000)
#define   ENCP_DBG_LN_RST                          (0x1b91)
#define P_ENCP_DBG_LN_RST                          (volatile uint32_t *)((0x1b91  << 2) + 0xff900000)
#define   ENCP_DBG_PX_INT                          (0x1b92)
#define P_ENCP_DBG_PX_INT                          (volatile uint32_t *)((0x1b92  << 2) + 0xff900000)
#define   ENCP_DBG_LN_INT                          (0x1b93)
#define P_ENCP_DBG_LN_INT                          (volatile uint32_t *)((0x1b93  << 2) + 0xff900000)
//----------- Video Advanced setting
#define   ENCP_VIDEO_YFP1_HTIME                    (0x1b94)
#define P_ENCP_VIDEO_YFP1_HTIME                    (volatile uint32_t *)((0x1b94  << 2) + 0xff900000)
#define   ENCP_VIDEO_YFP2_HTIME                    (0x1b95)
#define P_ENCP_VIDEO_YFP2_HTIME                    (volatile uint32_t *)((0x1b95  << 2) + 0xff900000)
#define   ENCP_VIDEO_YC_DLY                        (0x1b96)
#define P_ENCP_VIDEO_YC_DLY                        (volatile uint32_t *)((0x1b96  << 2) + 0xff900000)
#define   ENCP_VIDEO_MAX_PXCNT                     (0x1b97)
#define P_ENCP_VIDEO_MAX_PXCNT                     (volatile uint32_t *)((0x1b97  << 2) + 0xff900000)
#define   ENCP_VIDEO_HSPULS_BEGIN                  (0x1b98)
#define P_ENCP_VIDEO_HSPULS_BEGIN                  (volatile uint32_t *)((0x1b98  << 2) + 0xff900000)
#define   ENCP_VIDEO_HSPULS_END                    (0x1b99)
#define P_ENCP_VIDEO_HSPULS_END                    (volatile uint32_t *)((0x1b99  << 2) + 0xff900000)
#define   ENCP_VIDEO_HSPULS_SWITCH                 (0x1b9a)
#define P_ENCP_VIDEO_HSPULS_SWITCH                 (volatile uint32_t *)((0x1b9a  << 2) + 0xff900000)
#define   ENCP_VIDEO_VSPULS_BEGIN                  (0x1b9b)
#define P_ENCP_VIDEO_VSPULS_BEGIN                  (volatile uint32_t *)((0x1b9b  << 2) + 0xff900000)
#define   ENCP_VIDEO_VSPULS_END                    (0x1b9c)
#define P_ENCP_VIDEO_VSPULS_END                    (volatile uint32_t *)((0x1b9c  << 2) + 0xff900000)
#define   ENCP_VIDEO_VSPULS_BLINE                  (0x1b9d)
#define P_ENCP_VIDEO_VSPULS_BLINE                  (volatile uint32_t *)((0x1b9d  << 2) + 0xff900000)
#define   ENCP_VIDEO_VSPULS_ELINE                  (0x1b9e)
#define P_ENCP_VIDEO_VSPULS_ELINE                  (volatile uint32_t *)((0x1b9e  << 2) + 0xff900000)
#define   ENCP_VIDEO_EQPULS_BEGIN                  (0x1b9f)
#define P_ENCP_VIDEO_EQPULS_BEGIN                  (volatile uint32_t *)((0x1b9f  << 2) + 0xff900000)
#define   ENCP_VIDEO_EQPULS_END                    (0x1ba0)
#define P_ENCP_VIDEO_EQPULS_END                    (volatile uint32_t *)((0x1ba0  << 2) + 0xff900000)
#define   ENCP_VIDEO_EQPULS_BLINE                  (0x1ba1)
#define P_ENCP_VIDEO_EQPULS_BLINE                  (volatile uint32_t *)((0x1ba1  << 2) + 0xff900000)
#define   ENCP_VIDEO_EQPULS_ELINE                  (0x1ba2)
#define P_ENCP_VIDEO_EQPULS_ELINE                  (volatile uint32_t *)((0x1ba2  << 2) + 0xff900000)
#define   ENCP_VIDEO_HAVON_END                     (0x1ba3)
#define P_ENCP_VIDEO_HAVON_END                     (volatile uint32_t *)((0x1ba3  << 2) + 0xff900000)
#define   ENCP_VIDEO_HAVON_BEGIN                   (0x1ba4)
#define P_ENCP_VIDEO_HAVON_BEGIN                   (volatile uint32_t *)((0x1ba4  << 2) + 0xff900000)
#define   ENCP_VIDEO_VAVON_ELINE                   (0x1baf)
#define P_ENCP_VIDEO_VAVON_ELINE                   (volatile uint32_t *)((0x1baf  << 2) + 0xff900000)
#define   ENCP_VIDEO_VAVON_BLINE                   (0x1ba6)
#define P_ENCP_VIDEO_VAVON_BLINE                   (volatile uint32_t *)((0x1ba6  << 2) + 0xff900000)
#define   ENCP_VIDEO_HSO_BEGIN                     (0x1ba7)
#define P_ENCP_VIDEO_HSO_BEGIN                     (volatile uint32_t *)((0x1ba7  << 2) + 0xff900000)
#define   ENCP_VIDEO_HSO_END                       (0x1ba8)
#define P_ENCP_VIDEO_HSO_END                       (volatile uint32_t *)((0x1ba8  << 2) + 0xff900000)
#define   ENCP_VIDEO_VSO_BEGIN                     (0x1ba9)
#define P_ENCP_VIDEO_VSO_BEGIN                     (volatile uint32_t *)((0x1ba9  << 2) + 0xff900000)
#define   ENCP_VIDEO_VSO_END                       (0x1baa)
#define P_ENCP_VIDEO_VSO_END                       (volatile uint32_t *)((0x1baa  << 2) + 0xff900000)
#define   ENCP_VIDEO_VSO_BLINE                     (0x1bab)
#define P_ENCP_VIDEO_VSO_BLINE                     (volatile uint32_t *)((0x1bab  << 2) + 0xff900000)
#define   ENCP_VIDEO_VSO_ELINE                     (0x1bac)
#define P_ENCP_VIDEO_VSO_ELINE                     (volatile uint32_t *)((0x1bac  << 2) + 0xff900000)
#define   ENCP_VIDEO_SYNC_WAVE_CURVE               (0x1bad)
#define P_ENCP_VIDEO_SYNC_WAVE_CURVE               (volatile uint32_t *)((0x1bad  << 2) + 0xff900000)
#define   ENCP_VIDEO_MAX_LNCNT                     (0x1bae)
#define P_ENCP_VIDEO_MAX_LNCNT                     (volatile uint32_t *)((0x1bae  << 2) + 0xff900000)
#define   ENCP_VIDEO_SY_VAL                        (0x1bb0)
#define P_ENCP_VIDEO_SY_VAL                        (volatile uint32_t *)((0x1bb0  << 2) + 0xff900000)
#define   ENCP_VIDEO_SY2_VAL                       (0x1bb1)
#define P_ENCP_VIDEO_SY2_VAL                       (volatile uint32_t *)((0x1bb1  << 2) + 0xff900000)
#define   ENCP_VIDEO_BLANKY_VAL                    (0x1bb2)
#define P_ENCP_VIDEO_BLANKY_VAL                    (volatile uint32_t *)((0x1bb2  << 2) + 0xff900000)
#define   ENCP_VIDEO_BLANKPB_VAL                   (0x1bb3)
#define P_ENCP_VIDEO_BLANKPB_VAL                   (volatile uint32_t *)((0x1bb3  << 2) + 0xff900000)
#define   ENCP_VIDEO_BLANKPR_VAL                   (0x1bb4)
#define P_ENCP_VIDEO_BLANKPR_VAL                   (volatile uint32_t *)((0x1bb4  << 2) + 0xff900000)
#define   ENCP_VIDEO_HOFFST                        (0x1bb5)
#define P_ENCP_VIDEO_HOFFST                        (volatile uint32_t *)((0x1bb5  << 2) + 0xff900000)
#define   ENCP_VIDEO_VOFFST                        (0x1bb6)
#define P_ENCP_VIDEO_VOFFST                        (volatile uint32_t *)((0x1bb6  << 2) + 0xff900000)
#define   ENCP_VIDEO_RGB_CTRL                      (0x1bb7)
#define P_ENCP_VIDEO_RGB_CTRL                      (volatile uint32_t *)((0x1bb7  << 2) + 0xff900000)
#define   ENCP_VIDEO_FILT_CTRL                     (0x1bb8)
#define P_ENCP_VIDEO_FILT_CTRL                     (volatile uint32_t *)((0x1bb8  << 2) + 0xff900000)
#define   ENCP_VIDEO_OFLD_VPEQ_OFST                (0x1bb9)
#define P_ENCP_VIDEO_OFLD_VPEQ_OFST                (volatile uint32_t *)((0x1bb9  << 2) + 0xff900000)
#define   ENCP_VIDEO_OFLD_VOAV_OFST                (0x1bba)
#define P_ENCP_VIDEO_OFLD_VOAV_OFST                (volatile uint32_t *)((0x1bba  << 2) + 0xff900000)
#define   ENCP_VIDEO_MATRIX_CB                     (0x1bbb)
#define P_ENCP_VIDEO_MATRIX_CB                     (volatile uint32_t *)((0x1bbb  << 2) + 0xff900000)
#define   ENCP_VIDEO_MATRIX_CR                     (0x1bbc)
#define P_ENCP_VIDEO_MATRIX_CR                     (volatile uint32_t *)((0x1bbc  << 2) + 0xff900000)
#define   ENCP_VIDEO_RGBIN_CTRL                    (0x1bbd)
#define P_ENCP_VIDEO_RGBIN_CTRL                    (volatile uint32_t *)((0x1bbd  << 2) + 0xff900000)
//------------------Macrovision advanced setting
#define   ENCP_MACV_BLANKY_VAL                     (0x1bc0)
#define P_ENCP_MACV_BLANKY_VAL                     (volatile uint32_t *)((0x1bc0  << 2) + 0xff900000)
#define   ENCP_MACV_MAXY_VAL                       (0x1bc1)
#define P_ENCP_MACV_MAXY_VAL                       (volatile uint32_t *)((0x1bc1  << 2) + 0xff900000)
#define   ENCP_MACV_1ST_PSSYNC_STRT                (0x1bc2)
#define P_ENCP_MACV_1ST_PSSYNC_STRT                (volatile uint32_t *)((0x1bc2  << 2) + 0xff900000)
#define   ENCP_MACV_PSSYNC_STRT                    (0x1bc3)
#define P_ENCP_MACV_PSSYNC_STRT                    (volatile uint32_t *)((0x1bc3  << 2) + 0xff900000)
#define   ENCP_MACV_AGC_STRT                       (0x1bc4)
#define P_ENCP_MACV_AGC_STRT                       (volatile uint32_t *)((0x1bc4  << 2) + 0xff900000)
#define   ENCP_MACV_AGC_END                        (0x1bc5)
#define P_ENCP_MACV_AGC_END                        (volatile uint32_t *)((0x1bc5  << 2) + 0xff900000)
#define   ENCP_MACV_WAVE_END                       (0x1bc6)
#define P_ENCP_MACV_WAVE_END                       (volatile uint32_t *)((0x1bc6  << 2) + 0xff900000)
#define   ENCP_MACV_STRTLINE                       (0x1bc7)
#define P_ENCP_MACV_STRTLINE                       (volatile uint32_t *)((0x1bc7  << 2) + 0xff900000)
#define   ENCP_MACV_ENDLINE                        (0x1bc8)
#define P_ENCP_MACV_ENDLINE                        (volatile uint32_t *)((0x1bc8  << 2) + 0xff900000)
#define   ENCP_MACV_TS_CNT_MAX_L                   (0x1bc9)
#define P_ENCP_MACV_TS_CNT_MAX_L                   (volatile uint32_t *)((0x1bc9  << 2) + 0xff900000)
#define   ENCP_MACV_TS_CNT_MAX_H                   (0x1bca)
#define P_ENCP_MACV_TS_CNT_MAX_H                   (volatile uint32_t *)((0x1bca  << 2) + 0xff900000)
#define   ENCP_MACV_TIME_DOWN                      (0x1bcb)
#define P_ENCP_MACV_TIME_DOWN                      (volatile uint32_t *)((0x1bcb  << 2) + 0xff900000)
#define   ENCP_MACV_TIME_LO                        (0x1bcc)
#define P_ENCP_MACV_TIME_LO                        (volatile uint32_t *)((0x1bcc  << 2) + 0xff900000)
#define   ENCP_MACV_TIME_UP                        (0x1bcd)
#define P_ENCP_MACV_TIME_UP                        (volatile uint32_t *)((0x1bcd  << 2) + 0xff900000)
#define   ENCP_MACV_TIME_RST                       (0x1bce)
#define P_ENCP_MACV_TIME_RST                       (volatile uint32_t *)((0x1bce  << 2) + 0xff900000)
//---------------- VBI control -------------------
#define   ENCP_VBI_CTRL                            (0x1bd0)
#define P_ENCP_VBI_CTRL                            (volatile uint32_t *)((0x1bd0  << 2) + 0xff900000)
#define   ENCP_VBI_SETTING                         (0x1bd1)
#define P_ENCP_VBI_SETTING                         (volatile uint32_t *)((0x1bd1  << 2) + 0xff900000)
#define   ENCP_VBI_BEGIN                           (0x1bd2)
#define P_ENCP_VBI_BEGIN                           (volatile uint32_t *)((0x1bd2  << 2) + 0xff900000)
#define   ENCP_VBI_WIDTH                           (0x1bd3)
#define P_ENCP_VBI_WIDTH                           (volatile uint32_t *)((0x1bd3  << 2) + 0xff900000)
#define   ENCP_VBI_HVAL                            (0x1bd4)
#define P_ENCP_VBI_HVAL                            (volatile uint32_t *)((0x1bd4  << 2) + 0xff900000)
#define   ENCP_VBI_DATA0                           (0x1bd5)
#define P_ENCP_VBI_DATA0                           (volatile uint32_t *)((0x1bd5  << 2) + 0xff900000)
#define   ENCP_VBI_DATA1                           (0x1bd6)
#define P_ENCP_VBI_DATA1                           (volatile uint32_t *)((0x1bd6  << 2) + 0xff900000)
//----------------C656 OUT Control------------- Grant
#define   C656_HS_ST                               (0x1be0)
#define P_C656_HS_ST                               (volatile uint32_t *)((0x1be0  << 2) + 0xff900000)
#define   C656_HS_ED                               (0x1be1)
#define P_C656_HS_ED                               (volatile uint32_t *)((0x1be1  << 2) + 0xff900000)
#define   C656_VS_LNST_E                           (0x1be2)
#define P_C656_VS_LNST_E                           (volatile uint32_t *)((0x1be2  << 2) + 0xff900000)
#define   C656_VS_LNST_O                           (0x1be3)
#define P_C656_VS_LNST_O                           (volatile uint32_t *)((0x1be3  << 2) + 0xff900000)
#define   C656_VS_LNED_E                           (0x1be4)
#define P_C656_VS_LNED_E                           (volatile uint32_t *)((0x1be4  << 2) + 0xff900000)
#define   C656_VS_LNED_O                           (0x1be5)
#define P_C656_VS_LNED_O                           (volatile uint32_t *)((0x1be5  << 2) + 0xff900000)
#define   C656_FS_LNST                             (0x1be6)
#define P_C656_FS_LNST                             (volatile uint32_t *)((0x1be6  << 2) + 0xff900000)
#define   C656_FS_LNED                             (0x1be7)
#define P_C656_FS_LNED                             (volatile uint32_t *)((0x1be7  << 2) + 0xff900000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  enc480p_regs.h
//
//
// Reading file:  enci_regs.h
//
//===========================================================================
// Video Interface Registers    0xb00 - 0xb57
//===========================================================================
#define   ENCI_VIDEO_MODE                          (0x1b00)
#define P_ENCI_VIDEO_MODE                          (volatile uint32_t *)((0x1b00  << 2) + 0xff900000)
#define   ENCI_VIDEO_MODE_ADV                      (0x1b01)
#define P_ENCI_VIDEO_MODE_ADV                      (volatile uint32_t *)((0x1b01  << 2) + 0xff900000)
#define   ENCI_VIDEO_FSC_ADJ                       (0x1b02)
#define P_ENCI_VIDEO_FSC_ADJ                       (volatile uint32_t *)((0x1b02  << 2) + 0xff900000)
#define   ENCI_VIDEO_BRIGHT                        (0x1b03)
#define P_ENCI_VIDEO_BRIGHT                        (volatile uint32_t *)((0x1b03  << 2) + 0xff900000)
#define   ENCI_VIDEO_CONT                          (0x1b04)
#define P_ENCI_VIDEO_CONT                          (volatile uint32_t *)((0x1b04  << 2) + 0xff900000)
#define   ENCI_VIDEO_SAT                           (0x1b05)
#define P_ENCI_VIDEO_SAT                           (volatile uint32_t *)((0x1b05  << 2) + 0xff900000)
#define   ENCI_VIDEO_HUE                           (0x1b06)
#define P_ENCI_VIDEO_HUE                           (volatile uint32_t *)((0x1b06  << 2) + 0xff900000)
#define   ENCI_VIDEO_SCH                           (0x1b07)
#define P_ENCI_VIDEO_SCH                           (volatile uint32_t *)((0x1b07  << 2) + 0xff900000)
#define   ENCI_SYNC_MODE                           (0x1b08)
#define P_ENCI_SYNC_MODE                           (volatile uint32_t *)((0x1b08  << 2) + 0xff900000)
#define   ENCI_SYNC_CTRL                           (0x1b09)
#define P_ENCI_SYNC_CTRL                           (volatile uint32_t *)((0x1b09  << 2) + 0xff900000)
#define   ENCI_SYNC_HSO_BEGIN                      (0x1b0a)
#define P_ENCI_SYNC_HSO_BEGIN                      (volatile uint32_t *)((0x1b0a  << 2) + 0xff900000)
#define   ENCI_SYNC_HSO_END                        (0x1b0b)
#define P_ENCI_SYNC_HSO_END                        (volatile uint32_t *)((0x1b0b  << 2) + 0xff900000)
#define   ENCI_SYNC_VSO_EVN                        (0x1b0c)
#define P_ENCI_SYNC_VSO_EVN                        (volatile uint32_t *)((0x1b0c  << 2) + 0xff900000)
#define   ENCI_SYNC_VSO_ODD                        (0x1b0d)
#define P_ENCI_SYNC_VSO_ODD                        (volatile uint32_t *)((0x1b0d  << 2) + 0xff900000)
#define   ENCI_SYNC_VSO_EVNLN                      (0x1b0e)
#define P_ENCI_SYNC_VSO_EVNLN                      (volatile uint32_t *)((0x1b0e  << 2) + 0xff900000)
#define   ENCI_SYNC_VSO_ODDLN                      (0x1b0f)
#define P_ENCI_SYNC_VSO_ODDLN                      (volatile uint32_t *)((0x1b0f  << 2) + 0xff900000)
#define   ENCI_SYNC_HOFFST                         (0x1b10)
#define P_ENCI_SYNC_HOFFST                         (volatile uint32_t *)((0x1b10  << 2) + 0xff900000)
#define   ENCI_SYNC_VOFFST                         (0x1b11)
#define P_ENCI_SYNC_VOFFST                         (volatile uint32_t *)((0x1b11  << 2) + 0xff900000)
#define   ENCI_SYNC_ADJ                            (0x1b12)
#define P_ENCI_SYNC_ADJ                            (volatile uint32_t *)((0x1b12  << 2) + 0xff900000)
#define   ENCI_RGB_SETTING                         (0x1b13)
#define P_ENCI_RGB_SETTING                         (volatile uint32_t *)((0x1b13  << 2) + 0xff900000)
//`define   ENCI_CMPN_MATRIX_CB     8'h14
//`define   ENCI_CMPN_MATRIX_CR     8'h15
#define   ENCI_DE_H_BEGIN                          (0x1b16)
#define P_ENCI_DE_H_BEGIN                          (volatile uint32_t *)((0x1b16  << 2) + 0xff900000)
#define   ENCI_DE_H_END                            (0x1b17)
#define P_ENCI_DE_H_END                            (volatile uint32_t *)((0x1b17  << 2) + 0xff900000)
#define   ENCI_DE_V_BEGIN_EVEN                     (0x1b18)
#define P_ENCI_DE_V_BEGIN_EVEN                     (volatile uint32_t *)((0x1b18  << 2) + 0xff900000)
#define   ENCI_DE_V_END_EVEN                       (0x1b19)
#define P_ENCI_DE_V_END_EVEN                       (volatile uint32_t *)((0x1b19  << 2) + 0xff900000)
#define   ENCI_DE_V_BEGIN_ODD                      (0x1b1a)
#define P_ENCI_DE_V_BEGIN_ODD                      (volatile uint32_t *)((0x1b1a  << 2) + 0xff900000)
#define   ENCI_DE_V_END_ODD                        (0x1b1b)
#define P_ENCI_DE_V_END_ODD                        (volatile uint32_t *)((0x1b1b  << 2) + 0xff900000)
#define   ENCI_VBI_SETTING                         (0x1b20)
#define P_ENCI_VBI_SETTING                         (volatile uint32_t *)((0x1b20  << 2) + 0xff900000)
#define   ENCI_VBI_CCDT_EVN                        (0x1b21)
#define P_ENCI_VBI_CCDT_EVN                        (volatile uint32_t *)((0x1b21  << 2) + 0xff900000)
#define   ENCI_VBI_CCDT_ODD                        (0x1b22)
#define P_ENCI_VBI_CCDT_ODD                        (volatile uint32_t *)((0x1b22  << 2) + 0xff900000)
#define   ENCI_VBI_CC525_LN                        (0x1b23)
#define P_ENCI_VBI_CC525_LN                        (volatile uint32_t *)((0x1b23  << 2) + 0xff900000)
#define   ENCI_VBI_CC625_LN                        (0x1b24)
#define P_ENCI_VBI_CC625_LN                        (volatile uint32_t *)((0x1b24  << 2) + 0xff900000)
#define   ENCI_VBI_WSSDT                           (0x1b25)
#define P_ENCI_VBI_WSSDT                           (volatile uint32_t *)((0x1b25  << 2) + 0xff900000)
#define   ENCI_VBI_WSS_LN                          (0x1b26)
#define P_ENCI_VBI_WSS_LN                          (volatile uint32_t *)((0x1b26  << 2) + 0xff900000)
#define   ENCI_VBI_CGMSDT_L                        (0x1b27)
#define P_ENCI_VBI_CGMSDT_L                        (volatile uint32_t *)((0x1b27  << 2) + 0xff900000)
#define   ENCI_VBI_CGMSDT_H                        (0x1b28)
#define P_ENCI_VBI_CGMSDT_H                        (volatile uint32_t *)((0x1b28  << 2) + 0xff900000)
#define   ENCI_VBI_CGMS_LN                         (0x1b29)
#define P_ENCI_VBI_CGMS_LN                         (volatile uint32_t *)((0x1b29  << 2) + 0xff900000)
#define   ENCI_VBI_TTX_HTIME                       (0x1b2a)
#define P_ENCI_VBI_TTX_HTIME                       (volatile uint32_t *)((0x1b2a  << 2) + 0xff900000)
#define   ENCI_VBI_TTX_LN                          (0x1b2b)
#define P_ENCI_VBI_TTX_LN                          (volatile uint32_t *)((0x1b2b  << 2) + 0xff900000)
#define   ENCI_VBI_TTXDT0                          (0x1b2c)
#define P_ENCI_VBI_TTXDT0                          (volatile uint32_t *)((0x1b2c  << 2) + 0xff900000)
#define   ENCI_VBI_TTXDT1                          (0x1b2d)
#define P_ENCI_VBI_TTXDT1                          (volatile uint32_t *)((0x1b2d  << 2) + 0xff900000)
#define   ENCI_VBI_TTXDT2                          (0x1b2e)
#define P_ENCI_VBI_TTXDT2                          (volatile uint32_t *)((0x1b2e  << 2) + 0xff900000)
#define   ENCI_VBI_TTXDT3                          (0x1b2f)
#define P_ENCI_VBI_TTXDT3                          (volatile uint32_t *)((0x1b2f  << 2) + 0xff900000)
#define   ENCI_MACV_N0                             (0x1b30)
#define P_ENCI_MACV_N0                             (volatile uint32_t *)((0x1b30  << 2) + 0xff900000)
#define   ENCI_MACV_N1                             (0x1b31)
#define P_ENCI_MACV_N1                             (volatile uint32_t *)((0x1b31  << 2) + 0xff900000)
#define   ENCI_MACV_N2                             (0x1b32)
#define P_ENCI_MACV_N2                             (volatile uint32_t *)((0x1b32  << 2) + 0xff900000)
#define   ENCI_MACV_N3                             (0x1b33)
#define P_ENCI_MACV_N3                             (volatile uint32_t *)((0x1b33  << 2) + 0xff900000)
#define   ENCI_MACV_N4                             (0x1b34)
#define P_ENCI_MACV_N4                             (volatile uint32_t *)((0x1b34  << 2) + 0xff900000)
#define   ENCI_MACV_N5                             (0x1b35)
#define P_ENCI_MACV_N5                             (volatile uint32_t *)((0x1b35  << 2) + 0xff900000)
#define   ENCI_MACV_N6                             (0x1b36)
#define P_ENCI_MACV_N6                             (volatile uint32_t *)((0x1b36  << 2) + 0xff900000)
#define   ENCI_MACV_N7                             (0x1b37)
#define P_ENCI_MACV_N7                             (volatile uint32_t *)((0x1b37  << 2) + 0xff900000)
#define   ENCI_MACV_N8                             (0x1b38)
#define P_ENCI_MACV_N8                             (volatile uint32_t *)((0x1b38  << 2) + 0xff900000)
#define   ENCI_MACV_N9                             (0x1b39)
#define P_ENCI_MACV_N9                             (volatile uint32_t *)((0x1b39  << 2) + 0xff900000)
#define   ENCI_MACV_N10                            (0x1b3a)
#define P_ENCI_MACV_N10                            (volatile uint32_t *)((0x1b3a  << 2) + 0xff900000)
#define   ENCI_MACV_N11                            (0x1b3b)
#define P_ENCI_MACV_N11                            (volatile uint32_t *)((0x1b3b  << 2) + 0xff900000)
#define   ENCI_MACV_N12                            (0x1b3c)
#define P_ENCI_MACV_N12                            (volatile uint32_t *)((0x1b3c  << 2) + 0xff900000)
#define   ENCI_MACV_N13                            (0x1b3d)
#define P_ENCI_MACV_N13                            (volatile uint32_t *)((0x1b3d  << 2) + 0xff900000)
#define   ENCI_MACV_N14                            (0x1b3e)
#define P_ENCI_MACV_N14                            (volatile uint32_t *)((0x1b3e  << 2) + 0xff900000)
#define   ENCI_MACV_N15                            (0x1b3f)
#define P_ENCI_MACV_N15                            (volatile uint32_t *)((0x1b3f  << 2) + 0xff900000)
#define   ENCI_MACV_N16                            (0x1b40)
#define P_ENCI_MACV_N16                            (volatile uint32_t *)((0x1b40  << 2) + 0xff900000)
#define   ENCI_MACV_N17                            (0x1b41)
#define P_ENCI_MACV_N17                            (volatile uint32_t *)((0x1b41  << 2) + 0xff900000)
#define   ENCI_MACV_N18                            (0x1b42)
#define P_ENCI_MACV_N18                            (volatile uint32_t *)((0x1b42  << 2) + 0xff900000)
#define   ENCI_MACV_N19                            (0x1b43)
#define P_ENCI_MACV_N19                            (volatile uint32_t *)((0x1b43  << 2) + 0xff900000)
#define   ENCI_MACV_N20                            (0x1b44)
#define P_ENCI_MACV_N20                            (volatile uint32_t *)((0x1b44  << 2) + 0xff900000)
#define   ENCI_MACV_N21                            (0x1b45)
#define P_ENCI_MACV_N21                            (volatile uint32_t *)((0x1b45  << 2) + 0xff900000)
#define   ENCI_MACV_N22                            (0x1b46)
#define P_ENCI_MACV_N22                            (volatile uint32_t *)((0x1b46  << 2) + 0xff900000)
//`define   ENCI_MACV_P_AGC         8'h47
#define   ENCI_DBG_PX_RST                          (0x1b48)
#define P_ENCI_DBG_PX_RST                          (volatile uint32_t *)((0x1b48  << 2) + 0xff900000)
#define   ENCI_DBG_FLDLN_RST                       (0x1b49)
#define P_ENCI_DBG_FLDLN_RST                       (volatile uint32_t *)((0x1b49  << 2) + 0xff900000)
#define   ENCI_DBG_PX_INT                          (0x1b4a)
#define P_ENCI_DBG_PX_INT                          (volatile uint32_t *)((0x1b4a  << 2) + 0xff900000)
#define   ENCI_DBG_FLDLN_INT                       (0x1b4b)
#define P_ENCI_DBG_FLDLN_INT                       (volatile uint32_t *)((0x1b4b  << 2) + 0xff900000)
#define   ENCI_DBG_MAXPX                           (0x1b4c)
#define P_ENCI_DBG_MAXPX                           (volatile uint32_t *)((0x1b4c  << 2) + 0xff900000)
#define   ENCI_DBG_MAXLN                           (0x1b4d)
#define P_ENCI_DBG_MAXLN                           (volatile uint32_t *)((0x1b4d  << 2) + 0xff900000)
#define   ENCI_MACV_MAX_AMP                        (0x1b50)
#define P_ENCI_MACV_MAX_AMP                        (volatile uint32_t *)((0x1b50  << 2) + 0xff900000)
#define   ENCI_MACV_PULSE_LO                       (0x1b51)
#define P_ENCI_MACV_PULSE_LO                       (volatile uint32_t *)((0x1b51  << 2) + 0xff900000)
#define   ENCI_MACV_PULSE_HI                       (0x1b52)
#define P_ENCI_MACV_PULSE_HI                       (volatile uint32_t *)((0x1b52  << 2) + 0xff900000)
#define   ENCI_MACV_BKP_MAX                        (0x1b53)
#define P_ENCI_MACV_BKP_MAX                        (volatile uint32_t *)((0x1b53  << 2) + 0xff900000)
#define   ENCI_CFILT_CTRL                          (0x1b54)
#define P_ENCI_CFILT_CTRL                          (volatile uint32_t *)((0x1b54  << 2) + 0xff900000)
#define   ENCI_CFILT7                              (0x1b55)
#define P_ENCI_CFILT7                              (volatile uint32_t *)((0x1b55  << 2) + 0xff900000)
#define   ENCI_YC_DELAY                            (0x1b56)
#define P_ENCI_YC_DELAY                            (volatile uint32_t *)((0x1b56  << 2) + 0xff900000)
#define   ENCI_VIDEO_EN                            (0x1b57)
#define P_ENCI_VIDEO_EN                            (volatile uint32_t *)((0x1b57  << 2) + 0xff900000)
//
// Closing file:  enci_regs.h
//
//`define  VENC2_VCBUS_BASE             8'h1c
//
// Reading file:  venc2_regs.h
//
//===========================================================================
// Venc Registers (Cont.)    0xc00 - 0xcff (VENC registers 0xc00 - 0xcef)
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VENC2_VCBUS_BASE = 0x1c
// -----------------------------------------------
// Program video control signals from ENCI core to DVI/HDMI interface
#define   ENCI_DVI_HSO_BEGIN                       (0x1c00)
#define P_ENCI_DVI_HSO_BEGIN                       (volatile uint32_t *)((0x1c00  << 2) + 0xff900000)
#define   ENCI_DVI_HSO_END                         (0x1c01)
#define P_ENCI_DVI_HSO_END                         (volatile uint32_t *)((0x1c01  << 2) + 0xff900000)
#define   ENCI_DVI_VSO_BLINE_EVN                   (0x1c02)
#define P_ENCI_DVI_VSO_BLINE_EVN                   (volatile uint32_t *)((0x1c02  << 2) + 0xff900000)
#define   ENCI_DVI_VSO_BLINE_ODD                   (0x1c03)
#define P_ENCI_DVI_VSO_BLINE_ODD                   (volatile uint32_t *)((0x1c03  << 2) + 0xff900000)
#define   ENCI_DVI_VSO_ELINE_EVN                   (0x1c04)
#define P_ENCI_DVI_VSO_ELINE_EVN                   (volatile uint32_t *)((0x1c04  << 2) + 0xff900000)
#define   ENCI_DVI_VSO_ELINE_ODD                   (0x1c05)
#define P_ENCI_DVI_VSO_ELINE_ODD                   (volatile uint32_t *)((0x1c05  << 2) + 0xff900000)
#define   ENCI_DVI_VSO_BEGIN_EVN                   (0x1c06)
#define P_ENCI_DVI_VSO_BEGIN_EVN                   (volatile uint32_t *)((0x1c06  << 2) + 0xff900000)
#define   ENCI_DVI_VSO_BEGIN_ODD                   (0x1c07)
#define P_ENCI_DVI_VSO_BEGIN_ODD                   (volatile uint32_t *)((0x1c07  << 2) + 0xff900000)
#define   ENCI_DVI_VSO_END_EVN                     (0x1c08)
#define P_ENCI_DVI_VSO_END_EVN                     (volatile uint32_t *)((0x1c08  << 2) + 0xff900000)
#define   ENCI_DVI_VSO_END_ODD                     (0x1c09)
#define P_ENCI_DVI_VSO_END_ODD                     (volatile uint32_t *)((0x1c09  << 2) + 0xff900000)
// Define cmpt and cvbs cb/cr delay after ENCI chroma filters
// Bit 15:12 RW, enci_cb_cvbs_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit 11: 8 RW, enci_cr_cvbs_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit  7: 4 RW, enci_cb_cmpt_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit  3: 0 RW, enci_cr_cmpt_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
#define   ENCI_CFILT_CTRL2                         (0x1c0a)
#define P_ENCI_CFILT_CTRL2                         (volatile uint32_t *)((0x1c0a  << 2) + 0xff900000)
#define   ENCI_DACSEL_0                            (0x1c0b)
#define P_ENCI_DACSEL_0                            (volatile uint32_t *)((0x1c0b  << 2) + 0xff900000)
#define   ENCI_DACSEL_1                            (0x1c0c)
#define P_ENCI_DACSEL_1                            (volatile uint32_t *)((0x1c0c  << 2) + 0xff900000)
#define   ENCP_DACSEL_0                            (0x1c0d)
#define P_ENCP_DACSEL_0                            (volatile uint32_t *)((0x1c0d  << 2) + 0xff900000)
#define   ENCP_DACSEL_1                            (0x1c0e)
#define P_ENCP_DACSEL_1                            (volatile uint32_t *)((0x1c0e  << 2) + 0xff900000)
#define   ENCP_MAX_LINE_SWITCH_POINT               (0x1c0f)
#define P_ENCP_MAX_LINE_SWITCH_POINT               (volatile uint32_t *)((0x1c0f  << 2) + 0xff900000)
#define   ENCI_TST_EN                              (0x1c10)
#define P_ENCI_TST_EN                              (volatile uint32_t *)((0x1c10  << 2) + 0xff900000)
#define   ENCI_TST_MDSEL                           (0x1c11)
#define P_ENCI_TST_MDSEL                           (volatile uint32_t *)((0x1c11  << 2) + 0xff900000)
#define   ENCI_TST_Y                               (0x1c12)
#define P_ENCI_TST_Y                               (volatile uint32_t *)((0x1c12  << 2) + 0xff900000)
#define   ENCI_TST_CB                              (0x1c13)
#define P_ENCI_TST_CB                              (volatile uint32_t *)((0x1c13  << 2) + 0xff900000)
#define   ENCI_TST_CR                              (0x1c14)
#define P_ENCI_TST_CR                              (volatile uint32_t *)((0x1c14  << 2) + 0xff900000)
#define   ENCI_TST_CLRBAR_STRT                     (0x1c15)
#define P_ENCI_TST_CLRBAR_STRT                     (volatile uint32_t *)((0x1c15  << 2) + 0xff900000)
#define   ENCI_TST_CLRBAR_WIDTH                    (0x1c16)
#define P_ENCI_TST_CLRBAR_WIDTH                    (volatile uint32_t *)((0x1c16  << 2) + 0xff900000)
#define   ENCI_TST_VDCNT_STSET                     (0x1c17)
#define P_ENCI_TST_VDCNT_STSET                     (volatile uint32_t *)((0x1c17  << 2) + 0xff900000)
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define   ENCI_VFIFO2VD_CTL                        (0x1c18)
#define P_ENCI_VFIFO2VD_CTL                        (volatile uint32_t *)((0x1c18  << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define   ENCI_VFIFO2VD_PIXEL_START                (0x1c19)
#define P_ENCI_VFIFO2VD_PIXEL_START                (volatile uint32_t *)((0x1c19  << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define   ENCI_VFIFO2VD_PIXEL_END                  (0x1c1a)
#define P_ENCI_VFIFO2VD_PIXEL_END                  (volatile uint32_t *)((0x1c1a  << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define   ENCI_VFIFO2VD_LINE_TOP_START             (0x1c1b)
#define P_ENCI_VFIFO2VD_LINE_TOP_START             (volatile uint32_t *)((0x1c1b  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define   ENCI_VFIFO2VD_LINE_TOP_END               (0x1c1c)
#define P_ENCI_VFIFO2VD_LINE_TOP_END               (volatile uint32_t *)((0x1c1c  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define   ENCI_VFIFO2VD_LINE_BOT_START             (0x1c1d)
#define P_ENCI_VFIFO2VD_LINE_BOT_START             (volatile uint32_t *)((0x1c1d  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define   ENCI_VFIFO2VD_LINE_BOT_END               (0x1c1e)
#define P_ENCI_VFIFO2VD_LINE_BOT_END               (volatile uint32_t *)((0x1c1e  << 2) + 0xff900000)
#define   ENCI_VFIFO2VD_CTL2                       (0x1c1f)
#define P_ENCI_VFIFO2VD_CTL2                       (volatile uint32_t *)((0x1c1f  << 2) + 0xff900000)
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define   ENCT_VFIFO2VD_CTL                        (0x1c20)
#define P_ENCT_VFIFO2VD_CTL                        (volatile uint32_t *)((0x1c20  << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define   ENCT_VFIFO2VD_PIXEL_START                (0x1c21)
#define P_ENCT_VFIFO2VD_PIXEL_START                (volatile uint32_t *)((0x1c21  << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define   ENCT_VFIFO2VD_PIXEL_END                  (0x1c22)
#define P_ENCT_VFIFO2VD_PIXEL_END                  (volatile uint32_t *)((0x1c22  << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define   ENCT_VFIFO2VD_LINE_TOP_START             (0x1c23)
#define P_ENCT_VFIFO2VD_LINE_TOP_START             (volatile uint32_t *)((0x1c23  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define   ENCT_VFIFO2VD_LINE_TOP_END               (0x1c24)
#define P_ENCT_VFIFO2VD_LINE_TOP_END               (volatile uint32_t *)((0x1c24  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define   ENCT_VFIFO2VD_LINE_BOT_START             (0x1c25)
#define P_ENCT_VFIFO2VD_LINE_BOT_START             (volatile uint32_t *)((0x1c25  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define   ENCT_VFIFO2VD_LINE_BOT_END               (0x1c26)
#define P_ENCT_VFIFO2VD_LINE_BOT_END               (volatile uint32_t *)((0x1c26  << 2) + 0xff900000)
#define   ENCT_VFIFO2VD_CTL2                       (0x1c27)
#define P_ENCT_VFIFO2VD_CTL2                       (volatile uint32_t *)((0x1c27  << 2) + 0xff900000)
#define   ENCT_TST_EN                              (0x1c28)
#define P_ENCT_TST_EN                              (volatile uint32_t *)((0x1c28  << 2) + 0xff900000)
#define   ENCT_TST_MDSEL                           (0x1c29)
#define P_ENCT_TST_MDSEL                           (volatile uint32_t *)((0x1c29  << 2) + 0xff900000)
#define   ENCT_TST_Y                               (0x1c2a)
#define P_ENCT_TST_Y                               (volatile uint32_t *)((0x1c2a  << 2) + 0xff900000)
#define   ENCT_TST_CB                              (0x1c2b)
#define P_ENCT_TST_CB                              (volatile uint32_t *)((0x1c2b  << 2) + 0xff900000)
#define   ENCT_TST_CR                              (0x1c2c)
#define P_ENCT_TST_CR                              (volatile uint32_t *)((0x1c2c  << 2) + 0xff900000)
#define   ENCT_TST_CLRBAR_STRT                     (0x1c2d)
#define P_ENCT_TST_CLRBAR_STRT                     (volatile uint32_t *)((0x1c2d  << 2) + 0xff900000)
#define   ENCT_TST_CLRBAR_WIDTH                    (0x1c2e)
#define P_ENCT_TST_CLRBAR_WIDTH                    (volatile uint32_t *)((0x1c2e  << 2) + 0xff900000)
#define   ENCT_TST_VDCNT_STSET                     (0x1c2f)
#define P_ENCT_TST_VDCNT_STSET                     (volatile uint32_t *)((0x1c2f  << 2) + 0xff900000)
// Program video control signals from ENCP core to DVI/HDMI interface
#define   ENCP_DVI_HSO_BEGIN                       (0x1c30)
#define P_ENCP_DVI_HSO_BEGIN                       (volatile uint32_t *)((0x1c30  << 2) + 0xff900000)
#define   ENCP_DVI_HSO_END                         (0x1c31)
#define P_ENCP_DVI_HSO_END                         (volatile uint32_t *)((0x1c31  << 2) + 0xff900000)
#define   ENCP_DVI_VSO_BLINE_EVN                   (0x1c32)
#define P_ENCP_DVI_VSO_BLINE_EVN                   (volatile uint32_t *)((0x1c32  << 2) + 0xff900000)
#define   ENCP_DVI_VSO_BLINE_ODD                   (0x1c33)
#define P_ENCP_DVI_VSO_BLINE_ODD                   (volatile uint32_t *)((0x1c33  << 2) + 0xff900000)
#define   ENCP_DVI_VSO_ELINE_EVN                   (0x1c34)
#define P_ENCP_DVI_VSO_ELINE_EVN                   (volatile uint32_t *)((0x1c34  << 2) + 0xff900000)
#define   ENCP_DVI_VSO_ELINE_ODD                   (0x1c35)
#define P_ENCP_DVI_VSO_ELINE_ODD                   (volatile uint32_t *)((0x1c35  << 2) + 0xff900000)
#define   ENCP_DVI_VSO_BEGIN_EVN                   (0x1c36)
#define P_ENCP_DVI_VSO_BEGIN_EVN                   (volatile uint32_t *)((0x1c36  << 2) + 0xff900000)
#define   ENCP_DVI_VSO_BEGIN_ODD                   (0x1c37)
#define P_ENCP_DVI_VSO_BEGIN_ODD                   (volatile uint32_t *)((0x1c37  << 2) + 0xff900000)
#define   ENCP_DVI_VSO_END_EVN                     (0x1c38)
#define P_ENCP_DVI_VSO_END_EVN                     (volatile uint32_t *)((0x1c38  << 2) + 0xff900000)
#define   ENCP_DVI_VSO_END_ODD                     (0x1c39)
#define P_ENCP_DVI_VSO_END_ODD                     (volatile uint32_t *)((0x1c39  << 2) + 0xff900000)
#define   ENCP_DE_H_BEGIN                          (0x1c3a)
#define P_ENCP_DE_H_BEGIN                          (volatile uint32_t *)((0x1c3a  << 2) + 0xff900000)
#define   ENCP_DE_H_END                            (0x1c3b)
#define P_ENCP_DE_H_END                            (volatile uint32_t *)((0x1c3b  << 2) + 0xff900000)
#define   ENCP_DE_V_BEGIN_EVEN                     (0x1c3c)
#define P_ENCP_DE_V_BEGIN_EVEN                     (volatile uint32_t *)((0x1c3c  << 2) + 0xff900000)
#define   ENCP_DE_V_END_EVEN                       (0x1c3d)
#define P_ENCP_DE_V_END_EVEN                       (volatile uint32_t *)((0x1c3d  << 2) + 0xff900000)
#define   ENCP_DE_V_BEGIN_ODD                      (0x1c3e)
#define P_ENCP_DE_V_BEGIN_ODD                      (volatile uint32_t *)((0x1c3e  << 2) + 0xff900000)
#define   ENCP_DE_V_END_ODD                        (0x1c3f)
#define P_ENCP_DE_V_END_ODD                        (volatile uint32_t *)((0x1c3f  << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define   ENCI_SYNC_LINE_LENGTH                    (0x1c40)
#define P_ENCI_SYNC_LINE_LENGTH                    (volatile uint32_t *)((0x1c40  << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define   ENCI_SYNC_PIXEL_EN                       (0x1c41)
#define P_ENCI_SYNC_PIXEL_EN                       (volatile uint32_t *)((0x1c41  << 2) + 0xff900000)
// Bit 15 - enci_sync_enable
// Bit 14 - encp_sync_enable
// Bit 13 - enct_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define   ENCI_SYNC_TO_LINE_EN                     (0x1c42)
#define P_ENCI_SYNC_TO_LINE_EN                     (volatile uint32_t *)((0x1c42  << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define   ENCI_SYNC_TO_PIXEL                       (0x1c43)
#define P_ENCI_SYNC_TO_PIXEL                       (volatile uint32_t *)((0x1c43  << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define   ENCP_SYNC_LINE_LENGTH                    (0x1c44)
#define P_ENCP_SYNC_LINE_LENGTH                    (volatile uint32_t *)((0x1c44  << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define   ENCP_SYNC_PIXEL_EN                       (0x1c45)
#define P_ENCP_SYNC_PIXEL_EN                       (volatile uint32_t *)((0x1c45  << 2) + 0xff900000)
// Bit 15 - enci_sync_enable
// Bit 14 - encp_sync_enable
// Bit 13 - enct_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define   ENCP_SYNC_TO_LINE_EN                     (0x1c46)
#define P_ENCP_SYNC_TO_LINE_EN                     (volatile uint32_t *)((0x1c46  << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define   ENCP_SYNC_TO_PIXEL                       (0x1c47)
#define P_ENCP_SYNC_TO_PIXEL                       (volatile uint32_t *)((0x1c47  << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define   ENCT_SYNC_LINE_LENGTH                    (0x1c48)
#define P_ENCT_SYNC_LINE_LENGTH                    (volatile uint32_t *)((0x1c48  << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define   ENCT_SYNC_PIXEL_EN                       (0x1c49)
#define P_ENCT_SYNC_PIXEL_EN                       (volatile uint32_t *)((0x1c49  << 2) + 0xff900000)
// Bit 15 - enci_sync_enable
// Bit 14 - encp_sync_enable
// Bit 13 - enct_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define   ENCT_SYNC_TO_LINE_EN                     (0x1c4a)
#define P_ENCT_SYNC_TO_LINE_EN                     (volatile uint32_t *)((0x1c4a  << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define   ENCT_SYNC_TO_PIXEL                       (0x1c4b)
#define P_ENCT_SYNC_TO_PIXEL                       (volatile uint32_t *)((0x1c4b  << 2) + 0xff900000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define   ENCL_SYNC_LINE_LENGTH                    (0x1c4c)
#define P_ENCL_SYNC_LINE_LENGTH                    (volatile uint32_t *)((0x1c4c  << 2) + 0xff900000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define   ENCL_SYNC_PIXEL_EN                       (0x1c4d)
#define P_ENCL_SYNC_PIXEL_EN                       (volatile uint32_t *)((0x1c4d  << 2) + 0xff900000)
// Bit 15 - enci_sync_enable
// Bit 14 - encp_sync_enable
// Bit 13 - enct_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define   ENCL_SYNC_TO_LINE_EN                     (0x1c4e)
#define P_ENCL_SYNC_TO_LINE_EN                     (volatile uint32_t *)((0x1c4e  << 2) + 0xff900000)
// Bit 12:0 - sync target pixel
#define   ENCL_SYNC_TO_PIXEL                       (0x1c4f)
#define P_ENCL_SYNC_TO_PIXEL                       (volatile uint32_t *)((0x1c4f  << 2) + 0xff900000)
// bit    3 cfg_encp_lcd_scaler_bypass. 1=Do not scale LCD input data;
//                                      0=Scale LCD input data to y [16*4,235*4], c [16*4,240*4].
// bit    2 cfg_encp_vadj_scaler_bypass. 1=Do not scale data to enc480p_vadj;
//                                       0=Scale enc480p_vadj input data to y [16*4,235*4], c [16*4,240*4].
// bit    1 cfg_vfifo2vd_out_scaler_bypass. 1=Do not scale vfifo2vd's output vdata;
//                                          0=Scale vfifo2vd's output vdata to y [16,235], c [16,240].
// bit    0 cfg_vfifo_din_full_range. 1=Data from viu fifo is full range [0,1023];
//                                    0=Data from viu fifo is y [16*4,235*4], c [16*4,240*4].
#define   ENCP_VFIFO2VD_CTL2                       (0x1c50)
#define P_ENCP_VFIFO2VD_CTL2                       (volatile uint32_t *)((0x1c50  << 2) + 0xff900000)
// bit 15:1 Reserved.
// bit    0 cfg_int_dvi_sel_rgb. Applicable for using on-chip hdmi tx module only. This bit controls correct bit-mapping from
//          Venc to hdmi_tx depending on whether YCbCr or RGB mode.
//                               1=Map data bit from Venc to hdmi_tx for RGB mode;
//                               0=Default. Map data bit from Venc to hdmi_tx for YCbCr mode.
#define   VENC_DVI_SETTING_MORE                    (0x1c51)
#define P_VENC_DVI_SETTING_MORE                    (volatile uint32_t *)((0x1c51  << 2) + 0xff900000)
#define   VENC_VDAC_DAC4_FILT_CTRL0                (0x1c54)
#define P_VENC_VDAC_DAC4_FILT_CTRL0                (volatile uint32_t *)((0x1c54  << 2) + 0xff900000)
#define   VENC_VDAC_DAC4_FILT_CTRL1                (0x1c55)
#define P_VENC_VDAC_DAC4_FILT_CTRL1                (volatile uint32_t *)((0x1c55  << 2) + 0xff900000)
#define   VENC_VDAC_DAC5_FILT_CTRL0                (0x1c56)
#define P_VENC_VDAC_DAC5_FILT_CTRL0                (volatile uint32_t *)((0x1c56  << 2) + 0xff900000)
#define   VENC_VDAC_DAC5_FILT_CTRL1                (0x1c57)
#define P_VENC_VDAC_DAC5_FILT_CTRL1                (volatile uint32_t *)((0x1c57  << 2) + 0xff900000)
//Bit 0   filter_en
#define   VENC_VDAC_DAC0_FILT_CTRL0                (0x1c58)
#define P_VENC_VDAC_DAC0_FILT_CTRL0                (volatile uint32_t *)((0x1c58  << 2) + 0xff900000)
//dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
//Bit 15:8, coef1,
//Bit 7:0, coef0,
#define   VENC_VDAC_DAC0_FILT_CTRL1                (0x1c59)
#define P_VENC_VDAC_DAC0_FILT_CTRL1                (volatile uint32_t *)((0x1c59  << 2) + 0xff900000)
//Bit 0   filter_en
#define   VENC_VDAC_DAC1_FILT_CTRL0                (0x1c5a)
#define P_VENC_VDAC_DAC1_FILT_CTRL0                (volatile uint32_t *)((0x1c5a  << 2) + 0xff900000)
//dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
//Bit 15:8, coef1,
//Bit 7:0, coef0,
#define   VENC_VDAC_DAC1_FILT_CTRL1                (0x1c5b)
#define P_VENC_VDAC_DAC1_FILT_CTRL1                (volatile uint32_t *)((0x1c5b  << 2) + 0xff900000)
//Bit 0   filter_en
#define   VENC_VDAC_DAC2_FILT_CTRL0                (0x1c5c)
#define P_VENC_VDAC_DAC2_FILT_CTRL0                (volatile uint32_t *)((0x1c5c  << 2) + 0xff900000)
//dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
//Bit 15:8, coef1,
//Bit 7:0, coef0,
#define   VENC_VDAC_DAC2_FILT_CTRL1                (0x1c5d)
#define P_VENC_VDAC_DAC2_FILT_CTRL1                (volatile uint32_t *)((0x1c5d  << 2) + 0xff900000)
//Bit 0   filter_en
#define   VENC_VDAC_DAC3_FILT_CTRL0                (0x1c5e)
#define P_VENC_VDAC_DAC3_FILT_CTRL0                (volatile uint32_t *)((0x1c5e  << 2) + 0xff900000)
//dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
//Bit 15:8, coef1,
//Bit 7:0, coef0,
#define   VENC_VDAC_DAC3_FILT_CTRL1                (0x1c5f)
#define P_VENC_VDAC_DAC3_FILT_CTRL1                (volatile uint32_t *)((0x1c5f  << 2) + 0xff900000)
//===========================================================================
// ENCT registers
#define   ENCT_VIDEO_EN                            (0x1c60)
#define P_ENCT_VIDEO_EN                            (volatile uint32_t *)((0x1c60  << 2) + 0xff900000)
#define   ENCT_VIDEO_Y_SCL                         (0x1c61)
#define P_ENCT_VIDEO_Y_SCL                         (volatile uint32_t *)((0x1c61  << 2) + 0xff900000)
#define   ENCT_VIDEO_PB_SCL                        (0x1c62)
#define P_ENCT_VIDEO_PB_SCL                        (volatile uint32_t *)((0x1c62  << 2) + 0xff900000)
#define   ENCT_VIDEO_PR_SCL                        (0x1c63)
#define P_ENCT_VIDEO_PR_SCL                        (volatile uint32_t *)((0x1c63  << 2) + 0xff900000)
#define   ENCT_VIDEO_Y_OFFST                       (0x1c64)
#define P_ENCT_VIDEO_Y_OFFST                       (volatile uint32_t *)((0x1c64  << 2) + 0xff900000)
#define   ENCT_VIDEO_PB_OFFST                      (0x1c65)
#define P_ENCT_VIDEO_PB_OFFST                      (volatile uint32_t *)((0x1c65  << 2) + 0xff900000)
#define   ENCT_VIDEO_PR_OFFST                      (0x1c66)
#define P_ENCT_VIDEO_PR_OFFST                      (volatile uint32_t *)((0x1c66  << 2) + 0xff900000)
//----- Video mode
#define   ENCT_VIDEO_MODE                          (0x1c67)
#define P_ENCT_VIDEO_MODE                          (volatile uint32_t *)((0x1c67  << 2) + 0xff900000)
#define   ENCT_VIDEO_MODE_ADV                      (0x1c68)
#define P_ENCT_VIDEO_MODE_ADV                      (volatile uint32_t *)((0x1c68  << 2) + 0xff900000)
//--------------- Debug pins
#define   ENCT_DBG_PX_RST                          (0x1c69)
#define P_ENCT_DBG_PX_RST                          (volatile uint32_t *)((0x1c69  << 2) + 0xff900000)
#define   ENCT_DBG_LN_RST                          (0x1c6a)
#define P_ENCT_DBG_LN_RST                          (volatile uint32_t *)((0x1c6a  << 2) + 0xff900000)
#define   ENCT_DBG_PX_INT                          (0x1c6b)
#define P_ENCT_DBG_PX_INT                          (volatile uint32_t *)((0x1c6b  << 2) + 0xff900000)
#define   ENCT_DBG_LN_INT                          (0x1c6c)
#define P_ENCT_DBG_LN_INT                          (volatile uint32_t *)((0x1c6c  << 2) + 0xff900000)
//----------- Video Advanced setting
#define   ENCT_VIDEO_YFP1_HTIME                    (0x1c6d)
#define P_ENCT_VIDEO_YFP1_HTIME                    (volatile uint32_t *)((0x1c6d  << 2) + 0xff900000)
#define   ENCT_VIDEO_YFP2_HTIME                    (0x1c6e)
#define P_ENCT_VIDEO_YFP2_HTIME                    (volatile uint32_t *)((0x1c6e  << 2) + 0xff900000)
#define   ENCT_VIDEO_YC_DLY                        (0x1c6f)
#define P_ENCT_VIDEO_YC_DLY                        (volatile uint32_t *)((0x1c6f  << 2) + 0xff900000)
#define   ENCT_VIDEO_MAX_PXCNT                     (0x1c70)
#define P_ENCT_VIDEO_MAX_PXCNT                     (volatile uint32_t *)((0x1c70  << 2) + 0xff900000)
#define   ENCT_VIDEO_HAVON_END                     (0x1c71)
#define P_ENCT_VIDEO_HAVON_END                     (volatile uint32_t *)((0x1c71  << 2) + 0xff900000)
#define   ENCT_VIDEO_HAVON_BEGIN                   (0x1c72)
#define P_ENCT_VIDEO_HAVON_BEGIN                   (volatile uint32_t *)((0x1c72  << 2) + 0xff900000)
#define   ENCT_VIDEO_VAVON_ELINE                   (0x1c73)
#define P_ENCT_VIDEO_VAVON_ELINE                   (volatile uint32_t *)((0x1c73  << 2) + 0xff900000)
#define   ENCT_VIDEO_VAVON_BLINE                   (0x1c74)
#define P_ENCT_VIDEO_VAVON_BLINE                   (volatile uint32_t *)((0x1c74  << 2) + 0xff900000)
#define   ENCT_VIDEO_HSO_BEGIN                     (0x1c75)
#define P_ENCT_VIDEO_HSO_BEGIN                     (volatile uint32_t *)((0x1c75  << 2) + 0xff900000)
#define   ENCT_VIDEO_HSO_END                       (0x1c76)
#define P_ENCT_VIDEO_HSO_END                       (volatile uint32_t *)((0x1c76  << 2) + 0xff900000)
#define   ENCT_VIDEO_VSO_BEGIN                     (0x1c77)
#define P_ENCT_VIDEO_VSO_BEGIN                     (volatile uint32_t *)((0x1c77  << 2) + 0xff900000)
#define   ENCT_VIDEO_VSO_END                       (0x1c78)
#define P_ENCT_VIDEO_VSO_END                       (volatile uint32_t *)((0x1c78  << 2) + 0xff900000)
#define   ENCT_VIDEO_VSO_BLINE                     (0x1c79)
#define P_ENCT_VIDEO_VSO_BLINE                     (volatile uint32_t *)((0x1c79  << 2) + 0xff900000)
#define   ENCT_VIDEO_VSO_ELINE                     (0x1c7a)
#define P_ENCT_VIDEO_VSO_ELINE                     (volatile uint32_t *)((0x1c7a  << 2) + 0xff900000)
#define   ENCT_VIDEO_MAX_LNCNT                     (0x1c7b)
#define P_ENCT_VIDEO_MAX_LNCNT                     (volatile uint32_t *)((0x1c7b  << 2) + 0xff900000)
#define   ENCT_VIDEO_BLANKY_VAL                    (0x1c7c)
#define P_ENCT_VIDEO_BLANKY_VAL                    (volatile uint32_t *)((0x1c7c  << 2) + 0xff900000)
#define   ENCT_VIDEO_BLANKPB_VAL                   (0x1c7d)
#define P_ENCT_VIDEO_BLANKPB_VAL                   (volatile uint32_t *)((0x1c7d  << 2) + 0xff900000)
#define   ENCT_VIDEO_BLANKPR_VAL                   (0x1c7e)
#define P_ENCT_VIDEO_BLANKPR_VAL                   (volatile uint32_t *)((0x1c7e  << 2) + 0xff900000)
#define   ENCT_VIDEO_HOFFST                        (0x1c7f)
#define P_ENCT_VIDEO_HOFFST                        (volatile uint32_t *)((0x1c7f  << 2) + 0xff900000)
#define   ENCT_VIDEO_VOFFST                        (0x1c80)
#define P_ENCT_VIDEO_VOFFST                        (volatile uint32_t *)((0x1c80  << 2) + 0xff900000)
#define   ENCT_VIDEO_RGB_CTRL                      (0x1c81)
#define P_ENCT_VIDEO_RGB_CTRL                      (volatile uint32_t *)((0x1c81  << 2) + 0xff900000)
#define   ENCT_VIDEO_FILT_CTRL                     (0x1c82)
#define P_ENCT_VIDEO_FILT_CTRL                     (volatile uint32_t *)((0x1c82  << 2) + 0xff900000)
#define   ENCT_VIDEO_OFLD_VPEQ_OFST                (0x1c83)
#define P_ENCT_VIDEO_OFLD_VPEQ_OFST                (volatile uint32_t *)((0x1c83  << 2) + 0xff900000)
#define   ENCT_VIDEO_OFLD_VOAV_OFST                (0x1c84)
#define P_ENCT_VIDEO_OFLD_VOAV_OFST                (volatile uint32_t *)((0x1c84  << 2) + 0xff900000)
#define   ENCT_VIDEO_MATRIX_CB                     (0x1c85)
#define P_ENCT_VIDEO_MATRIX_CB                     (volatile uint32_t *)((0x1c85  << 2) + 0xff900000)
#define   ENCT_VIDEO_MATRIX_CR                     (0x1c86)
#define P_ENCT_VIDEO_MATRIX_CR                     (volatile uint32_t *)((0x1c86  << 2) + 0xff900000)
#define   ENCT_VIDEO_RGBIN_CTRL                    (0x1c87)
#define P_ENCT_VIDEO_RGBIN_CTRL                    (volatile uint32_t *)((0x1c87  << 2) + 0xff900000)
#define   ENCT_MAX_LINE_SWITCH_POINT               (0x1c88)
#define P_ENCT_MAX_LINE_SWITCH_POINT               (volatile uint32_t *)((0x1c88  << 2) + 0xff900000)
#define   ENCT_DACSEL_0                            (0x1c89)
#define P_ENCT_DACSEL_0                            (volatile uint32_t *)((0x1c89  << 2) + 0xff900000)
#define   ENCT_DACSEL_1                            (0x1c8a)
#define P_ENCT_DACSEL_1                            (volatile uint32_t *)((0x1c8a  << 2) + 0xff900000)
//===========================================================================
// For ENCL
//===========================================================================
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define   ENCL_VFIFO2VD_CTL                        (0x1c90)
#define P_ENCL_VFIFO2VD_CTL                        (volatile uint32_t *)((0x1c90  << 2) + 0xff900000)
// bit 12:0 -- vfifo2vd_pixel_start
#define   ENCL_VFIFO2VD_PIXEL_START                (0x1c91)
#define P_ENCL_VFIFO2VD_PIXEL_START                (volatile uint32_t *)((0x1c91  << 2) + 0xff900000)
// bit 12:00 -- vfifo2vd_pixel_end
#define   ENCL_VFIFO2VD_PIXEL_END                  (0x1c92)
#define P_ENCL_VFIFO2VD_PIXEL_END                  (volatile uint32_t *)((0x1c92  << 2) + 0xff900000)
// bit 10:0 -- vfifo2vd_line_top_start
#define   ENCL_VFIFO2VD_LINE_TOP_START             (0x1c93)
#define P_ENCL_VFIFO2VD_LINE_TOP_START             (volatile uint32_t *)((0x1c93  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_top_end
#define   ENCL_VFIFO2VD_LINE_TOP_END               (0x1c94)
#define P_ENCL_VFIFO2VD_LINE_TOP_END               (volatile uint32_t *)((0x1c94  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define   ENCL_VFIFO2VD_LINE_BOT_START             (0x1c95)
#define P_ENCL_VFIFO2VD_LINE_BOT_START             (volatile uint32_t *)((0x1c95  << 2) + 0xff900000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define   ENCL_VFIFO2VD_LINE_BOT_END               (0x1c96)
#define P_ENCL_VFIFO2VD_LINE_BOT_END               (volatile uint32_t *)((0x1c96  << 2) + 0xff900000)
#define   ENCL_VFIFO2VD_CTL2                       (0x1c97)
#define P_ENCL_VFIFO2VD_CTL2                       (volatile uint32_t *)((0x1c97  << 2) + 0xff900000)
#define   ENCL_TST_EN                              (0x1c98)
#define P_ENCL_TST_EN                              (volatile uint32_t *)((0x1c98  << 2) + 0xff900000)
#define   ENCL_TST_MDSEL                           (0x1c99)
#define P_ENCL_TST_MDSEL                           (volatile uint32_t *)((0x1c99  << 2) + 0xff900000)
#define   ENCL_TST_Y                               (0x1c9a)
#define P_ENCL_TST_Y                               (volatile uint32_t *)((0x1c9a  << 2) + 0xff900000)
#define   ENCL_TST_CB                              (0x1c9b)
#define P_ENCL_TST_CB                              (volatile uint32_t *)((0x1c9b  << 2) + 0xff900000)
#define   ENCL_TST_CR                              (0x1c9c)
#define P_ENCL_TST_CR                              (volatile uint32_t *)((0x1c9c  << 2) + 0xff900000)
#define   ENCL_TST_CLRBAR_STRT                     (0x1c9d)
#define P_ENCL_TST_CLRBAR_STRT                     (volatile uint32_t *)((0x1c9d  << 2) + 0xff900000)
#define   ENCL_TST_CLRBAR_WIDTH                    (0x1c9e)
#define P_ENCL_TST_CLRBAR_WIDTH                    (volatile uint32_t *)((0x1c9e  << 2) + 0xff900000)
#define   ENCL_TST_VDCNT_STSET                     (0x1c9f)
#define P_ENCL_TST_VDCNT_STSET                     (volatile uint32_t *)((0x1c9f  << 2) + 0xff900000)
//===========================================================================
// ENCL registers
#define   ENCL_VIDEO_EN                            (0x1ca0)
#define P_ENCL_VIDEO_EN                            (volatile uint32_t *)((0x1ca0  << 2) + 0xff900000)
#define   ENCL_VIDEO_Y_SCL                         (0x1ca1)
#define P_ENCL_VIDEO_Y_SCL                         (volatile uint32_t *)((0x1ca1  << 2) + 0xff900000)
#define   ENCL_VIDEO_PB_SCL                        (0x1ca2)
#define P_ENCL_VIDEO_PB_SCL                        (volatile uint32_t *)((0x1ca2  << 2) + 0xff900000)
#define   ENCL_VIDEO_PR_SCL                        (0x1ca3)
#define P_ENCL_VIDEO_PR_SCL                        (volatile uint32_t *)((0x1ca3  << 2) + 0xff900000)
#define   ENCL_VIDEO_Y_OFFST                       (0x1ca4)
#define P_ENCL_VIDEO_Y_OFFST                       (volatile uint32_t *)((0x1ca4  << 2) + 0xff900000)
#define   ENCL_VIDEO_PB_OFFST                      (0x1ca5)
#define P_ENCL_VIDEO_PB_OFFST                      (volatile uint32_t *)((0x1ca5  << 2) + 0xff900000)
#define   ENCL_VIDEO_PR_OFFST                      (0x1ca6)
#define P_ENCL_VIDEO_PR_OFFST                      (volatile uint32_t *)((0x1ca6  << 2) + 0xff900000)
//----- Video mode
#define   ENCL_VIDEO_MODE                          (0x1ca7)
#define P_ENCL_VIDEO_MODE                          (volatile uint32_t *)((0x1ca7  << 2) + 0xff900000)
#define   ENCL_VIDEO_MODE_ADV                      (0x1ca8)
#define P_ENCL_VIDEO_MODE_ADV                      (volatile uint32_t *)((0x1ca8  << 2) + 0xff900000)
//--------------- Debug pins
#define   ENCL_DBG_PX_RST                          (0x1ca9)
#define P_ENCL_DBG_PX_RST                          (volatile uint32_t *)((0x1ca9  << 2) + 0xff900000)
#define   ENCL_DBG_LN_RST                          (0x1caa)
#define P_ENCL_DBG_LN_RST                          (volatile uint32_t *)((0x1caa  << 2) + 0xff900000)
#define   ENCL_DBG_PX_INT                          (0x1cab)
#define P_ENCL_DBG_PX_INT                          (volatile uint32_t *)((0x1cab  << 2) + 0xff900000)
#define   ENCL_DBG_LN_INT                          (0x1cac)
#define P_ENCL_DBG_LN_INT                          (volatile uint32_t *)((0x1cac  << 2) + 0xff900000)
//----------- Video Advanced setting
#define   ENCL_VIDEO_YFP1_HTIME                    (0x1cad)
#define P_ENCL_VIDEO_YFP1_HTIME                    (volatile uint32_t *)((0x1cad  << 2) + 0xff900000)
#define   ENCL_VIDEO_YFP2_HTIME                    (0x1cae)
#define P_ENCL_VIDEO_YFP2_HTIME                    (volatile uint32_t *)((0x1cae  << 2) + 0xff900000)
#define   ENCL_VIDEO_YC_DLY                        (0x1caf)
#define P_ENCL_VIDEO_YC_DLY                        (volatile uint32_t *)((0x1caf  << 2) + 0xff900000)
#define   ENCL_VIDEO_MAX_PXCNT                     (0x1cb0)
#define P_ENCL_VIDEO_MAX_PXCNT                     (volatile uint32_t *)((0x1cb0  << 2) + 0xff900000)
#define   ENCL_VIDEO_HAVON_END                     (0x1cb1)
#define P_ENCL_VIDEO_HAVON_END                     (volatile uint32_t *)((0x1cb1  << 2) + 0xff900000)
#define   ENCL_VIDEO_HAVON_BEGIN                   (0x1cb2)
#define P_ENCL_VIDEO_HAVON_BEGIN                   (volatile uint32_t *)((0x1cb2  << 2) + 0xff900000)
#define   ENCL_VIDEO_VAVON_ELINE                   (0x1cb3)
#define P_ENCL_VIDEO_VAVON_ELINE                   (volatile uint32_t *)((0x1cb3  << 2) + 0xff900000)
#define   ENCL_VIDEO_VAVON_BLINE                   (0x1cb4)
#define P_ENCL_VIDEO_VAVON_BLINE                   (volatile uint32_t *)((0x1cb4  << 2) + 0xff900000)
#define   ENCL_VIDEO_HSO_BEGIN                     (0x1cb5)
#define P_ENCL_VIDEO_HSO_BEGIN                     (volatile uint32_t *)((0x1cb5  << 2) + 0xff900000)
#define   ENCL_VIDEO_HSO_END                       (0x1cb6)
#define P_ENCL_VIDEO_HSO_END                       (volatile uint32_t *)((0x1cb6  << 2) + 0xff900000)
#define   ENCL_VIDEO_VSO_BEGIN                     (0x1cb7)
#define P_ENCL_VIDEO_VSO_BEGIN                     (volatile uint32_t *)((0x1cb7  << 2) + 0xff900000)
#define   ENCL_VIDEO_VSO_END                       (0x1cb8)
#define P_ENCL_VIDEO_VSO_END                       (volatile uint32_t *)((0x1cb8  << 2) + 0xff900000)
#define   ENCL_VIDEO_VSO_BLINE                     (0x1cb9)
#define P_ENCL_VIDEO_VSO_BLINE                     (volatile uint32_t *)((0x1cb9  << 2) + 0xff900000)
#define   ENCL_VIDEO_VSO_ELINE                     (0x1cba)
#define P_ENCL_VIDEO_VSO_ELINE                     (volatile uint32_t *)((0x1cba  << 2) + 0xff900000)
#define   ENCL_VIDEO_MAX_LNCNT                     (0x1cbb)
#define P_ENCL_VIDEO_MAX_LNCNT                     (volatile uint32_t *)((0x1cbb  << 2) + 0xff900000)
#define   ENCL_VIDEO_BLANKY_VAL                    (0x1cbc)
#define P_ENCL_VIDEO_BLANKY_VAL                    (volatile uint32_t *)((0x1cbc  << 2) + 0xff900000)
#define   ENCL_VIDEO_BLANKPB_VAL                   (0x1cbd)
#define P_ENCL_VIDEO_BLANKPB_VAL                   (volatile uint32_t *)((0x1cbd  << 2) + 0xff900000)
#define   ENCL_VIDEO_BLANKPR_VAL                   (0x1cbe)
#define P_ENCL_VIDEO_BLANKPR_VAL                   (volatile uint32_t *)((0x1cbe  << 2) + 0xff900000)
#define   ENCL_VIDEO_HOFFST                        (0x1cbf)
#define P_ENCL_VIDEO_HOFFST                        (volatile uint32_t *)((0x1cbf  << 2) + 0xff900000)
#define   ENCL_VIDEO_VOFFST                        (0x1cc0)
#define P_ENCL_VIDEO_VOFFST                        (volatile uint32_t *)((0x1cc0  << 2) + 0xff900000)
#define   ENCL_VIDEO_RGB_CTRL                      (0x1cc1)
#define P_ENCL_VIDEO_RGB_CTRL                      (volatile uint32_t *)((0x1cc1  << 2) + 0xff900000)
#define   ENCL_VIDEO_FILT_CTRL                     (0x1cc2)
#define P_ENCL_VIDEO_FILT_CTRL                     (volatile uint32_t *)((0x1cc2  << 2) + 0xff900000)
#define   ENCL_VIDEO_OFLD_VPEQ_OFST                (0x1cc3)
#define P_ENCL_VIDEO_OFLD_VPEQ_OFST                (volatile uint32_t *)((0x1cc3  << 2) + 0xff900000)
#define   ENCL_VIDEO_OFLD_VOAV_OFST                (0x1cc4)
#define P_ENCL_VIDEO_OFLD_VOAV_OFST                (volatile uint32_t *)((0x1cc4  << 2) + 0xff900000)
#define   ENCL_VIDEO_MATRIX_CB                     (0x1cc5)
#define P_ENCL_VIDEO_MATRIX_CB                     (volatile uint32_t *)((0x1cc5  << 2) + 0xff900000)
#define   ENCL_VIDEO_MATRIX_CR                     (0x1cc6)
#define P_ENCL_VIDEO_MATRIX_CR                     (volatile uint32_t *)((0x1cc6  << 2) + 0xff900000)
#define   ENCL_VIDEO_RGBIN_CTRL                    (0x1cc7)
#define P_ENCL_VIDEO_RGBIN_CTRL                    (volatile uint32_t *)((0x1cc7  << 2) + 0xff900000)
#define   ENCL_MAX_LINE_SWITCH_POINT               (0x1cc8)
#define P_ENCL_MAX_LINE_SWITCH_POINT               (volatile uint32_t *)((0x1cc8  << 2) + 0xff900000)
#define   ENCL_DACSEL_0                            (0x1cc9)
#define P_ENCL_DACSEL_0                            (volatile uint32_t *)((0x1cc9  << 2) + 0xff900000)
#define   ENCL_DACSEL_1                            (0x1cca)
#define P_ENCL_DACSEL_1                            (volatile uint32_t *)((0x1cca  << 2) + 0xff900000)
//
// Closing file:  venc2_regs.h
//
//`define VPP_VCBUS_BASE                 8'h1d
//
// Reading file:  vpp_regs.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// CBUS_BASE:  VPP_VCBUS_BASE = 0x1d
// -----------------------------------------------
//===========================================================================
// Video postprocessing Registers
//===========================================================================
// dummy data used in the VPP preblend and scaler
// Bit 23:16    Y
// Bit 15:8     CB
// Bit 7:0      CR
#define   VPP_DUMMY_DATA                           (0x1d00)
#define P_VPP_DUMMY_DATA                           (volatile uint32_t *)((0x1d00  << 2) + 0xff900000)
//input line length used in VPP
#define   VPP_LINE_IN_LENGTH                       (0x1d01)
#define P_VPP_LINE_IN_LENGTH                       (volatile uint32_t *)((0x1d01  << 2) + 0xff900000)
//input Picture height used in VPP
#define   VPP_PIC_IN_HEIGHT                        (0x1d02)
#define P_VPP_PIC_IN_HEIGHT                        (volatile uint32_t *)((0x1d02  << 2) + 0xff900000)
//Because there are many coefficients used in the vertical filter and horizontal filters,
//indirect access the coefficients of vertical filter and horizontal filter is used.
//For vertical filter, there are 33x4 coefficients
//For horizontal filter, there are 33x4 coefficients
//Bit 15    index increment, if bit9 == 1  then (0: index increase 1, 1: index increase 2) else (index increase 2)
//Bit 14    1: read coef through cbus enable, just for debug purpose in case when we wanna check the coef in ram in correct or not
//Bit 13    if true, vertical separated coef enable
//Bit 9     if true, use 9bit resolution coef, other use 8bit resolution coef
//Bit 8:7   type of index, 00: vertical coef, 01: vertical chroma coef: 10: horizontal coef, 11: resevered
//Bit 6:0   coef index
#define   VPP_SCALE_COEF_IDX                       (0x1d03)
#define P_VPP_SCALE_COEF_IDX                       (volatile uint32_t *)((0x1d03  << 2) + 0xff900000)
//coefficients for vertical filter and horizontal filter
#define   VPP_SCALE_COEF                           (0x1d04)
#define P_VPP_SCALE_COEF                           (volatile uint32_t *)((0x1d04  << 2) + 0xff900000)
//these following registers are the absolute line address pointer for output divided screen
//The output divided screen is shown in the following:
//
//  --------------------------   <------ line zero
//      .
//      .
//      .           region0        <---------- nonlinear region or nonscaling region
//      .
//  ---------------------------
//  ---------------------------  <------ region1_startp
//      .
//      .           region1         <---------- nonlinear region
//      .
//      .
//  ---------------------------
//  ---------------------------  <------ region2_startp
//      .
//      .           region2         <---------- linear region
//      .
//      .
//  ---------------------------
//  ---------------------------  <------ region3_startp
//      .
//      .           region3         <---------- nonlinear region
//      .
//      .
//  ---------------------------
//  ---------------------------  <------ region4_startp
//      .
//      .           region4         <---------- nonlinear region or nonoscaling region
//      .
//      .
//  ---------------------------  <------ region4_endp
//Bit 28:16 region1 startp
//Bit 12:0 region2 startp
#define   VPP_VSC_REGION12_STARTP                  (0x1d05)
#define P_VPP_VSC_REGION12_STARTP                  (volatile uint32_t *)((0x1d05  << 2) + 0xff900000)
//Bit 28:16 region3 startp
//Bit 12:0 region4 startp
#define   VPP_VSC_REGION34_STARTP                  (0x1d06)
#define P_VPP_VSC_REGION34_STARTP                  (volatile uint32_t *)((0x1d06  << 2) + 0xff900000)
#define   VPP_VSC_REGION4_ENDP                     (0x1d07)
#define P_VPP_VSC_REGION4_ENDP                     (volatile uint32_t *)((0x1d07  << 2) + 0xff900000)
//vertical start phase step, (source/dest)*(2^24)
//Bit 27:24 integer part
//Bit 23:0  fraction part
#define   VPP_VSC_START_PHASE_STEP                 (0x1d08)
#define P_VPP_VSC_START_PHASE_STEP                 (volatile uint32_t *)((0x1d08  << 2) + 0xff900000)
//vertical scaler region0 phase slope, Bit24 signed bit
#define   VPP_VSC_REGION0_PHASE_SLOPE              (0x1d09)
#define P_VPP_VSC_REGION0_PHASE_SLOPE              (volatile uint32_t *)((0x1d09  << 2) + 0xff900000)
//vertical scaler region1 phase slope, Bit24 signed bit
#define   VPP_VSC_REGION1_PHASE_SLOPE              (0x1d0a)
#define P_VPP_VSC_REGION1_PHASE_SLOPE              (volatile uint32_t *)((0x1d0a  << 2) + 0xff900000)
//vertical scaler region3 phase slope, Bit24 signed bit
#define   VPP_VSC_REGION3_PHASE_SLOPE              (0x1d0b)
#define P_VPP_VSC_REGION3_PHASE_SLOPE              (volatile uint32_t *)((0x1d0b  << 2) + 0xff900000)
//vertical scaler region4 phase slope, Bit24 signed bit
#define   VPP_VSC_REGION4_PHASE_SLOPE              (0x1d0c)
#define P_VPP_VSC_REGION4_PHASE_SLOPE              (volatile uint32_t *)((0x1d0c  << 2) + 0xff900000)
//Bit 18:17     double line mode, input/output line width of vscaler becomes 2X,
//           so only 2 line buffer in this case, use for 3D line by line interleave scaling
//           bit1 true, double the input width and half input height, bit0 true, change line buffer 2 lines instead of 4 lines
//Bit 16     0: progressive output, 1: interlace output
//Bit 15     vertical scaler output line0 in advance or not for bottom field
//Bit 14:13  vertical scaler initial repeat line0 number for bottom field
//Bit 11:8   vertical scaler initial receiving  number for bottom field
//Bit 7      vertical scaler output line0 in advance or not for top field
//Bit 6:5    vertical scaler initial repeat line0 number for top field
//Bit 3:0    vertical scaler initial receiving  number for top field
#define   VPP_VSC_PHASE_CTRL                       (0x1d0d)
#define P_VPP_VSC_PHASE_CTRL                       (volatile uint32_t *)((0x1d0d  << 2) + 0xff900000)
//Bit 31:16  vertical scaler field initial phase for bottom field
//Bit 15:0  vertical scaler field initial phase for top field
#define   VPP_VSC_INI_PHASE                        (0x1d0e)
#define P_VPP_VSC_INI_PHASE                        (volatile uint32_t *)((0x1d0e  << 2) + 0xff900000)
//Bit 28:16 region1 startp
//Bit 12:0 region2 startp
#define   VPP_HSC_REGION12_STARTP                  (0x1d10)
#define P_VPP_HSC_REGION12_STARTP                  (volatile uint32_t *)((0x1d10  << 2) + 0xff900000)
//Bit 28:16 region3 startp
//Bit 12:0 region4 startp
#define   VPP_HSC_REGION34_STARTP                  (0x1d11)
#define P_VPP_HSC_REGION34_STARTP                  (volatile uint32_t *)((0x1d11  << 2) + 0xff900000)
#define   VPP_HSC_REGION4_ENDP                     (0x1d12)
#define P_VPP_HSC_REGION4_ENDP                     (volatile uint32_t *)((0x1d12  << 2) + 0xff900000)
//horizontal start phase step, (source/dest)*(2^24)
//Bit 27:24 integer part
//Bit 23:0  fraction part
#define   VPP_HSC_START_PHASE_STEP                 (0x1d13)
#define P_VPP_HSC_START_PHASE_STEP                 (volatile uint32_t *)((0x1d13  << 2) + 0xff900000)
//horizontal scaler region0 phase slope, Bit24 signed bit
#define   VPP_HSC_REGION0_PHASE_SLOPE              (0x1d14)
#define P_VPP_HSC_REGION0_PHASE_SLOPE              (volatile uint32_t *)((0x1d14  << 2) + 0xff900000)
//horizontal scaler region1 phase slope, Bit24 signed bit
#define   VPP_HSC_REGION1_PHASE_SLOPE              (0x1d15)
#define P_VPP_HSC_REGION1_PHASE_SLOPE              (volatile uint32_t *)((0x1d15  << 2) + 0xff900000)
//horizontal scaler region3 phase slope, Bit24 signed bit
#define   VPP_HSC_REGION3_PHASE_SLOPE              (0x1d16)
#define P_VPP_HSC_REGION3_PHASE_SLOPE              (volatile uint32_t *)((0x1d16  << 2) + 0xff900000)
//horizontal scaler region4 phase slope, Bit24 signed bit
#define   VPP_HSC_REGION4_PHASE_SLOPE              (0x1d17)
#define P_VPP_HSC_REGION4_PHASE_SLOPE              (volatile uint32_t *)((0x1d17  << 2) + 0xff900000)
//Bit 22:21   horizontal scaler initial repeat pixel0 number0
//Bit 19:16   horizontal scaler initial receiving number0
//Bit 15:0    horizontal scaler top field initial phase0
#define   VPP_HSC_PHASE_CTRL                       (0x1d18)
#define P_VPP_HSC_PHASE_CTRL                       (volatile uint32_t *)((0x1d18  << 2) + 0xff900000)
// Bit 22 if true, divide VSC line length 2 as the HSC input length, otherwise VSC length length is the same as the VSC line length,
//                 just for special usage, more flexibility
// Bit 21 if true, prevsc uses lin buffer, otherwise prevsc does not use line buffer, it should be same as prevsc_en
// Bit 20 prehsc_en
// Bit 19 prevsc_en
// Bit 18 vsc_en
// Bit 17 hsc_en
// Bit 16 scale_top_en
// Bit 15 video1 scale out enable
// Bit 12 if true, region0,region4 are nonlinear regions, otherwise they are not scaling regions, for horizontal scaler
// Bit 10:8 horizontal scaler bank length
// Bit 5, vertical scaler phase field mode, if true, disable the opposite parity line output, more bandwith needed if output 1080i
// Bit 4 if true, region0,region4 are nonlinear regions, otherwise they are not scaling regions, for vertical scaler
// Bit 2:0 vertical scaler bank length
#define   VPP_SC_MISC                              (0x1d19)
#define P_VPP_SC_MISC                              (volatile uint32_t *)((0x1d19  << 2) + 0xff900000)
// preblend video1 horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define   VPP_PREBLEND_VD1_H_START_END             (0x1d1a)
#define P_VPP_PREBLEND_VD1_H_START_END             (volatile uint32_t *)((0x1d1a  << 2) + 0xff900000)
// preblend video1 vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define   VPP_PREBLEND_VD1_V_START_END             (0x1d1b)
#define P_VPP_PREBLEND_VD1_V_START_END             (volatile uint32_t *)((0x1d1b  << 2) + 0xff900000)
// postblend video1 horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define   VPP_POSTBLEND_VD1_H_START_END            (0x1d1c)
#define P_VPP_POSTBLEND_VD1_H_START_END            (volatile uint32_t *)((0x1d1c  << 2) + 0xff900000)
// postblend video1 vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define   VPP_POSTBLEND_VD1_V_START_END            (0x1d1d)
#define P_VPP_POSTBLEND_VD1_V_START_END            (volatile uint32_t *)((0x1d1d  << 2) + 0xff900000)
// preblend/postblend video2 horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define   VPP_BLEND_VD2_H_START_END                (0x1d1e)
#define P_VPP_BLEND_VD2_H_START_END                (volatile uint32_t *)((0x1d1e  << 2) + 0xff900000)
// preblend/postblend video2 vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define   VPP_BLEND_VD2_V_START_END                (0x1d1f)
#define P_VPP_BLEND_VD2_V_START_END                (volatile uint32_t *)((0x1d1f  << 2) + 0xff900000)
// preblend horizontal size
#define   VPP_PREBLEND_H_SIZE                      (0x1d20)
#define P_VPP_PREBLEND_H_SIZE                      (volatile uint32_t *)((0x1d20  << 2) + 0xff900000)
// postblend horizontal size
#define   VPP_POSTBLEND_H_SIZE                     (0x1d21)
#define P_VPP_POSTBLEND_H_SIZE                     (volatile uint32_t *)((0x1d21  << 2) + 0xff900000)
//VPP hold lines
//Bit 29:24
//Bit 21:16
//Bit 15:8     preblend hold lines
//Bit 7:0      postblend hold lines
#define   VPP_HOLD_LINES                           (0x1d22)
#define P_VPP_HOLD_LINES                           (volatile uint32_t *)((0x1d22  << 2) + 0xff900000)
//Bit 26   if true, automatic change post blend output to one color if field ==1
//Bit 25   if true, change screen to one color value for preblender
//Bit 24   if true, change screen to one color value for postblender
// Bit 23:16 one color Y
// Bit 15:8 one color Cb
// Bit  7:0 one color  Cr
#define   VPP_BLEND_ONECOLOR_CTRL                  (0x1d23)
#define P_VPP_BLEND_ONECOLOR_CTRL                  (volatile uint32_t *)((0x1d23  << 2) + 0xff900000)
//Read Only, VPP preblend current_x, current_y
//Bit 28:16 current_x
//Bit 12:0 current_y
#define   VPP_PREBLEND_CURRENT_XY                  (0x1d24)
#define P_VPP_PREBLEND_CURRENT_XY                  (volatile uint32_t *)((0x1d24  << 2) + 0xff900000)
//Read Only, VPP postblend current_x, current_y
//Bit 28:16 current_x
//Bit 12:0 current_y
#define   VPP_POSTBLEND_CURRENT_XY                 (0x1d25)
#define P_VPP_POSTBLEND_CURRENT_XY                 (volatile uint32_t *)((0x1d25  << 2) + 0xff900000)
// Bit 31  vd1_bgosd_exchange_en for preblend
// Bit 30  vd1_bgosd_exchange_en for postblend
// Bit 28   color management enable
// Bit 27,  if true, vd2 use viu2 output as the input, otherwise use normal vd2 from memory
// Bit 26:18, vd2 alpha
// Bit 17, osd2 enable for preblend
// Bit 16, osd1 enable for preblend
// Bit 15, vd2 enable for preblend
// Bit 14, vd1 enable for preblend
// Bit 13, osd2 enable for postblend
// Bit 12, osd1 enable for postblend
// Bit 11, vd2 enable for postblend
// Bit 10, vd1 enable for postblend
// Bit 9,  if true, osd1 is alpha premultiplied
// Bit 8,  if true, osd2 is alpha premultiplied
// Bit 7,  postblend module enable
// Bit 6,  preblend module enable
// Bit 5,  if true, osd2 foreground compared with osd1 in preblend
// Bit 4,  if true, osd2 foreground compared with osd1 in postblend
// Bit 3,
// Bit 2,  if true, disable resetting async fifo every vsync, otherwise every vsync
//           the aync fifo will be reseted.
// Bit 1,
// Bit 0    if true, the output result of VPP is saturated
#define   VPP_MISC                                 (0x1d26)
#define P_VPP_MISC                                 (volatile uint32_t *)((0x1d26  << 2) + 0xff900000)
//Bit 31:20 ofifo line length minus 1
//Bit 19  if true invert input vs
//Bit 18  if true invert input hs
//Bit 17  force top/bottom field, enable
//Bit 16  force top/bottom field, 0: top, 1: bottom
//Bit 15  force one go_field, one pluse, write only
//Bit 14  force one go_line, one pluse, write only
//Bit 12:0 ofifo size (actually only bit 10:1 is valid), always even number
#define   VPP_OFIFO_SIZE                           (0x1d27)
#define P_VPP_OFIFO_SIZE                           (volatile uint32_t *)((0x1d27  << 2) + 0xff900000)
//Read only
//Bit 28:18 current scale out fifo counter
//Bit 17:13 current afifo counter
//Bit 12:0 current ofifo counter
#define   VPP_FIFO_STATUS                          (0x1d28)
#define P_VPP_FIFO_STATUS                          (volatile uint32_t *)((0x1d28  << 2) + 0xff900000)
// Bit 5 SMOKE3 postblend enable only when postblend vd2 is not enable
// Bit 4 SMOKE3 preblend enable only when preblend vd2 is not enable
// Bit 3 SMOKE2 postblend enable only when postblend osd2 is not enable
// Bit 2 SMOKE2 preblend enable only when preblend osd2 is not enable
// Bit 1 SMOKE1 postblend enable only when postblend osd1 is not enable
// Bit 0 SMOKE1 preblend enable only when preblend osd1 is not enable
#define   VPP_SMOKE_CTRL                           (0x1d29)
#define P_VPP_SMOKE_CTRL                           (volatile uint32_t *)((0x1d29  << 2) + 0xff900000)
//smoke can be used only when that blending is disable and then be used as smoke function
//smoke1 for OSD1 channel
//smoke2 for OSD2 channel
//smoke3 for VD2 channel
//31:24 Y
//23:16 Cb
//15:8 Cr
//7:0 Alpha
#define   VPP_SMOKE1_VAL                           (0x1d2a)
#define P_VPP_SMOKE1_VAL                           (volatile uint32_t *)((0x1d2a  << 2) + 0xff900000)
#define   VPP_SMOKE2_VAL                           (0x1d2b)
#define P_VPP_SMOKE2_VAL                           (volatile uint32_t *)((0x1d2b  << 2) + 0xff900000)
#define   VPP_SMOKE3_VAL                           (0x1d2c)
#define P_VPP_SMOKE3_VAL                           (volatile uint32_t *)((0x1d2c  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define   VPP_SMOKE1_H_START_END                   (0x1d2d)
#define P_VPP_SMOKE1_H_START_END                   (volatile uint32_t *)((0x1d2d  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define   VPP_SMOKE1_V_START_END                   (0x1d2e)
#define P_VPP_SMOKE1_V_START_END                   (volatile uint32_t *)((0x1d2e  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define   VPP_SMOKE2_H_START_END                   (0x1d2f)
#define P_VPP_SMOKE2_H_START_END                   (volatile uint32_t *)((0x1d2f  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define   VPP_SMOKE2_V_START_END                   (0x1d30)
#define P_VPP_SMOKE2_V_START_END                   (volatile uint32_t *)((0x1d30  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define   VPP_SMOKE3_H_START_END                   (0x1d31)
#define P_VPP_SMOKE3_H_START_END                   (volatile uint32_t *)((0x1d31  << 2) + 0xff900000)
//Bit 28:16 start
//Bit 12:0 end
#define   VPP_SMOKE3_V_START_END                   (0x1d32)
#define P_VPP_SMOKE3_V_START_END                   (volatile uint32_t *)((0x1d32  << 2) + 0xff900000)
//Bit 27:16 scale out fifo line length minus 1
//Bit 12:0 scale out fifo size (actually only bit 11:1 is valid, 11:1, max 1024), always even number
#define   VPP_SCO_FIFO_CTRL                        (0x1d33)
#define P_VPP_SCO_FIFO_CTRL                        (volatile uint32_t *)((0x1d33  << 2) + 0xff900000)
//for 3D quincunx sub-sampling and horizontal pixel by pixel 3D interleaving
//Bit 27:24, prehsc_mode, bit 3:2, prehsc odd line interp mode, bit 1:0, prehsc even line interp mode,
//           each 2bit, 00: pix0+pix1/2, average, 01: pix1, 10: pix0
//Bit 23 horizontal scaler double pixel mode
//Bit 22:21   horizontal scaler initial repeat pixel0 number1
//Bit 19:16   horizontal scaler initial receiving number1
//Bit 15:0    horizontal scaler top field initial phase1
#define   VPP_HSC_PHASE_CTRL1                      (0x1d34)
#define P_VPP_HSC_PHASE_CTRL1                      (volatile uint32_t *)((0x1d34  << 2) + 0xff900000)
//for 3D quincunx sub-sampling
//31:24  prehsc pattern, each patten 1 bit, from lsb -> msb
//22:20  prehsc pattern start
//18:16 prehsc pattern end
//15:8 hsc pattern, each patten 1 bit, from lsb -> msb
//6:4  hsc pattern start
//2:0  hsc pattern end
#define   VPP_HSC_INI_PAT_CTRL                     (0x1d35)
#define P_VPP_HSC_INI_PAT_CTRL                     (volatile uint32_t *)((0x1d35  << 2) + 0xff900000)
//Bit 3         minus black level enable for vadj2
//Bit 2         Video adjustment enable for vadj2
//Bit 1         minus black level enable for vadj1
//Bit 0         Video adjustment enable for vadj1
#define   VPP_VADJ_CTRL                            (0x1d40)
#define P_VPP_VADJ_CTRL                            (volatile uint32_t *)((0x1d40  << 2) + 0xff900000)
//Bit 16:8  brightness, signed value
//Bit 7:0   contrast, unsigned value, contrast from  0 <= contrast <2
#define   VPP_VADJ1_Y                              (0x1d41)
#define P_VPP_VADJ1_Y                              (volatile uint32_t *)((0x1d41  << 2) + 0xff900000)
//cb' = cb*ma + cr*mb
//cr' = cb*mc + cr*md
//all are bit 9:0, signed value, -2 < ma/mb/mc/md < 2
#define   VPP_VADJ1_MA_MB                          (0x1d42)
#define P_VPP_VADJ1_MA_MB                          (volatile uint32_t *)((0x1d42  << 2) + 0xff900000)
#define   VPP_VADJ1_MC_MD                          (0x1d43)
#define P_VPP_VADJ1_MC_MD                          (volatile uint32_t *)((0x1d43  << 2) + 0xff900000)
//Bit 16:8  brightness, signed value
//Bit 7:0   contrast, unsigned value, contrast from  0 <= contrast <2
#define   VPP_VADJ2_Y                              (0x1d44)
#define P_VPP_VADJ2_Y                              (volatile uint32_t *)((0x1d44  << 2) + 0xff900000)
//cb' = cb*ma + cr*mb
//cr' = cb*mc + cr*md
//all are bit 9:0, signed value, -2 < ma/mb/mc/md < 2
#define   VPP_VADJ2_MA_MB                          (0x1d45)
#define P_VPP_VADJ2_MA_MB                          (volatile uint32_t *)((0x1d45  << 2) + 0xff900000)
#define   VPP_VADJ2_MC_MD                          (0x1d46)
#define P_VPP_VADJ2_MC_MD                          (volatile uint32_t *)((0x1d46  << 2) + 0xff900000)
//Bit 2 horizontal chroma sharp/blur selection, 0:sharp, 1: blur
//Bit 1 horizontal luma sharp/blur selection, 0:sharp, 1: blur
//Bit 0 horizontal sharpness enable
#define   VPP_HSHARP_CTRL                          (0x1d50)
#define P_VPP_HSHARP_CTRL                          (volatile uint32_t *)((0x1d50  << 2) + 0xff900000)
//{1'b0,threshold} < diff
//Bit 26:16  luma threshold0
//Bit 10:0   luma threshold1
#define   VPP_HSHARP_LUMA_THRESH01                 (0x1d51)
#define P_VPP_HSHARP_LUMA_THRESH01                 (volatile uint32_t *)((0x1d51  << 2) + 0xff900000)
//
//Bit 26:16  luma threshold2
//Bit 10:0   luma threshold3
#define   VPP_HSHARP_LUMA_THRESH23                 (0x1d52)
#define P_VPP_HSHARP_LUMA_THRESH23                 (volatile uint32_t *)((0x1d52  << 2) + 0xff900000)
//Bit 26:16  chroma threshold0
//Bit 10:0   chroma threshold1
#define   VPP_HSHARP_CHROMA_THRESH01               (0x1d53)
#define P_VPP_HSHARP_CHROMA_THRESH01               (volatile uint32_t *)((0x1d53  << 2) + 0xff900000)
//Bit 26:16  chroma threshold2
//Bit 10:0   chroma threshold3
#define   VPP_HSHARP_CHROMA_THRESH23               (0x1d54)
#define P_VPP_HSHARP_CHROMA_THRESH23               (volatile uint32_t *)((0x1d54  << 2) + 0xff900000)
//Bit 23:16 luma gain2
//Bit 15:8  luma gain1
//Bit 7:0   luma gain0
#define   VPP_HSHARP_LUMA_GAIN                     (0x1d55)
#define P_VPP_HSHARP_LUMA_GAIN                     (volatile uint32_t *)((0x1d55  << 2) + 0xff900000)
//
//Bit 23:16 chroma gain2
//Bit 15:8  chroma gain1
//Bit 7:0   chroma gain0
#define   VPP_HSHARP_CHROMA_GAIN                   (0x1d56)
#define P_VPP_HSHARP_CHROMA_GAIN                   (volatile uint32_t *)((0x1d56  << 2) + 0xff900000)
//Read only
//Bit 31, if it is true, it means this probe is valid in the last field/frame
//Bit 29:20 component 0
//Bit 19:10 component 1
//Bit 9:0 component 2
#define   VPP_MATRIX_PROBE_COLOR                   (0x1d5c)
#define P_VPP_MATRIX_PROBE_COLOR                   (volatile uint32_t *)((0x1d5c  << 2) + 0xff900000)
#define   VPP_MATRIX_PROBE_COLOR1                  (0x1dd7)
#define P_VPP_MATRIX_PROBE_COLOR1                  (volatile uint32_t *)((0x1dd7  << 2) + 0xff900000)
//Bit 23:16 component 0
//Bit 15:8  component 1
//Bit 7:0 component 2
#define   VPP_MATRIX_HL_COLOR                      (0x1d5d)
#define P_VPP_MATRIX_HL_COLOR                      (volatile uint32_t *)((0x1d5d  << 2) + 0xff900000)
//28:16 probe x, postion
//12:0  probe y, position
#define   VPP_MATRIX_PROBE_POS                     (0x1d5e)
#define P_VPP_MATRIX_PROBE_POS                     (volatile uint32_t *)((0x1d5e  << 2) + 0xff900000)
//Bit 16,  highlight_en
//Bit 15   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before matrix
//Bit 14:12 probe_sel, 000: select post matrix, 001: select vd1 matrix, 010: select vd2 matrix
//Bit 9:8  matrix coef idx selection, 00: select post matrix, 01: select vd1 matrix, 10: select vd2 matrix
//Bit 5    vd1 conversion matrix enable
//Bit 4    vd2 conversion matrix enable
//Bit 2    output y/cb/cr saturation enable, only for post matrix (y saturate to 16-235, cb/cr saturate to 16-240)
//Bit 1    input y/cb/cr saturation enable, only for post matrix (y saturate to 16-235, cb/cr saturate to 16-240)
//Bit 0    post conversion matrix enable
#define   VPP_MATRIX_CTRL                          (0x1d5f)
#define P_VPP_MATRIX_CTRL                          (volatile uint32_t *)((0x1d5f  << 2) + 0xff900000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define   VPP_MATRIX_COEF00_01                     (0x1d60)
#define P_VPP_MATRIX_COEF00_01                     (volatile uint32_t *)((0x1d60  << 2) + 0xff900000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define   VPP_MATRIX_COEF02_10                     (0x1d61)
#define P_VPP_MATRIX_COEF02_10                     (volatile uint32_t *)((0x1d61  << 2) + 0xff900000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define   VPP_MATRIX_COEF11_12                     (0x1d62)
#define P_VPP_MATRIX_COEF11_12                     (volatile uint32_t *)((0x1d62  << 2) + 0xff900000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define   VPP_MATRIX_COEF20_21                     (0x1d63)
#define P_VPP_MATRIX_COEF20_21                     (volatile uint32_t *)((0x1d63  << 2) + 0xff900000)
#define   VPP_MATRIX_COEF22                        (0x1d64)
#define P_VPP_MATRIX_COEF22                        (volatile uint32_t *)((0x1d64  << 2) + 0xff900000)
//Bit 26:16 offset0
//Bit 10:0  offset1
#define   VPP_MATRIX_OFFSET0_1                     (0x1d65)
#define P_VPP_MATRIX_OFFSET0_1                     (volatile uint32_t *)((0x1d65  << 2) + 0xff900000)
//Bit 10:0  offset2
#define   VPP_MATRIX_OFFSET2                       (0x1d66)
#define P_VPP_MATRIX_OFFSET2                       (volatile uint32_t *)((0x1d66  << 2) + 0xff900000)
//Bit 26:16 pre_offset0
//Bit 10:0  pre_offset1
#define   VPP_MATRIX_PRE_OFFSET0_1                 (0x1d67)
#define P_VPP_MATRIX_PRE_OFFSET0_1                 (volatile uint32_t *)((0x1d67  << 2) + 0xff900000)
//Bit 10:0  pre_offset2
#define   VPP_MATRIX_PRE_OFFSET2                   (0x1d68)
#define P_VPP_MATRIX_PRE_OFFSET2                   (volatile uint32_t *)((0x1d68  << 2) + 0xff900000)
// dummy data used in the VPP postblend
// Bit 23:16    Y
// Bit 15:8     CB
// Bit 7:0      CR
#define   VPP_DUMMY_DATA1                          (0x1d69)
#define P_VPP_DUMMY_DATA1                          (volatile uint32_t *)((0x1d69  << 2) + 0xff900000)
//Bit 31 gainoff module enable
//Bit 26:16 gain0, 1.10 unsigned data
//Bit 10:0  gain1, 1.10 unsigned dat
#define   VPP_GAINOFF_CTRL0                        (0x1d6a)
#define P_VPP_GAINOFF_CTRL0                        (volatile uint32_t *)((0x1d6a  << 2) + 0xff900000)
//Bit 26:16 gain2, 1.10 unsigned data
//Bit 10:0, offset0, signed data
#define   VPP_GAINOFF_CTRL1                        (0x1d6b)
#define P_VPP_GAINOFF_CTRL1                        (volatile uint32_t *)((0x1d6b  << 2) + 0xff900000)
//Bit 26:16, offset1, signed data
//Bit 10:0, offset2, signed data
#define   VPP_GAINOFF_CTRL2                        (0x1d6c)
#define P_VPP_GAINOFF_CTRL2                        (volatile uint32_t *)((0x1d6c  << 2) + 0xff900000)
//Bit 26:16, pre_offset0, signed data
//Bit 10:0, pre_offset1, signed data
#define   VPP_GAINOFF_CTRL3                        (0x1d6d)
#define P_VPP_GAINOFF_CTRL3                        (volatile uint32_t *)((0x1d6d  << 2) + 0xff900000)
//Bit 10:0, pre_offset2, signed data
#define   VPP_GAINOFF_CTRL4                        (0x1d6e)
#define P_VPP_GAINOFF_CTRL4                        (volatile uint32_t *)((0x1d6e  << 2) + 0xff900000)
//only two registers used in the color management, which are defined in the chroma_reg.h
//`define VPP_CHROMA_ADDR_PORT    8'h70
//`define VPP_CHROMA_DATA_PORT    8'h71
//
// Reading file:  chroma_reg.h
//
//**********************************************************************************
//* Copyright (c) 2008, AMLOGIC Inc.
//* All rights reserved
//**********************************************************************************
//* File :  chroma_reg.v
//* Author : Terrence Wang
//* Date : Dec 2008
//* Description :
//*
//**********************************************************************************
//* Modification History:
//* Date    Modified By         Reason
//**********************************************************************************
// synopsys translate_off
// synopsys translate_on
#define   VPP_CHROMA_ADDR_PORT                     (0x1d70)
#define P_VPP_CHROMA_ADDR_PORT                     (volatile uint32_t *)((0x1d70  << 2) + 0xff900000)
#define   VPP_CHROMA_DATA_PORT                     (0x1d71)
#define P_VPP_CHROMA_DATA_PORT                     (volatile uint32_t *)((0x1d71  << 2) + 0xff900000)
//`define CHROMA_ADDR_PORT        8'h67
//`define CHROMA_DATA_PORT        8'h68

//  CHROMA_GAIN_REG_XX(00-07)
//  hue gain, sat gain function control
//  Bit 31      reg_sat_en                  enable sat adjustment in current region
//  Bit 27      reg_sat_increase            sat adjustment increase or decrease
//                                          1'b1: increase  1'b0: decrease
//  Bit 26:25   reg_sat_central_en          sat adjustment with central biggest or one side biggest
//                                          2'b01 central biggest   2'b00 one side biggest
//  Bit 24      reg_sat_shape               when sat adjustment one side biggest, define left or right
//                                          1'b1: left side biggest 1'b0 right side biggest
//  Bit 23:16   reg_sat_gain                define the sat gain when sat adjustment
//                                          0x00-0xff
//  Bit 15      reg_hue_en                  enable hue adjustment in current region
//  Bit 11      reg_hue_clockwise           hue adjustment clockwise or anti-clockwise
//                                          1'b1: clockwise 1'b0: anti-clockwise
//  Bit 10:9    reg_hue_central_en          when hue adjustment, parabola curve or non-symmetry curve
//                                          1'b1: parabola curve    1'b0: non-symmetry curve
//  Bit 8       reg_hue_shape               when non-symmetry curve, define which side change more
//                                          1'b1: right side change more    1'b0: left side change more
//  Bit 7:0     reg_hue_gain                define the hue gain when hue adjustment
//                                          0x00-0x80, note: should be no bigger than 0x80

    #define CHROMA_GAIN_REG00       0x00


//  HUE_HUE_RANGE_REG_XX(00-07)
//  hue range select
//  Bit 31:24   no use now
//  Bit 23:16   reg_hue_shift_range         define the angle of target region
//                                          0x00-0xff,(0x100 means 120 degree though it can not be set)
//                                          must be greater or equal than 8'd8
//  Bit 15      reg_symmetry_en             this is used for create one symmetry region
//                                          the symmetry region hue_shift_start = reg_hue_hue_shift_start + reg_hue_shift_range<<5
//                                          the symmetry region hue_shift_range = reg_hue_shift_range
//                                          in symmetry region, all the sat and hue setting will be same with original region,
//                                          except reg_hue_shape, reg_sat_shape, reg_hue_clockwise will be reversed
//  Bit 14:0    reg_hue_hue_shift_start     define the start angle of target region
//                                          0x6000 means 360 degree
//                                          only region 0 and 1 can exceed 360 degrees.

    #define HUE_HUE_RANGE_REG00     0x01


//  HUE_RANGE_INV_REG_XX
//  Calculation should be follow
//  HUE_RANGE_INV_REG0X[15:0] = ((1<<20)/HUE_HUE_RANGE_REG0X[23:16]+1)>>1
//  HUE_RANGE_INV_REG_XX is to used to save divider

    #define HUE_RANGE_INV_REG00     0x02



//  for belowing each low, high, low_slope, high_slope group:
//            a_____________b
//            /             \               a = low  + 2^low_slope
//           /               \              b = high - 2^high_slope
//          /                 \             low_slope <= 7; high_slope <= 7
//         /                   \            b >= a
//  ______/_____________________\________
//       low                    high
//
//
//  HUE_LUM_RANGE_REG_XX(00-07)
//  luma range selection for hue adjustment
//  Bit 31:24   reg_sat_lum_low             define the low level of luma value for sat adjustment
//                                          0x00-0xff
//  Bit 23:20   reg_hue_lum_high_slope      define the slope area below high level of luma value for hue adjustment
//                                          0x00-0x07
//  Bit 19:16   reg_hue_lum_low_slope       define the slope area above low  level of luma value for hue adjustment
//                                          0x00-0x07
//  Bit 15:8    reg_hue_lum_high            define the high level of luma value for hue adjustment
//                                          0x00-0xff
//  Bit 7:0     reg_hue_lum_low             define the low  level of luma value for hue adjustment
//                                          0x00-0xff

    #define HUE_LUM_RANGE_REG00     0x03

//  HUE_SAT_RANGE_REG_XX(00-07)
//  sat range selection for hue adjustment
//  Bit 31:24   reg_sat_lum_high            define the high level of luma value for sat adjustment
//                                          0x00-0xff
//  Bit 23:20   reg_hue_sat_high_slope      define the slope area below high level of sat value for hue adjustment
//                                          0x00-0x07
//  Bit 19:16   reg_hue_sat_low_slope       define the slope area above low  level of sat value for hue adjustment
//                                          0x00-0x07
//  Bit 15:8    reg_hue_sat_high            define the high level of sat value for hue adjustment
//                                          0x00-0xff
//  Bit 7:0     reg_hue_sat_low             define the low  level of sat value for hue adjustment
//                                          0x00-0xff

    #define HUE_SAT_RANGE_REG00     0x04

//  SAT_SAT_RANGE_REG_XX(00-07)
//  sat range selection for hue adjustment
//  Bit 31:28   reg_sat_lum_high_slope      define the slope area below high level of luma value for sat adjustment
//                                          0x00-0x07
//  Bit 27:24   reg_sat_lum_low_slope       define the slope area above low  level of luma value for sat adjustment
//                                          0x00-0x07
//  Bit 23:20   reg_sat_sat_high_slope      define the slope area below high level of sat value for sat adjustment
//                                          0x00-0x07
//  Bit 19:16   reg_sat_sat_low_slope       define the slope area above low  level of sat value for sat adjustment
//                                          0x00-0x07
//  Bit 15:8    reg_sat_sat_high            define the high level of sat value for sat adjustment
//                                          0x00-0xff
//  Bit 7:0     reg_sat_sat_low             define the low  level of sat value for sat adjustment
//                                          0x00-0xff

    #define SAT_SAT_RANGE_REG00     0x05


    #define CHROMA_GAIN_REG01       0x06
    #define HUE_HUE_RANGE_REG01     0x07
    #define HUE_RANGE_INV_REG01     0x08
    #define HUE_LUM_RANGE_REG01     0x09
    #define HUE_SAT_RANGE_REG01     0x0a
    #define SAT_SAT_RANGE_REG01     0x0b

    #define CHROMA_GAIN_REG02       0x0c
    #define HUE_HUE_RANGE_REG02     0x0d
    #define HUE_RANGE_INV_REG02     0x0e
    #define HUE_LUM_RANGE_REG02     0x0f
    #define HUE_SAT_RANGE_REG02     0x10
    #define SAT_SAT_RANGE_REG02     0x11


    #define CHROMA_GAIN_REG03       0x12
    #define HUE_HUE_RANGE_REG03     0x13
    #define HUE_RANGE_INV_REG03     0x14
    #define HUE_LUM_RANGE_REG03     0x15
    #define HUE_SAT_RANGE_REG03     0x16
    #define SAT_SAT_RANGE_REG03     0x17

    #define CHROMA_GAIN_REG04       0x18
    #define HUE_HUE_RANGE_REG04     0x19
    #define HUE_RANGE_INV_REG04     0x1a
    #define HUE_LUM_RANGE_REG04     0x1b
    #define HUE_SAT_RANGE_REG04     0x1c
    #define SAT_SAT_RANGE_REG04     0x1d

    #define CHROMA_GAIN_REG05       0x1e
    #define HUE_HUE_RANGE_REG05     0x1f
    #define HUE_RANGE_INV_REG05     0x20
    #define HUE_LUM_RANGE_REG05     0x21
    #define HUE_SAT_RANGE_REG05     0x22
    #define SAT_SAT_RANGE_REG05     0x23

    #define CHROMA_GAIN_REG06       0x24
    #define HUE_HUE_RANGE_REG06     0x25
    #define HUE_RANGE_INV_REG06     0x26
    #define HUE_LUM_RANGE_REG06     0x27
    #define HUE_SAT_RANGE_REG06     0x28
    #define SAT_SAT_RANGE_REG06     0x29

    #define CHROMA_GAIN_REG07       0x2a
    #define HUE_HUE_RANGE_REG07     0x2b
    #define HUE_RANGE_INV_REG07     0x2c
    #define HUE_LUM_RANGE_REG07     0x2d
    #define HUE_SAT_RANGE_REG07     0x2e
    #define SAT_SAT_RANGE_REG07     0x2f

//  REG_CHROMA_CONTROL
//  Bit 31      reg_chroma_en               enable color manage function
//                                          1'b1: enable    1'b0: bypass
//  Bit 6       sat_sel                     uv_max or u^2+v^2 selected as sat for reference
//                                          1'b1: uv_max(default)   1'b0: u^2+v^2
//  Bit 5       uv_adj_en                   final uv_adjust enable
//                                          1'b1: enable    1'b0: bypass
//  Bit 2       hue_en                      rgb to hue enable
//                                          1'b1: enable(default)   1'b0: bypass
//  Bit 1:0     csc_sel                     define input YUV with different color type
//                                          2'b00: 601(16-235)  2'b01: 709(16-235)
//                                          2'b10: 601(0-255)   2'b11: 709(0-255)
    #define REG_CHROMA_CONTROL      0x30   // default 32h'80000024
    #define REG_DEMO_CENTER_BAR     0x31   // default 32h'0
    #define REG_DEMO_HLIGHT_MODE    0x32   // default 32h'0
    #define REG_DEMO_OWR_DATA       0x33   // default 32h'0


////===========================================////
//// CM2 ADDR
////===========================================////

    #define SAT_BYYB_NODE_REG0          0x200   // default 32'h0
//Bit 31:24, sat_byyb_node3    the 4th node
//Bit 23:16, sat_byyb_node2    the 3th node
//Bit 15: 8, sat_byyb_node1    signed, the 2th node about saturation
//Bit  7: 0, sat_byyb_node0    signed, the 1th node about saturation
//gain offset along y coordinate,the gain normalized to 128 as "1"

    #define SAT_BYYB_NODE_REG1          0x201   // default 32'h0
//Bit 31:24, sat_byyb_node7     the 8th node
//Bit 23:16, sat_byyb_node6     the 7th node
//Bit 15: 8, sat_byyb_node5     signed, the 6th node about saturation
//Bit  7: 0, sat_byyb_node4     signed, the 5th node about saturation
//gain offset along y coordinate,the gain normalized to 128 as "1"

    #define SAT_BYYB_NODE_REG2          0x202   // default 32'h0
//Bit 31: 8, reserved
//Bit  7: 0, sat_byyb_node4     signed, the 5th node about saturation


    #define SAT_SRC_NODE_REG            0x203   // default 32'h0
//Bit 31:28, reserved
//Bit 27:16, sat_src_node1
//Bit 15:12, reserved
//Bit 11: 0, sat_src_node0     usigned, threshold of input saturation for  first and second piece

    #define CM_ENH_SFT_MODE_REG         0x204   // default 32'h0
//Bit 31: 9, reserved
//Bit  8: 6, hue_lsft_mode        hue offset adjustments scale
//Bit  5: 4, luma_lsft_mode       luma offset adjustments scale for reg_cm2_adj_luma_via_hue
//Bit  3: 2, sat_byy_rsft_mode    saturation gain adjustments scale for reg_cm2_adj_sat_via_y
//Bit  1: 0, sat_byhs_rsft_mode   saturation gain adjustments scale for reg_cm2_adj_sat_via_hs[:][:] 0:no scale up/down 1:dnscale by 2(-128,127)/2

    #define FRM_SIZE_REG                0x205   // default 32'h0
//Bit 31:29, reserved
//Bit 28:16, reg_frm_height       the frame height size
//Bit 15:13, reserved
//Bit 12: 0, reg_frm_width        the frame width size

    #define FITLER_CFG_REG              0x206   // default 32'h0
//Bit 31: 5, reserved
//Bit  4: 4, inteleav_mod         horizontal interleave filter(zero-padding) for 3D considerations 0:using non-zero padding lpf 1:using zero-padding lpf
//Bit  3: 2, lpf_slt_uv           apply cm on lp portion or original video pixels options
//Bit  1: 0, lpf_slt_y            apply cm on lp portion or original video pixels options

    #define CM_GLOBAL_GAIN_REG          0x207   // default 32'h0
//Bit 31:28, reserved
//Bit 27:16, cm2_global_sat     global saturation gain for general color adjustments(0~4095 <=> 0~8),512 normalized to "1"
//Bit 15:12, reserved
//Bit 11: 0, cm2_global_hue     global hue offsets for general color adjustments(0~4095 <=> 0~360 degree)

    #define CM_ENH_CTL_REG              0x208   // default 32'h0
//Bit  31:7, reserved
//Bit     6, hue_adj_en        cm2 hue adjustments
//Bit     5, sat_adj_en        cm2 saturation adjustments
//Bit     4, luma_adj_en       enable signal for cm2 luma adjustments
//Bit     3, reserved
//Bit     2, cm2_filt_en       apply cm on lp portion enable
//Bit     1, cm2_en            cm2 enable signal
//Bit     0, cm1_en

    #define ROI_X_SCOPE_REG             0x209   // default 32'h0
//Bit 31:29, reserved
//Bit 28:16, roi_x_end      ending col index of the region of interest
//Bit 15:13, reserved
//Bit 12: 0, roi_x_beg      start col index of the region of interest

   #define ROI_Y_SCOPE_REG             0x20a   // default 32'h0
//Bit 31:29, reserved
//Bit 28:16, roi_y_end      ending row index of the region of interest
//Bit 15:13, reserved
//Bit 12: 0, roi_y_beg      start row index of the region of interest

    #define POI_XY_DIR_REG              0x20b   // default 32'h0
//Bit 31:29, reserved
//Bit 28:16, poi_y_dir      ending row index of the region of interest
//Bit 15:13, reserved
//Bit 12: 0, poi_x_dir      start row index of the region of interest

    #define COI_Y_SCOPE_REG             0x20c   // default 32'h0
//Bit 31:16, reserved
//Bit 15: 8, coi_y_end
//Bit  7: 0, coi_y_beg

    #define COI_H_SCOPE_REG             0x20d   // default 32'h0
//Bit 31:28, reserved
//Bit 27:16, coi_h_end
//Bit 15:12, reserved
//Bit 11: 0, coi_h_beg        lower bound of hue value for color of interest ,12 bits precision

    #define COI_S_SCOPE_REG             0x20e   // default 32'h0
//Bit 31:28, reserved
//Bit 27:16, coi_s_end
//Bit 15:12, reserved
//Bit 11: 0, coi_s_beg        lower bound of sat value for color of interest ,12 bits precision
    #define IFO_MODE_REG                0x20f   // default 32'h0
//Bit 31:8, reserved
//Bit  7:6, ifo_mode3
//Bit  5:4, ifo_mode2
//Bit  3:2, ifo_mode1
//Bit  1:0, ifo_mode0
    #define POI_RPL_MODE_REG            0x210   // default 32'h0
//Bit 31:4, reserved
//Bit  3:0, poi_rpl_mode          enhance mode control of pixels inside and outside region of interest bit[3:2]control roi
    #define DEMO_OWR_YHS_REG            0x211   // default 32'h0
//Bit 31: 0, demo_owr_yhs

    #define DEMO_POI_Y_REG              0x212   // default 32'h0
//Bit 31: 8, reserved
//Bit  7: 0, luma_data_poi_r       only get locked higher 8bits
    #define DEMO_POI_H_REG              0x213   // default 32'h0
//Bit 31: 12, reserved
//Bit 11: 0, hue_data_poi_r        only get locked higher 12bits
    #define DEMO_POI_S_REG              0x214   // default 32'h0
//Bit 31: 12, reserved
//Bit 11: 0, sat_data_poi_r         only get locked higher 12bits
    //#define LUMA_BYH_LIMT_REG           0x215   // default 32'h0
    #define LUMA_ADJ_LIMT_REG           0x215   // default 32'h0
//Bit 31:24, reserved
//Bit 23:16, luma_lmt_satslp         slope to do the luma adjustment degrade
//Bit 15:12, reserved
//Bit 11:0, luma_lmt_satth           threshold to saturation
    #define SAT_ADJ_LIMT_REG            0x216   // default 32'h0
//Bit 31:24, reserved
//Bit 23:16, sat_lmt_satslp        slope to do the adjustment degrade
//Bit 15:12, reserved
//Bit 11:0, sat_lmt_satth          threshold to saturation
    #define HUE_ADJ_LIMT_REG            0x217   // default 32'h0
//Bit 31: 24, reserved
//Bit 23: 16, hue_lmt_satslp        slope to do the adjustment degrade
//Bit 15: 12, reserved
//Bit 11: 0,  hue_lmt_satth          threshold to saturation
    #define UVHS_OFST_REG               0x218   // default 32'h0
//Bit 31: 24, hs2uv_v_ofst
//Bit 23: 16, hs2uv_u_ofst
//Bit 15: 8,  uv2hs_v_ofst
//Bit  7: 0,  uv2hs_u_ofst
    #define HUE_CFG_PARA_REG            0x219   // default 32'h0
//Bit 31: 17, reserved
//Bit     16, hue_protect_en
//Bit 15: 13, cm2_hue_byhs_mode
//Bit     12, cm2_hue_div_mode
//Bit 11: 0, cm2_before_hue_ofst
    #define DEMO_SPLT_CFG_REG           0x21a   // default 32'h0
//Bit 31: 22, reserved
//Bit 21: 20, demo_split_mode
//Bit 19: 16, demo_split_width        slope to do the adjustment degrade
//Bit 15: 13, reserved
//Bit 12: 0,  demo_split_post           threshold to saturation
    #define DEMO_SPLT_YHS_REG           0x21b   // default 32'h0
//Bit 31: 0,  demo_splt_yhs             threshold to saturation

    #define XVYCC_YSCP_REG              0x21c   // default 32'h0
//Bit 31: 28, reserved
//Bit 27: 16, xvycc_y_max
//Bit 15: 12, reserved
//Bit 11: 0, xvycc_y_min
    #define XVYCC_USCP_REG              0x21d   // default 32'h0
//Bit 31: 28, reserved
//Bit 27: 16, xvycc_u_max
//Bit 15: 12, reserved
//Bit 11: 0, xvycc_u_min
    #define XVYCC_VSCP_REG              0x21e   // default 32'h0
//Bit 31: 28, reserved
//Bit 27: 16, xvycc_v_max
//Bit 15: 12, reserved
//Bit 11: 0, xvycc_v_min

////========= NODE 0 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H00      0x100   // default 32'H0
//Bit 31: 24, reg_cm2_adj_sat_via_hs_2
//Bit 23: 16, reg_cm2_adj_sat_via_hs_1
//Bit 15: 8,  reg_cm2_adj_sat_via_hs_0
//Bit  7: 0, reg_cm2_adj_luma_via_h
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H00      0x101   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H00      0x102   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H00      0x103   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H00      0x104   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 1 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H01      0x108   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H01      0x109   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H01      0x10a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H01      0x10b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H01      0x10c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 2 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H02      0x110   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H02      0x111   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H02      0x112   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H02      0x113   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H02      0x114   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 3 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H03      0x118   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H03      0x119   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H03      0x11a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H03      0x11b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H03      0x11c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 4 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H04      0x120   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H04      0x121   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H04      0x122   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H04      0x123   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H04      0x124   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 5 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H05      0x128   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H05      0x129   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H05      0x12a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H05      0x12b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H05      0x12c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 6 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H06      0x130   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H06      0x131   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H06      0x132   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H06      0x133   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H06      0x134   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 7 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H07      0x138   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H07      0x139   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H07      0x13a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H07      0x13b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H07      0x13c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 8 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H08      0x140   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H08      0x141   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H08      0x142   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H08      0x143   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H08      0x144   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 9 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H09      0x148   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H09      0x149   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H09      0x14a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H09      0x14b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H09      0x14c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 10 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H10      0x150   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H10      0x151   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H10      0x152   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H10      0x153   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H10      0x154   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 11 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H11      0x158   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H11      0x159   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H11      0x15a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H11      0x15b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H11      0x15c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 12 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H12      0x160   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H12      0x161   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H12      0x162   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H12      0x163   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H12      0x164   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 13 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H13      0x168   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H13      0x169   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H13      0x16a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H13      0x16b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H13      0x16c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx


/* Constraints
0)
  there are 16 regions totally. 8 regions are for hue adjustment, 8 regions are for sat adjustment.
  the hue range of the 16 regions can be set to overlap, but if overlap, the hue range(start and end) must be same.
  the 8 regions for hue adjustment should not overlap. if corresponding reg_hue_en_00 - 07 == 1
  the 8 regions for hue adjustment are defined by: (example are for region 0)
    a) hue:
        start: reg_hue_hue_shift_start_00[14:0]
        end:
        if reg_symmetry_en_00 == 0
        reg_hue_hue_shift_start_00[14:0] + (reg_hue_hue_shift_range_00[7:0]<<5)
        if reg_symmetry_en_00 == 1
        reg_hue_hue_shift_start_00[14:0] + (reg_hue_hue_shift_range_00[7:0]<<6)
    b) sat:
        start: reg_hue_sat_low_00
        end:   reg_hue_sat_high_00

  the 8 regions for sat adjustment should not overlap. if corresponding reg_sat_en_00 - 07 == 1
  the 8 regions for sat adjustment are defined by: (example are for region 0)
    a) hue: same as that for hue adjustment.
        start: reg_hue_hue_shift_start_00[14:0]
        end:
        if reg_symmetry_en_00 == 0
        reg_hue_hue_shift_start_00[14:0] + (reg_hue_hue_shift_range_00[7:0]<<5)
        if reg_symmetry_en_00 == 1
        reg_hue_hue_shift_start_00[14:0] + (reg_hue_hue_shift_range_00[7:0]<<6)
    b) sat:
        start: reg_sat_sat_low_00
        end:   reg_sat_sat_high_00

1)
  reg_hue_hue_shift_range_00[7:0]:
  reg_hue_hue_shift_range_01[7:0]:
  reg_hue_hue_shift_range_02[7:0]:
  reg_hue_hue_shift_range_03[7:0]:
  reg_hue_hue_shift_range_04[7:0]:
  reg_hue_hue_shift_range_05[7:0]:
  reg_hue_hue_shift_range_06[7:0]:
  reg_hue_hue_shift_range_07[7:0]:
  must be greater or equal than 8'd8, so as reg_hue_range_inv_regxx can be represented by 0.0000_0000_xxxx_xxxx_xxxx_xxxx

2)
  all regions of 0-7 should meet below requirement. below is just an example for region 7.
  (reg_hue_lum_high_07 - reg_hue_lum_low_07) >=
        (1<<reg_hue_lum_low_slope_07) + (1<<reg_hue_lum_high_slope_07)

  (reg_hue_sat_high_07 - reg_hue_sat_low_07) >=
        (1<<reg_hue_sat_low_slope_07) + (1<<reg_hue_sat_high_slope_07)

  (reg_sat_lum_high_07 - reg_sat_lum_low_07) >=
        (1<<reg_sat_lum_low_slope_07) + (1<<reg_sat_lum_high_slope_07)

  (reg_sat_sat_high_07 - reg_sat_sat_low_07) >=
        (1<<reg_sat_sat_low_slope_07) + (1<<reg_sat_sat_high_slope_07)

3)
  all of reg_hue_hue_shift_start_00[14:0] ~ 07[14:0] < 0x6000.
  only region 0 and 1 can exceed 360 degrees. ie:
    reg_hue_hue_shift_start_00 + (reg_hue_hue_shift_range_00<<5) can greater than 0x6000.
    reg_hue_hue_shift_start_01 + (reg_hue_hue_shift_range_01<<5) can greater than 0x6000.
  but below should be met:
    reg_hue_hue_shift_start_00 + (reg_hue_hue_shift_range_00<<5) < 0x8000. if reg_symmetry_en_00 == 0
    reg_hue_hue_shift_start_01 + (reg_hue_hue_shift_range_00<<5) < 0x8000. if reg_symmetry_en_00 == 0
    reg_hue_hue_shift_start_00 + (reg_hue_hue_shift_range_00<<6) < 0x8000. if reg_symmetry_en_00 == 1
    reg_hue_hue_shift_start_01 + (reg_hue_hue_shift_range_00<<6) < 0x8000. if reg_symmetry_en_00 == 1

  others could not exceed 360 degrees. ie:
    reg_hue_hue_shift_start_02(to 7) + (reg_hue_hue_shift_range_02 (to 7) <<5) < 0x6000. if reg_symmetry_en_02 (to 7) == 0.
    reg_hue_hue_shift_start_02(to 7) + (reg_hue_hue_shift_range_02 (to 7) <<6) < 0x6000. if reg_symmetry_en_02 (to 7) == 1.

4)
  reg_hue_gain_00[7:0] <= 0x80.
  reg_hue_gain_01[7:0] <= 0x80.
  reg_hue_gain_02[7:0] <= 0x80.
  reg_hue_gain_03[7:0] <= 0x80.
  reg_hue_gain_04[7:0] <= 0x80.
  reg_hue_gain_05[7:0] <= 0x80.
  reg_hue_gain_06[7:0] <= 0x80.
  reg_hue_gain_07[7:0] <= 0x80.

5)
  below registers can only have two setting: 00 and 01.
    reg_hue_central_en_00[1:0]  .. _07[1:0]
    reg_sat_central_en_00[1:0]  .. _07[1:0]

6)
  all reg_..._slope_00-07 should not be greater than 7, ie: maximum value is 7.
   for example: below is for region 0:
   reg_hue_lum_low_slope_00[3:0]  <= 7
   reg_hue_lum_high_slope_00[3:0] <= 7
   reg_hue_sat_low_slope_00[3:0]  <= 7
   reg_hue_sat_high_slope_00[3:0] <= 7
   reg_sat_lum_low_slope_00[3:0]  <= 7
   reg_sat_lum_high_slope_00[3:0] <= 7
   reg_sat_sat_low_slope_00[3:0]  <= 7
   reg_sat_sat_high_slope_00[3:0] <= 7
*/

// synopsys translate_off
// synopsys translate_on
//
// Closing file:  chroma_reg.h
//
//(hsvsharp), (blue), gainoff, mat_vd1,mat_vd2, mat_post, prebld, postbld,(hsharp),sco_ff, vadj1, vadj2, ofifo, (chroma1), clk0(free_clk) vpp_reg
//each item 2bits, for each 2bits, if bit 2*i+1 == 1, free clk, else if bit 2*i == 1 no clk, else auto gated clock
//bit1 is not used, because I can not turn off vpp_reg clk because I can not turn on again
//because the register itself canot be set again without clk
//Bit 31:0
#define   VPP_GCLK_CTRL0                           (0x1d72)
#define P_VPP_GCLK_CTRL0                           (volatile uint32_t *)((0x1d72  << 2) + 0xff900000)
//(front_lti), (front_cti), Chroma2_filter, Chroma2, (Ccoring), (blackext), dnlp
//Bit 13:0
#define   VPP_GCLK_CTRL1                           (0x1d73)
#define P_VPP_GCLK_CTRL1                           (volatile uint32_t *)((0x1d73  << 2) + 0xff900000)
//prehsc_clk, line_buf, prevsc, vsc, hsc_clk, clk0(free_clk)
//Bit 11:0
#define   VPP_SC_GCLK_CTRL                         (0x1d74)
#define P_VPP_SC_GCLK_CTRL                         (volatile uint32_t *)((0x1d74  << 2) + 0xff900000)
//Bit 17:9 VD1 alpha for preblend
//Bit 8:0 VD1 alpha for postblend
#define   VPP_MISC1                                (0x1d76)
#define P_VPP_MISC1                                (volatile uint32_t *)((0x1d76  << 2) + 0xff900000)
//Bit 31:0 super scalar clock control
#define   VPP_SRSCL_GCLK_CTRL                      (0x1d77)
#define P_VPP_SRSCL_GCLK_CTRL                      (volatile uint32_t *)((0x1d77  << 2) + 0xff900000)
//Bit 31:0 OSD super scalar clock control
#define   VPP_OSDSR_GCLK_CTRL                      (0x1d78)
#define P_VPP_OSDSR_GCLK_CTRL                      (volatile uint32_t *)((0x1d78  << 2) + 0xff900000)
//Bit 31:0 vvycc clock control
#define   VPP_XVYCC_GCLK_CTRL                      (0x1d79)
#define P_VPP_XVYCC_GCLK_CTRL                      (volatile uint32_t *)((0x1d79  << 2) + 0xff900000)
//Bit 31:24     blackext_start
//Bit 23:16     blackext_slope1
//Bit 15:8      blackext_midpt
//Bit 7:0       blackext_slope2
#define   VPP_BLACKEXT_CTRL                        (0x1d80)
#define P_VPP_BLACKEXT_CTRL                        (volatile uint32_t *)((0x1d80  << 2) + 0xff900000)
//Bit 31:24     bottom of region03 output value
//Bit 23:16     bottom of region02 output value
//Bit 15:8      bottom of region01 output value
//Bit 7:0       bottom of region00 output value
#define   VPP_DNLP_CTRL_00                         (0x1d81)
#define P_VPP_DNLP_CTRL_00                         (volatile uint32_t *)((0x1d81  << 2) + 0xff900000)
//Bit 31:24     bottom of region07 output value
//Bit 23:16     bottom of region06 output value
//Bit 15:8      bottom of region05 output value
//Bit 7:0       bottom of region04 output value
#define   VPP_DNLP_CTRL_01                         (0x1d82)
#define P_VPP_DNLP_CTRL_01                         (volatile uint32_t *)((0x1d82  << 2) + 0xff900000)
//Bit 31:24     bottom of region11 output value
//Bit 23:16     bottom of region10 output value
//Bit 15:8      bottom of region09 output value
//Bit 7:0       bottom of region08 output value
#define   VPP_DNLP_CTRL_02                         (0x1d83)
#define P_VPP_DNLP_CTRL_02                         (volatile uint32_t *)((0x1d83  << 2) + 0xff900000)
//Bit 31:24     bottom of region15 output value
//Bit 23:16     bottom of region14 output value
//Bit 15:8      bottom of region13 output value
//Bit 7:0       bottom of region12 output value
#define   VPP_DNLP_CTRL_03                         (0x1d84)
#define P_VPP_DNLP_CTRL_03                         (volatile uint32_t *)((0x1d84  << 2) + 0xff900000)
//Bit 31:24     bottom of region19 output value
//Bit 23:16     bottom of region18 output value
//Bit 15:8      bottom of region17 output value
//Bit 7:0       bottom of region16 output value
#define   VPP_DNLP_CTRL_04                         (0x1d85)
#define P_VPP_DNLP_CTRL_04                         (volatile uint32_t *)((0x1d85  << 2) + 0xff900000)
//Bit 31:24     bottom of region23 output value
//Bit 23:16     bottom of region22 output value
//Bit 15:8      bottom of region21 output value
//Bit 7:0       bottom of region20 output value
#define   VPP_DNLP_CTRL_05                         (0x1d86)
#define P_VPP_DNLP_CTRL_05                         (volatile uint32_t *)((0x1d86  << 2) + 0xff900000)
//Bit 31:24     bottom of region27 output value
//Bit 23:16     bottom of region26 output value
//Bit 15:8      bottom of region25 output value
//Bit 7:0       bottom of region24 output value
#define   VPP_DNLP_CTRL_06                         (0x1d87)
#define P_VPP_DNLP_CTRL_06                         (volatile uint32_t *)((0x1d87  << 2) + 0xff900000)
//Bit 31:24     bottom of region31 output value
//Bit 23:16     bottom of region30 output value
//Bit 15:8      bottom of region29 output value
//Bit 7:0       bottom of region28 output value
#define   VPP_DNLP_CTRL_07                         (0x1d88)
#define P_VPP_DNLP_CTRL_07                         (volatile uint32_t *)((0x1d88  << 2) + 0xff900000)
//Bit 31:24     bottom of region35 output value
//Bit 23:16     bottom of region34 output value
//Bit 15:8      bottom of region33 output value
//Bit 7:0       bottom of region32 output value
#define   VPP_DNLP_CTRL_08                         (0x1d89)
#define P_VPP_DNLP_CTRL_08                         (volatile uint32_t *)((0x1d89  << 2) + 0xff900000)
//Bit 31:24     bottom of region39 output value
//Bit 23:16     bottom of region38 output value
//Bit 15:8      bottom of region37 output value
//Bit 7:0       bottom of region36 output value
#define   VPP_DNLP_CTRL_09                         (0x1d8a)
#define P_VPP_DNLP_CTRL_09                         (volatile uint32_t *)((0x1d8a  << 2) + 0xff900000)
//Bit 31:24     bottom of region43 output value
//Bit 23:16     bottom of region42 output value
//Bit 15:8      bottom of region41 output value
//Bit 7:0       bottom of region40 output value
#define   VPP_DNLP_CTRL_10                         (0x1d8b)
#define P_VPP_DNLP_CTRL_10                         (volatile uint32_t *)((0x1d8b  << 2) + 0xff900000)
//Bit 31:24     bottom of region47 output value
//Bit 23:16     bottom of region46 output value
//Bit 15:8      bottom of region45 output value
//Bit 7:0       bottom of region44 output value
#define   VPP_DNLP_CTRL_11                         (0x1d8c)
#define P_VPP_DNLP_CTRL_11                         (volatile uint32_t *)((0x1d8c  << 2) + 0xff900000)
//Bit 31:24     bottom of region51 output value
//Bit 23:16     bottom of region50 output value
//Bit 15:8      bottom of region49 output value
//Bit 7:0       bottom of region48 output value
#define   VPP_DNLP_CTRL_12                         (0x1d8d)
#define P_VPP_DNLP_CTRL_12                         (volatile uint32_t *)((0x1d8d  << 2) + 0xff900000)
//Bit 31:24     bottom of region55 output value
//Bit 23:16     bottom of region54 output value
//Bit 15:8      bottom of region53 output value
//Bit 7:0       bottom of region52 output value
#define   VPP_DNLP_CTRL_13                         (0x1d8e)
#define P_VPP_DNLP_CTRL_13                         (volatile uint32_t *)((0x1d8e  << 2) + 0xff900000)
//Bit 31:24     bottom of region59 output value
//Bit 23:16     bottom of region58 output value
//Bit 15:8      bottom of region57 output value
//Bit 7:0       bottom of region56 output value
#define   VPP_DNLP_CTRL_14                         (0x1d8f)
#define P_VPP_DNLP_CTRL_14                         (volatile uint32_t *)((0x1d8f  << 2) + 0xff900000)
//Bit 31:24     bottom of region63 output value
//Bit 23:16     bottom of region62 output value
//Bit 15:8      bottom of region61 output value
//Bit 7:0       bottom of region60 output value
#define   VPP_DNLP_CTRL_15                         (0x1d90)
#define P_VPP_DNLP_CTRL_15                         (volatile uint32_t *)((0x1d90  << 2) + 0xff900000)
// `define VPP_PEAKING_HGAIN       8'h91   //32'h0
// `define VPP_PEAKING_VGAIN       8'h92   //32'h0
// `define VPP_PEAKING_NLP_1       8'h93   //32'h0
// `define VPP_PEAKING_NLP_2       8'h94   //32'h0
// `define VPP_PEAKING_NLP_3       8'h95   //32'h0
// `define VPP_PEAKING_NLP_4       8'h96   //32'h0
// `define VPP_PEAKING_NLP_5       8'h97   //32'h0
// `define VPP_SHARP_LIMIT         8'h98   //32'h0
// `define VPP_VLTI_CTRL           8'h99   //32'h0
// `define VPP_HLTI_CTRL           8'h9a   //32'h0
// `define VPP_CTI_CTRL            8'h9b   //32'h0
#define   VPP_SRSHARP0_CTRL                        (0x1d91)
#define P_VPP_SRSHARP0_CTRL                        (volatile uint32_t *)((0x1d91  << 2) + 0xff900000)
//Bit 31:29  reserved
//Bit 28:16  srsharp_demo_split_sz   srsharp demo top/bot left/right width
//Bit 15:6   reserved
//Bit 5:4    srsharp_demo_disp_post  srsharp demo display postion
//Bit 3      srsharp_demo_en         srsharp demo enable
//Bit 2      srsharp_c444to422_en    srsharp format444 convert 422 enable
//Bit 1,     srsharp_buf_en          srsharp buffer enable
//Bit 0,     srsharp_en              srsharp enable
#define   VPP_SRSHARP1_CTRL                        (0x1d92)
#define P_VPP_SRSHARP1_CTRL                        (volatile uint32_t *)((0x1d92  << 2) + 0xff900000)
//Bit 31:29  reserved
//Bit 28:16  srsharp_demo_split_sz   srsharp demo top/bot left/right width
//Bit 15:6   reserved
//Bit 5:4    srsharp_demo_disp_post  srsharp demo display postion
//Bit 3      srsharp_demo_en         srsharp demo enable
//Bit 2      srsharp_c444to422_en    srsharp format444 convert 422 enable
//Bit 1,     srsharp_buf_en          srsharp buffer enable
//Bit 0,     srsharp_en              srsharp enable
#define   VPP_DOLBY_CTRL                           (0x1d93)
#define P_VPP_DOLBY_CTRL                           (volatile uint32_t *)((0x1d93  << 2) + 0xff900000)
//todo
#define   VPP_DAT_CONV_PARA0                       (0x1d94)
#define P_VPP_DAT_CONV_PARA0                       (volatile uint32_t *)((0x1d94  << 2) + 0xff900000)
#define   VPP_DAT_CONV_PARA1                       (0x1d95)
#define P_VPP_DAT_CONV_PARA1                       (volatile uint32_t *)((0x1d95  << 2) + 0xff900000)
//todo
#define   VPP_SYNC_SEL0                            (0x1d96)
#define P_VPP_SYNC_SEL0                            (volatile uint32_t *)((0x1d96  << 2) + 0xff900000)
#define   VPP_VADJ1_BLACK_VAL                      (0x1d97)
#define P_VPP_VADJ1_BLACK_VAL                      (volatile uint32_t *)((0x1d97  << 2) + 0xff900000)
#define   VPP_VADJ2_BLACK_VAL                      (0x1d98)
#define P_VPP_VADJ2_BLACK_VAL                      (volatile uint32_t *)((0x1d98  << 2) + 0xff900000)
//Bit 29        blue_stretch_cb_inc
//Bit 28        blue_stretch_cr_inc
//Bit 27        the MSB of blue_stretch_error_crp_inv[11:0]
//Bit 26        the MSB of blue_stretch_error_crn_inv[11:0]
//Bit 25        the MSB of blue_stretch_error_cbp_inv[11:0]
//Bit 24        the MSB of blue_stretch_error_cbn_inv[11:0]
//Bit 23:16     blue_stretch_gain
//Bit 15:8      blue_stretch_gain_cb4cr
//Bit 7:0       blue_stretch_luma_high
#define   VPP_BLUE_STRETCH_1                       (0x1d9c)
#define P_VPP_BLUE_STRETCH_1                       (volatile uint32_t *)((0x1d9c  << 2) + 0xff900000)
//Bit 31:27     blue_stretch_error_crp
//Bit 26:16     the 11 LSB of blue_stretch_error_crp_inv[11:0]
//Bit 15:11     blue_stretch_error_crn
//Bit 10:0      the 11 LSB of blue_stretch_error_crn_inv[11:0]
#define   VPP_BLUE_STRETCH_2                       (0x1d9d)
#define P_VPP_BLUE_STRETCH_2                       (volatile uint32_t *)((0x1d9d  << 2) + 0xff900000)
//Bit 31:27     blue_stretch_error_cbp
//Bit 26:16     the 11 LSB of blue_stretch_error_cbp_inv[11:0]
//Bit 15:11     blue_stretch_error_cbn
//Bit 10:0      the 11 LSB of blue_stretch_error_cbn_inv[11:0]
#define   VPP_BLUE_STRETCH_3                       (0x1d9e)
#define P_VPP_BLUE_STRETCH_3                       (volatile uint32_t *)((0x1d9e  << 2) + 0xff900000)
//Bit 25:16 bypass_ccoring_ythd
//Bit 15:8, Chroma coring threshold
//Bit 3:0, Chroma coring slope
#define   VPP_CCORING_CTRL                         (0x1da0)
#define P_VPP_CCORING_CTRL                         (volatile uint32_t *)((0x1da0  << 2) + 0xff900000)
//Bit 20 demo chroma coring enable
//Bit 19 demo black extension enable
//Bit 18 demo dynamic nonlinear luma processing enable
//Bit 17 demo hsvsharp enable
//Bit 16 demo bluestretch enable
//Bit 15:14, 2'b00: demo adjust on top, 2'b01: demo adjust on bottom, 2'b10: demo adjust on left, 2'b11: demo adjust on right
//Bit 4 chroma coring enable
//Bit 3 black extension enable
//Bit 2 dynamic nonlinear luma processing enable
//Bit 1 hsvsharp enable
//Bit 0 bluestretch enable
#define   VPP_VE_ENABLE_CTRL                       (0x1da1)
#define P_VPP_VE_ENABLE_CTRL                       (volatile uint32_t *)((0x1da1  << 2) + 0xff900000)
//Bit 12:0, demo left or top screen width
#define   VPP_VE_DEMO_LEFT_TOP_SCREEN_WIDTH        (0x1da2)
#define P_VPP_VE_DEMO_LEFT_TOP_SCREEN_WIDTH        (volatile uint32_t *)((0x1da2  << 2) + 0xff900000)
#define   VPP_VE_DEMO_CENTER_BAR                   (0x1da3)
#define P_VPP_VE_DEMO_CENTER_BAR                   (volatile uint32_t *)((0x1da3  << 2) + 0xff900000)
//28:16  ve_line_length
//12:0   ve_pic_height
#define   VPP_VE_H_V_SIZE                          (0x1da4)
#define P_VPP_VE_H_V_SIZE                          (volatile uint32_t *)((0x1da4  << 2) + 0xff900000)
//28:16  vppout_line_length
//12:0   vppout_pic_height
#define   VPP_OUT_H_V_SIZE                         (0x1da5)
#define P_VPP_OUT_H_V_SIZE                         (volatile uint32_t *)((0x1da5  << 2) + 0xff900000)
//28:16  vppin_line_length
//12:0   vppin_pic_height
#define   VPP_IN_H_V_SIZE                          (0x1da6)
#define P_VPP_IN_H_V_SIZE                          (volatile uint32_t *)((0x1da6  << 2) + 0xff900000)
//Bit 10   reset bit, high active
//Bit 9    0: measuring rising edge, 1: measuring falling edge
//Bit 8    if true, accumulate the counter number, otherwise not
//Bit 7:0  vsync_span, define how many vsync span need to measure
#define   VPP_VDO_MEAS_CTRL                        (0x1da8)
#define P_VPP_VDO_MEAS_CTRL                        (volatile uint32_t *)((0x1da8  << 2) + 0xff900000)
//Read only
//19:16  ind_meas_count_n, every number of sync_span vsyncs, this counter add 1
//15:0, high bit portion of counter
#define   VPP_VDO_MEAS_VS_COUNT_HI                 (0x1da9)
#define P_VPP_VDO_MEAS_VS_COUNT_HI                 (volatile uint32_t *)((0x1da9  << 2) + 0xff900000)
//Read only
//31:0, low bit portion of counter
#define   VPP_VDO_MEAS_VS_COUNT_LO                 (0x1daa)
#define P_VPP_VDO_MEAS_VS_COUNT_LO                 (volatile uint32_t *)((0x1daa  << 2) + 0xff900000)
//bit 11:9 vd2_sel,  001: select vd1_din, 010: select vd2_din, 011: select d2d3_l_din, 100: d2d3_r_din, otherwise no selection
//bit 8:6 vd1_l_sel, 001: select vd1_din, 010: select vd2_din, 011: select d2d3_l_din, 100: d2d3_r_din, otherwise no selection
//bit 5:3 vd1_r_sel, 001: select vd1_din, 010: select vd2_din, 011: select d2d3_l_din, 100: d2d3_r_din, otherwise no selection
//note: the source vd1_l_sel selected cannot be used as the source of vd1_r_sel or vd2_sel
// vd1_r_sel is useful only vd1_interleave_mode is not 00. And the source vd1_r_sel used can not used for the vd2_sel any more.
//bit 2:0 vd1_interleave_mode, 000: no interleave, 001: pixel interleaving, 010: line interleaving, 011: 2 pixel interleaving,
// 100: 2 line interleaving
#define   VPP_INPUT_CTRL                           (0x1dab)
#define P_VPP_INPUT_CTRL                           (volatile uint32_t *)((0x1dab  << 2) + 0xff900000)
//bit 25:24 cti_bpf_sel
//bit 20:16 cti_blend_factor_gama
//bit 12:8 cti_blend_factor_beta
//bit 4:0 cti_blend_factor_alpha
#define   VPP_CTI_CTRL2                            (0x1dac)
#define P_VPP_CTI_CTRL2                            (volatile uint32_t *)((0x1dac  << 2) + 0xff900000)
#define   VPP_PEAKING_SAT_THD1                     (0x1dad)
#define P_VPP_PEAKING_SAT_THD1                     (volatile uint32_t *)((0x1dad  << 2) + 0xff900000)
#define   VPP_PEAKING_SAT_THD2                     (0x1dae)
#define P_VPP_PEAKING_SAT_THD2                     (volatile uint32_t *)((0x1dae  << 2) + 0xff900000)
#define   VPP_PEAKING_SAT_THD3                     (0x1daf)
#define P_VPP_PEAKING_SAT_THD3                     (volatile uint32_t *)((0x1daf  << 2) + 0xff900000)
#define   VPP_PEAKING_SAT_THD4                     (0x1db0)
#define P_VPP_PEAKING_SAT_THD4                     (volatile uint32_t *)((0x1db0  << 2) + 0xff900000)
#define   VPP_PEAKING_SAT_THD5                     (0x1db1)
#define P_VPP_PEAKING_SAT_THD5                     (volatile uint32_t *)((0x1db1  << 2) + 0xff900000)
#define   VPP_PEAKING_SAT_THD6                     (0x1db2)
#define P_VPP_PEAKING_SAT_THD6                     (volatile uint32_t *)((0x1db2  << 2) + 0xff900000)
#define   VPP_PEAKING_SAT_THD7                     (0x1db3)
#define P_VPP_PEAKING_SAT_THD7                     (volatile uint32_t *)((0x1db3  << 2) + 0xff900000)
#define   VPP_PEAKING_SAT_THD8                     (0x1db4)
#define P_VPP_PEAKING_SAT_THD8                     (volatile uint32_t *)((0x1db4  << 2) + 0xff900000)
#define   VPP_PEAKING_SAT_THD9                     (0x1db5)
#define P_VPP_PEAKING_SAT_THD9                     (volatile uint32_t *)((0x1db5  << 2) + 0xff900000)
#define   VPP_PEAKING_GAIN_ADD1                    (0x1db6)
#define P_VPP_PEAKING_GAIN_ADD1                    (volatile uint32_t *)((0x1db6  << 2) + 0xff900000)
#define   VPP_PEAKING_GAIN_ADD2                    (0x1db7)
#define P_VPP_PEAKING_GAIN_ADD2                    (volatile uint32_t *)((0x1db7  << 2) + 0xff900000)
//bit 23:16 peaking_dnlp_gain, u5.3, DNLP effect
//bit 15:8  peaking_factor
//bit 5     peaking_dnlp_demo_en
//bit 4     peaking_dnlp_en
//bit 3:0   peaking_filter_sel
#define   VPP_PEAKING_DNLP                         (0x1db8)
#define P_VPP_PEAKING_DNLP                         (volatile uint32_t *)((0x1db8  << 2) + 0xff900000)
//bit 24    sharp_demo_win_en
//bit 23:12 sharp_demo_win_vend
//bit 11:0  sharp_demo_win_vstart
#define   VPP_SHARP_DEMO_WIN_CTRL1                 (0x1db9)
#define P_VPP_SHARP_DEMO_WIN_CTRL1                 (volatile uint32_t *)((0x1db9  << 2) + 0xff900000)
//bit 23:12 sharp_demo_win_hend
//bit 11:0  sharp_demo_win_hstart
#define   VPP_SHARP_DEMO_WIN_CTRL2                 (0x1dba)
#define P_VPP_SHARP_DEMO_WIN_CTRL2                 (volatile uint32_t *)((0x1dba  << 2) + 0xff900000)
//Bit 31:24     front_hlti_neg_gain
//Bit 23:16     front_hlti_pos_gain
//Bit 15:8      front_hlti_threshold
//Bit 7:0       front_hlti_blend_factor
#define   VPP_FRONT_HLTI_CTRL                      (0x1dbb)
#define P_VPP_FRONT_HLTI_CTRL                      (volatile uint32_t *)((0x1dbb  << 2) + 0xff900000)
//Bit 31        front_enable, enable the front LTI&CTI before scaler
//Bit 26:24     front_cti_step2
//Bit 23:21     front_cti_step
//Bit 20:16     front_cti_blend_factor
//Bit 15        front_cti_median_mode
//Bit 14:8      front_cti_threshold
//Bit 7:0       front_cti_gain
#define   VPP_FRONT_CTI_CTRL                       (0x1dbc)
#define P_VPP_FRONT_CTI_CTRL                       (volatile uint32_t *)((0x1dbc  << 2) + 0xff900000)
//bit 29:28 front_hlti_step
//bit 25:24 front_cti_bpf_sel
//bit 20:16 front_cti_blend_factor_gama
//bit 12:8  front_cti_blend_factor_beta
//bit 4:0   front_cti_blend_factor_alpha
#define   VPP_FRONT_CTI_CTRL2                      (0x1dbd)
#define P_VPP_FRONT_CTI_CTRL2                      (volatile uint32_t *)((0x1dbd  << 2) + 0xff900000)
//vertical scaler phase step
//Bit 27:0,  4.24 format
#define   VPP_OSD_VSC_PHASE_STEP                   (0x1dc0)
#define P_VPP_OSD_VSC_PHASE_STEP                   (volatile uint32_t *)((0x1dc0  << 2) + 0xff900000)
//Bit 31:16, bottom vertical scaler initial phase
//Bit 15:0, top vertical scaler initial phase
#define   VPP_OSD_VSC_INI_PHASE                    (0x1dc1)
#define P_VPP_OSD_VSC_INI_PHASE                    (volatile uint32_t *)((0x1dc1  << 2) + 0xff900000)
//Bit 24    osd vertical Scaler enable
//Bit 23    osd_prog_interlace 0: current field is progressive, 1: current field is interlace
//Bit 22:21 osd_vsc_double_line_mode, bit1, double input width and half input height, bit0, change line buffer becomes 2 lines
//Bit 20    osd_vsc_phase0_always_en
//Bit 19    osd_vsc_nearest_en
//Bit 17:16 osd_vsc_bot_rpt_l0_num
//Bit 14:11 osd_vsc_bot_ini_rcv_num
//Bit 9:8   osd_vsc_top_rpt_l0_num
//Bit 6:3   osd_vsc_top_ini_rcv_num
//Bit 2:0   osd_vsc_bank_length
#define   VPP_OSD_VSC_CTRL0                        (0x1dc2)
#define P_VPP_OSD_VSC_CTRL0                        (volatile uint32_t *)((0x1dc2  << 2) + 0xff900000)
//horizontal scaler phase step
//Bit 27:0,  4.24 format
#define   VPP_OSD_HSC_PHASE_STEP                   (0x1dc3)
#define P_VPP_OSD_HSC_PHASE_STEP                   (volatile uint32_t *)((0x1dc3  << 2) + 0xff900000)
//Bit 31:16, horizontal scaler initial phase1
//Bit 15:0, horizontal scaler initial phase0
#define   VPP_OSD_HSC_INI_PHASE                    (0x1dc4)
#define P_VPP_OSD_HSC_INI_PHASE                    (volatile uint32_t *)((0x1dc4  << 2) + 0xff900000)
//Bit 22   osd horizontal scaler enable
//Bit 21   osd_hsc_double_pix_mode
//Bit 20   osd_hsc_phase0_always_en
//Bit 19   osd_hsc_nearest_en
//Bit 17:16 osd_hsc_rpt_p0_num1
//Bit 14:11 osd_hsc_ini_rcv_num1
//Bit 9:8   osd_hsc_rpt_p0_num0
//Bit 6:3   osd_hsc_ini_rcv_num0
//Bit 2:0   osd_hsc_bank_length
#define   VPP_OSD_HSC_CTRL0                        (0x1dc5)
#define P_VPP_OSD_HSC_CTRL0                        (volatile uint32_t *)((0x1dc5  << 2) + 0xff900000)
//for 3D quincunx sub-sampling
//bit 15:8 pattern, each patten 1 bit, from lsb -> msb
//bit 6:4  pattern start
//bit 2:0  pattern end
#define   VPP_OSD_HSC_INI_PAT_CTRL                 (0x1dc6)
#define P_VPP_OSD_HSC_INI_PAT_CTRL                 (volatile uint32_t *)((0x1dc6  << 2) + 0xff900000)
//bit 31:24, componet 0
//bit 23:16, component 1
//bit 15:8, component 2
//bit 7:0 component 3, alpha
#define   VPP_OSD_SC_DUMMY_DATA                    (0x1dc7)
#define P_VPP_OSD_SC_DUMMY_DATA                    (volatile uint32_t *)((0x1dc7  << 2) + 0xff900000)
//Bit 14 osc_sc_din_osd1_alpha_mode, 1: (alpha >= 128) ? alpha -1: alpha,  0: (alpha >=1) ? alpha - 1: alpha.
//Bit 13 osc_sc_din_osd2_alpha_mode, 1: (alpha >= 128) ? alpha -1: alpha,  0: (alpha >=1) ? alpha - 1: alpha.
//Bit 12 osc_sc_dout_alpha_mode, 1: (alpha >= 128) ? alpha + 1: alpha, 0: (alpha >=1) ? alpha + 1: alpha.
//Bit 12 osc_sc_alpha_mode, 1: (alpha >= 128) ? alpha + 1: alpha, 0: (alpha >=1) ? alpha + 1: alpha.
//Bit 11:4 default alpha for vd1 or vd2 if they are selected as the source
//Bit 3 osd scaler path enable
//Bit 1:0 osd_sc_sel, 00: select osd1 input, 01: select osd2 input, 10: select vd1 input, 11: select vd2 input after matrix
#define   VPP_OSD_SC_CTRL0                         (0x1dc8)
#define P_VPP_OSD_SC_CTRL0                         (volatile uint32_t *)((0x1dc8  << 2) + 0xff900000)
//Bit 28:16 OSD scaler input width minus 1
//Bit 12:0 OSD scaler input height minus 1
#define   VPP_OSD_SCI_WH_M1                        (0x1dc9)
#define P_VPP_OSD_SCI_WH_M1                        (volatile uint32_t *)((0x1dc9  << 2) + 0xff900000)
//Bit 28:16 OSD scaler output horizontal start
//Bit 12:0 OSD scaler output horizontal end
#define   VPP_OSD_SCO_H_START_END                  (0x1dca)
#define P_VPP_OSD_SCO_H_START_END                  (volatile uint32_t *)((0x1dca  << 2) + 0xff900000)
//Bit 28:16 OSD scaler output vertical start
//Bit 12:0 OSD scaler output vertical end
#define   VPP_OSD_SCO_V_START_END                  (0x1dcb)
#define P_VPP_OSD_SCO_V_START_END                  (volatile uint32_t *)((0x1dcb  << 2) + 0xff900000)
//Because there are many coefficients used in the vertical filter and horizontal filters,
//indirect access the coefficients of vertical filter and horizontal filter is used.
//For vertical filter, there are 33x4 coefficients
//For horizontal filter, there are 33x4 coefficients
//Bit 15    index increment, if bit9 == 1  then (0: index increase 1, 1: index increase 2) else (index increase 2)
//Bit 14    1: read coef through cbus enable, just for debug purpose in case when we wanna check the coef in ram in correct or not
//Bit 9     if true, use 9bit resolution coef, other use 8bit resolution coef
//Bit 8   type of index, 0: vertical coef,  1: horizontal coef
//Bit 6:0   coef index
#define   VPP_OSD_SCALE_COEF_IDX                   (0x1dcc)
#define P_VPP_OSD_SCALE_COEF_IDX                   (volatile uint32_t *)((0x1dcc  << 2) + 0xff900000)
//coefficients for vertical filter and horizontal filter
#define   VPP_OSD_SCALE_COEF                       (0x1dcd)
#define P_VPP_OSD_SCALE_COEF                       (volatile uint32_t *)((0x1dcd  << 2) + 0xff900000)
//Bit 12:0 line number use to generate interrupt when line == this number
#define   VPP_INT_LINE_NUM                         (0x1dce)
#define P_VPP_INT_LINE_NUM                         (volatile uint32_t *)((0x1dce  << 2) + 0xff900000)
#define   VPP_XVYCC_MISC                           (0x1dcf)
#define P_VPP_XVYCC_MISC                           (volatile uint32_t *)((0x1dcf  << 2) + 0xff900000)
// new add lti/cti in 120924
//Bit  3: 0        //default== 0  reg_hlti_dn_flt_coe[0]
//Bit  7: 4        //default== 0  reg_hlti_dn_flt_coe[1]
//Bit 11: 8        //default== 0  reg_hlti_dn_flt_coe[2]
//Bit 15:12        //default== 2  reg_hlti_dn_flt_coe[3]
//Bit 19:16        //default== 4  reg_hlti_dn_flt_coe[4]
//Bit 22:20        //default== 3  reg_hlti_dn_flt_nrm  u3: 3~7
#define   VPP_HLTI_DN_FLT                          (0x1dd0)
#define P_VPP_HLTI_DN_FLT                          (volatile uint32_t *)((0x1dd0  << 2) + 0xff900000)
//Bit  7: 0        //default== 8  reg_hlti_bst_gain  u8, norm 16 as "1"
//Bit 15: 8        //default== 20 reg_hlti_bst_core  u8, norm 32 as "1"
//Bit 23:16        //default== 32 reg_hlti_oob_gain  u8, norm 32 as "1"
//Bit 28:24        //default== 0  reg_hlti_oob_core  u5
#define   VPP_HLTI_GAIN                            (0x1dd1)
#define P_VPP_HLTI_GAIN                            (volatile uint32_t *)((0x1dd1  << 2) + 0xff900000)
//Bit  7: 0        //default== 2  reg_hlti_clp_ofst  u8,
//Bit     8        //default== 0  reg_hlti_clp_mode  u1,
//Bit 11: 9        //default== 1  reg_hlti_clp_wind  u3,
//Bit 14:12        //default== 1  reg_hlti_bst_fltr  u3,
//Bit    15        //default== 1  reg_hlti_enable    u1,
#define   VPP_HLTI_PARA                            (0x1dd2)
#define P_VPP_HLTI_PARA                            (volatile uint32_t *)((0x1dd2  << 2) + 0xff900000)
//Bit  3: 0        //default== 0  reg_hcti_dn_flt_coe[0]
//Bit  7: 4        //default== 0  reg_hcti_dn_flt_coe[1]
//Bit 11: 8        //default== 1  reg_hcti_dn_flt_coe[2]
//Bit 15:12        //default== 2  reg_hcti_dn_flt_coe[3]
//Bit 19:16        //default== 2  reg_hcti_dn_flt_coe[4]
//Bit 22:20        //default== 3  reg_hcti_dn_flt_nrm   u3: 3~7
#define   VPP_HCTI_DN_FLT                          (0x1dd3)
#define P_VPP_HCTI_DN_FLT                          (volatile uint32_t *)((0x1dd3  << 2) + 0xff900000)
//Bit 7: 0        //default== 48 reg_hcti_bst_gain  u8, norm 16 as "1"
//Bit15: 8        //default== 17 reg_hcti_bst_core  u8, norm 32 as "1"
//Bit23:16        //default== 16 reg_hcti_oob_gain  u8, norm 32 as "1"
//Bit28:24        //default==  0 reg_hcti_oob_core  u5
#define   VPP_HCTI_GAIN                            (0x1dd4)
#define P_VPP_HCTI_GAIN                            (volatile uint32_t *)((0x1dd4  << 2) + 0xff900000)
//Bit  7: 0        //default==  0 reg_hcti_clp_ofst  u8,
//Bit     8        //default==  1 reg_hcti_clp_mode  u1,
//Bit 11: 9        //default==  3 reg_hcti_clp_wind  u3,
//Bit 14:12        //default==  6 reg_hcti_bst_fltr  u3,
//Bit    15        //default==  1 reg_hcti_enable    u1,
#define   VPP_HCTI_PARA                            (0x1dd5)
#define P_VPP_HCTI_PARA                            (volatile uint32_t *)((0x1dd5  << 2) + 0xff900000)
//Bit  7: 0        //default== 48 reg_vcti_bst_gain  u8, normalize 16 as "1"
//Bit 15: 8        //default== 10 reg_vcti_bst_core  u8
//Bit 19:16        //default== 10 reg_vcti_clp_ofst  u4
//Bit    20        //default==  1 reg_vcti_clp_wind  u1, 0: wind 3, 1: wind5
#define   VPP_VCTI_PARA                            (0x1dd6)
#define P_VPP_VCTI_PARA                            (volatile uint32_t *)((0x1dd6  << 2) + 0xff900000)
//`define VPP_MATRIX_PROBE_COLOR1 8'hd7  //defined before
//Bit 31          //default== 0, urgent fifo hold enable
//Bit 28:12       //default== 0, urgent fifo hold line threshold
//Bit 15          //default== 0, urgent_ctrl_en
//Bit 14          //default== 0, urgent_wr, if true for write buffer
//Bit 13          //default== 0, out_inv_en
//Bit 12          //default == 0, urgent_ini_value
//Bit 11:6        //default == 0, up_th  up threshold
//Bit 5:0         //default == 0, dn_th  dn threshold
#define   VPP_OFIFO_URG_CTRL                       (0x1dd8)
#define P_VPP_OFIFO_URG_CTRL                       (volatile uint32_t *)((0x1dd8  << 2) + 0xff900000)
#define   VPP_CLIP_MISC0                           (0x1dd9)
#define P_VPP_CLIP_MISC0                           (volatile uint32_t *)((0x1dd9  << 2) + 0xff900000)
//Bit 29:20       // default == 1023, final clip r channel top
//Bit 19:10       // default == 1023, final clip g channel top
//Bit  9: 0       // default == 1023, final clip b channel top
#define   VPP_CLIP_MISC1                           (0x1dda)
#define P_VPP_CLIP_MISC1                           (volatile uint32_t *)((0x1dda  << 2) + 0xff900000)
//Bit 29:20       // default ==    0, final clip r channel bottom
//Bit 19:10       // default ==    0, final clip g channel bottom
//Bit  9: 0       // default ==    0, final clip b channel bottom
#define   VPP_MATRIX_COEF13_14                     (0x1ddb)
#define P_VPP_MATRIX_COEF13_14                     (volatile uint32_t *)((0x1ddb  << 2) + 0xff900000)
//Bit 28:16       // default == 0, matrix coef13
//Bit 12:0        // default == 0, matrix coef14
#define   VPP_MATRIX_COEF23_24                     (0x1ddc)
#define P_VPP_MATRIX_COEF23_24                     (volatile uint32_t *)((0x1ddc  << 2) + 0xff900000)
//Bit 28:16       // default == 0, matrix coef23
//Bit 12:0        // default == 0, matrix coef24
#define   VPP_MATRIX_COEF15_25                     (0x1ddd)
#define P_VPP_MATRIX_COEF15_25                     (volatile uint32_t *)((0x1ddd  << 2) + 0xff900000)
//Bit 28:16       // default == 0, matrix coef15
//Bit 12:0        // default == 0, matrix coef25
#define   VPP_MATRIX_CLIP                          (0x1dde)
#define P_VPP_MATRIX_CLIP                          (volatile uint32_t *)((0x1dde  << 2) + 0xff900000)
//Bit 7:5         //  default == 0,   mat rs
//Bit 4:3         //  default == 0,   mat clmod
//Bit 2:0         //  default == 0,   mat clip enable
#define   VPP_XVYCC_MISC0                          (0x1ddf)
#define P_VPP_XVYCC_MISC0                          (volatile uint32_t *)((0x1ddf  << 2) + 0xff900000)
//Bit 29:20       // default == 1023, xvycc clip r channel top
//Bit 19:10       // default == 1023, xvycc clip g channel top
//Bit  9: 0       // default == 1023, xvycc clip b channel top
#define   VPP_XVYCC_MISC1                          (0x1de0)
#define P_VPP_XVYCC_MISC1                          (volatile uint32_t *)((0x1de0  << 2) + 0xff900000)
//Bit 29:20       // default ==    0, xvycc clip r channel bottom
//Bit 19:10       // default ==    0, xvycc clip g channel bottom
//Bit  9: 0       // default ==    0, xvycc clip b channel bottom
#define   VPP_VD1_CLIP_MISC0                       (0x1de1)
#define P_VPP_VD1_CLIP_MISC0                       (volatile uint32_t *)((0x1de1  << 2) + 0xff900000)
//Bit 29:20       // default == 1023, vd1 clip r channel top
//Bit 19:10       // default == 1023, vd1 clip g channel top
//Bit  9: 0       // default == 1023, vd1 clip b channel top
#define   VPP_VD1_CLIP_MISC1                       (0x1de2)
#define P_VPP_VD1_CLIP_MISC1                       (volatile uint32_t *)((0x1de2  << 2) + 0xff900000)
//Bit 29:20       // default ==    0, vd1 clip r channel bottom
//Bit 19:10       // default ==    0, vd1 clip g channel bottom
//Bit  9: 0       // default ==    0, vd1 clip b channel bottom
#define   VPP_VD2_CLIP_MISC0                       (0x1de3)
#define P_VPP_VD2_CLIP_MISC0                       (volatile uint32_t *)((0x1de3  << 2) + 0xff900000)
//Bit 29:20       // default == 1023, vd2 clip r channel top
//Bit 19:10       // default == 1023, vd2 clip g channel top
//Bit  9: 0       // default == 1023, vd2 clip b channel top
#define   VPP_VD2_CLIP_MISC1                       (0x1de4)
#define P_VPP_VD2_CLIP_MISC1                       (volatile uint32_t *)((0x1de4  << 2) + 0xff900000)
//Bit 29:20       // default ==    0, vd2 clip r channel bottom
//Bit 19:10       // default ==    0, vd2 clip g channel bottom
//Bit  9: 0       // default ==    0, vd2 clip b channel bottom
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpp_regs.h
//
//`define VIU2_VCBUS_BASE                8'h1e
//
// Reading file:  v2regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// Video Interface 2 Registers    0xe00 - 0xeff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VIU2_VCBUS_BASE = 0x1e
// -----------------------------------------------
#define   VIU2_ADDR_START                          (0x1e00)
#define P_VIU2_ADDR_START                          (volatile uint32_t *)((0x1e00  << 2) + 0xff900000)
#define   VIU2_ADDR_END                            (0x1eff)
#define P_VIU2_ADDR_END                            (volatile uint32_t *)((0x1eff  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// VIU2 top-level registers
//------------------------------------------------------------------------------
// Bit  0 RW, osd1_reset
// Bit  1 RW, osd2_reset
// Bit  2 RW, vd1_reset
// Bit  3 RW, vd1_fmt_reset
// Bit  7 RW, vpp_reset
#define   VIU2_SW_RESET                            (0x1e01)
#define P_VIU2_SW_RESET                            (volatile uint32_t *)((0x1e01  << 2) + 0xff900000)
#define   VIU2_SW_RESET0                           (0x1e02)
#define P_VIU2_SW_RESET0                           (volatile uint32_t *)((0x1e02  << 2) + 0xff900000)
// Bit 0 RW, software reset for mcvecrd_mif
// Bit 1 RW, software reset for mcinfowr_mif
// Bit 2 RW, software reset for mcinford_mif
//bit 8 if true, vsync interrup is generate only field == 0
//bit 7:0 fix_disable
#define   VIU2_MISC_CTRL0                          (0x1e06)
#define P_VIU2_MISC_CTRL0                          (volatile uint32_t *)((0x1e06  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// OSD1 registers
//------------------------------------------------------------------------------
// Bit    31 Reserved
// Bit    30 RW, enable_free_clk: 1=use free-running clock to drive logic;
//                                0=use gated clock for low power.
// Bit    29 R, test_rd_dsr
// Bit    28 R, osd_done
// Bit 27:24 R, osd_blk_mode
// Bit 23:22 R, osd_blk_ptr
// Bit    21 R, osd_enable
//
// Bit 20:12 RW, global_alpha
// Bit    11 RW, test_rd_en
// Bit 10: 9 Reserved for control signals
// Bit  8: 5 RW, ctrl_mtch_y
// Bit     4 RW, ctrl_422to444
// Bit  3: 0 RW, osd_blk_enable. Bit 0 to enable block 0: 1=enable, 0=disable;
//                               Bit 1 to enable block 1, and so on.
#define   VIU2_OSD1_CTRL_STAT                      (0x1e10)
#define P_VIU2_OSD1_CTRL_STAT                      (volatile uint32_t *)((0x1e10  << 2) + 0xff900000)
// Bit 31:26 Reserved
// Bit 25:16 R, fifo_count
// Bit 15: 6 Reserved
// Bit  5: 4 RW, hold_fifo_lines[6:5]
// Bit     3 RW, rgb2yuv_full_range
// Bit     2 RW, alpha_9b_mode
// Bit     1 RW, reserved
// Bit     0 RW, color_expand_mode
#define   VIU2_OSD1_CTRL_STAT2                     (0x1e2d)
#define P_VIU2_OSD1_CTRL_STAT2                     (volatile uint32_t *)((0x1e2d  << 2) + 0xff900000)
// Bit 31: 9 Reserved
// Bit     8 RW, 0 = Write LUT, 1 = Read LUT
// Bit  7: 0 RW, lut_addr
#define   VIU2_OSD1_COLOR_ADDR                     (0x1e11)
#define P_VIU2_OSD1_COLOR_ADDR                     (volatile uint32_t *)((0x1e11  << 2) + 0xff900000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define   VIU2_OSD1_COLOR                          (0x1e12)
#define P_VIU2_OSD1_COLOR                          (volatile uint32_t *)((0x1e12  << 2) + 0xff900000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define   VIU2_OSD1_TCOLOR_AG0                     (0x1e17)
#define P_VIU2_OSD1_TCOLOR_AG0                     (volatile uint32_t *)((0x1e17  << 2) + 0xff900000)
#define   VIU2_OSD1_TCOLOR_AG1                     (0x1e18)
#define P_VIU2_OSD1_TCOLOR_AG1                     (volatile uint32_t *)((0x1e18  << 2) + 0xff900000)
#define   VIU2_OSD1_TCOLOR_AG2                     (0x1e19)
#define P_VIU2_OSD1_TCOLOR_AG2                     (volatile uint32_t *)((0x1e19  << 2) + 0xff900000)
#define   VIU2_OSD1_TCOLOR_AG3                     (0x1e1a)
#define P_VIU2_OSD1_TCOLOR_AG3                     (volatile uint32_t *)((0x1e1a  << 2) + 0xff900000)
// Bit 31:30 Reserved
// Bit    29 RW, y_rev: 0=normal read, 1=reverse read in Y direction
// Bit    28 RW, x_rev: 0=normal read, 1=reverse read in X direction
// Bit 27:24 Reserved
// Bit 23:16 RW, tbl_addr
// Bit    15 RW, little_endian: 0=big endian, 1=little endian
// Bit    14 RW, rpt_y
// Bit 13:12 RW, interp_ctrl. 0x=No interpolation; 10=Interpolate with previous
//                            pixel; 11=Interpolate with the average value
//                            between previous and next pixel.
// Bit 11: 8 RW, osd_blk_mode
// Bit     7 RW, rgb_en
// Bit     6 RW, tc_alpha_en
// Bit  5: 2 RW, color_matrix
// Bit     1 RW, interlace_en
// Bit     0 RW, interlace_sel_odd
#define   VIU2_OSD1_BLK0_CFG_W0                    (0x1e1b)
#define P_VIU2_OSD1_BLK0_CFG_W0                    (volatile uint32_t *)((0x1e1b  << 2) + 0xff900000)
#define   VIU2_OSD1_BLK1_CFG_W0                    (0x1e1f)
#define P_VIU2_OSD1_BLK1_CFG_W0                    (volatile uint32_t *)((0x1e1f  << 2) + 0xff900000)
#define   VIU2_OSD1_BLK2_CFG_W0                    (0x1e23)
#define P_VIU2_OSD1_BLK2_CFG_W0                    (volatile uint32_t *)((0x1e23  << 2) + 0xff900000)
#define   VIU2_OSD1_BLK3_CFG_W0                    (0x1e27)
#define P_VIU2_OSD1_BLK3_CFG_W0                    (volatile uint32_t *)((0x1e27  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, x_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, x_start
#define   VIU2_OSD1_BLK0_CFG_W1                    (0x1e1c)
#define P_VIU2_OSD1_BLK0_CFG_W1                    (volatile uint32_t *)((0x1e1c  << 2) + 0xff900000)
#define   VIU2_OSD1_BLK1_CFG_W1                    (0x1e20)
#define P_VIU2_OSD1_BLK1_CFG_W1                    (volatile uint32_t *)((0x1e20  << 2) + 0xff900000)
#define   VIU2_OSD1_BLK2_CFG_W1                    (0x1e24)
#define P_VIU2_OSD1_BLK2_CFG_W1                    (volatile uint32_t *)((0x1e24  << 2) + 0xff900000)
#define   VIU2_OSD1_BLK3_CFG_W1                    (0x1e28)
#define P_VIU2_OSD1_BLK3_CFG_W1                    (volatile uint32_t *)((0x1e28  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, y_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, y_start
#define   VIU2_OSD1_BLK0_CFG_W2                    (0x1e1d)
#define P_VIU2_OSD1_BLK0_CFG_W2                    (volatile uint32_t *)((0x1e1d  << 2) + 0xff900000)
#define   VIU2_OSD1_BLK1_CFG_W2                    (0x1e21)
#define P_VIU2_OSD1_BLK1_CFG_W2                    (volatile uint32_t *)((0x1e21  << 2) + 0xff900000)
#define   VIU2_OSD1_BLK2_CFG_W2                    (0x1e25)
#define P_VIU2_OSD1_BLK2_CFG_W2                    (volatile uint32_t *)((0x1e25  << 2) + 0xff900000)
#define   VIU2_OSD1_BLK3_CFG_W2                    (0x1e29)
#define P_VIU2_OSD1_BLK3_CFG_W2                    (volatile uint32_t *)((0x1e29  << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, h_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, h_start
#define   VIU2_OSD1_BLK0_CFG_W3                    (0x1e1e)
#define P_VIU2_OSD1_BLK0_CFG_W3                    (volatile uint32_t *)((0x1e1e  << 2) + 0xff900000)
#define   VIU2_OSD1_BLK1_CFG_W3                    (0x1e22)
#define P_VIU2_OSD1_BLK1_CFG_W3                    (volatile uint32_t *)((0x1e22  << 2) + 0xff900000)
#define   VIU2_OSD1_BLK2_CFG_W3                    (0x1e26)
#define P_VIU2_OSD1_BLK2_CFG_W3                    (volatile uint32_t *)((0x1e26  << 2) + 0xff900000)
#define   VIU2_OSD1_BLK3_CFG_W3                    (0x1e2a)
#define P_VIU2_OSD1_BLK3_CFG_W3                    (volatile uint32_t *)((0x1e2a  << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, v_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, v_start
#define   VIU2_OSD1_BLK0_CFG_W4                    (0x1e13)
#define P_VIU2_OSD1_BLK0_CFG_W4                    (volatile uint32_t *)((0x1e13  << 2) + 0xff900000)
#define   VIU2_OSD1_BLK1_CFG_W4                    (0x1e14)
#define P_VIU2_OSD1_BLK1_CFG_W4                    (volatile uint32_t *)((0x1e14  << 2) + 0xff900000)
#define   VIU2_OSD1_BLK2_CFG_W4                    (0x1e15)
#define P_VIU2_OSD1_BLK2_CFG_W4                    (volatile uint32_t *)((0x1e15  << 2) + 0xff900000)
#define   VIU2_OSD1_BLK3_CFG_W4                    (0x1e16)
#define P_VIU2_OSD1_BLK3_CFG_W4                    (volatile uint32_t *)((0x1e16  << 2) + 0xff900000)
// Bit    31 RW, burst_len_sel[2] of [2:0]
// Bit    30 RW, byte_swap: In addition to endian control, further define
//               whether to swap upper and lower byte within a 16-bit mem word.
//               0=No swap; 1=Swap data[15:0] to be {data[7:0], data[15:8]}
// Bit    29 RW, div_swap : swap the 2 64bits words in 128 bit word
// Bit 28:24 RW, fifo_lim : when osd fifo is small than the fifo_lim*16, closed the rq port of osd_rd_mif
// Bit 23:22 RW, fifo_ctrl: 00 : for 1 word in 1 burst , 01 : for  2words in 1burst, 10: for 4words in 1burst, 11: reserved
// Bit 21:20 R,  fifo_st. 0=IDLE, 1=FILL, 2=ABORT
// Bit    19 R,  fifo_overflow
//
// Bit 18:12 RW, fifo_depth_val, max value=64: set actual fifo depth to fifo_depth_val*8.
// Bit 11:10 RW, burst_len_sel[1:0] of [2:0]. 0=24(default), 1=32, 2=48, 3=64, 4=96, 5=128.
// Bit  9: 5 RW, hold_fifo_lines[4:0]
// Bit     4 RW, clear_err: one pulse to clear fifo_overflow
// Bit     3 RW, fifo_sync_rst
// Bit  2: 1 RW, endian
// Bit     0 RW, urgent
#define   VIU2_OSD1_FIFO_CTRL_STAT                 (0x1e2b)
#define P_VIU2_OSD1_FIFO_CTRL_STAT                 (volatile uint32_t *)((0x1e2b  << 2) + 0xff900000)
// Bit 31:24 R, Y or R
// Bit 23:16 R, Cb or G
// Bit 15: 8 R, Cr or B
// Bit  7: 0 R, Output Alpha[8:1]
#define   VIU2_OSD1_TEST_RDDATA                    (0x1e2c)
#define P_VIU2_OSD1_TEST_RDDATA                    (volatile uint32_t *)((0x1e2c  << 2) + 0xff900000)
// Bit    15 RW, prot_en: 1=Borrow PROT's FIFO storage, either for rotate or non-rotate.
// Bit 12: 0 RW, effective FIFO size when prot_en=1.
#define   VIU2_OSD1_PROT_CTRL                      (0x1e2e)
#define P_VIU2_OSD1_PROT_CTRL                      (volatile uint32_t *)((0x1e2e  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// OSD2 registers
//------------------------------------------------------------------------------
// Bit    31 Reserved
// Bit    30 RW, enable_free_clk: 1=use free-running clock to drive logic;
//                                0=use gated clock for low power.
// Bit    29 R, test_rd_dsr
// Bit    28 R, osd_done
// Bit 27:24 R, osd_blk_mode
// Bit 23:22 R, osd_blk_ptr
// Bit    21 R, osd_enable
//
// Bit 20:12 RW, global_alpha
// Bit    11 RW, test_rd_en
// Bit    10 RW, hl2_en
// Bit     9 RW, hl1_en
// Bit  8: 5 RW, ctrl_mtch_y
// Bit     4 RW, ctrl_422to444
// Bit  3: 0 RW, osd_blk_enable. Bit 0 to enable block 0: 1=enable, 0=disable;
//                               Bit 1 to enable block 1, and so on.
#define   VIU2_OSD2_CTRL_STAT                      (0x1e30)
#define P_VIU2_OSD2_CTRL_STAT                      (volatile uint32_t *)((0x1e30  << 2) + 0xff900000)
// Bit 31:26 Reserved
// Bit 25:16 R, fifo_count
// Bit 15: 6 Reserved
// Bit  5: 4 RW, hold_fifo_lines[6:5]
// Bit     3 RW, rgb2yuv_full_range
// Bit     2 RW, alpha_9b_mode
// Bit     1 RW, reserved
// Bit     0 RW, color_expand_mode
#define   VIU2_OSD2_CTRL_STAT2                     (0x1e4d)
#define P_VIU2_OSD2_CTRL_STAT2                     (volatile uint32_t *)((0x1e4d  << 2) + 0xff900000)
// Bit 31: 9 Reserved
// Bit     8 RW, 0 = Write LUT, 1 = Read LUT
// Bit  7: 0 RW, lut_addr
#define   VIU2_OSD2_COLOR_ADDR                     (0x1e31)
#define P_VIU2_OSD2_COLOR_ADDR                     (volatile uint32_t *)((0x1e31  << 2) + 0xff900000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define   VIU2_OSD2_COLOR                          (0x1e32)
#define P_VIU2_OSD2_COLOR                          (volatile uint32_t *)((0x1e32  << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, hl[1-2]_h/v_start
// Bit 15:12 Reserved
// Bit 11: 0 RW, hl[1-2]_h/v_end
#define   VIU2_OSD2_HL1_H_START_END                (0x1e33)
#define P_VIU2_OSD2_HL1_H_START_END                (volatile uint32_t *)((0x1e33  << 2) + 0xff900000)
#define   VIU2_OSD2_HL1_V_START_END                (0x1e34)
#define P_VIU2_OSD2_HL1_V_START_END                (volatile uint32_t *)((0x1e34  << 2) + 0xff900000)
#define   VIU2_OSD2_HL2_H_START_END                (0x1e35)
#define P_VIU2_OSD2_HL2_H_START_END                (volatile uint32_t *)((0x1e35  << 2) + 0xff900000)
#define   VIU2_OSD2_HL2_V_START_END                (0x1e36)
#define P_VIU2_OSD2_HL2_V_START_END                (volatile uint32_t *)((0x1e36  << 2) + 0xff900000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define   VIU2_OSD2_TCOLOR_AG0                     (0x1e37)
#define P_VIU2_OSD2_TCOLOR_AG0                     (volatile uint32_t *)((0x1e37  << 2) + 0xff900000)
#define   VIU2_OSD2_TCOLOR_AG1                     (0x1e38)
#define P_VIU2_OSD2_TCOLOR_AG1                     (volatile uint32_t *)((0x1e38  << 2) + 0xff900000)
#define   VIU2_OSD2_TCOLOR_AG2                     (0x1e39)
#define P_VIU2_OSD2_TCOLOR_AG2                     (volatile uint32_t *)((0x1e39  << 2) + 0xff900000)
#define   VIU2_OSD2_TCOLOR_AG3                     (0x1e3a)
#define P_VIU2_OSD2_TCOLOR_AG3                     (volatile uint32_t *)((0x1e3a  << 2) + 0xff900000)
// Bit 31:24 Reserved
// Bit 23:16 RW, tbl_addr
// Bit    15 RW, little_endian: 0=big endian, 1=little endian
// Bit    14 RW, rpt_y
// Bit 13:12 RW, interp_ctrl. 0x=No interpolation; 10=Interpolate with previous
//                            pixel; 11=Interpolate with the average value
//                            between previous and next pixel.
// Bit 11: 8 RW, osd_blk_mode
// Bit     7 RW, rgb_en
// Bit     6 RW, tc_alpha_en
// Bit  5: 2 RW, color_matrix
// Bit     1 RW, interlace_en
// Bit     0 RW, interlace_sel_odd
#define   VIU2_OSD2_BLK0_CFG_W0                    (0x1e3b)
#define P_VIU2_OSD2_BLK0_CFG_W0                    (volatile uint32_t *)((0x1e3b  << 2) + 0xff900000)
#define   VIU2_OSD2_BLK1_CFG_W0                    (0x1e3f)
#define P_VIU2_OSD2_BLK1_CFG_W0                    (volatile uint32_t *)((0x1e3f  << 2) + 0xff900000)
#define   VIU2_OSD2_BLK2_CFG_W0                    (0x1e43)
#define P_VIU2_OSD2_BLK2_CFG_W0                    (volatile uint32_t *)((0x1e43  << 2) + 0xff900000)
#define   VIU2_OSD2_BLK3_CFG_W0                    (0x1e47)
#define P_VIU2_OSD2_BLK3_CFG_W0                    (volatile uint32_t *)((0x1e47  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, x_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, x_start
#define   VIU2_OSD2_BLK0_CFG_W1                    (0x1e3c)
#define P_VIU2_OSD2_BLK0_CFG_W1                    (volatile uint32_t *)((0x1e3c  << 2) + 0xff900000)
#define   VIU2_OSD2_BLK1_CFG_W1                    (0x1e40)
#define P_VIU2_OSD2_BLK1_CFG_W1                    (volatile uint32_t *)((0x1e40  << 2) + 0xff900000)
#define   VIU2_OSD2_BLK2_CFG_W1                    (0x1e44)
#define P_VIU2_OSD2_BLK2_CFG_W1                    (volatile uint32_t *)((0x1e44  << 2) + 0xff900000)
#define   VIU2_OSD2_BLK3_CFG_W1                    (0x1e48)
#define P_VIU2_OSD2_BLK3_CFG_W1                    (volatile uint32_t *)((0x1e48  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, y_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, y_start
#define   VIU2_OSD2_BLK0_CFG_W2                    (0x1e3d)
#define P_VIU2_OSD2_BLK0_CFG_W2                    (volatile uint32_t *)((0x1e3d  << 2) + 0xff900000)
#define   VIU2_OSD2_BLK1_CFG_W2                    (0x1e41)
#define P_VIU2_OSD2_BLK1_CFG_W2                    (volatile uint32_t *)((0x1e41  << 2) + 0xff900000)
#define   VIU2_OSD2_BLK2_CFG_W2                    (0x1e45)
#define P_VIU2_OSD2_BLK2_CFG_W2                    (volatile uint32_t *)((0x1e45  << 2) + 0xff900000)
#define   VIU2_OSD2_BLK3_CFG_W2                    (0x1e49)
#define P_VIU2_OSD2_BLK3_CFG_W2                    (volatile uint32_t *)((0x1e49  << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, h_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, h_start
#define   VIU2_OSD2_BLK0_CFG_W3                    (0x1e3e)
#define P_VIU2_OSD2_BLK0_CFG_W3                    (volatile uint32_t *)((0x1e3e  << 2) + 0xff900000)
#define   VIU2_OSD2_BLK1_CFG_W3                    (0x1e42)
#define P_VIU2_OSD2_BLK1_CFG_W3                    (volatile uint32_t *)((0x1e42  << 2) + 0xff900000)
#define   VIU2_OSD2_BLK2_CFG_W3                    (0x1e46)
#define P_VIU2_OSD2_BLK2_CFG_W3                    (volatile uint32_t *)((0x1e46  << 2) + 0xff900000)
#define   VIU2_OSD2_BLK3_CFG_W3                    (0x1e4a)
#define P_VIU2_OSD2_BLK3_CFG_W3                    (volatile uint32_t *)((0x1e4a  << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, v_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, v_start
#define   VIU2_OSD2_BLK0_CFG_W4                    (0x1e64)
#define P_VIU2_OSD2_BLK0_CFG_W4                    (volatile uint32_t *)((0x1e64  << 2) + 0xff900000)
#define   VIU2_OSD2_BLK1_CFG_W4                    (0x1e65)
#define P_VIU2_OSD2_BLK1_CFG_W4                    (volatile uint32_t *)((0x1e65  << 2) + 0xff900000)
#define   VIU2_OSD2_BLK2_CFG_W4                    (0x1e66)
#define P_VIU2_OSD2_BLK2_CFG_W4                    (volatile uint32_t *)((0x1e66  << 2) + 0xff900000)
#define   VIU2_OSD2_BLK3_CFG_W4                    (0x1e67)
#define P_VIU2_OSD2_BLK3_CFG_W4                    (volatile uint32_t *)((0x1e67  << 2) + 0xff900000)
// Bit    31 RW, burst_len_sel[2] of [2:0]
// Bit    30 RW, byte_swap: In addition to endian control, further define
//               whether to swap upper and lower byte within a 16-bit mem word.
//               0=No swap; 1=Swap data[15:0] to be {data[7:0], data[15:8]}
// Bit    29 RW, div_swap : swap the 2 64bits words in 128 bit word
// Bit 28:24 RW, fifo_lim : when osd fifo is small than the fifo_lim*16, closed the rq port of osd_rd_mif
// Bit 23:22 RW, fifo_ctrl: 00 : for 1 word in 1 burst , 01 : for  2words in 1burst, 10: for 4words in 1burst, 11: reserved
// Bit 21:20 R,  fifo_st. 0=IDLE, 1=FILL, 2=ABORT
// Bit    19 R,  fifo_overflow
// Bit 18:12 RW, fifo_depth_val, max value=64: set actual fifo depth to fifo_depth_val*8.
// Bit 11:10 RW, burst_len_sel[1:0] of [2:0]. 0=24(default), 1=32, 2=48, 3=64, 4=96, 5=128.
// Bit  9: 5 RW, hold_fifo_lines[4:0]
// Bit     4 RW, clear_err: one pulse to clear fifo_overflow
// Bit     3 RW, fifo_sync_rst
// Bit  2: 1 RW, endian
// Bit     0 RW, urgent
#define   VIU2_OSD2_FIFO_CTRL_STAT                 (0x1e4b)
#define P_VIU2_OSD2_FIFO_CTRL_STAT                 (volatile uint32_t *)((0x1e4b  << 2) + 0xff900000)
// Bit 31:24 R, Y or R
// Bit 23:16 R, Cb or G
// Bit 15: 8 R, Cr or B
// Bit  7: 0 R, Output Alpha[8:1]
#define   VIU2_OSD2_TEST_RDDATA                    (0x1e4c)
#define P_VIU2_OSD2_TEST_RDDATA                    (volatile uint32_t *)((0x1e4c  << 2) + 0xff900000)
// Bit    15 RW, prot_en: 1=Borrow PROT's FIFO storage, either for rotate or non-rotate.
// Bit 12: 0 RW, effective FIFO size when prot_en=1.
#define   VIU2_OSD2_PROT_CTRL                      (0x1e4e)
#define P_VIU2_OSD2_PROT_CTRL                      (volatile uint32_t *)((0x1e4e  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// VD1 path
//------------------------------------------------------------------------------
#define   VIU2_VD1_IF0_GEN_REG                     (0x1e50)
#define P_VIU2_VD1_IF0_GEN_REG                     (volatile uint32_t *)((0x1e50  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_CANVAS0                     (0x1e51)
#define P_VIU2_VD1_IF0_CANVAS0                     (volatile uint32_t *)((0x1e51  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_CANVAS1                     (0x1e52)
#define P_VIU2_VD1_IF0_CANVAS1                     (volatile uint32_t *)((0x1e52  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_LUMA_X0                     (0x1e53)
#define P_VIU2_VD1_IF0_LUMA_X0                     (volatile uint32_t *)((0x1e53  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_LUMA_Y0                     (0x1e54)
#define P_VIU2_VD1_IF0_LUMA_Y0                     (volatile uint32_t *)((0x1e54  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_CHROMA_X0                   (0x1e55)
#define P_VIU2_VD1_IF0_CHROMA_X0                   (volatile uint32_t *)((0x1e55  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_CHROMA_Y0                   (0x1e56)
#define P_VIU2_VD1_IF0_CHROMA_Y0                   (volatile uint32_t *)((0x1e56  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_LUMA_X1                     (0x1e57)
#define P_VIU2_VD1_IF0_LUMA_X1                     (volatile uint32_t *)((0x1e57  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_LUMA_Y1                     (0x1e58)
#define P_VIU2_VD1_IF0_LUMA_Y1                     (volatile uint32_t *)((0x1e58  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_CHROMA_X1                   (0x1e59)
#define P_VIU2_VD1_IF0_CHROMA_X1                   (volatile uint32_t *)((0x1e59  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_CHROMA_Y1                   (0x1e5a)
#define P_VIU2_VD1_IF0_CHROMA_Y1                   (volatile uint32_t *)((0x1e5a  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_RPT_LOOP                    (0x1e5b)
#define P_VIU2_VD1_IF0_RPT_LOOP                    (volatile uint32_t *)((0x1e5b  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_LUMA0_RPT_PAT               (0x1e5c)
#define P_VIU2_VD1_IF0_LUMA0_RPT_PAT               (volatile uint32_t *)((0x1e5c  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_CHROMA0_RPT_PAT             (0x1e5d)
#define P_VIU2_VD1_IF0_CHROMA0_RPT_PAT             (volatile uint32_t *)((0x1e5d  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_LUMA1_RPT_PAT               (0x1e5e)
#define P_VIU2_VD1_IF0_LUMA1_RPT_PAT               (volatile uint32_t *)((0x1e5e  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_CHROMA1_RPT_PAT             (0x1e5f)
#define P_VIU2_VD1_IF0_CHROMA1_RPT_PAT             (volatile uint32_t *)((0x1e5f  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_LUMA_PSEL                   (0x1e60)
#define P_VIU2_VD1_IF0_LUMA_PSEL                   (volatile uint32_t *)((0x1e60  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_CHROMA_PSEL                 (0x1e61)
#define P_VIU2_VD1_IF0_CHROMA_PSEL                 (volatile uint32_t *)((0x1e61  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_DUMMY_PIXEL                 (0x1e62)
#define P_VIU2_VD1_IF0_DUMMY_PIXEL                 (volatile uint32_t *)((0x1e62  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_LUMA_FIFO_SIZE              (0x1e63)
#define P_VIU2_VD1_IF0_LUMA_FIFO_SIZE              (volatile uint32_t *)((0x1e63  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_RANGE_MAP_Y                 (0x1e6a)
#define P_VIU2_VD1_IF0_RANGE_MAP_Y                 (volatile uint32_t *)((0x1e6a  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_RANGE_MAP_CB                (0x1e6b)
#define P_VIU2_VD1_IF0_RANGE_MAP_CB                (volatile uint32_t *)((0x1e6b  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_RANGE_MAP_CR                (0x1e6c)
#define P_VIU2_VD1_IF0_RANGE_MAP_CR                (volatile uint32_t *)((0x1e6c  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_GEN_REG2                    (0x1e6d)
#define P_VIU2_VD1_IF0_GEN_REG2                    (volatile uint32_t *)((0x1e6d  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_PROT_CNTL                   (0x1e6e)
#define P_VIU2_VD1_IF0_PROT_CNTL                   (volatile uint32_t *)((0x1e6e  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_URGENT_CTRL                 (0x1e6f)
#define P_VIU2_VD1_IF0_URGENT_CTRL                 (volatile uint32_t *)((0x1e6f  << 2) + 0xff900000)
//Bit 31    it true, disable clock, otherwise enable clock
//Bit 30    soft rst bit
//Bit 28    if true, horizontal formatter use repeating to generate pixel, otherwise use bilinear interpolation
//Bit 27:24 horizontal formatter initial phase
//Bit 23    horizontal formatter repeat pixel 0 enable
//Bit 22:21 horizontal Y/C ratio, 00: 1:1, 01: 2:1, 10: 4:1
//Bit 20    horizontal formatter enable
//Bit 19    if true, always use phase0 while vertical formater, meaning always
//          repeat data, no interpolation
//Bit 18    if true, disable vertical formatter chroma repeat last line
//Bit 17    vertical formatter dont need repeat line on phase0, 1: enable, 0: disable
//Bit 16    vertical formatter repeat line 0 enable
//Bit 15:12 vertical formatter skip line num at the beginning
//Bit 11:8  vertical formatter initial phase
//Bit 7:1   vertical formatter phase step (3.4)
//Bit 0     vertical formatter enable
#define   VIU2_VD1_FMT_CTRL                        (0x1e68)
#define P_VIU2_VD1_FMT_CTRL                        (volatile uint32_t *)((0x1e68  << 2) + 0xff900000)
//Bit 27:16  horizontal formatter width
//Bit 11:0   vertical formatter width
#define   VIU2_VD1_FMT_W                           (0x1e69)
#define P_VIU2_VD1_FMT_W                           (volatile uint32_t *)((0x1e69  << 2) + 0xff900000)
#define   VIU2_VD1_IF0_GEN_REG3                    (0x1e70)
#define P_VIU2_VD1_IF0_GEN_REG3                    (volatile uint32_t *)((0x1e70  << 2) + 0xff900000)
//bit 31:1,  reversed
//bit 0,     cntl_64bit_rev
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  v2regs.h
//
//`define VIUB_VCBUS_BASE                8'h20
//
// Reading file:  vregs_clk1.h
//
//===========================================================================
// Video Interface Registers    0xa00 - 0xaff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VIUB_VCBUS_BASE = 0x20
// -----------------------------------------------
#define   VIUB_ADDR_START                          (0x2000)
#define P_VIUB_ADDR_START                          (volatile uint32_t *)((0x2000  << 2) + 0xff900000)
#define   VIUB_ADDR_END                            (0x20ff)
#define P_VIUB_ADDR_END                            (volatile uint32_t *)((0x20ff  << 2) + 0xff900000)
//`define TRACE_REG 8'ff
//------------------------------------------------------------------------------
// VIU top-level registers
//------------------------------------------------------------------------------
// Bit  0 RW, osd1_reset
// Bit  1 RW, osd2_reset
// Bit  2 RW, vd1_reset
// Bit  3 RW, vd1_fmt_reset
// Bit  4 RW, vd2_reset
// Bit  5 RW, vd2_fmt_reset
// Bit  6 RW, di_dsr1to2_reset
// Bit  7 RW, vpp_reset
// Bit  8 RW, di_if1_reset
// Bit  9 RW, di_if1_fmt_reset
// Bit 10 RW, di_inp_reset
// Bit 11 RW, di_inp_fmt_reset
// Bit 12 RW, di_mem_reset
// Bit 13 RW, di_mem_fmt_reset
// Bit 14 RW, di_nr_wr_mif_reset
// Bit 15 RW, dein_wr_mif_reset
// Bit 16 RW, di_chan2_mif_reset
// Bit 17 RW, di_mtn_wr_mif_reset
// Bit 18 RW, di_mtn_rd_mif_reset
// Bit 19 RW, di_mad_reset
// Bit 20 RW, vdin0_reset
// Bit 21 RW, vdin1_reset
// Bit 22 RW, nrin_mux_reset
// Bit 23 RW, vdin0_wr_reset
// Bit 24 RW, vdin1_wr_reset
// Bit 25 RW, reserved
// Bit 26 RW, d2d3_reset
// Bit 27 RW, di_cont_wr_mif_reset
// Bit 28 RW, di_cont_rd_mif_reset
#define   VIUB_SW_RESET                            (0x2001)
#define P_VIUB_SW_RESET                            (volatile uint32_t *)((0x2001  << 2) + 0xff900000)
#define   VIUB_SW_RESET0                           (0x2002)
#define P_VIUB_SW_RESET0                           (volatile uint32_t *)((0x2002  << 2) + 0xff900000)
// Bit 0 RW, software reset for mcvecrd_mif
// Bit 1 RW, software reset for mcinfowr_mif
// Bit 2 RW, software reset for mcinford_mif
//bit 8 if true, vsync interrup is generate only field == 0
//bit 7:0 fix_disable
#define   VIUB_MISC_CTRL0                          (0x2006)
#define P_VIUB_MISC_CTRL0                          (volatile uint32_t *)((0x2006  << 2) + 0xff900000)
#define   VIUB_GCLK_CTRL0                          (0x2007)
#define P_VIUB_GCLK_CTRL0                          (volatile uint32_t *)((0x2007  << 2) + 0xff900000)
//// gclk_ctrl0_gl[ 0] : def=1 di_top_wrap clk enable
////
//// gclk_ctrl0_gl[ 8] : def=0 mad pre clock enable, from mad clock
//// gclk_ctrl0_gl[ 9] : def=0 mad post clock enable, from mad clock
//// gclk_ctrl0_gl[10] : def=0 div clock enable, di slow clock including di&mcdi
//// gclk_ctrl0_gl[11] : def=0 mcdi clock enable, from div clock
//// gclk_ctrl0_gl[12] : def=0 di post clock enable, from div clock
//// gclk_ctrl0_gl[13] : def=0 reserved
//// gclk_ctrl0_gl[14] : def=1 di_no_clk_gate, for old di
//// gclk_ctrl0_gl[15] : def=0 di_gate_all, for old di
#define   VIUB_GCLK_CTRL1                          (0x2008)
#define P_VIUB_GCLK_CTRL1                          (volatile uint32_t *)((0x2008  << 2) + 0xff900000)
//// gclk_ctrl1_gl[ 1: 0] : def=2'b00 mif-sub-arb clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl1_gl[ 3: 2] : def=2'b00 if1 rdmif clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl1_gl[ 5: 4] : def=2'b00 if2 rdmif clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl1_gl[ 7: 6] : def=2'b00 de wrmif clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl1_gl[ 9: 8] : def=2'b00 mtnrd post mif clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl1_gl[11:10] : def=2'b00 mcdi post mif clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl1_gl[17:16] : def=2'b00 inp rdmif clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl1_gl[19:18] : def=2'b00 mem rdmif clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl1_gl[21:20] : def=2'b00 chan rdmif clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl1_gl[23:22] : def=2'b00 nr wrmif clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl1_gl[25:24] : def=2'b00 mtn mif clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl1_gl[27:26] : def=2'b00 mcdi pre mif clock gate ctrl [1]: clock valid, [0]: clock close
////
#define   VIUB_GCLK_CTRL2                          (0x2009)
#define P_VIUB_GCLK_CTRL2                          (volatile uint32_t *)((0x2009  << 2) + 0xff900000)
//// gclk_ctrl_pre[ 1: 0] : def=2'b00 nr clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl_pre[ 3: 2] : def=2'b00 pd clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl_pre[ 5: 4] : def=2'b00 mtn det clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl_pre[ 7: 6] : def=2'b00 debanding clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl_pre[ 9: 8] : def=2'b00 dnr clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl_pre[11:10] : def=2'b00 nr&dnr blend clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl_pre[13:12] : def=2'b00 mcdi clock gate ctrl [1]: clock valid, [0]: clock close
#define   VIUB_GCLK_CTRL3                          (0x200a)
#define P_VIUB_GCLK_CTRL3                          (volatile uint32_t *)((0x200a  << 2) + 0xff900000)
//// gclk_ctrl_post[ 1: 0] : def=2'b00 di blend clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl_post[ 3: 2] : def=2'b00 ei clock gate ctrl [1]: clock valid, [0]: clock close
//// gclk_ctrl_post[ 5: 4] : def=2'b00 ei_0 clock gate ctrl [1]: clock valid, [0]: clock close
#define   DI_IF2_GEN_REG                           (0x2010)
#define P_DI_IF2_GEN_REG                           (volatile uint32_t *)((0x2010  << 2) + 0xff900000)
#define   DI_IF2_CANVAS0                           (0x2011)
#define P_DI_IF2_CANVAS0                           (volatile uint32_t *)((0x2011  << 2) + 0xff900000)
#define   DI_IF2_LUMA_X0                           (0x2012)
#define P_DI_IF2_LUMA_X0                           (volatile uint32_t *)((0x2012  << 2) + 0xff900000)
#define   DI_IF2_LUMA_Y0                           (0x2013)
#define P_DI_IF2_LUMA_Y0                           (volatile uint32_t *)((0x2013  << 2) + 0xff900000)
#define   DI_IF2_CHROMA_X0                         (0x2014)
#define P_DI_IF2_CHROMA_X0                         (volatile uint32_t *)((0x2014  << 2) + 0xff900000)
#define   DI_IF2_CHROMA_Y0                         (0x2015)
#define P_DI_IF2_CHROMA_Y0                         (volatile uint32_t *)((0x2015  << 2) + 0xff900000)
#define   DI_IF2_RPT_LOOP                          (0x2016)
#define P_DI_IF2_RPT_LOOP                          (volatile uint32_t *)((0x2016  << 2) + 0xff900000)
#define   DI_IF2_LUMA0_RPT_PAT                     (0x2017)
#define P_DI_IF2_LUMA0_RPT_PAT                     (volatile uint32_t *)((0x2017  << 2) + 0xff900000)
#define   DI_IF2_CHROMA0_RPT_PAT                   (0x2018)
#define P_DI_IF2_CHROMA0_RPT_PAT                   (volatile uint32_t *)((0x2018  << 2) + 0xff900000)
#define   DI_IF2_DUMMY_PIXEL                       (0x2019)
#define P_DI_IF2_DUMMY_PIXEL                       (volatile uint32_t *)((0x2019  << 2) + 0xff900000)
#define   DI_IF2_LUMA_FIFO_SIZE                    (0x201a)
#define P_DI_IF2_LUMA_FIFO_SIZE                    (volatile uint32_t *)((0x201a  << 2) + 0xff900000)
#define   DI_IF2_RANGE_MAP_Y                       (0x201b)
#define P_DI_IF2_RANGE_MAP_Y                       (volatile uint32_t *)((0x201b  << 2) + 0xff900000)
#define   DI_IF2_RANGE_MAP_CB                      (0x201c)
#define P_DI_IF2_RANGE_MAP_CB                      (volatile uint32_t *)((0x201c  << 2) + 0xff900000)
#define   DI_IF2_RANGE_MAP_CR                      (0x201d)
#define P_DI_IF2_RANGE_MAP_CR                      (volatile uint32_t *)((0x201d  << 2) + 0xff900000)
#define   DI_IF2_GEN_REG2                          (0x201e)
#define P_DI_IF2_GEN_REG2                          (volatile uint32_t *)((0x201e  << 2) + 0xff900000)
#define   DI_IF2_FMT_CTRL                          (0x201f)
#define P_DI_IF2_FMT_CTRL                          (volatile uint32_t *)((0x201f  << 2) + 0xff900000)
#define   DI_IF2_FMT_W                             (0x2020)
#define P_DI_IF2_FMT_W                             (volatile uint32_t *)((0x2020  << 2) + 0xff900000)
#define   DI_IF2_URGENT_CTRL                       (0x2021)
#define P_DI_IF2_URGENT_CTRL                       (volatile uint32_t *)((0x2021  << 2) + 0xff900000)
//bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di inp chroma path
//bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di inp luma path
#define   DI_IF2_GEN_REG3                          (0x2022)
#define P_DI_IF2_GEN_REG3                          (volatile uint32_t *)((0x2022  << 2) + 0xff900000)
//bit 31:1,  reversed
//bit 0,     cntl_64bit_rev
#define   DI_IF1_URGENT_CTRL                       (0x20a3)
#define P_DI_IF1_URGENT_CTRL                       (volatile uint32_t *)((0x20a3  << 2) + 0xff900000)
//bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di inp chroma path
//bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di inp luma path
#define   DI_INP_URGENT_CTRL                       (0x20a4)
#define P_DI_INP_URGENT_CTRL                       (volatile uint32_t *)((0x20a4  << 2) + 0xff900000)
//bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di mem chroma path
//bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di mem luma path
#define   DI_MEM_URGENT_CTRL                       (0x20a5)
#define P_DI_MEM_URGENT_CTRL                       (volatile uint32_t *)((0x20a5  << 2) + 0xff900000)
//bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di chan2 chroma path
//bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di chan2 luma path
#define   DI_CHAN2_URGENT_CTRL                     (0x20a6)
#define P_DI_CHAN2_URGENT_CTRL                     (volatile uint32_t *)((0x20a6  << 2) + 0xff900000)
#define   DI_IF1_GEN_REG3                          (0x20a7)
#define P_DI_IF1_GEN_REG3                          (volatile uint32_t *)((0x20a7  << 2) + 0xff900000)
//bit 31:1,  reversed
//bit 0,     cntl_64bit_rev
#define   DI_INP_GEN_REG3                          (0x20a8)
#define P_DI_INP_GEN_REG3                          (volatile uint32_t *)((0x20a8  << 2) + 0xff900000)
//bit 31:1,  reversed
//bit 0,     cntl_64bit_rev
#define   DI_MEM_GEN_REG3                          (0x20a9)
#define P_DI_MEM_GEN_REG3                          (volatile uint32_t *)((0x20a9  << 2) + 0xff900000)
//bit 31:1,  reversed
//bit 0,     cntl_64bit_rev
#define   DI_CHAN2_GEN_REG3                        (0x20aa)
#define P_DI_CHAN2_GEN_REG3                        (volatile uint32_t *)((0x20aa  << 2) + 0xff900000)
//bit 31:1,  reversed
//bit 0,     cntl_64bit_rev
//
// Closing file:  vregs_clk1.h
//
//======================================================================
//   vpu  register.
//======================================================================
// -----------------------------------------------
// CBUS_BASE:  VPU_VCBUS_BASE = 0x27
// -----------------------------------------------
#define   VPU_OSD1_MMC_CTRL                        (0x2701)
#define P_VPU_OSD1_MMC_CTRL                        (volatile uint32_t *)((0x2701  << 2) + 0xff900000)
#define   VPU_OSD2_MMC_CTRL                        (0x2702)
#define P_VPU_OSD2_MMC_CTRL                        (volatile uint32_t *)((0x2702  << 2) + 0xff900000)
#define   VPU_VD1_MMC_CTRL                         (0x2703)
#define P_VPU_VD1_MMC_CTRL                         (volatile uint32_t *)((0x2703  << 2) + 0xff900000)
#define   VPU_VD2_MMC_CTRL                         (0x2704)
#define P_VPU_VD2_MMC_CTRL                         (volatile uint32_t *)((0x2704  << 2) + 0xff900000)
#define   VPU_DI_IF1_MMC_CTRL                      (0x2705)
#define P_VPU_DI_IF1_MMC_CTRL                      (volatile uint32_t *)((0x2705  << 2) + 0xff900000)
#define   VPU_DI_MEM_MMC_CTRL                      (0x2706)
#define P_VPU_DI_MEM_MMC_CTRL                      (volatile uint32_t *)((0x2706  << 2) + 0xff900000)
#define   VPU_DI_INP_MMC_CTRL                      (0x2707)
#define P_VPU_DI_INP_MMC_CTRL                      (volatile uint32_t *)((0x2707  << 2) + 0xff900000)
#define   VPU_DI_MTNRD_MMC_CTRL                    (0x2708)
#define P_VPU_DI_MTNRD_MMC_CTRL                    (volatile uint32_t *)((0x2708  << 2) + 0xff900000)
#define   VPU_DI_CHAN2_MMC_CTRL                    (0x2709)
#define P_VPU_DI_CHAN2_MMC_CTRL                    (volatile uint32_t *)((0x2709  << 2) + 0xff900000)
#define   VPU_DI_MTNWR_MMC_CTRL                    (0x270a)
#define P_VPU_DI_MTNWR_MMC_CTRL                    (volatile uint32_t *)((0x270a  << 2) + 0xff900000)
#define   VPU_DI_NRWR_MMC_CTRL                     (0x270b)
#define P_VPU_DI_NRWR_MMC_CTRL                     (volatile uint32_t *)((0x270b  << 2) + 0xff900000)
#define   VPU_DI_DIWR_MMC_CTRL                     (0x270c)
#define P_VPU_DI_DIWR_MMC_CTRL                     (volatile uint32_t *)((0x270c  << 2) + 0xff900000)
#define   VPU_VDIN0_MMC_CTRL                       (0x270d)
#define P_VPU_VDIN0_MMC_CTRL                       (volatile uint32_t *)((0x270d  << 2) + 0xff900000)
#define   VPU_VDIN1_MMC_CTRL                       (0x270e)
#define P_VPU_VDIN1_MMC_CTRL                       (volatile uint32_t *)((0x270e  << 2) + 0xff900000)
#define   VPU_BT656_MMC_CTRL                       (0x270f)
#define P_VPU_BT656_MMC_CTRL                       (volatile uint32_t *)((0x270f  << 2) + 0xff900000)
#define   VPU_TVD3D_MMC_CTRL                       (0x2710)
#define P_VPU_TVD3D_MMC_CTRL                       (volatile uint32_t *)((0x2710  << 2) + 0xff900000)
#define   VPU_TVDVBI_MMC_CTRL                      (0x2711)
#define P_VPU_TVDVBI_MMC_CTRL                      (volatile uint32_t *)((0x2711  << 2) + 0xff900000)
//Read only
//`define     VPU_TVDVBI_VSLATCH_ADDR   8'h12
//Read only
//`define     VPU_TVDVBI_WRRSP_ADDR 8'h13
#define   VPU_VDIN_PRE_ARB_CTRL                    (0x2714)
#define P_VPU_VDIN_PRE_ARB_CTRL                    (volatile uint32_t *)((0x2714  << 2) + 0xff900000)
#define   VPU_VDISP_PRE_ARB_CTRL                   (0x2715)
#define P_VPU_VDISP_PRE_ARB_CTRL                   (volatile uint32_t *)((0x2715  << 2) + 0xff900000)
#define   VPU_VPUARB2_PRE_ARB_CTRL                 (0x2716)
#define P_VPU_VPUARB2_PRE_ARB_CTRL                 (volatile uint32_t *)((0x2716  << 2) + 0xff900000)
#define   VPU_OSD3_MMC_CTRL                        (0x2717)
#define P_VPU_OSD3_MMC_CTRL                        (volatile uint32_t *)((0x2717  << 2) + 0xff900000)
#define   VPU_OSD4_MMC_CTRL                        (0x2718)
#define P_VPU_OSD4_MMC_CTRL                        (volatile uint32_t *)((0x2718  << 2) + 0xff900000)
#define   VPU_VD3_MMC_CTRL                         (0x2719)
#define P_VPU_VD3_MMC_CTRL                         (volatile uint32_t *)((0x2719  << 2) + 0xff900000)
// [31:11] Reserved.
// [10: 8] cntl_viu_vdin_sel_data. Select VIU to VDIN data path, must clear it first before changing the path selection:
//          3'b000=Disable VIU to VDIN path;
//          3'b001=Enable VIU of ENC_I domain to VDIN;
//          3'b010=Enable VIU of ENC_P domain to VDIN;
//          3'b100=Enable VIU of ENC_T domain to VDIN;
// [ 6: 4] cntl_viu_vdin_sel_clk. Select which clock to VDIN path, must clear it first before changing the clock:
//          3'b000=Disable VIU to VDIN clock;
//          3'b001=Select encI clock to VDIN;
//          3'b010=Select encP clock to VDIN;
//          3'b100=Select encT clock to VDIN;
// [ 3: 2] cntl_viu2_sel_venc. Select which one of the encI/P/T that VIU2 connects to:
//         0=No connection, 1=ENCI, 2=ENCP, 3=ENCT.
// [ 1: 0] cntl_viu1_sel_venc. Select which one of the encI/P/T that VIU1 connects to:
//         0=No connection, 1=ENCI, 2=ENCP, 3=ENCT.
#define   VPU_VIU_VENC_MUX_CTRL                    (0x271a)
#define P_VPU_VIU_VENC_MUX_CTRL                    (volatile uint32_t *)((0x271a  << 2) + 0xff900000)
// [15:12] rd_rate. 0=A read every clk2; 1=A read every 2 clk2; ...; 15=A read every 16 clk2.
// [11: 8] wr_rate. 0=A write every clk1; 1=A write every 2 clk1; ...; 15=A write every 16 clk1.
// [ 7: 5] data_comp_map. Input data is CrYCb(BRG), map the output data to desired format:
//                          0=output CrYCb(BRG);
//                          1=output YCbCr(RGB);
//                          2=output YCrCb(RBG);
//                          3=output CbCrY(GBR);
//                          4=output CbYCr(GRB);
//                          5=output CrCbY(BGR);
//                          6,7=Rsrv.
// [    4] inv_dvi_clk. 1=Invert clock to external DVI, (clock invertion exists at internal HDMI).
// [    3] inv_vsync. 1=Invert Vsync polarity.
// [    2] inv_hsync. 1=Invert Hsync polarity.
// [ 1: 0] src_sel. 0=Disable output to HDMI; 1=Select VENC_I output to HDMI; 2=Select VENC_P output.
#define   VPU_HDMI_SETTING                         (0x271b)
#define P_VPU_HDMI_SETTING                         (volatile uint32_t *)((0x271b  << 2) + 0xff900000)
#define   ENCI_INFO_READ                           (0x271c)
#define P_ENCI_INFO_READ                           (volatile uint32_t *)((0x271c  << 2) + 0xff900000)
#define   ENCP_INFO_READ                           (0x271d)
#define P_ENCP_INFO_READ                           (volatile uint32_t *)((0x271d  << 2) + 0xff900000)
#define   ENCT_INFO_READ                           (0x271e)
#define P_ENCT_INFO_READ                           (volatile uint32_t *)((0x271e  << 2) + 0xff900000)
#define   ENCL_INFO_READ                           (0x271f)
#define P_ENCL_INFO_READ                           (volatile uint32_t *)((0x271f  << 2) + 0xff900000)
// Bit  0 RW, viu_rst_n
// Bit  1 RW, vdin_mmc_arb_rst_n
// Bit  2 RW, vdisp_mmc_arb_rst_n
// Bit  3 RW, vpuarb2_mmc_arb_rst_n
#define   VPU_SW_RESET                             (0x2720)
#define P_VPU_SW_RESET                             (volatile uint32_t *)((0x2720  << 2) + 0xff900000)
//Bit 30     d2d3_depr_req_sel,  0:vdisp_pre_arb, 1: vpuarb2_pre_arb
//Bit 27:22  d2d3_depr_brst_num
//Bit 21:16  d2d3_depr_id
//Bit 14     d2d3_depw_req_sel, 0: vdin_pre_arb, 1: vdisp_pre_arb
//Bit 11:6   d2d3_depw_brst_num
//Bit 5:0    d2d3_depw_id
#define   VPU_D2D3_MMC_CTRL                        (0x2721)
#define P_VPU_D2D3_MMC_CTRL                        (volatile uint32_t *)((0x2721  << 2) + 0xff900000)
//Bit 30     mtn_contrd_req_pre,  0:disp1_arb, 1: vdin_pre_arb
//Bit 27:22  mtn_contrd_brst_num
//Bit 21:16  mtn_contrd_id
//Bit 14     mtn_contwr_req_pre, 0: vdisp1_arb, 1: vdin_pre_arb
//Bit 11:6   mtn_contwr_brst_num
//Bit 5:0    mtn_contwr_id
#define   VPU_CONT_MMC_CTRL                        (0x2722)
#define P_VPU_CONT_MMC_CTRL                        (volatile uint32_t *)((0x2722  << 2) + 0xff900000)
// Bit  6 RW, gclk_mpeg_vpu_misc
// Bit  5 RW, gclk_mpeg_venc_l_top
// Bit  4 RW, gclk_mpeg_vencl_int
// Bit  3 RW, gclk_mpeg_vencp_int
// Bit  2 RW, gclk_mpeg_vi2_top
// Bit  1 RW, gclk_mpeg_vi_top
// Bit  0 RW, gclk_mpeg_venc_p_top
#define   VPU_CLK_GATE                             (0x2723)
#define P_VPU_CLK_GATE                             (volatile uint32_t *)((0x2723  << 2) + 0xff900000)
//Bit    12 RW, rdma_pre
//Bit 11: 6 RW, rdma_num
//Bit  5: 0 RW, rdma_id
#define   VPU_RDMA_MMC_CTRL                        (0x2724)
#define P_VPU_RDMA_MMC_CTRL                        (volatile uint32_t *)((0x2724  << 2) + 0xff900000)
#define   VPU_MEM_PD_REG0                          (0x2725)
#define P_VPU_MEM_PD_REG0                          (volatile uint32_t *)((0x2725  << 2) + 0xff900000)
#define   VPU_MEM_PD_REG1                          (0x2726)
#define P_VPU_MEM_PD_REG1                          (volatile uint32_t *)((0x2726  << 2) + 0xff900000)
// [   31] hdmi_data_ovr_en: 1=Enable overriding data input to HDMI TX with hdmi_data_ovr[29:0]. 0=No override. Default 0.
// [   30] Reserved.                                                                                            Default 0
// [29: 0] hdmi_data_ovr.                                                                                       Default 0.
#define   VPU_HDMI_DATA_OVR                        (0x2727)
#define P_VPU_HDMI_DATA_OVR                        (volatile uint32_t *)((0x2727  << 2) + 0xff900000)
//Bit    15 RW, prot1_sel_osd4
//Bit    14 RW, prot1_sel_osd3
//Bit    13 RW, prot1_sel_osd2
//Bit    12 RW, prot1_sel_osd1
//Bit 11: 6 RW, prot1_brst_num
//Bit  5: 0 RW, prot1_id
#define   VPU_PROT1_MMC_CTRL                       (0x2728)
#define P_VPU_PROT1_MMC_CTRL                       (volatile uint32_t *)((0x2728  << 2) + 0xff900000)
//Bit    14 RW, prot2_sel_vd3
//Bit    13 RW, prot2_sel_vd2
//Bit    12 RW, prot2_sel_vd1
//Bit 11: 6 RW, prot2_brst_num
//Bit  5: 0 RW, prot2_id
#define   VPU_PROT2_MMC_CTRL                       (0x2729)
#define P_VPU_PROT2_MMC_CTRL                       (volatile uint32_t *)((0x2729  << 2) + 0xff900000)
//Bit    14 RW, prot3_sel_vd3
//Bit    13 RW, prot3_sel_vd2
//Bit    12 RW, prot3_sel_vd1
//Bit 11: 6 RW, prot3_brst_num
//Bit  5: 0 RW, prot3_id
#define   VPU_PROT3_MMC_CTRL                       (0x272a)
#define P_VPU_PROT3_MMC_CTRL                       (volatile uint32_t *)((0x272a  << 2) + 0xff900000)
//Bit 29:24 RW, s3_brst_num
//Bit 21:16 RW, s2_brst_num
//Bit 13: 8 RW, s1_brst_num
//Bit  5: 0 RW, s0_brst_num
#define   VPU_ARB4_V1_MMC_CTRL                     (0x272b)
#define P_VPU_ARB4_V1_MMC_CTRL                     (volatile uint32_t *)((0x272b  << 2) + 0xff900000)
//Bit 29:24 RW, s3_brst_num
//Bit 21:16 RW, s2_brst_num
//Bit 13: 8 RW, s1_brst_num
//Bit  5: 0 RW, s0_brst_num
#define   VPU_ARB4_V2_MMC_CTRL                     (0x272c)
#define P_VPU_ARB4_V2_MMC_CTRL                     (volatile uint32_t *)((0x272c  << 2) + 0xff900000)
//Bit 27:22 RW, mcvecwr_num
//Bit 21:16 RW, mcvecwr_id
//Bit 11:6  RW, mcvecrd_num
//Bit 5:0   RW, mcvecrd_id
#define   VPU_MCVEC_MMC_CTRL                       (0x272d)
#define P_VPU_MCVEC_MMC_CTRL                       (volatile uint32_t *)((0x272d  << 2) + 0xff900000)
//Bit 27:22 RW, mcinfwr_num
//Bit 21:16 RW, mcinfwr_id
//Bit 11:6  RW, mcinfrd_num
//Bit 5:0   RW, mcinfrd_id
#define   VPU_MCINF_MMC_CTRL                       (0x272e)
#define P_VPU_MCINF_MMC_CTRL                       (volatile uint32_t *)((0x272e  << 2) + 0xff900000)
//Bit 31    reg_vpu_pwm_inv, 1: invert the pwm signal, active low
//Bit 30:29 reg_vpu_pwm_src_sel, 00: encl, enct, encp
//Bit 28:16 reg_vpu_pwm_v_end0
//Bit 12:0  reg_vpu_pwm_v_start0
#define   VPU_VPU_PWM_V0                           (0x2730)
#define P_VPU_VPU_PWM_V0                           (volatile uint32_t *)((0x2730  << 2) + 0xff900000)
//Bit 28:16 reg_vpu_pwm_v_end1
//Bit 12:0  reg_vpu_pwm_v_start1
#define   VPU_VPU_PWM_V1                           (0x2731)
#define P_VPU_VPU_PWM_V1                           (volatile uint32_t *)((0x2731  << 2) + 0xff900000)
//Bit 28:16 reg_vpu_pwm_v_end2
//Bit 12:0  reg_vpu_pwm_v_start2
#define   VPU_VPU_PWM_V2                           (0x2732)
#define P_VPU_VPU_PWM_V2                           (volatile uint32_t *)((0x2732  << 2) + 0xff900000)
//Bit 28:16 reg_vpu_pwm_v_end3
//Bit 12:0  reg_vpu_pwm_v_start3
#define   VPU_VPU_PWM_V3                           (0x2733)
#define P_VPU_VPU_PWM_V3                           (volatile uint32_t *)((0x2733  << 2) + 0xff900000)
//Bit 28:16 reg_vpu_pwm_h_end0
//Bit 12:0  reg_vpu_pwm_h_start0
#define   VPU_VPU_PWM_H0                           (0x2734)
#define P_VPU_VPU_PWM_H0                           (volatile uint32_t *)((0x2734  << 2) + 0xff900000)
//Bit 28:16 reg_vpu_pwm_h_end1
//Bit 12:0  reg_vpu_pwm_h_start1
#define   VPU_VPU_PWM_H1                           (0x2735)
#define P_VPU_VPU_PWM_H1                           (volatile uint32_t *)((0x2735  << 2) + 0xff900000)
//Bit 28:16 reg_vpu_pwm_h_end2
//Bit 12:0  reg_vpu_pwm_h_start2
#define   VPU_VPU_PWM_H2                           (0x2736)
#define P_VPU_VPU_PWM_H2                           (volatile uint32_t *)((0x2736  << 2) + 0xff900000)
//Bit 28:16 reg_vpu_pwm_h_end3
//Bit 12:0  reg_vpu_pwm_h_start3
#define   VPU_VPU_PWM_H3                           (0x2737)
#define P_VPU_VPU_PWM_H3                           (volatile uint32_t *)((0x2737  << 2) + 0xff900000)
//Bit 18   reg_vpu_3d_go_high_fld_pol: 0: go high at field 0, 1: go high at field 1
//Bit 17   reg_vpu_3d_sync_setting_vsync_latch
//Bit 16   reg_vpu_3d_sync_enable
//Bit 14:8 reg_vpu_3d_sync_v_end
//Bit 6:0  reg_vpu_3d_sync_v_start
#define   VPU_VPU_3D_SYNC1                         (0x2738)
#define P_VPU_VPU_3D_SYNC1                         (volatile uint32_t *)((0x2738  << 2) + 0xff900000)
//Bit 28:16 reg_vpu_3d_sync_h_end
//Bit 12:0  reg_vpu_3d_sync_h_start
#define   VPU_VPU_3D_SYNC2                         (0x2739)
#define P_VPU_VPU_3D_SYNC2                         (volatile uint32_t *)((0x2739  << 2) + 0xff900000)
//Bit 0,   if true, force vencl clk enable, otherwise, it might auto turn off by mipi DSI
#define   VPU_MISC_CTRL                            (0x2740)
#define P_VPU_MISC_CTRL                            (volatile uint32_t *)((0x2740  << 2) + 0xff900000)
#define   VPU_ISP_GCLK_CTRL0                       (0x2741)
#define P_VPU_ISP_GCLK_CTRL0                       (volatile uint32_t *)((0x2741  << 2) + 0xff900000)
#define   VPU_ISP_GCLK_CTRL1                       (0x2742)
#define P_VPU_ISP_GCLK_CTRL1                       (volatile uint32_t *)((0x2742  << 2) + 0xff900000)
#define   VPU_HDMI_FMT_CTRL                        (0x2743)
#define P_VPU_HDMI_FMT_CTRL                        (volatile uint32_t *)((0x2743  << 2) + 0xff900000)
#define   VPU_VDIN_ASYNC_HOLD_CTRL                 (0x2744)
#define P_VPU_VDIN_ASYNC_HOLD_CTRL                 (volatile uint32_t *)((0x2744  << 2) + 0xff900000)
#define   VPU_VDISP_ASYNC_HOLD_CTRL                (0x2745)
#define P_VPU_VDISP_ASYNC_HOLD_CTRL                (volatile uint32_t *)((0x2745  << 2) + 0xff900000)
#define   VPU_VPUARB2_ASYNC_HOLD_CTRL              (0x2746)
#define P_VPU_VPUARB2_ASYNC_HOLD_CTRL              (volatile uint32_t *)((0x2746  << 2) + 0xff900000)
//    arb0_rd_urg_ctrl_o <=  vpp_off_urg_ctrl &  vpu_arb_urg_ctrl[0] |
//                        rdma_ddr_req_busy_sync_d1 & vpu_arb_urg_ctrl[1]
//                        ;
//
//    arb1_rd_urg_ctrl_o <=  vpp_off_urg_ctrl &  vpu_arb_urg_ctrl[2] |
//                        rdma_ddr_req_busy_sync_d1 & vpu_arb_urg_ctrl[3]
//                        ;
//
//    arb2_rd_urg_ctrl_o <=  vpp_off_urg_ctrl &  vpu_arb_urg_ctrl[4] |
//                        rdma_ddr_req_busy_sync_d1 & vpu_arb_urg_ctrl[5]
//                        ;
//
//    arb0_wr_urg_ctrl_o <=  vdin0_lff_urg_ctrl_sync_d1 & vpu_arb_urg_ctrl[6] |
//                        vdin1_lff_urg_ctrl_sync_d1 & vpu_arb_urg_ctrl[7]
//                        ;
//
//    arb1_wr_urg_ctrl_o <=  vdin0_lff_urg_ctrl_sync_d1 & vpu_arb_urg_ctrl[8] |
//                        vdin1_lff_urg_ctrl_sync_d1 & vpu_arb_urg_ctrl[9]
//
#define   VPU_ARB_URG_CTRL                         (0x2747)
#define P_VPU_ARB_URG_CTRL                         (volatile uint32_t *)((0x2747  << 2) + 0xff900000)
#define   VPU_SECURE_DUMMY                         (0x2748)
#define P_VPU_SECURE_DUMMY                         (volatile uint32_t *)((0x2748  << 2) + 0xff900000)
#define   VPU_VENCL_DITH_EN                        (0x2749)
#define P_VPU_VENCL_DITH_EN                        (volatile uint32_t *)((0x2749  << 2) + 0xff900000)
// todo :
#define   VPU_422TO444_RST                         (0x274a)
#define P_VPU_422TO444_RST                         (volatile uint32_t *)((0x274a  << 2) + 0xff900000)
// todo :
#define   VPU_422TO444_CTRL0                       (0x274b)
#define P_VPU_422TO444_CTRL0                       (volatile uint32_t *)((0x274b  << 2) + 0xff900000)
// todo :
#define   VPU_422TO444_CTRL1                       (0x274c)
#define P_VPU_422TO444_CTRL1                       (volatile uint32_t *)((0x274c  << 2) + 0xff900000)
// todo :
// Picture Rotate (PROT) module 1 (for OSD) registers:
#define   VPU_PROT1_CLK_GATE                       (0x2750)
#define P_VPU_PROT1_CLK_GATE                       (volatile uint32_t *)((0x2750  << 2) + 0xff900000)
#define   VPU_PROT1_GEN_CNTL                       (0x2751)
#define P_VPU_PROT1_GEN_CNTL                       (volatile uint32_t *)((0x2751  << 2) + 0xff900000)
#define   VPU_PROT1_X_START_END                    (0x2752)
#define P_VPU_PROT1_X_START_END                    (volatile uint32_t *)((0x2752  << 2) + 0xff900000)
#define   VPU_PROT1_Y_START_END                    (0x2753)
#define P_VPU_PROT1_Y_START_END                    (volatile uint32_t *)((0x2753  << 2) + 0xff900000)
#define   VPU_PROT1_Y_LEN_STEP                     (0x2754)
#define P_VPU_PROT1_Y_LEN_STEP                     (volatile uint32_t *)((0x2754  << 2) + 0xff900000)
#define   VPU_PROT1_RPT_LOOP                       (0x2755)
#define P_VPU_PROT1_RPT_LOOP                       (volatile uint32_t *)((0x2755  << 2) + 0xff900000)
#define   VPU_PROT1_RPT_PAT                        (0x2756)
#define P_VPU_PROT1_RPT_PAT                        (volatile uint32_t *)((0x2756  << 2) + 0xff900000)
#define   VPU_PROT1_DDR                            (0x2757)
#define P_VPU_PROT1_DDR                            (volatile uint32_t *)((0x2757  << 2) + 0xff900000)
#define   VPU_PROT1_RBUF_ROOM                      (0x2758)
#define P_VPU_PROT1_RBUF_ROOM                      (volatile uint32_t *)((0x2758  << 2) + 0xff900000)
#define   VPU_PROT1_STAT_0                         (0x2759)
#define P_VPU_PROT1_STAT_0                         (volatile uint32_t *)((0x2759  << 2) + 0xff900000)
#define   VPU_PROT1_STAT_1                         (0x275a)
#define P_VPU_PROT1_STAT_1                         (volatile uint32_t *)((0x275a  << 2) + 0xff900000)
#define   VPU_PROT1_STAT_2                         (0x275b)
#define P_VPU_PROT1_STAT_2                         (volatile uint32_t *)((0x275b  << 2) + 0xff900000)
#define   VPU_PROT1_REQ_ONOFF                      (0x275c)
#define P_VPU_PROT1_REQ_ONOFF                      (volatile uint32_t *)((0x275c  << 2) + 0xff900000)
// Picture Rotate (PROT) module 2 (for VD) registers:
#define   VPU_PROT2_CLK_GATE                       (0x2760)
#define P_VPU_PROT2_CLK_GATE                       (volatile uint32_t *)((0x2760  << 2) + 0xff900000)
#define   VPU_PROT2_GEN_CNTL                       (0x2761)
#define P_VPU_PROT2_GEN_CNTL                       (volatile uint32_t *)((0x2761  << 2) + 0xff900000)
#define   VPU_PROT2_X_START_END                    (0x2762)
#define P_VPU_PROT2_X_START_END                    (volatile uint32_t *)((0x2762  << 2) + 0xff900000)
#define   VPU_PROT2_Y_START_END                    (0x2763)
#define P_VPU_PROT2_Y_START_END                    (volatile uint32_t *)((0x2763  << 2) + 0xff900000)
#define   VPU_PROT2_Y_LEN_STEP                     (0x2764)
#define P_VPU_PROT2_Y_LEN_STEP                     (volatile uint32_t *)((0x2764  << 2) + 0xff900000)
#define   VPU_PROT2_RPT_LOOP                       (0x2765)
#define P_VPU_PROT2_RPT_LOOP                       (volatile uint32_t *)((0x2765  << 2) + 0xff900000)
#define   VPU_PROT2_RPT_PAT                        (0x2766)
#define P_VPU_PROT2_RPT_PAT                        (volatile uint32_t *)((0x2766  << 2) + 0xff900000)
#define   VPU_PROT2_DDR                            (0x2767)
#define P_VPU_PROT2_DDR                            (volatile uint32_t *)((0x2767  << 2) + 0xff900000)
#define   VPU_PROT2_RBUF_ROOM                      (0x2768)
#define P_VPU_PROT2_RBUF_ROOM                      (volatile uint32_t *)((0x2768  << 2) + 0xff900000)
#define   VPU_PROT2_STAT_0                         (0x2769)
#define P_VPU_PROT2_STAT_0                         (volatile uint32_t *)((0x2769  << 2) + 0xff900000)
#define   VPU_PROT2_STAT_1                         (0x276a)
#define P_VPU_PROT2_STAT_1                         (volatile uint32_t *)((0x276a  << 2) + 0xff900000)
#define   VPU_PROT2_STAT_2                         (0x276b)
#define P_VPU_PROT2_STAT_2                         (volatile uint32_t *)((0x276b  << 2) + 0xff900000)
#define   VPU_PROT2_REQ_ONOFF                      (0x276c)
#define P_VPU_PROT2_REQ_ONOFF                      (volatile uint32_t *)((0x276c  << 2) + 0xff900000)
// Picture Rotate (PROT) module 3 (for VD) registers:
#define   VPU_PROT3_CLK_GATE                       (0x2770)
#define P_VPU_PROT3_CLK_GATE                       (volatile uint32_t *)((0x2770  << 2) + 0xff900000)
#define   VPU_PROT3_GEN_CNTL                       (0x2771)
#define P_VPU_PROT3_GEN_CNTL                       (volatile uint32_t *)((0x2771  << 2) + 0xff900000)
#define   VPU_PROT3_X_START_END                    (0x2772)
#define P_VPU_PROT3_X_START_END                    (volatile uint32_t *)((0x2772  << 2) + 0xff900000)
#define   VPU_PROT3_Y_START_END                    (0x2773)
#define P_VPU_PROT3_Y_START_END                    (volatile uint32_t *)((0x2773  << 2) + 0xff900000)
#define   VPU_PROT3_Y_LEN_STEP                     (0x2774)
#define P_VPU_PROT3_Y_LEN_STEP                     (volatile uint32_t *)((0x2774  << 2) + 0xff900000)
#define   VPU_PROT3_RPT_LOOP                       (0x2775)
#define P_VPU_PROT3_RPT_LOOP                       (volatile uint32_t *)((0x2775  << 2) + 0xff900000)
#define   VPU_PROT3_RPT_PAT                        (0x2776)
#define P_VPU_PROT3_RPT_PAT                        (volatile uint32_t *)((0x2776  << 2) + 0xff900000)
#define   VPU_PROT3_DDR                            (0x2777)
#define P_VPU_PROT3_DDR                            (volatile uint32_t *)((0x2777  << 2) + 0xff900000)
#define   VPU_PROT3_RBUF_ROOM                      (0x2778)
#define P_VPU_PROT3_RBUF_ROOM                      (volatile uint32_t *)((0x2778  << 2) + 0xff900000)
#define   VPU_PROT3_STAT_0                         (0x2779)
#define P_VPU_PROT3_STAT_0                         (volatile uint32_t *)((0x2779  << 2) + 0xff900000)
#define   VPU_PROT3_STAT_1                         (0x277a)
#define P_VPU_PROT3_STAT_1                         (volatile uint32_t *)((0x277a  << 2) + 0xff900000)
#define   VPU_PROT3_STAT_2                         (0x277b)
#define P_VPU_PROT3_STAT_2                         (volatile uint32_t *)((0x277b  << 2) + 0xff900000)
#define   VPU_PROT3_REQ_ONOFF                      (0x277c)
#define P_VPU_PROT3_REQ_ONOFF                      (volatile uint32_t *)((0x277c  << 2) + 0xff900000)
//Bit 20    reg_viu2vdin_sw_reset:   software reset
//Bit 19:18 reg_viu2vdin_dn_ratio:   down-scale ratio; 0: no scale; 1: 1/2;  2:1/4; 3: reserved
//Bit 17:16 reg_viu2vdin_flt_mode:   filter mode; 0: no filter; 1:[0 2 2 0]/4; 2:[1 1 1 1]/4; 3:[1 3 3 1]/8
//Bit 15:14 reversed
//Bit 13:0  reg_viu2vdin_hsize:      source horizontal size
#define   VPU_VIU2VDIN_HDN_CTRL                    (0x2780)
#define P_VPU_VIU2VDIN_HDN_CTRL                    (volatile uint32_t *)((0x2780  << 2) + 0xff900000)
#define   VPU_VIU_ASYNC_MASK                       (0x2781)
#define P_VPU_VIU_ASYNC_MASK                       (volatile uint32_t *)((0x2781  << 2) + 0xff900000)
#define   VDIN_MISC_CTRL                           (0x2782)
#define P_VDIN_MISC_CTRL                           (volatile uint32_t *)((0x2782  << 2) + 0xff900000)
// vpu arbitration :
// the segment is 8'h90-8'hc8
//
// Reading file:  vpu_arb_axi_regs.h
//
// synopsys translate_off
// synopsys translate_on
////===============================////
//// reg
////===============================////
#define   VPU_RDARB_MODE_L1C1                      (0x2790)
#define P_VPU_RDARB_MODE_L1C1                      (volatile uint32_t *)((0x2790  << 2) + 0xff900000)
//Bit   31:22,    reserved
//Bit   21:16,    rdarb_sel           uns, default = 0 ,
//                                    rdarb_sel[0]==0 slave dc0 connect master port0 rdarb_sel[0]==1 slave dc0 connect master port1
//                                    rdarb_sel[1]==0 slave dc1 connect master port0 rdarb_sel[1]==1 slave dc1 connect master port1
//                                    rdarb_sel[2]==0 slave dc2 connect master port0 rdarb_sel[2]==1 slave dc2 connect master port1
//                                    rdarb_sel[3]==0 slave dc3 connect master port0 rdarb_sel[3]==1 slave dc3 connect master port1
//                                    rdarb_sel[4]==0 slave dc4 connect master port0 rdarb_sel[4]==1 slave dc4 connect master port1
//                                    rdarb_sel[5]==0 slave dc5 connect master port0 rdarb_sel[5]==1 slave dc5 connect master port1
//Bit   15:10,    reserved
//Bit   9:8,      rdarb_arb_mode      uns, default = 0 ,
//                                    rdarb_arb_mode[0] master port0 arb way,
//                                    rdarb_arb_mode[1] master port1 arb way,
//Bit   7:4,      reserved
//Bit   3:0,      rdarb_gate_clk_ctrl uns, default = 0 ,
//                                    rdarb_gate_clk_ctrl[1:0] master port0 clk gate control
//                                    rdarb_gate_clk_ctrl[3:2] master port1 clk gate control
#define   VPU_RDARB_REQEN_SLV_L1C1                 (0x2791)
#define P_VPU_RDARB_REQEN_SLV_L1C1                 (volatile uint32_t *)((0x2791  << 2) + 0xff900000)
//Bit   31:12,     reserved
//Bit   11:0,     rdarb_dc_req_en     unsigned  , default = 12'hfff
//                                    rdarb_dc_req_en[0]: the slv0 req to mst port0 enable,
//                                    rdarb_dc_req_en[1]: the slv1 req to mst port0 enable,
//                                    rdarb_dc_req_en[2]: the slv2 req to mst port0 enable,
//                                    rdarb_dc_req_en[3]: the slv3 req to mst port0 enable,
//                                    rdarb_dc_req_en[4]: the slv4 req to mst port0 enable,
//                                    rdarb_dc_req_en[5]: the slv5 req to mst port0 enable,
//                                    rdarb_dc_req_en[6]: the slv0 req to mst port1 enable,
//                                    rdarb_dc_req_en[7]: the slv1 req to mst port1 enable,
//                                    rdarb_dc_req_en[8]: the slv2 req to mst port1 enable,
//                                    rdarb_dc_req_en[9]: the slv3 req to mst port1 enable,
//                                    rdarb_dc_req_en[10]: the slv4 req to mst port1 enable,
//                                    rdarb_dc_req_en[11]: the slv5 req to mst port1 enable,
#define   VPU_RDARB_WEIGH0_SLV_L1C1                (0x2792)
#define P_VPU_RDARB_WEIGH0_SLV_L1C1                (volatile uint32_t *)((0x2792  << 2) + 0xff900000)
//Bit   31:30,    reserved
//Bit   29:0,     rddc_weigh_sxn     unsigned  , default = 0
//                                    rddc_weigh_sxn[0*6+:6]: the slv0 req weigh number
//                                    rddc_weigh_sxn[1*6+:6]: the slv1 req weigh number
//                                    rddc_weigh_sxn[2*6+:6]: the slv2 req weigh number
//                                    rddc_weigh_sxn[3*6+:6]: the slv3 req weigh number
//                                    rddc_weigh_sxn[4*6+:6]: the slv4 req weigh number
#define   VPU_RDARB_WEIGH1_SLV_L1C1                (0x2793)
#define P_VPU_RDARB_WEIGH1_SLV_L1C1                (volatile uint32_t *)((0x2793  << 2) + 0xff900000)
//Bit   31:6,    reserved
//Bit   5:0,     rddc_weigh_sxn     unsigned  , default = 0
//                                    rddc_weigh_sxn[5*6+:6]: the slv5 req weigh number
#define   VPU_WRARB_MODE_L1C1                      (0x2794)
#define P_VPU_WRARB_MODE_L1C1                      (volatile uint32_t *)((0x2794  << 2) + 0xff900000)
//Bit   31:22,    reserved
//Bit   21:16,    wrarb_sel           uns, default = 0 ,
//                                    wrarb_sel[0]==0 slave dc0 connect master port0 wrarb_sel[0]==1 slave dc0 connect master port1
//                                    wrarb_sel[1]==0 slave dc1 connect master port0 wrarb_sel[1]==1 slave dc1 connect master port1
//                                    wrarb_sel[2]==0 slave dc2 connect master port0 wrarb_sel[2]==1 slave dc2 connect master port1
//                                    wrarb_sel[3]==0 slave dc3 connect master port0 wrarb_sel[3]==1 slave dc3 connect master port1
//                                    wrarb_sel[4]==0 slave dc4 connect master port0 wrarb_sel[4]==1 slave dc4 connect master port1
//                                    wrarb_sel[5]==0 slave dc5 connect master port0 wrarb_sel[5]==1 slave dc5 connect master port1
//Bit   15:10,    reserved
//Bit   9:8,      wrarb_arb_mode      uns, default = 0 ,
//                                    wrarb_arb_mode[0] master port0 arb way,
//                                    wrarb_arb_mode[1] master port1 arb way,
//Bit   7:4,      reserved
//Bit   3:0,      wrarb_gate_clk_ctrl uns, default = 0 ,
//                                    wrarb_gate_clk_ctrl[1:0] master port0 clk gate control
//                                    wrarb_gate_clk_ctrl[3:2] master port1 clk gate control
#define   VPU_WRARB_REQEN_SLV_L1C1                 (0x2795)
#define P_VPU_WRARB_REQEN_SLV_L1C1                 (volatile uint32_t *)((0x2795  << 2) + 0xff900000)
//Bit   31:12,     reserved
//Bit   11:0,     wrarb_dc_req_en     unsigned  , default = 0
//                                    wrarb_dc_req_en[0]: the slv0 req to mst port0 enable,
//                                    wrarb_dc_req_en[1]: the slv1 req to mst port0 enable,
//                                    wrarb_dc_req_en[2]: the slv2 req to mst port0 enable,
//                                    wrarb_dc_req_en[3]: the slv3 req to mst port0 enable,
//                                    wrarb_dc_req_en[4]: the slv4 req to mst port0 enable,
//                                    wrarb_dc_req_en[5]: the slv5 req to mst port0 enable,
//                                    wrarb_dc_req_en[0]: the slv0 req to mst port1 enable,
//                                    wrarb_dc_req_en[1]: the slv1 req to mst port1 enable,
//                                    wrarb_dc_req_en[2]: the slv2 req to mst port1 enable,
//                                    wrarb_dc_req_en[3]: the slv3 req to mst port1 enable,
//                                    wrarb_dc_req_en[4]: the slv4 req to mst port1 enable,
//                                    wrarb_dc_req_en[5]: the slv5 req to mst port1 enable,
#define   VPU_WRARB_WEIGH0_SLV_L1C1                (0x2796)
#define P_VPU_WRARB_WEIGH0_SLV_L1C1                (volatile uint32_t *)((0x2796  << 2) + 0xff900000)
//Bit   31:30,    reserved
//Bit   29:0,     wrdc_weigh_sxn     unsigned  , default = 0
//                                    wrdc_weigh_sxn[0*6+:6]: the slv0 req weigh number
//                                    wrdc_weigh_sxn[1*6+:6]: the slv1 req weigh number
//                                    wrdc_weigh_sxn[2*6+:6]: the slv2 req weigh number
//                                    wrdc_weigh_sxn[3*6+:6]: the slv3 req weigh number
//                                    wrdc_weigh_sxn[4*6+:6]: the slv4 req weigh number
#define   VPU_WRARB_WEIGH1_SLV_L1C1                (0x2797)
#define P_VPU_WRARB_WEIGH1_SLV_L1C1                (volatile uint32_t *)((0x2797  << 2) + 0xff900000)
//Bit   31:6,    reserved
//Bit   5:0,     wrdc_weigh_sxn     unsigned  , default = 0
//                                    wrdc_weigh_sxn[5*6+:6]: the slv5 req weigh number
#define   VPU_RDWR_ARB_STATUS_L1C1                 (0x2798)
#define P_VPU_RDWR_ARB_STATUS_L1C1                 (volatile uint32_t *)((0x2798  << 2) + 0xff900000)
//Bit   31:4,    reserved
//Bit    3:2,    wrarb_arb_busy     unsigned  , default = 0
//Bit    1:0,    rdarb_arb_busy     unsigned  , default = 0
#define   VPU_RDARB_MODE_L1C2                      (0x2799)
#define P_VPU_RDARB_MODE_L1C2                      (volatile uint32_t *)((0x2799  << 2) + 0xff900000)
//Bit   31:21,    reserved
//Bit   20:16,    rdarb_sel           uns, default = 0 ,
//                                    rdarb_sel[0]==0 slave dc0 connect master port0 rdarb_sel[0]==1 slave dc0 connect master port1
//                                    rdarb_sel[1]==0 slave dc1 connect master port0 rdarb_sel[1]==1 slave dc1 connect master port1
//                                    rdarb_sel[2]==0 slave dc2 connect master port0 rdarb_sel[2]==1 slave dc2 connect master port1
//                                    rdarb_sel[3]==0 slave dc3 connect master port0 rdarb_sel[3]==1 slave dc3 connect master port1
//                                    rdarb_sel[4]==0 slave dc4 connect master port0 rdarb_sel[4]==1 slave dc4 connect master port1
//Bit   15:10,    reserved
//Bit   9:8,      rdarb_arb_mode      uns, default = 0 ,
//                                    rdarb_arb_mode[0] master port0 arb way,
//                                    rdarb_arb_mode[1] master port1 arb way,
//Bit   7:4,      reserved
//Bit   3:0,      rdarb_gate_clk_ctrl uns, default = 0 ,
//                                    rdarb_gate_clk_ctrl[1:0] master port0 clk gate control
//                                    rdarb_gate_clk_ctrl[3:2] master port0 clk gate control
#define   VPU_RDARB_REQEN_SLV_L1C2                 (0x279a)
#define P_VPU_RDARB_REQEN_SLV_L1C2                 (volatile uint32_t *)((0x279a  << 2) + 0xff900000)
//Bit   31:10,     reserved
//Bit    9:0,     rdarb_dc_req_en     unsigned  , default = 0
//                                    rdarb_dc_req_en[0]: the slv0 req to mst port0 enable,
//                                    rdarb_dc_req_en[1]: the slv1 req to mst port0 enable,
//                                    rdarb_dc_req_en[2]: the slv2 req to mst port0 enable,
//                                    rdarb_dc_req_en[3]: the slv3 req to mst port0 enable,
//                                    rdarb_dc_req_en[4]: the slv4 req to mst port0 enable,
//                                    rdarb_dc_req_en[5]: the slv0 req to mst port1 enable,
//                                    rdarb_dc_req_en[6]: the slv1 req to mst port1 enable,
//                                    rdarb_dc_req_en[7]: the slv2 req to mst port1 enable,
//                                    rdarb_dc_req_en[8]: the slv3 req to mst port1 enable,
//                                    rdarb_dc_req_en[9]: the slv4 req to mst port1 enable,
#define   VPU_RDARB_WEIGH0_SLV_L1C2                (0x279b)
#define P_VPU_RDARB_WEIGH0_SLV_L1C2                (volatile uint32_t *)((0x279b  << 2) + 0xff900000)
//Bit   31:30,    reserved
//Bit   29:0,     rddc_weigh_sxn     unsigned  , default = 0
//                                    rddc_weigh_sxn[0*6+:6]: the slv0 req weigh number
//                                    rddc_weigh_sxn[1*6+:6]: the slv1 req weigh number
//                                    rddc_weigh_sxn[2*6+:6]: the slv2 req weigh number
//                                    rddc_weigh_sxn[3*6+:6]: the slv3 req weigh number
//                                    rddc_weigh_sxn[4*6+:6]: the slv4 req weigh number
#define   VPU_RDWR_ARB_STATUS_L1C2                 (0x279c)
#define P_VPU_RDWR_ARB_STATUS_L1C2                 (volatile uint32_t *)((0x279c  << 2) + 0xff900000)
//Bit   31:3,    reserved
//Bit      2,    wrarb_arb_busy     unsigned  , default = 0
//Bit    1:0,    rdarb_arb_busy     unsigned  , default = 0
#define   VPU_RDARB_MODE_L2C1                      (0x279d)
#define P_VPU_RDARB_MODE_L2C1                      (volatile uint32_t *)((0x279d  << 2) + 0xff900000)
//Bit   31:28,    reserved
//Bit   27:16,    rdarb_sel           uns, default = 0 ,
//                                    rdarb_sel[0]==0 slave dc0 connect master port0 rdarb_sel[0]==1 slave dc0 connect master port1
//                                    rdarb_sel[1]==0 slave dc1 connect master port0 rdarb_sel[1]==1 slave dc1 connect master port1
//                                    rdarb_sel[2]==0 slave dc2 connect master port0 rdarb_sel[2]==1 slave dc2 connect master port1
//                                    rdarb_sel[3]==0 slave dc3 connect master port0 rdarb_sel[3]==1 slave dc3 connect master port1
//                                    rdarb_sel[4]==0 slave dc4 connect master port0 rdarb_sel[4]==1 slave dc4 connect master port1
//                                    rdarb_sel[5]==0 slave dc5 connect master port0 rdarb_sel[5]==1 slave dc5 connect master port1
//Bit   15:11,    reserved
//Bit   10:8,      rdarb_arb_mode      uns, default = 0 ,
//                                    rdarb_arb_mode[0] master port0 arb way,
//                                    rdarb_arb_mode[1] master port1 arb way,
//Bit   7:6,      reserved
//Bit   5:0,      rdarb_gate_clk_ctrl uns, default = 0 ,
//                                    rdarb_gate_clk_ctrl[1:0] master port0 clk gate control
//                                    rdarb_gate_clk_ctrl[3:2] master port1 clk gate control
//                                    rdarb_gate_clk_ctrl[5:4] master port2 clk gate control
#define   VPU_RDARB_REQEN_SLV_L2C1                 (0x279e)
#define P_VPU_RDARB_REQEN_SLV_L2C1                 (volatile uint32_t *)((0x279e  << 2) + 0xff900000)
//Bit   31:18,     reserved
//Bit   17:0,     rdarb_dc_req_en     unsigned  , default = 0
//                                    rdarb_dc_req_en[0]: the slv0 req to mst port0 enable,
//                                    rdarb_dc_req_en[1]: the slv1 req to mst port0 enable,
//                                    rdarb_dc_req_en[2]: the slv2 req to mst port0 enable,
//                                    rdarb_dc_req_en[3]: the slv3 req to mst port0 enable,
//                                    rdarb_dc_req_en[4]: the slv4 req to mst port0 enable,
//                                    rdarb_dc_req_en[5]: the slv5 req to mst port0 enable,
//                                    rdarb_dc_req_en[0]: the slv0 req to mst port1 enable,
//                                    rdarb_dc_req_en[1]: the slv1 req to mst port1 enable,
//                                    rdarb_dc_req_en[2]: the slv2 req to mst port1 enable,
//                                    rdarb_dc_req_en[3]: the slv3 req to mst port1 enable,
//                                    rdarb_dc_req_en[4]: the slv4 req to mst port1 enable,
//                                    rdarb_dc_req_en[5]: the slv5 req to mst port1 enable,
#define   VPU_RDARB_WEIGH0_SLV_L2C1                (0x279f)
#define P_VPU_RDARB_WEIGH0_SLV_L2C1                (volatile uint32_t *)((0x279f  << 2) + 0xff900000)
//Bit   31:30,    reserved
//Bit   29:0,     rddc_weigh_sxn     unsigned  , default = 0
//                                    rddc_weigh_sxn[0*6+:6]: the slv0 req weigh number
//                                    rddc_weigh_sxn[1*6+:6]: the slv1 req weigh number
//                                    rddc_weigh_sxn[2*6+:6]: the slv2 req weigh number
//                                    rddc_weigh_sxn[3*6+:6]: the slv3 req weigh number
//                                    rddc_weigh_sxn[4*6+:6]: the slv4 req weigh number
#define   VPU_RDARB_WEIGH1_SLV_L2C1                (0x27a0)
#define P_VPU_RDARB_WEIGH1_SLV_L2C1                (volatile uint32_t *)((0x27a0  << 2) + 0xff900000)
//Bit   31:6,    reserved
//Bit   5:0,     rddc_weigh_sxn     unsigned  , default = 0
//                                    rddc_weigh_sxn[5*6+:6]: the slv5 req weigh number
#define   VPU_RDWR_ARB_STATUS_L2C1                 (0x27a1)
#define P_VPU_RDWR_ARB_STATUS_L2C1                 (volatile uint32_t *)((0x27a1  << 2) + 0xff900000)
//Bit   31:4,    reserved
//Bit    3:2,    wrarb_arb_busy     unsigned  , default = 0
//Bit    1:0,    rdarb_arb_busy     unsigned  , default = 0
#define   VPU_WRARB_MODE_L2C1                      (0x27a2)
#define P_VPU_WRARB_MODE_L2C1                      (volatile uint32_t *)((0x27a2  << 2) + 0xff900000)
//Bit   31:20,    reserved
//Bit   19:16,    wrarb_sel           uns, default = 0 ,
//                                    wrarb_sel[0]==0 slave dc0 connect master port0 wrarb_sel[0]==1 slave dc0 connect master port1
//                                    wrarb_sel[1]==0 slave dc1 connect master port0 wrarb_sel[1]==1 slave dc1 connect master port1
//                                    wrarb_sel[2]==0 slave dc2 connect master port0 wrarb_sel[2]==1 slave dc2 connect master port1
//                                    wrarb_sel[3]==0 slave dc3 connect master port0 wrarb_sel[3]==1 slave dc3 connect master port1
//Bit   15:10,    reserved
//Bit   9:8,      wrarb_arb_mode      uns, default = 0 ,
//                                    wrarb_arb_mode[0] master port0 arb way,
//                                    wrarb_arb_mode[1] master port1 arb way,
//Bit   7:4,      reserved
//Bit   3:0,      wrarb_gate_clk_ctrl uns, default = 0 ,
//                                    wrarb_gate_clk_ctrl[1:0] master port0 clk gate control
//                                    wrarb_gate_clk_ctrl[3:2] master port0 clk gate control
#define   VPU_WRARB_REQEN_SLV_L2C1                 (0x27a3)
#define P_VPU_WRARB_REQEN_SLV_L2C1                 (volatile uint32_t *)((0x27a3  << 2) + 0xff900000)
//Bit   31:8,     reserved
//Bit    7:0,     wrarb_dc_req_en     unsigned  , default = 0
//                                    wrarb_dc_req_en[0]: the slv0 req to mst port0 enable,
//                                    wrarb_dc_req_en[1]: the slv1 req to mst port0 enable,
//                                    wrarb_dc_req_en[2]: the slv2 req to mst port0 enable,
//                                    wrarb_dc_req_en[3]: the slv3 req to mst port0 enable,
//                                    wrarb_dc_req_en[0]: the slv0 req to mst port1 enable,
//                                    wrarb_dc_req_en[1]: the slv1 req to mst port1 enable,
//                                    wrarb_dc_req_en[2]: the slv2 req to mst port1 enable,
//                                    wrarb_dc_req_en[3]: the slv3 req to mst port1 enable,
#define   VPU_WRARB_WEIGH0_SLV_L2C1                (0x27a4)
#define P_VPU_WRARB_WEIGH0_SLV_L2C1                (volatile uint32_t *)((0x27a4  << 2) + 0xff900000)
//Bit   31:24,    reserved
//Bit   23:0,     wrdc_weigh_sxn     unsigned  , default = 0
//                                    wrdc_weigh_sxn[0*6+:6]: the slv0 req weigh number
//                                    wrdc_weigh_sxn[1*6+:6]: the slv1 req weigh number
//                                    wrdc_weigh_sxn[2*6+:6]: the slv2 req weigh number
//                                    wrdc_weigh_sxn[3*6+:6]: the slv3 req weigh number
#define   VPU_ASYNC_RD_MODE0                       (0x27a5)
#define P_VPU_ASYNC_RD_MODE0                       (volatile uint32_t *)((0x27a5  << 2) + 0xff900000)
//Bit   31:19,    reserved
//Bit   18,       req_en            unsigned  , default = 0  async enable
//Bit   17:16,    clk_gate_ctrl     unsigned  , default = 0  async clock gate control
//Bit   15:12,    auto_arugt_weight unsigned  , default = 4
//Bit   11,       reserved
//Bit   10:9,     arugt_sel         unsigned  , default = 0
//                                  00 : use auto fifo arugt generate the output arugt.
//                                  01 : use the register bit control
//                                  00 : use the input argument
//Bit   8,        argument_cfg       unsigned  , default = 0  register argument control bit
//Bit   7:4,      rd_hold_num       unsigned  , default = 4  hold the read command threshold
//Bit   3:0,      rd_rel_num        unsigned  , default = 0  release the read command threshold
#define   VPU_ASYNC_RD_MODE1                       (0x27a6)
#define P_VPU_ASYNC_RD_MODE1                       (volatile uint32_t *)((0x27a6  << 2) + 0xff900000)
//Bit   31:19,    reserved
//Bit   18,       req_en            unsigned  , default = 0  async enable
//Bit   17:16,    clk_gate_ctrl     unsigned  , default = 0  async clock gate control
//Bit   15:12,    auto_arugt_weight unsigned  , default = 4
//Bit   11,       reserved
//Bit   10:9,     arugt_sel         unsigned  , default = 0
//                                  00 : use auto fifo arugt generate the output arugt.
//                                  01 : use the register bit control
//                                  00 : use the input argument
//Bit   8,        argument_cfg       unsigned  , default = 0  register argument control bit
//Bit   7:4,      rd_hold_num       unsigned  , default = 4  hold the read command threshold
//Bit   3:0,      rd_rel_num        unsigned  , default = 0  release the read command threshold
#define   VPU_ASYNC_RD_MODE2                       (0x27a7)
#define P_VPU_ASYNC_RD_MODE2                       (volatile uint32_t *)((0x27a7  << 2) + 0xff900000)
//Bit   31:19,    reserved
//Bit   18,       req_en            unsigned  , default = 0  async enable
//Bit   17:16,    clk_gate_ctrl     unsigned  , default = 0  async clock gate control
//Bit   15:12,    auto_arugt_weight unsigned  , default = 4
//Bit   11,       reserved
//Bit   10:9,     arugt_sel         unsigned  , default = 0
//                                  00 : use auto fifo arugt generate the output arugt.
//                                  01 : use the register bit control
//                                  00 : use the input argument
//Bit   8,        argument_cfg       unsigned  , default = 0  register argument control bit
//Bit   7:4,      rd_hold_num       unsigned  , default = 4  hold the read command threshold
//Bit   3:0,      rd_rel_num        unsigned  , default = 0  release the read command threshold
#define   VPU_ASYNC_RD_MODE3                       (0x27a8)
#define P_VPU_ASYNC_RD_MODE3                       (volatile uint32_t *)((0x27a8  << 2) + 0xff900000)
//Bit   31:19,    reserved
//Bit   18,       req_en            unsigned  , default = 0  async enable
//Bit   17:16,    clk_gate_ctrl     unsigned  , default = 0  async clock gate control
//Bit   15:12,    auto_arugt_weight unsigned  , default = 4
//Bit   11,       reserved
//Bit   10:9,     arugt_sel         unsigned  , default = 0
//                                  00 : use auto fifo arugt generate the output arugt.
//                                  01 : use the register bit control
//                                  00 : use the input argument
//Bit   8,        argument_cfg       unsigned  , default = 0  register argument control bit
//Bit   7:4,      rd_hold_num       unsigned  , default = 4  hold the read command threshold
//Bit   3:0,      rd_rel_num        unsigned  , default = 0  release the read command threshold
#define   VPU_ASYNC_RD_MODE4                       (0x27a9)
#define P_VPU_ASYNC_RD_MODE4                       (volatile uint32_t *)((0x27a9  << 2) + 0xff900000)
//Bit   31:19,    reserved
//Bit   18,       req_en            unsigned  , default = 0  async enable
//Bit   17:16,    clk_gate_ctrl     unsigned  , default = 0  async clock gate control
//Bit   15:12,    auto_arugt_weight unsigned  , default = 4
//Bit   11,       reserved
//Bit   10:9,     arugt_sel         unsigned  , default = 0
//                                  00 : use auto fifo arugt generate the output arugt.
//                                  01 : use the register bit control
//                                  00 : use the input argument
//Bit   8,        argument_cfg       unsigned  , default = 0  register argument control bit
//Bit   7:4,      rd_hold_num       unsigned  , default = 4  hold the read command threshold
//Bit   3:0,      rd_rel_num        unsigned  , default = 0  release the read command threshold
#define   VPU_ASYNC_WR_MODE0                       (0x27aa)
#define P_VPU_ASYNC_WR_MODE0                       (volatile uint32_t *)((0x27aa  << 2) + 0xff900000)
//Bit   31:19,    reserved
//Bit   18,       req_en            unsigned  , default = 0  async enable
//Bit   17:16,    clk_gate_ctrl     unsigned  , default = 0  async clock gate control
//Bit   15:12,    auto_arugt_weight unsigned  , default = 4
//Bit   11,       reserved
//Bit   10:9,     arugt_sel         unsigned  , default = 0
//                                  00 : use auto fifo arugt generate the output arugt.
//                                  01 : use the register bit control
//                                  00 : use the input argument
//Bit   8,        argument_cfg       unsigned  , default = 0  register argument control bit
//Bit   7:4,      wr_hold_num       unsigned  , default = 4  hold the read command threshold
//Bit   3:0,      wr_rel_num        unsigned  , default = 0  release the write command threshold
#define   VPU_ASYNC_WR_MODE1                       (0x27ab)
#define P_VPU_ASYNC_WR_MODE1                       (volatile uint32_t *)((0x27ab  << 2) + 0xff900000)
//Bit   31:19,    reserved
//Bit   18,       req_en            unsigned  , default = 0  async enable
//Bit   17:16,    clk_gate_ctrl     unsigned  , default = 0  async clock gate control
//Bit   15:12,    auto_arugt_weight unsigned  , default = 4
//Bit   11,       reserved
//Bit   10:9,     arugt_sel         unsigned  , default = 0
//                                  00 : use auto fifo arugt generate the output arugt.
//                                  01 : use the register bit control
//                                  00 : use the input argument
//Bit   8,        argument_cfg       unsigned  , default = 0  register argument control bit
//Bit   7:4,      wr_hold_num       unsigned  , default = 4  hold the read command threshold
//Bit   3:0,      wr_rel_num        unsigned  , default = 0  release the write command threshold
#define   VPU_ASYNC_WR_MODE2                       (0x27ac)
#define P_VPU_ASYNC_WR_MODE2                       (volatile uint32_t *)((0x27ac  << 2) + 0xff900000)
//Bit   31:19,    reserved
//Bit   18,       req_en            unsigned  , default = 0  async enable
//Bit   17:16,    clk_gate_ctrl     unsigned  , default = 0  async clock gate control
//Bit   15:12,    auto_arugt_weight unsigned  , default = 4
//Bit   11,       reserved
//Bit   10:9,     arugt_sel         unsigned  , default = 0
//                                  00 : use auto fifo arugt generate the output arugt.
//                                  01 : use the register bit control
//                                  00 : use the input argument
//Bit   8,        argument_cfg       unsigned  , default = 0  register argument control bit
//Bit   7:4,      wr_hold_num       unsigned  , default = 4  hold the read command threshold
//Bit   3:0,      wr_rel_num        unsigned  , default = 0  release the write command threshold
#define   VPU_ASYNC_STAT                           (0x27ad)
#define P_VPU_ASYNC_STAT                           (volatile uint32_t *)((0x27ad  << 2) + 0xff900000)
//Bit   31:19,    reserved
//Bit   18,       axiwr2_chan_idle  unsigned  , RO, axi write channel2 idle state
//Bit   17,       axiwr1_chan_idle  unsigned  , RO, axi write channel1 idle state
//Bit   16,       axiwr0_chan_idle  unsigned  , RO, axi write channel0 idle state
//Bit   15:5,     reserved
//Bit   4,        axird4_chan_idle  unsigned  , RO, axi read channel4 idle state
//Bit   3,        axird3_chan_idle  unsigned  , RO, axi read channel3 idle state
//Bit   2,        axird2_chan_idle  unsigned  , RO, axi read channel2 idle state
//Bit   1,        axird1_chan_idle  unsigned  , RO, axi read channel1 idle state
//Bit   0,        axird0_chan_idle  unsigned  , RO, axi read channel0 idle state
#define   VPU_WRARB_MODE_L1C2                      (0x27ae)
#define P_VPU_WRARB_MODE_L1C2                      (volatile uint32_t *)((0x27ae  << 2) + 0xff900000)
//Bit   31:18,    reserved
//Bit   17:16,    wrarb_sel           uns, default = 0 ,
//                                    wrarb_sel[0]==0 slave dc0 connect master port0 wrarb_sel[0]==1 slave dc0 connect master port1
//                                    wrarb_sel[1]==0 slave dc1 connect master port0 wrarb_sel[1]==1 slave dc1 connect master port1
//Bit   15:9,     reserved
//Bit   8,        wrarb_arb_mode      uns, default = 0 ,
//                                    wrarb_arb_mode[0] master port0 arb way,
//Bit   7:2,      reserved
//Bit   1:0,      wrarb_gate_clk_ctrl uns, default = 0 ,
//                                    wrarb_gate_clk_ctrl[1:0] master port0 clk gate control
#define   VPU_WRARB_REQEN_SLV_L1C2                 (0x27af)
#define P_VPU_WRARB_REQEN_SLV_L1C2                 (volatile uint32_t *)((0x27af  << 2) + 0xff900000)
//Bit   31:2,     reserved
//Bit    1:0,     wrarb_dc_req_en     unsigned  , default = 0
//                                    wrarb_dc_req_en[0]: the slv0 req to mst port0 enable,
//                                    wrarb_dc_req_en[1]: the slv1 req to mst port0 enable,
#define   VPU_WRARB_WEIGH0_SLV_L1C2                (0x27b0)
#define P_VPU_WRARB_WEIGH0_SLV_L1C2                (volatile uint32_t *)((0x27b0  << 2) + 0xff900000)
//Bit   31:30,    reserved
//Bit   29:0,     wrdc_weigh_sxn     unsigned  , default = 0
//                                    wrdc_weigh_sxn[0*6+:6]: the slv0 req weigh number
//                                    wrdc_weigh_sxn[1*6+:6]: the slv1 req weigh number
//                                    wrdc_weigh_sxn[2*6+:6]: the slv1 req weigh number
//                                    wrdc_weigh_sxn[3*6+:6]: the slv1 req weigh number
//                                    wrdc_weigh_sxn[4*6+:6]: the slv1 req weigh number
#define   VPU_WRARB_WEIGH1_SLV_L1C2                (0x27b1)
#define P_VPU_WRARB_WEIGH1_SLV_L1C2                (volatile uint32_t *)((0x27b1  << 2) + 0xff900000)
//Bit   31:18,    reserved
//Bit   17:0,     wrdc_weigh_sxn     unsigned  , default = 0
//                                    wrdc_weigh_sxn[5*6+:6]: the slv0 req weigh number
//                                    wrdc_weigh_sxn[6*6+:6]: the slv1 req weigh number
//                                    wrdc_weigh_sxn[7*6+:6]: the slv1 req weigh number
#define   VPU_RDARB_WEIGH1_SLV_L1C2                (0x27b2)
#define P_VPU_RDARB_WEIGH1_SLV_L1C2                (volatile uint32_t *)((0x27b2  << 2) + 0xff900000)
//Bit   31:18,    reserved
//Bit   17:0,     rddc_weigh_sxn     unsigned  , default = 0
//                                    rddc_weigh_sxn[5*6+:6]: the slv0 req weigh number
//                                    rddc_weigh_sxn[6*6+:6]: the slv1 req weigh number
//                                    rddc_weigh_sxn[7*6+:6]: the slv2 req weigh number
#define   VPU_ARB_DBG_CTRL_L1C1                    (0x27b3)
#define P_VPU_ARB_DBG_CTRL_L1C1                    (volatile uint32_t *)((0x27b3  << 2) + 0xff900000)
#define   VPU_ARB_DBG_STAT_L1C1                    (0x27b4)
#define P_VPU_ARB_DBG_STAT_L1C1                    (volatile uint32_t *)((0x27b4  << 2) + 0xff900000)
#define   VPU_ARB_DBG_CTRL_L1C2                    (0x27b5)
#define P_VPU_ARB_DBG_CTRL_L1C2                    (volatile uint32_t *)((0x27b5  << 2) + 0xff900000)
#define   VPU_ARB_DBG_STAT_L1C2                    (0x27b6)
#define P_VPU_ARB_DBG_STAT_L1C2                    (volatile uint32_t *)((0x27b6  << 2) + 0xff900000)
#define   VPU_ARB_DBG_CTRL_L2C1                    (0x27b7)
#define P_VPU_ARB_DBG_CTRL_L2C1                    (volatile uint32_t *)((0x27b7  << 2) + 0xff900000)
#define   VPU_ARB_DBG_STAT_L2C1                    (0x27b8)
#define P_VPU_ARB_DBG_STAT_L2C1                    (volatile uint32_t *)((0x27b8  << 2) + 0xff900000)
#define   VPU_ARB_PATH_CTRL                        (0x27b9)
#define P_VPU_ARB_PATH_CTRL                        (volatile uint32_t *)((0x27b9  << 2) + 0xff900000)
#define   VPU_ARB_PATH_MAP00                       (0x27ba)
#define P_VPU_ARB_PATH_MAP00                       (volatile uint32_t *)((0x27ba  << 2) + 0xff900000)
#define   VPU_ARB_PATH_MAP01                       (0x27bb)
#define P_VPU_ARB_PATH_MAP01                       (volatile uint32_t *)((0x27bb  << 2) + 0xff900000)
#define   VPU_ARB_PATH_MAP02                       (0x27bc)
#define P_VPU_ARB_PATH_MAP02                       (volatile uint32_t *)((0x27bc  << 2) + 0xff900000)
#define   VPU_ARB_PATH_MAP03                       (0x27bd)
#define P_VPU_ARB_PATH_MAP03                       (volatile uint32_t *)((0x27bd  << 2) + 0xff900000)
#define   VPU_ARB_PATH_MAP10                       (0x27be)
#define P_VPU_ARB_PATH_MAP10                       (volatile uint32_t *)((0x27be  << 2) + 0xff900000)
#define   VPU_ARB_PATH_MAP11                       (0x27bf)
#define P_VPU_ARB_PATH_MAP11                       (volatile uint32_t *)((0x27bf  << 2) + 0xff900000)
#define   VPU_ARB_PATH_MAP12                       (0x27c0)
#define P_VPU_ARB_PATH_MAP12                       (volatile uint32_t *)((0x27c0  << 2) + 0xff900000)
#define   VPU_ARB_PATH_MAP13                       (0x27c1)
#define P_VPU_ARB_PATH_MAP13                       (volatile uint32_t *)((0x27c1  << 2) + 0xff900000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpu_arb_axi_regs.h
//
// the segment is 8'he0-8'hef
#define   VPU_VENCL_DITH_CTRL                      (0x27e0)
#define P_VPU_VENCL_DITH_CTRL                      (volatile uint32_t *)((0x27e0  << 2) + 0xff900000)
#define   VPU_VENCL_DITH_LUT_1                     (0x27e1)
#define P_VPU_VENCL_DITH_LUT_1                     (volatile uint32_t *)((0x27e1  << 2) + 0xff900000)
#define   VPU_VENCL_DITH_LUT_2                     (0x27e2)
#define P_VPU_VENCL_DITH_LUT_2                     (volatile uint32_t *)((0x27e2  << 2) + 0xff900000)
#define   VPU_VENCL_DITH_LUT_3                     (0x27e3)
#define P_VPU_VENCL_DITH_LUT_3                     (volatile uint32_t *)((0x27e3  << 2) + 0xff900000)
#define   VPU_VENCL_DITH_LUT_4                     (0x27e4)
#define P_VPU_VENCL_DITH_LUT_4                     (volatile uint32_t *)((0x27e4  << 2) + 0xff900000)
#define   VPU_VENCL_DITH_LUT_5                     (0x27e5)
#define P_VPU_VENCL_DITH_LUT_5                     (volatile uint32_t *)((0x27e5  << 2) + 0xff900000)
#define   VPU_VENCL_DITH_LUT_6                     (0x27e6)
#define P_VPU_VENCL_DITH_LUT_6                     (volatile uint32_t *)((0x27e6  << 2) + 0xff900000)
#define   VPU_VENCL_DITH_LUT_7                     (0x27e7)
#define P_VPU_VENCL_DITH_LUT_7                     (volatile uint32_t *)((0x27e7  << 2) + 0xff900000)
#define   VPU_VENCL_DITH_LUT_8                     (0x27e8)
#define P_VPU_VENCL_DITH_LUT_8                     (volatile uint32_t *)((0x27e8  << 2) + 0xff900000)
#define   VPU_VENCL_DITH_LUT_9                     (0x27e9)
#define P_VPU_VENCL_DITH_LUT_9                     (volatile uint32_t *)((0x27e9  << 2) + 0xff900000)
#define   VPU_VENCL_DITH_LUT_10                    (0x27ea)
#define P_VPU_VENCL_DITH_LUT_10                    (volatile uint32_t *)((0x27ea  << 2) + 0xff900000)
#define   VPU_VENCL_DITH_LUT_11                    (0x27eb)
#define P_VPU_VENCL_DITH_LUT_11                    (volatile uint32_t *)((0x27eb  << 2) + 0xff900000)
#define   VPU_VENCL_DITH_LUT_12                    (0x27ec)
#define P_VPU_VENCL_DITH_LUT_12                    (volatile uint32_t *)((0x27ec  << 2) + 0xff900000)
//new added 4x4 dither
// the segment is 8'hf0
#define   VPU_HDMI_DITH_01_04                      (0x27f0)
#define P_VPU_HDMI_DITH_01_04                      (volatile uint32_t *)((0x27f0  << 2) + 0xff900000)
#define   VPU_HDMI_DITH_01_15                      (0x27f1)
#define P_VPU_HDMI_DITH_01_15                      (volatile uint32_t *)((0x27f1  << 2) + 0xff900000)
#define   VPU_HDMI_DITH_01_26                      (0x27f2)
#define P_VPU_HDMI_DITH_01_26                      (volatile uint32_t *)((0x27f2  << 2) + 0xff900000)
#define   VPU_HDMI_DITH_01_37                      (0x27f3)
#define P_VPU_HDMI_DITH_01_37                      (volatile uint32_t *)((0x27f3  << 2) + 0xff900000)
#define   VPU_HDMI_DITH_10_04                      (0x27f4)
#define P_VPU_HDMI_DITH_10_04                      (volatile uint32_t *)((0x27f4  << 2) + 0xff900000)
#define   VPU_HDMI_DITH_10_15                      (0x27f5)
#define P_VPU_HDMI_DITH_10_15                      (volatile uint32_t *)((0x27f5  << 2) + 0xff900000)
#define   VPU_HDMI_DITH_10_26                      (0x27f6)
#define P_VPU_HDMI_DITH_10_26                      (volatile uint32_t *)((0x27f6  << 2) + 0xff900000)
#define   VPU_HDMI_DITH_10_37                      (0x27f7)
#define P_VPU_HDMI_DITH_10_37                      (volatile uint32_t *)((0x27f7  << 2) + 0xff900000)
#define   VPU_HDMI_DITH_11_04                      (0x27f8)
#define P_VPU_HDMI_DITH_11_04                      (volatile uint32_t *)((0x27f8  << 2) + 0xff900000)
#define   VPU_HDMI_DITH_11_15                      (0x27f9)
#define P_VPU_HDMI_DITH_11_15                      (volatile uint32_t *)((0x27f9  << 2) + 0xff900000)
#define   VPU_HDMI_DITH_11_26                      (0x27fa)
#define P_VPU_HDMI_DITH_11_26                      (volatile uint32_t *)((0x27fa  << 2) + 0xff900000)
#define   VPU_HDMI_DITH_11_37                      (0x27fb)
#define P_VPU_HDMI_DITH_11_37                      (volatile uint32_t *)((0x27fb  << 2) + 0xff900000)
#define   VPU_HDMI_DITH_CNTL                       (0x27fc)
#define P_VPU_HDMI_DITH_CNTL                       (volatile uint32_t *)((0x27fc  << 2) + 0xff900000)
//========================================================================
//  MIPI CSI2 Controller Adaptor    (16'h2a00 - 16'h2aff)
//
//========================================================================
//`define  CSI2_VCBUS_BASE            8'h2a
//`include "csi2_regs.h"
//======================================================================
// D2D3 registers
//======================================================================
//`define     D2D3_VCBUS_BASE         8'h2b
//
// Reading file:  d2d3_regs.h
//
//===========================================================================
// D2D3 Registers    0x - 0x
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  D2D3_VCBUS_BASE = 0x2b
// -----------------------------------------------
//------------------------------------------------------------------------------
// D2D3 top-level registers
//------------------------------------------------------------------------------
// Bit 31    RW, rd_lock_en,     1 to allow update some read-only registers based on filed
// Bit 30    RW, sw_rst_nobuf,   1 to reset the whole d2d3 unit
// Bit 29:28 RW, clk_auto_dis,   [29] DBR clock disable
//                               [28] DPG clock disable
// Bit 27:16 RW, clk_ctrl,       [27:26] gated clock control for register unit
//                               [25:24] gated clock control for DBR unit
//                               [23:22] gated clock control for LBDG unit
//                               [21:20] gated clock control for MBDG unit
//                               [19:18] gated clock control for CBDG unit
//                               [17:16] gated clock control for DBLD unit and SCD81 unit
// Bit 15:12 Reserved
// Bit 11    RW, lo_chroma_sign, 0: negate the u/v component of DBR left channel video output, 1: bypass
// Bit 10    RW, ro_chroma_sign, 0: negate the u/v component of DBR right channel video output, 1: bypass
// Bit 9     RW, vi0_chroma_sign, 0: negate the u/v component of DPG video input, 1: bypass
// Bit 8     RW, vi1_chroma_sign, 0: negate the u/v component of DBR video input, 1: bypass
// Bit 7:5   Reserved
// Bit 4     RW, lg_en,          Enable the LBDG unit and LBDG clock
// Bit 3     RW, mg_en,          Enable the MBDG unit and MBDG clock
// Bit 2     RW, cg_en,          Enable the CBDG unit and CBDG clock
// Bit 1     RW, dbr_en,         Enable the DBR unit and DBR clock
// Bit 0     RW, dpg_en,         Enable the DPG unit and clock except sub-unit CBDG, MBDG and LBDG
#define   D2D3_GLB_CTRL                            (0x2b00)
#define P_D2D3_GLB_CTRL                            (volatile uint32_t *)((0x2b00  << 2) + 0xff900000)
// Indicate the input picture size in DPG unit
// Bit 31:16 RW, szx_vi_m1,      The horizontal size minus 1
// Bit 15:0  RW, szy_vi_m1,      The vertical size minus 1
#define   D2D3_DPG_INPIC_SIZE                      (0x2b01)
#define P_D2D3_DPG_INPIC_SIZE                      (volatile uint32_t *)((0x2b01  << 2) + 0xff900000)
// Indicate the output picture size in DBR unit
// Bit 31:16 RW, szx_vo_m1,      The horizontal size minus 1
// Bit 15:0  RW, szy_vo_m1,      The vertical size minus 1
#define   D2D3_DBR_OUTPIC_SIZE                     (0x2b02)
#define P_D2D3_DBR_OUTPIC_SIZE                     (volatile uint32_t *)((0x2b02  << 2) + 0xff900000)
// Indicate the rectangular window to generate the "depth" in DPG unit
// Bit 31:16 RW, dg_win_x_start, Horizontal start position, count from 0
// Bit 15:0  RW, dg_win_x_end,   Horizontal end position, count from 0
#define   D2D3_DGEN_WIN_HOR                        (0x2b03)
#define P_D2D3_DGEN_WIN_HOR                        (volatile uint32_t *)((0x2b03  << 2) + 0xff900000)
// Indicate the rectangular window to generate the "depth" in DPG unit
// Bit 31:16 RW, dg_win_y_start, Vertical start position, count from 0
// Bit 15:0  RW, dg_win_y_end,   Vertical end position, count from 0
#define   D2D3_DGEN_WIN_VER                        (0x2b04)
#define P_D2D3_DGEN_WIN_VER                        (volatile uint32_t *)((0x2b04  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// CBDG SCU18 SCD81 SCD81_PRE registers
// cg: color based depth generate module
// scu18: scale up module
// scd81: scale down module
// scd81_pre: scd81 pre-scale-down module
//------------------------------------------------------------------------------
// Indicate parameters of pre-scale-down unit
// Bit 31:16 RW, scd81_hphs_step, horizontal step
// Bit 15:0  RW, scd81_hphs_ini, horizontal initial phase
#define   D2D3_PRE_SCD_H                           (0x2b05)
#define P_D2D3_PRE_SCD_H                           (volatile uint32_t *)((0x2b05  << 2) + 0xff900000)
// Bit 31:16 RW, scu18_iniph,    initial phase in SCU18,
//                               [23:16] indicate the horizontal phase offset from the first data of every line
//                               [31:24] indicate the vertical phase offset from the first line of every frame
// Bit 15:12 Reserved
// Bit 11    RW, scd81_predrop_en, 1 to enable scd81 pre-scale-down function
// Bit 10:9  RW, cg_csc_sel,     Color Space Conversion(CSC) matrix mode selector in CBDG
//                               0: BT.601 (16-235/240)
//                               1: BT.709 (16-235/240)
//                               2: BT.601 (0-255)
//                               3: BT.709 (0-255)
// Bit 8     RW, scu18_rep_en,   1 to double each line of the SCU18 output
// Bit 7:4   RW, scu18_factor,   up-scale factor in SCU18 on DBR input depth data
//                               [7:6] for vertical, 0->1:1, 1->1:2, 2->1:4, 3->1:8
//                               [5:4] for horizontal, 0->1:1, 1->1:2, 2->1:4, 3->1:8
// Bit 3:0   RW, scd81_factor,   down-scale factor in SCD81 on DPG source video
//                               [3:2] for vertical, 0->1:1, 1->2:1, 2->4:1, 3->8:1
//                               [1:0] for horizontal, 0->1:1, 1->2:1, 2->4:1, 3->8:1
#define   D2D3_SCALER_CTRL                         (0x2b06)
#define P_D2D3_SCALER_CTRL                         (volatile uint32_t *)((0x2b06  << 2) + 0xff900000)
// Bit 31:24 RW, cg_rpg_dth,     the down |r-g| threshold for sky detect
// Bit 23:16 RW, cg_rpg_uth,     the up |r-g| threshold for sky detect
// Bit 15:8  RW, cg_lum_dth,     the down Y threshold for sky detect
// Bit 7:0   RW, cg_lum_uth,     the up Y threshold for sky detect
#define   D2D3_CG_THRESHOLD_1                      (0x2b07)
#define P_D2D3_CG_THRESHOLD_1                      (volatile uint32_t *)((0x2b07  << 2) + 0xff900000)
// Bit 31:24 RW, cg_rpb_dth,     the down |r-b| threshold for sky detect
// Bit 23:16 RW, cg_rpb_uth,     the up |r-b| threshold for sky detect
// Bit 15:8  RW, cg_bpg_dth,     the down |b-g| threshold for sky detect
// Bit 7:0   RW, cg_bpg_uth,     the up |b-g| threshold for sky detect
#define   D2D3_CG_THRESHOLD_2                      (0x2b08)
#define P_D2D3_CG_THRESHOLD_2                      (volatile uint32_t *)((0x2b08  << 2) + 0xff900000)
// Bit 31:24 RW, cg_vp_rel_k,    parameter to calculate vanish point reliability
// Bit 23:16 RW, cg_vp_y_thr,    the max limitation to calculate the vanish-point's vertical position
// Bit 15:8  RW, cg_meet_dval,   signed depth value in the sky-bitmap
// Bit 7:0   RW, cg_unmt_dval,   signed depth value not in the sky-bitmap
#define   D2D3_CG_PARAM_1                          (0x2b09)
#define P_D2D3_CG_PARAM_1                          (volatile uint32_t *)((0x2b09  << 2) + 0xff900000)
// Bit 31:16 RW, cg_vpos_thr,    Maximal vertical limitation for sky-bit map when cg_vpos_en=1 and cg_vpos_adpt_en=0
// Bit 15:8  Reserved
// Bit 7     RW, cg_vpos_en,     1 to enable the max vertical limitation for sky-bitmap
// Bit 6     RW, cg_vpos_adpt_en, 1 to enable the adaptive max vertical limitation for sky-bitmap.
//                               It is only valid when cg_vpos_en=1.
//                               The max vertical limitation is the previous field's vanish-point (vertical position) if cg_vpos_adpt_en=1.
// Bit 5:4   RW, cg_lpf_bypass,  bypass of low pass filter
//                               [5]:Vertical bypass, 1: bypass the vertical LPF on the CBDG depth
//                               [4]:Horizontal bypass, 1: bypass the horizontal LPF on the CBDG depth
// Bit 3:0   RW, cg_vp_rel_s,    parameter to calculate vanish point reliability
#define   D2D3_CG_PARAM_2                          (0x2b0a)
#define P_D2D3_CG_PARAM_2                          (volatile uint32_t *)((0x2b0a  << 2) + 0xff900000)
// Indicate parameters of pre-scale-down unit
// Bit 31:16 RW, scd81_vphs_step, vertical step
// Bit 15:0  RW, scd81_vphs_ini, vertical initial phase
#define   D2D3_PRE_SCD_V                           (0x2b0b)
#define P_D2D3_PRE_SCD_V                           (volatile uint32_t *)((0x2b0b  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// D2P registers
// d2p: depth to parallax transform module
//------------------------------------------------------------------------------
// Bit 31:24 RW, d2p_brdwid,     Horizontal boundary width for parallax, the parallax value would be forced to 0 in boundary,
//                               the d2p_brdwid should not 0 when D2P_WRAP is enabled
// Bit 23:22 Reserved
// Bit 21:20 RW, d2p_lomode,     line output mode,
//                               0:whole line is left or right;  1:whole line is left or right;
//                               2:left/right pixel interleaved;  3:left/right half-line interleaved
// Bit 19    RW, d2p_neg,        1 to exchange the left and right parallax value
// Bit 18    Reserved
// Bit 17    RW, d2p_wrap_en,    1 to enable D2P_WRAP unit
// Bit 16    RW, d2p_lar,        Indicate the first output for left or right, 0: left; 1: right
// Bit 15    RW, d2p_lr_switch,  enable left/right flag filed switch automatically, only valid when parallax output mode is field interleaved
// Bit 14    RW, d2p_1dtolr,     enable to generate 2 parallax data (left and right) from one depth
// Bit 13:12 RW, d2p_out_mode,   Parallax output mode
//                               0:left/right pixel interleaved; 1:line or half line interleaved; 2:field interleaved
// Bit 11:8  RW, d2p_smode,      Shift mode,
//                               0: no shift; 1: enable left shift;
//                               2: enable right shift; 3: both left and right shift are enabled
// Bit 7:0   RW, d2p_offset,     depth offset, signed,
#define   D2D3_D2P_PARAM_1                         (0x2b0c)
#define P_D2D3_D2P_PARAM_1                         (volatile uint32_t *)((0x2b0c  << 2) + 0xff900000)
// Bit 31:24 RW, d2p_pg0,        positive parallax gain when Parallax value < pt
// Bit 23:16 RW, d2p_pg1,        positive parallax gain when Parallax value >= pt
// Bit 15:8  RW, d2p_pt,         unsigned value used to separate the positive parallax range
// Bit 7:0   RW, d2p_plimit,     The limitation for positive parallax
#define   D2D3_D2P_PARAM_2                         (0x2b0d)
#define P_D2D3_D2P_PARAM_2                         (volatile uint32_t *)((0x2b0d  << 2) + 0xff900000)
// Bit 31:24 RW, d2p_ng0,        negative parallax gain when Parallax value > -nt
// Bit 23:16 RW, d2p_ng1,        negative parallax gain when Parallax value <= -nt
// Bit 15:8  RW, d2p_nt,         unsigned value used to separate the negative parallax range
// Bit 7:0   RW, d2p_nlimit,     The limitation for negative parallax
#define   D2D3_D2P_PARAM_3                         (0x2b0e)
#define P_D2D3_D2P_PARAM_3                         (volatile uint32_t *)((0x2b0e  << 2) + 0xff900000)
// Indicate step parameters of SCU18 unit
// Bit 31:17 Reserved
// Bit 16    RW, scu18_step_en,   step set enable in SCU18
// Bit 15:8  RW, scu18_hphs_step, horizontal step in SCU18
// Bit 7:0   RW, scu18_vphs_step, vertical step in SCU18
#define   D2D3_SCU18_STEP                          (0x2b0f)
#define P_D2D3_SCU18_STEP                          (volatile uint32_t *)((0x2b0f  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// LBDG and DBLD registers
// lg: luma based depth generate module
// db: depth blending module
//------------------------------------------------------------------------------
// Bit 31:22 Reserved
// Bit 21:20 RW, db_lpf_bpcoeff, [21]:Vertical factor of low pass filter,
//                               1: Vfactor = 0/0/64/0/0, 0: Vfactor = {db_vf_a,db_vf_b,db_vf_c,db_vf_b,db_vf_a}, see D2D3_CTRL_15
//                               [20]:Horizontal factor of low pass filter,
//                               1: Hfactor = 0/0/64/0/0, 0: Hfactor = {db_hf_a,db_hf_b,db_hf_c,db_hf_b,db_hf_a}, see D2D3_CTRL_14
// Bit 19:18 RW, lg_lpf_bpcoeff, [19]:Vertical factor of low pass filter, 1: Vfactor = 0/64/0, 0: Vfactor = 20/24/20
//                               [18]:Horizontal factor of low pass filter, 1: Hfactor = 0/64/0, 0: Hfactor = 16/32/16
// Bit 17:16 RW, cg_lpf_bpcoeff, [17]:Vertical factor of low pass filter, 1: Vfactor = 0/64/0, 0: Vfactor = 20/24/20
//                               [16]:Horizontal factor of low pass filter, 1: Hfactor = 0/64/0, 0: Hfactor = 16/32/16
// Bit 15:10 Reserved
// Bit 9:8   RW, db_lpf_bypass,  [9] 1 to bypass the vertical LPF on the DBLD depth
//                               [8] 1 to bypass the horizontal LPF on the DBLD depth
// Bit 7:6   RW, lg_lpf_bypass,  [7] 1 to bypass the vertical LPF on the LBDG depth
//                               [6] 1 to bypass the horizontal LPF on the LBDG depth
// Bit 5:0   RW, lg_kc,          gain of CPL(v-u+256-y) to calculate the depth in LBDG
#define   D2D3_DPF_LPF_CTRL                        (0x2b10)
#define P_D2D3_DPF_LPF_CTRL                        (volatile uint32_t *)((0x2b10  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// DBLD registers
// db: depth blending module
//------------------------------------------------------------------------------
// Bit 31:24 RW, db_g2_cg,       gain of CBDG depth in DBLD
// Bit 23:16 RW, db_o2_cg,       offset of CBDG depth in DBLD
// Bit 15:8  RW, db_g1_cg,       gain of CBDG depth using for summary in DBLD
// Bit 7:0   RW, db_o1_cg,       offset of CBDG depth using for summary in DBLD
#define   D2D3_DBLD_CG_PARAM                       (0x2b11)
#define P_D2D3_DBLD_CG_PARAM                       (volatile uint32_t *)((0x2b11  << 2) + 0xff900000)
// Bit 31:24 RW, db_g2_mg,       gain of MBDG depth in DBLD
// Bit 23:16 RW, db_o2_mg,       offset of MBDG depth in DBLD
// Bit 15:8  RW, db_g1_mg,       gain of MBDG depth using for summary in DBLD
// Bit 7:0   RW, db_o1_mg,       offset of MBDG depth using for summary in DBLD
#define   D2D3_DBLD_MG_PARAM                       (0x2b12)
#define P_D2D3_DBLD_MG_PARAM                       (volatile uint32_t *)((0x2b12  << 2) + 0xff900000)
// Bit 31:24 RW, db_g2_lg,       gain of LBDG depth in DBLD
// Bit 23:16 RW, db_o2_lg,       offset of LBDG depth in DBLD
// Bit 15:8  RW, db_g1_lg,       gain of LBDG depth using for summary in DBLD
// Bit 7:0   RW, db_o1_lg,       offset of LBDG depth using for summary in DBLD
#define   D2D3_DBLD_LG_PARAM                       (0x2b13)
#define P_D2D3_DBLD_LG_PARAM                       (volatile uint32_t *)((0x2b13  << 2) + 0xff900000)
// Bit 31:24 RW, db_factor,      unsigned gain of difference in DBLD
// Bit 23:16 RW, db_hf_a,        see register DPF_LPF_CTRL:db_lpf_bpcoeff, sign
// Bit 15:8  RW, db_hf_b,        see register DPF_LPF_CTRL:db_lpf_bpcoeff, sign
// Bit 7:0   RW, db_hf_c,        see register DPF_LPF_CTRL:db_lpf_bpcoeff, sign
#define   D2D3_DBLD_LPF_HCOEFF                     (0x2b14)
#define P_D2D3_DBLD_LPF_HCOEFF                     (volatile uint32_t *)((0x2b14  << 2) + 0xff900000)
// Bit 31:24 RW, db_owin_fill,   signed depth value outside the rectangular window defined in register DGEN_WIN_HOR and DGEN_WIN_VER
// Bit 23:16 RW, db_vf_a,        see register DPF_LPF_CTRL:db_lpf_bpcoeff, sign
// Bit 15:8  RW, db_vf_b,        see register DPF_LPF_CTRL:db_lpf_bpcoeff, sign
// Bit 7:0   RW, db_vf_c,        see register DPF_LPF_CTRL:db_lpf_bpcoeff, sign
#define   D2D3_DBLD_LPF_VCOEFF                     (0x2b15)
#define P_D2D3_DBLD_LPF_VCOEFF                     (volatile uint32_t *)((0x2b15  << 2) + 0xff900000)
// Bit 31:28 RW, hist_depth_idx,
// Bit 27:26 Reserved
// Bit 25    RW, mbdg_dep_neg,   1 to negate the output data of MBDG
// Bit 24    RW, lbdg_dep_neg,   1 to negate the output data of LBDG
// Bit 23:16 RW, db_f1_ctrl,     MUX1 selector
//                               [1:0] MUX1 path1 selector, 0:summary, 1:CBDG, 2:MBDG, 3:LBDG
//                               [3:2] MUX1 path2 selector, 0:summary, 1:CBDG, 2:MBDG, 3:LBDG
//                               [6:4] MUX1 out1 selector, 1:CBDG, 2:MBDG, 3:LBDG, 4:summary, 5:MUX1out0, others:summary
//                               [7] MUX1OUT0 selector, 0:MIN (MUX1PATH1,MUX1Path2), 1:MAX (MUX1Path1,MUX1Path2)
// Bit 15:8  RW, db_f2_ctrl,     MUX2 selector
//                               [1:0] MUX2 path1 selector, 0:MUX1OUT1, 1:CBDG, 2:MBDG, 3:LBDG
//                               [3:2] MUX2 path2 selector, 0:MUX1OUT1, 1:CBDG, 2:MBDG, 3:LBDG
//                               [6:4] MUX2 out1 selector, 1:CBDG, 2:MBDG, 3:LBDG, 4:summary, 5:MUX2out0, others:MUX2out0
//                               [7] MUX2OUT0 selector, 0:MIN (MUX2PATH1,MUX2Path2), 1:MAX (MUX2Path1,MUX2Path2)
// Bit 7:4   RW, db_fifo0_sel,   the source input of FIFO0
//                               0: no use; 1:from CBDG; 2:from MBDG; 3:from LBDG others:reserved
// Bit 3:0   RW, db_fifo1_sel,   the source input of FIFO1
//                               0: no use; 1:from CBDG; 2:from MBDG; 3:from LBDG 4: from FIFO0; others:reserved
#define   D2D3_DBLD_PATH_CTRL                      (0x2b16)
#define P_D2D3_DBLD_PATH_CTRL                      (volatile uint32_t *)((0x2b16  << 2) + 0xff900000)
// Indicate the input picture size in SCU18 unit
// Bit 31:16 RW, szy_scui,       The vertical size
// Bit 15:0  RW, szx_scui,       The horizontal size
#define   D2D3_SCU18_INPIC_SIZE                    (0x2b17)
#define P_D2D3_SCU18_INPIC_SIZE                    (volatile uint32_t *)((0x2b17  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// MBDG registers
// mg: model based depth generate module
//------------------------------------------------------------------------------
// Bit 31:18 Reserved
// Bit 17    RW, mg_vp_en,       mdg vanish point enable, not used
// Bit 16    RW, mg_sw_en,       1 to use the software forced parameter for the point D, U and C in MBDG
// Bit 15:8  RW, mg_owin_fill,   Signed depth value outside the rectangular window defined in register DGEN_WIN_HOR and DGEN_WIN_VER
// Bit 7     RW, mg_iir_en,      1 to enable the 2-taps IIR filter in MBDG
// Bit 6:0   RW, mg_iir,         [6]: 1 to bypass the 2-taps IIR filter in MBDG
//                               [5:0]:Unsigned coefficient of the 2-taps IIR filter in MBDG
//                               [6]:bypass, 1:bypass, 0:not bypass
#define   D2D3_MBDG_CTRL                           (0x2b18)
#define P_D2D3_MBDG_CTRL                           (volatile uint32_t *)((0x2b18  << 2) + 0xff900000)
// Bit 31:28 RW, mg_dtl_pxl_left, Max pixel number (1<< mg_dtl_pxl_left) using in the left window for activities in MBDG
// Bit 27:24 RW, mg_dtl_pxl_right, Max pixel number (1<< mg_dtl_pxl_right) using in the right window for activities in MBDG
// Bit 23:16 RW, mg_cx_sw,       Depth of point C in horizontal curve in MBDG for software forced
// Bit 15:8  RW, mg_ux_sw,       Depth of point U in horizontal curve in MBDG for software forced
// Bit 7:0   RW, mg_dx_sw,       Depth of point D in horizontal curve in MBDG for software forced
#define   D2D3_MBDG_PARAM_0                        (0x2b19)
#define P_D2D3_MBDG_PARAM_0                        (volatile uint32_t *)((0x2b19  << 2) + 0xff900000)
// Bit 31:28 RW, mg_dtl_pxl_up,  Max pixel number (1<< mg_dtl_pxl_up) using in the top window for activities in MBDG
// Bit 27:24 RW, mg_dtl_pxl_dn,  Max pixel number (1<< mg_dtl_pxl_dn) using in the bottom window for activities in MBDG
// Bit 23:16 RW, mg_cy_sw,       Depth of point C in vertical curve in MBDG for software forced
// Bit 15:8  RW, mg_uy_sw,       Depth of point U in vertical curve in MBDG for software forced
// Bit 7:0   RW, mg_dy_sw,       Depth of point D in vertical curve in MBDG for software forced
#define   D2D3_MBDG_PARAM_1                        (0x2b1a)
#define P_D2D3_MBDG_PARAM_1                        (volatile uint32_t *)((0x2b1a  << 2) + 0xff900000)
// Bit 31:24 RW, mg_dtl_ln_up,   Line number in the top window for activities in MBDG
// Bit 23:16 RW, mg_dtl_ln_dn,   Line number in the bottom window for activities in MBDG
// Bit 15:8  RW, mg_dtl_ln_left, Column number in the left window for activities in MBDG
// Bit 7:0   RW, mg_dtl_ln_right,Column number in the right window for activities in MBDG
#define   D2D3_MBDG_PARAM_2                        (0x2b1b)
#define P_D2D3_MBDG_PARAM_2                        (volatile uint32_t *)((0x2b1b  << 2) + 0xff900000)
// Bit 31:24 RW, mg_y_max,       Software initial depth of point D and U in vertical curve
// Bit 23:16 RW, mg_y_min,       Software initial depth of point C in vertical curve
// Bit 15:8  RW, mg_x_max,       Software initial depth of point D and U in horizontal curve
// Bit 7:0   RW, mg_x_min,       Software initial depth of point C in horizontal curve
#define   D2D3_MBDG_PARAM_3                        (0x2b1c)
#define P_D2D3_MBDG_PARAM_3                        (volatile uint32_t *)((0x2b1c  << 2) + 0xff900000)
// Bit 31:27 Reserved
// Bit 26    RW, mg_y_adapt_en,  1 to enable the adaptive mode for point U/D in vertical curve calculation
// Bit 25    RW, mg_xmm_adapt_en, 1 to enable the XMM adaptive mode for point U/D in horizontal curve calculation
// Bit 24    RW, mg_x_adapt_en,  1 to enable the adaptive mode for point U/D in horizontal curve calculation
// Bit 23:20 RW, mg_ytrans_1,    Shifter controller in vertical curve calculation, if mg_xtrans_1<0, right shift abs(mg_xtrans_1) bits, others left shift abs(mg_xtrans_1) bits
// Bit 19:16 RW, mg_xtrans_1,    Shifter controller in horizontal curve calculation, if mg_xtrans_1<0, right shift abs(mg_xtrans_1) bits, others left shift abs(mg_xtrans_1) bits
// Bit 15:8  RW, mg_yk_0,        The based activities value of the ACT for vertical curve
// Bit 7:0   RW, mg_xk_0,        The based activities value of the ACT for horizontal curve
#define   D2D3_MBDG_PARAM_4                        (0x2b1d)
#define P_D2D3_MBDG_PARAM_4                        (volatile uint32_t *)((0x2b1d  << 2) + 0xff900000)
// Bit 31:24 RW, mg_ysu3,        Quantized value 3 in vertical curve adaptive calculation
// Bit 23:16 RW, mg_ysu2,        Quantized value 2 in vertical curve adaptive calculation
// Bit 15:8  RW, mg_ysu1,        Quantized value 1 in vertical curve adaptive calculation
// Bit 7:0   RW, mg_ysu0,        Quantized value 0 in vertical curve adaptive calculation
#define   D2D3_MBDG_PARAM_5                        (0x2b1e)
#define P_D2D3_MBDG_PARAM_5                        (volatile uint32_t *)((0x2b1e  << 2) + 0xff900000)
// Bit 31:24 RW, mg_xsu3,        Quantized value 3 in horizontal curve adaptive calculation
// Bit 23:16 RW, mg_xsu2,        Quantized value 2 in horizontal curve adaptive calculation
// Bit 15:8  RW, mg_xsu1,        Quantized value 1 in horizontal curve adaptive calculation
// Bit 7:0   RW, mg_xsu0,        Quantized value 0 in horizontal curve adaptive calculation
#define   D2D3_MBDG_PARAM_6                        (0x2b1f)
#define P_D2D3_MBDG_PARAM_6                        (volatile uint32_t *)((0x2b1f  << 2) + 0xff900000)
// Bit 31:16 Reserved
// Bit 15:8  RW, mg_xsu4,        Quantized value 4 in horizontal curve adaptive calculation
// Bit 7:0   RW, mg_ysu4,        Quantized value 4 in vertical curve adaptive calculation
#define   D2D3_MBDG_PARAM_7                        (0x2b20)
#define P_D2D3_MBDG_PARAM_7                        (volatile uint32_t *)((0x2b20  << 2) + 0xff900000)
// Bit 31:28 RW, dbg_hscnt_sel   see DBG_STATUS_2
// Bit 27:25 Reserved
// Bit 24    RW, dbg_dbr_en,     1 to enable debug mode in DBR
// Bit 23:16 RW, dbg_force_data, Forced data in debug mode
// Bit 15:12 RW, dbg_bld_ctrl,   debug controller for DBLD
//                               [12]:enable;  [13]: 0 for passive mode, 0 for handshake mode
//                               [15:14]: 0 for constant mode, 1 for step1 mode
// Bit 11:8  RW, dbg_mg_ctrl,    debug controller for MBDG
//                               [8]:enable;  [9]: 0 for passive mode, 0 for handshake mode
//                               [11:10]: 0 for constant mode, 1 for step1 mode
// Bit 7:4   RW, dbg_cg_ctrl,    debug controller for CBDG
//                               [4]:enable;  [5]: 0 for passive mode, 0 for handshake mode
//                               [7:6]: 0 for constant mode, 1 for step1 mode
// Bit 3:0   RW, dbg_lg_ctrl,    debug controller for LBDG
//                               [0]:enable;  [1]: 0 for passive mode, 0 for handshake mode
//                               [3:2]: 0 for constant mode, 1 for step1 mode
#define   D2D3_DBG_CTRL                            (0x2b23)
#define P_D2D3_DBG_CTRL                            (volatile uint32_t *)((0x2b23  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// DWMIF registers
//------------------------------------------------------------------------------
// Bit 31:18 Reserved
// Bit 17    RW, dw_x_rev        0: Normal write data from left to right in horizontal
//                               1: Reversed write data from left to right in horizontal
// Bit 16    RW, dw_y_rev        0: Normal write data from top to bottom in horizontal
//                               1: Reversed write data from bottom to top in horizontal
// Bit 15    RW, dw_done_clr     1 to clear register depw_done (DWMIF_STATUS)
// Bit 14    RW, dw_little_endian, 0: data is ordered in big-endian, 1: little endian
// Bit 13:12 RW, dw_pic_struct,  0:read every line, 1:reserved, 2:read even line, 3:read odd line
// Bit 11    RW, dw_urgent,      urgent index
// Bit 10    RW, dw_clr_wrrsp,   1:clear the write fifo counter
// Bit 9     RW, dw_canvas_wr,   canvas write initialization again
// Bit 8     RW, dw_req_en,      1 to enable write request
// Bit 7:0   RW, dw_canvas_index,Canvas index for the MSB of memory address for memory write
#define   D2D3_DWMIF_CTRL                          (0x2b24)
#define P_D2D3_DWMIF_CTRL                          (volatile uint32_t *)((0x2b24  << 2) + 0xff900000)
// Bit 31    Reserved
// Bit 30:16 RW, dw_end_x,       Horizontal end position for memory write, count by BYTE
// Bit 15    Reserved
// Bit 14:0  RW, dw_start_x,     Horizontal start position for memory write, count by BYTE
#define   D2D3_DWMIF_HPOS                          (0x2b25)
#define P_D2D3_DWMIF_HPOS                          (volatile uint32_t *)((0x2b25  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, dw_end_y,       Vertical end position for memory write, count by BYTE
// Bit 15:13 Reserved
// Bit 12:0  RW, dw_start_y,     Vertical start position for memory write, count by BYTE
#define   D2D3_DWMIF_VPOS                          (0x2b26)
#define P_D2D3_DWMIF_VPOS                          (volatile uint32_t *)((0x2b26  << 2) + 0xff900000)
// Bit 31:28 Reserved
// Bit 27:16 RW, dw_vsizem1,     Vertical size for memory write, equal the size minus 1
// Bit 15:12 Reserved
// Bit 11:0  RW, dw_hsizem1,     Horizontal size for memory write, equal the size minus 1
#define   D2D3_DWMIF_SIZE                          (0x2b27)
#define P_D2D3_DWMIF_SIZE                          (volatile uint32_t *)((0x2b27  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// DRMIF registers
//------------------------------------------------------------------------------
// Bit 31:18 Reserved
// Bit 17    RW, dr_y_rev,       0: Normal Read data from top to bottom in horizontal
//                               1: Reversed read data from bottom to top in horizontal
// Bit 16    RW, dr_x_rev,       0: Normal Read data from left to right in horizontal
//                               1: Reversed read data from right to left in horizontal
// Bit 15    RW, dr_clr_fifo_error, 1 to clear the overflow flag of the sticky FIFO
// Bit 14    RW, dr_little_endian, 0: data is ordered in big-endian; 1: little-endian
// Bit 13:12 RW, dr_pic_struct,  0: progressive;  1: Reserved;
//                               2: interlaced, even line;  3: interlaced, odd line
// Bit 11    RW, dr_urgent,      urgent index, no use in this system
// Bit 10:9  RW, dr_burst_size,  Burst read length for each request; 0=24,1=32,2=48,3=64
// Bit 8     RW, dr_req_en,      1 to enable read request
// Bit 7:0   RW, dr_canvas_index, Canvas index for the MSB of memory address for memory read
#define   D2D3_DRMIF_CTRL                          (0x2b28)
#define P_D2D3_DRMIF_CTRL                          (volatile uint32_t *)((0x2b28  << 2) + 0xff900000)
// Bit 31    Reserved
// Bit 30:16 RW, dr_end_x,       Horizontal end position for memory read, count by BYTE
// Bit 15    Reserved
// Bit 14:0  RW, dr_start_x,     Horizontal start position for memory read, count by BYTE
#define   D2D3_DRMIF_HPOS                          (0x2b29)
#define P_D2D3_DRMIF_HPOS                          (volatile uint32_t *)((0x2b29  << 2) + 0xff900000)
// Bit 31:29 Reserved
// Bit 28:16 RW, dr_end_y,       Vertical end position for memory read, count by BYTE
// Bit 15:13 Reserved
// Bit 12:0  RW, dr_start_y,     Vertical start position for memory read, count by BYTE
#define   D2D3_DRMIF_VPOS                          (0x2b2a)
#define P_D2D3_DRMIF_VPOS                          (volatile uint32_t *)((0x2b2a  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// PDR registers
// ddd: parallax based render
//------------------------------------------------------------------------------
// Bit 31:8  Reserved
// Bit 7     RW, ddd_brdlpf_en,  1 to enable the smooth filter on the depth around the boundary
// Bit 6     RW, ddd_extn_black, 1 to enable the function to fill black colour when interpolated pixels is outside the picture in DBR
// Bit 5     RW, ddd_wrap_en,    Reserved
// Bit 4     RW, ddd_hhalf,      1 to indicate the left/right line length is a half of original line.
// Bit 3:2   RW, ddd_out_mode,   Reserved
// Bit 1:0   RW, ddd_lomode,     wrap & pbr interleave mode:
//                               2'b0x: whole line is left or right;
//                               2'b10: d2p_lar=1(D2P_PARAM_1), rlrlrlrl inteleave in one line,
//                                      d2p_lar=0(D2P_PARAM_1), lrlrlrlr inteleave in one line,
//                               2'b11: d2p_lar=1(D2P_PARAM_1), rrrrr?llll, half line is right, another half is left,
//                                      d2p_lar=0(D2P_PARAM_1), lllll?rrrr, half line is left, another half is right,
#define   D2D3_DBR_DDD_CTRL                        (0x2b2c)
#define P_D2D3_DBR_DDD_CTRL                        (volatile uint32_t *)((0x2b2c  << 2) + 0xff900000)
// Bit 31:0  RW, ddd_dbg_ctrl,   no use
#define   D2D3_DBR_DDD_DBG                         (0x2b2d)
#define P_D2D3_DBR_DDD_DBG                         (volatile uint32_t *)((0x2b2d  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// LRDMX registers
//------------------------------------------------------------------------------
// Bit 31:9  Reserved
// Bit 8     RW, lr_merge,       1: all the left/right input go to the left channel output
// Bit 7:6   RW, lrd_ff0_sel,    FF0 source selector
//                               0:from left input; 1:from right input; 2:from FF0; 3:no used
// Bit 5:4   RW, lrd_ff1_sel,    FF1 source selector
//                               0:from left input; 1:from right input; 2:from FF0; 3:no used
// Bit 3:2   RW, lrd_lout_sel,   left channel DEMUX
//                               00: ff0  01:ff1   10: left input  11:right input
// Bit 1:0   RW, lrd_rout_sel,   right channel DEMUX
//                               00: ff1  01:ff0   10: left input  11:right input
#define   D2D3_DBR_LRDMX_CTRL                      (0x2b2f)
#define P_D2D3_DBR_LRDMX_CTRL                      (volatile uint32_t *)((0x2b2f  << 2) + 0xff900000)
//------------------------------------------------------------------------------
// Read Only registers
//------------------------------------------------------------------------------
// Bit 31:24 RO, ro_cg_vprel,    vanish point's reliability in CBDG
// Bit 23:12 RO, ro_cg_vpx,      vanish point's X-Axis in CBDG
// Bit 11:0  RO, ro_cg_vpy,      vanish point's Y-Axis in CBDG
#define   D2D3_CBDG_STATUS_1                       (0x2b30)
#define P_D2D3_CBDG_STATUS_1                       (volatile uint32_t *)((0x2b30  << 2) + 0xff900000)
// Bit 31:24 RO, ro_mg_cx[7:0],  X-Axis of point C in horizontal curve in MBDG
// Bit 23:16 RO, ro_mg_ux,       Depth value of point U in horizontal curve in MBDG
// Bit 15:8  RO, ro_mg_dx,       Depth value of point D in horizontal curve in MBDG
// Bit 7:0   RO, ro_mg_minx,     Depth value of point C in horizontal curve in MBDG
#define   D2D3_MBDG_STATUS_1                       (0x2b31)
#define P_D2D3_MBDG_STATUS_1                       (volatile uint32_t *)((0x2b31  << 2) + 0xff900000)
// Bit 31:24 RO, ro_mg_cy[7:0],  X-Axis of point C in vertical curve in MBDG
// Bit 23:16 RO, ro_mg_uy,       Depth value of point U in vertical curve in MBDG
// Bit 15:8  RO, ro_mg_dy,       Depth value of point D in vertical curve in MBDG
// Bit 7:0   RO, ro_mg_miny,     Depth value of point C in vertical curve in MBDG
#define   D2D3_MBDG_STATUS_2                       (0x2b32)
#define P_D2D3_MBDG_STATUS_2                       (volatile uint32_t *)((0x2b32  << 2) + 0xff900000)
// Bit 31    RO, ro_wrap_status, 1 indicate the D2P_WRAP is busy to perform the initialization
// Bit 30:8  Reserved
// Bit 7:4   RO, ro_mg_cy[11:8], X-Axis of point C in vertical curve in MBDG
// Bit 3:0   RO, ro_mg_cx[11:8], X-Axis of point C in horizontal curve in MBDG
#define   D2D3_MBDG_STATUS_3                       (0x2b33)
#define P_D2D3_MBDG_STATUS_3                       (volatile uint32_t *)((0x2b33  << 2) + 0xff900000)
// Bit 31:21 Reserved
// Bit 20:0  RO, ro_mg_sum_u,    ACT(top): activities of the top part
#define   D2D3_MBDG_STATUS_4                       (0x2b34)
#define P_D2D3_MBDG_STATUS_4                       (volatile uint32_t *)((0x2b34  << 2) + 0xff900000)
// Bit 31:21 Reserved
// Bit 20:0  RO, ro_mg_sum_d,    ACT(bottom): activities of the bottom part
#define   D2D3_MBDG_STATUS_5                       (0x2b35)
#define P_D2D3_MBDG_STATUS_5                       (volatile uint32_t *)((0x2b35  << 2) + 0xff900000)
// Bit 31:21 Reserved
// Bit 20:0  RO, ro_mg_sum_l,    ACT(left): activities of the left part
#define   D2D3_MBDG_STATUS_6                       (0x2b36)
#define P_D2D3_MBDG_STATUS_6                       (volatile uint32_t *)((0x2b36  << 2) + 0xff900000)
// Bit 31:21 Reserved
// Bit 20:0  RO, ro_mg_sum_r,    ACT(right): activities of the right part
#define   D2D3_MBDG_STATUS_7                       (0x2b37)
#define P_D2D3_MBDG_STATUS_7                       (volatile uint32_t *)((0x2b37  << 2) + 0xff900000)
// Bit 31:0 dbg_handshake_ro0,   handshake signal for debug, internal srdy and rrdy
#define   D2D3_DBG_STATUS_1                        (0x2b38)
#define P_D2D3_DBG_STATUS_1                        (volatile uint32_t *)((0x2b38  << 2) + 0xff900000)
// Bit 31:0 dbg_hscnt,           dbg_hscnt_sel == 4'h0, output lg hscnt
//                               dbg_hscnt_sel == 4'h1, output cg hscnt
//                               dbg_hscnt_sel == 4'h2, output mg hscnt
//                               dbg_hscnt_sel == 4'h3, output bld hscnt
//                               dbg_hscnt_sel == other value, output 32'h0
#define   D2D3_DBG_STATUS_2                        (0x2b39)
#define P_D2D3_DBG_STATUS_2                        (volatile uint32_t *)((0x2b39  << 2) + 0xff900000)
// Bit 31:0 RO, drmif_status,    drmif module internal status
#define   D2D3_DRMIF_STATUS                        (0x2b3a)
#define P_D2D3_DRMIF_STATUS                        (volatile uint32_t *)((0x2b3a  << 2) + 0xff900000)
// Bit 31:2 RO, Reserved
// Bit 1:0  RO, d2d3_status0,    [1]: depw_done, one field depth write to ddr has done
//                               [0]: dwmif_pending_ddr_wrrsp, 1 to indicate write response from ddr
#define   D2D3_DWMIF_STATUS                        (0x2b3b)
#define P_D2D3_DWMIF_STATUS                        (volatile uint32_t *)((0x2b3b  << 2) + 0xff900000)
// Bit 31:24 Reserved
// Bit 23:0  RO, ro_meet_sum,    register sumxy_sum_dbg in CBDG
#define   D2D3_CBDG_STATUS_2                       (0x2b3c)
#define P_D2D3_CBDG_STATUS_2                       (volatile uint32_t *)((0x2b3c  << 2) + 0xff900000)
// Bit 31:20 Reserved
// Bit 19:0  RO, ro_hist_depth,
#define   D2D3_DBLD_STATUS                         (0x2b3d)
#define P_D2D3_DBLD_STATUS                         (volatile uint32_t *)((0x2b3d  << 2) + 0xff900000)
// Bit 31:0 Reserved
#define   D2D3_RESEV_STATUS1                       (0x2b3e)
#define P_D2D3_RESEV_STATUS1                       (volatile uint32_t *)((0x2b3e  << 2) + 0xff900000)
// Bit 31:0  Reserved
#define   D2D3_RESEV_STATUS2                       (0x2b3f)
#define P_D2D3_RESEV_STATUS2                       (volatile uint32_t *)((0x2b3f  << 2) + 0xff900000)
//
// Closing file:  d2d3_regs.h
//
//========================================================================
//  MIPI DSI Host Controller        (16'h2c00 - 16'h2cff)
//
//========================================================================
//`define  DSI_VCBUS_BASE             8'h2c
//`include "dsi_regs.h"
//========================================================================
//  ISP register    (16'h2d00 - 16'h2dff)
//========================================================================
//`define ISP_VCBUS_BASE                   8'h2d
//`include "isp_reg.h"
//`define MADB_VCBUS_BASE                8'h2d
//
// Reading file:  dnr_regs.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// CBUS_BASE:  MADB_VCBUS_BASE = 0x2d
// -----------------------------------------------
#define   DNR_CTRL                                 (0x2d00)
#define P_DNR_CTRL                                 (volatile uint32_t *)((0x2d00  << 2) + 0xff900000)
//Bit 31:17,        reserved
//Bit 16,            reg_dnr_en                                     , dnr enable                  . unsigned  , default = 1
//Bit 15,            reg_dnr_db_vdbstep                          , vdb step, 0: 4, 1: 8        . unsigned  , default = 1
//Bit 14,            reg_dnr_db_vdbprten                         , vdb protection enable       . unsigned  , default = 1
//Bit 13,            reg_dnr_gbs_difen                           , enable dif (between LR and LL/RR) condition for gbs stat.. unsigned  , default = 0
//Bit 12,            reg_dnr_luma_en                             , enable ycbcr2luma module    . unsigned  , default = 1
//Bit 11:10,        reg_dnr_db_mod                              , deblocking mode, 0: disable, 1: horizontal deblocking, 2: vertical deblocking, 3: horizontal & vertical deblocking. unsigned  , default = 3
//Bit  9,            reg_dnr_db_chrmen                           , enable chroma deblocking    . unsigned  , default = 1
//Bit  8,            reg_dnr_hvdif_mod                           , 0: calc. difs by original Y, 1: by new luma. unsigned  , default = 1
//Bit  7,            reserved
//Bit  6: 4,        reg_dnr_demo_lften                          , b0: Y b1:U b2:V             . unsigned  , default = 7
//Bit  3,            reserved
//Bit  2: 0,        reg_dnr_demo_rgten                          , b0: Y b1:U b2:V             . unsigned  , default = 7
#define   DNR_HVSIZE                               (0x2d01)
#define P_DNR_HVSIZE                               (volatile uint32_t *)((0x2d01  << 2) + 0xff900000)
//Bit 31:29,        reserved
//Bit 28:16,        reg_dnr_hsize                               , hsize                       . unsigned  , default = 0
//Bit 15:13,        reserved
//Bit 12: 0,        reg_dnr_vsize                               , vsize                       . unsigned  , default = 0
#define   DNR_DBLK_BLANK_NUM                       (0x2d02)
#define P_DNR_DBLK_BLANK_NUM                       (volatile uint32_t *)((0x2d02  << 2) + 0xff900000)
//Bit 31:16,        reserved
//Bit 15: 8,        reg_dblk_hblank_num                         , deblock hor blank num       . unsigned  , default = 16
//Bit  7: 0,        reg_dblk_vblank_num                         , deblock ver blank num       . unsigned  , default = 45
#define   DNR_BLK_OFFST                            (0x2d03)
#define P_DNR_BLK_OFFST                            (volatile uint32_t *)((0x2d03  << 2) + 0xff900000)
//Bit 31: 7,        reserved
//Bit  6: 4,        reg_dnr_hbofst                              , horizontal block offset may provide by software calc.. unsigned  , default = 0
//Bit  3,            reserved
//Bit  2: 0,        reg_dnr_vbofst                              , vertical block offset may provide by software calc.. unsigned  , default = 0
#define   DNR_GBS                                  (0x2d04)
#define P_DNR_GBS                                  (volatile uint32_t *)((0x2d04  << 2) + 0xff900000)
//Bit 31: 2,        reserved
//Bit  1: 0,        reg_dnr_gbs                                 , global block strength may update by software calc.. unsigned  , default = 0
#define   DNR_HBOFFST_STAT                         (0x2d05)
#define P_DNR_HBOFFST_STAT                         (volatile uint32_t *)((0x2d05  << 2) + 0xff900000)
//Bit 31:24,        reg_dnr_hbof_difthd                         , dif threshold (>=) between LR and LL/RR. unsigned  , default = 2
//Bit 23:16,        reg_dnr_hbof_edgethd                        , edge threshold (<=) for LR  . unsigned  , default = 32
//Bit 15: 8,        reg_dnr_hbof_flatthd                        , flat threshold (>=) for LR  . unsigned  , default = 0
//Bit  7,            reserved
//Bit  6: 4,        reg_dnr_hbof_delta                          , delta for weighted bin accumulator. unsigned  , default = 1
//Bit  3,            reserved
//Bit  2: 0,        reg_dnr_hbof_statmod                        , statistic mode for horizontal block offset, 0: count flags for 8-bin, 1: count LRs for 8-bin, 2: count difs for 8-bin, 3: count weighted flags for 8-bin, 4: count flags for first 32-bin, 5: count LRs for first 32-bin, 6 or 7: count difs for first 32-bin. unsigned  , default = 2
#define   DNR_VBOFFST_STAT                         (0x2d06)
#define P_DNR_VBOFFST_STAT                         (volatile uint32_t *)((0x2d06  << 2) + 0xff900000)
//Bit 31:24,        reg_dnr_vbof_difthd                         , dif threshold (>=) between Up and Dw. unsigned  , default = 1
//Bit 23:16,        reg_dnr_vbof_edgethd                        , edge threshold (<=) for Up/Dw. unsigned  , default = 16
//Bit 15: 8,        reg_dnr_vbof_flatthd                        , flat threshold (>=) for Up/Dw. unsigned  , default = 0
//Bit  7,            reserved
//Bit  6: 4,        reg_dnr_vbof_delta                          , delta for weighted bin accumulator. unsigned  , default = 1
//Bit  3,            reserved
//Bit  2: 0,        reg_dnr_vbof_statmod                        , statistic mode for vertical block offset, 0: count flags for 8-bin, 1: count Ups for 8-bin, 2: count difs for 8-bin, 3: count weighted flags for 8-bin, 4: count flags for first 32-bin, 5: count Ups for first 32-bin, 6 or 7: count difs for first 32-bin. unsigned  , default = 2
#define   DNR_GBS_STAT                             (0x2d07)
#define P_DNR_GBS_STAT                             (volatile uint32_t *)((0x2d07  << 2) + 0xff900000)
//Bit 31:24,        reg_dnr_gbs_edgethd                         , edge threshold (<=) for LR  . unsigned  , default = 32
//Bit 23:16,        reg_dnr_gbs_flatthd                         , flat threshold (>=) for LR  . unsigned  , default = 0
//Bit 15: 8,        reg_dnr_gbs_varthd                          , variation threshold (<=) for Lvar/Rvar. unsigned  , default = 16
//Bit  7: 0,        reg_dnr_gbs_difthd                          , dif threshold (>=) between LR and LL/RR. unsigned  , default = 2
#define   DNR_STAT_X_START_END                     (0x2d08)
#define P_DNR_STAT_X_START_END                     (volatile uint32_t *)((0x2d08  << 2) + 0xff900000)
//Bit 31:30,        reserved
//Bit 29:16,        reg_dnr_stat_xst                                                          . unsigned  , default = 24
//Bit 15:14,        reserved
//Bit 13: 0,        reg_dnr_stat_xed                                                          . unsigned  , default = HSIZE - 25
#define   DNR_STAT_Y_START_END                     (0x2d09)
#define P_DNR_STAT_Y_START_END                     (volatile uint32_t *)((0x2d09  << 2) + 0xff900000)
//Bit 31:30,        reserved
//Bit 29:16,        reg_dnr_stat_yst                                                          . unsigned  , default = 24
//Bit 15:14,        reserved
//Bit 13: 0,        reg_dnr_stat_yed                                                          . unsigned  , default = VSIZE - 25
#define   DNR_LUMA                                 (0x2d0a)
#define P_DNR_LUMA                                 (volatile uint32_t *)((0x2d0a  << 2) + 0xff900000)
//Bit 31:27,        reserved
//Bit 26:24,        reg_dnr_luma_sqrtshft                       , left shift for fast squart of chroma, [0, 4]. unsigned  , default = 2
//Bit 23:21,        reserved
//Bit 20:16,        reg_dnr_luma_sqrtoffst                      , offset for fast squart of chroma. signed    , default = 0
//Bit 15,            reserved
//Bit 14:12,        reg_dnr_luma_wcmod                          , theta related to warm/cool segment line, 0: 0, 1: 45, 2: 90, 3: 135, 4: 180, 5: 225, 6: 270, 7: 315. . unsigned  , default = 3
//Bit 11: 8,        reg_dnr_luma_cshft                          , shift for calc. delta part, 0~8,  . unsigned  , default = 8
//Bit  7: 6,        reserved
//Bit  5: 0,        reg_dnr_luma_cgain                          , final gain for delta part, 32 normalized to "1". unsigned  , default = 4
#define   DNR_DB_YEDGE_THD                         (0x2d0b)
#define P_DNR_DB_YEDGE_THD                         (volatile uint32_t *)((0x2d0b  << 2) + 0xff900000)
//Bit 31:24,        reg_dnr_db_yedgethd0                        , edge threshold0 for luma    . unsigned  , default = 12
//Bit 23:16,        reg_dnr_db_yedgethd1                        , edge threshold1 for luma    . unsigned  , default = 15
//Bit 15: 8,        reg_dnr_db_yedgethd2                        , edge threshold2 for luma    . unsigned  , default = 18
//Bit  7: 0,        reg_dnr_db_yedgethd3                        , edge threshold3 for luma    . unsigned  , default = 25
#define   DNR_DB_CEDGE_THD                         (0x2d0c)
#define P_DNR_DB_CEDGE_THD                         (volatile uint32_t *)((0x2d0c  << 2) + 0xff900000)
//Bit 31:24,        reg_dnr_db_cedgethd0                        , edge threshold0 for chroma  . unsigned  , default = 12
//Bit 23:16,        reg_dnr_db_cedgethd1                        , edge threshold1 for chroma  . unsigned  , default = 15
//Bit 15: 8,        reg_dnr_db_cedgethd2                        , edge threshold2 for chroma  . unsigned  , default = 18
//Bit  7: 0,        reg_dnr_db_cedgethd3                        , edge threshold3 for chroma  . unsigned  , default = 25
#define   DNR_DB_HGAP                              (0x2d0d)
#define P_DNR_DB_HGAP                              (volatile uint32_t *)((0x2d0d  << 2) + 0xff900000)
//Bit 31:24,        reserved
//Bit 23:16,        reg_dnr_db_hgapthd                          , horizontal gap thd (<=) for very sure blockiness . unsigned  , default = 8
//Bit 15: 8,        reg_dnr_db_hgapdifthd                       , dif thd between hgap and lft/rgt hdifs. unsigned  , default = 1
//Bit  7: 1,        reserved
//Bit  0,            reg_dnr_db_hgapmod                          , horizontal gap calc. mode, 0: just use current col x, 1: find max between (x-1, x, x+1) . unsigned  , default = 0
#define   DNR_DB_HBS                               (0x2d0e)
#define P_DNR_DB_HBS                               (volatile uint32_t *)((0x2d0e  << 2) + 0xff900000)
//Bit 31: 6,        reserved
//Bit  5: 4,        reg_dnr_db_hbsup                            , horizontal bs up value      . unsigned  , default = 1
//Bit  3: 2,        reg_dnr_db_hbsmax                           , max value of hbs for global control. unsigned  , default = 3
//Bit  1: 0,        reg_dnr_db_hgbsthd                          , gbs thd (>=) for hbs calc.  . unsigned  , default = 1
#define   DNR_DB_HACT                              (0x2d0f)
#define P_DNR_DB_HACT                              (volatile uint32_t *)((0x2d0f  << 2) + 0xff900000)
//Bit 31:16,        reserved
//Bit 15: 8,        reg_dnr_db_hactthd0                         , thd0 of hact, for block classification. unsigned  , default = 10
//Bit  7: 0,        reg_dnr_db_hactthd1                         , thd1 of hact, for block classification. unsigned  , default = 32
#define   DNR_DB_YHDELTA_GAIN                      (0x2d10)
#define P_DNR_DB_YHDELTA_GAIN                      (volatile uint32_t *)((0x2d10  << 2) + 0xff900000)
//Bit 31:27,        reserved
//Bit 26:24,        reg_dnr_db_yhdeltagain1                     , (p1-q1) gain for Y's delta calc. when bs=1, normalized 8 as "1" . unsigned  , default = 2
//Bit 23,            reserved
//Bit 22:20,        reg_dnr_db_yhdeltagain2                     , (p1-q1) gain for Y's delta calc. when bs=2, normalized 8 as "1" . unsigned  , default = 0
//Bit 19,            reserved
//Bit 18:16,        reg_dnr_db_yhdeltagain3                     , (p1-q1) gain for Y's delta calc. when bs=3, normalized 8 as "1" . unsigned  , default = 0
//Bit 15,            reserved
//Bit 14: 8,        reg_dnr_db_yhdeltaadjoffst                  , offset for adjust Y's hdelta (-64, 63). signed    , default = 0
//Bit  7: 6,        reserved
//Bit  5: 0,        reg_dnr_db_yhdeltaadjgain                   , gain for adjust Y's hdelta, normalized 32 as "1" . unsigned  , default = 32
#define   DNR_DB_YHDELTA2_GAIN                     (0x2d11)
#define P_DNR_DB_YHDELTA2_GAIN                     (volatile uint32_t *)((0x2d11  << 2) + 0xff900000)
//Bit 31:30,        reserved
//Bit 29:24,        reg_dnr_db_yhdelta2gain2                    , gain for bs=2's adjust Y's hdelta2, normalized 64 as "1" . unsigned  , default = 8
//Bit 23:21,        reserved
//Bit 20:16,        reg_dnr_db_yhdelta2offst2                   , offset for bs=2's adjust Y's hdelta2 (-16, 15). signed    , default = 0
//Bit 15:14,        reserved
//Bit 13: 8,        reg_dnr_db_yhdelta2gain3                    , gain for bs=3's adjust Y's hdelta2, normalized 64 as "1" . unsigned  , default = 4
//Bit  7: 5,        reserved
//Bit  4: 0,        reg_dnr_db_yhdelta2offst3                   , offset for bs=3's adjust Y's hdelta2 (-16, 15). signed    , default = 0
#define   DNR_DB_CHDELTA_GAIN                      (0x2d12)
#define P_DNR_DB_CHDELTA_GAIN                      (volatile uint32_t *)((0x2d12  << 2) + 0xff900000)
//Bit 31:27,        reserved
//Bit 26:24,        reg_dnr_db_chdeltagain1                     , (p1-q1) gain for UV's delta calc. when bs=1, normalized 8 as "1". unsigned  , default = 2
//Bit 23,            reserved
//Bit 22:20,        reg_dnr_db_chdeltagain2                     , (p1-q1) gain for UV's delta calc. when bs=2, normalized 8 as "1". unsigned  , default = 0
//Bit 19,            reserved
//Bit 18:16,        reg_dnr_db_chdeltagain3                     , (p1-q1) gain for UV's delta calc. when bs=3, normalized 8 as "1". unsigned  , default = 0
//Bit 15,            reserved
//Bit 14: 8,        reg_dnr_db_chdeltaadjoffst                  , offset for adjust UV's hdelta (-64, 63). signed    , default = 0
//Bit  7: 6,        reserved
//Bit  5: 0,        reg_dnr_db_chdeltaadjgain                   , gain for adjust UV's hdelta, normalized 32 as "1". unsigned  , default = 32
#define   DNR_DB_CHDELTA2_GAIN                     (0x2d13)
#define P_DNR_DB_CHDELTA2_GAIN                     (volatile uint32_t *)((0x2d13  << 2) + 0xff900000)
//Bit 31:30,        reserved
//Bit 29:24,        reg_dnr_db_chdelta2gain2                    , gain for bs=2's adjust UV's hdelta2, normalized 64 as "1" . unsigned  , default = 8
//Bit 23:21,        reserved
//Bit 20:16,        reg_dnr_db_chdelta2offst2                   , offset for bs=2's adjust UV's hdelta2 (-16, 15). signed    , default = 0
//Bit 15:14,        reserved
//Bit 13: 8,        reg_dnr_db_chdelta2gain3                    , gain for bs=2's adjust UV's hdelta2, normalized 64 as "1" . unsigned  , default = 4
//Bit  7: 5,        reserved
//Bit  4: 0,        reg_dnr_db_chdelta2offst3                   , offset for bs=2's adjust UV's hdelta2 (-16, 15). signed    , default = 0
#define   DNR_DB_YC_VEDGE_THD                      (0x2d14)
#define P_DNR_DB_YC_VEDGE_THD                      (volatile uint32_t *)((0x2d14  << 2) + 0xff900000)
//Bit 31:16,        reserved
//Bit 15: 8,        reg_dnr_db_yvedgethd                        , special Y's edge thd for vdb. unsigned  , default = 12
//Bit  7: 0,        reg_dnr_db_cvedgethd                        , special UV's edge thd for vdb. unsigned  , default = 12
#define   DNR_DB_VBS_MISC                          (0x2d15)
#define P_DNR_DB_VBS_MISC                          (volatile uint32_t *)((0x2d15  << 2) + 0xff900000)
//Bit 31:24,        reg_dnr_db_vgapthd                          , vertical gap thd (<=) for very sure blockiness . unsigned  , default = 8
//Bit 23:16,        reg_dnr_db_vactthd                          , thd of vact, for block classification . unsigned  , default = 10
//Bit 15: 8,        reg_dnr_db_vgapdifthd                       , dif thd between vgap and vact. unsigned  , default = 4
//Bit  7: 4,        reserved
//Bit  3: 2,        reg_dnr_db_vbsmax                           , max value of vbs for global control. unsigned  , default = 2
//Bit  1: 0,        reg_dnr_db_vgbsthd                          , gbs thd (>=) for vbs calc.  . unsigned  , default = 1
#define   DNR_DB_YVDELTA_GAIN                      (0x2d16)
#define P_DNR_DB_YVDELTA_GAIN                      (volatile uint32_t *)((0x2d16  << 2) + 0xff900000)
//Bit 31:30,        reserved
//Bit 29:24,        reg_dnr_db_yvdeltaadjgain                   , gain for adjust Y's vdelta, normalized 32 as "1". unsigned  , default = 32
//Bit 23,            reserved
//Bit 22:16,        reg_dnr_db_yvdeltaadjoffst                  , offset for adjust Y's vdelta (-64, 63). signed    , default = 0
//Bit 15:14,        reserved
//Bit 13: 8,        reg_dnr_db_yvdelta2gain                     , 