/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * drivers/display/lcd/aml_lcd_unifykey.h
 *
 * Copyright (C) 2020 Amlogic, Inc. All rights reserved.
 *
 */

#ifndef __AML_LCD_UNIFYKEY_H__
#define __AML_LCD_UNIFYKEY_H__
#include <amlogic/aml_lcd_tcon_data.h>

#define LCD_UKEY_RETRY_CNT_MAX   5

/*
  lcd unifykey data struct: little-endian, for example:
    4byte: d[0]=0x01, d[1]=0x02, d[2] = 0x03, d[3]= 0x04,
           data = 0x04030201
 */

/* define lcd unifykey length */

#define LCD_UKEY_HEAD_SIZE        10
#define LCD_UKEY_HEAD_CRC32       4
#define LCD_UKEY_HEAD_DATA_LEN    2
#define LCD_UKEY_HEAD_VERSION     2
#define LCD_UKEY_HEAD_RESERVED    2

struct aml_lcd_unifykey_header_s {
	unsigned int crc32;
	unsigned short data_len;
	unsigned char version;
	unsigned char block_next_flag;
	unsigned short block_cur_size;
};

/* ********************************
 * lcd
 * ********************************* */
/* V1: 265 */
/* V2: 424 */
#define LCD_UKEY_LCD_SIZE          700 //265+424

/* header (10Byte) */
/* LCD_UKEY_HEAD_SIZE */
/* basic (36Byte) */
#define LCD_UKEY_MODEL_NAME        (LCD_UKEY_HEAD_SIZE + 0)
#define LCD_UKEY_INTERFACE         (LCD_UKEY_MODEL_NAME + 30)
#define LCD_UKEY_LCD_BITS          (LCD_UKEY_MODEL_NAME + 31)
#define LCD_UKEY_SCREEN_WIDTH      (LCD_UKEY_MODEL_NAME + 32)
#define LCD_UKEY_SCREEN_HEIGHT     (LCD_UKEY_MODEL_NAME + 34)
/* timing (18Byte) */
#define LCD_UKEY_H_ACTIVE          (LCD_UKEY_MODEL_NAME + 36)/* +36 byte */
#define LCD_UKEY_V_ACTIVE          (LCD_UKEY_MODEL_NAME + 38)
#define LCD_UKEY_H_PERIOD          (LCD_UKEY_MODEL_NAME + 40)
#define LCD_UKEY_V_PERIOD          (LCD_UKEY_MODEL_NAME + 42)
#define LCD_UKEY_HS_WIDTH          (LCD_UKEY_MODEL_NAME + 44)
#define LCD_UKEY_HS_BP             (LCD_UKEY_MODEL_NAME + 46)
#define LCD_UKEY_HS_POL            (LCD_UKEY_MODEL_NAME + 48)
#define LCD_UKEY_VS_WIDTH          (LCD_UKEY_MODEL_NAME + 49)
#define LCD_UKEY_VS_BP             (LCD_UKEY_MODEL_NAME + 51)
#define LCD_UKEY_VS_POL            (LCD_UKEY_MODEL_NAME + 53)
/* customer (31Byte) */
#define LCD_UKEY_FR_ADJ_TYPE       (LCD_UKEY_MODEL_NAME + 54)/* +36+18 byte */
#define LCD_UKEY_SS_LEVEL          (LCD_UKEY_MODEL_NAME + 55)
#define LCD_UKEY_CLK_AUTO_GEN      (LCD_UKEY_MODEL_NAME + 56)
#define LCD_UKEY_PCLK              (LCD_UKEY_MODEL_NAME + 57)
#define LCD_UKEY_H_PERIOD_MIN      (LCD_UKEY_MODEL_NAME + 61)
#define LCD_UKEY_H_PERIOD_MAX      (LCD_UKEY_MODEL_NAME + 63)
#define LCD_UKEY_V_PERIOD_MIN      (LCD_UKEY_MODEL_NAME + 65)
#define LCD_UKEY_V_PERIOD_MAX      (LCD_UKEY_MODEL_NAME + 67)
#define LCD_UKEY_PCLK_MIN          (LCD_UKEY_MODEL_NAME + 69)
#define LCD_UKEY_PCLK_MAX          (LCD_UKEY_MODEL_NAME + 73)
#define LCD_UKEY_VLOCK_VAL_0       (LCD_UKEY_MODEL_NAME + 77)
#define LCD_UKEY_VLOCK_VAL_1       (LCD_UKEY_MODEL_NAME + 78)
#define LCD_UKEY_VLOCK_VAL_2       (LCD_UKEY_MODEL_NAME + 79)
#define LCD_UKEY_VLOCK_VAL_3       (LCD_UKEY_MODEL_NAME + 80)
#define LCD_UKEY_CUST_PINMUX       (LCD_UKEY_MODEL_NAME + 81)
#define LCD_UKEY_FR_AUTO_DIS       (LCD_UKEY_MODEL_NAME + 82)
#define LCD_UKEY_FRAME_RATE_MIN    (LCD_UKEY_MODEL_NAME + 83)
#define LCD_UKEY_FRAME_RATE_MAX    (LCD_UKEY_MODEL_NAME + 84)

/* interface (20Byte) */
#define LCD_UKEY_IF_ATTR_0         (LCD_UKEY_MODEL_NAME + 85)/* +36+18+31 byte */
#define LCD_UKEY_IF_ATTR_1         (LCD_UKEY_MODEL_NAME + 87)
#define LCD_UKEY_IF_ATTR_2         (LCD_UKEY_MODEL_NAME + 89)
#define LCD_UKEY_IF_ATTR_3         (LCD_UKEY_MODEL_NAME + 91)
#define LCD_UKEY_IF_ATTR_4         (LCD_UKEY_MODEL_NAME + 93)
#define LCD_UKEY_IF_ATTR_5         (LCD_UKEY_MODEL_NAME + 95)
#define LCD_UKEY_IF_ATTR_6         (LCD_UKEY_MODEL_NAME + 97)
#define LCD_UKEY_IF_ATTR_7         (LCD_UKEY_MODEL_NAME + 99)
#define LCD_UKEY_IF_ATTR_8         (LCD_UKEY_MODEL_NAME + 101)
#define LCD_UKEY_IF_ATTR_9         (LCD_UKEY_MODEL_NAME + 103)

/* version 1 */
#define LCD_UKEY_DATA_LEN_V1       (LCD_UKEY_MODEL_NAME + 105)

/* power (5Byte * n) */
/* v1/v2  p + offsite*/
/* 10+36+18+31+20 byte */
/* 10+36+18+31+20+44+10 byte */
#define LCD_UKEY_PWR_STEP          (LCD_UKEY_MODEL_NAME + 105)
#define LCD_UKEY_PWR_TYPE          (0)
#define LCD_UKEY_PWR_INDEX         (1)
#define LCD_UKEY_PWR_VAL           (2)
#define LCD_UKEY_PWR_DELAY         (3)

/* version 2 */
#define LCD_UKEY_DATA_LEN_V2        424

/* header (10Byte) */
/* LCD_UKEY_HEAD_SIZE */
/* phy (356Byte) */
#define LCD_UKEY_PHY_ATTR_FLAG          (LCD_UKEY_HEAD_SIZE + 0)
#define LCD_UKEY_PHY_ATTR_0             (LCD_UKEY_HEAD_SIZE + 4)
#define LCD_UKEY_PHY_ATTR_1             (LCD_UKEY_HEAD_SIZE + 6)
#define LCD_UKEY_PHY_ATTR_2             (LCD_UKEY_HEAD_SIZE + 8)
#define LCD_UKEY_PHY_ATTR_3             (LCD_UKEY_HEAD_SIZE + 10)
#define LCD_UKEY_PHY_ATTR_4             (LCD_UKEY_HEAD_SIZE + 12)
#define LCD_UKEY_PHY_ATTR_5             (LCD_UKEY_HEAD_SIZE + 14)
#define LCD_UKEY_PHY_ATTR_6             (LCD_UKEY_HEAD_SIZE + 16)
#define LCD_UKEY_PHY_ATTR_7             (LCD_UKEY_HEAD_SIZE + 18)
#define LCD_UKEY_PHY_ATTR_8             (LCD_UKEY_HEAD_SIZE + 20)
#define LCD_UKEY_PHY_ATTR_9             (LCD_UKEY_HEAD_SIZE + 22)
#define LCD_UKEY_PHY_ATTR_10            (LCD_UKEY_HEAD_SIZE + 24)
#define LCD_UKEY_PHY_ATTR_11            (LCD_UKEY_HEAD_SIZE + 26)
#define LCD_UKEY_PHY_LANE_CTRL          (LCD_UKEY_HEAD_SIZE + 28)//64*4
#define LCD_UKEY_PHY_LANE_PN_SWAP       (LCD_UKEY_HEAD_SIZE + 284)//8
#define LCD_UKEY_PHY_LANE_SWAP          (LCD_UKEY_HEAD_SIZE + 292)//64
/* custom ctrl (76Byte) */
#define LCD_UKEY_CUS_CTRL_ATTR_FLAG     (LCD_UKEY_HEAD_SIZE + 356)
#define LCD_UKEY_CUS_CTRL_ATTR_0        (LCD_UKEY_HEAD_SIZE + 360)
#define LCD_UKEY_CUS_CTRL_END           (LCD_UKEY_HEAD_SIZE + 424)
//#define LCD_UKEY_CUS_CTRL_END           (LCD_UKEY_HEAD_SIZE + 432)

/* ********************************
 * lcd extern
 * ********************************* */
#define LCD_UKEY_LCD_EXT_SIZE       3150

/* header (10Byte) */
/* LCD_UKEY_HEAD_SIZE */
/* basic (33Byte) */
#define LCD_UKEY_EXT_NAME           (LCD_UKEY_HEAD_SIZE + 0)
#define LCD_UKEY_EXT_INDEX          (LCD_UKEY_EXT_NAME + 30)
#define LCD_UKEY_EXT_TYPE           (LCD_UKEY_EXT_NAME + 31)
#define LCD_UKEY_EXT_STATUS         (LCD_UKEY_EXT_NAME + 32)
/* type (10Byte) */
#define LCD_UKEY_EXT_TYPE_VAL_0     (LCD_UKEY_EXT_NAME + 33)/* +33 byte */
#define LCD_UKEY_EXT_TYPE_VAL_1     (LCD_UKEY_EXT_NAME + 34)
#define LCD_UKEY_EXT_TYPE_VAL_2     (LCD_UKEY_EXT_NAME + 35)
#define LCD_UKEY_EXT_TYPE_VAL_3     (LCD_UKEY_EXT_NAME + 36)
#define LCD_UKEY_EXT_TYPE_VAL_4     (LCD_UKEY_EXT_NAME + 37)
#define LCD_UKEY_EXT_TYPE_VAL_5     (LCD_UKEY_EXT_NAME + 38)
#define LCD_UKEY_EXT_TYPE_VAL_6     (LCD_UKEY_EXT_NAME + 39)
#define LCD_UKEY_EXT_TYPE_VAL_7     (LCD_UKEY_EXT_NAME + 40)
#define LCD_UKEY_EXT_TYPE_VAL_8     (LCD_UKEY_EXT_NAME + 41)
#define LCD_UKEY_EXT_TYPE_VAL_9     (LCD_UKEY_EXT_NAME + 42)
/* init (cmd_size) */
#define LCD_UKEY_EXT_INIT           (LCD_UKEY_EXT_NAME + 43)/* +33+10 byte */
/*#define LCD_UKEY_EXT_INIT_TYPE      (0)*/
/*#define LCD_UKEY_EXT_INIT_VAL       (1)*/
/*#define LCD_UKEY_EXT_INIT_DELAY     (n)*/


/* ********************************
 * backlight
 * ********************************* */
/* V1: 92 */
/* V2: 118 */
#define LCD_UKEY_BL_SIZE            118

/* header (10Byte) */
/* LCD_UKEY_HEAD_SIZE */
/* basic (30Byte) */
#define LCD_UKEY_BL_NAME            (LCD_UKEY_HEAD_SIZE + 0)
/* level (12Byte) */
#define LCD_UKEY_BL_LEVEL_UBOOT     (LCD_UKEY_BL_NAME + 30)/* +30 byte */
#define LCD_UKEY_BL_LEVEL_KERNEL    (LCD_UKEY_BL_NAME + 32)
#define LCD_UKEY_BL_LEVEL_MAX       (LCD_UKEY_BL_NAME + 34)
#define LCD_UKEY_BL_LEVEL_MIN       (LCD_UKEY_BL_NAME + 36)
#define LCD_UKEY_BL_LEVEL_MID       (LCD_UKEY_BL_NAME + 38)
#define LCD_UKEY_BL_LEVEL_MID_MAP   (LCD_UKEY_BL_NAME + 40)
/* method (8Byte) */
#define LCD_UKEY_BL_METHOD          (LCD_UKEY_BL_NAME + 42)/* +30+12 byte */
#define LCD_UKEY_BL_EN_GPIO         (LCD_UKEY_BL_NAME + 43)
#define LCD_UKEY_BL_EN_GPIO_ON      (LCD_UKEY_BL_NAME + 44)
#define LCD_UKEY_BL_EN_GPIO_OFF     (LCD_UKEY_BL_NAME + 45)
#define LCD_UKEY_BL_ON_DELAY        (LCD_UKEY_BL_NAME + 46)
#define LCD_UKEY_BL_OFF_DELAY       (LCD_UKEY_BL_NAME + 48)
/* pwm (32Byte) */
#define LCD_UKEY_BL_PWM_ON_DELAY    (LCD_UKEY_BL_NAME + 50)/* +30+12+8 byte */
#define LCD_UKEY_BL_PWM_OFF_DELAY   (LCD_UKEY_BL_NAME + 52)
#define LCD_UKEY_BL_PWM_METHOD      (LCD_UKEY_BL_NAME + 54)
#define LCD_UKEY_BL_PWM_PORT        (LCD_UKEY_BL_NAME + 55)
#define LCD_UKEY_BL_PWM_FREQ        (LCD_UKEY_BL_NAME + 56)
#define LCD_UKEY_BL_PWM_DUTY_MAX    (LCD_UKEY_BL_NAME + 60)
#define LCD_UKEY_BL_PWM_DUTY_MIN    (LCD_UKEY_BL_NAME + 61)
#define LCD_UKEY_BL_PWM_GPIO        (LCD_UKEY_BL_NAME + 62)
#define LCD_UKEY_BL_PWM_GPIO_OFF    (LCD_UKEY_BL_NAME + 63)
#define LCD_UKEY_BL_PWM2_METHOD     (LCD_UKEY_BL_NAME + 64)
#define LCD_UKEY_BL_PWM2_PORT       (LCD_UKEY_BL_NAME + 65)
#define LCD_UKEY_BL_PWM2_FREQ       (LCD_UKEY_BL_NAME + 66)
#define LCD_UKEY_BL_PWM2_DUTY_MAX   (LCD_UKEY_BL_NAME + 70)
#define LCD_UKEY_BL_PWM2_DUTY_MIN   (LCD_UKEY_BL_NAME + 71)
#define LCD_UKEY_BL_PWM2_GPIO       (LCD_UKEY_BL_NAME + 72)
#define LCD_UKEY_BL_PWM2_GPIO_OFF   (LCD_UKEY_BL_NAME + 73)
#define LCD_UKEY_BL_PWM_LEVEL_MAX   (LCD_UKEY_BL_NAME + 74)
#define LCD_UKEY_BL_PWM_LEVEL_MIN   (LCD_UKEY_BL_NAME + 76)
#define LCD_UKEY_BL_PWM2_LEVEL_MAX  (LCD_UKEY_BL_NAME + 78)
#define LCD_UKEY_BL_PWM2_LEVEL_MIN  (LCD_UKEY_BL_NAME + 80)
/* local dimming (16Byte) */ /* V2 */
#define LCD_UKEY_BL_LDIM_ROW        (LCD_UKEY_BL_NAME + 82)/* +30+12+8+32 byte */
#define LCD_UKEY_BL_LDIM_COL        (LCD_UKEY_BL_NAME + 83)
#define LCD_UKEY_BL_LDIM_MODE       (LCD_UKEY_BL_NAME + 84)
#define LCD_UKEY_BL_LDIM_DEV_INDEX  (LCD_UKEY_BL_NAME + 85)
#define LCD_UKEY_BL_LDIM_ATTR_4     (LCD_UKEY_BL_NAME + 86)
#define LCD_UKEY_BL_LDIM_ATTR_5     (LCD_UKEY_BL_NAME + 88)
#define LCD_UKEY_BL_LDIM_ATTR_6     (LCD_UKEY_BL_NAME + 90)
#define LCD_UKEY_BL_LDIM_ATTR_7     (LCD_UKEY_BL_NAME + 92)
#define LCD_UKEY_BL_LDIM_ATTR_8     (LCD_UKEY_BL_NAME + 94)
#define LCD_UKEY_BL_LDIM_ATTR_9     (LCD_UKEY_BL_NAME + 96)
/* customer(10Byte) */ /* V2 */
#define LCD_UKEY_BL_CUST_VAL_0      (LCD_UKEY_BL_NAME + 98)/* +30+12+8+32+16 byte */
#define LCD_UKEY_BL_CUST_VAL_1      (LCD_UKEY_BL_NAME + 100)
#define LCD_UKEY_BL_CUST_VAL_2      (LCD_UKEY_BL_NAME + 102)
#define LCD_UKEY_BL_CUST_VAL_3      (LCD_UKEY_BL_NAME + 104)
#define LCD_UKEY_BL_CUST_VAL_4      (LCD_UKEY_BL_NAME + 106)

/* ********************************
 * tcon
 * ********************************* */
#define LCD_UKEY_TCON_SIZE          4096
#define LCD_UKEY_TCON_SIZE_NEW      24000

#define LCD_UKEY_TCON_SPI_SIZE      1552  /* 16+48*32 */

#define LCD_UKEY_TCON_SPI_HEAD_SIZE               16
#define LCD_UKEY_TCON_SPI_HEAD_CRC32              4
#define LCD_UKEY_TCON_SPI_HEAD_DATA_LEN           4
#define LCD_UKEY_TCON_SPI_HEAD_VERSION            2
#define LCD_UKEY_TCON_SPI_HEAD_DATA_LOAD_LEVEL    2
#define LCD_UKEY_TCON_SPI_HEAD_BLOCK_CNT          2

#define LCD_UKEY_TCON_SPI_BLOCK_CNT_MAX           32

struct aml_lcd_tcon_spi_unifykey_header_s {
	unsigned int crc32;
	unsigned int data_size;
	unsigned short version;
	unsigned short load_level;
	unsigned short reserved;
	unsigned short block_cnt;
};

/* ********************************
 * lcd optical
 * *********************************
 */
#define LCD_UKEY_OPTICAL_SIZE              102 /*10 + 52 + 40*/

/* header (10Byte) */
/* LCD_UKEY_HEAD_SIZE */
/* attr (52Byte) */
#define LCD_UKEY_OPT_HDR_SUPPORT           (LCD_UKEY_HEAD_SIZE + 0)
#define LCD_UKEY_OPT_FEATURES              (LCD_UKEY_OPT_HDR_SUPPORT + 4)
#define LCD_UKEY_OPT_PRI_R_X               (LCD_UKEY_OPT_HDR_SUPPORT + 8)
#define LCD_UKEY_OPT_PRI_R_Y               (LCD_UKEY_OPT_HDR_SUPPORT + 12)
#define LCD_UKEY_OPT_PRI_G_X               (LCD_UKEY_OPT_HDR_SUPPORT + 16)
#define LCD_UKEY_OPT_PRI_G_Y               (LCD_UKEY_OPT_HDR_SUPPORT + 20)
#define LCD_UKEY_OPT_PRI_B_X               (LCD_UKEY_OPT_HDR_SUPPORT + 24)
#define LCD_UKEY_OPT_PRI_B_Y               (LCD_UKEY_OPT_HDR_SUPPORT + 28)
#define LCD_UKEY_OPT_WHITE_X               (LCD_UKEY_OPT_HDR_SUPPORT + 32)
#define LCD_UKEY_OPT_WHITE_Y               (LCD_UKEY_OPT_HDR_SUPPORT + 36)
#define LCD_UKEY_OPT_LUMA_MAX              (LCD_UKEY_OPT_HDR_SUPPORT + 40)
#define LCD_UKEY_OPT_LUMA_MIN              (LCD_UKEY_OPT_HDR_SUPPORT + 44)
#define LCD_UKEY_OPT_LUMA_AVG              (LCD_UKEY_OPT_HDR_SUPPORT + 48)
/* adv (40Byte) */
#define LCD_UKEY_OPT_ADV_VAL0              (LCD_UKEY_OPT_HDR_SUPPORT + 52)
#define LCD_UKEY_OPT_ADV_VAL1              (LCD_UKEY_OPT_HDR_SUPPORT + 56)
#define LCD_UKEY_OPT_ADV_VAL2              (LCD_UKEY_OPT_HDR_SUPPORT + 60)
#define LCD_UKEY_OPT_ADV_VAL3              (LCD_UKEY_OPT_HDR_SUPPORT + 64)
#define LCD_UKEY_OPT_ADV_VAL4              (LCD_UKEY_OPT_HDR_SUPPORT + 68)
#define LCD_UKEY_OPT_ADV_VAL5              (LCD_UKEY_OPT_HDR_SUPPORT + 72)
#define LCD_UKEY_OPT_ADV_VAL6              (LCD_UKEY_OPT_HDR_SUPPORT + 76)
#define LCD_UKEY_OPT_ADV_VAL7              (LCD_UKEY_OPT_HDR_SUPPORT + 80)
#define LCD_UKEY_OPT_ADV_VAL8              (LCD_UKEY_OPT_HDR_SUPPORT + 84)
#define LCD_UKEY_OPT_ADV_VAL9              (LCD_UKEY_OPT_HDR_SUPPORT + 88)

/* ********************************
 * debug flag
 * ********************************* */
#define LCD_UKEY_DEBUG_TCON_LEN_MASK   (0xffffff)
#define LCD_UKEY_DEBUG_NORMAL          (1 << 24)
#define LCD_UKEY_DEBUG_TCON            (1 << 25)

/* ********************************
 * API
 * ********************************* */
int aml_lcd_unifykey_len_check(int key_len, int len);
int aml_lcd_unifykey_header_check(unsigned char *buf,
				  struct aml_lcd_unifykey_header_s *header);
int aml_lcd_unifykey_check_exist(const char *key_name);
int aml_lcd_unifykey_check(const char *key_name);
int aml_lcd_unifykey_get(const char *key_name, unsigned char *buf, int *len);
int aml_lcd_unifykey_get_tcon(const char *key_name, unsigned char *buf, int *len);
int aml_lcd_unifykey_check_no_header(const char *key_name);
int aml_lcd_unifykey_get_no_header(const char *key_name, unsigned char *buf, int *len);
int aml_lcd_unifykey_write(const char *key_name, unsigned char *buf, int len);

void aml_lcd_unifykey_test(void);
void aml_lcd_unifykey_tcon_test(int n);
void aml_lcd_unifykey_dump(unsigned int flag);

#endif
