/*
* Copyright (c) 2014 Amlogic, Inc. All rights reserved.
*
* This source code is subject to the terms and conditions defined in the
* file 'LICENSE' which is part of this source code package. *
* Description:
*/

static const char *freesat_table1="# Huffman Table for FreeSat table 1\n"
"#\n"
"# This table was derived from on-air transmissions.  It certainly has omissions \n"
"# and almost certainly contains errors.  Use entirely at your own risk. \n"
"#\n"
"# Data taken from MythTV and Freesat EPG Parser by mitsubushi\n"
"# Additions, and corrections made by Dom \n"
"# More additions and corrections from Jochen Mann \n"
"#\n"
"START:00:T:\n"
"START:010:B:\n"
"START:1000:C:\n"
"START:1001:I:\n"
"START:1101:S:\n"
"START:01100:L:\n"
"START:01110:D:\n"
"START:01111:H:\n"
"START:10100:R:\n"
"START:10101:N:\n"
"START:10110:E:\n"
"START:11000:F:\n"
"START:11001:A:\n"
"START:11100:M:\n"
"START:11101:P:\n"
"START:11110:W:\n"
"START:011011:Q:\n"
"START:101111:G:\n"
"START:111110:J:\n"
"START:0110100:K:\n"
"START:1011101:U:\n"
"START:1111110:O:\n"
"START:01101010:6:\n"
"START:01101011:.:\n"
"START:10111000:V:\n"
"START:11111110:Y:\n"
"START:011010111:.:\n"
"START:101110011:2:\n"
"START:111111111:X:\n"
"START:1011100100:Z:\n"
"START:1111111100:8:\n"
"START:10111001010:1:\n"
"START:10111001011:3:\n"
"START:111111110100:4:\n"
"START:111111110101:\':\n"
"START:111111110111: :\n"
"START:11111111011000:5:\n"
"START:1111111101101000:9:\n"
"START:111111110110100110:t:\n"
"START:11111111011010011110:ESCAPE:\n"
" :0000:W:\n"
" :0011:M:\n"
" :0100:C:\n"
" :0101:B:\n"
" :0111:P:\n"
" :1001:T:\n"
" :1100:N:\n"
" :1111:S:\n"
" :00011:I:\n"
" :00100:G:\n"
" :01100:H:\n"
" :01101:D:\n"
" :10000:o:\n"
" :10001:A:\n"
" :10100:t:\n"
" :10110:a:\n"
" :10111:F:\n"
" :11010:L:\n"
" :11011:R:\n"
" :001011:U:\n"
" :101011:O:\n"
" :111001:J:\n"
" :111010:E:\n"
" :0001000:f:\n"
" :0001001:Q:\n"
" :0001011:V:\n"
" :0010100:STOP:\n"
" :0010101:w:\n"
" :1110000:2:\n"
" :1110001:K:\n"
" :1110110:Y:\n"
" :1110111:i:\n"
" :00010100:-:\n"
" :10101001:1:\n"
" :101010000:&:\n"
" :101010101:X:\n"
" :0001010101:r:\n"
" :1010100010:5:\n"
" :1010100011:Z:\n"
" :1010101001:9:\n"
" :1010101101:s:\n"
" :1010101110:4:\n"
" :1010101111:3:\n"
" :00010101000:7:\n"
" :00010101100:b:\n"
" :00010101110:y:\n"
" :10101010000:\':\n"
" :10101011000:6:\n"
" :000101011010:v:\n"
" :000101011011:d:\n"
" :101010100010: :\n"
" :101010100011:0:\n"
" :101010110010:n:\n"
" :101010110011:8:\n"
" :0001010100110:g:\n"
" :0001010111110:u:\n"
" :00010101001001:.:\n"
" :00010101001011:l:\n"
" :00010101111110:p:\n"
" :000101011111111:e:\n"
" :00010101111111001:c:\n"
" :000101011111110000:k:\n"
" :0001010100101001110001:q:\n"
"!:01: :\n"
"!:0001:!:\n"
"!:000001:0x3a:\n"
"!:10000000:STOP:\n"
"%:1: :\n"
"&:1: :\n"
"&:01:B:\n"
"&:00001010100:T:\n"
"&:00001100001:a:\n"
"\':1:s:\n"
"\':000:m:\n"
"\':010:C:\n"
"\':0010:t:\n"
"\':0011: :\n"
"\':01100:d:\n"
"\':01110:v:\n"
"\':011011:r:\n"
"\':011111:A:\n"
"\':0110101:n:\n"
"\':01101000:G:\n"
"\':01111001:l:\n"
"\':011010011:D:\n"
"\':011110000:B:\n"
"\':011110101:i:\n"
"\':0110100100:L:\n"
"\':0111101001:STOP:\n"
"\':0111101111:w:\n"
"\':01101001010:O:\n"
"\':01111011101:N:\n"
"\':011110111001:R:\n"
"\':0110100101100:a:\n"
"\':0110100101110:K:\n"
"\':0110100101111:F:\n"
"\':0111101110000:0:\n"
"\':01111011100010:ESCAPE:\n"
"+:0001: :\n"
",:1: :\n"
",:01:0:\n"
"-:11: :\n"
"-:011:S:\n"
"-:0011:T:\n"
"-:0100:U:\n"
"-:1011:S:\n"
"-:000111:I:\n"
"-:010100:F:\n"
"-:010101:o:\n"
"-:0000110:L:\n"
"-:0000111:C:\n"
"-:0010001:A:\n"
"-:0010011:Y:\n"
"-:0101100:B:\n"
"-:1000010:D:\n"
"-:00100000:P:\n"
"-:00100001:Z:\n"
"-:01011101:i:\n"
"-:01011110:d:\n"
"-:01011111:H:\n"
"-:001011001:N:\n"
"-:001011011:R:\n"
"-:0011100000:E:\n"
"-:00101101011:M:\n"
"-:001011010000:ESCAPE:\n"
"-:100101101011:M:\n"
".:1:.:\n"
".:01:STOP:\n"
".:0010: :\n"
".:00001:T:\n"
".:00010:C:\n"
".:00110:p:\n"
".:00111:0:\n"
".:00011010:W:\n"
".:000110001:S:\n"
".:000110110:3:\n"
".:0001100000:1:\n"
".:0001100001:M:\n"
".:0001100110:c:\n"
".:00011001111:A:\n"
".:0001100101100:ESCAPE:\n"
"/:10:7:\n"
"0:00:6:\n"
"0:01: :\n"
"0:11:0:\n"
"0:1001:p:\n"
"0:1010:STOP:\n"
"0:10000:1:\n"
"0:10111:7:\n"
"0:1011010:s:\n"
"0:10110011:4:\n"
"0:10110110:t:\n"
"0:101101111:%:\n"
"0:1011001000:8:\n"
"0:1011001001:0x3a:\n"
"0:1011001011:2:\n"
"0:1011011100:/:\n"
"0:101100101000:5:\n"
"0:101101110101:,:\n"
"0:1011011101001000100111:\':\n"
"1:01:STOP:\n"
"1:000:.:\n"
"1:101:0:\n"
"1:111:1:\n"
"1:0010:2:\n"
"1:0011: :\n"
"1:10010:8:\n"
"1:11000:3:\n"
"1:100000:5:\n"
"1:100001:s:\n"
"1:100010:6:\n"
"1:100011:0x3a:\n"
"1:100110:\':\n"
"1:100111:,:\n"
"1:110010:X:\n"
"1:110011:9:\n"
"1:100111001:7:\n"
"2:0:0:\n"
"2:11:4:\n"
"2:101:STOP:\n"
"2:1001: :\n"
"2:10000:0x3a:\n"
"2:1000101:5:\n"
"2:10001001:1:\n"
"2:10001101001:3:\n"
"2:10001101010000011:8:\n"
"3:0: :\n"
"3:100:STOP:\n"
"3:1100:r:\n"
"3:11100:0:\n"
"3:1110100:0x3a:\n"
"3:10000000:STOP:\n"
"3:11101110011:t:\n"
"3:111011101011:5:\n"
"3:0011101110011:h:\n"
"4:11: :\n"
"4:1001:0x3a:\n"
"4:1011:/:\n"
"4:10101:.:\n"
"4:101000:0:\n"
"4:1010010:M:\n"
"4:00000000:STOP:\n"
"4:01010010:M:\n"
"4:10100111:-:\n"
"4:100001110:P:\n"
"4:10000100101:\':\n"
"5:11: :\n"
"5:101:0:\n"
"5:000000:STOP:\n"
"5:100011:0x3a:\n"
"5:10000000:ESCAPE:\n"
"5:1000000000101100:,:\n"
"5:1000000001001011:K:\n"
"6:01: :\n"
"6:10:0:\n"
"6:111:0x3a:\n"
"6:0001:STOP:\n"
"6:11001:.:\n"
"6:1100011:4:\n"
"6:1101000:8:\n"
"6:11000100:6:\n"
"6:000000000:STOP:\n"
"6:101101000:8:\n"
"6:110001011:9:\n"
"7:1:STOP:\n"
"7:01: :\n"
"7:000:0:\n"
"7:0011:.:\n"
"7:0010000:1:\n"
"7:00100011:4:\n"
"7:00100110:3:\n"
"7:00100111:2:\n"
"7:00100010:ESCAPE:\n"
"7:10000000:STOP:\n"
"8:1: :\n"
"8:00:0:\n"
"8:010:0x3a:\n"
"8:01101:STOP:\n"
"8:011110:.:\n"
"9:0:1:\n"
"9:110:STOP:\n"
"9:1000:9:\n"
"9:1010:.:\n"
"9:10011:0:\n"
"9:100100: :\n"
"9:100101:8:\n"
"9:101100:7:\n"
"9:101110:6:\n"
"9:101111001:3:\n"
"0x3a:1: :\n"
"0x3a:00:0:\n"
"0x3a:011:.:\n"
"0x3a:01011000:ESCAPE:\n"
"0x3a:01011001:T:\n"
"0x3a:0101100000110111:7:\n"
";:1: :\n"
"?:1:STOP:\n"
"?:01: :\n"
"?:10:STOP:\n"
"?:001:0x3a:\n"
"?:0001:.:\n"
"A:001:r:\n"
"A:010: :\n"
"A:100:l:\n"
"A:110:n:\n"
"A:0000:m:\n"
"A:0111:g:\n"
"A:1111:d:\n"
"A:00010:w:\n"
"A:01101:c:\n"
"A:10101:t:\n"
"A:10110:f:\n"
"A:10111:i:\n"
"A:11100:s:\n"
"A:000110:u:\n"
"A:000111:STOP:\n"
"A:111010:b:\n"
"A:1010001:v:\n"
"A:1110110:p:\n"
"A:10100000:S:\n"
"A:101000011:P:\n"
"A:10100001000:e:\n"
"A:10100001001:B:\n"
"A:11101111011:-:\n"
"A:101000010110:k:\n"
"A:101000010111:h:\n"
"A:111011110000:a:\n"
"A:111011110100:y:\n"
"A:1110111100010:x:\n"
"A:1110111100011:\':\n"
"A:11101111001010:0x3a:\n"
"A:111011110011100:D:\n"
"A:1110111100111010:ESCAPE:\n"
"B:00:C:\n"
"B:01:B:\n"
"B:101:r:\n"
"B:1001:i:\n"
"B:1100:o:\n"
"B:1101:u:\n"
"B:1110:a:\n"
"B:1111:e:\n"
"B:10001:l:\n"
"B:1000010:y:\n"
"B:10000000:STOP:\n"
"B:100000111:A:\n"
"B:100001110:S:\n"
"B:10000011000:.:\n"
"B:10000011001:w:\n"
"B:10000111101:h:\n"
"B:10000111111: :\n"
"C:00:o:\n"
"C:01: :\n"
"C:100:l:\n"
"C:110:h:\n"
"C:1010:r:\n"
"C:1110:a:\n"
"C:10110:i:\n"
"C:10111:e:\n"
"C:111100:u:\n"
"C:111101:B:\n"
"C:1111100:y:\n"
"C:1111110:!:\n"
"C:111110100:w:\n"
"C:111111100:STOP:\n"
"C:111111110:S:\n"
"C:111111111:T:\n"
"C:1111101011:2:\n"
"C:1111111011:I:\n"
"C:11111010100:4:\n"
"C:11111110101:D:\n"
"C:1111111010010:\':\n"
"C:111111101001110:z:\n"
"C:11111110100111101:E:\n"
"C:111111101001111110:ESCAPE:\n"
"D:01:o:\n"
"D:10:a:\n"
"D:000:r:\n"
"D:110:e:\n"
"D:111:i:\n"
"D:00111:u:\n"
"D:001011: :\n"
"D:0010101:J:\n"
"D:0011000:y:\n"
"D:00110011:0x3a:\n"
"D:00110100:STOP:\n"
"D:001010011:&:\n"
"D:001100100:\':\n"
"D:001101000:STOP:\n"
"D:0010100001:h:\n"
"D:00110010101:N:\n"
"D:001100101111:w:\n"
"D:0011001010011:d:\n"
"D:00110010100100:ESCAPE:\n"
"D:00110010100101:T:\n"
"E:00:m:\n"
"E:011:v:\n"
"E:101:n:\n"
"E:111:a:\n"
"E:0100:E:\n"
"E:1000:STOP:\n"
"E:1101:x:\n"
"E:10011:d:\n"
"E:11001:l:\n"
"E:010100:4:\n"
"E:010101:y:\n"
"E:010110:u:\n"
"E:100100:r:\n"
"E:110000:i:\n"
"E:0101111:s:\n"
"E:1001010:F:\n"
"E:10010110:R:\n"
"E:11000110:\':\n"
"E:11000111: :\n"
"E:010111010:g:\n"
"E:0101110001:c:\n"
"E:0101110011:q:\n"
"E:1001011100:p:\n"
"E:10010111011:t:\n"
"E:01011100100010:f:\n"
"E:01011100100011:U:\n"
"E:01011100100101:M:\n"
"E:100101110100100:ESCAPE:\n"
"E:10010111010010001101011:k:\n"
"F:00:i:\n"
"F:10:a:\n"
"F:011:r:\n"
"F:110:u:\n"
"F:111:o:\n"
"F:0100:e:\n"
"F:01011:l:\n"
"F:0101000:A:\n"
"F:0101010:O:\n"
"F:01010010: :\n"
"F:010100110:h:\n"
"F:010101101:f:\n"
"F:01010111001:I:\n"
"F:01010111011:1:\n"
"F:010101100000:M:\n"
"F:0101011000010:y:\n"
"G:10:r:\n"
"G:001:M:\n"
"G:010:a:\n"
"G:011:o:\n"
"G:110:i:\n"
"G:111:e:\n"
"G:00001:u:\n"
"G:000001:h:\n"
"G:000111:l:\n"
"G:0000001:y:\n"
"G:0001100:w:\n"
"G:00000000:0x3a:\n"
"G:00011011:C:\n"
"G:0001101010:P:\n"
"G:0001101011: :\n"
"G:00000001010:A:\n"
"G:000000010110:T:\n"
"G:0000000100110:ESCAPE:\n"
"G:000000010011001100100:d:\n"
"H:0:o:\n"
"H:100:a:\n"
"H:101:i:\n"
"H:110:e:\n"
"H:1110:u:\n"
"H:11110:R:\n"
"H:111111101:y:\n"
"H:111111110:S:\n"
"H:111111100011:w:\n"
"H:1111111000101:D:\n"
"H:11111110001000:ESCAPE:\n"
"I:0:T:\n"
"I:100:s:\n"
"I:101:n:\n"
"I:1101:t:\n"
"I:11001: :\n"
"I:11101:\':\n"
"I:11111:r:\n"
"I:110000:I:\n"
"I:110001:STOP:\n"
"I:111001:m:\n"
"I:1110000:d:\n"
"I:1110001:N:\n"
"I:11110000:a:\n"
"I:111101110:c:\n"
"I:11110110110:f:\n"
"I:11110111100:l:\n"
"I:111101101110:o:\n"
"I:1111011010010:,:\n"
"I:1111011010011:A:\n"
"I:1111011110101:g:\n"
"I:1111011111000:C:\n"
"I:1111011111001:0x3a:\n"
"I:11110111110101:b:\n"
"I:1111011110100100:ESCAPE:\n"
"I:111101111010010000111111:?:\n"
"J:00:a:\n"
"J:01:u:\n"
"J:11:e:\n"
"J:101:o:\n"
"J:1001:i:\n"
"J:10000: :\n"
"J:1000111:STOP:\n"
"J:10001110:STOP:\n"
"J:100011001:s:\n"
"J:100011011000:ESCAPE:\n"
"J:100011011001:D:\n"
"K:01:i:\n"
"K:11:y:\n"
"K:001:e:\n"
"K:101: :\n"
"K:0000:a:\n"
"K:1000:o:\n"
"K:00011:r:\n"
"K:100110:n:\n"
"K:100111:S:\n"
"K:00010000:STOP:\n"
"K:10010011:G:\n"
"K:100100100:h:\n"
"K:100100101:w:\n"
"K:10010001011:u:\n"
"K:100100010000:T:\n"
"K:1001000101010:ESCAPE:\n"
"K:1001000101011:l:\n"
"L:00:a:\n"
"L:10:o:\n"
"L:11:i:\n"
"L:010:e:\n"
"L:0111:u:\n"
"L:01101:K:\n"
"L:0110000:l:\n"
"L:0110010:A:\n"
"L:0110011: :\n"
"L:01100011:y:\n"
"L:0110001000:L:\n"
"L:01100010110010:ESCAPE:\n"
"M:01:a:\n"
"M:10:o:\n"
"M:000:e:\n"
"M:111:i:\n"
"M:0010:T:\n"
"M:1100:y:\n"
"M:1101:u:\n"
"M:00110:STOP:\n"
"M:001111:c:\n"
"M:00111001:r:\n"
"M:00111010:E:\n"
"M:0011100011: :\n"
"M:0011101100:1:\n"
"M:00111000001:h:\n"
"M:001110000000110:ESCAPE:\n"
"M:001110001011111:R:\n"
"N:1:e:\n"
"N:00:o:\n"
"N:011:i:\n"
"N:0101:a:\n"
"N:01001:u:\n"
"N:01000100:E:\n"
"N:010001111:H:\n"
"N:01000101011:I:\n"
"N:01000101110:A:\n"
"N:010001010100:M:\n"
"N:010001011110: :\n"
"O:000:\':\n"
"O:010:f:\n"
"O:110:u:\n"
"O:111:n:\n"
"O:0011:l:\n"
"O:1001:m:\n"
"O:01101:r:\n"
"O:01110:d:\n"
"O:10000:p:\n"
"O:10110:STOP:\n"
"O:011001:S:\n"
"O:011111:b:\n"
"O:100011:v:\n"
"O:101010:w:\n"
"O:101011:U:\n"
"O:01100010:x:\n"
"O:10001001:t:\n"
"O:10001011: :\n"
"O:10111110:s:\n"
"O:10111111:N:\n"
"O:011000001:g:\n"
"O:100010101:a:\n"
"O:1000100010:i:\n"
"O:1000101001:o:\n"
"O:01100000010:c:\n"
"O:10001010000:2:\n"
"O:0110000001101001101011:k:\n"
"P:01:r:\n"
"P:10:l:\n"
"P:000:e:\n"
"P:001:a:\n"
"P:111:o:\n"
"P:1101:i:\n"
"P:110000:D:\n"
"P:110001:u:\n"
"P:110011:h:\n"
"P:11001000: :\n"
"P:11001010:2:\n"
"P:110010011:M:\n"
"P:11001011100:0x3a:\n"
"P:11001011111:STOP:\n"
"P:110010111101:s:\n"
"P:1100101111101:G:\n"
"P:110010111100010:C:\n"
"P:110010111100011:ESCAPE:\n"
"Q:1:u:\n"
"Q:001:STOP:\n"
"Q:0111: :\n"
"Q:01101:C:\n"
"Q:011000:ESCAPE:\n"
"Q:0010000:STOP:\n"
"R:00:a:\n"
"R:01:o:\n"
"R:11:e:\n"
"R:100:i:\n"
"R:1011:u:\n"
"R:10101:E:\n"
"R:1010011:STOP:\n"
"R:10100101:h:\n"
"R:1010010000:I:\n"
"R:1010010010:y:\n"
"R:1010010011:n:\n"
"R:101001000110: :\n"
"R:1010010001011:S:\n"
"R:10100100011111:1:\n"
"R:101001000101010:ESCAPE:\n"
"R:10100100010101000111000:8:\n"
"S:001:o:\n"
"S:010:p:\n"
"S:011:u:\n"
"S:110:h:\n"
"S:111:t:\n"
"S:0001:a:\n"
"S:1001:e:\n"
"S:1011:c:\n"
"S:00000:n:\n"
"S:10001:i:\n"
"S:10101:k:\n"
"S:000011:w:\n"
"S:101000:m:\n"
"S:0000101:A:\n"
"S:1000010:l:\n"
"S:1010010:q:\n"
"S:00001000:2:\n"
"S:10000000:O:\n"
"S:10000011: :\n"
"S:100000010:y:\n"
"S:100001100:E:\n"
"S:10000110100:g:\n"
"S:100000011011:r:\n"
"S:1000011010110:3:\n"
"S:10000001101000:5:\n"
"S:10000001101010:0x3a:\n"
"S:10000001101011:1:\n"
"S:1000000110100110:ESCAPE:\n"
"S:100000011010011000110100:4:\n"
"S:100000011010011000110110:6:\n"
"S:100000011010011000111000:8:\n"
"S:100000011010011001010011:S:\n"
"T:0:h:\n"
"T:101:o:\n"
"T:111:V:\n"
"T:1000:e:\n"
"T:1001:r:\n"
"T:11000:a:\n"
"T:11010:w:\n"
"T:110011:i:\n"
"T:1101111:H:\n"
"T:11001001:y:\n"
"T:11001010:M:\n"
"T:11011000:.:\n"
"T:11011100:u:\n"
"T:11011101:W:\n"
"T:110010110:0x3a:\n"
"T:110010111:4:\n"
"T:1101100100: :\n"
"T:1101100101:STOP:\n"
"T:110010000000:T:\n"
"T:110010000010:B:\n"
"T:11001000001110:A:\n"
"T:1101100101000000:STOP:\n"
"T:11001000001111100:ESCAPE:\n"
"T:110010000011111000010110:-:\n"
"U:0:n:\n"
"U:10:p:\n"
"U:1101:K:\n"
"U:1111:l:\n"
"U:11000:R:\n"
"U:11100:S:\n"
"U:110011:E:\n"
"U:111011:s:\n"
"U:1100101:g:\n"
"U:1110101:T:\n"
"U:11001001: :\n"
"U:110010001:r:\n"
"U:111010000:2:\n"
"U:11101001011100:ESCAPE:\n"
"U:11101001011110:t:\n"
"V:1: :\n"
"V:011:i:\n"
"V:0010:e:\n"
"V:0011:a:\n"
"V:0101000:\':\n"
"V:0101001:4:\n"
"V:0101101:o:\n"
"V:01011100:STOP:\n"
"V:0101100000:s:\n"
"V:01011000111000:ESCAPE:\n"
"W:01:o:\n"
"W:11:e:\n"
"W:001:h:\n"
"W:100:a:\n"
"W:101:i:\n"
"W:00010:O:\n"
"W:00011:r:\n"
"W:000011:y:\n"
"W:0000100:u:\n"
"W:000010110000:I:\n"
"X:10: :\n"
"X:11:t:\n"
"X:0000:STOP:\n"
"X:01100011100:ESCAPE:\n"
"X:01100011101:i:\n"
"X:0110001110001110000:p:\n"
"Y:1:o:\n"
"Y:01:e:\n"
"Y:000:u:\n"
"Y:0011: :\n"
"Y:001010:a:\n"
"Y:001011000:n:\n"
"Y:00101100111:s:\n"
"Y:0010110101110:ESCAPE:\n"
"Z:1:o:\n"
"Z:00:a:\n"
"Z:010:i:\n"
"Z:01101:u:\n"
"Z:01110:e:\n"
"Z:011110: :\n"
"Z:01111110:STOP:\n"
"a:001:r:\n"
"a:011:t:\n"
"a:100:l:\n"
"a:110:n:\n"
"a:0001:m:\n"
"a:0100:c:\n"
"a:1010:s:\n"
"a:1110:y:\n"
"a:10110: :\n"
"a:10111:d:\n"
"a:11110:i:\n"
"a:11111:k:\n"
"a:000010:b:\n"
"a:010110:p:\n"
"a:010111:g:\n"
"a:0000000:e:\n"
"a:0000001:\':\n"
"a:0000011:w:\n"
"a:0101001:u:\n"
"a:0101010:z:\n"
"a:0101011:v:\n"
"a:00000101:f:\n"
"a:00001100:STOP:\n"
"a:01010001:h:\n"
"a:000001001:0x3a:\n"
"a:0000010000:!:\n"
"a:0101000000:o:\n"
"a:0101000001:x:\n"
"a:00000100011:a:\n"
"a:01010000101:.:\n"
"a:01010000111:,:\n"
"a:010100001000:q:\n"
"a:010100001011:.:\n"
"a:0101000010010:j:\n"
"a:01010000100111:?:\n"
"b:000:r:\n"
"b:001:o:\n"
"b:010:e:\n"
"b:011:a:\n"
"b:100:i:\n"
"b:1011:u:\n"
"b:1100:y:\n"
"b:1101:l:\n"
"b:1111: :\n"
"b:10101:s:\n"
"b:11100:b:\n"
"b:11101:STOP:\n"
"b:101000:h:\n"
"b:10100111:\':\n"
"b:1010011001:t:\n"
"b:1010011010:j:\n"
"b:10100110000:n:\n"
"b:10100110001:d:\n"
"b:10100110111:w:\n"
"b:101001101101:m:\n"
"b:10100110110001:0x3a:\n"
"b:1010011011000000101100:,:\n"
"c:00:k:\n"
"c:010:o:\n"
"c:100:h:\n"
"c:110:t:\n"
"c:111:e:\n"
"c:0111:r:\n"
"c:10100: :\n"
"c:10110:i:\n"
"c:10111:a:\n"
"c:011000:l:\n"
"c:011001:y:\n"
"c:011010:s:\n"
"c:011011:STOP:\n"
"c:1010100:c:\n"
"c:1010111:u:\n"
"c:10101010:0x3a:\n"
"c:101011001:D:\n"
"c:1010110100:G:\n"
"c:10101100000:L:\n"
"c:10101100001:K:\n"
"c:10101100011:A:\n"
"c:10101101010:q:\n"
"c:10101101110:.:\n"
"c:10101101111:C:\n"
"c:101011000100:n:\n"
"c:101011000101:\':\n"
"c:1010110101100:B:\n"
"c:1010110101101:I:\n"
"c:101011010111001:ESCAPE:\n"
"c:101011010111111:F:\n"
"c:1010110101111100:w:\n"
"c:1010110101111101:Q:\n"
"d:11: :\n"
"d:001:e:\n"
"d:100:STOP:\n"
"d:101:a:\n"
"d:0001:y:\n"
"d:0100:i:\n"
"d:0110:s:\n"
"d:00000:o:\n"
"d:01010:d:\n"
"d:000011:u:\n"
"d:010110:r:\n"
"d:010111:l:\n"
"d:011101:v:\n"
"d:011110:g:\n"
"d:0000100:\':\n"
"d:0111111:.:\n"
"d:00001010:0x3a:\n"
"d:00001011:h:\n"
"d:01110000:c:\n"
"d:01110010:n:\n"
"d:01110011:w:\n"
"d:011100010:?:\n"
"d:011111000:!:\n"
"d:011111001:-:\n"
"d:011111010:f:\n"
"d:0111000111:m:\n"
"d:0111110110:,:\n"
"d:01111101110:t:\n"
"d:01111101111:b:\n"
"d:0111000110001:p:\n"
"d:011100011000000:ESCAPE:\n"
"d:01110001100000001000010:B:\n"
"e:01: :\n"
"e:000:s:\n"
"e:101:r:\n"
"e:0010:t:\n"
"e:1001:n:\n"
"e:1110:a:\n"
"e:1111:w:\n"
"e:10000:l:\n"
"e:11000:STOP:\n"
"e:11011:e:\n"
"e:001110:m:\n"
"e:100010:c:\n"
"e:100011:d:\n"
"e:0011010:i:\n"
"e:0011011:p:\n"
"e:0011110:b:\n"
"e:1101000:v:\n"
"e:1101011:y:\n"
"e:00110000:g:\n"
"e:00110001:f:\n"
"e:00110010:x:\n"
"e:00111110:k:\n"
"e:00111111:0x3a:\n"
"e:11000000:STOP:\n"
"e:11010011:o:\n"
"e:11010100:\':\n"
"e:001100111:h:\n"
"e:110100101:.:\n"
"e:0011001100:P:\n"
"e:0011001101:B:\n"
"e:1101001000:,:\n"
"e:1101010100:V:\n"
"e:1101010101:z:\n"
"e:1101010111:j:\n"
"e:11010010010:4:\n"
"e:11010010011:?:\n"
"e:11010101101:u:\n"
"e:110101011001:-:\n"
"e:1101010110001:!:\n"
"e:11010101100001:q:\n"
"e:110101011000001:G:\n"
"e:1101010110000000001:ESCAPE:\n"
"f:0: :\n"
"f:101:o:\n"
"f:1001:t:\n"
"f:1100:a:\n"
"f:1101:i:\n"
"f:1111:e:\n"
"f:10000:.:\n"
"f:11100:r:\n"
"f:11101:f:\n"
"f:100010:STOP:\n"
"f:10001101:y:\n"
"f:10001111:u:\n"
"f:100011101:l:\n"
"f:1000111000:g:\n"
"f:100011001011:s:\n"
"f:100011100111:0x3a:\n"
"f:10001110011000:ESCAPE:\n"
"g:00:h:\n"
"g:10: :\n"
"g:011:e:\n"
"g:1100:i:\n"
"g:11100:0x3a:\n"
"g:11101:r:\n"
"g:11111:a:\n"
"g:110100:s:\n"
"g:110111:l:\n"
"g:111101:u:\n"
"g:1101011:b:\n"
"g:1101100:g:\n"
"g:1101101:o:\n"
"g:1111001:n:\n"
"g:01000000:STOP:\n"
"g:111100011:d:\n"
"g:1101010100:.:\n"
"g:1101010101:,:\n"
"g:1101010110:\':\n"
"g:1101010111:t:\n"
"g:1111000101:y:\n"
"g:11110001000:w:\n"
"g:111100010011:m:\n"
"g:11110001001011:?:\n"
"g:111100010010001:f:\n"
"g:1111000100101000:ESCAPE:\n"
"h:0:e:\n"
"h:101:o:\n"
"h:1001:i:\n"
"h:1100:a:\n"
"h:1110: :\n"
"h:1111:t:\n"
"h:11010:r:\n"
"h:100000:b:\n"
"h:100001:u:\n"
"h:10001000:w:\n"
"h:10001001:d:\n"
"h:10001010:n:\n"
"h:10001011:y:\n"
"h:10001100:!:\n"
"h:10001101:l:\n"
"h:10001111:.:\n"
"h:11011000:STOP:\n"
"h:100011100:\':\n"
"h:1000111010:s:\n"
"h:10001110110:m:\n"
"h:100011101111:0x3a:\n"
"h:10001110111000:f:\n"
"h:10001110111010:c:\n"
"h:1000111011101101:q:\n"
"h:1000111011101110:g:\n"
"h:10001110111011110:-:\n"
"h:100011101110111110:,:\n"
"i:01:n:\n"
"i:000:c:\n"
"i:1001:o:\n"
"i:1010:l:\n"
"i:1100:g:\n"
"i:1101:s:\n"
"i:1110:t:\n"
"i:1111:e:\n"
"i:00101:a:\n"
"i:00110:v:\n"
"i:10000:r:\n"
"i:10001:d:\n"
"i:10110:m:\n"
"i:001000:p:\n"
"i:001110: :\n"
"i:101111:f:\n"
"i:0011110:z:\n"
"i:1011100:b:\n"
"i:1011101:k:\n"
"i:00100101:-:\n"
"i:00100110:x:\n"
"i:00111110:STOP:\n"
"i:001001001:\':\n"
"i:001001111:q:\n"
"i:0010011100:u:\n"
"i:0010011101:i:\n"
"i:00100100001:h:\n"
"i:00100100010:0x3a:\n"
"i:00100100011:w:\n"
"i:0010010000001:,:\n"
"i:0010010000010:y:\n"
"i:001001000000010:ESCAPE:\n"
"i:001001000000011:j:\n"
"i:00100100000001011000011:ESCAPE:\n"
"j:0:y:\n"
"j:11:o:\n"
"j:101:e:\n"
"j:1001:a:\n"
"j:10001:u:\n"
"j:100001:i:\n"
"j:10000011: :\n"
"k:00: :\n"
"k:10:e:\n"
"k:010:i:\n"
"k:0110:y:\n"
"k:0111:s:\n"
"k:1111:f:\n"
"k:111001:a:\n"
"k:111010:l:\n"
"k:1110001:0x3a:\n"
"k:1110110:k:\n"
"k:11000000:STOP:\n"
"k:11100000:\':\n"
"k:11101111:.:\n"
"k:111000011:w:\n"
"k:111011100:o:\n"
"k:1110000101:h:\n"
"k:11100001000:b:\n"
"k:11100001001:,:\n"
"k:11101110111:n:\n"
"k:111011101010:?:\n"
"k:111011101100:m:\n"
"k:111011101101:!:\n"
"k:1110111010010:u:\n"
"k:1110111010110:d:\n"
"k:1110111010111:t:\n"
"k:111011101000000:p:\n"
"k:1110111010000000:p:\n"
"k:1110111010001100:ESCAPE:\n"
"k:1110111010001101:r:\n"
"l:01:e:\n"
"l:000:l:\n"
"l:101:a:\n"
"l:0011:y:\n"
"l:1001:d:\n"
"l:1100:o:\n"
"l:1110:i:\n"
"l:1111: :\n"
"l:00100:u:\n"
"l:11010:s:\n"
"l:001010:t:\n"
"l:001011:m:\n"
"l:1101101:k:\n"
"l:10000000:STOP:\n"
"l:11011000:f:\n"
"l:11011100:b:\n"
"l:11011110:\':\n"
"l:11011111:c:\n"
"l:110110011:v:\n"
"l:110111010:0x3a:\n"
"l:1101100101:.:\n"
"l:1101110110:w:\n"
"l:11011001000:z:\n"
"l:11011101111:p:\n"
"l:110110010010:h:\n"
"l:1101110111000:g:\n"
"l:1101110111001:,:\n"
"l:11011101110100:r:\n"
"l:11011101110101:n:\n"
"l:11011101110111:-:\n"
"l:1101110111011011:?:\n"
"m:10:e:\n"
"m:001:m:\n"
"m:011: :\n"
"m:111:a:\n"
"m:0000:i:\n"
"m:0100:y:\n"
"m:1101:p:\n"
"m:01010:b:\n"
"m:11000:o:\n"
"m:110010:n:\n"
"m:110011:s:\n"
"m:0101100:l:\n"
"m:0101110:f:\n"
"m:00010000:STOP:\n"
"m:01011010:0x3a:\n"
"m:01011110:4:\n"
"m:010110110:h:\n"
"m:010111110:w:\n"
"m:0101101111:\':\n"
"m:0101111110:r:\n"
"m:0101111111:u:\n"
"m:01011011101:.:\n"
"m:0101101110000:ESCAPE:\n"
"n:000:i:\n"
"n:100:g:\n"
"n:101: :\n"
"n:110:d:\n"
"n:0011:a:\n"
"n:0100:s:\n"
"n:0110:e:\n"
"n:1111:t:\n"
"n:01110:c:\n"
"n:01111:n:\n"
"n:001010:y:\n"
"n:010100:\':\n"
"n:010101:k:\n"
"n:010111:o:\n"
"n:111000:STOP:\n"
"n:0010000:r:\n"
"n:0010011:f:\n"
"n:0010110:u:\n"
"n:0010111:j:\n"
"n:00100010:v:\n"
"n:00100100:-:\n"
"n:00100101:.:\n"
"n:01011000:l:\n"
"n:01011010:x:\n"
"n:01011011:0x3a:\n"
"n:11100000:STOP:\n"
"n:001000111:,:\n"
"n:010110011:m:\n"
"n:0010001100:!:\n"
"n:00100011010:z:\n"
"n:01011001001:?:\n"
"n:01011001010:h:\n"
"n:01011001011:b:\n"
"n:001000110110:B:\n"
"n:010110010000:w:\n"
"n:0101100100011:q:\n"
"n:01011001000101:p:\n"
"n:010110010001000:;:\n"
"n:0101100100010011:ESCAPE:\n"
"o:00:r:\n"
"o:110:n:\n"
"o:0100:f:\n"
"o:0101: :\n"
"o:0110:w:\n"
"o:1000:o:\n"
"o:1011:u:\n"
"o:01111:t:\n"
"o:10010:c:\n"
"o:10100:p:\n"
"o:10101:d:\n"
"o:11100:m:\n"
"o:11110:l:\n"
"o:011100:a:\n"
"o:011101:b:\n"
"o:100110:y:\n"
"o:111010:s:\n"
"o:111011:k:\n"
"o:1111101:v:\n"
"o:1111110:g:\n"
"o:10011100:STOP:\n"
"o:11111111:i:\n"
"o:111110001:h:\n"
"o:111110010:!:\n"
"o:111111100:e:\n"
"o:111111101:j:\n"
"o:1111100110:\':\n"
"o:11111000001:?:\n"
"o:11111000010:0x3a:\n"
"o:11111001110:z:\n"
"o:11111001111:x:\n"
"o:111110000110:.:\n"
"o:111110000111:-:\n"
"o:11111000000110:,:\n"
"o:11111000000111:G:\n"
"o:1111100000010100:S:\n"
"o:111110000001010111:q:\n"
"p:00:e:\n"
"p:100:i:\n"
"p:110:o:\n"
"p:0110:s:\n"
"p:1010: :\n"
"p:1110:p:\n"
"p:01110:l:\n"
"p:01111:r:\n"
"p:10110:h:\n"
"p:11110:a:\n"
"p:101110:t:\n"
"p:101111:\':\n"
"p:1111100:d:\n"
"p:1111101:m:\n"
"p:1111110:y:\n"
"p:01000000:STOP:\n"
"p:111111101:0x3a:\n"
"p:111111111:!:\n"
"p:1111111100:w:\n"
"p:1111111101:u:\n"
"p:11111110000:b:\n"
"p:11111110010:-:\n"
"p:11111110011:.:\n"
"p:1111111000101:k:\n"
"p:11111110001001:,:\n"
"p:111111100010000:ESCAPE:\n"
"q:1:u:\n"
"q:001:0x3a:\n"
"q:0001:\':\n"
"q:01000000:STOP:\n"
"r:000: :\n"
"r:011:i:\n"
"r:101:e:\n"
"r:0011:y:\n"
"r:0100:d:\n"
"r:1000:s:\n"
"r:1001:t:\n"
"r:1100:a:\n"
"r:1101:STOP:\n"
"r:1111:o:\n"
"r:01011:n:\n"
"r:11101:l:\n"
"r:001001:k:\n"
"r:001010:r:\n"
"r:001011:m:\n"
"r:010101:u:\n"
"r:111001:g:\n"
"r:0010000:\':\n"
"r:0101001:c:\n"
"r:1110001:0x3a:\n"
"r:00100010:f:\n"
"r:00100011:.:\n"
"r:01010001:b:\n"
"r:11100000:v:\n"
"r:010100000:,:\n"
"r:010100001:p:\n"
"r:111000010:w:\n"
"r:1110000111:j:\n"
"r:11100001100:-:\n"
"r:111000011010:h:\n"
"r:1110000110111100:!:\n"
"r:1110000110111101010:ESCAPE:\n"
"s:10: :\n"
"s:11:STOP:\n"
"s:011:t:\n"
"s:0000:s:\n"
"s:0010:i:\n"
"s:0011:h:\n"
"s:00011:;:\n"
"s:01010:e:\n"
"s:010001:o:\n"
"s:010011:c:\n"
"s:010110:0x3a:\n"
"s:0001000:.:\n"
"s:0001001:!:\n"
"s:0001011:y:\n"
"s:0100000:p:\n"
"s:0100100:a:\n"
"s:0101111:u:\n"
"s:00010100:,:\n"
"s:00010101:f:\n"
"s:01000011:\':\n"
"s:01001011:n:\n"
"s:01011100:l:\n"
"s:01011101:r:\n"
"s:010000101:k:\n"
"s:010010100:d:\n"
"s:0100001001:m:\n"
"s:0100101011:b:\n"
"s:01000010000:?:\n"
"s:01000010001:w:\n"
"s:01001010100:g:\n"
"s:010010101010:q:\n"
"s:01001010101110:-:\n"
"s:010010101011000:ESCAPE:\n"
"t:000:i:\n"
"t:100: :\n"
"t:111:h:\n"
"t:0010:a:\n"
"t:0100:r:\n"
"t:1010:s:\n"
"t:1011:o:\n"
"t:1101:e:\n"
"t:00111:t:\n"
"t:01010:y:\n"
"t:11000:u:\n"
"t:010110:m:\n"
"t:110010:c:\n"
"t:110011:l:\n"
"t:0011000:\':\n"
"t:0011010:0x3a:\n"
"t:00110010:w:\n"
"t:00110110:!:\n"
"t:01011100:.:\n"
"t:01011101:b:\n"
"t:01011110:E:\n"
"t:01011111:f:\n"
"t:01100000:STOP:\n"
"t:001100110:?:\n"
"t:001101110:n:\n"
"t:0011001110:z:\n"
"t:0011011110:d:\n"
"t:00110011110:-:\n"
"t:00110011111:,:\n"
"t:0011011111110:g:\n"
"t:00110111111110:ESCAPE:\n"
"t:00110111111111100:k:\n"
"t:001101111111111010:j:\n"
"u:00:r:\n"
"u:100:s:\n"
"u:111:n:\n"
"u:0100:e:\n"
"u:0101:m:\n"
"u:1100:t:\n"
"u:01100:c:\n"
"u:01101:g:\n"
"u:01110:b:\n"
"u:10100:p:\n"
"u:10101:i:\n"
"u:10110:l:\n"
"u:11010:d:\n"
"u:11011:a:\n"
"u:011110:STOP:\n"
"u:101110:y:\n"
"u:0111110:z:\n"
"u:1011110: :\n"
"u:01111111:\':\n"
"u:011111100:k:\n"
"u:0111111010:f:\n"
"u:1011111100:w:\n"
"u:101111110100:v:\n"
"u:101111110101:x:\n"
"u:101111110111:o:\n"
"u:1011111101100:j:\n"
"u:10111111011011100:?:\n"
"v:1:e:\n"
"v:01:i:\n"
"v:001:a:\n"
"v:0001:o:\n"
"v:00000: :\n"
"v:0000100:y:\n"
"v:0000110:STOP:\n"
"v:00001011:s:\n"
"v:000010101:r:\n"
"v:0000101000:ESCAPE:\n"
"v:0000101001:.:\n"
"v:00001010011101:STOP:\n"
"w:0:s:\n"
"w:100: :\n"
"w:110:STOP:\n"
"w:1011:i:\n"
"w:1110:o:\n"
"w:10100:a:\n"
"w:11110:n:\n"
"w:11111:e:\n"
"w:1010111:y:\n"
"w:10101000:m:\n"
"w:10101011:d:\n"
"w:10101101:l:\n"
"w:101010011:b:\n"
"w:101010100:k:\n"
"w:101010101:r:\n"
"w:1010110001:,:\n"
"w:1010110011:h:\n"
"w:10101100000:c:\n"
"w:10101100001:f:\n"
"w:10101100101:p:\n"
"w:101011001000:t:\n"
"w:1010100101010:.:\n"
"w:1010100101011:0x3a:\n"
"w:10101100100101:\':\n"
"w:101011001001001:?:\n"
"w:1010110010010000:ESCAPE:\n"
"x:00:p:\n"
"x:10: :\n"
"x:11:t:\n"
"x:0110:STOP:\n"
"x:01000:o:\n"
"x:01010:c:\n"
"x:01110:i:\n"
"x:010010:e:\n"
"x:010110:y:\n"
"x:0100110:u:\n"
"x:0100111:f:\n"
"x:0101111:,:\n"
"x:010111001:a:\n"
"x:0101110101:\':\n"
"x:01011101001:x:\n"
"x:010111010000:ESCAPE:\n"
"y:0: :\n"
"y:10001:o:\n"
"y:10010:s:\n"
"y:10100:a:\n"
"y:10110:l:\n"
"y:10111:0x3a:\n"
"y:100110:d:\n"
"y:1000001:n:\n"
"y:1000010:t:\n"
"y:1010100:\':\n"
"y:1010101:b:\n"
"y:1010111:.:\n"
"y:10000000:i:\n"
"y:10000110:,:\n"
"y:10000111:p:\n"
"y:10011100:m:\n"
"y:10011110:c:\n"
"y:10101100:w:\n"
"y:10101101:e:\n"
"y:11000000:STOP:\n"
"y:100000010:?:\n"
"y:100000011:f:\n"
"y:100111010:r:\n"
"y:100111011:g:\n"
"y:1001111100:z:\n"
"y:1001111110:-:\n"
"y:1001111111:T:\n"
"y:100111110110:!:\n"
"y:100111110111:k:\n"
"y:1001111101010:v:\n"
"y:100111110101110:h:\n"
"y:10011111010111100:ESCAPE:\n"
"z:00:z:\n"
"z:01:STOP:\n"
"z:101:i:\n"
"z:1000:y:\n"
"z:1001:e:\n"
"z:1101: :\n"
"z:1110:l:\n"
"z:11110:a:\n"
"z:111110:o:\n"
"z:11111100:m:\n"
"z:11111101:0x3a:\n"
"z:11111111:c:\n"
"z:11111110100:u:\n"
"z:11111110101000:ESCAPE:"
"z:11111110101010:h:\n";
