/* SPDX-License-Identifier: (GPL-2.0+ OR MIT)
 *
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */
#include <linux/slab.h>
#include "ring_buffer.h"
#include <linux/arm-smccc.h>

#define AML_DATA_PROCESS             (0x820000FF)
#define AML_D_P_READ_BL30MSG         (0x200)


static unsigned long bl31_data_process(unsigned long type,
				 unsigned long buffer,
				 unsigned long length,
				 unsigned long option)
{
	struct arm_smccc_res res;

	asm __volatile__("" : : : "memory");

	do {
		arm_smccc_smc((unsigned long)AML_DATA_PROCESS,
			      (unsigned long)type,
			      (unsigned long)buffer,
			      (unsigned long)length,
			      (unsigned long)option,
			      0, 0, 0, &res);
	} while (0);

	return res.a0;
}


unsigned int read_remove_ring_buffer(unsigned long buffer, unsigned int size)
{
    unsigned int count;
    count = (unsigned int)bl31_data_process(AML_D_P_READ_BL30MSG,
                            (unsigned long)buffer, (unsigned long)size, 1);
	return count;
}

unsigned int read_keep_ring_buffer(unsigned long buffer, unsigned int size)
{
    unsigned int count;
    count = (unsigned int)bl31_data_process(AML_D_P_READ_BL30MSG,
                            (unsigned long)buffer, (unsigned long)size, 0);
	return count;
}

