/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2021 Amlogic, Inc. All rights reserved.
 */

#ifndef __VPP_PQ_TABLE_H__
#define __VPP_PQ_TABLE_H__

#define PAGE_REG_COUNT_MAX (256)
#define PAGE_TBL_COUNT_MAX (1)/*(100)*/
#define MASK_COUNT_MAX (256)

enum vpp_page_module_e {
	EN_PAGE_MODULE_SR_0 = 0,
	EN_PAGE_MODULE_SR_1,
	EN_PAGE_MODULE_LC,
	EN_PAGE_MODULE_MAX,
};

struct vpp_pq_reg_s {
	unsigned char addr;      /*Register address*/
	unsigned char update;    /*Update flag*/
	unsigned char mask_type; /*Mask type*/
	unsigned int  val;       /*Register value*/
};

struct vpp_pq_page_s {
	struct vpp_pq_reg_s reg[PAGE_REG_COUNT_MAX];
};

struct vpp_pq_table_s {
	unsigned char page_addr; /*Page address*/
	unsigned char count;     /*Count of total reg*/
	struct vpp_pq_page_s page[PAGE_TBL_COUNT_MAX]; /*Table selected by top layer*/
};

unsigned int mask_list[] = {
	0x00000000,
	0xffffffff,
	0x00000330,
	0x000f00ff,
};

struct vpp_pq_table_s pq_table[EN_PAGE_MODULE_MAX] = {
	/*sharpness0 reg*/
	{
		0x50, 94,
		{/*index 0*/
			{
				{
					{0x00, 1, 1, 0x02d00240},
					{0x01, 1, 1, 0x00082060},
					{0x02, 1, 1, 0x00000010},
					{0x05, 1, 1, 0x14323218},
					{0x06, 1, 1, 0x50845e00},
					{0x07, 1, 1, 0x14323218},
					{0x08, 1, 1, 0x508d5000},
					{0x09, 1, 1, 0x14323218},
					{0x0a, 1, 1, 0x3d3d1f00},
					{0x0b, 1, 1, 0x14323218},
					{0x0c, 1, 1, 0x38390c00},
					{0x0d, 1, 1, 0x22202220},
					{0x0e, 1, 1, 0x22202220},
					{0x0f, 1, 1, 0x00020202},
					{0x10, 1, 1, 0x00020202},
					{0x11, 1, 1, 0x00020202},
					{0x12, 1, 1, 0x00020202},
					{0x13, 1, 1, 0x38402840},
					{0x14, 1, 1, 0x0000103e},
					{0x15, 1, 1, 0x0a195040},
					{0x16, 1, 1, 0x3f003f00},
					{0x17, 1, 1, 0x0a195040},
					{0x18, 1, 1, 0x3f003f00},
					{0x19, 1, 1, 0x003f003f},
					{0x1a, 1, 1, 0x00000003},
					{0x1b, 1, 1, 0x00180014},
					{0x1c, 1, 1, 0x00103f00},
					{0x1d, 1, 1, 0x003f003f},
					{0x1e, 1, 1, 0x00010001},
					{0x1f, 1, 1, 0x0018000a},
					{0x20, 1, 1, 0x00402000},
					{0x21, 1, 1, 0x0000003f},
					{0x22, 1, 1, 0x00001414},
					{0x23, 1, 1, 0x08140214},
					{0x24, 1, 1, 0x08140214},
					{0x25, 1, 1, 0x2806c814},
					{0x26, 1, 1, 0x2203f03f},
					{0x27, 1, 1, 0x00000000},
					{0x28, 1, 1, 0x12120018},
					{0x29, 1, 1, 0x00000407},
					{0x2a, 1, 1, 0x0a00003f},
					{0x2b, 1, 1, 0x0400003f},
					{0x2c, 1, 1, 0x0c0c0c0c},
					{0x2d, 1, 1, 0x56ee0000},
					{0x2e, 1, 1, 0x05555300},
					{0x2f, 1, 1, 0x050a0a00},
					{0x30, 1, 1, 0x03030303},
					{0x31, 1, 1, 0x24193c05},
					{0x32, 1, 1, 0x4b055014},
					{0x33, 1, 1, 0x00000000},
					{0x34, 1, 1, 0x00152100},
					{0x35, 1, 1, 0x06060600},
					{0x36, 1, 1, 0x03030303},
					{0x37, 1, 1, 0x24193c05},
					{0x38, 1, 1, 0x66635e24},
					{0x39, 1, 1, 0x00000000},
					{0x3a, 1, 1, 0x00002a94},
					{0x3b, 1, 1, 0x00202020},
					{0x3c, 1, 1, 0x00050503},
					{0x3d, 1, 1, 0x193c0560},
					{0x3e, 1, 1, 0x5f501400},
					{0x3f, 1, 1, 0x00002a94},
					{0x40, 1, 1, 0x00101010},
					{0x41, 1, 1, 0x00050503},
					{0x42, 1, 1, 0x193c0560},
					{0x43, 1, 1, 0x5f501400},
					{0x44, 1, 1, 0x03c0021c},
					{0x61, 1, 1, 0x060606ff},
					{0x62, 1, 1, 0x00000ffc},
					{0x63, 1, 1, 0x112020cc},
					{0x66, 1, 1, 0x00000000},
					{0x67, 1, 1, 0x0405050c},
					{0x68, 1, 1, 0x01040708},
					{0x69, 1, 1, 0x00000000},
					{0x6a, 1, 1, 0x000e000e},
					{0x6b, 1, 1, 0x0392281c},
					{0x6c, 1, 1, 0xffffc81e},
					{0x6d, 1, 1, 0x001832ff},
					{0x6e, 1, 1, 0xffffc81e},
					{0x6f, 1, 1, 0x001832ff},
					{0x70, 1, 1, 0x00000048},
					{0x71, 1, 1, 0xffffec20},
					{0x72, 1, 1, 0x000a2010},
					{0x73, 1, 1, 0xfec96420},
					{0x77, 1, 1, 0x000222ca},
					{0x78, 1, 1, 0x97659765},
					{0x79, 1, 1, 0x00249249},
					{0x7a, 1, 1, 0x00000000},
					{0x7b, 1, 1, 0x60a52f20},
					{0x7c, 1, 1, 0x60a52f27},
					{0x7d, 1, 1, 0x60a52f22},
					{0x7e, 1, 1, 0x56667ac8},
					{0x7f, 1, 1, 0x00000004},
				},
			},
		},
	},
	/*sharpness1 reg*/
	{
		0x52, 109,
		{/*index 0*/
			{
				{
					{0x00, 1, 1, 0x02d00240},
					{0x01, 1, 1, 0x0008143c},
					{0x02, 1, 1, 0x00000010},
					{0x05, 1, 1, 0x14323218},
					{0x06, 1, 1, 0x50845e00},
					{0x07, 1, 1, 0x14323218},
					{0x08, 1, 1, 0x508d5000},
					{0x09, 1, 1, 0x14323218},
					{0x0a, 1, 1, 0x3d3d1f00},
					{0x0b, 1, 1, 0x14323218},
					{0x0c, 1, 1, 0x38390c00},
					{0x0d, 1, 1, 0x22202220},
					{0x0e, 1, 1, 0x22202220},
					{0x0f, 1, 1, 0x00020202},
					{0x10, 1, 1, 0x00020202},
					{0x11, 1, 1, 0x00020202},
					{0x12, 1, 1, 0x00020202},
					{0x13, 1, 1, 0x38402840},
					{0x14, 1, 1, 0x0000103e},
					{0x15, 1, 1, 0x0a195040},
					{0x16, 1, 1, 0x3f003f00},
					{0x17, 1, 1, 0x0a195040},
					{0x18, 1, 1, 0x3f003f00},
					{0x19, 1, 1, 0x003f003f},
					{0x1a, 1, 1, 0x00000003},
					{0x1b, 1, 1, 0x00180014},
					{0x1c, 1, 1, 0x00103f00},
					{0x1d, 1, 1, 0x003f003f},
					{0x1e, 1, 1, 0x00010001},
					{0x1f, 1, 1, 0x0018000a},
					{0x20, 1, 1, 0x00402000},
					{0x21, 1, 1, 0x0000003f},
					{0x22, 1, 1, 0x00001414},
					{0x23, 1, 1, 0x08140214},
					{0x24, 1, 1, 0x08140214},
					{0x25, 1, 1, 0x2806c814},
					{0x26, 1, 1, 0x2203f03f},
					{0x27, 1, 1, 0x00000000},
					{0x28, 1, 1, 0x12120018},
					{0x29, 1, 1, 0x00000407},
					{0x2a, 1, 1, 0x0a00003f},
					{0x2b, 1, 1, 0x0400003f},
					{0x2c, 1, 1, 0x0c0c0c0c},
					{0x2d, 1, 1, 0x56ee0000},
					{0x2e, 1, 1, 0x05555300},
					{0x2f, 1, 1, 0x050a0a00},
					{0x30, 1, 1, 0x03030303},
					{0x31, 1, 1, 0x24193c05},
					{0x32, 1, 1, 0x4b055014},
					{0x33, 1, 1, 0x00000000},
					{0x34, 1, 1, 0x00152100},
					{0x35, 1, 1, 0x06060600},
					{0x36, 1, 1, 0x03030303},
					{0x37, 1, 1, 0x24193c05},
					{0x38, 1, 1, 0x66635e24},
					{0x39, 1, 1, 0x00000000},
					{0x3a, 1, 1, 0x00002a94},
					{0x3b, 1, 1, 0x00202020},
					{0x3c, 1, 1, 0x00050503},
					{0x3d, 1, 1, 0x193c0560},
					{0x3e, 1, 1, 0x5f501400},
					{0x3f, 1, 1, 0x00002a94},
					{0x40, 1, 1, 0x00101010},
					{0x41, 1, 1, 0x00050503},
					{0x42, 1, 1, 0x193c0560},
					{0x43, 1, 1, 0x5f501400},
					{0x44, 1, 1, 0x03c0021c},
					{0x58, 1, 1, 0x00004000},
					{0x59, 1, 1, 0xfc2424fc},
					{0x5a, 1, 1, 0x00004000},
					{0x5b, 1, 1, 0xfc2424fc},
					{0x5c, 1, 1, 0x00004000},
					{0x5d, 1, 1, 0xfc2424fc},
					{0x5e, 1, 1, 0x00004000},
					{0x5f, 1, 1, 0xfc2424fc},
					{0x60, 1, 1, 0x00000000},
					{0x61, 1, 1, 0x060606ff},
					{0x62, 1, 1, 0x00000ffc},
					{0x63, 1, 1, 0x112020cc},
					{0x64, 1, 1, 0x0000000f},
					{0x65, 1, 1, 0x0f0f4646},
					{0x66, 1, 1, 0x00000000},
					{0x67, 1, 1, 0x0405050c},
					{0x68, 1, 1, 0x01040708},
					{0x69, 1, 1, 0x00000000},
					{0x6a, 1, 1, 0x000e000e},
					{0x6b, 1, 1, 0x0392281c},
					{0x6c, 1, 1, 0xffffc81e},
					{0x6d, 1, 1, 0x001832ff},
					{0x6e, 1, 1, 0xffffc81e},
					{0x6f, 1, 1, 0x001832ff},
					{0x70, 1, 1, 0x00000048},
					{0x71, 1, 1, 0xffffec20},
					{0x72, 1, 1, 0x000a2010},
					{0x73, 1, 1, 0xfec96420},
					{0x74, 1, 1, 0x00054006},
					{0x75, 1, 1, 0x00808080},
					{0x77, 1, 1, 0x000222ca},
					{0x78, 1, 1, 0x97659765},
					{0x79, 1, 1, 0x00249249},
					{0x7a, 1, 1, 0x00000000},
					{0x7b, 1, 1, 0x60a52f20},
					{0x7c, 1, 1, 0x60a52f27},
					{0x7d, 1, 1, 0x60a52f22},
					{0x7e, 1, 1, 0x56667ac8},
					{0x7f, 1, 1, 0x00000004},
					{0x80, 1, 1, 0x56667ac8},
					{0x81, 1, 1, 0x00000004},
				},
			},
		},
	},
	/*local contrast reg*/
	{
		0x40, 8,
		{/*index 0*/
			{
				{
					{0x00, 1, 2, 0x00000110},
					{0x02, 1, 1, 0x00000614},
					{0x03, 1, 1, 0x00100018},
					{0x04, 1, 1, 0x0a14ffff},
					{0x05, 1, 1, 0x00004020},
					{0x06, 1, 1, 0x00002020},
					{0x07, 1, 3, 0x00010038},
					{0x09, 1, 1, 0x00000c60},
				},
			},
		},
	},
};

#endif

