#ifndef __SLI2151_FUN_H
#define __SLI2151_FUN_H

#include <linux/version.h>
#include <linux/i2c.h>
#include <linux/videodev2.h>
#include <uapi/linux/dvb/frontend.h>
#include "dvb_frontend.h"

#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 9, 0)
#include <linux/../../../drivers/amlogic/dvb_tv/aml_fe.h>
#else
#include <linux/amlogic/aml_tuner.h>
#endif

#define SI2151_VER "Si2159_1_1_build_11_5_API"
#define   Si2151_COMMAND_PROTOTYPES

#include "Si2151_L2_API.h"
#include "Si2151_Commands_Prototypes.h"
#include "Si2151_Properties.h"
#include "Si2151_Properties_Strings.h"

#define NO_SI2151_ERROR                     NO_Si2151_ERROR

#define si2151_cmdreplyobj_t Si2151_CmdReplyObj

typedef struct si2151_device_s{
    struct class *clsp;
    struct i2c_client tuner_client;
    L1_Si2151_Context *api;
    L1_Si2151_Context apiObj;
    struct analog_parameters parm;
    int fre_offset;
#if LINUX_VERSION_CODE >= KERNEL_VERSION(4, 9, 0)
    unsigned int if_inv;
    unsigned int if_freq;
#endif
}si2151_device_t;
extern struct si2151_device_s *si2151_devp;

#endif /* __SLI2151_FUN_H */
