// Copyright 2021 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=Glagolitic`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v14.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [
    0x000484,
    0x000487,
    0x002E43,
    0x00A66F
  ],
  ranges: [
    [0x002C00, 0x002C5F],
    [0x01E000, 0x01E006],
    [0x01E008, 0x01E018],
    [0x01E01B, 0x01E021],
    [0x01E023, 0x01E024],
    [0x01E026, 0x01E02A]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=Glagolitic}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Glagolitic}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Glag}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Glag}"
);
testPropertyEscapes(
  /^\p{scx=Glagolitic}+$/u,
  matchSymbols,
  "\\p{scx=Glagolitic}"
);
testPropertyEscapes(
  /^\p{scx=Glag}+$/u,
  matchSymbols,
  "\\p{scx=Glag}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [
    0x01E007,
    0x01E022,
    0x01E025
  ],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x000483],
    [0x000485, 0x000486],
    [0x000488, 0x002BFF],
    [0x002C60, 0x002E42],
    [0x002E44, 0x00A66E],
    [0x00A670, 0x00DBFF],
    [0x00E000, 0x01DFFF],
    [0x01E019, 0x01E01A],
    [0x01E02B, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=Glagolitic}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Glagolitic}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Glag}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Glag}"
);
testPropertyEscapes(
  /^\P{scx=Glagolitic}+$/u,
  nonMatchSymbols,
  "\\P{scx=Glagolitic}"
);
testPropertyEscapes(
  /^\P{scx=Glag}+$/u,
  nonMatchSymbols,
  "\\P{scx=Glag}"
);
