/*

    This file is part of libdvbcsa.

    libdvbcsa is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published
    by the Free Software Foundation; either version 2 of the License,
    or (at your option) any later version.

    libdvbcsa is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with libdvbcsa; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA

    (c) 2006-2011 Alexandre Becoulet <alexandre.becoulet@free.fr>
    (c) 2011 Erik Tews <e_tews at cdc.informatik.tu-darmstadt.de>
*/

#include "dvbcsa/dvbcsa.h"
#include "dvbcsa_pv.h"

static const uint64_t kperm[8][256] =
  {
    {
      0x0000000000000000ULL, 0x0000000000080000ULL, 0x0000000008000000ULL, 0x0000000008080000ULL,
      0x0080000000000000ULL, 0x0080000000080000ULL, 0x0080000008000000ULL, 0x0080000008080000ULL,
      0x0000400000000000ULL, 0x0000400000080000ULL, 0x0000400008000000ULL, 0x0000400008080000ULL,
      0x0080400000000000ULL, 0x0080400000080000ULL, 0x0080400008000000ULL, 0x0080400008080000ULL,
      0x0000000000000002ULL, 0x0000000000080002ULL, 0x0000000008000002ULL, 0x0000000008080002ULL,
      0x0080000000000002ULL, 0x0080000000080002ULL, 0x0080000008000002ULL, 0x0080000008080002ULL,
      0x0000400000000002ULL, 0x0000400000080002ULL, 0x0000400008000002ULL, 0x0000400008080002ULL,
      0x0080400000000002ULL, 0x0080400000080002ULL, 0x0080400008000002ULL, 0x0080400008080002ULL,
      0x0000000000008000ULL, 0x0000000000088000ULL, 0x0000000008008000ULL, 0x0000000008088000ULL,
      0x0080000000008000ULL, 0x0080000000088000ULL, 0x0080000008008000ULL, 0x0080000008088000ULL,
      0x0000400000008000ULL, 0x0000400000088000ULL, 0x0000400008008000ULL, 0x0000400008088000ULL,
      0x0080400000008000ULL, 0x0080400000088000ULL, 0x0080400008008000ULL, 0x0080400008088000ULL,
      0x0000000000008002ULL, 0x0000000000088002ULL, 0x0000000008008002ULL, 0x0000000008088002ULL,
      0x0080000000008002ULL, 0x0080000000088002ULL, 0x0080000008008002ULL, 0x0080000008088002ULL,
      0x0000400000008002ULL, 0x0000400000088002ULL, 0x0000400008008002ULL, 0x0000400008088002ULL,
      0x0080400000008002ULL, 0x0080400000088002ULL, 0x0080400008008002ULL, 0x0080400008088002ULL,
      0x0000001000000000ULL, 0x0000001000080000ULL, 0x0000001008000000ULL, 0x0000001008080000ULL,
      0x0080001000000000ULL, 0x0080001000080000ULL, 0x0080001008000000ULL, 0x0080001008080000ULL,
      0x0000401000000000ULL, 0x0000401000080000ULL, 0x0000401008000000ULL, 0x0000401008080000ULL,
      0x0080401000000000ULL, 0x0080401000080000ULL, 0x0080401008000000ULL, 0x0080401008080000ULL,
      0x0000001000000002ULL, 0x0000001000080002ULL, 0x0000001008000002ULL, 0x0000001008080002ULL,
      0x0080001000000002ULL, 0x0080001000080002ULL, 0x0080001008000002ULL, 0x0080001008080002ULL,
      0x0000401000000002ULL, 0x0000401000080002ULL, 0x0000401008000002ULL, 0x0000401008080002ULL,
      0x0080401000000002ULL, 0x0080401000080002ULL, 0x0080401008000002ULL, 0x0080401008080002ULL,
      0x0000001000008000ULL, 0x0000001000088000ULL, 0x0000001008008000ULL, 0x0000001008088000ULL,
      0x0080001000008000ULL, 0x0080001000088000ULL, 0x0080001008008000ULL, 0x0080001008088000ULL,
      0x0000401000008000ULL, 0x0000401000088000ULL, 0x0000401008008000ULL, 0x0000401008088000ULL,
      0x0080401000008000ULL, 0x0080401000088000ULL, 0x0080401008008000ULL, 0x0080401008088000ULL,
      0x0000001000008002ULL, 0x0000001000088002ULL, 0x0000001008008002ULL, 0x0000001008088002ULL,
      0x0080001000008002ULL, 0x0080001000088002ULL, 0x0080001008008002ULL, 0x0080001008088002ULL,
      0x0000401000008002ULL, 0x0000401000088002ULL, 0x0000401008008002ULL, 0x0000401008088002ULL,
      0x0080401000008002ULL, 0x0080401000088002ULL, 0x0080401008008002ULL, 0x0080401008088002ULL,
      0x0000000000400000ULL, 0x0000000000480000ULL, 0x0000000008400000ULL, 0x0000000008480000ULL,
      0x0080000000400000ULL, 0x0080000000480000ULL, 0x0080000008400000ULL, 0x0080000008480000ULL,
      0x0000400000400000ULL, 0x0000400000480000ULL, 0x0000400008400000ULL, 0x0000400008480000ULL,
      0x0080400000400000ULL, 0x0080400000480000ULL, 0x0080400008400000ULL, 0x0080400008480000ULL,
      0x0000000000400002ULL, 0x0000000000480002ULL, 0x0000000008400002ULL, 0x0000000008480002ULL,
      0x0080000000400002ULL, 0x0080000000480002ULL, 0x0080000008400002ULL, 0x0080000008480002ULL,
      0x0000400000400002ULL, 0x0000400000480002ULL, 0x0000400008400002ULL, 0x0000400008480002ULL,
      0x0080400000400002ULL, 0x0080400000480002ULL, 0x0080400008400002ULL, 0x0080400008480002ULL,
      0x0000000000408000ULL, 0x0000000000488000ULL, 0x0000000008408000ULL, 0x0000000008488000ULL,
      0x0080000000408000ULL, 0x0080000000488000ULL, 0x0080000008408000ULL, 0x0080000008488000ULL,
      0x0000400000408000ULL, 0x0000400000488000ULL, 0x0000400008408000ULL, 0x0000400008488000ULL,
      0x0080400000408000ULL, 0x0080400000488000ULL, 0x0080400008408000ULL, 0x0080400008488000ULL,
      0x0000000000408002ULL, 0x0000000000488002ULL, 0x0000000008408002ULL, 0x0000000008488002ULL,
      0x0080000000408002ULL, 0x0080000000488002ULL, 0x0080000008408002ULL, 0x0080000008488002ULL,
      0x0000400000408002ULL, 0x0000400000488002ULL, 0x0000400008408002ULL, 0x0000400008488002ULL,
      0x0080400000408002ULL, 0x0080400000488002ULL, 0x0080400008408002ULL, 0x0080400008488002ULL,
      0x0000001000400000ULL, 0x0000001000480000ULL, 0x0000001008400000ULL, 0x0000001008480000ULL,
      0x0080001000400000ULL, 0x0080001000480000ULL, 0x0080001008400000ULL, 0x0080001008480000ULL,
      0x0000401000400000ULL, 0x0000401000480000ULL, 0x0000401008400000ULL, 0x0000401008480000ULL,
      0x0080401000400000ULL, 0x0080401000480000ULL, 0x0080401008400000ULL, 0x0080401008480000ULL,
      0x0000001000400002ULL, 0x0000001000480002ULL, 0x0000001008400002ULL, 0x0000001008480002ULL,
      0x0080001000400002ULL, 0x0080001000480002ULL, 0x0080001008400002ULL, 0x0080001008480002ULL,
      0x0000401000400002ULL, 0x0000401000480002ULL, 0x0000401008400002ULL, 0x0000401008480002ULL,
      0x0080401000400002ULL, 0x0080401000480002ULL, 0x0080401008400002ULL, 0x0080401008480002ULL,
      0x0000001000408000ULL, 0x0000001000488000ULL, 0x0000001008408000ULL, 0x0000001008488000ULL,
      0x0080001000408000ULL, 0x0080001000488000ULL, 0x0080001008408000ULL, 0x0080001008488000ULL,
      0x0000401000408000ULL, 0x0000401000488000ULL, 0x0000401008408000ULL, 0x0000401008488000ULL,
      0x0080401000408000ULL, 0x0080401000488000ULL, 0x0080401008408000ULL, 0x0080401008488000ULL,
      0x0000001000408002ULL, 0x0000001000488002ULL, 0x0000001008408002ULL, 0x0000001008488002ULL,
      0x0080001000408002ULL, 0x0080001000488002ULL, 0x0080001008408002ULL, 0x0080001008488002ULL,
      0x0000401000408002ULL, 0x0000401000488002ULL, 0x0000401008408002ULL, 0x0000401008488002ULL,
      0x0080401000408002ULL, 0x0080401000488002ULL, 0x0080401008408002ULL, 0x0080401008488002ULL,
    },
    {
      0x0000000000000000ULL, 0x0100000000000000ULL, 0x2000000000000000ULL, 0x2100000000000000ULL,
      0x0000008000000000ULL, 0x0100008000000000ULL, 0x2000008000000000ULL, 0x2100008000000000ULL,
      0x0000000000200000ULL, 0x0100000000200000ULL, 0x2000000000200000ULL, 0x2100000000200000ULL,
      0x0000008000200000ULL, 0x0100008000200000ULL, 0x2000008000200000ULL, 0x2100008000200000ULL,
      0x0040000000000000ULL, 0x0140000000000000ULL, 0x2040000000000000ULL, 0x2140000000000000ULL,
      0x0040008000000000ULL, 0x0140008000000000ULL, 0x2040008000000000ULL, 0x2140008000000000ULL,
      0x0040000000200000ULL, 0x0140000000200000ULL, 0x2040000000200000ULL, 0x2140000000200000ULL,
      0x0040008000200000ULL, 0x0140008000200000ULL, 0x2040008000200000ULL, 0x2140008000200000ULL,
      0x0400000000000000ULL, 0x0500000000000000ULL, 0x2400000000000000ULL, 0x2500000000000000ULL,
      0x0400008000000000ULL, 0x0500008000000000ULL, 0x2400008000000000ULL, 0x2500008000000000ULL,
      0x0400000000200000ULL, 0x0500000000200000ULL, 0x2400000000200000ULL, 0x2500000000200000ULL,
      0x0400008000200000ULL, 0x0500008000200000ULL, 0x2400008000200000ULL, 0x2500008000200000ULL,
      0x0440000000000000ULL, 0x0540000000000000ULL, 0x2440000000000000ULL, 0x2540000000000000ULL,
      0x0440008000000000ULL, 0x0540008000000000ULL, 0x2440008000000000ULL, 0x2540008000000000ULL,
      0x0440000000200000ULL, 0x0540000000200000ULL, 0x2440000000200000ULL, 0x2540000000200000ULL,
      0x0440008000200000ULL, 0x0540008000200000ULL, 0x2440008000200000ULL, 0x2540008000200000ULL,
      0x0004000000000000ULL, 0x0104000000000000ULL, 0x2004000000000000ULL, 0x2104000000000000ULL,
      0x0004008000000000ULL, 0x0104008000000000ULL, 0x2004008000000000ULL, 0x2104008000000000ULL,
      0x0004000000200000ULL, 0x0104000000200000ULL, 0x2004000000200000ULL, 0x2104000000200000ULL,
      0x0004008000200000ULL, 0x0104008000200000ULL, 0x2004008000200000ULL, 0x2104008000200000ULL,
      0x0044000000000000ULL, 0x0144000000000000ULL, 0x2044000000000000ULL, 0x2144000000000000ULL,
      0x0044008000000000ULL, 0x0144008000000000ULL, 0x2044008000000000ULL, 0x2144008000000000ULL,
      0x0044000000200000ULL, 0x0144000000200000ULL, 0x2044000000200000ULL, 0x2144000000200000ULL,
      0x0044008000200000ULL, 0x0144008000200000ULL, 0x2044008000200000ULL, 0x2144008000200000ULL,
      0x0404000000000000ULL, 0x0504000000000000ULL, 0x2404000000000000ULL, 0x2504000000000000ULL,
      0x0404008000000000ULL, 0x0504008000000000ULL, 0x2404008000000000ULL, 0x2504008000000000ULL,
      0x0404000000200000ULL, 0x0504000000200000ULL, 0x2404000000200000ULL, 0x2504000000200000ULL,
      0x0404008000200000ULL, 0x0504008000200000ULL, 0x2404008000200000ULL, 0x2504008000200000ULL,
      0x0444000000000000ULL, 0x0544000000000000ULL, 0x2444000000000000ULL, 0x2544000000000000ULL,
      0x0444008000000000ULL, 0x0544008000000000ULL, 0x2444008000000000ULL, 0x2544008000000000ULL,
      0x0444000000200000ULL, 0x0544000000200000ULL, 0x2444000000200000ULL, 0x2544000000200000ULL,
      0x0444008000200000ULL, 0x0544008000200000ULL, 0x2444008000200000ULL, 0x2544008000200000ULL,
      0x0000000010000000ULL, 0x0100000010000000ULL, 0x2000000010000000ULL, 0x2100000010000000ULL,
      0x0000008010000000ULL, 0x0100008010000000ULL, 0x2000008010000000ULL, 0x2100008010000000ULL,
      0x0000000010200000ULL, 0x0100000010200000ULL, 0x2000000010200000ULL, 0x2100000010200000ULL,
      0x0000008010200000ULL, 0x0100008010200000ULL, 0x2000008010200000ULL, 0x2100008010200000ULL,
      0x0040000010000000ULL, 0x0140000010000000ULL, 0x2040000010000000ULL, 0x2140000010000000ULL,
      0x0040008010000000ULL, 0x0140008010000000ULL, 0x2040008010000000ULL, 0x2140008010000000ULL,
      0x0040000010200000ULL, 0x0140000010200000ULL, 0x2040000010200000ULL, 0x2140000010200000ULL,
      0x0040008010200000ULL, 0x0140008010200000ULL, 0x2040008010200000ULL, 0x2140008010200000ULL,
      0x0400000010000000ULL, 0x0500000010000000ULL, 0x2400000010000000ULL, 0x2500000010000000ULL,
      0x0400008010000000ULL, 0x0500008010000000ULL, 0x2400008010000000ULL, 0x2500008010000000ULL,
      0x0400000010200000ULL, 0x0500000010200000ULL, 0x2400000010200000ULL, 0x2500000010200000ULL,
      0x0400008010200000ULL, 0x0500008010200000ULL, 0x2400008010200000ULL, 0x2500008010200000ULL,
      0x0440000010000000ULL, 0x0540000010000000ULL, 0x2440000010000000ULL, 0x2540000010000000ULL,
      0x0440008010000000ULL, 0x0540008010000000ULL, 0x2440008010000000ULL, 0x2540008010000000ULL,
      0x0440000010200000ULL, 0x0540000010200000ULL, 0x2440000010200000ULL, 0x2540000010200000ULL,
      0x0440008010200000ULL, 0x0540008010200000ULL, 0x2440008010200000ULL, 0x2540008010200000ULL,
      0x0004000010000000ULL, 0x0104000010000000ULL, 0x2004000010000000ULL, 0x2104000010000000ULL,
      0x0004008010000000ULL, 0x0104008010000000ULL, 0x2004008010000000ULL, 0x2104008010000000ULL,
      0x0004000010200000ULL, 0x0104000010200000ULL, 0x2004000010200000ULL, 0x2104000010200000ULL,
      0x0004008010200000ULL, 0x0104008010200000ULL, 0x2004008010200000ULL, 0x2104008010200000ULL,
      0x0044000010000000ULL, 0x0144000010000000ULL, 0x2044000010000000ULL, 0x2144000010000000ULL,
      0x0044008010000000ULL, 0x0144008010000000ULL, 0x2044008010000000ULL, 0x2144008010000000ULL,
      0x0044000010200000ULL, 0x0144000010200000ULL, 0x2044000010200000ULL, 0x2144000010200000ULL,
      0x0044008010200000ULL, 0x0144008010200000ULL, 0x2044008010200000ULL, 0x2144008010200000ULL,
      0x0404000010000000ULL, 0x0504000010000000ULL, 0x2404000010000000ULL, 0x2504000010000000ULL,
      0x0404008010000000ULL, 0x0504008010000000ULL, 0x2404008010000000ULL, 0x2504008010000000ULL,
      0x0404000010200000ULL, 0x0504000010200000ULL, 0x2404000010200000ULL, 0x2504000010200000ULL,
      0x0404008010200000ULL, 0x0504008010200000ULL, 0x2404008010200000ULL, 0x2504008010200000ULL,
      0x0444000010000000ULL, 0x0544000010000000ULL, 0x2444000010000000ULL, 0x2544000010000000ULL,
      0x0444008010000000ULL, 0x0544008010000000ULL, 0x2444008010000000ULL, 0x2544008010000000ULL,
      0x0444000010200000ULL, 0x0544000010200000ULL, 0x2444000010200000ULL, 0x2544000010200000ULL,
      0x0444008010200000ULL, 0x0544008010200000ULL, 0x2444008010200000ULL, 0x2544008010200000ULL,
    },
    {
      0x0000000000000000ULL, 0x0000000000000080ULL, 0x0000000020000000ULL, 0x0000000020000080ULL,
      0x0008000000000000ULL, 0x0008000000000080ULL, 0x0008000020000000ULL, 0x0008000020000080ULL,
      0x0000000000000040ULL, 0x00000000000000c0ULL, 0x0000000020000040ULL, 0x00000000200000c0ULL,
      0x0008000000000040ULL, 0x00080000000000c0ULL, 0x0008000020000040ULL, 0x00080000200000c0ULL,
      0x0000000200000000ULL, 0x0000000200000080ULL, 0x0000000220000000ULL, 0x0000000220000080ULL,
      0x0008000200000000ULL, 0x0008000200000080ULL, 0x0008000220000000ULL, 0x0008000220000080ULL,
      0x0000000200000040ULL, 0x00000002000000c0ULL, 0x0000000220000040ULL, 0x00000002200000c0ULL,
      0x0008000200000040ULL, 0x00080002000000c0ULL, 0x0008000220000040ULL, 0x00080002200000c0ULL,
      0x0000000800000000ULL, 0x0000000800000080ULL, 0x0000000820000000ULL, 0x0000000820000080ULL,
      0x0008000800000000ULL, 0x0008000800000080ULL, 0x0008000820000000ULL, 0x0008000820000080ULL,
      0x0000000800000040ULL, 0x00000008000000c0ULL, 0x0000000820000040ULL, 0x00000008200000c0ULL,
      0x0008000800000040ULL, 0x00080008000000c0ULL, 0x0008000820000040ULL, 0x00080008200000c0ULL,
      0x0000000a00000000ULL, 0x0000000a00000080ULL, 0x0000000a20000000ULL, 0x0000000a20000080ULL,
      0x0008000a00000000ULL, 0x0008000a00000080ULL, 0x0008000a20000000ULL, 0x0008000a20000080ULL,
      0x0000000a00000040ULL, 0x0000000a000000c0ULL, 0x0000000a20000040ULL, 0x0000000a200000c0ULL,
      0x0008000a00000040ULL, 0x0008000a000000c0ULL, 0x0008000a20000040ULL, 0x0008000a200000c0ULL,
      0x0000000000100000ULL, 0x0000000000100080ULL, 0x0000000020100000ULL, 0x0000000020100080ULL,
      0x0008000000100000ULL, 0x0008000000100080ULL, 0x0008000020100000ULL, 0x0008000020100080ULL,
      0x0000000000100040ULL, 0x00000000001000c0ULL, 0x0000000020100040ULL, 0x00000000201000c0ULL,
      0x0008000000100040ULL, 0x00080000001000c0ULL, 0x0008000020100040ULL, 0x00080000201000c0ULL,
      0x0000000200100000ULL, 0x0000000200100080ULL, 0x0000000220100000ULL, 0x0000000220100080ULL,
      0x0008000200100000ULL, 0x0008000200100080ULL, 0x0008000220100000ULL, 0x0008000220100080ULL,
      0x0000000200100040ULL, 0x00000002001000c0ULL, 0x0000000220100040ULL, 0x00000002201000c0ULL,
      0x0008000200100040ULL, 0x00080002001000c0ULL, 0x0008000220100040ULL, 0x00080002201000c0ULL,
      0x0000000800100000ULL, 0x0000000800100080ULL, 0x0000000820100000ULL, 0x0000000820100080ULL,
      0x0008000800100000ULL, 0x0008000800100080ULL, 0x0008000820100000ULL, 0x0008000820100080ULL,
      0x0000000800100040ULL, 0x00000008001000c0ULL, 0x0000000820100040ULL, 0x00000008201000c0ULL,
      0x0008000800100040ULL, 0x00080008001000c0ULL, 0x0008000820100040ULL, 0x00080008201000c0ULL,
      0x0000000a00100000ULL, 0x0000000a00100080ULL, 0x0000000a20100000ULL, 0x0000000a20100080ULL,
      0x0008000a00100000ULL, 0x0008000a00100080ULL, 0x0008000a20100000ULL, 0x0008000a20100080ULL,
      0x0000000a00100040ULL, 0x0000000a001000c0ULL, 0x0000000a20100040ULL, 0x0000000a201000c0ULL,
      0x0008000a00100040ULL, 0x0008000a001000c0ULL, 0x0008000a20100040ULL, 0x0008000a201000c0ULL,
      0x0000000000010000ULL, 0x0000000000010080ULL, 0x0000000020010000ULL, 0x0000000020010080ULL,
      0x0008000000010000ULL, 0x0008000000010080ULL, 0x0008000020010000ULL, 0x0008000020010080ULL,
      0x0000000000010040ULL, 0x00000000000100c0ULL, 0x0000000020010040ULL, 0x00000000200100c0ULL,
      0x0008000000010040ULL, 0x00080000000100c0ULL, 0x0008000020010040ULL, 0x00080000200100c0ULL,
      0x0000000200010000ULL, 0x0000000200010080ULL, 0x0000000220010000ULL, 0x0000000220010080ULL,
      0x0008000200010000ULL, 0x0008000200010080ULL, 0x0008000220010000ULL, 0x0008000220010080ULL,
      0x0000000200010040ULL, 0x00000002000100c0ULL, 0x0000000220010040ULL, 0x00000002200100c0ULL,
      0x0008000200010040ULL, 0x00080002000100c0ULL, 0x0008000220010040ULL, 0x00080002200100c0ULL,
      0x0000000800010000ULL, 0x0000000800010080ULL, 0x0000000820010000ULL, 0x0000000820010080ULL,
      0x0008000800010000ULL, 0x0008000800010080ULL, 0x0008000820010000ULL, 0x0008000820010080ULL,
      0x0000000800010040ULL, 0x00000008000100c0ULL, 0x0000000820010040ULL, 0x00000008200100c0ULL,
      0x0008000800010040ULL, 0x00080008000100c0ULL, 0x0008000820010040ULL, 0x00080008200100c0ULL,
      0x0000000a00010000ULL, 0x0000000a00010080ULL, 0x0000000a20010000ULL, 0x0000000a20010080ULL,
      0x0008000a00010000ULL, 0x0008000a00010080ULL, 0x0008000a20010000ULL, 0x0008000a20010080ULL,
      0x0000000a00010040ULL, 0x0000000a000100c0ULL, 0x0000000a20010040ULL, 0x0000000a200100c0ULL,
      0x0008000a00010040ULL, 0x0008000a000100c0ULL, 0x0008000a20010040ULL, 0x0008000a200100c0ULL,
      0x0000000000110000ULL, 0x0000000000110080ULL, 0x0000000020110000ULL, 0x0000000020110080ULL,
      0x0008000000110000ULL, 0x0008000000110080ULL, 0x0008000020110000ULL, 0x0008000020110080ULL,
      0x0000000000110040ULL, 0x00000000001100c0ULL, 0x0000000020110040ULL, 0x00000000201100c0ULL,
      0x0008000000110040ULL, 0x00080000001100c0ULL, 0x0008000020110040ULL, 0x00080000201100c0ULL,
      0x0000000200110000ULL, 0x0000000200110080ULL, 0x0000000220110000ULL, 0x0000000220110080ULL,
      0x0008000200110000ULL, 0x0008000200110080ULL, 0x0008000220110000ULL, 0x0008000220110080ULL,
      0x0000000200110040ULL, 0x00000002001100c0ULL, 0x0000000220110040ULL, 0x00000002201100c0ULL,
      0x0008000200110040ULL, 0x00080002001100c0ULL, 0x0008000220110040ULL, 0x00080002201100c0ULL,
      0x0000000800110000ULL, 0x0000000800110080ULL, 0x0000000820110000ULL, 0x0000000820110080ULL,
      0x0008000800110000ULL, 0x0008000800110080ULL, 0x0008000820110000ULL, 0x0008000820110080ULL,
      0x0000000800110040ULL, 0x00000008001100c0ULL, 0x0000000820110040ULL, 0x00000008201100c0ULL,
      0x0008000800110040ULL, 0x00080008001100c0ULL, 0x0008000820110040ULL, 0x00080008201100c0ULL,
      0x0000000a00110000ULL, 0x0000000a00110080ULL, 0x0000000a20110000ULL, 0x0000000a20110080ULL,
      0x0008000a00110000ULL, 0x0008000a00110080ULL, 0x0008000a20110000ULL, 0x0008000a20110080ULL,
      0x0000000a00110040ULL, 0x0000000a001100c0ULL, 0x0000000a20110040ULL, 0x0000000a201100c0ULL,
      0x0008000a00110040ULL, 0x0008000a001100c0ULL, 0x0008000a20110040ULL, 0x0008000a201100c0ULL,
    },
    {
      0x0000000000000000ULL, 0x0000800000000000ULL, 0x0000000040000000ULL, 0x0000800040000000ULL,
      0x0000000100000000ULL, 0x0000800100000000ULL, 0x0000000140000000ULL, 0x0000800140000000ULL,
      0x8000000000000000ULL, 0x8000800000000000ULL, 0x8000000040000000ULL, 0x8000800040000000ULL,
      0x8000000100000000ULL, 0x8000800100000000ULL, 0x8000000140000000ULL, 0x8000800140000000ULL,
      0x0000000000000400ULL, 0x0000800000000400ULL, 0x0000000040000400ULL, 0x0000800040000400ULL,
      0x0000000100000400ULL, 0x0000800100000400ULL, 0x0000000140000400ULL, 0x0000800140000400ULL,
      0x8000000000000400ULL, 0x8000800000000400ULL, 0x8000000040000400ULL, 0x8000800040000400ULL,
      0x8000000100000400ULL, 0x8000800100000400ULL, 0x8000000140000400ULL, 0x8000800140000400ULL,
      0x0000000000000800ULL, 0x0000800000000800ULL, 0x0000000040000800ULL, 0x0000800040000800ULL,
      0x0000000100000800ULL, 0x0000800100000800ULL, 0x0000000140000800ULL, 0x0000800140000800ULL,
      0x8000000000000800ULL, 0x8000800000000800ULL, 0x8000000040000800ULL, 0x8000800040000800ULL,
      0x8000000100000800ULL, 0x8000800100000800ULL, 0x8000000140000800ULL, 0x8000800140000800ULL,
      0x0000000000000c00ULL, 0x0000800000000c00ULL, 0x0000000040000c00ULL, 0x0000800040000c00ULL,
      0x0000000100000c00ULL, 0x0000800100000c00ULL, 0x0000000140000c00ULL, 0x0000800140000c00ULL,
      0x8000000000000c00ULL, 0x8000800000000c00ULL, 0x8000000040000c00ULL, 0x8000800040000c00ULL,
      0x8000000100000c00ULL, 0x8000800100000c00ULL, 0x8000000140000c00ULL, 0x8000800140000c00ULL,
      0x0000000000000010ULL, 0x0000800000000010ULL, 0x0000000040000010ULL, 0x0000800040000010ULL,
      0x0000000100000010ULL, 0x0000800100000010ULL, 0x0000000140000010ULL, 0x0000800140000010ULL,
      0x8000000000000010ULL, 0x8000800000000010ULL, 0x8000000040000010ULL, 0x8000800040000010ULL,
      0x8000000100000010ULL, 0x8000800100000010ULL, 0x8000000140000010ULL, 0x8000800140000010ULL,
      0x0000000000000410ULL, 0x0000800000000410ULL, 0x0000000040000410ULL, 0x0000800040000410ULL,
      0x0000000100000410ULL, 0x0000800100000410ULL, 0x0000000140000410ULL, 0x0000800140000410ULL,
      0x8000000000000410ULL, 0x8000800000000410ULL, 0x8000000040000410ULL, 0x8000800040000410ULL,
      0x8000000100000410ULL, 0x8000800100000410ULL, 0x8000000140000410ULL, 0x8000800140000410ULL,
      0x0000000000000810ULL, 0x0000800000000810ULL, 0x0000000040000810ULL, 0x0000800040000810ULL,
      0x0000000100000810ULL, 0x0000800100000810ULL, 0x0000000140000810ULL, 0x0000800140000810ULL,
      0x8000000000000810ULL, 0x8000800000000810ULL, 0x8000000040000810ULL, 0x8000800040000810ULL,
      0x8000000100000810ULL, 0x8000800100000810ULL, 0x8000000140000810ULL, 0x8000800140000810ULL,
      0x0000000000000c10ULL, 0x0000800000000c10ULL, 0x0000000040000c10ULL, 0x0000800040000c10ULL,
      0x0000000100000c10ULL, 0x0000800100000c10ULL, 0x0000000140000c10ULL, 0x0000800140000c10ULL,
      0x8000000000000c10ULL, 0x8000800000000c10ULL, 0x8000000040000c10ULL, 0x8000800040000c10ULL,
      0x8000000100000c10ULL, 0x8000800100000c10ULL, 0x8000000140000c10ULL, 0x8000800140000c10ULL,
      0x0000004000000000ULL, 0x0000804000000000ULL, 0x0000004040000000ULL, 0x0000804040000000ULL,
      0x0000004100000000ULL, 0x0000804100000000ULL, 0x0000004140000000ULL, 0x0000804140000000ULL,
      0x8000004000000000ULL, 0x8000804000000000ULL, 0x8000004040000000ULL, 0x8000804040000000ULL,
      0x8000004100000000ULL, 0x8000804100000000ULL, 0x8000004140000000ULL, 0x8000804140000000ULL,
      0x0000004000000400ULL, 0x0000804000000400ULL, 0x0000004040000400ULL, 0x0000804040000400ULL,
      0x0000004100000400ULL, 0x0000804100000400ULL, 0x0000004140000400ULL, 0x0000804140000400ULL,
      0x8000004000000400ULL, 0x8000804000000400ULL, 0x8000004040000400ULL, 0x8000804040000400ULL,
      0x8000004100000400ULL, 0x8000804100000400ULL, 0x8000004140000400ULL, 0x8000804140000400ULL,
      0x0000004000000800ULL, 0x0000804000000800ULL, 0x0000004040000800ULL, 0x0000804040000800ULL,
      0x0000004100000800ULL, 0x0000804100000800ULL, 0x0000004140000800ULL, 0x0000804140000800ULL,
      0x8000004000000800ULL, 0x8000804000000800ULL, 0x8000004040000800ULL, 0x8000804040000800ULL,
      0x8000004100000800ULL, 0x8000804100000800ULL, 0x8000004140000800ULL, 0x8000804140000800ULL,
      0x0000004000000c00ULL, 0x0000804000000c00ULL, 0x0000004040000c00ULL, 0x0000804040000c00ULL,
      0x0000004100000c00ULL, 0x0000804100000c00ULL, 0x0000004140000c00ULL, 0x0000804140000c00ULL,
      0x8000004000000c00ULL, 0x8000804000000c00ULL, 0x8000004040000c00ULL, 0x8000804040000c00ULL,
      0x8000004100000c00ULL, 0x8000804100000c00ULL, 0x8000004140000c00ULL, 0x8000804140000c00ULL,
      0x0000004000000010ULL, 0x0000804000000010ULL, 0x0000004040000010ULL, 0x0000804040000010ULL,
      0x0000004100000010ULL, 0x0000804100000010ULL, 0x0000004140000010ULL, 0x0000804140000010ULL,
      0x8000004000000010ULL, 0x8000804000000010ULL, 0x8000004040000010ULL, 0x8000804040000010ULL,
      0x8000004100000010ULL, 0x8000804100000010ULL, 0x8000004140000010ULL, 0x8000804140000010ULL,
      0x0000004000000410ULL, 0x0000804000000410ULL, 0x0000004040000410ULL, 0x0000804040000410ULL,
      0x0000004100000410ULL, 0x0000804100000410ULL, 0x0000004140000410ULL, 0x0000804140000410ULL,
      0x8000004000000410ULL, 0x8000804000000410ULL, 0x8000004040000410ULL, 0x8000804040000410ULL,
      0x8000004100000410ULL, 0x8000804100000410ULL, 0x8000004140000410ULL, 0x8000804140000410ULL,
      0x0000004000000810ULL, 0x0000804000000810ULL, 0x0000004040000810ULL, 0x0000804040000810ULL,
      0x0000004100000810ULL, 0x0000804100000810ULL, 0x0000004140000810ULL, 0x0000804140000810ULL,
      0x8000004000000810ULL, 0x8000804000000810ULL, 0x8000004040000810ULL, 0x8000804040000810ULL,
      0x8000004100000810ULL, 0x8000804100000810ULL, 0x8000004140000810ULL, 0x8000804140000810ULL,
      0x0000004000000c10ULL, 0x0000804000000c10ULL, 0x0000004040000c10ULL, 0x0000804040000c10ULL,
      0x0000004100000c10ULL, 0x0000804100000c10ULL, 0x0000004140000c10ULL, 0x0000804140000c10ULL,
      0x8000004000000c10ULL, 0x8000804000000c10ULL, 0x8000004040000c10ULL, 0x8000804040000c10ULL,
      0x8000004100000c10ULL, 0x8000804100000c10ULL, 0x8000004140000c10ULL, 0x8000804140000c10ULL,
    },
    {
      0x0000000000000000ULL, 0x4000000000000000ULL, 0x0000000004000000ULL, 0x4000000004000000ULL,
      0x0000010000000000ULL, 0x4000010000000000ULL, 0x0000010004000000ULL, 0x4000010004000000ULL,
      0x0000000000040000ULL, 0x4000000000040000ULL, 0x0000000004040000ULL, 0x4000000004040000ULL,
      0x0000010000040000ULL, 0x4000010000040000ULL, 0x0000010004040000ULL, 0x4000010004040000ULL,
      0x0000000000001000ULL, 0x4000000000001000ULL, 0x0000000004001000ULL, 0x4000000004001000ULL,
      0x0000010000001000ULL, 0x4000010000001000ULL, 0x0000010004001000ULL, 0x4000010004001000ULL,
      0x0000000000041000ULL, 0x4000000000041000ULL, 0x0000000004041000ULL, 0x4000000004041000ULL,
      0x0000010000041000ULL, 0x4000010000041000ULL, 0x0000010004041000ULL, 0x4000010004041000ULL,
      0x0010000000000000ULL, 0x4010000000000000ULL, 0x0010000004000000ULL, 0x4010000004000000ULL,
      0x0010010000000000ULL, 0x4010010000000000ULL, 0x0010010004000000ULL, 0x4010010004000000ULL,
      0x0010000000040000ULL, 0x4010000000040000ULL, 0x0010000004040000ULL, 0x4010000004040000ULL,
      0x0010010000040000ULL, 0x4010010000040000ULL, 0x0010010004040000ULL, 0x4010010004040000ULL,
      0x0010000000001000ULL, 0x4010000000001000ULL, 0x0010000004001000ULL, 0x4010000004001000ULL,
      0x0010010000001000ULL, 0x4010010000001000ULL, 0x0010010004001000ULL, 0x4010010004001000ULL,
      0x0010000000041000ULL, 0x4010000000041000ULL, 0x0010000004041000ULL, 0x4010000004041000ULL,
      0x0010010000041000ULL, 0x4010010000041000ULL, 0x0010010004041000ULL, 0x4010010004041000ULL,
      0x0000002000000000ULL, 0x4000002000000000ULL, 0x0000002004000000ULL, 0x4000002004000000ULL,
      0x0000012000000000ULL, 0x4000012000000000ULL, 0x0000012004000000ULL, 0x4000012004000000ULL,
      0x0000002000040000ULL, 0x4000002000040000ULL, 0x0000002004040000ULL, 0x4000002004040000ULL,
      0x0000012000040000ULL, 0x4000012000040000ULL, 0x0000012004040000ULL, 0x4000012004040000ULL,
      0x0000002000001000ULL, 0x4000002000001000ULL, 0x0000002004001000ULL, 0x4000002004001000ULL,
      0x0000012000001000ULL, 0x4000012000001000ULL, 0x0000012004001000ULL, 0x4000012004001000ULL,
      0x0000002000041000ULL, 0x4000002000041000ULL, 0x0000002004041000ULL, 0x4000002004041000ULL,
      0x0000012000041000ULL, 0x4000012000041000ULL, 0x0000012004041000ULL, 0x4000012004041000ULL,
      0x0010002000000000ULL, 0x4010002000000000ULL, 0x0010002004000000ULL, 0x4010002004000000ULL,
      0x0010012000000000ULL, 0x4010012000000000ULL, 0x0010012004000000ULL, 0x4010012004000000ULL,
      0x0010002000040000ULL, 0x4010002000040000ULL, 0x0010002004040000ULL, 0x4010002004040000ULL,
      0x0010012000040000ULL, 0x4010012000040000ULL, 0x0010012004040000ULL, 0x4010012004040000ULL,
      0x0010002000001000ULL, 0x4010002000001000ULL, 0x0010002004001000ULL, 0x4010002004001000ULL,
      0x0010012000001000ULL, 0x4010012000001000ULL, 0x0010012004001000ULL, 0x4010012004001000ULL,
      0x0010002000041000ULL, 0x4010002000041000ULL, 0x0010002004041000ULL, 0x4010002004041000ULL,
      0x0010012000041000ULL, 0x4010012000041000ULL, 0x0010012004041000ULL, 0x4010012004041000ULL,
      0x0020000000000000ULL, 0x4020000000000000ULL, 0x0020000004000000ULL, 0x4020000004000000ULL,
      0x0020010000000000ULL, 0x4020010000000000ULL, 0x0020010004000000ULL, 0x4020010004000000ULL,
      0x0020000000040000ULL, 0x4020000000040000ULL, 0x0020000004040000ULL, 0x4020000004040000ULL,
      0x0020010000040000ULL, 0x4020010000040000ULL, 0x0020010004040000ULL, 0x4020010004040000ULL,
      0x0020000000001000ULL, 0x4020000000001000ULL, 0x0020000004001000ULL, 0x4020000004001000ULL,
      0x0020010000001000ULL, 0x4020010000001000ULL, 0x0020010004001000ULL, 0x4020010004001000ULL,
      0x0020000000041000ULL, 0x4020000000041000ULL, 0x0020000004041000ULL, 0x4020000004041000ULL,
      0x0020010000041000ULL, 0x4020010000041000ULL, 0x0020010004041000ULL, 0x4020010004041000ULL,
      0x0030000000000000ULL, 0x4030000000000000ULL, 0x0030000004000000ULL, 0x4030000004000000ULL,
      0x0030010000000000ULL, 0x4030010000000000ULL, 0x0030010004000000ULL, 0x4030010004000000ULL,
      0x0030000000040000ULL, 0x4030000000040000ULL, 0x0030000004040000ULL, 0x4030000004040000ULL,
      0x0030010000040000ULL, 0x4030010000040000ULL, 0x0030010004040000ULL, 0x4030010004040000ULL,
      0x0030000000001000ULL, 0x4030000000001000ULL, 0x0030000004001000ULL, 0x4030000004001000ULL,
      0x0030010000001000ULL, 0x4030010000001000ULL, 0x0030010004001000ULL, 0x4030010004001000ULL,
      0x0030000000041000ULL, 0x4030000000041000ULL, 0x0030000004041000ULL, 0x4030000004041000ULL,
      0x0030010000041000ULL, 0x4030010000041000ULL, 0x0030010004041000ULL, 0x4030010004041000ULL,
      0x0020002000000000ULL, 0x4020002000000000ULL, 0x0020002004000000ULL, 0x4020002004000000ULL,
      0x0020012000000000ULL, 0x4020012000000000ULL, 0x0020012004000000ULL, 0x4020012004000000ULL,
      0x0020002000040000ULL, 0x4020002000040000ULL, 0x0020002004040000ULL, 0x4020002004040000ULL,
      0x0020012000040000ULL, 0x4020012000040000ULL, 0x0020012004040000ULL, 0x4020012004040000ULL,
      0x0020002000001000ULL, 0x4020002000001000ULL, 0x0020002004001000ULL, 0x4020002004001000ULL,
      0x0020012000001000ULL, 0x4020012000001000ULL, 0x0020012004001000ULL, 0x4020012004001000ULL,
      0x0020002000041000ULL, 0x4020002000041000ULL, 0x0020002004041000ULL, 0x4020002004041000ULL,
      0x0020012000041000ULL, 0x4020012000041000ULL, 0x0020012004041000ULL, 0x4020012004041000ULL,
      0x0030002000000000ULL, 0x4030002000000000ULL, 0x0030002004000000ULL, 0x4030002004000000ULL,
      0x0030012000000000ULL, 0x4030012000000000ULL, 0x0030012004000000ULL, 0x4030012004000000ULL,
      0x0030002000040000ULL, 0x4030002000040000ULL, 0x0030002004040000ULL, 0x4030002004040000ULL,
      0x0030012000040000ULL, 0x4030012000040000ULL, 0x0030012004040000ULL, 0x4030012004040000ULL,
      0x0030002000001000ULL, 0x4030002000001000ULL, 0x0030002004001000ULL, 0x4030002004001000ULL,
      0x0030012000001000ULL, 0x4030012000001000ULL, 0x0030012004001000ULL, 0x4030012004001000ULL,
      0x0030002000041000ULL, 0x4030002000041000ULL, 0x0030002004041000ULL, 0x4030002004041000ULL,
      0x0030012000041000ULL, 0x4030012000041000ULL, 0x0030012004041000ULL, 0x4030012004041000ULL,
    },
    {
      0x0000000000000000ULL, 0x0000000000800000ULL, 0x0800000000000000ULL, 0x0800000000800000ULL,
      0x0000020000000000ULL, 0x0000020000800000ULL, 0x0800020000000000ULL, 0x0800020000800000ULL,
      0x0000000000020000ULL, 0x0000000000820000ULL, 0x0800000000020000ULL, 0x0800000000820000ULL,
      0x0000020000020000ULL, 0x0000020000820000ULL, 0x0800020000020000ULL, 0x0800020000820000ULL,
      0x0000000080000000ULL, 0x0000000080800000ULL, 0x0800000080000000ULL, 0x0800000080800000ULL,
      0x0000020080000000ULL, 0x0000020080800000ULL, 0x0800020080000000ULL, 0x0800020080800000ULL,
      0x0000000080020000ULL, 0x0000000080820000ULL, 0x0800000080020000ULL, 0x0800000080820000ULL,
      0x0000020080020000ULL, 0x0000020080820000ULL, 0x0800020080020000ULL, 0x0800020080820000ULL,
      0x0000000000000001ULL, 0x0000000000800001ULL, 0x0800000000000001ULL, 0x0800000000800001ULL,
      0x0000020000000001ULL, 0x0000020000800001ULL, 0x0800020000000001ULL, 0x0800020000800001ULL,
      0x0000000000020001ULL, 0x0000000000820001ULL, 0x0800000000020001ULL, 0x0800000000820001ULL,
      0x0000020000020001ULL, 0x0000020000820001ULL, 0x0800020000020001ULL, 0x0800020000820001ULL,
      0x0000000080000001ULL, 0x0000000080800001ULL, 0x0800000080000001ULL, 0x0800000080800001ULL,
      0x0000020080000001ULL, 0x0000020080800001ULL, 0x0800020080000001ULL, 0x0800020080800001ULL,
      0x0000000080020001ULL, 0x0000000080820001ULL, 0x0800000080020001ULL, 0x0800000080820001ULL,
      0x0000020080020001ULL, 0x0000020080820001ULL, 0x0800020080020001ULL, 0x0800020080820001ULL,
      0x0000000002000000ULL, 0x0000000002800000ULL, 0x0800000002000000ULL, 0x0800000002800000ULL,
      0x0000020002000000ULL, 0x0000020002800000ULL, 0x0800020002000000ULL, 0x0800020002800000ULL,
      0x0000000002020000ULL, 0x0000000002820000ULL, 0x0800000002020000ULL, 0x0800000002820000ULL,
      0x0000020002020000ULL, 0x0000020002820000ULL, 0x0800020002020000ULL, 0x0800020002820000ULL,
      0x0000000082000000ULL, 0x0000000082800000ULL, 0x0800000082000000ULL, 0x0800000082800000ULL,
      0x0000020082000000ULL, 0x0000020082800000ULL, 0x0800020082000000ULL, 0x0800020082800000ULL,
      0x0000000082020000ULL, 0x0000000082820000ULL, 0x0800000082020000ULL, 0x0800000082820000ULL,
      0x0000020082020000ULL, 0x0000020082820000ULL, 0x0800020082020000ULL, 0x0800020082820000ULL,
      0x0000000002000001ULL, 0x0000000002800001ULL, 0x0800000002000001ULL, 0x0800000002800001ULL,
      0x0000020002000001ULL, 0x0000020002800001ULL, 0x0800020002000001ULL, 0x0800020002800001ULL,
      0x0000000002020001ULL, 0x0000000002820001ULL, 0x0800000002020001ULL, 0x0800000002820001ULL,
      0x0000020002020001ULL, 0x0000020002820001ULL, 0x0800020002020001ULL, 0x0800020002820001ULL,
      0x0000000082000001ULL, 0x0000000082800001ULL, 0x0800000082000001ULL, 0x0800000082800001ULL,
      0x0000020082000001ULL, 0x0000020082800001ULL, 0x0800020082000001ULL, 0x0800020082800001ULL,
      0x0000000082020001ULL, 0x0000000082820001ULL, 0x0800000082020001ULL, 0x0800000082820001ULL,
      0x0000020082020001ULL, 0x0000020082820001ULL, 0x0800020082020001ULL, 0x0800020082820001ULL,
      0x0000080000000000ULL, 0x0000080000800000ULL, 0x0800080000000000ULL, 0x0800080000800000ULL,
      0x00000a0000000000ULL, 0x00000a0000800000ULL, 0x08000a0000000000ULL, 0x08000a0000800000ULL,
      0x0000080000020000ULL, 0x0000080000820000ULL, 0x0800080000020000ULL, 0x0800080000820000ULL,
      0x00000a0000020000ULL, 0x00000a0000820000ULL, 0x08000a0000020000ULL, 0x08000a0000820000ULL,
      0x0000080080000000ULL, 0x0000080080800000ULL, 0x0800080080000000ULL, 0x0800080080800000ULL,
      0x00000a0080000000ULL, 0x00000a0080800000ULL, 0x08000a0080000000ULL, 0x08000a0080800000ULL,
      0x0000080080020000ULL, 0x0000080080820000ULL, 0x0800080080020000ULL, 0x0800080080820000ULL,
      0x00000a0080020000ULL, 0x00000a0080820000ULL, 0x08000a0080020000ULL, 0x08000a0080820000ULL,
      0x0000080000000001ULL, 0x0000080000800001ULL, 0x0800080000000001ULL, 0x0800080000800001ULL,
      0x00000a0000000001ULL, 0x00000a0000800001ULL, 0x08000a0000000001ULL, 0x08000a0000800001ULL,
      0x0000080000020001ULL, 0x0000080000820001ULL, 0x0800080000020001ULL, 0x0800080000820001ULL,
      0x00000a0000020001ULL, 0x00000a0000820001ULL, 0x08000a0000020001ULL, 0x08000a0000820001ULL,
      0x0000080080000001ULL, 0x0000080080800001ULL, 0x0800080080000001ULL, 0x0800080080800001ULL,
      0x00000a0080000001ULL, 0x00000a0080800001ULL, 0x08000a0080000001ULL, 0x08000a0080800001ULL,
      0x0000080080020001ULL, 0x0000080080820001ULL, 0x0800080080020001ULL, 0x0800080080820001ULL,
      0x00000a0080020001ULL, 0x00000a0080820001ULL, 0x08000a0080020001ULL, 0x08000a0080820001ULL,
      0x0000080002000000ULL, 0x0000080002800000ULL, 0x0800080002000000ULL, 0x0800080002800000ULL,
      0x00000a0002000000ULL, 0x00000a0002800000ULL, 0x08000a0002000000ULL, 0x08000a0002800000ULL,
      0x0000080002020000ULL, 0x0000080002820000ULL, 0x0800080002020000ULL, 0x0800080002820000ULL,
      0x00000a0002020000ULL, 0x00000a0002820000ULL, 0x08000a0002020000ULL, 0x08000a0002820000ULL,
      0x0000080082000000ULL, 0x0000080082800000ULL, 0x0800080082000000ULL, 0x0800080082800000ULL,
      0x00000a0082000000ULL, 0x00000a0082800000ULL, 0x08000a0082000000ULL, 0x08000a0082800000ULL,
      0x0000080082020000ULL, 0x0000080082820000ULL, 0x0800080082020000ULL, 0x0800080082820000ULL,
      0x00000a0082020000ULL, 0x00000a0082820000ULL, 0x08000a0082020000ULL, 0x08000a0082820000ULL,
      0x0000080002000001ULL, 0x0000080002800001ULL, 0x0800080002000001ULL, 0x0800080002800001ULL,
      0x00000a0002000001ULL, 0x00000a0002800001ULL, 0x08000a0002000001ULL, 0x08000a0002800001ULL,
      0x0000080002020001ULL, 0x0000080002820001ULL, 0x0800080002020001ULL, 0x0800080002820001ULL,
      0x00000a0002020001ULL, 0x00000a0002820001ULL, 0x08000a0002020001ULL, 0x08000a0002820001ULL,
      0x0000080082000001ULL, 0x0000080082800001ULL, 0x0800080082000001ULL, 0x0800080082800001ULL,
      0x00000a0082000001ULL, 0x00000a0082800001ULL, 0x08000a0082000001ULL, 0x08000a0082800001ULL,
      0x0000080082020001ULL, 0x0000080082820001ULL, 0x0800080082020001ULL, 0x0800080082820001ULL,
      0x00000a0082020001ULL, 0x00000a0082820001ULL, 0x08000a0082020001ULL, 0x08000a0082820001ULL,
    },
    {
      0x0000000000000000ULL, 0x0000100000000000ULL, 0x0000000000004000ULL, 0x0000100000004000ULL,
      0x0000000000000004ULL, 0x0000100000000004ULL, 0x0000000000004004ULL, 0x0000100000004004ULL,
      0x0000000000002000ULL, 0x0000100000002000ULL, 0x0000000000006000ULL, 0x0000100000006000ULL,
      0x0000000000002004ULL, 0x0000100000002004ULL, 0x0000000000006004ULL, 0x0000100000006004ULL,
      0x0000200000000000ULL, 0x0000300000000000ULL, 0x0000200000004000ULL, 0x0000300000004000ULL,
      0x0000200000000004ULL, 0x0000300000000004ULL, 0x0000200000004004ULL, 0x0000300000004004ULL,
      0x0000200000002000ULL, 0x0000300000002000ULL, 0x0000200000006000ULL, 0x0000300000006000ULL,
      0x0000200000002004ULL, 0x0000300000002004ULL, 0x0000200000006004ULL, 0x0000300000006004ULL,
      0x0001000000000000ULL, 0x0001100000000000ULL, 0x0001000000004000ULL, 0x0001100000004000ULL,
      0x0001000000000004ULL, 0x0001100000000004ULL, 0x0001000000004004ULL, 0x0001100000004004ULL,
      0x0001000000002000ULL, 0x0001100000002000ULL, 0x0001000000006000ULL, 0x0001100000006000ULL,
      0x0001000000002004ULL, 0x0001100000002004ULL, 0x0001000000006004ULL, 0x0001100000006004ULL,
      0x0001200000000000ULL, 0x0001300000000000ULL, 0x0001200000004000ULL, 0x0001300000004000ULL,
      0x0001200000000004ULL, 0x0001300000000004ULL, 0x0001200000004004ULL, 0x0001300000004004ULL,
      0x0001200000002000ULL, 0x0001300000002000ULL, 0x0001200000006000ULL, 0x0001300000006000ULL,
      0x0001200000002004ULL, 0x0001300000002004ULL, 0x0001200000006004ULL, 0x0001300000006004ULL,
      0x0000000000000008ULL, 0x0000100000000008ULL, 0x0000000000004008ULL, 0x0000100000004008ULL,
      0x000000000000000cULL, 0x000010000000000cULL, 0x000000000000400cULL, 0x000010000000400cULL,
      0x0000000000002008ULL, 0x0000100000002008ULL, 0x0000000000006008ULL, 0x0000100000006008ULL,
      0x000000000000200cULL, 0x000010000000200cULL, 0x000000000000600cULL, 0x000010000000600cULL,
      0x0000200000000008ULL, 0x0000300000000008ULL, 0x0000200000004008ULL, 0x0000300000004008ULL,
      0x000020000000000cULL, 0x000030000000000cULL, 0x000020000000400cULL, 0x000030000000400cULL,
      0x0000200000002008ULL, 0x0000300000002008ULL, 0x0000200000006008ULL, 0x0000300000006008ULL,
      0x000020000000200cULL, 0x000030000000200cULL, 0x000020000000600cULL, 0x000030000000600cULL,
      0x0001000000000008ULL, 0x0001100000000008ULL, 0x0001000000004008ULL, 0x0001100000004008ULL,
      0x000100000000000cULL, 0x000110000000000cULL, 0x000100000000400cULL, 0x000110000000400cULL,
      0x0001000000002008ULL, 0x0001100000002008ULL, 0x0001000000006008ULL, 0x0001100000006008ULL,
      0x000100000000200cULL, 0x000110000000200cULL, 0x000100000000600cULL, 0x000110000000600cULL,
      0x0001200000000008ULL, 0x0001300000000008ULL, 0x0001200000004008ULL, 0x0001300000004008ULL,
      0x000120000000000cULL, 0x000130000000000cULL, 0x000120000000400cULL, 0x000130000000400cULL,
      0x0001200000002008ULL, 0x0001300000002008ULL, 0x0001200000006008ULL, 0x0001300000006008ULL,
      0x000120000000200cULL, 0x000130000000200cULL, 0x000120000000600cULL, 0x000130000000600cULL,
      0x1000000000000000ULL, 0x1000100000000000ULL, 0x1000000000004000ULL, 0x1000100000004000ULL,
      0x1000000000000004ULL, 0x1000100000000004ULL, 0x1000000000004004ULL, 0x1000100000004004ULL,
      0x1000000000002000ULL, 0x1000100000002000ULL, 0x1000000000006000ULL, 0x1000100000006000ULL,
      0x1000000000002004ULL, 0x1000100000002004ULL, 0x1000000000006004ULL, 0x1000100000006004ULL,
      0x1000200000000000ULL, 0x1000300000000000ULL, 0x1000200000004000ULL, 0x1000300000004000ULL,
      0x1000200000000004ULL, 0x1000300000000004ULL, 0x1000200000004004ULL, 0x1000300000004004ULL,
      0x1000200000002000ULL, 0x1000300000002000ULL, 0x1000200000006000ULL, 0x1000300000006000ULL,
      0x1000200000002004ULL, 0x1000300000002004ULL, 0x1000200000006004ULL, 0x1000300000006004ULL,
      0x1001000000000000ULL, 0x1001100000000000ULL, 0x1001000000004000ULL, 0x1001100000004000ULL,
      0x1001000000000004ULL, 0x1001100000000004ULL, 0x1001000000004004ULL, 0x1001100000004004ULL,
      0x1001000000002000ULL, 0x1001100000002000ULL, 0x1001000000006000ULL, 0x1001100000006000ULL,
      0x1001000000002004ULL, 0x1001100000002004ULL, 0x1001000000006004ULL, 0x1001100000006004ULL,
      0x1001200000000000ULL, 0x1001300000000000ULL, 0x1001200000004000ULL, 0x1001300000004000ULL,
      0x1001200000000004ULL, 0x1001300000000004ULL, 0x1001200000004004ULL, 0x1001300000004004ULL,
      0x1001200000002000ULL, 0x1001300000002000ULL, 0x1001200000006000ULL, 0x1001300000006000ULL,
      0x1001200000002004ULL, 0x1001300000002004ULL, 0x1001200000006004ULL, 0x1001300000006004ULL,
      0x1000000000000008ULL, 0x1000100000000008ULL, 0x1000000000004008ULL, 0x1000100000004008ULL,
      0x100000000000000cULL, 0x100010000000000cULL, 0x100000000000400cULL, 0x100010000000400cULL,
      0x1000000000002008ULL, 0x1000100000002008ULL, 0x1000000000006008ULL, 0x1000100000006008ULL,
      0x100000000000200cULL, 0x100010000000200cULL, 0x100000000000600cULL, 0x100010000000600cULL,
      0x1000200000000008ULL, 0x1000300000000008ULL, 0x1000200000004008ULL, 0x1000300000004008ULL,
      0x100020000000000cULL, 0x100030000000000cULL, 0x100020000000400cULL, 0x100030000000400cULL,
      0x1000200000002008ULL, 0x1000300000002008ULL, 0x1000200000006008ULL, 0x1000300000006008ULL,
      0x100020000000200cULL, 0x100030000000200cULL, 0x100020000000600cULL, 0x100030000000600cULL,
      0x1001000000000008ULL, 0x1001100000000008ULL, 0x1001000000004008ULL, 0x1001100000004008ULL,
      0x100100000000000cULL, 0x100110000000000cULL, 0x100100000000400cULL, 0x100110000000400cULL,
      0x1001000000002008ULL, 0x1001100000002008ULL, 0x1001000000006008ULL, 0x1001100000006008ULL,
      0x100100000000200cULL, 0x100110000000200cULL, 0x100100000000600cULL, 0x100110000000600cULL,
      0x1001200000000008ULL, 0x1001300000000008ULL, 0x1001200000004008ULL, 0x1001300000004008ULL,
      0x100120000000000cULL, 0x100130000000000cULL, 0x100120000000400cULL, 0x100130000000400cULL,
      0x1001200000002008ULL, 0x1001300000002008ULL, 0x1001200000006008ULL, 0x1001300000006008ULL,
      0x100120000000200cULL, 0x100130000000200cULL, 0x100120000000600cULL, 0x100130000000600cULL,
    },
    {
      0x0000000000000000ULL, 0x0002000000000000ULL, 0x0000000000000100ULL, 0x0002000000000100ULL,
      0x0000000400000000ULL, 0x0002000400000000ULL, 0x0000000400000100ULL, 0x0002000400000100ULL,
      0x0000000000000020ULL, 0x0002000000000020ULL, 0x0000000000000120ULL, 0x0002000000000120ULL,
      0x0000000400000020ULL, 0x0002000400000020ULL, 0x0000000400000120ULL, 0x0002000400000120ULL,
      0x0000000000000200ULL, 0x0002000000000200ULL, 0x0000000000000300ULL, 0x0002000000000300ULL,
      0x0000000400000200ULL, 0x0002000400000200ULL, 0x0000000400000300ULL, 0x0002000400000300ULL,
      0x0000000000000220ULL, 0x0002000000000220ULL, 0x0000000000000320ULL, 0x0002000000000320ULL,
      0x0000000400000220ULL, 0x0002000400000220ULL, 0x0000000400000320ULL, 0x0002000400000320ULL,
      0x0000040000000000ULL, 0x0002040000000000ULL, 0x0000040000000100ULL, 0x0002040000000100ULL,
      0x0000040400000000ULL, 0x0002040400000000ULL, 0x0000040400000100ULL, 0x0002040400000100ULL,
      0x0000040000000020ULL, 0x0002040000000020ULL, 0x0000040000000120ULL, 0x0002040000000120ULL,
      0x0000040400000020ULL, 0x0002040400000020ULL, 0x0000040400000120ULL, 0x0002040400000120ULL,
      0x0000040000000200ULL, 0x0002040000000200ULL, 0x0000040000000300ULL, 0x0002040000000300ULL,
      0x0000040400000200ULL, 0x0002040400000200ULL, 0x0000040400000300ULL, 0x0002040400000300ULL,
      0x0000040000000220ULL, 0x0002040000000220ULL, 0x0000040000000320ULL, 0x0002040000000320ULL,
      0x0000040400000220ULL, 0x0002040400000220ULL, 0x0000040400000320ULL, 0x0002040400000320ULL,
      0x0200000000000000ULL, 0x0202000000000000ULL, 0x0200000000000100ULL, 0x0202000000000100ULL,
      0x0200000400000000ULL, 0x0202000400000000ULL, 0x0200000400000100ULL, 0x0202000400000100ULL,
      0x0200000000000020ULL, 0x0202000000000020ULL, 0x0200000000000120ULL, 0x0202000000000120ULL,
      0x0200000400000020ULL, 0x0202000400000020ULL, 0x0200000400000120ULL, 0x0202000400000120ULL,
      0x0200000000000200ULL, 0x0202000000000200ULL, 0x0200000000000300ULL, 0x0202000000000300ULL,
      0x0200000400000200ULL, 0x0202000400000200ULL, 0x0200000400000300ULL, 0x0202000400000300ULL,
      0x0200000000000220ULL, 0x0202000000000220ULL, 0x0200000000000320ULL, 0x0202000000000320ULL,
      0x0200000400000220ULL, 0x0202000400000220ULL, 0x0200000400000320ULL, 0x0202000400000320ULL,
      0x0200040000000000ULL, 0x0202040000000000ULL, 0x0200040000000100ULL, 0x0202040000000100ULL,
      0x0200040400000000ULL, 0x0202040400000000ULL, 0x0200040400000100ULL, 0x0202040400000100ULL,
      0x0200040000000020ULL, 0x0202040000000020ULL, 0x0200040000000120ULL, 0x0202040000000120ULL,
      0x0200040400000020ULL, 0x0202040400000020ULL, 0x0200040400000120ULL, 0x0202040400000120ULL,
      0x0200040000000200ULL, 0x0202040000000200ULL, 0x0200040000000300ULL, 0x0202040000000300ULL,
      0x0200040400000200ULL, 0x0202040400000200ULL, 0x0200040400000300ULL, 0x0202040400000300ULL,
      0x0200040000000220ULL, 0x0202040000000220ULL, 0x0200040000000320ULL, 0x0202040000000320ULL,
      0x0200040400000220ULL, 0x0202040400000220ULL, 0x0200040400000320ULL, 0x0202040400000320ULL,
      0x0000000001000000ULL, 0x0002000001000000ULL, 0x0000000001000100ULL, 0x0002000001000100ULL,
      0x0000000401000000ULL, 0x0002000401000000ULL, 0x0000000401000100ULL, 0x0002000401000100ULL,
      0x0000000001000020ULL, 0x0002000001000020ULL, 0x0000000001000120ULL, 0x0002000001000120ULL,
      0x0000000401000020ULL, 0x0002000401000020ULL, 0x0000000401000120ULL, 0x0002000401000120ULL,
      0x0000000001000200ULL, 0x0002000001000200ULL, 0x0000000001000300ULL, 0x0002000001000300ULL,
      0x0000000401000200ULL, 0x0002000401000200ULL, 0x0000000401000300ULL, 0x0002000401000300ULL,
      0x0000000001000220ULL, 0x0002000001000220ULL, 0x0000000001000320ULL, 0x0002000001000320ULL,
      0x0000000401000220ULL, 0x0002000401000220ULL, 0x0000000401000320ULL, 0x0002000401000320ULL,
      0x0000040001000000ULL, 0x0002040001000000ULL, 0x0000040001000100ULL, 0x0002040001000100ULL,
      0x0000040401000000ULL, 0x0002040401000000ULL, 0x0000040401000100ULL, 0x0002040401000100ULL,
      0x0000040001000020ULL, 0x0002040001000020ULL, 0x0000040001000120ULL, 0x0002040001000120ULL,
      0x0000040401000020ULL, 0x0002040401000020ULL, 0x0000040401000120ULL, 0x0002040401000120ULL,
      0x0000040001000200ULL, 0x0002040001000200ULL, 0x0000040001000300ULL, 0x0002040001000300ULL,
      0x0000040401000200ULL, 0x0002040401000200ULL, 0x0000040401000300ULL, 0x0002040401000300ULL,
      0x0000040001000220ULL, 0x0002040001000220ULL, 0x0000040001000320ULL, 0x0002040001000320ULL,
      0x0000040401000220ULL, 0x0002040401000220ULL, 0x0000040401000320ULL, 0x0002040401000320ULL,
      0x0200000001000000ULL, 0x0202000001000000ULL, 0x0200000001000100ULL, 0x0202000001000100ULL,
      0x0200000401000000ULL, 0x0202000401000000ULL, 0x0200000401000100ULL, 0x0202000401000100ULL,
      0x0200000001000020ULL, 0x0202000001000020ULL, 0x0200000001000120ULL, 0x0202000001000120ULL,
      0x0200000401000020ULL, 0x0202000401000020ULL, 0x0200000401000120ULL, 0x0202000401000120ULL,
      0x0200000001000200ULL, 0x0202000001000200ULL, 0x0200000001000300ULL, 0x0202000001000300ULL,
      0x0200000401000200ULL, 0x0202000401000200ULL, 0x0200000401000300ULL, 0x0202000401000300ULL,
      0x0200000001000220ULL, 0x0202000001000220ULL, 0x0200000001000320ULL, 0x0202000001000320ULL,
      0x0200000401000220ULL, 0x0202000401000220ULL, 0x0200000401000320ULL, 0x0202000401000320ULL,
      0x0200040001000000ULL, 0x0202040001000000ULL, 0x0200040001000100ULL, 0x0202040001000100ULL,
      0x0200040401000000ULL, 0x0202040401000000ULL, 0x0200040401000100ULL, 0x0202040401000100ULL,
      0x0200040001000020ULL, 0x0202040001000020ULL, 0x0200040001000120ULL, 0x0202040001000120ULL,
      0x0200040401000020ULL, 0x0202040401000020ULL, 0x0200040401000120ULL, 0x0202040401000120ULL,
      0x0200040001000200ULL, 0x0202040001000200ULL, 0x0200040001000300ULL, 0x0202040001000300ULL,
      0x0200040401000200ULL, 0x0202040401000200ULL, 0x0200040401000300ULL, 0x0202040401000300ULL,
      0x0200040001000220ULL, 0x0202040001000220ULL, 0x0200040001000320ULL, 0x0202040001000320ULL,
      0x0200040401000220ULL, 0x0202040401000220ULL, 0x0200040401000320ULL, 0x0202040401000320ULL,
    },
  };

static inline uint64_t dvbcsa_key_permute_block(uint64_t k)
{
  uint64_t n = 0;
  int i;

  for (i = 0; i < 8; i++)
    {
      n |= kperm[i][k & 0xff];
      k >>= 8;
    }

  return n;
}

void
dvbcsa_key_schedule_block(const dvbcsa_cw_t cw, uint8_t * kk)
{
  uint64_t k[7];
  int i, j;

  k[6] = dvbcsa_load_le64(cw);
  for (i = 6; i > 0; i--)
    k[i - 1] = dvbcsa_key_permute_block(k[i]);

  for (i = 0; i < 7; i++)
    for (j = 0; j < 8; j++)
      kk[i*8+j] = (k[i]>>(j*8)) ^ i;
}

