/*
* Copyright (c) 2014 Amlogic, Inc. All rights reserved.
*
* This source code is subject to the terms and conditions defined in the
* file 'LICENSE' which is part of this source code package. *
* Description:
*/
static const char *freesat_table2="# Huffman Table for FreeSat table 2\n"
"#\n"
"# This table was derived from on-air transmissions.  It certainly has omissions \n"
"# and almost certainly contains errors.  Use entirely at your own risk. \n"
"#\n"
"# Data taken from MythTV and Freesat EPG Parser by mitsubushi\n"
"# Additions, and corrections made by Dom \n"
"# More additions and corrections from Jochen Mann \n"
"#\n"
"START:010:A:\n"
"START:100:C:\n"
"START:111:T:\n"
"START:0001:J:\n"
"START:0011:D:\n"
"START:1010:S:\n"
"START:00000:H:\n"
"START:00100:I:\n"
"START:00101:R:\n"
"START:01101:F:\n"
"START:01110:.:\n"
"START:01111:W:\n"
"START:10111:M:\n"
"START:11000:B:\n"
"START:11001:P:\n"
"START:11011:N:\n"
"START:000010:O:\n"
"START:011001:[:\n"
"START:101101:L:\n"
"START:110101:E:\n"
"START:0000110:K:\n"
"START:1101000:Y:\n"
"START:1101001:G:\n"
"START:00001110:2:\n"
"START:01100010:U:\n"
"START:01100011:(:\n"
"START:10110000:1:\n"
"START:10110011:V:\n"
"START:000011110:Q:\n"
"START:101100010:3:\n"
"START:0000111110:9:\n"
"START:0000111111:8:\n"
"START:1011000110:6:\n"
"START:1011000111:5:\n"
"START:1011001000:Z:\n"
"START:1011001001:7:\n"
"START:1011001010:4:\n"
"START:101100101111: :\n"
"START:1011001011010:\':\n"
"START:1011001011011:\":\n"
"START:10110010110001110:ESCAPE:\n"
"0x09:1:ESCAPE:\n"
"0x0a:1:ESCAPE:\n"
"0x0d:1000010101:ESCAPE:\n"
" :010:a:\n"
" :100:t:\n"
" :0001:o:\n"
" :0010:s:\n"
" :00110:d:\n"
" :01100:[:\n"
" :01111:p:\n"
" :10101:b:\n"
" :11001:c:\n"
" :11010:h:\n"
" :11100:w:\n"
" :11101:i:\n"
" :11111:f:\n"
" :000000:A:\n"
" :000011:M:\n"
" :001111:e:\n"
" :011100:B:\n"
" :011101:C:\n"
" :101000:T:\n"
" :101101:S:\n"
" :101110:g:\n"
" :110000:r:\n"
" :110110:n:\n"
" :110111:l:\n"
" :111101:m:\n"
" :0000011:v:\n"
" :0000100:G:\n"
" :0000101:N:\n"
" :0011101:y:\n"
" :0110101:H:\n"
" :0110111:L:\n"
" :1010010:J:\n"
" :1010011:F:\n"
" :1011001:R:\n"
" :1011110:u:\n"
" :1100010:D:\n"
" :1100011:W:\n"
" :1111001:P:\n"
" :00000100:k:\n"
" :00000101:O:\n"
" :01101000:-:\n"
" :01101101:1:\n"
" :10110001:K:\n"
" :10111110:j:\n"
" :11110000:I:\n"
" :11110001:E:\n"
" :001110010:q:\n"
" :001110011:U:\n"
" :011010010:V:\n"
" :011011000:Y:\n"
" :011011001: :\n"
" :101100001:2:\n"
" :0011100000:3:\n"
" :0011100001:8:\n"
" :0011100010:6:\n"
" :0110100111:5:\n"
" :1011000000:(:\n"
" :1011111100:STOP:\n"
" :1011111110:7:\n"
" :00111000110:0:\n"
" :01101001100:\':\n"
" :01101001101:9:\n"
" :10110000010:Z:\n"
" :10111111110:4:\n"
" :10111111111:Q:\n"
" :001110001111:X:\n"
" :1011000001100:ESCAPE:\n"
" :1011000001101:.:\n"
" :1011000001110:&:\n"
" :10110000011110:\":\n"
" :10110000011111:z:\n"
" :001110001110011:$:\n"
" :0011100011100100:+:\n"
" :00111000111001011:x:\n"
" :0011100011100101000:/:\n"
" :0011100011100101001:?:\n"
"!:1: :\n"
"!:01:STOP:\n"
"!:001:.:\n"
"!:0000:0x3a:\n"
"!:0001010:/:\n"
"!:0001011:!:\n"
"!:00010000:):\n"
"!:000100010:\':\n"
"!:0001000111:?:\n"
"!:00010001100:ESCAPE:\n"
"!:00010001101:]:\n"
"\":11: :\n"
"\":001:.:\n"
"\":0000:p:\n"
"\":0101:B:\n"
"\":0111:T:\n"
"\":1000:i:\n"
"\":1010:STOP:\n"
"\":00010:f:\n"
"\":00011:W:\n"
"\":01000:S:\n"
"\":01100:t:\n"
"\":01101:C:\n"
"\":10111:,:\n"
"\":100100:m:\n"
"\":101010:n:\n"
"\":101011:I:\n"
"\":0100111:D:\n"
"\":1001010:w:\n"
"\":1001011:g:\n"
"\":1001100:b:\n"
"\":1001101:L:\n"
"\":1011000:c:\n"
"\":1011001:H:\n"
"\":10011110:P:\n"
"\":10110100:r:\n"
"\":10110111:K:\n"
"\":101101010:Y:\n"
"\":101101101:A:\n"
"\":1001111100:ESCAPE:\n"
"\":1001111101:a:\n"
"\":10100000000:STOP:\n"
"$:0:1:\n"
"$:11:3:\n"
"$:100:4:\n"
"$:1011:2:\n"
"$:101001:5:\n"
"$:1010000:ESCAPE:\n"
"$:101000000100000: :\n"
"%:1: :\n"
"&:1: :\n"
"&:01:w:\n"
"&:001:B:\n"
"&:0000:E:\n"
"&:000110:A:\n"
"&:000101100:ESCAPE:\n"
"\':1:s:\n"
"\':001:t:\n"
"\':010: :\n"
"\':0000:l:\n"
"\':01101:r:\n"
"\':000100:n:\n"
"\':000101:.:\n"
"\':000110:C:\n"
"\':011000:B:\n"
"\':011101:A:\n"
"\':0111000:d:\n"
"\':0111100:v:\n"
"\':00011100:S:\n"
"\':00011111:p:\n"
"\':01100101:D:\n"
"\':01111011:i:\n"
"\':01111100:c:\n"
"\':01111101:m:\n"
"\':01111111:,:\n"
"\':000111010:f:\n"
"\':000111011:g:\n"
"\':011001000:F:\n"
"\':011001001:h:\n"
"\':011001101:H:\n"
"\':011001110:N:\n"
"\':011100101:R:\n"
"\':011100111:T:\n"
"\':011110101:G:\n"
"\':011111101:L:\n"
"\':0001111000:o:\n"
"\':0001111001:K:\n"
"\':0001111011:a:\n"
"\':0110011001:u:\n"
"\':0110011111:O:\n"
"\':0111001001:I:\n"
"\':0111101000:w:\n"
"\':0111101001:b:\n"
"\':0111111001:e:\n"
"\':00011110101:?:\n"
"\':01100110000:E:\n"
"\':01100110001:7:\n"
"\':01110010000:P:\n"
"\':000111101001:W:\n"
"\':011001111001:0x3a:\n"
"\':011100100011:J:\n"
"\':011111100001:q:\n"
"\':011111100011:M:\n"
"\':0110011110001:9:\n"
"\':0110011110100:!:\n"
"\':0110011110111:y:\n"
"\':0111001000100:8:\n"
"\':0111001000101:5:\n"
"\':0111001100000:STOP:\n"
"\':0111111000000:6:\n"
"\':00011110100000:2:\n"
"\':00011110100001:0:\n"
"\':01100111100001:Y:\n"
"\':01111110000010:j:\n"
"\':01111110000011:Q:\n"
"\':011111100010001:U:\n"
"\':011111100010010:4:\n"
"\':0110011110110100:ESCAPE:\n"
"\':0110011110110101:1:\n"
"(:01:1:\n"
"(:000:P:\n"
"(:101:t:\n"
"(:1000:2:\n"
"(:1101:5:\n"
"(:1110:N:\n"
"(:00111:T:\n"
"(:10010:p:\n"
"(:11111:c:\n"
"(:001001:a:\n"
"(:001010:S:\n"
"(:001100:R:\n"
"(:100111:e:\n"
"(:111100:J:\n"
"(:111101:A:\n"
"(:0010110:D:\n"
"(:0011011:K:\n"
"(:1001100:v:\n"
"(:1001101:s:\n"
"(:1100000:b:\n"
"(:1100010:G:\n"
"(:1100100:M:\n"
"(:1100101:H:\n"
"(:1100110:C:\n"
"(:00100000:m:\n"
"(:00100010:o:\n"
"(:00100011:E:\n"
"(:00101110:W:\n"
"(:11000011:g:\n"
"(:11001110:L:\n"
"(:001000010:d:\n"
"(:001011111:U:\n"
"(:001101000:F:\n"
"(:001101010:f:\n"
"(:110000100:w:\n"
"(:110000101:B:\n"
"(:110011111:n:\n"
"(:0010000111:9:\n"
"(:0010111100:4:\n"
"(:0010111101:I:\n"
"(:0011010010:3:\n"
"(:0011010111:h:\n"
"(:1100111101:i:\n"
"(:00110100111:V:\n"
"(:11001111000:k:\n"
"(:001101011011:O:\n"
"(:0011010110100:ESCAPE:\n"
"(:0011010110101:u:\n"
"):0: :\n"
"):11:.:\n"
"):101:STOP:\n"
"):1001:,:\n"
"):1010:STOP:\n"
"):10000:0x3a:\n"
"):100011:;:\n"
"):1000101:!:\n"
"):1000100000:ESCAPE:\n"
"*:0:*:\n"
"*:11111:d:\n"
"*:111100010:ESCAPE:\n"
"+:01: :\n"
"+:0001000010:B:\n"
",:1: :\n"
",:01:S:\n"
",:001:0:\n"
",:00000:5:\n"
",:0000110:b:\n"
",:00001000:2:\n"
",:00001001:\":\n"
",:00001011:1:\n"
",:0000101010:\':\n"
",:000010100110:7:\n"
",:0000101011010:ESCAPE:\n"
"-:00: :\n"
"-:0100:t:\n"
"-:0101:b:\n"
"-:0110:w:\n"
"-:0111:u:\n"
"-:1001:o:\n"
"-:1010:s:\n"
"-:1011:f:\n"
"-:10000:c:\n"
"-:11011:l:\n"
"-:11101:d:\n"
"-:100010:9:\n"
"-:110000:h:\n"
"-:110010:1:\n"
"-:110011:y:\n"
"-:110101:r:\n"
"-:111000:a:\n"
"-:111100:m:\n"
"-:111110:p:\n"
"-:1000110:S:\n"
"-:1101000:e:\n"
"-:1101001:i:\n"
"-:1111011:n:\n"
"-:10001110:C:\n"
"-:11000101:W:\n"
"-:11000111:g:\n"
"-:11100101:J:\n"
"-:11100110:D:\n"
"-:11110101:2:\n"
"-:11111100:7:\n"
"-:11111110:G:\n"
"-:11111111:O:\n"
"-:100011111:H:\n"
"-:110001000:A:\n"
"-:110001100:6:\n"
"-:110001101:B:\n"
"-:111001111:M:\n"
"-:111101000:E:\n"
"-:111101001:L:\n"
"-:111111010:U:\n"
"-:111111011:k:\n"
"-:1000111100:F:\n"
"-:1100010010:j:\n"
"-:1100010011:P:\n"
"-:1110010001:q:\n"
"-:1110010010:5:\n"
"-:1110010011:T:\n"
"-:1110011101:I:\n"
"-:10001111011:K:\n"
"-:11100100000:v:\n"
"-:11100100001:Z:\n"
"-:11100111001:N:\n"
"-:100011110101:R:\n"
"-:111001110001:Y:\n"
"-:1000111101001:0:\n"
"-:10001111010000:4:\n"
"-:10001111010001:z:\n"
"-:11100111000001:V:\n"
"-:11100111000010:3:\n"
"-:11100111000011:8:\n"
"-:111001110000001:Q:\n"
"-:1110011100000000:\':\n"
"-:11100111000000010:ESCAPE:\n"
".:1: :\n"
".:0011:.:\n"
".:0100:STOP:\n"
".:00010:i:\n"
".:00100:0:\n"
".:00101:c:\n"
".:000001:u:\n"
".:0000000:a:\n"
".:0000001:[:\n"
".:0001101:3:\n"
".:00001000:4:\n"
".:00001110:H:\n"
".:00011000:S:\n"
".:00011001:W:\n"
".:00011100:o:\n"
".:00011110:1:\n"
".:000010100:5:\n"
".:000010101:L:\n"
".:000010111:p:\n"
".:000011000:T:\n"
".:000011001:A:\n"
".:000011010:M:\n"
".:000011110:C:\n"
".:000011111:2:\n"
".:000111011:D:\n"
".:000111110:B:\n"
".:0000100100:N:\n"
".:0000100110:t:\n"
".:0000100111:J:\n"
".:0000101101:R:\n"
".:0000110111:P:\n"
".:0001110101:s:\n"
".:0001111111:I:\n"
".:00001011000:r:\n"
".:00001101100:V:\n"
".:00011101000:w:\n"
".:00011101001:F:\n"
".:00011111101:G:\n"
".:000010010100:E:\n"
".:000010010101:0x3a:\n"
".:000010110010:h:\n"
".:000011011010:,:\n"
".:000111111000:\':\n"
".:0000100101101:b:\n"
".:0000100101110:K:\n"
".:0000100101111:Y:\n"
".:0000101100111:O:\n"
".:0000110110110:-:\n"
".:0001111110010:f:\n"
".:0001111110011:(:\n"
".:00001011001100:\":\n"
".:000010010110000:?:\n"
".:000010010110010:Q:\n"
".:000011011011111:,:\n"
".:0000100101100110:U:\n"
".:0000101100110101:6:\n"
".:0000101100110111:k:\n"
".:00001011001101100:d:\n"
".:000010110011011010:ESCAPE:\n"
".:000010110011011011:n:\n"
"/:01:c:\n"
"/:110:1:\n"
"/:111:e:\n"
"/:0000:5:\n"
"/:0010:8:\n"
"/:00010:T:\n"
"/:00011:f:\n"
"/:00110:B:\n"
"/:00111:2:\n"
"/:10001:3:\n"
"/:10010:7:\n"
"/:10100:6:\n"
"/:10110:a:\n"
"/:101111:4:\n"
"/:1000000:F:\n"
"/:1000010:s:\n"
"/:1000011:M:\n"
"/:1001100:H:\n"
"/:1001110:D:\n"
"/:1001111:A:\n"
"/:1010101:S:\n"
"/:10000011:m:\n"
"/:10011010:W:\n"
"/:10101000:G:\n"
"/:10101001:U:\n"
"/:10101100:d:\n"
"/:10101101:O:\n"
"/:10101110:N:\n"
"/:10111001:C:\n"
"/:10111011:P:\n"
"/:100110110:L:\n"
"/:101011110: :\n"
"/:101011111:I:\n"
"/:101110000:E:\n"
"/:101110001:R:\n"
"/:101110100:K:\n"
"/:101110101:t:\n"
"/:1000001001:J:\n"
"/:1000001011:9:\n"
"/:10000010000:v:\n"
"/:10000010001:p:\n"
"/:10000010100:h:\n"
"/:10011011101:o:\n"
"/:10011011110:Q:\n"
"/:10011011111:0:\n"
"/:100000101010:l:\n"
"/:100110111000:V:\n"
"/:0100010111101:c:\n"
"/:10011011100100:ESCAPE:\n"
"/:10011011100101:g:\n"
"0:0:0:\n"
"0:111: :\n"
"0:1001:a:\n"
"0:1011:p:\n"
"0:10001:s:\n"
"0:11000:.:\n"
"0:11001:8:\n"
"0:11011:,:\n"
"0:100000:4:\n"
"0:100001:t:\n"
"0:101001:5:\n"
"0:110100:6:\n"
"0:1010000:3:\n"
"0:1010001:7:\n"
"0:1010101:]:\n"
"0:1010110:-:\n"
"0:1010111:1:\n"
"0:10101000:):\n"
"0:10101001:/:\n"
"0:11010100:STOP:\n"
"0:11010101:9:\n"
"0:11010111:2:\n"
"0:110101100:%:\n"
"0:1101011010:0x3a:\n"
"0:110101101111:m:\n"
"0:11010110110001:l:\n"
"0:11010110110010:;:\n"
"0:11010110110011:\':\n"
"0:11010110111010:k:\n"
"0:11010110111011:!:\n"
"0:110101101100000:C:\n"
"0:1101011011000010:ESCAPE:\n"
"1:00:9:\n"
"1:100:1:\n"
"1:111:0:\n"
"1:0101: :\n"
"1:0111:2:\n"
"1:1011:.:\n"
"1:1100:5:\n"
"1:01000:6:\n"
"1:01001:8:\n"
"1:01101:/:\n"
"1:10100:]:\n"
"1:11010:3:\n"
"1:011001:7:\n"
"1:110110:4:\n"
"1:0110000:STOP:\n"
"1:0110001:-:\n"
"1:1010100:):\n"
"1:1010110:0x3a:\n"
"1:1010111:s:\n"
"1:1101110:,:\n"
"1:1101111:x:\n"
"1:10101010:\':\n"
"1:101010110:X:\n"
"1:10101011110:t:\n"
"1:10101011111:R:\n"
"1:101010111011:;:\n"
"1:1010101110000:p:\n"
"1:101010111001110:b:\n"
"1:101010111001111:a:\n"
"1:1010101110100110:ESCAPE:\n"
"2:11:0:\n"
"2:000: :\n"
"2:010:.:\n"
"2:100:5:\n"
"2:0011:/:\n"
"2:1011:,:\n"
"2:00100:]:\n"
"2:00101:p:\n"
"2:01101:1:\n"
"2:10101:4:\n"
"2:011000:6:\n"
"2:011001:2:\n"
"2:011100:0x3a:\n"
"2:011101:-:\n"
"2:011111:):\n"
"2:1010010:8:\n"
"2:1010011:9:\n"
"2:01111000:D:\n"
"2:01111001:3:\n"
"2:01111010:t:\n"
"2:01111011:7:\n"
"2:10100000:STOP:\n"
"2:10100010:n:\n"
"2:101000110:a:\n"
"2:1010001110:\':\n"
"2:10100011111:;:\n"
"2:1010001111010:\":\n"
"2:101000111101100:ESCAPE:\n"
"2:101000111101111:L:\n"
"3:00: :\n"
"3:10:0:\n"
"3:110:.:\n"
"3:1110:/:\n"
"3:01000:2:\n"
"3:01001:1:\n"
"3:01010:):\n"
"3:01100:0x3a:\n"
"3:01110:-:\n"
"3:11111:]:\n"
"3:010110:D:\n"
"3:011010:4:\n"
"3:011011:STOP:\n"
"3:011111:5:\n"
"3:111100:,:\n"
"3:0101110:7:\n"
"3:0101111:3:\n"
"3:0111101:6:\n"
"3:1111011:t:\n"
"3:01111001:B:\n"
"3:11110100:8:\n"
"3:111101010:9:\n"
"3:0111100001:;:\n"
"3:1111010110:r:\n"
"3:01111000101:b:\n"
"3:01111000110:\':\n"
"3:011110000010:p:\n"
"3:0111100010000:a:\n"
"3:01111000100110:ESCAPE:\n"
"3:010011001101101:m:\n"
"4:01: :\n"
"4:000:4:\n"
"4:100:.:\n"
"4:110:0:\n"
"4:0010:/:\n"
"4:1010:5:\n"
"4:1011:-:\n"
"4:00110:1:\n"
"4:11101:]:\n"
"4:11110:,:\n"
"4:001110:2:\n"
"4:111001:8:\n"
"4:111110:):\n"
"4:0011110:0x3a:\n"
"4:0011111:\':\n"
"4:1110000:t:\n"
"4:1110001:3:\n"
"4:1111111:STOP:\n"
"4:11111101:6:\n"
"4:1111110000:9:\n"
"4:1111110010:7:\n"
"4:1111111000:STOP:\n"
"4:11111100110:;:\n"
"4:111111000101:x:\n"
"4:1111110011101:m:\n"
"4:11111100111110:p:\n"
"4:11111100111111:c:\n"
"4:111111001110010:ESCAPE:\n"
"5:00:0:\n"
"5:10: :\n"
"5:010:.:\n"
"5:0111:p:\n"
"5:1100:5:\n"
"5:01100:/:\n"
"5:11010:a:\n"
"5:11011:-:\n"
"5:11101:6:\n"
"5:011010:3:\n"
"5:111100:2:\n"
"5:111110:8:\n"
"5:111111:]:\n"
"5:0110110:0x3a:\n"
"5:1110000:):\n"
"5:1110011:,:\n"
"5:1111010:7:\n"
"5:1111011:9:\n"
"5:01101110:4:\n"
"5:11100101:t:\n"
"5:0110111111:1:\n"
"5:01101111001:;:\n"
"5:01101111011:m:\n"
"5:011011110001:\':\n"
"5:011011110101:k:\n"
"5:0110111101001:l:\n"
"5:1110010000000:STOP:\n"
"5:01101111010000:ESCAPE:\n"
"5:01101111010001:f:\n"
"6:00: :\n"
"6:10:.:\n"
"6:111:0:\n"
"6:0101:]:\n"
"6:01001:1:\n"
"6:01100:7:\n"
"6:01110:):\n"
"6:11000:,:\n"
"6:11001:0x3a:\n"
"6:11010:/:\n"
"6:010001:-:\n"
"6:011010:5:\n"
"6:011011:4:\n"
"6:011111:8:\n"
"6:110111:t:\n"
"6:0100000:6:\n"
"6:0100001:STOP:   **Remove?\n"
"6:0111100:3:\n"
"6:0111101:2:\n"
"6:1101101:9:\n"
"6:11011000:\':\n"
"6:010000100:STOP:\n"
"6:1101100101:a:\n"
"6:11011001110:;:\n"
"6:110110011111110:ESCAPE:\n"
"7:11:.:\n"
"7:001: :\n"
"7:011:0:\n"
"7:101:-:\n"
"7:0000:8:\n"
"7:0100:7:\n"
"7:1001:]:\n"
"7:01010:/:\n"
"7:000101:6:\n"
"7:000110:2:\n"
"7:000111:1:\n"
"7:010111:t:\n"
"7:100000:9:\n"
"7:100010:):\n"
"7:100011:5:\n"
"7:0001001:3:\n"
"7:0101101:,:\n"
"7:1000010:a:\n"
"7:1000011:4:\n"
"7:00010000:STOP:\n"
"7:01011000:0x3a:\n"
"7:01011001:p:\n"
"7:0001000110:;:\n"
"7:00010001000:\':\n"
"7:000100011101:?:\n"
"7:0001000100100:ESCAPE:\n"
"7:0001000100101:s:\n"
"8:01: :\n"
"8:000:4:\n"
"8:110:.:\n"
"8:0011:0:\n"
"8:1000:9:\n"
"8:1001:7:\n"
"8:1011:8:\n"
"8:1110:1:\n"
"8:00100:/:\n"
"8:10100:3:\n"
"8:11110:5:\n"
"8:101010:):\n"
"8:111110:6:\n"
"8:111111:]:\n"
"8:0010100:0x3a:\n"
"8:0010101:,:\n"
"8:1010111:t:\n"
"8:00101100:p:\n"
"8:00101101:-:\n"
"8:00101111:a:\n"
"8:10101100:c:\n"
"8:10101101:2:\n"
"8:001011101:STOP:\n"
"8:0010111001:;:\n"
"8:001011100001:\':\n"
"8:00101110001110:ESCAPE:\n"
"9:000:5:\n"
"9:001:]:\n"
"9:111:9:\n"
"9:0101:0:\n"
"9:0110:.:\n"
"9:0111:-:\n"
"9:1000:4:\n"
"9:1001:8:\n"
"9:1011:6:\n"
"9:1100: :\n"
"9:1101:7:\n"
"9:01000:2:\n"
"9:10100:3:\n"
"9:010010:1:\n"
"9:010011:/:\n"
"9:101010:t:\n"
"9:1010111:):\n"
"9:10101100:0x3a:\n"
"9:101011010:,:\n"
"9:10101101100:p:\n"
"9:10101101111:STOP:\n"
"9:1010110111010:a:\n"
"9:10101101110111:e:\n"
"9:10101101111000:STOP:\n"
"9:101011011101100:ESCAPE:\n"
"0x3a:1: :\n"
"0x3a:01:0:\n"
"0x3a:00001:1:\n"
"0x3a:00010:T:\n"
"0x3a:0000000:ESCAPE:\n"
"0x3a:0000001:5:\n"
";:1: :\n"
";:000110001:1:\n"
";:001000111:G:\n"
";:001100001:a:\n"
";:001110000:p:\n"
"=:1:ESCAPE:\n"
"?:1: :\n"
"?:01:STOP:\n"
"?:000:0x3a:\n"
"?:00100:!:\n"
"?:00111:.:\n"
"?:001010:;:\n"
"?:0010110:\':\n"
"?:00101111:,:\n"
"?:001011101:/:\n"
"?:0010111000:ESCAPE:\n"
"@:1101:b:\n"
"@:11000:ESCAPE:\n"
"@:1010111:W:\n"
"@:1101110:n:\n"
"@:1100001100011:c:\n"
"@:1100001110011:s:\n"
"A:01: :\n"
"A:110:D:\n"
"A:111:n:\n"
"A:0000:s:\n"
"A:0001:m:\n"
"A:0010:d:\n"
"A:1000:r:\n"
"A:1011:l:\n"
"A:00110:c:\n"
"A:10010:u:\n"
"A:10100:g:\n"
"A:001111:b:\n"
"A:100111:t:\n"
"A:101011:f:\n"
"A:1010100:w:\n"
"A:1010101:i:\n"
"A:10011001:v:\n"
"A:10011011:p:\n"
"A:001110010:h:\n"
"A:001110100:.:\n"
"A:001110111:B:\n"
"A:100110100:q:\n"
"A:0011100000:C:\n"
"A:0011100010:,:\n"
"A:0011100110:y:\n"
"A:0011101010:S:\n"
"A:0011101100:k:\n"
"A:0011101101:T:\n"
"A:1001100010:F:\n"
"A:1001100011:z:\n"
"A:1001101011:a:\n"
"A:00111000010:P:\n"
"A:00111000110:-:\n"
"A:00111010110:A:\n"
"A:00111010111:I:\n"
"A:10011000001:e:\n"
"A:10011010100:N:\n"
"A:10011010101:x:\n"
"A:001110000110:X:\n"
"A:001110000111:K:\n"
"A:001110001110:3:\n"
"A:001110001111:&:\n"
"A:001110011101:M:\n"
"A:001110011111:Y:\n"
"A:0011100111000:L:\n"
"A:0011100111001:W:\n"
"A:1001100000000:o:\n"
"A:1001100000010:\':\n"
"A:1001100000011:0x3a:\n"
"A:00111001111010:j:\n"
"A:001110011110110:G:\n"
"A:00111001111011110:4:\n"
"A:001110011110111110:ESCAPE:\n"
"A:001110011110111111:E:\n"
"B:00:C:\n"
"B:010:a:\n"
"B:101:r:\n"
"B:110:e:\n"
"B:111:B:\n"
"B:0111:i:\n"
"B:1000:u:\n"
"B:1001:o:\n"
"B:01101:l:\n"
"B:01100000:T:\n"
"B:01100001:.:\n"
"B:01100011:y:\n"
"B:01100100:I:\n"
"B:01100110:h:\n"
"B:01100111: :\n"
"B:011000100:A:\n"
"B:0110001010:O:\n"
"B:01100010110:0x3a:\n"
"B:01100101000:&:\n"
"B:01100101010:j:\n"
"B:01100101011:M:\n"
"B:01100101110:D:\n"
"B:011000101111:W:\n"
"B:011001011010:,:\n"
"B:011001011011:1:\n"
"B:011001011110:ESCAPE:\n"
"B:011001011111:P:\n"
"B:0110001011100:E:\n"
"B:0110010110011:R:\n"
"B:01100010111011:w:\n"
"B:011000101110100:-:\n"
"B:011001011001010:S:\n"
"B:011001011001011:F:\n"
"B:0110010110010000:Q:\n"
"B:0110010110010001:4:\n"
"C:00:h:\n"
"C:011:B:\n"
"C:100:a:\n"
"C:110:o:\n"
"C:0101:r:\n"
"C:1010:.:\n"
"C:1110: :\n"
"C:1111:l:\n"
"C:01000:\':\n"
"C:10111:i:\n"
"C:010011:e:\n"
"C:101101:u:\n"
"C:0100101:y:\n"
"C:1011001:,:\n"
"C:01001001:I:\n"
"C:010010000:A:\n"
"C:1011000000:C:\n"
"C:1011000001:D:\n"
"C:1011000100:S:\n"
"C:1011000101:T:\n"
"C:1011000111:G:\n"
"C:01001000111:w:\n"
"C:10110001101:J:\n"
"C:010010001010:R:\n"
"C:010010001100:2:\n"
"C:101100001010:O:\n"
"C:101100001011:H:\n"
"C:101100011000:E:\n"
"C:0100100010110:z:\n"
"C:1011000010011:-:\n"
"C:1011000110011:s:\n"
"C:10110000110000:STOP:\n"
"C:10110001100100:P:\n"
"C:010010001011101:n:\n"
"C:101100001001000:K:\n"
"C:101100001001001:7:\n"
"C:101100011001011:4:\n"
"C:0100100010111000:0x3a:\n"
"C:1011000110010100:F:\n"
"C:01001000101110010:ESCAPE:\n"
"C:01001000101110011:b:\n"
"D:00:a:\n"
"D:01:,:\n"
"D:100:r:\n"
"D:101:o:\n"
"D:110:e:\n"
"D:1110:i:\n"
"D:111111:u:\n"
"D:1111001: :\n"
"D:1111011:\':\n"
"D:11110000:.:\n"
"D:11110001:]:\n"
"D:11111010:y:\n"
"D:111101010:w:\n"
"D:111101011:W:\n"
"D:111110001:N:\n"
"D:111110010:C:\n"
"D:111110111:J:\n"
"D:1111010010:h:\n"
"D:1111100111:I:\n"
"D:1111101101:0x3a:\n"
"D:11110100001:M:\n"
"D:11110100010:&:\n"
"D:11110100011:V:\n"
"D:11111000010:-:\n"
"D:11111000011:G:\n"
"D:11111001101:A:\n"
"D:11111011001:S:\n"
"D:111101000000:F\n"
"D:111101001101:s:\n"
"D:111101001111:d:\n"
"D:111110110000:v:\n"
"D:1111010011100:m:\n"
"D:1111010011101:j:\n"
"D:1111101100010:ESCAPE:\n"
"D:1111101100011:T:\n"
"D:11110100000110:9:\n"
"D:111101000001110:8:\n"
"D:111101000001111:7:\n"
"D:1111010000010011:R:\n"
"D:1111010000010100:B:\n"
"D:1111010000010101:4:\n"
"E:000:p:\n"
"E:010:a:\n"
"E:011:n:\n"
"E:110:l:\n"
"E:1001:m:\n"
"E:1010:x:\n"
"E:1110:v:\n"
"E:1111:d:\n"
"E:00100:s:\n"
"E:00110:r:\n"
"E:00111:u:\n"
"E:10000:E:\n"
"E:10001: :\n"
"E:001010:.:\n"
"E:001011:i:\n"
"E:101101:0x3a:\n"
"E:1011000:y:\n"
"E:1011001:t:\n"
"E:1011100:g:\n"
"E:1011110:4:\n"
"E:101110110:w:\n"
"E:101111100:c:\n"
"E:101111110:b:\n"
"E:1011101010:R:\n"
"E:1011101011:F:\n"
"E:1011101111:C:\n"
"E:10111010001:k:\n"
"E:10111010010:f:\n"
"E:10111010011:o:\n"
"E:10111011100:U:\n"
"E:10111011101:L:\n"
"E:10111110101:e:\n"
"E:10111110110:N:\n"
"E:10111111100:h:\n"
"E:10111111111:D:\n"
"E:101111101000:M:\n"
"E:101111101111:\':\n"
"E:101111111100:2:\n"
"E:101111111101:-:\n"
"E:1011101000011:q:\n"
"E:1011111010010:O:\n"
"E:1011111010011:A:\n"
"E:10111010000001:S:\n"
"E:10111010000100:):\n"
"E:10111110111000:T:\n"
"E:10111110111001:,:\n"
"E:101110100001010:P:\n"
"E:1011101000010110:ESCAPE:\n"
"E:1011101000010111:z:\n"
"F:00:o:\n"
"F:10:r:\n"
"F:010:e:\n"
"F:110:i:\n"
"F:111:a:\n"
"F:0110:l:\n"
"F:01110:u:\n"
"F:0111100: :\n"
"F:0111101:O:\n"
"F:01111101:A:\n"
"F:01111111:B:\n"
"F:011111100:f:\n"
"F:0111110000:.:\n"
"F:0111110011:L:\n"
"F:01111100010:M:\n"
"F:01111100101:T:\n"
"F:01111110101:C:\n"
"F:01111110110:W:\n"
"F:011111001000:0x3a:\n"
"F:011111101000:U:\n"
"F:011111101001:\':\n"
"F:011111101111:1:\n"
"F:0111110010010:y:\n"
"F:0111110010011:,:\n"
"F:01111110111010:I:\n"
"F:011111101110011:h:\n"
"F:0111111011100101:K:\n"
"F:0111111011101100:F:\n"
"F:0111111011101101:ESCAPE:\n"
"F:01111110111011100:X:\n"
"F:01111110111011101:R:\n"
"G:00:r:\n"
"G:01:a:\n"
"G:101:o:\n"
"G:110:e:\n"
"G:1001:u:\n"
"G:1111:i:\n"
"G:10001:n:\n"
"G:11101:l:\n"
"G:1110000:y:\n"
"G:1110001: :\n"
"G:1110011:w:\n"
"G:10000111:P:\n"
"G:11100101:h:\n"
"G:100001000:-:\n"
"G:100001100:C:\n"
"G:111001001:M:\n"
"G:1000011010:B:\n"
"G:1110010000:.:\n"
"G:1110010001:I:\n"
"G:10000100100:;:\n"
"G:10000100101:,:\n"
"G:10000100110:A:\n"
"G:10000110111:0x3a:\n"
"G:1000011011000:O:\n"
"G:100001101101000:K:\n"
"G:100001101101001:2:\n"
"G:100001101101011:\':\n"
"G:1000011011011100:ESCAPE:\n"
"G:1000011011011110:T:\n"
"G:1000011011011111:S:\n"
"H:00:e:\n"
"H:01:a:\n"
"H:10:o:\n"
"H:110:i:\n"
"H:1111:u:\n"
"H:11100:R:\n"
"H:1110100:P:\n"
"H:1110110:y:\n"
"H:11101011:I:\n"
"H:111011100:Q:\n"
"H:111011101:M:\n"
"H:111011111: :\n"
"H:1110101000:S:\n"
"H:1110101001:.:\n"
"H:11101010101:G:\n"
"H:111010101001:E:\n"
"H:1110101011101:L:\n"
"H:11101010111101:w:\n"
"H:11101010111110:v:\n"
"H:111010101000101:W:\n"
"H:111010101000110:D:\n"
"H:111010101111110:s:\n"
"H:1110101010001110:ESCAPE:\n"
"H:1110101010001111:r:\n"
"I:0:n:\n"
"I:110:t:\n"
"I:1001:s:\n"
"I:1111:r:\n"
"I:10000:T:\n"
"I:10101:a:\n"
"I:11100: :\n"
"I:100010:c:\n"
"I:101001:m:\n"
"I:101100:z:\n"
"I:101101:.:\n"
"I:101111:d:\n"
"I:111011:I:\n"
"I:1000111:\':\n"
"I:1011101:l:\n"
"I:10100000:A:\n"
"I:10100001:v:\n"
"I:10111001:V:\n"
"I:11101001:f:\n"
"I:11101011:o:\n"
"I:100011001:C:\n"
"I:100011010:P:\n"
"I:101000100:w:\n"
"I:101000110:0x3a:\n"
"I:101110000:p:\n"
"I:111010000:R:\n"
"I:111010001:,:\n"
"I:111010101:Y:\n"
"I:1000110000:E:\n"
"I:1000110001:6:\n"
"I:1000110111:q:\n"
"I:1010001011:y:\n"
"I:1110101000:g:\n"
"I:1110101001:D:\n"
"I:10001101100:e:\n"
"I:10001101101:5:\n"
"I:10100010100:S:\n"
"I:10100010101:9:\n"
"I:10100011111:F:\n"
"I:10111000100:b:\n"
"I:10111000110:-:\n"
"I:101000111101:):\n"
"I:1011100010100:N:\n"
"I:1011100010101:Q:\n"
"I:1011100010110:k:\n"
"I:1011100010111000:ESCAPE:\n"
"I:1011100010111001:h:\n"
"J:00:e:\n"
"J:10:a:\n"
"J:11:o:\n"
"J:011:u:\n"
"J:0101:i:\n"
"J:01000: :\n"
"J:0100110:D:\n"
"J:0100111:.:\n"
"J:01001001:r:\n"
"J:010010110:s:\n"
"J:0100100000:M:\n"
"J:0100100010:J:\n"
"J:0100100011:,:\n"
"J:0100101000:B:\n"
"J:0100101001:-:\n"
"J:0100101110:K:\n"
"J:0100101111:T:\n"
"J:01001000010:C:\n"
"J:01001010110:n:\n"
"J:0100100001110:w:\n"
"J:0100100001111:R:\n"
"J:0100101011100:F:\n"
"J:0100101011111:\':\n"
"J:010010101110110:ESCAPE:\n"
"K:00:i:\n"
"K:01:a:\n"
"K:10:e:\n"
"K:1111:y:\n"
"K:11000:n:\n"
"K:11001:o:\n"
"K:11011:r:\n"
"K:11101: :\n"
"K:110100:\':\n"
"K:111000:u:\n"
"K:1101011:.:\n"
"K:1110011:l:\n"
"K:11100101:h:\n"
"K:110101000:T:\n"
"K:110101011:G:\n"
"K:111001001:,:\n"
"K:1101010100:w:\n"
"K:11010100101:4:\n"
"K:11010100110:A:\n"
"K:11010101010:3:\n"
"K:11100100000:2:\n"
"K:110101001110:-:\n"
"K:110101010110:0x3a:\n"
"K:110101010111:!:\n"
"K:111001000010:):\n"
"K:111001000101:S:\n"
"K:1110010000110:6:\n"
"K:1110010000111:1:\n"
"K:11010100111111:L:\n"
"K:11100100010000:I:\n"
"K:11100100010001:?:\n"
"K:110101001111100:ESCAPE:\n"
"K:1101010011110100101000110:3:\n"
"L:00:i:\n"
"L:10:o:\n"
"L:011:]:\n"
"L:110:e:\n"
"L:111:a:\n"
"L:0100:u:\n"
"L:010100:l:\n"
"L:010101:A:\n"
"L:010111:y:\n"
"L:01011011: :\n"
"L:010110000:I:\n"
"L:010110101:,:\n"
"L:0101100101:\':\n"
"L:01011001101:.:\n"
"L:01011001110:C:\n"
"L:01011010010:L:\n"
"L:010110011001:t:\n"
"L:010110100111:S:\n"
"L:0101100110001:h:\n"
"L:01011001100000:E:\n"
"L:010110011000010:T:\n"
"L:010110011000011:P:\n"
"L:010110100000000:D:\n"
"L:010110100110101:j:\n"
"L:0101101001101000:ESCAPE:\n"
"M:00:o:\n"
"M:11:a:\n"
"M:011:e:\n"
"M:101:i:\n"
"M:0101:c:\n"
"M:1001:u:\n"
"M:01001:y:\n"
"M:10001:r:\n"
"M:100000:S:\n"
"M:100001:P:\n"
"M:0100001: :\n"
"M:01000001:C:\n"
"M:01000110:F:\n"
"M:010000000:1:\n"
"M:010001000:h:\n"
"M:010001010:I:\n"
"M:010001110:T:\n"
"M:010001111:X:\n"
"M:0100000010:A:\n"
"M:0100010010:z:\n"
"M:01000101110:.:\n"
"M:010000001101:K:\n"
"M:010000001110:B:\n"
"M:010001001111:s:\n"
"M:010001011000:R:\n"
"M:010001011001:W:\n"
"M:010001011010:O:\n"
"M:0100000011110:,:\n"
"M:0100000011111:\':\n"
"M:0100010110111:D:\n"
"M:0100010111110:E:\n"
"M:01000100111010:ESCAPE:\n"
"M:01000101111010:l:\n"
"M:01000101111111:w:\n"
"M:010001001110111:V:\n"
"M:010001011011010:6:\n"
"M:010001011011011:2:\n"
"N:00:a:\n"
"N:10:o:\n"
"N:11:e:\n"
"N:011:i:\n"
"N:01010:u:\n"
"N:01011:E:\n"
"N:010010:A:\n"
"N:0100010:y:\n"
"N:0100110:g:\n"
"N:01000001:B:\n"
"N:01000010:I:\n"
"N:01000111: :\n"
"N:010000001:\':\n"
"N:010000111:Y:\n"
"N:010011100:L:\n"
"N:010011101:H:\n"
"N:0100001100:C:\n"
"N:0100111100:W:\n"
"N:0100111110:N:\n"
"N:0100111111:T:\n"
"N:010000110101:M:\n"
"N:010000110111:O:\n"
"N:010011110100:,:\n"
"N:010011110111:h:\n"
"N:0100000011111:\':\n"
"N:0100001101001:.:\n"
"N:0100111101101:ESCAPE:\n"
"O:111:n:\n"
"O:0000:s:\n"
"O:0001:N:\n"
"O:0011:z:\n"
"O:0100:r:\n"
"O:1000:u:\n"
"O:1010:p:\n"
"O:1011:l:\n"
"O:1101:\':\n"
"O:00101:U:\n"
"O:01011:h:\n"
"O:01110:f:\n"
"O:01111:w:\n"
"O:10010:.:\n"
"O:11000: :\n"
"O:001000:o:\n"
"O:001001:J:\n"
"O:010100:b:\n"
"O:010101:m:\n"
"O:011011:v:\n"
"O:100111:c:\n"
"O:110011:x:\n"
"O:1001101:d:\n"
"O:1100100:a:\n"
"O:01100001:t:\n"
"O:01100010:k:\n"
"O:10011000:g:\n"
"O:011000000:K:\n"
"O:100110010:i:\n"
"O:110010111:V:\n"
"O:0110000011:2:\n"
"O:0110001101:S:\n"
"O:0110001110:B:\n"
"O:1001100110:W:\n"
"O:1001100111:-:\n"
"O:01100000100:,:\n"
"O:01100011000:j:\n"
"O:01100011001:L:\n"
"O:01100011111:I:\n"
"O:11001011001:A:\n"
"O:11001011011:C:\n"
"O:011000001010:0x3a:\n"
"O:011000111100:e:\n"
"O:110010110000:y:\n"
"O:110010110001:/:\n"
"O:110010110100:M:\n"
"O:01100000101110:E:\n"
"O:01100000101111:D:\n"
"O:11001011010101:T:\n"
"O:110010110101000:ESCAPE:\n"
"O:11001011010100000111011:;:\n"
"P:11:a:\n"
"P:000:i:\n"
"P:010:e:\n"
"P:011:l:\n"
"P:100:o:\n"
"P:101:r:\n"
"P:0010:h:\n"
"P:001111:u:\n"
"P:0011010:C:\n"
"P:0011100:.:\n"
"P:0011101: :\n"
"P:00110000:B:\n"
"P:00110010:D:\n"
"P:00110111:s:\n"
"P:001100011:O:\n"
"P:001100111:,:\n"
"P:0011000101:y:\n"
"P:0011001100:M:\n"
"P:0011011000:E:\n"
"P:0011011001:\':\n"
"P:0011011011:3:\n"
"P:00110001001:T:\n"
"P:001100010000:L:\n"
"P:001100010001:G:\n"
"P:001100110110:A:\n"
"P:001100110111:S:\n"
"P:001101101000:w:\n"
"P:001101101001:F:\n"
"P:0011001101011:J:\n"
"P:0011011010100:f:\n"
"P:0011011010101:R:\n"
"P:0011011010111:t:\n"
"P:00110011010100:V:\n"
"P:00110110101100:Y:\n"
"P:00110110101101:I:\n"
"P:0011001101010100:ESCAPE:\n"
"Q:1:u:\n"
"Q:00:V:\n"
"Q:011: :\n"
"Q:0101:.:\n"
"Q:01000:a:\n"
"Q:0100100:w:\n"
"Q:0100110:E:\n"
"Q:0100111:C:\n"
"Q:01001011:&:\n"
"Q:010010101:\':\n"
"Q:01001010010:ESCAPE:\n"
"R:01:a:\n"
"R:11:o:\n"
"R:100:i:\n"
"R:101:e:\n"
"R:0000:p:\n"
"R:0011:u:\n"
"R:00011:E:\n"
"R:00100:h:\n"
"R:000100: :\n"
"R:001010:y:\n"
"R:00010100:D:\n"
"R:00010110:.:\n"
"R:00101100:T:\n"
"R:00101110:S:\n"
"R:000101010:F:\n"
"R:001011010:B\n"
"R:001011011:n:\n"
"R:001011111:A:\n"
"R:0001010110:w:\n"
"R:0001011100:N:\n"
"R:0001011101:&:\n"
"R:0001011110:V:\n"
"R:0001011111:H:\n"
"R:0010111101:\':\n"
"R:00010101110:t:\n"
"R:00010101111:I:\n"
"R:001011110000:C:\n"
"R:001011110010:O:\n"
"R:00101111000100:,:\n"
"R:00101111001101:ESCAPE:\n"
"S:1:]:\n"
"S:0000:a:\n"
"S:0010:h:\n"
"S:0111:t:\n"
"S:00010:p:\n"
"S:00011:,:\n"
"S:00110:L:\n"
"S:01000:i:\n"
"S:01001:u:\n"
"S:01010:o:\n"
"S:01011:c:\n"
"S:01100:e:\n"
"S:001111:k:\n"
"S:0011100:w:\n"
"S:0110101: :\n"
"S:0110111:m:\n"
"S:00111010:q:\n"
"S:01101000:M:\n"
"S:01101001:n:\n"
"S:01101100:l:\n"
"S:001110110:P:\n"
"S:011011011:y:\n"
"S:0011101110:A:\n"
"S:01101101001:.:\n"
"S:001110111101:r:\n"
"S:001110111110:S:\n"
"S:001110111111:W:\n"
"S:011011010000:C:\n"
"S:011011010101:E:\n"
"S:011011010110:v:\n"
"S:0110110100011:ESCAPE:\n"
"S:0110110101000:I:\n"
"S:0110110101111:g:\n"
"S:00111011110010:4:\n"
"S:00111011110011:1:\n"
"S:01101101000100:O:\n"
"S:01101101011100:z:\n"
"S:011011010001011:B:\n"
"S:011011010111010:H:\n"
"S:011011010111011:T:\n"
"S:0011101111000100:G:\n"
"S:0011101111000111:D:\n"
"S:0110110100010100:-:\n"
"S:0110110101001100:3:\n"
"S:0110110101001101:2:\n"
"S:00111011110001010:\':\n"
"S:01101101010011101:s:\n"
"S:01101101010011110:j:\n"
"S:01101101010011111:b:\n"
"S:011011010001010110:J:\n"
"S:011011010001010111:F:\n"
"S:011011010100111000:0x3a:\n"
"T:0:h:\n"
"T:100:o:\n"
"T:1010:V:\n"
"T:1011:w:\n"
"T:1100:r:\n"
"T:1111:e:\n"
"T:11010:a:\n"
"T:11011:i:\n"
"T:11100:u:\n"
"T:1110100:H:\n"
"T:1110110:W:\n"
"T:11101010: :\n"
"T:11101011:y:\n"
"T:111011101:M:\n"
"T:111011111:x:\n"
"T:1110111000:S:\n"
"T:11101110010:A:\n"
"T:11101111001:s:\n"
"T:11101111011:J:\n"
"T:111011110000:.:\n"
"T:1110111001101:-:\n"
"T:1110111100011:L:\n"
"T:1110111101000:C:\n"
"T:1110111101011:c:\n"
"T:11101110011000:T:\n"
"T:11101110011001:U:\n"
"T:11101111000101:4:\n"
"T:11101111010010:O:\n"
"T:111011110100110:E:\n"
"T:111011110100111:,:\n"
"T:111011110101010:\':\n"
"T:1110111100010001:;:\n"
"T:1110111101010010:ESCAPE:\n"
"T:1110111101010111:D:\n"
"T:11101111000100000:0x3a:\n"
"T:11101111010100110:R:\n"
"T:11101111010100111:N:\n"
"T:11101111010101101:B:\n"
"U:00:K:\n"
"U:10:n:\n"
"U:011:S:\n"
"U:110:p:\n"
"U:1111:l:\n"
"U:01010:s:\n"
"U:01011:r:\n"
"U:11101:R:\n"
"U:010000:g:\n"
"U:111000: :\n"
"U:0100111:.:\n"
"U:1110010:m:\n"
"U:01000100:k:\n"
"U:01000101:t:\n"
"U:01000110:E:\n"
"U:01000111:-:\n"
"U:01001000:F:\n"
"U:01001100:2:\n"
"U:11100110:c:\n"
"U:11100111:N:\n"
"U:010010100:,:\n"
"U:010010111:Z:\n"
"U:0100101010:h:\n"
"U:0100110100:i:\n"
"U:0100110101:w:\n"
"U:0100110110:a:\n"
"U:01001010110:b:\n"
"U:010010110001:V:\n"
"U:010010110011:I:\n"
"U:010010110100:B:\n"
"U:010011011111:d:\n"
"U:0100101101101:C:\n"
"U:0100110111101:z:\n"
"U:01001101111000:ESCAPE:\n"
"U:01001101111001:T:\n"
"U:0100110111100000100111:\':\n"
"V:01: :\n"
"V:11:i:\n"
"V:000:.:\n"
"V:001:a:\n"
"V:101:e:\n"
"V:10001:C:\n"
"V:10011:o:\n"
"V:1000011:I:\n"
"V:10000001:1:\n"
"V:10000101:4:\n"
"V:10010000:r:\n"
"V:10010010:E:\n"
"V:10010011:s:\n"
"V:10010101:\':\n"
"V:10010110:0x3a:\n"
"V:10010111:l:\n"
"V:100000001:/:\n"
"V:100001001:-:\n"
"V:100100010:D:\n"
"V:100100011:u:\n"
"V:100101001:,:\n"
"V:1000000001:2:\n"
"V:1000010000:5:\n"
"V:1001010000:;:\n"
"V:10010100010:ESCAPE:\n"
"V:100001000100:7:\n"
"V:1000010001010:9:\n"
"V:1000010001110:A:\n"
"V:1000010001111:8:\n"
"V:1001010001111:W:\n"
"V:10010100011101:B:\n"
"W:00:h:\n"
"W:10:i:\n"
"W:011:a:\n"
"W:110:o:\n"
"W:111:e:\n"
"W:0100:r:\n"
"W:01011:O:\n"
"W:0101001: :\n"
"W:0101010:y:\n"
"W:010100000:B:\n"
"W:010100001:.:\n"
"W:010101100:I:\n"
"W:010101110:W:\n"
"W:010101111:A:\n"
"W:0101000100:\':\n"
"W:0101000111:T:\n"
"W:01010001100:2:\n"
"W:01010001101:0x3a:\n"
"W:01010110100:H:\n"
"W:01010110110:V:\n"
"W:010101101010:l:\n"
"W:010101101110:s:\n"
"W:0101011010111:u:\n"
"W:010101101011011:E:\n"
"W:0101011010110100:ESCAPE:\n"
"X:1: :\n"
"X:000:a:\n"
"X:0011:m:\n"
"X:0111:t:\n"
"X:01010:-:\n"
"X:01011:e:\n"
"X:011000:u:\n"
"X:011001:I:\n"
"X:011011:,:\n"
"X:0100010:V:\n"
"X:0110101:.:\n"
"X:01000000:S:\n"
"X:01000010:0x3a:\n"
"X:01000111:i:\n"
"X:010000111:X:\n"
"X:0100001100:):\n"
"X:01000011010:ESCAPE:\n"
"Y:1:o:\n"
"Y:00:e:\n"
"Y:010:u:\n"
"Y:01100:a:\n"
"Y:01110:v:\n"
"Y:01111: :\n"
"Y:0110100:n:\n"
"Y:01101010:r:\n"
"Y:01101101:O:\n"
"Y:01101111:i:\n"
"Y:011011000:L:\n"
"Y:011011001:s:\n"
"Y:011011101:m:\n"
"Y:0110101100:.:\n"
"Y:0110111001:P:\n"
"Y:011011100010:2:\n"
"Y:0110111000000:-:\n"
"Y:0110111000110:C\n"
"Y:0110111000111:,:\n"
"Y:01101110000010:ESCAPE:\n"
"Y:01101110000011:d:\n"
"Z:01:a:\n"
"Z:10:e:\n"
"Z:11:o:\n"
"Z:0010:z:\n"
"Z:0011:i:\n"
"Z:00001:Z:\n"
"Z:00010: :\n"
"Z:00011:u:\n"
"Z:0000011:.:\n"
"Z:00000000:y:\n"
"Z:00000010:,:\n"
"Z:0000001101:-:\n"
"Z:00000011110:ESCAPE:\n"
"[:1:S:\n"
"[:01:A:\n"
"[:0000:2:\n"
"[:0010:R:\n"
"[:0011:1:\n"
"[:000101:n:\n"
"[:0001111:l:\n"
"[:00010011:r:\n"
"[:00011101:b:\n"
"[:000100001:C:\n"
"[:000100010:f:\n"
"[:000100101:M:\n"
"[:000111001:c:\n"
"[:0001000111:K:\n"
"[:0001001000:H:\n"
"[:0001110001:T:\n"
"[:00010000000:J:\n"
"[:00010000001:B:\n"
"[:00010001101:Z:\n"
"[:00010010011:P:\n"
"[:00011100000:L:\n"
"[:000100011000:F:\n"
"[:000100100101:I:\n"
"[:000111000011:N:\n"
"[:0001000110010:s:\n"
"[:0001001001001:G:\n"
"[:0001110000101:D:\n"
"[:00011100001000:O:\n"
"[:000111000010010:ESCAPE:\n"
"[:000111000010011:W:\n"
"]:1:STOP:\n"
"]:01: :\n"
"]:001:.:\n"
"]:0001:[:\n"
"]:00001:0x3a:\n"
"]:000001:,:\n"
"]:000011: :\n"
"]:00000000:ESCAPE:\n"
"]:0000110000100:G:\n"
"a:01:n:\n"
"a:001:r:\n"
"a:101:t:\n"
"a:0000:m:\n"
"a:1001:s:\n"
"a:1110: :\n"
"a:1111:l:\n"
"a:00011:d:\n"
"a:10000:i:\n"
"a:11000:y:\n"
"a:11010:c:\n"
"a:000100:p:\n"
"a:100010:u:\n"
"a:100011:v:\n"
"a:110011:g:\n"
"a:110110:b:\n"
"a:110111:k:\n"
"a:0001010:w:\n"
"a:00010111:z:\n"
"a:11001000:.:\n"
"a:11001011:f:\n"
"a:000101100:,:\n"
"a:000101101:\':\n"
"a:110010011:e:\n"
"a:110010101:h:\n"
"a:1100101001:x:\n"
"a:11001001000:a:\n"
"a:11001001001:-:\n"
"a:11001001011:j:\n"
"a:11001010000:0x3a:\n"
"a:11001010001:o:\n"
"a:110010010100:q:\n"
"a:11001001010100:!:\n"
"a:11001001010111:?:\n"
"a:1100100101010100:ESCAPE:\n"
"a:1100100101010110:;:\n"
"a:1100100101010111:):\n"
"a:1100100101011001:/:\n"
"a:1100100101011011:@:\n"
"a:11001001010101010:J:\n"
"a:11001001010101011:]:\n"
"a:11001001010110101:L:\n"
"a:110010010101100000:R:\n"
"a:110010010101100001:S:\n"
"a:110010010101100010:V:\n"
"a:11001001010110001110:P:\n"
"b:00:e:\n"
"b:010:u:\n"
"b:011:a:\n"
"b:100:y:\n"
"b:101:o:\n"
"b:1100:l:\n"
"b:1110:r:\n"
"b:1111:i:\n"
"b:110100:s:\n"
"b:110110: :\n"
"b:110111:b:\n"
"b:11010101:c:\n"
"b:110101000:j:\n"
"b:110101100:,:\n"
"b:110101101:.:\n"
"b:1101010011:\':\n"
"b:1101011111:t:\n"
"b:11010100101:0x3a:\n"
"b:11010111000:w:\n"
"b:11010111001:d:\n"
"b:11010111010:h:\n"
"b:11010111011:&:\n"
"b:11010111101:-:\n"
"b:110101111000:m:\n"
"b:110101111001:n:\n"
"b:1101010010000:?:\n"
"b:1101010010010:v:\n"
"b:11010100100010:f:\n"
"b:11010100100111:p:\n"
"b:110101001000111:;:\n"
"b:110101001001101:D:\n"
"b:1101010010001100:/:\n"
"b:11010100100110001:k:\n"
"b:1101010010011000010:ESCAPE:\n"
"b:1101010010011000011:!:\n"
"b:110101001001100000000000:STOP:\n"
"c:00:o:\n"
"c:011:a:\n"
"c:100:e:\n"
"c:110:h:\n"
"c:0100:i:\n"
"c:0101:l:\n"
"c:1011:k:\n"
"c:1111:t:\n"
"c:10100:u:\n"
"c:10101:r:\n"
"c:11100: :\n"
"c:1110100:y:\n"
"c:1110101:c:\n"
"c:11101101:s:\n"
"c:11101110:.:\n"
"c:111011111:,:\n"
"c:1110110001:G:\n"
"c:11101100001:n:\n"
"c:11101100110:D:\n"
"c:11101111000:K:\n"
"c:11101111011:C:\n"
"c:111011000000:0x3a:\n"
"c:111011001001:-:\n"
"c:111011001010:A:\n"
"c:111011001110:L:\n"
"c:111011001111:\':\n"
"c:111011110010:d:\n"
"c:111011110100:q:\n"
"c:111011110101:I:\n"
"c:1110110010000:N:\n"
"c:1110110010001:z:\n"
"c:1110111100111:F:\n"
"c:11101100000101:w:\n"
"c:11101100000111:E:\n"
"c:11101100101100:?:\n"
"c:11101111001100:M:\n"
"c:11101111001101:S:\n"
"c:111011000001000:b:\n"
"c:111011000001001:ESCAPE:\n"
"c:111011000001100:!:\n"
"c:111011001011010:Q:\n"
"c:111011001011011:P:\n"
"c:111011001011100:;:\n"
"c:111011001011110:B:\n"
"c:1110110000011011:V:\n"
"c:1110110010111011:m:\n"
"c:1110110010111110:/:\n"
"c:11101100000110101:):\n"
"c:11101100101110100:U:\n"
"c:11101100101111110:W:\n"
"c:111011000001101001:H:\n"
"c:111011001011111110:R:\n"
"c:111011001011111111:T:\n"
"d:0: :\n"
"d:101:e:\n"
"d:1100:a:\n"
"d:1110:i:\n"
"d:10001:.:\n"
"d:10011:o:\n"
"d:11011:r:\n"
"d:11111:s:\n"
"d:100001:d:\n"
"d:100101:l:\n"
"d:110100:u:\n"
"d:111101:y:\n"
"d:1001001:-:\n"
"d:1101011:v:\n"
"d:1111000:g:\n"
"d:1111001:,:\n"
"d:10000000:h:\n"
"d:10000001:0x3a:\n"
"d:10000010:m:\n"
"d:10010000:w:\n"
"d:10010001:n:\n"
"d:11010101:\':\n"
"d:100000111:f:\n"
"d:1101010001:?:\n"
"d:1101010010:b:\n"
"d:1101010011:c:\n"
"d:10000011000:!:\n"
"d:11010100000:p:\n"
"d:11010100001:t:\n"
"d:100000110010:STOP:\n"
"d:100000110011:):\n"
"d:100000110100:k:\n"
"d:100000110101:;:\n"
"d:100000110111:/:\n"
"d:10000011011010:\":\n"
"d:10000011011011:j:\n"
"d:100000110110000:z:\n"
"d:100000110110011:q:\n"
"d:1000001101100011:@:\n"
"d:1000001101100100:ESCAPE:\n"
"d:10000011011001010:]:\n"
"e:10: :\n"
"e:010:s:\n"
"e:110:r:\n"
"e:0000:d:\n"
"e:0011:a:\n"
"e:1111:n:\n"
"e:00010:c:\n"
"e:01100:e:\n"
"e:01101:w:\n"
"e:01111:t:\n"
"e:11100:l:\n"
"e:000110:x:\n"
"e:001000:v:\n"
"e:001001:i:\n"
"e:001010:y:\n"
"e:011100:m:\n"
"e:111010:.:\n"
"e:0001110:f:\n"
"e:0010111:b:\n"
"e:0111010:,:\n"
"e:1110110:p:\n"
"e:00011110:-:\n"
"e:00011111:h:\n"
"e:00101100:k:\n"
"e:01110110:\':\n"
"e:11101110:g:\n"
"e:11101111:o:\n"
"e:001011011:0x3a:\n"
"e:0010110100:):\n"
"e:0010110101:q:\n"
"e:0111011101:?:\n"
"e:0111011110:u:\n"
"e:01110111000:z:\n"
"e:01110111110:!:\n"
"e:011101111110:STOP:\n"
"e:011101111111:j:\n"
"e:0111011100110:/:\n"
"e:01110111001001:4:\n"
"e:01110111001010:B:\n"
"e:01110111001110:]:\n"
"e:01110111001111:;:\n"
"e:011101110010000:\":\n"
"e:0111011100101100:ESCAPE:\n"
"e:0111011100101110:@:\n"
"e:01110111001000100:T:\n"
"e:01110111001011111:L:\n"
"e:011101110010110100:V:\n"
"e:011101110010110101:G:\n"
"e:011101110010111100:1:\n"
"e:011101110010111101000:2:\n"
"e:011101110010111101001:N:\n"
"e:0111011100101111011110:M:\n"
"e:0111011100101111011111:H:\n"
"f:00:o:\n"
"f:10: :\n"
"f:010:i:\n"
"f:110:r:\n"
"f:0111:a:\n"
"f:1110:e:\n"
"f:01100:t:\n"
"f:11110:u:\n"
"f:11111:f:\n"
"f:011011:l:\n"
"f:01101000:s:\n"
"f:01101001:y:\n"
"f:011010110:.:\n"
"f:0110101000:?:\n"
"f:0110101011:,:\n"
"f:0110101111:-:\n"
"f:01101010011:0x3a:\n"
"f:01101010100:\':\n"
"f:01101010101:g:\n"
"f:011010100100:m:\n"
"f:011010111000:ESCAPE:\n"
"f:011010111010:b:\n"
"f:011010111011:n:\n"
"f:0110101001011:c:\n"
"f:0110101110010:!:\n"
"f:01101011100110:):\n"
"f:01101011100111:w:\n"
"f:011010100101010:/:\n"
"f:0110101001010000:h:\n"
"f:0110101001010001:STOP:\n"
"f:0110101001010110:;:\n"
"f:01101010010101111:v:\n"
"f:011010100101000100:STOP:\n"
"g:11: :\n"
"g:000:a:\n"
"g:010:h:\n"
"g:101:e:\n"
"g:0011:u:\n"
"g:0110:r:\n"
"g:1000:i:\n"
"g:01110:l:\n"
"g:10010:s:\n"
"g:10011:o:\n"
"g:001001:,:\n"
"g:001010:n:\n"
"g:011110:g:\n"
"g:011111:.:\n"
"g:0010110:y:\n"
"g:00100001:\':\n"
"g:00100010:-:\n"
"g:00100011:0x3a:\n"
"g:001000000:d:\n"
"g:001011101:b:\n"
"g:001011110:t:\n"
"g:001011111:w:\n"
"g:0010000010:?:\n"
"g:0010000011:m:\n"
"g:00101110001:!:\n"
"g:00101110011:f:\n"
"g:001011100001:;:\n"
"g:001011100101:STOP:\n"
"g:0010111000000:k:\n"
"g:0010111001000:p:\n"
"g:00101110000010:):\n"
"g:00101110000011:\":\n"
"g:001011100100101:c:\n"
"g:001011100100111:/:\n"
"g:0010111001001000:ESCAPE:\n"
"g:0010111001001100:]:\n"
"g:0010111001001101:z:\n"
"g:001011100101000000:STOP:\n"
"h:0:e:\n"
"h:100:o:\n"
"h:101:i:\n"
"h:110: :\n"
"h:1111:a:\n"
"h:111001:r:\n"
"h:111011:t:\n"
"h:11100001:y:\n"
"h:11100011:l:\n"
"h:11101000:.:\n"
"h:11101001:n:\n"
"h:11101011:u:\n"
"h:111000000:d:\n"
"h:111000100:s:\n"
"h:111010100:,:\n"
"h:1110000011:w:\n"
"h:1110001010:\':\n"
"h:1110001011:-:\n"
"h:11101010101:m:\n"
"h:11101010110:0x3a:\n"
"h:11101010111:b:\n"
"h:111000001001:c:\n"
"h:111000001011:?:\n"
"h:111010101000:!:\n"
"h:1110000010000:):\n"
"h:1110000010100:h:\n"
"h:1110000010101:k:\n"
"h:1110101010011:f:\n"
"h:11101010100101:g:\n"
"h:111000001000100:p:\n"
"h:111000001000101:;:\n"
"h:111000001000110:/:\n"
"h:111000001000111:STOP:\n"
"h:111010101001001:v:\n"
"h:1110101010010000:q:\n"
"h:11101010100100010:ESCAPE:\n"
"h:111010101001000110:\":\n"
"h:11101010100100011100:z:\n"
"h:1110000010001110000000:STOP:\n"
"i:10:n:\n"
"i:000:t:\n"
"i:010:s:\n"
"i:0011:l:\n"
"i:1100:o:\n"
"i:1101:c:\n"
"i:1111:e:\n"
"i:00100:a:\n"
"i:01100:m:\n"
"i:01101:d:\n"
"i:01110:v:\n"
"i:11100:g:\n"
"i:11101:r:\n"
"i:001010:p:\n"
"i:011110:f:\n"
"i:0010110:z:\n"
"i:0111110: :\n"
"i:00101111:b:\n"
"i:01111110:k:\n"
"i:001011100:-:\n"
"i:001011101:x:\n"
"i:0111111100:u:\n"
"i:0111111110:q:\n"
"i:01111111010:.:\n"
"i:01111111110:,:\n"
"i:011111110111:w:\n"
"i:011111111111:\':\n"
"i:0111111101101:i:\n"
"i:0111111111101:j:\n"
"i:01111111011001:0x3a:\n"
"i:01111111111000:h:\n"
"i:011111110110000:/:\n"
"i:011111111110011:y:\n"
"i:0111111101100011:?:\n"
"i:0111111111100100:P:\n"
"i:01111111111001011:!:\n"
"i:011111111110010100:):\n"
"i:0111111101100010001:C:\n"
"i:0111111101100010010:ESCAPE:\n"
"i:01111111011000100110:D:\n"
"i:01111111011000100111:;:\n"
"i:0111111101100010000000:STOP:\n"
"j:0:o:\n"
"j:11:u:\n"
"j:101:a:\n"
"j:1001:e:\n"
"j:10000:i:\n"
"j:100011:y:\n"
"j:1000101: :\n"
"j:10001001:.:\n"
"j:100010000:\':\n"
"j:1000100011:t:\n"
"j:10001000100:n:\n"
"j:100010001011:s:\n"
"j:1000100010100:ESCAPE:\n"
"j:1000100010101:h:\n"
"k:10: :\n"
"k:11:e:\n"
"k:000:s:\n"
"k:011:i:\n"
"k:0010:.:\n"
"k:01001:y:\n"
"k:001100:\':\n"
"k:001101:a:\n"
"k:001110:p:\n"
"k:001111:,:\n"
"k:010100:l:\n"
"k:010101:f:\n"
"k:010110:n:\n"
"k:0100000:/:\n"
"k:0100010:-:\n"
"k:0100011:o:\n"
"k:01011101:0x3a:\n"
"k:010000111:b:\n"
"k:010111000:w:\n"
"k:010111001:m:\n"
"k:010111100:h:\n"
"k:010111110:u:\n"
"k:010111111:k:\n"
"k:0100001000:r:\n"
"k:0100001001:ESCAPE:\n"
"k:0100001010:?:\n"
"k:0100001100:t:\n"
"k:0100001101:g:\n"
"k:0101111011:d:\n"
"k:01000010110:j:\n"
"k:010000101110:):\n"
"k:010111101000:;:\n"
"k:010111101001:c:\n"
"k:0101111010110:!:\n"
"k:010111101011110:\":\n"
"k:010111101011111:STOP:\n"
"k:0101111010111110000000:STOP:\n"
"l:010:a:\n"
"l:011:i:\n"
"l:100:l:\n"
"l:110:e:\n"
"l:111: :\n"
"l:0000:u:\n"
"l:0001:d:\n"
"l:0010:y:\n"
"l:1011:o:\n"
"l:10100:s:\n"
"l:001100:.:\n"
"l:001110:t:\n"
"l:0011010:v:\n"
"l:0011110:f:\n"
"l:1010100:m:\n"
"l:1010101:k:\n"
"l:1010110:p:\n"
"l:00110111:c:\n"
"l:00111110:-:\n"
"l:10101111:,:\n"
"l:001101101:0x3a:\n"
"l:001111111:b:\n"
"l:101011100:\'\n"
"l:0011011000:r:\n"
"l:0011011001:h:\n"
"l:0011111100:n:\n"
"l:0011111101:g:\n"
"l:1010111011:w:\n"
"l:10101110100:?:\n"
"l:1010111010100:!:\n"
"l:1010111010110:z:\n"
"l:10101110101011:/:\n"
"l:101011101010100:;:\n"
"l:101011101011100:E:\n"
"l:101011101011111:STOP:\n"
"l:1010111010101011:ESCAPE:\n"
"l:1010111010111100:):\n"
"l:1010111010111110:STOP:\n"
"l:10101110101010100:@:\n"
"l:10101110101010101:j:\n"
"l:10101110101111010:\":\n"
"l:101011101011110111:]:\n"
"m:00:a:\n"
"m:01:e:\n"
"m:111: :\n"
"m:1001:p:\n"
"m:1011:o:\n"
"m:1100:i:\n"
"m:10000:.:\n"
"m:10001:s:\n"
"m:11010:u:\n"
"m:11011:m:\n"
"m:101001:y:\n"
"m:101011:b:\n"
"m:1010000:,:\n"
"m:1010100:/:\n"
"m:10100010:]:\n"
"m:101000110:0x3a:\n"
"m:101010100:\':\n"
"m:1010001111:r:\n"
"m:1010101011:f:\n"
"m:1010101100:l:\n"
"m:1010101110:n:\n"
"m:10100011100:?:\n"
"m:10100011101:!:\n"
"m:10101010100:STOP:\n"
"m:10101010101:w:\n"
"m:10101011011:h:\n"
"m:10101011110:-:\n"
"m:101010111110:4:\n"
"m:1010101101010:t:\n"
"m:1010101111110:;:\n"
"m:1010101111111:c:\n"
"m:10101011010000:):\n"
"m:10101011010001:ESCAPE:\n"
"m:10101011010011:d:\n"
"m:101010110100101:g:\n"
"m:1010101010000000:STOP:\n"
"m:10101011010010001:v:\n"
"m:10101011010010010:k:\n"
"m:10101011010010011:z:\n"
"m:1010001000111011111:]:\n"
"n:01: :\n"
"n:001:t:\n"
"n:100:g:\n"
"n:111:d:\n"
"n:0000:s:\n"
"n:1010:a:\n"
"n:1101:e:\n"
"n:10110:c:\n"
"n:11000:i:\n"
"n:000111:.:\n"
"n:101111:n:\n"
"n:110011:o:\n"
"n:0001001:u:\n"
"n:0001011:v:\n"
"n:0001100:f:\n"
"n:1011100:k:\n"
"n:1011101:\':\n"
"n:1100100:y:\n"
"n:1100101:,:\n"
"n:00010000:m:\n"
"n:00010100:l:\n"
"n:00010101:-:\n"
"n:000100011:w:\n"
"n:000110101:0x3a:\n"
"n:0001000101:z:\n"
"n:0001101000:h:\n"
"n:0001101100:b:\n"
"n:0001101101:j:\n"
"n:0001101110:r:\n"
"n:00010001000:p:\n"
"n:00011010011:x:\n"
"n:00011011111:?:\n"
"n:000100010011:;:\n"
"n:000110100101:):\n"
"n:000110111100:!:\n"
"n:000110111101:q:\n"
"n:0001000100100:/:\n"
"n:0001000100101:STOP:\n"
"n:0001101001000:ESCAPE:\n"
"n:00010001001010:STOP:\n"
"n:00011010010010:B:\n"
"n:0001101001001100:]:\n"
"n:0001101001001101:\":\n"
"n:0001101001001110:@:\n"
"n:000110100100001000001:A:\n"
"o:001:u:\n"
"o:011: :\n"
"o:100:r:\n"
"o:111:n:\n"
"o:0000:l:\n"
"o:1100:m:\n"
"o:1101:f:\n"
"o:00010:v:\n"
"o:01000:s:\n"
"o:01001:p:\n"
"o:10100:t:\n"
"o:10101:o:\n"
"o:10111:w:\n"
"o:000110:k:\n"
"o:000111:i:\n"
"o:010100:g:\n"
"o:010111:c:\n"
"o:101101:d:\n"
"o:0101011:e:\n"
"o:0101100:y:\n"
"o:0101101:a:\n"
"o:1011001:b:\n"
"o:01010101:h:\n"
"o:10110000:.:\n"
"o:010101000:-:\n"
"o:010101001:,:\n"
"o:1011000101:\':\n"
"o:1011000111:x:\n"
"o:10110001001:0x3a:\n"
"o:10110001101:z:\n"
"o:101100010001:?:\n"
"o:101100011001:j:\n"
"o:1011000100000:!:\n"
"o:1011000110001:q:\n"
"o:10110001100000:/:\n"
"o:10110001100001:):\n"
"o:1011000100001101:;:\n"
"o:1011000100001110:G:\n"
"o:10110001000011000:\":\n"
"o:10110001000011110:ESCAPE:\n"
"o:101100010000110010:]:\n"
"o:1011000100001111110:B:\n"
"o:10110001000011111110:O:\n"
"o:10110001000011111111:C:\n"
"o:1011000100001111101000:STOP:\n"
"o:101100010000110011110000:@:\n"
"p:001:l:\n"
"p:010: :\n"
"p:011:o:\n"
"p:101:r:\n"
"p:111:e:\n"
"p:0000:p:\n"
"p:1100:a:\n"
"p:1101:i:\n"
"p:00011:t:\n"
"p:10000:u:\n"
"p:10001:h:\n"
"p:10010:s:\n"
"p:000101:m:\n"
"p:0001001:d:\n"
"p:1001101:y:\n"
"p:1001110:.:\n"
"p:1001111:,:\n"
"p:00010000:-:\n"
"p:000100011:?:\n"
"p:100110001:0x3a:\n"
"p:1001100100:\':\n"
"p:1001100101:]:\n"
"p:1001100111:b:\n"
"p:00010001001:f:\n"
"p:00010001010:k:\n"
"p:00010001011:!:\n"
"p:10011000001:c:\n"
"p:10011000010:n:\n"
"p:10011000011:w:\n"
"p:000100010001:;:\n"
"p:100110000001:/:\n"
"p:1001100000001:g:\n"
"p:10011000000001:):\n"
"p:100110000000001:\":\n"
"p:10011000000000000:ESCAPE:\n"
"q:1:u:\n"
"q:000:,:\n"
"q:001:.:\n"
"q:011: :\n"
"q:01001:b:\n"
"q:01010:\':\n"
"q:01011:i:\n"
"q:010001:a:\n"
"q:010000100:ESCAPE:\n"
"r:000:a:\n"
"r:001:o:\n"
"r:100:i:\n"
"r:110: :\n"
"r:111:e:\n"
"r:0100:s:\n"
"r:0101:t:\n"
"r:01110:d:\n"
"r:10100:n:\n"
"r:10101:y:\n"
"r:011010:u:\n"
"r:011011:m:\n"
"r:011111:k:\n"
"r:101101:l:\n"
"r:101110:.:\n"
"r:101111:r:\n"
"r:0110000:f:\n"
"r:0110010:,:\n"
"r:0110011:v:\n"
"r:1011000:c:\n"
"r:1011001:g:\n"
"r:01100011:\':\n"
"r:01111000:-:\n"
"r:01111001:b:\n"
"r:01111011:p:\n"
"r:011000101:0x3a:\n"
"r:011110100:w:\n"
"r:0111101010:?:\n"
"r:0111101011:h:\n"
"r:01100010010:!:\n"
"r:011000100001:q:\n"
"r:011000100010:j:\n"
"r:011000100011:STOP:\n"
"r:011000100110:/:\n"
"r:0110001000001:;:\n"
"r:0110001000110:STOP:\n"
"r:0110001001111:):\n"
"r:01100010011101:z:\n"
"r:011000100000001:\":\n"
"r:011000100000011:]:\n"
"r:0110001000000100:x:\n"
"r:0110001000000101:ESCAPE:\n"
"r:01100010000000011:Z:\n"
"s:0: :\n"
"s:101:t:\n"
"s:1000:.:\n"
"s:1110:e:\n"
"s:10011:,:\n"
"s:11000:o:\n"
"s:11001:s:\n"
"s:11110:h:\n"
"s:11111:i:\n"
"s:100101:c:\n"
"s:110100:u:\n"
"s:110110:p:\n"
"s:1101111:a:\n"
"s:10010001:n:\n"
"s:10010011:m:\n"
"s:11010100:y:\n"
"s:11010110:0x3a:\n"
"s:11011100:l:\n"
"s:11011101:k:\n"
"s:100100001:b:\n"
"s:100100100:f:\n"
"s:110101010:w:\n"
"s:110101111:\':\n"
"s:1001000000:!:\n"
"s:1001000001:g:\n"
"s:1001001010:r:\n"
"s:1101010110:?:\n"
"s:1101010111:-:\n"
"s:1101011101:q:\n"
"s:11010111001:d:\n"
"s:100100101100:/:\n"
"s:100100101101:):\n"
"s:100100101111:STOP:\n"
"s:110101110000:]:\n"
"s:110101110001:;:\n"
"s:1001001011101:v:\n"
"s:100100101110001:\":\n"
"s:100100101110011:z:\n"
"s:1001001011100000:j:\n"
"s:1001001011100001:ESCAPE:\n"
"s:10010010111001011:@:\n"
"s:100100101110010101:T:\n"
"t:10:h:\n"
"t:000:i:\n"
"t:010:o:\n"
"t:011:e:\n"
"t:111: :\n"
"t:0010:a:\n"
"t:00110:u:\n"
"t:11001:r:\n"
"t:11011:s:\n"
"t:001111:.:\n"
"t:110001:t:\n"
"t:110100:y:\n"
"t:0011101:c:\n"
"t:1100001:l:\n"
"t:00111001:-:\n"
"t:11000000:v:\n"
"t:11000001:m:\n"
"t:11010101:w:\n"
"t:11010110:,:\n"
"t:11010111:\':\n"
"t:001110000:n:\n"
"t:0011100011:?:\n"
"t:1101010001:b:\n"
"t:1101010010:0x3a:\n"
"t:00111000100:!:\n"
"t:11010100000:z:\n"
"t:11010100110:d:\n"
"t:11010100111:f:\n"
"t:110101000010:x:\n"
"t:0011100010100:g:\n"
"t:0011100010101:;:\n"
"t:1101010000110:p:\n"
"t:00111000101100:P:\n"
"t:00111000101101:STOP:\n"
"t:00111000101111:):\n"
"t:11010100001110:/:\n"
"t:11010100001111:k:\n"
"t:0011100010110100:STOP:\n"
"t:0011100010111000:@:\n"
"t:0011100010111010:E:\n"
"t:00111000101110011:]:\n"
"t:00111000101110111:\":\n"
"t:001110001011100100:F:\n"
"t:001110001011101100:ESCAPE:\n"
"t:0011100010111001010:j:\n"
"t:0011100010111011010:1:\n"
"u:011:t:\n"
"u:101:n:\n"
"u:110:s:\n"
"u:111:r:\n"
"u:0001:d:\n"
"u:0010:e:\n"
"u:0101:l:\n"
"u:1000:p:\n"
"u:00000:b:\n"
"u:00001: :\n"
"u:00110:i:\n"
"u:01000:a:\n"
"u:01001:g:\n"
"u:10010:c:\n"
"u:10011:m:\n"
"u:0011100:y:\n"
"u:00111010:z:\n"
"u:00111100:\':\n"
"u:00111110:f:\n"
"u:00111111:k:\n"
"u:001111010:,:\n"
"u:0011101101:-:\n"
"u:0011101110:o:\n"
"u:0011110110:.:\n"
"u:0011110111:x:\n"
"u:00111011000:w:\n"
"u:00111011110:0x3a:\n"
"u:001110110010:q:\n"
"u:001110111110:h:\n"
"u:001110111111:v:\n"
"u:0011101100110:j:\n"
"u:001110110011100:u:\n"
"u:001110110011101:?:\n"
"u:0011101100111110:/:\n"
"u:0011101100111111:!:\n"
"u:001110110011110001:STOP:\n"
"u:001110110011110100:;:\n"
"u:001110110011110111:):\n"
"u:0011101100111101010:T:\n"
"u:0011101100111100010000000:STOP:\n"
"v:1:e:\n"
"v:01:i:\n"
"v:000:a:\n"
"v:0011:o:\n"
"v:00101:.:\n"
"v:001001: :\n"
"v:00100001:\':\n"
"v:00100011:y:\n"
"v:001000000:u:\n"
"v:001000100:s:\n"
"v:0010001010:r:\n"
"v:00100000100:-:\n"
"v:00100000110:,:\n"
"v:00100010110:n:\n"
"v:001000001010:g:\n"
"v:001000001011:v:\n"
"v:001000001111:l:\n"
"v:001000101110:@:\n"
"v:001000101111:0x3a:\n"
"v:001000001110010:t:\n"
"v:0010000011100110:d:\n"
"v:001000001110011110:ESCAPE:\n"
"w:00:i:\n"
"w:011:e:\n"
"w:100: :\n"
"w:101:s:\n"
"w:110:h:\n"
"w:0101:a:\n"
"w:1111:o:\n"
"w:01000:.:\n"
"w:01001:w:\n"
"w:11100:n:\n"
"w:1110110:r:\n"
"w:11101010:,:\n"
"w:11101011:l:\n"
"w:11101111:y:\n"
"w:111010010:c:\n"
"w:111011101:b:\n"
"w:1110100010:0x3a:\n"
"w:1110100110:m:\n"
"w:1110100111:\':\n"
"w:1110111000:d:\n"
"w:11101000000:f:\n"
"w:11101000001:]:\n"
"w:11101000010:!:\n"
"w:11101000111:k:\n"
"w:11101110010:-:\n"
"w:111010000111:g:\n"
"w:111010001100:?:\n"
"w:111010001101:t:\n"
"w:111011100111:p:\n"
"w:1110100001101:u:\n"
"w:1110111001101:):\n"
"w:11101000011000:STOP:\n"
"w:11101110011001:j:\n"
"w:111011100110001:q:\n"
"w:1110111001100000:/:\n"
"w:11101110011000010:;:\n"
"w:1110111001100001100:ESCAPE:\n"
"w:111011100110000110001000000:@:\n"
"x:01:p:\n"
"x:11:t:\n"
"x:101: :\n"
"x:0000:i:\n"
"x:0010:a:\n"
"x:1000:c:\n"
"x:00010:u:\n"
"x:00111:e:\n"
"x:10011:-:\n"
"x:000110:f:\n"
"x:001101:o:\n"
"x:100100:.:\n"
"x:0001110:,:\n"
"x:0001111:m:\n"
"x:0011001:y:\n"
"x:10010101:\':\n"
"x:10010110:q:\n"
"x:001100000:s:\n"
"x:100101000:0x3a:\n"
"x:100101110:h:\n"
"x:0011000011:?:\n"
"x:1001010010:l:\n"
"x:1001011110:w:\n"
"x:10010100110:x:\n"
"x:10010100111:b:\n"
"x:10010111111:):\n"
"x:001100001011:/:\n"
"x:0011000010100:4:\n"
"x:0011000010101:!:\n"
"x:1001011111011:;:\n"
"x:001100001010101:STOP:\n"
"x:100101111101001:v:\n"
"x:00110000101010000:!:\n"
"x:100101111101000011000011:ESCAPE:\n"
"y:1: :\n"
"y:000:o:\n"
"y:0011:s:\n"
"y:0101:.:\n"
"y:01001:,:\n"
"y:01100:e:\n"
"y:01110:\':\n"
"y:001001:a:\n"
"y:001010:i:\n"
"y:001011:d:\n"
"y:010001:n:\n"
"y:011011:0x3a:\n"
"y:011111:l:\n"
"y:0010000:w:\n"
"y:0110100:t:\n"
"y:0110101:m:\n"
"y:0111101:-:\n"
"y:00100011:b:\n"
"y:01000000:?:\n"
"y:01000001:r:\n"
"y:01000010:p:\n"
"y:01000011:f:\n"
"y:01111001:c:\n"
"y:0010001001:;:\n"
"y:0010001010:J:\n"
"y:0111100000:h:\n"
"y:0111100001:!:\n"
"y:0111100011:g:\n"
"y:00100010000:):\n"
"y:00100010111:/:\n"
"y:01111000101:]:\n"
"y:001000100011:k:\n"
"y:001000101100:ESCAPE:\n"
"y:001000101101:u:\n"
"y:011110001001:STOP:\n"
"y:0010001000100:z:\n"
"y:0111100010001:\":\n"
"y:00100010001011:j:\n"
"y:01111000100001:2:\n"
"y:001000100010100:y:\n"
"y:001000100010101:x:\n"
"y:0111100010000000:v:\n"
"y:0111100010000001:T:\n"
"y:0111100010000011:P:\n"
"z:10:e:\n"
"z:001:a:\n"
"z:011:z:\n"
"z:110: :\n"
"z:111:i:\n"
"z:0001:l:\n"
"z:0100:y:\n"
"z:01010:o:\n"
"z:000000:c:\n"
"z:000010:,:\n"
"z:000011:.:\n"
"z:010110:w:\n"
"z:0000010:\':\n"
"z:00000110:0x3a:\n"
"z:00000111:t:\n"
"z:01011101:m:\n"
"z:010111000:k:\n"
"z:010111100:-:\n"
"z:010111101:u:\n"
"z:010111111:b:\n"
"z:01011100100:s:\n"
"z:01011100101:/:\n"
"z:01011100111:d:\n"
"z:01011111001:p:\n"
"z:01011111011:?:\n"
"z:010111001100:h:\n"
"z:010111110000:@:\n"
"z:0101111100011:v:\n"
"z:0101111101010:g:\n"
"z:01011100110111:r:\n"
"z:01011111000100:q:\n"
"z:01011111000101:n:\n"
"z:01011111010110:ESCAPE:\n"
"z:0101111101011000111011:;:\n"
"}:0000100000: :\n"
"}:000010000001100111:STOP:";
