/*
 * drivers/amlogic/media/dtv_demod/include/dvbs.h
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#ifndef __DVBS_FUNC_H__
#define __DVBS_FUNC_H__
#include "dvb_frontend.h"

#define CNR_HIGH	0xcae
#define CNR_LOW		0xcad

enum diseq_irq_flag {
	DISEQ_IRQGAPBURST = 0x01,
	DISEQ_IRQFIFO64B = 0x02,
	DISEQ_IRQTXEND = 0x4,
	DISEQ_IRQTIMEOUT = 0x8,
	DISEQ_IRQTRFINISH = 0x10,
	DISEQ_IRQRXFIFO8B = 0x20,
	DISEQ_IRQRXEND = 0x40
};

#define DVBS_REG_MRELEASE	0x100
#define DVBS_REG_DEVICE_ID	0x101

/* t5d dvbs reg */
#define DVBS_REG_SYS_IRQMSK1	0x150
#define DVBS_REG_SYS_IRQMSK0	0x151
#define DVBS_REG_SYS_IRQSTATUS1	0x152
#define DVBS_REG_SYS_IRQSTATUS0	0x153
#define DVBS_REG_SYS_IRQFORCE1	0x154
#define DVBS_REG_SYS_IRQFORCE0	0x155

#define DVBS_REG_GPIO0CFG	0x180
#define DVBS_REG_GPIO1CFG	0x181
#define DVBS_REG_GPIO2CFG	0x182
#define DVBS_REG_GPIO3CFG	0x183
#define DVBS_REG_GPIO4CFG	0x184
#define DVBS_REG_GPIO5CFG	0x185
#define DVBS_REG_GPIO6CFG	0x186
#define DVBS_REG_GPIO7CFG	0x187
#define DVBS_REG_GPIOOBS0	0x1A3
#define DVBS_REG_TSTOUT		0x1F0
#define DVBS_REG_TSTIN		0x1F1
#define DVBS_REG_TSTSYS		0x1F2
#define DVBS_REG_TBUSXXX2	0x1F4
#define DVBS_REG_TBUSXXX1	0x1F5
#define DVBS_REG_TBUSXXX0	0x1F6
#define DVBS_REG_BITSPEED1	0x1F7
#define DVBS_REG_BITSPEED0	0x1F8
#define DVBS_REG_TBUSBIT1	0x1F9
#define DVBS_REG_TBUSBIT2	0x1FA
#define DVBS_REG_I2CMAPOCFG	0x1FB
#define DVBS_REG_I2CMAPO11	0x1FC
#define DVBS_REG_I2CMAPO10	0x1FD
#define DVBS_REG_I2CMAPO21	0x1FE
#define DVBS_REG_I2CMAPO20	0x1FF

#define DVBS_REG_DISIRQCFG	0x300
#define DVBS_REG_DISIRQSTAT	0x301
#define DVBS_REG_DISTXCFG	0X302
#define DVBS_REG_DISTXSTATUS	0x303
#define DVBS_REG_DISTXBYTES	0x304
#define DVBS_REG_DISTXFIFO	0x305
#define DVBS_REG_DISTXF22	0x306
#define DVBS_REG_DISTXWAIT	0x307
#define DVBS_REG_DISTIMEOCFG	0x308
#define DVBS_REG_DISTIMEOUT	0x309
#define DVBS_REG_DISRXCFG	0x30A
#define DVBS_REG_DISRXSTAT1	0x30B
#define DVBS_REG_DISRXSTAT0	0x30C
#define DVBS_REG_DISRXBYTES	0x30D
#define DVBS_REG_DISRXPARITY1	0x30E
#define DVBS_REG_DISRXPARITY0	0x30F
#define DVBS_REG_DISRXFIFO	0x310
#define DVBS_REG_DISRXDC1	0x311
#define DVBS_REG_DISRXDC0	0x312
#define DVBS_REG_DISRXKOFF	0x313
#define DVBS_REG_DISRXF221	0x314
#define DVBS_REG_DISRXF220	0x315
#define DVBS_REG_DISRXF100	0x316
#define DVBS_REG_DISRXK1	0x317
#define DVBS_REG_DISRXK2	0x318
#define DVBS_REG_DISRXPK	0x319
#define DVBS_REG_DISRXENV	0x31A
#define DVBS_REG_DISRXVMIN	0x31B
#define DVBS_REG_DISRXSHORT22K	0x31C
#define DVBS_REG_ACRPRESC	0x31E
#define DVBS_REG_ACRDIV		0x31F

void dvbs2_diseqc_send_msg(unsigned int len, unsigned char *msg);
void dvbs2_diseqc_read_msg(unsigned int *len, unsigned char *msg);
unsigned int dvbs2_diseqc_irq_check(void);
void dvbs2_diseqc_irq_en(unsigned int onoff);
void dvbs2_diseqc_init(void);
void dvbs2_diseqc_continuous_tone(unsigned int onoff);

#endif
