/*
 * drivers/amlogic/media/video_sink/video_reg.c
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#include <linux/amlogic/media/registers/register.h>
#include "video_reg.h"

struct hw_vd_reg_s vd_mif_reg_legacy_array[MAX_VD_LAYER] = {
	{
		VD1_IF0_GEN_REG,
		VD1_IF0_CANVAS0,
		VD1_IF0_CANVAS1,
		VD1_IF0_LUMA_X0,
		VD1_IF0_LUMA_Y0,
		VD1_IF0_CHROMA_X0,
		VD1_IF0_CHROMA_Y0,
		VD1_IF0_LUMA_X1,
		VD1_IF0_LUMA_Y1,
		VD1_IF0_CHROMA_X1,
		VD1_IF0_CHROMA_Y1,
		VD1_IF0_RPT_LOOP,
		VD1_IF0_LUMA0_RPT_PAT,
		VD1_IF0_CHROMA0_RPT_PAT,
		VD1_IF0_LUMA1_RPT_PAT,
		VD1_IF0_CHROMA1_RPT_PAT,
		VD1_IF0_LUMA_PSEL,
		VD1_IF0_CHROMA_PSEL,
		VD1_IF0_LUMA_FIFO_SIZE,
		VD1_IF0_GEN_REG2,
		VD1_IF0_GEN_REG3,
		VIU_VD1_FMT_CTRL,
		VIU_VD1_FMT_W,
	},
	{
		VD2_IF0_GEN_REG,
		VD2_IF0_CANVAS0,
		VD2_IF0_CANVAS1,
		VD2_IF0_LUMA_X0,
		VD2_IF0_LUMA_Y0,
		VD2_IF0_CHROMA_X0,
		VD2_IF0_CHROMA_Y0,
		VD2_IF0_LUMA_X1,
		VD2_IF0_LUMA_Y1,
		VD2_IF0_CHROMA_X1,
		VD2_IF0_CHROMA_Y1,
		VD2_IF0_RPT_LOOP,
		VD2_IF0_LUMA0_RPT_PAT,
		VD2_IF0_CHROMA0_RPT_PAT,
		VD2_IF0_LUMA1_RPT_PAT,
		VD2_IF0_CHROMA1_RPT_PAT,
		VD2_IF0_LUMA_PSEL,
		VD2_IF0_CHROMA_PSEL,
		VD2_IF0_LUMA_FIFO_SIZE,
		VD2_IF0_GEN_REG2,
		VD2_IF0_GEN_REG3,
		VIU_VD2_FMT_CTRL,
		VIU_VD2_FMT_W,
	}
};

struct hw_vd_reg_s vd_mif_reg_g12_array[MAX_VD_LAYER] = {
	{
		G12_VD1_IF0_GEN_REG,
		G12_VD1_IF0_CANVAS0,
		G12_VD1_IF0_CANVAS1,
		G12_VD1_IF0_LUMA_X0,
		G12_VD1_IF0_LUMA_Y0,
		G12_VD1_IF0_CHROMA_X0,
		G12_VD1_IF0_CHROMA_Y0,
		G12_VD1_IF0_LUMA_X1,
		G12_VD1_IF0_LUMA_Y1,
		G12_VD1_IF0_CHROMA_X1,
		G12_VD1_IF0_CHROMA_Y1,
		G12_VD1_IF0_RPT_LOOP,
		G12_VD1_IF0_LUMA0_RPT_PAT,
		G12_VD1_IF0_CHROMA0_RPT_PAT,
		G12_VD1_IF0_LUMA1_RPT_PAT,
		G12_VD1_IF0_CHROMA1_RPT_PAT,
		G12_VD1_IF0_LUMA_PSEL,
		G12_VD1_IF0_CHROMA_PSEL,
		G12_VD1_IF0_LUMA_FIFO_SIZE,
		G12_VD1_IF0_GEN_REG2,
		G12_VD1_IF0_GEN_REG3,
		G12_VIU_VD1_FMT_CTRL,
		G12_VIU_VD1_FMT_W,
	},
	{
		G12_VD2_IF0_GEN_REG,
		G12_VD2_IF0_CANVAS0,
		G12_VD2_IF0_CANVAS1,
		G12_VD2_IF0_LUMA_X0,
		G12_VD2_IF0_LUMA_Y0,
		G12_VD2_IF0_CHROMA_X0,
		G12_VD2_IF0_CHROMA_Y0,
		G12_VD2_IF0_LUMA_X1,
		G12_VD2_IF0_LUMA_Y1,
		G12_VD2_IF0_CHROMA_X1,
		G12_VD2_IF0_CHROMA_Y1,
		G12_VD2_IF0_RPT_LOOP,
		G12_VD2_IF0_LUMA0_RPT_PAT,
		G12_VD2_IF0_CHROMA0_RPT_PAT,
		G12_VD2_IF0_LUMA1_RPT_PAT,
		G12_VD2_IF0_CHROMA1_RPT_PAT,
		G12_VD2_IF0_LUMA_PSEL,
		G12_VD2_IF0_CHROMA_PSEL,
		G12_VD2_IF0_LUMA_FIFO_SIZE,
		G12_VD2_IF0_GEN_REG2,
		G12_VD2_IF0_GEN_REG3,
		G12_VIU_VD2_FMT_CTRL,
		G12_VIU_VD2_FMT_W,
	}
};

struct hw_vd_reg_s vd_mif_reg_sc2_array[MAX_VD_LAYER] = {
	{
		SC2_VD1_IF0_GEN_REG,
		SC2_VD1_IF0_CANVAS0,
		SC2_VD1_IF0_CANVAS1,
		SC2_VD1_IF0_LUMA_X0,
		SC2_VD1_IF0_LUMA_Y0,
		SC2_VD1_IF0_CHROMA_X0,
		SC2_VD1_IF0_CHROMA_Y0,
		SC2_VD1_IF0_LUMA_X1,
		SC2_VD1_IF0_LUMA_Y1,
		SC2_VD1_IF0_CHROMA_X1,
		SC2_VD1_IF0_CHROMA_Y1,
		SC2_VD1_IF0_RPT_LOOP,
		SC2_VD1_IF0_LUMA0_RPT_PAT,
		SC2_VD1_IF0_CHROMA0_RPT_PAT,
		SC2_VD1_IF0_LUMA1_RPT_PAT,
		SC2_VD1_IF0_CHROMA1_RPT_PAT,
		SC2_VD1_IF0_LUMA_PSEL,
		SC2_VD1_IF0_CHROMA_PSEL,
		SC2_VD1_IF0_LUMA_FIFO_SIZE,
		SC2_VD1_IF0_GEN_REG2,
		SC2_VD1_IF0_GEN_REG3,
		SC2_VIU_VD1_FMT_CTRL,
		SC2_VIU_VD1_FMT_W,
	},
	{
		SC2_VD2_IF0_GEN_REG,
		SC2_VD2_IF0_CANVAS0,
		SC2_VD2_IF0_CANVAS1,
		SC2_VD2_IF0_LUMA_X0,
		SC2_VD2_IF0_LUMA_Y0,
		SC2_VD2_IF0_CHROMA_X0,
		SC2_VD2_IF0_CHROMA_Y0,
		SC2_VD2_IF0_LUMA_X1,
		SC2_VD2_IF0_LUMA_Y1,
		SC2_VD2_IF0_CHROMA_X1,
		SC2_VD2_IF0_CHROMA_Y1,
		SC2_VD2_IF0_RPT_LOOP,
		SC2_VD2_IF0_LUMA0_RPT_PAT,
		SC2_VD2_IF0_CHROMA0_RPT_PAT,
		SC2_VD2_IF0_LUMA1_RPT_PAT,
		SC2_VD2_IF0_CHROMA1_RPT_PAT,
		SC2_VD2_IF0_LUMA_PSEL,
		SC2_VD2_IF0_CHROMA_PSEL,
		SC2_VD2_IF0_LUMA_FIFO_SIZE,
		SC2_VD2_IF0_GEN_REG2,
		SC2_VD2_IF0_GEN_REG3,
		SC2_VIU_VD2_FMT_CTRL,
		SC2_VIU_VD2_FMT_W,
	}
};

struct hw_afbc_reg_s vd_afbc_reg_array[MAX_VD_LAYER] = {
	{
		AFBC_ENABLE,
		AFBC_MODE,
		AFBC_SIZE_IN,
		AFBC_DEC_DEF_COLOR,
		AFBC_CONV_CTRL,
		AFBC_LBUF_DEPTH,
		AFBC_HEAD_BADDR,
		AFBC_BODY_BADDR,
		AFBC_SIZE_OUT,
		AFBC_OUT_YSCOPE,
		AFBC_STAT,
		AFBC_VD_CFMT_CTRL,
		AFBC_VD_CFMT_W,
		AFBC_MIF_HOR_SCOPE,
		AFBC_MIF_VER_SCOPE,
		AFBC_PIXEL_HOR_SCOPE,
		AFBC_PIXEL_VER_SCOPE,
		AFBC_VD_CFMT_H,
		AFBCDEC_IQUANT_ENABLE,
		AFBCDEC_IQUANT_LUT_1,
		AFBCDEC_IQUANT_LUT_2,
		AFBCDEC_IQUANT_LUT_3,
		AFBCDEC_IQUANT_LUT_4,
	},
	{
		VD2_AFBC_ENABLE,
		VD2_AFBC_MODE,
		VD2_AFBC_SIZE_IN,
		VD2_AFBC_DEC_DEF_COLOR,
		VD2_AFBC_CONV_CTRL,
		VD2_AFBC_LBUF_DEPTH,
		VD2_AFBC_HEAD_BADDR,
		VD2_AFBC_BODY_BADDR,
		VD2_AFBC_SIZE_OUT,
		VD2_AFBC_OUT_YSCOPE,
		VD2_AFBC_STAT,
		VD2_AFBC_VD_CFMT_CTRL,
		VD2_AFBC_VD_CFMT_W,
		VD2_AFBC_MIF_HOR_SCOPE,
		VD2_AFBC_MIF_VER_SCOPE,
		VD2_AFBC_PIXEL_HOR_SCOPE,
		VD2_AFBC_PIXEL_VER_SCOPE,
		VD2_AFBC_VD_CFMT_H,
		VD2_AFBCDEC_IQUANT_ENABLE,
		VD2_AFBCDEC_IQUANT_LUT_1,
		VD2_AFBCDEC_IQUANT_LUT_2,
		VD2_AFBCDEC_IQUANT_LUT_3,
		VD2_AFBCDEC_IQUANT_LUT_4,
	}
};

struct hw_afbc_reg_s vd_afbc_reg_sc2_array[MAX_VD_LAYER] = {
	{
		SC2_AFBC_ENABLE,
		SC2_AFBC_MODE,
		SC2_AFBC_SIZE_IN,
		SC2_AFBC_DEC_DEF_COLOR,
		SC2_AFBC_CONV_CTRL,
		SC2_AFBC_LBUF_DEPTH,
		SC2_AFBC_HEAD_BADDR,
		SC2_AFBC_BODY_BADDR,
		SC2_AFBC_SIZE_OUT,
		SC2_AFBC_OUT_YSCOPE,
		SC2_AFBC_STAT,
		SC2_AFBC_VD_CFMT_CTRL,
		SC2_AFBC_VD_CFMT_W,
		SC2_AFBC_MIF_HOR_SCOPE,
		SC2_AFBC_MIF_VER_SCOPE,
		SC2_AFBC_PIXEL_HOR_SCOPE,
		SC2_AFBC_PIXEL_VER_SCOPE,
		SC2_AFBC_VD_CFMT_H,
		SC2_AFBCDEC_IQUANT_ENABLE,
		SC2_AFBCDEC_IQUANT_LUT_1,
		SC2_AFBCDEC_IQUANT_LUT_2,
		SC2_AFBCDEC_IQUANT_LUT_3,
		SC2_AFBCDEC_IQUANT_LUT_4,
	},
	{
		SC2_VD2_AFBC_ENABLE,
		SC2_VD2_AFBC_MODE,
		SC2_VD2_AFBC_SIZE_IN,
		SC2_VD2_AFBC_DEC_DEF_COLOR,
		SC2_VD2_AFBC_CONV_CTRL,
		SC2_VD2_AFBC_LBUF_DEPTH,
		SC2_VD2_AFBC_HEAD_BADDR,
		SC2_VD2_AFBC_BODY_BADDR,
		SC2_VD2_AFBC_SIZE_OUT,
		SC2_VD2_AFBC_OUT_YSCOPE,
		SC2_VD2_AFBC_STAT,
		SC2_VD2_AFBC_VD_CFMT_CTRL,
		SC2_VD2_AFBC_VD_CFMT_W,
		SC2_VD2_AFBC_MIF_HOR_SCOPE,
		SC2_VD2_AFBC_MIF_VER_SCOPE,
		SC2_VD2_AFBC_PIXEL_HOR_SCOPE,
		SC2_VD2_AFBC_PIXEL_VER_SCOPE,
		SC2_VD2_AFBC_VD_CFMT_H,
		SC2_VD2_AFBCDEC_IQUANT_ENABLE,
		SC2_VD2_AFBCDEC_IQUANT_LUT_1,
		SC2_VD2_AFBCDEC_IQUANT_LUT_2,
		SC2_VD2_AFBCDEC_IQUANT_LUT_3,
		SC2_VD2_AFBCDEC_IQUANT_LUT_4,
	}
};

struct hw_sr_reg_s sr_reg_array[MAX_SR_NUM] = {
	{
		SRSHARP0_SHARP_SYNC_CTRL,
	},
	{
		SRSHARP1_SHARP_SYNC_CTRL,
	},
};

struct hw_sr_reg_s sr_reg_tm2revb_array[MAX_SR_NUM] = {
	{
		TM2REVB_SRSHARP0_SHARP_SYNC_CTRL,
	},
	{
		TM2REVB_SRSHARP1_SHARP_SYNC_CTRL,
	},
};

struct hw_fg_reg_s fg_reg_g12_array[MAX_VD_LAYER] = {
	{
		G12_FGRAIN_CTRL,
		G12_FGRAIN_WIN_H,
		G12_FGRAIN_WIN_V,
	},
	{
		G12_VD2_FGRAIN_CTRL,
		G12_VD2_FGRAIN_WIN_H,
		G12_VD2_FGRAIN_WIN_V,
	},
};

struct hw_fg_reg_s fg_reg_sc2_array[MAX_VD_LAYER] = {
	{
		SC2_FGRAIN_CTRL,
		SC2_FGRAIN_WIN_H,
		SC2_FGRAIN_WIN_V,
	},
	{
		SC2_VD2_FGRAIN_CTRL,
		SC2_VD2_FGRAIN_WIN_H,
		SC2_VD2_FGRAIN_WIN_V,
	},
};
