/**
 * Copyright (C) 2010, 2012-2014, 2016 ARM Limited. All rights reserved.
 *
 * This program is free software and is provided to you under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation, and any use by you of this program is subject to the terms of such GNU licence.
 *
 * A copy of the licence is included with the program, and can also be obtained from Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

/**
 * @file mali_pmu_power_up_down.c
 */

#include <linux/module.h>
#include "mali_executor.h"

int mali_perf_set_num_pp_cores(unsigned int num_cores)
{
#ifndef CONFIG_MALI_DVFS
	return mali_executor_set_perf_level(num_cores, MALI_TRUE);
#else
	return mali_executor_set_perf_level(num_cores, MALI_FALSE);
#endif
}

EXPORT_SYMBOL(mali_perf_set_num_pp_cores);
