#include <linux/module.h>
#include <linux/i2c.h>
#include <linux/delay.h>

/* Local Headers */
#include "si2151_func.h"
#include "si2151.h"

#define I2C_TRY_MAX_CNT       3  //max try counter

static unsigned int si2151_version = 33; //the old available firmware is 42
static unsigned int delay_det=85;
static unsigned int cvbs_amp=100;
module_param(si2151_version, uint, 0664);
MODULE_PARM_DESC(si2151_version, "\n si2151_version \n");
module_param(delay_det, uint, 0644);
MODULE_PARM_DESC(delay_det, "delay set freq time\n");
module_param(cvbs_amp,uint,0644);
MODULE_PARM_DESC(cvbs_amp, "\n si2151_cvbs_amp_out \n");

static unsigned int si2151_i2c_en = 1;
module_param(si2151_i2c_en,uint,0644);
MODULE_PARM_DESC(si2151_i2c_en, "\n si2151_i2c_en \n");

static unsigned int si2151_loss_prop = 127;
module_param(si2151_loss_prop,uint,0644);
MODULE_PARM_DESC(si2151_loss_prop, "\n si2151_loss prop \n");

unsigned char SI2151_SHARE_XTAL = SI2151_POWER_UP_CMD_CLOCK_MODE_XTAL;
module_param(SI2151_SHARE_XTAL, byte, 0644);
MODULE_PARM_DESC(SI2151_SHARE_XTAL, "\n SI2151_SHARE_XTAL \n");

unsigned char SI2151_XTAL_CAP = SI2151_CRYSTAL_TRIM_PROP_XO_CAP_DEFAULT;
module_param(SI2151_XTAL_CAP, byte, 0644);
MODULE_PARM_DESC(SI2151_XTAL_CAP, "\n SI2151_XTAL_CAP \n");

typedef struct firmware_struct {
	unsigned int firmware_len;
	unsigned char firmware_table[16];
} firmware_struct;

firmware_struct Si2151_FW_1_1b11[] = {
{ 8 , { 0x05,0x11,0xFF,0x58,0x2C,0xE5,0x01,0xC7 } },
{ 16 , { 0x0C,0x21,0x31,0x71,0x05,0x6C,0x05,0x12,0x08,0x29,0xDF,0xA5,0x77,0x46,0xCE,0x29 } },
{ 11 , { 0x0C,0x6D,0x57,0xC2,0x90,0x63,0x12,0xAF,0x42,0xB4,0xA0 } },
{ 11 , { 0x0C,0x66,0x98,0x26,0xE2,0xE3,0x5F,0x85,0x4A,0x9E,0x34 } },
{ 11 , { 0x0C,0x88,0x19,0xA1,0x49,0x73,0x32,0x40,0x42,0x5B,0xC6 } },
{ 11 , { 0x0C,0x32,0xBA,0x10,0x23,0xDF,0xE4,0x96,0x42,0xF4,0xA8 } },
{ 16 , { 0x09,0x92,0x4E,0x20,0xC2,0xFC,0x54,0xD2,0x09,0x39,0x0E,0x39,0x80,0x3B,0x6C,0x82 } },
{ 16 , { 0x08,0x30,0x10,0xA6,0x6B,0x7D,0x1E,0x7A,0x0C,0x6C,0x76,0xFC,0xCA,0xA1,0xAC,0x41 } },
{ 12 , { 0x3B,0x5F,0x80,0x7A,0x21,0x5A,0x06,0xB9,0xA2,0x99,0x11,0x55 } },
{ 16 , { 0x08,0xA3,0xF4,0x7C,0x31,0xEE,0x0E,0xFA,0x0C,0xDD,0x9B,0x1C,0xEA,0x75,0x8E,0x0B } },
{ 14 , { 0x4A,0x0A,0x74,0x0C,0xE0,0x9A,0x22,0xE1,0xD3,0x39,0x1A,0x4A,0x44,0x8F } },
{ 15 , { 0x0C,0xF0,0x38,0x28,0x86,0x66,0xF6,0xF9,0x46,0x49,0x4C,0xCC,0xDA,0x1B,0x5C } },
{ 15 , { 0x0C,0x70,0x8A,0x7E,0x64,0xA4,0x64,0x6F,0x4E,0xFE,0x6C,0xE0,0xF1,0xC6,0xB4 } },
{ 8 , { 0x09,0x37,0x06,0xBA,0x45,0xB3,0x1C,0x0F } },
{ 16 , { 0x3F,0xAC,0x85,0xD2,0x06,0xA5,0xD9,0x01,0x8D,0x33,0x0C,0x18,0xA4,0x40,0x7B,0x82 } },
{ 16 , { 0x37,0x62,0x6B,0xB4,0x15,0xF8,0x65,0xFB,0xD6,0x17,0x6E,0xAF,0x88,0x0A,0x01,0xCB } },
{ 16 , { 0x37,0x8A,0x0E,0xF0,0x10,0x81,0x4D,0xB8,0x0A,0xD3,0xE2,0x6F,0xF3,0x21,0xCB,0x4F } },
{ 16 , { 0x3F,0x0A,0xA3,0x7A,0xA8,0x1B,0x8E,0x92,0x7E,0x97,0x24,0xBF,0x6B,0xE7,0xF7,0xC6 } },
{ 13 , { 0x44,0xCA,0x69,0x74,0x71,0x08,0xB1,0x70,0x8B,0xC9,0x61,0x62,0xE0 } },
{ 16 , { 0x09,0x33,0x4B,0xA0,0x63,0x54,0xA3,0x1D,0x08,0x61,0x6C,0xCE,0x18,0x8B,0x22,0x0A } },
{ 16 , { 0x37,0x96,0xD9,0xED,0x1F,0x6B,0xD0,0x33,0xA2,0x0B,0x25,0x36,0xA6,0x3C,0x17,0xC7 } },
{ 16 , { 0x3F,0x25,0x65,0x94,0x80,0x3F,0x0A,0x91,0x62,0x65,0x8D,0x6C,0xBB,0xF1,0xA2,0x64 } },
{ 16 , { 0x3F,0x65,0x43,0xA1,0xDF,0x41,0xF1,0x67,0xD9,0xC8,0x66,0x4E,0x8F,0xE7,0xE9,0x20 } },
{ 16 , { 0x3F,0x8B,0x0A,0x37,0x20,0x2E,0x39,0x98,0x79,0xDD,0x30,0x3F,0x1E,0x40,0x42,0xAC } },
{ 16 , { 0x3F,0xC5,0x17,0x6A,0x49,0xAA,0x47,0x50,0xCF,0xA6,0x02,0x96,0x7D,0x35,0x65,0x3D } },
{ 13 , { 0x4C,0xF4,0x3B,0xC0,0x50,0x08,0x0D,0x7D,0xE1,0x6B,0xBA,0xC0,0xE7 } },
{ 16 , { 0x3F,0xAC,0xEA,0xCC,0x8C,0xDB,0xD8,0xD6,0x13,0x2F,0x83,0x11,0x02,0xC7,0xE2,0x80 } },
{ 16 , { 0x37,0x8C,0x9A,0x93,0x90,0x7D,0xBA,0x24,0x61,0x96,0xD6,0x52,0xF1,0x25,0x7C,0x44 } },
{ 16 , { 0x37,0x28,0x37,0x4E,0xD8,0xF9,0xBE,0x11,0xFC,0x13,0xFA,0xCB,0x12,0xC9,0x31,0x80 } },
{ 10 , { 0x41,0xCE,0x08,0x0E,0xFE,0x88,0x34,0x7E,0x34,0x71 } },
{ 16 , { 0x08,0x67,0xD4,0xF1,0x9D,0xAD,0xEC,0x85,0x08,0x69,0xB6,0x58,0x39,0x6F,0x2B,0xC6 } },
{ 16 , { 0x09,0xB6,0x26,0x75,0x22,0xF0,0x2B,0x43,0x09,0x6A,0xEB,0x7B,0x93,0xA7,0x13,0x58 } },
{ 16 , { 0x3F,0xB3,0xF9,0xD6,0xB7,0x2C,0x8C,0xC6,0x0B,0x8E,0x5B,0x60,0x41,0x57,0x9B,0x67 } },
{ 16 , { 0x37,0x38,0x39,0xA1,0x33,0xF8,0x2A,0x51,0x10,0x14,0x68,0x84,0x84,0x8C,0xC9,0xDA } },
{ 16 , { 0x3F,0xD5,0x68,0x30,0xCB,0x18,0xF9,0x8B,0xF9,0xC8,0xD9,0xBD,0x30,0x07,0xD3,0x76 } },
{ 11 , { 0x32,0xA3,0x59,0xDD,0xB7,0x05,0x76,0x5C,0xF7,0x3E,0x89 } },
{ 8 , { 0x0C,0x19,0xFE,0xE5,0x84,0xB5,0xA7,0xE0 } },
{ 16 , { 0x37,0x50,0xAC,0x29,0xCB,0x3F,0xA4,0x67,0x0F,0x2D,0x7C,0x34,0xFD,0x78,0x00,0x5B } },
{ 16 , { 0x37,0xC2,0x05,0xC4,0x5F,0x19,0x29,0x29,0x1A,0xD4,0xEA,0x84,0xEA,0x35,0x68,0x7C } },
{ 14 , { 0x3D,0x1F,0xCD,0xA3,0x32,0x6C,0x57,0xCC,0xF8,0x8D,0x57,0xF9,0x94,0xA7 } },
{ 16 , { 0x08,0xA2,0x4C,0x7C,0x43,0x34,0xBC,0x73,0x08,0xE8,0xBF,0x4B,0x9B,0x07,0xFE,0x91 } },
{ 16 , { 0x37,0xA2,0xE5,0xA7,0xAD,0x43,0xDB,0xF1,0x1F,0xA8,0x37,0x5B,0xAE,0x3D,0x99,0xFD } },
{ 16 , { 0x37,0x77,0xDD,0xA3,0x34,0x54,0xDD,0x74,0xA7,0x78,0x30,0x77,0x84,0xBC,0xDB,0x69 } },
{ 16 , { 0x37,0x90,0x7E,0xD3,0xC9,0xDC,0x35,0x6B,0xD8,0x9E,0x12,0xF8,0xFD,0xEE,0x71,0x4B } },
{ 16 , { 0x37,0x93,0xC7,0x98,0xD9,0x29,0xFC,0x04,0xB7,0x34,0x40,0x7A,0x01,0xDC,0x0D,0x00 } },
{ 16 , { 0x37,0x2E,0xFF,0xEC,0xF3,0xDE,0x8E,0x6E,0xAC,0xB4,0xBD,0xA1,0xDD,0xBF,0x5E,0x74 } },
{ 16 , { 0x3F,0x79,0x36,0x1E,0x6F,0x89,0xF9,0x89,0xFE,0x8F,0xCD,0xCE,0x8B,0x6E,0x23,0xE1 } },
{ 16 , { 0x3F,0xAC,0x0B,0x9E,0xFE,0x3F,0x1E,0x08,0x6B,0x1B,0x4A,0x7C,0xF4,0x1E,0xE9,0x81 } },
{ 16 , { 0x37,0xA8,0x81,0xDF,0xA4,0x28,0x54,0xB3,0x37,0x8D,0x0D,0xBC,0xA3,0x49,0x30,0xE7 } },
{ 16 , { 0x3F,0x2E,0x28,0x71,0xAC,0x58,0xC6,0xD3,0xEE,0x11,0x11,0xFE,0x25,0x9A,0x71,0xA8 } },
{ 16 , { 0x37,0x85,0x34,0xD0,0xB7,0x5F,0x36,0x8D,0x84,0x7B,0x3A,0xCE,0xFB,0x8D,0x5E,0x2F } },
{ 16 , { 0x47,0x4E,0x1D,0x02,0x3D,0xA7,0xF2,0x2C,0x08,0x70,0x9D,0x4D,0xFE,0xE6,0x49,0xED } },
{ 12 , { 0x43,0x80,0xD1,0x2F,0x09,0x5A,0x6C,0xB1,0xBA,0x85,0x4C,0xBA } },
{ 16 , { 0x3F,0x30,0xB6,0xE9,0xAF,0x0A,0x23,0x27,0x1D,0x13,0xAC,0xAD,0x4F,0x5E,0xAB,0x57 } },
{ 16 , { 0x3F,0x0C,0x9A,0xE1,0xB8,0x17,0xB1,0xF2,0xD2,0x3D,0x20,0x16,0x11,0x17,0x96,0xA3 } },
{ 16 , { 0x3F,0x61,0x7B,0xF5,0x09,0x1C,0xB3,0x7F,0x49,0xE0,0xFC,0x84,0x8E,0x56,0xCE,0xA4 } },
{ 16 , { 0x47,0x75,0x5C,0x47,0x78,0x98,0x3A,0xAB,0x08,0x64,0x51,0xA8,0x94,0x14,0xBF,0xA5 } },
{ 16 , { 0x37,0x17,0x84,0xFD,0x6C,0xBD,0xC3,0xE0,0x68,0xCE,0x22,0xCE,0xAE,0x36,0xBD,0x74 } },
{ 13 , { 0x3C,0x1F,0xA2,0xFA,0x04,0x7C,0x06,0xBC,0xA4,0xD2,0xBD,0x7B,0x2A } },
{ 8 , { 0x08,0x06,0x1E,0x53,0x3F,0xF9,0x6A,0x03 } },
{ 16 , { 0x37,0x3F,0x36,0xE1,0xCD,0x74,0x31,0x64,0x49,0x75,0x7F,0x1D,0x82,0x43,0xD6,0xE6 } },
{ 16 , { 0x37,0x0C,0x05,0xEA,0xF2,0x20,0x1A,0xE0,0xE6,0xB7,0x7C,0x22,0x83,0x07,0x1D,0xF6 } },
{ 16 , { 0x3F,0xC3,0xAF,0x42,0xEE,0x10,0x87,0x29,0xD8,0xF3,0x8B,0xF4,0x5D,0x9F,0x1B,0x74 } },
{ 16 , { 0x3F,0x20,0x89,0x05,0xB4,0x4B,0x15,0x2F,0xB5,0xC6,0xED,0xC1,0x8D,0x42,0x66,0x28 } },
{ 13 , { 0x44,0x72,0xD2,0x16,0xF4,0x08,0xCD,0x67,0xBD,0xB1,0x4B,0x4A,0x13 } },
{ 14 , { 0x35,0x96,0x28,0xD7,0x38,0xD8,0x12,0x23,0xEC,0x13,0xCA,0x9F,0xB4,0x06 } },
{ 8 , { 0x09,0x39,0xF0,0x99,0xD7,0xEC,0x46,0x4C } },
{ 16 , { 0x3F,0x18,0x44,0x76,0x26,0xBC,0x30,0xA1,0x91,0x99,0xA3,0xDC,0x15,0x2B,0xD2,0xCA } },
{ 16 , { 0x3F,0x15,0xFC,0x08,0x91,0x81,0xD4,0x00,0x0B,0x2F,0xE6,0x3A,0x8A,0x58,0x2E,0x56 } },
{ 16 , { 0x37,0xAE,0xCF,0x38,0x81,0xD7,0x13,0x41,0xB9,0x25,0x4B,0x26,0x32,0x85,0xB6,0x50 } },
{ 16 , { 0x3F,0x52,0xC8,0x1F,0x3C,0xA9,0x39,0x40,0x8C,0x4D,0xA4,0x06,0x15,0x93,0x6F,0x21 } },
{ 13 , { 0x4C,0x57,0x83,0x7F,0xA4,0x09,0xEE,0x2C,0xF3,0x0C,0xAA,0xA6,0x1E } },
{ 16 , { 0x37,0x09,0x67,0x24,0xD6,0xE4,0xDE,0xE3,0xAB,0x2D,0x36,0x60,0x6E,0xA9,0xBD,0x0A } },
{ 8 , { 0x08,0x2E,0xFC,0x67,0x1C,0xA2,0xDF,0xC0 } },
{ 16 , { 0x3F,0x4D,0x0E,0x42,0xB8,0x07,0x1B,0x0B,0x82,0x37,0x90,0xD1,0x13,0x08,0x2B,0xA4 } },
{ 9 , { 0x30,0x79,0x92,0x5B,0x93,0x60,0x5F,0xF2,0x14 } },
{ 8 , { 0x09,0x5C,0x7F,0x1D,0xE5,0x32,0x12,0x24 } },
{ 16 , { 0x3F,0xFE,0x94,0x4C,0xF9,0x72,0x9F,0x4E,0xA0,0xDF,0x65,0xD7,0xD9,0xEE,0x1F,0x2E } },
{ 16 , { 0x3F,0x1F,0x89,0xC3,0x15,0x28,0xAA,0x5D,0xDA,0xDC,0xBB,0x6A,0xAE,0x62,0x8F,0xC3 } },
{ 16 , { 0x37,0x3B,0x9F,0xBE,0x48,0x5D,0x44,0xD5,0x9D,0xE5,0x27,0xEB,0xE7,0xAA,0xD2,0xEF } },
{ 16 , { 0x4F,0x88,0x0F,0x54,0x9E,0x7A,0x13,0xAC,0x09,0xEF,0xE9,0xB5,0x0D,0x34,0x25,0x87 } },
{ 16 , { 0x09,0x50,0x86,0xAA,0x0E,0x28,0xF8,0xD6,0x08,0xA8,0x2B,0x2E,0xEA,0x09,0xA7,0xCE } },
{ 16 , { 0x37,0x95,0xB2,0xAC,0x08,0x16,0xC1,0xD3,0x33,0xDC,0x58,0x81,0x18,0x24,0xDC,0xA9 } },
{ 16 , { 0x3F,0x70,0x80,0x16,0xF3,0x3B,0x1F,0xDD,0x10,0xEF,0xC9,0xDB,0x78,0xAB,0xA1,0x8F } },
{ 16 , { 0x37,0x85,0x04,0xB7,0x95,0x32,0x39,0x9D,0x95,0xCB,0x0C,0xC7,0xE7,0x47,0xD5,0xEE } },
{ 13 , { 0x3C,0xC8,0xCC,0x10,0x13,0x72,0x67,0x64,0xC6,0x65,0xC3,0x60,0xC9 } },
{ 16 , { 0x09,0x62,0x37,0xBC,0x7B,0xDC,0xBE,0xB4,0x08,0x4F,0x2E,0x56,0x4C,0xF6,0x4D,0x89 } },
{ 16 , { 0x37,0xB4,0x17,0x4C,0x7F,0x7E,0xDA,0x13,0x68,0x15,0xEE,0xDE,0xED,0x9F,0xFB,0x22 } },
{ 16 , { 0x3F,0x84,0xD0,0xC5,0x7B,0x87,0xEE,0x1A,0xDC,0xCB,0x03,0x31,0xFF,0x35,0xC7,0xB3 } },
{ 14 , { 0x49,0xCA,0x08,0xAF,0x6A,0xBA,0xFB,0xA6,0x12,0xE5,0x4B,0x8F,0x25,0xC9 } },
{ 8 , { 0x08,0xA1,0xD6,0xC5,0xFE,0xF7,0x09,0xB2 } },
{ 16 , { 0x37,0x86,0x2F,0x97,0xF0,0x10,0x13,0x07,0xA6,0x24,0x43,0xA4,0x1B,0x0B,0x1A,0x8B } },
{ 14 , { 0x4D,0x7C,0xE4,0x7D,0x2E,0xD4,0x09,0xB2,0x6A,0xC0,0xC5,0xA2,0x8D,0xBF } },
{ 11 , { 0x32,0x4A,0x18,0xEB,0x0C,0x1C,0xF2,0x50,0x5B,0x1D,0xE2 } },
{ 8 , { 0x09,0xCE,0x71,0xFC,0x67,0x7F,0x7F,0x48 } },
{ 16 , { 0x37,0x0D,0xA7,0x0A,0x14,0xB9,0x55,0x6E,0x66,0x7E,0x84,0x77,0xBD,0x54,0xBE,0xAE } },
{ 16 , { 0x3F,0x4B,0xC9,0x11,0x5C,0xFB,0x83,0x5C,0x63,0xAC,0xF8,0x53,0x7D,0x50,0xAC,0x2B } },
{ 16 , { 0x37,0x15,0x19,0xF1,0xB0,0x9B,0x9A,0xB0,0xF4,0xED,0xDC,0x88,0x27,0x22,0x76,0x34 } },
{ 16 , { 0x37,0x5F,0x8D,0xDF,0xD5,0x88,0x50,0x50,0xD9,0x35,0x45,0x60,0xEF,0x79,0xFE,0x8A } },
{ 11 , { 0x32,0x20,0xE4,0x19,0xE4,0xF8,0xC9,0x75,0xC6,0xCF,0x11 } },
{ 16 , { 0x09,0x21,0xBD,0xA8,0x64,0x11,0x77,0xE2,0x08,0x0B,0x1E,0x3D,0xA9,0x0A,0x12,0x42 } },
{ 8 , { 0x08,0x78,0x8C,0x4D,0x06,0xDA,0x0C,0xEC } },
{ 16 , { 0x3F,0x3B,0x2B,0x27,0xD6,0xE6,0xA7,0xD0,0x14,0x30,0x69,0x95,0x57,0xF7,0x3B,0xAE } },
{ 16 , { 0x3F,0x3E,0xEF,0x4D,0x56,0xBE,0x26,0x00,0x93,0xEF,0xB5,0xDF,0xC9,0x7F,0x07,0x02 } },
{ 16 , { 0x3F,0x82,0x0C,0xF7,0xDE,0x99,0x81,0xA5,0x40,0x9E,0x50,0xD0,0xF5,0x91,0x66,0xED } },
{ 16 , { 0x3F,0xF9,0x9E,0x36,0xAA,0xE3,0x64,0xE4,0x1C,0xBD,0x3D,0x9E,0x4C,0x3C,0x09,0xB6 } },
{ 12 , { 0x3B,0xBB,0x23,0x8D,0xF4,0xCC,0xE6,0x52,0x7B,0xF2,0xD9,0xF3 } },
{ 8 , { 0x08,0x7E,0x4D,0xC1,0x3E,0x59,0xD5,0x6C } },
{ 12 , { 0x3B,0xF7,0x3B,0x00,0x23,0x28,0xBF,0x7B,0xB4,0x60,0x2F,0x88 } },
{ 16 , { 0x08,0x8D,0x0E,0x15,0xF8,0xB2,0x0F,0xCF,0x09,0x3C,0xF5,0x5E,0x6C,0x80,0x9B,0x5D } },
{ 16 , { 0x3F,0xD4,0x34,0xB7,0xD8,0x22,0xC9,0x6B,0xCC,0x96,0xBE,0xA5,0x42,0x64,0x7C,0x7F } },
{ 16 , { 0x3F,0xBB,0xC6,0x88,0xEF,0xBD,0x15,0xF2,0x22,0x33,0x66,0xD1,0xFE,0x41,0x4F,0x11 } },
{ 9 , { 0x30,0x53,0xB9,0xBE,0x9B,0xAD,0x81,0x9D,0x2B } },
{ 16 , { 0x09,0x0D,0xA9,0xE1,0xF6,0xB0,0x50,0x84,0x08,0x6A,0x84,0xCC,0x54,0x0A,0x69,0x9E } },
{ 8 , { 0x09,0xAD,0x1C,0xF5,0x58,0x0B,0xF0,0x01 } },
{ 12 , { 0x33,0xBE,0xCE,0x5C,0x21,0x0B,0x83,0xDF,0x20,0x84,0x5C,0xF8 } },
{ 16 , { 0x08,0xF0,0xE4,0x4D,0x98,0x17,0xE4,0x19,0x08,0xAD,0xD4,0x41,0x67,0x53,0xDD,0x0B } },
{ 16 , { 0x09,0xCA,0x74,0x04,0x47,0x67,0x31,0x61,0x08,0x55,0xE2,0x2B,0x7E,0x5D,0x16,0x92 } },
{ 16 , { 0x09,0x7C,0xE9,0xED,0xBB,0xB3,0xD3,0x67,0x09,0x02,0x79,0x11,0x0D,0xB9,0x94,0x2C } },
{ 16 , { 0x09,0x91,0x6C,0x00,0x05,0xFE,0xFE,0x1F,0x08,0xB8,0xC7,0xE8,0x63,0x35,0x17,0xDD } },
{ 12 , { 0x0C,0x39,0x23,0xB0,0xA5,0xAC,0x45,0x41,0x43,0x0A,0x80,0xB2 } },
{ 16 , { 0x08,0xDA,0x7C,0x15,0x78,0x11,0xB2,0x32,0x0C,0x10,0x5C,0x4E,0x24,0xF5,0xFE,0x64 } },
{ 12 , { 0x4B,0xF0,0xF4,0xB0,0x08,0xA3,0x01,0xC5,0x4D,0xE4,0xCF,0x60 } },
{ 11 , { 0x0C,0x35,0xD0,0x0F,0xE1,0x58,0x45,0x3C,0x4A,0x1B,0x8C } },
{ 16 , { 0x08,0x4B,0xE0,0x61,0x0D,0x89,0xD2,0x30,0x0C,0xD0,0x85,0xE0,0x4A,0x3F,0x53,0x4E } },
{ 12 , { 0x43,0x76,0xF7,0x16,0x09,0x3C,0x62,0x4B,0x7C,0x9E,0x15,0x71 } },
{ 8 , { 0x0C,0x3E,0x9F,0x77,0x69,0x44,0x2D,0xE0 } }
};

firmware_struct SI2151_FW_3_0b5[] = {
{ 16 , { 0xBF,0x21,0xB1,0xF8,0x50,0xD4,0xBD,0xDA,0x05,0x05,0xEE,0xC4,0xC2,0x3D,0x38,0x3E } },
{ 8 , { 0x05,0x37,0x88,0x3C,0xE8,0x9D,0x8C,0x73 } },
{ 16 , { 0x37,0x7E,0x76,0x05,0x28,0xFF,0xE7,0x9E,0xFF,0xB2,0xAC,0xA8,0x4C,0x34,0x27,0xD5 } },
{ 16 , { 0x37,0x61,0x1B,0x98,0x42,0x2A,0xF4,0x94,0x3A,0x41,0x54,0x62,0xC5,0x63,0x64,0xE8 } },
{ 8 , { 0x0F,0x25,0x9C,0x90,0x29,0xF4,0x01,0xB9 } },
{ 16 , { 0x3F,0x19,0x38,0xD3,0xCF,0x93,0x28,0xE7,0x0F,0x88,0x6E,0x9A,0x63,0x9D,0xC8,0xA9 } },
{ 11 , { 0x3A,0xF5,0x4F,0x80,0x53,0xA7,0x3B,0x61,0x61,0xB8,0x8E } },
{ 11 , { 0x07,0x35,0xFD,0xB8,0x08,0x47,0xD6,0xEF,0x42,0x55,0xB3 } },
{ 11 , { 0x0F,0x37,0x0E,0x93,0x3C,0xC5,0x95,0x6E,0x4A,0x16,0x87 } },
{ 8 , { 0x07,0xE0,0x62,0xC7,0x47,0x85,0x6F,0xE4 } },
{ 16 , { 0x3F,0xD1,0xE5,0xEB,0x0F,0xF8,0x8F,0x2E,0x92,0xEC,0xF8,0xF5,0xF5,0x4B,0x03,0x60 } },
{ 14 , { 0x4A,0xA5,0xC6,0x07,0x43,0x80,0x4D,0x16,0x73,0x23,0x62,0x4A,0x40,0xC6 } },
{ 8 , { 0x07,0xE8,0xC4,0x65,0xF3,0xE8,0xA8,0x40 } },
{ 9 , { 0x38,0xC6,0xF7,0xA0,0x83,0xDE,0x0A,0x2B,0xD9 } },
{ 16 , { 0x0F,0x90,0x5C,0x69,0x81,0x8E,0x3B,0x10,0x0F,0x04,0xB5,0x39,0xC5,0x45,0xD1,0x30 } },
{ 16 , { 0x07,0x94,0xB3,0xE8,0x5A,0xCD,0x12,0x3E,0x0F,0x52,0x02,0x0B,0x4C,0xA8,0x53,0x25 } },
{ 11 , { 0x0F,0x74,0xE6,0x3B,0xC2,0x52,0x80,0x11,0x4A,0xD8,0xF7 } },
{ 14 , { 0x07,0x12,0x8F,0xAF,0x41,0xAA,0x21,0x92,0x45,0x97,0xDE,0x8C,0xDF,0x61 } },
{ 8 , { 0x07,0x6C,0xF5,0xD0,0x97,0x73,0x1D,0x64 } },
{ 9 , { 0x30,0x59,0x7F,0xD1,0xF3,0x95,0x19,0x8C,0x83 } },
{ 11 , { 0x0F,0xA5,0xEB,0x96,0x1A,0xF7,0xDD,0xCF,0x42,0xCF,0x67 } },
{ 8 , { 0x07,0xBF,0x08,0xF6,0x58,0x2B,0xE6,0xF6 } },
{ 16 , { 0x3F,0x7A,0x11,0xF4,0x49,0xA2,0x2B,0x77,0xAA,0xFC,0xA4,0x62,0x96,0x92,0x2E,0x2E } },
{ 14 , { 0x42,0x2E,0xA7,0x07,0x4D,0x77,0x36,0x86,0x14,0xA8,0xF6,0x42,0x50,0xED } },
{ 16 , { 0x07,0xC9,0xCC,0xF5,0x96,0x73,0x36,0x27,0x0F,0x46,0xAD,0xB8,0x42,0xBB,0x20,0x5D } },
{ 8 , { 0x07,0x65,0x6C,0x82,0x0F,0xD3,0x75,0x2C } },
{ 12 , { 0x33,0x94,0xF7,0xCA,0x9B,0x4B,0x3D,0x9D,0x60,0x6A,0xF1,0xCF } },
{ 11 , { 0x0F,0x32,0x3B,0x72,0xF8,0x49,0x84,0xFB,0x42,0x0F,0x42 } },
{ 11 , { 0x07,0x26,0x87,0x28,0x8F,0x05,0xA3,0xAD,0x4A,0x59,0xC3 } },
{ 16 , { 0x0A,0xBE,0xBB,0x9F,0x7D,0xE9,0x1A,0x74,0x12,0xD6,0xED,0xA3,0xB8,0x4A,0xDE,0x61 } },
{ 8 , { 0x0F,0xB0,0x9C,0x7C,0x83,0xAE,0x64,0x9E } },
{ 9 , { 0x30,0x48,0xE3,0xC4,0xDF,0xB6,0x69,0xB1,0x28 } },
{ 11 , { 0x0F,0x33,0xAF,0x5A,0x2A,0xCE,0xFF,0xC2,0x4A,0x91,0x28 } },
{ 8 , { 0x0F,0xF9,0xC1,0x42,0xA9,0x47,0x1C,0x6F } },
{ 15 , { 0x36,0x39,0xE5,0x7D,0x4E,0xFE,0x74,0xA9,0x56,0x6F,0xB5,0x45,0x4E,0x3B,0x11 } },
{ 8 , { 0x07,0x89,0xCB,0x17,0x5D,0x68,0x45,0xE4 } },
{ 16 , { 0x3F,0xE5,0x65,0x79,0xE1,0x2F,0x88,0xAE,0x71,0x61,0xC6,0x44,0x08,0x9A,0xEC,0xA6 } },
{ 8 , { 0x07,0x69,0x5C,0x05,0xA4,0x7B,0x8C,0xB8 } },
{ 16 , { 0x3F,0xFD,0xF6,0x55,0x1C,0xE7,0x84,0xEF,0x78,0xA2,0x15,0x4C,0x27,0x20,0xE2,0xFC } },
{ 9 , { 0x30,0x72,0x05,0x23,0x31,0xA9,0x3F,0x1C,0xD0 } },
{ 11 , { 0x07,0xF3,0xC2,0xC4,0x9E,0xD9,0xD3,0x2E,0x42,0x0A,0x09 } },
{ 8 , { 0x07,0x7F,0x52,0x33,0xF7,0x79,0x0C,0x79 } },
{ 16 , { 0x3F,0xC0,0xCC,0xD6,0x65,0xC1,0xD2,0xEC,0x6F,0xB4,0xDC,0x42,0x26,0xCC,0xDF,0x8F } },
{ 8 , { 0x07,0x7C,0x43,0x52,0xB1,0x44,0x70,0xDC } },
{ 9 , { 0x38,0x66,0xE8,0x62,0xEA,0xE4,0xBA,0xFF,0xBB } },
{ 8 , { 0x0F,0x22,0xFA,0xF3,0xA6,0xE9,0xDC,0xFB } },
{ 15 , { 0x3E,0xE3,0x1F,0x9D,0xC0,0x56,0xB9,0xDD,0x71,0xA1,0x42,0x1C,0xD4,0x7C,0x0E } },
{ 15 , { 0x0F,0x6A,0x56,0xB2,0x84,0x4F,0xB2,0xA9,0x4E,0x67,0x14,0x82,0x57,0x3F,0xC8 } },
{ 11 , { 0x0F,0x87,0xA0,0x15,0x24,0x5F,0x03,0xF9,0x4A,0x50,0xB3 } },
{ 8 , { 0x0F,0x5B,0x7E,0x34,0x20,0x7A,0xC3,0xCF } },
{ 12 , { 0x33,0x5C,0xCB,0x58,0x7F,0x83,0x83,0xF7,0xC0,0x9E,0xC0,0x89 } },
{ 11 , { 0x0F,0x03,0x21,0x5C,0x19,0x58,0x3B,0x1F,0x42,0xB8,0x7B } },
{ 11 , { 0x07,0xDA,0x87,0x66,0x4A,0x8F,0xDB,0xCE,0x4A,0x04,0xBF } },
{ 8 , { 0x0F,0xD1,0xA3,0x5A,0xEC,0xB0,0xE1,0xA0 } },
{ 12 , { 0x3B,0xF6,0x00,0xE4,0x3D,0xDD,0x51,0x25,0x27,0xD2,0x50,0xB6 } },
{ 8 , { 0x0F,0xA2,0x36,0x93,0x50,0xD5,0xF8,0xE1 } },
{ 16 , { 0x3F,0x18,0x99,0xAE,0x84,0x94,0xE4,0x94,0xDE,0x75,0x12,0xE3,0xAA,0xD2,0x3D,0x18 } },
{ 11 , { 0x42,0xDB,0x33,0x07,0x2B,0x3C,0x18,0x8C,0x92,0x18,0x69 } },
{ 16 , { 0x07,0x6C,0x85,0xAA,0x6D,0xFD,0x7A,0xBD,0x07,0xB1,0x16,0x9B,0x5B,0xBA,0x9E,0x52 } },
{ 16 , { 0x3F,0x96,0x5C,0x2B,0x48,0x02,0x12,0x13,0x54,0xDD,0xAA,0x3F,0x44,0x14,0x6E,0x87 } },
{ 14 , { 0x4D,0x4C,0xF3,0x8A,0x52,0x04,0x0F,0x23,0x9C,0x12,0x15,0xB3,0xBA,0x00 } },
{ 14 , { 0x4D,0x2B,0x05,0x56,0x44,0x3A,0x07,0x40,0x3A,0x70,0xDA,0x3C,0x41,0xB2 } },
{ 12 , { 0x33,0xFB,0xE7,0x39,0x88,0x89,0x25,0x73,0x29,0xDB,0x47,0x09 } },
{ 11 , { 0x0F,0x39,0x30,0x9F,0xF9,0xD5,0x7B,0xB5,0x42,0x11,0x97 } },
{ 16 , { 0x07,0xC2,0xCD,0xF1,0x7C,0x63,0x5B,0x26,0x07,0x04,0xDD,0x5B,0x94,0x45,0xC8,0x9C } },
{ 14 , { 0x07,0x0C,0x4A,0x33,0xFA,0x28,0x1D,0x6B,0x4D,0x11,0xDC,0xA2,0xA7,0x84 } },
{ 11 , { 0x0F,0xD1,0x46,0xE6,0x27,0xBB,0xAD,0x8D,0x42,0xCE,0x58 } },
{ 11 , { 0x0F,0xD5,0xE3,0x25,0x5F,0x6F,0x1E,0xFC,0x42,0x93,0x8D } },
{ 8 , { 0x0F,0xD9,0xAB,0xC7,0xD7,0x96,0xF8,0xBE } },
{ 9 , { 0x30,0xA5,0x11,0xDE,0x14,0x5E,0xA3,0x07,0xBE } },
{ 8 , { 0x0F,0xFF,0xB5,0x28,0x4F,0xCF,0xA7,0x3C } },
{ 16 , { 0x3F,0x86,0x17,0x1A,0x00,0x6C,0xBF,0x7F,0x83,0xB2,0x3F,0xE4,0xD2,0xFF,0xC2,0x18 } },
{ 16 , { 0x37,0x37,0x1B,0x81,0x82,0xFE,0x8C,0xC2,0x8A,0xB1,0x1C,0x4A,0x4B,0x8A,0x94,0x66 } },
{ 16 , { 0x37,0x80,0x53,0x9C,0x2B,0x32,0x97,0xE4,0x7A,0x5A,0xE2,0xF3,0x75,0x47,0xA6,0xF1 } },
{ 16 , { 0x3F,0x44,0xCF,0x82,0x2F,0xD8,0x5D,0xED,0x9F,0xC0,0x3A,0x28,0x7F,0x7C,0x21,0x53 } },
{ 15 , { 0x3E,0x31,0x35,0xA6,0xF3,0xC8,0xAA,0x7E,0x98,0x8E,0x60,0x80,0xE0,0xE6,0xCC } },
{ 8 , { 0x07,0xB8,0x98,0xC0,0xA5,0xC9,0x9E,0x6A } },
{ 11 , { 0x32,0xEC,0x2E,0x11,0xB6,0x4C,0x71,0xBF,0xC2,0x31,0x1C } },
{ 8 , { 0x0F,0x00,0x13,0x7B,0x74,0xBC,0xD8,0x8B } },
{ 11 , { 0x32,0x7F,0xFD,0x3D,0x1A,0x34,0x1C,0x25,0x50,0xBB,0xD3 } },
{ 8 , { 0x07,0x7E,0xAE,0x2A,0x43,0x25,0x07,0x9C } },
{ 13 , { 0x34,0x8C,0xF2,0xD5,0x5D,0x83,0xF7,0xD6,0x82,0xD4,0x12,0xB5,0x7B } },
{ 8 , { 0x07,0xBC,0xC7,0x76,0x7E,0xDD,0xF4,0xA2 } },
{ 16 , { 0x3F,0x91,0x33,0x61,0xAB,0x3A,0x7F,0x94,0x75,0x86,0xC8,0x5B,0xB6,0xE9,0x4C,0x6F } },
{ 16 , { 0x37,0xB4,0x2A,0x7D,0xFB,0xDD,0x19,0x38,0xA4,0x06,0xE3,0xF9,0x02,0x25,0x1D,0x5D } },
{ 16 , { 0x37,0x80,0xDD,0xAC,0x0A,0x35,0x44,0xC4,0xC9,0x80,0x46,0x5A,0x84,0x78,0x32,0x08 } },
{ 16 , { 0x37,0x2D,0xA5,0x43,0xA2,0x87,0xDC,0x80,0xE9,0xE0,0xDA,0xDD,0x7B,0xD0,0x94,0x9E } },
{ 16 , { 0x3F,0xD8,0x40,0x1F,0xDC,0x59,0x13,0xC3,0xEA,0x88,0x9F,0x8E,0xD5,0xB8,0x7D,0xDF } },
{ 16 , { 0x37,0x94,0xB8,0x51,0x44,0x90,0x8B,0x9A,0xF7,0x4C,0x51,0xCB,0x3D,0xA7,0xEC,0x49 } },
{ 16 , { 0x3F,0x6E,0x1D,0xD3,0xDB,0x45,0xC1,0x0C,0xA2,0x8E,0xA7,0xD4,0x32,0x7A,0x41,0x13 } },
{ 16 , { 0x3F,0xFA,0x54,0xF6,0xCB,0x58,0x83,0x00,0x60,0x60,0x06,0x62,0x42,0xAD,0xD2,0xD9 } },
{ 16 , { 0x37,0xAD,0x2E,0xDB,0x84,0xB3,0xFE,0xB6,0x7C,0xA9,0x6D,0x2D,0x40,0x30,0x10,0x15 } },
{ 16 , { 0x37,0x3D,0xBC,0x3F,0xA5,0xD1,0x7F,0x67,0x2F,0xEE,0x6D,0x40,0x5E,0x9C,0x27,0xCF } },
{ 16 , { 0x3F,0x56,0xDD,0xBE,0x1E,0xC1,0xDE,0xC4,0x2D,0xC5,0xA9,0xC1,0xF6,0x90,0xF5,0x60 } },
{ 16 , { 0x37,0x2E,0xCF,0x9E,0x9E,0x48,0x77,0x0A,0xEF,0x20,0x7F,0xC2,0x3D,0xF3,0x89,0x09 } },
{ 12 , { 0x4B,0x61,0x03,0x39,0x0F,0x42,0x5F,0x38,0xB8,0xE0,0xB1,0x6F } },
{ 16 , { 0x37,0xC0,0xD5,0xD8,0xEE,0xA6,0xD2,0xFA,0x1D,0x3C,0x14,0xE4,0xA8,0x46,0x39,0x81 } },
{ 11 , { 0x42,0xCA,0x93,0x0F,0x49,0xDE,0x8A,0xFD,0x03,0xA9,0x8D } },
{ 16 , { 0x3F,0x00,0x49,0x34,0x7E,0xC3,0xF5,0x0A,0x2D,0x92,0xAC,0x4D,0x5F,0x4A,0x79,0x5C } },
{ 14 , { 0x35,0x62,0xD2,0xB7,0xEB,0x20,0x05,0x91,0x94,0xB3,0xAA,0xC1,0x99,0x0F } },
{ 16 , { 0x0F,0x6A,0x19,0xA9,0x88,0x8C,0x15,0x60,0x07,0x46,0x2D,0xAF,0xAF,0x89,0x27,0x5B } },
{ 8 , { 0x07,0xD9,0x28,0x8D,0x41,0xEA,0x18,0x2D } },
{ 13 , { 0x3C,0xD9,0x32,0x17,0x25,0x6E,0x6F,0xA3,0xAB,0x11,0x31,0x68,0x94 } },
{ 8 , { 0x0F,0xF1,0x57,0xF0,0xA4,0x1C,0x39,0x3F } },
{ 16 , { 0x3F,0xF2,0xF4,0xAE,0xB6,0xD9,0xC2,0xE5,0x32,0x4C,0xCC,0xBE,0xFA,0xE0,0xF4,0xB5 } },
{ 12 , { 0x4B,0xB6,0xAB,0x11,0x07,0x5E,0xFD,0x85,0x07,0x12,0x00,0x4E } },
{ 16 , { 0x0F,0x62,0x77,0x4B,0x1C,0xE7,0xF6,0xCF,0x0F,0x6A,0x38,0xE0,0x0F,0xD3,0x38,0xF5 } },
{ 15 , { 0x46,0x56,0x66,0xEA,0x53,0x0F,0xB1,0x07,0xE1,0xF9,0x0F,0x5D,0x1F,0x87,0xF8 } },
{ 12 , { 0x43,0x78,0x82,0xAD,0x07,0xFE,0x7D,0xA3,0x16,0x91,0xDB,0xE5 } },
{ 16 , { 0x3F,0x6E,0x45,0x3F,0xBF,0x02,0x48,0x32,0x36,0x9C,0x4A,0xCB,0xDA,0x27,0x8B,0x1D } },
{ 16 , { 0x3F,0x80,0x02,0x95,0x30,0x74,0xFB,0xC6,0x4B,0x04,0xFC,0xE1,0x0B,0xCD,0x4B,0x79 } },
{ 16 , { 0x3F,0xB6,0x0A,0xFE,0x6C,0x99,0x59,0x3A,0xD2,0xD9,0x04,0xBF,0x7D,0x39,0xE5,0xB3 } },
{ 16 , { 0x3F,0x59,0x27,0x2B,0x03,0x7B,0xE3,0xE2,0xFF,0x1B,0x86,0x58,0x5D,0xDD,0xA2,0x3B } },
{ 16 , { 0x37,0x42,0x1B,0x79,0xAD,0x8F,0x9B,0x68,0x3A,0x81,0xFA,0x18,0x37,0xC4,0x4F,0x3D } },
{ 16 , { 0x3F,0x14,0x7C,0x79,0x53,0x52,0xA5,0x31,0xA3,0x19,0x57,0xC2,0xDE,0xB5,0x6A,0x14 } },
{ 16 , { 0x3F,0x7E,0x5E,0xB9,0xFE,0xBF,0xCD,0x3E,0xC4,0xA9,0x43,0x9A,0xF8,0xA8,0xF7,0x88 } },
{ 16 , { 0x37,0x99,0xEC,0xB0,0xD5,0x6C,0x71,0x8F,0x91,0x44,0x74,0x4A,0x1B,0x39,0x94,0x29 } },
{ 16 , { 0x3F,0x40,0x38,0x62,0xDD,0x93,0xFB,0xCB,0x05,0xD9,0x88,0x18,0x33,0xB7,0x8A,0xE3 } },
{ 14 , { 0x35,0xA6,0x13,0x62,0xFF,0x44,0x4C,0xF0,0x04,0xCA,0xBA,0xE6,0x5B,0x93 } },
{ 16 , { 0x07,0xFE,0x29,0x6D,0xAD,0x38,0xD1,0xE9,0x07,0xA3,0x64,0x82,0x18,0x5E,0x46,0x84 } },
{ 8 , { 0x07,0x15,0x32,0x84,0x60,0x3E,0xCA,0x70 } },
{ 16 , { 0x37,0x29,0x2C,0xA9,0xD8,0xD6,0x8B,0x10,0x0A,0x60,0x9C,0xA0,0x68,0x6B,0x55,0xE7 } },
{ 16 , { 0x37,0x8B,0x84,0xB7,0x98,0x73,0x79,0x45,0xD8,0x14,0x8F,0xFB,0x76,0x9C,0x3F,0xA0 } },
{ 12 , { 0x3B,0xF1,0x16,0x24,0xC8,0x0B,0x2F,0xF6,0x82,0x38,0x2B,0x04 } },
{ 16 , { 0x0F,0xD4,0xA4,0xF8,0x07,0x6C,0x30,0x5F,0x0F,0x2C,0xF3,0xC5,0x41,0x31,0xF2,0xC9 } },
{ 8 , { 0x07,0x96,0x56,0x07,0x18,0x1C,0xBA,0x48 } },
{ 16 , { 0x37,0x3A,0xCA,0x6D,0xB5,0xC7,0x14,0xDD,0xE5,0x68,0x63,0x10,0x70,0x7D,0xAF,0x36 } },
{ 12 , { 0x4B,0x20,0x19,0xE4,0x07,0x1E,0xBB,0x82,0x34,0xE1,0x73,0x30 } },
{ 8 , { 0x0F,0x38,0x5B,0xBA,0xBD,0x26,0xBF,0xEE } },
{ 16 , { 0x3F,0x57,0x0D,0x9B,0x6B,0x4A,0xD0,0x74,0xC0,0x8A,0x92,0x68,0xA0,0x3C,0xA8,0xF1 } },
{ 16 , { 0x37,0xE9,0x6E,0x50,0x76,0x7C,0x51,0x06,0x70,0x1B,0x06,0x6F,0x42,0xDC,0x8E,0x3E } },
{ 16 , { 0x37,0x2E,0xAB,0x45,0x2C,0xBE,0xDA,0x19,0xA4,0xD5,0xC9,0x66,0xB9,0x0B,0x3A,0x0B } },
{ 14 , { 0x35,0x68,0x6B,0xCC,0x33,0x46,0xF4,0x5F,0x17,0xE5,0x02,0xF0,0xCD,0x65 } },
{ 8 , { 0x07,0xBB,0xE2,0xB6,0xCF,0x13,0xD3,0x6F } },
{ 16 , { 0x3F,0x12,0xA4,0x99,0x1E,0x91,0x51,0x3D,0x77,0x99,0xE4,0x3C,0x7D,0xF4,0xA6,0xBB } },
{ 10 , { 0x31,0x9C,0x6A,0x32,0xCE,0x00,0x1E,0x36,0x59,0x25 } },
{ 16 , { 0x0F,0x6A,0x0B,0x4C,0x7E,0x1F,0x11,0x54,0x0F,0x24,0x71,0xA6,0xC2,0xDA,0x3B,0xBC } },
{ 16 , { 0x0F,0x19,0x13,0x70,0x9E,0x0A,0xF4,0xB5,0x0F,0x58,0x5E,0xC5,0xFC,0x30,0xA4,0x42 } },
{ 8 , { 0x07,0xBC,0xFA,0xCC,0xBD,0x2B,0x76,0xC0 } },
{ 12 , { 0x3B,0x72,0xF4,0xCE,0x70,0x40,0x39,0xFC,0xBA,0xD0,0xA2,0x4F } },
{ 16 , { 0x0F,0x3B,0x9F,0x47,0xED,0xBA,0xA7,0x72,0x0F,0x29,0x3A,0x7A,0x97,0xDA,0x12,0x9C } },
{ 8 , { 0x0F,0x34,0x49,0x97,0x2B,0xB6,0xD0,0x66 } },
{ 16 , { 0x3F,0xAD,0xFB,0xC5,0xDF,0x94,0x43,0xB3,0xE2,0x24,0x27,0x37,0xA1,0x50,0xB6,0x09 } },
{ 10 , { 0x39,0x1D,0x5F,0x06,0x1B,0x96,0x0D,0x48,0x22,0x67 } },
{ 16 , { 0x0F,0x02,0xBA,0xB1,0xDD,0xEA,0x97,0xD3,0x07,0x9E,0x8B,0xD7,0xBB,0x41,0x0A,0x72 } },
{ 13 , { 0x0F,0x25,0xE3,0x4D,0x16,0x55,0x16,0x3B,0x44,0x08,0xB1,0x9D,0x63 } },
{ 16 , { 0x0F,0xF5,0x2A,0xDF,0x2A,0xB7,0x2B,0x0B,0x0F,0xE2,0xFF,0xCC,0x0D,0x37,0x7A,0x9E } },
{ 14 , { 0x45,0x84,0xCE,0x77,0x29,0x6D,0x07,0x09,0x0C,0x6B,0x83,0x21,0x2C,0x15 } },
{ 8 , { 0x07,0x63,0xA0,0x85,0xEF,0x5A,0xD3,0x55 } },
{ 9 , { 0x38,0xD5,0xC5,0xC5,0x3C,0xCB,0x70,0x54,0x69 } },
{ 8 , { 0x07,0x7D,0xA2,0x73,0x6A,0x98,0x4D,0x27 } },
{ 16 , { 0x3F,0x6C,0xE6,0x12,0x77,0x30,0x22,0x34,0xBB,0x27,0xBB,0xCD,0x4E,0xD0,0xE6,0xDF } },
{ 16 , { 0x3F,0x10,0x54,0x9A,0x1F,0x07,0x35,0x14,0xE1,0x33,0x0A,0x9B,0x67,0x4D,0xA0,0x5D } },
{ 12 , { 0x3B,0x56,0x33,0x93,0xC9,0xB3,0x30,0xA1,0x23,0xC8,0xDD,0xF5 } },
{ 8 , { 0x07,0xB2,0x01,0x59,0x31,0xDA,0xE4,0xDF } },
{ 16 , { 0x37,0xA6,0x2C,0xC8,0x2C,0x67,0x87,0xE6,0x00,0x8F,0x3E,0xC7,0x52,0x90,0xBE,0xD4 } },
{ 11 , { 0x4A,0x72,0x20,0x07,0x61,0xFC,0x3E,0x1C,0x7F,0xF4,0x77 } },
{ 14 , { 0x07,0xB2,0x8A,0x78,0xE5,0xED,0x6F,0x10,0x4D,0x47,0x27,0xA0,0x3A,0x71 } },
{ 8 , { 0x07,0xF6,0x45,0x4E,0x76,0x6D,0x01,0xCC } },
{ 16 , { 0x37,0x71,0xE1,0x5E,0xAF,0x55,0x06,0x4B,0x95,0x12,0xFF,0x95,0x6B,0x49,0xC4,0x46 } },
{ 9 , { 0x38,0xCC,0x51,0x29,0xB5,0x81,0x39,0x55,0xB9 } },
{ 8 , { 0x0F,0xD8,0xB3,0xDF,0xE6,0x61,0x5B,0x03 } },
{ 16 , { 0x3F,0xE8,0x82,0xC6,0x1F,0x26,0xBE,0x33,0x3A,0x7A,0x1C,0xBF,0x31,0x90,0x25,0x6B } },
{ 16 , { 0x3F,0x75,0x0F,0xDB,0x5A,0x87,0x26,0x5E,0x67,0x24,0xC3,0xB4,0xE9,0x43,0xAE,0x95 } },
{ 16 , { 0x3F,0xAF,0xE1,0xC1,0x3B,0x56,0x3F,0x19,0xC5,0xE1,0xC4,0xBB,0x63,0x0A,0xC3,0x4E } },
{ 13 , { 0x34,0x26,0xDC,0x69,0xF4,0xA9,0xAC,0x3B,0x98,0x13,0xF6,0x4E,0xAB } },
{ 8 , { 0x0F,0xD4,0x90,0x19,0x0A,0xA5,0x8D,0xB8 } },
{ 16 , { 0x3F,0xD2,0x8D,0xC3,0xA7,0x13,0x44,0x4C,0x23,0xF6,0xD2,0xDC,0xAB,0x0F,0x55,0x82 } },
{ 12 , { 0x4B,0x84,0xBA,0x97,0x0F,0x79,0x49,0xDF,0x1E,0xF9,0xA1,0x48 } },
{ 12 , { 0x33,0xE7,0x23,0x04,0xA1,0x71,0x37,0x3C,0x99,0x5D,0xF2,0x06 } },
{ 8 , { 0x0F,0x27,0xDF,0xFD,0xB0,0xEA,0xD5,0xDD } },
{ 16 , { 0x37,0x8D,0x8A,0xDB,0xDF,0x3F,0xF7,0xCD,0xC7,0x9E,0x7F,0x05,0xFD,0x77,0x33,0x20 } },
{ 11 , { 0x4A,0xDA,0x04,0x0F,0x6A,0xD1,0xB2,0xAA,0x1A,0x55,0x55 } },
{ 16 , { 0x3F,0x39,0xCB,0x0A,0x0C,0x92,0xE1,0xDB,0xB9,0xC6,0x7D,0x11,0x04,0xC7,0x87,0x66 } },
{ 15 , { 0x3E,0x1D,0x65,0x83,0x25,0xCD,0xFE,0x86,0x48,0xD3,0xC1,0x7B,0x03,0x05,0x87 } },
{ 16 , { 0x0F,0x4A,0x31,0xF5,0x39,0x24,0xB8,0x37,0x0F,0x96,0x51,0xCE,0xC1,0xC1,0xF6,0x4B } },
{ 16 , { 0x3F,0xF5,0xCC,0xC2,0x04,0xFC,0x8C,0xAD,0xD6,0x20,0x76,0x08,0x85,0x63,0x2B,0xD1 } },
{ 16 , { 0x3F,0xC3,0x83,0x8A,0xEA,0xF7,0x89,0x94,0x3E,0xE3,0x93,0x5E,0xEC,0xDF,0x40,0x01 } },
{ 12 , { 0x3B,0x1C,0x23,0x40,0xF6,0xD5,0x01,0xF6,0x2A,0x93,0xE4,0x1D } },
{ 8 , { 0x0F,0x0F,0x83,0xE8,0x76,0x50,0x92,0xFA } },
{ 16 , { 0x37,0x82,0x47,0x45,0x7E,0xE2,0x0F,0x32,0x49,0xCD,0x37,0x38,0x2B,0x4B,0x9A,0x8A } },
{ 12 , { 0x43,0x05,0xC8,0x40,0x0F,0x02,0xE3,0x6D,0x30,0x61,0xF1,0x98 } },
{ 16 , { 0x37,0x91,0x37,0xCB,0x68,0x81,0x9A,0xA8,0x61,0xCE,0xBF,0x67,0xC2,0x06,0xE8,0x09 } },
{ 16 , { 0x37,0x12,0xA4,0x7A,0xE4,0x73,0x20,0x90,0xAA,0x78,0x49,0xD0,0xD9,0xE1,0x18,0x47 } },
{ 16 , { 0x3F,0x52,0x80,0x43,0x40,0x41,0x19,0xFA,0xE5,0x06,0x64,0x39,0x94,0x2A,0xB1,0xA4 } },
{ 16 , { 0x37,0xB5,0xDD,0x62,0x66,0x1E,0x0B,0x00,0x0E,0x81,0x73,0x44,0xDB,0xDC,0xC5,0x37 } },
{ 16 , { 0x37,0xF1,0x6B,0x04,0xA6,0xFD,0x2E,0xD3,0x03,0x6B,0x8E,0xAA,0x9F,0x76,0xC5,0xA4 } },
{ 16 , { 0x3F,0x0E,0xAA,0x91,0x72,0xC3,0xFC,0xCD,0x1B,0xD2,0xA3,0x74,0x29,0xF8,0x3F,0xE3 } },
{ 16 , { 0x37,0x24,0xD1,0x29,0xAF,0x44,0xB2,0x93,0x93,0x91,0x69,0xC9,0xE3,0x9D,0x56,0x93 } },
{ 16 , { 0x37,0x2F,0x93,0xAC,0x2F,0x95,0x12,0x32,0x7E,0x48,0x21,0xC5,0xE1,0xBC,0xA7,0xAD } },
{ 9 , { 0x38,0x9C,0xD0,0x3C,0x03,0x8B,0x7E,0x43,0x07 } },
{ 16 , { 0x07,0xC3,0xE2,0x9B,0x18,0x67,0x79,0xE0,0x0F,0xEF,0x99,0xF4,0x9C,0xF2,0xFE,0xF7 } },
{ 8 , { 0x0F,0x52,0xB4,0x2B,0xEA,0xDE,0x46,0xCE } },
{ 9 , { 0x30,0x3B,0x55,0x5E,0x2C,0x34,0x56,0xD4,0x0C } },
{ 8 , { 0x07,0xC7,0x87,0xE0,0x46,0x48,0xD1,0x1B } },
{ 15 , { 0x36,0xDD,0x84,0xBA,0x2B,0x8C,0x84,0x56,0xA1,0x62,0x14,0x49,0x06,0xDA,0x5F } },
{ 8 , { 0x0F,0xB6,0x5B,0xF3,0x92,0xFC,0x8D,0xAA } },
{ 11 , { 0x3A,0xC6,0xAD,0x54,0x97,0x23,0x5A,0x03,0x17,0xDD,0x64 } },
{ 12 , { 0x07,0xB2,0x2B,0x95,0x16,0x06,0x37,0xB1,0x4B,0xFA,0x31,0x04 } },
{ 8 , { 0x07,0xF0,0x84,0xFA,0x66,0xED,0x51,0xCD } },
{ 16 , { 0x3F,0xDF,0x05,0x91,0xCC,0xE7,0x9D,0x26,0x0F,0x01,0xA9,0x2F,0x1B,0xB8,0x0A,0xBB } },
{ 16 , { 0x3F,0xF1,0x49,0xCE,0x04,0x53,0xA9,0x9F,0xA1,0xAC,0x0E,0x58,0x01,0x7C,0x67,0x35 } },
{ 10 , { 0x49,0x4C,0x0F,0x9C,0xB0,0xCD,0x55,0xD9,0xF6,0x70 } },
{ 16 , { 0x3F,0xDE,0x13,0xB5,0x3B,0xDE,0x4E,0x47,0x0B,0x5F,0xB4,0x18,0x04,0xDE,0xE0,0xD2 } },
{ 14 , { 0x3D,0x85,0x5E,0xE1,0x71,0x69,0xCD,0x41,0xF0,0x5B,0x96,0xD4,0x29,0x72 } },
{ 8 , { 0x07,0x8E,0xCC,0xDB,0xD8,0x27,0x78,0x0B } },
{ 16 , { 0x37,0x38,0x08,0x9E,0xC7,0xE3,0x95,0xF2,0xCD,0x5D,0xCA,0xC9,0x47,0xBB,0xE0,0x04 } },
{ 14 , { 0x4D,0x11,0x72,0x0F,0x5E,0x1D,0x07,0xAD,0x6B,0x91,0x10,0x83,0x73,0xF5 } },
{ 16 , { 0x3F,0x12,0x72,0xA8,0x60,0x89,0xA3,0xB0,0xED,0xBE,0x1D,0x50,0x40,0x53,0x68,0x05 } },
{ 10 , { 0x49,0x23,0x07,0x4B,0xB2,0x11,0x36,0x62,0xDB,0x95 } },
{ 12 , { 0x3B,0x5D,0xBD,0xB1,0xEC,0x89,0x9C,0x14,0x04,0xA7,0xCF,0x91 } },
{ 8 , { 0x07,0xF6,0xB7,0xC4,0xF5,0xDB,0xD6,0x63 } },
{ 11 , { 0x32,0x85,0x4A,0x56,0x1E,0x4B,0xAA,0xC6,0xD3,0xC8,0xED } },
{ 8 , { 0x0F,0x06,0x72,0x2F,0x17,0xE1,0xCA,0x13 } },
{ 16 , { 0x37,0x52,0x65,0xC2,0xC7,0xFB,0x89,0xFF,0xC0,0x3F,0xFC,0x71,0x9D,0x25,0x78,0xA0 } },
{ 11 , { 0x42,0xF2,0x84,0x0F,0x27,0x44,0x0C,0x66,0x46,0xDA,0x5C } },
{ 16 , { 0x37,0x22,0x51,0x61,0x14,0x17,0xBF,0x7F,0x9F,0x66,0x66,0x5E,0xA9,0xDC,0x8D,0xDB } },
{ 16 , { 0x3F,0xFE,0xE5,0x71,0x5C,0x57,0xE1,0x45,0x8C,0xBF,0x9B,0x64,0xA3,0xFB,0xF8,0x70 } },
{ 16 , { 0x37,0x3C,0x21,0x70,0x1E,0xB8,0x7F,0x67,0x87,0xB7,0xAF,0x60,0xB8,0xC3,0x90,0xAE } },
{ 12 , { 0x43,0xC1,0x59,0xF0,0x0F,0x1B,0x98,0x95,0x23,0x1F,0x78,0xF8 } },
{ 16 , { 0x07,0xC4,0x9F,0x90,0x47,0x00,0x75,0xAB,0x07,0x98,0xD5,0xE6,0xCE,0x04,0x38,0x1E } },
{ 13 , { 0x0F,0xD5,0x47,0x57,0xDC,0xE1,0xE1,0xFF,0x4C,0x51,0xFC,0xD4,0x87 } },
{ 8 , { 0x0F,0xCE,0x8A,0x5C,0xFA,0xDD,0x0E,0x91 } },
{ 16 , { 0x3F,0x0C,0xE7,0x71,0x60,0x3E,0x73,0x63,0x7C,0x5C,0xD0,0x7C,0xB0,0xD3,0x12,0x07 } },
{ 16 , { 0x3F,0x48,0xB6,0x42,0x9D,0xA2,0x2E,0x0F,0x84,0xA6,0x63,0xCF,0x3D,0xBA,0x70,0xBA } },
{ 13 , { 0x44,0x4B,0x8D,0xBB,0x82,0x07,0xED,0xB2,0xDB,0x83,0x50,0xEC,0xB9 } },
{ 16 , { 0x47,0x58,0x73,0xE5,0x80,0x68,0x3A,0x05,0x0F,0x4F,0x8C,0xCB,0xB0,0x41,0x9D,0x55 } },
{ 9 , { 0x38,0xDE,0x4B,0x78,0xD8,0x07,0x9F,0x91,0xA7 } },
{ 16 , { 0x0F,0xDD,0x11,0xF5,0xEA,0xCB,0x86,0x31,0x0F,0xBB,0xE2,0x90,0x54,0x2A,0xF5,0x72 } },
{ 16 , { 0x07,0x16,0x1A,0x60,0xFE,0x8D,0xBB,0xEE,0x0F,0x82,0xCD,0x90,0xE1,0x7E,0x7A,0x66 } },
{ 16 , { 0x4F,0x1E,0xBB,0xA1,0xAB,0x6E,0xA9,0x6E,0x0F,0x57,0xCD,0x9B,0x84,0x4C,0x79,0xBA } },
{ 8 , { 0x07,0xFA,0xD6,0x7D,0xA2,0x3A,0x39,0x5D } },
{ 16 , { 0x3F,0xB8,0x9E,0xD7,0x7A,0xEA,0x9E,0x94,0xC3,0x09,0x07,0x81,0x77,0xB0,0xFB,0xBC } },
{ 16 , { 0x37,0x08,0x37,0x2A,0x6F,0xBE,0x2D,0x2D,0x27,0x41,0x41,0x23,0xAA,0x33,0xE4,0x22 } },
{ 14 , { 0x3D,0x82,0x43,0x9B,0xCA,0x91,0x6C,0x3E,0xBD,0x6E,0xDF,0x30,0x4B,0x30 } },
{ 8 , { 0x07,0xDB,0x20,0xD6,0xF6,0x82,0x22,0x6A } },
{ 10 , { 0x39,0x8B,0x3F,0x89,0xD8,0x3A,0x93,0x6B,0x9E,0xC7 } },
{ 11 , { 0x0F,0xB8,0x7C,0xB1,0x17,0xBD,0x12,0xE4,0x42,0xEF,0xFF } },
{ 16 , { 0x0F,0x60,0x65,0x98,0x8B,0xA1,0x3F,0x68,0x07,0x6F,0x7D,0xB5,0x1F,0x50,0xE4,0x8C } },
{ 16 , { 0x3F,0x1A,0x52,0x7B,0x5A,0x8C,0x21,0x96,0xBE,0xEC,0x41,0xCA,0x41,0x4D,0xB3,0x40 } },
{ 15 , { 0x36,0x19,0xEA,0x24,0x82,0x68,0xF4,0x94,0xD9,0x32,0x88,0x08,0x80,0xD8,0xA8 } },
{ 15 , { 0x0F,0xC2,0xA8,0x88,0x1A,0x13,0xE9,0x71,0x4E,0xC9,0x44,0x2B,0xF7,0xA7,0xC2 } },
{ 8 , { 0x07,0xDF,0x40,0x91,0x36,0x50,0x67,0x54 } },
{ 16 , { 0x3F,0xFC,0x1A,0x13,0xB3,0xC5,0x79,0xE2,0x3C,0x41,0x25,0x51,0x11,0x22,0xE1,0x8E } },
{ 10 , { 0x49,0xEB,0x07,0x52,0x3D,0x83,0x21,0xE1,0xC6,0xC3 } },
{ 16 , { 0x37,0x38,0x99,0xD0,0x79,0xBE,0x79,0x36,0x35,0x74,0x36,0x2C,0x35,0x8F,0x68,0x95 } },
{ 16 , { 0x37,0xB9,0x7E,0x02,0x7D,0xA8,0xD5,0xF7,0x88,0x78,0x5D,0x84,0x12,0x6C,0x61,0x79 } },
{ 14 , { 0x3D,0xEE,0x31,0xFB,0x94,0x3E,0x12,0xF2,0x48,0x69,0x0B,0x45,0xD0,0xF2 } },
{ 8 , { 0x07,0x58,0x12,0x06,0xA9,0x9C,0x4E,0xB8 } },
{ 16 , { 0x3F,0x43,0x49,0x56,0x87,0x35,0x32,0xD9,0xD7,0xF8,0x6A,0x4D,0xD5,0x0D,0xAB,0x41 } },
{ 8 , { 0x07,0xF2,0x3E,0x03,0x8A,0xCD,0x9A,0x33 } },
{ 16 , { 0x37,0x2F,0x03,0x02,0xBA,0x6A,0x1D,0xBB,0x04,0x41,0x9A,0x2D,0xFC,0x3D,0x2E,0x8B } },
{ 11 , { 0x32,0xA9,0x46,0xBA,0x15,0xEB,0x89,0xD9,0x31,0xD9,0x3B } },
{ 11 , { 0x0F,0xC1,0xBA,0x17,0x15,0xD7,0x5D,0xF2,0x4A,0xF0,0x9A } },
{ 16 , { 0x0F,0xD6,0x67,0x39,0x57,0xFA,0xA9,0xF4,0x07,0xAA,0x67,0x94,0x43,0x80,0x9F,0x92 } },
{ 15 , { 0x3E,0xF1,0xD0,0x74,0xAB,0x8C,0x65,0x3C,0x6B,0x9D,0x52,0x4A,0x32,0x85,0xE2 } },
{ 13 , { 0x0F,0xEC,0x54,0xAB,0x98,0xB4,0xC3,0x60,0x44,0xB1,0x0A,0xFF,0xCC } },
{ 8 , { 0x0F,0x06,0x90,0x91,0x8F,0xE6,0xB9,0xB0 } },
{ 16 , { 0x37,0xFE,0x8D,0xDC,0xF0,0xEE,0x13,0xCE,0x52,0xF0,0xCF,0x8E,0xC1,0x0F,0x50,0x53 } },
{ 16 , { 0x3F,0xDA,0xA8,0xA3,0x0E,0xB0,0xD1,0xF9,0x5B,0x84,0xF3,0xA9,0xF4,0x53,0x30,0x9F } },
{ 16 , { 0x37,0xD1,0x96,0xCE,0x04,0xB2,0x00,0xB3,0xED,0x9D,0x0B,0xF6,0xC5,0x0C,0x8D,0x11 } },
{ 13 , { 0x4C,0x3E,0x02,0x0A,0xD3,0x0F,0xF4,0x07,0x05,0x8C,0xB2,0x35,0x58 } },
{ 8 , { 0x07,0xA8,0xF2,0xC2,0x8D,0x4E,0x09,0x17 } },
{ 16 , { 0x3F,0xB8,0xF0,0x39,0x43,0x6B,0x99,0x0E,0xF9,0xB5,0x8B,0x4B,0xAB,0xF4,0x89,0x9B } },
{ 15 , { 0x46,0xDC,0x23,0x96,0xFF,0xDA,0x67,0x07,0x43,0x32,0x86,0x98,0xF4,0x16,0xD8 } },
{ 16 , { 0x37,0x7E,0x89,0xCC,0x0A,0x11,0x5C,0x15,0x44,0xE0,0x7F,0x07,0xD2,0x84,0xD0,0x89 } },
{ 8 , { 0x07,0x58,0x0B,0xFB,0x86,0x8A,0x15,0x5B } },
{ 16 , { 0x37,0xE8,0xC7,0xA5,0xFB,0xCA,0x15,0xA3,0x73,0x21,0x48,0xA5,0x01,0xF8,0x02,0x6D } },
{ 16 , { 0x47,0x90,0xAD,0xAB,0x23,0x9F,0x1C,0xD1,0x07,0xA5,0x2D,0xDA,0x7D,0xD8,0x1A,0x93 } },
{ 16 , { 0x3F,0x6C,0x78,0xD0,0x93,0x51,0x32,0x13,0xF5,0x31,0x5B,0x81,0x0A,0xC9,0x7D,0x78 } },
{ 8 , { 0x07,0x1E,0x5E,0xCA,0x94,0xD5,0xAC,0x36 } },
{ 16 , { 0x37,0x81,0x62,0x6E,0xF0,0x57,0x7B,0xBD,0xA1,0xC6,0x27,0x43,0xFA,0x94,0x60,0x51 } },
{ 14 , { 0x45,0xC2,0x9B,0xC0,0x3B,0xC3,0x0F,0xAD,0x27,0x05,0x30,0x42,0x8B,0xB5 } },
{ 16 , { 0x37,0x41,0xB3,0x68,0x5D,0x45,0x9D,0xF6,0x1B,0xA0,0xA8,0xF8,0xE0,0x3C,0x3B,0xE2 } },
{ 16 , { 0x4F,0x3B,0xC5,0xDD,0x66,0x4E,0x34,0x4D,0x07,0x1B,0xB7,0xB7,0x91,0x0A,0x16,0x02 } },
{ 8 , { 0x07,0x4E,0xCA,0xA6,0xC9,0xBB,0xED,0x13 } },
{ 14 , { 0x35,0x6B,0x54,0x76,0xAF,0xAE,0x99,0x31,0x50,0xA1,0xF6,0xCD,0xD8,0x09 } },
{ 8 , { 0x07,0x0B,0x8E,0x8D,0x4E,0x76,0x43,0xC3 } },
{ 9 , { 0x38,0xA0,0xDC,0x85,0x10,0x36,0xAF,0x08,0xCF } },
{ 16 , { 0x0F,0x2C,0xE0,0x87,0x76,0xF5,0x35,0xE6,0x07,0x36,0x11,0xD5,0x54,0xDE,0x1B,0x5F } },
{ 8 , { 0x07,0xFD,0xE5,0x38,0x62,0xEB,0x5B,0x3A } },
{ 12 , { 0x3B,0x8D,0x13,0x42,0xDA,0x9C,0xF7,0x44,0xFA,0xF2,0x36,0x63 } },
{ 12 , { 0x07,0x81,0x52,0xA9,0x09,0x16,0x1C,0x59,0x43,0xA2,0x94,0x52 } },
{ 8 , { 0x0F,0x03,0x28,0x69,0x47,0xFD,0x3D,0x02 } },
{ 16 , { 0x3F,0xE6,0x7D,0x07,0x0B,0xF0,0xAA,0xB6,0xCA,0x0D,0x18,0x55,0x53,0xA0,0x56,0x56 } },
{ 13 , { 0x3C,0x65,0x7D,0xC0,0x23,0x85,0xDD,0x21,0x69,0x7B,0xFF,0x44,0x9E } },
{ 8 , { 0x0F,0xCD,0x81,0x71,0x90,0x1B,0x42,0x2B } },
{ 16 , { 0x3F,0x5E,0x33,0x19,0x91,0xD0,0xA2,0x17,0xA6,0xED,0x02,0x84,0x6F,0x4F,0xC0,0x67 } },
{ 14 , { 0x45,0x60,0x88,0x51,0xD8,0x54,0x07,0xD5,0xD9,0xC3,0x29,0xF0,0x85,0x98 } },
{ 16 , { 0x07,0x11,0xED,0x7E,0x4A,0xB5,0x85,0x55,0x0F,0xBA,0xCA,0x55,0xBB,0x39,0x2A,0xA6 } },
{ 16 , { 0x37,0x11,0x18,0xDE,0x57,0xFE,0x66,0x70,0x2D,0x6C,0x56,0x18,0x7F,0x10,0xDF,0xB6 } },
{ 10 , { 0x39,0xF8,0x7F,0x56,0xE2,0x3A,0x7B,0x55,0x6A,0xEC } },
{ 8 , { 0x0F,0x0E,0xAD,0x4D,0x8E,0x00,0x06,0xCB } },
{ 16 , { 0x37,0xAE,0x90,0xE3,0x86,0xA5,0x5C,0x0F,0x2E,0x20,0x78,0x90,0xED,0x54,0x1F,0x18 } },
{ 15 , { 0x3E,0x61,0x60,0x83,0x21,0xBE,0xCF,0x2E,0x04,0x91,0x4F,0xB4,0xE3,0x60,0xF3 } },
{ 16 , { 0x0F,0xA6,0x1F,0x08,0x4F,0x81,0x29,0xEC,0x0F,0x18,0x70,0x0D,0x34,0xE9,0x73,0x64 } },
{ 8 , { 0x0F,0x79,0x96,0x0D,0x78,0xB1,0x0A,0x32 } },
{ 16 , { 0x37,0x27,0xB5,0x9E,0xEC,0xCD,0xA0,0xD5,0x36,0x15,0xB1,0x77,0x3A,0x71,0x15,0x70 } },
{ 15 , { 0x36,0xDA,0xD0,0xF9,0xF8,0xB3,0x39,0x6B,0x2D,0xC4,0xD5,0x4B,0xCC,0xAD,0x27 } },
{ 16 , { 0x07,0xF0,0x92,0x1C,0x74,0x87,0xB9,0x1E,0x07,0xB0,0x9F,0xB5,0x42,0xC6,0x8E,0x0E } },
{ 12 , { 0x33,0xBE,0x5E,0x78,0xB1,0x9A,0xD7,0xBE,0x8D,0x8E,0x47,0x8E } },
{ 16 , { 0x0F,0xD1,0x61,0x6F,0x32,0x27,0x55,0xB0,0x47,0x84,0xDB,0xF3,0x19,0xD7,0xCF,0xA0 } },
{ 16 , { 0x0F,0x4C,0x5E,0xC6,0xAB,0x62,0xB9,0x1C,0x07,0x23,0xA4,0x04,0xBB,0xB7,0xE8,0x3E } },
{ 16 , { 0x07,0xB9,0x1D,0xEC,0xDA,0x51,0x7C,0xEE,0x07,0xEF,0x36,0x6F,0x99,0xA7,0x60,0xEE } },
{ 10 , { 0x31,0xF1,0xA1,0xB0,0x7E,0xF4,0xF0,0xFB,0xD7,0x03 } },
{ 11 , { 0x07,0xA5,0xD3,0x30,0x8B,0x9E,0x18,0xCA,0x4A,0xFE,0xF8 } },
{ 8 , { 0x0F,0x3C,0x2C,0x93,0xDE,0xDD,0x4D,0x7D } },
{ 10 , { 0x31,0x3D,0x04,0x75,0x1D,0xD7,0x88,0xCF,0x79,0x47 } },
{ 14 , { 0x07,0xB0,0x2F,0x40,0xB4,0xBB,0xCD,0xF8,0x45,0x04,0x36,0xAE,0xDD,0x1E } },
{ 12 , { 0x07,0x20,0x97,0x04,0xCB,0xCD,0x75,0xF6,0x4B,0xF0,0x67,0xFD } },
{ 8 , { 0x07,0x63,0x8D,0x9E,0xA6,0x73,0x6C,0x66 } },
{ 16 , { 0x37,0xDD,0xEE,0x63,0xFB,0x69,0xD9,0x97,0x29,0xCD,0x9C,0x28,0xCB,0xF5,0x84,0x14 } },
{ 14 , { 0x4D,0x6E,0xC5,0x07,0xD3,0xF9,0x07,0x93,0xD9,0xC3,0xA8,0x73,0xCE,0x2D } },
{ 16 , { 0x0F,0x50,0xA5,0x8D,0xA4,0x37,0x28,0x5F,0x0F,0x52,0xCD,0xA7,0xDC,0xD4,0x65,0xE2 } },
{ 15 , { 0x4E,0x8C,0xEF,0x15,0x9C,0xBF,0x86,0x07,0x2E,0x1F,0x32,0xA7,0x2F,0x6B,0x57 } },
{ 16 , { 0x0F,0x91,0x68,0xD0,0x0B,0x9C,0xD5,0xE4,0x0F,0xFF,0x25,0x1C,0x00,0xF7,0xAB,0xFD } },
{ 16 , { 0x3F,0x13,0x90,0x4A,0x31,0xAA,0x30,0xFD,0x23,0x42,0x47,0x48,0x93,0x6A,0x67,0xE1 } },
{ 16 , { 0x37,0x18,0x15,0x7E,0xC8,0x54,0xB6,0x4E,0x2A,0xC6,0x5E,0x7B,0x10,0x33,0x6E,0x4A } },
{ 16 , { 0x3F,0x1F,0x68,0xD6,0xE9,0xC4,0x67,0x0A,0x85,0x73,0x8F,0x2C,0xED,0xBF,0x28,0x05 } },
{ 10 , { 0x49,0xC3,0x07,0x50,0x3B,0x78,0xBE,0x7A,0xEC,0x55 } },
{ 16 , { 0x37,0xA6,0x01,0x77,0x03,0x70,0xA6,0xAF,0x1D,0x20,0x64,0xB5,0xD1,0x65,0xAA,0xAF } },
{ 12 , { 0x3B,0x66,0x4A,0x9E,0x1C,0x9B,0xBF,0xC2,0xBD,0xE1,0x2D,0xC8 } },
{ 8 , { 0x07,0xE8,0xD1,0x66,0x37,0x01,0x14,0xB8 } },
{ 9 , { 0x30,0xA6,0xD6,0xD4,0x63,0x39,0x57,0x59,0x07 } },
{ 16 , { 0x0F,0xDF,0x1B,0xDB,0xE2,0xBA,0x2B,0x24,0x0F,0x7B,0xBB,0x49,0x89,0xC8,0x66,0x1F } },
{ 8 , { 0x07,0x9E,0x4E,0x3E,0x1A,0x84,0xC2,0x54 } },
{ 16 , { 0x37,0xD7,0x37,0x60,0x62,0xC9,0x78,0x31,0x90,0xC7,0xA2,0x94,0xF0,0x52,0xC4,0xF9 } },
{ 16 , { 0x3F,0x05,0x4D,0xE0,0xE2,0x40,0xA7,0x92,0x03,0x1C,0xB0,0x0B,0xED,0xFF,0x7D,0xE9 } },
{ 10 , { 0x39,0xDE,0xA0,0x71,0x01,0x82,0xA7,0x55,0x2A,0x84 } },
{ 8 , { 0x0F,0x15,0x60,0xBF,0xAE,0x55,0xDF,0xE3 } },
{ 16 , { 0x3F,0x75,0xB1,0x9F,0x82,0x1A,0x65,0x0D,0x59,0x65,0x2F,0x10,0x51,0xA8,0x95,0x7D } },
{ 10 , { 0x41,0xD2,0x0F,0x44,0x8F,0x80,0x6C,0xF0,0x4B,0x43 } },
{ 12 , { 0x0F,0x28,0x34,0xC5,0x8D,0x81,0xD1,0xBE,0x43,0x77,0x0A,0x5D } },
{ 8 , { 0x07,0xD9,0xBA,0x5C,0xE1,0xD0,0x70,0x8E } },
{ 16 , { 0x3F,0x93,0xDC,0x98,0x4F,0x52,0xBC,0x9E,0x11,0x1A,0x45,0x53,0x67,0xE4,0x49,0x3F } },
{ 13 , { 0x4C,0xA0,0xA1,0x4B,0xD1,0x07,0x25,0x20,0xC2,0x6E,0x39,0x89,0x4C } },
{ 16 , { 0x07,0x87,0x44,0xBF,0x88,0x9A,0x36,0x6D,0x07,0xB4,0x0A,0x8E,0xAD,0x38,0x07,0xA2 } },
{ 15 , { 0x4E,0x41,0x05,0xA4,0x52,0x84,0x93,0x07,0x50,0xDD,0x56,0x01,0x5A,0x8B,0xAE } },
{ 16 , { 0x3F,0x5F,0x20,0xA9,0xC3,0x5E,0x96,0xE1,0xAD,0x1F,0x47,0x05,0x73,0xBA,0x67,0x30 } },
{ 16 , { 0x3F,0x8B,0x9C,0x55,0x2E,0x6A,0x7F,0x88,0x87,0x61,0xDA,0x61,0x85,0xE1,0x6D,0xD4 } },
{ 16 , { 0x3F,0xA1,0x4B,0xD7,0x69,0xD3,0xF0,0xB5,0x84,0x23,0xFF,0x2E,0x75,0x1C,0x3D,0x29 } },
{ 9 , { 0x30,0x39,0x00,0xC9,0xFA,0x81,0x8D,0xEC,0x39 } },
{ 8 , { 0x0F,0x2E,0x6E,0x74,0x4A,0x61,0xCF,0x65 } },
{ 16 , { 0x3F,0x47,0x90,0xE3,0x6B,0x9D,0x69,0x94,0xF6,0x41,0x74,0xD4,0xA8,0x6E,0xFF,0x1A } },
{ 11 , { 0x3A,0x51,0xCA,0xC7,0xFB,0x0F,0x80,0x84,0x69,0xA5,0x77 } },
{ 16 , { 0x0F,0x02,0x65,0xA8,0x3C,0x56,0x34,0x5A,0x07,0x1D,0xFB,0xB0,0x28,0x1C,0xF2,0x46 } },
{ 14 , { 0x45,0x3E,0x3B,0xCD,0xB4,0x0D,0x07,0x19,0x55,0x8D,0x5C,0x47,0x5C,0xEE } },
{ 12 , { 0x43,0x40,0x9A,0xA5,0x0F,0x85,0x9F,0x44,0xD6,0x13,0x96,0x52 } },
{ 16 , { 0x3F,0x4A,0x42,0x0D,0xEA,0x94,0x6F,0xF2,0x71,0xE0,0xF4,0xCE,0xE8,0x06,0xB9,0x70 } },
{ 16 , { 0x37,0x42,0x01,0x45,0xFB,0x15,0x97,0xB9,0xDB,0x1D,0x6F,0x85,0x2E,0xCF,0xFB,0x46 } },
{ 16 , { 0x3F,0xB0,0x3F,0x54,0xAE,0x7B,0xD1,0xCB,0xB9,0xE3,0x61,0x66,0x45,0xAD,0x8A,0xD4 } },
{ 13 , { 0x44,0x77,0x86,0x5D,0x20,0x07,0x55,0xD0,0xB1,0xE4,0x79,0x66,0xC5 } },
{ 8 , { 0x07,0x97,0xBB,0x36,0xC6,0xCA,0x63,0x7B } },
{ 14 , { 0x35,0xFE,0x06,0x3A,0xB5,0x7A,0x96,0x81,0x71,0x20,0xB7,0x92,0x02,0xA4 } },
{ 8 , { 0x07,0x4C,0xED,0x96,0x46,0x61,0xEE,0x30 } },
{ 16 , { 0x3F,0xFF,0x0D,0x10,0xE7,0x39,0x25,0xC2,0xCA,0xBC,0x8B,0x3D,0x5A,0x44,0xA4,0xF8 } },
{ 15 , { 0x46,0xEB,0xAA,0x98,0xE9,0x2C,0xBD,0x07,0x01,0x63,0x82,0x19,0x65,0x31,0x84 } },
{ 16 , { 0x3F,0x58,0xFA,0x1E,0x5D,0x4E,0x9A,0xCF,0x1C,0x51,0x7B,0xE2,0x8D,0xE6,0xA2,0x10 } },
{ 16 , { 0x37,0x94,0x7B,0x52,0x03,0xC5,0x18,0x86,0xB6,0xD1,0x44,0x3B,0xBD,0x69,0xDC,0x21 } },
{ 16 , { 0x3F,0xB9,0x57,0xEA,0xA5,0x13,0xBE,0x6B,0xF3,0x0A,0x54,0x85,0x8D,0x77,0x44,0x69 } },
{ 16 , { 0x37,0x29,0xB7,0xE1,0xAD,0xC0,0x47,0x53,0xB2,0x3F,0x10,0x9E,0xDC,0x70,0x71,0x22 } },
{ 16 , { 0x3F,0x14,0xCA,0x0D,0x42,0x9B,0x02,0x25,0xD5,0x43,0xBD,0xB4,0xB4,0xF4,0x0E,0x8A } },
{ 14 , { 0x4D,0xE6,0xF8,0xC8,0x36,0x22,0x07,0x67,0xC0,0x28,0x4F,0xB4,0xF0,0xBF } },
{ 13 , { 0x44,0xB0,0x86,0x2E,0x98,0x07,0x5A,0x2B,0x23,0x14,0x75,0x08,0x85 } },
{ 12 , { 0x4B,0x37,0x90,0x92,0x0F,0x69,0x7F,0x43,0xE5,0x5E,0x1D,0xBA } },
{ 16 , { 0x37,0x6F,0xED,0x83,0x81,0x1B,0x11,0x4C,0x27,0x82,0x22,0x32,0x74,0xCB,0xBF,0xB4 } },
{ 16 , { 0x37,0x8E,0xFC,0xDC,0x2D,0x93,0xA8,0x19,0x58,0x86,0x3B,0x74,0xB0,0xB7,0x79,0x5C } },
{ 16 , { 0x47,0x0E,0xA6,0xEF,0xBF,0x9B,0xAF,0x73,0x07,0xAB,0xDE,0xF0,0x70,0x07,0xBA,0xCB } },
{ 11 , { 0x4A,0x43,0xCC,0x07,0x69,0x9B,0xED,0x59,0x5C,0x91,0xED } },
{ 9 , { 0x30,0xEB,0xA0,0xA2,0x75,0xD2,0x2B,0xA3,0x52 } },
{ 16 , { 0x07,0xF3,0xB4,0xA9,0x75,0x4C,0x97,0xC6,0x07,0x33,0x44,0x76,0x7A,0xD1,0xF2,0x4E } },
{ 16 , { 0x07,0x65,0x1C,0xAB,0xE1,0x9E,0x83,0xCC,0x0F,0x77,0x0B,0xB9,0x11,0x65,0x59,0x4A } },
{ 15 , { 0x0F,0x45,0xDD,0xE8,0x58,0x2B,0x7B,0xB0,0x46,0x55,0x36,0x83,0x02,0xC7,0xED } },
{ 16 , { 0x0F,0x8F,0xB9,0x0D,0xB4,0xA1,0x23,0x21,0x0F,0x35,0x51,0x00,0xD1,0xC9,0x1C,0x59 } },
{ 13 , { 0x3C,0x89,0x2D,0x0D,0x45,0x36,0x2F,0x46,0x28,0xDC,0x43,0x95,0xE1 } },
{ 8 , { 0x0F,0x77,0x09,0x07,0x56,0xBC,0x50,0xD4 } },
{ 16 , { 0x37,0x9C,0x70,0x02,0xEE,0x41,0xB2,0x36,0xA7,0x99,0x6E,0x5E,0xAD,0xAB,0x1B,0x01 } },
{ 16 , { 0x3F,0x8A,0xA8,0xBD,0x6E,0x6A,0x74,0x37,0xF7,0x2A,0x89,0x47,0x91,0x75,0x4C,0xFB } },
{ 14 , { 0x45,0xE5,0x74,0xB2,0xBB,0x6E,0x0F,0x3B,0xC4,0x2E,0x57,0xDA,0x90,0x9B } },
{ 12 , { 0x3B,0xD1,0xB0,0xFC,0x79,0xBD,0xF5,0xB8,0xA4,0x63,0x37,0x97 } },
{ 16 , { 0x0F,0x54,0xEA,0x19,0x33,0x1F,0x43,0x1E,0x0F,0xE7,0x32,0x43,0xAE,0x27,0xFB,0xD2 } },
{ 8 , { 0x0F,0x3A,0x48,0x55,0x48,0x5A,0x16,0x0E } },
{ 11 , { 0x3A,0xBF,0xA9,0x8D,0x02,0x34,0x58,0x6D,0xE0,0x89,0x6A } },
{ 8 , { 0x0F,0x84,0xDF,0xCA,0xFD,0x33,0x0C,0xFF } },
{ 12 , { 0x3B,0x6D,0x30,0x86,0x93,0x33,0x8B,0xBD,0x86,0xFE,0x86,0xDB } },
{ 8 , { 0x07,0x98,0x0C,0x52,0x0F,0xC3,0x23,0x6A } },
{ 10 , { 0x39,0x89,0xF5,0x34,0x03,0xF0,0xAE,0x70,0xA0,0x33 } },
{ 11 , { 0x0F,0x12,0x47,0x09,0x2D,0x0F,0xBC,0xF8,0x42,0x67,0xAE } },
{ 14 , { 0x07,0xED,0x76,0x41,0xC2,0xD3,0x39,0xDE,0x45,0x4F,0x2B,0x2E,0x2C,0x89 } },
{ 14 , { 0x07,0xFB,0xBA,0x30,0xC0,0xDD,0xF5,0x06,0x45,0x10,0x62,0x58,0x63,0xA0 } },
{ 8 , { 0x07,0xED,0xA3,0x2A,0xAE,0x0F,0x91,0xDB } },
{ 16 , { 0x3F,0xB1,0xC1,0xF6,0xEF,0x12,0x9B,0x3E,0x65,0xF7,0x4F,0x21,0x31,0xB8,0x2E,0x23 } },
{ 12 , { 0x3B,0x9C,0xD2,0xE4,0x4C,0xAD,0x3F,0xF1,0x3D,0xF7,0xBD,0x56 } },
{ 12 , { 0x07,0x01,0xEA,0x75,0xF4,0x2A,0xD3,0xC6,0x4B,0xDC,0x4C,0x6A } },
{ 16 , { 0x0F,0xA2,0x38,0xE3,0xBF,0x4E,0x78,0x83,0x0F,0xCC,0x5A,0x4E,0x96,0xB0,0x2E,0xFA } },
{ 8 , { 0x07,0xE8,0x5A,0x55,0x26,0x2C,0xB5,0x1D } },
{ 16 , { 0x3F,0x26,0xEF,0x93,0x95,0x13,0x6A,0x36,0xE3,0x81,0x81,0x9A,0x6C,0x00,0x21,0x60 } },
{ 16 , { 0x3F,0x6D,0xF1,0x70,0x5F,0x19,0xDD,0xB9,0x28,0xB1,0xE8,0x06,0xF1,0x35,0x7F,0x14 } },
{ 16 , { 0x37,0xAE,0x87,0x10,0xD7,0xCF,0x8F,0xD6,0xBF,0x53,0x76,0x3A,0xD4,0x94,0x1A,0xEC } },
{ 16 , { 0x37,0xC5,0x41,0xC5,0x2A,0x32,0x72,0x9A,0x4A,0x62,0x88,0xD3,0x1E,0x58,0xED,0x5A } },
{ 16 , { 0x37,0x41,0x33,0xA6,0xB2,0x4C,0xF2,0x01,0x92,0x14,0xBD,0x7D,0xB2,0x3F,0xEF,0xE1 } },
{ 16 , { 0x3F,0xEC,0x09,0xF1,0x3D,0x09,0xFE,0x0B,0xA9,0xEA,0xAB,0x45,0x72,0xA4,0x1F,0x43 } },
{ 15 , { 0x3E,0x3D,0xD0,0x37,0xBA,0xE9,0xB6,0xDE,0xE4,0xAF,0x22,0x7A,0x18,0x48,0xEE } },
{ 8 , { 0x0F,0x05,0xF1,0x64,0x74,0x28,0x1B,0x93 } },
{ 16 , { 0x37,0x47,0x68,0xA8,0x7F,0x0E,0x0A,0xD4,0x6C,0xC0,0x0D,0xF0,0x82,0x86,0x83,0x1E } },
{ 16 , { 0x37,0xBD,0x51,0x92,0x8E,0xCE,0x04,0x83,0x95,0xBC,0xAB,0x2A,0x2B,0x5D,0x5D,0x85 } },
{ 16 , { 0x3F,0x39,0x1C,0x2C,0x62,0x37,0x74,0xF4,0xBF,0xB1,0x96,0x75,0xBC,0x6B,0x81,0xFD } },
{ 16 , { 0x37,0x24,0xC9,0xFA,0x39,0xD8,0xC1,0x40,0x49,0x78,0x4A,0x0A,0xAB,0x0E,0x6F,0x34 } },
{ 16 , { 0x3F,0xB0,0x13,0xBA,0x55,0x70,0x67,0x51,0x34,0x87,0xA9,0x8C,0x5B,0x4F,0x6A,0x14 } },
{ 16 , { 0x37,0xC9,0x85,0xCD,0xFB,0xF9,0x87,0x68,0x1B,0xB6,0xB6,0xED,0x4A,0x03,0xC5,0xE3 } },
{ 16 , { 0x37,0xA8,0x1D,0xFA,0x88,0xBA,0x0E,0x45,0x98,0x9C,0xCC,0x15,0xCC,0x6C,0x34,0xC6 } },
{ 16 , { 0x37,0x12,0x71,0x87,0x21,0xD8,0x35,0x81,0xFE,0x50,0xEB,0x70,0x9B,0x3D,0x0F,0x24 } },
{ 16 , { 0x37,0x48,0x21,0xC0,0x54,0xEB,0x80,0xBE,0x58,0x2C,0x7A,0xBF,0xE1,0x55,0xAC,0x0A } },
{ 16 , { 0x3F,0xAC,0xE6,0x81,0x16,0xE1,0x94,0x35,0x9E,0x3F,0x44,0x01,0xD9,0x39,0xF6,0x96 } },
{ 16 , { 0x3F,0x87,0x2E,0xC2,0x20,0x44,0x09,0x82,0xD5,0x5A,0xF0,0x5C,0x4F,0x4A,0x24,0xE4 } },
{ 16 , { 0x37,0x58,0x7B,0x6F,0x8C,0xF9,0x84,0x6A,0x60,0xDB,0xB7,0xBB,0x2C,0x13,0xBF,0x2B } },
{ 16 , { 0x37,0xD8,0x21,0x0F,0x40,0x35,0x0E,0x46,0x72,0x27,0x4A,0x4E,0x88,0x8E,0x27,0xF8 } },
{ 10 , { 0x39,0x8C,0x56,0x15,0xF5,0xE2,0xAA,0x99,0x98,0x80 } },
{ 8 , { 0x0F,0x5A,0x04,0xD3,0x73,0x75,0x7D,0x5A } },
{ 14 , { 0x35,0xC7,0x99,0x87,0xBC,0xC8,0x19,0xF8,0xC0,0xFA,0xAD,0x03,0xF7,0xE5 } },
{ 8 , { 0x07,0x7F,0xA5,0xD1,0xCC,0x2F,0xA2,0x83 } },
{ 16 , { 0x3F,0x53,0xD7,0xC5,0xE9,0xD5,0xC2,0x72,0xAC,0x4F,0xF9,0xE1,0x13,0x0E,0x8B,0x76 } },
{ 16 , { 0x3F,0x9C,0xFD,0xFC,0x8B,0x2A,0x8C,0x58,0x20,0xC5,0x4B,0x79,0x5A,0x7A,0xC8,0x35 } },
{ 16 , { 0x37,0x52,0x61,0x5D,0x2C,0x37,0x3C,0x7C,0x27,0x2B,0x56,0x28,0xA4,0x29,0x89,0x0E } },
{ 16 , { 0x3F,0xDE,0x96,0x85,0x21,0x5B,0x42,0x0E,0x23,0xD3,0xBF,0xDC,0x3C,0x36,0x55,0xE5 } },
{ 16 , { 0x3F,0xE6,0x7E,0x72,0x37,0x4E,0x37,0xEB,0x3E,0x80,0xEE,0x8F,0xED,0x4C,0xBE,0xE0 } },
{ 11 , { 0x3A,0xF7,0xAD,0xD0,0x67,0x3F,0xFA,0x83,0xD9,0x46,0xC5 } },
{ 8 , { 0x07,0x41,0xDB,0x56,0x6C,0xEF,0xDF,0xA9 } },
{ 16 , { 0x3F,0x7B,0x59,0xE3,0x57,0x3A,0x43,0x46,0xA3,0xFB,0x1B,0xC4,0xCD,0x40,0x5B,0xBB } },
{ 16 , { 0x3F,0x3D,0x37,0x62,0xE9,0x61,0x90,0x2C,0xAA,0x1C,0x53,0xCD,0x16,0x3D,0xEA,0xE9 } },
{ 16 , { 0x37,0x5E,0xAC,0xDC,0x22,0xD4,0x48,0xE1,0x0E,0x2E,0x46,0xB4,0xFC,0xD7,0x92,0xB9 } },
{ 16 , { 0x37,0x00,0x45,0xE4,0x2C,0x11,0xB7,0x3A,0x79,0x67,0x7F,0x45,0x86,0xB2,0xE5,0xD8 } },
{ 10 , { 0x41,0x4F,0x07,0x91,0x17,0x0B,0xDD,0x28,0xDE,0x9F } },
{ 16 , { 0x3F,0x9B,0x06,0x46,0x87,0xF1,0x83,0x1F,0xDD,0xE4,0x4D,0xD4,0xAB,0x0F,0x51,0x8E } },
{ 16 , { 0x37,0x01,0x73,0x10,0x44,0x79,0xF4,0x00,0x00,0x55,0x5D,0x87,0x88,0xFD,0x11,0x5D } },
{ 11 , { 0x32,0x78,0x0B,0xA8,0x77,0x42,0x2B,0xD6,0xB5,0xFC,0x55 } },
{ 8 , { 0x0F,0x8D,0x29,0x21,0xFD,0x22,0xCA,0xB7 } },
{ 16 , { 0x37,0x08,0x2C,0x76,0xDA,0x2B,0xDC,0x12,0xAB,0xC0,0x94,0xC5,0x1D,0x6D,0x7F,0x0B } },
{ 16 , { 0x37,0xB6,0x4A,0xC6,0xE0,0x36,0xC6,0x51,0x27,0x90,0x3B,0xAA,0xDD,0x85,0x62,0xBC } },
{ 16 , { 0x3F,0xA0,0x29,0x29,0x43,0xB0,0x96,0x14,0xF9,0x6B,0x86,0xBD,0xBD,0xAD,0x99,0x85 } },
{ 16 , { 0x3F,0xB0,0x4F,0x3B,0x70,0x33,0xB4,0x4D,0x51,0xA8,0x61,0xAA,0xDF,0x6F,0xDC,0x4B } },
{ 16 , { 0x37,0x1C,0x91,0x82,0xCC,0xF8,0x51,0x02,0xE3,0x2C,0x29,0x76,0x02,0x2E,0x48,0x3D } },
{ 16 , { 0x4F,0x93,0x5F,0x26,0xA3,0xA8,0x6A,0x4B,0x07,0xEA,0x6C,0x7C,0xED,0x1A,0x18,0x89 } },
{ 13 , { 0x3C,0x35,0xDE,0xE4,0xF2,0x10,0xC7,0x6B,0xF3,0x4A,0x92,0x71,0xFC } },
{ 16 , { 0x07,0xAC,0xD9,0x0E,0xBB,0x10,0xFA,0xF4,0x07,0xB6,0x10,0x48,0x8B,0x75,0x88,0x08 } },
{ 8 , { 0x0F,0x48,0xCC,0x6D,0xC4,0x40,0x1F,0xAD } },
{ 9 , { 0x38,0x46,0x81,0xAD,0x86,0x94,0x7F,0x98,0xFA } },
{ 8 , { 0x07,0x9C,0xEB,0x03,0x7C,0x62,0xB9,0x25 } },
{ 16 , { 0x3F,0x8D,0xC0,0x24,0xF9,0x4E,0xB5,0xE0,0x05,0x37,0xBE,0x8A,0x8A,0xCC,0xE1,0x9B } },
{ 16 , { 0x3F,0xED,0xD6,0x84,0x39,0x2D,0xAD,0xF2,0xD1,0xC9,0x98,0x58,0xD3,0xBB,0x7D,0x4A } },
{ 16 , { 0x47,0x6D,0x97,0x3E,0x93,0xF7,0x16,0xFE,0x07,0x82,0xA5,0xD2,0x9A,0xF0,0x19,0x3C } },
{ 16 , { 0x3F,0x68,0x5C,0x5A,0x3F,0xA7,0xE7,0x42,0xC6,0x2A,0x6C,0x3B,0xE7,0xC7,0x7B,0xE1 } },
{ 11 , { 0x42,0xCB,0x39,0x07,0x59,0x5C,0x8C,0xF3,0xB1,0x46,0x37 } },
{ 16 , { 0x3F,0x3B,0xC2,0x98,0xBD,0x94,0x10,0x15,0xBC,0x76,0xA0,0x98,0x8E,0x6F,0x09,0xEA } },
{ 12 , { 0x4B,0x9E,0x75,0x9C,0x0F,0x2E,0xED,0xEE,0x09,0x3B,0x0F,0xDF } },
{ 16 , { 0x0F,0x70,0x5B,0x7D,0x1A,0x36,0x09,0x14,0x0F,0x18,0xDD,0x9D,0x72,0x99,0x10,0x51 } },
{ 16 , { 0x37,0x46,0x82,0x0C,0xF3,0xF5,0xA7,0x33,0xFD,0xD3,0x54,0xDE,0xC0,0x97,0xEF,0x49 } },
{ 11 , { 0x4A,0x61,0xE7,0x07,0xE6,0x7F,0x70,0xB9,0xC2,0xBC,0x1B } },
{ 16 , { 0x07,0xCC,0x93,0x86,0xE0,0x2B,0x4D,0x3D,0x07,0x23,0x8A,0x2F,0xD7,0x49,0x9A,0x6D } },
{ 8 , { 0x07,0x0A,0xCF,0x3A,0x24,0x67,0x2A,0x63 } },
{ 11 , { 0x3A,0xC2,0xC9,0x06,0x90,0xBD,0x45,0x5D,0xAB,0xFC,0x7C } },
{ 13 , { 0x0F,0x5C,0x63,0xB6,0xE8,0xF8,0x4C,0x03,0x4C,0x13,0xC5,0x44,0x45 } },
{ 16 , { 0x0F,0xB5,0x7F,0xFF,0xF8,0x2C,0xA7,0x7A,0x4F,0xD1,0xAA,0x18,0x7A,0x42,0xE7,0x6A } },
{ 8 , { 0x07,0x56,0xFD,0xCA,0x84,0x27,0x09,0xA0 } },
{ 15 , { 0x36,0x5F,0x77,0x76,0x77,0x10,0xEE,0x1D,0x1B,0x5D,0x32,0xCB,0xC5,0x1F,0x1E } },
{ 15 , { 0x07,0x49,0x7D,0x86,0xE2,0x53,0x2A,0x36,0x46,0xC3,0xC2,0x2D,0xCB,0xBB,0xC4 } },
{ 16 , { 0x0F,0xDC,0x74,0x41,0xCA,0xC6,0x87,0xC5,0x07,0x24,0x52,0x58,0x1B,0x73,0xE3,0xDF } },
{ 15 , { 0x46,0x69,0x5B,0xFF,0x46,0xA8,0xD0,0x07,0xE3,0x46,0x2C,0x1B,0xA6,0x12,0x30 } },
{ 16 , { 0x37,0xD4,0xE0,0xD1,0xDA,0x09,0xE6,0x65,0x3B,0xC6,0x2C,0xA9,0x8A,0x5B,0x59,0xF8 } },
{ 16 , { 0x37,0x6A,0x6D,0x61,0x48,0x58,0x13,0xB1,0x48,0xE9,0xD9,0x0F,0x8E,0x22,0x30,0x9D } },
{ 16 , { 0x37,0x84,0xE6,0x21,0xFD,0x23,0xA9,0x85,0x23,0x52,0x68,0x2C,0xDE,0x07,0x9F,0x06 } },
{ 16 , { 0x37,0xBF,0x16,0xA5,0x7E,0x14,0x45,0xE2,0x20,0xDC,0x77,0x5E,0xF1,0xF8,0xB8,0xB2 } },
{ 16 , { 0x3F,0x0D,0x41,0x9B,0x88,0x55,0x39,0x4A,0x33,0xA9,0x0F,0x26,0x8B,0xFC,0x70,0xAC } },
{ 10 , { 0x41,0x70,0x0F,0x76,0xBD,0x5A,0xED,0x08,0x09,0x04 } },
{ 16 , { 0x0F,0xEA,0x6E,0x20,0xC8,0xD3,0x19,0xA3,0x07,0x60,0x16,0x50,0x6C,0xC9,0x4B,0x6F } },
{ 11 , { 0x32,0x97,0x0F,0x94,0x24,0x6C,0x5F,0x97,0xC2,0xE2,0x55 } },
{ 13 , { 0x0F,0x7C,0x3E,0xA8,0x8C,0xC4,0xF4,0x83,0x44,0x24,0x5A,0x1B,0xF2 } },
{ 8 , { 0x07,0x01,0xC5,0x03,0x17,0x44,0xB9,0x97 } },
{ 16 , { 0x37,0x75,0x9A,0xD9,0x9C,0x26,0x49,0x09,0xDF,0xCB,0x23,0x2E,0xF6,0xBD,0xB3,0x92 } },
{ 11 , { 0x32,0xE5,0xCF,0x57,0x9C,0xF4,0x13,0x27,0xC8,0xD8,0xD9 } },
{ 11 , { 0x0F,0xCE,0xF0,0x4A,0x6C,0xDF,0x4F,0xF5,0x4A,0xB2,0x1D } },
{ 8 , { 0x0F,0x32,0xC1,0x9A,0xAC,0x00,0xB0,0x79 } },
{ 16 , { 0x3F,0xEB,0x6B,0x6A,0x75,0xE5,0x01,0x4A,0x73,0x44,0x54,0x49,0x34,0xA9,0x9A,0x1A } },
{ 16 , { 0x4F,0x7D,0xBE,0x96,0xC1,0x63,0x46,0x61,0x07,0xAC,0x09,0x7D,0x47,0xDC,0x62,0xB3 } },
{ 14 , { 0x35,0x6F,0x4E,0x24,0xCB,0x25,0x62,0xA6,0xAB,0x37,0xE2,0xAC,0xE3,0x13 } },
{ 16 , { 0x07,0x93,0x60,0x60,0xB1,0x8D,0xC6,0xBB,0x07,0x29,0xBC,0x5C,0x13,0x8D,0x39,0xF4 } },
{ 8 , { 0x0F,0xAF,0x57,0xC7,0xB8,0x9E,0x72,0x0F } },
{ 16 , { 0x37,0xF0,0xC3,0x26,0xAA,0x26,0x48,0x7C,0x42,0xCA,0xB8,0x23,0x1B,0xC4,0xE8,0xB3 } },
{ 15 , { 0x46,0x67,0xC8,0xF8,0x0A,0x70,0x94,0x07,0x3C,0xF5,0xC8,0x66,0xE9,0x14,0x0C } },
{ 15 , { 0x36,0xA5,0x8E,0x38,0x1A,0xED,0x60,0x56,0x31,0x78,0xDE,0x6A,0x96,0xE3,0xEE } },
{ 16 , { 0x0F,0xAC,0x49,0xAD,0xBB,0x3B,0xCA,0x70,0x07,0xF7,0x4E,0xFC,0xE8,0x34,0x3E,0x7E } },
{ 8 , { 0x0F,0xE4,0xAE,0xEE,0x2B,0x08,0xEE,0xD0 } },
{ 16 , { 0x3F,0xE7,0x40,0x35,0x54,0xDF,0x0F,0x71,0x4A,0x92,0xC3,0xDF,0x8B,0x52,0x72,0xE7 } },
{ 12 , { 0x33,0x3C,0x92,0x3B,0xA2,0x2F,0x2D,0xD5,0x38,0xBB,0xF4,0xC1 } },
{ 8 , { 0x0F,0x07,0xFC,0x05,0xBB,0x58,0x06,0x5A } },
{ 9 , { 0x38,0x37,0x9A,0x45,0x6F,0x99,0xCE,0xC9,0xF6 } },
{ 16 , { 0x0F,0x72,0x45,0xC8,0x00,0x0D,0x68,0xAA,0x07,0xDE,0xDF,0x82,0x69,0x0E,0x32,0xE9 } },
{ 16 , { 0x07,0x78,0xC1,0x67,0x9E,0x54,0x8A,0x2B,0x07,0xEA,0xA7,0x77,0xD4,0x9E,0xE5,0xE3 } },
{ 8 , { 0x07,0xB6,0xB9,0xFE,0xBE,0xD9,0x74,0x8A } },
{ 12 , { 0x33,0x88,0x98,0xA2,0xC2,0x9F,0x73,0x68,0x12,0xAB,0xC5,0x1C } },
{ 8 , { 0x07,0xBB,0xD3,0x37,0x63,0x4C,0x82,0x3F } },
{ 16 , { 0x3F,0xD3,0xD1,0xD6,0x5A,0xED,0x66,0xB7,0xAB,0x9F,0x84,0xE6,0xE5,0x0F,0x1E,0x93 } },
{ 16 , { 0x37,0xFB,0x70,0x41,0x8C,0xD8,0x54,0x2A,0x99,0xD0,0x57,0x8F,0xE7,0x09,0x91,0x3C } },
{ 16 , { 0x37,0x5B,0x65,0x7A,0x89,0x19,0xF8,0xAD,0x6E,0x25,0x02,0x48,0xA4,0xBE,0xE2,0xD2 } },
{ 16 , { 0x3F,0x2C,0x56,0x91,0xB0,0xFA,0x21,0x6E,0x88,0xC0,0x24,0x84,0x93,0xBA,0xC7,0x6E } },
{ 16 , { 0x3F,0xD6,0x00,0x15,0x3F,0x12,0x31,0x6D,0x12,0x53,0x27,0xDC,0xAC,0x8C,0x77,0xED } },
{ 13 , { 0x44,0xD3,0x8E,0xEF,0xE2,0x0F,0x81,0xD6,0xCB,0xBA,0xA0,0x64,0x40 } },
{ 16 , { 0x37,0xDC,0x24,0xEA,0x2D,0xCB,0x61,0xA7,0x1A,0x97,0xFF,0x6B,0xA0,0x5C,0xB8,0xF9 } },
{ 16 , { 0x37,0x30,0x53,0x4C,0x24,0x5D,0x31,0x12,0x57,0x02,0x7C,0x0E,0x41,0x80,0x79,0xC1 } },
{ 10 , { 0x49,0xC8,0x0F,0x23,0x35,0xC5,0xD2,0x8A,0xC9,0x16 } },
{ 16 , { 0x37,0x3C,0xED,0x06,0x89,0xCA,0x5C,0xE6,0x02,0x2E,0x09,0xA2,0xC3,0xF0,0x64,0x32 } },
{ 16 , { 0x0F,0xF2,0x4F,0x8F,0xDE,0x9F,0xBA,0x5C,0x0F,0x67,0xB2,0xC5,0xB9,0x28,0xCC,0x2E } },
{ 16 , { 0x07,0xF8,0xE1,0xF2,0x5E,0xFF,0xCE,0xC6,0x07,0x9F,0x9D,0x23,0x64,0xAC,0x9B,0x67 } },
{ 16 , { 0x07,0x2A,0x4C,0x3D,0x14,0xBB,0xD4,0x31,0x0F,0x0C,0x24,0xD2,0x12,0x8C,0xD1,0x65 } },
{ 16 , { 0x37,0x12,0x02,0x1B,0xEC,0x92,0xEF,0x9E,0x56,0xA7,0x96,0x6E,0xB2,0x8D,0x12,0x2F } },
{ 16 , { 0x37,0xAB,0x09,0x10,0x3C,0x5C,0x1C,0xE5,0x4A,0x38,0x19,0xC8,0x7A,0xA9,0x7C,0x60 } },
{ 16 , { 0x3F,0x05,0xDE,0x7F,0x76,0x75,0x33,0x73,0x43,0x68,0xB4,0xC2,0xD0,0xA8,0x47,0xAC } },
{ 16 , { 0x3F,0x40,0xE3,0xB5,0x09,0xF4,0xF0,0x07,0x1A,0x4E,0x61,0x25,0x0D,0x25,0x34,0x28 } },
{ 16 , { 0x3F,0x77,0xA1,0xA0,0xC2,0x84,0x9F,0x70,0xF0,0x5F,0x71,0x0E,0x1F,0x68,0xA7,0x3F } },
{ 16 , { 0x3F,0x3A,0x52,0x96,0x83,0x9A,0x02,0x06,0x35,0x2A,0x1C,0x3A,0x75,0xBA,0x65,0xD8 } },
{ 12 , { 0x43,0x34,0x82,0x22,0x07,0xDE,0x9A,0xE0,0xE3,0x0C,0x23,0x86 } },
{ 16 , { 0x37,0x1F,0x51,0x23,0xD9,0x7B,0x66,0x1C,0x8C,0xE0,0xA5,0xB6,0xA8,0x89,0xA3,0x4C } },
{ 16 , { 0x37,0xB2,0xC7,0x45,0x42,0xCA,0x16,0xE9,0x86,0xEA,0xA9,0x8A,0x22,0xEF,0xB4,0xCA } },
{ 16 , { 0x37,0xD7,0xD1,0x5F,0x7B,0x33,0x07,0x21,0x52,0x59,0x61,0x89,0xF3,0x90,0xF8,0xEA } },
{ 14 , { 0x4D,0xC3,0x87,0xBB,0x9D,0xAF,0x0F,0xBC,0x66,0x33,0xBE,0x92,0x62,0xEF } },
{ 16 , { 0x3F,0x62,0xA8,0xCE,0xF1,0xB2,0x3D,0x16,0xCF,0xD6,0x21,0x1F,0xA3,0x48,0x26,0xC8 } },
{ 10 , { 0x41,0x43,0x07,0xC2,0x55,0x4B,0x1D,0xEA,0x49,0x68 } },
{ 13 , { 0x3C,0xD4,0xE5,0xA3,0x20,0xCB,0x42,0x9D,0xC4,0xFC,0x7E,0xAB,0xCA } },
{ 8 , { 0x07,0xB1,0x04,0xB5,0x51,0xE4,0xDF,0x9F } },
{ 16 , { 0x37,0x1F,0x5E,0xEB,0xAC,0x9C,0x8C,0xE9,0xF9,0xA1,0xBB,0x8A,0x68,0x47,0x61,0xA2 } },
{ 16 , { 0x37,0x04,0x7B,0xC4,0xE1,0x7F,0x2B,0xBE,0x2A,0x60,0x13,0xC7,0x50,0xA1,0xB8,0x36 } },
{ 10 , { 0x39,0x35,0xAE,0x58,0xAA,0x84,0xEA,0x76,0x52,0xCC } },
{ 8 , { 0x07,0x69,0x40,0x3F,0x04,0x60,0x17,0x2C } },
{ 16 , { 0x37,0xD4,0x50,0x3E,0x2E,0xCE,0x73,0xF2,0xED,0x7E,0x12,0x5A,0xF1,0x21,0xFA,0xEC } },
{ 8 , { 0x0F,0x54,0x0A,0x35,0x46,0xF8,0xA4,0x34 } },
{ 12 , { 0x3B,0x1A,0x6B,0x4D,0x95,0xCE,0x02,0x0D,0x54,0x48,0x11,0x49 } },
{ 16 , { 0x07,0xE2,0x68,0x94,0x50,0x03,0x14,0xD5,0x07,0x1E,0x04,0xD6,0x66,0x5B,0xF0,0x8B } },
{ 8 , { 0x07,0xD8,0xD1,0x2F,0x35,0x9C,0x42,0x9F } },
{ 16 , { 0x3F,0xD1,0xDA,0x9A,0xF7,0x0E,0x1D,0xAD,0xD2,0x16,0xD7,0x2B,0xD3,0x74,0x89,0x92 } },
{ 16 , { 0x3F,0xBA,0x99,0xBA,0x03,0x40,0xB0,0xE5,0x21,0x57,0x3A,0x4C,0x91,0x9F,0x8B,0x73 } },
{ 15 , { 0x49,0x68,0x07,0x9F,0xCE,0xC6,0xE1,0xFE,0xB7,0xC8,0x44,0xD0,0xAC,0x97,0x5E } },
{ 8 , { 0x0F,0x86,0xF1,0xFE,0x3B,0x83,0x5B,0x71 } },
{ 10 , { 0x39,0x5C,0xEE,0xC6,0xAB,0xA2,0x32,0xB6,0xCD,0x1E } },
{ 16 , { 0x0F,0xDB,0xD5,0x00,0x80,0xE5,0x8F,0xF4,0x07,0x9F,0xCE,0x1A,0x6D,0x00,0x91,0x8F } },
{ 8 , { 0x0F,0xDC,0x4B,0xE8,0x37,0xAC,0x80,0xE7 } },
{ 9 , { 0x38,0x0D,0x16,0xF8,0x22,0x6D,0x54,0xB5,0x72 } },
{ 11 , { 0x0F,0x3F,0xCB,0x62,0x48,0xA7,0xB9,0x92,0x4A,0x85,0x17 } },
{ 8 , { 0x07,0xCA,0x4B,0x40,0x47,0xA0,0x82,0xF6 } },
{ 16 , { 0x3F,0x01,0xC0,0x03,0x69,0x3F,0x89,0x4A,0xAA,0x24,0xC2,0x3C,0x24,0xA4,0x0A,0x12 } },
{ 16 , { 0x37,0xD8,0x01,0x02,0x77,0xAB,0xB4,0xC1,0xC9,0xB4,0x04,0x68,0x15,0xBE,0x6A,0xEC } },
{ 10 , { 0x39,0x2C,0x13,0x17,0x37,0xE1,0xF9,0xF6,0xEE,0x00 } },
{ 15 , { 0x0F,0x06,0x30,0x10,0x12,0x3B,0x7C,0xDB,0x4E,0x33,0xB6,0xAF,0xEF,0x95,0x0E } },
{ 16 , { 0x0F,0xE0,0xF5,0xE4,0xFA,0xEA,0x82,0x32,0x0F,0xA6,0x8D,0x92,0x58,0x06,0xDF,0x08 } },
{ 16 , { 0x37,0x52,0x3C,0xA9,0x93,0xE8,0xFC,0x3F,0x1A,0x44,0x67,0x10,0xEE,0x0C,0xBF,0x23 } },
{ 10 , { 0x41,0x20,0x07,0xE8,0xA2,0xB8,0x53,0x92,0x44,0x14 } },
{ 16 , { 0x3F,0x15,0xA4,0xE8,0x4B,0x85,0x0C,0x9D,0xC4,0x9C,0x60,0x2F,0x42,0x5E,0xF6,0xEE } },
{ 16 , { 0x3F,0x55,0x5A,0xAD,0x27,0x5F,0xDC,0x07,0xEF,0x32,0x7E,0x58,0xD2,0xFA,0x2A,0x4A } },
{ 8 , { 0x07,0xBD,0xD5,0x42,0x09,0x21,0x5E,0xD5 } },
{ 12 , { 0x3B,0x18,0x38,0x33,0x0B,0x23,0x35,0x69,0xB1,0x65,0x91,0x0C } },
{ 16 , { 0x0F,0x81,0xA7,0xDA,0x78,0x40,0xE2,0x71,0x07,0x2C,0x50,0x4E,0x27,0xB3,0x61,0xE6 } },
{ 15 , { 0x3E,0x83,0xCC,0xDB,0xCF,0x1F,0xC7,0x07,0x06,0xB3,0x98,0xF7,0x51,0x18,0x91 } },
{ 16 , { 0x0F,0x8C,0x4F,0xEF,0x7E,0x6A,0x7D,0x58,0x07,0xFC,0xCD,0xCC,0xF6,0x1C,0xB9,0x73 } },
{ 16 , { 0x07,0xF3,0x72,0xCC,0x1E,0x9E,0x11,0xCC,0x07,0x2C,0x65,0xF1,0x73,0xDB,0xFE,0x79 } },
{ 8 , { 0x07,0xFB,0x7F,0x9D,0x8C,0x26,0x05,0x5A } },
{ 9 , { 0x38,0xCE,0xD2,0x5A,0x36,0xC6,0x18,0x62,0xC9 } },
{ 11 , { 0x0F,0xE4,0x9C,0xEA,0x55,0x57,0x84,0x37,0x4A,0x8A,0x90 } },
{ 8 , { 0x07,0x6D,0xC9,0xA9,0x20,0xFC,0x83,0xF8 } },
{ 15 , { 0x36,0xCB,0x14,0x43,0x10,0x8C,0x98,0x38,0x76,0x25,0x4E,0xBA,0x68,0x79,0xB7 } },
{ 8 , { 0x0F,0x99,0x87,0xAB,0x3D,0x0D,0x21,0x82 } },
{ 15 , { 0x36,0x82,0xB5,0xAA,0xF8,0xB2,0xBC,0xDD,0x00,0xD7,0xE1,0x42,0x38,0xB2,0x7D } },
{ 8 , { 0x07,0x40,0x3D,0x78,0xDB,0x54,0x66,0xCA } },
{ 13 , { 0x34,0xAF,0x5F,0x79,0x9B,0xF9,0x60,0x55,0x75,0xE0,0x6B,0x94,0x3C } },
{ 16 , { 0x0F,0x81,0xAE,0x7E,0x06,0xC7,0x27,0x9F,0x07,0xD2,0x33,0xC1,0x0E,0x97,0x51,0xED } },
{ 16 , { 0x0F,0x23,0x3C,0xCA,0x98,0x51,0x36,0xFC,0x47,0x5D,0x47,0x14,0x9C,0x43,0xBB,0x42 } },
{ 16 , { 0x07,0x5A,0xE1,0x01,0xEF,0xE4,0x77,0xCA,0x07,0xC4,0xF9,0x29,0x20,0x13,0xA5,0xC1 } },
{ 13 , { 0x07,0x8B,0xB8,0xD3,0xA3,0xC9,0xA4,0xEE,0x4C,0xCB,0xCB,0x74,0x0E } },
{ 8 , { 0x0F,0x94,0x40,0xDC,0x4A,0xA9,0x1A,0x30 } },
{ 16 , { 0x37,0x06,0x49,0xC5,0xA7,0xF4,0x91,0x9C,0xB6,0x9E,0x0F,0x83,0xFD,0x8B,0xF9,0x67 } },
{ 16 , { 0x37,0x85,0x94,0x0A,0x41,0x14,0x42,0xA8,0x68,0x1F,0xAB,0xC1,0x8D,0xA0,0xD0,0x54 } },
{ 16 , { 0x37,0x2F,0x03,0xEF,0xEA,0x78,0x16,0xC3,0xB6,0xEF,0xA5,0xE2,0x8C,0xC2,0x5D,0xB6 } },
{ 12 , { 0x43,0xAF,0x0C,0x94,0x0F,0xC7,0xD1,0x32,0x5A,0x52,0xC6,0x5A } },
{ 8 , { 0x07,0x91,0x72,0x13,0x08,0x57,0x30,0xB6 } },
{ 16 , { 0x37,0x6D,0x6F,0x19,0xEE,0xB4,0x6F,0x00,0x1B,0x49,0xA2,0xD8,0xE1,0x3A,0x9E,0x47 } },
{ 14 , { 0x45,0xD5,0xFB,0x6D,0x44,0x21,0x07,0xD8,0x13,0xF5,0x21,0x6B,0xDC,0x60 } },
{ 8 , { 0x07,0x6B,0x70,0xE2,0xBB,0xB0,0x57,0xC1 } },
{ 9 , { 0x38,0xB9,0x67,0x42,0x0E,0xDB,0x02,0xD6,0xC9 } },
{ 8 , { 0x07,0x11,0xF6,0x9D,0x3B,0xC8,0x66,0xC1 } },
{ 16 , { 0x37,0x91,0xA4,0x40,0x6D,0xC7,0x10,0x5F,0xB6,0xC8,0x59,0x55,0x59,0x6C,0x66,0x92 } },
{ 16 , { 0x3F,0x0B,0xF7,0x08,0x80,0x30,0xE9,0x19,0x64,0x69,0xE1,0xCE,0x90,0x03,0x88,0xE5 } },
{ 12 , { 0x43,0xF9,0xEB,0x0D,0x07,0xB3,0xAC,0x79,0x50,0x7A,0x71,0x81 } },
{ 16 , { 0x37,0xAD,0x92,0x83,0x55,0x86,0x1A,0xA2,0x9C,0xA7,0xBC,0x6E,0x62,0xD1,0x13,0x09 } },
{ 16 , { 0x3F,0x69,0x5C,0x04,0x2A,0x3E,0x2B,0xBC,0xDC,0x0F,0x31,0x71,0xDD,0x45,0xFD,0xE3 } },
{ 16 , { 0x37,0x01,0xA3,0x13,0xAD,0xEB,0xEF,0x95,0x59,0xA7,0xF8,0x1B,0x8E,0x7E,0xE2,0xB5 } },
{ 16 , { 0x3F,0x8D,0xCA,0x8A,0x62,0x0F,0xF9,0xDA,0xC2,0xAB,0x30,0x94,0x89,0x13,0x3F,0xB5 } },
{ 13 , { 0x44,0x13,0x19,0x74,0x65,0x05,0x10,0x80,0xE7,0x42,0x88,0x82,0xEC } },
{ 16 , { 0x37,0xC4,0x35,0x3F,0x16,0x05,0x58,0x44,0x79,0x75,0xE6,0x97,0x11,0x0F,0x7F,0xEE } },
{ 16 , { 0x37,0x33,0x82,0x31,0x49,0x1E,0x56,0x05,0x82,0xF2,0xB0,0xD2,0x8F,0x3B,0x56,0xF8 } },
{ 16 , { 0x37,0x74,0x0C,0xE0,0xC0,0x2B,0xC5,0xCD,0xFD,0x9B,0x30,0x34,0x08,0xFA,0xAA,0xDF } },
{ 16 , { 0x3F,0xD8,0x1D,0xD5,0xCF,0x32,0x6D,0xF2,0xF2,0x90,0xEF,0x51,0x16,0x89,0x2D,0x75 } },
{ 16 , { 0x37,0xE5,0x67,0xA4,0xF4,0x90,0xFF,0x5B,0x52,0x0B,0x4E,0xF1,0xF7,0xE9,0x0C,0x98 } },
{ 16 , { 0x37,0xB9,0x2B,0x9A,0x6D,0xB8,0x02,0x03,0xD4,0x6C,0x58,0x2C,0xE7,0x97,0xF7,0x8A } },
{ 16 , { 0x3F,0x65,0x61,0x93,0xDA,0x29,0x88,0xE9,0x85,0x0F,0xEE,0xD4,0x5E,0x18,0x82,0x5E } },
{ 16 , { 0x3F,0x01,0x83,0xB0,0x32,0x5C,0x76,0xBA,0x30,0x2D,0x6C,0xE0,0x2F,0x96,0x04,0x25 } },
{ 16 , { 0x37,0x17,0x4E,0x91,0x10,0xD2,0xB9,0x9F,0x9B,0x68,0x5F,0x84,0xB7,0xF6,0x3F,0x9F } },
{ 16 , { 0x3F,0x4F,0x0B,0xDD,0x28,0x52,0xF3,0x6E,0x8A,0x6C,0x07,0xD1,0x7A,0x52,0xE6,0xFC } },
{ 13 , { 0x3C,0x2C,0x7E,0x6D,0xAE,0xFD,0x2B,0xC1,0x21,0xB4,0x4C,0x78,0x89 } },
{ 16 , { 0x07,0x16,0x9A,0xEC,0xA4,0xF3,0xEB,0xD3,0x07,0xA4,0x56,0xDE,0xDF,0x04,0x05,0xCB } },
{ 16 , { 0x37,0xDD,0xFB,0x88,0x60,0x7F,0x6D,0x5F,0x1A,0xCF,0x0C,0xC8,0x94,0x82,0x63,0x1F } },
{ 16 , { 0x3F,0x94,0x23,0x91,0xFB,0xDB,0xC1,0x02,0x5C,0x69,0xBA,0x49,0xE4,0xFD,0x90,0x6C } },
{ 16 , { 0x3F,0x1C,0xF5,0x74,0x3A,0xAA,0x02,0xA3,0x4A,0x69,0x8E,0x2A,0xFF,0x30,0xFA,0x71 } },
{ 16 , { 0x3F,0x0E,0x07,0x8C,0xEC,0x21,0x9F,0x9A,0xF2,0xBD,0x30,0xA5,0x6C,0xB9,0x2A,0xD5 } },
{ 16 , { 0x3F,0x21,0x1D,0xC7,0x0D,0xF4,0xE0,0x71,0x14,0xFE,0x88,0xD0,0xB3,0x90,0x30,0x77 } },
{ 16 , { 0x37,0x3D,0x55,0x05,0x42,0x07,0x3F,0xC1,0x5E,0x45,0xA2,0x6D,0xA2,0xF4,0x1E,0xDC } },
{ 16 , { 0x3F,0xA1,0x5B,0xB5,0x6A,0x9C,0x8F,0x22,0x4D,0x0F,0x8A,0xBE,0x4A,0xF8,0x8D,0xB8 } },
{ 16 , { 0x3F,0xC0,0xD7,0x2C,0x97,0xB5,0x96,0xF6,0x37,0x13,0xB7,0x70,0x3B,0xC7,0xCE,0x3B } },
{ 16 , { 0x37,0x2E,0x7D,0x7B,0x5E,0xEA,0x83,0x72,0x62,0x01,0xDC,0x5E,0x8E,0xCF,0x44,0x52 } },
{ 16 , { 0x3F,0x54,0x59,0xB7,0x0A,0x69,0x37,0x51,0xB9,0x72,0x50,0xB0,0xC8,0xF3,0xDF,0x0F } },
{ 16 , { 0x37,0x9C,0x35,0xB1,0x3B,0x93,0x84,0x5F,0xF4,0xB0,0x2F,0xA0,0xB9,0xC9,0x1C,0x09 } },
{ 16 , { 0x37,0xC4,0x03,0xB8,0x6A,0xDD,0xC3,0x7F,0x3D,0x88,0xFA,0x9E,0x46,0xBF,0x67,0x3C } },
{ 11 , { 0x42,0x92,0x5D,0x07,0x16,0x24,0x54,0x46,0x48,0x3D,0xDA } },
{ 16 , { 0x37,0x29,0x6B,0x4B,0x22,0xCA,0x10,0x55,0x0C,0xF3,0x94,0x4F,0x39,0x45,0x57,0xC1 } },
{ 15 , { 0x36,0xF8,0x9F,0xED,0xB2,0x9D,0xA0,0x92,0xFC,0x09,0x42,0xFF,0x51,0xD8,0x70 } },
{ 14 , { 0x07,0x2A,0x9F,0xD6,0x5F,0x90,0x8C,0x27,0x45,0xD7,0x7C,0xA1,0x3C,0x27 } },
{ 8 , { 0x0F,0x39,0x9A,0x9A,0x63,0x03,0xFA,0x94 } },
{ 16 , { 0x37,0x47,0xF1,0x16,0xC3,0xD6,0x7B,0x88,0x6D,0x8B,0x15,0x30,0xD5,0xEB,0x25,0x22 } },
{ 16 , { 0x37,0xD1,0xD7,0x78,0xBC,0xF7,0xC4,0xDD,0xA0,0x45,0x89,0x08,0x54,0x95,0xA8,0x12 } },
{ 16 , { 0x37,0x24,0x55,0x7F,0xA5,0x20,0xE2,0x51,0x06,0xEE,0x40,0x98,0xF1,0x47,0xA1,0x9E } },
{ 11 , { 0x32,0x4C,0x65,0xB2,0x97,0x7D,0x88,0x13,0xCE,0x17,0x4E } },
{ 8 , { 0x07,0xA9,0x71,0x73,0xE8,0x0E,0x03,0x8B } },
{ 16 , { 0x3F,0xF1,0x11,0x00,0x5B,0xCA,0xE8,0x92,0xDE,0xCB,0x25,0xB5,0xBA,0x2C,0x61,0x02 } },
{ 16 , { 0x37,0x7B,0xA5,0x54,0x4D,0xDA,0x95,0xC1,0x3B,0xB3,0x80,0xAE,0xAC,0x03,0xEA,0xF2 } },
{ 16 , { 0x37,0xB2,0xCE,0x77,0x35,0x7C,0x20,0x57,0x05,0x35,0xFA,0x5E,0x8A,0xD9,0x09,0x65 } },
{ 16 , { 0x3F,0xA6,0x89,0xF1,0xCB,0x7F,0xD3,0x1D,0x0C,0x97,0x6E,0x7F,0x31,0x7B,0x67,0xDF } },
{ 10 , { 0x41,0x78,0x0F,0xF8,0xB9,0xD0,0x37,0xBD,0xB4,0x92 } },
{ 16 , { 0x07,0x22,0x23,0x00,0xB7,0xA1,0x75,0xEE,0x07,0x40,0x28,0x63,0x9D,0x45,0x68,0x4B } },
{ 16 , { 0x37,0xB7,0xA3,0x6D,0xFB,0x16,0xC4,0x23,0x1D,0x7E,0xB8,0x87,0x45,0x9D,0x6E,0x03 } },
{ 16 , { 0x37,0xF1,0x0D,0x4E,0xAB,0xA0,0xF0,0x47,0xE8,0x6E,0xB4,0x68,0xAD,0xC6,0x38,0x20 } },
{ 16 , { 0x37,0x6E,0xF5,0x4E,0xC2,0xE6,0x51,0x6D,0xD2,0xC1,0x63,0x01,0xB5,0x6D,0x5F,0xFD } },
{ 9 , { 0x30,0x72,0xCE,0xAE,0xFE,0x96,0xC4,0x20,0x70 } },
{ 11 , { 0x07,0x39,0xCC,0xFB,0x91,0xB9,0xA7,0x66,0x4A,0xF6,0xB8 } },
{ 8 , { 0x07,0xA1,0xE8,0x8D,0x69,0xE2,0x04,0xA2 } },
{ 16 , { 0x37,0x06,0x3F,0x8C,0x15,0x4A,0x5D,0xF6,0x6F,0xD6,0x25,0x35,0x20,0x3C,0x9F,0x9D } },
{ 16 , { 0x3F,0x52,0x8D,0xFC,0x2A,0x47,0x00,0x6C,0xC6,0x3D,0x1E,0x8B,0xFE,0x65,0xC7,0x31 } },
{ 16 , { 0x3F,0xC9,0x13,0x38,0xE8,0x26,0xDE,0x16,0xD9,0xBD,0x16,0x06,0xD8,0x5A,0x26,0x36 } },
{ 16 , { 0x3F,0x31,0xAC,0x7E,0xA8,0x90,0xF6,0x3A,0x02,0x59,0x6B,0xF1,0x1E,0x02,0x1B,0xD1 } },
{ 10 , { 0x41,0x8D,0x0F,0x60,0xD8,0x95,0xC9,0x3C,0x0B,0x2A } },
{ 16 , { 0x0F,0x17,0xA0,0xDA,0x40,0x72,0x9A,0x78,0x07,0x4C,0x6B,0x32,0xAD,0x21,0x9C,0xB0 } },
{ 8 , { 0x0F,0x6A,0x23,0x4C,0x65,0x56,0x33,0x0D } },
{ 12 , { 0x33,0x7F,0xA0,0x9C,0xC7,0x08,0x60,0xCB,0x35,0x59,0x22,0xAA } },
{ 16 , { 0x07,0x3B,0xDB,0xFF,0x14,0x24,0xCB,0x64,0x0F,0xF5,0x60,0xE6,0x68,0x48,0xF3,0x43 } },
{ 16 , { 0x07,0x78,0x60,0x84,0x3F,0xC7,0x43,0xEE,0x0F,0xA8,0xA1,0x0F,0xCF,0xE1,0x3F,0x86 } },
{ 16 , { 0x0F,0xC0,0x67,0x53,0xC3,0x8E,0x5E,0x0A,0x07,0x7C,0x30,0xDA,0x6C,0x6A,0xCA,0xAA } },
{ 16 , { 0x0F,0x07,0x88,0x95,0x22,0xB7,0x88,0xBC,0x07,0x4A,0x2C,0xB3,0x7A,0xB9,0x75,0x22 } },
{ 11 , { 0x07,0x2A,0x62,0x95,0x87,0x61,0x93,0x59,0x42,0xEA,0x8F } },
{ 16 , { 0x0F,0x62,0x4C,0xC9,0x92,0xA0,0x43,0x96,0x0F,0x7C,0xD1,0x8B,0x51,0x25,0x67,0xC4 } },
{ 16 , { 0x07,0x39,0x88,0x93,0xDE,0x93,0x29,0x80,0x07,0xA7,0xAE,0x2A,0xE0,0xB1,0xB4,0x79 } },
{ 16 , { 0x0F,0x1C,0xDE,0x1C,0xEB,0x0F,0x9C,0x74,0x0F,0xC5,0xC2,0x09,0x0A,0xED,0x50,0x79 } },
{ 8 , { 0x07,0x0B,0x1A,0x05,0x6D,0x49,0xE0,0xFB } },
{ 16 , { 0x37,0x2A,0xBA,0x74,0x71,0xA9,0x88,0xCB,0x42,0x3E,0x0D,0x5F,0x1A,0xD2,0xAA,0xE1 } },
{ 11 , { 0x32,0x02,0x90,0xE7,0xD3,0x09,0xFA,0x1A,0xC8,0x33,0x65 } },
{ 15 , { 0x05,0xA6,0x9F,0x84,0x95,0x2F,0x16,0x7B,0x4E,0xCD,0xEA,0xBD,0x84,0xB1,0xC0 } },
{ 16 , { 0x07,0xF4,0x5F,0x53,0xA9,0x9D,0xC2,0x2F,0x0F,0x86,0xA5,0x30,0x58,0x55,0x79,0xF4 } },
{ 16 , { 0x0F,0xAF,0x6F,0x5D,0x7D,0xD5,0x5E,0xB2,0x07,0x4C,0x26,0x58,0xA7,0x42,0xBC,0x88 } },
{ 16 , { 0x0F,0x66,0xF8,0xAE,0xA1,0x28,0x54,0x49,0x07,0x77,0x84,0x7E,0xF5,0xD6,0xF2,0x1C } },
{ 8 , { 0x07,0x2E,0xFD,0xAD,0xB8,0x75,0xFE,0xE1 } },
{ 9 , { 0x38,0x8B,0x53,0xED,0xF4,0x54,0x51,0x36,0xFC } },
{ 16 , { 0x0F,0xCD,0x55,0xD1,0x59,0xC8,0xFB,0xF0,0x0F,0xFB,0x6D,0x1D,0xFE,0x5B,0xEE,0x2E } },
{ 16 , { 0x0F,0xF9,0xA0,0xF7,0xCB,0x23,0x7D,0x43,0x0F,0x3D,0xB8,0x0B,0x82,0x66,0xC8,0xB1 } },
{ 9 , { 0x38,0x9E,0xDD,0xDE,0xDD,0x88,0xC2,0xD1,0x83 } },
{ 16 , { 0x0F,0xE9,0xCA,0xB0,0xF9,0x8B,0x10,0xB0,0x0F,0xEE,0x0C,0x59,0x94,0x87,0x00,0xAF } },
{ 16 , { 0x37,0x17,0x34,0x12,0xB6,0xB0,0xAB,0xEA,0xD9,0xB7,0x7B,0x4C,0x85,0xA1,0xE3,0x99 } },
{ 10 , { 0x49,0x96,0x0F,0xE1,0xAD,0xB7,0xA8,0xDE,0xF5,0x51 } },
{ 16 , { 0x07,0xFD,0x04,0xDE,0xB1,0x80,0xFA,0x56,0x0F,0x56,0xCC,0xDB,0xF2,0x2B,0x38,0xE3 } },
{ 16 , { 0x0F,0xC6,0x2F,0x42,0x67,0x15,0x5F,0xDB,0x07,0x21,0xF4,0x54,0x8E,0x31,0x45,0x44 } },
{ 15 , { 0x0F,0x54,0xD7,0xEC,0x08,0x9A,0x13,0xD3,0x4E,0xE7,0xDC,0x69,0xA9,0xEC,0x98 } },
{ 16 , { 0x0F,0xAB,0x2F,0x3F,0x45,0x7A,0xD1,0x61,0x05,0xFE,0x24,0x54,0x46,0x54,0x61,0x1F } },
{ 13 , { 0x3C,0x1C,0x56,0x93,0xC7,0x68,0xF5,0x2A,0x4B,0xA1,0x29,0x84,0x25 } },
{ 16 , { 0x0F,0xDB,0x0F,0x14,0x77,0xAC,0xC5,0xC8,0x07,0xCA,0xCA,0x31,0x22,0x97,0x36,0x40 } },
{ 11 , { 0x07,0xD3,0x2C,0x22,0x69,0x8E,0xEC,0xD9,0x42,0x1C,0x11 } },
{ 16 , { 0x0F,0xE6,0x96,0x1E,0xA9,0x3C,0x25,0x8A,0x07,0x49,0x16,0x97,0xE8,0x2B,0xA1,0xCA } },
{ 8 , { 0x0F,0xD8,0x78,0xF7,0x58,0x40,0xA0,0x0A } },
{ 16 , { 0x3F,0x77,0x26,0x27,0xEF,0x07,0xBE,0xB1,0x17,0xF7,0x21,0x48,0x15,0x63,0x02,0xAB } },
{ 10 , { 0x39,0xF0,0x01,0x60,0x65,0xD7,0xC2,0x23,0x19,0xDC } },
{ 12 , { 0x07,0x01,0xB1,0x42,0xEE,0x5D,0x1B,0xDB,0x4B,0xA0,0xD3,0xD7 } },
{ 16 , { 0x07,0xF0,0xD1,0x0F,0x00,0x04,0x54,0xF5,0x05,0x34,0x94,0x2F,0xDC,0xAA,0x34,0xEB } }
};

#ifdef USING_ATV_FILTER
static unsigned char dlif_vidfilt_table[] = {0};
#define DLIF_VIDFILT_LINES (sizeof(dlif_vidfilt_table)/(8*sizeof(unsigned char)))
#endif

static si2151_common_reply_struct  reply;
/************************************************************************************************************************
NAME:		   si2151_readcommandbytes function
DESCRIPTION:Read inbbytes from the i2c device into pucdatabuffer, return number of bytes read
Parameter: iI2CIndex, the index of the first byte to read.
Parameter: inbbytes, the number of bytes to read.
Parameter: *pucdatabuffer, a pointer to a buffer used to store the bytes
Porting:    Replace with embedded system I2C read function
Returns:    Actual number of bytes read.
 ************************************************************************************************************************/
static int si2151_readcommandbytes(struct i2c_client *si2151, int inbbytes, unsigned char *pucdatabuffer)
{
        int i2c_flag = 0;
        int i = 0;
        unsigned int i2c_try_cnt = I2C_TRY_MAX_CNT;

        struct i2c_msg msg[] = {
                {
                        .addr  = si2151->addr,
                        .flags  = I2C_M_RD,
                        .len     = inbbytes,
                        .buf     = pucdatabuffer,
                },
        };

	if (si2151->adapter == NULL) {
		pr_err("%s: adapter == NULL.\n", __func__);
		return -EFAULT;
	}

	if(si2151_i2c_en == 0)
		return inbbytes;
	//	printk("[%s]adapter is %x,si2151->addr is %x\n", __func__,si2151->adapter,si2151->addr);
repeat:
        i2c_flag = i2c_transfer(si2151->adapter, msg, 1);
        if (i2c_flag < 0) {
                pr_err("%s: error in read sli2151, %d byte(s) should be read, ret:%d. \n", __func__, inbbytes, i2c_flag);
                if (i++ < i2c_try_cnt) {
                        pr_err("%s: error in read sli2151, try again!!!\n", __func__);
                        goto repeat;
                }
                else
                        return -EIO;
        }
        else {
                //pr_info("%s: read %d bytes\n", __func__, inbbytes);
                return inbbytes;
        }
}

/************************************************************************************************************************
NAME:  si2151_writecommandbytes
DESCRIPTION:  Write inbbytes from pucdatabuffer to the i2c device, return number of bytes written
Porting:    Replace with inbbytes system I2C write function
Returns:    Number of bytes written
 ************************************************************************************************************************/
static int si2151_writecommandbytes(struct i2c_client *si2151, int inbbytes, unsigned char *pucdatabuffer)
{
        int i2c_flag = 0;
        int i = 0;
        unsigned int i2c_try_cnt = I2C_TRY_MAX_CNT;

        struct i2c_msg msg[] = {
                {
                        .addr	= si2151->addr,
                        .flags	= 0,    //|I2C_M_TEN,
                        .len	= inbbytes,
                        .buf	= pucdatabuffer,
                }

        };

	if (si2151->adapter == NULL) {
		pr_err("%s: adapter == NULL.\n", __func__);
		return -EFAULT;
	}

	if(si2151_i2c_en == 0)
		return inbbytes;
		//printk("[%s]adapter is %x,si2151->addr is %x\n", __func__,si2151->adapter,si2151->addr);
repeat:
        i2c_flag = i2c_transfer(si2151->adapter, msg, 1);
        if (i2c_flag < 0) {
                pr_err("%s: error in write sli2151, %d byte(s) should be read, ret:%d. \n", __func__, inbbytes, i2c_flag);
                if (i++ < i2c_try_cnt) {
                        pr_err("%s: error in wirte sli2151, try again!!!\n", __func__);
                        goto repeat;
                }
                else
                        return -EIO;
        }
        else {
                //pr_info("%s: write %d bytes\n", __func__, inbbytes);
                return inbbytes;
        }
}

/***********************************************************************************************************************
  Si2151_GetStatus function
  Use:        POWER_UP checking function
              Used to check the status byte the reset code (0xFE) to drop.
  Comments:   Only required for the Si2151_L1_POWER_UP Command

  Returns:   0 if the Status byte is = 0xFE, nonzero otherwise
 ***********************************************************************************************************************/
unsigned char Si2151_GetStatus (struct i2c_client *si2151)
{
    unsigned char rspByteBuffer[1];

    if (si2151_writecommandbytes(si2151, 1, rspByteBuffer) != 1)
    {
      printk("Si2151_GetStatus ERROR reading byte 0!\n");
      return ERROR_SI2151_POLLING_CTS;
    }

    return (rspByteBuffer[0]);
}

/***********************************************************************************************************************
  sli2151_pollforcts function
Use:        CTS checking function
Used to check the CTS bit until it is set before sending the next command
Comments:   The status byte definition being identical for all commands,
using this function to fill the status structure hels reducing the code size
Comments:   waitForCTS = 1 => I2C polling
waitForCTS = 2 => INTB followed by a read (reading a HW byte using the cypress chip)
max timeout = 100 ms

Porting:    If reading INTB is not possible, the waitForCTS = 2 case can be removed

Parameter: waitForCTS          a flag indicating if waiting for CTS is required
Returns:   1 if the CTS bit is set, 0 otherwise
 ***********************************************************************************************************************/
static unsigned char si2151_pollforcts(struct i2c_client *si2151)
{
        unsigned char error_code = 0;
        unsigned char loop_count = 0;
        unsigned char rspbytebuffer[1];

        for (loop_count=0; loop_count<50; loop_count++) { /* wait a maximum of 50*25ms = 1.25s  */
                if (si2151_readcommandbytes(si2151, 1, rspbytebuffer) != 1)
                        error_code = ERROR_SI2151_POLLING_CTS;
                else
                        error_code = NO_SI2151_ERROR;
                if (error_code || (rspbytebuffer[0] & 0x80))
                        goto exit;
                mdelay(2); /* CTS not set, wait 2ms and retry */
        }
        error_code = ERROR_SI2151_CTS_TIMEOUT;

exit:
        if (error_code)
                pr_info("%s: poll cts function error:%d!!!...............\n", __func__, error_code);

        return error_code;
}

/***********************************************************************************************************************
  SI2151_CurrentResponseStatus function
Use:        status checking function
Used to fill the SI2151_COMMON_REPLY_struct members with the ptDataBuffer byte's bits
Comments:   The status byte definition being identical for all commands,
using this function to fill the status structure hels reducing the code size

Parameter: *ret          the SI2151_COMMON_REPLY_struct
Parameter: ptDataBuffer  a single byte received when reading a command's response (the first byte)
Returns:   0 if the err bit (bit 6) is unset, 1 otherwise
 ***********************************************************************************************************************/
static unsigned char si2151_currentresponsestatus(si2151_common_reply_struct *common_reply, unsigned char ptdatabuffer)
{
        /* _status_code_insertion_start */
        common_reply->tunint = ((ptdatabuffer >> 0 ) & 0x01);
        common_reply->atvint = ((ptdatabuffer >> 1 ) & 0x01);
        common_reply->dtvint = ((ptdatabuffer >> 2 ) & 0x01);
        common_reply->err    = ((ptdatabuffer >> 6 ) & 0x01);
        common_reply->cts    = ((ptdatabuffer >> 7 ) & 0x01);
        /* _status_code_insertion_point */
        return (common_reply->err ? ERROR_SI2151_ERR : NO_SI2151_ERROR);
}

/***********************************************************************************************************************
  si2151_pollforresponse function
Use:        command response retrieval function
Used to retrieve the command response in the provided buffer,
poll for response either by I2C polling or wait for INTB
Comments:   The status byte definition being identical for all commands,
using this function to fill the status structure hels reducing the code size
Comments:   waitForCTS = 1 => I2C polling
waitForCTS = 2 => INTB followed by a read (reading a HW byte using the cypress chip)
max timeout = 100 ms

Porting:    If reading INTB is not possible, the waitForCTS = 2 case can be removed

Parameter:  waitforresponse  a flag indicating if waiting for the response is required
Parameter:  nbbytes          the number of response bytes to read
Parameter:  pbytebuffer      a buffer into which bytes will be stored
Returns:    0 if no error, an error code otherwise
 ***********************************************************************************************************************/
static unsigned char si2151_pollforresponse(struct i2c_client *si2151, unsigned char waitforresponse, unsigned int nbbytes, unsigned char *pbytebuffer, si2151_common_reply_struct *common_reply)
{
        unsigned char error_code;
        unsigned char loop_count;

        for (loop_count=0; loop_count<50; loop_count++) { /* wait a maximum of 50*2ms = 100ms                        */
                switch (waitforresponse) { /* type of response polling?                                */
                        case 0 : /* no polling? valid option, but shouldn't have been called */
                                error_code = NO_SI2151_ERROR; /* return no error                                          */
                                goto exit;

                        case 1 : /* I2C polling status?                                      */
                                if (si2151_readcommandbytes(si2151, nbbytes, pbytebuffer) != nbbytes)
                                        error_code = ERROR_SI2151_POLLING_RESPONSE;
                                else
                                        error_code = NO_SI2151_ERROR;
                                if (error_code)
                                        goto exit;	/* if error, exit with error code */
                                if (pbytebuffer[0] & 0x80)	  /* CTS set? */
                                {
                                        error_code = si2151_currentresponsestatus(common_reply, pbytebuffer[0]);
                                        goto exit; /* exit whether ERR set or not   */
                                }
                                break;

                        default :
                                error_code = ERROR_SI2151_PARAMETER_OUT_OF_RANGE; /* support debug of invalid CTS poll parameter   */
                                goto exit;
                }
                mdelay(2); /* CTS not set, wait 2ms and retry                         */
        }
        error_code = ERROR_SI2151_CTS_TIMEOUT;

exit:
        return error_code;
}

unsigned char Si2151_pollForResetState (struct i2c_client *si2151)
{
  unsigned char rspByteBuffer[1];
  unsigned int loop_count;

  for (loop_count=0; loop_count<50; loop_count++) { /* wait a maximum of 50*25ms = 1.25s  */
    if (si2151_readcommandbytes(si2151, 1, rspByteBuffer) != 1) {
      printk("Si2151_pollForResetState ERROR reading byte 0!\n");
      return ERROR_SI2151_POLLING_CTS;
    }
    /* return OK if status=0xFE set */
    if (rspByteBuffer[0] == 0xFE) {
      return NO_SI2151_ERROR;
    }
  }

  printk("Si2151_pollForResetState ERROR status Timeout!\n");
  return ERROR_SI2151_CTS_TIMEOUT;
}

/***********************************************************************************************************************
NAME: Si2170_L1_API_Patch
DESCRIPTION: Patch information function
Used to send a number of bytes to the Si2170. Useful to download the firmware.
Parameter:   *api    a pointer to the api context to initialize
Parameter:  waitForCTS flag for CTS checking prior to sending a Si2170 API Command
Parameter:  waitForResponse flag for CTS checking and Response readback after sending Si2170 API Command
Parameter:  number of bytes to transmit
Parameter:  Databuffer containing the bytes to transfer in an unsigned char array.
Returns:   0 if no error, else a nonzero int representing an error
 ***********************************************************************************************************************/
static unsigned char si2151_api_patch(struct i2c_client *si2151, int inbbytes, unsigned char *pucdatabuffer, si2151_common_reply_struct *common_reply)
{
        unsigned char res = 0;
        unsigned char error_code = 0;
        unsigned char rspbytebuffer[1];

        res = si2151_pollforcts(si2151);
        if (res != NO_SI2151_ERROR)
        {
                pr_info("%s: poll cts error:%d!!!!\n", __func__, res);
                return res;
        }

        res = si2151_writecommandbytes(si2151, inbbytes, pucdatabuffer);
        if (res!=inbbytes)
        {
                pr_info("%s: poll cts error:%d!!!!\n", __func__, ERROR_SI2151_SENDING_COMMAND);
                return ERROR_SI2151_SENDING_COMMAND;
        }

        error_code = si2151_pollforresponse(si2151, 1, 1, rspbytebuffer, common_reply);
        if (error_code)
                pr_info("%s: poll response error:%d!!!!\n", __func__, error_code);

        return error_code;
}


/* _commands_insertion_start */
#ifdef SI2151_ATV_RESTART_CMD
/*---------------------------------------------------*/
/* SI2151_ATV_RESTART COMMAND                      */
/*---------------------------------------------------*/
unsigned char si2151_atv_restart(struct i2c_client *si2151,
                unsigned char   mode,
                si2151_cmdreplyobj_t *rsp,si2151_common_reply_struct *common_reply)
{
        //unsigned char error_code = 0;
        int return_code = 0;
        //unsigned char cmdbytebuffer[2];
        //unsigned char rspbytebuffer[1];

        pr_err("%s enter in\n", __func__); 
        return_code = si2151_powerupwithpatch(si2151, rsp, common_reply);

        if (return_code) {        /* PowerUp into bootloader */
            pr_err("%s: init si2151 error!!!\n", __func__);
        }
        return 0;

#ifdef DEBUG_RANGE_CHECK
        if ( (mode > SI2151_ATV_RESTART_CMD_MODE_MAX) )
                return ERROR_SI2151_PARAMETER_OUT_OF_RANGE;
#endif /* DEBUG_RANGE_CHECK */
#if 0
        error_code = si2151_pollforcts(si2151);
        if (error_code)
        {
                pr_info("%s: poll cts error:%d!!!!\n", __func__, error_code);
                goto exit;
        }

        cmdbytebuffer[0] = SI2151_ATV_RESTART_CMD;
        cmdbytebuffer[1] = (unsigned char) ( ( mode & SI2151_ATV_RESTART_CMD_MODE_MASK ) << SI2151_ATV_RESTART_CMD_MODE_LSB);

        if (si2151_writecommandbytes(si2151, 2, cmdbytebuffer) != 2)
        {
                error_code = ERROR_SI2151_SENDING_COMMAND;
                pr_info("%s: write command byte error:%d!!!!\n", __func__, error_code);
        }

        if (!error_code)
        {
                error_code = si2151_pollforresponse(si2151, 1, 1, rspbytebuffer, &reply);
                if (error_code)
                        pr_info("%s: poll response error:%d!!!!\n", __func__, error_code);
                rsp->atv_restart.status = &reply;
        }
        
exit:
        return error_code;
#endif
}
#endif /* SI2151_ATV_RESTART_CMD */
#ifdef SI2151_DTV_RESTART_CMD
/*---------------------------------------------------*/
/* SI2151_DTV_RESTART COMMAND                      */
/*---------------------------------------------------*/
unsigned char si2151_dtv_restart(struct i2c_client *si2151, si2151_cmdreplyobj_t *rsp)
{
        unsigned char error_code = 0;
        unsigned char cmdbytebuffer[1];
        unsigned char rspbytebuffer[1];


        error_code = si2151_pollforcts(si2151);
        if (error_code)
        {
                pr_info("%s: poll cts error:%d!!!!\n", __func__, error_code);
                goto exit;
        }

        cmdbytebuffer[0] = SI2151_DTV_RESTART_CMD;
        if (si2151_writecommandbytes(si2151, 1, cmdbytebuffer) != 1)
        {
                error_code = ERROR_SI2151_SENDING_COMMAND;
                pr_info("%s: write command byte error:%d!!!!\n", __func__, error_code);
        }

        if (!error_code)
        {
                error_code = si2151_pollforresponse(si2151, 1, 1, rspbytebuffer, &reply);
                if (error_code)
                        pr_info("%s: poll response error:%d!!!!\n", __func__, error_code);
                rsp->atv_restart.status = &reply;
        }
exit:
        return error_code;
}
#endif /* SI2151_ATV_RESTART_CMD */

#ifdef    SI2151_CONFIG_CLOCKS_CMD
 /*---------------------------------------------------*/
/* SI2151_CONFIG_CLOCKS COMMAND                    */
/*---------------------------------------------------*/
unsigned char si2151_config_clocks  (struct i2c_client *si2151,
                                         unsigned char   subcode,
                                         unsigned char   clock_mode,
                                         unsigned char   en_xout,
										 si2151_cmdreplyobj_t *rsp)
{
    unsigned char error_code = 0;
    unsigned char cmdByteBuffer[3];
    unsigned char rspByteBuffer[1];


   pr_info("SI2151 CONFIG_CLOCKS\n ");
  #ifdef   DEBUG_RANGE_CHECK
    if ((subcode    > SI2151_CONFIG_CLOCKS_CMD_SUBCODE_MAX   ) ||
     (clock_mode > SI2151_CONFIG_CLOCKS_CMD_CLOCK_MODE_MAX) 	||
     (en_xout    > SI2151_CONFIG_CLOCKS_CMD_EN_XOUT_MAX    ) )
     {
      pr_info("%s out of range parameters\n", __func__);
      return ERROR_SI2151_PARAMETER_OUT_OF_RANGE;
    }
  #endif /* DEBUG_RANGE_CHECK */


    cmdByteBuffer[0] = SI2151_CONFIG_CLOCKS_CMD;
    cmdByteBuffer[1] = (unsigned char) ( ( subcode    & SI2151_CONFIG_CLOCKS_CMD_SUBCODE_MASK    ) << SI2151_CONFIG_CLOCKS_CMD_SUBCODE_LSB   );
    cmdByteBuffer[2] = (unsigned char) ( ( clock_mode & SI2151_CONFIG_CLOCKS_CMD_CLOCK_MODE_MASK ) << SI2151_CONFIG_CLOCKS_CMD_CLOCK_MODE_LSB|
                                         ( en_xout    & SI2151_CONFIG_CLOCKS_CMD_EN_XOUT_MASK    ) << SI2151_CONFIG_CLOCKS_CMD_EN_XOUT_LSB   );

    if (si2151_writecommandbytes(si2151, 3, cmdByteBuffer) != 3) {
      pr_info("Error writing CONFIG_CLOCKS bytes!\n");
      return ERROR_SI2151_SENDING_COMMAND;
    }

    error_code = si2151_pollforresponse(si2151, 1,1, rspByteBuffer,&reply);
    if (error_code) {
      pr_info("Error polling CONFIG_CLOCKS response\n");
      return error_code;
    }


    return NO_SI2151_ERROR;
}
#endif /* SI2151_CONFIG_CLOCKS_CMD */
#ifdef SI2151_EXIT_BOOTLOADER_CMD
/*---------------------------------------------------*/
/* SI2151_EXIT_BOOTLOADER COMMAND                  */
/*---------------------------------------------------*/
static unsigned char si2151_exit_bootloader(struct i2c_client *si2151,
                unsigned char   func,
                unsigned char   ctsien,
                si2151_cmdreplyobj_t *rsp)
{
        unsigned char error_code = 0;
        unsigned char cmdbytebuffer[2];
        unsigned char rspbytebuffer[1];

#ifdef DEBUG_RANGE_CHECK
        if ( (func   > SI2151_EXIT_BOOTLOADER_CMD_FUNC_MAX  )
                        || (ctsien > SI2151_EXIT_BOOTLOADER_CMD_CTSIEN_MAX) )
                return ERROR_SI2151_PARAMETER_OUT_OF_RANGE;
#endif /* DEBUG_RANGE_CHECK */

        error_code = si2151_pollforcts(si2151);
        if (error_code) goto exit;

        cmdbytebuffer[0] = SI2151_EXIT_BOOTLOADER_CMD;
        cmdbytebuffer[1] = (unsigned char) ( ( func   & SI2151_EXIT_BOOTLOADER_CMD_FUNC_MASK   ) << SI2151_EXIT_BOOTLOADER_CMD_FUNC_LSB  |
                        ( ctsien & SI2151_EXIT_BOOTLOADER_CMD_CTSIEN_MASK ) << SI2151_EXIT_BOOTLOADER_CMD_CTSIEN_LSB);

        if (si2151_writecommandbytes(si2151, 2, cmdbytebuffer) != 2) error_code = ERROR_SI2151_SENDING_COMMAND;

        if (!error_code)
        {
                error_code = si2151_pollforresponse(si2151, 1, 1, rspbytebuffer, &reply);
                if (error_code)
                        pr_info("%s: poll response error:%d!!!!\n", __func__, error_code);
                rsp->exit_bootloader.status = &reply;
        }
exit:
        return error_code;
}
#endif /* SI2151_EXIT_BOOTLOADER_CMD */
#ifdef SI2151_FINE_TUNE_CMD
/*---------------------------------------------------*/
/* SI2151_FINE_TUNE COMMAND                        */
/*---------------------------------------------------*/
unsigned char si2151_fine_tune(struct i2c_client *si2151,
                                         unsigned char   persistence,
                                         unsigned char   apply_to_lif,
                int   offset_500hz,
                si2151_cmdreplyobj_t *rsp)
{
        unsigned char error_code = 0;
        unsigned char cmdbytebuffer[4];
        unsigned char rspbytebuffer[1];

#ifdef DEBUG_RANGE_CHECK
        if ( (reserved     > SI2151_FINE_TUNE_CMD_RESERVED_MAX    )
                        || (offset_500hz > SI2151_FINE_TUNE_CMD_OFFSET_500HZ_MAX)  || (offset_500hz < SI2151_FINE_TUNE_CMD_OFFSET_500HZ_MIN) )
                return ERROR_SI2151_PARAMETER_OUT_OF_RANGE;
#endif /* DEBUG_RANGE_CHECK */

        error_code = si2151_pollforcts(si2151);
        if (error_code)
        {
                pr_info("%s: poll cts error:%d!!!!\n", __func__, error_code);
                goto exit;
        }

        cmdbytebuffer[0] = SI2151_FINE_TUNE_CMD;
    	cmdbytebuffer[1] = (unsigned char) ( ( persistence  & SI2151_FINE_TUNE_CMD_PERSISTENCE_MASK  ) << SI2151_FINE_TUNE_CMD_PERSISTENCE_LSB |
                                         ( apply_to_lif & SI2151_FINE_TUNE_CMD_APPLY_TO_LIF_MASK ) << SI2151_FINE_TUNE_CMD_APPLY_TO_LIF_LSB);
        cmdbytebuffer[2] = (unsigned char) ( ( offset_500hz & SI2151_FINE_TUNE_CMD_OFFSET_500HZ_MASK ) << SI2151_FINE_TUNE_CMD_OFFSET_500HZ_LSB);
        cmdbytebuffer[3] = (unsigned char) ((( offset_500hz & SI2151_FINE_TUNE_CMD_OFFSET_500HZ_MASK ) << SI2151_FINE_TUNE_CMD_OFFSET_500HZ_LSB)>>8);

        if (si2151_writecommandbytes(si2151, 4, cmdbytebuffer) != 4)
        {
                error_code = ERROR_SI2151_SENDING_COMMAND;
                pr_info("%s: write command byte error:%d!!!!\n", __func__, error_code);
        }

        if (!error_code)
        {
                error_code = si2151_pollforresponse(si2151, 1, 1, rspbytebuffer, &reply);
                if (error_code)
                        pr_info("%s: poll response error:%d!!!!\n", __func__, error_code);
                rsp->fine_tune.status = &reply;
        }
exit:
        return error_code;
}
#endif /* SI2151_FINE_TUNE_CMD */
#ifdef SI2151_GET_PROPERTY_CMD
/*---------------------------------------------------*/
/* SI2151_GET_PROPERTY COMMAND                     */
/*---------------------------------------------------*/
unsigned char si2151_get_property(struct i2c_client *si2151,
                unsigned char   reserved,
                unsigned int    prop,
                si2151_cmdreplyobj_t *rsp)
{
        unsigned char error_code = 0;
        unsigned char cmdbytebuffer[4];
        unsigned char rspbytebuffer[4];

#ifdef DEBUG_RANGE_CHECK
        if ( (reserved > SI2151_GET_PROPERTY_CMD_RESERVED_MAX) )
                return ERROR_SI2151_PARAMETER_OUT_OF_RANGE;
#endif /* DEBUG_RANGE_CHECK */

        error_code = si2151_pollforcts(si2151);
        if (error_code)
        {
                pr_info("%s: poll cts error:%d!!!!\n", __func__, error_code);
                goto exit;
        }

        cmdbytebuffer[0] = SI2151_GET_PROPERTY_CMD;
        cmdbytebuffer[1] = (unsigned char) ( ( reserved & SI2151_GET_PROPERTY_CMD_RESERVED_MASK ) << SI2151_GET_PROPERTY_CMD_RESERVED_LSB);
        cmdbytebuffer[2] = (unsigned char) ( ( prop     & SI2151_GET_PROPERTY_CMD_PROP_MASK     ) << SI2151_GET_PROPERTY_CMD_PROP_LSB    );
        cmdbytebuffer[3] = (unsigned char) ((( prop     & SI2151_GET_PROPERTY_CMD_PROP_MASK     ) << SI2151_GET_PROPERTY_CMD_PROP_LSB    )>>8);

        if (si2151_writecommandbytes(si2151, 4, cmdbytebuffer) != 4)
        {
                error_code = ERROR_SI2151_SENDING_COMMAND;
                pr_info("%s: write command byte error:%d!!!!\n", __func__, error_code);
        }

        if (!error_code)
        {
                error_code = si2151_pollforresponse(si2151, 1, 4, rspbytebuffer, &reply);
                if (error_code)
                        pr_info("%s: poll response error:%d!!!!\n", __func__, error_code);
                rsp->get_property.status = &reply;
                if (!error_code)
                {
                        rsp->get_property.reserved =   (( ( (rspbytebuffer[1]  )) >> SI2151_GET_PROPERTY_RESPONSE_RESERVED_LSB ) & SI2151_GET_PROPERTY_RESPONSE_RESERVED_MASK );
                        rsp->get_property.data     =   (( ( (rspbytebuffer[2]  ) | (rspbytebuffer[3]  << 8 )) >> SI2151_GET_PROPERTY_RESPONSE_DATA_LSB     ) & SI2151_GET_PROPERTY_RESPONSE_DATA_MASK     );
                }
        }
exit:
        return error_code;
}
#endif /* SI2151_GET_PROPERTY_CMD */
#ifdef SI2151_GET_REV_CMD
/*---------------------------------------------------*/
/* SI2151_GET_REV COMMAND                          */
/*---------------------------------------------------*/
unsigned char si2151_get_rev(struct i2c_client *si2151,
                si2151_cmdreplyobj_t *rsp)
{
        unsigned char error_code = 0;
        unsigned char cmdbytebuffer[1];
        unsigned char rspbytebuffer[13];

        error_code = si2151_pollforcts(si2151);
        if (error_code) goto exit;

        cmdbytebuffer[0] = SI2151_GET_REV_CMD;

        if (si2151_writecommandbytes(si2151, 1, cmdbytebuffer) != 1) error_code = ERROR_SI2151_SENDING_COMMAND;

        if (!error_code)
        {
                error_code = si2151_pollforresponse(si2151, 1, 13, rspbytebuffer, &reply);
                if (error_code)
                        pr_info("%s: poll response error:%d!!!!\n", __func__, error_code);
                rsp->get_rev.status = &reply;
                if (!error_code)
                {
                        rsp->get_rev.pn       =   (( ( (rspbytebuffer[1]  )) >> SI2151_GET_REV_RESPONSE_PN_LSB       ) & SI2151_GET_REV_RESPONSE_PN_MASK       );
                        rsp->get_rev.fwmajor  =   (( ( (rspbytebuffer[2]  )) >> SI2151_GET_REV_RESPONSE_FWMAJOR_LSB  ) & SI2151_GET_REV_RESPONSE_FWMAJOR_MASK  );
                        rsp->get_rev.fwminor  =   (( ( (rspbytebuffer[3]  )) >> SI2151_GET_REV_RESPONSE_FWMINOR_LSB  ) & SI2151_GET_REV_RESPONSE_FWMINOR_MASK  );
                        rsp->get_rev.patch    =   (( ( (rspbytebuffer[4]  ) | (rspbytebuffer[5]  << 8 )) >> SI2151_GET_REV_RESPONSE_PATCH_LSB    ) & SI2151_GET_REV_RESPONSE_PATCH_MASK    );
                        rsp->get_rev.cmpmajor =   (( ( (rspbytebuffer[6]  )) >> SI2151_GET_REV_RESPONSE_CMPMAJOR_LSB ) & SI2151_GET_REV_RESPONSE_CMPMAJOR_MASK );
                        rsp->get_rev.cmpminor =   (( ( (rspbytebuffer[7]  )) >> SI2151_GET_REV_RESPONSE_CMPMINOR_LSB ) & SI2151_GET_REV_RESPONSE_CMPMINOR_MASK );
                        rsp->get_rev.cmpbuild =   (( ( (rspbytebuffer[8]  )) >> SI2151_GET_REV_RESPONSE_CMPBUILD_LSB ) & SI2151_GET_REV_RESPONSE_CMPBUILD_MASK );
                        rsp->get_rev.chiprev  =   (( ( (rspbytebuffer[9]  )) >> SI2151_GET_REV_RESPONSE_CHIPREV_LSB  ) & SI2151_GET_REV_RESPONSE_CHIPREV_MASK  );
                        rsp->get_rev.pn2      =   (( ( (rspbytebuffer[12]  )) >> Si2151_GET_REV_RESPONSE_PN2_LSB     ) & Si2151_GET_REV_RESPONSE_PN2_MASK      );
				}
        }
exit:
        return error_code;
}
#endif /* SI2151_GET_REV_CMD */

unsigned char si2151_get_config_pins(struct i2c_client *si2151,
		si2151_cmdreplyobj_t *rsp)
{
	unsigned char error_code = 0;
	unsigned char cmdbytebuffer[1];
	unsigned char rspbytebuffer[7];

	error_code = si2151_pollforcts(si2151);
	if (error_code) goto exit;

	cmdbytebuffer[0] = SI2151_CONFIG_PINS_CMD;

	if (si2151_writecommandbytes(si2151, 1, cmdbytebuffer) != 1)
		error_code = ERROR_SI2151_SENDING_COMMAND;

	if (!error_code) {
		error_code = si2151_pollforresponse(si2151, 1, 7, rspbytebuffer, &reply);
		if (error_code)
			pr_info("%s: poll response error:%d!!!!\n", __func__, error_code);

		rsp->get_rev.status = &reply;
		if (!error_code) {
			rsp->config_pins.gpio1_mode = ((rspbytebuffer[1] >> SI2151_CONFIG_PINS_RESPONSE_GPIO1_MODE_LSB) & SI2151_CONFIG_PINS_RESPONSE_GPIO1_MODE_MASK);
			rsp->config_pins.gpio1_state = ((rspbytebuffer[1] >> SI2151_CONFIG_PINS_RESPONSE_GPIO1_STATE_LSB) & SI2151_CONFIG_PINS_RESPONSE_GPIO1_STATE_MASK);
			rsp->config_pins.gpio2_mode = ((rspbytebuffer[2] >> SI2151_CONFIG_PINS_RESPONSE_GPIO2_MODE_LSB) & SI2151_CONFIG_PINS_RESPONSE_GPIO2_MODE_MASK);
			rsp->config_pins.gpio2_state = ((rspbytebuffer[2] >> SI2151_CONFIG_PINS_RESPONSE_GPIO2_STATE_LSB) & SI2151_CONFIG_PINS_RESPONSE_GPIO2_STATE_MASK);
			rsp->config_pins.agc1_mode = ((rspbytebuffer[3] >> SI2151_CONFIG_PINS_RESPONSE_AGC1_MODE_LSB) & SI2151_CONFIG_PINS_RESPONSE_AGC1_MODE_MASK);
			rsp->config_pins.agc1_state = ((rspbytebuffer[3] >> SI2151_CONFIG_PINS_RESPONSE_AGC1_STATE_LSB) & SI2151_CONFIG_PINS_RESPONSE_AGC1_STATE_MASK);
			rsp->config_pins.agc2_mode = ((rspbytebuffer[5] >> SI2151_CONFIG_PINS_RESPONSE_AGC2_MODE_LSB) & SI2151_CONFIG_PINS_RESPONSE_AGC2_MODE_MASK);
			rsp->config_pins.agc2_state = ((rspbytebuffer[5] >> SI2151_CONFIG_PINS_RESPONSE_AGC2_STATE_LSB) & SI2151_CONFIG_PINS_RESPONSE_AGC2_STATE_MASK);
			rsp->config_pins.xout_mode = ((rspbytebuffer[6] >> SI2151_CONFIG_PINS_RESPONSE_AGC2_MODE_LSB) & SI2151_CONFIG_PINS_RESPONSE_XOUT_MODE_MASK);
			rsp->config_pins.xout_state = ((rspbytebuffer[6] >> SI2151_CONFIG_PINS_RESPONSE_XOUT_STATE_LSB) & SI2151_CONFIG_PINS_RESPONSE_XOUT_STATE_MASK);
		}
	}
exit:
	return error_code;
}

#ifdef SI2151_PART_INFO_CMD
/*---------------------------------------------------*/
/* SI2151_PART_INFO COMMAND                        */
/*---------------------------------------------------*/
static unsigned char si2151_part_info(struct i2c_client *si2151,
                si2151_cmdreplyobj_t *rsp)
{
        unsigned char error_code = 0;
        unsigned char cmdbytebuffer[1];
        unsigned char rspbytebuffer[13];

        error_code = si2151_pollforcts(si2151);
        if (error_code) goto exit;

        cmdbytebuffer[0] = SI2151_PART_INFO_CMD;

        if (si2151_writecommandbytes(si2151, 1, cmdbytebuffer) != 1) error_code = ERROR_SI2151_SENDING_COMMAND;

        if (!error_code)
        {
                error_code = si2151_pollforresponse(si2151, 1, 13, rspbytebuffer, &reply);
                if (error_code)
                        pr_info("%s: poll response error:%d!!!!\n", __func__, error_code);
                rsp->part_info.status = &reply;
                if (!error_code)
                {
                        rsp->part_info.chiprev  =   (( ( (rspbytebuffer[1]  )) >> SI2151_PART_INFO_RESPONSE_CHIPREV_LSB  ) & SI2151_PART_INFO_RESPONSE_CHIPREV_MASK  );
                        rsp->part_info.part     =   (( ( (rspbytebuffer[2]  )) >> SI2151_PART_INFO_RESPONSE_PART_LSB     ) & SI2151_PART_INFO_RESPONSE_PART_MASK     );
                        rsp->part_info.pmajor   =   (( ( (rspbytebuffer[3]  )) >> SI2151_PART_INFO_RESPONSE_PMAJOR_LSB   ) & SI2151_PART_INFO_RESPONSE_PMAJOR_MASK   );
                        rsp->part_info.pminor   =   (( ( (rspbytebuffer[4]  )) >> SI2151_PART_INFO_RESPONSE_PMINOR_LSB   ) & SI2151_PART_INFO_RESPONSE_PMINOR_MASK   );
                        rsp->part_info.pbuild   =   (( ( (rspbytebuffer[5]  )) >> SI2151_PART_INFO_RESPONSE_PBUILD_LSB   ) & SI2151_PART_INFO_RESPONSE_PBUILD_MASK   );
                        rsp->part_info.reserved =   (( ( (rspbytebuffer[6]  ) | (rspbytebuffer[7]  << 8 )) >> SI2151_PART_INFO_RESPONSE_RESERVED_LSB ) & SI2151_PART_INFO_RESPONSE_RESERVED_MASK );
                        rsp->part_info.serial   =   (( ( (rspbytebuffer[8]  ) | (rspbytebuffer[9]  << 8 ) | (rspbytebuffer[10] << 16 ) | (rspbytebuffer[11] << 24 )) >> SI2151_PART_INFO_RESPONSE_SERIAL_LSB   ) & SI2151_PART_INFO_RESPONSE_SERIAL_MASK   );
                        rsp->part_info.romid    =   (( ( (rspbytebuffer[12] )) >> SI2151_PART_INFO_RESPONSE_ROMID_LSB    ) & SI2151_PART_INFO_RESPONSE_ROMID_MASK    );
                }
        }
exit:
        return error_code;
}
#endif /* SI2151_PART_INFO_CMD */
#ifdef SI2151_POWER_DOWN_CMD
/*---------------------------------------------------*/
/* SI2151_POWER_DOWN COMMAND                       */
/*---------------------------------------------------*/
unsigned char si2151_power_down(struct i2c_client *si2151,
                si2151_cmdreplyobj_t *rsp)
{
        unsigned char error_code = 0;
        unsigned char cmdbytebuffer[1];
        unsigned char rspbytebuffer[1];

        error_code = si2151_pollforcts(si2151);
        if (error_code)
        {
                pr_info("%s: poll cts error:%d!!!!\n", __func__, error_code);
                goto exit;
        }

        cmdbytebuffer[0] = SI2151_POWER_DOWN_CMD;

        if (si2151_writecommandbytes(si2151, 1, cmdbytebuffer) != 1)
        {
                error_code = ERROR_SI2151_SENDING_COMMAND;
                pr_info("%s: write command byte error:%d!!!!\n", __func__, error_code);
        }

        if (!error_code)
        {
                error_code = si2151_pollforresponse(si2151, 1, 1, rspbytebuffer, &reply);
                if (error_code)
                        pr_info("%s: poll response error:%d!!!!\n", __func__, error_code);
                rsp->power_down.status = &reply;
        }
exit:
        return error_code;
}
#endif /* SI2151_POWER_DOWN_CMD */

#ifdef    SI2151_RESET_HW_CMD
/*---------------------------------------------------*/
/* Si2151_RESET_HW COMMAND                                 */
/*---------------------------------------------------*/
unsigned char Si2151_RESET_HW        (struct i2c_client *si2151,
                                         unsigned char   subcode,
                                         unsigned char   reserved1,
                                         unsigned char   reserved2,
                                         si2151_cmdreplyobj_t *rsp)
{
    unsigned char error_code = 0;
    unsigned char cmdByteBuffer[4];

    printk("Si2151 RESET_HW ");
  #ifdef   DEBUG_RANGE_CHECK
    if ((subcode   > Si2151_RESET_HW_CMD_SUBCODE_MAX  )  || (subcode   < Si2151_RESET_HW_CMD_SUBCODE_MIN  ) ) {error_code++; printk("\nOut of range: ");}; printk("SUBCODE %d "  , subcode   );
    if ((reserved1 > Si2151_RESET_HW_CMD_RESERVED1_MAX) ) {error_code++; printk("\nOut of range: ");}; printk("RESERVED1 %d ", reserved1 );
    if ((reserved2 > Si2151_RESET_HW_CMD_RESERVED2_MAX) ) {error_code++; printk("\nOut of range: ");}; printk("RESERVED2 %d ", reserved2 );
    if (error_code) {
      printk("%d out of range parameters\n", error_code);
      return ERROR_SI2151_PARAMETER_OUT_OF_RANGE;
    }
  #endif /* DEBUG_RANGE_CHECK */

    printk("\n");
    cmdByteBuffer[0] = SI2151_RESET_HW_CMD;
    cmdByteBuffer[1] = (unsigned char) ( ( subcode   & Si2151_RESET_HW_CMD_SUBCODE_MASK   ) << Si2151_RESET_HW_CMD_SUBCODE_LSB  );
    cmdByteBuffer[2] = (unsigned char) ( ( reserved1 & Si2151_RESET_HW_CMD_RESERVED1_MASK ) << Si2151_RESET_HW_CMD_RESERVED1_LSB);
    cmdByteBuffer[3] = (unsigned char) ( ( reserved2 & Si2151_RESET_HW_CMD_RESERVED2_MASK ) << Si2151_RESET_HW_CMD_RESERVED2_LSB);

    if (si2151_writecommandbytes(si2151, 4, cmdByteBuffer) != 4) {
      printk("Error writing RESET_HW bytes!\n");
      return ERROR_SI2151_SENDING_COMMAND;
    }
    error_code = Si2151_pollForResetState(si2151);
    rsp->reset_hw.STATUS = &reply;
    if (error_code) {
      printk("Error polling RESET_HW response\n");
      return error_code;
    }

    return NO_SI2151_ERROR;
}
#endif /* Si2151_RESET_HW_CMD */

/***********************************************************************************************************************
  Si2151_L1_API_ERROR_TEXT function
  Use:        Error information function
              Used to retrieve a text based on an error code
  Returns:    the error text
  Parameter:  error_code the error code.
  Porting:    Useful for application development for debug purposes.
  Porting:    May not be required for the final application, can be removed if not used.
 ***********************************************************************************************************************/
char*            Si2151_L1_API_ERROR_TEXT(int error_code) {
    switch (error_code) {
        case NO_SI2151_ERROR                     : return (char *)"No Si2151 error";
        case ERROR_SI2151_ALLOCATING_CONTEXT     : return (char *)"Error while allocating Si2151 context";
        case ERROR_SI2151_PARAMETER_OUT_OF_RANGE : return (char *)"Si2151 parameter(s) out of range";
        case ERROR_SI2151_SENDING_COMMAND        : return (char *)"Error while sending Si2151 command";
        case ERROR_SI2151_CTS_TIMEOUT            : return (char *)"Si2151 CTS timeout";
        case ERROR_SI2151_ERR                    : return (char *)"Si2151 Error (status 'err' bit 1)";
        case ERROR_SI2151_POLLING_CTS            : return (char *)"Si2151 Error while polling CTS";
        case ERROR_SI2151_POLLING_RESPONSE       : return (char *)"Si2151 Error while polling response";
        case ERROR_SI2151_LOADING_FIRMWARE       : return (char *)"Si2151 Error while loading firmware";
        case ERROR_SI2151_LOADING_BOOTBLOCK      : return (char *)"Si2151 Error while loading bootblock";
        case ERROR_SI2151_STARTING_FIRMWARE      : return (char *)"Si2151 Error while starting firmware";
        case ERROR_SI2151_SW_RESET               : return (char *)"Si2151 Error during software reset";
        case ERROR_SI2151_INCOMPATIBLE_PART      : return (char *)"Si2151 Error Incompatible part";
        case ERROR_SI2151_UNKNOWN_COMMAND        : return (char *)"Si2151 Error unknown command";
        case ERROR_SI2151_UNKNOWN_PROPERTY       : return (char *)"Si2151 Error unknown property";
        case ERROR_SI2151_TUNINT_TIMEOUT         : return (char *)"Si2151 Error TUNINT Timeout";
        case ERROR_SI2151_xTVINT_TIMEOUT         : return (char *)"Si2151 Error xTVINT Timeout";
        default                                  : return (char *)"Unknown Si2151 error code";
    }
}

#ifdef    SI2151_POWER_UP_CMD
/* SI2151_POWER_UP COMMAND                         */
/*---------------------------------------------------*/
unsigned char Si2151_POWER_UP        (struct i2c_client *si2151,
                                         unsigned char   subcode,
                                         unsigned char   clock_mode,
                                         unsigned char   en_xout,
                                         unsigned char   config_1p8v,
                                         unsigned char   reserved3,
                                         unsigned char   reserved4,
                                         unsigned char   reserved5,
                                         unsigned char   reserved6,
                                         unsigned char   reserved7,
                                         unsigned char   reserved8,
                                         si2151_cmdreplyobj_t *rsp)
{
    unsigned char error_code = 0;
    unsigned char cmdByteBuffer[10];
    unsigned char rspByteBuffer[1];

    printk("Si2151 POWER_UP ");
  #ifdef   DEBUG_RANGE_CHECK
    if ((subcode     > SI2151_POWER_UP_CMD_SUBCODE_MAX    ) ) {error_code++; printk("\nOut of range: ");}; SiTRACE("SUBCODE %d "    , subcode     );
    if ((clock_mode  > SI2151_POWER_UP_CMD_CLOCK_MODE_MAX )  || (clock_mode  < SI2151_POWER_UP_CMD_CLOCK_MODE_MIN ) ) {error_code++; SiTRACE("\nOut of range: ");}; SiTRACE("CLOCK_MODE %d " , clock_mode  );
    if ((en_xout     > SI2151_POWER_UP_CMD_EN_XOUT_MAX    ) ) {error_code++; printk("\nOut of range: ");}; SiTRACE("EN_XOUT %d "    , en_xout     );
    if ((config_1p8v > SI2151_POWER_UP_CMD_CONFIG_1P8V_MAX)  || (config_1p8v < SI2151_POWER_UP_CMD_CONFIG_1P8V_MIN) ) {error_code++; SiTRACE("\nOut of range: ");}; SiTRACE("CONFIG_1P8V %d ", config_1p8v );
    if ((reserved3   > SI2151_POWER_UP_CMD_RESERVED3_MAX  ) ) {error_code++; printk("\nOut of range: ");}; SiTRACE("RESERVED3 %d "  , reserved3   );
    if ((reserved4   > SI2151_POWER_UP_CMD_RESERVED4_MAX  )  || (reserved4   < SI2151_POWER_UP_CMD_RESERVED4_MIN  ) ) {error_code++; SiTRACE("\nOut of range: ");}; SiTRACE("RESERVED4 %d "  , reserved4   );
    if ((reserved5   > SI2151_POWER_UP_CMD_RESERVED5_MAX  )  || (reserved5   < SI2151_POWER_UP_CMD_RESERVED5_MIN  ) ) {error_code++; SiTRACE("\nOut of range: ");}; SiTRACE("RESERVED5 %d "  , reserved5   );
    if ((reserved6   > SI2151_POWER_UP_CMD_RESERVED6_MAX  )  || (reserved6   < SI2151_POWER_UP_CMD_RESERVED6_MIN  ) ) {error_code++; SiTRACE("\nOut of range: ");}; SiTRACE("RESERVED6 %d "  , reserved6   );
    if ((reserved7   > SI2151_POWER_UP_CMD_RESERVED7_MAX  )  || (reserved7   < SI2151_POWER_UP_CMD_RESERVED7_MIN  ) ) {error_code++; SiTRACE("\nOut of range: ");}; SiTRACE("RESERVED7 %d "  , reserved7   );
    if ((reserved8   > SI2151_POWER_UP_CMD_RESERVED8_MAX  )  || (reserved8   < SI2151_POWER_UP_CMD_RESERVED8_MIN  ) ) {error_code++; SiTRACE("\nOut of range: ");}; SiTRACE("RESERVED8 %d "  , reserved8   );
    if (error_code) {
      printk("%d out of range parameters\n", error_code);
      return ERROR_SI2151_PARAMETER_OUT_OF_RANGE;
    }
  #endif /* DEBUG_RANGE_CHECK */
  
        error_code = si2151_pollforcts(si2151);
        if (error_code)
        {
                printk("up: poll cts error:%d!!!!\n", error_code);
                goto exit;
        }

    printk("\n");
    cmdByteBuffer[0] = SI2151_POWER_UP_CMD;
    cmdByteBuffer[1] = (unsigned char) ( ( subcode     & SI2151_POWER_UP_CMD_SUBCODE_MASK     ) << SI2151_POWER_UP_CMD_SUBCODE_LSB    );
    cmdByteBuffer[2] = (unsigned char) ( ( clock_mode  & SI2151_POWER_UP_CMD_CLOCK_MODE_MASK  ) << SI2151_POWER_UP_CMD_CLOCK_MODE_LSB |
                                         ( en_xout     & SI2151_POWER_UP_CMD_EN_XOUT_MASK     ) << SI2151_POWER_UP_CMD_EN_XOUT_LSB    );
    cmdByteBuffer[3] = (unsigned char) ( ( config_1p8v & SI2151_POWER_UP_CMD_CONFIG_1P8V_MASK ) << SI2151_POWER_UP_CMD_CONFIG_1P8V_LSB);
    cmdByteBuffer[4] = (unsigned char) ( ( reserved3   & SI2151_POWER_UP_CMD_RESERVED3_MASK   ) << SI2151_POWER_UP_CMD_RESERVED3_LSB  );
    cmdByteBuffer[5] = (unsigned char) ( ( reserved4   & SI2151_POWER_UP_CMD_RESERVED4_MASK   ) << SI2151_POWER_UP_CMD_RESERVED4_LSB  );
    cmdByteBuffer[6] = (unsigned char) ( ( reserved5   & SI2151_POWER_UP_CMD_RESERVED5_MASK   ) << SI2151_POWER_UP_CMD_RESERVED5_LSB  );
    cmdByteBuffer[7] = (unsigned char) ( ( reserved6   & SI2151_POWER_UP_CMD_RESERVED6_MASK   ) << SI2151_POWER_UP_CMD_RESERVED6_LSB  );
    cmdByteBuffer[8] = (unsigned char) ( ( reserved7   & SI2151_POWER_UP_CMD_RESERVED7_MASK   ) << SI2151_POWER_UP_CMD_RESERVED7_LSB  );
    cmdByteBuffer[9] = (unsigned char) ( ( reserved8   & SI2151_POWER_UP_CMD_RESERVED8_MASK   ) << SI2151_POWER_UP_CMD_RESERVED8_LSB  );

    if (si2151_writecommandbytes(si2151, 10, cmdByteBuffer) != 10) {
      printk("Error writing POWER_UP bytes!\n");
    }
		mdelay(100);
		
      if (!error_code)
        {
                error_code = si2151_pollforresponse(si2151, 1, 1, rspByteBuffer, &reply);
                if (error_code)
                        printk("powerup: poll response error:%d!!!!\n", error_code);

                rsp->power_up.status = &reply;
        }
	 printk("powerup is ok \n" );


exit:
        return error_code;
}
#endif

#ifdef    Si2151_WAKE_UP_CMD
/*---------------------------------------------------*/
/* Si2151_WAKE_UP COMMAND                                   */
/*---------------------------------------------------*/
unsigned char Si2151_L1_WAKE_UP         (struct i2c_client *si2151,
                                         unsigned char   subcode,
                                         unsigned char   reset,
                                         unsigned char   clock_freq,
                                         unsigned char   reserved9,
                                         unsigned char   func,
                                         unsigned char   wake_up,
                                         si2151_cmdreplyobj_t *rsp)
{
    unsigned char error_code = 0;
    unsigned char cmdByteBuffer[7];
    unsigned char rspByteBuffer[1];

    printk("Si2151 WAKE_UP ");
  #ifdef   DEBUG_RANGE_CHECK
    if ((subcode     > Si2151_WAKE_UP_CMD_SUBCODE_MAX    )  || (subcode     < Si2151_WAKE_UP_CMD_SUBCODE_MIN    ) ) {error_code++; printk("\nOut of range: ");}; printk("SUBCODE %d "    , subcode     );
    if ((reset       > Si2151_WAKE_UP_CMD_RESET_MAX      )  || (reset       < Si2151_WAKE_UP_CMD_RESET_MIN      ) ) {error_code++; printk("\nOut of range: ");}; printk("RESET %d "      , reset       );
    if ((clock_freq  > Si2151_WAKE_UP_CMD_CLOCK_FREQ_MAX )  || (clock_freq  < Si2151_WAKE_UP_CMD_CLOCK_FREQ_MIN ) ) {error_code++; printk("\nOut of range: ");}; printk("CLOCK_FREQ %d " , clock_freq  );
    if ((reserved9   > Si2151_WAKE_UP_CMD_RESERVED9_MAX  ) ) {error_code++; printk("\nOut of range: ");}; printk("RESERVED9 %d "  , reserved9   );
    if ((func        > Si2151_WAKE_UP_CMD_FUNC_MAX       ) ) {error_code++; printk("\nOut of range: ");}; printk("FUNC %d "       , func        );
    if ((wake_up     > Si2151_WAKE_UP_CMD_WAKE_UP_MAX    )  || (wake_up     < Si2151_WAKE_UP_CMD_WAKE_UP_MIN    ) ) {error_code++; printk("\nOut of range: ");}; printk("WAKE_UP %d "    , wake_up     );
    if (error_code) {
      printk("%d out of range parameters\n", error_code);
      return ERROR_SI2151_PARAMETER_OUT_OF_RANGE;
    }
  #endif /* DEBUG_RANGE_CHECK */

    printk("\n");
    cmdByteBuffer[0] = Si2151_WAKE_UP_CMD;
    cmdByteBuffer[1] = (unsigned char) ( ( subcode     & Si2151_WAKE_UP_CMD_SUBCODE_MASK     ) << Si2151_WAKE_UP_CMD_SUBCODE_LSB    );
    cmdByteBuffer[2] = (unsigned char) ( ( reset       & Si2151_WAKE_UP_CMD_RESET_MASK       ) << Si2151_WAKE_UP_CMD_RESET_LSB      );
    cmdByteBuffer[3] = (unsigned char) ( ( clock_freq  & Si2151_WAKE_UP_CMD_CLOCK_FREQ_MASK  ) << Si2151_WAKE_UP_CMD_CLOCK_FREQ_LSB );
    cmdByteBuffer[4] = (unsigned char) ( ( reserved9   & Si2151_WAKE_UP_CMD_RESERVED9_MASK   ) << Si2151_WAKE_UP_CMD_RESERVED9_LSB  );
    cmdByteBuffer[5] = (unsigned char) ( ( func       & Si2151_WAKE_UP_CMD_FUNC_MASK       ) << Si2151_WAKE_UP_CMD_FUNC_LSB         );
    cmdByteBuffer[6] = (unsigned char) ( ( wake_up     & Si2151_WAKE_UP_CMD_WAKE_UP_MASK     ) << Si2151_WAKE_UP_CMD_WAKE_UP_LSB    );

    if (si2151_writecommandbytes(si2151, 7, cmdByteBuffer) != 7) {
      printk("Error writing WAKE_UP bytes!\n");
      return ERROR_SI2151_SENDING_COMMAND;
    }

    error_code = si2151_pollforresponse(si2151, 1, 1, rspByteBuffer, &reply);
	rsp->wake_up.STATUS = &reply;
    if (error_code) {
      printk("Error polling AGC_OVERRIDE response\n");
      return error_code;
    }


    return NO_SI2151_ERROR;
}
#endif /* Si2151_WAKE_UP_CMD */


#ifdef SI2151_SET_PROPERTY_CMD
/*---------------------------------------------------*/
/* SI2151_SET_PROPERTY COMMAND                     */
/*---------------------------------------------------*/
unsigned char si2151_set_property(struct i2c_client *si2151,
                unsigned char   reserved,
                unsigned int    prop,
                unsigned int    data,
                si2151_cmdreplyobj_t *rsp)
{
        unsigned char error_code = 0;
        unsigned char cmdbytebuffer[6];
        unsigned char rspbytebuffer[4];

        error_code = si2151_pollforcts(si2151);
        if (error_code)
        {
                pr_info("%s: poll cts error:%d!!!!\n", __func__, error_code);
                goto exit;
        }

        cmdbytebuffer[0] = SI2151_SET_PROPERTY_CMD;
        cmdbytebuffer[1] = (unsigned char) ( ( reserved & SI2151_SET_PROPERTY_CMD_RESERVED_MASK ) << SI2151_SET_PROPERTY_CMD_RESERVED_LSB);
        cmdbytebuffer[2] = (unsigned char) ( ( prop     & SI2151_SET_PROPERTY_CMD_PROP_MASK     ) << SI2151_SET_PROPERTY_CMD_PROP_LSB    );
        cmdbytebuffer[3] = (unsigned char) ((( prop     & SI2151_SET_PROPERTY_CMD_PROP_MASK     ) << SI2151_SET_PROPERTY_CMD_PROP_LSB    )>>8);
        cmdbytebuffer[4] = (unsigned char) ( ( data     & SI2151_SET_PROPERTY_CMD_DATA_MASK     ) << SI2151_SET_PROPERTY_CMD_DATA_LSB    );
        cmdbytebuffer[5] = (unsigned char) ((( data     & SI2151_SET_PROPERTY_CMD_DATA_MASK     ) << SI2151_SET_PROPERTY_CMD_DATA_LSB    )>>8);

        if (si2151_writecommandbytes(si2151, 6, cmdbytebuffer) != 6)
        {
                error_code = ERROR_SI2151_SENDING_COMMAND;
                pr_info("%s: write command byte error:%d!!!!\n", __func__, error_code);
        }

        if (!error_code)
        {
                error_code = si2151_pollforresponse(si2151, 1, 4, rspbytebuffer, &reply);
                if (error_code)
                        pr_info("%s: poll response error:%d!!!!\n", __func__, error_code);
                rsp->set_property.status = &reply;
                if (!error_code)
                {
                        rsp->set_property.reserved =   (( ( (rspbytebuffer[1]  )) >> SI2151_SET_PROPERTY_RESPONSE_RESERVED_LSB ) & SI2151_SET_PROPERTY_RESPONSE_RESERVED_MASK );
                        rsp->set_property.data     =   (( ( (rspbytebuffer[2]  ) | (rspbytebuffer[3]  << 8 )) >> SI2151_SET_PROPERTY_RESPONSE_DATA_LSB     ) & SI2151_SET_PROPERTY_RESPONSE_DATA_MASK     );
                }
        }
exit:
        return error_code;
}
#endif /* SI2151_SET_PROPERTY_CMD */
#ifdef SI2151_TUNER_STATUS_CMD
/*---------------------------------------------------*/
/* SI2151_TUNER_STATUS COMMAND                     */
/*---------------------------------------------------*/
unsigned char si2151_tuner_status(struct i2c_client *si2151,
                unsigned char   intack,
                si2151_cmdreplyobj_t *rsp)
{
        unsigned char error_code = 0;
        unsigned char cmdbytebuffer[2];
        unsigned char rspbytebuffer[12];

#ifdef DEBUG_RANGE_CHECK
        if ( (intack > SI2151_TUNER_STATUS_CMD_INTACK_MAX) )
                return ERROR_SI2151_PARAMETER_OUT_OF_RANGE;
#endif /* DEBUG_RANGE_CHECK */

        error_code = si2151_pollforcts(si2151);
        if (error_code)
        {
                pr_info("%s: poll cts error:%d!!!!\n", __func__, error_code);
                goto exit;
        }

        cmdbytebuffer[0] = SI2151_TUNER_STATUS_CMD;
        cmdbytebuffer[1] = (unsigned char) ( ( intack & SI2151_TUNER_STATUS_CMD_INTACK_MASK ) << SI2151_TUNER_STATUS_CMD_INTACK_LSB);

        if (si2151_writecommandbytes(si2151, 2, cmdbytebuffer) != 2)
        {
                error_code = ERROR_SI2151_SENDING_COMMAND;
                pr_info("%s: write command byte error:%d!!!!\n", __func__, error_code);
        }

        if (!error_code)
        {
                error_code = si2151_pollforresponse(si2151, 1, 12, rspbytebuffer, &reply);
                if (error_code)
                        pr_info("%s: poll response error:%d!!!!\n", __func__, error_code);
                rsp->tuner_status.status = &reply;
                if (!error_code)
                {
                        rsp->tuner_status.tcint          = (( ( (rspbytebuffer[1]  )) >> SI2151_TUNER_STATUS_RESPONSE_TCINT_LSB    ) & SI2151_TUNER_STATUS_RESPONSE_TCINT_MASK    );
                        rsp->tuner_status.rssilint      = (( ( (rspbytebuffer[1]  )) >> SI2151_TUNER_STATUS_RESPONSE_RSSILINT_LSB ) & SI2151_TUNER_STATUS_RESPONSE_RSSILINT_MASK );
                        rsp->tuner_status.rssihint     = (( ( (rspbytebuffer[1]  )) >> SI2151_TUNER_STATUS_RESPONSE_RSSIHINT_LSB ) & SI2151_TUNER_STATUS_RESPONSE_RSSIHINT_MASK );
                        rsp->tuner_status.tc              = (( ( (rspbytebuffer[2]  )) >> SI2151_TUNER_STATUS_RESPONSE_TC_LSB       ) & SI2151_TUNER_STATUS_RESPONSE_TC_MASK       );
                        rsp->tuner_status.rssil          = (( ( (rspbytebuffer[2]  )) >> SI2151_TUNER_STATUS_RESPONSE_RSSIL_LSB    ) & SI2151_TUNER_STATUS_RESPONSE_RSSIL_MASK    );
                        rsp->tuner_status.rssih         = (( ( (rspbytebuffer[2]  )) >> SI2151_TUNER_STATUS_RESPONSE_RSSIH_LSB    ) & SI2151_TUNER_STATUS_RESPONSE_RSSIH_MASK    );
                        rsp->tuner_status.rssi           = (((( ( (rspbytebuffer[3]  )) >> SI2151_TUNER_STATUS_RESPONSE_RSSI_LSB     ) & SI2151_TUNER_STATUS_RESPONSE_RSSI_MASK) <<SI2151_TUNER_STATUS_RESPONSE_RSSI_SHIFT ) >>SI2151_TUNER_STATUS_RESPONSE_RSSI_SHIFT     );
                        rsp->tuner_status.freq          = (( ( (rspbytebuffer[4]  ) | (rspbytebuffer[5]  << 8 ) | (rspbytebuffer[6]  << 16 ) | (rspbytebuffer[7]  << 24 )) >> SI2151_TUNER_STATUS_RESPONSE_FREQ_LSB     ) & SI2151_TUNER_STATUS_RESPONSE_FREQ_MASK     );
                        rsp->tuner_status.mode        = (( ( (rspbytebuffer[8]  )) >> SI2151_TUNER_STATUS_RESPONSE_MODE_LSB     ) & SI2151_TUNER_STATUS_RESPONSE_MODE_MASK     );
                        rsp->tuner_status.vco_code = (((( ( (rspbytebuffer[10] ) | (rspbytebuffer[11] << 8 )) >> SI2151_TUNER_STATUS_RESPONSE_VCO_CODE_LSB ) & SI2151_TUNER_STATUS_RESPONSE_VCO_CODE_MASK) <<SI2151_TUNER_STATUS_RESPONSE_VCO_CODE_SHIFT ) >>SI2151_TUNER_STATUS_RESPONSE_VCO_CODE_SHIFT );
                }
        }
exit:
        return error_code;
}
#endif /* SI2151_TUNER_STATUS_CMD */
#ifdef SI2151_TUNER_TUNE_FREQ_CMD
/*---------------------------------------------------*/
/* SI2151_TUNER_TUNE_FREQ COMMAND                  */
/*---------------------------------------------------*/
unsigned char si2151_tuner_tune_freq(struct i2c_client *si2151,
                unsigned char   mode,
                unsigned long   freq,
                si2151_cmdreplyobj_t *rsp)
{
        unsigned char error_code = 0;
        unsigned char cmdbytebuffer[8];
        unsigned char rspbytebuffer[1];

#ifdef DEBUG_RANGE_CHECK
        if ( (mode > SI2151_TUNER_TUNE_FREQ_CMD_MODE_MAX)
                        || (freq > SI2151_TUNER_TUNE_FREQ_CMD_FREQ_MAX)  || (freq < SI2151_TUNER_TUNE_FREQ_CMD_FREQ_MIN) )
                return ERROR_SI2151_PARAMETER_OUT_OF_RANGE;
#endif /* DEBUG_RANGE_CHECK */

        error_code = si2151_pollforcts(si2151);
        if (error_code)
        {
                pr_info("%s: poll cts error:%d!!!!\n", __func__, error_code);
                goto exit;
        }

        cmdbytebuffer[0] = SI2151_TUNER_TUNE_FREQ_CMD;
        cmdbytebuffer[1] = (unsigned char) ( ( mode & SI2151_TUNER_TUNE_FREQ_CMD_MODE_MASK ) << SI2151_TUNER_TUNE_FREQ_CMD_MODE_LSB);
        cmdbytebuffer[2] = (unsigned char)0x00;
        cmdbytebuffer[3] = (unsigned char)0x00;
        cmdbytebuffer[4] = (unsigned char) ( ( freq & SI2151_TUNER_TUNE_FREQ_CMD_FREQ_MASK ) << SI2151_TUNER_TUNE_FREQ_CMD_FREQ_LSB);
        cmdbytebuffer[5] = (unsigned char) ((( freq & SI2151_TUNER_TUNE_FREQ_CMD_FREQ_MASK ) << SI2151_TUNER_TUNE_FREQ_CMD_FREQ_LSB)>>8);
        cmdbytebuffer[6] = (unsigned char) ((( freq & SI2151_TUNER_TUNE_FREQ_CMD_FREQ_MASK ) << SI2151_TUNER_TUNE_FREQ_CMD_FREQ_LSB)>>16);
        cmdbytebuffer[7] = (unsigned char) ((( freq & SI2151_TUNER_TUNE_FREQ_CMD_FREQ_MASK ) << SI2151_TUNER_TUNE_FREQ_CMD_FREQ_LSB)>>24);

        if (si2151_writecommandbytes(si2151, 8, cmdbytebuffer) != 8)
        {
                error_code = ERROR_SI2151_SENDING_COMMAND;
                pr_info("%s: write command byte error:%d!!!!\n", __func__, error_code);
        }

        if (!error_code)
        {
                error_code = si2151_pollforresponse(si2151, 1, 1, rspbytebuffer, &reply);
                if (error_code)
                        pr_info("%s: poll response error:%d!!!!\n", __func__, error_code);
                rsp->tuner_tune_freq.status = &reply;
        }
exit:
        return error_code;
}
#endif /* SI2151_TUNER_TUNE_FREQ_CMD */

/***********************************************************************************************************************
  si2151_setproperty function
Use:        property set function
Used to call L1_SET_PROPERTY with the property Id and data provided.
Comments:   This is a way to make sure CTS is polled when setting a property
Parameter: *api     the SI2151 context
Parameter: waitforcts flag to wait for a CTS before issuing the property command
Parameter: waitforresponse flag to wait for a CTS after issuing the property command
Parameter: prop     the property Id
Parameter: data     the property bytes
Returns:    0 if no error, an error code otherwise
 ***********************************************************************************************************************/
static unsigned char si2151_setproperty(struct i2c_client *si2151, unsigned int prop, int  data, si2151_cmdreplyobj_t *rsp)
{
        unsigned char  reserved          = 0;
        return si2151_set_property(si2151, reserved, prop, data, rsp);
}

/* _set_property2_insertion_start */

/* --------------------------------------------*/
/* SET_PROPERTY2 FUNCTION                      */
/* --------------------------------------------*/
unsigned char si2151_sendproperty(struct i2c_client *si2151, unsigned int prop, si2151_propobj_t *p, si2151_cmdreplyobj_t *rsp)
{
        int data = 0;
        switch (prop)
        {
#ifdef SI2151_ATV_AFC_RANGE_PROP
                case SI2151_ATV_AFC_RANGE_PROP:
                        data = (p->atv_afc_range.range_khz & SI2151_ATV_AFC_RANGE_PROP_RANGE_KHZ_MASK) << SI2151_ATV_AFC_RANGE_PROP_RANGE_KHZ_LSB ;
                        break;
#endif /*     SI2151_ATV_AFC_RANGE_PROP */
#ifdef SI2151_ATV_AF_OUT_PROP
                case SI2151_ATV_AF_OUT_PROP:
                        data = ((p->atv_af_out.volume & SI2151_ATV_AF_OUT_PROP_VOLUME_MASK) << SI2151_ATV_AF_OUT_PROP_VOLUME_LSB) |
								((p->atv_af_out.mute   & SI2151_ATV_AF_OUT_PROP_MUTE_MASK  ) << SI2151_ATV_AF_OUT_PROP_MUTE_LSB );
                        break;
#endif /*     SI2151_ATV_AF_OUT_PROP */
#ifdef SI2151_ATV_AGC_SPEED_PROP
                case SI2151_ATV_AGC_SPEED_PROP:
                        data = (p->atv_agc_speed.if_agc_speed & SI2151_ATV_AGC_SPEED_PROP_IF_AGC_SPEED_MASK) << SI2151_ATV_AGC_SPEED_PROP_IF_AGC_SPEED_LSB ;
                        break;
#endif /*     SI2151_ATV_AGC_SPEED_PROP */

#ifdef		  SI2151_ATV_AGC_SPEED_LOW_RSSI_PROP
	case		 SI2151_ATV_AGC_SPEED_LOW_RSSI_PROP:
	 data = (p->atv_agc_speed_low_rssi.if_agc_speed & SI2151_ATV_AGC_SPEED_LOW_RSSI_PROP_IF_AGC_SPEED_MASK) << SI2151_ATV_AGC_SPEED_LOW_RSSI_PROP_IF_AGC_SPEED_LSB	|
			 (p->atv_agc_speed_low_rssi.thld 		& SI2151_ATV_AGC_SPEED_LOW_RSSI_PROP_THLD_MASK		  ) << SI2151_ATV_AGC_SPEED_LOW_RSSI_PROP_THLD_LSB ;
break;
#endif /*	  SI2151_ATV_AGC_SPEED_LOW_RSSI_PROP */

#ifdef        SI2151_ATV_ARTIFICIAL_SNOW_PROP
     case         SI2151_ATV_ARTIFICIAL_SNOW_PROP:
      data = (p->atv_artificial_snow.gain   & SI2151_ATV_ARTIFICIAL_SNOW_PROP_GAIN_MASK  ) << SI2151_ATV_ARTIFICIAL_SNOW_PROP_GAIN_LSB  |
              (p->atv_artificial_snow.sound  & SI2151_ATV_ARTIFICIAL_SNOW_PROP_SOUND_MASK ) << SI2151_ATV_ARTIFICIAL_SNOW_PROP_SOUND_LSB  |
              (p->atv_artificial_snow.period & SI2151_ATV_ARTIFICIAL_SNOW_PROP_PERIOD_MASK) << SI2151_ATV_ARTIFICIAL_SNOW_PROP_PERIOD_LSB  |
              (p->atv_artificial_snow.offset & SI2151_ATV_ARTIFICIAL_SNOW_PROP_OFFSET_MASK) << SI2151_ATV_ARTIFICIAL_SNOW_PROP_OFFSET_LSB ;
break;
#endif /*	  SI2151_ATV_ARTIFICIAL_SNOW_PROP */


#ifdef SI2151_ATV_AUDIO_MODE_PROP
                case SI2151_ATV_AUDIO_MODE_PROP:
                        data = (p->atv_audio_mode.audio_sys  & SI2151_ATV_AUDIO_MODE_PROP_AUDIO_SYS_MASK ) << SI2151_ATV_AUDIO_MODE_PROP_AUDIO_SYS_LSB  |
                                (p->atv_audio_mode.demod_mode & SI2151_ATV_AUDIO_MODE_PROP_DEMOD_MODE_MASK) << SI2151_ATV_AUDIO_MODE_PROP_DEMOD_MODE_LSB  |
                                (p->atv_audio_mode.chan_bw    & SI2151_ATV_AUDIO_MODE_PROP_CHAN_BW_MASK   ) << SI2151_ATV_AUDIO_MODE_PROP_CHAN_BW_LSB ;
                        break;
#endif /*     SI2151_ATV_AUDIO_MODE_PROP */
    #ifdef        SI2151_ATV_CONFIG_IF_PORT_PROP
     case         SI2151_ATV_CONFIG_IF_PORT_PROP:
      data = (p->atv_config_if_port.atv_out_type & SI2151_ATV_CONFIG_IF_PORT_PROP_ATV_OUT_TYPE_MASK) << SI2151_ATV_CONFIG_IF_PORT_PROP_ATV_OUT_TYPE_LSB ;
     break;
    #endif /*     SI2151_ATV_CONFIG_IF_PORT_PROP */
#ifdef SI2151_ATV_CVBS_OUT_PROP
                case SI2151_ATV_CVBS_OUT_PROP:
                        data = (p->atv_cvbs_out.offset & SI2151_ATV_CVBS_OUT_PROP_OFFSET_MASK) << SI2151_ATV_CVBS_OUT_PROP_OFFSET_LSB  |
                                (p->atv_cvbs_out.amp    & SI2151_ATV_CVBS_OUT_PROP_AMP_MASK   ) << SI2151_ATV_CVBS_OUT_PROP_AMP_LSB ;
                        break;
#endif /*     SI2151_ATV_CVBS_OUT_PROP */
#ifdef SI2151_ATV_CVBS_OUT_FINE_PROP
                case SI2151_ATV_CVBS_OUT_FINE_PROP:
                        data = (p->atv_cvbs_out_fine.offset & SI2151_ATV_CVBS_OUT_FINE_PROP_OFFSET_MASK) << SI2151_ATV_CVBS_OUT_FINE_PROP_OFFSET_LSB  |
                                (p->atv_cvbs_out_fine.amp    & SI2151_ATV_CVBS_OUT_FINE_PROP_AMP_MASK   ) << SI2151_ATV_CVBS_OUT_FINE_PROP_AMP_LSB ;
                        break;
#endif /*     SI2151_ATV_CVBS_OUT_FINE_PROP */
    #ifdef        SI2151_ATV_HSYNC_OUT_PROP
     case         SI2151_ATV_HSYNC_OUT_PROP:
      data = (p->atv_hsync_out.gpio_sel & SI2151_ATV_HSYNC_OUT_PROP_GPIO_SEL_MASK) << SI2151_ATV_HSYNC_OUT_PROP_GPIO_SEL_LSB  |
              (p->atv_hsync_out.width    & SI2151_ATV_HSYNC_OUT_PROP_WIDTH_MASK   ) << SI2151_ATV_HSYNC_OUT_PROP_WIDTH_LSB  |
              (p->atv_hsync_out.offset   & SI2151_ATV_HSYNC_OUT_PROP_OFFSET_MASK  ) << SI2151_ATV_HSYNC_OUT_PROP_OFFSET_LSB ;
     break;
    #endif /*     SI2151_ATV_HSYNC_OUT_PROP */
#ifdef SI2151_ATV_IEN_PROP
                case SI2151_ATV_IEN_PROP:
                        data = (p->atv_ien.chlien  & SI2151_ATV_IEN_PROP_CHLIEN_MASK ) << SI2151_ATV_IEN_PROP_CHLIEN_LSB  |
                                (p->atv_ien.pclien  & SI2151_ATV_IEN_PROP_PCLIEN_MASK ) << SI2151_ATV_IEN_PROP_PCLIEN_LSB  |
                                (p->atv_ien.dlien   & SI2151_ATV_IEN_PROP_DLIEN_MASK  ) << SI2151_ATV_IEN_PROP_DLIEN_LSB  |
                                (p->atv_ien.snrlien & SI2151_ATV_IEN_PROP_SNRLIEN_MASK) << SI2151_ATV_IEN_PROP_SNRLIEN_LSB  |
                                (p->atv_ien.snrhien & SI2151_ATV_IEN_PROP_SNRHIEN_MASK) << SI2151_ATV_IEN_PROP_SNRHIEN_LSB ;
                        break;
#endif /*     SI2151_ATV_IEN_PROP */
#ifdef SI2151_ATV_INT_SENSE_PROP
                case SI2151_ATV_INT_SENSE_PROP:
                        data = (p->atv_int_sense.chlnegen  & SI2151_ATV_INT_SENSE_PROP_CHLNEGEN_MASK ) << SI2151_ATV_INT_SENSE_PROP_CHLNEGEN_LSB  |
                                (p->atv_int_sense.pclnegen  & SI2151_ATV_INT_SENSE_PROP_PCLNEGEN_MASK ) << SI2151_ATV_INT_SENSE_PROP_PCLNEGEN_LSB  |
                                (p->atv_int_sense.dlnegen   & SI2151_ATV_INT_SENSE_PROP_DLNEGEN_MASK  ) << SI2151_ATV_INT_SENSE_PROP_DLNEGEN_LSB  |
                                (p->atv_int_sense.snrlnegen & SI2151_ATV_INT_SENSE_PROP_SNRLNEGEN_MASK) << SI2151_ATV_INT_SENSE_PROP_SNRLNEGEN_LSB  |
                                (p->atv_int_sense.snrhnegen & SI2151_ATV_INT_SENSE_PROP_SNRHNEGEN_MASK) << SI2151_ATV_INT_SENSE_PROP_SNRHNEGEN_LSB  |
                                (p->atv_int_sense.chlposen  & SI2151_ATV_INT_SENSE_PROP_CHLPOSEN_MASK ) << SI2151_ATV_INT_SENSE_PROP_CHLPOSEN_LSB  |
                                (p->atv_int_sense.pclposen  & SI2151_ATV_INT_SENSE_PROP_PCLPOSEN_MASK ) << SI2151_ATV_INT_SENSE_PROP_PCLPOSEN_LSB  |
                                (p->atv_int_sense.dlposen   & SI2151_ATV_INT_SENSE_PROP_DLPOSEN_MASK  ) << SI2151_ATV_INT_SENSE_PROP_DLPOSEN_LSB  |
                                (p->atv_int_sense.snrlposen & SI2151_ATV_INT_SENSE_PROP_SNRLPOSEN_MASK) << SI2151_ATV_INT_SENSE_PROP_SNRLPOSEN_LSB  |
                                (p->atv_int_sense.snrhposen & SI2151_ATV_INT_SENSE_PROP_SNRHPOSEN_MASK) << SI2151_ATV_INT_SENSE_PROP_SNRHPOSEN_LSB ;
                        break;
#endif /*     SI2151_ATV_INT_SENSE_PROP */
    #ifdef        SI2151_ATV_PGA_TARGET_PROP
     case         SI2151_ATV_PGA_TARGET_PROP:
      data = (p->atv_pga_target.pga_target      & SI2151_ATV_PGA_TARGET_PROP_PGA_TARGET_MASK     ) << SI2151_ATV_PGA_TARGET_PROP_PGA_TARGET_LSB  |
              (p->atv_pga_target.override_enable & SI2151_ATV_PGA_TARGET_PROP_OVERRIDE_ENABLE_MASK) << SI2151_ATV_PGA_TARGET_PROP_OVERRIDE_ENABLE_LSB ;
     break;
    #endif /*     SI2151_ATV_PGA_TARGET_PROP */
#ifdef SI2151_ATV_RF_TOP_PROP
                case SI2151_ATV_RF_TOP_PROP:
                        data = (p->atv_rf_top.atv_rf_top & SI2151_ATV_RF_TOP_PROP_ATV_RF_TOP_MASK) << SI2151_ATV_RF_TOP_PROP_ATV_RF_TOP_LSB ;
                        break;
#endif /*     SI2151_ATV_RF_TOP_PROP */
#ifdef SI2151_ATV_RSQ_RSSI_THRESHOLD_PROP
                case SI2151_ATV_RSQ_RSSI_THRESHOLD_PROP:
                        data = (p->atv_rsq_rssi_threshold.lo & SI2151_ATV_RSQ_RSSI_THRESHOLD_PROP_LO_MASK) << SI2151_ATV_RSQ_RSSI_THRESHOLD_PROP_LO_LSB  |
                                (p->atv_rsq_rssi_threshold.hi & SI2151_ATV_RSQ_RSSI_THRESHOLD_PROP_HI_MASK) << SI2151_ATV_RSQ_RSSI_THRESHOLD_PROP_HI_LSB ;
                        break;
#endif /*     SI2151_ATV_RSQ_RSSI_THRESHOLD_PROP */
#ifdef SI2151_ATV_RSQ_SNR_THRESHOLD_PROP
                case SI2151_ATV_RSQ_SNR_THRESHOLD_PROP:
                        data = (p->atv_rsq_snr_threshold.lo & SI2151_ATV_RSQ_SNR_THRESHOLD_PROP_LO_MASK) << SI2151_ATV_RSQ_SNR_THRESHOLD_PROP_LO_LSB  |
                                (p->atv_rsq_snr_threshold.hi & SI2151_ATV_RSQ_SNR_THRESHOLD_PROP_HI_MASK) << SI2151_ATV_RSQ_SNR_THRESHOLD_PROP_HI_LSB ;
                        break;
#endif /*     SI2151_ATV_RSQ_SNR_THRESHOLD_PROP */
#ifdef SI2151_ATV_SOUND_AGC_SPEED_PROP
                case SI2151_ATV_SOUND_AGC_SPEED_PROP:
                        data = (p->atv_sound_agc_speed.other_systems & SI2151_ATV_SOUND_AGC_SPEED_PROP_OTHER_SYSTEMS_MASK) << SI2151_ATV_SOUND_AGC_SPEED_PROP_OTHER_SYSTEMS_LSB |
                                (p->atv_sound_agc_speed.system_l & SI2151_ATV_SOUND_AGC_SPEED_PROP_SYSTEM_L_MASK) << SI2151_ATV_SOUND_AGC_SPEED_PROP_SYSTEM_L_LSB;
                        break;
#endif
#ifdef SI2151_ATV_SIF_OUT_PROP
                case SI2151_ATV_SIF_OUT_PROP:
                        data = (p->atv_sif_out.offset & SI2151_ATV_SIF_OUT_PROP_OFFSET_MASK) << SI2151_ATV_SIF_OUT_PROP_OFFSET_LSB  |
                                (p->atv_sif_out.amp    & SI2151_ATV_SIF_OUT_PROP_AMP_MASK   ) << SI2151_ATV_SIF_OUT_PROP_AMP_LSB ;
                        break;
#endif /*     SI2151_ATV_SIF_OUT_PROP */
#ifdef SI2151_ATV_SOUND_AGC_LIMIT_PROP
                case SI2151_ATV_SOUND_AGC_LIMIT_PROP:
                        data = (p->atv_sound_agc_limit.max_gain & SI2151_ATV_SOUND_AGC_LIMIT_PROP_MAX_GAIN_MASK) << SI2151_ATV_SOUND_AGC_LIMIT_PROP_MAX_GAIN_LSB  |
                                (p->atv_sound_agc_limit.min_gain & SI2151_ATV_SOUND_AGC_LIMIT_PROP_MIN_GAIN_MASK) << SI2151_ATV_SOUND_AGC_LIMIT_PROP_MIN_GAIN_LSB ;
                        break;
#endif /*     SI2151_ATV_SOUND_AGC_LIMIT_PROP */
#ifdef        SI2151_ATV_SOUND_AGC_SPEED_PROP_c
     case         SI2151_ATV_SOUND_AGC_SPEED_PROP:
      *data = (p->atv_sound_agc_speed.system_l      & SI2151_ATV_SOUND_AGC_SPEED_PROP_SYSTEM_L_MASK     ) << SI2151_ATV_SOUND_AGC_SPEED_PROP_SYSTEM_L_LSB  |
              (p->atv_sound_agc_speed.other_systems & SI2151_ATV_SOUND_AGC_SPEED_PROP_OTHER_SYSTEMS_MASK) << SI2151_ATV_SOUND_AGC_SPEED_PROP_OTHER_SYSTEMS_LSB ;
     break;
#endif
#ifdef SI2151_ATV_VIDEO_EQUALIZER_PROP
                case SI2151_ATV_VIDEO_EQUALIZER_PROP:
                        data = (p->atv_video_equalizer.slope & SI2151_ATV_VIDEO_EQUALIZER_PROP_SLOPE_MASK) << SI2151_ATV_VIDEO_EQUALIZER_PROP_SLOPE_LSB ;
                        break;
#endif /*     SI2151_ATV_VIDEO_EQUALIZER_PROP */
#ifdef SI2151_ATV_VIDEO_MODE_PROP
                case SI2151_ATV_VIDEO_MODE_PROP:
                        data = (p->atv_video_mode.video_sys       & SI2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_MASK      ) << SI2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_LSB  |
                                (p->atv_video_mode.color           & SI2151_ATV_VIDEO_MODE_PROP_COLOR_MASK          ) << SI2151_ATV_VIDEO_MODE_PROP_COLOR_LSB  |
                                (p->atv_video_mode.invert_signal   & SI2151_ATV_VIDEO_MODE_PROP_INVERT_SIGNAL_MASK  ) << SI2151_ATV_VIDEO_MODE_PROP_INVERT_SIGNAL_LSB ;
                        break;
#endif /*     SI2151_ATV_VIDEO_MODE_PROP */
#ifdef SI2151_ATV_VSNR_CAP_PROP
                case SI2151_ATV_VSNR_CAP_PROP:
                        data = (p->atv_vsnr_cap.atv_vsnr_cap & SI2151_ATV_VSNR_CAP_PROP_ATV_VSNR_CAP_MASK) << SI2151_ATV_VSNR_CAP_PROP_ATV_VSNR_CAP_LSB ;
                        break;
#endif /*     SI2151_ATV_VSNR_CAP_PROP */
#ifdef SI2151_ATV_VSYNC_TRACKING_PROP
                case SI2151_ATV_VSYNC_TRACKING_PROP:
                        data = (p->atv_vsync_tracking.min_pulses_to_lock   & SI2151_ATV_VSYNC_TRACKING_PROP_MIN_PULSES_TO_LOCK_MASK  ) << SI2151_ATV_VSYNC_TRACKING_PROP_MIN_PULSES_TO_LOCK_LSB  |
                                (p->atv_vsync_tracking.min_fields_to_unlock & SI2151_ATV_VSYNC_TRACKING_PROP_MIN_FIELDS_TO_UNLOCK_MASK) << SI2151_ATV_VSYNC_TRACKING_PROP_MIN_FIELDS_TO_UNLOCK_LSB ;
                        break;
#endif /*     SI2151_ATV_VSYNC_TRACKING_PROP */
#ifdef SI2151_CRYSTAL_TRIM_PROP
                case SI2151_CRYSTAL_TRIM_PROP:
                        data = (p->crystal_trim.xo_cap & SI2151_CRYSTAL_TRIM_PROP_XO_CAP_MASK) << SI2151_CRYSTAL_TRIM_PROP_XO_CAP_LSB ;
                        break;
#endif /*     SI2151_CRYSTAL_TRIM_PROP */
#ifdef SI2151_DTV_LIF_FREQ_PROP
                case SI2151_DTV_LIF_FREQ_PROP:
                        data = (p->dtv_lif_freq.offset & SI2151_DTV_LIF_FREQ_PROP_OFFSET_MASK) << SI2151_DTV_LIF_FREQ_PROP_OFFSET_LSB ;
                        break;
#endif /*     SI2151_DTV_LIF_FREQ_PROP */
#ifdef SI2151_DTV_LIF_OUT_PROP
                case SI2151_DTV_LIF_OUT_PROP:
                        data = (p->dtv_lif_out.offset & SI2151_DTV_LIF_OUT_PROP_OFFSET_MASK) << SI2151_DTV_LIF_OUT_PROP_OFFSET_LSB  |
                                (p->dtv_lif_out.amp    & SI2151_DTV_LIF_OUT_PROP_AMP_MASK   ) << SI2151_DTV_LIF_OUT_PROP_AMP_LSB ;
                        break;
#endif /*     SI2151_DTV_LIF_OUT_PROP */
#ifdef SI2151_DTV_AGC_SPEED_PROP
                case SI2151_DTV_AGC_SPEED_PROP:
                    data = (p->dtv_agc_speed.agc_decim & SI2151_DTV_AGC_SPEED_PROP_AGC_DECIM_MASK) << SI2151_DTV_AGC_SPEED_PROP_AGC_DECIM_LSB |
                           (p->dtv_agc_speed.if_agc_speed & SI2151_DTV_AGC_SPEED_PROP_IF_AGC_SPEED_MASK) << SI2151_DTV_AGC_SPEED_PROP_IF_AGC_SPEED_LSB;
                    break;
#endif /* SI2151_DTV_AGC_SPEED_PROP */
#ifdef SI2151_DTV_MODE_PROP
                case SI2151_DTV_MODE_PROP:
                        data = (p->dtv_mode.bw              & SI2151_DTV_MODE_PROP_BW_MASK             ) << SI2151_DTV_MODE_PROP_BW_LSB  |
                                (p->dtv_mode.modulation      & SI2151_DTV_MODE_PROP_MODULATION_MASK     ) << SI2151_DTV_MODE_PROP_MODULATION_LSB  |
                                (p->dtv_mode.invert_spectrum & SI2151_DTV_MODE_PROP_INVERT_SPECTRUM_MASK) << SI2151_DTV_MODE_PROP_INVERT_SPECTRUM_LSB ;
                        break;
#endif /*     SI2151_DTV_MODE_PROP */
#ifdef SI2151_DTV_RF_TOP_PROP
                case SI2151_DTV_RF_TOP_PROP:
                        data = (p->dtv_rf_top.dtv_rf_top & SI2151_DTV_RF_TOP_PROP_DTV_RF_TOP_MASK) << SI2151_DTV_RF_TOP_PROP_DTV_RF_TOP_LSB ;
                        break;
#endif /*     SI2151_DTV_RF_TOP_PROP */
#ifdef SI2151_DTV_RSQ_RSSI_THRESHOLD_PROP
                case SI2151_DTV_RSQ_RSSI_THRESHOLD_PROP:
                        data = (p->dtv_rsq_rssi_threshold.lo & SI2151_DTV_RSQ_RSSI_THRESHOLD_PROP_LO_MASK) << SI2151_DTV_RSQ_RSSI_THRESHOLD_PROP_LO_LSB  |
                                (p->dtv_rsq_rssi_threshold.hi & SI2151_DTV_RSQ_RSSI_THRESHOLD_PROP_HI_MASK) << SI2151_DTV_RSQ_RSSI_THRESHOLD_PROP_HI_LSB ;
                        break;
#endif /*     SI2151_DTV_RSQ_RSSI_THRESHOLD_PROP */
#ifdef SI2151_MASTER_IEN_PROP
                case SI2151_MASTER_IEN_PROP:
                        data = (p->master_ien.tunien & SI2151_MASTER_IEN_PROP_TUNIEN_MASK) << SI2151_MASTER_IEN_PROP_TUNIEN_LSB  |
                                (p->master_ien.atvien & SI2151_MASTER_IEN_PROP_ATVIEN_MASK) << SI2151_MASTER_IEN_PROP_ATVIEN_LSB  |
                                (p->master_ien.dtvien & SI2151_MASTER_IEN_PROP_DTVIEN_MASK) << SI2151_MASTER_IEN_PROP_DTVIEN_LSB  |
                                (p->master_ien.errien & SI2151_MASTER_IEN_PROP_ERRIEN_MASK) << SI2151_MASTER_IEN_PROP_ERRIEN_LSB  |
                                (p->master_ien.ctsien & SI2151_MASTER_IEN_PROP_CTSIEN_MASK) << SI2151_MASTER_IEN_PROP_CTSIEN_LSB ;
                        break;
#endif /*     SI2151_MASTER_IEN_PROP */
#ifdef SI2151_TUNER_BLOCKED_VCO_PROP
                case SI2151_TUNER_BLOCKED_VCO_PROP:
                        data = (p->tuner_blocked_vco.vco_code & SI2151_TUNER_BLOCKED_VCO_PROP_VCO_CODE_MASK) << SI2151_TUNER_BLOCKED_VCO_PROP_VCO_CODE_LSB ;
                        break;
#endif /*     SI2151_TUNER_BLOCKED_VCO_PROP */
#ifdef SI2151_TUNER_IEN_PROP
                case SI2151_TUNER_IEN_PROP:
                        data = (p->tuner_ien.tcien    & SI2151_TUNER_IEN_PROP_TCIEN_MASK   ) << SI2151_TUNER_IEN_PROP_TCIEN_LSB  |
                                (p->tuner_ien.rssilien & SI2151_TUNER_IEN_PROP_RSSILIEN_MASK) << SI2151_TUNER_IEN_PROP_RSSILIEN_LSB  |
                                (p->tuner_ien.rssihien & SI2151_TUNER_IEN_PROP_RSSIHIEN_MASK) << SI2151_TUNER_IEN_PROP_RSSIHIEN_LSB ;
                        break;
#endif /*     SI2151_TUNER_IEN_PROP */
#ifdef SI2151_TUNER_INT_SENSE_PROP
                case SI2151_TUNER_INT_SENSE_PROP:
                        data = (p->tuner_int_sense.tcnegen    & SI2151_TUNER_INT_SENSE_PROP_TCNEGEN_MASK   ) << SI2151_TUNER_INT_SENSE_PROP_TCNEGEN_LSB  |
                                (p->tuner_int_sense.rssilnegen & SI2151_TUNER_INT_SENSE_PROP_RSSILNEGEN_MASK) << SI2151_TUNER_INT_SENSE_PROP_RSSILNEGEN_LSB  |
                                (p->tuner_int_sense.rssihnegen & SI2151_TUNER_INT_SENSE_PROP_RSSIHNEGEN_MASK) << SI2151_TUNER_INT_SENSE_PROP_RSSIHNEGEN_LSB  |
                                (p->tuner_int_sense.tcposen    & SI2151_TUNER_INT_SENSE_PROP_TCPOSEN_MASK   ) << SI2151_TUNER_INT_SENSE_PROP_TCPOSEN_LSB  |
                                (p->tuner_int_sense.rssilposen & SI2151_TUNER_INT_SENSE_PROP_RSSILPOSEN_MASK) << SI2151_TUNER_INT_SENSE_PROP_RSSILPOSEN_LSB  |
                                (p->tuner_int_sense.rssihposen & SI2151_TUNER_INT_SENSE_PROP_RSSIHPOSEN_MASK) << SI2151_TUNER_INT_SENSE_PROP_RSSIHPOSEN_LSB ;
                        break;
#endif /*     SI2151_TUNER_INT_SENSE_PROP */
#ifdef SI2151_TUNER_LO_INJECTION_PROP
                case SI2151_TUNER_LO_INJECTION_PROP:
                        data = (p->tuner_lo_injection.band_1 & SI2151_TUNER_LO_INJECTION_PROP_BAND_1_MASK) << SI2151_TUNER_LO_INJECTION_PROP_BAND_1_LSB  |
                                (p->tuner_lo_injection.band_2 & SI2151_TUNER_LO_INJECTION_PROP_BAND_2_MASK) << SI2151_TUNER_LO_INJECTION_PROP_BAND_2_LSB  |
                                (p->tuner_lo_injection.band_3 & SI2151_TUNER_LO_INJECTION_PROP_BAND_3_MASK) << SI2151_TUNER_LO_INJECTION_PROP_BAND_3_LSB  ;
     break;
#endif /*     SI2151_TUNER_LO_INJECTION_PROP */
    #ifdef        SI2151_TUNER_RETURN_LOSS_PROP
     case         SI2151_TUNER_RETURN_LOSS_PROP_CODE:
      data = (p->tuner_return_loss.config & SI2151_TUNER_RETURN_LOSS_PROP_CONFIG_MASK) << SI2151_TUNER_RETURN_LOSS_PROP_CONFIG_LSB  |
              (p->tuner_return_loss.mode   & SI2151_TUNER_RETURN_LOSS_PROP_MODE_MASK  ) << SI2151_TUNER_RETURN_LOSS_PROP_MODE_LSB ;
     break;
    #endif /*     SI2151_TUNER_RETURN_LOSS_PROP */
    #ifdef        SI2151_XOUT_PROP
     case         SI2151_XOUT_PROP_CODE:
      data = (p->xout.amp & SI2151_XOUT_PROP_AMP_MASK) << SI2151_XOUT_PROP_AMP_LSB ;
     break;
#endif /*     SI2151_XOUT_PROP */
    #ifdef        Si2151_ATV_EXT_AGC_PROP
     case         Si2151_ATV_EXT_AGC_PROP:
      data = (p->atv_ext_agc.min_10mv & Si2151_ATV_EXT_AGC_PROP_MIN_10MV_MASK) << Si2151_ATV_EXT_AGC_PROP_MIN_10MV_LSB  |
              (p->atv_ext_agc.max_10mv & Si2151_ATV_EXT_AGC_PROP_MAX_10MV_MASK) << Si2151_ATV_EXT_AGC_PROP_MAX_10MV_LSB ;
     break;
    #endif /*     Si2151_ATV_EXT_AGC_PROP */

    #ifdef        Si2151_ATV_LIF_FREQ_PROP
     case         Si2151_ATV_LIF_FREQ_PROP:
      data = (p->atv_lif_freq.offset & Si2151_ATV_LIF_FREQ_PROP_OFFSET_MASK) << Si2151_ATV_LIF_FREQ_PROP_OFFSET_LSB ;
     break;
    #endif /*     Si2151_ATV_LIF_FREQ_PROP */	
    #ifdef        Si2151_ATV_LIF_OUT_PROP
     case         Si2151_ATV_LIF_OUT_PROP_CODE:
      data = (p->atv_lif_out.offset & Si2151_ATV_LIF_OUT_PROP_OFFSET_MASK) << Si2151_ATV_LIF_OUT_PROP_OFFSET_LSB  |
              (p->atv_lif_out.amp    & Si2151_ATV_LIF_OUT_PROP_AMP_MASK   ) << Si2151_ATV_LIF_OUT_PROP_AMP_LSB ;
     break;
    #endif /*     Si2151_ATV_LIF_OUT_PROP */

    #ifdef        Si2151_ATV_PGA_LIMITS_PROP
     case         Si2151_ATV_PGA_LIMITS_PROP:
      data = (p->atv_pga_limits.min & Si2151_ATV_PGA_LIMITS_PROP_MIN_MASK) << Si2151_ATV_PGA_LIMITS_PROP_MIN_LSB  |
              (p->atv_pga_limits.max & Si2151_ATV_PGA_LIMITS_PROP_MAX_MASK) << Si2151_ATV_PGA_LIMITS_PROP_MAX_LSB ;
     break;
    #endif /*     Si2151_ATV_PGA_LIMITS_PROP */



    #ifdef        Si2151_TUNER_BLOCKED_VCO2_PROP
     case         Si2151_TUNER_BLOCKED_VCO2_PROP:
      data = (p->tuner_blocked_vco2.vco_code & Si2151_TUNER_BLOCKED_VCO2_PROP_VCO_CODE_MASK) << Si2151_TUNER_BLOCKED_VCO2_PROP_VCO_CODE_LSB ;
     break;
    #endif /*     Si2151_TUNER_BLOCKED_VCO2_PROP */
    #ifdef        Si2151_TUNER_BLOCKED_VCO3_PROP
     case         Si2151_TUNER_BLOCKED_VCO3_PROP:
      data = (p->tuner_blocked_vco3.vco_code & Si2151_TUNER_BLOCKED_VCO3_PROP_VCO_CODE_MASK) << Si2151_TUNER_BLOCKED_VCO3_PROP_VCO_CODE_LSB ;
     break;
    #endif /*     Si2151_TUNER_BLOCKED_VCO3_PROP */
	
    #ifdef        Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP
     case         Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP:
      data = (p->tuner_return_loss_optimize.thld                & Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP_THLD_MASK               ) << Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP_THLD_LSB  |
              (p->tuner_return_loss_optimize.config              & Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP_CONFIG_MASK             ) << Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP_CONFIG_LSB  |
              (p->tuner_return_loss_optimize.engagement_delay    & Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP_ENGAGEMENT_DELAY_MASK   ) << Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP_ENGAGEMENT_DELAY_LSB  |
              (p->tuner_return_loss_optimize.disengagement_delay & Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP_DISENGAGEMENT_DELAY_MASK) << Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP_DISENGAGEMENT_DELAY_LSB ;
     break;
    #endif /*     Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP */
    #ifdef        Si2151_TUNER_RETURN_LOSS_OPTIMIZE_2_PROP
     case         Si2151_TUNER_RETURN_LOSS_OPTIMIZE_2_PROP:
      data = (p->tuner_return_loss_optimize_2.thld             & Si2151_TUNER_RETURN_LOSS_OPTIMIZE_2_PROP_THLD_MASK            ) << Si2151_TUNER_RETURN_LOSS_OPTIMIZE_2_PROP_THLD_LSB  |
              (p->tuner_return_loss_optimize_2.window           & Si2151_TUNER_RETURN_LOSS_OPTIMIZE_2_PROP_WINDOW_MASK          ) << Si2151_TUNER_RETURN_LOSS_OPTIMIZE_2_PROP_WINDOW_LSB  |
              (p->tuner_return_loss_optimize_2.engagement_delay & Si2151_TUNER_RETURN_LOSS_OPTIMIZE_2_PROP_ENGAGEMENT_DELAY_MASK) << Si2151_TUNER_RETURN_LOSS_OPTIMIZE_2_PROP_ENGAGEMENT_DELAY_LSB ;
     break;
    #endif /*     Si2151_TUNER_RETURN_LOSS_OPTIMIZE_2_PROP */
    #ifdef        Si2151_TUNER_TF1_BOUNDARY_OFFSET_PROP
     case         Si2151_TUNER_TF1_BOUNDARY_OFFSET_PROP:
      data = (p->tuner_tf1_boundary_offset.tf1_boundary_offset & Si2151_TUNER_TF1_BOUNDARY_OFFSET_PROP_TF1_BOUNDARY_OFFSET_MASK) << Si2151_TUNER_TF1_BOUNDARY_OFFSET_PROP_TF1_BOUNDARY_OFFSET_LSB ;
     break;
    #endif /*     Si2151_TUNER_TF1_BOUNDARY_OFFSET_PROP */
    #ifdef SI2151_DTV_AGC_AUTO_FREEZE_PROP
    case SI2151_DTV_AGC_AUTO_FREEZE_PROP:
        data = (p->dtv_agc_auto_freeze.thld & SI2151_DTV_AGC_AUTO_FREEZE_PROP_THLD_MASK) << SI2151_DTV_AGC_AUTO_FREEZE_PROP_THLD_LSB |
               (p->dtv_agc_auto_freeze.timeout & SI2151_DTV_AGC_AUTO_FREEZE_PROP_TIMEOUT_MASK) << SI2151_DTV_AGC_AUTO_FREEZE_PROP_TIMEOUT_LSB;
        break;
    #endif /* SI2151_DTV_AGC_AUTO_FREEZE_PROP */
                default :
                        break;
        }
        return si2151_setproperty(si2151, prop , data, rsp);
}

static int si2157_setupatvdefaults(si2151_propobj_t *prop)
{
    prop->atv_ien.chlien                                 = SI2151_ATV_IEN_PROP_CHLIEN_ENABLE;     /* enable only CHL to drive ATVINT */
     prop->atv_ien.dlien                                   = SI2151_ATV_IEN_PROP_DLIEN_ENABLE;
     prop->atv_ien.pclien                                 = SI2151_ATV_IEN_PROP_PCLIEN_ENABLE;
     prop->atv_ien.snrhien                               = SI2151_ATV_IEN_PROP_SNRHIEN_ENABLE;
     prop->atv_ien.snrlien                                = SI2151_ATV_IEN_PROP_SNRLIEN_ENABLE;
     prop->atv_rsq_rssi_threshold.hi                          = 0;
     prop->atv_rsq_rssi_threshold.lo                          = -70;

    prop->atv_afc_range.range_khz                          = 2000;
    prop->atv_vsnr_cap.atv_vsnr_cap                       = 0;
    prop->atv_agc_speed.if_agc_speed                    = 178;//patch for skyworth
    prop->atv_rf_top.atv_rf_top                     = SI2151_ATV_RF_TOP_PROP_ATV_RF_TOP_AUTO;
    prop->atv_int_sense.chlnegen                   = SI2151_ATV_INT_SENSE_PROP_CHLNEGEN_DISABLE;
    prop->atv_int_sense.chlposen                   = SI2151_ATV_INT_SENSE_PROP_CHLPOSEN_ENABLE;
    prop->atv_int_sense.dlnegen                     = SI2151_ATV_INT_SENSE_PROP_DLNEGEN_DISABLE;
    prop->atv_int_sense.dlposen                     = SI2151_ATV_INT_SENSE_PROP_DLPOSEN_ENABLE;
    prop->atv_video_mode.video_sys             = SI2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_DK;//SI2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_DK;
    prop->atv_video_mode.trans                     = SI2151_ATV_VIDEO_MODE_PROP_TRANS_CABLE;//SI2176_ATV_VIDEO_MODE_PROP_TRANS_TERRESTRIAL;
    prop->atv_video_mode.color                     = SI2151_ATV_VIDEO_MODE_PROP_COLOR_PAL_NTSC;
    prop->atv_video_mode.invert_signal = SI2151_ATV_VIDEO_MODE_PROP_INVERT_SIGNAL_INVERTED;

    return 0;
}
/************************************************************************************************************************
NAME: si2151_SetupCommonDefaults
DESCRIPTION: Setup si2151 Common startup configuration
This is a list of all the common configuration properties.   Depending on your application, only a subset may be required.
The properties are stored in the global property structure 'prop'.  The function CommonConfig(..) must be called
after any of these properties are modified.
Parameter:  none
Returns:    0 if successful
Programming Guide Reference:    Flowchart A.6a (Common setup flowchart)
 ************************************************************************************************************************/
static int si2151_setupcommondefaults(si2151_propobj_t *prop)
{
#ifdef    SI2151_CRYSTAL_TRIM_PROP
	  prop->crystal_trim.xo_cap 				 = SI2151_XTAL_CAP ; /* (default '6p7pF') */
#endif /* SI2151_CRYSTAL_TRIM_PROP */

#ifdef    SI2151_MASTER_IEN_PROP
	  prop->master_ien.tunien					 = SI2151_MASTER_IEN_PROP_TUNIEN_ON ; /* (default 'OFF') */
	  prop->master_ien.atvien					 = SI2151_MASTER_IEN_PROP_ATVIEN_ON ; /* (default 'OFF') */
	  prop->master_ien.dtvien					 = SI2151_MASTER_IEN_PROP_DTVIEN_OFF ; /* (default 'OFF') */
	  prop->master_ien.errien					 = SI2151_MASTER_IEN_PROP_ERRIEN_ON ; /* (default 'OFF') */
	  prop->master_ien.ctsien					 = SI2151_MASTER_IEN_PROP_CTSIEN_ON ; /* (default 'OFF') */
#endif /* SI2151_MASTER_IEN_PROP */

#ifdef    SI2151_XOUT_PROP
	  //prop->xout.amp							 = SI2151_XOUT_PROP_AMP_HIGH ; /* (default 'HIGH') */
#endif /* SI2151_XOUT_PROP */

        return 0;
}
/************************************************************************************************************************
NAME: si2151_SetupTunerDefaults
DESCRIPTION: Setup si2151 Tuner startup configuration
This is a list of all the Tuner configuration properties.   Depending on your application, only a subset may be required.
The properties are stored in the global property structure 'prop'.  The function TunerConfig(..) must be called
after any of these properties are modified.
Parameter:  none
Returns:    0 if successful
Programming Guide Reference:    Flowchart A.6a (Tuner setup flowchart)
 ************************************************************************************************************************/
static int si2151_setuptunerdefaults(si2151_propobj_t *prop)
{


#ifdef    SI2151_TUNER_BLOCKED_VCO_PROP
  prop->tuner_blocked_vco.vco_code           = 0x8000; /* (default 0x8000) */
#endif /* SI2151_TUNER_BLOCKED_VCO_PROP */

#ifdef    SI2151_TUNER_IEN_PROP
  prop->tuner_ien.tcien                      = SI2151_TUNER_IEN_PROP_TCIEN_ENABLE     ; /* (default 'ENABLE') */
  prop->tuner_ien.rssilien                   = SI2151_TUNER_IEN_PROP_RSSILIEN_ENABLE ; /* (default 'DISABLE') */
  prop->tuner_ien.rssihien                   = SI2151_TUNER_IEN_PROP_RSSIHIEN_DISABLE ; /* (default 'DISABLE') */
#endif /* SI2151_TUNER_IEN_PROP */

#ifdef    SI2151_TUNER_INT_SENSE_PROP
  prop->tuner_int_sense.tcnegen              = SI2151_TUNER_INT_SENSE_PROP_TCNEGEN_DISABLE    ; /* (default 'DISABLE') */
  prop->tuner_int_sense.rssilnegen           = SI2151_TUNER_INT_SENSE_PROP_RSSILNEGEN_DISABLE ; /* (default 'DISABLE') */
  prop->tuner_int_sense.rssihnegen           = SI2151_TUNER_INT_SENSE_PROP_RSSIHNEGEN_DISABLE ; /* (default 'DISABLE') */
  prop->tuner_int_sense.tcposen              = SI2151_TUNER_INT_SENSE_PROP_TCPOSEN_ENABLE     ; /* (default 'ENABLE') */
  prop->tuner_int_sense.rssilposen           = SI2151_TUNER_INT_SENSE_PROP_RSSILPOSEN_ENABLE  ; /* (default 'ENABLE') */
  prop->tuner_int_sense.rssihposen           = SI2151_TUNER_INT_SENSE_PROP_RSSIHPOSEN_ENABLE  ; /* (default 'ENABLE') */
#endif /* SI2151_TUNER_INT_SENSE_PROP */

#ifdef    SI2151_TUNER_LO_INJECTION_PROP
  prop->tuner_lo_injection.band_1            = SI2151_TUNER_LO_INJECTION_PROP_BAND_1_HIGH_SIDE ; /* (default 'HIGH_SIDE') */
  prop->tuner_lo_injection.band_2            = SI2151_TUNER_LO_INJECTION_PROP_BAND_2_LOW_SIDE  ; /* (default 'LOW_SIDE') */
  prop->tuner_lo_injection.band_3            = SI2151_TUNER_LO_INJECTION_PROP_BAND_3_LOW_SIDE  ; /* (default 'LOW_SIDE') */
#endif /* SI2151_TUNER_LO_INJECTION_PROP */

#ifdef    Si2151_TUNER_BLOCKED_VCO2_PROP
  prop->tuner_blocked_vco2.vco_code               = 0x8000; /* (default 0x8000) */
#endif /* Si2151_TUNER_BLOCKED_VCO2_PROP */

#ifdef    Si2151_TUNER_BLOCKED_VCO3_PROP
  prop->tuner_blocked_vco3.vco_code               = 0x8000; /* (default 0x8000) */

#endif /* Si2151_TUNER_BLOCKED_VCO3_PROP */
#ifdef    Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP
  prop->tuner_return_loss_optimize.thld                 =     0; /* (default     0) */
  prop->tuner_return_loss_optimize.config               = Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP_CONFIG_DISABLE              ; /* (default 'DISABLE') */
  prop->tuner_return_loss_optimize.engagement_delay     =     7; /* (default     7) */
  prop->tuner_return_loss_optimize.disengagement_delay  =    10; /* (default    10) */
#endif /* Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP */

#ifdef    Si2151_TUNER_RETURN_LOSS_OPTIMIZE_2_PROP
  prop->tuner_return_loss_optimize_2.thld               =    31; /* (default    31) */
  prop->tuner_return_loss_optimize_2.window             =     0; /* (default     0) */
  prop->tuner_return_loss_optimize_2.engagement_delay   =    15; /* (default    15) */
#endif /* Si2151_TUNER_RETURN_LOSS_OPTIMIZE_2_PROP */

#ifdef    Si2151_TUNER_TF1_BOUNDARY_OFFSET_PROP
  prop->tuner_tf1_boundary_offset.tf1_boundary_offset   =     0; /* (default     0) */
#endif /* Si2151_TUNER_TF1_BOUNDARY_OFFSET_PROP */


#ifdef    SI2151_TUNER_RETURN_LOSS_PROP
  prop->tuner_return_loss.config             = si2151_loss_prop;//SI2151_TUNER_RETURN_LOSS_PROP_CONFIG_127         ; /* (default '127') */
  prop->tuner_return_loss.mode               = SI2151_TUNER_RETURN_LOSS_PROP_MODE_TERRESTRIAL   ; /* (default 'TERRESTRIAL') */
#endif /* SI2151_TUNER_RETURN_LOSS_PROP */

        return 0;
}

int si2151_atvconfig(struct i2c_client *si2151, si2151_propobj_t *prop, si2151_cmdreplyobj_t *rsp)
{
    /* Set the ATV_AFC_RANGE property */
    //prop.atv_afc_range.range_khz
    if (si2151_sendproperty(si2151, SI2151_ATV_AFC_RANGE_PROP, prop, rsp) != 0)
    {
         return ERROR_SI2151_SENDING_COMMAND;
    }

    /* Set the ATV_RF_TOP property */
    //prop.atv_rf_top.atv_rf_top
    if (si2151_sendproperty(si2151, SI2151_ATV_RF_TOP_PROP, prop, rsp) != 0)
    {
         return ERROR_SI2151_SENDING_COMMAND;
    }

    /* Set the ATV_VSNR_CAP property */
    //prop.atv_vsnr_cap.atv_vsnr_cap
    if (si2151_sendproperty(si2151, SI2151_ATV_VSNR_CAP_PROP, prop, rsp) != 0)
    {
         return ERROR_SI2151_SENDING_COMMAND;
    }

    /*Set the ATV_RSSI_RSQ_THRESHOLD property */
    //prop.atv_rsq_rssi_threshold.hi,
    //prop.atv_rsq_rssi_threshold.lo
    if (si2151_sendproperty(si2151, SI2151_ATV_RSQ_RSSI_THRESHOLD_PROP, prop, rsp) != 0)
    {
         return ERROR_SI2151_SENDING_COMMAND;
    }
    /* Set the ATV_AGC_SPEED property */
    //prop.atv_agc_speed.if_agc_speed
    if (si2151_sendproperty(si2151, SI2151_ATV_AGC_SPEED_PROP, prop, rsp) != 0)
    {
         return ERROR_SI2151_SENDING_COMMAND;
    }
    /*Set the ATV_INT_SENSE property */
    //prop.atv_int_sense.chlnegen,
    //prop.atv_int_sense.chlposen,
    //prop.atv_int_sense.dlnegen,
    //prop.atv_int_sense.dlposen,
    //prop.atv_int_sense.pclnegen,
    //prop.atv_int_sense.pclposen,
    //prop.atv_int_sense.snrhnegen,
    //prop.atv_int_sense.snrhposen,
    //prop.atv_int_sense.snrlnegen,
    //prop.atv_int_sense.snrlposen
     if (si2151_sendproperty(si2151, SI2151_ATV_INT_SENSE_PROP, prop, rsp) != 0)
     {
             return ERROR_SI2151_SENDING_COMMAND;
     }
     /* setup ATV_IEN_PROP  IEN properties to enable ATVINT on CHL  */

     /* prop.atv_ien.chlien,
     prop.atv_ien.pclien,
     prop.atv_ien.dlien ,
     prop.atv_ien.snrlien,
     prop.atv_ien.snrhien */
     if (si2151_sendproperty(si2151, SI2151_ATV_IEN_PROP, prop, rsp) != 0)
     {
         return ERROR_SI2151_SENDING_COMMAND;
     }
     /* Set the ATV_VIDEO_MODE property */
      /*prop.atv_video_mode.video_sys,
          prop.atv_video_mode.trans,
          prop.atv_video_mode.color  */
      if (si2151_sendproperty(si2151, SI2151_ATV_VIDEO_MODE_PROP, prop, rsp) != 0)
      {
          return ERROR_SI2151_SENDING_COMMAND;
      }

     // Property 0x0603. ATV_CONFIG_IF_PORT//zhuangwei ENABLE ALIFAGC
      //if(si2151_set_property(index, 0,SI2151_ATV_CONFIG_IF_PORT_PROP,0x000a, rsp)!=0)
	  if(si2151_set_property(si2151, 0,SI2151_ATV_CONFIG_IF_PORT_PROP,0x208, rsp)!=0)
    	  {
    	  return ERROR_SI2151_SENDING_COMMAND;
    	  }
      //ATV_LIF_FREQ
      if(si2151_set_property(si2151, 0,Si2151_ATV_LIF_FREQ_PROP,0x1770, rsp)!=0)
	  //if(si2151_set_property(index, 0,Si2151_ATV_LIF_FREQ_PROP,0x1388, rsp)!=0)
    	  {
    	  return ERROR_SI2151_SENDING_COMMAND;
    	  }
      //ATV_LIF_OUT
      //if(si2151_set_property(index, 0,Si2151_ATV_LIF_OUT_PROP,0xff94, rsp)!=0)
	  if(si2151_set_property(si2151, 0,Si2151_ATV_LIF_OUT_PROP,0x6494, rsp)!=0)
	  //if(si2151_set_property(index, 0,Si2151_ATV_LIF_OUT_PROP,0x3494, rsp)!=0)
    	  {
			printk("config tuner  alif error.\n");
    	  return ERROR_SI2151_SENDING_COMMAND;
    	  }
	  printk("config tuner alif .\n");
      //atv_ext_agc//zhuangwei
      //if(si2151_set_property(index, 0,Si2151_ATV_EXT_AGC_PROP,0x1388, rsp)!=0)
	  if(si2151_set_property(si2151, 0,Si2151_ATV_EXT_AGC_PROP,0xd700, rsp)!=0)
         	  {
         	  return ERROR_SI2151_SENDING_COMMAND;
         	  }
	  printk("enalbe tuner ALIF AGC\n");
	  // Property 0x0603. ATV_CONFIG_IF_PORT//zhuangwei
	  if(si2151_set_property(si2151, 0,SI2151_ATV_CONFIG_IF_PORT_PROP,0x0008, rsp)!=0)
		    {
		    return ERROR_SI2151_SENDING_COMMAND;
		    }

     // ATV_LIF_FREQ
      if(si2151_set_property(si2151, 0,Si2151_ATV_LIF_FREQ_PROP,0x1770, rsp)!=0)
	      	  {
    	  return ERROR_SI2151_SENDING_COMMAND;
    	  }
      //ATV_LIF_OUT
      if(si2151_set_property(si2151, 0,Si2151_ATV_LIF_OUT_PROP,0xa094, rsp)!=0)
	  //if(si2151_set_property(index, 0,Si2151_ATV_LIF_OUT_PROP,0xc094, rsp)!=0)
	  //if(si2151_set_property(index, 0,Si2151_ATV_LIF_OUT_PROP,0x6494, rsp)!=0)
	      	  {
			printk("config tuner  alif error.\n");
    	  return ERROR_SI2151_SENDING_COMMAND;
    	  }
	  printk("config tuner alif .\n");
      //atv_ext_agc//zhuangwei
      if(si2151_set_property(si2151, 0,Si2151_ATV_EXT_AGC_PROP,0x1388, rsp)!=0)
	           	  {
         	  return ERROR_SI2151_SENDING_COMMAND;
         	  }

    return 0;
}

/************************************************************************************************************************
NAME: si2151_CommonConfig
DESCRIPTION: Setup si2151 Common properties configuration
This function will download all the DTV configuration properties stored in the global structure 'prop.
Depending on your application, only a subset may be required to be modified.
The function si2151_SetupCommonDefaults() should be called before the first call to this function. Afterwards
to change a property change the appropriate element in the property structure 'prop' and call this routine.
Use the comments above the si2151_sendproperty calls as a guide to the parameters which are changed.
Parameter:  Pointer to si2151 Context (I2C address)
Returns:    I2C transaction error code, 0 if successful
Programming Guide Reference:    Flowchart A.6a (Common setup flowchart)
 ************************************************************************************************************************/
int si2151_commonconfig(struct i2c_client *si2151, si2151_propobj_t *prop, si2151_cmdreplyobj_t *rsp)
{

        /* Setting si2151_MASTER_IEN_PROP property */
        /***
          prop.master_ien.atvien,
          prop.master_ien.ctsien,
          prop.master_ien.dtvien,
          prop.master_ien.errien,
          prop.master_ien.tunien  */

        if (si2151_sendproperty(si2151, SI2151_MASTER_IEN_PROP, prop, rsp) != 0)
        {
                return ERROR_SI2151_SENDING_COMMAND;
        }

        /* Setting si2151_CRYSTAL_TRIM_PROP */
        //rop.crystal_trim.xo_cap
        if (si2151_sendproperty(si2151, SI2151_CRYSTAL_TRIM_PROP, prop, rsp) != 0)
        {
                return ERROR_SI2151_SENDING_COMMAND;
        }
#ifdef    SI2151_XOUT_PROP
  		//if (si2151_sendproperty(si2151, SI2151_XOUT_PROP, prop, rsp) != NO_SI2151_ERROR) {return ERROR_SI2151_SENDING_COMMAND;}
#endif /* SI2151_XOUT_PROP */

        return 0;
}
/************************************************************************************************************************
NAME: si2151_TunerConfig
DESCRIPTION: Setup si2151 Tuner (RF to IF analog path) properties configuration
This function will download all the DTV configuration properties stored in the global structure 'prop.
Depending on your application, only a subset may be required to be modified.
The function si2151_SetupTunerDefaults() should be called before the first call to this function. Afterwards
to change a property change the appropriate element in the property structure 'prop' and call this routine.
Use the comments above the si2151_sendproperty calls as a guide to the parameters which are changed.
Parameter:  Pointer to si2151 Context (I2C address)
Returns:    I2C transaction error code, 0 if successful
Programming Guide Reference:    Flowchart A.6a (Tuner setup flowchart)
 ************************************************************************************************************************/
int si2151_tunerconfig(struct i2c_client *si2151, si2151_propobj_t *prop, si2151_cmdreplyobj_t *rsp)
{

#ifdef    SI2151_TUNER_BLOCKED_VCO_PROP
		  if (si2151_sendproperty(si2151, SI2151_TUNER_BLOCKED_VCO_PROP, prop, rsp) != NO_SI2151_ERROR) {return ERROR_SI2151_SENDING_COMMAND;}
#endif /* SI2151_TUNER_BLOCKED_VCO_PROP */
#ifdef    SI2151_TUNER_IEN_PROP
		  if (si2151_sendproperty(si2151, SI2151_TUNER_IEN_PROP, prop, rsp) != NO_SI2151_ERROR) {return ERROR_SI2151_SENDING_COMMAND;}
#endif /* SI2151_TUNER_IEN_PROP */
#ifdef    SI2151_TUNER_INT_SENSE_PROP
		  if (si2151_sendproperty(si2151, SI2151_TUNER_INT_SENSE_PROP, prop, rsp) != NO_SI2151_ERROR) {return ERROR_SI2151_SENDING_COMMAND;}
#endif /* SI2151_TUNER_INT_SENSE_PROP */
#ifdef    SI2151_TUNER_LO_INJECTION_PROP
		  if (si2151_sendproperty(si2151, SI2151_TUNER_LO_INJECTION_PROP, prop, rsp) != NO_SI2151_ERROR) {return ERROR_SI2151_SENDING_COMMAND;}
#endif /* SI2151_TUNER_LO_INJECTION_PROP */
#ifdef    SI2151_TUNER_RETURN_LOSS_PROP
		  if (si2151_sendproperty(si2151, SI2151_TUNER_RETURN_LOSS_PROP, prop, rsp) != NO_SI2151_ERROR) {return ERROR_SI2151_SENDING_COMMAND;}
#endif /* SI2151_TUNER_RETURN_LOSS_PROP */

#ifdef    Si2151_TUNER_BLOCKED_VCO2_PROP
  if (si2151_sendproperty(si2151, Si2151_TUNER_BLOCKED_VCO2_PROP, prop, rsp) != NO_SI2151_ERROR) {return ERROR_SI2151_SENDING_COMMAND;}
#endif /* Si2151_TUNER_BLOCKED_VCO2_PROP */
#ifdef    Si2151_TUNER_BLOCKED_VCO3_PROP
  if (si2151_sendproperty(si2151, Si2151_TUNER_BLOCKED_VCO3_PROP , prop, rsp) != NO_SI2151_ERROR) {return ERROR_SI2151_SENDING_COMMAND;}
#endif /* Si2151_TUNER_BLOCKED_VCO3_PROP */
#ifdef    Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP
  if (si2151_sendproperty(si2151, Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP, prop, rsp) != NO_SI2151_ERROR) {return ERROR_SI2151_SENDING_COMMAND;}
#endif /* Si2151_TUNER_RETURN_LOSS_OPTIMIZE_PROP */

#ifdef    Si2151_TUNER_RETURN_LOSS_OPTIMIZE_2_PROP
  if (si2151_sendproperty(si2151, Si2151_TUNER_RETURN_LOSS_OPTIMIZE_2_PROP, prop, rsp) != NO_SI2151_ERROR) {return ERROR_SI2151_SENDING_COMMAND;}
#endif /* Si2151_TUNER_RETURN_LOSS_OPTIMIZE_2_PROP */
#ifdef    Si2151_TUNER_TF1_BOUNDARY_OFFSET_PROP
  if (si2151_sendproperty(si2151, Si2151_TUNER_TF1_BOUNDARY_OFFSET_PROP , prop, rsp ) != NO_SI2151_ERROR) {return ERROR_SI2151_SENDING_COMMAND;}
#endif /* Si2151_TUNER_TF1_BOUNDARY_OFFSET_PROP */


        return 0;
}
/************************************************************************************************************************
NAME: Si2170_SetupDTVDefaults
DESCRIPTION: Setup Si2170 DTV startup configuration
This is a list of all the DTV configuration properties.   Depending on your application, only a subset may be required.
The properties are stored in the global property structure 'prop'.  The function DTVConfig(..) must be called
after any properties are modified.
Parameter:  none
Returns:    0 if successful
Programming Guide Reference:    Flowchart A.6 (DTV setup flowchart)

 ************************************************************************************************************************/
static int si2151_setupdtvdefaults(si2151_propobj_t *prop, int ch_mode)
{
    
    prop->dtv_config_if_port.dtv_out_type   = SI2151_DTV_CONFIG_IF_PORT_PROP_DTV_OUT_TYPE_LIF_IF1;
    prop->dtv_config_if_port.dtv_agc_source = SI2151_DTV_CONFIG_IF_PORT_PROP_DTV_AGC_SOURCE_INTERNAL;
    prop->dtv_lif_freq.offset = 5000;
    prop->dtv_mode.bw = SI2151_DTV_MODE_PROP_BW_BW_8MHZ;
    prop->dtv_mode.invert_spectrum = SI2151_DTV_MODE_PROP_INVERT_SPECTRUM_NORMAL;
    //set in the get tuner ops
    prop->dtv_mode.modulation = SI2151_DTV_MODE_PROP_MODULATION_DTMB;
    prop->dtv_rsq_rssi_threshold.hi = 0;
    prop->dtv_rsq_rssi_threshold.lo = -80;
    prop->dtv_ext_agc.max_10mv = 250;
    prop->dtv_ext_agc.min_10mv = 50;
    if (ch_mode == 4) prop->dtv_lif_out.amp = 25; //22;//27;//23;
    else prop->dtv_lif_out.amp = 25; //27;

    prop->dtv_lif_out.offset = 148;
    prop->dtv_agc_speed.agc_decim = SI2151_DTV_AGC_SPEED_PROP_AGC_DECIM_OFF;
    prop->dtv_agc_speed.if_agc_speed = SI2151_DTV_AGC_SPEED_PROP_IF_AGC_SPEED_AUTO;
    prop->dtv_rf_top.dtv_rf_top = SI2151_DTV_RF_TOP_PROP_DTV_RF_TOP_AUTO;
    prop->dtv_int_sense.chlnegen = SI2151_DTV_INT_SENSE_PROP_CHLNEGEN_DISABLE;
    prop->dtv_int_sense.chlposen = SI2151_DTV_INT_SENSE_PROP_CHLPOSEN_ENABLE;
    prop->dtv_ien.chlien  = SI2151_DTV_IEN_PROP_CHLIEN_ENABLE;      /* enable only CHL to drive DTVINT */
    prop->dtv_agc_auto_freeze.thld = SI2151_DTV_AGC_AUTO_FREEZE_PROP_THLD_DEFAULT;
    prop->dtv_agc_auto_freeze.timeout = SI2151_DTV_AGC_AUTO_FREEZE_PROP_TIMEOUT_DEFAULT;
    printk("%s ....\n", __func__);
    return 0;
}
/************************************************************************************************************************
NAME: Si2170_DTVConfig
DESCRIPTION: Setup Si2170 DTV properties configuration
This function will download all the DTV configuration properties stored in the global structure 'prop.
Depending on your application, only a subset may be required to be modified.
The function Si2170_SetupDTVDefaults() should be called before the first call to this function. Afterwards
to change a property change the appropriate element in the property structure 'prop' and call this routine.
Use the comments above the Si2170_L1_SetProperty2 calls as a guide to the parameters which are changed.
Parameter:  Pointer to Si2170 Context (I2C address)
Returns:    I2C transaction error code, 0 if successful
Programming Guide Reference:    Flowchart A.6 (DTV setup flowchart)
 ************************************************************************************************************************/
int si2151_dtvconfig(struct i2c_client *si2151, si2151_propobj_t *prop, si2151_cmdreplyobj_t *rsp)
{
        /* Setting DTV_CONFIG_IF_PORT_PROP property */
        /*	prop.dtv_config_if_port.dtv_out_type,
                prop.dtv_config_if_port.dtv_agc_source */
        if (si2151_sendproperty(si2151, SI2151_DTV_CONFIG_IF_PORT_PROP, prop, rsp) != 0)
        {
                return ERROR_SI2151_SENDING_COMMAND;
        }

        /* Setting DTV_LIF_FREQ_PROP */
        //	prop.dtv_lif_freq.offset
        if (si2151_sendproperty(si2151, SI2151_DTV_LIF_FREQ_PROP, prop, rsp) != 0)
        {
                return ERROR_SI2151_SENDING_COMMAND;
        }

        /* Setting DTV_MODE_PROP property */
        /*	prop.dtv_mode.bw,
                prop.dtv_mode.invert_spectrum,
                prop.dtv_mode.modulation*/
        if (si2151_sendproperty(si2151, SI2151_DTV_MODE_PROP, prop, rsp) != 0)
        {
                return ERROR_SI2151_SENDING_COMMAND;
        }

        /* Setting DTV_RSQ_RSSI_THRESHOLD property */
        //	prop.dtv_rsq_rssi_threshold.hi,
        //	prop.dtv_rsq_rssi_threshold.lo
        if (si2151_sendproperty(si2151, SI2151_DTV_RSQ_RSSI_THRESHOLD_PROP, prop, rsp) != 0)
        {
                return ERROR_SI2151_SENDING_COMMAND;
        }

        /* Setting DTV_EXT_AGC property */
        //	prop.dtv_ext_agc.max_10mv,
        //	prop.dtv_ext_agc.min_10mv
        if (si2151_sendproperty(si2151, SI2151_DTV_EXT_AGC_PROP, prop, rsp) != 0)
        {
                return ERROR_SI2151_SENDING_COMMAND;
        }

        /* Setting DTV_LIF_OUT property */
        //	prop.dtv_lif_out.amp,
        //	prop.dtv_lif_out.offset
        if (si2151_sendproperty(si2151, SI2151_DTV_LIF_OUT_PROP, prop, rsp) != 0)
        {
                return ERROR_SI2151_SENDING_COMMAND;
        }

        /* Setting DTV_AGC_SPEED property */
        //	prop.dtv_agc_speed.agc_decim,
        //	prop.dtv_agc_speed.if_agc_speed
        if (si2151_sendproperty(si2151, SI2151_DTV_AGC_SPEED_PROP, prop, rsp) != 0)
        {
                return ERROR_SI2151_SENDING_COMMAND;
        }

        /* Setting DTV_RF_TOP property */
        //	prop.dtv_rf_top.dtv_rf_top
        if (si2151_sendproperty(si2151, SI2151_DTV_RF_TOP_PROP, prop, rsp) != 0)
        {
                return ERROR_SI2151_SENDING_COMMAND;
        }

        /* Setting DTV_INT_SENSE property */
        //	prop.dtv_int_sense.chlnegen,
        //	prop.dtv_int_sense.chlposen
        if (si2151_sendproperty(si2151, SI2151_DTV_INT_SENSE_PROP, prop, rsp) != 0)
        {
                return ERROR_SI2151_SENDING_COMMAND;
        }

        /* Set DTV_IEN property */
        /*	prop.dtv_ien.chlien */
        if (si2151_sendproperty(si2151, SI2151_DTV_IEN_PROP, prop, rsp) != 0)
        {
                return ERROR_SI2151_SENDING_COMMAND;
        }

        /* Set DTV_AGC_AUTO_FREEZE property */
        /* prop.dtv_agc_auto_freeze.thld */
        /* prop.dtv_agc_auto_freeze.timeout */
        if (si2151_sendproperty(si2151, SI2151_DTV_AGC_AUTO_FREEZE_PROP, prop, rsp) != 0)
        {
            return ERROR_SI2151_SENDING_COMMAND;
        }

        return 0;
}


/************************************************************************************************************************
NAME: si2151_Tune
DESCRIPTIION: Tune si2151 in specified mode (ATV/DTV) at center frequency, wait for TUNINT and xTVINT with timeout

Parameter:  Pointer to si2151 Context (I2C address)
Parameter:  Mode (ATV or DTV) use si2151_TUNER_TUNE_FREQ_CMD_MODE_ATV or si2151_TUNER_TUNE_FREQ_CMD_MODE_DTV constants
Parameter:  frequency (Hz) as a unsigned long integer
Parameter:  rsp - commandResp structure to returns tune status info.
Returns:    0 if channel found.  A nonzero value means either an error occurred or channel not locked.
Programming Guide Reference:    Flowchart A.7 (Tune flowchart)
 ************************************************************************************************************************/
int si2151_tune(struct i2c_client *si2151, unsigned char mode, unsigned long freq, si2151_cmdreplyobj_t *rsp, si2151_common_reply_struct *common_reply)
{
        int return_code = 0,count = 0;

        if (si2151_tuner_tune_freq(si2151, mode, freq, rsp) != 0)
        {
               // pr_info("%s: tuner tune freq error:%d!!!!\n", __func__, ERROR_SI2151_SENDING_COMMAND);
                return ERROR_SI2151_SENDING_COMMAND;
        }
        mdelay(5);
        for (count=50; count ;count--)
        {
                return_code = si2151_pollforcts(si2151);
                if (!return_code)
                        break;
                mdelay(2);
        }
        if (!count)
        {
                pr_info("%s: poll cts error:%d!!!!\n", __func__, return_code);
                return return_code;
        }
        mdelay(delay_det);
#if 0
        /* wait for TUNINT, timeout is 150ms */
        for (count=75; count ;count--)
        {
                if ((return_code = si2151_check_status(si2151, common_reply)) != 0)
                        return return_code;
                if (common_reply->tunint)
                        break;
                mdelay(2);
        }
        if (!count)
        {
                pr_info("%s: ERROR_SI2151_TUNINT_TIMEOUT error:%d!!!!\n", __func__, ERROR_SI2151_TUNINT_TIMEOUT);
                return ERROR_SI2151_TUNINT_TIMEOUT;
        }
        /* wait for xTVINT, timeout is 350ms for ATVINT and 6 ms for DTVINT */
        count = ((mode==SI2151_TUNER_TUNE_FREQ_CMD_MODE_ATV) ? 300 : 3);
        for (;count ;count--)
        {
                if ((return_code = si2151_check_status(si2151, common_reply)) != 0)
                        return return_code;
                if ((mode==SI2151_TUNER_TUNE_FREQ_CMD_MODE_ATV) ? common_reply->atvint : common_reply->dtvint)
                        break;
                mdelay(2);
        }
        if (!count)
        {
                pr_info("%s: ERROR_SI2151_XTVINT_TIMEOUT error:%d!!!!\n", __func__, ERROR_SI2151_XTVINT_TIMEOUT);
                return ERROR_SI2151_XTVINT_TIMEOUT;
        }
#endif
        return return_code;
}

/************************************************************************************************************************
NAME: si2151_LoadVideofilter
DESCRIPTION:        Load video filters from vidfiltTable in si2151_write_xTV_video_coeffs.h file into si2151
Programming Guide Reference:    Flowchart A.4 (Download Video Filters flowchart)

Parameter:  si2151 Context (I2C address)
Parameter:  pointer to video filter table array
Parameter:  number of lines in video filter table array (size in bytes / BYTES_PER_LINE)
Returns:    si2151/I2C transaction error code, 0 if successful
 ************************************************************************************************************************/
int si2151_loadvideofilter(struct i2c_client *si2151, unsigned char* vidfilttable, int lines, si2151_common_reply_struct *common_reply)
{
#define BYTES_PER_LINE 8
        int line;

        /* for each 8 bytes in VIDFILT_TABLE */
        for (line = 0; line < lines; line++)
        {
                /* send that 8 byte I2C command to si2151 */
                if (si2151_api_patch(si2151, BYTES_PER_LINE, vidfilttable+BYTES_PER_LINE*line, common_reply) != 0)
                {
                        return ERROR_SI2151_SENDING_COMMAND;
                }
        }
        return 0;
}
/************************************************************************************************************************
NAME: si2151_Configure
DESCRIPTION: Setup si2151 video filters, GPIOs/clocks, Common Properties startup, Tuner startup, ATV startup, and DTV startup.
Parameter:  Pointer to si2151 Context (I2C address)
Parameter:  rsp - commandResp structure buffer.
Returns:    I2C transaction error code, 0 if successful
 ************************************************************************************************************************/
int si2151_configure(struct i2c_client *si2151, si2151_propobj_t *prop, si2151_cmdreplyobj_t *rsp, si2151_common_reply_struct *common_reply) {
    int return_code = 0;

    /* load ATV video filter file */
#ifdef USING_ATV_FILTER
    if ((return_code = si2151_loadvideofilter(si2151, dlif_vidfilt_table, DLIF_VIDFILT_LINES, common_reply) != 0)
        return return_code;
#endif
#if 0
        /* Set the GPIO Pins using the CONFIG_PINS command*/
        if (si2151_config_pins(si2151,      /* turn off BCLK1 and XOUT */
                               SI2151_CONFIG_PINS_CMD_GPIO1_MODE_NO_CHANGE,
                               SI2151_CONFIG_PINS_CMD_GPIO1_READ_DO_NOT_READ,
                               SI2151_CONFIG_PINS_CMD_GPIO2_MODE_NO_CHANGE,
                               SI2151_CONFIG_PINS_CMD_GPIO2_READ_DO_NOT_READ,
                               SI2151_CONFIG_PINS_CMD_GPIO3_MODE_NO_CHANGE,
                               SI2151_CONFIG_PINS_CMD_GPIO3_READ_DO_NOT_READ,
                               SI2151_CONFIG_PINS_CMD_BCLK1_MODE_ENABLE,
                               SI2151_CONFIG_PINS_CMD_BCLK1_READ_DO_NOT_READ,
                               SI2151_CONFIG_PINS_CMD_XOUT_MODE_ENABLE,
                               rsp) !=0){
        pr_info("%s: config pins error:%d!!!!\n", __func__, ERROR_SI2151_SENDING_COMMAND);
        return ERROR_SI2151_SENDING_COMMAND;
    }
#endif
#if  1
        /* Set Common Properties startup configuration */
        si2151_setupcommondefaults(prop);
        if ((return_code = si2151_commonconfig(si2151, prop, rsp)) != 0) {
        pr_info("%s: setup command defaults error:%d!!!!\n", __func__, return_code);
        return return_code;
    }

        /* Set Tuner Properties startup configuration */
        si2151_setuptunerdefaults(prop);
        if ((return_code = si2151_tunerconfig(si2151, prop, rsp)) != 0) {
        pr_info("%s: setup tuner defaults error:%d!!!!\n", __func__, return_code);
        return return_code;
    }
        /* Set ATV startup configuration */
        si2157_setupatvdefaults(prop);
        if ((return_code = si2151_atvconfig(si2151, prop, rsp)) != 0) {
        printk("  setup atv defaults error:%d!!!!\n", return_code);
        return return_code;
    }
        if (si2151_devp->parm.mode != SI2151_TUNER_TUNE_FREQ_CMD_MODE_ATV) {
        /* Set DTV startup configuration */
        si2151_setupdtvdefaults(prop, 4);
        if ((return_code = si2151_dtvconfig(si2151, prop, rsp)) != 0) {
            pr_info("%s: setup dtv defaults error:%d!!!!\n", __func__, return_code);
            return return_code;
        }
    }
#endif

    return return_code;
}
/************************************************************************************************************************
NAME: si2151_LoadFirmware
DESCRIPTON: Load firmware from FIRMWARE_TABLE array in si2151_Firmware_x_y_build_z.h file into si2151
Requires si2151 to be in bootloader mode after PowerUp
Programming Guide Reference:    Flowchart A.3 (Download FW PATCH flowchart)

Parameter:  si2151 Context (I2C address)
Parameter:  pointer to firmware table array
Parameter:  number of lines in firmware table array (size in bytes / BYTES_PER_LINE)
Returns:    si2151/I2C transaction error code, 0 if successful
 ************************************************************************************************************************/


int si2151_loadfirmware(struct i2c_client *si2151, struct firmware_struct * firmwaretable, int lines, si2151_common_reply_struct *common_reply)
{
        int return_code = 0;
        int line;


        for (line = 0; line < lines; line++)
        {

                if (si2151_api_patch(si2151, firmwaretable[line].firmware_len, firmwaretable[line].firmware_table, common_reply) != 0){
                        return ERROR_SI2151_LOADING_FIRMWARE;
                }

        }
        return return_code;
}


/************************************************************************************************************************
NAME: si2151_StartFirmware
DESCRIPTION: Start si2151 firmware (put the si2151 into run mode)
Parameter:   si2151 Context (I2C address)
Parameter (passed by Reference): 	ExitBootloadeer Response Status byte : tunint, atvint, dtvint, err, cts
Returns:     I2C transaction error code, 0 if successful
 ************************************************************************************************************************/
int si2151_startfirmware(struct i2c_client *si2151, si2151_cmdreplyobj_t *rsp)
{

        if (si2151_exit_bootloader(si2151, SI2151_EXIT_BOOTLOADER_CMD_FUNC_TUNER, SI2151_EXIT_BOOTLOADER_CMD_CTSIEN_OFF, rsp) != 0)
        {
                return ERROR_SI2151_STARTING_FIRMWARE;
        }

        return 0;
}
/************************************************************************************************************************
NAME: si2151_PowerUpWithPatch
DESCRIPTION: Send si2151 API PowerUp Command with PowerUp to bootloader,
Check the Chip rev and part, and ROMID are compared to expected values.
Load the Firmware Patch then Start the Firmware.
Programming Guide Reference:    Flowchart A.2a (POWER_UP with patch flowchart)

Parameter:  si2151 Context (I2C address)
Returns:    si2151/I2C transaction error code, 0 if successful
 ************************************************************************************************************************/
int si2151_powerupwithpatch(struct i2c_client *si2151, si2151_cmdreplyobj_t *rsp, si2151_common_reply_struct *common_reply)
{
        int return_code = 0, num = 0;

		do{
		            if ((return_code = Si2151_RESET_HW(si2151,
		                                                  Si2151_RESET_HW_CMD_SUBCODE_CODE,
		                                                  Si2151_RESET_HW_CMD_RESERVED1_RESERVED,
		                                                  Si2151_RESET_HW_CMD_RESERVED2_RESERVED,
		                                                  rsp)) != NO_SI2151_ERROR)
		            {
		                printk ("Si2151_RESET_HW error 0x%02x: %s\n", return_code, Si2151_L1_API_ERROR_TEXT(return_code) );
		                return return_code;
		            }

		        return_code = Si2151_POWER_UP(si2151,          /* always wait for CTS prior to POWER_UP command */
		                       	SI2151_POWER_UP_CMD_SUBCODE_CODE,
								SI2151_SHARE_XTAL,
		                       	SI2151_POWER_UP_CMD_EN_XOUT_DIS_XOUT,
								SI2151_POWER_UP_CMD_CONFIG_1P8V_INTERNAL_REG,
								SI2151_POWER_UP_CMD_RESERVED3_RESERVED,
								SI2151_POWER_UP_CMD_RESERVED4_RESERVED,
								SI2151_POWER_UP_CMD_RESERVED5_RESERVED,
								SI2151_POWER_UP_CMD_RESERVED6_RESERVED,
								SI2151_POWER_UP_CMD_RESERVED7_RESERVED,
								SI2151_POWER_UP_CMD_RESERVED8_RESERVED,
								rsp);
		        if (return_code)
		                pr_info("%s: si2151_power_up error:%d!!!\n", __func__, return_code);

		} while (Si2151_GetStatus(si2151) == 0xFE);
		
        if ((return_code = Si2151_L1_WAKE_UP (si2151,
                                Si2151_WAKE_UP_CMD_SUBCODE_CODE,
                                Si2151_WAKE_UP_CMD_RESET_RESET,
                                Si2151_WAKE_UP_CMD_CLOCK_FREQ_CLK_24MHZ,
                                Si2151_WAKE_UP_CMD_RESERVED9_RESERVED,
                                Si2151_WAKE_UP_CMD_FUNC_BOOTLOADER,
                                Si2151_WAKE_UP_CMD_WAKE_UP_WAKE_UP,
                                rsp)) != NO_SI2151_ERROR)
        {
            printk ("Si2151_L1_WAKE_UP error 0x%02x: %s\n", return_code, Si2151_L1_API_ERROR_TEXT(return_code) );
            return return_code;
        }

        mdelay(25);
/* Get the Part Info from the chip.   This command is only valid in Bootloader mode */

		if ((return_code = si2151_part_info(si2151,rsp))) {
			pr_info ("SI2151__PART_INFO error %x, %s\n", return_code, __func__ );
			return return_code;
		}
		pr_info("chiprev %d\n", 	   rsp->part_info.chiprev);
		pr_info("part	 SI21%d\n",    rsp->part_info.part   );
		pr_info("pmajor  %d\n", 	   rsp->part_info.pmajor );
		if (rsp->part_info.pmajor >= 0x30) {
		pr_info("pmajor '%c'\n",	   rsp->part_info.pmajor );
		}
		pr_info("pminor  %d\n", 	   rsp->part_info.pminor );
		if (rsp->part_info.pminor >= 0x30) {
		pr_info("pminor '%c'\n",	   rsp->part_info.pminor );
		}
		pr_info("pbuild %d\n",		   rsp->part_info.pbuild );
		pr_info("romid %3d/0x%02x\n",  rsp->part_info.romid,  rsp->part_info.romid );

     /* Load the Firmware */
    //for version 2177_30_b_5
         /* Check part info values and load the proper firmware */
          if (rsp->part_info.romid == 0x61)
          {
		    		printk("si2151 load firmware firmwaretable_Si2151_FW_1_1b6.\n");
					num = (sizeof(Si2151_FW_1_1b11)/(sizeof(firmware_struct)));
					return_code = si2151_loadfirmware(si2151,Si2151_FW_1_1b11,num,common_reply);
          }

          else if (rsp->part_info.romid == 0x60)
          {
					/* Only load the Firmware if we are NOT a SI2151-A30 part*/

		    		printk("si2151 load firmware firmwaretable_SI2151_FW_3_0b5.\n");
					num = (sizeof(SI2151_FW_3_0b5)/(sizeof(firmware_struct)));
					return_code = si2151_loadfirmware(si2151,SI2151_FW_3_0b5,num,common_reply);

          }
          else
          {
              printk ("INCOMPATIBLE PART error ROMID 0x%02x\n", rsp->part_info.romid);
              return return_code;
          }


	if (return_code != 0){
        pr_info("%s: si2151_loadfirmware error:%d!!!\n", __func__, return_code);
        return return_code;
    }

        /*Start the Firmware */
    	if ((return_code = si2151_startfirmware(si2151, rsp)) != 0) /* Start firmware */
        {
                pr_info("%s: si2151_startfirmware error:%d!!!\n", __func__, return_code);
                return return_code;
        }
        mdelay(50);
        if (si2151_get_rev(si2151, rsp) != 0)
        {
                pr_info("%s: si2151_get_rev error:%d!!!\n", __func__, ERROR_SI2151_SENDING_COMMAND);
                return ERROR_SI2151_SENDING_COMMAND;
        }
        else
        {
                pr_dbg("%s: rsp.get_rev.pn :      %d \n", __func__, rsp->get_rev.pn);
                pr_dbg("%s: rsp.get_rev.fwmajor : %d \n", __func__, rsp->get_rev.fwmajor);
                pr_dbg("%s: rsp.get_rev.fwminor : %d \n", __func__, rsp->get_rev.fwminor);
                pr_dbg("%s: rsp.get_rev.patch :   %d \n", __func__, rsp->get_rev.patch);
                pr_dbg("%s: rsp.get_rev.cmpmajor :%d \n", __func__, rsp->get_rev.cmpmajor);
                pr_dbg("%s: rsp.get_rev.cmpminor :%d \n", __func__, rsp->get_rev.cmpminor);
                pr_dbg("%s: rsp.get_rev.cmpbuild :%d \n", __func__, rsp->get_rev.cmpbuild);
                pr_dbg("%s: rsp.get_rev.chiprev : %d \n", __func__, (u32)rsp->get_rev.chiprev);
        }

        return return_code;
}

int si2151_get_FWVersion(struct i2c_client *si2151, si2151_cmdreplyobj_t *rsp)
{
	int return_code = si2151_get_rev(si2151, rsp);
	if (return_code != 0) {
		pr_info("%s: si2151_get_rev error:%d!!!\n", __func__, ERROR_SI2151_SENDING_COMMAND);
		return ERROR_SI2151_SENDING_COMMAND;
	} else {
		pr_dbg("%s: rsp.get_rev.pn :      %d \n", __func__, rsp->get_rev.pn);
		pr_dbg("%s: rsp.get_rev.fwmajor : %d \n", __func__, rsp->get_rev.fwmajor);
		pr_dbg("%s: rsp.get_rev.fwminor : %d \n", __func__, rsp->get_rev.fwminor);
		pr_dbg("%s: rsp.get_rev.patch :   %d \n", __func__, rsp->get_rev.patch);
		pr_dbg("%s: rsp.get_rev.cmpmajor :%d \n", __func__, rsp->get_rev.cmpmajor);
		pr_dbg("%s: rsp.get_rev.cmpminor :%d \n", __func__, rsp->get_rev.cmpminor);
		pr_dbg("%s: rsp.get_rev.cmpbuild :%d \n", __func__, rsp->get_rev.cmpbuild);
		pr_dbg("%s: rsp.get_rev.chiprev : %d \n", __func__, (u32)rsp->get_rev.chiprev);
	}
	return return_code;
}

/************************************************************************************************************************
NAME: si2151_Init
DESCRIPTION:Reset and Initialize si2151
Parameter:  si2151 Context (I2C address)
Returns:    I2C transaction error code, 0 if successful
 ************************************************************************************************************************/
int si2151_init(struct i2c_client *si2151, si2151_cmdreplyobj_t *rsp, si2151_common_reply_struct *common_reply)
{
	int return_code = 0;
	/* Reset si2151 */
	/* TODO: SendRSTb requires porting to toggle the RSTb line low -> high */
	//sendrstb();

	return_code = si2151_powerupwithpatch(si2151, rsp, common_reply);
	if (return_code)		/* PowerUp into bootloader */
	{
		pr_info("%s: init si2151 error!!!\n", __func__);
	}

	return_code = si2151_get_FWVersion(si2151, rsp);
	if (return_code == NO_SI2151_ERROR) {
		pr_err("%s get FW version ok, si2151 ignore load fireware\n", __func__);
		return return_code;
	}

	/* At this point, FW is loaded and started.  Return 0*/
	return return_code;
}


