/******************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the Qt Virtual Keyboard module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
******************************************************************************/

import QtQuick 2.0
import QtQuick.Layouts 1.0
import QtQuick.VirtualKeyboard 2.1

KeyboardLayoutLoader {
    sourceComponent: (( InputContext.inputMethodHints & Qt.ImhNoAutoUppercase )) ? page2:page1;
    Component {
        id: page1
        KeyboardLayout {
            inputMode: InputEngine.Latin
            keyWeight: 152
            spacing: 0
            KeyboardRow {
                Layout.minimumHeight: 71
                Key {
                    key: Qt.Key_NumberSign
                    text: "#"
                }
                Key {
                    key: Qt.Key_Plus
                    text: "+"
                }
                Key {
                    key: Qt.Key_Equal
                    text: "="
                }
                Key {
                    key:  Qt.Key_Percent
                    text: "%"
                }
                Key {
                    key: Qt.Key_AsciiTilde
                    text: "~"
                }
                Key {
                    key: Qt.Key_Period
                    text: "."
                }
                Key {
                    key: Qt.Key_Asterisk
                    text: "*"
                }

                Key {
                    key: Qt.Key_AsciiCircum
                    text: "^"
                }
                Key {
                    key: Qt.Key_Less
                    text: "<"
                }
                Key {
                    key: Qt.Key_Greater
                    text: ">"
                }

                FillerKey {
                    weight: 32
                }
                Key {
                    key: Qt.Key_1
                    text: "1"
                }
                Key {
                    key: Qt.Key_2
                    text: "2"
                }
                Key {
                    key: Qt.Key_3
                    text: "3"
                }
                Key {
                    key: Qt.Key_4
                    text: "4"
                }
                Key {
                    key: Qt.Key_5
                    text: "5"
                }
            }
            KeyboardRow {
                Layout.minimumHeight: 71
                Key {
                    key: Qt.Key_BracketLeft
                    text: "["
                }
                Key {
                    key: Qt.Key_BracketRight
                    text: "]"
                }
                Key {
                    key: Qt.Key_ParenLeft
                    text: "("
                }
                Key {
                    key: Qt.Key_ParenRight
                    text: ")"
                }
                Key {
                    key: Qt.Key_BraceLeft
                    text: "{"
                }
                Key {
                    key: Qt.Key_BraceRight
                    text: "}"
                }
                Key {
                    key: Qt.Key_Slash
                    text: "/"
                }
                Key {
                    key: Qt.Key_Bar
                    text: "|"
                }
                Key {
                    key: Qt.Key_Backslash
                    text: "\\"
                }
                Key {
                    key: Qt.Key_Agrave
                    text: "`"
                }
                FillerKey {
                    weight: 32
                }

                Key {
                    key: Qt.Key_6
                   text: "6"
                }
                Key {
                    key: Qt.Key_7
                    text: "7"
                }
                Key {
                    key: Qt.Key_8
                    text: "8"
                }
                Key {
                    key: Qt.Key_9
                    text: "9"
                }
                Key {
                    key: Qt.Key_0
                    text: "0"
                }
            }

            KeyboardRow {
                Layout.minimumHeight: 71

                Key {
                    key: Qt.Key_Exclam
                    text: "!"
                }
                Key {
                    key: Qt.Key_Question
                    text: "?"
                }
                Key {
                    key: Qt.Key_Ampersand
                    text: "&"
                }
                Key {
                    key: Qt.Key_Comma
                    text: ","
                }
                Key {
                    key: Qt.Key_Semicolon
                    text: ";"
                }
                Key {
                    key: Qt.Key_Colon
                    text: ":"
                }
                Key {
                    key:  Qt.Key_QuoteDbl
                    text: '"'
                }
                Key {
                    key: Qt.Key_Apostrophe
                    text: "'"
                }
                Key {
                    key: Qt.Key_section
                    text: "§"
                }
                FillerKey {
                }
                FillerKey {
                    weight: 32
                }
                Key {
                    key: 0xC2
                    text: "£"
                }
                Key {
                    key: Qt.Key_Dollar
                    text: "$"
                }
                Key {
                    key: 0x20AC
                    text: "€"
                }
                Key {
                    key: 0xA5
                    text: "¥"
                }
                FillerKey{
                }
            }
            KeyboardRow {
                Layout.minimumHeight: 12
                FillerKey{
                }
            }
            KeyboardRow {
                Layout.minimumHeight: 71

                ShiftKey {
                    enabled: false
                    weight: 320
                }
                SymbolModeKey {
                    weight: 320
                    displayText: "abc"
                }
                SpaceKey {
                    weight: 1330
                    displayText: "Leertaste"
                }
                FillerKey {
                    weight: 32
                }
                BackspaceKey {
                    weight: 412
                    displayText: "Löschen"
                }
                EnterKey {
                    weight: 411
                    displayText: "Fertig"
                }
            }
        }
    }
    Component {
        id: page2
        KeyboardLayout {
            inputMode: InputEngine.Latin
            keyWeight: 152
            spacing: 0
            KeyboardRow {
                Layout.minimumHeight: 71
                Key {
                    key: Qt.Key_NumberSign
                    text: "#"
                }
                Key {
                    key: Qt.Key_Plus
                    text: "+"
                }
                Key {
                    key: Qt.Key_Equal
                    text: "="
                }
                Key {
                    key:  Qt.Key_Percent
                    text: "%"
                }
                Key {
                    key: Qt.Key_AsciiTilde
                    text: "~"
                }
                Key {
                    key: Qt.Key_Period
                    text: "."
                }
                Key {
                    key: Qt.Key_Asterisk
                    text: "*"
                }
                Key {
                    key: Qt.Key_AsciiCircum
                    text: "^"
                }
                Key {
                    key: Qt.Key_Less
                    text: "<"
                }
                Key {
                    key: Qt.Key_Greater
                    text: ">"
                }
                FillerKey {
                    weight: 32
                }
                Key {
                    key: Qt.Key_1
                    text: "1"
                }
                Key {
                    key: Qt.Key_2
                    text: "2"
                }
                Key {
                    key: Qt.Key_3
                    text: "3"
                }
                Key {
                    key: Qt.Key_4
                    text: "4"
                }
                Key {
                    key: Qt.Key_5
                    text: "5"
                }
            }
            KeyboardRow {
                Layout.minimumHeight: 71
                Key {
                    key: Qt.Key_BracketLeft
                    text: "["
                }
                Key {
                    key: Qt.Key_BracketRight
                    text: "]"
                }
                Key {
                    key: Qt.Key_ParenLeft
                    text: "("
                }
                Key {
                    key: Qt.Key_ParenRight
                    text: ")"
                }
                Key {
                    key: Qt.Key_BraceLeft
                    text: "{"
                }
                Key {
                    key: Qt.Key_BraceRight
                    text: "}"
                }
                Key {
                    key: Qt.Key_Slash
                    text: "/"
                }
                Key {
                    key: Qt.Key_Bar
                    text: "|"
                }
                Key {
                    key: Qt.Key_Backslash
                    text: "\\"
                }
                Key {
                    key: Qt.Key_Agrave
                    text: "`"
                }
                FillerKey {
                    weight: 32
                }
                Key {
                    key: Qt.Key_6
                    text: "6"
                }
                Key {
                    key: Qt.Key_7
                    text: "7"
                }
                Key {
                    key: Qt.Key_8
                    text: "8"
                }
                Key {
                    key: Qt.Key_9
                    text: "9"
                }
                Key {
                    key: Qt.Key_0
                    text: "0"
                }
            }

            KeyboardRow {
                Layout.minimumHeight: 71

                Key {
                    key: Qt.Key_Exclam
                    text: "!"
                }
                Key {
                    key: Qt.Key_Question
                    text: "?"
                }
                Key {
                    key: Qt.Key_Ampersand
                    text: "&"
                }
                Key {
                    key: Qt.Key_Comma
                    text: ","
                }
                Key {
                    key: Qt.Key_Semicolon
                    text: ";"
                }
                Key {
                    key: Qt.Key_Colon
                    text: ":"
                }
                Key {
                    key:  Qt.Key_QuoteDbl
                    text: '"'
                }
                Key {
                    key: Qt.Key_Apostrophe
                    text: "'"
                }
                Key {
                    key: Qt.Key_section
                    text: "§"
                }
                FillerKey {
                }
                FillerKey {
                    weight: 32
                }
                Key {
                    key: 0xC2
                    text: "£"
                }
                Key {
                    key: Qt.Key_Dollar
                    text: "$"
                }
                Key {
                    key: 0x20AC
                    text: "€"
                }
                Key {
                    key: 0xA5
                    text: "¥"
                }
                FillerKey{
                }
            }

            KeyboardRow {
                Layout.minimumHeight: 12
                FillerKey{
                }
            }
            KeyboardRow {
                Layout.minimumHeight: 71

                ShiftKey {
                    enabled: false
                    weight: 320
                }
                SymbolModeKey {
                    weight: 320
                    displayText: "abc"
                }

                SpaceKey {
                    weight: 1330
                    displayText: "Leertaste"
                }
                FillerKey {
                    weight: 32
                }
                BackspaceKey {
                    weight: 412
                    displayText: "Löschen"
                }
                EnterKey {
                    weight: 411
                    displayText: "Suchen"
                }
            }
        }
    }
}
