/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: trigtabs.c,v 1.5 2005/04/27 19:20:50 hubbe Exp $
 *
 * REALNETWORKS CONFIDENTIAL--NOT FOR DISTRIBUTION IN SOURCE CODE FORM
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc.
 * All Rights Reserved.
 *
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the Real Format Source Code
 * Porting and Optimization License, available at
 * https://helixcommunity.org/2005/license/realformatsource (unless
 * RealNetworks otherwise expressly agrees in writing that you are
 * subject to a different license).  You may also obtain the license
 * terms directly from RealNetworks.  You may not use this file except
 * in compliance with the Real Format Source Code Porting and
 * Optimization License. There are no redistribution rights for the
 * source code of this file. Please see the Real Format Source Code
 * Porting and Optimization License for the rights, obligations and
 * limitations governing use of the contents of the file.
 *
 * RealNetworks is the developer of the Original Code and owns the
 * copyrights in the portions it created.
 *
 * This file, and the files included with this file, is distributed and
 * made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL
 * SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT
 * OR NON-INFRINGEMENT.
 *
 * Technology Compatibility Kit Test Suite(s) Location:
 * https://rarvcode-tck.helixcommunity.org
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** */

/**************************************************************************************
 * Fixed-point RealAudio 8 decoder
 * Jon Recker (jrecker@real.com), Ken Cooke (kenc@real.com)
 * October 2003
 *
 * trigtabs.c - tables of sin, cos, etc. for MLT
 **************************************************************************************/

#include "coder.h"

const int nmltTab[NUM_MLT_SIZES] = {256, 512, 1024};

const int cos4sin4tabOffset[3] = {0, 256, 768};

/* PreMultiply() tables
 * format = Q31 * 2^[-2, -3, -4] for nmlt = [256, 512, 1024]
 * reordered for sequential access
 *
 * sqrt2divn = sqrt(2.0 / nmlt);
 * for (i = 0; i < nmlt/4; i++) {
 *   angle = (i + 0.25) * M_PI / nmlt;
 *   x = sqrt2divn * (cos(angle) + sin(angle));
 *   x = sqrt2divn * sin(angle);
 *
 *   angle = (nmlt/2 - 1 - i + 0.25) * M_PI / nmlt;
 *   x = sqrt2divn * (cos(angle) + sin(angle));
 *   x = sqrt2divn * sin(angle);
 * }
 */
const int cos4sin4tab[256 + 512 + 1024] = {
    /* 256 */
    0x2d64b9da, 0x00238b03, 0x2dab5fdf, 0x2d40bf2f, 0x2df19534, 0x00b1b556, 0x2e37592c, 0x2d3e90e6,
    0x2e7cab1c, 0x013fd8d0, 0x2ec18a58, 0x2d3aa413, 0x2f05f637, 0x01cdeff5, 0x2f49ee0f, 0x2d34f8de,
    0x2f8d713a, 0x025bf54b, 0x2fd07f0f, 0x2d2d8f7d, 0x301316eb, 0x02e9e359, 0x30553828, 0x2d24683a,
    0x3096e223, 0x0377b4a4, 0x30d8143b, 0x2d19836f, 0x3118cdcf, 0x040563b7, 0x31590e3e, 0x2d0ce188,
    0x3198d4ea, 0x0492eb1a, 0x31d82137, 0x2cfe8302, 0x3216f287, 0x05204559, 0x32554840, 0x2cee6869,
    0x329321c7, 0x05ad6d00, 0x32d07e85, 0x2cdc925e, 0x330d5de3, 0x063a5c9f, 0x3349bf48, 0x2cc90190,
    0x3385a222, 0x06c70ec6, 0x33c105db, 0x2cb3b6c1, 0x33fbe9e2, 0x07537e09, 0x34364da6, 0x2c9cb2c2,
    0x34703095, 0x07dfa4fe, 0x34a99221, 0x2c83f677, 0x34e271bd, 0x086b7e3d, 0x351acedd, 0x2c6982d3,
    0x3552a8f4, 0x08f70463, 0x3589ff7a, 0x2c4d58dc, 0x35c0d1e7, 0x0982320e, 0x35f71fb1, 0x2c2f79a9,
    0x362ce855, 0x0a0d01e1, 0x36622b4c, 0x2c0fe65e, 0x3696e814, 0x0a976e82, 0x36cb1e2a, 0x2beea035,
    0x36fecd0e, 0x0b21729b, 0x3731f440, 0x2bcba876, 0x37649341, 0x0bab08d9, 0x3796a996, 0x2ba70079,
    0x37c836c2, 0x0c342bee, 0x37f93a4b, 0x2b80a9a9, 0x3829b3b9, 0x0cbcd691, 0x3859a292, 0x2b58a580,
    0x38890663, 0x0d45037e, 0x38b7deb4, 0x2b2ef588, 0x38e62b13, 0x0dccad74, 0x3913eb0e, 0x2b039b5e,
    0x39411e33, 0x0e53cf38, 0x396dc414, 0x2ad698ae, 0x3999dc42, 0x0eda6395, 0x39c5664f, 0x2aa7ef32,
    0x39f061d2, 0x0f60655a, 0x3a1ace5f, 0x2a77a0b9, 0x3a44ab8e, 0x0fe5cf5d, 0x3a6df8f8, 0x2a45af1e,
    0x3a96b636, 0x106a9c79, 0x3abee2e5, 0x2a121c4e, 0x3ae67ea1, 0x10eec790, 0x3b0d8909, 0x29dcea48,
    0x3b3401bb, 0x11724b88, 0x3b59e85a, 0x29a61b17, 0x3b7f3c87, 0x11f52351, 0x3ba3fde7, 0x296db0d8,
    0x3bc82c1f, 0x127749de, 0x3bebc6d5, 0x2933adb9, 0x3c0ecdb2, 0x12f8ba2b, 0x3c314060, 0x28f813f6,
    0x3c531e88, 0x13796f3b, 0x3c7467d9, 0x28bae5db, 0x3c951bff, 0x13f96417, 0x3cb53aaa, 0x287c25c3,
    0x3cd4c38b, 0x147893d1, 0x3cf3b653, 0x283bd61b, 0x3d1212b7, 0x14f6f981, 0x3d2fd86c, 0x27f9f95d,
    0x3d4d0728, 0x15749047, 0x3d699ea3, 0x27b69213, 0x3d859e96, 0x15f1534d, 0x3da106bd, 0x2771a2d6,
    0x3dbbd6d4, 0x166d3dc3, 0x3dd60e99, 0x272b2e4f, 0x3defadca, 0x16e84ae2, 0x3e08b42a, 0x26e33735,
    0x3e212179, 0x176275eb, 0x3e38f57c, 0x2699c04e, 0x3e502ff9, 0x17dbba29, 0x3e66d0b4, 0x264ecc6f,
    0x3e7cd778, 0x185412ef, 0x3e92440d, 0x26025e7c, 0x3ea7163f, 0x18cb7b99, 0x3ebb4ddb, 0x25b47968,
    0x3eceeaad, 0x1941ef8d, 0x3ee1ec87, 0x25652032, 0x3ef45338, 0x19b76a39, 0x3f061e95, 0x251455eb,
    0x3f174e70, 0x1a2be716, 0x3f27e29f, 0x24c21daf, 0x3f37dafa, 0x1a9f61a7, 0x3f473759, 0x246e7aab,
    0x3f55f796, 0x1b11d578, 0x3f641b8d, 0x24197017, 0x3f71a31b, 0x1b833e1e, 0x3f7e8e1e, 0x23c3013a,
    0x3f8adc77, 0x1bf3973c, 0x3f968e07, 0x236b316b, 0x3fa1a2b2, 0x1c62dc7b, 0x3fac1a5b, 0x2312040b,
    0x3fb5f4ea, 0x1cd10993, 0x3fbf3246, 0x22b77c8b, 0x3fc7d258, 0x1d3e1a43, 0x3fcfd50b, 0x225b9e68,
    0x3fd73a4a, 0x1daa0a57, 0x3fde0205, 0x21fe6d2c, 0x3fe42c2a, 0x1e14d5a5, 0x3fe9b8a9, 0x219fec71,
    0x3feea776, 0x1e7e7811, 0x3ff2f884, 0x21401fd9, 0x3ff6abc8, 0x1ee6ed86, 0x3ff9c13a, 0x20df0b17,
    0x3ffc38d1, 0x1f4e31ff, 0x3ffe1288, 0x207cb1e9, 0x3fff4e59, 0x1fb44180, 0x3fffec43, 0x2019181a,

    /* 512 */
    0x40191d0b, 0x001921fb, 0x404b3977, 0x3fffd396, 0x407d2e39, 0x007da998, 0x40aefb34, 0x3fff0e32,
    0x40e0a049, 0x00e22fff, 0x41121d58, 0x3ffdaae7, 0x41437244, 0x0146b438, 0x41749eee, 0x3ffba9b8,
    0x41a5a337, 0x01ab354b, 0x41d67f02, 0x3ff90aaa, 0x42073231, 0x020fb240, 0x4237bca4, 0x3ff5cdc3,
    0x42681e3f, 0x02742a1f, 0x429856e4, 0x3ff1f30b, 0x42c86674, 0x02d89bf0, 0x42f84cd2, 0x3fed7a8c,
    0x432809e1, 0x033d06bb, 0x43579d83, 0x3fe86452, 0x4387079a, 0x03a16988, 0x43b6480a, 0x3fe2b067,
    0x43e55eb6, 0x0405c361, 0x44144b7f, 0x3fdc5edc, 0x44430e4b, 0x046a134c, 0x4471a6fa, 0x3fd56fbe,
    0x44a01572, 0x04ce5854, 0x44ce5994, 0x3fcde320, 0x44fc7345, 0x0532917f, 0x452a6269, 0x3fc5b913,
    0x455826e2, 0x0596bdd7, 0x4585c094, 0x3fbcf1ad, 0x45b32f64, 0x05fadc66, 0x45e07336, 0x3fb38d02,
    0x460d8bed, 0x065eec33, 0x463a796e, 0x3fa98b2a, 0x46673b9d, 0x06c2ec48, 0x4693d25e, 0x3f9eec3e,
    0x46c03d96, 0x0726dbae, 0x46ec7d29, 0x3f93b058, 0x471890fd, 0x078ab96e, 0x474478f6, 0x3f87d792,
    0x477034f8, 0x07ee8493, 0x479bc4ea, 0x3f7b620c, 0x47c728af, 0x08523c25, 0x47f2602e, 0x3f6e4fe3,
    0x481d6b4b, 0x08b5df30, 0x484849ed, 0x3f60a138, 0x4872fbf8, 0x09196cbc, 0x489d8153, 0x3f52562c,
    0x48c7d9e2, 0x097ce3d5, 0x48f2058d, 0x3f436ee3, 0x491c0438, 0x09e04385, 0x4945d5ca, 0x3f33eb81,
    0x496f7a2a, 0x0a438ad7, 0x4998f13d, 0x3f23cc2e, 0x49c23aea, 0x0aa6b8d5, 0x49eb5718, 0x3f13110f,
    0x4a1445ad, 0x0b09cc8c, 0x4a3d0690, 0x3f01ba50, 0x4a6599a7, 0x0b6cc506, 0x4a8dfeda, 0x3eefc81a,
    0x4ab63610, 0x0bcfa150, 0x4ade3f30, 0x3edd3a9a, 0x4b061a21, 0x0c326075, 0x4b2dc6cc, 0x3eca11fe,
    0x4b554516, 0x0c950182, 0x4b7c94e8, 0x3eb64e75, 0x4ba3b62a, 0x0cf78383, 0x4bcaa8c3, 0x3ea1f02f,
    0x4bf16c9c, 0x0d59e586, 0x4c18019c, 0x3e8cf75f, 0x4c3e67ac, 0x0dbc2698, 0x4c649eb4, 0x3e77643a,
    0x4c8aa69d, 0x0e1e45c6, 0x4cb07f4f, 0x3e6136f3, 0x4cd628b2, 0x0e80421e, 0x4cfba2b0, 0x3e4a6fc1,
    0x4d20ed31, 0x0ee21aaf, 0x4d46081f, 0x3e330ede, 0x4d6af362, 0x0f43ce86, 0x4d8faee3, 0x3e1b1482,
    0x4db43a8d, 0x0fa55cb4, 0x4dd89648, 0x3e0280e9, 0x4dfcc1ff, 0x1006c446, 0x4e20bd9a, 0x3de9544f,
    0x4e448903, 0x1068044e, 0x4e682425, 0x3dcf8ef3, 0x4e8b8eea, 0x10c91bda, 0x4eaec93b, 0x3db53113,
    0x4ed1d303, 0x112a09fc, 0x4ef4ac2d, 0x3d9a3af2, 0x4f1754a2, 0x118acdc4, 0x4f39cc4d, 0x3d7eacd2,
    0x4f5c131a, 0x11eb6643, 0x4f7e28f3, 0x3d6286f6, 0x4fa00dc3, 0x124bd28c, 0x4fc1c175, 0x3d45c9a4,
    0x4fe343f4, 0x12ac11af, 0x5004952c, 0x3d287523, 0x5025b508, 0x130c22c1, 0x5046a374, 0x3d0a89bc,
    0x5067605b, 0x136c04d2, 0x5087eba9, 0x3cec07b8, 0x50a8454b, 0x13cbb6f8, 0x50c86d2b, 0x3cccef62,
    0x50e86337, 0x142b3846, 0x5108275a, 0x3cad4107, 0x5127b981, 0x148a87d1, 0x51471999, 0x3c8cfcf6,
    0x5166478e, 0x14e9a4ac, 0x5185434c, 0x3c6c237e, 0x51a40cc2, 0x15488dee, 0x51c2a3db, 0x3c4ab4ef,
    0x51e10886, 0x15a742ac, 0x51ff3aae, 0x3c28b19e, 0x521d3a42, 0x1605c1fd, 0x523b072f, 0x3c0619dc,
    0x5258a163, 0x16640af7, 0x527608cb, 0x3be2ee01, 0x52933d56, 0x16c21cb2, 0x52b03ef1, 0x3bbf2e62,
    0x52cd0d8a, 0x171ff646, 0x52e9a910, 0x3b9adb57, 0x53061170, 0x177d96ca, 0x5322469a, 0x3b75f53c,
    0x533e487d, 0x17dafd59, 0x535a1705, 0x3b507c69, 0x5375b224, 0x1838290c, 0x539119c7, 0x3b2a713d,
    0x53ac4dde, 0x189518fc, 0x53c74e58, 0x3b03d414, 0x53e21b23, 0x18f1cc45, 0x53fcb431, 0x3adca54e,
    0x54171970, 0x194e4201, 0x54314ad0, 0x3ab4e54c, 0x544b4841, 0x19aa794d, 0x546511b2, 0x3a8c9470,
    0x547ea715, 0x1a067145, 0x54980858, 0x3a63b31d, 0x54b1356d, 0x1a622907, 0x54ca2e44, 0x3a3a41b9,
    0x54e2f2ce, 0x1abd9faf, 0x54fb82fb, 0x3a1040a8, 0x5513debc, 0x1b18d45c, 0x552c0602, 0x39e5b054,
    0x5543f8be, 0x1b73c62d, 0x555bb6e2, 0x39ba9125, 0x5573405f, 0x1bce7442, 0x558a9525, 0x398ee385,
    0x55a1b528, 0x1c28ddbb, 0x55b8a058, 0x3962a7e0, 0x55cf56a8, 0x1c8301b9, 0x55e5d809, 0x3935dea4,
    0x55fc246e, 0x1cdcdf5e, 0x56123bc8, 0x3908883f, 0x56281e0b, 0x1d3675cb, 0x563dcb28, 0x38daa520,
    0x56534313, 0x1d8fc424, 0x566885be, 0x38ac35ba, 0x567d931b, 0x1de8c98c, 0x56926b1f, 0x387d3a7e,
    0x56a70dbc, 0x1e418528, 0x56bb7ae5, 0x384db3e0, 0x56cfb28e, 0x1e99f61d, 0x56e3b4aa, 0x381da256,
    0x56f7812e, 0x1ef21b90, 0x570b180c, 0x37ed0657, 0x571e7938, 0x1f49f4a8, 0x5731a4a8, 0x37bbe05a,
    0x57449a4e, 0x1fa1808c, 0x57575a20, 0x378a30d8, 0x5769e411, 0x1ff8be65, 0x577c3816, 0x3757f84c,
    0x578e5625, 0x204fad5b, 0x57a03e31, 0x37253733, 0x57b1f02f, 0x20a64c97, 0x57c36c16, 0x36f1ee09,
    0x57d4b1d9, 0x20fc9b44, 0x57e5c16f, 0x36be1d4c, 0x57f69acc, 0x2152988d, 0x58073de7, 0x3689c57d,
    0x5817aab5, 0x21a8439e, 0x5827e12d, 0x3654e71d, 0x5837e143, 0x21fd9ba3, 0x5847aaee, 0x361f82af,
    0x58573e25, 0x22529fca, 0x58669add, 0x35e998b5, 0x5875c10e, 0x22a74f40, 0x5884b0ad, 0x35b329b5,
    0x589369b3, 0x22fba936, 0x58a1ec15, 0x357c3636, 0x58b037cb, 0x234facda, 0x58be4ccc, 0x3544bebf,
    0x58cc2b0f, 0x23a3595e, 0x58d9d28b, 0x350cc3d8, 0x58e74339, 0x23f6adf3, 0x58f47d10, 0x34d4460c,
    0x59018008, 0x2449a9cc, 0x590e4c18, 0x349b45e7, 0x591ae13a, 0x249c4c1b, 0x59273f64, 0x3461c3f5,
    0x59336690, 0x24ee9415, 0x593f56b6, 0x3427c0c3, 0x594b0fce, 0x254080ef, 0x595691d2, 0x33ed3ce1,
    0x5961dcba, 0x259211df, 0x596cf080, 0x33b238e0, 0x5977cd1c, 0x25e3461b, 0x59827288, 0x3376b551,
    0x598ce0bd, 0x26341cdb, 0x599717b5, 0x333ab2c6, 0x59a11769, 0x26849558, 0x59aadfd4, 0x32fe31d5,
    0x59b470ef, 0x26d4aecb, 0x59bdcab4, 0x32c13311, 0x59c6ed1e, 0x2724686e, 0x59cfd827, 0x3283b712,
    0x59d88bc9, 0x2773c17d, 0x59e10800, 0x3245be70, 0x59e94cc5, 0x27c2b934, 0x59f15a15, 0x320749c3,
    0x59f92fe9, 0x28114ed0, 0x5a00ce3d, 0x31c859a5, 0x5a08350c, 0x285f8190, 0x5a0f6452, 0x3188eeb2,
    0x5a165c0a, 0x28ad50b1, 0x5a1d1c31, 0x31490986, 0x5a23a4c1, 0x28fabb75, 0x5a29f5b7, 0x3108aabf,
    0x5a300f0f, 0x2947c11c, 0x5a35f0c5, 0x30c7d2fb, 0x5a3b9ad5, 0x299460e8, 0x5a410d3c, 0x308682dc,
    0x5a4647f8, 0x29e09a1c, 0x5a4b4b03, 0x3044bb00, 0x5a50165c, 0x2a2c6bfd, 0x5a54a9ff, 0x30027c0c,
    0x5a5905ea, 0x2a77d5ce, 0x5a5d2a1a, 0x2fbfc6a3, 0x5a61168c, 0x2ac2d6d6, 0x5a64cb3e, 0x2f7c9b69,
    0x5a68482d, 0x2b0d6e5c, 0x5a6b8d58, 0x2f38fb03, 0x5a6e9abd, 0x2b579ba8, 0x5a717059, 0x2ef4e619,
    0x5a740e2a, 0x2ba15e03, 0x5a767430, 0x2eb05d53, 0x5a78a269, 0x2beab4b6, 0x5a7a98d3, 0x2e6b615a,
    0x5a7c576d, 0x2c339f0e, 0x5a7dde36, 0x2e25f2d8, 0x5a7f2d2e, 0x2c7c1c55, 0x5a804453, 0x2de01278,
    0x5a8123a4, 0x2cc42bd9, 0x5a81cb21, 0x2d99c0e7, 0x5a823acb, 0x2d0bcce8, 0x5a82729f, 0x2d52fed2,

    /* 1024 */
    0x5a943d5e, 0x0011c583, 0x5ab7ba6c, 0x5a8269e6, 0x5adb297d, 0x0058db81, 0x5afe8a8b, 0x5a82241c,
    0x5b21dd90, 0x009ff149, 0x5b452288, 0x5a81a67e, 0x5b68596d, 0x00e706ad, 0x5b8b8239, 0x5a80f10b,
    0x5bae9ce7, 0x012e1b84, 0x5bd1a971, 0x5a8003c5, 0x5bf4a7d2, 0x01752fa0, 0x5c179806, 0x5a7edeac,
    0x5c3a7a05, 0x01bc42d5, 0x5c5d4dcc, 0x5a7d81c0, 0x5c801354, 0x020354f9, 0x5ca2ca99, 0x5a7bed02,
    0x5cc57394, 0x024a65df, 0x5ce80e41, 0x5a7a2074, 0x5d0a9a9a, 0x0291755b, 0x5d2d189a, 0x5a781c16,
    0x5d4f883b, 0x02d88342, 0x5d71e979, 0x5a75dfea, 0x5d943c4e, 0x031f8f67, 0x5db680b4, 0x5a736bf1,
    0x5dd8b6a7, 0x0366999f, 0x5dfade20, 0x5a70c02c, 0x5e1cf71c, 0x03ada1bd, 0x5e3f0194, 0x5a6ddc9e,
    0x5e60fd84, 0x03f4a798, 0x5e82eae5, 0x5a6ac148, 0x5ea4c9b3, 0x043bab01, 0x5ec699e9, 0x5a676e2c,
    0x5ee85b82, 0x0482abce, 0x5f0a0e77, 0x5a63e34b, 0x5f2bb2c5, 0x04c9a9d3, 0x5f4d4865, 0x5a6020a9,
    0x5f6ecf53, 0x0510a4e3, 0x5f90478a, 0x5a5c2648, 0x5fb1b104, 0x05579cd4, 0x5fd30bbc, 0x5a57f429,
    0x5ff457ad, 0x059e9179, 0x601594d1, 0x5a538a50, 0x6036c325, 0x05e582a7, 0x6057e2a2, 0x5a4ee8bf,
    0x6078f344, 0x062c7032, 0x6099f505, 0x5a4a0f79, 0x60bae7e1, 0x067359ed, 0x60dbcbd1, 0x5a44fe81,
    0x60fca0d2, 0x06ba3faf, 0x611d66de, 0x5a3fb5db, 0x613e1df0, 0x07012149, 0x615ec603, 0x5a3a3589,
    0x617f5f12, 0x0747fe92, 0x619fe918, 0x5a347d8e, 0x61c06410, 0x078ed75d, 0x61e0cff5, 0x5a2e8df0,
    0x62012cc2, 0x07d5ab7e, 0x62217a72, 0x5a2866b0, 0x6241b8ff, 0x081c7aca, 0x6261e866, 0x5a2207d3,
    0x628208a1, 0x08634516, 0x62a219aa, 0x5a1b715d, 0x62c21b7e, 0x08aa0a35, 0x62e20e17, 0x5a14a352,
    0x6301f171, 0x08f0c9fb, 0x6321c585, 0x5a0d9db6, 0x63418a50, 0x0937843e, 0x63613fcd, 0x5a06608d,
    0x6380e5f6, 0x097e38d1, 0x63a07cc7, 0x59feebdc, 0x63c0043b, 0x09c4e789, 0x63df7c4d, 0x59f73fa8,
    0x63fee4f8, 0x0a0b903b, 0x641e3e38, 0x59ef5bf4, 0x643d8806, 0x0a5232ba, 0x645cc260, 0x59e740c7,
    0x647bed3f, 0x0a98cedb, 0x649b08a0, 0x59deee25, 0x64ba147d, 0x0adf6473, 0x64d910d1, 0x59d66413,
    0x64f7fd98, 0x0b25f356, 0x6516dacd, 0x59cda296, 0x6535a86b, 0x0b6c7b59, 0x6554666d, 0x59c4a9b4,
    0x657314cf, 0x0bb2fc50, 0x6591b38c, 0x59bb7973, 0x65b0429f, 0x0bf9760f, 0x65cec204, 0x59b211d8,
    0x65ed31b5, 0x0c3fe86b, 0x660b91af, 0x59a872e8, 0x6629e1ec, 0x0c865339, 0x66482267, 0x599e9cab,
    0x6666531d, 0x0cccb64d, 0x66847408, 0x59948f25, 0x66a28524, 0x0d13117c, 0x66c0866d, 0x598a4a5d,
    0x66de77dc, 0x0d59649a, 0x66fc596f, 0x597fce5a, 0x671a2b20, 0x0d9faf7c, 0x6737ecea, 0x59751b21,
    0x67559eca, 0x0de5f1f7, 0x677340ba, 0x596a30ba, 0x6790d2b6, 0x0e2c2bdf, 0x67ae54ba, 0x595f0f2b,
    0x67cbc6c0, 0x0e725d09, 0x67e928c5, 0x5953b67c, 0x68067ac3, 0x0eb88549, 0x6823bcb7, 0x594826b2,
    0x6840ee9b, 0x0efea475, 0x685e106c, 0x593c5fd5, 0x687b2224, 0x0f44ba62, 0x689823bf, 0x593061ed,
    0x68b5153a, 0x0f8ac6e3, 0x68d1f68f, 0x59242d01, 0x68eec7b9, 0x0fd0c9cd, 0x690b88b5, 0x5917c118,
    0x6928397e, 0x1016c2f7, 0x6944da10, 0x590b1e3a, 0x69616a65, 0x105cb233, 0x697dea7b, 0x58fe446f,
    0x699a5a4c, 0x10a29758, 0x69b6b9d3, 0x58f133bf, 0x69d3090e, 0x10e8723a, 0x69ef47f6, 0x58e3ec32,
    0x6a0b7689, 0x112e42ae, 0x6a2794c1, 0x58d66dcf, 0x6a43a29a, 0x11740889, 0x6a5fa010, 0x58c8b8a0,
    0x6a7b8d1e, 0x11b9c3a0, 0x6a9769c1, 0x58baccad, 0x6ab335f4, 0x11ff73c7, 0x6acef1b2, 0x58aca9fe,
    0x6aea9cf8, 0x124518d5, 0x6b0637c1, 0x589e509c, 0x6b21c208, 0x128ab29d, 0x6b3d3bcb, 0x588fc090,
    0x6b58a503, 0x12d040f6, 0x6b73fdae, 0x5880f9e4, 0x6b8f45c7, 0x1315c3b3, 0x6baa7d49, 0x5871fc9f,
    0x6bc5a431, 0x135b3aab, 0x6be0ba7b, 0x5862c8cb, 0x6bfbc021, 0x13a0a5b2, 0x6c16b521, 0x58535e72,
    0x6c319975, 0x13e6049e, 0x6c4c6d1a, 0x5843bd9e, 0x6c67300b, 0x142b5743, 0x6c81e245, 0x5833e657,
    0x6c9c83c3, 0x14709d78, 0x6cb71482, 0x5823d8a7, 0x6cd1947c, 0x14b5d711, 0x6cec03af, 0x5813949a,
    0x6d066215, 0x14fb03e3, 0x6d20afac, 0x58031a37, 0x6d3aec6e, 0x154023c4, 0x6d551858, 0x57f2698b,
    0x6d6f3365, 0x15853689, 0x6d893d93, 0x57e1829e, 0x6da336dc, 0x15ca3c08, 0x6dbd1f3c, 0x57d0657c,
    0x6dd6f6b1, 0x160f3417, 0x6df0bd35, 0x57bf122f, 0x6e0a72c5, 0x16541e89, 0x6e24175c, 0x57ad88c1,
    0x6e3daaf8, 0x1698fb36, 0x6e572d93, 0x579bc93e, 0x6e709f2a, 0x16ddc9f2, 0x6e89ffb9, 0x5789d3b1,
    0x6ea34f3d, 0x17228a93, 0x6ebc8db0, 0x5777a824, 0x6ed5bb10, 0x17673cef, 0x6eeed758, 0x576546a2,
    0x6f07e285, 0x17abe0dc, 0x6f20dc92, 0x5752af38, 0x6f39c57d, 0x17f0762e, 0x6f529d40, 0x573fe1f0,
    0x6f6b63d8, 0x1834fcbc, 0x6f841942, 0x572cded6, 0x6f9cbd79, 0x1879745b, 0x6fb5507a, 0x5719a5f6,
    0x6fcdd241, 0x18bddce1, 0x6fe642ca, 0x5706375c, 0x6ffea212, 0x19023625, 0x7016f014, 0x56f29314,
    0x702f2ccd, 0x19467ffb, 0x70475839, 0x56deb929, 0x705f7255, 0x198aba3a, 0x70777b1c, 0x56caa9a8,
    0x708f728b, 0x19cee4b7, 0x70a7589f, 0x56b6649e, 0x70bf2d53, 0x1a12ff49, 0x70d6f0a4, 0x56a1ea17,
    0x70eea28e, 0x1a5709c6, 0x7106430e, 0x568d3a1f, 0x711dd220, 0x1a9b0403, 0x71354fc0, 0x567854c4,
    0x714cbbeb, 0x1adeedd7, 0x7164169d, 0x56633a12, 0x717b5fd3, 0x1b22c717, 0x71929789, 0x564dea16,
    0x71a9bdba, 0x1b668f9a, 0x71c0d265, 0x563864dd, 0x71d7d585, 0x1baa4737, 0x71eec716, 0x5622aa75,
    0x7205a716, 0x1bededc2, 0x721c7580, 0x560cbaeb, 0x72333251, 0x1c318314, 0x7249dd86, 0x55f6964d,
    0x7260771b, 0x1c750701, 0x7276ff0d, 0x55e03ca8, 0x728d7557, 0x1cb87960, 0x72a3d9f7, 0x55c9ae0a,
    0x72ba2cea, 0x1cfbda08, 0x72d06e2b, 0x55b2ea81, 0x72e69db7, 0x1d3f28cf, 0x72fcbb8c, 0x559bf21a,
    0x7312c7a5, 0x1d82658c, 0x7328c1ff, 0x5584c4e5, 0x733eaa96, 0x1dc59015, 0x73548168, 0x556d62f0,
    0x736a4671, 0x1e08a840, 0x737ff9ae, 0x5555cc48, 0x73959b1b, 0x1e4bade4, 0x73ab2ab4, 0x553e00fd,
    0x73c0a878, 0x1e8ea0d9, 0x73d61461, 0x5526011d, 0x73eb6e6e, 0x1ed180f4, 0x7400b69a, 0x550dccb7,
    0x7415ece2, 0x1f144e0d, 0x742b1144, 0x54f563d9, 0x744023bc, 0x1f5707f9, 0x74552446, 0x54dcc694,
    0x746a12df, 0x1f99ae91, 0x747eef85, 0x54c3f4f5, 0x7493ba34, 0x1fdc41aa, 0x74a872e8, 0x54aaef0d,
    0x74bd199f, 0x201ec11d, 0x74d1ae55, 0x5491b4eb, 0x74e63108, 0x20612cbf, 0x74faa1b3, 0x5478469e,
    0x750f0054, 0x20a38468, 0x75234ce8, 0x545ea437, 0x7537876c, 0x20e5c7ee, 0x754bafdc, 0x5444cdc4,
    0x755fc635, 0x2127f72a, 0x7573ca75, 0x542ac356, 0x7587bc98, 0x216a11f2, 0x759b9c9b, 0x541084fc,
    0x75af6a7b, 0x21ac181e, 0x75c32634, 0x53f612c8, 0x75d6cfc5, 0x21ee0984, 0x75ea672a, 0x53db6cca,
    0x75fdec60, 0x222fe5fc, 0x76115f63, 0x53c09311, 0x7624c031, 0x2271ad5e, 0x76380ec8, 0x53a585ae,
    0x764b4b23, 0x22b35f80, 0x765e7540, 0x538a44b3, 0x76718d1c, 0x22f4fc3b, 0x768492b4, 0x536ed02f,
    0x76978605, 0x23368365, 0x76aa670d, 0x53532835, 0x76bd35c7, 0x2377f4d7, 0x76cff232, 0x53374cd4,
    0x76e29c4b, 0x23b95068, 0x76f5340e, 0x531b3e1e, 0x7707b979, 0x23fa95f0, 0x771a2c88, 0x52fefc25,
    0x772c8d3a, 0x243bc546, 0x773edb8b, 0x52e286f9, 0x77511778, 0x247cde42, 0x776340ff, 0x52c5dead,
    0x7775581d, 0x24bde0bd, 0x77875cce, 0x52a90351, 0x77994f11, 0x24fecc8d, 0x77ab2ee2, 0x528bf4f9,
    0x77bcfc3f, 0x253fa18c, 0x77ceb725, 0x526eb3b5, 0x77e05f91, 0x25805f90, 0x77f1f581, 0x52513f99,
    0x780378f1, 0x25c10672, 0x7814e9df, 0x523398b5, 0x78264849, 0x2601960b, 0x7837942b, 0x5215bf1c,
    0x7848cd83, 0x26420e32, 0x7859f44f, 0x51f7b2e1, 0x786b088c, 0x26826ebf, 0x787c0a36, 0x51d97417,
    0x788cf94c, 0x26c2b78b, 0x789dd5cb, 0x51bb02cf, 0x78ae9fb0, 0x2702e86e, 0x78bf56f9, 0x519c5f1d,
    0x78cffba3, 0x27430141, 0x78e08dab, 0x517d8913, 0x78f10d0f, 0x278301dc, 0x790179cd, 0x515e80c5,
    0x7911d3e2, 0x27c2ea18, 0x79221b4b, 0x513f4645, 0x79325006, 0x2802b9cc, 0x79427210, 0x511fd9a8,
    0x79528167, 0x284270d3, 0x79627e08, 0x51003b00, 0x797267f2, 0x28820f04, 0x79823f20, 0x50e06a61,
    0x79920392, 0x28c19438, 0x79a1b545, 0x50c067de, 0x79b15435, 0x29010048, 0x79c0e062, 0x50a0338c,
    0x79d059c8, 0x2940530d, 0x79dfc064, 0x507fcd7d, 0x79ef1436, 0x297f8c60, 0x79fe5539, 0x505f35c7,
    0x7a0d836d, 0x29beac1a, 0x7a1c9ece, 0x503e6c7d, 0x7a2ba75a, 0x29fdb213, 0x7a3a9d0f, 0x501d71b3,
    0x7a497feb, 0x2a3c9e26, 0x7a584feb, 0x4ffc457e, 0x7a670d0d, 0x2a7b702b, 0x7a75b74f, 0x4fdae7f2,
    0x7a844eae, 0x2aba27fc, 0x7a92d329, 0x4fb95925, 0x7aa144bc, 0x2af8c571, 0x7aafa367, 0x4f979929,
    0x7abdef25, 0x2b374865, 0x7acc27f7, 0x4f75a815, 0x7ada4dd8, 0x2b75b0b0, 0x7ae860c7, 0x4f5385fd,
    0x7af660c2, 0x2bb3fe2c, 0x7b044dc7, 0x4f3132f7, 0x7b1227d3, 0x2bf230b3, 0x7b1feee5, 0x4f0eaf17,
    0x7b2da2fa, 0x2c30481e, 0x7b3b4410, 0x4eebfa72, 0x7b48d225, 0x2c6e4447, 0x7b564d36, 0x4ec9151f,
    0x7b63b543, 0x2cac2509, 0x7b710a49, 0x4ea5ff33, 0x7b7e4c45, 0x2ce9ea3b, 0x7b8b7b36, 0x4e82b8c3,
    0x7b989719, 0x2d2793b9, 0x7ba59fee, 0x4e5f41e5, 0x7bb295b0, 0x2d65215d, 0x7bbf7860, 0x4e3b9aaf,
    0x7bcc47fa, 0x2da29300, 0x7bd9047c, 0x4e17c337, 0x7be5ade6, 0x2ddfe87d, 0x7bf24434, 0x4df3bb93,
    0x7bfec765, 0x2e1d21ae, 0x7c0b3777, 0x4dcf83d9, 0x7c179467, 0x2e5a3e6c, 0x7c23de35, 0x4dab1c20,
    0x7c3014de, 0x2e973e93, 0x7c3c3860, 0x4d86847e, 0x7c4848ba, 0x2ed421fd, 0x7c5445e9, 0x4d61bd0a,
    0x7c602fec, 0x2f10e883, 0x7c6c06c0, 0x4d3cc5da, 0x7c77ca65, 0x2f4d9202, 0x7c837ad8, 0x4d179f06,
    0x7c8f1817, 0x2f8a1e52, 0x7c9aa221, 0x4cf248a3, 0x7ca618f3, 0x2fc68d4f, 0x7cb17c8d, 0x4cccc2ca,
    0x7cbcccec, 0x3002ded4, 0x7cc80a0f, 0x4ca70d91, 0x7cd333f3, 0x303f12bc, 0x7cde4a98, 0x4c81290f,
    0x7ce94dfb, 0x307b28e0, 0x7cf43e1a, 0x4c5b155c, 0x7cff1af5, 0x30b7211d, 0x7d09e489, 0x4c34d290,
    0x7d149ad5, 0x30f2fb4d, 0x7d1f3dd6, 0x4c0e60c2, 0x7d29cd8c, 0x312eb74b, 0x7d3449f5, 0x4be7c009,
    0x7d3eb30f, 0x316a54f3, 0x7d4908d9, 0x4bc0f07e, 0x7d534b50, 0x31a5d41f, 0x7d5d7a74, 0x4b99f238,
    0x7d679642, 0x31e134ac, 0x7d719eba, 0x4b72c550, 0x7d7b93da, 0x321c7673, 0x7d85759f, 0x4b4b69de,
    0x7d8f4409, 0x32579951, 0x7d98ff17, 0x4b23dff9, 0x7da2a6c6, 0x32929d22, 0x7dac3b15, 0x4afc27bb,
    0x7db5bc02, 0x32cd81c1, 0x7dbf298d, 0x4ad4413c, 0x7dc883b4, 0x33084709, 0x7dd1ca75, 0x4aac2c94,
    0x7ddafdce, 0x3342ecd6, 0x7de41dc0, 0x4a83e9dc, 0x7ded2a47, 0x337d7304, 0x7df62362, 0x4a5b792e,
    0x7dff0911, 0x33b7d970, 0x7e07db52, 0x4a32daa1, 0x7e109a24, 0x33f21ff4, 0x7e194584, 0x4a0a0e4f,
    0x7e21dd73, 0x342c466e, 0x7e2a61ed, 0x49e11452, 0x7e32d2f4, 0x34664cb9, 0x7e3b3083, 0x49b7ecc2,
    0x7e437a9c, 0x34a032b1, 0x7e4bb13c, 0x498e97b9, 0x7e53d462, 0x34d9f833, 0x7e5be40c, 0x49651550,
    0x7e63e03b, 0x35139d1b, 0x7e6bc8eb, 0x493b65a2, 0x7e739e1d, 0x354d2145, 0x7e7b5fce, 0x491188c6,
    0x7e830dff, 0x3586848e, 0x7e8aa8ac, 0x48e77ed9, 0x7e922fd6, 0x35bfc6d3, 0x7e99a37c, 0x48bd47f3,
    0x7ea1039b, 0x35f8e7f0, 0x7ea85033, 0x4892e42e, 0x7eaf8943, 0x3631e7c3, 0x7eb6aeca, 0x486853a5,
    0x7ebdc0c6, 0x366ac627, 0x7ec4bf36, 0x483d9672, 0x7ecbaa1a, 0x36a382fa, 0x7ed28171, 0x4812acaf,
    0x7ed94538, 0x36dc1e19, 0x7edff570, 0x47e79676, 0x7ee69217, 0x37149760, 0x7eed1b2c, 0x47bc53e3,
    0x7ef390ae, 0x374ceeae, 0x7ef9f29d, 0x4790e510, 0x7f0040f6, 0x378523df, 0x7f067bba, 0x47654a18,
    0x7f0ca2e7, 0x37bd36d1, 0x7f12b67c, 0x47398316, 0x7f18b679, 0x37f52760, 0x7f1ea2dc, 0x470d9024,
    0x7f247ba5, 0x382cf56c, 0x7f2a40d2, 0x46e1715d, 0x7f2ff263, 0x3864a0d0, 0x7f359057, 0x46b526de,
    0x7f3b1aad, 0x389c296b, 0x7f409164, 0x4688b0c1, 0x7f45f47b, 0x38d38f1b, 0x7f4b43f2, 0x465c0f22,
    0x7f507fc7, 0x390ad1bd, 0x7f55a7fa, 0x462f421c, 0x7f5abc8a, 0x3941f12f, 0x7f5fbd77, 0x460249cb,
    0x7f64aabf, 0x3978ed4f, 0x7f698461, 0x45d5264b, 0x7f6e4a5e, 0x39afc5fc, 0x7f72fcb4, 0x45a7d7b7,
    0x7f779b62, 0x39e67b13, 0x7f7c2668, 0x457a5e2c, 0x7f809dc5, 0x3a1d0c73, 0x7f850179, 0x454cb9c5,
    0x7f895182, 0x3a5379fa, 0x7f8d8de1, 0x451eea9f, 0x7f91b694, 0x3a89c387, 0x7f95cb9a, 0x44f0f0d5,
    0x7f99ccf4, 0x3abfe8f8, 0x7f9dbaa0, 0x44c2cc85, 0x7fa1949e, 0x3af5ea2b, 0x7fa55aee, 0x44947dcb,
    0x7fa90d8e, 0x3b2bc700, 0x7facac7f, 0x446604c2, 0x7fb037bf, 0x3b617f55, 0x7fb3af4e, 0x44376189,
    0x7fb7132b, 0x3b971308, 0x7fba6357, 0x4408943c, 0x7fbd9fd0, 0x3bcc81fa, 0x7fc0c896, 0x43d99cf7,
    0x7fc3dda9, 0x3c01cc08, 0x7fc6df08, 0x43aa7bd8, 0x7fc9ccb2, 0x3c36f113, 0x7fcca6a7, 0x437b30fb,
    0x7fcf6ce8, 0x3c6bf0f9, 0x7fd21f72, 0x434bbc7e, 0x7fd4be46, 0x3ca0cb9a, 0x7fd74964, 0x431c1e7e,
    0x7fd9c0ca, 0x3cd580d4, 0x7fdc247a, 0x42ec5719, 0x7fde7471, 0x3d0a1088, 0x7fe0b0b1, 0x42bc666b,
    0x7fe2d938, 0x3d3e7a95, 0x7fe4ee06, 0x428c4c93, 0x7fe6ef1c, 0x3d72bedb, 0x7fe8dc78, 0x425c09ae,
    0x7feab61a, 0x3da6dd39, 0x7fec7c02, 0x422b9ddb, 0x7fee2e30, 0x3ddad590, 0x7fefcca4, 0x41fb0935,
    0x7ff1575d, 0x3e0ea7bf, 0x7ff2ce5b, 0x41ca4bdd, 0x7ff4319d, 0x3e4253a6, 0x7ff58125, 0x419965f0,
    0x7ff6bcf0, 0x3e75d926, 0x7ff7e500, 0x4168578b, 0x7ff8f954, 0x3ea9381e, 0x7ff9f9ec, 0x413720ce,
    0x7ffae6c7, 0x3edc7070, 0x7ffbbfe6, 0x4105c1d6, 0x7ffc8549, 0x3f0f81fb, 0x7ffd36ee, 0x40d43ac3,
    0x7ffdd4d7, 0x3f426c9f, 0x7ffe5f03, 0x40a28bb2, 0x7ffed572, 0x3f75303e, 0x7fff3824, 0x4070b4c2,
    0x7fff8719, 0x3fa7ccb9, 0x7fffc251, 0x403eb613, 0x7fffe9cb, 0x3fda41ef, 0x7ffffd88, 0x400c8fc2,
};

/* PostMultiply() tables
 * format = Q31
 * reordered for sequential access
 * decimate (skip by 4 or 8) for smaller transforms (512, 256)
 *
 * for (i = 0; i <= (512/2); i++) {
 *   angle = i * M_PI / 1024;
 *   x = 0.5*(cos(angle) + sin(angle));
 *   x = 0.5*sin(angle);
 * }
 */
const int cos1sin1tab[514] = {
    0x40000000, 0x00000000, 0x40323034, 0x003243f1, 0x406438cf, 0x006487c4, 0x409619b2, 0x0096cb58,
    0x40c7d2bd, 0x00c90e90, 0x40f963d3, 0x00fb514b, 0x412accd4, 0x012d936c, 0x415c0da3, 0x015fd4d2,
    0x418d2621, 0x0192155f, 0x41be162f, 0x01c454f5, 0x41eeddaf, 0x01f69373, 0x421f7c84, 0x0228d0bb,
    0x424ff28f, 0x025b0caf, 0x42803fb2, 0x028d472e, 0x42b063d0, 0x02bf801a, 0x42e05ecb, 0x02f1b755,
    0x43103085, 0x0323ecbe, 0x433fd8e1, 0x03562038, 0x436f57c1, 0x038851a2, 0x439ead09, 0x03ba80df,
    0x43cdd89a, 0x03ecadcf, 0x43fcda59, 0x041ed854, 0x442bb227, 0x0451004d, 0x445a5fe8, 0x0483259d,
    0x4488e37f, 0x04b54825, 0x44b73ccf, 0x04e767c5, 0x44e56bbd, 0x0519845e, 0x4513702a, 0x054b9dd3,
    0x454149fc, 0x057db403, 0x456ef916, 0x05afc6d0, 0x459c7d5a, 0x05e1d61b, 0x45c9d6af, 0x0613e1c5,
    0x45f704f7, 0x0645e9af, 0x46240816, 0x0677edbb, 0x4650dff1, 0x06a9edc9, 0x467d8c6d, 0x06dbe9bb,
    0x46aa0d6d, 0x070de172, 0x46d662d6, 0x073fd4cf, 0x47028c8d, 0x0771c3b3, 0x472e8a76, 0x07a3adff,
    0x475a5c77, 0x07d59396, 0x47860275, 0x08077457, 0x47b17c54, 0x08395024, 0x47dcc9f9, 0x086b26de,
    0x4807eb4b, 0x089cf867, 0x4832e02d, 0x08cec4a0, 0x485da887, 0x09008b6a, 0x4888443d, 0x09324ca7,
    0x48b2b335, 0x09640837, 0x48dcf556, 0x0995bdfd, 0x49070a84, 0x09c76dd8, 0x4930f2a6, 0x09f917ac,
    0x495aada2, 0x0a2abb59, 0x49843b5f, 0x0a5c58c0, 0x49ad9bc2, 0x0a8defc3, 0x49d6ceb3, 0x0abf8043,
    0x49ffd417, 0x0af10a22, 0x4a28abd6, 0x0b228d42, 0x4a5155d6, 0x0b540982, 0x4a79d1ff, 0x0b857ec7,
    0x4aa22036, 0x0bb6ecef, 0x4aca4065, 0x0be853de, 0x4af23270, 0x0c19b374, 0x4b19f641, 0x0c4b0b94,
    0x4b418bbe, 0x0c7c5c1e, 0x4b68f2cf, 0x0cada4f5, 0x4b902b5c, 0x0cdee5f9, 0x4bb7354d, 0x0d101f0e,
    0x4bde1089, 0x0d415013, 0x4c04bcf8, 0x0d7278eb, 0x4c2b3a84, 0x0da39978, 0x4c518913, 0x0dd4b19a,
    0x4c77a88e, 0x0e05c135, 0x4c9d98de, 0x0e36c82a, 0x4cc359ec, 0x0e67c65a, 0x4ce8eb9f, 0x0e98bba7,
    0x4d0e4de2, 0x0ec9a7f3, 0x4d33809c, 0x0efa8b20, 0x4d5883b7, 0x0f2b650f, 0x4d7d571c, 0x0f5c35a3,
    0x4da1fab5, 0x0f8cfcbe, 0x4dc66e6a, 0x0fbdba40, 0x4deab226, 0x0fee6e0d, 0x4e0ec5d1, 0x101f1807,
    0x4e32a956, 0x104fb80e, 0x4e565c9f, 0x10804e06, 0x4e79df95, 0x10b0d9d0, 0x4e9d3222, 0x10e15b4e,
    0x4ec05432, 0x1111d263, 0x4ee345ad, 0x11423ef0, 0x4f06067f, 0x1172a0d7, 0x4f289692, 0x11a2f7fc,
    0x4f4af5d1, 0x11d3443f, 0x4f6d2427, 0x12038584, 0x4f8f217e, 0x1233bbac, 0x4fb0edc1, 0x1263e699,
    0x4fd288dc, 0x1294062f, 0x4ff3f2bb, 0x12c41a4f, 0x50152b47, 0x12f422db, 0x5036326e, 0x13241fb6,
    0x50570819, 0x135410c3, 0x5077ac37, 0x1383f5e3, 0x50981eb1, 0x13b3cefa, 0x50b85f74, 0x13e39be9,
    0x50d86e6d, 0x14135c94, 0x50f84b87, 0x144310dd, 0x5117f6ae, 0x1472b8a5, 0x51376fd0, 0x14a253d1,
    0x5156b6d9, 0x14d1e242, 0x5175cbb5, 0x150163dc, 0x5194ae52, 0x1530d881, 0x51b35e9b, 0x15604013,
    0x51d1dc80, 0x158f9a76, 0x51f027eb, 0x15bee78c, 0x520e40cc, 0x15ee2738, 0x522c270f, 0x161d595d,
    0x5249daa2, 0x164c7ddd, 0x52675b72, 0x167b949d, 0x5284a96e, 0x16aa9d7e, 0x52a1c482, 0x16d99864,
    0x52beac9f, 0x17088531, 0x52db61b0, 0x173763c9, 0x52f7e3a6, 0x1766340f, 0x5314326d, 0x1794f5e6,
    0x53304df6, 0x17c3a931, 0x534c362d, 0x17f24dd3, 0x5367eb03, 0x1820e3b0, 0x53836c66, 0x184f6aab,
    0x539eba45, 0x187de2a7, 0x53b9d48f, 0x18ac4b87, 0x53d4bb34, 0x18daa52f, 0x53ef6e23, 0x1908ef82,
    0x5409ed4b, 0x19372a64, 0x5424389d, 0x196555b8, 0x543e5007, 0x19937161, 0x5458337a, 0x19c17d44,
    0x5471e2e6, 0x19ef7944, 0x548b5e3b, 0x1a1d6544, 0x54a4a56a, 0x1a4b4128, 0x54bdb862, 0x1a790cd4,
    0x54d69714, 0x1aa6c82b, 0x54ef4171, 0x1ad47312, 0x5507b76a, 0x1b020d6c, 0x551ff8ef, 0x1b2f971e,
    0x553805f2, 0x1b5d100a, 0x554fde64, 0x1b8a7815, 0x55678236, 0x1bb7cf23, 0x557ef15a, 0x1be51518,
    0x55962bc0, 0x1c1249d8, 0x55ad315b, 0x1c3f6d47, 0x55c4021d, 0x1c6c7f4a, 0x55da9df7, 0x1c997fc4,
    0x55f104dc, 0x1cc66e99, 0x560736bd, 0x1cf34baf, 0x561d338d, 0x1d2016e9, 0x5632fb3f, 0x1d4cd02c,
    0x56488dc5, 0x1d79775c, 0x565deb11, 0x1da60c5d, 0x56731317, 0x1dd28f15, 0x568805c9, 0x1dfeff67,
    0x569cc31b, 0x1e2b5d38, 0x56b14b00, 0x1e57a86d, 0x56c59d6a, 0x1e83e0eb, 0x56d9ba4e, 0x1eb00696,
    0x56eda1a0, 0x1edc1953, 0x57015352, 0x1f081907, 0x5714cf59, 0x1f340596, 0x572815a8, 0x1f5fdee6,
    0x573b2635, 0x1f8ba4dc, 0x574e00f2, 0x1fb7575c, 0x5760a5d5, 0x1fe2f64c, 0x577314d2, 0x200e8190,
    0x57854ddd, 0x2039f90f, 0x579750ec, 0x20655cac, 0x57a91df2, 0x2090ac4d, 0x57bab4e6, 0x20bbe7d8,
    0x57cc15bc, 0x20e70f32, 0x57dd406a, 0x21122240, 0x57ee34e5, 0x213d20e8, 0x57fef323, 0x21680b0f,
    0x580f7b19, 0x2192e09b, 0x581fccbc, 0x21bda171, 0x582fe804, 0x21e84d76, 0x583fcce6, 0x2212e492,
    0x584f7b58, 0x223d66a8, 0x585ef351, 0x2267d3a0, 0x586e34c7, 0x22922b5e, 0x587d3fb0, 0x22bc6dca,
    0x588c1404, 0x22e69ac8, 0x589ab1b9, 0x2310b23e, 0x58a918c6, 0x233ab414, 0x58b74923, 0x2364a02e,
    0x58c542c5, 0x238e7673, 0x58d305a6, 0x23b836ca, 0x58e091bd, 0x23e1e117, 0x58ede700, 0x240b7543,
    0x58fb0568, 0x2434f332, 0x5907eced, 0x245e5acc, 0x59149d87, 0x2487abf7, 0x5921172e, 0x24b0e699,
    0x592d59da, 0x24da0a9a, 0x59396584, 0x250317df, 0x59453a24, 0x252c0e4f, 0x5950d7b3, 0x2554edd1,
    0x595c3e2a, 0x257db64c, 0x59676d82, 0x25a667a7, 0x597265b4, 0x25cf01c8, 0x597d26b8, 0x25f78497,
    0x5987b08a, 0x261feffa, 0x59920321, 0x264843d9, 0x599c1e78, 0x2670801a, 0x59a60288, 0x2698a4a6,
    0x59afaf4c, 0x26c0b162, 0x59b924bc, 0x26e8a637, 0x59c262d5, 0x2710830c, 0x59cb698f, 0x273847c8,
    0x59d438e5, 0x275ff452, 0x59dcd0d3, 0x27878893, 0x59e53151, 0x27af0472, 0x59ed5a5c, 0x27d667d5,
    0x59f54bee, 0x27fdb2a7, 0x59fd0603, 0x2824e4cc, 0x5a048895, 0x284bfe2f, 0x5a0bd3a1, 0x2872feb6,
    0x5a12e720, 0x2899e64a, 0x5a19c310, 0x28c0b4d2, 0x5a20676c, 0x28e76a37, 0x5a26d42f, 0x290e0661,
    0x5a2d0957, 0x29348937, 0x5a3306de, 0x295af2a3, 0x5a38ccc2, 0x2981428c, 0x5a3e5afe, 0x29a778db,
    0x5a43b190, 0x29cd9578, 0x5a48d074, 0x29f3984c, 0x5a4db7a6, 0x2a19813f, 0x5a526725, 0x2a3f503a,
    0x5a56deec, 0x2a650525, 0x5a5b1efa, 0x2a8a9fea, 0x5a5f274b, 0x2ab02071, 0x5a62f7dd, 0x2ad586a3,
    0x5a6690ae, 0x2afad269, 0x5a69f1bb, 0x2b2003ac, 0x5a6d1b03, 0x2b451a55, 0x5a700c84, 0x2b6a164d,
    0x5a72c63b, 0x2b8ef77d, 0x5a754827, 0x2bb3bdce, 0x5a779246, 0x2bd8692b, 0x5a79a498, 0x2bfcf97c,
    0x5a7b7f1a, 0x2c216eaa, 0x5a7d21cc, 0x2c45c8a0, 0x5a7e8cac, 0x2c6a0746, 0x5a7fbfbb, 0x2c8e2a87,
    0x5a80baf6, 0x2cb2324c, 0x5a817e5d, 0x2cd61e7f, 0x5a8209f1, 0x2cf9ef09, 0x5a825db0, 0x2d1da3d5,
    0x5a82799a, 0x2d413ccd,
};

const int windowOffset[3] = {0, 256, 768};

/* Synthesis window
 * format = Q31
 * reordered for sequential access
 *
 * for (i = 0; i < nmlt / 2; i++) {
 *   angle = (i + 0.5) * M_PI / (2.0 * nmlt);
 *   x = sin(angle);
 *
 *   angle = (nmlt - 1 - i + 0.5) * M_PI / (2.0 * nmlt);
 *   x = sin(angle);
 * }
 */
const int window[256 + 512 + 1024] = {
    /* 256 point window */
    0x006487e3, 0x7fffd886, 0x012d96b1, 0x7ffe9cb2, 0x01f6a297, 0x7ffc250f, 0x02bfa9a4, 0x7ff871a2,
    0x0388a9ea, 0x7ff38274, 0x0451a177, 0x7fed5791, 0x051a8e5c, 0x7fe5f108, 0x05e36ea9, 0x7fdd4eec,
    0x06ac406f, 0x7fd37153, 0x077501be, 0x7fc85854, 0x083db0a7, 0x7fbc040a, 0x09064b3a, 0x7fae7495,
    0x09cecf89, 0x7f9faa15, 0x0a973ba5, 0x7f8fa4b0, 0x0b5f8d9f, 0x7f7e648c, 0x0c27c389, 0x7f6be9d4,
    0x0cefdb76, 0x7f5834b7, 0x0db7d376, 0x7f434563, 0x0e7fa99e, 0x7f2d1c0e, 0x0f475bff, 0x7f15b8ee,
    0x100ee8ad, 0x7efd1c3c, 0x10d64dbd, 0x7ee34636, 0x119d8941, 0x7ec8371a, 0x1264994e, 0x7eabef2c,
    0x132b7bf9, 0x7e8e6eb2, 0x13f22f58, 0x7e6fb5f4, 0x14b8b17f, 0x7e4fc53e, 0x157f0086, 0x7e2e9cdf,
    0x16451a83, 0x7e0c3d29, 0x170afd8d, 0x7de8a670, 0x17d0a7bc, 0x7dc3d90d, 0x18961728, 0x7d9dd55a,
    0x195b49ea, 0x7d769bb5, 0x1a203e1b, 0x7d4e2c7f, 0x1ae4f1d6, 0x7d24881b, 0x1ba96335, 0x7cf9aef0,
    0x1c6d9053, 0x7ccda169, 0x1d31774d, 0x7ca05ff1, 0x1df5163f, 0x7c71eaf9, 0x1eb86b46, 0x7c4242f2,
    0x1f7b7481, 0x7c116853, 0x203e300d, 0x7bdf5b94, 0x21009c0c, 0x7bac1d31, 0x21c2b69c, 0x7b77ada8,
    0x22847de0, 0x7b420d7a, 0x2345eff8, 0x7b0b3d2c, 0x24070b08, 0x7ad33d45, 0x24c7cd33, 0x7a9a0e50,
    0x2588349d, 0x7a5fb0d8, 0x26483f6c, 0x7a24256f, 0x2707ebc7, 0x79e76ca7, 0x27c737d3, 0x79a98715,
    0x288621b9, 0x796a7554, 0x2944a7a2, 0x792a37fe, 0x2a02c7b8, 0x78e8cfb2, 0x2ac08026, 0x78a63d11,
    0x2b7dcf17, 0x786280bf, 0x2c3ab2b9, 0x781d9b65, 0x2cf72939, 0x77d78daa, 0x2db330c7, 0x7790583e,
    0x2e6ec792, 0x7747fbce, 0x2f29ebcc, 0x76fe790e, 0x2fe49ba7, 0x76b3d0b4, 0x309ed556, 0x76680376,
    0x3158970e, 0x761b1211, 0x3211df04, 0x75ccfd42, 0x32caab6f, 0x757dc5ca, 0x3382fa88, 0x752d6c6c,
    0x343aca87, 0x74dbf1ef, 0x34f219a8, 0x7489571c, 0x35a8e625, 0x74359cbd, 0x365f2e3b, 0x73e0c3a3,
    0x3714f02a, 0x738acc9e, 0x37ca2a30, 0x7333b883, 0x387eda8e, 0x72db8828, 0x3932ff87, 0x72823c67,
    0x39e6975e, 0x7227d61c, 0x3a99a057, 0x71cc5626, 0x3b4c18ba, 0x716fbd68, 0x3bfdfecd, 0x71120cc5,
    0x3caf50da, 0x70b34525, 0x3d600d2c, 0x70536771, 0x3e10320d, 0x6ff27497, 0x3ebfbdcd, 0x6f906d84,
    0x3f6eaeb8, 0x6f2d532c, 0x401d0321, 0x6ec92683, 0x40cab958, 0x6e63e87f, 0x4177cfb1, 0x6dfd9a1c,
    0x42244481, 0x6d963c54, 0x42d0161e, 0x6d2dd027, 0x437b42e1, 0x6cc45698, 0x4425c923, 0x6c59d0a9,
    0x44cfa740, 0x6bee3f62, 0x4578db93, 0x6b81a3cd, 0x4621647d, 0x6b13fef5, 0x46c9405c, 0x6aa551e9,
    0x47706d93, 0x6a359db9, 0x4816ea86, 0x69c4e37a, 0x48bcb599, 0x69532442, 0x4961cd33, 0x68e06129,
    0x4a062fbd, 0x686c9b4b, 0x4aa9dba2, 0x67f7d3c5, 0x4b4ccf4d, 0x67820bb7, 0x4bef092d, 0x670b4444,
    0x4c9087b1, 0x66937e91, 0x4d31494b, 0x661abbc5, 0x4dd14c6e, 0x65a0fd0b, 0x4e708f8f, 0x6526438f,
    0x4f0f1126, 0x64aa907f, 0x4faccfab, 0x642de50d, 0x5049c999, 0x63b0426d, 0x50e5fd6d, 0x6331a9d4,
    0x518169a5, 0x62b21c7b, 0x521c0cc2, 0x62319b9d, 0x52b5e546, 0x61b02876, 0x534ef1b5, 0x612dc447,
    0x53e73097, 0x60aa7050, 0x547ea073, 0x60262dd6, 0x55153fd4, 0x5fa0fe1f, 0x55ab0d46, 0x5f1ae274,
    0x56400758, 0x5e93dc1f, 0x56d42c99, 0x5e0bec6e, 0x57677b9d, 0x5d8314b1, 0x57f9f2f8, 0x5cf95638,
    0x588b9140, 0x5c6eb258, 0x591c550e, 0x5be32a67, 0x59ac3cfd, 0x5b56bfbd, 0x5a3b47ab, 0x5ac973b5,

    /* 512 point window */
    0x003243f5, 0x7ffff621, 0x0096cbc1, 0x7fffa72c, 0x00fb5330, 0x7fff0943, 0x015fda03, 0x7ffe1c65,
    0x01c45ffe, 0x7ffce093, 0x0228e4e2, 0x7ffb55ce, 0x028d6870, 0x7ff97c18, 0x02f1ea6c, 0x7ff75370,
    0x03566a96, 0x7ff4dbd9, 0x03bae8b2, 0x7ff21553, 0x041f6480, 0x7feeffe1, 0x0483ddc3, 0x7feb9b85,
    0x04e8543e, 0x7fe7e841, 0x054cc7b1, 0x7fe3e616, 0x05b137df, 0x7fdf9508, 0x0615a48b, 0x7fdaf519,
    0x067a0d76, 0x7fd6064c, 0x06de7262, 0x7fd0c8a3, 0x0742d311, 0x7fcb3c23, 0x07a72f45, 0x7fc560cf,
    0x080b86c2, 0x7fbf36aa, 0x086fd947, 0x7fb8bdb8, 0x08d42699, 0x7fb1f5fc, 0x09386e78, 0x7faadf7c,
    0x099cb0a7, 0x7fa37a3c, 0x0a00ece8, 0x7f9bc640, 0x0a6522fe, 0x7f93c38c, 0x0ac952aa, 0x7f8b7227,
    0x0b2d7baf, 0x7f82d214, 0x0b919dcf, 0x7f79e35a, 0x0bf5b8cb, 0x7f70a5fe, 0x0c59cc68, 0x7f671a05,
    0x0cbdd865, 0x7f5d3f75, 0x0d21dc87, 0x7f531655, 0x0d85d88f, 0x7f489eaa, 0x0de9cc40, 0x7f3dd87c,
    0x0e4db75b, 0x7f32c3d1, 0x0eb199a4, 0x7f2760af, 0x0f1572dc, 0x7f1baf1e, 0x0f7942c7, 0x7f0faf25,
    0x0fdd0926, 0x7f0360cb, 0x1040c5bb, 0x7ef6c418, 0x10a4784b, 0x7ee9d914, 0x11082096, 0x7edc9fc6,
    0x116bbe60, 0x7ecf1837, 0x11cf516a, 0x7ec14270, 0x1232d979, 0x7eb31e78, 0x1296564d, 0x7ea4ac58,
    0x12f9c7aa, 0x7e95ec1a, 0x135d2d53, 0x7e86ddc6, 0x13c0870a, 0x7e778166, 0x1423d492, 0x7e67d703,
    0x148715ae, 0x7e57dea7, 0x14ea4a1f, 0x7e47985b, 0x154d71aa, 0x7e37042a, 0x15b08c12, 0x7e26221f,
    0x16139918, 0x7e14f242, 0x1676987f, 0x7e0374a0, 0x16d98a0c, 0x7df1a942, 0x173c6d80, 0x7ddf9034,
    0x179f429f, 0x7dcd2981, 0x1802092c, 0x7dba7534, 0x1864c0ea, 0x7da77359, 0x18c7699b, 0x7d9423fc,
    0x192a0304, 0x7d808728, 0x198c8ce7, 0x7d6c9ce9, 0x19ef0707, 0x7d58654d, 0x1a517128, 0x7d43e05e,
    0x1ab3cb0d, 0x7d2f0e2b, 0x1b161479, 0x7d19eebf, 0x1b784d30, 0x7d048228, 0x1bda74f6, 0x7ceec873,
    0x1c3c8b8c, 0x7cd8c1ae, 0x1c9e90b8, 0x7cc26de5, 0x1d00843d, 0x7cabcd28, 0x1d6265dd, 0x7c94df83,
    0x1dc4355e, 0x7c7da505, 0x1e25f282, 0x7c661dbc, 0x1e879d0d, 0x7c4e49b7, 0x1ee934c3, 0x7c362904,
    0x1f4ab968, 0x7c1dbbb3, 0x1fac2abf, 0x7c0501d2, 0x200d888d, 0x7bebfb70, 0x206ed295, 0x7bd2a89e,
    0x20d0089c, 0x7bb9096b, 0x21312a65, 0x7b9f1de6, 0x219237b5, 0x7b84e61f, 0x21f3304f, 0x7b6a6227,
    0x225413f8, 0x7b4f920e, 0x22b4e274, 0x7b3475e5, 0x23159b88, 0x7b190dbc, 0x23763ef7, 0x7afd59a4,
    0x23d6cc87, 0x7ae159ae, 0x243743fa, 0x7ac50dec, 0x2497a517, 0x7aa8766f, 0x24f7efa2, 0x7a8b9348,
    0x2558235f, 0x7a6e648a, 0x25b84012, 0x7a50ea47, 0x26184581, 0x7a332490, 0x26783370, 0x7a151378,
    0x26d809a5, 0x79f6b711, 0x2737c7e3, 0x79d80f6f, 0x27976df1, 0x79b91ca4, 0x27f6fb92, 0x7999dec4,
    0x2856708d, 0x797a55e0, 0x28b5cca5, 0x795a820e, 0x29150fa1, 0x793a6361, 0x29743946, 0x7919f9ec,
    0x29d34958, 0x78f945c3, 0x2a323f9e, 0x78d846fb, 0x2a911bdc, 0x78b6fda8, 0x2aefddd8, 0x789569df,
    0x2b4e8558, 0x78738bb3, 0x2bad1221, 0x7851633b, 0x2c0b83fa, 0x782ef08b, 0x2c69daa6, 0x780c33b8,
    0x2cc815ee, 0x77e92cd9, 0x2d263596, 0x77c5dc01, 0x2d843964, 0x77a24148, 0x2de2211e, 0x777e5cc3,
    0x2e3fec8b, 0x775a2e89, 0x2e9d9b70, 0x7735b6af, 0x2efb2d95, 0x7710f54c, 0x2f58a2be, 0x76ebea77,
    0x2fb5fab2, 0x76c69647, 0x30133539, 0x76a0f8d2, 0x30705217, 0x767b1231, 0x30cd5115, 0x7654e279,
    0x312a31f8, 0x762e69c4, 0x3186f487, 0x7607a828, 0x31e39889, 0x75e09dbd, 0x32401dc6, 0x75b94a9c,
    0x329c8402, 0x7591aedd, 0x32f8cb07, 0x7569ca99, 0x3354f29b, 0x75419de7, 0x33b0fa84, 0x751928e0,
    0x340ce28b, 0x74f06b9e, 0x3468aa76, 0x74c7663a, 0x34c4520d, 0x749e18cd, 0x351fd918, 0x74748371,
    0x357b3f5d, 0x744aa63f, 0x35d684a6, 0x74208150, 0x3631a8b8, 0x73f614c0, 0x368cab5c, 0x73cb60a8,
    0x36e78c5b, 0x73a06522, 0x37424b7b, 0x73752249, 0x379ce885, 0x73499838, 0x37f76341, 0x731dc70a,
    0x3851bb77, 0x72f1aed9, 0x38abf0ef, 0x72c54fc1, 0x39060373, 0x7298a9dd, 0x395ff2c9, 0x726bbd48,
    0x39b9bebc, 0x723e8a20, 0x3a136712, 0x7211107e, 0x3a6ceb96, 0x71e35080, 0x3ac64c0f, 0x71b54a41,
    0x3b1f8848, 0x7186fdde, 0x3b78a007, 0x71586b74, 0x3bd19318, 0x7129931f, 0x3c2a6142, 0x70fa74fc,
    0x3c830a50, 0x70cb1128, 0x3cdb8e09, 0x709b67c0, 0x3d33ec39, 0x706b78e3, 0x3d8c24a8, 0x703b44ad,
    0x3de4371f, 0x700acb3c, 0x3e3c2369, 0x6fda0cae, 0x3e93e950, 0x6fa90921, 0x3eeb889c, 0x6f77c0b3,
    0x3f430119, 0x6f463383, 0x3f9a5290, 0x6f1461b0, 0x3ff17cca, 0x6ee24b57, 0x40487f94, 0x6eaff099,
    0x409f5ab6, 0x6e7d5193, 0x40f60dfb, 0x6e4a6e66, 0x414c992f, 0x6e174730, 0x41a2fc1a, 0x6de3dc11,
    0x41f93689, 0x6db02d29, 0x424f4845, 0x6d7c3a98, 0x42a5311b, 0x6d48047e, 0x42faf0d4, 0x6d138afb,
    0x4350873c, 0x6cdece2f, 0x43a5f41e, 0x6ca9ce3b, 0x43fb3746, 0x6c748b3f, 0x4450507e, 0x6c3f055d,
    0x44a53f93, 0x6c093cb6, 0x44fa0450, 0x6bd3316a, 0x454e9e80, 0x6b9ce39b, 0x45a30df0, 0x6b66536b,
    0x45f7526b, 0x6b2f80fb, 0x464b6bbe, 0x6af86c6c, 0x469f59b4, 0x6ac115e2, 0x46f31c1a, 0x6a897d7d,
    0x4746b2bc, 0x6a51a361, 0x479a1d67, 0x6a1987b0, 0x47ed5be6, 0x69e12a8c, 0x48406e08, 0x69a88c19,
    0x48935397, 0x696fac78, 0x48e60c62, 0x69368bce, 0x49389836, 0x68fd2a3d, 0x498af6df, 0x68c387e9,
    0x49dd282a, 0x6889a4f6, 0x4a2f2be6, 0x684f8186, 0x4a8101de, 0x68151dbe, 0x4ad2a9e2, 0x67da79c3,
    0x4b2423be, 0x679f95b7, 0x4b756f40, 0x676471c0, 0x4bc68c36, 0x67290e02, 0x4c177a6e, 0x66ed6aa1,
    0x4c6839b7, 0x66b187c3, 0x4cb8c9dd, 0x6675658c, 0x4d092ab0, 0x66390422, 0x4d595bfe, 0x65fc63a9,
    0x4da95d96, 0x65bf8447, 0x4df92f46, 0x65826622, 0x4e48d0dd, 0x6545095f, 0x4e984229, 0x65076e25,
    0x4ee782fb, 0x64c99498, 0x4f369320, 0x648b7ce0, 0x4f857269, 0x644d2722, 0x4fd420a4, 0x640e9386,
    0x50229da1, 0x63cfc231, 0x5070e92f, 0x6390b34a, 0x50bf031f, 0x635166f9, 0x510ceb40, 0x6311dd64,
    0x515aa162, 0x62d216b3, 0x51a82555, 0x6292130c, 0x51f576ea, 0x6251d298, 0x524295f0, 0x6211557e,
    0x528f8238, 0x61d09be5, 0x52dc3b92, 0x618fa5f7, 0x5328c1d0, 0x614e73da, 0x537514c2, 0x610d05b7,
    0x53c13439, 0x60cb5bb7, 0x540d2005, 0x60897601, 0x5458d7f9, 0x604754bf, 0x54a45be6, 0x6004f819,
    0x54efab9c, 0x5fc26038, 0x553ac6ee, 0x5f7f8d46, 0x5585adad, 0x5f3c7f6b, 0x55d05faa, 0x5ef936d1,
    0x561adcb9, 0x5eb5b3a2, 0x566524aa, 0x5e71f606, 0x56af3750, 0x5e2dfe29, 0x56f9147e, 0x5de9cc33,
    0x5742bc06, 0x5da5604f, 0x578c2dba, 0x5d60baa7, 0x57d5696d, 0x5d1bdb65, 0x581e6ef1, 0x5cd6c2b5,
    0x58673e1b, 0x5c9170bf, 0x58afd6bd, 0x5c4be5b0, 0x58f838a9, 0x5c0621b2, 0x594063b5, 0x5bc024f0,
    0x598857b2, 0x5b79ef96, 0x59d01475, 0x5b3381ce, 0x5a1799d1, 0x5aecdbc5, 0x5a5ee79a, 0x5aa5fda5,

    /* 1024 point window */
    0x001921fb, 0x7ffffd88, 0x004b65ee, 0x7fffe9cb, 0x007da9d4, 0x7fffc251, 0x00afeda8, 0x7fff8719,
    0x00e23160, 0x7fff3824, 0x011474f6, 0x7ffed572, 0x0146b860, 0x7ffe5f03, 0x0178fb99, 0x7ffdd4d7,
    0x01ab3e97, 0x7ffd36ee, 0x01dd8154, 0x7ffc8549, 0x020fc3c6, 0x7ffbbfe6, 0x024205e8, 0x7ffae6c7,
    0x027447b0, 0x7ff9f9ec, 0x02a68917, 0x7ff8f954, 0x02d8ca16, 0x7ff7e500, 0x030b0aa4, 0x7ff6bcf0,
    0x033d4abb, 0x7ff58125, 0x036f8a51, 0x7ff4319d, 0x03a1c960, 0x7ff2ce5b, 0x03d407df, 0x7ff1575d,
    0x040645c7, 0x7fefcca4, 0x04388310, 0x7fee2e30, 0x046abfb3, 0x7fec7c02, 0x049cfba7, 0x7feab61a,
    0x04cf36e5, 0x7fe8dc78, 0x05017165, 0x7fe6ef1c, 0x0533ab20, 0x7fe4ee06, 0x0565e40d, 0x7fe2d938,
    0x05981c26, 0x7fe0b0b1, 0x05ca5361, 0x7fde7471, 0x05fc89b8, 0x7fdc247a, 0x062ebf22, 0x7fd9c0ca,
    0x0660f398, 0x7fd74964, 0x06932713, 0x7fd4be46, 0x06c5598a, 0x7fd21f72, 0x06f78af6, 0x7fcf6ce8,
    0x0729bb4e, 0x7fcca6a7, 0x075bea8c, 0x7fc9ccb2, 0x078e18a7, 0x7fc6df08, 0x07c04598, 0x7fc3dda9,
    0x07f27157, 0x7fc0c896, 0x08249bdd, 0x7fbd9fd0, 0x0856c520, 0x7fba6357, 0x0888ed1b, 0x7fb7132b,
    0x08bb13c5, 0x7fb3af4e, 0x08ed3916, 0x7fb037bf, 0x091f5d06, 0x7facac7f, 0x09517f8f, 0x7fa90d8e,
    0x0983a0a7, 0x7fa55aee, 0x09b5c048, 0x7fa1949e, 0x09e7de6a, 0x7f9dbaa0, 0x0a19fb04, 0x7f99ccf4,
    0x0a4c1610, 0x7f95cb9a, 0x0a7e2f85, 0x7f91b694, 0x0ab0475c, 0x7f8d8de1, 0x0ae25d8d, 0x7f895182,
    0x0b147211, 0x7f850179, 0x0b4684df, 0x7f809dc5, 0x0b7895f0, 0x7f7c2668, 0x0baaa53b, 0x7f779b62,
    0x0bdcb2bb, 0x7f72fcb4, 0x0c0ebe66, 0x7f6e4a5e, 0x0c40c835, 0x7f698461, 0x0c72d020, 0x7f64aabf,
    0x0ca4d620, 0x7f5fbd77, 0x0cd6da2d, 0x7f5abc8a, 0x0d08dc3f, 0x7f55a7fa, 0x0d3adc4e, 0x7f507fc7,
    0x0d6cda53, 0x7f4b43f2, 0x0d9ed646, 0x7f45f47b, 0x0dd0d01f, 0x7f409164, 0x0e02c7d7, 0x7f3b1aad,
    0x0e34bd66, 0x7f359057, 0x0e66b0c3, 0x7f2ff263, 0x0e98a1e9, 0x7f2a40d2, 0x0eca90ce, 0x7f247ba5,
    0x0efc7d6b, 0x7f1ea2dc, 0x0f2e67b8, 0x7f18b679, 0x0f604faf, 0x7f12b67c, 0x0f923546, 0x7f0ca2e7,
    0x0fc41876, 0x7f067bba, 0x0ff5f938, 0x7f0040f6, 0x1027d784, 0x7ef9f29d, 0x1059b352, 0x7ef390ae,
    0x108b8c9b, 0x7eed1b2c, 0x10bd6356, 0x7ee69217, 0x10ef377d, 0x7edff570, 0x11210907, 0x7ed94538,
    0x1152d7ed, 0x7ed28171, 0x1184a427, 0x7ecbaa1a, 0x11b66dad, 0x7ec4bf36, 0x11e83478, 0x7ebdc0c6,
    0x1219f880, 0x7eb6aeca, 0x124bb9be, 0x7eaf8943, 0x127d7829, 0x7ea85033, 0x12af33ba, 0x7ea1039b,
    0x12e0ec6a, 0x7e99a37c, 0x1312a230, 0x7e922fd6, 0x13445505, 0x7e8aa8ac, 0x137604e2, 0x7e830dff,
    0x13a7b1bf, 0x7e7b5fce, 0x13d95b93, 0x7e739e1d, 0x140b0258, 0x7e6bc8eb, 0x143ca605, 0x7e63e03b,
    0x146e4694, 0x7e5be40c, 0x149fe3fc, 0x7e53d462, 0x14d17e36, 0x7e4bb13c, 0x1503153a, 0x7e437a9c,
    0x1534a901, 0x7e3b3083, 0x15663982, 0x7e32d2f4, 0x1597c6b7, 0x7e2a61ed, 0x15c95097, 0x7e21dd73,
    0x15fad71b, 0x7e194584, 0x162c5a3b, 0x7e109a24, 0x165dd9f0, 0x7e07db52, 0x168f5632, 0x7dff0911,
    0x16c0cef9, 0x7df62362, 0x16f2443e, 0x7ded2a47, 0x1723b5f9, 0x7de41dc0, 0x17552422, 0x7ddafdce,
    0x17868eb3, 0x7dd1ca75, 0x17b7f5a3, 0x7dc883b4, 0x17e958ea, 0x7dbf298d, 0x181ab881, 0x7db5bc02,
    0x184c1461, 0x7dac3b15, 0x187d6c82, 0x7da2a6c6, 0x18aec0db, 0x7d98ff17, 0x18e01167, 0x7d8f4409,
    0x19115e1c, 0x7d85759f, 0x1942a6f3, 0x7d7b93da, 0x1973ebe6, 0x7d719eba, 0x19a52ceb, 0x7d679642,
    0x19d669fc, 0x7d5d7a74, 0x1a07a311, 0x7d534b50, 0x1a38d823, 0x7d4908d9, 0x1a6a0929, 0x7d3eb30f,
    0x1a9b361d, 0x7d3449f5, 0x1acc5ef6, 0x7d29cd8c, 0x1afd83ad, 0x7d1f3dd6, 0x1b2ea43a, 0x7d149ad5,
    0x1b5fc097, 0x7d09e489, 0x1b90d8bb, 0x7cff1af5, 0x1bc1ec9e, 0x7cf43e1a, 0x1bf2fc3a, 0x7ce94dfb,
    0x1c240786, 0x7cde4a98, 0x1c550e7c, 0x7cd333f3, 0x1c861113, 0x7cc80a0f, 0x1cb70f43, 0x7cbcccec,
    0x1ce80906, 0x7cb17c8d, 0x1d18fe54, 0x7ca618f3, 0x1d49ef26, 0x7c9aa221, 0x1d7adb73, 0x7c8f1817,
    0x1dabc334, 0x7c837ad8, 0x1ddca662, 0x7c77ca65, 0x1e0d84f5, 0x7c6c06c0, 0x1e3e5ee5, 0x7c602fec,
    0x1e6f342c, 0x7c5445e9, 0x1ea004c1, 0x7c4848ba, 0x1ed0d09d, 0x7c3c3860, 0x1f0197b8, 0x7c3014de,
    0x1f325a0b, 0x7c23de35, 0x1f63178f, 0x7c179467, 0x1f93d03c, 0x7c0b3777, 0x1fc4840a, 0x7bfec765,
    0x1ff532f2, 0x7bf24434, 0x2025dcec, 0x7be5ade6, 0x205681f1, 0x7bd9047c, 0x208721f9, 0x7bcc47fa,
    0x20b7bcfe, 0x7bbf7860, 0x20e852f6, 0x7bb295b0, 0x2118e3dc, 0x7ba59fee, 0x21496fa7, 0x7b989719,
    0x2179f64f, 0x7b8b7b36, 0x21aa77cf, 0x7b7e4c45, 0x21daf41d, 0x7b710a49, 0x220b6b32, 0x7b63b543,
    0x223bdd08, 0x7b564d36, 0x226c4996, 0x7b48d225, 0x229cb0d5, 0x7b3b4410, 0x22cd12bd, 0x7b2da2fa,
    0x22fd6f48, 0x7b1feee5, 0x232dc66d, 0x7b1227d3, 0x235e1826, 0x7b044dc7, 0x238e646a, 0x7af660c2,
    0x23beab33, 0x7ae860c7, 0x23eeec78, 0x7ada4dd8, 0x241f2833, 0x7acc27f7, 0x244f5e5c, 0x7abdef25,
    0x247f8eec, 0x7aafa367, 0x24afb9da, 0x7aa144bc, 0x24dfdf20, 0x7a92d329, 0x250ffeb7, 0x7a844eae,
    0x25401896, 0x7a75b74f, 0x25702cb7, 0x7a670d0d, 0x25a03b11, 0x7a584feb, 0x25d0439f, 0x7a497feb,
    0x26004657, 0x7a3a9d0f, 0x26304333, 0x7a2ba75a, 0x26603a2c, 0x7a1c9ece, 0x26902b39, 0x7a0d836d,
    0x26c01655, 0x79fe5539, 0x26effb76, 0x79ef1436, 0x271fda96, 0x79dfc064, 0x274fb3ae, 0x79d059c8,
    0x277f86b5, 0x79c0e062, 0x27af53a6, 0x79b15435, 0x27df1a77, 0x79a1b545, 0x280edb23, 0x79920392,
    0x283e95a1, 0x79823f20, 0x286e49ea, 0x797267f2, 0x289df7f8, 0x79627e08, 0x28cd9fc1, 0x79528167,
    0x28fd4140, 0x79427210, 0x292cdc6d, 0x79325006, 0x295c7140, 0x79221b4b, 0x298bffb2, 0x7911d3e2,
    0x29bb87bc, 0x790179cd, 0x29eb0957, 0x78f10d0f, 0x2a1a847b, 0x78e08dab, 0x2a49f920, 0x78cffba3,
    0x2a796740, 0x78bf56f9, 0x2aa8ced3, 0x78ae9fb0, 0x2ad82fd2, 0x789dd5cb, 0x2b078a36, 0x788cf94c,
    0x2b36ddf7, 0x787c0a36, 0x2b662b0e, 0x786b088c, 0x2b957173, 0x7859f44f, 0x2bc4b120, 0x7848cd83,
    0x2bf3ea0d, 0x7837942b, 0x2c231c33, 0x78264849, 0x2c52478a, 0x7814e9df, 0x2c816c0c, 0x780378f1,
    0x2cb089b1, 0x77f1f581, 0x2cdfa071, 0x77e05f91, 0x2d0eb046, 0x77ceb725, 0x2d3db928, 0x77bcfc3f,
    0x2d6cbb10, 0x77ab2ee2, 0x2d9bb5f6, 0x77994f11, 0x2dcaa9d5, 0x77875cce, 0x2df996a3, 0x7775581d,
    0x2e287c5a, 0x776340ff, 0x2e575af3, 0x77511778, 0x2e863267, 0x773edb8b, 0x2eb502ae, 0x772c8d3a,
    0x2ee3cbc1, 0x771a2c88, 0x2f128d99, 0x7707b979, 0x2f41482e, 0x76f5340e, 0x2f6ffb7a, 0x76e29c4b,
    0x2f9ea775, 0x76cff232, 0x2fcd4c19, 0x76bd35c7, 0x2ffbe95d, 0x76aa670d, 0x302a7f3a, 0x76978605,
    0x30590dab, 0x768492b4, 0x308794a6, 0x76718d1c, 0x30b61426, 0x765e7540, 0x30e48c22, 0x764b4b23,
    0x3112fc95, 0x76380ec8, 0x31416576, 0x7624c031, 0x316fc6be, 0x76115f63, 0x319e2067, 0x75fdec60,
    0x31cc7269, 0x75ea672a, 0x31fabcbd, 0x75d6cfc5, 0x3228ff5c, 0x75c32634, 0x32573a3f, 0x75af6a7b,
    0x32856d5e, 0x759b9c9b, 0x32b398b3, 0x7587bc98, 0x32e1bc36, 0x7573ca75, 0x330fd7e1, 0x755fc635,
    0x333debab, 0x754bafdc, 0x336bf78f, 0x7537876c, 0x3399fb85, 0x75234ce8, 0x33c7f785, 0x750f0054,
    0x33f5eb89, 0x74faa1b3, 0x3423d78a, 0x74e63108, 0x3451bb81, 0x74d1ae55, 0x347f9766, 0x74bd199f,
    0x34ad6b32, 0x74a872e8, 0x34db36df, 0x7493ba34, 0x3508fa66, 0x747eef85, 0x3536b5be, 0x746a12df,
    0x356468e2, 0x74552446, 0x359213c9, 0x744023bc, 0x35bfb66e, 0x742b1144, 0x35ed50c9, 0x7415ece2,
    0x361ae2d3, 0x7400b69a, 0x36486c86, 0x73eb6e6e, 0x3675edd9, 0x73d61461, 0x36a366c6, 0x73c0a878,
    0x36d0d746, 0x73ab2ab4, 0x36fe3f52, 0x73959b1b, 0x372b9ee3, 0x737ff9ae, 0x3758f5f2, 0x736a4671,
    0x37864477, 0x73548168, 0x37b38a6d, 0x733eaa96, 0x37e0c7cc, 0x7328c1ff, 0x380dfc8d, 0x7312c7a5,
    0x383b28a9, 0x72fcbb8c, 0x38684c19, 0x72e69db7, 0x389566d6, 0x72d06e2b, 0x38c278d9, 0x72ba2cea,
    0x38ef821c, 0x72a3d9f7, 0x391c8297, 0x728d7557, 0x39497a43, 0x7276ff0d, 0x39766919, 0x7260771b,
    0x39a34f13, 0x7249dd86, 0x39d02c2a, 0x72333251, 0x39fd0056, 0x721c7580, 0x3a29cb91, 0x7205a716,
    0x3a568dd4, 0x71eec716, 0x3a834717, 0x71d7d585, 0x3aaff755, 0x71c0d265, 0x3adc9e86, 0x71a9bdba,
    0x3b093ca3, 0x71929789, 0x3b35d1a5, 0x717b5fd3, 0x3b625d86, 0x7164169d, 0x3b8ee03e, 0x714cbbeb,
    0x3bbb59c7, 0x71354fc0, 0x3be7ca1a, 0x711dd220, 0x3c143130, 0x7106430e, 0x3c408f03, 0x70eea28e,
    0x3c6ce38a, 0x70d6f0a4, 0x3c992ec0, 0x70bf2d53, 0x3cc5709e, 0x70a7589f, 0x3cf1a91c, 0x708f728b,
    0x3d1dd835, 0x70777b1c, 0x3d49fde1, 0x705f7255, 0x3d761a19, 0x70475839, 0x3da22cd7, 0x702f2ccd,
    0x3dce3614, 0x7016f014, 0x3dfa35c8, 0x6ffea212, 0x3e262bee, 0x6fe642ca, 0x3e52187f, 0x6fcdd241,
    0x3e7dfb73, 0x6fb5507a, 0x3ea9d4c3, 0x6f9cbd79, 0x3ed5a46b, 0x6f841942, 0x3f016a61, 0x6f6b63d8,
    0x3f2d26a0, 0x6f529d40, 0x3f58d921, 0x6f39c57d, 0x3f8481dd, 0x6f20dc92, 0x3fb020ce, 0x6f07e285,
    0x3fdbb5ec, 0x6eeed758, 0x40074132, 0x6ed5bb10, 0x4032c297, 0x6ebc8db0, 0x405e3a16, 0x6ea34f3d,
    0x4089a7a8, 0x6e89ffb9, 0x40b50b46, 0x6e709f2a, 0x40e064ea, 0x6e572d93, 0x410bb48c, 0x6e3daaf8,
    0x4136fa27, 0x6e24175c, 0x416235b2, 0x6e0a72c5, 0x418d6729, 0x6df0bd35, 0x41b88e84, 0x6dd6f6b1,
    0x41e3abbc, 0x6dbd1f3c, 0x420ebecb, 0x6da336dc, 0x4239c7aa, 0x6d893d93, 0x4264c653, 0x6d6f3365,
    0x428fbabe, 0x6d551858, 0x42baa4e6, 0x6d3aec6e, 0x42e584c3, 0x6d20afac, 0x43105a50, 0x6d066215,
    0x433b2585, 0x6cec03af, 0x4365e65b, 0x6cd1947c, 0x43909ccd, 0x6cb71482, 0x43bb48d4, 0x6c9c83c3,
    0x43e5ea68, 0x6c81e245, 0x44108184, 0x6c67300b, 0x443b0e21, 0x6c4c6d1a, 0x44659039, 0x6c319975,
    0x449007c4, 0x6c16b521, 0x44ba74bd, 0x6bfbc021, 0x44e4d71c, 0x6be0ba7b, 0x450f2edb, 0x6bc5a431,
    0x45397bf4, 0x6baa7d49, 0x4563be60, 0x6b8f45c7, 0x458df619, 0x6b73fdae, 0x45b82318, 0x6b58a503,
    0x45e24556, 0x6b3d3bcb, 0x460c5cce, 0x6b21c208, 0x46366978, 0x6b0637c1, 0x46606b4e, 0x6aea9cf8,
    0x468a624a, 0x6acef1b2, 0x46b44e65, 0x6ab335f4, 0x46de2f99, 0x6a9769c1, 0x470805df, 0x6a7b8d1e,
    0x4731d131, 0x6a5fa010, 0x475b9188, 0x6a43a29a, 0x478546de, 0x6a2794c1, 0x47aef12c, 0x6a0b7689,
    0x47d8906d, 0x69ef47f6, 0x48022499, 0x69d3090e, 0x482badab, 0x69b6b9d3, 0x48552b9b, 0x699a5a4c,
    0x487e9e64, 0x697dea7b, 0x48a805ff, 0x69616a65, 0x48d16265, 0x6944da10, 0x48fab391, 0x6928397e,
    0x4923f97b, 0x690b88b5, 0x494d341e, 0x68eec7b9, 0x49766373, 0x68d1f68f, 0x499f8774, 0x68b5153a,
    0x49c8a01b, 0x689823bf, 0x49f1ad61, 0x687b2224, 0x4a1aaf3f, 0x685e106c, 0x4a43a5b0, 0x6840ee9b,
    0x4a6c90ad, 0x6823bcb7, 0x4a957030, 0x68067ac3, 0x4abe4433, 0x67e928c5, 0x4ae70caf, 0x67cbc6c0,
    0x4b0fc99d, 0x67ae54ba, 0x4b387af9, 0x6790d2b6, 0x4b6120bb, 0x677340ba, 0x4b89badd, 0x67559eca,
    0x4bb24958, 0x6737ecea, 0x4bdacc28, 0x671a2b20, 0x4c034345, 0x66fc596f, 0x4c2baea9, 0x66de77dc,
    0x4c540e4e, 0x66c0866d, 0x4c7c622d, 0x66a28524, 0x4ca4aa41, 0x66847408, 0x4ccce684, 0x6666531d,
    0x4cf516ee, 0x66482267, 0x4d1d3b7a, 0x6629e1ec, 0x4d455422, 0x660b91af, 0x4d6d60df, 0x65ed31b5,
    0x4d9561ac, 0x65cec204, 0x4dbd5682, 0x65b0429f, 0x4de53f5a, 0x6591b38c, 0x4e0d1c30, 0x657314cf,
    0x4e34ecfc, 0x6554666d, 0x4e5cb1b9, 0x6535a86b, 0x4e846a60, 0x6516dacd, 0x4eac16eb, 0x64f7fd98,
    0x4ed3b755, 0x64d910d1, 0x4efb4b96, 0x64ba147d, 0x4f22d3aa, 0x649b08a0, 0x4f4a4f89, 0x647bed3f,
    0x4f71bf2e, 0x645cc260, 0x4f992293, 0x643d8806, 0x4fc079b1, 0x641e3e38, 0x4fe7c483, 0x63fee4f8,
    0x500f0302, 0x63df7c4d, 0x50363529, 0x63c0043b, 0x505d5af1, 0x63a07cc7, 0x50847454, 0x6380e5f6,
    0x50ab814d, 0x63613fcd, 0x50d281d5, 0x63418a50, 0x50f975e6, 0x6321c585, 0x51205d7b, 0x6301f171,
    0x5147388c, 0x62e20e17, 0x516e0715, 0x62c21b7e, 0x5194c910, 0x62a219aa, 0x51bb7e75, 0x628208a1,
    0x51e22740, 0x6261e866, 0x5208c36a, 0x6241b8ff, 0x522f52ee, 0x62217a72, 0x5255d5c5, 0x62012cc2,
    0x527c4bea, 0x61e0cff5, 0x52a2b556, 0x61c06410, 0x52c91204, 0x619fe918, 0x52ef61ee, 0x617f5f12,
    0x5315a50e, 0x615ec603, 0x533bdb5d, 0x613e1df0, 0x536204d7, 0x611d66de, 0x53882175, 0x60fca0d2,
    0x53ae3131, 0x60dbcbd1, 0x53d43406, 0x60bae7e1, 0x53fa29ed, 0x6099f505, 0x542012e1, 0x6078f344,
    0x5445eedb, 0x6057e2a2, 0x546bbdd7, 0x6036c325, 0x54917fce, 0x601594d1, 0x54b734ba, 0x5ff457ad,
    0x54dcdc96, 0x5fd30bbc, 0x5502775c, 0x5fb1b104, 0x55280505, 0x5f90478a, 0x554d858d, 0x5f6ecf53,
    0x5572f8ed, 0x5f4d4865, 0x55985f20, 0x5f2bb2c5, 0x55bdb81f, 0x5f0a0e77, 0x55e303e6, 0x5ee85b82,
    0x5608426e, 0x5ec699e9, 0x562d73b2, 0x5ea4c9b3, 0x565297ab, 0x5e82eae5, 0x5677ae54, 0x5e60fd84,
    0x569cb7a8, 0x5e3f0194, 0x56c1b3a1, 0x5e1cf71c, 0x56e6a239, 0x5dfade20, 0x570b8369, 0x5dd8b6a7,
    0x5730572e, 0x5db680b4, 0x57551d80, 0x5d943c4e, 0x5779d65b, 0x5d71e979, 0x579e81b8, 0x5d4f883b,
    0x57c31f92, 0x5d2d189a, 0x57e7afe4, 0x5d0a9a9a, 0x580c32a7, 0x5ce80e41, 0x5830a7d6, 0x5cc57394,
    0x58550f6c, 0x5ca2ca99, 0x58796962, 0x5c801354, 0x589db5b3, 0x5c5d4dcc, 0x58c1f45b, 0x5c3a7a05,
    0x58e62552, 0x5c179806, 0x590a4893, 0x5bf4a7d2, 0x592e5e19, 0x5bd1a971, 0x595265df, 0x5bae9ce7,
    0x59765fde, 0x5b8b8239, 0x599a4c12, 0x5b68596d, 0x59be2a74, 0x5b452288, 0x59e1faff, 0x5b21dd90,
    0x5a05bdae, 0x5afe8a8b, 0x5a29727b, 0x5adb297d, 0x5a4d1960, 0x5ab7ba6c, 0x5a70b258, 0x5a943d5e,
};

/* bit reverse tables for FFT */

const int bitrevtabOffset[3] = {0, 33, 98};

const unsigned char bitrevtab[33 + 65 + 129] = {
    /* bitrevtab0[33] */
    0x1, 0x10, 0x2, 0x8, 0x3, 0x18, 0x5, 0x14, 0x6, 0xc, 0x7, 0x1c, 0x9, 0x12, 0xb, 0x1a,
    0xd, 0x16, 0xf, 0x1e, 0x13, 0x19, 0x17, 0x1d, 0x0, 0x4, 0xa, 0xe, 0x11, 0x15, 0x1b, 0x1f, 0x0,

    /* bitrevtab1[65] */
    0x1, 0x20, 0x2, 0x10, 0x3, 0x30, 0x4, 0x8, 0x5, 0x28, 0x6, 0x18, 0x7, 0x38, 0x9, 0x24,
    0xa, 0x14, 0xb, 0x34, 0xd, 0x2c, 0xe, 0x1c, 0xf, 0x3c, 0x11, 0x22, 0x13, 0x32, 0x15, 0x2a,
    0x16, 0x1a, 0x17, 0x3a, 0x19, 0x26, 0x1b, 0x36, 0x1d, 0x2e, 0x1f, 0x3e, 0x23, 0x31, 0x25, 0x29,
    0x27, 0x39, 0x2b, 0x35, 0x2f, 0x3d, 0x37, 0x3b, 0x0, 0xc, 0x12, 0x1e, 0x21, 0x2d, 0x33, 0x3f, 0x0,

    /* bitrevtab2[129] */
    0x1, 0x40, 0x2, 0x20, 0x3, 0x60, 0x4, 0x10, 0x5, 0x50, 0x6, 0x30, 0x7, 0x70, 0x9, 0x48,
    0xa, 0x28, 0xb, 0x68, 0xc, 0x18, 0xd, 0x58, 0xe, 0x38, 0xf, 0x78, 0x11, 0x44, 0x12, 0x24,
    0x13, 0x64, 0x15, 0x54, 0x16, 0x34, 0x17, 0x74, 0x19, 0x4c, 0x1a, 0x2c, 0x1b, 0x6c, 0x1d, 0x5c,
    0x1e, 0x3c, 0x1f, 0x7c, 0x21, 0x42, 0x23, 0x62, 0x25, 0x52, 0x26, 0x32, 0x27, 0x72, 0x29, 0x4a,
    0x2b, 0x6a, 0x2d, 0x5a, 0x2e, 0x3a, 0x2f, 0x7a, 0x31, 0x46, 0x33, 0x66, 0x35, 0x56, 0x37, 0x76,
    0x39, 0x4e, 0x3b, 0x6e, 0x3d, 0x5e, 0x3f, 0x7e, 0x43, 0x61, 0x45, 0x51, 0x47, 0x71, 0x4b, 0x69,
    0x4d, 0x59, 0x4f, 0x79, 0x53, 0x65, 0x57, 0x75, 0x5b, 0x6d, 0x5f, 0x7d, 0x67, 0x73, 0x6f, 0x7b,
    0x0, 0x8, 0x14, 0x1c, 0x22, 0x2a, 0x36, 0x3e, 0x41, 0x49, 0x55, 0x5d, 0x63, 0x6b, 0x77, 0x7f, 0x0,
};

const unsigned char uniqueIDTab[8] = {0x5f, 0x4b, 0x43, 0x5f, 0x5f, 0x4a, 0x52, 0x5f};

/* Twiddle tables for FFT
 * format = Q31
 *
 * for (k = 4; k <= N/4; k <<= 1) {
 *   for (j = 0; j < k; j++) {
 *     double wr1, wi1, wr2, wi2, wr3, wi3;
 *
 *     wr1 = cos(1.0 * M_PI * j / (2*k));
 *     wi1 = sin(1.0 * M_PI * j / (2*k));
 *     wr1 = 0.5 * (wr1 + wi1);
 *     wi1 = 0.5 * -wi1;
 *
 *     wr2 = cos(2.0 * M_PI * j / (2*k));
 *     wi2 = sin(2.0 * M_PI * j / (2*k));
 *     wr2 = 0.5 * (wr2 + wi2);
 *     wi2 = 0.5 * -wi2;
 *
 *     wr3 = cos(3.0 * M_PI * j / (2*k));
 *     wi3 = sin(3.0 * M_PI * j / (2*k));
 *     wr3 = 0.5 * (wr3 + wi3);
 *     wi3 = 0.5 * -wi3;
 *
 *     if (k & 0xaaaaaaaa) {
 *       w_odd[iodd++] = (float)wr2;
 *       w_odd[iodd++] = (float)wi2;
 *       w_odd[iodd++] = (float)wr1;
 *       w_odd[iodd++] = (float)wi1;
 *       w_odd[iodd++] = (float)wr3;
 *       w_odd[iodd++] = (float)wi3;
 *     } else {
 *       w_even[ieven++] = (float)wr2;
 *       w_even[ieven++] = (float)wi2;
 *       w_even[ieven++] = (float)wr1;
 *       w_even[ieven++] = (float)wi1;
 *       w_even[ieven++] = (float)wr3;
 *       w_even[ieven++] = (float)wi3;
 *     }
 *   }
 * }
 */
const int twidTabOdd[8 * 6 + 32 * 6 + 128 * 6] = {
    0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x539eba45, 0xe7821d59,
    0x4b418bbe, 0xf383a3e2, 0x58c542c5, 0xdc71898d, 0x5a82799a, 0xd2bec333, 0x539eba45, 0xe7821d59,
    0x539eba45, 0xc4df2862, 0x539eba45, 0xc4df2862, 0x58c542c5, 0xdc71898d, 0x3248d382, 0xc13ad060,
    0x40000000, 0xc0000000, 0x5a82799a, 0xd2bec333, 0x00000000, 0xd2bec333, 0x22a2f4f8, 0xc4df2862,
    0x58c542c5, 0xcac933ae, 0xcdb72c7e, 0xf383a3e2, 0x00000000, 0xd2bec333, 0x539eba45, 0xc4df2862,
    0xac6145bb, 0x187de2a7, 0xdd5d0b08, 0xe7821d59, 0x4b418bbe, 0xc13ad060, 0xa73abd3b, 0x3536cc52,

    0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x45f704f7, 0xf9ba1651,
    0x43103085, 0xfcdc1342, 0x48b2b335, 0xf69bf7c9, 0x4b418bbe, 0xf383a3e2, 0x45f704f7, 0xf9ba1651,
    0x4fd288dc, 0xed6bf9d1, 0x4fd288dc, 0xed6bf9d1, 0x48b2b335, 0xf69bf7c9, 0x553805f2, 0xe4a2eff6,
    0x539eba45, 0xe7821d59, 0x4b418bbe, 0xf383a3e2, 0x58c542c5, 0xdc71898d, 0x569cc31b, 0xe1d4a2c8,
    0x4da1fab5, 0xf0730342, 0x5a6690ae, 0xd5052d97, 0x58c542c5, 0xdc71898d, 0x4fd288dc, 0xed6bf9d1,
    0x5a12e720, 0xce86ff2a, 0x5a12e720, 0xd76619b6, 0x51d1dc80, 0xea70658a, 0x57cc15bc, 0xc91af976,
    0x5a82799a, 0xd2bec333, 0x539eba45, 0xe7821d59, 0x539eba45, 0xc4df2862, 0x5a12e720, 0xce86ff2a,
    0x553805f2, 0xe4a2eff6, 0x4da1fab5, 0xc1eb0209, 0x58c542c5, 0xcac933ae, 0x569cc31b, 0xe1d4a2c8,
    0x45f704f7, 0xc04ee4b8, 0x569cc31b, 0xc78e9a1d, 0x57cc15bc, 0xdf18f0ce, 0x3cc85709, 0xc013bc39,
    0x539eba45, 0xc4df2862, 0x58c542c5, 0xdc71898d, 0x3248d382, 0xc13ad060, 0x4fd288dc, 0xc2c17d52,
    0x5987b08a, 0xd9e01006, 0x26b2a794, 0xc3bdbdf6, 0x4b418bbe, 0xc13ad060, 0x5a12e720, 0xd76619b6,
    0x1a4608ab, 0xc78e9a1d, 0x45f704f7, 0xc04ee4b8, 0x5a6690ae, 0xd5052d97, 0x0d47d096, 0xcc983f70,
    0x40000000, 0xc0000000, 0x5a82799a, 0xd2bec333, 0x00000000, 0xd2bec333, 0x396b3199, 0xc04ee4b8,
    0x5a6690ae, 0xd09441bb, 0xf2b82f6a, 0xd9e01006, 0x3248d382, 0xc13ad060, 0x5a12e720, 0xce86ff2a,
    0xe5b9f755, 0xe1d4a2c8, 0x2aaa7c7f, 0xc2c17d52, 0x5987b08a, 0xcc983f70, 0xd94d586c, 0xea70658a,
    0x22a2f4f8, 0xc4df2862, 0x58c542c5, 0xcac933ae, 0xcdb72c7e, 0xf383a3e2, 0x1a4608ab, 0xc78e9a1d,
    0x57cc15bc, 0xc91af976, 0xc337a8f7, 0xfcdc1342, 0x11a855df, 0xcac933ae, 0x569cc31b, 0xc78e9a1d,
    0xba08fb09, 0x0645e9af, 0x08df1a8c, 0xce86ff2a, 0x553805f2, 0xc6250a18, 0xb25e054b, 0x0f8cfcbe,
    0x00000000, 0xd2bec333, 0x539eba45, 0xc4df2862, 0xac6145bb, 0x187de2a7, 0xf720e574, 0xd76619b6,
    0x51d1dc80, 0xc3bdbdf6, 0xa833ea44, 0x20e70f32, 0xee57aa21, 0xdc71898d, 0x4fd288dc, 0xc2c17d52,
    0xa5ed18e0, 0x2899e64a, 0xe5b9f755, 0xe1d4a2c8, 0x4da1fab5, 0xc1eb0209, 0xa5996f52, 0x2f6bbe45,
    0xdd5d0b08, 0xe7821d59, 0x4b418bbe, 0xc13ad060, 0xa73abd3b, 0x3536cc52, 0xd5558381, 0xed6bf9d1,
    0x48b2b335, 0xc0b15502, 0xaac7fa0e, 0x39daf5e8, 0xcdb72c7e, 0xf383a3e2, 0x45f704f7, 0xc04ee4b8,
    0xb02d7724, 0x3d3e82ae, 0xc694ce67, 0xf9ba1651, 0x43103085, 0xc013bc39, 0xb74d4ccb, 0x3f4eaafe,

    0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x418d2621, 0xfe6deaa1,
    0x40c7d2bd, 0xff36f170, 0x424ff28f, 0xfda4f351, 0x43103085, 0xfcdc1342, 0x418d2621, 0xfe6deaa1,
    0x4488e37f, 0xfb4ab7db, 0x4488e37f, 0xfb4ab7db, 0x424ff28f, 0xfda4f351, 0x46aa0d6d, 0xf8f21e8e,
    0x45f704f7, 0xf9ba1651, 0x43103085, 0xfcdc1342, 0x48b2b335, 0xf69bf7c9, 0x475a5c77, 0xf82a6c6a,
    0x43cdd89a, 0xfc135231, 0x4aa22036, 0xf4491311, 0x48b2b335, 0xf69bf7c9, 0x4488e37f, 0xfb4ab7db,
    0x4c77a88e, 0xf1fa3ecb, 0x49ffd417, 0xf50ef5de, 0x454149fc, 0xfa824bfd, 0x4e32a956, 0xefb047f2,
    0x4b418bbe, 0xf383a3e2, 0x45f704f7, 0xf9ba1651, 0x4fd288dc, 0xed6bf9d1, 0x4c77a88e, 0xf1fa3ecb,
    0x46aa0d6d, 0xf8f21e8e, 0x5156b6d9, 0xeb2e1dbe, 0x4da1fab5, 0xf0730342, 0x475a5c77, 0xf82a6c6a,
    0x52beac9f, 0xe8f77acf, 0x4ec05432, 0xeeee2d9d, 0x4807eb4b, 0xf7630799, 0x5409ed4b, 0xe6c8d59c,
    0x4fd288dc, 0xed6bf9d1, 0x48b2b335, 0xf69bf7c9, 0x553805f2, 0xe4a2eff6, 0x50d86e6d, 0xebeca36c,
    0x495aada2, 0xf5d544a7, 0x56488dc5, 0xe28688a4, 0x51d1dc80, 0xea70658a, 0x49ffd417, 0xf50ef5de,
    0x573b2635, 0xe0745b24, 0x52beac9f, 0xe8f77acf, 0x4aa22036, 0xf4491311, 0x580f7b19, 0xde6d1f65,
    0x539eba45, 0xe7821d59, 0x4b418bbe, 0xf383a3e2, 0x58c542c5, 0xdc71898d, 0x5471e2e6, 0xe61086bc,
    0x4bde1089, 0xf2beafed, 0x595c3e2a, 0xda8249b4, 0x553805f2, 0xe4a2eff6, 0x4c77a88e, 0xf1fa3ecb,
    0x59d438e5, 0xd8a00bae, 0x55f104dc, 0xe3399167, 0x4d0e4de2, 0xf136580d, 0x5a2d0957, 0xd6cb76c9,
    0x569cc31b, 0xe1d4a2c8, 0x4da1fab5, 0xf0730342, 0x5a6690ae, 0xd5052d97, 0x573b2635, 0xe0745b24,
    0x4e32a956, 0xefb047f2, 0x5a80baf6, 0xd34dcdb4, 0x57cc15bc, 0xdf18f0ce, 0x4ec05432, 0xeeee2d9d,
    0x5a7b7f1a, 0xd1a5ef90, 0x584f7b58, 0xddc29958, 0x4f4af5d1, 0xee2cbbc1, 0x5a56deec, 0xd00e2639,
    0x58c542c5, 0xdc71898d, 0x4fd288dc, 0xed6bf9d1, 0x5a12e720, 0xce86ff2a, 0x592d59da, 0xdb25f566,
    0x50570819, 0xecabef3d, 0x59afaf4c, 0xcd110216, 0x5987b08a, 0xd9e01006, 0x50d86e6d, 0xebeca36c,
    0x592d59da, 0xcbacb0bf, 0x59d438e5, 0xd8a00bae, 0x5156b6d9, 0xeb2e1dbe, 0x588c1404, 0xca5a86c4,
    0x5a12e720, 0xd76619b6, 0x51d1dc80, 0xea70658a, 0x57cc15bc, 0xc91af976, 0x5a43b190, 0xd6326a88,
    0x5249daa2, 0xe9b38223, 0x56eda1a0, 0xc7ee77b3, 0x5a6690ae, 0xd5052d97, 0x52beac9f, 0xe8f77acf,
    0x55f104dc, 0xc6d569be, 0x5a7b7f1a, 0xd3de9156, 0x53304df6, 0xe83c56cf, 0x54d69714, 0xc5d03118,
    0x5a82799a, 0xd2bec333, 0x539eba45, 0xe7821d59, 0x539eba45, 0xc4df2862, 0x5a7b7f1a, 0xd1a5ef90,
    0x5409ed4b, 0xe6c8d59c, 0x5249daa2, 0xc402a33c, 0x5a6690ae, 0xd09441bb, 0x5471e2e6, 0xe61086bc,
    0x50d86e6d, 0xc33aee27, 0x5a43b190, 0xcf89e3e8, 0x54d69714, 0xe55937d5, 0x4f4af5d1, 0xc2884e6e,
    0x5a12e720, 0xce86ff2a, 0x553805f2, 0xe4a2eff6, 0x4da1fab5, 0xc1eb0209, 0x59d438e5, 0xcd8bbb6d,
    0x55962bc0, 0xe3edb628, 0x4bde1089, 0xc1633f8a, 0x5987b08a, 0xcc983f70, 0x55f104dc, 0xe3399167,
    0x49ffd417, 0xc0f1360b, 0x592d59da, 0xcbacb0bf, 0x56488dc5, 0xe28688a4, 0x4807eb4b, 0xc0950d1d,
    0x58c542c5, 0xcac933ae, 0x569cc31b, 0xe1d4a2c8, 0x45f704f7, 0xc04ee4b8, 0x584f7b58, 0xc9edeb50,
    0x56eda1a0, 0xe123e6ad, 0x43cdd89a, 0xc01ed535, 0x57cc15bc, 0xc91af976, 0x573b2635, 0xe0745b24,
    0x418d2621, 0xc004ef3f, 0x573b2635, 0xc8507ea7, 0x57854ddd, 0xdfc606f1, 0x3f35b59d, 0xc0013bd3,
    0x569cc31b, 0xc78e9a1d, 0x57cc15bc, 0xdf18f0ce, 0x3cc85709, 0xc013bc39, 0x55f104dc, 0xc6d569be,
    0x580f7b19, 0xde6d1f65, 0x3a45e1f7, 0xc03c6a07, 0x553805f2, 0xc6250a18, 0x584f7b58, 0xddc29958,
    0x37af354c, 0xc07b371e, 0x5471e2e6, 0xc57d965d, 0x588c1404, 0xdd196538, 0x350536f1, 0xc0d00db6,
    0x539eba45, 0xc4df2862, 0x58c542c5, 0xdc71898d, 0x3248d382, 0xc13ad060, 0x52beac9f, 0xc449d892,
    0x58fb0568, 0xdbcb0cce, 0x2f7afdfc, 0xc1bb5a11, 0x51d1dc80, 0xc3bdbdf6, 0x592d59da, 0xdb25f566,
    0x2c9caf6c, 0xc2517e31, 0x50d86e6d, 0xc33aee27, 0x595c3e2a, 0xda8249b4, 0x29aee694, 0xc2fd08a9,
    0x4fd288dc, 0xc2c17d52, 0x5987b08a, 0xd9e01006, 0x26b2a794, 0xc3bdbdf6, 0x4ec05432, 0xc2517e31,
    0x59afaf4c, 0xd93f4e9e, 0x23a8fb93, 0xc4935b3c, 0x4da1fab5, 0xc1eb0209, 0x59d438e5, 0xd8a00bae,
    0x2092f05f, 0xc57d965d, 0x4c77a88e, 0xc18e18a7, 0x59f54bee, 0xd8024d59, 0x1d719810, 0xc67c1e18,
    0x4b418bbe, 0xc13ad060, 0x5a12e720, 0xd76619b6, 0x1a4608ab, 0xc78e9a1d, 0x49ffd417, 0xc0f1360b,
    0x5a2d0957, 0xd6cb76c9, 0x17115bc0, 0xc8b4ab32, 0x48b2b335, 0xc0b15502, 0x5a43b190, 0xd6326a88,
    0x13d4ae08, 0xc9edeb50, 0x475a5c77, 0xc07b371e, 0x5a56deec, 0xd59afadb, 0x10911f04, 0xcb39edca,
    0x45f704f7, 0xc04ee4b8, 0x5a6690ae, 0xd5052d97, 0x0d47d096, 0xcc983f70, 0x4488e37f, 0xc02c64a6,
    0x5a72c63b, 0xd4710883, 0x09f9e6a1, 0xce0866b8, 0x43103085, 0xc013bc39, 0x5a7b7f1a, 0xd3de9156,
    0x06a886a0, 0xcf89e3e8, 0x418d2621, 0xc004ef3f, 0x5a80baf6, 0xd34dcdb4, 0x0354d741, 0xd11c3142,
    0x40000000, 0xc0000000, 0x5a82799a, 0xd2bec333, 0x00000000, 0xd2bec333, 0x3e68fb62, 0xc004ef3f,
    0x5a80baf6, 0xd2317756, 0xfcab28bf, 0xd4710883, 0x3cc85709, 0xc013bc39, 0x5a7b7f1a, 0xd1a5ef90,
    0xf9577960, 0xd6326a88, 0x3b1e5335, 0xc02c64a6, 0x5a72c63b, 0xd11c3142, 0xf606195f, 0xd8024d59,
    0x396b3199, 0xc04ee4b8, 0x5a6690ae, 0xd09441bb, 0xf2b82f6a, 0xd9e01006, 0x37af354c, 0xc07b371e,
    0x5a56deec, 0xd00e2639, 0xef6ee0fc, 0xdbcb0cce, 0x35eaa2c7, 0xc0b15502, 0x5a43b190, 0xcf89e3e8,
    0xec2b51f8, 0xddc29958, 0x341dbfd3, 0xc0f1360b, 0x5a2d0957, 0xcf077fe1, 0xe8eea440, 0xdfc606f1,
    0x3248d382, 0xc13ad060, 0x5a12e720, 0xce86ff2a, 0xe5b9f755, 0xe1d4a2c8, 0x306c2624, 0xc18e18a7,
    0x59f54bee, 0xce0866b8, 0xe28e67f0, 0xe3edb628, 0x2e88013a, 0xc1eb0209, 0x59d438e5, 0xcd8bbb6d,
    0xdf6d0fa1, 0xe61086bc, 0x2c9caf6c, 0xc2517e31, 0x59afaf4c, 0xcd110216, 0xdc57046d, 0xe83c56cf,
    0x2aaa7c7f, 0xc2c17d52, 0x5987b08a, 0xcc983f70, 0xd94d586c, 0xea70658a, 0x28b1b544, 0xc33aee27,
    0x595c3e2a, 0xcc217822, 0xd651196c, 0xecabef3d, 0x26b2a794, 0xc3bdbdf6, 0x592d59da, 0xcbacb0bf,
    0xd3635094, 0xeeee2d9d, 0x24ada23d, 0xc449d892, 0x58fb0568, 0xcb39edca, 0xd0850204, 0xf136580d,
    0x22a2f4f8, 0xc4df2862, 0x58c542c5, 0xcac933ae, 0xcdb72c7e, 0xf383a3e2, 0x2092f05f, 0xc57d965d,
    0x588c1404, 0xca5a86c4, 0xcafac90f, 0xf5d544a7, 0x1e7de5df, 0xc6250a18, 0x584f7b58, 0xc9edeb50,
    0xc850cab4, 0xf82a6c6a, 0x1c6427a9, 0xc6d569be, 0x580f7b19, 0xc9836582, 0xc5ba1e09, 0xfa824bfd,
    0x1a4608ab, 0xc78e9a1d, 0x57cc15bc, 0xc91af976, 0xc337a8f7, 0xfcdc1342, 0x1823dc7d, 0xc8507ea7,
    0x57854ddd, 0xc8b4ab32, 0xc0ca4a63, 0xff36f170, 0x15fdf758, 0xc91af976, 0x573b2635, 0xc8507ea7,
    0xbe72d9df, 0x0192155f, 0x13d4ae08, 0xc9edeb50, 0x56eda1a0, 0xc7ee77b3, 0xbc322766, 0x03ecadcf,
    0x11a855df, 0xcac933ae, 0x569cc31b, 0xc78e9a1d, 0xba08fb09, 0x0645e9af, 0x0f7944a7, 0xcbacb0bf,
    0x56488dc5, 0xc730e997, 0xb7f814b5, 0x089cf867, 0x0d47d096, 0xcc983f70, 0x55f104dc, 0xc6d569be,
    0xb6002be9, 0x0af10a22, 0x0b145041, 0xcd8bbb6d, 0x55962bc0, 0xc67c1e18, 0xb421ef77, 0x0d415013,
    0x08df1a8c, 0xce86ff2a, 0x553805f2, 0xc6250a18, 0xb25e054b, 0x0f8cfcbe, 0x06a886a0, 0xcf89e3e8,
    0x54d69714, 0xc5d03118, 0xb0b50a2f, 0x11d3443f, 0x0470ebdc, 0xd09441bb, 0x5471e2e6, 0xc57d965d,
    0xaf279193, 0x14135c94, 0x0238a1c6, 0xd1a5ef90, 0x5409ed4b, 0xc52d3d18, 0xadb6255e, 0x164c7ddd,
    0x00000000, 0xd2bec333, 0x539eba45, 0xc4df2862, 0xac6145bb, 0x187de2a7, 0xfdc75e3a, 0xd3de9156,
    0x53304df6, 0xc4935b3c, 0xab2968ec, 0x1aa6c82b, 0xfb8f1424, 0xd5052d97, 0x52beac9f, 0xc449d892,
    0xaa0efb24, 0x1cc66e99, 0xf9577960, 0xd6326a88, 0x5249daa2, 0xc402a33c, 0xa9125e60, 0x1edc1953,
    0xf720e574, 0xd76619b6, 0x51d1dc80, 0xc3bdbdf6, 0xa833ea44, 0x20e70f32, 0xf4ebafbf, 0xd8a00bae,
    0x5156b6d9, 0xc37b2b6a, 0xa773ebfc, 0x22e69ac8, 0xf2b82f6a, 0xd9e01006, 0x50d86e6d, 0xc33aee27,
    0xa6d2a626, 0x24da0a9a, 0xf086bb59, 0xdb25f566, 0x50570819, 0xc2fd08a9, 0xa65050b4, 0x26c0b162,
    0xee57aa21, 0xdc71898d, 0x4fd288dc, 0xc2c17d52, 0xa5ed18e0, 0x2899e64a, 0xec2b51f8, 0xddc29958,
    0x4f4af5d1, 0xc2884e6e, 0xa5a92114, 0x2a650525, 0xea0208a8, 0xdf18f0ce, 0x4ec05432, 0xc2517e31,
    0xa58480e6, 0x2c216eaa, 0xe7dc2383, 0xe0745b24, 0x4e32a956, 0xc21d0eb8, 0xa57f450a, 0x2dce88aa,
    0xe5b9f755, 0xe1d4a2c8, 0x4da1fab5, 0xc1eb0209, 0xa5996f52, 0x2f6bbe45, 0xe39bd857, 0xe3399167,
    0x4d0e4de2, 0xc1bb5a11, 0xa5d2f6a9, 0x30f8801f, 0xe1821a21, 0xe4a2eff6, 0x4c77a88e, 0xc18e18a7,
    0xa62bc71b, 0x32744493, 0xdf6d0fa1, 0xe61086bc, 0x4bde1089, 0xc1633f8a, 0xa6a3c1d6, 0x33de87de,
    0xdd5d0b08, 0xe7821d59, 0x4b418bbe, 0xc13ad060, 0xa73abd3b, 0x3536cc52, 0xdb525dc3, 0xe8f77acf,
    0x4aa22036, 0xc114ccb9, 0xa7f084e7, 0x367c9a7e, 0xd94d586c, 0xea70658a, 0x49ffd417, 0xc0f1360b,
    0xa8c4d9cb, 0x37af8159, 0xd74e4abc, 0xebeca36c, 0x495aada2, 0xc0d00db6, 0xa9b7723b, 0x38cf1669,
    0xd5558381, 0xed6bf9d1, 0x48b2b335, 0xc0b15502, 0xaac7fa0e, 0x39daf5e8, 0xd3635094, 0xeeee2d9d,
    0x4807eb4b, 0xc0950d1d, 0xabf612b5, 0x3ad2c2e8, 0xd177fec6, 0xf0730342, 0x475a5c77, 0xc07b371e,
    0xad415361, 0x3bb6276e, 0xcf93d9dc, 0xf1fa3ecb, 0x46aa0d6d, 0xc063d405, 0xaea94927, 0x3c84d496,
    0xcdb72c7e, 0xf383a3e2, 0x45f704f7, 0xc04ee4b8, 0xb02d7724, 0x3d3e82ae, 0xcbe2402d, 0xf50ef5de,
    0x454149fc, 0xc03c6a07, 0xb1cd56aa, 0x3de2f148, 0xca155d39, 0xf69bf7c9, 0x4488e37f, 0xc02c64a6,
    0xb3885772, 0x3e71e759, 0xc850cab4, 0xf82a6c6a, 0x43cdd89a, 0xc01ed535, 0xb55ddfca, 0x3eeb3347,
    0xc694ce67, 0xf9ba1651, 0x43103085, 0xc013bc39, 0xb74d4ccb, 0x3f4eaafe, 0xc4e1accb, 0xfb4ab7db,
    0x424ff28f, 0xc00b1a20, 0xb955f293, 0x3f9c2bfb, 0xc337a8f7, 0xfcdc1342, 0x418d2621, 0xc004ef3f,
    0xbb771c81, 0x3fd39b5a, 0xc197049e, 0xfe6deaa1, 0x40c7d2bd, 0xc0013bd3, 0xbdb00d71, 0x3ff4e5e0,
};

const int twidTabEven[4 * 6 + 16 * 6 + 64 * 6] = {
    0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x5a82799a, 0xd2bec333,
    0x539eba45, 0xe7821d59, 0x539eba45, 0xc4df2862, 0x40000000, 0xc0000000, 0x5a82799a, 0xd2bec333,
    0x00000000, 0xd2bec333, 0x00000000, 0xd2bec333, 0x539eba45, 0xc4df2862, 0xac6145bb, 0x187de2a7,

    0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x4b418bbe, 0xf383a3e2,
    0x45f704f7, 0xf9ba1651, 0x4fd288dc, 0xed6bf9d1, 0x539eba45, 0xe7821d59, 0x4b418bbe, 0xf383a3e2,
    0x58c542c5, 0xdc71898d, 0x58c542c5, 0xdc71898d, 0x4fd288dc, 0xed6bf9d1, 0x5a12e720, 0xce86ff2a,
    0x5a82799a, 0xd2bec333, 0x539eba45, 0xe7821d59, 0x539eba45, 0xc4df2862, 0x58c542c5, 0xcac933ae,
    0x569cc31b, 0xe1d4a2c8, 0x45f704f7, 0xc04ee4b8, 0x539eba45, 0xc4df2862, 0x58c542c5, 0xdc71898d,
    0x3248d382, 0xc13ad060, 0x4b418bbe, 0xc13ad060, 0x5a12e720, 0xd76619b6, 0x1a4608ab, 0xc78e9a1d,
    0x40000000, 0xc0000000, 0x5a82799a, 0xd2bec333, 0x00000000, 0xd2bec333, 0x3248d382, 0xc13ad060,
    0x5a12e720, 0xce86ff2a, 0xe5b9f755, 0xe1d4a2c8, 0x22a2f4f8, 0xc4df2862, 0x58c542c5, 0xcac933ae,
    0xcdb72c7e, 0xf383a3e2, 0x11a855df, 0xcac933ae, 0x569cc31b, 0xc78e9a1d, 0xba08fb09, 0x0645e9af,
    0x00000000, 0xd2bec333, 0x539eba45, 0xc4df2862, 0xac6145bb, 0x187de2a7, 0xee57aa21, 0xdc71898d,
    0x4fd288dc, 0xc2c17d52, 0xa5ed18e0, 0x2899e64a, 0xdd5d0b08, 0xe7821d59, 0x4b418bbe, 0xc13ad060,
    0xa73abd3b, 0x3536cc52, 0xcdb72c7e, 0xf383a3e2, 0x45f704f7, 0xc04ee4b8, 0xb02d7724, 0x3d3e82ae,

    0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x43103085, 0xfcdc1342,
    0x418d2621, 0xfe6deaa1, 0x4488e37f, 0xfb4ab7db, 0x45f704f7, 0xf9ba1651, 0x43103085, 0xfcdc1342,
    0x48b2b335, 0xf69bf7c9, 0x48b2b335, 0xf69bf7c9, 0x4488e37f, 0xfb4ab7db, 0x4c77a88e, 0xf1fa3ecb,
    0x4b418bbe, 0xf383a3e2, 0x45f704f7, 0xf9ba1651, 0x4fd288dc, 0xed6bf9d1, 0x4da1fab5, 0xf0730342,
    0x475a5c77, 0xf82a6c6a, 0x52beac9f, 0xe8f77acf, 0x4fd288dc, 0xed6bf9d1, 0x48b2b335, 0xf69bf7c9,
    0x553805f2, 0xe4a2eff6, 0x51d1dc80, 0xea70658a, 0x49ffd417, 0xf50ef5de, 0x573b2635, 0xe0745b24,
    0x539eba45, 0xe7821d59, 0x4b418bbe, 0xf383a3e2, 0x58c542c5, 0xdc71898d, 0x553805f2, 0xe4a2eff6,
    0x4c77a88e, 0xf1fa3ecb, 0x59d438e5, 0xd8a00bae, 0x569cc31b, 0xe1d4a2c8, 0x4da1fab5, 0xf0730342,
    0x5a6690ae, 0xd5052d97, 0x57cc15bc, 0xdf18f0ce, 0x4ec05432, 0xeeee2d9d, 0x5a7b7f1a, 0xd1a5ef90,
    0x58c542c5, 0xdc71898d, 0x4fd288dc, 0xed6bf9d1, 0x5a12e720, 0xce86ff2a, 0x5987b08a, 0xd9e01006,
    0x50d86e6d, 0xebeca36c, 0x592d59da, 0xcbacb0bf, 0x5a12e720, 0xd76619b6, 0x51d1dc80, 0xea70658a,
    0x57cc15bc, 0xc91af976, 0x5a6690ae, 0xd5052d97, 0x52beac9f, 0xe8f77acf, 0x55f104dc, 0xc6d569be,
    0x5a82799a, 0xd2bec333, 0x539eba45, 0xe7821d59, 0x539eba45, 0xc4df2862, 0x5a6690ae, 0xd09441bb,
    0x5471e2e6, 0xe61086bc, 0x50d86e6d, 0xc33aee27, 0x5a12e720, 0xce86ff2a, 0x553805f2, 0xe4a2eff6,
    0x4da1fab5, 0xc1eb0209, 0x5987b08a, 0xcc983f70, 0x55f104dc, 0xe3399167, 0x49ffd417, 0xc0f1360b,
    0x58c542c5, 0xcac933ae, 0x569cc31b, 0xe1d4a2c8, 0x45f704f7, 0xc04ee4b8, 0x57cc15bc, 0xc91af976,
    0x573b2635, 0xe0745b24, 0x418d2621, 0xc004ef3f, 0x569cc31b, 0xc78e9a1d, 0x57cc15bc, 0xdf18f0ce,
    0x3cc85709, 0xc013bc39, 0x553805f2, 0xc6250a18, 0x584f7b58, 0xddc29958, 0x37af354c, 0xc07b371e,
    0x539eba45, 0xc4df2862, 0x58c542c5, 0xdc71898d, 0x3248d382, 0xc13ad060, 0x51d1dc80, 0xc3bdbdf6,
    0x592d59da, 0xdb25f566, 0x2c9caf6c, 0xc2517e31, 0x4fd288dc, 0xc2c17d52, 0x5987b08a, 0xd9e01006,
    0x26b2a794, 0xc3bdbdf6, 0x4da1fab5, 0xc1eb0209, 0x59d438e5, 0xd8a00bae, 0x2092f05f, 0xc57d965d,
    0x4b418bbe, 0xc13ad060, 0x5a12e720, 0xd76619b6, 0x1a4608ab, 0xc78e9a1d, 0x48b2b335, 0xc0b15502,
    0x5a43b190, 0xd6326a88, 0x13d4ae08, 0xc9edeb50, 0x45f704f7, 0xc04ee4b8, 0x5a6690ae, 0xd5052d97,
    0x0d47d096, 0xcc983f70, 0x43103085, 0xc013bc39, 0x5a7b7f1a, 0xd3de9156, 0x06a886a0, 0xcf89e3e8,
    0x40000000, 0xc0000000, 0x5a82799a, 0xd2bec333, 0x00000000, 0xd2bec333, 0x3cc85709, 0xc013bc39,
    0x5a7b7f1a, 0xd1a5ef90, 0xf9577960, 0xd6326a88, 0x396b3199, 0xc04ee4b8, 0x5a6690ae, 0xd09441bb,
    0xf2b82f6a, 0xd9e01006, 0x35eaa2c7, 0xc0b15502, 0x5a43b190, 0xcf89e3e8, 0xec2b51f8, 0xddc29958,
    0x3248d382, 0xc13ad060, 0x5a12e720, 0xce86ff2a, 0xe5b9f755, 0xe1d4a2c8, 0x2e88013a, 0xc1eb0209,
    0x59d438e5, 0xcd8bbb6d, 0xdf6d0fa1, 0xe61086bc, 0x2aaa7c7f, 0xc2c17d52, 0x5987b08a, 0xcc983f70,
    0xd94d586c, 0xea70658a, 0x26b2a794, 0xc3bdbdf6, 0x592d59da, 0xcbacb0bf, 0xd3635094, 0xeeee2d9d,
    0x22a2f4f8, 0xc4df2862, 0x58c542c5, 0xcac933ae, 0xcdb72c7e, 0xf383a3e2, 0x1e7de5df, 0xc6250a18,
    0x584f7b58, 0xc9edeb50, 0xc850cab4, 0xf82a6c6a, 0x1a4608ab, 0xc78e9a1d, 0x57cc15bc, 0xc91af976,
    0xc337a8f7, 0xfcdc1342, 0x15fdf758, 0xc91af976, 0x573b2635, 0xc8507ea7, 0xbe72d9df, 0x0192155f,
    0x11a855df, 0xcac933ae, 0x569cc31b, 0xc78e9a1d, 0xba08fb09, 0x0645e9af, 0x0d47d096, 0xcc983f70,
    0x55f104dc, 0xc6d569be, 0xb6002be9, 0x0af10a22, 0x08df1a8c, 0xce86ff2a, 0x553805f2, 0xc6250a18,
    0xb25e054b, 0x0f8cfcbe, 0x0470ebdc, 0xd09441bb, 0x5471e2e6, 0xc57d965d, 0xaf279193, 0x14135c94,
    0x00000000, 0xd2bec333, 0x539eba45, 0xc4df2862, 0xac6145bb, 0x187de2a7, 0xfb8f1424, 0xd5052d97,
    0x52beac9f, 0xc449d892, 0xaa0efb24, 0x1cc66e99, 0xf720e574, 0xd76619b6, 0x51d1dc80, 0xc3bdbdf6,
    0xa833ea44, 0x20e70f32, 0xf2b82f6a, 0xd9e01006, 0x50d86e6d, 0xc33aee27, 0xa6d2a626, 0x24da0a9a,
    0xee57aa21, 0xdc71898d, 0x4fd288dc, 0xc2c17d52, 0xa5ed18e0, 0x2899e64a, 0xea0208a8, 0xdf18f0ce,
    0x4ec05432, 0xc2517e31, 0xa58480e6, 0x2c216eaa, 0xe5b9f755, 0xe1d4a2c8, 0x4da1fab5, 0xc1eb0209,
    0xa5996f52, 0x2f6bbe45, 0xe1821a21, 0xe4a2eff6, 0x4c77a88e, 0xc18e18a7, 0xa62bc71b, 0x32744493,
    0xdd5d0b08, 0xe7821d59, 0x4b418bbe, 0xc13ad060, 0xa73abd3b, 0x3536cc52, 0xd94d586c, 0xea70658a,
    0x49ffd417, 0xc0f1360b, 0xa8c4d9cb, 0x37af8159, 0xd5558381, 0xed6bf9d1, 0x48b2b335, 0xc0b15502,
    0xaac7fa0e, 0x39daf5e8, 0xd177fec6, 0xf0730342, 0x475a5c77, 0xc07b371e, 0xad415361, 0x3bb6276e,
    0xcdb72c7e, 0xf383a3e2, 0x45f704f7, 0xc04ee4b8, 0xb02d7724, 0x3d3e82ae, 0xca155d39, 0xf69bf7c9,
    0x4488e37f, 0xc02c64a6, 0xb3885772, 0x3e71e759, 0xc694ce67, 0xf9ba1651, 0x43103085, 0xc013bc39,
    0xb74d4ccb, 0x3f4eaafe, 0xc337a8f7, 0xfcdc1342, 0x418d2621, 0xc004ef3f, 0xbb771c81, 0x3fd39b5a,
};

/* for reference, here's the code to generate the bitreverse tables

static int bitrev(int n, int nbits)
{
    int r, i;

    r = 0;
    for (i = 0; i < nbits; i++) {
        r <<= 1;
        r |= (n & 1);
        n >>= 1;
    }

    return r;
}

static void InitBitrevTable(unsigned char *out, int nbits)
{
    int i, t;

    for (i = 0; i < (1<<nbits); i++) {
        / *** do not register the same transposition twice *** /
        t = bitrev(i,nbits);
        if (i < t) {
            *out++ = (unsigned char)i;
            *out++ = (unsigned char)t;
        }
    }

    / *** no need to write a sentinel (or rather, the first entry in the
      * table for symetric codes will be 0, which serves as the sentinel)
      *** /
    for (i = 0; i < (1<<nbits); i++) {
        t = bitrev(i,nbits);
        if (i == t)             / *** symmetric codes get special treatment *** /
            *out++ = (unsigned char)t;
    }
    *out++ = 0;                 / *** second sentinel is 0, again *** /
}

*/

