/*
 * drivers/amlogic/drm/meson_fbdev.h
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#ifndef __AM_MESON_FBDEV_H
#define __AM_MESON_FBDEV_H

#include <drm/drm_fb_helper.h>

int am_meson_drm_fbdev_init(struct drm_device *dev);
void am_meson_drm_fbdev_fini(struct drm_device *dev);

/*keep sync with amlogic osd/fbdev.*/
#define FBIOGET_OSD_DMABUF               0x46fc
#define FBIO_WAITFORVSYNC          _IOW('F', 0x20, __u32)
#define FBIO_WAITFORVSYNC_64       _IOW('F', 0x21, __u32)

struct fb_dmabuf_export {
	/*idx only used in legacy android implement, not used now.*/
	__u32 buffer_idx;
	__u32 fd;
	__u32 flags;
};

struct meson_drm_fbdev_config {
	u32 ui_w;
	u32 ui_h;
	u32 fb_w;
	u32 fb_h;
	u32 fb_bpp;
};

struct meson_drm_fbdev {
	struct drm_fb_helper base;
	struct drm_plane *plane;
	//struct am_meson_fb * fb;
	struct drm_gem_object *fb_gem;
	u32 zorder;
	bool blank;
};

extern struct am_meson_logo logo;
#endif /* __AM_MESON_FBDEV_H */
