/*
 * drivers/amlogic/media/enhancement/amvecm/dolby_vision/amdolby_vision.h
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */
#ifndef _AMDV_H_
#define _AMDV_H_

#define V1_5
#define V1_6_1
#define V2_4
/*  driver version */
#define DRIVER_VER "20181220"

#include <linux/types.h>

#define DEF_G2L_LUT_SIZE_2P        8
#define DEF_G2L_LUT_SIZE           (1 << DEF_G2L_LUT_SIZE_2P)

#ifdef V2_4
#define EXT_MD_AVAIL_LEVEL_1 (1 << 0)
#define EXT_MD_AVAIL_LEVEL_2 (1 << 1)
#define EXT_MD_AVAIL_LEVEL_4 (1 << 2)
#define EXT_MD_AVAIL_LEVEL_5 (1 << 3)
#define EXT_MD_AVAIL_LEVEL_6 (1 << 4)
#define EXT_MD_AVAIL_LEVEL_255 (1 << 31)
#endif
#define PQ2G_LUT_SIZE (4 + 1024 * 4 + 16 * 3)
#define GM_LUT_HDR_SIZE  (13 + 2*9)
#define LUT_DIM          17
#define GM_LUT_SIZE      (3 * LUT_DIM * LUT_DIM * LUT_DIM * 2)
#define BACLIGHT_LUT_SIZE 4096
#define BLU_LUT_SIZE 5
#define AMB_LUT_SIZE 8
#define TUNING_LUT_ENTRIES 14
#define DM4_TUNING_LUT_ENTRIES 7

#define TUNINGMODE_FORCE_ABSOLUTE        0x1
#define TUNINGMODE_EXTLEVEL1_DISABLE     0x2
#define TUNINGMODE_EXTLEVEL2_DISABLE     0x4
#define TUNINGMODE_EXTLEVEL4_DISABLE     0x8
#define TUNINGMODE_EXTLEVEL5_DISABLE     0x10
#define TUNINGMODE_EL_FORCEDDISABLE      0x20

enum core1_switch_type {
	NO_SWITCH = 0,
	SWITCH_BEFORE_DVCORE_1,
	SWITCH_BEFORE_DVCORE_2,
	SWITCH_AFTER_DVCORE,
};

enum core3_switch_type {
	CORE3_AFTER_WM = 0,
	CORE3_AFTER_OSD1_HDR,
	CORE3_AFTER_VD2_HDR,
};

enum core_type {
	DOLBY_TVCORE = 0,
	DOLBY_CORE1A,
	DOLBY_CORE1B,
	DOLBY_CORE1C,
	DOLBY_CORE2A,
	DOLBY_CORE2B,
	DOLBY_CORE2C,
};

enum input_source_status {
	IN_HDMI = 0,
	OTHER_SOURCE,
	OTHER_SOURCE_TO_HDMI,
};

/*! @brief Output CSC configuration.*/
# pragma pack(push, 1)
struct TgtOutCscCfg {
	int32_t   lms2RgbMat[3][3]; /**<@brief  LMS to RGB matrix */
	int32_t   lms2RgbMatScale;  /**<@brief  LMS 2 RGB matrix scale */
	uint8_t   whitePoint[3];    /**<@brief  White point */
	uint8_t   whitePointScale;  /**<@brief  White point scale */
	int32_t   reserved[3];
};
#pragma pack(pop)

/*! @brief Global dimming configuration.*/
# pragma pack(push, 1)
struct TgtGDCfg {
	int32_t   gdEnable;
	uint32_t  gdWMin;
	uint32_t  gdWMax;
	uint32_t  gdWMm;
	uint32_t  gdWDynRngSqrt;
	uint32_t  gdWeightMean;
	uint32_t  gdWeightStd;
	uint32_t  gdDelayMilliSec_hdmi;
	int32_t   gdRgb2YuvExt;
	int32_t   gdM33Rgb2Yuv[3][3];
	int32_t   gdM33Rgb2YuvScale2P;
	int32_t   gdRgb2YuvOffExt;
	int32_t   gdV3Rgb2YuvOff[3];
	uint32_t  gdUpBound;
	uint32_t  gdLowBound;
	uint32_t  lastMaxPq;
	uint16_t  gdWMinPq;
	uint16_t  gdWMaxPq;
	uint16_t  gdWMmPq;
	uint16_t  gdTriggerPeriod;
	uint32_t  gdTriggerLinThresh;
	uint32_t  gdDelayMilliSec_ott;
#ifdef V1_6_1
	int16_t   gdRiseWeight;      /*Back light rise weight signed Q3.12 */
	int16_t   gdFallWeight;      /*Back light fall weight signed Q3.12 */
	uint32_t  gdDelayMilliSec_ll;/*Back light delay for LL case */
	u32  gdContrast;
	uint32_t  reserved[3];
#else
#ifdef V1_5
	uint32_t  reserved[6];
#else
	uint32_t  reserved[9];
#endif
#endif
};
#pragma pack(pop)

#ifdef V1_6_1
#define AMBIENT_UPD_FRONT     (uint32_t)(1<<0)
#define AMBIENT_UPD_REAR      (uint32_t)(1<<1)
#define AMBIENT_UPD_WHITEXY   (uint32_t)(1<<2)
#define AMBIENT_UPD_MODE      (uint32_t)(1<<3)

struct ambient_cfg_s {
	uint32_t update_flag;
	uint32_t ambient; /* 1<<16 */
	uint32_t tRearLum;
	uint32_t tFrontLux;
	uint32_t tWhiteX; /* 1<<15 */
	uint32_t tWhiteY; /* 1<<15 */
};

/*! @brief Ambient light configuration.*/
# pragma pack(push, 1)
struct AmbientCfg {
	uint32_t ambient;
	uint32_t tFrontLux;
	uint32_t tFrontLuxScale;
	uint32_t tRearLum;
	uint32_t tRearLumScale;
	uint32_t tWhitexy[2];
	uint32_t tSurroundReflection;
	uint32_t tScreenReflection;
	uint32_t alDelay;
	uint32_t alRise;
	uint32_t alFall;
};
#pragma pack(pop)

/*! @brief Adaptive Boost configuration.*/
# pragma pack(push, 1)
struct TgtABCfg {
	int32_t   abEnable;             /*Adaptive boost enabled */
	uint32_t  abHighestTmax;        /*Adaptive boost highest Tmax */
	uint32_t  abLowestTmax;         /*Adaptive boost lowest Tmax  */
	int16_t   abRiseWeight;         /*Back light rise weight signed Q3.12 */
	int16_t   abFallWeight;         /*Back light fall weight signed Q3.12 */
	uint32_t  abDelayMilliSec_hdmi; /*Back light delay for HDMI case */
	uint32_t  abDelayMilliSec_ott;  /*Back light delay for OTT case */
	uint32_t  abDelayMilliSec_ll;   /*Back light delay for LL case */
	uint32_t  reserved[3];
};
#pragma pack(pop)


# pragma pack(push, 1)
struct TargetDisplayConfig {
	uint16_t gamma;        /*Gamma */
	uint16_t eotf;         /*Target EOTF */
	uint16_t rangeSpec;    /*Target Range */
	uint16_t maxPq;        /*Target max luminance in PQ */
	uint16_t minPq;        /*Target min luminance in PQ */
	uint16_t maxPq_dm3;    /*Target max luminance for DM3 in PQ  */
	int32_t  min_lin;      /*Target min luminance in linear scale 2^18 */
	int32_t  max_lin;      /*Target max luminance in linear scale 2^18 */
	int32_t  max_lin_dm3;  /*Target max luminance for DM 3*/
	int32_t  tPrimaries[8];/*Target primaries */
	uint16_t mSWeight;  /*Multi-scale Weight,maybe overwritten by metadata*/
	int16_t  trimSlopeBias;  /*Trim Slope bias */
	int16_t  trimOffsetBias; /*Trim Offset bias */
	int16_t  trimPowerBias;      /*Trim Power bias */
	int16_t  msWeightBias;       /*Multi-scale weight bias */
	int16_t  chromaWeightBias;   /*Tone mapping chroma weight bias */
	int16_t  saturationGainBias; /*Tone mapping saturation gain bias */
	uint16_t tuningMode;         /*Tuning Mode */
	int16_t  brightness;         /*Brightness */
	int16_t  contrast;           /*Contrast */
	int16_t  dColorShift;        /*ColorShift */
	int16_t  dSaturation;        /*Saturation */
	int16_t  dBacklight;         /*Backlight */
	int16_t  dbgExecParamsPrintPeriod; /*Print reg values every n-th frame*/
	int16_t  dbgDmMdPrintPeriod;       /*Print DM metadata*/
	int16_t  dbgDmCfgPrintPeriod;      /*Print DM configuration*/
	struct TgtGDCfg  gdConfig;         /*Global Dimming configuration */
	struct TgtABCfg  abConfig;         /*Adaptive boost configuration */
	struct AmbientCfg ambientConfig;   /*Ambient light configuration */
	uint8_t  vsvdb[7];
	uint8_t  dm31_avail;
	uint8_t  reference_mode_dark_id;
	uint8_t  applyL11;
	uint8_t  reserved1[1];
	int16_t  backlight_scaler;       /*Backlight Scaler */
	struct TgtOutCscCfg ocscConfig;  /*Output CSC configuration */
	int16_t  brightnessPreservation; /*Brightness preservation */
	uint8_t  num_total_viewing_modes;/*Num of total viewing modes in cfg*/
	uint8_t  viewing_mode_valid;     /*1 if the viewing mode is valid*/
	u32 ambientFrontLux[AMB_LUT_SIZE];
	u32 ambientCompLevel[AMB_LUT_SIZE];
	s16  midPQBiasLut[TUNING_LUT_ENTRIES];       /**<@brief  Mid PQ Bias Lut */
	s16  slopeBiasLut[TUNING_LUT_ENTRIES];       /**<@brief  Slope Bias Lut */
	s16  backlightBiasLut[TUNING_LUT_ENTRIES];   /**<@brief  Backlight Bias Lut */
	s16  userBrightnessUIlut[DM4_TUNING_LUT_ENTRIES];
	s16  padding2;
	s16  bluPwm[BLU_LUT_SIZE];
	s16  bluLight[BLU_LUT_SIZE];
	s16  padding[36];
};
#pragma pack(pop)

#else
/*! @defgroup general Enumerations and data structures*/
# pragma pack(push, 1)
struct TargetDisplayConfig {
	uint16_t gain;
	uint16_t offset;
	uint16_t gamma;         /**<@brief  Gamma */
	uint16_t eotf;
	uint16_t bitDepth;      /**<@brief  Bit Depth */
	uint16_t rangeSpec;
	uint16_t diagSize;      /**<@brief  Diagonal Size */
	uint16_t maxPq;
	uint16_t minPq;
	uint16_t mSWeight;
	uint16_t mSEdgeWeight;
	int16_t  minPQBias;
	int16_t  midPQBias;
	int16_t  maxPQBias;
	int16_t  trimSlopeBias;
	int16_t  trimOffsetBias;
	int16_t  trimPowerBias;
	int16_t  msWeightBias;
	int16_t  brightness;         /**<@brief  Brighness */
	int16_t  contrast;           /**<@brief  Contrast */
	int16_t  chromaWeightBias;
	int16_t  saturationGainBias;
	uint16_t chromaWeight;
	uint16_t saturationGain;
	uint16_t crossTalk;
	uint16_t tuningMode;
	int16_t  reserved0;
	int16_t  dbgExecParamsPrintPeriod;
	int16_t  dbgDmMdPrintPeriod;
	int16_t  dbgDmCfgPrintPeriod;
	uint16_t maxPq_dupli;
	uint16_t minPq_dupli;
	int32_t  keyWeight;
	int32_t  intensityVectorWeight;
	int32_t  chromaVectorWeight;
	int16_t  chip_fpga_lowcomplex;
	int16_t  midPQBiasLut[TUNING_LUT_ENTRIES];
	int16_t  saturationGainBiasLut[TUNING_LUT_ENTRIES];
	int16_t  chromaWeightBiasLut[TUNING_LUT_ENTRIES];
	int16_t  slopeBiasLut[TUNING_LUT_ENTRIES];
	int16_t  offsetBiasLut[TUNING_LUT_ENTRIES];
	int16_t  backlightBiasLut[TUNING_LUT_ENTRIES];
	struct TgtGDCfg gdConfig;
#ifdef V1_5
	uint8_t  vsvdb[7];
	uint8_t  reserved1[5];
#endif
	int32_t  min_lin;
	int32_t  max_lin;
	int16_t  backlight_scaler;
	int32_t  min_lin_dupli;
	int32_t  max_lin_dupli;
	struct TgtOutCscCfg ocscConfig;
#ifdef V1_5
	int16_t  reserved2;
#else
	int16_t  reserved00;
#endif
	int16_t  brightnessPreservation;
	int32_t  iintensityVectorWeight;
	int32_t  ichromaVectorWeight;
	int16_t  isaturationGainBias;
	int16_t  chip_12b_ocsc;
	int16_t  chip_512_tonecurve;
	int16_t  chip_nolvl5;
	int16_t  padding[8];
};
#pragma pack(pop)
#endif
/*! @brief PQ config main data structure.*/
struct pq_config_s {
#ifndef V1_6_1
	unsigned char default_gm_lut[GM_LUT_HDR_SIZE + GM_LUT_SIZE];
	unsigned char gd_gm_lut_min[GM_LUT_HDR_SIZE + GM_LUT_SIZE];
	unsigned char gd_gm_lut_max[GM_LUT_HDR_SIZE + GM_LUT_SIZE];
	unsigned char pq2gamma[sizeof(int32_t)*PQ2G_LUT_SIZE];
#endif
	unsigned char backlight_lut[BACLIGHT_LUT_SIZE];
	struct TargetDisplayConfig target_display_config;
};

enum input_mode_e {
	INPUT_MODE_OTT  = 0,
	INPUT_MODE_HDMI = 1
};

struct ui_menu_params_s {
	uint16_t u16BackLightUIVal;
	uint16_t u16BrightnessUIVal;
	uint16_t u16ContrastUIVal;
};

enum signal_format_e {
	FORMAT_INVALID = -1,
	FORMAT_DOVI = 0,
	FORMAT_HDR10 = 1,
	FORMAT_SDR = 2,
	FORMAT_DOVI_LL = 3,
	FORMAT_HLG = 4,
	FORMAT_HDR10PLUS = 5,
	FORMAT_SDR_2020 = 6,
	FORMAT_MVC = 7
};

enum priority_mode_e {
	VIDEO_PRIORITY = 0,
	GRAPHIC_PRIORITY = 1,
	/* same as video priority, but will only switch to video*/
	/* priority after scene refresh flag has been received */
	VIDEO_PRIORITY_DELAYED = 2
};

enum cp_signal_range_e {
	SIG_RANGE_SMPTE = 0,  /* head range */
	SIG_RANGE_FULL  = 1,  /* full range */
	SIG_RANGE_SDI   = 2           /* PQ */
};

enum graphics_format_e {
	GF_SDR_YUV = 0,  /* BT.709 YUV BT1886 */
	GF_SDR_RGB = 1,  /* BT.709 RGB BT1886 */
	GF_HDR_YUV = 2,  /* BT.2020 YUV PQ */
	GF_HDR_RGB = 3   /* BT.2020 RGB PQ */
};

struct run_mode_s {
	uint16_t width;
	uint16_t height;
	uint16_t el_width;
	uint16_t el_height;
	uint16_t hdmi_mode;
};

struct composer_register_ipcore_s {
	/* offset 0xc8 */
	uint32_t Composer_Mode;
	uint32_t VDR_Resolution;
	uint32_t Bit_Depth;
	uint32_t Coefficient_Log2_Denominator;
	uint32_t BL_Num_Pivots_Y;
	uint32_t BL_Pivot[5];
	uint32_t BL_Order;
	uint32_t BL_Coefficient_Y[8][3];
	uint32_t EL_NLQ_Offset_Y;
	uint32_t EL_Coefficient_Y[3];
	uint32_t Mapping_IDC_U;
	uint32_t BL_Num_Pivots_U;
	uint32_t BL_Pivot_U[3];
	uint32_t BL_Order_U;
	uint32_t BL_Coefficient_U[4][3];
	uint32_t MMR_Coefficient_U[22][2];
	uint32_t MMR_Order_U;
	uint32_t EL_NLQ_Offset_U;
	uint32_t EL_Coefficient_U[3];
	uint32_t Mapping_IDC_V;
	uint32_t BL_Num_Pivots_V;
	uint32_t BL_Pivot_V[3];
	uint32_t BL_Order_V;
	uint32_t BL_Coefficient_V[4][3];
	uint32_t MMR_Coefficient_V[22][2];
	uint32_t MMR_Order_V;
	uint32_t EL_NLQ_Offset_V;
	uint32_t EL_Coefficient_V[3];
};

/** @brief DM registers for IPCORE 1 */
struct dm_register_ipcore_1_s {
	uint32_t SRange;
	uint32_t Srange_Inverse;
	uint32_t Frame_Format_1;
	uint32_t Frame_Format_2;
	uint32_t Frame_Pixel_Def;
	uint32_t Y2RGB_Coefficient_1;
	uint32_t Y2RGB_Coefficient_2;
	uint32_t Y2RGB_Coefficient_3;
	uint32_t Y2RGB_Coefficient_4;
	uint32_t Y2RGB_Coefficient_5;
	uint32_t Y2RGB_Offset_1;
	uint32_t Y2RGB_Offset_2;
	uint32_t Y2RGB_Offset_3;
	uint32_t EOTF;
/*	uint32_t Sparam_1;*/
/*	uint32_t Sparam_2;*/
/*	uint32_t Sgamma; */
	uint32_t A2B_Coefficient_1;
	uint32_t A2B_Coefficient_2;
	uint32_t A2B_Coefficient_3;
	uint32_t A2B_Coefficient_4;
	uint32_t A2B_Coefficient_5;
	uint32_t C2D_Coefficient_1;
	uint32_t C2D_Coefficient_2;
	uint32_t C2D_Coefficient_3;
	uint32_t C2D_Coefficient_4;
	uint32_t C2D_Coefficient_5;
	uint32_t C2D_Offset;
	uint32_t Active_area_left_top;
	uint32_t Active_area_bottom_right;
};

/** @brief DM registers for IPCORE 2 */
struct dm_register_ipcore_2_s {
	uint32_t SRange;
	uint32_t Srange_Inverse;
	uint32_t Y2RGB_Coefficient_1;
	uint32_t Y2RGB_Coefficient_2;
	uint32_t Y2RGB_Coefficient_3;
	uint32_t Y2RGB_Coefficient_4;
	uint32_t Y2RGB_Coefficient_5;
	uint32_t Y2RGB_Offset_1;
	uint32_t Y2RGB_Offset_2;
	uint32_t Y2RGB_Offset_3;
	uint32_t Frame_Format;
	uint32_t EOTF;
	uint32_t A2B_Coefficient_1;
	uint32_t A2B_Coefficient_2;
	uint32_t A2B_Coefficient_3;
	uint32_t A2B_Coefficient_4;
	uint32_t A2B_Coefficient_5;
	uint32_t C2D_Coefficient_1;
	uint32_t C2D_Coefficient_2;
	uint32_t C2D_Coefficient_3;
	uint32_t C2D_Coefficient_4;
	uint32_t C2D_Coefficient_5;
	uint32_t C2D_Offset;
	uint32_t VDR_Resolution;
};

/** @brief DM registers for IPCORE 3 */
struct dm_register_ipcore_3_s {
	uint32_t D2C_coefficient_1;
	uint32_t D2C_coefficient_2;
	uint32_t D2C_coefficient_3;
	uint32_t D2C_coefficient_4;
	uint32_t D2C_coefficient_5;
	uint32_t B2A_Coefficient_1;
	uint32_t B2A_Coefficient_2;
	uint32_t B2A_Coefficient_3;
	uint32_t B2A_Coefficient_4;
	uint32_t B2A_Coefficient_5;
	uint32_t Eotf_param_1;
	uint32_t Eotf_param_2;
	uint32_t IPT_Scale;
	uint32_t IPT_Offset_1;
	uint32_t IPT_Offset_2;
	uint32_t IPT_Offset_3;
	uint32_t Output_range_1;
	uint32_t Output_range_2;
	uint32_t RGB2YUV_coefficient_register1;
	uint32_t RGB2YUV_coefficient_register2;
	uint32_t RGB2YUV_coefficient_register3;
	uint32_t RGB2YUV_coefficient_register4;
	uint32_t RGB2YUV_coefficient_register5;
	uint32_t RGB2YUV_offset_0;
	uint32_t RGB2YUV_offset_1;
	uint32_t RGB2YUV_offset_2;
};

/** @brief DM luts for IPCORE 1 and 2 */
struct dm_lut_ipcore_s {
	uint32_t TmLutI[64*4];
	uint32_t TmLutS[64*4];
	uint32_t SmLutI[64*4];
	uint32_t SmLutS[64*4];
	uint32_t G2L[DEF_G2L_LUT_SIZE];
};

/** @brief hdmi metadata for IPCORE 3 */
struct md_reister_ipcore_3_s {
	uint32_t raw_metadata[512];
	uint32_t size;
};

struct hdr_10_infoframe_s {
	uint8_t infoframe_type_code;
	uint8_t infoframe_version_number;
	uint8_t length_of_info_frame;
	uint8_t data_byte_1;
	uint8_t data_byte_2;
	uint8_t display_primaries_x_0_LSB;
	uint8_t display_primaries_x_0_MSB;
	uint8_t display_primaries_y_0_LSB;
	uint8_t display_primaries_y_0_MSB;
	uint8_t display_primaries_x_1_LSB;
	uint8_t display_primaries_x_1_MSB;
	uint8_t display_primaries_y_1_LSB;
	uint8_t display_primaries_y_1_MSB;
	uint8_t display_primaries_x_2_LSB;
	uint8_t display_primaries_x_2_MSB;
	uint8_t display_primaries_y_2_LSB;
	uint8_t display_primaries_y_2_MSB;
	uint8_t white_point_x_LSB;
	uint8_t white_point_x_MSB;
	uint8_t white_point_y_LSB;
	uint8_t white_point_y_MSB;
	uint8_t max_display_mastering_luminance_LSB;
	uint8_t max_display_mastering_luminance_MSB;
	uint8_t min_display_mastering_luminance_LSB;
	uint8_t min_display_mastering_luminance_MSB;
	uint8_t max_content_light_level_LSB;
	uint8_t max_content_light_level_MSB;
	uint8_t max_frame_average_light_level_LSB;
	uint8_t max_frame_average_light_level_MSB;
};

struct hdr10_param_s {
	uint32_t min_display_mastering_luminance;
	uint32_t max_display_mastering_luminance;
	uint16_t Rx;
	uint16_t Ry;
	uint16_t Gx;
	uint16_t Gy;
	uint16_t Bx;
	uint16_t By;
	uint16_t Wx;
	uint16_t Wy;
	uint16_t max_content_light_level;
	uint16_t max_pic_average_light_level;
};

#ifdef V2_4
struct dm_metadata_base_s {
	/* signal attributes */
	/* affected_dm_metadata_id<<4|current_dm_metadata_id */
	unsigned char dm_metadata_id;
	unsigned char scene_refresh_flag;
	unsigned char YCCtoRGB_coef0_hi;
	unsigned char YCCtoRGB_coef0_lo;
	unsigned char YCCtoRGB_coef1_hi;
	unsigned char YCCtoRGB_coef1_lo;
	unsigned char YCCtoRGB_coef2_hi;
	unsigned char YCCtoRGB_coef2_lo;
	unsigned char YCCtoRGB_coef3_hi;
	unsigned char YCCtoRGB_coef3_lo;
	unsigned char YCCtoRGB_coef4_hi;
	unsigned char YCCtoRGB_coef4_lo;
	unsigned char YCCtoRGB_coef5_hi;
	unsigned char YCCtoRGB_coef5_lo;
	unsigned char YCCtoRGB_coef6_hi;
	unsigned char YCCtoRGB_coef6_lo;
	unsigned char YCCtoRGB_coef7_hi;
	unsigned char YCCtoRGB_coef7_lo;
	unsigned char YCCtoRGB_coef8_hi;
	unsigned char YCCtoRGB_coef8_lo;
	unsigned char YCCtoRGB_offset0_byte3;
	unsigned char YCCtoRGB_offset0_byte2;
	unsigned char YCCtoRGB_offset0_byte1;
	unsigned char YCCtoRGB_offset0_byte0;
	unsigned char YCCtoRGB_offset1_byte3;
	unsigned char YCCtoRGB_offset1_byte2;
	unsigned char YCCtoRGB_offset1_byte1;
	unsigned char YCCtoRGB_offset1_byte0;
	unsigned char YCCtoRGB_offset2_byte3;
	unsigned char YCCtoRGB_offset2_byte2;
	unsigned char YCCtoRGB_offset2_byte1;
	unsigned char YCCtoRGB_offset2_byte0;
	unsigned char RGBtoLMS_coef0_hi;
	unsigned char RGBtoLMS_coef0_lo;
	unsigned char RGBtoLMS_coef1_hi;
	unsigned char RGBtoLMS_coef1_lo;
	unsigned char RGBtoLMS_coef2_hi;
	unsigned char RGBtoLMS_coef2_lo;
	unsigned char RGBtoLMS_coef3_hi;
	unsigned char RGBtoLMS_coef3_lo;
	unsigned char RGBtoLMS_coef4_hi;
	unsigned char RGBtoLMS_coef4_lo;
	unsigned char RGBtoLMS_coef5_hi;
	unsigned char RGBtoLMS_coef5_lo;
	unsigned char RGBtoLMS_coef6_hi;
	unsigned char RGBtoLMS_coef6_lo;
	unsigned char RGBtoLMS_coef7_hi;
	unsigned char RGBtoLMS_coef7_lo;
	unsigned char RGBtoLMS_coef8_hi;
	unsigned char RGBtoLMS_coef8_lo;
	unsigned char signal_eotf_hi;
	unsigned char signal_eotf_lo;
	unsigned char signal_eotf_param0_hi;
	unsigned char signal_eotf_param0_lo;
	unsigned char signal_eotf_param1_hi;
	unsigned char signal_eotf_param1_lo;
	unsigned char signal_eotf_param2_byte3;
	unsigned char signal_eotf_param2_byte2;
	unsigned char signal_eotf_param2_byte1;
	unsigned char signal_eotf_param2_byte0;
	unsigned char signal_bit_depth;
	unsigned char signal_color_space;
	unsigned char signal_chroma_format;
	unsigned char signal_full_range_flag;
	/* source display attributes */
	unsigned char source_min_PQ_hi;
	unsigned char source_min_PQ_lo;
	unsigned char source_max_PQ_hi;
	unsigned char source_max_PQ_lo;
	unsigned char source_diagonal_hi;
	unsigned char source_diagonal_lo;
	/* extended metadata */
	unsigned char num_ext_blocks;
};

struct ext_level_1_s {
	uint8_t min_PQ_hi;
	uint8_t min_PQ_lo;
	uint8_t max_PQ_hi;
	uint8_t max_PQ_lo;
	uint8_t avg_PQ_hi;
	uint8_t avg_PQ_lo;
};

struct ext_level_2_s {
	uint8_t target_max_PQ_hi;
	uint8_t target_max_PQ_lo;
	uint8_t trim_slope_hi;
	uint8_t trim_slope_lo;
	uint8_t trim_offset_hi;
	uint8_t trim_offset_lo;
	uint8_t trim_power_hi;
	uint8_t trim_power_lo;
	uint8_t trim_chroma_weight_hi;
	uint8_t trim_chroma_weight_lo;
	uint8_t trim_saturation_gain_hi;
	uint8_t trim_saturation_gain_lo;
	uint8_t ms_weight_hi;
	uint8_t ms_weight_lo;
};

struct ext_level_4_s {
	uint8_t anchor_PQ_hi;
	uint8_t anchor_PQ_lo;
	uint8_t anchor_power_hi;
	uint8_t anchor_power_lo;
};

struct ext_level_5_s {
	uint8_t active_area_left_offset_hi;
	uint8_t active_area_left_offset_lo;
	uint8_t active_area_right_offset_hi;
	uint8_t active_area_right_offset_lo;
	uint8_t active_area_top_offset_hi;
	uint8_t active_area_top_offset_lo;
	uint8_t active_area_bottom_offset_hi;
	uint8_t active_area_bottom_offset_lo;
};

struct ext_level_6_s {
	uint8_t max_display_mastering_luminance_hi;
	uint8_t max_display_mastering_luminance_lo;
	uint8_t min_display_mastering_luminance_hi;
	uint8_t min_display_mastering_luminance_lo;
	uint8_t max_content_light_level_hi;
	uint8_t max_content_light_level_lo;
	uint8_t max_frame_average_light_level_hi;
	uint8_t max_frame_average_light_level_lo;
};

struct ext_level_254_s {
	unsigned char dm_mode;
	unsigned char dm_version_index;
};

struct ext_level_255_s {
	uint8_t dm_run_mode;
	uint8_t dm_run_version;
	uint8_t dm_debug0;
	uint8_t dm_debug1;
	uint8_t dm_debug2;
	uint8_t dm_debug3;
};

struct ext_md_s {
	uint32_t available_level_mask;
	struct ext_level_1_s level_1;
	struct ext_level_2_s level_2;
	struct ext_level_4_s level_4;
	struct ext_level_5_s level_5;
	struct ext_level_6_s level_6;
	struct ext_level_255_s level_255;
};
#endif

enum dm_algo_e {
	DM_ALGO_INVALID = -1,
	DM_ALGO_DM29 = 0,
	DM_ALGO_DM31 = 1,
	DM_ALGO_DM4  = 2
};

struct dovi_setting_s {
	struct composer_register_ipcore_s comp_reg;
	struct dm_register_ipcore_1_s dm_reg1;
	struct dm_register_ipcore_2_s dm_reg2;
	struct dm_register_ipcore_3_s dm_reg3;
	struct dm_lut_ipcore_s dm_lut1;
	struct dm_lut_ipcore_s dm_lut2;
	/* for dovi output */
	struct md_reister_ipcore_3_s md_reg3;
	/* for hdr10 output */
	struct hdr_10_infoframe_s hdr_info;
	/* current process */
	enum signal_format_e src_format;
	enum signal_format_e dst_format;
	/* enhanced layer */
	bool el_flag;
	bool el_halfsize_flag;
	/* frame width & height */
	uint32_t video_width;
	uint32_t video_height;
#ifdef V2_4
	/* use for stb 2.4 */
	enum graphics_format_e g_format;
	uint32_t g_bitdepth;
	uint32_t dovi2hdr10_nomapping;
	uint32_t use_ll_flag;
	uint32_t ll_rgb_desired;
	uint32_t diagnostic_enable;
	uint32_t diagnostic_mux_select;
	uint32_t dovi_ll_enable;
	uint32_t vout_width;
	uint32_t vout_height;
	u8 vsvdb_tbl[32];
	struct ext_md_s ext_md;
	uint32_t vsvdb_len;
	uint32_t vsvdb_changed;
	uint32_t mode_changed;
#endif
};

struct dv_cfg_info_s {
	int id;
	char pic_mode_name[32];
	s16  brightness;        /*Brightness */
	s16  contrast;          /*Contrast */
	s16  colorshift;        /*ColorShift or Tint*/
	s16  saturation;        /*Saturation or color */
	u8  vsvdb[7];
};

struct dv_pq_center_value_s {
	s16  brightness;        /*Brightness */
	s16  contrast;          /*Contrast */
	s16  colorshift;        /*ColorShift or Tint*/
	s16  saturation;        /*Saturation or color */
};

struct dv_pq_range_s {
	s16  left;
	s16  right;
};

struct tv_input_info_s {
	s16 brightness_off[8][2];
	s32 content_fps;
	s32 gd_rf_adjust;
	s32 debug_buf[498];
};

#ifdef V1_6_1
#define PREFIX_SEI_NUT 39
#define SUFFIX_SEI_NUT 40
#define SEI_USER_DATA_REGISTERED_ITU_T_T35 4
#define SEI_MASTERING_DISPLAY_COLOUR_VOLUME 137

#define MAX_LENGTH_2086_SEI 256
#define MAX_LENGTH_2094_SEI 256

/* VUI parameters required to generate Dolby Vision metadata for ATSC 3.0*/
struct _dv_vui_param_s_ {
	int32_t  i_video_format;
	int      b_video_full_range;
	int      b_colour_description;
	int32_t  i_colour_primaries;
	int32_t  i_transfer_characteristics;
	int32_t  i_matrix_coefficients;
};

/* Data structure that combines all ATSC related parameters.*/
struct _dv_atsc_s_ {
	struct _dv_vui_param_s_  vui_param;
	uint32_t length_2086_sei;
	uint8_t  payload_2086_sei[MAX_LENGTH_2086_SEI];
	uint32_t length_2094_sei;
	uint8_t  payload_2094_sei[MAX_LENGTH_2094_SEI];
};
#endif

enum cpuID_e {
	_CPU_MAJOR_ID_GXM,
	_CPU_MAJOR_ID_TXLX,
	_CPU_MAJOR_ID_G12,
	_CPU_MAJOR_ID_TM2,
	_CPU_MAJOR_ID_TM2_REVB,
	_CPU_MAJOR_ID_UNKNOWN,
};

struct dv_device_data_s {
	enum cpuID_e cpu_id;
};

struct amdolby_vision_port_t {
	const char *name;
	struct device *dev;
	const struct file_operations *fops;
	void *runtime;
};

extern int control_path(
	enum signal_format_e in_format,
	enum signal_format_e out_format,
	char *in_comp, int in_comp_size,
	char *in_md, int in_md_size,
	enum priority_mode_e set_priority,
	int set_bit_depth, int set_chroma_format, int set_yuv_range,
	int set_graphic_min_lum, int set_graphic_max_lum,
	int set_target_min_lum, int set_target_max_lum,
	int set_no_el,
	struct hdr10_param_s *hdr10_param,
	struct dovi_setting_s *output);

struct tv_dovi_setting_s {
	uint64_t core1_reg_lut[3754];
	/* current process */
	enum signal_format_e src_format;
	enum signal_format_e dst_format;
	/* enhanced layer */
	bool el_flag;
	bool el_halfsize_flag;
	/* frame width & height */
	uint32_t video_width;
	uint32_t video_height;
	enum input_mode_e input_mode;
	uint16_t backlight;
};
#ifdef V1_6_1
extern int tv_control_path(
	enum signal_format_e in_format,
	enum input_mode_e in_mode,
	char *in_comp, int in_comp_size,
	char *in_md, int in_md_size,
	int set_bit_depth, int set_chroma_format, int set_yuv_range,
	struct pq_config_s *pq_config,
	struct ui_menu_params_s *menu_param,
	int set_no_el,
	struct hdr10_param_s *hdr10_param,
	struct tv_dovi_setting_s *output,
	char *vsem_if, int vsem_if_size,
	struct ambient_cfg_s *ambient_cfg,
	struct tv_input_info_s *input_info);
#else
extern int tv_control_path(
	enum signal_format_e in_format,
	enum input_mode_e in_mode,
	char *in_comp, int in_comp_size,
	char *in_md, int in_md_size,
	int set_bit_depth, int set_chroma_format, int set_yuv_range,
	struct pq_config_s *pq_config,
	struct ui_menu_params_s *menu_param,
	int set_no_el,
	struct hdr10_param_s *hdr10_param,
	struct tv_dovi_setting_s *output);

#endif

extern void *metadata_parser_init(int flag);
extern int metadata_parser_reset(int flag);
extern int metadata_parser_process(
	char  *src_rpu, int rpu_len,
	char  *dst_comp, int *comp_len,
	char  *dst_md, int *md_len, bool src_eos);
extern void metadata_parser_release(void);

struct dolby_vision_func_s {
	const char *version_info;
	void * (*metadata_parser_init)(int flag);
	/*flag: bit0 flag, bit1 0->dv, 1->atsc*/
	int (*metadata_parser_reset)(int flag);
	int (*metadata_parser_process)(
		char  *src_rpu, int rpu_len,
		char  *dst_comp, int *comp_len,
		char  *dst_md, int *md_len, bool src_eos);
	void (*metadata_parser_release)(void);
	int (*control_path)(
		enum signal_format_e in_format,
		enum signal_format_e out_format,
		char *in_comp, int in_comp_size,
		char *in_md, int in_md_size,
		enum priority_mode_e set_priority,
		int set_bit_depth, int set_chroma_format, int set_yuv_range,
		int set_graphic_min_lum, int set_graphic_max_lum,
		int set_target_min_lum, int set_target_max_lum,
		int set_no_el,
		struct hdr10_param_s *hdr10_param,
		struct dovi_setting_s *output);
#ifdef V1_6_1
	int (*tv_control_path)(
		enum signal_format_e in_format,
		enum input_mode_e in_mode,
		char *in_comp, int in_comp_size,
		char *in_md, int in_md_size,
		int set_bit_depth, int set_chroma_format, int set_yuv_range,
		struct pq_config_s *pq_config,
		struct ui_menu_params_s *menu_param,
		int set_no_el,
		struct hdr10_param_s *hdr10_param,
		struct tv_dovi_setting_s *output,
		char *vsem_if, int vsem_if_size,
		struct ambient_cfg_s *ambient_cfg,
		struct tv_input_info_s *input_info);
#else
	int (*tv_control_path)(
		enum signal_format_e in_format,
		enum input_mode_e in_mode,
		char *in_comp, int in_comp_size,
		char *in_md, int in_md_size,
		int set_bit_depth, int set_chroma_format, int set_yuv_range,
		struct pq_config_s *pq_config,
		struct ui_menu_params_s *menu_param,
		int set_no_el,
		struct hdr10_param_s *hdr10_param,
		struct tv_dovi_setting_s *output);
#endif
};

extern int register_dv_functions(const struct dolby_vision_func_s *func);
extern int unregister_dv_functions(void);
#ifndef CONFIG_AMLOGIC_MEDIA_VSYNC_RDMA
#define VSYNC_WR_MPEG_REG(adr, val) WRITE_VPP_REG(adr, val)
#define VSYNC_RD_MPEG_REG(adr) READ_VPP_REG(adr)
#define VSYNC_WR_MPEG_REG_BITS(adr, val, start, len) \
	WRITE_VPP_REG_BITS(adr, val, start, len)
#else
extern int VSYNC_WR_MPEG_REG_BITS(u32 adr, u32 val, u32 start, u32 len);
extern u32 VSYNC_RD_MPEG_REG(u32 adr);
extern int VSYNC_WR_MPEG_REG(u32 adr, u32 val);
#endif

void dv_mem_power_on(enum vpu_mod_e mode);
void dv_mem_power_off(enum vpu_mod_e mode);
int get_dv_mem_power_flag(enum vpu_mod_e mode);
bool get_disable_video_flag(enum vd_path_e vd_path);

#endif
