/*
 * drivers/amlogic/media/enhancement/amvecm/arch/hdr_curve.h
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#ifndef HDR_CURVE_H
#define HDR_CURVE_H

/*hdr eotf & oetf curve setting*/
/*panel from 260nit to 1000nit*/
/*matlab parameters:
 *% default setting for TV:
 *panel_lum_max = 260; % nits, maximum panel luminance (260~1000)
 *alpha_low = 0.075;    % 0: no dark boost; otherwise add dark boost
 *panel_gamma = 2.2; % panel gamma 1.8, 2.0, 2.2, ...

 *osd_merge_lut = 1; % whether merge osd
	eo/oe lut to solve table resolution issue

 *src_lum_max = 10000;  % nits, maximum of 10000 nits
 *dsp_lum_max = 10000;   % nits, maximum luma of display luminance
 *panel_lum_max = min(1000, panel_lum_max);
 *panel_lum_max = max(100, panel_lum_max)
 *panel_soft_clip_th = 912;
 *hlg_lum_max = 1200;  % nits, use HLG curve instead of 709 gamma
 *lum_norm = 10000;    % nits, 2084 maximum lum
 *eotf_scl = 2^(floor(log2(10000/panel_lum_max))-1)
	% to increase precision could be 1,2,4,8,16
 *eo_scale = 1;     % eotf scale
 *eotf_norm = (2^14)*eo_scale ;  % 14bit(16384)=1.0; 15bit(32768)=1.0
 *fact_scl = 1 / eo_scale;      % min(max(1,src_lum_max/dsp_lum_max),4);
	% factors to be applied to linear RGB before going to LUT289
 *oetf_norm = (2^14); % oetf normalization
 *oetf_scl = max(1,hlg_lum_max/100); % 1200
 *blx_soft = 0;        % 0: means not black soft cliping;
	otherwise soft clipping, e.g. 2*4
*/
unsigned int eotf_33_2084_table[][33] = {
	{/*260*/
	    0,     4,     9,    16,    27,    43,    66,   101,
	  149,   219,   315,   449,   644,   911,  1273,  1762,
	 2418,  3297,  4468,  6028,  8100, 10851, 14501, 14938,
	15304, 15605, 15847, 16035, 16176, 16276, 16339, 16373,
	16383
	},
	{/*280*/
	    0,     4,     9,    16,    27,    43,    66,   101,
	  149,   219,   315,   449,   644,   911,  1273,  1762,
	 2418,  3297,  4468,  6028,  8100, 10851, 14501, 14938,
	15304, 15605, 15847, 16035, 16176, 16276, 16339, 16373,
	16383
	},
	{/*300*/
	    0,     4,     9,    16,    27,    43,    66,   101,
	  149,   219,   315,   449,   644,   911,  1273,  1762,
	 2418,  3297,  4468,  6028,  8100, 10851, 14501, 14938,
	15304, 15605, 15847, 16035, 16176, 16276, 16339, 16373,
	16383
	},
	{/*320*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*340*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*360*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*380*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*400*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*420*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*440*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*460*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*480*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*500*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*600*/
	    0,     3,     6,    11,    18,    27,    40,    58,
	   84,   119,   169,   237,   329,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
	},
	{/*700*/
	    0,     2,     5,     8,    12,    18,    25,    35,
	   49,    68,    93,   128,   175,   239,   325,   440,
	  605,   824,  1117,  1507,  2025,  2713,  3625,  4836,
	 6445,  8583, 11430, 15228, 15695, 16025, 16237, 16350,
	16383
	},
	{/*800*/
	    0,     2,     5,     8,    12,    18,    25,    35,
	   49,    68,    93,   128,   175,   239,   325,   440,
	  605,   824,  1117,  1507,  2025,  2713,  3625,  4836,
	 6445,  8583, 11430, 15228, 15695, 16025, 16237, 16350,
	16383
	},
	{/*900*/
	    0,     2,     5,     8,    12,    18,    25,    35,
	   49,    68,    93,   128,   175,   239,   325,   440,
	  605,   824,  1117,  1507,  2025,  2713,  3625,  4836,
	 6445,  8583, 11430, 15228, 15695, 16025, 16237, 16350,
	16383
	},
	{/*1000*/
	    0,     2,     5,     8,    12,    18,    25,    35,
	   49,    68,    93,   128,   175,   239,   325,   440,
	  605,   824,  1117,  1507,  2025,  2713,  3625,  4836,
	 6445,  8583, 11430, 15228, 15695, 16025, 16237, 16350,
	16383
	}
};

unsigned int oetf_289_gamma22_table[][289] = {
	{/*260*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  125,  169,  202,  230,  255,  278,  297,
	 316,  333,  349,  364,  379,  393,  407,  420,
	 433,  445,  457,  468,  479,  489,  500,  510,
	 520,  530,  539,  549,  558,  567,  576,  585,
	 593,  602,  610,  618,  626,  634,  642,  649,
	 657,  664,  671,  678,  686,  693,  701,  708,
	 716,  724,  732,  739,  747,  755,  762,  769,
	 776,  782,  789,  794,  800,  805,  809,  813,
	 816,  819,  821,  823,  826,  828,  830,  832,
	 834,  836,  839,  841,  843,  845,  847,  849,
	 851,  853,  855,  857,  859,  861,  863,  865,
	 867,  869,  871,  873,  875,  877,  879,  880,
	 882,  884,  886,  888,  890,  891,  893,  895,
	 897,  898,  900,  902,  903,  905,  907,  908,
	 910,  912,  913,  915,  916,  918,  920,  921,
	 923,  924,  926,  927,  929,  930,  932,  933,
	 935,  936,  937,  939,  940,  942,  943,  944,
	 946,  947,  948,  950,  951,  952,  953,  955,
	 956,  957,  958,  960,  961,  962,  963,  964,
	 965,  967,  968,  969,  970,  971,  972,  973,
	 974,  975,  976,  977,  978,  979,  980,  981,
	 982,  983,  984,  985,  986,  987,  988,  989,
	 989,  990,  991,  992,  993,  994,  994,  995,
	 996,  997,  997,  998,  999, 1000, 1000, 1001,
	1002, 1002, 1003, 1004, 1004, 1005, 1006, 1006,
	1007, 1007, 1008, 1009, 1009, 1010, 1010, 1011,
	1011, 1012, 1012, 1013, 1013, 1014, 1014, 1014,
	1015, 1015, 1016, 1016, 1016, 1017, 1017, 1017,
	1018, 1018, 1018, 1019, 1019, 1019, 1020, 1020,
	1020, 1020, 1021, 1021, 1021, 1021, 1021, 1022,
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*280*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  121,  163,  195,  222,  247,  268,  287,
	 305,  322,  337,  352,  367,  380,  393,  406,
	 418,  430,  441,  452,  463,  473,  483,  493,
	 502,  512,  521,  530,  539,  548,  557,  565,
	 573,  582,  589,  597,  605,  612,  620,  627,
	 634,  641,  648,  655,  662,  669,  677,  684,
	 692,  699,  707,  714,  721,  729,  736,  742,
	 749,  755,  761,  767,  772,  777,  782,  786,
	 789,  792,  794,  797,  799,  802,  804,  806,
	 809,  811,  813,  816,  818,  820,  823,  825,
	 827,  829,  832,  834,  836,  838,  841,  843,
	 845,  847,  849,  851,  853,  855,  858,  860,
	 862,  864,  866,  868,  870,  872,  874,  876,
	 878,  880,  881,  883,  885,  887,  889,  891,
	 893,  895,  896,  898,  900,  902,  903,  905,
	 907,  909,  910,  912,  914,  915,  917,  919,
	 920,  922,  924,  925,  927,  928,  930,  931,
	 933,  934,  936,  937,  939,  940,  942,  943,
	 945,  946,  947,  949,  950,  952,  953,  954,
	 956,  957,  958,  959,  961,  962,  963,  964,
	 966,  967,  968,  969,  970,  971,  973,  974,
	 975,  976,  977,  978,  979,  980,  981,  982,
	 983,  984,  985,  986,  987,  988,  989,  990,
	 991,  992,  993,  993,  994,  995,  996,  997,
	 998,  998,  999, 1000, 1001, 1001, 1002, 1003,
	1004, 1004, 1005, 1006, 1006, 1007, 1008, 1008,
	1009, 1009, 1010, 1011, 1011, 1012, 1012, 1013,
	1013, 1014, 1014, 1015, 1015, 1015, 1016, 1016,
	1017, 1017, 1017, 1018, 1018, 1019, 1019, 1019,
	1019, 1020, 1020, 1020, 1021, 1021, 1021, 1021,
	1021, 1022, 1022, 1022, 1022, 1022, 1022, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*300*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  117,  158,  189,  216,  239,  260,  278,
	 295,  311,  327,  341,  355,  368,  381,  393,
	 405,  417,  428,  438,  449,  458,  468,  478,
	 487,  496,  505,  514,  523,  531,  539,  548,
	 556,  563,  571,  579,  586,  594,  601,  608,
	 615,  622,  628,  635,  642,  648,  655,  661,
	 667,  674,  680,  686,  692,  698,  704,  710,
	 716,  722,  728,  733,  739,  745,  750,  756,
	 761,  767,  772,  778,  783,  789,  795,  801,
	 807,  813,  819,  825,  831,  836,  842,  848,
	 854,  859,  864,  869,  874,  879,  884,  888,
	 892,  895,  899,  902,  905,  907,  909,  910,
	 912,  913,  915,  916,  918,  919,  921,  922,
	 923,  925,  926,  927,  929,  930,  931,  933,
	 934,  935,  937,  938,  939,  940,  942,  943,
	 944,  945,  946,  948,  949,  950,  951,  952,
	 953,  955,  956,  957,  958,  959,  960,  961,
	 962,  963,  964,  965,  966,  967,  968,  969,
	 970,  971,  972,  973,  974,  975,  976,  977,
	 978,  979,  980,  980,  981,  982,  983,  984,
	 985,  986,  986,  987,  988,  989,  990,  990,
	 991,  992,  993,  993,  994,  995,  995,  996,
	 997,  997,  998,  999,  999, 1000, 1001, 1001,
	1002, 1002, 1003, 1004, 1004, 1005, 1005, 1006,
	1006, 1007, 1007, 1008, 1008, 1009, 1009, 1010,
	1010, 1011, 1011, 1012, 1012, 1013, 1013, 1013,
	1014, 1014, 1015, 1015, 1015, 1016, 1016, 1016,
	1017, 1017, 1017, 1018, 1018, 1018, 1018, 1019,
	1019, 1019, 1019, 1020, 1020, 1020, 1020, 1021,
	1021, 1021, 1021, 1021, 1021, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1022, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*320*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  153,  209,  252,  287,  317,  345,  370,
	 394,  416,  436,  455,  474,  491,  508,  524,
	 540,  555,  569,  584,  597,  611,  623,  636,
	 648,  661,  672,  684,  696,  707,  718,  729,
	 739,  750,  761,  772,  784,  796,  808,  820,
	 831,  841,  851,  860,  868,  874,  879,  882,
	 884,  886,  887,  889,  891,  892,  894,  895,
	 897,  899,  900,  902,  903,  905,  906,  908,
	 909,  911,  912,  913,  915,  916,  918,  919,
	 920,  922,  923,  924,  926,  927,  928,  930,
	 931,  932,  934,  935,  936,  937,  938,  940,
	 941,  942,  943,  944,  946,  947,  948,  949,
	 950,  951,  952,  953,  954,  955,  956,  958,
	 959,  960,  961,  962,  963,  964,  965,  965,
	 966,  967,  968,  969,  970,  971,  972,  973,
	 974,  975,  975,  976,  977,  978,  979,  979,
	 980,  981,  982,  983,  983,  984,  985,  986,
	 986,  987,  988,  988,  989,  990,  990,  991,
	 992,  992,  993,  994,  994,  995,  996,  996,
	 997,  997,  998,  998,  999, 1000, 1000, 1001,
	1001, 1002, 1002, 1003, 1003, 1004, 1004, 1005,
	1005, 1006, 1006, 1006, 1007, 1007, 1008, 1008,
	1009, 1009, 1009, 1010, 1010, 1011, 1011, 1011,
	1012, 1012, 1012, 1013, 1013, 1013, 1014, 1014,
	1014, 1015, 1015, 1015, 1015, 1016, 1016, 1016,
	1017, 1017, 1017, 1017, 1017, 1018, 1018, 1018,
	1018, 1019, 1019, 1019, 1019, 1019, 1020, 1020,
	1020, 1020, 1020, 1020, 1021, 1021, 1021, 1021,
	1021, 1021, 1021, 1021, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*340*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  149,  204,  245,  279,  309,  335,  360,
	 383,  404,  424,  442,  460,  477,  494,  510,
	 525,  539,  554,  567,  581,  594,  606,  619,
	 631,  642,  654,  666,  677,  688,  699,  709,
	 719,  730,  740,  751,  763,  774,  786,  797,
	 808,  818,  827,  836,  844,  850,  855,  858,
	 860,  862,  864,  866,  868,  870,  871,  873,
	 875,  877,  879,  880,  882,  884,  886,  887,
	 889,  891,  892,  894,  896,  897,  899,  900,
	 902,  904,  905,  907,  908,  910,  911,  913,
	 914,  916,  917,  919,  920,  921,  923,  924,
	 926,  927,  928,  930,  931,  932,  934,  935,
	 936,  938,  939,  940,  941,  943,  944,  945,
	 946,  947,  949,  950,  951,  952,  953,  954,
	 955,  956,  957,  959,  960,  961,  962,  963,
	 964,  965,  966,  967,  968,  969,  970,  971,
	 972,  972,  973,  974,  975,  976,  977,  978,
	 979,  980,  980,  981,  982,  983,  984,  984,
	 985,  986,  987,  987,  988,  989,  990,  990,
	 991,  992,  992,  993,  994,  994,  995,  996,
	 996,  997,  998,  998,  999,  999, 1000, 1001,
	1001, 1002, 1002, 1003, 1003, 1004, 1004, 1005,
	1005, 1006, 1006, 1007, 1007, 1008, 1008, 1009,
	1009, 1009, 1010, 1010, 1011, 1011, 1011, 1012,
	1012, 1013, 1013, 1013, 1014, 1014, 1014, 1015,
	1015, 1015, 1016, 1016, 1016, 1016, 1017, 1017,
	1017, 1017, 1018, 1018, 1018, 1018, 1019, 1019,
	1019, 1019, 1019, 1020, 1020, 1020, 1020, 1020,
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1022,
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*360*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  145,  198,  240,  272,  301,  327,  350,
	 373,  394,  413,  432,  449,  466,  482,  497,
	 512,  526,  540,  553,  566,  579,  591,  603,
	 615,  626,  637,  648,  659,  670,  680,  691,
	 701,  711,  721,  732,  743,  754,  765,  776,
	 786,  796,  806,  814,  821,  828,  833,  836,
	 838,  840,  843,  845,  847,  849,  851,  853,
	 855,  857,  859,  861,  863,  865,  866,  868,
	 870,  872,  874,  876,  878,  879,  881,  883,
	 885,  887,  888,  890,  892,  893,  895,  897,
	 899,  900,  902,  903,  905,  907,  908,  910,
	 911,  913,  914,  916,  917,  919,  920,  922,
	 923,  925,  926,  928,  929,  930,  932,  933,
	 934,  936,  937,  938,  940,  941,  942,  944,
	 945,  946,  947,  948,  950,  951,  952,  953,
	 954,  956,  957,  958,  959,  960,  961,  962,
	 963,  964,  965,  966,  967,  968,  969,  970,
	 971,  972,  973,  974,  975,  976,  977,  978,
	 979,  980,  981,  981,  982,  983,  984,  985,
	 986,  986,  987,  988,  989,  989,  990,  991,
	 992,  992,  993,  994,  994,  995,  996,  997,
	 997,  998,  998,  999, 1000, 1000, 1001, 1001,
	1002, 1003, 1003, 1004, 1004, 1005, 1005, 1006,
	1006, 1007, 1007, 1008, 1008, 1009, 1009, 1010,
	1010, 1011, 1011, 1011, 1012, 1012, 1013, 1013,
	1013, 1014, 1014, 1014, 1015, 1015, 1015, 1016,
	1016, 1016, 1017, 1017, 1017, 1017, 1018, 1018,
	1018, 1019, 1019, 1019, 1019, 1019, 1020, 1020,
	1020, 1020, 1020, 1021, 1021, 1021, 1021, 1021,
	1021, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*380*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  142,  194,  233,  265,  293,  319,  343,
	 365,  385,  403,  421,  438,  454,  469,  484,
	 499,  513,  527,  540,  553,  565,  577,  588,
	 600,  611,  622,  633,  643,  654,  664,  674,
	 684,  693,  704,  714,  725,  736,  746,  757,
	 767,  777,  786,  794,  801,  808,  813,  816,
	 818,  821,  823,  825,  828,  830,  832,  834,
	 836,  838,  841,  843,  845,  847,  849,  851,
	 853,  855,  857,  859,  861,  863,  865,  867,
	 869,  871,  873,  875,  877,  879,  880,  882,
	 884,  886,  888,  889,  891,  893,  895,  896,
	 898,  900,  901,  903,  905,  906,  908,  910,
	 911,  913,  914,  916,  917,  919,  921,  922,
	 923,  925,  926,  928,  929,  931,  932,  934,
	 935,  936,  938,  939,  940,  942,  943,  944,
	 946,  947,  948,  949,  951,  952,  953,  954,
	 955,  957,  958,  959,  960,  961,  962,  963,
	 964,  966,  967,  968,  969,  970,  971,  972,
	 973,  974,  975,  976,  977,  978,  978,  979,
	 980,  981,  982,  983,  984,  985,  986,  986,
	 987,  988,  989,  990,  990,  991,  992,  993,
	 993,  994,  995,  996,  996,  997,  998,  998,
	 999, 1000, 1000, 1001, 1001, 1002, 1003, 1003,
	1004, 1004, 1005, 1005, 1006, 1007, 1007, 1008,
	1008, 1009, 1009, 1010, 1010, 1010, 1011, 1011,
	1012, 1012, 1013, 1013, 1013, 1014, 1014, 1015,
	1015, 1015, 1016, 1016, 1016, 1017, 1017, 1017,
	1017, 1018, 1018, 1018, 1019, 1019, 1019, 1019,
	1020, 1020, 1020, 1020, 1020, 1021, 1021, 1021,
	1021, 1021, 1021, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*400*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  139,  189,  228,  259,  287,  312,  334,
	 356,  375,  394,  411,  427,  443,  458,  473,
	 487,  501,  514,  527,  540,  552,  564,  575,
	 586,  597,  608,  618,  629,  639,  649,  658,
	 668,  677,  687,  697,  708,  718,  729,  739,
	 749,  758,  767,  775,  782,  788,  793,  797,
	 800,  802,  804,  807,  809,  812,  814,  816,
	 819,  821,  823,  826,  828,  830,  832,  835,
	 837,  839,  841,  843,  845,  848,  850,  852,
	 854,  856,  858,  860,  862,  864,  866,  868,
	 870,  872,  874,  876,  878,  880,  882,  883,
	 885,  887,  889,  891,  892,  894,  896,  898,
	 899,  901,  903,  905,  906,  908,  910,  911,
	 913,  914,  916,  918,  919,  921,  922,  924,
	 925,  927,  928,  930,  931,  933,  934,  935,
	 937,  938,  940,  941,  942,  944,  945,  946,
	 948,  949,  950,  951,  953,  954,  955,  956,
	 958,  959,  960,  961,  962,  963,  964,  966,
	 967,  968,  969,  970,  971,  972,  973,  974,
	 975,  976,  977,  978,  979,  980,  981,  982,
	 983,  984,  984,  985,  986,  987,  988,  989,
	 990,  990,  991,  992,  993,  993,  994,  995,
	 996,  996,  997,  998,  999,  999, 1000, 1001,
	1001, 1002, 1002, 1003, 1004, 1004, 1005, 1005,
	1006, 1007, 1007, 1008, 1008, 1009, 1009, 1010,
	1010, 1011, 1011, 1012, 1012, 1012, 1013, 1013,
	1014, 1014, 1014, 1015, 1015, 1016, 1016, 1016,
	1017, 1017, 1017, 1018, 1018, 1018, 1018, 1019,
	1019, 1019, 1019, 1020, 1020, 1020, 1020, 1021,
	1021, 1021, 1021, 1021, 1021, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1022, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*420*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  135,  185,  222,  253,  280,  305,  327,
	 348,  368,  385,  402,  418,  434,  449,  463,
	 477,  490,  503,  516,  528,  539,  550,  562,
	 572,  583,  594,  604,  614,  624,  634,  644,
	 653,  662,  672,  682,  692,  702,  713,  723,
	 732,  741,  750,  758,  765,  771,  776,  780,
	 783,  785,  788,  790,  793,  795,  798,  800,
	 803,  805,  808,  810,  813,  815,  817,  820,
	 822,  824,  827,  829,  831,  834,  836,  838,
	 840,  842,  845,  847,  849,  851,  853,  855,
	 857,  859,  862,  864,  866,  868,  870,  872,
	 874,  876,  877,  879,  881,  883,  885,  887,
	 889,  891,  892,  894,  896,  898,  900,  901,
	 903,  905,  907,  908,  910,  912,  913,  915,
	 916,  918,  920,  921,  923,  924,  926,  927,
	 929,  930,  932,  933,  935,  936,  938,  939,
	 941,  942,  943,  945,  946,  947,  949,  950,
	 951,  953,  954,  955,  956,  958,  959,  960,
	 961,  962,  964,  965,  966,  967,  968,  969,
	 970,  971,  972,  973,  975,  976,  977,  978,
	 979,  980,  980,  981,  982,  983,  984,  985,
	 986,  987,  988,  989,  990,  990,  991,  992,
	 993,  994,  994,  995,  996,  997,  997,  998,
	 999, 1000, 1000, 1001, 1002, 1002, 1003, 1003,
	1004, 1005, 1005, 1006, 1006, 1007, 1008, 1008,
	1009, 1009, 1010, 1010, 1011, 1011, 1012, 1012,
	1013, 1013, 1013, 1014, 1014, 1015, 1015, 1015,
	1016, 1016, 1017, 1017, 1017, 1018, 1018, 1018,
	1018, 1019, 1019, 1019, 1020, 1020, 1020, 1020,
	1020, 1021, 1021, 1021, 1021, 1021, 1022, 1022,
	1022, 1022, 1022, 1022, 1022, 1022, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*440*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  133,  182,  219,  249,  275,  298,  320,
	 340,  360,  377,  394,  410,  425,  440,  454,
	 467,  480,  493,  505,  517,  528,  539,  550,
	 561,  572,  582,  592,  602,  612,  621,  631,
	 640,  649,  658,  667,  675,  684,  692,  700,
	 708,  716,  724,  731,  739,  747,  754,  761,
	 769,  776,  784,  793,  801,  809,  818,  826,
	 834,  842,  850,  858,  865,  872,  878,  884,
	 889,  894,  898,  901,  903,  905,  906,  908,
	 909,  911,  912,  913,  915,  916,  918,  919,
	 920,  922,  923,  924,  926,  927,  928,  930,
	 931,  932,  933,  935,  936,  937,  938,  939,
	 941,  942,  943,  944,  945,  946,  948,  949,
	 950,  951,  952,  953,  954,  955,  956,  957,
	 958,  959,  960,  961,  962,  963,  964,  965,
	 966,  967,  968,  969,  970,  971,  972,  973,
	 973,  974,  975,  976,  977,  978,  979,  979,
	 980,  981,  982,  983,  983,  984,  985,  986,
	 986,  987,  988,  988,  989,  990,  991,  991,
	 992,  993,  993,  994,  994,  995,  996,  996,
	 997,  998,  998,  999,  999, 1000, 1000, 1001,
	1001, 1002, 1003, 1003, 1004, 1004, 1005, 1005,
	1006, 1006, 1006, 1007, 1007, 1008, 1008, 1009,
	1009, 1010, 1010, 1010, 1011, 1011, 1011, 1012,
	1012, 1013, 1013, 1013, 1014, 1014, 1014, 1015,
	1015, 1015, 1016, 1016, 1016, 1016, 1017, 1017,
	1017, 1017, 1018, 1018, 1018, 1018, 1019, 1019,
	1019, 1019, 1019, 1020, 1020, 1020, 1020, 1020,
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1022,
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*460*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  130,  177,  214,  243,  269,  293,  314,
	 334,  353,  370,  386,  402,  416,  430,  444,
	 457,  470,  482,  494,  506,  517,  528,  539,
	 549,  560,  570,  580,  590,  599,  609,  618,
	 627,  636,  645,  653,  662,  670,  678,  686,
	 694,  702,  709,  717,  725,  732,  739,  746,
	 754,  761,  769,  777,  785,  793,  801,  809,
	 817,  825,  833,  840,  847,  854,  860,  866,
	 871,  875,  879,  883,  885,  887,  889,  890,
	 892,  893,  895,  897,  898,  900,  901,  903,
	 904,  906,  907,  909,  910,  912,  913,  915,
	 916,  918,  919,  921,  922,  923,  925,  926,
	 927,  929,  930,  931,  933,  934,  935,  937,
	 938,  939,  940,  941,  943,  944,  945,  946,
	 947,  949,  950,  951,  952,  953,  954,  955,
	 956,  958,  959,  960,  961,  962,  963,  964,
	 965,  966,  967,  968,  969,  970,  971,  972,
	 973,  973,  974,  975,  976,  977,  978,  979,
	 980,  980,  981,  982,  983,  984,  985,  985,
	 986,  987,  988,  988,  989,  990,  991,  991,
	 992,  993,  993,  994,  995,  995,  996,  997,
	 997,  998,  999,  999, 1000, 1000, 1001, 1002,
	1002, 1003, 1003, 1004, 1004, 1005, 1005, 1006,
	1006, 1007, 1007, 1008, 1008, 1009, 1009, 1010,
	1010, 1010, 1011, 1011, 1012, 1012, 1012, 1013,
	1013, 1014, 1014, 1014, 1015, 1015, 1015, 1016,
	1016, 1016, 1017, 1017, 1017, 1017, 1018, 1018,
	1018, 1018, 1019, 1019, 1019, 1019, 1020, 1020,
	1020, 1020, 1020, 1021, 1021, 1021, 1021, 1021,
	1021, 1021, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*480*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  128,  174,  210,  239,  264,  287,  308,
	 327,  345,  362,  378,  393,  408,  422,  435,
	 448,  461,  473,  485,  496,  507,  518,  529,
	 539,  549,  559,  569,  579,  588,  597,  606,
	 615,  624,  632,  641,  649,  657,  665,  673,
	 681,  689,  696,  704,  711,  718,  725,  733,
	 740,  747,  754,  762,  770,  778,  786,  794,
	 801,  809,  816,  823,  830,  837,  843,  849,
	 854,  858,  862,  865,  868,  870,  872,  874,
	 875,  877,  879,  881,  882,  884,  886,  888,
	 889,  891,  893,  894,  896,  897,  899,  901,
	 902,  904,  905,  907,  909,  910,  912,  913,
	 915,  916,  918,  919,  920,  922,  923,  925,
	 926,  928,  929,  930,  932,  933,  934,  936,
	 937,  938,  940,  941,  942,  943,  945,  946,
	 947,  948,  949,  951,  952,  953,  954,  955,
	 956,  958,  959,  960,  961,  962,  963,  964,
	 965,  966,  967,  968,  969,  970,  971,  972,
	 973,  974,  975,  976,  977,  978,  979,  980,
	 980,  981,  982,  983,  984,  985,  985,  986,
	 987,  988,  989,  989,  990,  991,  992,  992,
	 993,  994,  995,  995,  996,  997,  997,  998,
	 999,  999, 1000, 1001, 1001, 1002, 1002, 1003,
	1003, 1004, 1005, 1005, 1006, 1006, 1007, 1007,
	1008, 1008, 1009, 1009, 1010, 1010, 1011, 1011,
	1011, 1012, 1012, 1013, 1013, 1013, 1014, 1014,
	1015, 1015, 1015, 1016, 1016, 1016, 1017, 1017,
	1017, 1018, 1018, 1018, 1018, 1019, 1019, 1019,
	1019, 1020, 1020, 1020, 1020, 1020, 1021, 1021,
	1021, 1021, 1021, 1021, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*500*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  125,  171,  206,  235,  259,  281,  302,
	 321,  339,  356,  371,  386,  401,  414,  427,
	 440,  453,  465,  476,  488,  498,  509,  519,
	 529,  539,  549,  558,  568,  577,  586,  595,
	 603,  612,  620,  628,  637,  645,  652,  660,
	 668,  675,  683,  690,  697,  705,  712,  719,
	 726,  733,  740,  748,  755,  763,  771,  778,
	 786,  793,  801,  808,  814,  821,  827,  832,
	 837,  842,  846,  849,  852,  854,  856,  858,
	 860,  862,  864,  866,  867,  869,  871,  873,
	 875,  877,  879,  880,  882,  884,  886,  887,
	 889,  891,  893,  894,  896,  898,  899,  901,
	 902,  904,  906,  907,  909,  910,  912,  914,
	 915,  917,  918,  920,  921,  923,  924,  925,
	 927,  928,  930,  931,  933,  934,  935,  937,
	 938,  939,  941,  942,  943,  945,  946,  947,
	 948,  950,  951,  952,  953,  954,  956,  957,
	 958,  959,  960,  961,  962,  963,  965,  966,
	 967,  968,  969,  970,  971,  972,  973,  974,
	 975,  976,  977,  978,  979,  980,  981,  981,
	 982,  983,  984,  985,  986,  987,  987,  988,
	 989,  990,  991,  991,  992,  993,  994,  995,
	 995,  996,  997,  997,  998,  999,  999, 1000,
	1001, 1001, 1002, 1003, 1003, 1004, 1004, 1005,
	1006, 1006, 1007, 1007, 1008, 1008, 1009, 1009,
	1010, 1010, 1011, 1011, 1012, 1012, 1012, 1013,
	1013, 1014, 1014, 1015, 1015, 1015, 1016, 1016,
	1016, 1017, 1017, 1017, 1018, 1018, 1018, 1019,
	1019, 1019, 1019, 1020, 1020, 1020, 1020, 1020,
	1021, 1021, 1021, 1021, 1021, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1022, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*600*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  115,  157,  189,  215,  238,  259,  278,
	 296,  312,  327,  342,  356,  369,  381,  394,
	 405,  417,  428,  438,  449,  459,  468,  478,
	 487,  496,  505,  514,  523,  531,  540,  548,
	 556,  564,  571,  579,  586,  594,  601,  608,
	 615,  622,  629,  636,  642,  649,  655,  662,
	 668,  675,  681,  688,  695,  702,  709,  715,
	 722,  729,  735,  741,  747,  753,  759,  764,
	 769,  773,  777,  781,  784,  786,  789,  791,
	 794,  796,  799,  801,  803,  806,  808,  811,
	 813,  815,  818,  820,  822,  825,  827,  829,
	 831,  834,  836,  838,  840,  842,  845,  847,
	 849,  851,  853,  855,  857,  860,  862,  864,
	 866,  868,  870,  872,  874,  876,  878,  880,
	 882,  884,  886,  887,  889,  891,  893,  895,
	 897,  899,  900,  902,  904,  906,  908,  909,
	 911,  913,  915,  916,  918,  920,  921,  923,
	 925,  926,  928,  929,  931,  932,  934,  936,
	 937,  939,  940,  942,  943,  945,  946,  947,
	 949,  950,  952,  953,  954,  956,  957,  958,
	 960,  961,  962,  964,  965,  966,  967,  969,
	 970,  971,  972,  973,  974,  976,  977,  978,
	 979,  980,  981,  982,  983,  984,  985,  986,
	 987,  988,  989,  990,  991,  992,  993,  994,
	 995,  996,  996,  997,  998,  999, 1000, 1001,
	1001, 1002, 1003, 1004, 1004, 1005, 1006, 1006,
	1007, 1008, 1008, 1009, 1010, 1010, 1011, 1011,
	1012, 1012, 1013, 1014, 1014, 1015, 1015, 1015,
	1016, 1016, 1017, 1017, 1018, 1018, 1018, 1019,
	1019, 1019, 1020, 1020, 1020, 1020, 1021, 1021,
	1021, 1021, 1022, 1022, 1022, 1022, 1022, 1022,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*700*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  146,  201,  241,  276,  306,  332,  356,
	 378,  399,  419,  437,  454,  471,  487,  503,
	 518,  533,  547,  560,  573,  586,  599,  611,
	 623,  634,  646,  657,  668,  679,  689,  700,
	 710,  720,  730,  739,  749,  758,  767,  776,
	 785,  794,  803,  811,  820,  828,  837,  845,
	 853,  861,  870,  880,  889,  898,  905,  908,
	 909,  911,  912,  914,  915,  917,  918,  919,
	 921,  922,  923,  925,  926,  927,  929,  930,
	 931,  932,  934,  935,  936,  937,  939,  940,
	 941,  942,  943,  944,  946,  947,  948,  949,
	 950,  951,  952,  953,  954,  955,  956,  957,
	 958,  959,  960,  961,  962,  963,  964,  965,
	 966,  967,  968,  969,  970,  971,  972,  972,
	 973,  974,  975,  976,  977,  977,  978,  979,
	 980,  981,  981,  982,  983,  984,  984,  985,
	 986,  987,  987,  988,  989,  989,  990,  991,
	 991,  992,  993,  993,  994,  994,  995,  996,
	 996,  997,  997,  998,  998,  999,  999, 1000,
	1001, 1001, 1002, 1002, 1003, 1003, 1003, 1004,
	1004, 1005, 1005, 1006, 1006, 1007, 1007, 1007,
	1008, 1008, 1009, 1009, 1009, 1010, 1010, 1011,
	1011, 1011, 1012, 1012, 1012, 1013, 1013, 1013,
	1014, 1014, 1014, 1014, 1015, 1015, 1015, 1016,
	1016, 1016, 1016, 1017, 1017, 1017, 1017, 1017,
	1018, 1018, 1018, 1018, 1018, 1019, 1019, 1019,
	1019, 1019, 1020, 1020, 1020, 1020, 1020, 1020,
	1020, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
	1021, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1022, 1022, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*800*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  139,  189,  227,  259,  288,  312,  335,
	 356,  375,  393,  411,  427,  443,  458,  473,
	 487,  501,  514,  527,  539,  551,  563,  574,
	 586,  597,  607,  618,  628,  639,  649,  658,
	 668,  678,  687,  696,  705,  714,  722,  731,
	 739,  747,  756,  764,  772,  780,  787,  795,
	 803,  811,  819,  827,  836,  844,  850,  854,
	 856,  858,  860,  862,  864,  866,  868,  870,
	 872,  873,  875,  877,  879,  881,  883,  884,
	 886,  888,  890,  891,  893,  895,  896,  898,
	 900,  901,  903,  905,  906,  908,  909,  911,
	 912,  914,  916,  917,  919,  920,  922,  923,
	 924,  926,  927,  929,  930,  931,  933,  934,
	 936,  937,  938,  939,  941,  942,  943,  945,
	 946,  947,  948,  949,  951,  952,  953,  954,
	 955,  956,  958,  959,  960,  961,  962,  963,
	 964,  965,  966,  967,  968,  969,  970,  971,
	 972,  973,  974,  975,  976,  977,  978,  979,
	 980,  980,  981,  982,  983,  984,  985,  985,
	 986,  987,  988,  989,  989,  990,  991,  992,
	 992,  993,  994,  994,  995,  996,  996,  997,
	 998,  998,  999, 1000, 1000, 1001, 1001, 1002,
	1002, 1003, 1004, 1004, 1005, 1005, 1006, 1006,
	1007, 1007, 1008, 1008, 1009, 1009, 1010, 1010,
	1010, 1011, 1011, 1012, 1012, 1012, 1013, 1013,
	1014, 1014, 1014, 1015, 1015, 1015, 1016, 1016,
	1016, 1017, 1017, 1017, 1017, 1018, 1018, 1018,
	1018, 1019, 1019, 1019, 1019, 1020, 1020, 1020,
	1020, 1020, 1020, 1021, 1021, 1021, 1021, 1021,
	1021, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*900*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  131,  179,  216,  246,  273,  296,  317,
	 337,  355,  373,  389,  405,  420,  435,  449,
	 462,  475,  488,  500,  512,  523,  534,  545,
	 555,  566,  576,  586,  596,  605,  615,  624,
	 633,  642,  651,  660,  668,  676,  685,  693,
	 701,  709,  716,  724,  732,  739,  747,  754,
	 761,  769,  776,  783,  790,  797,  804,  810,
	 817,  824,  832,  839,  847,  855,  863,  870,
	 877,  884,  890,  895,  900,  904,  907,  908,
	 910,  911,  913,  914,  915,  917,  918,  920,
	 921,  922,  924,  925,  926,  928,  929,  930,
	 932,  933,  934,  935,  937,  938,  939,  940,
	 941,  943,  944,  945,  946,  947,  948,  949,
	 951,  952,  953,  954,  955,  956,  957,  958,
	 959,  960,  961,  962,  963,  964,  965,  966,
	 967,  968,  969,  970,  971,  972,  972,  973,
	 974,  975,  976,  977,  978,  978,  979,  980,
	 981,  982,  982,  983,  984,  985,  985,  986,
	 987,  988,  988,  989,  990,  990,  991,  992,
	 992,  993,  994,  994,  995,  996,  996,  997,
	 997,  998,  999,  999, 1000, 1000, 1001, 1001,
	1002, 1002, 1003, 1004, 1004, 1005, 1005, 1005,
	1006, 1006, 1007, 1007, 1008, 1008, 1009, 1009,
	1009, 1010, 1010, 1011, 1011, 1011, 1012, 1012,
	1013, 1013, 1013, 1014, 1014, 1014, 1015, 1015,
	1015, 1015, 1016, 1016, 1016, 1017, 1017, 1017,
	1017, 1018, 1018, 1018, 1018, 1019, 1019, 1019,
	1019, 1019, 1020, 1020, 1020, 1020, 1020, 1020,
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1022,
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	},
	{/*1000*/
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  124,  171,  206,  235,  260,  281,  302,
	 321,  339,  355,  371,  386,  400,  414,  428,
	 441,  453,  465,  476,  487,  498,  509,  519,
	 529,  539,  549,  558,  568,  577,  586,  594,
	 603,  612,  620,  628,  636,  644,  652,  660,
	 668,  675,  683,  690,  697,  705,  712,  719,
	 726,  733,  740,  746,  753,  759,  766,  772,
	 778,  785,  791,  797,  803,  809,  815,  821,
	 827,  833,  839,  845,  850,  856,  862,  867,
	 873,  880,  886,  893,  898,  903,  907,  909,
	 911,  912,  914,  915,  917,  918,  919,  921,
	 922,  924,  925,  926,  928,  929,  930,  932,
	 933,  934,  936,  937,  938,  939,  941,  942,
	 943,  944,  946,  947,  948,  949,  950,  951,
	 952,  954,  955,  956,  957,  958,  959,  960,
	 961,  962,  963,  964,  965,  966,  967,  968,
	 969,  970,  971,  972,  973,  974,  975,  976,
	 976,  977,  978,  979,  980,  981,  982,  982,
	 983,  984,  985,  986,  986,  987,  988,  989,
	 989,  990,  991,  991,  992,  993,  993,  994,
	 995,  995,  996,  997,  997,  998,  999,  999,
	1000, 1000, 1001, 1001, 1002, 1003, 1003, 1004,
	1004, 1005, 1005, 1006, 1006, 1007, 1007, 1008,
	1008, 1008, 1009, 1009, 1010, 1010, 1011, 1011,
	1011, 1012, 1012, 1013, 1013, 1013, 1014, 1014,
	1014, 1015, 1015, 1015, 1016, 1016, 1016, 1016,
	1017, 1017, 1017, 1018, 1018, 1018, 1018, 1019,
	1019, 1019, 1019, 1019, 1020, 1020, 1020, 1020,
	1020, 1020, 1021, 1021, 1021, 1021, 1021, 1021,
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
	}
};
/*Mbox: iptv/ott hdr curve select*/
/*600nit alpha_low = 0.12; */
static unsigned int eotf_33_2084_mapping_box[33] = {
	    0,     4,    10,    16,    24,    34,    48,    67,
	   93,   129,   177,   244,   334,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
};

static unsigned int oetf_289_gamma22_mapping_box[289] = {
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  115,  157,  189,  215,  238,  259,  278,
	 296,  312,  327,  342,  356,  369,  381,  394,
	 405,  417,  428,  438,  449,  459,  468,  478,
	 487,  496,  505,  514,  523,  531,  540,  548,
	 556,  564,  571,  579,  586,  594,  601,  608,
	 615,  622,  629,  636,  642,  649,  655,  662,
	 668,  675,  681,  688,  695,  702,  709,  715,
	 722,  729,  735,  741,  747,  753,  759,  764,
	 769,  773,  777,  781,  784,  786,  789,  791,
	 794,  796,  799,  801,  803,  806,  808,  811,
	 813,  815,  818,  820,  822,  825,  827,  829,
	 831,  834,  836,  838,  840,  842,  845,  847,
	 849,  851,  853,  855,  857,  860,  862,  864,
	 866,  868,  870,  872,  874,  876,  878,  880,
	 882,  884,  886,  887,  889,  891,  893,  895,
	 897,  899,  900,  902,  904,  906,  908,  909,
	 911,  913,  915,  916,  918,  920,  921,  923,
	 925,  926,  928,  929,  931,  932,  934,  936,
	 937,  939,  940,  942,  943,  945,  946,  947,
	 949,  950,  952,  953,  954,  956,  957,  958,
	 960,  961,  962,  964,  965,  966,  967,  969,
	 970,  971,  972,  973,  974,  976,  977,  978,
	 979,  980,  981,  982,  983,  984,  985,  986,
	 987,  988,  989,  990,  991,  992,  993,  994,
	 995,  996,  996,  997,  998,  999, 1000, 1001,
	1001, 1002, 1003, 1004, 1004, 1005, 1006, 1006,
	1007, 1008, 1008, 1009, 1010, 1010, 1011, 1011,
	1012, 1012, 1013, 1014, 1014, 1015, 1015, 1015,
	1016, 1016, 1017, 1017, 1018, 1018, 1018, 1019,
	1019, 1019, 1020, 1020, 1020, 1020, 1021, 1021,
	1021, 1021, 1022, 1022, 1022, 1022, 1022, 1022,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
};

/*350nit alpha_low = 0.12; */
static unsigned int eotf_33_2084_mapping_level1_box[33] = {
	    0,     4,    10,    16,    24,    34,    48,    67,
	   93,   129,   177,   244,   334,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
};

static unsigned int oetf_289_gamma22_mapping_level1_box[289] = {
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  148,  201,  242,  276,  305,  331,  355,
	 378,  399,  418,  437,  454,  471,  487,  503,
	 518,  532,  546,  560,  573,  586,  598,  610,
	 622,  634,  645,  656,  667,  678,  689,  699,
	 710,  720,  730,  741,  752,  764,  775,  786,
	 797,  807,  816,  825,  832,  839,  844,  847,
	 849,  851,  853,  855,  857,  859,  861,  863,
	 865,  867,  869,  871,  872,  874,  876,  878,
	 880,  881,  883,  885,  887,  888,  890,  892,
	 893,  895,  897,  898,  900,  902,  903,  905,
	 906,  908,  910,  911,  913,  914,  916,  917,
	 919,  920,  921,  923,  924,  926,  927,  928,
	 930,  931,  933,  934,  935,  937,  938,  939,
	 940,  942,  943,  944,  945,  947,  948,  949,
	 950,  951,  952,  954,  955,  956,  957,  958,
	 959,  960,  961,  962,  963,  964,  965,  966,
	 967,  968,  969,  970,  971,  972,  973,  974,
	 975,  976,  977,  978,  979,  980,  980,  981,
	 982,  983,  984,  985,  985,  986,  987,  988,
	 988,  989,  990,  991,  991,  992,  993,  993,
	 994,  995,  995,  996,  997,  997,  998,  999,
	 999, 1000, 1000, 1001, 1002, 1002, 1003, 1003,
	1004, 1004, 1005, 1005, 1006, 1006, 1007, 1007,
	1008, 1008, 1009, 1009, 1010, 1010, 1010, 1011,
	1011, 1012, 1012, 1012, 1013, 1013, 1013, 1014,
	1014, 1014, 1015, 1015, 1015, 1016, 1016, 1016,
	1017, 1017, 1017, 1017, 1018, 1018, 1018, 1018,
	1019, 1019, 1019, 1019, 1020, 1020, 1020, 1020,
	1020, 1020, 1021, 1021, 1021, 1021, 1021, 1021,
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
};

/*800nit alpha_low = 0.12; */
static unsigned int eotf_33_2084_mapping_level2_box[33] = {
	    0,     4,     8,    12,    18,    24,    33,    43,
	   58,    77,   103,   138,   184,   246,   329,   440,
	  605,   824,  1117,  1507,  2025,  2713,  3625,  4836,
	 6445,  8583, 11430, 15228, 15695, 16025, 16237, 16350,
	16383
};

static unsigned int oetf_289_gamma22_mapping_level2_box[289] = {
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  139,  189,  227,  259,  288,  312,  335,
	 356,  375,  393,  411,  427,  443,  458,  473,
	 487,  501,  514,  527,  539,  551,  563,  574,
	 586,  597,  607,  618,  628,  639,  649,  658,
	 668,  678,  687,  696,  705,  714,  722,  731,
	 739,  747,  756,  764,  772,  780,  787,  795,
	 803,  811,  819,  827,  836,  844,  850,  854,
	 856,  858,  860,  862,  864,  866,  868,  870,
	 872,  873,  875,  877,  879,  881,  883,  884,
	 886,  888,  890,  891,  893,  895,  896,  898,
	 900,  901,  903,  905,  906,  908,  909,  911,
	 912,  914,  916,  917,  919,  920,  922,  923,
	 924,  926,  927,  929,  930,  931,  933,  934,
	 936,  937,  938,  939,  941,  942,  943,  945,
	 946,  947,  948,  949,  951,  952,  953,  954,
	 955,  956,  958,  959,  960,  961,  962,  963,
	 964,  965,  966,  967,  968,  969,  970,  971,
	 972,  973,  974,  975,  976,  977,  978,  979,
	 980,  980,  981,  982,  983,  984,  985,  985,
	 986,  987,  988,  989,  989,  990,  991,  992,
	 992,  993,  994,  994,  995,  996,  996,  997,
	 998,  998,  999, 1000, 1000, 1001, 1001, 1002,
	1002, 1003, 1004, 1004, 1005, 1005, 1006, 1006,
	1007, 1007, 1008, 1008, 1009, 1009, 1010, 1010,
	1010, 1011, 1011, 1012, 1012, 1012, 1013, 1013,
	1014, 1014, 1014, 1015, 1015, 1015, 1016, 1016,
	1016, 1017, 1017, 1017, 1017, 1018, 1018, 1018,
	1018, 1019, 1019, 1019, 1019, 1020, 1020, 1020,
	1020, 1020, 1020, 1021, 1021, 1021, 1021, 1021,
	1021, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
};

/*400nit alpha_low = 0.20; */
static unsigned int eotf_33_2084_mapping_level3_box[33] = {
	    0,     7,    15,    24,    34,    47,    63,    83,
	  110,   146,   193,   257,   342,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
};

static unsigned int oetf_289_gamma22_mapping_level3_box[289] = {
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  139,  189,  228,  259,  287,  312,  334,
	 356,  375,  394,  411,  427,  443,  458,  473,
	 487,  501,  514,  527,  540,  552,  564,  575,
	 586,  597,  608,  618,  629,  639,  649,  658,
	 668,  677,  687,  697,  708,  718,  729,  739,
	 749,  758,  767,  775,  782,  788,  793,  797,
	 800,  802,  804,  807,  809,  812,  814,  816,
	 819,  821,  823,  826,  828,  830,  832,  835,
	 837,  839,  841,  843,  845,  848,  850,  852,
	 854,  856,  858,  860,  862,  864,  866,  868,
	 870,  872,  874,  876,  878,  880,  882,  883,
	 885,  887,  889,  891,  892,  894,  896,  898,
	 899,  901,  903,  905,  906,  908,  910,  911,
	 913,  914,  916,  918,  919,  921,  922,  924,
	 925,  927,  928,  930,  931,  933,  934,  935,
	 937,  938,  940,  941,  942,  944,  945,  946,
	 948,  949,  950,  951,  953,  954,  955,  956,
	 958,  959,  960,  961,  962,  963,  964,  966,
	 967,  968,  969,  970,  971,  972,  973,  974,
	 975,  976,  977,  978,  979,  980,  981,  982,
	 983,  984,  984,  985,  986,  987,  988,  989,
	 990,  990,  991,  992,  993,  993,  994,  995,
	 996,  996,  997,  998,  999,  999, 1000, 1001,
	1001, 1002, 1002, 1003, 1004, 1004, 1005, 1005,
	1006, 1007, 1007, 1008, 1008, 1009, 1009, 1010,
	1010, 1011, 1011, 1012, 1012, 1012, 1013, 1013,
	1014, 1014, 1014, 1015, 1015, 1016, 1016, 1016,
	1017, 1017, 1017, 1018, 1018, 1018, 1018, 1019,
	1019, 1019, 1019, 1020, 1020, 1020, 1020, 1021,
	1021, 1021, 1021, 1021, 1021, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1022, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
};

/*450nit  alpha_low = 0.12;*/
static unsigned int eotf_33_2084_mapping_level4_box[33] = {
	    0,     4,    10,    16,    24,    34,    48,    67,
	   93,   129,   177,   244,   334,   455,   636,   881,
	 1209,  1648,  2234,  3014,  4050,  5425,  7251,  9673,
	12889, 13773, 14513, 15117, 15594, 15951, 16196, 16338,
	16383
};

static unsigned int oetf_289_gamma22_mapping_level4_box[289] = {
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,
	   0,  131,  179,  216,  245,  272,  295,  317,
	 337,  356,  374,  390,  406,  421,  435,  449,
	 462,  475,  488,  500,  512,  523,  534,  545,
	 556,  566,  576,  586,  596,  605,  615,  624,
	 633,  642,  651,  660,  668,  676,  685,  693,
	 701,  709,  717,  725,  732,  740,  747,  754,
	 762,  769,  777,  785,  793,  802,  810,  818,
	 826,  834,  842,  849,  856,  863,  869,  875,
	 880,  885,  889,  892,  894,  896,  897,  899,
	 900,  902,  904,  905,  907,  908,  909,  911,
	 912,  914,  915,  917,  918,  919,  921,  922,
	 924,  925,  926,  928,  929,  930,  931,  933,
	 934,  935,  937,  938,  939,  940,  941,  943,
	 944,  945,  946,  947,  948,  950,  951,  952,
	 953,  954,  955,  956,  957,  958,  959,  960,
	 961,  962,  963,  964,  965,  966,  967,  968,
	 969,  970,  971,  972,  973,  974,  975,  976,
	 976,  977,  978,  979,  980,  981,  981,  982,
	 983,  984,  985,  985,  986,  987,  988,  988,
	 989,  990,  990,  991,  992,  993,  993,  994,
	 994,  995,  996,  996,  997,  998,  998,  999,
	 999, 1000, 1001, 1001, 1002, 1002, 1003, 1003,
	1004, 1004, 1005, 1005, 1006, 1006, 1007, 1007,
	1008, 1008, 1009, 1009, 1009, 1010, 1010, 1011,
	1011, 1012, 1012, 1012, 1013, 1013, 1013, 1014,
	1014, 1014, 1015, 1015, 1015, 1016, 1016, 1016,
	1017, 1017, 1017, 1017, 1018, 1018, 1018, 1018,
	1019, 1019, 1019, 1019, 1019, 1020, 1020, 1020,
	1020, 1020, 1021, 1021, 1021, 1021, 1021, 1021,
	1021, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
	1022, 1022, 1022, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
	1023
};

#endif

