/*
 * drivers/amlogic/drm/meson_async_atomic.h
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#ifndef __MESON_ASYNC_ATOMIC_H
#define __MESON_ASYNC_ATOMIC_H

#include <drm/drm_atomic.h>

struct drm_property *drm_mode_obj_find_prop_id(struct drm_mode_object *obj,
					       u32 prop_id);
bool drm_property_change_valid_get(struct drm_property *property,
				   u64 value, struct drm_mode_object **ref);
void drm_property_change_valid_put(struct drm_property *property,
		struct drm_mode_object *ref);

int meson_asyc_atomic_ioctl(struct drm_device *dev,
			  void *data, struct drm_file *file_priv);

int meson_async_atomic_commit(struct drm_atomic_state *state);

#endif
