/*
 * drivers/amlogic/media/enhancement/amvecm/set_hdr2_v0.c
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#include <linux/types.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/amlogic/media/vfm/vframe.h>
#include <linux/amlogic/media/amvecm/amvecm.h>
#include <linux/amlogic/media/amdolbyvision/dolby_vision.h>
#include "set_hdr2_v0.h"
#include "arch/vpp_hdr_regs.h"
#include "arch/vpp_regs.h"
#include "arch/vpp_dolbyvision_regs.h"
#include "reg_helper.h"
#include "hdr/gamut_convert.h"

// sdr to hdr table  12bit
int cgain_lut0[65] = {
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x4c0, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x40e,
	0x429, 0x444, 0x45f, 0x479, 0x492, 0x4ab, 0x4c3, 0x4db, 0x4f2,
	0x509, 0x520, 0x536, 0x54c, 0x561, 0x576, 0x58b, 0x59f, 0x5b3,
	0x5c0, 0x5d0, 0x5f2, 0x609, 0x620, 0x636, 0x64c, 0x661, 0x676,
	0x68b, 0x69f
};

// hdr10 to gamma lut 12bit (hdr to sdr)
static int num_cgain_lut = 65;
/*int cgain_lut1[65] = {
 *	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
 *	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
 *	0x4c0, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
 *	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x40e,
 *	0x429, 0x444, 0x45f, 0x479, 0x492, 0x4ab, 0x4c3, 0x4db, 0x4f2,
 *	0x509, 0x520, 0x536, 0x54c, 0x561, 0x576, 0x58b, 0x59f, 0x5b3,
 *	0x5c0, 0x5d0, 0x5f2, 0x609, 0x620, 0x636, 0x64c, 0x661, 0x676,
 *	0x68b, 0x69f
};
*/
int cgain_lut1[65] = {
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x40e,
	0x419, 0x424, 0x43f, 0x449, 0x452, 0x46b, 0x473, 0x48b, 0x492,
	0x4a9, 0x4b0, 0x4c6, 0x4dc, 0x4e1, 0x4f6, 0x50b, 0x51f, 0x523,
	0x530, 0x540
};
module_param_array(cgain_lut1, int, &num_cgain_lut, 0664);
MODULE_PARM_DESC(cgain_lut1, "\n knee_setting, 256=1.0\n");

int cgain_lut_bypass[65] = {
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400
};

// sdr to hdr 10bit (gamma to peak)
int cgain_lut2[65] = {
	0xc00, 0xc00, 0xc00, 0xc00, 0xc00, 0xc00, 0xc00, 0xc00, 0xc00,
	0xc00, 0xc00, 0xc0e, 0xc79, 0xcdb, 0xd36, 0xd8b, 0xdda, 0xe25,
	0xe6b, 0xead, 0xeec, 0xf28, 0xf61, 0xf98, 0xfcc, 0xfff, 0x102f,
	0x105d, 0x108a, 0x10b5, 0x10df, 0x1107, 0x112e, 0x1154, 0x1178, 0x119c,
	0x11bf, 0x11e0, 0x1201, 0x1221, 0x1240, 0x125e, 0x127c, 0x1299, 0x12b5,
	0x12d1, 0x12ec, 0x1306, 0x1320, 0x1339, 0x1352, 0x136b, 0x1383, 0x139a,
	0x13b1, 0x13c7, 0x13de, 0x13f3, 0x1409, 0x141e, 0x1432, 0x1447, 0x145b,
	0x146e, 0x1482
};

int eo_y_lut_hdr_def[143] = {
	1032192, 1032192, 1032192, 1032192, 16384, 16384, 16384, 16384,
	32768, 32768, 32768, 32768, 40960, 40960, 40960, 49152, 49152,
	73728, 86016, 94208, 100352, 104448, 108544, 112640, 117760, 123904,
	128000, 133632, 137728, 141824, 146944, 150272, 153344, 157440,
	161536, 165248, 167808, 170880, 174208, 177792, 181056, 183360,
	185792, 188480, 191552, 194880, 197536, 199520, 201696, 204128,
	206688, 209568, 212640, 214480, 216336, 218320, 220464, 222832,
	225360, 228112, 230248, 231864, 233608, 235496, 237544, 239752,
	242136, 244712, 246628, 248132, 249748, 251492, 253364, 255388,
	257564, 259908, 262290, 263646, 265106, 266678, 268366, 270182,
	272134, 274230, 276486, 278717, 280017, 281415, 282915, 284525,
	286255, 288113, 290107, 292247, 294545, 295961, 297284, 298705,
	300229, 301866, 303622, 305507, 307530, 309701, 311664, 312915,
	314257, 315698, 317246, 318907, 320690, 322605, 324662, 326871,
	328461, 329735, 331104, 332575, 334155, 335853, 337679, 339642,
	341752, 344021, 345263, 346576, 347989, 349509, 351145, 352907,
	354805, 356848, 359050, 360935, 362214, 363593, 365080, 366684,
	368414, 370283, 372300, 374478, 376832
};

static int num_eo_y_lut_hdr = 143;
int eo_y_lut_hdr[143] = {
	1032192, 1032192, 1032192, 1032192, 16384, 16384, 16384, 16384,
	32768, 32768, 32768, 32768, 40960, 40960, 40960, 49152, 49152,
	73728, 86016, 94208, 100352, 104448, 108544, 112640, 117760, 123904,
	128000, 133632, 137728, 141824, 146944, 150272, 153344, 157440,
	161536, 165248, 167808, 170880, 174208, 177792, 181056, 183360,
	185792, 188480, 191552, 194880, 197536, 199520, 201696, 204128,
	206688, 209568, 212640, 214480, 216336, 218320, 220464, 222832,
	225360, 228112, 230248, 231864, 233608, 235496, 237544, 239752,
	242136, 244712, 246628, 248132, 249748, 251492, 253364, 255388,
	257564, 259908, 262290, 263646, 265106, 266678, 268366, 270182,
	272134, 274230, 276486, 278717, 280017, 281415, 282915, 284525,
	286255, 288113, 290107, 292247, 294545, 295961, 297284, 298705,
	300229, 301866, 303622, 305507, 307530, 309701, 311664, 312915,
	314257, 315698, 317246, 318907, 320690, 322605, 324662, 326871,
	328461, 329735, 331104, 332575, 334155, 335853, 337679, 339642,
	341752, 344021, 345263, 346576, 347989, 349509, 351145, 352907,
	354805, 356848, 359050, 360935, 362214, 363593, 365080, 366684,
	368414, 370283, 372300, 374478, 376832
};
module_param_array(eo_y_lut_hdr, int, &num_eo_y_lut_hdr, 0664);
MODULE_PARM_DESC(eo_y_lut_hdr, "\n eo_y_lut_hdr\n");

int eo_y_lut_pq_def[143] = {
	59392, 66560, 94208, 110592, 121984, 132160, 138816, 146432,
	151264, 156096, 161440, 165568, 168768, 172224, 175952, 179968,
	182240, 200680, 215102, 226400, 235271, 244625, 250984, 258029,
	264312, 269323, 275208, 280295, 284260, 288817, 294028, 297434,
	300794, 304586, 308851, 312465, 315139, 318120, 321437, 325119,
	328439, 330693, 333181, 335922, 338938, 342251, 344974, 346965,
	349143, 351524, 354124, 356960, 360050, 361931, 363762, 365751,
	367912, 370258, 372802, 375559, 377689, 379306, 381056, 382948,
	384994, 387204, 389591, 392167, 394081, 395581, 397197, 398940,
	400818, 402840, 405018, 407363, 409743, 411100, 412561, 414132,
	415820, 417636, 419588, 421685, 423939, 426172, 427472, 428869,
	430370, 431980, 433710, 435567, 437561, 439701, 441999, 443416,
	444740, 446160, 447685, 449321, 451078, 452962, 454986, 457157,
	459120, 460370, 461713, 463154, 464701, 466363, 468146, 470061,
	472118, 474326, 475917, 477191, 478560, 480031, 481611, 483309,
	485135, 487098, 489208, 491477, 492719, 494032, 495444, 496965,
	498601, 500363, 502261, 504304, 506506, 508391, 509670, 511049,
	512536, 514140, 515870, 517739, 519756, 521934, 524287
};

int eo_y_lut_pq[143] = {
	59392, 66560, 94208, 110592, 121984, 132160, 138816, 146432,
	151264, 156096, 161440, 165568, 168768, 172224, 175952, 179968,
	182240, 200680, 215102, 226400, 235271, 244625, 250984, 258029,
	264312, 269323, 275208, 280295, 284260, 288817, 294028, 297434,
	300794, 304586, 308851, 312465, 315139, 318120, 321437, 325119,
	328439, 330693, 333181, 335922, 338938, 342251, 344974, 346965,
	349143, 351524, 354124, 356960, 360050, 361931, 363762, 365751,
	367912, 370258, 372802, 375559, 377689, 379306, 381056, 382948,
	384994, 387204, 389591, 392167, 394081, 395581, 397197, 398940,
	400818, 402840, 405018, 407363, 409743, 411100, 412561, 414132,
	415820, 417636, 419588, 421685, 423939, 426172, 427472, 428869,
	430370, 431980, 433710, 435567, 437561, 439701, 441999, 443416,
	444740, 446160, 447685, 449321, 451078, 452962, 454986, 457157,
	459120, 460370, 461713, 463154, 464701, 466363, 468146, 470061,
	472118, 474326, 475917, 477191, 478560, 480031, 481611, 483309,
	485135, 487098, 489208, 491477, 492719, 494032, 495444, 496965,
	498601, 500363, 502261, 504304, 506506, 508391, 509670, 511049,
	512536, 514140, 515870, 517739, 519756, 521934, 524287
};

int eo_y_lut_hlg_23[143] = {
	1032192, 1032192, 1032192, 1032192, 16384, 16384, 16384, 16384,
	32768, 32768, 32768, 32768, 40960, 40960, 40960, 49152,
	49152, 73728, 185920, 197344, 204832, 213360, 218480, 224272,
	230072, 233656, 237576, 241848, 246108, 248580, 251228, 254044,
	257028, 260188, 262830, 264578, 266414, 268334, 270338, 272430,
	274606, 276866, 278871, 280087, 281345, 282647, 283991, 285377,
	286807, 288279, 289793, 291351, 292951, 294593, 295595, 296459,
	297344, 298251, 299179, 300128, 301099, 302091, 303104, 304139,
	305195, 306272, 307371, 308491, 309632, 310795, 311637, 312240,
	312853, 313477, 314112, 314757, 315413, 316080, 316757, 317455,
	318184, 318945, 319741, 320572, 321440, 322347, 323294, 324284,
	325318, 326398, 327526, 328192, 328808, 329451, 330123, 330825,
	331558, 332324, 333124, 333960, 334833, 335746, 336698, 337694,
	338734, 339820, 340955, 342141, 343379, 344368, 345044, 345750,
	346488, 347258, 348063, 348904, 349782, 350700, 351658, 352659,
	353705, 354798, 355940, 357132, 358378, 359679, 360743, 361453,
	362195, 362970, 363780, 364625, 365509, 366432, 367396, 368403,
	369455, 370554, 371703, 372902, 374155, 375464, 376832
};

int eo_y_lut_hlg[143] = {
	0, 169296, 202068, 221184, 234837, 246442, 253952, 262485, 267605,
	273408, 279210, 282794, 286720, 290986, 295253, 297728, 300373, 319488,
	333141, 344746, 352256, 360789, 365909, 371712, 377514, 381098, 385024,
	389290, 393557, 396032, 398677, 401493, 404480, 407637, 410282, 412032,
	413866, 415786, 417792, 419882, 422058, 424320, 426325, 427541, 428800,
	430101, 431445, 432832, 434261, 435733, 437248, 438805, 440405, 442048,
	443050, 443914, 444800, 445706, 446634, 447584, 448554, 449546, 450560,
	451594, 452650, 453728, 454826, 455946, 457088, 458250, 459093, 459696,
	460309, 460933, 461568, 462213, 462869, 463536, 464213, 464911, 465640,
	466401, 467197, 468028, 468896, 469803, 470750, 471740, 472774, 473854,
	474982, 475648, 476264, 476907, 477579, 478281, 479014, 479780, 480580,
	481416, 482289, 483201, 484154, 485150, 486190, 487276, 488411, 489597,
	490835, 491824, 492500, 493206, 493944, 494714, 495519, 496360, 497238,
	498156, 499114, 500115, 501161, 502254, 503396, 504588, 505834, 507135,
	508199, 508909, 509651, 510426, 511236, 512081, 512965, 513888, 514852,
	515859, 516911, 518010, 519158, 520358, 521611, 522920, 524287
};

int eo_y_lut_sdr[143] = {
	0, 163808, 199044, 219568, 234610, 247036, 255751, 264272, 270593,
	277939, 282430, 287163, 292441, 296593, 299792, 303278, 307054, 328697,
	344063, 354448, 364052, 372123, 379268, 384835, 391196, 395793, 399793,
	404214, 409063, 411973, 414834, 417919, 421229, 424767, 427260, 429261,
	431380, 433618, 435975, 438453, 441054, 443072, 444496, 445981, 447530,
	449142, 450817, 452556, 454360, 456229, 458163, 459457, 460489, 461555,
	462654, 463787, 464953, 466153, 467387, 468655, 469957, 471294, 472665,
	474071, 475324, 476062, 476817, 477590, 478381, 479190, 480016, 480861,
	481723, 482603, 483502, 484418, 485353, 486306, 487278, 488267, 489276,
	490302, 491348, 491966, 492507, 493057, 493618, 494187, 494766, 495354,
	495952, 496559, 497176, 497803, 498439, 499084, 499740, 500405, 501079,
	501764, 502458, 503161, 503875, 504598, 505332, 506075, 506828, 507590,
	508133, 508525, 508921, 509322, 509728, 510140, 510556, 510977, 511404,
	511835, 512272, 512713, 513160, 513611, 514068, 514530, 514997, 515469,
	515946, 516429, 516916, 517409, 517907, 518410, 518918, 519432, 519950,
	520474, 521003, 521537, 522077, 522622, 523172, 523727, 524287
};

int eo_y_lut_bypass[143] = {
	0, 360448, 376832, 385024, 393216, 397312, 401408, 405504, 409600,
	411648, 413696, 415744, 417792, 419840, 421888, 423936, 425984, 434176,
	442368, 446464, 450560, 454656, 458752, 460800, 462848, 464896, 466944,
	468992, 471040, 473088, 475136, 476160, 477184, 478208, 479232, 480256,
	481280, 482304, 483328, 484352, 485376, 486400, 487424, 488448, 489472,
	490496, 491520, 492032, 492544, 493056, 493568, 494080, 494592, 495104,
	495616, 496128, 496640, 497152, 497664, 498176, 498688, 499200, 499712,
	500224, 500736, 501248, 501760, 502272, 502784, 503296, 503808, 504320,
	504832, 505344, 505856, 506368, 506880, 507392, 507904, 508160, 508416,
	508672, 508928, 509184, 509440, 509696, 509952, 510208, 510464, 510720,
	510976, 511232, 511488, 511744, 512000, 512256, 512512, 512768, 513024,
	513280, 513536, 513792, 514048, 514304, 514560, 514816, 515072, 515328,
	515584, 515840, 516096, 516352, 516608, 516864, 517120, 517376, 517632,
	517888, 518144, 518400, 518656, 518912, 519168, 519424, 519680, 519936,
	520192, 520448, 520704, 520960, 521216, 521472, 521728, 521984, 522240,
	522496, 522752, 523008, 523264, 523520, 523776, 524032, 524287
};

int oe_y_lut_hdr[149] = {0, 3, 5, 8, 12, 19, 28, 41, 60, 67, 74, 80, 85,
	96, 105, 113, 120, 134, 146, 157, 167, 184, 200, 214, 227, 250, 270,
	288, 304, 332, 357, 380, 400, 435, 465, 492, 517, 559, 595, 628, 656,
	706, 749, 787, 820, 850, 878, 903, 927, 949, 970, 989, 1008, 1042, 1073,
	1102, 1129, 1154, 1177, 1199, 1219, 1258, 1292, 1324, 1354, 1381, 1407,
	1431, 1453, 1495, 1533, 1568, 1600, 1630, 1657, 1683, 1708, 1753, 1794,
	1831, 1865, 1897, 1926, 1954, 1980, 2028, 2071, 2110, 2146, 2179, 2210,
	2239, 2267, 2317, 2361, 2402, 2440, 2474, 2506, 2536, 2564, 2616, 2662,
	2704, 2742, 2778, 2810, 2841, 2870, 2922, 2969, 3011, 3050, 3086, 3119,
	3150, 3179, 3231, 3278, 3321, 3360, 3396, 3429, 3459, 3488, 3540, 3587,
	3629, 3668, 3703, 3736, 3766, 3795, 3821, 3846, 3870, 3892, 3913, 3934,
	3953, 3971, 3989, 4006, 4022, 4038, 4053, 4068, 4082, 4095
};

int oe_y_lut_hlg[149] = {0, 0, 0, 0, 1, 1, 2, 3, 4, 5, 6, 6, 6, 7, 8, 9,
	9, 10, 12, 12, 13, 15, 16, 18, 19, 21, 24, 25, 27, 30, 33, 36, 39,
	43, 48, 51, 55, 61, 67, 73, 78, 87, 96, 103, 110, 117, 123, 129, 135,
	141, 146, 151, 156, 166, 175, 183, 192, 199, 207, 214, 221, 235, 247,
	259, 271, 282, 293, 303, 313, 332, 350, 367, 384, 399, 414, 429, 443,
	470, 495, 519, 543, 565, 586, 607, 627, 665, 701, 735, 768, 799, 829,
	858, 886, 940, 991, 1039, 1086, 1130, 1173, 1214, 1254, 1330, 1402,
	1470, 1536, 1598, 1659, 1717, 1773, 1881, 1982, 2079, 2165, 2243,
	2313, 2377, 2436, 2541, 2633, 2714, 2788, 2855, 2916, 2972, 3025,
	3119, 3203, 3279, 3347, 3409, 3467, 3520, 3570, 3616, 3660, 3701,
	3740, 3778, 3813, 3847, 3879, 3910, 3939, 3968, 3995, 4022, 4047,
	4072, 4095
};

static int num_oe_y_lut_sdr = 149;
int oe_y_lut_sdr[149] = {
	0, 0, 0, 1, 1, 2, 2, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 11, 12, 13,
	14, 15, 16, 18, 19, 21, 23, 24, 26, 29, 31, 34, 36, 40, 43, 46,
	49, 55, 59, 64, 68, 75, 81, 87, 93, 98, 103, 107, 112, 116, 120,
	124, 128, 135, 141, 147, 153, 159, 165, 170, 175, 185, 194, 202,
	210, 218, 226, 233, 240, 253, 266, 277, 289, 299, 309, 319, 329,
	347, 364, 380, 396, 410, 424, 438, 451, 476, 499, 521, 542, 562,
	582, 600, 618, 652, 684, 714, 743, 771, 797, 823, 847, 894, 938,
	979, 1019, 1056, 1093, 1127, 1161, 1225, 1285, 1342, 1396, 1448,
	1497, 1545, 1591, 1679, 1761, 1839, 1913, 1984, 2052, 2118, 2181,
	2301, 2414, 2520, 2622, 2719, 2812, 2902, 2989, 3072, 3153, 3231,
	3308, 3382, 3454, 3525, 3593, 3661, 3727, 3791, 3854, 3916, 3977,
	4037, 4095
};
module_param_array(oe_y_lut_sdr, int, &num_oe_y_lut_sdr, 0664);
MODULE_PARM_DESC(oe_y_lut_sdr, "\n eo_y_lut_hdr\n");

static int oe_y_lut_bypass[149] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5,
	5, 6, 6, 7, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 20, 22, 24,
	26, 28, 30, 32, 36, 40, 44, 48, 52, 56, 60, 64, 72, 80, 88, 96,
	104, 112, 120, 128, 144, 160, 176, 192, 208, 224, 240, 256, 288,
	320, 352, 384, 416, 448, 480, 512, 576, 640, 704, 768, 832, 896,
	960, 1024, 1152, 1280, 1408, 1536, 1664, 1792, 1920, 2048, 2176,
	2304, 2432, 2560, 2688, 2816, 2944, 3072, 3200, 3328, 3456, 3584,
	3712, 3840, 3968, 4095
};

int oo_y_lut_hdr_hlg[149] = {
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
	4095, 4095, 4095, 4095, 4095, 4095, 3983, 3703, 3469, 3270,
	3098, 2948, 2816, 2698, 2592, 2409, 2257, 2127, 2016, 1918,
	1832, 1755, 1686, 1567, 1468, 1384, 1311, 1248, 1192, 1142,
	1097, 1020, 955, 900, 853, 812, 775, 743, 714, 663,
	621, 586, 555, 528, 504, 483, 464, 431, 404, 381,
	361, 343, 328, 314, 302, 281, 263, 248, 235, 223,
	213, 204, 196, 189, 182, 176, 171, 166, 161, 157,
	152, 149, 145, 142, 139, 136, 133, 130, 128
};

int oo_y_lut_hdr_sdr_def[149] = {
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1532,
	1440, 1287, 1165, 1065, 982, 911, 850, 798, 752, 675,
	613, 563, 520, 484, 454, 427, 403, 364, 332, 306,
	283, 265, 248, 234, 221, 199, 182, 167, 154, 144,
	134, 126, 119, 113, 107, 102, 97, 93, 89, 86,
	82, 79, 77, 74, 72, 69, 67, 65, 64
};

static int num_hdr_sdr_lut = 149;
int oo_y_lut_hdr_sdr[149] = {
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
	1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1532,
	1440, 1287, 1165, 1065, 982, 911, 850, 798, 752, 675,
	613, 563, 520, 484, 454, 427, 403, 364, 332, 306,
	283, 265, 248, 234, 221, 199, 182, 167, 154, 144,
	134, 126, 119, 113, 107, 102, 97, 93, 89, 86,
	82, 79, 77, 74, 72, 69, 67, 65, 64
};
module_param_array(oo_y_lut_hdr_sdr, int, &num_hdr_sdr_lut, 0664);
MODULE_PARM_DESC(oo_y_lut_hdr_sdr, "\n num_hdr_sdr_lut\n");

int oo_y_lut_bypass[149] = {
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
	512, 512, 512, 512, 512, 512
};

/* HDR map to 4000 gain=512*4000/10000, 512 as 1.0 */
int oo_y_lut_hdr_hdr_4000[149] = {
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 205, 205, 205, 205, 205
};

/* HDR map to 2500 gain=512*2500/10000, 512 as 1.0 */
int oo_y_lut_hdr_hdr_2500[149] = {
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128
};

/* HDR map to 1200 gain=512*1200/10000, 512 as 1.0 */
int oo_y_lut_hdr_hdr_1200[149] = {
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61
};

int oo_y_lut_hlg_hdr[149] = {
	6, 10, 12, 13, 16, 18, 21, 24, 27, 29,
	30, 31, 32, 33, 34, 35, 36, 38, 39, 41,
	42, 44, 45, 47, 48, 50, 52, 54, 55, 58,
	60, 62, 64, 66, 69, 71, 73, 76, 79, 82,
	84, 88, 91, 94, 97, 99, 101, 103, 105, 106,
	108, 110, 111, 114, 116, 118, 120, 122, 124, 126,
	128, 131, 133, 136, 138, 141, 143, 145, 147, 150,
	153, 156, 159, 162, 164, 166, 168, 172, 176, 180,
	183, 186, 188, 191, 194, 198, 202, 206, 210, 213,
	216, 220, 222, 228, 233, 237, 241, 245, 249, 252,
	256, 262, 267, 272, 277, 282, 286, 290, 294, 301,
	307, 313, 318, 324, 328, 333, 337, 345, 353, 360,
	366, 372, 377, 383, 388, 397, 405, 413, 420, 427,
	433, 440, 445, 451, 456, 461, 466, 470, 475, 479,
	483, 487, 491, 494, 498, 502, 505, 508, 512
};

/* SDR convert to 310 gain=512*310/10000 lumin HDR, 512 as 1.0 */
static int num_sdr_hdr_lut = 149;
int oo_y_lut_sdr_hdr[149] = {
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16
};
module_param_array(oo_y_lut_sdr_hdr, int, &num_sdr_hdr_lut, 0664);
MODULE_PARM_DESC(oo_y_lut_sdr_hdr, "\n num_sdr_hdr_lut\n");


/* SDR convert to 100 gain=512*100/10000 lumin HDR, 512 as 1.0 */
int oo_y_lut_sdr_hdr_100[149] = {
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5
};

/* SDR convert to 250 gain=512*250/12000 lumin HDR, 512 as 1.0 */
int oo_y_lut_sdr_hdr_250[149] = {
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12
};

/* SDR convert to 310 gain=512*310/10000 lumin HDR, 512 as 1.0 */
int oo_y_lut_sdr_hdr_300[149] = {
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16
};

int oo_y_lut_hlg_sdr[149] = {
	790, 749, 739, 729, 719, 709, 699, 690, 681, 678,
	675, 673, 671, 669, 666, 664, 662, 659, 657, 655,
	653, 651, 648, 646, 645, 642, 639, 638, 636, 633,
	631, 629, 627, 625, 622, 620, 619, 616, 614, 612,
	610, 608, 606, 604, 602, 601, 600, 598, 597, 596,
	596, 595, 594, 593, 591, 590, 589, 588, 588, 587,
	586, 585, 583, 582, 581, 580, 580, 579, 578, 577,
	576, 575, 574, 573, 572, 571, 570, 569, 568, 567,
	566, 565, 564, 563, 563, 561, 560, 559, 558, 557,
	556, 556, 555, 554, 553, 552, 551, 550, 549, 548,
	548, 546, 545, 544, 543, 542, 542, 541, 540, 539,
	538, 537, 536, 535, 534, 533, 533, 532, 530, 529,
	529, 528, 527, 526, 526, 524, 523, 522, 521, 521,
	520, 519, 519, 518, 517, 517, 516, 516, 515, 515,
	514, 514, 514, 513, 513, 512, 512, 512, 512
};

int oo_y_lut_sdr_hlg[149] = {
	331, 349, 354, 359, 364, 369, 374, 379, 384, 386,
	387, 389, 390, 391, 393, 394, 395, 397, 398, 399,
	400, 402, 404, 405, 406, 408, 409, 410, 411, 413,
	415, 416, 417, 419, 420, 422, 423, 425, 426, 427,
	429, 430, 432, 433, 434, 435, 436, 437, 438, 439,
	439, 440, 440, 441, 442, 443, 444, 445, 445, 446,
	446, 447, 448, 449, 450, 451, 451, 452, 453, 454,
	455, 455, 456, 457, 458, 458, 459, 460, 461, 462,
	462, 463, 464, 464, 465, 466, 467, 468, 469, 469,
	470, 471, 471, 472, 473, 474, 475, 476, 477, 477,
	478, 479, 480, 481, 482, 482, 483, 484, 484, 486,
	487, 487, 488, 489, 490, 490, 491, 492, 493, 494,
	495, 496, 496, 497, 498, 499, 500, 501, 502, 503,
	503, 504, 505, 505, 506, 506, 507, 507, 508, 508,
	509, 509, 509, 510, 510, 511, 511, 511, 512
};

static int eo_y_hdr_10000[143] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7,
	8, 9, 10, 11, 12, 14, 15, 17, 18, 20, 22, 24, 26,
	29, 31, 34, 37, 41, 44, 48, 52, 57, 62, 67, 72, 78,
	85, 92, 99, 107, 116, 125, 135, 146, 158, 170, 183,
	198, 213, 229, 247, 266, 287, 309, 332, 357, 384, 413,
	445, 478, 514, 553, 594, 639, 686, 737, 792, 851, 915,
	983, 1056, 1134, 1219, 1309, 1406, 1511, 1623, 1744,
	1873, 2012, 2162, 2323, 2496, 2683, 2883, 3098, 3330,
	3580, 3849, 4138, 4450, 4786, 5148, 5539, 5959, 6413,
	6903, 7431, 8001, 8616, 9281, 10000
};

unsigned int hdr10_pr;
unsigned int hdr10_clip_disable = 1;
unsigned int hdr10_clip_luma;
/*margin: margin / 10*/
unsigned int hdr10_clip_margin = 2;

static uint force_din_swap = 0xff;
module_param(force_din_swap, uint, 0664);
MODULE_PARM_DESC(force_din_swap, "\n force_din_swap\n");

static uint force_mtrxo_en = 0xff;
module_param(force_mtrxo_en, uint, 0664);
MODULE_PARM_DESC(force_mtrxo_en, "\n force_mtrxo_en\n");

static uint force_mtrxi_en = 0xff;
module_param(force_mtrxi_en, uint, 0664);
MODULE_PARM_DESC(force_mtrxi_en, "\n force_mtrxi_en\n");

static uint force_eo_enable = 0xff;
module_param(force_eo_enable, uint, 0664);
MODULE_PARM_DESC(force_eo_enable, "\n force_eo_enable\n");

static uint force_oe_enable = 0xff;
module_param(force_oe_enable, uint, 0664);
MODULE_PARM_DESC(force_oe_enable, "\n force_oe_enable\n");

static uint force_ogain_enable = 0xff;
module_param(force_ogain_enable, uint, 0664);
MODULE_PARM_DESC(force_ogain_enable, "\n force_ogain_enable\n");

static uint force_cgain_enable = 0xff;
module_param(force_cgain_enable, uint, 0664);
MODULE_PARM_DESC(force_cgain_enable, "\n force_cgain_enable\n");

static uint out_luma = 5;
module_param(out_luma, uint, 0664);
MODULE_PARM_DESC(out_luma, "\n out_luma\n");

static uint in_luma = 1;/*1 as 100luminance*/
module_param(in_luma, uint, 0664);
MODULE_PARM_DESC(in_luma, "\n in_luma\n");

static uint adp_scal_y_shift = 10; /* 1.0 =1024 */
module_param(adp_scal_y_shift, uint, 0664);
MODULE_PARM_DESC(adp_scal_y_shift, "\n adp_scal_y_shift\n");

#define X_SHFT 10
static uint adp_scal_x_shift = X_SHFT; /* 1.0 = 1024 */
module_param(adp_scal_x_shift, uint, 0664);
MODULE_PARM_DESC(adp_scal_x_shift, "\n adp_scal_x_shift\n");

static uint alpha_oe_a = 0x1;
module_param(alpha_oe_a, uint, 0664);
MODULE_PARM_DESC(alpha_oe_a, "\n alpha_oe_a\n");

static uint alpha_oe_b = 0x1;
module_param(alpha_oe_b, uint, 0664);
MODULE_PARM_DESC(alpha_oe_b, "\n alpha_oe_b\n");

static uint hdr2_debug;
module_param(hdr2_debug, uint, 0664);
MODULE_PARM_DESC(hdr2_debug, "\n hdr2_debug\n");

/* gamut 3x3 matrix*/
/*standard 2020rgb->709rgb*/
int ncl_2020_709[9] = {
	3401, -1204, -149, -255, 2320, -17, -37, -206, 2291};
/* dci-p3->709rgb*/
/*int ncl_2020_709[9] = {*/
	/*2543, -459, -36, -88, 2133, 3, -41, -161, 2250};*/

/* standard2020->dcip3 8bit*/
int ncl_2020_p3dci[9] = {
	368, -96, -16, -16, 275, -3, 1, -8, 263
};

/* standard2020->d65p3 8bit*/
int ncl_2020_p3d65[9] = {
	344, -72, -15, -16, 275, -2, 0, -5, 260
};

/* primary->panel 8bit*/
int ncl_prmy_panel[9] = {
	344, -72, -15, -16, 275, -2, 0, -5, 260
};

int gamut_bypass_8bit[9] = {
	256, 0, 0, 0, 256, 0, 0, 0, 256
};

/* standard2020->709-d65 8bit*/
int ncl_2020_709_8bit[9] = {
	425, -150, -18, -31, 290, -2, -4, -25, 286
};

/*for iptv special primary->709rgb*/
int ncl_sp_709[9] = {
	2684, -489, -147, -201, 2266, -17, -29, -171, 2248};

/* gamut bypass */
int gamut_bypass[9] = {2048, 0, 0, 0, 2048, 0, 0, 0, 2048};

/*int cl_2020_709[9] =*/
	/*{-1775, 3867, -44, 3422, -1154, -220 ,-304,	43, 2309}; */
int ncl_709_2020[9] = {1285, 674, 89, 142, 1883, 23, 34, 180, 1834};
/*int cl_709_2020[9] =*/
	/*{436, 1465, 148, 1285, 674, 89, 34, 180, 1834}; */


/* 1688, 2146,  262, */
/*  683, 2951,  462, */
/*   99,  309, 3688, */
/* 4096 as 1.0 */
int rgb2lms_ncl2020[9] = {
	844, 1073, 131,
	342, 1475, 231,
	50, 154, 1844
};

/* ncl_709_2020 * rgb2lms_ncl2020 */
/* 606.133 1275.828 166.040 */
/* 320.411 1489.315 238.273 */
/* 72.384  320.413 1655.203 */
int rgb709_to_lms2020[9] = {
	606, 1276, 166,
	321, 1489, 238,
	72, 320, 1656
};

/* Ys coeff, 1.0 = 1024 */
int ys_coef[3] = {269, 694, 61};

/* matrix coef */
int rgb2yuvpre[3]	= {0, 0, 0};
int rgb2yuvpos[3]	= {64, 512, 512};
int yuv2rgbpre[3]	= {-64, -512, -512};
int yuvf2rgbpre[3]	= {0, -512, -512};
int yuv2rgbpos[3]	= {0, 0, 0};
int bypass_pre[3] = {0, 0, 0};
int bypass_pos[3] = {0, 0, 0};

int rgb2yuvfpre[3]	= {0, 0, 0};
int rgb2yuvfpos[3]	= {0, 512, 512};

int srgb2yuvfpre[3]	= {-64, -64, -64};
int srgb2yuvfpos[3]	= {0, 512, 512};

/*matrix coef BT709*/
int yuv2rgbmat[MTX_NUM_PARAM] = {
	1197, 0, 0,
	1197, 1851, 0,
	1197, 0, 1163,
	1197, 2271, 0,
	1197, 0, 2011,
	0
};

int rgb2ycbcr[MTX_NUM_PARAM] = {
	230, 594, 52,
	-125, -323,
	448, 448, -412,
	-36, 0, 0,
	0, 0, 0,
	0
};

int rgb2ycbcr_ncl2020[MTX_NUM_PARAM] = {
	230, 594, 52,
	-125, -323, 448,
	448, -412, -36,
	0, 0, 0,
	0, 0, 0,
	0
};

int rgb2ycbcr_709[MTX_NUM_PARAM] = {
	186, 627, 63,
	-103, -345, 448,
	448, -407, -41,
	0, 0, 0,
	0, 0, 0,
	0
};

int rgb2ycbcrf_709[MTX_NUM_PARAM] = {
	218, 732, 74,
	-117, -393, 512,
	512, -464, -46,
	0, 0, 0,
	0, 0, 0,
	0
};

int srgb2ycbcrf_709[MTX_NUM_PARAM] = {
	254, 853, 86,
	-137, -459, 596,
	596, -542, -55,
	0, 0, 0,
	0, 0, 0,
	0
};

int ycbcr2rgb_709[MTX_NUM_PARAM]  = {
	1192, 0, 1836,
	1192, -217, -546,
	1192, 2166, 0,
	0, 0, 0,
	0, 0, 0,
	0
};

/*
 R = 1.0, 0, 1.402
 G = 1.0, -0.344136, -0.714136
 B = 1.0, 1.772, 0
*/
int ycbcrf2rgb_709[MTX_NUM_PARAM]  = {
	1024, 0, 1436,
	1024, -352, -731,
	1024, 1815, 0,
	0, 0, 0,
	0, 0, 0,
	0
};

/* int yrb2ycbcr_cl2020[MTX_NUM_PARAM] = { */
/*	876, 0, 0,    */
/*	-566, 0, 566, */
/*	-902, 902, 0, */
/*	-462, 0, 462, */
/*	-521, 521, 0, */
/*	0};	*/

int ycbcr2rgb_ncl2020[MTX_NUM_PARAM] = {
	1197, 0, 1726,
	1197, -193, -669,
	1197, 2202, 0,
	0, 0, 0,
	0, 0, 0,
	0
};

/*
 1, 0, 1.4746
 1, -0.16455312684366, -0.57135312684366
 1, 1.8814, 0
 */
int ycbcrf2rgb_ncl2020[MTX_NUM_PARAM] = {
	1024, 0, 1510,
	1024, -169, -585,
	1024, 1927, 0,
	0, 0, 0,
	0, 0, 0,
	0
};

/* int ycbcr2yrb_cl2020[MTX_NUM_PARAM] = { */
/*	1197, 0, 0, */
/*	1197, 0, 1163, */
/*	1197, 1851, 0, */
/*	1197, 0, 2011, */
/*	1197, 2271, 0, */
/*	0 */
/*}; */

/* int yrb2ycbcr_cl2020[MTX_NUM_PARAM] = { */
/*	876, 0, 0, */
/*	-566, 0, 566, */
/*	-902, 902, 0, */
/*	-462, 0, 462, */
/*	-521, 521, 0, */
/*	0 */
/* }; */

/* [ 2048,  2048,    0], */
/* [ 6610,-13613, 7003], */
/* [17933,-17390, -543] / 4096 */
/* int lms2ipt_ncl2020[MTX_NUM_PARAM] = { */
/*	256, 256, 0, */
/*	2242, -2174, -68, */
/*	827, -1702, 875, */
/*	0, 0, 0, */
/*	0, 0, 0, */
/*	7 << 5 */
/* }; */


int lms2ipt_ncl2020[MTX_NUM_PARAM] = {
	410,    410,  204,
	2281, -2484,  203,
	413,    183, -596,
	0, 0, 0,
	0, 0, 0,
	0
};

static int bypass_coeff[MTX_NUM_PARAM] = {
	1024, 0, 0,
	0, 1024, 0,
	0, 0, 1024,
	0, 0, 0,
	0, 0, 0,
	0
};

int full2lmt_pre[3]	= {-0, -512, -512};
int full2lmt_pos[3]	= {0, 512, 512};
static int full2lmt_coeff[MTX_NUM_PARAM] = {
	1024, 0, 0,
	0, 512, 0,
	0, 0, 512,
	0, 0, 0,
	0, 0, 0,
	0
};

int srgb2rgb_pre[3]	= {-64, -64, -64};
int srgb2rgb_pos[3]	= {0, 0, 0};
static int srgb2rgb_coeff[MTX_NUM_PARAM] = {
	1192, 0, 0,
	0, 1192, 0,
	0, 0, 1192,
	0, 0, 0,
	0, 0, 0,
	0
};

unsigned int _log2(unsigned int value)
{
	unsigned int ret;

	for (ret = 0; value > 1; ret++)
		value >>= 1;

	return ret;
}

static int prmy_maxl[7] = {
	1200, 2000, 3000, 5000, 7000, 9000, 10000
};
/*1024 as 1.0*/
static int margin_maxl[7] = {
	560, 384, 256, 128, 64, 16, 8
};
/*eo clip calculate according to luminance*/
static unsigned int eo_clip_maxl(unsigned int maxl)
{
	unsigned int clip_maxl = 0;
	int i;

	for (i = 0; i < 7; i++) {
		if (maxl <= prmy_maxl[i]) {
			clip_maxl = maxl + ((maxl * margin_maxl[i]) >> 10);
			return clip_maxl;
		}
	}

	return clip_maxl;
}
/*master_info used to get maxl
 *eo_sel used to sel 23bit eo or 32 bit eo
 */
void eo_clip_proc(
	struct vframe_master_display_colour_s *master_info,
	unsigned int eo_sel)
{
	unsigned int clip_index;
	unsigned int max_luma;
	int i;

	if (hdr10_clip_disable) {
		if (hdr10_pr & 0x1)
			pr_info("clip_disable = %d\n", hdr10_clip_disable);
		return;
	}

	/*force clip luma used for debug*/
	if (hdr10_clip_luma) {
		for (i = HDR2_EOTF_LUT_SIZE - 1; i >= 0; i--) {
			if (eo_y_hdr_10000[i] < hdr10_clip_luma) {
				clip_index = i + 1;
				break;
			}
			clip_index = HDR2_EOTF_LUT_SIZE - 1;
		}
		if (clip_index > HDR2_EOTF_LUT_SIZE - 1)
			clip_index = HDR2_EOTF_LUT_SIZE - 1;

		for (i = 0; i < HDR2_EOTF_LUT_SIZE; i++) {
			if (eo_sel) {
				if (i < clip_index)
					eo_y_lut_pq[i] = eo_y_lut_pq_def[i];
				if (i >= clip_index)
					eo_y_lut_pq[i] =
					eo_y_lut_pq_def[clip_index];
			} else {
				if (i < clip_index)
					eo_y_lut_hdr[i] = eo_y_lut_hdr_def[i];
				if (i >= clip_index)
					eo_y_lut_hdr[i] =
					eo_y_lut_hdr_def[clip_index];
			}
		}
		return;
	}
	/*force clip end*/

	if (master_info->luminance[0] > 10000)
		master_info->luminance[0] /= 10000;

	/*invalid luminance*/
	if (master_info->luminance[0] < 100)
		master_info->luminance[0] = 0;

	max_luma = eo_clip_maxl(master_info->luminance[0]);

	if (max_luma > 10000)
		max_luma = 10000;

	for (i = HDR2_EOTF_LUT_SIZE - 1; i >= 0; i--) {
		if ((master_info->luminance[0] == 0) ||
		    (master_info->present_flag == 0)) {
			/*default 1000 luminance*/
			if (eo_y_hdr_10000[i] < 1200) {
				clip_index = i + 1;
				break;
			}
		}

		if (eo_y_hdr_10000[i] < max_luma) {
			clip_index = i + 1;
			break;
		}

		clip_index = HDR2_EOTF_LUT_SIZE - 1;
	}

	if (clip_index > HDR2_EOTF_LUT_SIZE - 1)
		clip_index = HDR2_EOTF_LUT_SIZE - 1;
	for (i = 0; i < HDR2_EOTF_LUT_SIZE; i++) {
		if (eo_sel) {
			if (i < clip_index)
				eo_y_lut_pq[i] = eo_y_lut_pq_def[i];
			if (i >= clip_index)
				eo_y_lut_pq[i] = eo_y_lut_pq_def[clip_index];
		} else {
			if (i < clip_index)
				eo_y_lut_hdr[i] = eo_y_lut_hdr_def[i];
			if (i >= clip_index)
				eo_y_lut_hdr[i] = eo_y_lut_hdr_def[clip_index];
		}
	}

	if (hdr10_pr & 0x1) {
		pr_info("luma=%d,eo_lut[%d]=%d,clip_margin=%d\n",
			master_info->luminance[0], clip_index,
			eo_y_lut_hdr[clip_index], hdr10_clip_margin);
		if (hdr10_clip_luma)
			pr_info("clip_luma = %d\n", hdr10_clip_luma);
	}
}

/*in/out matrix*/
void set_hdr_matrix(
	enum hdr_module_sel module_sel,
	enum hdr_matrix_sel mtx_sel,
	struct hdr_proc_mtx_param_s *hdr_mtx_param,
	struct hdr10pgen_param_s *p_hdr10pgen_param)
{
	unsigned int MATRIXI_COEF00_01 = 0;
	unsigned int MATRIXI_COEF02_10 = 0;
	unsigned int MATRIXI_COEF11_12 = 0;
	unsigned int MATRIXI_COEF20_21 = 0;
	unsigned int MATRIXI_COEF22 = 0;
	unsigned int MATRIXI_COEF30_31 = 0;
	unsigned int MATRIXI_COEF32_40 = 0;
	unsigned int MATRIXI_COEF41_42 = 0;
	unsigned int MATRIXI_OFFSET0_1 = 0;
	unsigned int MATRIXI_OFFSET2 = 0;
	unsigned int MATRIXI_PRE_OFFSET0_1 = 0;
	unsigned int MATRIXI_PRE_OFFSET2 = 0;
	unsigned int MATRIXI_CLIP = 0;
	unsigned int MATRIXI_EN_CTRL = 0;

	unsigned int MATRIXO_COEF00_01 = 0;
	unsigned int MATRIXO_COEF02_10 = 0;
	unsigned int MATRIXO_COEF11_12 = 0;
	unsigned int MATRIXO_COEF20_21 = 0;
	unsigned int MATRIXO_COEF22 = 0;
	unsigned int MATRIXO_COEF30_31 = 0;
	unsigned int MATRIXO_COEF32_40 = 0;
	unsigned int MATRIXO_COEF41_42 = 0;
	unsigned int MATRIXO_OFFSET0_1 = 0;
	unsigned int MATRIXO_OFFSET2 = 0;
	unsigned int MATRIXO_PRE_OFFSET0_1 = 0;
	unsigned int MATRIXO_PRE_OFFSET2 = 0;
	unsigned int MATRIXO_CLIP = 0;
	unsigned int MATRIXO_EN_CTRL = 0;

	unsigned int CGAIN_OFFT = 0;
	unsigned int CGAIN_COEF0 = 0;
	unsigned int CGAIN_COEF1 = 0;
	unsigned int ADPS_CTRL = 0;
	unsigned int ADPS_ALPHA0 = 0;
	unsigned int ADPS_ALPHA1 = 0;
	unsigned int ADPS_BETA0 = 0;
	unsigned int ADPS_BETA1 = 0;
	unsigned int ADPS_BETA2 = 0;
	unsigned int ADPS_COEF0 = 0;
	unsigned int ADPS_COEF1 = 0;
	unsigned int GMUT_CTRL = 0;
	unsigned int GMUT_COEF0 = 0;
	unsigned int GMUT_COEF1 = 0;
	unsigned int GMUT_COEF2 = 0;
	unsigned int GMUT_COEF3 = 0;
	unsigned int GMUT_COEF4 = 0;

	unsigned int hdr_ctrl = 0;
	unsigned int hdr_clk_gate = 0;
	unsigned int cur_hdr_ctrl = 0;

	int adpscl_mode = 0;

	int c_gain_lim_coef[3];
	int gmut_coef[3][3];
	int gmut_shift;
	int adpscl_bypass[3];
	int adpscl_alpha[3] = {0, 0, 0};
	int adpscl_shift[3];
	int adpscl_ys_coef[3] = {
		269,
		694,
		61
	};
	int adpscl_beta[3];
	int adpscl_beta_s[3];

	int scale_shift = 0;

	int i = 0;
	int in_mtx[MTX_NUM_PARAM] = {
		1024, 0, 0,
		0, 1024, 0,
		0, 0, 1024,
		0, 0, 0,
		0, 0, 0,
		0
	};

	int out_mtx[MTX_NUM_PARAM] = {
		1024, 0, 0,
		0, 1024, 0,
		0, 0, 1024,
		0, 0, 0,
		0, 0, 0,
		0
	};

	if (module_sel == VD1_HDR) {
		MATRIXI_COEF00_01 = VD1_HDR2_MATRIXI_COEF00_01;
		MATRIXI_COEF00_01 = VD1_HDR2_MATRIXI_COEF00_01;
		MATRIXI_COEF02_10 = VD1_HDR2_MATRIXI_COEF02_10;
		MATRIXI_COEF11_12 = VD1_HDR2_MATRIXI_COEF11_12;
		MATRIXI_COEF20_21 = VD1_HDR2_MATRIXI_COEF20_21;
		MATRIXI_COEF22 = VD1_HDR2_MATRIXI_COEF22;
		MATRIXI_COEF30_31 = VD1_HDR2_MATRIXI_COEF30_31;
		MATRIXI_COEF32_40 = VD1_HDR2_MATRIXI_COEF32_40;
		MATRIXI_COEF41_42 = VD1_HDR2_MATRIXI_COEF41_42;
		MATRIXI_OFFSET0_1 = VD1_HDR2_MATRIXI_OFFSET0_1;
		MATRIXI_OFFSET2 = VD1_HDR2_MATRIXI_OFFSET2;
		MATRIXI_PRE_OFFSET0_1 = VD1_HDR2_MATRIXI_PRE_OFFSET0_1;
		MATRIXI_PRE_OFFSET2 = VD1_HDR2_MATRIXI_PRE_OFFSET2;
		MATRIXI_CLIP = VD1_HDR2_MATRIXI_CLIP;
		MATRIXI_EN_CTRL = VD1_HDR2_MATRIXI_EN_CTRL;

		MATRIXO_COEF00_01 = VD1_HDR2_MATRIXO_COEF00_01;
		MATRIXO_COEF00_01 = VD1_HDR2_MATRIXO_COEF00_01;
		MATRIXO_COEF02_10 = VD1_HDR2_MATRIXO_COEF02_10;
		MATRIXO_COEF11_12 = VD1_HDR2_MATRIXO_COEF11_12;
		MATRIXO_COEF20_21 = VD1_HDR2_MATRIXO_COEF20_21;
		MATRIXO_COEF22 = VD1_HDR2_MATRIXO_COEF22;
		MATRIXO_COEF30_31 = VD1_HDR2_MATRIXO_COEF30_31;
		MATRIXO_COEF32_40 = VD1_HDR2_MATRIXO_COEF32_40;
		MATRIXO_COEF41_42 = VD1_HDR2_MATRIXO_COEF41_42;
		MATRIXO_OFFSET0_1 = VD1_HDR2_MATRIXO_OFFSET0_1;
		MATRIXO_OFFSET2 = VD1_HDR2_MATRIXO_OFFSET2;
		MATRIXO_PRE_OFFSET0_1 = VD1_HDR2_MATRIXO_PRE_OFFSET0_1;
		MATRIXO_PRE_OFFSET2 = VD1_HDR2_MATRIXO_PRE_OFFSET2;
		MATRIXO_CLIP = VD1_HDR2_MATRIXO_CLIP;
		MATRIXO_EN_CTRL = VD1_HDR2_MATRIXO_EN_CTRL;

		CGAIN_OFFT = VD1_HDR2_CGAIN_OFFT;
		CGAIN_COEF0 = VD1_HDR2_CGAIN_COEF0;
		CGAIN_COEF1 = VD1_HDR2_CGAIN_COEF1;
		ADPS_CTRL = VD1_HDR2_ADPS_CTRL;
		ADPS_ALPHA0 = VD1_HDR2_ADPS_ALPHA0;
		ADPS_ALPHA1 = VD1_HDR2_ADPS_ALPHA1;
		ADPS_BETA0 = VD1_HDR2_ADPS_BETA0;
		ADPS_BETA1 = VD1_HDR2_ADPS_BETA1;
		ADPS_BETA2 = VD1_HDR2_ADPS_BETA2;
		ADPS_COEF0 = VD1_HDR2_ADPS_COEF0;
		ADPS_COEF1 = VD1_HDR2_ADPS_COEF1;
		GMUT_CTRL = VD1_HDR2_GMUT_CTRL;
		GMUT_COEF0 = VD1_HDR2_GMUT_COEF0;
		GMUT_COEF1 = VD1_HDR2_GMUT_COEF1;
		GMUT_COEF2 = VD1_HDR2_GMUT_COEF2;
		GMUT_COEF3 = VD1_HDR2_GMUT_COEF3;
		GMUT_COEF4 = VD1_HDR2_GMUT_COEF4;

		hdr_ctrl = VD1_HDR2_CTRL;
		hdr_clk_gate = VD1_HDR2_CLK_GATE;
	} else if (module_sel == VD2_HDR) {
		MATRIXI_COEF00_01 = VD2_HDR2_MATRIXI_COEF00_01;
		MATRIXI_COEF00_01 = VD2_HDR2_MATRIXI_COEF00_01;
		MATRIXI_COEF02_10 = VD2_HDR2_MATRIXI_COEF02_10;
		MATRIXI_COEF11_12 = VD2_HDR2_MATRIXI_COEF11_12;
		MATRIXI_COEF20_21 = VD2_HDR2_MATRIXI_COEF20_21;
		MATRIXI_COEF22 = VD2_HDR2_MATRIXI_COEF22;
		MATRIXI_COEF30_31 = VD2_HDR2_MATRIXI_COEF30_31;
		MATRIXI_COEF32_40 = VD2_HDR2_MATRIXI_COEF32_40;
		MATRIXI_COEF41_42 = VD2_HDR2_MATRIXI_COEF41_42;
		MATRIXI_OFFSET0_1 = VD2_HDR2_MATRIXI_OFFSET0_1;
		MATRIXI_OFFSET2 = VD2_HDR2_MATRIXI_OFFSET2;
		MATRIXI_PRE_OFFSET0_1 = VD2_HDR2_MATRIXI_PRE_OFFSET0_1;
		MATRIXI_PRE_OFFSET2 = VD2_HDR2_MATRIXI_PRE_OFFSET2;
		MATRIXI_CLIP = VD2_HDR2_MATRIXI_CLIP;
		MATRIXI_EN_CTRL = VD2_HDR2_MATRIXI_EN_CTRL;

		MATRIXO_COEF00_01 = VD2_HDR2_MATRIXO_COEF00_01;
		MATRIXO_COEF00_01 = VD2_HDR2_MATRIXO_COEF00_01;
		MATRIXO_COEF02_10 = VD2_HDR2_MATRIXO_COEF02_10;
		MATRIXO_COEF11_12 = VD2_HDR2_MATRIXO_COEF11_12;
		MATRIXO_COEF20_21 = VD2_HDR2_MATRIXO_COEF20_21;
		MATRIXO_COEF22 = VD2_HDR2_MATRIXO_COEF22;
		MATRIXO_COEF30_31 = VD2_HDR2_MATRIXO_COEF30_31;
		MATRIXO_COEF32_40 = VD2_HDR2_MATRIXO_COEF32_40;
		MATRIXO_COEF41_42 = VD2_HDR2_MATRIXO_COEF41_42;
		MATRIXO_OFFSET0_1 = VD2_HDR2_MATRIXO_OFFSET0_1;
		MATRIXO_OFFSET2 = VD2_HDR2_MATRIXO_OFFSET2;
		MATRIXO_PRE_OFFSET0_1 = VD2_HDR2_MATRIXO_PRE_OFFSET0_1;
		MATRIXO_PRE_OFFSET2 = VD2_HDR2_MATRIXO_PRE_OFFSET2;
		MATRIXO_CLIP = VD2_HDR2_MATRIXO_CLIP;
		MATRIXO_EN_CTRL = VD2_HDR2_MATRIXO_EN_CTRL;

		CGAIN_OFFT = VD2_HDR2_CGAIN_OFFT;
		CGAIN_COEF0 = VD2_HDR2_CGAIN_COEF0;
		CGAIN_COEF1 = VD2_HDR2_CGAIN_COEF1;
		ADPS_CTRL = VD2_HDR2_ADPS_CTRL;
		ADPS_ALPHA0 = VD2_HDR2_ADPS_ALPHA0;
		ADPS_ALPHA1 = VD2_HDR2_ADPS_ALPHA1;
		ADPS_BETA0 = VD2_HDR2_ADPS_BETA0;
		ADPS_BETA1 = VD2_HDR2_ADPS_BETA1;
		ADPS_BETA2 = VD2_HDR2_ADPS_BETA2;
		ADPS_COEF0 = VD2_HDR2_ADPS_COEF0;
		ADPS_COEF1 = VD2_HDR2_ADPS_COEF1;
		GMUT_CTRL = VD2_HDR2_GMUT_CTRL;
		GMUT_COEF0 = VD2_HDR2_GMUT_COEF0;
		GMUT_COEF1 = VD2_HDR2_GMUT_COEF1;
		GMUT_COEF2 = VD2_HDR2_GMUT_COEF2;
		GMUT_COEF3 = VD2_HDR2_GMUT_COEF3;
		GMUT_COEF4 = VD2_HDR2_GMUT_COEF4;

		hdr_ctrl = VD2_HDR2_CTRL;
		hdr_clk_gate = VD2_HDR2_CLK_GATE;
	} else if (module_sel == OSD1_HDR) {
		MATRIXI_COEF00_01 = OSD1_HDR2_MATRIXI_COEF00_01;
		MATRIXI_COEF00_01 = OSD1_HDR2_MATRIXI_COEF00_01;
		MATRIXI_COEF02_10 = OSD1_HDR2_MATRIXI_COEF02_10;
		MATRIXI_COEF11_12 = OSD1_HDR2_MATRIXI_COEF11_12;
		MATRIXI_COEF20_21 = OSD1_HDR2_MATRIXI_COEF20_21;
		MATRIXI_COEF22 = OSD1_HDR2_MATRIXI_COEF22;
		MATRIXI_COEF30_31 = OSD1_HDR2_MATRIXI_COEF30_31;
		MATRIXI_COEF32_40 = OSD1_HDR2_MATRIXI_COEF32_40;
		MATRIXI_COEF41_42 = OSD1_HDR2_MATRIXI_COEF41_42;
		MATRIXI_OFFSET0_1 = OSD1_HDR2_MATRIXI_OFFSET0_1;
		MATRIXI_OFFSET2 = OSD1_HDR2_MATRIXI_OFFSET2;
		MATRIXI_PRE_OFFSET0_1 = OSD1_HDR2_MATRIXI_PRE_OFFSET0_1;
		MATRIXI_PRE_OFFSET2 = OSD1_HDR2_MATRIXI_PRE_OFFSET2;
		MATRIXI_CLIP = OSD1_HDR2_MATRIXI_CLIP;
		MATRIXI_EN_CTRL = OSD1_HDR2_MATRIXI_EN_CTRL;

		MATRIXO_COEF00_01 = OSD1_HDR2_MATRIXO_COEF00_01;
		MATRIXO_COEF00_01 = OSD1_HDR2_MATRIXO_COEF00_01;
		MATRIXO_COEF02_10 = OSD1_HDR2_MATRIXO_COEF02_10;
		MATRIXO_COEF11_12 = OSD1_HDR2_MATRIXO_COEF11_12;
		MATRIXO_COEF20_21 = OSD1_HDR2_MATRIXO_COEF20_21;
		MATRIXO_COEF22 = OSD1_HDR2_MATRIXO_COEF22;
		MATRIXO_COEF30_31 = OSD1_HDR2_MATRIXO_COEF30_31;
		MATRIXO_COEF32_40 = OSD1_HDR2_MATRIXO_COEF32_40;
		MATRIXO_COEF41_42 = OSD1_HDR2_MATRIXO_COEF41_42;
		MATRIXO_OFFSET0_1 = OSD1_HDR2_MATRIXO_OFFSET0_1;
		MATRIXO_OFFSET2 = OSD1_HDR2_MATRIXO_OFFSET2;
		MATRIXO_PRE_OFFSET0_1 = OSD1_HDR2_MATRIXO_PRE_OFFSET0_1;
		MATRIXO_PRE_OFFSET2 = OSD1_HDR2_MATRIXO_PRE_OFFSET2;
		MATRIXO_CLIP = OSD1_HDR2_MATRIXO_CLIP;
		MATRIXO_EN_CTRL = OSD1_HDR2_MATRIXO_EN_CTRL;

		CGAIN_OFFT = OSD1_HDR2_CGAIN_OFFT;
		CGAIN_COEF0 = OSD1_HDR2_CGAIN_COEF0;
		CGAIN_COEF1 = OSD1_HDR2_CGAIN_COEF1;
		ADPS_CTRL = OSD1_HDR2_ADPS_CTRL;
		ADPS_ALPHA0 = OSD1_HDR2_ADPS_ALPHA0;
		ADPS_ALPHA1 = OSD1_HDR2_ADPS_ALPHA1;
		ADPS_BETA0 = OSD1_HDR2_ADPS_BETA0;
		ADPS_BETA1 = OSD1_HDR2_ADPS_BETA1;
		ADPS_BETA2 = OSD1_HDR2_ADPS_BETA2;
		ADPS_COEF0 = OSD1_HDR2_ADPS_COEF0;
		ADPS_COEF1 = OSD1_HDR2_ADPS_COEF1;
		GMUT_CTRL = OSD1_HDR2_GMUT_CTRL;
		GMUT_COEF0 = OSD1_HDR2_GMUT_COEF0;
		GMUT_COEF1 = OSD1_HDR2_GMUT_COEF1;
		GMUT_COEF2 = OSD1_HDR2_GMUT_COEF2;
		GMUT_COEF3 = OSD1_HDR2_GMUT_COEF3;
		GMUT_COEF4 = OSD1_HDR2_GMUT_COEF4;

		hdr_ctrl = OSD1_HDR2_CTRL;
		hdr_clk_gate = OSD1_HDR2_CLK_GATE;
	} else if (module_sel == DI_HDR) {
		MATRIXI_COEF00_01 = DI_HDR2_MATRIXI_COEF00_01;
		MATRIXI_COEF00_01 = DI_HDR2_MATRIXI_COEF00_01;
		MATRIXI_COEF02_10 = DI_HDR2_MATRIXI_COEF02_10;
		MATRIXI_COEF11_12 = DI_HDR2_MATRIXI_COEF11_12;
		MATRIXI_COEF20_21 = DI_HDR2_MATRIXI_COEF20_21;
		MATRIXI_COEF22 = DI_HDR2_MATRIXI_COEF22;
		MATRIXI_COEF30_31 = DI_HDR2_MATRIXI_COEF30_31;
		MATRIXI_COEF32_40 = DI_HDR2_MATRIXI_COEF32_40;
		MATRIXI_COEF41_42 = DI_HDR2_MATRIXI_COEF41_42;
		MATRIXI_OFFSET0_1 = DI_HDR2_MATRIXI_OFFSET0_1;
		MATRIXI_OFFSET2 = DI_HDR2_MATRIXI_OFFSET2;
		MATRIXI_PRE_OFFSET0_1 = DI_HDR2_MATRIXI_PRE_OFFSET0_1;
		MATRIXI_PRE_OFFSET2 = DI_HDR2_MATRIXI_PRE_OFFSET2;
		MATRIXI_CLIP = DI_HDR2_MATRIXI_CLIP;
		MATRIXI_EN_CTRL = DI_HDR2_MATRIXI_EN_CTRL;

		MATRIXO_COEF00_01 = DI_HDR2_MATRIXO_COEF00_01;
		MATRIXO_COEF00_01 = DI_HDR2_MATRIXO_COEF00_01;
		MATRIXO_COEF02_10 = DI_HDR2_MATRIXO_COEF02_10;
		MATRIXO_COEF11_12 = DI_HDR2_MATRIXO_COEF11_12;
		MATRIXO_COEF20_21 = DI_HDR2_MATRIXO_COEF20_21;
		MATRIXO_COEF22 = DI_HDR2_MATRIXO_COEF22;
		MATRIXO_COEF30_31 = DI_HDR2_MATRIXO_COEF30_31;
		MATRIXO_COEF32_40 = DI_HDR2_MATRIXO_COEF32_40;
		MATRIXO_COEF41_42 = DI_HDR2_MATRIXO_COEF41_42;
		MATRIXO_OFFSET0_1 = DI_HDR2_MATRIXO_OFFSET0_1;
		MATRIXO_OFFSET2 = DI_HDR2_MATRIXO_OFFSET2;
		MATRIXO_PRE_OFFSET0_1 = DI_HDR2_MATRIXO_PRE_OFFSET0_1;
		MATRIXO_PRE_OFFSET2 = DI_HDR2_MATRIXO_PRE_OFFSET2;
		MATRIXO_CLIP = DI_HDR2_MATRIXO_CLIP;
		MATRIXO_EN_CTRL = DI_HDR2_MATRIXO_EN_CTRL;

		CGAIN_OFFT = DI_HDR2_CGAIN_OFFT;
		CGAIN_COEF0 = DI_HDR2_CGAIN_COEF0;
		CGAIN_COEF1 = DI_HDR2_CGAIN_COEF1;
		ADPS_CTRL = DI_HDR2_ADPS_CTRL;
		ADPS_ALPHA0 = DI_HDR2_ADPS_ALPHA0;
		ADPS_ALPHA1 = DI_HDR2_ADPS_ALPHA1;
		ADPS_BETA0 = DI_HDR2_ADPS_BETA0;
		ADPS_BETA1 = DI_HDR2_ADPS_BETA1;
		ADPS_BETA2 = DI_HDR2_ADPS_BETA2;
		ADPS_COEF0 = DI_HDR2_ADPS_COEF0;
		ADPS_COEF1 = DI_HDR2_ADPS_COEF1;
		GMUT_CTRL = DI_HDR2_GMUT_CTRL;
		GMUT_COEF0 = DI_HDR2_GMUT_COEF0;
		GMUT_COEF1 = DI_HDR2_GMUT_COEF1;
		GMUT_COEF2 = DI_HDR2_GMUT_COEF2;
		GMUT_COEF3 = DI_HDR2_GMUT_COEF3;
		GMUT_COEF4 = DI_HDR2_GMUT_COEF4;

		hdr_ctrl = DI_HDR2_CTRL;
		/* hdr_clk_gate = DI_HDR2_CLK_GATE; */
	} else if (module_sel == VDIN0_HDR) {
		MATRIXI_COEF00_01 = VDIN0_HDR2_MATRIXI_COEF00_01;
		MATRIXI_COEF00_01 = VDIN0_HDR2_MATRIXI_COEF00_01;
		MATRIXI_COEF02_10 = VDIN0_HDR2_MATRIXI_COEF02_10;
		MATRIXI_COEF11_12 = VDIN0_HDR2_MATRIXI_COEF11_12;
		MATRIXI_COEF20_21 = VDIN0_HDR2_MATRIXI_COEF20_21;
		MATRIXI_COEF22 = VDIN0_HDR2_MATRIXI_COEF22;
		MATRIXI_COEF30_31 = VDIN0_HDR2_MATRIXI_COEF30_31;
		MATRIXI_COEF32_40 = VDIN0_HDR2_MATRIXI_COEF32_40;
		MATRIXI_COEF41_42 = VDIN0_HDR2_MATRIXI_COEF41_42;
		MATRIXI_OFFSET0_1 = VDIN0_HDR2_MATRIXI_OFFSET0_1;
		MATRIXI_OFFSET2 = VDIN0_HDR2_MATRIXI_OFFSET2;
		MATRIXI_PRE_OFFSET0_1 = VDIN0_HDR2_MATRIXI_PRE_OFFSET0_1;
		MATRIXI_PRE_OFFSET2 = VDIN0_HDR2_MATRIXI_PRE_OFFSET2;
		MATRIXI_CLIP = VDIN0_HDR2_MATRIXI_CLIP;
		MATRIXI_EN_CTRL = VDIN0_HDR2_MATRIXI_EN_CTRL;

		MATRIXO_COEF00_01 = VDIN0_HDR2_MATRIXO_COEF00_01;
		MATRIXO_COEF00_01 = VDIN0_HDR2_MATRIXO_COEF00_01;
		MATRIXO_COEF02_10 = VDIN0_HDR2_MATRIXO_COEF02_10;
		MATRIXO_COEF11_12 = VDIN0_HDR2_MATRIXO_COEF11_12;
		MATRIXO_COEF20_21 = VDIN0_HDR2_MATRIXO_COEF20_21;
		MATRIXO_COEF22 = VDIN0_HDR2_MATRIXO_COEF22;
		MATRIXO_COEF30_31 = VDIN0_HDR2_MATRIXO_COEF30_31;
		MATRIXO_COEF32_40 = VDIN0_HDR2_MATRIXO_COEF32_40;
		MATRIXO_COEF41_42 = VDIN0_HDR2_MATRIXO_COEF41_42;
		MATRIXO_OFFSET0_1 = VDIN0_HDR2_MATRIXO_OFFSET0_1;
		MATRIXO_OFFSET2 = VDIN0_HDR2_MATRIXO_OFFSET2;
		MATRIXO_PRE_OFFSET0_1 = VDIN0_HDR2_MATRIXO_PRE_OFFSET0_1;
		MATRIXO_PRE_OFFSET2 = VDIN0_HDR2_MATRIXO_PRE_OFFSET2;
		MATRIXO_CLIP = VDIN0_HDR2_MATRIXO_CLIP;
		MATRIXO_EN_CTRL = VDIN0_HDR2_MATRIXO_EN_CTRL;

		CGAIN_OFFT = VDIN0_HDR2_CGAIN_OFFT;
		CGAIN_COEF0 = VDIN0_HDR2_CGAIN_COEF0;
		CGAIN_COEF1 = VDIN0_HDR2_CGAIN_COEF1;
		ADPS_CTRL = VDIN0_HDR2_ADPS_CTRL;
		ADPS_ALPHA0 = VDIN0_HDR2_ADPS_ALPHA0;
		ADPS_ALPHA1 = VDIN0_HDR2_ADPS_ALPHA1;
		ADPS_BETA0 = VDIN0_HDR2_ADPS_BETA0;
		ADPS_BETA1 = VDIN0_HDR2_ADPS_BETA1;
		ADPS_BETA2 = VDIN0_HDR2_ADPS_BETA2;
		ADPS_COEF0 = VDIN0_HDR2_ADPS_COEF0;
		ADPS_COEF1 = VDIN0_HDR2_ADPS_COEF1;
		GMUT_CTRL = VDIN0_HDR2_GMUT_CTRL;
		GMUT_COEF0 = VDIN0_HDR2_GMUT_COEF0;
		GMUT_COEF1 = VDIN0_HDR2_GMUT_COEF1;
		GMUT_COEF2 = VDIN0_HDR2_GMUT_COEF2;
		GMUT_COEF3 = VDIN0_HDR2_GMUT_COEF3;
		GMUT_COEF4 = VDIN0_HDR2_GMUT_COEF4;

		hdr_ctrl = VDIN0_HDR2_CTRL;
		/* hdr_clk_gate = VDIN0_HDR2_CLK_GATE; */
	} else if (module_sel == VDIN1_HDR) {
		MATRIXI_COEF00_01 = VDIN1_HDR2_MATRIXI_COEF00_01;
		MATRIXI_COEF00_01 = VDIN1_HDR2_MATRIXI_COEF00_01;
		MATRIXI_COEF02_10 = VDIN1_HDR2_MATRIXI_COEF02_10;
		MATRIXI_COEF11_12 = VDIN1_HDR2_MATRIXI_COEF11_12;
		MATRIXI_COEF20_21 = VDIN1_HDR2_MATRIXI_COEF20_21;
		MATRIXI_COEF22 = VDIN1_HDR2_MATRIXI_COEF22;
		MATRIXI_COEF30_31 = VDIN1_HDR2_MATRIXI_COEF30_31;
		MATRIXI_COEF32_40 = VDIN1_HDR2_MATRIXI_COEF32_40;
		MATRIXI_COEF41_42 = VDIN1_HDR2_MATRIXI_COEF41_42;
		MATRIXI_OFFSET0_1 = VDIN1_HDR2_MATRIXI_OFFSET0_1;
		MATRIXI_OFFSET2 = VDIN1_HDR2_MATRIXI_OFFSET2;
		MATRIXI_PRE_OFFSET0_1 = VDIN1_HDR2_MATRIXI_PRE_OFFSET0_1;
		MATRIXI_PRE_OFFSET2 = VDIN1_HDR2_MATRIXI_PRE_OFFSET2;
		MATRIXI_CLIP = VDIN1_HDR2_MATRIXI_CLIP;
		MATRIXI_EN_CTRL = VDIN1_HDR2_MATRIXI_EN_CTRL;

		MATRIXO_COEF00_01 = VDIN1_HDR2_MATRIXO_COEF00_01;
		MATRIXO_COEF00_01 = VDIN1_HDR2_MATRIXO_COEF00_01;
		MATRIXO_COEF02_10 = VDIN1_HDR2_MATRIXO_COEF02_10;
		MATRIXO_COEF11_12 = VDIN1_HDR2_MATRIXO_COEF11_12;
		MATRIXO_COEF20_21 = VDIN1_HDR2_MATRIXO_COEF20_21;
		MATRIXO_COEF22 = VDIN1_HDR2_MATRIXO_COEF22;
		MATRIXO_COEF30_31 = VDIN1_HDR2_MATRIXO_COEF30_31;
		MATRIXO_COEF32_40 = VDIN1_HDR2_MATRIXO_COEF32_40;
		MATRIXO_COEF41_42 = VDIN1_HDR2_MATRIXO_COEF41_42;
		MATRIXO_OFFSET0_1 = VDIN1_HDR2_MATRIXO_OFFSET0_1;
		MATRIXO_OFFSET2 = VDIN1_HDR2_MATRIXO_OFFSET2;
		MATRIXO_PRE_OFFSET0_1 = VDIN1_HDR2_MATRIXO_PRE_OFFSET0_1;
		MATRIXO_PRE_OFFSET2 = VDIN1_HDR2_MATRIXO_PRE_OFFSET2;
		MATRIXO_CLIP = VDIN1_HDR2_MATRIXO_CLIP;
		MATRIXO_EN_CTRL = VDIN1_HDR2_MATRIXO_EN_CTRL;

		CGAIN_OFFT = VDIN1_HDR2_CGAIN_OFFT;
		CGAIN_COEF0 = VDIN1_HDR2_CGAIN_COEF0;
		CGAIN_COEF1 = VDIN1_HDR2_CGAIN_COEF1;
		ADPS_CTRL = VDIN1_HDR2_ADPS_CTRL;
		ADPS_ALPHA0 = VDIN1_HDR2_ADPS_ALPHA0;
		ADPS_ALPHA1 = VDIN1_HDR2_ADPS_ALPHA1;
		ADPS_BETA0 = VDIN1_HDR2_ADPS_BETA0;
		ADPS_BETA1 = VDIN1_HDR2_ADPS_BETA1;
		ADPS_BETA2 = VDIN1_HDR2_ADPS_BETA2;
		ADPS_COEF0 = VDIN1_HDR2_ADPS_COEF0;
		ADPS_COEF1 = VDIN1_HDR2_ADPS_COEF1;
		GMUT_CTRL = VDIN1_HDR2_GMUT_CTRL;
		GMUT_COEF0 = VDIN1_HDR2_GMUT_COEF0;
		GMUT_COEF1 = VDIN1_HDR2_GMUT_COEF1;
		GMUT_COEF2 = VDIN1_HDR2_GMUT_COEF2;
		GMUT_COEF3 = VDIN1_HDR2_GMUT_COEF3;
		GMUT_COEF4 = VDIN1_HDR2_GMUT_COEF4;

		hdr_ctrl = VDIN1_HDR2_CTRL;
		/* hdr_clk_gate = VDIN1_HDR2_CLK_GATE; */
	}

	if (hdr_mtx_param == NULL)
		return;

	/* need change clock gate as freerun when mtx on directly, not rdma op */
	/* Now only operate osd1/vd1/vd2 hdr core */
	if (get_cpu_type() <= MESON_CPU_MAJOR_ID_T5D) {
		if (hdr_clk_gate != 0) {
			cur_hdr_ctrl = VSYNC_READ_VPP_REG(hdr_ctrl);
			if (hdr_mtx_param->mtx_on && !(cur_hdr_ctrl & (1 << 13))) {
				WRITE_VPP_REG_BITS(hdr_clk_gate, 0xaaa, 0, 12);
				VSYNC_WRITE_VPP_REG_BITS(hdr_clk_gate, 0xaaa, 0, 12);
			}
		}
	}

	VSYNC_WRITE_VPP_REG_BITS(hdr_ctrl,
		 hdr_mtx_param->mtx_on, 13, 1);

	/* recover the clock gate as auto gate by rdma op when mtx off */
	/* Now only operate osd1/vd1/vd2 hdr core */
	if (get_cpu_type() <= MESON_CPU_MAJOR_ID_T5D) {
		if (hdr_clk_gate != 0 && !hdr_mtx_param->mtx_on)
			VSYNC_WRITE_VPP_REG_BITS(hdr_clk_gate, 0, 0, 12);
	}

	if (mtx_sel == HDR_IN_MTX) {
		for (i = 0; i < MTX_NUM_PARAM; i++)
			in_mtx[i] = hdr_mtx_param->mtx_in[i];

#ifdef HDR2_PRINT
		if (hdr2_debug & HDR_DBG_IN_MTX)
		pr_info("hdr: in_mtx %d %d = %x,%x %x %x %x %x,%x\n",
			hdr_mtx_param->mtx_on,
			hdr_mtx_param->mtx_only,
			(hdr_mtx_param->mtxi_pre_offset[0] << 16) |
			(hdr_mtx_param->mtxi_pre_offset[1] & 0xFFF),
			(in_mtx[0 * 3 + 0] << 16) |
			(in_mtx[0 * 3 + 1] & 0x1FFF),
			(in_mtx[0 * 3 + 2] << 16) |
			(in_mtx[1 * 3 + 0] & 0x1FFF),
			(in_mtx[1 * 3 + 1] << 16) |
			(in_mtx[1 * 3 + 2] & 0x1FFF),
			(in_mtx[2 * 3 + 0] << 16) |
			(in_mtx[2 * 3 + 1] & 0x1FFF),
			in_mtx[2 * 3 + 2],
			(hdr_mtx_param->mtxi_pos_offset[0] << 16) |
			(hdr_mtx_param->mtxi_pos_offset[1] & 0xFFF));
#endif
		if ((hdr_mtx_param->mtx_only == MTX_ONLY) &&
		    (!hdr_mtx_param->mtx_on))
			VSYNC_WRITE_VPP_REG(MATRIXI_EN_CTRL, 1);
		else
			VSYNC_WRITE_VPP_REG(MATRIXI_EN_CTRL,
					    hdr_mtx_param->mtx_on);
		VSYNC_WRITE_VPP_REG_BITS(hdr_ctrl,
					 hdr_mtx_param->mtx_on, 4, 1);
		VSYNC_WRITE_VPP_REG_BITS(hdr_ctrl,
					 hdr_mtx_param->mtx_only,
			16, 1);
		VSYNC_WRITE_VPP_REG_BITS(hdr_ctrl, 1, 14, 1);

		VSYNC_WRITE_VPP_REG(MATRIXI_COEF00_01,
				    (in_mtx[0 * 3 + 0] << 16) |
			(in_mtx[0 * 3 + 1] & 0x1FFF));
		VSYNC_WRITE_VPP_REG(MATRIXI_COEF02_10,
				    (in_mtx[0 * 3 + 2] << 16) |
			(in_mtx[1 * 3 + 0] & 0x1FFF));
		VSYNC_WRITE_VPP_REG(MATRIXI_COEF11_12,
				    (in_mtx[1 * 3 + 1] << 16) |
			(in_mtx[1 * 3 + 2] & 0x1FFF));
		VSYNC_WRITE_VPP_REG(MATRIXI_COEF20_21,
				    (in_mtx[2 * 3 + 0] << 16) |
			(in_mtx[2 * 3 + 1] & 0x1FFF));
		VSYNC_WRITE_VPP_REG(MATRIXI_COEF22,
				    in_mtx[2 * 3 + 2]);
		VSYNC_WRITE_VPP_REG(MATRIXI_OFFSET0_1,
				    (hdr_mtx_param->mtxi_pos_offset[0] << 16) |
			(hdr_mtx_param->mtxi_pos_offset[1] & 0xFFF));
		VSYNC_WRITE_VPP_REG(MATRIXI_OFFSET2,
				    hdr_mtx_param->mtxi_pos_offset[2]);
		VSYNC_WRITE_VPP_REG(MATRIXI_PRE_OFFSET0_1,
				    (hdr_mtx_param->mtxi_pre_offset[0] << 16) |
			(hdr_mtx_param->mtxi_pre_offset[1] & 0xFFF));
		VSYNC_WRITE_VPP_REG(MATRIXI_PRE_OFFSET2,
				    hdr_mtx_param->mtxi_pre_offset[2]);
	} else if (mtx_sel == HDR_GAMUT_MTX) {
		for (i = 0; i < 9; i++)
			gmut_coef[i / 3][i % 3] =
				hdr_mtx_param->mtx_gamut[i];
		if ((hdr_mtx_param->p_sel & HDR_SDR) ||
		    (hdr_mtx_param->p_sel & HDR10P_SDR) ||
		    (hdr_mtx_param->p_sel & HLG_SDR)) {
			if (hdr_mtx_param->gmt_bit_mode) {
				gmut_shift = 8;
				/*gamut shift bit for used for enable oo 33bit*/
				/*after tm2 revb fix 32bit bug*/
				gmut_shift |= 1 << 4;
			} else {
				/* use integer mode for gamut coeff */
				gmut_shift = 0;
			}
		} else
			/* 2048 as 1.0 for gamut coeff */
			gmut_shift = 11;

		for (i = 0; i < 3; i++)
			c_gain_lim_coef[i] =
				hdr_mtx_param->mtx_cgain[i] << 2;
		/* 0: adptive scaler mode(Ys); 1: max linear(RGB max) */
		/* 2: none linear Ys -- Do NOT use it */
		if (hdr_mtx_param->p_sel & HLG_HDR ||
		    hdr_mtx_param->p_sel & HLG_SDR ||
		    hdr_mtx_param->p_sel & HLG_IPT)
			adpscl_mode = 0;
		else
			adpscl_mode = 1;

		for (i = 0; i < 3; i++) {
			if (hdr_mtx_param->mtx_only == MTX_ONLY)
				adpscl_bypass[i] = 1;
			else
				adpscl_bypass[i] = 0;

			if (hdr_mtx_param->p_sel & HLG_HDR ||
			    hdr_mtx_param->p_sel & HLG_IPT)
				adpscl_alpha[i] = 1000 *
					(1 << adp_scal_y_shift) / 10000;
			else if ((hdr_mtx_param->p_sel & HDR_SDR) ||
				 (hdr_mtx_param->p_sel & HDR10P_SDR))
				adpscl_alpha[i] =
					(1 << adp_scal_y_shift);
			else
				adpscl_alpha[i] =
					(1 << adp_scal_y_shift);

			if (adpscl_mode == 1)
				adpscl_ys_coef[i] =
					1 << adp_scal_x_shift;
			else
				adpscl_ys_coef[i] =
					ys_coef[i] >> (10 - adp_scal_x_shift);


			adpscl_beta_s[i] = 0;
			adpscl_beta[i] = 0;
		}

		/*shift0 is for x coordinate*/
		/*shift1 is for scale multiple*/
		if (hdr_mtx_param->p_sel & HDR_SDR) {
			if (hdr_mtx_param->gmt_bit_mode) {
				adpscl_shift[0] = adp_scal_x_shift;
				adpscl_shift[1] = OO_NOR -
				_log2((1 << OO_NOR) / 64);
			} else {
			/*because input 1/2, shift0/shift1 need change*/
				adpscl_shift[0] = adp_scal_x_shift - 1;
				adpscl_shift[1] = OO_NOR -
				_log2((1 << OO_NOR) / oo_y_lut_hdr_sdr[148])
				- 1;
			}
		} else if (hdr_mtx_param->p_sel & HLG_SDR) {
			if (hdr_mtx_param->gmt_bit_mode) {
				adpscl_shift[0] = adp_scal_x_shift;
				adpscl_shift[1] = OO_NOR -
				_log2((1 << OO_NOR) / oo_y_lut_hlg_sdr[148]);
			} else {
				/*because input 1/2, shift0/shift1 need change*/
				adpscl_shift[0] = adp_scal_x_shift - 1;
				adpscl_shift[1] = OO_NOR -
				_log2((1 << OO_NOR) / oo_y_lut_hlg_sdr[148])
				- 1;
			}
		} else if (hdr_mtx_param->p_sel & HDR10P_SDR) {
			if (p_hdr10pgen_param)
				scale_shift = _log2((1 << OO_NOR) /
				p_hdr10pgen_param->gain[148]);
			else
				scale_shift =
				_log2((1 << OO_NOR) / oo_y_lut_hdr_sdr[148]);
			if (hdr_mtx_param->gmt_bit_mode) {
				adpscl_shift[0] = adp_scal_x_shift;
				adpscl_shift[1] = OO_NOR - scale_shift;
			} else {
				/*because input 1/2, shift0/shift1 need change*/
				adpscl_shift[0] = adp_scal_x_shift - 1;
				adpscl_shift[1] = OO_NOR - scale_shift - 1;
			}
			if (p_hdr10pgen_param) {
				adpscl_shift[0] -= p_hdr10pgen_param->shift;
				adpscl_shift[1] -= p_hdr10pgen_param->shift;
			}
		} else if (hdr_mtx_param->p_sel & HDR_HLG) {
			adpscl_shift[0] = adp_scal_x_shift;
			adpscl_shift[1] = OO_NOR -
			_log2((1 << OO_NOR) / oo_y_lut_hdr_hlg[148]);
		} else if (hdr_mtx_param->p_sel & SDR_GMT_CONVERT) {
			scale_shift =
			_log2((1 << OO_NOR) / oo_y_lut_bypass[148]);
			/*because input 1/2, shift0/shift1 need change*/
			adpscl_shift[0] = adp_scal_x_shift - 1;
			adpscl_shift[1] = OO_NOR - scale_shift - 1;
		} else {
			adpscl_shift[0] = adp_scal_x_shift;
			adpscl_shift[1] = OO_NOR;
		}

		/*shift2 is not used, set default*/
		adpscl_shift[2] = adp_scal_y_shift;

#ifdef HDR2_PRINT
		if (hdr2_debug & HDR_DBG_GAMUT_MTX) {
		pr_info("hdr: gamut_mtx %d mode %d shift %d = %x %x %x %x %x\n",
			hdr_mtx_param->mtx_on,
			hdr_mtx_param->mtx_gamut_mode,
			gmut_shift,
			(gmut_coef[0][1] & 0xffff) << 16 |
			(gmut_coef[0][0] & 0xffff),
			(gmut_coef[1][0] & 0xffff) << 16 |
			(gmut_coef[0][2] & 0xffff),
			(gmut_coef[1][2] & 0xffff) << 16 |
			(gmut_coef[1][1] & 0xffff),
			(gmut_coef[2][1] & 0xffff) << 16 |
			(gmut_coef[2][0] & 0xffff),
			gmut_coef[2][2] & 0xffff);
		pr_info("hdr: adpscl bypass %d, x_shift %d, y_shift %d\n",
			adpscl_bypass[0], adpscl_shift[0], adpscl_shift[1]);
		}
#endif

		/*gamut mode: 1->gamut before ootf*/
					/*2->gamut after ootf*/
					/*other->disable gamut*/
		VSYNC_WRITE_VPP_REG_BITS(hdr_ctrl,
					 hdr_mtx_param->mtx_gamut_mode, 6, 2);
		VSYNC_WRITE_VPP_REG(GMUT_CTRL, gmut_shift);
		VSYNC_WRITE_VPP_REG(GMUT_COEF0,
				    (gmut_coef[0][1] & 0xffff) << 16 |
				    (gmut_coef[0][0] & 0xffff));
		VSYNC_WRITE_VPP_REG(GMUT_COEF1,
				    (gmut_coef[1][0] & 0xffff) << 16 |
				    (gmut_coef[0][2] & 0xffff));
		VSYNC_WRITE_VPP_REG(GMUT_COEF2,
				    (gmut_coef[1][2] & 0xffff) << 16 |
				    (gmut_coef[1][1] & 0xffff));
		VSYNC_WRITE_VPP_REG(GMUT_COEF3,
				    (gmut_coef[2][1] & 0xffff) << 16 |
				    (gmut_coef[2][0] & 0xffff));
		VSYNC_WRITE_VPP_REG(GMUT_COEF4,
				    gmut_coef[2][2] & 0xffff);

		VSYNC_WRITE_VPP_REG(CGAIN_COEF0,
				    c_gain_lim_coef[1] << 16 |
				    c_gain_lim_coef[0]);
		VSYNC_WRITE_VPP_REG_BITS(CGAIN_COEF1,
					 c_gain_lim_coef[2],	0, 12);

		VSYNC_WRITE_VPP_REG(ADPS_CTRL,
				    adpscl_bypass[2] << 6 |
				    adpscl_bypass[1] << 5 |
				    adpscl_bypass[0] << 4 |
				    adpscl_mode);
		VSYNC_WRITE_VPP_REG(ADPS_ALPHA0,
				    adpscl_alpha[1] << 16 | adpscl_alpha[0]);
		VSYNC_WRITE_VPP_REG(ADPS_ALPHA1,
				    adpscl_shift[0] << 24 |
				    adpscl_shift[1] << 20 |
				    adpscl_shift[2] << 16 |
				    adpscl_alpha[2]);
		VSYNC_WRITE_VPP_REG(ADPS_BETA0,
				    adpscl_beta_s[0] << 20 | adpscl_beta[0]);
		VSYNC_WRITE_VPP_REG(ADPS_BETA1,
				    adpscl_beta_s[1] << 20 | adpscl_beta[1]);
		VSYNC_WRITE_VPP_REG(ADPS_BETA2,
				    adpscl_beta_s[2] << 20 | adpscl_beta[2]);
		VSYNC_WRITE_VPP_REG(ADPS_COEF0,
				    adpscl_ys_coef[1] << 16 |
				    adpscl_ys_coef[0]);
		VSYNC_WRITE_VPP_REG(ADPS_COEF1,
				    adpscl_ys_coef[2]);
	} else if (mtx_sel == HDR_OUT_MTX) {
		for (i = 0; i < MTX_NUM_PARAM; i++)
			out_mtx[i] = hdr_mtx_param->mtx_out[i];
#ifdef HDR2_PRINT
		if (hdr2_debug & HDR_DBG_OUT_MTX)
		pr_info("hdr: out_mtx %d %d = %x,%x %x %x %x %x,%x\n",
			hdr_mtx_param->mtx_on,
			hdr_mtx_param->mtx_only,
			(hdr_mtx_param->mtxo_pre_offset[0] << 16) |
			(hdr_mtx_param->mtxo_pre_offset[1] & 0xFFF),
			(out_mtx[0 * 3 + 0] << 16) |
			(out_mtx[0 * 3 + 1] & 0x1FFF),
			(out_mtx[0 * 3 + 2] << 16) |
			(out_mtx[1 * 3 + 0] & 0x1FFF),
			(out_mtx[1 * 3 + 1] << 16) |
			(out_mtx[1 * 3 + 2] & 0x1FFF),
			(out_mtx[2 * 3 + 0] << 16) |
			(out_mtx[2 * 3 + 1] & 0x1FFF),
			out_mtx[2 * 3 + 2],
			(hdr_mtx_param->mtxo_pos_offset[0] << 16) |
			(hdr_mtx_param->mtxo_pos_offset[1] & 0xFFF));
#endif
		VSYNC_WRITE_VPP_REG(CGAIN_OFFT,
				    (rgb2yuvpos[2] << 16) | rgb2yuvpos[1]);
		VSYNC_WRITE_VPP_REG(MATRIXO_EN_CTRL,
				    hdr_mtx_param->mtx_on);
		VSYNC_WRITE_VPP_REG_BITS(hdr_ctrl, 0, 17, 1);
		VSYNC_WRITE_VPP_REG_BITS(hdr_ctrl, 1, 15, 1);

		VSYNC_WRITE_VPP_REG(MATRIXO_COEF00_01,
				    (out_mtx[0 * 3 + 0] << 16) |
				    (out_mtx[0 * 3 + 1] & 0x1FFF));
		VSYNC_WRITE_VPP_REG(MATRIXO_COEF02_10,
				    (out_mtx[0 * 3 + 2] << 16) |
				    (out_mtx[1 * 3 + 0] & 0x1FFF));
		VSYNC_WRITE_VPP_REG(MATRIXO_COEF11_12,
				    (out_mtx[1 * 3 + 1] << 16) |
				    (out_mtx[1 * 3 + 2] & 0x1FFF));
		VSYNC_WRITE_VPP_REG(MATRIXO_COEF20_21,
				    (out_mtx[2 * 3 + 0] << 16) |
				    (out_mtx[2 * 3 + 1] & 0x1FFF));
		VSYNC_WRITE_VPP_REG(MATRIXO_COEF22,
				    out_mtx[2 * 3 + 2]);

		VSYNC_WRITE_VPP_REG(MATRIXO_OFFSET0_1,
				    (hdr_mtx_param->mtxo_pos_offset[0] << 16) |
				    (hdr_mtx_param->mtxo_pos_offset[1] & 0xFFF));
		VSYNC_WRITE_VPP_REG(MATRIXO_OFFSET2,
				    hdr_mtx_param->mtxo_pos_offset[2]);
		VSYNC_WRITE_VPP_REG(MATRIXO_PRE_OFFSET0_1,
				    (hdr_mtx_param->mtxo_pre_offset[0] << 16) |
				    (hdr_mtx_param->mtxo_pre_offset[1] & 0xFFF));
		VSYNC_WRITE_VPP_REG(MATRIXO_PRE_OFFSET2,
				    hdr_mtx_param->mtxo_pre_offset[2]);
	}
}

void set_eotf_lut(
	enum hdr_module_sel module_sel,
	struct hdr_proc_lut_param_s *hdr_lut_param)
{
	unsigned int lut[HDR2_EOTF_LUT_SIZE];
	unsigned int eotf_lut_addr_port = 0;
	unsigned int eotf_lut_data_port = 0;
	unsigned int hdr_ctrl = 0;
	unsigned int i = 0;

	if (module_sel == VD1_HDR) {
		eotf_lut_addr_port = VD1_EOTF_LUT_ADDR_PORT;
		eotf_lut_data_port = VD1_EOTF_LUT_DATA_PORT;
		hdr_ctrl = VD1_HDR2_CTRL;
	} else if (module_sel == VD2_HDR) {
		eotf_lut_addr_port = VD2_EOTF_LUT_ADDR_PORT;
		eotf_lut_data_port = VD2_EOTF_LUT_DATA_PORT;
		hdr_ctrl = VD2_HDR2_CTRL;
	} else if (module_sel == OSD1_HDR) {
		eotf_lut_addr_port = OSD1_EOTF_LUT_ADDR_PORT;
		eotf_lut_data_port = OSD1_EOTF_LUT_DATA_PORT;
		hdr_ctrl = OSD1_HDR2_CTRL;
	} else if (module_sel == DI_HDR) {
		eotf_lut_addr_port = DI_EOTF_LUT_ADDR_PORT;
		eotf_lut_data_port = DI_EOTF_LUT_DATA_PORT;
		hdr_ctrl = DI_HDR2_CTRL;
	} else if (module_sel == VDIN0_HDR) {
		eotf_lut_addr_port = VDIN0_EOTF_LUT_ADDR_PORT;
		eotf_lut_data_port = VDIN0_EOTF_LUT_DATA_PORT;
		hdr_ctrl = VDIN0_HDR2_CTRL;
	} else if (module_sel == VDIN1_HDR) {
		eotf_lut_addr_port = VDIN1_EOTF_LUT_ADDR_PORT;
		eotf_lut_data_port = VDIN1_EOTF_LUT_DATA_PORT;
		hdr_ctrl = VDIN1_HDR2_CTRL;
	}

	for (i = 0; i < HDR2_EOTF_LUT_SIZE; i++)
		lut[i] = hdr_lut_param->eotf_lut[i];

	VSYNC_WRITE_VPP_REG_BITS(hdr_ctrl, hdr_lut_param->lut_on, 3, 1);

	if (!hdr_lut_param->lut_on)
		return;

	VSYNC_WRITE_VPP_REG(eotf_lut_addr_port, 0x0);
	for (i = 0; i < HDR2_EOTF_LUT_SIZE; i++)
		VSYNC_WRITE_VPP_REG(eotf_lut_data_port, lut[i]);
}

void set_ootf_lut(
	enum hdr_module_sel module_sel,
	struct hdr_proc_lut_param_s *hdr_lut_param)
{
	unsigned int lut[HDR2_OOTF_LUT_SIZE];
	unsigned int ootf_lut_addr_port = 0;
	unsigned int ootf_lut_data_port = 0;
	unsigned int hdr_ctrl = 0;
	unsigned int i = 0;

	if (module_sel == VD1_HDR) {
		ootf_lut_addr_port = VD1_OGAIN_LUT_ADDR_PORT;
		ootf_lut_data_port = VD1_OGAIN_LUT_DATA_PORT;
		hdr_ctrl = VD1_HDR2_CTRL;
	} else if (module_sel == VD2_HDR) {
		ootf_lut_addr_port = VD2_OGAIN_LUT_ADDR_PORT;
		ootf_lut_data_port = VD2_OGAIN_LUT_DATA_PORT;
		hdr_ctrl = VD2_HDR2_CTRL;
	} else if (module_sel == OSD1_HDR) {
		ootf_lut_addr_port = OSD1_OGAIN_LUT_ADDR_PORT;
		ootf_lut_data_port = OSD1_OGAIN_LUT_DATA_PORT;
		hdr_ctrl = OSD1_HDR2_CTRL;
	} else if (module_sel == DI_HDR) {
		ootf_lut_addr_port = DI_OGAIN_LUT_ADDR_PORT;
		ootf_lut_data_port = DI_OGAIN_LUT_DATA_PORT;
		hdr_ctrl = DI_HDR2_CTRL;
	} else if (module_sel == VDIN0_HDR) {
		ootf_lut_addr_port = VDIN0_OGAIN_LUT_ADDR_PORT;
		ootf_lut_data_port = VDIN0_OGAIN_LUT_DATA_PORT;
		hdr_ctrl = VDIN0_HDR2_CTRL;
	} else if (module_sel == VDIN1_HDR) {
		ootf_lut_addr_port = VDIN1_OGAIN_LUT_ADDR_PORT;
		ootf_lut_data_port = VDIN1_OGAIN_LUT_DATA_PORT;
		hdr_ctrl = VDIN1_HDR2_CTRL;
	}

	for (i = 0; i < HDR2_OOTF_LUT_SIZE; i++)
		lut[i] = hdr_lut_param->ogain_lut[i];

	VSYNC_WRITE_VPP_REG_BITS(hdr_ctrl, hdr_lut_param->lut_on, 1, 1);

	if (!hdr_lut_param->lut_on)
		return;

	VSYNC_WRITE_VPP_REG(ootf_lut_addr_port, 0x0);
	for (i = 0; i < HDR2_OOTF_LUT_SIZE / 2; i++)
		VSYNC_WRITE_VPP_REG(ootf_lut_data_port,
				    (lut[i * 2 + 1] << 16) +
			lut[i * 2]);
	VSYNC_WRITE_VPP_REG(ootf_lut_data_port, lut[148]);
}

void set_oetf_lut(
	enum hdr_module_sel module_sel,
	struct hdr_proc_lut_param_s *hdr_lut_param)
{
	unsigned int lut[HDR2_OETF_LUT_SIZE];
	unsigned int oetf_lut_addr_port = 0;
	unsigned int oetf_lut_data_port = 0;
	unsigned int hdr_ctrl = 0;
	unsigned int i = 0;

	if (module_sel == VD1_HDR) {
		oetf_lut_addr_port = VD1_OETF_LUT_ADDR_PORT;
		oetf_lut_data_port = VD1_OETF_LUT_DATA_PORT;
		hdr_ctrl = VD1_HDR2_CTRL;
	} else if (module_sel == VD2_HDR) {
		oetf_lut_addr_port = VD2_OETF_LUT_ADDR_PORT;
		oetf_lut_data_port = VD2_OETF_LUT_DATA_PORT;
		hdr_ctrl = VD2_HDR2_CTRL;
	} else if (module_sel == OSD1_HDR) {
		oetf_lut_addr_port = OSD1_OETF_LUT_ADDR_PORT;
		oetf_lut_data_port = OSD1_OETF_LUT_DATA_PORT;
		hdr_ctrl = OSD1_HDR2_CTRL;
	} else if (module_sel == DI_HDR) {
		oetf_lut_addr_port = DI_OETF_LUT_ADDR_PORT;
		oetf_lut_data_port = DI_OETF_LUT_DATA_PORT;
		hdr_ctrl = DI_HDR2_CTRL;
	} else if (module_sel == VDIN0_HDR) {
		oetf_lut_addr_port = VDIN0_OETF_LUT_ADDR_PORT;
		oetf_lut_data_port = VDIN0_OETF_LUT_DATA_PORT;
		hdr_ctrl = VDIN0_HDR2_CTRL;
	} else if (module_sel == VDIN1_HDR) {
		oetf_lut_addr_port = VDIN1_OETF_LUT_ADDR_PORT;
		oetf_lut_data_port = VDIN1_OETF_LUT_DATA_PORT;
		hdr_ctrl = VDIN1_HDR2_CTRL;
	}

	for (i = 0; i < HDR2_OETF_LUT_SIZE; i++)
		lut[i] = hdr_lut_param->oetf_lut[i];

	VSYNC_WRITE_VPP_REG_BITS(hdr_ctrl, hdr_lut_param->lut_on, 2, 1);

	if (!hdr_lut_param->lut_on)
		return;

	VSYNC_WRITE_VPP_REG(oetf_lut_addr_port, 0x0);
	for (i = 0; i < HDR2_OETF_LUT_SIZE / 2; i++) {
		if (hdr_lut_param->bitdepth == 10)
			VSYNC_WRITE_VPP_REG(oetf_lut_data_port,
					    ((lut[i * 2 + 1] >> 2) << 16) +
				(lut[i * 2] >> 2));
		else
			VSYNC_WRITE_VPP_REG(oetf_lut_data_port,
					    (lut[i * 2 + 1] << 16) +
				lut[i * 2]);
	}
	if (hdr_lut_param->bitdepth == 10)
		VSYNC_WRITE_VPP_REG(oetf_lut_data_port, lut[148] >> 2);
	else
		VSYNC_WRITE_VPP_REG(oetf_lut_data_port, lut[148]);
}

void set_c_gain(
	enum hdr_module_sel module_sel,
	struct hdr_proc_lut_param_s *hdr_lut_param)
{
	unsigned int lut[HDR2_CGAIN_LUT_SIZE];
	unsigned int cgain_lut_addr_port = 0;
	unsigned int cgain_lut_data_port = 0;
	unsigned int hdr_ctrl = 0;
	unsigned int cgain_coef1 = 0;
	unsigned int i = 0;

	if (module_sel == VD1_HDR) {
		cgain_lut_addr_port = VD1_CGAIN_LUT_ADDR_PORT;
		cgain_lut_data_port = VD1_CGAIN_LUT_DATA_PORT;
		hdr_ctrl = VD1_HDR2_CTRL;
		cgain_coef1 = VD1_HDR2_CGAIN_COEF1;
	} else if (module_sel == VD2_HDR) {
		cgain_lut_addr_port = VD2_CGAIN_LUT_ADDR_PORT;
		cgain_lut_data_port = VD2_CGAIN_LUT_DATA_PORT;
		hdr_ctrl = VD2_HDR2_CTRL;
		cgain_coef1 = VD2_HDR2_CGAIN_COEF1;
	} else if (module_sel == OSD1_HDR) {
		cgain_lut_addr_port = OSD1_CGAIN_LUT_ADDR_PORT;
		cgain_lut_data_port = OSD1_CGAIN_LUT_DATA_PORT;
		hdr_ctrl = OSD1_HDR2_CTRL;
		cgain_coef1 = OSD1_HDR2_CGAIN_COEF1;
	} else if (module_sel == DI_HDR) {
		cgain_lut_addr_port = DI_CGAIN_LUT_ADDR_PORT;
		cgain_lut_data_port = DI_CGAIN_LUT_DATA_PORT;
		hdr_ctrl = DI_HDR2_CTRL;
		cgain_coef1 = DI_HDR2_CGAIN_COEF1;
	} else if (module_sel == VDIN0_HDR) {
		cgain_lut_addr_port = VDIN0_CGAIN_LUT_ADDR_PORT;
		cgain_lut_data_port = VDIN0_CGAIN_LUT_DATA_PORT;
		hdr_ctrl = VDIN0_HDR2_CTRL;
		cgain_coef1 = VDIN0_HDR2_CGAIN_COEF1;
	} else if (module_sel == VDIN1_HDR) {
		cgain_lut_addr_port = VDIN1_CGAIN_LUT_ADDR_PORT;
		cgain_lut_data_port = VDIN1_CGAIN_LUT_DATA_PORT;
		hdr_ctrl = VDIN1_HDR2_CTRL;
		cgain_coef1 = VDIN1_HDR2_CGAIN_COEF1;
	}

	for (i = 0; i < HDR2_CGAIN_LUT_SIZE; i++)
		lut[i] = hdr_lut_param->cgain_lut[i];

	/*cgain mode: 0->y domin*/
	/*cgain mode: 1->rgb domin, use r/g/b max*/
	VSYNC_WRITE_VPP_REG_BITS(hdr_ctrl,
				 0, 12, 1);
	VSYNC_WRITE_VPP_REG_BITS(hdr_ctrl,
				 hdr_lut_param->cgain_en, 0, 1);

	if (cpu_after_eq(MESON_CPU_MAJOR_ID_SM1)) {
		if (hdr_lut_param->bitdepth == 10)
			VSYNC_WRITE_VPP_REG_BITS(cgain_coef1,
						 0x400, 16, 13);
		else if (hdr_lut_param->bitdepth == 12)
			VSYNC_WRITE_VPP_REG_BITS(cgain_coef1,
						 0x1000, 16, 13);
	}

	if (!hdr_lut_param->cgain_en)
		return;

	VSYNC_WRITE_VPP_REG(cgain_lut_addr_port, 0x0);
	for (i = 0; i < HDR2_CGAIN_LUT_SIZE / 2; i++)
		VSYNC_WRITE_VPP_REG(cgain_lut_data_port,
				    (lut[i * 2 + 1] << 16) + lut[i * 2]);
	VSYNC_WRITE_VPP_REG(cgain_lut_data_port, lut[64]);
}

u32 hdr_hist[NUM_HDR_HIST][128];
static u32 hdr_max_rgb;
static u8 percentile_percent[9] = {
	1, 5, 10, 25, 50, 75, 90, 95, 99
};

u32 percentile[9];

u32 hist_maxrgb_luminance[128] = {
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1, 1, 1, 1,
	1, 2, 2, 2, 3, 3, 4, 4,
	5, 5, 6, 7, 7, 8, 9, 10, 11,
	12, 14, 15, 17, 18, 20, 22, 24,
	26, 29, 31, 34, 37, 41, 44, 48,
	52, 57, 62, 67, 72, 78, 85, 92,
	99, 107, 116, 125, 135, 146, 158, 170,
	183, 198, 213, 229, 247, 266, 287, 308,
	332, 357, 384, 413, 445, 478, 514, 553, 594,
	639, 686, 737, 792, 851, 915, 983, 1056, 1134,
	1219, 1309, 1406, 1511, 1623, 1744, 1873, 2012,
	2162, 2323, 2496, 2683, 2883, 3098, 3330, 3580,
	3849, 4138, 4450, 4786, 5148, 5539, 5959, 6413,
	6903, 7431, 8001, 8616, 9281, 10000
};

void set_hist(
	enum hdr_module_sel module_sel, int enable,
	enum hdr_hist_sel hist_sel,
	unsigned int hist_width, unsigned int hist_height)
{
	unsigned int hist_ctrl_port = 0;

	if (module_sel == VD1_HDR)
		hist_ctrl_port = VD1_HDR2_HIST_CTRL;
	else
		return;

	if (enable) {
		WRITE_VPP_REG(hist_ctrl_port + 1, hist_width - 1);
		WRITE_VPP_REG(hist_ctrl_port + 2, hist_height - 1);
		WRITE_VPP_REG(
			hist_ctrl_port,
			(1 << 4) | (hist_sel << 0));
	} else if (READ_VPP_REG_BITS(hist_ctrl_port, 4, 1)) {
		WRITE_VPP_REG_BITS(hist_ctrl_port, 0, 4, 1);
		hdr_max_rgb = 0;
	}
}

void get_hist(enum vd_path_e vd_path, enum hdr_hist_sel hist_sel)
{
	unsigned int hist_ctrl_port = 0;
	unsigned int hist_height, hist_width, i;
	u32 num_pixel, total_pixel;
	int j;
	int k = 0;
	enum hdr_module_sel module_sel = VD1_HDR;
	unsigned int hdr2_hist_rd;

	if (vd_path == VD1_PATH)
		module_sel = VD1_HDR;
	else
		module_sel = VD2_HDR;

	if (module_sel == VD1_HDR) {
		hist_ctrl_port = VD1_HDR2_HIST_CTRL;
		if (cpu_after_eq(MESON_CPU_MAJOR_ID_TM2))
			hdr2_hist_rd = VD1_HDR2_HIST_RD_2;
		else
			hdr2_hist_rd = VD1_HDR2_HIST_CTRL + 3;
	} else {
		hist_ctrl_port = VD2_HDR2_HIST_CTRL;
		if (cpu_after_eq(MESON_CPU_MAJOR_ID_TM2))
			hdr2_hist_rd = VD2_HDR2_HIST_RD_2;
		else
			hdr2_hist_rd = VD2_HDR2_HIST_CTRL + 3;
	}

	if ((get_cpu_type() < MESON_CPU_MAJOR_ID_G12A) ||
	    (get_cpu_type() == MESON_CPU_MAJOR_ID_SC2))
		return;

	/*no vd2 in TL1*/
	if ((get_cpu_type() == MESON_CPU_MAJOR_ID_TL1) &&
	   (module_sel == VD2_HDR))
		return;

	if (((get_cpu_type() == MESON_CPU_MAJOR_ID_T5) ||
		(is_meson_t5d_cpu())) &&
	    (module_sel == VD2_HDR))
		return;

	if (module_sel == VD1_HDR) {
		hist_width = READ_VPP_REG_BITS(VPP_PREBLEND_H_SIZE, 0, 13);
		hist_height = READ_VPP_REG_BITS(VPP_PREBLEND_H_SIZE, 16, 13);
	} else if (module_sel == VD2_HDR) {
		hist_width = READ_VPP_REG_BITS(VPP_VD2_HDR_IN_SIZE, 0, 13);
		hist_height = READ_VPP_REG_BITS(VPP_VD2_HDR_IN_SIZE, 16, 13);
	}

	if (!hist_width || !hist_height)
		return;

	if ((hist_height != READ_VPP_REG(hist_ctrl_port + 2) + 1) ||
	    (hist_width != READ_VPP_REG(hist_ctrl_port + 1) + 1) ||
	    /*(READ_VPP_REG_BITS(hist_ctrl_port, 4, 1) == 0) ||*/
	    (READ_VPP_REG_BITS(hist_ctrl_port, 0, 3) != hist_sel)) {
		set_hist(module_sel, 1, hist_sel, hist_width, hist_height);
		return;
	}

	for (i = 0; i < NUM_HDR_HIST - 1; i++)
		memcpy(hdr_hist[i], hdr_hist[i + 1], 128 * sizeof(uint32_t));
	memset(percentile, 0, 9 * sizeof(uint32_t));
	total_pixel = 0;
	for (i = 0; i < 128; i++) {
		WRITE_VPP_REG_BITS(hist_ctrl_port, i, 16, 8);
		num_pixel = READ_VPP_REG(hdr2_hist_rd);
		total_pixel += num_pixel;
		hdr_hist[NUM_HDR_HIST - 1][i] = num_pixel;
	}
	num_pixel = 0;

	if (total_pixel) {
		for (i = 0; i < 128; i++) {
			num_pixel += hdr_hist[NUM_HDR_HIST - 1][i];
			for (j = 8; j >= k; j--) {
				if (num_pixel * 100 / total_pixel >=
					percentile_percent[j]) {
					percentile[j] =
					hist_maxrgb_luminance[i];
					k = j + 1;
					if (k > 8)
						k = 8;
					break;
				}
			}
			if (hdr_hist[NUM_HDR_HIST - 1][i])
				hdr_max_rgb =
					(i + 1) * 10000 / 128;
			if (percentile[8] != 0)
				break;
		}
		if (percentile[0] == 0)
			percentile[0] = 1;
		for (i = 1; i < 9; i++) {
			if (percentile[i] == 0)
				percentile[i] = percentile[i - 1] + 1;
		}
		percentile[1] = percentile[8];
	}

#ifdef HDR2_PRINT
	if (hdr2_debug & HDR_DBG_HIST)
	if (total_pixel) {
		for (i = 0; i < 16; i++) {
			pr_info("hist[%d..]=%d %d %d %d %d %d %d %d\n",
				i * 8,
				hdr_hist[NUM_HDR_HIST - 1][i * 8],
				hdr_hist[NUM_HDR_HIST - 1][i * 8 + 1],
				hdr_hist[NUM_HDR_HIST - 1][i * 8 + 2],
				hdr_hist[NUM_HDR_HIST - 1][i * 8 + 3],
				hdr_hist[NUM_HDR_HIST - 1][i * 8 + 4],
				hdr_hist[NUM_HDR_HIST - 1][i * 8 + 5],
				hdr_hist[NUM_HDR_HIST - 1][i * 8 + 6],
				hdr_hist[NUM_HDR_HIST - 1][i * 8 + 7]);
			pr_info("max=%d percentile=%d %d %d %d %d %d %d %d %d\n",
				hdr_max_rgb,
				percentile[0], percentile[1], percentile[2],
				percentile[3], percentile[4], percentile[5],
				percentile[6], percentile[7], percentile[8]);
		}
	}
#endif
}

void hdr_hist_config(
	enum hdr_module_sel module_sel,
	struct hdr_proc_lut_param_s *hdr_lut_param)
{
	unsigned int hist_ctrl;
	unsigned int hist_hs_he;
	unsigned int hist_vs_ve;

	if (module_sel == VD1_HDR) {
		hist_ctrl = VD1_HDR2_HIST_CTRL;
		hist_hs_he = VD1_HDR2_HIST_H_START_END;
		hist_vs_ve = VD1_HDR2_HIST_V_START_END;
	} else if (module_sel == VD2_HDR) {
		hist_ctrl = VD2_HDR2_HIST_CTRL;
		hist_hs_he = VD2_HDR2_HIST_H_START_END;
		hist_vs_ve = VD2_HDR2_HIST_V_START_END;
	} else if (module_sel == OSD1_HDR) {
		hist_ctrl = OSD1_HDR2_HIST_CTRL;
		hist_hs_he = OSD1_HDR2_HIST_H_START_END;
		hist_vs_ve = OSD1_HDR2_HIST_V_START_END;
	} else if (module_sel == DI_HDR) {
		hist_ctrl = DI_HDR2_HIST_CTRL;
		hist_hs_he = DI_HDR2_HIST_H_START_END;
		hist_vs_ve = DI_HDR2_HIST_V_START_END;
	} else {
		return;
	}

	if (get_cpu_type() < MESON_CPU_MAJOR_ID_TM2)
		return;

	if (hdr_lut_param->hist_en) {
		VSYNC_WRITE_VPP_REG(hist_ctrl, 0);
		VSYNC_WRITE_VPP_REG(hist_hs_he, 0xeff);
		VSYNC_WRITE_VPP_REG(hist_vs_ve, 0x86f);
	} else {
		VSYNC_WRITE_VPP_REG(hist_ctrl, 0x5510);
		VSYNC_WRITE_VPP_REG(hist_hs_he, 0x10000);
		VSYNC_WRITE_VPP_REG(hist_vs_ve, 0x0);
	}
}

struct hdr_proc_lut_param_s hdr_lut_param;

enum hdr_process_sel hdr_func(
	enum hdr_module_sel module_sel,
	u32 hdr_process_select,
	struct vinfo_s *vinfo,
	struct matrix_s *gmt_mtx)
{
	int bit_depth;
	unsigned int i = 0, j = 0;
	struct hdr_proc_mtx_param_s hdr_mtx_param;
#ifdef CONFIG_AMLOGIC_MEDIA_ENHANCEMENT_DOLBYVISION
	int output_mode;
#endif
	bool mtx_only_mode = false;
	bool eo_gmt_bit_mode = false;
	int *coeff_in = bypass_coeff;
	int *coeff_out = bypass_coeff;
	int *oft_pre_in = bypass_pre;
	int *oft_post_in = bypass_pos;
	int *oft_pre_out = bypass_pre;
	int *oft_post_out = bypass_pos;
	bool always_full_func = false;

	pr_csc(16, "hdr func: hdr module=%d, select=%x\n",
			module_sel,
			hdr_process_select);

	memset(&hdr_mtx_param, 0, sizeof(struct hdr_proc_mtx_param_s));
	memset(&hdr_lut_param, 0, sizeof(struct hdr_proc_lut_param_s));

	if ((module_sel == OSD1_HDR) &&
	    (cpu_after_eq(MESON_CPU_MAJOR_ID_G12A))) {
		/* turn off OSD mtx and use HDR for g12, sm1, tl1 */
		VSYNC_WRITE_VPP_REG(
			VPP_WRAP_OSD1_MATRIX_EN_CTRL, 0);
		if (!is_dolby_vision_on() || is_hdr_tvmode())
			hdr_process_select |= RGB_OSD;
		/*for g12a/g12b osd blend shift rtl bug*/
		if (is_meson_g12a_cpu() ||
		    (is_meson_g12b_cpu() && is_meson_rev_a()))
			always_full_func = true;
	}

	if (cpu_after_eq(MESON_CPU_MAJOR_ID_TM2)) {
		if (is_meson_rev_a() && is_meson_tm2_cpu())
			eo_gmt_bit_mode = false;
		else
			eo_gmt_bit_mode = true;
	}

	if (module_sel == VD1_HDR ||
		module_sel == VD2_HDR ||
		module_sel == OSD1_HDR)
		bit_depth = 12;
	else if (module_sel == VDIN0_HDR
		|| module_sel == VDIN1_HDR
		|| module_sel == DI_HDR)
		bit_depth = 10;
	else
		return hdr_process_select;

	if (is_meson_tl1_cpu())
		bit_depth = 10;

	if (get_cpu_type() == MESON_CPU_MAJOR_ID_T5 ||
		is_meson_t5d_cpu())
		bit_depth = 10;

	/*lut parameters*/
	if (hdr_process_select & IPT_MAP) {
		mtx_only_mode = true;
		for (i = 0; i < HDR2_OETF_LUT_SIZE; i++) {
			hdr_lut_param.oetf_lut[i] =	oe_y_lut_bypass[i];
			hdr_lut_param.ogain_lut[i] = oo_y_lut_bypass[i];
			if (i < HDR2_EOTF_LUT_SIZE)
				hdr_lut_param.eotf_lut[i] =
					eo_y_lut_bypass[i];
			if (i < HDR2_CGAIN_LUT_SIZE)
				hdr_lut_param.cgain_lut[i] =
					cgain_lut_bypass[i] - 1;
		}
		hdr_lut_param.bitdepth = bit_depth;
		hdr_lut_param.lut_on = LUT_OFF;
		hdr_lut_param.cgain_en = LUT_OFF;
		hdr_lut_param.hist_en = LUT_OFF;
	} else if (hdr_process_select & HDR_BYPASS ||
		   hdr_process_select & HLG_BYPASS) {
		for (i = 0; i < HDR2_OETF_LUT_SIZE; i++) {
			hdr_lut_param.oetf_lut[i] =	oe_y_lut_bypass[i];
			hdr_lut_param.ogain_lut[i] = oo_y_lut_bypass[i];
			if (i < HDR2_EOTF_LUT_SIZE)
				hdr_lut_param.eotf_lut[i] =
					eo_y_lut_bypass[i];
			if (i < HDR2_CGAIN_LUT_SIZE)
				hdr_lut_param.cgain_lut[i] =
					cgain_lut_bypass[i] - 1;
		}

		if (always_full_func) {
			hdr_lut_param.lut_on = LUT_ON;
			hdr_lut_param.cgain_en = LUT_ON;
		} else {
			hdr_lut_param.lut_on = LUT_OFF;
			hdr_lut_param.cgain_en = LUT_OFF;
		}
		hdr_lut_param.bitdepth = bit_depth;
	} else if (hdr_process_select & HDR_SDR ||
		hdr_process_select & HDR10P_SDR) {
		for (i = 0; i < HDR2_OETF_LUT_SIZE; i++) {
			hdr_lut_param.oetf_lut[i]  = oe_y_lut_sdr[i];
			hdr_lut_param.ogain_lut[i] = oo_y_lut_hdr_sdr[i];
			if (i < HDR2_EOTF_LUT_SIZE) {
				if (eo_gmt_bit_mode)
					hdr_lut_param.eotf_lut[i] =
					eo_y_lut_pq[i];
				else
					hdr_lut_param.eotf_lut[i] =
					eo_y_lut_hdr[i];
			}
			if (i < HDR2_CGAIN_LUT_SIZE)
				hdr_lut_param.cgain_lut[i] = cgain_lut1[i] - 1;
		}
		hdr_lut_param.lut_on = LUT_ON;
		hdr_lut_param.bitdepth = bit_depth;
		hdr_lut_param.cgain_en = LUT_OFF;
		hdr_lut_param.hist_en = LUT_ON;
	} else if (hdr_process_select & SDR_HDR) {
		for (i = 0; i < HDR2_OETF_LUT_SIZE; i++) {
			hdr_lut_param.oetf_lut[i]  = oe_y_lut_hdr[i];
			hdr_lut_param.ogain_lut[i] = oo_y_lut_sdr_hdr[i];
			if (i < HDR2_EOTF_LUT_SIZE)
				hdr_lut_param.eotf_lut[i] = eo_y_lut_sdr[i];
			if (i < HDR2_CGAIN_LUT_SIZE)
				hdr_lut_param.cgain_lut[i] =
					cgain_lut_bypass[i] - 1;
		}
		hdr_lut_param.lut_on = LUT_ON;
		hdr_lut_param.bitdepth = bit_depth;
		hdr_lut_param.cgain_en = LUT_ON;
		hdr_lut_param.hist_en = LUT_OFF;
	} else if (hdr_process_select & HLG_SDR) {
		for (i = 0; i < HDR2_OETF_LUT_SIZE; i++) {
			hdr_lut_param.oetf_lut[i]  = oe_y_lut_sdr[i];
			hdr_lut_param.ogain_lut[i] = oo_y_lut_hlg_sdr[i];
			if (i < HDR2_EOTF_LUT_SIZE) {
				if (eo_gmt_bit_mode)
					hdr_lut_param.eotf_lut[i] =
					eo_y_lut_hlg[i];
				else
					hdr_lut_param.eotf_lut[i] =
					eo_y_lut_hlg_23[i];
			}
			if (i < HDR2_CGAIN_LUT_SIZE)
				hdr_lut_param.cgain_lut[i] = cgain_lut1[i] - 1;
		}
		hdr_lut_param.lut_on = LUT_ON;
		hdr_lut_param.bitdepth = bit_depth;
		hdr_lut_param.cgain_en = LUT_ON;
		hdr_lut_param.hist_en = LUT_ON;
	} else if (hdr_process_select & HLG_HDR) {
		for (i = 0; i < HDR2_OETF_LUT_SIZE; i++) {
			hdr_lut_param.oetf_lut[i]  = oe_y_lut_hdr[i];
			hdr_lut_param.ogain_lut[i] = oo_y_lut_hlg_hdr[i];
			if (i < HDR2_EOTF_LUT_SIZE)
				hdr_lut_param.eotf_lut[i] = eo_y_lut_hlg[i];
			if (i < HDR2_CGAIN_LUT_SIZE)
				hdr_lut_param.cgain_lut[i] = cgain_lut1[i] - 1;
		}
		hdr_lut_param.lut_on = LUT_ON;
		hdr_lut_param.bitdepth = bit_depth;
		hdr_lut_param.cgain_en = LUT_ON;
		hdr_lut_param.hist_en = LUT_ON;
	} else if (hdr_process_select & SDR_HLG) {
		for (i = 0; i < HDR2_OETF_LUT_SIZE; i++) {
			hdr_lut_param.oetf_lut[i]  = oe_y_lut_hlg[i];
			hdr_lut_param.ogain_lut[i] = oo_y_lut_sdr_hlg[i];
			if (i < HDR2_EOTF_LUT_SIZE)
				hdr_lut_param.eotf_lut[i] = eo_y_lut_sdr[i];
			if (i < HDR2_CGAIN_LUT_SIZE)
				hdr_lut_param.cgain_lut[i] =
					cgain_lut_bypass[i] - 1;
		}
		if (always_full_func)
			hdr_lut_param.cgain_en = LUT_ON;
		else
			hdr_lut_param.cgain_en = LUT_OFF;
		hdr_lut_param.lut_on = LUT_ON;
		hdr_lut_param.bitdepth = bit_depth;
		hdr_lut_param.hist_en = LUT_OFF;
	}
#ifdef CONFIG_AMLOGIC_MEDIA_ENHANCEMENT_DOLBYVISION
	else if (hdr_process_select & SDR_IPT) {
		for (i = 0; i < HDR2_OETF_LUT_SIZE; i++) {
			hdr_lut_param.oetf_lut[i]  = oe_y_lut_hdr[i];
			output_mode = get_dolby_vision_target_mode();
			if (output_mode == DOLBY_VISION_OUTPUT_MODE_SDR10 ||
			output_mode == DOLBY_VISION_OUTPUT_MODE_SDR8)
				hdr_lut_param.ogain_lut[i] =
					512 * 80 / 10000;
					/* oo_y_lut_sdr_hdr_250[i]; */
			else if (output_mode == DOLBY_VISION_OUTPUT_MODE_HDR10)
				hdr_lut_param.ogain_lut[i] =
					oo_y_lut_sdr_hdr_250[i];
			else if (output_mode == DOLBY_VISION_OUTPUT_MODE_IPT ||
			output_mode == DOLBY_VISION_OUTPUT_MODE_IPT_TUNNEL)
				hdr_lut_param.ogain_lut[i] =
					oo_y_lut_sdr_hdr_300[i];
			if (i < HDR2_EOTF_LUT_SIZE)
				hdr_lut_param.eotf_lut[i] = eo_y_lut_sdr[i];
			if (i < HDR2_CGAIN_LUT_SIZE)
				hdr_lut_param.cgain_lut[i] =
					cgain_lut0[i] - 1;
		}
		//pr_info("\t oo_gain = %lld of 512\n",
		//	hdr_lut_param.ogain_lut[0]);
		hdr_lut_param.lut_on = LUT_ON;
		hdr_lut_param.bitdepth = bit_depth;
		hdr_lut_param.cgain_en = LUT_ON;
		hdr_lut_param.hist_en = LUT_OFF;
	} else if (hdr_process_select & HLG_IPT) {
		for (i = 0; i < HDR2_OETF_LUT_SIZE; i++) {
			hdr_lut_param.oetf_lut[i]  = oe_y_lut_hdr[i];
			// hdr_lut_param.ogain_lut[i] = oo_y_lut_bypass[i];
			output_mode = get_dolby_vision_target_mode();
			if (output_mode == DOLBY_VISION_OUTPUT_MODE_SDR10 ||
			output_mode == DOLBY_VISION_OUTPUT_MODE_SDR8)
				hdr_lut_param.ogain_lut[i] =
					oo_y_lut_hdr_hdr_1200[i];
			else if (output_mode ==
			DOLBY_VISION_OUTPUT_MODE_HDR10)
				hdr_lut_param.ogain_lut[i] =
					oo_y_lut_hdr_hdr_2500[i];
			else if (output_mode == DOLBY_VISION_OUTPUT_MODE_IPT ||
			output_mode == DOLBY_VISION_OUTPUT_MODE_IPT_TUNNEL)
				hdr_lut_param.ogain_lut[i] =
					oo_y_lut_hdr_hdr_4000[i];
			if (i < HDR2_EOTF_LUT_SIZE)
				hdr_lut_param.eotf_lut[i] = eo_y_lut_hlg[i];
			if (i < HDR2_CGAIN_LUT_SIZE)
				hdr_lut_param.cgain_lut[i] =
					cgain_lut0[i] - 1;
		}
		//pr_info("\t oo_gain = %lld of 512\n",
		//	hdr_lut_param.ogain_lut[0]);
		hdr_lut_param.lut_on = LUT_ON;
		hdr_lut_param.bitdepth = bit_depth;
		hdr_lut_param.cgain_en = LUT_ON;
		hdr_lut_param.hist_en = LUT_ON;
	} else if (hdr_process_select & HDR_IPT) {
		for (i = 0; i < HDR2_OETF_LUT_SIZE; i++) {
			hdr_lut_param.oetf_lut[i]  = oe_y_lut_hdr[i];
			output_mode = get_dolby_vision_target_mode();
			if (output_mode == DOLBY_VISION_OUTPUT_MODE_SDR10 ||
			output_mode == DOLBY_VISION_OUTPUT_MODE_SDR8)
				hdr_lut_param.ogain_lut[i] =
					oo_y_lut_hdr_hdr_1200[i];
			else if (output_mode == DOLBY_VISION_OUTPUT_MODE_HDR10)
				hdr_lut_param.ogain_lut[i] =
					oo_y_lut_bypass[i];
			else if (output_mode == DOLBY_VISION_OUTPUT_MODE_IPT ||
			output_mode == DOLBY_VISION_OUTPUT_MODE_IPT_TUNNEL)
				hdr_lut_param.ogain_lut[i] =
					oo_y_lut_bypass[i];
			if (i < HDR2_EOTF_LUT_SIZE)
				hdr_lut_param.eotf_lut[i] = eo_y_lut_pq[i];
			if (i < HDR2_CGAIN_LUT_SIZE)
				hdr_lut_param.cgain_lut[i] =
					cgain_lut0[i] - 1;
		}
		//pr_info("\t oo_gain = %lld of 512\n",
		//	hdr_lut_param.ogain_lut[0]);
		hdr_lut_param.lut_on = LUT_ON;
		hdr_lut_param.bitdepth = bit_depth;
		hdr_lut_param.cgain_en = LUT_ON;
		hdr_lut_param.hist_en = LUT_ON;
	}
#endif
	else if (hdr_process_select & HDR_HLG) {
		for (i = 0; i < HDR2_OETF_LUT_SIZE; i++) {
			hdr_lut_param.oetf_lut[i]  = oe_y_lut_hlg[i];
			hdr_lut_param.ogain_lut[i] = oo_y_lut_hdr_hlg[i];
			if (i < HDR2_EOTF_LUT_SIZE)
				hdr_lut_param.eotf_lut[i] = eo_y_lut_pq[i];
			if (i < HDR2_CGAIN_LUT_SIZE)
				hdr_lut_param.cgain_lut[i] = cgain_lut1[i] - 1;
		}
		//pr_info("\t oo_gain = %lld of 512\n",
		//	hdr_lut_param.ogain_lut[0]);
		hdr_lut_param.lut_on = LUT_ON;
		hdr_lut_param.bitdepth = bit_depth;
		hdr_lut_param.cgain_en = LUT_OFF;
		hdr_lut_param.hist_en = LUT_ON;
	} else if (hdr_process_select & SDR_GMT_CONVERT) {
		for (i = 0; i < HDR2_OETF_LUT_SIZE; i++) {
			hdr_lut_param.oetf_lut[i]  = oe_y_lut_sdr[i];
			hdr_lut_param.ogain_lut[i] = oo_y_lut_bypass[i];
			if (i < HDR2_EOTF_LUT_SIZE)
				hdr_lut_param.eotf_lut[i] =
					eo_y_lut_sdr[i];
			if (i < HDR2_CGAIN_LUT_SIZE)
				hdr_lut_param.cgain_lut[i] =
					cgain_lut_bypass[i] - 1;
		}
		hdr_lut_param.lut_on = LUT_ON;
		hdr_lut_param.bitdepth = bit_depth;
		hdr_lut_param.cgain_en = LUT_ON;
	} else
		return hdr_process_select;
#ifdef HDR2_PRINT
	if (hdr2_debug & HDR_DBG_GAIN_LUT)
	pr_info("hdr: oo_gain %d = %lld-%lld-%lld, c_gain %d = %lld-%lld-%lld\n",
		hdr_lut_param.lut_on,
		hdr_lut_param.ogain_lut[0], hdr_lut_param.ogain_lut[74],
		hdr_lut_param.ogain_lut[148],
		hdr_lut_param.cgain_en,
		hdr_lut_param.cgain_lut[0], hdr_lut_param.cgain_lut[32],
		hdr_lut_param.cgain_lut[64]);
#endif
	/*mtx parameters*/
	/* default matrix config */
	if (module_sel == VD1_HDR ||
	    module_sel == VD2_HDR ||
	    module_sel == VDIN0_HDR ||
	    module_sel == VDIN1_HDR) {
		/* default setting for HDR*/
		if (hdr_process_select & RGB_VDIN &&
		    hdr_process_select & FULL_VDIN) {
			coeff_in = bypass_coeff;
			oft_pre_in = bypass_pre;
			oft_post_in = bypass_pos;
			oft_pre_out = rgb2yuvpre;
			oft_post_out = rgb2yuvpos;
		} else if (hdr_process_select & RGB_VDIN) {
			coeff_in = srgb2rgb_coeff;
			oft_pre_in = srgb2rgb_pre;
			oft_post_in = srgb2rgb_pos;
			oft_pre_out = rgb2yuvpre;
			oft_post_out = rgb2yuvpos;
		} else if (hdr_process_select & FULL_VDIN) {
			/* sdr-> hdr use ycbcrf2rgb_ncl2020 */
			coeff_in = ycbcrf2rgb_ncl2020;
			oft_pre_in = yuvf2rgbpre;
			oft_post_in = yuv2rgbpos;
			oft_pre_out = rgb2yuvpre;
			oft_post_out = rgb2yuvpos;
		} else {
			/* sdr-> hdr use ycbcr2rgb_ncl2020 */
			coeff_in = ycbcr2rgb_ncl2020;
			oft_pre_in = yuv2rgbpre;
			oft_post_in = yuv2rgbpos;
			oft_pre_out = rgb2yuvpre;
			oft_post_out = rgb2yuvpos;
		}
	} else if (module_sel == OSD1_HDR &&
		   hdr_process_select & HDR_BYPASS) {
		/* sdr process, always rgb osd here*/
		if (hdr_process_select & RGB_OSD) {
			if (hdr_process_select & RGB_VDIN) {
				coeff_in = rgb2ycbcrf_709;
				oft_pre_in = rgb2yuvfpre;
				oft_post_in = rgb2yuvfpos;
				oft_pre_out = bypass_pre;
				oft_post_out = bypass_pos;
			} else {
				coeff_in = rgb2ycbcr_709;
				oft_pre_in = rgb2yuvpre;
				oft_post_in = rgb2yuvpos;
				oft_pre_out = bypass_pre;
				oft_post_out = bypass_pos;
			}
		} else {
			coeff_in = bypass_coeff;
			oft_pre_in = bypass_pre;
			oft_post_in = bypass_pos;
			oft_pre_out = bypass_pre;
			oft_post_out = bypass_pos;
		}
	} else if (module_sel == OSD1_HDR &&
		   (hdr_process_select & SDR_HDR ||
		    hdr_process_select & SDR_HLG ||
		    hdr_process_select & SDR_IPT)) {
		/* sdr process, always rgb osd here*/
		if (hdr_process_select & RGB_OSD) {
			coeff_in = bypass_coeff;
			oft_pre_in = bypass_pre;
			oft_post_in = bypass_pos;
			oft_pre_out = rgb2yuvpre;
			oft_post_out = rgb2yuvpos;
		} else {
			coeff_in = ycbcr2rgb_709;
			oft_pre_in = yuv2rgbpre;
			oft_post_in = yuv2rgbpos;
			oft_pre_out = rgb2yuvpre;
			oft_post_out = rgb2yuvpos;
		}
	}

	for (i = 0; i < 3; i++) {
		hdr_mtx_param.mtxi_pre_offset[i] =
			oft_pre_in[i];
		hdr_mtx_param.mtxi_pos_offset[i] =
			oft_post_in[i];
		hdr_mtx_param.mtxo_pre_offset[i] =
			oft_pre_out[i];
		hdr_mtx_param.mtxo_pos_offset[i] =
			oft_post_out[i];
	}

	if (hdr_process_select & IPT_MAP) {
		hdr_mtx_param.mtx_gamut_mode = 1;
		if (mtx_only_mode) {
			hdr_mtx_param.mtx_only = MTX_ONLY;
			for (i = 0; i < MTX_NUM_PARAM; i++) {
				hdr_mtx_param.mtx_in[i] = full2lmt_coeff[i];
				hdr_mtx_param.mtx_cgain[i] = bypass_coeff[i];
				hdr_mtx_param.mtx_ogain[i] = bypass_coeff[i];
				hdr_mtx_param.mtx_out[i] = bypass_coeff[i];
				if (i < 9)
					hdr_mtx_param.mtx_gamut[i] =
						gamut_bypass[i];
				if (i < 3) {
					hdr_mtx_param.mtxi_pre_offset[i] =
						full2lmt_pre[i];
					hdr_mtx_param.mtxi_pos_offset[i] =
						full2lmt_pos[i];
					hdr_mtx_param.mtxo_pre_offset[i] =
						bypass_pre[i];
					hdr_mtx_param.mtxo_pos_offset[i] =
						bypass_pos[i];
				}
			}
			hdr_mtx_param.mtx_on = MTX_OFF;
		}
	} else if (hdr_process_select & HDR_BYPASS ||
		   hdr_process_select & HLG_BYPASS) {
		hdr_mtx_param.mtx_gamut_mode = 1;
		if (module_sel == VD1_HDR ||
		    module_sel == VD2_HDR ||
		    module_sel == VDIN0_HDR ||
		    module_sel == VDIN1_HDR) {
			if (hdr_process_select & RGB_VDIN &&
			    hdr_process_select & FULL_VDIN) {
				coeff_in = rgb2ycbcrf_709;
				oft_pre_in = rgb2yuvfpre;
				oft_post_in = rgb2yuvfpos;
			} else if (hdr_process_select & RGB_VDIN) {
				coeff_in = srgb2ycbcrf_709;
				oft_pre_in = srgb2yuvfpre;
				oft_post_in = srgb2yuvfpos;
			} else {
				coeff_in = bypass_coeff;
				oft_pre_in = bypass_pre;
				oft_post_in = bypass_pos;
			}
		}

		for (i = 0; i < MTX_NUM_PARAM; i++) {
			hdr_mtx_param.mtx_in[i] = coeff_in[i];
			hdr_mtx_param.mtx_cgain[i] = bypass_coeff[i];
			hdr_mtx_param.mtx_ogain[i] = bypass_coeff[i];
			hdr_mtx_param.mtx_out[i] = bypass_coeff[i];
			if (i < 9)
				hdr_mtx_param.mtx_gamut[i] =
					gamut_bypass[i];
			if (i < 3) {
				hdr_mtx_param.mtxi_pre_offset[i] =
					oft_pre_in[i];
				hdr_mtx_param.mtxi_pos_offset[i] =
					oft_post_in[i];
				hdr_mtx_param.mtxo_pre_offset[i] =
					bypass_pre[i];
				hdr_mtx_param.mtxo_pos_offset[i] =
					bypass_pos[i];
			}
		}
		if (always_full_func) {
			hdr_mtx_param.mtx_only = HDR_ONLY;
			hdr_mtx_param.mtx_on = MTX_ON;
		} else {
			hdr_mtx_param.mtx_only = MTX_ONLY;
			hdr_mtx_param.mtx_on = MTX_OFF;
		}
		hdr_mtx_param.p_sel = hdr_process_select;
	} else if (hdr_process_select & HDR_SDR ||
		hdr_process_select & HDR10P_SDR) {
		hdr_mtx_param.mtx_only = HDR_ONLY;
		hdr_mtx_param.mtx_gamut_mode = 1;

		if (gmt_mtx) {
			for (i = 0; i < 3; i++)
				for (j = 0; j < 3; j++)
					hdr_mtx_param.mtx_gamut[i * 3 + j] =
					gmt_mtx->matrix[i][j];
		} else {
			for (i = 0; i < 9; i++)
				hdr_mtx_param.mtx_gamut[i] =
				ncl_2020_709_8bit[i];
		}
		for (i = 0; i < MTX_NUM_PARAM; i++) {
			hdr_mtx_param.mtx_in[i] = coeff_in[i];
			hdr_mtx_param.mtx_cgain[i] = rgb2ycbcr_709[i];
			hdr_mtx_param.mtx_ogain[i] = rgb2ycbcr_709[i];
			hdr_mtx_param.mtx_out[i] = rgb2ycbcr_709[i];
		}
		hdr_mtx_param.mtx_on = MTX_ON;
		hdr_mtx_param.p_sel = hdr_process_select;
		if (eo_gmt_bit_mode)
			hdr_mtx_param.gmt_bit_mode = 1;
	}  else if (hdr_process_select & HLG_SDR) {
		hdr_mtx_param.mtx_only = HDR_ONLY;
		hdr_mtx_param.mtx_gamut_mode = 1;

		if (gmt_mtx) {
			for (i = 0; i < 3; i++)
				for (j = 0; j < 3; j++)
					hdr_mtx_param.mtx_gamut[i * 3 + j] =
					gmt_mtx->matrix[i][j];
		} else {
			for (i = 0; i < 9; i++)
				hdr_mtx_param.mtx_gamut[i] =
				ncl_2020_709_8bit[i];
		}
		for (i = 0; i < MTX_NUM_PARAM; i++) {
			hdr_mtx_param.mtx_in[i] = coeff_in[i];
			hdr_mtx_param.mtx_cgain[i] = rgb2ycbcr_709[i];
			hdr_mtx_param.mtx_ogain[i] = rgb2ycbcr_ncl2020[i];
			hdr_mtx_param.mtx_out[i] = rgb2ycbcr_709[i];
		}
		hdr_mtx_param.mtx_on = MTX_ON;
		hdr_mtx_param.p_sel = hdr_process_select;
		if (eo_gmt_bit_mode)
			hdr_mtx_param.gmt_bit_mode = 1;
	} else if (hdr_process_select & HDR_HLG) {
		hdr_mtx_param.mtx_only = HDR_ONLY;
		hdr_mtx_param.mtx_gamut_mode = 1;

		for (i = 0; i < MTX_NUM_PARAM; i++) {
			hdr_mtx_param.mtx_in[i] = coeff_in[i];
			hdr_mtx_param.mtx_cgain[i] = rgb2ycbcr_ncl2020[i];
			hdr_mtx_param.mtx_ogain[i] = rgb2ycbcr_ncl2020[i];
			hdr_mtx_param.mtx_out[i] = rgb2ycbcr_ncl2020[i];
			if (i < 9)
				hdr_mtx_param.mtx_gamut[i] =
					gamut_bypass[i];
		}
		hdr_mtx_param.mtx_on = MTX_ON;
		hdr_mtx_param.p_sel = HDR_HLG;
	} else if (hdr_process_select & SDR_HDR ||
		   hdr_process_select & SDR_HLG) {
		hdr_mtx_param.mtx_only = HDR_ONLY;
		hdr_mtx_param.mtx_gamut_mode = 1;
		if ((module_sel == VD1_HDR ||
		     module_sel == VD2_HDR) &&
		     !(hdr_process_select & RGB_VDIN)) {
			coeff_in = ycbcr2rgb_709;
		}

		for (i = 0; i < MTX_NUM_PARAM; i++) {
			hdr_mtx_param.mtx_in[i] = coeff_in[i];
			hdr_mtx_param.mtx_cgain[i] =
				rgb2ycbcr_ncl2020[i];
			hdr_mtx_param.mtx_ogain[i] = rgb2ycbcr_709[i];
			hdr_mtx_param.mtx_out[i] = rgb2ycbcr_ncl2020[i];
			if (i < 9)
				hdr_mtx_param.mtx_gamut[i] =
					ncl_709_2020[i];
		}
		hdr_mtx_param.mtx_on = MTX_ON;
		hdr_mtx_param.p_sel = hdr_process_select;
	} else if (hdr_process_select & HLG_HDR) {
		hdr_mtx_param.mtx_only = HDR_ONLY;
		hdr_mtx_param.mtx_gamut_mode = 1;

		for (i = 0; i < MTX_NUM_PARAM; i++) {
			hdr_mtx_param.mtx_in[i] = coeff_in[i];
			hdr_mtx_param.mtx_cgain[i] = bypass_coeff[i];
			hdr_mtx_param.mtx_ogain[i] = bypass_coeff[i];
			hdr_mtx_param.mtx_out[i] = rgb2ycbcr_ncl2020[i];
			if (i < 9)
				hdr_mtx_param.mtx_gamut[i] = gamut_bypass[i];
		}
		hdr_mtx_param.mtx_on = MTX_ON;
		hdr_mtx_param.p_sel = HLG_HDR;
	}  else if (hdr_process_select & SDR_IPT) {
		hdr_mtx_param.mtx_only = HDR_ONLY;
		hdr_mtx_param.mtx_gamut_mode = 2;
		if ((module_sel == VD1_HDR ||
		     module_sel == VD2_HDR) &&
		     !(hdr_process_select & RGB_VDIN)) {
			coeff_in = ycbcr2rgb_709;
		}

		for (i = 0; i < MTX_NUM_PARAM; i++) {
			hdr_mtx_param.mtx_in[i] = coeff_in[i];
			hdr_mtx_param.mtx_cgain[i] = lms2ipt_ncl2020[i];
			hdr_mtx_param.mtx_ogain[i] = rgb2ycbcr_709[i];
			hdr_mtx_param.mtx_out[i] = lms2ipt_ncl2020[i];
			if (i < 9)
				hdr_mtx_param.mtx_gamut[i] =
					rgb709_to_lms2020[i];
		}
		hdr_mtx_param.mtx_on = MTX_ON;
		hdr_mtx_param.p_sel = SDR_IPT;
	}  else if (hdr_process_select & HLG_IPT) {
		hdr_mtx_param.mtx_only = HDR_ONLY;
		hdr_mtx_param.mtx_gamut_mode = 2;

		for (i = 0; i < MTX_NUM_PARAM; i++) {
			hdr_mtx_param.mtx_in[i] = coeff_in[i];
			hdr_mtx_param.mtx_cgain[i] = lms2ipt_ncl2020[i];
			hdr_mtx_param.mtx_ogain[i] = rgb2ycbcr_ncl2020[i];
			hdr_mtx_param.mtx_out[i] = lms2ipt_ncl2020[i];
			if (i < 9)
				hdr_mtx_param.mtx_gamut[i] = rgb2lms_ncl2020[i];
		}
		hdr_mtx_param.mtx_on = MTX_ON;
		hdr_mtx_param.p_sel = HLG_IPT;
	}  else if (hdr_process_select & HDR_IPT) {
		hdr_mtx_param.mtx_only = HDR_ONLY;
		hdr_mtx_param.mtx_gamut_mode = 2;

		for (i = 0; i < MTX_NUM_PARAM; i++) {
			hdr_mtx_param.mtx_in[i] = coeff_in[i];
			hdr_mtx_param.mtx_cgain[i] = lms2ipt_ncl2020[i];
			hdr_mtx_param.mtx_ogain[i] = rgb2ycbcr_ncl2020[i];
			hdr_mtx_param.mtx_out[i] = lms2ipt_ncl2020[i];
			if (i < 9)
				hdr_mtx_param.mtx_gamut[i] = rgb2lms_ncl2020[i];
		}
		hdr_mtx_param.mtx_on = MTX_ON;
		hdr_mtx_param.p_sel = HDR_IPT;
	} else if (hdr_process_select & SDR_GMT_CONVERT) {
		if (hdr_process_select & RGB_VDIN &&
		    hdr_process_select & FULL_VDIN) {
			coeff_in = bypass_coeff;
			coeff_out = rgb2ycbcrf_709;
			oft_pre_in = bypass_pre;
			oft_post_in = bypass_pos;
			oft_pre_out = rgb2yuvfpre;
			oft_post_out = rgb2yuvfpos;
		} else if (hdr_process_select & RGB_VDIN) {
			coeff_in = bypass_coeff;
			coeff_out = srgb2ycbcrf_709;
			oft_pre_in = bypass_pre;
			oft_post_in = bypass_pos;
			oft_pre_out = srgb2yuvfpre;
			oft_post_out = srgb2yuvfpos;
		} else if (hdr_process_select & FULL_VDIN) {
			coeff_in = ycbcrf2rgb_709;
			coeff_out = rgb2ycbcr_709;
			oft_pre_in = yuvf2rgbpre;
			oft_post_in = yuv2rgbpos;
			oft_pre_out = rgb2yuvpre;
			oft_post_out = rgb2yuvpos;
		} else {
			coeff_in = ycbcr2rgb_709;
			coeff_out = rgb2ycbcr_709;
			oft_pre_in = yuv2rgbpre;
			oft_post_in = yuv2rgbpos;
			oft_pre_out = rgb2yuvpre;
			oft_post_out = rgb2yuvpos;
		}

		if (gmt_mtx) {
			for (i = 0; i < 3; i++)
				for (j = 0; j < 3; j++)
					hdr_mtx_param.mtx_gamut[i * 3 + j] =
					gmt_mtx->matrix[i][j];
		} else {
			for (i = 0; i < 9; i++)
				hdr_mtx_param.mtx_gamut[i] =
				bypass_coeff[i];
		}
		hdr_mtx_param.mtx_only = HDR_ONLY;
		hdr_mtx_param.mtx_gamut_mode = 1;
		for (i = 0; i < MTX_NUM_PARAM; i++) {
			hdr_mtx_param.mtx_in[i] = coeff_in[i];
			hdr_mtx_param.mtx_cgain[i] =
				rgb2ycbcr_709[i];
			hdr_mtx_param.mtx_ogain[i] = rgb2ycbcr_709[i];
			hdr_mtx_param.mtx_out[i] = coeff_out[i];

			if (i < 3) {
				hdr_mtx_param.mtxi_pre_offset[i] =
					oft_pre_in[i];
				hdr_mtx_param.mtxi_pos_offset[i] =
					oft_post_in[i];
				hdr_mtx_param.mtxo_pre_offset[i] =
					oft_pre_out[i];
				hdr_mtx_param.mtxo_pos_offset[i] =
					oft_post_out[i];
			}
		}
		hdr_mtx_param.mtx_on = MTX_ON;
		hdr_mtx_param.p_sel = SDR_GMT_CONVERT;
	}

	if ((get_cpu_type() == MESON_CPU_MAJOR_ID_T5 || is_meson_t5d_cpu()) &&
	    ((module_sel == VD2_HDR) || (module_sel == OSD1_HDR)))
		return hdr_process_select;

	set_hdr_matrix(module_sel, HDR_IN_MTX, &hdr_mtx_param, NULL);

	set_eotf_lut(module_sel, &hdr_lut_param);

	set_hdr_matrix(module_sel, HDR_GAMUT_MTX, &hdr_mtx_param, NULL);

	set_ootf_lut(module_sel, &hdr_lut_param);

	set_oetf_lut(module_sel, &hdr_lut_param);

	set_hdr_matrix(module_sel, HDR_OUT_MTX, &hdr_mtx_param, NULL);

	set_c_gain(module_sel, &hdr_lut_param);

	hdr_hist_config(module_sel, &hdr_lut_param);

	return hdr_process_select;
}

u32 hdr_set(u32 module_sel, u32 hdr_process_select)
{
	return hdr_func(module_sel, hdr_process_select, NULL, NULL);
}
EXPORT_SYMBOL(hdr_set);

int hdr10p_ebzcurve_update(
	enum hdr_module_sel module_sel,
	enum hdr_process_sel hdr_process_select,
	struct hdr10pgen_param_s *p_hdr10pgen_param)
{
	int bit_depth;
	unsigned int i = 0;
	struct hdr_proc_mtx_param_s hdr_mtx_param;
	bool eo_gmt_bit_mode = false;

	memset(&hdr_mtx_param, 0, sizeof(struct hdr_proc_mtx_param_s));
	memset(&hdr_lut_param, 0, sizeof(struct hdr_proc_lut_param_s));

	if (module_sel == VD1_HDR ||
	    module_sel == VD2_HDR ||
	    module_sel == OSD1_HDR)
		bit_depth = 12;
	else if (
		module_sel == VDIN0_HDR ||
	    module_sel == VDIN1_HDR ||
	    module_sel == DI_HDR)
		bit_depth = 10;
	else
		return 0;

	if (cpu_after_eq(MESON_CPU_MAJOR_ID_TM2)) {
		if (is_meson_rev_a() && is_meson_tm2_cpu())
			eo_gmt_bit_mode = false;
		else
			eo_gmt_bit_mode = true;
	}

	if (is_meson_tl1_cpu())
		bit_depth = 10;

	if (get_cpu_type() == MESON_CPU_MAJOR_ID_T5 ||
		is_meson_t5d_cpu())
		bit_depth = 10;

	/*lut parameters*/
	if (hdr_process_select & HDR10P_SDR) {
		for (i = 0; i < HDR2_OETF_LUT_SIZE; i++) {
			if (!p_hdr10pgen_param)
				hdr_lut_param.ogain_lut[i] =
					oo_y_lut_hdr_sdr[i];
			else
				hdr_lut_param.ogain_lut[i] =
				p_hdr10pgen_param->gain[i];
		}
		hdr_lut_param.lut_on = LUT_ON;
	} else {
		return 0;
	}
#ifdef HDR2_PRINT
	if (hdr2_debug & HDR_DBG_GAIN_LUT)
	pr_info("hdr: oo_gain %d = %lld-%lld-%lld, c_gain %d = %lld-%lld-%lld\n",
		hdr_lut_param.lut_on,
		hdr_lut_param.ogain_lut[0], hdr_lut_param.ogain_lut[74],
		hdr_lut_param.ogain_lut[148],
		hdr_lut_param.cgain_en,
		hdr_lut_param.cgain_lut[0], hdr_lut_param.cgain_lut[32],
		hdr_lut_param.cgain_lut[64]);
#endif

	hdr_mtx_param.mtx_only = HDR_ONLY;
	hdr_mtx_param.mtx_gamut_mode = 1;
	for (i = 0; i < 9; i++) {
		if (!p_hdr10pgen_param)
			hdr_mtx_param.mtx_gamut[i] =
				ncl_2020_709_8bit[i];
		else
			hdr_mtx_param.mtx_gamut[i] =
				ncl_prmy_panel[i] *
				p_hdr10pgen_param->scale_gmt / 1024;
	}
	if (eo_gmt_bit_mode)
		hdr_mtx_param.gmt_bit_mode = 1;
	hdr_mtx_param.mtx_on = MTX_ON;
	hdr_mtx_param.p_sel = hdr_process_select;

	set_hdr_matrix(
		module_sel, HDR_GAMUT_MTX,
		&hdr_mtx_param, p_hdr10pgen_param);

	set_ootf_lut(module_sel, &hdr_lut_param);

	return 0;
}

int hdr10_tm_update(
	enum hdr_module_sel module_sel,
	enum hdr_process_sel hdr_process_select)
{
	int bit_depth;
	unsigned int i = 0;
	struct hdr_proc_mtx_param_s hdr_mtx_param;

	memset(&hdr_mtx_param, 0, sizeof(struct hdr_proc_mtx_param_s));
	memset(&hdr_lut_param, 0, sizeof(struct hdr_proc_lut_param_s));

	if (module_sel == VD1_HDR ||
	    module_sel == VD2_HDR ||
	    module_sel == OSD1_HDR)
		bit_depth = 12;
	else if (
		module_sel == VDIN0_HDR ||
	    module_sel == VDIN1_HDR ||
	    module_sel == DI_HDR)
		bit_depth = 10;
	else
		return 0;

	if (is_meson_tl1_cpu())
		bit_depth = 10;

	if (get_cpu_type() == MESON_CPU_MAJOR_ID_T5 ||
		is_meson_t5d_cpu())
		bit_depth = 10;

	if (hdr_process_select & HDR_SDR) {
		for (i = 0; i < HDR2_OETF_LUT_SIZE; i++)
			hdr_lut_param.ogain_lut[i] = oo_y_lut_hdr_sdr[i];
		hdr_lut_param.lut_on = LUT_ON;
	} else {
		return 0;
	}

	set_ootf_lut(module_sel, &hdr_lut_param);

	return 0;
}

enum hdr_process_sel hdr10p_func(
	enum hdr_module_sel module_sel,
	u32 hdr_process_select,
	struct vinfo_s *vinfo,
	struct matrix_s *gmt_mtx)
{
	int bit_depth;
	unsigned int i = 0, j = 0;
	struct hdr_proc_mtx_param_s hdr_mtx_param;
	bool eo_gmt_bit_mode = false;
	int *coeff_in = bypass_coeff;
	int *oft_pre_in = bypass_pre;
	int *oft_post_in = bypass_pos;

	memset(&hdr_mtx_param, 0, sizeof(struct hdr_proc_mtx_param_s));
	memset(&hdr_lut_param, 0, sizeof(struct hdr_proc_lut_param_s));

	if ((module_sel == OSD1_HDR) &&
	    (cpu_after_eq(MESON_CPU_MAJOR_ID_G12A))) {
		/* turn off OSD mtx and use HDR for g12, sm1, tl1 */
		VSYNC_WRITE_VPP_REG(
			VPP_WRAP_OSD1_MATRIX_EN_CTRL, 0);
		if (!is_dolby_vision_on()) {
			hdr_process_select |= RGB_OSD;
		}
	}

	if (cpu_after_eq(MESON_CPU_MAJOR_ID_TM2)) {
		if (is_meson_rev_a() && is_meson_tm2_cpu())
			eo_gmt_bit_mode = false;
		else
			eo_gmt_bit_mode = true;
	}

	if (module_sel == VD1_HDR ||
	    module_sel == VD2_HDR ||
	    module_sel == OSD1_HDR)
		bit_depth = 12;
	else if (module_sel == VDIN0_HDR ||
		 module_sel == VDIN1_HDR ||
		 module_sel == DI_HDR)
		bit_depth = 10;
	else
		return hdr_process_select;

	if (is_meson_tl1_cpu())
		bit_depth = 10;

	if (get_cpu_type() == MESON_CPU_MAJOR_ID_T5 ||
		is_meson_t5d_cpu())
		bit_depth = 10;

	/*lut parameters*/
	if (hdr_process_select & HDR_BYPASS) {
		for (i = 0; i < HDR2_OETF_LUT_SIZE; i++) {
			hdr_lut_param.oetf_lut[i] =	oe_y_lut_bypass[i];
			hdr_lut_param.ogain_lut[i] = oo_y_lut_bypass[i];
			if (i < HDR2_EOTF_LUT_SIZE)
				hdr_lut_param.eotf_lut[i] =
					eo_y_lut_bypass[i];
			if (i < HDR2_CGAIN_LUT_SIZE)
				hdr_lut_param.cgain_lut[i] =
					cgain_lut_bypass[i] - 1;
		}
		hdr_lut_param.bitdepth = bit_depth;
		hdr_lut_param.lut_on = LUT_OFF;
		hdr_lut_param.cgain_en = LUT_OFF;
	} else if (hdr_process_select & HDR10P_SDR) {
		for (i = 0; i < HDR2_OETF_LUT_SIZE; i++) {
			hdr_lut_param.oetf_lut[i]  = oe_y_lut_sdr[i];
			hdr_lut_param.ogain_lut[i] = oo_y_lut_hdr_sdr[i];
			if (i < HDR2_EOTF_LUT_SIZE) {
				if (eo_gmt_bit_mode)
					hdr_lut_param.eotf_lut[i] =
					eo_y_lut_pq_def[i];
				else
					hdr_lut_param.eotf_lut[i] =
					eo_y_lut_hdr_def[i];
			}
			if (i < HDR2_CGAIN_LUT_SIZE)
				hdr_lut_param.cgain_lut[i] = cgain_lut1[i] - 1;
		}
		hdr_lut_param.lut_on = LUT_ON;
		hdr_lut_param.bitdepth = bit_depth;
		hdr_lut_param.cgain_en = LUT_OFF;
	} else {
		return hdr_process_select;
	}
#ifdef HDR2_PRINT
	if (hdr2_debug & HDR_DBG_GAIN_LUT)
	pr_info("hdr: oo_gain %d = %lld-%lld-%lld, c_gain %d = %lld-%lld-%lld\n",
		hdr_lut_param.lut_on,
		hdr_lut_param.ogain_lut[0], hdr_lut_param.ogain_lut[74],
		hdr_lut_param.ogain_lut[148],
		hdr_lut_param.cgain_en,
		hdr_lut_param.cgain_lut[0], hdr_lut_param.cgain_lut[32],
		hdr_lut_param.cgain_lut[64]);
#endif

	/*mtx parameters*/
	/* default pre/post in:yuv_rgb out:rgb_yuv */
	if (hdr_process_select & RGB_VDIN &&
	    hdr_process_select & FULL_VDIN) {
		coeff_in = bypass_coeff;
		oft_pre_in = bypass_pre;
		oft_post_in = bypass_pos;
	} else if (hdr_process_select & RGB_VDIN) {
		coeff_in = srgb2rgb_coeff;
		oft_pre_in = srgb2rgb_pre;
		oft_post_in = srgb2rgb_pos;
	} else {
		/* sdr-> hdr use ycbcr2rgb_709 */
		coeff_in = ycbcr2rgb_ncl2020;
		oft_pre_in = yuv2rgbpre;
		oft_post_in = yuv2rgbpos;
	}

	for (i = 0; i < 3; i++) {
		hdr_mtx_param.mtxi_pre_offset[i] =
			oft_pre_in[i];
		hdr_mtx_param.mtxi_pos_offset[i] =
			oft_post_in[i];
		hdr_mtx_param.mtxo_pre_offset[i] =
			rgb2yuvpre[i];
		hdr_mtx_param.mtxo_pos_offset[i] =
			rgb2yuvpos[i];
	}

	if (hdr_process_select & HDR_BYPASS) {
		hdr_mtx_param.mtx_gamut_mode = 1;
		if (hdr_process_select & RGB_VDIN &&
		    hdr_process_select & FULL_VDIN) {
			coeff_in = rgb2ycbcrf_709;
			oft_pre_in = rgb2yuvfpre;
			oft_post_in = rgb2yuvfpos;
		} else if (hdr_process_select & RGB_VDIN) {
			coeff_in = srgb2ycbcrf_709;
			oft_pre_in = srgb2yuvfpre;
			oft_post_in = srgb2yuvfpos;
		} else {
			coeff_in = bypass_coeff;
			oft_pre_in = bypass_pre;
			oft_post_in = bypass_pos;
		}

		hdr_mtx_param.mtx_only = MTX_ONLY;
		for (i = 0; i < MTX_NUM_PARAM; i++) {
			hdr_mtx_param.mtx_in[i] = coeff_in[i];
			hdr_mtx_param.mtx_cgain[i] = bypass_coeff[i];
			hdr_mtx_param.mtx_ogain[i] = bypass_coeff[i];
			hdr_mtx_param.mtx_out[i] = bypass_coeff[i];
			if (i < 9)
				hdr_mtx_param.mtx_gamut[i] =
					gamut_bypass[i];
			if (i < 3) {
				hdr_mtx_param.mtxi_pre_offset[i] =
					oft_pre_in[i];
				hdr_mtx_param.mtxi_pos_offset[i] =
					oft_post_in[i];
				hdr_mtx_param.mtxo_pre_offset[i] =
					bypass_pre[i];
				hdr_mtx_param.mtxo_pos_offset[i] =
					bypass_pos[i];
			}
		}
		hdr_mtx_param.mtx_on = MTX_ON;

		hdr_mtx_param.p_sel = HDR_BYPASS;
	} else if (hdr_process_select & HDR10P_SDR) {
		hdr_mtx_param.mtx_only = HDR_ONLY;
		hdr_mtx_param.mtx_gamut_mode = 1;

		if (gmt_mtx) {
			for (i = 0; i < 3; i++)
				for (j = 0; j < 3; j++) {
					if (gmt_mtx->matrix[i][j] & 0x8000)
						ncl_prmy_panel[i * 3 + j] =
						gmt_mtx->matrix[i][j] -
						(1 << 16);
					else
						ncl_prmy_panel[i * 3 + j] =
						gmt_mtx->matrix[i][j];
				}
		} else {
			for (i = 0; i < 9; i++)
				ncl_prmy_panel[i] = ncl_2020_p3d65[i];
		}
		for (i = 0; i < MTX_NUM_PARAM; i++) {
			hdr_mtx_param.mtx_in[i] = coeff_in[i];
			hdr_mtx_param.mtx_cgain[i] = rgb2ycbcr_709[i];
			hdr_mtx_param.mtx_ogain[i] = rgb2ycbcr_709[i];
			hdr_mtx_param.mtx_out[i] = rgb2ycbcr_709[i];
			if (i < 9) {
				hdr_mtx_param.mtx_gamut[i] =
					ncl_prmy_panel[i];
			}
		}
		hdr_mtx_param.mtx_on = MTX_ON;
		hdr_mtx_param.p_sel = hdr_process_select;
		if (eo_gmt_bit_mode)
			hdr_mtx_param.gmt_bit_mode = 1;
	}

	if ((get_cpu_type() == MESON_CPU_MAJOR_ID_T5 || is_meson_t5d_cpu()) &&
	    ((module_sel == VD2_HDR) || (module_sel == OSD1_HDR)))
		return hdr_process_select;

	set_hdr_matrix(module_sel, HDR_IN_MTX, &hdr_mtx_param, NULL);

	set_eotf_lut(module_sel, &hdr_lut_param);

	set_hdr_matrix(module_sel, HDR_GAMUT_MTX, &hdr_mtx_param, NULL);

	set_ootf_lut(module_sel, &hdr_lut_param);

	set_oetf_lut(module_sel, &hdr_lut_param);

	set_hdr_matrix(module_sel, HDR_OUT_MTX, &hdr_mtx_param, NULL);

	set_c_gain(module_sel, &hdr_lut_param);

	hdr_hist_config(module_sel, &hdr_lut_param);

	return hdr_process_select;
}

/*G12A matrix setting*/
void mtx_setting(enum vpp_matrix_e mtx_sel,
	enum mtx_csc_e mtx_csc,
	int mtx_on)
{
	unsigned int matrix_coef00_01 = 0;
	unsigned int matrix_coef02_10 = 0;
	unsigned int matrix_coef11_12 = 0;
	unsigned int matrix_coef20_21 = 0;
	unsigned int matrix_coef22 = 0;
	unsigned int matrix_coef13_14 = 0;
	unsigned int matrix_coef23_24 = 0;
	unsigned int matrix_coef15_25 = 0;
	unsigned int matrix_clip = 0;
	unsigned int matrix_offset0_1 = 0;
	unsigned int matrix_offset2 = 0;
	unsigned int matrix_pre_offset0_1 = 0;
	unsigned int matrix_pre_offset2 = 0;
	unsigned int matrix_en_ctrl = 0;

	if (mtx_sel == VD1_MTX) {
		matrix_coef00_01 = VPP_VD1_MATRIX_COEF00_01;
		matrix_coef02_10 = VPP_VD1_MATRIX_COEF02_10;
		matrix_coef11_12 = VPP_VD1_MATRIX_COEF11_12;
		matrix_coef20_21 = VPP_VD1_MATRIX_COEF20_21;
		matrix_coef22 = VPP_VD1_MATRIX_COEF22;
		matrix_coef13_14 = VPP_VD1_MATRIX_COEF13_14;
		matrix_coef23_24 = VPP_VD1_MATRIX_COEF23_24;
		matrix_coef15_25 = VPP_VD1_MATRIX_COEF15_25;
		matrix_clip = VPP_VD1_MATRIX_CLIP;
		matrix_offset0_1 = VPP_VD1_MATRIX_OFFSET0_1;
		matrix_offset2 = VPP_VD1_MATRIX_OFFSET2;
		matrix_pre_offset0_1 = VPP_VD1_MATRIX_PRE_OFFSET0_1;
		matrix_pre_offset2 = VPP_VD1_MATRIX_PRE_OFFSET2;
		matrix_en_ctrl = VPP_VD1_MATRIX_EN_CTRL;

		VSYNC_WRITE_VPP_REG_BITS(VPP_VD1_MATRIX_EN_CTRL, mtx_on, 0, 1);
	} else if (mtx_sel == POST2_MTX) {
		matrix_coef00_01 = VPP_POST2_MATRIX_COEF00_01;
		matrix_coef02_10 = VPP_POST2_MATRIX_COEF02_10;
		matrix_coef11_12 = VPP_POST2_MATRIX_COEF11_12;
		matrix_coef20_21 = VPP_POST2_MATRIX_COEF20_21;
		matrix_coef22 = VPP_POST2_MATRIX_COEF22;
		matrix_coef13_14 = VPP_POST2_MATRIX_COEF13_14;
		matrix_coef23_24 = VPP_POST2_MATRIX_COEF23_24;
		matrix_coef15_25 = VPP_POST2_MATRIX_COEF15_25;
		matrix_clip = VPP_POST2_MATRIX_CLIP;
		matrix_offset0_1 = VPP_POST2_MATRIX_OFFSET0_1;
		matrix_offset2 = VPP_POST2_MATRIX_OFFSET2;
		matrix_pre_offset0_1 = VPP_POST2_MATRIX_PRE_OFFSET0_1;
		matrix_pre_offset2 = VPP_POST2_MATRIX_PRE_OFFSET2;
		matrix_en_ctrl = VPP_POST2_MATRIX_EN_CTRL;

		VSYNC_WRITE_VPP_REG_BITS(VPP_POST2_MATRIX_EN_CTRL, mtx_on, 0, 1);
	} else if (mtx_sel == POST_MTX) {
		matrix_coef00_01 = VPP_POST_MATRIX_COEF00_01;
		matrix_coef02_10 = VPP_POST_MATRIX_COEF02_10;
		matrix_coef11_12 = VPP_POST_MATRIX_COEF11_12;
		matrix_coef20_21 = VPP_POST_MATRIX_COEF20_21;
		matrix_coef22 = VPP_POST_MATRIX_COEF22;
		matrix_coef13_14 = VPP_POST_MATRIX_COEF13_14;
		matrix_coef23_24 = VPP_POST_MATRIX_COEF23_24;
		matrix_coef15_25 = VPP_POST_MATRIX_COEF15_25;
		matrix_clip = VPP_POST_MATRIX_CLIP;
		matrix_offset0_1 = VPP_POST_MATRIX_OFFSET0_1;
		matrix_offset2 = VPP_POST_MATRIX_OFFSET2;
		matrix_pre_offset0_1 = VPP_POST_MATRIX_PRE_OFFSET0_1;
		matrix_pre_offset2 = VPP_POST_MATRIX_PRE_OFFSET2;
		matrix_en_ctrl = VPP_POST_MATRIX_EN_CTRL;

		VSYNC_WRITE_VPP_REG_BITS(VPP_POST_MATRIX_EN_CTRL, mtx_on, 0, 1);
	}

	if (!mtx_on)
		return;

	switch (mtx_csc) {
	case MATRIX_RGB_YUV709:
		VSYNC_WRITE_VPP_REG(matrix_coef00_01, 0x00bb0275);
		VSYNC_WRITE_VPP_REG(matrix_coef02_10, 0x003f1f99);
		VSYNC_WRITE_VPP_REG(matrix_coef11_12, 0x1ea601c2);
		VSYNC_WRITE_VPP_REG(matrix_coef20_21, 0x01c21e67);
		VSYNC_WRITE_VPP_REG(matrix_coef22, 0x00001fd7);
		VSYNC_WRITE_VPP_REG(matrix_offset0_1, 0x00400200);
		VSYNC_WRITE_VPP_REG(matrix_offset2, 0x00000200);
		VSYNC_WRITE_VPP_REG(matrix_pre_offset0_1, 0x0);
		VSYNC_WRITE_VPP_REG(matrix_pre_offset2, 0x0);
		break;
	case MATRIX_YUV709_RGB:
		VSYNC_WRITE_VPP_REG(matrix_coef00_01, 0x04A80000);
		VSYNC_WRITE_VPP_REG(matrix_coef02_10, 0x072C04A8);
		VSYNC_WRITE_VPP_REG(matrix_coef11_12, 0x1F261DDD);
		VSYNC_WRITE_VPP_REG(matrix_coef20_21, 0x04A80876);
		VSYNC_WRITE_VPP_REG(matrix_coef22, 0x0);
		VSYNC_WRITE_VPP_REG(matrix_offset0_1, 0x0);
		VSYNC_WRITE_VPP_REG(matrix_offset2, 0x0);
		VSYNC_WRITE_VPP_REG(matrix_pre_offset0_1, 0x7c00600);
		VSYNC_WRITE_VPP_REG(matrix_pre_offset2, 0x00000600);
		break;
	case MATRIX_YUV709F_RGB:/*full to full*/
		VSYNC_WRITE_VPP_REG(matrix_coef00_01, 0x04000000);
		VSYNC_WRITE_VPP_REG(matrix_coef02_10, 0x064D0400);
		VSYNC_WRITE_VPP_REG(matrix_coef11_12, 0x1F411E21);
		VSYNC_WRITE_VPP_REG(matrix_coef20_21, 0x0400076D);
		VSYNC_WRITE_VPP_REG(matrix_coef22, 0x0);
		VSYNC_WRITE_VPP_REG(matrix_offset0_1, 0x0);
		VSYNC_WRITE_VPP_REG(matrix_offset2, 0x0);
		VSYNC_WRITE_VPP_REG(matrix_pre_offset0_1, 0x0000600);
		VSYNC_WRITE_VPP_REG(matrix_pre_offset2, 0x00000600);
		break;
	default:
		break;
	}

	/*pr_info("mtx_sel:%d, mtx_csc:0x%x\n", mtx_sel, mtx_csc);*/
}
