// Copyright 2017, the V8 project authors. All rights reserved.
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//     * Neither the name of Google Inc. nor the names of its
//       contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Generated by tools/bigint-tester.py.

var data = [{
  a: 0x9f756d5eba29edefedd68e98e89487acbab2b7591d350cd5n,
  b: 0x6efa27ff53050315bbf334fe7d99addcf446c9c6a2b35c0n,
  r: 0x16n
}, {
  a: -0x2a5ba1bd8b2dde1801c0a3673cadd03b6805f8a0cd7d173eebb9f08900n,
  b: -0x93f36328986en,
  r: 0x494acc5e0d2328db494ef81a182928ec70cdec2a7d85dfn
}, {
  a: -0x18b8f685f4f31e6e0ef491d7a3fb4b64839c0dfa51e17500bc8de7f2fen,
  b: -0x7377ec8f2d58af27de037079d619b570n,
  r: 0x36cfa9f256a4c3889a3b39621dn
}, {
  a: -0xb20ca62069104293f05bcc2b57c57b0b2f41098356a1fa75fn,
  b: 0xdb5c3c7a97929f9cd948e2bbf75c1fc4a7n,
  r: -0xcfc9f983f8d6e8dn
}, {
  a: 0x33b8f94f367e4ef22ae7ab1226d1f773fbd14b42f95ac33d1a8ea4a9040534b58490n,
  b: -0xc81ff0bb05e1ed4f6n,
  r: -0x4229e14e80d4e47ad51a410d6fd79a3089ced9912e40c48c2d8n
}, {
  a: -0xb8e17c705355a220135408bfa2052c98c05fe46ac251749d3efe2f4caa44586a0f1n,
  b: 0x73be87683b5aan,
  r: -0x198ea12c082994be22e02b7d2480b118e17e93e58e5e24de8a4f6d4n
}, {
  a: 0xa788cdf7ca158d80c16be0b95984c815511553b81d5514e2bed148en,
  b: 0xae408dc2e93746057c1d6322cca3c5475678dan,
  r: 0xf62174aec76c03ae9n
}, {
  a: -0x4c792e336d556afda77787f0eba295df7995b02ddfe7d5fb93414beb4122n,
  b: 0x2752c75fce1n,
  r: -0x1f1d9ea2587db084b61f7ab6f4379132d7c4021f46cec1e7cfn
}, {
  a: -0x8625e87c6d3c9ca3dcd7f8cb98ee0771532132f8e3bn,
  b: 0x9691ab2753f9037ebed0edeb0n,
  r: -0xe414b1f710236f49f4n
}, {
  a: -0x6d258113a4259b8645484fb94f57809e24df61515c12343bed737f650aa89170a6fa32n,
  b: 0xa3903df6d0n,
  r: -0xaad46b2d9b89b01120ff62767da8c8d3ec6751c03bd5f751e28728740470n
}, {
  a: -0xacf54d6fe7c3441b4fe07d5afa707919ddef846c0fec934c98230d1c501ea7n,
  b: -0xb547198n,
  r: 0xf4404e2d00b30b2551ea27417045c074bec764965a1a5211458c14fn
}, {
  a: 0x4a165f0be9eae6709d52e7eb7d4391ea0fa754bbfa0bf8n,
  b: 0xebe7a55fae937ed1be05456dd187n,
  r: 0x5065fcd23eb98ce31an
}, {
  a: -0x2a09a867367c2d9a5922a03591acd3900f17c71e4bdfaa4842723918dn,
  b: -0xbb2fe0d18b1f1d7361f85ee11en,
  r: 0x397dd1338d043960846cab937e4b4d9n
}, {
  a: -0xdc60fa053f8bdce10d07435b66c2277d77fca316f87fb006fn,
  b: 0xcd3c713beb4cf77dfdfcfb7bn,
  r: -0x112e35f158dafe7c77d76f75a3n
}, {
  a: 0xb153a8e0f1f3c1ddddf5083c00c6465c927d461fac440719c8d862a8da0f9n,
  b: -0x78aan,
  r: -0x178371a367b3fcffb35a0e51950fcc996d606b6c0ab5a1c4aa919cbcbcn
}, {
  a: 0xb5bbb451b7362d6a71b782bcc7d0d478b85ff0e8c7a72cdd0ca4724280d7473cn,
  b: -0x816ae96bdb575cf662cad7b50cf9ca923afn,
  r: -0x1677c2de2b3eea2e716d525171e12an
}, {
  a: 0xb962ad6781fffe201865a0c404f3f1adfd41db3075ea69970n,
  b: 0x34543aa5f9f4an,
  r: 0x38aedaf768cfae96100ee5198d13501779f5dn
}, {
  a: 0x76e90ada2365aa63e873e49b48ef6669d7ee56120ac69bc3f6437a0c5n,
  b: 0x3b4a8d8cddf70864b0eb82dcdaa299a03fe5893716d5f21dn,
  r: 0x2016a690b8n
}, {
  a: 0x31503127fed2b61bb0c09e2f2508ced8672bb165dc2b576a23d3fe526a4159058n,
  b: -0xea526en,
  r: -0x35e01a803b78f4da063e49e684dc1dd0293a07c3370891877c9b337e113n
}, {
  a: -0x6758748b7400ceb6bac77b766d1a2839b02074b24e8db7722303b6a999393cb6681980n,
  b: 0xa833c4740461dfd2f77bbf554adde62e5ca83b7e3n,
  r: -0x9d4a21a29c4d28ec7d2d46b32277cn
}, {
  a: -0x93f829d198741c175a4b58a8e8e8c13a324604fccc3e7a69ccc201228n,
  b: 0xd438ac49ben,
  r: -0xb27e5e3f9697e28a6651b0d646068a24ee8a99c45b10cdcn
}, {
  a: -0xfb4c539763d1c52c3ff64187692f274d9f47370923df0d4f8743f220940e3efda9583cn,
  b: -0x1867229ba723f9a06fcccbede245ab8493an,
  r: 0xa4c42aea3f642341b0c72851780a4c3ea710n
}, {
  a: 0xb915f0dc6c091dd249822bc91e942b7d9a18f689059abcad8n,
  b: -0x7ea8fe881aa8a08410e17d18e2f58d2cf74b32n,
  r: -0x1761655dd835n
}, {
  a: -0x98c13556a2ddfd3b908600f72e9ad5efd1f65ff9ae188b5243ab55c06bec7n,
  b: -0x9c8835cafe141a99eed5e20e017e1n,
  r: 0xf9d284ee80f40dc3da64802f54e0e705n
}, {
  a: -0x42d76f8816729baaf7e4baac4da7596bb11f2a68eb078332b6ce00ecfda5f57314n,
  b: 0x52bf061bab9d8n,
  r: -0xcecb53f7a4585000ee6fae7b5d5ae145e68cd97900e9020650e8dn
}, {
  a: -0x2506042948835a0ae706142edf6a25ba39834ae8f23ad4945e80n,
  b: 0x3371b8f1fd0d94d891e8187b9cn,
  r: -0xb83d198c3a4e64a18a20f2c60bn
}, {
  a: -0x7fe9af2235c81a8e55ef3d9ee1701312af2116b7b9ac4n,
  b: 0xce1ca6a0f90650a11d238ad979fb828f5n,
  r: -0x9edf91bc25d0n
}, {
  a: 0xcc85075cf8128feabc7ec3279522d3e4fbdd46584201d08n,
  b: -0xc46c897152418081c11d3ba0d6887c3782d253fn,
  r: -0x10a8d15dbn
}, {
  a: 0xc486a0cd641f1aa9c9c2ea5ba611dfcd83c98b825953b7e19f5d2en,
  b: -0xd7d6301c2448c6f7afe5d75d2022dab90b5eaee87acn,
  r: -0xe918885268bn
}, {
  a: 0x35f5ceae82df10c747e1cd150e07fba5af43901dcen,
  b: -0xcc273cn,
  r: -0x43a9f5dfa5dd56d1cac22fa882bf75c11827n
}, {
  a: 0x41a7d26f978838dec7ca7685c6ca720720d8348c24fen,
  b: 0x504a17824a10f48cca40b6087218d49edfn,
  r: 0xd1572676b9n
}, {
  a: -0xf4f20bcb108ab7cc38b111d6d0df6a088894c2693f3eddaff142bn,
  b: -0x5f2957n,
  r: 0x292f18c95736a4a3e8aa0a460bb54fca793e2b1709c0c683n
}, {
  a: 0xd672bcfb3cdc40056e44b990c328df90795c8d8c0018c26cn,
  b: -0xdec453e74a5b9b082d16970f373f3269718a3dn,
  r: -0xf670b61a15n
}, {
  a: -0x97f071342ebd634506b380466e623dbaaa0aba6cba0ea6698eff78a909b7n,
  b: 0x3b6814df9165550181n,
  r: -0x28ebff698c05db77a6077796061c315d57d5ca7dc8fn
}, {
  a: 0xf77a8431729d7bca3383cfacd3d52a5d0d5fa9268aa9n,
  b: 0xe2cb28f7bdfc5a3cn,
  r: 0x117594a67426d6b4c8f82f4bcc4f2n
}, {
  a: -0x989fb88bf61acfefd034c22f5fd7efab65ee481a8203e8a24d5f929fa6ae0d54084ebn,
  b: 0xe708318928d8525b1ecf94981e99bcn,
  r: -0xa91e437714456d5bce01a14b9aa12b0341a73e8n
}, {
  a: -0xed29a2a99c4b7cb81ec74944ec5c23196d5615f2c9129bc21cn,
  b: -0xe505736433n,
  r: 0x10919b39c4737764ad5e214180d59a3295359c4den
}, {
  a: 0xb130726bfd9e66219503ebb570925c1171384fbebc4d9c307526ad7e9619n,
  b: -0x82d58c1b49c8n,
  r: -0x15ab3abaf1fccbc4216d60cd75dcf59e059a7a35999682a97n
}, {
  a: -0x8ff389567614e38c27769413c2b63ec20b67f45a8abd84bd9d149n,
  b: -0x88e19d5aa927f9dcn,
  r: 0x10d38f9f001c130ab429bf75ed93243c5bdeebn
}, {
  a: 0xaaeca7143f2ea9e61adfc730efe9c8d8934a3deb7da24e9en,
  b: 0xb28fdc0a7n,
  r: 0xf50cdddc6e46f43c56ab0b7149a28a8e760a934n
}, {
  a: -0xd4e9b26a9f60ac419206a9b2bb7074b9a5d367990c8e640f768215n,
  b: -0x33ec566a4f3e5e06513b47f99470b2a7854cc75b8a74n,
  r: 0x419bcab5c13n
}, {
  a: -0xf8660e7788f0a11a5c01d4fb16ae2e2bd240f6963227bf73b34n,
  b: -0xc8c30c331c0d7167773d233f97952n,
  r: 0x13cbe5f2f31c90f2320a481n
}, {
  a: -0xe57fc45ad20304ec08a7ec145a134a37cd32cb1168940ffd94cef97286fn,
  b: -0x963f82c94339a374c98c09088cb49b7n,
  r: 0x187081e0339e3ad70fa0793577b1cn
}, {
  a: -0xbcc42f216c858d6631c6454506692b85be9fe95b26n,
  b: 0xa5d8fac620d343f80343b9e16074049bca4479cn,
  r: -0x1236n
}, {
  a: -0x47b5c4e7b23a1928871a9c474d715949f677818a359c1df567596d4e03740598n,
  b: 0x8c1cd3c684bcfba573a9b027091f10n,
  r: -0x830583804de93d58b2098eaa74a4a283een
}, {
  a: 0xefc9b9c14d4aec26eb9b403f2701b3871121b5872b06437d5b7c5bn,
  b: -0xfa5fd430faca4e764e858d6a36ac81ac98f0facf5e7n,
  r: -0xf52d00daf05n
}, {
  a: 0x16dcfa5d4a77474dce19c469e413faa7c5d18db2625c86d43846n,
  b: 0x90ddc56b67b60d8d7c4ded2d415a80020d3an,
  r: 0x2867122ecd8c781fn
}, {
  a: -0x9ac13a7d7889041b0e130f457ce2f6c10720aa7377b6bce2b28ce1efn,
  b: 0x86a76df0b1fbb5597fb2bcd2fe3430293773efa6b88dfn,
  r: -0x126370819161n
}, {
  a: 0xeb3bd241315893c1891a30b218521b57801ff6c53bfbbe822a449dn,
  b: 0x57567e8n,
  r: 0x2b1810f4310fdbb35bf60a2534fce5b769944c4f305f338fn
}, {
  a: -0xd9aa6d800a3a4e84b3e6dad6927ce2b1cc69d93d01bf00fbd4n,
  b: 0xc886d15904d415eae3a65cb34n,
  r: -0x115e1643323e933a490faf2c52n
}, {
  a: -0x5b0eceb7a377ba38c0bce9e9b38b9aadf511fb28317b1237e8795n,
  b: 0xa8e50c9975b5f22n,
  r: -0x8a050e5394a4626d6a5ca24937a4c624108a8dn
}, {
  a: -0xd0ab63cbbd55709f3c0465a36f7702bd04310a46eef50086c2db49b5bac61n,
  b: -0x18b0ff50f274e495b285d3637558475315a05bfab88a0bn,
  r: 0x8737b62d3366d376n
}, {
  a: -0xecdebe5b453ce24f52b7f645ad2e182ed9be49e8868814n,
  b: -0xa79808efcd68ca0ea53ed91015e5ba9bf80bn,
  r: 0x169d1cda69an
}, {
  a: 0x9bb3249b8a52c0d32b5448ef47603237e15bb7fdf144454n,
  b: 0x6009a072a6e557953dc76649cce0c5aadc79a9dn,
  r: 0x19f096dbdn
}, {
  a: 0x7b1ae0d265275dc29c9b6fc1d3965c53487a7782e8b077679ef227fa193d47en,
  b: 0x67265469893e682a5ce8ecn,
  r: 0x131868b73cedaac7ae67441cbea069ed92c2c06fe9n
}, {
  a: -0x5fd4e0ba919c2290202fa45361842803508a036d17ce03f23047e3cn,
  b: 0xfad89a8bbf451dbc700eb8f2979d069690eaaec8b0e4c5n,
  r: -0x61ccee5cfn
}, {
  a: 0xe1af802548c249579b854d5aba2afaad54b7d3d65c36ba1fab6258e81810e37c4bb25cn,
  b: -0xccn,
  r: -0x11b3696c560532edc5ec566178035ef47f1d7a06c5fa40cb44a857496b4c9e641a03fn
}, {
  a: -0x37f951bc21760be3757797b116c7f46d9896e1a2828d6ab9bc0379d2250ea1f448a2d6n,
  b: 0xcb7001fbb9b6e2df7555fecdbedn,
  r: -0x466f9b917ef53187b126fd1b5b18aaf75be7c73893en
}, {
  a: 0xb89a8413391f0cfbe270ff228891b2240b9fb0a40fbd7fc217n,
  b: 0xc55012ea35745e8a7391aa93n,
  r: 0xef82ba82c27485f1aac227eb8cn
}, {
  a: -0x98d15987b00c31b598d99266237b43c0f904e4b00f9ed28f8ff0d03e33e52bn,
  b: -0xeb02307615bf1e02dbf6c7n,
  r: 0xa677bfd11a43d4ba3a6bebc3c1238f062526ac81n
}, {
  a: -0x298cd7d548526ecd3dd9636d17672f62eaad6fe44482a1a3d3dc2f1bba7d5a063f2ean,
  b: -0xe0a09787dc7014c0e4193dn,
  r: 0x2f5a7175975a800c167163932efc6620facd57da7b0c3d6n
}, {
  a: -0x7b4c592f740c0e3af4ce6d23d415293fe26467813df301an,
  b: -0xd24e42f05815d83b64f914cdn,
  r: 0x96168289b679f0aea1bd8dfn
}, {
  a: 0xc4b9a6ef487444fe6c39c25a4380a9fa0df1ce34020c29d1bc4f771d3fdb8dec3827f9n,
  b: -0x883b8e6dc8be74n,
  r: -0x171ac84b597d1677acec474c8dca20b45abcfcf9d33119e84ee4df546n
}, {
  a: -0x71ee81d103950e794fb1c2b7bf1e14fd7f17011b5f6b0c79n,
  b: 0x8499f50bedn,
  r: -0xdbf4cd8148b5285d17ea86646563e5db90ec68n
}, {
  a: 0xe7778d456d63d3e7a5ad6b5197e2bf686445995298fn,
  b: -0x4185340268de0c7cn,
  r: -0x388626033045ac0e4fe9b860aa8en
}, {
  a: 0xa38f1e89e4d643605172bbaa9cb1ed2513dde9a930b12c1b8395n,
  b: -0xfa79e6d690a37606308c868b8ebd7bn,
  r: -0xa72a83cc136f836aecd9fan
}, {
  a: 0x85a6ebc2803b3859cc14828aa35fe14e26a4b90b03cb078a6eba1cn,
  b: 0xce2bfc37adb128d01b7d305e90f52b97ef1n,
  r: 0xa5f414351f8a8fd66ddn
}, {
  a: -0x9eae1b3f8acdc4623fab754ba83a5107e69b3991edf08a4fe0ee0dd2576896bn,
  b: -0x64eeddff6b8487dc86bd270fd2297c8aa121c5n,
  r: 0x192773bdfb9258e8f229564badn
}, {
  a: 0xe98bca463b543e0d14d8a1a6f3482830b7331847c14ddb0n,
  b: -0x6df98646095n,
  r: -0x21fa67f40c3edc0a838ef67295ba6a0a339e1n
}, {
  a: -0x673770f4653b1c0d51a08a2c64ba4bb9b0f6ce16b22n,
  b: 0x99161ab6d2c8bdc9393ee4c494d0c67dben,
  r: -0xac9ad58ffn
}, {
  a: -0xc3c05efea37c9398b58befaf320d1392cbececc988b16ea9f19bfca5cn,
  b: 0x315fcn,
  r: -0x3f6f4449c9c4497350cd303f7f5dac153877d61651ff9546bb886n
}, {
  a: -0x64903c2cbccb1b3b74da0a1ed46acd92d8abc3460485a29ffc7en,
  b: 0x73f1757997fbcb9141bc5ac6en,
  r: -0xde0ab28f1c02bcdaa6bd6cffddbn
}, {
  a: -0x1ddcfc27346dc43f5c5cf5f5aa6cfb16cceb5f7784n,
  b: -0x6cb78d088243n,
  r: 0x4651ef092a610cd5cab30b35fe0a3fn
}, {
  a: 0x823298ecc298df9b89fa5aacd4681794a07da05a709b68e7bab5n,
  b: -0x549ddba315ea5346b294401268f10c5n,
  r: -0x189e6b8507fc88ee88853fn
}, {
  a: 0xd3b02ffd1845afa0d5119f0d70b6d5e2016c70d728389425098ebbc9n,
  b: 0xd52080b60009b2920n,
  r: 0xfe4597f96ce193a794c91c3ca0d9fecede02a17n
}, {
  a: 0xec2f8871e5e5886a37c2dafddc1af2ad13f365888f297b0ed92e2526a060c85e975ccn,
  b: 0xb87en,
  r: 0x147bac0bbe097a3de00b0060f224e00656703bf91132441b006522266883a1067an
}, {
  a: 0x6ccf1de59816758506d1a5243fb6814354c5f0a86c882001n,
  b: 0x931958826b8a9e3ba560ddc85205fcfe1bn,
  r: 0xbd5cf0efb54f72n
}, {
  a: -0xfbac3f407dd83a7edaec309d4db32920ef306f92a7554eb381a88cn,
  b: 0x32d04e5d9a4d5ac7dc1n,
  r: -0x4f3ee453d9e259bc6dc71b7c95a284b49811n
}, {
  a: -0x5e365850439622c692d7d1ab999179d4fc28a462e098e4aafa9ddef3n,
  b: 0x11782521ce812fd410892ff49858e682f6d6910ad6c142f6fn,
  r: -0x5649ca03n
}, {
  a: -0x877e4038a49444ae8dbcd7e78eed57641a002a59edbab9409d76bff9171n,
  b: -0x7cfefc061d53dn,
  r: 0x1157fb23cd6ab234361a5f4f10ed77cc4b3d8f468f055bdn
}, {
  a: 0x4d1bed676a7ba3f5997e1fcbc5d9fca5df0cbdf92664b8db93dfn,
  b: -0x64eebf54cc8db23d63aae55a4a811264fn,
  r: -0xc3934876b973d958203n
}, {
  a: -0x89f9ba8e27ec1606427d4b5d4c974353b067d1566902b0c83351b8n,
  b: -0x384619adb13a6feb1362f6ad948an,
  r: 0x273ad0a6b9b72c8c8d9c5473593n
}, {
  a: -0xc22aa46ae596ad31d8627d5990376b9cb547f0fb13a405en,
  b: -0x1d5363cbaf7880720n,
  r: 0x69efbb9d9eb4dd10e73d6f9ee18558an
}, {
  a: -0xbd1c5078396bfd3e8cc4053f4db3259dc42b85a950c06a26f9ba0107189094n,
  b: -0xa92c08b7f0e9797406771a551756d3a9d366947517ca6b5bcn,
  r: 0x11e2c10e3b5b32n
}, {
  a: -0x4b310c0a1a47f8ceba03742be644342103aed907c591edn,
  b: 0x96a72e00e58bf7338214642685n,
  r: -0x7fc54d6e67ba39e0a637n
}, {
  a: -0x1aa86854c9b938e7f5962ed49a13aaa07fbce70086083a0533e5fc0657136e01n,
  b: -0xe50d3c30ce19ba25ee6b4db5d277288ecf5aa30f87ee93n,
  r: 0x1dcb4f5f7f9fba3a96n
}, {
  a: -0x33769532e7e8e6890fd242af40956790f2aded82b854aa6f2a3927dbccden,
  b: -0x347b7e74531119fd605846022caaad42dd4b02ec4a2cn,
  r: 0xfb0752215bff9c31n
}, {
  a: -0x80dd225dbe1266cf9da2de805667217ddd92f73e90c800e570b347da92a9fa00a42n,
  b: 0x79cf0d713c30bce3fd3b87cf251cf6ba2dn,
  r: -0x10ed3c2787c08602496e6f1b84b25d0552n
}, {
  a: 0x672c47c50d74fae36aaf4bdaed7313002e7db32a75d77n,
  b: -0x9507f92cb95n,
  r: -0xb13a012c0d7ddef9c3913400d5ec1dd89fn
}, {
  a: -0x3fed6f175c85b0fb32127b597658ca49dbc7bce36fe056d1ad8bbn,
  b: 0xbd742a81753baff816707b92ac9bde34c11a7716398d2n,
  r: -0x5661d7ecn
}, {
  a: 0x5d09b59fbc23bfc92c81f7855cd2cd9b623ac4de449b8c6bdfn,
  b: -0x6f26245bb1f19b715487c40880bd030ad7824c4a63n,
  r: -0xd6494cd2n
}, {
  a: 0x5a022433f4b3ee584100abe1d3ad0de16b2e341a8339da325e36c11d774d228den,
  b: -0x434b4n,
  r: -0x156690acc89db5a3d0d96a5a2eb203f9f658bdca022fa89c07bbcaf6301b6n
}, {
  a: 0x3ceb91949a2359115cf527866ce3359b15b5fcf238909a7c0b94b9ac3b5n,
  b: -0x136f9bbc2d0fbd4a7b2d258c97cd2b441a2a8af2d4cn,
  r: -0x3226853a657b5e279n
}, {
  a: -0x5b90dff84caf711c9114fa8bbf1cbc3fcc9f505f2d547f59111e8bec0eb3b0fn,
  b: 0xdan,
  r: -0x6b86e6213b853752de0a8b35b87fb0707f8e75de2723d04303a9be25a53a5n
}, {
  a: -0xc0847971b7aa59859b75422fbc47987a3b1be882df418c5n,
  b: 0xbe9d0adf61ac54dd5cd59ce314ef5n,
  r: -0x1028ea30372e89db7e7n
}, {
  a: 0x89c629a91f479300386607fabb429aca734c1a24b26d8e0d720e1c47dcn,
  b: -0x7b36e7b7f6b92f123ee49924f5ccbd1n,
  r: -0x11e400a83fc72b02cca72f884b04n
}, {
  a: -0x70f592403525db63452e3037c85b26428a4281db1b34971d1faa27ea9d0b846ce7en,
  b: 0x67e6ba511abee479e72771ea351b83ece1b72n,
  r: -0x11651587fcc560d782cc96d43f2ffe3n
}, {
  a: -0xaa3dfc90a00341f6435bacb4205b9e59d12035b54b078b5d015d7deen,
  b: -0x156ad4a82e0f19c3a85n,
  r: 0x7f2e54c351058fde872b0c8aa07d8affa4971dn
}, {
  a: 0x3fbabcd4a9b2e330d353b2d0fef1fc751691827d4148n,
  b: -0x2caen,
  r: -0x16d261ca9c792d97a3b9e1f167e01fad4f35da7c1n
}, {
  a: -0x11be8385746af72bfc51c9b5c273b95ad038f1963e72dc71dd7200n,
  b: -0x375b7ccc1141c7b1fd4eae0561e0d4en,
  r: 0x520ed73e1aa6b7920ad1ea0n
}, {
  a: -0xa9a76a3c4e319026d04a0d6b69e412f67ae5eb27d0b2acff4n,
  b: -0x47090db1d53a4263n,
  r: 0x26367d0b098b9653573949599006c9db06n
}, {
  a: -0x7a595e7930d0616b0be9a524e82f8a2e028680f2444309a5b471d6df81bn,
  b: 0x1eae3913820f4fb4f8d22edc5af7b38an,
  r: -0x3fce2f41931d0f1b941f8bc20d5en
}, {
  a: 0xee21fb08393075bf59cf58d4714dbf2c7fa210f5c52738f6266c749c7n,
  b: 0x5b34bf539b25n,
  r: 0x29c66022b481d64f1fa13df576853b3c0bae4a23560107n
}, {
  a: 0xfa686bcfba822926b5ac7bb02a5c93f7cad15a27a5d3bedc342n,
  b: 0x83ab8a4538ff38b148d57155n,
  r: 0x1e6db3d5f90cf393bc6a379f4896n
}, {
  a: 0x922e64df39883287a84886850dc162b650a7019816d5f5471edn,
  b: -0xd4155954a5acbdcf3e490f66d1n,
  r: -0xb07389720a0288e961950c8c8n
}, {
  a: 0x6a4292f31ad1645011d720e4c1f1c27d09d93f122240dfee1ff73n,
  b: -0xa17901aae96d31n,
  r: -0xa8772a2e7a578c448e5f02755a3f481dc9c29cen
}, {
  a: 0x8013d25d9b27deb012d3777377fac05ce0829270c406ef27c3ac9fn,
  b: 0xdd978cd400778dd6da76ad3fbe8e4181fa653dn,
  r: 0x93f6ff2a4430cba9n
}, {
  a: -0xb4e9259ee5d4b521f9f4a34a18625fcd3be07ac8cb2n,
  b: 0x541c5624f524bb86abc4df7n,
  r: -0x2269f152383ab1f391859n
}, {
  a: -0x344b92c8e423b55ba7147cabdefd6174f0916f1978e55bcd610897d1a0938967c56e20n,
  b: 0xc620ded3f1fc355f1d502d52a69f1313ddcc1a8a58628n,
  r: -0x4391f7e2c17ce0dfa2652c751n
}, {
  a: -0x478dc8a7e245789ec3a63aeb36293d752d10d240bc45d79bd31c3130a66n,
  b: -0xee7a86d4738de0934n,
  r: 0x4ccf9e6516237f7a311bce74a76c84c6315da5cde0n
}, {
  a: 0x991a5f0f64dcd65d6b4244d4c8adcd77796ca684db0784bn,
  b: 0xfa4eeb7a4e072d20e9186bb28d4cf0d4dd6dn,
  r: 0x9c959b147b2n
}, {
  a: -0xc54442900da61d20713995c9ab7a72e505faa2fee174b295e72b59dc1n,
  b: -0xb15b41n,
  r: 0x11cbd1fdfc063abe4911ce128ee4bb6ecdf372c69b4381cc0fd7n
}, {
  a: 0x8f2b333f3bcf296eb1fe7bbdff7fb7e18a99ff2c8b0bd2a61ac453f14329e4d6dc47n,
  b: -0x698n,
  r: -0x15b679d1c78dd353848c82632f3dd5847aef5129f0b08102239abdde384a4bf4e8n
}, {
  a: -0x660cc9d5f93e06e0b0b32cab1c1ae1c7ed289ebecb4245731c7b4e18555de20n,
  b: 0x6ebd12e62103f3f35a0e93621dc2bd38560c7a8n,
  r: -0xebea0187b87b94e765114d28n
}, {
  a: 0x7bd78dabd9c0ca3189801e2ca7c85855fb6ac1bc3f9477c2a109bef97ea2b6cfn,
  b: -0xee24bbd1f263c4786c6dn,
  r: -0x8520c0f5e6a606d86fc64a47c82fa095af63297cc053n
}, {
  a: 0x79dac4697db0c4ea0735fa829c3122236dd62a598an,
  b: 0xdef9f936ad597591n,
  r: 0x8be6d064ccb83f6bfdfc3bb6b1n
}, {
  a: -0xd844f9feb642f5936d66f2428f6ce186ba118cac21eddn,
  b: 0xa34d1845838be27116ban,
  r: -0x153093a3a8969f58d86673c56bn
}, {
  a: -0x2cddc3b3cf9491dc485cf27b5c0aac10e0bc357bce8c3aaad96d17n,
  b: 0xec0bee44b62991c060c197bb031acbc4n,
  r: -0x30a8aca79cacd577351ac9n
}, {
  a: -0xc9c3603b93b01ba5f1c9fc31aad3ffb7be50eed972fan,
  b: 0xb929aa2f1c7e7d3be91d170752d14e9e5c8ecc58ffen,
  r: -0x11n
}, {
  a: 0xd3daa6a94bfb20a3b7e14ad73c0d303e8b16ae3711fc7bb885ben,
  b: -0x56cf6e48febc748137ad49f8b3fn,
  r: -0x270bfcbb5a98767f62b8f4af17n
}, {
  a: -0xbcf0ba97aef92431d82ad5d822d0dfeaec07869fe1a1384dn,
  b: -0xf8a8427c6c6d8d9e483a4721441e9b5565n,
  r: 0xc285090d519f5fn
}, {
  a: -0xa0c2d2c39e43997ff025119a10cb9a0d75e39769b98b6dd4047e6e79cn,
  b: 0x2ba3f03f217463d5876ff075704d5817ab126265a83742a5n,
  r: -0x3af0b62407n
}, {
  a: 0x85d046b2eb36de7a8e8cd933d62841b35ede561c306959bfd9n,
  b: -0xad50472b8a0b9c79d7a8548n,
  r: -0xc5a7a643d847531ce3c53234702n
}, {
  a: 0xabef684f616ab67e77e278817269001fcacb7c0f05e48c089d6b0n,
  b: -0x4c5a7144ceb92cf846ac90a554cb5a4a90b0c2a542ca2b9f2n,
  r: -0x24078n
}, {
  a: -0x7976fe535b6ee6dd972365665ec913447b30668e53619cef08d88e1112n,
  b: -0xc04c542168b4ab7b8362f05abbb6c67ef54135n,
  r: 0xa1b3b51cb19464cab42cn
}, {
  a: 0x3886872a30947126b72fe7df56ba3dedb281180ad0db91578e7dn,
  b: 0xd3d3df5b400e6046046c3c4eac39b8e2d565d41b3n,
  r: 0x44501077894n
}, {
  a: -0xd167a5094c5261c559ba946a29851f1358f23138ae02e862ad1e84fbb0b188n,
  b: 0xff503e26431b539119432ae5446c8975n,
  r: -0xd1f7cc6c718b91f3bebb45a2d50320n
}, {
  a: 0x15a1b852f0980a6fb39900d73d09707e20593b1040175f6a51cdae729n,
  b: -0xa13f68d0b2f8n,
  r: -0x2257cafbbe8cf112779ff46b6172b483275e81c68c63fn
}, {
  a: 0xf4989ed890f36f45ff89cf9ce48bb9df04600bb3631n,
  b: 0x9711e5fcaan,
  r: 0x19e7cd951ffef7abc96168c3a61422d95an
}, {
  a: -0x7c506fb620da06850505b955ec215b674b0379ff4dd9a5a9fc57b29b594521b98b297n,
  b: -0x7a9620420fc2c8757538699895n,
  r: 0x1039bafcada04192f9f95444cdd396b51aa4667a1a93n
}, {
  a: -0x9613b9e2ffaee5d8aa97d2c5f403fe4992c1368a7fd0b8n,
  b: 0x45075595d7eff303ebe47ed7c5n,
  r: -0x22c93974a7e46924f0ec5n
}, {
  a: -0x450c8ab3a8872b65cb84e02f0fc54c03eaf580d3ddn,
  b: 0x62fdaa2067260fd980465f705429478f4f59c2e02n,
  r: -0xbn
}, {
  a: 0x9230fe9ee72cb99b43fb908ab920ccd08761e3b7f3d4cfn,
  b: 0xc23f02c02a2b6a17n,
  r: 0xc0aafb588731857fb5f396bfa50989n
}, {
  a: 0x91f5698b2b195d722f1c459810e287d665f9373b2551n,
  b: 0x994f993489dcb2b0f3cn,
  r: 0xf3b91bb652b17c22352e90d23n
}, {
  a: -0x7f2343e1728de23e81fad33c2b532c306cfac7a817ff57c5f5104n,
  b: 0xd6ea6d4f45261n,
  r: -0x97712607e9a2f04d329879f2405c4569288e4be4n
}, {
  a: 0xf81aad0463ca86e75c623d978aa55e3b39fc0e475c04a6e4n,
  b: -0xd2c88d15bn,
  r: -0x12d53a54ece345e3cb59fe8aabd1a4b0ee28f638n
}, {
  a: 0x42407c70678130f35b69a11d90ab6ef8b97ec27cfb4394ff99n,
  b: 0x82633a343016da6f91e77056e6e1040625ada3n,
  r: 0x8213d319207dn
}, {
  a: 0x2263ff132bf7a74424aebe3089d641ef95ec6a376b06c84648704ddn,
  b: -0x5af03a1dd4977db9f1n,
  r: -0x60d01129b34055b42de7e70ed25258195ec1an
}, {
  a: -0xaa6bcf979f7736ceb961cc9417f1cd5e9ec8c5d24488d8a9d5c4ed3385e239ac395511n,
  b: -0x5a5ec597c46052497f2n,
  r: 0x1e2c48525d4f55fdcdb63d1e94cde2bcf182b56dd115e7abe921n
}, {
  a: -0xf8ba16c9ff2529eab728ff6a9eaa2dad564f11145877eb70ec3268457788n,
  b: -0xdfe212ad908n,
  r: 0x11c6862987124bf8a5df41c567ea3ff7aad0adc1680b4a391fn
}, {
  a: 0x1fbddff6af580e5d4571b442769f27c2a47f3f56ebfbb3c7678n,
  b: 0x56fcee10d4f113e61n,
  r: 0x5d69eaa9e706f38c81c3e61eddefbfc188n
}, {
  a: -0x406ce76ccca208e2d517f4c4e96d60c614a0ae55d665a9d28254a02083edcfd7n,
  b: 0x45832321bf419943ed08f80289d5164009en,
  r: -0xed4421649dd1efda41f6a56b82968n
}, {
  a: -0x76255c0ed273deea2c0f4270881a23d7db5e29fc94b049685a78e8893c38c0dn,
  b: 0x6bc4c6214d5e59f2ef8ed861a572n,
  r: -0x118a69c344ae6a00efafda616b04bddda866n
}, {
  a: 0xbfb2d5eb1ddb64539f4eda26758c8eec9a757aa3a9c14cn,
  b: -0xa6fecc9aa995b1e910815n,
  r: -0x125de9a7fd6da63d8b0f832c68n
}, {
  a: 0x685bb595dc8a16ab791c4f6bbd9fc87623f901aa95bbf397701562390d0dn,
  b: 0xb3dbce1a8848b6cc8515421bd28n,
  r: 0x94898b347d3f5de1e8cdcebb71ea357bbn
}, {
  a: -0xf30610ca49ee05288daf854b00ff61ea9adde79817f5777c62e1ae0baa3d5d79c0n,
  b: 0x4da128471a8fba159c6e4d44c09998a1b6998eca8ebc5686n,
  r: -0x3216c3a9f4dd806a251n
}, {
  a: 0xb2dfea570fb64188f6d07d6ac3f4c26dc1691c2f793cfn,
  b: 0xbc06dbd1903026139en,
  r: 0xf38a1051fbd65f1d287f630f0f3n
}, {
  a: 0x4c879765634b8f1502ab92ef086d3af581df50e019698be1f00366d750f8cae2ec72n,
  b: -0xaf78d3ee2fc2346f3845acc2702e8728d05cn,
  r: -0x6fa69c54b3f3f40cf9f585a2dbb5f543n
}, {
  a: 0x17268b836eda8a3a002bbdc5b6f2f30307b9c8ae695d1ef3n,
  b: -0xc7f6ac3f902677155bd9ff8dn,
  r: -0x1da35c197d8aa2ca1c940fa5n
}, {
  a: -0x11ec276021a5541377cf3047177204880f6bc1fd38328268dd2n,
  b: -0xan,
  r: 0x1cad0bcd02a2201f26184d3e8be9a0d9b246032ec050d0a7c8n
}, {
  a: 0x44b8d5cd5d83cb771e6c5c508191f506314b586127dfbd16b3f722e5cbf7c4ce0n,
  b: 0x53ba0bc9c91daef86d1b5f78c97e1n,
  r: 0xd21f3efedb16879ae9dd6a4611041e7b74b3n
}, {
  a: -0xd0e29496ea40e602225f54f3130acf45a2ad5f29666cn,
  b: -0x5145706fc98fa8bb8cf947f3b4622cn,
  r: 0x291fa03d77b5c33n
}, {
  a: -0x9e343a49f83f75b319ad6fa36cafe84d1885dcfdd83an,
  b: -0x5200e032ddac6df822cd82f1c2dn,
  r: 0x1ede275dfcb9a696c4n
}, {
  a: 0x17fb49062b623e1e5dd8276b5ff1f70dd2ebd4a530252ccd0694cn,
  b: -0x996bf472c361ceba331690c2a39e14f31bd1b19c2bf1n,
  r: -0x280408949n
}, {
  a: 0xe472afd96a0652ce26aa42a28066459ba6d143f1b066cfd36635a9dd9e23da47041n,
  b: 0x7650b2ece8d8c10e25c60164n,
  r: 0x1ee4ba67818c46c8d6509c1e8d1cccb17fd9e0b2a18cn
}, {
  a: -0x2e7c9885f9ffdfc738a9e9a9d0a5b76fbe43b809fef9395fc10a98ff077en,
  b: -0x49ddf909aa7c9a6a8568f4afd064e0a53n,
  r: 0xa11bb5ea97bf1016f9ac7d2c01cn
}, {
  a: 0x8bc0d0fe416146ed066b743a3f29dd78fe4fe21f8526ac40dda23e0c3453n,
  b: 0xfcd5c3aefe0bdf4923b09802800b9168n,
  r: 0x8d80ab73ac5a6a646843ff7c627dn
}, {
  a: 0x86f42167e706f96d2aa24d2913d8cfe7382e18961978fca8997f6n,
  b: -0xc8cc309695b61f8a041039ae22758fd9n,
  r: -0xac0df2bbb7371439b963an
}, {
  a: 0x4bcb9f3188d3845cb44384e86b9731f456e21a48f0c0b0bn,
  b: -0x2c454d53fcda4b797f8f7bbcfbeebfd242b2efd960b8be1n,
  r: -0x1n
}, {
  a: 0x96ca0bd51f6950ca438223e2fc793557775da2b357277fb53861ad65db0073265n,
  b: -0xe10e652a752c81bc8c61217cc501d51e6434c021n,
  r: -0xab85939f2d8f4966f32244b5bn
}, {
  a: -0xa053c66a4b94d0948be14e9e41ab3f2da4b857e40cn,
  b: 0xf0898e17883af9n,
  r: -0xaaa23a8c0b803e0a5e84bef3e28fn
}, {
  a: -0x8265fdd6550056e924ada9f2988d0ad70a8339fd06a01026b07820bb79cddn,
  b: -0x17f320cd01eb46d724n,
  r: 0x571d6214b47eb821f60de87ec5215e55f02184914ad0n
}, {
  a: 0xda8fc09e7bead0b45f13f2a9c54e6e685eb8dd3f6d7b5516730a05e3d63e22f23n,
  b: 0x3bc80799cf988b2237625049cdn,
  r: 0x3a7f08ebada372306abf67cc71c8c3927a381892n
}, {
  a: -0x3aa9ff663009c65ba401a99a2b4762a9d5a9fa2fc7c410af9c86ff593n,
  b: 0x7df806d5d3dn,
  r: -0x77384d280615744f4df78ca8afecb9f08fd98be9ae3fdfn
}, {
  a: 0x5b0d65b0f5ef144fc3b5a5833114bb2801eec013545d22612b35299282891c0a4f81n,
  b: 0x6f108395290cn,
  r: 0xd1df62d6ebd4af28bf2fed6bf7bb365f05b2cdb5f2d4ae5aaf8a0edbn
}, {
  a: -0x8b43acedee9edac7ab823f47a51948e4dbb0de3910fb7be262ec90n,
  b: -0x5e26n,
  r: 0x17aacd7e47450954aeb44f7f1f2e2ac3f6dafe5133c42d45411n
}, {
  a: -0xf1e6dc7ca786e04d6f93d92d106010954dbfeb394892e687e1b7ed1c318d526e4dbn,
  b: -0xfa17n,
  r: 0xf79e5336745c97890876dfbd66c46f8c939421b47c455c775f39b944254dcb3n
}, {
  a: -0x34fd5aa1a5ef95065c4e30e8695832e6111df5bbd6n,
  b: -0xb141e52aa12579a57b0fa428722a8db6n,
  r: 0x4c8774c361n
}, {
  a: -0xa7089fc6d5487fa48529990df8455ff23de669b8ec9fd4aa6a6cbbbc0be4c57664902dn,
  b: 0x4eb10n,
  r: -0x21f6578305b66bd13035649807e215ec4014028934446f81d1b3e06133001e63bcn
}, {
  a: 0x452937f06fcf788550edec9e1b512024276d730f76723f3d30d2566n,
  b: -0xa075d6f94d83n,
  r: -0x6e5715921fd03a874edb19467ca708839b69c13aa04n
}, {
  a: 0x36bf8f22d4dbdcafa71c0800a353431cf556c5e122991a39fe7371df6343520459n,
  b: -0x469b810n,
  r: -0xc67ff015efe4ca281976852949f77c54030241d0ff99b4882c00acf296cn
}, {
  a: 0x111c667d8b4a4de8514df6765fce9ac27ffb7a3359ae2b613a24n,
  b: -0x3397588bb91e9c6689d3d992ddb5abn,
  r: -0x54e7ed8960c51e7b64f58an
}, {
  a: 0x43e132602ff8e5317ba12c09a16f5ee1cdcda6eb3c48359b6a6b2cafb218c31n,
  b: -0x96d3755f7197133n,
  r: -0x7336a9cf0095a057f28f4a540f8b56e5d58968a73553b338n
}, {
  a: -0x9be83622af7591aceb9b27520fb29abb01b469d8ef7a82a0ba8n,
  b: -0x43f48c7f07f86b43d5eb5bd7a65n,
  r: 0x24b54a4c650708773d2daa99bn
}, {
  a: 0x45a79edfece395c9012b356c30ac731e072dc128a9ade31f288e6dc925d1e002bn,
  b: 0x9a07c823870d3c77431ca61d657161ad7f15bbn,
  r: 0x73c4531e4481f865b334e06c2f8n
}, {
  a: -0x659deddc8ac4848a58fda0c89c22490a13d64bc39545423c02e8a0b27721n,
  b: 0xce136f8e06219f95bc6cf2046735d1607n,
  r: -0x7e3c145f9faca2390012e4e8a29n
}, {
  a: 0x6ab44b07dcb007ecc5177bd5e3b6fd4ec51a7bc182fbd642e1da932011d26f89adn,
  b: -0x7n,
  r: -0xf3e53dc8d3db7fd40ba36432087db0b40baa3f712b6432e2043cbe0028bc6ca86n
}, {
  a: 0x171540ce2a7f4ad3767656f0338dcec32855b31bb2db3f5a82919a4n,
  b: -0xef9acd4f2288685af46b294945ba4f49n,
  r: -0x18a99a3e100c813e05359ddn
}, {
  a: 0x7a8c1e4b58de2bb8cd648137dcec74fc3ee90c733e55dd5c458548c8ddb2n,
  b: 0xcbc138471c92f419b7539e3ed22030a29f2a474n,
  r: 0x99f85102c0f74567b0a02n
}, {
  a: -0xb1e342fe9093b6550d2e7947fb6cee1c6ec608edaacdf5c94fded2eb8d14791n,
  b: -0x99114f72ee8236bbf31193f202ae3f598f6735877203e1fn,
  r: 0x12982c0628144e3c8n
}, {
  a: -0x1ef1c9186623e8dc6745e9784596422abc08c0d144f0c3n,
  b: -0xdcn,
  r: 0x240213e48978e9baa6b7c08bf3e20bd4a2f2e9adb1f7n
}, {
  a: 0x26ee4b3f0bf9267a9f9be5c16aa3a7ecd1d5d8d02503a2fd1f85a7e582bdn,
  b: -0x976ac8da8107f11df42ef7f926400d29a1409n,
  r: -0x41d1f393797ab4e86676d2dn
}, {
  a: -0x3c09899914dece39635db250b6b892d3b5181bfeec3b811b8n,
  b: -0x989b41d234c4e7n,
  r: 0x64b6aa484228ac22d8e564fe06cbcfee706n
}, {
  a: -0x242ed46aee3f897136b4cd878b76b4473a0bed88ce68976ea60ed0485n,
  b: -0x1b2ca102a4dadbe99bed30b2a108f66n,
  r: 0x154ddebf936b3eeed9c19432c72n
}, {
  a: -0xb51de51270444c2384a5bd890654de5c6cc84df8127abae53n,
  b: -0xafba37684210d1f66ad466f91en,
  r: 0x107d9eafc3ebd7f1f3c81d79n
}, {
  a: 0xc9c688c3ad7ab1bafd8ab81968fdb0de85977ca89c8e83e049fa8f45e4288d0b4baf9n,
  b: -0xe0b14e7d94eaece74c24986d69f06b98n,
  r: -0xe5e3c8e665bbe4d4f05b960b62f2b0db8e870n
}, {
  a: -0xbb4821d285b3f83c2c83c449e4c4843046b5f84cb08bd0416en,
  b: 0x90a6ee2c10n,
  r: -0x14b71ca167a9f7d042f1c384889f93262fcd8730cn
}, {
  a: 0xd26c707a8f3ba4c6d285fed2795dce4bbf811841332845bbd3229bn,
  b: -0xcf8c7fbbbf8c2bca620b17ff015b5c7ddf21777c90n,
  r: -0x1038bbde74e38n
}, {
  a: 0x82773fc1bbba201871e5b08783ff25cea73d70c11c00n,
  b: -0x82438f28fada0n,
  r: -0x10065953eca768d9bcb7075e5104daabn
}, {
  a: 0x209e393ef41508c50e62976fb63898a15fb00c8439bf19a0473c7n,
  b: -0xa3b7a9290305b1e4bb898519c817d021fn,
  r: -0x3300fe2b17214bf26ba0n
}, {
  a: 0xd9ede8ae843cf7d4bb86908f5866579a6e7e856fdfce8139836a8d8n,
  b: -0x618f1dfc650c59f7993f5122959e7894856040cadf403an,
  r: -0x23bdb9bc81n
}, {
  a: 0xdc4204f7da0431d423085516fad76f18f783a36d3d5785a437cab6c6251cf4de5n,
  b: -0xe2b8331a56b575e4ddab4b04524d38485ddf8a4n,
  r: -0xf8b42f5d40962998147bb62724n
}, {
  a: -0x25d13b271403a3942300b9cde9913044cae5cc1c743efc0c6c8c7c9612e071e49n,
  b: -0x443den,
  r: 0x8ddde6313078a7376b3b0af35a59528eebaf5e7e14ca337d192d46a7fc54n
}, {
  a: -0x61b481a8f02773b1980d2fc50c2ef83f335751f8b1e777bcea448en,
  b: 0xa5f3631fabe6cc6010494b74b3332779e38ce19c6e249n,
  r: -0x96b8f4baen
}, {
  a: -0xe90e70a6041c9643ad7f09f8217aed2353f24c94e847e87b2f467b5875befa35b84b38n,
  b: 0xbd83297845b3783488f82ebea1eedf1a45c8n,
  r: -0x13ad22360a4f0cc9295244876a52ddc6704n
}, {
  a: -0x70b9f5f7db0a53c4edc8e8fe7aac8717a9e03d58e9a7d3c2bf969f00df8daf96bn,
  b: 0x40806bfn,
  r: -0x1bf661920b9d4b442b6b2bae433988d3fa008d5919d34910787b2a3a0b5n
}, {
  a: -0x4aadffd328a7a1a7a5adbd3cc4237f5c398f06fcc7349b1848a2cn,
  b: -0x478fe21cdd434dn,
  r: 0x10b271ce47bcfb396e9737ff1bd333b0c47b17den
}, {
  a: -0x40b11c9606caf941cf28d46a4b5bea026ffeea63aa8806fab1be32bbdabaefb01fn,
  b: -0xdff64a34087215f75ce16d55n,
  r: 0x49f230b34dcfbc468404fe2d9655c0cddf9c939d4bn
}, {
  a: -0xdc1f270fbf034e6f6043c8ad5dec23022971a89acfc4bn,
  b: -0xed44910c390d16493dffd7f7c6bdfn,
  r: 0xed800b53094d5cebn
}, {
  a: 0x3c6e48cdb2c5dc3118f9abcb21bb103afe23536d6eb4e7ebf15765n,
  b: -0x48779e209ea520e64en,
  r: -0xd57aca2d44a4769d3fc5fedc51fa99f66c52n
}, {
  a: -0x46292ef4258b1100ed94a5de7c9dff0fe4a0bf9639455f61acd05abf1d1f33c627n,
  b: 0xae0f0810d8342e7a47a9b674dd70544ce6n,
  r: -0x6730bc18bc5a421f644e51b6df815d70n
}, {
  a: 0xf6a96475928878d646cd7a017634b5e098df74c60bc259d79469217n,
  b: -0x9cb1bf2397df6a08f1c145271b0255cab3ef22827f61n,
  r: -0x192fc0bfeaf8n
}, {
  a: 0x29ffbfe5e37a02df5d65c10ae1391ce468f9b4bf7386f957d3f59da4f59e43ad535n,
  b: 0xf62670321b872529c44b26an,
  r: 0x2badfccdbaf61468f976a53c05590a17895d12a84a1fn
}, {
  a: 0xe882f9f4405681ccca698bf139c44fa4797557cbcce97466c992dc65e1292f302dc708n,
  b: 0x290d3ee2caa564eca6e57b646188162b1adb5cea79fn,
  r: 0x5a9f33ad98691c137c300c3a45ebn
}, {
  a: 0x88d11aee9a4f88792139e354b9ca89ee29795c3b3ebn,
  b: 0xe486b153b75a83716ae3fb67cd684f3e51n,
  r: 0x9943e4306n
}, {
  a: 0x4b52e30f360bcdb10ec842013ce737d9bcbd894bf615d57fb89d1274f021een,
  b: 0xbfd474ebdc09cb1e0636a023a27b8dn,
  r: 0x64855015462f1194f771de8e79f365fdn
}, {
  a: -0xca70721dabd7dd602babf2f99577b4f5a8e53fd675ab9e4814b2d3760fc7261536e47n,
  b: 0xe85c0a729814f625d4394e014ecdf7ebc3d49n,
  r: -0xdf091c66eb3ee0ce7c1843ffdef407c8n
}, {
  a: 0x4a5237537fd5ba97f385f47aea92a9df2aac853f41502995b3a951276n,
  b: -0xb310e3501b733c0ddf8e5af031c0ed1dfa83n,
  r: -0x6a40a73e2afbb81453dc0n
}, {
  a: -0x2a0ac65408f27ac9c03cdfbf7960e8eb6182df794e60f4191d160cffbdcn,
  b: 0x86ff6f9cda1abf2400041818bbee935b108e8c304n,
  r: -0x4fb9be3026fce20037n
}, {
  a: 0xa971417cf866b5f3bc20fe3070f502f326e8e184211855d88886d7fcb89ed75b1n,
  b: 0xe3f5a0aa04e560b48eb7808ddbea9d2b669n,
  r: 0xbe48f1a0ff2083741ebf8a805f9a90n
}, {
  a: -0xfcd3de1395b00a2ad1f0fe5d06edc2b281a6de5dcafn,
  b: 0xf6b1c7028a8a774e769d242b2d2e27en,
  r: -0x1065d50c1272en
}, {
  a: -0xf7aac09bdc56ebb40f1be4bebe41bb7ee98240b929e00n,
  b: -0x9b4a54n,
  r: 0x19849042f638a12622c18aa5b8252a34169c199bn
}, {
  a: -0x137551619a4b69db7adda6945ed544b1e0b758fa1a101ae4dadc7fb960ed44417dn,
  b: -0x5b8b5a9cc8dfb751140b22n,
  r: 0x366a0cc517d2fe9371e888a23d5a645ecb77780b35f2n
}, {
  a: 0x864523f8d42d773b928437d3547888e63feedc1f2bb7cc81n,
  b: 0x52d240b3f2aec6a77cad86ab42fb65bb6fa268n,
  r: 0x19f071cd974n
}, {
  a: -0x3b7bf8db403ff8ba1acf61a928cd6bcdc1ecf7c2a99bbf4fdd9aaa535n,
  b: -0xfb4112129f984aab3c69f6fn,
  r: 0x3c9b9b19025097e91d7c6f9132215daeden
}, {
  a: 0xf0c15452dac1aa6e9d56c07ce771d63848903e2ec81880cfd0f9afc86285d50a4110cbn,
  b: 0x8539fn,
  r: 0x1ce9f0bf0c629fea8811ceeae75196d495bf470b2189df1b0f28281ad8b2e79aa8n
}, {
  a: 0xac88736367395bc1ee2824ec70a697ef636a7febe3ba9aff8fcbf354n,
  b: -0x41d84a790a77ce8n,
  r: -0x29ecba32a2a8ae9281f01d67370137f24b8dfce318n
}, {
  a: -0xc0e725bed85017737643885ab58fe070cb4ac16c7e64f4bc2d9697151b96936323fcn,
  b: 0xf79b78e3528e4d0f0e9ca994fc9b641f21f1fb6bbdf4c1e1n,
  r: -0xc770ff1e613cd73b8979n
}, {
  a: 0xa44ee08d329ac92b3873176d9e41412b91cc138c9d8f304d1aaa3152e01985606261n,
  b: 0x8cc86e325cf5117b46422d5n,
  r: 0x12ac73b0c3761226431b6470227e5a7d53bd400965e17en
}, {
  a: 0x9b683a364ce77e53563afb826c00c432667c7a052836509n,
  b: 0x1fdn,
  r: 0x4e295b23dc3e1c54295b870bc7abe3ef19e514a18664bn
}, {
  a: -0xfd16857749fc0ba0595ca9765cc641fcb7fc1470a88bd24n,
  b: 0xa814n,
  r: -0x1817a85eef8dc5902204c66d8e1440d36611f39e7d2fn
}, {
  a: -0x5af26a966e5d19ad55fb57b13666227d78f1ff402dan,
  b: 0x1554e3201800e96fdfd1dd222e557915c1f251e0cn,
  r: -0x443n
}, {
  a: 0x6a9be472bd605fca8e4c09827f1df330d5a354b5e21n,
  b: 0x620b2a541c58b099n,
  r: 0x1165d6455489416081e8b8c298f0n
}, {
  a: -0x29a79eb8754ca71ef623105ef945a160c739baab76bbn,
  b: -0xcdf1bb64c1f6b4n,
  r: 0x33c776afa27b53e0727b96c4b37a7en
}, {
  a: 0xe5f1633edfb5b9e27d94cd6b88e07277c3ed6ac66765dn,
  b: 0x399b784d8b3a540d8b66ebea8n,
  r: 0x3fdd6c5aaa7eec4a1c849n
}, {
  a: 0xe3871c8c5ecf51b3771262e236aac2bd32731599595an,
  b: 0x270n,
  r: 0x5d584039967c7049a0709197e1ea288221d35110f6n
}, {
  a: -0x491bd7cd374e4be4a66f7b29c72858ec7f21877794b6b90a3c68d04dda9n,
  b: -0x25c0e161c0981an,
  r: 0x1efbd1f394dfab0e6de577df5bc2c7cf4f18f135c7491en
}, {
  a: -0x2a5bd0823bc1ae064e9e220464a5dfcdb7f4a7ba1be8056b1b398a56e0b02bdf1cc7n,
  b: 0xea8b609f2dc2f776da9c7f6110959b282b787d4462n,
  r: -0x2e3bc7c47c75bea8c39bc31848n
}, {
  a: 0xb64064407787e527099d146c2ff79804fa225d0940e5b324527fdb87f56d4c41cn,
  b: 0xf05948504de90a4048fb91d897af82dcb3de60f22bb3cn,
  r: 0xc21e9a6e29c47f8fb914n
}, {
  a: -0x585bc3342b8b19efcccfa082bedd2e187c5a7a5894f31ee424a45e124fa10798n,
  b: -0xc8678120b4bn,
  r: 0x70dee20ade634d4dd76823789144226664314562233397a3e0ccan
}, {
  a: 0xb7383a0e12ef9862e6304eca4c9fa36acfbdac0a48148ecn,
  b: -0x7547ac3570d3bc6e620ab114681n,
  r: -0x18fef0eb55e1432b8794an
}, {
  a: 0xdad54c814fbc7b35b88e469b8e4f7b57339278323fcbb037775c22n,
  b: -0x266n,
  r: -0x5b3d6a1ce60a3509e3e142f6a4672f418b1435732dc72a9e36c4n
}, {
  a: -0x6d8d5ab1b6f82fda1b5061cf8beb3946323adcbe3120c6e705896e17da64n,
  b: -0x4d794324n,
  r: 0x169ff9c0dccff2028eafcf2b229f4cfe1f7fd9648ddbcbb9195ecn
}, {
  a: 0xc6bf36473977d504f66643be34c2a9047471f381647d3c0868b92fn,
  b: -0x551adn,
  r: -0x255d7a18662202a3ddb3e764096f3806b1ecc296752632436bn
}, {
  a: 0x6321d8187c1f41c189c886827c0a741ddfc263057d2f70402bcd0a67758304f93039n,
  b: 0x863446398f29184750fcc6een,
  r: 0xbd1946db0f0b8f33ec0567cf81ac310e01b327b2e064n
}, {
  a: 0x8f0e6c45d52c30a0ae6394957e7dad247069790ad4fdf43a282a46n,
  b: -0x164d52b3a1f31aec9f8694d519379dd799979c6f5n,
  r: -0x66a1c548107b16n
}, {
  a: -0x99a5e685129bf2b7b52726d5b174e6edd5a28c96fef4d38e5a8f4930ba9806n,
  b: 0xfada68ca8c0e895b9de4183c688ee5c219e6e9ea597n,
  r: -0x9ccced63f34585cae77n
}, {
  a: -0x77d0fd41c844aae0b51245188f7f16ed9cb3a09643409d6ae7n,
  b: 0xff5a7e256122f9fdc3cfd9958110ac2f20ab9an,
  r: -0x781ea5f0c2b4n
}, {
  a: 0x6e5e1b315baabd6622fce09bf3c083175272f81e5e3361ed804a6e0n,
  b: -0x6n,
  r: -0x1265048839f1ca3bb07f7ac4a8a015d938687eafba5de5a79561bd0n
}, {
  a: 0x30042ba0aaa3db452e49751eee4e7087d7d0ea2fc6c4643ba0681n,
  b: -0xbbb63a603n,
  r: -0x417bf88d5fe64204f03e705a34611849f45e9dccddden
}, {
  a: -0xba538775f175c2940a7fd52e2bc420c8d599f5c79c919edb0n,
  b: 0x90890e91n,
  r: -0x14a050e2e7e1dad45ca6d68f0a95c417de44178ce6n
}, {
  a: 0xbaa0fe1fc01486e36d872bfa1e50a364c541f73e18ca931734a57n,
  b: 0xfd182f4c2425824a66ead54fee291ae824f12e479056eben,
  r: 0xbcc579n
}, {
  a: -0x3e29d05f93da4a3298dae7e94be8bcc0b9a39b0b78a4en,
  b: -0x7ba54f907744ec693881n,
  r: 0x80b474aef0a47de2604565b96n
}, {
  a: 0x58736c28391af7b7b158d0448eaf5ebb2be9235ea50448f2665en,
  b: -0x6876c457380859c79dn,
  r: -0xd8c21e9ca77fb79a2a96d33b54a5598bf9n
}, {
  a: 0x1dd79fcb2fc3eff03a600e34314b87f623d24f6fac2758c3d48d3eaa0a408n,
  b: -0x4705105d88e05378a56dca06b7b6n,
  r: -0x6b9203d7319fb3120aa7fd9bb6ffbfaden
}, {
  a: -0x8fbdb0da91e6e8f10fbe6051fcf4b77e4b0db5501a01faen,
  b: 0x92c0a9762ec04e61cb73058n,
  r: -0xfabf17c25a7071e5a40beb40n
}, {
  a: -0x2ca73eb0d6872ec7802f170a526f04efe315b15e24274a5fe3cc76a1eec90d368e00n,
  b: -0x5a07en,
  r: 0x7ef86e5c485c5250fa2619efb691db977c9600b88433d621378b09306d4912bn
}, {
  a: -0x3e9cab9420e95c898d660268146e4c20877f49033f38f57f2efn,
  b: 0xfa6d18ec39bd34efbn,
  r: -0x40016d4d3444145433ec5ac79f6cb75161n
}, {
  a: 0xe3a3e1cd20d41c64f17c94f2b275b9ea00c0a4e1e1f87n,
  b: -0xcd11c5709f4d29f8d5n,
  r: -0x11c2d2640b833ffeec14022d6470n
}, {
  a: -0x95d6ace66b651c92573644d2332a3ea5c5b5c0015916d8da0fcab257ba20a5n,
  b: 0xfc285029c77ae5198283b7504bc570n,
  r: -0x981f3538680a95530d1d3a24328c08f1n
}, {
  a: 0x4e3f8ca08903aa3814652a19bcfdd0533b1f877677bn,
  b: 0x126fb695n,
  r: 0x43e85debe741261d5cd57f94f575b5b6ed3dn
}, {
  a: 0xd8667e284e8ea04dd40642ee12e31db2abf697c2bcf4aan,
  b: -0x183b0f39b48ee6f3c91eb2b5ff46e410d0cb9e5c7a721n,
  r: -0x8en
}, {
  a: -0xc781540c40e969ee90f6c38ac1743db0830f8043591fbd7afcda26fa41a044479643n,
  b: 0x34dbed1c48f0f96512902698f134cf9n,
  r: -0x3c637749a9f1ef6e2d33a36851684d4817ed4an
}, {
  a: -0xaa1f7a4545ff52ab8fbd493a3ceb34fe91ac3e632e4n,
  b: 0x6f1b8491386c93d479f665f9cn,
  r: -0x187f9df9023f85226can
}, {
  a: 0x66f4bc196b1ef4ea61d5102876ef90d88a73960ff34de29a79879f650896n,
  b: 0xcf111bb027b5791f012dce3b40482c369ba034n,
  r: 0x7f493fa6ced05c9a1e6b08n
}, {
  a: 0x98065dcd8aa64736d106a9eff9d4dc56e9eebc414904f9n,
  b: 0x1e2e89850c39411acbf77dn,
  r: 0x509771fb2abb65394273fe266n
}, {
  a: -0x4754cf99fa0c8195e7083209e17ccdd1cb707912be0n,
  b: -0xf33b531537d6577c5e956e13b3ed56987d2fa1400abb4b2n,
  r: 0n
}, {
  a: -0x5b48f28a10c05214fdf9a6dd5a7218fd93a11bc85ecd3999cn,
  b: 0xa86a34dc21n,
  r: -0x8ac21ab12c9b47a88b558633ba6019473f0fde5n
}, {
  a: -0x3df26f3b6a1d1a004da38d49996dbc89464048408f87a9d347n,
  b: -0x952af07e5bb49f45dben,
  r: 0x6a5011904fdb37c3c50c839e0bee7a4n
}, {
  a: 0x7f1677cb4a497657f9ace461c349f0f5485b96336642a02f2n,
  b: -0x41af7d3009529d6ed2ccf53da4a694n,
  r: -0x1ef4e81a30aee28ad529n
}, {
  a: -0x5412b2ca97d49b37e568a2e9ab5da11d9c9d384a8561b154d642953e63n,
  b: -0x477a0f9fe8c3n,
  r: 0x12d1d4d5648d455ae189269386a5d5119ce62c4965ac209n
}, {
  a: 0x562ee754c455752bd5bc7d1d03bb2d1036cf2660a27dn,
  b: 0x4e0393f4bb34b90f0de508e43ab99b4b9e65bb3n,
  r: 0x11ace9n
}, {
  a: -0x9245255bf0eb224923cad408a16f74132642efd714954097dac6bf1dn,
  b: 0xdd6b59bc80a0b48abcc82f291468af33fcedn,
  r: -0xa91d39c2bcd33096ac2bn
}, {
  a: 0xf026bc5cc922f8a6231df92f280b4047593419dd3496c6db583440ad677e34ecde17dn,
  b: 0x3286e6e79f297a160de116dfe75988n,
  r: 0x4c0c048e657702f034a3a7f3d518f0d1ec25e19cn
}, {
  a: -0x63b36434e6b0730ea2a7760490a1771cec8589e21c99n,
  b: -0x6da4560ec714e9n,
  r: 0xe8c9e095c5cf1fb5585eec970f2fb1n
}, {
  a: 0x2fc482c39214de08034ddcc0cba11d5f48b3fced39bc5586d53747a3b4c4c3e4cb28b6n,
  b: -0x58b0cb5e0ee34206087fb4bee6d887dn,
  r: -0x89e0d929a4da65fa8f2770a977c68439595b113n
}, {
  a: 0x55844adc02d74c8e863fe8827f7cc0ce12146836fa09cfd0cd971f7a46d240d924dn,
  b: 0x4660d7fd5cb9bfb9b4b6967202d53e8d09bf0n,
  r: 0x13710e306b44c803b8a482953370f4an
}, {
  a: -0x1bd4e695fb85f45b74cfb5b278801179f498346466dc771847f1278e4aa4d0b3f4an,
  b: 0x1f83bc50cc920569d8e81884n,
  r: -0xe21524d0988f9895c4335ffd0e168206f2d719d6222n
}, {
  a: -0x16f46f4d7e50541b991a9b57ab25fb1404e77004b1c1e38cdbfd79ee73cfd2cn,
  b: 0x575a2b7aa7086ecf285951b30bn,
  r: -0x4345daaf83834475c61239289dd5f66055d3en
}, {
  a: 0xa17196cf342cffe1a5b9434212df6b50229af4cae2fb24e79808c457ce163c28ca0ab8n,
  b: -0x8fef02b0d4845c66f50685a6b876b823e8fd5dc2n,
  r: -0x11f24b3f6447abd7dd7cf86ec013dd7n
}, {
  a: -0x699b3606e5e21debcdb2b6adc5606bfb6a2b6d87810db976ad3ab40e667008bb4b5cn,
  b: 0xcad9e06ed9dba86ff18ef1ca67e023a5a9be4f301d4de23n,
  r: -0x8546b1c1769296bcf187dn
}, {
  a: 0x88516cec0a514a2851e22048bd36c5149c13b787b3ce4f6031n,
  b: -0x5d5a58140978b9b4147aec8f89e6caef4c82n,
  r: -0x175d295657e9e57n
}, {
  a: 0xaae3ce788569bac79d34b1586a861bda7a8ac506a07n,
  b: -0x50d2afcd65d52en,
  r: -0x21d477a00ef07981e6a2fcc8012bf3n
}, {
  a: 0xc6e51da3b1c6ee8aac70fe4d07b4ee99035c653c8a2c8cd008636b4d982c2524d9c3e4n,
  b: 0x29ee7ba26345d40aa95c8f0a6779657n,
  r: 0x4be4a64290fbc967dc4db0f634e45a4827814720n
}, {
  a: 0xca9a9c5506a498137b728f9570eb8be714a9b5d717fn,
  b: -0x464ebfce84n,
  r: -0x2e1b5b0738bb762bc9888a64c2fa09afden
}, {
  a: -0xfa38563de4f7aaea79fce8ea6690f0b4e78cd78977c6b76d9bb6e50353cbn,
  b: 0x42bdc982966be56f05da2228fe579d3ad1681dn,
  r: -0x3bfc51090e0e6b706778401n
}, {
  a: -0x3f9d8208da1a4bc9a12310a66d5168c189502cfbe9d0n,
  b: -0xa08bbn,
  r: 0x6570408dcdf65be09809c48337f2e8a38db60f8n
}, {
  a: 0x7463f6988da642e552be8fa1c73eb39cfaf3e871377e4f27f7598505480f6ae193en,
  b: 0x85e181ff90e77b2fd07n,
  r: 0xde8e465286b6c6845692915a7534850bbe0d8074d719a357n
}, {
  a: -0x1dfc751d7090e16eca2a8bd740828c37c2b466997dfea9072eb522cn,
  b: 0x99n,
  r: -0x322c44cb317845534eeb2990512abf1c0b37e2e2b4b276d825fe8n
}, {
  a: 0xc8452d3d0a6a5ec2468fcb52f3c3346b4dfcb535216099an,
  b: -0x783253fc8d8eed0c85d0dc7n,
  r: -0x1aa8b59c784e97fe28bc3383dn
}, {
  a: 0xbfaa50f7d7adb6ce327c7e804abf61abaaa85017106c0d3b914n,
  b: 0x370e81950dn,
  r: 0x37b3258f0c41d85aa8a114585e599a810d1401b159n
}, {
  a: 0x62cc939231dd7d29937c9181f7d84add81c67d9f4efef3abf25352a22085cde9n,
  b: -0x954n,
  r: -0xa976e9651ac8aa166dc0a73fd691708bcddf64faf46a43305d2e6fb82d7e2n
}, {
  a: 0xb9d55f28755010b3e164abe17e8d2f75f4dfac573644b95031c05742515n,
  b: -0xc69195993623be52cd3bbn,
  r: -0xef94d90342a02bf90761785886ceeb50611b1an
}, {
  a: 0xd574563a503a4546b1af5650e82906cb60e2ae99a8300n,
  b: 0xbb57acb132d648099fb8eb572eeeb4f8445b3e75fd8cbn,
  r: 0x1n
}, {
  a: -0xaf8c6cb036cdce01f09e44447ee28356dca0b22ca89145d7ef8be1448fbdcc15b2512n,
  b: 0x269d8eb56fdc10d89d2c7d9n,
  r: -0x48bcb2a9eb3a7fc6584b04344736c45330dab71cacfadc4n
}, {
  a: -0xced4cb0745b9afefc61cb9223e7cc57d30fe31cd5356ada32n,
  b: 0x3c5578efa1e6aa7dd0169e1f504bc6d3n,
  r: -0x36d98addff04398ce1n
}, {
  a: 0xf04c96f324b1c92f6dac6a93c20d3d094a3aec16cen,
  b: 0xc9bda40867b9585e8441cc7169ef1e17n,
  r: 0x130edca84d0n
}, {
  a: -0x68f996cca696461c222d4c1a5ab58ec14a29c1eb0d96d1a69b64627d33n,
  b: -0xd62d5dc61n,
  r: 0x7d793ed5831fae76aa27e8c7ace960d07a0fabb1ef7a6308dn
}, {
  a: -0x9cab010e0498f8c26e5e357268396ee913682007d28dbe7140a2c0273447e5a32ed552n,
  b: 0xd6f9d5a3d1e2fa0c8f000db49cd88a4n,
  r: -0xba90aaa56c6ee236fea06cddfc273cdcfd389can
}, {
  a: -0x52593c443b607f2d5b680b40da19ee88a32d71080edf11f30136454n,
  b: 0xfen,
  r: -0x52ff3ab9aebdfb23a2ad660cf401f26d7e29c4913141951d3badan
}, {
  a: -0x802d463c6fdfd9e53f4d1b4aaba6687fe25483c2c9bec21f96b12c4n,
  b: 0xdn,
  r: -0x9dc1918575ffd11a268648f970cccf6251a318523360eeebcd28d4n
}, {
  a: -0xcbffc874a694ee53416740c1926fb16954814f9542df4c4a7c40e9a2448dda555bn,
  b: 0xfe9c3223cde3e48be4ad1c27ea66869359e54e80c66n,
  r: -0xcd1cdc6ad833e16c3ebd0a2n
}, {
  a: -0xec96d34ea79b42c04158fe08d028038ae18b64ae80d8e2580146a88819512cn,
  b: 0x6dn,
  r: -0x22ba8b0de4eedd2ca94c79d704b85e770745c851fb6d573e3d4063e5015e1n
}, {
  a: 0x89027d8cfa995928fb3ed5a9926317a2ce8c1de09a79c54712a087ff006n,
  b: -0xac4a8a76a879c42dfb71f310904c6c3869e4e29dd19f796n,
  r: -0xcb93aaccde2an
}, {
  a: -0xf7d0247faaf80d46a43212a3b961ac09073dc6c734299f3e806e6b08fn,
  b: -0x7e1e08a1c16c060e18c92172791958fb665adan,
  r: 0x1f7065b01f581e58126cn
}, {
  a: 0xae679e7a3ffc5cf1a63884aeb2a6b288e6495c8a3f9429ba49dc0ed06c2707926d137n,
  b: 0xc9831357d2c99en,
  r: 0xdd9024e75d8711e900c3c7b13d19fcc67c4cf9a2091dcb88c90e52en
}, {
  a: 0x8d9fc97864aaef9b6cdf42e45ec4a58167fb801a2aed0a4fb9026515a4d38b5d86d7n,
  b: -0x73384c0863e922n,
  r: -0x13aaa7e42707425b8997522f71b638ad2c941440c4fdd3ab74caa48n
}, {
  a: 0x8b5ca5e7b4f6b3b50bda03f8ca7f83946628ed0d66264b8599fn,
  b: 0xeabe79900235c8e47066d2df497n,
  r: 0x97fb26a84640f8695b912141n
}, {
  a: -0x5d5f3e414d4dc7d9d2a24e8ffc138e7b97ca292507749acb3f0509n,
  b: -0x94be4ba84ccb8eef4aeba6bcd7cc5ff4eb7dn,
  r: 0xa0b386176a9608abf3n
}, {
  a: 0x99eabc9bcf3ca2077244849d0f904867fda3f55d661441fa9086b99ba0faa6d9db76bn,
  b: 0xd7de6ff3c68n,
  r: 0xb687e6ea5ae8eb4f0c0956b0f51275388df595290916b67426cc1b7532n
}, {
  a: -0x99c4dae0749b237cb2a6d4806eaec5282b3d4336475ae3cb9dbc82f9a1cb6n,
  b: 0x6df0f0ce079b39a0b1fa1ccfc3ee2dfa348b8n,
  r: -0x1660dc5ab9a48fb499ee6781fn
}, {
  a: -0xfa8cfba528470d871208f0815da1fff1c89331f28771924960acafa1804354313cn,
  b: 0xbafa0e60b46f7ade5311a970ff60da1d3394d571cn,
  r: -0x1570ae1618d84152cfb20f06f5n
}, {
  a: -0xa4744956f1a8847b536807df7450da8431af512d76a7bc436d9a0n,
  b: -0xd3c6e330d7d4c94fc50fb81df83n,
  r: 0xc6cba315013cc798062f958cbfn
}, {
  a: -0xe0662238bdf2556f8f725a239ea443e43537fc2ddb9c6e227f194fc2ffbbfa6431n,
  b: -0x71630c5c642eae87d2f601c19e2108d9ea41d20bf78cn,
  r: 0x1faa35e33ab3592463ba7c9n
}, {
  a: -0x379bc155624cd953ff81dd93f9e03a10afd2d329cae95f9fe7f3108047639c7725ean,
  b: 0x3c0d3ce1296f568234f6c857295n,
  r: -0xed0eeb861483cb759d38b7c65e3e485053522cb76n
}, {
  a: 0x11a40a35335963d0cc0061b0b8633b384052afea29633ca76abdabn,
  b: -0x37c4b638eeadbf713899b2n,
  r: -0x50fa7caf3da539bdb70a94e5478dd849n
}, {
  a: 0x6f13ee308de87d359508bbb7c474cd2925ee68f68a916bd4n,
  b: -0xd32n,
  r: -0x86b009ee2e44cc919b18af7a56575db6846351f43a48fn
}, {
  a: -0x4e70baaf36a445e03928ed561ba67659a833ff84d4463336b98991d31a7b540c7fn,
  b: 0xe824ab62ffe09de425909n,
  r: -0x56805fb12a28638d55a112405ab05a7df6793c7f299ben
}, {
  a: -0xdac36b2813d7a1e0bf2f0e5cd0b70acf0ed6034f2ebccn,
  b: 0x59dan,
  r: -0x26f49c76b2ccd9abaebe3c1e81a13a9e4576935d5dn
}, {
  a: -0xe19f5f3f2e53237f5329cce8d1e5eea8342100cf85e366e93d83fa38068n,
  b: -0x33524aedd0ab29e7e280fdd7087ee4f96b16a604c7addn,
  r: 0x4657166fa915159n
}, {
  a: -0x4326d27605e8ff4db5773f539bc918c4043632363d9d0b420e16371345711be7d4dcn,
  b: -0x6655e7c77c1e2a851dfdcen,
  r: 0xa7fc1d438bad33c842b36e11166c5ba2d7b47adc4c5856n
}, {
  a: 0x6bf626f07770b102c47db6597478485d7668aa7cda45ce366249832ce94dd5a61d7581n,
  b: -0x83e38feb08ece65ad1d4a3cdaec333f21ac2b3n,
  r: -0xd18e693cfb34927a8964e7a28d41944an
}, {
  a: -0xf0b1e7ea75708e98e835d82ae696e0f9be1f7d27ac337d3706ecb9n,
  b: 0xd302cd87d875436ef5d8cf68db8cbb72ffn,
  r: -0x1240349568115ecc181e3n
}, {
  a: 0xaf62a11e121eb78210ed6760da16cf04b9611cafbadc5n,
  b: 0xec9926fdb05971fn,
  r: 0xbdc472c5b53574ba6634cc3820e9b2n
}, {
  a: 0xae35905a2a58c05b4d977d2c85fe4bbd9150649fac0f5d147en,
  b: 0xe40c8cf8dbd2c6489be4d45166ff4bd72n,
  r: 0xc38fb152269ea6608n
}, {
  a: -0x7120d0a98420fa65f6ab0ae45c79199b097cca2333c2e9f259n,
  b: 0xc2318n,
  r: -0x952247f63cb90e0250c9224f798aafe301717f97cb194n
}, {
  a: -0xc5a77b62ab85d169c5cb597d21442fe4a8c9c74b69f620341n,
  b: 0xe896e45482c2717bef7d962e7d7795cd2e94eb181n,
  r: -0xd98c6b1dn
}, {
  a: -0x11e4e68b5916ead82ea2351359e415b244f94883c2aff98516818778f754544a2n,
  b: -0x6672ad06f484f9f6fcd86d7dbb70256a3c45a54072bn,
  r: 0x2cb6e4168257464d2d759dn
}, {
  a: -0x7c35ca5dffb4a7a9fb92db32acb0e24a00771524ba598dee279e0c122ban,
  b: -0x1c2fc48b84459fad8f86a5788bn,
  r: 0x4681e18e9cd89a8d41570556340f5e110en
}, {
  a: 0x13723b68d2853a343efc07c3e987760a497ec3fa76e2fa49d5e12e7en,
  b: -0xfe27ea1564n,
  r: -0x13965a4c9884e0bf9d1bd30eb41fa5371a552327ea3b21n
}, {
  a: -0x92b6c95b63c0737e5b189825a09677111e7af6afdf23179b487aa87d9n,
  b: -0x5ca83e0155a965c9d24d4675784n,
  r: 0x1955a2178fded273f612b854c2c48b6n
}, {
  a: -0x9b023246430e8d8de6bf2113cdaef8f46096b457347n,
  b: -0x57d88cfcf75540007a1d50b3f0f687171de92026c7ce01bcn,
  r: 0n
}, {
  a: -0xe8c1e5dc8f756b1a0589846a6ab1c4dd2a07518a013b89cee4266n,
  b: -0x5bn,
  r: 0x28eca43208582956285bb201d4de8d83b89ed342765edd27308dn
}, {
  a: -0xfe8539d56ab06fa9aeeed796bd82b140cede7a9e93d2c8n,
  b: 0xaa8b3cd929b04ac10a49ee5f0f5n,
  r: -0x17e0e322b4d0e617aa51n
}, {
  a: -0x31e1fed333ceee4a9cc8701980d77e9545ef1313e3eeda9f147f30b01cd9f3b2an,
  b: 0x71988ec50b79e6be816n,
  r: -0x706a7c631fa8627c974ffe8893555af381d71a86021a86n
}, {
  a: 0x29c233c9993c1f15d7663a7c264d457288d1200a8c8192a6a4f58f11572f4c8e705e58n,
  b: -0xd49818ef504fb9db1262b36ead05bn,
  r: -0x3248d8eb6e4801b77578abd7b3447decd8d1f4d22n
}, {
  a: 0x81e327c43bb01c29b82298e44514b001c0f39c10495f961d4b4bn,
  b: -0x5f30n,
  r: -0x15d529d0a3549141acfc920d2804d272ee82b536013d48773n
}, {
  a: 0xe16f3e57773a184aa34082c38751dfac6346654bb5160013cn,
  b: -0x7ca13d67eeb9bb90b990d71574n,
  r: -0x1cf0faa26a9ceac6a55d40a2n
}, {
  a: -0xc188939b1aefcf0e3b0a6d54587a569a33c0333312f72n,
  b: 0x273a37f932n,
  r: -0x4ef0247cae9f272b798db5aa50fb9cab01dan
}, {
  a: 0xa7257abcd53d0d3bc478df50fa463dd1276ac6505c416db6d9f7f8an,
  b: 0x3202ae6e3457df72n,
  r: 0x3579c4027f1dc3d8d745c89bc6b9fa2315282488n
}, {
  a: 0x84e04721e149d48affa95f43eb3535a424a4462d6e0cc0aabe22a29fc9n,
  b: 0x663b757986379233c88e0d001e442efff6f5e4d8a7bec56dn,
  r: 0x14cbc39e34bn
}, {
  a: 0x7a2d60f0760949d1298693119ac1aef9f017125b73e79289c0df6aa89f09f41n,
  b: -0x356eb5fac1653a5a93cfn,
  r: -0x2495ce29f973d2a9f832e0dec847d30f458c4a32bddbn
}, {
  a: -0x50a4cda7ceab52929af4302b8fa9f847db4d5764d1c49a8619e2ff1n,
  b: 0x20acfc7d3251c6c0989n,
  r: -0x277cefb906df192f93aeed5a33aa8001dac92n
}, {
  a: -0x8b5fca90b58d4e97cd2bd96a89c143b113dcf679d4795c58d4ec5c17b2c1f4n,
  b: 0x1dbb3d94cf14efb686f627500f553d2n,
  r: -0x4b012179281cca17d4eb5f1d7145937fn
}, {
  a: 0x9e86bd25ef450cf62172ff0b889bb17f82a3507735fn,
  b: 0x3a6d9a672f3dd4ee6e351d1ea74e57c8n,
  r: 0x2b6934480f5fn
}, {
  a: -0xb0f7c7d0d713f8a9bc1ed632aa25a8761b7d0095b7b5affc1149f2e81n,
  b: 0xda8b727d45e33717d8f63c775fb50n,
  r: -0xcf4c2b27fbbbc34bae1edd7138b2n
}, {
  a: 0xe89fafa1e0f737456207c4d366eac944ee6c54de754n,
  b: -0xd0555n,
  r: -0x11dd923f29177864f4e6eb3268db34f53262f97n
}, {
  a: -0x477995ad4c501927d246df2b9b67af4a5dc16884f65d165d0496dafc6n,
  b: 0xafc562e19352f1cf235ba6ac1750122947bffn,
  r: -0x681956440124b387d306n
}, {
  a: -0xba008d98adf8a0e705146bd27d665646302b783cf655fa031db1n,
  b: 0x63c6e6047f82n,
  r: -0x1dd3ae1a529131e7c621c5cfe5a1bdf0754ded35an
}, {
  a: -0x6721da9ce8995946180b3edb55e169f4b39d08dc61465b441921n,
  b: 0x3c6953a20e43e6bfab9c6706fn,
  r: -0x1b508b89422aa40aecf9fd5ca030n
}, {
  a: -0xbb6fd8b08bf2f3e883452c51c8e7951aea86cac5da2f5f90de3cd59e0f2bn,
  b: -0x8d08c7a0fcbf4ef550845f320b4946fa34bbe16af5b1e30fcn,
  r: 0x1543a6c2050bn
}, {
  a: -0x525ffe37f57e2446760b3b8aca74475cc7175b992cfca210249be2c3b487c9669ef42n,
  b: -0x34dade57941022c19d4991aff7a8ec951b26bd2fbcca20n,
  r: 0x18efa81d6f5ed586455dc568n
}, {
  a: -0xb213b6581c9208f2a6eff589fd3d307509799acbb241e3a2e4f427e8cc9019n,
  b: 0xff6413be3632a99bn,
  r: -0xb2806ed77e8c797e5ef38d08a44f1888873bcc8b3e44adn
}, {
  a: 0x9a5d20172899e6ecf9511de5b657ebbe904490d20a59729c1d0fcd8292en,
  b: -0xc2f5bbba9b3b75b2ecfc4d4e58880c6874940n,
  r: -0xcab190847b2729b83dc69en
}, {
  a: 0x9a6e4903e21b373cb97942d52780e071b1f4e257c1c0a4d8c20f0ac3ab21n,
  b: -0x637c6b7a156507n,
  r: -0x18d62a6852117f7feb3085f52292ba7de3b55d151a21bban
}, {
  a: 0x799df741d892df06b29cd1f85774092b8ede8fb72cbaa5ab02ee182ec88c89ea729n,
  b: -0x104a3c50577ca7f15c6a74f2fe49f776n,
  r: -0x7773bdaacb88b75bb3fb1f0eda490e176061n
}, {
  a: -0xa5b781a92e52a41d980c81b5f6e4f0b627ca5920584ea43a80fd6e5c25564c1n,
  b: -0x783d41798ca3aafef3c65ed9d7f8c1fcd82fan,
  r: 0x160d3601e0cd61713d033ed9f24n
}, {
  a: 0x7a16cc5f227b3fd88d5df597b74f88f38dc4ad4488e344070fd8fef7d397c1892e6n,
  b: 0xcf3dbb87425a5d761edb04e7e1cn,
  r: 0x96d04cffef13861ed9a096879dc244789cd992cbn
}, {
  a: 0xe12acb7f483e1c6f9e00565b438cb8232de68fb4c04cbee726791906645dn,
  b: -0xb81a9c2981ff663499d2af39620en,
  r: -0x139196411eba9d63f4013f00e58f1ad8cn
}, {
  a: -0x2987db3bd45859db8c6d2a696d1b033f260066151c439f16bc24d022551d2dn,
  b: 0xce2ab84b1613ebc8193e3a60982ffd62db99ee4ce0798n,
  r: -0x3391b5b0ac487f513n
}, {
  a: 0xa1fd06cfc57b57d5606338ac446cf7f33736a0d85c7825n,
  b: 0x79a5e08a80f303cbef6cd0f5662ac9n,
  r: 0x154e4cbd52ff9a8fbn
}, {
  a: 0xfa3f11c68af935097a381d79f3cc4acb44414592bd8932f6a054d248b6fcd34n,
  b: 0xd50fa27e70da37520437be743ac9a10ea89fb9d338n,
  r: 0x12cadeb3ebaa18887bb9a5n
}, {
  a: -0x4fdbc121205f343e97d639298dcd90189aebc781371147c39d8d7987n,
  b: -0x8d5069f52e1119f7bceeb39ad461d3ae8bn,
  r: 0x90ab3b71f425d8f424845dn
}, {
  a: 0x576b67510c00a5402acddff688343017572fb54824c9417616ed4651dd62db8n,
  b: -0xc6079d775614cb50640558f66302e0fabb13417d02393efn,
  r: -0x7102a3dad99a2d0en
}, {
  a: -0x67c65913b30b01059315dd67c23d5a77544443e8e56d02658cce6an,
  b: -0x4c91e5f5ae102da1c7f535053084ed4n,
  r: 0x15af497297dc2c21ecdeb426n
}, {
  a: -0x7aa99c4a7ce002b9378a5073c5a01dc493eb97ae122608dd920925581c96a7a2e60n,
  b: 0x9502a4a00n,
  r: -0xd2bc05ae040f60a1a118415cd841744c9709b984487d09eb87338d18e2n
}, {
  a: 0xf0d4cae8d268d8b39d49280ca084f54c5e06390156bb788ffn,
  b: -0xc26cbfed1a944a1d171ac64en,
  r: -0x13d1a814ee87d1a9838f926c88n
}, {
  a: -0xf720838bfd1a54e10fdcaa51dbfc96d2984d961470fd66f6ddaf36dc5d97603cba55n,
  b: -0xa53d5dn,
  r: 0x17edd76fba13bbbd89810ac6152801dfb340f659f3cb5aa14b3eb8dc3831c18n
}, {
  a: 0x91335f46aa4e7bbea6c682a8a88cf28a47a72d3cff894112acd8f5n,
  b: -0xbc7f6eab9101acc55067e327c03ca6e3b0709229cn,
  r: -0xc532ab6c84734n
}, {
  a: 0x711a95ba9d1b9866d0125258555b97df2edfe2abf125e0698ad1d6a2a516d01f63n,
  b: -0x37159ae687cbdn,
  r: -0x20da3f315e3dc9aee25bea8cdba3c2f76ba3c617e619189e419b00n
}, {
  a: -0xf20f41d8387295fc52533d179e104dfd327677ed072ab519da8489f87bf5n,
  b: -0x74f3d38dc89f287e0380n,
  r: 0x211d99b6e1128f07a8652b87c7c36384285314acan
}, {
  a: -0x63825f582fdcd94a844c6795bb3a015fbec64fd6878df37eb360e34ben,
  b: 0xf45885n,
  r: -0x6841635c642d8c289371fb9829237980935c2dbcc418a0aede3n
}, {
  a: -0x3ce0651f5488390a3ae01782d3025099dbb8a4d386b3519ef3ec6bn,
  b: 0x1732b788f827d3c580712n,
  r: -0x29fcbb9de2aac0c056afece879cfa7921dn
}, {
  a: -0x93dcf7bb2125808dd2543ea2f377f922cc04141464564c9475670e711n,
  b: -0x9f7e2c297a5df37ccfb66681a9b4cfe7523e513e6a7n,
  r: 0xed555363c563f4n
}, {
  a: 0x7d80abc9f212b682bdc8d898af4deaae9f0990f9c014326519d4126f52n,
  b: 0x468351f6745bbe442a2c28700463dd33n,
  r: 0x1c7a45ab662c3c7d5b4cc38cdd8n
}, {
  a: -0x5be34b81487b6743af639319ce7bbf3ef67c591699ae4ad4n,
  b: -0xa5b9d7d87addd361ef046a174429cbc62fb60956d11f6582n,
  r: 0n
}, {
  a: 0x7d81f1bcac61a8607b429c2cca4ced64de5999a38840e106df953186ebf2dn,
  b: -0x35716da741949e4n,
  r: -0x259330832e3a04e9d5a6d6e79b0f206a20b12eae2efc2c1n
}, {
  a: -0x3ea9eed23cf837166d749c41d0d6cb87053a3fd0c1n,
  b: -0xa448d8bebn,
  r: 0x61a5b13e34ca05c86d3ab02b8845ae162n
}, {
  a: -0xed8ea63659a2b8cf55b42ca215fa4d2340382ed0a01a1f32e69718a84854fn,
  b: -0xec4cb25e9d81ee1ba11ecd7b071fdeaf755a7b71b8e32b4n,
  r: 0x1015ccb38d16806n
}, {
  a: -0x4f31c16f3fd8aebbf69c1495a7df88352574210ccan,
  b: -0x91db9e289f5ccc603fc3bc182cf27c0032b04bf9eb2f90bn,
  r: 0n
}, {
  a: 0xc7febae6302e9f047f4a663d9a13b5e52cbb8fd0eb9390c7593b7fc1f99332c0n,
  b: -0xbd911cc862847910d10aa5a32cc5a9904e8b10d3en,
  r: -0x10e152d6d5a78a1a13c87e56n
}, {
  a: 0xbed2fef3cd3640400758918c7a7d8a17f76a185adc4e1n,
  b: 0x70058816n,
  r: 0x1b415e19e63265bec316084e0d50ee53e52961n
}, {
  a: 0xb46cd14ddc619f115e5e53e73098ac0ba320cd6088547n,
  b: 0x171d067cae6f31f4a5n,
  r: 0x7ce5bc03efc1775d296124c625a2n
}, {
  a: -0xec7b3530043d27fd33ba98d23f20be291b875b98321a39bn,
  b: -0x9b93b3c3c528ca8171f8b683ced1012af5f108b07f00c8fc8n,
  r: 0n
}, {
  a: 0xc011c9dcfde6c10d61e7ab1828cb88dc85c87864e77e7ae8ad0c94c5n,
  b: 0x4972e40c9b75231160c0b40c5b7d8136857a46ceaa22n,
  r: 0x29d717034b1a9n
}, {
  a: -0x3dc9e7dcb385fd34362f798122bf641d91b0bf8c5f9eb2a80e4f49e2n,
  b: -0x1d8b920b754a4f16n,
  r: 0x21761434d07750ffde8c591a731bd75f5c98d2368n
}, {
  a: -0x575a84dbe99ef7edc9e2b22ec20b02d4135d0ed6ab24ab649468n,
  b: -0xb9578a823d594b76382801345a198929ed0eeb95ff0f100n,
  r: 0x78a7cn
}, {
  a: 0x5a63947af1526412e89006aff49ebfaefac24b04db51n,
  b: -0xdae0aee4den,
  r: -0x69b81fe0bfce5f7e11dd95cd8ab29fe15bn
}, {
  a: -0xdb3d8730bddccf863975cd3e5853c808a5c3a57b97n,
  b: 0x3e959efce61ffde780ffea9n,
  r: -0x380cbed9b770df8c8d18n
}, {
  a: 0x9dedd6b833c49a72880d0eac01eb5d04f6fbf883013d00730n,
  b: 0x9n,
  r: 0x118c344d5b15d8459d56c8bdc7530a55e28dc64771ea55621n
}, {
  a: -0x33767b138e9c7f34d64d4e9209ef0476142777186b56975e3449b95n,
  b: 0x552a2055421e1be4a295e1c29fd644f32032bd07d0fn,
  r: -0x9ab1c4e36e8fn
}, {
  a: -0xd6d5b34a24211fb09b6a79297da8e03180f7dc0500941311f493555bbbf6118af809n,
  b: 0x5d2f66e040fb2n,
  r: -0x24e32b2639909f6cc754e8b04a80be33e8b3fe8e47fa68282c02d2cbn
}, {
  a: -0x22dadcb1e36b3300299e537c9405bd7056dc8904cd6643c15n,
  b: 0xe641c4ff017ee078e45a004f13e96c69n,
  r: -0x26c073c4811298017n
}, {
  a: 0xfb35ca8454379aa6563a792a39f83d5ea7e7d282cc4d9e512437n,
  b: -0x5245991771870114366b23e9a41fc1f59c1082c4b5755b53n,
  r: -0x30dacn
}, {
  a: 0x1c8297fd7eb5bee70e92cdbbe42f8c9a7d5be5d51133616a953ee4n,
  b: -0x4n,
  r: -0x720a5ff5fad6fb9c3a4b36ef90be3269f56f975444cd85aa54fb9n
}, {
  a: 0x26d74ea2236f400317f8431a19d64b7629a4a161acaaf2fbce8b9882967d152174n,
  b: 0x365944294dd978de75936da09220702cb8fe607e8eb6a57f3n,
  r: 0xb6f434406a422c680n
}, {
  a: 0xf2c1b00ddb27a5af2f59dc4faa79745763773e52b4749n,
  b: 0xec3n,
  r: 0x1071ec16586a32611683aebacfddf4c71f54272d5e2n
}, {
  a: 0x5a623c5adc047820a57244f2e897747c3d0f949a806164c514dan,
  b: 0x48d373c552bd6d5n,
  r: 0x13db83145b8d81f8a4d5692bd1da21547a0544n
}, {
  a: 0x18c831c96010832e5346d4f1ec4111f70f66f025120712n,
  b: 0xdebfd55375740f7b34bdb44c4bb3n,
  r: 0x1c7b377de31e196595n
}, {
  a: -0x33eda11233eae902970b6e1eca3b44ee388acd6926f713079b0c30a3603809d482c33n,
  b: 0x8676f7cfn,
  r: -0x62dd02dd0a9f62818e26b261fb8a9910548fdc496d60d6e689cf38d3b40efn
}, {
  a: 0x379e093a238fbe565f366f952b82f10ba211a0f2b6d73a8861c3f4b7af61n,
  b: 0x892a105d530a2fd586e144260a2n,
  r: 0x67cd8291cfb231523a553656f37571bcfn
}, {
  a: -0xa9fa4d12d6828ba07e110a3c8fb51828dfcdf85655fn,
  b: 0x12c84917317b2a0f7179bfd1c35acbd77n,
  r: -0x90cc37e5c1en
}, {
  a: -0xf4dfd05c15b5ff8dd66786f104b6fc2260103010136e0856fn,
  b: -0x84d31d49f56ca86011935dde92n,
  r: 0x1d7f589ab8a2ec157d40e6abn
}, {
  a: -0x9724d281601ce797f10f359048baa0733dfd6892688afn,
  b: -0x8700127eee48b7a31dd26991f49f285d04d6f17n,
  r: 0x11e9ce6n
}, {
  a: -0xc3c3da06a63179d2b40150e769e71584374ac09d482126c2n,
  b: 0x608ab271dfbf7f20deaa855dae38f3fc8df155afba881bn,
  r: -0x207n
}, {
  a: -0xe33c3415b62f17098da39481a6be543743d1e36b664029be0f55979an,
  b: 0xdf4a604372b3d6262a38b7e1c7aa2b694c5dn,
  r: -0x10485c162bddc66fd3f35n
}, {
  a: 0x89536e9fbea69a3a63fefee7c9ada6955e144d861481309c47d43e34718073f47n,
  b: -0xec7526ed56315n,
  r: -0x94ace70b8cf61154f1ee1ef90434559bc110cce95dc85e0774e4n
}, {
  a: 0x5a012293f149e5a8c3665ebc59be9bc9f418ed38667ccde54f6641d075844fe63e19e7n,
  b: -0x565n,
  r: -0x10af33d37ff5f8859c287ada6f2d288eba80d2117fcff3befdd97d7689d3f068f74en
}, {
  a: -0xf20bcb4a8e14a1b7de6fb15d2997daf88eeed389fd447cf0b04d80n,
  b: -0xf56632d2c0n,
  r: 0xfc80839ce2d0376f2b42fc4bf4262e8b4c2e71df2bc0n
}, {
  a: 0x9cdb53594b38a7fb39d0c9bbb589f27bc33626bd9a5befn,
  b: -0x9a1bd8f0713a9060fn,
  r: -0x1049097c1c263aeb7c27c910617e3an
}, {
  a: -0x4f1f41a9cc030d3655030fa24aa0a4bd97ba00e2974e36ae3e6c8n,
  b: -0xf1966969cab71b2d41a055662dn,
  r: 0x53d7a13dda9c82de2d8254af7ean
}, {
  a: -0xa4f7b6cb5fc8017630ff38df40d9f2277610e252029d0n,
  b: -0x4aa07127fd54bc37a6ec054714a3c1bcd7a387153304af65n,
  r: 0n
}, {
  a: 0x26dcdfc3163ae72a4d06ebad632dbb6aeccf398ea5f67612fa2472f35b69ddacn,
  b: -0x79f5833f6afe2n,
  r: -0x519356999b9ed27d8c7f0ad0f625d0eee10d15c23c189a22c60n
}, {
  a: 0xb9ff30fa00911aa64ac1cc9f3f18370ffd8bfbcd4ef5a6c987cbn,
  b: 0x73875ac5b362ab1753e8fb047f4ed6f8n,
  r: 0x19c2674fee0038c0c6088n
}, {
  a: 0x1077cdd0e3ce4929dcc36b3fdaee4e2765b898641e21625a0a8f26d102fa7b91865b3n,
  b: 0x18ea2aeba9fn,
  r: 0xa9359a249af6929a70d88b92d2c7454bb9c65af4bdad56a4c9fcc6ed98n
}, {
  a: 0xe86b9e7e1549e787133450af2c1da0af7e04e790fd6aded94b33713d9793183c8bn,
  b: -0xf72da4cb89c8a8156175fccdn,
  r: -0xf0b723987a329cc67979e936a89359a05b38e32ad7n
}, {
  a: 0x9c358c9ded9405785bed97953071c51808f060357d7ae1930314318e378an,
  b: 0xdb3476159a7e4cf2abbee0134149fff7a012bn,
  r: 0xb66e12d4b704b6c821ae492n
}, {
  a: -0x47b9c9cb61e7819b07036d9a0e86982247f98eb4917a7d15955566ed03f0f53n,
  b: 0x36ee766ef01ccf87c8ff85en,
  r: -0x14e445ce6a01fce9a412b2c913c3c807111d4b04bn
}, {
  a: 0x40ad08e199e2d7b73813ab08200fc8cfd4eaadec39b3n,
  b: -0x6cn,
  r: -0x994e4df0d510383709a9e142aad014e328195068d4n
}, {
  a: 0x788c0e3ee70ff6ac57a0845e227f1721dfc7289725b39b4802f94dcfb757e6n,
  b: 0x83069d0dc577b76n,
  r: 0xeb86c87cd264857b09c07729ada3aebb5afe3c99baddc09n
}, {
  a: -0x3c273a26750bb5c19c2a249d209fd701da1218d6e082492dff67b33ab2bn,
  b: -0x5640598222fc288c571b90ea548n,
  r: 0xb289f7c3d7c67c0af7846c565fa2df46n
}, {
  a: -0x2a65bc160cef1d7ac3c90320e7d52817d519702956460a9n,
  b: 0x4ae5bn,
  r: -0x90ea416977c35eb66615c6cc76856c23dfb2bfe709n
}, {
  a: 0x283be8864518ef083a082581cfe3648cc7a19b600651dbn,
  b: 0x75e0d1db918a4c9b130c4e2ecfen,
  r: 0x5760a700a3bf0ed8f94n
}, {
  a: -0xc52aac4d39e5f9b375c65bedc1820546dafecf6a217a9bb7n,
  b: 0x9025d3503fd93bf5fbc0a5d7a54a49n,
  r: -0x15e28c5fea507769ea5n
}, {
  a: 0x897f56acc8388512b20dfd59efa161e5b8b87c0d386a7a9c7b9ede6ae2n,
  b: -0x83ece9bdf831n,
  r: -0x10acff6e6656a87c3e8554f88276c0ac9b3ac26a5b530b7n
}, {
  a: 0x366b4de29349222dced1aa4b3fba6058da6c4e07ec83e489f9ff9d47d29e58694cdn,
  b: -0xf09895bc39bb93a2c7202d812b5f3en,
  r: -0x39e73ea14e0eecfb8ab263b47ae00f7284403n
}, {
  a: 0x86603b33778e21b1f8ceccb8d57173e6dd638629e46483fd4eb4cn,
  b: 0xad6fn,
  r: 0xc6591fe64dfa8e2404b89ae65b19163b86097ae641ee231f3n
}, {
  a: -0xa69b148ff9ecbb8fc5989d9a94e55a04dac05b325488bc8e687e5077e419cc7232n,
  b: -0x45n,
  r: 0x26a21b076a2f7967d4c6a2b0d49d1129eff13df568ef79a2e09403d199111cdb6n
}, {
  a: -0xbf0583d70204169031d25270eaea8064c33c43b25cbfn,
  b: -0x6322n,
  r: 0x1ed4afd1adf8a1544308625d12ee4436eb1382f27n
}, {
  a: -0x699d6f0d4d39711f3607c6380f555a81ab8f9bba4a1203c89fcb508bn,
  b: 0x5f446f0ac0ef23b66a2c735507b4ec06729n,
  r: -0x11bce53ec20c7fbb324a52n
}, {
  a: 0x16129ed47fd110d243ca1e7f5e8051cfd7fd3f46e815584n,
  b: 0x1n,
  r: 0x16129ed47fd110d243ca1e7f5e8051cfd7fd3f46e815584n
}, {
  a: -0x6b7fe0ac2d5328d640eb24b7b8cd09761cc5b50d5804f9a5n,
  b: 0x96ad63f55c49d3c8cf2n,
  r: -0xb6a422e16acc6a346c2a06d674c5cn
}, {
  a: 0xa0d4fe545540142b35cc4bb6e60f95c2798ab46f4d8c566en,
  b: -0x37fa33ad00n,
  r: -0x2df878dde2743fa924f67ab35053452d4754e6an
}, {
  a: -0x823061a6379c906b15a062794006bef323baa3d6899c160fb0935eb53n,
  b: 0x8aae895a99e61796347cc4f2ad1663856cdbn,
  r: -0xf0529cdb874f03bb9cae1n
}, {
  a: 0xc9b63587a8d2404018179b6dc5c57b5e965603f6d09n,
  b: -0x749726dc3n,
  r: -0x1bae711a9ece972db01d0aaab0cfacc2b7cn
}, {
  a: 0xcc8dd9a3aa985479773e2dec4016674212f761d8e0n,
  b: 0x543a94b35f63051fb0ba22e6eacc7832a93452fa8177n,
  r: 0n
}, {
  a: 0x42e7ac3ff40cd72af5d34f5a690a494d760cc02e94bn,
  b: 0x41819fa5106n,
  r: 0x1057743580cd7b856db6535ea0463f464n
}, {
  a: 0xa7ffcad4b706985ee671f579d634b59eeb8ea5b13796bc7cc3a564f2b256fce6n,
  b: 0x9c070c9e6c852abe8f2f4e6ab58131cf353acc95d4n,
  r: 0x113a46f2cf1a4f04fb88b95n
}, {
  a: 0x1202e27213c705d6ae396646cbb837b927a71e8ba1ef2n,
  b: 0x57fedb6ee1f3d6bf7f6d6c4e5e0733561c07baa556n,
  r: 0x346n
}, {
  a: -0x23711e271d7cba1f170aabd3b902f36c3940959a56ccac244013291d40fcbfab859dfn,
  b: 0xbb9e20704272b8eed789afbc587d1b1977db8e58n,
  r: -0x305c0f5785c8026f663d873654ddbn
}, {
  a: -0x727831952776f50279a92ea1abc61a4d96214750629f30da905350884243bn,
  b: -0xca3fb85c2c06en,
  r: 0x90e4484ffc01b1a0af5e6eebfe5b5a924be797f9b90138ddn
}, {
  a: -0x3870fe780ece99fb082d8bbcce01574adeacdd9e0335f7cffd47e12799fn,
  b: 0xc8672246c16d3f6a5f4fcdn,
  r: -0x4819885fd5593ffb92790f8a651250b4f1b91n
}, {
  a: 0x635dfc0ca7cab1ba85738e49fc9867acb62c14443b091ae56c0n,
  b: 0xbacb99a5a4b50b28e1c9n,
  r: 0x882e5a3b93723f728066bea2cd53ad7n
}, {
  a: -0x2bf534ad5df83ff626c441749fc883cfd0859bb1e2ab6c3e8bf09fdcn,
  b: 0x40aafff83c2c6f2e7e335c816db329655df4613fc2n,
  r: -0xae03e06eec6107n
}, {
  a: -0x625f66c9e2b13567c75c70d431933cc935ec462e54ef9fbab8fn,
  b: 0xe552baf5316a45432fb75a655fa5182e94c0d41e5n,
  r: -0x6dd0f352abn
}, {
  a: 0x79602db6bbd8e71868388a8b0f2753cb9935d9aecfb6cfn,
  b: -0xb8b6c88b1d8e074ff54ceab8bae7cbcf11b4n,
  r: -0xa837c06b15n
}, {
  a: -0x3cfe384e620e7396516b3f7a87f4c23c295015734c0169b9f81ecb9n,
  b: -0xdd224cf6958a209af8bf01f14f804e5802d4fn,
  r: 0x469c19e290d5495efcn
}, {
  a: 0x27d4369f89bdc602fd24911a5a007eb5ab919ab7233eab2befd7ccn,
  b: 0xe17e0e8bd95a6cf158e57d8d4943fa956e7ce0d0c038f4a3n,
  r: 0x2d37b1n
}, {
  a: 0x4c2f5d6bd2761b832190851e196635489e2f54b8070869f998843464d620dn,
  b: -0x2e0202b0432bf1457fcf0f4aa4e3328867479ee7n,
  r: -0x1a7e9f0179db5a138c8844n
}, {
  a: 0x1c96cf4996382824e489e87d131fcbf2c63626364f59bn,
  b: 0xe6f052055082d73388e5868bccban,
  r: 0x1fb10a31b6744501cn
}, {
  a: 0x59c664d89dd76086a99c6410bf6cce6f11b75b4016aan,
  b: -0xbdf4c89b5b35316f4bn,
  r: -0x78fce4e8382451c0ecee6ac7afn
}, {
  a: 0x77c4996b76ba37ff4385d3d157661b10cbe7da41dc31606db1051c651a2n,
  b: 0x2dn,
  r: 0x2a958be1f153471c2ec37e8352467005f8daf844ed94668d66c33d4bc5n
}, {
  a: 0x95bd68504862ea8747521bffc4abc0aa2718a3a68ab08d7a7890d64d35n,
  b: -0x64080e7d8ac01bfe0efc503a15d3fd6354047dd36bc647918n,
  r: -0x17f36a62e8n
}, {
  a: 0x913bacf277a87a99072a3bafac4cc7b79ed2abe2d49ce97afe6b09282e1d51n,
  b: -0x7150dfn,
  r: -0x1481b3e93a9eb0ba00da45b9e4ad195a1836a46aed15b15db57fa46edn
}, {
  a: 0x6d433ae2824e60c730676baa11ea0829a91efc10e03739f9b6cf3b9bf5309dafe79n,
  b: 0xe65d8d6f5ffdc397n,
  r: 0x796bce9f6fa5e52c930215bc245bebb5788afb025c63af4bdd2n
}, {
  a: -0xe7320b06d783675bc8ff2df35ed3439f0c3f65537b5cf8696n,
  b: 0xd3f42f1c79f0a7ab84d1cn,
  r: -0x1173d80a13ad46e87e09d991e3fe2n
}, {
  a: -0xb3afaf0455cd95a2516047df90ade20377babc19d3a3b22e9f735dn,
  b: 0x8een,
  r: -0x141f52166f4ac2973779a5f2f5ff50a1a5eed620e78bf2ce5914n
}, {
  a: 0xdee257ccb8917cff7875e9c8c9a662c7a0de51207ee39e49f3n,
  b: -0x9127d223dcdff981n,
  r: -0x189158972d7cb61a3da28f440d967ef0c4cn
}, {
  a: -0x532948e42c05a5642bce5858b98576e2b6d80ec9be16n,
  b: -0x4d0bcda486d6eb73578cn,
  r: 0x114519a55246ed75936af840an
}, {
  a: 0xe366306509d4ab3b937c372aaade75f879e978b5b3afc939d9n,
  b: -0x7a834b687907174fd293624184d93526856191n,
  r: -0x1db2afecbd7a2n
}, {
  a: 0x3be34cd7d6293c0abfd7e7929ad25d80bda0961a66ab66a753e583329713d8e78n,
  b: -0x8f836ae16cbaac842866373520f860f937b93d7d31c22n,
  r: -0x6ad41167ec5538f7e5d7n
}, {
  a: -0x9fdbc4d2388ef8c7e9491dd549f6c87c9c0d30da90ed45f4a576n,
  b: 0x624fn,
  r: -0x1a04755b3a77e2196535209303479b40fc99cab1eb8067d43n
}, {
  a: 0x94d05bb2f78968a91e2affdabfb357d6ed695ac1f5ef4ff1dn,
  b: 0xa3c6e9e5c96b6bc8278ff23f2n,
  r: 0xe89c747a036e0a375cc32bdbn
}, {
  a: 0x6a52d03152d86fee1ae400f80b119ad17b24ef1c8aa9669228cb28c8c837903daean,
  b: 0x1bb2cf316d1aea36dad061001939d5fbb660fd89637n,
  r: 0x3d6aeca35b1ab14389e2f8d34n
}, {
  a: -0x6dcd87e1d7d0ebb01edebb607e1a74b5a2787f21d42ea18339an,
  b: -0x4a3f16fe9e4c23ea1329n,
  r: 0x17a9900c504ad1c58f28f413583b623fn
}, {
  a: 0x9e079e60b4f721fdb94756ebba44d83083d2deaf4af44bb42n,
  b: 0x4c2635204b3b98a5e56c0370de501dd46932d7c4d427n,
  r: 0x213447n
}, {
  a: -0x9cace359643ecbcee60a639d6dd6353e5942242028456c04b7e93b12402a793n,
  b: -0xaa2d380e80835bc63e703ab1dc77186ba05762n,
  r: 0xebb093207487716caae8cfa72n
}, {
  a: -0xaf0a47cb24a63b7d19c9b910dc2e179af262d8702dcfd0b65f2e777db54882n,
  b: -0xb05fc3f558750f9982d4359fdfc9d11df653b06dn,
  r: 0xfe10591779a8f01e3b111fn
}, {
  a: -0x81a8913ed67affdf65d1918f5033e5d6425143ca0ec3473n,
  b: -0x1c1ddb93en,
  r: 0x49c880b8b3dafca59ea259e379c1a48a6d79f08n
}, {
  a: 0xe16c2de7e441d36a1c193ad26b77b356659735b4e14e1107ee174f00891en,
  b: 0xdd2d43d42596204b86579d01bf44385d2464d073b24350cf1n,
  r: 0x104ea0b29128n
}, {
  a: 0xf5ed2318f7b70991b674f85ece66f2d8017544901da8cf7cdbn,
  b: -0x16c30ffa064494ccdda96dcc65feffen,
  r: -0xacde46e53eec7cb7556an
}, {
  a: 0xa4d0a09c517e3b48b272aeac05c4d9fb2edaf5b48d21489078f44015cca0391n,
  b: 0x3a1d9332a449n,
  r: 0x2d60352e747309d6f672b65ace78e5f5f839bfc132432c3a3143n
}, {
  a: -0x5f5d1204399ada6f10165ff9b9f896691c75008d9332n,
  b: 0x18fc129a949d3ebn,
  r: -0x3d11f5703bcea6e45549d65b825dcan
}, {
  a: -0x5a28500defdf00298b3e9b4d32d6b58df643e8874dea278b6fd7e84df9n,
  b: 0xd772d8cn,
  r: -0x6b2073616fad45e3f9ceb2029695faf6243901291b3d4928266n
}, {
  a: -0xcb823def88acf080a46bf6efd8c9223689ac215168f26789f55642918660fe76b123n,
  b: -0xb64f29797edaa1c0642c83e52d7dc89ac9550n,
  r: 0x11dc4bf3063331630abac9c9ad7d521dn
}, {
  a: -0x2dc9a8db4f24f7e04f0a767862fe3f538ae96840337387d5ee7532cn,
  b: 0xe65ab790134dfea2cae178f9f41325854f9n,
  r: -0x32e2a57f696d8816b345n
}, {
  a: -0x6e7815e5181f60e3200b0f11eef825022227a695a3612c111db01effe6f3f995d6bn,
  b: -0xd3c28eef0c43af4944e63769e845b8n,
  r: 0x858c3df107046f17730c889fe1e1e5de6df63n
}, {
  a: -0xa80e6e51dd9109fc88300c326402176efaf97c04f3d42e4a6810n,
  b: 0x6ab79dd107569854dbea327e3a33en,
  r: -0x19324e409caf74b677e92507n
}, {
  a: -0x9876e292f9c5cded0c5ec0d4a4512124562309ce3eb0590a8b43d53ebcn,
  b: 0xfaa333ffc91d8177ae6ad8e6n,
  r: -0x9bb9f754d6f05aab349114b7e0cc112ac1n
}, {
  a: 0x9c837823ec217ef95dea2efc3ec7f8f612a713f33c2fb0937cdc47e33473fn,
  b: -0xee6048ba700bae00becffb8613f63b89c9n,
  r: -0xa815c84dbc814da15cead57eaa9n
}, {
  a: 0x1cf003054f7878d67e126ebc3f4a1ca897ad3d1f1353481b21n,
  b: -0x33f40ce5129d09f7e47a28b1a0f8c62fb1d15260n,
  r: -0x8e96faa94fn
}, {
  a: -0xf1f7d1c4041ad62a53961a844f3e5e973d7d4148d2dae470a81fff0n,
  b: -0xac35ce80ab26191f9765e378ceec93d5abfn,
  r: 0x167b2ed801d10443e573dn
}, {
  a: 0x7421800c055f6b3058b8125430e641f7769d4999bd358bb6d739561cc7n,
  b: 0xe21945cdd9dc6f8230426f39c461644f5n,
  r: 0x837d30abf1a10887ce569ee41n
}, {
  a: 0x71043e9d498b87b3a85788800afb063dec593d28b0abe5113e5dc622193537an,
  b: 0x5a314e9b878d136c439e2d9ddn,
  r: 0x140c86b62ee0c56ea097167067880f0900a5967n
}, {
  a: -0x601316db745675ef41c41d1baa8b17f4c5e9a920b52f1a08c8196e65n,
  b: -0xd1b81f2fcdd3ad943n,
  r: 0x7546b9dbbfd433af96d252d438b34a0d6e7e238n
}, {
  a: -0xf2f49885ad3cb987ee5cebc4bcc1157b7dc6363ab9b4bb2b33b8e9a833fb29efd53en,
  b: -0x6b7be373f95ba899d9e7519daaf8b412a1488n,
  r: 0x242a8d0d15d4f16c7d4d9a3450b32c43n
}, {
  a: 0x12676150bfc7faab5bf4c23c87ab2a912acba5405f4c2c5efdan,
  b: 0xf3f7985e059abdb75c80c95280d4a09b1e4f541bd9n,
  r: 0x134fc0a7fn
}, {
  a: -0x9cc2b78d12715666a23715bb85c6037051fc8c8ea48e5b6n,
  b: 0xecb1364n,
  r: -0xa98c4fd8d204ceb89bf3acb2b0aea15d033c0af6n
}, {
  a: 0x71d15fcf4d4fd461f21b259cb0e816ef0f8bda22fed2992932e0n,
  b: 0x55de12e1n,
  r: 0x153545f3ae01714acfe0a922fe153d6c06f15d0a55328n
}, {
  a: -0xdc0cbc07a5cf239a20571c323b4e17e87c76470962n,
  b: -0x6d0b3dfc37367e5e541359c34a878013e42e974055n,
  r: 0x2n
}, {
  a: 0x7e78aac8770c50a949a7359ef900dd335bfc326f42d9ac047c44d4cn,
  b: -0x926aa02da685f8441a30a890bbedc2de7104fab5a8n,
  r: -0xdd208dee5295bn
}, {
  a: -0x35b0b27732af5b94442cf5868ea1f6677361409596a2fcbf746ec3693f649n,
  b: -0x61befb8180edf55effdbd83544854169869e7f434e6aan,
  r: 0x8c9dce5f772978dfn
}, {
  a: -0x32cd6c911872ec7945dcfc7b6af77c9b72c9a3155b03347e7bcb6f878d8n,
  b: -0x9dd38988n,
  r: 0x526744c7863de6e9ff3f1e3fc4ca5777e3bda3670e7acd1881cn
}, {
  a: 0xef2eeb5a99957cc1767ce77d5a500e462b8bb2fa8e5e5f5b3a76n,
  b: 0x28caa43c9119892cb95db2n,
  r: 0x5dd116a42f1f4601cd6a911331c73e6n
}, {
  a: -0x6a1d06b0ea4ce0a387cc38cd6b9ee5837d04f399ee63n,
  b: 0x45db1e9f4bcd95ccedd819ee9n,
  r: -0x184df43734a090d0c3a4n
}, {
  a: -0x1b034e8be4d96a0ab4ded123efd5d1a28ea9dab37054eac36218n,
  b: -0x67460958507ad146fe6f789217d6d7059028n,
  r: 0x42f6070801f67b5fn
}, {
  a: -0x679e5b30ff99bbf7e60a7948019b47fe178e083abdb7cfcddd2d0b3776bdan,
  b: -0x303086d4b9e71403101efd22a2be82389340efan,
  r: 0x2267566b9fffdd61acf2630n
}, {
  a: 0xdb001cd075640bc5f5881f72ac56521fcce6d115e42644279f0693n,
  b: 0xfbb148520fe87n,
  r: 0xdebf996927174959ea25625d0941cf2f0c5f958a0n
}, {
  a: 0x978c63e1a05c34a212d43656d61c625be65706d88830a96bc71dn,
  b: -0x8786e03654433b9cd4n,
  r: -0x11e43736740418e7a78258d4e8e22c69113n
}, {
  a: 0xd0762dcc9e357e8ffb821560aa0f2821ff0e106e695eae85a733e1ff8e96n,
  b: -0x9943e14f31e5ab730d23aeac8e0e37n,
  r: -0x15c31f3130c38389a05197da6fb0599n
}, {
  a: -0x44634ed5e16f8c3bc11a39a29d02d62eb0d08e57a02e262da37b038b30e1n,
  b: -0xe04b67607ff0c611c7n,
  r: 0x4e0e13a5c1ebbf993f3491265011eeebdf3c121765n
}, {
  a: 0x5db354ee2bd6f82fbb36d085bd461ba5e45706721509f26e2a7b2626885816fcc9dbdn,
  b: -0x4597783e87021f5569868020b14n,
  r: -0x158afd0f9b6a6f0a21ee26e51ebb9709fc2bb8f7632n
}, {
  a: -0x944f35ab0c68b76dda75d471f7104e3fb249279d1acb498f72af453cfa5n,
  b: 0xd0a6e4385e940cccn,
  r: -0xb5f6df391074528f6f152f7ed0c3ccd2d2c45a1b7c2n
}, {
  a: 0x150101487b0dad2a3bece479e003b924215f31b1d173a4007b1d990ad1n,
  b: -0xab7620da50ecbb925bddd08d04c4244d69061c19n,
  r: -0x1f5c1f223d687b91aan
}, {
  a: -0x67766a5ff146ceba43b1b6dcce61f0318f5ac1c319e21749f915d7d35fn,
  b: 0x60b9eddef4eff434a9d063363f854dbe54728en,
  r: -0x111d419c3f262ddcd32e8n
}, {
  a: -0xe9b552f1c40dbf34fae926891a3052dc622d8146e351721952fdb93ab5bcf35a3n,
  b: -0xdb37ed8db202ced6e776d37ebdf84fc33365dn,
  r: 0x110ebc6c2e491e45d968acf83e83en
}, {
  a: -0x8d09155be665ef0ef9d52df9d8ff2cf220f69fb180e80fbc705b52d6a2bbd1669c5n,
  b: 0x6b230f7314f436ad7n,
  r: -0x150ffd50a430000259edf2637d32fc744466044848db999b236n
}, {
  a: 0x97d7baaed31982097c13c6b69a6f6e119bdcd5c7bad8e4921a53af1ec21d1dn,
  b: -0xbaae3b709fa13fc9272e9e2dbn,
  r: -0xd039d2a0a99762af1c5bbac5c8d505fc52471n
}, {
  a: -0xd256c8a35e06d2848f5d8ee040f1245bc79e37d56209e02d59608e23f0n,
  b: -0xed1f64f23773f7733e89b4644209363n,
  r: 0xe31588a0767922f3364546ad129n
}, {
  a: 0x9c37b38d78d9bb5c893a59542e350af9e503bdb7470d55cde839d823f55866206b5af3n,
  b: -0xd86f5b51d437682b738d3cfc8ccdan,
  r: -0xb8c6502e664b0443a58b877c8df943cca94392ac5n
}, {
  a: 0x5d917d9b38e650ae3db3a8857ef457b8bcce2dadd01b4n,
  b: -0x4ffa84cd7fn,
  r: -0x12b7fb0bd2795ded2137671974e2affb6166n
}, {
  a: -0xdd2e0543ffe8be4845ced403a95a0963badfb350ffc1n,
  b: -0x7e237b6672a834d2b1705de98n,
  r: 0x1c0e3284a95f0431fd99n
}, {
  a: -0x4b0be69c679d05be68dc0ea70b623f7e3a5e9da9e6ddcn,
  b: 0x2745102c6d45f7d05b65e2c9403dd6fa778636fe00c07n,
  r: -0x1n
}, {
  a: -0x9dc2d7b58c72745b04eb9c18ae1396bbd103b934d5fn,
  b: 0x9c7582ab0e1c5452e7531c7n,
  r: -0x1022166df54acb2c84271n
}, {
  a: -0xab0cb718eb96c3cae9ce82a8fea4ec9426b3bfa540b3981142a54n,
  b: -0x9a5534db26683feb940a9357180cn,
  r: 0x11bbaa579a526ec18f9ab9ae51n
}, {
  a: 0xd67be171d80f81f034c91e234709e180ffb44d6704127b6c910208caa5ad47a0781n,
  b: -0xc1aaa3ad9f28186426976e192739n,
  r: -0x11b848239fa781d11dc11f63de1bdcaa42fa71b6n
}, {
  a: 0x8112bf5e7444f3a0b9802651f9bdb1fd9a87d1049f1c302d6ffd58a50d8630b66n,
  b: 0xf97ec95b3fb1d68a39cce5eee25645dn,
  r: 0x84703989939239b9262eb787613072c32an
}, {
  a: -0x1df1835100eb617b55b0173923d2ad1df0c72b2bceda0cf7d103785f996bdd52n,
  b: 0x708abfeb167f10661b41b54f76aa49fac052e066a014fa6n,
  r: -0x441ccad1777766000n
}, {
  a: -0xf27919abcae83b050b4b13d70662af12e6945f54bdf272cc6b301213439c72c5d9f4dn,
  b: -0x25801105276f9aae78c212111a1952e4c4532390a8ccfc45n,
  r: 0x677456e0cac66acb3bac30n
}, {
  a: 0x889fded94beab7a61a1e05821d26394d3743fcd3aa7dce45238n,
  b: 0xda2a155a0dae6048246feb51166b7fn,
  r: 0xa051a2277548abb486771n
}, {
  a: 0x5f9e590edf123160b89089ebad0e77b7703f8ad349740f741dn,
  b: -0xab023658bbd953eea62d55cbbdf63db4ebd09b5n,
  r: -0x8f241888e89n
}, {
  a: -0x35e5c03b08780cced84e3163fcb38bf3c124979b1ffe4e081ba0c5c19en,
  b: 0xc39241e5df78578d5fe579f19c15dn,
  r: -0x468d0df2c1ecb3e2d49cf91cbbdaan
}, {
  a: 0x1cfc8dd95be8181a751502d82d1cc863ed64d1a01694n,
  b: 0xc0fac6898a1n,
  r: 0x2673d9315405134220b0dd019d97f80d8n
}, {
  a: 0x2035f72033fce4c2680a202f8f131c8d7545113733b07a3a93b9cc015ed27n,
  b: 0xbf86dde2cea778a36e3n,
  r: 0x2b0dc880f33c4d67ff331a94a861df4827d4d5f0c8n
}, {
  a: 0x9798f0448ef70b706eb721b7299bc1ce8be66f193a847d9450829f48f0db73bfcd5a8n,
  b: 0x1eb98n,
  r: 0x4ef1f4d8782563303fa4efb985b62771ba545c4a42f56efa7bfa452e552ab17abn
}, {
  a: -0x259ca0fbee063142348e9bedbbadff83d28437b12c8e6b59014n,
  b: 0xd7en,
  r: -0x2c9a50eab8229e52f53f20f8b76e22b45696913358dbe22cn
}, {
  a: 0xd64825a363fd0db6b9bfe89348168042b46b264ef19n,
  b: 0x6cn,
  r: 0x1fbed62b2b41ef1196c718f96003555f372c5186f4n
}, {
  a: -0x324499f0e3aafbd7a2ec711c1d8c37c84081a0ae2b7c517c72d08bb742c1b6a7n,
  b: 0x19f4a0a5105ccdf02a26ef658c4f11ac8fb676a727n,
  r: -0x1efcb170d656d1a3f4a0ae5n
}, {
  a: -0xf51dcd5a90172a05c0098cacd85d6f3579c13614c4e8d050db355eb5dn,
  b: 0x8f8n,
  r: -0x1b547e5df1bd02026cd392ce96c94d83bb8341cb03392d86c90dfa8n
}, {
  a: 0x2e0d84a1166422771df119f077e5fa79d03a723ba8f8db6676cb1752232a1e6n,
  b: -0x61a8a4f785ad48735e2a8670cb58dea9e045019ca7263ffn,
  r: -0x78b8b7b9f3db2133n
}, {
  a: -0x6f99ffaba479f9798f6ff785aa776f953b485af5b3789026bf38en,
  b: -0x22n,
  r: 0x3484b48d021b48393470ecf39b837fcdc18b76194565e97ba547n
}, {
  a: -0x4224305a8fc159a316ec77efaf7d6aa25fce4ea252f94475c498b82ac918c4en,
  b: 0xa5fd78e95574dc7fe2118b931bfc5b161n,
  r: -0x6601d834d3bc503c22d4b0c4b31822n
}, {
  a: -0x3347104053c37c20a9af2f42205c12a3711f85f47359f7f4dd112baf46bcab447b178n,
  b: 0x4f3c48ed2506cc9578n,
  r: -0xa5abe88e97bcd657b15160956bf3e32c38ccf6e0f50668afd98n
}, {
  a: -0x12a1a00239827f8a3191af4cd2bdfa846f2f9b90240b40bn,
  b: 0x873f21fd32b44f46b7en,
  r: -0x2344214c8c71cda6d841548b04dbn
}, {
  a: -0x90176844cc970f4e900f04e07ea3a513f7aa9ad4347338326fbfcd74bn,
  b: 0x299b8cfdb1c17b020def59e5b7c2708c3e1aefb0fn,
  r: -0x3768ddb3ddd602193n
}, {
  a: 0x2fd50e501b28dd29ce6806c516734bff04ab5b7ffeb69e8f8en,
  b: -0x64f8012300eaa84951911e5fd0aaff6cbdb530f786579n,
  r: -0x79469n
}, {
  a: 0x24d44bf3d9591e86a5c4367434fcc05709378da5a6771n,
  b: 0x10d1d24cbee311c4f9n,
  r: 0x2308dbc0fff6434d27e03e3ae9b3n
}, {
  a: 0x9eda5a2ae91bb6c2a9e27f83502deac425bc9a0c45e202c7c2188c3cd27363239af881n,
  b: -0x7f7a6820547409n,
  r: -0x13f01a68e44f0180fc8d65e17b354febd2f85973b75308ca68cb5ac28n
}, {
  a: 0x3153624dd7b6c558bb0685c3a610734b72faca99d3715789788ce36e9013198246n,
  b: -0xd287884n,
  r: -0x3bfaac1e5e96d4126eda84e9c28091f3444936bbba97ce88d9db0612f17n
}, {
  a: 0xa5c92ac56681b5f22e9074672680b62f7f03bcf48649d347c5n,
  b: -0xf73b2c2ffc1030b482a26fb127af844964f76d2n,
  r: -0xabaa7b2e27cn
}, {
  a: -0xf8ab780d823e33d0a001a0cd47595b153763d71608d93963c3ed76n,
  b: 0x8d42392b5332abd239693cf6986n,
  r: -0x1c2a8a6e996d181bd0fe77b25fa4n
}, {
  a: -0x155fac34b43f277e0218931f43520b199173cf26a65f2332faen,
  b: -0xe5eecf0e73e24d371n,
  r: 0x17cbfcff1db3b3799ff92fa7fac156b245n
}, {
  a: 0xd3ac7bbe72da6aae150e54a5743bcd95bd9106f1fd0d4bf2a40e51dbn,
  b: 0x7361e716a30e89b4178a3b924845eb9a72bd37f3c125n,
  r: 0x1d5a474d87ceen
}, {
  a: 0xa82e64a8c7171c77c37d95697f3a2933bbb06e46b736480238d2e0b247dfee583n,
  b: 0x8babff85990ec1ea4648cd06c5dc42b5388d940dn,
  r: 0x13440fd5dce41ab2bebe47e064n
}, {
  a: 0x1a6c17b966ebff06715000ef21758b9ecd88ac3e449c3453b25fn,
  b: -0x6d69a18ef9946d797e8e0613173325c9c1a4fcn,
  r: -0x3dd265f5fb23cdn
}, {
  a: 0xf7b62a95f518d9611168934623169db28cf4861eb531b26886n,
  b: 0x350624ba38c2d315afe61cb4faececdacf6d7n,
  r: 0x4abf3c2a01b864n
}, {
  a: 0x8fbbbe952c771e4ef1c61854d04a1edeb4821e091c94ce169a905995d6d1n,
  b: 0x4e29ab3n,
  r: 0x1d6c208e55368ba7e4c989a6854c49ae7f63a12effb6e8e8fafe74n
}, {
  a: -0x1bed2394eb16e823f05e7f8c41073056bbeb902a6b22742c7277a4002cf8daf92edn,
  b: 0x3d547b910cd3n,
  r: -0x7491804f26aea180b2b24aa6c114197ded033b591be85aacb81928bn
}, {
  a: 0xccc3bfd78dbc170c22306584919ea01c051e52f7f9acd5172b0e88642d712e0dn,
  b: 0xc417ad51df2f95bf6a06d2b1f82c2n,
  r: 0x10b52519507fb5d3690c2525e3f1935f7b9bn
}, {
  a: -0xe1833f0efa1b7b4d88615de40f753f6011045abf3434n,
  b: -0xb6071fd48aeacaa40n,
  r: 0x13d27f9b6d823741a123929fefd4n
}, {
  a: -0x19730b895dda3f36af84454dc0760d84147dcc97d9cd3a96029fdn,
  b: 0xa1e95c285647d3a604096d42aec759bdn,
  r: -0x283d00d7323cdaeb097dfn
}, {
  a: 0xa606f827bbcdf30e75caddad9650a2959e9799dcb662dfden,
  b: 0x7ef8fabc9d90f257f521fe9b14ban,
  r: 0x14ebdc804128c97443ad4n
}, {
  a: 0xc8bbe31893948f44ac20c3cdea621b92dc5c7e02d6d4431693b10b9aacea6cdfbn,
  b: -0xf3c37379d65cn,
  r: -0xd2cf791e53bd527caa6197b76fd2b46751c85e1024f3e72c69647n
}, {
  a: -0x6b20028cc4609fea2a45b1ce0dc100ca1cbf30ab55fe03006b606n,
  b: -0x1b506be6c2dbe264634a0cn,
  r: 0x3ec05b03b8c0907108c003ddd5d80f19n
}, {
  a: 0x2b059d9b484c87608ef8feee0bfd284e75223439fff9423c9ab9f5c0e6f53cdfaf4n,
  b: 0xc6a2679900n,
  r: 0x377258f6be1701204cb605ea4e4973732563d593d287a4a6cd64296d6n
}, {
  a: 0xa1d4b27bbfb3d35176a0f7341fedd0330f73abb1b3ec030efn,
  b: 0xd87249e10c6468dfn,
  r: 0xbf676758dd0d630d033035b23639938a2n
}, {
  a: -0x93174dfb8ba87dc5de8235c80940b16c8f2fea1093fa46n,
  b: 0x9b144f4144fb9666bb7f4be6n,
  r: -0xf2d02bd850d5a9cb9cc485n
}, {
  a: -0x5c64045ccd1779072d27b1d91a6190a4f8b9114824725a6a6f8f0cn,
  b: 0xf1a393aa4db420e1cc95193c882a4dfaa25bf267fa8e6df06n,
  r: -0x61e1bn
}, {
  a: 0xa9f320b3bf973baab7c49ec96f017db3d4919e8cdd8c5aabdfe471a58516f168c6e1e4n,
  b: -0xc39fd2cc4cb45f52611602b956ff839fb3b1ee6n,
  r: -0xde66c4957b597404d52b5892f07e1e6n
}, {
  a: -0x69b11fe11cbf3a67c50653d76d5727d38e4a4aec56n,
  b: 0x533bf12c58df0fb80n,
  r: -0x1451288d440b717a350c4cfeb8n
}, {
  a: 0x4d73ea3a41a267d6d509478160024bb58c59d66cb20f540d2d3dc9b7n,
  b: 0xf77ecddc0c980690818d844844ba7e09d8en,
  r: 0x501d42bfda58180cb99ecn
}, {
  a: -0x403d7df81cb86aeb8e939f06984a25563c6cf7e9559a4bdn,
  b: -0xaaca086d9896n,
  r: 0x604a8a8368c3bfb9c5f303b1ef4fab24231n
}, {
  a: -0xc074c76374ded8fb429bc5e03a4c545bc072be58907n,
  b: 0xccca9a3cdfc2n,
  r: -0xf0948e150c2a1f8f42b6c470db0ec9dn
}, {
  a: 0x1fd4f6668713bbf3e1fce86222be215440af93fba9f1724feb8ce76c75bd3aa6316n,
  b: 0xb4363885ce3ddcadd239a6a0608439d6d47210n,
  r: 0x2d3803b2fff86831858bfd283c004n
}, {
  a: 0x91d106a6a909e0b44e4c978bef422bd23c9b4ec92f43f1350f1ec2d16242en,
  b: -0xeb179e2def8c382dca5517c7f3c40ba36n,
  r: -0x9ec8da69365bb38eb8d4c7b33857n
}, {
  a: -0x3b57c7595663bb13b0f88ea407c3c7ce8c1cee34d891d02738n,
  b: -0xa4ca328ebe1542d744248n,
  r: 0x5c3055dbb38326e060df1dd1a2025n
}, {
  a: 0xdcb485e6558383ab0fb6b59d3061aa192715bcea7fn,
  b: 0x83bcc08ban,
  r: 0x1ace34536f9b26436346cc03ad943aca9bn
}, {
  a: 0x7a3cf4441a30ca4c95235af79c5d0a023809199f813108dc18n,
  b: -0x79591f4a0a72020c0622cb26be4f345fcb1fd141d12n,
  r: -0x101e0a44n
}, {
  a: -0x284c56d5f8a38d93f8630485fc1430f943153e851300a9383006a4bde8e1007dn,
  b: 0xcbccf39473ce3e610ef46fb5n,
  r: -0x329ea949490c6d9ae91efd205ea1e865aff86100n
}, {
  a: 0xc0d7e33a661f8777ae99f6eea7c216b332c9e8c65cb9c9ed0378de2891n,
  b: 0x8c89239a366ff903ceff6ac3ac5ad92995e8n,
  r: 0x15f489a8d1454e3dbf503b9n
}, {
  a: 0x6e5dcb2d8d7d2adf6ce679877c089f22be77ea231e19n,
  b: -0x10b187f6b4071bd9d66213faca716ad0a3b19e93a8c2d5a1n,
  r: 0n
}, {
  a: -0xae334dfff28c40af6b345e0bef72781a66d6f0c95d8d6a19n,
  b: -0x3e468347bd41d83700698954e75e3fb979f8dn,
  r: 0x2cc1907f8eb9n
}, {
  a: -0x104ac586e3574f9c6fbda9166f6ceae8e9ab5afbbfn,
  b: -0x77ccda8c1403an,
  r: 0x22d07c1000716151ee629e1708d53n
}, {
  a: -0x58da2344d46312aa9a8ebacf51b0e579eb129b4dd8dcc2e1008b9a2n,
  b: 0x4325dba91n,
  r: -0x152bf3562b3c870580c1a9e6b961e40077d90c6beb30989n
}, {
  a: 0x3a7edbafaac462b0dc1348d69bce5c95e2ab76c08827e2e139n,
  b: 0x1e9ef5b5f6702229ffbdc920404f6n,
  r: 0x1e90a33416972ca39c287dn
}, {
  a: -0x7205df6461a8872e833c4ef3c8ebb0dbf923b94e66a1c719e9d198c7c751e6en,
  b: -0x56045bee1b57ce17c967fc4688eec51e7f3c5a7d5ec5n,
  r: 0x15359953a44fa868b2a1n
}, {
  a: -0x57402d30fa746df0c4e8af45d6e155e819c3a9d34ca782fbf1b94bc624941cebcn,
  b: -0xa853456106482ecf1en,
  r: 0x84b24e5a3edf24e1f920fe10c281a19d80575362299c6c2n
}, {
  a: 0x405e8139a9f89722ca8dc5f9352a6b7dbf29dc79e8e654abfa371n,
  b: -0xc0621ed7d53d25f62ccfab5177fn,
  r: -0x55a7910310f81716955d5c66b3n
}, {
  a: -0xa614001da2577de16ce5850d0731aebbe0ed324ea2be33b556da3378c69f460n,
  b: 0xbc1a24e7c17eafb1266f54f6052ef8e11e0d542418209261n,
  r: -0xe206b22e43aee22n
}, {
  a: 0x8563bef8074727c87c1d878ffd45f2a2f7e3c4ba204d3fdc529fd9c4760n,
  b: 0x95b271650ed86962d3547290dd664n,
  r: 0xe41cc3bd4e78f31432925de30c00een
}, {
  a: -0x6a8c39584d17f86b8c94a4a843dc2e6f0159def88c2a48bacd962a02ee637a63327952n,
  b: 0x6a655e2991a5d9dffc9n,
  r: -0x1005d7dfa4de5b374e5ddc7a7f7a12087ecaa809922c1a35c70fn
}, {
  a: -0x52d161f6cf7dd227bb52f7e1b69dee10cb09b40c097661ca75895fb35c82n,
  b: 0x3f77f0a24893b10e39ffc506bd36a7n,
  r: -0x14e0bb0e70cc45e3f2260d2a47f215fn
}, {
  a: -0x762c014d52f79a812a2a0e5b25bcb23d731cc21c95e0598d1a21d2c575b6b0a3aaa7c5n,
  b: 0xbc21e93d3221b9d53d9bfa0b9en,
  r: -0xa0cd36efb1f2961ff8ece8535da8009954b13911ce29n
}, {
  a: 0x6e0f82625df958fc8961e8348e9dc6031b5b6959ef4de993298e97n,
  b: -0x73cc0fe97b14cn,
  r: -0xf35160a40144e418ed30268ff24b3fcaafeeb6be1n
}, {
  a: 0x37d97f78cc28b1e5fa8d243c2d1ae6049af623c11af6d6d6f96n,
  b: -0x5abb8f67711n,
  r: -0x9d940b8b5d27b4728c2a279dbde5ba709810bab2n
}, {
  a: 0x187bbbdd99b77226220c82f537e05cf7190335b9eb1bc88cbf77d17cefn,
  b: 0x970ecc2381fb6an,
  r: 0x297e0696fc75438faf32f6718d0445befadcf75ae8bbn
}, {
  a: 0x30f0cb57f00a4c5ddaf7148377df6f2e0ae0d38e3d92fd58600c4n,
  b: 0x3a9fbe50d474bd4ddn,
  r: 0xd5b6e4f0a852750eb543939dae5be662fcc0n
}, {
  a: 0xaad71e4d8e204f7e6a4bab4f24bde1b1e4d2b2b274bcac950c831dn,
  b: 0xca9d4919529cb6a4c42be0cb8e1a3c5c95b6n,
  r: 0xd7da9ca33c00a451c2n
}, {
  a: -0x640518e1ee7718803c5ee8d4f6c577a54c613591e7e3fc6dn,
  b: 0x12488749767a804608dd4bde96748ab99f98dn,
  r: -0x578766a6d18dn
}, {
  a: 0x83f816928d94f2ba0535a44d00591e06f71e3ad70326n,
  b: -0x1bd94fb6b97b83b1d94e121n,
  r: -0x4bd1f4e9b3dcf084f8652dn
}, {
  a: 0x29202317520433cfb54ee6d34033620e0ecc7afa705n,
  b: -0x6386889bf84a4a5a868d5f863a6270abecn,
  r: -0x69c885a3en
}, {
  a: 0x56ef535680c269f67043e87e67e062677f141552022e481a271196c3n,
  b: 0x54c2785d08d4ae394016ad90c5f257948a66129n,
  r: 0x10691df8405c0d4675n
}, {
  a: -0xf6fef6d9839ee3fc06fa197114f93a858c0c2196fbed2da5f7ae61n,
  b: -0x33682b5ad4116f67f4b47d74n,
  r: 0x4ce024e54d42457aea38aa0fab26cbbn
}, {
  a: -0x4c3431117c1125fccb5f02dd36c28226449a0e3e1ba720c2n,
  b: -0xd63a119483d9274df40n,
  r: 0x5b103138bca115db15fac98c338f0n
}, {
  a: -0xccc623a2b48c5b20b32ac07ed08702d93ac333d3f5abcad9c044e3ac9c2b1d2dc0bn,
  b: 0x53b66eea024bcbn,
  r: -0x27237255fab0835798277e656d880ab6bc29bede9e9293cb19ae6en
}, {
  a: 0x61c5762b56f5d2bd98e2b41d45b355e0062ef0f43b070adc548958cn,
  b: 0xbc3bbde012d6250f11970376n,
  r: 0x84f86a9c91ba18520409d7673c38003n
}, {
  a: -0xa194d31ef8a0a8316afdfa7270a0bfc333f7741c9e67f69an,
  b: 0x7n,
  r: -0x171542bb4816f374c62448597dcdd240752359baf20eda16n
}, {
  a: 0x1777e32bdc3b34bf3f687c6e9a1d2c74ec2505df88fc33e68eb34cn,
  b: -0x1cfce67038fc3f007n,
  r: -0xcf414c30d270f85c56449593c2e51bfad4530n
}, {
  a: 0xe63cf114d99cab82bb5ebd19418115d7813a98ada3bda4a6fd5952469cb9dbbn,
  b: -0x1aa53c592d9e323n,
  r: -0x8a40b8ba32c8bcdce4ac0637767294f00ad2bdf1e1b273441n
}, {
  a: -0x7eb671def905535928576977dbd0142f87369cfd55c619b7611e798n,
  b: 0x2b0ac09036e178c82fdd86f96d0f42n,
  r: -0x2f1a5742e5bedc7a9d8efa64f3n
}, {
  a: 0xcbb829b15dd6d49e266427a7d4e5ca254d6a71eff0c639c718164051ab3n,
  b: 0x777d903668160160dd05572fbdan,
  r: 0x1b4745c855562999017701428e64c9a08n
}, {
  a: -0x134e7901003ba40a8730f205f10f539f21354b67d7c3e5b404n,
  b: -0x5b474fdba2c7cn,
  r: 0x3625aaaa725517caca743252672daa846a145n
}, {
  a: 0x81a1c892518927c3ed00b7e3daa15e60d223ba4fe556d2ddcen,
  b: 0xbaa681031f517f46df693e1n,
  r: 0xb1cbe5838cfde18302b49c70130n
}, {
  a: -0x454497e033227500f5f995084cb6dc31d5092f0d6acca6a991091a67a8n,
  b: -0x5d9284aaen,
  r: 0xbd81bd0b01214155cf3629b2aac6e60befc209c3d26c7857en
}, {
  a: 0xd514c4c19c3d3b752a04ad0ec12a796ca7d178c13abdbn,
  b: 0xc953cf936ca356b054374f3fa3c1e1fa9a3n,
  r: 0x10ef21290f7n
}, {
  a: 0x2c3c88b60417a9eb657f226becf26692e5d27223657c88c85a2d59cdn,
  b: 0x3975f95b3a5bec91n,
  r: 0xc51528bf3d1dfb22f7f9d06c30cc92f73ee73adan
}, {
  a: -0x239ad3d6e9fff03fbcab4a569660c083875e2c515ad0n,
  b: -0x58c8616681cb6f73eb5c3a38387f9667dadb335n,
  r: 0x66aa1n
}, {
  a: 0x879357d597455ecca9133d81f929ec0ae413ea7d53n,
  b: 0xd0133649d9faf762a1a95c59193ed7ad14fe0d6fn,
  r: 0xa6n
}, {
  a: -0x2d8a0808e64f6c1d3b49ce712f213b632b395acb38n,
  b: -0x34f5a974n,
  r: 0xdc216df0955cbeb53ab40b22ce3577b581n
}, {
  a: 0x19e619156b805cd2bee908b134f395d7862648a53a5cd272be62f787fca7596c756d9n,
  b: -0x9c525b48n,
  r: -0x2a69c50e65e60b44700e2fb37a48894a74ac0869f497b4b178d93160c83afn
}, {
  a: 0x2f75ec43882e461163fd328f25e185ff8cba93648c13fead11a05f18223an,
  b: -0x82ac435a9e9a04fa92a384f068d968b1ac8694362n,
  r: -0x5cfacb6af2d4760b6can
}, {
  a: 0x5545409c0d8130df7a3122ce49505f1344b7be498d37e31809d133947ef17e839ca1cen,
  b: -0x7fddcc4b5n,
  r: -0xaab81f16b716f37b7a37e394f1831f95983a3c7e234089ef716ca59700b79n
}, {
  a: -0x21802e26c323d1620ceae474fb7d057e5294212bb22d60bb24db40dc5ab103309788n,
  b: 0x33ac6c752f053c857e4bf648n,
  r: -0xa5f7f22f88ac58a6a72929577b317519700e23845a81n
}, {
  a: -0x6e216a608e590a8487c8c3120ba57a1a7e426f0235f4821e9bf3e178aa16n,
  b: -0x45f21dfa6ffe933bf3501837684cac9c624743d52d1138n,
  r: 0x1931349fcb570f6n
}, {
  a: -0x6a0f479877d1bb51940229ef34d165fdb08e64dbbea13dd4n,
  b: 0xb640383b4b8b116f0e2880ddf6fdfdn,
  r: -0x94fa3e53e346441c52n
}, {
  a: -0xeb40b84c1b0b1ba1d1fed18fdd2f0c6af55235dc2f19454c403dfc94n,
  b: 0xan,
  r: -0x178678d4691ab5f694ffe1c1961e4e0ab221d22f9e4f53bad339660en
}, {
  a: 0xa51cb5f1ee721b8d96239b89f07fff006abb9d92c08495n,
  b: -0x33ce6134c2524ad74b71b27cab8eb5n,
  r: -0x32fe6ad41105f62b9n
}, {
  a: 0x3dfe9661fa6170655ca187863cd50962f523c4e61856bf7a9a8a1bee4339e6a4f67n,
  b: -0xdba22525a60fa062e20ed54e41384ec809539cn,
  r: -0x48426b631f2a89c2ae2eb73ee1c3cn
}, {
  a: 0x83a96055343b81488dfeaa4a0a4306d13c6cc0c280fn,
  b: -0x8636c8208ae5158ae8b3n,
  r: -0xfb21b17d2b5e8d1b2d95a95n
}, {
  a: -0x6e85cbfc7bbf92ba2982eac0655291c22b29a86a5f32522723215367d84e4n,
  b: -0xb0508d146db322d853551b5bd6a5eceec6fdeeda17ff820n,
  r: 0xa0792b2dbdbb64n
}, {
  a: -0x43b66da5f720045f45d8411d2a6ae7bab30ea91739f139080b7980eaa2a563fen,
  b: -0x9ffbb23d588dce995ba6ed8de657dn,
  r: 0x6c59fff2465995927eb83108d5582c7173an
}, {
  a: 0x337a0205255ada6eb1a604851beca56f07051656fc227a49ab75n,
  b: 0x329n,
  r: 0x104a0ca9f9779161ffe386a6cc65771e630d516ebfce275462n
}, {
  a: 0xc59fe70c451652771069c250f47016dfbd778c24095673962f7dea98ed0a618ce2d905n,
  b: 0xf6ac1f41e325c2d9f1eedc616112250n,
  r: 0xcd18fb07135dfbb392b8921a73621c95472aa70n
}, {
  a: 0xb5fc648dfdc4027e0c6bf5d567a143d3a44f57212dc4518552c83d3a4804d2ef36n,
  b: -0x8c5ff00d8ce82db8n,
  r: -0x14be2c5d4dd77386667ade86209f750d7ba14d6bbab01bfe4d6n
}, {
  a: -0xbedcd388445981b17ad1fc2b22c007955356a9a3bed5ee386efab1d3dn,
  b: 0x1f3cad4965793c4afd374d80f0e41d9f8b1c638ce35n,
  r: -0x61c32396eaf8925n
}, {
  a: -0x3c01dc68f26290b5af3f2e8e10e155f9e4cef1e44824a9c62d0df86b75cefn,
  b: 0x9633fd33a734021n,
  r: -0x664620e8df0f3204a7f272eb430f997139e17f83aabb5fn
}, {
  a: -0x5cb2a39a7b12982a7f92b554a32c718e0288a182931201n,
  b: 0x75697a64c0127b9n,
  r: -0xca1d3d38a797e44d9dadf589aa6f0b6n
}, {
  a: -0xa0383648cdf65359ebb710e5c33dbe798bd1cd96f8a12b9b53baf61a2beb3fe00fn,
  b: -0xccf0e2ed3aa803459n,
  r: 0xc82300148a827db6224436e99c8e7afc54f43730bb75ef084n
}, {
  a: -0xcb6f60c517b85bb1a9a52fc09c62c7d9a81b5230711dda600n,
  b: 0xe4e1248883c556en,
  r: -0xe38a66e95dbf28945518396ad7864cbd0dn
}, {
  a: -0x3f058b3dca89d3ebec75a29038890307c493451b12257cac27e4179899e66b75n,
  b: -0x2f15a30c307c4af4dfn,
  r: 0x156a694eb45401913e8167ecaf69b21bf69239bde00e228n
}, {
  a: -0xde82aa7d753475cde067b9e5c92a44dc6449cadaae8bfd2fee8n,
  b: 0x2df4d9944d207bcd2adan,
  r: -0x4d77e104fb68fb59116b36f815dd6c4dn
}, {
  a: -0xb437e1623a83ac8abcfa851b5095155db5079d2ce3a19n,
  b: 0x6243f65d453f371b1664e7cn,
  r: -0x1d5809f0f8784f3b27c6c69n
}, {
  a: -0x5b9962e2cb32b8cf464d56dcd189ed4bd5ea3bec5eb169fce498d6c9f1199cb48bbdcn,
  b: 0xaadbef3af57ddabd5a561b4aa19f9d61664a2debn,
  r: -0x893e75c275ac8bc63ed838789ed1fn
}, {
  a: -0x72875cbc2fac3d7f75285f51f7628d635afe0a51b8b4774513f34ba6f430e21fe7n,
  b: 0x70d59014d23da19afe8c1f7c8cd1cen,
  r: -0x103d835eefe299c71e55dd4068a707f623a26n
}, {
  a: 0xe885980b9f6ce99ad36faff8e88dbe11b770300592a5a08n,
  b: -0x38641e35a5a5089c5605ca06823acb44d4390dd82df184cn,
  r: -0x4n
}, {
  a: 0x26d0bad171e747a387f259ee511698a89133764a0de6cn,
  b: 0xfe69dece2dn,
  r: 0x270eb12ef131dfd9d49c92d9a15fbcfce4fn
}, {
  a: -0xeb128379207b97fc37b69937fc61d458f0c701cdc5efn,
  b: 0x1a50357f71dd8498d2an,
  r: -0x8eeff9a4968191bffd126b4353n
}, {
  a: 0x5551ecc963686102fcadc896335bd1dbd573dd97882ef155n,
  b: 0x5ad9967c68d822c98b5dfd7f33c557edff91n,
  r: 0xf06ae5f76b38n
}, {
  a: -0xb9c08553d768cd224cf7e208f0bb1c7fa009e13c2a5dn,
  b: 0xa466e28a4bb44f54c389b6f58b929f2n,
  r: -0x1213ede27ea14en
}, {
  a: -0x51a2919a543298ee5f94be9a7bca4edf67471a7b29a1840625b47acb1e0d70n,
  b: 0xa531b5b9a103f6dd04d86b47ae5n,
  r: -0x7e82551a9e86fe070cfe4ea004d0c328cc7n
}, {
  a: 0x6e015e953b35d988ebc34020e1b1cfc38a3ce0fd0a06e448655d1f2b9d14n,
  b: 0xecd55927a5b5bc362fcn,
  r: 0x76e86e684b932a50285a67534aa26a14fd7beb9c2n
}, {
  a: 0x6c3a90f5d4d982d7b63d4ecceefe1b43eb98b8a1c461ffeb12aeb017d87234n,
  b: 0x8n,
  r: 0xd87521eba9b305af6c7a9d99ddfc3687d731714388c3ffd6255d602fb0e46n
}, {
  a: 0x31cae467bcb9e0b66a216751ae659ec41e7977fa7e1934e4c5ce90b627ae340c1dn,
  b: -0x309a61eda1bb35d8468707dn,
  r: -0x10643e6948d09869ec6e93e02cf8d1e7e77a8f4e4168n
}, {
  a: 0x3bffa7e3730bdf46606b3a8efce355377ea01dfde1caa79538bn,
  b: 0xe81f5d1c513849a5f62a2c6a6b71ff3575d4ec4n,
  r: 0x422ba3e71800n
}, {
  a: 0x1e5d19a31cb7bff69bff3867db9e59d0034f3dc2a061bn,
  b: -0xbc6bfbn,
  r: -0x2940f3ccf9333ad9938c8ef6dcf50be9e74ded7n
}, {
  a: 0xbff0b02c31e28940f3148ebf5422293b158b460736a032f72f1n,
  b: 0x274c392946cebc17f83513317d9b27e4b87963bac5dc216n,
  r: 0x4e25en
}, {
  a: 0xd07dfa264a8f139ec533a74fd49f91667f7b9e015f93d624e1c2bben,
  b: 0xe4dc83f3d5060c0bbf81986ee744ae69e2958afn,
  r: 0xe9371dd6cef0fb1an
}, {
  a: 0xb10f01b6e266caf0036be00fa1c2e9e896bd66c4386bb382f5n,
  b: -0x83943722b6eaab9f43n,
  r: -0x1587c36276e1644c764e3edca72e38154n
}, {
  a: -0xf0fe12b31cd8b1995a8ec92b9c9a837a12224197032b5792d9e6f418531ad8335n,
  b: -0x2650bb9n,
  r: 0x64a2a5c9e5d7749e20c73f71f7968edc8e94fb78156ac2d29de2c0a0dc1n
}, {
  a: 0x42829cae0704c8837e9b8c1fe5e1caea4a56ff62cc1daf64d9abf829381851n,
  b: -0xd7e798873b4e6a19c4354007618cb680ffbf03549fc89ben,
  r: -0x4edc992b13c52d2n
}, {
  a: 0x5e1ccc4849c81e3a2b62c6af280506071a76ac563372n,
  b: 0x4f43696063f1dc817d053bba11fb1a4ea0dec3e4c2f051n,
  r: 0n
}, {
  a: 0xfe44d73065b7f15ab1f4073f6493b97e77ee58f4063cb30752fbb2fbc3215bdc9fn,
  b: -0xc1aefc68423b9e04aeafd030ecb74557bbbn,
  r: -0x150140d86c1479dffdf8cdbb92fb13abn
}, {
  a: 0x14dc770a141ff67fbe9bdaf940c5116ac202652d0cfc2db0a83beaee844bab44892f4n,
  b: -0x27968e4021cea12c581n,
  r: -0x86e696c52ab30b2189dcd39cca0e50b5f4e4cd6af77d263017n
}, {
  a: 0xace1b68f6a4d1f054650f3635332461ac9e43e0901cca1621cf5n,
  b: 0x492b2eb7f4f77dd91f42995f7n,
  r: 0x25cdf52fb6f35b79f99bdfaa6e4an
}, {
  a: -0x2df1619c6f27772705dfe54e6e0ce7fe0e1f73831ed3e4da743cde9acd389n,
  b: 0x5f4n,
  r: -0x7b7aa43efbb5ff10dc0d287769a055fc1de4fe045aeae2b6a33e233894n
}, {
  a: -0xb115741e529513014aebd3a2cc35edf66ea3b937a7e22891fee257415n,
  b: -0x81a5ab497fcc5a75n,
  r: 0x15daaffe3c77ddc1b0dd98e566b4a34d09b28d2cf8n
}, {
  a: 0x9a19745fa1ce0346ff0e3a6ce60f7545c73ff66fd029583b650ede707d7aef201c04dcn,
  b: -0xc03f663a5599d20529ba325e6760eac3d9c3c2f90d923n,
  r: -0xcd3383abecfe9b2f52a61f632n
}, {
  a: -0x7922a6000551a7e699a1f6f56a56f6d2209c08114cff89ae2e6fb70n,
  b: -0x75f490n,
  r: 0x106e6d24e31385cfa0af6f3c77208f1053281080b0f2b7361fn
}, {
  a: 0x17d3103ec2408a0b924403d244d87caacc8f39adffab26a30994b9a4981ee14c99n,
  b: 0x4e5n,
  r: 0x4de18f9d24940c6805c59dc18b09f7f72bb65e29442d7105a382106747b2c99n
}, {
  a: -0x14c0c78cda00bb033e46d2f400da7e775eb5d06f997a51cf271f7aba223cn,
  b: -0x78bd1b2f1db10fbcecfc69719d41bd846bn,
  r: 0x2c009647fb4de5a5ece6c74d63n
}, {
  a: -0xffd38a2336dd0e9d376dba023b348541d8e97fbbdd6c478173n,
  b: -0xa90c42197ae8ce9056f6bbab85606371dn,
  r: 0x1836a04c08734af052n
}, {
  a: -0xc35d6784e3a96cfddc0c4a3829ae0364ef50f0cc902e630ab5687579a29ec32146n,
  b: 0xb1ed6ae54bn,
  r: -0x11916bc2aae5a312ab55b8ed5035416d1271d0b7a6d690b034c550b82n
}, {
  a: -0xbceed7e0a97828bf8526676f77f0d6d770f6ec56198c5f57n,
  b: -0x4614ce3a4f0421319n,
  r: 0x2b227538116e3dced4f152f94f92b7d6n
}, {
  a: -0xd391c71d9bfb0ed5878ecc40f113238fdfde5231ed25684b325c5c21n,
  b: 0x56a6e0419a52963171859413f3e0b3a6cn,
  r: -0x2710ce5d3b4333bca34602e3n
}, {
  a: -0x257b802d6a7169aa2bab393745f760cdbf045a810cn,
  b: 0xbffn,
  r: -0x31fe2ac01def0b792efd8c155f11c28d351f90an
}, {
  a: -0xcc0d30461bf13c8511f6c00087d1ad2ba5ce6b935cbed27ddf94a1a8a826n,
  b: -0x6438ac01313d6e7a56n,
  r: 0x20937d19038a23b10339793b047a40892680708cdcfn
}, {
  a: -0x20d6ca4232ccc8cc34746d48a6386a8d26ce3f1c83n,
  b: -0xa25e1672141e64aa707369ef542c18b5c7d293d7n,
  r: 0x33n
}, {
  a: -0x95bfb3aaec41f82a1f7eebde819b96463d15d6f971230n,
  b: -0x85019a673e6af539999880f5e39247545e89dbf1e7n,
  r: 0x1203n
}, {
  a: 0x4b5e55c8adea913e52244c07b401ec134836bed79833a72a6a494f9b1654b59193dn,
  b: 0x987981de838c1582a9cdd48e18819d2adf88n,
  r: 0x7e8a91008e256679a8fa153464f87d2n
}, {
  a: -0xe096b8bd489f449df8f8da34cac298be1730c1bd5e22388b7275en,
  b: 0xf2463n,
  r: -0xed5008d7a7230c5f39c607a49254570083f3eb299b261424n
}, {
  a: -0x84944b3a483fea13a34cf323c31de4f427f43fae5acb7be0f96f5d1e2f4fn,
  b: -0x24c6n,
  r: 0x39af4f03c44868057fab226108278c3e81184f7be28aae183ed7db80dn
}, {
  a: 0x196114f9bcdf28e6cd45b0cbbf2ec2675712b20eb5c01418bd358fcfn,
  b: 0x78b8bn,
  r: 0x35d19c68fb7c3900e971a7b57a8c9bebf3cf71c930e37555649n
}, {
  a: -0x3d887e14ead789df14d4e073fc3f4e25e85214e6290c9a7ea0b09f884eb47404n,
  b: -0x9eca3ca23cfe86eaa99262aa777676f980f750n,
  r: 0x63340c2dc1509712e7ec86bdc4n
}, {
  a: 0x5715bbbfe9d00dfbf7b4a4936ea7a944bb772d6b5943975n,
  b: 0xe427a1e48e409fb2fdc761aeae07c20d3dcf2c82dd8n,
  r: 0x61b6n
}, {
  a: 0x13e35d48aa570367ffe194630d6607dbe766b6cd7a92cb67123f276ed28n,
  b: -0x7670daf9aa4cd04add2a43e38169n,
  r: -0x2afc8f3a98eaed38df8483ef8e4e7c3n
}, {
  a: 0xa3eea2fb98157c7a3de0eb526de42ab72048d96802ad1f50e3c3e037a826c6e04bn,
  b: -0xe7a0c8db61948ae6dfe1fan,
  r: -0xb52e5f2310bf36001bbe05332990c4e4b58dfa51bb67n
}, {
  a: -0x83fb5595f6d79aabb71804f3da675c2a7aa8f0fd1cdcae7835cce433e2e23c8n,
  b: 0xa15n,
  r: -0xd173e261581fe7ac3b43939cfa3191c50cd9b85e9ab5cc92bb8ac9ab82d7n
}, {
  a: 0x996d3c8b9f5fbb247a73f71c8d2982a63bc5ddb4c9f50754f8n,
  b: 0x5bd2665c6259n,
  r: 0x1abc132b5f5280a42ba09e9925fc850bdf83174n
}, {
  a: 0x3761685c73ee346a3178a562bb384cf15cc286f550e4ae59c41a59dddcn,
  b: 0xafd6c1f96f80d85c57a64a83ae3919452n,
  r: 0x50a093cd359f05c3d9c1a9b47n
}, {
  a: 0xab110f404aa2342be8e1ab528748e08ebbef90868763555eb47a9bbfb9cf01b08012n,
  b: -0x850f09a09n,
  r: -0x14920320564acbca3476567630285f3a6746871ff994db226646c6b232dan
}, {
  a: 0x545ffc040098a45b4ec51ed1456a18f31961cc09c4cc9ba63ec7863a62f20n,
  b: -0xd21faa0a5a1a378a9d9df74d28f4cc3ad8e6n,
  r: -0x66cbe8e43f94cbf62f72b3524n
}, {
  a: -0xb8989320d3af425a15c9a4a3a4c551846e98f07528f48dn,
  b: -0xeb27b6a5a30b23ff087bf9n,
  r: 0xc8f58ab94dfab4ff3bb6f3c5n
}, {
  a: -0x9b02f0b5aa780ae21dceeb1bcd7f1e94ee8e30912f7b179cf7dc25d51ad910cc5n,
  b: 0xb7f6915247b0ac0n,
  r: -0xd7b61af3d0ae097016f05a9c5009a96b8e228a825fcf643672n
}, {
  a: 0x5d16d9152ae28bbb5cbf15983488d2f0970912bf164d9c8n,
  b: -0xdd18c6eab9576b1cb7f844f406n,
  r: -0x6bc8e14d700861afc3f82n
}, {
  a: 0xe2c1eaa7cc6a6187c71dbde44fa48f13c6ceafdb78e8b1e968d029728227a528803dn,
  b: 0xca1f0b74a203ba82d7339f01d8a0f7e68656e7aa2n,
  r: 0x11f34125faab056317b21ae830a7n
}, {
  a: -0xe1548513536fc926cb26a2f96ce137c9ca36cd428b5a1eec4c0ed399aa6ec594n,
  b: 0xc1f84cbd3f52ef3e5dffa3e3e7923809e4485fd4e9b6d8d2bn,
  r: -0x12963952afde8386n
}, {
  a: -0xadb177f06b9bf0251e26f2eb21de9062975b3c1092cn,
  b: 0xb22ff96a09b884adfe3b28bb1b8491a4da1dd1232dcdbe4fn,
  r: 0n
}, {
  a: -0x1751debea507bbd6a534aebf534dd899e6fa36f37107478fn,
  b: -0x72a4fee73fa993d7825dcbfaea00fc98d97d8d28e0305c45n,
  r: 0n
}, {
  a: 0x8bb016b624e1289c774ded7cbc1c4039c1aced523f6f2e3b74ee5cd43243dc6n,
  b: 0xef5c29b425n,
  r: 0x9566151695f9a3d3f82a557c5d4975eaa10772703f78e11c384f1n
}, {
  a: 0xe6b7098f42636a4777d9600d4c1127297be958178854fn,
  b: -0x9a75bba2bn,
  r: -0x17e6260f627c19130c04fa711874fd4962a4dn
}, {
  a: 0xc95e4a5de79553b1b249062a8916cfca67ced91d01c6642f37a6n,
  b: 0xf708feace978915b6b0n,
  r: 0xd0ad0abd98cca3afef8c874f64a856b36n
}, {
  a: -0xeab43f46dafaa18d4dd932d8cf6e32c3efa29abc22386e37af8419ce036n,
  b: -0x2f5002987n,
  r: 0x4f5f182575ac6f95030f0bc2b7d65720b068fa5551c2b4f803an
}, {
  a: -0xfccbef86bef25b3b2c309111f9496af740e508de70f6a56ff53116cb4n,
  b: 0x12b43e94d096e05f90dfd3987bf05580cn,
  r: -0xd83fd864f7c7c852627092147n
}, {
  a: -0xd1b0ead666b554b79c31508755a6696c2fc3a0252f20472en,
  b: 0xb4cbfe5e060a12n,
  r: -0x128e9b3e8f9ce098cbfc8b12f1e0dc4234en
}, {
  a: -0x98b7bf5d2ff30d332ab50b1b28f07808845118f0668416n,
  b: 0x2689155e1bb9e1cd72n,
  r: -0x3f689f83d16982d4fda48657cf076n
}, {
  a: -0xc724002dd211d8e5748508bd54f2f713ac10643700c0244d0ea6d4edf8e8cb7an,
  b: -0x1ce9c872ff601784d1d120757c1981n,
  r: 0x6e33526701f3f3e11fa15a5f95962c37615n
}, {
  a: 0x4e9fd4e9d8f6ce28108979efb0481787747c902f166743aa63n,
  b: 0xc312e8ccd7n,
  r: 0x672e398b9e33d2c77d26995b72393100782d6effn
}, {
  a: -0x5a5240134c1325095f8a1e44846e6fb9130dd29b210e22a5ed640f04dfa3818c15dbn,
  b: -0x70c507a83b6485823n,
  r: 0xcd0a27273165bf6b6bf5eafe5cef9059d89b12598d3881295een
}, {
  a: 0x4a52922a35e663f8e9cd7bd57fe81a18b36ec067afd916186a8872dadn,
  b: -0xb5b13e7521n,
  r: -0x68b7f6b275a8d07861412109c89c55d656792b5da42c7e2n
}, {
  a: -0x95bdc5f2a38935a3954967bd290b2bbf6581500999ffn,
  b: 0x6c9ec2ba3100f6dbcn,
  r: -0x160ea73acca4529e3a9d8fcfed4bn
}, {
  a: 0x23af5167738d41753f29483ec1e9441ee56b49ee11d1c445n,
  b: 0xf36857c93f135297ac7b29fcd1116eb24n,
  r: 0x2587ec50db93391n
}, {
  a: -0xd0906f731d3f7fcf6860d8272783736a41c6089c178238455080n,
  b: -0xae540n,
  r: 0x1324687ceca2508536299bbe4c8bea60b6fd8c463889b10cn
}, {
  a: -0x402f2092197e5dfcfc2fe7cb7de496a53920101b469568061088490864a45n,
  b: -0x3651af55930f7n,
  r: 0x12e7e23790ae245846742eda6b42768d25860a5b567c1a673n
}, {
  a: 0x2293cf3cafb14e1905d6f5e509d36f454ecef374e55e13d6n,
  b: 0x4661a79bc89893bd68aef71641192d75e8948bda6421n,
  r: 0x7dc4n
}, {
  a: 0xc0ab9ff282f4d58b6d4f85936534f8823c7b4007c99efn,
  b: -0x79cn,
  r: -0x1951f46dab3afbff6626d627587881618ad6e63f0d5n
}, {
  a: 0x16527988d596711d7f1df8764376d16210be8e4fd3557dd6n,
  b: 0x8b415af2b987bfb517ae766148dfc3f7a9b3e1dee297n,
  r: 0x2909n
}, {
  a: -0x613dea144e09513c2af59d878a1f08b7242f067618d92d6164387a3575b8n,
  b: 0x71014b5aeafc5384b9d89ca316ef05f814463392ccf78n,
  r: -0xdc4a4f2b054edb7n
}, {
  a: 0x2ace4f433d886d3f3d04fba08942fbb1382a18ce54940745ac92b457cn,
  b: 0x260023abd5a4f6ff1b6576f3n,
  r: 0x1205f581f444b02a7d21a7860f8642d78dn
}, {
  a: 0x6e75fe336b8dd1fb126c1ff9f70e428aa409df1487201386bbcn,
  b: -0x6d6a7a632fe759478a42014e5ebn,
  r: -0x10271e74bb3d693703c9726d6n
}, {
  a: 0x71e662257e7410a2bb31ed6f8ffaa57e4ebc6be43ba882fda7eefa7cafn,
  b: -0x9fabb7f8483769992503adf20b0ef30f54n,
  r: -0xb69d9b9701e040d3c0d992efn
}, {
  a: -0x9ea43e5912acd25e68ba12c3b2aceed9e0e92b9d993af220f5f6768a9a11dn,
  b: -0xac0b57630416b968d300817267an,
  r: 0xec0e9095be115eba05fb718edd1dd96ec4n
}, {
  a: 0x15c25baf773bca8591c2c0f0fb70ad2653d483fbac12dd2b95f30f57db5a277a0f2n,
  b: 0xf8b59f1f08e1n,
  r: 0x1665a50e5e6ca70a5acadb00050fed03e2dbee27017d6758b00b1cdn
}, {
  a: -0x43d98f00e94710aceeae8afd5a9c07f392bcb6d9d612fbc9d1e9f6ef141aa1d5n,
  b: 0x6138b4114b9af24220e7e1a084dc2e2bcd4cen,
  r: -0xb2a8debc62e9bf899e66e19c228n
}, {
  a: 0xcd026911ab1f5e54e6ae02c69a8c2f2f97262b7a30daee4570119fn,
  b: 0xafn,
  r: 0x12be644daf18cf92bbdb3f2819d53a709a40ee083efb25e05076an
}, {
  a: -0xd5f12eb44e9ca6654290f401f7aa2150bc9bb13494d441336713703716727fban,
  b: -0x3cf19b4f531f8d3b7cd839d4553fb9fb8dd8n,
  r: 0x382af0b88857ccdbf9b00de5bc946n
}, {
  a: 0x2d28c070a91d9f0f167394515c80963d5ea4d57702b4622e7c959fdd807f29725d2ecn,
  b: -0x148d5679b900a0f5d9647a720840fb1e85662f4n,
  r: -0x232826df1039a7c5ae38e2214f98592n
}, {
  a: 0xd5c4f7d5a75a44aa4b18144405372797d661533f30a4654a2f4cde38848a230d6n,
  b: 0xca49n,
  r: 0x10e88a5da6f9b2ce235f944aba5182d3e04aee0cc268fb6e2e4e114534a812n
}, {
  a: -0xaf9d7760987d86b349b104cd78679ccb2ceb994238e2c786d48047n,
  b: -0x294d602815f0be05b3c74f9d4534ac514n,
  r: 0x4407fce90346c01d723a51n
}, {
  a: -0x4ae6882a86a4c0598d692c6ede7d48ff13dc26f2c468e3n,
  b: -0x80cc07dca9328fa731600211fc4a4bn,
  r: 0x94dfc29212776ce9n
}, {
  a: 0xfefe6588bcd878ef22f76dd534f77b91b7b43c38363386fc3620d37n,
  b: -0xd9046f60dfda2aaa0adf2903d9cc2eeb459n,
  r: -0x12ccc4f99752350ebc5den
}, {
  a: 0x2d749992b96c5bc176ab78ff16d0ad42e5ddb2b78002f930n,
  b: 0x2f1ba66n,
  r: 0xf70502c1a538472e548ca336547f141ef9fe5d827n
}, {
  a: 0x95cfdbc9f55dd5b642313365e8bc2594075e6e5bd753743ed03dababn,
  b: 0x1bce410a5d02985b29e2280n,
  r: 0x563480d1f0169c5858ab8148e9d6815ec8n
}, {
  a: 0x3b108b76c5da63e1886380a57c05df2dbf92ff62c4146acfd5005f1n,
  b: -0xen,
  r: -0x43809f632b42bb4ae50400bd2006b5eb2415b627bb850c5b3c92b5n
}, {
  a: -0x39fee62aa2714823a75ef15cc744f1d00a94a6a5ab5de99e1185197dfa1b6c48974n,
  b: -0x70536111c2d29531ee7n,
  r: 0x842d5e7ce388b3552ddb207fe1601d63a5450e197beaa6afn
}, {
  a: 0x40646307e1c14bbeec559f125f634954ac42ca9d988cn,
  b: 0xc50345f5c313en,
  r: 0x53abf1e6800c985f241c846e29ddd6fn
}, {
  a: 0x8c19f30144b10673fb6f774ca5b14002bb5d9f1a030f2f79n,
  b: 0x3f7a1f2bce408f4aed5de8fde52f9ac168c5bbn,
  r: 0x23505bcd6f0n
}, {
  a: 0xbfdbbd4a157aece7f63ada1bdb21f585952e73c1f6d678abf247e51n,
  b: 0x5001a7e87697489539b3bef2674c3f3d5abn,
  r: 0x265e5a8c6e37bd4b1afa2n
}, {
  a: -0x933c7d47f2a724760b2b8f5ed3b5d1d5f07b1004bde5b154eb3bcen,
  b: 0x38e8cae2d1d70e2ed22255e434e424f416b6n,
  r: -0x296533b2cdf9db4e5a4n
}, {
  a: -0xca47b6702d2b749e4e97a9dfc8ad3051f86159d5997757f5e9n,
  b: 0xb2a656a79b40n,
  r: -0x121dc948ce7dd4283149137aa6b2b3dfc07cf67n
}, {
  a: 0xbd9d00b6a1ba4da6d29aa5a1de2ac68a8221178679b888b3134ef375cd1n,
  b: 0x2f4f8bn,
  r: 0x40201222e20533e288a0b172f56fbccd78fb78ccb854644e858342n
}, {
  a: 0x3793dee5ba2199ec6efb8ae665b6cca4a5a66beaa97e38c0751e1045cc7dc58ba402dn,
  b: 0xcn,
  r: 0x4a1a7e87a2d777e5e94f63dddcf3bb8632333a8e3752f655f17d6b07bb525cba3003n
}, {
  a: -0xfaabb95839dad475c09ab06aaf94d807e41306c634dd32963ffa00116145n,
  b: -0x58n,
  r: 0x2d9396100a84e0cf9761f187c2d53e8d1232013b4f6e09329744ba31b49n
}, {
  a: -0xc4de6166e9d9893151452b5055025fedf74ee43c26ce995f7n,
  b: 0x1ca6ef00a5012078fd8050065350855fd02dba4b77d288n,
  r: -0x6defn
}, {
  a: -0x399b39a19dcae9f374de4ee1e346eaf5e499d0a2455fdb953be33cn,
  b: 0x559cfe31067c1c334ea7ac71dcacd9bn,
  r: -0xac4105ef6d024b2b557e665n
}, {
  a: 0x9345d56a5cbeb8ae5a490bd8e316a0741bed725969058df438de26cb3137895865bn,
  b: 0xdd667350ee3385n,
  r: 0xaa49c549e21719c37663c13da94b89d96c8939b3909b51cf466f1n
}, {
  a: 0x93c98cbd6d9d6c23895b3d14ce4c7f4b214be30c4bn,
  b: -0x6237f8d3c8a571dn,
  r: -0x181327ea8d67ffa9d0a7f00223c6n
}, {
  a: 0x11805acbb2a2fc19c0225d310f4691ebdcd8483aab657ed9e30cbn,
  b: -0x8a2c2d2d8n,
  r: -0x206d00a0c59a3f9759186234fa920f7ffabd18dec6b9n
}, {
  a: 0x8ffc35e4d8314037567a47c382733cb3b8bea3548faf3238a7589e1dc1a02c88dc9an,
  b: 0xe60701162ee0922ed23eb7879fce929d134901aebbb5533n,
  r: 0xa03e2313c3b581cbfd492n
}, {
  a: -0x44844ab321bc454aa2b6fa5ad548eb39cd2cbf1909d26cbb1ae90c670ce33dd516f71n,
  b: -0xc2n,
  r: 0x5a69f3ba3c5a16d155659443142b7076803b0c015ec67fa516508f0bf1561788093n
}, {
  a: -0xf7af2e0c7e150cf29e29882e09a5f087ab6e0d4265f00f8cf6ffff87decf2a2abb50n,
  b: 0x4ce9de36e04dfd7aa62can,
  r: -0x338653dab4a2ca59e8a5d8fbfbfcd3059d6f44cdf9238824n
}, {
  a: -0xc12e562290c0a5da79394abd3431d587a5bc533352cb2d8n,
  b: 0x7f1c5243180a8f2adcfc36b36n,
  r: -0x18510b8023fcdf58b386d87n
}, {
  a: 0xadecfd1103ca958dfaf6f4625ccc24ae82f544c7e570da820df4ae62019dan,
  b: 0x6da7d39n,
  r: 0x1960b4479543d543d48f0ad4d4b85237a7c4bcc4e0a93485f1f7c8cn
}, {
  a: 0xe96d72bbafb02b504cdf3fedbd4dffd8698e2cae2a719dd32db5d537d72473c2e7b82n,
  b: -0x3821872f37cf0dc7a8d3eac74bn,
  r: -0x4289b825016e2b3876d08b74de3ac96be9e42c7202e9n
}, {
  a: 0x5066fe60d72d281b5a217161eb71d14abcd5de871b6n,
  b: -0x26e765e3317236a5n,
  r: -0x21112a1a8f4162ddb1ee2f308f7bn
}, {
  a: 0xdf266cfb67918f65a5f2617a52fbdbc5bf9342236a1bff2ab296f7n,
  b: -0x6e64cef42571b31dd432n,
  r: -0x2057a88cc72606f7a5dc29a6a7361dbceb6n
}, {
  a: 0xb5c0128eb198299e39e34243a0610a1ceac5796a5e5a54609edcf8cb61dn,
  b: 0x9152d6fe0c3d8e731531710dff6n,
  r: 0x1402b32ea035d76053b96e283ac327abfn
}, {
  a: -0x79950a4da83614cc02643fad077d64731f2788d56fbf802da21340e66d45f906b0n,
  b: -0x982b86393bf619761774d0f4f08f2759a52fn,
  r: 0xcc8a8d1dd02294e204b4b1b4836f21n
}, {
  a: -0x912f4173de0432762fc976b4fe394f565f17af5650fa0a82b1fb4b71d9n,
  b: 0x4an,
  r: -0x1f6429d3dcf9fd12a28c6cb183134f6c9ef05d43186d6a0e6babf4a2fn
}, {
  a: -0x20dce0bcdb87cac05edb1270473aec897180e9731fb9dfbf7e3e2b88c6c1n,
  b: -0x526951bdf5befea98894c6ddf8411b2n,
  r: 0x66157acac39f4d7599f96e48f98f5n
}, {
  a: -0xcce9328bfe368a9b8ddd805d48d8b0f08ec27477417273c59d24c82cn,
  b: -0x7b61e5a13d4648accfan,
  r: 0x1a928d19ebda541fd8fad5b1c4ed3e064565aen
}, {
  a: -0xd84cbb59d4c2d7a405f59befd6c843b32ddf9c6bcb496n,
  b: 0x5n,
  r: -0x2b428bdec426f7ed9acab8c9915b40bd6f931f48c241en
}, {
  a: -0xf8c5ac0e733bd36144baead370fcc3a3e5b803fc768948ef8n,
  b: 0xf94542379e7927n,
  r: -0xff7cf8125cdcc33bca9b40ae68c3508d523n
}, {
  a: 0xb07901f985fec2f05287dfc82baa1a685d295a7b7b0b72e8n,
  b: 0x3724d70f82cf2c41da2dba9e0f3139006e226179510dn,
  r: 0x33341n
}, {
  a: -0x44e77d19e4c9383db87d0ec97a0039ed31fd577a48e14a7165ecd6f381f47de663cn,
  b: 0x6ebb18768f83n,
  r: -0x9f4cf39732935c6f9ff8de4468ba2574bc45e5e5917bad48d0dadf0n
}, {
  a: 0x195c31fe8ad45f598377df5a4cb2b11169f8307485ab4b6acbn,
  b: -0xebeb33e4ddd60515a034e3fc1e3487fb8ccn,
  r: -0x1b84ce702e6764cn
}, {
  a: -0x313c12b45e9727cff8b2e4ba853af5af73c6195e6a74d37d8a6ec519c6n,
  b: -0x834c882419f69030eb9da47f17b9947ef3e0cdfn,
  r: 0x5ffec75c6ccdef6966bn
}, {
  a: -0x9e86a0d2a3331c62b69f1284d639ed8bd1889da69fdde743fd31c8867fea097n,
  b: -0x36e8b6d187446afd1c10bdbb4688n,
  r: 0x2e3169a3857cc7d52084cdc740af6adb4610n
}, {
  a: 0x43484428f4e193bbaa0ce00409bac11e146a3646d4658b34n,
  b: -0xc40bd71625100b2388de65246dfb80bn,
  r: -0x57dbb1819857171f5n
}, {
  a: 0xbf312e3dbdf54fec15d99b934d4d86ee84650bbddb5f3f368d256ac9n,
  b: 0x2b497f39eba9a5c0a695ecn,
  r: 0x46ab5eabce9a9122c6fe956c4c2f354fe0fn
}, {
  a: -0x62a3641f4748424db75088a3cbacfb58c3f27f9f9d21n,
  b: -0x8c03a48a7980f27855n,
  r: 0xb459479add0527fd7f5170ce8dn
}, {
  a: -0x262bc4793ecddb8db2f83d64c9fe2303dadaa21c78d39d5011n,
  b: -0x1dd974aa0d5d289cc7b0009c8519a2a6fn,
  r: 0x1475e5af6835c85114n
}, {
  a: -0xe4b3233ee715bcd3602a1282af96022c5804be5721a99e639a3a37n,
  b: -0x2de2ef94c5c6a4ff5caafe5fbn,
  r: 0x4fbe9b5297fe620b19cd5ffbf6ff21n
}, {
  a: 0xeacdc4961e4047f4c97f833f71ed4118907bd00456f19911671aea2ff9468b52bbn,
  b: 0x13b46a2dc6f0cb9c7b56695n,
  r: 0xbea85c0b92a6d47621f004882e7ee98218596cfd94b0n
}, {
  a: -0x7daa6e736037e1752d90aa527303b7b951b5bbe9b0f7f1e10378fe878c26en,
  b: 0xa8ec62a1aef7n,
  r: -0xbe71a50b56c8c1d57f073a62cd43c462ac59152adff3b291dn
}, {
  a: -0x94334d172b75cd8a95e0387d0e6743a598c20b5ca3e8n,
  b: -0x345ccc13c6b809083b69c83n,
  r: 0x2d48d17951e68da5290823n
}, {
  a: -0xf88ebd06517c9d9c8346643f494ca0bacedff6b9a03e6d09b1f77ee4677ede180n,
  b: -0xac171ea127b45659bcc70a257n,
  r: 0x171c083b4557a4ef40b32db6c27f6af9d37ae9118n
}, {
  a: -0x1b6eee51dfade48874175acdada7b151fefd0374b8874a62c860408c378050fn,
  b: -0xce4ecb99b2bc24599979d0bc10b48a81dc5e7dd56n,
  r: 0x220a814cb023cf1dd765acn
}, {
  a: -0x57a282336710f99f8bfd969f83de6d792c247591f493b190n,
  b: -0x80c5bec8n,
  r: 0xae37debed67c87074bbec9c6edf41145ac0fb2b6n
}, {
  a: -0x86ca5b6c1b39cd395d9dfb698ee4e9dc1530e4d5cf867509620f0fda74e1e5bce1n,
  b: 0x42948cn,
  r: -0x206445ee8235ea76807775e5457753f05edc2b36364b1fc655ae52d3268d0n
}, {
  a: -0xd082a121a9209f0090df45aa392d36eeb0f233fcfa6f12851n,
  b: 0x5f2c915n,
  r: -0x230da3eb1dc8d265e964b1dd3c321727c340310accbn
}, {
  a: 0xb0d3991beb7250d954875d3efc4c71b2dd015594e2148577018n,
  b: 0xf99a9c65107fa6a4c086bb42943585n,
  r: 0xb55b923a2592705f00103n
}, {
  a: -0x7a0c9a527abc1ed1e03dab6c6ad90fc9a30026aef19a7dac4591f6ef22b1776n,
  b: 0xcea858e2b38bf379n,
  r: -0x9730b04fb8e72d8f10f9e313c4896039b06f8032c2e49dbn
}, {
  a: -0x578273b6246bcf55e24d28188ad4583e22a442f72e7df22d0d106693cc0c5b622n,
  b: -0x677011e0074d19n,
  r: 0xd8943affe3d8ce8a0b405caff976c8abfbdc33cb752fe78e9c6n
}, {
  a: -0x1de9a898165ad12c3acdc62cfc984b4f224c46420f1821558n,
  b: 0x8ea6d34d0057806a128fe9a1a3n,
  r: -0x35ae4a66d645355cc7742e6n
}, {
  a: 0xedafe1b9760185fdb9f82d6e6e8e7cd6fa4e34612b917a9f21960n,
  b: 0x43d7e3513n,
  r: 0x380e37001159658c9c74ae2b29e6fd77edc06c6d8dc88n
}, {
  a: -0x8c1ab595aed2a284479465b7cdb997795e206f6e059c22n,
  b: -0xe532fbf7b84b2066f72b0n,
  r: 0x9c7cb1faac9903ab39738e01bn
}, {
  a: -0x8422b00f342f7c42779c3ecd523fb6c72a00556783n,
  b: -0x51f5e9a9f5f95511eb6799842e2f4d2ddff4f1cdeb6n,
  r: 0n
}, {
  a: -0xe162f15532dc5d302f77c632343b01879df84e34034f3acf618481dbb5f29e3ceaec60n,
  b: 0x7cf69202649f5ebc86498n,
  r: -0x1cdba441f5cc34ed9701ec0594183e3b5ffa5406d1d2eea00bn
}, {
  a: -0x7ccd3cef4d917bf8fea6655ade52e33d3a3dc32876n,
  b: 0x4873454n,
  r: -0x1b8fb49d25daf17073dedc02e214c4539c58n
}, {
  a: -0x92822b3d42183cc9b54be39c9866316f46fb8f8e29c229b2e84c30bd69a28331n,
  b: 0xf89f9d6fed5198da7990a08dfa71n,
  r: -0x96daf41a3b2a1761800e03a208207ef07b1fn
}, {
  a: 0xcc9058565e4786c1adcd830935400f43cfed57e17a7db359f1217b3dac0a512cf4n,
  b: -0xa7a4ec4n,
  r: -0x13860bb282aa9341b0e00e108ca43a2e9d08c3630167fdc3f62e6e665eb7n
}, {
  a: -0xaae801d519b5b862900ffcec07f04f248c2fdedd02f84n,
  b: -0x2656d48d3901287c1010e560c2cd8d0e2n,
  r: 0x4752ec0d803e9n
}, {
  a: 0xa23e313353435e4d7e20542c1b7a5099381e1572def72da2f9n,
  b: 0xe8f35f89cbn,
  r: 0xb24bcbd27da89ae0d44438d720638e3677ec1fe1n
}, {
  a: 0xde58a164f0f7cd40465c3d1bcc3d0d864a1ec78e03n,
  b: -0x5fda706f28257c70fbd25bdb8d86088606n,
  r: -0x251d4b06bn
}, {
  a: -0xf2c249cad53326fe3df11ea77f066baf020fa149b9a2bf4e5de2e7de7b1n,
  b: 0x91a41db1f59c92ff7153bccf1d65n,
  r: -0x1aab5614738107daf8cc795a6b88a73en
}, {
  a: 0x8de015e88f607973d61ad3436f015fb0f905ff6d3ded0961fa0ce5c8ebn,
  b: -0xcf2a4a29e52abf09667b10522699b3n,
  r: -0xaf51c6bdfd2d772989fde20e8dc8n
}, {
  a: 0x50b8601ede1b0c786a7f0d75f44f98f8265e12d8ee84bb03632793n,
  b: -0xc5c8dbd4fba87e04e595e7230n,
  r: -0x687aac441e2e20f6e560643ab61f6n
}, {
  a: -0x863f787a2fed65e31ee37df23e9338bb1a6116957c2c019d60fda413fd8bn,
  b: 0xe240aaf38b7n,
  r: -0x97e60f52c62b0364c3bd95d04ef091295308fec1c3cc4b239n
}, {
  a: 0x7cf88fafb12ed64f5557991b4d5c71e0236c13fc4d03a4bd77c9be8d4c3183n,
  b: 0xa56770ec66faf7d63c9c62d890n,
  r: 0xc16baf625e533a4e0013652b97bd60df3f09n
}, {
  a: 0x3b2c87c4759d8aa1596458512d1824521babc68e99d15f1349dfa227ced41810f1a7dn,
  b: 0xc3b9dc18200eadn,
  r: 0x4d6588572668ff92da0b26ae7c58282ce4b5b7486b512f3e48c12d0n
}, {
  a: -0x978b5c16d6d5ea96ac1e491a649fae8b451c548371b718309753d22eb0f6bn,
  b: 0x4f1c26e9e12dn,
  r: -0x1ea65da6d8c91075d139685085585c002cf304ca25797a5447n
}, {
  a: -0x99712fd3259d3b74cd53a772f6e56bd6ee266f608c3fen,
  b: 0xc9f8fb16c94214b65dc6ec1f94f2335n,
  r: -0xc27cdb359166e2n
}, {
  a: 0xc1a5dce33ca282b91e849d00123ebaa47cb48998c7ee4ef7n,
  b: -0xe77d9cfaff970n,
  r: -0xd6268c76cb73234fa0a48b8b3d8ff27d7f0n
}, {
  a: -0xa40ea71c8807ca55fc2f39527d941720cd746195ecf5n,
  b: -0xcf4f31637ff2f51b272c21ca4c4300748358e9d40b93n,
  r: 0n
}, {
  a: 0x5213c9f67f1d2c0fee336f2983d9c09a4566fa9ed6ef24eb2d53n,
  b: -0x81e437d760f80d9463en,
  r: -0xa1c3a19f9a233f1ee39c5c374a2322301n
}, {
  a: -0x6170fc4283de51bac0fd1a3d087e8ef6857dd446134ad42842a623905d61n,
  b: -0xa76b53d72cfcaad29467de8b0b9n,
  r: 0x94ff431940607c4fb06edfb74c72c66dan
}, {
  a: -0xf2847c41c884b62dc58f123c4be739a98db0ff91830e61c78938n,
  b: 0x460f9f705631an,
  r: -0x376260f176cd6612eb040de7ad5101e793c3db33n
}, {
  a: -0xd034bad1299d1a5e2f56898ab0e49daa13d45e146a60f630d2n,
  b: -0x6a6a44b0721c71312bdbc8n,
  r: 0x1f4e025b49e0f331007b3800a657bn
}, {
  a: 0x746bf0878a85aedcebb352a9ab87edd8f600c9cd0c3ade71d19cn,
  b: -0xc2df71bc19f1n,
  r: -0x98f0c1cb528ecb67f578d3b0dba7d107d418ef42n
}, {
  a: 0xe1108843c3ffe9e58af01dc69a297c3d9c7aba0b3fb3384764130113bdab7ff922e7b8n,
  b: 0xb16da8560ef1f48a0ac83314f9n,
  r: 0x144bb341ad9b625d9f6d6a440a9d9c9e0b6a351509687n
}, {
  a: -0x7eca0665f462790a207c3082291b9bd03d922a19c5025d54a3653e0b7ff3c3d3a07n,
  b: -0x32edb9549b4bcb2ea65bd6f0bc23255a106125e76823cc8n,
  r: 0x27d52f1c566d3ddb20f92n
}, {
  a: -0x10eef343c6d89d114b15722574eaff78c3c38640c27cacb8511bf02fa78d3n,
  b: -0x55dc59n,
  r: 0x327cf7ebbdef3a92ef477a142a9ab9cdb2e2bb601a5f2c75867d000n
}, {
  a: -0x2a3f6d58043750a32e4cc1ab2943bc5001ff17f3f8fff92445e00c5581an,
  b: -0x4cc7a5b607648a74a01f7ad4a2b4e09fabn,
  r: 0x8cdcdfe339e2cd1ff52a8ae05n
}, {
  a: -0x8620aa2dbafcc13131922af7f655565c745c3fefa265cba7790e5b0c2fn,
  b: -0x3bd50a639f09bd39920fa0057ae6220aa0ecc810n,
  r: 0x23de1ff5b9ba7fc6f2bn
}, {
  a: 0x970fab44801010900b3e01fca08242f543ecf710c937b9n,
  b: 0x98e1038f21db5dd090081354d3d9f8822c09n,
  r: 0xfcf4c46b0fn
}, {
  a: 0x77e68ead5bee10ef8cd2c35e0e43404514786a486af8e82f79f692n,
  b: 0x306158fdc8e3f0e79ee9527a1322n,
  r: 0x27a719b1dc10943c877bf45c7c9n
}, {
  a: -0x3f9a0932cf9fbfc053bf97b3a2a7d641c00ed76ce4f8e2b65n,
  b: -0xa58bc2d21aaedddf15c50f3400e0dn,
  r: 0x625a843136a5f62c0461n
}, {
  a: 0x3903f2e62faabc6f87059da382f82d6c8cd7f513147ce155d36933n,
  b: 0x4371272f9cn,
  r: 0xd86c17272a817c32d9b7a1fc783956dfb3dfdd07e79an
}, {
  a: -0x7450b8b70aa780631f3cc60ebec07f506771a3915d5743ae39f4f7c619en,
  b: -0x3bbd8f34d921000bf41f51af5ecn,
  r: 0x1f26f48998837ba8a1bcd0230a601e33en
}, {
  a: -0xb1c12862840c0dd3e80c10d0abd992e48f4af0762dc364b46d38ba143f860ac0f03a53n,
  b: 0x60cae9d7a01606490313ff3a3ec50n,
  r: -0x1d621619daa0d8c13d34fc5141fc92456bce037551n
}, {
  a: -0x462b48fbcc046f4df4e11745d52f163c74f015312648fdf796a273a5b335en,
  b: 0xb6270338ea5262e6b20d41n,
  r: -0x629de63dd04f889267c61f1983bfa89cb768437n
}, {
  a: 0xb75e38383dd03ff1f63dff5a160c460dd50ffc5844b3037dd5e6086n,
  b: -0x46382n,
  r: -0x29c8266e0aed3d337e156beef744c709f99dccfc2a17a024228n
}, {
  a: 0x30d382afa6dc2610d6e505347cf9a1ea589264f299eadb2b0bca94f3f4n,
  b: -0xab57237bbe1667a474ae206908038566308627810n,
  r: -0x48f38af0d7540e9c4n
}, {
  a: 0x800697fadc4a246c99f70ee26ee9e18e008f1edf80045c8182b30585n,
  b: 0xa58889c62e7daen,
  r: 0xc5fe701a2ae532722d8e7680e378f3add150b735c4n
}, {
  a: -0x9a4652738d24760b25f4b98c3f26f7cac8231d0ded97e443c19fec764c46bfn,
  b: 0x7006dc7fc19971bc50137bcn,
  r: -0x1608b2382c46611026540f345ac97c311fc5c0f4n
}, {
  a: -0x39254cdbe4c4a4ab75a58da3b0a3534e47df1dc8c9dff0464c16d9e741bdf0fn,
  b: -0xdeb0efeb82b25ad51a6b9695c0ef2aa3ee02376n,
  r: 0x41b1771a669acaffe269bd1fn
}, {
  a: -0x1c116e2a1dab91dfe7b3de97ae4e9268dc1d2723bfd4dff277f2df9bf55ee0ff68be5n,
  b: 0x2ac128aa81001bdb574dc438141532929a593e24n,
  r: -0xa80ffc6ff6eea1c68d8d6f26558d5n
}, {
  a: -0x5db0d69336b79dbb78db44280015342bbd6041a712bdf673an,
  b: 0x73ed8n,
  r: -0xcee50d85f052b8bd66b79700e927d7486156b5e3ca61n
}, {
  a: 0xd44809a62aa519839d4e1882554df59bfcd9f83ebe9b769f1ee42dd12n,
  b: -0x632216aaccf99aa0678d2c46437ef6f3a13336d5n,
  r: -0x224313cf34ec8744ben
}, {
  a: -0x23cacf6fd8b2fcac99da395715f849f5e06d1aba25c07n,
  b: 0x6bb260f495a98c40ad73f5e9846a3ddd7126486ce33n,
  r: -0x55n
}, {
  a: 0x1dfcb7ec9a8ae87cc0655d31eb2d41cf0908dbff0544f3eb90ffb4ab459fn,
  b: 0x1f405ff88dd8f0d6c6191946b0fc00dab329b3dn,
  r: 0xf5a4bb1238c4d2171a3d7n
}, {
  a: 0x41ddb978d021e1b6531e388217315d2b2f6570f629d5a29145976b9eda3d396c223en,
  b: 0xa38ea43113fae40d7e420969ce8cf92679a76c6598f38013n,
  r: 0x6718000f2435d1a45795n
}, {
  a: 0xf2b56ba646f2d8ae1db885f82d3bdee38355a3989efa9a4fe40a18c8640fn,
  b: 0x80c47d7655ca1443c9c6f174481fd1e8f6fcf5f080fn,
  r: 0x1e28620f5037bda7c4n
}, {
  a: -0x6033a95f2bba2433c63fe36d3021e6ee48945ffadb1n,
  b: -0x78ac885fb5aa7f91d2c35611d28cb17a8cn,
  r: 0xcc1595a83n
}, {
  a: -0x244f2c7752d2382567860c2dfb53137fbfb89b6214bb7cdfebn,
  b: 0x16a7c26n,
  r: -0x19a49695e39e358d6c4015f8ce2d74991f4a0ec1b9c7n
}, {
  a: -0x71982a5c914c3468d326f582428bb0416652e01821c5b512292b5cfa4e8753157838n,
  b: -0x385d9b928c7e68b1b1a061d3d767274efa71b96def37n,
  r: 0x203eb8147a28260e1ebef789fn
}, {
  a: -0xb76561c9b436213b640b96f3caeaaf9395f2473b5eb80bacc2aa1en,
  b: 0x509e4c817a7d001707d937d3997n,
  r: -0x2465dac95dba3912e4f70cc15986n
}, {
  a: -0x652acdbeff57fcc68f85a1c3a6f5b0282180533aaen,
  b: -0x5d70eb8e39ca73dd0272ce06080cd936db7n,
  r: 0x1152acban
}, {
  a: 0xc2cf2385de70d30a6e0f4f0c4e97aff280869f491c4cd5d67d2b942a222248e07a7c7n,
  b: 0xa63c2175ec7c9b1db0f756n,
  r: 0x12c01095b866f705aed57799d013003a831e61d92873e1ccn
}, {
  a: 0x191be7fe1e69ff6e1aa341fa20ad2011ba890e5ef8d6756e773235bb3cn,
  b: 0xdc5fn,
  r: 0x1d2b2660707006d0f5a30789b18bea10238b7ae4800cbb013e86fdn
}, {
  a: -0x8e010b594188dcf8e88ee763294aded7d164e3bc4bae424953a62df3n,
  b: 0xb36eba4392b80c118dbc38n,
  r: -0xca999ea5e459474764c2bb048814a8d490n
}, {
  a: -0x8a71b1621f0f11760b23d7484dcda400c6260ac5c7275b26b179dn,
  b: 0x1eebb76d94918b026f2cdn,
  r: -0x47a35c231755a38254ba1437039437b5an
}, {
  a: -0x9dbf64b56951969a88c2671136f6e2f0cc556b30435b92d5f9aa08d9a57fa2645en,
  b: -0xd1084a29f85b7b8c1a7628058fa18050f4n,
  r: 0xc13129e551c0c2a9540f6fc895f9297fn
}, {
  a: 0x444653be74c68c1dff55bcf9d0c1e6710f4909f9a207ed9f34f854c6ccfb648227f5n,
  b: -0xb66ce10386a41e0e8335150n,
  r: -0x5fcf95099663a82536b7019a643eb364f94336b7b2258n
}, {
  a: -0xec585ce681fef6fd6436ca8f548affba2805fcb92d1eaa145ec8ba553a9n,
  b: 0xfbb81bc6f6e13641aa18c3f3een,
  r: -0xf05d525a6d7948a65876d2652a488bb39n
}, {
  a: -0x394bd2b4c0193ab3b04e039340aa1ec55595d91a049d9082211672e920d036324dn,
  b: -0xd8ad9d26355738f6n,
  r: 0x43b1ad21fe2f7a8af246f3ba17d00e0d0eec8c74149cac6b65n
}, {
  a: -0x4defa1830c546391d34b35ce5904284de25b1f9c406f25b7b5a12304ff2dbn,
  b: -0x3a424d1456ba1ddff452f85e45400d204d4c606fe6c2ca91cn,
  r: 0x15676e46660can
}, {
  a: 0xbbc3e6e0c879a33b92520c2cba9a3b4e774ab115db3d3c4cfa3e4n,
  b: -0x48e73cd7fd18d569d22de338166758e86d62dn,
  r: -0x293568af4b7461a51n
}, {
  a: 0x2df6610b66fa54d226e69853bfbe04c6b95559186dcd526n,
  b: 0xb8cb88n,
  r: 0x3fac2edce57386021be08375320c9edbe4f79a981n
}, {
  a: 0x7791540f74ac2c93bb4a9d4acec93b9f8fef8e44acb2f5f344f978575c9d3e4n,
  b: -0x848eaf851861fn,
  r: -0xe6e9f070b4de48928f2f109fcc4b9619643ea7de1fe5ea315en
}, {
  a: -0xf0ef9531522d9c82a44d54cc894fa7b1d6938fac353ed1n,
  b: -0x3a5c1072bb3fdf2ed1bd7b0n,
  r: 0x420e34dae7d17f41106be2bcn
}, {
  a: -0x1d9799bfef825949bd509cdd1ea10b8b88f7feb4efcn,
  b: -0xe2e53ffebfbb63dc3a54719471b7e729fa812619389822n,
  r: 0n
}, {
  a: -0x9df8295801cca2fa8491894f139a9e478f8e288fden,
  b: 0x4e0b63d0e8103fbc5d0f56fcn,
  r: -0x2062b04c9406d37349an
}, {
  a: 0x23e2424f8a92b54059523ab6cda8712e3ffea045f7a256d43507n,
  b: -0xe4ae53b7ab9c651dcbfffn,
  r: -0x282bae9418e0dc80a3e0b9ad734bc35n
}, {
  a: -0x47b16ed58d68792ea141c25b8cd8da55016f7e3d12d43ac38c7124n,
  b: 0xf662acn,
  r: -0x4a7da0fb56689d385ba11c38b755eb75bd91802e0b8832ddn
}, {
  a: 0x9ceb92d7570d7f6e987846c36f92d83c8048758a69n,
  b: -0x84425244b74e9c11n,
  r: -0x12fbbe6616a2ce0b95dbc06dd68n
}, {
  a: -0x6842dcf0fb68fdeba23161dca840378b144ef7c23755e30065b21800a9a2147n,
  b: 0xe136105db75bbce163edabbea68bc2889n,
  r: -0x7683cb2aabbeb3b2232030042a3d9dn
}, {
  a: 0x817d99c58e443ebd55f3c6fd541924d65f0ad3abd868d91fad769c32c282f209966cn,
  b: 0xfce8b5fn,
  r: 0x8312be9c1eecd73cc7c6118940a2a097a02075bb01493c78c6b3410cfda88n
}, {
  a: -0xa423f252e018f107d4f984a65222493f7763030c06cb1a4e154bc67fdd42503n,
  b: 0x4e95bde056a1329n,
  r: -0x216b51b4dc90a1a33be665f54787ac5adb4e3b5851ec3f598n
}, {
  a: 0x4228ae72755bd73961ee0231825dbb6334a0625d28706abaa8f18df19bn,
  b: 0xc2a90cc9a06fen,
  r: 0x57019e64ac7004616e19aac1178d3d076c5c8efe39ea7n
}, {
  a: -0x60a22c07ecb3b5c50a4655d7847105d4736369c909d6c1051n,
  b: 0xfafc1e347bfda1n,
  r: -0x62907d1a40a049ebc4e8ec909a948cb7abfn
}, {
  a: -0x6bede7db8ee663731f3436613f595bc59cef2c418c53ebd45e19cba012n,
  b: -0xdad85dba748ca0d59b1ef654ac50b5n,
  r: 0x7e40d221c4b10aaebf4804e34556n
}, {
  a: 0xd294aa5d5e1ece508065a60a62cdb83ffcb0797ba07ff7587a85e85n,
  b: -0xf0c340604fb63d8f7d75592d2e2ecn,
  r: -0xdfe86ab0ced21160f42f20b74dn
}, {
  a: 0x723fa61cd3caa9ea3be02517c7f88af365bb4f54a3e4234b799bn,
  b: -0x9n,
  r: -0xcb1bd1fa5c12f52ea3559746b8d64c5b5f85e25d9523ccf7f4an
}, {
  a: -0xf5e115c481b592c104cb14eb527545ea8e1f7df536ef1b89dn,
  b: 0xaed9cd55a951c0ad73n,
  r: -0x167fe3e8af1c652b77a5df3c69661d56n
}, {
  a: 0xf7ade36ea67fe6d231f6ba7d665bd84ae69158d26b6f38c51e440008a7n,
  b: -0x5n,
  r: -0x31892d7c87b32e2a09fe254c47abf80efae9de907be30b5a9fa73334een
}, {
  a: 0x9999d85c15400b14b2cc9555f4b6b3c02fb4ea36c29fa504ba79d66bd62ab03207927bn,
  b: 0x5900fbd68d7648e9ad599a3f5f532e9c77e0e42n,
  r: 0x1b9cca617795fe2b21002f9384abbb96n
}, {
  a: -0x892e1c434f302d1e92ab861988a76d85a0059c9d8f2e6db4305n,
  b: 0x49de67eaccf6998bcf446c46d6035d330278bd81n,
  r: -0x1db6981034aen
}, {
  a: -0xcce16695a1b1cba24d9285223b97b276e5e276b25f17fcd6946n,
  b: 0x46aef4af578fecc9b5dd226b778b54d811049a4aaa15n,
  r: -0x2e608569n
}, {
  a: -0x47f589d75d35361ceac048149e79a2e1c7e464b34cf4c8f722354n,
  b: -0xa52aeb9dee9d0935af2a192e1c0bab9433d1ddbcen,
  r: 0x6f8848a863d5n
}, {
  a: 0x7642a43508971622a67f368eb5da577fceddf91b63419n,
  b: 0x83141f185c2e9bf92b9n,
  r: 0xe6f72e976b0bfe5bec0581c567n
}, {
  a: 0x44599065b04adb55eb34a1a625d72dd7a0b4c114fbe159b9d0c76a9294794a532n,
  b: -0xbn,
  r: -0x636b0093e927107cf906bc949421b70b184cbbc16e5f0e258cc4f81b0681e078n
}, {
  a: -0x1fd51de2b215f1ba3bce5f87aa3d076c38a6a49a8e03cfee31335383bbb2n,
  b: 0xe522c101fec14a925362n,
  r: -0x2390883f012b0a7c251aa55918c6245eb7fc12c7n
}, {
  a: -0x264abdb7588c6eaa3b354161f51cce4d54be5212c40e2bn,
  b: -0xf3a814e26d7481cefc7939e3n,
  r: 0x283b56e7de4bff68315b93n
}, {
  a: 0xb75e2a29af4faff8691dc37bf183d4a73600985b278d61a624c0458de20839n,
  b: 0xc58736e85487bff0b199850add7c955034n,
  r: 0xeda5df26223a5f8f561d2fa9a699n
}, {
  a: 0xfe8ad72032c032ca1465928bcd0178c1fc1b254dcf8650n,
  b: -0x759116bd5a314d2ac77592can,
  r: -0x22a4331f56a4549cbea7d41n
}, {
  a: 0x3d9a735cfad55b6cd47fa3fe1408ec92a63d36f7c7644321799n,
  b: -0x9efc65d1a57e092b645c302n,
  r: -0x6331aa298ec6b88376def4020ae6n
}, {
  a: -0xce8974c73e5e9b3e8f15afa31e5e713132eb8e29a41ade6cc2d35fc48c7fn,
  b: 0x8c38n,
  r: -0x179140f5790d9746fb46328218933fc03c94f93aaad4ae67950fbb825n
}, {
  a: -0x3f152936acf77c3c7cc1e9f6809b3aaf4e4bcaa7ab88e5d535d947dc69280b4f41n,
  b: 0xa9e42b9d2142f6041n,
  r: -0x5f0e4c2c105f8da4a06f66a4399c73bd8e43f77becf88a5d8n
}, {
  a: 0x585646ec40ba8caea66a0cce6af188dc9cbf07482da0d2229fbaa64e89e2n,
  b: -0x14a761f0dce6n,
  r: -0x446eb3a961d49e5e127deabaeae84bd3e97a7a4f3f6626c95n
}, {
  a: 0xa9c6f5138fd89e26999733dad629d8935ce1785574d832an,
  b: -0x5b8fe4a36e5n,
  r: -0x1daaed44f640124ab80591a9cce779cd8cb24n
}, {
  a: -0x49d5b811446f1ae80d550550c201a0dc71465391008124587b45n,
  b: 0x5b7fb42e6n,
  r: -0xce942aaa32630d6226154a0c6464c5b923959a7cc43n
}, {
  a: -0xdc44dd4d3a28692593c727187053cb1b08992da9c20b351d86ad9n,
  b: 0x9ce73cd13n,
  r: -0x16762db7036c68f658f04eb382d6a2889c929a098a74fn
}, {
  a: 0x5589e72ee772ad1c603e3a24d9b1e1af4a5c3261dfd55f19c31c2e5b98n,
  b: -0x105902844e4cd91a9an,
  r: -0x53b8299c24a813cf05c95f09f6e84b1a66cc7546dn
}, {
  a: -0x770545fae945e6f1bc2853ccf8b405859bc42eb053f4c63n,
  b: -0x1718eac4ac5ffe5754243d73cadn,
  r: 0x5272b2355cf9f449dea52n
}, {
  a: -0xdf7a803e30c080123073609a982b8162d964c7fc6ac7an,
  b: -0x6c56d4be25c8f1ef114146d8cn,
  r: 0x21011839aa7fe4bcfc533n
}, {
  a: 0xdf8e71c241ff295fcac713507c62659ea3238733bae0dd76e7e9e69d24dfe363451n,
  b: -0xccbn,
  r: -0x117995fc44a195f4923c1df68061bdaf115d37abdec4e4fd7dc3f592cf86acb40n
}, {
  a: -0xcfddf50125031afba559671490b8a88eb9ee9edc0104f7544cn,
  b: 0xee3e99cn,
  r: -0xdf5bcae4b5431000ccafb4453fed44c97bc69976a76n
}, {
  a: -0x6d7ef4b0c11e1ea9dca2eae71b15bf17a9fadf58c9c9f42965b3n,
  b: -0x5n,
  r: 0x15e630f0269f9fbb9286fbc7d2378c9e55322cab5b8eca6eadf0n
}, {
  a: -0xaac0164c2cd64895ebaf30ec490b3cf4c0b119db6ac503631n,
  b: 0x673394d14f0f3a438a8cdn,
  r: -0x1a78f84ed24b51af7a86c39ab5b4fn
}, {
  a: -0xdea9350d7618067bfc8a057bbf5b00b0fa7efb8185d0e5n,
  b: 0x25aafc35bf32b86c5552d14e200bf90c60bb690de8fan,
  r: -0x5e9n
}, {
  a: -0xe16dd670c748285dde4e50c1f280b50fb0874b5b9ab856c96c7c6n,
  b: 0x32ebfbcdd71f7761067846ee43f52a081eccd1a360efe673en,
  r: -0x46d4dn
}, {
  a: 0xd3738e3bcbb8c290fe21ba9be06c951b408eacfa66e8n,
  b: -0xb454e7a73e58ede11c4fbaaan,
  r: -0x12c2d82607e09ef9dbbdbn
}, {
  a: -0xf6f859beb816b6b16ef9d816f2d9dbf46445feacb7b73339efcdb70216a28an,
  b: 0x1n,
  r: -0xf6f859beb816b6b16ef9d816f2d9dbf46445feacb7b73339efcdb70216a28an
}, {
  a: -0x40c72f15cdbda449ea8164c21cd64358aa697b2be48e9d28f39dfdfa012e476beda43n,
  b: -0xb11a977d05c97bn,
  r: 0x5da2a68e0f3ce5ae54f0a41e6a613c9f4b79ce9ec6bd0d6866a6ef1n
}, {
  a: 0x5bc0e344a0eeefdec4d732988faaa0d116e42056af60bn,
  b: -0xbdd0c299fn,
  r: -0x7bbef3e155325c36e009d417a0f5202057ddn
}, {
  a: -0xddb6de62acff37535805138d8f918e1b5e1bc0d4258f005fn,
  b: 0xe9bf062a999c5f3fn,
  r: -0xf2d2992c017320e942fe5d1b06550e73n
}, {
  a: 0xbce2f0969df0e590a232002ba24a173584852085d8a18470fa0a263bcbc8d7bb98be5n,
  b: 0xb02n,
  r: 0x1128c8a3650388973911713533a0421020634dfdfcc9730ca0125d3a4dbe4e1a206n
}, {
  a: 0x9163c4c1351fa89e55466c25792ab6afb344f9b09fb17dn,
  b: 0x8n,
  r: 0x122c789826a3f513caa8cd84af2556d5f6689f3613f62fn
}, {
  a: -0x9b07e094ad07c148d07828fe1b473c9b72f2e5a10cd0cn,
  b: 0x62780349b064ba56053e72e6bce70bc9fb300edd233d7n,
  r: -0x1n
}, {
  a: 0x50cf8c33b7c1d659845843083c9260eb887b0256fb3a81ef1054fdn,
  b: -0x6fc8ef087a81d890154ee65627bc3490b36d81c7n,
  r: -0xb910d02eb37dfan
}, {
  a: 0x78e954b96181cc9a620b7bb7fd52721b7700f9f4d5ee18n,
  b: -0x864f91634ebc58c0024cdf02f9fb19n,
  r: -0xe675e06901035ad7n
}, {
  a: -0xb893cee307dc1da31fb810858fa3bd635394206b3923c62ae32472d2f96ban,
  b: 0xdea4f4b1a7f83f65530af639366af1a47401fcf5n,
  r: -0xd43ae0128d33b56f11f89n
}, {
  a: 0xd0c240e507e1a8ad8c398c6ae320000a9245675e39969f7d176700b4n,
  b: 0xe22614n,
  r: 0xec508abc331835580eb5c9f3358497fd56fc42f9daec4c3ea7n
}, {
  a: -0x828fb24335f7ca82703efd4003934c58c674b79548d6d03530cc451n,
  b: 0x1bda07fc59937d2d4a12308n,
  r: -0x4b00f659ab7ae53393c8bc27c2f84353cn
}, {
  a: -0xa2f5727467953b75f449cb5fa942854530cdb01c93b68ec2a40d99e04378c9784n,
  b: -0x80dc75818b90f79a526db4394b700f8n,
  r: 0x143bd4e57796e9d5d355d8d1fcb7cad1eb3n
}, {
  a: 0xd7d801a118e04a6834473fe534622ec5bdb44241508954n,
  b: 0xb45066854042dfae26ee23d6n,
  r: 0x13271710187d6e959fe9d94n
}, {
  a: 0x213a828fa46ad99fc2500b905662cb8c02453aba267fce0098efdn,
  b: -0xeaffb61a0d9dedd0ec817beaa6460n,
  r: -0x2432b5ef3e0509074cc28a34n
}, {
  a: -0xeebc53b55830fa6f21755f042f38c78e4a56a364d358n,
  b: 0x2d4n,
  r: -0x546a31664f45a657621b5b95fce56717708fc8a01dn
}, {
  a: 0x2cc8070f8cdcada7a04ff0e9eda578c8401d808f0cn,
  b: 0x1f91fc52e7c56a43e070945c790ea74dn,
  r: 0x16b20a261e1n
}, {
  a: -0x580995926bcc03836bf86d855a48606f0868bd9230n,
  b: 0x79b2ee23f4n,
  r: -0xb930f811c60affbd0fda51360f4ee38dn
}, {
  a: 0xd7a488e1437bd42c9be8499cd1cf11149fb934de768fc8f7ce10003e37f9c99c47n,
  b: -0x7b797f2d95b3858ecd00f5259fc3n,
  r: -0x1bf179d5cbd5e746797330f96365f9209d2ed01n
}, {
  a: -0x7355c429773c2c7a2d2b4772842eb5fc1354d8df0bb58a75b7n,
  b: 0x1b77f9n,
  r: -0x432e3ce67bff6c791c9d6c9ce9fb8cdfbf52d999a7690n
}, {
  a: 0x9c3382293f99e0b063787e7edb98b7cd29f712499711a99f10d8n,
  b: 0x11b5c1141e1bb65f3e940e19071078f39b061f845n,
  r: 0x8d1e893419dan
}, {
  a: 0xd1f182e93fa54a10c842ef8f14a1f745db8145acc7c8e31c523190fc42892b435n,
  b: 0xb4cbfc526a0ac0012c09cad839a51fed3268610a4024bn,
  r: 0x129452d972e59948a7197n
}, {
  a: 0xb9f3dee4926227d5b8990ca7bff7416b7475e2abcaa675459b705fb3c315d8n,
  b: 0x568b110a832615f682ab3eb00n,
  r: 0x2260f12241e507ff8eeb04f9e111ab28cd0b09n
}, {
  a: -0xbc49db0d3b34f27326535ff153a09e0f4efdf0465382n,
  b: -0xbbc93ac60498805en,
  r: 0x100af59976d3969cc20b0f8cfc5e4n
}, {
  a: 0x9df7eff32d8ec073aeedd073e3408ccffc595603acfbc3244c2cf974bdb3b2cccee2n,
  b: -0xe6349c45n,
  r: -0xafab39cebe897132bba85edbc2256eefa6eebc548892a400e819ae41d29cn
}, {
  a: 0x89d4fd63467678910bbebec424b93c0e81e47b31dfc769f6cb0b449d52n,
  b: 0x94a427bf1e9918n,
  r: 0xed62333d019e2c26e1fa9efdcfaaf57ffad885d52f59n
}, {
  a: -0x1495fbc1dd22e84a47a694771d7d831d3c1b2e1b50920an,
  b: 0x68d1c199cd593d79e1e2f67e68879ad0a8ee957e761n,
  r: -0x324n
}, {
  a: 0xd0a0db95ba2fadd7d5b85434f440e1f37419139564276a25c8963ee2405n,
  b: -0xbn,
  r: -0x12f759c7cb1b9b70b656934aa1d75a5bf348190d94bdc3d4e3b0915a62fn
}, {
  a: -0x298b567674fd4c333ad19c2ae771a81f6ce3d445ef044fd53819fn,
  b: 0x122d434c17655128e8ade15a395764cc1bdf7n,
  r: -0x2491ad46638ce9572n
}, {
  a: -0x90db4df555da5df3821641732f06e6a8f02d7fd00a1eb7140fb308c5fbe81934n,
  b: -0x66625n,
  r: 0x16a32b81b9ffc35ba0a3cbc3c991c7d417866c5e24f6d65580adb44df9d9n
}, {
  a: -0x1e1c4e63b949ac35e78b21e7b23e820e4fdd24756171c1fn,
  b: -0xdfd3ba7dce7b369230eb1n,
  r: 0x22704c9e7c6b798fb239dd66a4n
}, {
  a: -0x9e943f9a4289503ae5fca55915ef8fdb283c3bea14c8f74dbn,
  b: 0x16d7fd9c3n,
  r: -0x6f121472742f0cc803919a1dcd39946e637335914n
}, {
  a: -0xa1222c7c0186cc47a992838ea76f68a187a1d8b272dda85833623edn,
  b: 0x929966a9ed55e297134761d1e71df8c081b757f66n,
  r: -0x119616d703b06f1n
}, {
  a: 0xc8926b7e7bd9f0f2ccc2751f2ff9d38a1ac20478701aa22e08651n,
  b: -0x6b68f3941d02cd636bc63b814c5de1fd3b71726cen,
  r: -0x1de0a9eb446f3n
}, {
  a: -0xb24c2e740f18fc3b8547aca843e9ae9430d1f7ebf956e57ba5e8en,
  b: 0xc831cf65aea864ba2afc6ff7ebn,
  r: -0xe3ffc4d8548e96deca29b7492a0n
}, {
  a: -0x26864b6260eb9108b7f45455fe8685f6485d59929434730n,
  b: -0x9d46ab7c9fc4b7cc2a2d679c7f3ab310e49a42cedn,
  r: 0x3eb4f7n
}, {
  a: -0xf0b23ab1cce99d0ad872cd4a73850df029d9cb2a2ab06579d0b918an,
  b: 0xb33n,
  r: -0x157e02eb5b11e9c5248f797687dc052c648786d8756421b49f011n
}, {
  a: -0xa4f63b7ad6c649d9d5cbef539180245aeb42f889e763fa614n,
  b: 0xdbd570a020d25d9f7c5abc00be8d3f4c9f5879n,
  r: -0xc019cbfc1c1n
}, {
  a: 0x5f05faf990626341bd5b1ee532fe6dd5e328689c62963a5f03f4bn,
  b: -0x4f0e7d679891c89f5cd236acf1048fad15d58f470808bn,
  r: -0x133b40e3en
}, {
  a: 0x25b11133b96a5071513aaaf49bd15d9e1a22e67d6d56887653813b14c7b4aceec57aen,
  b: -0x782e35e20en,
  r: -0x5049c23d218488beaa49df3427e9317faa74086753c93811037473f505bn
}, {
  a: -0xfc87d3659885cd856de4dcd06888eafe7309ae1defa60fn,
  b: 0xa620f3ad90fe4d12b70c92n,
  r: -0x185249ad8ead90fe20fa6aae9n
}, {
  a: -0x49f30a538967ee6eba803c40ff6430a677d885548cb8ffbee7485b7b45bn,
  b: -0x25da1c1838a1354043b1b29fade26d15f71e5af8505an,
  r: 0x1f4221e5781a40f5n
}, {
  a: -0xde77c202566e67af841a39991c30be216f46b571d7805626a858deecan,
  b: 0x28b1aa4083e19b638d7571833813c7161874f8d354en,
  r: -0x5778323d1de97c8n
}, {
  a: 0xae49b00033b188c9fbd7baedd64d92c466816329b7n,
  b: 0x34f7ee60e96f826e792341e0fa8ad3n,
  r: 0x34a5816df4e00n
}, {
  a: -0x99258244f7729a772f549a9382cfa3a3d9004297d8f6446b7b42e8b69cn,
  b: -0x4ddb6ad93743dcb4c94fan,
  r: 0x1f78ea9bb99171bc4ac638137cc3ddebc2cbf0n
}, {
  a: -0x2d38995f7c4028400f8b033bd50e85ab0e272797d1918db0dd31ea90eaa195an,
  b: 0x9bbed6586cb379077063881n,
  r: -0x4a548b60efc3b10f266d681524a74c07b744cf4an
}, {
  a: -0x270503c95381c4a3d65f120bf1b32288de03783a6ce38b56f54da7b529132938792fn,
  b: -0xb2356dc7fef2617e163bf35d20efbae13ad1aa0408913n,
  r: 0x380d6613b3628ebe0fa7b15n
}, {
  a: 0xd818ae54ceb9c77cdc29ae755bfd505d76456d12253f9e60n,
  b: -0xd54a5c534930a57f032bad643b976b585n,
  r: -0x1035e285a0ca2e8fn
}, {
  a: -0x1ab67d1a87e3e51a20ec2cc60dd1e023aa86f768fcbb35d42281eaa3d7a883cbn,
  b: -0x2436674152d6a48fc61ae254dcf13334an,
  r: 0xbcd7df49e05a1a53203fe9d673e3718n
}, {
  a: 0xe9ca784b051701dc7a86ed646e83e48da6b6152f3551de16578448d34ff4d6n,
  b: 0xa598e32b51949c4177cfc886b5ba01en,
  r: 0x1696c0555325b0b055bf38d28f150972n
}, {
  a: -0x796ab1f20105a1ad6c594ac7b8750db21c2b705f71e24f3n,
  b: 0x525636236e9d30n,
  r: -0x17981c32e3fde3b4e02a3ef91eb6008ee3n
}, {
  a: -0x1985d9e3fff9e756355f42a9353669df638ab506a2344ff6dba9f9n,
  b: -0x87e23b7bd464b71da6c7e3b7an,
  r: 0x301589ddfe11ebbff3bd00ef9fc37n
}, {
  a: -0xd4d260e5c4985cec4fe0b30ba049c2f38f900cdea841n,
  b: 0xb04a70c7ae27707b8efbac26e1f8f5a7cd2b59e1ce12a8df0n,
  r: 0n
}, {
  a: -0xf88a95e6b9984f1fa97fed3575fff73b94c97462fb80645990c3n,
  b: -0x823b7a955b3a781n,
  r: 0x1e88fe5fe3c22d697e4c3aa35709c8591e4ef6n
}, {
  a: -0xf03155844a97104af843f0a4570d12f5129ecc32c440b43adba44141dcc00an,
  b: -0xb33f7fab23cc69db6a2282cn,
  r: 0x1570a5ccdebf3deef0aa4911085364e34fdf9188n
}, {
  a: -0x170d473e742ec9cf727931e09b74a493aac000894c69b56b82e4b1e7n,
  b: -0xc56850a4d49d18434cda83f32aa209af02685n,
  r: 0x1de4d63ca2a9cb74739n
}, {
  a: 0x9d551a1c5d86fa5c9e6d19ea39daad4ce18786e56b29d6427bc486cn,
  b: -0x42b4n,
  r: -0x25bd38935df9a360a2bbb8bd12229563efd0df4affdbfb06699bn
}, {
  a: 0x2d3e40755fe97019bc3e8b801e4ad1fdb2120b31e4n,
  b: 0x9c5325fabc56d2264c9a93ccn,
  r: 0x4a1748122ce52aa7b6n
}, {
  a: 0x2822a1b4d8928f1264f1a81c3242ea6129c4bb522e274d7a4db651c0be4efn,
  b: -0xf814b6bda0n,
  r: -0x296a9cb5cfdb98be3205b1c6aa3434255167f6e5bbea5c8b7f8n
}, {
  a: 0xe366d574c76a7dc75acdf1c750e1f5c869b39f5c4180628399c134c96aa4381e395c23n,
  b: -0xd7650156ec1364b04add1n,
  r: -0x10e454bd9ad8363be2aa9655ad1cd10b5963b07763a80ece2an
}, {
  a: 0x998cfe32d34bcf4a8f142466e8337c9636ef2a8dfe7de4d2ecdd4477b3b2e4028629n,
  b: -0x5e6dc99bb10c30879b5aadan,
  r: -0x1a04814e535cdf4a7d29cc03e83e8f138295132277af12n
}, {
  a: 0xeccbd69f22b92f4cdf0dde14027e141174deee0ad4ece5298a1e80c7c7aa1cn,
  b: -0x963cb89f70554c7e5201028c73ac0224a796865143e0075e9n,
  r: -0x1937e8513fc2b1n
}, {
  a: 0x5079663d3d1493525f6158a2b36a244cd9db84821d0282db90e0db4f96abd0b9an,
  b: -0x6fe980bd3d9d28e54b6c92a9a2ad8ec94b905f474503n,
  r: -0xb815e3baaee8366cbfd94n
}, {
  a: 0xe8a1d80a21b58d6b62a00554f5127f3fee924ae6c7d9b90d55n,
  b: -0x284444b22be01feb5f351fn,
  r: -0x5c6fc6728905648c2182ff4225c18n
}, {
  a: -0x734a52d9dd56990fbce18e84c8fe7866528d07784e3b03faeeb7e7a27fd02375ddeban,
  b: 0x41fd0cc5ce417fb081fn,
  r: -0x1bf43cafa14496c2f3156b7c4f9fe96f62ffe2bc904dbc9eb7dn
}, {
  a: -0x1d2121cc03672e68d5890f1ca36e816fedd8c7a52559912229ecd00c2cfn,
  b: -0xe65a24615fe2b259e2f98bfd30355f74ae7850f48n,
  r: 0x205f6caff066069d11n
}, {
  a: -0x26cadb74fae59079db544ffda1fc1b05bd27c8f1b80n,
  b: -0x48607f37245e409ccf5493f447d6cc4d77feecdf348a8315n,
  r: 0n
}, {
  a: 0xbeff721d4783f92f7beca332e550d212c95b27a7a4ae123ff546e2fen,
  b: 0xd69079791c06f44d31af03eb25n,
  r: 0xe3e1e6c671c0db149010baf98af7c9n
}, {
  a: 0xa42898323720df8ff1dc2bc47e84442481b3cb061397d80d523d0f1ef6cn,
  b: 0x22n,
  r: 0x4d40479f29006934ae0d41c5e12f2f203d09507b5483b0f735c26177fbn
}, {
  a: 0xfb415dbb653c9761d324455200c8915fead754c10a8ce36ed8fn,
  b: 0xf72ca450aaa9e6234bn,
  r: 0x1043a06f9ce79f0ab5700b22994384b897n
}, {
  a: 0x7e89c615700fddd96123e0bd2b456aea911a98766bn,
  b: -0x49556c3f1e53907837c1487794d6267f5en,
  r: -0x1b9bb2e20n
}, {
  a: -0x34fea7bce0d66cca51728f8584c4d30a09a9b7b2e3e14n,
  b: 0xe16cf2604ce252ad80c63f73b96b558aa5n,
  r: -0x3c2eb2b24c5n
}, {
  a: -0xb8e1966a1ab9a0b9ce61dc366a477bdcdf5636c9a246abc2cn,
  b: 0x836fbbf6ec68ba6da0a6313ea57619edeen,
  r: -0x16818455dbea08a4n
}, {
  a: 0x11ca5c6dd988d56e2e10527ce245079343d2d0eec6b95e2cfa7b8n,
  b: -0x49953bb8499c1f0dc90605dab03fde405352a10fa05en,
  r: -0x3de4ed942n
}, {
  a: -0xe24e9cf43555f74ee8f87dec9313b95d30d7b7b697c54210bd7c1bd82142187fan,
  b: 0x302763ce3636n,
  r: -0x4b31d4d001baed7c4b55d0a4b158bf2a40ac70d6b465553df84a60n
}, {
  a: 0x2410c1c21b457945c50f7cb61903fc14c6a56b93420c3ff01de062236bee592bn,
  b: 0xcd81ea8ae1b970e1d0ab01c66d283an,
  r: 0x2ced370676ebf300da771952399bea6468n
}, {
  a: -0xeb2c4ca4ca20ca9d8096445398d182eee9001ee1678dc0c3ba7a994435c2en,
  b: 0x1a741f77a85b07e57e9n,
  r: -0x8e3d843f69cecb1b3b63bc3dbfc43be1ffc8b7ccf1dn
}, {
  a: 0x4a406ad4b0e7720f2648e2e7de336f162377673fc16149f4eaae2829bc35dn,
  b: -0xd7af160448e154cf4ad76d75a4fd988f97an,
  r: -0x58218232685b612083096be1e1n
}, {
  a: 0x923eab38cede594fe799ef61d8be70a5261e65302677a6a8bb76c80304cn,
  b: 0xa190232d76d878defc2c111af2c48cc3283c855d8b0c6n,
  r: 0xe7ba59eddc21f3n
}, {
  a: 0x56af60e944afb3bded86776ea7f3815a521a6f426382eaf568c8232f5e5a4324n,
  b: 0x5819ade4d1866014n,
  r: 0xfbe33bfc3d0630de43711d77b29a83066b88f54cc2a54c06n
}, {
  a: -0xa24a183065268bdcf8900dffb501690099926ea2eae25748346d99c9n,
  b: 0xc4057282a30cf415be77280c2cf568dbb7a7bn,
  r: -0xd3f2656b83a92f6d30bn
}, {
  a: 0x3dc3d394a987c0fb530453e5f99f12f34a765f61876e285734db810a5de0319662an,
  b: -0x596fad6ebc594f678537b3f9b7177ca0n,
  r: -0xb0cb5ddac8b993d7c530f433870530fefd4n
}, {
  a: 0xf5a87a333b4345f9484bcb8a3696969888fbfec6906e95434b042eb863865e4e6e1n,
  b: -0x84d591ea41b67d069fe6257719305ba1f5e6c283c8c72a3dn,
  r: -0x1d96f88d35fd725461c0n
}, {
  a: 0x3c5b9e1ea1e1a96a57d7d07487347a90bae42cf2a4b86174abn,
  b: -0xc4cb3093d8c348n,
  r: -0x4e844ec3f1ff0bb3e9b75ef71af0350a225fn
}, {
  a: 0x749b682acfd5a54f418b95c6d9199ee5bade30c062aefc1a0139e5e070bfb10n,
  b: 0xfcffc05n,
  r: 0x75fd7dff4e08319dc4b19a7527adad3c7547002e069e4a3e3d095dc9n
}, {
  a: 0xf0828320e35f7e9b9de97a8a28a67a7a1f8d6cbdd69269954e74ce29a6ad13fbcdbn,
  b: -0x8f872c5fb28b63de0ca1fff574b10a9ec49228ebdc4034n,
  r: -0x1acfaa231fa879e0777ca0n
}, {
  a: 0x36bafa2e07345b2b1f32a5c98ae576aefa035256237b95210f7594n,
  b: -0x7c9e1d7a9968fbe6ad7610a7a50f70cc8503eca2a7594dcn,
  r: -0x706e863n
}, {
  a: -0x7a24fb06106f7f8ce5a1a4835bf2235c57800bf8c5aea5334n,
  b: 0x4571b58f9e448n,
  r: -0x1c2466a195ea910b2570613128af4e174ef2en
}, {
  a: 0x5aec7ddffabb5b7bbacfefd241b1cd4fa932c79563529n,
  b: 0x30f810d908dcdb0a9fa52583adc300a8997b772e2n,
  r: 0x1db54n
}, {
  a: -0x35e796e5fa3ba0c6c5386123076c8309bc284691cfc311a6580760b67n,
  b: -0x6ce10c361075fdf6c8dd9f7n,
  r: 0x7ebe0913bbcce290b77a1142c0a0b724d0n
}, {
  a: -0xf98f5ef0bb4247ce4974122c15f90089a3a5b3ae315bf9cac6508259727ccc3n,
  b: 0x15f06263d07c541e50bd2ee49bc93c5286b48299d97235n,
  r: -0xb600ba855ea19833c4n
}, {
  a: -0xd20722b23354a74e1036f79274b67acea520df64854c6f0d0an,
  b: 0x79n,
  r: -0x1bc5b430f3bf075023fece3972df016dd65d34cfefc6678b3n
}, {
  a: -0xc70ff5995a69c2e8469ffdea6f2e7ba357e9e40a32486ee2b4043b511an,
  b: -0x4b1b539dcca0ef5c0caba562a5d37ebe11n,
  r: 0x2a6801ce9f0781c5143721a4bn
}, {
  a: -0xbde8b99ad672ef67eab0f98d1269cc0d48dfda84e60c378b00e71ead1n,
  b: -0xb0ea46f2f825a4e38b31796951b8fd0c3b28dcee1717b74e1n,
  r: 0x112cd70f5n
}, {
  a: -0x71d8bab7f08050566a8f1c2793779cde22340b73556ec3b8n,
  b: -0xbda70925fede22f2556b2b807172cn,
  r: 0x99aca4b65516f507363n
}, {
  a: -0xb8ec90a758f42b36e60ab67f56850b4da07cc61b8bb281b7f6e84d9a49eed86da8375cn,
  b: -0x48037ded6d4f6bc918658508f6an,
  r: 0x29162207a2ea7b6f9a97d025e92f0711ebe48666970cn
}, {
  a: -0x4c50dee79322301c60830012313efbffe53a297063079b6b5efb62a0a36adba1fden,
  b: -0x73fbbdc586b3ba8c66270cbd2941a2bb4eeb09d97112d7n,
  r: 0xa87209690ab433d48dd0an
}, {
  a: 0xc86893df495f939476d376cd1c129bf7f54bf38add51d808a8498a2485df4dn,
  b: -0x8b3d29e5n,
  r: -0x17076df4e27e05466af475f86acd2b59d2cb3e08d0191883bd3da73n
}, {
  a: 0xaf8bc65bdfea48a64187df50bb3d52e846803a0e05fb1f5ea88n,
  b: 0xdde35ba7a79614db29070debd7322d82653dd3a53424en,
  r: 0xca8892n
}, {
  a: 0xedd7128cea44b2741c01b45297818a37a58d41561df576e9bc70b9n,
  b: -0x888f874873c35d294a71821e1d89a9302bdf14n,
  r: -0x1bddc6af07c1abe93n
}, {
  a: -0x4d1a3da6a37ab860be3f3e55139b256817cc16657f971n,
  b: -0x2f68421en,
  r: 0x1a05ad59c0ce5f192093964e5e7521dc7fbedfn
}, {
  a: -0x23b825c74bc000e62a0a068115daf860aa569520b679c653ba245fdd34n,
  b: 0x8b93033aa4b7045a5c7adn,
  r: -0x4183ba964a28cf9fe5adc6194cda531db0a2an
}, {
  a: 0x7da4a77096cd07390bce9670bd92bd4775865161cf7b634d45700374b8an,
  b: -0x65fbe44c4194d7d773ebd2dd69n,
  r: -0x13b63ad7e2187ee5fe548e6511110e4e76n
}, {
  a: -0xc078a7d9de9f012529cad2ba9c5919aa7eef122721n,
  b: -0x2a697b35e3c53c5680e72627c134c78d7ca72ed12ef266n,
  r: 0n
}, {
  a: -0x524414fdd3531d9b1f89b8a6cc9ea6ccf10f2b24b0344629346ca8141071475f0c34n,
  b: 0x38103700fe50732927fd18e61476e409154b051c950b6e38cn,
  r: -0x177a5e42b4683801ead1n
}, {
  a: -0x5daefcc5196ec860538de07092694e162995f536f87113e0910709d72cefefd7777n,
  b: -0xae62n,
  r: 0x8987dade9f34b9a99120d69c90e25773c412fa0aab3159b9b36784b9eb0ea52n
}, {
  a: 0x7f937a7624b577acb4eb7c33de6661921b7a437e991n,
  b: 0x72935d05f57f5c78c1e80b0492c9a77an,
  r: 0x11d0c1d07b87n
}, {
  a: -0xa0433810b21669b2c3b92615b55c16b6c71af70a332e57f6ecfc7n,
  b: 0x303acf91dca01016bc1bfbf9c94f548f0n,
  r: -0x352a994db89aed5865604n
}, {
  a: -0x425d8372dd502245e9e6beccf5b9bd1025493949ef1094b5c74f350619dc4n,
  b: -0x35fd00be578d08048668c7e11f34b939d5e16bcfbf88cn,
  r: 0x13ab0582f0673fef4n
}, {
  a: -0x60d5c37e3edbfb808202746c7958e948deed6f05b88f8bb1499178n,
  b: -0xd9db00c2a471d591a3c90616b5929f6c5af84bn,
  r: 0x71ca39fdc7dc80d5n
}, {
  a: -0x8daceed42b449397990552fabae7a2d657f83b1af39d560cn,
  b: -0xba8fe130e4561a8324634cd58ecfe7n,
  r: 0xc268260b5b9bb9bef1n
}, {
  a: -0x1666c78fcc8c0ea4da73886aa9c572f6bf59f273281343332341dn,
  b: 0x291319f67dn,
  r: -0x8b9e5b7759fceb9b955364809e5ca84c5cf12b30b5cn
}, {
  a: 0xb9b8b657ed1be4884aa83ea4695098a709e6d05c367b18en,
  b: -0x2449baad19125051f14en,
  r: -0x51e34638b1f3e7c8daad9d2d026bn
}, {
  a: 0xcb254e72bbc79f73ca4e3f05a510fd93376c3f36c69bfn,
  b: -0x72ded5cc9d6n,
  r: -0x1c4bae5ab21c4957f1912dc5752f46b5ae0n
}, {
  a: 0xe2b6e8914b9c9e056abee0cddf689ed4c7d8780aa37580942bb775b3bn,
  b: -0xd97cf3c544b686dbe14f128f0d0n,
  r: -0x10adc33aa9a5ed4d7e2050fa72cf7b5n
}, {
  a: 0x8f1eca3abb1b0f50bbf76a2c860c4598daaa768f94bd40e19912fc9ce717c5f0363n,
  b: 0xe858c771c7d0a7626b0d4adb14a4ca1b2d7501137c6n,
  r: 0x9db0aaa522e615f7363e7848n
}, {
  a: 0xb8372890109512d1e3160a12558e08cbeb1a1c87ab0b2682d812ce566f37n,
  b: -0x88de4db9f7n,
  r: -0x1588ef8683078edf03a6c395c4e7383b8d4c294f65bad79de2en
}, {
  a: -0x3445a458bd07fdef34423befd316edbac472fa22170f2c08e6e88ea30ef6cb8n,
  b: 0x7c7c5f77269c383c1d7a41196n,
  r: -0x6b7ecc101fac298bdc80a14b1a9b518119b697n
}, {
  a: 0xf3d48085983bd69f09444725abd132853c0f0355d0794b5e6ffn,
  b: 0xebcdc4b08594fb6915be4df39b1e8c8a7630b8ea070bben,
  r: 0x108b6bn
}, {
  a: 0x67839f08fe7f55c1e1220f5d4bbc986d535b46579dn,
  b: -0x933n,
  r: -0xb40a3632362169590978a87964f6b569081eea4n
}, {
  a: -0x9a936374da118fc91ad52103c22b278a0b807cb08fd94f0575n,
  b: 0xbd84754e2457ea95c97282c89a5ca352213661865can,
  r: -0xd0cd017n
}, {
  a: 0x398b97a2b92c917ffe3a7b090da33390c7709650d31n,
  b: 0xd9bff348a0fdc90a7f26e86dn,
  r: 0x43a75c942aa0ee30abdn
}, {
  a: 0x1339878aa532ca0ed7e48ca6852d0e64eabeb1c8e41981n,
  b: 0xd0381a4375619dc77fen,
  r: 0x17a2e449c43171b502299c11f73n
}, {
  a: -0x6df94d4182b6ae7138967e9876adb3f46209d3e46bc4e6n,
  b: 0xc07ba55f803683d93380e8dffd0ed73d3fa2297f54001e92n,
  r: 0n
}, {
  a: 0xdda0621f19f631821cd8f67786777300e9584d9b10ebeb5ae22e5acd481b085f5f5eaan,
  b: 0x15ecc145e7cf905c77439c25142af70efed7119792n,
  r: 0xa1bc4e6805020295bd2e0597b30cdn
}, {
  a: -0x8e8c14f0bb22eae2db8b732a0d1e02ca60555c3e70n,
  b: 0xfd43234d9e94fcf12n,
  r: -0x90168ed7188f03e1498858197n
}, {
  a: -0xc9c96082f576dc05a37607180032414d411350c05bb924a093bda5c7en,
  b: -0x2505n,
  r: 0x57368a25f650621eb13dae9fc0fba73453570951ec293ab320c334n
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var r = d.a / d.b;
  if (d.r !== r) {
    print("Input A:  " + d.a.toString(16));
    print("Input B:  " + d.b.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    print("Op: /");
    error_count++;
  }
}
if (error_count !== 0)
  throw new Error("Finished with " + error_count + " errors.")

