// Copyright 2017, the V8 project authors. All rights reserved.
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//     * Neither the name of Google Inc. nor the names of its
//       contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Generated by tools/bigint-tester.py.

var data = [{
  a: 0x9a7n,
  b: -0x930835f77962eb16d6d55fe2f837f19873bb10d02960fn,
  r: 0x930835f77962eb16d6d55fe2f837f19873bb10d029fb6n
}, {
  a: -0xfb041518ecb918497f344d2af59ee0c2cca02dn,
  b: 0x94020c55e9abbd73842246770226ba103fee5a1c08d8dn,
  r: -0x94020c6599ed0f024fb3cb0ef56b8cbf99dc6648d2dban
}, {
  a: -0x51d2c0a0d3c58176086bcb0ece1n,
  b: 0x89n,
  r: -0x51d2c0a0d3c58176086bcb0ed6an
}, {
  a: 0x63149ec473n,
  b: -0xac2f7b06a9390e57c9fb2e1a4c7eae49dd51cc734cf6eff7928fn,
  r: 0xac2f7b06a9390e57c9fb2e1a4c7eae49dd51cc734d5a04965702n
}, {
  a: -0x9b9e907c9914864fa09b40c1fe4a480n,
  b: -0xe1a9dfd2bba5135966b23745685a60b86fa51fbcn,
  r: 0xe1a9dfd2b1eb2a519d20eee06e50acac4fc07b3cn
}, {
  a: 0x9ae3b063cb92264f1426123a42476162442a2143fb3241707d6f3e8e14n,
  b: 0x8dbcc3327910n,
  r: 0x9ae3b063cb92264f1426123a42476162442a2143fb3240e2c0ac0c1504n
}, {
  a: 0x8d69b6312d93107fec7n,
  b: 0xc7f733139d8172a27d33339e0601dcn,
  r: -0xc7f733139d789c071a205a6cfe0315n
}, {
  a: -0x9a88d30505b927db2840c79b070f6fe0c97d2f6ab8fb9d702642d8c464bn,
  b: -0x4f516d12bn,
  r: -0x9a88d30505b927db2840c79b070f6fe0c97d2f6ab8fb9d7025f38757520n
}, {
  a: -0x6c5a80cd8bc61e72ad439f73bbc32cca8da79a2c79d6932ce7d9fe7b0ead3f4n,
  b: -0xa7c0c39cd0b85699c68fe2cf033364cb6e0f9n,
  r: -0x6c5a80cd8bc61e72ad439f73bb1b6c06f0d6e1d5e010034a18d6cb16433f2fbn
}, {
  a: -0xeec006b9e2af4n,
  b: -0x6dbd68595079cfbdb4a5c08n,
  r: 0x6dbd68594f8b0fb6fac3114n
}, {
  a: 0x3d7dcdea4d9d53867n,
  b: -0xf9b86b88d27a67ec6028a800acaa4f0693a12e6f6d027a64n,
  r: 0xf9b86b88d27a67ec6028a800acaa4f0a6b7e0d1446d7b2cbn
}, {
  a: -0x1c4a9b84c2c3c5e03e81n,
  b: -0xc008855a31ff1dc8950e0f3b4d1dfa006170f564adfcdbafn,
  r: 0xc008855a31ff1dc8950e0f3b4d1dddb5c5ec32a0e81c9d2en
}, {
  a: -0x1fed6550a441cfa1427949n,
  b: 0x7e9cb7e70f4ea7fda222dbb548380c7aa6fceae3n,
  r: -0x7e9cb7e70f4ea7fda242c91a98dc4e4a483f642cn
}, {
  a: 0x4ea8db932f4bcd09bb1a0bfeaad8b3420a0acfdf51af45fc89fn,
  b: 0x63b6f901418eda4n,
  r: 0x4ea8db932f4bcd09bb1a0bfeaad8b3420a0a6c2858ae046dafbn
}, {
  a: 0x1ba41ed71266e3b7930n,
  b: -0xa902fd00434009f586aan,
  r: 0xaabd3eedb4667830ffdan
}, {
  a: 0x6f7496afa00d2d2f7dc06954e07ffa6b4447c8n,
  b: -0xed91f8b7a6be49672ab5ec37n,
  r: 0x6f7496afa00d2e1d0fb920fb9ec96195fa33ffn
}, {
  a: 0x82cf9fe70bc1d8830cc08cfa1f3a2e6n,
  b: 0x16ef181n,
  r: 0x82cf9fe70bc1d8830cc08cfa084b165n
}, {
  a: 0xb5d776468516e24563be55cf2da3ef4a05abcn,
  b: -0xd7910d769e9f85c7a18c00e36319571607b1d43594n,
  r: 0xd79118d41603ee190fb0571f487649f046a6749050n
}, {
  a: -0x6ab52be113897a9a188480efffcan,
  b: 0xbaffdff5n,
  r: -0x6ab52be113897a9a18853befdfbfn
}, {
  a: -0xa43e68e8aa1c907931d66bc247a127445e5143e11bd0af41fe8d40521d72b3736a48fn,
  b: -0xbe733e900f4836486ccdd3413a29472296dan,
  r: -0xa43e68e8aa1c907931d66bc247a12744526a0ff81adc2bdd77c0631e09d01f0140db5n
}, {
  a: -0x7a78n,
  b: -0xaf0b6a2d3bebcb15191a7485c7be4473157n,
  r: 0xaf0b6a2d3bebcb15191a7485c7be446b6dfn
}, {
  a: 0x6d73f6n,
  b: -0x6062131f6n,
  r: 0x6068ea5ecn
}, {
  a: -0xb19990fa73077a327b3e69afd4d8d73f1876f0c5f0843934f51bf90fde949915a6a0n,
  b: -0xd8bebae5117795ef4017d04798d256e4bb1f9007917fd4b7n,
  r: -0xb19990fa73077a327b3d90f119f3c5c78287b0ae203ca0629e373df04e8d0795d1e9n
}, {
  a: 0xf70e2c2577e5ad3b35646656n,
  b: 0xf86b77b0d12a221n,
  r: 0xf70e2c25685ef5c02851c435n
}, {
  a: 0x6acb7ee0cn,
  b: 0n,
  r: 0x6acb7ee0cn
}, {
  a: -0xcf0635929ed271ddeef7d01c4f98d6e266bb966f8d9dn,
  b: -0xf5ef180b2bccecb0311e7ae7067d020d5de3f49aen,
  r: -0xcef6d6a11e1fb50f23f4be34a1286f1245e5b83043efn
}, {
  a: -0x1adn,
  b: 0x5af82a417c20bfn,
  r: -0x5af82a417c226cn
}, {
  a: -0x1c3eab5dc5ae99f88afb06cf845bc5e77f5bf4e413d06bfa866f35853b665dn,
  b: 0x8288ecf187a576fb552dc6a219474b4cdb34e3a287dn,
  r: -0x1c3eab5dc5ae99f88b032f5e5374403eef1147c07df2006f3b3ce8d3758edan
}, {
  a: -0x1131d37742da7cd65961e2e2cfd65c89eaec5b5075ac492c1n,
  b: -0x3d88be1609fc5dcde3982906d2a1c84n,
  r: -0x1131d37742da7cd659245a24b9cc602c1d08c3276ed9a763dn
}, {
  a: 0x9f8c48b77264ff951n,
  b: 0x43c941a35d3cf8916c517ec57a3c902a64f592bbdcd9ec47a456n,
  r: -0x43c941a35d3cf8916c517ec57a3c902a64eb99f75162c5f7ab05n
}, {
  a: -0x1c5ca1598f897fd57e5ed138013b8dd440c940dc9900ea1a2dn,
  b: 0x23e48782ecf0n,
  r: -0x1c5ca1598f897fd57e5ed138013b8dd440c941007d886d071dn
}, {
  a: -0xff13f19fbb739eb884b30114579fn,
  b: 0xe591abad69en,
  r: -0xff13f19fbb739eb8930c1bcf2e3dn
}, {
  a: 0x8286df6c2c364d9b86c7a481dca61cd45f1dn,
  b: 0x5c7a8c6ee0371c6bd442987341569c75d75fa534c0fa2f3359819808bce409002n,
  r: -0x5c7a8c6ee0371c6bd44298734156944d6968e2715c2076c6df397a3e5b16c30e5n
}, {
  a: 0x559140f9d0ebf1c0ab5a64c4bn,
  b: -0x826625175cae9b0aff147e04d8346b8ffefe4a09946n,
  r: 0x826625175cae9b0aff6a0f45d2055781bfa9a46e591n
}, {
  a: -0x90597b0fd53d390245f7n,
  b: 0xfac5be9a4fc0d46492a8e25769d6030b3ac7977097bca2fc78c268110304n,
  r: -0xfac5be9a4fc0d46492a8e25769d6030b3ac7977128161e0c4dffa11348fbn
}, {
  a: -0xb7116300f3df7ede23ca21ba98633c1b0n,
  b: 0x5f90959098c10b236n,
  r: -0xb7116300f3df7ede835ab74b3124473e6n
}, {
  a: -0x768f10n,
  b: -0xc24e06610c063ef358e4b56ea9bc87f9b9b8n,
  r: 0xc24e06610c063ef358e4b56ea9bc87832aa8n
}, {
  a: -0x194ff4783bde5eebcb70bfcd25328156351c797bc2a7cn,
  b: 0xd6cef80862bbe9dec5e8a6e514f1f45e670de7501436795b9638995696cefec28n,
  r: -0xd6cef80862bbe9dec5e8c035096a303cc5f9b2c0d4039e8e178ece73104ac16a4n
}, {
  a: -0x30726bc072bbf74b79891779af255eca003cdcd4bafa3de5880cb922291fcad7d7efn,
  b: 0x33af24f45dfc04bb4ce1992895e8a7de2136afb3d23535ca43n,
  r: -0x30726bc072bbf74b79bcc69ea3835acebb89be6de390268d662defd1dcf2000da232n
}, {
  a: -0x8c542a645f6bd7f31db67fa905bcd27e2n,
  b: -0xbn,
  r: -0x8c542a645f6bd7f31db67fa905bcd27d7n
}, {
  a: -0x9a6bdb536adb19716bf03f49c911e7n,
  b: -0xa110c83523n,
  r: -0x9a6bdb536adb19716bef9e3900dcc4n
}, {
  a: 0x3730612ece1c15a2n,
  b: -0x714125bb1e24a8dd576eea1a4470be1364d63d5f3b1d0b3a3en,
  r: 0x714125bb1e24a8dd576eea1a4470be13650d6dc069eb274fe0n
}, {
  a: -0xf3af9f5e5c91ad8a49ab42578e74e10a571dd51ea8n,
  b: -0xc531bb0n,
  r: -0xf3af9f5e5c91ad8a49ab42578e74e10a57118202f8n
}, {
  a: 0xe0ad04a0d01n,
  b: -0xd8d49ecd24dca03566779ea98e3d99168784en,
  r: 0xd8d49ecd24dca03566779ea98f1e461b2854fn
}, {
  a: -0x6ab118286653an,
  b: 0x7a92e68aan,
  r: -0x6ab192bb4cde4n
}, {
  a: 0xfca8c8c88e092d2bn,
  b: 0x295d8332ad5ccd5dd73de4d797c73e29n,
  r: -0x295d8332ad5ccd5cda951c0f09be10fen
}, {
  a: -0x8cea36b075a49d1092eaa8bcc529e9242ddf3b23571392241bc257b52f3b2375n,
  b: 0xc25f55e8dcd40e6n,
  r: -0x8cea36b075a49d1092eaa8bcc529e9242ddf3b235713922427e84d13bd08645bn
}, {
  a: 0xca3c2479e480da24978fe7e16c4e4a3285ed8621cb428a0ec3e2ba029ebaf5e74a8n,
  b: -0xcbd334da0cff2efc46061be40n,
  r: 0xca3c2479e480da24978fe7e16c4e4a3285ed8621cc0e5d439defb9319b00fc032e8n
}, {
  a: -0xac70cd815f5f29n,
  b: -0xe6940d9081b15337ccf92dn,
  r: 0xe6940d8fd54085b66d9a04n
}, {
  a: 0x7d57a44639a1599bfca213n,
  b: -0x29a61644140232d69da1b28f7n,
  r: 0x29adebbe5865ccec37617cb0an
}, {
  a: -0x19b81ff421feb7b0140adbe9c408ab8cd2203333c7902f6e2156fa59ceea3n,
  b: -0xaddc31c58772eecf2e1f518cd4d58f499e0bc9n,
  r: -0x19b81ff421feb7b0140adbdee6458f345af14640e59b16a0d3fe05bfee2dan
}, {
  a: 0x5d9fb778e2abec9308b08a3e29269cb4bb7een,
  b: 0xab136ecb27929b80197ef8d209fn,
  r: 0x5d9fb778e200d9243d88f7a2a90d1dbbe974fn
}, {
  a: 0x18ed8fc6f427e5f4509532e0633a569n,
  b: -0x20ab0a280ddb638b0b25a311dfd740d71cae298341n,
  r: 0x20ab0a280ddcf2640794e5903f1c4a2a4ab45d28aan
}, {
  a: -0x4c8f15287a2302d0ad9ce72d63487668043b3cdc638ecn,
  b: -0xd76cb38630c061a4e2da19510fbe5b039770f4bdb7e1e8fe2031n,
  r: 0xd76cb38167cf0f1d40a9ec4635efe82d62e98e3d742e1b37e745n
}, {
  a: -0xc2ed68n,
  b: -0x6e7c69f8bee53368d77071403ded56db7317n,
  r: 0x6e7c69f8bee53368d77071403ded561885afn
}, {
  a: 0xceb1n,
  b: -0xb500f3be75af8c7ceac5d70d1307e46824a04f0920398485bn,
  r: 0xb500f3be75af8c7ceac5d70d1307e46824a04f0920399170cn
}, {
  a: -0xf489aab9b717c0cfdfb762eb47fb2e74an,
  b: -0x4c811cebf12509f0a3f281908d6cde5d24a0f5e513a740edda6an,
  r: 0x4c811cebf12509f0a3e338f5e1d16ce117a2fa6ee4f2c13af320n
}, {
  a: 0x1a28ef036a2aa356e87092704f2324fa054n,
  b: -0x512fe53979d5d633905bb762fc031a1facc0c33f0885489cb5c584d7bn,
  r: 0x512fe53979d5d633905bb77d24f21d89d7641a277917b8ebd8ea7edcfn
}, {
  a: -0xe9f6b76d1746929ecaace91479c4ee5n,
  b: 0n,
  r: -0xe9f6b76d1746929ecaace91479c4ee5n
}, {
  a: -0x3137bd8b17a4230441d4b105166c0afe0258n,
  b: 0xea4717929028405e80edf32a73309fa20d7n,
  r: -0x3fdc2f0440a6a70a29e39037bd9f14f8232fn
}, {
  a: -0xd82595c7n,
  b: 0xb0b8ac799eedafc7ddf65208ba6223f2c56af9d91en,
  r: -0xb0b8ac799eedafc7ddf65208ba6223f2c6431f6ee5n
}, {
  a: -0xffc8419b8914a8e7e4fa0d561dc485f3346b973d7b1b5c013f318c9n,
  b: -0x55368e1en,
  r: -0xffc8419b8914a8e7e4fa0d561dc485f3346b973d7b1b5bfbebc8aabn
}, {
  a: 0xe894d434faca060713360a9c25e5e495cc6c961f7n,
  b: -0x9731692da1f8cd6ea5618b1n,
  r: 0xe894d434faca060713cd3c055387dd633b11f7aa8n
}, {
  a: -0xc0581accf89b38n,
  b: 0x9579aef6015d4050acbf97fd8988f0845d78e8c94de88d4e814f9426d13227cbn,
  r: -0x9579aef6015d4050acbf97fd8988f0845d78e8c94de88d4e820fec419e2ac303n
}, {
  a: -0x3bbeae8234c84197dcb7839e843b174b66cdc5b1e1e0c1c8614a382e8925n,
  b: -0xf0c46d175n,
  r: -0x3bbeae8234c84197dcb7839e843b174b66cdc5b1e1e0c1c8613b2be7b7b0n
}, {
  a: -0x82c37f79b9b4592be0f498632a06e0d5df62289996be346110fe9902d054db0bn,
  b: 0xc498e704n,
  r: -0x82c37f79b9b4592be0f498632a06e0d5df62289996be346110fe990394edc20fn
}, {
  a: -0xaf0f570be8040n,
  b: 0x7cc526cd314569d211662ddc6eac4b715e17b95199595209004789ceeda289n,
  r: -0x7cc526cd314569d211662ddc6eac4b715e17b951995952090b387f3fac22c9n
}, {
  a: -0xe060e6e538acd4523753c9184c6c8e24eea03832202901fe476n,
  b: -0x93fa7f520dc3a1d055323aa90fec2b7055a7ee3127a3n,
  r: -0xe060e6dbf904df315b19ac12f948e393efdd812cc5aa1eebcd3n
}, {
  a: -0x1630ed211d68dff1f9a3de8ec774619ca07ada059c57f403f153b7n,
  b: -0xc9031b7ee336b3c81da3bf577f12c84325ece363321b802d13e1b21cdc1n,
  r: 0xc9031a1bd464a1f18fa49fbd4129dbcbdfd3195b847b266794a17307a0an
}, {
  a: -0x201af2217de9103a454d325575c3195336f1a8075fd0cd107b68d61c880cb7766a90e0n,
  b: -0xeacan,
  r: -0x201af2217de9103a454d325575c3195336f1a8075fd0cd107b68d61c880cb77669a616n
}, {
  a: -0xcfebca280a281f8b224f149a884dcc4a6deb0e0cb30f01c055b4503397166n,
  b: 0x2402a2a2bf75f8185edbb4dfcfafa3d10084f81aebd1eff6b81en,
  r: -0xcfebca280c6849b54e46741c0e3b87986ae60849c317514204716f3302984n
}, {
  a: -0xc327e99c3e3c5c43a064ed57677n,
  b: -0x6dbbcdfb52n,
  r: -0xc327e99c3e3c5c4399893077b25n
}, {
  a: 0x6974682866582b974003f84ba44a56c095de6n,
  b: -0xa6c37c63e89e18dba5ba0982n,
  r: 0x697468286658360377ca36d585d8111c36768n
}, {
  a: -0xe26ede66157e5a700743cbb6be9n,
  b: -0xc5b002a703324edc5f6en,
  r: -0xe26ede59ba7e2fffd41eddf0c7bn
}, {
  a: 0x2d74dn,
  b: -0x8f9ac851dn,
  r: 0x8f9af5c6an
}, {
  a: -0x16c329556c9fe2f586dn,
  b: -0x6bdf2eb725ce644d8c7708e4449570380dfd271f89dccn,
  r: 0x6bdf2eb725ce644d8c7708e4447ead0eb890873c9455fn
}, {
  a: -0xc3a086da0eb3a0927256b772241bd9n,
  b: -0xf7052015f4e907c5f07e34c9e3eb9n,
  r: -0xb43034d8af651016134ed42585dd20n
}, {
  a: -0x4b0658751n,
  b: 0x52a9e40e324e2234b108d0bc7n,
  r: -0x52a9e40e324e2234fc0f29318n
}, {
  a: 0x323d35ec8fc344d58n,
  b: -0xacc6n,
  r: 0x323d35ec8fc34fa1en
}, {
  a: 0x15a09n,
  b: -0xc91605296cbab7c9b74ae75cf6ab97278f0d25f6a90000bc0da898b18d91a13cen,
  r: 0xc91605296cbab7c9b74ae75cf6ab97278f0d25f6a90000bc0da898b18d91b6dd7n
}, {
  a: -0x4a5d7937f54ee008b525702cafa2f42bc6fan,
  b: -0x52d3bf59a786d961c9b4fc0a0fde1c6647ce6e81e50891c512d13f9a53n,
  r: 0x52d3bf59a786d961c9b4fbbfb264e470f8ee65ccbf9865156fdd13d359n
}, {
  a: -0x4b918e4d3e4bb75a1993dd77aa691634b25986497767b02c0f4d2fd351a7933a8n,
  b: 0x8397ea1c7c6390b5f3n,
  r: -0x4b918e4d3e4bb75a1993dd77aa691634b25986497767b03448cbd19b17e09e99bn
}, {
  a: 0xd248cf21dn,
  b: 0xe4n,
  r: 0xd248cf139n
}, {
  a: -0xe0a62b9042a87fda180ed24dfn,
  b: 0x87a92908b3e4d3d04bc05d5an,
  r: -0xe920be20cde6cd171ccad8239n
}, {
  a: -0xb3e3a655c764f641aab97151bn,
  b: 0x5e1029ed87f3c39db22n,
  r: -0xb3e3a6b3d78ee3c99e7d0f03dn
}, {
  a: 0xba20cb15f32747d0ffdb8ce9bd7d9964a2bea07a2392ea812ean,
  b: 0x62fdb05ce9f8c8e618345f9eebb59a20906751b86be9n,
  r: 0xba20cb0fc34c4202604efe883a379f75e764fe711d1dcefa701n
}, {
  a: 0x14a3a37e6d20dca7596n,
  b: -0xdf7494c4c66fe5af5997293401d2001ebf853b554e130b65f175f70635b35d5fn,
  r: 0xdf7494c4c66fe5af5997293401d2001ebf853b554e130cb02badddd8437dd2f5n
}, {
  a: 0xe6a370c3n,
  b: -0xf1e618f05dn,
  r: 0xf2ccbc6120n
}, {
  a: 0xdb9d2bb37495n,
  b: -0x9675d474n,
  r: 0xdb9dc2294909n
}, {
  a: 0x22cb882fbd88703a282a816f20040dfacn,
  b: 0xa8d59500a4d9b8264b9d5e3637c51e8a41a211172883e2962e797843n,
  r: -0xa8d59500a4d9b8264b9d5e340b0c9b8e691b0d74a5dbcba42e389897n
}, {
  a: -0xb6d977f439e6b706de0cb7f956ecd429cbdc591e537fecfa47c3c1n,
  b: 0x6de26d296c0c34f43b3a3e0ca91be056cbdc8ada88c5066b44b7ff98786f2e6dn,
  r: -0x6de26d296cc30e6c2f7424c3aff9ed0ec53377aeb290e2c4630b7f8572b6f22en
}, {
  a: 0x3b1c841d3caef680bb0bee5n,
  b: -0xe46d48c7fb19a4e540a2f5de4636d53dc4c7ae70d54235165e3d78c24bn,
  r: 0xe46d48c7fb19a4e540a2f5de4636d53dc4cb603917160005c649298130n
}, {
  a: 0x807e7368469bdn,
  b: 0x65308b654b6d08145199c0550953ff831126c88b9c66n,
  r: -0x65308b654b6d08145199c0550953ff7b093f920732a9n
}, {
  a: -0xd2724e8n,
  b: 0x2f3ed11c5dcbcea5735ce06b4ee033cba197b27n,
  r: -0x2f3ed11c5dcbcea5735ce06b4ee033cc740a00fn
}, {
  a: 0n,
  b: 0xf03f8d3fad1d22b20c01f2cecd3463een,
  r: -0xf03f8d3fad1d22b20c01f2cecd3463een
}, {
  a: 0x8613facf3a87b979998f5eb584d31520c46be2aa1328b28a22dfcd3d971452n,
  b: 0x3177ac649be2c128d435n,
  r: 0x8613facf3a87b979998f5eb584d31520c46be2aa12f73addbe43ea7c6e401dn
}, {
  a: 0xe339f890d6an,
  b: 0xd24d98aca953c9c64dn,
  r: -0xd24d989e75b440b8e3n
}, {
  a: 0xa1384c936d94bc1a138a1c6e1bebea8dba4f25ea1ba5465a3a45d853ean,
  b: -0xa2d10c2956327e622f16dcba2n,
  r: 0xa1384c936d94bc1a138a1c6e1bebea8dc47c36acb1086e405d37461f8cn
}, {
  a: 0x3d7d269286eb0b0010a0d0d28219996f87beedb1fc5a98en,
  b: -0x8b2f32957a0592de12b720029526aa5952f364064b99bcfe60e3bf3c2n,
  r: 0x8b2f32957a431004a53e0b0d95374b2a25757d9fbb217bec12e019d50n
}, {
  a: -0x8800ffn,
  b: -0x254f6178adc33fcbd56d75cf4417b8ba17n,
  r: 0x254f6178adc33fcbd56d75cf441730b918n
}, {
  a: 0x2169abf482c68e241c76740d4bcce67a802bc3350d3c9a9659373d6f80efa1d6f332n,
  b: 0x8c315f4e49521e273b6a7345bn,
  r: 0x2169abf482c68e241c76740d4bcce67a802bc3350d33d7806452a84d9e7beb2fbed7n
}, {
  a: 0xbc23n,
  b: -0x9fn,
  r: 0xbcc2n
}, {
  a: 0x9c624f40a280ab93bf3de946d07e13542716874bd02c7a59e16385f7b969n,
  b: -0xd6fa81cdddd7df3343b21b1ef2e7d7ebdb0f52c75d4eb34a42be2ee3n,
  r: 0x9c63263b244e896b9e712cf8eb9d063bff02625b22f3d7a894adc8b5e84cn
}, {
  a: 0x240n,
  b: -0x9aa2b558a4df0bc604n,
  r: 0x9aa2b558a4df0bc844n
}, {
  a: 0xe77c02352825ac09d8d870397402b585b0be959n,
  b: -0xf1df5ce8e8c64277d8ac046bcdn,
  r: 0xe77c02352825bb27cea6fec5d82a33107105526n
}, {
  a: 0x8n,
  b: -0xfa260c7915ce5264n,
  r: 0xfa260c7915ce526cn
}, {
  a: 0x614f562cf0818f402b33f4f7b8417562cb10314af3035adb47n,
  b: -0x4d7f92dae6fc187e930e990fe4a6328adb885f54c14cb0a93c7bc84931ecn,
  r: 0x4d7f92dae75d67d4bfff1a9f24d1667fd340a0ca2417c0da876ecba40d33n
}, {
  a: 0x93c5688b5d73a7d3fn,
  b: -0xdb99031fe75f021473475288794a80685c9793c3afdbn,
  r: 0xdb99031fe75f0214734752887953bcbee54d6afe2d1an
}, {
  a: 0x6d3286b4c6e38d0c0d87beddc22545d9a03d7789815110dd79ef9n,
  b: 0x1101d69926cadc7d8n,
  r: 0x6d3286b4c6e38d0c0d87beddc22545d9a03d6687aab7ea129d721n
}, {
  a: -0xe355defdb2d4018ed8d3fa3d8f1172n,
  b: 0x986932de87551an,
  r: -0xe355defdb2d4018f713d2d1c16668cn
}, {
  a: 0x20d1f2fa1c301757ea703b8ece820fb3d0e32d8n,
  b: 0xabd72acc8f2n,
  r: 0x20d1f2fa1c301757ea703b8ece8163dca6169e6n
}, {
  a: 0n,
  b: 0x2d27d5d99n,
  r: -0x2d27d5d99n
}, {
  a: -0xe46fa550c3fdd40f504a030n,
  b: -0x7cc0a0e99b859e3029b013a865af4df9cb7229n,
  r: 0x7cc0a0e99b859e21e2b5be9c25d20d04c6d1f9n
}, {
  a: 0x3f5228a1n,
  b: 0xf2b262769f4ddc2ea9e148n,
  r: -0xf2b262769f4ddbef57b8a7n
}, {
  a: 0x9f83e36e130df514408aa989323n,
  b: 0xca8519a8b29806739834bbe7ab7efb145cn,
  r: -0xca85199eba59cf9267556aa3a2d4628139n
}, {
  a: -0x76bfbb02b37d3d0fd13e092d09aa3ec7af9634b8d11da9a906efe4n,
  b: 0x3690652794451966c311cea97c3e646565e124f898993bbcb040e392394cfn,
  r: -0x3690652f0040c991fae59fa6901ef7360085117391fc8749c21b7e22a84b3n
}, {
  a: 0xf6dcea8695bb330326ba1d84cf74be7a316cn,
  b: 0xb71dbc65ed01ffc1c1a18d0ca16ee013814cb7n,
  r: -0xb626df7b666c448ebe7ad2ef1c9f6b55071b4bn
}, {
  a: 0xfan,
  b: 0x747bcb5202965a052c51f7cn,
  r: -0x747bcb5202965a052c51e82n
}, {
  a: 0x502df8d89a49ca0d93cdba40e8d88ac9ff85742dba005799n,
  b: -0xcb573426a22ed3fceb38f0104a8n,
  r: 0x502df8d89a49ca0d93cdc6f65c1af4ececc542e149015c41n
}, {
  a: -0x3d46730ce19665c6c7bb87e4dn,
  b: -0x8857af2f75bcac99b207a20340949b017ec71258f99eda48628c9c5614n,
  r: 0x8857af2f75bcac99b207a20340949b017af2ab282b8573ebf610e3d7c7n
}, {
  a: 0x81000eec0f46c52bccf85a9888918c2d15784b5fn,
  b: 0x3f8d6684a596ab1c25adec0b55fbd28f5d8b87ea21dfcd8bcaecd05210c076an,
  r: -0x3f8d6684a596ab1c25adec0345fae3ce691f352d525a240341d40d80b93bc0bn
}, {
  a: -0x820ea0a0700e6e3e74bdd5b649b06d49aadad57d1n,
  b: 0x909b75n,
  r: -0x820ea0a0700e6e3e74bdd5b649b06d49aae3df346n
}, {
  a: 0xb1fd5a57319bf4c1a5acfad9ac87d3n,
  b: 0xef051c156acn,
  r: 0xb1fd5a57319bf4c1a59e0a87eb3127n
}, {
  a: -0xf9bc4n,
  b: 0x39ff086ed2fce68bf15c613ff5d52an,
  r: -0x39ff086ed2fce68bf15c61400570een
}, {
  a: 0x4921b99575fc07ea9f5a6270a8abbbb72290ec2f9924842f4da5bc75ae94e8fn,
  b: -0xa24ea3a206b1dn,
  r: 0x4921b99575fc07ea9f5a6270a8abbbb72290ec2f9924842f4e480b19509b9acn
}, {
  a: -0x148926dfa871c9513e2cae03354c5beee42b3b9cn,
  b: 0xc5a82f9fec86558ad715686c9367629dc454cbfa260c2304e2fd57e817c7cn,
  r: -0xc5a82f9fec86558ad71569b525d55d24e0e9dfdcf0ec5659a8bc462acb818n
}, {
  a: -0x4ab8ab95bf4449d266n,
  b: -0x6c974d6d46e2e2n,
  r: -0x4ab83efe71d702ef84n
}, {
  a: -0x561ca68bbd32a8561a3ce842106n,
  b: -0x3994d9d12eb30ad7126468356bc22455n,
  r: 0x3994d46f644a4f03e7df06919d3e034fn
}, {
  a: -0x11b2ce645d00ef56e43ccf64385289dbcd7729n,
  b: -0x5e178n,
  r: -0x11b2ce645d00ef56e43ccf64385289dbc795b1n
}, {
  a: 0x3ef3645f7f1ce3c37c95653n,
  b: -0xfd472336ffad9557ffca96115f77f1a6bda04926cdb5cde8daa7498b486ee0d1b3n,
  r: 0xfd472336ffad9557ffca96115f77f1a6bda04926cdb9bd1f209f3b5984a6aa2806n
}, {
  a: 0n,
  b: -0x68db49117a9n,
  r: 0x68db49117a9n
}, {
  a: -0x32b584a3c30f1b0fbfbn,
  b: -0xed8ec611761975aea4e857fc6bbbc9a1154f0b11d020cf96263aa338926079eae19358n,
  r: 0xed8ec611761975aea4e857fc6bbbc9a1154f0b11d020cf96263777e0482448f930975dn
}, {
  a: 0x41bb4d50cb7e0314468a31aa0fa36e279cae9aefc2d65267a9cce58dn,
  b: 0xb0eae11016ded3d8320afa0307f17ee09283ff71db815fbc4fdf57195n,
  r: -0xaccf2c3b0a26f3a6eda256e866f747fe18b915c2df53fa95d54288c08n
}, {
  a: 0x39126e459c8b5bc25367a83cc81f42ed2b098c61595163d5n,
  b: -0xad0d4469e1876382c45a9d41d9795232313919bf7c4601074d8002b1b435an,
  r: 0xad0d4469e1876713eb3ef70a8f357768abbce6417074d3b7e6461846ca72fn
}, {
  a: -0x7a92128f2e063c4794e4facc6a466348a844n,
  b: -0xf589f23baedfe9a6d18b7b0bc34d3db29ae6a1467ed49c01464d93ed23fddn,
  r: 0xf589f23baedfe9a6d18b7b0bbba41c89a8063d8205864c547fa92db899799n
}, {
  a: -0x21ac5c2b87a5e6e12c2c464c414884a42edab22n,
  b: -0xb9ef258d5d8c62bd972988e12a119756d519cb6n,
  r: 0x9842c961d5e67bdc6afd4294e8c912b2a63f194n
}, {
  a: -0xa527dc74056e232b13218ab1b344766f7b60fe287a3n,
  b: -0x102dfcbb6d940f43ca29f888aeba4d0753d057f919cf1fn,
  r: 0x1023aa3da653b8619778c670039f18bfecd8a1e937477cn
}, {
  a: 0x57ce2n,
  b: -0xd6409b5826eb1n,
  r: 0xd6409b587eb93n
}, {
  a: 0x2084d238afdd2ded3c6a4991f8c2cf8e027ca3641daa8f70949ff3331b0n,
  b: -0x2f6fabedcbf400214c733aa5b1bf85a7fec042eb42554011def6a8a831109n,
  r: 0x2f9030c004a3dd4f39afa4ef43b848778cc2bf8ea672eaa14f8b489b642b9n
}, {
  a: -0x3b521cc1367ca108015e45845bf654ffae2fa148b9c0f11f92a8570e85a8fdaf1n,
  b: 0x1fa5aec3e23cbfn,
  r: -0x3b521cc1367ca108015e45845bf654ffae2fa148b9c0f11f92aa516971e7217b0n
}, {
  a: -0x6d2bb8fc41b68e026a562573bae4751ce69d0f24d9449e88b83a03dn,
  b: 0x712d91bdc5f7f358369a81fc0a5abbf4e4d5073475a2892b8dfd955cdbd62931cen,
  r: -0x712d91bdc5fec613c65e9d64ea8161573c10b57bc770f2fc804b29a6c461acd20bn
}, {
  a: -0x47785c2fbc1b5c0691178aa84ec939e66ff48be4843a4da971e86b213b2cc66a65be4n,
  b: -0xf2856e02n,
  r: -0x47785c2fbc1b5c0691178aa84ec939e66ff48be4843a4da971e86b213b2cb7420ede2n
}, {
  a: 0n,
  b: 0n,
  r: 0n
}, {
  a: -0x7c0f5n,
  b: -0x9c1bd2289e69cd496f72bf0bce3fb10ed1d2597ba0e8f44n,
  r: 0x9c1bd2289e69cd496f72bf0bce3fb10ed1d2597ba06ce4fn
}, {
  a: 0x32c099292fbcf355381e826n,
  b: -0x127a232b17149bdbn,
  r: 0x32c0992a575f2606a968401n
}, {
  a: 0xd17331beaf71c0e90d8adf9b1b5a2a27d71d6621f37802debff10d4de0fbf870250n,
  b: 0xcc1da45ba06c4969959c74decae9555511d8807d4e074d34fn,
  r: 0xd17331beaf71c0e90cbec1f6bfb9bdde6d87c9ad14ad19896adf34cd63adf122f01n
}, {
  a: 0x7c5175a85n,
  b: 0x2c264e3792f44fe869fd313c05b71ab2f47b53an,
  r: -0x2c264e3792f44fe869fd313c05b71a36a305ab5n
}, {
  a: 0x93f056d8f12e724an,
  b: 0x677c8cd329c5c3e5546n,
  r: -0x67734dcdbc36b0fe2fcn
}, {
  a: 0xc1a2d1e772c1f61d87ca5438062b7n,
  b: 0x5179d4c17453de8388c75a2b4cccb1e0bce52604783b22f55805930fe525b31ee7f8n,
  r: -0x5179d4c17453de8388c75a2b4cccb1e0bce525f85e0e047e2be6313768806f9e8541n
}, {
  a: -0x237n,
  b: -0xfa50b07fa7ded14a93520ba0cc630691cfn,
  r: 0xfa50b07fa7ded14a93520ba0cc63068f98n
}, {
  a: -0xc08e7cc7e1e5dc2275770d65fcd2551a57b15eb00116n,
  b: 0xd2b0c3dc6e40da23aa943d3d3ad2dc97n,
  r: -0xc08e7cc7e1e6aed339537ba6d6f5ffae94ee9982ddadn
}, {
  a: -0xeaa7d79e3d1c0b9ad4a83df9fe7484651d2c238f1b6daa4b0017ba6cdf093beac091an,
  b: 0x1942n,
  r: -0xeaa7d79e3d1c0b9ad4a83df9fe7484651d2c238f1b6daa4b0017ba6cdf093beac225cn
}, {
  a: -0xb554290ee903e7a1dn,
  b: -0x6dffcan,
  r: -0xb554290ee8fd07a53n
}, {
  a: -0xa96b2b1be64aae8f44e7d4f6ecef576b2101dn,
  b: 0xd3085e6an,
  r: -0xa96b2b1be64aae8f44e7d4f6ecef649ba6e87n
}, {
  a: 0xe1e9n,
  b: -0xa831f20191bd0a75e10faf5cf2dd9a35f294cf82503b8416db83a9f98n,
  r: 0xa831f20191bd0a75e10faf5cf2dd9a35f294cf82503b8416db83b8181n
}, {
  a: -0x6en,
  b: -0xe2fc4fa130a645b26724670c1f59ebf8079cc5d712f1e23ecc6f8866n,
  r: 0xe2fc4fa130a645b26724670c1f59ebf8079cc5d712f1e23ecc6f87f8n
}, {
  a: -0x83f65f553ee8b342d76n,
  b: -0x421b1215ef16644221b7c9a28dn,
  r: 0x421b120dafb06eee332c957517n
}, {
  a: 0x29d4da1d973a2fad48871d8057315n,
  b: 0x28af16b7cbe2717254d6504887321ba202n,
  r: -0x28af141a7e4097feb1db7bc0155a162eedn
}, {
  a: 0x749f1874eb45d294a22349n,
  b: 0xbef899248739764587bcn,
  r: 0x73e01fdbc6be991e5c9b8dn
}, {
  a: -0x314ben,
  b: 0x9460f1eab99e2456aen,
  r: -0x9460f1eab99e276b6cn
}, {
  a: -0x5a9d9b34a4b2829388ef2d87a660b93feae60aefb1a236d36d3c133c7a5fe10n,
  b: 0x1bd1fcbff0574aab5958f85c7ee9053a4ed9347677e64b6103d0dd8f150c22e4fe6d8cn,
  r: -0x1bd1fcc59a30fdf5a48121950ddbddb4b4e4c8752646fa5c1df44ac5e8cd56aca46b9cn
}, {
  a: -0x99c931836764957e6n,
  b: -0x412169950396e3abbe40ba073f0e96480b9f34faa2af4514a8n,
  r: 0x412169950396e3abbe40ba073f0e96480202a1e26c38fbbcc2n
}, {
  a: -0x60154d2f372c317c7825121980b2fca53b104ec8b067a63n,
  b: 0xb3860536963c09e9f03baae0529bfcn,
  r: -0x60154d2f372c317c835d726cea16bd43da140976b59165fn
}, {
  a: -0xab7dbdfe56e77aca2b3de4747a356a81n,
  b: 0x885198e11ab779cbabba6457f8e9da78c79c7592d8d7c32a0c6c712e6n,
  r: -0x885198e11ab779cbabba645803a1b658ad0aed3f7b8ba171540fc7d67n
}, {
  a: 0x5c6df3ea1a8d69n,
  b: -0x3cadf8bbc2fe16n,
  r: 0x991beca5dd8b7fn
}, {
  a: -0x6bcd0348ae72966bf43f2f0bd70e3d1508bcf586fd1599e12bd8a43a314702096n,
  b: 0x2f8d80af93d154888ba06bfe50a7fe50fd576881e411b873dcae4124192n,
  r: -0x6bcd03783bf345ffc593b797777a3b65b0bb4684547e1bc53d911816df8826228n
}, {
  a: -0x48093dab1b908a737ca42463d0508c05b22f75e14679b45bf8f8bn,
  b: -0x990719a1d22d63b3d57cd61be1a488fad09efa0n,
  r: -0x48093dab1b9089da758a8291a2ecd830355959ffa1f0b98b59febn
}, {
  a: -0xe181f8ae001b81n,
  b: 0x39f43ef022290dde3cff9fffn,
  r: -0x39f43ef0230a8fd6eaffbb80n
}, {
  a: -0xbfd3a83160c36bb560a6ef3c92524345c0dd35853b608e85e7706733893cfn,
  b: -0x475240230221d0baf0725ab2ed8cef2211n,
  r: -0xbfd3a83160c36bb560a6ef3c924dce21bead13682fb187603c418e64971ben
}, {
  a: 0x70a6640afffd8acc7c946cfa915c0689ceccff861b38768925359d38c2349d2112n,
  b: 0x1be07b393a674477ac60f20f3c8a9f22bdc38e8568a6eb1a09681cf86ddbn,
  r: 0x70a663ef1f825192154ff54e3069f74d442ddcc857a9f1207e4a832f5a17a4b337n
}, {
  a: 0x279627c7280d5e40c4a7148179ff2a092eb7db03492n,
  b: 0x5645d1baafa0b9c5f67fdb24c39a5be544cc071a0c394cd9b40cc537a8df68564n,
  r: -0x5645d1baafa0b9c5f67fdafd2d7294bd376dc6556524cb5fb4e2bc08f104650d2n
}, {
  a: -0xf04578ca763971833c242309cab6f76ae4d7222dd177a1171543a1043d567fn,
  b: 0x977dc404cad868d904a567f9c306c7510faa7951856bbbd6ec3be5651n,
  r: -0xf04582425279be30c2b1b3542136939b514c3328790cb96dd1010fc7fbacd0n
}, {
  a: -0x4841n,
  b: 0xf7ae3492d0069860046ab9a13f96c10f4871da41a17ed6ee289897da300cn,
  r: -0xf7ae3492d0069860046ab9a13f96c10f4871da41a17ed6ee289897da784dn
}, {
  a: 0xe56133ee7ee5d0d80a7c9856318a642ddb2c479878b13391b83ecben,
  b: 0x5an,
  r: 0xe56133ee7ee5d0d80a7c9856318a642ddb2c479878b13391b83ec64n
}, {
  a: 0x9220181b78bd40ed087c9f7933e89fdd579281b315cb4n,
  b: -0x25c18af4d4cd3b04154f4c60e5bbfeaf66a3774a3cf1ea83e6c8n,
  r: 0x25c18afdf6cebcbba1235b316d85f642a52d751fb61a05b5437cn
}, {
  a: 0xaebdd914a27ec42ef06ben,
  b: 0xc7add3d31efa3d89198252bffe15ab456f52251n,
  r: -0xc7add3d31efa3d8918d394e6e9732c814061b93n
}, {
  a: -0x96d0ccfd56fafd80178013ebc323364n,
  b: -0xe599055da5fc5c83241322a2a63e629431a949d9e6eba48fe05f6a1c561c82aan,
  r: 0xe599055da5fc5c83241322a2a63e6294283c3d0a117bf4b7dee768dd99ea4f46n
}, {
  a: -0x46f63c31n,
  b: -0x5a97259dd54544d28dd02669dee5db0cbcdn,
  r: 0x5a97259dd54544d28dd02669dee16ba8f9cn
}, {
  a: 0xeeac0en,
  b: -0x6b3f4d4b314f0051cd3n,
  r: 0x6b3f4d4b314f0f3c8e1n
}, {
  a: 0xb5def1b8e368919ffa3cc971b1f1f944e65f90960fb02390b5ddn,
  b: 0xe89e124d1f966beb61e8f3b5b05ff1c84b5dce8fe245a6ffb61e52820442348fn,
  r: -0xe89e124d1f95b60c7030104d1ebff78b81ec1c9de900c0a0258842d1e0b17eb2n
}, {
  a: 0x3545e00fe1b8fdda92b350ce5bc127n,
  b: 0x464f405eb80ff2f65300ed1937eeaf90a37dcdc4f3a65851851620ae9fcn,
  r: -0x464f405eb80ff2f65300ed1937eeac3c457ccfa963c8af2650093af28d5n
}, {
  a: -0xb71fd8a861fd653117f5c94b43d45c4d5489b9b5e9f27c095625de5f0368cc504an,
  b: -0x29327acf5a935e001d24e103219d8e10728ben,
  r: -0xb71fd8a861fd653117f5c94b43d459ba2cdcc40cb4127a370815ac452a87c5278cn
}, {
  a: -0xdf64acc338cbc6n,
  b: 0x2915f04735755cc5ccf5a0a7c5ead9ab718n,
  r: -0x2915f04735755cc5ccf5ae9e10b70d382den
}, {
  a: -0x6041792a7f77cea0cb68d2418132cbe096ed17ebd2cc5bc2f54d1dn,
  b: -0x5bc7a1cc3d7c1af952e58962ef837dd15n,
  r: -0x6041792a7f77cea0cb68cc8507160808d53d82bd7a362ccabd7008n
}, {
  a: 0x7e21062c5348adb537285cn,
  b: -0x9a8a37076495fn,
  r: 0x7e21062c5cf15125ad71bbn
}, {
  a: 0x312732ba0124112f54ec93b3b7034335a8ad7e170141e55ebfc23bdn,
  b: -0x97f530f07dafc85ca33a9ca2bd09f101dae4693f2a703ab6ea373085b4eaff6n,
  r: 0x97f530f0aed6fb16a45eadd211f684b591e7ac74d31db8cdeb7915e474ad3b3n
}, {
  a: -0xb3ee6a31d086e6199b434e576fd2fc87e6058330432f852n,
  b: -0x8c2n,
  r: -0xb3ee6a31d086e6199b434e576fd2fc87e6058330432ef90n
}, {
  a: 0xa006326e9f8c6804291f8484591d5e3c0924ee38150n,
  b: -0x6bdn,
  r: 0xa006326e9f8c6804291f8484591d5e3c0924ee3880dn
}, {
  a: 0xede12e3d1en,
  b: -0x7b3f642e9a526aab0700dac6155beb9d5a77c772601a0en,
  r: 0x7b3f642e9a526aab0700dac6155beb9d5a78b5538e572cn
}, {
  a: -0x18a8d0458d4cb2c00fe742ef2821f799dea74df02b39561f541e6aafa240397e905389n,
  b: -0xff3c59ccd04dfe119422a1b652b682730bc0c36d99c4c56b02fd076377f7b7429n,
  r: -0x18a8c051c7afe5bb300629acfe06926e76801d341f027c8307c7ba7fd1ca01ff14df60n
}, {
  a: -0xcab37d1726cee828febc7c63b73f7d3f21e5111e605e98e28351dn,
  b: -0xf7f18ada2b4f996b2e6217cfd91e23f678d772dde3a726e6857fcdn,
  r: 0xeb465308b8e2aae89e7650099daa2c2286b921cbfda13d585d4ab0n
}, {
  a: 0x698efc8dd0963fa547aa13707bbbcd29e09d05bb97c2en,
  b: -0x57e85565n,
  r: 0x698efc8dd0963fa547aa13707bbbcd29e09d0b3a1d193n
}, {
  a: -0x852566a6db2f87bc857469f9f030fa4d7d13dc378d4dbea167e080b4545bdn,
  b: 0xc12c34ecf91c0fa6fa8894cca962d137b2be2cn,
  r: -0x852566a6db2f87bc85746a0602f4491d0ed4d6a735d70b6bfe0d942f803e9n
}, {
  a: -0x5f8a13d9af7095f3b6cab254129de48d97b47366cae0f80e60e2c170fea0c3n,
  b: 0x453e21f54ac7a37427dbc523baed93e1ef7972192f3d34f12144bec1cn,
  r: -0x5f8a182d918feaa03101f4d1cef0203c70f2925e62028b023431d3854a8cdfn
}, {
  a: 0xd0a79e6ed19bff3a117950309b7103e1d237bffbn,
  b: 0x46445366c5c9c9bff4823b16242de4n,
  r: 0xd0a79e6ed155bae6aab38666db7c81a6bc139217n
}, {
  a: 0x704f8920545ed3a654n,
  b: -0xf70c9db79602c0950221fcaa944f02a4f2d3e8e56aca051n,
  r: 0xf70c9db79602c0950221fcaa944f09a9eb65ee2b58046a5n
}, {
  a: -0xb779e7b39352c2790ece360f4f3f3437f537b4f2n,
  b: 0x527d4952577cdef71098b1a99937be4ca17d65abb404623n,
  r: -0x527d495dcf1b5a3045c4d93a861b1f419570a92b077fb15n
}, {
  a: -0x63aac71e94104ff5f06d42a4f866e5da821c2617915d5552da2an,
  b: 0x6ac7a38445ed547587an,
  r: -0x63aac71e94104ff5f06d42a4f866e5da88c8a04fd5bc2a9a32a4n
}, {
  a: 0x2fbd0e223ab46586d58an,
  b: 0xca83e19d5275c5c16acd28a79cd4664f7382a5n,
  r: -0xca83e19d5275c5c16a9d6b997a99b1e9ecad1bn
}, {
  a: 0xe0aec4n,
  b: 0x104b3d4df56f2762bca66db1f458babd47n,
  r: -0x104b3d4df56f2762bca66db1f457da0e83n
}, {
  a: -0xddd2a3f937face51d63fa1a90fa3ce293n,
  b: -0x5438e392c61d0f18cd9n,
  r: -0xddd2a3f937facdfd9d5c0ee2f294b55ban
}, {
  a: 0xcc42e0bb9cefe36083b9035ea3f56f0dde26n,
  b: -0x659d6n,
  r: 0xcc42e0bb9cefe36083b9035ea3f56f1437fcn
}, {
  a: -0x655b0f2aed5d044130d5299c3378f94a81cbff257fn,
  b: -0xb57e4f33884f9d51b9cb79200d71c566199810b8bdfdn,
  r: 0xb518f4245d62404d789aa3f6713e4c6ccf1644b9987en
}, {
  a: 0xfcb1086337d954d62e089a664fd9b8d9a0c31f63e6d35cc59cdfaf2n,
  b: -0x6b0bd47c3n,
  r: 0xfcb1086337d954d62e089a664fd9b8d9a0c31f63e6d35d30a8b42b5n
}, {
  a: -0x57ac219520e4d20a4b745e75ef6n,
  b: 0xcd0c77a27cfa9cf193c4c9f03376bbbaaeda4962f23d28d5644373cdcaca0fn,
  r: -0xcd0c77a27cfa9cf193c4c9f03376bbbaaedfc4250b8f372284e82b13b22905n
}, {
  a: -0x46e5759n,
  b: -0x87fdb52eb3a9b163bc896fe0c0ddc39ad0c5f14243cff6b8df41n,
  r: 0x87fdb52eb3a9b163bc896fe0c0ddc39ad0c5f14243cff24a87e8n
}, {
  a: -0x34a49e8c96d2543457f08e4f0a4ddd0ffc0249e7ab1a103999ffabf12c0a7f23can,
  b: -0xeccdc805c4876e528826d27dcb9a9880087c381de93832316f7e81db053552abn,
  r: -0x33b7d0c4910dccc60568677c8c8242777bf9cdaf8d30d80768902d6f510549d11fn
}, {
  a: -0xfec9304097b667a9e4ea1cea28b27526776bfa630193165ca545baab156n,
  b: -0x4f0a16c3abcc86855e5en,
  r: -0xfec9304097b667a9e4ea1cea28b27526776bfa5e10f1aa21e87d52552f8n
}, {
  a: -0x74658034f4e22cb196ee803488b8d184f05afca1717f4ca5613d3f0626601272cfeen,
  b: -0x70b13f70c46a523ff11ae25bbf230199b6c8en,
  r: -0x74658034f4e22cb196ee803488b8d17de54705952ada28a64f8f194a342ff8d76360n
}, {
  a: -0xabc6a1386bcb1e21a9813fde8104e232954468e27cf88352e0d2e55f8b751509ba0fn,
  b: 0x51e2cd29d8065573d95b42bfn,
  r: -0xabc6a1386bcb1e21a9813fde8104e232954468e27cf8d535adfcbd65e0e8ee64fccen
}, {
  a: -0xd329e52357c73bc8be3716n,
  b: 0xd93acf8afbe223an,
  r: -0xd329e530eb7434787c5950n
}, {
  a: 0xc6b32b7c6664d5cb3ff8e5bf93f5c33n,
  b: 0xbe618188eb307589cd606b8fb2dab86018be7258dn,
  r: -0xbe618188ea69c25e50fa06b9e79abf7a592a7c95an
}, {
  a: -0xcf9b9e736b5n,
  b: 0x4ae5en,
  r: -0xcf9b9ebe513n
}, {
  a: -0x13a306b6c2985175e4a0e44164a4535409n,
  b: -0xee801c82cf9061c092c3b1ce7eef0b9d32704a6bf20512b3a172n,
  r: 0xee801c82cf9061c092b00ec7c82c734bbc8ba987b0a06e604d69n
}, {
  a: 0x5d5c5047d4e8f549bd44ce88en,
  b: -0x45460f23dc3267bb5e63387f2c7987a655a7e2403cdfdf3deccbb53ba1dn,
  r: 0x45460f23dc3267bb5e63387f2c7987a656053e9084b4c8333688fa0a2abn
}, {
  a: -0xa447c4a8880ea9cb5333196af7n,
  b: 0xe288ec8803bcc17n,
  r: -0xa447c4a8881cd25a1bb355370en
}, {
  a: -0xf8914b23401e5e8a901668afcf2e4486daed056079509fff14e99n,
  b: 0x9014066e9n,
  r: -0xf8914b23401e5e8a901668afcf2e4486daed0560795130131b582n
}, {
  a: 0xbe6ea7894c44b96b2de9498274ce3c80c08c811c02c2d4bde6fcfeab3360b8429n,
  b: 0xf3cee99ed19ecef2187cc7413bb63ca569b879e8ba380d40n,
  r: 0xbe6ea7894c44b96b1eac5ae887b44f919f04b4a7ef0770f39061770ca7bd376e9n
}, {
  a: 0xd124700d2e696ff62da67e569fc6ebebe380762bd09b72c3ce46f978f6f11299699bn,
  b: -0xa7e67cc19494a5d02fbd8b983n,
  r: 0xd124700d2e696ff62da67e569fc6ebebe380762bd0a5f12b9a6042c353f40e72231en
}, {
  a: 0xa056n,
  b: -0xf4a54acc44e25b4887ec81cc1bf722a53f656e4817a223316a1177f0f900e00d2n,
  r: 0xf4a54acc44e25b4887ec81cc1bf722a53f656e4817a223316a1177f0f900ea128n
}, {
  a: -0xa8e168fac64e240f4ce0n,
  b: 0x99d7fb9ca5f555c7f45dde72d87c3c9004e6fdbf46b85157bb98c69fe1e14f0c12n,
  r: -0x99d7fb9ca5f555c7f45dde72d87c3c9004e6fdbf46b852009d01c16630055e58f2n
}, {
  a: 0x72bb572421b04bd5a4ab08c259dd4107534n,
  b: -0x6e9b2a117494ce22a59bd480123c7047n,
  r: 0x72c240d6c2c7952286d5627fa1de64ce57bn
}, {
  a: 0xc2dbdb65e7438459236637369fd6163a36850c100fn,
  b: 0xff8946e3c10851f642a8fd8848cc5475603db9n,
  r: 0xc2dadbdca05fc350d16ff48da24dcd6de20fabd256n
}, {
  a: 0x5db6b0e020bee59a0698e3e07240n,
  b: 0x8211d6ffec423b2ddf0a40e9959cea9bafe02n,
  r: -0x8211d6ffe666d01fdcfe528ff5335c5da8bc2n
}, {
  a: 0xac8166de002084n,
  b: 0x7491742e28e8dc18ab28bcn,
  r: -0x7491742d7c67753aab0838n
}, {
  a: -0xb6a202d0d2f852f79e4fe0d3fe19f56439a9n,
  b: 0xb40f79f13cb7c1ffebad1cca25ee47259fd035n,
  r: -0xb4c61bf40d8aba52e34b6caaf9ec611b0409den
}, {
  a: -0xb130a9146fe78e27b8c30da2ff9c70594257c0d5b44n,
  b: 0xa5ffa8da8n,
  r: -0xb130a9146fe78e27b8c30da2ff9c705942fdc07e8ecn
}, {
  a: 0xbb48b1951cf5fe76863f93898817ff572e75c9ec57ba7fn,
  b: 0x242c4aeecdcad22222521df101ad1f1fd5dfn,
  r: 0xbb48b1951cd1d22b9771c8b765f5ad393d741ccd37e4a0n
}, {
  a: -0x39d1f37118d4e27d72d74a48063f1c4121b60fef5050f35bba71221ef5c6932c5en,
  b: -0x722a06893a5a9db56b3a8b145f37b27a3dc9f5cd681n,
  r: -0x39d1f37118d4e27d72d74a40e39eb3ad7c0c34989ca84215c6f5fa7b19273655ddn
}, {
  a: -0xcaf87bc2f2374an,
  b: -0x68a0a0026ab582e59b85f617452ba483e2a1f01c8d506fee0c14d98ba632d1bn,
  r: 0x68a0a0026ab582e59b85f617452ba483e2a1f01c8d506fedff6551cf770f5d1n
}, {
  a: -0xd05en,
  b: 0xe5492b2c0c434961e4b68507361c2e540df921en,
  r: -0xe5492b2c0c434961e4b68507361c2e540e0627cn
}, {
  a: -0x80f0c1d1851f6ec39c1b4f9be5ad49a7fcbab4ca25a19a34972903fbbd7f6ben,
  b: 0x39b6db55b08bdn,
  r: -0x80f0c1d1851f6ec39c1b4f9be5ad49a7fcbab4ca25a19a349762bad7132ff7bn
}, {
  a: 0x42e5e65n,
  b: 0xe2613c35a7n,
  r: -0xe25d0dd742n
}, {
  a: -0xf39a45b4f125fc6a0045724ad8351edeb587718a4e7b895ef1n,
  b: 0x1867682642750531ee1e17bb1c8a4c1b750b9f361985bd77fd667dc26c741dafb1fbn,
  r: -0x1867682642750531ef11b200d17b7217df0be4a8645df296dc1c0533f6c2993910ecn
}, {
  a: -0x1c8c2607dc88cf57be0ba17b7431bea026679547n,
  b: 0x1aa1dd9fb638eea1230ae5fce2634d38b683dc44816c7441bbe9bcdbf584985043c62n,
  r: -0x1aa1dd9fb638eea1230ae5fce2634f0178e45a0d0e61f0227601741f116e9ab6bd1a9n
}, {
  a: 0x81b43399ff8222a136e63df41e6n,
  b: -0x52d7d1035f8da111a48d0d1e0310d1e9a50n,
  r: 0x52d7d103e141d4aba40f2fbf39f70fddc36n
}, {
  a: -0x8a0ea00a8fbb21bf9dc9a7d34748c46f8ac1ca50b6187f27d23e3eaf4c3f5b70n,
  b: -0xb2d945516dc2a52b73652b9b8d74af44d4a71b9194c90d542fb3ad9b993n,
  r: -0x8a0e94dcfb660ae37376f09cf48f0b983fcd7d06445f65db4168fbb41165a1ddn
}, {
  a: -0xb32929c7d5b1ea4782d993a2ba5e65e451ae7n,
  b: 0xae9a21e0d771de763dd47en,
  r: -0xb32929c7d5b1ea526c7bb1b0317c4d482ef65n
}, {
  a: 0xf79a401886619aae1f85af6b9c601235fc9a6000a140e6f0efc5can,
  b: -0x5c7541dd27c945d7be4d7e71cb7cbe9b4dn,
  r: 0xf79a401886619aae1f860be0de3d39ff42721e4e1fb2b26dae6117n
}, {
  a: -0x7bd1164836b56b310b7dff32a5e51b9d420c6ba6abf7e834f340acd1d8cf614d73dc5n,
  b: -0x9cbd60eb283720a5a9f0a0f0ddd574ffc6a784b02n,
  r: -0x7bd1164836b56b310b7dff32a5e47edfe121436f8b523e44524fcefc63cf9aa5ef2c3n
}, {
  a: 0xe1d63570b12cf3ce16f1044672136b53803f0a73122752141ad56640c1c51bd6cen,
  b: 0n,
  r: 0xe1d63570b12cf3ce16f1044672136b53803f0a73122752141ad56640c1c51bd6cen
}, {
  a: -0xabf5cn,
  b: 0x189862d09fa50587f9223963dd9f1c19e8201a19f5ceaa98n,
  r: -0x189862d09fa50587f9223963dd9f1c19e8201a19f5d969f4n
}, {
  a: -0x753cf2ba28n,
  b: -0xcb742db26cbn,
  r: 0xc4205e86ca3n
}, {
  a: -0x38abeec108877cd0e2877c84d0d44624931cf2a7475eaaa1n,
  b: -0xb62ef6bfb4f3071a954cc3315687ba931d4c47305464b3e3db1d66a6f392a16cn,
  r: 0xb62ef6bfb4f3071a5ca0d4704e003dc23ac4caab83906dbf480073ffac33f6cbn
}, {
  a: 0x9b8019e7b61fccd69de965d40902dbeb12d4365n,
  b: -0xd0bbe777b283e1c3afef0a7b909eb9dbabfab08b05b2eb3d2cd666e20e57dc6aan,
  r: 0xd0bbe777b283e1c3afef0a7b913a39f593b0d057dc50d4a300df69bdf96ab0a0fn
}, {
  a: 0xe5f39f8f5d683449a015d373dd12d812dc52cd8e5b08408a117b7a7n,
  b: 0xd82fab59c022ab90cecf1d3b17d2fc6baa3e79a4b188448d9171n,
  r: 0xe5e61c94a7cc321ee708e68209615ae3159829a6c0bd2805c8a2636n
}, {
  a: 0x296fa2d27b1899ad9661529ea1a89ca6b25f97c91c2c2c1560n,
  b: 0x6cb00c98c695f1e4596d6n,
  r: 0x296fa2d27b1899ad9661529ea1a895dbb1960b5fbd0de67e8an
}, {
  a: 0x91bf8211b7f74d2806631d4e74f901c1dccc729b2e9772e6e3f3aa4763c9e9cbn,
  b: 0xf5e6e64ed8a440n,
  r: 0x91bf8211b7f74d2806631d4e74f901c1dccc729b2e9772e6e2fdc36114f1458bn
}, {
  a: 0xc7ead92510dd75aa7161ed0f0cb8fn,
  b: -0x8c0ec8f089ebn,
  r: 0xc7ead92510dd75aa7a22d99e1557an
}, {
  a: -0xf1526n,
  b: -0xa17ad57eec06bea9c2dcf6acn,
  r: 0xa17ad57eec06bea9c2cde186n
}, {
  a: -0x3ededd75a1d68795b2e23253ea1016c91afn,
  b: -0xec98cc2fa3fd3df0b061d2b2c6c06458f9fc8b0a651d2c9138ddb129d23378n,
  r: 0xec98cc2fa3fd3df0b061d2b2c6bc766b22a26da1ebc1fe6e139f102865a1c9n
}, {
  a: -0x594n,
  b: -0x31b019bd56689c4a5d55e27n,
  r: 0x31b019bd56689c4a5d55893n
}, {
  a: 0x4941fa468ce2d1f7ef453931fa491e72db64dn,
  b: 0x71b109d053522cd6f1477n,
  r: 0x4941fa468ce2d1f77d942f61a6f6f19bea1d6n
}, {
  a: -0xeb130ed910b19e3d700fddfcd798b072af99d076cf7b9a01a0f6ean,
  b: 0xcfd21fc3a398df6441f8f4250n,
  r: -0xeb130ed910b19e3d700fddfcd798bd6fd1960ab05d71de2130393an
}, {
  a: -0x9a5n,
  b: -0x1062b89f30a097891ababb523221n,
  r: 0x1062b89f30a097891ababb52287cn
}, {
  a: -0x50710e783cb1f55c3d518317aa16a12n,
  b: -0x47e8a134a5ff43f12f2dfaa97cfe50ee8n,
  r: 0x479830262dc291fbd2f0a92665543a4d6n
}, {
  a: 0xa240c3de24f30a38a4a2e73b090157942d41d4ab4dn,
  b: -0x6216df196818a833abbea75d66d3ae97c59df92f6c1accen,
  r: 0x6216e93d74568a82dc6231a795475f27db173c03896581bn
}, {
  a: 0x90c6abe718e3e2b920a5a2930b69a06836bf4an,
  b: -0x5adac0acbfa6756c0b763fben,
  r: 0x90c6abe718e3e313fb664f52b1df0c73acff08n
}, {
  a: -0x49436d8026a04fb20db8672d78713b5f5157a91069b52fa5c09deb68e53bn,
  b: -0x90d8d2795dfdb63a95acdc3a826c9e52a0f4632363ee45cn,
  r: -0x49436d8026a046a48090d14d9d0d9204839400e99fd005967a6bb52a00dfn
}, {
  a: 0x38183eeed8d58e599n,
  b: 0x84e766527f9b0063b9947415f7fb28f88288920add1d08ec86n,
  r: -0x84e766527f9b0063b9947415f7fb28f87f070e1bef8fb006edn
}, {
  a: 0xec19n,
  b: 0x6576970f36efe320324n,
  r: -0x6576970f36efe31170bn
}, {
  a: 0xac1340b6c5153542a9b04052b36b2652a70e115b1fa70dc0821b06e3b70c03e055f4n,
  b: 0xe8e1bce52288fa3017f669b1713401ac4b4594a633bd780n,
  r: 0xac1340b6c5153542a9b031c4979cd42a176b0fdbb90bf6ad4200422f5dc1a0a47e74n
}, {
  a: 0xf8n,
  b: -0xf2d5bb8d958c43552e43807425330200bc9441n,
  r: 0xf2d5bb8d958c43552e43807425330200bc9539n
}, {
  a: -0xa30e781698d6353a3684426a81829b0682ec6bea23c9fn,
  b: 0xd100ffae73cae3eba67e49n,
  r: -0xa30e781698d6353a36844277919295edbf9aaaa48bae8n
}, {
  a: 0x756024777ee0a7ba57009825bea335323317944ed361073405a970bcdf854n,
  b: 0xad494dac6bdf576dn,
  r: 0x756024777ee0a7ba57009825bea335323317944ed360fc5f70cea9feea0e7n
}, {
  a: 0n,
  b: -0xfc58484008769fb7be47b287be04916e970d14cf8e50556064dcff22n,
  r: 0xfc58484008769fb7be47b287be04916e970d14cf8e50556064dcff22n
}, {
  a: 0x180fdb9ff570d4c5df8d79n,
  b: 0xe98d521b2674d8ece4ca0c19849b3ed49ad9f00baa6ed2699e115099f6e1c31a41b98n,
  r: -0xe98d521b2674d8ece4ca0c19849b3ed49ad9f00baa6ed2681d13969a9fd476bc48e1fn
}, {
  a: 0xc6eabd7341873d6f84624119a9fd5be61409518n,
  b: -0xd681fc34n,
  r: 0xc6eabd7341873d6f84624119a9fd5bf37c2914cn
}, {
  a: -0xc22f486e2ca46a4e6b5408c699dfca4b305c85n,
  b: -0xb364fb29e0a649135726a471e9fdf06d94377f5a72391bbe5066b84d46b03fn,
  r: 0xb364fb29e0a649135726a47127cea7ff6793150c06e512f7b686ee021653ban
}, {
  a: -0xbb331en,
  b: -0x192111abd9c4d8d19d78d835f33cdd5ff519013380a78eea5663faeb2b6fcab29n,
  r: 0x192111abd9c4d8d19d78d835f33cdd5ff519013380a78eea5663faeb2b641780bn
}, {
  a: 0xd5ac5cf0343adc3de45c35a55fn,
  b: 0x5dc265b189f8a568389bf14b66cbn,
  r: -0x5cecb95499c46a8bfab79515c16cn
}, {
  a: -0x9a7n,
  b: -0xfc4c232eebbb228c58f81b3f93762n,
  r: 0xfc4c232eebbb228c58f81b3f92dbbn
}, {
  a: 0x158ef6ed2696e00c6a14d6531a3362b122a08fd63e12371ca043b0af773n,
  b: -0x7426170fba0f1440bfc28009a43e59e57e2c0b92e7ad703a128c6940209529279a5n,
  r: 0x7426170fcf9e0b2de65960160e533038985f6e440a4e0010509ea05cc0d8d9d7118n
}, {
  a: -0xb084200e278665e0e8224feedc9f35df3f1c4023d8b2b30aan,
  b: 0xde59855a3d95561ee8dde7ee02f29b19c9750c499e2d20a8d1f7edd7c9c9403f5n,
  r: -0xde59855a3d95561f996207fc2a7900fab1975c387acc568811142dfba27bf349fn
}, {
  a: -0x6670b42197e138a19745570eea1n,
  b: -0x9b18f4dbc89a0da22e94eba8098ea0ebaf20e6d2dbe2865n,
  r: 0x9b18f4dbc89a0da22e948537556d090a767f4f8d84d39c4n
}, {
  a: -0x6183n,
  b: -0x553352512e4c85fd5b1f8f688ff30a774a9f1n,
  r: 0x553352512e4c85fd5b1f8f688ff30a774486en
}, {
  a: -0xbe747763b31ebf80en,
  b: -0x8a7e588bc81ff5293daa714a7706ec056d91f1e7461441fb9c79c4c0597a04n,
  r: 0x8a7e588bc81ff5293daa714a7706ec056d91f1e7461436145503898e6d81f6n
}, {
  a: -0xd283e56b62f607d087bn,
  b: 0xb83198d71c50175949d51b02857dn,
  r: -0xb83198d7297855b000047b7f8df8n
}, {
  a: 0xdn,
  b: 0x29a5ff8423b2f3f2052cec66757n,
  r: -0x29a5ff8423b2f3f2052cec6674an
}, {
  a: 0x61b36a97fe6d3aafbaad02bf08351beafe0f565b2b5b48509d19e003e0dn,
  b: -0x706dfaf4aa9cbdb25fc9e0145068daa1cen,
  r: 0x61b36a97fe6d3aafbaad02bf0f3bfb9a48b922365157e651e2206dadfdbn
}, {
  a: 0xffa2b1b6690c2191e674n,
  b: 0xfd3e3650703067ade67ean,
  r: -0xed440b35099fa594c8176n
}, {
  a: 0x3286a8636e7c1c0b4df00b9d0dfe14d0da6b7071d406277n,
  b: -0xd4b8eea34581f5ad5f8b516d6c1786n,
  r: 0x3286a8636e7c1c0b5b3b9a874256342bb0642588aac79fdn
}, {
  a: -0x4385a8c51544810329e272d165229b09d15798a9de9583bd21b93d930n,
  b: -0x4f5185c5304072858e9d2e6e15n,
  r: -0x4385a8c51544810329e272d165229b04dc3f3c56da8e5b6437e656b1bn
}, {
  a: 0x44e6f63780acf4250031c883ec8d7e177541cb5586a5a831n,
  b: -0x9f156f765b4n,
  r: 0x44e6f63780acf4250031c883ec8d7e177541d546dd9d0de5n
}, {
  a: 0xad2n,
  b: -0xe97c6d4186d0b13fd56129abf27082734a03e6d557b1fa50311653e22f551c1fn,
  r: 0xe97c6d4186d0b13fd56129abf27082734a03e6d557b1fa50311653e22f5526f1n
}, {
  a: 0x35dc0ede3f7bf34ea92e4c332358a8fcbeda5e00d756n,
  b: -0x8d5n,
  r: 0x35dc0ede3f7bf34ea92e4c332358a8fcbeda5e00e02bn
}, {
  a: -0x62c4e9cdde1959d1a8abfcce2ce42a384678dn,
  b: 0x5e6491d4cebe4af1c7e8bc45ea82d175b2an,
  r: -0x63234e5fb2e8181c9a73e58a72cead09bc2b7n
}, {
  a: 0xa75bc8a898b6fc348c14dc719n,
  b: -0xea065c147344ebbadfc870d7n,
  r: 0xb5fc2e69dfeb4af03a11637f0n
}, {
  a: -0x1f2c3232d705n,
  b: -0xcaf0611cfb0fad160e19ff676835163d10ece0cc2fd5697c2f8bb115n,
  r: 0xcaf0611cfb0fad160e19ff676835163d10ece0cc2fd54a4ffd58da10n
}, {
  a: 0xf3e486710a13dd7b558495fe449de23f4219e9bdcfc49a50b9c6ba1ea72n,
  b: 0x107fb2b1e078d4d5bac495bad699cn,
  r: 0xf3e486710a13dd7b558495fe449de22ec26737dd56efc495f530ff480d6n
}, {
  a: 0x5983a809381db22d97a7eea579f9d0bfcd90d4d794ea81c68b039n,
  b: -0x84d223ec35ce4496a195556a815065efe09d7c3f03dfa315822f5d7b56d48908113cen,
  r: 0x84d223ec35ce4496fb18fd73b96e181d78456ae47dd973d54fc03252ebbf0ace9c407n
}, {
  a: -0xc47431b138527acn,
  b: -0x3939f62d68b5b58c948590c7a7fda1cn,
  r: 0x3939f62d68b5b58bd0115f166fab270n
}, {
  a: 0xf9d9042c6ba0c93eaab7ef6c6ea930cd0f5c401a980af965f5b4fa61bd87234faddn,
  b: 0xd9bf02f97e9326b2b0a470992f86acec173d5f86dfffb1f93afc8aaf203972770n,
  r: 0xf8ff452972223617f8074afbd579aa20234502bb112af9b3fc79fdd70e66e9dd36dn
}, {
  a: -0xf12361n,
  b: -0x6c342c9d05cce649a194ff683696536fc8070db030fc58n,
  r: 0x6c342c9d05cce649a194ff683696536fc8070daf3fd8f7n
}, {
  a: 0xf27d68058n,
  b: 0x76d6c91846e427cc87f4693e3130e3fc9baae5824f62d83n,
  r: -0x76d6c91846e427cc87f4693e3130e3fc9baae48fd1fad2bn
}, {
  a: -0x6b69b198ce66f47084b5ed104f2d8993dc427b0994f710f5c511b180e1b25db235545dn,
  b: -0x6b6b00ccefaa1cfacf6be25120f4ca38e9fa7473ca18b7ea7867187c80ecf0e8n,
  r: -0x6b69b12d63662780da98f240e34b3872e778421f9a829d2bac59c7087a99e131486375n
}, {
  a: 0xb4d14be49c65fb0346a01133217f1033n,
  b: -0x15777ed893b7798n,
  r: 0xb4d14be49c65fb0347f78920aaba87cbn
}, {
  a: -0x28ddb2ea2b1681d8a7ecd58824db6e99083c8af0372708e3f51ffcn,
  b: 0xe9ebbb3dfn,
  r: -0x28ddb2ea2b1681d8a7ecd58824db6e99083c8af037271782b0d3dbn
}, {
  a: 0xfd48n,
  b: -0x681007f532ded8577db3f7d49088a787fdb99556cb71bf35d023c3438ba8dn,
  r: 0x681007f532ded8577db3f7d49088a787fdb99556cb71bf35d023c3439b7d5n
}, {
  a: -0xdec730b31feb2cad72a7333f123c5cdn,
  b: 0x52ae16e35cbf03130260f516fa11123696f1cb3a70264a1e7174d30bn,
  r: -0x52ae16e35cbf03130260f51707fd8541c8f07e054750bd52629898d8n
}, {
  a: -0x18a7aeb3390f73f308dc9916c9bd8726298b7962a99c035223e3n,
  b: 0x56b218bd982bac38055376d4effd8bfc14c5n,
  r: -0x18a7aeb3390f73f35f8eb1d461e9335e2edef03799998f4e38a8n
}, {
  a: 0x572f94414a8c82784db7f346c97125e47cbc0ea9b20c8f71c5e7ecef73abdn,
  b: 0xd28168e87a9a9c247244480e9c752fe25e5ec4d8a5n,
  r: 0x572f94414a8c82784daacb303ae97c3aba74ea653122c81ec7c2070326218n
}, {
  a: -0xa2n,
  b: 0n,
  r: -0xa2n
}, {
  a: -0x3af4d5f6e422826cbb12b89a84ebd646n,
  b: -0x9d6d7b4ae9fe56fafc02b094658428669721dfd5dn,
  r: 0x9d6d7b4ae64f099b8dc0886d99d2fcdceed322717n
}, {
  a: -0x3d86ee96ed459da3896a7b625ea0f6d1ed0n,
  b: 0xae56e20ea9e499c92c886c14n,
  r: -0x3d86ee96ed508311aa5519abfb33bf58ae4n
}, {
  a: -0x544bbe309eeca18e37cdb968e25fcn,
  b: 0xccdb451139971a9f4fa55ef5af3a494b22a706f1fee9d488d92fn,
  r: -0xccdb451139971a9f4fa55efaf3f62c5511711fd57bc56b16ff2bn
}, {
  a: 0x1177083ab620e7d8818b74ec08e5a7836585254d3n,
  b: 0n,
  r: 0x1177083ab620e7d8818b74ec08e5a7836585254d3n
}, {
  a: 0x28afb3df46e8fn,
  b: -0x7d23590387528fdafc549d7ea58ec28n,
  r: 0x7d23590387528fdafc7d4d3284d5ab7n
}, {
  a: 0x2683d132ed1168f3a9058f9ffn,
  b: 0xe85029a93960e094906c31394c993039839n,
  r: -0xe85029a9393a5cc35d7f1fd058f02aa9e3an
}, {
  a: 0xc65a7215f11f4c1061b7f82094fba65ff17c2671d09621590f2fc7n,
  b: 0xf6203e276fce57ed56cn,
  r: 0xc65a7215f11f4c1061b7f82094fba65ff16cc46dee1f2473905a5bn
}, {
  a: 0x14c11ebf2a2c060ffa237n,
  b: 0xcn,
  r: 0x14c11ebf2a2c060ffa22bn
}, {
  a: -0x48a754537d66ff5aa146b4aa1edbf3aaa6620091907933883395b34b8n,
  b: -0xc0d8381750c94092dcba40f5en,
  r: -0x48a754537d66ff5aa146b4aa1edbf3a9e589c87a3faff2f556db7255an
}, {
  a: 0x8f215159feb51989e8eb2fn,
  b: -0xd55d582688ce697dc80342e6f08455dacn,
  r: 0xd55d582688d75b92dda32e388922e48dbn
}, {
  a: -0x59cada5470fa06aa76907224251656a214fb47n,
  b: -0xa5a79f6dff4420f04009f9f5ad766b21fdc9b9fb284f76af04b5dn,
  r: 0xa5a79f6dff4420eaa35c54ae9dd6007a94c297b8d6ea0c8db5016n
}, {
  a: -0xa4b71bc2fee0023eeac4854d966e1afff9a9c8da4e70b6848b1f70920n,
  b: 0x8d0ac683b3efd956b8a617fe80dn,
  r: -0xa4b71bc2fee0023eeac4854d966e1b8d04704c8e3e4a0d3d31376f12dn
}, {
  a: 0xb70a28769bf021a911b8f5356a62937a5ea0a58c91e8e7f17cd9an,
  b: 0x9d80819de1b89n,
  r: 0xb70a28769bf021a911b8f5356a62937a5ea0a58bf46866539b211n
}, {
  a: 0xa2fff0e765d9411n,
  b: 0xabf96a67c086n,
  r: 0xa2f53150bf5d38bn
}, {
  a: 0x1f685184fb8de4d317a007b3c929aeb9981db842e2477e4a42133af988a75012n,
  b: 0xcacca7d16766eeecf3043a1731a03d6b93ee7cd1324472a8e30f80a93n,
  r: 0x1f6851784ec367bca13118e498e60d467e19e189a35fb1371dcc106b57af457fn
}, {
  a: 0xd38fb223d4194eafe9609831710ad6115fea76899a9e7d8d9f194n,
  b: 0x318468a1ff8defc05c4e5ff50d035dd0db68en,
  r: 0xd38fb223d4194eafb7dc2f8f717ce651039c16948d9b1fbcc3b06n
}, {
  a: -0x19474d46e0b4490190f68ee0367b1a21121dn,
  b: 0xcefn,
  r: -0x19474d46e0b4490190f68ee0367b1a211f0cn
}, {
  a: -0x67b3c4426e5249b26510b2093d0d63cn,
  b: -0xe78436a92be23a328de39dadn,
  r: -0x67b3c433f60edf1fa6ed0ee05ed388fn
}, {
  a: 0xe3288ee8b8e1ab86be951b5f8e6673838a80705d0642n,
  b: 0x93193c80d1b461d722a6752bc356a54105aa99d5fbf5e9576820544b5172f96n,
  r: -0x93193c80d1b461d7229842a2d4cb17264d3eb08445fd02f02fe7ac444ba2954n
}, {
  a: 0x34312c689afe66b9cbf72316b5bd36cd0c16cb329n,
  b: -0xe4d9bf0aa9e37fefe6e40517dn,
  r: 0x34312c689afe66bab0d0e2215fa0b6bcf2fad04a6n
}, {
  a: 0x83ded6cd69988ad95b1e7c993b74eec44372b826f5d641n,
  b: -0xe7d3ad24c99d9285b402d80aaf6bf04fb30ea35a5605d7864220362f6e460cea84367n,
  r: 0xe7d3ad24c99d9285b402d812ed595d264c9750f007eda119f96f2273a5718f59e19a8n
}, {
  a: 0x92937e323d5an,
  b: -0xf2030835b61be60c28ff54acfn,
  r: 0xf2030835b61bef3560e278829n
}, {
  a: -0x3490686b0ef99n,
  b: 0x41c77f9821839f3an,
  r: -0x41cac89ea8348ed3n
}, {
  a: 0x588d3752db3f02cf1190abcf713c9f0n,
  b: -0x3db1e1502bcn,
  r: 0x588d3752db3f02cf1190e981528ccacn
}, {
  a: -0xdf6cafbfaa90b8cfaa49d675f0370a4c366828a3df5123b57bdd3dbe87adaf858n,
  b: -0x2bdaece5b78e4368n,
  r: -0xdf6cafbfaa90b8cfaa49d675f0370a4c366828a3df5123b5791f8ef02c34cb4f0n
}, {
  a: 0x7ead129f5f0n,
  b: -0xf1adf453fb97bd3b17d6a70f13d521ec1e001b2f0e096409984425d01n,
  r: 0xf1adf453fb97bd3b17d6a70f13d521ec1e001b2f0e0964884556c52f1n
}, {
  a: 0xa7f2098279a5b36a42bd28ff0860258f778ee1n,
  b: -0xcn,
  r: 0xa7f2098279a5b36a42bd28ff0860258f778eedn
}, {
  a: -0xf781ff69ea8b8b5f9dc9ee337e4d0901cb81f71441n,
  b: 0xb74300den,
  r: -0xf781ff69ea8b8b5f9dc9ee337e4d0901cc393a151fn
}, {
  a: 0xf94fe37c94de0fc40d2eaa1e91e3bcb45150a51n,
  b: 0x9b2f40d4fcf4a8e230c3ee645f64ab0fc8466f09fd0f48b6793116dbdd1775645n,
  r: -0x9b2f40d4fcf4a8e230c3ee645e6b5b2c4bb190fa39021a0c5a9f331f28c624bf4n
}, {
  a: 0x5739b4ec7765b91bc95519dc71f3ef3b7460e5f8aeccn,
  b: 0x35n,
  r: 0x5739b4ec7765b91bc95519dc71f3ef3b7460e5f8ae97n
}, {
  a: 0xce532ca691279b849297ea6fbac61f9be6d4dbfee0be636n,
  b: -0x4636d4f35765e56232859n,
  r: 0xce532ca691279b849297ea6fbb0c5670da2c41e442f0e8fn
}, {
  a: 0xddf6d5828537a7f333n,
  b: -0x8aa3db233931ea3f1084f5dd103n,
  r: 0x8aa3db234711579738d8705c436n
}, {
  a: 0x85d526bfec1148n,
  b: 0x400fa731098cf640b13n,
  r: -0x400f9ed3b720f77f9cbn
}, {
  a: 0xf31799d42afdb38fa5f6687ca5fc6a2866732490c4cd6a7bc0dfn,
  b: 0x2ce3925975ac0681fba7d513bece4438n,
  r: 0xf31799d42afdb38fa5f63b9913a2f47c5ff128e8efb9abad7ca7n
}, {
  a: 0xfb02n,
  b: -0x314674bdf8d668346c2b95a850127e3655eee410bf837n,
  r: 0x314674bdf8d668346c2b95a850127e3655eee410cf339n
}, {
  a: -0x9cc991b9def7f345be6686cf3n,
  b: 0xd991df548ea230e6b86c294bd613a7566d0d8b7ed855cd52e2n,
  r: -0xd991df548ea230e6b86c294bdfe040720afd0ab3343c35bfd5n
}, {
  a: 0x82e96249a40f92d61af1597965cb72n,
  b: -0xc6153441d0n,
  r: 0x82e96249a40f92d61af21f8e9a0d42n
}, {
  a: -0x63b9c2da9255b0n,
  b: -0xa5d3eddaa43eda3df36750ff3b4c3d6ca9ba58d9ce0b2530n,
  r: 0xa5d3eddaa43eda3df36750ff3b4c3d6ca9569f16f378cf80n
}, {
  a: 0x51e73ab0eafccf633d4b887256a47f994c446adaf2065d84n,
  b: 0x15acaen,
  r: 0x51e73ab0eafccf633d4b887256a47f994c446adaf1f0b0d6n
}, {
  a: -0x74c66n,
  b: 0xc7cce8456fn,
  r: -0xc7ccef91d5n
}, {
  a: -0xd6ba85e7c0f3c7cac662bf0n,
  b: -0xabe4eaff9a7642c225f873e4b4c36a339b94dbed68413n,
  r: 0xabe4eaff9a7642c225f8730dfa3d8272a7cd112705823n
}, {
  a: -0xe999992a3fcb62edcn,
  b: -0x11c37bca56b8e0a915192ac40f518164c831dab2n,
  r: 0x11c37bca56b8e0a915192ab575b7eec0cb7babd6n
}, {
  a: -0x858621eb9dc294e9b9f1deed72361ab7dn,
  b: -0x53b5aaaf154fd95fbc5dc250b8266d3ee568384733d15b9c8d624ad228fecf28ebbn,
  r: 0x53b5aaaf154fd95fbc5dc250b8266d3ee4e2b22548339907a3a858f33b8c990e33en
}, {
  a: 0x1264edaab7f76b14f863b90da3a94cn,
  b: 0xc92b32922605e27a78c0a8c99ada3dd4986c471ecn,
  r: -0xc92b32922604bc2b9e152952e98ab79907920c8a0n
}, {
  a: -0xc0c59409c854f3909e60f430c8eb42967fc49729ca7b56813n,
  b: -0xd330843n,
  r: -0xc0c59409c854f3909e60f430c8eb42967fc49729c9a825fd0n
}, {
  a: -0x5f71fd1f1ea1b96d049ecea5a117fecde8f2f4336dbn,
  b: -0x60aeeb4ecba6dfef44af9c57c93c1d8n,
  r: -0x5f71fd1f1ea158be195002fec128ba1e4c9b2af7503n
}, {
  a: -0xfcf9a99c968c7db0f23a51a3d091103c29a293f4d64d01a645a46e52dd25461768a1n,
  b: 0x3216fn,
  r: -0xfcf9a99c968c7db0f23a51a3d091103c29a293f4d64d01a645a46e52dd25461a8a10n
}, {
  a: -0xf78n,
  b: -0x9f9801846e5af020043d860ac2en,
  r: 0x9f9801846e5af020043d8609cb6n
}, {
  a: -0x6d443d4fd86906ff270n,
  b: -0x777023b7c34fa5e84a115be358838n,
  r: 0x777023b7c2e261aafa38f2dc595c8n
}, {
  a: 0x6a482fcd1c3fceeeb08788f66b97616cddd5b1bf7108176442ab25c424e77887n,
  b: -0x5e05687d9738fn,
  r: 0x6a482fcd1c3fceeeb08788f66b97616cddd5b1bf7108176442b1061aacc0ec16n
}, {
  a: -0x543c5e2c01468a02e5bac1c96be018951443a3e1655b70d17a3cn,
  b: -0x221a10b293386129378086cdf2c1d55cef5610b4b5fab1977efn,
  r: -0x521abd20d81303f05242b95c8cb3fb3f454e42d619fbc5b8024dn
}, {
  a: -0x649fb5a9c5614973e5e637f1a2d73c6c8fbfd343f017748e78332875en,
  b: 0x9c60acn,
  r: -0x649fb5a9c5614973e5e637f1a2d73c6c8fbfd343f017748e783cee80an
}, {
  a: -0xfecc1a51c104ae82dc00d427e9f3ad039482an,
  b: -0xb249b067d43d7dn,
  r: -0xfecc1a51c104ae82dc00d41cc558a68650aadn
}, {
  a: 0x87ab4f3558308n,
  b: -0x9f0a39017ad53b94282a22a7a3b20ef41cbab0f748fa7c936efa40bdn,
  r: 0x9f0a39017ad53b94282a22a7a3b20ef41cbab0f74902f748624fc3c5n
}, {
  a: -0x3d92fb226a2011476187faac6eab61c38n,
  b: -0x219327c65cc2fbe9775109b632f3c9fc414e2b84f650a226fc8b7039b11cecf63d4b50n,
  r: 0x219327c65cc2fbe9775109b632f3c9fc414e27abc69e7b84fb76fa213172260b872f18n
}, {
  a: -0x3fe36cn,
  b: 0xf4fd6de3dffn,
  r: -0xf4fd71e216bn
}, {
  a: -0xf434ab9f71033a959376daef8176c49018382fc7ace5ff17ec05cn,
  b: 0xfa1dcaf9de6a2475fef3f7e9a322e1dd67c12cd87c067d3d97f6aen,
  r: -0x1096115b3d57a581f582b65989b3a4e266944afd4f6d4dd2f16b70an
}, {
  a: -0x15e25d55d42368b00625520d993901e0384644429dc4e5e65a651e206n,
  b: 0x3d054c28c12b963f9b2dn,
  r: -0x15e25d55d42368b00625520d993901e038464812f28771f913c917d33n
}, {
  a: -0xbb8928fb0f78f7dd6de53a9610287a2a31f1f7en,
  b: -0x1858a860cn,
  r: -0xbb8928fb0f78f7dd6de53a9610287a11d949972n
}, {
  a: 0x5n,
  b: -0xe6100c275de89c6261092c9fa65a2ad8bf4dfe506f883c3bfa5de6n,
  r: 0xe6100c275de89c6261092c9fa65a2ad8bf4dfe506f883c3bfa5debn
}, {
  a: 0x787a8ba954e2ce4fd1dae11e414415n,
  b: 0xba2614ea710771233d88c30ad7n,
  r: 0x7879d1833ff85d4860b7a3957e393en
}, {
  a: 0x1n,
  b: -0xb151a1792ab062d77bf9n,
  r: 0xb151a1792ab062d77bfan
}, {
  a: 0xc56058c4bbbf50d970f177f8446eec7120cee7c7c905ae3b91c6d9f199b53724edcfc7n,
  b: 0xde8633ca717f2fa6444b9d49f2c80986c942bb970n,
  r: 0xc56058c4bbbf50d970f177f8446ede88bd9240afd60b49f6d7f23ac5191cca90c21657n
}, {
  a: -0xfac705ae80ebd6a0fd20dea58931n,
  b: 0x713b902c7dd18d1aa20592c984b6n,
  r: -0x16c0295dafebd63bb9f26716f0de7n
}, {
  a: -0xbd12ce7bf7a25273b3328077c1eb8e177cff17e4286e1dad0a65n,
  b: -0xbe82n,
  r: -0xbd12ce7bf7a25273b3328077c1eb8e177cff17e4286e1dac4be3n
}, {
  a: -0xf74f81550cd2f569a0b1bb5ba1d5ab3c7c24c8n,
  b: -0xa61d370f436ef4fn,
  r: -0xf74f81550cd2f569a0b1bb5140023a48453579n
}, {
  a: 0x4f8a497560350eae8953c3125f1899853439n,
  b: -0x71aead750aefd4e91n,
  r: 0x4f8a497560350eae895addfd3669488282can
}, {
  a: -0xdfaa769c0081934d312f8b7974154033971bd77e9b17d44d2a48d8de6fb02c8an,
  b: -0xdefed349292c316b17d6723824bd2c815751062b1eben,
  r: -0xdfaa769c0081934d312eac7aa0cc170765b0bfa828dfaf8ffdc7818d69850dccn
}, {
  a: -0x96a445422f188a93aa25786n,
  b: -0x3322152a87f9d25b5e1d58bb5313cce25660ff00514dec7059ee63b95e2c9cbc45n,
  r: 0x3322152a87f9d25b5e1d58bb5313cce25660ff005144822c05cb7230b4f1fa64bfn
}, {
  a: -0x110b78028dn,
  b: 0x1cfb9858076e6087fd8a0e31c84a555c82da1d1debe5f0a41e4dn,
  r: -0x1cfb9858076e6087fd8a0e31c84a555c82da1d1debf6fc1c20dan
}, {
  a: -0xa2e3b5ad729f973c74bf69d176b6166176859c7b492n,
  b: -0xb090cbcb480aa43ee21f9d3354514b108e0e89372cb193f49b6e021n,
  r: 0xb090cbcb480a015b2c722a93bd14d651243d128116501d6efef2b8fn
}, {
  a: 0x5479b3d072454c2230ef68db46d8132edd495916ac2b1be75n,
  b: -0xa158840e90f18124c3a8faab482ed6c27146091a354bc24972e3158b45584a745247n,
  r: 0xa158840e90f18124c3ae42468535fb1733691810c3002fcaa5d0ea20d6c30d2610bcn
}, {
  a: -0x33a32b66b5e0f4682026cc5890b419ce0309878951ae79n,
  b: 0xf4ad5e0a583c219cef1745702622n,
  r: -0x33a32b66b5e0f468211b79b69b0c55ef9ff89ecec1d49bn
}, {
  a: 0xea35366e57ee2e6baafce8ea937af7ffbb483365d9a5f90611d1n,
  b: 0x4b40677f24e4n,
  r: 0xea35366e57ee2e6baafce8ea937af7ffbb4833658e659186ecedn
}, {
  a: -0xb3a4a943c82273a604b77cb16da778f3359d72e4an,
  b: 0xfe52311fe11eca8487f474af33b2622595289f1970b568b289eacbn,
  r: -0xfe52311fe11ed5bed288b1315aecc2710cf3b5f3e8449c0c611915n
}, {
  a: -0x132dff68879bn,
  b: -0xb8ddedf46535fd506fb997c0995ed5fb982699n,
  r: 0xb8ddedf46535fd506fb997c0994ba7fc2f9efen
}, {
  a: -0x1daed1ea6a60b273d8b270fa8e28b533444375e21211cd5b8cbe21d311n,
  b: 0x5464e6eca45cd81075n,
  r: -0x1daed1ea6a60b273d8b270fa8e28b533444375e26676b448311af9e386n
}, {
  a: -0x884a48da992bc355fn,
  b: 0n,
  r: -0x884a48da992bc355fn
}, {
  a: -0xff35b9a8n,
  b: -0x6d8420c5be57e0c3b699b1dfbf2d50d453fb82n,
  r: 0x6d8420c5be57e0c3b699b1dfbf2d4fd51e41dan
}, {
  a: 0xa545fdd1e19e20fa23e34f4b8a188378254966def24613n,
  b: -0x8335809ec5f8901cf14975a35a6c07b12701n,
  r: 0xa545fdd1e221567ac2a947dba709ccedc8a3d2e6a36d14n
}, {
  a: 0x87af0n,
  b: 0xd936111b2396570e26ac5cf6fa548e49f8ca8008e70n,
  r: -0xd936111b2396570e26ac5cf6fa548e49f8ca7f81380n
}, {
  a: -0xf6b4fcd70f3c7dcae85n,
  b: 0x55129458889d6n,
  r: -0xf6b4fd2c21d0d65385bn
}, {
  a: 0x166bb7ea20dbc58af71667e297e1d7da6ff437dd991f0d7de55e86a698n,
  b: 0xf36e2158e53210e7ae60e4788bn,
  r: 0x166bb7ea20dbc58af71667e297e1d7d97c861684b3ecfc9636fda22e0dn
}, {
  a: -0x4n,
  b: 0x25d589825fe2929e299b2fae34a3da04c6en,
  r: -0x25d589825fe2929e299b2fae34a3da04c72n
}, {
  a: -0x1ad56596e28cdf22aaba2c2b2b6341cn,
  b: -0x5cb7556aa7a2c9b8427233a0d4323c3f9c0506ceb6e2ee9fb136e4270e5e47dcn,
  r: 0x5cb7556aa7a2c9b8427233a0d4323c3f9a57b07548ba20ad868b41645ba813c0n
}, {
  a: -0xd85ade10d5d0e966032348ef40ce024bf6f36befd8fc608n,
  b: -0xc9eb892198bebbce722d79c3beean,
  r: -0xd85ade10d5d0e9660316aa36aeb476603a0c49183cc071en
}, {
  a: 0x499f311d32c7b1996d7983496d6bde003acb25bd89b03efn,
  b: -0xcfe9c059e819602ee03fcn,
  r: 0x499f311d32c7b1996d7983496e3bc7c094b33f1db8907ebn
}, {
  a: 0x84ac91ed839a5035f29762e2636b58e1512bd89aca0b627d88658cad2969883n,
  b: -0xbae006ff4c2357d50966cadb20fe88bc6fc61192deaa3866c5d18f0d0f2bn,
  r: 0x84b83fedf38f126b6fe7f94f111d68c9dcf2d4fbe3394d210ed1e9c61a3a7aen
}, {
  a: -0x805f0dcf924e9d2c7f9c72fed60695e6aab5a250f71044b96ce56f96n,
  b: 0x2de36d605339549ad258bc807271ab8bb026en,
  r: -0x805f0dcf924e9d2c7f9f5135ac0bc97bf462c7dcbf176bd425a07204n
}, {
  a: 0xb733ab7e98e7fb753beabd7331e8a80aec5a7n,
  b: 0xb96d28c2cf202fe8f63feed980n,
  r: 0xb733ab7e98dc64a2afbdcb703359440bfec27n
}, {
  a: 0xb60e70db4d337c3b5c2n,
  b: 0x50508720a6edd9f512257c5beea5e930110219659b221e394e675beac7fd936f4en,
  r: -0x50508720a6edd9f512257c5beea5e930110219659b221e2ded804e35f4c5cfb98cn
}, {
  a: 0xfdcafn,
  b: -0x5db87760c3cn,
  r: 0x5db8785e8ebn
}, {
  a: 0xb943af828efe671ef231en,
  b: 0x38bn,
  r: 0xb943af828efe671ef1f93n
}, {
  a: 0x4995804fd7e258ad4c0f8523cb210084af5cde934c14e0732776b9n,
  b: 0x72c58e8e65152108d3103dddb05e4bf7723abad1ba2c26366baec0c3a2d4104983ba8n,
  r: -0x72c58e8e6515210439b838e03238c122b1426895081c1deb75e0d78ee18609170c4efn
}, {
  a: -0x1dn,
  b: -0xf151642ce6cbf9a714b7aeaa6696274b6a1706da75d094caef4dn,
  r: 0xf151642ce6cbf9a714b7aeaa6696274b6a1706da75d094caef30n
}, {
  a: 0x191ffedbn,
  b: 0xff950dd90c73e3f5a9db8606ae099d36c986aff2f73f54229n,
  r: -0xff950dd90c73e3f5a9db8606ae099d36c986aff2f5ad5434en
}, {
  a: 0x7db350b614821f406c3c6cc2917994e398e99aed6f08aen,
  b: -0xf892e454ed9b44en,
  r: 0x7db350b614821f406c3c6cc2917994f32217e03c48bcfcn
}, {
  a: 0x4ea4a2f6b82e7d5ba208a9c32a60102a27d5f4a920b47f191n,
  b: -0x862079737bdfab5dd63c120373d8c58e4efe2e4100a9a25953074444a08n,
  r: 0x862079737c2e5000ccf44080cf7ace3812288e512ad1784dfc27f8c3b99n
}, {
  a: -0x4f1402918f3de122ef1ea11c1dbn,
  b: 0xa14567badf3374fd1762d8ab472d93cb6n,
  r: -0xa1456809f336068c5543fb9a65ceafe91n
}, {
  a: 0xe2a36940b89df9636ef8a00f8ba3a98dad6n,
  b: 0x2452443a8f7n,
  r: 0xe2a36940b89df9636ef8a00f675165531dfn
}, {
  a: 0xbc5322dde2a11ebd6n,
  b: -0xc727d354e3a6384feed7e8cb7n,
  r: 0xc727d3559ff95b2dd1790788dn
}, {
  a: 0x22c245c5849f411f9a769f65b69b02724cc4e1e9df7bdce11ef4ac66c6n,
  b: -0x796b546ae6f291fa1a7f942910d7f9a2d03a2f0fc2648406638929eaef679n,
  r: 0x796d808f434adbee2c793b9307336352f75efb5de1027bc4319b1935b5d3fn
}, {
  a: 0x9209d8f838eb9c50e8520447f45c947500fd762ab08307a559541205an,
  b: 0x51n,
  r: 0x9209d8f838eb9c50e8520447f45c947500fd762ab08307a5595412009n
}, {
  a: 0x45fcd635af7e37a4cc389dc25604a5bbb0925eeb1630b56263ae0defca17n,
  b: 0x4fc13469f92553f99fa5b382457260fcfb0c9n,
  r: 0x45fcd635af7e37a4cc389dbd59f15f1c1e3d1f511bd57d3e0c87fe20194en
}, {
  a: -0x149ba17b0a5efe24d83aad19dfc797e9a152e099011841a3c5dd2d7bbb8651cn,
  b: -0xc10f732681f7fe981e24ffa995a55f2f18c3acf9d175016dfdb8b34n,
  r: -0x149ba17a494f8afe5642ae81c1a298400bad8169e85494a9f4682c0dbdcd9e8n
}, {
  a: -0x899e88fbce059216245bb72ee299711f9c96a30d9f408049e965c31e28n,
  b: 0x76cc3ca7f6992dc2f1f7bdbc1a5f3bbcbf2d5c52a03a531ddae77719b65afde4n,
  r: -0x76cc3d3195222990f789d3e076166a9f589e7bef36dd60bd1b67c1031c1e1c0cn
}, {
  a: 0x53bd63bbec689a49038c44e48667f19fd29295n,
  b: -0xe9432c341dn,
  r: 0x53bd63bbec689a49038c44e48668dae2fec6b2n
}, {
  a: -0x7d710287c3e7d37en,
  b: 0xb50c481da093623d0d1996ddb36e5808df58f35681481n,
  r: -0xb50c481da093623d0d1996ddb36e5fdfef816f94fe7ffn
}, {
  a: 0x3n,
  b: -0x7d7a99bee18631458cc6dbacca017an,
  r: 0x7d7a99bee18631458cc6dbacca017dn
}, {
  a: -0xd79fa2aa44ae7d341c84787dd927a9n,
  b: -0x533b78c15a524dae9bb935994d0f00ceba42n,
  r: 0x533b77e9baafa369ed3c017cc89682f59299n
}, {
  a: -0xcc91382e72d57f3507a4676481147fa7f48566aa048bc5f29d3c0e78ecb1c1ea79f5n,
  b: -0x89df96f16ff5cc0f525133cb965ed51f62e6a2eb331105c2d8bab486e14dfbce77aen,
  r: -0x42b1a13d02dfb325b5533398eab5aa88919ec3bed17ac02fc48159f20b63c61c0247n
}, {
  a: -0x6634767a57eee53914cb9457n,
  b: 0xec7971c82938598n,
  r: -0x6634767a66b67c55975f19efn
}, {
  a: -0x1739865da6ef35n,
  b: -0x11c30f0df30997217a393f0n,
  r: 0x11c30f0df195febb9fca4bbn
}, {
  a: -0x4d9f3dd230a06f9642cb1c10862f4cn,
  b: -0xbbce784d7e2304409a690f1ca57e2c95ba74ad57d90fn,
  r: 0xbbce784d7e2303f2fb2b3cec050e9652ef589cd1a9c3n
}, {
  a: 0x9a02c23fcb97fb1458d317e47966c8f8fdcf578e5a32b79385fa0e4a573c7bn,
  b: 0xdf0a18702c0aa7241dc1fe5c705965c4da45f14eaen,
  r: 0x9a02c23fcb97fb1458d238da60f69cee56ab39cc5bd6473a2035340465edcdn
}, {
  a: -0x19ecbb099ab6d03bfda9d3f1c8c5e0e33f12d5e22f5e845c7459b336621e38a5f189bn,
  b: 0x3eb303f74760553d0308b5a667ede0d3e9e7b9c45b631dc4285432fb8a21f72an,
  r: -0x19ecbef4caf644b202fda422542047621d201480aafaca12a635f5bba54df14810fc5n
}, {
  a: 0x12b9daf29fbn,
  b: -0xdb02ccf6bc66e25341n,
  r: 0xdb02ccf7e804917d3cn
}, {
  a: 0n,
  b: -0x95f5accf6n,
  r: 0x95f5accf6n
}, {
  a: 0xf217c4bffd237b6n,
  b: 0x99a032aea6n,
  r: 0xf217bb25f9f8910n
}, {
  a: 0x505be456e3aebae088d217482c9a5fe4544002675d127c2f418088c4919a4n,
  b: 0x22414df357e597f2cd229592211834n,
  r: 0x505be456e3aebae088d217482c9a5fe2302b2331deb8fd026f572fa280170n
}, {
  a: 0x70c902889f1a57bae6aac90a312f70f99n,
  b: 0x2637b78970cfcba0e80184d9527en,
  r: 0x70c9002523a1c0ade9f0ba8a18e1dbd1bn
}, {
  a: -0x9d810115349a16ecc676665f2dffabb09617fd89fae052d75n,
  b: -0xb3e70ba45679e8adb01db8ea4e9a87db173f62834ffd8c950f3abn,
  r: 0xb3e66e235564b4139930f273e83b59db6b8ecc6b527391b4bc636n
}, {
  a: 0x804d529df76033ed8346d4c37f307224db12dfc4f0aa0fbc0dcc2553702en,
  b: -0xd903e3b63124a08b6e3205402da17fef2f29233cbbd96168d55dn,
  r: 0x804d529ed06417a3b46b754eed62776508b45fb41fd332f8c9a586bc458bn
}, {
  a: -0xc179n,
  b: 0x373742832e75b4bb1d6c23787c5da6a831cb0dbadn,
  r: -0x373742832e75b4bb1d6c23787c5da6a831cb19d26n
}, {
  a: 0x8fe9996dd77bb6834d75fb381dd7c38f99151b16b2n,
  b: -0x714a06560d90c7480c44d6346e8c26dd2e860c20c3d4aef605404f0f7052d212419en,
  r: 0x714a06560d90c7480c44d6346f1c10769c5d87d7472224f13d5e26d2ffebe72d5850n
}, {
  a: 0x28c8d0efb565b85ebd6da7d32b6f9f966bdd3382762df9e1bf96995dbf9f156dn,
  b: -0x4ca46f0f0f8f0afec64c18aa36199f209e30ef1d9en,
  r: 0x28c8d0efb565b85ebd6da81fcfdeaea5fae83248c246a417d935b9fbf08e330bn
}, {
  a: 0x93d91c03eff701eede417bbabe1649099e4eb28e6dn,
  b: 0xe24ab6a3fn,
  r: 0x93d91c03eff701eede417bbabe164909902a07242en
}, {
  a: 0xe8442f56n,
  b: 0xf666774c56ce52f6eb70efc9dafbn,
  r: -0xf666774c56ce52f6eb700785aba5n
}, {
  a: 0x9fac871f4b9caf57bbad3c92526n,
  b: -0x10f895c90ea7e067480f73b8a5018f8a27cd9851cbn,
  r: 0x10f895c90ea7e07142d7e5ad5ecc8505e2a16176f1n
}, {
  a: 0x8f8a65a54eed30e0548a400bf20a6f43f1320ecbf69c727547c83ed77a0cdce45n,
  b: 0x9d1127cc7870baeab8882f993d2832839502228553579c8a8e62557f5811db503en,
  r: -0x941881722381e7dcb33f8b987e078b8f55ef019893edd56339e5d191e0710d81f9n
}, {
  a: 0xbb2f104bc66af7aceca94b353c8b588dba8bc9n,
  b: -0xa3a01f50e3ac3716396e028e0b81fc307bfcd75cd8n,
  r: 0xa3a0da7ff3f7fd81311aef3756b738bbd48a91e8a1n
}, {
  a: -0x27b8eebf7414331c77daec78b83158b8324b7n,
  b: 0x8741efe57b4dbac4n,
  r: -0x27b8eebf7414331c77daf4ecd72fb06d0df7bn
}, {
  a: 0x2e03b107f08ed6db65n,
  b: 0xbb211da8f8a7cb13debb0ca2be3cedb3fec3203e291ced912f5e3fe4an,
  r: -0xbb211da8f8a7cb13debb0ca2be3cedb3fec3203b48e1dd122670d22e5n
}, {
  a: 0x1824f43n,
  b: 0xf4cf24514a4fefc069c4c9d7158075dd4b30f40e12c611b081042cecce544c7688a618n,
  r: -0xf4cf24514a4fefc069c4c9d7158075dd4b30f40e12c611b081042cecce544c750656d5n
}, {
  a: -0x4154cbbff760fad4f98n,
  b: 0x3c58c5fd343af8431ec1a3c8386e8n,
  r: -0x3c58c5fd347c4d0edeb904c30d680n
}, {
  a: 0xd103cc899207650c4049f95ef7925f05cfde12874466dcacb89a3fn,
  b: 0xb967e04dbc90f3caf61d67n,
  r: 0xd103cc899207650c4049f95ef7925f051676323987d5e8e1c27cd8n
}, {
  a: -0x36n,
  b: 0xcbd418d092dc4474591e7a38fa24d059cbec2cc1fc1617c7b82ea0f8e4c1n,
  r: -0xcbd418d092dc4474591e7a38fa24d059cbec2cc1fc1617c7b82ea0f8e4f7n
}, {
  a: 0x27fc1690e15ba7012dd6c6bf3ba36b5ed2c2c1dccf24b92b139a82bc27n,
  b: -0x3d67fefd7c7eefcf302dn,
  r: 0x27fc1690e15ba7012dd6c6bf3ba36b5ed2c2c21a3723b6a7928a51ec54n
}, {
  a: -0x6d726c786d0bb9n,
  b: 0x71a3f09b4027b5fef5db54n,
  r: -0x71a3f09bad9a227762e70dn
}, {
  a: -0xc15bce78133d31994bb6cn,
  b: 0x6708d8ff9d6991a7c36c2cac42e977144dcec7adcc04fe9n,
  r: -0x6708d8ff9d6991a7c36c2cac43aad2e2c5e204df6550b55n
}, {
  a: -0x47bacdf6b56280eb2b3e393163en,
  b: -0x89fbf0a64234e1ec1072c98db01cbfcb6n,
  r: 0x89fbf05e8766eb36adf1de6271e38e678n
}, {
  a: 0n,
  b: 0x42589daa57080ebdcf505584f9d77655c9d4b320d64ecf97n,
  r: -0x42589daa57080ebdcf505584f9d77655c9d4b320d64ecf97n
}, {
  a: -0x77839779e087dcb95f06fb1be032ecc6640528b1b36n,
  b: 0xbc867c4e637dde4dd2eff7d2c58c22n,
  r: -0x77839779e087e881c6cbe153be17c9f56382550a758n
}, {
  a: 0x2fn,
  b: -0x9771a1009da6a81b833931b5d73a824ffd9cdc2023a49e4f5n,
  r: 0x9771a1009da6a81b833931b5d73a824ffd9cdc2023a49e524n
}, {
  a: -0x58c3241d87dc0d8dc4d954a2e3d55b1d79f9db8b61641c8b932n,
  b: 0x41ecc7f49f48746366f8493b9ee9020a5bc12efb5f4371a95b46afcb5ea39125cbba11n,
  r: -0x41ecc7f49f48746366fdd56de0c17fcb349d7c90a971aeff0d1e4f691759a767947343n
}, {
  a: 0xe09b30cf39c4fa0748a52a4a8140287246n,
  b: -0xd4aab77df50fac03711an,
  r: 0xe09b30cf39c4fadbf35ca83f90ec2be360n
}, {
  a: 0x36f11c713fdn,
  b: -0x459da277167cn,
  r: 0x490cb43e2a79n
}, {
  a: -0x1c0ca5n,
  b: 0x85e998605e29ee2a7c1ca8a0474b8eaab7a5344n,
  r: -0x85e998605e29ee2a7c1ca8a0474b8eaab965fe9n
}, {
  a: 0x2f3d702ffb1b037cab732b4c4a5d378feaf9n,
  b: 0xdc3318855336ad6faf8362ea0b17b0df83704n,
  r: -0xd93f41825384fd37e4cc30354671dd6684c0bn
}, {
  a: 0x8e2875c90a70bbe42dab89c954n,
  b: -0x58ba5n,
  r: 0x8e2875c90a70bbe42dab8f54f9n
}, {
  a: 0x805921924da466cc8399d3605270effe25e066n,
  b: -0xa9165c4faad145041d65b21f4fden,
  r: 0x805921924e4d7d28d344a4a5568e55b0453044n
}, {
  a: 0xf41d5ca522b3adc59e8af5d449d5f31318b0daaf74b1ece55an,
  b: -0x70fb2fb7bb9f58cf1d4709525afcfc219a71d4n,
  r: 0xf41d5ca522b41ec0ce42b173a2a5105a220335ac70d387572en
}, {
  a: 0x745ab80975c968b6d4a91699f0c7a94e4130f6416762b6b45bae5b9n,
  b: 0xc1ead529fc6aff60d12fd5d3bd2536e21n,
  r: 0x745ab80975c968b6d4a915d805f27f51d6319570378ce2f73677798n
}, {
  a: 0xe0ff12c420efab3c3f53148a016c6e41bn,
  b: 0x1472ff5f2cf870ff08ca2f950597f5631ee81792ef2fc19d4272bbf16fdf4058n,
  r: -0x1472ff5f2cf870ff08ca2f950597f5550ef6eb50e0350dd94d41735159185c3dn
}, {
  a: 0x938d4e91b11dn,
  b: -0x2a216813bb6952ceb3dc3b14f51259884a7bb427145en,
  r: 0x2a216813bb6952ceb3dc3b14f5125988de0902b8c57bn
}, {
  a: -0xed456e4caa444da786527aeaae0dadca5f9b0117dd385ea691160n,
  b: -0x485faf2n,
  r: -0xed456e4caa444da786527aeaae0dadca5f9b0117dd385e5e3166en
}, {
  a: -0x5b09bcc7cfbaed5b3bb76702a0908be78f8df6fn,
  b: -0x86fa8434e5c588a4797989d6f0b60n,
  r: -0x5b09bcc7cf33f2d706d1a179fc17125db89d40fn
}, {
  a: -0x5d2633cad3ca98a9d63ba4c686711674a8f5be0e944b8deb7dc465a72755dfc38n,
  b: -0x2616fffb0ea7d3f5f0bfab57861682f973af4e3996f02n,
  r: -0x5d2633cad3ca98a9d63b7eaf867607ccd4ffcd4ee8f407d4facaf1f7d91c48d36n
}, {
  a: 0x76f594edec43c74fa8720e83651566cen,
  b: 0x7002ef40fc076e0d22f15be49ff28a59n,
  r: 0x6f2a5acf03c59428580b29ec522dc75n
}, {
  a: -0xb44995e6313c0e4ea3f9fdee490722b9908d60f8c1261632532fed89dd56ef70n,
  b: -0xcae5962c913a5d8fc63f8b9c23de9f7be83a8c5cecd4e5972daba564bd4da0c1a4n,
  r: 0xca314c96ab092181779b919e359598592ea9fefbf413bf80fb587577337049d234n
}, {
  a: -0xc642904012f3a3c21a5aada3117f88d34406f795n,
  b: 0xec6cdd5d367009e8a16490fd7efdn,
  r: -0xc642904012f4902ef7b7e4131b682a37d5047692n
}, {
  a: -0x157f81b98fd1ba716085d41856926n,
  b: -0xd03a4affd305ac81e40208a39d0c4c2588b9cf64f62e869d2e3b08en,
  r: 0xd03a4affd305ac81e40208a39cf6cca3cf29fdaa84ce00c915e4768n
}, {
  a: 0xb93fa4b0564f88dfa55b1dcc0a2n,
  b: 0x75925c51b93ac163b055817b50f041a9ead35d29c8n,
  r: -0x75925c51b93ac1581c5b3675ebf7b3af9521806926n
}, {
  a: 0xf550fca17274050c1an,
  b: 0xb87fa5bb52fd081f2d71cda9ef5537e7e9544268d8d45f918ac410b75ba5e82n,
  r: -0xb87fa5bb52fd081f2d71cda9ef5537e7e9544268d8d4503c7af9f9901b55268n
}, {
  a: 0xa2c654ced902e558f3c6a2c82b6d5497bf895a22ef7467cb38d9456c6fed30b625f08n,
  b: -0xd23n,
  r: 0xa2c654ced902e558f3c6a2c82b6d5497bf895a22ef7467cb38d9456c6fed30b626c2bn
}, {
  a: 0xff89a450967264ca591915f9a10dcda0c39fc97bf02dc7694b593b331ea921ffe93n,
  b: -0x43d41ad9e9f276535bd01fef694b7f283ccee6c6fd9c0d1a08f574582cn,
  r: 0xff89a4509aafa677f7b83d5ed6cacf9fba34816e73fab5d5bb32fc04bf3879456bfn
}, {
  a: -0xbee6adf1b29033d9c8b375ba4ec0n,
  b: -0xe8d7fn,
  r: -0xbee6adf1b29033d9c8b375abc141n
}, {
  a: -0x2b5fa28f6e6f30693b86e4947ce086fn,
  b: -0xc811526935cb1d7a21c20e8f236c805ef31cfe6ca9c655d701f97179100112aba4b1b2n,
  r: 0xc811526935cb1d7a21c20e8f236c805ef31cfe69f3cc2ce01b066ae55792c963d6a943n
}, {
  a: 0xcf8n,
  b: 0n,
  r: 0xcf8n
}, {
  a: -0x3a0e7fbc1d97c09f864c1d9ff94a30dcbee5fn,
  b: 0x3dcc9d28726c992fa55d93564daaab2ea921n,
  r: -0x3deb498ea4be8a3280a1f6d55e24db8fa9780n
}, {
  a: -0x1211a26a86c6bc571da60d685ca7fb99n,
  b: 0x7f5ee368b145d28aecbfb62fec681bdee8bbc90cn,
  r: -0x7f5ee368c35774f5738672870a0e29474563c4a5n
}, {
  a: 0xaef018ed630da61e7249129bn,
  b: 0x7a1cf9910en,
  r: 0xaef018ed630da5a4554f818dn
}, {
  a: 0x1ace7f43c03c03ceb18n,
  b: -0xd1891e9dc36afn,
  r: 0x1ace8015495aa1921c7n
}, {
  a: 0xe5ae20c1bb9c100ad83bn,
  b: -0xcd2b49ef54f02ddbe830c2522dd897f4n,
  r: 0xcd2b49ef54f1138a08f27dee3de3702fn
}, {
  a: -0x9156033d40b2f6535fa6n,
  b: -0x5bbfa3366e77ef1a0cf35ff15843a4689cn,
  r: 0x5bbfa3366e77ee88b6f022b0a54d5108f6n
}, {
  a: 0xcdba0878d036aa95c1f3e25ac7ef7504ce689n,
  b: 0xdb3c5526adc6018dn,
  r: 0xcdba0878d036aa95c1f3d4a7029d0a286e4fcn
}, {
  a: 0xa8d16a41edd122b2d4498c06c9n,
  b: -0x268820dae8c0f49b314811bacfen,
  r: 0x3115377f079e06c65e8caa7b3c7n
}, {
  a: -0x21fa5ab9acb9917da3dfd5bb28a0b7fcbb28a0c990a24de5511c73e5f53n,
  b: -0xba99f7ff79cbaa14adc40f0b3c1973e27d31f29709a43e08d882b34917fn,
  r: 0x989f9d45cd12189709e439501378bbe5c20951cd7901f02387663f6322cn
}, {
  a: -0xc0f83555e69eabe4c8b0303893d1e233651f1en,
  b: 0xe2b67d1b57a42f970960a761aab20d2dd12f737fadda69a0777f48b58138903c60n,
  r: -0xe2b67d1b57a42f970960a761aab2ce2606855a1e59bf3250a7b7dc87636bf55b7en
}, {
  a: 0x173b0d8abb0650d51c3938fb41ddn,
  b: 0x614eac555435da69b030fc36df2b180fac182e0750cf0b18e0b6312306bn,
  r: -0x614eac555435da69b030fc36df2b180e3867555ba069fdc71d22a16ee8en
}, {
  a: -0xd6aa0f0e4e424d88e8e6b823n,
  b: -0x68e7457c0085817ea360a0212an,
  r: 0x68109b6cf2373f311a77b96907n
}, {
  a: 0x198ccfb3adcb1e14aa5c305n,
  b: 0x9c54962a58141b656ca85657b8ffffe3287fe8770a32f3d8c68646fn,
  r: -0x9c54962a58141b656ca85657b8ffffe30ef318c35c67d5c41c2a16an
}, {
  a: -0xcf2n,
  b: -0xc2e7eef73e0d10c12cb9e5cbaabdcd57c75660cn,
  r: 0xc2e7eef73e0d10c12cb9e5cbaabdcd57c75591an
}, {
  a: -0xa6b9aef664df117d9788be624c2592c85eb6n,
  b: 0x279f91ca9650cd95ba1c51fe7e5bbfa9fe22f6n,
  r: -0x28464b798cb5aca737b3dabce0a7e53cc681acn
}, {
  a: 0x199080da8051bn,
  b: -0x56150882fbeb960edb0bf15c05d8b0a1055125efd0d4c97ebb3n,
  r: 0x56150882fbeb960edb0bf15c05d8b0a1055126096155a3ff0cen
}, {
  a: 0x6912ab1d7f2b1524228956fc907f93n,
  b: -0x3c77685ae7d318231a91d83ed9921ddbe627n,
  r: 0x3c7768c3fa7e35a245a6fc6162e91a6c65ban
}, {
  a: -0x8f4fa5f6ad7b9669en,
  b: -0x12d4f5210133a11c81534145n,
  r: 0x12d4f5180c3941b1a999daa7n
}, {
  a: 0xcc40504b11277b7c6548bc75318ccf53f83cbc5f0b8b3cn,
  b: 0x4916b2657ea09d02beb36c41c990e7n,
  r: 0xcc40504b11277b7c1c320a0fb2ec32513989501d41fa55n
}, {
  a: 0xcedf0e62f973c9b1f7d9afe158d86n,
  b: 0x7e70c7d1b0de08f0adb2395ac8a56dfcb52b793a34e270e6bf953544256c373c4n,
  r: -0x7e70c7d1b0de08f0adb2395ac8a56dfcb52aaa5b267f7772f5e33d6a758ade63en
}, {
  a: 0x375eb6967e6ffda10487ae9f370f3bcdb19dc21eea7cece2fn,
  b: -0xae53f0c43377b2b747056e953cea89b1eb910fd6ed3922e9346fefc9a8955n,
  r: 0xae53f0c43377ea15fd9bed053a8b8e399a3046e62906d486f68eda4695784n
}, {
  a: -0x7173879abae5ba14191028f6adbbd6e53ed00d35afbd5a0cd7fd85450d74c7ccfa00cdn,
  b: -0xb59e2a32bade0ec8e0131b7a35c8ae84e094200c29679c7e83005ce726e80f321e1n,
  r: -0x71682db817ba0c332c8227c4f6187a5a568203f3aefac3931015553f3f02594c06deecn
}, {
  a: -0x4052bab812583577d1a56a243b18e197c88ac95e7d3a713d91ffccfb85de5b0en,
  b: 0xe13f48210c95b0129daa8bb2ab93cd8988n,
  r: -0x4052bab812583577d1a56a243b18e27907d2ea6b12ea83db3c8b7fa719abe496n
}, {
  a: 0x6d4df3aef35012eca5a5ec81273bbc4114869b0900c50fn,
  b: 0xbea20d98a7efda43n,
  r: 0x6d4df3aef35012eca5a5ec81273bbb827279026110eaccn
}, {
  a: 0x658453f2f3bdc9e095f27a3000e987cecd229a2459c0620252b94e3f67309bn,
  b: 0x53ef5d031c3f3d2bd16ef80d3834f953858490481788f79e208a84d60307d39338d60cn,
  r: -0x53ef5d02b6bae938ddb12e2ca2427f23849b08794a665d79c6ca22d3b04e8553d1a571n
}, {
  a: -0x843cf6473b09ca9ada73b619981753782bb578047ab52f3761ed6d8d187an,
  b: -0xf111baa8b0735dd750dc309b9f75d5e634c09589171b5e5f74dedd433611562c522en,
  r: 0xf111baa82c36679015d26600c5021fcc9ca94210eb65e65afa29ae0bd423e89f39b4n
}, {
  a: -0xeaa810030d2a9469a69838f3f5e1n,
  b: 0xcabn,
  r: -0xeaa810030d2a9469a69838f4028cn
}, {
  a: -0x87a50930b0480e0n,
  b: -0xee22836736aa6963a4afcc379af972bacf637ab717be78290f3e92fc6555a1an,
  r: 0xee22836736aa6963a4afcc379af972bacf637ab717be7828879989cbb50d93an
}, {
  a: 0x50be94a711fn,
  b: -0x753f0c5739f1ae98d069b742087c514e4502766db53396bd94b95d91c4aad53832n,
  r: 0x753f0c5739f1ae98d069b742087c514e4502766db53396bd94b95d96d0941fa951n
}, {
  a: 0x97de09a38e1d340a5d2f8d0107f8d0054a71e17d110d2ad2accb133f2f6ce4e8n,
  b: -0x2f44da95ddab637656c0057534136n,
  r: 0x97de09a38e1d340a5d2f8d0107f8d0054a74d5caba6b0588e4307f3f86c0261en
}, {
  a: 0x9d41b9cc10fdca09a357a8582b9ed9060c65dc772476c6n,
  b: -0x8f8dc0a76cdf693b644bc0e7408ea7a5d54d0an,
  r: 0x9d41b9cca08b8ab1103711938fea99ed4cf4841cf9c3d0n
}, {
  a: 0xa79562a27df4ef3ae4e6n,
  b: -0x634n,
  r: 0xa79562a27df4ef3aeb1an
}, {
  a: 0x2762410990bf0325904d5eae9c3617fb6d18e1db81n,
  b: 0xbcce057697n,
  r: 0x2762410990bf0325904d5eae9c3617fab04adc64ean
}, {
  a: 0x123c66412e0991a80480fc8d841861e3486f68n,
  b: -0xee4279ffb54a5d9ce38dbe364457e1a446dc846cde7n,
  r: 0xee427b237bae707d7ca83e7e5420b9e5ccfab8f3d4fn
}, {
  a: -0x70194fb7d7544614a08408a1fabd718cac1c57ded0bd6287ee558c76cbn,
  b: -0xf4en,
  r: -0x70194fb7d7544614a08408a1fabd718cac1c57ded0bd6287ee558c677dn
}, {
  a: 0xad01927a765253c0fbc2e28413d61b6dedfee8546d27034c845c0b1n,
  b: 0x335fd331edf88351dd2bfe9059c91dd67bad95533f00eddf4828074d3ae083e0n,
  r: -0x335fd331e3286a2a35c6d9544a0cefae3a70339c6020ff5a01559718729ac32fn
}, {
  a: -0xd9f7a4f079d106879a102dccn,
  b: -0xdc07a0104e1e62cd99b853f90601766b9f7ff9ca6ad21a32def108be23e089f0b78ed8n,
  r: 0xdc07a0104e1e62cd99b853f90601766b9f7ff9ca6ad21958e74c184452da0256a7610cn
}, {
  a: -0x4fe50592a18830966bd4357fd0e51febadb5179243f969c8530396bfc2dba23d8cb11n,
  b: -0x31af7ebf56a082dbfa92n,
  r: -0x4fe50592a18830966bd4357fd0e51febadb5179243f969c84fe89ed3cd719a0fcd07fn
}, {
  a: 0xdfn,
  b: -0x93b2cba34f8f86350ef222c8afb5b1576df0643d4800ce1b94fafe54ed4e53f5d2500dn,
  r: 0x93b2cba34f8f86350ef222c8afb5b1576df0643d4800ce1b94fafe54ed4e53f5d250ecn
}, {
  a: 0x3b4e7a23b5babb68e75dab395e843f2a36ef671cee9511faecn,
  b: -0xc46f90c6168afc8ca74744db52c4396b97ae0409a2375b645c67cb9dn,
  r: 0xc46f9101650520426202adc2b06f72ca1bed2e40919e7852f179c689n
}, {
  a: 0xb747976277n,
  b: -0x3577b34584431d9f42c6b6197324b6c4cd5532c981d4e052010123f4640347n,
  r: 0x3577b34584431d9f42c6b6197324b6c4cd5532c981d4e0520101db3bfb65ben
}, {
  a: 0x81a26846936742b88c13073a125a80f2c3edddbf93d9703e4c636n,
  b: -0x10dfd2350b623c246c69331a7cfac8480091c3an,
  r: 0x81a26846936742c96be53c457496a55f2d20f83c8ea1b83ede270n
}, {
  a: -0x65b0d11ed7ae1f4n,
  b: 0xe7e8f667660608e871fc17102n,
  r: -0xe7e8f667666bb9b990d3c52f6n
}, {
  a: 0xd395800b4bee047d5ab094ffabe94c9090c3323c68n,
  b: 0xa25298e85772c69554b2270cb72dfcc34793n,
  r: 0xd3957f68f9551c25e7e9ffaaf9c23fd962c66ef4d5n
}, {
  a: 0xbe94612ae81bbabcn,
  b: 0x5b9299bb29c2458bn,
  r: 0x6301c76fbe597531n
}, {
  a: 0x80f90c89f16bdcc89cb2ee08e0n,
  b: -0x9b543b7894ab02adf1cb25209bcfb898a640356cn,
  r: 0x9b543b7894ab032eead7af1207ac8135592e3e4cn
}, {
  a: 0xf5c11550bc0f56fad3679e9ddde37b54e7f470512a79fcn,
  b: -0x7edbdacbaf42125ffn,
  r: 0xf5c11550bc0f56fad3679e9ddde38342a5a12b454b9ffbn
}, {
  a: 0x9528bc6d7f312e46b26n,
  b: -0x7384070f227be41f13a78d6c59720686e3dn,
  r: 0x7384070f227be41fa8d049d9d8a334cd963n
}, {
  a: -0x826796a95c21caa99fc852fa4343f84511ca9f248d9c89532fa8cf42d678d5ee7b18n,
  b: 0xc18bc4e982c725cc442c45en,
  r: -0x826796a95c21caa99fc852fa4343f84511ca9f248d9c956bebf7676f48d59a313f76n
}, {
  a: 0xcbe6fn,
  b: 0x19cb3c3337f3ebd3882403524e37342n,
  r: -0x19cb3c3337f3ebd3882403524d6b4d3n
}, {
  a: 0xfe882b9c78905b8b2eb5be0dd17764a57d5eb380n,
  b: -0x5c444af01b2dd2c02d169n,
  r: 0xfe882b9c78905b8b2ebb825280791782a96184e9n
}, {
  a: -0x6cf655299f7f60bd2ef76900303eac9b9be6bbe903dff7bed1ccn,
  b: -0x182937744cf0e49349140e07900c621f4f282c65ee9b4n,
  r: -0x6cf655281cebe9785fe91fcb9efdcc229b2099f4115d315fe818n
}, {
  a: 0x44f168bae593d619af0e032a65e24fefaedef9c82d7498f790984a6daf21af89c31d1n,
  b: 0x92819fd1fd1a494974bd5a3bf1dn,
  r: 0x44f168bae593d619af0e032a65e24fefaedef9c82ce21757be9b302465acf22f872b4n
}, {
  a: -0xadfb71362d4fed651a7b3f07d3546d1324033f394e60ebe06n,
  b: 0x7148ed2e7b80b47n,
  r: -0xadfb71362d4fed651a7b3f07d3546d13247488267cdc6c94dn
}, {
  a: -0x55c453a4957bb068b3dn,
  b: 0x29c25f30f4b80f8309c67586904acfe7fad5e61bef7c7af0cf3cc8cfee74025eb8fbn,
  r: -0x29c25f30f4b80f8309c67586904acfe7fad5e61bef7c7af0d4990e0a37cbbd654438n
}, {
  a: 0xf9b4d1353b42e695ea51fc62an,
  b: -0x7b2d1c2cn,
  r: 0xf9b4d1353b42e695f204ce256n
}, {
  a: -0xd700b11392ccd291f7445934106f44779c601e104271f5fe32038n,
  b: 0xac619d0a35a7cc63e5d759fdd4cb4e9n,
  r: -0xd700b11392ccd291f74459e0720c4ead442c81f619cbf3d2fd521n
}, {
  a: -0x883c49b95dc1325a5531355404799bd049n,
  b: 0x92fc448b0013bacac74e2225541b4b1d4078e7en,
  r: -0x92fc4d0ec4af50a6da73c77867708b64da35ec7n
}, {
  a: 0x913f1686e45032b355612n,
  b: 0x28529e0b79ccb059be82e7e721ddae04c0f8fff5c5a83f7a14n,
  r: -0x28529e0b79ccb059be82e7e721dda4f0cf9091b0c27d0a2402n
}, {
  a: -0xfn,
  b: -0x710bc955ac48f33b1edb5a2cb2e6ba8546673ad46ad076b0n,
  r: 0x710bc955ac48f33b1edb5a2cb2e6ba8546673ad46ad076a1n
}, {
  a: -0xb788b4ef8dafc32085004964a914e89fd93ff6578b38a30f3c9c887f89cf82e713n,
  b: 0x6a5cn,
  r: -0xb788b4ef8dafc32085004964a914e89fd93ff6578b38a30f3c9c887f89cf83516fn
}, {
  a: 0xea518e6e3c5a5afa1a5a5576a646e27676aef8e0919745bbe95151712058513e5aacn,
  b: 0x2734da1f8c3a693ffb3557c8dc0f4c1735cd80955fe75955f68efb66bc5dffn,
  r: 0xea518e4707803b6ddff1157b70ef199a6762e1aac416b05c01f7fb7a915cea81fcadn
}, {
  a: 0xc562c2113n,
  b: 0xa48a3114b931d2ab0cd4f0a74409bb5b953860n,
  r: -0xa48a3114b931d2ab0cd4f0a74409af0569174dn
}, {
  a: -0xa06n,
  b: 0x4a3d6326da0fe603f9d543e9c094b168f90907cf1539d20e34577f34n,
  r: -0x4a3d6326da0fe603f9d543e9c094b168f90907cf1539d20e3457893an
}, {
  a: -0x1eb72a3a21f22ffbd61n,
  b: -0xff31bbfbdb5039510dc302cb893b3168bf35n,
  r: 0xff31bbfbdb5039510bd79027e71c0e6901d4n
}, {
  a: 0xede8n,
  b: -0x39b79e7c2d407abb79f530a3dfe965f519803225e631d75e6ed06f2585bn,
  r: 0x39b79e7c2d407abb79f530a3dfe965f519803225e631d75e6ed06f34643n
}, {
  a: -0x318e4e0303d3e7ef2314e612ae1343b5dc8a46fb5afda722006dc11an,
  b: -0xd05378df5201dd26f9972759acb39e827fn,
  r: -0x318e4e0303d3e7ef2314e5425a9a6463daad2001c3d64d754ccf3e9bn
}, {
  a: 0x1880278ff8caae361n,
  b: -0xcdac22421adb306289eedcbeaen,
  r: 0xcdac22421c6332db897b87a20fn
}, {
  a: 0xc06b6afe8c1481cfdeb7e9a4019da9fn,
  b: -0xfb3961a5687n,
  r: 0xc06b6afe8c1481cfdeb8e4dd6343126n
}, {
  a: -0x7e0486215484bb220ff73856b2330fd51272eae61bf80567c8n,
  b: -0xd64ebcd574fb04124b59ddb34f40d294eedd9d42c5f59398a4626dcae73n,
  r: 0xd64ebcd56d1abbb0361192012e415f0f83ba6c4574ce64ea42a2ed746abn
}, {
  a: 0xcad268a2ec1f4d14450d116c1682bca8f7a05893e311c6cn,
  b: -0xae53e75241a8654e2d16f0cf3f8b0d8e69e913de0ba5a2891bfc521f68f66n,
  r: 0xae53e75241a86618ff7f93bb5ed821d376fa7ff48e624b80bc54e6027abd2n
}, {
  a: -0x7c3cc4f6f6e5b3b2523821f307d25a4c61a05d75909an,
  b: 0xab70a1a98ff75581229cea969f8dn,
  r: -0x7c3cc4f6f6e5b3b2fda8c39c97c9afcd843d480c3027n
}, {
  a: -0xfaf1e58cbdf71fd94030b495a0fd0505671327bae542e2409e8f78223a7n,
  b: -0xe8d59ed89f421018e8e2n,
  r: -0xfaf1e58cbdf71fd94030b495a0fd0505671327ac57e8f4b6aa6e7693ac5n
}, {
  a: -0xe3e4fbd0f63a50bb1313acb51e1a12c06f516aa3f2cfd9774197an,
  b: 0xe241f18c2f09129c823n,
  r: -0xe3e4fbd0f63a50bb1313acb51e1a12c07033ac957efee289de19dn
}, {
  a: 0x9619facdb6108abc9n,
  b: -0xbcf81c7db157aee7c1n,
  r: 0xc659bc2a8cb8b7938an
}, {
  a: -0x39d8ac4de4038dbdcc52183fa6n,
  b: -0x89e32cadc4fa639ffd6a6ec0c8d9d488986n,
  r: 0x89e32cadc15cd8db1f2a35e4ec14b3049e0n
}, {
  a: -0x313b98cd1acdf6da80c597c8c175b3240cc67728af83cfd26a0ff0ba9507n,
  b: 0x24a33ea55540n,
  r: -0x313b98cd1acdf6da80c597c8c175b3240cc67728af83cfd28eb32f5fea47n
}, {
  a: -0xff25c0858238c418becbn,
  b: -0x723ec123c64d1e9ba306d9f1f52a2aen,
  r: 0x723ec123c63d2c3f9aaeb665b39e3e3n
}, {
  a: 0x4ee76acb556b930f48ad6356da0595f024ca8fd627194en,
  b: -0x61c7e7676101fdb98515daa87675e9c6d2be9ea9532e4a199957bd3n,
  r: 0x61c7e76765f074663a6c93d96b00bffc405ef808557af316fbc9521n
}, {
  a: -0xf54f6b2dd7ecb817182d7n,
  b: 0x6439e08e6ea7a057a05555396482076fab03fffdbdb67e4613e78ddbdf198n,
  r: -0x6439e08e6ea7a057a05555396482076fab03fffeb305e973ebd445f2f746fn
}, {
  a: -0x448a69416466b2a6bef0fda4c99e06347036c33797917d565n,
  b: 0xef94d75b902f1c44f86d01ab11688aec9231d459ef9615bdfacf95df85593e6a96n,
  r: -0xef94d75b902f1c44fcb5a83f27aef616fe20e4343c2ff62141d30212fed2563ffbn
}, {
  a: 0x459f18ae6d6e90241263ad4e5ed1166ab39bae39dee89a692c73aeb9b087a8en,
  b: 0x23e39ddb83df6bdb82ac3cbb37ca03e15955e04a883e45b06fe8n,
  r: 0x459f18ae6d6c51ea34ab6f57a118eba6e7e83199a0d3050b27cb2ad55580aa6n
}, {
  a: -0x76d7188f23c5996db9cbf60fn,
  b: 0x7ee8e992940f72b457a1ade22af6ed7914b5d7140c2af350n,
  r: -0x7ee8e992940f72b457a1ade2a1ce0608387b7081c5f6e95fn
}, {
  a: 0x6e4c2d5c167deec242c45c0bfa778ac7d7b6c65c98572d00f3629n,
  b: -0x346fc869b5348a593d13e889b66e7928d5e52b3cba0n,
  r: 0x6e4c2d5c16b25e8aac79909653b49eb0616d34d5c12d122c301c9n
}, {
  a: -0x6561f296cd64872e920d69403cab38193f49a26cabca49653f0552n,
  b: 0x6be149a5367d59e9b61b675c9b3bae61aec8670f3fef7ff65309ea042d9157n,
  r: -0x6be149a59bdf4c80837fee8b2d4917a1eb739f287f392262fed433696c96a9n
}, {
  a: -0x23bf2ed5664bb249f2fbb5e47bc855b9d598be4c0d8be2ee85468bn,
  b: 0xba5ac550adc87db776f3b1cc26781n,
  r: -0x23bf2ed5664bb249f2fbb5e4876e020ee075462784fb1e0b47ae0cn
}, {
  a: 0x4caee87ee690c7fbfab36575f0fa0561c315337c907cf8630a3213300en,
  b: 0x673fd098b1ee9e6f2220ade64a5d5bc08c47n,
  r: 0x4caee87ee690c7fbfab3650eb1296cafd476c45a6fcf1218acd652a3c7n
}, {
  a: 0xd433fd881546025fbb886beb550b80134035a355306bad676dce3e9b023bbd119a40an,
  b: 0xf3a296n,
  r: 0xd433fd881546025fbb886beb550b80134035a355306bad676dce3e9b023bbd0260174n
}, {
  a: -0x78367a127bc92c5f10n,
  b: 0xe0dfb61fea19ebfdbn,
  r: -0x864475747a6acb1eebn
}, {
  a: 0x44f5aeba1n,
  b: 0xa5ba5f160ca6de03db8b257ba6ff8d3caa655cbed83b727bc9b01n,
  r: -0xa5ba5f160ca6de03db8b257ba6ff8d3caa655cbed83b2d861af60n
}, {
  a: -0x40n,
  b: 0xd900b15394534e60ca93d31ee81c67af3n,
  r: -0xd900b15394534e60ca93d31ee81c67b33n
}, {
  a: -0xed2151n,
  b: 0x3c73634e97663e5845fed348770ca1ea5adc3baf3b221fa929f7014n,
  r: -0x3c73634e97663e5845fed348770ca1ea5adc3baf3b221fa938c9165n
}, {
  a: 0xc1d4f8216eee7cbc6c3a9bce1abe5e64c7f25dffc14b5bafe668fa5f38c1402a95n,
  b: -0xcb03def07edff7b15dfc8833072b0eff0648e1dc22943an,
  r: 0xc1d4f8216eee7cbc6c3b66d1f9aedd44bfa3bbfc497e62daf56800a81a9d62becfn
}, {
  a: -0x8e199cc9d1c10589faa710b5cc7381703182e8a9837f12a54408c8c8e0a7aaf2fn,
  b: -0x39daf3200ce935n,
  r: -0x8e199cc9d1c10589faa710b5cc7381703182e8a9837f12a544052b19aea6dc5fan
}, {
  a: 0xa7240f2648e46c4b246a7e8bc4deb27a56e94169n,
  b: 0x221f28a37a5e6b86977f47d64n,
  r: 0xa7240f2648e46c490277f4541ef7fa10def4c405n
}, {
  a: 0x1c027n,
  b: 0x427b7c83e3f2889e89f5625cacn,
  r: -0x427b7c83e3f2889e89f5609c85n
}, {
  a: -0x3459d8f347b0aa08b6d283c29b3b8c871e77872302f0d07830a3754b4b5841c2eb56bfn,
  b: -0x71c7aac1d5e0be92d42n,
  r: -0x3459d8f347b0aa08b6d283c29b3b8c871e77872302f0d078309c58d09f3ae3b702297dn
}, {
  a: 0x74c84f7f9f1f7b004b8003498b0927867f5afd050034ccf6eaecn,
  b: -0x998dbe158bdde138568542436e21dc0a7be259f731en,
  r: 0x74c84f7fa8b856e1a43de15d10717baab63d1ac5a7f2f2965e0an
}, {
  a: -0x18299df5cece9488n,
  b: 0x78e976856f0e314d0ddfc3afb8453ec06n,
  r: -0x78e976856f0e314d0f625d8f15322808en
}, {
  a: -0x55a6de8157a64f87en,
  b: 0x31626e965f718e211ec815df0n,
  r: -0x31626e96b5186ca2766e6566en
}, {
  a: 0n,
  b: -0xed44efbb1n,
  r: 0xed44efbb1n
}, {
  a: -0xfe4742bcf6c487b9a9975053a27359b73a736dca5adf85n,
  b: -0x623b6faaba48d6572324dde3n,
  r: -0xfe4742bcf6c487b9a9974ff16703aefcf19d16a73601a2n
}, {
  a: -0x416bb1ffcb998bbb38f5an,
  b: 0x76eebc06223d8ff4406039cf08cdaaf6a4cc80c7baa14f6871a30cb6n,
  r: -0x76eebc06223d8ff4406039cf08cdaaf6a4d09782da9e09012d569c10n
}, {
  a: -0x3049d37ff059eedc01205f9a044db3026da2b2n,
  b: -0xc19n,
  r: -0x3049d37ff059eedc01205f9a044db3026d9699n
}, {
  a: -0x14e0ce4d407a0494195e29a535c9d9d510d5e6b2ee9f9821c66fde9032ffdf22920cean,
  b: 0x9c718fb8f792fe756cbb463dddbbc8743223bbb16f9e405812a4735n,
  r: -0x14e0ce4d407a049de0772534aef9c12bdc8a4a90ca5c1f64e8ab99a72ce3e4a3bc541fn
}, {
  a: 0x52bde03920b8fe072af45f245eab9712422e8b33afde26cc551c1257b4995ddac4n,
  b: -0xfn,
  r: 0x52bde03920b8fe072af45f245eab9712422e8b33afde26cc551c1257b4995ddad3n
}, {
  a: 0x5ef52bcc848693ce344e3n,
  b: -0x35b0236c1f9a0029edd672acdb838e8732a2a3f370f7605e70477en,
  r: 0x35b0236c1f9a0029edd672acdb838e873891f6b0393fc99b538c61n
}, {
  a: -0x887b8c26594ba9250e6bdafbn,
  b: 0x6ad31301643663861db8cc6302082d2e367115d37941e540n,
  r: -0x6ad31301643663861db8cc638a83b9548fbcbef887adc03bn
}, {
  a: 0xa0b94b5d1bf0aa3fca96573aa6e85ec6f4b772b54781f4b25aec06f5e34386fa1n,
  b: -0x94f0a7n,
  r: 0xa0b94b5d1bf0aa3fca96573aa6e85ec6f4b772b54781f4b25aec06f5e34cd6048n
}, {
  a: -0xb8c9dcb8bf2e3f319311138de6d581efd0454a57en,
  b: 0x6b6f06f4edda93ad35438155224da2c719643dd821n,
  r: -0x76fba4c079cd77a04e74928e00bafae61668927d9fn
}, {
  a: 0xb5340n,
  b: 0xd8eb6a79efe832ee0d5b843853e73f9e4087e7848n,
  r: -0xd8eb6a79efe832ee0d5b843853e73f9e408732508n
}, {
  a: -0x6a3b0ac3f75065ed00a6fd3e65477d3bd4296d8a8n,
  b: -0x65378119n,
  r: -0x6a3b0ac3f75065ed00a6fd3e65477d3bcdd5f578fn
}, {
  a: -0x9en,
  b: 0x81133831fdc5e242742bec95c4946786be6b45c3af1cb4dfa71c21f75ca3e35bn,
  r: -0x81133831fdc5e242742bec95c4946786be6b45c3af1cb4dfa71c21f75ca3e3f9n
}, {
  a: -0xbfa805ff351bfde5dn,
  b: -0xced7ae070ececba477fc5e9e6f1c4dd864cc9d544028n,
  r: 0xced7ae070ececba477fc5e9e6f10535804d94b9461cbn
}, {
  a: -0x67161dee2fa80c985de16df6438de8a9c0d02fc30da622f4e487n,
  b: -0x1f49b19a7ffebc5742fc8f8ed507137dee73f5aden,
  r: -0x67161dee2fa617fd44396e0a7e19b8e0c7e2df51d5c73bb589a9n
}, {
  a: -0x3ab1bf88146a1204n,
  b: 0x5ccf9c0c01d241012b282f5585b5f0fbd95787fa2en,
  r: -0x5ccf9c0c01d241012b282f5585f0a2bb616bf20c32n
}, {
  a: 0x1a609320fd71c3b078b2c7dfe6e1abd0803n,
  b: -0x4388840339n,
  r: 0x1a609320fd71c3b078b2c7dfeb1a3410b3cn
}, {
  a: 0x3ee8d85d01bf28387efb6589363f1894cbfbaf07030aafc2bb0af02c717an,
  b: 0x80ac872b4985bd16bf6936a60d41e1ae97bf93b621b749868a5n,
  r: 0x3ee8d85cf9b45fc5ca6309b7ca48852a6b2790ec198eb68758ef7b9408d5n
}, {
  a: -0xdc4n,
  b: -0xe66df2378cd0399ban,
  r: 0xe66df2378cd038bf6n
}, {
  a: 0xf79645603dbf168d42148308a390eb1bae7db843c1e46d026c6cee78d528e19db37n,
  b: 0x2199a4d9d459c9ac1317c8c4a3411ac9eb826ac2bfb48fa87bc9b659799989dn,
  r: 0xf79623c698e5423378686ff0dacc47da93b3ccc15721ad4ddcc472af1ecf680429an
}, {
  a: -0xb8880dn,
  b: -0x4fb0n,
  r: -0xb8385dn
}, {
  a: 0xb76n,
  b: 0xcf0febbed4469bbc85c4db2n,
  r: -0xcf0febbed4469bbc85c423cn
}, {
  a: -0x9b5n,
  b: 0xbe62d7c378fb4856b5c827e38b08n,
  r: -0xbe62d7c378fb4856b5c827e394bdn
}, {
  a: -0xe3f1f60da41ff93956ed817n,
  b: 0x65191de8d7d8af5418e0833an,
  r: -0x73583d49b21aaee7ae4f5b51n
}, {
  a: 0xb11b96c0f9fdf53553bd16256f67f69ef2b2244905a4fd51519126fa468n,
  b: 0xc06c19770941169ea9834b5c7c8ac1d5e70fe16b6an,
  r: 0xb11b96c0f9fdf53547b6548dfed3e5350819ef933ddc5133f32028e38fen
}, {
  a: -0xa8979ba4e521628a0n,
  b: -0x799656d2955250550f2bd3629dac6dc1c6e171ecfda349606047c74124aca50f19efdn,
  r: 0x799656d2955250550f2bd3629dac6dc1c6e171ecfda3496060471ea98907bfedb765dn
}, {
  a: -0xd0d0c7c5c4afbcdaf52a0853528a78eed8f0ce9d8f0dcfc00cf1883beb5907n,
  b: -0x2a240a912c4a5bdb1n,
  r: -0xd0d0c7c5c4afbcdaf52a0853528a78eed8f0ce9d8f0dcd1dcc487577459b56n
}, {
  a: 0x80c6e9b5n,
  b: 0xec89100f0dd33e9d082a833630113feb45f07b57n,
  r: -0xec89100f0dd33e9d082a833630113feac52991a2n
}, {
  a: 0xb66n,
  b: 0xb91216157c54855ce67701e5e3c8ef913n,
  r: -0xb91216157c54855ce67701e5e3c8eedadn
}, {
  a: -0xdd88159e75b8c9f21f57645776ae7124f4ede6904ed174633cdc9af744f6n,
  b: 0x6f135558d651b1967aec273165b326c101eaa73a983961418c4d63abf9f5c47b9n,
  r: -0x6f13633157ab98f2078b4926dbf89e2be8fcf68976a2662ea3939779c3a538cafn
}, {
  a: 0n,
  b: 0xbdc9e545e92b033f68ab1en,
  r: -0xbdc9e545e92b033f68ab1en
}, {
  a: 0x5c0b62f32fc376006n,
  b: -0x22bc5374d561af1e1f5e26c5e84f64b0af3652aff839402cfe32b0024b96n,
  r: 0x22bc5374d561af1e1f5e26c5e84f64b0af3652aff83f00e32d65ac39ab9cn
}, {
  a: -0xb093fadd847f790f5aec9b670557a9dn,
  b: -0x7ed43230ff02e031540bdbd8680n,
  r: -0xb0937c09524e7a0c7abb475b297f41dn
}, {
  a: 0x556n,
  b: 0xdbc873aa8de63e3119881133880cbe77n,
  r: -0xdbc873aa8de63e3119881133880cb921n
}, {
  a: 0xaeeb70dbe6856e2255967355de07997e6a41c8cfb9efcabe2fcn,
  b: -0xf976c6b740418bb5ff547041dac0864cd285n,
  r: 0xaeeb70dbe6856e31ed02dec9e22054de5f88cced65f82f8b581n
}, {
  a: 0x3a41e1b5d8ca5a715da10372d6e655fdd24f7318d0e045e6dc6n,
  b: -0xc43f24648300a8n,
  r: 0x3a41e1b5d8ca5a715da10372d6e655fdd24f7f5cc3268e16e6en
}, {
  a: -0x1450dbn,
  b: -0xd04aa6524ba0n,
  r: 0xd04aa63dfac5n
}, {
  a: 0x419a679013c9b969dd390a96637ad2aac0d9fb6cc22f74346241049e80255964n,
  b: 0x88a87f454cdf46aa1299bc243f98c6a8f3d4057c752n,
  r: 0x419a679013c9b969dd39020bdb867ddccc6f5a43266d303ad5d675613fcd9212n
}, {
  a: -0x22f1c29b90369da84a84b5247430c5e190063d08348n,
  b: -0x8b94e88eaffc6n,
  r: -0x22f1c29b90369da84a84b5247430c555fb1dae58382n
}, {
  a: -0x1c7e9d7cdf36913574fdc10435fe203n,
  b: -0x9d7ee69d1098ea4f538edf224bbff9f5b9951c4ecadc7n,
  r: 0x9d7ee69d1098ea32d4f16243152ec480bbd41818ccbc4n
}, {
  a: -0x40c06ff0b6ea465087a4530ae59e181d469c2eafc070d99332b50acn,
  b: -0x67286e438acfb3b5d9fac0bdc6cdc85b2e8cd5d9c61c8cn,
  r: -0x40c06ff0b077bf6c4ef757cf87fe6c116a2f522a0d880c359653420n
}, {
  a: -0x4157faa23a48261f06346ac7039f8b2d7def6f011f70731n,
  b: 0x275715878ac2ecc446e06055a23828328613d666d062310910af8c532c859bbn,
  r: -0x275715878ac2ecc488385af7dc804e518c48412dd401bc368e9efb544bf60ecn
}, {
  a: -0x8463950n,
  b: -0x6059b33c0300d981bcaa9d9fc397n,
  r: 0x6059b33c0300d981bcaa95598a47n
}, {
  a: 0x8b073f25820b64187564de8c0dbd7362b53744870fc0be53486df7ef3f009n,
  b: -0x3f30e16c1c947d38034bf1d1n,
  r: 0x8b073f25820b64187564de8c0dbd7362b537487a1dd7801c90417823fe1dan
}, {
  a: 0x9a38715bf991cn,
  b: -0xcc85b1f4be9cd72d6ace15a7b95a4n,
  r: 0xcc85b1f4be9cd72e05068703b2ec0n
}, {
  a: -0x49df13f93cd5f1c30cea77c9ac46714cca43de3a62e1fbf5b5b69867n,
  b: -0xbcbef88aaf74869c643e80f2a9543b35c98ccb46b90fcf4d8568347ae5an,
  r: 0xbcba5a996fe0b93d480db24b2cb976ceb4c02708d569a12dc60cd9115f3n
}, {
  a: 0x6972034869d434c42b122a92cn,
  b: -0x8698c84ca185cd880b18c32fde23ban,
  r: 0x8698cee3c1ba54254e6505e100cce6n
}, {
  a: -0x9e1d4a3127a85c57779780c9dfda5e724554910fc3964c1666484342459e7c460ad457n,
  b: 0xdd867ac786n,
  r: -0x9e1d4a3127a85c57779780c9dfda5e724554910fc3964c1666484342459f59cc859bddn
}, {
  a: 0x7ae8e786fe10579adbce994752c2503e0fn,
  b: 0x68a93a31935bbfc50c7f03576faa1d2bdd559c52b6b9667858ed3ffd2f5n,
  r: -0x68a93a31935bbfc50c7f035767fb8eb36d7496d908fc7ce3e3c11af94e6n
}, {
  a: -0xbd5d87e5cd55908439n,
  b: -0xc1ea7dcecd7d8a38daac959d23ee7435c887b8878e33355d81dd9999032f584e541n,
  r: 0xc1ea7dcecd7d8a38daac959d23ee7435c887b8878e33355d7607c11aa659ff46108n
}, {
  a: 0xb69af455e24ae22dd4fdf1322be917d95c96c152ca11d9194551db61ed41e83975n,
  b: 0xd2b896e54402b4ab1ca0bd241c68a386d4073d9353e2eb33e7f76e7058a4668cebn,
  r: -0x1c1da28f61b7d27d47a2cbf1f07f8bad77707c4089d1121aa2a5930e6b627e5376n
}, {
  a: 0xb8bae76b78c0dfca3a572n,
  b: 0xdcc1694fd6c3807cf01dff38da8d930e19feace76b9be22898f81af804f4ee86127n,
  r: -0xdcc1694fd6c3807cf01dff38da8d930e19feace76b9be16fde10af7f4415244bbb5n
}, {
  a: 0xef8cdcb6a0c4f66a6en,
  b: 0x160a0117a671ff3acb5fe722e26c0dedb08aen,
  r: -0x160a0117a671ff3acb50ee551702019e49e40n
}, {
  a: 0x3be0a57a8e00cecbfe9f3fb2e33844cf5ed22ff534951950b144bda2d1a1n,
  b: -0x29b81947d0bb6256ad03fc7ca258d4f7f76e8f890n,
  r: 0x3be0a57a8e00cecbfea1db3477b55085843d0034fc5f3ede00c4348bca31n
}, {
  a: 0x695ab14362ec43ac3d74fe356e0d0d4c050a03a2eb51c7afa1n,
  b: -0x503728an,
  r: 0x695ab14362ec43ac3d74fe356e0d0d4c050a03a2eb56cb222bn
}, {
  a: 0x1bbbca5fc52e0617n,
  b: 0x59c74a2cc4ba946d0d7b96087f56a6f0dd946e5n,
  r: -0x59c74a2cc4ba946d0d7b9606c39a00f48ab40cen
}, {
  a: 0x77cc2cae6f8632fae18525afcdd1b40b64416cf8an,
  b: -0x68166n,
  r: 0x77cc2cae6f8632fae18525afcdd1b40b6441d50f0n
}, {
  a: -0x269b04n,
  b: 0x95d9770bd70cf1b0c5a624b05e90e891a2ed31c8n,
  r: -0x95d9770bd70cf1b0c5a624b05e90e891a313ccccn
}, {
  a: 0xdb6n,
  b: 0xc57bb4b176n,
  r: -0xc57bb4a3c0n
}, {
  a: -0x23728f901c136n,
  b: 0xf7944438bfb926a12cb4a4eff05dd3197f23caacfa6ad710c55b5db7b7n,
  r: -0xf7944438bfb926a12cb4a4eff05dd3197f23caacfa6ad947ee545f78edn
}, {
  a: -0x3cc16ba0c1a85dd36e7d0923b9an,
  b: 0x753e3f89219f0ca58e485c8d56ec9c6251n,
  r: -0x753e3f8cedb5c6b1a8ce39c43ebd2e9debn
}, {
  a: -0xa9ef27a3n,
  b: 0xfb16f0ec2c532b5a9367d73d743593fb84454e4e97538d4314aa2an,
  r: -0xfb16f0ec2c532b5a9367d73d743593fb84454e4e97538ded03d1cdn
}, {
  a: -0x417595c06a4812a833db72943bc52b29d1ae5n,
  b: -0xc75c13d1d5afab57527b00958f4dac804d0n,
  r: -0x40ae39ac987262fcdc88f793a635dd7d51615n
}, {
  a: 0xdf38a787bb32b63d9fbc0938a79f943cc1cn,
  b: 0xc63a7de9626882fn,
  r: 0xdf38a787bb32b63d9fbb42fe29b631d43edn
}, {
  a: 0xcd270b1ea3e89c19734f8eb76ad36c12bb49b6d3223356d7bb93caace613f5732cn,
  b: 0xfddd7ef5a13ed40ban,
  r: 0xcd270b1ea3e89c19734f8eb76ad36c12bb49b6d3223356d7abb5f2bd8c00083272n
}, {
  a: 0x619148642a8923888495d1c12c05892ca730cc3fe07ce2n,
  b: -0xfd0a8b4ab19df8a68c3fe33a497de405d9626ec2f9a0cddedc104bdfca783n,
  r: 0xfd0a8b4ab19df8aca554697cf2101c8e22bf8ad5b9f960a94f1d0fddd2465n
}, {
  a: -0x838f208a3f3fd0387dc60ff1e5c3e565899cf5n,
  b: -0x5657cb5377510a8ce75ce4fe141990b9f6f15306bc15987n,
  r: 0x5657cb536f1818844368e7fa8c3d2fbad89514b0637bc92n
}, {
  a: -0x4895aa4a36d726f81c5bbf2c398e378774n,
  b: 0xea28fdn,
  r: -0x4895aa4a36d726f81c5bbf2c398f21b071n
}, {
  a: -0xc14b288b021deb847809126999169bec47300aac2eee1af763ed3ece8272da3558e7cn,
  b: -0xc16d7508222c7fa96a4201370d9n,
  r: -0xc14b288b021deb847809126999169bec47300aac2e2cad825bcb124ed908983421da3n
}, {
  a: 0xdadca8d8can,
  b: -0x70c40171129a453fe788b9de2c0f973b0e33d0604a7e434de0efbd9c4can,
  r: 0x70c40171129a453fe788b9de2c0f973b0e33d0604a7e434dee9d8829d94n
}, {
  a: -0xe687en,
  b: -0xa91d06a323c33eda4765dd240d957aefda3838n,
  r: 0xa91d06a323c33eda4765dd240d957aefcbcfban
}, {
  a: -0x7fccf251a6624a1d1814c38n,
  b: -0x512f99be54an,
  r: -0x7fccf251a661f8ed7e566een
}, {
  a: -0xdbc11eab14111cfd966152d9d67n,
  b: 0x8f76ef1d35017524f7b67e9c61d5619eae9fe5bf093f25d482dc299n,
  r: -0x8f76ef1d35017524f7b67e9c61d63d5fcd4af9d0263cbc35d5b6000n
}, {
  a: 0x7514b92616f665e432bf54ff8b336924db51be2d604456af1ca028d99366a57afn,
  b: 0xe4f6628f11b746de300572d45e5d9e5d32b5acen,
  r: 0x7514b92616f665e432bf54ff8a4e72c24c4006e68214513c4841cb3b3633efce1n
}, {
  a: -0x2133b678ecfb30n,
  b: 0x44en,
  r: -0x2133b678ecff7en
}, {
  a: 0xc6acf0n,
  b: 0x5ba4b8891df88202772fe390fn,
  r: -0x5ba4b8891df88202772378c1fn
}, {
  a: 0x522f16313171741dc0a3aacaa4de879225a6224abdd5n,
  b: -0xcf81cbeb6b7bde24n,
  r: 0x522f16313171741dc0a3aacaa4df5713f1918dc69bf9n
}, {
  a: -0xfd298bd6f4b60cf85e62e6d0b4f5edn,
  b: -0x1d946en,
  r: -0xfd298bd6f4b60cf85e62e6d097617fn
}, {
  a: -0xe5ae8d1832544ce80accf58a91f62ecb0c9659608n,
  b: 0x1072f3n,
  r: -0xe5ae8d1832544ce80accf58a91f62ecb0c97608fbn
}, {
  a: 0x1b2908ca1c67a1556ae63d0d7270d341696779c3f54cda5ea90abn,
  b: -0x843823e01634ca8f1de364528364309db1e4efafn,
  r: 0x1b2908ca1c67a998ed243e70bf19c51f9faca1fa3856b57cf805an
}, {
  a: 0x3a3d2040482396e01b1cd481c0e2b9cdedc437148f3f1f6f416b5f7n,
  b: -0xd181ef85312589da80e12e66ee70d3384ae29bn,
  r: 0x3a3d2040482396e02834f37a13f5126b95d249fafe262ca2c619892n
}, {
  a: 0x36902a139666e96ad4c19449b571e0487c8c4e690e053a16c508fe0252878610cn,
  b: 0x777208a54n,
  r: 0x36902a139666e96ad4c19449b571e0487c8c4e690e053a16c508fe01db157d6b8n
}, {
  a: -0x5eff5dn,
  b: -0x57dfn,
  r: -0x5ea77en
}, {
  a: -0xfd05b172n,
  b: 0xee45682ff5a66n,
  r: -0xee45780050bd8n
}, {
  a: 0x8b66eac89f4aacc88017ed523cfaae1166cb0d1b154c637ec09d2e9560n,
  b: -0x77951fa2053f9c710a963683b7d153b73f4e2ea2790ac6d49a1c08f5cn,
  r: 0x92e03cc2bf9ea68f90c150ba7877c34cdabff0053cdd0fec0a3eef24bcn
}, {
  a: -0xba3b9ba7ad19416n,
  b: -0xb2ed13f7aac16bee5ef7bae3cn,
  r: 0xb2ed13f7aa073052b74aa1a26n
}, {
  a: 0x1n,
  b: 0xf3da3ae3595571en,
  r: -0xf3da3ae3595571dn
}, {
  a: -0x90082n,
  b: -0x14116b5cf4a477dan,
  r: 0x14116b5cf49b7758n
}, {
  a: -0x80b90040627ff671e0bda15a2727332921bde3dc3a3a08510bea0c9bc90d3037bc0n,
  b: 0xb8567ac4252aa107594f85046e1b1180n,
  r: -0x80b90040627ff671e0bda15a2727332921c96943e67c5afb1c5fa194195411e8d40n
}, {
  a: 0x4392dc534a59c23ff2f45f7ea537b9a9n,
  b: 0x98b1f9349fn,
  r: 0x4392dc534a59c23ff2f45ee5f33e850an
}, {
  a: 0x458b1b96813219f68ae929ee85ffa1385573cc61n,
  b: -0x61577510998eda60f7f92ca952abfd4n,
  r: 0x458b1b968747914794821794957f3402ea9e8c35n
}, {
  a: 0xb4898362fn,
  b: 0x28fba3fd73fd4979181f773abdfn,
  r: -0x28fba3fd73fd4979176aedb75b0n
}, {
  a: -0x17396ed54b9562a9aa66a2b505den,
  b: 0x5ddcfd27e00167379279508ecdd24a2338dc6a0n,
  r: -0x5ddcfd27e002dace7fce09e4f86cf08d642cc7en
}, {
  a: 0xf729c0ff9117348ac617417f855201f30188674daf98e6dd35n,
  b: -0x88e147be228n,
  r: 0xf729c0ff9117348ac617417f855201f3018867563dad62bf5dn
}, {
  a: 0x8a4269ffb7f915909dcba36f07d32c5d77b5651n,
  b: -0x1bc49d1d7eb1bb1n,
  r: 0x8a4269ffb7f915909dcba36f2397c97af667202n
}, {
  a: -0xc8b8326d77877228e1fff37f9e834a546ebf985f15e2dn,
  b: 0xa4f855cb868084ed4f5bbdc42c0385e7f3cf295f8ea16928d84142fecd255n,
  r: -0xa4f855cb868084ee1813f031a38af810d5cf1cdf2d24b37d4700db5de3082n
}, {
  a: 0x428335e353d3fe35d4f01e2cd61e3229060cafn,
  b: 0xcf90a5006c49117c472b9n,
  r: 0x428335e353d3fe35c7f713dccf59a1114199f6n
}, {
  a: -0xba4b0b6e5b1af376632n,
  b: 0xed7e2112608ce0bcf58904717e6765an,
  r: -0xed7e2112608d9b0800f75f8c71ddc8cn
}, {
  a: 0xda54215577ebd066e01efcd88ec608fee324c0aefbf5eb47de43e2de6n,
  b: -0x417n,
  r: 0xda54215577ebd066e01efcd88ec608fee324c0aefbf5eb47de43e31fdn
}, {
  a: -0x8779b3326a0749f7636f1f9de35f9feaa9ban,
  b: 0x1561614a93790a06144441508cd97970c7ba89c7n,
  r: -0x1561e8c446ab740d5e3ba4bfac775cd067a53381n
}, {
  a: -0xa77eaae89094745bfb8c1818dd34435cb6228ef1e2edfa1b1d0ea44bn,
  b: -0xe6141fe1ccbfddc1c3f233449e58n,
  r: -0xa77eaae89094745bfb8c1818dd335d489640c232052c3628e9ca05f3n
}, {
  a: 0xed3cn,
  b: -0x4463n,
  r: 0x1319fn
}, {
  a: 0xf92c2afd1b8c008785815696fff20959ee43de9b09cf29ba5afde6f35876n,
  b: -0x5eace8fa7bcfdc629d54ac1b645aa1d1e688a7df9b450c2d89db04788245948d010n,
  r: 0x5eace90a0e928c345614b493bc700b41e5a93d7e7f82f5de26cda01e322403c2886n
}, {
  a: 0xcc05ec2e1f744529c10e4c4fac9a3d3afc6dce5fd33600dd90276e28bb95ddn,
  b: 0x150d179fb6b22e0400d8d4acb4a239d9d06db3ea99n,
  r: 0xcc05ec2e1f744529c10e374294fa8688ce69cd86fe894c3b564d9dbb07ab44n
}, {
  a: 0x37f0ac98e712bf1911eab1a37c68194e20df66a713e3096936c84a2902b1n,
  b: -0x91126e1d19704fc3cd10fbc288fb7ad29128n,
  r: 0x37f0ac98e712bf1911eab1a40d7a876b3a4fb66ae0f4052bbfc3c4fb93d9n
}, {
  a: 0x20660a5af3b1b8ea1bedd473793226c85e9bf8a041n,
  b: 0x70718dd5ac572845b6bbdbc045acf4c85f6cd6n,
  r: 0x206599e965dc0c92f3a81db79d71e11b69d399336bn
}, {
  a: -0x77c656a2e0f39bc90bf393c4e2294811763a0dd5e0729eab0c18b5df379344aa32fen,
  b: -0x5890dcc1138d14e234692d5n,
  r: -0x77c656a2e0f39bc90bf393c4e2294811763a0dd5e0729921fe4ca4a666452163a029n
}, {
  a: -0xce2917d635974381b279829f1fde1e9bdc3a6ecc862bee3457897n,
  b: -0xfe80431b6984bdn,
  r: -0xce2917d635974381b279829f1fde1e9bdc3a6ebc9e27bc7dbf3dan
}, {
  a: -0xc4f150fee3a5ef1ddc860394934dc4n,
  b: 0xe0915223679b64d29afn,
  r: -0xc4f150fee3b3f832febc7d4ae07773n
}, {
  a: 0x90ce7e2114471c92223d604719cb5f5dda181ce625f115b83767e512610424c77f71n,
  b: -0x985db0752cefccc93d4661f87372210c020750368970ea1a60a8c10b74n,
  r: 0x90ce7e2114df7a42976a5013e308a5bfd28b8f0731f31d086df155fc7b64cd888ae5n
}, {
  a: 0n,
  b: -0xd4adbd14ae69e7656e45d59e50c82be807a664ed6f4a5n,
  r: 0xd4adbd14ae69e7656e45d59e50c82be807a664ed6f4a5n
}, {
  a: -0xee5de9088bfc65457bc835746f1eac0b36940aecd7e05dd1da6n,
  b: 0xc596ba222961ebe113b456c0d1n,
  r: -0xee5de9088bfc65457bc835747b7817ad592a29aae91ba33de77n
}, {
  a: -0x161be764bc1301727b3e7729b7057aa244ce90e7n,
  b: 0x7f4n,
  r: -0x161be764bc1301727b3e7729b7057aa244ce98dbn
}, {
  a: 0x569e812b370ebb7d3749n,
  b: -0x5ed5504e4f98525972a1a8d8cecc0143eb8ffe68ae746258ca6129f21a601e4a6605n,
  r: 0x5ed5504e4f98525972a1a8d8cecc0143eb8ffe68ae74625920ffab1d516ed9c79d4en
}, {
  a: 0xa6124ef0fbda3185c96991af818e19e8d97227c41147382c5309d0aa409fb0n,
  b: 0x919106973051c402f28fcdc2981d9b887b6abn,
  r: 0xa6124ef0fbda3185c96991af7875097f666d0b83e21e3b502987f6f1b8e905n
}, {
  a: -0xdeaab01d16766234386e43973ff15fccc88799a31f423140b11b6adn,
  b: -0x2ebfd856d9c985f108acb21653fc8bafaef486d4d4aff4cdb71n,
  r: -0xdeaa815d3e1f886ab27d3aea8ddb0bd03cd7eaae986d5c90bc4db3cn
}, {
  a: 0xd29b8aen,
  b: -0xc271720fb1d94ac4576cee76d9679891b67a4d8e0c260c23cf7a2543fb7135187fn,
  r: 0xc271720fb1d94ac4576cee76d9679891b67a4d8e0c260c23cf7a2543fb7e5ed12dn
}, {
  a: -0x9a02975390c9d99d9efed45ebc9ea3b824a751b87055e17f4fa09ebbcn,
  b: 0xb57e9ecd66062cab99264bn,
  r: -0x9a02975390c9d99d9efed45ebc9ea3b824b2a9a25d2c41e21a5a31207n
}, {
  a: -0x9c756f290782bcfa26d0ee117a2cec848a001fd871f8ce02ba625fn,
  b: -0xdbd87b67c5fec4a2fee986436cd12d93d6abn,
  r: -0x9c756f290782bcfa25f515961266edbfe70136522e8bfcd5268bb4n
}, {
  a: -0x3c5f98a8f9346bb18e9d37d9dafn,
  b: 0x92ab543a4f0db9929a530d873eedd9e4bff7d6ed0b12718b8b8283d3712a7a8720n,
  r: -0x92ab543a4f0db9929a530d873eedd9e4bff7d6f0d10bfc1b1ec93eec5afdf824cfn
}, {
  a: -0xf7009b73440c364fban,
  b: 0x913e245f30edce24898c5e1e090c594359n,
  r: -0x913e245f30edce25808cf9914d188f9313n
}, {
  a: -0xfn,
  b: 0xbc465b24e22b5141f851359701484e97cc67ad42e2fa010cn,
  r: -0xbc465b24e22b5141f851359701484e97cc67ad42e2fa011bn
}, {
  a: 0xcfab6acdcf4fe84703882f579362fn,
  b: -0x729012f9f9e7eff8b8636b9690n,
  r: 0xcfb293cefeef86c60313b58e4ccbfn
}, {
  a: -0xfc7d39e5fc0ac6731432d0cd4b39c04612n,
  b: 0xe08b13bb18e7b26eb003c1d5be5830959af005c802cc0e7860a05d66b13606dn,
  r: -0xe08b13bb18e7b26eb003c1d5be58405d6e8e6588af333fbb8dad321a4d3a67fn
}, {
  a: -0xa40b0cc04a7f3b7735d5ac71d2e7c6979c9a166a47bfab35c3fd643a72n,
  b: -0x7df85d54ad693ed2f857e73dfdbe8c11b90cdc34a7e321dbfn,
  r: -0xa40b0cc0429fb5a1eaff1884a3624823bcbe2da92c2edd72797f321cb3n
}, {
  a: -0x33f564a99aa15e3595902d8n,
  b: -0x53c94481677896c85df9ee3ff83fb868a30eeacc4e0e06b3555c3ffcf8cn,
  r: 0x53c94481677896c85df9ee3ff83fb868a30eb6d6e9646c11f726aa6ccb4n
}, {
  a: 0x2c7f08766643b048a6fa796011287e47ac87a1485n,
  b: -0x15ae86d3ccf3126c82c93afc5n,
  r: 0x2c7f08766643b048bca90033de1b90b42f50dc44an
}, {
  a: -0x6230c36d1e9293cf91ad71452f94n,
  b: 0x2efb12f0052930an,
  r: -0x6230c36d1e9296bf42dc7197c29en
}, {
  a: 0x7an,
  b: 0xfd50e16f15c06dcd8033569e54307b652186a90256b1da8b46ef3061badfdn,
  r: -0xfd50e16f15c06dcd8033569e54307b652186a90256b1da8b46ef3061bad83n
}, {
  a: 0xce992090023ff4dcb69ab65fdbd5370c0a36f99676fn,
  b: 0xed952b188b50d5fn,
  r: 0xce992090023ff4dcb69ab65fdbd44976df1e6e45a10n
}, {
  a: -0xb60d1fcbfc49c5973ad0cd176c8643c96e42843f53f23d4d0d43c797fbb156568481n,
  b: 0n,
  r: -0xb60d1fcbfc49c5973ad0cd176c8643c96e42843f53f23d4d0d43c797fbb156568481n
}, {
  a: -0xc551c3be66aad16f3b1b3d30n,
  b: -0x4576bfbcbb7c47fbn,
  r: -0xc551c3be213411b27f9ef535n
}, {
  a: 0x57adc665cf52582d856b24759a1e1f04cc5n,
  b: -0x4e353en,
  r: 0x57adc665cf52582d856b24759a1e23e8203n
}, {
  a: -0xde53a007b1a787a6fbd8c61c17316n,
  b: 0x61b7949bd3dd4752f11bbc1b3f044e95ac0bf80cbf803d4aeff533a3644n,
  r: -0x61b7949bd3dd4752f11bbc1b3f044f73ffabffbe6707e446c8bb4fba95an
}, {
  a: 0x69f7e4141an,
  b: 0xf433384634179301520dfb12277ec6453a18fa9c0f8f96an,
  r: -0xf433384634179301520dfb12277ec6453a18f3fc914e550n
}, {
  a: 0x695b0e3a68c0a47689cc4c33d2355eae100cdf4e210eea0be8df05a31ddbae86bn,
  b: -0xa55n,
  r: 0x695b0e3a68c0a47689cc4c33d2355eae100cdf4e210eea0be8df05a31ddbaf2c0n
}, {
  a: 0xe2a3eb8bb7f25385a1dd8fbcbb74bc9c07b7d6b747846e9n,
  b: -0x283def44108f259fc5e7d6aa20ec7defa4434049be7c0e1e7ca2770787n,
  r: 0x283def44109d4fde7ea355cf59469bc8a00ef795883c899be816ef4e70n
}, {
  a: 0x76c391a6716d330c709d78907089f0baaf55839551n,
  b: 0x9f50fd1d944e519755fa9a17a5d0d29e9485ea3d94bab7a0dn,
  r: -0x9f50fd16281537303f2769509bf949978be6de929f627e4bcn
}, {
  a: 0x6089ea330886fe369f511db71473b2d75c68ca553b91b3ce069c205ac6ac1fb69138f6n,
  b: -0xf26442003n,
  r: 0x6089ea330886fe369f511db71473b2d75c68ca553b91b3ce069c205ac6ac2edcd558f9n
}, {
  a: 0xf2e7519094968fd3934ec39a6b7af0b4e008en,
  b: 0x728c53ae9cf10c48994e6d8fcban,
  r: 0xf2e751909424037fe4b1d28e22e1a247503d4n
}, {
  a: 0x7e5e36acced04c30207648401c678f906021fn,
  b: -0x86391143467d318b5e60d6b54859a6be2e9ade6cb213af4eddc0ee5af57258d03b2n,
  r: 0x86391143467d318b5e60d6b54859a73c8cd18b3b825fdf6f54092e775d01e9305d1n
}, {
  a: 0x684dd0418027b6ef59d00c144e88913e7ad3c37en,
  b: 0x47fb4f2465d9f5650d563419f339df5e78d19f932a97n,
  r: -0x47fae6d69598753d5666da49e72590d5e79324bf6719n
}, {
  a: 0x7360ea6559189164265780c6ae013bc90d8cd551n,
  b: 0x5b951ben,
  r: 0x7360ea6559189164265780c6ae013bc907d38393n
}, {
  a: 0xcd3544f565cn,
  b: 0x540d54aeb04455dd130f11508de0fa143c44c44503f26b0873e4f0891n,
  r: -0x540d54aeb04455dd130f11508de0fa143c44c44503f26a3b3e9ffb235n
}, {
  a: -0x806c4b5c299c735ce2ae62d4ae0ce7511164dc35ad1e05d0098417b339cfn,
  b: -0xed14ffec6dccef7724cac583n,
  r: -0x806c4b5c299c735ce2ae62d4ae0ce7511163ef20ad3198031a0cf2e8744cn
}, {
  a: 0x9332ce9ebfb493d317e94c28b5adf4ee0c7feb07c3bb067bb591634d360c80ce6b138n,
  b: 0x880008c5553b6cf0n,
  r: 0x9332ce9ebfb493d317e94c28b5adf4ee0c7feb07c3bb067bb5915acd35802b7ab4448n
}, {
  a: -0x852d77fdc4fc64d0dn,
  b: 0x9382d3a8e0d388893995ea68086500587dfd99a430d6802e9fc7e78b79ec1bda1387n,
  r: -0x9382d3a8e0d388893995ea68086500587dfd99a430d6802e9fd03a62f9c86ba06094n
}, {
  a: 0x4a67cab5f5e5b9194b074efabcee98ad24233d65728476db7c2dca678n,
  b: -0x6c4628c82a4c368790d8ff806d04dcfcd47e0ebc387n,
  r: 0x4a67cab5f5e5b985913017250925203dfd22bdd2776173affa3c869ffn
}, {
  a: -0x335611212e49163a5319c7c3375660ce3b4077n,
  b: -0xbd60cn,
  r: -0x335611212e49163a5319c7c3375660ce2f6a6bn
}, {
  a: 0x6b9bc9d2d44b4835a566b7cf1db1080d1fe282577437475a21f7fb78034657n,
  b: 0x5fc8c38837c1cea51b20d1ee5474629c5c9e190bn,
  r: 0x6b9bc9d2d44b4835a566b76f54ed7fd55e13dd3c53655905ad955f1b652d4cn
}, {
  a: 0x548n,
  b: 0xdae5dfc96af8n,
  r: -0xdae5dfc965b0n
}, {
  a: -0x7a5c1e742b97b783n,
  b: 0xd205f5a45f7d99713bb12463ec871cad2a02d0a0ea3c881b2921d533n,
  r: -0xd205f5a45f7d99713bb12463ec871cad2a02d0a16498a68f54b98cb6n
}, {
  a: -0xan,
  b: 0xdb56a130f41ec96dd26c6dn,
  r: -0xdb56a130f41ec96dd26c77n
}, {
  a: 0x69ee559602fa226bf46ddd6824e511472ea3eeb8d79fbcf2e772fn,
  b: -0xa127eaab511433ef4cdea8c4bf0a19398f87be2056b9ab8443edf186eb9bacc584aa35n,
  r: 0xa127eaab511433ef537d8e1e1f39bb604ece9bf6d907fc98b6d830727915a894b32164n
}, {
  a: 0x4a260bd243144e9e1c876048121cb8852f7f2f9c80n,
  b: 0x30893b5ac718bc8700c1684af9dadn,
  r: 0x4a260bd243144b9588d1b3d68654487918fa7ffed3n
}, {
  a: -0xa1a7e11c09be590n,
  b: 0xfn,
  r: -0xa1a7e11c09be59fn
}, {
  a: -0x1235de90b64342323c4a26c02cc057a75b88401cc0a8e18855130995e556d6n,
  b: 0n,
  r: -0x1235de90b64342323c4a26c02cc057a75b88401cc0a8e18855130995e556d6n
}, {
  a: 0x8be410e4f36d913457cc0d2d16fee0ae38b6323cc772310472cd31016n,
  b: 0xa275c5abe1en,
  r: 0x8be410e4f36d913457cc0d2d16fee0ae38b6323cc7723061fd07851f8n
}, {
  a: -0xbf8fb219f2a759b018c5dbf5f4037cd91e301ce64638861fd290623n,
  b: 0x651c2e91bca73589164c3ae82a03c6f902f40a8e99e68n,
  r: -0xbf8fb219f30c75deaa82832b7d19c914065a20ad3f3b7a2a612a48bn
}, {
  a: 0xc67a1153d251b8df6an,
  b: 0xd655f585780a3b4907b541n,
  r: -0xd6552f0b66b668f74ed5d7n
}, {
  a: 0xd3b1f394d1e3en,
  b: 0xb471bdf82e876575an,
  r: -0xb470ea463af29391cn
}, {
  a: 0x589f84639a7c02eff37bbed282fbd58e69n,
  b: 0x2c8ef4bd481273d845bba33e7ca2714aef01bf9c9b26ba8846303d8791e336539c1aan,
  r: -0x2c8ef4bd481273d845bba33e7ca2714aeefc35a454ed12c8173105cba4bb069643341n
}, {
  a: 0xc12ced4268e8a933564dc444a2f3c0e4ec0c1cd10n,
  b: 0x9657ba8b46aa28904b555b34489b8eed174efn,
  r: 0xc12c56eaae5d62892dbd78ef47bf78495d1f05821n
}, {
  a: 0x997e662b06n,
  b: 0xd8ebn,
  r: 0x997e65521bn
}, {
  a: -0xe61n,
  b: 0x2a59ddn,
  r: -0x2a683en
}, {
  a: 0xdfb6n,
  b: -0x97bfad7f5670a2624cc51ec1df9b86c4b6fa8cn,
  r: 0x97bfad7f5670a2624cc51ec1df9b86c4b7da42n
}, {
  a: -0xe7c2c2e4fcfdan,
  b: 0xa1de1c4346dab22b336en,
  r: -0xa1de1c51c306e07b0348n
}, {
  a: 0xca3e22aa2a4db9e6ae2c883c20000613ae1de5ed8bceedfb0aan,
  b: 0x26d2fd7e3977b03845a604610624b5463bf060cn,
  r: 0xca3e22aa2a4d9313b0ae4ec46fc7c06da9bcdfc8d688b20aa9en
}, {
  a: 0x108cc2ffn,
  b: -0x7e43a374ef448ded6e4d2e5e5c8dcb015cfc3d01f06e5115b11c957431n,
  r: 0x7e43a374ef448ded6e4d2e5e5c8dcb015cfc3d01f06e5115b12d223730n
}, {
  a: -0x160n,
  b: 0xf32362a9043a8baeeb2d6d2n,
  r: -0xf32362a9043a8baeeb2d832n
}, {
  a: 0x5fb12n,
  b: -0xcb56db24463a83088d64741905ef30680c2c7004fc92efcen,
  r: 0xcb56db24463a83088d64741905ef30680c2c7004fc98eae0n
}, {
  a: -0x76a391b8f8606b7364b47b04a19d16d307256f67bb6b5bbd1256cc49n,
  b: -0xa7356a46cebc751a5c1d952fb7ec661aa417f53n,
  r: -0x76a391b8f8606b735a41246034b14f8161639614bfec955b68154cf6n
}, {
  a: -0xc68fe81aba0e5a343f47209e9b29e9a56cdf3ff9242372d02a2c336646dd8aceen,
  b: -0x1a2c846eb029a39580ef0df9d8e5c6210c8a656ca41729f214aban,
  r: -0xc68fe81aba0e4007bad87074f79468b65ee567135e026645c4bf8f4f1ceb76234n
}, {
  a: 0x3afc0be7edfa0d733960d6d5b7bd42f6fd19740f59bn,
  b: 0x21n,
  r: 0x3afc0be7edfa0d733960d6d5b7bd42f6fd19740f57an
}, {
  a: 0xccffbaf3eea0b9b841755f9ae28a19d20cc7an,
  b: 0x9443eeb16395ffb0ca969c7b42700416n,
  r: 0xccffb1afafb5a37ee17a52f178c265ab0c864n
}, {
  a: -0xa6fef570d7d396b5e84022f9756a91n,
  b: -0x9a4ff82eeb8ce085bn,
  r: -0xa6fef570d7d38d10e8bd3440a76236n
}, {
  a: 0x7e825362fn,
  b: 0x26579826275dfd496410d83cfc53b7c35f56ace43f8df3f70cbdcd78d20f612b5acd0n,
  r: -0x26579826275dfd496410d83cfc53b7c35f56ace43f8df3f70cbdcd78d20ee2a9076a1n
}, {
  a: 0xcfe3ac24a84a2f7en,
  b: 0x3c69ad71cf6f613f00a81e9dc17865c7f3392173d60n,
  r: -0x3c69ad71cf6f613f00a81e9dc16b678d30ee9cd0de2n
}, {
  a: -0xc1n,
  b: 0xa4222d61f78217180dfab9f11fdbc4a048ac185e563f07b64en,
  r: -0xa4222d61f78217180dfab9f11fdbc4a048ac185e563f07b70fn
}, {
  a: 0xfb0e8460n,
  b: 0xb60b4f167a7568370f8d60734c94b7333ec064993622c5a9b5e3befacc3n,
  r: -0xb60b4f167a7568370f8d60734c94b7333ec064993622c5a9b5d40e12863n
}, {
  a: 0xb9ab9ee8ea615cd1b1b11e9f5145f678c03n,
  b: -0x492c3e9077c7a278e4b1d3f2f4d84cb8467ec52feeee92a5cc9n,
  r: 0x492c3e9077c7a2799e5d72dbdf39a989f82fe3cf4034891e8ccn
}, {
  a: 0x56b05b0a799fn,
  b: -0xd0e479c20c03d52630422831de639d159af69f47b9ef4345ded287345n,
  r: 0xd0e479c20c03d52630422831de639d159af69f47b9ef48b0e4832ece4n
}, {
  a: 0x57b6n,
  b: -0x7e3513d574e2e99328d76b81n,
  r: 0x7e3513d574e2e99328d7c337n
}, {
  a: 0xa9e974ad2572682381c96223f5e0688c7319984n,
  b: 0xd9eabe1ba56b9ce1c1ba3c6aad91c2ef301547265f2ac0ef7040ecn,
  r: -0xd9eabe1ba56b9cd72322f198566b40b7137f24e7012438283ea768n
}, {
  a: -0xb9fef4fc8d3001910c9706d9e29d6a4cec7a2ae8866fen,
  b: -0x6d08b749a4394cbddd64a7327bf114fd1577b0e2a864961368561adf3483n,
  r: 0x6d08b749a4394cb23d755769a8f0fbec4c0743447e8df144a0b36c56cd85n
}, {
  a: 0x20cc6178a4b80066cdd1af27d57abd9f9eaef73cdd75n,
  b: -0x15cdc762903604632e12702afn,
  r: 0x20cc6178a4b80066cdd30c044ba3c0ffe4e1d863e024n
}, {
  a: 0x7b11672d12a0811b3a295ce7d7cf6a548e2fdcc85b23fcf4c9n,
  b: 0xaa495fc96428c8e79a818e73eef69n,
  r: 0x7b11672d12a0811b3a29524341d2d41201a16320423cbe0560n
}, {
  a: -0xcfe5fef45dn,
  b: -0x4e175d62d910b76ede3edcaeaeea4en,
  r: 0x4e175d62d910b76ede3e0cc8aff5f1n
}, {
  a: -0xc6da3ddb722f69b6882faf644474bf50a644a32976efc02b93d0n,
  b: -0x424f1dca8a80b4537252c45a766dcfe897f7a2f0b410b4588777f58ea431395fan,
  r: 0x424f1dca8a80a7e5ce750d377fd267659d015ea9681ba9f43d455e1fa82e8022an
}, {
  a: -0x2a00c1ff58fdecdac3cdecdc9446b2db0d9a69995dc25c6ce5934f3a7c1545622n,
  b: -0xdb78efdc29cbfff7d532f1196924566d28ecd52c1dd0f9n,
  r: -0x2a00c1ff58fdecdac3c0354d9684161b0e1d166a4c2bca277ec0c06d295368529n
}, {
  a: -0x875b0d4d4f6692faede5a3b23cbfdn,
  b: 0x2bc6979d5b735a06fa99378632e28ab6ceb8cb6222n,
  r: -0x2bc6979d5b73627cab6e0c7c9c12399528f3ef2e1fn
}, {
  a: 0x2b99af633f5adc17d4dd4894951913n,
  b: -0xd2763e87c3fb14dac3f02dfa0ff17fed7f0fe9e5947d87c22a73928e2n,
  r: 0xd2763e87c3fb14dac3f02dfa0ff439887543df9355fad596b3bce41f5n
}, {
  a: 0xb5b68dcf16b289f444001en,
  b: 0x1b14463e28cec3a4e3a10fe67d995d642e3799331an,
  r: -0x1b14463e28cec3a4e3a05a2fefca46b1a4435532fcn
}, {
  a: -0x68efc6468e59a28ca22e9b97e9b4c08aa1eab9833403efc3n,
  b: -0xa7fc151e709e8bffae79ceade2401273cb5c6b5940f7fn,
  r: -0x68e546853c7298a3e233b3fafed69c897aae03bc7e6fe044n
}, {
  a: 0x3eaa06916a0561c5181db5n,
  b: 0xd3989346f7b4ebce6ce1fa05617ef117a6a5f98bc7f2c80956147afd09f40a4n,
  r: -0xd3989346f7b4ebce6ce1fa05617ef117a6a5f98bc40827a03f7424e0b8722efn
}, {
  a: -0xedab48fc599135bee17ffb513ca6952057559deb1f168554f0b00f6104a5a20bd133dn,
  b: 0x1fb69a1a9bacfd04d5234751f1992d79n,
  r: -0xedab48fc599135bee17ffb513ca6952057559fe688b82f0fc0805cb3391ac125640b6n
}, {
  a: 0x9a79bd2dbcc5d5d59ecb66a964b4dba1fb2371fd586f10cf8cn,
  b: -0x469b4b9c3be54dcbf6fcb658n,
  r: 0x9a79bd2dbcc5d5d59ecb66a964fb76ed975f574b24660d85e4n
}, {
  a: 0xcdbb9ec7a7aff4an,
  b: -0x9b65n,
  r: 0xcdbb9ec7a7b9aafn
}, {
  a: -0x321554ddd914de723009e37603547262e0e8a60d05d050151852130bf017984518n,
  b: -0x7d0ad1fd0f1ee1d9fd4cf5a60b7d9bb1c1cc890c775619a69c205ffb8f2b43f340n,
  r: 0x4af57d1f360a0367cd4312300829294ee0e3e2ff7185c99183ce4cef9f13abae28n
}, {
  a: 0x3c96e440feffa3591545dbb9453ba4dfc522cd8fn,
  b: -0xc5fba2b9840bd9ea7bd5d72c44de48778391930821aa90528312bn,
  r: 0xc5fba2b9840bddb3ea19e71c3f13d9cbe14d275bdbf88ca4afeban
}, {
  a: -0x5c9bd936ef2bac19efa039abn,
  b: 0n,
  r: -0x5c9bd936ef2bac19efa039abn
}, {
  a: 0xc9b1040deb095d88702f09239n,
  b: 0x1n,
  r: 0xc9b1040deb095d88702f09238n
}, {
  a: 0xeee8fd4951e41aa0dd644e01ed943n,
  b: -0xea51730eb1b1815d6f340bbcbbn,
  r: 0xeef7a26082cf35b8f33b4142a95fen
}, {
  a: -0x389d94b488c434d4cd23b326c0d3db3n,
  b: -0xaad6cadc5cf8e150ac091b6a0713c534e6d33a342c649512cb0f2aff76a3ef13f9e03en,
  r: 0xaad6cadc5cf8e150ac091b6a0713c534e6d33a30a28b49ca3ecbddb2a468bca7eca28bn
}, {
  a: -0x9b48a2d98db1f4392bc259c3a0n,
  b: -0x231a3f12e215e5f537a792a226n,
  r: -0x782e63c6ab9c0e43f41ac7217an
}, {
  a: 0x1e93e45111479c38d4n,
  b: -0xa50df9857f41n,
  r: 0x1e93e4f61f4121b815n
}, {
  a: -0x3db412ea3980a7b832c658237ec0n,
  b: 0xea3e41aa0e4b03882dff18511fn,
  r: -0x3e9e512be38ef2bbbaf4573bcfdfn
}, {
  a: -0x69c842005380638ebdc2f7e8101e09aa29bb1a47e954c168b4486abn,
  b: -0x77f52f2106434ad093385d1609402d0c4n,
  r: -0x69c842005380638ebdc2f7701aeee8a3e67049b4b0f7ab5f741b5e7n
}, {
  a: 0xd8c9aa5ed80faen,
  b: 0x866acb65cf81853e8863512749ean,
  r: -0x866acb65cf818465beb8f24f3a3cn
}, {
  a: -0x68e76cd7102f9b69741ec2ad27c31b23da4768fe399561a5430d76fe7cfn,
  b: 0x4c8781eafdcd553dn,
  r: -0x68e76cd7102f9b69741ec2ad27c31b23da4768fe399a2a1d61bd53d3d0cn
}, {
  a: -0xb081d9ece6b6875171bddce6963ff6dced1075ad4605e809b41152a7befn,
  b: 0x74dec912b16bed69d77c10aaf2153cedc35d3b6ed5a10c6c5cc286e306a42n,
  r: -0x758f4aec9e52a3f128edce87d8ab7ce4a04a4be482e7125466769835ae631n
}, {
  a: -0xd91548668n,
  b: -0xf6927b043fn,
  r: 0xe901267dd7n
}, {
  a: -0xe3e96850049a30f4f97a84c8dn,
  b: -0x7e1934bd1fe90d5abcf1ca7fa4bbd871741c2bf00c0724e3136n,
  r: 0x7e1934bd1fe90d5abcf1ca7fa3d7ef09241791bf170daa5e4a9n
}, {
  a: 0xb461168d03dd37an,
  b: -0x8d6de89f9294ea2a40b652c21d3032e46456d8e437d482c57124167963b90dfa757c31n,
  r: 0x8d6de89f9294ea2a40b652c21d3032e46456d8e437d482c571241684a9ca76cab34fabn
}, {
  a: -0xd7f8fee3b5d80776da3669916c18deeae09fe8363e30c65d74cd4a3e5164en,
  b: 0xad9523aed7a07593db4780886f0ae2b7b1b7d8fae6533c4cfcf7n,
  r: -0xd7f8fee3c0b159b1c7b070eaa9cd56f367909661b94c43ed23327e0321345n
}, {
  a: 0x846e4cd0e3b44f7bf80ac5df354b369d0d7d6db5703f365n,
  b: -0x2296f4379a42e30f759fn,
  r: 0x846e4cd0e3b44f7bf80ac5df354d600c50f711e3a136904n
}, {
  a: -0x724b932ea5bfed08b1e3c1aaabcab826dd0e61c00f24ffcebcac00fca0c55f4e4n,
  b: 0n,
  r: -0x724b932ea5bfed08b1e3c1aaabcab826dd0e61c00f24ffcebcac00fca0c55f4e4n
}, {
  a: 0xfa90ab23984dfe04a195fac739424b403n,
  b: -0xc7c5b4e3f119859f5b34e37b7331d6n,
  r: 0xfa9d277ee68d0f9cfb8bae1570f97e5d9n
}, {
  a: 0xbb2c6dbdb8cc0164b8dbd12079798973cfn,
  b: -0xf01ab71633c33b512aec15cc126170294fc1c98dd05b5n,
  r: 0xf01ab71633ceee1806c7a28c28acfde661c9612667984n
}, {
  a: -0xa517395cf7619541a73b17ab2c875n,
  b: 0xa66bbcbbee85983bfb1067n,
  r: -0xa51739675e1d61008f949b6add8dcn
}, {
  a: 0x91a47a548c9112dfdn,
  b: -0x688de6634300dn,
  r: 0x91a4e2e272f455e0an
}, {
  a: 0xafbcf9bb011e997b46bb5eb57191536fdf9df16b9ddf1a05fa4c9318dc4d2f08b71570n,
  b: 0xd7266675244ff0cbdf5bcb6cfe9c22a6b054f061e2edd737n,
  r: 0xafbcf9bb011e997b46bb5dde4b2ade4b8fad258c4213ad075e29ec68875ccd25c93e39n
}, {
  a: -0x9cen,
  b: 0xb153a0b4b177568662c91c725973dc5ac36a70caf338f5eef4n,
  r: -0xb153a0b4b177568662c91c725973dc5ac36a70caf338f5f8c2n
}, {
  a: -0x7f95565882f7561f9n,
  b: -0xb7ad1af89dad6e1f8042dbc1dn,
  r: 0xb7ad1af81e1817c6fd4b85a24n
}, {
  a: 0xb5e479a6130688bd161df37c321d1cb705153f7cn,
  b: -0xc507ac4n,
  r: 0xb5e479a6130688bd161df37c321d1cb71165ba40n
}, {
  a: 0x880a9a54aa31b4244ae5d06fa630n,
  b: 0x69463a7d1cbe3af0025c55c54f72a5570389fed1n,
  r: -0x69463a7d1cbdb2e56807ab939b4e5a71331a58a1n
}, {
  a: 0x2761a5386c72n,
  b: 0x4a6be7e1257eba75c21fba819df24e53eba525040416d4d9d48e8fdb009e3n,
  r: -0x4a6be7e1257eba75c21fba819df24e53eba525040416d4d9d218758779d71n
}, {
  a: -0xecd7d269b9b71bdfbn,
  b: 0xe7bcf8fda61877fdb51a4501ef0f081e664c81ae12n,
  r: -0xe7bcf8fda61877fdb51a4501fddc854501e7f36c0dn
}, {
  a: 0xcd4c5e7e0775f7fabcaf4n,
  b: -0xb7e7644e4b5b0b69n,
  r: 0xcd4c69fc7dbadcb06d65dn
}, {
  a: -0xda2713b286fca36e6dac17aa17adbcae55fc2604459886a09n,
  b: -0x9034f479b81385af20ae90n,
  r: -0xda2713b286fca36e6dac17aa17a4b95f0e60a4cbeaa67bb79n
}, {
  a: -0xf710794274ba63b5b08048c458b49d2aa1cfd79c6eb3237f1b2n,
  b: -0xcc98199b210457861167d953068a11f86100a6551n,
  r: -0xf710794273edcb9c155f446cd2a335514ec94d8a765222d8c61n
}, {
  a: 0x2b3d3279da394dc448296dcbb9ce024d47da742524fc2899a6479a208c2602748b97an,
  b: -0x872cb4ed84450d499fb38n,
  r: 0x2b3d3279da394dc448296dcbb9ce024d47da742524fc289a2d744f0e106b0fbe2b4b2n
}, {
  a: 0xb7c77f04130b81b6en,
  b: -0xc088600f28e7fcdd0cc36fb26506810f1dc06dc870ffe2cf1a6f2864c4cf7930b94n,
  r: 0xc088600f28e7fcdd0cc36fb26506810f1dc06dc870ffe2cf1b26efe3c8e284b2702n
}, {
  a: -0x3e6485b312715f79095618cb1472cdcb01b501c1757a91e587n,
  b: -0xae53e4363f69c548c81d625643f9135n,
  r: -0x3e6485b312715f79094b338cd10ed72ead287feb5016525452n
}, {
  a: 0x6e73f393fd47c54edfe005aa13c00c598014d589166f58754bb33e0an,
  b: 0xbed6db65e0b9267d6010fd5ff12e6aee0b59fd770b48c4ed1a1n,
  r: 0x6e73e7a68f9167434d782fa903ea0d469965f4d37697e7c0bf646c69n
}, {
  a: 0x1cf266f238ec3f6809ab2af8178424993n,
  b: 0x27d92a8baf07cf0f33472f280448408035b833a6f754b5c4b2d91296a9311d489f4650n,
  r: -0x27d92a8baf07cf0f33472f280448408035b831d7d0e59235eee291fbf6819bd05cfcbdn
}, {
  a: -0xfdbc23012d4fdec7ea6cb02debe2579n,
  b: 0x193d523eeec2f53b2576ec721a79d5b42dn,
  r: -0x194d2e011ed5ca3911f5933d1d5893d9a6n
}, {
  a: -0xddf3cbadb6580f549cd3e5bb7b5b088f22b8e35b0b018df220f857b9a7a49ce0n,
  b: -0x671d5aed0896e1d79162d6af17e043n,
  r: -0xddf3cbadb6580f549cd3e5bb7b5b088f2251c6001df8f7104966f4e2f88cbc9dn
}, {
  a: 0xb89eec53n,
  b: -0xf2d2cc7efc8411ff3f4566df9bd621d4206b212c4en,
  r: 0xf2d2cc7efc8411ff3f4566df9bd621d42123c018a1n
}, {
  a: -0x97dd050aea1df16dc094c15116ee016d95n,
  b: 0xecfen,
  r: -0x97dd050aea1df16dc094c15116ee025a93n
}, {
  a: 0xd2186b35n,
  b: 0xc0b0938dc1f8aad04dddf005773766763be67323363d07d59a4a181a255n,
  r: -0xc0b0938dc1f8aad04dddf005773766763be67323363d07d59a3cf693720n
}, {
  a: 0xa5f9a98dea97c80153bbda2422456962476bd1315fea21f6n,
  b: -0xb2546ce942e565b551a0f88aec1c79f61d8d46cb4e142n,
  r: 0xa604ced4b92bf657af10f433aaf42b29e6cdaa05cc9f0338n
}, {
  a: 0xfe56bed8b986a28c334e997cfb393n,
  b: 0x7da009eb051f44935c697ad556d8bdb452305fd0fd5c7b2bb015b23e2b4ca2598n,
  r: -0x7da009eb051f44935c697ad556d8bdb4522f617a3e83c1a50d897eef91cfa7205n
}, {
  a: 0n,
  b: -0x2317f726170040de9ec1945e2c5ac5ea3587n,
  r: 0x2317f726170040de9ec1945e2c5ac5ea3587n
}, {
  a: -0xd2323c3875288cn,
  b: 0xefab6a69bfdn,
  r: -0xd24136ef1bc489n
}, {
  a: -0x5034839faf793531af736n,
  b: 0x32be8a72e6e78dbd12d2ba5fda2e81d3707666b17521fc8dbd06accd44n,
  r: -0x32be8a72e6e78dbd12d2ba5fda2e81d370766bb4bd5bf7855059c7c47an
}, {
  a: 0x403ecb8e5db772f278702bbfb75eb09740686943b5fab355d8bac740a77f7n,
  b: 0x89d20710ba996fa33e58d15dbc77c6f0df734n,
  r: 0x403ecb8e5db772f278702bbf2d8ca98685cef9a077a1e1f81c43004fc80c3n
}, {
  a: -0x12891445f40f22171b52fd0185585c88n,
  b: -0xfaa433b86bbfddf100388414d57e9df547n,
  r: 0xfa91aaa425cbcecee91d3117d3f94598bfn
}, {
  a: -0x3e8d234b930883a13f40636a04ed566f4b51n,
  b: 0x8n,
  r: -0x3e8d234b930883a13f40636a04ed566f4b59n
}, {
  a: 0xa96a8c84bb9d445cc5f36210ade8465c8e4f54059036n,
  b: 0x96cb84b6b530afa62ef89c17b9548d74513bf86794f8a434f4052a38471n,
  r: -0x96cb84b6b530af9b984fd3cbff8047a7f205d75cb6743e6c0f0fe9df43bn
}, {
  a: 0xd96a65579baaa4c9bb60ade5ea7c9264a9b8f4a032da0b69dn,
  b: -0x3a2e4f704cd9da7134344d6a94a7n,
  r: 0xd96a65579baaa4c9bb60b188cf739732476007e377b0b4b44n
}, {
  a: 0x9212765d11cb0eea25d90f3527d537af3d7870b4e60ac87c89046debcn,
  b: 0xd07da0d56e62adb0n,
  r: 0x9212765d11cb0eea25d90f3527d537af3d7870b4d902ee6f321e4310cn
}, {
  a: -0x78adf4bf6a10c7ae0687fb2d9846e05bb95d73d7755d6n,
  b: 0xf0713409df4e9fd1n,
  r: -0x78adf4bf6a10c7ae0687fb2d9846ef62cc9e11cc5f5a7n
}, {
  a: 0x5213890f81b0be2dbd65d19c71b3b8e0b8044n,
  b: -0x4baad1d9ec54215cb363c581831c83f03dd476e79n,
  r: 0x4bab23ed7563a30d719182e754b8f5a3f6b52eebdn
}, {
  a: -0x8a25f82bf9e9e0334723e7c8f5791384dff64f89b92n,
  b: 0x4314fbafd82ae3537472bcdc1d8269e67e29f4b4n,
  r: -0x8a2a297bb4e762e17c5b2ef4c33aebab7e5e3229046n
}, {
  a: -0xf598db2b3e0n,
  b: -0x3bbd6ccc9f02e8af6de2871b25n,
  r: 0x3bbd6ccc9f02e8a01454d46745n
}, {
  a: -0xc6cf4246d457ab7980132ed5603b0e1242c11ba604290e1072a0f833c88cn,
  b: -0x29b2a48073f052efa2a4c28c112850817cac1614dc67547177036fb9ab43db8490cen,
  r: 0x29b2a47fad2110a8ce4d1712911521ac1c71080299a638cb72da61a938a2e350c842n
}, {
  a: 0xebb4ee7a6a9547a5n,
  b: 0xcd21ce8b8d9fc29d4a718ebfb226ea34b9d9d03a2f1909332608dn,
  r: -0xcd21ce8b8d9fc29d4a718ebfb226ea34b9d9c17ee0316289d18e8n
}, {
  a: 0x1b3512b780d357ec9f4d46a394103an,
  b: -0xf8855791af6a5fd7e9n,
  r: 0x1b3512b780d45071f6def60df3e823n
}, {
  a: 0xb4cec883fc56fcf9c23dab455017bf12135d03747575f7cea33918c6109bn,
  b: 0xcccb78ce49cc5dn,
  r: 0xb4cec883fc56fcf9c23dab455017bf12135d03747575f701d7c04a7c443en
}, {
  a: 0xe7ab9f00dc6c845n,
  b: 0xf95a0f7abn,
  r: 0xe7ab9e07825d09an
}, {
  a: -0x14314003bb38n,
  b: -0x59df69d9c9b92ef5ed83a7bdc131cb3c459d4513n,
  r: 0x59df69d9c9b92ef5ed83a7bdc131b70b059989dbn
}, {
  a: 0x44d6a62f6f540n,
  b: -0x9eb6fd724012439d90dan,
  r: 0x9eb6fd768d7ca694861an
}, {
  a: -0xbdf9bf71e5426205db92563cb41ea76f5c6725bb84f54136d8a87n,
  b: 0xe49c92801417640878c143n,
  r: -0xbdf9bf71e5426205db92563cb41ea77da6304dbcc66b81be64bcan
}, {
  a: -0x2ad2483dc43b9df3dae398d1d93b84cfe7b22f4af95cb7522d349027b60bb1c4d1ban,
  b: -0x1b2e69667058cae45f94b8ebc6ba0b1385ef9a278acan,
  r: -0x2ad2483dc43b9df3dae398d1be0d1b697759646699c7fe66667a8514301c179d46f0n
}, {
  a: 0x4ea1bc773n,
  b: -0x238e8bc0507d2ca593e58254b9845746d2739b2n,
  r: 0x238e8bc0507d2ca593e58254b98457957430125n
}, {
  a: 0x6eb43caan,
  b: 0x376fdf52n,
  r: 0x37445d58n
}, {
  a: 0x96d5ec68f9n,
  b: 0xaa3eacae0e0f65b65c9fd92872521bb974e7a64ca1d8c3571f7fcf5c6745add75b7n,
  r: -0xaa3eacae0e0f65b65c9fd92872521bb974e7a64ca1d8c3571f7fcf5c5dd84f10cben
}, {
  a: -0x35599355170dabe2787af4fa587560fc4db8a87a82999b619n,
  b: -0x5ef0fab801bb476c1004d16e10b2436a16fc11cn,
  r: -0x3559935516aebae7c07939b2ec655c2adfa7f63718829f4fdn
}, {
  a: 0xd6ff8483089870eef7an,
  b: 0x4a38b6178f5aa40n,
  r: 0xd6ff3a4a5280e19453an
}, {
  a: 0x946f9184cb219ad89a6e4a78ea3d546f21ae263466ce0b0afn,
  b: -0x35cfb5face9054b1n,
  r: 0x946f9184cb219ad89a6e4a78ea3d546f250b219413b710560n
}, {
  a: -0x9a8822n,
  b: 0xc63397520c10525ced2edee827dba6a16f2100bdn,
  r: -0xc63397520c10525ced2edee827dba6a16fbb88dfn
}, {
  a: 0x2f672c4n,
  b: 0xd35da339112e6a65e2df6983860n,
  r: -0xd35da339112e6a65e2df3a1c59cn
}, {
  a: -0x3f6065349125698c6ee147n,
  b: -0x105d3406a5b7346a7a69b6654c3da88d2d6983359c82e891d33ed1aa3aa5d58247n,
  r: 0x105d3406a5b7346a7a69b6654c3da88d2d6983359c82a9316e0a4084d11966a100n
}, {
  a: 0x201cf2f66n,
  b: -0x6c613b1444c5adbf4e8bb119a62cb5119739430f5b2bf802f2fa49b04747a1cfn,
  r: 0x6c613b1444c5adbf4e8bb119a62cb5119739430f5b2bf802f2fa49b24916d135n
}, {
  a: 0xec3202989c85568059938a9d5b123505d656764783aaafdba92135f6e9642ae5n,
  b: 0xfd0819dd91da348an,
  r: 0xec3202989c85568059938a9d5b123505d656764783aaafdaac191c195789f65bn
}, {
  a: 0xea3n,
  b: -0x9905adab3d86f7adf40a2a58cfa8cf2dn,
  r: 0x9905adab3d86f7adf40a2a58cfa8ddd0n
}, {
  a: -0xc455e34ecb1eb1ca5990514en,
  b: 0x6317247a641d86c478cad4e2ec81736744ae88b23a257bn,
  r: -0x6317247a641d86c478cad5a74264c2326360530bca76c9n
}, {
  a: 0xc41f0b7c818b1e5d08fc871d8en,
  b: 0x2950372f78e845n,
  r: 0xc41f0b7c818af50cd1cd0e3549n
}, {
  a: -0xee3cc07039c9b1fd341a60df970e01c6304e4478449636n,
  b: 0n,
  r: -0xee3cc07039c9b1fd341a60df970e01c6304e4478449636n
}, {
  a: -0xfcf6bce8eac7eb514304d8fn,
  b: 0x4a7af177650008d6d5197121e36n,
  r: -0x4a7bee6e21e8f39ec06ab426bc5n
}, {
  a: 0xf3fdc25b8f962e52b581c607ceeb6510b681ff934ad74b9c6499cc7aa59136023a1bn,
  b: 0x800fab5b0f6cb9da8cc67n,
  r: 0xf3fdc25b8f962e52b581c607ceeb6510b681ff934ad74b94639f16c9aec598596db4n
}, {
  a: -0xb488f9476cb3cd944ab66c227a8493e0f6b13eedf242n,
  b: -0xb518bed38e385c9ae9ca956d5fd382f2afca890d1b5c2068332efab5ef2b8n,
  r: 0xb518bed38e385c9ade8205d8e90846196b1f224af3b3d72a23c3e6c710076n
}, {
  a: 0x96f949d18a41f7dfdcbc9a6ccbc445432ef39dd76086bbc7f0a2197en,
  b: 0x9febb9266e28d729c83340n,
  r: 0x96f949d18a41f7dfdcbc9a6ccbc445432e53b21e3a1892f0c6d9e63en
}, {
  a: -0xdd5b76ed37ce61155ba9e124daeabe77c5fdf9355d035eb7fec34e6368767833n,
  b: 0x67e9d93f69c3c3f8279ce531fb1125952ce850e1da63ed4ebc93en,
  r: -0xdd5b76ed37d4dfb2efa07d611a6d3846191daa47b6562d3d0ce0f4a23d624171n
}, {
  a: -0x1c0a457n,
  b: 0xb2aedb1an,
  r: -0xb46f7f71n
}, {
  a: -0x59bb70caa031d2c6d1n,
  b: 0xef640d60c08f004829b54bc7f445459a18e3d7ccbdb7264e5f875674c87en,
  r: -0xef640d60c08f004829b54bc7f445459a18e3d7ccbe10e1bf2a2788478f4fn
}, {
  a: 0xd9fn,
  b: -0x48e0f8713db8aa9ff017690cdf377107a4cc3ef320217495e5811cb57413n,
  r: 0x48e0f8713db8aa9ff017690cdf377107a4cc3ef320217495e5811cb581b2n
}, {
  a: 0xc42c8c9c392an,
  b: -0x4f278c1f5eda3de93ec81edec88df9d0083679694f05b7n,
  r: 0x4f278c1f5eda3de93ec81edec88df9d008faa5f5eb3ee1n
}, {
  a: 0x86f4072d944d2a2dabd6c70fa8e72ffdbfa3b9n,
  b: 0xcd2d5ebe7b1e4d7d15d899df537104b992968337ccn,
  r: -0xcd2cd7ca73f0b92febaaee088c615bd26298c39413n
}, {
  a: 0xa6a6c9a88dc0bcf7b614ca9f0af3a40bae6511eac885bbcc704ccf53cf5cc87n,
  b: 0xbf9a9b2a853736da2d19a768c1725bef3e159b93c81593e6cn,
  r: 0xa6a6c9a88dc0bc381b79a019d3bcc9de94bda9295629cc8e5ab13b8bb9c8e1bn
}, {
  a: -0xced1a3c44223634c55b6f538n,
  b: -0x164e6354546317fa7aafc76abf04fc5256cn,
  r: 0x164e635454562ae03e6ba5348a3fa0e3034n
}, {
  a: 0x4eb864b692dd040n,
  b: -0xd87bbc8125562bb76c13843e39a6cc640b9643fn,
  r: 0xd87bbc8125562bb76c13843e885f311a9e7347fn
}, {
  a: 0x243db7e819807079de39b0d9458362a434b0ad443d9b44d9601e70f80aa3n,
  b: 0x3cfd5ad9ef161fd3bn,
  r: 0x243db7e819807079de39b0d9458362a434b0ad443d977503b27f7f960d68n
}, {
  a: 0xba1c385be4947eac8c1bd90dc5bf92b3f650259cf89723b1bn,
  b: 0x1dbb74245ec2acf2b2d3256d6ef62bd52322f7675a890e1025797n,
  r: -0x1dbaba082666c85e3426995195e86615906f011734ec157901c7cn
}, {
  a: 0x7aea014ce0b152a4eb32698a936d7ccd3dn,
  b: 0x19c324f571fc5b6e529bda5646a18ecn,
  r: 0x7ae8651a915a32df344d3fccee0912b451n
}, {
  a: 0x66a7c02ec23533a17c0f45ce7f66535fn,
  b: 0x6b13b0da291509205d2f2e5e3249b8096d13cd47514838c1e5efac609fe29556dbn,
  r: -0x6b13b0da291509205d2f2e5e3249b8096cad25872286038e44739d1ad1632f037cn
}, {
  a: -0xa321defad62d68ebcb97a787n,
  b: 0xc4c1dd06b3b253ff2900af1fe921df622ec670ddc0520be91d28f2n,
  r: -0xc4c1dd06b3b253ff2900af1fe921e00550a56bb3edbaf7b4b4d079n
}, {
  a: -0xbc5dcafef39be80c96272fc3ef85n,
  b: 0x823e6fb550e2e12a1bbbcd78f8en,
  r: -0xc481b1fa48aa161f37e2ec9b7f13n
}, {
  a: 0xeeb7acd3e95aaf472a1692an,
  b: 0x986d004ee44n,
  r: 0xeeb7acd3e95a16da29c7ae6n
}, {
  a: -0x639b437886e459409ec0b7468276e6n,
  b: -0x2362752e480e19f1acd119ec934c0acba6ca95763378bn,
  r: 0x2362752e480e19eb731ce264250676c1babf210e0c0a5n
}, {
  a: -0xa13e3930b840c0eef2a026b14700ecc2df2e36dae9ba9d2a1eadn,
  b: -0xc3ae007ea27a2722n,
  r: -0xa13e3930b840c0eef2a026b14700ecc2df2d732ce93bfaaff78bn
}, {
  a: 0xe137d17f7fb04f45bd02da0821c5a6d03162fc6de4f67n,
  b: -0x9ee75c3714211e89bacn,
  r: 0xe137d17f7fb04f45bd02da0822648e2c68771d8c6eb13n
}, {
  a: -0xf5fn,
  b: 0x88a50957f6d4c2b70a76961f8n,
  r: -0x88a50957f6d4c2b70a7697157n
}, {
  a: 0xe8eb1fn,
  b: -0xf97891n,
  r: 0x1e263b0n
}, {
  a: 0xfbca14dad5316b0772d62bd6n,
  b: -0xe3b510e7b1465d33a5668f8c1n,
  r: 0xf371b2355e9973e41c93f2497n
}, {
  a: 0x4c1ff941478834208091a30bfe6506d0027c1f902330d3c5450cae496n,
  b: -0x4n,
  r: 0x4c1ff941478834208091a30bfe6506d0027c1f902330d3c5450cae49an
}, {
  a: 0x966b3593b50ea63f198a3fe24022d2bc6b7eb356c00d3ec2a93e7291e62452n,
  b: -0xfa5c237636cbe9cf10d2f21578b396431fb2c6ac93n,
  r: 0x966b3593b50ea63f198b3a3e63990988554dc429b222b7763f819244acd0e5n
}, {
  a: 0x9f4cd871a1n,
  b: 0xce408da74cd93d4eeca6c82ed7557eadbd097dn,
  r: -0xce408da74cd93d4eeca6c82ed754df60e497dcn
}, {
  a: -0xbb1a7e5b07ff87d45c960a226a30e4138b86cdn,
  b: -0xd3cbdc7d862b28e791a555c18ad790a32e5638d640da3ac5c801f9455n,
  r: 0xd3cbdc7d862b28e79199a419a52710aab1106f759eb397b786c940d88n
}, {
  a: 0x399be58f374be0a6a1022c83391b016c7cba5e9107a0772beb6n,
  b: 0xaa129cab9825db153ef8f9e0dafb442ca87c27953e970ba4c465005f4e448den,
  r: -0xaa129cab9825a1795969c294fa54a32a7bf8ee7a3d2a8eea65d3f8bed718a28n
}, {
  a: 0xd9f8216f4acb2026351bb7633e3d67a3edfb8aad161bd4f62f8n,
  b: 0x274dc90a535977a944092cf584a0e97bdb2aa85a7e9d78590d418n,
  r: -0x2673d0e8e40eac891dd4113e2162ac14373caccfd1875c8417120n
}, {
  a: 0x7ac3ba15aaa1e7e1bacd5304ce7fda9fn,
  b: -0xb9da9bf72955e8ac6b80dn,
  r: 0x7ac3ba15aaad858b7a3fe863594692acn
}, {
  a: -0x7n,
  b: -0x41n,
  r: 0x3an
}, {
  a: -0xf58e1157cc1e892c5e97baf3de82c56db223bede0d70c6n,
  b: -0xe8f1285e9468472bca5ee5bn,
  r: -0xf58e1157cc1e892c5e97bae54f703f846b9f4c2167826bn
}, {
  a: 0xb5268426a4d9053d4aa48be2cn,
  b: -0x7f54f1323c2dda2adn,
  r: 0xb5268427242df66f86d2660d9n
}, {
  a: -0xf3c1a981c8d8fb6b2d4e9d0427e2dc7b79564fb1c46312cecb71e0e700n,
  b: 0xe6cfd4b327b1e0cd2437ee4d7c4n,
  r: -0xf3c1a981c8d8fb6b2d4e9d0427e2dc89e6539ae43f811fa10ef0c5bec4n
}, {
  a: -0x2bfb6051n,
  b: 0x97a3ff67248fbe19bf818n,
  r: -0x97a3ff67248fc0d975869n
}, {
  a: 0x1c7981eb1840fbce57df1eac2679999cf1b725e813e477ac7c163n,
  b: 0x6c286c0907012f6f135d77c5bb824042b6n,
  r: 0x1c7981eb1840fbce57d85c2565e92989fac5f0109788bf8877eadn
}, {
  a: 0x68a77d84f014d888d004ac958ce185bec6c80an,
  b: 0xe84516c882263552cb54bd9290aec5f06f68caf5c280f8cc72n,
  r: -0xe84516c88225ccab4dcfcd7db825f5ebc2d33e143cc2320468n
}, {
  a: -0xc5dac3c4267292f8552d77826aeadab5805b4706564f0076n,
  b: 0x1cn,
  r: -0xc5dac3c4267292f8552d77826aeadab5805b4706564f0092n
}, {
  a: 0x1fdadn,
  b: 0x7eaa6d3626addn,
  r: -0x7eaa6d3606d30n
}, {
  a: -0x6d943697110c1cc6c706ec87d30348123e318fcn,
  b: -0x67ff3b056027fn,
  r: -0x6d943697110c1cc6c706ec87d29b48d738d167dn
}, {
  a: -0x362558ce9966e87edae788a152f143c71e0d7b3071afcb6cb3bfd039f5bn,
  b: 0x2fc6f5n,
  r: -0x362558ce9966e87edae788a152f143c71e0d7b3071afcb6cb3bfd336650n
}, {
  a: -0xf5d0ee594957710b1458137c19eba978f3160083f5a034c7ab8n,
  b: -0x9aeeb649ed8b23a355954908eab8b4c748b8a6n,
  r: -0xf5d0ee594957675c28f374a367b1741f9e8571d86a53c03c212n
}, {
  a: 0x1912b094b1aca758af29ebb2dc69370d7f8b5ee4f752d87e3aeb90ecen,
  b: 0x27d65db213c6eaf514988n,
  r: 0x1912b094b1aca758af29ebb2dc69370d7f8b370e99a0c4b74ff67c546n
}, {
  a: 0x121c3ff533a5309463f2702ac7dbf3f7fa9ff704a73c351c072n,
  b: -0xc064b3284910d3d0f1779f9c8e7e8n,
  r: 0x121c3ff533a5309463f270eb2c8f1c410b73c7f61edbd1aa85an
}, {
  a: -0x4982497cn,
  b: -0x6d5fe959e57e7e1a641db0102ed5dba9ac694cdae1a2efa1c49b310n,
  r: 0x6d5fe959e57e7e1a641db0102ed5dba9ac694cdae1a2ef9d2c76994n
}, {
  a: -0x5adf6ca1dfbd4ccc152982bf3n,
  b: 0x52d9d1127ben,
  r: -0x5adf6ca1dfbd4d1eeefa953b1n
}, {
  a: 0x2e75ad6e959cd0579e70258f824bab387151c7a223055a0f4e48a16f45n,
  b: 0xa4bc507800ed38589f4382dcf195b5cc53deb63ffe20an,
  r: 0x2e75ad6e959cc60bd968a580aec621443923f888c7a894d162e4a18d3bn
}, {
  a: -0xe4ff4208ce012595dcban,
  b: 0xb302643fab64411cd60b67e3928aadacd8aecbdc01a4557701a7bn,
  r: -0xb302643fab64411cd60b67e3928aadace6febffc8e8467d05f735n
}, {
  a: 0x1eae180a7540490706f12f4fef6f4d8545428f63354d14a54d9946179an,
  b: 0n,
  r: 0x1eae180a7540490706f12f4fef6f4d8545428f63354d14a54d9946179an
}, {
  a: 0xc1238f985269d59e6bae4b1889cffbn,
  b: -0xd3b3c4d54cn,
  r: 0xc1238f985269d59e6baf1ecc4ea547n
}, {
  a: -0x7ab4b3e3c62c260n,
  b: -0x71075310e32a2d38b90f3a57c1534d886db453af952307a438a1b0332af6d6276da42fn,
  r: 0x71075310e32a2d38b90f3a57c1534d886db453af952307a438a1b02b7fab97eb0ae1cfn
}, {
  a: 0x1a45182a12bc345c20n,
  b: -0xb1b858b3e36e9f2712cf37c43an,
  r: 0xb1b858b3fdb3b751258b6c205an
}, {
  a: -0xd206ffe39e0a7b662n,
  b: 0xe9d92549c9401010dd65cc73a8cc5n,
  r: -0xe9d92549c940e217dd496a7e24327n
}, {
  a: -0x1c3fb244eeaf76800718161abbd6aba300fn,
  b: 0x14154fd7ad101d21ce7b72651c62717010ac52e4a6577n,
  r: -0x14154fd7ad2c5cd4136a21db9c6989862b68299049586n
}, {
  a: 0x2e4ad1153a93ab6513a2320de2377a1e319a9ef1ed1f158aa51cbcd4a3509fbbd1723n,
  b: -0x4c31f9939n,
  r: 0x2e4ad1153a93ab6513a2320de2377a1e319a9ef1ed1f158aa51cbcd4a350ebedcb05cn
}, {
  a: -0xe0adee76e44d4373b4287eb0bc264c82ce3e259f904a26a0b68563738d474acan,
  b: 0x8ddb34722686n,
  r: -0xe0adee76e44d4373b4287eb0bc264c82ce3e259f904a26a0b685f14ec1b97150n
}, {
  a: 0xe0b41a80ae4203fa6a866d8836b59914ce0n,
  b: -0x9096b1ee855de1f96583558672604d30f144fd438eae02fe9n,
  r: 0x9096b1ee855de2da199dd634b464479b77b2857a444717cc9n
}, {
  a: 0xb825092c23da1ae30c1aba99c280aa00a6666f74c8cd532an,
  b: -0x45e4dda7255f7cf01d64n,
  r: 0xb825092c23da1ae30c1aba99c280efe5840d94d445bd708en
}, {
  a: 0x3d9e864ceb70a5b7fb10n,
  b: 0x5n,
  r: 0x3d9e864ceb70a5b7fb0bn
}, {
  a: 0xe9f65de0d6bcd9409383dc6c58626eb56ee92a83b70e0a63dda0d059cbfb6aeea7n,
  b: 0xba64a0791c2eb185ea729302454b2d25709f789en,
  r: 0xe9f65de0d6bcd9409383dc6c57a80a14f5ccfbd2312397d0db5b852ca68acb7609n
}, {
  a: -0xe83dc500eb5f02437f4f6n,
  b: 0x5076346aafe6ced23b71e638n,
  r: -0x5084b846fff584c25fa9db2en
}, {
  a: -0x19n,
  b: -0xd89453f3d3463444eaa6060fcb1e93413a40ed6d139f1635b3ff0f4094n,
  r: 0xd89453f3d3463444eaa6060fcb1e93413a40ed6d139f1635b3ff0f407bn
}, {
  a: -0x6faa72ba6a1cb63b6a409b2ee94e36d386dd883df91300f490n,
  b: -0x24ce97f2293c7a454b6c6e3n,
  r: -0x6faa72ba6a1cb63b6a409b2ee94be9ea07baf47654be4a2dadn
}, {
  a: 0x79de630b670e12dab4bd0an,
  b: 0x96242132bd11b42945c457d94604d5d399c68b5d1713b9f0016a27202a188c3bb8c9fn,
  r: -0x96242132bd11b42945c457d94604d5d399c68b5d1713b9e86383f669b9375e906cf95n
}, {
  a: -0x45cfa0n,
  b: -0xcab106583043ea7e9c0613eda5c1feb2c0b9a09c6327a8fa41f56ee0653n,
  r: 0xcab106583043ea7e9c0613eda5c1feb2c0b9a09c6327a8fa41f56a836b3n
}, {
  a: 0xa3653dea686517f691611c4d2c8eb32c82e3293f18d71d845dced4dcd5n,
  b: 0x2ee6540c268b9ab0c3n,
  r: 0xa3653dea686517f691611c4d2c8eb32c82e3293ee9f0c97837433a2c12n
}, {
  a: 0x56012d33ae4e611f719e58a1n,
  b: -0xd193b22a954e637b28fa71c1ee47fe81dc79a3a246301de4n,
  r: 0xd193b22a954e637b28fa71c244492bb58ac804c1b7ce7685n
}, {
  a: -0x432d10887n,
  b: -0x46c0ae6e51db7172acefdf80cdecc8ccb332f5066af380170f2d6ebn,
  r: 0x46c0ae6e51db7172acefdf80cdecc8ccb332f5066af37fd3e21ce64n
}, {
  a: -0x4c9910aace4c854c27b9d34c68218n,
  b: 0x907c8815249a27c0e16308590c8c3a2dan,
  r: -0x907cd4ae3544f60d66af3012dfd8a24f2n
}, {
  a: 0xbe9a21aaef2454f64704en,
  b: 0x55en,
  r: 0xbe9a21aaef2454f646af0n
}, {
  a: 0x80d0cb79e2b7n,
  b: -0x289ea3e58fe53f694a2964263d6e3e9b45c5b4n,
  r: 0x289ea3e58fe53f694a2964263def0f66bfa86bn
}, {
  a: -0xcc33889f761b6daea22bdfbd5dffae96f2ea055978da4925ab4d31d3566b71f6512n,
  b: 0x38aa7154205938b7ba4e1449f7n,
  r: -0xcc33889f761b6daea22bdfbd5dffae96f2ea05597c64f03aed52c55ed210533af09n
}, {
  a: 0x1c0ebbdc946624n,
  b: 0x609c3eee4000dfee2e332ae3e302bf9ccc4632a7513ed824bb8a6ce5bf175n,
  r: -0x609c3eee4000dfee2e332ae3e302bf9ccc4632a7513ed822fa9eaf1c78b51n
}, {
  a: -0xd938n,
  b: 0xf7893bdc52e8031cbe8007cb32287e4f4dc28f965fan,
  r: -0xf7893bdc52e8031cbe8007cb32287e4f4dc28fa3f32n
}, {
  a: -0x3b9625aaa0d51bbad95d2983af46244d2377b8996f10a5n,
  b: -0x74281a5748dffbe103434e26fc9c0cn,
  r: -0x3b9625aaa0d51bba65350f2c6666286c20346a72727499n
}, {
  a: -0x99ac5df2845524fad349bd58bbb1bff2c88an,
  b: -0x783b6d0ac1en,
  r: -0x99ac5df2845524fad349bd58b42e09221c6cn
}, {
  a: -0x61af10830f36a064f5816fe68d42dd90f324317f7d3e662812c2622n,
  b: -0xca985748e2ceb4cbbb4e73f4360944380cn,
  r: -0x61af10830f36a064f581633d07ce4f6407d775ca95ff22c77e7ee16n
}, {
  a: -0x871f9174102482fb814fd5b53f6n,
  b: -0x764baad97044a28a25b3025ce67dd1e8b225e8bacff26ed7b528e480n,
  r: 0x764baad97044a28a25b3025ce67dc976b90ea7b887c2b6c2b7cd908an
}, {
  a: -0x8bb74c23b47bcf9359c66b0an,
  b: 0xdfc11a222b4fceac52a65f5ca60cdd96e845e4d08n,
  r: -0xdfc11a222b4fceac5b61d41ee1549a901de24b812n
}, {
  a: 0x6f0d92f0671fcaba7d5eb0ece9b36358n,
  b: -0xafd1496b95df0f130c34999ea0399ec28f7bc832bcdbe29f1e05480b99d5a0ed2n,
  r: 0xafd1496b95df0f130c34999ea0399ec2966ca161c34ddf4ac5db331a6870d722an
}, {
  a: -0xdc5f34a8e2d9b9bd7cn,
  b: 0x732cf80c5d8b8e018d70390a911cn,
  r: -0x732cf80c5e67ed36365312c44e98n
}, {
  a: -0xbaea3a06971003ebc96815bdc8d1bdede8n,
  b: 0x831f1e79b4e757a40ddab0d46n,
  r: -0xbaea3a069f41f5d364b68b3809af68fb2en
}, {
  a: -0xd6025387fb01876aec27aa5c3a35d027b991c4n,
  b: 0xd0708a5585cfe3e64df6c13b04bdce32e5b09552n,
  r: -0xd1468ca90dcae56db8e2e8e560f804030d6a2716n
}, {
  a: -0xc1c1744220f9db4a753e2bf89357n,
  b: -0xc88862bbcbc0b41edc55de27cfc95n,
  r: 0xbc6c4b77a9b1166a3501fb684693en
}, {
  a: 0xffn,
  b: -0x4cba00c0d5be53222cf8d33d1n,
  r: 0x4cba00c0d5be53222cf8d34d0n
}, {
  a: -0x608c5a80a9e98d8b4bcf109bb86d031bf0cb52aebdae65117b58b7c1eb58049n,
  b: 0xa73423270efb65671d03cbac52996n,
  r: -0x608c5a80a9e98d8b4bcf109bb86d031bf17286d1e4bd6076e275bb8d97aa9dfn
}, {
  a: 0x79f3705a94a0c14fn,
  b: -0x890c529596e3ea2d2b50ed87a59cf522d5b2ae9e6d777e23fcb7bb9fn,
  r: 0x890c529596e3ea2d2b50ed87a59cf522d5b2ae9ee76aee7e91587ceen
}, {
  a: -0x3a9e4c3a7aa192b3affa2b828e9n,
  b: -0xcf660dd86d2476f39bf1a451de6e0f502774e8a02f3f9c24ce24b7fe4bbn,
  r: 0xcf660dd86d2476f39bf1a451de6e0f4fecd69c65b49e09711e2a8c7bbd2n
}, {
  a: 0x437e5b4fa6ef6e1dbf75f8e87a52134298n,
  b: -0xe62f3332abe80e45b5164n,
  r: 0x437e5b4fa6ef7c80b2a923a6fb366e93fcn
}, {
  a: 0x9014f16f7ab8fddb227745a804733dd78625a3276937d1f6ed470c3f94n,
  b: -0x2a9957347ab1c66c6ca4525bc9aab887c7d049c0a3d0ae6b87c524e5cf412ddf9en,
  r: 0x2a9957350ac6b7dbe75d5036ec21fe2fcc43879829f65192f0fcf6dcbc883a1f32n
}, {
  a: -0xa11509f6622b89en,
  b: 0xe3eef1110efc7n,
  r: -0xa1f8f8e7733a865n
}, {
  a: 0x7f8f959848ca3a9ad1248a4c97617eb68bf048d0eeb42e8a3a76cf20ab7b81af17fn,
  b: 0x7d4b374b1e74f237865c485c14f2a45ccn,
  r: 0x7f8f959848ca3a9ad1248a4c97617eb68b72fd99a395b99802f072d84f668f0abb3n
}, {
  a: 0xa328ddd8749eb65d6ff7bn,
  b: 0x7cff98adeda0edb03633cee21187an,
  r: -0x7cff98ad4a780fd7c1951884a18ffn
}, {
  a: -0x93f57d8165797dec1d489n,
  b: -0xea149662320390b08e37b199144n,
  r: 0xea1495ce3c860f4b14b9c57bcbbn
}, {
  a: -0x1a751c30a64bd5a4ba2edac0c044fdaab4a633d4abbcfdfec6f5a0e4aadca4b2355n,
  b: 0x492b52c1ae411fb352598cccb9955db79n,
  r: -0x1a751c30a64bd5a4ba2edac0c044fdaab4ef5f276d6b3f1e7a47fa7177963a0fecen
}, {
  a: 0xb4ffed912014d44851f6abd9970d0a3f4f35c5c3bc0e9d345825f5d09a1fn,
  b: -0x152c1a2a1770e3n,
  r: 0xb4ffed912014d44851f6abd9970d0a3f4f35c5c3bc0e9d4984401fe80b02n
}, {
  a: -0x48a59fen,
  b: -0xb73c1cea768e06a3b6296540dd69346101dc5575226d8886dn,
  r: 0xb73c1cea768e06a3b6296540dd69346101dc55752224e2e6fn
}, {
  a: -0xc97b977dbc989a0028d629n,
  b: 0x14766f4d7595aadb0cca5942eb00n,
  r: -0x14767016f12d2897a564596bc129n
}, {
  a: -0xd4301286fc8b84879n,
  b: 0x5a67420c1e3ac96bac911abe76d9e4e124c7580cc3ce5e59a0n,
  r: -0x5a67420c1e3ac96bac911abe76d9e4e1320a5935339716a219n
}, {
  a: 0xc0dfbefc5fc6e19da3949bd58f9d4ed76ff10c777e1a2c0160603b22n,
  b: -0x104n,
  r: 0xc0dfbefc5fc6e19da3949bd58f9d4ed76ff10c777e1a2c0160603c26n
}, {
  a: -0x8a28dc80a284f26a8c641b5ded4n,
  b: -0xd0e5b375n,
  r: -0x8a28dc80a284f26a8c570d02b5fn
}, {
  a: 0xe0n,
  b: -0x3502c622ecddb06fc8977ec6fc0da437848d64b1dfn,
  r: 0x3502c622ecddb06fc8977ec6fc0da437848d64b2bfn
}, {
  a: 0xc515f4c4335856a242da597406dbca52b4n,
  b: -0x94916bb1808n,
  r: 0xc515f4c4335856a242da597d4ff2856abcn
}, {
  a: -0xefe53n,
  b: 0xb1b91fd029034fbdaddf5ef81fafcc88n,
  r: -0xb1b91fd029034fbdaddf5ef81fbecadbn
}, {
  a: 0xd6380c43ce96c7dd8542b111b379n,
  b: -0xe0de0553eaa1e3d7da88cf38fa7090f29f32833an,
  r: 0xe0de0553eaa2ba0fe6cc9dcfc24e1635504436b3n
}, {
  a: 0xf3c796d155a65f69af63599d41e185eb4bd86n,
  b: 0xb363bd5d2d327f57e04797b387183172b7cb19f6a92ffn,
  r: -0xb363bd5c396ae8868aa13849d7b4d7d575e9940b5d579n
}, {
  a: -0xcbb3996891n,
  b: 0xdc2c71f16dead78d7a7fcb7e1e8721701d01e74d0a89792918070e13554954ce984704n,
  r: -0xdc2c71f16dead78d7a7fcb7e1e8721701d01e74d0a89792918070e13554a208231af95n
}, {
  a: 0x7147281a7723a0b230c7187af4ad927731b3cf420f3accn,
  b: -0x150994cafdbb0d9586dfae1aae8cn,
  r: 0x7147281a7723a0b230dc220fbfab4d84c73aaef029e958n
}, {
  a: 0x56e858e1fb5404c0ae1260512069822c9efdfdba7d3bd2332c0358119502044ecac9c0n,
  b: -0xd0a474155546232995a360eb4ce4a54d5dcfa47090d82debc263n,
  r: 0x56e858e1fb5404c0aee304c535bec84fc893a11b6888b6d8796127b60592dc7cb68c23n
}, {
  a: 0x37ef001403c7819c5304f92d942b698794414e6a61a4cda9ae59cd7a88ben,
  b: -0x5890471241c972c091529bad344652d9db055bcn,
  r: 0x37ef001403c7819c5304feb6989c8da42b6d577f8b5fa0ee13876b2ade7an
}, {
  a: -0xb99d209347ca20597e274d0d0acade27d29f39a9c5a63b617n,
  b: -0xd0c249c1cb14e12bed64bf36fd00e51521a185577dfc9ca5b9af719863af5eaec56n,
  r: 0xd0c249c1cb14e12becab221669b91af4c8235e0a70f1d1c791dcd25eb9e9b87363fn
}, {
  a: -0x5c71da55ae4139d829cfa682aeen,
  b: 0x26aed194ddn,
  r: -0x5c71da55ae4139d82c3a939bfcbn
}, {
  a: 0x73bac9ed42574ae204d911da4567a5369db7fn,
  b: 0x9d42a240038748c64c6de6aa7823fb5576f8c5bed459d6d17426390n,
  r: -0x9d42a240038748c64bfa2be08ae1a40a94f3ecacfa146f2c3d88811n
}, {
  a: 0x8dc70c6bcbd8f27e2c807d6f24b1db9a7ec615n,
  b: -0xf21975f588923b63cd6138591n,
  r: 0x8dc70c6bcbd9019fc3dfd5f848681870924ba6n
}, {
  a: 0x137a0239693302d1c0e8c9931cfc4n,
  b: -0xb7946fade6b29cfd9c7en,
  r: 0x137a023974ac49cc9f53f362f6c42n
}, {
  a: 0xbeba2bdc6a8f91c1305d0be3fa03677f2n,
  b: -0x7060c63eb3ecn,
  r: 0xbeba2bdc6a8f91c1305d12ea066752bden
}, {
  a: 0x756b6297da1f965a0029add7c5f60372f1ef0c6e2e5b2d73ca8aadb3e2887n,
  b: -0x3e801cebe647df3d375016520b9daeb6a922c743475e61e49afb9c049e7c35n,
  r: 0x45d6d31563e9d8a2d752b12f87fd0eedd841b80a2a4414bbd7a446dfdca4bcn
}, {
  a: -0xab7e0d3780n,
  b: 0xf6f193abcb1655323ff3640bd6354n,
  r: -0xf6f193abcb1655323ffe1beca9ad4n
}, {
  a: 0x7f16632726c246b14de069fc8663da4ae0ae456n,
  b: 0x930b0b3ff27354982758155b82c346e6a183f6675b13aa582fe8d9856d7acn,
  r: -0x930b0b3ff2735498275814dc6c601fbfdf3d45197aa9add1cc0e8ea4bf356n
}, {
  a: -0x44ad0fb0e4n,
  b: -0x2916bccb83e5de617eba1a9746324c1d4b68n,
  r: 0x2916bccb83e5de617eba1a9745ed9f0d9a84n
}, {
  a: -0x65e4de890an,
  b: 0xdaffb2927326c2582cd9an,
  r: -0xdaffb292732d20a6156a4n
}, {
  a: 0x6ae5f4bb70dn,
  b: -0x410f759d13adan,
  r: 0x417a5b91cf1e7n
}, {
  a: -0xf73efb6f26d8c9cfd8606aee83e997d355f16871a99af7ee78d0c95dcd40d9n,
  b: 0n,
  r: -0xf73efb6f26d8c9cfd8606aee83e997d355f16871a99af7ee78d0c95dcd40d9n
}, {
  a: -0x4c375b39275a4804effec8c5ad4bdb9eee099a9bf935b4acdn,
  b: 0x17e9c980754f5ad2162bc0b1a7548a7ccef02b0n,
  r: -0x4c375b39277231ce707418207f62075f9fb0ef267604a4d7dn
}, {
  a: 0xa751n,
  b: 0xf042ce551b804392e36f9b8b0cde94a937ff041c54a928736b2n,
  r: -0xf042ce551b804392e36f9b8b0cde94a937ff041c54a92868f61n
}, {
  a: 0xca850226d9cb6d6ebbbfd6cd1bfb4ce8d2dd5a59593f8b46cf68cbfded28n,
  b: 0x9b9da3dfecf1157b0c47c92bae201cfd697df196ac62b9c220n,
  r: 0xca850226d92fcfcadbd2e5b7a0ef051fa72f3a3c5bd60d5538bc69442b08n
}, {
  a: -0x2351cn,
  b: 0x924b753d512033862801025eff5e6n,
  r: -0x924b753d512033862801025f22b02n
}, {
  a: -0x51906e862e232703397594829e9a2862bee932n,
  b: -0x345c46eb6400585abba3d7n,
  r: -0x51906e862e23270305194d973a99d00803455bn
}, {
  a: 0x50f7bf307e10b0a2dc5ef9214c4923a193db0f880d348998e3n,
  b: 0x9261db2e97767c31b290fd724a702d2f413ca6265da41a2baa260b73e8n,
  r: -0x9261db2e467ebd0134804ccf6e11340df4f38284c9c90aa39cf181db05n
}, {
  a: -0x10438eb943f96c02bf905c10e452d1n,
  b: -0x2ab8f0a2ac38e06f1b01a2a6b5b22bc1c6a3deee011640c6e3c8619d4507aadc313f3an,
  r: 0x2ab8f0a2ac38e06f1b01a2a6b5b22bc1c6a3deedf0d2b20d9fcef59a85774ecb4cec69n
}, {
  a: 0xe5cb78285f3e8ee79da1bc6a24a0a9db74c2f19ff56e0d0cbd961e2fba3175ec8n,
  b: -0x6f11787cb8d90daad668a37da16n,
  r: 0xe5cb78285f3e8ee79da1bc6a24a0a9db74c2f20f06e689c596a3c90622d4f38den
}, {
  a: 0x2302dd603227f18f132ed77b07299071a72550n,
  b: -0xbfee10a8fe49254d641560b81a2f89452565d7e30n,
  r: 0xbff040d6d44c47cc7d0693a591dffbde2c804a380n
}, {
  a: -0x952b5e104beebf0d3cd52778cca4da7b62fe69b885n,
  b: -0x9b3b5761cef591988e92f84ff7c45ce2d4503bd112b9376c77d9eae511b36c51a5d6n,
  r: 0x9b3b5761cef591988e92f84ff72f3184c4044d12057c6244ff0d460a96506de7ed51n
}, {
  a: 0xed34068aa1654c304326e72n,
  b: 0xbn,
  r: 0xed34068aa1654c304326e67n
}, {
  a: 0x36e53dn,
  b: 0x9709n,
  r: 0x364e34n
}, {
  a: -0xe36a116623ae4d8066338a935b9fcf50164e9fb601237fa0f9785e9b824ef9b6n,
  b: 0x7b939a5ean,
  r: -0xe36a116623ae4d8066338a935b9fcf50164e9fb601237fa0f9785ea33b889fa0n
}, {
  a: -0x37c85dd4f74ccean,
  b: 0xac3260226n,
  r: -0x37c85e8129acf10n
}, {
  a: 0xc5bfdd4544ed64de719a2e3fa9a1c470745da4bb970844e7f50n,
  b: -0x2e08544fb04b2fcf5fd663aa464f820e1c6cfff8d67352f818a5ccee64cc3ec2a08dn,
  r: 0x2e08544fb04b2fcf6c32617e9a9e585c0386a2dcd10d6f3f1feba73a1e3cc3111fddn
}, {
  a: 0xd19c96486cbcn,
  b: 0x13ff0f2739f8db77n,
  r: -0x13fe3d8aa3b06ebbn
}, {
  a: -0xae882bf7e109bbaa07ed44d6d8fd2f6c30407bdd1360f3af809cn,
  b: 0x4daac96f0b9d5f8332a8f7a69a16027n,
  r: -0xae882bf7e109bbaa07ed49b1859420260638af07a2db5d50e0c3n
}, {
  a: -0x8ea34352432860n,
  b: 0xc6f54f7a7b67c9d2f69aeb0d55a520dbc5196fc12317a4961051fb2797304a2a8n,
  r: -0xc6f54f7a7b67c9d2f69aeb0d55a520dbc5196fc12317a496105ae55bcc547cb08n
}, {
  a: 0x3b0c1e07c8b298bc2675828a024ff6de408809ecn,
  b: 0xee086384a5f20ac6af579ca9f94174314a7d4378e4d3779f06ca95dn,
  r: -0xee086384a5f20ac2fe95bc2d6e17e86ee3251ad8bfd409bafe49f71n
}, {
  a: 0x760n,
  b: 0x425dbc01a71c87ab22a63a1122c834788bf0dfcbeff6ae7936a60bedn,
  r: -0x425dbc01a71c87ab22a63a1122c834788bf0dfcbeff6ae7936a6048dn
}, {
  a: 0x620dn,
  b: 0x7b9d561e941fbf1c892c6ed66bf8417e0e3730fa1050b2ae89c2fb4bn,
  r: -0x7b9d561e941fbf1c892c6ed66bf8417e0e3730fa1050b2ae89c2993en
}, {
  a: -0xfb8dab78f0f7bb4543731bd22d158c93e1n,
  b: 0xd2e97ac55f2a57bd5630e275d555d1be89a635a9fcd3ff41dc7a24dca8691acn,
  r: -0xd2e97ac55f2a57bd5630e275d555e177645dc4b9788853790e3747ae013258dn
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var r = d.a - d.b;
  if (d.r !== r) {
    print("Input A:  " + d.a.toString(16));
    print("Input B:  " + d.b.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    print("Op: -");
    error_count++;
  }
}
if (error_count !== 0)
  throw new Error("Finished with " + error_count + " errors.")

