DESCRIPTION = "PNGWRITER"
SECTION = "libs"
LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://${WORKDIR}/pngwriter/doc/LICENSE;md5=fd9466548a4a68e6dfd4db9a24de15fd"

SRC_URI = "${RDK_ARTIFACTS_BASE_URL}/sky_llama/prebuilts/sky-mic-test/pngwriter.tar.gz;name=pngwriter" 
SRC_URI[pngwriter.md5sum]    = "e9cf4d37afc6a9ad9e867c4b871b2bc7"
SRC_URI[pngwriter.sha256sum] = "4357adc89895abe609c1179eaeb6e12bc3467a4eeb8927cb9f5f7c33dfcb0dd4"  

inherit cmake autotools pkgconfig 

# we had multiple recipes in the past
PROVIDES = "pngwriter"

EXTRA_OECONF = "--disable-fortran --enable-shared --enable-threads"

SOUNDTOUCH_NEON = "${@bb.utils.contains('TUNE_FEATURES', 'neon', '--enable-neon', '', d)}"
SOUNDTOUCH_NEON_class-native = ""

do_configure() {
	mkdir -p ${B}
    cp -r ${WORKDIR}/pngwriter/* ${B}
    mkdir -p ${B}/pngwriter-build
    cd ${B}/pngwriter-build
    cmake ${B}
}

do_compile() {
    cd ${B}/pngwriter-build
    oe_runmake
}

do_install() {
    install -d ${D}${libdir}
    install -m 0755 ${B}/pngwriter-build/libPNGwriter.a ${D}${libdir}
}

DEPENDS = "libpng zlib freetype libpng-native"
