/*
 * Project    : ipv6calc
 * File       : databases/lib/libipv6calc_db_wrapper_IP2Location.h
 * Version    : $Id: libipv6calc_db_wrapper_IP2Location.h,v 1.11 2015/05/02 15:25:33 ds6peter Exp $
 * Copyright  : 2013-2013 by Peter Bieringer <pb (at) bieringer.de>
 *
 * Information:
 *  Header file for libipv6calc_db_wrapper_IP2Location.c
 */

#include "ipv6calctypes.h"

#ifndef _libipv6calc_db_wrapper_IP2Location_h

#define _libipv6calc_db_wrapper_IP2Location_h 1

#ifdef SUPPORT_IP2LOCATION
#include "IP2Location.h"
#endif

#define IP2LOCATION_SUPPORT_UNKNOWN		0
#define IP2LOCATION_SUPPORT_COMPAT		1
#define IP2LOCATION_SUPPORT_FULL		2
#define IP2LOCATION_SUPPORT_NOTEXISTS		3

#define IP2LOCATION_IPV6_SUPPORT_UNKNOWN	0
#define IP2LOCATION_IPV6_SUPPORT_COMPAT		1
#define IP2LOCATION_IPV6_SUPPORT_FULL		2
#define IP2LOCATION_IPV6_SUPPORT_NOTEXISTS	3

// database types
#define IP2LOCATION_DB_MAX	 24

/*** Commercial ***/
#define IP2LOCATION_IPV4_DB1	 1
#define IP2LOCATION_IPV4_DB2	 2
#define IP2LOCATION_IPV4_DB3	 3
#define IP2LOCATION_IPV4_DB4	 4
#define IP2LOCATION_IPV4_DB5	 5
#define IP2LOCATION_IPV4_DB6	 6
#define IP2LOCATION_IPV4_DB7	 7
#define IP2LOCATION_IPV4_DB8	 8
#define IP2LOCATION_IPV4_DB9	 9
#define IP2LOCATION_IPV4_DB10	 10
#define IP2LOCATION_IPV4_DB11	 11
#define IP2LOCATION_IPV4_DB12	 12
#define IP2LOCATION_IPV4_DB13	 13
#define IP2LOCATION_IPV4_DB14	 14
#define IP2LOCATION_IPV4_DB15	 15
#define IP2LOCATION_IPV4_DB16	 16
#define IP2LOCATION_IPV4_DB17	 17
#define IP2LOCATION_IPV4_DB18	 18
#define IP2LOCATION_IPV4_DB19	 19
#define IP2LOCATION_IPV4_DB20	 20
#define IP2LOCATION_IPV4_DB21	 21
#define IP2LOCATION_IPV4_DB22	 22
#define IP2LOCATION_IPV4_DB23	 23
#define IP2LOCATION_IPV4_DB24	 24

#define IP2LOCATION_IPV6_DB1	 25
#define IP2LOCATION_IPV6_DB2	 26
#define IP2LOCATION_IPV6_DB3	 27
#define IP2LOCATION_IPV6_DB4	 28
#define IP2LOCATION_IPV6_DB5	 29
#define IP2LOCATION_IPV6_DB6	 30
#define IP2LOCATION_IPV6_DB7	 31
#define IP2LOCATION_IPV6_DB8	 32
#define IP2LOCATION_IPV6_DB9	 33
#define IP2LOCATION_IPV6_DB10	 34
#define IP2LOCATION_IPV6_DB11	 35
#define IP2LOCATION_IPV6_DB12	 36
#define IP2LOCATION_IPV6_DB13	 37
#define IP2LOCATION_IPV6_DB14	 38
#define IP2LOCATION_IPV6_DB15	 39
#define IP2LOCATION_IPV6_DB16	 40
#define IP2LOCATION_IPV6_DB17	 41
#define IP2LOCATION_IPV6_DB18	 42
#define IP2LOCATION_IPV6_DB19	 43
#define IP2LOCATION_IPV6_DB20	 44
#define IP2LOCATION_IPV6_DB21	 45
#define IP2LOCATION_IPV6_DB22	 46
#define IP2LOCATION_IPV6_DB23	 47
#define IP2LOCATION_IPV6_DB24	 48

/* SAMPLE */
#define IP2LOCATION_IPV4_SAMPLE_DB1	 49
#define IP2LOCATION_IPV4_SAMPLE_DB2	 50
#define IP2LOCATION_IPV4_SAMPLE_DB3	 51
#define IP2LOCATION_IPV4_SAMPLE_DB4	 52
#define IP2LOCATION_IPV4_SAMPLE_DB5	 53
#define IP2LOCATION_IPV4_SAMPLE_DB6	 54
#define IP2LOCATION_IPV4_SAMPLE_DB7	 55
#define IP2LOCATION_IPV4_SAMPLE_DB8	 56
#define IP2LOCATION_IPV4_SAMPLE_DB9	 57
#define IP2LOCATION_IPV4_SAMPLE_DB10	 58
#define IP2LOCATION_IPV4_SAMPLE_DB11	 59
#define IP2LOCATION_IPV4_SAMPLE_DB12	 60
#define IP2LOCATION_IPV4_SAMPLE_DB13	 61
#define IP2LOCATION_IPV4_SAMPLE_DB14	 62
#define IP2LOCATION_IPV4_SAMPLE_DB15	 63
#define IP2LOCATION_IPV4_SAMPLE_DB16	 64
#define IP2LOCATION_IPV4_SAMPLE_DB17	 65
#define IP2LOCATION_IPV4_SAMPLE_DB18	 66
#define IP2LOCATION_IPV4_SAMPLE_DB19	 67
#define IP2LOCATION_IPV4_SAMPLE_DB20	 68
#define IP2LOCATION_IPV4_SAMPLE_DB21	 69
#define IP2LOCATION_IPV4_SAMPLE_DB22	 70
#define IP2LOCATION_IPV4_SAMPLE_DB23	 71
#define IP2LOCATION_IPV4_SAMPLE_DB24	 72

#define IP2LOCATION_IPV6_SAMPLE_DB1	 73
#define IP2LOCATION_IPV6_SAMPLE_DB2	 74
#define IP2LOCATION_IPV6_SAMPLE_DB3	 75
#define IP2LOCATION_IPV6_SAMPLE_DB4	 76
#define IP2LOCATION_IPV6_SAMPLE_DB5	 77
#define IP2LOCATION_IPV6_SAMPLE_DB6	 78
#define IP2LOCATION_IPV6_SAMPLE_DB7	 79
#define IP2LOCATION_IPV6_SAMPLE_DB8	 80
#define IP2LOCATION_IPV6_SAMPLE_DB9	 81
#define IP2LOCATION_IPV6_SAMPLE_DB10	 82
#define IP2LOCATION_IPV6_SAMPLE_DB11	 83
#define IP2LOCATION_IPV6_SAMPLE_DB12	 84
#define IP2LOCATION_IPV6_SAMPLE_DB13	 85
#define IP2LOCATION_IPV6_SAMPLE_DB14	 86
#define IP2LOCATION_IPV6_SAMPLE_DB15	 87
#define IP2LOCATION_IPV6_SAMPLE_DB16	 88
#define IP2LOCATION_IPV6_SAMPLE_DB17	 89
#define IP2LOCATION_IPV6_SAMPLE_DB18	 90
#define IP2LOCATION_IPV6_SAMPLE_DB19	 91
#define IP2LOCATION_IPV6_SAMPLE_DB20	 92
#define IP2LOCATION_IPV6_SAMPLE_DB21	 93
#define IP2LOCATION_IPV6_SAMPLE_DB22	 94
#define IP2LOCATION_IPV6_SAMPLE_DB23	 95
#define IP2LOCATION_IPV6_SAMPLE_DB24	 96

/* LITE */
#define IP2LOCATION_DB_IP_COUNTRY_LITE				100
#define IP2LOCATION_DB_IPV6_COUNTRY_LITE			101

#define IP2LOCATION_DB_IP_COUNTRY_REG_CIT_LITE			102
#define IP2LOCATION_DB_IPV6_COUNTRY_REG_CIT_LITE		103

#define IP2LOCATION_DB_IP_COUNTRY_REG_CIT_LL_LITE		104
#define IP2LOCATION_DB_IPV6_COUNTRY_REG_CIT_LL_LITE		105

#define IP2LOCATION_DB_IP_COUNTRY_REG_CIT_LL_ZIP_LITE		106
#define IP2LOCATION_DB_IPV6_COUNTRY_REG_CIT_LL_ZIP_LITE		107

#define IP2LOCATION_DB_IP_COUNTRY_REG_CIT_LL_ZIP_TZ_LITE	108
#define IP2LOCATION_DB_IPV6_COUNTRY_REG_CIT_LL_ZIP_TZ_LITE	109

/* FREE (old) */
#define IP2LOCATION_DB_IPV6_COUNTRY_FREE			120

// shortcuts
#define IPV6CALC_DB_SC_IP2LOCATION_IPV4_COUNTRY			(IPV6CALC_DB_IPV4_TO_CC | IPV6CALC_DB_IPV4_TO_COUNTRY | IPV6CALC_DB_IP2LOCATION_IPV4)
#define IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY			(IPV6CALC_DB_IPV4_TO_CC | IPV6CALC_DB_IPV4_TO_COUNTRY | IPV6CALC_DB_IP2LOCATION_IPV4 | IPV6CALC_DB_IPV4_TO_REGION | IPV6CALC_DB_IPV4_TO_CITY)

#define IPV6CALC_DB_SC_IP2LOCATION_IPV6_COUNTRY			(IPV6CALC_DB_IPV6_TO_CC | IPV6CALC_DB_IPV6_TO_COUNTRY | IPV6CALC_DB_IP2LOCATION_IPV6)
#define IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY			(IPV6CALC_DB_IPV6_TO_CC | IPV6CALC_DB_IPV6_TO_COUNTRY | IPV6CALC_DB_IP2LOCATION_IPV6 | IPV6CALC_DB_IPV6_TO_REGION | IPV6CALC_DB_IPV6_TO_CITY)

#define IP2LOCATION_DB1  "Country"
#define IP2LOCATION_DB2  "Country/ISP"
#define IP2LOCATION_DB3  "Country/Region/City"
#define IP2LOCATION_DB4  "Country/Region/City/ISP"
#define IP2LOCATION_DB5  "Country/Region/City/LongitudeLattitude"
#define IP2LOCATION_DB6  "Country/Region/City/LongLatt/ISP"
#define IP2LOCATION_DB7  "Co/Re/Ci/ISP/Domain"
#define IP2LOCATION_DB8  "Co/Re/Ci/LattLong/ISP/Domain"
#define IP2LOCATION_DB9  "Co/Re/Ci/LattLong/ZIP"
#define IP2LOCATION_DB10 "Co/Re/Ci/LattLong/ZIP/ISP/Domain"
#define IP2LOCATION_DB11 "Co/Re/Ci/LattLong/ZIP/TZ"
#define IP2LOCATION_DB12 "Co/Re/Ci/LaLo/ZI/TZ/IS/Domain"
#define IP2LOCATION_DB13 "Co/Re/Ci/LaLo/TZ/NetSpeed"
#define IP2LOCATION_DB14 "Co/Re/Ci/LaLo/ZI/TZ/ISP/Do/Netspeed"
#define IP2LOCATION_DB15 "Co/Re/Ci/LaLo/ZIP/TZ/Area"
#define IP2LOCATION_DB16 "Co/Re/Ci/LaLo/ZI/TZ/IS/Do/Net/Area"
#define IP2LOCATION_DB17 "Co/Re/Ci/LaLo/TZ/Net/Weather"
#define IP2LOCATION_DB18 "Co/Re/Ci/LaLo/ZI/TZ/IS/Do/Ne/Ar/Weather"
#define IP2LOCATION_DB19 "Co/Re/Ci/LaLo/ISP/Dom/Mobile"
#define IP2LOCATION_DB20 "Co/Re/Ci/LaLo/ZI/TZ/IS/Do/Ne/Ar/We/Mo"
#define IP2LOCATION_DB21 "Co/Re/Ci/LaLo/ZI/TZ/Area/Elevation"
#define IP2LOCATION_DB22 "Co/Re/Ci/LaLo/ZI/TZ/IS/Do/Ne/Ar/We/Mo/El"
#define IP2LOCATION_DB23 "Co/Re/Ci/LaLo/ISP/Dom/Mobile/Usagetype"
#define IP2LOCATION_DB24 "Co/Re/Ci/LaLo/ZI/TZ/IS/Do/Ne/Ar/We/Mo/El/Us"


#define IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE		0x00000001
#define IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE		0x00000002
#define IPV6CALC_DB_IP2LOCATION_INTERNAL_FREE		0x00000004
#define IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6	0x00000008

/*@unused@*/ static const db_file_desc2 libipv6calc_db_wrapper_IP2Location_db_file_desc[] = {
	// sequence is important for automagic selection of the best

	/*****************/
	/**** SAMPLES ****/
	/*****************/
	// SAMPLES IPv4
	{ IP2LOCATION_IPV4_SAMPLE_DB1, 
		"IP-COUNTRY-SAMPLE.BIN", IP2LOCATION_DB1,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_COUNTRY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB2, 
		"IP-COUNTRY-ISP-SAMPLE.BIN", IP2LOCATION_DB2,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_COUNTRY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB3, 
		"IP-COUNTRY-REGION-CITY-SAMPLE.BIN", IP2LOCATION_DB3,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB4, 
		"IP-COUNTRY-REGION-CITY-ISP-SAMPLE.BIN", IP2LOCATION_DB4,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB5,
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-SAMPLE.BIN", IP2LOCATION_DB5,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB6, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-SAMPLE.BIN", IP2LOCATION_DB6,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB7, 
		"IP-COUNTRY-REGION-CITY-ISP-DOMAIN-SAMPLE.BIN", IP2LOCATION_DB7,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB8, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-SAMPLE.BIN", IP2LOCATION_DB8,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB9, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-SAMPLE.BIN", IP2LOCATION_DB9,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB10, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-ISP-DOMAIN-SAMPLE.BIN", IP2LOCATION_DB10,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB11, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-SAMPLE.BIN", IP2LOCATION_DB11,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB12, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-SAMPLE.BIN", IP2LOCATION_DB12,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB13, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-TIMEZONE-NETSPEED-SAMPLE.BIN", IP2LOCATION_DB13,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB14, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-SAMPLE.BIN", IP2LOCATION_DB14,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB15, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-AREACODE-SAMPLE.BIN", IP2LOCATION_DB15,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB16, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-SAMPLE.BIN", IP2LOCATION_DB16,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB17, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-TIMEZONE-NETSPEED-WEATHER-SAMPLE.BIN", IP2LOCATION_DB17,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB18, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-SAMPLE.BIN", IP2LOCATION_DB18,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB19, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-MOBILE-SAMPLE.BIN", IP2LOCATION_DB19,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB20, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-SAMPLE.BIN", IP2LOCATION_DB20,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB21, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-AREACODE-ELEVATION-SAMPLE.BIN", IP2LOCATION_DB21,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV4_SAMPLE_DB22, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION-SAMPLE.BIN", IP2LOCATION_DB22,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV4_SAMPLE_DB23, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-MOBILE-USAGETYPE-SAMPLE.BIN", IP2LOCATION_DB23,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV4_SAMPLE_DB24, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION-USAGETYPE-SAMPLE.BIN", IP2LOCATION_DB24,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },

	// SAMPLES IPv6
	{ IP2LOCATION_IPV6_SAMPLE_DB1, 
		"IPV6-COUNTRY.SAMPLE.BIN", IP2LOCATION_DB1,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_COUNTRY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB2, 
		"IPV6-COUNTRY-ISP.SAMPLE.BIN", IP2LOCATION_DB2,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_COUNTRY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB3, 
		"IPV6-COUNTRY-REGION-CITY.SAMPLE.BIN", IP2LOCATION_DB3,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB4, 
		"IPV6-COUNTRY-REGION-CITY-ISP.SAMPLE.BIN", IP2LOCATION_DB4,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB5, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE.SAMPLE.BIN", IP2LOCATION_DB5,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB6, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP.SAMPLE.BIN", IP2LOCATION_DB6,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB7, 
		"IPV6-COUNTRY-REGION-CITY-ISP-DOMAIN.SAMPLE.BIN", IP2LOCATION_DB7,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB8, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN.SAMPLE.BIN", IP2LOCATION_DB8,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB9, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE.SAMPLE.BIN", IP2LOCATION_DB9,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB10, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-ISP-DOMAIN.SAMPLE.BIN", IP2LOCATION_DB10,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB11, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE.SAMPLE.BIN", IP2LOCATION_DB11,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB12, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN.SAMPLE.BIN", IP2LOCATION_DB12,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB13, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-TIMEZONE-NETSPEED.SAMPLE.BIN", IP2LOCATION_DB13,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB14, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED.SAMPLE.BIN", IP2LOCATION_DB14,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB15, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-AREACODE.SAMPLE.BIN", IP2LOCATION_DB15,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB16, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE.SAMPLE.BIN", IP2LOCATION_DB16,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB17, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-TIMEZONE-NETSPEED-WEATHER.SAMPLE.BIN", IP2LOCATION_DB17,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB18, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER.SAMPLE.BIN", IP2LOCATION_DB18,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB19, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-MOBILE.SAMPLE.BIN", IP2LOCATION_DB19,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB20, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE.SAMPLE.BIN", IP2LOCATION_DB20,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB21, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-AREACODE-ELEVATION.SAMPLE.BIN", IP2LOCATION_DB21,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV6_SAMPLE_DB22, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION.SAMPLE.BIN", IP2LOCATION_DB22,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV6_SAMPLE_DB23, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-MOBILE-USAGETYPE.SAMPLE.BIN", IP2LOCATION_DB23,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV6_SAMPLE_DB24, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION-USAGETYPE.SAMPLE.BIN", IP2LOCATION_DB24,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },


	/**************/
	/**** LITE ****/
	/**************/

	// LITE IPv4
	{ IP2LOCATION_DB_IP_COUNTRY_LITE,   "IP2LOCATION-LITE-DB1.BIN"     , IP2LOCATION_DB1,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_COUNTRY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE },
	{ IP2LOCATION_DB_IP_COUNTRY_REG_CIT_LITE, "IP2LOCATION-LITE-DB3.BIN", IP2LOCATION_DB3,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE },
	{ IP2LOCATION_DB_IP_COUNTRY_REG_CIT_LL_LITE, "IP2LOCATION-LITE-DB5.BIN", IP2LOCATION_DB5,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE },
	{ IP2LOCATION_DB_IP_COUNTRY_REG_CIT_LL_ZIP_LITE, "IP2LOCATION-LITE-DB9.BIN", IP2LOCATION_DB9,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE },
	{ IP2LOCATION_DB_IP_COUNTRY_REG_CIT_LL_ZIP_TZ_LITE, "IP2LOCATION-LITE-DB11.BIN", IP2LOCATION_DB11,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE },

	// LITE IPv6
	{ IP2LOCATION_DB_IPV6_COUNTRY_LITE, "IP2LOCATION-LITE-DB1.IPV6.BIN", IP2LOCATION_DB1,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_COUNTRY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_COUNTRY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE }, // having also IPv4 included
	{ IP2LOCATION_DB_IPV6_COUNTRY_REG_CIT_LITE, "IP2LOCATION-LITE-DB3.IPV6.BIN", IP2LOCATION_DB2,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE }, // having also IPv4 included
	{ IP2LOCATION_DB_IPV6_COUNTRY_REG_CIT_LL_LITE, "IP2LOCATION-LITE-DB5.IPV6.BIN", IP2LOCATION_DB5,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE }, // having also IPv4 included
	{ IP2LOCATION_DB_IPV6_COUNTRY_REG_CIT_LL_ZIP_LITE, "IP2LOCATION-LITE-DB9.IPV6.BIN", IP2LOCATION_DB9,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE }, // having also IPv4 included
	{ IP2LOCATION_DB_IPV6_COUNTRY_REG_CIT_LL_ZIP_TZ_LITE, "IP2LOCATION-LITE-DB11.IPV6.BIN", IP2LOCATION_DB11,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE }, // having also IPv4 included


	/**************/
	/* commercial */
	/**************/

	// Commercial IPv4
	{ IP2LOCATION_IPV4_DB1, 
		"IP-COUNTRY.BIN", IP2LOCATION_DB1,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_COUNTRY, 0 },
	{ IP2LOCATION_IPV4_DB2, 
		"IP-COUNTRY-ISP.BIN", IP2LOCATION_DB2,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_COUNTRY, 0 },
	{ IP2LOCATION_IPV4_DB3, 
		"IP-COUNTRY-REGION-CITY.BIN", IP2LOCATION_DB3,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB4, 
		"IP-COUNTRY-REGION-CITY-ISP.BIN", IP2LOCATION_DB4,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB5, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE.BIN", IP2LOCATION_DB5,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB6, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP.BIN", IP2LOCATION_DB6,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB7, 
		"IP-COUNTRY-REGION-CITY-ISP-DOMAIN.BIN", IP2LOCATION_DB7,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB8, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN.BIN", IP2LOCATION_DB8,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB9, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE.BIN", IP2LOCATION_DB9,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB10, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-ISP-DOMAIN.BIN", IP2LOCATION_DB10,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB11, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE.BIN", IP2LOCATION_DB11,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB12, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN.BIN", IP2LOCATION_DB12,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB13, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-TIMEZONE-NETSPEED.BIN", IP2LOCATION_DB13,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB14, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED.BIN", IP2LOCATION_DB14,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB15, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-AREACODE.BIN", IP2LOCATION_DB15,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB16, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE.BIN", IP2LOCATION_DB16,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB17, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-TIMEZONE-NETSPEED-WEATHER.BIN", IP2LOCATION_DB17,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB18, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER.BIN", IP2LOCATION_DB18,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB19, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-MOBILE.BIN", IP2LOCATION_DB19,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB20, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE.BIN", IP2LOCATION_DB20,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB21, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-AREACODE-ELEVATION.BIN", IP2LOCATION_DB21,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV4_DB22, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION.BIN", IP2LOCATION_DB22,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV4_DB23, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-MOBILE-USAGETYPE.BIN", IP2LOCATION_DB23,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV4_DB24, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION-USAGETYPE.BIN", IP2LOCATION_DB24,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },

	// Commercial IPv6
	{ IP2LOCATION_IPV6_DB1, 
		"IPV6-COUNTRY.BIN", IP2LOCATION_DB1,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_COUNTRY, 0 },
	{ IP2LOCATION_IPV6_DB2, 
		"IPV6-COUNTRY-ISP.BIN", IP2LOCATION_DB2,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_COUNTRY, 0 },
	{ IP2LOCATION_IPV6_DB3, 
		"IPV6-COUNTRY-REGION-CITY.BIN", IP2LOCATION_DB3,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB4, 
		"IPV6-COUNTRY-REGION-CITY-ISP.BIN", IP2LOCATION_DB4,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB5, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE.BIN", IP2LOCATION_DB5,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB6, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP.BIN", IP2LOCATION_DB6,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB7, 
		"IPV6-COUNTRY-REGION-CITY-ISP-DOMAIN.BIN", IP2LOCATION_DB7,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB8, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN.BIN", IP2LOCATION_DB8,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB9, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE.BIN", IP2LOCATION_DB9,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB10, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-ISP-DOMAIN.BIN", IP2LOCATION_DB10,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB11, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE.BIN", IP2LOCATION_DB11,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB12, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN.BIN", IP2LOCATION_DB12,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB13, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-TIMEZONE-NETSPEED.BIN", IP2LOCATION_DB13,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB14, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED.BIN", IP2LOCATION_DB14,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB15, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-AREACODE.BIN", IP2LOCATION_DB15,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB16, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE.BIN", IP2LOCATION_DB16,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB17, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-TIMEZONE-NETSPEED-WEATHER.BIN", IP2LOCATION_DB17,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB18, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER.BIN", IP2LOCATION_DB18,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB19, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-MOBILE.BIN", IP2LOCATION_DB19,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB20, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE.BIN", IP2LOCATION_DB20,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, 0 },
	{ IP2LOCATION_IPV6_DB21, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-AREACODE-ELEVATION.BIN", IP2LOCATION_DB21,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV6_DB22, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION.BIN", IP2LOCATION_DB22,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV6_DB23, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-MOBILE-USAGETYPE.BIN", IP2LOCATION_DB23,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV6_DB24,
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION-USAGETYPE.BIN", IP2LOCATION_DB24,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },


	/*****************/
	/**** SPECIAL ****/
	/*****************/
	{ IP2LOCATION_DB_IPV6_COUNTRY_FREE, 
		"IPV6-COUNTRY-FREE.BIN", IP2LOCATION_DB1,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_COUNTRY, IPV6CALC_DB_IP2LOCATION_INTERNAL_FREE },
};

// features
extern uint32_t wrapper_features_IP2Location;

/* text representations */
/*@unused@*/ static const s_type libipv6calc_db_wrapper_IP2Location_support[] = {
	{ IP2LOCATION_SUPPORT_UNKNOWN,		"unknown" },
	{ IP2LOCATION_SUPPORT_COMPAT,		"compat" },
	{ IP2LOCATION_SUPPORT_FULL,		"full" },
	{ IP2LOCATION_SUPPORT_NOTEXISTS,	"not-exists" },
};

/* text representations */
/*@unused@*/ static const s_type libipv6calc_db_wrapper_IP2Location_IPv6_support[] = {
	{ IP2LOCATION_IPV6_SUPPORT_UNKNOWN,	"unknown" },
	{ IP2LOCATION_IPV6_SUPPORT_COMPAT,	"compat" },
	{ IP2LOCATION_IPV6_SUPPORT_FULL,	"full" },
	{ IP2LOCATION_IPV6_SUPPORT_NOTEXISTS,	"not-exists" },
};


/* IP2Location Usage Type explanation
    see also: http://www.ip2location.com/databases/db24-ip-country-region-city-latitude-longitude-zipcode-timezone-isp-domain-netspeed-areacode-weather-mobile-elevation-usagetype
*/
static const s_type2 libipv6calc_db_wrapper_IP2Location_UsageType[] = {
	{ 0,  "Commercial"                     , "COM" },
	{ 1,  "Organization"                   , "ORG" },
	{ 2,  "Government"                     , "GOV" },
	{ 3,  "Military"                       , "MIL" },
	{ 4,  "University/College/School"      , "EDU" },
	{ 5,  "Library"                        , "LIB" },
	{ 6,  "Content Delivery Network"       , "CDN" },
	{ 7,  "Fixed Line ISP"                 , "ISP" },
	{ 8,  "Mobile ISP"                     , "MOB" },
	{ 9,  "Data Center/Web Hosting/Transit", "DCH" },
	{ 10, "Search Engine Spider"           , "SES" },
	{ 11, "Reserved"                       , "RSV" }
};


#endif

extern int         libipv6calc_db_wrapper_IP2Location_wrapper_init(void);
extern int         libipv6calc_db_wrapper_IP2Location_wrapper_cleanup(void);
extern const char *libipv6calc_db_wrapper_IP2Location_wrapper_asnum_by_addr (const char *addr, const int proto);
extern void        libipv6calc_db_wrapper_IP2Location_wrapper_info(char* string, const size_t size);
extern void        libipv6calc_db_wrapper_IP2Location_wrapper_print_db_info(const int level_verbose, const char *prefix_string);
extern char       *libipv6calc_db_wrapper_IP2Location_wrapper_db_info_used(void);

extern char       *libipv6calc_db_wrapper_IP2Location_wrapper_country_code_by_addr(char *addr, const int proto);
extern char       *libipv6calc_db_wrapper_IP2Location_wrapper_country_name_by_addr(char *addr, const int proto);

extern int         libipv6calc_db_wrapper_IP2Location_has_features(uint32_t features);

extern int         libipv6calc_db_wrapper_IP2Location_library_version_major(void);


#ifdef SUPPORT_IP2LOCATION
extern char ip2location_lib_file[NI_MAXHOST];
extern char ip2location_db_dir[NI_MAXHOST];

extern int                libipv6calc_db_wrapper_IP2Location_db_avail(int type);
extern char              *libipv6calc_db_wrapper_IP2Location_lib_version(void);
extern IP2Location       *libipv6calc_db_wrapper_IP2Location_open(char *db);
extern IP2Location       *libipv6calc_db_wrapper_IP2Location_open_type(int type);
extern int                libipv6calc_db_wrapper_IP2Location_close(IP2Location *loc);
extern IP2LocationRecord *libipv6calc_db_wrapper_IP2Location_get_all(IP2Location *loc, char *ip);
void                      libipv6calc_db_wrapper_IP2Location_free_record(IP2LocationRecord *record);

extern const char  *libipv6calc_db_wrapper_IP2Location_dbdescription(int type);
extern char        *libipv6calc_db_wrapper_IP2Location_database_info(IP2Location *loc, const int level_verbose, const int entry, const int flag_copyright);

extern IP2LocationRecord *libipv6calc_db_wrapper_IP2Location_wrapper_record_city_by_addr(char *addr, const int proto);

extern const char *libipv6calc_db_wrapper_IP2Location_UsageType_description(char *UsageType);

extern int ip2location_db_lite_to_sample_autoswitch_max_delta_months;
extern int ip2location_db_comm_to_lite_switch_min_delta_months;
extern int ip2location_db_only_type;
extern int ip2location_db_allow_softlinks;


#endif
