DESCRIPTION = "Wi-Fi RSSI logger for connected AP"
SECTION = "wifi"
LICENSE = "BSD|GPL"

FILESEXTRAPATHS_prepend := "${THISDIR}/files/wifi:"

inherit systemd

SRCREV = "${AUTOREV}"
ARTIFACTVER = "2.3"

KERNEL_VERSION = "4.9.119"

SRC_URI = "\
			file://wifi_rssi_logger.service \
			file://logWifiRssi.sh \
	    	"

INHIBIT_PACKAGE_DEBUG_SPLIT = "1"
EXCLUDE_FROM_SHLIBS = "1"
INHIBIT_PACKAGE_STRIP = "1"

INSANE_SKIP_${PN} = "${ERROR_QA} ${WARN_QA}"
INSANE_SKIP_${PN}-dev = "${ERROR_QA} ${WARN_QA}"

# Skip the unwanted steps
do_configure[noexec] = "1"
do_compile[noexec] = "1"
do_populate_sysroot[noexec] = "1"
do_populate_lic[noexec] = "1"

S = "${WORKDIR}"

do_install() {

	install -d ${D}${systemd_unitdir}/system
	install -d ${D}/lib/rdk/

	install -m 0644 ${S}/wifi_rssi_logger.service ${D}${systemd_unitdir}/system/wifi_rssi_logger.service
	install -D -m 0777  ${S}/logWifiRssi.sh ${D}/lib/rdk/logWifiRssi.sh
}

FILES_${PN} += "/lib/rdk/logWifiRssi.sh"

SYSTEMD_SERVICE_${PN} = "wifi_rssi_logger.service"
