#!/usr/bin/perl -W
# (c) 2017, Jianxin Pan.

my $err_cnt = 0;
my $err_msg = "";
my $exit = 0;

sub check_nonascii_character
{
	my $add_msg = `git diff --cached --stat -p HEAD`;
	my @add_str = split /[\n]/, $add_msg;
	my $i = 0;
	my $len = @add_str;

	for ($i = 0; $i < $len; $i = $i + 1)
	{
		if ($add_str[$i] =~ m/[^\x00-\x7f]/)
		{
			$err_cnt += 1;
			$err_msg  .= "	$add_str[$i]\n";
		}
	}
}

sub check_extra_comma_in_struct
{
#my $msg_comma = `git format-patch -1 --stdout`;
	my $msg_comma = `git diff --cached --stat -p HEAD`;

	if( $msg_comma =~ /.+\[\](\s)=(\s){(\n.*){0,},(\n)\+};/ )
	{
		$err_cnt += 1;
		$err_msg .= "	Is the extra comma in the structure necessary? it will increase the code size.\n";
	}
}

sub out_review
{
	my $out_msg = "";

	if ($err_cnt)
	{
		$out_msg = <<END;
\$ total $err_cnt errors.
${err_msg}

END

		print $out_msg;
	}
	else
	{
		print "";
	}
}

check_nonascii_character();

check_extra_comma_in_struct();

out_review();

exit $exit;
