/*
 * sound/soc/amlogic/auge/resample_hw_coeff.h
 *
 * Copyright (C) 2018 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#ifndef __RESAMPLE_HW_COEFF_H__
#define __RESAMPLE_HW_COEFF_H__

#define SINC8_FILTER_COEF_SIZE (129 * 32)

#ifdef AA_FILTER_DEBUG
#define AA_FILTER_COEF_SIZE (32)

static s32 aa_coef_a_half[AA_FILTER_COEF_SIZE] = {
	1071888850, 682703897,  2418626,  -224301306,
	-2366746,   130725205,  2282164,  -89357198,
	-2167624,   65493114,   2026802,  -49690155,
	-1864146,   38331289,   1684692,  -29737627,
	-1493853,   23024720,   1297198,  -17681100,
	-1100227,   13387710,   908158,   -9931723,
	-725734,    7161999,    557052,   -4964668,
	-405433,    3249194,    273329,   -1940211
};

static s32 aa_coef_a_quarter[AA_FILTER_COEF_SIZE] = {
	536034773,  481655564,   338657708,   158400365,
	812047,     -90688473,   -104827128,  -62173264,
	-743181,    43937876,    54060052,    33506097,
	639092,     -24414671,   -30496133,   -19084204,
	-513619,    13625521,    16983155,    10573830,
	382276,     -7160427,    -8801749,    -5389244,
	-259487,    3325899,     3972125,     2351947,
	156264,     -1215082,    -1360518,    -743909
};
#endif

static s32 sinc8_coef[SINC8_FILTER_COEF_SIZE] = {
	0x7ccccccd, 0x0323eb7f, 0xfd086246, 0x02b2aa5c,
	0xfda45e2c, 0x01fa5183, 0xfe694e12, 0x0137e672,
	0xff1c87d3, 0x009ce6d8, 0xff9a68b0, 0x003d150d,
	0xffde727a, 0x00106595, 0xfff93679, 0x00021fc5,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x7cc9b757, 0x022ac835, 0xfd7e3a71, 0x026b7da1,
	0xfdd2b905, 0x01db7c90, 0xfe7db77c, 0x012aa7bf,
	0xff24dc32, 0x0097dfc9, 0xff9d4ae9, 0x003b8742,
	0xffdf38e5, 0x00100be5, 0xfff959f5, 0x0002144b,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x7cc0773c, 0x01354bc1, 0xfdf365e8, 0x0224726d,
	0xfe011d2e, 0x01bc908b, 0xfe923a2b, 0x011d528d,
	0xff2d426f, 0x0092cbc0, 0xffa035cc, 0x0039f42e,
	0xffe00236, 0x000fb0d2, 0xfff97dfa, 0x000208b0,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x7cb10d52, 0x0043843f, 0xfe67d5a8, 0x01dd92df,
	0xfe2f83c1, 0x019d9230, 0xfea6d2e5, 0x010fe901,
	0xff35b924, 0x008dab9d, 0xffa328d4, 0x00385c1d,
	0xffe0ce46, 0x000f5471, 0xfff9a27f, 0x0001fcf5,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x7c9b7afd, 0xff557f58, 0xfedb7ae9, 0x0196e8fe,
	0xfe5de5e3, 0x017e8635, 0xfebb7e75, 0x01026d40,
	0xff3e3eed, 0x0088803e, 0xffa6237a, 0x0036bf58,
	0xffe19cec, 0x000ef6d4, 0xfff9c77d, 0x0001f11e,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x7c7fc22f, 0xfe6b4a44, 0xff4e471d, 0x01507eb8,
	0xfe8c3cc3, 0x015f714d, 0xfed039a8, 0x00f4e16f,
	0xff46d266, 0x00834a83, 0xffa9253b, 0x00351e2d,
	0xffe26e01, 0x000e980f, 0xfff9eceb, 0x0001e52e,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x7c5de56a, 0xfd84f1c8, 0xffc02bf2, 0x010a5de2,
	0xfeba819d, 0x01405821, 0xfee5014c, 0x00e747b0,
	0xff4f722b, 0x007e0b4b, 0xffac2d8f, 0x003378e7,
	0xffe3415d, 0x000e3834, 0xfffa12c0, 0x0001d927,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x7c35e7bb, 0xfca28234, 0x00311b54, 0x00c49034,
	0xfee8adba, 0x01213f58, 0xfef9d232, 0x00d9a226,
	0xff581cd8, 0x0078c375, 0xffaf3bf2, 0x0031cfd1,
	0xffe416d8, 0x000dd758, 0xfffa38f5, 0x0001cd0d,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x7c07ccbe, 0xfbc40766, 0x00a1076e, 0x007f1f4b,
	0xff16ba71, 0x01022b90, 0xff0ea931, 0x00cbf2f0,
	0xff60d10b, 0x007373de, 0xffb24fde, 0x00302337,
	0xffe4ee4b, 0x000d758d, 0xfffa5f81, 0x0001c0e1,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x7bd3989d, 0xfae98cc5, 0x010fe2ab, 0x003a14a6,
	0xff44a128, 0x00e3215e, 0xff238322, 0x00be3c2d,
	0xff698d62, 0x006e1d66, 0xffb568ce, 0x002e7363,
	0xffe5c78d, 0x000d12e6, 0xfffa865d, 0x0001b4a8,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x7b99500c, 0xfa131d41, 0x017d9fb8, 0xfff579a3,
	0xff725b54, 0x00c42551, 0xff385ce3, 0x00b07ff8,
	0xff72507e, 0x0068c0e9, 0xffb8863e, 0x002cc0a2,
	0xffe6a277, 0x000caf76, 0xfffaad81, 0x0001a863,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x7b58f84d, 0xf940c355, 0x01ea3184, 0xffb15783,
	0xff9fe27d, 0x00a53bed, 0xff4d3358, 0x00a2c06b,
	0xff7b18fe, 0x00635f45, 0xffbba7aa, 0x002b0b3d,
	0xffe77ee2, 0x000c4b50, 0xfffad4e4, 0x00019c15,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x7b12972d, 0xf8728902, 0x02558b43, 0xff6db764,
	0xffcd303b, 0x008669ae, 0xff620368, 0x0094ff9b,
	0xff83e586, 0x005df954, 0xffbecc8d, 0x00295380,
	0xffe85ca7, 0x000be687, 0xfffafc7f, 0x00018fc1,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x7ac63304, 0xf7a877d4, 0x02bfa06d, 0xff2aa243,
	0xfffa3e37, 0x0067b303, 0xff76ca02, 0x00873f9b,
	0xff8cb4bb, 0x00588ff1, 0xffc1f465, 0x002799b3,
	0xffe93b9e, 0x000b812d, 0xfffb244a, 0x0001836a,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x7a73d2b5, 0xf6e298db, 0x032864c1, 0xfee820f8,
	0x00270631, 0x00491c54, 0xff8b841a, 0x0079827a,
	0xff958542, 0x005323f7, 0xffc51eaf, 0x0025de22,
	0xffea1ba2, 0x000b1b55, 0xfffb4c3e, 0x00017712,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x7a1b7daa, 0xf620f4b2, 0x038fcc44, 0xfea63c38,
	0x005381fa, 0x002aa9fa, 0xffa02eac, 0x006bca44,
	0xff9e55c6, 0x004db63c, 0xffc84ae9, 0x00242115,
	0xffeafc8b, 0x000ab510, 0xfffb7452, 0x00016abb,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x79bd3bd8, 0xf5639376, 0x03f5cb46, 0xfe64fc93,
	0x007fab77, 0x000c6043, 0xffb4c6b9, 0x005e1900,
	0xffa724f0, 0x00484799, 0xffcb7893, 0x002262d6,
	0xffebde33, 0x000a4e72, 0xfffb9c80, 0x00015e68,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x795915bc, 0xf4aa7cce, 0x045a565c, 0xfe246a72,
	0x00ab7ca6, 0xffee4372, 0xffc9494b, 0x005070b0,
	0xffaff16f, 0x0042d8e1, 0xffcea72c, 0x0020a3ad,
	0xffecc075, 0x0009e78c, 0xfffbc4bf, 0x0001521b,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x78ef1457, 0xf3f5b7e4, 0x04bd6269, 0xfde48e17,
	0x00d6ef99, 0xffd057bb, 0xffddb374, 0x0042d353,
	0xffb8b9f3, 0x003d6aea, 0xffd1d635, 0x001ee3e1,
	0xffeda32a, 0x00098070, 0xfffbed0a, 0x000145d7,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x787f4134, 0xf3454b6a, 0x051ee498, 0xfda56f9c,
	0x0101fe7a, 0xffb2a145, 0xfff2024e, 0x003542e2,
	0xffc17d30, 0x0037fe85, 0xffd50530, 0x001d23b9,
	0xffee862e, 0x0009192f, 0xfffc1558, 0x0001399e,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x7809a65e, 0xf2993d95, 0x057ed264, 0xfd6716f2,
	0x012ca389, 0xff952429, 0x000632fa, 0x0027c151,
	0xffca39dd, 0x00329483, 0xffd833a0, 0x001b637e,
	0xffef695c, 0x0008b1db, 0xfffc3da2, 0x00012d72,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x778e4e68, 0xf1f19421, 0x05dd218f, 0xfd298be0,
	0x0156d920, 0xff77e470, 0x001a42a4, 0x001a508e,
	0xffd2eeb3, 0x002d2db0, 0xffdb6109, 0x0019a373,
	0xfff04c8f, 0x00084a86, 0xfffc65e2, 0x00012155,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x770d4466, 0xf14e544f, 0x0639c82d, 0xfcecd602,
	0x018099b2, 0xff5ae614, 0x002e2e82, 0x000cf281,
	0xffdb9a70, 0x0027cada, 0xffde8cf1, 0x0017e3df,
	0xfff12fa3, 0x0007e33f, 0xfffc8e11, 0x0001154a,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x768693ec, 0xf0af82e4, 0x0694bca0, 0xfcb0fcca,
	0x01a9dfcc, 0xff3e2d01, 0x0041f3d2, 0xffffa90e,
	0xffe43bd5, 0x00226ccb, 0xffe1b6dd, 0x00162507,
	0xfff21275, 0x00077c17, 0xfffcb628, 0x00010952,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x75fa4911, 0xf015242b, 0x06edf595, 0xfc76077b,
	0x01d2a615, 0xff21bd11, 0x00558fdc, 0xfff27611,
	0xffecd1a6, 0x001d144a, 0xffe4de56, 0x0014672d,
	0xfff2f4e0, 0x00071520, 0xfffcde20, 0x0000fd6f,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x75687068, 0xef7f3bf5, 0x07456a0e, 0xfc3bfd2e,
	0x01fae74e, 0xff059a0e, 0x0068fff3, 0xffe55b60,
	0xfff55aae, 0x0017c21c, 0xffe802e6, 0x0012aa95,
	0xfff3d6c3, 0x0006ae6a, 0xfffd05f3, 0x0000f1a4,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x74d11703, 0xeeedcd98, 0x079b1158, 0xfc02e4cc,
	0x02229e57, 0xfee9c7af, 0x007c4177, 0xffd85ac9,
	0xfffdd5b8, 0x00127704, 0xffeb2416, 0x0010ef82,
	0xfff4b7fb, 0x00064804, 0xfffd2d9b, 0x0000e5f3,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x74344a70, 0xee60dbee, 0x07eee314, 0xfbcac510,
	0x0249c629, 0xfece499d, 0x008f51cf, 0xffcb7615,
	0x00064197, 0x000d33c3, 0xffee4174, 0x000f3633,
	0xfff59866, 0x0005e1fe, 0xfffd5511, 0x0000da5c,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x739218b8, 0xedd86958, 0x0840d732, 0xfb93a486,
	0x027059da, 0xfeb3236b, 0x00a22e71, 0xffbeaf06,
	0x000e9d1f, 0x0007f915, 0xfff15a8d, 0x000d7eea,
	0xfff677e2, 0x00057c68, 0xfffd7c4f, 0x0000cee3,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x72ea905a, 0xed5477be, 0x0890e5f7, 0xfb5d898c,
	0x029654a0, 0xfe98589b, 0x00b4d4dd, 0xffb20754,
	0x0016e72c, 0x0002c7b6, 0xfff46ef1, 0x000bc9e6,
	0xfff75650, 0x00051750, 0xfffda350, 0x0000c388,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x723dc051, 0xecd5088e, 0x08df07f6, 0xfb287a4d,
	0x02bbb1cc, 0xfe7dec9c, 0x00c7429f, 0xffa580b1,
	0x001f1e9b, 0xfffda05c, 0xfff77e31, 0x000a1765,
	0xfff8338e, 0x0004b2c7, 0xfffdca0d, 0x0000b84d,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x718bb80b, 0xec5a1cbc, 0x092b3617, 0xfaf47cc4,
	0x02e06ccf, 0xfe63e2cc, 0x00d97550, 0xff991cc9,
	0x00274253, 0xfff883be, 0xfffa87df, 0x000867a5,
	0xfff90f7c, 0x00044eda, 0xfffdf080, 0x0000ad34,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x70d4876b, 0xebe3b4c5, 0x09756994, 0xfac196bb,
	0x03048139, 0xfe4a3e70, 0x00eb6a95, 0xff8cdd3c,
	0x002f513a, 0xfff3728d, 0xfffd8b92, 0x0006bae1,
	0xfff9e9fd, 0x0003eb98, 0xfffe16a6, 0x0000a23f,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x70183ec5, 0xeb71d0ab, 0x09bd9bfb, 0xfa8fcdca,
	0x0327eab8, 0xfe3102bd, 0x00fd2022, 0xff80c3a4,
	0x00374a40, 0xffee6d78, 0x000088df, 0x00051157,
	0xfffac2f0, 0x0003890e, 0xfffe3c76, 0x0000976e,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x6f56eee1, 0xeb046ffc, 0x0a03c72b, 0xfa5f2755,
	0x034aa51b, 0xfe1832d4, 0x010e93b5, 0xff74d194,
	0x003f2c57, 0xffe97529, 0x00037f60, 0x00036b3f,
	0xfffb9a38, 0x0003274c, 0xfffe61ee, 0x00008cc4,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x6e90a8f2, 0xea9b91cc, 0x0a47e559, 0xfa2fa890,
	0x036cac52, 0xfdffd1bd, 0x011fc31c, 0xff690894,
	0x0046f679, 0xffe48a4a, 0x00066eae, 0x0001c8d2,
	0xfffc6fb8, 0x0002c65d, 0xfffe8707, 0x00008241,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x6dc57e9b, 0xea3734bb, 0x0a89f10c, 0xfa015679,
	0x038dfc6c, 0xfde7e26f, 0x0130ac31, 0xff5d6a24,
	0x004ea7a3, 0xffdfad7f, 0x00095666, 0x00002a4a,
	0xfffd4352, 0x00026650, 0xfffeabbd, 0x000077e8,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x6cf581e8, 0xe9d756f3, 0x0ac9e521, 0xf9d435dc,
	0x03ae919a, 0xfdd067ca, 0x01414cdd, 0xff51f7bb,
	0x00563edb, 0xffdadf69, 0x000c3627, 0xfffe8fdc,
	0xfffe14eb, 0x00020730, 0xfffed00a, 0x00006db9,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x6c20c550, 0xe97bf627, 0x0b07bcc6, 0xf9a84b50,
	0x03ce682d, 0xfdb96498, 0x0151a317, 0xff46b2c7,
	0x005dbb29, 0xffd620a6, 0x000f0d91, 0xfffcf9be,
	0xfffee466, 0x0001a90b, 0xfffef3ea, 0x000063b5,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x6b475bb0, 0xe9250f99, 0x0b437380, 0xf97d9b37,
	0x03ed7c9a, 0xfda2db8c, 0x0161ace5, 0xff3b9cad,
	0x00651b9c, 0xffd171d1, 0x0011dc47, 0xfffb6825,
	0xffffb1aa, 0x00014bed, 0xffff1759, 0x000059dd,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x6a69584a, 0xe8d2a017, 0x0b7d0525, 0xf95429c0,
	0x040bcb77, 0xfd8ccf46, 0x01716859, 0xff30b6c8,
	0x006c5f4b, 0xffccd380, 0x0014a1ee, 0xfff9db44,
	0x00007c9c, 0x0000efe1, 0xffff3a53, 0x00005033,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x6986cec4, 0xe884a3fb, 0x0bb46de2, 0xf92bfae4,
	0x0429517b, 0xfd77424c, 0x0180d397, 0xff260269,
	0x00738551, 0xffc84645, 0x00175e2d, 0xfff8534d,
	0x00014521, 0x000094f3, 0xffff5cd2, 0x000046b8,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x689fd324, 0xe83b1731, 0x0be9aa34, 0xf9051266,
	0x04460b81, 0xfd62370e, 0x018fecd1, 0xff1b80da,
	0x007a8cd0, 0xffc3cab1, 0x001a10ad, 0xfff6d070,
	0x00020b23, 0x00003b2e, 0xffff7ed3, 0x00003d6c,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x67b479cf, 0xe7f5f531, 0x0c1cb6ef, 0xf8df73d6,
	0x0461f688, 0xfd4dafe6, 0x019eb246, 0xff113358,
	0x008174ef, 0xffbf614e, 0x001cb91a, 0xfff552de,
	0x0002ce87, 0xffffe29d, 0xffffa052, 0x00003450,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x66c4d787, 0xe7b53908, 0x0c4d913a, 0xf8bb228c,
	0x047d0fb1, 0xfd39af17, 0x01ad2249, 0xff071b16,
	0x00883cdc, 0xffbb0aa3, 0x001f5723, 0xfff3dac3,
	0x00038f37, 0xffff8b4b, 0xffffc14b, 0x00002b66,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x65d10168, 0xe778dd50, 0x0c7c368d, 0xf89821ac,
	0x0497543f, 0xfd2636ca, 0x01bb3b37, 0xfefd3941,
	0x008ee3cd, 0xffb6c735, 0x0021ea76, 0xfff2684e,
	0x00044d1b, 0xffff3540, 0xffffe1bc, 0x000022ad,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x64d90ce7, 0xe740dc3c, 0x0ca8a4b7, 0xf8767422,
	0x04b0c19a, 0xfd134913, 0x01c8fb81, 0xfef38ef6,
	0x009568fc, 0xffb29782, 0x002472c8, 0xfff0fba9,
	0x0005081f, 0xfffee088, 0x0000019f, 0x00001a28,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x63dd0fcd, 0xe70d2f8d, 0x0cd2d9d5, 0xf8561ca7,
	0x04c9554e, 0xfd00e7ec, 0x01d661a6, 0xfeea1d4c,
	0x009bcbab, 0xffae7c06, 0x0026efcc, 0xffef94fe,
	0x0005c02c, 0xfffe8d2c, 0x000020f3, 0x000011d5,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x62dd2039, 0xe6ddd09f, 0x0cfad45a, 0xf8371dbb,
	0x04e10d0a, 0xfcef153a, 0x01e36c34, 0xfee0e54e,
	0x00a20b23, 0xffaa7538, 0x0029613a, 0xffee3477,
	0x0006752d, 0xfffe3b35, 0x00003fb3, 0x000009b6,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x61d95497, 0xe6b2b862, 0x0d209309, 0xf81979ab,
	0x04f7e6a2, 0xfcddd2c7, 0x01f019cb, 0xfed7e7fd,
	0x00a826b2, 0xffa6838c, 0x002bc6cd, 0xffecda3b,
	0x0007270f, 0xfffdeaaa, 0x00005ddd, 0x000001cc,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x60d1c3a6, 0xe68bdf5e, 0x0d4414f9, 0xf7fd328c,
	0x050de00d, 0xfccd2246, 0x01fc691b, 0xfecf2650,
	0x00ae1dae, 0xffa2a770, 0x002e2040, 0xffeb866f,
	0x0007d5bf, 0xfffd9b96, 0x00007b6f, 0xfffffa17,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x5fc68470, 0xe6693db5, 0x0d65598f, 0xf7e24a3c,
	0x0522f766, 0xfcbd0551, 0x020858e2, 0xfec6a130,
	0x00b3ef73, 0xff9ee150, 0x00306d52, 0xffea3939,
	0x0008812a, 0xfffd4dff, 0x00009865, 0xfffff297,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x5eb7ae46, 0xe64acb24, 0x0d846084, 0xf7c8c267,
	0x05372aee, 0xfcad7d6b, 0x0213e7f0, 0xfebe5980,
	0x00b99b65, 0xff9b3192, 0x0032adc4, 0xffe8f2bb,
	0x0009293e, 0xfffd01ee, 0x0000b4bd, 0xffffeb4c,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x5da558c5, 0xe6307f05, 0x0da129df, 0xf7b09c7f,
	0x054a7909, 0xfc9e8bfd, 0x021f1526, 0xfeb65015,
	0x00bf20ee, 0xff979898, 0x0034e15b, 0xffe7b317,
	0x0009cdeb, 0xfffcb769, 0x0000d074, 0xffffe438,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x5c8f9bcb, 0xe61a504f, 0x0dbbb5f6, 0xf799d9c4,
	0x055ce03f, 0xfc903258, 0x0229df75, 0xfeae85bb,
	0x00c47f7f, 0xff9416c1, 0x003707dc, 0xffe67a6f,
	0x000a6f20, 0xfffc6e78, 0x0000eb89, 0xffffdd5a,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x5b768f7a, 0xe6083599, 0x0dd40571, 0xf7847b3d,
	0x056e5f3d, 0xfc8271b4, 0x023445dd, 0xfea6fb32,
	0x00c9b691, 0xff90ac66, 0x00392111, 0xffe548e0,
	0x000b0cce, 0xfffc2720, 0x000105f9, 0xffffd6b2,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x5a5a4c32, 0xe5fa2519, 0x0dea1943, 0xf77081be,
	0x057ef4d3, 0xfc754b32, 0x023e4772, 0xfe9fb12e,
	0x00cec5a1, 0xff8d59dd, 0x003b2cc5, 0xffe41e88,
	0x000ba6e5, 0xfffbe169, 0x00011fc3, 0xffffd041,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x593aea93, 0xe5f014aa, 0x0dfdf2ae, 0xf75dede5,
	0x058e9ff8, 0xfc68bfd7, 0x0247e354, 0xfe98a85b,
	0x00d3ac38, 0xff8a1f77, 0x003d2ac6, 0xffe2fb83,
	0x000c3d59, 0xfffb9d59, 0x000138e4, 0xffffca06,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x58188376, 0xe5e9f9ca, 0x0e0f9342, 0xf74cc01c,
	0x059d5fc5, 0xfc5cd092, 0x025118b8, 0xfe91e159,
	0x00d869e1, 0xff86fd81, 0x003f1ae4, 0xffe1dfec,
	0x000cd01b, 0xfffb5af3, 0x0001515c, 0xffffc402,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x56f32fea, 0xe5e7c99e, 0x0e1efcdb, 0xf73cf898,
	0x05ab3377, 0xfc517e38, 0x0259e6e1, 0xfe8b5cba,
	0x00dcfe32, 0xff83f443, 0x0040fcf3, 0xffe0cbdc,
	0x000d5f1f, 0xfffb1a3f, 0x00016928, 0xffffbe35,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x55cb0935, 0xe5e978f0, 0x0e2c319d, 0xf72e9758,
	0x05b81a70, 0xfc46c987, 0x02624d23, 0xfe851b09,
	0x00e168c5, 0xff810401, 0x0042d0c9, 0xffdfbf6b,
	0x000dea5a, 0xfffadb40, 0x00018048, 0xffffb89f,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x54a028d0, 0xe5eefc35, 0x0e3733fc, 0xf7219c2a,
	0x05c41435, 0xfc3cb323, 0x026a4ae5, 0xfe7f1cc4,
	0x00e5a93c, 0xff7e2cfb, 0x0044963d, 0xffdebaaf,
	0x000e71c1, 0xfffa9dfa, 0x000196ba, 0xffffb340,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x5372a862, 0xe5f8478d, 0x0e4006b2, 0xf71606a6,
	0x05cf2070, 0xfc333b97, 0x0271df9c, 0xfe79625e,
	0x00e9bf43, 0xff7b6f6c, 0x00464d2b, 0xffddbdbd,
	0x000ef549, 0xfffa6273, 0x0001ac7d, 0xffffae17,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x5242a1c1, 0xe6054ec6, 0x0e46acc4, 0xf70bd632,
	0x05d93eee, 0xfc2a6356, 0x02790ace, 0xfe73ec40,
	0x00edaa88, 0xff78cb8c, 0x0047f571, 0xffdcc8a9,
	0x000f74e9, 0xfffa28ad, 0x0001c191, 0xffffa924,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x51102eec, 0xe616055a, 0x0e4b297c, 0xf7030a01,
	0x05e26f9f, 0xfc222abb, 0x027fcc12, 0xfe6ebac6,
	0x00f16ac4, 0xff76418b, 0x00498eed, 0xffdbdb84,
	0x000ff098, 0xfff9f0ac, 0x0001d5f4, 0xffffa467,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4fdb6a09, 0xe62a5e76, 0x0e4d806f, 0xf6fba113,
	0x05eab296, 0xfc1a9208, 0x02862311, 0xfe69ce43,
	0x00f4ffb6, 0xff73d199, 0x004b1984, 0xffdaf65e,
	0x0010684e, 0xfff9ba73, 0x0001e9a7, 0xffff9fe0,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4ea46d66, 0xe6424cf8, 0x0e4db575, 0xf6f59a36,
	0x05f20809, 0xfc139968, 0x028c0f83, 0xfe6526fe,
	0x00f86924, 0xff717bdf, 0x004c951b, 0xffda1948,
	0x0010dc05, 0xfff98604, 0x0001fca8, 0xffff9b8f,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4d6b536f, 0xe65dc373, 0x0e4bccac, 0xf6f0f407,
	0x05f87053, 0xfc0d40ec, 0x0291912f, 0xfe60c533,
	0x00fba6da, 0xff6f4083, 0x004e0199, 0xffd9444e,
	0x00114bb4, 0xfff95363, 0x00020ef7, 0xffff9773,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4c3036b2, 0xe67cb42f, 0x0e47ca78, 0xf6edacf2,
	0x05fdebee, 0xfc07888e, 0x0296a7f0, 0xfe5ca913,
	0x00feb8ad, 0xff6d1fa5, 0x004f5ee9, 0xffd8777d,
	0x0011b757, 0xfff92290, 0x00022095, 0xffff938c,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4af331d9, 0xe69f112f, 0x0e41b37c, 0xf6ebc332,
	0x06027b78, 0xfc027031, 0x029b53af, 0xfe58d2c5,
	0x01019e78, 0xff6b1961, 0x0050acf7, 0xffd7b2e0,
	0x00121ee9, 0xfff8f38e, 0x00023181, 0xffff8fd9,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x49b45fa8, 0xe6c4cc2e, 0x0e398c9f, 0xf6eb34d4,
	0x06061fb2, 0xfbfdf79e, 0x029f9466, 0xfe554265,
	0x0104581c, 0xff692dd2, 0x0051ebb4, 0xffd6f67f,
	0x00128265, 0xfff8c65d, 0x000241bb, 0xffff8c5a,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4873daf7, 0xe6edd6a4, 0x0e2f5b0b, 0xf6ebffb2,
	0x0608d97c, 0xfbfa1e88, 0x02a36a1e, 0xfe51f802,
	0x0106e583, 0xff675d09, 0x00531b12, 0xffd64264,
	0x0012e1c8, 0xfff89b00, 0x00025143, 0xffff890e,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4731beb7, 0xe71a21c7, 0x0e232425, 0xf6ee217b,
	0x060aa9da, 0xfbf6e48c, 0x02a6d4f0, 0xfe4ef3a4,
	0x0109469d, 0xff65a718, 0x00543b04, 0xffd59695,
	0x00133d0e, 0xfff87176, 0x0002601b, 0xffff85f5,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x45ee25e7, 0xe7499e8f, 0x0e14ed93, 0xf6f197ad,
	0x060b91ee, 0xfbf4492d, 0x02a9d508, 0xfe4c3546,
	0x010b7b61, 0xff640c08, 0x00554b83, 0xffd4f316,
	0x00139436, 0xfff849c0, 0x00026e41, 0xffff830e,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x44a92b96, 0xe77c3db4, 0x0e04bd39, 0xf6f65f9b,
	0x060b92ff, 0xfbf24bd9, 0x02ac6a9e, 0xfe49bcd9,
	0x010d83cb, 0xff628be3, 0x00564c88, 0xffd457ec,
	0x0013e73e, 0xfff823dd, 0x00027bb8, 0xffff805a,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4362eadc, 0xe7b1efb4, 0x0df29936, 0xf6fc766a,
	0x060aae6e, 0xfbf0ebe7, 0x02ae95fb, 0xfe478a42,
	0x010f5fe2, 0xff6126a9, 0x00573e0f, 0xffd3c519,
	0x00143626, 0xfff7ffce, 0x0002887f, 0xffff7dd6,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x421b7edf, 0xe7eaa4d4, 0x0dde87e2, 0xf703d912,
	0x0608e5c2, 0xfbf02896, 0x02b05779, 0xfe459d5e,
	0x01110faf, 0xff5fdc5b, 0x00582016, 0xffd33a9e,
	0x001480ec, 0xfff7dd92, 0x00029497, 0xffff7b82,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x40d302c5, 0xe8264d21, 0x0dc88fd2, 0xf70c8461,
	0x06063a9d, 0xfbf00112, 0x02b1af7f, 0xfe43f5ff,
	0x01129344, 0xff5eacf3, 0x0058f29f, 0xffd2b87c,
	0x0014c792, 0xfff7bd28, 0x0002a002, 0xffff795f,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x3f8991bd, 0xe864d874, 0x0db0b7d1, 0xf71674fa,
	0x0602aec3, 0xfbf0746e, 0x02b29e84, 0xfe4293ec,
	0x0113eabb, 0xff5d9867, 0x0059b5ad, 0xffd23eaf,
	0x00150a19, 0xfff79e8f, 0x0002aac0, 0xffff776a,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x3e3f46f2, 0xe8a63671, 0x0d9706e1, 0xf721a756,
	0x05fe4414, 0xfbf181a9, 0x02b3250f, 0xfe4176e2,
	0x01151632, 0xff5c9eaa, 0x005a6946, 0xffd1cd37,
	0x00154883, 0xfff781c5, 0x0002b4d2, 0xffff75a3,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x3cf43d8f, 0xe8ea568f, 0x0d7b843b, 0xf72e17c4,
	0x05f8fc8f, 0xfbf327ab, 0x02b343b5, 0xfe409e95,
	0x011615ce, 0xff5bbfaa, 0x005b0d72, 0xffd1640e,
	0x001582d3, 0xfff766c8, 0x0002be3b, 0xffff740a,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x3ba890b9, 0xe9312813, 0x0d5e3749, 0xf73bc26b,
	0x05f2da52, 0xfbf56549, 0x02b2fb1a, 0xfe400aae,
	0x0116e9bc, 0xff5afb53, 0x005ba23b, 0xffd1032f,
	0x0015b90b, 0xfff74d97, 0x0002c6fa, 0xffff729e,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x3a5c5b8e, 0xe97a9a17, 0x0d3f27ab, 0xf74aa34c,
	0x05ebdf97, 0xfbf83941, 0x02b24bf1, 0xfe3fbacd,
	0x0117922f, 0xff5a5189, 0x005c27af, 0xffd0aa93,
	0x0015eb2f, 0xfff7362f, 0x0002cf12, 0xffff715d,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x390fb920, 0xe9c69b8c, 0x0d1e5d32, 0xf75ab63f,
	0x05e40eb3, 0xfbfba23f, 0x02b136f9, 0xfe3fae87,
	0x01180f5d, 0xff59c230, 0x005c9ddc, 0xffd05a33,
	0x00161944, 0xfff7208d, 0x0002d684, 0xffff7047,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x37c2c474, 0xea151b3a, 0x0cfbdfdd, 0xf76bf6f7,
	0x05db6a19, 0xfbff9ed7, 0x02afbd02, 0xfe3fe569,
	0x01186187, 0xff594d27, 0x005d04d4, 0xffd01205,
	0x0016434f, 0xfff70caf, 0x0002dd53, 0xffff6f5c,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x36759880, 0xea6607c4, 0x0cd7b7dd, 0xf77e6103,
	0x05d1f459, 0xfc042d8e, 0x02addee8, 0xfe405ef6,
	0x011888f2, 0xff58f249, 0x005d5cab, 0xffcfd1ff,
	0x00166956, 0xfff6fa92, 0x0002e37e, 0xffff6e99,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x35285026, 0xeab94fa9, 0x0cb1ed8c, 0xf791efcb,
	0x05c7b01a, 0xfc094cd2, 0x02ab9d96, 0xfe411aa8,
	0x011885e7, 0xff58b16c, 0x005da575, 0xffcf9a15,
	0x00168b5e, 0xfff6ea31, 0x0002e90a, 0xffff6dff,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x33db0631, 0xeb0ee148, 0x0c8a8973, 0xf7a69e96,
	0x05bca021, 0xfc0efafe, 0x02a8fa03, 0xfe4217ef,
	0x011858b9, 0xff588a65, 0x005ddf4c, 0xffcf6a3b,
	0x0016a96f, 0xfff6db89, 0x0002edf6, 0xffff6d8d,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x328dd556, 0xeb66aae0, 0x0c619444, 0xf7bc6889,
	0x05b0c74b, 0xfc15365c, 0x02a5f535, 0xfe435633,
	0x011801be, 0xff587d03, 0x005e0a48, 0xffcf4262,
	0x0016c390, 0xfff6ce97, 0x0002f246, 0xffff6d40,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x3140d82e, 0xebc09a94, 0x0c3716da, 0xf7d348a4,
	0x05a42890, 0xfc1bfd22, 0x02a2903e, 0xfe44d4d3,
	0x01178152, 0xff588913, 0x005e2687, 0xffcf227b,
	0x0016d9c9, 0xfff6c356, 0x0002f5fc, 0xffff6d1a,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2ff42933, 0xec1c9e6d, 0x0c0b1a37, 0xf7eb39cc,
	0x0596c6ff, 0xfc234d75, 0x029ecc3c, 0xfe469325,
	0x0116d7d7, 0xff58ae5d, 0x005e3427, 0xffcf0a77,
	0x0016ec22, 0xfff6b9c1, 0x0002f919, 0xffff6d17,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2ea7e2c0, 0xec7aa45b, 0x0bdda783, 0xf80436c0,
	0x0588a5bf, 0xfc2b2567, 0x029aaa5a, 0xfe489077,
	0x011605b5, 0xff58eca8, 0x005e3347, 0xffcefa44,
	0x0016faa5, 0xfff6b1d5, 0x0002fba0, 0xffff6d38,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2d5c1f0e, 0xecda9a39, 0x0baec80a, 0xf81e3a25,
	0x0579c812, 0xfc3382fb, 0x02962bd1, 0xfe4acc0e,
	0x01150b5a, 0xff5943b4, 0x005e240a, 0xffcef1cf,
	0x0017055b, 0xfff6ab8c, 0x0002fd94, 0xffff6d7c,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2c10f82d, 0xed3c6dce, 0x0b7e853c, 0xf8393e81,
	0x056a314b, 0xfc3c6420, 0x029151e3, 0xfe4d4526,
	0x0113e937, 0xff59b340, 0x005e0694, 0xffcef106,
	0x00170c4f, 0xfff6a6e2, 0x0002fef6, 0xffff6de2,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2ac68807, 0xeda00cd1, 0x0b4ce8a8, 0xf8553e3c,
	0x0559e4da, 0xfc45c6b6, 0x028c1de0, 0xfe4ffaf6,
	0x01129fc5, 0xff5a3b09, 0x005ddb0b, 0xffcef7d4,
	0x00170f8a, 0xfff6a3d0, 0x0002ffc9, 0xffff6e67,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x297ce85a, 0xee0564e8, 0x0b19fbfe, 0xf87233a4,
	0x0548e63f, 0xfc4fa88f, 0x02869122, 0xfe52ecab,
	0x01112f81, 0xff5adac6, 0x005da198, 0xffcf0623,
	0x00170f18, 0xfff6a252, 0x00030010, 0xffff6f0d,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x283432b9, 0xee6c63ad, 0x0ae5c90b, 0xf89018eb,
	0x05373912, 0xfc5a076a, 0x0280ad0f, 0xfe561969,
	0x010f98eb, 0xff5b922d, 0x005d5a62, 0xffcf1bde,
	0x00170b04, 0xfff6a262, 0x0002ffcd, 0xffff6fd1,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x26ec8083, 0xeed4f6b0, 0x0ab059bc, 0xf8aee828,
	0x0524e100, 0xfc64e0f9, 0x027a7318, 0xfe598050,
	0x010ddc8c, 0xff5c60ee, 0x005d0597, 0xffcf38ec,
	0x0017035a, 0xfff6a3f9, 0x0002ff03, 0xffff70b2,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x25a5eae8, 0xef3f0b78, 0x0a79b814, 0xf8ce9b5d,
	0x0511e1c6, 0xfc7032de, 0x0273e4b8, 0xfe5d2075,
	0x010bfaee, 0xff5d46bb, 0x005ca363, 0xffcf5d36,
	0x0016f828, 0xfff6a713, 0x0002fdb4, 0xffff71b0,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x24608ae2, 0xefaa8f87, 0x0a41ee32, 0xf8ef2c71,
	0x04fe3f39, 0xfc7bfaad, 0x026d0374, 0xfe60f8ea,
	0x0109f4a2, 0xff5e433e, 0x005c33f6, 0xffcf88a2,
	0x0016e979, 0xfff6aba9, 0x0002fbe4, 0xffff72c9,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x231c7932, 0xf017705a, 0x0a09064e, 0xf9109535,
	0x04e9fd3c, 0xfc8835ed, 0x0265d0dd, 0xfe6508b6,
	0x0107ca3c, 0xff5f5621, 0x005bb77f, 0xffcfbb17,
	0x0016d75b, 0xfff6b1b4, 0x0002f995, 0xffff73fc,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x21d9ce63, 0xf0859b6e, 0x09cf0ab4, 0xf932cf65,
	0x04d51fc6, 0xfc94e216, 0x025e4e8b, 0xfe694edd,
	0x01057c57, 0xff607f0b, 0x005b2e31, 0xffcff478,
	0x0016c1dc, 0xfff6b92d, 0x0002f6c9, 0xffff7549,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2098a2bf, 0xf0f4fe3d, 0x099405c6, 0xf955d4a7,
	0x04bfaadf, 0xfca1fc96, 0x02567e22, 0xfe6dca58,
	0x01030b8e, 0xff61bd9f, 0x005a9840, 0xffd034ac,
	0x0016a90a, 0xfff6c20f, 0x0002f385, 0xffff76ae,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x1f590e55, 0xf1658649, 0x095801f8, 0xf9799e8f,
	0x04a9a29e, 0xfcaf82ca, 0x024e614c, 0xfe727a1f,
	0x01007885, 0xff631180, 0x0059f5e1, 0xffd07b95,
	0x00168cf2, 0xfff6cc52, 0x0002efca, 0xffff782a,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x1e1b28f2, 0xf1d72114, 0x091b09d1, 0xf99e269e,
	0x04930b2b, 0xfcbd7206, 0x0245f9bf, 0xfe775d1f,
	0x00fdc3e0, 0xff647a4b, 0x0059474a, 0xffd0c915,
	0x00166da5, 0xfff6d7f0, 0x0002eb9c, 0xffff79bc,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x1cdf0a20, 0xf249bc2c, 0x08dd27e6, 0xf9c36642,
	0x047be8bc, 0xfccbc793, 0x023d4937, 0xfe7c7243,
	0x00faee49, 0xff65f79e, 0x00588cb4, 0xffd11d0f,
	0x00164b32, 0xfff6e4e1, 0x0002e6fe, 0xffff7b63,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x1ba4c923, 0xf2bd4523, 0x089e66dd, 0xf9e956da,
	0x04643f95, 0xfcda80ad, 0x0234517a, 0xfe81b86d,
	0x00f7f86e, 0xff678912, 0x0057c658, 0xffd17764,
	0x001625a7, 0xfff6f31d, 0x0002e1f3, 0xffff7d1f,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x1a6c7cf9, 0xf331a99b, 0x085ed167, 0xfa0ff1b6,
	0x044c1409, 0xfce99a86, 0x022b1455, 0xfe872e7c,
	0x00f4e2ff, 0xff692e3f, 0x0056f471, 0xffd1d7f5,
	0x0015fd15, 0xfff7029f, 0x0002dc7d, 0xffff7eed,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x19363c54, 0xf3a6d741, 0x081e7241, 0xfa373017,
	0x04336a75, 0xfcf91246, 0x0221939d, 0xfe8cd349,
	0x00f1aeb2, 0xff6ae6ba, 0x0056173b, 0xffd23ea1,
	0x0015d18b, 0xfff7135d, 0x0002d6a0, 0xffff80cd,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x18021d9d, 0xf41cbbd3, 0x07dd5430, 0xfa5f0b30,
	0x041a4744, 0xfd08e50c, 0x0217d12d, 0xfe92a5a7,
	0x00ee5c3e, 0xff6cb218, 0x00552ef3, 0xffd2ab47,
	0x0015a31b, 0xfff72551, 0x0002d060, 0xffff82bf,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x16d036eb, 0xf493451f, 0x079b8203, 0xfa877c29,
	0x0400aeec, 0xfd190fed, 0x020dcee8, 0xfe98a466,
	0x00eaec5e, 0xff6e8fe9, 0x00543bd8, 0xffd31dc7,
	0x001571d5, 0xfff73873, 0x0002c9be, 0xffff84c0,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x15a09e09, 0xf50a610a, 0x0759068f, 0xfab07c1d,
	0x03e6a5ee, 0xfd298ff6, 0x02038eb7, 0xfe9ece4f,
	0x00e75fd1, 0xff707fbd, 0x00533e29, 0xffd395fd,
	0x00153dca, 0xfff74cba, 0x0002c2be, 0xffff86d0,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x1473686d, 0xf581fd8b, 0x0715ecae, 0xfada0420,
	0x03cc30d4, 0xfd3a622b, 0x01f9128a, 0xfea52227,
	0x00e3b758, 0xff728121, 0x00523626, 0xffd413c9,
	0x0015070b, 0xfff76220, 0x0002bb64, 0xffff88ee,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x1348ab3a, 0xf5fa08b5, 0x06d23f3d, 0xfb040d3b,
	0x03b15431, 0xfd4b8389, 0x01ee5c55, 0xfeab9eb2,
	0x00dff3b7, 0xff7493a2, 0x00512412, 0xffd49705,
	0x0014cdab, 0xfff7789c, 0x0002b3b3, 0xffff8b19,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x12207b3e, 0xf67270b1, 0x068e091c, 0xfb2e906f,
	0x039614a1, 0xfd5cf105, 0x01e36e14, 0xfeb242ac,
	0x00dc15b4, 0xff76b6ca, 0x0050082f, 0xffd51f90,
	0x001491b9, 0xfff79026, 0x0002abad, 0xffff8d50,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x10faecee, 0xf6eb23c6, 0x0649552a, 0xfb5986b6,
	0x037a76c7, 0xfd6ea790, 0x01d849c7, 0xfeb90cce,
	0x00d81e1a, 0xff78ea20, 0x004ee2c1, 0xffd5ad44,
	0x00145349, 0xfff7a8b6, 0x0002a357, 0xffff8f92,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0fd81464, 0xf7641059, 0x06042e45, 0xfb84e906,
	0x035e7f4e, 0xfd80a411, 0x01ccf173, 0xfebffbd0,
	0x00d40db3, 0xff7b2d2d, 0x004db40c, 0xffd63ffe,
	0x0014126c, 0xfff7c245, 0x00029ab2, 0xffff91de,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0eb80562, 0xf7dd24ef, 0x05be9f49, 0xfbb0b04e,
	0x034232e6, 0xfd92e36c, 0x01c16720, 0xfec70e64,
	0x00cfe54f, 0xff7d7f76, 0x004c7c55, 0xffd6d798,
	0x0013cf36, 0xfff7dcc8, 0x000291c3, 0xffff9434,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d9ad348, 0xf856502d, 0x0578b30e, 0xfbdcd57a,
	0x03259644, 0xfda5627e, 0x01b5acdd, 0xfece433a,
	0x00cba5bc, 0xff7fe07f, 0x004b3be3, 0xffd773ed,
	0x001389b7, 0xfff7f83a, 0x0002888c, 0xffff9691,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0c80911b, 0xf8cf80de, 0x05327467, 0xfc095174,
	0x0308ae24, 0xfdb81e22, 0x01a9c4bc, 0xfed598fe,
	0x00c74fce, 0xff824fca, 0x0049f2fc, 0xffd814d7,
	0x00134204, 0xfff81490, 0x00027f11, 0xffff98f5,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b69517e, 0xf948a5f0, 0x04ebee1c, 0xfc361d25,
	0x02eb7f44, 0xfdcb132d, 0x019db0d0, 0xfedd0e5c,
	0x00c2e457, 0xff84ccdb, 0x0048a1e7, 0xffd8ba31,
	0x0012f82e, 0xfff831c3, 0x00027555, 0xffff9b60,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a5526b0, 0xf9c1ae7b, 0x04a52af2, 0xfc633173,
	0x02ce0e67, 0xfdde3e6f, 0x01917334, 0xfee4a1fa,
	0x00be642f, 0xff875731, 0x004748ed, 0xffd963d4,
	0x0012ac48, 0xfff84fcb, 0x00026b5b, 0xffff9dd0,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0944228e, 0xfa3a89be, 0x045e359f, 0xfc908746,
	0x02b0604f, 0xfdf19cb9, 0x01850e00, 0xfeec527e,
	0x00b9d02b, 0xff89ee4d, 0x0045e856, 0xffda1199,
	0x00125e66, 0xfff86e9e, 0x00026126, 0xffffa045,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08365690, 0xfab32723, 0x041718d2, 0xfcbe1789,
	0x029279c4, 0xfe052ad4, 0x01788354, 0xfef41e8c,
	0x00b52925, 0xff8c91ad, 0x0044806c, 0xffdac35a,
	0x00120e9b, 0xfff88e35, 0x000256b9, 0xffffa2be,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x072bd3c5, 0xfb2b7641, 0x03cfdf29, 0xfcebdb26,
	0x02745f8c, 0xfe18e58c, 0x016bd54f, 0xfefc04c6,
	0x00b06ff7, 0xff8f40d0, 0x00431177, 0xffdb78ef,
	0x0011bcf9, 0xfff8ae88, 0x00024c18, 0xffffa539,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0624aad6, 0xfba366df, 0x03889336, 0xfd19cb0e,
	0x02561670, 0xfe2cc9a7, 0x015f0612, 0xff0403cc,
	0x00aba57c, 0xff91fb31, 0x00419bc2, 0xffdc3231,
	0x00116994, 0xfff8cf8d, 0x00024146, 0xffffa7b7,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0520ec00, 0xfc1ae8f2, 0x03413f7b, 0xfd47e035,
	0x0237a337, 0xfe40d3ed, 0x015217c0, 0xff0c1a3c,
	0x00a6ca90, 0xff94c04f, 0x00401f98, 0xffdceef9,
	0x00111480, 0xfff8f13c, 0x00023645, 0xffffaa35,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0420a716, 0xfc91eca1, 0x02f9ee68, 0xfd761395,
	0x02190aa6, 0xfe550124, 0x01450c7f, 0xff1446b5,
	0x00a1e00f, 0xff978fa6, 0x003e9d42, 0xffddaf1e,
	0x0010bdcf, 0xfff9138e, 0x00022b19, 0xffffacb4,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0323eb7f, 0xfd086246, 0x02b2aa5c, 0xfda45e2c,
	0x01fa5183, 0xfe694e12, 0x0137e672, 0xff1c87d3,
	0x009ce6d8, 0xff9a68b0, 0x003d150d, 0xffde727a,
	0x00106595, 0xfff93679, 0x00021fc5, 0xffffaf33,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
};

static s32 sinc_coef[SINC8_FILTER_COEF_SIZE] = {
	0x27feb535, 0x21be8f19, 0x1288dff1, 0x028f5c07,
	0xf939801e, 0xf8bca44b, 0xfdbc844d, 0x02adac2d,
	0x03fa8824, 0x01d679f2, 0xfef18206, 0xfdbc9fe9,
	0xfea32bc9, 0x00502d7c, 0x013b1b06, 0x00ea2648,
	0x00000000, 0xff6388a9, 0xff739e69, 0xffe84c38,
	0x0043ee4c, 0x00499236, 0x00161876, 0xffe7b5b4,
	0xffdf82eb, 0xfff2e12e, 0x00066655, 0x000b4031,
	0x00055871, 0xfffffff3, 0x00000000, 0x00000000,
	0x27fe9ae7, 0x21a6c167, 0x1266b23b, 0x0274523d,
	0xf930129b, 0xf8c2fc7a, 0xfdc83594, 0x02b4748c,
	0x03f90297, 0x01d06695, 0xfeece4cc, 0xfdbc922c,
	0xfea658a8, 0x005325a5, 0x013ba1a4, 0x00e896c3,
	0xfffe3b09, 0xff62fe5f, 0xff744ec4, 0xffe940cb,
	0x00445238, 0x00494f99, 0x0015a3e0, 0xffe77c99,
	0xffdf971d, 0xfff3106b, 0x00067fef, 0x000b3b9a,
	0x0005493c, 0x00000000, 0x00000000, 0x00000000,
	0x27fe4bfb, 0x218ece64, 0x12448212, 0x0259651e,
	0xf926ca80, 0xf8c96b31, 0xfdd3e5ae, 0x02bb2ce0,
	0x03f76e71, 0x01ca5071, 0xfee84f27, 0xfdbc8d7d,
	0xfea9889f, 0x00561a51, 0x013c22e9, 0x00e704cc,
	0xfffc7785, 0xff627706, 0xff7500be, 0xffea34dc,
	0x0044b4aa, 0x00490c0e, 0x00152f6d, 0xffe74429,
	0xffdfabc3, 0xfff33fa2, 0x00069947, 0x000b36d6,
	0x00053a08, 0x00000000, 0x00000000, 0x00000000,
	0x27fdc874, 0x2176b648, 0x12224fbf, 0x023e94d5,
	0xf91da7c2, 0xf8cff045, 0xfddf946f, 0x02c1d51d,
	0x03f5cbc4, 0x01c437a1, 0xfee3c125, 0xfdbc91d4,
	0xfeacbb9e, 0x00590b78, 0x013c9ed8, 0x00e5706c,
	0xfffab57a, 0xff61f29e, 0xff75b454, 0xffeb2867,
	0x004515a1, 0x0048c798, 0x0014bb1e, 0xffe70c62,
	0xffdfc0da, 0xfff36ed2, 0x0006b25c, 0x000b31e6,
	0x00052ad7, 0x00000000, 0x00000000, 0x00000000,
	0x27fd1052, 0x215e794e, 0x12001b8d, 0x0223e18e,
	0xf914aa58, 0xf8d68b87, 0xfdeb41ad, 0x02c86d34,
	0x03f41aa1, 0x01be1c3d, 0xfedf3ad0, 0xfdbc9f2b,
	0xfeaff195, 0x005bf910, 0x013d1574, 0x00e3d9aa,
	0xfff8f4f0, 0xff617126, 0xff766981, 0xffec1b68,
	0x0045751e, 0x00488239, 0x001446f5, 0xffe6d546,
	0xffdfd663, 0xfff39dfc, 0x0006cb30, 0x000b2cca,
	0x00051ba6, 0x00000000, 0x00000000, 0x00000000,
	0x27fc2398, 0x214617ae, 0x11dde5c6, 0x02094b72,
	0xf90bd239, 0xf8dd3cca, 0xfdf6ed3c, 0x02cef51a,
	0x03f25b18, 0x01b7fe61, 0xfedabc37, 0xfdbcb57c,
	0xfeb32a77, 0x005ee30f, 0x013d86bd, 0x00e24090,
	0xfff735ea, 0xff60f29f, 0xff772041, 0xffed0ddc,
	0x0045d31f, 0x00483bf2, 0x0013d2f4, 0xffe69ed3,
	0xffdfec5b, 0xfff3cd1d, 0x0006e3c1, 0x000b2783,
	0x00050c78, 0x00000000, 0x00000000, 0x00000000,
	0x27fb0246, 0x212d91a3, 0x11bbaeb3, 0x01eed2ac,
	0xf9031f59, 0xf8e403e1, 0xfe0296f2, 0x02d56cc2,
	0x03f08d3d, 0x01b1de25, 0xfed64565, 0xfdbcd4c0,
	0xfeb66635, 0x0061c96e, 0x013df2b7, 0x00e0a524,
	0xfff57871, 0xff607706, 0xff77d88f, 0xffedffc0,
	0x00462fa6, 0x0047f4c5, 0x00135f1d, 0xffe6690b,
	0xffe002c3, 0xfff3fc35, 0x0006fc11, 0x000b2210,
	0x0004fd4d, 0x00000000, 0x00000000, 0x00000000,
	0x27f9ac61, 0x2114e766, 0x1199769e, 0x01d47766,
	0xf8fa91ae, 0xf8eae09e, 0xfe0e3ea4, 0x02dbd41f,
	0x03eeb11f, 0x01abbba4, 0xfed1d666, 0xfdbcfcef,
	0xfeb9a4be, 0x0064ac22, 0x013e5963, 0x00df0771,
	0xfff3bc89, 0xff5ffe5d, 0xff789268, 0xffeef111,
	0x00468ab2, 0x0047acb6, 0x0012eb72, 0xffe633ee,
	0xffe0199a, 0xfff42b43, 0x0007141d, 0x000b1c72,
	0x0004ee24, 0x00000000, 0x00000000, 0x00000000,
	0x27f821eb, 0x20fc1933, 0x11773dd2, 0x01ba39ca,
	0xf8f2292d, 0xf8f1d2d3, 0xfe19e427, 0x02e22b26,
	0x03ecc6d2, 0x01a596f8, 0xfecd6f46, 0xfdbd2e04,
	0xfebce604, 0x00678b22, 0x013ebac4, 0x00dd677d,
	0xfff20238, 0xff5f88a3, 0xff794dc7, 0xffefe1ca,
	0x0046e442, 0x004763c5, 0x001277f3, 0xffe5ff7c,
	0xffe030de, 0xfff45a47, 0x00072be7, 0x000b16a9,
	0x0004defe, 0x00000000, 0x00000000, 0x00000000,
	0x27f662e8, 0x20e32744, 0x11550498, 0x01a01a01,
	0xf8e9e5cb, 0xf8f8da52, 0xfe258751, 0x02e871ca,
	0x03eace67, 0x019f7039, 0xfec91012, 0xfdbd67f6,
	0xfec029f9, 0x006a6666, 0x013f16dc, 0x00dbc551,
	0xfff04984, 0xff5f15d6, 0xff7a0aa7, 0xfff0d1e8,
	0x00473c57, 0x004719f6, 0x001204a4, 0xffe5cbb4,
	0xffe0488f, 0xfff48940, 0x0007436f, 0x000b10b7,
	0x0004cfdb, 0x00000000, 0x00000000, 0x00000000,
	0x27f46f5c, 0x20ca11d5, 0x1132cb39, 0x01861832,
	0xf8e1c77b, 0xf8fff6ee, 0xfe3127f8, 0x02eea801,
	0x03e8c7f0, 0x01994783, 0xfec4b8d4, 0xfdbdaabf,
	0xfec3708d, 0x006d3de6, 0x013f6daf, 0x00da20f6,
	0xffee9273, 0xff5ea5f7, 0xff7ac905, 0xfff1c168,
	0x004792f0, 0x0046cf49, 0x00119186, 0xffe59898,
	0xffe060ab, 0xfff4b82d, 0x00075ab4, 0x000b0a9a,
	0x0004c0bc, 0x00000000, 0x00000000, 0x00000000,
	0x27f2474c, 0x20b0d921, 0x11109200, 0x016c3488,
	0xf8d9ce31, 0xf9072878, 0xfe3cc5f1, 0x02f4cdc0,
	0x03e6b380, 0x01931cee, 0xfec06999, 0xfdbdf657,
	0xfec6b9b1, 0x00701198, 0x013fbf3d, 0x00d87a75,
	0xffecdd0b, 0xff5e3905, 0xff7b88db, 0xfff2b047,
	0x0047e80f, 0x004683c2, 0x00111e9a, 0xffe56627,
	0xffe07932, 0xfff4e70c, 0x000771b6, 0x000b0454,
	0x0004b1a1, 0x00000000, 0x00000000, 0x00000000,
	0x27efeabe, 0x20977d64, 0x10ee5935, 0x01526f29,
	0xf8d1f9e0, 0xf90e6ec2, 0xfe486113, 0x02fae2fa,
	0x03e49129, 0x018cf095, 0xfebc226b, 0xfdbe4ab7,
	0xfeca0555, 0x0072e173, 0x01400b8b, 0x00d6d1d4,
	0xffeb2951, 0xff5dceff, 0xff7c4a26, 0xfff39e81,
	0x00483bb2, 0x00463762, 0x0010abe3, 0xffe53461,
	0xffe09223, 0xfff515df, 0x00078876, 0x000afde5,
	0x0004a289, 0x00000000, 0x00000000, 0x00000000,
	0x27ed59b7, 0x207dfeda, 0x10cc2121, 0x0138c83d,
	0xf8ca4a7d, 0xf915c99d, 0xfe53f935, 0x0300e7a7,
	0x03e260ff, 0x0186c290, 0xfeb7e356, 0xfdbea7d7,
	0xfecd536c, 0x0075ad70, 0x0140529b, 0x00d5271e,
	0xffe9774a, 0xff5d67e5, 0xff7d0ce1, 0xfff48c14,
	0x00488dd9, 0x0045ea2b, 0x00103961, 0xffe50346,
	0xffe0ab7c, 0xfff544a3, 0x00079ef2, 0x000af74d,
	0x00049376, 0x00000000, 0x00000000, 0x00000000,
	0x27ea943d, 0x20645dbf, 0x10a9ea0f, 0x011f3fec,
	0xf8c2bff8, 0xf91d38db, 0xfe5f8e2c, 0x0306dbbc,
	0x03e02313, 0x018092f9, 0xfeb3ac66, 0xfdbf0db0,
	0xfed0a3e6, 0x00787586, 0x0140946f, 0x00d37a59,
	0xffe7c6fe, 0xff5d03b5, 0xff7dd108, 0xfff578fb,
	0x0048de85, 0x00459c20, 0x000fc717, 0xffe4d2d7,
	0xffe0c53e, 0xfff57357, 0x0007b52c, 0x000af08c,
	0x00048468, 0x00000000, 0x00000000, 0x00000000,
	0x27e79a58, 0x204a9a51, 0x1087b447, 0x0105d65c,
	0xf8bb5a44, 0xf924bc4d, 0xfe6b1fd0, 0x030cbf2e,
	0x03ddd779, 0x017a61ea, 0xfeaf7da3, 0xfdbf7c39,
	0xfed3f6b4, 0x007b39ac, 0x0140d10a, 0x00d1cb90,
	0xffe61870, 0xff5ca270, 0xff7e9696, 0xfff66533,
	0x00492db6, 0x00454d42, 0x000f5507, 0xffe4a314,
	0xffe0df67, 0xfff5a1fc, 0x0007cb23, 0x000ae9a4,
	0x0004755e, 0x00000000, 0x00000000, 0x00000000,
	0x27e46c0e, 0x2030b4cb, 0x10658012, 0x00ec8bb4,
	0xf8b41954, 0xf92c53c5, 0xfe76adf7, 0x031291f3,
	0x03db7e44, 0x01742f7d, 0xfeab571b, 0xfdbff36b,
	0xfed74bc7, 0x007df9db, 0x01410870, 0x00d01ac9,
	0xffe46ba7, 0xff5c4413, 0xff7f5d86, 0xfff750ba,
	0x00497b6c, 0x0044fd94, 0x000ee331, 0xffe473fc,
	0xffe0f9f5, 0xfff5d090, 0x0007e0d7, 0x000ae294,
	0x0004665a, 0x00000000, 0x00000000, 0x00000000,
	0x27e10967, 0x2016ad6c, 0x10434dba, 0x00d36019,
	0xf8acfd18, 0xf933ff14, 0xfe823878, 0x03185404,
	0x03d91787, 0x016dfbca, 0xfea738d7, 0xfdc0733e,
	0xfedaa310, 0x0080b609, 0x01413aa4, 0x00ce680d,
	0xffe2c0a7, 0xff5be89f, 0xff8025d5, 0xfff83b8b,
	0x0049c7a7, 0x0044ad18, 0x000e7199, 0xffe44590,
	0xffe114e9, 0xfff5ff13, 0x0007f648, 0x000adb5d,
	0x0004575b, 0x00000000, 0x00000000, 0x00000000,
	0x27dd726b, 0x1ffc8470, 0x10211d86, 0x00ba53b2,
	0xf8a60581, 0xf93bbe0a, 0xfe8dbf2a, 0x031e0555,
	0x03d6a356, 0x0167c6eb, 0xfea322e1, 0xfdc0fbaa,
	0xfeddfc80, 0x00836e2f, 0x014167a8, 0x00ccb366,
	0xffe11777, 0xff5b9012, 0xff80ef7e, 0xfff925a5,
	0x004a1267, 0x00445bd1, 0x000e003f, 0xffe417cf,
	0xffe13041, 0xfff62d84, 0x00080b76, 0x000ad3fe,
	0x00044862, 0x00000000, 0x00000000, 0x00000000,
	0x27d9a724, 0x1fe23a17, 0x0ffeefc0, 0x00a166a3,
	0xf89f3281, 0xf9439079, 0xfe9941e5, 0x0323a5de,
	0x03d421c4, 0x016190fa, 0xfe9f1544, 0xfdc18ca6,
	0xfee15809, 0x00862245, 0x01418f80, 0x00cafcdb,
	0xffdf701c, 0xff5b3a6b, 0xff81ba7d, 0xfffa0f03,
	0x004a5bad, 0x004409bf, 0x000d8f25, 0xffe3eabb,
	0xffe14bfd, 0xfff65be2, 0x00082061, 0x000acc79,
	0x0004396e, 0x00000000, 0x00000000, 0x00000000,
	0x27d5a79a, 0x1fc7ce9d, 0x0fdcc4b0, 0x00889912,
	0xf8988407, 0xf94b7632, 0xfea4c080, 0x03293597,
	0x03d192e5, 0x015b5a0f, 0xfe9b100a, 0xfdc2262a,
	0xfee4b59a, 0x0088d244, 0x0141b22e, 0x00c94475,
	0xffddca9b, 0xff5ae7a9, 0xff8286cc, 0xfffaf7a2,
	0x004aa378, 0x0043b6e6, 0x000d1e4c, 0xffe3be52,
	0xffe1681a, 0xfff68a2c, 0x00083509, 0x000ac4ce,
	0x00042a81, 0x00000000, 0x00000000, 0x00000000,
	0x27d173d7, 0x1fad4241, 0x0fba9c9e, 0x006feb23,
	0xf891fa04, 0xf9536f05, 0xfeb03ad4, 0x032eb477,
	0x03cef6cd, 0x01552244, 0xfe97133e, 0xfdc2c82e,
	0xfee81526, 0x008b7e22, 0x0141cfb7, 0x00c78a3b,
	0xffdc26f9, 0xff5a97cc, 0xff835468, 0xfffbdf80,
	0x004ae9c9, 0x00436348, 0x000cadb7, 0xffe39295,
	0xffe18499, 0xfff6b862, 0x0008496e, 0x000abcfe,
	0x00041b9b, 0x00000000, 0x00000000, 0x00000000,
	0x27cd0be5, 0x1f929543, 0x0f9877d4, 0x00575cf9,
	0xf88b9467, 0xf95b7ac2, 0xfebbb0b7, 0x03342276,
	0x03cc4d90, 0x014ee9b1, 0xfe931ee7, 0xfdc372a8,
	0xfeeb769c, 0x008e25d9, 0x0141e81e, 0x00c5ce38,
	0xffda853b, 0xff5a4ad1, 0xff84234d, 0xfffcc699,
	0x004b2ea0, 0x00430ee6, 0x000c3d67, 0xffe36783,
	0xffe1a178, 0xfff6e683, 0x00085d8f, 0x000ab507,
	0x00040cbb, 0x00000000, 0x00000000, 0x00000000,
	0x27c86fd0, 0x1f77c7e0, 0x0f765698, 0x003eeeb9,
	0xf885531f, 0xf963993c, 0xfec72202, 0x03397f8c,
	0x03c99741, 0x0148b071, 0xfe8f3312, 0xfdc42591,
	0xfeeed9ef, 0x0090c961, 0x0141fb66, 0x00c41073,
	0xffd8e567, 0xff5a00b9, 0xff84f375, 0xfffdacea,
	0x004b71fd, 0x0042b9c3, 0x000bcd5e, 0xffe33d1d,
	0xffe1beb7, 0xfff7148e, 0x0008716e, 0x000aacec,
	0x0003fde2, 0x00000000, 0x00000000, 0x00000000,
	0x27c39fa2, 0x1f5cda58, 0x0f543934, 0x0026a085,
	0xf87f361c, 0xf96bca41, 0xfed28e8e, 0x033ecbb1,
	0x03c6d3f6, 0x0142769b, 0xfe8b4fc6, 0xfdc4e0df,
	0xfef23f0f, 0x009368b1, 0x01420993, 0x00c250f4,
	0xffd74782, 0xff59b981, 0xff85c4dc, 0xfffe9270,
	0x004bb3e1, 0x004263e1, 0x000b5d9d, 0xffe31363,
	0xffe1dc54, 0xfff74283, 0x0008850a, 0x000aa4ac,
	0x0003ef10, 0x00000000, 0x00000000, 0x00000000,
	0x27be9b68, 0x1f41cceb, 0x0f321fef, 0x000e7281,
	0xf8793d4c, 0xf9740da3, 0xfeddf632, 0x034406df,
	0x03c403c3, 0x013c3c49, 0xfe87750d, 0xfdc5a48a,
	0xfef5a5ee, 0x009603c4, 0x014212a8, 0x00c08fc4,
	0xffd5ab91, 0xff597528, 0xff86977e, 0xffff7729,
	0x004bf44c, 0x00420d43, 0x000aee25, 0xffe2ea55,
	0xffe1fa4f, 0xfff77061, 0x00089862, 0x000a9c48,
	0x0003e046, 0x00000000, 0x00000000, 0x00000000,
	0x27b9632c, 0x1f269fd8, 0x0f100b11, 0xfff664cf,
	0xf873689c, 0xf97c6331, 0xfee958c9, 0x0349310e,
	0x03c126bc, 0x01360194, 0xfe83a2f1, 0xfdc67088,
	0xfef90e7c, 0x00989a91, 0x014216a9, 0x00becceb,
	0xffd41199, 0xff5933ae, 0xff876b56, 0x00005b10,
	0x004c333e, 0x0041b5ea, 0x000a7ef9, 0xffe2c1f2,
	0xffe218a6, 0xfff79e27, 0x0008ab78, 0x000a93c0,
	0x0003d183, 0x00000000, 0x00000000, 0x00000000,
	0x27b3f6fd, 0x1f0b535f, 0x0eedfae2, 0xffde7791,
	0xf86db7fb, 0xf984cabc, 0xfef4b629, 0x034e4a37,
	0x03be3cf6, 0x012fc694, 0xfe7fd97a, 0xfdc744d0,
	0xfefc78ab, 0x009b2d11, 0x0142159a, 0x00bd0873,
	0xffd2799e, 0xff58f510, 0xff884060, 0x00013e24,
	0x004c70b8, 0x00415dd8, 0x000a1019, 0xffe29a3b,
	0xffe23759, 0xfff7cbd4, 0x0008be4b, 0x000a8b14,
	0x0003c2c8, 0x00000000, 0x00000000, 0x00000000,
	0x27ae56e7, 0x1eefe7c1, 0x0ecbefa8, 0xffc6aae9,
	0xf8682b56, 0xf98d4414, 0xff000e2d, 0x03535254,
	0x03bb4686, 0x01298b63, 0xfe7c18b1, 0xfdc8215a,
	0xfeffe46c, 0x009dbb3c, 0x01420f7f, 0x00bb4263,
	0xffd0e3a6, 0xff58b94e, 0xff891698, 0x00022060,
	0x004cacba, 0x00410511, 0x0009a189, 0xffe2732f,
	0xffe25666, 0xfff7f968, 0x0008d0da, 0x000a8245,
	0x0003b416, 0x00000000, 0x00000000, 0x00000000,
	0x27a882f8, 0x1ed45d3d, 0x0ea9e9ac, 0xffaefef7,
	0xf862c29a, 0xf995cf09, 0xff0b60ae, 0x0358495f,
	0x03b84380, 0x01235019, 0xfe7860a0, 0xfdc9061c,
	0xff0351af, 0x00a0450d, 0x0142045b, 0x00b97ac4,
	0xffcf4fb7, 0xff588066, 0xff89edf8, 0x000301c3,
	0x004ce744, 0x0040ab95, 0x00093348, 0xffe24cce,
	0xffe275cd, 0xfff826e2, 0x0008e327, 0x000a7953,
	0x0003a56c, 0x00000000, 0x00000000, 0x00000000,
	0x27a27b3e, 0x1eb8b416, 0x0e87e935, 0xff9773dd,
	0xf85d7db3, 0xf99e6b6c, 0xff16ad85, 0x035d2f51,
	0x03b533fa, 0x011d14ce, 0xfe74b14e, 0xfdc9f30c,
	0xff06c067, 0x00a2ca7b, 0x0141f433, 0x00b7b19e,
	0xffcdbdd3, 0xff584a56, 0xff8ac67c, 0x0003e249,
	0x004d2057, 0x00405168, 0x0008c558, 0xffe22719,
	0xffe2958c, 0xfff85441, 0x0008f530, 0x000a703f,
	0x000396cb, 0x00000000, 0x00000000, 0x00000000,
	0x279c3fc8, 0x1e9cec8b, 0x0e65ee8a, 0xff8009bb,
	0xf8585c8f, 0xf9a7190b, 0xff21f48b, 0x03620425,
	0x03b2180a, 0x0116d99c, 0xfe710ac3, 0xfdcae821,
	0xff0a3083, 0x00a54b7f, 0x0141df0a, 0x00b5e6fa,
	0xffcc2e01, 0xff58171d, 0xff8ba020, 0x0004c1ef,
	0x004d57f3, 0x003ff68b, 0x000857bc, 0xffe2020f,
	0xffe2b5a4, 0xfff88186, 0x000906f7, 0x000a6709,
	0x00038832, 0x00000000, 0x00000000, 0x00000000,
	0x2795d0a6, 0x1e8106de, 0x0e43f9f1, 0xff68c0b1,
	0xf8535f1a, 0xf9afd7b7, 0xff2d359c, 0x0366c7d6,
	0x03aeefc4, 0x01109e9a, 0xfe6d6d09, 0xfdcbe551,
	0xff0da1f7, 0x00a7c814, 0x0141c4e4, 0x00b41ae0,
	0xffcaa045, 0xff57e6ba, 0xff8c7adf, 0x0005a0b3,
	0x004d8e1a, 0x003f9b01, 0x0007ea74, 0xffe1ddb0,
	0xffe2d612, 0xfff8aeae, 0x0009187b, 0x000a5db1,
	0x000379a3, 0x00000000, 0x00000000, 0x00000000,
	0x278f2de6, 0x1e650351, 0x0e220bb1, 0xff5198df,
	0xf84e853e, 0xf9b8a740, 0xff387090, 0x036b7a5e,
	0x03abbb3d, 0x010a63e2, 0xfe69d827, 0xfdccea93,
	0xff1114b2, 0x00aa4031, 0x0141a5c7, 0x00b24d59,
	0xffc914a4, 0xff57b92b, 0xff8d56b5, 0x00067e92,
	0x004dc2ca, 0x003f3ecc, 0x00077d83, 0xffe1b9fb,
	0xffe2f6d5, 0xfff8dbba, 0x000929bc, 0x000a5438,
	0x00036b1d, 0x00000000, 0x00000000, 0x00000000,
	0x27885799, 0x1e48e224, 0x0e002412, 0xff3a9263,
	0xf849cee7, 0xf9c18775, 0xff43a543, 0x03701bb9,
	0x03a87a8c, 0x0104298b, 0xfe664c25, 0xfdcdf7dc,
	0xff1488a6, 0x00acb3d1, 0x014181b5, 0x00b07e6c,
	0xffc78b22, 0xff578e6d, 0xff8e339d, 0x00075b88,
	0x004df606, 0x003ee1ee, 0x000710e8, 0xffe196f2,
	0xffe317ee, 0xfff908a8, 0x00093abb, 0x000a4a9e,
	0x00035ca1, 0x00000000, 0x00000000, 0x00000000,
	0x27814dcf, 0x1e2ca39b, 0x0dde4359, 0xff23ad5d,
	0xf8453c00, 0xf9ca7826, 0xff4ed38e, 0x0374abe2,
	0x03a52dc7, 0x00fdefad, 0xfe62c90b, 0xfdcf0d24,
	0xff17fdc4, 0x00af22ed, 0x014158b4, 0x00aeae24,
	0xffc603c4, 0xff576681, 0xff8f1193, 0x00083794,
	0x004e27cd, 0x003e8469, 0x0006a4a7, 0xffe17493,
	0xffe3395a, 0xfff93578, 0x00094b77, 0x000a40e3,
	0x00034e2e, 0x00000000, 0x00000000, 0x00000000,
	0x277a109b, 0x1e1047f7, 0x0dbc69cd, 0xff0ce9eb,
	0xf840cc74, 0xf9d37923, 0xff59fb4c, 0x03792ad4,
	0x03a1d502, 0x00f7b662, 0xfe5f4ee0, 0xfdd02a5e,
	0xff1b73fd, 0x00b18d7e, 0x01412ac7, 0x00acdc88,
	0xffc47e8f, 0xff574163, 0xff8ff092, 0x000912b1,
	0x004e5820, 0x003e2640, 0x000638c0, 0xffe152de,
	0xffe35b19, 0xfff9622a, 0x00095bf0, 0x000a3709,
	0x00033fc6, 0x00000000, 0x00000000, 0x00000000,
	0x2772a00c, 0x1df3cf7b, 0x0d9a97b4, 0xfef6482b,
	0xf83c802c, 0xf9dc8a3a, 0xff651c59, 0x037d988b,
	0x039e7054, 0x00f17dc1, 0xfe5bddac, 0xfdd14f83,
	0xff1eeb43, 0x00b3f37e, 0x0140f7f4, 0x00ab09a0,
	0xffc2fb87, 0xff571f13, 0xff90d096, 0x0009ecdf,
	0x004e8700, 0x003dc775, 0x0005cd35, 0xffe131d4,
	0xffe37d2a, 0xfff98ebd, 0x00096c26, 0x000a2d0e,
	0x00033168, 0x00000000, 0x00000000, 0x00000000,
	0x276afc36, 0x1dd73a6a, 0x0d78cd54, 0xfedfc83a,
	0xf8385714, 0xf9e5ab3d, 0xff70368f, 0x0381f504,
	0x039affd4, 0x00eb45e1, 0xfe587576, 0xfdd27c87,
	0xff226388, 0x00b654e7, 0x0140c03e, 0x00a93575,
	0xffc17ab0, 0xff56ff8e, 0xff91b199, 0x000ac619,
	0x004eb46d, 0x003d6809, 0x00056208, 0xffe11173,
	0xffe39f8b, 0xfff9bb30, 0x00097c1a, 0x000a22f5,
	0x00032314, 0x00000000, 0x00000000, 0x00000000,
	0x2763252c, 0x1dba8906, 0x0d570af2, 0xfec96a36,
	0xf8345114, 0xf9eedbf9, 0xff7b49c9, 0x0386403b,
	0x03978396, 0x00e50edc, 0xfe551645, 0xfdd3b160,
	0xff25dcbc, 0x00b8b1b2, 0x014083aa, 0x00a7600f,
	0xffbffc0f, 0xff56e2d2, 0xff929399, 0x000b9e5e,
	0x004ee067, 0x003d0800, 0x0004f739, 0xffe0f1bd,
	0xffe3c23d, 0xfff9e782, 0x00098bcc, 0x000a18bc,
	0x000314cb, 0x00000000, 0x00000000, 0x00000000,
	0x275b1aff, 0x1d9dbb92, 0x0d3550d5, 0xfeb32e3b,
	0xf8306e15, 0xf9f81c3f, 0xff8655e4, 0x038a7a2c,
	0x0393fbb2, 0x00ded8c9, 0xfe51c020, 0xfdd4ee04,
	0xff2956d0, 0x00bb09d9, 0x0140423e, 0x00a58977,
	0xffbe7fa8, 0xff56c8de, 0xff93768f, 0x000c75aa,
	0x004f0af1, 0x003ca75b, 0x00048cca, 0xffe0d2b0,
	0xffe3e53d, 0xfffa13b3, 0x00099b3b, 0x000a0e64,
	0x0003068d, 0x00000000, 0x00000000, 0x00000000,
	0x2752ddc4, 0x1d80d252, 0x0d139f41, 0xfe9d1465,
	0xf82cae01, 0xfa016bde, 0xff915abb, 0x038ea2d6,
	0x0390683e, 0x00d8a3c0, 0xfe4e730f, 0xfdd63267,
	0xff2cd1b7, 0x00bd5d56, 0x013ffbfc, 0x00a3b1b6,
	0xffbd0580, 0xff56b1b0, 0xff945a78, 0x000d4bfb,
	0x004f3409, 0x003c461c, 0x000422bd, 0xffe0b44c,
	0xffe4088b, 0xfffa3fc3, 0x0009aa68, 0x000a03ef,
	0x0002f85a, 0x00000000, 0x00000000, 0x00000000,
	0x274a6d8f, 0x1d63cd89, 0x0cf1f67c, 0xfe871cd1,
	0xf82910c1, 0xfa0acaa4, 0xff9c5829, 0x0392ba34,
	0x038cc951, 0x00d26fd8, 0xfe4b2f17, 0xfdd77e81,
	0xff304d62, 0x00bfac24, 0x013fb0eb, 0x00a1d8d3,
	0xffbb8d9b, 0xff569d45, 0xff953f4f, 0x000e214e,
	0x004f5bb1, 0x003be447, 0x0003b912, 0xffe09691,
	0xffe42c26, 0xfffa6bb0, 0x0009b953, 0x0009f95c,
	0x0002ea33, 0x00000000, 0x00000000, 0x00000000,
	0x2741ca74, 0x1d46ad7b, 0x0cd056cb, 0xfe71479a,
	0xf825963b, 0xfa143862, 0xffa74e0b, 0x0396c044,
	0x03891f01, 0x00cc3d29, 0xfe47f43f, 0xfdd8d245,
	0xff33c9c2, 0x00c1f63c, 0x013f610f, 0x009ffed7,
	0xffba17fd, 0xff568b9c, 0xff96250f, 0x000ef5a1,
	0x004f81ea, 0x003b81dd, 0x00034fcc, 0xffe07980,
	0xffe4500d, 0xfffa977a, 0x0009c7fb, 0x0009eeab,
	0x0002dc17, 0x00000000, 0x00000000, 0x00000000,
	0x2738f489, 0x1d29726c, 0x0caec072, 0xfe5b94da,
	0xf8223e59, 0xfa1db4e6, 0xffb23c3e, 0x039ab505,
	0x03856964, 0x00c60bcb, 0xfe44c28d, 0xfdda2daa,
	0xff3746c8, 0x00c43b99, 0x013f0c6d, 0x009e23cb,
	0xffb8a4aa, 0xff567cb3, 0xff970bb5, 0x000fc8f0,
	0x004fa6b5, 0x003b1ee0, 0x0002e6ec, 0xffe05d17,
	0xffe4743e, 0xfffac321, 0x0009d662, 0x0009e3dd,
	0x0002ce07, 0x00000000, 0x00000000, 0x00000000,
	0x272febe2, 0x1d0c1ca0, 0x0c8d33b7, 0xfe4604ad,
	0xf81f0901, 0xfa274000, 0xffbd229e, 0x039e9874,
	0x0381a893, 0x00bfdbd5, 0xfe419a08, 0xfddb90a3,
	0xff3ac467, 0x00c67c34, 0x013eb30a, 0x009c47b6,
	0xffb733a6, 0xff567088, 0xff97f33a, 0x00109b3b,
	0x004fca12, 0x003abb53, 0x00027e72, 0xffe04156,
	0xffe498ba, 0xfffaeea4, 0x0009e487, 0x0009d8f2,
	0x0002c003, 0x00000000, 0x00000000, 0x00000000,
	0x2726b097, 0x1ceeac5c, 0x0c6bb0de, 0xfe30972d,
	0xf81bf61c, 0xfa30d97f, 0xffc80108, 0x03a26a8f,
	0x037ddca3, 0x00b9ad5f, 0xfe3e7ab5, 0xfddcfb27,
	0xff3e4290, 0x00c8b809, 0x013e54ea, 0x009a6aa2,
	0xffb5c4f5, 0xff566719, 0xff98db9c, 0x00116c7e,
	0x004fec01, 0x003a5737, 0x00021661, 0xffe0263e,
	0xffe4bd7e, 0xfffb1a01, 0x0009f26a, 0x0009cdeb,
	0x0002b20b, 0x00000000, 0x00000000, 0x00000000,
	0x271d42bc, 0x1cd121e3, 0x0c4a382b, 0xfe1b4c73,
	0xf819058f, 0xfa3a8132, 0xffd2d759, 0x03a62b55,
	0x037a05ab, 0x00b38080, 0xfe3b649b, 0xfdde6d2a,
	0xff41c133, 0x00caef11, 0x013df214, 0x00988c97,
	0xffb4589c, 0xff566062, 0xff99c4d5, 0x00123cb6,
	0x00500c85, 0x0039f290, 0x0001aeba, 0xffe00bcd,
	0xffe4e28b, 0xfffb453a, 0x000a000c, 0x0009c2c8,
	0x0002a41f, 0x00000000, 0x00000000, 0x00000000,
	0x2713a26a, 0x1cb37d7c, 0x0c28c9e2, 0xfe062499,
	0xf8163742, 0xfa4436e7, 0xffdda56e, 0x03a9dac4,
	0x037623c4, 0x00ad554e, 0xfe3857bf, 0xfddfe6a2,
	0xff454044, 0x00cd2148, 0x013d8a8c, 0x0096ad9c,
	0xffb2ee9e, 0xff565c64, 0xff9aaee1, 0x00130be1,
	0x00502b9c, 0x00398d5f, 0x0001477d, 0xffdff204,
	0xffe507de, 0xfffb704c, 0x000a0d6b, 0x0009b78a,
	0x00029640, 0x00000000, 0x00000000, 0x00000000,
	0x2709cfb8, 0x1c95bf6a, 0x0c076648, 0xfdf11fb8,
	0xf8138b1a, 0xfa4dfa6f, 0xffe86b25, 0x03ad78dd,
	0x03723703, 0x00a72be2, 0xfe355426, 0xfde16782,
	0xff48bfb4, 0x00cf4ea9, 0x013d1e57, 0x0094cdbb,
	0xffb186ff, 0xff565b1a, 0xff9b99bb, 0x0013d9fe,
	0x0050494a, 0x003927a6, 0x0000e0ad, 0xffdfd8e2,
	0xffe52d77, 0xfffb9b39, 0x000a1a8a, 0x0009ac30,
	0x0002886e, 0x00000000, 0x00000000, 0x00000000,
	0x26ffcabc, 0x1c77e7f3, 0x0be60d9f, 0xfddc3de8,
	0xf81100fe, 0xfa57cb98, 0xfff3285b, 0x03b1059d,
	0x036e3f81, 0x00a10453, 0xfe3259d6, 0xfde2efc0,
	0xff4c3f74, 0x00d1772d, 0x013cad7b, 0x0092ecfb,
	0xffb021c4, 0xff565c83, 0xff9c855f, 0x0014a708,
	0x0050658e, 0x0038c169, 0x00007a4a, 0xffdfc067,
	0xffe55356, 0xfffbc5fe, 0x000a2767, 0x0009a0bc,
	0x00027aa8, 0x00000000, 0x00000000, 0x00000000,
	0x26f59391, 0x1c59f75d, 0x0bc4c02b, 0xfdc77f42,
	0xf80e98d4, 0xfa61aa31, 0xfffddcef, 0x03b48105,
	0x036a3d56, 0x009adeb6, 0xfe2f68d5, 0xfde47f50,
	0xff4fbf75, 0x00d39acf, 0x013c37fc, 0x00910b66,
	0xffaebeef, 0xff56609c, 0xff9d71c8, 0x001572fe,
	0x00508069, 0x00385aa8, 0x00001457, 0xffdfa892,
	0xffe57978, 0xfffbf09b, 0x000a3403, 0x0009952e,
	0x00026cf0, 0x00000000, 0x00000000, 0x00000000,
	0x26eb2a4f, 0x1c3bedec, 0x0ba37e30, 0xfdb2e3dc,
	0xf80c5280, 0xfa6b9608, 0x000888be, 0x03b7eb15,
	0x03663097, 0x0094bb24, 0xfe2c8126, 0xfde61627,
	0xff533fab, 0x00d5b98c, 0x013bbde1, 0x008f2903,
	0xffad5e84, 0xff566764, 0xff9e5ef2, 0x00163dde,
	0x005099dc, 0x0037f367, 0xffffaed3, 0xffdf9164,
	0xffe59fdd, 0xfffc1b10, 0x000a405e, 0x00098985,
	0x00025f45, 0x00000000, 0x00000000, 0x00000000,
	0x26e08f0f, 0x1c1dcbe7, 0x0b8247f0, 0xfd9e6bcf,
	0xf80a2de7, 0xfa758eee, 0x00132ba7, 0x03bb43cc,
	0x0362195e, 0x008e99b2, 0xfe29a2d0, 0xfde7b439,
	0xff56c006, 0x00d7d35d, 0x013b3f2e, 0x008d45da,
	0xffac0088, 0xff5670d8, 0xff9f4cd8, 0x001707a6,
	0x0050b1e8, 0x00378ba7, 0xffff49c0, 0xffdf7adc,
	0xffe5c684, 0xfffc455d, 0x000a4c78, 0x00097dc3,
	0x000251a8, 0x00000000, 0x00000000, 0x00000000,
	0x26d5c1ea, 0x1bff9193, 0x0b611daf, 0xfd8a1732,
	0xf8082aef, 0xfa7f94b1, 0x001dc589, 0x03be8b2b,
	0x035df7c1, 0x00887a78, 0xfe26cdd6, 0xfde9597b,
	0xff5a4079, 0x00d9e83e, 0x013abbe9, 0x008b61f5,
	0xffaaa4fe, 0xff567cf5, 0xffa03b76, 0x0017d052,
	0x0050c88f, 0x0037236a, 0xfffee520, 0xffdf64f9,
	0xffe5ed6c, 0xfffc6f80, 0x000a5851, 0x000971e7,
	0x00024419, 0x00000000, 0x00000000, 0x00000000,
	0x26cac2fb, 0x1be13f36, 0x0b3fffae, 0xfd75e61a,
	0xf806497c, 0xfa89a71f, 0x00285643, 0x03c1c133,
	0x0359cbd9, 0x00825d8c, 0xfe24023e, 0xfdeb05e1,
	0xff5dc0f5, 0x00dbf82b, 0x013a3418, 0x00897d5a,
	0xffa94be9, 0xff568bb9, 0xffa12ac7, 0x001897e1,
	0x0050ddd0, 0x0036bab4, 0xfffe80f4, 0xffdf4fbb,
	0xffe61494, 0xfffc9979, 0x000a63ea, 0x000965f3,
	0x00023697, 0x00000000, 0x00000000, 0x00000000,
	0x26bf925e, 0x1bc2d518, 0x0b1eee31, 0xfd61d89d,
	0xf8048971, 0xfa93c608, 0x0032ddb3, 0x03c4e5e4,
	0x035595be, 0x007c4305, 0xfe21400c, 0xfdecb95f,
	0xff61416c, 0x00de031d, 0x0139a7c0, 0x00879814,
	0xffa7f54d, 0xff569d22, 0xffa21ac7, 0x00195e50,
	0x0050f1ae, 0x00365186, 0xfffe1d3d, 0xffdf3b22,
	0xffe63bfb, 0xfffcc348, 0x000a6f42, 0x000959e6,
	0x00022924, 0x00000000, 0x00000000, 0x00000000,
	0x26b4302c, 0x1ba4537d, 0x0afde97a, 0xfd4deed2,
	0xf802eab2, 0xfa9df13b, 0x003d5bba, 0x03c7f93f,
	0x03515587, 0x00762af8, 0xfe1e8744, 0xfdee73e9,
	0xff64c1d1, 0x00e00912, 0x013916e8, 0x0085b229,
	0xffa6a12e, 0xff56b12c, 0xffa30b71, 0x001a239e,
	0x00510428, 0x0035e7e3, 0xfffdb9fc, 0xffdf272d,
	0xffe6639f, 0xfffcecec, 0x000a7a59, 0x00094dc1,
	0x00021bbe, 0x00000000, 0x00000000, 0x00000000,
	0x26a89c81, 0x1b85baad, 0x0adcf1ca, 0xfd3a28ce,
	0xf8016d23, 0xfaa82887, 0x0047d036, 0x03cafb46,
	0x034d0b4d, 0x0070157d, 0xfe1bd7ea, 0xfdf03573,
	0xff684214, 0x00e20a04, 0x01388193, 0x0083cba2,
	0xffa54f8f, 0xff56c7d7, 0xffa3fcc1, 0x001ae7c8,
	0x00511541, 0x00357dcc, 0xfffd5732, 0xffdf13dd,
	0xffe68b81, 0xfffd1665, 0x000a8531, 0x00094184,
	0x00020e67, 0x00000000, 0x00000000, 0x00000000,
	0x269cd77b, 0x1b670aee, 0x0abc0763, 0xfd2686a4,
	0xf80010a7, 0xfab26bba, 0x00523b07, 0x03cdebfb,
	0x0348b728, 0x006a02a9, 0xfe193202, 0xfdf1fdf2,
	0xff6bc229, 0x00e405f0, 0x0137e7c9, 0x0081e488,
	0xffa40073, 0xff56e11e, 0xffa4eeb2, 0x001baacb,
	0x005124f9, 0x00351344, 0xfffcf4e1, 0xffdf0130,
	0xffe6b39f, 0xfffd3fb2, 0x000a8fc8, 0x00093530,
	0x0002011f, 0x00000000, 0x00000000, 0x00000000,
	0x2690e135, 0x1b484488, 0x0a9b2a87, 0xfd13086a,
	0xf7fed521, 0xfabcbaa3, 0x005c9c0e, 0x03d0cb5e,
	0x03445930, 0x0063f292, 0xfe169590, 0xfdf3cd59,
	0xff6f4201, 0x00e5fccf, 0x01374990, 0x007ffce2,
	0xffa2b3de, 0xff56fcff, 0xffa5e13f, 0x001c6ca7,
	0x00513350, 0x0034a84d, 0xfffc930a, 0xffdeef26,
	0xffe6dbf8, 0xfffd68d2, 0x000a9a20, 0x000928c5,
	0x0001f3e6, 0x00000000, 0x00000000, 0x00000000,
	0x2684b9cc, 0x1b2967c0, 0x0a7a5b77, 0xfcffae33,
	0xf7fdba73, 0xfac71512, 0x0066f32a, 0x03d39973,
	0x033ff17d, 0x005de54f, 0xfe140298, 0xfdf5a39c,
	0xff72c18f, 0x00e7eea0, 0x0136a6ec, 0x007e14b8,
	0xffa169d2, 0xff571b78, 0xffa6d465, 0x001d2d58,
	0x0051404a, 0x00343cea, 0xfffc31ad, 0xffdeddbf,
	0xffe7048b, 0xfffd91c5, 0x000aa438, 0x00091c43,
	0x0001e6bb, 0x00000000, 0x00000000, 0x00000000,
	0x2678615e, 0x1b0a74e0, 0x0a599a74, 0xfcec7813,
	0xf7fcc07f, 0xfad17ad5, 0x0071403d, 0x03d6563c,
	0x033b8028, 0x0057daf5, 0xfe11791c, 0xfdf780ae,
	0xff7640c4, 0x00e9db5d, 0x0135ffe4, 0x007c2c14,
	0xffa02254, 0xff573c86, 0xffa7c81f, 0x001decdc,
	0x00514be5, 0x0033d11c, 0xfffbd0cc, 0xffdeccfa,
	0xffe72d57, 0xfffdba8b, 0x000aae11, 0x00090fac,
	0x0001d9a0, 0x00000000, 0x00000000, 0x00000000,
	0x266bd808, 0x1aeb6c2d, 0x0a38e7bf, 0xfcd9661d,
	0xf7fbe727, 0xfadbebbb, 0x007b8327, 0x03d901bb,
	0x03370549, 0x0051d39a, 0xfe0ef921, 0xfdf96484,
	0xff79bf93, 0x00ebc302, 0x0135547e, 0x007a42fd,
	0xff9edd67, 0xff576027, 0xffa8bc68, 0x001eab32,
	0x00515625, 0x003364e6, 0xfffb7069, 0xffdebcd7,
	0xffe7565b, 0xfffde323, 0x000ab7aa, 0x000902fe,
	0x0001cc94, 0x00000000, 0x00000000, 0x00000000,
	0x265f1dea, 0x1acc4df0, 0x0a184398, 0xfcc67863,
	0xf7fb2e4e, 0xfae66794, 0x0085bbc9, 0x03db9bf3,
	0x033280f9, 0x004bcf53, 0xfe0c82aa, 0xfdfb4f11,
	0xff7d3ded, 0x00eda58c, 0x0134a4c0, 0x0078597a,
	0xff9d9b0d, 0xff578657, 0xffa9b13c, 0x001f6858,
	0x00515f09, 0x0032f84a, 0xfffb1083, 0xffdead56,
	0xffe77f96, 0xfffe0b8c, 0x000ac104, 0x0008f63b,
	0x0001bf97, 0x00000000, 0x00000000, 0x00000000,
	0x26523322, 0x1aad1a6f, 0x09f7ae3f, 0xfcb3aef8,
	0xf7fa95d4, 0xfaf0ee2d, 0x008fea04, 0x03de24e8,
	0x032df350, 0x0045ce37, 0xfe0a15b8, 0xfdfd4049,
	0xff80bbc6, 0x00ef82f6, 0x0133f0b1, 0x00766f95,
	0xff9c5b49, 0xff57af13, 0xffaaa696, 0x0020244b,
	0x00516693, 0x00328b4b, 0xfffab11d, 0xffde9e75,
	0xffe7a907, 0xfffe33c7, 0x000aca1f, 0x0008e963,
	0x0001b2aa, 0x00000000, 0x00000000, 0x00000000,
	0x264517cf, 0x1a8dd1f4, 0x09d727f5, 0xfca109ee,
	0xf7fa1d9a, 0xfafb7f56, 0x009a0dba, 0x03e09c9c,
	0x03295c68, 0x003fd05a, 0xfe07b251, 0xfdff381f,
	0xff843910, 0x00f15b3e, 0x01333855, 0x00748556,
	0xff9b1e20, 0xff57da5a, 0xffab9c73, 0x0020df09,
	0x00516cc4, 0x00321dea, 0xfffa5237, 0xffde9035,
	0xffe7d2ad, 0xfffe5bd2, 0x000ad2fb, 0x0008dc76,
	0x0001a5cd, 0x00000000, 0x00000000, 0x00000000,
	0x2637cc12, 0x1a6e74c5, 0x09b6b0fa, 0xfc8e8955,
	0xf7f9c582, 0xfb061adf, 0x00a426cd, 0x03e30313,
	0x0324bc58, 0x0039d5d3, 0xfe055875, 0xfe013687,
	0xff87b5bd, 0x00f32e5e, 0x01327bb4, 0x00729ac4,
	0xff99e393, 0xff580828, 0xffac92cc, 0x00219891,
	0x0051719d, 0x0031b029, 0xfff9f3d2, 0xffde8295,
	0xffe7fc87, 0xfffe83ad, 0x000adb98, 0x0008cf75,
	0x000198ff, 0x00000000, 0x00000000, 0x00000000,
	0x262a500a, 0x1a4f032b, 0x0996498c, 0xfc7c2d3f,
	0xf7f98d6b, 0xfb10c095, 0x00ae351e, 0x03e55851,
	0x0320133a, 0x0033deb5, 0xfe030828, 0xfe033b73,
	0xff8b31bf, 0x00f4fc54, 0x0131bad3, 0x0070afe8,
	0xff98aba5, 0xff58387a, 0xffad899f, 0x002250e1,
	0x00517520, 0x0031420c, 0xfff995f0, 0xffde7594,
	0xffe82694, 0xfffeab58, 0x000ae3f8, 0x0008c260,
	0x00018c42, 0x00000000, 0x00000000, 0x00000000,
	0x261ca3d8, 0x1a2f7d6e, 0x0975f1ec, 0xfc69f5bc,
	0xf7f97536, 0xfb1b7048, 0x00b83890, 0x03e79c5a,
	0x031b6127, 0x002deb17, 0xfe00c16c, 0xfe0546d7,
	0xff8ead09, 0x00f6c51c, 0x0130f5b9, 0x006ec4c9,
	0xff97765a, 0xff586b4d, 0xffae80e6, 0x002307f6,
	0x0051774d, 0x0030d394, 0xfff93892, 0xffde6933,
	0xffe850d3, 0xfffed2d2, 0x000aec19, 0x0008b538,
	0x00017f95, 0x00000000, 0x00000000, 0x00000000,
	0x260ec79d, 0x1a0fe3d7, 0x0955aa58, 0xfc57e2dc,
	0xf7f97cc2, 0xfb2629c7, 0x00c23105, 0x03e9cf33,
	0x0316a638, 0x0027fb0d, 0xfdfe8443, 0xfe0758a7,
	0xff92278e, 0x00f888b4, 0x01302c6d, 0x006cd970,
	0xff9643b4, 0xff58a09f, 0xffaf789e, 0x0023bdd0,
	0x00517827, 0x003064c3, 0xfff8dbb8, 0xffde5d70,
	0xffe87b44, 0xfffefa1b, 0x000af3fc, 0x0008a7fc,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2600bb7b, 0x19f036ad, 0x0935730f, 0xfc45f4af,
	0xf7f9a3f0, 0xfb30ece2, 0x00cc1e60, 0x03ebf0e0,
	0x0311e285, 0x00220eac, 0xfdfc50b0, 0xfe0970d5,
	0xff95a13f, 0x00fa4716, 0x012f5ef4, 0x006aede5,
	0xff9513b6, 0xff58d86c, 0xffb070c1, 0x0024726b,
	0x005177ad, 0x002ff59c, 0xfff87f63, 0xffde524b,
	0xffe8a5e4, 0xffff2132, 0x000afba1, 0x00089aae,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x25f27f94, 0x19d0763a, 0x09154c50, 0xfc342b44,
	0xf7f9ea9e, 0xfb3bb966, 0x00d60084, 0x03ee0165,
	0x030d1628, 0x001c2609, 0xfdfa26b3, 0xfe0b8f54,
	0xff991a11, 0x00fc0041, 0x012e8d55, 0x00690230,
	0xff93e663, 0xff5912b1, 0xffb1694c, 0x002525c6,
	0x005175e3, 0x002f8620, 0xfff82395, 0xffde47c3,
	0xffe8d0b4, 0xffff4817, 0x000b0308, 0x00088d4d,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x25e4140b, 0x19b0a2c6, 0x08f53658, 0xfc2286aa,
	0xf7fa50ac, 0xfb468f24, 0x00dfd754, 0x03f000c8,
	0x0308413a, 0x00164139, 0xfdf80650, 0xfe0db418,
	0xff9c91f4, 0x00fdb431, 0x012db796, 0x00671658,
	0xff92bbbd, 0xff594f6c, 0xffb2623a, 0x0025d7e0,
	0x005172c8, 0x002f1653, 0xfff7c84e, 0xffde3dd8,
	0xffe8fbb2, 0xffff6ec9, 0x000b0a32, 0x00087fda,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x25d57901, 0x1990bc99, 0x08d53167, 0xfc1106f0,
	0xf7fad5f8, 0xfb516dea, 0x00e9a2b4, 0x03f1ef0f,
	0x030363d4, 0x00106050, 0xfdf5ef87, 0xfe0fdf14,
	0xffa008dd, 0x00ff62e4, 0x012cddbf, 0x00652a66,
	0xff9193c8, 0xff598e9a, 0xffb35b86, 0x002688b7,
	0x00516e5f, 0x002ea636, 0xfff76d90, 0xffde348a,
	0xffe926dd, 0xffff9548, 0x000b111f, 0x00087255,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x25c6ae9b, 0x1970c3fe, 0x08b53db9, 0xfbffac22,
	0xf7fb7a61, 0xfb5c5588, 0x00f36287, 0x03f3cc3e,
	0x02fe7e0f, 0x000a8362, 0xfdf3e25a, 0xfe12103a,
	0xffa37ebe, 0x01010c56, 0x012bffd5, 0x00633e61,
	0xff906e85, 0xff59d036, 0xffb4552c, 0x00273848,
	0x005168a8, 0x002e35cb, 0xfff7135c, 0xffde2bd8,
	0xffe95234, 0xffffbb94, 0x000b17cf, 0x000864bf,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x25b7b4fd, 0x1950b93c, 0x08955b8c, 0xfbee764f,
	0xf7fc3dc6, 0xfb6745cc, 0x00fd16b1, 0x03f5985b,
	0x02f99005, 0x0004aa84, 0xfdf1decb, 0xfe14477d,
	0xffa6f389, 0x0102b084, 0x012b1ddf, 0x00615252,
	0xff8f4bf7, 0xff5a143f, 0xffb54f28, 0x0027e693,
	0x005161a5, 0x002dc515, 0xfff6b9b1, 0xffde23c0,
	0xffe97db7, 0xffffe1ac, 0x000b1e43, 0x00085718,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x25a88c4a, 0x19309c9d, 0x08758b1d, 0xfbdd6584,
	0xf7fd2003, 0xfb723e87, 0x0106bf17, 0x03f7536d,
	0x02f499d0, 0xfffed5ca, 0xfdefe4da, 0xfe1684d0,
	0xffaa6732, 0x01044f6c, 0x012a37e4, 0x005f6640,
	0xff8e2c20, 0xff5a5ab1, 0xffb64976, 0x00289395,
	0x00515957, 0x002d5416, 0xfff66092, 0xffde1c44,
	0xffe9a964, 0x00000790, 0x000b2479, 0x00084961,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x259934a8, 0x19106e6b, 0x0855cca9, 0xfbcc79ce,
	0xf7fe20f8, 0xfb7d3f87, 0x01105b9d, 0x03f8fd7a,
	0x02ef9b87, 0xfff90548, 0xfdedf489, 0xfe18c825,
	0xffadd9ac, 0x0105e90b, 0x01294deb, 0x005d7a34,
	0xff8d0f04, 0xff5aa388, 0xffb74411, 0x00293f4e,
	0x00514fc0, 0x002ce2d0, 0xfff60800, 0xffde1562,
	0xffe9d53a, 0x00002d3f, 0x000b2a74, 0x00083b99,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2589ae3b, 0x18f02eee, 0x0836206d, 0xfbbbb338,
	0xf7ff4081, 0xfb88489c, 0x0119ec28, 0x03fa9688,
	0x02ea9546, 0xfff33913, 0xfdec0dd8, 0xfe1b1170,
	0xffb14ae9, 0x01077d5f, 0x01285ffa, 0x005b8e34,
	0xff8bf4a4, 0xff5aeec2, 0xffb83ef4, 0x0029e9ba,
	0x005144e2, 0x002c7145, 0xfff5affa, 0xffde0f19,
	0xffea0138, 0x000052b8, 0x000b3032, 0x00082dc1,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2579f929, 0x18cfde70, 0x081686a5, 0xfbab11cf,
	0xf8007e7b, 0xfb935995, 0x0123709d, 0x03fc1e9d,
	0x02e58726, 0xffed713d, 0xfdea30c8, 0xfe1d60a3,
	0xffb4badd, 0x01090c64, 0x01276e18, 0x0059a249,
	0xff8add02, 0xff5b3c5c, 0xffb93a1c, 0x002a92d9,
	0x005138bd, 0x002bff77, 0xfff55882, 0xffde0969,
	0xffea2d5e, 0x000077fd, 0x000b35b5, 0x00081fda,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x256a1598, 0x18af7d3b, 0x07f6ff8e, 0xfb9a959d,
	0xf801dac4, 0xfb9e7242, 0x012ce8e0, 0x03fd95c1,
	0x02e07140, 0xffe7addb, 0xfde85d5a, 0xfe1fb5b0,
	0xffb8297b, 0x010a961a, 0x0126784c, 0x0057b67b,
	0xff89c822, 0xff5b8c51, 0xffba3584, 0x002b3aaa,
	0x00512b52, 0x002b8d69, 0xfff5019a, 0xffde0452,
	0xffea59aa, 0x00009d0b, 0x000b3afc, 0x000811e4,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x255a03af, 0x188f0b98, 0x07d78b62, 0xfb8a3eaf,
	0xf8035537, 0xfba99272, 0x013654d8, 0x03fefbfb,
	0x02db53ad, 0xffe1ef00, 0xfde6938e, 0xfe22108a,
	0xffbb96b5, 0x010c1a7d, 0x01257e9d, 0x0055cad2,
	0xff88b604, 0xff5bde9f, 0xffbb3128, 0x002be12a,
	0x00511ca5, 0x002b1b1c, 0xfff4ab41, 0xffddffd2,
	0xffea861b, 0x0000c1e3, 0x000b4008, 0x000803df,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2549c394, 0x186e89d1, 0x07b82a5e, 0xfb7a0d0e,
	0xf804edb3, 0xfbb4b9f4, 0x013fb46b, 0x04005153,
	0x02d62e88, 0xffdc34bf, 0xfde4d364, 0xfe247124,
	0xffbf0280, 0x010d998b, 0x01248112, 0x0053df54,
	0xff87a6ac, 0xff5c3343, 0xffbc2d03, 0x002c8658,
	0x00510cb5, 0x002aa894, 0xfff45578, 0xffddfbea,
	0xffeab2b1, 0x0000e685, 0x000b44d8, 0x0007f5cc,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2539556e, 0x184df830, 0x0798dcbc, 0xfb6a00c4,
	0xf806a412, 0xfbbfe899, 0x0149077d, 0x040195cf,
	0x02d101ea, 0xffd67f2d, 0xfde31cdd, 0xfe26d76f,
	0xffc26cce, 0x010f1342, 0x01237fb1, 0x0051f40a,
	0xff869a1b, 0xff5c8a39, 0xffbd2912, 0x002d2a32,
	0x0050fb85, 0x002a35d1, 0xfff40041, 0xffddf898,
	0xffeadf6b, 0x00010aef, 0x000b496e, 0x0007e7ab,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2528b965, 0x182d56fe, 0x0779a2b8, 0xfb5a19dc,
	0xf8087830, 0xfbcb1e30, 0x01524df7, 0x0402c978,
	0x02cbcdee, 0xffd0ce5c, 0xfde16ff8, 0xfe29435e,
	0xffc5d593, 0x011087a0, 0x01227a82, 0x005008fc,
	0xff859054, 0xff5ce37d, 0xffbe254f, 0x002dccb8,
	0x0050e916, 0x0029c2d7, 0xfff3ab9d, 0xffddf5dc,
	0xffeb0c47, 0x00012f22, 0x000b4dc9, 0x0007d97c,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2517efa2, 0x180ca686, 0x075a7c8c, 0xfb4a585e,
	0xf80a69ea, 0xfbd65a89, 0x015b87bd, 0x0403ec56,
	0x02c692ac, 0xffcb225f, 0xfddfccb5, 0xfe2bb4e4,
	0xffc93cc2, 0x0111f6a4, 0x0121718c, 0x004e1e31,
	0xff848957, 0xff5d3f0d, 0xffbf21b7, 0x002e6de7,
	0x0050d569, 0x00294fa7, 0xfff3578b, 0xffddf3b5,
	0xffeb3944, 0x0001531e, 0x000b51ea, 0x0007cb40,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2506f84c, 0x17ebe711, 0x073b6a73, 0xfb3abc54,
	0xf80c791b, 0xfbe19d73, 0x0164b4b7, 0x0404fe71,
	0x02c1503e, 0xffc57b49, 0xfdde3314, 0xfe2e2bf2,
	0xffcca24f, 0x0113604b, 0x012064d6, 0x004c33b1,
	0xff838529, 0xff5d9ce5, 0xffc01e46, 0x002f0dbf,
	0x0050c080, 0x0028dc43, 0xfff3040e, 0xffddf223,
	0xffeb6662, 0x000176e1, 0x000b55d1, 0x0007bcf7,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x24f5d38e, 0x17cb18ea, 0x071c6ca6, 0xfb2b45c5,
	0xf80ea59d, 0xfbece6be, 0x016dd4cd, 0x0405ffd1,
	0x02bc06bf, 0xffbfd92e, 0xfddca314, 0xfe30a87b,
	0xffd0062d, 0x0114c494, 0x011f5466, 0x004a4983,
	0xff8283c9, 0xff5dfd01, 0xffc11af6, 0x002fac3e,
	0x0050aa5d, 0x002868ae, 0xfff2b125, 0xffddf125,
	0xffeb93a0, 0x00019a6b, 0x000b597e, 0x0007aea1,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x24e4818f, 0x17aa3c5b, 0x06fd8360, 0xfb1bf4ba,
	0xf810ef4c, 0xfbf8363b, 0x0176e7e4, 0x0406f080,
	0x02b6b649, 0xffba3c1f, 0xfddb1cb5, 0xfe332a70,
	0xffd36850, 0x0116237d, 0x011e4045, 0x00485faf,
	0xff81853a, 0xff5e5f5f, 0xffc217c4, 0x00304962,
	0x00509301, 0x0027f4ea, 0xfff25ed1, 0xffddf0ba,
	0xffebc0fd, 0x0001bdbd, 0x000b5cf1, 0x0007a03f,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x24d3027b, 0x178951ae, 0x06deaed9, 0xfb0cc93b,
	0xf8135602, 0xfc038bb9, 0x017fede6, 0x0407d087,
	0x02b15ef5, 0xffb4a42f, 0xfdd99ff5, 0xfe35b1c5,
	0xffd6c8ab, 0x01177d04, 0x011d2879, 0x0046763d,
	0xff80897f, 0xff5ec3f9, 0xffc314ac, 0x0030e52b,
	0x00507a6e, 0x002780f9, 0xfff20d14, 0xffddf0e2,
	0xffebee77, 0x0001e0d6, 0x000b602b, 0x000791d1,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x24c1567a, 0x1768592e, 0x06bfef4b, 0xfafdc34e,
	0xf815d99a, 0xfc0ee708, 0x0188e6b9, 0x04089fee,
	0x02ac00dd, 0xffaf1172, 0xfdd82cd5, 0xfe383e6a,
	0xffda2733, 0x0118d129, 0x011c0d0a, 0x00448d33,
	0xff7f9097, 0xff5f2ace, 0xffc411aa, 0x00317f96,
	0x005060a5, 0x00270cdc, 0xfff1bbed, 0xffddf19c,
	0xffec1c0e, 0x000203b5, 0x000b632c, 0x00078358,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x24af7db8, 0x17475324, 0x06a144ef, 0xfaeee2fb,
	0xf81879ef, 0xfc1a47f9, 0x0191d246, 0x04095ebf,
	0x02a69c1b, 0xffa983f8, 0xfdd6c352, 0xfe3ad053,
	0xffdd83da, 0x011a1fe9, 0x011aedfe, 0x0042a49a,
	0xff7e9a87, 0xff5f93d9, 0xffc50eb9, 0x003218a4,
	0x005045a8, 0x00269897, 0xfff16b5f, 0xffddf2e7,
	0xffec49c1, 0x0002265b, 0x000b65f4, 0x000774d4,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x249d7860, 0x17263fdc, 0x0682affd, 0xfae02847,
	0xf81b36d9, 0xfc25ae5b, 0x019ab075, 0x040a0d04,
	0x02a130ca, 0xffa3fbd5, 0xfdd5636c, 0xfe3d6770,
	0xffe0de95, 0x011b6943, 0x0119cb5e, 0x0040bc7a,
	0xff7da74d, 0xff5fff17, 0xffc60bd5, 0x0032b051,
	0x00502979, 0x0026242c, 0xfff11b68, 0xffddf4c2,
	0xffec778f, 0x000248c6, 0x000b6884, 0x00076644,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x248b469e, 0x17051f9f, 0x066430ad, 0xfad19338,
	0xf81e1033, 0xfc3119ff, 0x01a38130, 0x040aaac6,
	0x029bbf03, 0xff9e791a, 0xfdd40d21, 0xfe4003b5,
	0xffe43758, 0x011cad37, 0x0118a530, 0x003ed4d8,
	0xff7cb6ee, 0xff606c84, 0xffc708f9, 0x0033469e,
	0x00500c19, 0x0025af9b, 0xfff0cc0b, 0xffddf72e,
	0xffeca576, 0x00026af7, 0x000b6adb, 0x000757ab,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2478e89c, 0x16e3f2b9, 0x0645c738, 0xfac323d5,
	0xf82105d7, 0xfc3c8ab6, 0x01ac445e, 0x040b3810,
	0x029646e1, 0xff98fbd9, 0xfdd2c070, 0xfe42a512,
	0xffe78e17, 0x011debc3, 0x01177b7c, 0x003cedbd,
	0xff7bc969, 0xff60dc1c, 0xffc80623, 0x0033db89,
	0x004fed8a, 0x00253ae8, 0xfff07d48, 0xffddfa29,
	0xffecd377, 0x00028ced, 0x000b6cfb, 0x00074907,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x24665e88, 0x16c2b973, 0x062773d4, 0xfab4da22,
	0xf824179d, 0xfc480050, 0x01b4f9e8, 0x040bb4ec,
	0x0290c87d, 0xff938425, 0xfdd17d57, 0xfe454b79,
	0xffeae2c5, 0x011f24e5, 0x01164e49, 0x003b0731,
	0xff7adec1, 0xff614ddd, 0xffc9034d, 0x00346f11,
	0x004fcdce, 0x0024c615, 0xfff02f1f, 0xffddfdb2,
	0xffed0190, 0x0002aea8, 0x000b6ee3, 0x00073a5a,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2453a88d, 0x16a17418, 0x060936ba, 0xfaa6b623,
	0xf827455f, 0xfc537a9d, 0x01bda1ba, 0x040c2164,
	0x028b43f2, 0xff8e120e, 0xfdd043d4, 0xfe47f6dd,
	0xffee3557, 0x0120589e, 0x01151d9f, 0x0039213a,
	0xff79f6f7, 0xff61c1c2, 0xffca0074, 0x00350135,
	0x004face5, 0x00245123, 0xffefe191, 0xffde01c9,
	0xffed2fc0, 0x0002d028, 0x000b7094, 0x00072ba3,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2440c6da, 0x168022f4, 0x05eb101f, 0xfa98b7dd,
	0xf82a8ef5, 0xfc5ef96e, 0x01c63bbb, 0x040c7d83,
	0x0285b95a, 0xff88a5a6, 0xfdcf13e6, 0xfe4aa72f,
	0xfff185c1, 0x012186ed, 0x0113e985, 0x00373bdf,
	0xff79120c, 0xff6237c7, 0xffcafd93, 0x003591f4,
	0x004f8ad3, 0x0023dc15, 0xffef949f, 0xffde066d,
	0xffed5e07, 0x0002f16c, 0x000b720d, 0x00071ce3,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x242db99b, 0x165ec650, 0x05cd003c, 0xfa8adf54,
	0xf82df439, 0xfc6a7c94, 0x01cec7d6, 0x040cc954,
	0x028028cf, 0xff833eff, 0xfdcded89, 0xfe4d5c60,
	0xfff4d3f7, 0x0122afcf, 0x0112b203, 0x00355729,
	0xff783002, 0xff62afe9, 0xffcbfaa6, 0x0036214c,
	0x004f6798, 0x002366ed, 0xffef4849, 0xffde0b9d,
	0xffed8c62, 0x00031274, 0x000b7350, 0x00070e1a,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x241a80fe, 0x163d5e78, 0x05af0745, 0xfa7d2c8b,
	0xf8317502, 0xfc7603e0, 0x01d745f6, 0x040d04e3,
	0x027a926c, 0xff7dde2a, 0xfdccd0bd, 0xfe501663,
	0xfff81fee, 0x0123d346, 0x01117721, 0x0033731e,
	0xff7750d9, 0xff632a24, 0xffccf7aa, 0x0036af3d,
	0x004f4337, 0x0022f1ad, 0xffeefc91, 0xffde1159,
	0xffedbad2, 0x00033340, 0x000b745c, 0x0006ff49,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x24071d31, 0x161bebb6, 0x05912571, 0xfa6f9f85,
	0xf8351129, 0xfc818f21, 0x01dfb604, 0x040d303a,
	0x0274f649, 0xff788338, 0xfdcbbd7e, 0xfe52d529,
	0xfffb699a, 0x0124f150, 0x011038e5, 0x00318fc5,
	0xff767494, 0xff63a674, 0xffcdf499, 0x00373bc5,
	0x004f1db1, 0x00227c57, 0xffeeb176, 0xffde17a0,
	0xffede956, 0x000353cf, 0x000b7532, 0x0006f070,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x23f38e64, 0x15fa6e55, 0x05735af5, 0xfa623845,
	0xf838c886, 0xfc8d1e2b, 0x01e817ec, 0x040d4b65,
	0x026f5483, 0xff732e3a, 0xfdcab3ca, 0xfe5598a4,
	0xfffeb0ef, 0x012609ed, 0x010ef758, 0x002fad26,
	0xff759b33, 0xff6424d6, 0xffcef171, 0x0037c6e4,
	0x004ef708, 0x002206ed, 0xffee66f9, 0xffde1e71,
	0xffee17ec, 0x00037422, 0x000b75d2, 0x0006e18f,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x23dfd4c5, 0x15d8e6a0, 0x0555a808, 0xfa54f6cd,
	0xf83c9af0, 0xfc98b0cd, 0x01f06b98, 0x040d5670,
	0x0269ad32, 0xff6ddf40, 0xfdc9b39e, 0xfe5860c5,
	0x0001f5e1, 0x01271d1c, 0x010db281, 0x002dcb48,
	0xff74c4b7, 0xff64a545, 0xffcfee2d, 0x00385098,
	0x004ecf3d, 0x00219171, 0xffee1d1b, 0xffde25cc,
	0xffee4694, 0x00039438, 0x000b763d, 0x0006d2a7,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x23cbf083, 0x15b754e1, 0x05380cdd, 0xfa47db1e,
	0xf840883f, 0xfca446d9, 0x01f8b0f4, 0x040d5166,
	0x02640071, 0xff68965c, 0xfdc8bcf8, 0xfe5b2d7d,
	0x00053867, 0x01282ade, 0x010c6a67, 0x002bea32,
	0xff73f122, 0xff6527bf, 0xffd0eac9, 0x0038d8e1,
	0x004ea653, 0x00211be5, 0xffedd3dd, 0xffde2daf,
	0xffee754c, 0x0003b410, 0x000b7672, 0x0006c3b8,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x23b7e1cf, 0x1595b963, 0x051a89aa, 0xfa3ae53a,
	0xf844904b, 0xfcafe01f, 0x0200e7ec, 0x040d3c55,
	0x025e4e5b, 0xff63539e, 0xfdc7cfd4, 0xfe5dfebf,
	0x00087873, 0x01293331, 0x010b1f14, 0x002a09ea,
	0xff732074, 0xff65ac3e, 0xffd1e741, 0x00395fbe,
	0x004e7c4b, 0x0020a64c, 0xffed8b3e, 0xffde3619,
	0xffeea414, 0x0003d3ab, 0x000b7672, 0x0006b4c3,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x23a3a8d8, 0x15741472, 0x04fd1ea3, 0xfa2e1521,
	0xf848b2eb, 0xfcbb7c73, 0x0209106b, 0x040d1748,
	0x02589709, 0xff5e1717, 0xfdc6ec30, 0xfe60d47c,
	0x000bb5fb, 0x012a3616, 0x0109d08d, 0x00282a79,
	0xff7252af, 0xff6632c0, 0xffd2e390, 0x0039e52e,
	0x004e5127, 0x002030a6, 0xffed4340, 0xffde3f0b,
	0xffeed2ec, 0x0003f308, 0x000b763e, 0x0006a5c7,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x238f45cf, 0x15526658, 0x04dfcbfc, 0xfa216ad5,
	0xf84ceff5, 0xfcc71ba4, 0x02112a5e, 0x040ce24c,
	0x0252da97, 0xff58e0d6, 0xfdc61208, 0xfe63aea4,
	0x000ef0f4, 0x012b338d, 0x01087edc, 0x00264be4,
	0xff7187d3, 0xff66bb3f, 0xffd3dfb4, 0x003a6930,
	0x004e24e9, 0x001fbaf7, 0xffecfbe3, 0xffde4883,
	0xffef01d1, 0x00041227, 0x000b75d5, 0x000696c5,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x237ab8e6, 0x1530af60, 0x04c291e8, 0xfa14e655,
	0xf8514741, 0xfcd2bd85, 0x021935b0, 0x040c9d6e,
	0x024d191d, 0xff53b0ed, 0xfdc54159, 0xfe668d2a,
	0x00122952, 0x012c2b96, 0x01072a07, 0x00246e34,
	0xff70bfe1, 0xff6745b9, 0xffd4dba8, 0x003aebc3,
	0x004df793, 0x001f4540, 0xffecb528, 0xffde5281,
	0xffef30c3, 0x00043108, 0x000b7538, 0x000687bd,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2366024c, 0x150eefd5, 0x04a5709a, 0xfa0887a1,
	0xf855b8a4, 0xfcde61e8, 0x0221324f, 0x040c48ba,
	0x024752b7, 0xff4e876a, 0xfdc47a20, 0xfe697000,
	0x00155f0b, 0x012d1e30, 0x0105d217, 0x0022916e,
	0xff6ffadb, 0xff67d22a, 0xffd5d768, 0x003b6ce6,
	0x004dc926, 0x001ecf83, 0xffec6f0e, 0xffde5d03,
	0xffef5fc2, 0x00044faa, 0x000b7467, 0x000678b0,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x23512234, 0x14ed2801, 0x04886847, 0xf9fc4eb8,
	0xf85a43f6, 0xfcea089d, 0x02292027, 0x040be43e,
	0x0241877f, 0xff49645d, 0xfdc3bc58, 0xfe6c5715,
	0x00189212, 0x012e0b5d, 0x01047713, 0x0020b59a,
	0xff6f38c0, 0xff68608d, 0xffd6d2f1, 0x003bec99,
	0x004d99a5, 0x001e59c3, 0xffec2997, 0xffde6809,
	0xffef8ecc, 0x00046e0e, 0x000b7363, 0x0006699e,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x233c18d1, 0x14cb5830, 0x046b7920, 0xf9f03b99,
	0xf85ee90d, 0xfcf5b178, 0x0230ff26, 0x040b7008,
	0x023bb78e, 0xff4447d8, 0xfdc307fe, 0xfe6f425c,
	0x001bc25f, 0x012ef31c, 0x01031904, 0x001edabf,
	0xff6e7992, 0xff68f0de, 0xffd7ce3e, 0x003c6adb,
	0x004d6910, 0x001de401, 0xffebe4c4, 0xffde7393,
	0xffefbde0, 0x00048c33, 0x000b722c, 0x00065a87,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2326e654, 0x14a980ad, 0x044ea358, 0xf9e44e42,
	0xf863a7be, 0xfd015c4a, 0x0238cf39, 0x040aec25,
	0x0235e300, 0xff3f31e8, 0xfdc25d0e, 0xfe7231c6,
	0x001eefe5, 0x012fd56e, 0x0101b7f1, 0x001d00e3,
	0xff6dbd51, 0xff69831a, 0xffd8c94b, 0x003ce7ab,
	0x004d376b, 0x001d6e3f, 0xffeba093, 0xffde7f9e,
	0xffefecfe, 0x0004aa18, 0x000b70c2, 0x00064b6c,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x23118aef, 0x1487a1c1, 0x0431e720, 0xf9d886b2,
	0xf8687fdf, 0xfd0d08e6, 0x0240904e, 0x040a58a2,
	0x023009ee, 0xff3a229e, 0xfdc1bb84, 0xfe752544,
	0x00221a9a, 0x0130b253, 0x010053e2, 0x001b280e,
	0xff6d03fd, 0xff6a173c, 0xffd9c414, 0x003d6309,
	0x004d04b7, 0x001cf87f, 0xffeb5d07, 0xffde8c2b,
	0xfff01c25, 0x0004c7bf, 0x000b6f25, 0x00063c4d,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x22fc06d8, 0x1465bbb9, 0x041544aa, 0xf9cce4e6,
	0xf86d7146, 0xfd18b71d, 0x02484253, 0x0409b58e,
	0x022a2c73, 0xff351a08, 0xfdc1235c, 0xfe781cc8,
	0x00254273, 0x013189cc, 0x00feecdf, 0x00195045,
	0xff6c4d99, 0xff6aad40, 0xffdabe97, 0x003ddcf3,
	0x004cd0f5, 0x001c82c3, 0xffeb1a1f, 0xffde9939,
	0xfff04b53, 0x0004e526, 0x000b6d57, 0x00062d2b,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x22e65a40, 0x1443cedf, 0x03f8bc28, 0xf9c168db,
	0xf8727bc9, 0xfd2466c3, 0x024fe536, 0x040902f6,
	0x02244aaa, 0xff301836, 0xfdc09492, 0xfe7b1843,
	0x00286766, 0x01325bd9, 0x00fd82f1, 0x00177990,
	0xff6b9a23, 0xff6b4523, 0xffdbb8ce, 0x003e556a,
	0x004c9c28, 0x001c0d0e, 0xffead7dc, 0xffdea6c7,
	0xfff07a88, 0x0005024d, 0x000b6b56, 0x00061e05,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x22d0855c, 0x1421db7e, 0x03dc4dca, 0xf9b6128e,
	0xf8779f3c, 0xfd3017a9, 0x025778e5, 0x040840ea,
	0x021e64ab, 0xff2b1d37, 0xfdc00f20, 0xfe7e17a5,
	0x002b8968, 0x0133287b, 0x00fc161e, 0x0015a3f5,
	0xff6ae99c, 0xff6bdee1, 0xffdcb2b6, 0x003ecc6c,
	0x004c6652, 0x001b9761, 0xffea963e, 0xffdeb4d3,
	0xfff0a9c4, 0x00051f34, 0x000b6924, 0x00060edb,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x22ba8860, 0x13ffe1e0, 0x03bff9c0, 0xf9aae1fb,
	0xf87cdb75, 0xfd3bc9a3, 0x025efd50, 0x04076f78,
	0x02187a92, 0xff26291a, 0xfdbf9304, 0xfe811ae0,
	0x002ea86e, 0x0133efb4, 0x00faa670, 0x0013cf7b,
	0xff6a3c06, 0xff6c7a74, 0xffddac4c, 0x003f41f9,
	0x004c2f75, 0x001b21be, 0xffea5546, 0xffdec35e,
	0xfff0d904, 0x00053bdb, 0x000b66c1, 0x0005ffaf,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x22a46381, 0x13dde250, 0x03a3c03c, 0xf99fd71f,
	0xf8823049, 0xfd477c83, 0x02667266, 0x04068eae,
	0x02128c79, 0xff213bed, 0xfdbf2036, 0xfe8421e6,
	0x0031c46e, 0x0134b183, 0x00f933ed, 0x0011fc29,
	0xff69915f, 0xff6d17da, 0xffdea58b, 0x003fb610,
	0x004bf792, 0x001aac26, 0xffea14f4, 0xffded267,
	0xfff10849, 0x00055842, 0x000b642d, 0x0005f081,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x228e16f3, 0x13bbdd1a, 0x0387a16d, 0xf994f1f4,
	0xf8879d8c, 0xfd53301d, 0x026dd816, 0x04059e9b,
	0x020c9a7a, 0xff1c55bf, 0xfdbeb6b4, 0xfe872ca7,
	0x0034dd5f, 0x01356dea, 0x00f7be9f, 0x00102a05,
	0xff68e9a9, 0xff6db70e, 0xffdf9e70, 0x004028b1,
	0x004bbeab, 0x001a369d, 0xffe9d548, 0xffdee1eb,
	0xfff13792, 0x00057468, 0x000b6169, 0x0005e151,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2277a2ec, 0x1399d287, 0x036b9d81, 0xf98a3277,
	0xf88d2313, 0xfd5ee442, 0x02752e50, 0x04049f4f,
	0x0206a4af, 0xff17769e, 0xfdbe5678, 0xfe8a3b15,
	0x0037f335, 0x013624eb, 0x00f6468d, 0x000e5916,
	0xff6844e4, 0xff6e580c, 0xffe096f6, 0x004099dc,
	0x004b84c3, 0x0019c124, 0xffe99643, 0xffdef1ec,
	0xfff166dd, 0x0005904e, 0x000b5e74, 0x0005d21e,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x226107a1, 0x1377c2e3, 0x034fb4aa, 0xf97f98a2,
	0xf892c0b3, 0xfd6a98c8, 0x027c7503, 0x040390d8,
	0x0200ab32, 0xff129e99, 0xfdbdff7c, 0xfe8d4d20,
	0x003b05e6, 0x0136d685, 0x00f4cbc0, 0x000c8961,
	0xff67a310, 0xff6efacf, 0xffe18f1b, 0x0041098f,
	0x004b49db, 0x00194bbc, 0xffe957e5, 0xffdf0267,
	0xfff1962a, 0x0005abf3, 0x000b5b4f, 0x0005c2eb,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x224a454a, 0x1355ae78, 0x0333e714, 0xf975246f,
	0xf898763f, 0xfd764d80, 0x0283ac20, 0x04027347,
	0x01faae1e, 0xff0dcdbd, 0xfdbdb1bc, 0xfe9062ba,
	0x003e1569, 0x013782ba, 0x00f34e3f, 0x000abaee,
	0xff67042d, 0xff6f9f54, 0xffe286db, 0x004177cb,
	0x004b0df6, 0x0018d668, 0xffe91a2e, 0xffdf135c,
	0xfff1c577, 0x0005c757, 0x000b57fb, 0x0005b3b6,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x22335c1a, 0x13339590, 0x031834ee, 0xf96ad5d8,
	0xf89e438c, 0xfd82023f, 0x028ad398, 0x040146aa,
	0x01f4ad8d, 0xff090419, 0xfdbd6d32, 0xfe937bd4,
	0x004121b3, 0x0138298c, 0x00f1ce12, 0x0008edc3,
	0xff66683c, 0xff704596, 0xffe37e31, 0x0041e48f,
	0x004ad115, 0x0018612a, 0xffe8dd1f, 0xffdf24ca,
	0xfff1f4c5, 0x0005e27a, 0x000b5478, 0x0005a480,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x221c4c4b, 0x13117877, 0x02fc9e67, 0xf960acd7,
	0xf8a4286d, 0xfd8db6d8, 0x0291eb5a, 0x04000b12,
	0x01eea999, 0xff0441bb, 0xfdbd31d9, 0xfe96985f,
	0x00442abb, 0x0138cafc, 0x00f04b43, 0x000721e7,
	0xff65cf3c, 0xff70ed92, 0xffe4751b, 0x00424fda,
	0x004a933a, 0x0017ec03, 0xffe8a0b8, 0xffdf36b0,
	0xfff22412, 0x0005fd5c, 0x000b50c6, 0x0005954a,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x22051612, 0x12ef5776, 0x02e123ac, 0xf956a964,
	0xf8aa24b7, 0xfd996b1e, 0x0298f359, 0x03fec08f,
	0x01e8a25b, 0xfeff86af, 0xfdbcffab, 0xfe99b84c,
	0x00473076, 0x0139670b, 0x00eec5d8, 0x0005575e,
	0xff65392d, 0xff719743, 0xffe56b94, 0x0042b9ac,
	0x004a5467, 0x001776f5, 0xffe864fa, 0xffdf490e,
	0xfff2535e, 0x000617fd, 0x000b4ce6, 0x00058613,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x21edb9a7, 0x12cd32d9, 0x02c5c4eb, 0xf94ccb7a,
	0xf8b0383d, 0xfda51ee7, 0x029feb85, 0x03fd6730,
	0x01e297ef, 0xfefad304, 0xfdbcd6a2, 0xfe9cdb8c,
	0x004a32db, 0x0139fdbc, 0x00ed3dda, 0x00038e31,
	0xff64a610, 0xff7242a4, 0xffe66199, 0x00432206,
	0x004a149f, 0x00170202, 0xffe829e4, 0xffdf5be3,
	0xfff282a7, 0x0006325c, 0x000b48d7, 0x000576dc,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x21d63741, 0x12ab0ae9, 0x02aa824f, 0xf9431310,
	0xf8b662d3, 0xfdb0d205, 0x02a6d3d1, 0x03fbff07,
	0x01dc8a6e, 0xfef626c7, 0xfdbcb6b9, 0xfea00210,
	0x004d31e0, 0x013a8f0f, 0x00ebb352, 0x0001c665,
	0xff6415e4, 0xff72efb3, 0xffe75726, 0x004388e6,
	0x0049d3e3, 0x00168d2d, 0xffe7ef77, 0xffdf6f2c,
	0xfff2b1ec, 0x00064c79, 0x000b449b, 0x000567a6,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x21be8f19, 0x1288dff1, 0x028f5c07, 0xf939801e,
	0xf8bca44b, 0xfdbc844d, 0x02adac2d, 0x03fa8824,
	0x01d679f2, 0xfef18206, 0xfdbc9fe9, 0xfea32bc9,
	0x00502d7c, 0x013b1b06, 0x00ea2648, 0x00000000,
	0xff6388a9, 0xff739e69, 0xffe84c38, 0x0043ee4c,
	0x00499236, 0x00161876, 0xffe7b5b4, 0xffdf82eb,
	0xfff2e12e, 0x00066655, 0x000b4031, 0x00055871,
	0x00000000, 0x00000000, 0x00000000, 0x00000000
};

#endif
