/*
 *
 * (C) COPYRIGHT 2010-2019 ARM Limited. All rights reserved.
 *
 * This program is free software and is provided to you under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation, and any use by you of this program is subject to the terms
 * of such GNU licence.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can access it online at
 * http://www.gnu.org/licenses/gpl-2.0.html.
 *
 * SPDX-License-Identifier: GPL-2.0
 *
 */

/*
 * THIS FILE IS AUTOGENERATED BY mali_trace_generator.py.
 * DO NOT EDIT.
 */

#include "mali_kbase_tracepoints.h"
#include "mali_kbase_tlstream.h"
#include "mali_kbase_tl_serialize.h"

/* clang-format off */

/* Message ids of trace events that are recorded in the timeline stream. */
enum tl_msg_id_obj {
	KBASE_TL_NEW_CTX,
	KBASE_TL_NEW_GPU,
	KBASE_TL_NEW_LPU,
	KBASE_TL_NEW_ATOM,
	KBASE_TL_NEW_AS,
	KBASE_TL_DEL_CTX,
	KBASE_TL_DEL_ATOM,
	KBASE_TL_LIFELINK_LPU_GPU,
	KBASE_TL_LIFELINK_AS_GPU,
	KBASE_TL_RET_CTX_LPU,
	KBASE_TL_RET_ATOM_CTX,
	KBASE_TL_RET_ATOM_LPU,
	KBASE_TL_NRET_CTX_LPU,
	KBASE_TL_NRET_ATOM_CTX,
	KBASE_TL_NRET_ATOM_LPU,
	KBASE_TL_RET_AS_CTX,
	KBASE_TL_NRET_AS_CTX,
	KBASE_TL_RET_ATOM_AS,
	KBASE_TL_NRET_ATOM_AS,
	KBASE_TL_ATTRIB_ATOM_CONFIG,
	KBASE_TL_ATTRIB_ATOM_PRIORITY,
	KBASE_TL_ATTRIB_ATOM_STATE,
	KBASE_TL_ATTRIB_ATOM_PRIORITIZED,
	KBASE_TL_ATTRIB_ATOM_JIT,
	KBASE_TL_JIT_USEDPAGES,
	KBASE_TL_ATTRIB_ATOM_JITALLOCINFO,
	KBASE_TL_ATTRIB_ATOM_JITFREEINFO,
	KBASE_TL_ATTRIB_AS_CONFIG,
	KBASE_TL_EVENT_LPU_SOFTSTOP,
	KBASE_TL_EVENT_ATOM_SOFTSTOP_EX,
	KBASE_TL_EVENT_ATOM_SOFTSTOP_ISSUE,
	KBASE_TL_EVENT_ATOM_SOFTJOB_START,
	KBASE_TL_EVENT_ATOM_SOFTJOB_END,
	KBASE_JD_GPU_SOFT_RESET,
	KBASE_TL_NEW_KCPUQUEUE,
	KBASE_TL_RET_KCPUQUEUE_CTX,
	KBASE_TL_DEL_KCPUQUEUE,
	KBASE_TL_NRET_KCPUQUEUE_CTX,
	KBASE_TL_EVENT_KCPUQUEUE_ENQUEUE_FENCE_SIGNAL,
	KBASE_TL_EVENT_KCPUQUEUE_ENQUEUE_FENCE_WAIT,
	KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_ENQUEUE_CQS_WAIT,
	KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_ENQUEUE_CQS_WAIT,
	KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_ENQUEUE_CQS_WAIT,
	KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_ENQUEUE_CQS_SET,
	KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_ENQUEUE_CQS_SET,
	KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_ENQUEUE_CQS_SET,
	KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_ENQUEUE_DEBUGCOPY,
	KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_ENQUEUE_DEBUGCOPY,
	KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_ENQUEUE_DEBUGCOPY,
	KBASE_TL_EVENT_KCPUQUEUE_ENQUEUE_MAP_IMPORT,
	KBASE_TL_EVENT_KCPUQUEUE_ENQUEUE_UNMAP_IMPORT,
	KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_ENQUEUE_JIT_ALLOC,
	KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_ENQUEUE_JIT_ALLOC,
	KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_ENQUEUE_JIT_ALLOC,
	KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_ENQUEUE_JIT_FREE,
	KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_ENQUEUE_JIT_FREE,
	KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_ENQUEUE_JIT_FREE,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_FENCE_SIGNAL_START,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_FENCE_SIGNAL_END,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_FENCE_WAIT_START,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_FENCE_WAIT_END,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_CQS_WAIT_START,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_CQS_WAIT_END,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_CQS_SET_START,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_CQS_SET_END,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_DEBUGCOPY_START,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_DEBUGCOPY_END,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_MAP_IMPORT_START,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_MAP_IMPORT_END,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_UNMAP_IMPORT_START,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_UNMAP_IMPORT_END,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_JIT_ALLOC_START,
	KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_EXECUTE_JIT_ALLOC_END,
	KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_EXECUTE_JIT_ALLOC_END,
	KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_EXECUTE_JIT_ALLOC_END,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_JIT_FREE_START,
	KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_EXECUTE_JIT_FREE_END,
	KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_EXECUTE_JIT_FREE_END,
	KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_EXECUTE_JIT_FREE_END,
	KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_ERRORBARRIER,
	KBASE_OBJ_MSG_COUNT,
};

/* Message ids of trace events that are recorded in the auxiliary stream. */
enum tl_msg_id_aux {
	KBASE_AUX_PM_STATE,
	KBASE_AUX_PAGEFAULT,
	KBASE_AUX_PAGESALLOC,
	KBASE_AUX_DEVFREQ_TARGET,
	KBASE_AUX_PROTECTED_ENTER_START,
	KBASE_AUX_PROTECTED_ENTER_END,
	KBASE_AUX_PROTECTED_LEAVE_START,
	KBASE_AUX_PROTECTED_LEAVE_END,
	KBASE_AUX_JIT_STATS,
	KBASE_AUX_EVENT_JOB_SLOT,
	KBASE_AUX_MSG_COUNT,
};

#define OBJ_TL_LIST \
	TP_DESC(KBASE_TL_NEW_CTX, \
		"object ctx is created", \
		"@pII", \
		"ctx,ctx_nr,tgid") \
	TP_DESC(KBASE_TL_NEW_GPU, \
		"object gpu is created", \
		"@pII", \
		"gpu,gpu_id,core_count") \
	TP_DESC(KBASE_TL_NEW_LPU, \
		"object lpu is created", \
		"@pII", \
		"lpu,lpu_nr,lpu_fn") \
	TP_DESC(KBASE_TL_NEW_ATOM, \
		"object atom is created", \
		"@pI", \
		"atom,atom_nr") \
	TP_DESC(KBASE_TL_NEW_AS, \
		"address space object is created", \
		"@pI", \
		"address_space,as_nr") \
	TP_DESC(KBASE_TL_DEL_CTX, \
		"context is destroyed", \
		"@p", \
		"ctx") \
	TP_DESC(KBASE_TL_DEL_ATOM, \
		"atom is destroyed", \
		"@p", \
		"atom") \
	TP_DESC(KBASE_TL_LIFELINK_LPU_GPU, \
		"lpu is deleted with gpu", \
		"@pp", \
		"lpu,gpu") \
	TP_DESC(KBASE_TL_LIFELINK_AS_GPU, \
		"address space is deleted with gpu", \
		"@pp", \
		"address_space,gpu") \
	TP_DESC(KBASE_TL_RET_CTX_LPU, \
		"context is retained by lpu", \
		"@pp", \
		"ctx,lpu") \
	TP_DESC(KBASE_TL_RET_ATOM_CTX, \
		"atom is retained by context", \
		"@pp", \
		"atom,ctx") \
	TP_DESC(KBASE_TL_RET_ATOM_LPU, \
		"atom is retained by lpu", \
		"@pps", \
		"atom,lpu,attrib_match_list") \
	TP_DESC(KBASE_TL_NRET_CTX_LPU, \
		"context is released by lpu", \
		"@pp", \
		"ctx,lpu") \
	TP_DESC(KBASE_TL_NRET_ATOM_CTX, \
		"atom is released by context", \
		"@pp", \
		"atom,ctx") \
	TP_DESC(KBASE_TL_NRET_ATOM_LPU, \
		"atom is released by lpu", \
		"@pp", \
		"atom,lpu") \
	TP_DESC(KBASE_TL_RET_AS_CTX, \
		"address space is retained by context", \
		"@pp", \
		"address_space,ctx") \
	TP_DESC(KBASE_TL_NRET_AS_CTX, \
		"address space is released by context", \
		"@pp", \
		"address_space,ctx") \
	TP_DESC(KBASE_TL_RET_ATOM_AS, \
		"atom is retained by address space", \
		"@pp", \
		"atom,address_space") \
	TP_DESC(KBASE_TL_NRET_ATOM_AS, \
		"atom is released by address space", \
		"@pp", \
		"atom,address_space") \
	TP_DESC(KBASE_TL_ATTRIB_ATOM_CONFIG, \
		"atom job slot attributes", \
		"@pLLI", \
		"atom,descriptor,affinity,config") \
	TP_DESC(KBASE_TL_ATTRIB_ATOM_PRIORITY, \
		"atom priority", \
		"@pI", \
		"atom,prio") \
	TP_DESC(KBASE_TL_ATTRIB_ATOM_STATE, \
		"atom state", \
		"@pI", \
		"atom,state") \
	TP_DESC(KBASE_TL_ATTRIB_ATOM_PRIORITIZED, \
		"atom caused priority change", \
		"@p", \
		"atom") \
	TP_DESC(KBASE_TL_ATTRIB_ATOM_JIT, \
		"jit done for atom", \
		"@pLLILILLL", \
		"atom,edit_addr,new_addr,jit_flags,mem_flags,j_id,com_pgs,extent,va_pgs") \
	TP_DESC(KBASE_TL_JIT_USEDPAGES, \
		"used pages for jit", \
		"@LI", \
		"used_pages,j_id") \
	TP_DESC(KBASE_TL_ATTRIB_ATOM_JITALLOCINFO, \
		"Information about JIT allocations", \
		"@pLLLIIIII", \
		"atom,va_pgs,com_pgs,extent,j_id,bin_id,max_allocs,jit_flags,usg_id") \
	TP_DESC(KBASE_TL_ATTRIB_ATOM_JITFREEINFO, \
		"Information about JIT frees", \
		"@pI", \
		"atom,j_id") \
	TP_DESC(KBASE_TL_ATTRIB_AS_CONFIG, \
		"address space attributes", \
		"@pLLL", \
		"address_space,transtab,memattr,transcfg") \
	TP_DESC(KBASE_TL_EVENT_LPU_SOFTSTOP, \
		"softstop event on given lpu", \
		"@p", \
		"lpu") \
	TP_DESC(KBASE_TL_EVENT_ATOM_SOFTSTOP_EX, \
		"atom softstopped", \
		"@p", \
		"atom") \
	TP_DESC(KBASE_TL_EVENT_ATOM_SOFTSTOP_ISSUE, \
		"atom softstop issued", \
		"@p", \
		"atom") \
	TP_DESC(KBASE_TL_EVENT_ATOM_SOFTJOB_START, \
		"atom soft job has started", \
		"@p", \
		"atom") \
	TP_DESC(KBASE_TL_EVENT_ATOM_SOFTJOB_END, \
		"atom soft job has completed", \
		"@p", \
		"atom") \
	TP_DESC(KBASE_JD_GPU_SOFT_RESET, \
		"gpu soft reset", \
		"@p", \
		"gpu") \
	TP_DESC(KBASE_TL_NEW_KCPUQUEUE, \
		"New KCPU Queue", \
		"@ppI", \
		"kcpu_queue,ctx,kcpuq_num_pending_cmds") \
	TP_DESC(KBASE_TL_RET_KCPUQUEUE_CTX, \
		"Context retains KCPU Queue", \
		"@pp", \
		"kcpu_queue,ctx") \
	TP_DESC(KBASE_TL_DEL_KCPUQUEUE, \
		"Delete KCPU Queue", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_NRET_KCPUQUEUE_CTX, \
		"Context releases KCPU Queue", \
		"@pp", \
		"kcpu_queue,ctx") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_ENQUEUE_FENCE_SIGNAL, \
		"KCPU Queue enqueues Signal on Fence", \
		"@pL", \
		"kcpu_queue,fence") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_ENQUEUE_FENCE_WAIT, \
		"KCPU Queue enqueues Wait on Fence", \
		"@pL", \
		"kcpu_queue,fence") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_ENQUEUE_CQS_WAIT, \
		"Begin array of KCPU Queue enqueues Wait on Cross Queue Sync Object", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_ENQUEUE_CQS_WAIT, \
		"Array item of KCPU Queue enqueues Wait on Cross Queue Sync Object", \
		"@pLI", \
		"kcpu_queue,cqs_obj_gpu_addr,cqs_obj_compare_value") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_ENQUEUE_CQS_WAIT, \
		"End array of KCPU Queue enqueues Wait on Cross Queue Sync Object", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_ENQUEUE_CQS_SET, \
		"Begin array of KCPU Queue enqueues Set on Cross Queue Sync Object", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_ENQUEUE_CQS_SET, \
		"Array item of KCPU Queue enqueues Set on Cross Queue Sync Object", \
		"@pL", \
		"kcpu_queue,cqs_obj_gpu_addr") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_ENQUEUE_CQS_SET, \
		"End array of KCPU Queue enqueues Set on Cross Queue Sync Object", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_ENQUEUE_DEBUGCOPY, \
		"Begin array of KCPU Queue enqueues Debug Copy", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_ENQUEUE_DEBUGCOPY, \
		"Array item of KCPU Queue enqueues Debug Copy", \
		"@pL", \
		"kcpu_queue,debugcopy_dst_size") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_ENQUEUE_DEBUGCOPY, \
		"End array of KCPU Queue enqueues Debug Copy", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_ENQUEUE_MAP_IMPORT, \
		"KCPU Queue enqueues Map Import", \
		"@pL", \
		"kcpu_queue,map_import_buf_gpu_addr") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_ENQUEUE_UNMAP_IMPORT, \
		"KCPU Queue enqueues Unmap Import", \
		"@pL", \
		"kcpu_queue,map_import_buf_gpu_addr") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_ENQUEUE_JIT_ALLOC, \
		"Begin array of KCPU Queue enqueues JIT Alloc", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_ENQUEUE_JIT_ALLOC, \
		"Array item of KCPU Queue enqueues JIT Alloc", \
		"@pLLLLIIIII", \
		"kcpu_queue,jit_alloc_gpu_alloc_addr_dest,jit_alloc_va_pages,jit_alloc_commit_pages,jit_alloc_extent,jit_alloc_jit_id,jit_alloc_bin_id,jit_alloc_max_allocations,jit_alloc_flags,jit_alloc_usage_id") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_ENQUEUE_JIT_ALLOC, \
		"End array of KCPU Queue enqueues JIT Alloc", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_ENQUEUE_JIT_FREE, \
		"Begin array of KCPU Queue enqueues JIT Free", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_ENQUEUE_JIT_FREE, \
		"Array item of KCPU Queue enqueues JIT Free", \
		"@pI", \
		"kcpu_queue,jit_alloc_jit_id") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_ENQUEUE_JIT_FREE, \
		"End array of KCPU Queue enqueues JIT Free", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_FENCE_SIGNAL_START, \
		"KCPU Queue starts a Signal on Fence", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_FENCE_SIGNAL_END, \
		"KCPU Queue ends a Signal on Fence", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_FENCE_WAIT_START, \
		"KCPU Queue starts a Wait on Fence", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_FENCE_WAIT_END, \
		"KCPU Queue ends a Wait on Fence", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_CQS_WAIT_START, \
		"KCPU Queue starts a Wait on an array of Cross Queue Sync Objects", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_CQS_WAIT_END, \
		"KCPU Queue ends a Wait on an array of Cross Queue Sync Objects", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_CQS_SET_START, \
		"KCPU Queue starts a Set on an array of Cross Queue Sync Objects", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_CQS_SET_END, \
		"KCPU Queue ends a Set on an array of Cross Queue Sync Objects", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_DEBUGCOPY_START, \
		"KCPU Queue starts an array of Debug Copys", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_DEBUGCOPY_END, \
		"KCPU Queue ends an array of Debug Copys", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_MAP_IMPORT_START, \
		"KCPU Queue starts a Map Import", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_MAP_IMPORT_END, \
		"KCPU Queue ends a Map Import", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_UNMAP_IMPORT_START, \
		"KCPU Queue starts an Unmap Import", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_UNMAP_IMPORT_END, \
		"KCPU Queue ends an Unmap Import", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_JIT_ALLOC_START, \
		"KCPU Queue starts an array of JIT Allocs", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_EXECUTE_JIT_ALLOC_END, \
		"Begin array of KCPU Queue ends an array of JIT Allocs", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_EXECUTE_JIT_ALLOC_END, \
		"Array item of KCPU Queue ends an array of JIT Allocs", \
		"@pLL", \
		"kcpu_queue,jit_alloc_gpu_alloc_addr,jit_alloc_mmu_flags") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_EXECUTE_JIT_ALLOC_END, \
		"End array of KCPU Queue ends an array of JIT Allocs", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_JIT_FREE_START, \
		"KCPU Queue starts an array of JIT Frees", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_EXECUTE_JIT_FREE_END, \
		"Begin array of KCPU Queue ends an array of JIT Frees", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_EXECUTE_JIT_FREE_END, \
		"Array item of KCPU Queue ends an array of JIT Frees", \
		"@pL", \
		"kcpu_queue,jit_free_pages_used") \
	TP_DESC(KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_EXECUTE_JIT_FREE_END, \
		"End array of KCPU Queue ends an array of JIT Frees", \
		"@p", \
		"kcpu_queue") \
	TP_DESC(KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_ERRORBARRIER, \
		"KCPU Queue executes an Error Barrier", \
		"@p", \
		"kcpu_queue") \

#define MIPE_HEADER_BLOB_VAR_NAME    __obj_desc_header
#define MIPE_HEADER_TP_LIST          OBJ_TL_LIST
#define MIPE_HEADER_TP_LIST_COUNT    KBASE_OBJ_MSG_COUNT
#define MIPE_HEADER_PKT_CLASS        TL_PACKET_CLASS_OBJ

#include "mali_kbase_mipe_gen_header.h"

const char   *obj_desc_header = (const char *) &__obj_desc_header;
const size_t  obj_desc_header_size = sizeof(__obj_desc_header);

#define AUX_TL_LIST \
	TP_DESC(KBASE_AUX_PM_STATE, \
		"PM state", \
		"@IL", \
		"core_type,core_state_bitset") \
	TP_DESC(KBASE_AUX_PAGEFAULT, \
		"Page fault", \
		"@IIL", \
		"ctx_nr,as_nr,page_cnt_change") \
	TP_DESC(KBASE_AUX_PAGESALLOC, \
		"Total alloc pages change", \
		"@IL", \
		"ctx_nr,page_cnt") \
	TP_DESC(KBASE_AUX_DEVFREQ_TARGET, \
		"New device frequency target", \
		"@L", \
		"target_freq") \
	TP_DESC(KBASE_AUX_PROTECTED_ENTER_START, \
		"enter protected mode start", \
		"@p", \
		"gpu") \
	TP_DESC(KBASE_AUX_PROTECTED_ENTER_END, \
		"enter protected mode end", \
		"@p", \
		"gpu") \
	TP_DESC(KBASE_AUX_PROTECTED_LEAVE_START, \
		"leave protected mode start", \
		"@p", \
		"gpu") \
	TP_DESC(KBASE_AUX_PROTECTED_LEAVE_END, \
		"leave protected mode end", \
		"@p", \
		"gpu") \
	TP_DESC(KBASE_AUX_JIT_STATS, \
		"per-bin JIT statistics", \
		"@IIIIII", \
		"ctx_nr,bid,max_allocs,allocs,va_pages,ph_pages") \
	TP_DESC(KBASE_AUX_EVENT_JOB_SLOT, \
		"event on a given job slot", \
		"@pIII", \
		"ctx,slot_nr,atom_nr,event") \

#define MIPE_HEADER_BLOB_VAR_NAME    __aux_desc_header
#define MIPE_HEADER_TP_LIST          AUX_TL_LIST
#define MIPE_HEADER_TP_LIST_COUNT    KBASE_AUX_MSG_COUNT
#define MIPE_HEADER_PKT_CLASS        TL_PACKET_CLASS_AUX

#include "mali_kbase_mipe_gen_header.h"

const char   *aux_desc_header = (const char *) &__aux_desc_header;
const size_t  aux_desc_header_size = sizeof(__aux_desc_header);

void __kbase_tlstream_tl_new_ctx(
	struct kbase_tlstream *stream,
	const void *ctx,
	u32 ctx_nr,
	u32 tgid)
{
	const u32 msg_id = KBASE_TL_NEW_CTX;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(ctx)
		+ sizeof(ctx_nr)
		+ sizeof(tgid)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &ctx, sizeof(ctx));
	pos = kbasep_serialize_bytes(buffer,
		pos, &ctx_nr, sizeof(ctx_nr));
	pos = kbasep_serialize_bytes(buffer,
		pos, &tgid, sizeof(tgid));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_new_gpu(
	struct kbase_tlstream *stream,
	const void *gpu,
	u32 gpu_id,
	u32 core_count)
{
	const u32 msg_id = KBASE_TL_NEW_GPU;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(gpu)
		+ sizeof(gpu_id)
		+ sizeof(core_count)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &gpu, sizeof(gpu));
	pos = kbasep_serialize_bytes(buffer,
		pos, &gpu_id, sizeof(gpu_id));
	pos = kbasep_serialize_bytes(buffer,
		pos, &core_count, sizeof(core_count));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_new_lpu(
	struct kbase_tlstream *stream,
	const void *lpu,
	u32 lpu_nr,
	u32 lpu_fn)
{
	const u32 msg_id = KBASE_TL_NEW_LPU;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(lpu)
		+ sizeof(lpu_nr)
		+ sizeof(lpu_fn)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &lpu, sizeof(lpu));
	pos = kbasep_serialize_bytes(buffer,
		pos, &lpu_nr, sizeof(lpu_nr));
	pos = kbasep_serialize_bytes(buffer,
		pos, &lpu_fn, sizeof(lpu_fn));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_new_atom(
	struct kbase_tlstream *stream,
	const void *atom,
	u32 atom_nr)
{
	const u32 msg_id = KBASE_TL_NEW_ATOM;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		+ sizeof(atom_nr)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom_nr, sizeof(atom_nr));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_new_as(
	struct kbase_tlstream *stream,
	const void *address_space,
	u32 as_nr)
{
	const u32 msg_id = KBASE_TL_NEW_AS;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(address_space)
		+ sizeof(as_nr)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &address_space, sizeof(address_space));
	pos = kbasep_serialize_bytes(buffer,
		pos, &as_nr, sizeof(as_nr));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_del_ctx(
	struct kbase_tlstream *stream,
	const void *ctx)
{
	const u32 msg_id = KBASE_TL_DEL_CTX;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(ctx)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &ctx, sizeof(ctx));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_del_atom(
	struct kbase_tlstream *stream,
	const void *atom)
{
	const u32 msg_id = KBASE_TL_DEL_ATOM;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_lifelink_lpu_gpu(
	struct kbase_tlstream *stream,
	const void *lpu,
	const void *gpu)
{
	const u32 msg_id = KBASE_TL_LIFELINK_LPU_GPU;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(lpu)
		+ sizeof(gpu)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &lpu, sizeof(lpu));
	pos = kbasep_serialize_bytes(buffer,
		pos, &gpu, sizeof(gpu));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_lifelink_as_gpu(
	struct kbase_tlstream *stream,
	const void *address_space,
	const void *gpu)
{
	const u32 msg_id = KBASE_TL_LIFELINK_AS_GPU;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(address_space)
		+ sizeof(gpu)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &address_space, sizeof(address_space));
	pos = kbasep_serialize_bytes(buffer,
		pos, &gpu, sizeof(gpu));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_ret_ctx_lpu(
	struct kbase_tlstream *stream,
	const void *ctx,
	const void *lpu)
{
	const u32 msg_id = KBASE_TL_RET_CTX_LPU;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(ctx)
		+ sizeof(lpu)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &ctx, sizeof(ctx));
	pos = kbasep_serialize_bytes(buffer,
		pos, &lpu, sizeof(lpu));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_ret_atom_ctx(
	struct kbase_tlstream *stream,
	const void *atom,
	const void *ctx)
{
	const u32 msg_id = KBASE_TL_RET_ATOM_CTX;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		+ sizeof(ctx)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));
	pos = kbasep_serialize_bytes(buffer,
		pos, &ctx, sizeof(ctx));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_ret_atom_lpu(
	struct kbase_tlstream *stream,
	const void *atom,
	const void *lpu,
	const char *attrib_match_list)
{
	const u32 msg_id = KBASE_TL_RET_ATOM_LPU;
	const size_t s0 = sizeof(u32) + sizeof(char)
		+ strnlen(attrib_match_list, STRLEN_MAX);
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		+ sizeof(lpu)
		+ s0
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));
	pos = kbasep_serialize_bytes(buffer,
		pos, &lpu, sizeof(lpu));
	pos = kbasep_serialize_string(buffer,
		pos, attrib_match_list, s0);

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_nret_ctx_lpu(
	struct kbase_tlstream *stream,
	const void *ctx,
	const void *lpu)
{
	const u32 msg_id = KBASE_TL_NRET_CTX_LPU;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(ctx)
		+ sizeof(lpu)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &ctx, sizeof(ctx));
	pos = kbasep_serialize_bytes(buffer,
		pos, &lpu, sizeof(lpu));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_nret_atom_ctx(
	struct kbase_tlstream *stream,
	const void *atom,
	const void *ctx)
{
	const u32 msg_id = KBASE_TL_NRET_ATOM_CTX;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		+ sizeof(ctx)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));
	pos = kbasep_serialize_bytes(buffer,
		pos, &ctx, sizeof(ctx));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_nret_atom_lpu(
	struct kbase_tlstream *stream,
	const void *atom,
	const void *lpu)
{
	const u32 msg_id = KBASE_TL_NRET_ATOM_LPU;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		+ sizeof(lpu)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));
	pos = kbasep_serialize_bytes(buffer,
		pos, &lpu, sizeof(lpu));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_ret_as_ctx(
	struct kbase_tlstream *stream,
	const void *address_space,
	const void *ctx)
{
	const u32 msg_id = KBASE_TL_RET_AS_CTX;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(address_space)
		+ sizeof(ctx)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &address_space, sizeof(address_space));
	pos = kbasep_serialize_bytes(buffer,
		pos, &ctx, sizeof(ctx));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_nret_as_ctx(
	struct kbase_tlstream *stream,
	const void *address_space,
	const void *ctx)
{
	const u32 msg_id = KBASE_TL_NRET_AS_CTX;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(address_space)
		+ sizeof(ctx)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &address_space, sizeof(address_space));
	pos = kbasep_serialize_bytes(buffer,
		pos, &ctx, sizeof(ctx));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_ret_atom_as(
	struct kbase_tlstream *stream,
	const void *atom,
	const void *address_space)
{
	const u32 msg_id = KBASE_TL_RET_ATOM_AS;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		+ sizeof(address_space)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));
	pos = kbasep_serialize_bytes(buffer,
		pos, &address_space, sizeof(address_space));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_nret_atom_as(
	struct kbase_tlstream *stream,
	const void *atom,
	const void *address_space)
{
	const u32 msg_id = KBASE_TL_NRET_ATOM_AS;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		+ sizeof(address_space)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));
	pos = kbasep_serialize_bytes(buffer,
		pos, &address_space, sizeof(address_space));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_attrib_atom_config(
	struct kbase_tlstream *stream,
	const void *atom,
	u64 descriptor,
	u64 affinity,
	u32 config)
{
	const u32 msg_id = KBASE_TL_ATTRIB_ATOM_CONFIG;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		+ sizeof(descriptor)
		+ sizeof(affinity)
		+ sizeof(config)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));
	pos = kbasep_serialize_bytes(buffer,
		pos, &descriptor, sizeof(descriptor));
	pos = kbasep_serialize_bytes(buffer,
		pos, &affinity, sizeof(affinity));
	pos = kbasep_serialize_bytes(buffer,
		pos, &config, sizeof(config));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_attrib_atom_priority(
	struct kbase_tlstream *stream,
	const void *atom,
	u32 prio)
{
	const u32 msg_id = KBASE_TL_ATTRIB_ATOM_PRIORITY;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		+ sizeof(prio)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));
	pos = kbasep_serialize_bytes(buffer,
		pos, &prio, sizeof(prio));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_attrib_atom_state(
	struct kbase_tlstream *stream,
	const void *atom,
	u32 state)
{
	const u32 msg_id = KBASE_TL_ATTRIB_ATOM_STATE;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		+ sizeof(state)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));
	pos = kbasep_serialize_bytes(buffer,
		pos, &state, sizeof(state));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_attrib_atom_prioritized(
	struct kbase_tlstream *stream,
	const void *atom)
{
	const u32 msg_id = KBASE_TL_ATTRIB_ATOM_PRIORITIZED;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_attrib_atom_jit(
	struct kbase_tlstream *stream,
	const void *atom,
	u64 edit_addr,
	u64 new_addr,
	u32 jit_flags,
	u64 mem_flags,
	u32 j_id,
	u64 com_pgs,
	u64 extent,
	u64 va_pgs)
{
	const u32 msg_id = KBASE_TL_ATTRIB_ATOM_JIT;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		+ sizeof(edit_addr)
		+ sizeof(new_addr)
		+ sizeof(jit_flags)
		+ sizeof(mem_flags)
		+ sizeof(j_id)
		+ sizeof(com_pgs)
		+ sizeof(extent)
		+ sizeof(va_pgs)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));
	pos = kbasep_serialize_bytes(buffer,
		pos, &edit_addr, sizeof(edit_addr));
	pos = kbasep_serialize_bytes(buffer,
		pos, &new_addr, sizeof(new_addr));
	pos = kbasep_serialize_bytes(buffer,
		pos, &jit_flags, sizeof(jit_flags));
	pos = kbasep_serialize_bytes(buffer,
		pos, &mem_flags, sizeof(mem_flags));
	pos = kbasep_serialize_bytes(buffer,
		pos, &j_id, sizeof(j_id));
	pos = kbasep_serialize_bytes(buffer,
		pos, &com_pgs, sizeof(com_pgs));
	pos = kbasep_serialize_bytes(buffer,
		pos, &extent, sizeof(extent));
	pos = kbasep_serialize_bytes(buffer,
		pos, &va_pgs, sizeof(va_pgs));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_jit_usedpages(
	struct kbase_tlstream *stream,
	u64 used_pages,
	u32 j_id)
{
	const u32 msg_id = KBASE_TL_JIT_USEDPAGES;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(used_pages)
		+ sizeof(j_id)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &used_pages, sizeof(used_pages));
	pos = kbasep_serialize_bytes(buffer,
		pos, &j_id, sizeof(j_id));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_attrib_atom_jitallocinfo(
	struct kbase_tlstream *stream,
	const void *atom,
	u64 va_pgs,
	u64 com_pgs,
	u64 extent,
	u32 j_id,
	u32 bin_id,
	u32 max_allocs,
	u32 jit_flags,
	u32 usg_id)
{
	const u32 msg_id = KBASE_TL_ATTRIB_ATOM_JITALLOCINFO;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		+ sizeof(va_pgs)
		+ sizeof(com_pgs)
		+ sizeof(extent)
		+ sizeof(j_id)
		+ sizeof(bin_id)
		+ sizeof(max_allocs)
		+ sizeof(jit_flags)
		+ sizeof(usg_id)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));
	pos = kbasep_serialize_bytes(buffer,
		pos, &va_pgs, sizeof(va_pgs));
	pos = kbasep_serialize_bytes(buffer,
		pos, &com_pgs, sizeof(com_pgs));
	pos = kbasep_serialize_bytes(buffer,
		pos, &extent, sizeof(extent));
	pos = kbasep_serialize_bytes(buffer,
		pos, &j_id, sizeof(j_id));
	pos = kbasep_serialize_bytes(buffer,
		pos, &bin_id, sizeof(bin_id));
	pos = kbasep_serialize_bytes(buffer,
		pos, &max_allocs, sizeof(max_allocs));
	pos = kbasep_serialize_bytes(buffer,
		pos, &jit_flags, sizeof(jit_flags));
	pos = kbasep_serialize_bytes(buffer,
		pos, &usg_id, sizeof(usg_id));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_attrib_atom_jitfreeinfo(
	struct kbase_tlstream *stream,
	const void *atom,
	u32 j_id)
{
	const u32 msg_id = KBASE_TL_ATTRIB_ATOM_JITFREEINFO;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		+ sizeof(j_id)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));
	pos = kbasep_serialize_bytes(buffer,
		pos, &j_id, sizeof(j_id));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_attrib_as_config(
	struct kbase_tlstream *stream,
	const void *address_space,
	u64 transtab,
	u64 memattr,
	u64 transcfg)
{
	const u32 msg_id = KBASE_TL_ATTRIB_AS_CONFIG;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(address_space)
		+ sizeof(transtab)
		+ sizeof(memattr)
		+ sizeof(transcfg)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &address_space, sizeof(address_space));
	pos = kbasep_serialize_bytes(buffer,
		pos, &transtab, sizeof(transtab));
	pos = kbasep_serialize_bytes(buffer,
		pos, &memattr, sizeof(memattr));
	pos = kbasep_serialize_bytes(buffer,
		pos, &transcfg, sizeof(transcfg));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_lpu_softstop(
	struct kbase_tlstream *stream,
	const void *lpu)
{
	const u32 msg_id = KBASE_TL_EVENT_LPU_SOFTSTOP;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(lpu)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &lpu, sizeof(lpu));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_atom_softstop_ex(
	struct kbase_tlstream *stream,
	const void *atom)
{
	const u32 msg_id = KBASE_TL_EVENT_ATOM_SOFTSTOP_EX;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_atom_softstop_issue(
	struct kbase_tlstream *stream,
	const void *atom)
{
	const u32 msg_id = KBASE_TL_EVENT_ATOM_SOFTSTOP_ISSUE;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_atom_softjob_start(
	struct kbase_tlstream *stream,
	const void *atom)
{
	const u32 msg_id = KBASE_TL_EVENT_ATOM_SOFTJOB_START;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_atom_softjob_end(
	struct kbase_tlstream *stream,
	const void *atom)
{
	const u32 msg_id = KBASE_TL_EVENT_ATOM_SOFTJOB_END;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(atom)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom, sizeof(atom));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_jd_gpu_soft_reset(
	struct kbase_tlstream *stream,
	const void *gpu)
{
	const u32 msg_id = KBASE_JD_GPU_SOFT_RESET;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(gpu)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &gpu, sizeof(gpu));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_aux_pm_state(
	struct kbase_tlstream *stream,
	u32 core_type,
	u64 core_state_bitset)
{
	const u32 msg_id = KBASE_AUX_PM_STATE;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(core_type)
		+ sizeof(core_state_bitset)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &core_type, sizeof(core_type));
	pos = kbasep_serialize_bytes(buffer,
		pos, &core_state_bitset, sizeof(core_state_bitset));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_aux_pagefault(
	struct kbase_tlstream *stream,
	u32 ctx_nr,
	u32 as_nr,
	u64 page_cnt_change)
{
	const u32 msg_id = KBASE_AUX_PAGEFAULT;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(ctx_nr)
		+ sizeof(as_nr)
		+ sizeof(page_cnt_change)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &ctx_nr, sizeof(ctx_nr));
	pos = kbasep_serialize_bytes(buffer,
		pos, &as_nr, sizeof(as_nr));
	pos = kbasep_serialize_bytes(buffer,
		pos, &page_cnt_change, sizeof(page_cnt_change));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_aux_pagesalloc(
	struct kbase_tlstream *stream,
	u32 ctx_nr,
	u64 page_cnt)
{
	const u32 msg_id = KBASE_AUX_PAGESALLOC;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(ctx_nr)
		+ sizeof(page_cnt)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &ctx_nr, sizeof(ctx_nr));
	pos = kbasep_serialize_bytes(buffer,
		pos, &page_cnt, sizeof(page_cnt));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_aux_devfreq_target(
	struct kbase_tlstream *stream,
	u64 target_freq)
{
	const u32 msg_id = KBASE_AUX_DEVFREQ_TARGET;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(target_freq)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &target_freq, sizeof(target_freq));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_aux_protected_enter_start(
	struct kbase_tlstream *stream,
	const void *gpu)
{
	const u32 msg_id = KBASE_AUX_PROTECTED_ENTER_START;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(gpu)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &gpu, sizeof(gpu));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_aux_protected_enter_end(
	struct kbase_tlstream *stream,
	const void *gpu)
{
	const u32 msg_id = KBASE_AUX_PROTECTED_ENTER_END;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(gpu)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &gpu, sizeof(gpu));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_aux_protected_leave_start(
	struct kbase_tlstream *stream,
	const void *gpu)
{
	const u32 msg_id = KBASE_AUX_PROTECTED_LEAVE_START;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(gpu)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &gpu, sizeof(gpu));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_aux_protected_leave_end(
	struct kbase_tlstream *stream,
	const void *gpu)
{
	const u32 msg_id = KBASE_AUX_PROTECTED_LEAVE_END;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(gpu)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &gpu, sizeof(gpu));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_aux_jit_stats(
	struct kbase_tlstream *stream,
	u32 ctx_nr,
	u32 bid,
	u32 max_allocs,
	u32 allocs,
	u32 va_pages,
	u32 ph_pages)
{
	const u32 msg_id = KBASE_AUX_JIT_STATS;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(ctx_nr)
		+ sizeof(bid)
		+ sizeof(max_allocs)
		+ sizeof(allocs)
		+ sizeof(va_pages)
		+ sizeof(ph_pages)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &ctx_nr, sizeof(ctx_nr));
	pos = kbasep_serialize_bytes(buffer,
		pos, &bid, sizeof(bid));
	pos = kbasep_serialize_bytes(buffer,
		pos, &max_allocs, sizeof(max_allocs));
	pos = kbasep_serialize_bytes(buffer,
		pos, &allocs, sizeof(allocs));
	pos = kbasep_serialize_bytes(buffer,
		pos, &va_pages, sizeof(va_pages));
	pos = kbasep_serialize_bytes(buffer,
		pos, &ph_pages, sizeof(ph_pages));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_aux_event_job_slot(
	struct kbase_tlstream *stream,
	const void *ctx,
	u32 slot_nr,
	u32 atom_nr,
	u32 event)
{
	const u32 msg_id = KBASE_AUX_EVENT_JOB_SLOT;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(ctx)
		+ sizeof(slot_nr)
		+ sizeof(atom_nr)
		+ sizeof(event)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &ctx, sizeof(ctx));
	pos = kbasep_serialize_bytes(buffer,
		pos, &slot_nr, sizeof(slot_nr));
	pos = kbasep_serialize_bytes(buffer,
		pos, &atom_nr, sizeof(atom_nr));
	pos = kbasep_serialize_bytes(buffer,
		pos, &event, sizeof(event));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_new_kcpuqueue(
	struct kbase_tlstream *stream,
	const void *kcpu_queue,
	const void *ctx,
	u32 kcpuq_num_pending_cmds)
{
	const u32 msg_id = KBASE_TL_NEW_KCPUQUEUE;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		+ sizeof(ctx)
		+ sizeof(kcpuq_num_pending_cmds)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));
	pos = kbasep_serialize_bytes(buffer,
		pos, &ctx, sizeof(ctx));
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpuq_num_pending_cmds, sizeof(kcpuq_num_pending_cmds));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_ret_kcpuqueue_ctx(
	struct kbase_tlstream *stream,
	const void *kcpu_queue,
	const void *ctx)
{
	const u32 msg_id = KBASE_TL_RET_KCPUQUEUE_CTX;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		+ sizeof(ctx)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));
	pos = kbasep_serialize_bytes(buffer,
		pos, &ctx, sizeof(ctx));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_del_kcpuqueue(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_DEL_KCPUQUEUE;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_nret_kcpuqueue_ctx(
	struct kbase_tlstream *stream,
	const void *kcpu_queue,
	const void *ctx)
{
	const u32 msg_id = KBASE_TL_NRET_KCPUQUEUE_CTX;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		+ sizeof(ctx)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));
	pos = kbasep_serialize_bytes(buffer,
		pos, &ctx, sizeof(ctx));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_enqueue_fence_signal(
	struct kbase_tlstream *stream,
	const void *kcpu_queue,
	u64 fence)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_ENQUEUE_FENCE_SIGNAL;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		+ sizeof(fence)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));
	pos = kbasep_serialize_bytes(buffer,
		pos, &fence, sizeof(fence));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_enqueue_fence_wait(
	struct kbase_tlstream *stream,
	const void *kcpu_queue,
	u64 fence)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_ENQUEUE_FENCE_WAIT;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		+ sizeof(fence)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));
	pos = kbasep_serialize_bytes(buffer,
		pos, &fence, sizeof(fence));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_begin_kcpuqueue_enqueue_cqs_wait(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_ENQUEUE_CQS_WAIT;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_item_kcpuqueue_enqueue_cqs_wait(
	struct kbase_tlstream *stream,
	const void *kcpu_queue,
	u64 cqs_obj_gpu_addr,
	u32 cqs_obj_compare_value)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_ENQUEUE_CQS_WAIT;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		+ sizeof(cqs_obj_gpu_addr)
		+ sizeof(cqs_obj_compare_value)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));
	pos = kbasep_serialize_bytes(buffer,
		pos, &cqs_obj_gpu_addr, sizeof(cqs_obj_gpu_addr));
	pos = kbasep_serialize_bytes(buffer,
		pos, &cqs_obj_compare_value, sizeof(cqs_obj_compare_value));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_end_kcpuqueue_enqueue_cqs_wait(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_ENQUEUE_CQS_WAIT;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_begin_kcpuqueue_enqueue_cqs_set(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_ENQUEUE_CQS_SET;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_item_kcpuqueue_enqueue_cqs_set(
	struct kbase_tlstream *stream,
	const void *kcpu_queue,
	u64 cqs_obj_gpu_addr)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_ENQUEUE_CQS_SET;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		+ sizeof(cqs_obj_gpu_addr)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));
	pos = kbasep_serialize_bytes(buffer,
		pos, &cqs_obj_gpu_addr, sizeof(cqs_obj_gpu_addr));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_end_kcpuqueue_enqueue_cqs_set(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_ENQUEUE_CQS_SET;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_begin_kcpuqueue_enqueue_debugcopy(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_ENQUEUE_DEBUGCOPY;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_item_kcpuqueue_enqueue_debugcopy(
	struct kbase_tlstream *stream,
	const void *kcpu_queue,
	u64 debugcopy_dst_size)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_ENQUEUE_DEBUGCOPY;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		+ sizeof(debugcopy_dst_size)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));
	pos = kbasep_serialize_bytes(buffer,
		pos, &debugcopy_dst_size, sizeof(debugcopy_dst_size));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_end_kcpuqueue_enqueue_debugcopy(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_ENQUEUE_DEBUGCOPY;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_enqueue_map_import(
	struct kbase_tlstream *stream,
	const void *kcpu_queue,
	u64 map_import_buf_gpu_addr)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_ENQUEUE_MAP_IMPORT;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		+ sizeof(map_import_buf_gpu_addr)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));
	pos = kbasep_serialize_bytes(buffer,
		pos, &map_import_buf_gpu_addr, sizeof(map_import_buf_gpu_addr));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_enqueue_unmap_import(
	struct kbase_tlstream *stream,
	const void *kcpu_queue,
	u64 map_import_buf_gpu_addr)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_ENQUEUE_UNMAP_IMPORT;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		+ sizeof(map_import_buf_gpu_addr)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));
	pos = kbasep_serialize_bytes(buffer,
		pos, &map_import_buf_gpu_addr, sizeof(map_import_buf_gpu_addr));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_begin_kcpuqueue_enqueue_jit_alloc(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_ENQUEUE_JIT_ALLOC;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_item_kcpuqueue_enqueue_jit_alloc(
	struct kbase_tlstream *stream,
	const void *kcpu_queue,
	u64 jit_alloc_gpu_alloc_addr_dest,
	u64 jit_alloc_va_pages,
	u64 jit_alloc_commit_pages,
	u64 jit_alloc_extent,
	u32 jit_alloc_jit_id,
	u32 jit_alloc_bin_id,
	u32 jit_alloc_max_allocations,
	u32 jit_alloc_flags,
	u32 jit_alloc_usage_id)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_ENQUEUE_JIT_ALLOC;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		+ sizeof(jit_alloc_gpu_alloc_addr_dest)
		+ sizeof(jit_alloc_va_pages)
		+ sizeof(jit_alloc_commit_pages)
		+ sizeof(jit_alloc_extent)
		+ sizeof(jit_alloc_jit_id)
		+ sizeof(jit_alloc_bin_id)
		+ sizeof(jit_alloc_max_allocations)
		+ sizeof(jit_alloc_flags)
		+ sizeof(jit_alloc_usage_id)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));
	pos = kbasep_serialize_bytes(buffer,
		pos, &jit_alloc_gpu_alloc_addr_dest, sizeof(jit_alloc_gpu_alloc_addr_dest));
	pos = kbasep_serialize_bytes(buffer,
		pos, &jit_alloc_va_pages, sizeof(jit_alloc_va_pages));
	pos = kbasep_serialize_bytes(buffer,
		pos, &jit_alloc_commit_pages, sizeof(jit_alloc_commit_pages));
	pos = kbasep_serialize_bytes(buffer,
		pos, &jit_alloc_extent, sizeof(jit_alloc_extent));
	pos = kbasep_serialize_bytes(buffer,
		pos, &jit_alloc_jit_id, sizeof(jit_alloc_jit_id));
	pos = kbasep_serialize_bytes(buffer,
		pos, &jit_alloc_bin_id, sizeof(jit_alloc_bin_id));
	pos = kbasep_serialize_bytes(buffer,
		pos, &jit_alloc_max_allocations, sizeof(jit_alloc_max_allocations));
	pos = kbasep_serialize_bytes(buffer,
		pos, &jit_alloc_flags, sizeof(jit_alloc_flags));
	pos = kbasep_serialize_bytes(buffer,
		pos, &jit_alloc_usage_id, sizeof(jit_alloc_usage_id));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_end_kcpuqueue_enqueue_jit_alloc(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_ENQUEUE_JIT_ALLOC;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_begin_kcpuqueue_enqueue_jit_free(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_ENQUEUE_JIT_FREE;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_item_kcpuqueue_enqueue_jit_free(
	struct kbase_tlstream *stream,
	const void *kcpu_queue,
	u32 jit_alloc_jit_id)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_ENQUEUE_JIT_FREE;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		+ sizeof(jit_alloc_jit_id)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));
	pos = kbasep_serialize_bytes(buffer,
		pos, &jit_alloc_jit_id, sizeof(jit_alloc_jit_id));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_end_kcpuqueue_enqueue_jit_free(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_ENQUEUE_JIT_FREE;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_fence_signal_start(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_FENCE_SIGNAL_START;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_fence_signal_end(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_FENCE_SIGNAL_END;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_fence_wait_start(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_FENCE_WAIT_START;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_fence_wait_end(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_FENCE_WAIT_END;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_cqs_wait_start(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_CQS_WAIT_START;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_cqs_wait_end(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_CQS_WAIT_END;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_cqs_set_start(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_CQS_SET_START;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_cqs_set_end(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_CQS_SET_END;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_debugcopy_start(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_DEBUGCOPY_START;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_debugcopy_end(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_DEBUGCOPY_END;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_map_import_start(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_MAP_IMPORT_START;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_map_import_end(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_MAP_IMPORT_END;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_unmap_import_start(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_UNMAP_IMPORT_START;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_unmap_import_end(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_UNMAP_IMPORT_END;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_jit_alloc_start(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_JIT_ALLOC_START;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_begin_kcpuqueue_execute_jit_alloc_end(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_EXECUTE_JIT_ALLOC_END;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_item_kcpuqueue_execute_jit_alloc_end(
	struct kbase_tlstream *stream,
	const void *kcpu_queue,
	u64 jit_alloc_gpu_alloc_addr,
	u64 jit_alloc_mmu_flags)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_EXECUTE_JIT_ALLOC_END;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		+ sizeof(jit_alloc_gpu_alloc_addr)
		+ sizeof(jit_alloc_mmu_flags)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));
	pos = kbasep_serialize_bytes(buffer,
		pos, &jit_alloc_gpu_alloc_addr, sizeof(jit_alloc_gpu_alloc_addr));
	pos = kbasep_serialize_bytes(buffer,
		pos, &jit_alloc_mmu_flags, sizeof(jit_alloc_mmu_flags));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_end_kcpuqueue_execute_jit_alloc_end(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_EXECUTE_JIT_ALLOC_END;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_jit_free_start(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_JIT_FREE_START;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_begin_kcpuqueue_execute_jit_free_end(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_BEGIN_KCPUQUEUE_EXECUTE_JIT_FREE_END;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_item_kcpuqueue_execute_jit_free_end(
	struct kbase_tlstream *stream,
	const void *kcpu_queue,
	u64 jit_free_pages_used)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_ITEM_KCPUQUEUE_EXECUTE_JIT_FREE_END;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		+ sizeof(jit_free_pages_used)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));
	pos = kbasep_serialize_bytes(buffer,
		pos, &jit_free_pages_used, sizeof(jit_free_pages_used));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_array_end_kcpuqueue_execute_jit_free_end(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_ARRAY_END_KCPUQUEUE_EXECUTE_JIT_FREE_END;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

void __kbase_tlstream_tl_event_kcpuqueue_execute_errorbarrier(
	struct kbase_tlstream *stream,
	const void *kcpu_queue)
{
	const u32 msg_id = KBASE_TL_EVENT_KCPUQUEUE_EXECUTE_ERRORBARRIER;
	const size_t msg_size = sizeof(msg_id) + sizeof(u64)
		+ sizeof(kcpu_queue)
		;
	char *buffer;
	unsigned long acq_flags;
	size_t pos = 0;

	buffer = kbase_tlstream_msgbuf_acquire(stream, msg_size, &acq_flags);

	pos = kbasep_serialize_bytes(buffer, pos, &msg_id, sizeof(msg_id));
	pos = kbasep_serialize_timestamp(buffer, pos);
	pos = kbasep_serialize_bytes(buffer,
		pos, &kcpu_queue, sizeof(kcpu_queue));

	kbase_tlstream_msgbuf_release(stream, acq_flags);
}

/* clang-format on */
