/*
 * drivers/amlogic/media/enhancement/amvecm/arch/vpp_hdr_regs.h
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#ifndef VPP_HDR_REGS_H
#define VPP_HDR_REGS_H

#define XVYCC_LUT_R_ADDR_PORT	0x315e
#define XVYCC_LUT_R_DATA_PORT	0x315f
#define XVYCC_LUT_G_ADDR_PORT	0x3160
#define XVYCC_LUT_G_DATA_PORT	0x3161
#define XVYCC_LUT_B_ADDR_PORT	0x3162
#define XVYCC_LUT_B_DATA_PORT	0x3163
#define XVYCC_INV_LUT_CTL		0x3164
#define XVYCC_LUT_CTL			0x3165

#define XVYCC_INV_LUT_Y_ADDR_PORT     0x3158
#define XVYCC_INV_LUT_Y_DATA_PORT     0x3159

extern struct am_regs_s r_lut_hdr_hdr;
extern struct am_regs_s r_lut_sdr_sdr;
extern struct am_regs_s r_lut_hdr_sdr_level1;
extern struct am_regs_s r_lut_hdr_sdr_level2;
extern struct am_regs_s r_lut_hdr_sdr_level3;

#define VD1_HDR2_CTRL                      0x3800
#define VD1_HDR2_CLK_GATE                  0x3801
#define VD1_HDR2_MATRIXI_COEF00_01         0x3802
#define VD1_HDR2_MATRIXI_COEF02_10         0x3803
#define VD1_HDR2_MATRIXI_COEF11_12         0x3804
#define VD1_HDR2_MATRIXI_COEF20_21         0x3805
#define VD1_HDR2_MATRIXI_COEF22            0x3806
#define VD1_HDR2_MATRIXI_COEF30_31         0x3807
#define VD1_HDR2_MATRIXI_COEF32_40         0x3808
#define VD1_HDR2_MATRIXI_COEF41_42         0x3809
#define VD1_HDR2_MATRIXI_OFFSET0_1         0x380a
#define VD1_HDR2_MATRIXI_OFFSET2           0x380b
#define VD1_HDR2_MATRIXI_PRE_OFFSET0_1     0x380c
#define VD1_HDR2_MATRIXI_PRE_OFFSET2       0x380d
#define VD1_HDR2_MATRIXO_COEF00_01         0x380e
#define VD1_HDR2_MATRIXO_COEF02_10         0x380f
#define VD1_HDR2_MATRIXO_COEF11_12         0x3810
#define VD1_HDR2_MATRIXO_COEF20_21         0x3811
#define VD1_HDR2_MATRIXO_COEF22            0x3812
#define VD1_HDR2_MATRIXO_COEF30_31         0x3813
#define VD1_HDR2_MATRIXO_COEF32_40         0x3814
#define VD1_HDR2_MATRIXO_COEF41_42         0x3815
#define VD1_HDR2_MATRIXO_OFFSET0_1         0x3816
#define VD1_HDR2_MATRIXO_OFFSET2           0x3817
#define VD1_HDR2_MATRIXO_PRE_OFFSET0_1     0x3818
#define VD1_HDR2_MATRIXO_PRE_OFFSET2       0x3819
#define VD1_HDR2_MATRIXI_CLIP              0x381a
#define VD1_HDR2_MATRIXO_CLIP              0x381b
#define VD1_HDR2_CGAIN_OFFT                0x381c
/*TL1 hist read is 0x3840, tm2 is 0x381d*/
#define VD1_HDR2_HIST_RD_2                 0x381d
#define VD1_EOTF_LUT_ADDR_PORT             0x381e
#define VD1_EOTF_LUT_DATA_PORT             0x381f
#define VD1_OETF_LUT_ADDR_PORT             0x3820
#define VD1_OETF_LUT_DATA_PORT             0x3821
#define VD1_CGAIN_LUT_ADDR_PORT            0x3822
#define VD1_CGAIN_LUT_DATA_PORT            0x3823
#define VD1_HDR2_CGAIN_COEF0               0x3824
#define VD1_HDR2_CGAIN_COEF1               0x3825
#define VD1_OGAIN_LUT_ADDR_PORT            0x3826
#define VD1_OGAIN_LUT_DATA_PORT            0x3827
#define VD1_HDR2_ADPS_CTRL                 0x3828
#define VD1_HDR2_ADPS_ALPHA0               0x3829
#define VD1_HDR2_ADPS_ALPHA1               0x382a
#define VD1_HDR2_ADPS_BETA0                0x382b
#define VD1_HDR2_ADPS_BETA1                0x382c
#define VD1_HDR2_ADPS_BETA2                0x382d
#define VD1_HDR2_ADPS_COEF0                0x382e
#define VD1_HDR2_ADPS_COEF1                0x382f
#define VD1_HDR2_GMUT_CTRL                 0x3830
#define VD1_HDR2_GMUT_COEF0                0x3831
#define VD1_HDR2_GMUT_COEF1                0x3832
#define VD1_HDR2_GMUT_COEF2                0x3833
#define VD1_HDR2_GMUT_COEF3                0x3834
#define VD1_HDR2_GMUT_COEF4                0x3835
#define VD1_HDR2_PIPE_CTRL1                0x3836
#define VD1_HDR2_PIPE_CTRL2                0x3837
#define VD1_HDR2_PIPE_CTRL3                0x3838
#define VD1_HDR2_PROC_WIN1                 0x3839
#define VD1_HDR2_PROC_WIN2                 0x383a
#define VD1_HDR2_MATRIXI_EN_CTRL           0x383b
#define VD1_HDR2_MATRIXO_EN_CTRL           0x383c
#define VD1_HDR2_HIST_CTRL                 0x383d
#define VD1_HDR2_HIST_H_START_END          0x383e
#define VD1_HDR2_HIST_V_START_END          0x383f

#define VD2_HDR2_CTRL                      0x3850
#define VD2_HDR2_CLK_GATE                  0x3851
#define VD2_HDR2_MATRIXI_COEF00_01         0x3852
#define VD2_HDR2_MATRIXI_COEF02_10         0x3853
#define VD2_HDR2_MATRIXI_COEF11_12         0x3854
#define VD2_HDR2_MATRIXI_COEF20_21         0x3855
#define VD2_HDR2_MATRIXI_COEF22            0x3856
#define VD2_HDR2_MATRIXI_COEF30_31         0x3857
#define VD2_HDR2_MATRIXI_COEF32_40         0x3858
#define VD2_HDR2_MATRIXI_COEF41_42         0x3859
#define VD2_HDR2_MATRIXI_OFFSET0_1         0x385a
#define VD2_HDR2_MATRIXI_OFFSET2           0x385b
#define VD2_HDR2_MATRIXI_PRE_OFFSET0_1     0x385c
#define VD2_HDR2_MATRIXI_PRE_OFFSET2       0x385d
#define VD2_HDR2_MATRIXO_COEF00_01         0x385e
#define VD2_HDR2_MATRIXO_COEF02_10         0x385f
#define VD2_HDR2_MATRIXO_COEF11_12         0x3860
#define VD2_HDR2_MATRIXO_COEF20_21         0x3861
#define VD2_HDR2_MATRIXO_COEF22            0x3862
#define VD2_HDR2_MATRIXO_COEF30_31         0x3863
#define VD2_HDR2_MATRIXO_COEF32_40         0x3864
#define VD2_HDR2_MATRIXO_COEF41_42         0x3865
#define VD2_HDR2_MATRIXO_OFFSET0_1         0x3866
#define VD2_HDR2_MATRIXO_OFFSET2           0x3867
#define VD2_HDR2_MATRIXO_PRE_OFFSET0_1     0x3868
#define VD2_HDR2_MATRIXO_PRE_OFFSET2       0x3869
#define VD2_HDR2_MATRIXI_CLIP              0x386a
#define VD2_HDR2_MATRIXO_CLIP              0x386b
#define VD2_HDR2_CGAIN_OFFT                0x386c
/*TL1 hist read is 0x3890, tm2 is 0x386d*/
#define VD2_HDR2_HIST_RD_2                 0x386d
#define VD2_EOTF_LUT_ADDR_PORT             0x386e
#define VD2_EOTF_LUT_DATA_PORT             0x386f
#define VD2_OETF_LUT_ADDR_PORT             0x3870
#define VD2_OETF_LUT_DATA_PORT             0x3871
#define VD2_CGAIN_LUT_ADDR_PORT            0x3872
#define VD2_CGAIN_LUT_DATA_PORT            0x3873
#define VD2_HDR2_CGAIN_COEF0               0x3874
#define VD2_HDR2_CGAIN_COEF1               0x3875
#define VD2_OGAIN_LUT_ADDR_PORT            0x3876
#define VD2_OGAIN_LUT_DATA_PORT            0x3877
#define VD2_HDR2_ADPS_CTRL                 0x3878
#define VD2_HDR2_ADPS_ALPHA0               0x3879
#define VD2_HDR2_ADPS_ALPHA1               0x387a
#define VD2_HDR2_ADPS_BETA0                0x387b
#define VD2_HDR2_ADPS_BETA1                0x387c
#define VD2_HDR2_ADPS_BETA2                0x387d
#define VD2_HDR2_ADPS_COEF0                0x387e
#define VD2_HDR2_ADPS_COEF1                0x387f
#define VD2_HDR2_GMUT_CTRL                 0x3880
#define VD2_HDR2_GMUT_COEF0                0x3881
#define VD2_HDR2_GMUT_COEF1                0x3882
#define VD2_HDR2_GMUT_COEF2                0x3883
#define VD2_HDR2_GMUT_COEF3                0x3884
#define VD2_HDR2_GMUT_COEF4                0x3885
#define VD2_HDR2_PIPE_CTRL1                0x3886
#define VD2_HDR2_PIPE_CTRL2                0x3887
#define VD2_HDR2_PIPE_CTRL3                0x3888
#define VD2_HDR2_PROC_WIN1                 0x3889
#define VD2_HDR2_PROC_WIN2                 0x388a
#define VD2_HDR2_MATRIXI_EN_CTRL           0x388b
#define VD2_HDR2_MATRIXO_EN_CTRL           0x388c
#define VD2_HDR2_HIST_CTRL                 0x388d
#define VD2_HDR2_HIST_H_START_END          0x388e
#define VD2_HDR2_HIST_V_START_END          0x388f

#define OSD1_HDR2_CTRL                      0x38a0
#define OSD1_HDR2_CLK_GATE                  0x38a1
#define OSD1_HDR2_MATRIXI_COEF00_01         0x38a2
#define OSD1_HDR2_MATRIXI_COEF02_10         0x38a3
#define OSD1_HDR2_MATRIXI_COEF11_12         0x38a4
#define OSD1_HDR2_MATRIXI_COEF20_21         0x38a5
#define OSD1_HDR2_MATRIXI_COEF22            0x38a6
#define OSD1_HDR2_MATRIXI_COEF30_31         0x38a7
#define OSD1_HDR2_MATRIXI_COEF32_40         0x38a8
#define OSD1_HDR2_MATRIXI_COEF41_42         0x38a9
#define OSD1_HDR2_MATRIXI_OFFSET0_1         0x38aa
#define OSD1_HDR2_MATRIXI_OFFSET2           0x38ab
#define OSD1_HDR2_MATRIXI_PRE_OFFSET0_1     0x38ac
#define OSD1_HDR2_MATRIXI_PRE_OFFSET2       0x38ad
#define OSD1_HDR2_MATRIXO_COEF00_01         0x38ae
#define OSD1_HDR2_MATRIXO_COEF02_10         0x38af
#define OSD1_HDR2_MATRIXO_COEF11_12         0x38b0
#define OSD1_HDR2_MATRIXO_COEF20_21         0x38b1
#define OSD1_HDR2_MATRIXO_COEF22            0x38b2
#define OSD1_HDR2_MATRIXO_COEF30_31         0x38b3
#define OSD1_HDR2_MATRIXO_COEF32_40         0x38b4
#define OSD1_HDR2_MATRIXO_COEF41_42         0x38b5
#define OSD1_HDR2_MATRIXO_OFFSET0_1         0x38b6
#define OSD1_HDR2_MATRIXO_OFFSET2           0x38b7
#define OSD1_HDR2_MATRIXO_PRE_OFFSET0_1     0x38b8
#define OSD1_HDR2_MATRIXO_PRE_OFFSET2       0x38b9
#define OSD1_HDR2_MATRIXI_CLIP              0x38ba
#define OSD1_HDR2_MATRIXO_CLIP              0x38bb
#define OSD1_HDR2_CGAIN_OFFT                0x38bc
#define OSD1_EOTF_LUT_ADDR_PORT             0x38be
#define OSD1_EOTF_LUT_DATA_PORT             0x38bf
#define OSD1_OETF_LUT_ADDR_PORT             0x38c0
#define OSD1_OETF_LUT_DATA_PORT             0x38c1
#define OSD1_CGAIN_LUT_ADDR_PORT            0x38c2
#define OSD1_CGAIN_LUT_DATA_PORT            0x38c3
#define OSD1_HDR2_CGAIN_COEF0               0x38c4
#define OSD1_HDR2_CGAIN_COEF1               0x38c5
#define OSD1_OGAIN_LUT_ADDR_PORT            0x38c6
#define OSD1_OGAIN_LUT_DATA_PORT            0x38c7
#define OSD1_HDR2_ADPS_CTRL                 0x38c8
#define OSD1_HDR2_ADPS_ALPHA0               0x38c9
#define OSD1_HDR2_ADPS_ALPHA1               0x38ca
#define OSD1_HDR2_ADPS_BETA0                0x38cb
#define OSD1_HDR2_ADPS_BETA1                0x38cc
#define OSD1_HDR2_ADPS_BETA2                0x38cd
#define OSD1_HDR2_ADPS_COEF0                0x38ce
#define OSD1_HDR2_ADPS_COEF1                0x38cf
#define OSD1_HDR2_GMUT_CTRL                 0x38d0
#define OSD1_HDR2_GMUT_COEF0                0x38d1
#define OSD1_HDR2_GMUT_COEF1                0x38d2
#define OSD1_HDR2_GMUT_COEF2                0x38d3
#define OSD1_HDR2_GMUT_COEF3                0x38d4
#define OSD1_HDR2_GMUT_COEF4                0x38d5
#define OSD1_HDR2_PIPE_CTRL1                0x38d6
#define OSD1_HDR2_PIPE_CTRL2                0x38d7
#define OSD1_HDR2_PIPE_CTRL3                0x38d8
#define OSD1_HDR2_PROC_WIN1                 0x38d9
#define OSD1_HDR2_PROC_WIN2                 0x38da
#define OSD1_HDR2_MATRIXI_EN_CTRL           0x38db
#define OSD1_HDR2_MATRIXO_EN_CTRL           0x38dc
#define OSD1_HDR2_HIST_CTRL                 0x38dd
#define OSD1_HDR2_HIST_H_START_END          0x38de
#define OSD1_HDR2_HIST_V_START_END          0x38df

#define DI_HDR2_CTRL                      0x3770
#define DI_HDR2_CLK_GATE                  0x3771
#define DI_HDR2_MATRIXI_COEF00_01         0x3772
#define DI_HDR2_MATRIXI_COEF02_10         0x3773
#define DI_HDR2_MATRIXI_COEF11_12         0x3774
#define DI_HDR2_MATRIXI_COEF20_21         0x3775
#define DI_HDR2_MATRIXI_COEF22            0x3776
#define DI_HDR2_MATRIXI_COEF30_31         0x3777
#define DI_HDR2_MATRIXI_COEF32_40         0x3778
#define DI_HDR2_MATRIXI_COEF41_42         0x3779
#define DI_HDR2_MATRIXI_OFFSET0_1         0x377a
#define DI_HDR2_MATRIXI_OFFSET2           0x377b
#define DI_HDR2_MATRIXI_PRE_OFFSET0_1     0x377c
#define DI_HDR2_MATRIXI_PRE_OFFSET2       0x377d
#define DI_HDR2_MATRIXO_COEF00_01         0x377e
#define DI_HDR2_MATRIXO_COEF02_10         0x377f
#define DI_HDR2_MATRIXO_COEF11_12         0x3780
#define DI_HDR2_MATRIXO_COEF20_21         0x3781
#define DI_HDR2_MATRIXO_COEF22            0x3782
#define DI_HDR2_MATRIXO_COEF30_31         0x3783
#define DI_HDR2_MATRIXO_COEF32_40         0x3784
#define DI_HDR2_MATRIXO_COEF41_42         0x3785
#define DI_HDR2_MATRIXO_OFFSET0_1         0x3786
#define DI_HDR2_MATRIXO_OFFSET2           0x3787
#define DI_HDR2_MATRIXO_PRE_OFFSET0_1     0x3788
#define DI_HDR2_MATRIXO_PRE_OFFSET2       0x3789
#define DI_HDR2_MATRIXI_CLIP              0x378a
#define DI_HDR2_MATRIXO_CLIP              0x378b
#define DI_HDR2_CGAIN_OFFT                0x378c
#define DI_EOTF_LUT_ADDR_PORT             0x378e
#define DI_EOTF_LUT_DATA_PORT             0x378f
#define DI_OETF_LUT_ADDR_PORT             0x3790
#define DI_OETF_LUT_DATA_PORT             0x3791
#define DI_CGAIN_LUT_ADDR_PORT            0x3792
#define DI_CGAIN_LUT_DATA_PORT            0x3793
#define DI_HDR2_CGAIN_COEF0               0x3794
#define DI_HDR2_CGAIN_COEF1               0x3795
#define DI_OGAIN_LUT_ADDR_PORT            0x3796
#define DI_OGAIN_LUT_DATA_PORT            0x3797
#define DI_HDR2_ADPS_CTRL                 0x3798
#define DI_HDR2_ADPS_ALPHA0               0x3799
#define DI_HDR2_ADPS_ALPHA1               0x379a
#define DI_HDR2_ADPS_BETA0                0x379b
#define DI_HDR2_ADPS_BETA1                0x379c
#define DI_HDR2_ADPS_BETA2                0x379d
#define DI_HDR2_ADPS_COEF0                0x379e
#define DI_HDR2_ADPS_COEF1                0x379f
#define DI_HDR2_GMUT_CTRL                 0x37a0
#define DI_HDR2_GMUT_COEF0                0x37a1
#define DI_HDR2_GMUT_COEF1                0x37a2
#define DI_HDR2_GMUT_COEF2                0x37a3
#define DI_HDR2_GMUT_COEF3                0x37a4
#define DI_HDR2_GMUT_COEF4                0x37a5
#define DI_HDR2_PIPE_CTRL1                0x37a6
#define DI_HDR2_PIPE_CTRL2                0x37a7
#define DI_HDR2_PIPE_CTRL3                0x37a8
#define DI_HDR2_PROC_WIN1                 0x37a9
#define DI_HDR2_PROC_WIN2                 0x37aa
#define DI_HDR2_MATRIXI_EN_CTRL           0x37ab
#define DI_HDR2_MATRIXO_EN_CTRL           0x37ac
#define DI_HDR2_HIST_CTRL                 0x37ad
#define DI_HDR2_HIST_H_START_END          0x37ae
#define DI_HDR2_HIST_V_START_END          0x37af

#define VDIN0_HDR2_CTRL                    0x1280
#define VDIN0_HDR2_CLK_GATE                0x1281
#define VDIN0_HDR2_MATRIXI_COEF00_01       0x1282
#define VDIN0_HDR2_MATRIXI_COEF02_10       0x1283
#define VDIN0_HDR2_MATRIXI_COEF11_12       0x1284
#define VDIN0_HDR2_MATRIXI_COEF20_21       0x1285
#define VDIN0_HDR2_MATRIXI_COEF22          0x1286
#define VDIN0_HDR2_MATRIXI_COEF30_31       0x1287
#define VDIN0_HDR2_MATRIXI_COEF32_40       0x1288
#define VDIN0_HDR2_MATRIXI_COEF41_42       0x1289
#define VDIN0_HDR2_MATRIXI_OFFSET0_1       0x128a
#define VDIN0_HDR2_MATRIXI_OFFSET2         0x128b
#define VDIN0_HDR2_MATRIXI_PRE_OFFSET0_1   0x128c
#define VDIN0_HDR2_MATRIXI_PRE_OFFSET2     0x128d
#define VDIN0_HDR2_MATRIXO_COEF00_01       0x128e
#define VDIN0_HDR2_MATRIXO_COEF02_10       0x128f
#define VDIN0_HDR2_MATRIXO_COEF11_12       0x1290
#define VDIN0_HDR2_MATRIXO_COEF20_21       0x1291
#define VDIN0_HDR2_MATRIXO_COEF22          0x1292
#define VDIN0_HDR2_MATRIXO_COEF30_31       0x1293
#define VDIN0_HDR2_MATRIXO_COEF32_40       0x1294
#define VDIN0_HDR2_MATRIXO_COEF41_42       0x1295
#define VDIN0_HDR2_MATRIXO_OFFSET0_1       0x1296
#define VDIN0_HDR2_MATRIXO_OFFSET2         0x1297
#define VDIN0_HDR2_MATRIXO_PRE_OFFSET0_1   0x1298
#define VDIN0_HDR2_MATRIXO_PRE_OFFSET2     0x1299
#define VDIN0_HDR2_MATRIXI_CLIP            0x129a
#define VDIN0_HDR2_MATRIXO_CLIP            0x129b
#define VDIN0_HDR2_CGAIN_OFFT              0x129c
#define VDIN0_EOTF_LUT_ADDR_PORT           0x129e
#define VDIN0_EOTF_LUT_DATA_PORT           0x129f
#define VDIN0_OETF_LUT_ADDR_PORT           0x12a0
#define VDIN0_OETF_LUT_DATA_PORT           0x12a1
#define VDIN0_CGAIN_LUT_ADDR_PORT          0x12a2
#define VDIN0_CGAIN_LUT_DATA_PORT          0x12a3
#define VDIN0_HDR2_CGAIN_COEF0             0x12a4
#define VDIN0_HDR2_CGAIN_COEF1             0x12a5
#define VDIN0_OGAIN_LUT_ADDR_PORT          0x12a6
#define VDIN0_OGAIN_LUT_DATA_PORT          0x12a7
#define VDIN0_HDR2_ADPS_CTRL               0x12a8
#define VDIN0_HDR2_ADPS_ALPHA0             0x12a9
#define VDIN0_HDR2_ADPS_ALPHA1             0x12aa
#define VDIN0_HDR2_ADPS_BETA0              0x12ab
#define VDIN0_HDR2_ADPS_BETA1              0x12ac
#define VDIN0_HDR2_ADPS_BETA2              0x12ad
#define VDIN0_HDR2_ADPS_COEF0              0x12ae
#define VDIN0_HDR2_ADPS_COEF1              0x12af
#define VDIN0_HDR2_GMUT_CTRL               0x12b0
#define VDIN0_HDR2_GMUT_COEF0              0x12b1
#define VDIN0_HDR2_GMUT_COEF1              0x12b2
#define VDIN0_HDR2_GMUT_COEF2              0x12b3
#define VDIN0_HDR2_GMUT_COEF3              0x12b4
#define VDIN0_HDR2_GMUT_COEF4              0x12b5
#define VDIN0_HDR2_PIPE_CTRL1              0x12b6
#define VDIN0_HDR2_PIPE_CTRL2              0x12b7
#define VDIN0_HDR2_PIPE_CTRL3              0x12b8
#define VDIN0_HDR2_PROC_WIN1               0x12b9
#define VDIN0_HDR2_PROC_WIN2               0x12ba
#define VDIN0_HDR2_MATRIXI_EN_CTRL         0x12bb
#define VDIN0_HDR2_MATRIXO_EN_CTRL         0x12bc

#define VDIN1_HDR2_CTRL                    0x1380
#define VDIN1_HDR2_CLK_GATE                0x1381
#define VDIN1_HDR2_MATRIXI_COEF00_01       0x1382
#define VDIN1_HDR2_MATRIXI_COEF02_10       0x1383
#define VDIN1_HDR2_MATRIXI_COEF11_12       0x1384
#define VDIN1_HDR2_MATRIXI_COEF20_21       0x1385
#define VDIN1_HDR2_MATRIXI_COEF22          0x1386
#define VDIN1_HDR2_MATRIXI_COEF30_31       0x1387
#define VDIN1_HDR2_MATRIXI_COEF32_40       0x1388
#define VDIN1_HDR2_MATRIXI_COEF41_42       0x1389
#define VDIN1_HDR2_MATRIXI_OFFSET0_1       0x138a
#define VDIN1_HDR2_MATRIXI_OFFSET2         0x138b
#define VDIN1_HDR2_MATRIXI_PRE_OFFSET0_1   0x138c
#define VDIN1_HDR2_MATRIXI_PRE_OFFSET2     0x138d
#define VDIN1_HDR2_MATRIXO_COEF00_01       0x138e
#define VDIN1_HDR2_MATRIXO_COEF02_10       0x138f
#define VDIN1_HDR2_MATRIXO_COEF11_12       0x1390
#define VDIN1_HDR2_MATRIXO_COEF20_21       0x1391
#define VDIN1_HDR2_MATRIXO_COEF22          0x1392
#define VDIN1_HDR2_MATRIXO_COEF30_31       0x1393
#define VDIN1_HDR2_MATRIXO_COEF32_40       0x1394
#define VDIN1_HDR2_MATRIXO_COEF41_42       0x1395
#define VDIN1_HDR2_MATRIXO_OFFSET0_1       0x1396
#define VDIN1_HDR2_MATRIXO_OFFSET2         0x1397
#define VDIN1_HDR2_MATRIXO_PRE_OFFSET0_1   0x1398
#define VDIN1_HDR2_MATRIXO_PRE_OFFSET2     0x1399
#define VDIN1_HDR2_MATRIXI_CLIP            0x139a
#define VDIN1_HDR2_MATRIXO_CLIP            0x139b
#define VDIN1_HDR2_CGAIN_OFFT              0x139c
#define VDIN1_EOTF_LUT_ADDR_PORT           0x139e
#define VDIN1_EOTF_LUT_DATA_PORT           0x139f
#define VDIN1_OETF_LUT_ADDR_PORT           0x13a0
#define VDIN1_OETF_LUT_DATA_PORT           0x13a1
#define VDIN1_CGAIN_LUT_ADDR_PORT          0x13a2
#define VDIN1_CGAIN_LUT_DATA_PORT          0x13a3
#define VDIN1_HDR2_CGAIN_COEF0             0x13a4
#define VDIN1_HDR2_CGAIN_COEF1             0x13a5
#define VDIN1_OGAIN_LUT_ADDR_PORT          0x13a6
#define VDIN1_OGAIN_LUT_DATA_PORT          0x13a7
#define VDIN1_HDR2_ADPS_CTRL               0x13a8
#define VDIN1_HDR2_ADPS_ALPHA0             0x13a9
#define VDIN1_HDR2_ADPS_ALPHA1             0x13aa
#define VDIN1_HDR2_ADPS_BETA0              0x13ab
#define VDIN1_HDR2_ADPS_BETA1              0x13ac
#define VDIN1_HDR2_ADPS_BETA2              0x13ad
#define VDIN1_HDR2_ADPS_COEF0              0x13ae
#define VDIN1_HDR2_ADPS_COEF1              0x13af
#define VDIN1_HDR2_GMUT_CTRL               0x13b0
#define VDIN1_HDR2_GMUT_COEF0              0x13b1
#define VDIN1_HDR2_GMUT_COEF1              0x13b2
#define VDIN1_HDR2_GMUT_COEF2              0x13b3
#define VDIN1_HDR2_GMUT_COEF3              0x13b4
#define VDIN1_HDR2_GMUT_COEF4              0x13b5
#define VDIN1_HDR2_PIPE_CTRL1              0x13b6
#define VDIN1_HDR2_PIPE_CTRL2              0x13b7
#define VDIN1_HDR2_PIPE_CTRL3              0x13b8
#define VDIN1_HDR2_PROC_WIN1               0x13b9
#define VDIN1_HDR2_PROC_WIN2               0x13ba
#define VDIN1_HDR2_MATRIXI_EN_CTRL         0x13bb
#define VDIN1_HDR2_MATRIXO_EN_CTRL         0x13bc

#define VPP_VD2_HDR_IN_SIZE                0x1df0
#endif
