/*
 * drivers/amlogic/media/vout/lcd/lcd_extern/mipi_TV070WSM.c
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/interrupt.h>
#include <linux/platform_device.h>
#include <linux/i2c.h>
#include <linux/amlogic/i2c-amlogic.h>
#include <linux/clk.h>
#include <linux/delay.h>
#include <linux/slab.h>
#include <linux/of.h>
#include <linux/amlogic/media/vout/lcd/lcd_extern.h>
#include "lcd_extern.h"

#define LCD_EXTERN_NAME        "lcd_mipi_TV070WSM"

/* ******************** mipi command ********************
 * format:  data_type, cmd_size, data....
 * special: data_type=0xff,
 *		cmd_size<0xff means delay ms, cmd_size=0xff means ending.
 *          data_type=0xf0,
 *		data0=gpio_index, data1=gpio_value, data2=delay.
 */
static unsigned char mipi_init_on_table[] = {
	0xff, 100,   /* delay */
	0x15, 2, 0x62, 0x01,
	0x39, 5, 0xff, 0xaa, 0x55, 0x25, 0x01,
	0x15, 2, 0xfc, 0x08,
	0xff, 1,   /* delay */
	0x15, 2, 0xfc, 0x00,
	0x39, 5, 0xff, 0xaa, 0x55, 0x25, 0x00,
	0xff, 20,   /* delay */
	0x39, 6, 0xf0, 0x55, 0xaa, 0x52, 0x08, 0x00,
	0x39, 3, 0xb1, 0x68, 0x41,
	0x15, 2, 0xb5, 0x88,
	0x15, 2, 0xb6, 0x0f,
	0x39, 5, 0xb8, 0x01, 0x01, 0x12, 0x01,
	0x39, 3, 0xbb, 0x11, 0x11,
	0x39, 3, 0xbc, 0x05, 0x05,
	0x15, 2, 0xc7, 0x03,
	0x39, 6, 0xbd, 0x03, 0x02, 0x19, 0x17, 0x00,
	0x15, 2, 0xc8, 0x80,
	0x39, 6, 0xf0, 0x55, 0xaa, 0x52, 0x08, 0x01,
	0x39, 3, 0xB2, 0x01, 0x01,
	0x39, 3, 0xB3, 0x28, 0x28,
	0x39, 3, 0xB4, 0x14, 0x14,
	0x39, 3, 0xB8, 0x05, 0x05,
	0x39, 3, 0xB9, 0x45, 0x45,
	0x39, 3, 0xBA, 0x25, 0x25,
	0x39, 3, 0xBC, 0x88, 0x00,
	0x39, 3, 0xBD, 0x88, 0x00,
	0x39, 6, 0xF0, 0x55, 0xAA, 0x52, 0x08, 0x02,
	0x15, 2, 0xEE, 0x00,
	0x39, 17, 0xB0, 0x00, 0x4B, 0x00, 0x5C, 0x00, 0x79, 0x00, 0x94, 0x00,
		0xA6, 0x00, 0xD8, 0x00, 0xF2, 0x01, 0x19,
	0x39, 17, 0xB1, 0x01, 0x39, 0x01, 0x77, 0x01, 0xA2, 0x01, 0xF2, 0x02,
		0x32, 0x02, 0x34, 0x02, 0x6D, 0x02, 0xA2,
	0x39, 17, 0xB2, 0x02, 0xC7, 0x02, 0xF2, 0x03, 0x18, 0x03, 0x43, 0x03,
		0x65, 0x03, 0x86, 0x03, 0x8F, 0x03, 0x94,
	0x39, 5, 0xB3, 0x03, 0x96, 0x03, 0x98,
	0x39, 17, 0xB4, 0x00, 0x84, 0x00, 0x91, 0x00, 0xA4, 0x00, 0xB6, 0x00,
		0xCA, 0x00, 0xE9, 0x01, 0x02, 0x01, 0x2A,
	0x39, 17, 0xB5, 0x01, 0x49, 0x01, 0x82, 0x01, 0xAF, 0x01, 0xF7, 0x02,
		0x36, 0x02, 0x38, 0x02, 0x70, 0x02, 0xA6,
	0x39, 17, 0xB6, 0x02, 0xC8, 0x02, 0xF5, 0x03, 0x1A, 0x03, 0x43, 0x03,
		0x62, 0x03, 0x82, 0x03, 0x8F, 0x03, 0x94,
	0x39, 5, 0xB7, 0x03, 0x96, 0x03, 0x98,
	0x39, 17, 0xB8, 0x01, 0x22, 0x01, 0x27, 0x01, 0x2E, 0x01, 0x38, 0x01,
		0x40, 0x01, 0x53, 0x01, 0x60, 0x01, 0x7B,
	0x39, 17, 0xB9, 0x01, 0x8C, 0x01, 0xB5, 0x01, 0xD3, 0x02, 0x11, 0x02,
		0x49, 0x02, 0x4A, 0x02, 0x7F, 0x02, 0xB1,
	0x39, 17, 0xBA, 0x02, 0xD1, 0x03, 0x00, 0x03, 0x22, 0x03, 0x49, 0x03,
		0x60, 0x03, 0x7A, 0x03, 0x8B, 0x03, 0x8F,
	0x39, 5, 0xBB, 0x03, 0x93, 0x03, 0x9A,
	0x39, 17, 0xBC, 0x00, 0x37, 0x00, 0x48, 0x00, 0x65, 0x00, 0x80, 0x00,
		0x92, 0x00, 0xC4, 0x00, 0xDE, 0x01, 0x05,
	0x39, 17, 0xBD, 0x01, 0x31, 0x01, 0x6F, 0x01, 0x9E, 0x01, 0xEE, 0x02,
		0x32, 0x02, 0x34, 0x02, 0x71, 0x02, 0xA7,
	0x39, 17, 0xBE, 0x02, 0xD3, 0x02, 0xFE, 0x03, 0x24, 0x03, 0x4F, 0x03,
		0x71, 0x03, 0x92, 0x03, 0x9B, 0x03, 0xA0,
	0x39, 5, 0xBF, 0x03, 0xA6, 0x03, 0xA8,
	0x39, 17, 0xC0, 0x00, 0x70, 0x00, 0x7D, 0x00, 0x90, 0x00, 0xA4, 0x00,
		0xB6, 0x00, 0xD5, 0x00, 0xEE, 0x01, 0x16,
	0x39, 17, 0xC1, 0x01, 0x41, 0x01, 0x7A, 0x01, 0xAB, 0x01, 0xF3, 0x02,
		0x36, 0x02, 0x38, 0x02, 0x74, 0x02, 0xAA,
	0x39, 17, 0xC2, 0x02, 0xD4, 0x03, 0x01, 0x03, 0x26, 0x03, 0x4F, 0x03,
		0x6E, 0x03, 0x8E, 0x03, 0x9B, 0x03, 0xA0,
	0x39, 5, 0xC3, 0x03, 0xA6, 0x03, 0xA8,
	0x39, 17, 0xC4, 0x01, 0x0E, 0x01, 0x13, 0x01, 0x1A, 0x01, 0x24, 0x01,
		0x2C, 0x01, 0x3F, 0x01, 0x4C, 0x01, 0x67,
	0x39, 17, 0xC5, 0x01, 0x84, 0x01, 0xAD, 0x01, 0xCF, 0x02, 0x0D, 0x02,
		0x49, 0x02, 0x4A, 0x02, 0x83, 0x02, 0xB5,
	0x39, 17, 0xC6, 0x02, 0xDD, 0x03, 0x0C, 0x03, 0x2E, 0x03, 0x55, 0x03,
		0x6B, 0x03, 0x86, 0x03, 0x97, 0x03, 0x9B,
	0x39, 5, 0xC7, 0x03, 0xA1, 0x03, 0xA8,
	0x39, 6, 0xF0, 0x55, 0xAA, 0x52, 0x08, 0x04,
	0x39, 6, 0xB1, 0x03, 0x02, 0x02, 0x02, 0x00,
	0x39, 6, 0xF0, 0x55, 0xAA, 0x52, 0x08, 0x06,
	0x39, 3, 0xB0, 0x11, 0x11,
	0x39, 3, 0xB1, 0x13, 0x13,
	0x39, 3, 0xB2, 0x03, 0x03,
	0x39, 3, 0xB3, 0x34, 0x34,
	0x39, 3, 0xB4, 0x34, 0x34,
	0x39, 3, 0xB5, 0x34, 0x34,
	0x39, 3, 0xB6, 0x34, 0x34,
	0x39, 3, 0xB7, 0x34, 0x34,
	0x39, 3, 0xB8, 0x34, 0x34,
	0x39, 3, 0xB9, 0x34, 0x34,
	0x39, 3, 0xBA, 0x34, 0x34,
	0x39, 3, 0xBB, 0x34, 0x34,
	0x39, 3, 0xBC, 0x34, 0x34,
	0x39, 3, 0xBD, 0x34, 0x34,
	0x39, 3, 0xBE, 0x34, 0x34,
	0x39, 3, 0xBF, 0x34, 0x34,
	0x39, 3, 0xC0, 0x34, 0x34,
	0x39, 3, 0xC1, 0x02, 0x02,
	0x39, 3, 0xC2, 0x12, 0x12,
	0x39, 3, 0xC3, 0x10, 0x10,
	0x39, 3, 0xE5, 0x34, 0x34,
	0x39, 6, 0xD8, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x39, 6, 0xD9, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x39, 6, 0xF0, 0x55, 0xAA, 0x52, 0x08, 0x05,
	0x15, 2, 0xC0, 0x03,
	0x15, 2, 0xC1, 0x02,
	0x39, 3, 0xC8, 0x01, 0x20,
	0x15, 2, 0xE5, 0x03,
	0x15, 2, 0xE6, 0x03,
	0x15, 2, 0xE7, 0x03,
	0x15, 2, 0xE8, 0x03,
	0x15, 2, 0xE9, 0x03,
	0x39, 5, 0xD1, 0x03, 0x00, 0x3D, 0x00,
	0x39, 6, 0xF0, 0x55, 0xAA, 0x52, 0x08, 0x03,
	0x39, 3, 0xB0, 0x11, 0x00,
	0x39, 3, 0xB1, 0x11, 0x00,
	0x39, 6, 0xB2, 0x03, 0x00, 0x00, 0x00, 0x00,
	0x39, 6, 0xB3, 0x03, 0x00, 0x00, 0x00, 0x00,
	0x39, 6, 0xBA, 0x31, 0x00, 0x00, 0x00, 0x00,
	0x15, 2, 0x35, 0x00,
	0x15, 2, 0x51, 0xFF,
	0x15, 2, 0x53, 0x2C,
	0x15, 2, 0x55, 0x03,
	0x05, 1, 0x11,
	0xff, 120,  /* delay 120ms */
	0x05, 1, 0x29,
	0xff, 0xff, /* ending flag */
};

static unsigned char mipi_init_off_table[] = {
	0x05, 1, 0x28, /* display off */
	0xff, 30,      /* delay 30ms */
	0x05, 1, 0x10, /* sleep in */
	0xff, 10,
	0xff, 0xff,   /* ending flag */
};

static int lcd_extern_driver_update(struct aml_lcd_extern_driver_s *ext_drv)
{
	if (ext_drv == NULL) {
		EXTERR("%s driver is null\n", LCD_EXTERN_NAME);
		return -1;
	}

	ext_drv->config->cmd_size = LCD_EXT_CMD_SIZE_DYNAMIC;
	ext_drv->config->table_init_on  = &mipi_init_on_table[0];
	ext_drv->config->table_init_on_cnt  = sizeof(mipi_init_on_table);
	ext_drv->config->table_init_off = &mipi_init_off_table[0];
	ext_drv->config->table_init_off_cnt  = sizeof(mipi_init_off_table);

	return 0;
}

int aml_lcd_extern_mipi_TV070WSM_probe(struct aml_lcd_extern_driver_s *ext_drv)
{
	int ret = 0;

	ret = lcd_extern_driver_update(ext_drv);

	if (lcd_debug_print_flag)
		EXTPR("%s: %d\n", __func__, ret);
	return ret;
}

