#include <linux/module.h>
#include <linux/i2c.h>
#include <linux/delay.h>
#include <linux/slab.h>
#include <linux/err.h>
#include <linux/delay.h>
#include <linux/version.h>
#include <generated/utsrelease.h>
#include <generated/compile.h>
#include <uapi/linux/dvb/frontend.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 9, 0)
#include <uapi/linux/dvb/aml_demod.h>
#endif
//#include <mach/gpio_data.h>
//#include<mach/gpio.h>

/* Amlogic Headers */

/* Local Headers */
#include "si2151_func.h"

#define KERNEL_INFO                     "Linux version "UTS_RELEASE"-"UTS_MACHINE
#define TUNER_VERSION                   "V2.16"
#define SI2151_TUNER_I2C_NAME           "si2159_tuner_i2c"
#define TUNER_DEVICE_NAME               "si2159"
#ifndef ERROR
#define ERROR                           1
#endif
#define CVD_SI2151_RSSI
int si2159_debug = 0;
module_param(si2159_debug, int, 0644);
MODULE_PARM_DESC(si2159_debug, "\n si2159_debug \n");

static unsigned short audio_delay = 100;
module_param(audio_delay, ushort, 0644);
MODULE_PARM_DESC(audio_delay, "\n the delay for audio mode detection by ms\n");

#define siprintk if(si2159_debug) printk
#define ssiprintk if(si2159_debug==2) printk

struct si2151_device_s *si2151_devp;
//static void get_mono_sound_mode(unsigned int *);
#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 9, 0)
void si2151_set_frequency(unsigned int freq);
#endif
void si2151_set_std(void);

#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 9, 0)
int si2151_get_strength(struct dvb_frontend *fe){
	  int strength=100;
	  if(Si2151_L1_TUNER_STATUS(si2151_devp->api)!=0)
    	 {
        	printk("[si2159..]%s:get si2159 tuner status error!!!\n",__func__);
        	return -ERROR;
         }
    	else
		strength = si2151_devp->api->rsp->tuner_status.rssi - 256;

		siprintk("[si2159..]%s: strength = %d dbm\n", __func__, strength);
		return strength;
}
#endif

static void sound_store(const char *buff, v4l2_std_id *std)
{
        if(!strncmp(buff,"dk",2))
                *std |= V4L2_STD_PAL_DK;
        else if(!strncmp(buff,"bg",2))
                *std |= V4L2_STD_B;
        else if(!strncmp(buff,"i",1))
                *std |= V4L2_STD_PAL_I;
        else if(!strncmp(buff,"nm",2))
                *std |= V4L2_STD_NTSC;
        else if(!strncmp(buff,"pm",2))
                *std |= V4L2_STD_PAL_M;
        else if(!strncmp(buff,"l",1))
                *std |= V4L2_STD_SECAM_L;
        else if(!strncmp(buff,"lc",2))
                *std |= V4L2_STD_SECAM_LC;
		else if(!strncmp(buff,"n",1))
                *std |= V4L2_STD_PAL_N;
        else
                pr_info("invaild command.\n");
}

static ssize_t si2159_debug_store(struct class *cls, struct class_attribute *attr, const char *buf, size_t count)
{
        int n = 0, rssi = 0;
        //unsigned char ret =0;
        char *buf_orig = NULL, *ps = NULL, *token = NULL;
        char *parm[4] = { NULL };
        unsigned int addr = 0, val = 0;
        v4l2_std_id std = 0;
        buf_orig = kstrdup(buf, GFP_KERNEL);
        ps = buf_orig;
        while (1) {
                token = strsep(&ps, " \n");
                if (token == NULL)
                        break;
                if (*token == '\0')
                        continue;
                parm[n++] = token;
        }

        if (!strncmp(parm[0],"rs",strlen("rs")))
        {
                if (n != 2)
                {
                        pr_err("read: invalid parameter\n");
                        kfree(buf_orig);
                        return count;
                }
                addr = simple_strtol(parm[1], NULL, 16);
                pr_err("%s 0x%x\n", parm[0], addr);
                Si2151_L1_GetProperty(si2151_devp->api, addr, &val);
                pr_err("%s: 0x%x --> 0x%x\n", parm[0], addr, val);
        }
        else if (!strncmp(parm[0],"ws",strlen("ws")))
        {
                addr = simple_strtol(parm[1], NULL, 16);
                val  = simple_strtol(parm[2], NULL, 16);
                pr_err("%s 0x%x 0x%x", parm[0], addr, val);
                Si2151_L1_SetProperty(si2151_devp->api, addr, val);
                pr_err("%s: 0x%x <-- 0x%x\n", parm[0], addr, val);
        }
        else if(!strncmp(parm[0], "dump_prop", strlen("dump_prop")))
		{
			int i = 0;
			int cmd[] = { 0x0402, 0x0404,
						0x0504, 0x0506, 0x0507, 0x0508, 0x0509,
						0x0603, 0x0604, 0x0605, 0x0607, 0x060c, 0x060d, 0x0611,
						0x0612, 0x0616, 0x0617, 0x061e, 0x0623, 0x0624, 0x0627,
						0x0702, 0x0703, 0x0704, 0x0705, 0x0706, 0x0707, 0x0708,
						0x0709, 0x070d, 0x070e, 0x070f, 0x0710, 0x0713, 0x0714,
						0x0715, 0x0716, 0x0717
			};

			for (i = 0; i < sizeof(cmd) / sizeof(cmd[0]); ++i) {
				addr = cmd[i];
				val = 0;
				Si2151_L1_GetProperty(si2151_devp->api, addr, &val);
				pr_err("CMD: 0x%x --> 0x%x\n", addr, val);
			}
		}
        else if(!strncmp(parm[0],"atv_restart",strlen("atv_restart")))
        {
                //ret = si2151_atv_restart(si2151_devp->api, 0,  &si2151_devp->si_cmd_reply);
                //if(ret)
                pr_err("[tuner..] not surport atv_restart .\n");
        }
        else if(!strncmp(parm[0],"dtv_restart",strlen("atv_restart")))
        {
                //ret = si2151_dtv_restart(si2151_devp->api, &si2151_devp->si_cmd_reply);
                //if(ret)
                pr_err("[tuner..] not surport atv_restart .\n");
        }
        else if(!strcmp(parm[0],"tune"))
        {
                val  = simple_strtol(parm[1], NULL, 10);
                //Si2151_TUNER_TUNE_FREQ_CMD_MODE_ATV = 1
                Si2151_Tune(si2151_devp->api, si2151_devp->parm.mode, val);
        }
        else if(!strcmp(parm[0],"tuner_status"))
        {
			//1=Si2151_ATV_STATUS_CMD_INTACK_CLEAR
			Si2151_L1_TUNER_STATUS(si2151_devp->api);

			rssi = si2151_devp->api->rsp->tuner_status.rssi - 256;

			printk("\n[tuner_status.vco_code]:%d \n"
					"[tuner_status.rssi]:%d (%d dBm)\n"
					"[tuner_status.freq]:%lu \n"
					"[tuner_status.mode]:%d \n"
					"[tuner_status.atvint]:%d \n"
					"[tuner_status.dtvint]:%d \n",
					si2151_devp->api->rsp->tuner_status.vco_code,
					si2151_devp->api->rsp->tuner_status.rssi, rssi,
					si2151_devp->api->rsp->tuner_status.freq,
					si2151_devp->api->rsp->tuner_status.mode,
					si2151_devp->api->status->atvint,
					si2151_devp->api->status->dtvint);
			Si2151_L1_GetProperty(si2151_devp->api, Si2151_ATV_LIF_OUT_PROP, &val);
			printk("[tuner_atv_lif_out_amp_offset]:%d - %d \n", (val >> 8) & 0xFF, val & 0xFF);
			Si2151_L1_GetProperty(si2151_devp->api, Si2151_DTV_LIF_OUT_PROP, &val);
			printk("[tuner_dtv_lif_out_amp_offset]:%d - %d \n", (val >> 8) & 0xFF, val & 0xFF);
			Si2151_L1_GetProperty(si2151_devp->api, Si2151_ATV_LIF_FREQ_PROP, &val);
			printk("[tuner_atv_lif_freq]:%d KHZ\n", val);
			Si2151_L1_GetProperty(si2151_devp->api, Si2151_DTV_LIF_FREQ_PROP, &val);
			printk("[tuner_dtv_lif_freq]:%d KHZ\n", val);
			Si2151_L1_GetProperty(si2151_devp->api, Si2151_ATV_VIDEO_MODE_PROP, &val);
			printk("[tuner_atv_lif_inv]:%d \n",((val&0x200) >> 9));
			printk("[tuner_atv_video_sys]:%d \n",(val&0x07));
			printk("[tuner_atv_fre_offset]:%d \n", si2151_devp->fre_offset);
#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 9, 0)
			printk("[tuner_atv_if_inv]:%d \n", si2151_devp->parm.if_inv);
			printk("[tuner_if_freq]:%d \n", si2151_devp->parm.if_freq);
#else
			printk("[tuner_atv_if_inv]:%d \n", si2151_devp->if_inv);
			printk("[tuner_if_freq]:%d \n", si2151_devp->if_freq);
#endif
			printk("[tuner_freq]:%d \n", si2151_devp->parm.frequency);
			printk("[tuner signal mode]:%d (0-DTV,1-ATV)\n", si2151_devp->parm.mode);
			printk("[tuner dtv bw]:%d \n", si2151_devp->api->prop->dtv_mode.bw);
			printk("[tuner dtv mode]:%d \n", si2151_devp->api->prop->dtv_mode.modulation);
			printk("[tuner dtv invert spectrum]:%d \n", si2151_devp->api->prop->dtv_mode.invert_spectrum);
			printk("[tuner dtv lif freq offset]:%d \n", si2151_devp->api->prop->dtv_lif_freq.offset);
			printk("[tuner set std color %s, audio type %s.\n",
					v4l2_std_to_str(0xff000000 & si2151_devp->parm.std),
					v4l2_std_to_str(0xffffff & si2151_devp->parm.std));
			printk("[tuner i2c address]: 0x%x.\n", si2151_devp->tuner_client.addr);
			printk("[si2159] tuner driver version: %s\n",SI2151_VER);
			printk("[si2159] tuner release version: %s (%s %s %s)\n",
					TUNER_VERSION, KERNEL_INFO, __DATE__, __TIME__);
        }
        else if(!strncmp(parm[0],"mono_mode",strlen("mono_mode")))
        {
            //get_mono_sound_mode(&val);
            printk("[si2159..]%s,not surport get mono 0x%x,mode %s.\n",__func__,val,v4l2_std_to_str((v4l2_std_id)val));
        }
        else if(!strncmp(parm[0],"enter_atv",strlen("enter_atv")))
        {
            si2151_devp->parm.mode = Si2151_TUNER_TUNE_FREQ_CMD_MODE_ATV;
            Si2151_Init(si2151_devp->api);
            //Si2151_Configure(si2151_devp->api);
        }
        else if(!strncmp(parm[0],"init_fe",strlen("init_fe")))
        {

        }
        else if(!strncmp(parm[0],"std",strlen("std")))
        {
                if(!strncmp(parm[1],"pal",3))
                {
                        std= V4L2_COLOR_STD_PAL;
                        sound_store(parm[2],&std);
                }
                else if(!strncmp(parm[1],"ntsc",4))
                {
                        std= V4L2_COLOR_STD_NTSC;
                        sound_store(parm[2],&std);
                }
                else if(!strncmp(parm[1],"secam",5))
                {
                        std= V4L2_COLOR_STD_SECAM;
                        sound_store(parm[2],&std);
                }
                si2151_devp->parm.std  =std;
                si2151_devp->parm.audmode = std & 0x00FFFFFF;
                si2151_set_std();
                siprintk("[si2159..]%s set std color %s, audio type %s.\n",__func__,\
                                v4l2_std_to_str(0xff000000&si2151_devp->parm.std), v4l2_std_to_str(0xffffff&si2151_devp->parm.std));
        }
		else if(!strncmp(parm[0], "debug_on", strlen("debug_on")))
		{
			si2159_debug = 2;
		}
		else if(!strncmp(parm[0], "debug_off", strlen("debug_off")))
		{
			si2159_debug = 0;
		}
		else
                printk("invalid command\n");
        kfree(buf_orig);
        return count;
}

static ssize_t si2159_debug_show(struct class *cls,struct class_attribute *attr,char *buff)
{
	int n = 0, rssi = 0;
	unsigned int val = 0;
	const char *path = "/sys/class/si2159/si2159_debug";

	n += sprintf(buff + n, "\nTuner Debug Usage:\n");
	n += sprintf(buff + n, "[read register]\n\techo rs [addr] > %s\n", path);
	n += sprintf(buff + n, "[write register]\n\techo ws [addr] [value]> %s\n", path);
	n += sprintf(buff + n, "[status]\n\techo tuner_status > %s\n", path);
	n += sprintf(buff + n, "[debug on]\n\techo debug_on > %s\n", path);
	n += sprintf(buff + n, "[debug off]\n\techo debug_off > %s\n", path);

	n += sprintf(buff + n, "\n[si2159] Tuner Status:\n");

	Si2151_L1_TUNER_STATUS(si2151_devp->api);

	rssi = si2151_devp->api->rsp->tuner_status.rssi - 256;

	n += sprintf(buff + n, "\n[tuner_status.vco_code]:%d \n"
			"[tuner_status.rssi]:%d (%d dBm)\n"
			"[tuner_status.freq]:%lu \n"
			"[tuner_status.mode]:%d \n"
			"[tuner_status.atvint]:%d \n"
			"[tuner_status.dtvint]:%d \n",
			si2151_devp->api->rsp->tuner_status.vco_code,
			si2151_devp->api->rsp->tuner_status.rssi, rssi,
			si2151_devp->api->rsp->tuner_status.freq,
			si2151_devp->api->rsp->tuner_status.mode,
			si2151_devp->api->status->atvint,
			si2151_devp->api->status->dtvint);
	Si2151_L1_GetProperty(si2151_devp->api, Si2151_ATV_LIF_OUT_PROP, &val);
	n += sprintf(buff + n, "[tuner_atv_lif_out_amp_offset]:%d - %d \n", (val >> 8) & 0xFF, val & 0xFF);
	Si2151_L1_GetProperty(si2151_devp->api, Si2151_DTV_LIF_OUT_PROP, &val);
	n += sprintf(buff + n, "[tuner_dtv_lif_out_amp_offset]:%d - %d \n", (val >> 8) & 0xFF, val & 0xFF);
	Si2151_L1_GetProperty(si2151_devp->api, Si2151_ATV_LIF_FREQ_PROP, &val);
	n += sprintf(buff + n, "[tuner_atv_lif_freq]:%d KHZ\n", val);
	Si2151_L1_GetProperty(si2151_devp->api, Si2151_DTV_LIF_FREQ_PROP, &val);
	n += sprintf(buff + n, "[tuner_dtv_lif_freq]:%d KHZ\n", val);
	Si2151_L1_GetProperty(si2151_devp->api, Si2151_ATV_VIDEO_MODE_PROP, &val);
	n += sprintf(buff + n, "[tuner_atv_lif_inv]:%d \n",((val&0x200) >> 9));
	n += sprintf(buff + n, "[tuner_atv_video_sys]:%d \n",(val&0x07));
	n += sprintf(buff + n, "[tuner_atv_fre_offset]:%d \n", si2151_devp->fre_offset);
#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 9, 0)
	n += sprintf(buff + n, "[tuner_atv_if_inv]:%d \n", si2151_devp->parm.if_inv);
	n += sprintf(buff + n, "[tuner_if_freq]:%d \n", si2151_devp->parm.if_freq);
#else
	n += sprintf(buff + n, "[tuner_atv_if_inv]:%d \n", si2151_devp->if_inv);
	n += sprintf(buff + n, "[tuner_if_freq]:%d \n", si2151_devp->if_freq);
#endif
	n += sprintf(buff + n, "[tuner_freq]:%d \n", si2151_devp->parm.frequency);
	n += sprintf(buff + n, "[tuner signal mode]:%d (0-DTV,1-ATV)\n", si2151_devp->parm.mode);
	n += sprintf(buff + n, "[tuner dtv bw]:%d \n", si2151_devp->api->prop->dtv_mode.bw);
	n += sprintf(buff + n, "[tuner dtv mode]:%d \n", si2151_devp->api->prop->dtv_mode.modulation);
	n += sprintf(buff + n, "[tuner dtv invert spectrum]:%d \n", si2151_devp->api->prop->dtv_mode.invert_spectrum);
	n += sprintf(buff + n, "[tuner dtv lif freq offset]:%d \n", si2151_devp->api->prop->dtv_lif_freq.offset);
	n += sprintf(buff + n, "[tuner set std color %s, audio type %s.\n",
			v4l2_std_to_str(0xff000000 & si2151_devp->parm.std),
			v4l2_std_to_str(0xffffff & si2151_devp->parm.std));
	n += sprintf(buff + n, "[tuner i2c address]: 0x%x.\n", si2151_devp->tuner_client.addr);
	n += sprintf(buff + n, "[si2159] tuner driver version: %s\n",SI2151_VER);
	n += sprintf(buff + n, "[si2159] tuner release version: %s (%s %s %s)\n\n",
			TUNER_VERSION, KERNEL_INFO, __DATE__, __TIME__);

	return n;
}

static CLASS_ATTR_RW(si2159_debug);

#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 9, 0)
#ifdef  CVD_SI2151_RSSI
int cvd_get_rf_strength(void)
{
	 int cvd_rssi=0;
	 if(!si2151_devp)
	 	return 0;
	 cvd_rssi=si2151_devp->api->rsp->tuner_status.rssi;
	 return ((cvd_rssi>0)?cvd_rssi:0);
}
EXPORT_SYMBOL(cvd_get_rf_strength);
#endif


static int si2151_get_rf_strength(struct dvb_frontend *fe, unsigned short *strength)
{
    if (!strength) {
        printk("[si2159..]%s null pointer error.\n", __func__);
        return -ERROR;
    }
    if (Si2151_L1_TUNER_STATUS(si2151_devp->api) != 0) {
        pr_err("[si2159..]%s:get si2159 tuner status error!!!\n", __func__);
        return -ERROR;
    } else *strength = si2151_devp->api->rsp->tuner_status.rssi;

	siprintk("%s strength:%d \n", __func__, *strength);
    return 0;
}

static int si2151_get_tuner_status(struct dvb_frontend *dvb_fe, struct tuner_status_s *status)
{
	si2151_cmdreplyobj_t  *si_cmd_reply = si2151_devp->api->rsp;
	if(!status) {
		pr_err("[si2159..]%s null pointer error.\n",__func__);
		return -ERROR;
	}
	//Si2151_ATV_STATUS_CMD_INTACK_OK = 0
	if(Si2151_L1_TUNER_STATUS(si2151_devp->api)!=0) {
		pr_err("[si2159..]%s:get si2159 tuner status error.\n",__func__);
		return -ERROR;
	}
	status->frequency = si_cmd_reply->tuner_status.freq;
	status->mode        = si_cmd_reply->tuner_status.mode;
	status->rssi           = si_cmd_reply->tuner_status.rssi;
	if(si2151_devp->api->status->atvint == 0) {
		status->tuner_locked = 0;
		siprintk("[si2159..]%s rssi %d dismatch rssi_threshold.lo:%d>.\n",__func__, (si_cmd_reply->tuner_status.rssi<<24),
			(si2151_devp->api->prop->atv_rsq_rssi_threshold.lo));
	} else {
		status->tuner_locked = 1;
		siprintk("[si2159..]%s rssi %d dismatch <rssi_threshold.lo:%d>.\n",__func__, si_cmd_reply->tuner_status.rssi,
			si2151_devp->api->prop->atv_rsq_rssi_threshold.lo);
	}
    siprintk(" frequency %u, mode %d,tuner locked %d.\n",status->frequency, status->mode, status->tuner_locked);
	pr_err("[%s] frequency %u, mode %d,tuner locked %d.\n", __func__,
        status->frequency, status->mode, status->tuner_locked);
	return 0;
}

static int  si2151_tuner_fine_tune(struct dvb_frontend *dvb_fe, int offset_khz)
{
    pr_err("[dgt] %s offset_khz:%d \n", __func__, offset_khz);
	
	siprintk("[si2159..]%s: si2159 fine tune %d khz.\n", __func__, offset_khz);
    return 0;
	
}
#endif


#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 9, 0)
void si2151_set_frequency(unsigned int freq)
{
	int ret = 0;
	if(si2159_debug)
		siprintk("[%s]:now mode is %d(0-DTV,1-ATV)\n",__func__,si2151_devp->parm.mode);
	if (si2151_devp->parm.mode == Si2151_TUNER_TUNE_FREQ_CMD_MODE_ATV)
		ret = Si2151_Tune(si2151_devp->api, si2151_devp->parm.mode, freq);
	else
		ret = Si2151_DTVTune(si2151_devp->api, freq, si2151_devp->api->prop->dtv_mode.bw, si2151_devp->api->prop->dtv_mode.modulation, si2151_devp->api->prop->dtv_mode.invert_spectrum);
	if (ret)
		siprintk("[si2159..]%s: tune frequency error:%d.\n", __func__, ret);
}
//EXPORT_SYMBOL(si2151_set_frequency);
#endif

void si2151_set_std(void)
{
	//unsigned char invert_spectrum = 0;
	unsigned char video_sys=Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_I;
	unsigned char  ret=0;
	v4l2_std_id ptstd = si2151_devp->parm.std;
	
	/* set audio standard of tuner:secam*/
	if (/*(ptstd & (V4L2_COLOR_STD_PAL)) && */(ptstd & V4L2_STD_B)) {
		si2151_devp->fre_offset = 2250000;
		video_sys = Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_B;
	} else if (/*(ptstd & (V4L2_COLOR_STD_PAL)) && */(ptstd & V4L2_STD_GH)) {
		si2151_devp->fre_offset = 2750000;
		video_sys = Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_GH;
	} else if (/*(ptstd & V4L2_COLOR_STD_NTSC) || */((ptstd & V4L2_STD_NTSC) || (ptstd & V4L2_STD_PAL_M))) {
		si2151_devp->fre_offset = 1750000;
		video_sys = Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_M;
	} else if (/*(ptstd & (V4L2_COLOR_STD_PAL)) && */(ptstd & (V4L2_STD_PAL_N | V4L2_STD_PAL_Nc))) {
		si2151_devp->fre_offset = 1750000;
		video_sys = Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_N;
	} else if (/*(ptstd & (V4L2_COLOR_STD_PAL)) && */(ptstd & V4L2_STD_PAL_I)) {
		si2151_devp->fre_offset = 2750000;
		video_sys = Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_I;
	} else if (/*(ptstd & (V4L2_COLOR_STD_PAL)) && */(ptstd & V4L2_STD_DK)) {
		si2151_devp->fre_offset = 2750000;
		video_sys = Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_DK;
	} else if (ptstd & V4L2_STD_SECAM_L) {
		si2151_devp->fre_offset = 2750000;
		video_sys = Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_L;
	} else if (ptstd & V4L2_STD_SECAM_LC) {
		si2151_devp->fre_offset = -2750000;
		video_sys = Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_LP;
	}

	ret = Si2151_ATV_VIDEOSTD(si2151_devp->api, video_sys, 
        si2151_devp->api->prop->atv_video_mode.invert_spectrum);
	if(ret)
		pr_err("[si2159..]%s:set std %llu error\n",__func__, (unsigned long long)ptstd);

    siprintk("[si2159..]%s:video_mode.video_sys:%d, invert_spectrum:%d\n", __func__, video_sys,
        si2151_devp->api->prop->atv_video_mode.invert_spectrum);
}

#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 9, 0)
static int si2151_set_params(struct dvb_frontend *fe)
{
	struct dtv_frontend_properties *c = &fe->dtv_property_cache;
	int strength=100;
    //int si2151_mode = 0;
	if(FE_ANALOG == fe->ops.info.type) {
		if(c->analog.std != si2151_devp->parm.std) {
            //si2151_mode = 
			si2151_devp->parm.std  = c->analog.std;
			si2151_devp->parm.audmode = c->analog.audmode;
			si2151_set_std();
			siprintk("[si2159..]%s set std color %s, audio type %s.\n",__func__,\
					v4l2_std_to_str(0xff000000&si2151_devp->parm.std), v4l2_std_to_str(0xffffff&si2151_devp->parm.std));
		} 
		if(c->frequency  != si2151_devp->parm.frequency) {
			si2151_devp->parm.frequency  = c->frequency;
			si2151_set_frequency(si2151_devp->parm.frequency + si2151_devp->fre_offset);
			siprintk("[si2159..]%s set frequency %u. frequency offset is %d.\n",__func__,si2151_devp->parm.frequency,si2151_devp->fre_offset);
		}
		
	} else {
		/*	if(FE_QAM == fe->ops.info.type)
			{
			if(QAM_128 == parm->u.qam.modulation)
			{
			si2151_devp->api->prop->dtv_lif_out.amp = 22;
			if(Si2151_L1_SetProperty(si2151_devp->api,0,0x707,22))
			printk("[si2159..]%s set dtv lif out amp 22error.\n",__func__);
			}
			else
			{
			si2151_devp->api->prop->dtv_lif_out.amp = 25;
			if(Si2151_L1_SetProperty(si2151_devp->api,0,0x707,25))
			printk("[si2159..]%s set dtv lif out amp 25 error.\n",__func__);
			}
			}*/
		if(FE_ATSC==fe->ops.info.type) {
			si2151_devp->api->prop->dtv_lif_freq.offset=5000;
			siprintk("FE_ATSC set para if is %d\n",si2151_devp->api->prop->dtv_lif_freq.offset);
			if(Si2151_L1_SetProperty(si2151_devp->api,0x706,si2151_devp->api->prop->dtv_lif_freq.offset))
				pr_err("[si2159..]%s set dtv lif out if error.\n",__func__);
			//	parm->frequency=parm->frequency+2500000;//for atsc 2.5mhz
			si2151_devp->api->prop->dtv_mode.bw = Si2151_DTV_MODE_PROP_BW_BW_6MHZ;
			if ((c->modulation <= QAM_AUTO) && (c->modulation != QPSK)) {
				si2151_devp->api->prop->dtv_mode.modulation = Si2151_DTV_MODE_PROP_MODULATION_QAM_US;
			} else if (c->modulation > QAM_AUTO) {
				si2151_devp->api->prop->dtv_mode.modulation = Si2151_DTV_MODE_PROP_MODULATION_ATSC;
			}
		} else if(FE_QAM == fe->ops.info.type) {
			si2151_devp->api->prop->dtv_lif_freq.offset=5000;
			siprintk("FE_QAM set para if is %d\n",si2151_devp->api->prop->dtv_lif_freq.offset);
			if(Si2151_L1_SetProperty(si2151_devp->api,0x706,si2151_devp->api->prop->dtv_lif_freq.offset))
				pr_err("[si2159..]%s set dtv lif out if error.\n",__func__);
			if(c->modulation==QAM_256){
				si2151_devp->api->prop->dtv_lif_out.amp = 23;
			}else{
				si2151_devp->api->prop->dtv_lif_out.amp = 23;
			}
			siprintk("amp is %d,offset is %d,amp+offset is %x\n",si2151_devp->api->prop->dtv_lif_out.amp,
					si2151_devp->api->prop->dtv_lif_out.offset,
					((si2151_devp->api->prop->dtv_lif_out.offset)+((si2151_devp->api->prop->dtv_lif_out.amp)<<8)));
			if(Si2151_L1_SetProperty(si2151_devp->api,0x707,
						(si2151_devp->api->prop->dtv_lif_out.offset)+((si2151_devp->api->prop->dtv_lif_out.amp)<<8)))
				pr_err("[si2159..]%s set dtv lif out amp error.\n",__func__);
			si2151_devp->api->prop->dtv_mode.bw = Si2151_DTV_MODE_PROP_BW_BW_8MHZ;
			si2151_devp->api->prop->dtv_mode.modulation = Si2151_DTV_MODE_PROP_MODULATION_DVBC;
		} else if(FE_DTMB == fe->ops.info.type) {
			si2151_devp->api->prop->dtv_lif_out.amp = 21;
			if(Si2151_L1_SetProperty(si2151_devp->api,0x707, 
						(si2151_devp->api->prop->dtv_lif_out.offset)+((si2151_devp->api->prop->dtv_lif_out.amp)<<8)))
				pr_err("[si2159..]%s set dtv lif out amp error.\n",__func__);

			siprintk("FE_DTMB amp is %d,offset is %d,amp+offset is %x\n",si2151_devp->api->prop->dtv_lif_out.amp,
					si2151_devp->api->prop->dtv_lif_out.offset,((si2151_devp->api->prop->dtv_lif_out.offset)+((si2151_devp->api->prop->dtv_lif_out.amp)<<8)));
			si2151_devp->api->prop->dtv_mode.bw = Si2151_DTV_MODE_PROP_BW_BW_8MHZ;
			si2151_devp->api->prop->dtv_mode.modulation = Si2151_DTV_MODE_PROP_MODULATION_DTMB;
		} else if (FE_OFDM == fe->ops.info.type) {
			si2151_devp->api->prop->dtv_lif_freq.offset = 5000;
			pr_info("FE_OFDM set para if is %d\n",
					si2151_devp->api->prop->dtv_lif_freq.offset);
			if (Si2151_L1_SetProperty(si2151_devp->api, 0x706,
					si2151_devp->api->prop->dtv_lif_freq.offset))
				pr_err("[si2159]%s set dtv lif out if error.\n", __func__);

			si2151_devp->api->prop->dtv_lif_out.amp = 21;
			if(Si2151_L1_SetProperty(si2151_devp->api,0x707,
						(si2151_devp->api->prop->dtv_lif_out.offset)+((si2151_devp->api->prop->dtv_lif_out.amp)<<8)))
				pr_err("[si2159..]%s set dtv lif out amp error.\n",__func__);

			pr_info("FE_OFDM amp is %d,offset is %d,amp+offset is %x\n",si2151_devp->api->prop->dtv_lif_out.amp,
					si2151_devp->api->prop->dtv_lif_out.offset,((si2151_devp->api->prop->dtv_lif_out.offset)+((si2151_devp->api->prop->dtv_lif_out.amp)<<8)));
			si2151_devp->api->prop->dtv_mode.bw = Si2151_DTV_MODE_PROP_BW_BW_8MHZ;
			si2151_devp->api->prop->dtv_mode.modulation = Si2151_DTV_MODE_PROP_MODULATION_DVBT;
		} else if (FE_ISDBT == fe->ops.info.type) {
			si2151_devp->api->prop->dtv_lif_freq.offset = 5000;
			siprintk("FE_OFDM set para if is %d\n",
					si2151_devp->api->prop->dtv_lif_freq.offset);
			if (Si2151_L1_SetProperty(si2151_devp->api, 0x706,
					si2151_devp->api->prop->dtv_lif_freq.offset))
				pr_err("[si2159] %s set dtv lif out if error.\n", __func__);

			si2151_devp->api->prop->dtv_lif_out.amp = 21;
			if(Si2151_L1_SetProperty(si2151_devp->api,0x707,
						(si2151_devp->api->prop->dtv_lif_out.offset)+((si2151_devp->api->prop->dtv_lif_out.amp)<<8)))
				pr_err("[si2159] %s set dtv lif out amp error.\n", __func__);

			siprintk("FE_ISDBT amp is %d,offset is %d,amp+offset is %x\n",si2151_devp->api->prop->dtv_lif_out.amp,
					si2151_devp->api->prop->dtv_lif_out.offset,((si2151_devp->api->prop->dtv_lif_out.offset)+((si2151_devp->api->prop->dtv_lif_out.amp)<<8)));
			si2151_devp->api->prop->dtv_mode.bw = Si2151_DTV_MODE_PROP_BW_BW_6MHZ;
			si2151_devp->api->prop->dtv_mode.modulation = Si2151_DTV_MODE_PROP_MODULATION_ISDBT;
		}

		si2151_devp->parm.frequency  = c->frequency;
		si2151_set_frequency(si2151_devp->parm.frequency);
		siprintk("[si2159..]%s set frequency %u. bw %d,mode %d\n",__func__,si2151_devp->parm.frequency,
			si2151_devp->api->prop->dtv_mode.bw, si2151_devp->api->prop->dtv_mode.modulation);
		if(Si2151_L1_TUNER_STATUS(si2151_devp->api)!=0) {
			pr_err("[si2159..]%s:get si2159 tuner status error!!!\n",__func__);
			return -ERROR;
		} else
			strength = si2151_devp->api->rsp->tuner_status.rssi-256;
		siprintk("strength is %d\n",strength);
	}

	return 0;
}
#endif

#if 0
//try audmode B,CH,I,DK,return the sound level
static unsigned char set_video_audio_mode(unsigned char color,unsigned char audmode)
{
        int ret = 0;
        ret = Si2151_L1_SetProperty(si2151_devp->api, 0x604, color<<4|audmode);
   //     ret = si2151_atv_restart(si2151_devp->api, 0,  &si2151_devp->si_cmd_reply);
        mdelay(audio_delay);
        if(ret)
                printk("[si2159..]%s set sound mode %d error.\n",__func__,audmode);
        //ret = si2151_atv_status(si2151_devp->api, Si2151_ATV_STATUS_CMD_INTACK_OK, &si2151_devp->si_cmd_reply);
        if(ret)
                printk("[si2159..]%s:get si2159 atv status error.\n",__func__);
        if(!ret)
                return si2151_devp->si_cmd_reply.atv_status.sound_level;
        else
                return ret;
}

static void get_mono_sound_mode(unsigned int *mode)
{
	unsigned char max_level=0, cu_level=0;
	//set audio mode B=0,GH=1,I=4,DK=5
	cu_level = set_video_audio_mode(si2151_devp->api->prop->atv_video_mode.color,Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_B);
	if(cu_level > max_level) {
		max_level = cu_level;
		*mode = V4L2_STD_B;
	}
	cu_level = set_video_audio_mode(si2151_devp->api->prop->atv_video_mode.color,Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_GH);
	if(cu_level > max_level) {
		max_level = cu_level;
		*mode = V4L2_STD_GH;
	}
	cu_level = set_video_audio_mode(si2151_devp->api->prop->atv_video_mode.color,Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_I);
	if(cu_level > max_level) {
		max_level = cu_level;
		*mode = V4L2_STD_PAL_I;
	}
	cu_level = set_video_audio_mode(si2151_devp->api->prop->atv_video_mode.color,Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_DK);
	if(cu_level > max_level) {
		max_level = cu_level;
		*mode = V4L2_STD_DK;
	}
	siprintk("[si2159..]%s auto result audio mode is 0x%x,%s.\n",__func__, *mode,v4l2_std_to_str((v4l2_std_id)*mode));
}
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 9, 0)
static int si2151_set_config(struct dvb_frontend *fe, void *arg)
{
	struct tuner_param_s *param = (struct tuner_param_s*)arg;
	if(!arg) {
		pr_err("[si2159..]%s null pointer error.\n",__func__);
		return -ERROR;
	}
	switch(param->cmd) {
		case TUNER_CMD_AUDIO_MUTE:
			//Si2151_ATV_AF_OUT_PROP = 0x060b
			if(Si2151_L1_SetProperty(si2151_devp->api, 0x60b, 0)) {
				pr_err("[si2159..]%s mute tuner error.\n",__func__);
				return -ERROR;
			}
			break;
		case TUNER_CMD_AUDIO_ON:
			break;
		case TUNER_CMD_TUNER_POWER_DOWN:
			if(Si2151_Powerdown(si2151_devp->api)) {
				pr_err("[si2159..]%s power down tuner error.\n",__func__);
				return -ERROR;
			}
			siprintk("[si2159..]%s power down tuner TUNER_CMD_TUNER_POWER_DOWN.\n",__func__);
			break;
		case TUNER_CMD_TUNER_POWER_ON:
			if(Si2151_Init(si2151_devp->api)) {
				pr_err("[si2159..]%s: si2159 initializate error.\n",__func__);
				return -ERROR;
			}
			// if(Si2151_Configure(si2151_devp->api))
			// 	pr_err("[si2159..]%s: si2159 configure atv&dtv error.\n",__func__);
			break;
		case TUNER_CMD_SET_VOLUME:
			
			break;
		case TUNER_CMD_GET_MONO_MODE:
			//get_mono_sound_mode(&param->parm);
            pr_err("%s TUNER_CMD_GET_MONO_MODE\n", __func__);
			break;
		case TUNER_CMD_SET_LEAP_SETP_SIZE:
			si2151_devp->parm.leap_step = param->parm;
			break;
		case TUNER_CMD_SET_BEST_LOCK_RANGE:
			break;
		case TUNER_CMD_GET_BEST_LOCK_RANGE:
			break;
		case TUNER_CMD_SET_CVBS_AMP_OUT:
			break;
		case TUNER_CMD_GET_CVBS_AMP_OUT:
			break;
		default:
			break;
	}
	return 0;
}


int demod_set_si2151(struct dvb_frontend *fe, struct aml_demod_sta *demod_sta, struct aml_demod_i2c *demod_i2c, struct aml_tuner_sys *tuner_sys)
{
	unsigned int freq;
//	int err_code;
	freq=tuner_sys->ch_freq;
	printk("freq is %d\n",freq);
    #if 0
	err_code = Si2151_Init(si2151_devp->api);
	//err_code = Si2151_Configure(si2151_devp->api);
	if(err_code) {
		pr_err("[si2176..]%s init si2176 error.\n",__func__);
		return err_code;
	}
    #endif
	si2151_devp->api->prop->dtv_lif_out.amp = tuner_sys->amp;
	si2151_devp->api->prop->dtv_lif_freq.offset = tuner_sys->if_freq;
	siprintk("amp is %d,offset is %d,amp+offset is %x\n",si2151_devp->api->prop->dtv_lif_out.amp,
			si2151_devp->api->prop->dtv_lif_out.offset,
			((si2151_devp->api->prop->dtv_lif_out.offset)+((si2151_devp->api->prop->dtv_lif_out.amp)<<8)));
	if(Si2151_L1_SetProperty(si2151_devp->api, 0x707,
				(si2151_devp->api->prop->dtv_lif_out.offset)+((si2151_devp->api->prop->dtv_lif_out.amp)<<8)))
		pr_err("[si2159..]%s set dtv lif out amp error.\n",__func__);
	siprintk("if is %d\n",si2151_devp->api->prop->dtv_lif_freq.offset);
	if(Si2151_L1_SetProperty(si2151_devp->api, 0x706,si2151_devp->api->prop->dtv_lif_freq.offset))
		pr_err("[si2159..]%s set dtv lif out if error.\n",__func__);

	si2151_set_frequency(freq);
	demod_sta->ch_if=tuner_sys->if_freq;
	return 0;
}


static int si2151_get_status(struct dvb_frontend *fe, u32 *stat);
static void si2151_get_pll_status(struct dvb_frontend *fe, void *stat);
static int si2151_analog_get_afc(struct dvb_frontend *fe, s32 *afc);

static int si2151_tuner_get_ops(struct aml_fe_dev *dev, int mode, void *ops)
{
	struct dvb_tuner_ops *si2151_tuner_ops  = (struct dvb_tuner_ops*)ops;
	if(!ops) {
		pr_err("[si2159..]%s null pointer error.\n",__func__);
		return -ERROR;
	}
	si2151_tuner_ops->info.frequency_min    = Si2151_TUNER_TUNE_FREQ_CMD_FREQ_MIN;
	si2151_tuner_ops->info.frequency_max   = Si2151_TUNER_TUNE_FREQ_CMD_FREQ_MAX;
	switch(mode) {
		case AM_FE_QPSK:
			//SI2151_DTV_MODE_PROP_MODULATION_ISDBT = 4
			//si2151_devp->api->prop->dtv_mode.modulation = 4;
			break;
		case AM_FE_QAM:
			//SI2151_DTV_MODE_PROP_MODULATION_DVBC = 3
			//si2151_devp->api->prop->dtv_mode.modulation = 3;
			break;
		case AM_FE_OFDM:
			//SI2151_DTV_MODE_PROP_MODULATION_DVBT = 2
			//si2151_devp->api->prop->dtv_mode.modulation = 2;
			break;
		case AM_FE_ATSC:
			//SI2151_DTV_MODE_PROP_MODULATION_ATSC = 0
			//si2151_devp->api->prop->dtv_mode.modulation = 0;
			break;
		case AM_FE_ANALOG:
			break;
		case AM_FE_DTMB:
			//SI2176_DTV_MODE_PROP_MODULATION_DTMB = 6
			//si2151_devp->api->prop->dtv_mode.modulation = 6;
			break;
		default:
			printk("[si2159..] %s no mode to match %d.\n",__func__, mode);
			break;
	}

	if(AM_FE_ANALOG == mode) { //the auto afc step size 1/2 M
		si2151_tuner_ops->info.frequency_step = 0x0;
		//fine tune
		si2151_tuner_ops->fine_tune             = si2151_tuner_fine_tune;
		//the box for expand
		si2151_tuner_ops->set_config           = si2151_set_config;
		si2151_devp->parm.mode                 = Si2151_TUNER_TUNE_FREQ_CMD_MODE_ATV;
	} else {//dtv doesn't use auto afc
	//	if(Si2151_L1_SetProperty(si2151_devp->api, 0x703,
	//				si2151_devp->api->prop->dtv_mode.modulation<<4|8))
	//		pr_err("[si2159..] %s mode %d Si2151_L1_SetProperty error. %d\n",__func__, mode, Si2151_L1_SetProperty(si2151_devp->api, 0x703,
	//				si2151_devp->api->prop->dtv_mode.modulation<<4|8));
		si2151_devp->parm.mode = Si2151_TUNER_TUNE_FREQ_CMD_MODE_DTV;
		si2151_tuner_ops->info.frequency_step = 0x0;
	}
	si2151_tuner_ops->get_rf_strength       = si2151_get_rf_strength;
	si2151_tuner_ops->get_tuner_status    = si2151_get_tuner_status;
	si2151_tuner_ops->get_status              =si2151_get_status;
	si2151_tuner_ops->get_pll_status              =si2151_get_pll_status;
	//set std&frequency
	si2151_tuner_ops->set_params     	  = si2151_set_params;
	si2151_tuner_ops->get_afc		 = si2151_analog_get_afc;

	si2151_tuner_ops->set_tuner	=	demod_set_si2151;
	si2151_tuner_ops->get_strength	=	si2151_get_strength;

	return 0;
}

#define TUNER_POWER_GPIO_OWNER  "TUNER_OWNER"

static int si2151_tuner_fe_init(struct aml_fe_dev *dev)
{

	int error_code = 0;
	if(!dev) {
		printk("[si2159..]%s: null pointer error.\n",__func__);
		return -ERROR;
	}
	si2151_devp->tuner_client.adapter = dev->i2c_adap;
	si2151_devp->tuner_client.addr    = dev->i2c_addr;
	si2151_devp->api->i2c = &(si2151_devp->api->i2cObj);
	si2151_devp->api->i2c->_i2c_client = &(si2151_devp->tuner_client);
    si2151_devp->api->cmdObj.power_up.clock_mode = Si2151_POWER_UP_CMD_CLOCK_MODE_XTAL;
    si2151_devp->api->cmdObj.power_up.en_xout = Si2151_POWER_UP_CMD_EN_XOUT_DIS_XOUT;
    Si2151_L1_API_Init(si2151_devp->api, dev->i2c_addr);
	
    if(!sprintf(si2151_devp->tuner_client.name,SI2151_TUNER_I2C_NAME)) {
		printk("[si2159..]%s sprintf name error.\n",__func__);
	}

	printk("[%s]tuner reset.dev->reset_value=[%d],i2c_addr is %x \n",
			__func__,dev->reset_value,dev->i2c_addr);
	return error_code;
}

static int si2151_enter_mode(struct aml_fe *fe, int mode)
{
	int err_code;
	err_code = Si2151_Init(si2151_devp->api);
	//err_code = Si2151_Configure(si2151_devp->api);
	if(err_code) {
		pr_err("[si2159..]%s init si2159 error.\n",__func__);
		return err_code;
	}
	return 0;
}
static int si2151_leave_mode(struct aml_fe *fe, int mode)
{
	int err_code;
	si2151_devp->parm.frequency=0;
	si2151_devp->parm.std=0;
	err_code = Si2151_Powerdown(si2151_devp->api);
	if(err_code) {
		pr_err("[si2159..]%s power down si2159 error.\n",__func__);
		return err_code;
	}
	return 0;
}

static int si2151_suspend(struct aml_fe_dev *dev)
{
	int err_code;
	si2151_devp->parm.frequency=0;
	si2151_devp->parm.std=0;
	err_code = Si2151_Powerdown(si2151_devp->api);
	if(err_code) {
		pr_err("[si2159..]%s si2159 standby mode is err.\n",__func__);
		return err_code;
	}
	return 0;

}
static int si2151_resume(struct aml_fe_dev *dev)
{
	int err_code;

	err_code = Si2151_Init(si2151_devp->api);
	//err_code = Si2151_Configure(si2151_devp->api);
	if(err_code) {
		pr_info("[si2159..]%s resume si2159 error.\n",__func__);
		return err_code;
	}
	return 0;
}
static struct aml_fe_drv si2151_tuner_drv = {
        .name    = "si2159_tuner",
        .capability = AM_FE_ANALOG|AM_FE_QPSK|AM_FE_QAM|AM_FE_ATSC|AM_FE_OFDM|AM_FE_DTMB,
        .id      = AM_TUNER_SI2159,
        .get_ops = si2151_tuner_get_ops,
        .init    = si2151_tuner_fe_init,
        .enter_mode = si2151_enter_mode,
        .leave_mode = si2151_leave_mode,
        .suspend = si2151_suspend,
        .resume = si2151_resume,
};

static int si2151_analog_get_afc(struct dvb_frontend *fe, s32 *afc)
{
#if 0
	if(si2151_atv_status(si2151_devp->api, Si2151_ATV_STATUS_CMD_INTACK_OK, &si2151_devp->si_cmd_reply)!=0)
	{
		pr_info("[si2159..]%s: get si2159 atv status error.\n",__func__);
		*afc=0;
		return -ERROR;
	}
	else

		*afc = si2151_devp->si_cmd_reply.atv_status.afc_freq;
#endif

	return 0;
}

//tuner lock status & demod lock status should be same in silicon tuner
static int si2151_get_status(struct dvb_frontend *fe, u32 *stat)
{
    fe_status_t *status = (fe_status_t*)stat;
    struct aml_fe *fee;
    int data = 0;
    int video_sys = 0;
    unsigned char inv_bit = 0;
    unsigned char mode_bit = 0;
    unsigned char mode_mask = 0;
    unsigned int prop_mode = 0;
    unsigned int prop_lif = 0;

    if (si2151_devp->parm.mode == Si2151_TUNER_TUNE_FREQ_CMD_MODE_ATV) {
        inv_bit = 0x09;
        mode_bit = 0x00;
        mode_mask = 0x07;
        prop_mode = Si2151_ATV_VIDEO_MODE_PROP;
        prop_lif = Si2151_ATV_LIF_FREQ_PROP;
    } else {
        inv_bit = 0x08;
        mode_bit = 0x04;
        mode_mask = 0x0f;
        prop_mode = Si2151_DTV_MODE_PROP;
        prop_lif = Si2151_DTV_LIF_FREQ_PROP;
    }

    //lif_inv
    Si2151_L1_GetProperty(si2151_devp->api, prop_mode, &data);
    si2151_devp->parm.if_inv = (data >> inv_bit) & 0x01;
    video_sys = (data >> mode_bit) & mode_mask;
    //lif_freq
    Si2151_L1_GetProperty(si2151_devp->api, prop_lif, &data);
    si2151_devp->parm.if_freq = data * 1000;
    fee = fe->demodulator_priv;
    if (si2151_devp->parm.if_inv == 0 || video_sys == Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_LP) {
		if (video_sys == Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_LP)
			fee->demod_param.if_inv = 1;
		else
			fee->demod_param.if_inv = 0;

		fee->demod_param.if_freq = si2151_devp->parm.if_freq - si2151_devp->fre_offset;
	} else {
		fee->demod_param.if_inv = 1;
		fee->demod_param.if_freq = si2151_devp->parm.if_freq + si2151_devp->fre_offset;
	}
	*status = FE_TIMEDOUT;
    siprintk("%s @@@@@@ parm.if_inv:%d ,si2151_devp->parm.if_freq:%d, "
           "si2151_devp->fre_offset:%d,demod_param.if_freq:%d \n",
        __func__, si2151_devp->parm.if_inv,
        si2151_devp->parm.if_freq,si2151_devp->fre_offset,
        fee->demod_param.if_freq);

    return 0;
}
//tuner lock status & demod lock status should be same in silicon tuner
static void si2151_get_pll_status(struct dvb_frontend *fe, void *stat)
{
   si2151_get_status(fe, (u32 *) stat);
}
#endif

static int __init si2159_tuner_init(void)
{
	int ret = 0;
	si2151_devp = kmalloc(sizeof(struct si2151_device_s), GFP_KERNEL);

	if(!si2151_devp) {
		pr_info("[si2159..] %s:allocate memory error,no enough memory for struct si2151_dev_s.\n",__func__);
		return -ENOMEM;
	}
	memset(si2151_devp, 0, sizeof(struct si2151_device_s));
    si2151_devp->api = &si2151_devp->apiObj;
    si2151_devp->api->i2c = &(si2151_devp->api->i2cObj);
    si2151_devp->api->i2c->_i2c_client = &(si2151_devp->tuner_client);

#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 9, 0)
	si2151_devp->clsp = class_create(THIS_MODULE,TUNER_DEVICE_NAME);
#else
	si2151_devp->clsp = aml_class_create(THIS_MODULE,TUNER_DEVICE_NAME);
#endif
	if(!si2151_devp->clsp) {
		pr_info("[si2159..]%s:create class error.\n",__func__);
		kfree(si2151_devp);
		si2151_devp = NULL;
		return PTR_ERR(si2151_devp->clsp);
	}

#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 9, 0)
	ret = class_create_file(si2151_devp->clsp, &class_attr_si2159_debug);
#else
	ret = aml_class_create_file(si2151_devp->clsp, &class_attr_si2159_debug);
#endif
	if(ret)
		pr_err("[si2159]%s create si2159 class file error.\n",__func__);
#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 9, 0)
	/*initialize the tuner common struct and register*/
	aml_register_fe_drv(AM_DEV_TUNER, &si2151_tuner_drv);
	//aml_register_fe_drv(AM_DEV_ATV_DEMOD, &si2151_analog_drv);
#endif
	printk("[si2159..]%s, tuner version: %s (%s %s %s).\n",
			__func__, TUNER_VERSION, KERNEL_INFO, __DATE__, __TIME__);
	return 0;
}

static void __exit si2159_tuner_exit(void)
{
#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 9, 0)
	class_destroy(si2151_devp->clsp);
#else
	aml_class_destroy(si2151_devp->clsp);
#endif
	kfree(si2151_devp);
#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 9, 0)
	aml_unregister_fe_drv(AM_DEV_TUNER, &si2151_tuner_drv);
#endif
	pr_info("[si2159..]%s: driver removed ok.\n",__func__);
}

MODULE_AUTHOR("Amlogic");
MODULE_DESCRIPTION("si2159 tuner device driver");
#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 9, 0)
MODULE_LICENSE("GPL");
#else
//MODULE_LICENSE("");
#endif
MODULE_VERSION(TUNER_VERSION);

fs_initcall(si2159_tuner_init);
module_exit(si2159_tuner_exit);
