#include <uapi/linux/dvb/frontend.h>

#include "si2151_func.h"
#include "si2159.h"


#if LINUX_VERSION_CODE >= KERNEL_VERSION(4, 9, 0)
extern struct si2151_device_s *si2151_devp;
extern void si2151_set_std(void);

#if LINUX_VERSION_CODE >= KERNEL_VERSION(5, 4, 0)
static void si2159_release_ex(struct dvb_frontend *fe);
#else
static int si2159_release_ex(struct dvb_frontend *fe);
#endif
static int si2159_init_ex(struct dvb_frontend *fe);
static int si2159_sleep_ex(struct dvb_frontend *fe);
static int si2159_suspend_ex(struct dvb_frontend *fe);
static int si2159_resume_ex(struct dvb_frontend *fe);
static int si2159_set_params_ex(struct dvb_frontend *fe);
static int si2159_set_analog_params_ex(struct dvb_frontend *fe,
		struct analog_parameters *p);
static int si2159_calc_regs_ex(struct dvb_frontend *fe, u8 *buf, int buf_len);
static int si2159_set_config_ex(struct dvb_frontend *fe, void *priv_cfg);
static int si2159_get_frequency_ex(struct dvb_frontend *fe, u32 *frequency);
static int si2159_get_bandwidth_ex(struct dvb_frontend *fe, u32 *frequency);
static int si2159_get_if_frequency_ex(struct dvb_frontend *fe, u32 *frequency);
static int si2159_get_status_ex(struct dvb_frontend *fe, u32 *status);
static int si2159_get_rf_strength_ex(struct dvb_frontend *fe, u16 *strength);
#ifdef CONFIG_AMLOGIC_DVB_COMPAT
static int si2159_get_strength_ex(struct dvb_frontend *fe, s16 *strength);
#endif
static int si2159_get_afc_ex(struct dvb_frontend *fe, s32 *afc);
static int si2159_set_frequency_ex(struct dvb_frontend *fe, u32 frequency);
static int si2159_set_bandwidth_ex(struct dvb_frontend *fe, u32 bandwidth);


#if LINUX_VERSION_CODE >= KERNEL_VERSION(5, 4, 0)
static void si2159_release_ex(struct dvb_frontend *fe)
#else
static int si2159_release_ex(struct dvb_frontend *fe)
#endif
{
	int err_code = 0;

	si2151_devp->parm.frequency = 0;
	si2151_devp->parm.std = 0;
	si2151_devp->parm.audmode = 0;
	si2151_devp->fre_offset = 0;

	err_code = Si2151_Powerdown(si2151_devp->api);
	if (err_code) {
		pr_err("[si2159] %s power down si2159 error.\n", __func__);
#if LINUX_VERSION_CODE >= KERNEL_VERSION(5, 4, 0)
#else
		return err_code;
#endif
	}

	pr_info("[si2159] %s OK.\n", __func__);

#if LINUX_VERSION_CODE >= KERNEL_VERSION(5, 4, 0)
#else
	return 0;
#endif
}

static int si2159_init_ex(struct dvb_frontend *fe)
{
#if 0
	int err_code = 0;

	if (fe->ops.info.type == FE_ANALOG)
		si2151_devp->parm.mode = Si2151_TUNER_TUNE_FREQ_CMD_MODE_ATV;
	else
		si2151_devp->parm.mode = Si2151_TUNER_TUNE_FREQ_CMD_MODE_DTV;

	err_code = Si2151_Init(si2151_devp->api);
	/* err_code = Si2151_Configure(si2151_devp->api);*/
	if (err_code) {
		pr_err("[si2159] %s init si2159 error.\n", __func__);
		return err_code;
	}
#endif
	pr_info("[si2159] %s OK\n", __func__);

	return 0;
}

static int si2159_sleep_ex(struct dvb_frontend *fe)
{
	pr_info("[si2159] %s OK.\n", __func__);

	return 0;
}

static int si2159_suspend_ex(struct dvb_frontend *fe)
{
	int err_code = 0;

	si2151_devp->parm.frequency = 0;
	si2151_devp->parm.std = 0;
	si2151_devp->parm.audmode = 0;
	si2151_devp->fre_offset = 0;

	err_code = Si2151_Powerdown(si2151_devp->api);
	if (err_code) {
		pr_err("[si2159] %s si2159 standby mode is err.\n", __func__);
		return err_code;
	}

	pr_info("[si2159] %s OK.\n", __func__);

	return 0;
}

static int si2159_resume_ex(struct dvb_frontend *fe)
{
	int err_code = 0;

	err_code = Si2151_Init(si2151_devp->api);
	/*err_code = Si2151_Configure(si2151_devp->api);*/
	if (err_code) {
		pr_info("[si2159] %s resume si2159 error.\n", __func__);
		return err_code;
	}

	pr_info("[si2159] %s OK.\n", __func__);

	return 0;
}

/* This is the recomended way to set the tuner */
static int si2159_set_params_ex(struct dvb_frontend *fe)
{
	struct dtv_frontend_properties *c = &fe->dtv_property_cache;
	int strength = 100;

	pr_info("[si2159] %s: fe->ops.info.type %d\n", __func__, fe->ops.info.type);

/*
	if (FE_QAM == fe->ops.info.type) {
		if (QAM_128 == parm->u.qam.modulation) {
			si2151_devp->api->prop->dtv_lif_out.amp = 22;
			if (Si2151_L1_SetProperty(si2151_devp->api,0,0x707,22))
				pr_err("[si2159] %s set dtv lif out amp 22error.\n", __func__);
		} else {
			si2151_devp->api->prop->dtv_lif_out.amp = 25;
			if (Si2151_L1_SetProperty(si2151_devp->api,0,0x707,25))
				pr_err("[si2159] %s set dtv lif out amp 25 error.\n", __func__);
		}
	}
*/

	if (FE_ATSC == fe->ops.info.type) {
		si2151_devp->api->prop->dtv_lif_freq.offset = 5000;
		pr_dbg("FE_ATSC set para if is %d\n",
				si2151_devp->api->prop->dtv_lif_freq.offset);
		if (Si2151_L1_SetProperty(si2151_devp->api, 0x706,
				si2151_devp->api->prop->dtv_lif_freq.offset))
			pr_err("[si2159] %s set dtv lif out if error.\n", __func__);
		//parm->frequency = parm->frequency + 2500000;//for atsc 2.5mhz
		si2151_devp->api->prop->dtv_mode.bw = Si2151_DTV_MODE_PROP_BW_BW_6MHZ;
		if ((c->modulation <= QAM_AUTO) && (c->modulation != QPSK)) {
			si2151_devp->api->prop->dtv_mode.modulation =
					Si2151_DTV_MODE_PROP_MODULATION_QAM_US;
		} else if (c->modulation > QAM_AUTO) {
			si2151_devp->api->prop->dtv_mode.modulation =
					Si2151_DTV_MODE_PROP_MODULATION_ATSC;
		}
	} else if (FE_QAM == fe->ops.info.type) {
		si2151_devp->api->prop->dtv_lif_freq.offset = 5000;
		pr_dbg("FE_QAM set para if is %d\n",
				si2151_devp->api->prop->dtv_lif_freq.offset);
		if (Si2151_L1_SetProperty(si2151_devp->api, 0x706,
				si2151_devp->api->prop->dtv_lif_freq.offset))
			pr_err("[si2159] %s set dtv lif out if error.\n", __func__);
		if (c->modulation == QAM_256) {
			si2151_devp->api->prop->dtv_lif_out.amp = 23;
		} else {
			si2151_devp->api->prop->dtv_lif_out.amp = 23;
		}
		pr_dbg("amp is %d,offset is %d,amp+offset is %x\n",
				si2151_devp->api->prop->dtv_lif_out.amp,
				si2151_devp->api->prop->dtv_lif_out.offset,
				((si2151_devp->api->prop->dtv_lif_out.offset)
						+ ((si2151_devp->api->prop->dtv_lif_out.amp) << 8)));
		if (Si2151_L1_SetProperty(si2151_devp->api, 0x707,
				(si2151_devp->api->prop->dtv_lif_out.offset)
						+ ((si2151_devp->api->prop->dtv_lif_out.amp) << 8)))
			pr_err("[si2159] %s set dtv lif out amp error.\n", __func__);
		si2151_devp->api->prop->dtv_mode.bw = Si2151_DTV_MODE_PROP_BW_BW_8MHZ;
		si2151_devp->api->prop->dtv_mode.modulation =
				Si2151_DTV_MODE_PROP_MODULATION_DVBC;
	} else if (FE_DTMB == fe->ops.info.type) {
		si2151_devp->api->prop->dtv_lif_out.amp = 21;
		if(Si2151_L1_SetProperty(si2151_devp->api,0x707,
					(si2151_devp->api->prop->dtv_lif_out.offset)+((si2151_devp->api->prop->dtv_lif_out.amp)<<8)))
			pr_err("[si2159] %s set dtv lif out amp error.\n", __func__);

		pr_dbg("FE_DTMB amp is %d,offset is %d,amp+offset is %x\n",si2151_devp->api->prop->dtv_lif_out.amp,
				si2151_devp->api->prop->dtv_lif_out.offset,((si2151_devp->api->prop->dtv_lif_out.offset)+((si2151_devp->api->prop->dtv_lif_out.amp)<<8)));
		si2151_devp->api->prop->dtv_mode.bw = Si2151_DTV_MODE_PROP_BW_BW_8MHZ;
		si2151_devp->api->prop->dtv_mode.modulation = Si2151_DTV_MODE_PROP_MODULATION_DTMB;
	} else if (FE_OFDM == fe->ops.info.type) {
		si2151_devp->api->prop->dtv_lif_freq.offset = 5000;
		pr_dbg("FE_OFDM set para if is %d\n",
				si2151_devp->api->prop->dtv_lif_freq.offset);
		if (Si2151_L1_SetProperty(si2151_devp->api, 0x706,
				si2151_devp->api->prop->dtv_lif_freq.offset))
			pr_err("[si2159] %s set dtv lif out if error.\n", __func__);

		si2151_devp->api->prop->dtv_lif_out.amp = 21;
		if(Si2151_L1_SetProperty(si2151_devp->api,0x707,
					(si2151_devp->api->prop->dtv_lif_out.offset)+((si2151_devp->api->prop->dtv_lif_out.amp)<<8)))
			pr_err("[si2159] %s set dtv lif out amp error.\n", __func__);

		pr_dbg("FE_OFDM amp is %d,offset is %d,amp+offset is %x\n",si2151_devp->api->prop->dtv_lif_out.amp,
				si2151_devp->api->prop->dtv_lif_out.offset,((si2151_devp->api->prop->dtv_lif_out.offset)+((si2151_devp->api->prop->dtv_lif_out.amp)<<8)));
		si2151_devp->api->prop->dtv_mode.modulation = Si2151_DTV_MODE_PROP_MODULATION_DVBT;
		switch (c->bandwidth_hz) {
		case 1700000:
			si2151_devp->api->prop->dtv_mode.bw = Si2151_DTV_MODE_PROP_BW_BW_1P7MHZ;
			break;
		case 5000000:
		case 6000000:
			si2151_devp->api->prop->dtv_mode.bw = Si2151_DTV_MODE_PROP_BW_BW_6MHZ;
			break;
		case 7000000:
			si2151_devp->api->prop->dtv_mode.bw = Si2151_DTV_MODE_PROP_BW_BW_7MHZ;
			break;
		case 8000000:
			si2151_devp->api->prop->dtv_mode.bw = Si2151_DTV_MODE_PROP_BW_BW_8MHZ;
			break;
		default:
			si2151_devp->api->prop->dtv_mode.bw = Si2151_DTV_MODE_PROP_BW_BW_8MHZ;
			break;
		}
	} else if (FE_ISDBT == fe->ops.info.type) {
		si2151_devp->api->prop->dtv_lif_freq.offset = 5000;
		pr_dbg("FE_OFDM set para if is %d\n",
				si2151_devp->api->prop->dtv_lif_freq.offset);
		if (Si2151_L1_SetProperty(si2151_devp->api, 0x706,
				si2151_devp->api->prop->dtv_lif_freq.offset))
			pr_err("[si2159] %s set dtv lif out if error.\n", __func__);

		si2151_devp->api->prop->dtv_lif_out.amp = 21;
		if(Si2151_L1_SetProperty(si2151_devp->api,0x707,
					(si2151_devp->api->prop->dtv_lif_out.offset)+((si2151_devp->api->prop->dtv_lif_out.amp)<<8)))
			pr_err("[si2159] %s set dtv lif out amp error.\n", __func__);

		pr_dbg("FE_ISDBT amp is %d,offset is %d,amp+offset is %x\n",si2151_devp->api->prop->dtv_lif_out.amp,
				si2151_devp->api->prop->dtv_lif_out.offset,((si2151_devp->api->prop->dtv_lif_out.offset)+((si2151_devp->api->prop->dtv_lif_out.amp)<<8)));
		si2151_devp->api->prop->dtv_mode.bw = Si2151_DTV_MODE_PROP_BW_BW_6MHZ;
		si2151_devp->api->prop->dtv_mode.modulation = Si2151_DTV_MODE_PROP_MODULATION_ISDBT;
	}

	si2151_devp->fre_offset = 0;
	si2151_devp->parm.frequency = c->frequency;
	si2159_set_frequency_ex(fe, si2151_devp->parm.frequency);
	pr_dbg("[si2159] %s set frequency %u, bw %d, mode %d\n", __func__, si2151_devp->parm.frequency,
		si2151_devp->api->prop->dtv_mode.bw, si2151_devp->api->prop->dtv_mode.modulation);
	if (Si2151_L1_TUNER_STATUS(si2151_devp->api) != 0) {
		pr_err("[si2159] %s:get si2159 tuner status error!!!\n", __func__);
		return -1;
	} else
		strength = si2151_devp->api->rsp->tuner_status.rssi - 256;

	pr_dbg("strength is %d\n",strength);

	return 0;
}

static int si2159_set_analog_params_ex(struct dvb_frontend *fe, struct analog_parameters *p)
{
	/* if (p->std != si2151_devp->parm.std || p->audmode != si2151_devp->parm.audmode) */ {
		/* si2151_mode = */
		si2151_devp->parm.std = p->std;
		si2151_devp->parm.audmode = p->audmode;
		si2151_set_std();

		pr_dbg("[si2159] %s set std color %s, audio type %s.\n",
				__func__,
				v4l2_std_to_str((0xff000000 & si2151_devp->parm.std)),
				v4l2_std_to_str((0xffffff & si2151_devp->parm.std)));
	}

	/* if (p->frequency != si2151_devp->parm.frequency) */{
		si2151_devp->parm.frequency = p->frequency;
		si2159_set_frequency_ex(fe,
				si2151_devp->parm.frequency + si2151_devp->fre_offset);
		pr_dbg("[si2159] %s set frequency %u. frequency offset is %d.\n",
				__func__, si2151_devp->parm.frequency, si2151_devp->fre_offset);
	}

	return 0;
}

static int si2159_set_config_ex(struct dvb_frontend *fe, void *priv_cfg)
{
	int err_code = 0;

	pr_info("[si2159] %s fe->ops.info.type %d.\n", __func__, fe->ops.info.type);

	if (fe->ops.info.type == FE_ANALOG)
		si2151_devp->parm.mode = Si2151_TUNER_TUNE_FREQ_CMD_MODE_ATV;
	else
		si2151_devp->parm.mode = Si2151_TUNER_TUNE_FREQ_CMD_MODE_DTV;

	err_code = Si2151_Init(si2151_devp->api);
	/* err_code = Si2151_Configure(si2151_devp->api);*/
	if (err_code) {
		pr_err("[si2159] %s init si2159 error.\n", __func__);
		return err_code;
	}

	pr_info("[si2159] %s OK.\n", __func__);

	return 0;
}

static int si2159_get_frequency_ex(struct dvb_frontend *fe, u32 *frequency)
{
	*frequency = si2151_devp->parm.frequency;

	return 0;
}

static int si2159_get_bandwidth_ex(struct dvb_frontend *fe, u32 *frequency)
{
	return 0;
}

static int si2159_get_if_frequency_ex(struct dvb_frontend *fe, u32 *frequency)
{
	/* frequency[0]: if_inv.
	 * frequency[1]: if_freq.
	 */

	int data = 0;
	int video_sys = 0;
	unsigned char inv_bit = 0;
	unsigned char mode_bit = 0;
	unsigned char mode_mask = 0;
	unsigned int prop_mode = 0;
	unsigned int prop_lif = 0;

	if (si2151_devp->parm.mode == Si2151_TUNER_TUNE_FREQ_CMD_MODE_ATV) {
		inv_bit = 0x09;
		mode_bit = 0x00;
		mode_mask = 0x07;
		prop_mode = Si2151_ATV_VIDEO_MODE_PROP;
		prop_lif = Si2151_ATV_LIF_FREQ_PROP;
	} else {
		inv_bit = 0x08;
		mode_bit = 0x04;
		mode_mask = 0x0f;
		prop_mode = Si2151_DTV_MODE_PROP;
		prop_lif = Si2151_DTV_LIF_FREQ_PROP;
	}

	/* lif_inv */
	Si2151_L1_GetProperty(si2151_devp->api, prop_mode, &data);
	si2151_devp->if_inv = (data >> inv_bit) & 0x01;
	video_sys = (data >> mode_bit) & mode_mask;
	/* lif_freq */
	Si2151_L1_GetProperty(si2151_devp->api, prop_lif, &data);
	si2151_devp->if_freq = data * 1000;

	if (si2151_devp->if_inv == 0 || video_sys == Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_LP) {
		if (video_sys == Si2151_ATV_VIDEO_MODE_PROP_VIDEO_SYS_LP)
			frequency[0] = 1;
		else
			frequency[0] = 0;

		frequency[1] = si2151_devp->if_freq - si2151_devp->fre_offset;
	} else {
		frequency[0] = 1;
		frequency[1] = si2151_devp->if_freq + si2151_devp->fre_offset;
	}

	pr_dbg("[si2159] %s, if_inv: %d, if_freq: %d \n",
			__func__, frequency[0], frequency[1]);

	return 0;
}

static int si2159_get_status_ex(struct dvb_frontend *fe, u32 *status)
{
	if (!status) {
		pr_err("[si2159] %s: null pointer error.\n", __func__);
		return 0;
	}

	*status = FE_TIMEDOUT;

	return 0;
}

static int si2159_get_rf_strength_ex(struct dvb_frontend *fe, u16 *strength)
{
#if 0
	if (Si2151_L1_TUNER_STATUS(si2151_devp->api) != 0) {
		pr_err("[si2159] %s:get si2159 tuner status error!!!\n", __func__);
		return -1;
	} else
		*strength = si2151_devp->api->rsp->tuner_status.rssi - 256;

	pr_info("[si2159] %s: strength = %d dbm\n", __func__, *strength);
#else
	pr_info("[si2159] %s: please use get_strength.\n", __func__);
#endif

	return 0;
}

#ifdef CONFIG_AMLOGIC_DVB_COMPAT
static int si2159_get_strength_ex(struct dvb_frontend *fe, s16 *strength)
{
	if (Si2151_L1_TUNER_STATUS(si2151_devp->api) != 0) {
		pr_err("[si2159] %s:get si2159 tuner status error!!!\n", __func__);
		return -1;
	} else
		*strength = si2151_devp->api->rsp->tuner_status.rssi - 256;

	pr_dbg("[si2159] %s: strength = %d dbm\n", __func__, *strength);

	return 0;
}
#endif

static int si2159_get_afc_ex(struct dvb_frontend *fe, s32 *afc)
{
	return 0;
}

/*
 * This is support for demods like the mt352 - fills out the supplied
 * buffer with what to write.
 *
 * Don't use on newer drivers.
 */
static int si2159_calc_regs_ex(struct dvb_frontend *fe, u8 *buf, int buf_len)
{
	return 0;
}

/*
 * These are provided separately from set_params in order to
 * facilitate silicon tuners which require sophisticated tuning loops,
 * controlling each parameter separately.
 *
 * Don't use on newer drivers.
 */
static int si2159_set_frequency_ex(struct dvb_frontend *fe, u32 frequency)
{
	int ret = 0;

	/* if(si2159_debug) */
	pr_dbg("[%s]:now mode is %d(0-DTV,1-ATV)\n", __func__, si2151_devp->parm.mode);
	if (si2151_devp->parm.mode == Si2151_TUNER_TUNE_FREQ_CMD_MODE_ATV)
		ret = Si2151_Tune(si2151_devp->api, si2151_devp->parm.mode, frequency);
	else
		ret = Si2151_DTVTune(si2151_devp->api, frequency, si2151_devp->api->prop->dtv_mode.bw, si2151_devp->api->prop->dtv_mode.modulation, si2151_devp->api->prop->dtv_mode.invert_spectrum);

	if (ret && ret != ERROR_Si2151_xTVINT_TIMEOUT)
		pr_err("[si2159] %s: tune frequency error:%d.\n", __func__, ret);

	return 0;
}

static int si2159_set_bandwidth_ex(struct dvb_frontend *fe, u32 bandwidth)
{
	return 0;
}

static struct dvb_tuner_ops si2159_tuner_ops = {
	.info = {
		.name           = "si2159",
#if LINUX_VERSION_CODE >= KERNEL_VERSION(5, 4, 0)
		.frequency_min_hz  = Si2151_TUNER_TUNE_FREQ_CMD_FREQ_MIN,
		.frequency_max_hz  = Si2151_TUNER_TUNE_FREQ_CMD_FREQ_MAX,
		.frequency_step_hz = 0,
#else
		.frequency_min  = Si2151_TUNER_TUNE_FREQ_CMD_FREQ_MIN,
		.frequency_max  = Si2151_TUNER_TUNE_FREQ_CMD_FREQ_MAX,
		.frequency_step = 0,
#endif
		.bandwidth_min  = 6000000,
		.bandwidth_max  = 8000000,
		.bandwidth_step = 0,
	},
	.release = si2159_release_ex,
	.init = si2159_init_ex,
	.sleep = si2159_sleep_ex,
	.suspend = si2159_suspend_ex,
	.resume = si2159_resume_ex,
	.set_params = si2159_set_params_ex,
	.set_analog_params = si2159_set_analog_params_ex,
	.calc_regs = si2159_calc_regs_ex,
	.set_config = si2159_set_config_ex,
	.get_frequency = si2159_get_frequency_ex,
	.get_bandwidth = si2159_get_bandwidth_ex,
	.get_if_frequency = si2159_get_if_frequency_ex,
	.get_status = si2159_get_status_ex,
	.get_rf_strength = si2159_get_rf_strength_ex,
#ifdef CONFIG_AMLOGIC_DVB_COMPAT
	.get_strength = si2159_get_strength_ex,
#endif
	.get_afc = si2159_get_afc_ex,
	.set_frequency = si2159_set_frequency_ex,
	.set_bandwidth = si2159_set_bandwidth_ex,
};

struct dvb_frontend *si2159_attach(struct dvb_frontend *fe,
		struct tuner_config *cfg)
{
	if (!fe || !cfg || !cfg->i2c_adap) {
		pr_info("[si2159] %s NULL pointer of fe or i2c_adap.\n",
				__func__);
		return NULL;
	}

	fe->tuner_priv = si2151_devp;

	si2151_devp->tuner_client.adapter = cfg->i2c_adap;
	si2151_devp->tuner_client.addr = cfg->i2c_addr;

	si2151_devp->api->i2c = &(si2151_devp->api->i2cObj);
	si2151_devp->api->i2c->_i2c_client = &(si2151_devp->tuner_client);
	si2151_devp->api->cmdObj.power_up.clock_mode = Si2151_POWER_UP_CMD_CLOCK_MODE_XTAL;
	si2151_devp->api->cmdObj.power_up.en_xout = Si2151_POWER_UP_CMD_EN_XOUT_DIS_XOUT;
	Si2151_L1_API_Init(si2151_devp->api, cfg->i2c_addr);

	if (!sprintf(si2151_devp->tuner_client.name, "si2159_tuner_i2c"))
		pr_err("[si2159] %s: sprintf name error.\n", __func__);

	memcpy(&fe->ops.tuner_ops, &si2159_tuner_ops,
			sizeof(struct dvb_tuner_ops));

	pr_info("[si2159] %s done.\n", __func__);

	return fe;
}
EXPORT_SYMBOL(si2159_attach);
#endif /* LINUX_VERSION_CODE >= KERNEL_VERSION(4, 9, 0) */
