DESCRIPTION = "SOUNDTOUCH"
SECTION = "libs"
LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://COPYING.TXT;md5=4d2892adf339c4489918ab705d44f66c"

SRC_URI = " ${RDK_ARTIFACTS_BASE_URL}/sky_llama/prebuilts/sky-mic-test/soundtouch-2.2.tar.gz;name=soundtouch" 
SRC_URI[soundtouch.md5sum]    = "9ff2206827acdecd85eab47d2d53ee1a"
SRC_URI[soundtouch.sha256sum] = "b847e16f32faf8ffb2c801b862553d91c744549494ad42e7dc59c45c3184f09d"  

inherit autotools pkgconfig

# we had multiple recipes in the past
PROVIDES = "soundtouch"

EXTRA_OECONF = "--disable-fortran --enable-shared --enable-threads"

SOUNDTOUCH_NEON = "${@bb.utils.contains('TUNE_FEATURES', 'neon', '--enable-neon', '', d)}"
SOUNDTOUCH_NEON_class-native = ""

do_configure() {
	mkdir -p ${B}
    cp -r ${WORKDIR}/soundtouch-2.2/* ${B}
    cd ${B}
    # full (re)configure
	./bootstrap
    ./configure --prefix=${prefix} \
	            --libdir=${libdir} \
    		 	--host=${TARGET_ARCH}
}

do_compile() {
    cd ${B}
    oe_runmake
}

PACKAGES =+ "libsoundtouch"
FILES_libsoundtouch-staticdev = "${libdir}/libSoundTouch.a"

RDEPENDS_${PN}-dev = ""

