/*
 * sound/soc/amlogic/auge/audio_aed_reg_list.h
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#ifndef __AML_AUDIO_AED_REG_H_
#define __AML_AUDIO_AED_REG_H_

#include "regs.h"

static const struct register_table aed_register_table[] = {
{"AED_COEF_RAM_CNTL           ",     0x00},
{"AED_COEF_RAM_DATA           ",     0x01},
{"AED_EQ_EN                   ",     0x02},
{"AED_EQ_TAP_CNTL             ",     0x03},
{"AED_EQ_VOLUME               ",     0x04},
{"AED_EQ_VOLUME_SLEW_CNT      ",     0x05},
{"AED_MUTE                    ",     0x06},
{"AED_DRC_CNTL                ",     0x07},
{"AED_DRC_RMS_COEF0           ",     0x08},
{"AED_DRC_RMS_COEF1           ",     0x09},
{"AED_DRC_THD0                ",     0x0a},
{"AED_DRC_THD1                ",     0x0b},
{"AED_DRC_THD2                ",     0x0c},
{"AED_DRC_THD3                ",     0x0d},
{"AED_DRC_THD4                ",     0x0e},
{"AED_DRC_K0                  ",     0x0f},
{"AED_DRC_K1                  ",     0x10},
{"AED_DRC_K2                  ",     0x11},
{"AED_DRC_K3                  ",     0x12},
{"AED_DRC_K4                  ",     0x13},
{"AED_DRC_K5                  ",     0x14},
{"AED_DRC_THD_OUT0            ",     0x15},
{"AED_DRC_THD_OUT1            ",     0x16},
{"AED_DRC_THD_OUT2            ",     0x17},
{"AED_DRC_THD_OUT3            ",     0x18},
{"AED_DRC_OFFSET              ",     0x19},
{"AED_DRC_RELEASE_COEF00      ",     0x1a},
{"AED_DRC_RELEASE_COEF01      ",     0x1b},
{"AED_DRC_RELEASE_COEF10      ",     0x1c},
{"AED_DRC_RELEASE_COEF11      ",     0x1d},
{"AED_DRC_RELEASE_COEF20      ",     0x1e},
{"AED_DRC_RELEASE_COEF21      ",     0x1f},
{"AED_DRC_RELEASE_COEF30      ",     0x20},
{"AED_DRC_RELEASE_COEF31      ",     0x21},
{"AED_DRC_RELEASE_COEF40      ",     0x22},
{"AED_DRC_RELEASE_COEF41      ",     0x23},
{"AED_DRC_RELEASE_COEF50      ",     0x24},
{"AED_DRC_RELEASE_COEF51      ",     0x25},
{"AED_DRC_ATTACK_COEF00       ",     0x26},
{"AED_DRC_ATTACK_COEF01       ",     0x27},
{"AED_DRC_ATTACK_COEF10       ",     0x28},
{"AED_DRC_ATTACK_COEF11       ",     0x29},
{"AED_DRC_ATTACK_COEF20       ",     0x2a},
{"AED_DRC_ATTACK_COEF21       ",     0x2b},
{"AED_DRC_ATTACK_COEF30       ",     0x2c},
{"AED_DRC_ATTACK_COEF31       ",     0x2d},
{"AED_DRC_ATTACK_COEF40       ",     0x2e},
{"AED_DRC_ATTACK_COEF41       ",     0x2f},
{"AED_DRC_ATTACK_COEF50       ",     0x30},
{"AED_DRC_ATTACK_COEF51       ",     0x31},
{"AED_DRC_LOOPBACK_CNTL       ",     0x32},
{"AED_MDRC_CNTL               ",     0x33},
{"AED_MDRC_RMS_COEF00         ",     0x34},
{"AED_MDRC_RMS_COEF01         ",     0x35},
{"AED_MDRC_RELEASE_COEF00     ",     0x36},
{"AED_MDRC_RELEASE_COEF01     ",     0x37},
{"AED_MDRC_ATTACK_COEF00      ",     0x38},
{"AED_MDRC_ATTACK_COEF01      ",     0x39},
{"AED_MDRC_THD0               ",     0x3a},
{"AED_MDRC_K0                 ",     0x3b},
{"AED_MDRC_LOW_GAIN           ",     0x3c},
{"AED_MDRC_OFFSET0            ",     0x3d},
{"AED_MDRC_RMS_COEF10         ",     0x3e},
{"AED_MDRC_RMS_COEF11         ",     0x3f},
{"AED_MDRC_RELEASE_COEF10     ",     0x40},
{"AED_MDRC_RELEASE_COEF11     ",     0x41},
{"AED_MDRC_ATTACK_COEF10      ",     0x42},
{"AED_MDRC_ATTACK_COEF11      ",     0x43},
{"AED_MDRC_THD1               ",     0x44},
{"AED_MDRC_K1                 ",     0x45},
{"AED_MDRC_OFFSET1            ",     0x46},
{"AED_MDRC_MID_GAIN           ",     0x47},
{"AED_MDRC_RMS_COEF20         ",     0x48},
{"AED_MDRC_RMS_COEF21         ",     0x49},
{"AED_MDRC_RELEASE_COEF20     ",     0x4a},
{"AED_MDRC_RELEASE_COEF21     ",     0x4b},
{"AED_MDRC_ATTACK_COEF20      ",     0x4c},
{"AED_MDRC_ATTACK_COEF21      ",     0x4d},
{"AED_MDRC_THD2               ",     0x4e},
{"AED_MDRC_K2                 ",     0x4f},
{"AED_MDRC_OFFSET2            ",     0x50},
{"AED_MDRC_HIGH_GAIN          ",     0x51},
{"AED_ED_CNTL                 ",     0x52},
{"AED_DC_EN                   ",     0x53},
{"AED_ND_LOW_THD              ",     0x54},
{"AED_ND_HIGH_THD             ",     0x55},
{"AED_ND_CNT_THD              ",     0x56},
{"AED_ND_SUM_NUM              ",     0x57},
{"AED_ND_CZ_NUM               ",     0x58},
{"AED_ND_SUM_THD0             ",     0x59},
{"AED_ND_SUM_THD1             ",     0x5a},
{"AED_ND_CZ_THD0              ",     0x5b},
{"AED_ND_CZ_THD1              ",     0x5c},
{"AED_ND_COND_CNTL            ",     0x5d},
{"AED_ND_RELEASE_COEF0        ",     0x5e},
{"AED_ND_RELEASE_COEF1        ",     0x5f},
{"AED_ND_ATTACK_COEF0         ",     0x60},
{"AED_ND_ATTACK_COEF1         ",     0x61},
{"AED_ND_CNTL                 ",     0x62},
{"AED_MIX0_LL                 ",     0x63},
{"AED_MIX0_RL                 ",     0x64},
{"AED_MIX0_LR                 ",     0x65},
{"AED_MIX0_RR                 ",     0x66},
{"AED_CLIP_THD                ",     0x67},
{"AED_CH1_ND_SUM_OUT          ",     0x68},
{"AED_CH2_ND_SUM_OUT          ",     0x69},
{"AED_CH1_ND_CZ_OUT           ",     0x6a},
{"AED_CH2_ND_CZ_OUT           ",     0x6b},
{"AED_NOISE_STATUS            ",     0x6c},
{"AED_POW_CURRENT_S0          ",     0x6d},
{"AED_POW_CURRENT_S1          ",     0x6e},
{"AED_POW_CURRENT_S2          ",     0x6f},
{"AED_POW_OUT0                ",     0x70},
{"AED_POW_OUT1                ",     0x71},
{"AED_POW_OUT2                ",     0x72},
{"AED_POW_ADJ_INDEX0          ",     0x73},
{"AED_POW_ADJ_INDEX1          ",     0x74},
{"AED_POW_ADJ_INDEX2          ",     0x75},
{"AED_DRC_GAIN_INDEX0         ",     0x76},
{"AED_DRC_GAIN_INDEX1         ",     0x77},
{"AED_DRC_GAIN_INDEX2         ",     0x78},
{"AED_CH1_VOLUME_STATE        ",     0x79},
{"AED_CH2_VOLUME_STATE        ",     0x7a},
{"AED_CH1_VOLUME_GAIN         ",     0x7b},
{"AED_CH2_VOLUME_GAIN         ",     0x7c},
{"AED_FULL_POW_CURRENT        ",     0x7d},
{"AED_FULL_POW_OUT            ",     0x7e},
{"AED_FULL_POW_ADJ            ",     0x7f},
{"AED_FULL_DRC_GAIN           ",     0x80},
{"AED_MASTER_VOLUME_STATE     ",     0x81},
{"AED_MASTER_VOLUME_GAIN      ",     0x82},
{"AED_TOP_CTL                 ",     0x83},
{"AED_TOP_REQ_CTL             ",     0x84},
};

#endif
