/*
 * drivers/amlogic/media/vin/tvin/tvin_format_table.c
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#include <linux/module.h>

#include "tvin_global.h"
#include "tvin_format_table.h"

const char *tvin_sig_fmt_str(enum tvin_sig_fmt_e fmt)
{
	switch (fmt) {
	case TVIN_SIG_FMT_NULL:
		return "TVIN_SIG_FMT_NULL";
		/* HDMI Formats */
	case TVIN_SIG_FMT_HDMI_640X480P_60HZ:
		return "TVIN_SIG_FMT_HDMI_640x480P_60Hz";
	case TVIN_SIG_FMT_HDMI_640X480P_72HZ:
		return "TVIN_SIG_FMT_HDMI_640x480P_72Hz";
	case TVIN_SIG_FMT_HDMI_640X480P_75HZ:
		return "TVIN_SIG_FMT_HDMI_720x480P_75Hz";
	case TVIN_SIG_FMT_HDMI_720X480P_60HZ:
		return "TVIN_SIG_FMT_HDMI_720x480P_60Hz";
	case TVIN_SIG_FMT_HDMI_1280X720P_60HZ:
		return "TVIN_SIG_FMT_HDMI_1280x720P_60Hz";
	case TVIN_SIG_FMT_HDMI_1920X1080I_60HZ:
		return "TVIN_SIG_FMT_HDMI_1920x1080I_60Hz";
	case TVIN_SIG_FMT_HDMI_1440X480I_60HZ:
		return "TVIN_SIG_FMT_HDMI_1440x480I_60Hz";
	case TVIN_SIG_FMT_HDMI_1440X240P_60HZ:
		return "TVIN_SIG_FMT_HDMI_1440x240P_60Hz";
	case TVIN_SIG_FMT_HDMI_2880X480I_60HZ:
		return "TVIN_SIG_FMT_HDMI_2880x480I_60Hz";
	case TVIN_SIG_FMT_HDMI_2880X240P_60HZ:
		return "TVIN_SIG_FMT_HDMI_2880x240P_60Hz";
	case TVIN_SIG_FMT_HDMI_1440X480P_60HZ:
		return "TVIN_SIG_FMT_HDMI_1440x480P_60Hz";
	case TVIN_SIG_FMT_HDMI_1920X1080P_60HZ:
		return "TVIN_SIG_FMT_HDMI_1920x1080P_60Hz";
	case TVIN_SIG_FMT_HDMI_720X576P_50HZ:
		return "TVIN_SIG_FMT_HDMI_720x576P_50Hz";
	case TVIN_SIG_FMT_HDMI_1280X720P_50HZ:
		return "TVIN_SIG_FMT_HDMI_1280x720P_50Hz";
	case TVIN_SIG_FMT_HDMI_1920X1080I_50HZ_A:
		return "TVIN_SIG_FMT_HDMI_1920x1080I_50Hz_A";
	case TVIN_SIG_FMT_HDMI_1440X576I_50HZ:
		return "TVIN_SIG_FMT_HDMI_1440x576I_50Hz";
	case TVIN_SIG_FMT_HDMI_1440X288P_50HZ:
		return "TVIN_SIG_FMT_HDMI_1440x288P_50Hz";
	case TVIN_SIG_FMT_HDMI_2880X576I_50HZ:
		return "TVIN_SIG_FMT_HDMI_2880x576I_50Hz";
	case TVIN_SIG_FMT_HDMI_2880X288P_50HZ:
		return "TVIN_SIG_FMT_HDMI_2880x288P_50Hz";
	case TVIN_SIG_FMT_HDMI_1440X576P_50HZ:
		return "TVIN_SIG_FMT_HDMI_1440x576P_50Hz";
	case TVIN_SIG_FMT_HDMI_1920X1080P_50HZ:
		return "TVIN_SIG_FMT_HDMI_1920x1080P_50Hz";
	case TVIN_SIG_FMT_HDMI_1920X1080P_24HZ:
		return "TVIN_SIG_FMT_HDMI_1920x1080P_24Hz";
	case TVIN_SIG_FMT_HDMI_1920X1080P_25HZ:
		return "TVIN_SIG_FMT_HDMI_1920x1080P_25Hz";
	case TVIN_SIG_FMT_HDMI_1920X1080P_30HZ:
		return "TVIN_SIG_FMT_HDMI_1920x1080P_30Hz";
	case TVIN_SIG_FMT_HDMI_2880X480P_60HZ:
		return "TVIN_SIG_FMT_HDMI_2880x480P_60Hz";
	case TVIN_SIG_FMT_HDMI_2880X576P_50HZ:
		return "TVIN_SIG_FMT_HDMI_2880x576P_50Hz";
	case TVIN_SIG_FMT_HDMI_1920X1080I_50HZ_B:
		return "TVIN_SIG_FMT_HDMI_1920x1080I_50Hz_B";
	case TVIN_SIG_FMT_HDMI_1920X1080I_100HZ:
		return "TVIN_SIG_FMT_HDMI_1920x1080I_100Hz";
	case TVIN_SIG_FMT_HDMI_1280X720P_100HZ:
		return "TVIN_SIG_FMT_HDMI_1280x720P_100Hz";
	case TVIN_SIG_FMT_HDMI_720X576P_100HZ:
		return "TVIN_SIG_FMT_HDMI_720x576P_100Hz";
	case TVIN_SIG_FMT_HDMI_1440X576I_100HZ:
		return "TVIN_SIG_FMT_HDMI_1440x576I_100Hz";
	case TVIN_SIG_FMT_HDMI_1920X1080I_120HZ:
		return "TVIN_SIG_FMT_HDMI_1920x1080I_120Hz";
	case TVIN_SIG_FMT_HDMI_1280X720P_120HZ:
		return "TVIN_SIG_FMT_HDMI_1280x720P_120Hz";
	case TVIN_SIG_FMT_HDMI_720X480P_120HZ:
		return "TVIN_SIG_FMT_HDMI_720x480P_120Hz";
	case TVIN_SIG_FMT_HDMI_1440X480I_120HZ:
		return "TVIN_SIG_FMT_HDMI_1440x480I_120Hz";
	case TVIN_SIG_FMT_HDMI_720X576P_200HZ:
		return "TVIN_SIG_FMT_HDMI_720x576P_200Hz";
	case TVIN_SIG_FMT_HDMI_1440X576I_200HZ:
		return "TVIN_SIG_FMT_HDMI_1440x576I_200Hz";
	case TVIN_SIG_FMT_HDMI_720X480P_240HZ:
		return "TVIN_SIG_FMT_HDMI_720x480P_240Hz";
	case TVIN_SIG_FMT_HDMI_1440X480I_240HZ:
		return "TVIN_SIG_FMT_HDMI_1440x480I_240Hz";
	case TVIN_SIG_FMT_HDMI_1280X720P_24HZ:
		return "TVIN_SIG_FMT_HDMI_1280x720P_24Hz";
	case TVIN_SIG_FMT_HDMI_1280X720P_25HZ:
		return "TVIN_SIG_FMT_HDMI_1280x720P_25Hz";
	case TVIN_SIG_FMT_HDMI_1280X720P_30HZ:
		return "TVIN_SIG_FMT_HDMI_1280x720P_30Hz";
	case TVIN_SIG_FMT_HDMI_1920X1080P_120HZ:
		return "TVIN_SIG_FMT_HDMI_1920x1080P_120Hz";
	case TVIN_SIG_FMT_HDMI_1920X1080P_100HZ:
		return "TVIN_SIG_FMT_HDMI_1920x1080P_100Hz";
	case TVIN_SIG_FMT_HDMI_1280X720P_60HZ_FRAME_PACKING:
		return "TVIN_SIG_FMT_HDMI_1280x720P_60Hz_FRAME_PACKING";
	case TVIN_SIG_FMT_HDMI_1280X720P_50HZ_FRAME_PACKING:
		return "TVIN_SIG_FMT_HDMI_1280x720P_50Hz_FRAME_PACKING";
	case TVIN_SIG_FMT_HDMI_1280X720P_24HZ_FRAME_PACKING:
		return "TVIN_SIG_FMT_HDMI_1280x720P_24Hz_FRAME_PACKING";
	case TVIN_SIG_FMT_HDMI_1280X720P_30HZ_FRAME_PACKING:
		return "TVIN_SIG_FMT_HDMI_1280x720P_30Hz_FRAME_PACKING";
	case TVIN_SIG_FMT_HDMI_1920X1080I_60HZ_FRAME_PACKING:
		return "TVIN_SIG_FMT_HDMI_1920x1080I_60Hz_FRAME_PACKING";
	case TVIN_SIG_FMT_HDMI_1920X1080I_50HZ_FRAME_PACKING:
		return "TVIN_SIG_FMT_HDMI_1920x1080I_50Hz_FRAME_PACKING";
	case TVIN_SIG_FMT_HDMI_1920X1080P_24HZ_FRAME_PACKING:
		return "TVIN_SIG_FMT_HDMI_1920x1080P_24Hz_FRAME_PACKING";
	case TVIN_SIG_FMT_HDMI_1920X1080P_30HZ_FRAME_PACKING:
		return "TVIN_SIG_FMT_HDMI_1920x1080P_30Hz_FRAME_PACKING";
	case TVIN_SIG_FMT_HDMI_800X600_00HZ:
		return "TVIN_SIG_FMT_HDMI_800x600";
	case TVIN_SIG_FMT_HDMI_1024X768_00HZ:
		return "TVIN_SIG_FMT_HDMI_1024x768";
	case TVIN_SIG_FMT_HDMI_720X400_00HZ:
		return "TVIN_SIG_FMT_HDMI_720_400";
	case TVIN_SIG_FMT_HDMI_1280X768_00HZ:
		return "TVIN_SIG_FMT_HDMI_1280_768";
	case TVIN_SIG_FMT_HDMI_1280X800_00HZ:
		return "TVIN_SIG_FMT_HDMI_1280_800";
	case TVIN_SIG_FMT_HDMI_1280X960_00HZ:
		return "TVIN_SIG_FMT_HDMI_1280_960";
	case TVIN_SIG_FMT_HDMI_1280X1024_00HZ:
		return "TVIN_SIG_FMT_HDMI_1280_1024";
	case TVIN_SIG_FMT_HDMI_1360X768_00HZ:
		return "TVIN_SIG_FMT_HDMI_1360_768";
	case TVIN_SIG_FMT_HDMI_1366X768_00HZ:
		return "TVIN_SIG_FMT_HDMI_1366_768";
	case TVIN_SIG_FMT_HDMI_1600X1200_00HZ:
		return "TVIN_SIG_FMT_HDMI_1600_1200";
	case TVIN_SIG_FMT_HDMI_1920X1200_00HZ:
		return "TVIN_SIG_FMT_HDMI_1920_1200";
	case TVIN_SIG_FMT_HDMI_1440X900_00HZ:
		return "TVIN_SIG_FMT_HDMI_1440X900_00HZ";
	case TVIN_SIG_FMT_HDMI_1400X1050_00HZ:
		return "TVIN_SIG_FMT_HDMI_1400X1050_00HZ";
	case TVIN_SIG_FMT_HDMI_1680X1050_00HZ:
		return "TVIN_SIG_FMT_HDMI_1680X1050_00HZ";
	case TVIN_SIG_FMT_HDMI_1152X864_00HZ:
		return "TVIN_SIG_FMT_HDMI_1152X864_00HZ";
		/* for alternative and 4k2k */
	case TVIN_SIG_FMT_HDMI_1920X1080I_60HZ_ALTERNATIVE:
		return "TVIN_SIG_FMT_HDMI_1920X1080I_60HZ_ALTERNATIVE";
	case TVIN_SIG_FMT_HDMI_1920X1080I_50HZ_ALTERNATIVE:
		return "TVIN_SIG_FMT_HDMI_1920X1080I_50HZ_ALTERNATIVE";
	case TVIN_SIG_FMT_HDMI_1920X1080P_24HZ_ALTERNATIVE:
		return "TVIN_SIG_FMT_HDMI_1920X1080P_24HZ_ALTERNATIVE";
	case TVIN_SIG_FMT_HDMI_1920X1080P_30HZ_ALTERNATIVE:
		return "TVIN_SIG_FMT_HDMI_1920X1080P_30HZ_ALTERNATIVE";
	case TVIN_SIG_FMT_HDMI_3840_2160_00HZ:
		return "TVIN_SIG_FMT_HDMI_3840_2160_00HZ";
	case TVIN_SIG_FMT_HDMI_4096_2160_00HZ:
		return "TVIN_SIG_FMT_HDMI_4096_2160_00HZ";
	case TVIN_SIG_FMT_HDMI_1600X900_60HZ:
		return "TVIN_SIG_FMT_HDMI_1600X900_60HZ";
	case TVIN_SIG_FMT_HDMI_3840X600_00HZ:
		return "TVIN_SIG_FMT_HDMI_3840X600_00HZ";
	case TVIN_SIG_FMT_HDMI_RESERVE8:
		return "TVIN_SIG_FMT_HDMI_RESERVE8";
	case TVIN_SIG_FMT_HDMI_RESERVE9:
		return "TVIN_SIG_FMT_HDMI_RESERVE9";
	case TVIN_SIG_FMT_HDMI_RESERVE10:
		return "TVIN_SIG_FMT_HDMI_RESERVE10";
	case TVIN_SIG_FMT_HDMI_RESERVE11:
		return "TVIN_SIG_FMT_HDMI_RESERVE11";
	case TVIN_SIG_FMT_HDMI_720X480P_60HZ_FRAME_PACKING:
		return "TVIN_SIG_FMT_HDMI_720x480P_60Hz_FRAME_PACKING";
	case TVIN_SIG_FMT_HDMI_720X576P_50HZ_FRAME_PACKING:
		return "TVIN_SIG_FMT_HDMI_720x576P_50Hz_FRAME_PACKING";
	case TVIN_SIG_FMT_HDMI_2560X1440_00HZ:
		return "TVIN_SIG_FMT_HDMI_2560X1440_00HZ";
	case TVIN_SIG_FMT_HDMI_MAX:
		return "TVIN_SIG_FMT_HDMI_MAX";
		/* Video Formats */
	case TVIN_SIG_FMT_CVBS_NTSC_M:
		return "TVIN_SIG_FMT_CVBS_NTSC_M";
	case TVIN_SIG_FMT_CVBS_NTSC_443:
		return "TVIN_SIG_FMT_CVBS_NTSC_443";
	case TVIN_SIG_FMT_CVBS_PAL_I:
		return "TVIN_SIG_FMT_CVBS_PAL_I";
	case TVIN_SIG_FMT_CVBS_PAL_M:
		return "TVIN_SIG_FMT_CVBS_PAL_M";
	case TVIN_SIG_FMT_CVBS_PAL_60:
		return "TVIN_SIG_FMT_CVBS_PAL_60";
	case TVIN_SIG_FMT_CVBS_PAL_CN:
		return "TVIN_SIG_FMT_CVBS_PAL_CN";
	case TVIN_SIG_FMT_CVBS_SECAM:
		return "TVIN_SIG_FMT_CVBS_SECAM";
	case TVIN_SIG_FMT_CVBS_NTSC_50:
		return "TVIN_SIG_FMT_CVBS_NTSC_50";
		/* 656 Formats */
	case TVIN_SIG_FMT_BT656IN_576I_50HZ:
		return "TVIN_SIG_FMT_BT656IN_576I";
	case TVIN_SIG_FMT_BT656IN_480I_60HZ:
		return "TVIN_SIG_FMT_BT656IN_480I";
		/* 601 Formats */
	case TVIN_SIG_FMT_BT601IN_576I_50HZ:
		return "TVIN_SIG_FMT_BT601IN_576I";
	case TVIN_SIG_FMT_BT601IN_480I_60HZ:
		return "TVIN_SIG_FMT_BT601IN_480I";
		/* Camera Formats */
	case TVIN_SIG_FMT_CAMERA_640X480P_30HZ:
		return "TVIN_SIG_FMT_CAMERA_640X480P_30Hz";
	case TVIN_SIG_FMT_CAMERA_800X600P_30HZ:
		return "TVIN_SIG_FMT_CAMERA_800X600P_30Hz";
	case TVIN_SIG_FMT_CAMERA_1024X768P_30HZ:
		return "TVIN_SIG_FMT_CAMERA_1024X768P_30Hz";
	case TVIN_SIG_FMT_CAMERA_1920X1080P_30HZ:
		return "TVIN_SIG_FMT_CAMERA_1920X1080P_30Hz";
	case TVIN_SIG_FMT_CAMERA_1280X720P_30HZ:
		return "TVIN_SIG_FMT_CAMERA_1280X720P_30Hz";
	case TVIN_SIG_FMT_MAX:
		return "TVIN_SIG_FMT_MAX";
	default:
		return "TVIN_SIG_FMT_NULL";
	}
}
EXPORT_SYMBOL(tvin_sig_fmt_str);


const struct tvin_format_s *tvin_get_fmt_info(enum tvin_sig_fmt_e fmt)
{
	/* find  format table through format */
	if ((fmt < TVIN_SIG_FMT_HDMI_MAX) &&
			(fmt >= TVIN_SIG_FMT_HDMI_640X480P_60HZ))
		return &tvin_hdmi_fmt_tbl[fmt-TVIN_SIG_FMT_HDMI_640X480P_60HZ];
	else if ((fmt < TVIN_SIG_FMT_CVBS_MAX) &&
			(fmt > TVIN_SIG_FMT_HDMI_THRESHOLD))
		return &tvin_cvbs_fmt_tbl[fmt-TVIN_SIG_FMT_CVBS_NTSC_M];
	else if ((fmt < TVIN_SIG_FMT_BT601_MAX) &&
			(fmt > TVIN_SIG_FMT_CVBS_THRESHOLD))
		return &tvin_bt601_fmt_tbl[fmt-TVIN_SIG_FMT_BT656IN_576I_50HZ];
	else
		return NULL;
}
EXPORT_SYMBOL(tvin_get_fmt_info);

const struct tvin_format_s tvin_hdmi_fmt_tbl[TVIN_SIG_FMT_HDMI_MAX -
	TVIN_SIG_FMT_HDMI_640X480P_60HZ + 1] = {
	/* H_Active V_Active H_cnt Hcnt_offset Vcnt_offset Hs_cnt Hscnt_offset
	 * H_Total V_Total Hs_Front Hs_Width Hs_bp Vs_Front Vs_Width
	 * Vs_bp Hs_Polarity  Vs_Polarity
	 * Scan_Mode Pixel_Clk(Khz/10) VBIs VBIe duration
	 */
	{/* TVIN_SIG_FMT_HDMI_640x480P_60Hz, */
	640,  480, 0, 10, 10, 0, 10,
	800,  525,  16,  96,  48, 10, 2,
	33, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  2518,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_720x480P_60Hz, */
	720,  480, 0, 10, 10, 0, 10,
	858,  525,  16,  62,  60,  9, 6,
	30, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  2700,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_1280x720P_60Hz, */
	1280,  720, 0, 10, 10, 0, 10,
	1650,  750, 110,  40, 220,  5, 5,
	20, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  7425,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_1920x1080I_60Hz, */
	1920,  540, 0, 10, 10, 0, 10,
	2200,  563,  88,  44, 148,  2, 5,
	16, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_INTERLACED,  7425,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_1440x480I_60Hz, */
	1440,  240, 0, 10, 10, 0, 10,
	1716,  263,  38, 124, 114,  4, 3,
	16, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  2700,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_1440x240P_60Hz, */
	1440,  240, 0, 10, 10, 0, 10,
	1716,  262,  38, 124, 114,  4, 3,
	15, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  2700,   0,   0, 1600
	},
	{ /* TVIN_SIG_FMT_HDMI_2880x480I_60Hz, */
	2880,  240, 0, 10, 10, 0, 10,
	3432,  263,  76, 248, 228,  4, 3,
	16, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  5400,   0,   0, 1600
	},
	{ /* TVIN_SIG_FMT_HDMI_2880x240P_60Hz, */
	2880,  240, 0, 10, 10, 0, 10,
	3432,  262,  76, 248, 228,  4, 3,
	15, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  5400,   0,   0, 1590
	},
	{ /* TVIN_SIG_FMT_HDMI_1440x480P_60Hz, */
	1440,  480, 0, 10, 10, 0, 10,
	1716,  525,  32, 124, 120,  9, 6,
	30, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  5400,   0,   0, 1600
	},
	{ /* TVIN_SIG_FMT_HDMI_1920x1080P_60Hz, */
	1920, 1080, 0, 10, 10, 0, 10,
	2200, 1125,  88,  44, 148,  4, 5,
	36, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 14850,   0,   0, 1600
	},
	{ /* TVIN_SIG_FMT_HDMI_720x576P_50Hz, //160 */
	720,  576, 0, 10, 10, 0, 10,
	864,  625,  12,  64,  68,  5, 5,
	39, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  2700,   0,   0, 1920
	},
	{/* TVIN_SIG_FMT_HDMI_1280x720P_50Hz, */
	1280,  720, 0, 10, 10, 0, 10,
	1980,  750, 440,  40, 220,  5, 5,
	20, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  7425,   0,   0, 1920
	},
	{/* TVIN_SIG_FMT_HDMI_1920x1080I_50Hz_A, */
	1920,  540, 0, 10, 10, 0, 10,
	2640,  563, 528,  44, 148,  2, 5,
	16, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_INTERLACED,  7425,   0,   0, 1920
	},
	{/* TVIN_SIG_FMT_HDMI_1440x576I_50Hz, */
	1440,  288, 0, 10, 10, 0, 10,
	1728,  313,  24, 126, 138,  2, 3,
	20, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  2700,   0,   0, 1920
	},
	{/* TVIN_SIG_FMT_HDMI_1440x288P_50Hz, */
	1440,  288, 0, 10, 10, 0, 10,
	1728,  312,  24, 126, 138,  2, 3,
	19, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  2700,   0,   0, 1920
	},
	{/* TVIN_SIG_FMT_HDMI_2880x576I_50Hz, */
	2880,  288, 0, 10, 10, 0, 10,
	3456,  313,  48, 252, 276,  2, 3,
	20, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  5400,   0,   0, 1920
	},
	{/* TVIN_SIG_FMT_HDMI_2880x288P_50Hz, */
	2880,  288, 0, 10, 10, 0, 10,
	3456,  312,  48, 252, 276,  2, 3,
	19, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  5400,   0,   0, 1920
	},
	{ /* TVIN_SIG_FMT_HDMI_1440x576P_50Hz, */
	1440,  576, 0, 10, 10, 0, 10,
	1728,  625,  24, 128, 136,  5, 5,
	39, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  5400,   0,   0, 1920
	},
	{/* TVIN_SIG_FMT_HDMI_1920x1080P_50Hz, */
	1920, 1080, 0, 10, 10, 0, 10,
	2640, 1125, 528,  44, 148,  4, 5,
	36, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 14850,   0,   0, 1920
	},
	{ /* TVIN_SIG_FMT_HDMI_1920x1080P_24Hz, */
	1920, 1080, 0, 10, 10, 0, 10,
	2750, 1125, 638,  44, 148,  4, 5,
	36, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  7425,   0,   0, 4000
	},
	{/* TVIN_SIG_FMT_HDMI_1920x1080P_25Hz,//170 */
	1920, 1080, 0, 10, 10, 0, 10,
	2640, 1125, 528,  44, 148,  4, 5,
	36, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  7425,   0,   0, 3840
	},
	{/* TVIN_SIG_FMT_HDMI_1920x1080P_30Hz, */
	1920, 1080, 0, 10, 10, 0, 10,
	2200, 1125,  88,  44, 148,  4, 5,
	36, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  7425,   0,   0, 3200
	},
	{/* TVIN_SIG_FMT_HDMI_2880x480P_60Hz, */
	2880,  480, 0, 10, 10, 0, 10,
	3432,  525,  64, 248, 240,  9, 6,
	30, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 10800,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_2880x576P_50Hz, */
	2880,  576, 0, 10, 10, 0, 10,
	3456,  625,  48, 256, 272,  5, 5,
	39, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 10800,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_1920x1080I_50Hz_B, */
	1920,  540, 0, 10, 10, 0, 10,
	2304,  625,  32, 168, 184, 23, 5,
	57, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  7200,   0,   0, 1920
	},
	{/* TVIN_SIG_FMT_HDMI_1920x1080I_100Hz, */
	1920,  540, 0, 10, 10, 0, 10,
	2640,  563, 528,  44, 148,  2, 5,
	16, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_INTERLACED, 14850,   0,   0, 960
	},
	{/* TVIN_SIG_FMT_HDMI_1280x720P_100Hz, */
	1280,  720, 0, 10, 10, 0, 10,
	1980,  750, 440,  40, 220,  5, 5,
	20, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 14850,   0,   0, 960
	},
	{ /* TVIN_SIG_FMT_HDMI_720x576P_100Hz, */
	720,  576, 0, 10, 10, 0, 10,
	864,  625,  12,  64,  68,  5, 5,
	39, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  5400,   0,   0, 960
	},
	{ /* TVIN_SIG_FMT_HDMI_1440x576I_100Hz, */
	1440,  288, 0, 10, 10, 0, 10,
	1728,  313,  24,  12, 252,  2, 3,
	20, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  5400,   0,   0, 960
	},
	{/* TVIN_SIG_FMT_HDMI_1920x1080I_120Hz, */
	1920,  540, 0, 10, 10, 0, 10,
	2200,  563,  88,  44, 148,  2, 5,
	16, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_INTERLACED, 14850,   0,   0, 800
	},
	{/* TVIN_SIG_FMT_HDMI_1280x720P_120Hz,//180 */
	1280,  720, 0, 10, 10, 0, 10,
	1650,  750,  110, 40, 220,  5, 5,
	20, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 14850,   0,   0, 800
	},
	{/* TVIN_SIG_FMT_HDMI_720x480P_120Hz, */
	720,  480, 0, 10, 10, 0, 10,
	858,  525,   16, 62,  60,  9, 6,
	30, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  5400,   0,   0, 800
	},
	{/* TVIN_SIG_FMT_HDMI_1440x480I_120Hz, */
	1440,  240, 0, 10, 10, 0, 10,
	1716,  263,   38, 12, 226,  4, 3,
	16, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  5400,   0,   0, 800
	},
	{ /* TVIN_SIG_FMT_HDMI_720x576P_200Hz, */
	720,  576, 0, 10, 10, 0, 10,
	864,  625,   13, 64,  67,  5, 5,
	39, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 10800,   0,   0, 480
	},
	{ /* TVIN_SIG_FMT_HDMI_1440x576I_200Hz, */
	1440,  288, 0, 10, 10, 0, 10,
	1728,  313,   24, 12, 252,  2, 3,
	20, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED, 10800,   0,   0, 480
	},
	{/* TVIN_SIG_FMT_HDMI_720x480P_240Hz, */
	720,  480, 0, 10, 10, 0, 10,
	858,  525,   16, 62,  60,  9, 6,
	30, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 10800,   0,   0, 400
	},
	{ /* TVIN_SIG_FMT_HDMI_1440x480I_240Hz, */
	1440,  240, 0, 10, 10, 0, 10,
	1716,  263,   38, 12, 226,  4, 3,
	16, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED, 10800,   0,   0, 400
	},
	{/* TVIN_SIG_FMT_HDMI_1280x720P_24Hz, */
	1280,  720, 0, 10, 10, 0, 10,
	3300,  750, 1760, 40, 220,  5, 5,
	20, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  5940,   0,   0, 4000
	},
	{ /* TVIN_SIG_FMT_HDMI_1280x720P_25Hz, */
	1280,  720, 0, 10, 10, 0, 10,
	3960,  750, 2420, 40, 220,  5, 5,
	20, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  7425,   0,   0, 3840
	},
	{/* TVIN_SIG_FMT_HDMI_1280x720P_30Hz, */
	1280,  720, 0, 10, 10, 0, 10,
	3300,  750, 1760, 40, 220,  5, 5,
	20, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  7425,   0,   0, 3200
	},
	{/* TVIN_SIG_FMT_HDMI_1920x1080P_120Hz,//190 */
	1920, 1080, 0, 10, 10, 0, 10,
	2200, 1125,   88, 44, 148,  4, 5,
	36, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 29700,   0,   0, 800
	},
	{/* TVIN_SIG_FMT_HDMI_1920x1080P_100Hz, */
	1920, 1080, 0, 10, 10, 0, 10,
	2640, 1125,  528, 44, 148,  4, 5,
	36, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 29700,   0,   0, 960
	},
	{/* TVIN_SIG_FMT_HDMI_1280x720P_60Hz_FRAME_PACKING, */
	1280, 1470, 0, 10, 10, 0, 10,
	1650, 1500,  110, 40, 220,  5, 5,
	20, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 14850,   0,   0, 1600
	},
	{ /* TVIN_SIG_FMT_HDMI_1280x720P_50Hz_FRAME_PACKING, */
	1280, 1470, 0, 10, 10, 0, 10,
	1980, 1500,  440, 40, 220,  5, 5,
	20, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 14850,   0,   0, 1920
	},
	{/* TVIN_SIG_FMT_HDMI_1280x720P_24Hz_FRAME_PACKING, */
	1280, 1470, 0, 10, 10, 0, 10,
	3300, 1500, 1760, 40, 220,  5, 5,
	20, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 11880,   0,   0, 4000
	},
	{/* TVIN_SIG_FMT_HDMI_1280x720P_30Hz_FRAME_PACKING, */
	1280, 1470, 0, 10, 10, 0, 10,
	3300, 1500, 1760, 40, 220,  5, 5,
	20, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 14850,   0,   0, 3200
	},
	{ /* TVIN_SIG_FMT_HDMI_1920x1080I_60Hz_FRAME_PACKING, */
	1920, 2228, 0, 10, 10, 0, 10,
	2200, 2250,   88, 44, 148,  2, 5,
	16, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_INTERLACED, 14850,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_1920x1080I_50Hz_FRAME_PACKING, */
	1920, 2228, 0, 10, 10, 0, 10,
	2640, 2250,  528, 44, 148,  2, 5,
	16, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_INTERLACED, 14850,   0,   0, 1920
	},
	{/* TVIN_SIG_FMT_HDMI_1920x1080P_24Hz_FRAME_PACKING, */
	1920, 2205, 0, 10, 10, 0, 10,
	2750, 2250,  638, 44, 148,  4, 5,
	36, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 14850,   0,   0, 4000
	},
	{ /* TVIN_SIG_FMT_HDMI_1920x1080P_30Hz_FRAME_PACKING, */
	1920, 2205, 0, 10, 10, 0, 10,
	2200, 2250,   88, 44, 148,  4, 5,
	36, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 14850,   0,   0, 3200
	},
	{ /* 800x600_60HZ, //200 */
	800,  600, 0, 10, 10, 0, 10,
	1056,  627,  40, 128,  88, 1, 3,
	23, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  4000,   0,   0, 1600
	},
	{/* 1024x768_60HZ, */
	1024,  768, 0, 10, 10, 0, 0,
	1344,  806,  24, 136, 160, 3, 6,
	29, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  6500,	 0,   0, 1600
	},
	{ /* TVIN_SIG_FMT_HDMI_720_400, */
	720,   400, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0,   1600
	},
	{ /* TVIN_SIG_FMT_HDMI_1280_768, */
	1280,  768, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0,  1600
	},
	{/* TVIN_SIG_FMT_HDMI_1280_800, */
	1280,  800, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0,  1600
	},
	{/* TVIN_SIG_FMT_HDMI_1280_960, */
	1280,  960, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0,  1600
	},
	{ /* TVIN_SIG_FMT_HDMI_1280_1024, */
	1280, 1024, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_1360_768, */
	1360,  768, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0,  1600
	},
	{/* TVIN_SIG_FMT_HDMI_1366_768, */
	1366,  768, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0,  1600
	},
	{ /* TVIN_SIG_FMT_HDMI_1600_1200, */
	1600, 1200, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0, 1600
	},
	{ /* TVIN_SIG_FMT_HDMI_1920_1200, //210 */
	1920, 1200, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0, 1600
	},
	{ /* TVIN_SIG_FMT_HDMI_1440_900, */
	1440,  900, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0, 1600
	},
	{ /* TVIN_SIG_FMT_HDMI_1400_1050, */
	1400, 1050, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_1680X1050_60HZ */
	1680, 1050, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_1920X1080I_60HZ_ALTERNATIVE, */
	1920, 1103, 0,  0, 0,  0, 0,
	2200, 2250,  88,  44, 148, 2, 5,
	16, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_INTERLACED,  14850,   0,   0, 4000
	},
	{/* TVIN_SIG_FMT_HDMI_1920X1080I_50HZ_ALTERNATIVE, */
	1920, 1103, 0,  0, 0,  0, 0,
	2640, 2250, 528,  44, 148, 2, 5,
	16, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_INTERLACED,  14850,   0,   0, 4000
	},
	{/* TVIN_SIG_FMT_HDMI_1920X1080P_24HZ_ALTERNATIVE, */
	1920, 2160, 0,  0, 0,  0, 0,
	2750, 2250, 638,  44, 148, 4, 5,
	36, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  14850,   0,   0, 3840
	},
	{ /* TVIN_SIG_FMT_HDMI_1920X1080P_30HZ_ALTERNATIVE, */
	1920, 2160, 0,  0, 0,  0, 0,
	2200, 2250,  88,  44, 148, 4, 5,
	36, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  14850,   0,   0, 3840
	},
	{/* TVIN_SIG_FMT_HDMI_3840_2160_00HZ, */
	3840, 2160, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  29700,   0,   0, 3200
	},
	{/* TVIN_SIG_FMT_HDMI_4096_2160_00HZ, */
	4096, 2160, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  29700,   0,   0, 4000
	},
	{ /* TVIN_SIG_FMT_HDMI_1600X900_60HZ, */
	1600, 900, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_RESERVE8, */
	0,    0, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0, 1600
	},
	{ /* TVIN_SIG_FMT_HDMI_RESERVE9, */
	0,    0, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_RESERVE10, */
	0,    0, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_RESERVE11, */
	0,    0, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0, 1600
	},
	{ /* TVIN_SIG_FMT_HDMI_720x480P_60Hz_FRAME_PACKING, */
	720, 1005, 0, 10, 10,  0, 10,
	858, 1050,  16,  62,  60, 9, 6,
	30, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  5400,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_720x576P_50Hz_FRAME_PACKING, */
	720, 1201, 0, 10, 10,  0, 10,
	864, 1250,  12,  64,  68, 5, 5,
	39, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  5400,   0,   0, 1920
	},
	{/* TVIN_SIG_FMT_HDMI_640x480P_72Hz, */
	640,  480, 0, 10, 10, 0, 10,
	800,  525,  16,  96,  48, 10, 2,
	33, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  3000,   0,   0, 1333
	},
	{/* TVIN_SIG_FMT_HDMI_640x480P_75Hz, */
	640,  480, 0, 10, 10, 0, 10,
	800,  525,  16,  96,  48, 10, 2,
	33, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  3125,   0,   0, 1066
	},
	{/* TVIN_SIG_FMT_HDMI_1152X864_00HZ, */
	1152,  864, 0, 10, 10, 0, 10,
	1600,  900,  64,  128,  256, 1, 3,
	32, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE,  10800,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_1152X864_00HZ, */
	3840,  2160, 0, 0, 0, 0, 0,
	0,  0,  0,  0,  0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_2560X1440_00HZ, */
	2560,  1440, 0, 0, 0, 0, 0,
	0,  0,  0,  0,  0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_PROGRESSIVE,  0,   0,   0, 1600
	},
	{/* TVIN_SIG_FMT_HDMI_MAX,//227 */
	0,    0, 0,  0, 0,  0, 0,
	0,    0,   0,   0,   0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_NULL,     0,   0,   0,   1600
	},
};
EXPORT_SYMBOL(tvin_hdmi_fmt_tbl);

const struct tvin_format_s tvin_cvbs_fmt_tbl[TVIN_SIG_FMT_CVBS_MAX -
	TVIN_SIG_FMT_CVBS_NTSC_M + 1] = {
	/* H_Active V_Active H_cnt Hcnt_offset Vcnt_offset Hs_cnt Hscnt_offset
	* H_Total V_Total Hs_Front Hs_Width Hs_bp Vs_Front Vs_Width
	* Vs_bp Hs_Polarity  Vs_Polarity
	* Scan_Mode Pixel_Clk(Khz/10) VBIs VBIe duration
	*/

	{	/* TVIN_SIG_FMT_CVBS_NTSC_M, */
	720, 240, 0, 0, 0, 0, 0,
	858, 263, 16, 62, 0, 4, 3,
	0, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  1350,   0,   0, 1600
	},
	{	/* TVIN_SIG_FMT_CVBS_NTSC_443, */
	720, 240, 0, 0, 0, 0, 0,
	858, 263, 16, 62, 0, 4, 3,
	0, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  1350,   0,   0, 1600
	},
	{	/* TVIN_SIG_FMT_CVBS_PAL_I, */
	720, 288, 0, 0, 0, 0, 0,
	864, 313, 20, 62, 0, 3, 3,
	0, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  1350,   0,   0, 1920
	},
	{	/* TVIN_SIG_FMT_CVBS_PAL_M, */
	720, 240, 0, 0, 0, 0, 0,
	858, 263, 20, 62, 0, 4, 3,
	0, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  1350,   0,   0, 1600
	},
	{	/* TVIN_SIG_FMT_CVBS_PAL_60, */
	720, 240, 0, 0, 0, 0, 0,
	858, 263, 16, 62, 0, 4, 3,
	0, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  1350,   0,   0, 1600
	},
	{	/* TVIN_SIG_FMT_CVBS_PAL_CN, */
	720, 288, 0, 0, 0, 0, 0,
	864, 313, 12, 62, 0, 3, 3,
	0, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  1350,   0,   0, 1920
	},
	{	/* TVIN_SIG_FMT_CVBS_SECAM, */
	720, 288, 0, 0, 0, 0, 0,
	864, 313, 12, 62, 0, 3, 3,
	0, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  1350,   0,   0, 1920
	},
	{	/* TVIN_SIG_FMT_CVBS_NTSC_50, */
	720, 288, 0, 0, 0, 0, 0,
	864, 313, 20, 62, 0, 3, 3,
	0, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  1350,   0,   0, 1920
	},
	{	/* TVIN_SIG_FMT_CVBS_MAX, */
	0, 0, 0, 0, 0,  0, 0,
	0, 0, 0, 0,  0,  0, 0,
	0,  TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_NULL,     0,   0,   0,  0
	},
};
EXPORT_SYMBOL(tvin_cvbs_fmt_tbl);

const struct tvin_format_s tvin_bt601_fmt_tbl[TVIN_SIG_FMT_BT601_MAX -
	TVIN_SIG_FMT_BT656IN_576I_50HZ + 1] =  {
	/* H_Active V_Active H_cnt Hcnt_offset Vcnt_offset Hs_cnt Hscnt_offset
	 * H_Total V_Total Hs_Front Hs_Width Hs_bp Vs_Front Vs_Width
	 * Vs_bp Hs_Polarity  Vs_Polarity
	 * Scan_Mode Pixel_Clk(Khz/10) VBIs VBIe duration
	 */

	{	/* TVIN_SIG_FMT_BT656IN_576I, */
	720, 288, 6400, 20, 10, 0, 10,
	864, 625, 12,   64,  0, 5,  5,
	0, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED, 1350, 0, 0, 1920
	},
	{	/* TVIN_SIG_FMT_BT656IN_480I, // 160 */
	720, 240, 6356, 20, 10, 0, 10,
	858, 525,   16, 62,  0, 9,  6,
	0, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED, 1350, 0, 0, 1600
	},
	{	/* TVIN_SIG_FMT_BT601IN_576I, */
	720, 288, 6400, 20, 10, 0, 10,
	864, 625,   12, 64,  0, 5,  5,
	0, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  1350,   0,   0, 1920
	},
	{	 /* TVIN_SIG_FMT_BT601IN_480I, */
	720, 240, 6356, 20, 10, 0, 10,
	858, 525,   16, 62,  0, 9,  6,
	0, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_INTERLACED,  1350,   0,   0, 1600
	},
	{	/* TVIN_SIG_FMT_CAMERA_640X480P_30HZ, */
	640, 480, 6356, 20, 10, 473, 10,
	780, 525,   18, 58, 64,   4,  3,
	16, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 1227, 0, 0, 3200
	},
	{	 /* TVIN_SIG_FMT_CAMERA_800X600P_30HZ, */
	800, 600,  0,  20, 10, 0, 10,
	1056, 628, 40, 128,  0, 1,  4,
	0, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 4000, 0, 0, 3200
	},
	{	/* TVIN_SIG_FMT_CAMERA_1024X768P_30HZ, */
	1024, 768,  0,  10, 10, 0, 10,
	1344, 795, 64, 128,  0, 3,  3,
	0, TVIN_SYNC_POL_NEGATIVE, TVIN_SYNC_POL_NEGATIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 6411, 0, 0, 3200
	},
	{
	1920, 1080,   0,  10, 10, 0, 10,
	2576, 1118, 120, 208,  0, 1,  3,
	0, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 17280, 0, 0, 3200
	},
	{
	1280, 720,   0,  10, 10, 0, 10,
	1650, 750, 120, 208,  0, 1,  3,
	0, TVIN_SYNC_POL_POSITIVE, TVIN_SYNC_POL_POSITIVE,
	TVIN_SCAN_MODE_PROGRESSIVE, 17280, 0, 0, 3200
	},
	/* format max */
	{
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, TVIN_SYNC_POL_NULL, TVIN_SYNC_POL_NULL,
	TVIN_SCAN_MODE_NULL, 0, 0, 0, 0
	},
};
EXPORT_SYMBOL(tvin_bt601_fmt_tbl);

#define r_0a 0x00
#define r_0e 0x00
#define r_12 0x00
#define r_16 0x00
#define r_1c 0x00
#define r_1d 0x00
#define r_22 0x00
#define r_23 0x00
#define r_25 0x00
#define r_29 0x00
#define r_2c 0x00
#define r_2d 0x00
#define r_36 0x00
#define r_37 0x00
#define r_40 0x00
#define r_42 0x00
#define r_44 0x00
#define r_45 0x00
#define r_48 0x00
#define r_49 0x00
#define r_4a 0x00
#define r_4b 0x00
#define r_4c 0x00
#define r_4d 0x00
#define r_4e 0x00
#define r_4f 0x00
#define r_50 0x00
#define r_51 0x00
#define r_52 0x00
#define r_53 0x00
#define r_54 0x00
#define r_55 0x00
#define r_57 0x00
#define r_67 0x00
#define r_6a 0x00
#define r_6b 0x00
#define r_6c 0x00
#define r_6d 0x00
#define r_6e 0x00
#define r_6f 0x00

const unsigned char adc_cvbs_table[ADC_REG_NUM] = {
	/*0x40*/
	0x00, 0x6b, 0xf0, 0x08, 0x14, 0x30, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10,
	0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x40, 0x23, 0x03, 0x83, 0x22, 0x10,
	0x00, 0x80, 0x30, 0x00, 0x00, 0x00, 0x69, 0x88, 0x30, 0x07, 0xc0, 0x00,
	0x05, 0x00, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x40, 0x28,
	0x20, 0x20, 0x08, 0x0f, 0x25, 0x02, 0x10, 0x00, 0x00, 0xc0, 0xe3, 0x5c,
	0x54, 0x81, 0x01, 0x08, 0x70, 0x07, 0x75, 0xf8, 0xf0, 0xf0, 0x51, 0x5a,
	0x00, 0x00, 0x85, 0x01, 0x00, 0x30, 0x00, 0x00, 0x18, 0x15, 0x03, 0x00,
	0xe0, 0x00, 0x10, 0x00, 0x09, 0x07, 0x02, 0x22, 0x8e, 0x6f, 0x0f, 0x09,
	0xf4, 0x00, 0x0f, 0x19, 0x00, 0x00, 0x10, 0x00, 0x0b, 0x39, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00
};
EXPORT_SYMBOL(adc_cvbs_table);

#define r180 (unsigned char)((CVD2_CHROMA_DTO_NTSC_M >> 24)&0x000000ff)
#define r190 (unsigned char)((CVD2_CHROMA_DTO_NTSC_M >> 16)&0x000000ff)
#define r1a0 (unsigned char)((CVD2_CHROMA_DTO_NTSC_M  >> 8)&0x000000ff)
#define r1b0 (unsigned char)((CVD2_CHROMA_DTO_NTSC_M  >> 0)&0x000000ff)
#define r1c0 (unsigned char)((CVD2_HSYNC_DTO_NTSC_M >> 24)&0x000000ff)
#define r1d0 (unsigned char)((CVD2_HSYNC_DTO_NTSC_M >> 16)&0x000000ff)
#define r1e0 (unsigned char)((CVD2_HSYNC_DTO_NTSC_M  >> 8)&0x000000ff)
#define r1f0 (unsigned char)((CVD2_HSYNC_DTO_NTSC_M  >> 0)&0x000000ff)

#define r181 (unsigned char)((CVD2_CHROMA_DTO_NTSC_443>>24)&0x000000ff)
#define r191 (unsigned char)((CVD2_CHROMA_DTO_NTSC_443>>16)&0x000000ff)
#define r1a1 (unsigned char)((CVD2_CHROMA_DTO_NTSC_443 >> 8)&0x000000ff)
#define r1b1 (unsigned char)((CVD2_CHROMA_DTO_NTSC_443 >> 0)&0x000000ff)
#define r1c1 (unsigned char)((CVD2_HSYNC_DTO_NTSC_443>>24)&0x000000ff)
#define r1d1 (unsigned char)((CVD2_HSYNC_DTO_NTSC_443>>16)&0x000000ff)
#define r1e1 (unsigned char)((CVD2_HSYNC_DTO_NTSC_443 >> 8)&0x000000ff)
#define r1f1 (unsigned char)((CVD2_HSYNC_DTO_NTSC_443 >> 0)&0x000000ff)

#define r182 (unsigned char)((CVD2_CHROMA_DTO_PAL_I >> 24)&0x000000ff)
#define r192 (unsigned char)((CVD2_CHROMA_DTO_PAL_I >> 16)&0x000000ff)
#define r1a2 (unsigned char)((CVD2_CHROMA_DTO_PAL_I   >> 8)&0x000000ff)
#define r1b2 (unsigned char)((CVD2_CHROMA_DTO_PAL_I   >> 0)&0x000000ff)
#define r1c2 (unsigned char)((CVD2_HSYNC_DTO_PAL_I >> 24)&0x000000ff)
#define r1d2 (unsigned char)((CVD2_HSYNC_DTO_PAL_I >> 16)&0x000000ff)
#define r1e2 (unsigned char)((CVD2_HSYNC_DTO_PAL_I   >> 8)&0x000000ff)
#define r1f2 (unsigned char)((CVD2_HSYNC_DTO_PAL_I   >> 0)&0x000000ff)

#define r183 (unsigned char)((CVD2_CHROMA_DTO_PAL_M >> 24)&0x000000ff)
#define r193 (unsigned char)((CVD2_CHROMA_DTO_PAL_M >> 16)&0x000000ff)
#define r1a3 (unsigned char)((CVD2_CHROMA_DTO_PAL_M   >> 8)&0x000000ff)
#define r1b3 (unsigned char)((CVD2_CHROMA_DTO_PAL_M   >> 0)&0x000000ff)
#define r1c3 (unsigned char)((CVD2_HSYNC_DTO_PAL_M >> 24)&0x000000ff)
#define r1d3 (unsigned char)((CVD2_HSYNC_DTO_PAL_M >> 16)&0x000000ff)
#define r1e3 (unsigned char)((CVD2_HSYNC_DTO_PAL_M   >> 8)&0x000000ff)
#define r1f3 (unsigned char)((CVD2_HSYNC_DTO_PAL_M   >> 0)&0x000000ff)

#define r184 (unsigned char)((CVD2_CHROMA_DTO_PAL_60 >> 24)&0x000000ff)
#define r194 (unsigned char)((CVD2_CHROMA_DTO_PAL_60 >> 16)&0x000000ff)
#define r1a4 (unsigned char)((CVD2_CHROMA_DTO_PAL_60  >> 8)&0x000000ff)
#define r1b4 (unsigned char)((CVD2_CHROMA_DTO_PAL_60  >> 0)&0x000000ff)
#define r1c4 (unsigned char)((CVD2_HSYNC_DTO_PAL_60 >> 24)&0x000000ff)
#define r1d4 (unsigned char)((CVD2_HSYNC_DTO_PAL_60 >> 16)&0x000000ff)
#define r1e4 (unsigned char)((CVD2_HSYNC_DTO_PAL_60  >> 8)&0x000000ff)
#define r1f4 (unsigned char)((CVD2_HSYNC_DTO_PAL_60  >> 0)&0x000000ff)

#define r185 (unsigned char)((CVD2_CHROMA_DTO_PAL_CN >> 24)&0x000000ff)
#define r195 (unsigned char)((CVD2_CHROMA_DTO_PAL_CN >> 16)&0x000000ff)
#define r1a5 (unsigned char)((CVD2_CHROMA_DTO_PAL_CN  >> 8)&0x000000ff)
#define r1b5 (unsigned char)((CVD2_CHROMA_DTO_PAL_CN  >> 0)&0x000000ff)
#define r1c5 (unsigned char)((CVD2_HSYNC_DTO_PAL_CN >> 24)&0x000000ff)
#define r1d5 (unsigned char)((CVD2_HSYNC_DTO_PAL_CN >> 16)&0x000000ff)
#define r1e5 (unsigned char)((CVD2_HSYNC_DTO_PAL_CN  >> 8)&0x000000ff)
#define r1f5 (unsigned char)((CVD2_HSYNC_DTO_PAL_CN  >> 0)&0x000000ff)

#define r186 (unsigned char)((CVD2_CHROMA_DTO_SECAM >> 24)&0x000000ff)
#define r196 (unsigned char)((CVD2_CHROMA_DTO_SECAM >> 16)&0x000000ff)
#define r1a6 (unsigned char)((CVD2_CHROMA_DTO_SECAM   >> 8)&0x000000ff)
#define r1b6 (unsigned char)((CVD2_CHROMA_DTO_SECAM   >> 0)&0x000000ff)
#define r1c6 (unsigned char)((CVD2_HSYNC_DTO_SECAM >> 24)&0x000000ff)
#define r1d6 (unsigned char)((CVD2_HSYNC_DTO_SECAM >> 16)&0x000000ff)
#define r1e6 (unsigned char)((CVD2_HSYNC_DTO_SECAM   >> 8)&0x000000ff)
#define r1f6 (unsigned char)((CVD2_HSYNC_DTO_SECAM   >> 0)&0x000000ff)

/* 00~3f */
const unsigned char cvd_part1_table[TVIN_SIG_FMT_CVBS_NTSC_50 -
	TVIN_SIG_FMT_CVBS_NTSC_M + 1][CVD_PART1_REG_NUM] = {
	{
	0x00, 0x08, 0x43, 0x10, 0xdd, 0x32, 0x80, 0x4e, 0x7b, 0x1c, 0x78,
	0x00, 0x90, 0x00, 0x06, 0x00, 0x0a, 0x09, 0x10, 0xb4, 0x80, 0x20,
	0xf6, 0x0d, r180, r190, r1a0, r1b0, r1c0, r1d0, r1e0, r1f0,	0x3e,
	0x3e, 0x00, 0x80, 0xf3, 0x3e, 0x6d, 0x5a, 0x07, 0x29, 0xd6, 0x4e,
	0x32, 0x46, 0x82, 0x50,	0x22, 0x61, 0x70, 0x0e, 0x78, 0x10, 0x00,
	0x23, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
	}, /* TVIN_SIG_FMT_CVBS_NTSC_M, */
	{
	0x00, 0x01, 0x43, 0x82, 0xdd, 0x32, 0x80, 0x40, 0x7e, 0x20, 0x80,
	0x00, 0x8a, 0x00, 0x06, 0x00, 0x37, 0x09, 0x10, 0xb4, 0x80, 0x20,
	0xf6, 0x0d, r181, r191, r1a1, r1b1, r1c1, r1d1, r1e1, r1f1,	0x3e,
	0x3e, 0x00, 0x80, 0xf3, 0x3e, 0x6d, 0x5a, 0x07, 0x29, 0xd6, 0x4e,
	0x32, 0x46, 0x7a, 0x50,	0x22, 0x61, 0x70, 0x0e, 0x78, 0x10, 0x00,
	0x23, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
	}, /* TVIN_SIG_FMT_CVBS_NTSC_443, */
	{
	0x32, 0x04, 0x43, 0x12, 0xdd, 0x32, 0x80, 0x03, 0x7d, 0x20, 0x78,
	0x00, 0x90, 0x00, 0x06, 0x00, 0x08, 0x09, 0x10, 0xb4, 0x80, 0x20,
	0xf6, 0x0d, r182, r192, r1a2, r1b2, r1c2, r1d2, r1e2, r1f2,	0x3e,
	0x3e, 0x00, 0x80, 0xe7, 0x42, 0x6d, 0x5a, 0x1d, 0xb9, 0xd6, 0x4e,
	0x32, 0x46, 0x8c, 0x50,	0x2a, 0xc0, 0x70, 0x0e, 0x78, 0x10, 0x00,
	0x23, 0x01, 0x0a, 0x2e, 0x00, 0x0d, 0x00, 0x00, 0x01
	}, /* TVIN_SIG_FMT_CVBS_PAL_I, */
	{
	0x04, 0x0, 0x43, 0x12, 0xdd, 0xff, 0x80, 0x00, 0x7d, 0x20, 0x80,
	0x00, 0x8a, 0x00, 0x20, 0x00, 0x37, 0x09, 0x10, 0xb4, 0x80, 0x20,
	0xf6, 0x0d, r183, r193, r1a3, r1b3, r1c3, r1d3, r1e3, r1f3,	0x3e,
	0x3e, 0x00, 0x80, 0xf3, 0x3e, 0x6d, 0x5a, 0x07, 0x29, 0xd6, 0x4e,
	0x32, 0x46, 0x82, 0x50,	0x22, 0x61, 0x70, 0x0e, 0x78, 0x10, 0x00,
	0x23, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
	}, /* TVIN_SIG_FMT_CVBS_PAL_M, */
	{
	0x04, 0x00, 0x43, 0x02, 0xdd, 0x32, 0x80, 0x00, 0x80, 0x20, 0x80,
	0x00, 0x67, 0x01, 0x06, 0x00, 0x37, 0x09, 0x10, 0xb4, 0x80, 0x20,
	0xf6, 0x0b, r184, r194, r1a4, r1b4, r1c4, r1d4, r1e4, r1f4,	0x3e,
	0x3e, 0x00, 0x80, 0xf3, 0x3e, 0x6d, 0x5a, 0x07, 0x29, 0xd6, 0x4e,
	0x32, 0x46, 0x84, 0x50,	0x2a, 0x61, 0x70, 0x0e, 0x78, 0x10, 0x00,
	0x23, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
	}, /* TVIN_SIG_FMT_CVBS_PAL_60, */
	{
	0x36, 0x0, 0x43, 0x12, 0xdd, 0x32, 0x80, 0x00, 0x7d, 0x31, 0x80,
	0x00, 0x8a, 0x00, 0x06, 0x00, 0x37, 0x09, 0x10, 0xb4, 0x80, 0x20,
	0xf6, 0x0d, r185, r195, r1a5, r1b5, r1c5, r1d5, r1e5, r1f5,	0x3e,
	0x3e, 0x00, 0x80, 0xf3, 0x3e, 0x6d, 0x5a, 0x07, 0x29, 0xd6, 0x4e,
	0x32, 0x46, 0x8a, 0x50,	0x2a, 0xc1, 0x70, 0x0e, 0x78, 0x10, 0x00,
	0x23, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
	}, /* TVIN_SIG_FMT_CVBS_PAL_CN, */
	{
	0x38, 0x00, 0x43, 0x00, 0xdc, 0x32, 0x80, 0x00, 0x80, 0x20, 0x80,
	0x00, 0xc8, 0x00, 0x06, 0x00, 0x37, 0x09, 0x10, 0xb4, 0x80, 0x20,
	0xf6, 0x0d, r186, r196, r1a6, r1b6, r1c6, r1d6, r1e6, r1f6,	0x3e,
	0x3e, 0x00, 0x80, 0xf3, 0x3e, 0x6d, 0x5a, 0x07, 0x29, 0xd6, 0x4e,
	0x3c, 0x6e, 0x76, 0x58,	0x29, 0xbf, 0x70, 0x0e, 0x78, 0x10, 0x00,
	0x23, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
	}, /* TVIN_SIG_FMT_CVBS_SECAM, */
	{
	0x32, 0x04, 0x43, 0x12, 0xdd, 0x32, 0x80, 0x03, 0x7d, 0x20, 0x78,
	0x00, 0x90, 0x00, 0x06, 0x00, 0x37, 0x09, 0x10, 0xb4, 0x80, 0x20,
	0xf6, 0x0d, r182, r192, r1a2, r1b2, r1c2, r1d2, r1e2, r1f2,	0x3e,
	0x3e, 0x00, 0x80, 0xe7, 0x42, 0x6d, 0x5a, 0x1d, 0xb9, 0xd6, 0x4e,
	0x32, 0x46, 0x8c, 0x50,	0x2a, 0xc0, 0x70, 0x0e, 0x78, 0x10, 0x00,
	0x23, 0x01, 0x0a, 0x2e, 0x00, 0x0d, 0x00, 0x00, 0x01
	}, /* TVIN_SIG_FMT_CVBS_NTSC_50, */
};
EXPORT_SYMBOL(cvd_part1_table);

#define r_81 0x00
#define r_89 0x00
#define r_8c 0x00
#define r_97 0x00
#define r_98 0x00
#define r_99 0x00
#define r_9a 0x00
#define r_9b 0x00
#define r_9c 0x00
#define r_9d 0x00
#define r_9e 0x00
#define r_9f 0x00
#define r_ad 0x00
#define r_b9 0x00
#define r_bf 0x00
#define r_c1 (unsigned char)(CVD2_DCRESTORE_ACCUM)
#define r_cf 0x00
#define r_dd 0x00
#define r_df 0x00
#define r_ef 0x00
#define r_f5 0x00
#define r_f6 0x00
#define r_f7 0x00
#define r_f8 0x00
#define r_ff 0x00
/* 70~ff */
const unsigned char cvd_part2_table[TVIN_SIG_FMT_CVBS_NTSC_50 -
	TVIN_SIG_FMT_CVBS_NTSC_M + 1][CVD_PART2_REG_NUM] = {
	{
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, r_81, 0x42, 0x6f, 0x03, 0x00,
	0x00, 0x00, 0x00, r_89, 0x0a, 0x11, r_8c, 0x0a, 0x00, 0xe2,	0x00,
	0x00, 0x01, 0x08, 0x08, 0x00, 0x00, r_97, r_98, r_99, r_9a, r_9b,
	r_9c, r_9d, r_9e, r_9f,	0xf2, 0x0b, 0x00, 0x00, 0x08, 0x08, 0x00,
	0x00, 0x00, 0x00, 0x16, 0x0f, 0xc1, r_ad, 0xcf, 0x0f, 0x30, 0x2d,
	0x04, 0x03, 0x23, 0xa2, 0x02, 0x00, 0x00, r_b9, 0x24, 0x5f, 0x00,
	0x25, 0x55, r_bf, 0x14, r_c1, 0x40, 0xc0, 0xfe, 0x90, 0x00, 0xf0,
	0x01, 0x50, 0x60, 0x90, 0xe3, 0x0c, 0x23, r_cf,	0xc0, 0x08, 0x10,
	0x10, 0x0a, 0x00, 0x0d, 0x00, 0x00, 0x05, 0x00, 0x05, 0x50, r_dd,
	0x08, r_df,	0x00, 0x00, 0x00, 0x00, 0x6e, 0x50, 0x00, 0x00, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, r_ef, 0x20, 0x40, 0x32, 0x46,
	0xe4, r_f5, r_f6, r_f7, r_f8, 0x01, 0x00, 0x32, 0x50, 0x1c, 0x00,
	r_ff
	}, /* TVIN_SIG_FMT_CVBS_NTSC_M, */
	{
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, r_81, 0x42, 0x6f, 0x03, 0x00,
	0x00, 0x00, 0x00, r_89, 0x0a, 0x11, r_8c, 0x0a, 0x00, 0xe2,	0x00,
	0x00, 0x01, 0x00, 0x08, 0x00, 0x00, r_97, r_98, r_99, r_9a, r_9b,
	r_9c, r_9d, r_9e, r_9f,	0xf2, 0x0b, 0x00, 0x00, 0x08, 0x08, 0x00,
	0x00, 0x00, 0x00, 0x16, 0x0f, 0xc1, r_ad, 0xcf, 0x8c, 0x3a, 0xf3,
	0x8,  0x03, 0x24, 0xa2, 0x02, 0x00, 0x00, r_b9, 0x24, 0x5f, 0x00,
	0x25, 0x55, r_bf, 0x17, r_c1, 0x40, 0xc0, 0xfe, 0x90, 0x00, 0x00,
	0x01, 0x50, 0x62, 0x90, 0xe3, 0x0c, 0x23, r_cf,	0xc0, 0x08, 0x10,
	0x10, 0x0a, 0x00, 0x0d, 0x00, 0x00, 0x05, 0x00, 0x05, 0x50, r_dd,
	0x08, r_df,	0x00, 0x00, 0x00, 0x00, 0x6e, 0x40, 0x00, 0x00, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, r_ef, 0x20, 0x40, 0x32, 0x46,
	0xe4, r_f5, r_f6, r_f7, r_f8, 0x01, 0x00, 0x32, 0x50, 0x1c, 0x00,
	r_ff
	}, /* TVIN_SIG_FMT_CVBS_NTSC_443, */
	{
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7f, 0x42, 0x6f, 0x03, 0x00,
	0x04, 0x00, 0x00, r_89, 0x0a, 0x11, r_8c, 0x0a, 0x00, 0xe2,	0x00,
	0x00, 0x1f, 0x00, 0x08, 0x00, 0x00, r_97, r_98, r_99, r_9a, r_9b,
	r_9c, r_9d, r_9e, r_9f,	0xf2, 0x0b, 0x00, 0x00, 0x08, 0x08, 0x00,
	0x00, 0x00, 0x00, 0x16, 0x0f, 0xc1, r_ad, 0xcf, 0x86, 0xfa, 0x2f,
	0x0c, 0x03, 0x23, 0xa2, 0x02, 0x00, 0x08, r_b9, 0x24, 0x5f, 0x00,
	0x25, 0x55, r_bf, 0x14, r_c1, 0x40, 0xc0, 0xfe, 0x90, 0x00, 0xf0,
	0x01, 0x50, 0x62, 0x90, 0xe3, 0x2c, 0x23, r_cf,	0xc0, 0x08, 0x10,
	0x10, 0x0a, 0x00, 0x0d, 0x00, 0x00, 0x05, 0x00, 0x05, 0x40, r_dd,
	0x08, r_df,	0x00, 0x01, 0xc2, 0x88, 0x6e, 0x50, 0x00, 0x00, 0x30,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, r_ef, 0x20, 0x1f, 0x32, 0x46,
	0xe4, r_f5, r_f6, r_f7, r_f8, 0x01, 0x80, 0x32, 0x50, 0x1c, 0x00,
	r_ff
	}, /* TVIN_SIG_FMT_CVBS_PAL_I, */
	{
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, r_81, 0x42, 0x6f, 0x03, 0x00,
	0x00, 0x00, 0x00, r_89, 0x0a, 0x11, r_8c, 0x0a, 0x00, 0xe2,	0x00,
	0x00, 0x01, 0x00, 0x08, 0x00, 0x00, r_97, r_98, r_99, r_9a, r_9b,
	r_9c, r_9d, r_9e, r_9f,	0xf2, 0x0b, 0x00, 0x00, 0x08, 0x08, 0x00,
	0x00, 0x00, 0x00, 0x16, 0x0f, 0xc1, r_ad, 0xcf, 0x8c, 0x3a, 0xf3,
	0x0c, 0x03, 0x23, 0xa2, 0x02, 0x00, 0x00, r_b9, 0x24, 0x5f, 0x00,
	0x25, 0x55, r_bf, 0x14, r_c1, 0x40, 0xc0, 0xfe, 0x90, 0x00, 0x00,
	0x01, 0x50, 0x62, 0x90, 0xe3, 0x2c, 0x23, r_cf,	0xc0, 0x08, 0x10,
	0x10, 0x0a, 0x00, 0x0d, 0x00, 0x00, 0x05, 0x00, 0x05, 0x50, r_dd,
	0x08, r_df,	0x00, 0x00, 0x00, 0x00, 0x6e, 0x50, 0x8c, 0x00, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, r_ef, 0x20, 0x1f, 0x32, 0x46,
	0xe4, r_f5, r_f6, r_f7, r_f8, 0x01, 0x00, 0x32, 0x50, 0x1c, 0x00,
	r_ff
	}, /* TVIN_SIG_FMT_CVBS_PAL_M, */
	{
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, r_81, 0x42, 0x6f, 0x03, 0x00,
	0x00, 0x00, 0x00, r_89, 0x0a, 0x11, r_8c, 0x0a, 0x00, 0xe2,	0x00,
	0x00, 0x01, 0x00, 0x08, 0x00, 0x00, r_97, r_98, r_99, r_9a, r_9b,
	r_9c, r_9d, r_9e, r_9f,	0xf2, 0x0b, 0x00, 0x00, 0x08, 0x08, 0x00,
	0x00, 0x00, 0x00, 0x16, 0x0f, 0xc1, r_ad, 0xcf, 0x8c, 0xe0, 0x2f,
	0x0c, 0x0b, 0x24, 0xa2, 0x02, 0x00, 0x00, r_b9, 0x24, 0x5f, 0x00,
	0x25, 0x55, r_bf, 0x14, r_c1, 0x40, 0xc0, 0xfe, 0x90, 0x00, 0x00,
	0x01, 0x50, 0x62, 0x90, 0xe3, 0x0c, 0x23, r_cf,	0xc0, 0x08, 0x10,
	0x10, 0x0a, 0x00, 0x0d, 0x00, 0x00, 0x05, 0x00, 0x05, 0x50, r_dd,
	0x08, r_df,	0x00, 0x00, 0x00, 0x00, 0x6e, 0x40, 0x00, 0x00, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, r_ef, 0x20, 0x40, 0x32, 0x46,
	0xe4, r_f5, r_f6, r_f7, r_f8, 0x01, 0x00, 0x32, 0x50, 0x05, 0x00,
	r_ff
	}, /* TVIN_SIG_FMT_CVBS_PAL_60, */
	{
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, r_81, 0x42, 0x6f, 0x03, 0x00,
	0x03, 0x00, 0x00, r_89, 0x0a, 0x11, r_8c, 0x0a, 0x00, 0xe2,	0x00,
	0x00, 0x01, 0x00, 0x08, 0x00, 0x00, r_97, r_98, r_99, r_9a, r_9b,
	r_9c, r_9d, r_9e, r_9f,	0xf2, 0x0b, 0x00, 0x00, 0x08, 0x08, 0x00,
	0x00, 0x00, 0x00, 0x16, 0x0f, 0xc1, r_ad, 0xcf, 0x8c, 0xe0, 0x2f,
	0x0c, 0x03, 0x24, 0xa2, 0x02, 0x00, 0x00, r_b9, 0x24, 0x5f, 0x00,
	0x25, 0x55, r_bf, 0x14, r_c1, 0x40, 0xc0, 0xfe, 0x90, 0x00, 0x00,
	0x01, 0x50, 0x62, 0x90, 0xe3, 0x2c, 0x23, r_cf,	0xc0, 0x08, 0x10,
	0x10, 0x0a, 0x00, 0x0d, 0x00, 0x00, 0x05, 0x00, 0x05, 0x50, r_dd,
	0x08, r_df,	0x00, 0x00, 0x00, 0x00, 0x6e, 0x50, 0x00, 0x00, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, r_ef, 0x20, 0x1f, 0x32, 0x46,
	0xe4, r_f5, r_f6, r_f7, r_f8, 0x01, 0x00, 0x32, 0x50, 0x1c, 0xdc,
	r_ff
	}, /* TVIN_SIG_FMT_CVBS_PAL_CN, */
	{
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x84, r_81, 0x42, 0x6f, 0x03, 0x00,
	0x00, 0x00, 0x00, r_89, 0x0a, 0x11, r_8c, 0x0a, 0x00, 0xe2,	0x00,
	0x00, 0x01, 0x00, 0x08, 0x00, 0x00, r_97, r_98, r_99, r_9a, r_9b,
	r_9c, r_9d, r_9e, r_9f,	0xf2, 0x0b, 0x00, 0x00, 0x08, 0x08, 0x00,
	0x00, 0x00, 0x00, 0x5f, 0x0f, 0x0b, r_ad, 0xcf, 0x8c, 0xe0, 0x2f,
	0x0c, 0x03, 0x24, 0x22, 0x02, 0x00, 0x00, r_b9, 0x24, 0x5f, 0x00,
	0x25, 0x55, r_bf, 0x14, r_c1, 0x40, 0xc0, 0xfe, 0x90, 0x00, 0x00,
	0x01, 0x50, 0x62, 0x90, 0xe3, 0x0c, 0x23, r_cf,	0xc0, 0x08, 0x10,
	0x10, 0x0a, 0x00, 0x0d, 0x00, 0x00, 0x05, 0x00, 0x05, 0x50, r_dd,
	0x1f, r_df,	0x00, 0x00, 0x00, 0x00, 0x6e, 0x40, 0x00, 0x00, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, r_ef, 0x20, 0x40, 0x3c, 0x6e,
	0xe4, r_f5, r_f6, r_f7, r_f8, 0x01, 0x00, 0x50, 0x6e, 0x05, 0xdc,
	r_ff
	}, /* TVIN_SIG_FMT_CVBS_SECAM, */
	{
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7f, 0x42, 0x6f, 0x03, 0x00,
	0x04, 0x00, 0x00, r_89, 0x0a, 0x11, r_8c, 0x0a, 0x00, 0xe2,	0x00,
	0x00, 0x1f, 0x00, 0x08, 0x00, 0x00, r_97, r_98, r_99, r_9a, r_9b,
	r_9c, r_9d, r_9e, r_9f,	0xf2, 0x0b, 0x00, 0x00, 0x08, 0x08, 0x00,
	0x00, 0x00, 0x00, 0x16, 0x0f, 0xc1, r_ad, 0xcf, 0x86, 0xfa, 0x2f,
	0x0c, 0x03, 0x23, 0xa2, 0x02, 0x00, 0x08, r_b9, 0x24, 0x5f, 0x00,
	0x25, 0x55, r_bf, 0x14, r_c1, 0x40, 0xc0, 0xfe, 0x90, 0x00, 0xf0,
	0x01, 0x50, 0x62, 0x90, 0xe3, 0x2c, 0x23, r_cf,	0xc0, 0x08, 0x10,
	0x10, 0x0a, 0x00, 0x0d, 0x00, 0x00, 0x05, 0x00, 0x05, 0x40, r_dd,
	0x08, r_df,	0x00, 0x01, 0xc2, 0x88, 0x6e, 0x50, 0x00, 0x00, 0x30,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, r_ef, 0x20, 0x1f, 0x32, 0x46,
	0xe4, r_f5, r_f6, r_f7, r_f8, 0x01, 0x80, 0x32, 0x50, 0x1c, 0x00,
	r_ff
	}, /* TVIN_SIG_FMT_CVBS_NTSC_50, */
};
EXPORT_SYMBOL(cvd_part2_table);

/* 0x87, 0x93, 0x94, 0x95, 0x96, 0xe6, 0xfa */
const unsigned int cvd_part3_table[TVIN_SIG_FMT_CVBS_NTSC_50 -
	TVIN_SIG_FMT_CVBS_NTSC_M + 1][CVD_PART3_REG_NUM] = {
	{
		0x00000000, 0x98000000, 0x0000FF08, 0x00000000, 0x8b000000,
		0x0000008c, 0x00000000
	}, /* TVIN_SIG_FMT_CVBS_NTSC_M, */
	{
		0x00000000, 0x98000000, 0x0000FF08, 0x00000000, 0x8b000000,
		0x0000008c, 0x00000000
	}, /* TVIN_SIG_FMT_CVBS_NTSC_443, */
	{
		0x00000000, 0x98000000, 0x0000FF08, 0x00000000, 0x8b000000,
		0x0000008c, 0x00000080
	}, /* TVIN_SIG_FMT_CVBS_PAL_I, */
	{
		0x00000000, 0x98000000, 0x0000FF08, 0x00000000, 0x8b000000,
		0x0000008c, 0x00000080
	}, /* TVIN_SIG_FMT_CVBS_PAL_M, */
	{
		0x00000000, 0x98000000, 0x0000FF08, 0x00000000, 0x8b000000,
		0x0000008c, 0x00000080
	}, /* TVIN_SIG_FMT_CVBS_PAL_60, */
	{
		0x00000000, 0x98000000, 0x0000FF08, 0x00000000, 0x8b000000,
		0x0000008c, 0x00000080
	}, /* TVIN_SIG_FMT_CVBS_PAL_CN, */
	{
		0x00000000, 0x98000000, 0x0000FF08, 0x00000000, 0x8b000000,
		0x0000008c, 0x00000020
	}, /* TVIN_SIG_FMT_CVBS_SECAM, */
	{
		0x00000000, 0x98000000, 0x0000FF08, 0x00000000, 0x8b000000,
		0x0000008c, 0x00000080
	}, /* TVIN_SIG_FMT_CVBS_NTSC_50, */

};
EXPORT_SYMBOL(cvd_part3_table);

const unsigned int cvbs_acd_table[TVIN_SIG_FMT_CVBS_NTSC_50 -
	TVIN_SIG_FMT_CVBS_NTSC_M + 1][ACD_REG_NUM+1] = {
	{
		0x10101002, 0x0,       0x7f00e110, 0x08881e18, 0xb36d1858,
		0x00007612, 0x00000000, 0x77444444,	0x20e000fe, 0x00000101,
		0x0c000100, 0x80010909, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0x1010403c, 0x44060606, 0x08080044, 0x00080808,
		0xc006844b, 0x40200808, 0x44440044, 0x00008c80,	0xf0008888,
		0xa0461006, 0x70ff0404, 0x0400208c, 0x48484848, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x08000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x2,       0xe7f14e8e,
		0x001f0008, 0x20070000, 0x0036e946, 0x00001001, 0x10e0474f,
		0x00880358, 0x00130103, 0x00000000,	0x00000000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004cfb0, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000164e, 0x0003d55e, 0x000000f0,	0x00000001,
		0x00000400, 0x7f00e110, 0x08881e18, 0xb36d1858, 0x00007612,
		0x00000000, 0x77444444,	0x20e000fe, 0x00000101, 0x0c000100,
		0x80010909, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x50502070, 0x401020,
		0xd9801c0c, 0x21f00ff, 0x8080801c,	0x81f11111, 0x81f85852,
		0x00680068, 0x0487101c, 0x0000000f, 0x00000000, 0x00012002,
		0x00028040,	0x00000000, 0x08000000, 0x7f1ff000, 0x00000000,
		0x10101040, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x80000000, 0x00000000,
		0x00000000, 0xa00833da,	0xba5b0391, 0x000ae232, 0x00000000,
		0xf0080610, 0x3000180a, 0x9c10,    0x00000182, 0x00000000,
		0x81000002, 0x83020010, 0x000121ff, 0x000c0340, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x75777577, 0x00000000, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x00018018, 0x00040010, 0x00000000,
		0x00000000, 0x002468b5, 0x002fa63a, 0x0143a740,	0x00032864,
		0x00001b10, 0x0371d249, 0x0003ebde, 0x00032864, 0x00001b10,
		0x0371d249, 0x0003ebde,	0X00032864, 0x00001b10, 0x0371d249,
		0x0003ebde, 0x00032864, 0x00001b10, 0x0371d249, 0x0003ebde,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000,
		0x00000000, 0x90000fff, 0x00000000, 0x90000fff,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x00c1837e, 0x01000100, 0x43062222,
		0x75777577, 0x00000000, 0x00192718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x00018018, 0x00040010, 0x00000000, 0x00000000,
		0x00247e04, 0x002fa52a, 0x0143a2ef,	0x000327bf, 0x00001b03,
		0x0371b470, 0x0003f28b, 0x000327bf, 0x00001b03, 0x0371b470,
		0x0003f28b,	0x000327bf, 0x00001b03, 0x0371b470, 0x0003f28b,
		0x000327bf, 0x00001b03, 0x0371b470, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x0f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff

	}, /* TVIN_SIG_FMT_CVBS_NTSC_M, */
	{
		0x10101002, 0x10101010, 0x7f00e110, 0x08881e18, 0xb36d1858,
		0x00007612, 0x00000000, 0x77444444,	0x20e000fe, 0x00000101,
		0x0c000100, 0x80010909, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0x1010603c, 0x44060606, 0x08080044, 0x00080808,
		0x0c06844b, 0x40200808, 0x44440044, 0x00008c80,	0xf0008888,
		0xa0461006, 0x70ff0404, 0x0000208c, 0x48484848, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x10000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x00000002, 0xe7f14e8e,
		0x00140008, 0x20070000, 0x0036e946, 0x00001001, 0x10e0474f,
		0x00880358, 0x00120102, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d068, 0x00000000, 0x030000f0,
		0x0000000a, 0x000013f0, 0x0003d300, 0x000000f0,	0x00000001,
		0x00000400, 0x7f00e110, 0x08881e18, 0xb36d1858, 0x00007612,
		0x00000000, 0x77444444,	0x20e000fe, 0x00000101, 0x0c000100,
		0x80010909, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x40403070, 0x04281020,
		0x00000000, 0x021000ff, 0x80688030,	0x81f11111, 0x81f85852,
		0x00680068, 0x0487101c, 0x0000000f, 0x00000000, 0x00012002,
		0x00028040,	0x00000000, 0x10000000, 0x7f1ff000, 0x00000000,
		0x10101040, 0x40404040, 0x00000000, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x80000000, 0x00000000,
		0x00000000, 0xc00833da,	0xba5b0391, 0x000ae232, 0x00000000,
		0xf0080610, 0x60001808, 0x00009410, 0x00000003, 0x00000000,
		0x81018014, 0x03020010, 0x000121ff, 0x000c0340, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x75757577, 0x00000002, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x00018018, 0x00040010, 0x00000000,
		0x00000000, 0x01c12807, 0x00000000, 0x00000000,	0x000ff511,
		0x00000000, 0x0012198b, 0x037d7036, 0x000ff511, 0x00000000,
		0x0012198b, 0x037d7036,	0x000ff511, 0x00000000, 0x0012198b,
		0x037d7036, 0x000ff511, 0x00000000, 0x0012198b, 0x037d7036,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000,
		0x00000000, 0x90000fff, 0x00000000, 0x90000fff,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x00c1837e, 0x01000100, 0x43062222,
		0x75757577, 0x00000002, 0x00000718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x00018018, 0x00040010, 0x00000000, 0x00000000,
		0x01c08fed, 0x00000000, 0x00000000,	0x000feeef, 0x00000000,
		0x001213ab, 0x037b5071, 0x000feeef, 0x00000000, 0x001213ab,
		0x037b5071,	0x000feeef, 0x00000000, 0x001213ab, 0x037b5071,
		0x000feeef, 0x00000000, 0x001213ab, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,
	}, /* TVIN_SIG_FMT_CVBS_NTSC_443, */
	{
		0x22222202, 0x22222222, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0x1010403c, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x70ff0404, 0x400208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x08000000, 0x02020000,
		0x0209c832, 0x00000000, 0xfcf44396, 0x2,       0xe7f14e8e,
		0x00140008, 0x20800000, 0x00275a60, 0x00001001, 0x10e0474f,
		0x00890359, 0x00170137, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d206, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000523e, 0x0004114e, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x18188080, 0x601838,
		0xd9804c18, 0x020f00ff, 0x80808020,	0x88711111, 0x81f24742,
		0x80380038, 0x10000,   0x0000000f, 0x00000000, 0x00000000,
		0x00300000,	0x00000000, 0x08000000, 0x7f1ff000, 0x00000000,
		0x80c0c080, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0xa00833da,	0xba5b0391, 0x000ae232, 0x00000000,
		0xf0080610, 0x08104008, 0x2c10,    0x00000003, 0x00000000,
		0x88001002, 0x3020010, 0x000281ff, 0x000803c0, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x74777477, 0x00000000, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x18004,   0x00200000, 0x00000000,
		0x00000000, 0x00eb2aac, 0x00000000, 0x00000000,	0x001652f7,
		0x00000000, 0x00000000, 0x04974980, 0x001652f7, 0x00000000,
		0x00000000, 0x04974980,	0x001652f7, 0x00000000, 0x00000000,
		0x04974980, 0x001652f7, 0x00000000, 0x00000000, 0x04974980,
		0x3f000100, 0x8f000004, 0x3f000100, 0x0f000004, 0x00000002,
		0x00000000, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004,
		0x00000002, 0x90000fff, 0x00000002, 0x90000fff,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x00c1837e, 0x01000100, 0x43062222,
		0x74777477, 0x00000000, 0x00192718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018004, 0x00200000, 0x00000000, 0x00000000,
		0x010d753b, 0x00000000, 0x00000000,	0x0018c65f, 0x00000000,
		0x00000000, 0x05520b96, 0x0018c65f, 0x00000000, 0x00000000,
		0x05520b96,	0x0018c65f, 0x00000000, 0x00000000, 0x05520b96,
		0x0018c65f, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100,
		0x8f000004, 0x00000002, 0x90000fff, 0x00000002, 0x90000fff,
		0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004, 0x00000002,
		0x90000fff, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,
	}, /* TVIN_SIG_FMT_CVBS_PAL_I, */
	{
		0x01010101, 0x01010101, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0xc0c0600f, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x40ff0400, 0x0427208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x10000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x00000102, 0xe7f14e8e,
		0x00142108, 0x00800000, 0x0026e905, 0x00001001, 0x10e0474f,
		0x00700340, 0x00100100, 0x000a0000,	0x00080000, 0x00000000,
		0x000a0000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d019, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000442d, 0x0004033d, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00205040, 0xf0f0c0c0,
		0xd9c00010, 0x020f00ff, 0x80808020,	0x81f11111, 0x81f24742,
		0x80400040, 0x03000000, 0x0000000f, 0x00000000, 0x00000000,
		0x00300000,	0x00000000, 0x10000000, 0x7f1ff000, 0x00000000,
		0x40404040, 0x40404040, 0x00000000, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0x2008f433,	0xb3640378, 0x000bdf37, 0x00000000,
		0xf0080610, 0x08104008, 0x00002410, 0x00000003, 0x00000000,
		0x00400040, 0x00080040, 0x000281ff, 0x000803c0, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x75767576, 0x00000002, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x80018018, 0x00800000, 0x00000000,
		0x00000000, 0x027d7b59, 0x00000000, 0x00000000,	0x001540c8,
		0x00000000, 0x00000000, 0x03ca7af4, 0x001540c8, 0x00000000,
		0x00000000, 0x03ca7af4,	0x001540c8, 0x00000000, 0x00000000,
		0x03ca7af4, 0x001540c8, 0x00000000, 0x00000000, 0x03ca7af4,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000,
		0x00000000, 0x90000fff, 0x00000000, 0x90000fff,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x00c1837e, 0x01000100, 0x43062222,
		0x75767576, 0x00000002, 0x00000718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018018, 0x00800000, 0x00000000, 0x00000000,
		0x0282ce1c, 0x00000000, 0x00000000,	0x00153fb2, 0x00000000,
		0x00000000, 0x03ca7c7c, 0x00153be2, 0x00000000, 0x00000000,
		0x03ca7c7c,	0x00153be2, 0x00000000, 0x00000000, 0x03ca7c7c,
		0x00153be2, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,
	}, /* TVIN_SIG_FMT_CVBS_PAL_M, */
	{
		0x01010101, 0x01010101, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0xc0c0600f, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x40ff0400, 0x0427208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x08000000, 0x02020000,
		0x0209c832, 0x00000000, 0xfcf44396, 0x00000102, 0xe7f14e8e,
		0x00140008, 0x20800000, 0x00275a60, 0x00001001, 0x10e0474f,
		0x00880358, 0x00130103, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d206, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000523e, 0x0004114e, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x08205070, 0x0050a0a0,
		0x00000000, 0x020f00ff, 0x80808020,	0x80711111, 0x81f24742,
		0x80380038, 0x03061010, 0x0000000f, 0x00000000, 0x00000000,
		0x00300000,	0x00000000, 0x08000000, 0x7f1ff000, 0x00000000,
		0x80c0c080, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0xa00833da,	0xba5b0391, 0x000ae232, 0x00000000,
		0xf0080610, 0x08104008, 0x00002410, 0x00000003, 0x00000000,
		0x88001002, 0x83024016, 0x000281ff, 0x000803c0, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x74777477, 0x00000000, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x80018004, 0x00200000, 0x00000000,
		0x00000000, 0x00eb2aac, 0x00000000, 0x00000000,	0x001652f7,
		0x00000000, 0x00000000, 0x04974980, 0x001652f7, 0x00000000,
		0x00000000, 0x04974980,	0x001652f7, 0x00000000, 0x00000000,
		0x04974980, 0x001652f7, 0x00000000, 0x00000000, 0x04974980,
		0x3f000100, 0x8f000004, 0x3f000100, 0x0f000004, 0x00000002,
		0x00000000, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004,
		0x00000002, 0x90000fff, 0x00000002, 0x90000fff,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x00c1837e, 0x01000100, 0x43062222,
		0x74777477, 0x00000000, 0x00192718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018004, 0x00200000, 0x00000000, 0x00000000,
		0x010d753b, 0x00000000, 0x00000000,	0x0018c65f, 0x00000000,
		0x00000000, 0x05520b96, 0x0018c65f, 0x00000000, 0x00000000,
		0x05520b96,	0x0018c65f, 0x00000000, 0x00000000, 0x05520b96,
		0x0018c65f, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100,
		0x8f000004, 0x00000002, 0x90000fff, 0x00000002, 0x90000fff,
		0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004, 0x00000002,
		0x90000fff, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,
	}, /* TVIN_SIG_FMT_CVBS_PAL_60,the same to TVIN_SIG_FMT_CVBS_PAL_I */
	{
		0x01010101, 0x01010101, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0xc0c0600f, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x40ff0400, 0x0427208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x10000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x00000102, 0xe7f14e8e,
		0x00142108, 0x00800000, 0x002717d9, 0x00001001, 0x10e0474f,
		0x00700340, 0x00100100, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d1fb, 0x00000000, 0x030000f0,
		0x0000000a, 0x00005fef, 0x00041eff, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00205040, 0xf0f0c0c0,
		0xd9c00010, 0x020f00ff, 0x80808020,	0x81f11111, 0x81f24742,
		0x80400040, 0x03000000, 0x0000000f, 0x00000000, 0x00000000,
		0x00000000,	0x00000000, 0x10000000, 0x7f1ff000, 0x00000000,
		0x40404040, 0x40404040, 0x00000000, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0x2008f433,	0xb3640378, 0x000bdf37, 0x00000000,
		0xf0080610, 0x08104008, 0x00002410, 0x00000003, 0x00000000,
		0x00400040, 0x00080040, 0x00fff000, 0x00040000, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0xf3f6f4f8, 0x00000002, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x80018018, 0x00800000, 0x00000000,
		0x00000000, 0x00c2befd, 0x00000000, 0x00000000,	0x00047fcc,
		0x00000000, 0x00000000, 0x04591a41, 0x00047fcc, 0x00000000,
		0x00000000, 0x04591a41,	0x00047fcc, 0x00000000, 0x00000000,
		0x04591a41, 0x00047fcc, 0x00000000, 0x00000000, 0x04591a41,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000,
		0x00000000, 0x90000fff, 0x00000000, 0x90000fff,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x00c1837e, 0x01000100, 0x43062222,
		0xf3f6f4f8, 0x00000002, 0x00000718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018018, 0x00800000, 0x00000000, 0x00000000,
		0x00b57c68, 0x00000000, 0x00000000,	0x00042c0d, 0x00000000,
		0x00000000, 0x03dc2e7a, 0x00042c0d, 0x00000000, 0x00000000,
		0x03dc2e7a,	0x00042c0d, 0x00000000, 0x00000000, 0x03dc2e7a,
		0x00042c0d, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,
	}, /* TVIN_SIG_FMT_CVBS_PAL_CN, */
	{
		0x01010101, 0x01010101, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0xc0c0600f, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x40ff0400, 0x0427208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x10000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x00000102, 0xe7f14e8e,
		0x00140108, 0x00070000, 0x002717d9, 0x00001001, 0x10e0474f,
		0x00700340, 0x00170137, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d1fb, 0x00000000, 0x030000f0,
		0x0000000a, 0x00005fef, 0x00041eff, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x08205040, 0x0050c0c0,
		0x00000000, 0x020f00ff, 0x00808020,	0x81f11111, 0x81f24742,
		0x80200020, 0x03000000, 0x0000000f, 0x00000000, 0x00000000,
		0x00000000,	0x00000000, 0x10000000, 0x7f1ff000, 0x00000000,
		0x40404040, 0x40404040, 0x00000000, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0x2008f433,	0xb3640378, 0x000bdf37, 0x00000000,
		0xf0080610, 0x08104008, 0x00002410, 0x00000003, 0x00000000,
		0x00400040, 0x00080040, 0x00fff000, 0x00040000, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0xf3f6f4f8, 0x00000002, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x80018018, 0x00800000, 0x00000000,
		0x00000000, 0x00c2befd, 0x00000000, 0x00000000,	0x00047fcc,
		0x00000000, 0x00000000, 0x04591a41, 0x00047fcc, 0x00000000,
		0x00000000, 0x04591a41,	0x00047fcc, 0x00000000, 0x00000000,
		0x04591a41, 0x00047fcc, 0x00000000, 0x00000000, 0x04591a41,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000,
		0x00000000, 0x90000fff, 0x00000000, 0x90000fff,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x00c1837e, 0x01000100, 0x43062222,
		0xf3f6f4f8, 0x00000002, 0x00000718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018018, 0x00800000, 0x00000000, 0x00000000,
		0x00b57c68, 0x00000000, 0x00000000,	0x00042c0d, 0x00000000,
		0x00000000, 0x03dc2e7a, 0x00042c0d, 0x00000000, 0x00000000,
		0x03dc2e7a,	0x00042c0d, 0x00000000, 0x00000000, 0x03dc2e7a,
		0x00042c0d, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,

	}, /* TVIN_SIG_FMT_CVBS_SECAM, */
	{
		0x22222202, 0x22222222, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0x1010403c, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x70ff0404, 0x400208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x08000000, 0x02020000,
		0x0209c832, 0x00000000, 0xfcf44396, 0x2,       0xe7f14e8e,
		0x00140008, 0x20800000, 0x00275a60, 0x00001001, 0x10e0474f,
		0x00890359, 0x00170137, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d206, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000523e, 0x0004114e, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x18188080, 0x601838,
		0xd9804c18, 0x020f00ff, 0x80808020,	0x88711111, 0x81f24742,
		0x80380038, 0x10000,   0x0000000f, 0x00000000, 0x00000000,
		0x00300000,	0x00000000, 0x08000000, 0x7f1ff000, 0x00000000,
		0x80c0c080, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0xa00833da,	0xba5b0391, 0x000ae232, 0x00000000,
		0xf0080610, 0x08104008, 0x2c10,    0x00000003, 0x00000000,
		0x88001002, 0x3020010, 0x000281ff, 0x000803c0, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x74777477, 0x00000000, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x18004,   0x00200000, 0x00000000,
		0x00000000, 0x00eb2aac, 0x00000000, 0x00000000,	0x001652f7,
		0x00000000, 0x00000000, 0x04974980, 0x001652f7, 0x00000000,
		0x00000000, 0x04974980,	0x001652f7, 0x00000000, 0x00000000,
		0x04974980, 0x001652f7, 0x00000000, 0x00000000, 0x04974980,
		0x3f000100, 0x8f000004, 0x3f000100, 0x0f000004, 0x00000002,
		0x00000000, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004,
		0x00000002, 0x90000fff, 0x00000002, 0x90000fff,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x00c1837e, 0x01000100, 0x43062222,
		0x74777477, 0x00000000, 0x00192718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018004, 0x00200000, 0x00000000, 0x00000000,
		0x010d753b, 0x00000000, 0x00000000,	0x0018c65f, 0x00000000,
		0x00000000, 0x05520b96, 0x0018c65f, 0x00000000, 0x00000000,
		0x05520b96,	0x0018c65f, 0x00000000, 0x00000000, 0x05520b96,
		0x0018c65f, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100,
		0x8f000004, 0x00000002, 0x90000fff, 0x00000002, 0x90000fff,
		0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004, 0x00000002,
		0x90000fff, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,

	}, /* TVIN_SIG_FMT_CVBS_NTSC_50, */
};
EXPORT_SYMBOL(cvbs_acd_table);

const unsigned int rf_acd_table[TVIN_SIG_FMT_CVBS_NTSC_50 -
				TVIN_SIG_FMT_CVBS_NTSC_M+1][ACD_REG_NUM+1] = {
	{
		0x10101002, 0x0,       0x7f00e110, 0x08881e18, 0xb36d1858,
		0x00007612, 0x00000000, 0x77444444,	0x20e000fe, 0x00000101,
		0x0c000100, 0x80010909, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0x1010403c, 0x44060606, 0x08080044, 0x00080808,
		0xc006844b, 0x40200808, 0x44440044, 0x00008c80,	0xf0008888,
		0xa0461006, 0x70ff0404, 0x0400208c, 0x48484848, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x08000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x2,       0xe7f14e8e,
		0x001f0008, 0x20070000, 0x0036e946, 0x00001001, 0x10e0474f,
		0x00880358, 0x00130103, 0x00000000,	0x00000000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004cfb0, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000164e, 0x0003d55e, 0x000000f0,	0x00000001,
		0x00000400, 0x7f00e110, 0x08881e18, 0xb36d1858, 0x00007612,
		0x00000000, 0x77444444,	0x20e000fe, 0x00000101, 0x0c000100,
		0x80010909, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x50502070, 0x401020,
		0xd9801c0c, 0x21f00ff, 0x8080801c,	0x81f11111, 0x81f85852,
		0x00680068, 0x0487101c, 0x0000000f, 0x00000000, 0x00012002,
		0x00028040,	0x00000000, 0x08000000, 0x7f1ff000, 0x00000000,
		0x10101040, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x80000000, 0x00000000,
		0x00000000, 0xa00833da,	0xba5b0391, 0x000ae232, 0x00000000,
		0xf0080610, 0x3000180a, 0x9c10,    0x00000182, 0x00000000,
		0x81000002, 0x83020010, 0x000121ff, 0x000c0340, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x75777577, 0x00000000, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x00018018, 0x00040010, 0x00000000,
		0x00000000, 0x002468b5, 0x002fa63a, 0x0143a740,	0x00032864,
		0x00001b10, 0x0371d249, 0x0003ebde, 0x00032864, 0x00001b10,
		0x0371d249, 0x0003ebde,	0X00032864, 0x00001b10, 0x0371d249,
		0x0003ebde, 0x00032864, 0x00001b10, 0x0371d249, 0x0003ebde,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000,
		0x00000000, 0x90000fff, 0x00000000, 0x90000fff,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x00c1837e, 0x01000100, 0x43062222,
		0x75777577, 0x00000000, 0x00192718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x00018018, 0x00040010, 0x00000000, 0x00000000,
		0x00247e04, 0x002fa52a, 0x0143a2ef,	0x000327bf, 0x00001b03,
		0x0371b470, 0x0003f28b, 0x000327bf, 0x00001b03, 0x0371b470,
		0x0003f28b,	0x000327bf, 0x00001b03, 0x0371b470, 0x0003f28b,
		0x000327bf, 0x00001b03, 0x0371b470, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x0f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff
	}, /* TVIN_SIG_FMT_CVBS_NTSC_M, */
	{
		0x10101002, 0x10101010, 0x7f00e110, 0x08881e18, 0xb36d1858,
		0x00007612, 0x00000000, 0x77444444,	0x20e000fe, 0x00000101,
		0x0c000100, 0x80010909, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0x1010603c, 0x44060606, 0x08080044, 0x00080808,
		0x0c06844b, 0x40200808, 0x44440044, 0x00008c80,	0xf0008888,
		0xa0461006, 0x70ff0404, 0x0000208c, 0x48484848, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x10000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x00000102, 0xe7f14e8e,
		0x00140008, 0x20070000, 0x0036e946, 0x00001001, 0x10e0474f,
		0x00880358, 0x00120102, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d068, 0x00000000, 0x030000f0,
		0x0000000a, 0x000013f0, 0x0003d300, 0x000000f0,	0x00000001,
		0x00000400, 0x7f00e110, 0x08881e18, 0xb36d1858, 0x00007612,
		0x00000000, 0x77444444,	0x20e000fe, 0x00000101, 0x0c000100,
		0x80010909, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x40403070, 0x04281020,
		0x00000000, 0x021000ff, 0x80688030,	0x81f11111, 0x81f85852,
		0x00680068, 0x0487101c, 0x0000000f, 0x00000000, 0x00012002,
		0x00028040,	0x00000000, 0x10000000, 0x7f1ff000, 0x00000000,
		0x10101040, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x80000000, 0x00000000,
		0x00000000, 0x2008f433,	0xb3630387, 0x000bdf37, 0x00000000,
		0xf0080610, 0x60001808, 0x00009410, 0x00000003, 0x00000000,
		0x81018014, 0x83020010, 0x000121ff, 0x000c0340, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x75757577, 0x00000002, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x00018018, 0x00040010, 0x00000000,
		0x00000000, 0x01c12807, 0x00000000, 0x00000000,	0x000ff511,
		0x00000000, 0x0012198b, 0x037d7036, 0x000ff511, 0x00000000,
		0x0012198b, 0x037d7036,	0x000ff511, 0x00000000, 0x0012198b,
		0x037d7036, 0x000ff511, 0x00000000, 0x0012198b, 0x037d7036,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000,
		0x00000000, 0x90000fff, 0x00000000, 0x90000fff,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x00c1837e, 0x01000100, 0x43062222,
		0x75757577, 0x00000002, 0x00000718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x00018018, 0x00040010, 0x00000000, 0x00000000,
		0x01c08fed, 0x00000000, 0x00000000,	0x000feeef, 0x00000000,
		0x001213ab, 0x037b5071, 0x000feeef, 0x00000000, 0x001213ab,
		0x037b5071,	0x000feeef, 0x00000000, 0x001213ab, 0x037b5071,
		0x000feeef, 0x00000000, 0x001213ab, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,

	}, /* TVIN_SIG_FMT_CVBS_NTSC_443, */
	{
		0x22222202, 0x22222222, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0x1010403c, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x70ff0404, 0x208c,    0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x08000000, 0x02020000,
		0x0209c832, 0x00000000, 0xfcf44396, 0x2,       0xe7f14e8e,
		0x00140008, 0x20800000, 0x00275a60, 0x00001001, 0x10e0474f,
		0x00890359, 0x00170137, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d206, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000523e, 0x0004114e, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x28284080, 0x602020,
		0xd9804c08, 0x020f00ff, 0x80808020,	0x88711111, 0x81f24742,
		0x80380038, 0x10000,   0x0000000f, 0x00000000, 0x00000000,
		0x00300000,	0x00000000, 0x08000000, 0x7f1ff000, 0x00000000,
		0x80c0c080, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0xa00833da,	0xba5b0391, 0x000ae232, 0x00000000,
		0xf0080610, 0x08104008, 0x2c10,    0x00000003, 0x00000000,
		0x88001002, 0x3020010, 0x000281ff, 0x000803c0, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x74777477, 0x00000000, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x18004,   0x00200000, 0x00000000,
		0x00000000, 0x00eb2aac, 0x00000000, 0x00000000,	0x001652f7,
		0x00000000, 0x00000000, 0x04974980, 0x001652f7, 0x00000000,
		0x00000000, 0x04974980,	0x001652f7, 0x00000000, 0x00000000,
		0x04974980, 0x001652f7, 0x00000000, 0x00000000, 0x04974980,
		0x3f000100, 0x8f000004, 0x3f000100, 0x0f000004, 0x00000002,
		0x00000000, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004,
		0x00000002, 0x90000fff, 0x00000002, 0x90000fff,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x00c1837e, 0x01000100, 0x43062222,
		0x74777477, 0x00000000, 0x00192718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018004, 0x00200000, 0x00000000, 0x00000000,
		0x010d753b, 0x00000000, 0x00000000,	0x0018c65f, 0x00000000,
		0x00000000, 0x05520b96, 0x0018c65f, 0x00000000, 0x00000000,
		0x05520b96,	0x0018c65f, 0x00000000, 0x00000000, 0x05520b96,
		0x0018c65f, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100,
		0x8f000004, 0x00000002, 0x90000fff, 0x00000002, 0x90000fff,
		0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004, 0x00000002,
		0x90000fff, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,

	}, /* TVIN_SIG_FMT_CVBS_PAL_I, */
	{
		0x01010101, 0x01010101, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0xc0c0600f, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x40ff0400, 0x0427208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x10000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x00000102, 0xe7f14e8e,
		0x00140108, 0x00800000, 0x0026e905, 0x00001001, 0x10e0474f,
		0x00880358, 0x00130103, 0x000a0000,	0x00080000, 0x00000000,
		0x000a0000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d019, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000442d, 0x0004033d, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00205040, 0xf0f0c0c0,
		0xd9c00010, 0x020f00ff, 0x00808020,	0x81f11111, 0x81f24742,
		0x80400040, 0x03000000, 0x0000000f, 0x00000000, 0x00000000,
		0x80300000,	0x00000000, 0x10000000, 0x7f1ff000, 0x00000000,
		0x40404040, 0x40404040, 0x00000000, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0x2008f433,	0xb3640378, 0x000bdf37, 0x00000000,
		0xf0080610, 0x08104008, 0x00002410, 0x00000003, 0x00000000,
		0x00400040, 0x00080040, 0x000281ff, 0x000803c0, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x75767576, 0x00000002, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x80018018, 0x00800000, 0x00000000,
		0x00000000, 0x027d7b59, 0x00000000, 0x00000000,	0x001540c8,
		0x00000000, 0x00000000, 0x03ca7af4, 0x001540c8, 0x00000000,
		0x00000000, 0x03ca7af4,	0x001540c8, 0x00000000, 0x00000000,
		0x03ca7af4, 0x001540c8, 0x00000000, 0x00000000, 0x03ca7af4,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000,
		0x00000000, 0x90000fff, 0x00000000, 0x90000fff,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x00c1837e, 0x01000100, 0x43062222,
		0x75767576, 0x00000002, 0x00000718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018018, 0x00800000, 0x00000000, 0x00000000,
		0x0282ce1c, 0x00000000, 0x00000000,	0x00153fb2, 0x00000000,
		0x00000000, 0x03ca7c7c, 0x00153be2, 0x00000000, 0x00000000,
		0x03ca7c7c,	0x00153be2, 0x00000000, 0x00000000, 0x03ca7c7c,
		0x00153be2, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,

	}, /* TVIN_SIG_FMT_CVBS_PAL_M, */
	{
		0x01010101, 0x01010101, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0xc0c0600f, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x40ff0400, 0x0427208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x08000000, 0x02020000,
		0x0209c832, 0x00000000, 0xfcf44396, 0x00000102, 0xe7f14e8e,
		0x00140008, 0x20800000, 0x00275a60, 0x00001001, 0x10e0474f,
		0x00880358, 0x00130103, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d206, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000523e, 0x0004114e, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x08205070, 0x0050a0a0,
		0x00000000, 0x020f00ff, 0x80808020,	0x80711111, 0x81f24742,
		0x80380038, 0x03061010, 0x0000000f, 0x00000000, 0x00000000,
		0x00300000,	0x00000000, 0x08000000, 0x7f1ff000, 0x00000000,
		0x80c0c080, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0x2008f433,	0xb3630387, 0x000bdf37, 0x00000000,
		0xf0080610, 0x08104008, 0x00002410, 0x00000003, 0x00000000,
		0x88001002, 0x83024016, 0x000281ff, 0x000803c0, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x74777477, 0x00000000, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x80018004, 0x00200000, 0x00000000,
		0x00000000, 0x00eb2aac, 0x00000000, 0x00000000,	0x001652f7,
		0x00000000, 0x00000000, 0x04974980, 0x001652f7, 0x00000000,
		0x00000000, 0x04974980,	0x001652f7, 0x00000000, 0x00000000,
		0x04974980, 0x001652f7, 0x00000000, 0x00000000, 0x04974980,
		0x3f000100, 0x8f000004, 0x3f000100, 0x0f000004, 0x00000002,
		0x00000000, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004,
		0x00000002, 0x90000fff, 0x00000002, 0x90000fff,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x00c1837e, 0x01000100, 0x43062222,
		0x74777477, 0x00000000, 0x00192718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018004, 0x00200000, 0x00000000, 0x00000000,
		0x010d753b, 0x00000000, 0x00000000,	0x0018c65f, 0x00000000,
		0x00000000, 0x05520b96, 0x0018c65f, 0x00000000, 0x00000000,
		0x05520b96,	0x0018c65f, 0x00000000, 0x00000000, 0x05520b96,
		0x0018c65f, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100,
		0x8f000004, 0x00000002, 0x90000fff, 0x00000002, 0x90000fff,
		0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004, 0x00000002,
		0x90000fff, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,

	}, /* TVIN_SIG_FMT_CVBS_PAL_60,the same to TVIN_SIG_FMT_CVBS_PAL_I */
	{
		0x01010101, 0x01010101, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0xc0c0600f, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x40ff0400, 0x0427208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x10000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x00000102, 0xe7f14e8e,
		0x00142108, 0x00800000, 0x002717d9, 0x00001001, 0x10e0474f,
		0x00700340, 0x00100100, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d1fb, 0x00000000, 0x030000f0,
		0x0000000a, 0x00005fef, 0x00041eff, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00205040, 0xf0f0c0c0,
		0xd9c00010, 0x020f00ff, 0x80808020,	0x81f11111, 0x81f24742,
		0x80400040, 0x03000000, 0x0000000f, 0x00000000, 0x00000000,
		0x00000000,	0x00000000, 0x10000000, 0x7f1ff000, 0x00000000,
		0x40404040, 0x40404040, 0x00000000, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0x2008f433,	0xb3640378, 0x000bdf37, 0x00000000,
		0xf0080610, 0x08104008, 0x00002410, 0x00000003, 0x00000000,
		0x00400040, 0x00080040, 0x00fff000, 0x00040000, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0xf3f6f4f8, 0x00000002, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x80018018, 0x00800000, 0x00000000,
		0x00000000, 0x00c2befd, 0x00000000, 0x00000000,	0x00047fcc,
		0x00000000, 0x00000000, 0x04591a41, 0x00047fcc, 0x00000000,
		0x00000000, 0x04591a41,	0x00047fcc, 0x00000000, 0x00000000,
		0x04591a41, 0x00047fcc, 0x00000000, 0x00000000, 0x04591a41,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000,
		0x00000000, 0x90000fff, 0x00000000, 0x90000fff,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x00c1837e, 0x01000100, 0x43062222,
		0xf3f6f4f8, 0x00000002, 0x00000718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018018, 0x00800000, 0x00000000, 0x00000000,
		0x00b57c68, 0x00000000, 0x00000000,	0x00042c0d, 0x00000000,
		0x00000000, 0x03dc2e7a, 0x00042c0d, 0x00000000, 0x00000000,
		0x03dc2e7a,	0x00042c0d, 0x00000000, 0x00000000, 0x03dc2e7a,
		0x00042c0d, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,

	}, /* TVIN_SIG_FMT_CVBS_PAL_CN, */
	{
		0x01010101, 0x01010101, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0xc0c0600f, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x40ff0400, 0x0427208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x10000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x00000102, 0xe7f14e8e,
		0x00140108, 0x00070000, 0x002717d9, 0x00001001, 0x10e0474f,
		0x00700340, 0x00170137, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d1fb, 0x00000000, 0x030000f0,
		0x0000000a, 0x00005fef, 0x00041eff, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x08205040, 0x0050c0c0,
		0x00000000, 0x020f00ff, 0x80808020,	0x81f11111, 0x81f24742,
		0x80200020, 0x03000000, 0x0000000f, 0x00000000, 0x00000000,
		0x00000000,	0x00000000, 0x10000000, 0x7f1ff000, 0x00000000,
		0x40404040, 0x40404040, 0x00000000, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0x2008f433,	0xb3640378, 0x000bdf37, 0x00000000,
		0xf0080610, 0x08104008, 0x00002410, 0x00000003, 0x00000000,
		0x00400040, 0x00080040, 0x00fff000, 0x00040000, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0xf3f6f4f8, 0x00000002, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x80018018, 0x00800000, 0x00000000,
		0x00000000, 0x00c2befd, 0x00000000, 0x00000000,	0x00047fcc,
		0x00000000, 0x00000000, 0x04591a41, 0x00047fcc, 0x00000000,
		0x00000000, 0x04591a41,	0x00047fcc, 0x00000000, 0x00000000,
		0x04591a41, 0x00047fcc, 0x00000000, 0x00000000, 0x04591a41,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000,
		0x00000000, 0x90000fff, 0x00000000, 0x90000fff,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x00c1837e, 0x01000100, 0x43062222,
		0xf3f6f4f8, 0x00000002, 0x00000718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018018, 0x00800000, 0x00000000, 0x00000000,
		0x00b57c68, 0x00000000, 0x00000000,	0x00042c0d, 0x00000000,
		0x00000000, 0x03dc2e7a, 0x00042c0d, 0x00000000, 0x00000000,
		0x03dc2e7a,	0x00042c0d, 0x00000000, 0x00000000, 0x03dc2e7a,
		0x00042c0d, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,
	}, /* TVIN_SIG_FMT_CVBS_SECAM, */
	{
		0x22222202, 0x22222222, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0x1010403c, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x70ff0404, 0x208c,    0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x08000000, 0x02020000,
		0x0209c832, 0x00000000, 0xfcf44396, 0x2,       0xe7f14e8e,
		0x00140008, 0x20800000, 0x00275a60, 0x00001001, 0x10e0474f,
		0x00890359, 0x00170137, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d206, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000523e, 0x0004114e, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x28284080, 0x602020,
		0xd9804c08, 0x020f00ff, 0x80808020,	0x88711111, 0x81f24742,
		0x80380038, 0x10000,   0x0000000f, 0x00000000, 0x00000000,
		0x00300000,	0x00000000, 0x08000000, 0x7f1ff000, 0x00000000,
		0x80c0c080, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0xa00833da,	0xba5b0391, 0x000ae232, 0x00000000,
		0xf0080610, 0x08104008, 0x2c10,    0x00000003, 0x00000000,
		0x88001002, 0x3020010, 0x000281ff, 0x000803c0, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x74777477, 0x00000000, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x18004,   0x00200000, 0x00000000,
		0x00000000, 0x00eb2aac, 0x00000000, 0x00000000,	0x001652f7,
		0x00000000, 0x00000000, 0x04974980, 0x001652f7, 0x00000000,
		0x00000000, 0x04974980,	0x001652f7, 0x00000000, 0x00000000,
		0x04974980, 0x001652f7, 0x00000000, 0x00000000, 0x04974980,
		0x3f000100, 0x8f000004, 0x3f000100, 0x0f000004, 0x00000002,
		0x00000000, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004,
		0x00000002, 0x90000fff, 0x00000002, 0x90000fff,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x00c1837e, 0x01000100, 0x43062222,
		0x74777477, 0x00000000, 0x00192718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018004, 0x00200000, 0x00000000, 0x00000000,
		0x010d753b, 0x00000000, 0x00000000,	0x0018c65f, 0x00000000,
		0x00000000, 0x05520b96, 0x0018c65f, 0x00000000, 0x00000000,
		0x05520b96,	0x0018c65f, 0x00000000, 0x00000000, 0x05520b96,
		0x0018c65f, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100,
		0x8f000004, 0x00000002, 0x90000fff, 0x00000002, 0x90000fff,
		0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004, 0x00000002,
		0x90000fff, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,
	}, /* TVIN_SIG_FMT_CVBS_NTSC_50, */
};
EXPORT_SYMBOL(rf_acd_table);

const unsigned int cvbs_acd_table_tm2_b[TVIN_SIG_FMT_CVBS_NTSC_50 -
	TVIN_SIG_FMT_CVBS_NTSC_M + 1][ACD_REG_NUM+1] = {
	{
		0x10101002, 0x0,       0x7f00e110, 0x08881e18, 0xb36d1858,
		0x00007612, 0x00000000, 0x77444444,	0x20e000fe, 0x00000101,
		0x0c000100, 0x80010909, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0x1010403c, 0x44060606, 0x08080044, 0x00080808,
		0xc006844b, 0x40200808, 0x44440044, 0x00008c80,	0xf0008888,
		0xa0461006, 0x70ff0404, 0x0400208c, 0x48484848, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x08000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x2,       0xe7f14e8e,
		0x001f0008, 0x20070000, 0x0036e946, 0x00001001, 0x10e0474f,
		0x00880358, 0x00130103, 0x00000000,	0x00000000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004cfb0, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000164e, 0x0003d55e, 0x000000f0,	0x00000001,
		0x00000400, 0x7f00e110, 0x08881e18, 0xb36d1858, 0x00007612,
		0x00000000, 0x77444444,	0x20e000fe, 0x00000101, 0x0c000100,
		0x80010909, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x50502070, 0x401020,
		0xd9801c0c, 0x21f00ff, 0x8080801c,	0x81f11111, 0x81f85852,
		0x00680068, 0x0487101c, 0x0000000f, 0x00000000, 0x00012002,
		0x00028040,	0x00000000, 0x08000000, 0x7f1ff000, 0x00000000,
		0x10101040, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x80000000, 0x00000000,
		0x00000000, 0xa00833da,	0xba5b0391, 0x000ae232, 0x00000000,
		0xf0080610, 0x3000180a, 0x9c10,    0x00000182, 0x00000000,
		0x81000002, 0x83020010, 0x000121ff, 0x000c0340, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x75777577, 0x00000000, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x00018018, 0x00040010, 0x00000000,
		0x00000000, 0x002468b5, 0x002fa63a, 0x0143a740,	0x00032864,
		0x00001b10, 0x0371d249, 0x0003ebde, 0x00032864, 0x00001b10,
		0x0371d249, 0x0003ebde,	0X00032864, 0x00001b10, 0x0371d249,
		0x0003ebde, 0x00032864, 0x00001b10, 0x0371d249, 0x0003ebde,
		/* addr: 0xa0 ~ 0xa4 */
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x20070000, 0x0, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000078,//ae
		0x16080000, 0x00030040, 0x80002000, 0xc0002000, 0xffff8080,//b3
		0xff00ff00, 0xff00ff00, 0x00004092, 0x00004092, 0x003c1e0f,//b8
		0x783c1e0f, 0x00088888, 0x00087654, 0x00086532, 0x00086420,//bd
		0x00080000, 0x40080160, 0x00050000, 0x10101010, 0x00000010,//c2
		0x75777577, 0x00000000, 0x00192718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x00018018, 0x00040010, 0x00000000, 0x00000000,
		0x00247e04, 0x002fa52a, 0x0143a2ef,	0x000327bf, 0x00001b03,
		0x0371b470, 0x0003f28b, 0x000327bf, 0x00001b03, 0x0371b470,
		0x0003f28b,	0x000327bf, 0x00001b03, 0x0371b470, 0x0003f28b,
		0x000327bf, 0x00001b03, 0x0371b470, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x0f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff

	}, /* TVIN_SIG_FMT_CVBS_NTSC_M, */
	{
		0x10101002, 0x10101010, 0x7f00e110, 0x08881e18, 0xb36d1858,
		0x00007612, 0x00000000, 0x77444444,	0x20e000fe, 0x00000101,
		0x0c000100, 0x80010909, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0x1010603c, 0x44060606, 0x08080044, 0x00080808,
		0x0c06844b, 0x40200808, 0x44440044, 0x00008c80,	0xf0008888,
		0xa0461006, 0x70ff0404, 0x0000208c, 0x48484848, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x10000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x00000002, 0xe7f14e8e,
		0x00140008, 0x20070000, 0x0036e946, 0x00001001, 0x10e0474f,
		0x00880358, 0x00120102, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d068, 0x00000000, 0x030000f0,
		0x0000000a, 0x000013f0, 0x0003d300, 0x000000f0,	0x00000001,
		0x00000400, 0x7f00e110, 0x08881e18, 0xb36d1858, 0x00007612,
		0x00000000, 0x77444444,	0x20e000fe, 0x00000101, 0x0c000100,
		0x80010909, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x40403070, 0x04281020,
		0x00000000, 0x021000ff, 0x80688030,	0x81f11111, 0x81f85852,
		0x00680068, 0x0487101c, 0x0000000f, 0x00000000, 0x00012002,
		0x00028040,	0x00000000, 0x10000000, 0x7f1ff000, 0x00000000,
		0x10101040, 0x40404040, 0x00000000, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x80000000, 0x00000000,
		0x00000000, 0xc00833da,	0xba5b0391, 0x000ae232, 0x00000000,
		0xf0080610, 0x60001808, 0x00009410, 0x00000003, 0x00000000,
		0x81018014, 0x03020010, 0x000121ff, 0x000c0340, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x75757577, 0x00000002, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x00018018, 0x00040010, 0x00000000,
		0x00000000, 0x01c12807, 0x00000000, 0x00000000,	0x000ff511,
		0x00000000, 0x0012198b, 0x037d7036, 0x000ff511, 0x00000000,
		0x0012198b, 0x037d7036,	0x000ff511, 0x00000000, 0x0012198b,
		0x037d7036, 0x000ff511, 0x00000000, 0x0012198b, 0x037d7036,
		/* addr: 0xa0 ~ 0xa4 */
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x20070000, 0x0, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000078,//ae
		0x16080000, 0x00030040, 0x80002000, 0xc0002000, 0xffff8080,//b3
		0xff00ff00, 0xff00ff00, 0x00004092, 0x00004092, 0x003c1e0f,//b8
		0x783c1e0f, 0x00088888, 0x00087654, 0x00086532, 0x00086420,//bd
		0x00080000, 0x40080160, 0x00050000, 0x10101010, 0x00000010,//c2
		0x75757577, 0x00000002, 0x00000718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x00018018, 0x00040010, 0x00000000, 0x00000000,
		0x01c08fed, 0x00000000, 0x00000000,	0x000feeef, 0x00000000,
		0x001213ab, 0x037b5071, 0x000feeef, 0x00000000, 0x001213ab,
		0x037b5071,	0x000feeef, 0x00000000, 0x001213ab, 0x037b5071,
		0x000feeef, 0x00000000, 0x001213ab, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,
	}, /* TVIN_SIG_FMT_CVBS_NTSC_443, */
	{
		0x22222202, 0x22222222, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0x1010403c, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x70ff0404, 0x400208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x08000000, 0x02020000,
		0x0209c832, 0x00000000, 0xfcf44396, 0x2,       0xe7f14e8e,
		0x00140008, 0x20800000, 0x00275a60, 0x00001001, 0x10e0474f,
		0x00890359, 0x00170137, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d206, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000523e, 0x0004114e, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x18188080, 0x601838,
		0xd9804c18, 0x020f00ff, 0x80808020,	0x88711111, 0x81f24742,
		0x80380038, 0x10000,   0x0000000f, 0x00000000, 0x00000000,
		0x00300000,	0x00000000, 0x08000000, 0x7f1ff000, 0x00000000,
		0x80c0c080, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0xa00833da,	0xba5b0391, 0x000ae232, 0x00000000,
		0xf0080610, 0x08104008, 0x2c10,    0x00000003, 0x00000000,
		0x88001002, 0x3020010, 0x000281ff, 0x000803c0, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x74777477, 0x00000000, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x18004,   0x00200000, 0x00000000,
		0x00000000, 0x00eb2aac, 0x00000000, 0x00000000,	0x001652f7,
		0x00000000, 0x00000000, 0x04974980, 0x001652f7, 0x00000000,
		0x00000000, 0x04974980,	0x001652f7, 0x00000000, 0x00000000,
		0x04974980, 0x001652f7, 0x00000000, 0x00000000, 0x04974980,
		/* addr: 0xa0 ~ 0xa4 */
		0x3f000100, 0x8f000004, 0x3f000100, 0x0f000004, 0x00000002,
		0x00000000, 0x00000002, 0x20070000, 0x0, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000078,//ae
		0x16050880, 0x00030040, 0x80002000, 0xc0002000, 0xffff8080,//b3
		0xff00ff00, 0xff00ff00, 0x00004090, 0x00004090, 0x003c1e0f,//b8
		0x783c1e0f, 0x00088888, 0x00087654, 0x00086532, 0x00086420,//bd
		0x00080000, 0x40080160, 0x00050000, 0x10101010, 0x00000010,//c2
		0x74777477, 0x00000000, 0x00192718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018004, 0x00200000, 0x00000000, 0x00000000,
		0x010d753b, 0x00000000, 0x00000000,	0x0018c65f, 0x00000000,
		0x00000000, 0x05520b96, 0x0018c65f, 0x00000000, 0x00000000,
		0x05520b96,	0x0018c65f, 0x00000000, 0x00000000, 0x05520b96,
		0x0018c65f, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100,
		0x8f000004, 0x00000002, 0x90000fff, 0x00000002, 0x90000fff,
		0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004, 0x00000002,
		0x90000fff, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,
	}, /* TVIN_SIG_FMT_CVBS_PAL_I, */
	{
		0x01010101, 0x01010101, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0xc0c0600f, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x40ff0400, 0x0427208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x10000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x00000102, 0xe7f14e8e,
		0x00142108, 0x00800000, 0x0026e905, 0x00001001, 0x10e0474f,
		0x00700340, 0x00100100, 0x000a0000,	0x00080000, 0x00000000,
		0x000a0000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d019, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000442d, 0x0004033d, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00205040, 0xf0f0c0c0,
		0xd9c00010, 0x020f00ff, 0x80808020,	0x81f11111, 0x81f24742,
		0x80400040, 0x03000000, 0x0000000f, 0x00000000, 0x00000000,
		0x00300000,	0x00000000, 0x10000000, 0x7f1ff000, 0x00000000,
		0x40404040, 0x40404040, 0x00000000, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0x2008f433,	0xb3640378, 0x000bdf37, 0x00000000,
		0xf0080610, 0x08104008, 0x00002410, 0x00000003, 0x00000000,
		0x00400040, 0x00080040, 0x000281ff, 0x000803c0, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x75767576, 0x00000002, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x80018018, 0x00800000, 0x00000000,
		0x00000000, 0x027d7b59, 0x00000000, 0x00000000,	0x001540c8,
		0x00000000, 0x00000000, 0x03ca7af4, 0x001540c8, 0x00000000,
		0x00000000, 0x03ca7af4,	0x001540c8, 0x00000000, 0x00000000,
		0x03ca7af4, 0x001540c8, 0x00000000, 0x00000000, 0x03ca7af4,
		/* addr: 0xa0 ~ 0xa4 */
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x20070000, 0x0, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000078,//ae
		0x16080000, 0x00030040, 0x80002000, 0xc0002000, 0xffff8080,//b3
		0xff00ff00, 0xff00ff00, 0x00004092, 0x00004092, 0x003c1e0f,//b8
		0x783c1e0f, 0x00088888, 0x00087654, 0x00086532, 0x00086420,//bd
		0x00080000, 0x40080160, 0x00050000, 0x10101010, 0x00000010,//c2
		0x75767576, 0x00000002, 0x00000718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018018, 0x00800000, 0x00000000, 0x00000000,
		0x0282ce1c, 0x00000000, 0x00000000,	0x00153fb2, 0x00000000,
		0x00000000, 0x03ca7c7c, 0x00153be2, 0x00000000, 0x00000000,
		0x03ca7c7c,	0x00153be2, 0x00000000, 0x00000000, 0x03ca7c7c,
		0x00153be2, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,
	}, /* TVIN_SIG_FMT_CVBS_PAL_M, */
	{
		0x01010101, 0x01010101, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0xc0c0600f, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x40ff0400, 0x0427208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x08000000, 0x02020000,
		0x0209c832, 0x00000000, 0xfcf44396, 0x00000102, 0xe7f14e8e,
		0x00140008, 0x20800000, 0x00275a60, 0x00001001, 0x10e0474f,
		0x00880358, 0x00130103, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d206, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000523e, 0x0004114e, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x08205070, 0x0050a0a0,
		0x00000000, 0x020f00ff, 0x80808020,	0x80711111, 0x81f24742,
		0x80380038, 0x03061010, 0x0000000f, 0x00000000, 0x00000000,
		0x00300000,	0x00000000, 0x08000000, 0x7f1ff000, 0x00000000,
		0x80c0c080, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0xa00833da,	0xba5b0391, 0x000ae232, 0x00000000,
		0xf0080610, 0x08104008, 0x00002410, 0x00000003, 0x00000000,
		0x88001002, 0x83024016, 0x000281ff, 0x000803c0, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x74777477, 0x00000000, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x80018004, 0x00200000, 0x00000000,
		0x00000000, 0x00eb2aac, 0x00000000, 0x00000000,	0x001652f7,
		0x00000000, 0x00000000, 0x04974980, 0x001652f7, 0x00000000,
		0x00000000, 0x04974980,	0x001652f7, 0x00000000, 0x00000000,
		0x04974980, 0x001652f7, 0x00000000, 0x00000000, 0x04974980,
		/* addr: 0xa0 ~ 0xa4 */
		0x3f000100, 0x8f000004, 0x3f000100, 0x0f000004, 0x00000002,
		0x00000000, 0x00000002, 0x20070000, 0x0, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000078,//ae
		0x16080000, 0x00030040, 0x80002000, 0xc0002000, 0xffff8080,//b3
		0xff00ff00, 0xff00ff00, 0x00004092, 0x00004092, 0x003c1e0f,//b8
		0x783c1e0f, 0x00088888, 0x00087654, 0x00086532, 0x00086420,//bd
		0x00080000, 0x40080160, 0x00050000, 0x10101010, 0x00000010,//c2
		0x74777477, 0x00000000, 0x00192718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018004, 0x00200000, 0x00000000, 0x00000000,
		0x010d753b, 0x00000000, 0x00000000,	0x0018c65f, 0x00000000,
		0x00000000, 0x05520b96, 0x0018c65f, 0x00000000, 0x00000000,
		0x05520b96,	0x0018c65f, 0x00000000, 0x00000000, 0x05520b96,
		0x0018c65f, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100,
		0x8f000004, 0x00000002, 0x90000fff, 0x00000002, 0x90000fff,
		0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004, 0x00000002,
		0x90000fff, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,
	}, /* TVIN_SIG_FMT_CVBS_PAL_60,the same to TVIN_SIG_FMT_CVBS_PAL_I */
	{
		0x01010101, 0x01010101, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0xc0c0600f, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x40ff0400, 0x0427208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x10000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x00000102, 0xe7f14e8e,
		0x00142108, 0x00800000, 0x002717d9, 0x00001001, 0x10e0474f,
		0x00700340, 0x00100100, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d1fb, 0x00000000, 0x030000f0,
		0x0000000a, 0x00005fef, 0x00041eff, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00205040, 0xf0f0c0c0,
		0xd9c00010, 0x020f00ff, 0x80808020,	0x81f11111, 0x81f24742,
		0x80400040, 0x03000000, 0x0000000f, 0x00000000, 0x00000000,
		0x00000000,	0x00000000, 0x10000000, 0x7f1ff000, 0x00000000,
		0x40404040, 0x40404040, 0x00000000, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0x2008f433,	0xb3640378, 0x000bdf37, 0x00000000,
		0xf0080610, 0x08104008, 0x00002410, 0x00000003, 0x00000000,
		0x00400040, 0x00080040, 0x00fff000, 0x00040000, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0xf3f6f4f8, 0x00000002, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x80018018, 0x00800000, 0x00000000,
		0x00000000, 0x00c2befd, 0x00000000, 0x00000000,	0x00047fcc,
		0x00000000, 0x00000000, 0x04591a41, 0x00047fcc, 0x00000000,
		0x00000000, 0x04591a41,	0x00047fcc, 0x00000000, 0x00000000,
		0x04591a41, 0x00047fcc, 0x00000000, 0x00000000, 0x04591a41,
		/* addr: 0xa0 ~ 0xa4 */
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x20070000, 0x0, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000078,//ae
		0x16050880, 0x00030040, 0x80002000, 0xc0002000, 0xffff8080,//b3
		0xff00ff00, 0xff00ff00, 0x00004090, 0x00004090, 0x003c1e0f,//b8
		0x783c1e0f, 0x00088888, 0x00087654, 0x00086532, 0x00086420,//bd
		0x00080000, 0x40080160, 0x00050000, 0x10101010, 0x00000010,//c2
		0xf3f6f4f8, 0x00000002, 0x00000718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018018, 0x00800000, 0x00000000, 0x00000000,
		0x00b57c68, 0x00000000, 0x00000000,	0x00042c0d, 0x00000000,
		0x00000000, 0x03dc2e7a, 0x00042c0d, 0x00000000, 0x00000000,
		0x03dc2e7a,	0x00042c0d, 0x00000000, 0x00000000, 0x03dc2e7a,
		0x00042c0d, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,
	}, /* TVIN_SIG_FMT_CVBS_PAL_CN, */
	{
		0x01010101, 0x01010101, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0xc0c0600f, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x40ff0400, 0x0427208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x10000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x00000102, 0xe7f14e8e,
		0x00140108, 0x00070000, 0x002717d9, 0x00001001, 0x10e0474f,
		0x00700340, 0x00170137, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d1fb, 0x00000000, 0x030000f0,
		0x0000000a, 0x00005fef, 0x00041eff, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x08205040, 0x0050c0c0,
		0x00000000, 0x020f00ff, 0x00808020,	0x81f11111, 0x81f24742,
		0x80200020, 0x03000000, 0x0000000f, 0x00000000, 0x00000000,
		0x00000000,	0x00000000, 0x10000000, 0x7f1ff000, 0x00000000,
		0x40404040, 0x40404040, 0x00000000, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0x2008f433,	0xb3640378, 0x000bdf37, 0x00000000,
		0xf0080610, 0x08104008, 0x00002410, 0x00000003, 0x00000000,
		0x00400040, 0x00080040, 0x00fff000, 0x00040000, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0xf3f6f4f8, 0x00000002, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x80018018, 0x00800000, 0x00000000,
		0x00000000, 0x00c2befd, 0x00000000, 0x00000000,	0x00047fcc,
		0x00000000, 0x00000000, 0x04591a41, 0x00047fcc, 0x00000000,
		0x00000000, 0x04591a41,	0x00047fcc, 0x00000000, 0x00000000,
		0x04591a41, 0x00047fcc, 0x00000000, 0x00000000, 0x04591a41,
		/* addr: 0xa0 ~ 0xa4 */
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x20070000, 0x0, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000078,//ae
		0x16050880, 0x00030040, 0x80002000, 0xc0002000, 0xffff8080,//b3
		0xff00ff00, 0xff00ff00, 0x00004090, 0x00004090, 0x003c1e0f,//b8
		0x783c1e0f, 0x00088888, 0x00087654, 0x00086532, 0x00086420,//bd
		0x00080000, 0x40080160, 0x00050000, 0x10101010, 0x00000010,//c2
		0xf3f6f4f8, 0x00000002, 0x00000718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018018, 0x00800000, 0x00000000, 0x00000000,
		0x00b57c68, 0x00000000, 0x00000000,	0x00042c0d, 0x00000000,
		0x00000000, 0x03dc2e7a, 0x00042c0d, 0x00000000, 0x00000000,
		0x03dc2e7a,	0x00042c0d, 0x00000000, 0x00000000, 0x03dc2e7a,
		0x00042c0d, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,

	}, /* TVIN_SIG_FMT_CVBS_SECAM, */
	{
		0x22222202, 0x22222222, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0x1010403c, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x70ff0404, 0x400208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x08000000, 0x02020000,
		0x0209c832, 0x00000000, 0xfcf44396, 0x2,       0xe7f14e8e,
		0x00140008, 0x20800000, 0x00275a60, 0x00001001, 0x10e0474f,
		0x00890359, 0x00170137, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d206, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000523e, 0x0004114e, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x18188080, 0x601838,
		0xd9804c18, 0x020f00ff, 0x80808020,	0x88711111, 0x81f24742,
		0x80380038, 0x10000,   0x0000000f, 0x00000000, 0x00000000,
		0x00300000,	0x00000000, 0x08000000, 0x7f1ff000, 0x00000000,
		0x80c0c080, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0xa00833da,	0xba5b0391, 0x000ae232, 0x00000000,
		0xf0080610, 0x08104008, 0x2c10,    0x00000003, 0x00000000,
		0x88001002, 0x3020010, 0x000281ff, 0x000803c0, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x74777477, 0x00000000, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x18004,   0x00200000, 0x00000000,
		0x00000000, 0x00eb2aac, 0x00000000, 0x00000000,	0x001652f7,
		0x00000000, 0x00000000, 0x04974980, 0x001652f7, 0x00000000,
		0x00000000, 0x04974980,	0x001652f7, 0x00000000, 0x00000000,
		0x04974980, 0x001652f7, 0x00000000, 0x00000000, 0x04974980,
		/* addr: 0xa0 ~ 0xa4 */
		0x3f000100, 0x8f000004, 0x3f000100, 0x0f000004, 0x00000002,
		0x00000000, 0x00000002, 0x20070000, 0x0, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000078,//ae
		0x16050880, 0x00030040, 0x80002000, 0xc0002000, 0xffff8080,//b3
		0xff00ff00, 0xff00ff00, 0x00004090, 0x00004090, 0x003c1e0f,//b8
		0x783c1e0f, 0x00088888, 0x00087654, 0x00086532, 0x00086420,//bd
		0x00080000, 0x40080160, 0x00050000, 0x10101010, 0x00000010,//c2
		0x74777477, 0x00000000, 0x00192718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018004, 0x00200000, 0x00000000, 0x00000000,
		0x010d753b, 0x00000000, 0x00000000,	0x0018c65f, 0x00000000,
		0x00000000, 0x05520b96, 0x0018c65f, 0x00000000, 0x00000000,
		0x05520b96,	0x0018c65f, 0x00000000, 0x00000000, 0x05520b96,
		0x0018c65f, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100,
		0x8f000004, 0x00000002, 0x90000fff, 0x00000002, 0x90000fff,
		0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004, 0x00000002,
		0x90000fff, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,

	}, /* TVIN_SIG_FMT_CVBS_NTSC_50, */
};
EXPORT_SYMBOL(cvbs_acd_table_tm2_b);

const unsigned int rf_acd_table_tm2_b[TVIN_SIG_FMT_CVBS_NTSC_50 -
				TVIN_SIG_FMT_CVBS_NTSC_M+1][ACD_REG_NUM+1] = {
	{
		0x10101002, 0x0,       0x7f00e110, 0x08881e18, 0xb36d1858,
		0x00007612, 0x00000000, 0x77444444,	0x20e000fe, 0x00000101,
		0x0c000100, 0x80010909, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0x1010403c, 0x44060606, 0x08080044, 0x00080808,
		0xc006844b, 0x40200808, 0x44440044, 0x00008c80,	0xf0008888,
		0xa0461006, 0x70ff0404, 0x0400208c, 0x48484848, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x08000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x2,       0xe7f14e8e,
		0x001f0008, 0x20070000, 0x0036e946, 0x00001001, 0x10e0474f,
		0x00880358, 0x00130103, 0x00000000,	0x00000000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004cfb0, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000164e, 0x0003d55e, 0x000000f0,	0x00000001,
		0x00000400, 0x7f00e110, 0x08881e18, 0xb36d1858, 0x00007612,
		0x00000000, 0x77444444,	0x20e000fe, 0x00000101, 0x0c000100,
		0x80010909, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x50502070, 0x401020,
		0xd9801c0c, 0x21f00ff, 0x8080801c,	0x81f11111, 0x81f85852,
		0x00680068, 0x0487101c, 0x0000000f, 0x00000000, 0x00012002,
		0x00028040,	0x00000000, 0x08000000, 0x7f1ff000, 0x00000000,
		0x10101040, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x80000000, 0x00000000,
		0x00000000, 0xa00833da,	0xba5b0391, 0x000ae232, 0x00000000,
		0xf0080610, 0x3000180a, 0x9c10,    0x00000182, 0x00000000,
		0x81000002, 0x83020010, 0x000121ff, 0x000c0340, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x75777577, 0x00000000, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x00018018, 0x00040010, 0x00000000,
		0x00000000, 0x002468b5, 0x002fa63a, 0x0143a740,	0x00032864,
		0x00001b10, 0x0371d249, 0x0003ebde, 0x00032864, 0x00001b10,
		0x0371d249, 0x0003ebde,	0X00032864, 0x00001b10, 0x0371d249,
		0x0003ebde, 0x00032864, 0x00001b10, 0x0371d249, 0x0003ebde,
		/* addr: 0xa0 ~ 0xa4 */
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x20070000, 0x0, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000078,//ae
		0x16080000, 0x00030040, 0x80002000, 0xc0002000, 0xffff8080,//b3
		0xff00ff00, 0xff00ff00, 0x00004092, 0x00004092, 0x003c1e0f,//b8
		0x783c1e0f, 0x00088888, 0x00087654, 0x00086532, 0x00086420,//bd
		0x00080000, 0x40080160, 0x00050000, 0x10101010, 0x00000010,//c2
		0x75777577, 0x00000000, 0x00192718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x00018018, 0x00040010, 0x00000000, 0x00000000,
		0x00247e04, 0x002fa52a, 0x0143a2ef,	0x000327bf, 0x00001b03,
		0x0371b470, 0x0003f28b, 0x000327bf, 0x00001b03, 0x0371b470,
		0x0003f28b,	0x000327bf, 0x00001b03, 0x0371b470, 0x0003f28b,
		0x000327bf, 0x00001b03, 0x0371b470, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x0f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff
	}, /* TVIN_SIG_FMT_CVBS_NTSC_M, */
	{
		0x10101002, 0x10101010, 0x7f00e110, 0x08881e18, 0xb36d1858,
		0x00007612, 0x00000000, 0x77444444,	0x20e000fe, 0x00000101,
		0x0c000100, 0x80010909, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0x1010603c, 0x44060606, 0x08080044, 0x00080808,
		0x0c06844b, 0x40200808, 0x44440044, 0x00008c80,	0xf0008888,
		0xa0461006, 0x70ff0404, 0x0000208c, 0x48484848, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x10000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x00000102, 0xe7f14e8e,
		0x00140008, 0x20070000, 0x0036e946, 0x00001001, 0x10e0474f,
		0x00880358, 0x00120102, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d068, 0x00000000, 0x030000f0,
		0x0000000a, 0x000013f0, 0x0003d300, 0x000000f0,	0x00000001,
		0x00000400, 0x7f00e110, 0x08881e18, 0xb36d1858, 0x00007612,
		0x00000000, 0x77444444,	0x20e000fe, 0x00000101, 0x0c000100,
		0x80010909, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x40403070, 0x04281020,
		0x00000000, 0x021000ff, 0x80688030,	0x81f11111, 0x81f85852,
		0x00680068, 0x0487101c, 0x0000000f, 0x00000000, 0x00012002,
		0x00028040,	0x00000000, 0x10000000, 0x7f1ff000, 0x00000000,
		0x10101040, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x80000000, 0x00000000,
		0x00000000, 0x2008f433,	0xb3630387, 0x000bdf37, 0x00000000,
		0xf0080610, 0x60001808, 0x00009410, 0x00000003, 0x00000000,
		0x81018014, 0x83020010, 0x000121ff, 0x000c0340, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x75757577, 0x00000002, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x00018018, 0x00040010, 0x00000000,
		0x00000000, 0x01c12807, 0x00000000, 0x00000000,	0x000ff511,
		0x00000000, 0x0012198b, 0x037d7036, 0x000ff511, 0x00000000,
		0x0012198b, 0x037d7036,	0x000ff511, 0x00000000, 0x0012198b,
		0x037d7036, 0x000ff511, 0x00000000, 0x0012198b, 0x037d7036,
		/* addr: 0xa0 ~ 0xa4 */
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x20070000, 0x0, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000078,//ae
		0x16080000, 0x00030040, 0x80002000, 0xc0002000, 0xffff8080,//b3
		0xff00ff00, 0xff00ff00, 0x00004092, 0x00004092, 0x003c1e0f,//b8
		0x783c1e0f, 0x00088888, 0x00087654, 0x00086532, 0x00086420,//bd
		0x00080000, 0x40080160, 0x00050000, 0x10101010, 0x00000010,//c2
		0x75757577, 0x00000002, 0x00000718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x00018018, 0x00040010, 0x00000000, 0x00000000,
		0x01c08fed, 0x00000000, 0x00000000,	0x000feeef, 0x00000000,
		0x001213ab, 0x037b5071, 0x000feeef, 0x00000000, 0x001213ab,
		0x037b5071,	0x000feeef, 0x00000000, 0x001213ab, 0x037b5071,
		0x000feeef, 0x00000000, 0x001213ab, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,

	}, /* TVIN_SIG_FMT_CVBS_NTSC_443, */
	{
		0x22222202, 0x22222222, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0x1010403c, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x70ff0404, 0x208c,    0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x08000000, 0x02020000,
		0x0209c832, 0x00000000, 0xfcf44396, 0x2,       0xe7f14e8e,
		0x00140008, 0x20800000, 0x00275a60, 0x00001001, 0x10e0474f,
		0x00890359, 0x00170137, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d206, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000523e, 0x0004114e, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x28284080, 0x602020,
		0xd9804c08, 0x020f00ff, 0x80808020,	0x88711111, 0x81f24742,
		0x80380038, 0x10000,   0x0000000f, 0x00000000, 0x00000000,
		0x00300000,	0x00000000, 0x08000000, 0x7f1ff000, 0x00000000,
		0x80c0c080, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0xa00833da,	0xba5b0391, 0x000ae232, 0x00000000,
		0xf0080610, 0x08104008, 0x2c10,    0x00000003, 0x00000000,
		0x88001002, 0x3020010, 0x000281ff, 0x000803c0, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x74777477, 0x00000000, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x18004,   0x00200000, 0x00000000,
		0x00000000, 0x00eb2aac, 0x00000000, 0x00000000,	0x001652f7,
		0x00000000, 0x00000000, 0x04974980, 0x001652f7, 0x00000000,
		0x00000000, 0x04974980,	0x001652f7, 0x00000000, 0x00000000,
		0x04974980, 0x001652f7, 0x00000000, 0x00000000, 0x04974980,
		/* addr: 0xa0 ~ 0xa4 */
		0x3f000100, 0x8f000004, 0x3f000100, 0x0f000004, 0x00000002,
		0x00000000, 0x00000002, 0x20070000, 0x0, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000078,//ae
		0x16050880, 0x00030040, 0x80002000, 0xc0002000, 0xffff8080,//b3
		0xff00ff00, 0xff00ff00, 0x00004090, 0x00004090, 0x003c1e0f,//b8
		0x783c1e0f, 0x00088888, 0x00087654, 0x00086532, 0x00086420,//bd
		0x00080000, 0x40080160, 0x00050000, 0x10101010, 0x00000010,//c2
		0x74777477, 0x00000000, 0x00192718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018004, 0x00200000, 0x00000000, 0x00000000,
		0x010d753b, 0x00000000, 0x00000000,	0x0018c65f, 0x00000000,
		0x00000000, 0x05520b96, 0x0018c65f, 0x00000000, 0x00000000,
		0x05520b96,	0x0018c65f, 0x00000000, 0x00000000, 0x05520b96,
		0x0018c65f, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100,
		0x8f000004, 0x00000002, 0x90000fff, 0x00000002, 0x90000fff,
		0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004, 0x00000002,
		0x90000fff, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,

	}, /* TVIN_SIG_FMT_CVBS_PAL_I, */
	{
		0x01010101, 0x01010101, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0xc0c0600f, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x40ff0400, 0x0427208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x10000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x00000102, 0xe7f14e8e,
		0x00140108, 0x00800000, 0x0026e905, 0x00001001, 0x10e0474f,
		0x00880358, 0x00130103, 0x000a0000,	0x00080000, 0x00000000,
		0x000a0000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d019, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000442d, 0x0004033d, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00205040, 0xf0f0c0c0,
		0xd9c00010, 0x020f00ff, 0x00808020,	0x81f11111, 0x81f24742,
		0x80400040, 0x03000000, 0x0000000f, 0x00000000, 0x00000000,
		0x80300000,	0x00000000, 0x10000000, 0x7f1ff000, 0x00000000,
		0x40404040, 0x40404040, 0x00000000, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0x2008f433,	0xb3640378, 0x000bdf37, 0x00000000,
		0xf0080610, 0x08104008, 0x00002410, 0x00000003, 0x00000000,
		0x00400040, 0x00080040, 0x000281ff, 0x000803c0, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x75767576, 0x00000002, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x80018018, 0x00800000, 0x00000000,
		0x00000000, 0x027d7b59, 0x00000000, 0x00000000,	0x001540c8,
		0x00000000, 0x00000000, 0x03ca7af4, 0x001540c8, 0x00000000,
		0x00000000, 0x03ca7af4,	0x001540c8, 0x00000000, 0x00000000,
		0x03ca7af4, 0x001540c8, 0x00000000, 0x00000000, 0x03ca7af4,
		/* addr: 0xa0 ~ 0xa4 */
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x20070000, 0x0, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000078,//ae
		0x16080000, 0x00030040, 0x80002000, 0xc0002000, 0xffff8080,//b3
		0xff00ff00, 0xff00ff00, 0x00004092, 0x00004092, 0x003c1e0f,//b8
		0x783c1e0f, 0x00088888, 0x00087654, 0x00086532, 0x00086420,//bd
		0x00080000, 0x40080160, 0x00050000, 0x10101010, 0x00000010,//c2
		0x75767576, 0x00000002, 0x00000718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018018, 0x00800000, 0x00000000, 0x00000000,
		0x0282ce1c, 0x00000000, 0x00000000,	0x00153fb2, 0x00000000,
		0x00000000, 0x03ca7c7c, 0x00153be2, 0x00000000, 0x00000000,
		0x03ca7c7c,	0x00153be2, 0x00000000, 0x00000000, 0x03ca7c7c,
		0x00153be2, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,

	}, /* TVIN_SIG_FMT_CVBS_PAL_M, */
	{
		0x01010101, 0x01010101, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0xc0c0600f, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x40ff0400, 0x0427208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x08000000, 0x02020000,
		0x0209c832, 0x00000000, 0xfcf44396, 0x00000102, 0xe7f14e8e,
		0x00140008, 0x20800000, 0x00275a60, 0x00001001, 0x10e0474f,
		0x00880358, 0x00130103, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d206, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000523e, 0x0004114e, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x08205070, 0x0050a0a0,
		0x00000000, 0x020f00ff, 0x80808020,	0x80711111, 0x81f24742,
		0x80380038, 0x03061010, 0x0000000f, 0x00000000, 0x00000000,
		0x00300000,	0x00000000, 0x08000000, 0x7f1ff000, 0x00000000,
		0x80c0c080, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0x2008f433,	0xb3630387, 0x000bdf37, 0x00000000,
		0xf0080610, 0x08104008, 0x00002410, 0x00000003, 0x00000000,
		0x88001002, 0x83024016, 0x000281ff, 0x000803c0, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x74777477, 0x00000000, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x80018004, 0x00200000, 0x00000000,
		0x00000000, 0x00eb2aac, 0x00000000, 0x00000000,	0x001652f7,
		0x00000000, 0x00000000, 0x04974980, 0x001652f7, 0x00000000,
		0x00000000, 0x04974980,	0x001652f7, 0x00000000, 0x00000000,
		0x04974980, 0x001652f7, 0x00000000, 0x00000000, 0x04974980,
		/* addr: 0xa0 ~ 0xa4 */
		0x3f000100, 0x8f000004, 0x3f000100, 0x0f000004, 0x00000002,
		0x00000000, 0x00000002, 0x20070000, 0x0, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000078,//ae
		0x16080000, 0x00030040, 0x80002000, 0xc0002000, 0xffff8080,//b3
		0xff00ff00, 0xff00ff00, 0x00004092, 0x00004092, 0x003c1e0f,//b8
		0x783c1e0f, 0x00088888, 0x00087654, 0x00086532, 0x00086420,//bd
		0x00080000, 0x40080160, 0x00050000, 0x10101010, 0x00000010,//c2
		0x74777477, 0x00000000, 0x00192718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018004, 0x00200000, 0x00000000, 0x00000000,
		0x010d753b, 0x00000000, 0x00000000,	0x0018c65f, 0x00000000,
		0x00000000, 0x05520b96, 0x0018c65f, 0x00000000, 0x00000000,
		0x05520b96,	0x0018c65f, 0x00000000, 0x00000000, 0x05520b96,
		0x0018c65f, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100,
		0x8f000004, 0x00000002, 0x90000fff, 0x00000002, 0x90000fff,
		0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004, 0x00000002,
		0x90000fff, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,

	}, /* TVIN_SIG_FMT_CVBS_PAL_60,the same to TVIN_SIG_FMT_CVBS_PAL_I */
	{
		0x01010101, 0x01010101, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0xc0c0600f, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x40ff0400, 0x0427208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x10000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x00000102, 0xe7f14e8e,
		0x00142108, 0x00800000, 0x002717d9, 0x00001001, 0x10e0474f,
		0x00700340, 0x00100100, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d1fb, 0x00000000, 0x030000f0,
		0x0000000a, 0x00005fef, 0x00041eff, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00205040, 0xf0f0c0c0,
		0xd9c00010, 0x020f00ff, 0x80808020,	0x81f11111, 0x81f24742,
		0x80400040, 0x03000000, 0x0000000f, 0x00000000, 0x00000000,
		0x00000000,	0x00000000, 0x10000000, 0x7f1ff000, 0x00000000,
		0x40404040, 0x40404040, 0x00000000, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0x2008f433,	0xb3640378, 0x000bdf37, 0x00000000,
		0xf0080610, 0x08104008, 0x00002410, 0x00000003, 0x00000000,
		0x00400040, 0x00080040, 0x00fff000, 0x00040000, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0xf3f6f4f8, 0x00000002, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x80018018, 0x00800000, 0x00000000,
		0x00000000, 0x00c2befd, 0x00000000, 0x00000000,	0x00047fcc,
		0x00000000, 0x00000000, 0x04591a41, 0x00047fcc, 0x00000000,
		0x00000000, 0x04591a41,	0x00047fcc, 0x00000000, 0x00000000,
		0x04591a41, 0x00047fcc, 0x00000000, 0x00000000, 0x04591a41,
		/* addr: 0xa0 ~ 0xa4 */
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x20070000, 0x0, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000078,//ae
		0x16050880, 0x00030040, 0x80002000, 0xc0002000, 0xffff8080,//b3
		0xff00ff00, 0xff00ff00, 0x00004090, 0x00004090, 0x003c1e0f,//b8
		0x783c1e0f, 0x00088888, 0x00087654, 0x00086532, 0x00086420,//bd
		0x00080000, 0x40080160, 0x00050000, 0x10101010, 0x00000010,//c2
		0xf3f6f4f8, 0x00000002, 0x00000718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018018, 0x00800000, 0x00000000, 0x00000000,
		0x00b57c68, 0x00000000, 0x00000000,	0x00042c0d, 0x00000000,
		0x00000000, 0x03dc2e7a, 0x00042c0d, 0x00000000, 0x00000000,
		0x03dc2e7a,	0x00042c0d, 0x00000000, 0x00000000, 0x03dc2e7a,
		0x00042c0d, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,

	}, /* TVIN_SIG_FMT_CVBS_PAL_CN, */
	{
		0x01010101, 0x01010101, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0xc0c0600f, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x40ff0400, 0x0427208c, 0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x10000000, 0x02020000,
		0x0209c832, 0x00000000, 0xeafb4e8e, 0x00000102, 0xe7f14e8e,
		0x00140108, 0x00070000, 0x002717d9, 0x00001001, 0x10e0474f,
		0x00700340, 0x00170137, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d1fb, 0x00000000, 0x030000f0,
		0x0000000a, 0x00005fef, 0x00041eff, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x08205040, 0x0050c0c0,
		0x00000000, 0x020f00ff, 0x80808020,	0x81f11111, 0x81f24742,
		0x80200020, 0x03000000, 0x0000000f, 0x00000000, 0x00000000,
		0x00000000,	0x00000000, 0x10000000, 0x7f1ff000, 0x00000000,
		0x40404040, 0x40404040, 0x00000000, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0x2008f433,	0xb3640378, 0x000bdf37, 0x00000000,
		0xf0080610, 0x08104008, 0x00002410, 0x00000003, 0x00000000,
		0x00400040, 0x00080040, 0x00fff000, 0x00040000, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0xf3f6f4f8, 0x00000002, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x80018018, 0x00800000, 0x00000000,
		0x00000000, 0x00c2befd, 0x00000000, 0x00000000,	0x00047fcc,
		0x00000000, 0x00000000, 0x04591a41, 0x00047fcc, 0x00000000,
		0x00000000, 0x04591a41,	0x00047fcc, 0x00000000, 0x00000000,
		0x04591a41, 0x00047fcc, 0x00000000, 0x00000000, 0x04591a41,
		/* addr: 0xa0 ~ 0xa4 */
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x00000000, 0x00000000, 0x20070000, 0x0, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000078,//ae
		0x16050880, 0x00030040, 0x80002000, 0xc0002000, 0xffff8080,//b3
		0xff00ff00, 0xff00ff00, 0x00004090, 0x00004090, 0x003c1e0f,//b8
		0x783c1e0f, 0x00088888, 0x00087654, 0x00086532, 0x00086420,//bd
		0x00080000, 0x40080160, 0x00050000, 0x10101010, 0x00000010,//c2
		0xf3f6f4f8, 0x00000002, 0x00000718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018018, 0x00800000, 0x00000000, 0x00000000,
		0x00b57c68, 0x00000000, 0x00000000,	0x00042c0d, 0x00000000,
		0x00000000, 0x03dc2e7a, 0x00042c0d, 0x00000000, 0x00000000,
		0x03dc2e7a,	0x00042c0d, 0x00000000, 0x00000000, 0x03dc2e7a,
		0x00042c0d, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff,
		0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000, 0x3f000100,
		0x0fff0000, 0x00000000, 0x90000fff, 0x00000000, 0x90000fff,
		0x3f000100, 0x0fff0000, 0x3f000100, 0x0fff0000, 0x00000000,
		0x90000fff, 0x00000000, 0x90000fff,	0x3f000100, 0x0fff0000,
		0x3f000100, 0x0fff0000, 0x00000000, 0x90000fff, 0x00000000,
		0x90000fff,
	}, /* TVIN_SIG_FMT_CVBS_SECAM, */
	{
		0x22222202, 0x22222222, 0x00004110, 0x08881e28, 0xe4962858,
		0x00008e19, 0x00000000, 0x66666442,	0x20e00044, 0x00000101,
		0x00000000, 0x80010101, 0x00000000, 0x00000000, 0x00000000,
		0x00000000,	0x1010403c, 0x44441010, 0x10100444, 0x00101010,
		0x40c09008, 0x44808080, 0x44440844, 0x00008c80,	0x01008888,
		0x30100c01, 0x70ff0404, 0x208c,    0x88888888, 0x00004444,
		0x00000000, 0x00000000,	0x00000000, 0x08000000, 0x02020000,
		0x0209c832, 0x00000000, 0xfcf44396, 0x2,       0xe7f14e8e,
		0x00140008, 0x20800000, 0x00275a60, 0x00001001, 0x10e0474f,
		0x00890359, 0x00170137, 0x00000000,	0x00070000, 0x00000000,
		0x00000000, 0x00000050, 0x00000000, 0x000003ff, 0x00000000,
		0x00000000,	0x00000000, 0x0004d206, 0x00000000, 0x030000f0,
		0x0000000a, 0x0000523e, 0x0004114e, 0x000000f0,	0x00000001,
		0x00000400, 0x00004110, 0x08881e28, 0xe4962858, 0x00008e19,
		0x00000000, 0x66666442,	0x20e00044, 0x00000101, 0x00000000,
		0x80010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x28284080, 0x602020,
		0xd9804c08, 0x020f00ff, 0x80808020,	0x88711111, 0x81f24742,
		0x80380038, 0x10000,   0x0000000f, 0x00000000, 0x00000000,
		0x00300000,	0x00000000, 0x08000000, 0x7f1ff000, 0x00000000,
		0x80c0c080, 0x40404040, 0x80000f5c, 0xff000000,	0x00000000,
		0x00000000, 0x00ffffff, 0x00000fff, 0x00000000, 0x00000000,
		0x00000000, 0xa00833da,	0xba5b0391, 0x000ae232, 0x00000000,
		0xf0080610, 0x08104008, 0x2c10,    0x00000003, 0x00000000,
		0x88001002, 0x3020010, 0x000281ff, 0x000803c0, 0x40305c1c,
		0x00d63650, 0x00c184af, 0x00c1837f,	0x00c18329, 0x01000100,
		0x43062222, 0x74777477, 0x00000000, 0x00000718, 0x9968edd6,
		0x3553fab0,	0x026f2865, 0x18004,   0x00200000, 0x00000000,
		0x00000000, 0x00eb2aac, 0x00000000, 0x00000000,	0x001652f7,
		0x00000000, 0x00000000, 0x04974980, 0x001652f7, 0x00000000,
		0x00000000, 0x04974980,	0x001652f7, 0x00000000, 0x00000000,
		0x04974980, 0x001652f7, 0x00000000, 0x00000000, 0x04974980,
		/* addr: 0xa0 ~ 0xa4 */
		0x3f000100, 0x8f000004, 0x3f000100, 0x0f000004, 0x00000002,
		0x00000000, 0x00000002, 0x20070000, 0x0, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000078,//ae
		0x16050880, 0x00030040, 0x80002000, 0xc0002000, 0xffff8080,//b3
		0xff00ff00, 0xff00ff00, 0x00004090, 0x00004090, 0x003c1e0f,//b8
		0x783c1e0f, 0x00088888, 0x00087654, 0x00086532, 0x00086420,//bd
		0x00080000, 0x40080160, 0x00050000, 0x10101010, 0x00000010,//c2
		0x74777477, 0x00000000, 0x00192718, 0x9968edd6, 0x3553fab0,
		0x026f2865, 0x80018004, 0x00200000, 0x00000000, 0x00000000,
		0x010d753b, 0x00000000, 0x00000000,	0x0018c65f, 0x00000000,
		0x00000000, 0x05520b96, 0x0018c65f, 0x00000000, 0x00000000,
		0x05520b96,	0x0018c65f, 0x00000000, 0x00000000, 0x05520b96,
		0x0018c65f, 0x00000000, 0x00000000, 0x00000003,	0x3f000100,
		0x8f000004, 0x3f000100, 0x8f000004, 0x00000002, 0x90000fff,
		0x00000002, 0x90000fff,	0x3f000100, 0x8f000004, 0x3f000100,
		0x8f000004, 0x00000002, 0x90000fff, 0x00000002, 0x90000fff,
		0x3f000100, 0x8f000004, 0x3f000100, 0x8f000004, 0x00000002,
		0x90000fff, 0x00000002, 0x90000fff,	0x3f000100, 0x8f000004,
		0x3f000100, 0x8f000004, 0x00000002, 0x90000fff, 0x00000002,
		0x90000fff,
	}, /* TVIN_SIG_FMT_CVBS_NTSC_50, */
};
EXPORT_SYMBOL(rf_acd_table_tm2_b);

/* 0x00-0x03 */
const unsigned char cvd_yc_reg_0x00_0x03[TVIN_SIG_FMT_CVBS_NTSC_50 -
					 TVIN_SIG_FMT_CVBS_NTSC_M + 1][4] = {
	{
		0x01, 0x08, 0x42, 0x22,
	}, /* TVIN_SIG_FMT_CVBS_NTSC_M, */
	{
		0x01, 0x08, 0x42, 0x22,
	}, /* TVIN_SIG_FMT_CVBS_NTSC_443, */
	{
		0x33, 0x08, 0x42, 0x22,
	}, /* TVIN_SIG_FMT_CVBS_PAL_I, */
	{
		0x00, 0x08, 0x42, 0x22,
	}, /* TVIN_SIG_FMT_CVBS_PAL_M, */
	{
		0x00, 0x08, 0x42, 0x22,
	}, /* TVIN_SIG_FMT_CVBS_PAL_60, */
	{
		0x00, 0x08, 0x42, 0x22,
	}, /* TVIN_SIG_FMT_CVBS_PAL_CN, */
	{
		0x00, 0x08, 0x42, 0x22,
	}, /* TVIN_SIG_FMT_CVBS_SECAM, */
	{
		0x33, 0x08, 0x42, 0x22,
	}, /* TVIN_SIG_FMT_CVBS_NTSC_50, */
};
EXPORT_SYMBOL(cvd_yc_reg_0x00_0x03);

/* 0x18-0x1f */
const unsigned char cvd_yc_reg_0x18_0x1f[TVIN_SIG_FMT_CVBS_NTSC_50 -
					 TVIN_SIG_FMT_CVBS_NTSC_M + 1][8] = {
	{
		0x21, 0xf0, 0x7c, 0x1f, 0x24, 0x00, 0x00, 0x00,
	}, /* TVIN_SIG_FMT_CVBS_NTSC_M, */
	{
		0x21, 0xf0, 0x7c, 0x1f, 0x24, 0x00, 0x00, 0x00,
	}, /* TVIN_SIG_FMT_CVBS_NTSC_443, */
	{
		0x2f, 0x4a, 0xbc, 0x24, 0x24, 0x00, 0x00, 0x00,
	}, /* TVIN_SIG_FMT_CVBS_PAL_I, */
	{
		0x21, 0xe6, 0xef, 0xa4, 0x24, 0x00, 0x00, 0x00,
	}, /* TVIN_SIG_FMT_CVBS_PAL_M, */
	{
		0x21, 0xf6, 0x94, 0x46, 0x24, 0x00, 0x00, 0x00,
	}, /* TVIN_SIG_FMT_CVBS_PAL_60, */
	{
		0x21, 0xf6, 0x94, 0x46, 0x24, 0x00, 0x00, 0x00,
	}, /* TVIN_SIG_FMT_CVBS_PAL_CN, */
	{
		0x28, 0xa3, 0x3b, 0xb2, 0x24, 0x00, 0x00, 0x00,
	}, /* TVIN_SIG_FMT_CVBS_SECAM, */
	{
		0x2f, 0x4a, 0xbc, 0x24, 0x24, 0x00, 0x00, 0x00,
	}, /* TVIN_SIG_FMT_CVBS_NTSC_50, */
};
EXPORT_SYMBOL(cvd_yc_reg_0x18_0x1f);

MODULE_LICENSE("GPL");

