/*
 * drivers/amlogic/media/enhancement/amvecm/amcm_regmap.h
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#ifndef __AM_CM_REGMAP_H
#define __AM_CM_REGMAP_H

#include <linux/amlogic/media/amvecm/cm.h>
#include "arch/vpp_regs.h"

static struct am_regs_s cmreg_lever1 = {
	172,
	{
	/* optimize */
	{REG_TYPE_INDEX_VPPCHROMA,	512,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPPCHROMA,	513,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPPCHROMA,	514,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPPCHROMA,	515,	    0xffffffff,	134218752   },
	{REG_TYPE_INDEX_VPPCHROMA,	516,	    0xffffffff,	144         },
	{REG_TYPE_INDEX_VPPCHROMA,	518,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPPCHROMA,	519,	    0xffffffff,	33554432    },
	{REG_TYPE_INDEX_VPPCHROMA,	520,	    0xffffffff,	118         },
	{REG_TYPE_INDEX_VPPCHROMA,	521,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPPCHROMA,	522,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPPCHROMA,	527,	    0xf,	0           },
	{REG_TYPE_INDEX_VPPCHROMA,	517,	    0xffffffff,	70715263    },
	{REG_TYPE_INDEX_VPP_COEF,	256,	    0xffffffff,	532992      },
	{REG_TYPE_INDEX_VPP_COEF,	257,	    0xffffffff,	0xf3f600af  },
	{REG_TYPE_INDEX_VPP_COEF,	258,	    0xffffffff,	0xe3000000  },
	{REG_TYPE_INDEX_VPP_COEF,	259,	    0xffffffff,	240         },
	{REG_TYPE_INDEX_VPP_COEF,	260,	    0xffffffff,	63506       },
	{REG_TYPE_INDEX_VPP_COEF,	264,	    0xffffffff,	16650496    },
	{REG_TYPE_INDEX_VPP_COEF,	265,	    0xffffffff,	249         },
	{REG_TYPE_INDEX_VPP_COEF,	266,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	267,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	268,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	272,	    0xffffffff,	135936      },
	{REG_TYPE_INDEX_VPP_COEF,	273,	    0xffffffff,	253         },
	{REG_TYPE_INDEX_VPP_COEF,	274,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	275,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	276,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	280,	    0xffffffff,	0xf3f11300  },
	{REG_TYPE_INDEX_VPP_COEF,	281,	    0xffffffff,	214         },
	{REG_TYPE_INDEX_VPP_COEF,	282,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	283,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	284,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	288,	    0xffffffff,	0xede91300  },
	{REG_TYPE_INDEX_VPP_COEF,	289,	    0xffffffff,	177         },
	{REG_TYPE_INDEX_VPP_COEF,	290,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	291,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	292,	    0xffffffff,	15660544    },
	{REG_TYPE_INDEX_VPP_COEF,	296,	    0xffffffff,	0xe9e61100  },
	{REG_TYPE_INDEX_VPP_COEF,	297,	    0xffffffff,	184         },
	{REG_TYPE_INDEX_VPP_COEF,	298,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	299,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	300,	    0xffffffff,	15464448    },
	{REG_TYPE_INDEX_VPP_COEF,	304,	    0xffffffff,	0xeff80f00  },
	{REG_TYPE_INDEX_VPP_COEF,	305,	    0xffffffff,	232         },
	{REG_TYPE_INDEX_VPP_COEF,	306,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	307,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	308,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	312,	    0xffffffff,	0xf60a0d00  },
	{REG_TYPE_INDEX_VPP_COEF,	313,	    0xffffffff,	245         },
	{REG_TYPE_INDEX_VPP_COEF,	314,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	315,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	316,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	320,	    0xffffffff,	526848      },
	{REG_TYPE_INDEX_VPP_COEF,	321,	    0xffffffff,	238         },
	{REG_TYPE_INDEX_VPP_COEF,	322,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	323,	    0xffffffff,	10          },
	{REG_TYPE_INDEX_VPP_COEF,	324,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	328,	    0xffffffff,	527616      },
	{REG_TYPE_INDEX_VPP_COEF,	329,	    0xffffffff,	134742245   },
	{REG_TYPE_INDEX_VPP_COEF,	330,	    0xffffffff,	167903232   },
	{REG_TYPE_INDEX_VPP_COEF,	331,	    0xffffffff,	21          },
	{REG_TYPE_INDEX_VPP_COEF,	332,	    0xffffffff,	3328        },
	{REG_TYPE_INDEX_VPP_COEF,	336,	    0xffffffff,	397056      },
	{REG_TYPE_INDEX_VPP_COEF,	337,	    0xffffffff,	0xf80d00da  },
	{REG_TYPE_INDEX_VPP_COEF,	338,	    0xffffffff,	0xf80500fb  },
	{REG_TYPE_INDEX_VPP_COEF,	339,	    0xffffffff,	2           },
	{REG_TYPE_INDEX_VPP_COEF,	340,	    0xffffffff,	132357      },
	{REG_TYPE_INDEX_VPP_COEF,	344,	    0xffffffff,	526848      },
	{REG_TYPE_INDEX_VPP_COEF,	345,	    0xffffffff,	0xfb0a00c7  },
	{REG_TYPE_INDEX_VPP_COEF,	346,	    0xffffffff,	0xf6020002  },
	{REG_TYPE_INDEX_VPP_COEF,	347,	    0xffffffff,	251         },
	{REG_TYPE_INDEX_VPP_COEF,	348,	    0xffffffff,	16646656    },
	{REG_TYPE_INDEX_VPP_COEF,	352,	    0xffffffff,	657408      },
	{REG_TYPE_INDEX_VPP_COEF,	353,	    0xffffffff,	327857      },
	{REG_TYPE_INDEX_VPP_COEF,	354,	    0xffffffff,	0xf6050000  },
	{REG_TYPE_INDEX_VPP_COEF,	355,	    0xffffffff,	2           },
	{REG_TYPE_INDEX_VPP_COEF,	356,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	360,	    0xffffffff,	526336      },
	{REG_TYPE_INDEX_VPP_COEF,	361,	    0xffffffff,	162         },
	{REG_TYPE_INDEX_VPP_COEF,	362,	    0xffffffff,	0xf600f600  },
	{REG_TYPE_INDEX_VPP_COEF,	363,	    0xffffffff,	254         },
	{REG_TYPE_INDEX_VPP_COEF,	364,	    0xffffffff,	33554432    },
	{REG_TYPE_INDEX_VPP_COEF,	368,	    0xffffffff,	986368      },
	{REG_TYPE_INDEX_VPP_COEF,	369,	    0xffffffff,	166         },
	{REG_TYPE_INDEX_VPP_COEF,	370,	    0xffffffff,	0xf300eef6  },
	{REG_TYPE_INDEX_VPP_COEF,	371,	    0xffffffff,	243         },
	{REG_TYPE_INDEX_VPP_COEF,	372,	    0xffffffff,	0xfb050000  },
	{REG_TYPE_INDEX_VPP_COEF,	376,	    0xffffffff,	34541312    },
	{REG_TYPE_INDEX_VPP_COEF,	377,	    0xffffffff,	83886277    },
	{REG_TYPE_INDEX_VPP_COEF,	378,	    0xffffffff,	0xfbfef8f8  },
	{REG_TYPE_INDEX_VPP_COEF,	379,	    0xffffffff,	246         },
	{REG_TYPE_INDEX_VPP_COEF,	380,	    0xffffffff,	0xf8080200  },
	{REG_TYPE_INDEX_VPP_COEF,	384,	    0xffffffff,	286331136   },
	{REG_TYPE_INDEX_VPP_COEF,	385,	    0xffffffff,	353698041   },
	{REG_TYPE_INDEX_VPP_COEF,	386,	    0xffffffff,	168427768   },
	{REG_TYPE_INDEX_VPP_COEF,	387,	    0xffffffff,	13          },
	{REG_TYPE_INDEX_VPP_COEF,	388,	    0xffffffff,	0xfb081000  },
	{REG_TYPE_INDEX_VPP_COEF,	392,	    0xffffffff,	218960128   },
	{REG_TYPE_INDEX_VPP_COEF,	393,	    0xffffffff,	674758687   },
	{REG_TYPE_INDEX_VPP_COEF,	394,	    0xffffffff,	573177856   },
	{REG_TYPE_INDEX_VPP_COEF,	395,	    0xffffffff,	21          },
	{REG_TYPE_INDEX_VPP_COEF,	396,	    0xffffffff,	854766      },
	{REG_TYPE_INDEX_VPP_COEF,	400,	    0xffffffff,	168430080   },
	{REG_TYPE_INDEX_VPP_COEF,	401,	    0xffffffff,	809304110   },
	{REG_TYPE_INDEX_VPP_COEF,	402,	    0xffffffff,	674234389   },
	{REG_TYPE_INDEX_VPP_COEF,	403,	    0xffffffff,	13          },
	{REG_TYPE_INDEX_VPP_COEF,	404,	    0xffffffff,	716515      },
	{REG_TYPE_INDEX_VPP_COEF,	408,	    0xffffffff,	134745344   },
	{REG_TYPE_INDEX_VPP_COEF,	409,	    0xffffffff,	807731246   },
	{REG_TYPE_INDEX_VPP_COEF,	410,	    0xffffffff,	403308562   },
	{REG_TYPE_INDEX_VPP_COEF,	411,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	412,	    0xffffffff,	59590       },
	{REG_TYPE_INDEX_VPP_COEF,	416,	    0xffffffff,	67504640    },
	{REG_TYPE_INDEX_VPP_COEF,	417,	    0xffffffff,	269484072   },
	{REG_TYPE_INDEX_VPP_COEF,	418,	    0xffffffff,	182845440   },
	{REG_TYPE_INDEX_VPP_COEF,	419,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	420,	    0xffffffff,	61139       },
	{REG_TYPE_INDEX_VPP_COEF,	424,	    0xffffffff,	396544      },
	{REG_TYPE_INDEX_VPP_COEF,	425,	    0xffffffff,	134217757   },
	{REG_TYPE_INDEX_VPP_COEF,	426,	    0xffffffff,	0xfb0b0000  },
	{REG_TYPE_INDEX_VPP_COEF,	427,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	428,	    0xffffffff,	246         },
	{REG_TYPE_INDEX_VPP_COEF,	432,	    0xffffffff,	527616      },
	{REG_TYPE_INDEX_VPP_COEF,	433,	    0xffffffff,	12          },
	{REG_TYPE_INDEX_VPP_COEF,	434,	    0xffffffff,	15597568    },
	{REG_TYPE_INDEX_VPP_COEF,	435,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	436,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	440,	    0xffffffff,	658688      },
	{REG_TYPE_INDEX_VPP_COEF,	441,	    0xffffffff,	7           },
	{REG_TYPE_INDEX_VPP_COEF,	442,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	443,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	444,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	448,	    0xffffffff,	986880      },
	{REG_TYPE_INDEX_VPP_COEF,	449,	    0xffffffff,	255         },
	{REG_TYPE_INDEX_VPP_COEF,	450,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	451,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	452,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	456,	    0xffffffff,	219811584   },
	{REG_TYPE_INDEX_VPP_COEF,	457,	    0xffffffff,	238         },
	{REG_TYPE_INDEX_VPP_COEF,	458,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	459,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	460,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	464,	    0xffffffff,	287183104   },
	{REG_TYPE_INDEX_VPP_COEF,	465,	    0xffffffff,	197         },
	{REG_TYPE_INDEX_VPP_COEF,	466,	    0xffffffff,	0xf3000000  },
	{REG_TYPE_INDEX_VPP_COEF,	467,	    0xffffffff,	246         },
	{REG_TYPE_INDEX_VPP_COEF,	468,	    0xffffffff,	0xfb000000  },
	{REG_TYPE_INDEX_VPP_COEF,	472,	    0xffffffff,	219943168   },
	{REG_TYPE_INDEX_VPP_COEF,	473,	    0xffffffff,	169         },
	{REG_TYPE_INDEX_VPP_COEF,	474,	    0xffffffff,	0xf0000000  },
	{REG_TYPE_INDEX_VPP_COEF,	475,	    0xffffffff,	232         },
	{REG_TYPE_INDEX_VPP_COEF,	476,	    0xffffffff,	0           },
	{REG_TYPE_INDEX_VPP_COEF,	480,	    0xffffffff,	1707264     },
	{REG_TYPE_INDEX_VPP_COEF,	481,	    0xffffffff,	0xfb0000ab  },
	{REG_TYPE_INDEX_VPP_COEF,	482,	    0xffffffff,	0xe300f3f3  },
	{REG_TYPE_INDEX_VPP_COEF,	483,	    0xffffffff,	219         },
	{REG_TYPE_INDEX_VPP_COEF,	484,	    0xffffffff,	15597568    },
	{REG_TYPE_INDEX_VPP_COEF,	488,	    0xffffffff,	1509888     },
	{REG_TYPE_INDEX_VPP_COEF,	489,	    0xffffffff,	0xf30000b6  },
	{REG_TYPE_INDEX_VPP_COEF,	490,	    0xffffffff,	0xd800e8e3  },
	{REG_TYPE_INDEX_VPP_COEF,	491,	    0xffffffff,	222         },
	{REG_TYPE_INDEX_VPP_COEF,	492,	    0xffffffff,	14876680    },
	{REG_TYPE_INDEX_VPP_COEF,	496,	    0xffffffff,	1117440     },
	{REG_TYPE_INDEX_VPP_COEF,	497,	    0xffffffff,	0xf3fb00ba  },
	{REG_TYPE_INDEX_VPP_COEF,	498,	    0xffffffff,	0xd300ebe6  },
	{REG_TYPE_INDEX_VPP_COEF,	499,	    0xffffffff,	232         },
	{REG_TYPE_INDEX_VPP_COEF,	500,	    0xffffffff,	15661840    },
	{REG_TYPE_INDEX_VPP_COEF,	504,	    0xffffffff,	989696      },
	{REG_TYPE_INDEX_VPP_COEF,	505,	    0xffffffff,	0xf6f800b6  },
	{REG_TYPE_INDEX_VPP_COEF,	506,	    0xffffffff,	0xe600f3f3  },
	{REG_TYPE_INDEX_VPP_COEF,	507,	    0xffffffff,	235         },
	{REG_TYPE_INDEX_VPP_COEF,	508,	    0xffffffff,	18          },
	{0}
	}
};
static struct am_regs_s cmreg_lever2 = {
	172,
	{
	/* optimize */
	{REG_TYPE_INDEX_VPPCHROMA,	512,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPPCHROMA,	513,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPPCHROMA,	514,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPPCHROMA,	515,	    0xffffffff,	134218752  },
	{REG_TYPE_INDEX_VPPCHROMA,	516,	    0xffffffff,	144        },
	{REG_TYPE_INDEX_VPPCHROMA,	518,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPPCHROMA,	519,	    0xffffffff,	33554432   },
	{REG_TYPE_INDEX_VPPCHROMA,	520,	    0xffffffff,	122        },
	{REG_TYPE_INDEX_VPPCHROMA,	521,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPPCHROMA,	522,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPPCHROMA,	527,	    0xf,	0          },
	{REG_TYPE_INDEX_VPPCHROMA,	517,	    0xffffffff,	70715263   },
	{REG_TYPE_INDEX_VPP_COEF,	256,	    0xffffffff,	2840064    },
	{REG_TYPE_INDEX_VPP_COEF,	257,	    0xffffffff,	12         },
	{REG_TYPE_INDEX_VPP_COEF,	258,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	259,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	260,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	264,	    0xffffffff,	2708992    },
	{REG_TYPE_INDEX_VPP_COEF,	265,	    0xffffffff,	31         },
	{REG_TYPE_INDEX_VPP_COEF,	266,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	267,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	268,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	272,	    0xffffffff,	2708992    },
	{REG_TYPE_INDEX_VPP_COEF,	273,	    0xffffffff,	51         },
	{REG_TYPE_INDEX_VPP_COEF,	274,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	275,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	276,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	280,	    0xffffffff,	2840064    },
	{REG_TYPE_INDEX_VPP_COEF,	281,	    0xffffffff,	63         },
	{REG_TYPE_INDEX_VPP_COEF,	282,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	283,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	284,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	288,	    0xffffffff,	2840064    },
	{REG_TYPE_INDEX_VPP_COEF,	289,	    0xffffffff,	63         },
	{REG_TYPE_INDEX_VPP_COEF,	290,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	291,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	292,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	296,	    0xffffffff,	2708992    },
	{REG_TYPE_INDEX_VPP_COEF,	297,	    0xffffffff,	63         },
	{REG_TYPE_INDEX_VPP_COEF,	298,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	299,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	300,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	304,	    0xffffffff,	2708480    },
	{REG_TYPE_INDEX_VPP_COEF,	305,	    0xffffffff,	63         },
	{REG_TYPE_INDEX_VPP_COEF,	306,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	307,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	308,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	312,	    0xffffffff,	2708480    },
	{REG_TYPE_INDEX_VPP_COEF,	313,	    0xffffffff,	51         },
	{REG_TYPE_INDEX_VPP_COEF,	314,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	315,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	316,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	320,	    0xffffffff,	2708480    },
	{REG_TYPE_INDEX_VPP_COEF,	321,	    0xffffffff,	9          },
	{REG_TYPE_INDEX_VPP_COEF,	322,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	323,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	324,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	328,	    0xffffffff,	2708480    },
	{REG_TYPE_INDEX_VPP_COEF,	329,	    0xffffffff,	234        },
	{REG_TYPE_INDEX_VPP_COEF,	330,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	331,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	332,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	336,	    0xffffffff,	2708480    },
	{REG_TYPE_INDEX_VPP_COEF,	337,	    0xffffffff,	212        },
	{REG_TYPE_INDEX_VPP_COEF,	338,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	339,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	340,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	344,	    0xffffffff,	2708480    },
	{REG_TYPE_INDEX_VPP_COEF,	345,	    0xffffffff,	197        },
	{REG_TYPE_INDEX_VPP_COEF,	346,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	347,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	348,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	352,	    0xffffffff,	2708480    },
	{REG_TYPE_INDEX_VPP_COEF,	353,	    0xffffffff,	193        },
	{REG_TYPE_INDEX_VPP_COEF,	354,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	355,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	356,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	360,	    0xffffffff,	2708480    },
	{REG_TYPE_INDEX_VPP_COEF,	361,	    0xffffffff,	203        },
	{REG_TYPE_INDEX_VPP_COEF,	362,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	363,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	364,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	368,	    0xffffffff,	2708480    },
	{REG_TYPE_INDEX_VPP_COEF,	369,	    0xffffffff,	214        },
	{REG_TYPE_INDEX_VPP_COEF,	370,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	371,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	372,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	376,	    0xffffffff,	2708992    },
	{REG_TYPE_INDEX_VPP_COEF,	377,	    0xffffffff,	219        },
	{REG_TYPE_INDEX_VPP_COEF,	378,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	379,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	380,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	384,	    0xffffffff,	2708480    },
	{REG_TYPE_INDEX_VPP_COEF,	385,	    0xffffffff,	236        },
	{REG_TYPE_INDEX_VPP_COEF,	386,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	387,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	388,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	392,	    0xffffffff,	2708992    },
	{REG_TYPE_INDEX_VPP_COEF,	393,	    0xffffffff,	249        },
	{REG_TYPE_INDEX_VPP_COEF,	394,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	395,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	396,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	400,	    0xffffffff,	2708992    },
	{REG_TYPE_INDEX_VPP_COEF,	401,	    0xffffffff,	3          },
	{REG_TYPE_INDEX_VPP_COEF,	402,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	403,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	404,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	408,	    0xffffffff,	2708992    },
	{REG_TYPE_INDEX_VPP_COEF,	409,	    0xffffffff,	9          },
	{REG_TYPE_INDEX_VPP_COEF,	410,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	411,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	412,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	416,	    0xffffffff,	2708480    },
	{REG_TYPE_INDEX_VPP_COEF,	417,	    0xffffffff,	12         },
	{REG_TYPE_INDEX_VPP_COEF,	418,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	419,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	420,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	424,	    0xffffffff,	2708480    },
	{REG_TYPE_INDEX_VPP_COEF,	425,	    0xffffffff,	14         },
	{REG_TYPE_INDEX_VPP_COEF,	426,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	427,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	428,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	432,	    0xffffffff,	2708480    },
	{REG_TYPE_INDEX_VPP_COEF,	433,	    0xffffffff,	12         },
	{REG_TYPE_INDEX_VPP_COEF,	434,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	435,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	436,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	440,	    0xffffffff,	2708480    },
	{REG_TYPE_INDEX_VPP_COEF,	441,	    0xffffffff,	7          },
	{REG_TYPE_INDEX_VPP_COEF,	442,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	443,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	444,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	448,	    0xffffffff,	2708480    },
	{REG_TYPE_INDEX_VPP_COEF,	449,	    0xffffffff,	251        },
	{REG_TYPE_INDEX_VPP_COEF,	450,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	451,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	452,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	456,	    0xffffffff,	2708480    },
	{REG_TYPE_INDEX_VPP_COEF,	457,	    0xffffffff,	242        },
	{REG_TYPE_INDEX_VPP_COEF,	458,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	459,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	460,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	464,	    0xffffffff,	36262912   },
	{REG_TYPE_INDEX_VPP_COEF,	465,	    0xffffffff,	238        },
	{REG_TYPE_INDEX_VPP_COEF,	466,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	467,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	468,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	472,	    0xffffffff,	69817344   },
	{REG_TYPE_INDEX_VPP_COEF,	473,	    0xffffffff,	245        },
	{REG_TYPE_INDEX_VPP_COEF,	474,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	475,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	476,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	480,	    0xffffffff,	136926208  },
	{REG_TYPE_INDEX_VPP_COEF,	481,	    0xffffffff,	1          },
	{REG_TYPE_INDEX_VPP_COEF,	482,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	483,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	484,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	488,	    0xffffffff,	136926208  },
	{REG_TYPE_INDEX_VPP_COEF,	489,	    0xffffffff,	5          },
	{REG_TYPE_INDEX_VPP_COEF,	490,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	491,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	492,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	496,	    0xffffffff,	136926208  },
	{REG_TYPE_INDEX_VPP_COEF,	497,	    0xffffffff,	5          },
	{REG_TYPE_INDEX_VPP_COEF,	498,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	499,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	500,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	504,	    0xffffffff,	69817344   },
	{REG_TYPE_INDEX_VPP_COEF,	505,	    0xffffffff,	7          },
	{REG_TYPE_INDEX_VPP_COEF,	506,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	507,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	508,	    0xffffffff,	0          },
	{0}
	}
};
static struct am_regs_s cmreg_lever3 = {
	172,
	{
	/* optimize */
	{REG_TYPE_INDEX_VPPCHROMA,	512,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPPCHROMA,	513,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPPCHROMA,	514,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPPCHROMA,	515,	    0xffffffff,	134218752  },
	{REG_TYPE_INDEX_VPPCHROMA,	516,	    0xffffffff,	144        },
	{REG_TYPE_INDEX_VPPCHROMA,	518,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPPCHROMA,	519,	    0xffffffff,	33554432   },
	{REG_TYPE_INDEX_VPPCHROMA,	520,	    0xffffffff,	118        },
	{REG_TYPE_INDEX_VPPCHROMA,	521,	    0xffffffff,	62914560   },
	{REG_TYPE_INDEX_VPPCHROMA,	522,	    0xffffffff,	70778880   },
	{REG_TYPE_INDEX_VPPCHROMA,	527,	           0xf,	1          },
	{REG_TYPE_INDEX_VPPCHROMA,	517,	    0xffffffff,	70780799   },
	{REG_TYPE_INDEX_VPP_COEF,	256,	    0xffffffff,	16648704   },
	{REG_TYPE_INDEX_VPP_COEF,	257,	    0xffffffff,	0xf3f6000b },
	{REG_TYPE_INDEX_VPP_COEF,	258,	    0xffffffff,	0xe3000000 },
	{REG_TYPE_INDEX_VPP_COEF,	259,	    0xffffffff,	240        },
	{REG_TYPE_INDEX_VPP_COEF,	260,	    0xffffffff,	63742      },
	{REG_TYPE_INDEX_VPP_COEF,	264,	    0xffffffff,	16650496   },
	{REG_TYPE_INDEX_VPP_COEF,	265,	    0xffffffff,	14         },
	{REG_TYPE_INDEX_VPP_COEF,	266,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	267,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	268,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	272,	    0xffffffff,	135936     },
	{REG_TYPE_INDEX_VPP_COEF,	273,	    0xffffffff,	253        },
	{REG_TYPE_INDEX_VPP_COEF,	274,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	275,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	276,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	280,	    0xffffffff,	0xf3f11300 },
	{REG_TYPE_INDEX_VPP_COEF,	281,	    0xffffffff,	214        },
	{REG_TYPE_INDEX_VPP_COEF,	282,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	283,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	284,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	288,	    0xffffffff,	0xede91300 },
	{REG_TYPE_INDEX_VPP_COEF,	289,	    0xffffffff,	177        },
	{REG_TYPE_INDEX_VPP_COEF,	290,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	291,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	292,	    0xffffffff,	15660544   },
	{REG_TYPE_INDEX_VPP_COEF,	296,	    0xffffffff,	0xe9e61100 },
	{REG_TYPE_INDEX_VPP_COEF,	297,	    0xffffffff,	184        },
	{REG_TYPE_INDEX_VPP_COEF,	298,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	299,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	300,	    0xffffffff,	15464448   },
	{REG_TYPE_INDEX_VPP_COEF,	304,	    0xffffffff,	0xeff80f00 },
	{REG_TYPE_INDEX_VPP_COEF,	305,	    0xffffffff,	232        },
	{REG_TYPE_INDEX_VPP_COEF,	306,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	307,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	308,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	312,	    0xffffffff,	0xf60a0d00 },
	{REG_TYPE_INDEX_VPP_COEF,	313,	    0xffffffff,	5          },
	{REG_TYPE_INDEX_VPP_COEF,	314,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	315,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	316,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	320,	    0xffffffff,	526848     },
	{REG_TYPE_INDEX_VPP_COEF,	321,	    0xffffffff,	5          },
	{REG_TYPE_INDEX_VPP_COEF,	322,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	323,	    0xffffffff,	10         },
	{REG_TYPE_INDEX_VPP_COEF,	324,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	328,	    0xffffffff,	526848     },
	{REG_TYPE_INDEX_VPP_COEF,	329,	    0xffffffff,	134742265  },
	{REG_TYPE_INDEX_VPP_COEF,	330,	    0xffffffff,	167903232  },
	{REG_TYPE_INDEX_VPP_COEF,	331,	    0xffffffff,	21         },
	{REG_TYPE_INDEX_VPP_COEF,	332,	    0xffffffff,	3328       },
	{REG_TYPE_INDEX_VPP_COEF,	336,	    0xffffffff,	131072     },
	{REG_TYPE_INDEX_VPP_COEF,	337,	    0xffffffff,	0xf80d00ea },
	{REG_TYPE_INDEX_VPP_COEF,	338,	    0xffffffff,	0xf80500fb },
	{REG_TYPE_INDEX_VPP_COEF,	339,	    0xffffffff,	2          },
	{REG_TYPE_INDEX_VPP_COEF,	340,	    0xffffffff,	132357     },
	{REG_TYPE_INDEX_VPP_COEF,	344,	    0xffffffff,	131584     },
	{REG_TYPE_INDEX_VPP_COEF,	345,	    0xffffffff,	0xfb0100da },
	{REG_TYPE_INDEX_VPP_COEF,	346,	    0xffffffff,	0xf6020002 },
	{REG_TYPE_INDEX_VPP_COEF,	347,	    0xffffffff,	251        },
	{REG_TYPE_INDEX_VPP_COEF,	348,	    0xffffffff,	16646656   },
	{REG_TYPE_INDEX_VPP_COEF,	352,	    0xffffffff,	657408     },
	{REG_TYPE_INDEX_VPP_COEF,	353,	    0xffffffff,	327872     },
	{REG_TYPE_INDEX_VPP_COEF,	354,	    0xffffffff,	0xf6050000 },
	{REG_TYPE_INDEX_VPP_COEF,	355,	    0xffffffff,	2          },
	{REG_TYPE_INDEX_VPP_COEF,	356,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	360,	    0xffffffff,	526336     },
	{REG_TYPE_INDEX_VPP_COEF,	361,	    0xffffffff,	175        },
	{REG_TYPE_INDEX_VPP_COEF,	362,	    0xffffffff,	0xf600f600 },
	{REG_TYPE_INDEX_VPP_COEF,	363,	    0xffffffff,	254        },
	{REG_TYPE_INDEX_VPP_COEF,	364,	    0xffffffff,	33554432   },
	{REG_TYPE_INDEX_VPP_COEF,	368,	    0xffffffff,	986368     },
	{REG_TYPE_INDEX_VPP_COEF,	369,	    0xffffffff,	169        },
	{REG_TYPE_INDEX_VPP_COEF,	370,	    0xffffffff,	0xf300eef6 },
	{REG_TYPE_INDEX_VPP_COEF,	371,	    0xffffffff,	243        },
	{REG_TYPE_INDEX_VPP_COEF,	372,	    0xffffffff,	0xfb050000 },
	{REG_TYPE_INDEX_VPP_COEF,	376,	    0xffffffff,	34541312   },
	{REG_TYPE_INDEX_VPP_COEF,	377,	    0xffffffff,	83886277   },
	{REG_TYPE_INDEX_VPP_COEF,	378,	    0xffffffff,	0xfbfef8f8 },
	{REG_TYPE_INDEX_VPP_COEF,	379,	    0xffffffff,	246        },
	{REG_TYPE_INDEX_VPP_COEF,	380,	    0xffffffff,	0xf8080200 },
	{REG_TYPE_INDEX_VPP_COEF,	384,	    0xffffffff,	135339520  },
	{REG_TYPE_INDEX_VPP_COEF,	385,	    0xffffffff,	353697836  },
	{REG_TYPE_INDEX_VPP_COEF,	386,	    0xffffffff,	168427768  },
	{REG_TYPE_INDEX_VPP_COEF,	387,	    0xffffffff,	13         },
	{REG_TYPE_INDEX_VPP_COEF,	388,	    0xffffffff,	0xfb080800 },
	{REG_TYPE_INDEX_VPP_COEF,	392,	    0xffffffff,	219356160  },
	{REG_TYPE_INDEX_VPP_COEF,	393,	    0xffffffff,	674758739  },
	{REG_TYPE_INDEX_VPP_COEF,	394,	    0xffffffff,	573177856  },
	{REG_TYPE_INDEX_VPP_COEF,	395,	    0xffffffff,	21         },
	{REG_TYPE_INDEX_VPP_COEF,	396,	    0xffffffff,	657920     },
	{REG_TYPE_INDEX_VPP_COEF,	400,	    0xffffffff,	219223808  },
	{REG_TYPE_INDEX_VPP_COEF,	401,	    0xffffffff,	809304160  },
	{REG_TYPE_INDEX_VPP_COEF,	402,	    0xffffffff,	674562069  },
	{REG_TYPE_INDEX_VPP_COEF,	403,	    0xffffffff,	13         },
	{REG_TYPE_INDEX_VPP_COEF,	404,	    0xffffffff,	657920     },
	{REG_TYPE_INDEX_VPP_COEF,	408,	    0xffffffff,	168629504  },
	{REG_TYPE_INDEX_VPP_COEF,	409,	    0xffffffff,	807731289  },
	{REG_TYPE_INDEX_VPP_COEF,	410,	    0xffffffff,	403308562  },
	{REG_TYPE_INDEX_VPP_COEF,	411,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	412,	    0xffffffff,	526848     },
	{REG_TYPE_INDEX_VPP_COEF,	416,	    0xffffffff,	395776     },
	{REG_TYPE_INDEX_VPP_COEF,	417,	    0xffffffff,	269484098  },
	{REG_TYPE_INDEX_VPP_COEF,	418,	    0xffffffff,	167772160  },
	{REG_TYPE_INDEX_VPP_COEF,	419,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	420,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	424,	    0xffffffff,	396544     },
	{REG_TYPE_INDEX_VPP_COEF,	425,	    0xffffffff,	134217757  },
	{REG_TYPE_INDEX_VPP_COEF,	426,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	427,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	428,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	432,	    0xffffffff,	527616     },
	{REG_TYPE_INDEX_VPP_COEF,	433,	    0xffffffff,	12         },
	{REG_TYPE_INDEX_VPP_COEF,	434,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	435,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	436,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	440,	    0xffffffff,	658688     },
	{REG_TYPE_INDEX_VPP_COEF,	441,	    0xffffffff,	7          },
	{REG_TYPE_INDEX_VPP_COEF,	442,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	443,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	444,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	448,	    0xffffffff,	986880     },
	{REG_TYPE_INDEX_VPP_COEF,	449,	    0xffffffff,	5          },
	{REG_TYPE_INDEX_VPP_COEF,	450,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	451,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	452,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	456,	    0xffffffff,	219811584  },
	{REG_TYPE_INDEX_VPP_COEF,	457,	    0xffffffff,	244        },
	{REG_TYPE_INDEX_VPP_COEF,	458,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	459,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	460,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	464,	    0xffffffff,	287183104  },
	{REG_TYPE_INDEX_VPP_COEF,	465,	    0xffffffff,	186        },
	{REG_TYPE_INDEX_VPP_COEF,	466,	    0xffffffff,	0xf3000000 },
	{REG_TYPE_INDEX_VPP_COEF,	467,	    0xffffffff,	246        },
	{REG_TYPE_INDEX_VPP_COEF,	468,	    0xffffffff,	0xfb000000 },
	{REG_TYPE_INDEX_VPP_COEF,	472,	    0xffffffff,	219944192  },
	{REG_TYPE_INDEX_VPP_COEF,	473,	    0xffffffff,	158        },
	{REG_TYPE_INDEX_VPP_COEF,	474,	    0xffffffff,	0xf0000000 },
	{REG_TYPE_INDEX_VPP_COEF,	475,	    0xffffffff,	232        },
	{REG_TYPE_INDEX_VPP_COEF,	476,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	480,	    0xffffffff,	1382912    },
	{REG_TYPE_INDEX_VPP_COEF,	481,	    0xffffffff,	0xfb0000a4 },
	{REG_TYPE_INDEX_VPP_COEF,	482,	    0xffffffff,	0xe300f3f3 },
	{REG_TYPE_INDEX_VPP_COEF,	483,	    0xffffffff,	219        },
	{REG_TYPE_INDEX_VPP_COEF,	484,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	488,	    0xffffffff,	1514496    },
	{REG_TYPE_INDEX_VPP_COEF,	489,	    0xffffffff,	0xf30000ba },
	{REG_TYPE_INDEX_VPP_COEF,	490,	    0xffffffff,	0xe600f3f0 },
	{REG_TYPE_INDEX_VPP_COEF,	491,	    0xffffffff,	222        },
	{REG_TYPE_INDEX_VPP_COEF,	492,	    0xffffffff,	0          },
	{REG_TYPE_INDEX_VPP_COEF,	496,	    0xffffffff,	1120000    },
	{REG_TYPE_INDEX_VPP_COEF,	497,	    0xffffffff,	0xf3fb00db },
	{REG_TYPE_INDEX_VPP_COEF,	498,	    0xffffffff,	0xe800f6ee },
	{REG_TYPE_INDEX_VPP_COEF,	499,	    0xffffffff,	232        },
	{REG_TYPE_INDEX_VPP_COEF,	500,	    0xffffffff,	64256      },
	{REG_TYPE_INDEX_VPP_COEF,	504,	    0xffffffff,	397056     },
	{REG_TYPE_INDEX_VPP_COEF,	505,	    0xffffffff,	0xf6f800f7 },
	{REG_TYPE_INDEX_VPP_COEF,	506,	    0xffffffff,	0xe60000f8 },
	{REG_TYPE_INDEX_VPP_COEF,	507,	    0xffffffff,	235        },
	{REG_TYPE_INDEX_VPP_COEF,	508,	    0xffffffff,	65278      },
	{0}
	}
};

static struct am_regs_s cmreg_optimize = {
	172,
	{
	/* optimize */
	{REG_TYPE_INDEX_VPPCHROMA,	0x200,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPPCHROMA,	0x201,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPPCHROMA,	0x202,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPPCHROMA,	0x203,    0xffffffff, 0x8000400},
	{REG_TYPE_INDEX_VPPCHROMA,	0x204,    0xffffffff, 0x90   },
	{REG_TYPE_INDEX_VPPCHROMA,	0x205,    0xffffffff, 0x437077f},
	{REG_TYPE_INDEX_VPPCHROMA,	0x206,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPPCHROMA,	0x207,    0xffffffff, 0x1f60000},
	{REG_TYPE_INDEX_VPPCHROMA,	0x208,    0xffffffff, 0x76   },
	{REG_TYPE_INDEX_VPPCHROMA,	0x209,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPPCHROMA,	0x20a,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPPCHROMA,	0x20f,    0xf, 0x0,   },
	{REG_TYPE_INDEX_VPP_COEF,	0x100,    0xffffffff, 0xa1100  },
	{REG_TYPE_INDEX_VPP_COEF,	0x101,    0xffffffff, 0xc   },
	{REG_TYPE_INDEX_VPP_COEF,	0x102,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x103,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x104,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x108,    0xffffffff, 0xd1100  },
	{REG_TYPE_INDEX_VPP_COEF,	0x109,    0xffffffff, 0x1f   },
	{REG_TYPE_INDEX_VPP_COEF,	0x10a,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x10b,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x10c,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x110,    0xffffffff, 0xf1300  },
	{REG_TYPE_INDEX_VPP_COEF,	0x111,    0xffffffff, 0x33   },
	{REG_TYPE_INDEX_VPP_COEF,	0x112,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x113,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x114,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x118,    0xffffffff, 0xf1300  },
	{REG_TYPE_INDEX_VPP_COEF,	0x119,    0xffffffff, 0x3f   },
	{REG_TYPE_INDEX_VPP_COEF,	0x11a,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x11b,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x11c,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x120,    0xffffffff, 0xf1300  },
	{REG_TYPE_INDEX_VPP_COEF,	0x121,    0xffffffff, 0x40   },
	{REG_TYPE_INDEX_VPP_COEF,	0x122,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x123,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x124,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x128,    0xffffffff, 0xf1100  },
	{REG_TYPE_INDEX_VPP_COEF,	0x129,    0xffffffff, 0x40   },
	{REG_TYPE_INDEX_VPP_COEF,	0x12a,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x12b,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x12c,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x130,    0xffffffff, 0xd0f00  },
	{REG_TYPE_INDEX_VPP_COEF,	0x131,    0xffffffff, 0x3f   },
	{REG_TYPE_INDEX_VPP_COEF,	0x132,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x133,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x134,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x138,    0xffffffff, 0xa0d00  },
	{REG_TYPE_INDEX_VPP_COEF,	0x139,    0xffffffff, 0x32   },
	{REG_TYPE_INDEX_VPP_COEF,	0x13a,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x13b,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x13c,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x140,    0xffffffff, 0x80a00  },
	{REG_TYPE_INDEX_VPP_COEF,	0x141,    0xffffffff, 0x9   },
	{REG_TYPE_INDEX_VPP_COEF,	0x142,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x143,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x144,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x148,    0xffffffff, 0x80a00  },
	{REG_TYPE_INDEX_VPP_COEF,	0x149,    0xffffffff, 0xea   },
	{REG_TYPE_INDEX_VPP_COEF,	0x14a,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x14b,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x14c,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x150,    0xffffffff, 0xa0a00  },
	{REG_TYPE_INDEX_VPP_COEF,	0x151,    0xffffffff, 0xd4   },
	{REG_TYPE_INDEX_VPP_COEF,	0x152,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x153,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x154,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x158,    0xffffffff, 0xa0800  },
	{REG_TYPE_INDEX_VPP_COEF,	0x159,    0xffffffff, 0xc3   },
	{REG_TYPE_INDEX_VPP_COEF,	0x15a,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x15b,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x15c,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x160,    0xffffffff, 0xa0800  },
	{REG_TYPE_INDEX_VPP_COEF,	0x161,    0xffffffff, 0xc0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x162,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x163,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x164,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x168,    0xffffffff, 0x80800  },
	{REG_TYPE_INDEX_VPP_COEF,	0x169,    0xffffffff, 0xcb   },
	{REG_TYPE_INDEX_VPP_COEF,	0x16a,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x16b,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x16c,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x170,    0xffffffff, 0x60800  },
	{REG_TYPE_INDEX_VPP_COEF,	0x171,    0xffffffff, 0xd4   },
	{REG_TYPE_INDEX_VPP_COEF,	0x172,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x173,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x174,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x178,    0xffffffff, 0x40600  },
	{REG_TYPE_INDEX_VPP_COEF,	0x179,    0xffffffff, 0xdb   },
	{REG_TYPE_INDEX_VPP_COEF,	0x17a,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x17b,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x17c,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x180,    0xffffffff, 0x60600  },
	{REG_TYPE_INDEX_VPP_COEF,	0x181,    0xffffffff, 0xea   },
	{REG_TYPE_INDEX_VPP_COEF,	0x182,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x183,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x184,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x188,    0xffffffff, 0x60600  },
	{REG_TYPE_INDEX_VPP_COEF,	0x189,    0xffffffff, 0xf7   },
	{REG_TYPE_INDEX_VPP_COEF,	0x18a,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x18b,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x18c,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x190,    0xffffffff, 0x60600  },
	{REG_TYPE_INDEX_VPP_COEF,	0x191,    0xffffffff, 0x3   },
	{REG_TYPE_INDEX_VPP_COEF,	0x192,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x193,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x194,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x198,    0xffffffff, 0x80800  },
	{REG_TYPE_INDEX_VPP_COEF,	0x199,    0xffffffff, 0x9   },
	{REG_TYPE_INDEX_VPP_COEF,	0x19a,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x19b,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x19c,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1a0,    0xffffffff, 0x60a00  },
	{REG_TYPE_INDEX_VPP_COEF,	0x1a1,    0xffffffff, 0xc   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1a2,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1a3,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1a4,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1a8,    0xffffffff, 0x60d00  },
	{REG_TYPE_INDEX_VPP_COEF,	0x1a9,    0xffffffff, 0xe   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1aa,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1ab,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1ac,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1b0,    0xffffffff, 0x80d00  },
	{REG_TYPE_INDEX_VPP_COEF,	0x1b1,    0xffffffff, 0xc   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1b2,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1b3,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1b4,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1b8,    0xffffffff, 0xa0d00  },
	{REG_TYPE_INDEX_VPP_COEF,	0x1b9,    0xffffffff, 0x7   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1ba,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1bb,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1bc,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1c0,    0xffffffff, 0xf0f00  },
	{REG_TYPE_INDEX_VPP_COEF,	0x1c1,    0xffffffff, 0xfb   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1c2,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1c3,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1c4,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1c8,    0xffffffff, 0x110f00 },
	{REG_TYPE_INDEX_VPP_COEF,	0x1c9,    0xffffffff, 0xf2   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1ca,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1cb,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1cc,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1d0,    0xffffffff, 0x131100 },
	{REG_TYPE_INDEX_VPP_COEF,	0x1d1,    0xffffffff, 0xee   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1d2,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1d3,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1d4,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1d8,    0xffffffff, 0x131500 },
	{REG_TYPE_INDEX_VPP_COEF,	0x1d9,    0xffffffff, 0xf5   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1da,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1db,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1dc,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1e0,    0xffffffff, 0x151a00 },
	{REG_TYPE_INDEX_VPP_COEF,	0x1e1,    0xffffffff, 0x1   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1e2,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1e3,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1e4,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1e8,    0xffffffff, 0x171c00 },
	{REG_TYPE_INDEX_VPP_COEF,	0x1e9,    0xffffffff, 0x5   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1ea,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1eb,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1ec,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1f0,    0xffffffff, 0x171a00 },
	{REG_TYPE_INDEX_VPP_COEF,	0x1f1,    0xffffffff, 0x5   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1f2,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1f3,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1f4,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1f8,    0xffffffff, 0x131500 },
	{REG_TYPE_INDEX_VPP_COEF,	0x1f9,    0xffffffff, 0x7   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1fa,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1fb,    0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1fc,    0xffffffff, 0x0   },
	{0}
	}
};
static struct am_regs_s cmreg_enhancement = {
	172,
	{
	/* enhancement */
	{REG_TYPE_INDEX_VPPCHROMA,	0x200,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPPCHROMA,	0x201,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPPCHROMA,	0x202,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPPCHROMA,	0x203,	  0xffffffff, 0x8000400},
	{REG_TYPE_INDEX_VPPCHROMA,	0x204,	  0xffffffff, 0x90   },
	{REG_TYPE_INDEX_VPPCHROMA,	0x205,	  0xffffffff, 0x437077f},
	{REG_TYPE_INDEX_VPPCHROMA,	0x206,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPPCHROMA,	0x207,	  0xffffffff, 0x2640000},
	{REG_TYPE_INDEX_VPPCHROMA,	0x208,	  0xffffffff, 0x7a   },
	{REG_TYPE_INDEX_VPPCHROMA,	0x209,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPPCHROMA,	0x20a,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPPCHROMA,	0x20f,	  0xf, 0x0,   },
	{REG_TYPE_INDEX_VPP_COEF,	0x100,	  0xffffffff, 0x2b5600 },
	{REG_TYPE_INDEX_VPP_COEF,	0x101,	  0xffffffff, 0xc   },
	{REG_TYPE_INDEX_VPP_COEF,	0x102,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x103,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x104,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x108,	  0xffffffff, 0x295600 },
	{REG_TYPE_INDEX_VPP_COEF,	0x109,	  0xffffffff, 0x1f   },
	{REG_TYPE_INDEX_VPP_COEF,	0x10a,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x10b,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x10c,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x110,	  0xffffffff, 0x295600 },
	{REG_TYPE_INDEX_VPP_COEF,	0x111,	  0xffffffff, 0x33   },
	{REG_TYPE_INDEX_VPP_COEF,	0x112,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x113,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x114,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x118,	  0xffffffff, 0x2b5600 },
	{REG_TYPE_INDEX_VPP_COEF,	0x119,	  0xffffffff, 0x3f   },
	{REG_TYPE_INDEX_VPP_COEF,	0x11a,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x11b,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x11c,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x120,	  0xffffffff, 0x2b5600 },
	{REG_TYPE_INDEX_VPP_COEF,	0x121,	  0xffffffff, 0x3f   },
	{REG_TYPE_INDEX_VPP_COEF,	0x122,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x123,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x124,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x128,	  0xffffffff, 0x295600 },
	{REG_TYPE_INDEX_VPP_COEF,	0x129,	  0xffffffff, 0x3f   },
	{REG_TYPE_INDEX_VPP_COEF,	0x12a,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x12b,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x12c,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x130,	  0xffffffff, 0x295400 },
	{REG_TYPE_INDEX_VPP_COEF,	0x131,	  0xffffffff, 0x3f   },
	{REG_TYPE_INDEX_VPP_COEF,	0x132,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x133,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x134,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x138,	  0xffffffff, 0x295400 },
	{REG_TYPE_INDEX_VPP_COEF,	0x139,	  0xffffffff, 0x33   },
	{REG_TYPE_INDEX_VPP_COEF,	0x13a,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x13b,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x13c,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x140,	  0xffffffff, 0x295400 },
	{REG_TYPE_INDEX_VPP_COEF,	0x141,	  0xffffffff, 0x9   },
	{REG_TYPE_INDEX_VPP_COEF,	0x142,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x143,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x144,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x148,	  0xffffffff, 0x295400 },
	{REG_TYPE_INDEX_VPP_COEF,	0x149,	  0xffffffff, 0xea   },
	{REG_TYPE_INDEX_VPP_COEF,	0x14a,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x14b,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x14c,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x150,	  0xffffffff, 0x295400 },
	{REG_TYPE_INDEX_VPP_COEF,	0x151,	  0xffffffff, 0xd4   },
	{REG_TYPE_INDEX_VPP_COEF,	0x152,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x153,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x154,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x158,	  0xffffffff, 0x295400 },
	{REG_TYPE_INDEX_VPP_COEF,	0x159,	  0xffffffff, 0xc5   },
	{REG_TYPE_INDEX_VPP_COEF,	0x15a,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x15b,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x15c,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x160,	  0xffffffff, 0x295400 },
	{REG_TYPE_INDEX_VPP_COEF,	0x161,	  0xffffffff, 0xc1   },
	{REG_TYPE_INDEX_VPP_COEF,	0x162,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x163,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x164,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x168,	  0xffffffff, 0x295400 },
	{REG_TYPE_INDEX_VPP_COEF,	0x169,	  0xffffffff, 0xcb   },
	{REG_TYPE_INDEX_VPP_COEF,	0x16a,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x16b,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x16c,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x170,	  0xffffffff, 0x295400 },
	{REG_TYPE_INDEX_VPP_COEF,	0x171,	  0xffffffff, 0xd6   },
	{REG_TYPE_INDEX_VPP_COEF,	0x172,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x173,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x174,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x178,	  0xffffffff, 0x295600 },
	{REG_TYPE_INDEX_VPP_COEF,	0x179,	  0xffffffff, 0xdb   },
	{REG_TYPE_INDEX_VPP_COEF,	0x17a,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x17b,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x17c,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x180,	  0xffffffff, 0x295400 },
	{REG_TYPE_INDEX_VPP_COEF,	0x181,	  0xffffffff, 0xec   },
	{REG_TYPE_INDEX_VPP_COEF,	0x182,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x183,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x184,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x188,	  0xffffffff, 0x295600 },
	{REG_TYPE_INDEX_VPP_COEF,	0x189,	  0xffffffff, 0xf9   },
	{REG_TYPE_INDEX_VPP_COEF,	0x18a,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x18b,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x18c,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x190,	  0xffffffff, 0x295600 },
	{REG_TYPE_INDEX_VPP_COEF,	0x191,	  0xffffffff, 0x3   },
	{REG_TYPE_INDEX_VPP_COEF,	0x192,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x193,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x194,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x198,	  0xffffffff, 0x295600 },
	{REG_TYPE_INDEX_VPP_COEF,	0x199,	  0xffffffff, 0x9   },
	{REG_TYPE_INDEX_VPP_COEF,	0x19a,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x19b,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x19c,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1a0,	  0xffffffff, 0x295400 },
	{REG_TYPE_INDEX_VPP_COEF,	0x1a1,	  0xffffffff, 0xc   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1a2,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1a3,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1a4,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1a8,	  0xffffffff, 0x295400 },
	{REG_TYPE_INDEX_VPP_COEF,	0x1a9,	  0xffffffff, 0xe   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1aa,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1ab,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1ac,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1b0,	  0xffffffff, 0x295400 },
	{REG_TYPE_INDEX_VPP_COEF,	0x1b1,	  0xffffffff, 0xc   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1b2,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1b3,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1b4,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1b8,	  0xffffffff, 0x295400 },
	{REG_TYPE_INDEX_VPP_COEF,	0x1b9,	  0xffffffff, 0x7   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1ba,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1bb,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1bc,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1c0,	  0xffffffff, 0x295400 },
	{REG_TYPE_INDEX_VPP_COEF,	0x1c1,	  0xffffffff, 0xfb   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1c2,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1c3,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1c4,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1c8,	  0xffffffff, 0x295400 },
	{REG_TYPE_INDEX_VPP_COEF,	0x1c9,	  0xffffffff, 0xf2   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1ca,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1cb,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1cc,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1d0,	  0xffffffff, 0x2295400},
	{REG_TYPE_INDEX_VPP_COEF,	0x1d1,	  0xffffffff, 0xee   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1d2,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1d3,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1d4,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1d8,	  0xffffffff, 0x4295400},
	{REG_TYPE_INDEX_VPP_COEF,	0x1d9,	  0xffffffff, 0xf5   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1da,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1db,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1dc,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1e0,	  0xffffffff, 0x8295400},
	{REG_TYPE_INDEX_VPP_COEF,	0x1e1,	  0xffffffff, 0x1   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1e2,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1e3,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1e4,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1e8,	  0xffffffff, 0x8295400},
	{REG_TYPE_INDEX_VPP_COEF,	0x1e9,	  0xffffffff, 0x5   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1ea,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1eb,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1ec,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1f0,	  0xffffffff, 0x8295400},
	{REG_TYPE_INDEX_VPP_COEF,	0x1f1,	  0xffffffff, 0x5   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1f2,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1f3,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1f4,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1f8,	  0xffffffff, 0x4295400},
	{REG_TYPE_INDEX_VPP_COEF,	0x1f9,	  0xffffffff, 0x7   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1fa,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1fb,	  0xffffffff, 0x0   },
	{REG_TYPE_INDEX_VPP_COEF,	0x1fc,	  0xffffffff, 0x0   },
	{0}
	}
};

/*sr1 sharpness reg*/
struct am_regs_s sr1reg_sd_scale = {
	109,
	{
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_HVSIZE, 0xffffffff, 0x02d00240},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_HVBLANK_NUM, 0xffffffff, 0x00001e58},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_GAUSSIAN_MODE, 0xffffffff, 0x00000010},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PKOSHT_VSLUMA_LUT_L, 0xffffffff, 0x56667ac8},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PKOSHT_VSLUMA_LUT_H, 0xffffffff, 0x00000004},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2CIRHPGAIN_TH_RATE,
		0xffffffff, 0x14323218},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2CIRHPGAIN_LIMIT,
		0xffffffff, 0x50845e00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2CIRBPGAIN_TH_RATE,
		0xffffffff, 0x14323218},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2CIRBPGAIN_LIMIT,
		0xffffffff, 0x508d5000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2DRTHPGAIN_TH_RATE,
		0xffffffff, 0x14323218},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2DRTHPGAIN_LIMIT,
		0xffffffff, 0x3d3d1f00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2DRTBPGAIN_TH_RATE,
		0xffffffff, 0x14323218},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2DRTBPGAIN_LIMIT,
		0xffffffff, 0x38390c00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CIRFB_LPF_MODE, 0xffffffff, 0x22202220},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_DRTFB_LPF_MODE, 0xffffffff, 0x22202220},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CIRFB_HP_CORING, 0xffffffff, 0x00020202},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CIRFB_BP_CORING, 0xffffffff, 0x00020202},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_DRTFB_HP_CORING, 0xffffffff, 0x00020202},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_DRTFB_BP_CORING, 0xffffffff, 0x00020202},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CIRFB_BLEND_GAIN, 0xffffffff, 0x38402840},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALPY_SSD_GAIN_OFST,
		0xffffffff, 0x0000103e},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0Y_ERR2CURV_TH_RATE,
		0xffffffff, 0x0a195040},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0Y_ERR2CURV_LIMIT,
		0xffffffff, 0x3f003f00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0C_ERR2CURV_TH_RATE,
		0xffffffff, 0x0a195040},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0C_ERR2CURV_LIMIT,
		0xffffffff, 0x3f003f00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0_MIN_MAX, 0xffffffff, 0x003f003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP1_MIERR_CORING,
		0xffffffff, 0x00000003},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP1_ERR2CURV_TH_RATE,
		0xffffffff, 0x00180014},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP1_ERR2CURV_LIMIT,
		0xffffffff, 0x00103f00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP1_MIN_MAX, 0xffffffff, 0x003f003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_ALP2_MIERR_CORING,
		0xffffffff, 0x00010001},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_ALP2_ERR2CURV_TH_RATE,
		0xffffffff, 0x0018000a},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_ALP2_ERR2CURV_LIMIT,
		0xffffffff, 0x00402000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_ALP2_MIN_MAX, 0xffffffff, 0x0000003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_FINALGAIN_HP_BP,
		0xffffffff, 0x00001414},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_OS_HORZ_CORE_GAIN,
		0xffffffff, 0x08140214},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_OS_VERT_CORE_GAIN,
		0xffffffff, 0x08140214},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_OS_ADPT_MISC,
		0xffffffff, 0x2806c814},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_OS_STATIC, 0xffffffff, 0x2203f03f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_NR_ENABLE, 0xffffffff, 0x00000002},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_DRT_SAD_MISC, 0xffffffff, 0x12120018},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_TI_DNLP_BLEND, 0xffffffff, 0x00000407},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_TI_DIR_CORE_ALPHA, 0xffffffff, 0x0a00003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_CTI_DIR_ALPHA, 0xffffffff, 0x0400003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_LTI_CTI_DF_GAIN, 0xffffffff, 0x0c0c0c0c},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_LTI_CTI_DIR_AC_DBG, 0xffffffff, 0x56ee0000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_FLT_CLP_DC, 0xffffffff, 0x15555300},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_BST_GAIN, 0xffffffff, 0x050a0a00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_BST_CORE, 0xffffffff, 0x03030303},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_CON_2_GAIN_0, 0xffffffff, 0x24193c05},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_CON_2_GAIN_1, 0xffffffff, 0x4b055014},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_OS_MARGIN, 0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_FLT_CLP_DC, 0xffffffff, 0x10152100},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_BST_GAIN, 0xffffffff, 0x06060600},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_BST_CORE, 0xffffffff, 0x03030303},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_CON_2_GAIN_0, 0xffffffff, 0x24193c05},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_CON_2_GAIN_1, 0xffffffff, 0x66635e24},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_OS_MARGIN, 0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_FLT_CON_CLP, 0xffffffff, 0x00006a94},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_BST_GAIN, 0xffffffff, 0x00202020},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_BST_CORE, 0xffffffff, 0x00050503},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_CON_2_GAIN_0, 0xffffffff, 0x193c0560},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_CON_2_GAIN_1, 0xffffffff, 0x5f501400},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_FLT_CON_CLP, 0xffffffff, 0x00006a94},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_BST_GAIN, 0xffffffff, 0x00101010},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_BST_CORE, 0xffffffff, 0x00050503},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_CON_2_GAIN_0, 0xffffffff, 0x193c0560},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_CON_2_GAIN_1, 0xffffffff, 0x5f501400},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_3DLIMIT, 0xffffffff, 0x03c0021c},
	/*{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CTRL, 0xffffffff, 0x0018103c},*/
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_YBIC_HCOEF0,
		0xffffffff, 0x00004000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_YBIC_HCOEF1,
		0xffffffff, 0xfc2424fc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CBIC_HCOEF0,
		0xffffffff, 0x00004000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CBIC_HCOEF1,
		0xffffffff, 0xfc2424fc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_YBIC_VCOEF0,
		0xffffffff, 0x00004000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_YBIC_VCOEF1,
		0xffffffff, 0xfc2424fc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CBIC_VCOEF0,
		0xffffffff, 0x00004000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CBIC_VCOEF1,
		0xffffffff, 0xfc2424fc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_MISC, 0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_SAD_CTRL, 0xffffffff, 0x060606ff},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_PK_CTRL0, 0xffffffff, 0x00000ffc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_PK_CTRL1, 0xffffffff, 0x112020cc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DEJ_CTRL, 0xffffffff, 0x0000000f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DEJ_ALPHA, 0xffffffff, 0x0f0f4646},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_EN, 0xffffffff, 0x00000037},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_ALPHA_0,
		0xffffffff, 0x0405050c},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_ALPHA_1,
		0xffffffff, 0x01040708},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_ALPHA_2,
		0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_ALPHA_OFST,
		0xffffffff, 0x000e000e},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_CTRL,
		0xffffffff, 0x1392281c},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_LUMA2PKGAIN_0TO3,
		0xffffffff, 0xffffc81e},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_LUMA2PKGAIN_4TO6,
		0xffffffff, 0x001832ff},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_LUMA2PKOS_0TO3,
		0xffffffff, 0xffffc81e},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_LUMA2PKOS_4TO6,
		0xffffffff, 0x001832ff},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_GAINVS_MADSAD,
		0xffffffff, 0x00000048},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_GAINVS_VR2MAX,
		0xffffffff, 0xffffec20},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_PARAM0,
		0xffffffff, 0x000a2010},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_THETA,
		0xffffffff, 0xfec96420},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SATPRT_CTRL, 0xffffffff, 0x00054006},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SATPRT_DIVM, 0xffffffff, 0x00808080},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SATPRT_LMT_RGB,
		0xffffffff, 0x3c0f03c0},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_CTRL, 0xffffffff, 0x06e222fa},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_YC_THRD,
		0xffffffff, 0x97659765},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_RANDLUT,
		0xffffffff, 0x00249249},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_PXI_THRD,
		0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_SEED_Y, 0xffffffff, 0x60a52f20},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_SEED_U, 0xffffffff, 0x60a52f27},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_SEED_V, 0xffffffff, 0x60a52f22},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PKGAIN_VSLUMA_LUT_L,
		0xffffffff, 0x56667ac8},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PKGAIN_VSLUMA_LUT_H,
		0xffffffff, 0x00000004},
	{0}
	}
};

/*sr1 sharpness reg*/
struct am_regs_s sr1reg_hd_scale = {
	109,
	{
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_HVSIZE, 0xffffffff, 0x02d00240},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_HVBLANK_NUM, 0xffffffff, 0x00001e58},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_GAUSSIAN_MODE, 0xffffffff, 0x00000010},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PKOSHT_VSLUMA_LUT_L, 0xffffffff, 0x56667ac8},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PKOSHT_VSLUMA_LUT_H, 0xffffffff, 0x00000004},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2CIRHPGAIN_TH_RATE,
		0xffffffff, 0x14323218},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2CIRHPGAIN_LIMIT,
		0xffffffff, 0x50775e00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2CIRBPGAIN_TH_RATE,
		0xffffffff, 0x14323218},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2CIRBPGAIN_LIMIT,
		0xffffffff, 0x50775000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2DRTHPGAIN_TH_RATE,
		0xffffffff, 0x14323218},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2DRTHPGAIN_LIMIT,
		0xffffffff, 0x3d3d1f00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2DRTBPGAIN_TH_RATE,
		0xffffffff, 0x14323218},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2DRTBPGAIN_LIMIT,
		0xffffffff, 0x38390c00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CIRFB_LPF_MODE, 0xffffffff, 0x22202220},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_DRTFB_LPF_MODE, 0xffffffff, 0x22202220},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CIRFB_HP_CORING, 0xffffffff, 0x00020202},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CIRFB_BP_CORING, 0xffffffff, 0x00020202},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_DRTFB_HP_CORING, 0xffffffff, 0x00020202},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_DRTFB_BP_CORING, 0xffffffff, 0x00020202},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CIRFB_BLEND_GAIN, 0xffffffff, 0x38402830},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALPY_SSD_GAIN_OFST,
		0xffffffff, 0x0000103e},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0Y_ERR2CURV_TH_RATE,
		0xffffffff, 0x0a195040},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0Y_ERR2CURV_LIMIT,
		0xffffffff, 0x3f003f00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0C_ERR2CURV_TH_RATE,
		0xffffffff, 0x0a195040},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0C_ERR2CURV_LIMIT,
		0xffffffff, 0x3f003f00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0_MIN_MAX, 0xffffffff, 0x003f003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP1_MIERR_CORING, 0xffffffff, 0x00000003},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP1_ERR2CURV_TH_RATE,
		0xffffffff, 0x00180014},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP1_ERR2CURV_LIMIT,
		0xffffffff, 0x00103f00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP1_MIN_MAX, 0xffffffff, 0x003f003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_ALP2_MIERR_CORING,
		0xffffffff, 0x00010001},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_ALP2_ERR2CURV_TH_RATE,
		0xffffffff, 0x0018000a},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_ALP2_ERR2CURV_LIMIT,
		0xffffffff, 0x00402000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_ALP2_MIN_MAX, 0xffffffff, 0x0000003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_FINALGAIN_HP_BP, 0xffffffff,
		0x00001410},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_OS_HORZ_CORE_GAIN, 0xffffffff,
		0x08140214},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_OS_VERT_CORE_GAIN, 0xffffffff,
		0x08140214},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_OS_ADPT_MISC, 0xffffffff, 0x2806c814},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_OS_STATIC, 0xffffffff, 0x2203f03f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_NR_ENABLE, 0xffffffff, 0x00000002},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_DRT_SAD_MISC, 0xffffffff, 0x10100018},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_TI_DNLP_BLEND, 0xffffffff, 0x00000407},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_TI_DIR_CORE_ALPHA, 0xffffffff, 0x0a00003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_CTI_DIR_ALPHA, 0xffffffff, 0x0400003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_LTI_CTI_DF_GAIN, 0xffffffff, 0x0c0c0c0c},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_LTI_CTI_DIR_AC_DBG, 0xffffffff, 0x56ee0000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_FLT_CLP_DC, 0xffffffff, 0x15555300},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_BST_GAIN, 0xffffffff, 0x050a0a00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_BST_CORE, 0xffffffff, 0x03030303},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_CON_2_GAIN_0, 0xffffffff, 0x24193c05},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_CON_2_GAIN_1, 0xffffffff, 0x4b055014},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_OS_MARGIN, 0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_FLT_CLP_DC, 0xffffffff, 0x10152100},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_BST_GAIN, 0xffffffff, 0x06060600},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_BST_CORE, 0xffffffff, 0x03030303},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_CON_2_GAIN_0, 0xffffffff, 0x24193c05},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_CON_2_GAIN_1, 0xffffffff, 0x66635e24},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_OS_MARGIN, 0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_FLT_CON_CLP, 0xffffffff, 0x00006a94},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_BST_GAIN, 0xffffffff, 0x00202020},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_BST_CORE, 0xffffffff, 0x00050503},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_CON_2_GAIN_0, 0xffffffff, 0x193c0560},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_CON_2_GAIN_1, 0xffffffff, 0x5f501400},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_FLT_CON_CLP, 0xffffffff, 0x00006a94},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_BST_GAIN, 0xffffffff, 0x00101010},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_BST_CORE, 0xffffffff, 0x00050503},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_CON_2_GAIN_0, 0xffffffff, 0x193c0560},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_CON_2_GAIN_1, 0xffffffff, 0x5f501400},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_3DLIMIT, 0xffffffff, 0x03c0021c},
	/*{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CTRL, 0xffffffff, 0x0018103c},*/
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_YBIC_HCOEF0,
		0xffffffff, 0x00004000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_YBIC_HCOEF1,
		0xffffffff, 0xfc2424fc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CBIC_HCOEF0,
		0xffffffff, 0x00004000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CBIC_HCOEF1,
		0xffffffff, 0xfc2424fc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_YBIC_VCOEF0,
		0xffffffff, 0x00004000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_YBIC_VCOEF1,
		0xffffffff, 0xfc2424fc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CBIC_VCOEF0,
		0xffffffff, 0x00004000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CBIC_VCOEF1,
		0xffffffff, 0xfc2424fc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_MISC, 0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_SAD_CTRL, 0xffffffff, 0x060606ff},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_PK_CTRL0, 0xffffffff, 0x00000ffc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_PK_CTRL1, 0xffffffff, 0x112020cc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DEJ_CTRL, 0xffffffff, 0x0000000f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DEJ_ALPHA, 0xffffffff, 0x0f0f4646},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_EN, 0xffffffff, 0x00000037},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_ALPHA_0,
		0xffffffff, 0x0405050c},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_ALPHA_1,
		0xffffffff, 0x01040708},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_ALPHA_2,
		0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_ALPHA_OFST,
		0xffffffff, 0x000e000e},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_CTRL, 0xffffffff, 0x1392281c},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_LUMA2PKGAIN_0TO3,
		0xffffffff, 0xffffc81e},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_LUMA2PKGAIN_4TO6,
		0xffffffff, 0x001832ff},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_LUMA2PKOS_0TO3,
		0xffffffff, 0xffffc81e},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_LUMA2PKOS_4TO6,
		0xffffffff, 0x001832ff},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_GAINVS_MADSAD,
		0xffffffff, 0x00000048},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_GAINVS_VR2MAX,
		0xffffffff, 0xffffec20},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_PARAM0,
		0xffffffff, 0x000a2010},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_THETA,
		0xffffffff, 0xfec96420},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SATPRT_CTRL, 0xffffffff, 0x00054006},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SATPRT_DIVM, 0xffffffff, 0x00808080},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SATPRT_LMT_RGB, 0xffffffff, 0x3c0f03c0},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_CTRL, 0xffffffff, 0x06e222fa},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_YC_THRD, 0xffffffff, 0x97659765},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_RANDLUT, 0xffffffff, 0x00249249},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_PXI_THRD, 0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_SEED_Y, 0xffffffff, 0x60a52f20},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_SEED_U, 0xffffffff, 0x60a52f27},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_SEED_V, 0xffffffff, 0x60a52f22},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PKGAIN_VSLUMA_LUT_L,
		0xffffffff, 0x56667ac8},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PKGAIN_VSLUMA_LUT_H,
		0xffffffff, 0x00000004},
	{0}
	}
};

/*sr1 sharpness reg*/
struct am_regs_s sr1reg_cvbs = {
	109,
	{
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_HVSIZE, 0xffffffff, 0x02d00240},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_HVBLANK_NUM, 0xffffffff, 0x00001e58},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_GAUSSIAN_MODE, 0xffffffff, 0x00000010},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PKOSHT_VSLUMA_LUT_L, 0xffffffff, 0x56667ac8},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PKOSHT_VSLUMA_LUT_H, 0xffffffff, 0x00000004},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2CIRHPGAIN_TH_RATE,
		0xffffffff, 0x14323218},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2CIRHPGAIN_LIMIT,
		0xffffffff, 0x50845e00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2CIRBPGAIN_TH_RATE,
		0xffffffff, 0x14323218},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2CIRBPGAIN_LIMIT,
		0xffffffff, 0x508d5000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2DRTHPGAIN_TH_RATE,
		0xffffffff, 0x14323218},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2DRTHPGAIN_LIMIT,
		0xffffffff, 0x3d3d1f00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2DRTBPGAIN_TH_RATE,
		0xffffffff, 0x14323218},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2DRTBPGAIN_LIMIT,
		0xffffffff, 0x38390c00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CIRFB_LPF_MODE, 0xffffffff, 0x22202220},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_DRTFB_LPF_MODE, 0xffffffff, 0x22202220},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CIRFB_HP_CORING, 0xffffffff, 0x00020202},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CIRFB_BP_CORING, 0xffffffff, 0x00020202},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_DRTFB_HP_CORING, 0xffffffff, 0x00020202},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_DRTFB_BP_CORING, 0xffffffff, 0x00020202},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CIRFB_BLEND_GAIN, 0xffffffff, 0x38402840},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALPY_SSD_GAIN_OFST,
		0xffffffff, 0x0000103e},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0Y_ERR2CURV_TH_RATE,
		0xffffffff, 0x0a195040},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0Y_ERR2CURV_LIMIT,
		0xffffffff, 0x3f003f00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0C_ERR2CURV_TH_RATE,
		0xffffffff, 0x0a195040},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0C_ERR2CURV_LIMIT,
		0xffffffff, 0x3f003f00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0_MIN_MAX, 0xffffffff, 0x003f003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP1_MIERR_CORING,
		0xffffffff, 0x00000003},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP1_ERR2CURV_TH_RATE,
		0xffffffff, 0x00180014},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP1_ERR2CURV_LIMIT,
		0xffffffff, 0x00103f00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP1_MIN_MAX, 0xffffffff, 0x003f003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_ALP2_MIERR_CORING,
		0xffffffff, 0x00010001},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_ALP2_ERR2CURV_TH_RATE,
		0xffffffff, 0x0018000a},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_ALP2_ERR2CURV_LIMIT,
		0xffffffff, 0x00402000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_ALP2_MIN_MAX, 0xffffffff, 0x0000003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_FINALGAIN_HP_BP,
		0xffffffff, 0x00001414},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_OS_HORZ_CORE_GAIN,
		0xffffffff, 0x08140214},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_OS_VERT_CORE_GAIN,
		0xffffffff, 0x08140214},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_OS_ADPT_MISC,
		0xffffffff, 0x2806c814},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_OS_STATIC, 0xffffffff, 0x2203f03f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_NR_ENABLE, 0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_DRT_SAD_MISC, 0xffffffff, 0x12120018},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_TI_DNLP_BLEND, 0xffffffff, 0x00000407},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_TI_DIR_CORE_ALPHA, 0xffffffff, 0x0a00003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_CTI_DIR_ALPHA, 0xffffffff, 0x0400003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_LTI_CTI_DF_GAIN, 0xffffffff, 0x0c0c0c0c},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_LTI_CTI_DIR_AC_DBG, 0xffffffff, 0x56ee0000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_FLT_CLP_DC, 0xffffffff, 0x05555300},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_BST_GAIN, 0xffffffff, 0x050a0a00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_BST_CORE, 0xffffffff, 0x03030303},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_CON_2_GAIN_0, 0xffffffff, 0x24193c05},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_CON_2_GAIN_1, 0xffffffff, 0x4b055014},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_OS_MARGIN, 0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_FLT_CLP_DC, 0xffffffff, 0x00152100},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_BST_GAIN, 0xffffffff, 0x06060600},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_BST_CORE, 0xffffffff, 0x03030303},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_CON_2_GAIN_0, 0xffffffff, 0x24193c05},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_CON_2_GAIN_1, 0xffffffff, 0x66635e24},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_OS_MARGIN, 0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_FLT_CON_CLP, 0xffffffff, 0x00002a94},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_BST_GAIN, 0xffffffff, 0x00202020},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_BST_CORE, 0xffffffff, 0x00050503},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_CON_2_GAIN_0, 0xffffffff, 0x193c0560},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_CON_2_GAIN_1, 0xffffffff, 0x5f501400},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_FLT_CON_CLP, 0xffffffff, 0x00002a94},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_BST_GAIN, 0xffffffff, 0x00101010},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_BST_CORE, 0xffffffff, 0x00050503},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_CON_2_GAIN_0, 0xffffffff, 0x193c0560},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_CON_2_GAIN_1, 0xffffffff, 0x5f501400},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_3DLIMIT, 0xffffffff, 0x03c0021c},
	/*{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CTRL, 0xffffffff, 0x0018103c},*/
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_YBIC_HCOEF0,
		0xffffffff, 0x00004000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_YBIC_HCOEF1,
		0xffffffff, 0xfc2424fc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CBIC_HCOEF0,
		0xffffffff, 0x00004000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CBIC_HCOEF1,
		0xffffffff, 0xfc2424fc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_YBIC_VCOEF0,
		0xffffffff, 0x00004000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_YBIC_VCOEF1,
		0xffffffff, 0xfc2424fc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CBIC_VCOEF0,
		0xffffffff, 0x00004000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CBIC_VCOEF1,
		0xffffffff, 0xfc2424fc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_MISC, 0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_SAD_CTRL, 0xffffffff, 0x060606ff},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_PK_CTRL0, 0xffffffff, 0x00000ffc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_PK_CTRL1, 0xffffffff, 0x112020cc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DEJ_CTRL, 0xffffffff, 0x0000000f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DEJ_ALPHA, 0xffffffff, 0x0f0f4646},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_EN, 0xffffffff, 0x00000037},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_ALPHA_0,
		0xffffffff, 0x0405050c},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_ALPHA_1,
		0xffffffff, 0x01040708},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_ALPHA_2,
		0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_ALPHA_OFST,
		0xffffffff, 0x000e000e},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_CTRL,
		0xffffffff, 0x1392281c},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_LUMA2PKGAIN_0TO3,
		0xffffffff, 0xffffc81e},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_LUMA2PKGAIN_4TO6,
		0xffffffff, 0x001832ff},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_LUMA2PKOS_0TO3,
		0xffffffff, 0xffffc81e},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_LUMA2PKOS_4TO6,
		0xffffffff, 0x001832ff},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_GAINVS_MADSAD,
		0xffffffff, 0x00000048},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_GAINVS_VR2MAX,
		0xffffffff, 0xffffec20},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_PARAM0,
		0xffffffff, 0x000a2010},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_THETA,
		0xffffffff, 0xfec96420},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SATPRT_CTRL, 0xffffffff, 0x00054006},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SATPRT_DIVM, 0xffffffff, 0x00808080},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SATPRT_LMT_RGB,
		0xffffffff, 0x3c0f03c0},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_CTRL, 0xffffffff, 0x06e222fa},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_YC_THRD,
		0xffffffff, 0x97659765},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_RANDLUT,
		0xffffffff, 0x00249249},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_PXI_THRD,
		0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_SEED_Y, 0xffffffff, 0x60a52f20},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_SEED_U, 0xffffffff, 0x60a52f27},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_SEED_V, 0xffffffff, 0x60a52f22},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PKGAIN_VSLUMA_LUT_L,
		0xffffffff, 0x56667ac8},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PKGAIN_VSLUMA_LUT_H,
		0xffffffff, 0x00000004},
	{0}
	}
};

/*sr1 sharpness reg use for 1080p/720p output*/
struct am_regs_s sr1reg_hv_noscale = {
	109,
	{
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_HVSIZE, 0xffffffff, 0x02d00240},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_HVBLANK_NUM, 0xffffffff, 0x00001e58},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_GAUSSIAN_MODE, 0xffffffff, 0x00000010},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PKOSHT_VSLUMA_LUT_L, 0xffffffff, 0x56667ac8},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PKOSHT_VSLUMA_LUT_H, 0xffffffff, 0x00000004},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2CIRHPGAIN_TH_RATE,
		0xffffffff, 0x14323218},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2CIRHPGAIN_LIMIT,
		0xffffffff, 0x50845e00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2CIRBPGAIN_TH_RATE,
		0xffffffff, 0x14323218},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2CIRBPGAIN_LIMIT,
		0xffffffff, 0x508d5000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2DRTHPGAIN_TH_RATE,
		0xffffffff, 0x14323218},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2DRTHPGAIN_LIMIT,
		0xffffffff, 0x3d3d1f00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2DRTBPGAIN_TH_RATE,
		0xffffffff, 0x14323218},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CON_2DRTBPGAIN_LIMIT,
		0xffffffff, 0x38390c00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CIRFB_LPF_MODE, 0xffffffff, 0x22202220},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_DRTFB_LPF_MODE, 0xffffffff, 0x22202220},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CIRFB_HP_CORING, 0xffffffff, 0x00020202},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CIRFB_BP_CORING, 0xffffffff, 0x00020202},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_DRTFB_HP_CORING, 0xffffffff, 0x00020202},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_DRTFB_BP_CORING, 0xffffffff, 0x00020202},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_CIRFB_BLEND_GAIN, 0xffffffff, 0x38402840},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALPY_SSD_GAIN_OFST,
		0xffffffff, 0x0000103e},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0Y_ERR2CURV_TH_RATE,
		0xffffffff, 0x0a195040},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0Y_ERR2CURV_LIMIT,
		0xffffffff, 0x3f003f00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0C_ERR2CURV_TH_RATE,
		0xffffffff, 0x0a195040},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0C_ERR2CURV_LIMIT,
		0xffffffff, 0x3f003f00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP0_MIN_MAX, 0xffffffff, 0x003f003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP1_MIERR_CORING,
		0xffffffff, 0x00000003},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP1_ERR2CURV_TH_RATE,
		0xffffffff, 0x00180014},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP1_ERR2CURV_LIMIT,
		0xffffffff, 0x00103f00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_ALP1_MIN_MAX, 0xffffffff, 0x003f003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_ALP2_MIERR_CORING,
		0xffffffff, 0x00010001},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_ALP2_ERR2CURV_TH_RATE,
		0xffffffff, 0x0018000a},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_ALP2_ERR2CURV_LIMIT,
		0xffffffff, 0x00402000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_ALP2_MIN_MAX, 0xffffffff, 0x0000003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_FINALGAIN_HP_BP,
		0xffffffff, 0x00001414},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_OS_HORZ_CORE_GAIN,
		0xffffffff, 0x08140214},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_OS_VERT_CORE_GAIN,
		0xffffffff, 0x08140214},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_OS_ADPT_MISC,
		0xffffffff, 0x2806c814},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_OS_STATIC, 0xffffffff, 0x2203f03f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_NR_ENABLE, 0xffffffff, 0x00000002},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PK_DRT_SAD_MISC, 0xffffffff, 0x12120018},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_NR_TI_DNLP_BLEND, 0xffffffff, 0x00000407},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_TI_DIR_CORE_ALPHA, 0xffffffff, 0x0a00003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_CTI_DIR_ALPHA, 0xffffffff, 0x0400003f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_LTI_CTI_DF_GAIN, 0xffffffff, 0x0c0c0c0c},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_LTI_CTI_DIR_AC_DBG, 0xffffffff, 0x56ee0000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_FLT_CLP_DC, 0xffffffff, 0x10155300},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_BST_GAIN, 0xffffffff, 0x050a0a00},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_BST_CORE, 0xffffffff, 0x03030303},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_CON_2_GAIN_0, 0xffffffff, 0x24193c05},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_CON_2_GAIN_1, 0xffffffff, 0x4b055014},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HCTI_OS_MARGIN, 0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_FLT_CLP_DC, 0xffffffff, 0x10152100},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_BST_GAIN, 0xffffffff, 0x06060600},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_BST_CORE, 0xffffffff, 0x03030303},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_CON_2_GAIN_0, 0xffffffff, 0x24193c05},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_CON_2_GAIN_1, 0xffffffff, 0x66635e24},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_HLTI_OS_MARGIN, 0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_FLT_CON_CLP, 0xffffffff, 0x00004014},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_BST_GAIN, 0xffffffff, 0x000a0a0a},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_BST_CORE, 0xffffffff, 0x00050503},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_CON_2_GAIN_0, 0xffffffff, 0x193c0560},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VLTI_CON_2_GAIN_1, 0xffffffff, 0x5f501400},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_FLT_CON_CLP, 0xffffffff, 0x00004014},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_BST_GAIN, 0xffffffff, 0x000a0a0a},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_BST_CORE, 0xffffffff, 0x00050503},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_CON_2_GAIN_0, 0xffffffff, 0x193c0560},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_VCTI_CON_2_GAIN_1, 0xffffffff, 0x5f501400},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_3DLIMIT, 0xffffffff, 0x03c0021c},
	/*{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CTRL, 0xffffffff, 0x0018103c},*/
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_YBIC_HCOEF0,
		0xffffffff, 0x00004000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_YBIC_HCOEF1,
		0xffffffff, 0xfc2424fc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CBIC_HCOEF0,
		0xffffffff, 0x00004000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CBIC_HCOEF1,
		0xffffffff, 0xfc2424fc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_YBIC_VCOEF0,
		0xffffffff, 0x00004000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_YBIC_VCOEF1,
		0xffffffff, 0xfc2424fc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CBIC_VCOEF0,
		0xffffffff, 0x00004000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_CBIC_VCOEF1,
		0xffffffff, 0xfc2424fc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SHARP_SR2_MISC, 0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_SAD_CTRL, 0xffffffff, 0x060606ff},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_PK_CTRL0, 0xffffffff, 0x00000ffc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_PK_CTRL1, 0xffffffff, 0x112020cc},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DEJ_CTRL, 0xffffffff, 0x0000000f},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DEJ_ALPHA, 0xffffffff, 0x0f0f4646},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_EN, 0xffffffff, 0x00000037},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_ALPHA_0,
		0xffffffff, 0x0405050c},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_ALPHA_1,
		0xffffffff, 0x01040708},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_ALPHA_2,
		0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_ALPHA_OFST,
		0xffffffff, 0x000e000e},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_CTRL,
		0xffffffff, 0x1392281c},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_LUMA2PKGAIN_0TO3,
		0xffffffff, 0xffffc81e},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_LUMA2PKGAIN_4TO6,
		0xffffffff, 0x001832ff},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_LUMA2PKOS_0TO3,
		0xffffffff, 0xffffc81e},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_LUMA2PKOS_4TO6,
		0xffffffff, 0x001832ff},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_GAINVS_MADSAD,
		0xffffffff, 0x00000048},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_GAINVS_VR2MAX,
		0xffffffff, 0xffffec20},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DERING_PARAM0,
		0xffffffff, 0x000a2010},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SR3_DRTLPF_THETA,
		0xffffffff, 0xfec96420},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SATPRT_CTRL, 0xffffffff, 0x00054006},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SATPRT_DIVM, 0xffffffff, 0x00808080},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_SATPRT_LMT_RGB,
		0xffffffff, 0x3c0f03c0},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_CTRL, 0xffffffff, 0x06e222fa},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_YC_THRD,
		0xffffffff, 0x97659765},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_RANDLUT,
		0xffffffff, 0x00249249},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_PXI_THRD,
		0xffffffff, 0x00000000},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_SEED_Y, 0xffffffff, 0x60a52f20},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_SEED_U, 0xffffffff, 0x60a52f27},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_DB_FLT_SEED_V, 0xffffffff, 0x60a52f22},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PKGAIN_VSLUMA_LUT_L,
		0xffffffff, 0x56667ac8},
	{REG_TYPE_OFFSET_VCBUS, SRSHARP1_PKGAIN_VSLUMA_LUT_H,
		0xffffffff, 0x00000004},
	{0}
	}
};

struct dejaggy_regs_s {
	unsigned int    length; /* Length of total am_reg */
	struct am_reg_s am_reg[2];
};
#define DEJAGGY_LEVEL 4
/*0: weak,  1: middle,  2: strong, 3: from db*/
struct dejaggy_regs_s sr0_dej_setting[DEJAGGY_LEVEL] = {
	/* weak */
	{
		2,
		{
		{REG_TYPE_VCBUS, SRSHARP0_DEJ_CTRL, 0x00000001, 0x00000001},
		{REG_TYPE_VCBUS, SRSHARP0_DEJ_ALPHA, 0x000000ff, 0x00000046},
		}
	},
	/* middle */
	{
		2,
		{
		{REG_TYPE_VCBUS, SRSHARP0_DEJ_CTRL, 0x00000001, 0x00000001},
		{REG_TYPE_VCBUS, SRSHARP0_DEJ_ALPHA, 0x000000ff, 0x0000006c},
		}
	},
	/* strong */
	{
		2,
		{
		{REG_TYPE_VCBUS, SRSHARP0_DEJ_CTRL, 0x00000001, 0x00000001},
		{REG_TYPE_VCBUS, SRSHARP0_DEJ_ALPHA, 0x000000ff, 0x000000ff},
		}
	},
	/* db setting */
	{
		2,
		{
		{REG_TYPE_VCBUS, SRSHARP0_DEJ_CTRL, 0x00000001, 0x00000001},
		{REG_TYPE_VCBUS, SRSHARP0_DEJ_ALPHA, 0x000000ff, 0x00000046},
		}
	},
};
#endif

