/*
 * Create proc entry so we can output the debug using cat
 *
 * Use the macro LDIM_PROC_ENTRY to create the proc functions
 * for each entry.
 *
 */

#define LDIM_PROC_ENTRY(T, write_func)  \
	static int ldim_## T ##_proc_show(struct seq_file *m, void *v)\
	{ \
		ldim_proc_get_##T(m, v); \
		return 0; \
	} \
	\
	static int ldim_ ## T ## _proc_open(struct inode *inode, struct file *file)\
	{ \
		return single_open(file, ldim_## T ##_proc_show, PDE_DATA(inode)); \
	} \
	\
	static const struct file_operations ldim_## T ##_proc_fops = { \
		.owner          = THIS_MODULE, \
		.open           = ldim_## T ##_proc_open, \
		.write          = write_func, \
		.read           = seq_read, \
		.llseek         = seq_lseek, \
		.release        = single_release, \
	}; \
	\
	static const char T ## _proc_name[] = #T

#define SET_COLOUR_NEW(colour_debug, r, gb) {if (colour_debug)\
		len += snprintf(buf + len,\
		PAGE_SIZE - (len+1), "\033[0;30m\033[48;2;%d;%d;%dm", r, gb, gb);\
		}

#define RESET_COLOUR_NEW(colour_debug)    {if (colour_debug) len += snprintf(buf + len,\
		PAGE_SIZE - (len+1), "\033[0m");\
		}

#define SET_COLOUR(r, gb) {if (ldim_drv->colour_debug)\
		len += snprintf(buf + len,\
		PAGE_SIZE - (len+1), "\033[0;30m\033[48;2;%d;%d;%dm", r, gb, gb);\
		}

#define RESET_COLOUR()    {if (ldim_drv->colour_debug) len += snprintf(buf + len,\
		PAGE_SIZE - (len+1), "\033[0m");\
		}

extern int print_box_header(char *buf, int len, int buff_size, int col, int box_size_before, int box_size_after);
extern int print_box_line(char *buf, int len, int buff_size, int index, int row, int col, int box_size);
extern void ldim_dump_histgram_matrix(struct aml_ldim_driver_s *ldim_drv, bool percentage, struct seq_file *sfile);
extern int ldim_proc_get_hist_matrix(struct seq_file *m, void *v);
extern int ldim_proc_get_hist_percent(struct seq_file *m, void *v);
extern int ldim_proc_get_maxrgb(struct seq_file *m, void *v);
extern int ldim_proc_get_boost_info(struct seq_file *m, void *v);
extern int ldim_proc_init(void);
